﻿USE sofia;
DROP TABLE IF EXISTS sofia.mfxe_vpl;
CREATE TABLE mfxe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mfxe_vpl WRITE;
INSERT INTO mfxe_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ዳዉተ ናአ አፍራመ ናአ ማቄዝ የሱስ ክርስቶሳ የለትꬅ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","አፍራመ እሳቃ የሌዛ፤ እሳቃ ያይቆባ የሌዛ፤ ያይቆባ ይሁዳራኔ ኤ እሽታ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ይሁዳ ትእማርፕ ፓረሳኔ ዛራ የሌዛ፤ ፓረሳ አስሮመ የሌዛ፤ አስሮማ ራመ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ራመ አምናዳባ የሌዛ፤ አምናዳባ ናአሶና የሌዛ፤ ናአሶና ሳልሞነ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሳልሞና ራአብፐ ቦኤዛ የሌዛ፤ ቦኤዛ ኡርትፐ ኢዮቤደ የሌዛ፤ ኢዮቤደ ኢሳየ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ኢሳየ ካታ ዳውተ የሌዛ፤ ካት ዳውተ ኦርዮ ማቻትፐ ሶሎሞነ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሶሎሞነ ሮብአማ የሌዛ፤ ሮብአመ አብያ የሌዛ፤ አብየ ኣሳፈ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ኣሳፈ ኢዮሳፈጸ የሌዛ፤ ኢዮሳፍጸ ኢዮራመ የሌዛ፤ ኢዮራመ ኦዛኔ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ኦዛኔ ኢዮአታመ የሌዛ፤ ኢዮአታመ አካዛ የሌዛ፤ አካዛ ህዝቃሳ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ህዝቃሳ ምናሰ የሌዛ፤ ምናሰ አሞጻ የሌዛ፤ አሞጻ ኢዮሳሳ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ኢዮሳሳ ኢኮናናራኔ ኤ እሽታ የሌዝ ያ ላይꬅተ እስሬለ አሳይ ድእንቲ ባብሎነ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባብሎነ ቢታ እስሬለ አሳይ ድእንቲ Ꮊንጌዛይፕ ጉዬ ኢኮናና ሳላትያለ የሌዛ። ሳላትያለ ዘሩባበላ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዘሩባበላ አብድዩ የሌዛ፤ አብድዩ ኤልያቀመ የሌዛ፤ ኤልያቀመ ኣዞራ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ኣዞራ ሳዶቀ የሌዛ፤ ሳዶቀ አክመ የሌዛ፤ አክመ ኤልዩዳ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤልዩዳ አላዛራ የሌዛ፤ አላዛረ ማታነ የሌዛ፤ ማታነ ያይቆባ የሌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያይቆባ ዮሴፋ የሌዛ፤ ዮሴፋ ክርስቶሳ ግዝ የሱሳና የሌዝ ማይራሚ አዝና። ");
INSERT INTO mfxe_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ይኬ፥ የለትꬅ አፍራመፕ ዳዉተ ሄሎዳይስ ታጶ ኦይደ። ዳዉተፕ Ꮊንጊ ባብሎነ ድአ ሄሎዳይስ ታጶ ኦይደ። ባብሎነ ድአይፕ Ꮊንጊ ክርስቶሳ ሄሎዳይስ ታጶ ኦይዲ የለትꬅ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","የሱስ ክርስቶሳ የልንቶ ታርካይ Ꮊይፕ ካልዛ። ኤ እንዳት ማይራማ ዮሴፋስ ኦይጭንቲ የዛር ዮሴፋር ዎላ አቀካዛር ጌሻ አያናፕ ዎደጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ዮሴፋ ጌሻ አስ ማቄዝ ግሾ እዞ አሲ ኦዶዳይ ጋርክ ኮየካዛይ ግሾስ ጌማር አሾዳይስ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ኤ የ ቆፋል የዝን ጾሳ ኪታንቻይ አቡካር ኤስ በንቲ፥ «ዳዉተ ናአ፥ ዮሴፋ፥ ማይራማ ዎደጼዛይ ጌሻ አያናፕ ማቄዝ ግሾ እዞ ኤኮዳይስ ያሽትፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","እዛ ꬍራꬅ ናአ የሎዳ፥ ኤ ዎይታ ኡ ናጋራይፕ አሽዛይ ግሾ ኤ ሱንꬃ ነ የሱሳ ግ ጼጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ጎዳይ ናባይ ዶናር፥ ");
INSERT INTO mfxe_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ይኬ ዉድርታ ዎደጾዳ፤ ꬍራꬅ ናአካ የሎዳ፤ ኤ ሱንꬃይ አማኑኤላ ግንትንቶዳ» ጌዛይ ፖልንቶዳይ ጋርክ Ꮊ ኡባይ ሀኔዛ። አማኑኤላ ጉሳይስ ብርሽꬃይ «ጾሳይ ኑር የዛ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሴፋ ገንታፕ ባርኪ ጎዳይ ኪታንቻይ ኪቴዛይ ጋርክ ማይራሞ ፋ ካራ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ዝን ፋ ባይራ ናአ የሎድ ጋꬆ እዞ ቦቼካያ፤ የልንቴዝ ናአካ የሱሳ ጊ ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ካት ሄሮዶሳ ዎደ የሱሳ ይሁዳ ቢታ ቤተለመ ካታማ የልንቴዛይፕ ጉየ ጾልንቶ ፍላግዝታይ አዋ ከስ ባጋፕ የሩሳላመ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«የልንቴዝ አይሁድታይ ካታይ አባ የኔ? ኑ አዋ ከስ ባጋር ከዜዝ ጾልንቶ ብኢ ኤዝስ ጎይኖዳይስ የኤዛ» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ካት ሄሮዶሳ የያ ስኢ ዳጋሜዛ። የሩሳላመ የዝ አስ ኡባይካ ዳጋሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ሄሮዶሳ ቄሰ ሀላቅታኔ ህገ አስታማርታ ፋኮ ጼጊ «ክርስቶሳ አባ የልንቶደሻ?» ዬጊ ኡንታን ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ኡንትካ፥ «ይሁዳ ቤተለመ ናባይ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","« ‹ይሁዳ የዝ ቤተለመ፥ ይሁዳ የዝ ጋደ አቅስዝታይፕ፥ ነ አባራካ ካዉዦያ። ታ ዎያ እስሬለ ሃርዛይ፥ ኔፕ ከዞዳ ኤካ ታ ዎያ እስሬለ ሄንግዛ ማቃዳ› ግ ጻፌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","የይፕ ጉየ፥ ሄሮዶሳ አዋ ከስ ባጋፕ የኤዝ አስታ ጌማር ጼጊ፥ ጾልንቶ ኡ በኤዝ ላይꬃ ኡንታፕ ሎእꬅ ኦይጪ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ኤ ኡንታን ቤተለመ ዳክታር፥ «Ꮊንጊ የልንቴዝ ናአ ሚንꬂ ኮዦይታ፤ ኤዛ ይ ደንግኮ ታካ Ꮊንጊ ኤዝስ ጎይኖድ ጋርክ ማቅታር ታስ ኦዶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ኡንትካ ካታይ ሄሮዶሳ ኦዴዛና ስኢ ቅቴዛ። ኡ አዋ ከስ ባጋር በኤዝ ጾልንታይ ኡንታን ካልꬂታር ናአይ የዛ አቃይድ ኤቆድ ሄሎዳይስ ካንጊ ሄልꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ኡ የ ጾልንታ ብኢ አቆፕ ኣꬎ ኡፋይስ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ካራ ገሊ ናአይ ፋ እንዳት ማይራምር የዛና በኤዛ። ኤስ ጹጉኒ ጎይኔዛ። ፋ ሳጽና ዶዪ ዎርቀራ፥ እጻነራኔ ካርበራ ኤስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ኡ ሄሮዶሳኮ ጉየ ማቃማይ ጋርክ ጾሳይ አቡካር ኡንትስ ኦድን፥ ሀራ ኦገር ፋ ቢታ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","አዋ ከስ ባጋፕ የኤዝ አሳይ ቅቴዛይፕ ጉየ፥ ጎዳይ ኪታንቻይ ዮሴፋስ አቡካር በንቲ፥ «ሄሮዶሳ ናአና ዎꬎዳይስ ኮይዝግሾስ ደንዶባ፤ ኤልሲ ናአይራ ናአይ እንዳትራ ኤኪ ግብጸ ቢታ Ꮊንጎባ። ነ ማቃድ ጋላሳ ኔስ ኦዶድ ጋꬆ ኤዛይድ ጋምኦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","የይ ግሾስ፥ ዮሴፋ ቃማር ደንዲ፥ ናአይራ ናአይ እንዳትራ ኤኪ ግብጸ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ናበ ዶናር ጾሲ፥ «ታኒ፥ ታ ናአ፥ ግብጸ ቢታፕ ጼጌዛ» ግንትንቴዝ ቃላይ ፖልንቶድ ጋርክ ሄሮዶሳ Ꮊይቆድ ሄሎዳይስ ኤ ኤዛይድ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","የይፕ ጉየ፥ አዋ ከስ ባጋፕ የኤዝ አሳይ ኤዛ ዶሼዛና ኤሪ ኢታ ይሎቴዛ። ኤ ቲና ኡንታፕ ስኤዛይ ጋርክ ቤተለመኔ የ ሄራ የዝ ናምኢ ላይꬅ ኩመዝታኔ ናምኢ ላይꬃፕ ሱለ የዝ ꬍራꬅ ናእታ ኡባ ፋ ዎታዳርታ ዳኪ ዎꬍሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","ናበ እርማሳ ዶናር፥ «ዬፎኔ ዘላልሲ፥ ራማ ስንቴዛ። እራሄላ ፋ ናእታይስ ዬክዛ፤ ኡ Ꮊይቄዝ ግሾስ ምንጎዳይስ ዳንዳኤካያ» ግ ኦዴዛይ ፖልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮዶሳ Ꮊይቄዛይፕ ጉየ ጎዳ ኪታንቻይ ዮሴፋስ ግብጸ አቡካር በንቲ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ናአ ዎꬎዳይስ ኮይዝታይ Ꮊይቄዝ ግሾስ ደንዲ ናአይራ ናአይ እንዳትራ ኤኪ እስሬለ ቢታ ማቆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ዮሴፋ ደንዲ ናአይራ ናአይ እንዳትራ ኤኪ እስሬለ ቢታ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ዝን አርክሎሳ ይሁዳል ፋ አዳይ ሄሮዶሳ አቆ ካዉቴዛና ስኢ የ አቃ Ꮊማዳይስ ያሽቴዛ። ጾሳይ አቡካር ኤዛ ቤዝን ጋልላ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ናብታይ ዶናር፥ «ናዝረተ አስ ግንትንቶዳ» ግ ኦድንቴዛይ ፖልንቶድ ጋርክ ናዝረተ ካታማ Ꮊንጊ ኤዛይድ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","የ ዎደ ጻማቅዛ ዋንሳ፥ «ጾስ ካተትꬂ ኡኬዝ ግሾስ ይ ናጋራይፕ ማቆይታ» ዬጊ ሳባክታር ይሁዳ ሊዦ ጋꬋር የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ናበ ኢሳያሳ ኦዴዛይ ዋንሳ ባጋ፥ «ሊዦ ጋꬋ፥ ፐቲ አꬋይ ፋ ቃላ ꬎቅ ኡዲ፥ ‹ጎዳይ ጎሳ ሎእꬆይታ። ኤ ኦጋ ፕትꬃካ ሉልሶይታ› ጌዛ» ዬግንቴዛይ ኤሲ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ዋንሳ ግማለ እክሰፕ ዳድንቴዝ አፍላ ማእዛ። ፋ ጼሳይዳካ ዳፈ ዳንጭዛ። ኤ ሚዝ ካꬃይካ ቦለራኔ ደገራ ኤሳራ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","አሳይ የ ዎደ የሩሳላመ ካታማፐ፥ ይሁዳ ቢታ ኡባይፐራኔ ዮርዳኖሳ ቦርካ ሄራፐ ኤኮ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ፋ ናጋራ ቡጽታር ዮርዳኖሳ ቦርካ ኤ ኩሸ ጻማቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ኤዝካ፥ ጋመ ፈርሳውታይፐኔ ሳዱቃውታይፕ ጋምታይ ጻማቅንቶዳይስ ፋኮ ይእዝታ ብኢ፥ ኡንትኮ፥ «Ꮊ ሾሽ ናኡንꬆ፥ የኦድ ጾስ ካቻይፕ ቆስንቶዳይ ጋርክ ይንታን ዞሬዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ይኬ፥ ይንቲ፥ ይ ናጋራይፕ ማቄዛና ቤዝዛ ኣፈ ኣፎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ይ፥ ይ ዎዝናራ፥ ‹አፍራመ፥ ኑ አደ ግ ይ ቆፕዛይ ጋርክ› ይንትስ ማቅፐ። ሎእꬂ ስኦይታ! ጾሳይ Ꮊ ሹችታይፕ አፍራመስ ናአ ከሶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ጋንደ ምንጻይ ጻጳይድ ጊጊ በቴዛ፤ ሎኦ ኣፈ ኣፎዋ ምꬂ ኡባይ ጋችንቲ ታማ ጋንጨ ዎꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«ይ፥ ይ ናጋራይፕ ማቄዛና ኤርሶዳይስ ታ ይንታን ሃꬃር ጻማቅዛ። ዝን ታፕ ጉየር ይእዛይ ይንታን ጌሻ አያናራኔ ታማር ጻማቆዳ። ኤ ታፕ ሎእꬂ ሚንግዛ፤ ታ ሀራ አቶዝን ኤ ጫማ ቶኮዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ካꬃ ጌሽዝ ፕꬄ ኤ ኩሻይድ የዛ። ካꬃ ሎእꬂ ጌሽዛ፤ ግስታ ፋ ሻላይድ ኦሎዳ፥ ዝን ቡና ቶኦዋ ታማይድ ጹጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","የ ዎደ የሱሳ ዋንሳ ኩሻይድ ጻማቅንቶዳይስ ጋልላፐ ዮርዳኖሳ ቦርካ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ዝን ዋንሳ ኤዛ ካዮዳይስ ኮዪ፥ «ታ ነ ኩሻይድ ጻማቅንቶዳይስ ቤዞዳር ነ ታኮ ይእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","የሱሳ ማሂ፥ «ጾሲ ኑፐ ኮዥዝ ባዝ ኡባ ኑ ፖሎዳይስ ቤዝዛይ ግሾስ Ꮊት ታስ ኤሮ ጎባ» ዬጌዛ። ዋንሳ ኤዝስ ኤሮ ግ ኤዛ ጻማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","የሱሳ ጻማቅንቴዛን ጋርክ ቦርካፕ ከዜዝ። እዝራካ ሳሎ ዶይንትን ጾሳ አያናይ ሆለ ጋርክ ይኢ ኤዛል ዎꬎዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","የ ዎደ «ታ ቃꬍዛ ናአይ፥ ታ ኡፋይትዛ ናአይ Ꮊያ» ዬግዝ ቃላ ሳሎፕ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","የይፕ ጉየ፥ ዳቡሎሳ የሱሳና ፋጮድ ጋርክ ጌሻ አያናይ የሱሳና ሊዦ ጋꬋ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ኤዛይድ ኦይታም ቃማኔ ኦይታም ጋላስ ጾሜዛይፕ ጉየ ናይንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ፓጭዛይ የሱሳኮ ይኢ «ነ ጾስ ናአዛኮ፥ አን Ꮊ ሹቹንꬃን ቦራ ማቆዳይ ጋርክ አዛዞባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","የሱሳ ማሂ ኤኮ፥ « ‹አሲ ጾስ ዶናፕ ከዝዝ ቃላ ኡባይር የዝዛፕ አትን ቦራ ኣዳር የዞያ› ዬግንቲ ጾሳ ቃላይድ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ኤዛይፕ ማቅካ፥ ዳቡሎሳ የሱሳና ጌሻ ካታማ ካንጊ፥ ጾስ ኬꬅ ኩስተል አፋ ከሲ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«ነ ጾስ ናአ ማቅኮ፥ አን ሱል ጉፒ ዎꬎባ።» አብስ ጊኮ፥ « ‹ነ ቶካይ ሹቻር ꬉብንታማይ ጋርክ፥ ፋ ኩሸር ነና ደንꬆዳይ ጋርክ፥ ጾሳይ ፋ ኪታንችታ ነ ግሾስ ኪቶዳ› ዬግንቲ ጾሳ ቃላይድ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","የሱሳ ኤኮ፥ «ማካ፥ ‹ጾሳ ቃላይድ ነ ጎዳ፥ ነ ጾሳ ፓጭፐ› ዬግንቲ ጻፍንቴዛ» ግ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ዉርስꬃል ዳቡሎሳ የሱሳና ፐቲ ዳማ አምባ ጼራል ከሲ አላመ ካተትꬅ ኡ ቦንቻይር ዎላ ቤዚ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«ነ ታስ ጹጉኒ ጎይንኮ ታ ኔስ Ꮊያ ኡባ እማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","የሱሳ ማሂ ኤኮ፥ «Ꮊ ጻላሃዮ፥ ታፕ ሃኮባ! ‹ነ ጎዳ፥ ነ ጾሳይስ ጎይኖባ፥ ኤዛ ኣዳ ጎይኖባ› ዬግንቲ ጾሳ ቃላይድ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","የይፕ ጉየ፥ ኤዛ ጻላሃይ አሺ ቅቴዛ፤ ኪታንችታይ ይኢ ኤዛ ማዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","የሱሳ፥ ዋንሳ አጭንቴዛና ስኢ ጋልላ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ናዝረተ ካታማ አሺ ዛብሎናኔ ንፍታለመ ሄራ፥ አባ ላንቀ የዝ ቅፍርናሆመ ካታማ Ꮊንጊ ኤዛይድ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","የይ ሀኔዛይ ናበ ኢሳያሳ ዶናር፥ ");
INSERT INTO mfxe_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ዛብሎነ ቢታ፥ ንፍታለመ ቢታ፥ ዮርዳኖስ ቦርካፕ ሰኮ ፕኖ፥ አባኮ ካንግዝ ኦገ ጋጻ የዝ፥ አይሁደ ባ አሳይ ጋንጨ የዝ ጋልላ ቢታ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ꬉማ የዝ ዎያ፥ ዎልቃማ ፖኦ በኤዛ። Ꮊይቆ ኩያ በቴዝታይስካ፥ ፖኦ ከዜዝ» ዬጊ ኦድንቴዝ ቃላይ ፖልንቶድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","የ ዎደፕ አይኪ የሱሳ፥ «ጾስ ካተትꬃይ ኡኬዝ ግሾስ ይ ናጋራፕ ማቆይታ» ዬጊ ቃላ ሳባኮ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","የሱሳ ጋልላ አባ ላንቀር ኣꬊታር ናምኢ እሽታ፥ ጵጽሮሳ ግንትንትዝ ስሞናራኔ ኤ እሻ እንድራሰ በኤዛ። ኡንቲ ሞሎ አይክዝታ ማቄዝ ግሾስ ፋ ግታና አባ ጋንጨ ኦልዛና በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","የሱሳ ኡንታን፥ «Ꮊና የኦይታ፤ ታና ካሎይታ! ሞሎ አይክዛይ ጋርክ፥ ታ ይንታን አስ አይꬅ ታማርሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ኡንትካ፥ ኤልሲ ፋ ግታና ኦሊ አሺ የሱሳና ካሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","የሱሳ የይፕ ጽቃ ገደ ቲናል Ꮊንጊ ሀራ ናምኢ እሽታ፥ ዛብዶሳ ናእታ፥ ያይቆባራ ዋንሳራ በኤዛ። ፋ አዳ ዛብዶሳራ ዎላ ዎጎሎ ጋንጨ ፋ ግተ ሎእꬅዝን ብኢ ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ኡንትካ፥ ኤልሲ ፋ ዎጎሎ ጋንጨ ፋ አዳ አሺ የሱሳና ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","የሱሳ አይሁድታይ ዎሳ ኬꬃ ታማርስታር፥ ሳሎ ካተትꬅ ዎንግለ ኦድታራ ዱማ ዱማ ሀርገፕ አሳ ፓꬅታር ጋልላ ቢታ ኡባ ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","የይፕ ደንዴዛይድ ኤ ዋራይ ሶራ ቢታ ኡባ ስእንቴዛ። ዱማ ዱማ ሀርገር ዎቤዝታኔ መትንትዝታ፥ ቱና አያና አይክንቴዝታ፥ ሾጪ ኦልዝ ሀርገር የዝታኔ፥ ስሌዝታ ኤዝኮ ካንጌዛ፤ ኤዝካ ኡንታን ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","አሳይ ጋልላፕ፥ ታጲ ካታምታይፕ፥ የሩሳላመፕ፥ ይሁዳፐራ ዮርዳኖሳፕ ሰኮ ፕኖ የዝ ቢታፕ የኤዝ ጋመ አሳይ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ጋመ ዎያ ሺቄዛና የሱሳ ብኢ አምባል አፋ ከዚ በቴዛ። ኤ ታማርታይ ኤዝኮ ሺቅን፥ ");
INSERT INTO mfxe_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ꮊይ ጋርክ ዬጊ ታማርሴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«አያናር ማንቅታይ አንጅንቴዝታ፥ ሳሎ ካተትꬃይ ኡንትሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ዬክዝታይ አንጅንቴዝታ፥ ኡ ምንꬃꬆ ደማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ሃይታይ አንጅንቴዝታ፥ ኡ ሳአ ላቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ጌሸትꬅ ናይንትዝታይኔ ሳምንትዝታይ አንጅንቴዝታ፥ ኡ ምዦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ማርዝታይ አንጅንቴዝታ፥ ኡ ማሮትꬅ ደማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ዎዝና ጌሽታይ አንጅንቴዝታ፥ ኡ ጾሳ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","እግንꬅዝታይ አንጅንቴዝታ፥ ኡ ጾስ ናእታ ግንትንቲ ጼግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ጌሽ ባዝስ ግ፥ ባይእንትዝታይ አንጅንቴዝታ፥ ሳሎ ካተትꬃይ ኡንትሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«አሳይ ይንታን ታ ግሾስ ግ ጫዢ ባይኢ ይንታል አፋ ኢታ ባዝ ኡባ ዎርዶር ኦድኮ ይ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ይ ሳሎ Ꮊንጊ ኤኮድ ዎይታይ ዳማ ማቄዝ ግሾስ ኡፋይቶይታ፥ ሀባ ጎይታ። ይንታፕ ቲና የዝ ናብታ Ꮊይ ጋርክ ባይኤዛ።» ");
INSERT INTO mfxe_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«ይ ቢታስ ማጽነ፤ ማጽነ ፋ ማጽነትꬅ አሽኮ፥ ፋ ማልኦትꬃ ዋይዚ ማሂ ደማዴ? ባለ ኦልን አሳር የꬍንቶዳይፕ አትን አብስካ ማዶያ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«ይ ቢታስ ፖኦ፤ ደረል አፋ የዝ ካታምታ ጌሞዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ጾምፐ አይꬂ ካራ የዝ አስ ኡባይስ ፖኦዳይ ጋርክ ꬎቃ አቆ ጋድዛፕ አትን ኦታ ጋንጨ ጋድዛይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","የይ ጋርክ አሳይ ይ ሎኦ ኦሳ ብኢ፥ ሳሎ የዝ ይ አዳ ቦንቾዳይ ጋርክ ይ ፖአይ አስ ቲና ፖኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«ታኒ ሙሰ ህጋኔ ናብታይ ቃላ ሻሮዳይስ የኤዛ ይንትስ ኣዝፐ። ታ፥ ፖሎዳይስ የኤዛፕ አትን ሻሮዳይስ የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ታ ይንትስ ቱሮ ኦድዛ፤ ሳሎኔ ሳአ ኣꬎድ ሄሎዳይስ ህገ ኡባይ ፖልንቶዳይፕ አትን ህጋይፕ ፐቲ ቃላ ዎይ ፕዳለ ጹቃካ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","የይ ግሾስ፥ Ꮊ ኪትታይፕ ጽቅዛ ፐቲ ኪታ መንꬅዛ ኦንካ ማ Ꮊንክታ የይ ጋርክ ኦꬆድ ጋርክ ታማርስዛይ ኦንካ ሳሎ ካተትꬃ ኡባፕ ላፋ ማቆዳ። ዝን Ꮊ ኪታ ፖልዝታይኔ Ꮊንክታካ ፖሎድ ጋርክ ታማርስዛይ ሳሎ ካተትꬃ ኣꬎ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ታ ይንትስ ኦድዛ፤ ይ ጽሎትꬃይ ፈርሳውታይ ጽሎትꬃይፐኔ ህገ አስታማርታይ ጽሎትꬃይፕ ኣካ አትኮ፥ ሳሎ ካተትꬃ ይ የሻ ገላሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«ይ ማይዝታይስ፥ ‹ዎꬍፓተ፤ ሸምፖ ዎꬍዝ ኦንካ ፕርድንቶዳ› ግንትንቴዛና ይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ዝን ታ ይንትስ ኦድዛ፤ ፋ እሻይር ካጭንትዝ ኡባይ ፕርድንቶዳ። ፋ እሻ ጩርቃይ ግዝ ኦንካ ዳይና ቲና ፕርዳስ ሺቆዳ። ፋ እሻይኮ፥ ‹ቱላይ› ግዝ ኦንካ ጋናመ ታማ ፕርድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«የይ ግሾስ፥ ኔኒ ነ ያርሻ ያርሾዳር ነ እሻ ሽፍሼዝ ባዝ ኔስ ቆፍንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ነ ያርሻ ያ አቃይድ አሺ ቅቶባ፤ ቲናቲ Ꮊንጊ ነ እሻይር ጊጎባ፤ ዬዚ ማቂ፥ ነ ያርሻ ጾስስ ያርሾባ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«ነና ሞትዛይራ ፕርደ ኬꬅ Ꮊንግታር ኦገል አፋ ኤዛር ዳቦቶባ። የይ አቶ ጊኮ ኤ ነና ዳይና ቲና ካንጎዳ። ዳይናይ ነና አጭዛይስ ኣꬂ እማዳ፤ ኤ ነና ዎይነ ኦሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ታ ቱሮ ኦድዛ፤ ሚሻይፕ ፐቲ ሳንትፈ አተካዝ ጭጊ ሃሶድ ሄሎዳይስ አች ኬꬃፕ ነ ኬዛሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","« ‹ላምፓተ› ግንትንቴዛና ይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ዝን ታ ይንትስ ኦድዛ፥ ማች ብኢ፥ አሞቴዝ ኡባይ ፋ ዎዝና ጋንጨ እዝር ላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ነ ኡሻች ኣፋይ ነና ናጋራ ቤዝዛ ማቅኮ፥ ከሲ ኦሎባ። ነ አሻይ ኩንꬅዝን ጋናመ ታማ ጋንጨ ዎꬋዳይፕ ነ አሳተꬃይፐ ፐታይ ꬋብኮ ኔስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ነ ኡሻች ኩሻይ ነና ናጋራ ኦꬅስዛ ማቅኮ፥ እዞ ጋቺ ኦሎባ። ነ ጋላይ ኩንꬅዝን ጋናመ ታማ ጋንጨ ዎꬋዳይፕ ነ አሳተꬃይፐ ፐታይ ꬋብኮ፥ ኔስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«ፋ ማቻቶ ዳክዝ ኦንካ አንጆ ዋርቃተ እንጎ» ግንትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ዝን ታ ይንትስ ኦድዛ፤ ፋ ማቻቶ ላግተካዝን ብልእዝ ኦንካ እዛ ላሞድ ጋርክ ኦꬅዛ። የይ ጋርከካ፥ አንጅንቴዝ አስቶ ኤክዛ ኡባይ ላምዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«ይ ማይዝታይኮ፥ ‹ዎርዶር ጫቂፓተ፤ ይ ጾስ ቲና ጫቀዛና ፖሎይታ› ግንትንቴዛ ይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ዝን ታ ይንትስ ኦድዛ፤ ኡባራካ ጫቂፓተ። ጾሳይ በትዛ ዙፋነ ማቄዝ ግሾስ ሳሎር ጫቂፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ኤ ቶካይ የꬍዝ አቆ ማቄዝ ግሾስ ሳአራካ ጫቂፓተ። ግታ ካት ካታማ ማቄዝ ግሾስ የሩሳላመራካ ጫቂፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ይ ብናናይፕ ፐታካ ቦꬅ ዎይ ካርꬅ ኡዶዳይስ ዳንዳኦዋ ግሾስ ይንቲ ይ ኡባራካ ጫቂፕፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","የይ ግሾስ፥ ይ ቃላይ፥ ‹ኤ› ዎይ ‹ዋኣ› ማቆ። የይፕ አቴዛይ ኢታፕ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹ኣፈ ግሾስ ኣፈ፤ አች ግሾስ አች› ግንትንቴዛ ይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ዝን ታ ይንትስ ኦድዛ፤ ይንታል አፋ ኢታ ባዝ ኦꬅዝ አꬃካ እጽፓተ። ኦንካ ነ ኡሻች ሻንጋላ ባቂኮ ነ ሀድርስ ሻንጋላካ ቤዞባ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ፐቲ አሲ ነ ሻምዥቶ ኤኮዳይስ ነና ዳይናል ሞትኮ፥ ነ ኮታቶ ጉጂ እንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ኦንካ አሲ ነና ዎልቃር ፋባዝ ቶሲ ፐቲ ክሎ ምትረ ባጋ ኦገ ፋር Ꮊንጎድ ጋርክ ነና ጭጵችኮ፥ ኤዛር ናምእ ዳኮ ኦገ Ꮊንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ዎስዛ ኦስካ እንጎባ፤ ኔፐ ጋርጾዳይስ ኮይዝ ኦናካ ካይፐ።» ");
INSERT INTO mfxe_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« ‹ነና ቃꬍዛና ቃꬎባ፤ ነና እጽዛና እጾባ› ግንትንቴዛና ይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ዝን ታ ይንትስ ኦድዛ፤ ይ ሞርክታ ቃꬎይታ፤ ይንታን ቆህዝታይስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","የይ ጋርክ ይ ኦꬅኮ፥ ሳሎ የዝ ይ አዳይስ ይ ናእታ ማቆዳ። ኤ ኢትታይስኔ ሎእታይስ አዋ ከስዛ፤ ጽልታይስኔ ናጋራንችታይስ ፋ እራ ቡክስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ይንታን ቃꬍዛ አስ ኣዳ ይ ቃꬍኮ፥ ይንትስ አባ ዎይቶ የኔ? ሀራ አቶዝን፥ ቃራጸ ጋችስዝታይካ ይኖ ኦꬆሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ይንቲ፥ ይ እሽታይ ኣዳ ሳሮꬅኮ፥ Ꮊንክታይፕ አብ ሀራ ኣꬍዝባዝ ኦꬅኔ? ሀራ አቶዝን፥ ጾስ አማኖዋ አሳይካ ይኖ ኦꬆሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ይኬ፥ ሳሎ የዝ ይ አዳይ ፎሎ ማቄዛይ ጋርክ ይንትካ ፎሎ ማቆይታ።» ");
INSERT INTO mfxe_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«ጉጅካ የሱሳ Ꮊይ ጋርክ ዬጌዛ፤ አሲ ቦኦ ግ ይ ሎኦ ኦሳ አስ ቲና ኦꬃማይ ጋርክ ናግንቶይታ። የይፕ አትኮ ሳሎ የዝ ይ አዳይፕ ዎይቶ ደንጋሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«ይንቲ ማንቅታይስ እንግታር አስ ቲና ቦንችንቶዳይስ ግ ጩቢታይ ኦገ ዶናይዳኔ አይሁድታይ ዎሳ ኬꬅታይድ ኦꬅዛይ ጋርክ አሲ ቦኦ ግ ቱልቱላ ፑግስፓተ። ታ ይንትስ ቱሮ ኦድዛ፤ ኡንቲ ፋ ዋጋ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ዝን ይ ማንቅታይስ እንጎዳር ይ ኡሻች ኩሻይ ኦꬅዛና ይ ሀድርስ ኩሻይ ኤርፐ፤ ");
INSERT INTO mfxe_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ይኬ እማይ ጌማ ማቆ። ጌማ ኦꬅዛና ብእዛ ይ አዳይ ይንትስ ዎይቶ ፕ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ዎሳ ዎስታር ጩቦ አሳይ ጋርክ ሀንፓተ። ኡ ፋና አሲ ቦኦ ግ አይሁድታይ ዎሳ ኬꬅ ጋንጨኔ ኦገ ዶናል ኤቂ ዎስዛና ዶስዛ። ታ ይንትስ ቱሮ ኦድዛ፤ ኡንቲ ፋ ኩንꬅ ጋተ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ዝን ነ ዎስታር ነ ቆልአ ገሊ ጋዛራ ጎርዲ ጌማ የዝ ነ አዳይኮ ዎሶባ፤ ጌማ ኦስንቴዝ ባዝ ብእዛ ነ አዳይ ኔስ ነ ጋታ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ይ ዎስታር አማኖዋ አስ ጋርክ ጨረ ቃላ ማሂ ማሂ አዱስስ ዎስፓተ። ኡ አዱስስ ዎስኮ ጾሲ ስእዛ ግ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","የይ ግሾስ ኡንቲሳይ ጋርክ ሀንፓተ። አብስ ጊኮ ይ አዳይ ይንትስ አቢ ኮሽዛኮ ይ ዎሶዳይፕ ቲናቲ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ይኬ፥ ይ ዬጊ ዎሶይታ፦ « ‹ሳሎ የዝ ኑ አዳዮ፥ ነ ሱንꬃይ አንጅንቶ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ነ ካተትꬃይ የኦ፥ ነ ሸናይ ሳሎ ሀኔዛይ ጋርክ ሳአላካ ሀኖ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ጋላሳ ካꬃ Ꮊይኖ ኑስ እንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ኑኒ ኑና ቆሄዝታይስ፥ አቶ ግዛይ ጋርክ፥ ኑስካ ኑ ቆሄዝ ባዝ አቶ ጎባ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ኑና ኢታፕ አሾባፕ አትን ፓጨ ጋንጨ ገልስፐ። ካተትꬂ፥ ዎልቃኔ ቦንቾ መꬍናስ ኔሲ። አምንኤ።› ");
INSERT INTO mfxe_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«ይ ይንታን ቆሄዝታይስ አቶ ጊኮ፥ ሳሎ የዝ ይ አዳይ ይ ቆሄዝ ባዝካ አቶ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ዝን ይ ሀራ አስ ናጋራ አቶ ጋም እጽኮ ይ አዳይ ይ ናጋራ አቶ ጋሚ።» ");
INSERT INTO mfxe_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ይ ጾምታር ጩቢታይ ጋርክ ሹልፓተ። አብስ ጊኮ፥ ኡንቲ ጾምዛና አሲ ኤሮድ ጋርክ ፋ ስና ካይስዛ። ታ ቱሮ ኦድዛ፤ ኡንቲ ፋ ጋታ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","«ዝን ነ ጾምታር ነ አፋ ሜጮባ፥ ነ ኦማ ትዥንቶባ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","የይ ጋርክ ነ ኦꬅኮ ነ ጾምዛ ጾማይ አሳፕ ጌምዛ፥ ዝን ጌማ የዝ ነ አዳይ ኤርዛ ጾማ ማቃዳ። ጌማ ኦስንቴዝ ባዝ ብእዛ ነ አዳይ ኔስ ዎይቶ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ብላኔ ዎሾ ꬋብስዛ አቆ፥ ካይዞ ቦኪ ኤክዛ አቆ፥ Ꮊ ሳአል፥ ይንትስ ሻሎ ሺሽፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ዝን ብላኔ፥ ዎሾ፥ ꬋብሶዋ፥ ካይዞ ቦኪ ኤኮዋ አቆ ሳሎ ይንትስ ሻሎ ሺሾይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ነ ሻላይ የዛ አቆ ነ ዎዝናይካ ኤዛይድ የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«ኣፈ አሰትꬅ ኡባስ ጾምፐ። የይ ግሾስ፥ ነ ኣፋይ ፓꬅ ማቅኮ ነ ጋላይ ኡባይ ፖኦ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ነ ኣፋይ ሀርግንትዛ ማቅኮ ነ ኩንꬅ አሰትꬃይ ꬉማ ማቅዛ። ይኬ፥ ኔል የዝ ፖአይ ꬉማ ማቅኮ፥ ꬉማይ አብ ጋርክ ኣꬊ ꬉሞደሻ! ");
INSERT INTO mfxe_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«ፐቲ አሲ ናምኢ ጎድታይስ ሞድንቶዳይስ ዳንዳኦያ። ፐታ ቃꬊኮ Ꮊንካ እጽዛ፤ ዎይ ፐታ ቦንችኮ Ꮊንካ ለቂዛ። ጾስስኔ ሚሸስ ሞድንቶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«ይኬ፥ ስኦይታ! ይ ሸምፓይስ፥ ‹አብ ማዴ? አብ ኡዦደ? አብ ማኦደ?› ግ ቆፕፓተ፤ ሸምፖ ካꬃፕ፥ ጋላ ማኦፕ ኣꬎሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ሳሎ ካፍታ ቦኦይታ፤ ኡንቲ ዘሮያ፥ ቡጮያ፥ ሻለ ኦሎያ፥ ዝን ይ ሳሎ አዳይ ኡንታን ሙዝዛ። የዝን ይ ኡንታፕ ሎእꬂ ኣꬎሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ይ ጋንጨፕ ኡንእንቲ ፋ ላይꬂል አፋ ፐቲ ጋላስ ጉጆዳይስ ዳንዳእዛይ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«ማ ይንቲ ማእዛባዝስ አብስ ኡንእንትኔ? ዎራ የዝ ፉꬂታ ቦኦይታ፥ ኡ ኦሶር ዳቡሮያ ዎይ ሱቆያ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ሀራ አቶዝን፥ ካት ሶሎሞነ ፋ ቦንቾ ኡባይር Ꮊ ፉꬂታይፕ ፐታይ ጋርክ ማኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ይንታኖ፥ አማኖ ፓጬዝታዮ፥ ጾሳይ Ꮊይኖ በንቲ ዎንታ ታማ ጋንጨ ዎꬋዳይስ የዝ ማታ ዬዚ ማእስዛ ማቅኮ፥ ይንታን ኡንታፕ ኣꬂ ዋይዚ ማእሶሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","የይ ግሾስ፥ ‹አብ ማዴ? አብ ኡዦደ? አብ ማኦደ?› ግ ኡንእንትፐተ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ꮊያ ኡባ ጾስ አማኖዋ አሳይ ጋንꬂ ደንጎዳይስ ኡንእንትዛ። ይ ሳሎ አዳይ የ ኡባይ ይንትስ ኮሽዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ዝን ኡባፕ ቲን ጾስ ካተትꬅኔ ኤ ጽሎትꬅ ኮዦይታ፤ የ ኡባይ ይንትስ ጉዥንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","የይ ግሾስ፥ ዎንታስ ቆፕታር ኡንእንትፓተ። ዎንታ ፓስ መትንቶ፤ ፐቲ ፐቲ ጋላሳይስ ኤ ኢታትꬃይ ግዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«ይንታል አፋ ፕርድንታማይ ጋርክ ሀራ አሳል አፋ ፕርድፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","አብስ ጊኮ፥ ሀራ አሳል አፋ ይ ፕርድዛይ ጋርክ ይንታል አፋ ፕርዶዳ ይ ሀራ አስስ ማኬዝ ባዛር ይንትስ ማሂ ማክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ነ ኣፈ የዝ ቱሳ በኤካዛር ነ እሻይ ኣፈ የዝ ቡጻ አብስ በኤ? ");
INSERT INTO mfxe_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ነ ኣፈ ቱስ የዝን ነ እሻይ ኣፈ የዝ ቡጻ ከሶ ጎዳይስ ዋይዚ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ነኖ ጩባዮ፥ ቲናቲ ነ ኣፋይድ የዝ ቱሳ ከሶባ። ኤዛይፕ ጉየ ነ እሻይ ኣፋይድ የዝ ቡጻ ከሶዳይስ ነ ምልጽ ኡዲ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«ጉየ ማቂ ይንታን ꬋቃማይ ጋርክ ጌሽ ባዝ ካንታይስ ኦልፓተ። ፋ ቶካይር የꬊ ኢሳማይ ጋርክ ይ አልኦ እንቁ ጉዱዳይልታይ ቲና ኦልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«ዎሶይታ ይንትስ እንግንቶዳ፥ ኮዦይታ ይ ደማዳ ባለ ይኢ ጼጎይታ ይንትስ ዶይንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ዎስዛ ኦስካ እንግንቶዳ ኮይዝ ኦስካ በንቶዳ ባለ ይኢ ጼግዝ ኦስካ ዶይንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«ይንታፕ ናአ ዳቦ ዎስኮ ሹች እንግዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ዎይ ሞሎ ዎስኮ ሾሽ እንግዛይ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","የዝን ይ ኢትታይ ይ ናእታይስ ሎኦ ባዝ እሞ ኤርኮ ሳሎ የዝ ይ አዳይ ፋና ዎስዝታይስ ሎኦ ባዝ ዋይዚ ጋንꬂ እንጋሞ? ");
INSERT INTO mfxe_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ꮊንክታይ ይንትስ ኦꬆድ ጋርክ ይ ኮዥዝ ባዝ ኡባ ይንትካ ሀራ አስስ ኦꬆይታ። አብስ ጊኮ፥ ሙሰ ህጋይኔ ናብታይ ታማርስዛይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«ኡንአ ፐንገር ገሎይታ፤ ꬋቦ ካንግዝ ኦጋይ ዳማ፥ ፐንጋይካ ዳልገ። ኤዛይር ገልዛ አሳይካ ጋመ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ዝን ደኦኮ ካንግዝ ኦጋይኔ ፐንጋይ ኡንአ፤ ኤዛይር ገልዛ አሳይካ ጽቃ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«አፋ ባጋር ዱረ ኣዚ ጋንጨር ፉገ ማቂ ቦንቆዳይስ ይ ጋንጨ ገልዛ ዎርዶ ናብታይፕ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ይ ኡንታን፥ ኡ ኣፋይር ኤሮዳ፤ አንጉꬂፕ ዎይኔ፥ ግጀፕ ባላሰ ማጽንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","የይ ጋርክ ሎኦ ምꬂ ኡባይ ሎኦ ኣፈ ኣፍዛ፤ ኢታ ምꬂ ኢታ ኣፈ ኣፍዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ሎኦ ምꬂ ኢታ ኣፈ ኣፎያ፥ ማ ኢታ ምꬂ ሎኦ ኣፈ ኣፎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ሎኦ ኣፈ ኣፎዋ ምꬂ ኡቢታይ ጋችንቲ ታማ ጋንጨ ኦልንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","የይ ግሾስ፥ ይ ኡንታን፥ ኡ ኣፋትር ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ሳሎ የዝ ታ አዳይ አዛዞ ኦꬂዛ አꬃይ ሳሎ ካተትꬃ ገሎዳይፕ አትን ጨር ታና ‹ጎዳዮ፥ ጎዳዮ› ግዝ ኡባይ ሳሎ ካተትꬅ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","የ ዎደ ጋምታይ፥ ‹ጎዳዮ፥ ጎዳዮ፥ ነ ሱንꬃር ትንቢተ ኑ ኦደካሳ? ነ ሱንꬃር ቱና አያንታ ኑ ከሰካሳ? ነ ሱንꬃር ጋመ ማላታ ኑ ኦꬃካሳ?› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","የ ዎደ፥ ‹ታ ይንታን የሻ ኤሮያ፥ ይንቲ ዉጭታይ ታፕ ሃኮይታ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«ይኬ፥ Ꮊ ታ ቃላ ስኢ ኦꬅዛ ኦንካ ፋ ኬꬃ ዛላል አፋ ኬጼዝ ዎዛናማ አስ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","እራ ቡኬዛ፥ ድኦ ድኤዛ፥ ጫርኮካ ጫርኪ የ ኬꬃና ኡርቄዛ። ዝን ኬꬃይ ዛላል አፋ ኬጽንቴዝ ግሾስ ዎደካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ꮊ ታ ቃላ ስኢ ኦꬆዋ ኦንካ ፋ ኬꬃ ሻፈል አፋ ኬጼዝ ቦዞ አꬃይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","እራ ቡኪ፥ ድኦ ድኢ፥ ጫርኮካ ጫርኪ፥ የ ኬꬃ ኡርቅን፥ የ ኬꬃይ ዎዴዛ፤ ኤ ዎድꬃይካ ዎልቃማ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","የሱሳ ፋ ኦዳ ዉርሴዛይፕ ኤ ትምርታይ ህገ አስታማርታይ ጋርክ ማቀካ ማዉተር የዝ አሳይሳይ ጋርክ ማቅዝ ግሾስ አሳይ ኤ ትምርታ Ꮊይ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","የሱሳ ደረላፕ ዎꬍዝ ዎደ ጋመ ዎያ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ፐቲ ቦርቆንቶር ሀርግንትዛይ ኤዝኮ ሺቂ፥ ኤ ቲናይድ ጹጉኒ፥ «ጎዳዮ፥ ነ ሸነ ማቅኮ ታና ጌሺ ፓꬆዳይስ ነ ዳንዳእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","የሱሳ ፋ ኩሻ ዳኪ ኤዛ ቦቺ፥ «ኤ ታ ሸነ፥ ጌዦባ» ዬጌዛ። አꬃይ ቦርቆንታይፕ እዝር ጌዢ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","የሱሳ ኤዝኮ፥ «ነ ፓጻ ኦስካ ኦድፐ። ዝን Ꮊንጊ ነ ጌዢ ፓጼዛና ቄሰ ቤዞባ። ነ ፓጼዛይስ ማርካ ማቆዳይ ጋርክ Ꮊንጊ ሙሰ ኪቴዝ ያርሻ ያርሾባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","የሱሳ ቅፍርናሆመ ግዝ ካታማ ሄሌዝ ዎደ ፐቲ ማቶ ሀላቃይ ኤዝኮ ሺቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ጎዳዮ፥ ታ አይላይ ጋላይ ስልን ኢታ ሀርግንቲ ካራ ዎይኢ የዛ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","የሱሳ ማሂ ኤዝኮ፥ «ታኒ Ꮊንጊ ኤዛ ፓꬆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ዝን ማቶ ሀላቃይ ማሂ፥ «ጎዳዮ ነ ታ ካራ ገሎዳይስ ታ ቤዝዛ አስ ባያ፥ ዝን ነ Ꮊኔ በቲ ቃላ ኣዳ ኦዶባ ታ አይላይ ፓጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ታፕ አፋር ታና ኪትዛ አሳይ የዛ፥ ማ ታፕ ኣሞር ታስ ኪትንትዝታይ የዛ። ኡንታፕ ፐታ፥ ‹ቅቶባ› ጊኮ ቅትዛ፤ ማ Ꮊንካና ‹Ꮊና የኦባ!› ጊኮ ይእዛ። ታ አይላ፥ ‹Ꮊኖ ኦꬆባ› ጊኮ ኦꬂዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","የሱሳ የያ ስኢ ማላባዝ ግ፥ ፋና ካልዛ አሳይኮ፥ «ታ ይንትስ ቱሮ ኦድዛ፤ ታኒ Ꮊይ ጋርክ ጻላ አማኖ እስሬለ አሳይ ጋንጨካ በኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ታ ይንትስ ኦድዛ፤ ጋምታይ አዋ ከስኔ አዋ ገሎ ባጋፕ ይኢ፥ ሳሎ ካተትꬅ አፍራመር፥ እሳቃራኔ ያይቆባራ ዎላ እማቶል በቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ዝን ሳሎ ካተትꬅ ላቶዳይስ ቤዞዳር አቴዝታይ ባለ ꬉማ ኦልንቶዳ። ኤዛይድ ኡንትስ ዬፎኔ አች ጮንች ማቃዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","የሱሳ ማቶ ሀላቃይኮ፥ «ነ ካራ ቅቶባ፥ ነ አማናቲ ጋርክ ኔስ ሀኖ» ዬጌዛ። ኤ አይላይ ያ ሳታተ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","የሱሳ ጵጽሮሳ ካራ ገሎዳር ጵጽሮሳ ማቻት እንዳት ኦጸ ምሻ ሀርገር ሀርግንቲ ዎይኢ የዛኖ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","የሱሳ እ ኩሻ ቦቼዛን ጋርክ ኦጻይኔ ምሻይ ኤቄዛ። ፓጺ ደንዲ ኤዛ ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","የ ዎደ ኦማꬅ ቱና አያናር አይክንቴዝ ጋመ አስታ፥ አሳይ የሱሳኮ ከኤዛ። ኤዝካ ቱና አያንታ ፋ ቃላር ከሴዛ፥ ሀርግንቴዝታ ኡብታ ፓꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","የይዳካ ናበ ኢሳያሳ፥ «ኤ ኑ ዳቡርሳ ፋስ ኤኬዛ፥ ኤ ኑ ሀርጋ ቶኬዛ» ጌዝ ቃላይ ፖልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","የሱሳ ጋመ አሳይ ኤ ካለ ኤቄዝታ ብኢ፥ አባፕ ሰኮ ፕኖ ፒንጎድ ጋርክ ፋ ታማርታ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ህገ አስታማርታይፕ ፐታይ፥ «አስታማራዮ፥ ነ Ꮊንግዛ አቆ ኡባ ታ ካሎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","የሱሳ ኤዝኮ «ሻንታይስ ኦላ የዛ፥ ሳሎ ካፍታይስ ኬꬂ የዛ። ዝን አስ ናአይስ ፋ ኦማ ሸምፕስዛ አቆ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","የሱሳ ካልዛ አስታይፕ ፐታይ፥ «ጎዳዮ፥ ታኒ ቲናቲ Ꮊንጊ ታ አዳ ሞጊ የኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ዝን የሱሳ፥ «Ꮊይቄዝታይ ፋ Ꮊይቂታ ሞጎ፤ ኔኒ ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","የሱሳ Ꮊማዳይስ ዎጎሎ ጋንጨ ገሎዳር ኤ ታማርታይካ ኤዛር Ꮊማዳይስ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ኡንቲ ቆፐካ የዝን፥ ዎልቃማ ጎተ አባል አፋ ደንድን ዎጎላይ ምትንቶዳይስ ሄሌዛ። ዝን የሱሳ ገንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ኤ ታማርታይ ኤዝኮ ሺቂ ኤዛ ባርክꬂ፥ «ጎዳዮ፥ ኑ ꬋቦሆ ኑና አሾዬ» ዬጊ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","የሱሳ ኡንትኮ፥ «ይንታኖ፥ አማኖ ፓጬዝታዮ፥ አብስ ያሽተ?» ዬጌዛ። ደንዲ፥ ጫርካኔ ጎታ ሴርን ኤልሲ ኡባ ባዝ ጭጭርክ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ኤ ታማርታይ ማላባዝ ግ፥ «Ꮊይ፥ ሀራ አቶዝን፥ ጎተነ አባ ኪትንትዛይ ዋፋ አሶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","የሱሳ አባፕ ሰኮ ፕኖ የዝ ገርገሶነ ግዝ ቢታ ሄሎዳር ቱና አያና አይኬዝ ናምኢ አስታይ ዱፎፕ ከዚ ኤዛ ሄሌዛ። ኡ ኢታ ያሽዝ አስታ ማቄዝ ግሾስ አሲ የ አቃይር ኣꬎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ኡንትካ፥ «ጾስ ናአዮ፥ ኑራኔ ኔራ አቢ ዎል ሄልꬂ? ኑ ቃማይ ሄለካዝን ኑና ፕርዶዳይስ ነ የኤኔ?» ግ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ኡንታፕ ጋመ ሃከካዛር ጉዳይለ ዉደ ሄንግንትዝታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ቱና አያንታይ የሱሳ፥ «ነ ኑና ከስዛ ባዝ ማቅኮ፥ ሰኮ ጉዳይለ ዉዳይ ጋንጨ ዳኮየ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","የሱሳ፥ «Ꮊንጎይታ» ዬጌዛ። ቱና አያንታይ ከዚ ጉዳይልታይል ገሌዛ። ጉዳይልታይ ኡባይ ጋጋ ዶናር ድርጊ Ꮊንጊ አባ ጋንጨ ምትንቲ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ጉዳይለ ዉደ ሄንግዝታይ ቆስንቲ ካታማ Ꮊንጊ፥ ሀኔዝባዝኔ ቱና አያናይ አይኬዝ አሳይል አፋ ኦስንቴዝ ባዝ ኡብታ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","የዝን፥ ካታማ ጋንጨ የዝ አስ ኡቢታይ የሱሳ በአዳይስ ከዜዝ። ኡንቲ የሱሳ በኤዝ ዎደ ፋ ቢታፕ ከዚ ቅቶድ ጋርክ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","የይፕ ጉየ፥ የሱሳ ዎጎሎ ጋንጨ ገሊ፥ አባ ፒንጊ ፋ ካታማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","አሳይ ፐቲ ስላ አꬃ አርሳር ቶኪ የሱሳኮ ከኤዛ። የሱሳ ኡ አማና ብኢ፥ ስላ አꬃ፥ «ታ ናአዮ፥ ያሽትፐ! ነ ናጋራይ አቶ ግንትንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","የ ሳታይድ፥ አይሁድታይ ህገ አስታማርታይፕ ፐታይ ፐታይ፥ «Ꮊይ ጾስ ጫዥዛ» ዬጊ ኡ ፋ ዎዝናር ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","የሱሳ ኡ ቆፋ ኤሪ፥ «ኢታ ባዝ ይ ዎዝናር አብስ ቆፔ? ዬጌዛ ");
INSERT INTO mfxe_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ዝን፥ ‹ነ ናጋራይ አቶ ግንትንቴዛ› ግዛይፐነ ‹ደንዲ ቅቶባ› ግዛይፕ ኣይ ኣꬌ? ");
INSERT INTO mfxe_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ዝን ቢታል አፋ ናጋራ አቶ ጎዳይስ አስ ናአይስ ማዉተ የዛና ታ ይንታን ኤርሶዳ» ዬጊ፥ ስላ አꬃይኮ፥ «ደንዲ ነ አርሳ ቶኪ፥ ነ ካራ Ꮊንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ስላ አꬃይ ደንዲ ፋ ካራ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ዎያይ የያ ብኢ ማላባዝ ጌዛ። የይ ጋርክ ማዉተ አስስ እንጌዝ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","የሱሳ የይፕ ደንዲ Ꮊንግታር ማቶሳ ግዝ አꬃይ ቃራጸ ጋችስዝ አቆ በቴዝን ብኢ፥ «ታና ካሎባ» ዬጌዛ። ኤዝካ ደንዲ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","የሱሳ ማቶሳ ካራ ሙንታል አፋ በቴዝን፥ ቃራጸ ጋችዝ ጋመ አስታይኔ ናጋራ ኦꬅዝ አሳይ ይኢ ኤዛራኔ ኤ ታማርታይር ዎላ ማዳይስ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ፐቲ ፐቲ ፈርሳወ አሳይ የያ ብኢ፥ የሱሳ ታማርታ፥ «ይ አስታማራይ ቃራጸ ጋችሽዝታይራኔ ናጋራ ኦꬅዝታይር አብስ ሜ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","የሱሳ የያ ስኢ፥ «አክመ ኮሽዛይ ሀርግንቴዝታይስፕ አትን ፓꬅታይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ዝን ይ Ꮊንጊ፥ ‹ታኒ ይ ያርሻ ባዝን ማሮትꬅ ኮይዛ› ጉሳይ ዋጉስዛኮ ኤሮይታ። አብስ ጊኮ፥ ታ ናጋራ ኦꬅዝታ ጼጎዳይስ የኤዛፕ አትን ጽልታ ጼጎዳይስ የኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","የ ዎደ ዋንሳ ታማርታይ የሱሳኮ ሺቂ፥ «ኑራኔ ፈርሳወ አሳይ ጾምዛ፥ ዝን ነ ታማርታይ አብስ ጾሞሳ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","የሱሳ ማሂ ኡንትኮ፥ «ማቾ ኤክዛይ ኡንታር የዝን ላዛንꬅታይ አዛኖዳይስ ዳንዳእኔ? ማቾ ኤክዛይ ኡ አቻፕ ኤክንቶድ ዎደ የኦዳ፥ ኡ የ ዎደ ጾሞዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«ኦሮꬅ ማኦፕ ፔꬃ ጭማ ማኦል አፋ ስክዛ ኦንካ ባያ። የይ ጋርክ ኦꬂኮ ኦሮꬃይ ጭማና ፐርእዛ። ፐርእꬃይካ ጉጂ ዳልግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ኦሮꬅ ዎይነ ጭማ ኦጎሮ ጋንጨ ዳኪ ጋድዛ ኦንካ ባያ። የይ ጋርክ ኦꬂኮ ኦሮꬅ ዎይናይ ጭማ ኦጎራ ꬉስዛ ዎይናይካ ላልንትዛ፤ ኦጎራይካ ናምአንꬆ አዶዋ ባዝ ማቅዛ። ዝን ኦሮꬅ ዎይነ ኦሮꬅ ኦጎሮ ጋንጨ ኦልንቶዳይስ ቤዝዛ። የይ ጋርክ ኦስንትኮ ናምእታይካ ኢተካዛር ናግንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","የሱሳ የያ ኦዶል አፋ የዝን፥ አይሁደ ሀላቅታይፕ ፐታይ ኤዝኮ ይኢ፥ ኤ ቲናይድ ጹጉኒ፥ «ታ ናአታ Ꮊት Ꮊይቄዛ፥ ዝን እዛ ፓጾድ ጋርክ ነ ይኢ ነ ኩሻ እዝል አፋ ጋዶየ» ግ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","የሱሳ ደንዲ ኤዛር Ꮊንጌዛ፤ ኤ ታማርታይካ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ኤ Ꮊማዳር ታጶ ናምኢ ላይꬅ ኩንꬅ ሱꬂ ጎግ ዋይꬅዛ ፐቲ አስታ ጉየር ሺቂ የሱሳ አፍላ ማጫራ ቦቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","እዛ ፋ ዎዝናር፥ «ታ ኤ አፍላ ማጫርቶ ኣዳ ቦችዛኮ ፓጾዳ» ዬጊ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","የሱሳ ጉየ ማቂ እዞ ብኢ፥ «ታ ናአተ፥ ያሽትፐ! ነና ነ አማናይ ፓꬅዛ» ዬጌዛ። የ አስታ እዝር ፓጺ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","የሱሳ አይሁደ ሀላቃይ ካራ ሄሎዳር ድንከ ፑግዝታኔ ዬክዝታ ብኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«አን ሀልኦይታ፤ ጽቃ ናአታ ገንቴዛፕ አትን Ꮊይቀካያ» ዬጌዛ። ዝን አሳይ ኤዛል አፋ ሚጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","አሳ ባለ ከሴዛይፕ ጉየ ካራ ገሊ፥ ናአት ኩሻ አይክን፥ ናአታ ደንዲ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","የ ዋራይ የ ቢታ ኡባ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","የሱሳ ኤዛይር ገደ ቲና Ꮊንጎዳር ናምኢ ቶእታይ ፋ ቃላ ꬎቅ ኡዲ፥ «ዳዉተ ናአዮ፥ ኑና ማሮየ» ግ ኡክታር ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","የሱሳ ካራ ገሎዳር ቶእታይ ኤዛ ካል የኤዛ። የሱሳ ኡንትኮ፥ «ታኒ የያ ኦꬆዳይስ ዳንዳእዛና ይ አማንኔ?» ዬጌዛ። ኡንትካ፥ «ኤ፥ ጎዳዮ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","የይፕ ጉየ፥ የሱሳ ኡ ኣፋና ቦቺ ኡንትኮ፥ «ይንትስ፥ ይ አማናይ ጋርክ ሀኖ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ኡ ኣፋይካ ዶይንቴዛ። የሱሳ ኡንትኮ፥ «Ꮊያ ኦስካ ኦድፓተ» ዬጊ ሚንꬂ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ዝን አስታይ Ꮊንጊ የሱሳ ኦሳ የ ቢታ ኡባይል ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ኡንቲ የይፕ ከሳዳር አሳይ ቱና አያናይ አይኬዝ ፐቲ ሙመ አስ የሱሳኮ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ቱና አያናይ ከዜዛይፕ ጉየ ሙመ አꬃይ ኦድንቴዛ፥ ዎይታይካ ማላባዝ ግ፥ «Ꮊይ ጋርክ ኦሮꬅ ባዝ እስሬለ ቢታል የሻ ሀነካ ባዝ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ዝን ፈርሳውታይ፥ «ቱና አያንታይ ሀላቃይር ቱና አያንታ ከስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","የሱሳ አይሁድታይ ዎሳ ኬꬃ ታማርስታር፥ ሳሎ ካተትꬅ ዎንግለ ሳባክታር፥ አሳ ሀርገ ኡባይፕ ፓꬅታር ካታምታይራኔ ሄራ ኡባይር ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ጋመ ዎያ፥ ሄንግዝ አስ ባ ዱር ጋርክ ኡንታን ብእዛ አስ ꬋብን ኡንእንቴዝታኔ ላልንቲ የዝታ ብኢ ኡንትስ ቃꬍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ፋ ታማርታይኮ፥ «ሺቆድ ቶርቼ ካꬃይ ጋመ፥ ዝን ቶርቼ ካꬃ ሺሽዛ አሳይ ጽቃ። ");
INSERT INTO mfxe_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","የይ ግሾስ፥ ጎዳይ ቶርቼ ካꬃ ሺሾዳይስ ኦሶ አስታ ዳኮድ ጋርክ ቶርቼ ጎዳ ዎሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","የሱሳ ታጶ ናምኢ ታማርታ ፋኮ ጼጊ፥ ቱና አያንታ ከሶድ ጋርከኔ ሀርገ ኡባ ፓꬆዳይ ጋርክ ኡንትስ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ታጶ ናምኢ ሀዋርታይ ሱንꬃ፦ ኡንትካ ጵጽሮሳ ግዝ ስሞናራኔ ኤ እሻ እንድራሰ፥ ዛብዶሳ ናአ ያይቆባራ ኤ እሻ ዋንሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፍልጶሳ ባርቶሎሞሳ፥ ቶማሳ ቃራጸ ጋችስዝ ማቶሳ፥ ኢልፎሳ ናአ ያይቆባ፥ ታዶሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ቀነና ስሞናራኔ የሱሳ ኣꬃ እንጌዝ አስቆሮቶ ይሁዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","የ ታጶ ናምእታ የሱሳ ኪቲ ዳክታር፥ «አይሁደ ባዝታይኮ Ꮊንግፓተ፥ ማ ሳማርታይ ካታማ ገልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ዝን እስሬለ ካራፕ ማቄዝ ሰክ ꬋቤዝ ዱርታይኮ Ꮊንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ꮊንጊ፥ ‹ሳሎ ካተትꬃይ ኡኬዛ› ግ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ሀርግንቴዝታ ፓꬆይታ፥ Ꮊይቄዝታ Ꮊይቆፐ ደንꬆይታ፥ ቦርቆንቶ ሀርገር የዝታ ጌሺ ፓꬆይታ፥ ቱና አያንታ ከሶይታ። ይ ጨር ኤኬዛና ጨር እንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ይ ኪሰ ዎርቀ፥ ዎይ ብራ ሳንተ አይክፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ይ ኦገስ ቁርቦ፥ ናምኢ አፍላ፥ ዎይ ጫማ ዎይ ጉፈ አይክፓተ፤ ኦሶ ኦꬆዝታይስ ካꬃ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«ይ ካታማ ዎይ ሄራ ገሎዳር ይንታን ሞኪ ኤኮዳይስ ኡፋይትዛ አꬃ ኮዢ ኤ ካራ ሸምፖይታ፤ ይ ከዚ Ꮊማድ ጋላሳ ሄሎዳይስ ኤዛይድ ጋምኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ማ ኦ ካራካ ገልታር ሳሮꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","የ ኬꬃይ ይንታን ሞክኮ ይ ሳሮꬆዝ ሳራይ ኡንታን ሄሎ፥ ዝን ኡ ሞካም እጽኮ ይ ሳሮꬅዝ ሳራይ ይንትስ ጉየ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ኦንካ ይንታን ሞኮዋ ባዝ ማቅኮኔ ይ ኦዴዝባዝ ስአም እጽኮ የ ካርትፕ ዎይ የ ካታምትፕ ከዝታር ይ ቶከል የዝ ቡልአ ፕቲ ከዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ታ ይንትስ ቱሮ ኦድዛ፤ ጾስ ፕርዳ ጋላስ የ ካታማትፐ ሶዶመስራኔ ጋሞራ ካታምታይስ ፕርዳይ ካዉዦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«ታ ይንታን ዱርታይ ጋርክ ፉግታይ ጋንጨ ዳኮዳ። የይ ግሾስ፥ ሾሽ ጋርክ ኤጭታ፥ ሆለ ጋርክ ሀይታ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","አሳይ ይንታን ፕርዳ ዳይንታይስ ኣꬂ እማዳ፥ ማ አይሁድታይ ዎሳ ኬꬃይድ ይንታን አላንጎዳ። የይ ግሾስ፥ ኡንታፕ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ታ ግሾስ ግ ይንታን ጋደ አቅስዝታይ ቲናኔ ካትታይ ቲና ካንጎዳ። ኡ ቲናይዳኔ አይሁደ ባ ዎያ ቲና ኤቂ ይ ታባዝ ማርካቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ዝን ይንታን ፕርዳስ ኣꬂ እንጎዳር ዋጎ አብ ማሆ ግ ኡንእንትፓተ፤ የ ሳተ ይ ጎድባዝ ጾስ ይንትስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","አብስ ጊኮ፥ ይንታር ማቂ ኦድዛይ ይ አዳይ አያናፕ አትን ይንታን ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«ኢሻይ ፋ እሻ፥ አዳይ ፋ ናአ፥ Ꮊይቆስ ኣꬂ እማዳ፥ ናእታይ ፋና የሌዝታይል አፋ ደንዲ ዎꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ታ ሱንꬃይ ግሾስ ግ አሲ ኡባይ ይንታን እጾዳ፥ ዝን ዉርስꬃይ ሄሎዳይስ ጋርዤዛይ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ፐቲ ካታማፕ ይንታን ኡ ባይእኮ ሀራ ካታማ ቆስንቶይታ። ታኒ ይንትስ ቱሮ ኦድዛ፤ አስ ናአይ የኦድ ሄሎዳይስ፥ ይ እስሬለ ካታማ ኡባ ፖላሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«ታማራይ ፋ አስታማራይፕ፥ አይላይ ፋ ጎዳይፕ ኣꬎያ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ታማራይ ፋ አስታማራ፥ አይላይ ፋ ጎዳ ኣዝኮ ኤዝስ ግዶዳ። ካራ አዳ ብኤልዘቡላ ጊኮ ኤ ካራ አሳ ዋይዚ ኢሲ ጼጎዴ? ");
INSERT INTO mfxe_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ይኬ፥ አስስ ያሽትፓተ፥ ካምንቴዝ ባዝ ቆንጮዳ፥ ቆስንቴዝ ባዝ ፕ ከዘካዛር አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ታ ይንትስ ꬉማ ኦድዛና ይ ፖኦ ኦዶይታ፤ ታ ይንትስ ሀየ ካለ ካልካሼዝ ባዝ ደረል አፋ ዎያስ አዋጆይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","አሾፕ አትን ሸምፖ ዎꬎዳይስ ዳንዳኦዝታይስ ያሽትፓተ። ዝን ሸምፖኔ አሾ ጋናመ ꬋብሶዳይስ ዳንዳእዛ ጾሳይስ ኣꬎ ያሽቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ናምኢ ሱንታይ ፐቲ ባካና ባይዝንቶሳኔ? ዝን፥ ኡንታፕ ፐታካ ይ አዳይ ጌካዝን ሳአ ዎꬂ አቶያ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ሀራ አቶዝን፥ ይ ኦማ ብናናይካ ፓይድንቲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ይኬ፥ ጋመ ሱንታይፕ ይ ኣꬂዝ ግሾስ ያሽትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«አስ ቲና ታስ ማርካትዝ ኡባይስ ታንካ ሳሎ የዝ ታ አዳይ ቲና ማርካቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ዝን አስ ቲና ታና ካድዛና ታንካ ሳሎ የዝ ታ አዳይ ቲና ኤዛ ካዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«ታ ሳአል ሳሮ ኮኦዳይስ የኤዛ ይንትስ ኣዝፐ። ታ ኦላፕ አትን ሳሮትꬅ ኮኦዳይስ የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ታ የኤዛይ፥ «‹ናአ አዳይፕ ናአቶ እንዳትፕ፤ ናአይ ማቻቶ አዝናይ እንዳትፕ ሻኮዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","አስስ ሞርኬ ኤ ካራ አስታ ማቃዳ።› ");
INSERT INTO mfxe_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«ታፕ ኣꬂ ፋ ኣዳ ዎይ ፋ እንዳቶ ዶስዛይ፥ ታስ ማቆዳይስ ቤዞያ። ፋ ꬍራꬅ ናአ ዎይ ፋ ማች ናአቶ ታፕ ኣꬂ ዶስዛይ፥ ታባዝ ማቆዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ፋ ማዝቃለ ቶኪ ታና ካሎዋ ኦንካ ታባዝ ማቆዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ፋ ሸምፖ አሾዳይስ ኮይዛይ ꬋብሶዳ፥ ዝን ፋ ሸምፖ ታ ግሾስ ኣꬂ እንግዛይ አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«ይንታን ሞክዛይ ታና ሞክዛ፥ ታና ሞክዛይ ማ ታና ኪቴዝ ታ ኣዳ ሞክዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ናባና ናበ ሱንꬃር ሞክዛይ፥ ናባይ ጋርክ ዎይትንቶዳ፤ ማ ጽላና ጽሎ ሱንꬃር ሞክዛይ፥ ጽልታይ ጋርክ ዎይትንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ታ ይንትስ ቱሮ ኦድዛ፤ Ꮊ ታ ታማርታይፕ ጽቅዛ ፐታይስ ታና ካልዛ ግሾስ ሀራ አቶዝን ሀለ ሃꬅ እርጻ እንግኮ ኤ ዎይታይ ꬋበና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","የሱሳ ታጶ ናምኢ ታማርታይስ አዛዛ እንጌዛይፕ ጉየ ኤዛይፕ ደንዲ ታማርሶዳይስኔ ሳባኮዳይስ ጋልላ ካታምታይኮ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ዋንሳ አች ካራ የዛር ክርስቶሳ ኦꬄዝ ባዝታ ስኢ፥ ፋ ታማርታይፕ ናምእታ ኤዝኮ ኪቲ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«የኦዳ ጊንትንቴዛይ ነናኔ? ኑ ሀራ ናጎ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","የሱሳ ኡንትኮ ማሂ፥ «Ꮊንጊ ይ ስእዝባዝኔ ይ በኤዝ ባዝ ዋንሳስ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ቶእታይ በአዳ፥ ሾልዝታይ የꬎዳ፥ ቦርቆንቶር ሀርግንቴዝ አስታይ ጌዦዳ፥ ቱልታይ ስኦዳ፥ Ꮊይቄዝታይ Ꮊይቆፕ ደንዶዳ፤ ማንቅታይስ ዎንግላይ ሳባክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ታል ꬉብንተካዛይ አንጅንቴዛያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ዋንሳ ታማርታይ ጉየ ማቂ ቅትን፥ የሱሳ ዎያይስ ዋንሳ ባዝ ኦድታር፥ «Ꮊ ሊዦ ጋꬋይድ አብ በአዳይስ ከዜኔ? ጫርኮ ኤንእስዛ ማቃ በአዳይስ የኤነኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","የዝን፥ አብ በአዳይስ ከዜኔ? ሎኦ አፍላ ማኤዝ አስ በአዳይሶኔ? ሎኦ አፍላ ማኤዝታይ ካትታይ ኬꬃ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","የዝን፥ አብ በአዳይስ ከዜኔ? ናበ በአዳይሶኔ? ዬዛኮ፥ ይ ናበፐካ ኣꬍዛና ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","«ነ ኦጋ ነ ቲናይር ጊግስዛ ኪትንቴዛና ኔፕ ቲና ኪቶዳ» ዬግንቲ ጻፍንቴዛይ ኤሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ታ ይንትስ ቱሮ ኦድዛ፤ ማቻፕ የልንቴዝታይ ጋንጨፕ ጻማቅዛ ዋንሳፕ ኣꬍዛይ ኦንካ ባያ፤ ሳሎ ካተትꬅ ኡባይፕ ጽቅዛይ፥ ኤዝፕ ኣꬎዳ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ጻማቅዛ ዋንሳ ዎደፕ አይኪ Ꮊይኖ ሄሎዳይስ ሳሎ ካተትꬃይ ጋመ ኡርቅንትዛ፥ ሚንጊ ቡትንቴዝታይ የ አቃ ገሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ናብታይ ኡቢታይኔ ሙሰ ህጋይ ዋንሳ ዎደ ሄሎዳይስ ሀኖድ ባዝ ትንቢተ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ይኬ፥ ይ ኡ ኪታ አማኖድ ማቅኮ፥ የኦድ ግንትንቴዝ ኤላሳ፥ የይ ኤ ዋንሳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ይኬ፥ ስእዝ ሀየር የዛይ ስኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ይኬ፥ Ꮊ ዎደ የለትꬃ አባራ ኣዝሶ? ጋበ ጋንጨ በቲ ዎል ጼጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","« ‹ኑ ይንትስ እምፕልተ ፑግን፤ ይ የጾያ። ኑ ሳቢ ዘላልን፤ ይ ዬኮያ› ዬግዝ ናእታ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ጻማቅዛ ዋንሳ ሜካዛራኔ ኡዠካዛር ይእን፥ ‹ቱና አያናር የዛ› ይ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","አስ ናአይ ሚታራኔ ኡዥታር ይእን፥ ‹ዥምባራኔ ኡሺ ዣረ፥ ቃራጸ ጋችስዝታይኔ ናጋራንችታይ ዳቦ› ዬጌዛ። ይኬ፥ ኤጨትꬅ ቱማትꬃይ ኤ ኦሳይር በንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","የይፕ ጉየ፥ የሱሳ ጋመ ማላትታ ኦꬅዝ ካታምታይድ የዝ አሳይ ፋ ናጋራፕ ማቂ ማሮትꬅ ገላም እጼዝ ግሾስ ኡንታን፥ ");
INSERT INTO mfxe_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«አየ ኮራዝኔ ካታማስ፥ አየ ቤተሳይዳ ካታማስ፥ አብስ ጊኮ፥ ይ ጋንጨ ኦꬅንቴዝ ማላታይ ጽሮሳኔ ስዶና ኦꬅንቴዝ ማቄዛኮ፥ ኡ ብኒ ቡዶ ትዥንቲ፥ ካዮ አፍላ ማኢ ፋ ናጋራይፕ ማቂ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ዝን ታ ይንትስ ኦድዛ፤ ፕርዳ ጋላስ ይንታፕ ኣꬅ ጽሮሳስኔ ስዶናስ ፕርዳይ ካዉዦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ማ Ꮊኔ ቅፍርናሆማ፥ ነ ፑደ ሳሎ ከዞዳይስ ኮይኔ? ሀናሚ! ኔኒ ስኦለ ዎꬎዳ። አብስ ጊኮ፥ ነ ጋንጨ ኦꬅንቴዝ ማላትታይ ሶዶማ ኦስንቴዛኮ ሶዶመ Ꮊይኖ ሄሎዳይስ የሳዳዝን። ");
INSERT INTO mfxe_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ዝን ታ ኔስ ኦድዛ፤ ፕርዳ ጋላስ ኔፕ ኣꬅ ሶዶማስ ፕርዳይ ካዉዦዳ» ዬጊ ካጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","የ ዎደ የሱሳ፥ «አዳዮ፥ ሳሎኔ ሳአ ጎዳዮ፥ ኔኒ Ꮊያ ኤራንችታይፐኔ ኤጭታይፕ ቆሲ ዱደ ናእታይስ ቆንጭሴዝ ግሾስ ነና ታ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ኤ፥ ታ አዳዮ፥ Ꮊይ ነ ሎኦ ሸናይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«ኡባይ ታስ ታ አዳይፕ እንግንቴዛ። አዳይፕ ሀራ ናአ ኤርዛይ ባያ፥ ናአይፐኔ ኤ ኡንትስ ቆንጭሶዳይስ ኮይዝታይፕ ሀራ ኣዳ ኤሮዳይስ ዳንዳእዛይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«ይንታኖ፥ ዳቡሬዝታዮ፥ ቶፎ ዴጼዝ ኡቢታዮ ታኮ Ꮊና የኦይታ፤ ታ ይንታን ሸምፕሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ታኒ ታ ዎዝናር ኬሃኔ ሃዮ ማቄዝ ግሾስ ታ ቃምባራይድ ገሎይታ፥ ታፕ ታማሮይታ፤ ይንቲ፥ ይ ሸምፖስ ሸምፖ ደማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ታ ቃምባራይ ሊቃማ፥ ማ ታ ቶፋይካ ሻዉኮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","የይፕ ጉየ፥ ማላ ጋላስ፥ የሱሳ ጋደ ጋንጨር ኣꬍዛ። የሱሳ ታማርታይ ናይንቴዝ ግሾስ ባንጋ ትዣ ምርኪ ሙስ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ዝን ፈርሳውታይ የያ ብኢ የሱሳኮ፥ «Ꮊያ ቦኦባ፥ ነ ታማርታይ ማላ ጋላስ ኦꬆዳይስ ቤዞዋ ባዝ ኦꬅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","የሱሳ ኡንትኮ ማሂ፥ «ዳውተ ናይንቴዝ ዎደ ኤዛር የዝታይራ አብ ኦꬄዛኮ ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ዳውተ ጾስ ኬꬃ ገሊ ቄስታይ ኣዳፕ አትን ኤዝኔ ኤዛር የዝታይስ ቤዞዋ ያርሽንቴዝ ዳቦ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ካህንታይ ማላ ዎጋ ሻሪ ጾሳ ኬꬃ ማላ ጋላስ ኦሶ ኦꬅኮ ኡንትስ ናጋራ ማቆዛና ሙሰ ህጋይፕ ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ዝን ስኦይታ! ጾስ ኬꬃፕ ኣꬍዛይ Ꮊይዳ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹ታኒ ይ ያርሻ ባዝን ይ ሀራ አስ ማሮድ ጋርክ ኮይዛ› ግዝ ቃላይ ዋጉስዛኮ ይ ኤሬዛኮ ጌሽ አሳል አፋ ፕርዳሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","አስ ናአይ ማላስ ጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","የሱሳ የይፕ Ꮊንጊ አይሁድታይ ዎሳ ኬꬃ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ኤዛይድ ኩሸ ስሌዝ ፐቲ አꬃይ የዛ። የሱሳና ሞቶዳይስ ሳንከ ኮይዝ አሳይ፥ «ማላ ጋላስ አስ ፓꬆዳይስ ቤዝነኔ ቤዞሳ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ኤ ኡንትኮ፥ «ይ ጋንጨፕ ፐታይስ ዱሪ ማላ ጋላስ ኦላ ዎꬍኮ፥ ጎቺ ከሶዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","የዝን አሲ ዱራፕ ዋይዚ ሎእꬂ ኣꬎሳ? የይ ግሾስ፥ ማላ ጋላስ ሎኦ ባዝ ኦꬆዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","የይፕ ጉየ፥ የሱሳ አꬃይኮ፥ «ነ ኩሻ ፕድ ኡዶባ» ዬግን፥ አꬃይካ ፕድ ኡዴዛ። ኤ ኩሻይ ፓጺ Ꮊንኮ ኩሻይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ዝን ፈርሳውታይ የይፕ ባለ ከዚ፥ የሱሳ ዋይዚ ዎꬎዳዛኮ ዎላ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","የሱሳ ኡ ቆፋ ኤሪ የ አቃ አሺ ሀራ አቆ ቅቴዛ። ጋመ አሲ ኤዛ ካሊ Ꮊንጌዛ፥ ሀርግንቴዝታ ኡባ ኤ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","የሱሳ፥ «ታ ባጋ ኦስካ ኦድፓተ» ዬጊ ሚንꬂ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","የይካ ናበ ኢሳያሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«ይኬ ታ ማራጼዝ አይላይ፥ ታ ዶስዛይ፥ ታና ኡፋይስዛይ፥ ታኒ ታ አያና፥ ኤዛል አፋ ሸምፕሶዳ፤ ኤ፥ አይሁደ ባ ዎያስ ሉለ ፕርደባዝ አዋጆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ኤ ፓላሞያ ዎይ ካጮያ፤ ፋ ቃላካ ደንባል ጨር ስሶያ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ሉለ ፕርዳር ጋሞድ ሄሎዳይስ፥ ሎሜዝ ማቃ መንꬆያ፥ ጩይዝ ሙቃዳ ቶእሶያ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","አይሁደ ባ ዎያ ኡቢታይ ኤል ኡፋይቶዳ» ዬጊ ኦድንቴዛይ ፖልንቶዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","የይፕ ጉየ፥ ቱና አያና አይኬዝ ቶአኔ ሙመ አስ የዛና ኤዝኮ ከኤዛ። የሱሳ አꬃ ፓꬅን፥ አꬃይ በኤዛኔ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ዎያ ኡባይ ማላባዝ ግ፥ «Ꮊይ ዳዉተ ናአ ማቃደሻ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ዝን ፈርሳውታይ የያ ስኢ፥ «Ꮊ አꬃይ ቱና አያንታ ከስዛይ ቱና አያንታይ ሀላቃ ብኤልዘቡላ ዎልቃራ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","የሱሳ ኡ ቆፋ ኤሪ፥ «ፐቲ ካተትꬂ ሻክንቲ ዎላል ኤቅንትዛ ማቅኮ የ ካተትꬃይ ዎꬎዳ፤ ማ ዎል ጋንጨ ሻኮትꬅ መꬍዝ ካታማ ዎይ ኬꬂ ሚንጊ ኤቆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ጻላሄ ጻለሄ ከስዛ ባዝ ማቅኮ ፋ ጋንጨ ሻግንቴዝ ጉሲ። የይ ጋርከ ሀንዛ ባዝ ማቅኮ ኤ ካተትꬃይ ዋይዚ ሚንጊ ኤቆዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ታኒ ቱና አያና ከስዛይ ብኤልዘቡላ ዎልቃር ማቅኮ ይንታን ካልዛ አሳይ ኦ ዎልቃር ከሶዴ? የይ ግሾስ፥ ይንታን ካልዛ አሳይ ይንታን ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ዝን ታኒ ቱና አያንታ ከስዛይ ጾስ አያናር ማቅኮ፥ ጾስ ካተትꬃይ ይንትኮ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«ዎይ ፐቲ አስ ዎልቃማ አስ ካራ ገሊ ኤ ሻላና ቦንቆዳይስ ኮይኮ ቲናቲ የ አꬃ አጨካ አትኮ ዋይዚ ቦንቆዳይስ ዳንዳኤ? አጬዛይፕ ጉየ ኤ ሻላና ቦንቆዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«ታር ባዛይ ኦንካ ታና እጽዛ፤ ማ ታር ዎላ ሺሾዋ ኡባይ ላልዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","የይ ግሾስ፥ ስኦይታ፤ አሳይ ኦꬂዛ አባ ናጋራካ ጫሺ ኡባይ አቶ ግንትንቶዳ፥ ዝን ጌሻ አያና ጫዤዝ ኦስካ ኤ ናጋራይ አቶ ጊንትንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ኦንካ አስ ናአል አፋ ኢታ ባዝ ኦድንትኮ ኤስ አቶ ግንትንቶዳ፥ ዝን ጌሻ አያናል አፋ ኢታ ባዝ ኦድንትዛ ኦስካ Ꮊ ሳአል ማቅን የኦድ አላማይላካ ኤ ናጋራይ አቶ ጊንትንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«ሎኦ ምꬂ ሎኦ ኣፈ ኣፍዛ፤ ማ ኢታ ምꬂ ኢታ ኣፍዛ። ይኬ፥ ምꬂ ኤርንትዛይ ፋ ኣፋይራ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ይንታኖ፥ ሾሽ ናኡንꬆ፥ ይ ኢታ ማቅታር ዋይዚ ሎኦ ባዝ ኦድንቶዳይስ ዳንዳእኔ? አሲ ፋ ዎዛና ጋንጨ ኩሚ ፑጬዝ ባዛፕ ዶናር ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ሎኦ አሲ ፋ ዎዝና ጋንጨ ጋዴዝ ሎኦ ባዛፕ፥ ሎኦ ባዝ ከስዛ፤ ኢታ አሲ ፋ ዎዝና ጋንጨ ጋዴዝ ኢታ ባዛፕ፥ ኢታ ባዝ ከስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ዝን ስኦይታ፥ አሲ ኦድንትዛ ጨረ ኦዳ ኡባይስካ ፕርዳ ጋላስ ማልሰ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","አብስ ጊኮ፥ ነ ኦድንትዛ ነቃላይር ጽሎዳ፤ ነ ኦድንትዛ ነ ቃላይ ኔል አፋ ፕርዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","የይፕ ጉየ፥ ፐቲ ፐቲ ፈርሳውታይኔ ህገ አስታማርታይ የሱሳኮ፥ «አስታማራዮ፥ ኔኒ ማላታ ኦꬂ ኑና ቤዞዬ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ዝን የሱሳ ማሂ፥ «አማኖዝታይኔ ኢታ የለትꬂታይ ማላታ ኮይዛ። ዝን ናበ ዮናሳ ማላታፕ ሀራ ማላታ ኤስ እንግንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናሳ ግታ ሞሎ ኡሎ ጋንጨ ሀይꬒ ጋላስኔ ሀይꬒ ቃማ ጋምኤዛይ ጋርክ አስ ናአይ ሀይꬒ ጋላስኔ ሀይꬒ ቃማ ቢታ ጋንጨ ጋምኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ነነወ አሳይ ፕርደ ጋላስ ደንዲ Ꮊ የለትꬃይል አፋ ፕርዶዳ፤ አብስ ጊኮ፥ ኡ ዮናሳ ስብካታ ስኢ ፋ ናጋራይፕ ማቄዛ። ይኬ፥ ዮናሳፕ ኣꬍዛይ Ꮊይዳ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ፕርዳ ጋላስ ሱለ ባጋ ካታታ ደንዲ Ꮊ የለትꬃይር ዎላ ፕርዶዳ፤ አብስ ጊኮ፥ እዛ ሶሎሞነ ኤጨትꬃ ስኦዳይስ ቢታ ጋጻፕ የኤዛ። ዬዛኮ፥ ሶሎሞነፕ ኣꬍዛይ Ꮊይዳ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«ቱና አያናይ አሳፕ ከዜዛይፕ ጉየ ፋስ ሸምፕዛ አቆ ኮዪ ሃꬂ ባ መላ አቆ ዳቡርዛ፥ ዝን ፋ ኮይዝ ሸምፖ ደንጎያ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","የይ ግሾስ፥ ‹ታ አሺ ከዜዝ ካራ ማቂ Ꮊማዳ› ዬግዛ። ኤ ማቂ የኦዳር ኬꬃይ ካይሳ ማቅዛኔ ፕትንቲ ጊጊ በቴዛና ደንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ይኬ፥ ማቂ Ꮊንጊ፥ ፓፕ ኢታ ሀራ ላፑን ኢታ አያንታ ኤኪ ይእዛ፤ ኡንትካ አꬃይ ጋንጨ ገሊ የዝዛ። የ አꬃይስ ቲናሳይፕ ጉዬሳይ ኡሳ ኢትዛ። Ꮊ ኢታ የለትꬃይል የይ ጋርክ ባዝ ሀኖዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","የሱሳ ዎያይስ ኦዳል አፋ የዝን ኤ እንዳትኔ ኤ እሽታይ ኤር ናሾዳይስ ኮዪ ባለ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ፐቲ አሲ ኤዝኮ፥ «ነ እንዳትኔ ነ እሽታይ ኔር ናሾዳይስ ኮዪ ባለ ኤቄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","የሱሳ ማሂ፥ «ታ እንዳት ኦኖ? ታ እሽታይካ ኦናንታራ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ፋ ኩሻይር ታማርታ ማልታር፥ «ቦኦይታ፥ ታ እንዳታነ ታ እሽታይ Ꮊይትታ። ");
INSERT INTO mfxe_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ሳሎ የዝ ታ አዳይ ሸነ ኦꬂዛ ኡቢታይ ታ እሸ፥ ታ ምሾኔ ታ እንዶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","የ ጋላስ የሱሳ ካራፕ ከዚ አባ ካንታ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ጋመ ዎያ ኤ ላንቀ ሺቅን አሳ አባ ጋጻ አሺ ዎጎሎ ጋንጨ ገሊ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","አሳይስ ጋመ ባዝ ኣዝሶር ዬጊ ኦዴዛ፦ «ፐቲ ቢታ ኦꬅዝ አꬃይ ዘርꬅ ዘሮዳይስ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ኤ ዘሮዳር ፐቲ ፐቲ ዘርꬃይ ኦገ ጋጻ ዎꬌዛ፤ ኡንታናካ ካፍታይ ይኢ ማጺ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ፐቲ ፐቲ ዘርꬅታይ ስስልቆ ቢታል አፋ ዎꬌዛ። ጋመ ቢታ ባ ግሾስ ኤልሲ ዶሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ዝን አዋ ኬዝን ሹሌዛ፤ ጻጶ ባዛይ ግሾስ መሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ፐቲ ፐቲ ዘርꬃይ አንጉꬅ ጋንጨ ዎꬌዛ፤ አንጉꬃይ ድጪ የ ዶላ ጩሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ꮊንክታይ ማ እርኮ ቢታል አፋ ዎꬌዛ፤ ዶሊ ኣፈ ኣፌዛ። ፐታይ ጼት፥ ፐታይ ኡሱፑንታም፥ ፐታይ ማ ሀስታም ኣፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ስእዝ ሀየር የዝ አꬃይ ስኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","የሱሳ ታማርታይ ኤዝኮ ሺቂ፥ «አብስ ኔኒ ዎያይስ ኣዝሶር ኦዴ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ኤ ማሂ፥ «ይንትስ ሳሎ ካተትꬅ ጹራ እንግንቴዛ፥ ዝን ኡንትስ እንግንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","የዛ ኡባይስ ጉዥንቶዳ፥ ኤዝስ ጋንጎዳ፥ ዝን ባዛይፕ ሀራ አቶዝን ኤዝስ የዛናካ ኤክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","የይ ግሾስ፥ ታኒ ኡንቲ፥ ብእታር ደንጋማይ ጋርክ፥ ስእታር ስአም ጋርክ ዎይ አካካማይ ጋርክ ኡንትስ ኣዝሶር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","«ኢሳያሳ ፋ ማጻፋይ ግዶ ኦዴዛይ ኡንታል አፋ ፖልንቴዛ። ኤ ኦድታር፥ « ‹ይ ስስ ስእዛ፥ ዝን አካኮያ፤ ይ ብእꬅ ብእዛ፥ ዝን ደንጎያ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","አብስ ጊኮ፥ Ꮊ አሳይ ዎዝናይ ኦርዴዛ፤ ፋ ሀያ ኤርታር ቱልሴዛ፥ ፋ ኣፋ ጎዜዛ። የይ ባዛኮ ኡ ፋ ኣፋትር ብኢ፥ ፋ ሀየር ስኢ፥ ፋ ዎዝናር አካኪ፥ ታኮ ማቆዳ፥ ታካ ኡንታን ፓꬆዳዝን› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«ዝን ይ ኣፋይ ብእዛ ግሾ ይ ሀያይ ስእዝ ግሾስ ይ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ታ ይንትስ ቱሮ ኦድዛ፤ ጋመ ናብታይኔ ጌሽ አስታይ ይ በኤዛና በአዳይስነ ይ ስእዛና ስኦዳይስ አሞቴዛ፥ ዝን ኡንትስ ሀነካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ይኬ፥ Ꮊ ዘርꬅ ዘርዝ አꬃይ ኣዝሳ ስኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ኦገ ጋጻ ዎꬌዝ ዘርꬅ ኣዝሳይ Ꮊያ፦ ሳሎ ካተትꬅ ቃላ ስኢ አካኮዋ አይ ዎዝናይፕ ጻላሄ ይኢ ኤ ዎዛና ጋንጨ የዝ ዘርꬅ ማጺ ሃሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ስስልቆ ቢታል አፋ ዘርንቴዛይ ቤዝዛይ ቃላ ስኢ ኤልሲ ኡፋይሳር ኤክዝታ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ዝን Ꮊተሳፕ አትን ጻጶ ዳከካያ። ቃላ ግሾ መቶ ዎይ ባይእꬂ ይእዛ ዎደ ኤልሲ ꬉብንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","አንጉꬅ ጋንጨ ዘርንቴዛይ Ꮊያ ቃላ ስኤዛ፥ ዝን Ꮊ አላመ የስስ ህርጋይኔ ዱረትꬅስ ቆፋይ ቃላ ጩልዛ ግሾስ ኣፈ ኣፈካዛር አትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ዝን አራዳ ቢታል ዘርንቴዝ ዘርꬃይ Ꮊያ አካካር ቃላ ስኤዝ አꬃ። ኤ ኣፈ ኣፍዛ፤ ፐታይ ጼት፥ ፐታይ ኡሱፑንታም ፐታይ ማ ሀስታም እንግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","የሱሳ ኡንትስ ሀራ ኣዝሶ ኦዴዛ፥ «ጾስ ካተትꬃይ ፋ ዎታ ጋንጨ ሎኦ ዘርꬅ ዘሬዝ አꬃ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ዝን አስ ኡባይ ገንትን ኤ ሞርካይ ይኢ ግስተ ጋንጨ ሌሾ ዘሪ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ግስታይ ድጪ ካእዝ ዎደ ሌሾካ ኤ ጋንጨ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«ጋደ ጎዳይ አይልታይ ጎዳይኮ Ꮊንጊ፥ ‹ጎዳዮ፥ ነ ዎታይድ ነ ሎኦ ዘርꬅ ዘረካሳ? የዝን፥ ሌሾ አናፕ የኤኔ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«ኤ ኡንትኮ፥ ‹የያ ሞርከ ኦꬄዛ› ዬጌዛ። «አይልታይ ጎዳይኮ፥ ‹ኑ Ꮊንጊ ሌሻ ሾዶድ ጋርክ ነ ኮይኔ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«ዝን ኤ፥ ‹አቶ ቦችፓተ፤ ይ ሌሻ ሾድዝ ጎዳር ግስተካ ሾድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ቦችፓተ፤ ማጾ ዎደ ሄሎዳይስ ዎላ ድጮ። የ ዎደ ማጽዛ አስታይ ሌሻ ቲናቲ ማጺ ታማ ጋንጨ ጹጎዳይስ ምርቀር ምርቀር ምርቆይታ። ዝን ግስታ ሺሺ ታ ሻላይድ ኦሎይታ› ዬጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ማ ሀራ ኣዝሶ ዬጊ ኦዴዛ፤ «ሳሎ ካተትꬃይ ፐቲ አሲ ፋ ዎታ ጋንጨ ባኬዝ ሳናፍጨ ኣፈ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","የ ምꬃት ኣፋይ ሀራ ምꬅ ኣፍታይፕ ጽቃ፥ ዝን ዶሊ ድጪ ሀራ ምꬅ ኡባይፕ ኣꬃ ዳሚ ድጭዛ። እ ሻቅታይል አፋ ካፍታይ ኬጺ በቶድ ሄሎዳይስ ዳማ ምꬅ ማቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ማቅካ፥ የሱሳ ሀራ ኣዝሶ ኦዴዛ፤ «ሳሎ ካተትꬃይ ፐቲ ማቺ ሀይꬒ ጎንገ ꬍላ ኤኪ ሙኑቂ፥ ሙኑቃይ ደንዶዳይ ጋርክ ኤዛይድ ዳኬዝ እርሾ ኣዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","የሱሳ ዎያይስ የ ኣዝሶ ኡባ ኦዴዛ። ኣዝሶ ባዝን ፐትባዝካ ኦደካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ናባይ ፋ ማጻፋይ ጋንጨ፥ «ታኒ ታ ዶና፥ ኣዝሶር ዶዮዳ፤ ሳሎኔ ሳአ መꬍንቴዛይፐ፥ ጌመዛና ታ ኦድዛ» ዬጊ ኦዴዛይ የይድ ፖልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","የሱሳ ዎይታ አሺ ካራ ገሌዛ። ኤ ታማርታይ ኤዝኮ ሺቂ፥ «ዎታይድ የዝ ሌሻይ ብልꬃ ኑስ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ኤ ማሂ፥ «ሎኦ ዘርꬅ ዘሬዛይ አስ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ዎታይ Ꮊ አላማ። ሎኦ ዘርꬃይ ሳሎ ካተትꬅ ናእታ። ሌሻይ ጻላሄ ናእታ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ሌሾ ዘሬዛይ ሞርከ ጻላሄ፥ ማጾ ዎዳይ ዎደ ዉርስꬅ፥ ማጽዝታይ ኪታንችታ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«ሌሻይ ማጽንቲ ታማ ጋንጨ ጹግንትዛይ ጋርክ ዎደ ዉርስꬃላ Ꮊይ ጋርክ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","አስ ናአይ ፋ ኪታንችታ ኪቶዳ። ኡ ናጋራስ ሳንከ ማቄዝታኔ ኢታ ኦꬅዝ ኡብታ ማጺ ኤ ካተትꬃይፕ ከሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ማጺ ሺሺ ዬፎኔ አች ጮንቺ የዝ ቶኦዋ ታማ ጋንጨ ኦሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","የ ዎደ ጽልታይ ፋ አዳይ ካተትꬃይድ አዋ ጋርክ ፖኦዳ። ስእዝ ሀየ የዛይ ስኦ! ");
INSERT INTO mfxe_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«ጾስ ካተትꬃይ ዎታ ጋንጨ ሞግንቴዝ ሚሸ ኣዝዛ። ፐቲ አሲ የ ሚሻ ደንጊ ማሂ ሞጌዛ። ጋመ ኡፋይቲ Ꮊንጊ ፓስ የዛ ባዝ ኡባ ባይዚ የ ጋዳት ዎንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«የይ ጋርክ፥ ማ ሳሎ ካተትꬃይ እንቆ ግዝ አልኦ ሹችታ ኮይዝ ዛልኤ አስ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ጋመ አልኦ እንቆ ደንጊ Ꮊንጊ ፓስ የዛ ባዝ ኡባ ባይዚ ኤ ዎንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«ማ ጾስ ካተትꬃይ አባ ጋንጨ ኦልንቴዝ ዱማ ዱማ ሞሎ ኮች አይክዝ ግተ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ሞሎ አይክዝ አሳይ ሞሎ ግታይድ ኩምን አባፕ ጋጻ ከሴዛ። ኤዛይድ በቲ ሎኣ ሎኣ ቁሪ ዳቾ ጋንጨ ኦሌዛ፥ ዝን ኢታ ሞልታ አላ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ዎደ ዉርስꬃል የይ ጋርክ ሀኖዳ። ኪታንችታይ ይኢ ናጋራ ኦꬅዝታ ጽልታይፕ ቁሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ዬፎኔ አች ጮንቺ የዛ ቶኦዋ ታማ ጋንጨ ኦሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«Ꮊ ኡቢታይ ይንትስ ገሌኔ?» ዬጊ ኡንታን ኦይጬዛ። ኡ ማሂ፥ «ኤ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","የሱሳ፥ «ይኬ፥ ሳሎ ካተትꬅ ጹራ ኤኪ ህገ ታማርስዛ ኡቢታይ፥ ፋ ምንጄዝ ሻላይፕ ኦሮꬅኔ ጭማ ከስዛ ሻሎ ጎዳ ኣዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","የሱሳ Ꮊ ኣዝሳ ኦዲ ዉርሴዛይፕ ጉየ ኤዛይፕ ደንዲ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ፋ የልንቴዝ ቢታ Ꮊንጊ አይሁድታይ ዎሳ ካራ ታማርሶ አይኬዛ። ኡ ማላ ባዝ ግ፥ «Ꮊ አꬃይ Ꮊ ኤጨትꬅኔ Ꮊ ማላታ ኦꬄዛ ዎልቃ አናፕ ኤኬኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ꮊይ አናጻይ ናአ ባሳኔ? ኤ እንዳቲ ሱንꬃይ ማይራሞ ባሳኔ? ኤ እሽታይ ያይቆባ፥ ዮሴፋ፥ ስሞናራኔ ይሁዳ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ኤ ምሹንꬅካ ኑር የዙንꬃና ባሳኔ? የዝን፥ Ꮊ አꬃይ Ꮊ ኡባ አናፕ ኤኬኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","የይ ግሾስ፥ ኤ ግዝ ባዛ ኤካም እጼዛ። ዝን የሱሳ፥ «ናበ ፋ የልንቴዝ ቢታይዳኔ ፋ ካራ አሳይ ካለ ቦንችንቶያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ኡ አማናም እጼዝ ግሾስ ጋመ ማላታ የ አቃይድ ኦꬄካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","የ ዎደ ጋልላ አቅስዝ ሄሮድሳ የሱሳ ዋራ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ፋ አይልታይኮ፥ «Ꮊይ ጻማቅዛ ዋንሳ፤ ኤ Ꮊይቆፕ ደንዴዛ። የይ ግሾስ Ꮊ ኡባ ማላትታ ኤ ኦꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ኤ የያ ጌዛይ ሄሮድሳ ፋ እሻ ፍልጶሳ ማቻት ሄሮድያዳ ግሾስ ዋንሳ አች ኬꬃ ገልሴዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ዋንሳ ሄሮድሳ፥ «ነ እዞ ኤኮዳይስ ዎጋ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ሄሮድሳ ዋንሳ ዎꬎዳይስ ኮዬዛ፥ ዝን ዎያይ ዋንሳ ናበ ኡዲ ብእዝ ግሾስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ሄሮድሳ ፋ የልንቴዝ ጋላሳ ቦንችዛ ዎደ ሄሮድያዳ ናአት አስ ቲና የꬃር ዶንጊ ኤዛ ኡፋይሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","የዝን፥ ኤ፥ «እዛ ኮይዝ ባዝ ኡባ ኢስ እማዳ ግ» ጫቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ናአታ ፋ እንዳት ዞረ ስኢ ሄሮድሳኮ፥ «ጻማቅዛ ዋንሳ ቆꬋይፕ ጋቺ ኦማ ፍልኦ ጋንጨ ጋዲ ታስ እንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","እዛ ዬግን ካታይ ቂራꬋዛ፥ ዝን ፋ ጫቃይ ግሾኔ ፓር የዝ እማꬂታይ ግሾስ ግ እ ኦይቻይ ፖልንቶድ ጋርክ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ካታይ አስ ኪቲ ዋንሳ አች ኬꬃ የዝን ኤ ቆꬋ ጋችሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ኤ ኦማ ፍልኦ ጋንጨ ኣꬃ ክኢ ናአትስ እንጌዛ፤ ናአታካ ኤኪ ፋ እንዳትስ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ዋንሳ ታማርታይ ይኢ ኤ አሃ ካንጊ ሞጌዛ። ኤዛይፐ ጉየ ሀኔዝባዝ ኡባ Ꮊንጊ የሱሳስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","የሱሳ ሀኔዝባዛና ስኢ ዎጎሎ ጋንጨ ገሊ የ በሳይፐ ፐቲ ጌምዛ አቆ ፋ ኣዳስ Ꮊንጌዛ። አሳይ የያ ስኢ ካታምታይፕ ደንዲ ቶከር ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","የሱሳ ዎጎሎፕ ዎꬊ ጋመ አሳ ብኢ ኡንትስ ቃꬍንቴዛ። ኡ ጋንጨ የዝ ሀርግንቴዝ አስታ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ሳአይ ኦማꬂታር Ꮊንግን የሱሳ ታማርታይ ኤዝኮ ሺቂ፥ «Ꮊ አቃይ ሊዦ፥ ሳአይካ ቃሜዛ። የይ ግሾስ፥ ሄራ Ꮊንጊ ፓስ ዎንጊ ማድ ጋርክ ዎያ ዳኮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ዝን የሱሳ ኡንትኮ፥ «ዎያይ ሜካዛር Ꮊማዳይስ ኮሾያ፤ ኡ ማድባዝ ይ እንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ኡ ማሂ፥ «ኑስ Ꮊኔ እችን ሶሎራኔ ናምእ ሞሎፕ ሀራ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ኤዝካ፥ «አን እዞ Ꮊና ኮኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ማ ማቅካ፥ ዎያይ ማታል በቶዳይ ጋርክ ኦዴዛ። እችን ሶሎራ ናምእ ሞልታ ኤኪ፥ ሳሎ ብኢ ጋላቲ ማቂ፥ ሶላ ዱꬂ ፋ ታማርታይስ እንጌዛ፤ ኡንቲ ማ ዎያይስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ኡባይ ም ምዤዛ። የሱሳ ታማርታይ ማዳር አቴዛና ታጶ ናምኢ ሌማተ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ካꬃ ሜዝ አሳይ ማችኔ ናአ አትን እችን ሙኩለ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","የሱሳ ፋ ታማርታይ ዎጎሎ ጋንጨ ገሊ ፓፕ ቲናቲ አባይፕ ሰኮ ፍንꬂ ፒንጎዳይ ጋርክ ኪቲ ፋስ ዎያ ሞይዞዳይስ ጉየ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ዎያ ሞይዚ ማቂ ፋ ኣዳስ ዎሶዳይስ ፐቲ ደረል አፋ ከዜዝ። ሳአ ቃምንካ ኤ ፋ ኣዳስ ኤዛይድ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","የ ዎደ ዎጎላይ አባል አፋር Ꮊማዳር ቲና ባጋር ጫርኮ ደንድን ጎታይ ዎጎላና ጭጵቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ዎንትማꬄላ የሱሳ አባል አፋ የꬍታር ፋ ታማርታይኮ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ኤ ታማርታይ፥ ኤ አባል አፋ የꬍታር ኡንትኮ ይእዛና ብኢ ያሽቴዛ። ኡንትካ፥ «Ꮊይ ሜሸ» ግ ያሽቲ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ዝን የሱሳ ኤልሲ፥ «አኮ ባያ! ያሽትፓተ! Ꮊይ ታና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ጵጽሮሳ ኤዝኮ፥ «ጎዳዮ፥ ነና ማቅኮ፥ ታ ሃꬃል አፋር የꬊ ኔኮ Ꮊንጎድ ጋርክ ታና አዛዞባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","የሱሳ ጵጽሮሳኮ፥ «Ꮊና የኦባ» ዬጌዛ። ጵጽሮሳ ዎጎሎፕ ዎꬊ ሃꬃይል አፋ የꬍታር የሱሳኮ Ꮊሞ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ዝን ጫርካይ ወልቃ ብኢ ያሽቴዛ። ሃꬃይ ኤዛ ምቶ አይክን «ጎዳዮ፥ ታና አሾዬ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","የሱሳ ኤልሲ ፋ ኩሻ ዳኪ ኤዛ አይኪ፥ «ናት፥ አማኖ ፓጬዛዮ አብስ ስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","የሱሳራኔ ጵጽሮሳራ ዎጎሎ ጋንጨ ገልን ጫርካይ ጭጭርኪ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ዎጎሎ ጋንጨ የዝ ኤ ታማርታይ፥ «ኔኒ ቱማካ ጾስ ናአ» ግ ጎይኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ኡ አባ ፒንጊ ገንሳሬጸ ቢታ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ያ ቢታይል የዝ አሳይ የሱሳና ኤሪ ፋ ሾሮ ሄራ የዝ ኡባይስ ኪታ ዳኬዛ። አሳይ ሀርግንቴዝ አስታ ኡባ ኤዝኮ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ሀርግንቴዝ አስታይ ኤ አፍላ ማንቻ ኣዳ ቦቾዳይስ ኤዛ ዎሴዛ። ቦቼዝ ኡቢታይካ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","የይፕ ጉየ፥ ፐቲ ፐቲ ፈርሳውታይኔ ህገ አስታማርታይ የሩሳላመፕ የሱሳኮ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ነ ታማርታይ አብስ ኑ አድታይ ዎጋ መንꬂ? ኡ ካꬃ ማዳይፕ ቲና ፋ ኩሻ ሜጭንቶያ» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","የሱሳ ማሂ፥ «ይንቲ፥ ይ ዎጋ ግሾስ ጾሳ ኪታ ፖልዛና አብስ እጼ? ");
INSERT INTO mfxe_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","አብስ ጊኮ፥ ጾሳይ፥ ‹ነ አደኔ ነ እንዶ ቦንቾባ። ፋ አደ ዎይ ፋ እንዶ ጫዥዛይ Ꮊይቆ ጌካሳ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ዝን ይ፥ ፐቲ አስ ፋ ኣዳ ዎይ ፋ እንዳት ማዶድ ባዝ የዝን፥ ‹Ꮊያ ታ ጾስስ ያርሼዛ ጊኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ፋ ኣዳ ዎይ ፋ እንዳት ቦንቾዳይስ ቤዞያ› ይ ዬግዛ። ዬዚ ይንቲ፥ ይ ዎጋ ፖሎዳይስ ጾሳ ቃላ መንꬂዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ይንትኖ፥ ጩቢታዮ፥ ኢሳያሳ ይ ባዝ ቱሮ ኦዴዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹Ꮊ አሳይ ታና ፋ ዶናር ቦንችዛ፥ ዝን ኡ ዎዝናይ ታፕ ሃኮ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","አሳይ ታና ጨር ጎይንዛ፤ ኡ አሲ መꬌዝ ዎጋ፥ ጾሳ ህገ ኣዝሲ ታማርስዛ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","የሱሳ ጋመ አስታ ፋኮ ጼጊ፥ «ስኦይታ! አካኮይታ! ");
INSERT INTO mfxe_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","አስ ቱንስዛ ባዛይ ዶናር ገልዝ ባዝ ባዝን ዶናፐ ከዝዝ ባዝ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","የይፕ ጉየ፥ የሱሳ ታማርታይ ኤዝኮ ይኢ፥ «ፈርሳውታይ ኔኒ ኦዴዛ ስኢ ꬉብንቴዛና ነ ኤሬኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ዝን የሱሳ ኡንትኮ ማሂ፥ «ሳሎ የዝ ታ አዳይ ቱከካ ምꬂ ኡባይ ሾድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ኡ ባጋ ህርግፓተ፤ ኡ ቶአ ካልꬂዛይካ ቶእታ። ቶአይ ቶአ ካልꬂኮ፥ ናምእታይካ ጋጋ ቅትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጵጽሮሳ ማሂ፥ «Ꮊ ኣዝሳይስ ብልꬂ ኑስ ኦዶየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","የሱሳ ኡንትኮ፥ «ይንትስካ Ꮊኖ ሄሎዳይስ ገለካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ዶናር ገልዝ ባዝ ኡባይ ኡሎ ገሊ ባለ ከዝዛና ይ ኤሮሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ዝን ዶናር ከዝዝ ባዝ ዎዝናፕ ከዝዛ። አስ ቱንስዛ ባዝታይ Ꮊይትታ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ኡንትካ አስ ዎዝና ጋንጨፕ ከዝዝ ኢታ ቆፋ፥ ዎꬎ፥ ላግተ፥ ላመ፥ ካይዞ፥ ዎርዶ ማርካትꬂ፥ አስ ሱንꬂ ꬋብሶ፥ ጫሸ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","የያ ኣዝዝባዝታይ አስ ቱንስዛፕ አትን ሜጭንተካ ኩሸር ሚዛይ ቱንሶያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","የይፕ ጉየ፥ የሱሳ ኤዛይፕ ከዚ ጽሮሳኔ ስዶና ካታምታይ የዝ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ፐቲ ካናኔ ቢታ አስታ የሱሳኮ ይኢ፥ ፋ ቃላ ꬎቂ ኡዲ፥ «ጎዳዮ፥ ዳዉተ ናአዮ፥ ታስ ቃꬍንቶየ፤ ታ ናአቶ ቱና አያና አይኪ ኢታ ዋይꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ዝን የሱሳ ፐቲ ቃላካ ማሄካዛር ሲኤ አቴዛ። የሱሳ ታማርታይ ኤዝኮ ይኢ፥ «Ꮊ አስታ ኑ ላሳ ካልታር፥ ኡክዛ ግሾስ፥ ነ እዞ ሞይዞዬ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","የሱሳ ማሂ፥ «ታኒ ዉደፕ ꬋቤዝ ዱር ጋርክ እስሬለ ካራፕ ꬋቤዝ አስታይ ኣዳስ ኪትንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ዝን እዛ፥ ኤ ቲና ጹጉኒ፥ «ጎዳዮ፥ ታና ማዶየ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ኤ ማሂ፥ «ናእታይ ካꬃ ኤኪ ካንታይስ ኦሎዳይስ ቤዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","እዛካ፥ «ጎዳዮ፥ የይ ቱማ፥ ዝን ሀራ አቶዝን ካንታይ ፋ ጎድታይ ማዳር፥ ጋይታፕ ዎꬍዝ ጉፋ ሚዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","የሱሳ ማሂ፥ «አስት Ꮊኔ፥ ነ አማናይ ግታ፤ ነ ኮዬዛይ ጋርክ ኔስ ሀኖ» ዬጌዛ። እ ናአታ እዝር ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","የሱሳ የይፕ ደንዲ ጋልላ አባ ላንቀ ቅቴዛ። አምባል አፋ ከዚ፥ ኤዛይድ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ጋመ አሳይ ፋር፥ ዎብታ፥ ቶእታ፥ ስሌዝታ፥ ዶና ሙሜዝታኔ፥ ሀራ ጋመ ሀርግንቴዝ አስታ ኤኪ፥ ኤዝኮ ክኢ ኤ ቲናይድ ጋዴዛ። የሱሳ ኡንታን ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","የይ ግሾስ፥ ሙምታይ ናሾዳር፥ ስሌዝታይ ፓጾዳር፥ ዎብታይ የꬎዳር፥ ቶእታይ በአዳር አሳይ ብኢ Ꮊይ ማላባዝ ግ፥ እስሬለ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","የሱሳ ፋ ታማርታ ፋኮ ጼጊ፥ «Ꮊ ጋመ አሳይ ታር ሀይꬒ ጋላስ ጋምኤዝ ግሾኔ ኡንትስ Ꮊት ሚዝባዝ ባዛይ ግሾስ ታ ኡንትስ ቃꬍንትዛ። ኡ ኦገል ዳቡሪ ፎካም ጋርክ አኮ ሙዘካ ኡንታን ጨር ዳኮዳይስ ታ ኮዮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ኤ ታማርታይ ማሂ፥ «ኑኒ Ꮊ ሊዣይድ Ꮊይ ጋርክ አሳይስ ግድዛ ካꬃ አናፕ ደማዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","የሱሳ ኡንትኮ፥ «ይንትስ ኣፑን ሶሎ የኔ?» ዬጊ ኦይጬዛ። ኡ ማሂ፥ «ላፑን ሶሎኔ ይሸ ሞልታይፕ ጽቃ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","የሱሳ ዎይታ ሳአ በቶይታ ዬጊ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","የይፕ ጉየ፥ የ ላፑን ሶላይራ ሞላ ኤኪ ጾስ ጋላቴዛ። ዱስርꬂ ፋ ታማርታይስ እንጌዛ። ኤ ታማርታይ አሳይስ ግሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","አሳይ ኡባይ ም ምዤዛ። ኤ ታማርታይ፥ ማዳር አቴዝ ጉፋ ላፑን ግታ ሌማተ ኩንꬂ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ሜዝ አሳይ ማችኔ ናአ ፓይደካዝን ꬍራꬅ ኣዳ ኦይዲ ሙኩሎ። ");
INSERT INTO mfxe_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","የሱሳ ዎይታ ዳከዛይፕ ጉየ ዎጎሎ ጋንጨ ገሊ ማጋዶና ግዝ ቢታ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፈርሳውታይኔ ሳዱቃውታይ የሱሳኮ ይኢ። ኤዛ ፋጮዳይስ ኮዪ፥ ፋና ሳሎፕ ማላታ ቤዞ ግ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ዝን ኤ ኡንትኮ፥ «ሳአ ኦማꬆዳር ‹ሳሎ ዞቂ በንትኮ ዎንታ ሳአ ቦቃሎዳ› ይ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ዎንትታር ‹ሳሎ ዞቂ ሻራ አይክኮ Ꮊይኖ እራ ቡኮዳ› ይ ግዛ። የዝን ይ ሳሎ ብኢ ማሊ ኤርዝን ዎደ ብኢ ማሊ ኤሮዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ኢትታይኔ አማኖዋ የለትꬃይ ማላታ ኮይዛ። ዝን ኤስ ዮናሳ ማላታይፕ ሀራ ማላታ እንግንቶያ» ዬጌዛ። የይፕ ጉየ፥ ኡንታን ኤዛይድ አሺ ሀራ አቆ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ኡ አባፕ ሰኮ ፕኖ ፒንጌዝ ዎደ ሶሎ ኤኪ የኦዳና ዶጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","የሱሳ ኡንትኮ፥ «ፈርሳውታይፐነ ሳዱቃውታይ እርሾፕ ናግንቶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ኡንትካ ፋ ጋንጨ፥ «ኤ የያ ጌዛይ ኑ ሶሎ ኤኪ የኤካ ግሾስ ማቃዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","የሱሳ ኡ ቆፋ ኤሪ፥ «ይንታኖ፥ አማኖ ፓጬዝታዮ! ሶሎ ኤከካ የኤዝ ግሾስ ይ ዎል ግዶ አብስ ኦድንቴ? ");
INSERT INTO mfxe_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ꮊተካ ይ አካኮሳ? እችን ሙኩለ አሳይስ እችን ሶሎ ግሼዛኔ ኡ ም ምዥን ይ ኣፑን ሌማተ ኩንꬅ ደንꬄዛኮ ይ ዶጌኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","የይ ጋርከካ፥ ላፑን ሶሎ ኦይዲ ሙኩለ አሳይስ ግሼዛኔ ኡ ም ምዥን፥ ይ ኣፑን ሌማተ ኩንꬅ ደንꬄዛካ ይ አካኮሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ይኬ፥ ታኒ ፈርሳውታይኔ ሳዱቃውታይ እርሾፕ ናግንቶይታ ግ ኦድዛይ ሶሎባጋ ባዛና ይ አካኮሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","የዝን፥ ኤ ታማርታይ የሱሳ ኦድዛይ ሙኑቆ ደንꬆዳይስ ዎꬌዝ እርሾባጋ ባዝን ፈርሳውታይኔ ሳዱቃውታይ ትምርታይፕ ናግንቶ ባጋ ማቄዛና አካኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","የሱሳ ቅሳረ ፍልጶሳ ቢታ ሄሌዝ ዎደ ፋ ታማርታይኮ፥ «አሳይ፥ አስ ናአ ኦና ጌ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ኡንትካ፥ «ፐታይ ፐታይ ጻማቅዛ ዋንሳ፥ Ꮊንክታይ ኤላሳ፥ ማ Ꮊንክታይካ እርማሳ ዎይ ናብታይፕ ፐታ ግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","የሱሳ ማሂ፥ «የዝን፥ ይ ታና ኦና ጌ?» ግ ኡንታን ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ስሞና ጵጽሮሳ ማሂ፥ «ኔኒ ክርስቶሳ፥ ደኦ ጾስ ናአ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","የሱሳ ጵጽሮሳኮ፥ «ዮና ናአ ስሞና፥ ነ አንጅንቴዛያ! Ꮊያ ኔስ ቤዜዛይ ሳሎ የዝ ታ አዳይፕ አትን አስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ታ ኔስ ኦድዛ ጵጽሮሳ፥ ኔኒ ዛላ! ታኒ Ꮊ ዛላይል አፋ ታ ዎሳ ኬꬅ ኬጾዳ። Ꮊይቆ ዎልቃይካ እዞ ጋመና። ");
INSERT INTO mfxe_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ሳሎ ካተትꬅ ቁልፕታ ታ ኔስ እማዳ። ሳአ ነ አጬዝ ባዝ ኡባ ሳሎ ጾስ ካለ አጭንቴዝ ባዝ ማቃዳ። ሳአ ኔኒ ብልኤዝ ባዝ ኡባይ ሳሎ ጾስ ካለ ብልንቴዝ ባዝ ማቃዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","የይፕ ጉየ፥ ኤ፥ ክርስቶሳ ማቄዛና ኦስካ ኦዳማይ ጋርክ ፋ ታማርታ ሚንꬂ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","የ ዎደፕ አይኪ የሱሳ ፋ ታማርታይስ፥ «ታኒ የሩሳላመ Ꮊማዳይስ ቤዝዛ። ኤዛይድ ጋደ ጭምታይፕ፥ ቄሰ ሀላቅታይፐኔ ህገ አስታማርታይፕ ታ መቶ ኤኮዳይስ ቤዝዛ። ኡ ታና ዎꬎዳ፥ ዝን ታኒ ሃይꬒንꬃ ጋላስ Ꮊይቆፕ ደንዶዳ» ዬጊ ጌሺ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጵጽሮሳ የሱሳና ጋጻ ከሲ፥ «ጎዳዮ፥ የይ ሀነና! የይ ጋርክ ባዝ ነና የሻ ሄልፐ!» ዬጊ ጋይሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","የሱሳ ጵጽሮሳኮ ጉየ ማቂ፥ «Ꮊ ጻላሃዮ፥ ታፕ ሃኮባ! ኔኒ አስ ቆፋ ቆፕዛፕ አትን ጾስ ቆፋ ቆፖዋ ግሾስ ታስ ꬉበ ማቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","የይፕ ጉየ፥ የሱሳ ፋ ታማርታይኮ፥ «ኦንካ ታና ካሎዳይስ ኮይዝ ባዝ ማቅኮ ፋና ካዶ፥ ፋ ማዝቃላ ቶኪ ታና ካሎ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ፋ ሸምፖ አሾዳይስ ኮይዝ ኡቢታይ ꬋብስዛ። ዝን ፋ ሸምፖ ታ ግሾስ ግ ኣꬂ እንግዛይ አሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","አሲ አላመ ኩንꬃ ፋባዝ ኡዲ፥ ፋ ሸምፖ ꬋብስኮ ኤዛ አብ ማዴ? ዎይ አሲ ፋ ሸምፖ ዎዞዳይስ አብ እንጎዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","አስ ናአይ ፋ አዳይ ቦንቻይር ፋ ኪታንችታይር የኦዳ። የ ዎደ ፐቲ ፐቲ አꬃይስ ኤ ኦሳት ጋርክ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ታ ቱሮ ኦድዛ፤ አስ ናአይ ካተትꬃይር ማቂ የኦዳር በአድ ሄሎዳይስ Ꮊይዳ ኤቄዝ አሳይፕ Ꮊይቃምዝታይ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ኡሱፑን ጋላሳፕ ጉየ የሱሳ ጵጽሮሳ፥ ያይቆባኔ ኤ እሻ ዋንሳ ፓር ኤኪ ኡ ኣዳ ዳማ አምባል አፋ ከዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ኤዛይድ ኡ ቲና የሱሳ ማላይ ላምንቴዛ፤ ኤ ስናይካ አዋ ጋርክ ፖኤዛ። ኤ አፍላይካ ቦꬅ ፖኦ ጋርክ ፖጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ይኬ፥ ሙሰኔ ኤላሳ ኤዛር ናሾዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ጵጽሮሳ የሱሳኮ፥ «ኑኒ ነ ኮይኮ ፐቶ ኔስ፥ ፐቶ ሙሰሲ፥ ፐቶ ኤላሳስ Ꮊይዳ ሀይꬒ ሻቃራ አጮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ጵጽሮሳ የያ ሀጋ ኦዶዳር ቦꬅ ሻራ ኡንታን ካሜዛ። ሻራይ ጋንጨ፥ «ታና ኡፋይስዛ፥ ታ ቃꬊዛ ናአይ Ꮊያ፥ ኤዛ ስኦይታ!» ዬግዝ ጊርꬂ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","የሱሳ ታማርታይ የያ ስኢ ዳጋሚ ፋ ስናይር ሳአ ጉጲንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ዝን የሱሳ ኡንትኮ ሺቂ ኡንታን ቦቺ፥ «ደንዶይታ፥ ያሽትፓተ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ኡ ꬎቅ ግ በአዳር የሱሳፕ ሀራ ኦናካ በኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ኡ አምባላፕ ዎꬎዳር የሱሳ ኡንትኮ፥ «አስ ናአይ Ꮊይቆፕ ደንዶድ ሄሎዳይስ Ꮊያ ይ በኤዝ ባዛና ኦስካ ኦድፓተ» ግ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","የሱሳ ታማርታይ፥ «የዝን፥ ህገ አስታማርታይ ኤላሳ ክርስቶሳፕ ቲናቲ የኦድ ጌዛይ አብሶ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","የሱሳ ማሂ፥ «ኤ! ኤላሳ ቲናꬊ ይኢ ኡባ ባዝ ሎእꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ዝን ታ ይንትስ ቱሮ ኦድዛ፤ ኤላሳ ቲናቲ የኤዛ። ኡንትካ ኤዛል አፋ ኮዬዝ ባዝ ኦꬂዛይፕ አትን ኤዛ ሻኪ ኤረካያ። የይ ጋርክ አስ ናአይ ኡ ኩሸ መቶ ኤኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","የ ዎደ የሱሳ ጌዛይ ጻማቅዛ ዋንሳ ባጋ ማቄዛና ኡ አካኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ኡ አምባላፕ አሳይኮ ማቄዛን ጋርክ ፐቲ አꬃይ የሱሳ ቲና ቡንቅቲ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«ጎዳዮ፥ ማጋነ ታ ናአይስ ቃꬊንቶየ፤ ኤዛ አግናር አግናር ደንዲ ታማ ጋንጨኔ ሃꬅ ጋንጨ ሾጪ ኦልዝ ኢታ ሀርገ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ነ ታማርታይኮ ታ ክእን፥ ኡ ፓꬆዳይስ ዳንዳኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","የሱሳ ማሂ፥ «ይንታኖ፥ አማኖዋ ዡጫ የለትꬂታዮ አይደ ሄሎዳይስ ታ ይንታር የዞዴ? አይደ ሄሎዳይስ ታ ይንታን ዳንዳኦዴ? አን ናአ Ꮊና ኤኪ የኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","የሱሳ ቱና አያና ቆድን፥ ቱና አያናይ ናአይፕ ከዜዝ፤ የ ሳታተ ናአይ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","የይፕ ጉየ፥ የሱሳ ታማርታይ ፋ ኣዳስ ኤዝኮ ሺቂ፥ «ኑኒ ቱና አያና ከሶዳይስ ዳንዳኤካዛይ አብሶ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ኤ ኡንትኮ፥ «ይንትስ አማኖ ጽቄዝ ግሾሲ። ታ ይንትስ ቱሮ ኦድዛ፤ ሳናፍጨ ኣፈ ጋርክ አማኖ ይንትስ የዛኮ ‹Ꮊ አምባ Ꮊይፕ ደንዲ ገደ ኣꬎባ› ጊኮ ይንትስ ኪትንቶዳ። ይንትስ ዳንዳእንቶዋ ባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ዝን የይ ጋርከዛይ ዎሳፐኔ ጾማፕ አትን ሀራር ከዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","የሱሳ ታማርታይ ጋልላ ቢታ ሺቂ የዝን የሱሳ ኡንትኮ፥ «አስ ናአይ አስ ኩሸ ኣ እንግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ኡንቲ ኤዛ ዎꬎዳ፥ ዝን ኤ ሃይꬒንꬃ ጋላስ Ꮊይቆፕ ደንዶዳ» ዬጌዛ። ኤ ታማርታይካ ኢታ አዛኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","የሱሳራ ኤ ታማርታይራ ቅፍርናሆመ ካታማ ሄሌዝ ዎደ ጾሳ ኬꬃ ጊራ ኤክዝታይ ጵጽሮሳኮ ይኢ፥ «ይ አስታማራይ ዎሳ ኬꬃ ጊራ ጊርነኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጵጽሮሳ ማሂ፥ «ጊርዛ» ዬጌዛ። ጵጽሮሳ ካራ ገሎዳር የሱሳ ቲናቲ፥ «ጵጽሮሳ፥ ኔስ አብ ኣዜ? Ꮊ ሳአ ካተትꬃይ ቃራጸኔ ጊራ ኦፕ ኤክኔ? ጋደ አሳይፐኔ አስ ጋደ አሳፕ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጵጽሮሳ «አስ ጋደ አሳፔ» ግ ማሄዛ። የሱሳ ማሂ፥ «ጋደ አስ ጊራ ጊሮዋ ጉሶ? ");
INSERT INTO mfxe_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ዝን ኡ ꬉብንታማይ ጋርክ አባ Ꮊንጊ ሞሎ አይክዝ ማንጻቆ ኦሎባ። ቲና ነ አይክዝ ሞላይ ዶና ዶዪ ጊራስ ግድዛ ሚሸ ኤኪ ነ ግሾኔ ታ ግሾስ ካንጊ ጊሮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","የ ዎደ የሱሳ ታማርታይ ይኢ፥ «ሳሎ ካተትꬅ ኡባፕ ኣꬍዛይ ኦኖ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","የሱሳ ፐቲ ዱደ ናአ ጼጊ ኡ ጋንጨ ኤሲ Ꮊይ ጋርከ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«ታ ይንትስ ቱሮ ኦድዛ፤ ይ ላምንታምጽኮኔ ዱደ ናአ ጋርክ ሀናም እጽኮ ሳሎ ካተትꬅ ገሎዳይስ የሻ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ይኬ፥ Ꮊ ዱደ ናአይ ጋርክ ፋና ካዉሽዛ ኦንካ ሳሎ ካተትꬅ ኡባፕ ኣꬍዛ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ꮊይ ጋርክ ዱደ ናአ ታ ሱንꬃር ሞክዛ ኦንካ ታና ሞክዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«ዝን ታና አማንዛ Ꮊ ጽቅታይፕ ፐታ ናጋራ ኦꬆድ ጋርክ ꬉበ ማቅዝ ኦንካ ዳማ ዎጻ ፋ ቆል አጪ ጪሞ አባ ጋንጨ ምትንትኮ ኤስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","አላመል አሲ ናጋራ ኦꬆድ ጋርክ ኦꬅዛባዝ የዛ ግሾስ አላመ አየ። የይ ጋርክ ባዝ የኤካ አታሚ፥ ዝን ꬉበ ኤ ባጋር ይእዝ አꬃ አየ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«ነ ኩሸ ዎይ ነ ቶኬ ነና ባልꬅኮ ኔፕ ጋቺ ኦሎባ። ኔኒ ናምኢ ኩሸር ዎይ ናምኢ ቶከር መꬍና ታማ ጋንጨ ዎꬋዳይፕ ኩሸ ዎይ ቶኬ ዱጻ ማቂ መꬍና ደኦ ደንግዛይ ኔስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ማ ነ ኣፋይ ነና ባልꬅኮ እዞ ዎጪ ከሲ ኦሎባ። ኔኒ ናምኢ ኣፈር ጋናመ ታማ ጋንጨ ዎꬋዳይፕ ፐቲ ኣፈር መꬍና ደኦ ገልዛኮ ኔስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«ታ ይንትስ ኦድዛ፤ ሳሎ የዝ ኡንታን ናግዝ ኪታንችታይ ኡባ ዎደ ሳሎ የዝ ታ አዳይ ቲና የዝ ግሾስ ይ Ꮊ ጽቅታይፕ ፐታካ ሌቃም ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","አስ ናአይ ꬋቤዝታ አሾዳይስ የኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ማ የሱሳ፥ «ይንትስ አብ ኣዜ? ፐቲ አꬃይስ ጼት ዱርታይ የዝታይፐ ፐታይ ꬋብኮ ኡዱፉን ታማኔ ኡዱፉንታ አምባል አፋ ኦሊ አሺ የ ꬋቤዛና ኮዮዳይስ Ꮊንጎሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ታ ቱሮ ኦድዛ፤ ኤ ደንጌዝ ዎደ ኡዱፉን ታማኔ ኡዱፉንታይፕ ኣꬃ ꬋቢ በንቴዝ ፐቲ ዱራይል ኡፋይትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","የይ ጋርከካ፥ ሳሎ የዝ ይ አዳይ Ꮊ ጽቅታይፕ ፐታይ ꬋቦድ ጋርክ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«ነ እሻይ ነና ቆህኮ ነ ኣዳስ ኤዝኮ Ꮊንጊ ኤ ቡታ ኤዝስ ኦዶባ። ኤ ነና ስእኮ ነ እሻ ኔስ ሻሎ ኡዶባ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ዝን ኤ ነና ስአም እጽኮ፥ ናምኢ ዎይ ሀይꬒ አስ ማርካር ሞቲ ዎꬍዛ ግሾስ ፐቲ ዎይ ናምኢ አስ ኤኪ ኤዝኮ Ꮊንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ኤ ኡንታን ስአም እጽኮ፥ ዎሳ ኬꬅስ ኦዶባ። ዎሳ ኬꬅ ግዝ ባዝ ስአም እጽኮ አማኖዋ አስ ጋርክ ዎይ ቃራጸ ጋችስዝ አስ ጋርክ ኤዛ ታይቦባ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«ታ ይንትስ ቱሮ ኦድዛ፤ ሳአ ይ አጭዝ ባዝ ኡቢታይ ሳሎ ጾስ ካለ አጭንቴዝ ባዝ ማቃዳ። ሳአ ይ ብሌዝ ባዝ ኡቢታይ ሳሎ ጾስ ካለ ብልንቴዝ ባዝ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«ማካ ታ ይንትስ ኦድዛ፤ ሳአ ይንትፕ ናምእታይ ፐቲ ዎዝናር ማቂ ጾስ ዎስዛ ባዝ ማቅኮ ሳሎ የዝ ታ አዳይ ይንትስ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ታና ካልዝታይፕ ናምኢ ዎይ ሀይꬒ ማቂ ሺቅዛ በሳ ታ ኡ ጋንጨ በንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","የ ዎደ ጵጽሮሳ የሱሳኮ ይኢ፥ «ጎዳዮ፥ ታ እሻይ ታና ቆህኮ ኣፑን ቶኬ ታ አቶ ጎዳይስ ቤዝኔ? ላፑን ቶኬ ሄሎዳይሶኔ?» ግ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","የሱሳ ማሂ፥ «የያ ባያ፥ ላፑን ታም ቶኬ ላፑንፕ አትን ላፑን ቶኬ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«የይ ግሾስ፥ ጾስ ካተትꬃይ ፋ ኦሶ አስታይር ፋ ምሻይ ፓጨዛኮኔ ፉጬዛኮ በአዳይስ ቆፔዝ ካታ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","የ ካታይ ሚሻይ ፓጨዛኮኔ ፉጬዛኮ ብእዛ ዎደ ጋመ ሙኩለ አጮ የዝ ፐቲ አꬃ ኤዝኮ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ዝን የ አይላይ አጫ ጭጎዳይስ ጋምንትን ኤዛ፥ ኤ ማቻትራ፥ ኤ ናእታይራኔ ኤዝስ የዛ ባዝ ኡባይ ባይዝንቲ አጮ ጭግንቶድ ጋርክ ኤዛ ጎዳይ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","የዝን አይላይ ፋ ጎዳይ ቶካይል አፋ ዎꬊ፥ ‹ታ ጎዳዮ፥ ሀያና ጽቃስ ጋምኦዬ፥ ታ ኡባ ጭጎዳ› ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ካታይ ኤዝስ ቃꬍንቲ፥ ዳኪ አሼዛ፤ ኤ አጫካ ማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«ዝን የ አይላይ ከዚ Ꮊንጊ ፋ ላጌ ኦሶ አስታይፕ ፐታይ ኤዛፕ ጽቃ ሚሸ ታልኤዛና፥ ‹ኔል አፋ የዝ ታ ሚሻ ታስ ጭጎባ› ግ አꬃይስ ቆꬋት ጩሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«የ ኤ ላጌ አይላይ ኤ ቶካይል ዎꬊ፥ ‹ሀያና ጽቃል ጋምኦዬ ታ ኔስ ኡባ ጭጎዳ› ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«ዝን እጺ ኤኪ ካንጊ ፋ ላጋይ ኣጫ ጭጎድ ሄሎዳይስ አች ኬꬃ ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","የይ ግሾስ፥ ሀራ ላጌ ኦሶ አስታይ የያ ብኢ ኢታ ይሎቲ፥ Ꮊንጊ ፋ ጎዳይስ ኤ ኦꬄዝ ባዝታ ኡባ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«የዝን ጎዳይ የ አይላ ጼግሲ፥ ‹Ꮊ ኢታ አይላዮ፥ ኔኒ ታና ዎሴዝ ግሾስ ታ ነ አጫ ኡባ ነና ማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","የዝን፥ ታኒ ነ አጫ ማሬዛይ ጋርክ ኔኒ ነ ላጌ ማቄዝ አይላይ አጫ ማሮዳይስ ኔስ ቤዞሳ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","የይ ግሾስ፥ ጎዳይ ኢታ ይሎቲ፥ ኤ ፋ አጫ ኡባ ጭጎድ ሄሎዳይስ ፓꬅ ካእንቶዳይ ጋርክ አች ኬꬅስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«የይ ጋርከ፥ ይ ፐታይ ፐታይ ይ እሻ ዎዝናፕ ማራም እጽኮ ሳሎ የዝ ታ አዳይ ይንታን Ꮊይ ጋርክ ኦꬆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","የሱሳ የያ ኦዲ ሃሴዛይፕ ጉየ ጋልላፕ ደንዲ ዮርዳኖሳ ቦርካፕ ሰኮ ፕኖ የዝ ይሁዳ ቢታ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ጋመ አሳይ ኤዛ ካሊ Ꮊንግን ኡ ጋንጨፕ ሀርግንቴዝ አስታ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ፈርሳወ አስታይ ኤዛ ፋጮዳይስ ኮዪ ኤዝኮ ይኢ፥ «ፐቲ አሲ አባባዝ ግሾስካ ፋ ማቻቶ ዳኮዳይስ ቤዝኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","የሱሳ ማሂ፥ «ጾሲ ቲና ꬍራꬅኔ ማች ኡዲ መꬌዛና ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹የይ ግሾስ፥ ፐቲ አሲ ፋ አደኔ ፋ እንዶ አሺ ፋ ማቻትር ፐቶ ማቅዛ፥ ናምእታይካ ፐቲ አሾ ማቅዛ› ");
INSERT INTO mfxe_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","የይ ግሾስ፥ ኡንቲ ፐቲ አሾ ማቆዳይፕ አትን ናምኤ ማቆያ። ይኬ፥ ጾሲ አጬዛና አሲ ብልፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ፈርሳወ አስታይ፥ «የዝን፥ ሙሰ ፐቲ አስ አንጆ ዋርቃተ እንጊ ፋ ማቻቶ ዳኮዳይ ጋርክ አብስ አዛዜኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","የሱሳ ማሂ፥ «ይንቲ፥ ይ ማችታ ዳኮድ ጋርክ ሙሰ ይንታን አዛዜዛይ፥ ይ ዎዛና ምኖትꬃይ ግሾፕ አትን ቲናፕ የይ ጋርክ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ታ ይንትስ ኦድዛ፤ ፋ ማቻት ላግተካዝን ዳኪ ሀራ ኤክዝ ኦንካ ላምዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ኤ ታማርታይ ኤዝኮ፥ «አዝንኔ ማቺ ባጋ የይ ጋርክ ማቅኮ ኤኮኔ ገሎ አትኮ ሎኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","የሱሳ ማሂ፥ «የይ ጋርክ ትምርታይ ጾሲ ዳንዳአ እንጌዝታይሳፕ አትን አስ ኡቢታይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ይኬ፥ የልንትታር ሲላ ማቂ የልንቴዝታይ የዛ፥ ማ አሲ ቃራቴዝታይ የዛ፥ ማ ሳሎ ካተትꬅ ግሾስ ዬጊ ፋና ሲሊሴዝታይ የዛ። የይ ግሾስ፥ Ꮊያ ኤኮዳይስ ዳንዳእዛ ኦንካ ኤኮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","የሱሳ ፋ ኩሻ ዱደ ናእታይል አፋ ጋዲ ኡንትስ ዎሶድ ጋርክ ፐቲ ፐቲ አሳይ ናእታ ኤዝኮ ከኤዛ። ዝን ኤ ታማርታይ አሳይል ካጭንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ዝን የሱሳ፥ «ጾስ ካተትꬃይ Ꮊይትታይ ጋርከዝታይስ ማቄዝ ግሾስ ዱደ ናእታይ ታኮ ይእዛና ካይፓተ፤ የኦ ጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ፋ ኩሻ ኡንታል አፋ ጋዴዛይፕ ጉየ የ አቃይፕ አሺ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ፐቲ ጋላስ ፐቲ አꬃይ የሱሳኮ ይኢ፥ «አስታማራዮ፥ ታኒ መꬍና ደኦ ደንጎዳይስ አብ ሎኦ ባዝ ኦꬆ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","የሱሳ ኤዝኮ፥ «ሎኦ ባዝ ባጋ ነ ታና አብስ ኦይጨ? ፐቲ ጾሳፕ አትን ሀራ ሎኦ ባያ። ዝን ነ መꬍና ደኦ ኤኮዳይስ ኮይኮ አዛዝታ ናጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","አꬃይ ማሂ፥ «አዛዝታይ ኣይታ?» ዬጊ ኦይጬዛ። የሱሳ ማሂ፥ «ዎꬍፐ፥ ላምፐ፥ ካስትፐ፥ ዎርዶ ማርካትፐ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ነ አዳኔ ነ እንዳቶ ቦንቾባ፥ ነ ላጋ ነ ኡባይ ጋርክ ቃꬎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","የ ፓንꬃይ፥ «ታኒ Ꮊይትታ ኡባ ናአትꬃፕ አይኪ ፖልታር የዛ። የዝን፥ ሀራ ታስ ፓጭዛባዝ አባ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","የሱሳ ማሂ፥ «ነ ፎሎ ማቆዳይስ ኮይኮ Ꮊንጊ ኔስ የዛ ባዝ ባይዚ ማንቅታይስ እንጎባ፤ ኔኒ ሳሎ ዱርቶዳ። ዬዚ ማቂ ይኢ ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ዝን የ አꬃይ ዱረ ማቄዝ ግሾስ የያ ስኢ አዛንታር አሺ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","የይፕ ጉየ፥ የሱሳ ፋ ታማርታይር፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ዱረ ሳሎ ካተትꬅ ገሎዳይ ጋመ መቶ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ዱረ አሲ ጾስ ካተትꬅ ገሎዳይፕ ግማለ ናርፐ ሉኮር ኣꬎዳይ ካዉዥዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","የሱሳ ታማርታይ የያ ስኢ ማላባዝ ግ፥ «የዝን፥ ኦኒ አቶዳይስ ዳንዳኤ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","የሱሳ ኡንታን ዳኪ ብኢ፥ «Ꮊይ አስስ ዳንዳእንቶያ፥ ዝን ጾስስ ኡባይ ዳንዳእንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ጵጽሮሳ ማሂ፥ «ኑኒ ኡባ ባዝ አሺ ነና ካሌዛ። የዝን፥ ኑኒ አብ ደማዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","የሱሳ ኡንትኮ Ꮊይ ጋርከ ዬጌዛ፦ «ታኒ ይንትስ ቱሮ ኦድዛ፤ አስ ናአይ የኦድ አላማይድ ፋ ቦንቾ ዙፋነል በትዛ ዎደ ይ ታጶ ናምእታይ፥ ታና ካሌዝ፥ ታጶ ናምኢ ዙፋነል በቲ ታጶ ናምኢ እስሬለ ዘርꬂታይል አፋ ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ታ ሱንꬃይ ግሾስ ኬꬂታ ዎይ እሽታ ዎይ ምሽታ፥ ዎይ አደ ዎይ እንዶ ዎይ ናእታ ዎይ ፋ ኦሶ ጋደ አሼዛይ ኦንካ ጼት ኩሸ ኤኮዳ። ማ መꬍና ደኦካ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ዝን ጋምታይ ቲንታይ ጉይታ፥ ማ ጉይታይ ቲንታ» ማቃዳ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«ጾስ ካተትꬃይ ፋ ዎይነ ጋንጨ ኦሶ አስታ ኦስሶዳይስ ዎንታ ጉራ ከዜዝ ጋደ ጎዳ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ኤ የ ኦሶ አስታይስ ፐቲ ጋላስስ ፐቲ ዲናረ ጋቾዳይስ ኡንታር ጊጊ፥ ኡንታን ፋ ዎይነ ጋንጨ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«ማ ዎንታፕ ሀይꬒ ሳተ ማቆዳር ከዚ ኦሶ ꬋብን ጋበል አፋ ኤቄዝ ሀራ አስታካ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ኤ ኡንትኮ፥ ‹ይንትካ ታ ዎይነ ጋንጨ Ꮊንጊ ኦꬆይታ፥ ታ ይንትስ ቤዝዛ ዳሞዘ ጋቾዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ኡንትካ Ꮊንጌዛ። ማካ ኤ ኡሱፑን ሳተራኔ ኡዱፉን ሳተር ከዚ Ꮊይ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ታጶ ፐቲ ሳተ ማቅን ኤ ከሳዳር Ꮊንክታ ኤቄዝታ ደንጊ፥ ‹ይ ኦሶ ኦꬄካ ጋላስ ሙዳ Ꮊይዳ አብስ ኤቂ ፔዤኔ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«ኡ ማሂ፥ ‹ኑና ኦስስዛ አሲ ꬋቤዝ ግሾስ› ዬጌዛ። «ኤዚ፥ ‹ይንትካ ታ ዎይነ ጋንጨ Ꮊንጊ ኦꬆይታ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«ሳአ ኦማꬅን፥ ዎይነ ጎዳይ ኦሶ አስታይ ሀላቃይኮ፥ ‹ኦሶ አስታ ጼጊ ጉየፕ ኦሶ ገለዝታይፕ አይኪ ቲና ገሌዝታ ሄሎዳይስ ኡንትስ ዳሞዘ ጋቾባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ታጶ ፐቲ ሳተር ኦሶ አይኬዝታይ ይኢ፥ ኦማር ኦማር ፐቲ ፐቲ ድናረ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ቲና ኦሶ አይኬዝታይ ይኢ፥ ፓስ ጋመ እንግንቶዳ ግ ቆፔዛ። ዝን ኡንትካ ኦማር ኦማር ፐቲ ፐቲ ድናረ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ፋ ሚሻ ኤኪ ማቂ ጋደ ጎዳይል አፋ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Ꮊይትታይ ጉየፕ ይኢ ፐቲ ሳተ ኣዳ ኦꬄዛ። ዝን ጋላስ ሙዳ አዋ ምሻር ዳቡሪ ፔዤዝ ኑር ኡንቲ ዋይዚ ፐቶ ማቆደ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«ዎይኔ ቱኬዝ ጎዳይ ኦሶ አስታይፕ ፐታይኮ፥ ‹ታ እሻዮ፥ ታኒ ነና ቆሄካያ፤ ነ ታር ጊግንቴዛይ ፐቲ ዲናረስ ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ነ ግሽቶ ኤኪ ነ ካራ ቅቶባ። ታ ኦማꬅ የኤዛይስካ ኔሳይ ጋርክ እማዳይስ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ታኒ ታ ሚሻይር ኮዬዝ ባዝ ኦꬆዳይስ ታስ ማዉተ ባሳ? ዎይ ታኒ ኬሃ ማቄዝ ግሾስ ነና ቅናትስኔ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«የይ ጋርክ Ꮊተ ጉይታይ፥ ቲናቶዳ ማ ቲንታይ ጉይቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","የሱሳ የሩሳላመ Ꮊንግታር፥ ታጶ ናምኢ ታማርታ ዱማ ጋጻ ከስ ኡንትኮ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ዬዛኮ፥ ኑኒ Ꮊት የሩሳላመ Ꮊሞል አፋ የዛ። ኤዛይድ አስ ናአይ ቄሰ ሀላቅታይስኔ ህገ አስታማርታይስ ኣꬂ እንግንቶዳ። ኡንትካ ኤዛል አፋ Ꮊይቆ ፕርደ ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ኤዛ አይሁደ ባ ዎያስ ኣꬂ እማዳ። ኡንቲ ኤዛ ካዉሾዳ፥ አላንጎዳ፥ ኤዛ ማዝቃለል አፋካ ሶቶዳ። ዝን ኤ ሃይꬒንꬆ ጋላስ Ꮊይቆፕ ደንዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","የ ዎደ ዛብዶሳ ማቻት ፋ ናምኢ ꬍራꬅ ናእታይር የሱሳኮ ይኢ፥ ኤ ቲናይድ ቡንቂቲ ፐትባዝ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","የሱሳ እዝኮ፥ «ነ አብ ኮዬ?» ዬጌዛ። እዛ ማሂ፥ «ነ ካተትꬃይድ Ꮊ ታ ናምኢ ናእታይፕ ፐታይ ኔስ ኡሻቻ ፐታይ ነ ሀድርሳ በቶ ጎየ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ዝን የሱሳ ማሂ፥ «ይ አብ ዎስዛኮ ኤሮያ፤ ታኒ ኡዦዳይስ የዝ መቶ ጹአ ኡዦዳይስ ዳንዳእኔ?» ዬጌዛ። ኡንትካ፥ «ኤ ኑ ዳንዳእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","የሱሳ፥ «ቱማ ታ ኡዦዳይስ የዝ ጹአይፐ ይንቲ ኡዦዳ። ዝን ታ ኡሻቻኔ ሀድርሳ በቶድታና ዶሬዛይ ታና ባያ። የ አቃይ እንግንትዛይ፥ ታ አዳይ እማዳይስ ጊግሴዝ አስታይሲ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","አቴዝ ታጲ ኤ ታማርታይ የያ ስኢ ናምኢ እሽታይል አፋ ካጭንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ዝን የሱሳ ኡንታን ኡብታ ጼጊ Ꮊይ ጋርክ ዬጌዛ። «አይሁደ ባ አሳ አቅስዝታይ ፋ አሳል አፋ ጎዳትዛነ ኡንታን ካልꬅዝታይ ዎልቃር አቅስዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ዝን ይ ጋንጨ Ꮊይ ጋርክ ማቅፐ። ይንትፕ ባይራትꬅ ኮይዝ ኦንካ ይንትስ አይለ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ይ ጋንጨ ኡባይፕ ኣꬅ ማቆዳይስ ኮይዝ ኦንካ ይንትስ አይለ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","የይ ጋርከካ፥ አስ ናአይ አስ ማዶዳይስኔ ጋመ አስ ዎዞዳይስ ፋ ሸምፖ እማዳይስ የኤዛፕ አትን አሳር ማድንቶዳይስ የኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","የይፕ ጉየ፥ የሱሳ ፋ ታማርታይር ኢያርኮፕ ከዚ Ꮊማዳር፥ ጋመ አሳይ ኡንታን ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ኦገ ጋጻ በቴዝ ናምኢ ቶእታይ የሱሳ ኤዛይር ኣꬍዛና ስኢ፥ «ጎዳዮ፥ ዳዉተ ናአዮ፥ ኑስ ቃꬍንቶየ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ጋመ አሳይ ኡንታን፥ «ሀይዞይታ» ዬጊ ቆዴዛ። ዝን ኡንቲ፥ «ጎዳዮ፥ ዳዉተ ናአዮ፥ ሀያና ኑና ማሮየ» ግ ጉጂ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","የሱሳ ኤቂ፥ ኡንታን ጼጊ፥ «ታ ይንትስ አብ ኡዶድ ጋርክ ኮይኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ኡንትካ፥ «ጎዳዮ፥ ኑ ኣፋይ በአዳይ ጋርክ ኑ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","የሱሳ ኡንትስ ቃꬍንቲ፥ ኡ ኣፋ ቦቼዛ። ኤልሲ ኡ ኣፋይ ብእን፤ ኡ ኤዛ ካሊ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","የሱሳራ ኤ ታማርታይራ የሩሳላመ ኡኪ፥ ደብረ ዛይተ አምባል አፋ የዝ ቤተፋገ ግዝ ሄራ ሄልታር፥ የሱሳ ፋ ታማርታይፕ ናምእታ ፓፕ ቲና ኪቴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«ይ ቲና የዝ ሄራ Ꮊንጎይታ። ኤዛይድ ፐቲ ሀረ አቻ የዛኖ እ ናአይራ ይ ኤልሲ ደማዳ። ኡንታን ብሊ Ꮊና ኤኪ የኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ኦንካ ይንታን ኦይጭኮ፥ ‹ጎዳይ ኡንታን ኮይዛ› ዬጎይታ። ኤ ኡንታን ኤልሲ ዳኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ናባይ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ጽዮነ ካታማ፥ ‹ይኬ፥ ነ ካታይ አሽከ ማቂ፥ ሀረል አፋኔ ሀረ ናአል አፋ በቲ፥ ኔኮ ይእዛ› ዬጎይታ» ዬጊ ጻፌዛይ ፖልንቶድ ጋርክ የይ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ኤ ታማርታይ Ꮊንጊ የሱሳ ኡንታን አዛዜዛይ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ሀርቶኔ ሀረ ናአ ክኢ አፋር ማኤዝ ፋ አፍላ ኡ ዞካይል ኦሌዛ። የሱሳ አፍላይል አፋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ዎያይ ፋ አፍላ ኦገል ሂጼዛ። Ꮊንክታይ ሀራታ ሻቂ ኦገል ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","የሱሳፕ ቲናር የꬍዝታይኔ ኤዛፕ ጉየር ካልዛ ዎይታይ፥ «ሆሳና! ዳዉተ ናአይ ጋላትንቶ! ጎዳይ ሱንꬃር ይእዛይ አንጅንቴዛያ! ቦንቾ ኡባፕ ꬎቃ ሳሎ ጾሳይስ ማቆ!» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","የሱሳ የሩሳላመ ካታማ ገሌዝ ዎደ የ ካታማ የዝ አስ ኡቢታይ፥ «Ꮊይ ኦኖ?» ዬጊ ሻርክሻርኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","አሳይ፥ «Ꮊይ ጋልላ ቢታ የዝ ናዝረተ ካታማፕ የኤዝ ናበ የሱሳበ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","የሱሳ ጾስ ኬꬅ ገሊ፥ ኤዛይድ ባይዝዝታኔ ዎንግዝታ ኡባ ባይኢ ባለ ከሴዛ። ሚሸ ላምዝታይ ጻርጴዝታኔ ሆልታ ባይዝዝታይ ኦይዲታ ሽሪ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ኤዝካ ኡንትኮ፥ «ጾስ ቃላይድ፥ ‹ታ ኬꬃይ ጾስ ዎስዛ ኬꬅ ግንትንቶዳ› ዬግንቲ ጻፍንቴዛ። ዝን ይ ፓንታይ ቆስንትዝ ኮምኦ ኡዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","የሱሳ ጾስ ካራ ጋንጨ የዝን ቶእታይኔ ጉንዴዝታይ ኤዝኮ ይእን ኡንታን ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ዝን ቄሰ ሀላቅታይኔ ህገ አስታማርታይ የሱሳ ኦꬄዝ ማላትታ ብእዝታይኔ ጽቃ ናእታይ ጾስ ኬꬅ ጋንጨ፥ «ዳዉተ ናአይ፥ ጋላትንቶ» ዬጊ ኡክዛና ስኢ ካጭንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ኡ የሱሳኮ፥ «Ꮊይትታይ ግዛ ነ ስእኔ?» ዬጌዛ። የሱሳ፥ «ኤ ስእዛ፥ ጾስ ቃላይድ፥ ‹ዱደ ናእታይ ዶናኔ ꬋንግዝ ናእታይ ዶና ጋላታ ኩንꬄዛ› ዬግንቲ ጻፍንቴዛና ይ ናባበካሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ኡንታን እዘ አሺ ብታና ካታማ Ꮊንጊ አቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","የሱሳ ዎንታ ጉራ ካታማ ማቂ ይእታር ናይንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ኦገ ጋጻ ፐቲ ባላሰ ምꬃቶ ብኢ እዝኮ Ꮊንጌዛ። ዝን ሀየፕ አትን ሀራ አብካ ደንገካያ። የይ ግሾስ፥ እዞ፥ «Ꮊንፕ መꬍናስ ኔፕ ኣፈ በንትፐ!» ዬጌዛ። የ ባላሰ ምꬃታ እዝር መሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ኤ ታማርታይ የያ ብኢ፥ «Ꮊ ባላሳት ዋይዚ ኤልሲ መላረ?» ዬጊ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","የሱሳ ማሂ፥ «ታኒ ይንትስ ቱማ ኦድዛ፤ ይንትስ አማኖ ዬዛኮ፥ ማ ይ ስꬋምጽኮ ባላሰል አፋ ታኒ ኦꬄዛን ጋርክ ኣዳ ኦꬃሚ፥ ዝን ‹Ꮊ አምባ ሾድንቲ አባ ጋንጨ ዎꬎባ› ዬግኮ ይንትስ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","አማኒ ይ ዎስዛ ባዝ አባባዝ ማቅኮካ ይ ኤኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","የሱሳ ጾሳ ኬꬃ ገሊ ታማርሶዳር፥ ቄሰ ሀላቅታይኔ አይሁደ ጭምታይ ኤዝኮ ይኢ፥ «ኔኒ Ꮊያ ኡባ አባ ማዉተር ኦꬄ? ኔስ Ꮊ ማዉታ እንጌዛይ ኦኖ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","የሱሳ ኡንትኮ፥ «ታንካ ይንታን ፐትባዝ ኦይጭዛ፤ ይ ታስ እዞ ማህኮ፥ ታኒ አባ ማዉተር ኦꬄዛኮ ይንትስ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ዋንሳ ጻማቆድ ጋርክ ማዉታይ አናፕ እንግንቴኔ? ጾሳፐኔ አሳፔ?» ዬጌዛ። ኡንቲ ዎል ጋንጨ ቶቢ፥ «ኑኒ፥ ‹ጾሳፕ› ጊኮ፥ ኤ ኑና፥ ‹የዝን አብስ አማነካሳ?› ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ኑኒ፥ ‹አሳፔ› ጊኮ፥ አሲ ኡባይ ዋንሳና ናበ ኡዲ ብእዛ ግሾስ ዎያይ ኑና ያሽዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","የይ ግሾስ፥ «ኑኒ ኤሮያ» ዬጊ ማሄዛ። ኤዝካ፥ «ይኬ፥ ታንካ Ꮊያ አባ ማዉተር ኦꬄዛኮ ይንትስ ኦዳሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«የሱሳ ማቅካ Ꮊይ ጋርክ ዬጌዛ፦ ፐቲ አꬃይስ ናምኢ ꬊራꬅ ናእታይ የዛ። የ አꬃይ ባይራ ናአይኮ Ꮊንጊ፥ ‹ታ ናአዮ፥ Ꮊይኖ ዎይነ ጋንጨ Ꮊንጊ Ꮊንቶባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ናአይ ማሂ፥ ‹ኢእኖ Ꮊንጋሚ› ዬጌዛ። ዝን ጉየፐ ፋ ዎዝናር ቆፒ ኤኪ Ꮊንቶዳይስ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","አዳይ ፋ ጉየ ናአይኮ Ꮊንጊ፥ ፋ ባይራ ናአይኮ ጌዛይ ጋርክ አዛዜዛ። ኤዝካ፥ ‹ኤሮ፥ ታ አዳዮ› ዬጌዛ። ዝን Ꮊንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ꮊ ናምኢ ናእታይፕ ፋ አዳይስ አዛዝንቴዛይ ኣያ?» ዬጌዛ። ኡንትካ፥ «ባይራ» ዬጌዛ። የሱሳ ኡንትኮ፥ «ታ ይንትስ ቱማ ኦድዛ፤ ቃራጸ ጋችሽዝታይኔ ላምዝታይ ይንትፕ ቲናቲ ጾስ ካተትꬃ ገሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ጻማቅዛ ዋንሳ ሉሎ ኦገ ታማርስታር ይእን ኤ ግዛና ይ አማነካያ። ዝን ቃራጸ ጋችስዝታይኔ ላምዝታይ አማኔዛ። ይ ሀራ አቶዝን፥ ኡንታን ብእካ ይ ናጋራይፕ ማቂ አማነካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ማካ የሱሳ Ꮊይ ጋርክ ዬጌዛ፤ «ሀራ ኣዝሶ ስኦይታ፥ ዎይነ ቱኬዝ ፐቲ አꬃይ የዛ። የ ዎይነ ጋጻና ጋሴዛ። ዎይነ ቡልዝ ኦላካ ቦኬዛ። ዎይና ናጎዳይስ ሻኮካ ኮቼዛ። የይፕ ጉየ፥ ጋዳ ማታየ እንጊ ሀራ ጋደ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ዎይነ አፋ ማጽዛ ዎደ ሄልን ፋና ሄልዛ ባጋ ኤኪ የኦድ ጋርክ ፋ አይልታ ኡንትኮ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ማታየ ኤኬዝታይ ኤ አይልታ አይኪ ፐታ Ꮊꬌዛ፥ Ꮊንካ ዎꬌዛ ማ አቴዛና ሹቻር ሾጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ዎይነ አታክልተ ጎዳይ ካሴስታይፕ ጋመ ሀራ አይልታ ኪቴዛ። ማታየ ኤኬዝታይ ኡንታል ጉጅካ Ꮊንክታይል አፋ ኦꬄዛይ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ዉርስꬃል ኤ፥ ‹ታ ናአ ኡ ቦንቾዳ!› ዬጊ ፋ ናአ ኡንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«ዝን ማታየ ኤኬዝታይ ናአ ብኢ ዎል ጋንጨ ‹ጋዳ ላቶዳይ Ꮊያ፥ ኤዛ ዎꬊ ጋዳ ኑኒ ኤኮዳ!› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ናአ አይኪ ዎይነ ጋንጨፐ ጋጻ ከሲ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«ይኬ፥ ዎይነ አታክልተ ጎዳይ ይኢ የ ማታየ ኤኬዝታ ዋይሳዴ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ኡ ማሂ፥ «ኤ የ ኢታ አሳ ኢታ ዎꬎ ዎꬊ፥ ዎይናይ ካእዝ ዎደ ኤዛ ሄልዝ ባጋ ዎደር ዎደር እንግዛ ሀራ አስስ እማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","የሱሳ ማሂ ኡንትኮ፥ ጾሳ ቃላይ፥ «‹ግምቢዝታይ ቦሪ እጼዝ ሹቻይ፥ ኬꬄ ሙመር ቶክዛ ክርክሮ ጋርክ፥ ኡባፕ ኣዝ ሹች ማቄዛ። Ꮊይ ጎዳይ ኦꬄዝ ባዝ፤ ኑ ኣፋይስካ ማላ ባዝ› ዬግንቲ ጻፍንቴዛና ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«የይ ግሾስ፥ ታ ይንትስ ኦድዛ፤ ጾሳ ካተትꬃይ ይንትፕ ኤክንቲ ሎኦ ኣፈ ኣፍዝ አስታይስ እንግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ꮊ ሹቻይል አፋ ዎꬌዝ ኡቢታይ መቅቶዳ። ማ የ ሹቻይ ኤዛል አፋ ዎꬌዝ አꬃይካ ጋጭንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ቄሰ ሀላቅታይኔ ፈርሳውታይ የሱሳ ኦዴዝ ኣዝሶ ፋና ኦዴዛና ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ኡ የሱሳ አይኮዳይስ ኮዬዛ፥ ዝን አሳይ የሱሳ ናበ ኡዲ ብእዛ ግሾስ አሳይስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","የሱሳ Ꮊተካ አሳይስ Ꮊይ ጋርክ ዬጊ ኣዝሶ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ሳሎ ካተትꬃይ ፋ ናአይስ ቦስ ማኬዝ ካታ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","የ ካታይ ቦስ የኦዳይ ጋርክ ኦዴዝ አሳ ጼጎዳይስ ፋ አይልታ ኪቴዛ። ዝን አሳይ የኦዳይስ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ማ ሀራ አይልታ ጼጊ፥ ጼግንቴዝ አስታይኮ Ꮊንጊ፥ ‹ታኒ ታ ሳንግታኔ ሞꬌዝ መህታ ሹኬዛ፤ ኡባ ባዝ ጊጌዛ። ታ ቦሳይኮ የኦይታ ዬጎይታ› ዬጊ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ዝን ጼግንቴዝታይ ጼሳ እጺ፥ ፋ Ꮊንታስ Ꮊንታስ ቅቴዛ። ፐታይ ፋ ዎታስ፥ Ꮊንካይ ፋ ዛልኤስ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ꮊንክታይ ማ ካታይ አይልታ አይኪ፥ ካዉሽሽ Ꮊꬊ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«ካታይ ኢታ ሸንቲ፥ ፋ ዎታዳርታ ዳኪ ሸምፖ ዎꬍዝታ ዎꬍሴዛ፥ ኡ ካታምቶካ ጹጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","የይፕ ጉየ፥ ፋ አይልታይኮ፥ ‹ቦሳይ ጊጌዛ፥ ዝን ጼግንቴዝታይ ቦሳይስ ቤዝዛ አስታ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","የይ ግሾስ፥ ዳሞ ጎሳ አይኪ Ꮊንጊ፥ ደንጌዝ አስ ኡብታ ቦሳ የኦድ ጋርክ ጼጎይታ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","አይልታይ ኦገል ከዚ ፋ ደንጌዝ አስ ኡባ ሎእታኔ ኢትታ ክኢ ቦሳ ሻቃራ ገልሲ ኩንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«ዝን ካታይ ሙንታ ማዳይስ በቴዝ አሳ በአዳይስ ገሎዳር ቦስ አፍላ ማኤካ ፐቲ አስ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ኤዝኮ፥ ‹ናት ነ ቦስ አፍላ ማኤካዛር ዋይዚ Ꮊይዳ ገሌኔ?› ዬጌዛ። ዝን አꬃይ ስኤ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«ካታይ ፋ አይልታይኮ፥ ‹Ꮊ አꬃይስ ኩሻኔ ቶካ አጪ፥ ባለ ꬉማ ከሲ ኦሎይታ። ኤዛይድ ኤዝስ ዬፎኔ አች ጮንቺ ማቃዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«የይ ጋርክ፥ ጾስ ካተትꬃይስ ጼግንቴዝታይ ጋመ ዝን ዶርንቴዝታይ ጽቃ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","የይፕ ጉየ፥ ፈርሳውታይ Ꮊንጊ፥ የሱሳ ዋይዚ ኦዳር አይኮዳዛኮ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ፋ ታማርታኔ ሄሮዶሳ ባግታይፕ ፐታ ፐታ ኪቴዛ። ኡንትካ፥ «አስታማራዮ፥ ነ ቱሮ ኦድዛና ኑ ኤርዛ። ኔኒ አሳፕ አስ ሻኪ ኤሮያ፥ አሲ ዋጎዴ ግ አብካ ኦꬂ ኤሮያ፥ ጾስ ኦገ ቱሮራ ታማርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","አን ኑስ ኦዶባ፥ ኑኒ ኦሮመ ካታይስ ጊራ ጊሮዳይስ ቤዝነኔ ቤዞሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ዝን የሱሳ ኡ ኢታ ቆፋ ኤሪ፥ «Ꮊ ጩቢታዮ፥ ታና አብስ ፓጬ? ");
INSERT INTO mfxe_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ጊራ ጊርዛ ሚሽቶ ታና ቤዞይታ» ዬጌዛ። ኡንትካ ኤዝስ ድናረ ክኢ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ኤ፥ «Ꮊ ሱንꬃይኔ ማላይ ኦ ባዞ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ኡንቲ፥ «ሮመ ካታይሲ» ዬጌዛ። የሱሳ ኡንትኮ፥ «የዝን፥ ካታይስ ቤዝዛና ካታይስ፥ ጾስስ ቤዝዛና ጾስስ እንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ኡ የያ ስኢ ማላ ባዝ ግ አሺ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","የ ጋላስ Ꮊይቆፕ ደንዶ ባያ ዬግዝ ሳዱቃውታይ የሱሳኮ ይኢ፥ ዬጊ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«አስታማራዮ፥ ‹ሙሰ፥ ፐቲ አሲ ማቾ ኤኪ ናአ የለካዛር Ꮊይቅኮ፥ የ Ꮊይቄዛይስ እሻይ ኤ ማቻቶ ኤኪ፥ ፋ እሻይስ ናአ የሎ› ዬጊ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ኑ ኤርዛ ላፑን እሽታይ የዛ። ባይራይ ማቾ ኤኪ ናአ የለካዛር Ꮊይቄዛ። ኤ ማቻቶ ኤ ካሎ እሻይ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","የይ ጋርከካ፥ የ አስቶ ኤኬዝ ናምአንꬆይካ፥ ሃይꬒንꬃይካ፥ Ꮊንጊ ላፑንታይ ዉሮድ ጋꬆ ኡቢታይ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ኡባፕ ዉርስꬆል የ አስታካ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","የዝን፥ ላፑንታይ ኡቢታይ እዞ ኤኬዝ ግሾስ Ꮊይቆፕ ደንድዛ ጋላስ፥ የ አስታ ላፑንታይፕ ኣያይስ ማቾ ማቃዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","የሱሳ ማሂ፥ «ይ ጾስ ቃላይ ታማርሴዝ ባዝ ዎይ ኤ ዎልቃ ኤሮዋ ግሾስ ባልንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","አሳይ Ꮊይቆፐ ደንድዛ ዎደ ሳሎ የዝ ኪታንችታይ ጋርክ ማቆዳይፕ አትን ኤኮያኔ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ማ Ꮊይቄዝ አሳይ Ꮊይቆፕ ደንዶድ ባዝ ጾስ ይንትስ ኦዴዛና ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ጾሳይ፥ ‹ታኒ አፍራመ ጾስ፥ እሳቃ ጾስ፥ ያይቆባ ጾስ› ዬጌዛ። የይ ግሾስ፥ ጾሳይ ፓꬂ የዝታይ ጾሳፕ አትን Ꮊይቄዝታይ ጾስ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ጋመ አሳይ የያ ስኢ፥ ኤ ትምርታ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","የሱሳ ሳዱቃውታይስ ጎድባዝ ꬋብሴዛና ፈርሳውታይ ስኢ ዎላ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ኡ ጋንጨፕ ፐቲ ህገ አስታማራይ የሱሳ ፓጨ ኦይች ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«አስታማራዮ፥ ህገ ኡባይፕ ኣꬍዛይ ኣያ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","የሱሳ ማሂ፥ «‹ነ ጎዳ፥ ነ ጾሳ፥ ነ ኩንꬅ ዎዝናይፕ፥ ነ ኩንꬅ ሸምፖፕ፥ ነ ኩንꬅ ቆፋፕ ቃꬎባ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ኡባፕ ኣꬍዛይኔ ባይራ ኪታይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ናምእንꬆ ኡባይፕ ኣꬍዝ ኪታይ፥ አስ ኡባ ነ ነና ዶስዛይ ጋርክ ዶሶባ› ዬግዛያ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ሙሰ ህጋይኔ ናብታይ ትምርታይ ኡባይ Ꮊ ኪትታይል አፋ ካትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፈርሳውታይ ፐትፕ ሺቂ የዝን፥ የሱሳ ኡንታን፥ ");
INSERT INTO mfxe_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«ክርስቶሳ ባጋ ይ ዋጌ? ኤ ኦ ናአ?» ዬጊ ኦይጬዛ። ኡ፥ «ኤ ካታ ዳዉተ ናአ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","የሱሳ ኡንትኮ፥ «የዝን፥ ዳዉተ ጌሻ አያናር ማቂ ዋይዚ ክርስቶሳ፥ ‹ጎዳ› ግ ጼጌ? ዳዉተ ጊታር፥ ");
INSERT INTO mfxe_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","« ‹ጾሳይ፥ ታ ጎዳይኮ፥ ነ ሞርክታ ነ ቶካይስ የꬍዝ አቆ ኦꬆድ ጋꬆ፥ Ꮊይዳ ታፕ ኡሻች ባጋር በቶባ› ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ይኬ፥ ዳዉተ ክርስቶሳ ጎዳ ግ ጼግኮ፥ ዋይዚ ክርስቶሳ ዳዉተ ናአ ማቄ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","የሱሳስ ፐቲ ቃላ ማሆዳይስ ዳንዳኤዝ አስ ኦንካ ባያ። ማ የ ጋላሳፕ አይኪ ሀራ ኦይች ኦይጮዳይስ ኦንካ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","የይፕ ጉየ፥ የሱሳ ዎያስኔ ፋ ታማርታይስ Ꮊይ ጋርክ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ህገ አስታማርታይኔ ፈርሳወ አሳይ ሙሰ ህገ ታማርሶዳይስ ሙሰ ኦይደላ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","የይ ግሾስ፥ ኡ ይንታን አዛዝዛ ባዝ ኡብታ ኦꬆይታኔ ናጎይታ። ዝን ኡ ኦꬂዛይ ጋርከ ኦꬂፓተ። አብስ ጊኮ፥ ኡ ኦድዛይ ጋርክ ኦꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ኡንቲ ቶክን ደንዶዋ ዴጾ ቶፎ አጪ አስ ቶስዛ። ዝን ፓስ ሀራ አቶዝን፥ የ ቶፋ አሳይ ቶኮዳር ፋ ኩሸ ግልአ ጼራር ቦቾዳይስ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«ዝን ኡ ፋ ኦሶ ኡባ አሲ በአዳይ ጋርክ ኦꬂዛ። ፋ ስኖላኔ ቀሴል አጭዝ ማጻፈ ጽቅሰ የዝ ኪታፐ ዳልግስዛ፥ ፋ አፍላ ማንቻ አዱስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ሞክንትዛ አቆ ቦንቾ አቆኔ አይሁድታይ ዎሳ ኬꬅ ጋመ ሎእዛ ኦይደ ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","አሳይ ጋበ ጋንጨ ኡንታን ቦንቾር ሳሮꬆዳናኔ ‹አስታማራዮ› ግ ጼጎድ ጋርክ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«ዝን ይ አስታማራይ ፐታይ ኣዳ ማቄዝ ግሾኔ ይ ኡቢታይ ኤ እሽታ ማቄዝ ግሾስ ‹አስታማራዮ› ግንትንቲ ጼግንትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ይንትስ ሳሎ ፐቲ አዳይ ኣዳ የዝ ግሾስ Ꮊ ሳአ ኦናካ ‹አዳዮ› ግ ጼግፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ይንትስ ፐቲ ጎዳይ ክርስቶሳ ኣዳ የዛ ግሾስ ‹ጎዳ› ግንትንቲ ጼግንትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ይንታፕ ኣꬍዛይ ይንትስ አይለ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ፋና ꬎቅ ኡድዝ ኦንካ ካዉዦዳ፤ ፋና ካዉዥስዛ ኦንካ ꬎቂ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«ይንታኖ፥ ጩቢታዮ፥ ህገ አስታማርታይኔ ፈርሳዉታዮ፥ አስ ቲና ሳሎ ካተትꬅ ጎርድዝታዮ ይንታን አየ። ይንቲ፥ ይ ኡባስ ገላሚ ማ Ꮊንክታካ ገልሳሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ይንታኖ ጩቢታዮ፥ ህገ አስታማርታይኔ፥ ፈርሳዉታዮ፥ አምእታይ ኬꬅ ይ ቦንቂታር፥ አሲ ቦኦ ግ ዎሳ አዱስዛ። የይ ግሾስ፥ ይንታን አየ። ኡባፕ ኣꬍዝ ፕርዳይ ይንታን ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«ይንታኖ፥ ጩቢታዮ፥ ህገ አስታማርታይኔ ፈርሳዉታዮ፥ ይንቲ ፐቲ አꬃ አማንꬆዳይስ አባራኔ ሳአር ዩይዛ። ዝን ይ ኤዛ አማንꬄዝ ዎደ የ አꬃ ይንትፕ ኣꬃ ጋናመስ ጊግስዛ ኦሶ ኦꬍዛ ግሾስ ይንታን አየ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«ኦንካ ጾስ ኬꬅ ጫቂኮ አኮካ ባያ። ዝን ጾስ ኬꬅ የዝ ዎርቃ ጫቂኮ፥ የ ጫቃይ ኤዝስ ጎሞዳ ግዝ ቶእታዮ፥ ይ ይ ኡባስ ቶኢ ሀራ አስ ካልꬅዝታዮ፥ ይንታን አየ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ይንታኖ፥ ቦዝታዮ፥ ቶእታዮ፥ ዎርቃይ ኣꬍነኔ? ዎርቃ ጾሳይስ ዱማስዛ ጾስ ኬꬃይ ኣꬌ? ");
INSERT INTO mfxe_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ማ ‹ኦንካ ያርሾ ያርሽዛ አቆ ጫቂኮ፥ አኮካ ባያ። ዝን ኦንካ ኤዛል አፋ የዛ ያርሻ ጫቂኮ፥ የ ጫቃይ ኤስ ጎሞዳ› ዬጊ ታማርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ይንታኖ፥ ቱልታዮ ቶእታዮ፥ ያርሾ ኣꬍነኔ? ያርሾ ጾሳይስ ዱማስዛ አቃይ ኣꬌ? ");
INSERT INTO mfxe_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","የይ ግሾስ፥ ያርሾ አቃይር ጫቂዛ አꬃይ፥ የ ያርሾ በሳይዳነ ኤዛል አፋ የዛ ኡባባዛል ጫቂዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ጾስ ኬꬅ ጫቂዛ አꬃይ፥ የ ጾስ ኬꬅ ግዶኔ ኤዛይድ የዛ ጾሳ ጫቂዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ሳሎ ጫቂዛ አꬃይ ጾስ ዙፋናኔ የ ዙፋናይል አፋ በትዝ ጾሳ ጫቂዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«ይንታኖ፥ ጩቢታዮ፥ ህገ አስታማርታዮኔ ፈርሳዉታዮ፥ ይንታን አየ። ይ ካርꬅ ጋላፕ፥ ሻሽንቸፐኔ ቦꬅ ጋላፕ አስራታ ከስዛ። ዝን ህጋይድ የዝ ኣ ኮሽዝታ አሽዛ፦ የይካ ሉለ ፕርደ፥ ቃꬌነ ኡባባዛል አማንንቶ። ሀራባዝታካ አሸካዛር Ꮊይትታ ይ ኦꬎዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ይንትስ ቶኢ ሀራ አስ ካልꬅዝታዮ፥ ይ ኡሻፕ ዉኑኖ ከሲ ግማለ ምትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«ይንታኖ፥ ጩቢታዮ፥ ህገ አስታማርታዮኔ ፈርሳወ አሳዮ፥ ይንታን አየ። ይ ሻተስኔ ከረስ አፋ ባጋ ጌሽዛ። ዝን ጋንችጬ ባጋይ ቦንቃኔ ኡዛትꬂ ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ነኖ ቶአ ፈርሳዋዮ፥ ሻተስኔ ከረስ ጋንጫ ቲና ጌሾባ። የይፕ ጉየ፥ አፋ ባጋይካ ጌሺ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«ይንታኖ፥ ጩቢታዮ፥ ህገ አስታማርታዮኔ ፈርሳዉታዮ፥ ይንታን አየ። ይ አፋ ባጋር ቦርሾንቶር ትዥንት ሎእ፥ ጋንጨ መቀꬅኔ ዎቄዝባዝ ኩሜዝ ዱፎ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","የይ ጋርከካ፥ አፋ ባጋር አስስ ሎኦ ኣዝዛ። ዝን ይ ጋንጨ ጩቦትꬅኔ ኢታትꬂ ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«ይንታኖ፥ ጩቢታዮ፥ ህገ አስታማርታዮኔ ፈርሳውታዮ፥ ይንታን አየ። ይ ናብታይስ ዱፎ ግንቢዛ፥ ማ ጽልታይ ዱፋካ ሎእꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ማ ይንቲ፥ ‹ኑኒ ብኒ ኑ አድታይ ዎደ የዛ ባዝ ማቄዛኮ፥ ኡንታር ዎላ ናብታይ ሱꬂ ላላምዝን› ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","የይ ግሾስ፥ ይ ናብታ ዎꬌዝ አስ ናእታ ማቄዛና ይንቲ ይ ኡባስ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ዬዛኮ፥ ይ አድታይ አይኬዛና ይ ፖሎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Ꮊ ሾሹንꬆ፥ ጎፐ ናኡንꬆ፥ ይ ጋናመ ፕርዳፕ ዋይዚ አቶዴ? ");
INSERT INTO mfxe_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","የይ ግሾስ፥ ታ ኦድዛና ስኦይታ፤ ታኒ ናብታ፥ ኤጫ አስታኔ አስታማርታ ይንትኮ ኪቶዳ። ኡንታፕ ፐታ ፐታ ይ ዎꬎዳ ማዝቃለል አፋ ሶቶዳ። ባግታ አይሁድታይ ዎሳ ኬꬅ ገልሲ አላንጎዳ ካታማፕ ካታማ ባይኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","የይ ግሾስ፥ ጽላ አቤላ ዎꬌዝ ዎደፕ አይኪ፥ ጾስ ኬꬅስኔ ያርሾ አቆፕ ግዶ ይ ዎꬌዝ ባራክዩ ናአ ዛክሬሳ ሱꬅ ሄሎዳር Ꮊይቄዝ ጌሽ አስ ኡባይ ግሾስ ይ ሴርንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ታኒ ይንትስ ቱሮ ኦድዛ፤ ይንትኔ ይ አድታይ ኦꬄዝ ቡታይስ Ꮊ ፕርዳ ኡባይ Ꮊ የለትꬃይል አፋ ሄሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«የሩሳላመ፥ የሩሳላመ፥ ናብታ ዎꬌዛኔ! ጾሳይ ኔኮ ኪቴዝታ ሹቻር ሾጭዛኔ! ሹጉላ ፋ ናእታ ፋ ቀፈር ሀጵዛይ ጋርክ ታኒ ነ ናእታ ታ ሺሾዳይስ ኣፑን ቶኬ ኮየኔ! ዝን ታና ነ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ይኬ፥ ይ ኬꬃይ ካይሳ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ታኒ ይንትስ ኦድዛ፤ ‹ጎዳይ ሱንꬃር ይእዛይ አንጅንቴዛያ› ይ ጎድ ጋꬆ Ꮊይፕ ጉየ ታና ይ በአሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","የሱሳ ጾስ ኬꬃፕ ከዚ Ꮊማዳር፥ ኤ ታማርታይ ኤዝኮ ይኢ፥ ጾስ ኬꬃ ግምባ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","የሱሳ ኡንትኮ ማሂ፥ «ኤ! Ꮊያ ኡብታ ይ ብእኔ? ታኒ ይንትስ ቱሮ ኦድዛ፤ ሹች ሹቻል አፋ ግንቢንቴዛይ ላልንተካዛር አታሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","የሱሳ ደብረዛይተ አምባል አፋ በቴዝን፥ ኤ ታማርታይ ፋ ኣዳስ ኤዝኮ ይኢ፥ «የይ አይደ ሀኖዳዛኮ ኑስ ኦዶባ። ማ ነ ይእꬃይስኔ ዎደ ዉርስꬃይስ ማላይ አባ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","የሱሳ ማሂ፥ «ይንታን ኦንካ ባልꬃም ጋርክ ናግንቶይታ! ");
INSERT INTO mfxe_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","አብስ ጊኮ፥ ጋመ አሳይ ታ ሱንꬃር፥ ‹ታኒ ክርስቶሳ› ጊታር ታ ሱንꬃር ይኢ ጋመ አስ ባልꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ኦላኔ ኦላ ባዝ ናሾዳር ይ ስኦዳይስ የዛ። የይ ሀኖዳይስ ቤዝዛ ግሾስ ህርግፓተ። ዝን ዉርስꬃይ ሀጋ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ዎያይ ዎያራ፥ ፐቲ ካተትꬃይ ሀራ ካተትꬃር ኦልንቶዳ። ናየኔ ቢታ ኤንኦ ጋመ አቆ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","የይ ኡባይ የሎ እቅꬅ ዞኬ አይꬅ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«የ ዎደ አሳይ ይንታን መቶስ ኣꬂ እማዳ፥ ዎꬎዳ። ታ ሱንꬃይ ግሾስ አሲ ኡባይ ይንታን እጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","የ ዎደ ጋምታይ አማኖ አሾዳ። ፋ ጋንጨ ፐታይ ፐታ ኣꬂ እማዳ፥ ፐታይ ፐታ እጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ማ ጋመ ዎርዶ ናብታይ ደንዲ ጋምታ ባልꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ዉጨትꬂ ጋንግዛይ ግሾስ ጋመ አሳይስ ሲቆ እርጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ዝን ዉርስꬂ ሄሎዳይስ ጋርዥዛ አꬃይ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","አስ ኡባስ ማርካ ማቃድ ጋርክ ጾስ ካተትꬅ ዎንግላይ ቢታ ኡባይል ሳባክንቶዳ። የይፕ ጉየ፥ ዉርስꬃይ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«የይ ግሾስ፥ ናበ ዳለነ ኦዴዝ ꬋብስዛ ቱና ኦሶ ጌሽ አቆ ኤቄዛና ይ በአዳ። ናባብዛይ አካኮ! ");
INSERT INTO mfxe_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","የ ዎደ ይሁዳ ቢታል የዝታይ አምባል ቆስንቶ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ኬꬅ ኩስተል የዝ አꬃይ ፋ ካራ የዝ ባዝ ኤኮዳይስ ዎꬍፐ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ጋደ ኦሶል የዛይ ፋ አፍላ ኤኮዳይስ ጉየ ማቅፐ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","የ አግናይድ ዎደꬅ ማችታይስኔ አምስዛ ማችታይስ ኢታ መቶ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ይ ቆስንታይ ባርጎር ዎይ ማላ ጋላስ ማቃም ጋርከ ጾሳ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","አብስ ጊኮ፥ ሳአ መꬍንቴዛይፕ Ꮊይኖ ሄሎዳይስ ሀነካ ባዝ፥ ማ ቲናስካ የሻ ሀናም መቶ የ ዎደ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","የ ጋላስታይ ፓይዳ ሃትሰካዛኮ አሾ ማኤዝ ኦንካ አታሚ። ዝን ኤ ፋ ዶሬዝ አሳይ ግሾስ የ ጋላስታይ ፓይዳ ሃትꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«የ ዎደ ኦንካ ይንታን፥ ‹Ꮊይሼ፥ ክርስቶሳ Ꮊይዳ› ዎይ ‹ሰንዳይዳ የዛ› ዬግኮ አማንፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","አብስ ጊኮ፥ ዎርዶ ክርስቶስታይራኔ ዎርዶ ናብታይራ ደንዶዳ። ኡንትስ ዳንዳእንትኮ፥ ሀራ አቶዝን ጾሲ ዶሬዝታካ ባልꬆድ ሄሎዳይስ ማላኔ ማላባዝ ቤዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","አካኮይታ፥ ታኒ ይንትስ Ꮊያ ቲናቲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«የይ ግሾስ፥ አሳይ ይንትኮ፥ ‹ክርስቶሳ ሊዦ የዛ› ጊኮ፥ እዘ Ꮊንግፓተ፥ ዎይ ይንትኮ፥ ‹ቆልአ የዛ› ጊኮ፥ አማንፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","አብስ ጊኮ፥ ዜልንꬂ ሳሎ ዜልንጊ፥ አዋ ከሳፕ አዋ ገሎ ሄሎዳይስ በንትዛይ ጋርክ፥ አሲ ናአ ይእꬃይ Ꮊይ ጋርክ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","«ጋዉጻ የዛ አቆ አንኮ ሺቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«የ ዎደ የ መቶ ጋላስታይፕ ጉየ፥ ኤለ አዋ ꬉሞዳ፥ አግና ፋ ፖኦ ካዮዳ። ጾልንትታይ ሳሎፕ ዎꬎዳ፥ ማ ሳሎ የዝ ዎልቅታይካ ቡቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","የ ዎደ አስ ናአ ማላይ ሳሎል አፋ በንቶዳ። ሳአ የዝ አስ ኡባይ ዬኮዳ። ማ አስ ናአይ፥ ዎልቃራኔ ግታ ቦንቾር ሳሎ ሻራ ጋንጨር የኦዳር ኡንቲ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ኤ ፋ ኪታንችታ ፑግዛ ዳማ ቱልቱላር ኪቶዳ። ኡ ሳአ ኦይዲ ዞዘ Ꮊንጊ፥ ጋጻፕ ጋጻ ሄሎዳይስ የዝ ኤስ ዶርንቴዝታ ሺሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«በለሰ ምꬃፕ ታማሮይታ። እ ጼራይ ጪዥኮ ሀይታይ አጮ አይክኮ ቦነ ኡኬዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","የይ ጋርከካ፥ ይ Ꮊ ኡባ በአዳር አስ ናአይ ይእዛ ዎዳይ ፔንገል የዛና ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ታኒ ይንትስ ቱሮ ኦድዛ፤ Ꮊ ኡባ ባዝ ፖልንቶድ ሄሎዳይስ፥ Ꮊ የለትꬃይ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ሳሎኔ ሳአይ ኣꬎዳ፥ ዝን ታ ቃላይ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«የ ጋላሳትኔ የ ሳታቲ ባጋ ሳሎ የዝ ታ አዳይፕ አትን ሀራ ሳሎ ኪታንችታ ማቅን ዎይ ናአ ማቅን ኦንካ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","አስ ናአ ይእꬃይ፥ ኖሄ ዎደ ሀኔዛይ ጋርክ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","የ አግንተ ꬋቦ ሃꬃይ የኦዳይፕ ቲና ኖሄ ማርካበ ጋንጨ ገሎድ ሄሎዳይስ፥ አሳይ ሚታራኔ ኡዥታር፥ ኤክታራኔ ገልታር ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ꬋቦ ሃꬃይ ይኢ፥ ኡንታን ኡባ ꬋብሶድ ሄሎዳይስ አካኬካያ። አስ ናአ ይእꬃይካ Ꮊይ ጋርክ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«የ ዎደ ናምኢ አሳይ ጋደ ጋንጨ ኦꬆዳ። ኡንታፕ ፐታይ ኤክንቶዳ፥ Ꮊንካይ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ናምኢ ማችታይ ዎላ ጋጮዳ። ኡንታፕ ፐታት ኤክንቶዳ Ꮊንካት አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«ይኬ፥ ይ ጎዳይ አባ ጋላስ የኦዳዛኮ ኤሮዋ ግሾስ ሚንጊ ናጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ዝን ካይዞ ቃማፕ ኣፑን ሳተል የኦዳዛኮ ካራ አዳይ ኤርዛኮ፥ ፋ ካራ ቦክንታማይ ጋርክ ባርክ ናጎዳዝን። ");
INSERT INTO mfxe_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","የይ ጋርክ፥ አስ ናአይ ይ ቆፐካ ሳተ የኦድ ግሾስ ይንትካ ጊግንቲ የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«የዝን፥ ፋ ካራ አሳይስ ካꬃ ቤዝዛ ዎደር እማድ ጋርክ ኤ ጎዳይ ዶሬዝ አማንꬅዛይኔ ዎዛናማ አይላይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ኤ ፋ ጎዳይ አዛዜዛና ኦꬃዳር ኤ ጎዳይ ይኢ ደንግዛ አይላይ አንጅንቴዛያ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ታኒ ይንትስ ቱሮ ኦድዛ፤ ጎዳይ የ አይላ ፋባዝ ኡባይል አፋ ሹሞዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ኢታ አይላይ፥ ‹ታ ጎዳይ ጋምኢ የኦዳ› ዬጊ ፋ ዎዝናር ቆፒ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ፋ ኦሶ ላግታ Ꮊꬎ አይክኮ፥ ማꬅዝታይራ ሚኮኔ ኡዥኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","የ አይላይ ጎዳይ ኤ ቆፐካ ጋላስኔ ኤ ኤረካ ሳተር፥ ");
INSERT INTO mfxe_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ይኢ ኤዛ ናምኢ ከሲ ጳልቆዳ። ኤ አንጃካ ጩቢታይር ኡዶዳ። ኤዛይድ ኤስ ዬፎኔ አች ጮንች ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«የ ዎደ ሳሎ ካተትꬃይ ፋ ኩራዘ አይኪ፥ ማቾ ኮኦዳይስ Ꮊንጌዝ አꬃ ሞኮዳይስ ከዜዝ ታጲ ዉድርታ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ኡንታፕ እችንታይ ቦዝታ፥ እችንታይ ኤጭታ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ቦዝታይ ኩራዘ አይኬዛ፥ ዝን ሀራ ላምባ አይከካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ዝን ኤጭታይ ፋ ኩራዛኔ ሀራ ጉጆ ላምባ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ማቾ ኤክዛ አꬃይ ጋምእን፥ የ ዉድርታይ ኡንታን ገንታ አይክን ገንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«ግዲ ብላሄ ማቆዳር ‹ማቻቶ ኤክዛይ የኤዛ፥ ኤዛ ሞኮዳይስ ከዞይታ› ዬግዝ ግታ ጫቦትꬂ ስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«የ ዎደ የ ዉድርታይ ኡቢታይ ባርኪ፥ ፋ ኩራዛ ጊግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ቦዝታይ ኤጭታይኮ፥ ‹ኑ ጾምፓይ ቶኦድ ሀንዛ ግሾስ ይ ላምባይፕ ኑስ እንጎይታ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«ዝን ኤጭታይ ኡንትኮ ማሂ፥ ‹የይ ሀናሚ፥ ኑስኔ ይንትስ ግድዛ ላምባ ባያ። የይ ግሾስ፥ ይንትስ Ꮊንጊ ዎንጊ ኤኮይታ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ቦዞ ዉድርታይ ላምባ ዎንጎዳይስ ቅቴዝን፥ ማቻት ኤክዛ አꬃይ ፑት ጌዛ። ጊግንቲ በቴዝ እችን ዉድርታይ ኤዛር ዎላ ቦሳ ስብረል ገሌዛ፤ ፐንጋይካ ጎርድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«ጉየፕ Ꮊንኮ ዉድርታይ ይኢ፥ ‹ጎዳዮ፥ ጎዳዮ፥ ኑስ ዶዮዬ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«ዝን ኤ ኡንትኮ ማሂ፥ ‹ታኒ ይንትስ ቱሮ ኦድዛ፤ ታ ይንታን ኤሮያ!› ");
INSERT INTO mfxe_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«ይኬ፥ አስ ናአይ የኦድ ጋላሳ ዎይ ሳታ ይ ኤሮዋ ግሾስ ባርኪ ናጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«ጾስ ካተትꬃይ ፋ አይልታ ጼጊ ፋስ የዛ ባዝ ኡንትስ ሀዳሪ ኦገ Ꮊማዳይስ ከዜዝ አꬃ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ኡንትስ ኦማር ኦማር ኡ ዎልቃይ ጋርክ ፐታይስ እችን መክልተ ፥ ፐታይስ ናምኢ መክልተ ማ ፐታይስ ፐቲ መክልተ እንጊ ሀራ ጋደ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","እችን መክልተ ኤኬዝ አይላይ ኤለ Ꮊንጊ ዛልእ፥ ሀራ እችን መክልተ ትርፕሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","የይ ጋርከካ፥ ማ ናምኢ መክልተ ኤኬዝ አይላይ ሀራ ናምኢ መክልተ ትርፕሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ዝን ፐቲ መክልተ ኤኬዛይ Ꮊንጊ፥ ኦላ ቦኪ፥ ፋ ጎዳይ ሚሻ ሞጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ጋመ ዎደፕ ጉየ የ አይልታይ ጎዳይ ይኢ፥ ፋ ሚሻ ኡንታን ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","እችን መክልተ ኤኬዝ አይላይ ይኢ፥ ሀራ እችን መክልተ ክኢ፥ ‹ታ ጎዳዮ፥ ነ ታስ እችን መክልተ እንጌዛ። ዝን ታ ሀራ እችን መክልተ ትርፕሴዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ኤ ጎዳይ፥ ‹ዛምባይ! ኔኒ ሎኦ አማንꬅዛ አይለ፤ ኔኒ ጽቃ ባዛል አማንቴዛ። ታኒ ነና ጋመ ባዛል ሹሞዳ፤ Ꮊና ነ ጎዳይ ኡፋይሳይድ ገሎባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«ማ ናምኢ መክልተ ኤኬዛይ ይኢ፥ ‹ታ ጎዳዮ፥ ኔኒ ታስ ናምኢ መክልተ እንጌዛ። ዝን ታኒ ሀራ ናምኢ መክልተ ትርፕሴዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ኤ ጎዳይ፥ ‹ዛምባይ! ኔኒ ሎኦ አማንꬅዛ አይለ፤ ኔኒ ጽቃ ባዛል አማንቴዛ። ታኒ ነና ጋመ ባዛል ሹሞዳ፤ Ꮊና ነ ጎዳይ ኡፋይሳይድ ገሎባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«ማ ፐቲ መክልተ ኤኬዛይ ይኢ፥ ‹ታ ጎዳዮ፥ ኔኒ ዘረካ አቆፕ ቡጭዝ ላለካ አቆፕ ማጽዝ ኢታ አስ ማቄዛና ታኒ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ታ ያሽቲ ነ መክልታ ቢታ ጋንጨ ሞጌዛ። ነ መክልታ Ꮊናሸ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«ኤ ጎዳይ ማሂ፥ ‹Ꮊ ኢታ አዛላ አይላዮ፥ ታኒ ዘረካ አቆፕ ቡጭዛኔ ላለካ አቆፕ ማጽዛ አስ ማቄዛ ነ ኤርኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ይኬ፥ ኔኒ ታ ሚሽቶ ባንከ ጋዴዛኮ ዎር ኤኮዳኖ ነ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","የይ ግሾስ፥ ሚሻ ኤፕ ኤኪ፥ ታጲ መክልተ የዛይስ እንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","አብስ ጊኮ፥ የዛ ኡባይስ ጉጅንቶዳ ጋንጎዳ። ዝን ባዛይፕ ሀራ አቶዝን፥ የ ኤዝስ የዛ ጽቃታካ ኤክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ꮊ ማዶዋ አይላ ባለ ꬉማ ከሲ ኦሎይታ። ኤዛይድ ኤዝስ ዬፎኔ አች ጮንች ማቃዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«አስ ናአይ፥ ኪታንቾ ኡቢታይራ፥ ፋ ቦንቾር ይኢ ኤ ፋ ቦንቾ ካተትꬅ ዙፋናይል አፋ በቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","አስ ኮች ኡቢታይ ኤ ቲና ሺቆዳ። ሄንግዝ ናአይ ዱርታ ዴሽታይፕ ቁርዛይ ጋርክ ኤ የ አሳ ናምኢ አቆ ሻጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ዱርታ ኡሻች ባጋር ዴሽታ ሀድርስ ባጋር ኤሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«የ ዎደ፥ ካታይ ኡሻች ባጋር የዝታይኮ Ꮊይ ጋርክ ዬጎዳ፦ ‹ታ አዳይ አንጄዝታዮ፥ Ꮊና ይኢ ሳአ መꬍንቴዛይፕ አይኪ ይንትስ ጊጌዝ ካተትꬅ ላቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","አብስ ጊኮ፥ ታኒ ናይንትን ይ ታና ሙዜዛ፥ ሳምንትን ኡሼዛ፥ እማꬅ ማቂ Ꮊንግን ሞኬዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ካሎቲን ማእሴዛ፥ ሀርግንትን ኦይጬዛ፥ አጭንትን ታና ይ በኤዛ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«የይፕ ጉየ፥ ጽልታይ ማሂ፥ ‹ጎዳዮ፥ ኔኒ ናይንትን አይደ ብኢ ነና ኑ ሙዜኔ? ዎይ ኔኒ ሳምንትን አይደ ብኢ ነና ኑ ኡሼኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ኔኒ እማꬅ ማቂ ይእን አይደ ብኢ ነና ኑ ሞከኔ? ዎይ ኔኒ ካሎቲን አይደ ነና ኑ ማእሴኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ኔኒ ሀርግንትን ዎይ አጭንትን ኔኮ Ꮊንጊ አይደ ነና ኑ ኦይጬኔ?› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ካታይ ማሂ፥ ‹ታኒ ይንትስ ቱሮ ኦድዛ፤ ይንቲ ታና ካልዛ Ꮊ ኡባይፕ ጽቅዛ እሽታይፕ ፐታይስ ኦꬍዛና ታስ ኦꬍዛ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«የ ዎደ ሀድርስ ባጋር የዝታይኮ፥ ‹Ꮊ ባድንቴዝታዮ፥ ታ ላንቃይፕ ሃኮይታ። ጻላሄስኔ ኤ ኪታንችታይስ ጊጌዝ መꬍና ታማ ጋንጨ Ꮊንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","አብስ ጊኮ፥ ናይንትን ታና ይ ሙዘካያ፤ ሳምንትን ታና ይ ኡሸካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ታኒ እማꬅ ማቂ Ꮊንግን ታና ይ ሞከካያ፥ ካሎቲን ማእሰካያ፥ ሀርግን አጭንትን ታና ኦይጨካያ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«የ ዎደ ኡንቲ፥ ‹ጎዳዮ፥ ኔኒ ናይንትን ዎይ ሳምንትን ዎይ እማꬅ ማቂ Ꮊንግን ዎይ ካሎቲን ዎይ ሀርግንትን ዎይ አጭንትን ብኢ ነና አይደ ማዳም እጼኔ?› ዬጊ ማሆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«የ ዎደ ካታይ ማሂ ኡንትኮ፥ ‹ታኒ ይንትስ ቱሮ ኦድዛ፤ ይንቲ ታና ካልዛ Ꮊ ኡባፕ ጽቅዝታይፕ ፐታ ማዳም እጼዛይ፥ ታና ማዳም እጼዛ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","የይ ግሾስ፥ የ አሳይ መꬍና ፕርደስ ማ ጽልታይ መꬍና ደኦስ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","የሱሳ Ꮊ ትምርታ ኡባ ዉርሴዛይፕ ፋ ታማርታይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ናምኢ ጋላሳፕ ጉየ፥ ፓዝቃ ባለ ቦንችዛ ጋላስ ማቅዛና ይ ኤርዛ። የ ጋላስ አስ ናአይ ማዝቃለል አፋ ሶትንቶዳይስ አስ ኩሸ ኣꬊ እንግንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","የ ዎደ ቄሰ ሀላቅታይኔ ጋደ ጭምታይ፥ ቃያፋ ግዝ ቄሰ ሀላቃይ ካራ ሺቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","አሲ ኤረካዝን የሱሳ አይኪ፥ ዎꬎዳይስ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ዝን ኡንቲ፥ «አሳይ ጫቦታማይ ጋርክ ግ፥ ፓዝቃ ቦንችዛ ጋላስ የያ ኦꬃሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","የሱሳ ብታና ካታማ ጋንጨ ቦርቆንቶ ሀርገር የዝ ስሞና ካራ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","የሱሳ ሙንትታል የዝን ፐቲ አስታ አልባስጽሮሳ ብልጋጸ ኩንꬃ ጋመ አልኦ ሽቶ ኤኪ ይኢ የሱሳ ኦማይል ቆሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ዝን የሱሳ ታማርታይ የያ ብኢ ካጭንቲ፥ «Ꮊ ሽታ ጨረ ኢስዛይ አብሶ? ");
INSERT INTO mfxe_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ꮊ ሽታይ አልኦ ዋጋር ባይዝንቲ፥ ሚሻይ ማንቅታይስ እንግንቶዳይስ ዳንዳእንትዛዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","የሱሳ ኡንቲ ጌዛና ኤሪ፥ ኡንትኮ፥ «Ꮊ አስቶ አብስ ዋይꬄ? እዛ ታስ ሎኦ ባዝ ኦꬂዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ማንቅታይ ኡባ ዎደ ይንታር የዞዳ። ዝን ታኒ ይንታር ኡባ ዎደ የዛሚ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","እዛ Ꮊ ሽታ ታል አፋ ቆሌዛይ ታና ሞጎስ ጊግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ታኒ ይንትስ ቱሮ ኦድዛ፤ ቢታ ኡባይል Ꮊ ዎንግላይ ሳባክንትዛ አቆ አባ ማቅኮካ፥ አሳይ እዝስ ቆፕሶ ማቃዳይ ጋርክ ኦድንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","የ ዎደ ታጶ ናምኢ የሱሳ ታማርታይፕ ፐታይ፥ አስቆሮንቶ ይሁዳ ግንትንትዛይ ቄሰ ሀላቅታይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ꮊንጊ፥ «ታኒ ይንትስ የሱሳ ኣꬂ እንግኮ፥ ይ ታስ አብ እማዴ?» ዬጊ ኡንታን ኦይጬዛ። ኡንቲ ቶቢ ሀስታም ብራ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","የይፕ ጉየ፥ ይሁዳ የሱሳ ኣꬂ እማዳይስ ጊጋ ጋላስ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ቦራ ባለ ቦንችዛ ቲና ጋላስ፥ የሱሳ ታማርታይ ኤዝኮ ይኢ፥ «ፓዝቃ ቦንችዛ ጋላስ ኔኒ ማድ ካꬃ ኑኒ አባ ማኮ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","የሱሳ ኡንትኮ፥ «ካታማ ይ ገሎዳር ሄሌዝ አꬃይኮ Ꮊንጊ፥ ‹አስታማራይ፥ ታስ ዎደ ሄሌዝ ግሾ ታ ታማርታይር ፓዝቃ ቦንችዛ ጋላሳ ነ ካራ ኣꬆዳ ዬጌዛ› ጎይታ» ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ኤ ታማርታይ የሱሳ ኪቴዛይ ጋርክ ኡዲ፥ ፓዝቃ ባለ ጋላስ ማድ ካꬃ ጊግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ሳአይ ኦማꬆዳር የሱሳ ታጶ ናምኢ ሀዋርታይር ካꬃ ማዳይስ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ኡ ማዳር፥ የሱሳ ኡንትኮ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ይንታፕ ፐታይ ታና ኣꬂ እማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ኡ ኢታ ዳጋሚ፥ ኦማር ኦማር፥ «ጎዳዮ፥ ቱሮ ታናሻ?» ግ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","የሱሳ ማሂ፥ «ፋ ኩሻ ታር ዎላ ፍልኦ ጋንጨ ዳክዛይ ኤ ታና ኣꬂ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","አስ ናአይ፥ ጾስ ቃላይድ ኤዝስ ጻፍንቴዛይ ጋርክ Ꮊይቆዳ። ዝን አስ ናአ ኣꬂ እንግዛ አꬃ አየ፤ የ አꬃይ የልንተካ አቴዛኮ ኤዝስ ሎኦዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ኤዛ ኣꬂ እማዳይስ የዝ ይሁዳ ማሂ፥ «አስታማራዮ፥ ነ ግዛይ ታናኔ?» ዬጌዛ። የሱሳ ማሂ፥ «ነ ጌዛይ ጋርክ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ኡንቲ ማዳር፥ የሱሳ ቦራ ኤኪ ጾሳ ጋላቴዛ። የ ቦራ ባጺ ፋ ታማርታይስ እንጊ፥ «Ꮊሽቴ፥ ሞይታ፥ Ꮊይ ታ አሾ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ጹአ ኤኪ፥ ጾሳ ጋላቴዛ። ኡንትስ እንጊ፥ «ኡባይ Ꮊይፕ ኡዦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ꮊይ ጋመ አሳይ ናጋራይ አቶ እንትንቶዳይ ጋርክ ጎግዝ ኦሮꬅ ታ ጫቆ ሱꬂ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ዝን ታኒ ይንትስ ኦድዛ፤ ታኒ ታ አዳይ ካተትꬃ ኦሮꬅ ዎይነ ኡሽ ይንታር ኡዦድ ጋላሳ ሄሎዳይስ Ꮊንፕ ገደ Ꮊ ዎይነ ኡሻ ኡዣሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ጋላታ ማዝሙረ የጼዛይፕ ጉየ ደብረ ዛይተ አምባል ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","የ ዎደ የሱሳ ኡንትኮ፥ «‹ጾሳይ ሄንግዛና ሾጮዳ ዱርታይካ ላልንቶዳ› ግንትንቲ ጾስ ቃላይድ ጻፍንቴዛይ ጋርክ Ꮊይኖ ቃማ ይ ኡቢታይ ታል ꬉብንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ዝን ታኒ Ꮊይቆፕ ደንዴዛይፕ ጉየ ይንትፕ ቲናቲ ጋልላ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ጵጽሮሳ ማሂ፥ «ኡንቲ ኡባይ ነና አሺ ꬋብኮካ፥ ታኒ ነና አሻሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","የሱሳ ጵጽሮሳኮ፥ «ታኒ ኔስ ቱሮ ኦድዛ፤ Ꮊይኖ ቃማ ሹጉላ ኡኮዳይፕ ቲና ኔኒ ታና ሀይꬒ ቶኬ ካዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ጵጽሮሳ ማሂ፥ «ታኒ ኔር ዎላ Ꮊይቆፕ አትን ነና የሻ ካዳሚ» ዬጌዛ። Ꮊንኮ ኤ ታማርታይ ኡቢታይካ Ꮊይ ጋርክ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ኤዛይፕ ጉየ፥ የሱሳ ፋ ታማርታይር ጌተሰማነ ግዝ አቆ Ꮊንጊ፥ ኡንትኮ፥ «ታኒ ሰንዳይድ Ꮊንጊ ጾስ ዎሶዳ፥ ይ Ꮊይዳ በቶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ጵጽሮሳኔ ዛብዶሳ ናአ ናምእታ ፓር ኤኪ Ꮊንጊ አዛኖኔ ይሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ማካ ኡንትኮ፥ «ታኒ Ꮊይቆድ ሄሎዳይስ አዛኔዛ። Ꮊይዳ ጋምኦይታኔ ባርኪ ናጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ጽቃ ቲናል Ꮊንጊ ቢታል ፋ ስናይር ጹጉኒ፥ «ታ አዳዮ፥ ዳንዳእንትዛ ባዝ ማቅኮ Ꮊ መቶ ጹአይ ታፕ ኣꬂ። ዝን ነ ሸነ ሀኖፕ አትን ታ ሸናይ ሀንፐ» ዬጊ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","የሱሳ ፋ ታማርታይኮ ማቂ ይኢ ኡንቲ ገንቴዝን ደንጊ፥ ጵጽሮሳኮ፥ «ይንቲ ፐቲ ሳተዛኮኔ ገንተካዛር ታር ምንጎዳይስ ዳንዳኤካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ፓጨ ጋንጨ ይ ገላማይ ጋርክ ባርኪ ናጎይታኔ ጾሳ ዎሶይታ። አያናይ እንግንቲ የዝን አሾ ዳቡሬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","የሱሳ ማ ናምእንꬃ Ꮊንጊ ዎሲ፥ «ታ አዳዮ፥ ታኒ Ꮊ መቶ ጹአይፕ ኡዠካዝን ኣꬆዳይስ ዳንዳእንቶዋ ባዝ ማቅኮ ነ ሸናይ ሀኖ» ዬጊ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ማካ ማቂ የኦዳር ኤ ታማርታይ ገንታ ጋምን፥ ዎይኤዝን ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ማካ ኡንታን አሺ Ꮊንጊ፥ ቲና ጌዝ ቃላቶ እዞ ማሂ ሃይꬒንꬆ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","የይፕ ጉየ፥ ፋ ታማርታይኮ ይኢ፥ «Ꮊኖ ሄሎዳይስ ገንታላኔ ሸምፖል የኔ? ይኬ ገንቶይታ። ይኬ፥ አስ ናአይ፥ ናጋራ ኦꬅዝታይ ኩሸ ኣꬊ እንግንትዛ ሳታይ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ደንዲ የꬎይታ፥ ታና ኣꬂ እንግዛይ Ꮊይሼ ሄሌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","የሱሳ ሀጋ የያ ኦድንቶዳር፥ ታጶ ናምኢ ታማርታይፕ ፐታይ፥ ይሁዳ የኤዛ። ቄሰ ሀላቅታይኔ ጋደ ጭምታይ ኪቴዝ ጋመ አሳይ ማሻኔ ጉፈ አይኬዝታይ ኤዛር ዎላ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","የሱሳ ኣꬂ እንግዝ ይሁዳ የ ጋመ አሳይኮ፥ «ታኒ ዬርዛይ ይ ኮይዛይ ኤዛ፥ ኤዛ አይኮይታ» ዬጊ ማላ እንጊ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ኤልሲ የሱሳኮ ሺቂ፥ «አስታማራዮ፥ ሳሮ ኔስ ማቆ» ዬጊ ኤዛ ዬሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","የሱሳ ኤዝኮ፥ «ታ ዳባዮ፥ ኔኒ አብስ የኤኔ» ዬጌዛ። የይፕ ጉየ፥ ሺቂ፥ ፋ ኩሻ የሱሳል ጋዲ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","የሱሳር የዝታይፕ ፐታይ ፋ ማሻ ሾዲ ቄሰ ሀላቃይ አይላ ሾጪ፥ ኤ ሀያ ጋቺ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ዝን የሱሳ፥ «ነ ማሻ ጉየ ሾካይድ ማሆባ። አብስ ጊኮ፥ ማሻ ሾድዝ ኡቢታይ ማሻር Ꮊይቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ታ፥ ታ አዳና ዎስዛኮ ጋመ ሙኩሎ ፓይድንትዝ ኪታንችታ ዳኮዳይስ ዳንዳኦዋ ባዝ ኔስ ኣዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","የያ ማቅኮ፥ ጾሳ ቃላይድ Ꮊይ ጋርክ ሀኖዳይስ ቤዝዛ ግንትንትዛይ ዋይዚ ፖልንቶደ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","የ ሳተ፥ የሱሳ የ ሺቄዝ ጋመ ዎያይኮ፥ «ታና ፓኖ ማሂ አይኮዳይስ ማሻኔ ጉፈ አይኪ የኤኔ? ታኒ ጾስ ኬꬃ ጋላስ ጋላስ ታማርስታር ይንታር የዝ ዎደ ይ ታና አይክበኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ዝን Ꮊይ ኡባይ ሀኔዛይ ናብታይ ጾስ ቃላይድ ጻፌዛይ ፖልንቶዳይ ጋርከ» ዬጌዛ። የ ዎደ ኤ ታማርታይ ኡቢታይ ኤዛ አሺ ቆስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","የሱሳ አይኬዝታይ ቄሰ ሀላቃ ቀያፋኮ ኤዛ ካንጌዛ። ኤዛይድ ህገ አስታማርታይኔ ቢታ ጭምታይ ሺቂ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ዝን ጵጽሮሳ ቄሰ ሀላቃይ ዛባ ሄሎዳይስ ሃኮር ኤዛ ካሌዛ። ኤ ዉርስꬃ በአዳይስ ዛባ ገሊ ናግዝታይር በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ቄሰ ሀላቅታይኔ ሺቄዝ አስ ኡቢታይ የሱሳ ዎꬎዳይስ ኤዛል አፋ ዎርዶ ማርካ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ጋምታይ ይኢ ኤዛል አፋ ዎርዶ ማርካ ማርካቴዛ፥ ዝን አብካ ደንገካያ። ጉየፕ ናምኢ አሳይ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Ꮊ አꬃይ፥ ‹ታኒ ጾሳ ኬꬃ ላሊ ሀይꬒ ጋላሳር ማሂ ኬጾዳይስ ዳንዳእዛ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ቄስታይ ሀላቃይ ደንዲ ኤቂ የሱሳኮ፥ «Ꮊይትታይ ነና ሞትዛ ሞታይስ ኔኒ ማህዝባዝ ባሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ዝን የሱሳ ስእ አቴዛ። ማካ ቄሰ ሀላቃይ፥ «ታኒ ነና ደኦ ጾሳ ሱንꬃር አይክዛ፤ ኔኒ ጾሳ ናአ ክርስቶሳ ማቅኮ ኑስ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","የሱሳ ማሂ፥ «የያ ነ ጌዛ። ዝን ታኒ ይንትስ ኦድዛ፤ Ꮊይፕ ጉየ፥ አስ ናአይ ዎልቃማ ጾሳ ኡሻች ባጋር በቴዝን፥ ሳሎ ሻራር የኦዳር ይ በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","የ ዎደ ቄሰ ሀላቃይ ፋ አፍላ ፔꬊ፥ «Ꮊያ ቦኦይታ ጾስ ጫዤዛ! ኑና ሀራ ማርካ አብ ኮሼ? ኤ Ꮊት ጫዤዛና ይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ይ ቆፋይ አባ?» ዬጌዛ። ኡንትካ፥ «ኤዝስ Ꮊይቆ ቤዝዛ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","የ ዎደ፥ ኡ ኤ ስናይድ ጩቲ ዡልቴዛ፥ Ꮊንክታይ ኤዛ ባቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«ክርስቶሳ! ነና ሾጬዛይ ኦኖ? አን ኑስ ትንቢተ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጵጽሮሳ ዛባይድ በቴዝን፥ ፐቲ ጋꬍንዳታ ኤዝኮ ይኢ፥ «ኔካ ጋልላ የሱሳር ዎላ የዛ ባሳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ዝን ኤ ኡ ኡቢታይ ቲና የ ጋꬍንዳትኮ፥ «ነ ግዝ ባዛይ አብዛኮ ታ ኤሮያ» ዬጊ ካዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ማ Ꮊንጊ ጋሰ ፐንገኮ ሄሎዳር Ꮊንካት ኤዛ ብኢ፥ እዘ የዛ አሳይኮ፥ «Ꮊ አꬃይ ናዝረተ የሱሳር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ጵጽሮሳካ ናምእንꬆ ጫቂ፥ «ታኒ የ አꬃ ኤሮያ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ጽቃ ጋምኦዳር፥ እዘ ኤቄዝ አሳይ ጵጽሮሳኮ ይኢ፥ «ኔካ ቱሮ ኡንታር ዎላ የዛ ባይ፤ ኔኒ ነ ናሻይር ኤርንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","የይፕ ጉየ፥ ጵጽሮሳ፥ «ታኒ የ አꬃ ኤሮያ!» ዬጊ፥ ፋና ባድꬅኔ ጫቆ አይኬዛ። የ ዎደ እዝር ሹጉላ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","የሱሳ ኤዝኮ፥ «ኔኒ ሹጉላ ኡኮዳይፕ ቲና ታና ሀይꬒ ቶኬ ካዶዳ» ጌዛና ጵጽሮሳስ ኤልቂ ግን፥ ባለ ከዚ ዱካ ሱꬅ ዬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ዎንታ ጉራ ቄሰ ሀላቅታይኔ ጋደ ጭምታይ ኡቢታይ የሱሳና ዎꬎዳይስ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ኡንቲ የሱሳ አጪ ካንጊ ጋደ አቅስዝ ጵላጾሳስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","የ ዎደ የሱሳና አይꬅዝ ይሁዳ፥ ጵላጾሳ የሱሳል አፋ ፕርዴዛና ብኢ፥ ቂራቲ፥ የ ሀስታም ብራ ቄሰ ሀላቅታይስኔ ጋደ ጭምታይስ ጉየ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«ታኒ ጌሽ አስ Ꮊይቆስ አꬂ እንጊ ናጋራ ኦꬂዛ» ዬጌዛ። ዝን ኡንቲ፥ «የይ ኑ መቶ ባያ ነ መቶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ይሁዳ ምሽቶ ጾስ ኬꬃ ኦሊ አሺ ኡ ላንቃይፕ Ꮊንጊ፥ ሶትንቲ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ቄሰ ሀላቅታይ ሚሻ ኤኪ፥ «Ꮊ ሚሻይ ሱꬅ ሚሸ ማቄዝ ግሾስ ኑኒ ጾስ ካራ ሚሸር ዋላኮዳይስ ቤዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","የይፕ ጉየ፥ ዎላ ቶቢ፥ በተ አስ ሞጎዳይስ ዢጨ ቢታ ዎንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","የይ ግሾስ፥ የ ጋዳይ Ꮊይኖ ሄሎዳይስ ሱꬅ ቢታ ግንትንቲ ጼግንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","የ ዎደ ናበ ኤርማሳ ጌዛይ ጋርክ «እስሬለ ናእታይ ዋቼዝ ኤ ጋታ ሀስታም ብራ ኤኬዛ ");
INSERT INTO mfxe_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ጎዳይ ታና አዛዜዛይ ጋርክ ዢጨ ቢታ ዎንጎዳይስ እንጌዛ» ጌዛይ የ ዎደ ፖልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","የሱሳ ጋደ አቅስዛ ጵላጾሳ ቲና ሺቅን፥ ጵላጾሳ ኤዝኮ፥ «ኔኒ አይሁደ ካቶ» ዬጊ ኦይጬዛ። የሱሳ ማሂ፥ «ነ ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ቄሰ ሀላቅታይኔ ጋደ ጭምታይ ኤዛ ሞቶዳር ኡንትስ አባ ማልሰካ ማሄካያ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","የ ዎደ ጵላጾሳ የሱሳኮ፥ «Ꮊይትታይ ነና ሞትዛ ሞታ ኡባ ነ ስኦሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","የሱሳ ሀራ አቶዝን፥ ፐቲ ቃላካ ማሃም እጽን፥ ጋደ አቅስዛይ Ꮊይ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ጋደ አቅስዛይ ላይꬃ ላይꬃ ፓዝቃ ባለ ቦንችዛ ጋላስ፥ ዎያይ ኮይዝ ፐቲ አስ አቻፕ ብልእዝ ዎጋ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","የ ዎደ ፐቲ ባርባና ግዝ ዳፋር ኤርንቴዝ ኢታ አሳይ አች ኬꬃ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","የይ ግሾስ፥ ጋመ አስ ሺቂ የዝን ጵላጾሳ፥ «ታኒ ይንትስ ባርባና፥ ብሎነ የሱሳ ግዝ ክርስቶሳና ብልኦ?» ዬጊ ዎያ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ኤ የያ ጌዛይ ኡ ቅናቲ የሱሳ ኣꬂ እንጌዛና ኤርዛ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ጵላጾሳ ፕርደ ካራ በቴዝን፥ ኤ ማቻት፥ «ታኒ Ꮊይኖ ቃማ አቡካር ኤ ባጋ ኢታ ዋይታር አቄዝ ግሾስ የ ጌሽ አꬃይል አፋ አባባዝካ ኦꬂፐ» ዬጊ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ዝን ቄሰ ሀላቅታይኔ ጋደ ጭምታይ ጵላጾሳ ባርባና ብልኢ፥ የሱሳ ዎꬎድ ጋርክ፥ ዎያይ ኤዛ ዎሶድ ጋርክ፥ ዎያ ዶሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ጵላጾሳ ማሂ ኡንትኮ፥ «ታኒ ኡ ናምአይፕ ይንትስ ኦና ብሎድ ጋርክ ኮይኔ?» ዬጊ ኦይጬዛ። ኡ፥ «ባርባና ብሎድ ጋርክ ኑ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጵላጾሳ፥ «የዝን፥ የሱሳ ግዝ ክርስቶሳ አብ ኡዶ?» ዬጊ ኡንታን ኦይጬዛ። ኡባይ ማሂ፥ «ሶትንቶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ጵላጾሳ ዎያይኮ፥ «አብሶ? ኤ አብ ኢታ ባዝ ኦꬅኔ?» ዬጊ ኦይጬዛ። ዝን አሳይ ቲናሳይፕ አꬂ፥ «ማዝቃለል አፋ ኤዛ ሶቶባ» ግ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ጵላጾሳ ጫቦ ደንꬅꬆፕ ሀራ አባባዝካ ኦꬆዳይስ ዳንዳእንታምዛ ብኢ፥ ዉርሲ ሃꬃ ኤኪ፥ «Ꮊ አꬃይ Ꮊይቃይድ ታኒ ባያ። የያ ኦꬅዛይ ይንታን» ዬጊ ዎያ ቲና ፋ ኩሸ ሜጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","አስ ኡቢታይ ማሂ፥ «ኤ ሱꬃይ ኑላኔ ኑ ናእታይል አፋ ማቆ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","የዝን፥ ጵላጾሳ ባርባና ኡንትስ ብልኢ፥ የሱሳ ጋራፊ፥ ማዝቃለል አፋ ሶትንቲ Ꮊይቆድ ጋርክ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","የይፕ ጉየ፥ ጵላጾሳ ዎታዳርታይ የሱሳና ጋደ አቅስዛይ ዛባ ካንግን፥ ዎታዳርታይ ኤ ካላይድ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ኤ አፍላ ቃሪ ኤኪ ዞቆ አፍላ ማእሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ማ አንጉꬅ ዛዉደ ኮቺ፥ ኤ ኦማይል ጋዴዛ። ኤ ኡሻች ኩሻይድ ሾምቦቆ ጉፈ አይꬂ፥ ኤ ቲናይድ ቡንቂቲ፥ «አይሁደ ካታዮ ሳሮ ኔስ ማቆ!» ዬጊ፥ ኤዛል አፋ ቃልዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ኤዛል አፋ ጩቴዛ። የ ሾምቦቆ ጉፋ ኤኪ፥ ኤ ኦማይድ ሾጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ኡንቲ ኤዛል አፋ ቃልዴዛይፕ ጉየ ዞቆ አፍላ ኤፕ ቃሪ ኤኪ፥ ኤ አፍላ ኤዛ ማእስ ሶቶዳይስ ኤኪ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ኡንቲ ባለ ከዚ፥ ፐቲ ስሞና ግዝ ቀረና ቢታ አꬃ ደንጊ፥ የሱሳ ማዝቃላ ዎልቃር ቶሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ጎልጎታ ግዝ አቆ ሄሌዛ። «ጎልጎታ» ጉሳይ «ኦማ ኦታ አቆ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","የይድ ኡ ጭዠር ዋላክንቴዝ ዎይነ ኡሺ ኡዦ ግ ኤስ እንጌዛ። ዝን ኤ የያ ጋንጺ ብኢ፥ ኡዣም እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ኡንቲ ማዝቃለል አፋ ኤዛ ሶቴዛይፕ ጉየ ኤ አፍላ ሻኪ፥ እጻ ኦሊ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","የይፕ ጉየ፥ ኤዛይድ በቲ ኤዛ ናጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ማ፥ «Ꮊይ አይሁደ ካት የሱሳ» ዬግዝ ኤ ዳፋ ቤዝዝ ሞቶ ጹፈ ኤ ኦማ አቻ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","የሱሳር የ ዎደ ናምኢ ፓንታይፕ ፐታ ኤፕ ኡሻች ባጋር፥ Ꮊንካ ኤፕ ሀድርስ ባጋር፥ ማዝቃለል አፋ ሶቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ኦገር ኣꬅዝ አሳይ ፋ ኦማ ኤንእስታር የሱሳ ጫዥታር፥ ");
INSERT INTO mfxe_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«ጾስ ካራ ላሊ ሀይꬒ ጋላስ ጋንጨ ኬጽዛዮ፥ ነና አሾባ። ኔኒ ጾስ ናአ ማቅኮ፥ አን ማዝቃላይፕ ዎꬎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","የይ ጋርከካ፥ ቄሰ ሀላቅታይ፥ ህገ አስታማርታይኔ ቢታ ጭምታይ ዎላ የሱሳል አፋ ቃልዴዛ። Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ሀራ አሳ አሼዛ፥ ዝን ፋና አሾዳይስ ዳንዳኤካያ። ኤ እስሬለ ካት ማቅኮ፥ አን ማዝቃላይፕ Ꮊት ዎꬎ፥ ኑካ ኤዛ አማኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ጾሳል ኤ አማንንትዛ፥ ጾሳይ ኤዛ አሾዳይስ ኮይኮ አን አሾ። አብስ ጊኮ፥ ኤ ፋና፥ ‹ታኒ ጾስ ናአ› ግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ማ ሀራ አቶዝን፥ ኤዛር ማዝቃለል አፋ ሶትንቴዝ ፓንታይፕ ፐታይ Ꮊይ ጋርክ ግ ኤዛል አፋ ቃልዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ኡሱፑን ሳተፕ Ꮊንጊ፥ ኡዱፉን ሳተ ሄሎዳይስ ቢታ ኡባይ ꬉሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ኡዱፉን ሳተ ማቄዛን ጋርክ የሱሳ፥ «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቅታኒ?» ግ ግታ ኡፎ ኡኬዛ። «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቅታኒ?» ጉሳይስ ብርሽꬃይ «ታ ጾሳዮ፥ ታ ጾሳዮ፥ ታና አብስ አሻሬ?» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ኤዛይድ ኤቄዝ አሳይፕ ፐታይ ፐታይ የያ ስኢ፥ «Ꮊ አꬃይ ኤላሳ ጼግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","እዝር ኡንታፕ ፐታይ ዎጺ Ꮊንጊ፥ ዛንዛር ጫላ ዎይነ ኡሽ ኤኪ። የያ ሾምቦቆ ጉፈ ጼራል ጋዲ ኡሾዳይስ ኤ ዶናይኮ ኡክꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ዝን Ꮊንክታይ፥ «አሾይታ፥ ኤላሳ ኤዛ አሾዳይስ የኦዳዛኮ አን ዎላ በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","የሱሳ ናምእንꬆ ግታ ኡፎ ኡኪ፥ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","የ ሳታይድ ጾስ ካራ ሶጽንቴዝ ማጋራዣይ ዎኮ ጼራፕ የኮ ጼራ ሄሎዳይስ ናምኢ ከዚ፥ ፐርእንቲ ዎꬌዛ። ቢታ ኤንኤዛ፥ ዛልታይካ ጳልቂንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ዱፍታይ ዶይንትን ጌሽ አስታይፕ ጋምታይ Ꮊይቆፕ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","የሱሳ Ꮊይቆፕ ደንዴዛይፕ ጉየ ኡንቲ ዱፎፕ ከዚ፥ ጌሽ ካታማ ቅቴዛ፤ ኤዛይድ ኡንደና አሳይስ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ማቶ ሀላቃይኔ ኤዛር የሱሳ ናግዛ ዎታዳርታይ ቢታይ ኤንኤዛኔ አቃይድ ሀኔዝባዛ በኤዝ ዎደ ጋመ ያሽቲ «ቱማ Ꮊይ ጾስ ናአ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","የይድ ጋመ ማችታይ፥ ጋልላፕ አይኪ የሱሳ ማድታር ካሌዝታይ ሃኮር ኤቂ ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ኡ ጋንጨ ማግዴላ ማይራማ፥ ያይቆባራኔ ዮሴፋ እንዳት ማራማኔ ዛብዶሳ ናእታይ እንዳት የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ሳአ ለምእለምኦዳር ዮሴፋ ግዝ ፐቲ ዱረ አꬃይ፥ አርማታሳ ካታማፕ የኤዛ። ኤ ፋ ኡባስካ የሱሳ ካልዛ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ዮሴፋ ጵላጾሳኮ Ꮊንጊ፥ የሱሳ አሃ ኤኮዳይስ ዎሴዛ። ጵላጾሳ አሃይ ዮሴፋስ እንግንቶድ ጋርክ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","የሱሳ አሃ ኤኪ፥ ጌሽ አፍላር ሳዋጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ሹቻፕ ዎጬዝ ኦሮꬅ ዱፎ ጋንጨ አሃ ጋዴዛ። ማ የ ዱፋይ ዶናይድ ዳማ ሹች ጎልእሲ ጋዲ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ማግዴላ ማይራምራ Ꮊንኮ ማይራማ የ ዱፋይኮ ማቂ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ዎንትꬃ ማላ ጋላስ፥ ቄሰ ሀላቅታይኔ ፈርሳውታይ ጵላጾሳኮ ይኢ፥ Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«ጎዳዮ፥ Ꮊ ባልꬅዛይ ፓꬅ የዛር፥ ‹ታኒ ሀይꬒ ጋላሳፕ ጉየ Ꮊይቆፕ ደንዶዳ› ዬጌዛይ ኑስ ኤልቂ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","የይ ግሾስ፥ ኤ ሞግንቴዝ ዱፋ ሀይꬒ ጋላስ ሄሎዳይስ፥ ሚንꬂ ናጎድ ጋርክ አዛዞባ። የይ ሀናም እጽኮ፥ ኤ ታማርታይ Ꮊንጊ ኤ አሃ ካስቲ ꬋብሲ፥ ‹Ꮊይቆፕ ደንዴዛ› ዬጊ ዎያይስ ኦድኮ ናምእንꬆ ባልꬃይ ቲናሳይፕ ኡባ Ꮊና ኢቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጵላጾሳ ኡንትኮ፥ «ይንትስ ናግዝታይ የዛ፤ Ꮊንጊ ይንትስ ዳንዳእንቴዛይ ጋርክ ናግሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","የይ ግሾስ፥ ኡንቲ Ꮊንጊ ዱፋይ ቦችንታማይ ጋርክ ሹቻይል አፋ ማታመ አታሚ ዎታዳርታይር ዎላ ጎርዲ ናግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ማላ ጋላሳይ ኣꬌዝ ዎጋ ዎደ ጉራ፥ ማግዴላ ማይራምራ Ꮊንኮ ማይራማ የሱሳ ሞግንቴዝ ዱፋ በአዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ቆፐካ ዎልቃማ ቢታ ኤንኦ ሀኔዛ። ጎዳይ ኪታንቻይ ሳሎፕ ዎꬊ ዱፋይ ዶናይል የዝ ሹቻ ጎልእሲ ኤዛል አፋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ኤ ጭራይ ዜልንꬅ ኣዝዛ። ኤ አፍላይካ ሻች ጋርክ ቦꬅ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ናግዝታይ ኪታንቻ ብኢ፥ ያሻር ኩኩሪ፥ Ꮊይቄዝ አስ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ኪታንቻይ ማችታይኮ፥ «ያሽትፓተ ይ ማዝቃለል አፋ ሶትንቴዝ የሱሳ ኮይዛና ታ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ኤ ቲን ኦዴዛይ ጋርክ Ꮊይቆፕ ደንዴዛ፤ Ꮊይዳ ባያ። Ꮊና ይኢ ኤዛ ዎይꬄዝ አቃ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ይ Ꮊት ኤልሲ Ꮊንጊ፥ ኤ ታማርታይስ፥ ‹የሱሳ Ꮊይቆፕ ደንዴዛ። ማ ኤ ይንትፕ ቲናቲ ጋልላ Ꮊማዳ፤ ይ ኤዛ ኤዛይድ በአዳ› ዬጊ ኦዶይታ። ታኒ ይንትስ Ꮊያ ኦዶዳይስ የኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ኡንቲ ያሽትታራኔ ጋመ ኡፋይትታር፥ ዱፋይ ላንቃይፕ ኤልሲ Ꮊንጊ፥ ኤ ታማርታይስ ኦዶዳይስ ዎጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ቆፐካዝን የሱሳ ኡንታር ዎል ሄሊ ኡንትኮ፥ «ሳሮ ይንትስ ማቆ» ዬጌዛ። ኡንቲ ኤዝኮ ሺቂ፥ ኤ ቶካ አይኪ ኤዝስ ጎይኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","የ ዎደ የሱሳ ኡንትኮ፥ «ያሽትፓተ፤ Ꮊንጊ ታ ታማርታይ ጋልላ Ꮊማድ ጋርክ ኡንትስ ኦዶይታ። ኡ ኤዛይድ ታና በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","የ ማችታይ Ꮊማዳር፥ ዱፋ ናግዛ ዎታዳርታይፕ ባግታይ ካታማ Ꮊንጊ፥ ሀኔዝባዛ ኡብታ ቄሰ ሀላቅታይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ቄሰ ሀላቅታይኔ ጭምታይ ሺቂ ቶቢ፥ ዎታዳርታይስ ጋመ ሚሸ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«‹ኑኒ ገንቴዝን ኤ ታማርታይ ቃማ ይኢ፥ ኤ አሃ ካስቴዛ› ዬጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ꮊ ኦዳ ጋደ አቅስዛይ ስእኮ፥ የይ ይ ቡታ ባዛ ኑኒ ኤዛ ኦዲ አማንꬆዳ። ይንታን አብካ ህርግስፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ዎታዳርታይ ሚሸ ኤኪ፥ ኪትንቴዛይ ጋርክ ኡዴዛ። Ꮊ ኦዳይ አይሁድታይ ካለ Ꮊይኖ ሄሎዳይስ ኦድንትታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ታጶ ፐቲ ኤ ታማርታይ የሱሳ ኡንታን Ꮊንጎይታ ጌዝ ጋልላ ደረል አፋ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ኤዛይድ ኡንቲ ኤዛ በኤዝ ዎደ ኤዝስ ጎይኔዛ፥ ዝን ኡንታፕ ፐታይ ፐታይ ስꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","የሱሳ ኡንትኮ ሺቂ፥ «ሳሎኔ ሳአ ማዉተ ኡባይ ታስ እንግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ይኬ፥ ይንቲ ኡባ አቆ Ꮊንጊ፥ ዎንግላ ሳባኪ ታና ካልዝታ ማሆይታ፥ ኣዳ፥ ናአ፥ ጌሻ አያና ሱንꬃር ዎያ ኡባ ጻማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ታኒ ይንታን ኪቴዛ ኡባ ኡ ናጎድ ጋርክ ታማርሶይታ። ታኒ ዎደ ዉርስꬅ ሄሎዳይስ ኡባ ዎደ ታ ይንታር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ꮊይ ጾስ ናአ የሱስ ክርስቶሳ ዎንግለ አይꬅ ");
INSERT INTO mfxe_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ናበ ኢሳያሳ ጻፌዝ ማጻፋይ ጋንጨ ጾሳይ፥ «ዬዛኮ፥ ታኒ ታ ኪታ ናአ ኔፕ ቲና ዳኮዳ። ኤ ነ ኦጋ ፕጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ፐታይ ሊዦ ጋꬋር ኡኪ ኦድታር፥ ‹ጎዳይስ ኦገ ፕጾይታ፤ ኤ የꬎዳይስ ጎሰ ኤዝስ ሉልሶይታ ጌዛ» ጊንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ጻማቅዛ ዋንሳ አሳ ጻማቅታር፥ «ይ ናጋራይፕ ማቂ ጻማቅንቶይታ፤ ጾሳይ ይ ናጋራ ይንትስ አቶ ጎዳ» ዬጊ ቃላ ኦድታር ሊዦ ጋꬋፕ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ይሁዳ ቢታ የዝ አስ ኡቢታይኔ የሩሳላመ ካታማ አስ ኡቢታይ ዋንሳኮ ይእዛ። ፋ ናጋራ ቡጽን፥ ዋንሳ ኡንታን ዮርዳኖሳ ቦርካ ጻማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ዋንሳ ግማለ እክሰፕ ዳድንቴዝ አፍላ ማእዛ። ፋ ጼሳይድ ዳፈ ዳንጭዛ፤ ማ ቦለራኔ ደገራ ኤሳራ ሚዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ዋንሳ ቃላ ኦድታር፥ «ታፕ ጉየር ሎእꬂ ሚንግዛይ ይእዛ። ሀራ አቶዝን፥ ታ ኤ ጫማ ዎዶራ ዙጊ ብሎዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ታ ይንታን ሃꬃር ጻማቅዛ፥ ዝን ኤ ይንታን ጌሻ አያናር ጻማቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","የሱሳ የ ዎደ ጋልላ ቢታ የዝ ናዝረተ ካታማፕ ይእን፥ ዋንሳ ዮርዳኖሳ ቦርካ ኤዛ ጻማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","የሱሳ ሃꬃፕ ከዜዛን ጋርክ ሳሎ ዶይንትን፥ ጌሻ አያናይ ኤዛል አፋ ሆለ ጋርክ ዎꬋዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ማካ፥ «ታ ቃꬊዛ ታ ናአይ ነና፤ ታ ኔል ኡፋይትዛ» ዬግዝ ግርꬂ ሳሎፕ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","እዝር ጌሻ አያናይ የሱሳ ሊዦ ጋꬋ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","የሱሳ ሊዦ ጋꬋ ጻላሄር ፓጭንትታር ኦይታም ጋላስ ጋምኤዛ። ዶእታይር የዜዛ፥ ዝን ኪታንችታይ ይኢ ኤዛ ማዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ዋንሳ አጭንቴዛይፕ ጉየ የሱሳ ጾስ ካተትꬅ ዎንግለ ኦድታር ጋልላ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«ላይꬃይ ሄሌዛ፤ ጾስ ካተትꬃይ ኡኬዛ። ይ ናጋራይፕ ማቂ፥ ዎንግላ አማኖይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","የሱሳ ጋልላ አባ ላንቀር ኣꬊታር፥ ሞሎ አይክዝ፥ ስሞናራኔ ኤ እሻ እንድራሰራ፥ ፋ ግተ አባል አፋ ኦልዝታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ኡንትኮ፥ «ታና ካሎይታ፤ ታ ይንታን አስ አይክꬅ ታማርሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ኡንትካ እዝር ፋ ግትታ ኦሊ አሺ የሱሳና ካሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","እዝፕ ጽቃል ቲን Ꮊንጊ፥ ናምኢ እሽታ ዛብዶሳ ናእታ፥ ያይቆባራኔ ዋንሳራ ዎጎሎ ጋንጨ ፋ ግተ ሎእꬅዝታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","የሱሳ ኤልሲ ኡንታን ጼጌዛ። ኡንትካ ፋ ኣዳ ዛብዶሳ፥ ኤ ኦሶ አስታይር ዎጎሎ ጋንጨ ኦሊ አሺ ኤዛ ካሊ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ኡንቲ ቅፍርናሆመ ካታማ ገሌዛ። ማላ ጋላስ ሄሌዛን ጋርክ የሱሳ ኤልሲ አይሁደ ዎሳ ኬꬃ ገሊ ታማርሶ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ማዉተር የዝ አስ ጋርክ ታማርስዛፕ አትን ሀገ አስታማርታይ ጋርክ ታማርሶዋ ግሾስ አሳይ ኤ ትምርታ Ꮊይ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","የ ዎደ ቱና አያና አይኬዝ ፐቲ አꬃይ አይሁድታይ ዎሳ ኬꬃ ገሊ ኡኪ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«ናዝረተ የሱሳ፥ ኔራኔ ኑር አባ አላለ የኔ? ኑና ꬋብሶዳይስ የኤኔ? ነ ኦኖዛኮ ታ ኤርዛ፤ ነ ጾሳ ጌሻ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","የሱሳ ያ ቱና አያና፥ «ሀይዞባ፥ Ꮊ አꬃይፕ ከዞባ» ዬጊ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ቱና አያናይ አꬃ ዛርድዛርድ ኡዲ፥ ጽላሲ ኡኪ ኤዛፕ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","አሳይ ኡባይ ማላባዝ ግ፥ «Ꮊይ አባ? Ꮊ አꬃይ ፋ ማዉተር ሀራ አቶዝን ቱና አያንታካ አዛዝዛ። ኡንትካ ኤስ አዛዝንትዛ፤ Ꮊይ አባ ኦሮꬅ ትምርተ?» ዬጊ፥ ፋ ጋንጨር ፐታይ ፐታይ ዎል ኦይች አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","የሱሳ ዋራይ ኤልሲ ጋልላ አዉራጃ የዝ ሄራ ኡባ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","የሱሳ የ ዎደ አይሁድታይ ዎሳ ኬꬃፕ ከዚ፥ ያይቆባራ ዋንሳራ ስሞና ካራኔ እንድራሰ ካራ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ስሞና ማቻቲ እንዳት ኦጸ ምሻ ሀርገር ዎይኢ የዝን የሱሳ እዘ ሄልን ኤዝስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ኤ እዝኮ ሺቂ፥ እ ኩሻ አይኪ፥ እዞ ደንꬂ ኤሴዛ። ኦጸ ምሻ ሀርጋይ ኤልሲ እዞ ዳክን እዛ ኡንታን ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ሀርግንቴዝ አሳ ኡብታኔ ቱና አያንታይ አይኬዝ አሳ ኡባ ኦማꬅ አዋ ገሊ ለምእለምኦዳር ኤዝኮ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ካታማ የዝ አስ ኡባይ ይኢ ኬꬃይስ ባለ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","የሱሳ ዱማ ዱማ ሀርገር አይክንቴዝ ጋመ አስታ ፓꬂ፥ ጋመ ቱና አያንታ ከሴዛ። ኤ ኦኖዛኮ ቱና አያንታይ ኤሬዛ። ዝን የሱሳ ኡንታን ናሾዳ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","የሱሳ ዣባሮ ደንዲ፥ አሲ ባ አቆ ዎሶዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ስሞናራኔ ኤዛር የዝታይ ኤዛ ኮይታር Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ኡንቲ ኤዛ ደንጊ፥ «አሳይ ኡቢታይ ነና ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","የሱሳ ማ ኡንታን፥ «ሀራ አቆ ኡከ ሄርታ የꬎይታ። ታ የኤዛይ ዎንግለ ኦዶዳይስ ማቄዝ ግሾስ ኤዛይዳካ ቃላ ኦዶዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","አይሁድታይ ዎሳ ኬꬅታይድ ቃላ ኦድታር፥ ቱና አያንታ ከስታር፥ ጋልላ ቢታ ኡባ ዉቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ቦርቆንቶ ሀርገ አይኬዝ ፐቲ አꬃይ የሱሳኮ ይኢ፥ ኤ ቲናይድ ጹጉኒ፥ «ነ ቃꬊኮ ታና ጌሾዳይስ ዳንዳእዛ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","የሱሳ ኤዝስ ቃꬊንቲ፥ ፋ ኩሻ ዳኪ ኤዛ ቦቺ፥ «ታ ኮይዛ፥ ጌዦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","እዝር ቦርቆንታይ አꬃ ዳክን አꬃይ ኤልሲ ጌዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","የሱሳ አꬃይኮ ሚንꬂ ናግንቶባ ግ ሞይዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","የሱሳ ኤዛ፥ «ነና ኤሮባ፥ Ꮊኖ ኦስካ ኦድፐ። ዝን Ꮊንጊ ነ ጋላ ቄሰ ቤዞባ። ነ Ꮊት ጌሻ ማቄዛና አሳ ኤርሶዳይስ፥ ሙሰ ኪቴዝ ያርሾ ያርሾባ» ዬጊ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ዝን አꬃይ Ꮊንጊ፥ ሄራ ኡባይድ አስስ ኦዴዛ። የይ ግሾስ፥ የሱሳ ቆንጨር፥ ካታማ ገሎዳይስ ዳንዳኤካያ። ዝን አሲ ባ አቆ ጋጻ የዜዛ፤ ማ አሲ ኡባ አቆፕ ኤዝኮ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ጽቃ ጋላሳፕ ጉየ የሱሳ ቅፍርናሆመ ማቂ፥ ካራ የዛ ግዝ ዎረ ስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ሺቄዝ አሳ ኬꬃይ ኤካም እጽን ሀራ አቶዝን ባላይካ ኡንኦድ ጋꬆ ጋመ አስ ሺቅን፥ የሱሳ ቃላ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ኦይዲ አስታይ ፐቲ ስላ አꬃ ቶኪ ኤዝኮ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","አሳይ ጋንጌዝ ግሾስ አꬃ የሱሳኮ ሺሾዳይስ ኡንትስ ዳንዳእንታም እጽን፥ የሱሳ የዛ ባጋይር ኬꬃ ቃሪ፥ ሲትንጋ ቃዉጺ አꬃ ኤ ዎይኤዝ አርሳትራ ሱለ ዳኪ የሱሳ ቲናይድ ዎꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","የሱሳ ኡ አማና ብኢ፥ ያ ስላ አꬃ፥ «ታ ናአዮ፥ ነ ናጋራይ አቶ ግንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ህገ አስታማርታይፕ የ አቃይድ በንቴዝ ፐቲ ፐቲ አስታይ ፋ ዎዝናይር፥ ");
INSERT INTO mfxe_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ꮊ አꬃይ Ꮊይ ጋርክ ኢታ ባዝ ጾሳል አፋ አብስ ኦድንቴ? ጾስ ኣዳፕ አትን ሀራ ኦ ናጋራ አቶ ጎዳይስ ዳንዳኤ?» ዬጊ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ኡ ፋ ዎዝናይድ የይ ጋርክ ቆፔዛና የሱሳ ኤልሲ ፋ አያናር ኤሪ፥ ኡንትኮ፥ «ይንቲ ይ ዎዝናይር አብስ Ꮊይ ጋርክ ቆፔ? ");
INSERT INTO mfxe_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ስላ አꬃ፥ ‹ነ ናጋራይ አቶ ግንቴዛ› ግዛይ ሻዉክነኔ? ዎይ፥ ‹ደንዲ ኤቂ ነ አርሳ ቶኪ ቅቶባ› ግዛይ ሻዉከ? ");
INSERT INTO mfxe_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ዝን ታስ፥ አስ ናአይስ፥ ሳአል አፋ የሳይ ናጋራ አቶ ጎዳይስ ዎልቃ የዛና ይ ኤሮድ ጋርክ» ዬጊ የ ስላ አꬃይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ታ ኔኮ Ꮊት ኦድዛ፥ ደንዲ ነ አርሳ ቶኪ ነ ካራ ቅቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","አꬃይ ኤልꬂ ደንዲ፥ ፋ አርሳ ቶኪ አስ ኡባይ ቲና ከዜዝ። አሳይ ኡባይ ማላባዝ ግ፥ «ኑኒ Ꮊይ ጋርክ ባዝ የሻ ብኢ ኤሮያ» ዬጊ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","የሱሳ ማካ ጋልላ አባ ላንቀ Ꮊንጊ፥ ኤዝኮ የኤዝ አስ ኡብታ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ኤዛይር ኣꬎዳር፥ ኢልፎሳ ናአ ለወ ግንትንትዛይ ቃራጸ ጋችስዛ አቆ በቴዝን ብኢ፥ «ታና ካሎባ» ዬጌዛ። ለዋይ ደንዲ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","የሱሳ ካꬃ ማዳይስ ለዋይ ካራ በቴዛ። ኤዛ ካልዛ አሳይ ጋመ ማቄዝ ግሾስ ቃራጸ ጋችስዛ ጋመ አሳይኔ ናጋራ ኦꬄዛ አሳይ ኤዛራኔ ኤ ታማርታይር ዎላ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ህገ አስታማረ ማቄዝ ፐቲ ፐቲ ፈርሳወ አሳይ የሱሳ ናጋራ ኦꬄዝ አሳይራኔ ቃራጸ ጋችስዝታይር ካꬃ ማዳር ብኢ፥ «ኤ አብስ ናጋራ ኦꬄዝ አሳይራኔ ቃራጸ ጋችስዝታይር ካꬃ ሜ?» ዬጊ፥ ኤ ታማርታይር ዎል ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","የሱሳ ኡ ግዛና ስኢ፥ «አክመ ሀርግንትዝታይሳፕ አትን ፓꬅ አስስ ኮሾያ። ታኒ ናጋራ ኦꬄዝታ ጼጎዳይስ የኤዛፕ አትን ጽልታ ጼጎዳይስ የኤካያ» ዬጊ ኡንትስ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ጻማቅዛ ዋንሳ ታማርታይኔ ፈርሳውታይ ጾምዛዝን፥ ፐቲ ፐቲ አሳይ የሱሳኮ ይኢ፥ «ዋንሳ ታማርታይኔ ፈርሳውታይ ታማርታይ ጾምዛ፥ ዝን ነ ታማርታይ አብስ ጾሞሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","የሱሳ ኡንትኮ፥ «ማቾ ኤክዛይ ኡንታር የዝን ላዛንꬅታይ፥ ጾሞዳይስ ዳንዳእኔ? ማቾ ኤክዝ አꬃይ ኡንታር የዝን፥ ጾሞዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ዝን ማቾ ኤክዛ አꬃይ ኡ ካለፕ ኤክንትዛ ቃማ የኦዳ፥ ኡ ያ ጋላስ ጾሞዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ጭማ አፍላል አፋ ኦሮꬅ እራፈ ጋዲ ስክዛ አሲ ባያ። ጋዲ ስክኮ፥ ኦሮꬃይ ጭማ አፍላና ፐርእዛ፤ ፐርእꬃይካ ቲናሳይፕ ዳልግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ማ ማልአንቶ ዎይነ ጭማ ኦጎሮ ጋንጨ ቡልዝ አሲ ባያ። ቡልዝ ማቅኮ፥ የ ዎይናይ ኦጎራና ꬉስዛ፥ ፋ ኡባስካ ላልንትዛ፥ ኦጎራይካ ኢትዛ። ዝን ማልአንቶ ዎይነ ኦሮꬅ ኦጎሮ ጋንጨ ቡልንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","የሱሳ ፐቲ ማላ ጋላስ ባንጋ ጋደ ጋንጨር ኣꬎዳር፥ ኤ ታማርታይ ኤዛር ዎላ Ꮊንግታር ባንጋ ትዣ ምርኪ ሙስ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ፈርሳወ አሳይ የሱሳኮ፥ «የዝን፥ ነ ታማርታይ ማላ ጋላስ ዎጋ ባባዝ አብስ ኦꬄ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","የሱሳ ኡንትኮ፥ «ዳዉተ ናይንቲ፥ ሚዝ ባዝ ኮዤዝ ዎደ ፓር የዝታይር ኦꬄዛና ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","አብያታራ ቄሰ ሀላቃ ማቂ የዛ ዎደ ዳዉተ ጾሳ ኬꬃ ገሊ፥ ቄስታይ ኣዳ ማዳይስ በዝዛፕ አትን ኦንካ ማዳይስ ዎጋ ባባዝ ጎዳይ ቲና ጋዴዝ ያርሾ ሶሎ ሜዛ፥ ፓር የዝታይስካ እንጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ማካ የሱሳ ኡንትኮ፥ «ማላይ አስስ መꬍንቴዛፕ አትን አሲ ማላስ መꬍንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","የይ ግሾስ፥ አስ ናአይ፥ ሀራ አቶዝን ማላስካ ጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","የሱሳ አይሁድታይ ዎሳ ኬꬅ ማቂ ገሌዛ። ኤዛይዳ ኩሸ ስሌዝ ፐቲ አꬃይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ፐቲ ፐቲ አሳይ የሱሳ ሞቶዳይስ ኮዪ፥ ኩሸ ስሌዝ አꬃ ማላ ጋላስ ኤ ፓꬆዳዛኮኔ አሾዳዛኮ በአዳይስ ኮዪ ሚንጊ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","የሱሳ ኩሸ ስሌዝ አꬃ፥ «ደንዲ Ꮊና ይኢ ኑ ጋንጨ ኤቆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","የይፕ ጉየ፥ አስታይኮ፥ «ማላ ጋላስ ሎኦ ባዝ ኦꬅዛይ ዎጋኔ ኢታ ባዝ ኦꬅዛይ ዎጋ? አስ ሸምፖ አሾኔ ዎꬎ?» ዬጊ ኦይጬዛ። ዝን አሳይ ስኤ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","የሱሳ ሸንቲ ኡንታን ፋ ካላይር የዝታ ዳኪ ብኢ፥ ኡ ዎዝና ዶጬዝታ ማቄዝ ግሾስ ኡንታን ካጬዛ። ያ አꬃይኮ፥ «ነ ኩሻ ፕድ ኡዶባ» ዬጌዛ። አꬃይ ፕድ ኡድን ኤ ኩሽታይ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ኤልሲ ፈርሳዋይ አይሁድታይ ዎሳ ኬꬃፕ ባለ ከዚ፥ የሱሳና ዋይዚ ዎꬎዳዛኮ ቶቦዳይስ ሄሮዶሳ ባግታይር ፐቲ ካራ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","የሱሳ ፋ ታማርታይር ጋልላ አባ ላንቀ Ꮊንጌዛ። ጋልላፐራ ይሁዳፕ የኤዝ ጋመ አሳይ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ማካ የሩሳላመፕ፥ ኤዶማሳፕ፥ ዮርዳኖሳ ሃꬅ ፕንꬃፐ፥ ጽሮሳ ካታማፐር ስዶና ግዝ ካታማፕ የሱሳ ኦꬄዝ ባዝታ ስኢ፥ ጋመ አሳይ ኤዝኮ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ሺቄዝ አሳይ ጋመትꬃይፕ ደንዴዛይድ ኤዛ ዋይꬃም ጋርክ ኤ ታማርታይ ዎጎሎ ኤዝስ ሎእꬆዳይ ጋርክ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ጋመ አስታ ኤ ፓꬄዝ ግሾስ ሀርግንትዛ አሳይ ኡቢታይ ኤዛ ቦቾዳይስ ኡርቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ቱና አያና አይኬዝ አስታይ ኤዛ በኤዛን ጋርክ ኤ ቲና ጹጉኒ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ነ ጾስ ናአያ ባሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","የሱሳ ኡንታን ፋ ሱንꬃ ኦስካ ኦዳማይ ጋርክ ሚንꬂ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","የሱሳ ደረል አፋ ከዚ፥ ፋ ኮዤዝ አስታ ፋኮ ጼጌዛ፤ ኡንትካ ኤዝኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ኡንትካ ፓር የዞዳይ ጋርከኔ ቃላ ታማርሶዳይ ጋርክ ታጶ ናምእታ ዶሪ፥ ኡንታን፥ «ሀዋርታ» ግ ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ቱና አያንታካ ከሶዳይ ጋርክ ኡንትስ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ኤ ዶሬዝ ታጶ ናምእታይ Ꮊይትታ፦ ጵጽሮሳ ዬግንቲ ጼግንትዝ ስሞና፥ ");
INSERT INTO mfxe_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ቦአነርገሰ (ዳዳ ናእታ) ዬጊ ሱንꬅ ጋዴዝታ፥ ዛብዶሳ ናእታ ያይቆባራኔ ያይቆባ እሻ ዋንሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","እንድራሰ፥ ፍልጶሳ፥ ባርቶሎሞሳ፥ ማቶሳ፥ ቶማሳ፥ ኢልፎሳ ናአ ያይቆባ፥ ታዶሳ፥ ካናነፕ ማቄዝ ስሞናራኔ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","የሱሳ ኣꬂ እንጌዝ አስቆሮቶ ይሁዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","የይፕ ጉየ፥ የሱሳ ካራ ገሌዛ። ማ ጋመ አሳይ ሺቅን፥ ኤዛራ ኤ ታማርታይ ሀራ አቶዝን ካꬃ ማዳይስካ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","አሳይ ኤዛ፥ «ኤይዛ» ግዝ ግሾስ ኤ ዳብታይ የያ ስኢ ኤዛ አይኮዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ህገ አስታማርታይፕ ፐታይ ፐታይ የሩሳላመፕ ይኢ፥ «ኤዛል አፋ ብኤልዘቡላ የዛ»፥ ኤ፥ «ጻላሄ ዎልቃር ጻላሄ አያንታ ከስዛ» ዬጊ ዎላ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","የሱሳ አስታ ፋኮ ጼጊ ኣዝሶ ኦዴዛ። «ጻላሄ ጻላሄ ዋይዚ ከሶዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ፐቲ ካተትꬃይ ፋ ጋንጨ ሻኮ ከስኮ ያ ካተትꬃይ ኤቆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","የይ ጋርክ፥ ፐቲ ካራ አሳይካ ዎል ጋንጨ ሻኮ መꬍኮ ꬋቦዳይፕ አትን የዞዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ይኬ፥ ጻላሄ ዎልር ሞርክንቲ ዱጽኮ ꬋቦዳይፕ አትን የዞዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«ዝን ቲናቲ ዎልቃማ አꬃ አጨካዛር ኤ ካራ ገሊ፥ ኤ ሻላ ቦንቆዳይስ ዳንዳእዛ አሲ ባያ። አጪ ማቄዛይፕ ኤ ካራ ቦንቆዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«ታ ይንትስ ቱሮ ኦድዛ፤ ጾሲ አስ ናእታይስ ናጋራ ኡባኔ ኡ ጫዤዝ ጫሽ ኡባ አቶ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ዝን ጌሻ አያናል አፋ ኢታ ባዝ ኦድንትዛ ኦስካ መꬍናስ ናጋራ ማቆዳይፕ አትን ጾሲ ኡባራካ ኤዛ ማራሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","የሱሳ የያ ጌዛይ፥ አሳይ፥ «ኤዛል አፋ ቱና አያና የዛ» ዬጌዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ኤ እንዳትኔ ኤ እሽታይ ይኢ ባለ ኤቂ፥ ኤዛ ጼግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ኤ ላንቀ በቴዝ ጋመ አስታይ፥ «ነ እንዳትራኔ ነ እሽታይር ባለ ኤቂ ነና ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","የሱሳ ማሂ፥ «ታ እንዳት ኦኖ? ማ ታ እሽታይ ኣይታ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ፋ ካለ በቴዝ አሳ ዩዪ ብኢ፥ «ታ እንዳትኔ ታ እሽታይ Ꮊይትታ። ");
INSERT INTO mfxe_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ጾስ አዛዞ ኦꬅዝ ኡቢታይ ታ እሸ፥ ታ ምሾ ታ ኣዮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","የሱሳ ማካ ጋልላ አባ ካለ ታማርሶ አይኬዛ። አቆፕ ኣꬌዝ ጋመ አስታይ ኤ ላንቃይር ሺቅን፥ አባይል የዝ ዎጎላይ ጋንጨ ገሊ በቴዛ፥ አሳይ ኡቢታይ አባ ላንቀ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ኤ ኡንታን ጋመ ባዝ ኣዝሶር ታማርሴዛ። ታማርስታር Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ስኦይታ! ፐቲ አꬃይ ዘርꬅ ዘሮዳይስ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ኤ ዘሮዳር፥ ፐቲ ፐቲ ዘርꬃይ ኦገ አቻ ዎꬌዛ፤ ካፍታይ ይኢ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ፐቲ ፐቲ ዘርꬃይ ስስንቆ ኣዳ የዝ ቢታል አፋ ዎꬌዛ። አፋር ቢታ ባዛይ ግሾስ የ ዘርꬃይ ኤልሲ ዶሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ዝን አዋ ከዜዝ ዎደ ሹሌዛ። ሎእꬂ ጻጶ ዳከካ ግሾስ ኤልሲ መሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ፐቲ ፐቲ ዘርꬅታይ አንጉꬅ ጋንጨ ዎꬌዛ። ዶሌዛኖ አንጉꬂ ድጪ ጩሌዝ ግሾስ ኣፈ ኣፋም እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ፐቲ ፐቲ ዘርꬅታይ አራዳ ቢታል ዎꬊ ዶሌዛ። ድጪ ፐታይ ሀስታም፥ ፐታይ ኡሱፑንታም ፐታይ ጼት ኣፌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","«ስእዝ ሀየር የዝ ኦንካ ስኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","የሱሳ ካለር የዝ አስታይኔ ታጶ ናምኢ ታማርታይ የሱሳ ፋ ኣዳ የዝን፥ ኤዝኮ ሺቂ ያ ኣዝሳይስ ብልእꬃ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","የሱሳ ኡንትኮ Ꮊይ ጋርክ ዬጌዛ፦ «ይንትስ ጾስ ካተትꬂ ጹራ ኤረትꬂ እንግንቴዛ። ዝን Ꮊንክታይስ ካተትꬃፕ ባለ የዝታይስ ኡባ ባዝ ኣዝሶር ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","የይካ፥ « ‹ኡ ቢእዛ፥ ዝን ደንጎያ። ስእዛ፥ ዝን አካኮያ። ኡ ደንግዛኮኔ አካክዛኮ፥ ጾስኮ ማቆዳ ኤዝካ ኡንታን ማሮዳዝኒ› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","የሱሳ ኡንትኮ፥ «Ꮊ ኣዝሳይ ይንትስካ ገሎሳ? የዝን፥ Ꮊንኮ ኣዝስታ ኡባ ይ ዋይዚ አካኮዴ? ");
INSERT INTO mfxe_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ዘርዛይ ጾስ ቃላ ዘርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ቃላይ ዘርንቶዳር ኦገ ካንታ ዎꬌዝታይ ቃላ ስኤዝታ። ዝን ጻላሄ እዝር ይኢ፥ ኡ ዎዝናይድ ዘርንቴዝ ቃላ ማጺ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","የይ ጋርክ፥ ስስንቆ የዝ ቢታይል ዘርንቴዛይ ቃላ ስኢ፥ ኤልሲ ኡፋይቲ ኤክዝታ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ዝን ኡንትስ ጻጶ ባዛይ ግሾስ ጨረ Ꮊተሳፕ አትን ጋምኦያ። ጽቃ ዎደፕ ጉየ ቃላ ግሾ መቶ ዎይ ባይእꬂ ሄልኮ ኤልሲ ꬉብንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","አንጉꬅ ጋንጨ ዘርንቴዛይ ቃላ ስእዝታ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ዝን Ꮊ ሳአ የስስ ህርጋ፥ ዱረትꬅ ቃኔ ሀራ ባዝ አሞትꬂ ኤ ዎዝናይድ ገሊ ቃላ ጩልዛ ግሾስ ኣፈ ኣፈካዛር አትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ዝን አራዳ ቢታል ዘርንቴዝታይ ቃላ ስኢ ኤክዝታ። ኡንትካ ፐታይ ሀስታም፥ ፐታይ ኡሱፑንታም ፐታይ ጼት ኣፍዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","የሱሳ ጉጂ፥ «ጾምፐ አይꬂ፥ ኦታ ጋንጨ ዎይ አርሳ ኦሞ ጋድዝ አሲ የኔ? ꬎቃ አቆ ጋዶሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ይኬ፥ ቆስንቴዝ ባዝ ኡቢታይ ከዘካዛር፤ ዙርንቴዝ ባዝ ኡባይ ፕ በንተካዛር አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ስእዝ ሀየ የዝ ኦንካ ስኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ማ ኡንትኮ፥ «ይንቲ ስእዝ ባዝ አካኪ ስኦይታ! ጾስ ቃላ ይ ስእዛን ጋርክ ኤ ይንትስ አካካ እንጎዳ። ይ ማክዝ ባዛር ይንትስ ማኮዳ። ኤዛይፐካ ይንትስ ጋንꬂ እንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ፐቲ ባዝ የዛ አꬃይስ ጉጅንቲ እንግንቶዳ፥ ባዛይፕ ሀራ አቶዝን፥ የዛን እዛካ ኤፕ ኤክንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","የሱሳ ማሂ፥ «ጾሳ ካተትꬃይ ፋ ጋደ ዘርꬅ ዘርዝ አስ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","የ አꬃይ ቃማ ገንትዛ፤ ጉራ ጎዲ ደንድዛ። ኤ ዋይዛኮ ኤረካዝን ያ ዘርꬃይ ዶሊ ድጭዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ቢታታ ፋ ኣዳስ ካꬃ እንግዛ። ቲና ጫረ፥ የይፕ ኣፎዳይስ ጋምቡጽዛ፥ ዉርስꬃላ ኩንꬅ ኣፈ ኣፍዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ዝን ካꬃይ ማጾስ ሄልኮ አꬃይ ኤልሲ ማጾ አይክዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","የሱሳ፥ «ኑኒ ጾስ ካተትꬂ አብ ኣዝዛ ጎደ? ዎይ አባር ኣዝሶዴ? ");
INSERT INTO mfxe_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ጾስ ካተትꬃይ ሳናፍጨ ኣፈ ኣዝዛ። የ ምꬃቲ አፋ ዘሮዳር ሳአ የዝ ምꬂ ኣፈ ኡባይፕ ጽቅዛራ ");
INSERT INTO mfxe_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ዘርኮ ዶሊ ድጪ ምꬅ ኡባይፕ ኣꬊዝ፤ ግታ ሻቆ ከስዛ። ሳሎ ካፍታይ እ ሻቃይል አፋ ኬጺ በቶድ ጋꬆ ዳዥዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","የሱሳ Ꮊይ ጋርክ ኡንደና ኣዝሶ አስታይ አካኮዳይስ ዳንዳእዛይ ጋርክ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","አሳይስ ኣዝሶ ባዝን ኦዶያ። ዝን የሱሳ ፋ ታማርታይር ኣዳ የዛ ዎደ ኡንትስ ብልኢ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","የ ጋላስ ሳአይ ኦማꬅን፥ የሱሳ ፋ ታማርታይኮ፥ «አባፕ ሰኮ ፕኖ ዎላ ፒንጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ኤ ታማርታይ ዎይታ ኦሊ አሺ፥ የሱሳ ቲና ገሊ በቴዝ ዎጎልተ ገሊ የሱሳና ፓር ካንጌዛ። ሀራ ዎጎልታይ ኤዛይድ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ዎልቃማ ጎተካ ደንዲ፥ ዎጎላይ ጋንጨ ሃꬂ ኩሞድ ጋꬆ ዙላይ ሾጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","የ ዎደ የሱሳ ዎጎላይስ ጉየ ባጋር ቦርኮꬂ ገንቴዛ። ኤ ታማርታይ ኤዛ ደንꬂ፥ «አስታማራዮ፥ ኑኒ ꬋቦዳር ነ ስኤ ግ ብእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ኤ ባርኪ ጎታና፥ «ስኤ ጎባ» ዬጊ፥ አባናካ፥ «ሀይዞባ» ጌዛ። ጎታይካ ስኤ ግን ኡባ ባዝ ጭጭርክ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","የሱሳ ፋ ታማርታይኮ፥ «Ꮊይ ጋርክ ይንታን ያሾዳይ አባ? ይንትስ አማኖ አብስ ꬋቤኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ኡንቲ ኢታ ያሻ ያሽቲ ዎል ጋንጨ፥ «Ꮊይ ሀራ አቶዝን፥ ጎተነ አባ አዛዝንትዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","የሱሳራኔ ኤ ታማርታይ አባ ፒንጊ፥ ገርገሶና ግዝ ጋደ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","የሱሳ ዎጎላይፕ ዎꬌዛን ጋርክ ቱና አያና አይኬዝ ፐቲ አꬃይ ዱፎፕ ከዚ ኤዛ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","የ አꬃይ ዱፎ ጋንጨ አቅታር ፔዥታር የዛ። ኤዛ ኦንካ ሳንꬃላተር አጮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ኤ ጋመ ዎደ ዱኩልንቲ ሳንꬃላተር አጭንቲ የዛ። ዝን ሳንꬃላታ ዱስርꬅዛ፥ ዱꬃካ መንꬅርꬅዛ። ኤዛ ካዮዳይስ ዳንዳእዛ ኦንካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ኤ ቃማኔ ጋላስ ያ ዱፋይዳኔ ደረል አፋ ኡክዛ፥ ፋ ጋላካ ሹቻር ካርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","የሱሳና ሃኮር ብኢ ዎጺ Ꮊንጊ ኤ ቲናይድ ጹጉኒ ጎይኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","የ አꬃይ ፋ ቃላ ꬎቅ ኡዲ፥ «ኡባይፕ ኣꬎ ጾሳ ናአ የሱሳ፥ ነናኔ ታና አባ ሄልꬅዛይ? ታና ꬋብሳማይ ጋርክ ታ ነና ጾሳ ሱንꬃር ዎስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ኤ የያ ጌዛይ የሱሳ ኤዛ፥ «ናት Ꮊ ቱና አያናዮ፥ Ꮊ አꬃይፕ ከዞባ» ዬጊ ኪቴዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","የሱሳ ኤዝኮ፥ «ነ ሱንꬃይ ኦኖ?» ዬጊ ኦይጬዛ። ኤ፥ «ኑኒ ጋመ ማቄዝ ግሾስ ታ ሱንꬃይ ሌጎና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ቱና አያንታይ ፋና ያ ጋዳይፕ ከሲ ዳካማይ ጋርክ የሱሳና ሚንꬂ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","የ ደራይል አፋ ጋመ ጉዳይለ ዉደ ሄንግንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ቱና አያንታይ የሱሳኮ፥ «ኑና ሰኮ ጉዳይለ ዉዳይኮ ዳኮየ፥ ኡ ጋንጨ Ꮊንጊ ኑ ገሎዳ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","የሱሳ ኡንትኮ፥ «ቅቶይታ» ዬጌዛ። ዬግን ቱና አያንታይ አꬃይፕ ከዚ ጉዳይልታይል ገሌዛ። ናምኢ ሙኩለ ማቆድ ጉዳይለ ዉዳይ ጋጋ ዶናር ድርጊ Ꮊንጊ አባ ጋንጨ ገሊ ምትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ጉዳይለ ዉደ ሄንግዝታይ ያሽቲ Ꮊንጊ ሀኔዝባዛና ካታማስኔ ጋጻረስ ኦዴዛ። የይፐ አሳይ ሀኔዝባዛና በአዳይስ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","አሳይ የሱሳኮ ይእታር ቱና አያናይ ኤፕ ከዜዝ አꬃ በኤዛ። ኤ ዎዝናይ ማቅን፥ አፍላ ማኢ፥ ኤዛይድ በቴዛና ብኢ ኡቢታይ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","የያ በኤዝ አስታይ ቱና አያንታይ አይኬዛ አꬃይል አፋኔ ጉዳይልታይል አፋ ሀኔዝባዛና ኡባ አስስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","የይ ግሾስ፥ አሳይ ፋ ቢታይፕ የሱሳ ከዚ ቅቶዳይ ጋርክ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","የሱሳ ዎጎላይል አፋ ከሳዳር ቲን ቱና አያና አይኪ ዳኬዝ አꬃይ፥ የሱሳር Ꮊማዳይስ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ዝን የሱሳ እጺ ኤዝኮ፥ «ነ ካራ ማቂ፥ ጎዳይ ኔስ አብ ጋርክ ማሮትꬅ ኦꬄዛኮ ኔስ ዋፋ ኬሄዛኮ ነ ካራ አሳይስ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","አꬃይ Ꮊንጊ ታጲ ካታማ ግንትዝ አቆ ዩዪ፥ የሱሳ ኤዝስ አብ ጋርክ ማሮትꬅ ኦꬄዛኮ ኦዴዛ። ኤ ኦዴዛና ስኤዝ አስ ኡቢታይ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","የሱሳ ማቂ፥ ዎጎሎ ጋንጨ ገሊ፥ አባ ፒንጌዛይፕ ጉየ ጋመ አሳይ አባ ጋጻ ኤ ካለ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ኢያሮሳ ግዝ አይሁድታይ ዎሳ ኬꬅ ሀላቅታይፕ ፐታይ፥ የሱሳና በኤዝ ዎደ ኤዝኮ ይኢ ኤ ቶካይል አፋ ዎꬊ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","«ታ ናአታ ሀርግንቲ Ꮊይቆድ ሀንዛ። እዛ ፓጾድ ጋርክ ይኢ ነ ኩሸ እዝል አፋ ጋዶዬ» ዬጊ የሱሳና ሚንꬂ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","የሱሳ ኢያሮሳር Ꮊንጌዛ። ኤ Ꮊማዳር ጋመ አስ ኤዛ ካልታር ኡርቅꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ታጶ ናምኢ ላይꬅ እዝላፕ ሱꬂ ጎጌዝ ፐቲ አስታ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ጋመ አክምታይ እዞ አክሜዝን፥ እዛ ፓꬅ ኤቃ ካእንትዛ። እዛ ፋ ሚሻ ኡባ ዉርስንካ ኢስ Ꮊና ኢቴዛይፕ አትን አብካ እዞ ማደካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","የ አስታ የሱሳ ዋራ ስኤዝ፥ ግሾስ አሳይፕ ኣꬊ የሱሳስ ጉይጉꬃር ይኢ ኤ አፍላ ቦቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","እዛ፥ «ታ ሀራ አቶዝን ኤ አፍላ ማንቻቶ ቦቼዛኮ ፓጾዳ» ግ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","እዝፕ ጎግዝ ሱꬃይ እዝር ኤቂ አቴዛ። እዛ ፋ ዋያይፕ ፓጼዛና ፋ ጋላይል ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","የሱሳ ኤልሲ ፓፕ ዎልቃ ከዜዛና ፋ ኡባስ ኤሪ፥ ጋመ አሳይ ጋንጨ ጉየ ማቂ፥ «ታ አፍላ ቦቼዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ኤ ታማርታይ፥ «አሳይ ነና ኡርቅዛ ብእታር፥ ‹ኦኖ ታና ቦቼዛይ ዬጊ ዋይዚ ኦይጨ?› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","የሱሳ የያ ኦ ኦꬄዛኮ ኤሮዳይስ ዩዪ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ዝን አስታ ፓስ ሀኔዝባዛና ኤሪ፥ ያሻር ኩኩርታር ይኢ የሱሳ ቲናይድ ጉጲንጊ፤ ፋ ጽላት ኡባ ኤስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ዬይን፥ የሱሳ እዝኮ፥ «ታናአተ፥ ነና ነ አማናይ ፓꬄዛ፥ ሳሮ Ꮊንጎባ፥ ነ ዋያይፐካ ፓጾባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","የሱሳ ሀጋ Ꮊያ ኦዶዳር፥ አይሁደ ዎሳ ኬꬅ ሀላቃይ ካራፕ ኪትንቴዝ አስታይ ይኢ፥ «ነ ናአታ Ꮊይቄዛ፥ Ꮊት አስታማራ አብስ ዳቡርሰ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ዝን የሱሳ ኡ ግዛና ስኢ፥ አይሁድታይ ዎሳ ኬꬅ ሀላቃይኮ፥ «አማኖ ኣዳ አማኖባፕ አትን ያሽትፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","የሱሳ ጵጽሮሳፕ፥ ያይቆባፐኔ ያይቆባ እሻ ዋንሳፕ ሀራ ኦንካ ፋና ካላማይ ጋርክ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ኡንቲ አይሁደ ዎሳ ኬꬅ ሀላቃይ ካራ ሄሎዳር የሱሳ አሳይ ዬኮዳር፥ ዘላሎዳራኔ ኡኮዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ገሊ አስታይኮ፥ «Ꮊ ኡባ ዬፋይኔ ኡፋይ አብሶ? ናአታ ገንቴዛፕ አትን Ꮊይቀካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","አሳይ ኤዛ ለቂ ሚጬዛ። ዝን አስ ኡብታ ባለ ከሲ፥ ናአቲ ኣዳ፥ እንዳቶኔ ሀይꬒ ታማርታ ፓር ኤኪ ናአታ የዛበሳ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","የሱሳ ናአቲ ኩሻ አይኪ፥ «ጻልታ፥ ኩሚ» ጌዛ። ብልꬃይካ (ጽቃ ናአተ፥ ነና ግዛ ደንዶባ) ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","እዛ ታጶ ናምኢ ላይꬅ ናአዛር እዝር ደንዲ ኤቂ የꬍꬅ አይኬዛ። የይካ ሀኔዛ ብኢ አሳይ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","የሱሳ የያ ኡ ኦስካ ኦዳማይ ጋርክ ኡንታን ሚንꬂ አዛዜዛ። ናአትስ ሚዝ ባዝ እማድ ጋርክ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","የሱሳ የይፕ ከዚ፥ ፋ ታማርታ ካልꬂ፥ ፋ ካታማ ናዝረተ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ማላ ጋላስ አይሁደ ዎሳ ኬꬃ ታማርሶ አይኬዛ። ኤ ታማርስዛና ስኤዝ ጋመ አሳይ Ꮊይ ማላባዝ ግ፥ «Ꮊይ Ꮊ ኡባ አናፕ ደንጌኔ? Ꮊይ ኤስ እንግንቴዝ ኤጨትꬃይ ዋፋ? Ꮊ ማላትታ ኦꬅዛ ማዉታይ ኤስ ዋይዚ እንግንቴነ? ");
INSERT INTO mfxe_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ꮊይ አናጻ ባሳ? ማይራሚ ናአ፥ ያይቆባ፥ ዮሳ፥ ይሁዳራኔ ስሞና እሻ ባሳ? ኤ ምሹንꬅካ ኑር Ꮊኔ የዙንꬁን ባሳኔ?» ዬጊ፥ ኤ ኦድዛና ኤካም እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","የሱሳ የ አስታይኮ፥ «ናበ ፋ ጋደላ፥ ፋ ዳብታይዳኔ ፋ ካራ አስ ጋንጨ ቦንችንቶያፕ አትን Ꮊንክታይ ካለ ቦንችንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ኤ የ አቃይድ ፋ ኩሻ ሀርግንትዛ ጽቃ አስታይል አፋ ጋዲ ፓꬄዛይፕ አትን ሀራ ማላታ ባዝ ኦꬆዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","አሳይ አማናም እጼዝ ግሾስ ፓላ ባዝ ጌዛ። የይፕ ጉየ፥ የሱሳ የ ሄራፕ ሀራ ሄራ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","የሱሳ ታጶ ናምኢ ታማርታ ፋኮ ጼጊ፥ ናምኤ ናምኤ ዎል ሄልꬂ ኪቴዛ። ኡንትስ ቱና አያንታይል አፋ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ኡንታን፥ «ኦገስ ጉፈ ኣዳፕ አትን ካꬃ፥ ቁርቦ፥ ይ ኪሰ ሚሸ አባባዝካ አይክፓቴ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ይ ቶኬ ጫማ ኣꬆይታ፥ ዝን ላመ አፍላካ አይክፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ማካ፥ «ይንታን አሲ ሞኬዝ ካራ አባካ ማቅን የ አቃቶ አሺ ቅቶድ ጋꬆ የ ካርቴ ጋምኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ይንታን አሲ ሞኮዋ ካራ ዎይ ይ ኦድዛ ባዝ ስኦዋ ካራ አባካ ማቅኮ፥ የ ቢታተ የዝ አሳይስ የይ ማርካ ማቃዳይ ጋርክ የ አቃይፕ ከዝታር፥ ይ ቶካይፕ ቡልአ ትቅሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ታጶ ናምኢ ታማርታይ Ꮊንጊ፥ አሳይ ፋ ናጋራይፕ ማቃዳይ ጋርክ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ኡንቲ አሳይፕ ጋመ ቱና አያንታ ከሴዛ። ጋመ ሀርግንቴዝታ ዛይተ ትዢ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","የሱሳ ሱንꬃይ ኡባ አቆ ከዜዛይ ግሾስ ካታይ ሄሮዶሳ ኤ ባጋ ስኤዛ። ፐቲ ፐቲ አሳይ፥ «ጻማቅዛ ዋንሳ Ꮊይቆፕ ደንዴዛ፥ የይ ባጋር Ꮊ ማላትታ ኦꬅዛይ ኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ባግታይ፥ «Ꮊይ ኤላሳ» ዬጌዛ። Ꮊንክታይ ማ፥ «Ꮊይ ብኒ ዎደ ናብታይፕ ፐታይ ጋርክ ማቅꬅ አታሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ዝን ሄሮዶሳ የያ ስኢ «Ꮊይ ታ ቆ ጋችሴዝ ጻማቅዛ ዋንሳ ኤ Ꮊይቆፕ ደንዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ሄሮዶሳ ፋ እሻይ ፍልጶሳ ማቻቶ ሄሮዳዳ ኤኬዝ ግሾስ ዋንሳ አይꬂ አጭሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ዋንሳ ሄሮዶሳ፥ «ነ ነ እሻይ ማቻቶ ኤኮዳይስ ቤዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ሄሮዳዳ ዋንሳ ፋ ኡሎር ሞርኪ ኤዛ ዎꬍሶዳይስ ኮዬዛ፥ ዝን ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ዋንሳ ጽሎኔ ጌሽ አስ ማቄዛና ሄሮዶሳ ኤሬዝ ባጋር ኤዝስ ያሽቲ ሚንꬂ ናጌዛ። ሄሮዶሳ ዋንሳ ናሻ ስኢ ኡፋይትዛራካ ሞርእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ሄሮዶሳ ፋ የልንቴዝ ጋላሳ ቦንቾዳይስ ጋደ አቅስዝታይስ፥ ሻላቅታይስኔ ጋልላ የዝ ዳማ አሳይስ እማቶ ጊግሴዛ። የይ ሄሮዳዳስ ሎኦ ጋላስ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ሄሮዳዳ ናአታ እማꬅ ሞክንትዛ አቃይድ ገሊ ዶንጊ፥ ሄሮዶሳኔ ኤ እማꬅታ ኡፋይሴዛ። ካታይ ናአትስ፥ «ነ ኮይዝ ባዝ አብ ማቅኮካ ታና ኦይጮባ፥ ታ ኔስ እማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ማ እዝስ ጫቂ፥ «ነ ኦይጭዝ ባዝ አብ ማቅኮካ፥ ታ ኔስ እማዳ። ሀራ አቶዝን፥ ታ ካተትꬃይ ባጋ ማቅኮካ ታ ኔስ እማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ናአታ ባለ ከዚ ፋ እንዳትኮ፥ «አብ እንጎባ ግ ኦይጮ?» ግ ኦይጬዛ። እ እንዳት፥ «ጻማቅዛ ዋንሳ ኦማ እንጎ ጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ናአታ ኤልሲ ካታይኮ Ꮊንጊ፥ «ጻማቅዛ ዋንሳ ቆꬋትፕ ጋቺ ፕልኦ ጋንጨ ጋዲ Ꮊት ታስ እማዳይ ጋርክ ታ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ዬግን ካታይ ኡንደና ቂራꬌዛ ዝን ፋ እማꬅታይ ግሾ እዝስ ጫቄዝ ፋ ጫቃ መንꬆዳይስ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","የይ ግሾስ፥ ኤልሲ ናግዛ አꬃ ዋንሳ ኦማ ኮኦዳይ ጋርክ ኪቴዛ። ናግዛ አꬃይ አች ኬꬅ Ꮊንጊ ዋንሳ ቆꬋ ጋቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","የ ጋችንቴዝ ኦማ ፕልኦ ጋንጨ ጋዲ ክኢ ናአትስ እንጌዛ። ናአታካ ማ ፋ እንዳትስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ዋንሳ ታማርታይ የያ ስኤዝ ዎደ Ꮊንጊ ኤ አሃ ኤኪ ካንጊ ሞጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ሀዋርታይ ማቂ ይኢ የሱሳኮ ሺቂ ኡ ኦꬄዝባዝኔ ታማርሴዛ ባዝ ኡባ የሱሳስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ኡንትኮ ይእዛ አሳይኔ ቅትዛ አሳይ ጋንጌዝ ግሾስ የሱሳራኔ ኤ ታማርታይ፥ ሀራ አቶዝን ካꬃ ማዳይስካ ኡንትስ ዎደ ꬋቤዛ። ዬይን፥ የሱሳ ኡንትኮ፥ «ኑስካ ጽቃል ሸምፕ ኤኮዳይስ አሲ ባ አቆ የꬎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","የይ ግሾስ፥ ኡንቲ ፋ ኣዳስ ዎጎሎ ጋንጨ ገሊ አሲ ባ አቆ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ኡ Ꮊማዳር ጋመ አስታይ ኡንታን ብኢ ኤሬዛ። የዝን፥ ካታማ ኡባፕ አሲ ቶከር ዎጺ Ꮊንጊ ኡ Ꮊንግዛ አቃይድ ኡንታፕ ቲናቲ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","የሱሳ ዎጎሎፕ ዎꬊ ጋመ ዎያ በኤዛ። አሳይ ሄንግዝ አሲ ባ ዱር ጋርክ ማቄዛና ብኢ ኡንትስ ቃꬊንቲ ኡንታን ጋመ ባዝ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ሳአይ አዋ ኣꬎዳር የሱሳ ታማርታይ ኤዝኮ ይኢ፥ «Ꮊ አቃይ ሊዦ፤ Ꮊት ሳአይ ኦማꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","አሳይ ሄራራኔ ካታማር Ꮊንጊ ፓስ ሚዝ ባዝ ዎንጎድ ጋርክ አሳ ዳኮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ዝን የሱሳ ማሂ ኡንትኮ፥ «አሳይስ ሚዝ ባዝ ይ እንጎይታ» ዬጌዛ። ኡ፥ የዝን «ኑኒ Ꮊንጊ ናምኢ ጼት ዲናረር ሶሎ ዎንጊ እማደኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","የሱሳ ኡንትኮ፥ «ይንትስ ኣፑን ሶሎ የኔ? አን Ꮊንጊ ቦኦይታ» ዬጌዛ። ኡ ብኢ፥ «እችን ሶሎራኔ ናምኢ ሞሎር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","የሱሳ ፋ ታማርታ አሳ ኡባ ጩጋር ጩጋር ሻኪ ማታል በትꬆዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","አሳይ ባጋይ ጼት፥ ባግታይ እሻታም ማቂ ጩጋር ጩጋር ሻክንቲ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","የሱሳ እችን ሶሎራኔ ናምኢ ሞልታ ኤኪ፥ ሳሎ ብኢ ጾሳ ጋላቴዛ። ሶላ ዱꬂ አሳይስ ግሾዳይ ጋርክ ፋ ታማርታይስ እንጌዛ። ማ ናምኢ ሞልታ ኡ ኡቢታይስ ሻኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","አስ ኡቢታይ ም ምዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","አቴዝ ሶሎ ጉፋኔ ሞሎ ጉፋ፥ ኤ ታማርታይ ታጶ ናምኢ ሌማተ ኩንꬅ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ሶሎ ሜዝ ꬊራꬅ አስታይ ኣዳ እችን ሙኩለ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ኤልሲ የሱሳ ፋ ታማርታይ ዎጎሎ ጋንጨ ገሊ፥ አባፕ ሰኮፍኖ የዝ ቢታ ቤተሳይዳ Ꮊንጎዳይፕ ቲናቲ ቅቶዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","አሳ ሞይዜዛይፕ ጉየ ጾስ ዎሶዳይስ ደረል አፋ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ሳአ ቃሞዳር ዎጎላይ አባ ጋንጨ የዝን፥ የሱሳ አባ ጋጻ ፋ ኣዳ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ጫርኮ ኤ ታማርታይኮ ጫርክዝ ግሾስ አባ ፕꬊꬃይ ዋይꬅዛና የሱሳ በኤዛ። ዎንትማꬄ ሹጉላ ኡኮዳር ኤ አባል አፋር የꬍታር ኡንትኮ ይኢ፥ ኡንታን ኦሊ ኣꬎዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ዝን ኤ አባል አፋ የꬎዳር፥ ኡ ብኢ፥ ኡንትስ ሜሸ ኣዝን ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ኡ ኡቢታይ ኤዛ ብኢ፥ ያሽቲ ዳጋሜዛ። ዝን የሱሳ ኤልሲ ኡንትኮ፥ «ታና፥ አኮ ባያ፤ ያሽትፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","የሱሳ ዎጎላይድ ገሊ ኡንታር ዎላ በትን ጫርካይ ስእ አቴዛ። ኡንቲ ግታ ማላ ባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ኡ ዎዝናይ ዶጬዝ ግሾስ ሶላይል ኦꬄዝ ማላታ ኡንቲ አካኬካያፕ አትን Ꮊይ ኡንትስ ማላባዝ ባቦናዝን። ");
INSERT INTO mfxe_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ኡንቲ አባ ፒንጊ፥ ገንሳሬጼ ቢታ ሄሊ፥ ዎጎላ ጋጻል ሺሺ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ኡ ዎጎላይፕ ዎꬎዳር አሳይ ኤልሲ የሱሳና ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ኡ ሄራ የዝ ቢታ ኡባ ዎጽቲ ሀርግንቴዝ አስታ ሀላር ቶኪ፥ «የሱሳ የዛ» ጌዝ አቃይድ ክእꬅ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","አሳይ ኤ Ꮊንጌዝ ካራ ኡባ፥ ጋጻረ ማቅን፥ ካታማ፥ የዝ ሀርግንቴዝ አስታ ቡጫል ካንግዛ። ሀርግንቴዝ አስታይ ኤ አፍላ ማንቻ ማቅኮካ ቦቾድ ጋርክ አሳይ ኤዛ ዎሴዛ። ቦቼዝ ኡቢታይ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","የሩሳላመፕ የኤዝ ፈርሳውታይራ ፐቲ ፐቲ ህገ አስታማርታይ የሱሳ ካለ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","የሱሳ ታማርታይፕ ፐታይ ፐታይ ጌዠካ ኩሸር፥ የይካ ኩሸ ሜጭንተካዛር ካꬃ ሚዝታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፈርሳውታይኔ አይሁድታይ አሲ ኡባይ ፋ አድታይ ዎጋይ ጋርክ ፋ ኩሸ ሎእꬂ ሜጭንተካዛር ሞያ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","የይ ጋርክ፥ ኡንቲ ጋበፕ ማቂ ሜጨካዛር ሞያ። ማ ኡንቲ ፋ አድታይፕ ኤኬዝ ሀራ ጋመ ዎጋ የዛ፦ የይካ ዋንጫ፥ ኦታ፥ ብራታ ሚሸራ አርሳ ሜጭዝ ዎጋ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ፈርሳውታይራኔ ህገ አስታማርታይ የሱሳ፥ «ነ ታማርታይ አብሶ አድታይ ዎጋ መንꬂ ፋ ኩሸ ሜጭንተካዛር ካꬃ ሚዛይ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","የሱሳ ኡንትኮ፥ «ናበ ኢሳያሳ ይንትስ ጩቢታይስ፥ « ‹Ꮊ አሳይ ታና ፋ እራንꬅ ኣዳር ቦንችዛ፥ ዝን ኡ ዎዝናይ ታፕ ሃኮ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","አሲ ኮቼዝ ዎጋ ጾስ ህገ ኣዝሲ ታማርስዛ ግሾ ኡ ታና ጨር ጎይንዛ› » ዬጊ ጻፌዛይ ቱሮ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«ይንቲ ጾስ ኪታ አሺ አስ ዎጋ ናግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ማካ የሱሳ፥ «ይንቲ ይ ዎጋ ናጎዳይስ ግ ጾስ ኪታ ኦሊ አሼዛ ");
INSERT INTO mfxe_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሰ፥ ‹ነ አደኔ ነ እንዶ ቦንቾባ›፥ ማ ‹ፋ አዳኔ ዎይ ፋ እንዶ ጫዥዛይ Ꮊይቆዳይስ ቤዝዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ዝን ይ ዬግዛ ፐቲ አꬃይ ፋ ኣዳ ዎይ ፋ እንዳቶ ማዶዳ አሺ፥ ‹Ꮊይ ጾሳ ያርሾ› ጊኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ኤ ፋ ኣዳ ዎይ ፋ እንዳቶ ማዳም ጋርክ ይ ኡድዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","የይ ጋርክ፥ ይ Ꮊንክታ ታማርሴዝ ይ ዎጋይድ ጾሳ ቃላ ለቄዛ። የይ ጋርክ ሀራ ጋመ ባዝ ኦꬅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","የሱሳ ጋመ አሳ ማካ ፋኮ ጼጊ፥ «ኡባይ ታ ኦድዛ ስኦይታኔ አካኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","አስ ዎዝናፕ ከዝዝ ባዝ አስ ቱንስዛፕ አትን ባለፕ አስ ኡሎ ገሊ አስ ቱንስዛ ባዝ አብካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ስእዝ ሀየር የዝ ኦንካ ስኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","የሱሳ ጋመ አሳ ኦሊ አሺ ኬꬃ ገልን ኤ ታማርታይ የ ኣዝሳይ ባጋ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ኤ ኡንትኮ፥ «ይንትስካ ማ ገለካሳ? ባለፕ አስ ጋንጨ ገልዛ ባዝ አብካ አስ ቱንሶዳይስ ዳንዳኦዛና አካኮሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","አብስ ጊኮ፥ ካꬃ አስ ዶናር ኡሎ ጋንጨ ገሊ ኤዛይር ባለ ከዝዛይፕ አትን አስ ዎዝና ጋንጨ ገሎያ» ዬጌዛ። ኤዛይድ የሱሳ ካꬃ ኡባይ ጌሺ ማቄዛና ኤርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ጉጅካ፥ የሱሳ፥ «አስ ቱንስዛ ባዝ አስ ዎዝና ጋንጨፕ ከዝዝ ባዚ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","አስ ዎዝና ጋንጨፕ ከዝዝ ባዝ ዎቦ ቆፋ፥ ላግታ፥ ካስቶ፥ አስ ዎꬎ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ላመ፥ ኢታ አሞትꬂ፥ ኢታትꬂ፥ ገነ፥ ቃይጸ፥ ዶሻ፥ ቅናተ፥ ጫሸ፥ ኡትራኔ ቦዛትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ꮊ ኢታ ባዝ ኡባይካ አስ ዎዝና ጋንጨፕ ከዚ አስ ቱንስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","የሱሳ የይፕ ከዚ፥ ጽሮሳ ካታማ ካለ የዝ ጋደ Ꮊንጌዛ። ኤ ፐቲ ካራ ገሊ ኤዛይድ የዛና ኦንካ ኤሮድ ጋርክ ኮየካያ። ዝን ቆስንቲ ጋምኦዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ዝን እ ጽቃ ናአቶ ቱና አያና አይኬዝ ፐቲ አስታ የሱሳ ኦሳ ስኢ ኤልሲ ኤዝኮ ይኢ ኤ ቶካይል አፋ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","እዛ ግርከ አሲ፤ የልንቴዛይ ስሮፍንቀ ግዝ ቢታ። እዛ፥ ፋ ናአትፕ ቱና አያና ከሶዳይ ጋርክ የሱሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ዝን የሱሳ ማሂ፥ «ናእታይ ቲናቲ ካꬃ ምዦ፤ ናእታይ ካꬃ ኤኪ ካንታይስ ኦሎ ኮሾያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","አስታ ማቂ፥ «ታ ጎዳዮ የይ ቱማ፥ ዝን ሌማተ ካለ የዝ ካንታይ ናእታይፕ ዎꬍዝ ጉፋ ሚነባይ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","የሱሳ ማ እዝኮ፥ «Ꮊ ነ ቃላይ ግሾስ ነ ካራ ቅቶባ፤ ቱና አያና ነ ናአትፕ ከዜዝ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","እዛካ ፋ ካራ Ꮊንጎዳር ቱና አያና እ ናአትፕ ኬዝን አርሳል ዎይኤዛኖ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","የሱሳ ማ ጽሮሳ ካታማፕ ከዚ፥ ስዶናራነ ታጲ ካታምታ ግዝ ቢታር ኣꬊ ጋልላ አባኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","አሳይ ቱለኔ ደዳትዛ አስ የሱሳኮ ክኢ፥ ፋ ኩሸ ኤዛል አፋ ጋዶድ ጋርክ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","የሱሳ ኣዳ የ አꬃ ጋመ አሳይፕ ጋጻ ከሲ፥ ፋ ብራ ኤ ሀያይድ ዳኬዛ። ማ የይፕ ጩቺ ጩቲ ኤ እራንꬃ ቦቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ሳሎ ፉደ ꬎቅ ግ ብኢ፥ ዎሲ፥ «ኤፍታህ» ጌዛ። ብልእꬃይካ «ዶይንቶባ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","አꬃይ ሀያይ ኤልሲ ዶይንቴዛ፥ አጭንቴዝ እራንꬃይካ ብልእንቴዛ፥ አꬃይ ብልእንቲ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","የሱሳ አሳይኮ፥ «Ꮊያ ኦስካ ኦድፓተ» ዬጌዛ። ዝን ኤ ሎእꬂ ሚንꬂ ኦድፓተ ግን፥ አሳይ ኦዳ ገደ ዳልግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","የያ ስኤዝ አስ ኡባይ ሎእꬂ ማላባዝ ግ፥ «ኡባ ባዝ ኤ ሎእꬂ ኦꬅዛ። ሀራ አቶዝን፥ ቱለ ስስዛ፥ ሙመ ኦድስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ጽቃ ዎደፕ ጉየ፥ ጋመ አሳይ የሱሳኮ ሺቄዛ። አሳይስ ሚዝባዝ ꬋብን የሱሳ ፋ ታማርታ ፋኮ ጼጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Ꮊ አሳይ ታር ሀይꬒ ጋላስ ሄሎዳይስ ጋምኢ፥ አብካ ሚዝ ባዝ ደንገካዛይ ግሾስ ታና አሳይ ቃꬊꬂዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ታ አሳ ናየር ካራ ዳካሚ፥ አሳይ Ꮊንግታር ኦገላ ዳቡሪ ፖኮዳ፥ ባጋ አሳይ ሃኮፕ የኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","የሱሳ ታማርታይ ማሂ፥ «Ꮊ ሊዣይድ Ꮊ አሳ ኡባ ሙዞዳይስ ግድዛ ካꬃ ደንጎዳይስ ዳንዳእዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","የሱሳ ኡንትኮ፥ «ይንታር ኣፑን ሶሎ የኔ?» ዬጊ ኦይጬዛ። ኡ ማሂ፥ «ላፑን ሶሎ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","የሱሳ አሳይ ሳአ በቶዳይ ጋርክ ኪቴዛ። ዬዜዛይፕ፥ ላፑን ሶሎ ኤኪ ጾስ ጋላቲ ማቂ የ ሶላ ዱꬅርꬂ፥ አሳይስ ግሾድ ጋርክ ፋ ታማርታይስ እንጌዛ። ኤ ታማርታይ አሳይስ ግሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ኡንትስ ማ ጽቃ ይሸ ሞልታይ የዛ። የሱሳ የ ሞልታይ ግሾስ ጾስ ጋላቲ፥ አሳይስ ግሾድ ጋርክ ፋ ታማርታ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","አሳይ ኡቢታይ ም ምዤዛ። ኤ ታማርታይ አቴዝ ጉፋ ላፑን ሌማተ ኩንꬅ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ካꬃ ሜዝ አሳይ ታይባይ ኦይዲ ሙኩለ ማቆዳ። የይፕ ጉየ፥ የሱሳ አሳ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ኤ ማ ፋ ታማርታይር ኤልꬂ ዎጎሎ ጋንጨ ገሊ ዳልማኑታ ግንትዝ ቢታ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፈርሳወ አስታይ ይኢ የሱሳ ፓጮዳይስ ኮዪ፥ ሳሎፕ ኡ ፋና ማላ ቤዞዳይ ጋርክ የሱሳር ፓላማ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","የሱሳ ሼምቲ፥ «Ꮊ ዎደ አሳይ አብስ ማላ ኮዬ? ታ ይንትስ ቱማ ኦድዛ፤ Ꮊ ዎደ አስስ አባ ማላካ እንግንቴና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ኤ ኡንታን እዘ ኦሊ አሺ ማቂ ዎጎሎ ጋንጨ ገሊ አባይፕ ሰኮ ፕኖ ፒንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ኤ ታማርታይ ካꬃ ኤኪ Ꮊሞ ዶጌዛ፤ ኡንትስ ዎጎላይ ጋንጨ ፐቲ ሶሎፕ ሀራ ካꬃ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","የሱሳ ኡንትኮ፥ «ይንታን ኤሮይታ። ፈርሳውታይ እርሾፐኔ ሄሮዶሳ እርሾፕ ናግንቶይታ» ዬጊ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ኡንቲ ዎል ጋንጨ፥ «ኤ Ꮊያ ግዛይ ኑስ ሶሎ ባዛይ ግሾስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","የሱሳ ኡ ግዛና ኤሪ ኡንትኮ፥ «ይንትስ ሶሎ ባዛይ ግሾስ አብስ ኦድንቴ? Ꮊተካ ይ ኤሮሳ? ዎይ ይ አካኮሳ? ይ ዎዝናይ ዶጬኔ? ");
INSERT INTO mfxe_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ይንትስ ኣፈ የዝን ቦኦሳ? ሀየ የዝን ስኦሳ? ይንትስ ዋይዚ አካክንቶሳ? ");
INSERT INTO mfxe_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ታ እችን ሶሎ እችን ሙኩለ አስስ ፔꬌዝ ዎደ ኣፑን ሌማተ ኩንꬅ ጉፋ ደንꬄኔ?» ዬጌዛ። ኡንትካ፥ «ታጶ ናምኢ ሌማተ ኩንꬅ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«የይ ጋርክ፥ ታ ላፑን ሶሎ ኦይዲ ሙኩለ አስስ ፔꬊን ኣፑን ሌማተ ኩንꬅ ጉፋ ደንꬄኔ?» ዬጌዛ። ኡንቲ፥ «ላፑን ሌማተ ኩንꬅ ደንꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","የዝን፥ «Ꮊተካ ይንትስ ቆፍንቶሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ኡንቲ ቤተሳይዳ ካታማ Ꮊንጌዛ። ጽቃ አስታይ ቶአ አꬃ የሱሳኮ ክኢ የ አꬃ ቦቾድ ጋርክ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","የሱሳ ቶአ አꬃይ ኩሻ አይኪ ካታማፕ ጋጻ ከሴዛ። ኤ ኣፋተ ጩቲ ፋ ኩሻ ኤዛል አፋ ጋዲ፥ «ኔስ አኮ በንትኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","አꬃይ ꬎቅ ግ ብኢ፥ «ታስ አሳይ በንትዛ፥ ዝን አሳይ የꬍታር ምꬂ ኣዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","የይፕ ጉየ፥ የሱሳ ማሂ፥ አꬃይ ኣፋይል ፋ ኩሸ ጋዴዛ። አꬃይ ሎእꬂ በኤዛ፥ ኤ ኣፋይ ፓጼዛ፥ ኡባ ባዝ ምልጽ ኡዲ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","የሱሳ አꬃይኮ፥ «ነ ካራ ቅቶባ፥ ካታማ Ꮊንግፐ» ዬጊ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","የሱሳ ፋ ታማርታይር ቅሳረ ፍልጶሳ ካለ የዝ ሄራ Ꮊንጌዛ። ኡ Ꮊማዳር ኦገል አፋ የሱሳ፥ «ታና አሳይ ኦና ግነሻ?» ዬጊ ፋ ታማርታ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ኤ ታማርታይ፥ «ፐቲ ፐቲ አሳይ ነና፥ ‹ጻማቅዛ ዋንሳ› ግዛ፤ Ꮊንክታይ፥ ‹ኤላሳ ግዛ› ማ Ꮊንክታይ፥ ‹ናብታይፕ ፐታ› ግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","የሱሳ ኡንትኮ፥ «የዝን ይ ታና ኦና ጌ?» ዬጊ ኦይጬዛ። ጵጽሮሳ፥ «ነ ክርስቶሳ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","የሱሳ፥ «ታባጋ ኦስካ ኦዳማይ ጋርክ ናግንቶይታ» ዬጊ ኡንታን አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","የሱሳ ፋ ታማርታይኮ፥ «አስ ናአይ፥ ጋመ መቶ ኤኮዳይስ ቤዝዛ፤ ጭምታይ፥ ቄሰ ሀላቅታይኔ ህገ አስታማርታይ ኤዛ እጾዳይስ ቤዝዛ። ኡንቲ ኤዛ ዎꬎዳይስኔ ሀይꬒ ጋላሳፕ ጉየ፥ ኤ Ꮊይቆፕ ደንዶዳይስ ቤዝዛ» ዬጊ ኡንታን ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ኤ የያ ኡንትስ ጌሺ ኦዴዛ። ጵጽሮሳ ኣዳ ፐቲ ባጋ ኣꬂ ካጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ዝን የሱሳ ጉየ ማቂ፥ ፋ ታማርታ ብኢ፥ ጵጽሮሳር ካጭንቲ፥ «Ꮊ ጻላሃዮ፥ ታፕ ሃኮባ። ነ አሲ ዶስዝባዝ ቆፕዛፕ አትን ጾስ ዶስዝባዝ ቆፖያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ማካ የሱሳ ጋመ አስታይራ ፋ ታማርታ ፋኮ ጼጊ፥ «ታና ካሎዳይስ ኮይዝ ኦንካ ፋና ካዶ፤ ፋ ማዝቃላና ቶኪ ታና ካሎ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ፋ ሸምፖ አሾዳይስ ኮይዝ አꬃይ ꬋብስዛ። ዝን ታ ግሾኔ ዎንግለ ግሾስ ፋ ሸምፖ ꬋብስዛ አꬃይ አሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","አሲ ሳአል የዝ ሻሎ ኡባ ደንጊ ፋ ሸምፖ ꬋብስኮ ኤዛ አብ አዶዴ? ");
INSERT INTO mfxe_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","አሲ ፋ ሸምፖ ዎዞዳይስ አብ እንጎዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ጾስ አማኖዋ Ꮊ ኢታ የለትꬃይድ፥ አሲ ታላኔ ታ ቃላይድ ዬላትኮ፥ አስ ናአይ፥ ፋ አዳይ ቦንቻይር ጌሽ ኪታንችታይር ይእታር ኤ ባጋር ዬላቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","የሱሳ ኡንትኮ፥ «ታ ይንትስ ቱሮ ኦድዛ፤ ጾስ ካተትꬃይ ዎልቃር ይእዛና በኤካዛር Ꮊይቃም ፐቲ ፐቲ አሳይ Ꮊይዳ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","የሱሳ ኡሱፑን ጋላሳፕ ጉየ፥ ፓር ጵጽሮሳራ፥ ያይቆባራ ዋንሳራ ኣዳ ኤኪ ዳማ አምባል አፋ ከሲ ኡ ቲናይድ ላምንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ኤ አፍላይካ ፎጭዛ፤ ሳአ አፍላ ሜጭዛ ኦንካ ጌሾዳይስ ዳንዳኦዛይ ጋርክ ሙልጽ ግ ቦጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","የ ዎደ ኤላሳራ ሙሰራ የሱሳር ዎላ ናሾዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጵጽሮሳ የሱሳኮ፥ «አስታማራዮ፥ ኑኒ Ꮊይዳ የዜዛኮ ኑስ ሎኦ፤ ኑ ሀይꬒ ሻቃራ ፐታ ኔስ፥ ፐታ ሙሰስ፥ ማ ፐታ ኤላሳስ አጮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ꮊንክታይ ኢታ ያሽቴዝ ግሾ ጵጽሮሳ አብ ግዛኮካ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","የይፕ ጉየ፥ ሻራ ይኢ ኡንታን ጎልን ሻራይ ጋንጨፕ፥ «Ꮊይ ታ ቃꬍዛ፥ ታ ናአያ፥ ኤ ግዝ ባዝ ስኦይታ» ግዝ ቃላ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ኤልሲ ኡ ዩዪ በአዳር የሱሳፕ አትን ሀራ ኦናካ ፋ ካለ ኡ በኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ኡንቲ አምባላፕ ዎꬎዳር፥ የሱሳ ኡንትኮ፥ «አስ ናአይ፥ Ꮊይቆፕ ደንዶድ ጋꬆ፥ ይ በኤዝ ባዝ ኦስካ ኦድፓተ» ዬጊ አዛዘዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ኤ አዛዜዛና ኡ፥ «ኤሮ» ዬጊ፥ «Ꮊ Ꮊይቆፕ ደንዶ ጉሳይ አብ ጉሶ» ዬጊ፥ ፋ ጋንጨር ዎላ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ኡ ማቂ፥ «ህገ አስታማርታይ፥ ‹ኤላሳ ቲናቲ የኦዳይስ ቤዝዛ› አብስ ጌ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","የሱሳ ማሂ «ኤላሳ ቲናቲ ይኢ፥ ኡባ ባዝ ሎእꬅዛ፤ የዝን፥ አብስ ጌሻ ማጻፋይ፥ ‹አስ ናአይ ዴጾ መቶ ኤኮዳኔ ለቅንቶዳ› ዬጊ ጻፌዛይ ዋፋ? ");
INSERT INTO mfxe_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ዝን ታ ይንትስ ኦድዛ፤ ኤላሳ ካሰ የኤዛ፤ ማ ኤ ባጋ ጌሻ ማጻፋይድ ጻፍንቴዛይ ጋርክ፥ አሳይ ኤዛል አፋ ፋ ኮዬዝ ባዝ ኡባ ኦꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","የሱሳራኔ ሀይꬒ ኤ ታማርታይ አቴዝታይኮ ማቂ የኦዳር ጋመ አስ ኡ ላንቃይድ በቴዝታኔ ህገ አስታማርታይ ኡንታር ፓላምዛና በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","የ ጋመ አሳይ የሱሳ በኤዝ ዎደ ዳጋማር ማላባዝ ግ፥ ኤልሲ ኤዝኮ ላሲ ይኢ፥ ኤዛ ሳሮꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","የሱሳ ህገ አስታማርታይኮ፥ «ኡንታር ፓላምዛይ አብሶ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","የ ዎይታይ ጋንጨፕ ፐቲ አꬃይ ማቂ፥ «አስታማራዮ፥ ታ ናአይል አፋ ፖጎዳ ካይዝ ቱና አያና የዛ ግሾስ ኤዛ ታ ኔኮ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ያ አያናይ ደንዴዝ ዎደ፥ ኤዛ ሾጪ ኦሊ፤ ዶናይር ጋፑንቶ ክኢ፤ አች ጮንቺ፤ ጋላ ዛብሲ ጋምን ከሶዳይ ጋርክ ነ ታማርታይስ ኦድን፥ ኡ ከሶዳይስ ዳንዳኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","የሱሳ ማሂ ኡንትኮ፥ «አማኖዋ Ꮊ ላይꬃ አስታዮ! ታኒ ይንታር አይደ ሄሎዳይስ የዞዴ? ማ ይንታን አይደ ሄሎዳይስ ዳንዳኦዴ? ናአ ታኮ Ꮊና ኤኪ የኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ኡንቲ ናአ ኤዝኮ ከኤዛ፤ የ ቱና አያናይ የሱሳ በኤዛን ጋርክ ናአ ኩኩርሲ፤ ፖክሲ፥ ዶናር ጋፑንቶ ክእꬅ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","የሱሳ የ ናአይ አዳይኮ፥ «Ꮊ ነ ናአ አይኬዛይፕ ኣፑን ላይꬅ ማቆደ?» ዬጊ ኦይጬዛ። ናአይ አዳይ፥ «ኤ ዱደዝን አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ኤዛ ዎꬎዳይስ ጋመ ዎደ ታማ ጋንጨኔ ሃꬂ ጋንጨ ኦልዛ፥ ዝን ነ ዳንዳእኮ፥ ኑስ ቃꬎየ፥ ኑና ማዶየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","የሱሳ፥ « ‹ነ ዳንዳእኮ ግኔ?› አማንዛ ኦስካ ኡባ ባዝ ዳንዳእንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ኤልሲ ናአይ አዳይ ፋ ቃላ ꬎቅ ኡዲ፥ «ታ አማንዛ፥ ዝን ጉጂ አማኖዳይ ጋርክ ታና ማዶየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","የሱሳ አሳይ ጋንጊ ጋንጊ Ꮊንግዛና ብኢ፥ ቱና አያና፥ «Ꮊ ቱለኔ ሙመ አያናዮ፥ Ꮊ ናአይፕ ከዞባ ነና ታ አዛዝዛ፤ ማ ናምእንꬆ ማቂ ኤዛል ገልፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","የ ቱና አያናይ ኡኪ፥ ናአ ኢታ ኩኩርሲ፥ ኤዛፕ ከዜዝ። ናአይ Ꮊይቄዛ ኣዝን፥ ጋመ አሳይ፥ «ናአይ Ꮊይቄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ዝን የሱሳ ናአይ ኩሻ አይኪ ደንꬅን፥ ናአይ ደንዲ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","የሱሳ ካራ ገሌዛይፕ ጉየ ኤ ታማርታይ፥ «ኑኒ የ ቱና አያና ከሶዳይስ አብስ ዳንዳኤካሳ?» ዬጊ የሱሳ ኣዳ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","የሱሳ ማሂ፥ «የይ ጋርከዛይ ዎሳራኔ ጾማራፕ አትን ሀራባዛር ከዞዳይስ ዳንዳኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ኡንቲ የ በሳይፕ ደንዲ፥ ጋልላር ኣꬊ Ꮊንጌዛ፤ የሱሳ ፋ የዛበሳ ኦንካ ኤሮድ ጋርክ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ኤ ፋ ታማርታይኮ፥ «አስ ናአ፥ አሲ አስታይ ኩሸ ኣꬂ እማዳኔ ዎꬎዳ፤ ኤ ሀይꬒ ጋላሳፕ ጉየ፥ Ꮊይቆፕ ደንዶዳ» ዬጊ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ዝን ኡንትስ ኤ ጌዛይ ገለካያ፤ ማ ኤዛ ኦይጮዳይስካ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ኡንቲ ቅፍርናሆመ ካታማ Ꮊንጊ ካራ ገሌዛይፕ ጉየ የሱሳ ኡንትኮ፥ «ኦገል ይ አብስ ፓላምንቴ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ዝን ኡ፥ «ኑ ጋንጨ ኡባፕ ኣꬎዳይ ኦኖ?» ዬጊ ፓላሜዝ ግሾስ ስኤ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","የሱሳ በቲ፥ ታጶ ናምኢ ታማርታ ጼጊ፥ «ኦንካ ቲና ኣꬎዳይስ ኮይኮ፥ ኡባፕ ጉየ ኣꬊ፥ ኡባይስ አይለ ማቆዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ፐቲ ጽቃ ናአ ኤኪ፥ ኡ ጋንጨ ኤሴዛ፤ የ ጽቃ ናአ እድንጊ ኡንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ꮊይ ጋርክ ጽቃ ናእታይፕ ፐታ ታ ሱንꬃይር ሞክዛ ኦንካ ታና ሞክዛ፤ ማ ታና ሞክዛ ኦንካ ታና ኪቴዛናካ ሞክዛፕ አትን ታ ኣዳ ሞኮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዋንሳ፥ «አስታማራዮ፥ ፐቲ አሲ ነ ሱንꬃር ቱና አያንታ ከሶዳር ኑ ብኢ፥ ኑ ባጋ ማቀካ ግሾስ ኤዛ ካዬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ዝን የሱሳ፥ «ኦንካ ታ ሱንꬃር ጾሲ ኦꬅዝ ማላታ ባዝ ኦꬂ፥ ኤልሲ ታል አፋ ኢታ ባዝ ኦድንቶዳይስ ዳንዳእዛይ ባ ግሾስ ካይፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ኑባዝ እጾዋ ኡቢታይ ኑ ባጋ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ታ ይንትስ ቱሮ ኦድዛ፤ ይ ታስታ ማቄዝ ግሾስ ኦንካ ይንትስ ታ ሱንꬃር ሀለ ሃꬂ ኡዦዳይስ እንግኮካ፥ ፋ ጋተ ꬋባሚ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«ታና አማንዛ Ꮊ ጽቅታይፕ ፐታ ባልꬆዳይፕ ኦንካ፥ ዳማ ዎጻ ፋ ቆꬌል አጪ፥ አባ ጋንጨ ዎꬍዛኮ ኤስ ሎኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ነ ኩሻይ ነና ባልꬅኮ፥ ጋቺ ኦሎባ። ኔኒ ናምኢ ኩሸር ቶኦዋ ጋናመ ታማ ጋንጨ ዎꬍዛይፕ፥ ዱጻ ኩሸር መꬍና ደኦ ገሎ ኔስ ሎኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ጋናመ ጉጽነካ Ꮊይቆዋ፥ ታማይካ ቶኦዋ አቆ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ነ ቶካይ ነና ባልꬅኮ፥ ጋቺ ኦሎባ። ነ ናምኢ ቶከር ጋናመ ታማ ጋንጨ ዎꬍዛይፕ፥ ዎቦ ማቂ ደኦ ገልዛኮ ኔስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ጋናመ ጉጽነ Ꮊይቆዋ፥ ታማይካ ቶኦዋ አቆ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ነ ኣፋይ ነና ባልꬅኮ፥ ዎጪ ከሲ ኦሎባ። ነ ናምኢ ኣፈር ጋናመ ታማ ጋንጨ ዎꬍዛይፕ፥ ፐቲ ኣፈር ጾስ ካተትꬂ ገልዛኮ ኔስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ጋናመ ጉጽናይ Ꮊይቆዋ፥ ታማይካ ቶኦዋ አቆ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ያርሾ ማጽነር ኦꬅንትዛይ ጋርክ አሲ ኡባይ ታማር ሀርቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ማጽነ ሎኦ፥ ዝን ማልአም እጽኮ፥ ማቂ ዋይዚ ማልእꬆደ? ይንታር ማጽነ የዞ። ዬዚ ፐታይ ፐታይር ሳሮ የዞይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","የሱሳ የይፕ ደንዲ፥ ይሁዳ ቢታ Ꮊንጊ ዮርዳኖሳ ቦርካ ፒንጌዛ። ጋመ አሳይ ማቂ ኤዝኮ ሺቅን፥ ካሴሳይ ጋርክ ያ አሳ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ፈርሳወ አሳፕ ፋጮዳይስ ኮዪ የሱሳ፥ «ፐቲ አስ ፋ ማቻቶ አንጆድ ጋርክ ሙሰ ህጋይ ኪትኔ?» ዬጊ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ኤ ማሂ፥ «ሙሰ ይንታን ካሰ ዋጊ ኪቴኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ኡንቲ፥ «ሙሰ፥ ‹ፐቲ አሲ ፋ ማቻትስ አንጆ ዋርቃተ እንጊ ዳኮ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","የሱሳ ማሂ፥ ኡንታን «ይ ዎዝናይ ሚንꬂ ማቄዝ ግሾስ ሙሰ Ꮊ አዛዛ ይንትስ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ዝን ጾሳይ ቲና መꬍታር ꬊራꬃራ ማቻር ኡዲ፥ መꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","የይ ግሾስ፥ ፐቲ አሲ ፋ አደኔ ፋ እንዶ አሺ፥ ፋ ማቻትር ዎላ ማድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ኡ ናምእታይ ፐቲ አሾ ማቅዛ፤ Ꮊይፕ፥ ኡ ፐቲ አሾ ማቆዳይፕ አትን ናምኤ ማቆያ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","የይ ግሾስ፥ ጾሳይ ዎላል ዋጼዛና አሲ ሻክፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ኡ ካራ ማቄዝ ዎደ ኤ ታማርታይ Ꮊ ኦዳይ ባጋ የሱሳ ናምእንꬆ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","የሱሳ ኡንትኮ፥ «ፋ ማቻቶ አንጂ ሀራ ኤክዝ ኦንካ ላምዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ማ ማቻታካ ፋ አዝናይፕ ከዚ ሀራ ኣዝን ገልኮ ላምዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","የሱሳ ዱደ ናእታ ቦቾድ ጋርክ፥ ፐቲ ፐቲ አሳይ ናእታ ኤዝኮ ክእዛ፥ ዝን ኤ ታማርታይ የ አስታ ካጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","የሱሳ የያ ብኢ፥ ፋ ታማርታ ጋይሌዛ፤ ኡንትኮ፥ «ዱደ ናእታይ ታኮ ይእዛና ካይፓተ፤ ጾስ ካተትꬃይ Ꮊይትታይ ጋርከዝታይሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ታ ይንትስ ቱሮ ኦድዛ፤ ጾስ ካተትꬃ ዱደ ናአ ጋርክ ኤኮዋ አስ ኦንካ የ ካተትꬃ ኡባራካ ገላሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","የይፕ ጉየ ዱደ ናእታ እድንጊ፥ ፋ ኩሸ ኡንታል አፋ ጋዲ አንጄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","የሱሳ Ꮊንጎዳይስ ከዞዳራ ፐቲ አꬃይ ላሲ ይኢ፥ ኤ ቲናይድ ቡንቂትድነ፥ «ኬሃ አስታማራዮ፥ መꬍናስ ደኦ ላቶዳይስ ታ አብ ኦꬆ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","የሱሳ፥ «አብስ ታና ኬሃዮ ግ ጼጌ? ጾስ ኣዳፕ አትን ሀራ ኬሃ ኦንካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ጾሳ ኪታይ፥ ዎꬍፐ፤ ላምፐ፤ ካስትፐ፤ ዎርዶ ማርካትፐ፤ ዶሽፐ፤ ነ አደኔ ነ እንዶ ቦንቾባ ዬግዛና ነ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","አꬃይ፥ «አስታማራዮ፥ ታ Ꮊይትታ ኡባ ናአትꬃፕ አይኪ Ꮊኖ ሄሎዳይስ ናግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","የሱሳ አꬃ ዳኪ ብኢ ቃꬌዛ፤ «ኔስ ፐትባዚ ፓጭዛ፤ Ꮊንጊ ኔስ የዛ ባዝ ኡባ ባይዚ፥ የ ሚሻ ማንቅታይስ እንጎባ፤ ነ ሳሎ ዱርቶዳ። ዬዚ ማቂ ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ዝን አꬃይ የያ ስኢ፥ ኤ ቱቄዝ ዱረ ማቄዝ ግሾስ ፋ ስና ቱኬዛ፥ ኡፋይተካዛር አሺ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","የሱሳ ፋ ታማርታ ዩዪ ብኢ፥ «ዱረ አስ ጾሳ ካተትꬂ ገሎዳይ ዋይዚ መቶደሻ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ኤ ታማርታይ ኤ ትምርታ ስኢ ማላባዝ ጌዛ። ዝን የሱሳ ማካ ኡንትኮ፥ «ናእቶ፥ ጾሳ ካተትꬂ ገሎዳይ ዋይዚ መቶደሻ! ");
INSERT INTO mfxe_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ዱረ አስ ጾስ ካተትꬂ ገሎዳይፕ፥ ግማለ ናርፐ ሉኮር ኣꬎዳይ ሻዉክዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ኤ ታማርታይ Ꮊይ ማላባዝ ግ፥ «የዝን፥ ኦኒ አቶዴ?» ዬጊ፥ ፐታይ ፐታ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","የሱሳ ኡንታን ዳኪ ብኢ፥ «Ꮊይ ጾስስ ዳንዳእንትዛፕ አትን አስስ ዳንዳእንቶያ፤ ጾስስ ኡባ ባዝ ዳንዳእንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጵጽሮሳ የሱሳኮ፥ «ዬዛኮ፤ ኑኒ ኑባዝ ኡባ አሺ፥ ነና ካሌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","የሱሳ «ታ ይንትስ ቱሮ ኦድዛ፤ ታ ግሾኔ ዎንግለ ግሾስ ፋ ካራ ዎይ እሽታ ዎይ ምሽታ ዎይ አደ ዎይ እንዶ ዎይ ማቾ ዎይ ናእታ ዎይ ጋደ አሼዛይ ኦንካ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ꮊት Ꮊ ዎዳይድ ባይእꬃር ፋ ካራ፥ እሽታ፥ ምሽታ፥ እንድታ፥ ናእታ፥ ጋደ፥ ጼት ኩሸ ኤኮዳ። ቲናስ የኦድ አላመ መꬍና ደኦ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ዝን ጋምታይ ቲናቴዝታይ ጉይቶዳ፥ ማካ ጋምታይ ጉይቴዝታይ ቲናቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","የሱሳራኔ ኤ ታማርታይር የሩሳላመ Ꮊማዳር፥ የሱሳ ፋ ታማርታይፕ ቲን ቲን የꬍዛ። ኡ የያ ማላባዝ ጌዛ። ኤዛ ካልዝታይካ ያሽቴዛ። ናምእንꬆ፥ ታጶ ናምኢ ታማርታ ጋጻ ከሲ፥ ፋና ሄሎድ ባዛ ዱማ ኡንትስ Ꮊይ ጋርክ ዬጊ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«ዬዛኮ፥ ኑኒ የሩሳላመ Ꮊት ዎላ ኬሳል የዛ። የይዳ አስ ናአ፥ ቄሰ ሀላቅታይስኔ ህገ አስታማርታይስ ኣꬂ እንግንቶዳ። ኡ ኤዛል አፋ Ꮊይቆ ፕርዳ ፕርዶዳ፤ ማ አይሁደ ባ ዎያስ ኤዛ ኣꬂ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","የ አይሁደ ባ ዎያይ ኤዛ ቶቾዳ፥ ኤዛል አፋ ጩቶዳ፥ ልሶር ጋራፎዳኔ ዎꬎዳ። ኤ ሀይꬒ ጋላሳፕ ጉየ፥ Ꮊይቆፕ ደንዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ዛብዶሳ ናእታይ ያይቆባራኔ ዋንሳር የሱሳኮ ይኢ፥ «አስታማራዮ፥ ኑኒ ነና ዎስዛ ኡባ ባዝ ኑስ ኦꬆዳይ ጋርክ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ኤ ኡንትኮ፥ «ታኒ ይንትስ አብ ኦꬆ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ኡንቲ፥ «ኔኒ ነ ቦንቾ ካተትꬃ በትዛ ጋላስ ኑፕ ፐታ ኡሻች ባጋር ማ ፐታ ሀድርስ ባጋር በትꬆየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ዝን የሱሳ ኡንትኮ፥ «ይ አብ ዎስዛኮ ኤሮያ፥ ታ ኡዦዳይስ የዝ ጹአ ኡዦዳይስ ዳንዳእኔ? ማ ታ ጻማቅንቶዳይስ የዝ ጽንቃታ ጻማቅንቶዳይስ ዳንዳእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ኡ ማሂ፥ «ኤ ኑ ዳንዳእዛ» ዬጌዛ። የሱሳ ማካ፥ «ቱማ ታ ኡዦዳይስ የዝ ጹአ ይ ኡዦዳ፥ ታ ጻማቅንቶዳይስ የዝ ጽንቃታ ይ ጻማቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ዝን ታፕ ኡሻች ባጋራኔ ሀድርስ ባጋር በቶድታ ዶሮ ታ ዎልቃ ባያ፥ ዝን የ አቃይ ጾሳይ እማዳይስ ጊግሲ ጋዴዝታይሲ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ꮊንኮ ታጲ ታማርታይ የያ ስኢ ያይቆባላኔ ዋንሳል ጋይልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","የሱሳ ኡንታን ኡባ ፋኮ ጼጊ፥ «አይሁደ ባ አስታይስ ሀላቅታይ ጋደ አቅስዝታ ግንትንቲ ጼግንትዝታይ ሞድዝታይስ ፋ አስታይል አፋ ማዉተ የዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ዝን ይ ጋንጨ የይ ጋርክ ባያ፤ ይንቲ ይ ጋንጨ ባይራꬎዳይስ ኮይዝ ኦንካ ይንትስ አይለ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ማ ይ ጋንጨ ኡባፕ ꬎቃ ማቆዳይስ ኮይዝ ኦንካ ይ ኡባይስ አይለ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ሀራ አቶዝን፥ አስ ናአይካ፥ አስስ ኦꬆዳይስኔ ጋምታ ዎዞዳይስ ፋ ሸምፖ ኣꬂ እማዳይስ የኤዛፕ አትን አሲ ኤዝስ ኦꬆድ ጋርክ የኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ኡንቲ ኢያርኮ ካታማ Ꮊንጌዛ። የሱሳ ፋ ታማርታይራኔ ጋመ አስታይር ኢያርኮፕ ከሳዳር፥ ጽሞሳ ናአይ፥ ቶአይ፥ ባርጽሞሳ ግንትንትዛይ፥ ኦገ ጋጻ በቲ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ባርጽሞሳ፥ ኤ የ ኦጋይር ኣꬍዛይ ናዝረተ የሱሳ ማቄዛና ስኢ ፋ ቃላ ꬎቅ ኡዲ፥ «ዳዉተ ናአ የሱሳ፥ ታና ማሮየ!» ዬግታር ኡፎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ጋመ አሳይ ኤዛ፥ «ሀይዞባ!» ዬጊ ቆዴዛ። ዝን፥ ኤ ፋ ቃላ ቲናሳይፕ ኣꬂ፥ «ዳዉተ ናአዮ፥ ታና ሀያና ማሮየ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","የሱሳ ኤቂ፥ «ኤዛ Ꮊና ጼጎይታ» ዬጌዛ። ኡንቲ ቶአይኮ፥ «አኮ ባያ፥ ደንዲ ኤቆባ፥ ነና ጼግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ቶአይ ፋ አፍላ ꬎጊ ኦሊ፥ ጉፒ ደንዲ ኤቂ፥ የሱሳኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","የሱሳካ፥ «ታ ኔስ አብ ኡዶድ ጋርክ ነ ኮዬ?» ዬጌዛ። ቶአይ፥ «አስታማራዮ፥ ታ በአዳይስ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","የሱሳ ኤዛ፥ «ቅቶባ፥ ነ አማናይ ነና ፓꬄዛ» ዬጌዛ። እዝር ኤ ኣፋይ ብእን፥ ኦገር የሱሳ ላሳ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ኡ የሩሳላመ ኡክታር፥ ደብረ ዛይተ ደረ ላንቀ የዝ ቤተፋገኔ ብታና ካታማ ሄሌዛ። የሱሳ ፋ ታማርታይፕ ናምእታ ቲና ኪቲ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«ይንታፕ ቲና የዝ ሄራ Ꮊንጎይታ፤ እዘ ሄሌዛን ጋርክ ኦንካ ቶጊ በኤካ አቻ የዝ ሀረ ናአ ይ ደማዳ፥ ኤዛ ብሊ፥ Ꮊና ኤኪ የኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ኦንካ ይንታን፥ ‹Ꮊያ አብሶ ዋይዘ?› ዬጊ ኦይጭኮ፥ ‹ጎዳይ ኤዛ ኮይዛ፥ ዬጎይታ ኤ ኤልሲ Ꮊና ዳኮዳ› ዬጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ኡ Ꮊንጊ፥ ሀረ ናአይካ ባለ ኦገ ካለ አጭንቲ የዛና ደንጊ ብሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","የ አቃይድ ኤቄዝ ፐቲ ፐቲ አሳይ ኡንትኮ፥ «ሀረ ናአ ዋይሳዳይስ ብሌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ኤ ታማርታይ ኤ ኡንታን አዛዜዛና ኦድን፥ አሳይ ዳኪ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ኡ ሀረ ናአ የሱሳኮ ክኢ፥ ፋ አፍልታ ኤ ዞካይል ሂጽን የሱሳ ያ ሀረ ናአ ቶጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ጋመ አሳይ ፋ አፍላ ኦገል ሂጼዛ፤ ማ አቴዝ አሳይ ምꬅ ሀየ ሻቂ፥ ኦገል አፋ ሂጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","የሱሳፕ ቲናር የዝታኔ ኤዛ ጉየር ካልዝ አስታይ ፋ ቃላ ꬎቅ ኡዲ፥ «ሆሳና! ጎዳይ ሱንꬃር ይእዛይ አንጅንቴዛያ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ይእዛና፥ ኑ ኣዳ ዳዉተ ካተትꬃት እዛ አንጅንቴዛኖ። ሆሳና! ኡባፕ ኣꬎ ሳሎ» ዬግታር ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","የሱሳ የሩሳላመ Ꮊንጊ፥ ጾሳ ኬꬃ ገሌዛ። ማ ኡባ ባዝ ዩዪ በኤዛይፕ ጉየ፥ ሳአይ ቃሜዛይስ ታጶ ናምኢ ታማርታይር ብታና ካታማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ዎንትꬃ ጋላስ ኡንቲ ብታናፕ ከዚ Ꮊማዳር፥ የሱሳ ናይንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ሃኮር ፐቲ ባላሰ ምꬃቶ ሀየ ቶኪ የዛኖ ብኢ፥ እዝል አፋ ኣፈ በንቶደሻ ግ፥ በአዳይስ እዝኮ Ꮊንጌዛ፥ ዝን እዝኮ ኤ Ꮊንጎዳር ሀየ ኣዳፕ አትን ፐቲ ኣፈካ ደንገካያ፤ አብስ ጊኮ፥ ባላሰ ካእዝ ዎደ ሄለካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","የሱሳ የ ባላሳቶ፥ «ይኬ፥ ኔፕ መꬍናስ አሲ ኣፈ ሚፐ» ዬጌዛ። ኤ ታማርታይ ኤ ግዛ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ኡ የሩሳላመ Ꮊንጌዛ፤ የሱሳ ጾሳ ኬꬅ ገሊ፥ ኤዛይድ ባይዝዝታኔ ዎንግዝታ ባለ ባይእꬂ አይኬዛ፤ ማ ሚሸ ላምዝታይ ጻርጴዛናኔ ሆለ ባይዝዝታይ ኦይዳ ሽሪ ኦሌዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","አሲ አባባዝካ ቶኪ፥ ጾሳ ኬꬅ ጋንጨር ኣꬋማይ ጋርክ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","የሱሳ አስታ Ꮊይ ጋርክ ዬጊ ታማርሴዛ፦ «ጌሻ ማጻፋይድ፥ ‹ታ ካራይ አስ ኡባይ ጾሳ ዎስዛ ካራ ማቃዳ› ዬግንቲ ጻፍንተካሳ? ዝን ይ ኤዛ ፓንታይ ቆስንትዛ ኮምኦ ማሄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ቄሰ ሀላቅታይኔ ህገ አስታማርታይ የያ ስኢ፥ ኤዛ ዎꬎዳይስ ኦገ ኮሽ አይኬዛ። ዝን ዎያ ኡባይ ኤ ትምርታ ማላባዝ ግዝ ግሾስ ኤዝስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ሳአ ለምእለምኦዳር የሱሳራኔ ኤ ታማርታይ ካታማፕ ጋጻ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ኡንቲ ዎንትꬃ ጋላስ የ ኦጋይር ኣꬊታር፥ የ ባላሳታ ጻጶር መሌዛኖ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጵጽሮሳስ ኤልቂ ግን፥ «አስታማራዮ፥ ይናሸ፥ ነ ባዴዝ ባላሳት መሌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","የሱሳ ማሂ፥ «ጾሳ አማኖይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ታ ይንትስ ቱሮ ኦድዛ፤ ኦንካ ፋ ዎዝናይድ ስካዛር ጌዝባዚ ሀኖዳና ፋ ዎዝናር አማኒ፥ Ꮊ አምባ፥ ‹ሾድንቲ አባ ጋንጨ ዎꬎባ› ዬግኮ ኤዝስ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","የይ ግሾስ፥ ታ ይንትስ ኦድዛ፤ ጾሳ ይ ዎስዛባዝኔ ኦይጭዝ ባዝ አብ ማቅኮ ኤኬዛይ ጋርክ አማኖይታ፥ ይ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ጾስ ዎሶዳይስ ይ ኤቆዳር ሳሎ የዝ ይ አዳይ ይ ናጋራ አቶ ጎዳይ ጋርክ፥ ኦንካ ይንታን ናቄዝ ባዝ ፐታካ የዝኮ፥ ኤዝስ አቶ ጎይታ።  ");
INSERT INTO mfxe_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ዝን አስ ናጋራ ይ አቶ ጋም እጽኮ፥ ሳሎ የዝ ይ አዳይካ ይ ናጋራ ይንትስ አቶ ጋሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ኡ ማቅካ የሩሳላመ ቅቴዛ። የሱሳ ጾሳ ኬꬃ የꬎዳር፥ ቄሰ ሀላቅታይ፥ ህገ አስታማርታይኔ ጭምታይ ኤዝኮ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«ነ Ꮊይትታ ኦꬆዳይስ ኔስ አባ ማዉተ የኔ? ዎይ ኔስ Ꮊ ማዉታ እንጌዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","የሱሳካ ማሂ ኡንትኮ፥ «ታ ይንታን ፐትባዝ ኦይጮዳ፥ ታስ ኦዶይታ። ታ ማ Ꮊያ አባ ማዉተር ኦꬅዛኮ፥ ይንትስ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ዋንሳ ጽንቃታይ ጾሳፐኔ አሳፔ? ታስ ኦዶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ኡ ዎል ጋንጨ ፓላማ አይኪ፥ «ኑ፥ ‹ጾሳፕ› ጊኮ፥ ኤ ኑኮ፥ ‹የዝን፥ ዋንሳ ኦዴዛና አብስ አማነካሳ?› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹አሳፔ ጊኮ› ኡባ አስ ዋንሳ ናበ ማቄዛ ኤርዛ።» የይ ግሾስ ዎያይስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","የይ ግሾስ፥ ኡ የሱሳኮ፥ «ኑ ኤሮያ» ዬጊ ማሄዛ፤ የሱሳካ፥ «ታንካ Ꮊያ አባ ማዉተር ኦꬅዛኮ፥ ይንትስ ኦዳሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","የሱሳ ኡንትስ ኣዝሶር ዬጊ ኦዳ አይኬዛ፤ «ፐቲ አꬃይ ዎይነ ምꬂ ቱኪ፥ ዩሻ ጋሴዛ። ማ ዎይነ ቡልዝ ኦላካ ቦኬዛ። ናጎዳይስ አዱስ ሻኮ ሻክሴዛ። የይፕ ጉየ፥ ማታየ Ꮊንትዝ አሳይስ እንጊ፥ ሀራ ቢታ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ዎይነ ኣፈ ማጽዛ ዎደ ሄልን፥ ፋና ሄልዛና ኤኪ የኦድ ጋርክ፥ ፐቲ ፋ አይላ ማታየ ኤኬዝታይኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ማታየ ኤኬዝታይ ኤ አይላ አይኪ Ꮊꬊ፥ ካሎ ኩሸ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ናምአንꬆ ሀራ አይለ ኡንትኮ ኪትን፥ ኡንቲ የ አይላ ሹቻር ቃዉጺ ዬላꬂ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ዎይነ አታክልተ ጎዳይ ማካ ሀራ አይለ ኪቴዛ። ያ አይላ ዎꬌዛ፥ ማ ሀራ ጋምታ ዳክን የይ ጋርክ፥ ፐታ ፐታ Ꮊꬊ፥ ባግታ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«ዎይነ አታክልተ ጎዳይስ ኪቶዳይስ ኡባፕ ዉርስꬃል ኤ ሎእꬂ ቃꬍዛ ናአይ ኣዳ አቴዛ። ኤ፥ ‹ኡ ታ ናአ ቦንቼካ አሻሚ› ዬጊ፥ ፋ ናአ ኡንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«ዝን ማታየ ኤኬዝታይ ፋ ጋንጨር፥ ‹ላቶዳይ Ꮊያ፤ የꬎይታ ኤዛ ዎላ ዎꬎዳ፤ ኤ ጋዳይ ኑስ ማቆዳ!› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ናአ አይኪ ዎꬊ፥ ኤ አሃ ዎይነ አታክልተ ጋንጨፕ ጋጻ ከሲ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«ይኬ፥ ዎይነ አታክልተ ጎዳይ ዋይሳዴ? ይኢ የ ማታየ ኤኬዝታ ዎꬊ፥ ዎይና ኦꬅዛ ሀራ አሳይስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","« ‹ግምቢዝታይ ቦሪ እጼዝ ሹቻይ ኬꬅ ሙመር ቶክዛ ክርክሮ ጋርክ፤ ኡባፕ ኣꬊዝ ሹች ማቄዛ። Ꮊይ ጎዳይ ኦꬄዝ ባዝ፤ ማ ኑ ኣፋይስካ ማላ ባዝ› ዬግዛና ጌሻ ማጻፈፕ ናባበካሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ቄሰ ሀላቅታይ፥ ህገ አስታማርታይኔ ጭምታይ የሱሳ የ ኣዝሳ ኡ ፋል አፋ ኣዝሴዛና ኤሬዝ ግሾስ ኤዛ አይኮዳይስ ኮዬዛ፥ ዝን አሳይስ ያሽቲ፥ አሺ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ፈርሳውታይፐኔ ሄሮዶሳ ባግታይፕ ጽቃ አስታይ ኤ ኦዳይፕ ቡታ ደንጊ፥ ኤዛ አይኮዳይስ ኮዪ፥ ኤዝኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ኡ ኤዝኮ ይኢ፥ «አስታማራዮ፥ ነ ቱሮ ኦድንትዛኔ አሳፕ አሰ ሻጎዛና ኑ ኤርዛ። ነ አሰ ሻጎያ፤ ማ ጾስ ኦገ ቱማር ታማርስዛ። ኑ ኦሮመ ቢታ ካት ቄሳረስ ጊራ ጋችዛይ ዎጋኔ ዎጋ ባሳ? ጊራ ጋቾኔ አሾ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ዝን ኡ ጩቦትꬃ የሱሳ ኤሪ፥ «ታና አብስ ፋጮዳይስ ኮዬ? አን ፐቲ ሳንተ Ꮊና ክኢ ታና ቤዞይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ኡንቲ ኤዝስ ከኤዛ፥ «Ꮊ ማላይኔ ሱንꬃይ ኦሶ?» ዬጊ ኡንታን ኦይጬዛ። ኡንቲ፥ «ቄሳረስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","የሱሳ ማሂ፥ «ዬዛኮ፥ ቄሳሬሳና ቄሳረስ፥ ጾሲሳ ጾስስ እንጎይታ» ዬግን ኡ ኤ ኦዳ Ꮊይ ማላ ባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ꮊይቄዝ አሲ ደንዶያ ግዝ ሳዱቃውታይፕ ፐቲ ፐቲ አሳይ የሱሳኮ ይኢ፥ Ꮊይ ጋርክ ዬጊ፥ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«አስታማራዮ፥ ሙሰ ኑስ ህገ ጻፍታር፥ ‹ማቾ ኤኬዝ አꬃይ ናአ የለካ Ꮊይቅኮ፥ የ Ꮊይቄዛይስ እሻይ ኤ ማቻቶ ኤኪ፥ ፋ እሻይስ ናአ የሎዳይስ ቤዝዛ› ዬግዛና ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ብኒ ዎደ ላፑን እሽታይ የዝታይፕ ባይራይ ማቾ ኤኪ፥ ናአ የለካዛር Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ናምእንꬃይ እዞ ኤኬዛ፥ ኤዝካ ናአ የለካዛር Ꮊይቄዛ። ሃይꬒንꬃይካ የይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ላፑንታይካ የይ ጋርክ እዞ ኤኪ፥ ናአ የለካዛር Ꮊይቄዛ። ኡባፕ ጉየ፥ ማ የ አስታካ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","የዝን፥ ላፑንታይ እዞ ኤኬዝ ግሾስ Ꮊይቄዝ አሳይ Ꮊይቆፕ ደንድዛ ጋላስ፥ እዛ ኡንታፕ ኣያይስ ማቾ ማቆደ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","የሱሳ ማሂ፥ «ይ ባልንትዛይ፥ ጌሻ ማጻፍታ ዎይ ጾስ ዎልቃ ኤረካ ግሾስ ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ꮊይቄዝ አሳይ Ꮊይቆፕ ደንድዛ ጋላስ፥ ሳሎ የዝ ኪታንችታይ ጋርክ ማቆዳይፕ አትን ꬊራꬅ አሳይ ኤኮያ፤ ማቺ አስታይ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ዝን Ꮊይቄዝታይ ደንዶ ባጋ ማቅኮ፥ ጾሲ ሙሰኮ ቱሻ ጋንጨ ኤጽዝ ታማፕ ዋጌዛኮ ሙሰ ማጻፋይፕ ይ ናባበካሳ? የይካ ‹ታኒ፥ አፍራመ ጾሲ፥ እሳቃ ጾሲ፥ ያይቆባ ጾሲ› ዬጌዛያ ");
INSERT INTO mfxe_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","የይ ግሾስ፥ ኤ፥ ፓꬅ የዝታይ ጾሳፕ አትን Ꮊይቄዝታይ ጾስ ባያ። ይ አቆፕ ኣꬊ ባልንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ህገ አስታማርታይፕ ፐታይ ኡ ፓላምዛና ሺቂ ስኤዛ። ማ የሱሳ ኡንትስ ሎእꬂ ማሄዛና ስኢ፥ «ኪታ ኡባፕ ኣꬊዝ ኪታይ ኣያ?» ዬጊ የሱሳና ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","የሱሳ ማሂ፥ ኤዝኮ Ꮊይ ጋርክ ዬጌዛ፦ «ኪታ ኡባፕ ኣꬊዝ ኪታ ስኦይታ፤ ‹እስሬለ አሳይስ፥ ጎዳይ ኑ ጾሳይ ፐቲ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ነ ጎዳ ነ ጾሳ ነ ኩንꬅ ዎዝናፕ፥ ነ ኩንꬅ ሸምፖፕ፥ ነ ኩንꬅ ቆፋፕ፥ ነ ኩንꬅ ዎልቃፕ ቃꬎባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ማ ኪታ ኡባፕ ኣꬊዝ ናምእንꬆ ኪታይ Ꮊያ፤ ‹ነ ላጋ ነ ኡባይ ጋርክ ቃꬎባ› ዬግዛ፤ Ꮊይትታይፕ ኣꬊዝ ሀራ ኪታ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ህገ አስታማራይ የሱሳኮ፥ «አስታማራዮ፤ ‹ጾሳይ ፐቶ። ኤዛፕ አትን ሀራ ባያ› ነ ጌዛይ ቱሮ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ጾሳ ኩንꬅ ዎዝናፕ፥ ኩንꬅ ቆፋፐኔ ኩንꬅ ዎልቃፕ ቃꬍዛይኔ ማ አስ ኡባ ፋ ኡባይ ጋርክ ቃꬍዛይ ጹግዝ ያርሾፐኔ ሀራ ያርሾ ኡባይፕ ኣꬍዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","የሱሳ ህገ አስታማራይ ማህꬃይ ኣꬎ ኤራ አስ ማልሰ ማቄዛና ብኢ፥ «ነ ጾስ ካተትꬃፕ ሃከካያ» ዬጌዛ፤ የይፕ ጉየ፥ የሱሳና ሀራ ባዝ ኦይጮዳይስ ኦንካ ምንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","የሱሳ ጾስ ኬꬃ ታማርስታር፥ Ꮊይ ጋርክ ዬጌዛ፦ «ህገ አስታማርታይ ክርስቶሳ ዋጊ ፋና ዳዉተ ናአ ጌ? ");
INSERT INTO mfxe_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዉተ ጌሻ አያና ደንꬅꬅን፥ « ‹ጎዳይ፥ ታ ጎዳይኮ፥ «ታኒ ነ ሞርክታ ነ ቶኬ የꬍዝ አቆ ኡዶድ ጋꬆ፥ Ꮊይዳ ታ ኡሻቻ በቶባ» ጌዛ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ዳዉተ ፋ ኡባስ ክርስቶሳና፥ «ጎዳ ግ ጼግኮ፥ የዝን፥ ክርስቶሳ ዋይዚ፥ ዳዉተ ናአ ማቄ» ዬጌዛ። ዎያይ የሱሳ ግዛና ኡፋይቲ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","የሱሳ ታማርስታር፥ Ꮊይ ጋርክ ዬጌዛ፦ «ህገ አስታማርታይፕ ናግንቶይታ፤ ኡ አዱስ አፍላ ማኢ ዩይዝታኔ ጋበላካ አሳይ ኡንታን ቦንቺ ሳሮꬅዛና ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ኡንቲ አይሁድታይ ዎሳ ኬꬃ ጋመ ሎኦ ኦይደ ዶስዛ፤ ማካ አሲ ፋና ሞክዛ አቆካ ቦንቾ አቆ ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ኡ አሲ በኦ ግ ዎሳ አዱስስታር፥ አምእታይ ኬꬃ ቦንቂዛ፤ ኡ ኡባፕ ኣꬊዝ ፕርዳ ኤኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","የሱሳ ጾስ ኬꬅ ጋንጨ ሙጻታ ኦልዛ ሳጽነ ካለ በቲ፥ አሳይ ፋ ሚሻ የ ሳጽናይድ ኦልዛና በኤዛ፤ ጋመ ዱረ አሳይ ጋመ ሚሸ የ ሳጽናተ ኦልዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ፐቲ ማንቆ አምአት ይኢ፥ ናምኢ ስክና የ ሳጽንተ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","የሱሳ ፋ ታማርታ ጼጊ፥ «ታ ይንትስ ቱሮ ኦድዛ፤ ሙጻታ ሳጽነ ጋንጨ ኦሌዝ አስ ኡባፕ Ꮊ ማንቆ አምአት ኣꬂ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","አብስ ጊኮ፥ Ꮊንክታይ ኡቢታይ ፓስ ፑጬዝ ሚሻይፕ ኦሌዛ። ዝን እዛ ፋ ፓጫትፕ፥ ፓስ የዛኖ ኡባር ኦሌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","የሱሳ ጾስ ኬꬃፕ ከሳዳር፥ ኤ ታማርታይፕ ፐታይ፥ «አስታማራዮ፥ Ꮊይ ዋፋ ሎኦ ሹችኔ ዋፋ ሎኦ ሹች ኬꬅዛኮ ነ ቦኦባ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","የሱሳ ማሂ፥ «Ꮊ ዳማ ሹች ኬꬃ ነ ብእኔ? Ꮊ ኬꬃይ ሹቺ ሹቻል አፋ ግምቢንቴዛይ ጋርክ ላልንተካዛር አታሚ፤ ፐቲ ሹችካ አተካዛር ኡቢታይ ላልንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","የሱሳ ጾስ ኬꬃፕ ቲና ባጋር ደብረ ዛይተ አምባል አፋ በቴዝን፥ ጵጽሮሳ፥ ያይቆባ፥ ዋንሳኔ እንድራሰራ ዎላ ኤዝኮ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Ꮊይ አይደ ሀኖዳዛኮ፥ ኑስ ኦዶባ፤ Ꮊ ኡቢታይ ፖልንቶድ ዎዳ ኤርስዛ ማላይ አባ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","የሱሳ ማካ ኡንትስ Ꮊይ ጋርክ ዬጊ ኦዴዛ፦ «ይንታን ኦንካ ባልꬃማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ጋመ አሳይ ታ ሱንꬃር፥ ‹ታኒ ክርስቶሳ› ዬግታር ይኢ፥ ጋመ አስታ ባልꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ኦላኔ ኦላ ዎረ ይ ስኤዝ ጋላስ ዳጋምፓተ። የይ ጋርክ ባዝ ሀኖዳይ አታሚ፥ ዝን ዉርስꬃይ ሀጋ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ፐቲ ዎያ ሀራ ዎያር ኦልንቶዳ፤ ማ ፐቲ ካተትꬃይ ሀራ ካተትꬃር ኦልንቶዳ፤ ቢታ ኤንኦ ኡባ አቆ ሀኖዳ፤ ናየ ደንዶዳ፥ ዝን የይ ኡባይ የሎስ ማቺ እቅንትዝ ዞኬ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«ዝን ይ፥ ይ ኡባስ ናግንቶይታ። አብስ ጊኮ፥ አሲ ይንታን አይኪ፥ ፕርደ ኬꬅስ ኣꬂ እማዳ፤ ማ አይሁድታይ ዎሳ ኬꬅታይዳካ ይንታን አላንጋር አላንጎዳ፤ ጋደ አቅስዝታይ ቲናኔ ካትታይ ቲና ታ ግሾስ ይ ማርካቶዳይስ ኤቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ዉርስꬂ ሄሎዳይፕ ቲና ዎንግለ አስ ኡባይስ ኦድንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ኡ ይንታን ፕርደ ኬꬅ ክእዛ ዎደኔ ኣꬂ እንግዛ ዎደ ዋጊ ኦዶደ ዬጊ ህርግፓተ፤ የ ሳታተ ጾሳይ ይንትስ እንግዛ ባዝ ኦዶይታ። ጌሻ አያናይ ኦድንትዛፕ አትን ይንታን ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«ኢሻይ ፋ እሻ፥ አዳይ ፋ ናአ ኣꬂ እማዳ። ናእታይ ፋና የሌዝታይል አፋ ደንዲ፥ ኡንታን ዎꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","አሲ ኡባይ ይንታን ታ ሱንꬃይ ግሾስ እጾዳ፥ ዝን ዉርስꬂ ሄሎዳይስ ጋርዤዛይ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«ዝን ꬋብስዛ ቱና ኦሶ ኤቆዳይስ ቤዞዋ አቆ ኤቄዝን ይ በአዳ።» የይ ዋጉስዛኮ ናባብዛይ አካኮ! «ይሁዳ ቢታ የዝታይ የ ዎደ አምባ ጉየ ቆስንቶ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ኬꬃል የዝ አꬃይካ ፐትባዝ ኤኮዳይስ፥ ፋ ካራ ገልፐ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ጋደ ኦꬆል የዛይ ፋ አፍላ ኤኮዳይስ ጉየ ማቅፐ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","የ ዎደ ዎደꬅ ማችታይስኔ ꬋንꬅዛ ማችታ ኡንታን አየ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ዝን Ꮊይ ኡቢታይ ሀኖዳር ዎዳይ ባርጎ ማቃማይ ጋርክ፥ ጾስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","አብስ ጊኮ፥ ጾሲ አላመ መꬌዝ ዎደፕ አይኪ፥ Ꮊኖ ሄሎዳይስ ሀንበኤካ መቶ ቲናፐካ ሀናም መቶ አሳል አፋ የ ዎደ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ጎዳይ የ ጋላስታይ ታይባ ሃትꬆዛኮ፥ አስ ግዝ ኦንካ አታሚ። ዝን ኤ ፋ ዶሬዝ አሳይ ግሾስ የ ጋላስታይ ታይባ ቃንꬅሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«የ ዎደ ኦንካ ይንታን፥ ‹Ꮊያ ቦኦይታ፥ ክርስቶሳ Ꮊይዳ የዛ ዎይ ክርስቶሳ ሰንዳይዳ የዛ› ዬግኮ፥ የያ አማንፓተ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ዎርዶ ክርስቶስታይራኔ ዎርዶ ናብታይ ደንዲ ኡንትስ ዳንዳእንትኮ፥ ሀራ አቶዝን ጾሳይ ማራጼዝታካ ባልꬆዳይስ ማላኔ ማላባዝ ቤዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ዝን ይ ናግንቶይታ፤ ታ ይንትስ ኡባ ባዝ ቲናቲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«ዝን የ ዎደ የ ዋያይፕ ጉየ፥ « ‹አዋ ꬉሞዳ፤ አግና ፋ ፎአ ካዮዳ፤ ");
INSERT INTO mfxe_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ጾልንትታይ ሳሎፕ ጉፎዳ፤ ማ ሳሎ የዝ ዎልቅታይካ ኤንኦዳ።› ");
INSERT INTO mfxe_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","የ ዎደ አስ ናአይ፥ ኣꬎ ዎልቃራኔ ቦንቾራ ሻራ ጋንጨር የኦዳር ኡባይ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","የ ዎደ ኤ ኪታንችታ ኪቶዳ፤ ኡንትካ ኦይዲ ጎንተ Ꮊንጊ ሳአ ጋጻፕ ሳሎ ጋጻ ሄሎዳይስ፥ ጾሲ ዶሬዝ አስታ ሺሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«ኣዝሶ ባላሰ ምꬃፕ አካኮይታ፤ ባላሳታ ፉርጮዳራኔ እ ሀያይ ብልእꬅ አይክኮ ቦነ ኡኬዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","የይ ጋርከካ፥ ይ የ ኡባ ባዝ ሀንዛና ብእኮ ዎዳይ ኡኪ ፐንገ ሄሌዛና ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ታ ይንትስ ቱሮ ኦድዛ፤ Ꮊ ኡባባዛይ ሀኖድ ጋꬆ Ꮊ የለትꬅ ኡቢታይ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ሳሎኔ ሳአ ኣꬎዳ፥ ዝን ታ ቃላይ ኡባራካ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«ዝን የ ጋላሳኔ የ ሳታ አዳይ ኣዳፕ አትን ሀራ አቶዝን ሳሎ የዝ ኪታንችታ ማቅን ዎይ ናአ ማቅን ኦንካ ኤርዛይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","የ ጋላሳይ አይደ ማቆዳዛኮ ይ ኤሮዋ ግሾስ ናግንቶይታ፥ ምንጎይታኔ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ታ ይእꬃይ ፋ ካራ አሺ፥ ኦገ Ꮊንግዛ አꬃይ ጋርከ። አꬃይ ፋ አይልታ ኦማር ኦማር ኦꬆ አይꬂ ኡንትስ ፋ ኦሳይስ ማዉተ እንጌዛ፤ ማ ናግዛናካ ሚንꬂ ናጎድ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«የይ ግሾስ፥ ሚንጎይታ። አብስ ጊኮ፥ ካራ አዳይ ኦማꬅ ማቆ ዎይ ግዲ ብላሄ ማቆ ዎይ ሹጉላ ኡፎ ማቆ ዎይ ዎንትማꬄ ማቆ አይደ የኦዳዛኮ፥ ይ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ይ አካኬካዝን ኤ ይኢ ይንታን ይ ገንቲ የዝን ደንጋማይ ጋርክ ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ታ ይንትስ ኦድዛን ጋርክ አስ ኡባስ፤ ሚንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ፓዝቃ ባለ ቦንችዛ ጋላስኔ ቦራ ባለ ቦንችዛ ጋላስ ሄሎዳይስ ናምኢ ጋላሲ አቴዛ። ቄሰ ሀላቅታይኔ ህገ አስታማርታይ ጩቦትꬃር የሱሳና አይኪ ዎꬍዛ ኦገ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","«አሳይ ካች ከሳማይ ጋርክ ፓዝቃ ቦንችዝ ጋላስ ኦꬃሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","የሱሳ ብታና ካታማ ቦርቆንቶ ሀርገር የዝ ስሞና ካራ ስብረል አፋ በቴዝን፥ ፐቲ አስታ አልባስጽሮሳ ግንትዝ ብልጋጸ ኩንꬅ ናርዶሰ ግንትዝ ጋመ አልኦ ሽቶ ኤኪ የኤዛ። የ ብልጋጻቶ መንꬂ ሽታ የሱሳ ኦማይል ሁልኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","የ አቃይድ የዝ አሳይፕ ፐታይ ፐታይ ካጭንቲ፥ «Ꮊ ሽታይ ጨር ኢትዛይ አብሶ? ");
INSERT INTO mfxe_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ꮊ ሽታና ሀይꬒ ጼት ድናረ ጋተ ከሶዳያ ባይዚ፥ ሚሻ ማንቅታይስ እማዳይስ ዳንዳእንትዛዝን» ዬጊ ፋ ጋንጨር ዎላ ኦድንቴዛ። ዬዚ፥ የ አስቶ ቦሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ዝን የሱሳ «Ꮊ አስቶ አሾይታ፤ እዞ አብስ ዋይꬄ? እዛ ታስ ሎኦ ባዝ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ማንቅታይ ኡባ ዎደ ይንታር የዛ። ይ ኮዤዝ ጋላስ አይደካ ኡንታን ማዶዳይስ ዳንዳእዛ፥ ዝን ታ ኡባ ዎደ ይንታር የዛሚ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","እዛ ፓስ ዳንዳእንቴዛይ ጋርክ ኦꬄዛ፤ ማ ታና ሞጎስ ጊግሶዳይስ ቲናቲ ሽቶ ትዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ታ ይንትስ ቱሮ ኦድዛ፤ ሳአ ኡባይል ዎንግለ ኦድንትዛ አባ ማቅኮካ፥ አሳይ እዞ ሀሳዮዳይ ጋርክ Ꮊ እዛ ኦꬄዛይ ኦድንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ታጶ ናምኢ ታማርታይፕ ፐታይ አስቆሮቶ ይሁዳ ግንትንትዛይ የሱሳና ቄሰ ሀላቅታይስ ኣꬂ እማዳይስ ኡንትኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ኡ የያ ስኢ ኡፋይቲ፥ «ኑ ኔስ ሚሸ እማዳ» ዬጌዝ ግሾስ፤ ይሁዳ የሱሳና ኣꬂ እንጎዳይስ ጊጋ ጋላስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ቦራ ባለ ቦንችንትዛይፕ ቲና ጋላስ፥ ፓዝቃ ካꬃ ማዳይስ ዱር ሹክዛ ጋላስ የሱሳ ታማርታይ ኤዝኮ፥ «ፓዝቃ ቦንችዛ ጋላስ ነ ማድ ካꬃ ኑ ኣይድ Ꮊንጊ ማኮ?» ግ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","የሱሳ ፋ ታማርታይፕ ናምእታ Ꮊይ ጋርክ ዬጊ ኪቴዛ፦ «ካታማ Ꮊንጎይታ፤ ይ Ꮊማዳር፥ ኦታር ሃꬅ ቶኬዝ ፐቲ አꬃይ ይንታን ሄሎዳ፤ ኤዛ ካሎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ኤ Ꮊንጊ ገልዛ ኬꬃቲ ጎዳይኮ፥ ‹አስታማራይ ኔኮ፥ ታኒ ታ ታማርታይር ፓዝቃ ማዳይስ እማꬅ ኬꬂ አባ የኔ? ዬጌዛ› ዬጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ካራ ጎዳይ ይንታን ፖቄል አፋ ሂጽንቲ ጊጊ የዝ ዳልገ ክፍለ ቤዞዳ፤ የ አቃይድ ማኮይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","የ ታማርታይ ከዚ፥ ካታማ Ꮊንጌዛ፤ የሱሳ ኡንትስ ኦዴዛይ ጋርክ ደንጊ፥ ፓዝቃ ካꬃ ማኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ሳአ ኦማꬆዳር የሱሳ ታጶ ናምኢ ታማርታይር የ አቃ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ኡ በቲ ካꬃ ማዳር፥ የሱሳ ኡንትኮ፥ «ታ ይንትስ ቱሮ ኦድዛ፤ ይንታፕ ፐታይ ታር ሚዛይ፥ ታና ኣꬂ እማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ኤ ታማርታይ ዳጋሚ፥ ፋ ኦማስ ኦማስ፥ «ቱማ ታናሻ?» ዬጊ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","የሱሳ ማሂ፥ «የ አꬃይ ይ ታጶ ናምእታይፕ ፐታ፤ ኤ ታር ዎላ ፍልኦ ጋንጨ ኩሸ ዳክዛያ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","አስ ናአይ፥ ጌሻ ማጻፋይድ Ꮊይቆዳ ጌዛይ ጋርክ Ꮊይቆዳ፥ ዝን አስ ናአ፥ ኣꬂ እንግዛ አꬃ ኤዛ አየ። የ አꬃይ የልንተካ አቴዛኮ ኤስ ሎኦዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ኡ ማዳር፥ የሱሳ ቦራ ኤኪ፥ ጾስ ጋላቴዛ፤ የ ቦራ ባጺ፥ ፋ ታማርታይስ እንግታር፥ «Ꮊሽተ፥ Ꮊይ ታ አሾ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ጹአ ደንꬂ፥ ጾስ ጋላቲ፥ ኡንትስ እንግን ኡቢታይካ የ ጹአይፕ ኡዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","የሱሳ፥ «Ꮊይ ጋመ አሳይስ ጎግዝ ኦሮꬅ ጫቆ ታ ሱꬂ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ታ ይንትስ ቱሮ ኦድዛ፤ ታኒ ጾስ ካተትꬃ ኦሮꬅ ዎይነ ኡዦድ ጋላሳይ ሄሎድ ጋꬆ ማቂ Ꮊ ዎይናይፕ ኡዣሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ማዝሙረ የጼዛይፕ ጉየ ደብረ ዛይተ አምባል አፋ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","የሱሳ ኡንትኮ፥ «ይ ኡቢታይ ታና ኦሊ አሺ ላሲ ꬋቦዳ፤ « ‹ጾሲ ሄንግዛና ሾጮዳ፥ ዱርታይ ኡባይ ላልንቶዳ› ዬግንቲ ጻፍንቴዛይ ጋርከ። ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ዝን ታ Ꮊይቆፕ ደንዴዛይፕ ጉየ ይንታፕ ቲናቲ ጋልላ ኣꬎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ጵጽሮሳ ማሂ፥ «ኡ ኡቢታይ ነና ኦሊ አሽኮካ፥ ታ ነና አሻሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","የሱሳ ጵጽሮሳኮ፥ «ታ ኔስ ቱሮ ኦድዛ፤ Ꮊይኖ ቃማ ሹጉላ ናምኢ ቶክ ኡኮዳይፕ ቲና ነ ታና ሀይꬒ ቶኬ ካዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ዝን ጵጽሮሳ ቲናሳይፕ ሚንꬂ፥ «ታ ሀራ አቶዝን፥ ኔር ዎላ Ꮊይቅዛኮካ፥ ነና ካዳሚ» ዬጌዛ። Ꮊንክታይ ኡቢታይካ የይ ጋርክ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","የሱሳ ፋ ታማርታይር ጌተሰማነ ግንትዝ አቆ Ꮊንጊ፤ ፋ ታማርታይኮ፥ «ታ ጾሳ ዎሲ ማቆድ ጋꬆ ይ Ꮊይዳ በቶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","የሱሳ ጵጽሮሳ፥ ያይቆባራኔ ዋንሳ ፓር ኤኪ ቅቴዛ፤ ዋይንቴዛኔ ኡንእንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ማ ኡንትኮ፥ «ታ ሸምፓታ Ꮊይቆድ ጋꬆ አዛኔዛ፥ Ꮊይዳ ጋምኦይታኔ፤ ሚንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ጽቃ ቲና ሺቂ፥ ሳአ ጹጉኒ፥ ዳንዳእንትዛ ባዝ ማቅኮ፥ Ꮊ ዋየ ሳታይ ፓፕ ኣꬎዳይ ጋርክ፥ ጾስ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ማ፥ «አቦ፥ አባቦ፥ ኡባ ባዝ ኔስ ዳንዳእንትዛ፥ Ꮊ ዋየ ጹአ ታፕ ሃሶባ። ዝን ነ ሸነ ሀኖፕ አትን ታ ሸነ ሀንፔ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","የሱሳ ማቂ ይኢ፥ ኡ ገንቴዝን ደንጊ፥ ጵጽሮሳኮ፥ «ስሞና፥ ገንቴኔ? ሀራ አቶ ነ ፐቲ ሳተካ ባርኪ ናጎዳይስ ዳንዳኤካሳ? ");
INSERT INTO mfxe_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ፓጨ ጋንጨ ይ ገላማይ ጋርክ ባርኪ ናጎይታኔ ጾሳ ሚንጊ ዎሶይታ። አያናይ፥ ጊግንቴዝን አሻይ ዳቡራ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ማካ Ꮊንጊ ቲናሳይ ጋርክ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ꮊተካ ኤ ጉየ ማቂ ኡንትኮ የኦዳር ገንቴዝን ደንጌዛ። ኡ አፋ ገንታ ጎዚ ጋዴዝ ግሾስ ኤዝኮ አብ ማሆዳዛኮካ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ሃይꬒንꬆ ኡንትኮ ይኢ፥ «Ꮊኖ ሄሎዳይስካ ገንታላኔ ሸምፖል የኔ? ይኬ፥ ግዶዳ፤ ሳታት ሄሌዛ፤ ቦኦይታ! አስ ናአይ፥ ናጋራንቾ አሳይስ ኣꬊ እንግንቶድ ዎዳይ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ይኬ ደንዶይታ የꬎይታ፤ ቦኦይታ፥ ታና ኣꬂ እንግዛ አꬃይ ሄሌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","የሱሳ የያ ሀጋ ኦዶዳር፥ ኤ ታጶ ናምኢ ታማርታይፕ ፐታይ፥ ይሁዳ፥ ኤልሲ ሄሌዛ። ማ ቄሰ ሀላቅታይ፥ ህገ አስታማርታይኔ ጭምታይ ኪትን፥ ማሻኔ ጉፈ አይኬዝ ጋመ አሳይ ኤዛር ዎላ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","የሱሳና ኣꬂ እንጎዳይ የ ጋመ አሳይስ፥ «ታ ዬርዛይ ኤዛ፤ ኤዛ አይኪ፥ ሎእꬂ ናጊ፥ ኤኪ ካንጎይታ» ዬጊ ማላ ኦዲ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ይሁዳ ሄሌዛን ጋርክ የሱሳኮ ሺቂ፥ «አስታማራዮ» ዬጊ የሱሳ ዬሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","የ ጋመ አሳይ የሱሳና አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ኤ ታማርታይፕ ፐታይ ፋ ማሻ ሾዲ ቄሰ ሀላቃይ አይላ ሾጪ፥ ኤ ሀይቶ ቃꬊ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","የሱሳ ማሂ፥ አሳይኮ፥ «ይ ታና ፓኖ አይክዛይ ጋርክ አይኮዳይስ ማሻኔ ጉፈ አይኪ የኤኔ? ");
INSERT INTO mfxe_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ታ ጾስ ካራ ጋንጨ ታማርስታር፥ ጋላስ ጋላስ ይንታር የዝን ታና አይከካዛር፥ ጌሻ ማጻፋይ ጌዛይ ፖልንቶዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ኤ ታማርታይ ኡቢታይ ኤዛ ኦሊ አሺ ላሲ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ላጻና ኣዳ ማኤዝ ፐቲ የላጋ አꬃይ የሱሳ ካሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ዝን የ አꬃይ ላጻና ኦሊ አሺ፥ ጺራ ካሎ ላሲ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","አሳይ የሱሳ ቄሰ ሀላቃይ ካራ ካንጌዛ። ኤዛይድ ቄሰ ሀላቅታይ፥ ጭምታይኔ ህገ አስታማርታይ ሺቂ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጵጽሮሳ ቄሰ ሀላቃይ ዛባ ሄሎዳይስ ሃኮር ኤዛ ካሊ Ꮊንጊ ኤዛይድ ናግዝታይር በቲ ታማ ካዥዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ቄሰ ሀላቅታይኔ ፕርደ ሻንግታይ ኡቢታይ የሱሳ ዎꬎዳይስ ኤዛል አፋ ማርካ ኮዬዛ፥ ዝን አብካ ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ጋመ አሳይ ኤዛል አፋ ዎርዶ ማርካቴዛ፥ ዝን ኡ ማርክተꬃይ ፐቲ ቃላ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","ፐቲ ፐቲ አስታይ ደንዲ ኤቂ የሱሳል አፋ፥ «ኤ፥ ‹ታኒ አሲ ኬጼዝ Ꮊ ጾሳ ኬꬅ ላሊ፥ አሲ ኩሸ ኬጽንተካ ሀራ ጾስ ኬꬅ ሀይꬒ ጋላሳ ጋንጨ ኬጾድ› ጎዳር ኑ ስኤዛ» ዬጊ ዎርዶ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ማቆዝን፥ ኡ ማርከትꬃይ ፐቶ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ቄሰ ሀላቃይ አስ ኡቢታይ ቲናይድ ደንዲ ኤቂ፥ «Ꮊይታይ ነና ሞትዛ ሞታይስ ነ ማህዝባዝ ባሳ?» ዬጊ የሱሳና ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ዝን የሱሳ ስኤ ጌዛ፤ አብካ ማሄካያ። ቄሰ ሀላቃይ፥ «አንጅንቴዝ ጾስ ናአይ፥ ክርስቶሳ ነናኔ?» ዬጊ ማሂ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","የሱሳ ማሂ፥ «ኤ ታና፥ ይ አስ ናአይ፥ ዎልቃማ ጾሳፕ ኡሻች ባጋር በቴዝንኔ ሳሎ ሻራር የኦዳር በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ቄሰ ሀላቃይ ሸነር ፋ አፍላ ፔꬊ፥ «ኑና ሀራ አብ ማርካ ኮሼ? ");
INSERT INTO mfxe_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ይ ኤ ጫሻ ስኤዛ፤ ይንትስ አብ ኣዜ?» ዬጌዛ። ኡንቲ ኡቢታይ፥ «ኤ Ꮊይቆዳይስ ቤዝዛ» ዬጊ ኤዛል አፋ ፕርዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ኡንታፕ ፐታይ ፐታይ ኤዛል አፋ ጩቲ ኤ አፋ ጎሊ ዡልትታር፥ «ነና Ꮊꬌዛይ ኦኖ? አን ኑስ ኦዶባ!» ዬጌዛ። ናግዝታይ ኤዛ ጋራፍታር ኤኪ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጵጽሮሳ ቄሰ ሀላቃይ ዛባይድ ዬክ ባጋር የዝን፥ ቄሰ ሀላቃይ ጋꬊንድታይፕ ፐታት እዘ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ጵጽሮሳ ታማ ካዦዳር እዛ ዳኪ ብኢ፥ «ኔካ ናዝረተ የሱሳር የዛ ባይ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ዝን ጵጽሮሳ፥ «ነ ግዛይ አብዛኮ ታ ኤሮያ፥ ታስ አካክንቶያ» ዬጊ ካዴዛ። ዬጊ ማቂ ኤ ባለ ከዜዛን ጋርክ ሹጉላ ኡኬዛ ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","የ ጋꬊንዳታ ጵጽሮሳ ብኢ፥ እ ላንቀ ኤቄዝ አስታይኮ፥ «Ꮊ አꬃይካ ኡንታር የዛ» ግ ማሂ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ዝን ጵጽሮሳ ማካ ካዴዛ። ጽቃ ጋምኦዳር፥ ላንቀ ኤቄዝ አስታይ ማካ ጵጽሮሳኮ፥ «ነ ጋልላ ቢታ አስ ማቄዝ ግሾስ ቱማ ኡንታር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ዝን ጵጽሮሳ፥ «ታ ይ ግዝ አꬃ ኤሮያ!» ዬጊ ፋና ባድꬅኔ ጫቆ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","እዝር ሹጉላ ናምእንꬆ ኡኬዛ። ጵጽሮሳ የሱሳ ኤዝኮ፥ «ነ ሹጉላ ናምኢ ቶክ ኡኮዳይፕ ቲና ሀይꬒ ቶክ ታና ካዶዳ» ኤዝኮ ጌዛይ ኤልቂ ግን ዬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ዎንት ጉር ኤልሲ ቄሰ ሀላቅታይ፥ ጭምታይ፥ ህገ አስታማርታይኔ ፕርደ ሻንጎ ኡቢታይ ሺቂ ቶቤዛ። ኡ የሱሳና አጪ ካንጊ ጵላጾሳስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጵላጾሳ ኤዝኮ፥ «ነ አይሁድታይስ ካቶ?» ዬጊ ኦይጬዛ። የሱሳ ማሂ፥ «ነ ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ቄሰ ሀላቅታይ የሱሳና ጋመ ባዛ ሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ዝን ጵላጾሳ ማሂ የሱሳኮ፥ «ኔስ ማህዝባዝ ባሳ? ኡ ኔል አፋ አብ ጋርክ ሞቶ ክእዛኮ በአሞ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ዝን የሱሳ ሀራ ባዝ ማሃም እጽን፥ ጵላጾሳ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጵላጾሳስ ፓዝቃ ባለ ቦንችዛ ጋላስ አስታይ ኮይዝ ፐቲ አꬃ አቻፕ ብልእዝ ዎጋ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","የ ዎደ ፐቲ ባእርባና ግዝ አꬃይ ዳፋ ከሲ ሸምፖ ዎꬌዝ አስታይር ዎላ አች ካራ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ጋመ አስታይ ጵላጾሳክ ይኢ ካሴሳይ ጋርክ ኦꬆድ ጋርክ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ጵላጾሳ አሳና ማሂ፥ «ታ ይንትስ አይሁድታይ ካታ ብልኦዳና ኮይኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ꮊ ኤ ጌዛይ፥ ቄሰ ሀላቅታይ የሱሳ ቅናተ ኣꬂ እንጌዛና ኤርዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ዝን ቄሰ ሀላቅታይ ባእርባና ብሎዳይ ጋርክ፥ የ ሺቄዝ አስታይ ጵላጾሳ ዎሶዳይ ጋርክ አስታ ደንꬅꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጵላጾሳ ማሂ፥ «የዝን፥ ይ አይሁደ ካተ ግዛና ዋይሳዳይ ጋርክ ኮዬ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","አስታይ ጵላጾሳል አፋ ኡኪ፥ «ማዝቃለል አፋ ኤዛ ሶቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጵላጾሳ አሳይኮ፥ «አብሶ? ኤ አብ ኢታ ባዝ ኦꬄኔ?» ዬጌዛ። ዝን አሳይ ቲናሳይፕ ጉጂ ኡኪ፥ «ማዝቃለል አፋ ኤዛ ሶቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጵላጾሳ አሳ ኡፋይሶዳይስ ኮዪ፥ ባእርባና አሳይስ ብልኤዛ፤ የይፕ የሱሳና አላንጊ፥ ማዝቃለል አፋ ሶቶዳይ ጋርክ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","የይፕ ጉየ፥ ዎታዳርታይ የሱሳ ፕራይቶራ ግንትዝ ዎታዳርታይ ዛባ ኤኪ ካንጊ፥ ሀራ ዎታዳርታ ኡባ ጼግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ማ ዞቆ አፍላ ኤዛ ማእሴዛ፤ አንጉꬅ ዛዉደ ኮቺ፥ ኤ ኦማይድ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","የይፕ ጉየ፥ ኤዝኮ፥ «አይሁድታይ ካታዮ ሳሮ» ዬጊ፥ ኤስ ኩሸ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ኤ ኦማይድ ጉፈር ሾጬዛ፤ ማ ኤዛል አፋ ጩቴዛ፤ ጹጉኒ ኤስ ጎይኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ኤዛ ለቄዛይፕ ጉየ ዞቆ አፍላ ኤፕ ቃሪ ኤኪ፥ ኤ አፍላ ኤዛ ማእስ ማዝቃለል አፋ ኤዛ ሶቶዳይስ ኤኪ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ኡ Ꮊንግታር፥ ኢስክንድረራኔ ሩፎሳ ኣዳ፥ ስሞና ግዝ ቀረና ጋደ አስ፥ ጋጻረፕ ካታማ ይእዛና ሄሊ፥ የሱሳ ማዝቃላና ዎልቃንꬂ ቶሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ዬዚ ጎልጎታ ግዝ አቆ የሱሳ ካንጌዛ። «ጎልጎታ» ጉሳይ «ኦማ ኦታ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ካርበ ግዝ ꬋለር ዋላክንቴዝ ዎይነ ኡዦ ግ ኤስ እንጌዛ። ዝን ኤ ኡዣም እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ኡ ማዝቃለል አፋ ኤዛ ሶቴዛይፕ ጉየ ኦና አቢ ሄሎዳዛኮ ግ ኤ አፍላይል ዎላ እጻ ኦሊ ሻግንቲ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ኡ ማዝቃለል አፋ ኤዛ ሶቶዳር ዎንታፕ ሀይꬒ ሳተ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ኡንቲ፥ «አይሁድታይ ካታ» ዬጊ ኤዛ ሞትዛ ጹፈ ጻፊ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","የሱሳር ናምኢ ፓንታ ፐታ ኤዝፕ ኡሻች ባጋር Ꮊንካ ኤዝፕ ሀድርስ ባጋር ማዝቃለል አፋ ሶቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ጌሻ ማጻፈ፥ «ኢታ ባዝ ኦꬄዝ አስታይር ኤ ታይብንቴዛ» ዬግንቴዛይ ፖልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ኦገር ኣꬊዝ አሳይ የሱሳ ቶቺ፥ ፋ ኦማ ኤንእሲ ጫዤዛ፤ «የዝን! ጾስ ካራ ላሊ ሀይꬒ ጋላሳ ጋንጨ ኬጽዛዮ፥ ");
INSERT INTO mfxe_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","አን ማዝቃላይፕ ሱለ ዎꬊ ነና አሾባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","የይ ጋርከካ፥ ቄሰ ሀላቅታይ ህገ ታማርስዝታይር ዎላ የሱሳ ቶቺ «Ꮊንክታ አሼዛ፥ ዝን ፋና አሾዳይስ ዳንዳኦያ፤ ");
INSERT INTO mfxe_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ኑ ብኢ አማኖድ ጋርክ ክርስቶሳ፥ ኤ እስሬለ ካትዛኮ፥ አን ማዝቃላይፕ Ꮊት ዎꬎ» ዬጌዛ። ማ ሀራ አቶዝን፥ ኤዛር ማዝቃለል አፋ ሶትንቴዝታይካ ኤዛ ቶቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ኡሱፑን ሳተፕ አይኪ፥ ኡዱፉን ሳተ ሄሎዳይስ ቢታ ኡባይ ꬉሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ኡዱፉን ሳተል የሱሳ ፋ ቃላ ꬎቅ ኡዲ፥ «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቅታኒ?» ዬጊ ኡኬዛ። የያ ጉሳይ፥ «ታ ጾሳዮ፥ ታ ጾሳዮ፥ ታና አብስ አሼነ?» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ያ አቃይድ ኤቄዝ አሳይፕ ፐታይ ፐታይ የያ ስኢ፥ «ዬዛኮ፥ ኤላሳ ጼግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","የ አሳይፕ ፐታይ ላሲ፥ ዛንዛር ጫላ ዎይነ ኩንꬅ፤ ጉፈ ጼራል ጋዲ፥ «ናጎይታ፤ ኤላሳ ማዝቃላይፕ ኤዛ ዎꬆዳይስ የኦዳዛኮ አን ዎላ በአዳ» ዬጊ የሱሳ ዶናይኮ ኡሾዳይስ ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","የሱሳ ፋ ቃላ ꬎቅ ኡዲ ኡኪ፥ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ጾስ ካራ ሶትንቴዝ ማጋራዣይ ኣፋፕ ሳአ ሄሎዳይስ፥ ናምኢ ከዚ ፐርእንቲ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ማዝቃላይፕ ቲና ባጋር ኤዛይድ ኤቄዝ ፐቲ ማቶ ሀላቃይ፥ የሱሳ ዋይዚ Ꮊይቄዛኮ ብኢ «Ꮊ አꬃይ ቱማ ጾስ ናአ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ያ ሃኮር ኤቂ ብእዛ ማችታይ የዛ። ኡ ጋንጨ ማግዴላ ማይራማ፥ ጌዶ ናአ ያይቆባስኔ ዮሳ እንዳት ማይራምራኔ ሳሎምራ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","የ ማች አስታይ የሱሳ ጋልላ ቢታ የዝ ዎደ ኤዛ ካለዝታኔ ኤዛ ሞኬዝታ። ማ የሱሳር ዎላ የሩሳላመ Ꮊንጌዝ ሀራ ጋመ ማች አስታይ ኤዛይድ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ሳአይ ኦማርሴዝ ግሾስ ሺቄዝ አሳይ ጋንጨ ቦንችንቴዝ አይሁደ ሻንግታይፕ ፐታይ፥ ዮሴፋ ግዝ አꬃይ፥ ጾስ ካተትꬃይ የኦዳ ጊታር የዛይ፥ አርማታሳ ካታማ አሳይ የኤዛ። ዎንትꬃ ማላ ዎንትዛ ጋላስ ማቄዝ ግሾ ዮሴፋ ሚንጊ ጵላጾሳክ Ꮊንጊ፥ የሱሳ አሃ ኤኮዳይስ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጵላጾሳካ የሱሳ Ꮊይቃ ስኢ ማላባዝ ጌዛ፤ ማቶ ሀላቃ ጼጊ፥ «ኤ Ꮊይቂ ጋምኤነኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ጵላጾሳ የሱሳ Ꮊይቃ ማቶ ሀላቃይፕ ስኢ ኤ አሃ ዮሴፋስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዮሴፋ ሞጎ አፍላ ዎንጊ፤ የሱሳ አሃ ማዝቃላይፕ ዎꬂ፥ አፍላር ጻጺ፥ ዛላፕ ዎጭንቴዝ ዱፎ ጋንጨ ሞጌዛ። ማ የ ዱፋይ ዶናይድ ዳማ ሹች ጎልእሲ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ማግዴላ ማይራምራ ዮሳ እንዳት ማይራምራ የሱሳ አሃ ኡንቲ አባ ጋድዛኮ ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ማላ ጋላሳይ ኣꬌዛይፕ ጉየ ማግዴላወ ማይራሞ፥ ያይቆባ እንዳት ማይራማኔ ሳሎመ Ꮊንጊ፥ የሱሳ አሃ ትዦዳይስ ሽቶ ዎንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ዎጋ ጋላስ ጉራ ዠርክዠርኮ ጻልቀ ከሳዳር፥ ዱፎ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ኡ ፋ ጋንጨ ፐታቲ ፐታትራ፥ «ዱፋይ ዶናፕ ኑስ ሹቻ ኦኖ ጎልእሲ ሃሶዳይ?» ዬጊ ዎላ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ኡ በአዳር የ ዳም አቴዝ ሹቻይ ጎልአልኢ ሀልኤዛና በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","የሱሳ ሞግንቴዝ ዱፋይ ጋንጨ ገሎዳር ፐቲ የላጋ አꬃይ ቦꬅ አፍላ ማኢ፥ ኡሻች ባጋር በቴዛና ብኢ ዳጋሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ዝን ኤ ኡንትኮ፥ «ዳጋምፓተ፤ ማዝቃለል አፋ ሶትንቴዝ፥ ናዝረተ የሱሳ ይ ኮይዛና ታ ኤርዛ። ኤ Ꮊይድ ባያ፥ Ꮊይቆፕ ደንዴዛ። ኡ ኤዛ ሞጌዝ አቃ Ꮊያ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ꮊት Ꮊንጊ የሱሳ ታማርታይስኔ ጵጽሮሳስ፥ ‹የሱሳ ይንታፕ ቲናቲ ጋልላ ኣꬍዛ። ኤ ይንትስ ኦዴዛይ ጋርክ ይ ኤዛ ኤዛይድ በአዳ› ዬጊ ኦዶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ማችታይ ያሻር ኩኩርታር ዱፋይፕ ከዚ ላሲ ቅቴዛ። ማ ኡ ያሽቴዝ ግሾስ የያ ኦስካ አብካ ኦደካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","የሱሳ Ꮊይቆፕ ደንዴዛይፕ ጉየ ዎጋ ጋላስ ጉራ፥ ላፑን ቱና አያንታ እዝፕ ኤ ከሴዝ ማግዴላ ማይራምስ ቲናቲ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","እዛ Ꮊንጊ ቲና ኤዛር የዝታይስ፥ ኡ አዛንታራኔ ዬክታር የዝን ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ዝን የሱሳ ፓꬅ የዛናኔ እዝስ በንቴዛና ኡ ስኤዝ ዎደ እዛ ግዛ አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","የይፕ ጉየ፥ ኡንታፕ ናምእታይ ካታማፕ ከዚ Ꮊማዳር፥ ኦገላ የሱሳ ቲናሳይፕ ዱማቲ ኡንትስ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ኡ ጉየ ማቂ፥ ሀራ አሳይስ ኦዴዛ፥ ዝን ሀራ አሳይካ ኡ ኦዳ ቱማ ጌካያ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ጉየፕ ታጶ ፐቲ ኤ ታማርታይ ካꬃ ማዳር፥ የሱሳ ኡንትስ በንቴዛ። ኡንትስ አማኖ ባዛይ ግሾኔ Ꮊይቆፕ ኤ ደንዴዛና በኤዝ አሳይ ኦድን ኡ አማናም እጼዛይስ ኤ ኡንታን ቦሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ኤ ኡንትኮ፥ «ቢታ ኡባይል Ꮊንጊ አስ ኡባይስ ዎንግለ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","አማኔዛይኔ ጻማቅንቴዛይ አቶዳ፥ ዝን አማነካዛይ ፕርድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","አማንዝታይስ Ꮊ ማላትታይ እንግንቶዳ። ኡ ታ ሱንꬃይር ቱና አያንታ ከሶዳ፥ ኦሮꬅ ዶና ናሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ኡ ሾሽ አይክኮ ዎይ ዎꬍዛ ባዝ ኡዥኮካ ኡንታን ቆሃሚ። ማ ኡ ፋ ኩሸ ሀርግንቴዝታይል አፋ ጋዲ ኡንታን ፓꬆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ጎዳ የሱሳ ታማርታይራ ናሼዛይፕ ጉየ ፑደ ደንዲ ሳሎ ከዜዝ፤ ጾሳፕ ኡሻች ባጋር በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ኤ ታማርታይ Ꮊንጌዝ አቆ ኡባይድ ቃላ ኦዴዛ። ጎዳይካ ኡንታር ዎላ ኦꬅዛ። ኡ ኦድዛ ቃላይ ቱማ ማቄዛ ጾሳይ ኡንትስ እንግዛ ማላይር ፋ ቃላ ሚንꬄዛ።");
INSERT INTO mfxe_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ቦንቾ ቶፍሎሳ፥ ኑ ጋንጨ ፖልንቴዝ ባዛ ጋምታይ፥ ፓስ ዳንዳእንቴዛይ ጋርክ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","የ ታርካ ኡ ጻፌዛይ ቲናፕ አይኪ ኣፈ ማርክታይኔ ቃላ ኦዲ ማድዝታይ ኑስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ታካ ታ ባጋር ቲናፕ አካኪ በኤዛይፕ ጉየ የ ታርካይ ሀና ሎእꬂ ኔስ ቶፍሎሳስ ጻፋይ ታስ ሎኦ ማቂ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","የይካ፥ ነ ታማሬዝ ባዛይ ቱማ ማቄዛና ኤርሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ይሁዳ ካት ሄሮዶሳ ዎደ አብያ ባጋፕ ማቄዝ ዛክሬሳ ግዝ አይሁደ ቄሳይ የዛ። ኤ ማቻታካ ኣሮና ሼሽፐ። እ ሱንꬃይካ ኤልሳቤጾ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ናምአይካ ጎዳይ ዎጋኔ አዛዛ ኡባ ናጊ ቦርሶ ባይꬅ ጾስ ቲና ጽሎትꬃር የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ኤልሳቤጻ ꬎንꬅ ማቄዝ ግሾ ኡንትስ ናአ ባያ። ናምአይካ ጭሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ፐቲ ጋላስ ዛክሬሳ ፋ ታራር ጾስ ቲና ቄሰትꬃ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ቄሰትꬅ ዎጋር ጾስ ካራ ገሊ እጻኔ ጩይሾዳይስ ኤዛ እጻ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ኤ እጻኔ ጩይሾዳር አሳይ ባለ ኤቂ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ጎዳይ ኪታንቻይ ያርሾ ያርሽዛ አቃይፕ ኡሻች ባጋር ኤቂ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዛክሬሳ ኪታንቻና ብኢ ዳጋሚ ኢታ ያሽቲ ፖኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ዝን ኪታንቻይ ኤኮ፥ «ዛክሬሳ ያሽትፐ፤ ነ ዎሳይ ስንቴዛ። ነ ማቻት ኤልሳቤጻ ꬊራꬅ ናአ የሎዳ፥ ኤ ሱንꬃካ ነ ዋንሳ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ኤ የልንታይ ኔስ ኡፋይስኔ ጊጋ ማቆዳ፤ ጋምታይ ኤ የልንታይድ ኡፋይቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ጎዳይ ቲና ኤ ኡባይፕ ግታ ማቆዳ፤ ዎይነ ኡሺ ማቅን ሀራ ማꬅስዝ ኡሺ ኡዣሚ። ፋ እንዳት ኡሎ የዛር ጌሻ አያናር ኩሞዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","እስሬለ አስታይፕ ጋምታ ኡ ጎዳ ጾሳይኮ ማሆዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","አድታይ ዎዝና ናእታይኮ ማሆዳ፥ ኪትንቶዝታ ጽልታይ ኤጨትꬃይኮ ማሆዳይ ጋርክ፥ ጎዳይስ ቤዝዛ አሳ ጊግሶዳይስ ኤላሳ አያናራኔ ዎልቃር ጎዳይ ቲናር Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዛክሬሳ ኪታንቻይኮ፥ «ታ የያ አባር ኤሮዴ? ታራኔ ታ ማቻትር ጭሜዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ኪታንቻይ ማሂ፥ «ታ ጾስ ቲና ኤቅዛ ጋብሬለ። Ꮊ ምሽራቻ ኔስ ኦዶዳይስ ጾሳፕ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ይኬ፥ ዎዳይ ሄልን ፖልንትዛ ታ ቃላ ነ አማናም እጼዝ ግሾ Ꮊይ ፖልንቶድ ሄሎዳይስ ነ ሙመ ማቆዳ፥ ኦድንቶዳይስካ ዳንዳኣሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","የ ዎደ ዛክሬሳ ጾስ ካራ ገሊ ጋምኤዝ ግሾ አብ ሀኔዛኮ ግ አሳይ ባለ ናግታር ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ኤ ባለ ከዚ ኡንታር ናሾዳይስ ዳንዳኤካያ። ኩሸር ማሊ ቤዞፐ አትን ኦድንቶዳይስ ዳንዳኦዛና ብኢ አቡካ በኤዛይ ጋርክ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ዛክሬሳ ያርሾ ዎዳ ዉርሲ ፋ ካራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","የይፐ ጉየ፥ ኤ ማቻት ኤልሳቤጻ ዎደጼዛ። እችን አግና ሙመ ኬꬃፕ ከዘካዛር ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","እዛ፥ «ጎዳይ ፋ ማሮትꬃይር ታ ቦርንታ አሳይ ጋንጨፕ ቃሮዳይስ ኮዪ Ꮊያ ኦꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ኤልሳቤጻ ዎደጽን ኡሱፑንꬆ አግናር፥ ጾሲ ኪታንቻ ጋብሬለና ጋልላ ቢታ የዝ ናዝረተ ካታማ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ኤዚ ዉድርትኮ ዳዉተ ሼሻፕ ማቄዝ ዮሴፋ ግዝ አꬃይስ ኡሽንቴዝ ማይራምኮ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ኪታንቻይ እዝኮ Ꮊንጊ፥ «ኣꬎ ኬሃትꬃር ኩሜዛኔ፥ ሳሮ ኔስ ማቆ፥ ጾስ ኔር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ማይራማ ኤ ኦዳይድ ኢታ ዳጋሚ፥ «Ꮊይ ዋፋ ሳሮꬆ» ግ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ኪታንቻይ ማሂ፥ «ማይራመ፥ ያሽትፐ፤ ነ ጾስ ቲና ሳባ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ይኬ ነ ዎደጾዳ ꬊራꬅ ናአ የሎዳ፥ ኤ ሱንꬃካ የሱሳ ግ ሱንꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ኤ ግታ ማቆዳ፥ ኡባይፕ ኣꬎ ጾስ ናአ ግንትንቲ ጼግንቶዳ። ጾሳይ ኤ አዳይ ዳዉተ ዙፋና ኤስ እንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ኤ ያይቆባ ሼሻል አፋ መꬍናስ ካዉቶዳ፤ ኤ ካተትꬃይስ ዛዋ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማይራማ ኪታንቻይኮ፥ «ታ ꬊራꬅ ኤሮያ የይ ዋይዚ ሀኖዳይስ ዳንዳኤ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ኪታንቻይ ማሂ፥ «ጌሻ አያና ኔል አፋ ዎꬎዳ፥ ኡባፕ ኣꬎ ጾስ ዎልቃይ ኔል አፋ ኩያቶዳ። የይ ግሾ፥ የልንትዛ ናአይ ጌሻ፥ ጾስ ናአካ ግንትንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ይኬ፥ ነ ዳባት ኤልሳቤጻ ፋ ጭማትꬅ ላይꬃር ꬊራꬅ ናአ ዎደጼዛ። እዛ ꬎንꬅ ግንትንቴዛኖ፥ ዝን Ꮊተ ኡሱፑንꬃ አግና አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ጾሳ ጋምዝባዝ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ማይራማ፥ «ዬዛኮ፥ ታስ ጎዳይ አይላትስ፥ ነ ቃላይ ጋርክ ሀኖ» ዬጌዛ። የይፐ ጉየ፥ ኪታንቻይ ኢፐ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ማይራማ የ ሳምንታተ ደንዲ ይሁዳ ቢታ የዝ ፐቲ ገዘ ካታማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ዛክሬሳ ካራ ገሊ ኤልሳቤጾ ሳሮꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳቤጻ ማይራሚ ሳሮꬃ ስኤዛን ጋርክ እኡሎ የዝ ናአይ ኡፋይሳር ዶንጌዛ። ኤልሳቤጻ ጌሻ አያናር ኩሚ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ፋ ቃላ ꬎቅ ኡዲ፥ «ኔኒ ማችታይ ጋንጨፐ አንጅንቴዛኖ፥ ነ ዎደጼዝ ናአይካ አንጅንቴዛያ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ሀኖ ዝን፥ ታ ጎዳይ እንዳቴ፥ ነ ታኮ የኦዳይስ ታ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ዬዛኮ ነ ሳሮꬃ ታ ስእን ታ ኡሎ የዝ ናአይ ኡፋይሳር ዶንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ጎዳይ ፖሎድ ግ እንጌዝ ቃላ አማኔዛና፥ እዛ አንጅቴዛኖ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማይራማ Ꮊይ ጋርክ ዬጌዛ፦ «ታ ሸምፓታ ጎዳ ቦንቼዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ታ አያናይ ታ ꬋለ ጾሳይል ኡፋይትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ኤ ፋ አይላቲ ካዉሻትꬃ በኤዛ። Ꮊይኖፐ አይኪ የለትꬅ ኡባይ ታና አንጅቴዛኖ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ዎልቃማ ማቄዝ ኤ፥ ታስ ዳማባዝ ኦꬄዛ። ኤ ሱንꬃይካ ጌሻ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ኤዛ ቦንችዝታይል አፋ፥ ኤ ማሮትꬃይ መꬊናፕ መꬍና ሄሎዳይስ የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ፋ ሚንꬅ ቀሳይር ፋ ዎልቃ ቤዜዛ፥ ፋ ዎዝናር ኡትርትዝታ ላሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ዎልቃንꬅዛ ካትታ ኡ ዙፋናይፕ ዎꬍሴዛ፤ ፋና ቶቼዝታ ꬎቅ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ናይንቴዝታ ሎኦ ባዛር ምሼዛ፥ ዱርታ ካሎ ኩሸ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ፋ ማሮትꬃ ቆፒ፥ ፋ አይላ እስሬለ ማዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","የይካ ኑ አድታይስ ኦዴዝ ቃላ፥ አፍራመስኔ ኤ ሼሻይስ ጌዛና መꬍናስ ፖሎዳይሲ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ማይራማ ኤልሳቤጽ ላንቀ ሀይꬒ አግና ጋምኢ ፋ ካራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ኤልሳቤጽስ የሎ ቃማይ ሄልን ꬊራꬅ ናአ የሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","እ ሾርታይኔ እ ዳብታይ ጎዳይ ጋመ ማሮትꬅ ኦꬄዛና ስኢ፥ እዝር ዎላ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ሆስፑንꬃ ጋላስ ዱደ ናአና ዶካሎዳይስ የኤዛ። ናአና አዳይ ሱንꬃይር ዛክሬሳ ግ ጼጎዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ዝን እንዳት፥ «የይ ሀነና ዋንሳ ጊንትንቶዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ኡንትካ፥ «ነ ዳብታይፕ Ꮊ ሱንꬃይር ጼግንቴዛይ ኦንካ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ኤ አዳይ ኦና ግ ሱንꬅ ጋዶዳዛኮ ኤሮዳይስ ኮዢ ኤዛ ማላር ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ኤ ጻፍዛ ባዝ ኦይጪ ኤኪ፥ «ኤ ሱንꬃይ ዋንሳ» ግ ጻፌዛ። ኡባይ ኤ ጻፈዛና ብኢ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","እዝር ዛክሬሳ እራንꬃይ ብልንቴዛ፥ ጾስ ጋላትታር ኦድንቶ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ሾርታይ ኡቢታይ ያሻር ኩሜዛ። Ꮊ ሀኔዝባዛይ ꬎቅ ጌዝ ይሁዳ ጋደ ኡባይድ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","የያ ስኤዝ ኡባይ፥ «Ꮊ ናአይ አብ ሀኖደሻ» ግ ዎል ጋንጨ ኦድንቴዛ። ጎዳይ ኩሻይ ኤዛር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ዋንሳ አዳይ ዛክሬሳ ጌሻ አያናር ኩሚ Ꮊይ ጋርክ ዬጊ ትንቢተ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«እስሬለ ጎዳይ ጾሳይ ጋላትንቶ፥ ይኢ ፋ አሳ ዎዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ፋ አይላይ ዳዉተ ካራ አቶትꬅ ካጨ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","የይካ ብኒ ዎደ ጌሻ ናብታይ ዶናይድ ኦድንቴዛይ ጋርክ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ኤዚ ኑና ኑ ሞርክታይፐኔ ኑር ኤቅንትዛ ኡቢታይ ኩሸፐ አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","የያ ኤ ኦꬄዛይ ኑ አድታይስ ፋ ማሮትꬅ ቤዞዳይስኔ፥ ፋ ጌሻ ጫቃ ናጎዳይስ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ኑ አዳ አፍራመስ ጫቄዝ ጫቃ ቆፖዳይስኔ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ኑ ሞርክታይ ኩሸፕ ከሲ፥ ያሻ ባይꬅ ኤዝስ ኦꬆዳይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ኑ ላይꬅ ኡባይድ ጌሸትꬃራኔ ጽሎትꬃር ፋ ቲና ኑና ኤሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ማ ታ ናአዮ፥ ነ ኡባፕ ኣꬎ ጾስ ናበ ግንትንቶዳ። ጎዳይስ ኦገ ሎይꬆዳይስ ነ ኤ ቲና Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ኡንቲ አቶትꬅ ኤረትꬅ ደማዳና፥ ኡ ናጋራይ አቶ ግንትንትን፥ ነ ጎዳይ ዎያይስ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ኑ ጾሳይ ፋ ኬሃ ማሮትꬃይር ዎንታ ጻልቀ ኑስ ሳሎፕ ከሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","የይካ ꬉማ ጋንጨኔ፥ Ꮊይቆ ኩያ ኦሞ የዝታይስ ፖእሶዳይስ፥ ኑ ቶካካ ሳሮ ኦገኮ ማሆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ናአይካ ድጬዛ፥ አያናራካ ሚንጌዛ፥ እስሬለ አሳይስ በንቶድ ጋꬆ ሊዦ ደምባ የዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","የ ዎደ ኦሮመ ቢታ የዝ አስ ኡቢታይ ታይብንቶድ ጋርከኔ ሱንꬃይ ጻፍንቶድ ጋርክ ካት አዉግስጾሳ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","የይካ ቀረኖሳ ሶረ ቢታ አቅስዛ ዎደ ሀኔዝ ቲና ዎያ ታይባ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","የይ ግሾስ፥ ፐቲ ፐቲ አሲ ፋ ሱንꬅ ጻፍሶዳይስ ፋ የልንቴዝ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ዮሴፋካ ዳዉተ ካራፐኔ ኮቻፕ ማቄዝ ግሾስ ጋልላ ናዝረተ ካታማፕ ደንዲ ዳዉተ ካታማ ግንትዝ ቤተለመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ኤ ኦይጪ ጋዴዝ ዎልቃ ኢታ፥ ማይራምር ዎላ ጻፍንቶዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ኡንትካ ኤዛይድ የዝን ኢስ የሎ ዎደ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ፋ ባይራ ናአ የሌዛ። ቃንጾራ ጻጺ እማꬂ አቅዛ አቆ አቆ ꬋቤዝ ግሾስ መሄ ጋላ ሙዝዝ ጎና ጋንጨ ዎይꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","የ ጋዳይድ ቃማ ዉደ ሄንግታር ቃኤል አቅዝ መሄ ሄንግዝታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ጎዳ ኪታንቻይ ይኢ ኡንትስ በንቴዛ። ጎዳይ ቦንቾ ፖአይ ኡ ላንቃይር ፖኤዛ፤ ኡንትካ ዎልቃማ ያሻ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ኪታንቻይ ኡንትኮ፥ «ያሽትፓተ! ይኬ አስ ኡባይስ ማቅዝ ግታ ኡፋይሳ ምሽራቾ ታ ኤኪ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","የይካ፥ ዳዉተ ካታማ አሽዛይ ይንትስ Ꮊይኖ የልንቴዛ። ኤ ጎዳ ክርስቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","የይስካ ማላይ Ꮊያ። ጽቃ ናአይ ቃንጾር ጻጽንቲ ጎና ጋንጨ ዎይኤዛና ይ ደማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ቆፐካዝን ጋመ ሳሎ ኪታንችታይ ኪታንቻይር ዎላ በንቲ፥ ጾሳ ጋላትታር፥ ");
INSERT INTO mfxe_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ቦንቾ ጾስስ ꬎቀ ሳሎ፥ ሳሮ ቢታል አፋ ጾሲ ቃꬍዛ አሳይስ ማቆ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ኪታንችታይ ኡንታፕ ሻክንቲ ሳሎ ከዜዛይፕ ጉየ መሄ ሄንግዝታይ፥ «አን ጎዳይ ኑስ ቆንጭሴዝ ባዛኔ ሀኔዝ ባዛ በአዳይስ ቤተለመ ዎላ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ኡንትካ ኤልሲ Ꮊንጌዛ። ማይራሞ፥ ዮሴፋ፥ የይፐ ጽቃ ናአይ ጎና ጋንጨ ዎይኤዛ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ብኢ ማቂ ናአይ ባጋ ኡንትስ ኦድንቴዛና የ አቃይድ የዝ አሳይስ ጌሺ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","የያ ስኤዝ ኡባይ መሄ ሄንግዝታይ ኦዴዝ ኦዳ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ማይራማ ሀኔዝባዛ ኡባ ፋ ዎዝናር ቆፕታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","መሄ ሄንግዝታይ ኡንትስ ኦድንቴዛይ ጋርክ ሀንን በኤዛ። የይ ግሾ፥ ኡ ፋ ስኤዝ ባዝስኔ በኤዝ ባዝ ኡባይስ ጾሳ ቦንችታራኔ ጋላትታር ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ሆስፑንꬃ ጋላስ፥ ዶካልንቶዳይስ ቃማ ሄልን፥ ኤዛ ዎደጾዳይፕ ቲና ኪታንቻይ ጋዴዝ ሱንꬃይር የሱሳ ግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ሙሰ ህጋይ ጋርክ ኡንቲ ሻግሸ ዎደ ፖልንቴዛይፕ ጉየ ዮሰፋራኔ ማይራምር ናአ ፋ ጎዳይስ እማዳይስ የሩሳላመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","የይካ፥ ጎዳይ ህጋይድ፥ «ꬊራꬅ ማቄዝ ባይራ ናአ ኡባይ ጎዳይስ ሻክንቴዛ ማቆ» ዬግንቲ ጻፍንቴዛይ ፖሎዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ማ ጎዳይ ህጋይድ፥ ናምኢ ሄሮ ዎይ ሆሌ ጌዛይ ጋርክ ያርሾዳይስ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","የ ዎደ ጌሽኔ አማኖር ሚንꬅ ማቄዝ ስሞና ግንትንትዝ አꬃይ የሩሳላመ የዛ። ኤ እስሬልታይ አቶትꬅ ናግታር የዛ። ጌሻ ኣያናይካ ኤዛል አፋ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ማ ጾሲ ዶሬዝ ክርስቶሳ በኤካዛር Ꮊይቃማና ጌሻ አያናይ ኤስ ቤዝን ኤሪ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ኤዛ የ ጋላስ አያና ካልꬅን ጾስ ካራ Ꮊንጌዛ። አዳይራኔ እንዳትራ ዎጋ ፖሎዳይስ ናአና ኤኪ ገሌዝ ዎደ ");
INSERT INTO mfxe_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ስሞና ሞኪ ኤኪ ናአና እድንጊ፥ ጾሳ ጋላትታር። ");
INSERT INTO mfxe_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ጎዳዮ ነ ታስ ገሌዝ ቃላይ ጋርክ፥ Ꮊተ ነ አይላ ሳሮ ሞይዞባ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ታ ኣፋይ አስ ኡባይ ቲና ነ ጊግሴዝ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ነ አቶትꬃ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","የይካ አይሁደ ባ አስ ኡባይስ፥ ጾስ ቱማትꬅ ቤዝዛ ፖኦ፥ ነ አሳይስ እስራኤልታይስካ ቦንቾ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሰፋራኔ ማይራምራ ኤ ባጋ ኦድንቴዛና ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ስሞና ኡንታን አንጄዛ። እንዳትኮ ማይራምኮ፥ «እስሬለ የዝ ጋምታይስ ኡ ፖክꬃይስኔ ደንዳይስ ጾሳፕ ዶርንቴዛ። ማ እጽዝታይስ ማላ ማቃዳ ");
INSERT INTO mfxe_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ነ ሸምፓይራካ አዛኖ ማሻ ኣꬎዳ» ይኬ ጋመ አሳይ ዎዛና ጌሜዝ ቆፋይ በንቶዳይ ጋርክ የያ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ማ አሴረ ኮቻፕ ማቄዝ ፋኑኤላ ናአታ ሃና ግንትንትዝ ናባታ የዛ። እዛ ኢታ ጭሜዛ፤ እዛ ፋ አዝናይር ላፑን ላይꬅ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","እ አዝናይ Ꮊይቂን ሆስፑን ታማኔ ኦይዲ ላይꬅ ማቆድ ጋꬆ ቃማኔ ጋላስ ፓጨ ባይꬅ ዎሳራኔ ጾማር ጾስ ኬꬃ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","እዛ የ ሳታይድ Ꮊንጊ ጾሳ ጋላቴዛ፤ የሩሳላመ ዎዝንታ ናግዛ ኡባይስ ናአይ ባጋ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ዮሰፋራኔ ማይራምራ ጎዳይ ህጋይድ አዛዝንቴዝ ዎጋ ኡብታ ፖሌዛይፕ ጉየ ጋልላ ቢታ የዝ ፋ ካታማ ናዝረተ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ናአይ ድጭታራኔ አያናር ምንግታር Ꮊንጌዛ። ኤጨትꬃር ኩሜዛ፤ ጾስ ኣꬎ ኬሄትꬃይ ኤዛል አፋ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ዮሰፋራኔ ማይራምር ፋዝቃ ባለ ቦንቾዳይስ ላይꬃር ላይꬃር የሩሳላመ Ꮊንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","የሱሳስ ታጶ ናምኢ ላይꬅ ማቄዝ ዎደ ካሰፕ ኦꬅዛይ ጋርክ ባላ ቦንቾዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ባላ ቦንቼዛይፕ ጉየ ካራ ማቆዳር ናአይ የሱሳ የሩሳላመ አቴዛ። ዝን ዮሰፋራኔ ማይራምር ኤ የሩሳላመ አቴዛና ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ኤ ካራ ማቅዝ አሳይር ዎላ የዛ ኣዝን ኡንቲ ፐቲ ጋላሳ ኦገ Ꮊንጌዛ። ኤ ባዛና ኤሬዛይፕ ጉየ ፋ ዳብታይኔ ፋ ላግታይ ላንቀ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ኤ ኤዛይድ ꬋብን ኮይታር ጉየ የሩሳላመ ሄሎዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ሀይꬒ ጋላሳፕ ጉየ ጾስ ኬꬃ አስታማርታይ ጋንጨ በቲ ኡ ኦድዛና ስእታራኔ ኡንታን ኦይጭታር የዝን ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ኤዛ ስእዝ ኡቢታይ ኤ አካካኔ ኤ ማህዝ ማልሳ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ካራ አሳይ ኤዛ ደንጌዝ ዎደ Ꮊይ ማላባዝ ጌዛ። ኤ እንዳታካ፥ «ታ ናአዮ፥ አብስ ኑና Ꮊይ ጋርክ ኦꬄኔ? ነ አዳይራኔ ታራ ነና ኮይታር ዳቡሬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","የሱሳ ኡንትኮ፥ «ታና አብስ ኮዬ? ታ፥ ታ አዳይ ካራ የዞዳይስ ቤዝዛና ይ ኤሮሳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ዝን ኤ ኡንትኮ ጌዛና ኡንቲ አካኬካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","የይፐ ጉየ፥ ኡንታር ዎላ ናዝረተ ካታማ Ꮊንጌዛ። ኡንትስ ኪትንትታር የዜዛ። ኤ እንዳት የ ኡብታ ፋ ዎዛና ጋዲ ናጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","የሱሳ፥ ኤጨትꬃር፥ ኤቃማር፥ ዴቴር ጾስ ቲናኔ አስ ቲና ድጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ካታይ ጽባሮሳ ኦሮመ ቢታል ካዉትን፥ ታጶ እችንꬆ ላይꬃር፥ ጰንጸ ጵላጾሳ ይሁዳ አቅስዛ ላይꬅ ሄሮዶሳ ጋልላ አቅስዛ ላይꬅ ኤ እሻ ፍልጶሳ ኢጹራሳኔ ጽራኮንዶሳ አቅስዛ ዎደ ልሳኖሳ አብላንሳና አቅስዛ ዎደ ");
INSERT INTO mfxe_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ሃናራኔ ቃያፋራ ቄሰ ሀላቃ ማቂ የዝን፥ ጾስ ቃላይ ዛክሬሳ ናአ ዋንሳኮ ሊዦ ጋꬋ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ዋንሳ፥ «ይ ናጋራይፕ ማቆይታኔ ጻማቅንቶይታ። ጾሳይ ይ ናጋራ አቶ ጎዳ» ዬጊ ታማርስታር ዮርዳኖሳ ቦርካ ሄራ የዝ ቢታ ኡባ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","የይካ ናበ ኢስያሳ ፋ ማጻፋይድ፥ «ሊዦ ጋꬋ ፋ ቃላ ꬎቅ ኡዲ፥ ኡክዛ አꬃይ ቃላይ፥ ‹ጎዳይስ ኦገ ሎእꬆይታ፥ ጎሳካ ፕድ ኡዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ሎጳ ኡቢታይ ኩሞ፥ አምባይኔ ደራይ ዝቂ ጎ። ዎቦ ኦጋይ ሉሎ፥ ጊገካ ጎሳይ ቅንጺ ጎ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","አሾ ማኤዝ አስ ኡብታይ፥ ጾሲ አሽዛና ቦኦ› » ግ ጻፍንቴዛይ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ዋንሳ፥ ኤ ኩሸ ጻማቅንቶዳይስ የኤዝ ጋመ አሳይኮ፥ «ይንታኖ፥ ሾሽ ናኡንꬆ የኦዳይስ የዝ ቦቻይፕ ቡቶድ ጋርክ ይንታን ዞሬዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ይኬ፥ ይ ማቅꬃ ቤዝዛ ሎኦ ኦሶ ኦꬆይታ፥ ይ ዎዝናር፥ ‹ኑስ፥ ኑ አዳይ አፍራመ የዛ ግ ጋይርፓተ።› Ꮊና ስኦይታ፥ Ꮊ ሹችታይፕ ጾሳይ አፍራመስ ናአ ከሶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ዬዛኮ፥ ጋንደ ምንጻይስ ጻጳይድ የዛ። ይኬ፥ ሎኦ ኣፈ ኣፎዋ ምꬅ ኡቢታይ ጋችንቲ ታማ ጋንጨ ዎꬎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","አሳይ፥ «የዝን ኑኒ አብ ኦꬆ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ዋንሳ ማሂ፥ «ናምኢ አፍላ የዛ አሲ ባዛይስ እንጎ። ካꬃ የዛይ ባዛይስ ሻጎ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ቃራጸ ጋችስዝታይ ጻማቅንቶዳይስ ይኢ፥ «አስታማራዮ፥ ኑ አብ ኡዶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ኤ ማሂ፥ «ይንታን ኪቴዛንፕ ኣꬂ ኤክፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ማ ዎታዳርታይ ይኢ፥ «ኑ አብ ኡዶ» ዬጊ ኦይጬዛ። ዋንሳ፥ «ኦባዝካ ዎልቃር ዳፍ ኤክፓተ፥ ኦናካ ዎርዶር ሞትፓተ፥ ይ ዳሞዛይ ይንትስ ግዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","አሳይ ክርስቶሳ ኡፋይሳር ናግታር የዛ ግሾ ዋንሳና፥ «ኤ ክርስቶሳ ማቃደሻ?» ዬጊ ኡ ፋ ዎዝናይድ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዋንሳ ኡብታይስ ማሂ፥ «ታኒ ይንታን ሃꬃር ጻማቅዛ፥ ዝን ታፕ ኣꬊ ዎልቃምዛይ የኦዳ። ታኒ ኤ ጫማይ ዎዶራ ብሎዳይስ ቤዞዋ አሲ። ኤ ይንታን ጌሻ አያናራኔ ታማር ጻማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ዉዱማ የዝ ካꬃ ጌሾዳይስ ፕꬃይ ኤ ኩሻይድ የዛ። ጌዤዝ ካꬃ ፋ ሻላይድ ቆሎዳ፤ ቡናና ꬋቦዋ ታማር ጹጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ማ ዋንሳ አሳ ጋመ ዞረ ዞሪ ዎንግለ ሳባኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ዝን ዋንሳ ሄሮዶሳ ፋ እሻይ ማቻት፥ ሄሮድያዳ፥ ኤኬዝ ግሾኔ ሀራ ኢታ ኦስታ ኦꬄዝ ግሾስ ካጬዝ ዎደ ");
INSERT INTO mfxe_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮዶሳ ካሰሳይል አፋ ሀራ ኢታ ባዝ ኡባ ጉጂ ዋንሳና ዎይነ ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ዎያይ ኡባይ ጻማቅንቴዛይፕ ጉየ፥ የሱሳካ ማ ጻማቅንቴዛ። ኤ ዎሶዳር ሳሎ ዶይንቴዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ጌሻ አያናይ ሆለ ጋርከ ማቂ ኤዛል አፋ ዎꬌዛ። ሳሎፕ «ታኒ ቃꬍዛ ናአይ ነና፤ ነ ታና ኡፋይስዛ ዬግዝ» ቃላ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","የሱሳ ታማርሶ አይኮዳር ኤስ ሀስታም ላይꬅ ዝን፥ አሳይ ኤዛ ዮሴፋ ናአ ግ ቆፔዛ። ዮሴፋ ኤለ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ኤለ ማተ ናአ፥ ማተ ለወ ናአ፥ ለወ ምልካ ናአ፥ ምልካ ዮና ናአ፥ ዮና ዮሴፋ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ዮሴፋ ማታተ ናአ፥ ማታተ አሞጸ ናአ፥ አሞጸ ናሆመ ናአ፥ ናሆመ አስሊመ ናአ፥ አስሊመ ናገ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ናገ ማአተ ናአ፥ ማአተ ማታትየ ናአ፥ ማታትየ ሳማየ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ሳማየ ዮሴፋ ናአ፥ ዮሴፋ ዮዳ ናአ፥ ዮዳ ዮናነ ናአ፥ ዮናነ ራሰ ናአ፥ ራሰ ዘሩባበላ ናአ፥ ዘሩባበላ ሳላትያለ ናአ፥ ሳላትያለ ኔራ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ኔራ ምልካ ናአ፥ ምልካ ሃደ ናአ፥ ሃደ ቆሳመ ናአ፥ ቆሳመ ኤልሞዳኔ ናአ፥ ኤልሞዳኔ ኤረ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ኤረ ዮሴኤ ናአ፥ ዮሴኤ አላዛራ ናአ፥ አላዛረ ዮራመ ናአ፥ ዮራመ ማጻተ ናአ፥ ማጻተ ለወ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ለወ ስሞነ ናአ፥ ስሞና ይሁዳ ናአ፥ ይሁዳ ዮሴፋ ናአ፥ ዮሴፋ ዮናነ ናአ፥ ዮናነ ኤልያቀመ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ኤልያቀመ ማልየ ናአ፥ ማልየ ማይናነ ናአ፥ ማይናነ ማጻተ ናአ፥ ማጻተ ናታነ ናአ፥ ናታነ ዳዉተ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ዳዉተ ኢሳየ ናአ፥ ኢሳየ ኢዮቤደ ናአ፥ ኢዮቤደ ቦኤዛ ናአ፥ ቦኤዛ ሳልሞና ናአ፥ ሳልሞና ናአሶና ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ናአሶና አምናዳባ ናአ፥ አምናዳባ ራመ ናአ፥ ራመ አርና ናአ፥ አርነ አስሮመ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","አስሮመ ፓረሰ ናአ፥ ፓረሰ ይሁዳ ናአ፥ ይሁዳ ያይቆባ ናአ፥ ያይቆባ እሳቃ ናአ፥ ይሳቃ አፍራመ ናአ፥ አፍራመ ታር ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ታር ናኮረ ናአ፥ ናኮረ ሳሩገ ናአ፥ ሳሩገ ረሁ ናአ፥ ረሁ ፋላቃ ናአ፥ ፋላቃ ኤቤራ ናአ፥ ኤቤሮ ሴላ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ሴላ ቃይናመ ናአ፥ ቃይናመ አርፋክሳዳ ናአ፥ አርፋክሳደ ሴመ ናአ፥ ሴመ ኖሄ ናአ፥ ኖሄ ላመ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ላመሄ ማቱሳላ ናአ፥ ማቱሳላ እኖኬ ናአ፥ ሄኖኬ ያረደ ናአ፥ ያረደ ማላልኤላ ናአ፥ ማላልኤላ ቃይናነ ናአ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ቃይናነ ሄኖሳ ናአ፥ ሄኖሰ ሴተ ናአ፥ ሴተ አዳማ ናአ፥ አዳማ ጾስ ናአ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","የሱሳ ጌሻ አያናር ኩሚ ዮርዳኖሳ ቦርካፕ ማቆዳር ጌሻ አያናይ ኤዛ ሊዦ ጋꬋ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ኤዛይድ ኦይታም ጋላስኔ ኦይታም ቃማ ጻላሄር ፓጭንቴዛ። የ ጋላስታ አብካ ሜካዛር ጋምኤዝ ግሾስ ዉርስꬃል ናይንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ጻላሄ ኤዝኮ፥ «ነ ጾስ ናአ ማቅኮ አን Ꮊ ሹቻ ሶሎ ማቆ ግ አዛዞባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","የሱሳ ማሂ፥ «አሲ ጾስ ቃላራፕ አትን ሶሎ ኣዳር የዞያ ግንትንቲ ጌሻ ማጻፋይድ ጻፍንቴዛ» ዬጌዝ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","የይፕ ጉየ፥ ጻላሃይ የሱሳ አዱሰ ደረል አፋ ከሲ Ꮊ አላመ ካተትꬃ ኤልሲ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ጻላሄ፥ «Ꮊ ኡቢታይል ማዉተኔ ቦንቾ ታስ እንግንቴዛ። ታኒ ቃꬌዝ ኦስካ እንግዛ ግሾስ ኔስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","የይ ግሾስ፥ ኔኒ ታስ ጎይንኮ ኡቢታይ ኔስ ማቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","የሱሳ ማሂ፥ «ነ ጎዳ፥ ነ ጾሳይስ፥ ኣዳ ጎይኖባ፥ ኤዛ ኣዳ አጋዞባ ዬግንቲ ጌሻ ማጻፋይድ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ዉርስꬃል ጻላሃይ የሱሳ የሩሳላመ ካንጊ ጾስ ኬꬅስ ኩስተል አፋ ኤሲ፥ «ኔኒ ጾሳ ናአ ማቅኮ አን ሱለ ሳአ ጉፒ ዎꬎባ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","አብስ ጊኮ፥ « ‹ነና ናግዝ ፋ ኪታንችታ፥ ጾሳይ ነ ግሾስ ኪቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ነ ቶካይ ሹቻር ꬉብንታማይ ጋርክ፥ ኡ ፋ ኩሻይር ነና ደንꬆዳ› ዬግንቲ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","የሱሳ ማሂ፥ «ነ ጎዳ ጾሳ ፓጭፐ ግንትንቲ ጌሻ ማጻፋይድ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ጻላሃይ የሱሳ ፓጭታ ኡባ ዉርሴዛይፕ ጉየ ሀራ ጊጋ ዎደ ደማድ ጋꬆ ኤዝፕ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","የሱሳ ጌሻ አያና ዎልቃር ኩሚ ጋልላ ማቄዛ። ኤ ዋራይ ሄራ የዝ ቢታ ኡባይል ስእንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ኤ አይሁድታይ ዎሳ ኬꬃ ገሊ ታማርሴዛ፤ አሲ ኡባይ ኤዛ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","የይፕ ፋ ድጬዝ ካታማ ናዝረተ የኤዛ። ቲን ኦꬅዛይ ጋርክ ማላ ጋላስ አይሁድታይ ዎሳ ኬꬃ ገሌዛ። ናባቦዳይስካ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ናበ ኢሳያሳ ማጻፋይ ኤዝስ እንግንትን፥ ጻꬃ ብሊ፥ Ꮊይ ጋርከ ዬጊ ጻፍንቴዛና ደንጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ጎዳ አያናይ ታል አፋ የዛ፥ ማንቅታይስ ዎንግለ ኦዶድ ጋርክ ጾሳይ ታና ትዤዛ። አጭንቴዝታይስ ብልꬅ፥ ቶእታይ በአድ ጋርክ ኡንእንቴዝታ ብልኦድ ጋርክ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ጾሳይ ኬሆዳይስ ቆፔዝ ላይꬃ ኦዶድ ጋርክ ታና ኪቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","የይፕ ጉየ፥ ማጻፋ ጻጺ አጋዝዛይስ እንጊ በቴዛ። አይሁድታይ ዎሳ ኬꬃ የዛ አሳይ ኡባይ ዳኪ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ኤ፥ «Ꮊይ ይ ሀየር ስእዝ Ꮊ ማጻፈ ቃላይ Ꮊይኖ ፖልንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ኡብታይ ኤ ባጋ ሎኦ ኦድንትዛ። ማ ኤ ዶናፕ ከዝዝ ኣꬎ ኬሃትꬃር ኩሜዝ ቃላር ማላባዝ ጊታር፥ «Ꮊይ ዮሴፋ ናአ ባሳኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ኤ፥ ኡንትኮ « ‹ነኖ ኣክማዮ ነና አሾባ፥ ዬግዝ ኣዝሶ ናሻ ታ ስአሚ የይ ጋርክ ቅፍርናሆመ ነ ኦꬄዝ ባዝ ኑ ስኤዛና ማ Ꮊይዳ ነ ካታማይድ ኦꬆባ› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ማካ ታ፥ «ቱማ ኦድዛ፤ ናበ ፋ የልንቴዝ ቢታ ቦንችንቶያ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«ታ ይንትስ ቱሮ ኦድዛ፤ ናበ ኤላሳ ላይꬅ ሀይꬒ ላይꬅኔ ባጋ ሳሎ ጎርድንትን ኢታ ናየ ቢታ ኡባይል የዝ ዎደ ጋመ አዝኒ ባ ማችታይ እስሬለ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ኤላሳ ኡ ኡብታይስ ኪትንተካያ። ዝን ሰራፕታ ጋደ የዛ አዝኒ ባ ፐቲ አስትኮ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ናበ ኤልሳኤ ዎደ እስሬለ ጋመ ቦርቆንቶ ሀርገር የዝ አሳይ የዛ። ዝን ሶረ አꬃ ንእማነፕ አትን ኦንካ ጌዠካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","አይሁድታይ ዎሳ ኬꬅ የዝ አስ ኡቢታይ የያ ስኤዝ ዎደ ጋመ ካጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ፋ በቴዝ አቃይፕ ደንዲ አምባል አፋ ኬጽንቴዝ ካታማፕ ጋጻ ከሲ ኡርቂ ዳኮዳይስ አምባ ጼራ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ዝን ኤ ኡ ጋንጨር ኣꬊ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ኤዛይፕ ጋልላ ቢታ የዝ ቅፍርናሆመ ካታማ Ꮊንጌዛ። ኤዛይድ ማላ ጋላስ አሳ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ኤ ቃላ ታማርስዛይ ማዉተር የዝ አስ ጋርክ ማቄዝ ግሾስ ኡቢታይ ኤ ትምርታ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","አይሁድታይ ዎሳ ኬꬃ ቱና አያና አይኬዝ አꬃይ የዛ። ኤዚ ፋ ቃላ ꬎቅሲ ኡክታር ");
INSERT INTO mfxe_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«ናዝረተ የሱሳ ኔስ ኑር አቢ የኔ? ኑፕ ሃኮባ፤ ነ የኤዛይ ኑና ꬋብሶዳይሶኔ? ኔኒ ኦናዛኮ ታኒ ኤርዛ። ኔኒ ጾሳፕ የኤዝ ጽላያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","የሱሳ ቱና አያናይኮ፥ «ስኤ ግ Ꮊ አꬃይፕ ከዞባ» ዬጊ ካጬዛ። ቱና አያናይ አꬃ አስ ኡቢታይ ቲና ሾጪ ኦሊ አብካ ቆሄካዛር አሺ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","አስ ኡቢታይ ማላባዝ ግ። ዎልኮ፥ «ሀኖስ፥ Ꮊይ አባ ትምርቴ? ቱና አያንታ ማዉተራኔ ዎልቃር ኪትዛ፤ ኡንትካ ከዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ኤ ዋራይ ሄራ ኡባይል ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","የይፐ ጉየ፥ የሱሳ አይሁድታይ ዎሳ ኬꬃፕ ከዚ ስሞና ካራ ገሌዛ። ስሞና ማቻት እንዳታ ኢታ ኦጸ ምሻ ሀርገር ሀርግንቴዛ። እዞ ፓꬆዳይ ጋርክ የሱሳና ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","እ ሂጻይኮ ሺቂ ዙጊ እ ሀርጋ ካጬዛ። ምሻይ አሽን ኤልሲ ደንዲ ኡንታን ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","አዋ ገሎድ ሀኖዳር ዱማ ዱማ ሀርጋይር አይክንቴዝ አሳ ኤዝኮ ከኤዛ። ኤ ፐታይል ፐታይል አፋ ፋ ኩሻ ጋዲ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ቱና አያንታይ ማ፥ «ኔኒ፥ ጾስ ናአ» ዬጊ ኡክታር ጋመ አሳይፕ ከዜዝ። ዝን ኤ ኡንታን ካጬዛ። ኤ ክርስቶሳ ማቄዛና ኡንቲ ኤርዛ ግሾስ ፐትባዝካ ኦዶድ ጋርክ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ሀጋ ሳአ ዎንቶዳር የሱሳ ፐቲ ጌማ አቆ Ꮊንጌዛ። አሳይ ኮይታር ኤ የዛ አቃ የኤዛ። ኡንታፕ ኤ ሻክንቲ Ꮊንጋም ጋርክ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ዝን ኤ፥ «ታኒ ሀራ ካታምታይድ Ꮊንጊ ጾሳ ካተትꬂ ዎንግለ ማርካቶዳይስ ቤዝዛ። ታ ኪትንቴዛይ የይ ግሾሲ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ይሁዳ ቢታል የዝ አይሁድታይ ዎሳ ኬꬃ ኡባ ዉቲ ሳባኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ፐቲ ጋላስ የሱሳ ገንሳሬጸ አባ ላንቀ ኤቄዝን ጋመ አሳይ ኤ ካንታ ኡኪ፥ ኤ ታማርስዛ ጾሳ ቃላና ስኦዳይስ ኡርቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ኤዛይድ አባይ ጋጻ የዝ ናምኢ ዎጎልታ በኤዛ። ሞሎ አይክዝ አስታይ ዎጎልታይፕ ዎꬊ ፋ ግታ ሜጭዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","የ ዎጎልታይፕ ስሞናረ ገሊ ቢታፕ ጽቃል ገድ አባይ ጋንጨል ሺሾዳይ ጋርክ ኦይጬዛ። ዬዚ፥ የ ዎጎላታይድ በቲ አሳ ዎንግለ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ፋ ታማርሳ ዉርሴዛይፕ ጉየ ስሞናኮ፥ «ገደ ጪማይኮ ሺሺ ሞሎ አይኮዳይስ ይ ግታ ኦሎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ስሞና ማሂ፥ «አስታማራዮ፥ ቃማ ሙዳ ዳቡርታር አቅ አብካ አይከካያ፥ ዝን ነ ጊኮ ነቃላይር ግታ ኑ ኦሎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ኡ ግታ ኦሌዝ ዎደ ግታይ ፔꬊንቶድ ጋꬆ ጋመ ሞሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ሀራ ዎጎሎ ጋንጨ የዝ ፋ ዣምታይ ይኢ፥ ፋና ማዶድ ጋርክ ዉቲ ጼጌዛ። ኡ ይኢ ናምኢ ዎጎልታ፥ ሃꬃይ ጋንጨ ምትንቶድ ጋꬆ ሞሎ ኩንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ስሞን ጵጽሮሳ የያ በኤዝ ዎደ የሱሳ ቲና ጹጉኒ፥ «ጎዳዮ፥ ታኒ ናጋራንቾ አስ ማቄዝ ግሾስ ታፕ ሻክንቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","የያ ኤ ጌዛይ ኤዝኔ ኤዛር የዝታይ አይኬዝ ሞላይ ጋመትꬃይ ማላባዝ ማቄዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ማ ስሞና ዣመ ማቄዝ ዛብዶሳ ናእታይ ያይቆባራኔ ዋንሳራ ማላባዝ ጌዛ። የሱሳ ስሞናኮ፥ «ያሽትፐ! Ꮊንፕ ገድ ኔኒ አስ አይክዝ አስ ማቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ኡ ዎጎልታ ጋጻ ሺሼዛይፕ ጉየ ኡብታ አሺ የሱሳና ካሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","የሱሳ ካታምታይፕ ፐታይድ ማቂ የዝን ፐቲ ቦርቆንቶ ሀርገር አይክንቴዝ አሲ የ ካታማይድ የዛ። የ አꬃይ የሱሳ ብኢ ኤ ቲናይድ ጹጉኒ፥ «ጎዳዮ፥ ነ ሸነ ማቅኮ ታና ጌሾዳይስ ነ ዳንዳእዛ» ግ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","የሱሳ ፋ ኩሻ ዳኪ ቦቺ፥ «ኤ፥ ታ ሸነ፤ ጌዦባ» ዬጌዛ። እዝር አꬃይ ጌዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","የሱሳ፥ «Ꮊያ ኦስካ ኦድፐ፥ ዝን Ꮊንጊ ነናትꬃ ቄሳ ቤዞባ። ነ ጌዤዛይስ ማርካ ማቃዳይ ጋርክ ሙሰ ኪቴዝ ያርሻና ያርሾባ» ግ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ማቆዝን፥ የሱሳ ዋራይ ካሰሳይፕ ኣꬊ ዳልግታር Ꮊንጌዛ። ጋመ አሳይ ኤ ኦድዛ ባዝ ስኦዳይስኔ ፋ ሀርገፕ ፓጾዳይስ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ዝን ኤዚ ኡባ ዎደ ፋ ኣዳስ ጌማ አቆ Ꮊንጊ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ፐቲ ጋላስ የሱሳ ታማርሶዳር ጋልላፐራ ይሁዳ ሄራ ኡባይፐ ማ የሩሳላመፐካ የኤዝ ፈርሳውታይራ ህገ አስታማርታይ ኤዛይድ በቴዛ። አሳ ፓꬅዛ ጎዳይ ዎልቃይካ ኤዛር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","የ ዎደ አሳይ ፐቲ ስላ አስ ሀላር ቶኪ ከኤዛ። ካራ ገልሲ ኤ ቲናይድ ጋዶዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ዝን አስ ዳሮትꬃይፕ ካራ ገልሶዳይስ ጋምንቲ ኬꬃል አፋ ከዚ፥ ሲትንጋ ቃዉጺ፥ ሀርግንቴዝ አꬃ ሀላር አሳ ሻጊ የሱሳ ቲና ዎꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","የሱሳ ኡ አማና ብኢ፥ «ናት አꬃዮ፥ ነ ናጋራይ አቶ ግንትንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ህገ አስታማርታይኔ ፈርሳወ አሳይ፥ «Ꮊይ ጾስ ጫዥዛይ ኦኖ? ፐቲ ጾሳፕ አትን ሀራ ናጋራ አቶ ጎዳይስ ዳንዳእዛይ ኦኖ?» ዬጊ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","የሱሳ ኡ ቆፋ ኤሬዝ ግሾስ ኡንትኮ፥ «ይ ዎዝና ጋንጨ የይ ጋርክ አብስ ቆፔ? ");
INSERT INTO mfxe_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹ነ ናጋራይ ኡጭንቴዛ ግዛይፐነ ደንዲ የꬎባ ግዛይፕ ኣይ ሎኦ?› ");
INSERT INTO mfxe_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ዝን ታ የያ ጌዛይ አስ ናአይ ቢታል አፋ ናጋራ ኡጮዳይስ ማዉተ የዛና ይ ኤሮድ ጋርከ።» የይፕ ማቂ፥ ስላ አꬃይኮ፥ «ደንዲ፤ ነ አርሳ ቶኪ ነ ካራ Ꮊንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ኤ ኤልꬂ ደንዲ ኡ ቲና ኤቄዛ፤ ኤ ቶክንቲ የኤዝ አርሳ ቶኪ ጾሳ ጋላትታር ፋ ካራ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","የ ዎደ ኡቢታይካ ማላባዝ ጌዛ። ጾሳ ጋላትታር፥ «Ꮊይኖ ኑ ዳማ ማላታ በኤዛ» ዬጊ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","የይፕ ጉየ፥ የሱሳ የይፕ ከዚ Ꮊንግታር። ለወ ግንትንትዝ ፐቲ ቃራጸ ጋችስዛይ ቃራጸ ጋችስዛ አቆ በቴዛና ብኢ፥ «ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ኤ ኡባ ባዝ አሺ ደንዲ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","የ ለዋይ ፋ ካራ ዳሞ ስብረ ጊግሴዛ። ጋመ ቃራጸ ጋችሽዝታይኔ ሀራ አሳይ ካꬃ ማዳይስ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፈርሳውታይራ ህገ አስታማርታይ፥ «ቃራጸ ጋችስዝታይራኔ ናጋራ ኦꬅዝታይር አብስ ም ኡዤ?» ዬጊ የሱሳ ታማርታይል ኤዛ ዝግሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","የሱሳ ኡንትኮ፥ «ሀርግንቴዝታይፕ አትን ፓꬅ አስስ አክመ ኮሾያ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ታኒ ናጋራ ኦꬅዝታ ማሮትꬅኮ ማሆዳይስፕ አትን ጌሽታ ጼጎዳይስ የኤካያ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ኡ የሱሳኮ፥ «ዋንሳ ታማርታይ ጋመ ጾምዛ፥ ማ ፈርሳውታይ ታማርታይካ የይ ጋርክ ኦꬅዛ። ዝን ኔስታይ ኡባ ዎደ ሚዛይ ኡዥዛይ አብሶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","የሱሳ ኡንትኮ፥ «ማቾ ኤክዛይ ኡንታር የዝን ላዛንꬅታይ ጾሞዳይ ጋርክ ኦꬆዳይስ ዳንዳእኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ዝን ማቾ ኤክዛይ ኡንታፕ ሻክንቶድ ጋላስ የኦዳ፥ የ ዎደ ኡንቲ ጾሞዳ።» ");
INSERT INTO mfxe_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ማ ዬጊ ኣዝሶ ኦዴዛ፤ «ኦሮꬅ ማኦፕ ፔꬊ ጭማ አፍላል አፋ ስክዛ ኦንካ ባያ። የይ ጋርክ ኦꬅኮ ኦሮꬅ አፍላ ፐርእዛ፥ ኦሮꬃይ ጭማይስ ጊጎያ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ማልአንቶ ዎይነ ጭማ ኦጎሮ ጋንጨ ቡልዝ ኦንካ ባያ። የያ ኦꬅኮ፥ ማልአንቶ ዎይናይ ጭማ ኦጎራ ꬉስዛ፤ ዎይናይ ላልንትዛ ኦጎራይካ አዶያ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","የይ ግሾስ፥ ማልአንቶ ዎይነ ኦሮꬅ ኦጎሮ ጋንጨ ቡልንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ይኬ፥ ካኤዛይ ሎኦ ግዝ ግሾስ ካኦ ዎይነ ኡዢ ማቂ ማልአንቶ ኮይዛይ ኦንካ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ፐቲ ማላ ጋላስ የሱሳ ጋደ ጋንጨር ኣꬍዛ። የሱሳ ታማርታይ ባንጋ ትዣ ዱꬂ ፋ ኩሸር ምርኪ ሚዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ዝን ፈርሳውታይ ጋንጨፕ ፐታይ ፐታይ፥ «ማላ ጋላስ ኦꬆዳይስ ኑ ህጋይድ ቤዞዋ ባዝ አብስ ኦꬄ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","የሱሳ ኡንትኮ ማሂ፥ «ዳዉተ ናይንቴዝ ዎደ ፓር የዝታይራ ዎላ ኦꬅዛና ይ ናባበካሳ? ");
INSERT INTO mfxe_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ጾስ ኬꬃ ገሊ አይሁድታይ ቄስታይ ኣዳስ ቤዝዛ ዳቦ ሜዛ፤ ፓር የዝታይስካ እንጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ማ የሱሳ፥ «አስ ናአይ ማላስ ጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ሀራ ማላ ጋላስ የሱሳ አይሁድታይ ዎሳ ኬꬅ ገሊ ታማርስዛ። የ አቃይድ ኡሻች ኩሸ ስሌዝ ፐቲ አሲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ህገ አስታማርታይኔ ፈርሳወ አሳይ ኤዛ ሞቶዳይስ ሳንከ ኮዢ ማላ ጋላስ ፓꬅኮ በአዳ ግ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ዝን የሱሳ ኡ ቆፋ ኤሪ ኩሻይ ስሌዝ አꬃይኮ፥ «ደንዲ አሳይ ጋንጨ ኤቆባ» ዬጌዛ፥ አꬃይካ ደንዲ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","የሱሳ፥ «አን ታ ይንታን ፐትባዝ ኦይጭዛ፤ ማላ ጋላስ ኦꬆዳይስ ቤዝዛይ ሎኦ ባዞኔ ኢታባዞ? ሸምፖ አሾኔ ꬋብሶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ማ የሱሳ ኤ ላንቃይር የዝ አሳ ኡባ ዩዪ ብኢ አꬃይኮ፥ «ነ ኩሻ ፕድ ኡዶባ» ዬጌዛ፥ አꬃይካ ኤ ጌዛን ጋርክ ኡድን ኩሻይ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ዝን ህገ አስታማርታይኔ ፈርሳወ አሳይ ኢታ ይላꬌዛ። የሱሳል አፋ አብ ኡዶ ግ ዎላ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","የ ዎደ ጋላስታይፕ ፐቲ ጋላስ የሱሳ ዎሶዳይስ ደረል አፋ ከዜዛ። ቃማ ሙዳ ጾሳ ዎስታር አቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ዎንትꬃ ፋ ታማርታ ጼጊ ኡ ጋንጨፕ ታጶ ናምእታ ዶሪ፥ ኡንታን፥ «ሀዋርታ» ግ ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ኡንትካ፥ ጵጽሮሳ ግ ጼግዝ ስሞና፥ ኤ እሻ እንድራሰ፥ ያይቆባ፥ ዋንሳ፥ ፍልጶሳ፥ ባርቶሎሞሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቶሳ፥ ቶማሳ፥ እልፎሳ ናአ ያይቆባ፥ ፋ ቢታይስ ምጭንትዝ ስሞና፥ ");
INSERT INTO mfxe_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያይቆባ ናአ ይሁዳራኔ የሱሳ ኣꬂ እንጌዝ አስቆሮንቶ ይሁዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","የሱሳ ሀዋርታይር ዎላ ደረላፕ ዎꬊ ደንባ አቆ ኤቄዛ። ኤ ታማርታይፕ ጋምታይ የ አቃይድ የዛ። ይሁዳ ቢታ ኡባፐ የሩሳላመፐ፥ ጽሮሳፐኔ ስዶና አባ ጋጻፐ ጋመ አሳይ ኤ ታማርስዛ ባዝ ስኦዳይስኔ ፋ ሀርገፕ ፋጾዳይስ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ቱና አያናር መትንትዛ አስታይካ ይኢ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ፓꬅዛ ዎልቃ ኤዝፕ ከዚ አሲ ኡባ ፓꬅዛ ግሾስ አሳይ ኤዛ ቦቾዳይስ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ፋ ታማርታይኮ ብኢ Ꮊይ ጋርከ ዬጌዛ፦ «ይንታኖ፥ ማንቅታዮ፥ ይ አንጅንቴዝታ፤ ጾስ ካተትꬃይ ይንትሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ይ Ꮊት ናይንትዝታይ አንጅንቴዝታ፥ ይ ምዦዳ። ይ Ꮊት ዬክዝታይ አንጅንቴዝታ ይ ሚጮዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","አሳይ ይንታን ታ ግሾ፥ አስ ናአይ ግሾስ እጽዛ ዎደ ይንታን ፕልዛ ዎደ ይንታን ኡ ቶችዛ ዎደኔ፥ ኢታ ሱንꬅ ኡ ይንትስ እንግዛ ዎደ ይ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«ዬዛኮ፥ ይ ጋታይ ሳሎ ዳማ ማቄዝ ግሾስ የ ዎደ ኡፋይሳር ጉፖይታ። አብስ ጊኮ፥ ብኒ ኡ አድታይ ናብታይል አፋ Ꮊይ ጋርክ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«ዝን ዱርታዮ ይንታን አየ፤ ይ Ꮊት ሎኦ የስ ኤኬዝታ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ꮊት ምዤዝታዮ ይንታን አየ፤ ይ ናይንቶዳ። Ꮊት ሚጭዝታዮ አቦ ይንታኖሾ ይ ካያꬎዳኔ ዬኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","አሲ ኡባይ ይ ሎኦትꬃ ኣዳ ኦድዝ ዎደ ይንታን አየ። ኡ አድታይ ብኒ ዎርዶ ናብታይል አፋ Ꮊይ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«ዝን ታና ስእዝ ይንትስ ታ ኦድዛ፤ ይ ሞርክታ ሲቆይታ፤ ይንታን እጽዝታይስ ሎኦ ባዝ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ይንታን ባድዝታ አንጆይታ፥ ይንታን ናቅዝታይስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ፐቲ ባጋ ሻንጋላ ባቅዝታይስ Ꮊንኮ ባጋካ ቤዞባ። ነ ኮታ ኤኮዳ ግዛይስ ነ ሻምዣካ ጉጂ እንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ነና ዎስዛ ኡባይስ እንጎባ፤ ኔፕ ኤኬዝ ኦናካ ማሆ ግ ኦይጭፐ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","አሳይ ይንትስ ኦꬆድ ጋርክ ይ ኮይዝ ባዝ ኡባ ይንትካ አስስ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«ይ ይንታን ቃꬍዛ አሳ ኣዳ ቃꬍኮ፥ አባ ጋላታ ይንትስ የኔ? ሀራ አቶዝን፥ ናጋራንችታይካ ፋና ሲቅዝታ ሲቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ይንትስ ሎኦ ባዝ ኦꬅዝታይስ ኣዳ ሎኦ ባዝ ኦꬅኮ ይንትስ አባ ጋላታ የኔ? ናጋራንችታይካ Ꮊይ ጋርክ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ታልኤ ማሆድ አስስ ኣዳ ይ ታልእኮ አብ ዱማ ጋላትንትኔ? ናጋራንችታይካ ጉየ ማሆድ አሲ ብኢ ታልእዛ።» ");
INSERT INTO mfxe_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«ዝን ይ ሞርክታ ሲቆይታ፤ ኡንትስ ሎኦ ባዝ ኦꬆይታ። ጉየ ኤኮዳይስ ቆፐካዛር ታልኦይታ። የይድ ይ ኤኮድ ጋታይ ዳማ ማቆዳ። ይ ኡባይፕ ኣꬎ ጾስ ናእታ ማቆዳ። ኤ ፋና ጋላቶዝታይስኔ ኢትታይስካ ኬሃ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ይ አዳይ ማርዛ ማቄዛይ ጋርከ ይንትካ ማርዝታ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«አሳል አፋ ፕርድፓተ፤ ይንታል አፋ ፕርድንታሚ። ይ ቦርንታማይ ጋርክ ኦናካ ቦርፓተ። አቶ ጎይታ፤ ጾሳይ ይንትስ አቶ ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","እንጎይታ፤ ይንትስ እንግንቶዳ። ይ ማኬዝ ባዛር ይንትስ ማሂ ማክንቶዳ፥ ኡባራካ ሎኦ ማክዝ ባዛር ባቂ፥ ሱዲ ኩንꬂ፥ ላልንቶዳር ይንትስ ማክንቲ እንግንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ማካ የሱሳ ዬጊ ኡንትስ ኣዝሶ ኦዴዛ፤ «ቶአይ ቶአ ካልꬆዳይስ ዳንዳእኔ? ካልꬅኮ ናምእታይካ ዎል ኤኪ ጋጋ ቅቶሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ታማራይ አስታማራይፕ ኣꬎያ። ዝን ሎእꬂ ታማሬዝ አꬃይ ፋ አስታማራይ ጋርክ ሀንዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ነ እሻይ ኣፋይድ የዛ ቡጻ አብስ ነ ብእኔ? ነ ኣፋይድ የዛ ቱስ ኣዝዛና አብስ ቦኦሳ? ");
INSERT INTO mfxe_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ነ ኣፋይድ የዛ ቱስ ኣዝዛና በኤካዛር ነ እሻይኮ፥ ‹ታ እሻዮ ነ ኣፋይድ የዝ ቡጻ ከሶ› ጎዳይስ ዋይዚ ዳንዳኤ? ነኖ ጩባዮ፥ ቲናቲ ነ ኣፋይድ የዝ ቱስ ኣዝዛና ከሶባ። የይፕ ጉየ፥ ነ እሻይ ኣፋይድ የዝ ቡጻ ከሶዳይስ ነ ጌሺ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«ሎኦ ምꬂ ኢታ ኣፈ ኣፎያ፤ የይ ጋርከካ ኢታ ምꬂ ሎኦ ኣፈ ኣፎያ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ኣፈ ኣፍዝ ምꬅ ኡባይ ፋ ኣፈር ኤርንትዛ። አንጉꬅፐ ባላሰ ኣፈ ማጽንቶያ ማ ጎምኦረፐ ዎይነ ኣፋይ ማጽንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ሎኦ አስ ፋ ዎዛና ጋንጨ ኩሜዝ ሎኦ ባዛፕ ሎኦ ባዝ ከስዛ። ኢታ አሲ ፋ ዎዝናይድ ኩሜዝ ኢታ ባዛፕ ኢታ ባዝ ከስዛ። አሲ ፋ ዎዝና ኩሚ ፉጬዛይፕ ፋ ዶናር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ታ ግዛና ኦꬆዋዛር፥ አብስ ታና፥ ‹ጎዳዮ፥ ጎዳዮ፥ ጌ?› ");
INSERT INTO mfxe_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ታኮ ይእዛይኔ ታ ቃላ ስኢ ፖልዛ ኡቢታይ ኦና ኣዝዛኮ ታ ይንታን ቤሳዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ኤ ኬꬅ ኬጾዳይስ ዎꬍሲ፥ ኦላ ቦኪ፥ ኦሞ የዝ ዛላይል አፋ ኬꬅ ኤሴዝ ኤጫ አꬃ ኣዝዛ። ድኦ ድኢ የ ኬꬃ ኡርቄዛ፥ ዝን ሚንꬂ ኬጼዝ ግሾስ ኤንኦዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ዝን ታ ቃላ ስኢ ኦꬆዛይ ፋ ኬꬃ ሻፈል አፋ ኬጼዝ አꬃ ኣዝዛ። ድኦ ድኢ የ ኬꬃ ኡርቄዝ ዎደ ኤልሲ ዎዴዛ። የ ኬꬃይ ዎድꬃይካ ዎልቃማ ማቄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","የሱሳ የያ ኡባ አስ ቲና ታማርሲ ዉርሴዛይፕ ጉየ፥ ቅፍርናሆማ ካታማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","የ አቃይድ ፐቲ ማቶ ሀላቃይ የዛ። ኤ ጋመ ቃꬍዛ አይላይ ሀርግንቲ Ꮊይቆስ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ኤ የሱሳ ባጋ ስኤዝ ዎደ ፋ አይላ ፓꬆዳይ ጋርክ ኤዛ ዎሶ ግ አይሁድታይ ጭምታ የሱሳኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ኪትንቴዝታይ፥ የሱሳኮ Ꮊንጊ፥ «ነ ኤስ Ꮊያ ኦꬆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","አብስ ጊኮ፥ Ꮊ አꬃይ ኑ አሳ ቃꬍዛ፥ አይሁድታይስ ዎሳ ኬꬃካ ኬጼዛ» ግ ሚንꬂ ዎሴዛ ");
INSERT INTO mfxe_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","የሱሳካ ኡንታር Ꮊንጌዛ። ማቶ ሀላቃይ ካራኮ ኡኮዳር ፋ ላግታ ኤዝኮ ኪቲ፥ «ጎዳዮ፥ ታ ኬꬃይድ ነ ገሎዳይስ ታስ ቤዘካ ግሾስ ዳቡርፐ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ታካ ታና ነ ቲና ሺቆዳይስ ቤዝዛ አስ ግ ቆፖያ። ዝን ነ Ꮊን እዘ ኤቂ ፐቲ ቃላ ኦዶባ፤ ታ አይላይ ፓጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ታስ ታፕ አፋር ሀላቃይ የዛ፥ ታፕ ኦሞር ታ ኪትዛ ዎታዳርታይ የዛ። ፐታ፥ ‹ቅቶባ› ጊኮ ቅትዛ፥ Ꮊንካ፥ ‹Ꮊና የኦባ› ጊኮ ይእዛ። ታ አይላይኮ፥ ‹Ꮊኖ ኦꬆባ› ጊኮ ኦꬅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","የሱሳ የያ ስኤዝ ዎደ ማላባዝ ጌዛ። ጉየ ማቂ Ꮊንጊ አሳይኮ፥ «ታ ይንትስ ቱሮ ኦድዛ፤ ሀራ አቶዝን አስራኤለ ጋንጨካ Ꮊይ ጋርክ ግታ አማኖ ታ ደንገካ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ኪትንቴዝታይ ካራ ማቃዳር አይላይ ፓጽን ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ዎንትꬃ ጋላስ የሱሳ ናይነ ካታማ Ꮊንጌዛ። ኤ ታማርታይራኔ ሀራ ጋመ አሳይ ኤዛር Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ኤ ካታማ ገሎድ ሀኖዳር አሃ ቶኬዝ ጋመ አሳይ ካታማፕ ከዜዝ። Ꮊይቄዝ ናአይ ፋ እንዳትስ ፐቶ፥ እዛካ አምኦ። ካታማ አሳይፕ ጋምታይ እዝር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ጎዳይ እዞ ብኢ ቃꬊንቲ፥ «ዬክፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ሺቂ ሀላ ቦችን ቶኬዝ አሳይ ኤቄዛ። የሱሳ፥ «ናት፥ የላጋዮ ደንዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ꮊይቄዛይ ደንዲ በቲ ናሻ አይኬዛ። የሱሳ ናአ ደንꬂ እንዳትስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","አስ ኡቢታይ ያሽቲ፥ «ኡባፕ ኣꬍዝ ናበ ኑ ጋንጨ ደንዴዛ፤ ጾሳይ ፋ አስታ በኤዛ» ዬጊ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ኤ ዋራይ ይሁዳንነ የ ሄራይድ የዝ ቢታ ኡባይል ስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ጻማቅዛ ዋንሳ ታማርታይ የያ ኡብታ ዋንሳስ ኦዴዛ። ኤ ኡ ጋንጨፕ ናምእታ ጼጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«የኦድ ጊንትንቴዛይ ነናኔ? ዎይ ሀራ ናጎ?» ዬጊ ኦይጮይታ ግ ጎዳይኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","አሳይ የሱሳኮ Ꮊንጊ፥ ጻማቅዛ ዋንሳ፥ «የኦድ ጊንትንቴዛይ ማሳይ ነናኔ? ዎይ ሀራ ኑ ናጎ?» ጎይታ ግ ኑና ኔኮ ኪቴዛ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","የ ሳታተ የሱሳ ጋመ አሳ ሀርገፕ ፓꬄዛ። ቱና አያንታ ከሴዛ፥ ጋመ ቶኤዝ አስ ኣፍታካ ብእሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ዋንሳ ካንታፕ ኪትንቲ የኤዝታይኮ፥ «Ꮊንጊ ይ በኤዛናኔ ስኤዛና ዋንሳስ ኦዶይታ። ኣፈ ቶእታይ ብእዛ፥ ጉንድታይ ብልእንቲ የꬍዛ፥ ቦርቆንቶር የዝታይ ጌዥዛ፥ ቱልታይ ስእዛ፥ Ꮊይቄዝታይ Ꮊይቆፕ ደንድዛ፥ ማንቅታይስ ዎንግላይ ሳባክንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ታል ꬉብንቶዋ ኦንካ አንጅንቴዛያ።» ");
INSERT INTO mfxe_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ዋንሳ ኪቴዝታይ Ꮊንጌዛይፕ ጉየ የሱሳ ዎያይስ ዋንሳ ባጋ ዬጊ ኦዴዛ፦ «ይ አብ በአዳይስ ሊዦ ከዜኔ? ጫርኮ ኤንእስዛ ማቃ በአዳይሶኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","የዝን፥ አብ በአዳይስ ከዜኔ? ቦንቾ አፍላ ማኤዝ አሳ በአዳይስነ? ቦንቾ አፍላ ማኤዝታይኔ ሳአ ጊጌዝ አሳይ ካት ኬꬃ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","የዝን፥ አብ በአዳይስ ከዜኔ? ናበ በአዳይሶኔ? ኤ፥ ታ ዬግዛ፦ ይ በአዳይስ ከዜዛይ ናበፕ ኣꬍዛና። ");
INSERT INTO mfxe_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","«‹ነ ኦገ ነ ቲና ጊግስዛ ታ ኪታንቻ ኔፕ ቲና ታ ኪቶዳ› ዬግንቲ ጻፍንቴዛይ Ꮊይስ ኤዝሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ታ ይንትስ ኦድዛ፤ ማቻፕ የልንቴዝታይ ጋንጨፕ ዋንሳፕ ኣꬍዛይ ባያ። ጾስ ካተትትꬃ ኡባፕ ጽቅዛይ፥ ኤ ኡባፕ ዳማ ማቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ሀራ አቶዝን፥ የሱሳ ቃላ ስኤዝ ቃራጸ ጋችዝታይኔ አስ ኡባይ ዋንሳ ኩሸ ጻማቅንቴዝታይ ጾሳይ ጌሽ ማቅዛ ቆንጭሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ዝን ፈርሳውታይኔ ህገ አስታማርታይ ዋንሳ ኩሸ ጻማቅንታም እጺ ጾስ ቆፋ ለቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","የሱሳ ማቂ Ꮊይ ጋርከ ዬጌዛ፦ «ይኬ፥ Ꮊ ዎደ የለትꬃ አባር ኣዝሶዴ? ኡንትካ ኦና ኣዜ? ");
INSERT INTO mfxe_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ጋበ ጋንጨ በቲ ዎል ጼጊ፥ ‹ኑ ይንትስ እምፕልተ ፑግን፥ ይ የጾያ። ኑ ሳቢ ዘላልን፥ ይ ዬኮያ› ዬግዝ ናእታ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ጻማቅዛ ዋንሳ ሶሎ ሜካዛራኔ ዎይነ ኡዠካዛር ይእን፥ ‹ኢታ አያናይር የዛ ይ ጌዛ።› ");
INSERT INTO mfxe_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","አስ ናአይ ሚታራኔ ኡዥታር ይእን፥ Ꮊ አꬃይ ‹ዥንባራኔ ኡሺ ዶስዛ፥ ቃራጸ ጋችስዝታኔ ናጋራ ኦꬅዝታይ ዳቦ› ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ኤጨትꬂ ቱሮ ማቅዛይ ፋ ናአትራ ኤርንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ፈርሳውታይፕ ፐታይ የሱሳ ካꬃ ሙዞዳይስ ፋ ካራ ጼጌዛ። ኤ ፈርሳዋይ ካራ Ꮊንጊ ሌማተል አፋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","የ ካታማ ጋንጨ ፐቲ ናጋራንቾ ማች የዛና የሱሳ ፈርሳዋይ ካራ ስብረል አፋ የዛና ስኤዝ ዎደ ሎእꬂ አልኦ አልባስጽሮሳ ብልጋጸ ሽቶ ኤኪ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","የሱሳስ ጉየ ባጋር፥ ኤ ቶካይ ካለ ኤቂ ዬክታር ኤ ቶካ ፋ አፉꬃር ላክꬄዛ። ፋ ብናናይር ኤ ቶካ ኡጭታራኔ ዬርታር ሽቶ ትዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ስብራና ማኬዝ ፈርሳዋይ የያ ብኢ ፋ ዎዝናር፥ «Ꮊይ ናበ ማቄዛኮ Ꮊ አስታ ኤዛ ቦችዛና ኦናዛኮ ማ እዛ ዋፋ ናጋራንቾ ማቄዛኮ ኤ ኤሮዳዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","የሱሳ፥ «ስሞና፥ ታ ኔስ ኦድዛ ባዝ የዛ» ዬጌዛ። ኤ፥ «አስታማራዮ፥ ታስ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","የሱሳ ኤዝኮ፥ «ናምኢ አሳይ ፔቲ አꬃይፕ ሚሸ ታልኤዛ። ፐታይ እችን ጼት ድናረ Ꮊንካይ ማ እሻታም ድናረ ታልኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ናምእታይካ ታልኤ ጭጎዳይስ ጋምንትን፥ ናምእታይስካ ታልኤዛና ማሬዛ። ይኬ፥ Ꮊ ናምእታይፕ የ አꬃ ሎእꬂ ዶሶዳይ ኔስ ኣያ ኣዜ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ስሞና፥ «ጋመ አጮ ማርንቴዝ አꬃይ ጋመ ቃꬎዳ ኣዝዛ» ዬጌዛ። የሱሳ፥ «ነ ቱማ ፕርዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","የይፐ ጉየ፥ የሱሳ አስትኮ ማቂ ብኢ፥ ስሞናኮ፥ «Ꮊኖ አስቶ ነ ብእኔ? ታኒ ነ ካራ ገልን ሀራ አትን ነ ታስ ቶኬ ሃꬅ እንገካያ፥ ዝን እዛ ታ ቶካ ፋ አፉꬃር ላክꬂ ፋ ብናናይር ኡጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ነ ታና ዬሪ ኤከካያ፥ ዝን እዛ ታ ነ ካራ ገሌዛይፕ አይኪ ታ ቶኬ ዬሮ አሸካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ኔኒ ታ ኦማይል ዛይተ ትዠካያ፥ ዝን እዛ ታ ቶካ ሽቶ ትዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","እዛ ታና ጋመ ቃꬌዝ ግሾስ እ ጋመ ናጋራይ አቶ ግንትንቴዛ። ኤ ጽቃ ናጋራይ አቶ ጊንትንቴዛይ ጽቃል ቃꬌዛ።» ");
INSERT INTO mfxe_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","የሱሳ አስትኮ፥ «ነ ናጋራይ አቶ ግንትንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ኤዛር ዎላ በቲ ሚዝታይ፥ «ናጋራ አቶ ዬግዛይ፥ ኤ Ꮊይ ኦኖ?» ዬጊ ፋ ዎዝናር ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","የሱሳ አስትኮ፥ «ነ አማናይ ነና አሼዛ፤ ሳሮ ቅቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","የይፐ ጉየ፥ የሱሳ ጾሳ ካተትꬂ ዎንግለ ሳባክታር ካታማራኔ ሄራር ኣꬌዛ። የ ዎደ ታጶ ናምእታይ ኤዛር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ማ ቱና አያናፐኔ ዱማ ዱማ ሀርገፕ ፓጼዝ ፐቲ ፐቲ ማችታይ ኤዛር የዛ። ኡንትካ፥ ላፑን ቱና አያንታይ ከዜዝ ማግዴላ ማይራሞ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ሄሮዶሳ ሹማይ ኩዛ ማቻት ዮሃና፥ ሶስናራኔ ማ ሀራ ጋምታይ ኡንታን ሚሸር ማድዝታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ጋመ አሳይ ዱማ ዱማ ካታማፕ ኤዝኮ ሺቅን ኣዝሶር ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«ፐቲ ቢታ ኦꬂ አቅዛይ ዘርꬅ ዘሮዳይስ ከዜዝ። ኤ ዘሮዳር ፐቲ ፐቲ ዘርꬃይ ኦገል ዎꬊ የꬍንቴዛ፥ ሳሎ ካፍታይ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ꮊንክታይ ስስንቆ ኦሞር የዛ ቢታል አፋ ዎꬌዛ። ሀጋ ዶሌዛኒ ጋርክ ቢታይ ላኮ ባዛይ ግሾስ ሚጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ሀራ ዘርꬃይ ማ አንጉንꬅ ጋንጨ ዎꬌዛ። አጉንꬃር ዎላ ድጬዝ ግሾስ አንጉꬃይ ጩሊ አቃይድ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ꮊንክታይ ሎኦ ቢታል አፋ ዎꬌዛ። ዶሌዝ ዎደ ጼት ኩሸ ኣፌዛ።» የያ ኦዲ ሃሲ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ስእዝ ሀየ ዬዚ ኡቢታይ ስኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ኤ ታማርታይ፥ «Ꮊ ኣዝሳይስ ብርሽꬃይ አባ?» ዬጊ ኦይጬዛ ");
INSERT INTO mfxe_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ኤ፥ «ጾሳ ካተትꬃ ጹራ ባዝ ኤሮድ ጋርክ ይንትስ እንግንቴዛ። ዝን ሀራ አሳይ ብእታር ደንጋም ጋርክ፥ ስእታር አካካማይ ጋርክ ኣዝሶር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«ይኬ፥ Ꮊ ኣዝሳይስ ብርሽꬃይ Ꮊይ፦ ዘርꬅ ዬግንቴዛይ ጾስ ቃላ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ኦገ ጋጻ ዎꬌዝ ዘርꬃይ ቃላ ስእዝታ። ማቆዝን፥ ኡንቲ አማኒ አታም ጋርክ ጻላሃይ ቃላ ኡ ዎዝናይፕ ማጺ ሃስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ስስልቆ የዝ ቢታል አፋ ዎꬌዝ ዘርꬃይ ቃላ ስኢ ኡፋይሳር ኤክዝታ። ኡ Ꮊተስ አማንዛፕ አትን ጻጶ ባ ግሾስ ፓጨ ሄልዛ ዎደ ኤልሲ ካድዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","አንጉꬅ ጋንጨ ዘርንቴዝታይ ቃላ ስእዝታ። ኡንትካ አላመ ቆፋር፥ ዱረትꬃራኔ ሳአ የስ ሀንን ጩልንቲ ቤዝዛይ ጋርክ ኣፈካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ሎኦ ቢታል ዎꬌዝ ዘርꬃይ ሎኦኔ ሉለ ዎዝናር ቃላ ስኢ ናግዝታኔ ዳንዳአር ሚንጊ ኣፈ ኣፍዝታ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«ጾምፐ ጾምፒ፥ ኦታ ጋንጨ ዎይ አርሳፕ ኦሞር ጋድዛይ ባያ። ገልዛ አሲ በአድ ጋርክ ꬎቀ አቆ ጋድዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«የይ ግሾስ፥ ቆስንቴዛይ ፕ ከዘካዛር፥ ካምንቴዝ ባዝ፥ በንተካዛር አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«ይኬ፥ ይ ቃላ ዋይዚ ስእዛኮ ናግንቶይታ። የዛ ኡባይስ ጉዥንቲ እንግንቶዳ፥ ባዛይስ ሀራ አቶዝን ኤዝስ የዛ ጽቃታካ ኤዛፕ ኤክንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","የሱሳ እንዳትራኔ እሽታይራ ኤዝኮ የኤዛ። ዝን አስታይ ጋመትꬃይፕ ደንዴዛይድ ኤዛ ደንጎዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ፐቲ አሲ የሱሳኮ፥ «ነ እንዳትራ ነ እሽታይራ ነና ኮዪ ባለ ናግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","የሱሳ ማሂ፥ «ጾስ ቃላ ስኢ ኦሶል ፔሽዝታይ ኡባይ ታስ እንዶኔ ታስ እሸ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ፐቲ ጋላስ የሱሳራኔ ኤ ታማርታይራ ዎላ ዎጎሎ ጋንጨ ገሊ፥ «አባ ፒንጎዳ» ዬጌዛ። ኡንትካ Ꮊማዳይስ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","አባል አፋር ኡንቲ ፒንጎዳይስ Ꮊማዳር የሱሳ ገንቴዛ። ቆፐካዝን ዎልቃማ ጫርኮ አባል አፋ ደንዴዛ። ሃꬃይ ዎጎሎ ጋንጨ ገልን ዎጎላይ ምትንቶ አይክን ኡባይ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ኤ ታማርታይ ኤዝኮ ሺቂ፥ «ኑ ጎዳዮ፥ ኑ ꬋቦሆ ዬጊ» የሱሳ ደንꬄዛ። የሱሳ ደንዲ ጫርካኔ ጎታ ሴሬዛ። ኤልሲ ጫርካይኔ ጎታይ ሀይዚ ጭጭርክ ጌዛ። ሳሮትꬃይካ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","የሱሳ ፋ ታማርታይኮ፥ «ይ አማናይ አባ የኔ» ዬጌዛ። ኡንትካ፥ ያሽትታራኔ ማላባዝ ጊታር ፐታይ ፐታይኮ፥ «ጫርኮኔ ሃꬂ አዛዝንትዛይ፥ ኤ Ꮊይ ኦኖ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","አባ ፒንጊ ጋልላ ባጋር የዝ ገርገሶነ ቢታ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","የሱሳ ዎጎሎፕ ከዚ ሳአ ዎꬎዳር ቱና አያናር አይክንቴዝ አꬃይ ካታምትፕ ከዚ ኤዛ ሄሌዛ። ጋመ ላይꬅ አፍላ ማኤካዛር ካሎ ዱፎ ጋንጨ የዛይፕ አትን ካራ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","የሱሳና በኤዝ ዎደ ኤ ቲናይድ ጹጉኒ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ኡባፕ ኣꬎ ጾስ ናአ የሱሳ ኔር ታስ አባ ፐትፐተꬅ የኔ? ሀያና ታና Ꮊት ብጽስፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","የይ ኤ ጌዛይ፥ ቱና አያናይ አꬃይፕ ከዞዳይ ጋርክ የሱሳ ካጬዝ ግሾስ። ጋመ ዎደ ቱና አያናይ ኤዛ ሞዴዝ ግሾስ ሳንꬃላተራኔ ቶኬ አጭዝ ብራታር አጭንቲ ናግንትዛ። ዝን አቻ ዱꬂ ቱና አያናር ላግንቲ ሊዦ ገልዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","የሱሳ፥ «ነ ሱንꬃይ ኦኖ?» ዬጊ ኦይጬዛ። ኤ፥ ጋመ ቱና አያንታይ ኤዛ አይኬዝ ግሾስ ፋና፥ «ሌጎና» ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ቱና አያንታይ ፋና ጪሞ ኪታም ጋርክ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","የ አቃይድ ደረል አፋ ሚዝ ጉዳይለ ዉደ ሄንግንትዛ። Ꮊ ጉዳይልታይል ኑ ገሎ ግ ዎሴዛ፥ ኤዝካ «ገሎይታ» ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ቱና አያንታይ አꬃይፕ ከዚ ጉዳይልታይል ገሌዛ። ዉዳይ ደረላፕ ሱለ ጉርጉጺ አባ ጋንጨ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ሄንግዝታይ ሀኔዛና ብኢ ዎጺ Ꮊንጊ፥ ካታማኔ ሄራ ኡባይል ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","አሳይ ሀኔዝባዛ በአዳይስ ከዚ የሱሳኮ የኤዛ። ቱና አያናይ ከዜዝ አꬃይ አፍላ ማኢ፥ ኤ ዎዝናይ ማቅን፥ የሱሳ ቶኬ ካለ በቴዛና ደንጊ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ኤዛ በኤዝ አሳይ ቱና አያናር አይክንቴዝ አꬃይ ዋይዚ ፓጼዛኮ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ገርገሶነ ላንቃይድ የዝ አሳይ ጋመ ያሻ ያሽቲ የሱሳ ፋ ጋዳይፕ Ꮊንጎድ ጋርክ ዎሴዛ። ኤ ዎጎሎ ጋንጨ ገሊ ጉየ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ቱና አያናይ ከዜዝ አꬃይ የሱሳር የዞዳይስ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ዝን የሱሳ ኤዝኮ፥ «ነ ካራ ማቆባ፥ ጾሳይ አብ ጋርክ ዳማባዝ ኔስ ኦꬄዛኮ ኦዶባ» ዬጊ ሞይዜዛ። አꬃይካ የሱሳ አብ ጋርክ ዳማባዝ ኤዝስ ኦꬄዛኮ ካታማ ኡባይድ ማርካትታር ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","አሳይ ናጊ ጋምኤዝ ግሾስ የሱሳ ማቅዝ ዎደ ሞኪ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","አይሁድታይ ዎሳ ኬꬅ ሀላቃ ማቄዝ ኢያሮሳ ግዝ አꬃይ ፋ ካራ የኦድ ጋርክ የሱሳ ቶካይል አፋ ዎꬊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ኤስ ታጶ ናምኢ ላይꬅ ማቄዝ ፐቲ ማች ናአ የዛና ሀርግንቲ Ꮊይቆስ ሄሊ የዛ። የሱሳ Ꮊንጎዳር አሳይ ኤዛ ኡንእꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ታጶ ናምኢ ላይꬅ ሱꬂ ጎግታር ጋምኤዝ አስታ የዛ። እዛ ፓስ ዬዚ ሻላ ኡባ አክምታይስ እንጊ ዉርሴዛ። ዝን ፓጾዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","እዛ የሱሳስ ጉየ ባጋር ሺቂ፥ ኤ አፍላ ማንቻቶ ቦቼዛ፥ እዝራ ጎግዝ ሱꬃይ ኤቂ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","የሱሳ፥ «ታና ቦቼዛይ ኦኖ?» ዬጌዛ። ኡባይ «ኑ ቦቼካያ» ዬግን፥ ጵጽሮሳ፥ «አስታማራዮ፥ ጋመ አሳይ ካሎዳራኔ ኡርቅꬆዳር ብእታር ዋይዚ፥ ‹ታና ቦቼዛይ ኦኖ?› ጌ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ዝን የሱሳ፥ «ፐቲ አሲ ታና ቦቼዛ፤ አብስ ጊኮ፥ ዎልቃ ታፕ ከዜዛይ ታስ ኤርንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","የ አስታ፥ እባዝ ቆስንተካዛና ኤሪ ኩኩርታር ይኢ የሱሳ ቶካይል አፋ ዎꬌዛ። አብስ ቦቼዛኮኔ ዋይዚ ኤልሲ ፓጼዛኮ አስ ኡቢታይ ቲና ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ኤ፥ «ታ ናአተ፥ ነ አማናይ ነና ፓꬄዛ፤ ሳሮ ቅቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","የሱሳ ናሻ ዉርሰካዝን፥ አይሁድታይ ዎሳ ኬꬅ ሀላቃይ፥ ኢያሮሳ ካራፕ ፐቲ አሲ ይኢ፥ «ኢያሮሳ፥ ነ ናአታ Ꮊይቄዛ፤ ይኬ አስታማራ ጨረ ዳቡርስፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ዝን የሱሳ የያ ስኢ ኢያሮሳኮ፥ «ያሽትፐ! አማኖባፕ አትን፥ ነ ናአታ ፓጾዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","የሱሳ ኢያሮሳ ካራ ሄሌዛን ጋርክ ጵጽሮሳ፥ ዋንሳ፥ ያይቆባ፥ ናአቲ አዳይፐኔ እንዳትፐ አትን ሀራ አስ ገሎድ ጋርክ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","የ አቃይድ የዝ አሳይ ኡቢታይ ናአትስ ዎ ዎ ግ ዬኮዳር፥ የሱሳ፥ «ዬክፓተ! ናአታ ገንቴዛፕ አትን Ꮊይቀካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","አሳይ ናአታ Ꮊይቄዛና ኤርዛ ግሾስ ኤ ኦዳ ለቂ ሚጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ዝን የሱሳ ናአቲ ኩሻ አይኪ፥ «ቡሽተ ደንዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ናአትስ ሸምፓይ ማቅን ኤልሲ ፑꬁክ ግ ደንዲ ኤቄዛ። የሱሳ ኡንትኮ፥ «እዝስ ሚዝባዝ እንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ናአቲ አዳይራኔ እንዳትር ማላባዝ ጌዛ። ዝን የሱሳ Ꮊያ፥ «ኦስካ ኦድፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","የሱሳ ታጶ ናምኢ ሀዋርታ ፋኮ ጼጊ፥ ቱና አያንታ ከሶድ ጋርከኔ ሀርገ ኡባ ፓꬆዳይ ጋርክ ዎልቃኔ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ጾስ ካተትꬂ ባዝ ማርካቶድ ጋርክ ሀርግንቴዝታ ፓꬆዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ኤ ኡንትኮ፥ «ጉፈ ማቅን ቁርቦ ማቅን ካꬃ ማቅን ሚሸ ማቅን ላሚ ማእዛ አፍላ ማቅን ኦገስ ግ አብካ አይክፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","የ ካታማፕ ይ ከዞድ ጋꬆ እማꬄትꬃር ይ ገሌዝ አቆ ጋምኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ኦንካ ይንታን ሞካም እጽኮ የ ካታማፕ ከዝታር ኡንትስ ኤርስዛ ማርካ ማቃዳይ ጋርክ ይ ቶኬ የዝ ቡልአ ፕቲ ከዞይታ።» ");
INSERT INTO mfxe_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ኡንትካ ኪትንቴዛይ ጋርክ ከዚ ዎንግለ ኦድታር ዱማ ዱማ ሄራ ሀርግንቴዝታ ፓꬅታር ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ጋልላ ቢታ አቅስዛ ሄሮዶሳ የሱሳ ኦꬄዝ ባዝ ኡባ ስኢ ዳጋሜዛ። አብስ ጊኮ፥ ፐቲ ፐቲ አሳይ ዋንሳ Ꮊይቆፕ ደንደካ አተና ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ባግታይ፥ «ኤላሳ በንቴዛ» ግዛ፤ Ꮊንክታይ ማ፥ «ብኒ ናብታይፕ ፐታይ Ꮊይቆፕ ደንዴዛ» ዬጊ ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ዝን ሄሮዶሳ፥ «ዋንሳ ቆ ታ ጋችሲ ዎꬌዛ። የዝን፥ Ꮊይ ጋርክ ዬግንቲ ኤ ባጋ ኦድንትዛይ፥ ኤ ኦኖ?» ዬጊ የሱሳና ፋ ኣፈር በአዳይስ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ታጶ ናምኢ ሀዋርታይ ጉየ ማቂ ይኢ፥ ኡንቲ ኦꬄዝ ባዝ ኡባ የሱሳስ ኦዴዛ። ኤ ኡንታን ኤኪ ቤተሳይዳ ካታማ ላንቀ የዝ አቆ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ዝን ጋመ አሳይ የሱሳ ማቄዛና ኤሪ ኤዛ ካሌዛ። ኤ ኡንታን ሞኪ ኤኪ ጾስ ካተትꬅ ባጋ ታማርሴዛ፤ ፓጾዳይስ ኮይዝታይካ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ሳአ ኦማꬆዳር ታጶ ናምኢ ሀዋርታይ ኤዝኮ ሺቂ፥ «ኑ የዛይ ሊዦ ማቄዝ ግሾስ አሳይ ዱማ ዱማ ሄራራኔ ካታምታ Ꮊንጊ፥ ካꬃኔ አቅዛ ካራ ኮዮድ ጋርክ አሳ ሞይዞባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ዝን የሱሳ፥ «ኡንትስ ሚዝባዝ ይ እንጎይታ» ዬጌዛ። ኡንቲ፥ «ኑስ የዛይ እችን ሶሎኔ ናምኢ ሞሎ ማቄዝ ግሾስ Ꮊ አሳይስ ግድዛ ካꬃ ኑኒ Ꮊንጊ ዎንጋም እጽኮ ግዳሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","የ አቃይድ እችን ሙኩለ ማቅዝ ꬊራꬅታይ የዛ። የሱሳ ፋ ታማርታይኮ፥ «ኢሻታም እሻታም ሻኪ ሻኪ አሳ በትꬆይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ኤ ታማርታይ፥ ኤ ኪቴዛይ ጋርክ አስታ በትꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ኤ እችን ሶሎራኔ ናምኢ ሞልታ ኤኪ፥ ሳሎ ብኢ፥ ጾሳ ጋላቲ፥ መንꬂ አሳ ኡባ ሄልꬆድ ጋርክ ፋ ታማርታይስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ኡባይ ም ምዤዛ። ኡንታፕ አቴዝ ጉፋይ ታጶ ናምኢ ሌማተ ኩንꬅ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","የሱሳ ፋ አዳ ዎሶዳር፥ ኤ ታማርታይ ኤዝኮ የኤዛ። ፐቲ ጋላስ ኤ፥ «አሳይ ታና ኦና ጌ?» ግ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ኡንቲ ማሂ «ፐታይ ፐታይ፥ ‹ጻማቅዛ ዋንሳ፥ ባግታይ ኤላሳ፥ Ꮊንክታይ ማ፥ ብኒ ናብታይፕ ፐታይ Ꮊይቆፕ ደንዴዛ› ዬግዛ» ግ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ኤ ማሂ፥ «የዝን ይ ታና ኦና ጌ» ዬጌዛ። ጵጽሮሳ፥ «ኔኒ ጾሳፕ ትዥንቴዝ ክርስቶሳ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","የሱሳ Ꮊያ ኦስካ ኦድፓተ ግ ሚንꬂ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ማካ የሱሳ፥ «አስ ናአይ ጋመ መቶ ኤኮዳ። ጋደ ጭምታይር፥ ቄሰ ሀላቅታይር፥ ህገ አስታማርታይር እጽንቶዳ። ኡንቲ ኤዛ ዎꬎዳ፥ ዝን ኤ ሃይꬓንꬆ ጋላስ Ꮊይቆፕ ደንዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","የሱሳ አስ ኡባይኮ፥ «ታና ካሎዳይስ ኮይዛይ ኦንካ የዝኮ ፋና ካዶ፥ ፋ ማዝቃላ ጋላስ ጋላስ ቶኪ ታና ካሎ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ፋ ሸምፓቶ አሾዳይስ ኮይዝ ኡባይ እዞ ꬋብስዛ፥ ፋ ሸምፓቶ ታ ግሾስ ግ ꬋብስዛ ኦንካ እዞ አሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","አሲ አላመል የዛ ባዝ ኡባ ሞዲ፥ ፋ ሸምፓቶ ꬋብስዛ ባዝ ዎይ ቆህዛ ባዝ ማቅኮ ኤዛ አብ ማዴ? ");
INSERT INTO mfxe_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ኦንካ ታላኔ ታ ቃላይል ዬላትኮ አስ ናአይ ፋ ቦንቾር፥ ፋ አዳይ ቦንቻይራኔ ጌሽ ኪታንችታይ ቦንቾር ይእዛ ዎደ ኤ ቲና ዬላቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ታ ይንትስ ቱሮ ኦድዛ፤ Ꮊይዳ ኤቄዝታይ ጋንጨፐ ጾሳ ካተትꬃ በኤካዛር Ꮊይቃም ፐቲ ፐቲ አሳይ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","የሱሳ የ ኦዳ ኦድን፥ ሆስፑን ጋላሳፕ ጉየ ጵጽሮሳ፥ ያይቆባራኔ ዋንሳ ፓር ኤኪ ዎሶዳይስ ደረል አፋ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ኤ ዎሳል አፋ የዝን ኤ ጭራይ ላምንቴዛ፤ አፍላይካ አዋ ጋርክ ፎጪ ቦጺ ፎጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ናምኢ አሳይ፥ ኡንትካ ሙሰራኔ ኤላሳራ ኡንታር ናሽዛ ");
INSERT INTO mfxe_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ቦንቾር በንቲ የሩሳላመ ፖልንቶዳይስ የዛ ባዝ፥ የይካ፥ ኤ Ꮊ አላማይፕ ሻክንቶድ ባዝ ኤዛር ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ጵጽሮሳራኔ ኤዛር የዝታ ገንታ ኦልን፥ ኡ ገንታፕ ባርኪ ኤ ቦንቻኔ ኤዛር ኤቄዝ ናምኢ አስታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","አሳይ የሱሳፕ ሻክንቲ ቅቶድ ሀኖዳር፥ ጵጽሮሳ የሱሳኮ፥ «ጎዳዮ፥ Ꮊይዳ የስ ኑስ ሎኦ! ፐቶ ኔስ፥ ፐቶ ሙሰስ፥ ፐቶ ኤላሳስ ሀይꬒ ጋባ ጋቢሶዳ» ዬጌዛ። ዝን ኤ ፋ ግዝ ባዝ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ኤ ዬጊ ናሾዳር ሻራ ይኢ ኡንታን ካሜዛ። ኤ ታማርታይ የ ሻራይ ጋንጨ ገልታር ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ሻራይ ጋንጨፐ፥ «ታ ዶሬዝ ናአይ Ꮊያ ኤዛ ስኦይታ» ዬግዝ ቃላ ስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","የ ቃላይ ስንቴዛይፕ ጉየ የሱሳ ፋ ኣዳስ የዛር በንቴዛ። የ ጋላስ ኡንቲ በኤዝ ባዝ ኦስካ ኦደካዛር፥ ፋ ዎዝና አይኪ ስእ ግ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ዎንትꬃ ኡንቲ ደረላፕ ዎꬎዳር ጋመ አሳይ ይኢ ኤዛ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","የ ዎደ ዎይታይፕ ፐቲ አሲ ኡክታር፥ «አስታማራዮ፥ ታ ናአይ ፐቶ ኤዛ ፓꬆዳይ ጋርክ ታ ነና ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ቱና አያና ቆፐካዝን አይኪ ኡክስዛ፤ አፋፕ ኦሊ ጋፑንትሲ ቃክትስዛ፥ ጋላ ማዱꬅስዝ ኡንእꬅ ዳክዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ነ ታማርታይ ከሶዳይ ጋርክ ዎሴዛ፥ ዝን ኡ ዳንዳኤካያ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","የሱሳ፥ «አማኖ ባ ዡጫ የለትꬁንꬆ፥ አይደ ሄሎዳይስ ታ ይንታር የዞዴ፥ አይደ ሄሎዳዪስ ይንታን ዳንዳኦዴ? ነ ናአ Ꮊና ኤኪ የኦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ናአ ኤኪ የኦዳር ቱና አያናይ ሾጪ ኦሊ ኩኩርሴዛ። ዝን የሱሳ ቱና አያና ካጪ ናአይፕ ከሲ ፓꬄዛ። ናአናካ ናአይ አዳይስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","አሳይ ኡባይ ጾሳይስ የዝ ዳሞ ዎልቃ ብኢ ማላባዝ ጌዛ። ኡንቲ ኤ ኦꬄዝ ባዛር ማላባዝ ጊታር፥ የሱሳ ታማርታይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ꮊያ ታ ይንትስ ኦድዛና ሎእꬂ ስኦይታ፤ አስ ናአይ ሞርክታይ ኩሸ ኣꬊ እንግንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ዝን ኤ ጌዝባዛይ ኡንታፕ ቆስንቴዝ ግሾስ መልክ ጌዛ። የይ ግሾስ፥ ማሂ ኦይጮዳይስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","የሱሳ ታማርታይ፥ «ኑ ጋንጨ ኡባፕ ኣꬎ ማቃዳይ ኦኖ?» ግ ፓላማ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","የሱሳ ኡ ዎዝና ቆፋ ኤሪ ዱደ ናአ ፋ ካለ ኤሲ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«Ꮊ ዱደ ናአ ታ ሱንꬃር ሞክዛ ኦንካ ታና ሞክዛ፥ ታና ሞክዛይ ታና አዛዜዛና ሞክዛ፥ ይ ኡባይፕ ጽቅዛይ፥ ኤ ኣꬎ ማቃዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ዋንሳ ማሂ «ጎዳዮ ፐቲ አꬃይ ነ ሱንꬃር ጻላሄ ከሶዳር ኑ በኤዛ። ዝን ኤ ኑ ባጋ ማቀካ ግሾስ ኑ ኤዛ ካዬዛ።» ");
INSERT INTO mfxe_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","የሱሳ ማሂ «ይንታን እጾዋ ኡባይ ይንታር የዛ ካይፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","የሱሳ ሳሎ Ꮊንግዛ ዎዳይ ኡኬዝ ግሾስ የሩሳላመ Ꮊማዳይስ ሙርቲ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ሳማረ ቢታ የዝ ፐቲ ሄራ Ꮊንጊ፥ ኡባ ባዝ ኤዝስ ጊግሶዳይ ጋርክ አሳ የ አቃ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ዝን ኤ Ꮊንግዛይ የሩሳላመ ማቅዛና ኡ ኤርዛ ግሾስ ሞኪ ኤከካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","የሱሳ ታማርታይ ያይቆባራ ዋንሳራ የያ ብኢ፥ «ጎዳዮ፥ ሳሎፕ ታማ ዎꬊ ኡንታን ሙየ ጎድ ጋርክ ነ ኮይኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ዝን የሱሳ ጉየ ማቂ ኡንታን ካጪ፥ ይንታል አባ አያና የዛኮ ይ ኤሮያ። «ይንታል አፋ አባ አያና የኔ። Ꮊ ቆፋይ ፐቲ ፐቲ ማጻፍታይድ ባያ አስ ናአይ አስ አሾዳይስ የኤዛይፕ አትን ꬋብሶዳይስ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ኤዛይፕ ደንዲ ሀራ ሄራ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","የሱሳራ ኤ ታማርታይራ ኦገር Ꮊማዳር፥ ፐቲ አሲ፥ «ጎዳዮ ነ Ꮊንግዛ አቆ ኡባ ታ ካሎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","የሱሳ ማሂ፥ «ሻንታይስ ኦላ፥ ሳሎ ካፍታይስ ኬꬅ የዛ፥ ዝን አስ ናአይ ፋ ኦማ ሸምፕስዛ አቆ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ꮊንካይኮካ፥ «ኔኒ ታና ካሎባ» ዬጌዛ። ዝን አꬃይ፥ «ጎዳዮ፥ ቲናቲ Ꮊንጊ ታ ታ ኣዳ ሞጊ የኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ዝን የሱሳ፥ «Ꮊይቄዝታይ Ꮊይቄዝታ ሞጎድ ጋርክ ኡንትስ አሺ አሾባ፤ ኔኒ Ꮊንጊ ጾሳ ካተትꬃ ሳባኮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ማ ሀራ አሲ፥ «ጎዳዮ፥ ታ ነና ካሎዳ፥ ዝን ቲናቲ ታ ካራ አሳ ሳሮꬅ የኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","የሱሳ ማሂ፥ «ኮጸ አይኪ ጉየ ብእዝ ኦንካ ጾሳ ካተትꬃይስ ቤዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","የይፕ ጉየ፥ ጎዳይ ሀራ ላፑን ታማኔ ናምኢ አስታ ዶሬዛ። ኤ Ꮊማዳይስ ቆፔዝ ካታማኔ ሄራ ኡባ ቲናቲ Ꮊማድ ጋርክ ናምኤ ናምኤ ኡዲ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","የሱሳ ኡንትኮ፥ «ይኬ ሺቆድ ቶርቼ ካꬃይ ጋመ ዝን ቶርቼ ኦሶ አሳይ ጽቃ። ዬዬዝ ግሾስ፥ ቶርቼ ካꬃ ጎዳይ ኦሶ አስታ ኪቶዳ ጋርክ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ይኬ፥ Ꮊንጎይታ፥ ዱርታይ ጋርክ ፉግታይ ጋንጨ ይንታን ታ ዳኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ይ Ꮊንግታር ኦገስ Ꮊይትታ አይክፓተ፥ ሚሸ ማቅን ካꬃ ማቅን ጫማ አይክፓተ። ኦገል አፋ ኦናካ ሳሮꬅታር ዎዴ ኣꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ይ ገልዛ ኬꬃ ኡባ ቲናቲ፥ ‹ሳሮ Ꮊ ኬꬃይስ ማቆ› ዬጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ሳሮ ቃꬍዛ አስ የ አቃይድ የዝኮ፥ ይ ሳራይ ኤዛይድ አቆዳ፤ እጽኮ ይ ሳራይ ይንትስ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ኦሶ አስስ ዳሞዘ ቤዝዛ ግሾስ ይ ገሌዝ ኬꬃ ይንትስ ሺሼዝ ባዝ ኡባ ሚታራኔ ኡዥታር ኤዛይድ ጋምኦይታ። ፐታይ ካራፕ ፐታይ ካራ ዩይፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","አባ ካታማካ ይ ገሎዳር አሳይ ይንታን ሞኪ፥ ይንትስ ሺሼዝ ባዝ ኡባ ሞይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","የ ካታማ ጋንጨ የዝ ሀርግንቴዝታ ፓꬅታር፥ ‹ጾሳ ካተትꬃይ ይንትኮ ኡኬዛ› ዬጊ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ዝን ፐቲ ካታማ ገሎዳር አሳይ ይንታን ሞካም እጽኮ ዞዘል ከዚ Ꮊይ ጋርከ ጎይታ: ");
INSERT INTO mfxe_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹ኑ ቶካይል አፋ የዝ ይ ካታማይ ቡልአ ኑ ፕቶዳ፥ ዝን ጾስ ካተትꬃይ ይንትኮ ኡኬዛና ኤሮይታ› ");
INSERT INTO mfxe_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ፕርዳ ጋላስ Ꮊ ካታማትፕ ሶዶመ ካታማስ ፕርዳይ ካዉሻ ማቃዳና ታ ይንትስ ኦድዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ማ ማቅካ፥ የሱሳ፥ «ነኖ ኮራዝኔ፥ ነኖ ቤተሳይዳ፥ አየ፥ ይንታል ኦስንቴዝ ማላትታይ ጽሮሳኔ ስዶና ኦስንቴዛኮ ኤዛይድ የዝ አሳይ ካዮ አፍላ ማኢ፥ ቡዶል አፋ በቲ ብኒ ማሮተꬅ ገሊ አቶዳዝን። ");
INSERT INTO mfxe_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","የይ ግሾስ፥ ይንትፕ ኣꬂ ጽሮሳስኔ ስዶናስ ጾስ ፕርዳይ ካዉዦዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ꮊኔ ቅፍርናሆመ፥ ሳሎ ሄሎዳይስ ነ ꬎቅ ጌኔ? ነ ሱል ስኦለ ዎꬎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ማካ የሱሳ ፋ ታማርታይኮ፥ «ይንታን ስእዛይ ታና ስእዛ፥ ይንታን ኤኮዛይ ታና ኤኮያ፥ ታና ኤኮዛይ ታና አዛዜዛና ኤኮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ላፑን ታማኔ ናምኢ ታማርታይ ኪትንቴዝ አቃይፕ ሎእꬂ ኡፋይትታር ማቄዛ። የሱሳኮ ሺቂ፥ «ጎዳዮ፥ ነ ሱንꬃር ቱና አያንታይካ ኑስ አዛዝንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","የሱሳ ኡንትኮ፥ «ጻላሄ ሳሎፕ ዳዳ ጋርክ ዎꬎዳር ታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ዬዛኮ፥ ሾሽኔ Ꮊንጋርጮ የꬎድ ጋርከኔ ሞርከ ዎልቃር ኤቅንቶድ ጋርክ ይንትስ ታ ማዉተ እንጌዛ። ይንታን ቆሆድ ባዝ አኮካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ማቆዝን፥ ይ ሱንꬃይ ሳሎ ማዝጋባይድ ጻፍንቴዝ ግሾስ ኡፋይቶይታፕ አትን ቱና አያንታይ ይንትስ ኪትንቴዝ ግሾስ ኡፋይትፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","የ ዎደ የሱሳ ጌሻ አያናር ኡፋይቲ፥ «ሳሎ ሳአ ጎዳዮ፥ Ꮊያ ኤጭታይፐኔ ኤራንችታይፐ ቆሲ ዱደ ናእታይስ ቤዜዝ ግሾስ ታ ነና ጋላትዛ። ኤ ታ አዳዮ፥ የያ ነ ኦꬆዳይስ ሎኦ ሸነ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«ኡባ ባዝ ታ አዳይፕ ታስ እንግንቴዛ። ናአይ ኦናዛኮ አዳይፕ አትን ሀራ ዎይ ናአይ ቆንጭሶዳይስ ኮይዛይፕ ሀራ ኦንካ ኣዳ ኤርዛይ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ማ ማቅካ፥ የሱሳ ዱማ ፋ ታማርታይኮ፥ «ይ በኤዛና ብእዝታይ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ቱማ ጋመ ናብታይኔ ካትታይ ይ ብእዛኔ ስእዛና በአዳይስኔ ስኦዳይስ አሞቴዛ፥ ዝን ኡ በኤካያ፥ ስኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ዬዛኮ፥ ፐቲ ጋላስ ሙሰ ህገ ኤርዛ ፐቲ አꬃይ ደንዲ የሱሳ ዬጊ ፓጨ ኦይች ኦይጬዛ። «አስታማራዮ፥ መꬍናስ ደኦ ላቶዳይስ ታኒ አብ ኡዶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","የሱሳ፥ «ሙሰ ማጻፋይድ ጻፍንቴዛይ ዋጌ? ነ ዋይዚ ናባብ አካኬ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","አꬃይ ማሂ፥ « ‹ነ ጎዳ ነ ጾሳ፥ ነ ኩንꬅ ዎዝናፐ፥ ነ ኩንꬅ ሸምፖፕ፥ ነ ኩንꬅ ዎልቃፐኔ ነ ኩንꬅ ቆፋፕ ቃꬎባ። ማካ ነ ላጋ ነ ኡባይ ጋርክ ቃꬎባ› ዬግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","የሱሳ ኤዝኮ፥ «ኔኒ ይኖ ልኬ ማሄዛ፥ ኔካ Ꮊይ ጋርክ ኦꬆባ። ነ መꬍናስ ደኦ የዞዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ዝን አꬃይ ፋና ጌሽ ኦꬆዳይስ ኮዢ፥ «ሀኖስ ኤ ታ ላጋይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ኤ ኦይቻይስ የሱሳ ዬጊ ማልሰ እንጌዛ፥ «ፐቲ አሲ የዛይ የሩሳላመ ካታማፐ ሱለ ኢያርኮ ካታማ Ꮊማዳር ኦገል አፋ ፓንታይ ከዚ ሾጬዛ። ኤ አፍላ ቃሪ ኤኪ Ꮊይቆፐኔ ፓꬃፕ ጋንጨ ኦሊ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ጉየፕ፥ አይሁደ ቄሰ ፐታይ የ ኦጋይር ፋ Ꮊሞ Ꮊንግታር አꬃ ብኢ ደሽ ግ ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ማካ ፐቲ ለዋይ የ አቃ ሄልታር አꬃ ብኢ ሀራ ኦገር ኣꬊ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ዝን፥ ፐቲ ሳማረ ቢታ አስ የዛይ የ ኦጋይር ይእታር አꬃ ብኢ ኤስ ቃꬊንቴዛ ");
INSERT INTO mfxe_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ኤዝኮ ሺቂ፥ ኤ ማዶꬃይል አፋ ዛይተኔ ዎይነ ቆል አጬዛ። ፋ ሀረል አፋ በትꬂ እማꬂ አቅዝ ኬꬃ ካንጌዛ። የ አቃይድ ኤዝስ ኮሽዛ ባዝ ኡባ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ዎንትꬃ ናምኢ ዲናረ ማሂ እማꬅ ካራ አዳይስ እንጊ፥ ‹ሀያና Ꮊ አꬃ ሎእꬂ ቦኦባ። ታኒ ኔስ እንጌዛይፕ አፋር ነ ከስዛ ባዝ ኡብታ ታ ኔስ ጭጎዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«ይኬ፥ Ꮊ ሀይꬒ አስታይፕ ፓንታይ ሾጬዝ አꬃይስ ላጌ ማቄዛይ ኔስ ኦና ኣዜ?» ");
INSERT INTO mfxe_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","አꬃይ ማሂ፥ «ኤዝስ ቃꬊንቴዛያ» ዬጌዛ። የሱሳ፥ «ኔካ Ꮊንጊ Ꮊይ ጋርክ ኦꬆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","የሱሳ ፋ ታማርታይር ኦገ Ꮊንግታር ፐቲ ሄራ ሄሌዛ። ኤዛይድ ማርታ ግንትንትዝ ፐቲ አስታ ኤዛ ፋ ካራ ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","እዝስካ ማይራሞ ግዝ ምሽታ የዛ፥ ማይራማ ቃላ ስእታር ጎዳይ ቶኬ ካለ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ዝን ማርታ ጋመ ኦሶር ኡንእንቲ የሱሳኮ ሺቂ፥ «ጎዳዮ፥ ታ ምሽታ ኦሶ ታ ኣዳስ አሺ በቲ አትን ታ ዳቡሮዳር ነ ብእታር ስኢ ግኔ? እዛ ታና ማዶድ ጋርክ ኦዶሳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ዝን ጎዳይ Ꮊይ ጋርክ ግ ማሄዛ፥ «ማርታ፥ ማርታ፥ ነ ጋመባዛር ቱርቱሪ መትንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ማቆዝን፥ ኮይንትዛይ ፐትባዝ ኣዳ። ማይራማ ሎኦ ባዝ ዶሬዛ፥ የይካ እዝፐ ኤክንታሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ፐቲ ጋላስ የሱሳ ፐቲ አቆ ዎስዛ። ዎሳ ዉርሴዛይፕ ጉየ ኤ ታማርታይፕ ፐታይ፥ «ጎዳዮ፥ ዋንሳ ፋ ታማርታ ዎሳ ታማርሴዛይ ጋርክ ኔካ ኑና ዎሳ ታማርሶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","የሱሳ፥ «Ꮊይ ጋርከ ዬጊ ዎሶይታ፦ «‹ሳሎ የዝ ኑ አዳዮ ነ ጌሽ ሱንꬃይ አንጅንቶ፤ ነ ካተትꬃይ የኦ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ኑስ ጋላሳ ካꬃ Ꮊይኖ ኑስ እንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ኑና ቆሄዝታ ኑኒ አቶ ግዛይ ጋርክ፥ ኑ ናጋራ አቶ ጎባ፤ ፓጨ ጋንጨ ኑና ገልስፐ› ዬጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ማቅካ፥ የሱሳ ፋ ታማርታይኮ ዬጌዛ፦ «ኣዝሶስ ይንትፕ ፐታይስ ላጌ የዛ። ኤ ግዲ ብላሄ ፋ ላጋይ ካራ Ꮊንጊ፥ ‹ታ ላጋዮ፥ ሀይꬒ ሶሎ ታስ ታልኦየ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ታስ ላጌ ማቄዝ ፐቲ አሲ ኦገፕ ይእን፥ ኤዝስ ኣꬆድ ባዝ ታና ꬋቤዛ› ዬግኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«ኤ ላጋይ ኬꬃ ጋንጨ የዚ፥ ‹ሀያና ታና ዋይꬅፐ፥ ፐንጋይ ኮብንቴዛ። ታ ናእታይካ ታር አርሳል አፋ ዎይኤዛ። የይ ግሾስ፥ ደንዲ ነ ኮዬዝ ባዛ እንጎዳይስ ዳንዳኦያ› ዬግነኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ታ ይንትስ ኦድዛ፤ ላገትꬃይ ግሾስ ደንዲ እማዳይስ ኮየካ ማቅኮካ ዎሳር ዋይꬄዝ ግሾስ ደንዲ ኮይዝ ባዝ ኡባ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«የይ ግሾስ፥ ታኒ ይንትስ ኦድዛ፤ ዎሶይታ ይንትስ እንግንቶዳ፤ ኮዦይታ ይ ደንጎዳ፤ ባለ ይኢ ጼጎይታ ይንትስ ዶይንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ዎስዛ ኡባይ ኤክዛ፤ ኮይዛይ ደንግዛ፤ ባለ ይኢ ጼግዛይስ ዶይንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«ይንታኖ፥ አድታዮ ይ ጋንጨፕ ናአ ቦራ ዎስኮ ሹች እንግዛይ ኦኖ? ሞሎ ዎስኮ ሾሺ እንግዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ዎይ ጱጱለ ዎስኮ Ꮊንጋርጮ እንግኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ይ ኢትታ ማቅታር ይ ናእታይስ ሎኦ ባዝ እሞ ኤርኮ፥ ሳሎ የዝ ይ አዳይ ዎስዝታይስ ጌሻ አያና ዋይዚ ኣꬂ እንጋሞ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ፐቲ ጋላስ የሱሳ ዶና ሙምሴዝ ቱና አያና ፐቲ አꬃይፕ ከሴዛ። ቱና አያናይ ከዜዛን ጋርክ ሙመ አꬃይ ኦድንቴዛ። ዎያይካ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ዝን ፐታይ ፐታይ፥ «ቱና አያና ሀላቃ፥ ብኤልዘቡላ ዎልቃር ቱና አያንታ ከስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ꮊንክታይ ማ ፋጮዳይስ ሳሎፕ ማላ ቤዞዳይ ጋርክ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ዝን የሱሳ ኡ ቆፋ ኤሪ ኡንትኮ፥ «ዎል ጋንጨ ሻክንትዛ ካተትꬂ ኡቢታይ ꬋብዛ፤ ዎል ጋንጨ ሻክንትዛ ኬꬅ ዎድዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ጻላሄ ካተትꬃይ ሻክንትኮ ኤ ካተትꬃይ ዋይዚ ሚንጊ ኤቆዴ? ይ ታና፥ ‹ኤ ቱና አያንታ ብኤልዘቡላ ዎልቃር ከስዛ› ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ይኬ፥ ታኒ ቱና አያና ብኤልዘቡላ ዎልቃር ከስዛ ባዝ ማቅኮ ይንታን ካልዝታይ ኦ ዎልቃር ከሶደሻ? የይ ግሾስ፥ ኡንቲ ይንታል አፋ ፕርድዝታ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ዝን ታኒ ቱና አያንታ ጾስ ዎልቃር ከስዛ ባዝ ማቅኮ ይኬ ጾሳ ካተትꬃይ ይንትኮ ኡኬዛና ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«ሚንꬅ አስ ዳንጭንቲ ፋ ኬꬃ ናግዝ ማቅኮ፥ ኤ ሻላይ ቦችንተና። ");
INSERT INTO mfxe_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ሀኖ ዝን፥ ኤዝፕ ኣꬊ ሚንꬅ ማቄዝ አስ ይኢ፥ ኤዛ ጋሚ ኤ አማንንቲ ዳንጬዝ ዳንጫ ብልሲ፥ ኤ ሻላና ቦንቂ ሻግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«ታር ዎላ ማቀካዛይ ታና እጽዛ፤ ታር ሺሾዛይካ ላልዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«ቱና አያናይ አሳፕ ከዜዝ ዎደ ሸምፕዛ አቆ ኮዪ ሃꬂ ባ አቆር ዩይዛ። ሸምፕዛ አቆ ꬋቤዝ ዎደ ‹ማቂ ታ ከዜዝ ካርቴ Ꮊማዳ› ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ኤ ማቅዝ ዎደ ኬꬃይ ፕትንቲ ሎእ የዝን ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","የይፕ ጉየ፥ Ꮊንጊ ኤዝፕ ኣꬊ ኢቴዝ ሀራ ላፑን ቱና አያንታ ኤኪ ይእዛ። ኤዛል ገሊ የስ አይክዛ። የ አꬃይስ ቲናሳይፕ ጉዬሳይ ኣꬊ ኢታ ማቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","የሱሳ የያ ኦዳል አፋ የዝን ፐቲ አስታ ዎያ ጋንጨፕ ደንዲ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ነና ቶኬዝ ኡላይኔ ነ አሜዝ አምታይ አንጅንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ዝን ኤ፥ «አንጅንቴዝታይ ጾስ ቃላ ስኢ ኪትንትዝታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ጋመ አሳይ ሺቄዝ ዎደ የሱሳ፥ «Ꮊ የለትꬃይ ኢታ፤ ማላ ኮይዛ። ዝን ዮናሳ ማልታይፕ አትን ሀራ ኡንትስ እንግንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ዮናሳ ናናወ አሳይስ ማላ ማቄዛይ ጋርክ አስ ናአይካ Ꮊ የለትꬃይስ ማላ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ካታታ ሳባ ፕርደ ጋላስ Ꮊ የለትꬃይራ ደንዲ ፕርዶዳ። አብስ ጊኮ፥ እዛ ሶሎሞነ ኤጨትꬃ ስኦዳይስ ቢታ ጋጻፕ ደንዲ የኤዛ። ዬዛኮ ሶሎሞነፕ ኣꬍዛይ Ꮊይዳ የዛ ");
INSERT INTO mfxe_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ናናወ አሳይ ፕርደ ጋላስ Ꮊ የለትꬃይራ ደንዲ ኡንታል አፋ ፕርዶዳ። አብስ ጊኮ ዮናሳ ስብካተር ማሮትꬅ ገሌዛ። ዬዛኮ፥ ዮናሳፕ ኣꬍዛይ Ꮊይዳ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«ጾምፐ ጾምፒ ቆሶ አቆ ዎይ ኦታ ጋንጨ ጋድዛ አሲ ባያ። አሲ ፖአና በአድ ጋርክ ꬎቀ አቆ ጋድዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ነ ጋላ ኡባይስ ፖአይ ነ አፋ። ነ ኣፋይ ሎኦ ማቅኮ፥ ነ ኩንꬅ ጋላይ ፖእዛ። ነ ኣፋይ ሀርግኮ ነ ጋላይ ኡባይ ꬉምዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","የይ ግሾስ፥ ነ ጋንጨ የዝ ፖአይ ꬉማም ጋርክ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ይኬ፥ ነ ኩንꬅ ጋላይ ፖኦ ማቅኮ፥ ነ አሰትꬃይዳካ ሀራ ꬉማ አቆ ꬋብኮ፥ ነ ጋላ ኩንꬃይ ዋዢ ጌዝ ፖኦ ጋርክ ማቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","የሱሳ ፋ ናሻ ዉርሴዛን ጋርክ ፐቲ ፈርሳዋይ ፓር ካꬃ ማዳይ ጋርክ ጼጌዛ። ኤ ኤዛር ዎላ ገሊ ስብረል አፋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ፈርሳዋይ የሱሳ ካꬃ ማዳይፕ ቲና ኩሸ ሜጨካዛ ብኢ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ጎዳይ ኤዝኮ፥ «ይንቲ ፈርሳውታይ ዋንጫስኔ ከረስ አፋ ባጋ ሜጭዛ። ዝን ይ ጋንጫይ ቦንቃኔ ኢታትꬃር ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ይንታኖ፥ ቦዝታዮ፥ ባለ ባጋ መꬌዛይ ጋንጨ መꬌዝ ጎዳይ ኤዛ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ዝን ዋንጫኔ ኬሬ የዛና ማንቅታይስ እንጎይታ። የ ዎደ ይንትስ ኡባ ባዝ ጌሽ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«ፈርሳውታዮ ይንታን አየ፥ ሳዎፐ፥ ጻሎተፐ፥ የይ ጋርክ ባዝፐ አስራታ ከስዛ። ዝን ጽሎትꬅኔ ጾስ ቃ ይንታር ባያ። Ꮊንክታ አሸካዛር Ꮊይትታካ ኦꬆዳይስ ቤዝዛ፥ ዝን ይ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«ፈርሳውታዮ ይንታን አየ፥ አይሁድታይ ዎሳ ኬꬃ ቦንቾ ኦይደ፥ ጋበ ጋንጨ ቦንቾ ሳሮꬆ ይ ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«ሊላሚ ꬋብን አሳይ ኤረካዛር አፋር የꬍዝ ዱፎ ኣዝዝታዮ ይንታን አየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ህገ አስታማራይ ማቂ፥ «አስታማራዮ፥ ነ የያ ጊታር ኑና ጫዥዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","የሱሳ፥ «ይንታኖ፥ ህገ አስታማርታዮ፥ ይንታናካ አየ፥ አሲ ቶኮዳይስ ዳንዳኦዋ ዴጾ ቶፎ ቶስዛ፥ ዝን ይንቲ ይ ኡባስ ሀራ አቶዝን ብራ ጼራራካ ቦቾያ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«ይ አድታይ ዎꬌዝ ናብታይ ዱፋ ይ ጊግስዛይ ግሾስ ይንታን አየ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ይኬ፥ ይ አድታይ ኦሳ ምንꬆዳይስ ኡ ዎꬌዝ ናብታይ ዱፋ ይ ሎእꬅዛ ግሾስ ኡ ኢታ ኦሳይስ ይ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","የይ ግሾስ፥ ጾሳይ ፋ ኤጨትꬃር፥ ‹ናብታኔ ሀዋርታ ታ ይንትስ ኪቶዳ፥ ዝን ይ ባግታ ዎꬎዳ፤ Ꮊንክታ ባይኦዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","የይ ግሾስ፥ Ꮊ የለትꬅታይ አላማይ መꬍንቴዛይፐ Ꮊኖ ሄሎዳይስ ላልንቴዝ ናብታይ ኡቢታይ ሱꬃይስ ኦይጭንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","አቤላፕ አይኪ ያርሾ አቆስኔ ጾስ ኬꬃፐ ጋንጨር ላልንቴዝ ዛክሬሳ ሱꬃይ ግሾስ Ꮊ የለትꬃይ ኦይጭንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«ህገ አስታማርታዮ፥ ይንታን አየ፥ ኤረትꬅ ቁልፓ ይ ኩሸ ይ አይኬዛ፥ ዝን ይንትስ ገሎያ Ꮊንክታካ ገልሶያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","የሱሳ የይፕ Ꮊማዳይስ ከሳዳር ህገ አስታማርታይኔ ፈርሳውታይ ኤዛር ኤቅንቲ ኦይቻር ዋይꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ኤ ዶናፕ ከዝዝ ቃላር ኤዛ አይኮዳይስ ኮዪ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","የ ዎደ ጋመ ሙኩለር ታይብንትዛ አሳይ ዎላል አፋ የꬍንቶድ ጋꬆ አሲ አሳል አፋ ሺቂ የዝን፥ የሱሳ ፋ ታማርታይኮ፥ «ፈርሳውታይ እርሾፕ ናግንቶይታ። የይካ ጩቦትꬅ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","በንተካ ቆስንቲ፥ ኤርንተካ ካምንት አትዝባዝ አኮካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ይኬ፥ ይ ꬉማ ኦዴዝባዛይ ኡባይ ፖኦ ስእንቶዳ፥ ቆልአ ሀየ ካልካሼዝ ባዝ ዎያስ ኦድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«ታ ባጉንꬆ፥ ታ ኦድዛና ስኦይታ፤ አሾ ዎꬍዛፕ አትን ሀራ አብካ ኦꬆዳይስ ዳንዳኦዝታይስ ያሽትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ሀኖ ዝን፥ ይ ያሽቶዳይስ ቤዝዛና ታ ይንትስ ቤሳዳ። የይካ ዎꬌዛይፐ ጉየ ጋናመ ኦሎዳይስ ማዉተ የዛይስ ኤዝስ ያሽቶይታ። ኤ፥ ቱማ ግዛ፤ ኤስ ኣዳ ያሽቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","እችን ሱንታይ ፐቲ ሳንትፈስ ባይዝንቶሳኔ? ሀኖፕ አትን ኡንታፕ ፐታታካ ጾስ ቲና ዶግንተና። ");
INSERT INTO mfxe_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ሀራ አቶዝን፥ ይ ኦማ ብናናይካ ፓይድንቲ የዛ። ይኬ፥ ያሽትፓተ፤ ጋመ ሱንታይፕ ይ ኣꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«ታ ኦድዛ ስኦይታ፤ አስ ቲና ታ ባዝ ማርካትዝ ኡባይስ አስ ናአይ ጾስ ኪታንችታይ ቲና ማርኮቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","አስ ቲና ታና ካድዛና ጾስ ኪታንችታይ ቲና ታ ኤዛ ካዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","አስ ናአል አፋ ለቆ ቃላ ኦድዝ ኡቢታይ ማሮትꬅ ደማዳ፥ ዝን ጌሻ አያና ጫዥዝታይ ማርንተና። ");
INSERT INTO mfxe_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«አሲ ይንታን አይኪ አይሁድታይ ዎሳ ኬꬃ፥ ዳይንታይ ቲናኔ ካትታይ ቲና ጎሽችዛ ዎደ አብ ኦዶዳዛኮኔ ዋጊ ማሆዳዛኮ ህርግፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","የ ዎደ ይ ኦዶድ ባዝ ጌሻ አያናይ ይንታን ታማርሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ዎይታይፕ ፐቲ አሲ የሱሳኮ ይኢ፥ «ታ እሻይ ታስ ኑ አዳይ ኬኬፕ ሻኮድ ጋርክ ኤዝስ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","የሱሳ ማሂ፥ «ናት አꬃዮ፥ ይንታል አፋ ታና ዳይንኔ ኬኬ ሻክዝ ጭማ ኦꬄዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ማካ የሱሳ፥ «አስ የሳይ ሻሎ ጋመትꬃር ባዛይ ግሾስ ዣረ አሺ ሚንꬂ ይንታን ናጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ማቅካ ኣዝሶር፥ «ጋዳይ ጋመ ካꬃ እንግዝ ፐቲ ዱረ አꬃይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","የ አꬃይ፥ ‹ታ ካꬃ ታኒ ሺሾዳይስ አቆ ጽቄዝ ግሾስ አብ ኦꬆ?› ዬጊ ፋ ዎዝናር ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ꮊንፐ የሳዳ፤ ቲን የዛ ሻልታ ሁሊ ሀራ ዳልገ ሻለ ኬጾዳ። ካꬃኔ ታስ የዛ ባዝ ኡባ ኤዛይድ ኦሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ፋ ሸምፓትኮ፥ ‹ታ ሸምፓተ፥ ጋመ ላይꬅስ ኔስ ግድዛ ሻሎ ሺሼዛ። ይኬ፥ ሸምፕ ሞባ፥ ኡዦባ፥ ኡፋይቶባ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«ዝን ጾሳይ፥ ‹ናት፥ ቦዞ አꬃዮ፥ Ꮊይኖ ቃማ ነ ሸምፓታ ኔፕ ኤክንትዛ። ይኬ፥ ነ ሺሼዛይ ኦስ ማቆደ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«የይ ግሾስ፥ ፓስ ዱረትꬂ ሳአል ሺሽዛ አስስ፥ ጾስ ካለ ዱረ ማቀካ አስስ ዉርስꬃይ Ꮊ አꬃይሳይ ጋርከ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","የይፐ ጉየ፥ የሱሳ ፋ ታማርታይኮ፥ «ይኬ፥ ታ ኦድዛ ባዝ ስኦይታ፥ ይ ሸምፖስ አብ ማዴ ይ ጋላሳስ አብ ማአዴ ዬጊ ኡንእንትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ሸምፖ ካꬃፕ ጋላ አፍላፕ ኣꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ካፍታ ቦኦይታ ዘሮያ፥ ማጾያ፥ ሻለካ ባያ። ዝን ጾሳይ ኡንታን ሙዝዛ። ይ ካፍታይፕ ሎእꬂ ኣꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ሀኖ ዝን፥ ይንትፕ ኡንእንቲ ፋ ላይꬃል አፋ ፐቲ ቃማ ጉጆዳይስ ዳንዳእዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ይኬ፥ Ꮊ ጽቃባዝ ኦꬆዳይስ ዳንዳኦዋ ይ ሀራባዝስ አብስ ኡንእንቴ? ");
INSERT INTO mfxe_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","አን ፉꬍታይ ዋይዚ ድጭዛኮ ቦኦይታ። ዋዮያ ሱቆያ። ሀራ አቶዝን፥ ሶሎሞነ ፓስ የዝ ቦንቾ ኡባይር ኡንታፕ ፐታይ ጋርከካ ማኢ በኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ይንታኖ፥ አማኖ ፓጬዝታዮ፥ ይኬ፥ ጾሳይ Ꮊይኖ በንቲ ዎንታ ታማ ጋንጨ ዎꬎድ ፉꬍታ Ꮊይ ጋርከ ማእስኮ፥ ይንታን ዋይዚ ኣꬂ ማእሶሳ? ");
INSERT INTO mfxe_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","የይ ግሾስ፥ አብ ሞሻ ዎይ አብ ኡዦሻ ግ ይ ዎዝናር ኡንእንትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","የ ኡባ ጾሳ አማኖዋ አሳይ ኮይዛ። ዝን ይ አዳይ ጾሳይ የይ ኡቢታይ ይንትስ ኮሽዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ኡባፕ ኣꬂ ጾስ ካተትꬃ ኮዦይታ የይ ኡቢታይ ይንትስ ጉጂ እንግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«ይንታኖ፥ ጽቃ ዎይታዮ፥ ይ አዳይ ጾሳይ ካተትꬃ ይንትስ እማዳይስ ኤ ሎኦ ሸነ ማቄዛ ያሽትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ይንትስ የዛ ባዝ ባይዚ ማንቅታይስ እንጎይታ። ካይዞ ኤኮዋ፥ ብላ ሞዋ አቆ፥ ጭሞዋ ቁርቦ ጋንጨ፥ ዉሮዋ ሻላና ሳሎ ሺሾይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ይ ዎዝናይ ይ ሻላይ የዛ አቆ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«ይ ጼሳይ ዳንጭንቴዛ፥ ይ ጾምፓይ ፖኤዛ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ፋ ጎዳይ ቦሳይፕ ማቃድ ጋꬆ ባርኪ ናግዝታይ ጋርክ፥ ጎዳይ ይኢ ጼግዝ ዎደ ኤልሲ ዶዮዳይስ ጊጌዝ አስታ ኣዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ፋ ጎዳይ ማቅዝ ዎደ ገንተካዛር ናግዝታይ አንጅንቴዝታ። ታ ቱሮ ግዛ፤ ጎዳይ ሃታር ዳንጪ ሌማተ ላንቃይድ በትꬅ ሞክዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ጎዳይ ግዲ ብላሄ ማቅን ዎይ ዎንትማꬄ ማቅን ይኢ፥ የይ ጋርክ ገንተካዛር ናጎዳር ደንግዛ የ አይልታይ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ዝን Ꮊያ ኤሮይታ፤ ካይዞ አይደ የኦዳዛኮ ካራ አዳይ ኤርዛኮ ኬꬃይ ቦክንታምዝን። ");
INSERT INTO mfxe_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ይንትካ ጊጊ ናጎይታ፤ አስ ናአይ ይ ቆፐካ ዎደ የኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጵጽሮሳካ፥ «ጎዳዮ Ꮊ ኣዝሳ ኑ ኣዳስ ኦድነኔ አስ ኡባሶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ጎዳይ ማሂ፥ «ይኬ፥ ካꬃ ሙዞዳይስ ቤዝዛ ዎደር እማድ ጋርክ ጎዳይ ፋ አይልታይል አፋ ሹሜዝ አማንꬅዛይኔ ዎዛናማይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ጎዳይ ማቆዳር የይ ጋርክ ኦꬅታር በንትዝ አይላይ ኤ አንጅንቴዛያ ");
INSERT INTO mfxe_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ታ ይንትስ ቱሮ ኦድዛ፤ ፋ ጎዳይስ የዝ ሻሎ ኡባይል አፋ ኤ ሹምንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ዝን የ አይላይ፥ ‹ታ ጎዳይ ኤልꬂ የኤና› ዬጊ ፋ ዎዝናር ቆፒ፥ ጋꬊንድታኔ ጋችታ Ꮊꬍኮ፥ ማ ፓስ ኮዤዝ ጋርክ ሚታራኔ ኡዥታር ማꬅኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","የ አይላይ ጎዳይ ኤ ቆፐካ ጋላሳኔ ህርገካ ዎደ የኦዳ። ይኢ ኤዛ ጋሽቺ፥ ኤ አንጃ አማኖዋ አስታይር ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«ጎዳይ ሸናይ ጋርክ ጊጎዛይኔ ኤ ጎዳይ አብ ቃꬍዛኮ ኤርታር ኦꬆዋ አይላይ ጋመ ጋራፍንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ዝን ፋ ጎዳይ ሸና ኤረካ አቲ ጋራፍንቶዳይስ ቤዝዛና ኦꬄዛይ ጽቃል ጋራፍንቶዳ። አብስ ጊኮ ጋመ እንግንቴዛይፕ ጋመ ኮይንትዛ፥ ጋመ ሀዳራ ኤኬዛይፐካ ጋመ እማድ ግ ናግንትዛ።» ");
INSERT INTO mfxe_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«ታኒ የኤዛይ ቢታል አፋ ታማ አይꬆዳይስ። Ꮊት ታማይ አይክዛኮ ታና ዋይዚ ኡፋይሶደሻ! ");
INSERT INTO mfxe_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ሀኖ ዝን፥ ታ Ꮊት ጻማቅንትዛ ጽንቃታይ የዛ። ኤ ፖልንቶድ ጋꬆ ታ ዋፋ ኡንእንቶደሻ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ሳአል አፋ ሳሮትꬅ ኮኦዳይስ የኤዛ ይንትስ ኣዝኔ? የያ ባያ፥ ታ የኤዛይ ሻኮዳይስ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ꮊተፕ አይኪ ዎል ጋንጨ ሻክንቴዝ እችን አሳይ ፐቲ ኬꬃ ዎላ የዛ። ናምእታይ ሃይꬒታይል አፋ፥ ሀይዝታይካ ናምእታይል አፋ፥ ደንዲ ሻክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","አዳይ ናአይል አፋ፥ ናአይካ አዳይል አፋ፥ እንዳት ናአትል አፋ፥ ናአታ እንዳትል አፋ፥ አዝናይ እንዳት ናአይ ማቻትል አፋ፥ ናአይ ማቻት አዝናይ እንዳትል አፋ፥ ደንዲ ሻክንቶዳ።» ");
INSERT INTO mfxe_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ማካ አሳይኮ፥ «አዋ ገሎ ባጋር ሳሎ ሻራትዛ ዎደ ብኢ፥ ኤልሲ፥ ‹እራ የኦዳ› ይ ዬግዛ፥ የይ ጋርከካ ሀንዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ሱለ ባጋ ጫርኮ ጫርክዛ ዎደ ‹ሳአይ አዎዳ› ይ ዬግዛ፥ የይ ጋርከካ ሀንዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ይንታኖ፥ ጩብታዮ፥ ሳሎባዝኔ ሳአባዝ ሻኪ ኤርዝን Ꮊ ዎዳ ሻኪ ኤሮዳይ ይንታን ዋይዚ ጋሜኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«የዝን፥ ይ ኡባስ አብስ ቱማ ፕርዶሳ? ");
INSERT INTO mfxe_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ነ ሞርካይር ዎላ ዳይና ቲና ኤቆዳይስ Ꮊንግታር ኦገል አፋ ጊጎዳይስ ኮዪ ነ ጊገካ አትኮ ጎሽች ዳይና ቲና ነና ካማዳ። ዳይናይ ነና ፖልሴስ ኣꬂ እማዳ። ኤ ነና ዎይነ ኦሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ስኦይታ፥ ፐቲ ባካና አተካዝን ጭግ ሃሶድ ጋꬆ ነ እዝፕ ኬዛምዛኖ ኤሮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","የ ዎደ የሱሳኮ አሳይ ይኢ ጋልላ አሳይ ያርሾ ያርሾዳር ኡንታን ጵላጾሳ ዎꬊ ኡ ሱꬃ ያርሾር ዋላኬዝ ባዛ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ኤ Ꮊይ ጋርከ ዬጊ ማሄዛ፤ «የዝን Ꮊ ጋልላ አሳይ Ꮊ ኢታ Ꮊይቆ Ꮊይቄዝ ግሾስ ጋልላ የዝ አስ ኡባይፕ ኣꬎ ናጋራ ኦꬅዛ ኣዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","የያ ባያ! ይንትካ ማሮተꬃር ማቃም አትኮ፥ ኡቢታይ Ꮊይ ጋርክ ꬋቦዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ዎይ ማ ሳልሆመ ግዝ በሳይድ ግምባይ ዎዲ ዎꬌዝ ታጶ ሆስፑን አሳይ የሩሳላመ የዝ አስ ኡባፕ ኣꬌዝ ናጋራ ኦꬅዛ ኣዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","የያ ባያ! ዝን ይንትካ ማሮትꬃር ማቃም አትኮ ኡባይ Ꮊይ ጋርክ ꬋቦዳ።» ");
INSERT INTO mfxe_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ማካ የሱሳ Ꮊይ ጋርከ ግ ኣዝሶ ኦዴዛ፦ «ፐቲ አꬃይስ ዎይነ ጋደ ቱክንቴዝ ባላሰ ምꬃት የዛ። ኤ ኢፐ ኣፈ ኮዪ ይኢ አብካ ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ጋደ ጎዳይ ዎይነ ኦሶ አሳይኮ፥ ‹ኣፈ ደንጎዳይስ ኮዪ ሀይꬒ ላይꬅ ማቂ ማቂ ይኢ አብካ ደንገካያ። የይ ግሾስ፥ ጋቺ ሀልእሶባ፤ አብስ ቢታ መልሴ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«ዝን ኦሶ አꬃይ፥ ‹ጎዳዮ፥ እ ጋጻ ኦꬂ ኦሻ ኦሎድ ጋꬆ ሀበረስ አሾዬ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ይእዛ ላይꬅ ኣፍኮ ሎኦ፥ አትኮ ጋቺ አሾባ› » ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","የሱሳ ማላ ጋላስ አይሁድታይ ዎሳ ኬꬃ ታማርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","የ በሳይድ ታጶ ሆስፑን ላይꬅ ቱና አያና ዞኮ ኩንሴዝ ፐቲ አስታ የዛ። እዛ ኩኔዛይ ግሾስ ሉለ ኤቆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","የሱሳ እዞ በኤዝ ዎደ ጼጊ፥ «Ꮊን አስቴ፥ ነ ሀርጋይፕ ፓጼዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ፋ ኩሻ እዝል አፋ ጋድን፥ እዛ ኤለር ሉሊ ኤቄዛ። ጾሳካ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ዝን አይሁድታይ ዎሳ ኬꬅ ሀላቃይ ይሎቲ አሳይኮ፥ «ኦሶ ኦꬅዝ ኡሱፑን ጋላስታይ የዛ። የይ ግሾስ፥ የ ጋላስታይድ ይኢ ፓጾይታፕ አትን ማላ ጋላስ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ጎዳይ፥ «ጩብታዮ፥ ይ ጋንጨፕ ገማተ ዎይ ሀረ ማላ ጋላስ ዛዳሎፕ ብሊ ሃꬅ ኡሾዳይስ ካንጎዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","የዝን፥ Ꮊ አስታ አፍራመ ናአ ማቅታር ጻላሄር አጭንቲ ታጶ ሆስፑን ላይꬅ ኩንꬅ የዜዛንስ ማላ ጋላስ ብልንቶዳይስ ቤዞሳ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ኤ የያ ኦዴዝ ዎደ ኤቅንትዝታይ ኡቢታይ ዬላቴዛ። ዝን አስ ኡባይ ኤ ኦꬄዝ ማላታ ኦሶ ኡባይድ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","የይፐ ጉየ፥ የሱሳ Ꮊይ ጋርከ ዬጌዛ፥ «ጾስ ካተትꬃይ አብ ኣዝኔ? እዞ አባር ኣዝሶ? ");
INSERT INTO mfxe_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ጾስ ካተትꬃይ ፐቲ አስ ፋ ጋደ ጋንጨ ቱኬዝ ሳናፍጨ ኣፈ ጋርከ። እዛ ድጪ ዳማ ምꬅ ማቄዛ። ካፍታይ እ ሻቃይል አፋ ሸምፔዛ።» ");
INSERT INTO mfxe_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ማ፥ «ጾስ ካተትꬃ አባር ኣዝሶ? ");
INSERT INTO mfxe_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ፐቲ አስታ ጋመ ꬊላር ዋላኪ ሙኑቄዝ ጽቃ እርሾ ኣዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","የይፐ ጉየ፥ የሱሳ የሩሳላመ Ꮊንግታር ኤ ኣꬊዝ ኦገል የዝ ካታምታይዳኔ ሄራ ታማርስታር ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ፐቲ አስ የሱሳኮ፥ «ጎዳዮ፥ አቶዳይ ጽቃ አስ አዳኔ?» ዬጊ ኦይጬዛ። የሱሳ ኡንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ስኦይታ፥ ጹንꬅ ፐንገር ገሎዳይስ ቡትቶይታ። ጋምታይ ገሎዳይስ ኮይዛ ዝን ኡንትስ ሀናሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ኬꬅ ጎዳይ ደንዲ ፐንገ ጎርደዛይፐ ጉየ ‹ኑስ ዶዮዬ› ዬግታር ባለ ኤቂ ጼስ አይኮዳ። ዝን ኤ፥ ‹ይ ኦናዛኮኔ አናፕ የኤዛኮ ታ ኤሮያ› ግ ማሆዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","የ ዎደ ይ፥ ‹ኔር ዎላ ሜዛ፥ ኡዤዛ፥ ኑ ደንባይዳካ ነ ታማርሴዛ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«ኤ ማሂ፥ ‹ይ ኦናዛኮኔ አናፕ የኤዛኮ ታ ኤሮያ። ይንታኖ፥ ኢታ ባዝ ኦꬅዝታዮ ታፕ ሃኮይታ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","አፍራመ፥ እሳቃ፥ ያይቆባራኔ ናብታ ኡብታ ጾሳ ካተትꬃይድ ይ በአዳ፥ ዝን ይ ባለ ዎꬊ አትኮ ይንትስ ዬፎኔ አች ጮንቺ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","አሳይ አዋ ከሳፐ፥ አዋ ገሎፐ፥ ፑደ ባጋፐ ሱለ ባጋፐ ይኢ ጾስ ካተትꬃ ሙንታል አፋ በቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","የይ ግሾስ፥ ጉየቴዝታይፕ ቲና ማቆድታይ፥ ቲኔዝታይፕ ጉየ ማቆድታይ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","የ ዎደ ፈርሳውታይፕ ፐታይ ፐታይ ይኢ፥ «ሄሮዶሳ ነና ዎꬎዳይስ ኮይዝ ግሾስ Ꮊ በሳፕ ደንዲ ቅቶባ» ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ኤ ማሂ፥ «Ꮊንጊ፥ የ ዎርካንታይስ ዬዛኮ፥ ‹Ꮊይኖኔ ዎንታ ቱና አያንታ ከሶዳ፥ ሀርግንቴዝታ ፓꬆዳ፥ ሃይꬓንꬆ ጋላሳር ሃሶዳ› ዬጌዛ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ሀኖፕ አትን፥ ናባይ የሩሳላመፕ ሀራ አቆ Ꮊይቆዳይስ ቤዞያ። የይ ግሾስ፥ Ꮊይኖ፥ ዎንታኔ ዎንቲ ፔዢ የ በሳ Ꮊማዳይስ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«የሩሳላመ፥ የሩሳላመ፥ ናብታ ዎꬍዛኔ፥ ኔኮ ኪትንቴዝታ ሹቻር ሾጭዛኔ፥ ሹጉላ ፋ ናእታ ፋ ቀፋይፕ ኦሞር ሺሽዛይ ጋርክ ነ ናእታ ታ ታ ሹጳይፕ ኦሞር ኣፑን ቶኬ ሺሾዳይስ ኮየኔ፥ ዝን ይ እጼዛ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ታ ይንትስ ኦድዛ፤ ይ ኬꬃይ ካይሳቶዳ። ጎዳይ ሱንꬃር ይእዛይ አንጅንቴዛያ ይ ጎድ ጋꬆ ታና ደንጋሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ማላ ጋላስ የሱሳ ፐቲ ፈርሳውታይ ሀላቃይ ካራ ካꬃ ማዳይስ ገሎዳር አሳይ ኤ አብ ኡድዛክ በአዳይስ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","የ አቃይድ ሻዉሄ ሀርገር መትንትዛ ፐቲ አስ ኤዝስ ቲና ባጋር ዎይኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","የሱሳ ፈርሳዉታይኮኔ ህገ አስታማርታይኮ፥ «ማላ ጋላስ ሀርግንቴዝ አስ ፓꬅዛይ ዎጋኔ ዎጋ ባሳ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ኡ ስእ አቴዛ። የሱሳ ሀርግንትዛ አꬃ ቦቺ ፓꬅ ሞይዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","«ማካ ይንታፕ ፐታይስ ናአ ዎይ ገማተ ማላ ጋላስ ሆቦ ዎꬍኮ ኤልሲ ከሶዛይ ኦኖ» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ኡ ፐትባዝካ ማሆዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","የሱሳ እማቶስ ጼግንቴዝታይ ቦንቾ አቆ ዶሮዳር ብኢ፥ Ꮊ ኣዝሳ ኦዴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ፐቲ አሲ ነና ቦስ ካራ ጼግኮ ቦንቾ አቆ በትፐ። ኔፕ ኣꬊ ቦንችንትዛ አሲ ጼግንቶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ይንታን ናምእታካ ጼጌዛይ ይኢ፥ ‹ነ አቃ Ꮊ እማꬃይስ ዳኮባ› ዬግዝ ዎደ ነ ዬላትታር ሱል ዎꬋዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ማቆዝን፥ ነ ጼግንቴዝ ዎደ ቲናቲ ዝቃ አቆ ብኢ በቶባ። ጼጌዛይ ይኢ፥ ‹ታ ላጋዮ፥ Ꮊ ቦንቾ አቃይድ በቶባ› ዬጎዳ። የ ዎደ ኔር ዎላ ጼግንቴዝ አሳ ኡባይ ቲና ነ ቦንችንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ፋና ሾክ ሾክ ኡድዝ ኡቢታይ ካዉዦዳ፤ ፋና ዝቅ ዝቅ ኡድዝ ኡቢታይ ሾክ ሾክ ጎዳ።» ");
INSERT INTO mfxe_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ማካ የሱሳ ኤዛ ሞኬዝ ካራ አዳይኮ፥ «ቁማ ዎይ ካሆ እማቶ ጼግዝ ዎደ ኔኒ ኩሸ ማሆ ጼጋማይ ጋርክ ነ ላግታ ዎይ ነ እሽታ ዎይ ነ ዳብታ ዎይ ነ ዱረ ሾርታ እማቶ ጼግፐ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ማቆዝን፥ ነ እማቶ ማኬዝ ዎደ ማንቅታ፥ ዎብታ፥ ስልታኔ ቶእታ ጼጎባ፤ ነ አንጅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ꮊይትታይ ኩሸ ማሆዳይስ ዳንዳኦዋ ግሾስ ኩሸ ማህꬃይ ጌሽታይ ደንዶ ጋላስ ጾሲ ኔስ ማሆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","የሱሳር ዎላ እማቶል አፋ በቴዝታይ ጋንጨፐ ፐታይ የያ ስኢ፥ «ጾሳ ካተትꬃይድ እማቶል አፋ በቴዛይ አንጅንቴዛያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","የሱሳ፥ «ፐቲ አስ ዳማ እማቶ ጊግሲ ጋመ አስታ ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","እማቶ ሞክንትዛ ሳታት ሄልዝ ዎደ ጼግንቴዝ እማꬅታ፥ ‹ዬዛኮ ኡባ ባዝ ጊጌዛ፥ Ꮊና የኦይታ› ዬጊ ጼጎድ ጋርክ ፋ አይላ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«ዝን ኡቢታይካ ፋ ሳላምበ ሳላምበ መꬌዛ። ፐታይ፥ ‹Ꮊት ታ ሀጋ ጋደ ዎንጌዝ ግሾስ Ꮊንጊ በአዳይስ ኮሽዛ ሀያና ታና አሾዬ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ꮊንካይ፥ ‹እችን ዋጻ ገማተ ዎንጌዛ ኡንታን ዋጺ ፋጪ በአድ ግሾስ ሀያና ታል ላንጭፐ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ማ Ꮊንካይ፥ ‹ታኒ ሀጋ መዳል የዝ ግሾስ የኦዳይስ ታስ ዳንዳእንታሚ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«አይላይ ማቂ ይኢ የያ ኡባ ፋ ጎዳይስ ኦዴዛ። የ ዎደ ቦስ ጎዳይ ካጭንቲ አይላይኮ፥ ‹ኤልሲ ካታማ የዝ ጎስታይላኔ ሁሳ ኦግታይል Ꮊንጊ፥ ማንቅታ፥ ዎብታ፥ ቶእታኔ ጉንዴዝታ Ꮊና ኮኦባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«አይላይ፥ ‹ታ ጎዳዮ፥ ነ ኪቴዛይ ኡቢታይ ፖልንቴዛ፥ ዝን Ꮊተካ አቆ የዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«ጎዳይ አይላይኮ፥ ‹ጎስታይል አፋኔ፥ ካራ ጋንጨ ኦገል ከዞባ፥ ታ ኬꬃይ ኩሞድ ጋꬆ በንቴዝ ኡቢታይ የኦድ ጋርክ ኡዶባ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ታ ይንትስ ኦድዛ፤ እማትንቲ አቴዝታይፕ ኦንካ ታ አታላይፕ ማምዛና ኤሮይታ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ጋመ አሳይ ኤዛር ዎላ Ꮊማዳር የሱሳ ኡንትኮ ጉየ ማቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ታኮ ይእዝ ኡቢታይ ፋ አዳኔ ፋ እንዶ፥ ፋ ማቻቶኔ ፋ ናእታ፥ ፋ እሽታኔ ፋ ምሽታ፥ ሀራ አቶዝን ፋ ሸምፖ እጾዛይ ታ ታማረ ማቆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ፋ ማዝቃለ ቶኪ ታና ካሎዋ ኦንካ ታ ታማረ ማቆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ይንታፕ ፐቲ አሲ ሹች ኬꬅ ኬጾዳይስ ኮይኮ፥ ኬꬅ ኬጺ ዉርሶዳይስ አብ ጋርክ ሚሸ ኮሽዛኮ ቲናቲ ኤሮዳይስ ቆፖዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","የያ ማቀካ አትኮ፥ Ꮊ አꬃይ ባሶል ሹች ሂጽን ዉርሶ ጋምኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ብእዛ ኡባይ፥ ‹Ꮊ አꬃይ ግምብꬅ አይክን ዉርሶዳይስ ኤዛ ጋሜዛ› ዬጊ ቦርዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«ዎይ ፐቲ ካታይ ሀራ ካታር ኦልንቶዳይስ ደንድታር ላታም ሙኩለ ኦላንችታ ኤኪ የ በሳ ካታይር ታጲ ሙኩለ ኦላንችታር ኤቅንቶዳይስ ዳንዳኦዳናኔ ዳንዳአምዛ ቲናቲ በቲ ዞርንቶዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ኤቅንቶዳይስ ዳንዳእንቶዋ ባዝ ማቅኮ፥ የ ሀራ ካታይር ሃኮር የዝን ዳቦቶዳይስ ቲናቲ ጭማ ዳኪ ኦይጭሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","የይ ጋርከ፥ ይንታፕ ኦንካ ፓስ የዛ ባዝ ኡብታ አሻም እጽኮ ታ ታማረ ማቆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«ማጽነ ሎኦ፥ ዝን ማጽነ ፋ ማልአ አሽኮ፥ ዋይዚ ማጽነ ጊንትንቶዳይስ ዳንዳእኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ቢታስካ አራድሶስካ ማዶዋ ባዝ ማቅዝ ግሾስ አላ ኦልንቶዳ። ይኬ፥ ስእዝ ሀየር የዝ አስ ስኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ፐቲ ጋላስ ቃራጸ ጋችሽዝታይኔ ናጋራ ኦꬅዝ አሳይ የሱሳ ትምርታ ስኦዳይስ ኤ ላንቃይር ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ዝን ፈርሳውታይራኔ ህገ አስታማርታይ፥ «Ꮊ አꬃይ ናጋራንችታ ሺሺ ኤክዛ፥ ኡንታር ዎላ ሚዛ» ዬጊ ዝግሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","የሱሳ ዬጊ Ꮊ ኣዝሳ ኡንትስ ኦዴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ይ ጋንጨፐ ፐታይስ ጼት ዱርታይ የዛ ባዝ ማቅኮ ኡንታፕ ፐታይ ꬋብኮ ኡዱፉን ታማኔ ኡዱፉንታ ዎራ አሺ ꬋቤዛና ደንጎድ ጋꬆ ኮዮዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ደንጌዝ ዎደ ኡፋይቲ ፋ ጋናል ቶኪ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ፋ ካራ ማቅዛ። ፋ ላግታኔ ሾርታ ዎላ ጼጊ፥ ‹ꬋቤዝ ታ ዱራ ደንጌዛ፥ ታር ዎላ ኡፋይቶይታ› ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","የይ ጋርከካ፥ ማሮትꬅ ገሎዋ ኡዱፉን ታማኔ ኡዱፉን ጽልታይፕ ፋ ናጋራስ ማሮተꬅ ገልዝ ፐቲ አꬃይ ግሾስ ሳሎ ዳሞ ኡፋይስ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«ዎይ ታጲ ሹቻ ብራ የዛ ፐቲ አስታ ታጵፕ ፐታት ꬋብኮ ደንጎድ ሄሎዳይስ ጾምፐ አይꬂ ኬꬅ ፕቲ ሚንꬂ ኮዮዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ደንጌዝ ዎደ ፋ ላግታኔ ፋ ሾርታ ጼጊ ‹ꬋቤዝ ታ ሹቻ ብርቶ ደንጌዝ ግሾስ ታር ኡፋይቶይታ› ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ስኦይታ፥ የይ ጋርክ ፐቲ ማሮትꬅ ገልዝ ናጋራንቻይር ጾሳ ኪታንችታይ ቲና ኡፋይስ ማቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ማቂ የሱሳ፥ «ፐቲ አꬃይስ ናምኢ ናእታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ኡንታፕ ጌዶ ናአይ ፋ አዳይኮ፥ ‹ታ አዳዮ፥ ነ ሻላይፕ ታ ባጋ ታስ እንጎባ› ዬጌዛ። አዳይ ፋ ሻላና ፋ ናእታይስ ሻጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ጽቃ ጋላሳፕ ጉየ ጌዶ ናአይ ፋ ባጋ ኡብታ አጪ ኤኪ ሃኮ ጋደ Ꮊንጌዛ። ኤዛይድ ኤኪ Ꮊንጌዝ ሻላና ቶቺ ዉርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ኤ ፓስ የዛ ባዝ ኡብታ ዉርሴዛይፕ ጉየ የ ጋዳይድ ኡባይል ሚንꬅ ናየ ገልን መትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","የይ ግሾስ፥ የ ጋደ አሳይፕ ፐታይ ካራ ጋታ ገሌዛ። አꬃይ ኤዛ ጉዳይለ ሄማድ ጋርክ ፋ ሞꬃ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ጉዳይልታይ ሚዝ ሀርቃይፕ ማዳይስ አሞቴዛ፥ ዝን እዞካ ኤዝስ እንግዛ አሲ በንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ፋ ዎዝናር፥ ‹ኣፑን ታ አዳይ አይልታይስ ካꬃ አላ አትን ታ Ꮊይዳ ናየር Ꮊይቀ?› ");
INSERT INTO mfxe_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ደንዲ ታ አዳይኮ Ꮊንጊ፥ ‹ታ አዳዮ፥ ሳሎ ጾሳ፥ ሳአ ነና ታ ቆሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ꮊንፕ ነ ናአ ግንትንቲ ጼግንቶዳይስ ታስ ቤዞዋ ግሾስ ነ ካራ የዝ አይልታይፕ ፐታይ ጋርክ ኡዲ ታና ታይቦባ› ዬጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","የይ ግሾስ፥ ደንዲ ፋ አዳይኮ Ꮊንጌዛ። «ሀኖ ዝን፥ ኤ ሀጋ ሃኮር የዝን አዳይ ቃꬊንቲ፥ ኤዝኮ ዎጺ Ꮊንጊ እድንጊ ዬሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ናአይካ፥ ‹ታ አዳዮ ሳሎ ጾሳ፥ ሳአ ነና ታ ቆሄዛ። Ꮊንፕ ገደ ነ ናአ ግንትንቲ ጼግንቶዳይስ ታስ ቤዞያ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«ኤ አዳይ አይልታ ጼጊ፥ ‹ኤልሲ ኡባፕ ሎኦ ማቄዝ አፍላ ክኢ ኤዛ ማእሲ፤ ኤ ብራꬋይዳካ ምግዶ፥ ኤ ቶካይድ ጫማ ኣꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ሞꬎ መሄ ክኢ ሹኮይታ፥ ማዳ፥ ኡፋይቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ታ ናአይ Ꮊይ Ꮊይቄዛ፥ ዝን Ꮊቴ ፓጼዛ፤ ꬋቤዛ፥ ዝን በንቴዛ› ዬጌዛ። የይፐ ጉየ፥ ኡፋይትꬂ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«የ ዎደ ባይራ ናአይ ዎታ ጋደ የዛ። ኤዛይፕ ይእታር ካራ ኡኮዳር የꬅኔ ዶንꬅ ጊርꬅ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","አይልታይፕ ፐታ ጼጊ ሀንዛይ አብዛኮ ኤሮዳይስ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","አይላይ፥ ‹ነ እሻይ ሳሮ የኤዝ ግሾስ ነ አዳይ ሞꬎ መሄ ኤዝስ ሹኬዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«ባይራ እሻይ ካጭንቲ ካራ ገሎዳይስካ ኮየካያ። አዳይ ባለ ከዚ ካራ ገሎዳይ ጋርክ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ዝን ኤ ፋ አዳይኮ፥ ‹ዬዛኮ፥ Ꮊይ ጋርክ ላይꬅ ታ ኔስ አይለት ነ ኪታፐ ፐቶካ ፓጭንቸካዛር ኔስ ኪትንትን ታ ታ ላግታይር ኡፋይቶድ ጋርክ ሀራ አቶዝን ፐቲ ሆጎ ዴሽ ታስ እንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ዝን፥ Ꮊይ ነ ናአይ ነ ሻላና ላምዝታይር ዶንጊ ዉርሲ ይእን ሞꬎ መሄ ሹኬነ ባይ› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«አዳይካ፥ ‹ታ ናአዮ፥ ነ ኡባ ዎደ ታር የዛ፥ ታባዝ ኡባይ ኔስ። ");
INSERT INTO mfxe_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ꮊይ ነ እሻይ Ꮊይቄዛ፥ ዝን ፓጼዛ፤ ꬋቤዛ፥ ዝን በንቴዛ። የይ ግሾስ፥ ጋመ ኡፋይቶዳይስ ቤዝዛ› ዬጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","የሱሳ ፋ ታማርታይኮ፥ «ፐቲ ዱረ አꬃይስ ኤዝፕ ኦሞር ፐቲ ሹማይ የዛ። የ ሹማይ ፋ ጎዳይ ሻላና ቶቼዛ ዬጊ ሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ሻሎ ጎዳይ ሹማ ጼግሲ፥ ‹ታኒ ዋግዝን ስአሬ? Ꮊንፕ ነ ታ ኬꬅስ ሹም ማቂ ኦꬆዳይስ ዳንዳኦዋ ግሾስ ታ ሻላና ታና ሄልꬆባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«የ ሹማይካ ፋ ዎዝናር Ꮊይ ጋርከ ዬጊ ቆፔዛ። ‹ታ ጎዳይ ታና ሹመትꬃይፕ ዎꬆድ ሀንዛ፥ ዎቲ አቆዳይስ ዎልቃ ባያ፥ ዎሲ ማዳይስ ዬላꬅዛ፤ የዝን ታ ዋይዞ? ");
INSERT INTO mfxe_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ሹማትꬃፕ ታና ዎꬍስኮ ዎደ አሳይ ታና ሞኮድ ጋርክ ኦꬆድ ባዝ ታ ኤርዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«የይ ግሾስ፥ ኤ ጎዳይ አጮ የዝ አሳ ፐታ ፐታ ጼጊ ክኢ ቲና አꬃይኮ፥ ‹ኔል አፋ ታ ጎዳይ አጮ ኣፑኒ የኔ?› ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«ኤ፥ ‹ጼት ኦታ ዛይተ አጮ የዛ› ዬጌዛ። «ሹማይ፥ ‹ዉለ ዋርቃታ Ꮊይሼ፥ ኤልሲ፥ እሻታም ኦታ ዛይተ አጮ የዛ ግ ጻፎባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«የይፐ ካል ናምእንꬃይኮ፥ ‹ኔስ ኣፑኒ የኔ?› ዬጌዛ። «ኤ፥ ጼት ጆንያ ‹ግስተ አጮ የዛ› ዬጌዛ። «ሹማይ፥ ‹ነ ዉለ ዋርቃታ Ꮊይሸ፥ ኤልሲ፥ ሆስፑን ታም ጆንያ ዬጊ ጻፎባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ሻሎ ጎዳይ አማንንቶዋ ሹማይ ኤ ብላማትꬃይስ ናሽቼዛ። Ꮊ አላማይ ናእታይ አስ አይꬃር ፖኦ ናእታይፕ ኣꬌዝ ዎዛናምታ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«የይ ግሾስ፥ ታ ይንትስ ኦድዛ፤ Ꮊ ዎርዶ ሚሻይ ዎርዶር በንቴዝ ዎዳይድ መꬍና ኬꬃ ይንታን ሞኮዳይ ጋርክ ሚሻይር ይንትስ ላግታ ዎንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ኡባይፕ ጽቃ ባዛል አማንንቴዛይ ጋመ ባዛል አማንንቴዛያ ማቅዛ። ማ ኡባፕ ጽቃ ባዛል አማንንቶዋዛይ ጋመ ባዛል አማንንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ይኬ፥ Ꮊ አላመ ሚሸል ይ አማንንታም እጽኮ ቱማ ሚሸ ይንትስ ኦኒ ሀዳራ እማደ? ");
INSERT INTO mfxe_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ይንቲ ሀራ አስ ሚሸል አማንንታም እጽኮ፥ ይ ቡዞ ሚሸ ይንትስ ኦኒ እማደ? ");
INSERT INTO mfxe_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«ፐቲ አይላይ ናምኢ ጎድታይስ ሞድንቶዳይስ ዳንዳኦያ። ፐታ እጽኮ Ꮊንካያ ቃꬍዛ ዎይ ፐታይኮ ሺቅኮ Ꮊንካያ ለቂዛ። የይ ጋርክ፥ ይ ጾስስኔ ሚሸስ ሞድንቶዳይስ ዳንዳኦያ።» ");
INSERT INTO mfxe_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ሚሸ ቃꬍዛ ፈርሳውታይ የያ ስኢ የሱሳና ቃልዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ኤ፥ «ይንቲ ይንታን አስ ቲና ጽልስዛ፥ ዝን ጾሳይ ይ ዎዝና ኤርዛ። አስ ቲና ቦንችንቴዛይ ጾስ ቲና ቦርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«ሙሰ ህጋይኔ ናብታይ ኪታይ ዋንሳ ሄሎዳይስ ይንትስ ኦድንትታር ጋምኤዛ። የይፐ ጉየ፥ ጾሳ ካተትꬃ ዎንግላይ ኦꬅታር ጋምኤዛ። አሲ ኡባይ የ አቃ ገሎዳይስ ዳፍንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ማቆዝን፥ ህጋይፕ ፐቲ ላፋ ፕዳለ አቶዳይፕ ሳሎራኔ ሳአር ኣꬍዛይ ሻዉክዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«ፋ ማቻቶ ዳኪ ሀራ ኤክዛ ኡባይ ዎድረ ላምዛ። ፋ አዝናይፕ አንጅቴዛኖ ኤኬዛይካ ዎድረ ላምዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«አልኦኔ ቡቁሮ አፍላ ማእዛ፥ ሳአ ሀንን ጋላስ ጋላስ ኡፋይሳር የዝ ፐቲ ዱረ አስ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ሀራ ማ ጋላይ ሙመር ማዱንጼዝ ፐቲ አላዛራ ግንትንትዝ ማንቃይ የ ዱረ አꬃይ ባለ ዶግንቲ አቴዛይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ናየፕ ደንዴዛይድ ዱረ አꬃይ ሌማተፕ ዎꬍዝ ጉፋ ማዳይስ አሞትታር የዛ። ሀራ አቶዝን፥ ካንታይ ይኢ ኤ ማዶꬃ ላእዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«የ ማንቃይ Ꮊይቄዛ፤ ኪታንችታይ ኤዛ አፍራመ ክኦ ካንጌዛ። ማ ዱረ አꬃይካ Ꮊይቂ ሞግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ስኦለ ኡንእንቲ የዝታር ꬎቅ ግ ሃኮር አፍራመኔ ኤ ክኦ የዝ አላዛራ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ኤ፥ ‹አዳዮ አፍራመ፥ ታስ ቃꬍንቶየ፤ Ꮊ ላꬅ ታማይ ጋንጨ ኤጽታር የዝ ግሾስ አላዛረ ፋ ብራ ጼራቶ ሃꬃ ዳኪ ታ እራንꬃቶ ላክꬆድ ጋርክ ሀያና ኤዛ ዳኮየ› ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«ዝን አፍራመ ኤዝኮ፥ ‹ታ ናአዮ፥ ነ ሳአ የሳይድ ሎኦ ባዝ ኤኬዛናኔ፥ ማ አላዛረ ኢታ ባዝ ኤኬዛና አካኮባ። ዝን Ꮊት ኤ Ꮊይዳ ኡፋይትዛ፥ ማ ኔኒ ዋይታር የዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ꮊ ኡባፕ ኣꬊ፥ ‹Ꮊይፐ ይንትኮ፥ ይንፐ Ꮊና ኑኮ ኣꬎዳይስ ኮይዝታይ ፒንጋም ጋርክ ኑስኔ ይንትስ ጋንጨ ዳማ ጋጋ የዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«ዱረ አꬃይ፥ ‹ታ አዳዮ፥ ዬዛኮ አላዛራ ታ አዳይ ካራ ኪቶድ ጋርክ ታ ነና ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ታስ እችን እሽታይ የዛ፥ ኡንትካ Ꮊ መቶ አቃ የአማይ ጋርክ ኡንትስ Ꮊንጊ ማርካቶ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«ዝን አፍራመ፥ ‹ኡንትስ ሙሰራኔ ናብታይር የዛ፤ ኡንቲ ኦዴዝ ባዝ ስኦ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«ዱረ አꬃይ፥ ‹አዳዮ አፍራመ፥ የይ ጋርክ ባያ፤ ፐቲ አሲ Ꮊይቆፕ ደንዲ Ꮊንግኮ ኡንቲ ማሮትꬅ ገሎዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«አፍራመ፥ ‹ሙሰኔ ናብታ ስአም እጽኮ፥ ሀራ አቶዝን Ꮊይቆፕ ፐቲ አሲ ደንዲ ኦድኮካ አማነና› ዬጌዛ።» ");
INSERT INTO mfxe_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","የሱሳ ፋ ታማርታይኮ፥ «አስ ꬉብꬂ ናጋራ ገልስዛባዝ ይእꬃይ አተና። ማቆዝን፥ ናጋራ ገሎድ ጋርክ ኦꬅዛ አꬃይ አየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","የ አꬃይ ጽቅታይፕ ፐታ ባልꬆዳይፕ ዎጻ ፋ ቆል አጪ አባ ጋንጨ ቅትኮ ኤዝስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","የይ ግሾስ ናግንቶይታ። «ነ እሻይ ናጋራ ኦꬅኮ ካጮባ፤ ቂራꬊ ማሮትꬃር ማቅኮ፥ ኤዝስ አቶ ጎባ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ፐቲ ጋላስ ላፑን ቶኬ ቆህ፥ ላፑን ቶኬ፥ ‹ታኒ ታ ቡታ ኤሬዛ ታና ማሮባ› ዬጊ ይእኮ ኤዝስ አቶ ጎባ።» ");
INSERT INTO mfxe_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ሀዋርታይ ጎዳይኮ፥ «አማኖ ኑስ ጉጆየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ጎዳይ፥ «ሳናፍጨ ኣፈ ጋርክ አማኖ ይንትስ የዝኮ ‹Ꮊ ዋላ ሾድንቲ አባ ጋንጨ ቱክንቶባ› ዬግኮ ይንትስ ኪትንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ጉጅካ የሱሳ፥ «ይ ጋንጨፐ ፐታይስ ዎትዛ ዎይ ዱረ ሄንግዝ አይለ የዝኮ ኦሶ ጋደፕ ዎይ ዉደፕ ካራ ማቃዳር ‹ኤለ ካꬃ ማዳይስ Ꮊና ይኢ በቶባ› ዬግዛይ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ባያ፥ ‹ታስ ካሆ ጊግሶባ፤ ታ ም፥ ኡዢ አሾድ ጋꬆ ኤቂ ሙዞባ። የይፕ ጉየ፥ ነ ማ ማዳኔ ኡዦዳ› ዬግንባሳ? ");
INSERT INTO mfxe_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ይኬ ጎዳይ አይላይ ኪታ ፖሌዝ ግሾስ አንጅኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","የይ ግሾስ፥ ይንትካ ኪታ ኡብታ ፖሌዝ ዎደ ‹ኑ ፓꬆዋ አይልታይ፤ ኦꬆዳይስ ቤዝዛ ኦሶ ፖሌዛ› ዬጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","የሱሳ የሩሳላመ Ꮊንግታር ሳማረስኔ ጋልላ ቢታስ ጋንጨር ቆእ ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ፐቲ ሄራ ገሎዳር ቦርቆንቶ ሀርገር አይክንቴዝ ታጲ አስታይ ኤዛና ደንጌዛ። ኡንትካ ሃኮ ኤቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«ጎዳ የሱሳ፥ ኑስ ቃꬍንቶየ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ኤ ኡንታን ብኢ «Ꮊንጊ ይ ጋላ አይሁድታይ ቄሰ ቤዞይታ» ዬጌዛ። ኡ ኦገር Ꮊንግታር ጌዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ኡንታፕ ፐታይ ፋ ጌዥꬃ ብኢ ꬎቅ ጌዝ ቃላር ጾሳ ቦንችታር የሱሳኮ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ኤዚ ሳማረ ቢታ አስ፥ ዝን የሱሳ ቶካይል አፋ ጹጉኒ ኤዛ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","የሱሳ፥ «ጌዤዛይ ታጲ አስታ ባሳ? የዝን፥ ኡዱፉንታይ አባ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ꮊ አላጋ አꬃይፕ አትን ሀራ ማቂ ጾሳ ጋላትዛ አስ በንተካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","አꬃይኮ፥ «ነ አማናይ ነና ጌሼዛ፤ ደንዲ ቅቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፈርሳወ አስታይ፥ «ጾስ ካተትꬃይ አይደ የኦዴ?» ግ የሱሳና ኦይጬዛ። ኤ፥ «ጾስ ካተትꬃይ ናጎር የኦያ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ማካ እዞ፥ ‹Ꮊኔ ዎይ ይነ ዬጎዳይስ ዳንዳኦያ። አብስ ጊኮ ጾስ ካተትꬃይ ይ ጋንጨ የዛ› » ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","የሱሳ ፋ ታማርታይኮ፥ «አስ ናአይ ጋላስታይፕ ፐታ በአዳይስ ይ አሞትዝ ዎዳይ የኦዳ፥ ዝን ይ በአሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","አሳይ፥ ‹ኤ የይድ የዛ› ዎይ፥ ‹Ꮊይዳ የዛ› ዬጎዳ፥ ዝን ኡንታን ካሊ Ꮊንግፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ዜልንꬂ ዜልንጊ ሳሎ ጋጻፕ ጋጻ ፖእስዛይ ጋርክ አስ ናአይ ይእꬅ ጋላሳይ የይ ጋርክ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ዝን የይ ሀኖዳይፕ ቲና አስ ናአይ ጋመ ዋዮዳይስኔ Ꮊ የለትꬃይድ እጽንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ኖሄ ዎደ ሀኔዛይ ጋርክ አስ ናአይ ዎዳይዳካ የይ ጋርክ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖሄ ማርካበ ገሌዝ ቃማ ሄሎዳይስ አሳይ ሚታራኔ ኡዥታር፥ ኤክታራኔ ገልታር የዝን ꬋብስዛ ሃꬃይ ይኢ ኡብታ ꬋብሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ሎጸ ላይꬃካ የይ ጋርክ ሀኔዛ። አሳይ ሚታራኔ ኡዥታር፥ ዎንግታራኔ ባይዝታር፥ ቱክታራኔ ኬጽታር፥ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ሎጸ ሶዶማፐ ከዜዝ ጋላስ ዲነ ግንትንትዝ ጹግዝ ታማ ሳሎፕ ቡኪ ኡባ ባዝ ꬋብሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","አስ ናአይ በንትዝ ዎደካ የይ ጋርክ ሀኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«የ ጋላስ ኦንካ ባለ የዛይ ኬꬃል የዛይካ ጋንጨ የዝ ባዝ ኤኮዳይስ ካራ ገልፐ። የይ ጋርከ፥ ጋደ የዝ አሲ አብስካ ካራ ማቅፐ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ሎጸ ማቻቶ አካኮይታ፤ ");
INSERT INTO mfxe_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ፋ ሸምፓቶ አሾዳይስ ኮይዝ አሲ ኦንካ ꬋብሶዳ፤ ፋ ሸምፓቶ ኣꬂ እንግዝ ኦንካ አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ታ ይንትስ ኦድዛ፤ የ ጋላስ ናምኢ አሳይ ፐቲ አርሳል ዎይአዳ። ፐታይ ኤክንቶዳ፥ Ꮊንካይ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ናምኢ ማችታይ ዎላ ጋጮዳር ፐታት ኤክንቶዳ፥ Ꮊንካት አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ናምኢ አሳይ ዎላ ጋደ ዎትዝታይፕ ፐታይ ኤክንቶዳ፥ Ꮊንካይ አቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ኡንቲ፥ «ጎዳዮ አና ኤክንቶዴ?» ዬጊ ኦይጬዛ። ኤ፥ «ጋዉጻ የዝ በሳ አንኮ ሺቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","የሱሳ ፋ ታማርታ አዛለካ ኡባ ዎደ ዎሶድ ጋርክ ታማርሶዳይስ ኮዢ ዬጊ ኣዝሶ ኦዴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«ፐቲ ካታማ ጾስስ ያሽቶዋ አስስካ ዬላቶዋ ፐቲ ዳይናይ የዛ ");
INSERT INTO mfxe_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","የ ካታማ ጋንጨ ፐቲ አምአት የዛ። እዛካ፥ ‹ታስኔ ታ ሞርካይ ጋንጨ የዝ ሞታ ፕርዶባ› ዬጊ ኡባ ዎደ የ ዳይናካ ዳቡርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ዳይናይ ጽቃ ዎደስ እ ኦዳ ስአም እጼዛ፥ ዝን ጉየፕ ፋ ዎዝናር ቆፕ፥ ‹ታኒ ጾስስ ያሽታም፥ አስስ ዬላታም እጽኮካ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ꮊ አምአት ታና ኡባ ዎደ ዋይꬅዛ ግሾስ እዝስ ፕርዶዳ፤ ዬጊ ቆፔዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ጎዳይካ፥ «ዉጨ ዳይናይ ጌዛና ይ ስኦይታ፤ ");
INSERT INTO mfxe_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ጾሳይ ቃማኔ ጋላስ ኤዝኮ ኡክዛ ፋ ማራጼዝታይስ ፕርዶሳ? ኡንታን ማዶዳይስ ጋምእኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ታ ይንትስ ኦድዛና ስኦይታ፥ ኤልሲ ፕርዶዳ። ማቆዝን፥ አስ ናአይ ይእዛ ዎደ ሳአል አማኖ ደማደሻ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ማ ማሂ፥ የሱሳ፥ ፋና ጌሻ አስ ጋርክ ኡዲ ጬቅንትዝታይስኔ Ꮊንክታ ቦርዝታይስ Ꮊይ ጋርከ ዬጊ ኣዝሶ ኦዴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«ናምኢ አስታይ ዎሶዳይስ ጾስ ካራ Ꮊንጌዛ። ፐታይ ፈርሳወ Ꮊንካይ ማ ቃራጸ ጋችስዝ አስ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ፈርሳዋይ ኤቂ ፓስ ዎስታር፥ ‹ጾሳዮ ታኒ Ꮊንክታይ ጋርክ ቦንቂዛ፥ ዡጫኔ ላምዛ አስ፥ ኡባራካ ማ Ꮊ ቃራጸ ጋችስዝ አꬃይ ጋርክ ባ ግሾስ ነና ታ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ሳምንታፕ ናምኢ ቶኬ ጾምዛ፥ ታ ደንግዝባዝ ኡባይፕ አስራታ ከስዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«ዝን ቃራጸ ጋችስዛይ ማ ሃኮር ኤቂ ሀራ አቶዝን ሳሎ ꬎቅ ግ በአዳይስ ያሽቲ ፋ ትራ ቆጽታር ‹ጾሳዮ፥ ታና ናጋራንቻና ማሮየ› ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ታ ይንትስ ኦድዛና ስኦይታ፤ ፈርሳዋይ Ꮊይ ቃራጸ ጋችስዛይ ጾስ ቲና ጌሽ ማቂ ፋ ካራ ማቄዛ። አብስ ጊኮ፥ ፋና ꬎቅ ꬎቅ ኡድዛ አስ ካዉዦዳ፥ ፋና ካዉሽዛ አስ ꬎቅ ꬎቅ ጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","የሱሳ ዱደ ናእታይል አፋ ፋ ኩሻ ጋዲ አንጆዳይ ጋርክ አሳይ ኤኮ ክእዛ። የሱሳ ታማርታይ የያ ብኢ አብስ የሱሳኮ ክእኔ ዬጊ ካጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ዝን የሱሳ ናእታ ፋኮ ጼጊ፥ «ናእታይ ታኮ የኦዳና ካይፐቴ፤ የኦ ጎይታ። አብስ ጊኮ፥ ጾስ ካተትꬃይ Ꮊይትታይ ጋርክ ሀኔዝታይስ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ታ ይንትስ ቱሮ ኦድዛ፤ ጾስ ካተትꬃ ዱደ ናእታይ ጋርክ ኤኮዛይ ኦንካ ኤዛይድ ገላሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","አይሁደ ሀላቅታይፕ ፐታይ፥ «ኬሃ አስታማራዮ፥ መꬍና ደኦ ደንጎዳይስ አብ ኦꬆ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","የሱሳ ኤዝኮ፥ «አብስ ታና ኬሃዮ ዬጊ ጼጌ? ፐቲ ጾሳፕ አትን ሀራ ኬሃ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ላምፐ፥ ዎꬍፐ፥ ካስትፐ፥ ዎርዶ ማርካትፐ፥ ነ አዳኔ ነ እንዳት ቦንቾባ ዬግዝ አዛዞ ኤርኔ» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","አꬃይካ፥ «የይትታ ኡባ ታ ናአትꬃፕ አይኪ ናግታር ጋምኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","የሱሳ የያ ስኢ «ዬዛኮ፥ ኔስ ፐትባዝ ፓጭዛ፤ ኔስ የዝ ባዝ ኡባ ባይዚ ማንቅታይስ እንጎባ፤ ሳሎ ነና ሻሎ ናግዛ። ዬዚ ማቂ ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ዝን አꬃይ የያ ስኢ ኤዝስ ጋመ ሻሎ የዛ ግሾስ ኢታ ቂራቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","የሱሳ አꬃ ብኢ፥ «ዱረ አስስ ጾስ ካተትꬅ ገሎ ዋይዚ ኡንኦደሻ! ");
INSERT INTO mfxe_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ዱረ ጾስ ካተትꬃ ገሎዳይፐ ግማለ ናርፐ ሉኮር ኣꬍዛይ ሻዉክዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","የያ ስኤዝ አስታይ፥ «የያ ማቅኮ ኦ አቶዴ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","የሱሳ፥ «አስስ ዳንዳእንቶዋ ባዝ ጾስስ ዳንዳእንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጵጽሮሳ፥ «ዬዛኮ ኑ ኑባዝ ኡባ አሺ ነና ካሌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","«የሱሳ ቱማ ታ ይንትስ ኦድዛ፤ ጾስ ካተትꬃይስ ግ ፋ ካራ ዎይ ፋ ማቻቶ ዎይ ፋ እሽታ ዎይ ፋ አዳኔ ፋ እንዳት ዎይ ፋ ናእታ አሼዛይ፤ ");
INSERT INTO mfxe_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ꮊ ዎዳይድ ጋመ ዳኮ፥ የኦድ አላማይድ መꬍና ደኦ ኤኮዛይ ኦንካ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","የሱሳ ታጶ ናምእታ ፋኮ ጼጊ፥ «አን የሩሳላመ ዎላ Ꮊማዳ፥ ናብታይ አስ ናአይ ባጋ ጻፌዝባዝ ኡቢታይ ኤዛይድ ፖልንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ኤ አይሁደ ባ አሳይስ ኣꬊ እንግንቶዳ። ኡ ኤዛ ቶቾዳ፥ ጫዦዳኔ ኤዛል አፋ ጩቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ኤዛ ጋራፌዛይፕ ጉየ ዎꬎዳ፥ ዝን ሃይꬓንꬆ ጋላስ ኤ Ꮊይቆፕ ደንዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ዝን ኤ ታማርታይ ያ ኡባይፕ ፐትባዝካ አካኬካያ። ኤ ጹራይ ኡንትስ ቆስንቴዝ ግሾስ ኤ ዋጌዛኮ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","የሱሳ ኢያርኮ ኡኮዳር ፐቲ ቶአ አꬃይ ኦገ ጋጻ በቲ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ቶአ አꬃይ አስታይ የ አቃይር ኣꬎዳር ስኢ፥ «የይ አባ?» ግ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ኡ፥ «ናዝረተ የሱሳ Ꮊይር ኣꬍዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ኤ፥ «ዳዉተ ናአዮ፥ የሱሳ፥ ታና ማሮየ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ቲን ቲን Ꮊንግዝታይ፥ «ሀይዞባ» ግ ቆዴዛ። ዝን ኤ፥ «ዳዉተ ናአዮ፥ ታና ማሮየ» ዬጊ ዳርሲ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","የሱሳ ኤቂ አꬃ ፋኮ ኮኦድ ጋርክ ኪቴዛ። አꬃይካ፥ ኤኮ ሺቅን፥ ");
INSERT INTO mfxe_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«ታ ኔስ አብ ኡዶድ ጋርክ ኮዬ?» ዬጊ ኦይጬዛ። ቶአይ፥ «ጎዳዮ ታ በአዳይስ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","የሱሳ፥ «ቦኦባ፥ ነ አማናይ ነና ፓꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","አꬃይ እዝር ብኢ አቴዛ። ጾሳ ቦንችታር የሱሳ ካሌዛ። አስ ኡባይ የያ ብኢ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","የሱሳ ኢያርኮ ገሊ ኣꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ኤዛይድ ዛኮሳ ግንትንትዝ ቃራጸ ጋችስዝታይ ሀላቃይ የዛ። ኤ ጋመ ዱረ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ኤ የሱሳ ኣያዛኮ በአዳይስ ኮዬዛ። ኤ ሃታ ማቄዝ ግሾስ አስ ዳሮትꬃይፕ ደንዴዛይድ የሱሳ በአዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","የሱሳና በአዳይስ ኮዢ ኤ Ꮊንግዛ ኦጋይስ ቲና ዎጺ Ꮊንጊ ፐቲ ጋሳረ ምꬃል አፋ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","የሱሳ የ አቃ ሄልታር ꬎቅ ግ ብኢ፥ «ዛኮሳ፥ Ꮊይኖ ታ ነ ካራ ፔዦዳይስ ቤዝዛ ግሾስ ኤልꬂ ዎꬎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ኤ ኤልሲ ዎꬊ ኡፋይሳር የሱሳና ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","የ አቃይድ የዝ አስ ኡባይ የያ ብኢ፥ «ናጋራንቾ ካራ ገሊ ሞክንቶዳይስ ሀንዛ» ዬጊ ዝግሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ማቆዝን፥ ዛኮሳ ኤቂ ጎዳይኮ፥ «ጎዳዮ፥ ዬዛኮ ታስ የዝ ሻሎ ኡባይፕ ባጋ ማንቅታይስ እማዳ። አሳፕ አብካ ዎርዶር ባልꬂ ኤኬዝባዝ ማቅኮ ኦይዲ ኩሸ ማሆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","የሱሳ ማ፥ «Ꮊ አꬃይ አፍራመ ናአ ማቄዝ ግሾስ Ꮊይኖ አቶትꬅ Ꮊ ካራ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","አስ ናአይ የኤዛይ ꬋቤዛና ኮዮዳይስኔ አሾዳይስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","አሳይ የያ ስእታር የዝን የሱሳ የሩሳላመ ኡኬዝ ግሾስ ጾሳ ካተትꬃይ Ꮊት ኡኬዛ ኣዜዝ ግሾስ ኡንትስ ኣዝሶ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","የይ ግሾስ፥ የሱሳ፥ «ፐቲ ዳማ አሲ የዛይ ፋስ ካተትꬂ ማዉተ ኤኪ የኦዳይስ ሀራ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ኤዝስ ኦꬅዝ አይልታይፕ ታጵታ ጼጊ ታጲ ምናኔ እንጊ ‹ታ ማቂ የኦድ ጋꬆ Ꮊ ሚሻይር ዛልኦይታ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«የ ጋደ አሳይ ኤዛ እጽዛ ግሾስ Ꮊ አꬃይ ኑል አፋ ካዉቶዳይ ጋርክ ኑ ኮዮያ ዬጊ አስ ኤ ጉየር ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«ማቆዝን፥ የ አꬃይ ካት ማቂ ፋ ቢታ ማቄዛ። የ ታጲ አይልታይ ኤ እንጌዝ ሚሻይር አብ ጋርክ ዛልእ ዎꬍሴዛኮ ኤሮዳይስ ኮዢ ኡንታን ጼግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«ቲናይ ይኢ፥ ‹ጎዳዮ፥ ነ ታስ እንጌዝ ሚሻይል ሀራ ታጶ ዎꬍሴዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«ኤ ጎዳይ፥ ‹ነኖ አማንንትዛ አይላዮ ነ ሎኦ ኦꬄዛ። ኔኒ ጽቃ ባዛል አማንንትዛ ግሾስ ኔስ ታጲ ካታምታይል አፋ ማዉተ እንጌዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«ናምአንꬃይካ ይኢ፥ ‹ጎዳዮ፥ ነ ታስ እንጌዝ ሚሻይ ሀራ እችን ዎꬌዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«ጎዳይ ኤዝኮ፥ ‹ነስካ ማ እችን ካታምታይል አፋ ማዉተ እንጌዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«ዬዛኮ ሃꬓንꬃይ ይኢ፥ ‹ጎዳዮ፥ ታ ቃንጾር ጻጺ ናጌዝ ነ ሚሽታ Ꮊናሾ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","አብስ ጊኮ፥ ነ ጋደካ ባዝ ኤክዛናኔ ነ ዘረካባዝ ማጽዝ ኢታ አስ ማቅዝ ግሾስ ኔስ ታ ያሽቴዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«ኤ ጎዳይ ማሂ፥ ‹ነኖ ኢታ አይላዮ ነ ዶናቲ ጋርክ ታ ነና ፕርዶዳ። ታ ጋደካ ባዝ ኤክዛናኔ ዘረካባዝ ማጽዝ ኢታ አስ ማቄዛ ነ ኤርኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ታ ይኢ ታ ሚሻ ዎር ኤኮድ ጋርክ ዛልእዛ አስስ አብስ እንገካሳ?› ");
INSERT INTO mfxe_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«ኤ ጎዳይ የ አቃይድ ኤቄዛይኮ፥ ‹ኤዛር የዝ ሚሻ ኤኪ ታጶ ዎꬍሴዛይስ እንጎይታ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«ኡንቲ፥ ‹ጎዳዮ፥ ኤዝስ ብንካ ታጲ ምናናይ የዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«ጎዳይ፥ ታ ይንትስ ኦድዛ፤ ‹የዛ ኡባይስ ሀራ ጉዥንቶዳ፥ ዝን ባዛይፕ ሀራይ አቶ ኤዝስ የዛናካ ኤክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ማቆዝን፥ ታ ኡንታል አፋ ካዉታማይ ጋርክ ኮዬዝታ የ ታ ሞርክታ Ꮊና ታ ቲና ክኢ ዎꬎይታ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","የሱሳ የያ ኦዴዛይፕ ጉየ ኡንታፕ ቲና ኣꬊ የꬍታር የሩሳላመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ደብሬዘይተ አምባል አፋ የዝ ቤተፋገኔ ብታና ኡክታር ፋ ታማርታይፕ ናምእታ ዬጊ ኪቴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«ይ ቲና የዝ ሄራ Ꮊንጎይታ፥ ይ እዘ ሄሎዳር ኦንካ ቶግበኤካ አጭንቲ የዝ ሀረ ናአ ይ ደማዳ። ኤዛ ብሊ Ꮊና ኤኪ የኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ኦንካ፥ ‹አብስ ብሌ?› ግ ኦይጭኮ፥ ‹ጎዳይ ኤዛ ኮይዛ› ዬጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ኪትንቴዝታይ Ꮊንጊ ኤ ጌዛይ ጋርክ ሀንን በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ኡንትካ ሀረ ናአ ብሎዳር ጎድታይ ብኢ፥ «ሀረ ናአ አብስ ብሌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ኡንቲ ማሂ፥ «ጎዳይስ ኤ ኮሽዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ኤዛይፕ ሀረ ናአ የሱሳኮ ከኤዛ። ፋ አፍላ ሀረ ናአይ ዞካይል ህጺ የሱሳና ቶግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","አሳይካ ኤ Ꮊንግዛ ኦጋይል አፋ ፋ አፍላ ሂጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ደብሬዘይተ ደረል ሱለꬅ የሩሳላመ ዎꬍስዝ ኦገኮ ኡኮዳር ታይቦር ጋመ አሳይ ኡንቲ በኤዝ ማላታይስ ኡፋይቲ ፋ ቃላ ꬎቅ ኡዲ፥ ጾሳ ጋላታ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«ጎዳይ ሱንꬃር ይእዛ ካታይ አንጅንቴዛያ ሳሎ ሳሮ፥ ኡባፕ ꬎቀ ሳሎ ቦንቾ፥ ጾሳይስ ማቆ» ዬጊ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","አሳይ ጋንጨፐ ፐቲ ፐቲ ፈርሳወ አሳይ የሱሳኮ፥ «አስታማራዮ፥ ነ ታማርታ ሀይዝሶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ኤ ኡንትኮ፥ «ኡንቲ ስኤ ጊኮ ሹችታይ ኡኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","የሱሳ የሩሳላመ ኡክታር ካታማ ብኢ እዝስ ዬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«ነ ሳራይስ ማቃዳና Ꮊይኖ ነ ኤረካያ፥ Ꮊተካ ነ ኣፋይፕ ቆስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ነ ሞርክታይ ነ ካላ ጋሲ ፋ ኦገር ኦገር ነና ማር ኡንእꬅዛ ዎደ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ነናኔ ነ ጋሰ ግዶ የዝ ነ ናእታ ꬋብሶዳ። ፐቲ ፐቲ ሹች ደንꬂ ላሎዳ፥ አብስ ጊኮ ጾሳይ ነና አሾዳይስ ይእዝ ዎዳ ነ ኤረካዛይ ግሾስ» ዬጊ እዝስ ዬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","የይፐ ጉየ፥ የሱሳ ጾሳ ኬꬅ ገሊ ዛልእዝታ ኤዛይፕ ባይኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ማ፥ «‹ታ ኬꬃይ ጾሳ ዎስዛ ኬꬅ ማቃዳ› ግ ጻፍንቴዛ፥ ዝን ይ ታ ኬꬃ ፓንታይ ኮምኦ ኡዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ጋላስ ጋላስ ጾሳ ኬꬃ ታማርስዛ። ቄሰ ሀላቅታይ፥ ህገ አስታማርታይኔ ጋደ ጭምታይ ኤዛ ዎꬎዳይስ ኦገ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ማቆዝን፥ አሲ ኡባይ ኤ ትምርታ ፋ ዎዝናስ ኣꬂ ስእዝ ግሾስ ኡንትስ ኦꬆድ ባዝ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ፐቲ ጋላስ የሱሳ ጾሳ ኬꬅ ጋንጨ አሳ ታማርሶዳራኔ ዎንግለ ማርካቶዳር፥ ቄሰ ሀላቅታይ፥ ህገ አስታማርታይኔ ጋደ ጭምታይ ዎላ ኤዝኮ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«ነ Ꮊይትታ አባ ማዉተር ኦꬅዛኮ ኑስ ኦዶባ። Ꮊ ማዉታ ኔስ እንጌዛይ ኦኖ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ኤ ኡንትኮ፥ «ታካ ይንታን ፐትባዝ ኦይጮዳ፥ አን ታስ ማሆይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ጻማቅዛ ዋንሳ ጽንቃታይ ጾሳፐነ አሳፔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ኡ ዎል ጋንጨ ዬጊ ቶቤዛ፦ «ጾሳፕ ጊኮ የዝን፥ አብስ አማነካሳ?» ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","«አሳፕ ጊኮ፥ አሲ ኡባይ ዋንሳ ናበ ማቅዛና አማንዛ ግሾስ ኑና ሹቻር ሾጮዳ።» ");
INSERT INTO mfxe_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","የይ ግሾስ፥ «አናፐዛኮ ኑ ኤሮያ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","የሱሳ ማሂ፥ «ይኬ፥ ታካ አባ ማዉተር Ꮊይትታ ኦꬅዛኮ ይንትስ ኦዳሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","የይፕ ጉየ፥ የሱሳ ዬጊ Ꮊ ኣዝሳ አሳይስ ኦዴዛ፦ «ፐቲ አሲ ዎይነ ቱኬዛ። ዎትዝታይስ ማታየ እንጊ ጋመ ዎደ ጋምኢ የኦዳይስ ሀራ ጋደ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ዎይነ ኣፋ ማጽዛ ዎዳይ ሄልን ዎይነ ኣፋይፕ ኤዝስ ዳኮድ ጋርክ ቢታ ዎትዝታይኮ ፋ አይላ ኪቴዛ። ዝን ዎትዝታይ የ አይላ አይኪ Ꮊꬊ ካሎ ኩሸ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ማ ማቅካ ሀራ አይላ ኪቴዛ። ማ ቢታ ዎትዝታይ ኤዛ Ꮊꬊ፥ ቶቺ ካሎ ኩሸ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ꮊተካ ማሂ ሃይꬓንꬆ አይላ ኪቴዛ። ዎትዝታይ ኤዛካ Ꮊꬊ ማዱንꬂ ዎይኔ ጋንጫይፕ ጋጻ ከሲ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«ዎይነ ጎዳይ፥ ‹የዝን ታ አብ ኦꬆ? አን ማ ታ ቃꬍዛ ታ ናአ ዳኮዳ፤ ኦኒ ኤሬ ኡ ኤዛ ቦንቼካ አሻሚ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«ዝን ቢታ ዎትዝታይ አꬃይ ናአ ብኢ ‹Ꮊይ ኤዛ ላቶዳያ፥ Ꮊና የኦይታ ኤዛ ዎላ ዎꬎዳ፥ ዬዝኮ ላታይ ኑስ ማቃዳ› ዬጊ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ዎይነ ጋንጨፕ ጋጻ ከሲ ዎꬌዛ። የዝን፥ ዎይነ ጎዳይ የ አስታ ዋይሳዴ? ");
INSERT INTO mfxe_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ይኢ የ ቢታ ዎትዙንꬃን ዎꬎዳ፥ ዎይነ ጋዳና ሀራ አሳይስ እማዳ። አሳይ የያ ስኤዝ ዎደ ‹ሽንቻለ የይ ጋርክ ባዝ ሀንፔ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","የሱሳ ኡንታን ዳኪ ብኢ፥ «የዝን ‹ግምበ ኬጽዛ አሳይ ቦሬዝ ሹቻይ፥ ኬꬅ ሙመር ቶኪ አይክዝ ክርክሮ ጋርክ ኡባፕ አጵዝ ሹች ማቄዛ› ግንትንቲ ጻፍንቴዛይስ ብርሽꬃይ አባ? ");
INSERT INTO mfxe_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","የ ሹቻይል አፋ ዎꬍዝ ኡባይ ጋጭንቶዳ፥ ሹቻይ ኤዛል አፋ ዎꬍዝ ኡቢታይካ ጋጭንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ህገ አስታማርታይኔ ቄሰ ሀላቅታይ Ꮊ ኣዝሳይ ኦድንቴዛይ ኡንታል አፋ ማቄዛና ኤሪ የ ዎደ ኤዛ አይኮዳይስ ኮዬዛ፥ ዝን ዎያይስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","የይ ግሾስ፥ የሱሳ ጋደ አቅስዛ ኦሮመ ካታይስ ኣꬂ እማዳይስ ኮዪ ኤ ዶናፕ ቡታ ቃላ ናግዛ። የያ ፖልሶዳይስ ጌሽ አስ ኣዚ ቆህዝ አስታ ኤዝኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ኪትንቲ Ꮊንጌዝ አሳይ፥ «አስታማራዮ፥ ኔኒ ኦድዛይኔ ታማርስዛይ ልከ ማቄዛ፥ ማ ጾስ ኦገ ቱማትꬃር ታማርስዛኔ ኦናካ ሻኮዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ሀኖ ዝን፥ ኦሮመ ካታይስ ጊራ ጊሮዳይስ ቤዝነኔ ቤዞሳ?» ዬጊ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ዝን ኤ ኡ ዎዛና ኢታትꬃ ኤሬዝ ግሾስ ");
INSERT INTO mfxe_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«አን ታና ፐቲ ሳንተ ቤዞይታ፥ ኤዛል አፋር የዝ ምስላይኔ ሱንꬃይ ኦ ባዞ?» ዬጌዛ። ኡ ማሂ፥ «ቄሳሬሲ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ኤ ማሂ፥ «ዬዛኮ፥ ቄሳሬሳ ቄሳረስ፥ ጾሲሳ ጾስስ እንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","የይ ግሾስ፥ ኤ ማሄዝ ማልሳይፕ ዎያይ ቲና ቡታ ደንጎዳይስ ዳንዳኤካያ። ኡ ኤ ማህዝ ማልሳ ማላባዝ ግ ስኤ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ꮊይቆፕ ደንዶ ባያ ዬግዝ ሳዱቃውታይፐ ፐታይ ፐታይ የሱሳኮ ይኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«አስታማራዮ፥ ፐቲ አሲ ማቾ ኤኪ ናአ የለካዛር Ꮊይቅኮ፥ ኤ እሻይ የ ማቻቶ ኤኪ ናእታ የሊ ፋ እሻይስ ኮቺ አሾዳይ ጋርክ ሙሰ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ዬዛኮ ላፑን እሽታይ የዛ። ባይራይ ማቾ ኤኪ ናአ የለካዛር Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ኤ ካላይ እዞ ኤኪ ናአ የለካዛር Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ሃይꬓንꬃይካ የይ ጋርክ ሀኔዛ። ላፑንታይ ኡባይ Ꮊይ ጋርክ ሀኒ እዞ ኤኬዛ፥ ዝን ናአ የለካዛር Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ዉርስꬃል አስታካ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ይኬ፥ ላፑን እሽታይ እዞ ኤኬዝ ግሾስ Ꮊይቆፕ ደንድዛ ዎደ እዛ ኦ ማቾ ማቃዴ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","የሱሳ ማሂ፥ «አሳይ Ꮊ አላማይል ኤክዛኔ ገልዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ዝን Ꮊይቆፕ ደንዲ የኦድ አላማይል የዞዳይስ በዝዛ አሳይ ኤኮያኔ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ኡንቲ ኪታንቾ ጋርክ ማቅዝ ግሾስ ቲናፕ Ꮊይቀና። Ꮊይቆፕ ደንዴዝ ግሾስ ኡንቲ ጾስ ናእታ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ሙሰ ጎዳና፥ ‹አፍራመ ጎዳ፥ እሳቃ ጎዳ፥ ያይቆባ ጎዳ› ማቂ ቱሻ ዎራ ጋንጨ ጹግዝ ታማ ታርካ ጻፌዛይድ Ꮊይቄዝ አሳይ ደንድዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ኡባይ ኤዝስ ፓꬅ የዛ ማቅዝ ግሾስ ኤ ፓꬅ የዝታይ ጎዳይፕ አትን Ꮊይቄዝታይ ጎዳ ባያ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ህገ አስታማርታይፕ ፐታይ ፐታይ፥ «አስታማራዮ፥ ሎኦ ባዝ ነ ኦዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","የይፐ ጉየ፥ ሀራ ኦይች ኦይጮዳይስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ኤዛይፕ ማቂ የሱሳ ኡንትኮ፥ «አሳይ ክርስቶሳ ዋይዚ ዳዉተ ናአ ዬጌ? ");
INSERT INTO mfxe_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","አብስ ጊኮ፥ ዳዉተ ፋ ኡባስ ፋ ማዝሙረ ማጻፋይድ፥ «ጾሳይ ታ ጎዳይኮ ‹ታ ነ ሞርክታ፤ ነ ቶካይ የꬌዝ በሰ ኦꬆድ ጋꬆ፥ ታፕ ኡሻች ባጋር በቶባ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«ይኬ፥ ዳዉተ ክርስቶሳ፥ ‹ጎዳ ግ ጼግታር ኤዝስ ናአ ዋይዚ ማቄ?› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ዎያ ኡቢታይ ስኦዳር ፋ ታማርታይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«አዱስ አፍላ ማኢ ዩሸ ዶስዝታይፕ፥ ጋበ ጋንጨ ቦንቾ ሳሮꬆ፥ አይሁድታይ ዎሳ ኬꬃ ቦንቾ ኦይደ፥ ሞክንትዛ ካራካ ቦንቾ አቆ ኮይዝ ህገ አስታማርታይፕ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ኡንትካ አምእታይ ካራ ካሎስዛ፥ ጌሽ አስ ኣዚ አስ ቤዞዳይስ ዎሳ አዱስዛ። ኡ ኢታ ፕርደ ኤኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ዱረ አሳይ ጾስ ኬꬃ ሙጻታ ሳጽነ ኦሎዳር የሱሳ ꬎቅ ግ አሳ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ማ ፐቲ ማንቆ አምአት ናምኢ ስክና ኦሎዳር ብኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«ታ ይንትስ ቱሮ ኦድዛ፤ Ꮊ ማንቆ አምአት ኡባፕ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","አብስ ጊኮ፥ Ꮊ አሳይ ኡቢታይ ፋስ የዛ ባዛፕ እንጌዛ፥ ዝን እዛ ፋ ፓጫትፕ፥ ፓስ የዝ አቆ ፐሽ ኡባ እንጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","የሱሳ ታማርታይፕ ፐታይ ፐታይ ጾስ ኬꬃይ ጋመ ሎእዛ ሹቻራኔ አሳይ ጾስስ እንጌዝ እሞታር ሎኤዛና ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ዝን የሱሳ፥ «Ꮊ ይ ብእዛ ባዛይ ኡቢታይ ላልንተካዛር፥ ሹች ሹቻል አፋ ግምቢንቴዛይ ጋርክ አታም ዎደ የኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ኡንትካ፥ «አስታማራዮ፥ Ꮊ ኡቢታይ ሀኖዳይ አይደ? ማ Ꮊይ ሀኖዳይስ ማላይ አባ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","የሱሳ ዬጊ ኡንትስ ማልሰ እንጌዛ፦ «ባልንታማይ ጋርክ ናግንቶይታ። ጋምታይ፥ ‹ታኒ ክርስቶሳ፥ ዎዳይ ኡኬዛ› ዬግታር ታ ሱንꬃይር የኦዳ፥ ዝን ይ ኡንታን ካልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ይ ኦላ ባጋኔ ጫቦ ስኤዝ ዎደ ዳጋምፓተ። የይ ቲናቲ ሀኖዳይ አቶዋ ባዝ ማቅዝ ግሾስ ዎደ ዉርስꬃይ ኤልሲ የኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ማካ፥ «ዎያይ ዎያል አፋ፥ ካተትꬃይ ካተትꬃል አፋ ደንዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ግታ ቢታ ኤንኦ ሀኖዳ፥ ናየኔ ጋዶ ዱማ ዱማ በሳ ዳሮዳ፥ ያሽዝባዝኔ ጋመ ማላትታይ ሳሎፕ በንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ዝን Ꮊ ኡባይ ሀኖዳይፕ ቲና ታ ሱንꬃይ ግሾስ ግ አሳይ ይንታን ባይኦዳኔ አይኮዳ። አይሁድታይ ዎሳ ኬꬅ ጋንጨኔ አች ኬꬃ ይንታን ዳኮዳ። ካትታይ ቲናኔ ጋደ አቅስዝታይ ቲና ይንታን ካማዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","የይካ ታ ባጋ ይ ኡንትስ ማርካቶዳይስ ሎኦ ኦገ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","የይ ግሾስ፥ ይ ኦይጭንትዝ ዎደ ዋጊ ማልሰ እማደ ግ ይ ዎዝናር ኡንእንታም ጋርክ አካኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","አብስ ጊኮ፥ ይ ሞርክታይ ይንታር ኤቅንቶዳይስኔ ፓላሞዳይስ ዳንዳኦዋ ዶናኔ ኤጨትꬂ ታ ይንትስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ሀራ አቶዝን፥ ይንታን የሌዝታይ፥ ይ እሽታይ፥ ይ ዳብታይኔ ላግታይ ይንታን ኣꬂ እማዳ። ይ ጋንጨፕ ፐታ ፐታ ዎꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ታ ሱንꬃይ ግሾስ አሲ ኡቢታይ ቲና ይ እጽንቴዝታ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ዝን ሀራ አቶዝን፥ ይ ጭምባይፐ ፐቲ ብናናካ ꬋበና። ");
INSERT INTO mfxe_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ይ፥ ዳንዳአር፥ ይ ሸምፖ አሾዳ።» ");
INSERT INTO mfxe_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«የሩሳላመ ካታማይ ዎታዳርታይር ማርንቲ በቴዝን ይ ብእኮ እዝስ ꬋቦ ኡኬዛና ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","የ ዎደ ይሁዳ ግዶ የዝ ኡቢታይ አምባ ጉየ ቆስንቶ፥ ካታማ የዝታይ የይፕ ከዞ፥ ጋጻረ የዝታይ ካታማ ገልፐ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","አብስ ጊኮ፥ Ꮊ ጻፍንቴዝባዝ ፖልንቶድ ጋርክ የይ ጾሳይ ኩሸ ከስስ ዎደ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ሳአል አፋ ዳማ መቶ የኦዳ፥ የ ሳአይዳካ አሳል አፋ ጾስ ካቺ የኦዳ። የይ ግሾስ፥ ዎደጸዝታኔ ꬋንꬅዝታ አየ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ኡ ማሻር Ꮊይቃዳ፥ አሲ ኡቢታይ አላጋ ቢታ ድእንቶዳ። አይሁደ ማቀካ አስታ ዎዳይ ፖልንቶድ ጋꬆ የሩሳላመ ኡንታር የꬍንቴዛ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«አዋ፥ አግናራኔ፥ ጾልንትታይል አፋ ማላትታይ ሀኒ በንቶዳ። አባፐኔ ዙሎ ሾቻይፕ ደንዴዛይድ ቢታል የዝ አሳይ ያሽቲ ኡንእንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሳሎ ዎልቅታይካ ቡቅንቶዳይ ግሾስ አሳይ ያሻራኔ ቢታል አፋ አብ ሀነነሻ ግ ናጎር ፋና ዶጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","የ ዎደ አስ ናአይ ዎልቃራኔ ጋመ ቦንቾ ሻራር የኦዳር ኡ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ይ አቶትꬃይ ኡኬዝ ግሾስ Ꮊ ሀንታይ ፖልንቶ አይክዝ ዎደ ጊግንቲ ኤቆይታ፥ ꬎቅ ግ ቦኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ማ ማቅካ፥ Ꮊይ ጋርክ ግ ኣዝሶ ኦዴዛ፦ «ባላሰ ምꬅኔ ሀራ ምꬂ ኡባ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ኡ ሀያይ ፉርጮዳር ቦነ ኡኬዛ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","የይ ጋርክ Ꮊ ሀንታይ ፖልንቶዳር ይ ብእኮ ጾስ ካተትꬃይ ኡኬዛና ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«ታ ይንትስ ቱሮ ኦድዛ፤ Ꮊ ኡባይ ፖልንቶድ ጋꬆ Ꮊ የለትꬅታይ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ሳሎኔ ሳአ ኣꬎዳ፥ ዝን ታ ቃላይ ኣꬋሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«ይኬ፥ ይ ኡሺ ዳሮራኔ፥ ማꬄር የስስ ኡንእንቲ ይ ዎዝናይ አይክንታም ጋርከኔ የ ቃማይ አካኬካዝን ጽኬ ጋርክ ይንታል አፋ ሄላማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","የ ቃማይ ቢታል የዝ ኡባይል አፋ ሄሊ ጽክሲ አይኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","የይ ግሾስ፥ ይእዛ ኢታይፕ አቶዳይስኔ አስ ናአይ ቲና ኤቆዳይስ ዳንዳኦድ ጋርክ ኡባ ዎደ ሚንጊ ዎሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ጋላስ ጋላስ የሱሳ ጾስ ኬꬃ ታማርስታር፥ ቃማ ቃማ ደብሬዘይተ አምባል አፋ ከዚ አቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","አሳይ ኡቢታይ ኤዛ ስኦዳይስ ዎንት ጉራ ኤዝኮ ጾሳ ኬꬃ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","የ ዎደ ፋዝቃ ዬግንትዝ ቦራ ባለ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ቄሰ ሀላቅታይኔ ህገ አስታማርታይ አሳይስ ያሽቴዝ ግሾስ ዋይዚ የሱሳ ፋ ጋንጨፕ ꬋብሶዳዛኮ ኦገ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ጻላሄ ታጶ ናምእታይፕ ፐታ ማቄዝ አስቆሮንቶ ይሁዳ ግንትንትዛይ ጋንጨ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ይሁዳ ቄሰ ሀላቅታይኮራ ጾሳ ካራ ናግዝታይስ ሀላቅታይኮ Ꮊንጊ የሱሳ ዋይዚ ኣꬂ እንጎዳዛኮ ኡንታር ማቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ኡንትካ የይድ ኡፋይቲ ሚሸ እንጎዳይስ ኤዛር ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ኤዝካ የ ዞራይድ ጊጌዛ። ኡንትስ አሲ ኤረካዝን ኣꬂ እማዳይስ ጊጋ ዎደ ናግታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","የይፐ ጉየ፥ ፋዝቃ ዱር ሹክንትዛ ቦራ ባለ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","የሱሳ፥ «ፋዝቃ ካሆ ማዳይ ጋርክ Ꮊንጊ ኑስ ጊግሶይታ» ዬጊ ጵጽሮሳኔ ዋንሳ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ኡ፥ «ኑ አባ ጊግሶድ ጋርክ ነ ኮዬ» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ኤ ኡንትኮ፥ «ዬዛኮ ይ ካታማ ገሎዳር ሃꬅ ኦታ ቶኬዝ አꬃይ ይንታን ሄሎዳ። ኤ Ꮊንጊ ገልዛ ካራ ኤዛ ካል ገሎይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","የ ካራ አዳይኮ አስታማራይ፥ ‹ታ ታ ታማርታይራ ዎላ ፋዝቃ ካሆ ማዳይስ እማꬂ ሸምፕዛ ካራ አባ የኔ? ዬጌዛ› ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ኤ ፖቄል አፋ ሂጽንቲ ጊጊ የዝ ዳልገ ክፍለ ይንታን ቤዞዳ፥ ኤዛይድ ማኮይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ኡ Ꮊንጊ የሱሳ ጌዛይ ጋርክ ሀንን ደንጌዛ። ፋዝቃ ባለ ካሆ ኤዛይድ ጊግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሳታይካ ሄሌዝ ዎደ የሱሳ ሀዋርታይር ዎላ ካሆል አፋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ኤ ኡንትኮ፥ «ታ ዋየ ኤኮዳይፕ ቲና Ꮊ ካሃ ይንታር ማዳይስ ሎእꬂ አሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ይኬ፥ ስኦይታ! ጾስ ካተትꬃ Ꮊይስ ብርሽꬃይ ፖልንቶድ ጋꬆ Ꮊይኖፕ ጉየ Ꮊ ካሃ ማሂ ማሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ኡሻ ኤኪ ጋላቲ ማቂ፥ «Ꮊሽተ Ꮊያ ይ ጋንጨ ሻግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ስኦይታ! ጾስ ካተትꬃይ የኦድ ጋꬆ Ꮊይኖፕ አይኪ Ꮊ ዎይነ ኡሻይፕ ማቂ ታ ኡዣሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ቦራ ደንꬂ ኤኪ፥ ጋላቲ ማቂ፥ «Ꮊይ ይንትስ እንግንትዛ ታ አሾ። Ꮊያ ኦꬅታር ታና ቆፖይታ» ዬጊ ኡንትስ ባጺ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","የይ ጋርከካ፥ ካሆፕ ጉየ ኡሻ ኤኪ፥ «Ꮊ ኡሻይ ይንትስ ላልንቴዝ ታ ሱꬅ ማቅዝ ኦሮꬅ ጫቆ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ማቆዝን፥ ታና ኣꬂ እንጎድ አꬃይ ኩሻይ ታር ዎላ ፕልኦ ጋንጨ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","አስ ናአይ ኤዝስ ጊንትንቴዛይ ጋርክ Ꮊይቆዳይስ የዛ፥ ዝን ኤዛ ኣꬂ እንግዝ አꬃያ አየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ኡ ፋ ጋንጨ፥ «Ꮊያ ኦኒ ኦꬆዴ» ግ ዎል ኦይጭቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ማ ኡ ጋንጨ ኣꬎ ማቃዳይ ኦኖ ግዝ ፓላማ መꬍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","የሱሳ ኡንትኮ፥ «ጋደ ካትታይ ፋ አስታ ዎልቃር ሞድዛ፤ ፋ ጋደል አፋ ጎዳትዝታይካ ፋና፥ ‹ሎኦ ኦꬅዝታ› ዬግንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ዝን ይ ጋንጨ የይ ጋርክ ማቅፐ። ይ ጋንጨ ባይራትዛይ ካሎ ጋርክ ሀኖ፤ ካልꬅዛይ ካልዛይ ጋርክ ሀኖ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ሀኖ ዝን፥ ሞክዛይፐኔ ሞክንትዛይፕ ኣይ ኣꬌ? ሞክንትዛ ባሳ? ዝን ታኒ ይ ጋንጨ ሞክዛይጋርኬ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ይንትካ ታ መታይር ታፕ ሻክንቶዋ ታር ሚንጊ ኤቄዝታ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","ይ ታ ሌማተፕ ማድ ጋርክ፥ ኡዦድ ጋርከኔ ዙፋንታይል አፋ በቲ ታጶ ናምኢ እስሬለ ሼሽታይል አፋ ፕርዶድ ጋርክ ታ አዳይ ታና ሹሜዛይ ጋርክ ታካ ይንታን ታ ካተትትꬃይል ሹሞዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ማቅካ የሱሳ፥ «ስሞና፥ ስሞና፥ ጻላሄ ይንታን ግስተ ጋርከ ሀርቆዳይስ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ዝን ታኒ ነ አማናይ ꬋባም ጋርክ ኔስ ዎሴዛ። ኔካ ማቄዝ ዎደ ነ እሽታ ምንꬃꬆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ስሞና፥ «ጎዳዮ፥ ታኒ ኔር አጭንቶዳይስኔ Ꮊይቆዳይስ ጊግንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","የሱሳ ጵጽሮሳኮ፥ «ታ ኔስ ኦድዛ፤ Ꮊይኖ ሹጉላ ኡኮዳይፕ ቲና ነ ታና ሀይꬒ ቶኬ ካዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ማ ማቅካ፥ የሱሳ ኡንትኮ፥ «ታኒ ይንታን ኮሮጆ፥ ቁርቦኔ ጫማ ባዝን ኪቴዝ ዎደ ይንትስ ፓጬዝ ባዝ የኔ?» ዬጊ ኦይጬዛ። ኡ ማሂ፥ «አኮካ ፓጨካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ኤ ኡንትኮ፥ «Ꮊት ኮሮጆኔ ቁርቦ የዛይ አይኮ፤ ማሻ ባዛይ ፋ አፍላ ባይዚ ማሻ ዎንጎ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ꮊና ስኦይታ! ‹ዡጭታይር ታይብንቴዛ› ግንትንቲ ጻፍንቴዛይ ታል ፖልንቶዳይስ ቤዝዛ። ኤ፥ ታ ግሾስ ጻፍንቴዝባዝ ፖልንትዛይ ቱማተዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ኤ ታማርታይ፥ «ጎዳዮ Ꮊይዳ ናምኢ ማሻ የዛ» ዬጌዛ። ኤ፥ «ግዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","የሱሳ ካሴሳይ ጋርክ ደንዲ ደብሬዘይተ አምባል አፋ ከዜዝ። ኤ ታማርታይ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","የ አቃ ሄሌዝ ዎደ ይ «ፓጨ ጋንጨ ገላማይ ጋርክ ዎሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ኡንታፕ ሹች ꬎግን ሄልዛ አቆ ጋርክ ሃኪ ቡንቂቲ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«ታ አዳዮ፥ ነ ሸነ ማቅኮ Ꮊ መቶ ጹአ ታፕ ኣꬆባ። ዝን ታ ሸነ ማቅፐ ነ ሸናይ ሀኖ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ምንꬃꬅዛ። ኪታንቻይ ሳሎፕ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ጋመ ኡንእንቲ ሚንꬂ ዎስዛ። ኤ ጫዋይካ ሱꬂ ጾክዛይ ጋርክ ሳአ ጾኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","የሱሳ ዎሳ ዉርሲ ፋ ታማርታይኮ የኤዛ። ኡ፥ አዛኖፐ ደንዴዛይድ ዳቡሪ ገንቴዝን ደንጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«አብስ ገንቴ? ይ ፓጨ ጋንጨ ገላም ጋርክ ደንዲ ዎሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ኤ ሀጋ ኦዳል አፋ የዝን ጋመ አሳይ የኤዛ። ታጶ ናምእታይፕ ፐታይ ይሁዳ ግንትንትዛይ ኡንታን ካልꬅዛ። ኤ የሱሳ ዬሮዳይስ ላንቀ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ዝን የሱሳ፥ «ይሁዳ፥ አስ ናአ ዬሪ ኣꬂ እማደ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","የሱሳ ታማርታይ የ ሀና ብኢ፥ «ጎዳዮ ኑ ማሻር ጋቾ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ኡ ጋንጨፕ ፐታይ ቄሰ ሀላቃይ አይላይስ ሾጪ ኡሻች ሀይቶ ጋቺ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ዝን የሱሳ፥ «አሾባ!» ዬጌዛ። አꬃይ ሀያ ቦቺ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","የይፕ ጉየ፥ የሱሳ ፋና አይኮዳይስ የኤዝ ቄሰ ሀላቅታይኮ፥ ጾስ ኬꬅ ናግዝታ ሹምታይኮኔ ጭምታይኮ፥ «ፓኖ አይክዝ አስ ጋርክ ማሻኔ ጉፈ አይኪ የኤኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ኡባ ጋላስ ጾስ ኬꬅ ጋንጨ ታ ይንታር የዝ ዎደ ታል አፋ ኩሸ ጋደካያ ዝን Ꮊይ ꬉማ ካተትꬃይ ሞዴዝ ዎደኔ ይ ዎደ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","የይፐ ጉየ፥ የሱሳና አይኪ ቄሰ ሀላቃይ ዛባ ካንጌዛ። ጵጽሮሳ ሃኮር የሱሳና ካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","አሳይ ቄሰ ሀላቃይ ዛባይድ ታማ ኤꬂ ዎላ በቴዝን ጵጽሮሳ ኡንታር ዎላ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ፐቲ ጋꬊንዳታ ጵጽሮሳ ታማ ላንቀ በቴዛና ታማ ፎአይር ዳኪ ብኢ፥ «Ꮊ አꬃይ ኤዛር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ዝን ጵጽሮሳ፥ «Ꮊን አስቴ ታ የ አꬃ ኤሮያ» ዬጊ ካዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ጽቃ ሳተፕ ጉየ ፐቲ ሀራ አꬃይ ኤዛ ብኢ፥ «ኔካ ኡንታፕ ፐታባይ» ዬጌዛ። ዝን ጵጽሮሳ፥ «Ꮊ አꬃዮ ታና ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ፐቲ ሳተ ጋርክ ጋምኤዛይፕ ጉየ ፐቲ ሀራ አꬃይ ትልሲ፥ «Ꮊ አꬃይ ጋልላፕ ማቅዝ ግሾስ ስ ባይꬅ ኤዛር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ዝን ጵጽሮሳ፥ «Ꮊ አꬃዮ፥ ነ ግዛና ታ ኤሮያ» ዬጌዛ። ኤ የ ኦዳ ዉርሰካዝን ሹጉላ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ጎዳይ ጉየ ሽርንቲ ኤቂ ጵጽሮሳ በኤዛ። ጵጽሮሳ፥ «Ꮊይኖ ሹጉላ ኡኮዳይፕ ቲና ነ ታና ሀይꬒ ቶኬ ካዶዳ» ዬጊ፥ ጎዳይ ኦዴዝ ቃላይ ኤዝስ ኤልቂ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ጵጽሮሳስ ባለ ከዚ ዱካ ሱꬅ ዬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","የሱሳ ናግዝ አሳይ ኤዛ ላቃሶኔ Ꮊꬎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ኤ አፋ ጎዚ «አን ነ ናበዛኮ ኤሮባ፤ ነና ሾጬዛይ ኦኖ?» ዬጊ ኦይጭዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ሀራ ጋመ ጫሺ ጫዢ ካዉሽሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ሳአ ዎንትዛ ዎደ አይሁደ ጋደ ጭምታይ፥ ቄሰ ሀላቅታይኔ ህገ አስታማርታይ ሺቂ፥ የሱሳና ፋ ቲና ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ኡ፥ «ነ ክርስቶሳ? አን ኑስ ኦዶባ?» ዬጊ ኦይጬዛ። የሱሳ፥ «ታ ኦድዛኮን ይ አማናሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ታ ኦይጭዛኮ ይ ማሃሚ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ዝን አስ ናአይ Ꮊይፕ ገደ ዎልቃማ ጾስ ኡሻች ባጋር በቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","የ ዎደ ኡቢታይ፥ «የዝን፥ ነ ጾሳ ናአ?» ዬጌዛ። ኤ፥ «ታ ጾስ ናአ ማቄዛና ይ ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ኡ፥ «ይኬ፥ ሀራ ማርካ አብ ኮሼ? ኤ ፋ ዶናር ኦዶዳር ኑ ስኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","የ አቃይድ ሺቄዝ ኡቢታይ ደንዲ የሱሳና ጵላጾሳኮ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«Ꮊ አꬃይ ኑ አስታ ባለꬅታር፥ ኦሮመ ካታይስ ጊራ ጊራማይ ጋርክ ካይታራኔ ማ፥ ‹ታኒ ክርስቶሳ ይ ካታ› ዬጎዳር ኑ ደንጌዛ» ዬጊ ሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጵላጾሳ የሱሳና፥ «ኔኒ አይሁድታይ ካቶኔ?» ዬጊ ኦይጬዛ። የሱሳ፥ «ኤ፥ ነ ጌዛይ ጋርከ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ጵላጾሳ ቄሰ ሀላቅታይኮኔ አሳይኮ፥ «Ꮊ አꬃይል አፋ ታ ፐቲ ቡታካ ደንገካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ዝን ኡንቲ፥ «Ꮊ አꬃይ ጋልላፐ Ꮊያ ሄሎዳይስ ይሁዳ ሙመር ኢታ ባዝስ ደንꬅꬅዛ» ዬጊ ሚንꬂ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጵላጾሳ የያ ስኤዝ ዎደ የሱሳ ጋልላ አሶ ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","የሱሳ ሄሮዶሳ ጋደፕ የኤዝ አስ ማቄዛና ጵላጾሳ ኤሬዛይፕ ጉየ ሄሮዶሳ የ ዎደ የሩሳላመ የዝ ግሾስ ኤዝኮ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮዶሳ የሱሳ በአዳይስ ጋመ ዎደፐ ኮይታር የዝ ግሾ ኤዛ በኤዝ ዎደ ጋመ ኡፋይቴዛ። አብስ ጊኮ፥ ኤባዝ ስኤዝ ግሾ ማላባዝ ኡድን በአዳይስ አሞትታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ሄሮዶሳ የሱሳና ጋመ ኦይች ኦይጬዛ፥ ዝን ኤ አብካ ማሄካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ቄስታይ ሀላቅታይኔ ህገ አስታማርታይ ኤዛይድ ኤቂ ሚንꬂ ኤዛ ሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮዶሳራኔ ኤ ዎታዳርታይር የሱሳ ላቃሰር ለቄዛ። ቡቁሮ አፍላ ማእሲ ጵላጾሳኮ ማሂ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ሄሮዶሳራኔ ጵላጾሳር ቲን ሞርከዝን የ ጋላስ ዎላ እግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ጵላጾሳ ቄሰ ሀላቅታ፥ ጋደ አቅስዝታኔ ዎይታ ጼጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹Ꮊ አꬃይ ኢታ ባዝስ ደንꬅꬅዛ› ግ ታኮ ይ ከኤዛ። ታካ ይ ቲና ፕላጊ ብእን ይ ሺሼዝ ሞታይስ አባ ቡታካ ኤል ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ሄሮዶሳ፥ የይ ጋርክ አባ ቡታካ ኤዛል አፋ ደንገካ ግሾስ ኑኮ ዳኬዛ። ቱማ Ꮊ አꬃይ Ꮊይቆስ ሄልꬅዝ አባ ቡታካ ኦꬄካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","የይ ግሾስ፥ ኤዛ ጋራፊ ብሊ ዳኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","የያ ኤ ጌዛይ ፋዝቃ ባለ ዎደ ፐቲ አስ አቻፕ ኡንትስ ብልዛይ ኤዝስ አቶዋ ባዝ ማቄዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ዎያ ኡቢታይ ፐትፕ፥ «Ꮊ አꬃ ገደ ሀልእሶባ፥ ኑስ ባርባና ብሎባ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባና ካታማ ጋንጨ አስ ኢታ ባዝስ ደንꬅꬂ አስ ዎꬊ አጭንቴዝ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጵላጾሳ የሱሳና ብልኦዳይስ ኮዪ አሳይስ ማሂ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ማቆዝን፥ አሳይ፥ «ሶቶባ! ሶቶባ!» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ጵላጾሳ ሃይꬒንꬆ፥ «Ꮊ አꬃይ ቆሄዝ ባዛይ አባ? ዎꬎስ ሄልꬅዝ ቡታ ታ ደንገካያ። የይ ግሾስ፥ ጋራፊ ዳኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ኡ ፋ ቃላ ꬎቅ ኡዲ፥ «ሶትንቶዳይስ ቤዝዛ» ግ ሚንꬂ ኡኬዛ። ኡ ኡፋይካ ኡሳ ዳሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ኡ ኦይቻይ ግሾስ ግ ጵላጾሳ ኤዛል አፋ ፕርዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","አሳ ኢታ ባዝስ ደንꬅꬅዛኔ አስ ዎꬊ አጭንቴዛና ብሎድ ጋርክ ዎሴዝ፥ የ አꬃ ኡንትስ ብልኤዛ። ዝን የሱሳ ኡንቲ ኮዬዝ ባዝ ኦꬆድ ጋርክ ኡንትስ አꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","የሱሳና አይኪ ካማዳር ስሞና ግዝ ቀረና ቢታ አꬃይ ጋጻረፕ የኦዳር፥ ደንጊ ማዝቃላ ቶሲ የሱሳ ካሊ Ꮊማድ ጋርክ ጭጵቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ጋመ አሳይኔ ኡ ጋንጨፕ ፋ ትራ ቆጽታር ዬክዛ ማችታይ ኤ ጉያይር ካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ዝን የሱሳ ኡንትኮ ጉየ ማቂ፥ «ይንታኖ፥ የሩሳላመ ማችታዮ፥ ይ ኡባይስኔ ይ ናእታይስ ዬኮይታፕ አትን ታስ ዬክፓተ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹የዛኮ ꬎንꬅታይ፥ የለካ ኡልታይኔ አምሰካ አምታይ አንጅንቴዛ› ይ ዬጎድ ጋላሳይ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","የ ዎደ አምብታካ፥ ‹ኑል አፋ ዎዶይታ›፥ ደርታካ፥ ‹ኑና ቆሶይተ› ዬጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ይኬ፥ እርጻ ምንጻ የይ ጋርክ ኦꬅኮ መላ ምንጻ ዋይሳደሻ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ኤዛር ዎላ ዎꬎዳይስ ሀራ ናምኢ ፓንታ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ቄራንዮ ግንትንትዝ አቆ ሄልꬂ ሶቴዛ። ፓንታይፕ ፐታ ኡሻች ባጋር Ꮊንካ ሀድርስ ባጋር ሶቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","የሱሳ፥ «ታ አዳዮ፥ ኡ አብ ኦꬅዛኮ ኤሮዋ ግሾስ ኔኒ ኡንትስ አቶ ጎባ» ዬጌዛ። ኡ ኤ አፍላይል አፋ እጻ ኦሊ ሻክንቲ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","አሳይ ኤቂ በአዳር፥ ጋደ ሞድዝታይ፥ «ኤ ሀራ አሳ አሼዛ፤ ጾሳይ ማራጼዝ ክርስቶሳ ኤዛ ማቅኮ አን ፋና አሾ» ዬጊ ለቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ዎታዳርታይ ኤዝኮ ሺቂ፥ ጫላ ዎይነ ኡሽ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ዬዚ፥ «ኔኒ አይሁድታይ ካት ማቅኮ አን ነ ኡባ አሾባ» ዬጊ ለቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ኤዝስ ኦማ ባጋር፥ «Ꮊይ አይሁድታይ ካት» ዬግዝ ጹፈ ግርክꬆራ፥ ኦሮምꬆራ፥ እብራይስጽꬆራ ጻፊ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ሶትንቴዝ ፓኖ ፐታይ ጫሸ ሳአር ጎችታር፥ «አን ኔኒ ክርስቶሳ ማቅኮ፥ ነናካ ኑናካ አሾባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ዝን Ꮊንኮ ፓናይ፥ «ነ Ꮊይ ጋርክ ፕርዳር የዛር ሀራ አቶዝን፥ ጾስስ ያሽታሞ? ");
INSERT INTO mfxe_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ኑኒ ኑ ቡታይስ ቤዝዛ ፕርደ ኤክዛ፥ ዝን Ꮊ አꬃይ ፐቲ ኢታባዝካ ኦꬄካያ» ዬጊ ካጭንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ማካ፥ «የሱሳ፥ ነ ነ ካተትꬃር ይእዝ ዎደ ታና ቆፖባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","የሱሳ፥ «ታ ኔስ ቱሮ ኦድዛ፤ Ꮊይኖ ነ ታር ጋናተ የሳዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","የ ጋላስ ኡሱፑን ሳተፕ Ꮊንጊ ኡዱፉን ሳተ ጋꬆ አዋ ፖኦ ካዬዝ ግሾስ ቢታ ኡባይል አፋ ꬉማ ማቄዛ። ጾስ ኬꬅ ማጋራዣይ ፐርእንቲ ናምኢ አቆ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","የሱሳ፥ ቃላ ꬎቅ ኡዲ፥ «ታ አዳዮ፥ ታ ታ ሸምፓቶ ነ ኩሻይድ እንጌዛ» ዬጊ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ማቶ ሀላቃይ፥ ሀኔዛያ ብኢ፥ «Ꮊ አꬃይ ቱማካ ጌሻ» ዬጊ ጾስ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ꮊ ሀንዛባዛ በአዳይስ የ አቃይድ ሺቄዝ አስ ኡባይ ሀኔዝባዛ ብኢ ፋ ትራ ቆጽታር ፋ ካራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ማቆዝን፥ የሱሳ ላንቀ ኤርዛ አስ ኡባይ፥ የይ ጋርከካ ጋልላፐ ካል የኤዝ ማችታይ የያ ብእታር ሃኮር ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","አይሁደ ሻንግታይፕ ፐታይ፥ ዮሴፋ ግንትንትዝ አꬃይ የዛ። ኤ አርማትያሳ ግንትንትዝ ይሁዳ ካታማፕ የኤዛ። ኤ ሎኦኔ ጌሽ አስ ማቅዝ ግሾስ ጾሳ ካተትꬃይ ይእꬃና ናግዛ። ሻንግታይፕ ፐታ ማቅታር ኡ ዞረትꬃራኔ ኦሳይር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","የ አꬃይ ጵላጾሳኮ Ꮊንጊ፥ የሱሳ አሃ ሞጎዳይስ ታስ እንጎባ ግ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","የሱሳ አሃ ዎꬍሲ አፍላር ጻጼዛ። ዛላ ዎጪ ከሴዝ ሀራ አስ ሞግንተካ ኦሮꬅ ዱፎ ጋንጨ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ማላ ገሎድ ሀንዛ ግሾስ የ ጋላሳይ ጊግንቶ ቃማ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ጋልላፐ ደንዲ የሱሳ ካሊ የኤዝ ማችታይ ዮሴፋር ዎላ Ꮊንጊ ኤ አሃ ዋይዚ ሞግዛኮ ዱፋ አካኪ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ኤዛይፕ ማቂ ሽቶኔ ቅባተ ጊግሴዛ። ህገ ኪትዛይ ጋርክ ማላ ጋላስ ሸምፕ ፔዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ሳምንታፕ ቲና ጋላስ፥ ዎጋ ዎደ ጉራ የጭየጮ፥ ማችታይ ፋ ጊግሴዝ ሽቶ ኤኪ ዱፋይኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ኡ እዘ ሄሎዳር ዱፋይ ዶና የዝ ሹቻይ ጎልኣልኢ ሀልኤዛና ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ኡ ዱፋ ሄሊ ገሌዛ፥ ዝን ጎዳ የሱሳ አሃ ደንጌካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ኡ ኤዛይድ ኤቂ አቢ ሀነኔ ግ ቆፖዳር አካከካዝን ቦꬅ ፖጭዝ አፍላ ማኤዝ ናምኢ አስታይ ኡ ካለ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ማችታይ ያሽቲ ፋ ኦማ ሳአ ዝቂ ኡዲ የዝን፥ አስታይ ኡንትኮ፥ «ፓꬃና Ꮊይቅታይ ጋንጨ አብስ ኮዬ? ");
INSERT INTO mfxe_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","ኤ Ꮊይዳ ባያ፤ Ꮊይቆፕ ደንዴዛ፥ ‹አስ ናአይ ናጋራ ኦꬅዝታይ ኩሸ ኣꬊ እንግንቶዳ፤ ኡንትካ ኤዛ ሶቶዳ። ኤ ሃይꬓንꬆ ጋላስ Ꮊይቆፕ ደንዶዳ› ዬጊ፥ ኤ ይንታር ጋልላ ቢታ የዝታር ይንትስ ኦዴዝ ቃላ ቆፖይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ማችታይ የ ዎደ ኤ ቃላ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ማችታይ ዱፋይፕ ማቂ ሀኔዝባዛ ኡብታ ታጶ ፐትታይስኔ Ꮊንክታይስካ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","የያ ሀዋርታይስ ኦዴዛይ ማግዴላ ማይራሞ፥ ዮሃና፥ ያይቆባ እንዳት ማይራምራኔ ኡንታር የዝ ሀራ ማችታ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ዝን ኡንትስ ማችታይ ኦዴዛይ ኤልሞ ኣዝን አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ዝን ጵጽሮሳ ደንዲ ዎጺ ዱፎ Ꮊንጌዛ። የ አቃ ሄሊ ዙጊ በአዳር ሞጎ አፍላ ኣዳ በኤዛ። ሀኔዝ ባዛይስ ማላባዝግታር ፋ ካራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","የ ጋላስ ካልዛ ታማርታይፕ ናምእታይ የሩሳላመፕ ታጶ ናምኢ ክሎ ምትረ ሃክዛ ኤማሁሰ ሄራ Ꮊንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ኡ ዎላ ሀኔዝባዛ ኡብታ ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ኡ የ ሀናይ ባጋ ቆፕታራኔ ኦድንትታር Ꮊንጎዳር የሱሳ ኡንትኮ ሺቂ ኡንታር ዎላ Ꮊንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ሀኖ ዝን፥ ኡንቲ ኤዛ ኤራም ጋርክ ኡ ኣፋይ አይክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ኤ፥ «ይ ዎላ ኦገል አፋ ኦድንትዛይ አባ?» ዬጌዛ። ኡ አዛኒ ስኤ ግ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ኡንታፕ ፐታይ ቀልዮጳ ግንትንትዛይ፥ «Ꮊ ቃምታይ ጋንጨ የሩሳላመ ሀኔዝባዛ ኤሮዛይ፥ ነ ቢታስ እማꬆኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ኤ ማሂ፥ «ኤ ሀኔዛይ አባ?» ዬጊ ኦይጬዛ። ኡንቲ፥ «ጾስ ቲናኔ አስ ቲና ኦሶራኔ ኦዳር ሚንꬂ ናበ ማቄዝ ናዝረተ የሱሳ ባጋ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ኤዛ ቄሰ ሀላቅታይኔ ኑና አቅስዝታይ Ꮊይቆ ፕርደስ ኣꬂ እንጊ፥ ሶቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ኑኒ እስሬለ አሳ ዎዞደ ግ ኡፋይቲ ናጌዝን Ꮊይ ሀንን Ꮊይኖ ሃይꬓንꬆ ቃማ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ማ ኑ ጋንጨፕ ፐቲ ፐቲ ማችታይ ኑና ዶና ኣይꬄዛ። ኡንቲ Ꮊይኖ ዎንታ ጉራ ዱፎ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ኤ አሃይ ꬋብን ማቂ ይኢ፥ ‹ኤ ፓꬅ የዛ› ዬግዛና ኪታንችታይ ቆንጭስን በኤዛ ዬጊ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ኑ ጋንጨፐካ ፐታይ ፐታይ ዱፋ Ꮊንጊ ማችታይ ኦዴዛይ ሀንን በኤዛ፥ ዝን ኤዛ ኡ በኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ኤ ኡንትኮ፥ «ይንታኖ፥ አካኮዋ አስታዮ፥ ይ ዎዝናይ ናብታይ ኦዴዝ ባዝ ኡብታ አማኖዳይስ ጋምእዝታዮ፥ ");
INSERT INTO mfxe_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ክርስቶሳ Ꮊ መታ ኤኮዳይስነ ፋ ቦንቻይር ገሎዳይስ ቤዞሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ሙሰፐኔ ናብታይ ኡባይፕ ደንዲ ጌሻ ማጻፋይድ ኤባጋ ጻፍንቴዛና ኡባ ኡንትስ ፓቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ኡንቲ Ꮊንግዛ ጉታይኮ ኡኮዳር የሱሳ አꬊ ሃኮ አቆ Ꮊንግዛ ኣዝን፥ ");
INSERT INTO mfxe_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ኡንቲ፥ «ሳአይ ቃሜዝ ግሾስ ኑር አቆባ» ዬጊ ሚንꬂ ዎሴዛ። የይ ግሾስ፥ ኡንታር አቆዳይስ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ኡንታር ዎላ ሙንታል አፋ በቲ፥ ቦራ፥ ደንꬂ አንጂ ኡንትስ ባጺ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","የ ዎደ ኡንቲ ኤሮዳይ ጋርክ ኡ አፋይ ዶይንቴዛ። ኡንትካ ኤሬዛ። ዝን ኤ ኡ ኣፋይፕ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ኡንቲ፥ «ኑ ኦገል አፋ የዝን ኤ ኑስ ጌሻ ማጻፋ ብልታራኔ ኑር ናሾዳር ኑ ዎዝናይ ጹግንተካሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","የ ዎደ ደንዲ ጉየ የሩሳላመ የኤዛ። ታጶ ፐትታይራ Ꮊንክታይ ፐትፕ ሺቂ የዝን ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ኡንቲ፥ «ጎዳይ ቱማ ደንዴዛ፤ ስሞናስ በንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","የ ናምኢ ታማርታይ ኤማሁሰ ኦገል አፋ የዝን ሀነዛናኔ ቦራ ሜዝ ዎደ ዋይዚ ኤዛ ኤሬዛኮ ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ናምኢ ታማርታይ የ ኦዳይል አፋ የዝን፥ የሱሳ ኡ ጋንጨ ኤቂ፥ «ሳሮ ይንትስ ማቆ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ማቆዝን፥ ኡንቲ ዳጋሚ፥ ሜሸ በኤዛ ኣዝን ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ኤ ኡንትኮ፥ «አብስ ዳጋሜኔ? አብስ ስ ይ ዎዝናይድ ገሌኔ? ");
INSERT INTO mfxe_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ታ ኩሻኔ ታ ቶካ ቦኦይታ፤ ታ ታና። ማካ አይኪ ቦኦይታ፤ ታል ይ ብእዛይ ጋርክ፥ ሜሸስ አሾኔ መቀꬂ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ዬጊ፥ ፋ ቶካኔ ፋ ኩሻ ኡንታን ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ኡ ኡፋይሳፕ ደንዴዛይድ አማነካዛር ማላባዝ ጉሳል የዝን፥ የሱሳ ኡንትኮ፥ «Ꮊይዳ ይንትስ ሚዝባዝ የኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ኡ ጽቃ ምችንቴዝ ሞሎ ኤዝስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ኤ ኤኪ ኡ ቲናይድ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ኤ፥ «ታ ይንታር ጋምኤዝ ዎደ ኡባይድ ሙሰ ህገ ማጻፍታይድ፥ ናብታይ ማጻፍታይዳኔ ማዝሙረ ማጻፍታይድ፥ ታ ግሾ ጻፍንቴዝባዝ ኡቢታይ ፖልንቶዳይስ ቤዝዛ ዬጊ ታ ይንትስ ኦዴዝ ቃላይ Ꮊያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","የ ዎደ ጌሻ ማጻፍታ አካኮድ ጋርክ ካሃ ኡንትስ ዶዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","የይ ጋርከካ፥ «ክርስቶሳ ዋየ ኤኮዳ፥ ሃይꬓንꬆ ቃማ Ꮊይቆፕ ደንዶዳ ዬጊ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","የሩሳላመፐ ደንዲ አስ ኡባይስ ናጋራይፕ ማሮትꬃይኔ አቶትꬅ ኤ ሱንꬃይር ማርካቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ይ የይስ ማርክታ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ዬዛኮ፥ ታካ ታ አዳይ እንጌዝ ኡፋይሳ ይንትስ ዳኮዳ። ይ ሳሎፕ ዎልቃ ማኦድ ጋꬆ የሩሳላመ ካታማ ጋምኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","የይፐ ጉየ፥ ብታና ካታማ ኡንታን ኤኪ ቅቴዛ። ፋ ኩሻ ደንꬂ አንጄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ኡንታን አንጅታር ኡንታፕ ሻክንቲ ኡዴ ሳሎ ኤክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ኡ ዙጊ ጎይኒ ጋመ ኡፋይሳር የሩሳላመ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ጾሳ ኡባ ዎደ ጋላትታር ጾስ ኬꬃ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ቃላ ቲናፕ የዛ። ቃላይካ ጾሳር የዛ፤ የ ቃላይ ጾሰ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ቲና ቃላይ ጾሳር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ጾሳይ ኡባ ባዝ ቃላ ባጋር መꬌዛ። መꬍንቴዝ ባዛፕ ፐቲ ባዝካ ኤ ባጋር መꬍንተካባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ኤዛር ደኦ የዛ፤ የ ደአይ አስስ ፖኦ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ፖአይ ꬉማ ፖእዛ፤ ꬉማይ ፖአና ጋመካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ጾሲ ኪቴዝ፥ ፐቲ ዋንሳ ግዝ አሲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","አሲ ኡባይ ኤ ባጋር ፖአ አማኖድ ጋርክ ኤ ፖኦስ ማርካ ማቂ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ኤ ፖኦ ባጋ ማርካቶዳይስ የኤዛፕ አትን ፋ ኡባስ ፖኦ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","አስ ኡባስ ፖእስዛ ቱማ ፖአይ አላመ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ኤዝካ አላመል የዛ። አላማይካ መꬍንቴዛይ ኤ ባጋራ፥ ዝን አላማይካ ኤዛ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ኤ ፋስታይኮ የኤዛ፥ ዝን ኤስታይ ኤዛ ኤከካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ዝን ኤ ፋና ኤኬዝታይስንኔ ኤ ሱንꬃ አማኔዝታይስ ጾስ ናእታ ማቃድ ጋርክ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ኡንትካ ጾሳፕ የልንቴዛፕ አትን አሲ የልንትዛ ዎጋይ ጋርክ ꬊራꬅ ሸነፕ ዎይ አሾፐኔ ሱꬅ ሸነር የልንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ቃላይ አስ ማቄዛ፤ አꬎ ኬሄትꬃኔ ቱማትꬅ ኩሚ ኑ ጋንጨ የዜዛ። ኤ ፋ አዳይስ ፐቲ ናአ ማቂ ኤኬዝ ኤ ቦንቻ ኑ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዋንሳ ኤ ባጋ ማርካቴዛ። ፋ ቃላ ꬎቅ ኡዲ፥ «ታኒ፥ ‹ታፕ ጉየር ይእዛይ ታፕ ቲን የዛ ግሾስ ታፕ ኣꬍዛ› ግ ማርካቴዛይ Ꮊያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ኑኒ ኡቢታይ ኤ አꬎ ኬሄትꬅ ኩንꬃይፕ አንጆል አፋ አንጆ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ጾሳይ ህገ ሙሰ ባጋር እንጌዛ፥ ዝን አꬎ ኬሄትꬅኔ ቱማትꬂ የሱሳ ክርስቶሳ ባጋር የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ጾሳ ኣፈር በኤዝ አስ ኦንካ ባያ፤ ፋ አዳይ ላንቀ የዝ ፐቲ ናአይ ኣዳ ኤ ፋ ኡባስ ጾስ ማቄዛይ ኤዛ ቆንጨ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","የሩሳላመ የዝ አይሁድታይ ሀላቅታይ፥ ቄስታይኔ ለዊታይ፥ «ኔኒ ኦኖ?» ግ፥ ዋንሳ ኦይጮድ ጋርክ ኤዝኮ ኪትን፥ ዋንሳ ኡንትስ ማርካቴዝ ማርካትꬃይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ዋንሳ፥ «ታኒ ክርስቶሳ ባያ» ዬጊ፥ ምልጽ ኡዲ ማርካቴዛፕ አትን ካድበኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ኡንትካ፥ «የዝን፥ ነ ኦኖ? ነ ኤላሳኔ?» ዬጊ ኦይጬዛ። ዋንሳ ማሂ፥ «ታ ኤላሳ ባያ» ዬጌዛ። ማ ኡንቲ፥ «ነ የኦድ ግንትንቴዝ ናባይ ነናኔ?» ዬጊ ኦይጬዛ። ዋንሳ፥ «ዋኣ» ግ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","የዝን፥ «ነ ኦኖ? ኑኒ ኑና ኪቴዝታይስ ኦዶድ ጋርክ ነ ነና ኦና ጌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ዋንሳ ማሂ፥ «ናበ እሳያሳ ጌዛይ ጋርክ፥ «‹ጎዳይስ ኦገ ሉልሶይታ!› ግ ሊዦ ደምባ ኡክዛ አꬃይ ቃላይ ታና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ማ ፈርሳወ አስታይ ኪቴዝ አሳይ ");
INSERT INTO mfxe_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ዋንሳኮ፥ «ነ ክርስቶሳ ዎይ ኤላሳ ዎይ ናበ ባ እጽኮ፥ የዝን አብስ ጻማቄ?» ግ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ዋንሳ ማሂ፥ «ታኒ ሃꬃር ጻማቅዛ፥ ዝን ይ ኤሮዋ አሲ ይ ጋንጨ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ኤ ታፕ ጉየር ይእዛ። ታኒ ሀራ አቶዝን ኤ ጫማ ዎዶሮ ብሎዳይስ ቤዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","የይ ኡባይ ዮርዳኖሳ ቦርካፕ ሰኮ ፕኖ፥ ብታና ካታማ፥ ዋንሳ ጻማቅዛ አቃይድ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ዋንሳ ዎንትꬃ ጋላስ የሱሳ ኤኮ የኦዳር ብኢ፥ «አላመ ናጋራ ባራንችዛ ጾስ ዱራይ Ꮊያ! ");
INSERT INTO mfxe_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ታኒ፥ ‹ታፕ ጉየር ፐቲ አሲ የኦዳ። ኤ ታፕ ቲን የዛ ግሾስ ታፕ ኣꬍዛ ግ ኦዴዛይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ኤ ኦናዛኮ ታኒ ኤሮያ። ዝን እስሬለ አሳይስ ኤዛ ቆንጨ ከሶዳይስ ሃꬃር ጻማቅታር የኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ዋንሳ Ꮊይ ጋርክ ዬጊ ማርካቴዛ፦ «ጌሻ አያናይ ሳሎፕ ሆለ ጋርክ ዎꬎዳራኔ ኤዛል ሸምፖዳር ታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","የይ ሀኖዳይፕ ቲና ታ ኤዛ ኤሮያ። ዝን ሃꬃር ጻማቆዳይስ ታና ኪቴዝ ጾሳይ፥ ‹ጌሻ አያናይ ዎꬊ ኤዛር የዝን ኔኒ በአዳይኔ ጌሻ አያናር ጻማቆዳይ ኤዛ› ዬጊ ታስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ታ የይ ሀኖዳር ብኢ፥ ኤ ጾስ ናአ ማቄዛና ማርካትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ማ ዎንትꬃ ጋላስ ዋንሳ ፋ ታማርታይፕ ናምእታይር ዎላ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","የሱሳ ኣꬎዳር ዋንሳ ብኢ፥ «ጾስ ዱራይ Ꮊይሸ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ናምኢ ዋንሳ ታማርታይ ዋንሳ ግዛና ስኢ የሱሳና ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","የሱሳ ፋና ካልዝታ ጉየ ሽርንቲ ብኢ፥ «ይ አብ ኮይኔ?» ዬጊ ኦይጬዛ። ኡንቲ ማቂ፥ «አስታማራዮ፥ ነ አባ የሳዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","የሱሳ ኡንትኮ፥ «Ꮊና ይኢ ቦኦይታ» ዬጌዛ። ኡንቲ Ꮊንጊ ኤ የዛ አቃ በኤዛ። የ ጋላስ ሳአይ ታጲ ሳተ ሄራ ማቅዝ ግሾስ ኤ ላንቀ ፔዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ዋንሳ ጌዛና ስኢ፥ የሱሳና ካሌዝ ናምኢ ታማርታይፕ ፐታይ፥ ስሞን ጵጽሮሳ እሻ እንድራሰ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","እንድራሰ ቲና ፋ እሻ ስሞናር ዎልሄሊ፥ «ኑኒ ክርስቶሳ ደንጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","እንድራሰ ስሞና የሱሳኮ ከኤዛ። የሱሳ ስሞና ብኢ፥ «ኔኒ ዮና ናአ ስሞና፤ ነ ሱንꬃይ ኬፋ ግ ጼግንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ዎንትꬃ ጋላስ የሱሳ ጋልላ ቢታ Ꮊማዳይስ ሙርቴዛ። ኤ ፍልጶሳና ደንጊ፥ «ታና ካሎባ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፍልጶሳ፥ እንድራሰኔ ጵጽሮሳ የዜዝ ቤተሳይዳ ግዝ ካታማፕ የኤዝ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፍልጶሳ ናትናኤላና ሄሊ፥ «ሙሰ ህገ ማጻፋይ ጋንጨ፥ ማ ናብታይካ ኤባዝ ጻፌዝ ዮሴፋ ናአ ናዝረተ የሱሳ ኑ ደንጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናትናኤላ ማሂ፥ «ናዝረተ ካታማፕ ሎኦ ባዝ ከዞዳይስ ዳንዳእኔ?» ዬጌዛ። ፍልጶሳ፥ «ይኢ ቦኦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","የሱሳ ናትናኤላ ፋኮ ይእዛና ብኢ፥ «ገነ ባ ቱማ እስሬለ አስ Ꮊያ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናትናኤላ የሱሳኮ፥ «ኔኒ ታና አባ ኤሬ?» ዬጌዛ። የሱሳ ማሂ፥ «ፍልጶሳ ነና ጼጎዳይፕ ቲና፥ ኔኒ ባላሰ ምꬂ ኦሞ የዝን ታኒ ነና በኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ናትናኤላ ማሂ፥ «አስታማራዮ፥ ኔኒ ጾስ ናአ! ኔኒ እስሬለ ካተ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","የሱሳ ኤኮ፥ «ታ ነና ባላሰ ምꬂ ኦሞ በኤዛ ጌዝ ግሾስ ነ አማንኔ? ኔኒ Ꮊይፕ ኣꬅባዝ በአዳ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ማ የሱሳ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ሳሎ ዶይንትን፥ ጾስ ኪታንችታይ አስ ናአ አፋ ከዞዳራኔ ዎꬎዳር ይ በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ሃይꬒንꬃ ጋላስ ጋልላ ቢታ ቃና ካታማ ቦስ የዛ። የሱሳ እንዳት የ ቦሳይድ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","የሱሳካ ፋ ታማርታይር ዎላ የ ቦሳይድ ጼግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ዎይነ ኡሺ ዉርን፥ የሱሳ እንዳት የሱሳኮ፥ «ኡንትስ ዎይነ ኡሺ ዉሬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","የሱሳ ማሂ፥ «ታ እንዳቴ፥ ነ Ꮊይዳ ገልፐ? ታ ዎዳይ ሀጋ ሄለካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","የሱሳ እንዳት ኦሶ አስታይኮ፥ «ኤ ይንትስ ኦዴዝባዝ አባባዝ ማቅኮካ ኦꬆይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","አይሁድታይ ፋ ሻግሸ ዎጋስ ማድንትዛ ኡሱፑን ሹች ጋንታይ የ አቃይድ የዛ። ፐቲ ፐቲ ጋናይ ናምኢ ዎይ ሀይꬒ ጹጋ አይክዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","የሱሳ ኦሶ አስታይኮ፥ «ጋንታይድ ሃꬄ ኩንꬆይታ» ዬጌዛ። ኡንቲ ጋንታይስ ዶና ሄሎዳይስ ሃꬄ ኩንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","የሱሳ ኡንትኮ፥ «Ꮊት ዱቂ ቦስ ጎዳይስ እንጎይታ» ዬጌዛ። ኡንቲ ኤዝስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ቦስ ጎዳይስ ዎይነ ኡሽኮ ላምንቴዝ ሃꬃ ጋንጺ ብኢ አናፕ የኤዛኮ ኤረካ፥ ዝን ሃꬄ ኩንꬄዝ ኦሶ አስታይ ኤርዛ። ቦሳ ጎዳይ ማቾ ኤክዛና ጼጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«ኦንካ ሎኦ ዎይነ ኡሺ አሳ ቲናቲ ኡሽዛ። የይተ አሳይ ኡዢ አሌዛይፕ ጉየ ሃጾ ኡሽ እንግዛ። ዝን ኔኒ ሎኦ ዎይነ ኡሺ Ꮊኖ ሄሎዳይስ ጋዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","የሱሳ Ꮊ ቲና ማላታ ጋልላ ቢታ ቃና ካታማ ኦꬄዛ፤ የይዳ ፋ ቦንቻ ቤዜዛ። ኤ ታማርታይ ኤዛ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","የይፕ ጉየ፥ የሱሳ ፋ እንዳትራ፥ ፋ እሽታይራኔ ፋ ታማርታይር ዎላ ቅፍርናሆመ ካታማ Ꮊንጊ ጽቃ ጋላስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","አይሁድታይ ቦንችዛ ፓዝቃ ባላይ ኡክን የሱሳ የሩሳላመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ꮊንጊ ጾስ ካራ ጋንጨ ገማትታ፥ ሀርታ፥ ዱርታኔ ሆልታ ባይዝዝታኔ ፋ ኦይደል በቲ ሚሸ ላምዝታ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ኤ ጹርቃፈር ኡብታ ኡ መህታይር ጾስ ካራፕ ባይኢ ባለ ከሴዛ። ሚሸ ላምዝታይ ጻርጴዝታካ ሽሪ ኦሊ ኡ ሚሻ ላሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ሆለ ባይዝዝታና፥ «Ꮊ ሆልታ Ꮊይፕ ከሶይታ፤ ታ አዳይ ካራ ጋበ ማህፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ኤ ታማርታይ ጌሻ ማጻፋይድ፥ «ታኒ ነ ካራይስ ምጭንትዛ ምሻይ ታና ታማ ጋርክ ምችዛ ግዛ» ግንትንቲ ጻፍንቴዛና አካኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","የይፕ ጉየ፥ አይሁድታይ ማሂ፥ «ነ Ꮊያ ኦꬆዳይስ ኔስ ማዉተ የዛይስ ኑና አባ ማላታ ኦꬂ ቤዞዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","የሱሳካ፥ «Ꮊ ጾስ ካራ ላሎይታ፤ ታኒ ሀይꬒ ጋላሳር ማሂ ደንꬆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ማካ አይሁድታይ፥ «Ꮊ ጾሳ ካራ ኬጾዳይስ ኦይታማነ ኡሱፑን ላይꬅ ኤኬዛ፥ ዝን ኔኒ ሀይꬒ ጋላሳር ደንꬆደ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ዝን የሱሳ ኦድዛ ጾሳ ካራይ ፋ አሳተꬅባጋ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","የይ ግሾስ፥ የሱሳ Ꮊይቆፕ ደንዴዛይፕ ጉየ ኤ ታማርታይ ኤ የያ ጌዛና አካኬዛኔ ጌሻ ማጻፋይድ ጻፍንተዛኔ የሱሳ ኦዴዛና አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","የሱሳ ፓዝቃ ቦንችዛ ጋላስ የሩሳላመ የዝን፥ ኤ ኦꬄዝ ማልታ ብኢ ጋመ አሳይ ኤዛ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ዝን የሱሳ አስ ኡባ ኤርዛ ግሾስ ኡንታን አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","አስ ዎዝና የዛ ባዝ ኤ ፋ ኡባስ ኤርዛ ግሾስ አስባዝ ኦንካ ኤዝስ ኦዶዳይ ጋርክ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ፈርሳውታይ ባጋፕ ማቄዝ፥ አይሁድታይ ሀላቃይ፥ ንቆድሞሳ ግዝ ፐቲ አꬃይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ንቆድሞሳ ቃማ የሱሳኮ ይኢ፥ «አስታማራዮ፥ ኔኒ ጾሳይ ኪቴዝ አስታማረ ማቄዛና ኑ ኤርዛ። አብስ ጊኮ፥ ጾሳይ ኤዛር የዛም እጽኮ Ꮊ ነ ኦꬅዛ ማልታ ኦꬆዳይስ ዳንዳእዛ አሲ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","የሱሳ ማሂ፥ «ታኒ ኔስ ቱሮ ኦድዛ፤ ኦንካ ማቂ የልንታም እጽኮ ጾስ ካተትꬃ በአዳይስ ዳንዳኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ንቆድሞሳ፥ «አስ ጭሚ ዋይዚ ማቂ የልንቶዳይስ ዳንዳኤ? ፋ እንዳት ኡሎ ማቂ ገሊ ማሂ የልንቶዳይስ ዳንዳእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","የሱሳ ማሂ፥ «ታኒ ኔስ ቱሮ ኦድዛ፤ ኦንካ ሃꬃፐኔ ጌሻ አያናፕ የልንታም እጽኮ፥ ጾስ ካተትꬅ ገሎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","አሾፕ የልንቴዛይ አሾ፤ አያናፕ የልንቴዛይ አያና። ");
INSERT INTO mfxe_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ታኒ፥ ‹ይ ማቂ የልንቶዳይስ ቤዝዛ› ግ ይንትስ ኦዴዛይ ግሾስ ኔኒ ማላባዝ ጊፐ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ጫርኮ ፋ ኮዤዝ ባጋ ጫርክዛ። ኔኒ ጊርꬃ ስእነፕ አትን አያይፕ ይእዛኮ ዎይ አያ Ꮊንግዛኮ ኤሮያ። አያናፕ የልንቴዝ ኡቢታይ የይ ጋርክ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","የዝን ንቆድሞሳ፥ «የይ ዋይዚ ሀኖዳይስ ዳንዳኤ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","የሱሳ ማሂ፥ «ኔኒ እስሬልታይ አስታማረ ማቅታር Ꮊያ ኤሮሳ? ");
INSERT INTO mfxe_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ታኒ ኔስ ቱሮ ኦድዛ፤ ኑ ኤርዛ ባዝ ኦድዛኔ በኤዝ ባዝ ማርካትዛ፥ ዝን ኑ ማርከትꬃ ይ ኤኮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ታኒ ይንትስ ሳአባዝ ኦድን ይ አማኖዋባዝ ማቅኮ ሳሎባዝ ኦድን ዋይዚ አማኖዴ? ");
INSERT INTO mfxe_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ሳሎፕ ዎꬌዝ አስ ናአይፕ አትን ሳሎ ከዜዛይ ኦንካ ባያ፤ ሳሎ የዝ አስ ናአይ ታና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","ሙሰ ሊዦ ደንባል ናሰ ሾሽ ሶቴዛይ ጋርክ ኤዛ አማኔዝ ኡቢታይ መꬍና ደኦ ኤኮዳይ ጋርክ አስ ናአይ ሶትንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ጾሳይ Ꮊ አላመ ቃꬌዝ ግሾስ ፋ ናአ ፐታ ኣꬅ እንጎድ ሄሎዳይስ ጨር ዶሴዛይ ኤዛ አማንዛ ኡቢታይ መꬍና ደኦ ላቶዳይ ጋርከፕ አትን ꬋባማይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ጾሳይ ፋ ናአ Ꮊ አላመ ኪቴዛይ አላመ ፕርዶዳይስ ባዝን አላማ ኤ ባጋር አሾዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ኤዛ አማንዛ ኦንካ ፕርድንታሚ፥ ዝን ኤዛ አማኖዋ ኦንካ ፐቲ ጾስ ናአ አማነካ ግሾስ Ꮊት ፕርድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ፕርዳይካ Ꮊያ፤ ፖኦ፤ አላመል የኤዛ፥ ዝን አስ ኦሶ ኢታ ማቄዝ ግሾስ አሳይ ፖኦፕ ኣꬂ ꬉማ ዶሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ኢታ ባዝ ኦꬅዛ ኦንካ ፖኦ እጽዛ። አብስ ጊኮ፥ ፋ ኦሶ ፕ ኬዛማይ ጋርክ ፖኦኮ የኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ዝን ቱማ ኦꬅዝ ኦንካ ጾሳይ ኪቴዛይ ጋርክ ኤ ኦꬄዛና ፖኦ ቤዞዳይ ጋርክ ፖኦኮ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","የይፕ ጉየ፥ የሱሳ ፋ ታማርታይር ዎላ ይሁዳ ቢታ Ꮊንጌዛ። ኤዛይድ ጻማቅታር ኡንታር ጽቃ ዎደ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ማ ዋንሳ ሳሌመ ላንቀ የዝ ሄኖነ ዬግዝ አቆ ጋመ ሃꬅ የዛ ግሾስ አሳ ኤዛይድ ጻማቅዛ። አሳይካ የ አቃ Ꮊንጊ ጻማቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","የ ዎደ ዋንሳ ሀጋ አጭንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","የይፕ ጉየ፥ ዋንሳ ታማርታይኔ አይሁደ አሳይ ሻግሸ ዎጋ ባጋ ፓላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ዋንሳ ታማርታይ ዋንሳኮ Ꮊንጊ፥ «አስታማራዮ፥ ዮርዳኖሳ ቦርካፕ ሰኮ ፕኖ ኔር የዛይ፥ ኔኒ ኤባጋ ማርካቴዛይ፥ የዛኮ ጻማቅዛ። አሳይ ኡቢታይካ ኤዝክ Ꮊንግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዋንሳ ማሂ፥ «ጾሳይ እንገካ አሲ አባባዝካ ኤኮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹ታኒ ክርስቶሳ ባያ፥ ዝን ኤፕ ቲና ኪትንቴዛ› ማቄዝ ግሾ ይ፥ ይ ኡባስ ታስ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ገሎስ ጊጌዛና ኤኮዳይስ ጊጌዝ አꬃይሲ። ኤክዛይስ ላዛንꬃይ ካለ ኤቂ ኤ ግዛ ስኤዝ ዎደ ሎእꬂ ኡፋይትዛ። የይ ግሾስ፥ Ꮊይ ታ ኡፋይሳይ ፖልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ኤ ግታቶዳይስ ታኒ ጽቆዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","አፋፕ ይእዛይ ኡባይፕ ኣꬅ። ሳአፕ በንቴዛይ ሳአባዝ። ኤ ሳአባዝ ኦድዛ። ሳሎፕ ይእዛይ ኡባይፕ አፋ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ኤ ፋ በኤዝባዝኔ ስኤዝባዝ ማርካትዛ፥ ዝን ኤ ማርከትꬃ ኤክዛይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ኤ ማርከትꬃ ኤክዛ ኦንካ ጾሳይ ቱማ ማቅዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ጾሳይ ፋ ጌሻ አያና ኤስ ማከካ እንግዝ ግሾስ ጾሳይ ኪቴዛይ ጾስ ቃላ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","አዳይ ፋ ናአ ዶሲ ኡባ ባዝ ኤ ኩሻይድ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ናአ አማንዛ አꬃይስ መꬍና ደኦ የዛ። ዝን ናአ አማኖዋ አꬃይል አፋ ጾስ ካቺ የዛይፕ አትን ኤ ደኦ ደንጋሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","የሱሳ ዋንሳስታይፕ ጋንግዛ ካልዝታ ፋኮ ሺሽዛኔ ጻማቅዛና ፈርሳውታይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ማቅኮካ የሱሳ ታማርታይ ጻማቄነፕ አትን የሱሳ ኦናካ ጻማቀካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","የሱሳ አሳይ ኤባዝ ግዛ ስኢ ይሁዳፕ ደንዲ ጋልላ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ጋልላ Ꮊንግታር ሳማረራ አꬎዳይ ኤዝስ አታምባዝ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","የይ ግሾስ፥ ያይቆባ ፋ ናአ ዮሴፋስ እንጌዝ ጋደ ላንቀ የዝ ስካረ ግዝ ሳማረ ካታማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","የ አቃይድ ያይቆባስ ሃꬅ ኦላ የዛ። የሱሳ የꬍታር ዳቡሪ የ ሃꬅ ኦላቲ ላንቀ በቴዛ። የ ዎደ ሳአይ ኡሱፑን ሳተ ሄራ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ፐቲ ሳማረ አስታ የ ኦላይፕ ሃꬅ ትኮዳይስ የኤዛ። የሱሳ የ አስትኮ፥ «ታና ሃꬄ ኡሾየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","የ ዎደ የሱሳ ታማርታይ ሚዝ ባዝ ዎንጎዳይስ ካታማ Ꮊንጌዛን። ");
INSERT INTO mfxe_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","የ አስታ ማሂ፥ «ኔኒ አይሁደ አስ ማቅታር፥ ሳማረ ማች ማቅዝ ታና ዋይዚ ሃꬄ ኡሾባ ጌ?» ዬጌዛ። የያ እዛ ጌዛይ አይሁድታይ ሳማርታይር ዎልሄሎዋ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","የሱሳ ማሂ፥ «ኔኒ ጾስ እሞታኔ ሃꬄ ታና ኡሾየ ግዛይ ኦናዛኮ ነ ኤሬዛኮ ኤዛ ነ ዎሶዳዝን፤ ኤዝካ ኔስ ደኦ እንግዛ ሃꬂ እማዳዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","የ አስታ ማሂ፥ «ጎዳዮ፥ ኔስ ዱቅዛባዝ ባያ፤ ኦላይካ ጪሞ። የዝን፥ ደኦ እንግዝ ሃꬅ ነ አናፕ ደንጎዴ? ");
INSERT INTO mfxe_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ኑስ Ꮊ ሃꬅ ኦላ እንጌዝ ኑ አዳይ ያይቆባፕ ኔኒ አꬊኔ? ኤዝኔ፥ ኤ ናእታይኔ ኤ መህታይ Ꮊ ኦላይፕ ኡዤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","የሱሳ፥ «Ꮊ ሃꬃይፕ ኡዤዝ ኦንካ ማቂ ሳምንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ዝን ታኒ እንጎድ ሃꬃ ኡዥዝ ኦንካ ኡባራካ ሳምንታሚ። ታኒ እማድ ሃꬃይ ኤ ጋንጨ መꬍናስ ደኦ እንግዝ ጎግዝ ፑልቶ ማቃዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","የ አስታ ማሂ፥ «ጎዳዮ፥ ታኒ ሳምንታማይ ጋርከኔ ሃꬅ ትኮዳይስ Ꮊ አቃ የኣማይ ጋርክ ታስ የ ሃꬃ እንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","የሱሳ እዝኮ፥ «Ꮊንጊ ነ አዝና ጼጊ የኦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","የ አስታ ማሂ፥ «ታስ አዝኒ ባያ» ዬጌዛ። የሱሳ እዝኮ፥ «ታስ ኣዝኒ ባያ ጉሳይድ ኔስ ቡታ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ኔስ ቲን እችን አዝንታይ የዛ። Ꮊት ኔር የዛ አꬃይ ነ አዝነ ባያ። ኔኒ Ꮊት ቱሮ ኦዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","የ አስታ ማሂ፥ «ጎዳዮ፥ ኔኒ ናበ ማቅዛና ታኒ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ኑ አድታይ Ꮊ ደራይል አፋ ጾስ ጎይኔዛ። ዝን ይ አይሁድታይ አሲ ጾስ ጎይኖዳይስ ቤዝዛ አቃይ የሩሳላመ ግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","የሱሳ፥ «Ꮊን አስተ ታና አማኖባ፤ Ꮊ ደራይል አፋ ዎይ የሩሳላመ አዳይስ ጎይናም ዎደ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ይ ሳማርታይ ይ ኤሮዋዛይስ ጎይንዛ። ዝን ኑኒ አቶትꬂ አይሁደፕ ይእዝ ግሾስ ኑ ኤርዛይስ ጎይንዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ዝን አዳ ቱማር ጎይንዝታይ አያናራኔ ቱማር ጎይኖድ ዎደ ኡኬዛ፤ Ꮊተካ ሄሌዛ። ይኬ፥ አዳይ ኮይዛይ Ꮊይ ጋርክ ኦገር ጎይንዝታ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ጾሳይ አያና፤ ኤዝስ ጎይንዝታይ አያናራኔ ቱማትꬃር ጎይኖዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","የ አስታ ማሂ፥ «ክርስቶሳ ግንትዝ ‹ማሳይ› የኦዳና ታኒ ኤርዛ። ኤ ይኢ ኑስ ኡባ ባዝ ኦዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","የሱሳ፥ «Ꮊ ኔር ናሽዛይ ታኒ ኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ኡንቲ ናሾዳር፥ የሱሳ ታማርታይ Ꮊንጌዝ አቃይፕ ማቄዛ። የሱሳ ማቻር ዎላ ናሾዳር ኡ ብኢ ማላባዝ ጌዛ። ዝን አስትኮ፥ «አብ ኮዬ?» ዎይ የሱሳኮ፥ «እዝር አብስ ኦድንቴ?» ጌዛይ ኦንካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","የይፕ ጉየ፥ አስታ ፋ ሃꬅ ኦታና አሺ ጉየ ካታማ Ꮊንጊ አስታይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ታኒ ኦꬄዝ ባዝ ኡባ ታስ ኦዴዝ አꬃ በአዳይስ የꬎይታ። ኤ ክርስቶሳ ማቃደሻ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","አሳይ ካታማፕ ከዚ የሱሳኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","የይ ሀኖዳር፥ ኤ ታማርታይ የሱሳኮ፥ «አስታማራዮ ጽቃ ሙንታ ሞየ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ዝን ኤ፥ «ታስ ይ ኤሮዋ ካꬃ ታ ሚዛይ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","የይ ግሾስ፥ ኤ ታማርታይ ዎል ጋንጨ፥ «ኤዝስ ሚዝባዝ አሲ ኮኦ አተና?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","የሱሳ ኡንትኮ፥ «ታ ሙንታይ ታና ኪቴዛይ ሸና ኦꬆኔ ኤ ኦሶ ፖሎዳያ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ይ፥ ‹ኦይዲ አጌናፕ ጉየ ካꬃይ ማጾስ ሄሌዛ› ጎሳ? ዝን ታኒ ይንትስ ኦድዛ፤ ካꬃይ ካጺ ሺሾስ ሄሌዛያ ሎእꬂ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ዘርዛይኔ ማጽዛይ ዎላ ኡፋይቶድ ጋርክ ማጽዛይ ዳሞዘ ኤክዛ ማ ካꬃካ መꬍና ደኦስ ሺሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ይኬ፥ ‹ፐታይ ዘርዛ፤ Ꮊንካይ ማ ማጽዛ› ግዝ ኦዳይ ቱማ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ይንቲ ዳቡረካዛና ሺሾዳይ ጋርክ ታኒ ይንታን ኪቴዛ። Ꮊንክታይ ኦꬂ ዳቡሬዝ አቆ ገሊ ይ ኡ ዳቡርስ አፋ ኤኬዝታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","የ አስታ፥ «ኤ፥ ታኒ ኦꬄዝ ኡባ ባዝ ኦዴዛ» ግ ማርካቴዝ ግሾስ የ ካታማ የዝ ሳማረ አሳይፕ ጋምታይ የሱሳ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ሳማረ አሳይ የሱሳኮ ይኢ፥ ፋ ካለ ጋምኦዳይ ጋርክ የሱሳ ዎስን ኤ ኤዛይድ ናምኢ ጋላስ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ኤ ኦድዛ ቃላይ ግሾስ ቲናሳይፕ ጋመ አሳይ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ማ ኡንቲ አስትኮ፥ «Ꮊት ኑ አማንዛይ ኑ ኡባስ ኤ ግዛ ስኤዝ ግሾሳፕ አትን ኔኒ ማርካቴዝ ግሾስ ባያ። ማ ኤ ቱማ Ꮊ አላመ አሽዛ ማቅዛና ኑኒ ኤሬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ናምኢ ጋላሳፕ ጉየ፥ የሱሳ የይፕ ከዚ ጋልላ ቢታ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","የሱሳ ፋ ኡባስ፥ «ናበ ፋ ቢታል ቦንችንቶያ» ዬጊ ቲናቲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","የሱሳ ጋልላ ሄሌዝ ዎደ ጋልላ አሳይ ኤዛ ሞኬዛ። አብስ ጊኮ፥ ፓዝቃ ባለ ቦንችዛ ጋላስ ኡንቲ የሩሳላመ የዝ ግሾስ ኤ ኦꬄዝ ባዝ ኡብታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","የሱሳ ሃꬄ ዎይነ ኡሽኮ ላሜዝ አቆ፥ ጋልላ የዝ ቃና ካታማ ቅቴዛ። ቅፍርናሆመ ካታይ ካራ ኦꬅዝ ፐቲ ሹማይስ ናአይ ሀርግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","የሱሳ ይሁዳፕ ጋልላ የኤዛና የ ሹማይ ስኢ ኤዝኮ የኤዛ። Ꮊይቆዳይስ ኡኬዝ ፋ ናአ Ꮊንጊ ፓꬆዳይ ጋርክ የሱሳና ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","የሱሳ ሹማይኮ፥ «ጾሳይ ኦꬅዛ ማላባዝኔ ማላ በአምጽኮ ይ ኡባራ አማናም» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ሹማይ ማሂ፥ «ጎዳዮ፥ ታ ናአይ Ꮊይቀካ የዝን ታር የꬎዬ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","የሱሳ፥ «ነ ካራ ቅቶባ፤ ነ ናአይ ፓጾዳ» ዬጌዛ። የ ሹማይ የሱሳ ጌዛና አማኒ ፋ ካራ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ኤ ፋ ካራ Ꮊማዳር ኤ አይልታይ ኤዝኮ ይእታር ኤዛ ኦገል ሄሊ፥ «ነ ናአይ ፓጼዛ» ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ኤ አይልታ ፋ ናአይስ አፑን ሳተር ሎኤዛኮ ኦይጬዛ። ኡንቲ ማሂ፥ «ዝቅን ላፑን ሳተር ምሻይ አቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ናአይ አዳይ የሱሳ ፋኮ፥ «ነ ናአይ ፓጾዳ» ጌዛይ የ ሳተ ማቄዛና አካኬዛ። የይ ግሾስ፥ ኤዝኔ ኤ ካራ አስ ኡቢታይ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","የይ የሱሳ ይሁዳፕ ጋልላ ይኢ ኦꬄዝ ናምእንꬆ ማላ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","የይፕ ጉየ፥ የሱሳ አይሁድታይ ቦንችዛ ባላይስ የሩሳላመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","የሩሳላመ ዱርታይ ፐንገ ካለ እብራይስጸ ዶናር ቤተሳይዳ ግዝ ዴለ የዛ። የ ሃꬃይ ላንቀ እችን ሸምፖ በስታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","የይድ ሃꬃይ ኤንኦዳና ናግዛ ጋመ ሀርግንቴዝታይ፥ ቶእታይ፥ ዎብታይኔ ጉንድታይ ዎይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","አብስ ጊኮ፥ ፐቲ ፐቲ ቶኬ ጎዳ ኪታንቻይ ሃꬃ ዎꬊ ኤንእስዛ። ሃꬃይ ኤንኦዳር ቲን ገሌዝ አꬃይ ፋና አይኬዝ አባ ሀርገፐካ ፓጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","የ አቃይድ ሀስታማኔ ሆስፑን ላይꬅ ሀርግንቴዝ ፐቲ አꬃይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","የሱሳ የ አꬃ ብኢ፥ ማ ጋመ ዎደ ሀርግንቴዛና ኤሪ አꬃይኮ፥ «ፓጾዳይስ ኮይኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ሀርግንቴዝ አꬃይ ማቂ፥ «ጎዳዮ፥ ሃꬃይ ኤንኦዳር ታና ሃꬃይ ጋንጨ ኦልዛ አሲ ባያ። ታኒ ገሎድ ሀኖዳር ሀራይ ታፕ ቲናቲ ገልዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","የሱሳ ኤዝኮ፥ «ደንዲ ኤቆባ፤ ነ አርሳ ቶኪ ቅቶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","አꬃይ እዝር ኤልሲ ፓጼዛ፤ ፋ አርሳ ቶኪ ቅቴዛ። የይ ማላ ጋላሳር ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","የይ ግሾስ፥ አይሁድታይ ፓጼዝ አꬃይኮ፥ «Ꮊይኖ ሳአይ ማላ፤ ኔኒ ነ አርሳ ቶክዛይ ዎጋ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ዝን አꬃይ፥ «ታና ፓꬄዛይ፥ ነ አርሳ ቶኪ ቅቶባ ጌዛ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ኡንቲ ኤዝኮ፥ «ነና፥ ነ አርሳ ቶኪ ቅቶባ ጌዛይ ኤ ኦኖ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ዝን የሱሳ የ አቃይድ ጋመ አስ ጋንጨር ኤርሰካዛር ኣꬊ ቅቴዝ ግሾስ አꬃይ ፋና ፓꬄዛይ ኦናዛኮ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","የሱሳ ጉየፕ የ አꬃ ጾስ ኬꬃ ደንጊ፥ «Ꮊት፥ ኔኒ ፓጼዛ፤ Ꮊይፕ ኢታ ባዝ ነና ሄላማይ ጋርክ ማቂ ናጋራ ኦꬅፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","የይፕ ጉየ፥ አꬃይ Ꮊንጊ ፋና ፓꬄዛይ የሱሳ ማቄዛና አይሁድታይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","የሱሳ የያ ማላ ጋላስ ኦꬄዝ ግሾስ አይሁድታይ የሱሳና ባይእꬅ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","የሱሳ ማቂ፥ «ታ አዳይ ኡባ ዎደ ኦꬅዛ፤ ታካ ኦꬆዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","የሱሳ ማላ ቦንቼካ ግሾስ ኣዳ ባዝን ጾሳ ፋ አደ ግ ፋና ጾሳር ኡኩልሴዝ ግሾስ አይሁድታይ ኤዛ ዎꬎዳይስ ቲናሳይፕ አꬂ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","የሱሳ ማሂ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ናአይ ፋ ኣዳስ አብካ ኦꬆዳይስ ዳንዳኦያ። ኤ ፋ አዳይ ኦꬆዳር በኤዛና አዳ ኦꬅዛ። አዳይ ኦꬅዛና ናአይካ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","አዳይ ፋ ናአ ቃꬍዛ ግሾስ ኤ ኦꬅዝ ኦꬆ ኡባ ፋ ናአ ቤዝዛ። ይ ማላባዝ ጎዳይ ጋርክ ኤ Ꮊይፕ አꬊዝ ኦሶ ፋ ናአ ቤዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","አዳይ Ꮊይቄዝታ Ꮊይቆፕ ደንꬂ ኡንትስ ደኦ እንግዛይ ጋርክ ናአይካ ፋ ኮይዝታይስ ደኦ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","አዳይ ናአይስ ፕርደ ማዉተ ኡባ እንጌዛፕ አትን ኤ ኦናካ ፕርዶያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","አሳይ ኡቢታይ አዳ ቦንችዛይ ጋርክ ናአካ ቦንቾዳ። ናአ ቦንቾዋ ኦንካ ናአ ኪቴዝ አዳካ ቦንቾያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ታኒ ይንትስ ቱሮ ኦድዛ፤ ታ ቃላ ስእዝታይኔ ታና አዛዜዛና አማንዛይ መꬍና ደኦ የዛ። ኤ Ꮊይቆፕ ደኦ ፒንጌዝ ግሾስ ፕርድንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ታኒ ይንትስ ቱሮ ኦድዛ፤ Ꮊይቄዝ አሳይ ጾስ ናአ ቃላ ስእዝ ዎደ የኦዳ፤ የይካ Ꮊተ። የ ቃላ ስእዛይ ደኦር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","አዳይስ ኤስ ደኦ የዛይ ጋርክ ናአይስካ ኤስ ደኦ የዞዳይ ጋርክ እንግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","አስ ናአ ማቅዝ ግሾስ አዳይ ናአይስ ፕርደ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«ዱፎ የዝታይ ኤ ቃላ ስኢ ደንዶድ ዎደ የኦድ ግሾስ Ꮊያ ማላባዝ ጊፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ሎኦ ኦꬄዝታይ ደኦር የዞዳይስ ማ ኢታ ኦꬄዝታይ ፕርደ ኤኮዳይስ ዱፎፕ ደንዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«ታኒ ታ ማዉተር አባባዝካ ኦꬆዳይስ ዳንዳኦያ። ጾሳይ ታስ ኦዴዛይ ጋርክ ፕርድዛ። ታኒ ታና ኪቴዛይ ኮይዝ ባዝ ኦꬅዛፕ አትን ታ ኮይዝ ባዝ ኦꬆዋ ግሾስ ታ ፕርዳይ ቱማ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«ታኒ ታባዝ ማርካትኮ ታ ማርካትꬃይ ቱማ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ታ ባጋ ማርካትዛይ ሀራ የዛ፤ ኤ ታባዝ ማርካትዛይ ቱማ ማቅዛና ታኒ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«ይ ዋንሳኮ አስ ኪትን ኤ ቱማስ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ታኒ የያ ይንትስ ኦድዛይ፥ ይ አቶድ ጋርክ ጌዛፕ አትን አስ ማርካትꬂ ታስ ኮሼዝ ግሾ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ዋንሳ ሙቃዳ ጋርክ ኤጽታር ፖኤዛ። ይ ጽቃ ዎደስ ኤ ፖአይድ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«ዝን ታስ ዋንሳፕ ኣꬊዝ ማርካ የዛ። ታኒ ኦꬆድ ጋርክ ታ አዳይ ታስ እንጌዝ ኦስታይ ታ ባጋ ማርካትዛ፤ አዳይ ታና አዛዜዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«ማ ታና ኪቴዝ አዳይ ፋ ኡባስ ታባዝ ማርካትዛ። ይ ኤ ቃላ ኡባራካ ስኤካ ዎይ ኤ ማላ ብእቤኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ኤ አዛዜዛና ይ አማኖዋ ግሾስ ኤ ቃላይ ይ ዎዝና ጋንጨ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«ጌሻ ማጻፍታይፕ መꬍና ደኦ ደማድባዝ ይንትስ ኣዝን ኡንታን ይ ፕላግዛ፤ ኡንቲ ታባዝ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ዝን ይ ደኦ ደንጎዳይስ ታኮ የኦዳይስ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«አሳፕ ታኒ ቦንቾ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ዝን ታኒ ይ ዎዝና ጋንጨ ጾስስ ቃ ባዛ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ታኒ ታ አዳይ ማዉተር የኤዛ፥ ዝን ታና ሞከካያ። ሀራይ ፋ ማዉተር ይእዛ ዎደ ኤዛ ሞክዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ይ ፐታይ ፐታይፕ ቦንቾ ኮይዝታይ፥ ፐቲ ጾሳፕ ይእዝ ጋላታ ኤኮዳይስ ኮዮዝታይ፥ ዋይዚ ታና አማኖዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«ታኒ ታ አዳይ ቲና ይንታን ሞትዛባዝ ይንትስ ኣዝፐ። ይንታን ሞቶዳይ ይ ኡፋይሳር ናግዝ ሙሰ። ");
INSERT INTO mfxe_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ይ ሙሰ አማኔዝ ባዝ ማቄዛኮ ኤ ታ ባጋ ጻፌዝ ግሾስ ታናካ አማኖዳዝን። ");
INSERT INTO mfxe_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ዝን ይ ኤ ጻፌዛና አማናም እጽኮ ታ ቃላ ዋይዚ አማኖዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","የይፕ ጉየ፥ የሱሳ ጽብራዶሳ ግዝ ጋልላ አባፕ ሰኮ ፕኖ ፒንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ኤ ሀርግንቴዝታ ፓꬆር ኦꬄዝ ማላ በኤዝ ግሾስ ጋመ አሳይ ኤዛ ካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","የሱሳ ደረል አፋ ከዚ፥ ኤዛይድ ፋ ታማርታይር ዎላ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","አይሁድታይ ቦንችዛ ፓዝቃ ባለ ጋላሳይ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","የሱሳ ጋመ አሳይ ፋኮ ይእዛና ብኢ ፍልጶሳኮ፥ «Ꮊ አሳ ኡብታ ሙዞዳይስ ግድዛ ካꬃ አናፕ ዎማዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ኤ የያ ፍልጶሳ ፋጮዳይስ ጌዛፕ አትን ኤ ፋ ኡባስ አብ ኦꬆዳዛኮ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፍልጶሳ ማሂ የሱሳኮ፥ «ሀራ አቶዝን፥ ኦማር ኦማር፥ ፐቲ ፐቲ ባꬊꬅ ሄልꬆዳይስ፥ ናምኢ ጼት ዲናረር ሶሎ ዎንግኮካ ግዳሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ማ የሱሳ ታማርታይፕ ፐታይ፥ ስሞን ጵጽሮሳ እሻይ እንድራሰ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«እችን ባንጋ ሶሎራ ናምኢ ሞሎ አይኬዝ ፐቲ ናአይ Ꮊይዳ የዛ፥ ዝን Ꮊ አስ ኡባይስ የይ አብ ማዶዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","የሱሳ ፋ ታማርታይኮ፥ «አሳ በትꬆይታ» ዬጌዛ። የ አቃይድ ጋመ ማታ የዛ፤ አሳይ ኡቢታይ በቴዛ። ꬊራꬅ አስታይ ታይባይ እችን ሙኩሎ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","የሱሳ ሶላ ኤኪ ጾስ ጋላቲ ማቂ ኤዛይድ በቴዝ አሳይስ ግሼዛ። ሞላካ ኤኪ Ꮊይ ጋርክ ኡዲ እንግን፥ አሳይ ፋ ኮዬዛይ ጋርክ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ኡ ኡቢታይ ምዤዛይፕ ጉየ የሱሳ ፋ ታማርታይኮ፥ «ፐቲ ባዝካ ኢታም ጋርክ አቴዝ ጉፋ ሺሾይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","የይ ግሾስ፥ ኡ ኡባ ሺሼዛ። አሳይ ሚን አቴዝ ባንጋ ሶሎ ጉፋ ሺሺ ታጶ ናምኢ ሌማተ ኩንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","አሳይ የሱሳ ኦꬄዝ ማላ ብኢ «Ꮊይ ቱማ Ꮊ አላመ የኦድ ግንትንቴዝ ናበ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","የሱሳ ኡ ኤዛ አይኪ ዎልቃር ካዉትሶዳይስ ቆፔዛና ኤሪ፥ ፋ ኣዳስ ደረል አፋ ማቂ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ሳአይ ኦማꬆዳር የሱሳ ታማርታይ አባኮ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ሳአይ ቃሜዝ ግሾስ የሱሳ ሀጋ ኡንትኮ የኤካ ግሾስ ኤ ታማርታይ ዎጎሎ ጋንጨ ገሊ አባ ፒንጊ ቅፍርናሆማ Ꮊማዳይስ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ዎልቃማ ጫርኮ ጫርኬዝ ግሾስ አባይ ኤንእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","እችን ዎይ ኡሱፑን ክሎ ምትረ ማቆዳይ ጋርክ ኡ አባ ፕꬊ Ꮊንጌዛይፕ ጉየ የሱሳ አባል አፋር የꬍታር ይእዛና ብኢ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ዝን ኤ፥ «ያሽትፋተ፥ ታናበ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ኡንቲ ኡፋይቲ ኤዛ ዎጎሎ ጋንጨ ገልሴዛ፤ እዝር ዎጎላይ ኡ Ꮊንግዛ አባ ጋጻ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ዎንትꬃ ጋላስ አባፕ ሰኮ ፕኖ አቴዝ ጋመ አሳይ ፐቲ ዎጎሎ አዳ የዛና በኤዝ ግሾስኔ የሱሳ ፋ ታማርታይር ዎጎሎ ጋንጨ ገሊ፥ ኡንታር Ꮊንጎዛኔ ኡ ፋ ኣዳስ Ꮊንጌዛና አካኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ዝን ጽባራዶሳፕ ሀራ ዎጎልታይ የሱሳ ጾስ ጋላትን፥ አሳይ ሶሎ ሜዝ አቃ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","አሳይ የሱሳ ዎይ ኤ ታማርታይ ኤዛይድ ባዛና ብኢ፥ የሱሳ ኮዮዳይስ ዎጎልታይድ ገሊ ቅፍርናሆማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","አሳይ የሱሳ አባፕ ሰኮ ፕኖ ደንጌዝ ዎደ «አስታማራዮ፥ Ꮊይድ አይድ የኤኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","የሱሳ ማሂ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ይ ታና ኮይዛይ ሶሎ ም ምዤዝ ግሾስፕ አትን ማላ በኤዝ ግሾስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ꬋብዛ ካꬃስ ኦꬅፓተ፥ ዝን መꬍናስ ደኦ እንግዝ ካꬃስ ኦꬆይታ። ጾስ አዳይ ኤ ኦꬆድ ጋርክ ኤዝስ ማዉተ እንጌዝ ግሾስ የ ካꬃ አስ ናአይ ይንትስ እማዳ ኤርሴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","የዝን ኡንቲ፥ «ኑኒ ጾስ ኦꬆ ኦꬆዳይስ አብ ኦꬆዴ?» ዬጊ የሱሳ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","የሱሳ ማሂ፥ «ይ ኦꬆድ ጋርክ ጾሳይ ኮይዝ ኦሳይ Ꮊያ፤ ኤ አዛዜዛና አማኖይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ኡንቲ ማሂ፥ «ኑኒ ብኢ፥ ነና አማኖድ ጋርክ አባ ማላ ነ በሳደ? ነ አብ ኦꬆዴ? ");
INSERT INTO mfxe_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ጌሻ ማጻፋይድ፥ ‹ኡ ማድ ጋርክ ሶሎ ሳሎፕ እንጌዛ› ግንትንቲ ጻፍንቴዛይ ጋርክ ኑ አድታይ ሊዦ ደንባ ማና ሜዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","የሱሳ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ይንትስ ሳሎፕ ቱማ ሶሎ እንጌዛይ ታ አዳይፕ አትን ሙሰ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ይኬ፥ ጾሳይ እንግዝ ሶላይ ሳሎፕ ዎꬌዛይ አላማይስ ደኦ እንግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ኡንቲ ማሂ፥ «ጎዳዮ፥ ኑስ የ ሶላ ኡባ ጋላስ እንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","የሱሳ፥ «ታኒ ደኦ እንግዛ ሶሎ፤ ታኮ ይእዝ ኦንካ ኡባራካ ናይንተና። ማ ታና አማንዛ አꬃይ ኡባራካ ሳምንተና። ");
INSERT INTO mfxe_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ዝን ታኒ ይንትስ ኦዴዛ፤ ይ ታና በኤዛ፥ ዝን አማኖያ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ታ አዳይ ታስ እንግዝ ኡቢታይ ታኮ የኦዳ፤ ማ ታኮ ይእዝ ኦናካ ባለ ዳካሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ታኒ ታ ኮይዝ ባዝ ኦꬆዳይስ ባዝን ታና ኪቴዛይ ኮይዝ ባዝ ኦꬆዳይስ ሳሎፕ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ታና ኪቴዛይ ኮይዛይ Ꮊያ፦ ታኒ ኤ ታስ እንጌዝ ኡብታካ ዉርስꬅ ጋላስ Ꮊይቆፕ ደንꬆዳይ ጋርከፕ አትን ፐታካ ꬋብሶድ ጋርክ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ይኬ፥ ታ አዳይ ኮይዛይ የያ ናአ ብኢ አማንዛ ኡቢታይ መꬍና ደኦ ኤኮዳ፤ ታኒ የ ኡብታ ዉርስꬅ ጋላስ መꬍና ደኦስ Ꮊይቆፕ ደንꬆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","የሱሳ፥ «ታኒ ሳሎፕ ዎꬌዝ ሶሎ» ጌዝ ግሾስ አይሁድታይ ኤዛ ዝግሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ኡንቲ፥ «Ꮊይ ኑኒ ኤ አዳኔ ኤ እንዳት ኤርዛ ዮሴፋ ናአ የሱሳ ባሳኔ? የዝን፥ ኤ ዋይዚ፥ ‹ታኒ ሳሎፕ ዎꬌዛ› ጎዳይስ ዳንዳእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","የሱሳ ማሂ፥ «ፐታይ ፐታይራ ዝግርዛ አሾይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ታና ኪቴዝ ታ አዳይ ታኮ ክእዛ አሳፕ አትን ታኮ የኦዳይስ ዳንዳእዛ ኦንካ ባያ። ታኒ ዉርስꬂ ጋላስ ኤዛ መꬍና ደኦስ Ꮊይቆፕ ደንꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ናብታይ፥ ‹ጾሳይ አስ ኡባ ታማርሶዳ› ዬጊ ጻፌዛ። ኣዳ ስእዛይኔ ኤዝፕ ታማርዛ ኦንካ ታኮ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ጾስ አዳ በኤዛይ ኦንካ ባያ፤ ኤ አዳይ አዳ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«ታኒ ይንትስ ቱሮ ኦድዛ፤ ታና አማንዛ ኦስካ መꬍና ደኦ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ታኒ ደኦ እንግዝ ሶሎ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ይ አድታይ ሊዦ ደምባ ማኖ ሜዛ፥ ዝን Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ሳሎፕ ይእዝ ሶላይ Ꮊያ፤ የ ሶላ ሚዝ ኦንካ Ꮊይቃሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ሳሎፕ የኤዝ ደኦ ሶላይ ታና። ኦንካ Ꮊ ሶላ ሚኮ መꬍናስ የዞዳ። ማ Ꮊ አላማይ ደኦር የዞድ ጋርክ ታኒ ይንትስ እማድ ሶላይ ታ አሾ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","አይሁድታይ፥ «Ꮊ አꬃይ ፋ አሾ ኑ ማድ ጋርክ ኑስ ዋይዚ እማዳይስ ዳንዳኤ?» ዬጊ ዎል ጋንጨ ፓላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","የይ ግሾስ፥ የሱሳ ኡንትኮ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ አስ ናአ አሾ፥ ይ ማም እጽኮ፥ ኤ ሱꬃ ይ ኡዣም እጽኮ፥ ይንትስ ደኦ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ታ አሾ ሚዝ አꬃይስኔ ታ ሱꬃ ኡዥዝ አꬃይስ መꬍና ደኦ የዛ። ታኒ ዉርስꬅ ጋላስ ኤዛ Ꮊይቆፕ ደንꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ታ አሻይ ቱማ ሙንታ፤ ታ ሱꬃይካ ቱማ ኡሺ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ታ አሾ ሚዝ አꬃይኔ ታ ሱꬃ ኡዥዝ አꬃይ ታር የዝዛ፤ ታካ ኤዛር የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ደኦ አዳይ ታና ኪትን፥ ታኒ ኤ ባጋር ደኦር የዛይ ጋርክ፥ ታና ሚዝ አꬃይካ ታ ባጋር ደኦር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ሳሎፕ ዎꬌዝ ሶላይ Ꮊያ፦ ይ አድታይ ም Ꮊይቄዝ ማናይ ጋርክ ባያ፤ Ꮊ ሶላ ሚዝ አꬃይ መꬍናስ የዞዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","የሱሳ ቅፍርናሆማ ካታማ አይሁድታይ ዎሳ ኬꬃ Ꮊያ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","የሱሳ ታማርታይፕ ጋመ ባጋይ የያ ስኢ «Ꮊይ ገሎዋ ትምርተ፤ Ꮊይ ኦስ ገሌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","የሱሳ ፋ ታማርታይ የይስ ዝግሬዛና ኤሪ፥ «Ꮊይ ይንታን ꬉቢኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","የዝን፥ አስ ናአይ ቲን የዛበሳ ፑደ ከሳዳር ይ ብኢ ዋጎደሻ? ");
INSERT INTO mfxe_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","አያናይ ደኦ እንግዛ፤ አስ ዎልቃ አብካ ማዶያ። ታ ይንትስ ኦድዛ ቃላይ ደኦ እንግዝ ጌሻ አያናፕ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ዝን ይ ጋንጨ አማኖዝታይ የዛ» ዬጌዛ። አማኖዝታይ ኦናንታዛኮ የሱሳ ቲናፕ አይኪ ኤርዛ። ማ ፋና ኣꬂ እማዳይ ኦናዛኮ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ማካ የሱሳ፥ «አዳይ Ꮊንጎባ ጌካ ኦንካ ታኮ የኦዳይስ ዳንዳኦያ ግ ታኒ ኦዴዛይ የይ ግሾስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","የይ ግሾስ፥ የሱሳና ካልዝታይፕ ጋምታይ ኤዛ አሺ ጉየ ማቄዛ፤ ማቂ ኤዛ ካልበኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","የሱሳ ታጶ ናምኢ ፋ ታማርታ፥ «ይንትካ አሺ Ꮊማዳይስ ኮይኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ስሞን ጵጽሮሳ ማሂ፥ «ጎዳዮ፥ ኑኒ ኦክ Ꮊማዴ? ነ መꬍና ደኦ እንግዝ ቃላር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ኔኒ ጌሻ ጾሳይ ናአ ማቄዛና ኑኒ አማንዛኔ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","የሱሳ ኡንትኮ፥ «ታኒ ይንታን ታጶ ናምእታ ማራጸካሳ? ዝን ይንትፕ ፐታይ ጻላሄ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","የሱሳ የያ ጌዛይ ስሞና ናአ አስቆሮቶ ይሁዳስ። ይሁዳ የሱሳና አꬂ እማዳይስ የዝ ታጶ ናምኢ ታማርታይፕ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","የይፕ ጉየ፥ አይሁድታይ የሱሳ ዎꬎዳይስ ኮይዝ ግሾስ ኤ ይሁዳ አሺ ጋልላር ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","አይሁድታይ ቦንችዛ ዳሰ ባለ ቦንችንቶዳይስ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","የይ ግሾስ፥ የሱሳ እሽታይ፥ «ነ ታማርታይ ኔኒ ኦꬅዝ ማልታ በአድ ጋርክ Ꮊይፕ ደንዲ ይሁዳ ቢታ ቅቶባ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ፓስ ኤርንቶዳይስ ኮይዝ አስ ኦንካ ፋ ኦሳ ቆሶያ። ኔኒ Ꮊይትታ ኦꬂ ነ ባጋ አላማ ኤርሶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ኤ እሽታይ የያ ጌዛይ ኤዛል አማናም እጼዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","የሱሳ ኡንትኮ፥ «ታስ ዎዳይ ሄለካያ፥ ዝን ይንትስ ኡባ ዎዳይ ጊጋ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","አላማይ ይንታን እጾዳይስ ዳንዳኦያ፥ ዝን ታኒ አላማይ ኦሳይ ኢታ ማቅዛና ማርካትዝ ግሾስ ታና እጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ይ ባላ Ꮊንጎይታ፤ ታ ዎዳይ ሄለካዛይ ግሾስ ታኒ ባላ Ꮊንጋሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ኤ የያ ግ ጋልላ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ኤ እሽታይ ባላ ቦንቾዳይስ Ꮊንጌዛይፕ ጉየ የሱሳ ኦናካ ኤርሰካዛር ቆሶር የ አቃ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","አይሁድታይ ባላ ቦንችዛ አቃይድ፥ «ኤ አባ የኔ?» ዬጊ ኤዛ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","አሳይ ካልካሺ ኤባጋ ኦድንቶዳር ባግታይ፥ «ኤ ሎኦ አስ» ጎዳር አቴዝ አሳይ ማ፥ «ዋኣ፥ ኤ ዎያ ባልꬅዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ዝን አይሁደ ሀላቅታይስ ያሽቴዝ ግሾስ ኦንካ ኤባጋ ጌሻ ኦድንቶዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ባላ ቦንቺ ጋባ ሄልꬆዳር የሱሳ ጾሳ ኬꬅ Ꮊንጊ ታማርሶ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","አይሁድታይ፥ «Ꮊ አꬃይ ትምርተ ታማረካዛር Ꮊያ ኡባ ዋይዚ ኤሬኔ?» ዬጊ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","የሱሳ ማሂ፥ «ታ ታማርስዛ ትምርታይ ታና ኪቴዝ ጾሳፕ ይእዝ ትምርተፕ አትን ታባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ጾስ አዛዞ ኦꬆዳይስ ኮይዝ ኦንካ Ꮊ ትምርታይ ጾሳፕ ይእዛኮኔ ዎይ ታኒ ታፕ ኦድዛኮ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ፓፕ ኦድዝ ኦንካ ፋ ኡባ ቦንቾ ኮይዛ። ዝን ፋና ኪቴዛይ ቦንቾ ኮይዝ ኦንካ ኤ ቱማንቾ፤ ኤዛር ዎርዶ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሰ ይንትስ ህገ እንጌዛ፥ ዝን ይንትፕ ኦንካ ህገ ናገካያ። የዝን አብስ ታና ዎꬎዳይስ ኮዬ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","አሳይ ማሂ፥ «ኔል ጻላሄ የዛ፤ ነና ዎꬎዳይስ ኦኖ ኮይዛይ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","የሱሳ፥ «ታኒ ፐቲ ማላ ኡድን ይ ኡቢታይ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ይንቲ፥ ይ ናእታ ዶካሎድ ጋርክ ሙሰ ኪቴዛ። ዝን ዶካሎ ይ ማይዝታይ ኡዶ አይኬዛፕ አትን ሙሰ ባያ። የይ ግሾስ፥ ይ ማላ ጋላስ ꬊራꬅ ናእታ ዶካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ሙሰ ህጋይ ኪቴዝ ግሾስ ይ ማላ ጋላስ ዶካልዛባዝ ማቅኮ፥ ታኒ ፐቲ አሲ ኩንꬅ ጋላ ፓꬄዝ ግሾስ ታር አብስ ካጬ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ቱማ ፕርደ ፕርዶይታፕ አትን አስ ኣፈ ብኢ ፕርድፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","የሩሳላመ አሳይፕ ፐታይ ፐታይ፥ «ኡ ዎꬎዳይስ ኮይዝ አꬃይ Ꮊያ ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ዬዛኮ፥ ኤ ፕ ኦድዛ፤ ኡንቲ ኤዛ አብካ ጎያ። ኤ ክርስቶሳ ማቅዛና ሀላቅታይ ቱማ ኤርነሻ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ክርስቶሳ ይእዛ ዎደ ኤ አናፕ ይእዛኮ ኦንካ ኤሮያ፥ ዝን ኤ አናፕ የኤዛኮ ኑ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","የሱሳ ጾስ ኬꬃ ታማርስታር ፋ ቃላ ꬎቅ ኡዲ፥ «ቱማ ይ ታኒ ኦናዛኮኔ ታ አናፕ የኤዛኮ ኤርኔ? ታኒ ታ ማዉተር የኤካያ፥ ዝን ታና ኪቴዛይ ቱማ፤ ይ ኤዛ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ዝን ታኒ ኤ ኪትን ኤ ላንቀፕ የኤዝ ግሾስ ኤዛ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","የይ ግሾስ፥ ኡንቲ ኤዛ አይኮዳይስ ኮዬዛ። ዝን ኤ ዎዳይ ሀጋ ሄለካዛይ ግሾስ ኦንካ ኤዛል አፋ ኩሸ ጋደካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ዝን ጋመ አሳይ የሱሳ አማኒ፥ «ክርስቶሳ የኦዳር Ꮊ አꬃይ ኦꬄዝ ማልታይፕ ጋንግዛ ማልታ ኦꬆደኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ፈርሳወ አሳይ ጋመ አሳይ የሱሳ ኦሳይ ባጋ ካልካሾዳር ስኤዛ። ቄሰ ሀላቅታይኔ ፈርሳወ አሳይ ኤዛ አይኪ አጭሾዳይስ ጾስ ኬꬃ ናግዝታ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","የሱሳ፥ «ታኒ ይንታር ጽቃ ዎደ ጋምኦዳ፤ የይፕ ጉየ ታና ኪቴዛይኮ Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ይ ታና ኮዮዳ፥ ዝን ደንጋሚ። ታኒ የዛ አቃ ይ የኦዳይስ ዳንዳኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","አይሁድታይ ፐታይ ፐታይራ፥ «Ꮊይ ኑኒ ደንጎዋ አቆ አባ Ꮊማድ ሀኔ? ግርከ ካታማ ጋንጨ የዝ አይሁድታይኮ Ꮊንጊ ግርክታ ታማርሶዳይስ ሀንነኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹ይ ታና ኮዮዳ፥ ዝን ደንጋሚ› ማ፥ ‹ታኒ የዛበሳ ይ የኦዳይስ ዳንዳኦያ› ጉሳይ አብ ጉሶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ባላ ቦንችዛ ጋላስታይፕ ዎልቃማነ ዉርስꬅ ጋላስ የሱሳ ደንዲ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ሳምንቴዝ ኦንካ ታኮ ይኢ ኡዦ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ታና አማንዛ ኦንካ ጌሻ ማጻፈ ጌዛይ ጋርክ ደኦ እንግዝ ፑልቶ ሃꬃይ ኤ ጋንጨፕ ጎጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ኤ የያ ጌዛይ ኤዛ አማኔዝታይ ኤኮዳይስ የዝ ጌሻ አያናባጋ። የሱሳ ሀጋ ቦንችንተካ ግሾስ የ ዎደ ጌሻ አያናይ እንግንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","የ አሳይፕ ጋምታይ ኤ ግዛ ስኢ፥ «ቱማ Ꮊይ ናበ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ꮊንክታይ ማ፥ «Ꮊይ ክርስቶሳ» ዬጌዛ። ዝን አቴዝ አሳይ ማ፥ «ክርስቶሳ ጋልላፕ የኦደኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ጌሻ ማጻፋይ፥ ‹ክርስቶሳ ዳውተ ሼሻፕ ዳውተ የዜዝ ቤተለመ ካታማፕ የኦዳ› ዬጎሳኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ዝን፥ የሱሳ ግሾስ አሳይ ዎል ጋንጨ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","የ አሳይፕ ፐታይ ፐታይ ኤዛ አይኮዳይስ ኮዬዛ፥ ዝን ኦንካ ኤዛል አፋ ኩሸ ጋደካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ጾሳ ኬꬅ ናግዝታይ ቄሰ ሀላቅታይኮራኔ ፈርሳውታይኮ ጉየ ማቂ ይእን ኡንቲ፥ «አብስ ኤዛ ከኤካሳ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ጾሳ ኬꬅ ናግዝታይ ኡንትኮ፥ «Ꮊ አꬃይ ኦድዛይ ጋርክ ኦንካ ኦድንቶያ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ፈርሳወ አሳይ ማሂ፥ «ኤ ይንታናካ ባልꬄኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","አይሁደ ሀላቅታይፕ ዎይ ፈርሳወ አሳይፕ ኤዛ አማኔዝ አስ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ሙሰ ህገ ኤሮዋ Ꮊ አሳይ ባድቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ፈርሳውታይፕ ፐታይ ቃማ የሱሳኮ Ꮊንጌዝ ንቆድሞሳ ኡንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«ፐቲ አሲ ግዝ ባዝ ስኤካዛር ዎይ ኤ አብ ኦꬄዛኮ ኤረካዛር ቲናቲ ኤዛል አፋ ፕርድዛይ ኑ ህጋይድ የኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ኡንቲ ማቂ፥ «ኔካ ማ ጋልላ ቢታ አሶ? ጋልላ ቢታፕ ናበ ኬዛምዛ ጌሻ ማጻፋይፕ ፕላጊ ደንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ኡቢታይ ፋ ካራ ፋ ካራ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","የሱሳ ደብረ ዛይተ ደረል አፋ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ማ ዎንትꬃ ጋላስ ጉራ ጾሳ ኬꬅ ማቄዛ። ጋመ አሳይ ኤዝኮ ይእን በቲ ኡንታን ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ህገ አስታማርታይኔ ፈርሳወ አሳይ ላግቶዳር አይኬዝ ፐቲ አስቶ ኤዝኮ ከኤዛ። ኡ አስ ኡባይ ቲና እዞ ኤሲ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«አስታማራዮ፥ Ꮊ አስታ ላግቶዳር ኑ አይኬዝ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ሙሰ ህጋይ Ꮊን ጋርክ አስታ ሹቻር ጫድንቲ Ꮊይቆድ ጋርክ ኪትዛ። የዝን፥ ኔኒ ዋጌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ኡ የያ ጌዛይ የሱሳና ፓጪ ኤዛ ሞትዛባዝ ደማዳይሲ። ዝን የሱሳ ዙጊ ፋ ብራር ሳአል ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ኡ ኤዛ ማሂ ማሂ ኦይጪ አሻሚ እጽን፥ ፑደ ꬎቅ ግ፥ «ይ ጋንጨ ናጋራ ኦꬄካ አስ ቲናቲ እዞ ሹቻር ሾጮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ማካ ዙጊ ሳአል ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ኡንቲ የያ ስኤዝ ዎደ ጭምታይፕ አይኪ ፐታይ ፐታይ ከዝታር ዉሬዛ። የሱሳ ኣዳ የ አቃይድ ኤቄዝ አስትር አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ኤ ፑደ ꬎቅ ግ አስትኮ፥ «Ꮊን አስተ፥ አሳይ አና Ꮊንጌኔ? ኔል ፕርዴዝ ኦንካ ባሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ያ አስታ፥ «ጎዳዮ፥ ኦንካ ባያ» ዬጌዛ። የሱሳ ማሂ፥ «ታንካ ኔል አፋ ፕርዳሚ። ቅቶባ፤ Ꮊንፕ ማቂ ናጋራ ኦꬅፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ማካ የሱሳ አሳይኮ፥ «ታኒ አላመስ ፖኦ። ታና ካልዛ ኦንካ ደኦ እንግዝ ፖአና ደንጎዳይፕ አትን ꬉማ ጋንጨ ዉተና» ዬጊ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፈርሳወ አሳይ፥ «ነ ነባዝ ማርካትዛ፥ ዝን ነ ማርካትꬃይ ቱማ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","የሱሳ ማሂ፥ «ታኒ ታባዝ ማርካትኮካ ታ ማርካትꬃይ ቱማ። አብስ ጊኮ፥ ታኒ አናፕ የኤዛኮ ማ አና Ꮊንግዛኮ ኤርዛ፥ ዝን ይ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ይ አስ ቆፋል ፕርድዛ፤ ታኒ ፐቲ አሳላካ ፕርዳሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ታኒ ፕርድዛ ባዝ ማቅኮካ ታ ፕርዳይ ቱማ። አብስ ጊኮ፥ ታና ኪቴዝ ታ አዳይ ታር የዛይፕ አትን ታኒ ታ ኣዳስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ናምኢ አስ ማርካትꬂ ሚንግዛ የይ ይ ህጋይድ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ታኒ ታባዝ ታ ኡባስ ማርካትዛ፤ ማ ታና ኪቴዝ ታ አዳይ ታባዝ ማርካትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ኡንቲ፥ «ነ አዳይ አባ የኔ?» ዬጊ ኤዛ ኦይጬዛ። የሱሳ ማሂ፥ «ይ ታና ዎይ ታ አዳ ኤሮያ። ታና ኤርዛ ማቄዛኮ፥ ይ ታ አዳካ ኤሮዳዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","የሱሳ ጾሳ ኬꬅ ሙጻታ ሚሸ ኦልዝ ሳጽነ የዝ በሳ የያ ታማርሴዛ። ኤ ቃማይ ሀጋ ሄለካዛይ ግሾስ ኦንካ ኤዛ አይከካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ማካ የሱሳ ኡንትኮ፥ «ታኒ Ꮊማዳዝን፤ ይ ታና ኮዮዳ፥ ዝን ይ አቶትꬅ ደንጋሚ ይ ናጋራራ Ꮊይቆዳ። ታኒ Ꮊንግዛ አቆ Ꮊማዳይስ ይ ዳንዳኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","አይሁደ ሀላቅታይ፥ «ኤ፥ ‹ታኒ Ꮊንግዛ አቆ ይ Ꮊማዳይስ ዳንዳኦያ› ዬጌዛ። ኤ ፋና ፋ ኣዳስ ዎꬎዳይሶኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","የሱሳ ማሂ፥ «ይ ሳአፐ፤ ታ አፋፐ። ይ Ꮊ አላማይፐ፥ ታ Ꮊ አላማይፕ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ይ አቶትꬅ ደንጋም ይ ናጋራራ Ꮊይቆድ ግ ታ ይንትስ ኦደዛይ Ꮊይሲ። ታኒ ታና ይ አማናም እጽኮ ይ አቶትꬅ ደንጋሚ ይ ናጋራራ Ꮊይቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ኡንቲ፥ «ኔኒ ኦኖ?» ዬጊ ኦይጬዛ። የሱሳ ማሂ፥ «ታኒ፥ ቲናፕ ይንትስ ኦዴዛይ ታና። ");
INSERT INTO mfxe_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ታኒ ይ ባዝ ኦዲ ፕርድዛ ባዝ ጋመ ባዝ የዛ። ዝን ታና ኪቴዛይ ቱማንቾ፤ ማ ታ ኤፕ ስኤዛን ኣዳ አላማይስ ኦድዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","የሱሳ ፋ አዳይባጋ ኦድዛና ኡ አካኬካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","የይ ግሾስ፥ የሱሳ ኡንትኮ፥ «ይ አስ ናአ ፑደ ꬎቅ ኦꬅዛ ዎደ ታኒ ታና ማቄዛና ይ ኤሮዳ። ማካ ታኒ ታ ስልጻነር አብካ ኦꬆዳኔ ታ አዳይ ታና ታማርሴዛና ኦድዛ ይ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ታና ኪቴዛይ ታር የዛ። ታኒ ኡባ ዎደ ኤዛ ኡፋይስዛ ባዝ ኦꬅዛ ግሾስ ኤ ታና ታ ኡባስ አሸካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","የሱሳ የያ ኦዶዳር ስኤዝ ጋመ አሳይ ኤዛ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","የሱሳ ፋና አማኔዝ አስታይኮ፥ «ይ ታ ትምርታይስ ኪትንትኮ ቱማ ታና ካልዝታ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ይ ቱማ ኤሮዳ፤ ቱማይካ ይንታን ዎዚ ኤኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ኡንቲ ማሂ፥ «ኑኒ አፍራመ ሼሺ፤ ኑኒ ኦስካ አይልትበኤካያ። ነ ዋጊ፥ ‹ይ ዎዝንቶዳ ጌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","የሱሳ ማሂ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ናጋራ ኦꬅዝ ኦንካ ናጋራ አይለ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","አይለ መꬍናስ ካራ አሳር የዞያ፥ ዝን ናአይ መꬍናስ ካራ አሳር የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ናአይ ይንታን ዎዝኮ ይ ቱማ ዎዝንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ይ አፍራመ ሼሽ ማቄዛና ታኒ ኤርዛ። ዝን ታ ቃላይ ይ ዎዝና ጋንጨ ባዛይ ግሾስ ታና ዎꬎዳይስ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ታኒ ታ አዳይ ታና ቤዜዛና ኦድዛ፥ ዝን ይንትካ ይ አዳይፕ ስኤዛን ኦꬅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ኡንቲ ማሂ፥ «ኑ አዳይ አፍራመ» ዬጌዛ። የሱሳ ኡንትኮ፥ «ይ አፍራመ ናእታ ማቄዛኮ ኤ ኦꬄዛና ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ዝን ጾሳፕ ስኤዝ ቱማ ኦዴዝ ታና ይ ዎꬎዳይስ ኮይዛ። አፍራመ Ꮊይ ጋርክ ኦꬄካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ይንቲ፥ ይ አዳይ ኦꬄዛና ኦꬅዛ» ዬጌዛ። ኡንቲ ማሂ፥ «ኑኒ ላግተር የልንቴዝ ናእታ ባያ፤ ኑስ ፐቲ አዳይ ጾሳይ ኣዳ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","የሱሳ ኡንትኮ፥ «ጾሳይ ቱማ ይ አደ ማቄዛኮ ይ ታና ቃꬎዳ፤ አብስ ጊኮ፥ ታ ጾስ ላንቀፕ ይኢ Ꮊይዳ የዛ። ታና ኤ ኪቴዛፕ አትን ታኒ ታ ማዉተር የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ታኒ ግዛ ይ ስኦዳይስ ኮዦዋ ግሾስ ታ ግዝ ባዝ ይንትስ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ይንቲ፥ ይ አዳይ ጻለሃይ ናእታ። ማ ይንቲ፥ ይ አዳይ አሞትዝባዝ ኦꬆዳይስ ኮይዛ። ኤ ቲናፕ አይኪ ሸምፖ ዎꬍዛያ። ቱማ ኤዛር ባዛይ ግሾስ ኤ ቱማ እጽዛ። ዎርዶ ኤዝስ መꬎ ማቄዝ ግሾኔ ኤ ዎርዶ አደኔ ዎርዶ ኦድንትታር ፓፕ ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ታኒ ቱሮ ኦድዛ፥ ዝን ይ ታና አማኖያ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ይንታፕ፥ ‹ኔኒ ናጋራ ኦꬆዳር ታ በኤዛ› ጎዳይስ ዳንዳእዛይ ኦኖ? ታኒ ቱሮ ኦድንትዛባዝ ማቅኮ ታና አብስ ይ አማኖሳ? ");
INSERT INTO mfxe_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ጾስ አሲ ጾሳይ ግዝ ባዝ ስእዛ። ይ ጾስ አስ ማቀካ ግሾስ ጾሳይ ግዝ ባዝ ስኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","አይሁድታይ ማሂ፥ « ‹ኔኒ ሳማረ አሲ፤ ኔል ቱና አያና የዛ› ጉሳይድ ቡታ የኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","የሱሳ ኡንትኮ «ታል አፋ ቱና አያና ባያ። ታኒ ታ አዳ ቦንችዛ፥ ዝን ይ ታና ካዉሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ታኒ ታ ኡባስ ቦንቾ ኮዮያ፤ ታኒ ቦንችንቶድ ጋርክ ኮይዛይኔ ታስ ፕርድዛይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ታኒ ይንትስ ቱሮ ኦድዛ፤ ታ ቃላ ናግዝ ኦንካ Ꮊይቃሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","አይሁድታይ ማሂ፥ «ኔል አፋ ቱና አያና የዛና ኑኒ Ꮊት ኤሬዛ። አፍራመ Ꮊይቄዛ፤ ናብታይካ Ꮊይቄዛ። ዝን ኔኒ፥ ‹ታ ቃላ ናግዝ ኦንካ Ꮊይቃሚ› ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ኔኒ Ꮊይቄዝ ኑ ኣዳ አፍራመፕ ኣꬊኔ? ናብታይካ ማ Ꮊይቄዛ። ኔኒ ነና ኦና ግ ቆፔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","የሱሳ፥ «ታኒ ታና ቦንችኮ ታ ቦንቻይ ጨረ። ይ፥ ‹ኑ ጾሳ› ግዝ ታ አዳይ ኤ ታና ቦንችዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ይ ኤዛ ኤራም እጽኮ ታኒ ኤዛ ኤርዛ። ታኒ ኤዛ ኤሮያ ጊኮ ይ ጋርክ ዎርዶትዛ። ዝን ታኒ ኤዛ ኤርዛ፤ ማ ኤ ቃላካ ታ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","አዳይ አፍራመ ታ ይእꬅ ጋላሳ ብኢ ኡፋይቶዳይስ አሞቴዛ፤ ብእካ ኡፋይቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","አይሁድታይ ማሂ፥ «ሀራ አቶዝን፥ ኔስ እሻታም ላይꬅ ኩመካዝን ዋይዚ አፍራመ በኤዛ ጌ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","የሱሳ ኡንትኮ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ አፍራመ የልንቶዳይፕ ቲን ታኒ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","የይ ግሾስ፥ ኡንቲ የሱሳ ሾጮዳይስ ሹች ኤኬዛ። ዝን የሱሳ ኡንታፕ ጌሚ ጾሳ ኬꬃፕ ከዚ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","የሱሳ Ꮊንግታር የልንቴዛይፕ ቶአ ማቂ የዝ ፐቲ አꬃ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ኤ ታማርታይ፥ «አስታማራዮ፥ Ꮊ አꬃይ ቶአ ማቂ የልንቶድ ጋርክ ናጋራ ኦꬄዛይ ኦኖ? ኤ ኦꬄነኔ ኤዛ የሌዝታይ ኦꬄኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","የሱሳ፥ «ጾሳ ኦሶ ኤዛል አፋ በንቶድ ጋርከፕ አትን ኤ ዎይ ኤዛ የሌዝታይ ናጋራ ኦꬄዝ ግሾስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ጋላሳ የዝን ታና ኪቴዛይ ኦሳ ታ ኦꬆዳይስ ቤዝዛ። ኦንካ ኦꬆዳይስ ዳንዳኦዋ ቃማይ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ታኒ አላማይድ የዛር አላማይስ ፖኦ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","የሱሳ የያ ግ ሳአ ጩቴዛ። ፋ ጩቻይር ላፋ ቢታ ላክꬂ የ ኡርቃይር ቶአ አꬃይ አፋ ትዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ዬዚ፥ «Ꮊንጊ ሳልሆመ ግዝ ተቅንቴዝ ሃꬃ ነ አፋ ሜጭንቶባ» ዬጌዛ። (ሳላሆመ ጉሳይ ኪትንቴዛ ጉሲ) የይ ግሾስ፥ አꬃይ Ꮊንጊ ፋ አፋ ሜጭንቲ ብእታር ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","አꬃይ ሾርታይኔ አꬃይ ቲን ዎሶዳር በኤዝ አሳይ፥ «Ꮊይ በቲ ዎስዛ አꬃ ባሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ፐቲ ፐቲ አሳይ፥ «Ꮊይ ኤዛ» ዬጌዛ። Ꮊንክታይ ማ፥ «ዋአ፥ Ꮊይ ኤዛ አዝዛፕ አትን ኤዛ ባያ» ዬጌዛ። ዝን አꬃይ፥ «ኤ፥ ታና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ኡንቲ ኤዝኮ፥ «የዝን ነ ኣፋይ ዋይዚ በኤኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ኤ ማሂ፥ «የሱሳ ግዝ አꬃይ ጽቃ ኡርቃ ላክꬂ ታ አፋ ትዢ፥ ‹ሳልሆመ Ꮊንጊ ነ አፋ ሜጭንቶባ› ዬግን፥ ታኒ Ꮊንጊ ሜጭንቲ ብኢ አቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ኡንቲ ኤዝኮ፥ «ኤ አባ የኔ?» ዬጊ ኦይጬዛ። አꬃይ፥ «ታኒ ኤሮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ኡንቲ ቲን ቶአ፥ ዝን Ꮊት በኤዝ አꬃ ፈርሳውታይኮ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","የሱሳ ኡርቃ ላክꬂ አꬃይ አፋ ፓꬄዝ ጋላሳይ ማላ ጋላሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","የይ ግሾስ፥ አꬃይ ዋይዚ በኤዛኮ ፈርሳወ አሳይ ኤዛ ማሂ ኦይጬዛ። አꬃይ ኡንትኮ፥ «ኤ ታ ኣፋተ ጽቃ ኡርቃ ትዤዛ። ታ ኣፋ ሜጭንቲ Ꮊት ብእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ፈርሳውታይፕ ፐታይ ፐታይ፥ «Ꮊያ ኦꬄዝ አꬃይ ማላ ህገ ናጎዋ ግሾስ ጾሳፕ የኤካያ» ዬጌዛ። ዝን Ꮊንክታይ፥ «ናጋራንቾ አሲ Ꮊይ ጋርክ ማልታ ዋይዚ ኦꬆዳይስ ዳንዳኤ?» ዬጊ ዎል ጋንጨ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","የይ ግሾስ፥ ፈርሳወ አሳይ አꬃይኮ፥ «ኤ ነ አፋ ብእሴዝ ግሾስ ነ ኤባዝ ዋጌ?» ዬጌዛ። አꬃይ፥ «ኤ ናበ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","አይሁደ ሀላቅታይ፥ ኤ እንዳቶኔ አዳ ጼጊ ኦይጮድ ጋꬆ፥ አꬃይ ቲን ቶአ ማቄዛኔ Ꮊት ኤ ብእዛና አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ኡንቲ ኤ እንዳትኔ ኤ አዳይኮ፥ «ይ ‹ቶአ ማቂ የልንቴዛ› ግዝ ይ ናአይ Ꮊያ? የዝን፥ Ꮊት ዋይዚ በኤኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ኤዛ የሌዝታይ፥ «Ꮊይ ኑ ናአ ማቄዛኔ ቶአ ማቂ ኤ የልንቴዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ዝን Ꮊት ኤ ዋይዚ በኤዛኮ ማ ኤ አፋ ኦኒ ፓꬄዛኮ ኑኒ ኤሮያ። ኤዛ ኦይጮይታ። ኤ ፋና ኤሬዝ አስ ማቄዝ ግሾስ ፋባዝ ኦዶዳይስ ዳንዳእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ኤዛ የሌዝታይ የያ ጌዛይ አይሁድታይስ ያሽቴዝ ግሾስ። አብስ ጊኮ፥ አይሁድታይ፥ የሱሳና ኤ ክርስቶሳ ዬጊ ማርካትዝ አሲ የዛኮ የ አꬃ አይሁድታይ ዎሳ ኬꬃፕ ባይኦዳይስ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ኤዛ የሌዝታይ፥ «ኤ ፋና ኤሬዝ አሲ፤ ኤዛ ኦይጮይታ» ዬጌዛይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","የይ ግሾስ፥ ቶአ ማቂ የልንቴዝ አꬃ ኡንቲ ማሂ ጼጊ፥ «ቱማ ኦዶዳይስ ጾሳ ቦንቾባ፤ Ꮊ አꬃይ ናጋራንቾ ማቅዛና ኑ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","አꬃይ ማሂ፥ «ኤ ናጋራንቾ ማቄዛና፥ ታ ኤሮያ። ታኒ ቶአ ማቄዛናኔ Ꮊት ብእዛና ኣዳ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ኡንቲ ማሂ፥ «ኤ ኔስ አብ ኦꬄኔ? ኤ ነ ኣፋ ዋይዚ ፓꬄኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ኤ ኡንትኮ፥ «ታኒ ይንትስ ኦዴዛ፥ ዝን ይ ስኤካያ። አብስ ማቂ ማቂ ስኦዳይስ ኮይኔ? ይንትካ ኤ ታማረ ማቆዳይስ ኮይኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ኡንቲ ኤዛ ጫዢ፥ «ነ የ አꬃይ ታማረ፤ ኑኒ ሙሰ ታማረ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ጾሳይ ሙሰስ ኦዴዛና ኑኒ ኤርዛ፥ ዝን Ꮊ አꬃይ ኤ አናፕ የኤዛኮካ ኑ ኤሮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","አꬃይ ኡንትኮ፥ «ኤ አናፕ የኤዛኮ ይንቲ ኤሮዛይ ማላባዝ፥ ዝን ኤ ታ ኣፋ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ጾሳ ቦንችዛኔ ኤ ኮይዝ ባዝ ኦꬅዛ አꬃ ጾስ ስኤዛፕ አትን ናጋራ ኦꬅዝታ ስኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ሳሎ ሳአ መꬊንቴዛይፕ ቶአ ማቂ የልንቴዝ አስ ኣፈ ፓꬄዛይ ኦንካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ꮊ አꬃይ ጾሳፕ ኪትንተካዛኮ ፐትባዝካ ኦꬆዳይስ ዳንዳኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ኡንቲ ማቂ፥ «ኔኒ ናጋራራ የልንቲ ድጬዛይ ኑና ታማርሶዳይስ ኮይኔ?» ዬጌዛ። ኡ ኤዛ አይሁድታይ ዎሳ ኬꬃፕ ከሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","የሱሳ ኡንቲ አꬃ ባለ ከሴዛና ስኢ ኤዛ ሄሊ፥ «አስ ናአ ነ አማንኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","አꬃይ የሱሳኮ፥ «ጎዳዮ፥ ታ ኤዛ አማኖድ ጋርክ ኤ ኦኖ? ታስ ኦዶየ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","የሱሳ አꬃይኮ፥ «ነ ኤዛ በኤዛ፤ Ꮊ ኔር ኦድንትዛይ ኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","አꬃይ ማሂ፥ «ጎዳዮ፥ ታ አማንዛ» ዬጊ የሱሳስ ጎይኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","የሱሳ፥ «ቶእታይ በአድ ጋርክ ብእዝታይ ቶኦዳይ ጋርክ ፕርዶዳይስ Ꮊ አላመ ታ የኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ኤዛር የዝ ጽቃ ፈርሳወ አስታይ የያ ስኢ፥ «ኑ ቶአኔ?» ዬጊ ዎል ኦይጭቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","የሱሳ፥ «ይ ቶእታ ማቄዛኮ ይንትስ ናጋራ ባያ። ዝን Ꮊት ይ ብእዛ ግዝ ግሾስ ይ፥ ይ ናጋራራ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","የሱሳ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ዱር ካለ ጋንጨ ፐንገር ባዝን ሀራ ኦገር ገልዝ ኦንካ ካይዞኔ ፓኖ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","የያ ማቆዝን ፐንገር ገልዛይ ዱርታ ሄንግዛያ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ፐንገ ናግዛይ ኤዝስ ፐንጋ ዶይዛ፤ ዱርታይካ ኤ ቃላ ስእዛ። ኤ ፋ ዱርታ ኡ ሱንꬃይር ሱንꬃይር ጼግዛ፤ ኡንታን ካልꬂ ባለ ከስዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ኤ ኦꬄዝ ፋስታ ባለ ከሴዛይፕ ጉየ ኡ ቲና ቲና የꬍዛ። ኡንትካ ኤ ቃላ ኤርዛ ግሾስ ኤዛ ካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ሀራ አስ ቃላ ኡንቲ ኤሮዋ ግሾስ ኤፕ ሃክዛፕ አትን ኤ ላሳ ካሎያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","የሱሳ ኡንትስ Ꮊ ኣዝሳ ኦዴዛ፥ አብ ኦዴዛኮ ኡንቲ አካከካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ማሂ የሱሳ ኡንትኮ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ታ ዱርታይስ ፐንገ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ታፕ ቲን የኤዝ ኡቢታይ ካይዞኔ ፓኖ፥ የያ ማቃዳር ዱርታይ ኡንታን ስኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ፐንጋይ ታና፤ ታ ባጋር ገልዛ ኦንካ አቶዳ። ኤ ታ ባጋር ገሎዳኔ ከዞዳ፤ ሎኦ ሄንግንትዝ አቆ ደማዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ካይዞ ካስቶዳይስ፥ ሹኮዳይስኔ ꬋብሶዳይስ ይእዛፕ አትን ሀራባዝስ የኦያ። ታኒ ኡንትስ ደኦ የዞድ ጋርከራኔ ኩሚ ፉጮድ ጋርክ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«ታኒ ሎኦ ሄንꬃንቾ፤ ሎኦ ሄንꬃንቻይ ፋ ዱርታይ ግሾስ ፋ ሸምፖ ኣꬂ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ከራ ሄንግዝ አስ ዱርታይ ጎዳነ ሄንꬃንቾ ባዛይ ግሾስ ፉገ ይእኮ ብኢ ዱርታ አሺ ሀልእዛ። የይ ግሾስ፥ ሱꬉመ ዱርታ አይኪ ላልዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ከራ ሄንግዛይ ሚሸስ ሄንግዝ ግሾኔ ዱርታይባዝ ኤዛ ቆፍሶዋ ግሾስ ዱርታ አሺ ላስዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«ታኒ ሎኦ ሄንꬃንቾ። ታ አዳይ ታና ኤርዛይ ጋርክ ታንካ ታ አዳ ኤርዛ። የይ ጋርከካ፥ ታ ታ ዱርታ ኤርዛ፤ ታ ዱርታይካ ታና ኤርዛ። ታኒ ታ ዱርታይ ግሾስ ታ ሸምፖ ኣꬂ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ꮊ ዉዳይድ ባ ሀራ ዱርታይ ታስ የዛ። ታኒ ኡንታናካ ኮኦዳይስ ቤዝዛ። ኡንቲ ታ ቃላ ስኦዳ፤ ኡንቲ ፐቲ ዉደ ማቃዳ፤ ሄንꬃንቻይካ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«ታኒ ታ ሸምፖ ኣꬂ እንጊ ማሂ ኤክዝ ግሾስ ታ አዳይ ታና ዶሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ታ ዶስዛ ታ ሸምፖ ኣꬂ እንግዛይፕ አትን ታፕ ኦንካ ኤከና። ታ ታ ሸምፖ ኣꬂ እማዳይስኔ ማሂ ኤኮዳይስ ስልጻኔ ታስ የዛ። ታኒ ኦꬆድ ጋርክ ታ አዳይ ታና ኪቴዛይ Ꮊያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","የያ ኤ ጌዝ ግሾስ አይሁድታይ ጋንጨ ማካ ሻኮተꬂ መꬍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ኡንታፕ ጋመ ባጋይ፥ «ኤዛር ቱና አያና የዛ! ኤ ኤይዛ! ኤ ግዝ ባዝ አብስ ስእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ꮊንክታይ ማ፥ «ጻላሄ አይኬዝ አስ Ꮊይ ጋርክ ኦድንቶያ። ቱና አያና ቶአ ኣፈ ቤዞዳይስ ዳንዳእኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","የሩሳላመ ጾሳ ኬꬅ ኦሮꬄዝ ጋላስታይ ቦንችዛ ባለ ሄሌዛ፤ የ ዎደ ሳአ ባርጎ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","የሱሳ ጾሳ ኬꬅ ሶሎሞነ ባራንዳር ዩይዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","አይሁድታይ የሱሳ ላንቃይድ ሺቂ ኤቂ፥ «ኔኒ ኑና አይደ ሄሎዳይስ ስር ጋዶዴ? ኔኒ ክርስቶሳ ማቅኮ አን ኑስ ጌሺ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","የሱሳ ማቂ ኡንትኮ፥ «ታኒ ይንትስ ኦዴዛ፤ ዝን ይ ታና አማኖያ። ታኒ ታ አዳይ ታስ እንጌዝ ማዉተር ኦꬅዛ ኦሳይ ታባዝ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ዝን ታኒ ይንትስ ኦዴዛይ ጋርክ ይ ታ ዱረ ማቀካ ግሾስ አማኖያ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ታ ዱርታይ ታ ቃላ ስኦዳ። ታ ኡንታን ኤርዛ፤ ኡንትካ ታና ካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ታኒ ኡንትስ መꬍና ደኦ እንግዛ፤ ኡንቲ ኡባራካ ꬋባሚ። ኦንካ ታ ኩሸፕ ኡንታን ቦንቂ ኤኮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ኡንታን ታስ እንጌዝ ታ አዳይ ኡባፕ ኣꬍዛ ኦንካ ታ አዳይ ኩሸፕ ኡንታን ቦንቂ ኤኮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ታኔ ታ አዳይ ፐቶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","አይሁድታይ የሱሳ ሾጮዳይስ ማካ ሹች ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","የሱሳ ኡንትኮ፥ «ታኒ ኦꬆድ ጋርክ ታ አዳይ ታስ እንጌዝ ጋመ ሎኦ ኦስታ ይንታን ኦꬂ ቤዝዛ። የይትታይፕ ኣያይ ግሾስ ታና ሹቻር ሾጮዳይስ ኮይኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","አይሁድታይ ማሂ፥ «ኑኒ ነና ነ ሎኦ ኦሶ ግሾስ ሹቻር ሾጮዳይስ ኮዮያ። ዝን ኔኒ ጾስ ጫዤዝ ግሾኔ አስ ማቅታር ነ ነና ጾስ ግዝ ግሾስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","የሱሳ ማሂ፥ «ጌሻ ማጻፋይድ ጾሳይ፥ ‹ይ ጾስታ› ጌዛይ ጻፍንተካሳ? ");
INSERT INTO mfxe_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ጌሻ ማጻፋይ መꬍናስ ላምንታሚ። ጾሳይ ፋ ቃላ እንጌዝ አስታ፥ ‹ጾስታ› ግ ጼግኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ታ ታና ጾስ ናአ ጌዛይስ፥ አዳይ ማራጺ Ꮊ አላመ ኪቴዝ ታና ጾስ ናአ ዋይዚ ‹ጾሳ ነ ጫዥዛ› ዬጌ? ");
INSERT INTO mfxe_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ታኒ ታ አዳይ ኦꬅዛና ኦꬃም እጽኮ ታና አማንፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ዝን ታኒ ኦꬅዛባዝ ማቅኮ ይንቲ ታና አማናም እጽኮካ፥ ታ አዳይ ታር የዛኔ ታካ ታ አዳይር የዛና ይ ኤሮድ ጋርክ ታ ኦሳ አማኖይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ማካ ኡንቲ ኤዛ አይኮዳይስ ኮዬዛ፥ ዝን ኤ ኡንታፕ ቡቲ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ዋንሳ ቲን ጻማቅዛ አቃ፥ ዮርዳኖሳ ቦርካፕ ሰኮ ፕኖ የሱሳ ፒንጊ ኤዛይድ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ጋመ አሳይ የሱሳኮ ይኢ፥ «ዋንሳ ማላታ ኦꬄካያ፥ ዝን ኤ Ꮊ አꬃያባዝ ኦዴዝባዛይ ኡባይ ቱማ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ኤዛይድ ጋመ አሳይ የሱሳ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ብታና ሄራ አላዛራ ግዝ ፐቲ አꬃይ ሀርግንቴዛ። ብታና ማይራምራኔ እ ምሽት ማርታራ የዛ ሄራ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ማይራማ ጎዳይ ቶካ ሽቶ ትዤዝ ፋ ብናናይራካ ኤ ቶካ ኡጬዛኖ። ሀርግንቴዛይ እ እሻ አላዛራ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","የይ ግሾስ፥ ምሹንꬅካ፥ «ጎዳዮ፥ ነ ዶስዛይ ሀርግንቴዛ» ግ የሱሳኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","የሱሳ የያ ስኢ «Ꮊ ሀርጋይ፥ ጾሳይኔ ኤ ናአይ ቦንችንቶድ ጋርከፕ አትን Ꮊይቆስ ሄልꬅዝ ሀርገ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","የሱሳ ማርታ፥ እ ምሽቶኔ አላዛራ ቃꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ዝን አላዛረ ሀርግንቴዛ ግን የሱሳ ስኢ ፋ የዛ አቆ ናምኢ ጋላስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","የይፕ ጉየ፥ የሱሳ ፋ ታማርታይኮ፥ «ማሂ ይሁዳ ቢታ ዎላ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ኤ ታማርታይ ማሂ፥ «አስታማራዮ፥ ጽቃ ዎደፕ ቲን አይሁድታይ ነና ሹቻር ሾጪ ዎꬎዳይስ ኮዬዛኔ፤ Ꮊተካ ገደ Ꮊማዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","የሱሳ፥ «ፐቲ ጋላሳ ጋንጨ ታጶ ናምኢ ሳት ባሳኔ? ጋላስ የꬍዝ አሲ Ꮊ አላመ ፖአ ብእዛ ግሾስ ꬉብንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ዝን ቃማ የꬍዝ ኦንካ ፖኦ ባዛይ ግሾስ ꬉብንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","የሱሳ የያ ጌዛይፕ ጉየ ኡንትኮ፥ «ኑ ቃꬍዛ አላዛረ ገንቴዛ፥ ዝን ኤዛ ደንꬆዳይስ ታኒ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ኤ ታማርታይ ማሂ፥ «ጎዳዮ፥ ኤ ገንቴዝባዝ ማቅኮ ኤስ ሎኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","የሱሳ አላዛረ Ꮊይቄዛይ ግሾስ የያ ኦዴዛ፥ ዝን ኡንትስ ጨር ገንታ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","የይ ግሾስ፥ የሱሳ ቆንጭሲ ኡንትኮ፥ «አላዛረ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ይ አማኖድ ጋርክ ታኒ የ አቃይድ ባ ማቄዛይስ ይ ግሾስ ታና ኡፋይስዛ። አን የꬎይታ፤ ኤዝኮ ዎላ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","የይፕ ጉየ፥ ድድሞሳ ግንትንትዝ ቶማሳ ፋ ላገ ታማርታይኮ፥ «አስታማራይር Ꮊይቆዳይስ ኑካ ዎላ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","የሱሳ ብታና ሄሎዳር አላዛረ ሞግንትን ኦይዲ ጋላስ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ብታና የሩሳላመፕ ሀይꬒ ክሎ ምትረ ጋርክ ሃክዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ጋመ አይሁድታይ ማርታኔ ማይራሞ ኡ እሻይ Ꮊይቄዛይስ ምንꬃꬆዳይስ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታ የሱሳ የኤዛና ስኢ ኤዛ ሞኮዳይስ ከዜዝ፥ ዝን ማይራማ ኬꬃ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታ የሱሳኮ፥ «ጎዳዮ፥ ኔኒ Ꮊይዳ የዛ ማቄዛኮ ታ እሻይ Ꮊይቃም። ");
INSERT INTO mfxe_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ዝን Ꮊት ማቅኮካ ኔኒ ዎስዛ ባዝ ጾሳይ ኔስ እማዳና ታኒ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","የሱሳ፥ «ነ እሻይ Ꮊይቆፕ ደንዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርታ ኤዝኮ፥ «ዉርስꬅ ጋላስ ኤ Ꮊይቆፕ ደንዶዳና ታ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","የሱሳ እዝኮ፥ «ታኒ ደንዶኔ ደኦ፤ ታና አማንዛ ኦንካ Ꮊይቅኮካ ደኦር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ማ ደኦር የዛይኔ ታና አማንዛ ኦንካ Ꮊይቃም። የያ ነ አማንኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ማርታ ማሂ፥ «ጎዳዮ፥ ኤ ታኒ አማንዛ! ኔኒ ጾስ ናአ፥ አላመ የኦዳይስ የዛ ክርስቶሳ ማቅዛና ታኒ አማንዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርታ የያ ጌዛይፕ ጉየ፥ Ꮊንጊ ፋ ምሽቶ ጌማ ጼጊ፥ «አስታማራይ ይኢ ነና ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ማይራማ የያ ስኢ ኤልሲ ደንዲ የሱሳኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","የ ዎደ የሱሳ ማርታ ኤዛ ሞኬዝ አቆ የዛ፤ ሀጋ ሄራ ሄለካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ማይራሞ ምንꬃꬅታር እዝር ካራ የዝ አይሁድታይ፥ እዛ ደንዲ ኤልሲ ባለ ከዜዛያ ብኢ፥ ዱፎ Ꮊንጊ ዬኮዳይስ ሀንዛ ኣዝን እዞ ካሊ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማይራማ የሱሳ የዛ አቃ Ꮊንጊ ኤዛ ብኢ ኤ ቶካይል አፋ ጉጲንጊ፥ «ጎዳዮ፥ ኔኒ Ꮊይዳ የዛ ማቄዛኮ ታ እሻይ Ꮊይቃምዝን» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","የሱሳ ማይራምኔ ኢር የዝ፥ አይሁድታይ ዬክዛና ብኢ፥ ፋ ዎዝናር ኢታ ምጭንቲ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«አባ ሞጌኔ?» ዬጊ ኦይጭን፥ «ጎዳዮ፥ ይኢ ቦኦባ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","የሱሳ አፉጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","የይ ግሾስ፥ አይሁድታይ፥ «ኤ አላዛራ አብ ጋርክ ቃꬍዛኮ ቦኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ዝን ኡንታፕ ፐታይ ፐታይ፥ «Ꮊይ ቶአ ብእሴዛይ Ꮊ አꬃይ Ꮊይቃም ጋርክ ኦꬆዳይስ ዳንዳአሞኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ማካ የሱሳ ምጭንቲ፥ አላዛረ ሞግንቴዝ ዱፋ ቅቴዛ። የ ዱፋይ ሹቻር ጎርድንቴዝ ኮምኦ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","የሱሳ፥ «ሹቻ ደንꬆይታ» ዬጊ ኪቴዛ። ማርታ፥ «ጎዳዮ፥ ኤ Ꮊይቄዛይፕ ኦይዲ ጋላስ ማቄዝ ግሾስ Ꮊት ዜቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","የሱሳ ማርታኮ፥ «ነ አማንዛባዝ ማቅኮ ጾስ ቦንቾ በአዳና ታኒ ኔስ ኦደካሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ኡንቲ ሹቻ ደንꬅን የሱሳ ሳሎ ፑደ ብኢ፥ «አዳዮ፥ ታና ነ ስኤዝ ግሾስ ነና ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ነ ኡባ ዎደ ታና ስእዛና ታኒ ኤርዛ። ዝን Ꮊይዳ ኤቄዝ አሳይ ኔኒ ታና አዛዜዛና አማኖዳይ ጋርክ ታኒ ኡ ግሾስ Ꮊያ ግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","የሱሳ የያ ጌዛይፕ ጉየ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «አላዛራ፥ Ꮊና ከዞባ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ꮊይቄዝ አꬃይ ዝꬍꬃትር ኩሻይኔ ቶካይ ሻሎር አጭንቲ የዝን ኤ ኣፈ ባጋይ ጎዝንቴዝን ዱፋይፕ ከዜዝ። የሱሳ ኡንታን፥ «ብሎይታ! Ꮊመ ጎይታ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","የይ ግሾስ፥ ማይራምኮ የኤዝ አይሁድታይፕ ጋምታይ የሱሳ ኦꬄዛና ብኢ ኤዛ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ዝን ኡንታፕ ፐታይ ፐታይ ፈርሳውታይኮ Ꮊንጊ የሱሳ ኦꬄዛና ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","የይፕ ጉየ፥ ቄሰ ሀላቅታይኔ ፈርሳወ አሳይ ሻንጎ ሺሺ፥ «Ꮊ አꬃይ ጋመ ማላ ኦꬅዝ ግሾስ ኑ አብ ኡዶ? ");
INSERT INTO mfxe_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ኑኒ ኤዛ ስእ ግ አሽኮ አስ ኡባይ ኤዛ አማኖዳ። ማ ኦሮመ ቢታ አሳይ ይኢ ኑ ጾሳ ካራኔ ኑ ጋዳ ꬋብሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ኡንታፕ ፐታይ ቃያፋ ግዛይ፥ የ ላይꬅ ቄሰ ሀላቃ ማቄዛይ፥ «ይ አብካ ኤሮያ! ");
INSERT INTO mfxe_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","አሳይ ኡቢታይ ꬋብዛይፕ አስ ኡባይ ግሾስ ፐቲ አስ Ꮊይቅዛይ ሎኦ ማቅዛና ይ ኤሮሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ኤ የያ ፓፕ ጌካያ። ዝን (የ ላይꬅ ቄሰ ሀላቃ ማቅዝ ግሾስ የሱሳ አይሁደ አስ ግሾስ Ꮊይቆዳይስ ቤዝዛና ትንቢተ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ማ የሱሳ አይሁደ አስ ኣዳስ ባዝን ላልንቲ የዝ ጾሳ አሲ ኡባ ዎላል ሺሾዳይስኔ ፐቲ አሲ ኦꬆዳይስ Ꮊይቆዳ።) ");
INSERT INTO mfxe_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","የ ጋላሳፕ አይኪ ኡንቲ ኤዛ ዎꬎዳይስ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","የይ ግሾስ፥ የሱሳ አይሁድታይ ጋንጨ ጌሻር ዩየካያ። ዝን ሊዦ ደንባ ላንቀ የዝ ኤፍሬመ ሄራ Ꮊንጌዛ። ፋ ታማርታይር የ አቃይድ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","አይሁድታይ ቦንችዛ ፓዝቃ ጋላሳይ ኡኬዛ። ማ ጋመ አሳይ ፋና ቃሾዳይስ ፓዝቃ ቦንችዛ ጋላሳይ ሄሎዳይፕ ቲና የ ቢታፕ የሩሳላመ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ኡንቲ ጾሳ ኬꬃ ኤቂ የሱሳ ይእꬃ ናግዛ ግሾስ «አብ ቆፔ? የሱሳ ባላ ቦንቾዳይስ የኦሳ?» ዬጊ ፐታይ ፐታ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ቄሰ ሀላቅታይኔ ፈርሳወ አሳይ የሱሳ አይኮዳይስ፥ ኤ የዛበሳ ኤርዛ ኦንካ ፓስ ኦዶድ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ፓዝቃ ቦንችዛ ጋላስፕ ኡሱፑን ጋላስ ቲናቲ፥ የሱሳ Ꮊይቆፕ ደንꬄዝ አላዛረ የዝ ሄራ፥ ብታና ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","የ አቃይድ ኡንቲ ኤስ ካሆ ጊግሴዛ። አላዛረ የሱሳር ዎላል ሙንታል በቴዝን ማርታ ኡንታን ሞክዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ማይራማ ናርዶሳ ግዝ ጋመ አልኦ ጌሽ ሽቶ ክኢ የሱሳ ቶካ ትዤዛ። ፋ ብናናይር ኤ ቶካ ኡጬዛ፤ ኬꬃ ኡባይ ሽቶ ሳዎር ቶንክ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ዝን የሱሳ ታማርታይፕ ፐታይ፥ የሱሳ ኣꬂ እንጎዳይ፥ አስቆሮቶ ይሁዳ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«አብስ Ꮊ ሽታይ ሀይꬒ ጼት ድናረ ባይዝንቲ፥ ሚሻይ ማንቅታይስ እንግንቶሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","(ኤ ካይዞ ማቄዝ ግሾስ የያ ጌዛፕ አትን ማንቅታይስ ቃꬊንቲ ጌካያ። ኤ ሚሸ ቁርቦ አይክዛ ማቄዝ ግሾስ ኡባ ዎደ ኤዛይፕ ፓስ ኤክዛ።) ");
INSERT INTO mfxe_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","የሱሳ፥ «እዛ ፓስ የዛ ባዝ ታ ሞጎ ጋላስስ ምንጄዝ ግሾስ እዞ አሾይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ማንቅታይ ኡባ ዎደ ይንታር የዞዳ፥ ዝን ታኒ ኡባ ዎደ ይንታር የዛሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","የ ዎደ ጋመ አሳይ የሱሳ ብታና የዛና ስኢ ገደ Ꮊንጌዛ። ኡንቲ የሱሳ ኣዳ ባዝን ኤ Ꮊይቆፕ ደንꬄዝ አላዛራካ በአዳይስ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","የይ ግሾስ፥ ቄሰ ሀላቅታይ አላዛራካ ማ ዎꬎዳይስ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","አብስ ጊኮ፥ አላዛራ ባጋር ጋመ አይሁድታይ ኡንታን እጺ የሱሳና አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ዎንትꬃ ጋላስ ፓዝቃ ቦንችዛ አቆ የኤዝ ዎያ የሱሳ የሩሳላመ Ꮊንግዛ ስኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ዛምባ ሀየ ኤኪ ኤዛ ሞኮዳይስ ከዜዝ። ፋ ቃላ ꬎቅ ኡዲ፥ «ሆሳና! ጾሳይ ጋላትንቶ! ጎዳይ ሱንꬃር ይእዛይ አንጅንቶ! ጾሳ እስሬለ ካታይ አንጅንቶ!» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","ጌሻ ማጻፋይድ፥ «ጽዮነ ካታምትስ፥ ያሽትፐ! ዬዛኮ፥ ነ ካታይ ሀረ ናአል አፋ በቲ ይእዛ» ጊንትንቴዛይ ጋርክ የሱሳ ሀረ ናአ ደንጊ ኤዛ ቶጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","የሱሳ ታማርታይ የያ ቲን አካኬካያ። ዝን የሱሳ ቦንችንተዛይፕ ጉየ ኡንቲ የያ ኡባ አካኬዛ። የይ ኡባይ ጌሻ ማጻፋይ ጌዛይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","የሱሳ አላዛራ ዱፎፕ ጼጊ፥ Ꮊይቆፕ ደንꬄዝ ዎደ ኤዛር የዝ ጋመ አሳይ የሱሳ ኦሳ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ጋመ አሳይ ኤዛ ሞኮዳይስ ከዜዛይ፥ ኤ የ ማልታ ኦꬄዛና ስኤዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","የይ ግሾስ፥ ፈርሳወ አሳይ ፐታይ ፔታይኮ፥ «ኑ አብካ ኦꬆዳይስ ዳንዳኦዛ ቦኦይታ፤ ዎያ ኡባይ ኤዛ ካልዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ፓዝቃ ቦንችዛ ጋላስ ጎይኖዳይስ የሩሳላመ Ꮊንጌዝታይ ጋንጨ ፐቲ ፐቲ ግርከ አሳይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ኡንቲ ጋልላ ቢታ ቤተሳይዳ ካታማፕ የኤዝ ፍልጶሳኮ Ꮊንጊ፥ «ጎዳዮ፥ ኑኒ የሱሳ በአዳይስ ኮይዛ» ዬጊ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፍልጶሳ Ꮊንጊ እንድራሰስ ኦድን ናምእታይ Ꮊንጊ፥ የሱሳስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","የሱሳ ኡንትኮ፥ «አስ ናአይ፥ ቦንችንትዛ ዎደ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ታኒ ይንትስ ቱሮ ኦድዛ፤ ፐቲ ግስተ ኣፈ ቢታ ጋንጨ ዎꬊ ዎቀካ አትኮ ፋ ኣዳስ አትዛ። ዝን የ ግስተ ኣፋይ ዎቅኮ ጋመ ኣፈ ኣፍዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ፋ ሸምፖ ቃꬍዛ ኦንካ ꬋብስዛ፤ ፋ ሸምፖ Ꮊ አላማይድ እጽዛ ኦንካ መꬍናስ ደኦስ ናግስዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ታኒ የዛ አቆ ታር የዞድ ጋርክ ታስ ኦꬆዳይስ ኮይዝ ኦንካ ታና ካሎዳይስ ቤዝዛ። ታስ ኦꬅዛ ኦናካ ታ አዳይ ቦንቾዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Ꮊት ታ ሸምፓይ ጋመ ኡንእንቴዛ፤ የዝን ዋጎ? ‹ታ አዳዮ፥ ታና Ꮊ ሳታይፕ አሾዬ› ዬጎ? ዋኣ፥ ታኒ የኤዛይ መቶ ኤኮዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ታ አዳዮ፥ ነ ሱንꬃ ቦንቾባ» ዬጌዛ። የይፕ ጉየ ሳሎፕ፥ «ታኒ ታ ሱንꬃ ቦንቼዛ፤ ጉጅካ ቦንቾዳ» ዬግዝ ቃላ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","የ አቃይድ ኤቄዝ ጋመ አሳይ የ ቃላ ስኢ፥ «የይ ዳዳ» ዬጌዛ። Ꮊንክታይ ማ፥ «ኪታንቻይ ኤስ ኦዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","የሱሳ ማሂ ኡንትኮ፥ «Ꮊ ቃላይ ይ ግሾስ የኤዛይፕ አትን ታ ግሾስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ꮊ አላማይ ፕርድንትዛ ዎዳይ Ꮊተ፤ Ꮊ አላማ አቅስዛና Ꮊት ባለ ኦሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ማ ታኒ ሳአፕ ꬎቅ ጌዝ ዎደ አስ ኡባ ታኮ ኮኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ኤ የያ ጌዛይ አብ ጋርክ Ꮊይቆ Ꮊይቆዳዛኮ ኡንትስ ኤርሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ጋመ አሳይ ማሂ፥ «ኑ ህጋይ ክርስቶሳ መꬍናስ የዛና ኦድዛ። የዝን፥ ኔኒ ዋጊ፥ አስ ናአይ ꬎቅ ጎዳይስ ቤዝዛ ጌ? ኤ፥ አስ ናአይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","የሱሳ፥ «ፖአይ ይንታር ጽቃ ዎደ ጋምኦዳ። ይንትስ ꬉማም ጋርክ ፖኦ የዝን፥ ፖአይር የꬎይታ። ꬉማር የꬍዝ አስ አና Ꮊንግዛኮ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ፖኦ ናእታ ማቃዳይ ጋርክ ፖኦ የዝን ፖአና አማኖይታ» ዬጌዛ። የሱሳ የያ ኦዴዛይፕ ጉየ Ꮊንጊ ኡንታፕ ጌሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ኤ የይ ጋርክ ማልታ ኡ ቲናይድ ኦꬅንካ አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ናበ ኢሳያሳ፥ «ጎዳዮ፥ ኑ ማርከትꬅ ኦኒ አማኔኔ? ጎዳይ ዎልቃይ ኦስ ቤንቴኔ?» ጌዛይ ቱማ ማቃዳይ ጋርክ ኡንቲ ኤዛ አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","ማካ ኢሳያሳ፥ «ኡ ኣፋይ በኣማይ ጋርክ፥ ኡ ዎዝናይ አካካማይ ጋርክ፥ ኡንቲ ጾስኮ ማቅን፥ ኤ ኡንታን ፓꬃማይ ጋርክ፥ ጾሳይ ኡ አፋ ቶእሴዛ። ኡ ዎዛና ሚንꬄዛ» ጌዝ ግሾስ ኡንቲ አማኖዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ኢሳያሳ የያ ጌዛይ፥ የሱሳ ቦንቾ በኤዝ ግሾኔ ኤባዝ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ማቅኮካ፥ አይሁድታይ ሀላቅታይፐካ ጋምታይ የሱሳና አማኔዛ። ዝን ፈርሳወ አስታይ ፋና አይሁድታይ ዎሳ ኬꬃፕ ከስዛ ግ ያሽቴዝ ግሾስ አማኔዝ ግ ጌሻ ማርካተካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","የያ ኡንቲ ኦꬄዛይ፥ ጾሳር ኤርንቶዳይፕ ኣꬂ አሳር ኤርንቶዳና ዶሴዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","የሱሳ ፋ ቃላ ꬎቅ ኡዲ፥ «ታና አማንዛ ኦንካ ታና ኪቴዛናካ አማኔዛይፕ አትን ታና ኣዳ አማኖያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ታና ብእዛ ኦንካ ታና ኪቴዛናካ ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ታና አማንዛ ኡባይ ꬉማ ጋንጨ የዛም ጋርክ ፖኦ ማቂ አላመ ታኒ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ታ ቃላ ስኢ ኪትንቶዋ ኦናካ ታኒ ፕርዳሚ። አብስ ጊኮ፥ ታኒ አላመ አሾዳይስ የኤዛይፕ አትን ፕርዶዳይስ የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ታና እጽዛኔ ታ ቃላ ኤኮዋ ኦናካ ፕርድዛይ የዛ። ታኒ ኦዴዝ ቃላይ ዉርስꬅ ጋላስ የ አꬃ ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","አብስ ጊኮ፥ ታኒ የያ ታፕ ኦደካያ፥ ዝን ታና ኪቴዝ ታ አዳይ ታኒ አብ ጎዳዛኮነ አብ ኦዶዳዛኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ማ ኤ ኪታይ መꬍናስ ደኦ ማቅዛና ታኒ ኤርዛ። የይ ግሾስ፥ ታኒ ኦድዛይ ታ አዳይ ታና ኦዶባ ጌዛና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ፓዝቃ ቦንችዛ ጋላሳይ ሄሎዳይፕ ቲናቲ Ꮊ አላመ አሺ አዳይኮ Ꮊንግዛ ዎደ ሄሌዛና የሱሳ ኤሬዛ። Ꮊ አላማይድ የዝ ፋስታ ኡባ ዎደ ዶሴዛ፤ ፎሎ ሲቆራካ ኡንታን ዶሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","የሱሳራ ኤ ታማርታይር ዎላ ካሆ ማዳር ጻላሄ ስሞና ናአ አስቆሮቶ ይሁዳ የሱሳ ኣꬂ እማዳይ ጋርክ ኤ ዎዝና ጋንጨ ኢታ ቆፋ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","የሱሳስ አዳይ ኡባ ባዝ ኤ ኩሸ ጋዴዛና፥ ኤ ጾሳፕ የኤዛናኔ ማቂ ኤዝኮ Ꮊማዳና ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","የሱሳ ካሆ ም ደንዲ ፋ ጉላንታ ቃሪ ጋዲ፥ ፖጻ ፋ ጼሳ ዳንጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","የይፕ ጉየ፥ ጋባተ ጋንጨ ሃꬅ ቆል፥ ፋ ታማርታይ ቶኬ ሜጬዛ፤ ማ ፋ ጼሳይዳ ዳንጬዝ ፖጻይር ኡጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","የሱሳ ስሞን ጵጽሮሳኮ የኦዳር ጵጽሮሳ፥ «ጎዳዮ፥ ነ ታ ቶካ ሜጮዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","የሱሳ ማሂ ኤዝኮ፥ «ታኒ ኦꬅዛና ነ Ꮊት ኤሮያ፥ ዝን ጉየፕ አካኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","የዝን፥ ጵጽሮሳ፥ «ነ ታ ቶካ ኡባራካ ሜጮዳይስ ዳንዳኦያ» ዬጌዛ። የሱሳ ኤዝኮ፥ «ታኒ ነ ቶኬ ሜጨካ አትኮ ኔስኔ ታስ ፐትፐተꬂ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ጵጽሮሳ የሱሳኮ፥ «ጎዳዮ፥ ዬዛኮ፥ ታ ቶካይ ኣዳ ባዝን ታ ኩሻኔ ታ ኦማ ሜጮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","የሱሳ ማሂ፥ «ጋላ ሜጭንቴዝ ኦንካ ቶከፕ ሀራ ባዝ ሜጭንቶዳይስ ቤዞያ፤ ኤ ኡባይ ጌሺ። ይ ጌሺ፥ ዝን ኡባ አሲ ጌሺ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","የሱሳ ፋና ኣꬂ እማድ አꬃይ ኦናዛኮ ኤርዛ ግሾስ «ይ ኡቢታይ ጌሺ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ኡ ቶኬ ሜጬዛይፕ ጉየ የሱሳ ፋ አፍላ ማሂ ማኤዛ። ማቂ ሙንታል አፋ በቲ ኡንትኮ፥ «ታኒ ይንትስ ኦꬄዛና አካክኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ይ ታና አስታማረኔ ጎዳ ግዛ፤ ታኒ ይ ግዛ ማቄዝ ግሾስ ሎኦ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ታኒ ይንትስ ጎዳነ አስታማረ ማቅታር ይ ቶኬ ሜጭኮ ይንትካ ፐታይ ፐታይስ Ꮊይ ጋርክ ኦꬆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ይኬ፥ ታኒ ይንትስ ኦꬄዛይ ጋርክ ይንትካ ኦꬆድ ጋርክ ይንትስ ኣዝሶ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ታኒ ይንትስ ቱሮ ኦድዛ፤ አይላይ ፋ ጎዳይፕ፥ ኪትንቴዛይ ኪቴዛይፕ ኣꬎያ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ይ የያ ኤሪ ኦꬅዛባዝ ማቅኮ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«ታኒ ይንታን ኡብታ ጎያ፤ ታኒ ማራጼዝታ ታ ኤርዛ። ዝን ጌሻ ማጻፋይድ፥ ‹ታፕ ሜዛይ ታል አፋ ፋ ቶካ ደንꬄዛ› ግንትንትዛይ ቱማ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ታኒ ታና ማቄዛና ይ አማኖድ ጋርክ የይ ሀኖዳይፕ ቲናቲ ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ታኒ ይንትስ ቱሮ ኦድዛ፤ ታኒ ኪቴዝ ኦናካ ሞክዛ አꬃይ ታና ሞክዛ። ታና ሞክዝ ኦንካ ታና አዛዜዛና ሞክዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","የሱሳ የያ ኦዴዛይፕ ጉየ ፋ ዎዝናር ጋመ ኡንእንቲ፥ «ታኒ ይንትስ ቱሮ ኦድዛ፤ ታና ይንትፕ ፐታይ አꬂ እማዳ» ግ ቆንጭሲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ኤ ኦ ባጋ ኦድዛኮ ኤ ታማርታይስ ኤርንታም እጽን ፐታይ ፐታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ኤ ታማርታይፕ ፐታይ፥ የሱስ ዶስዛይ፥ የሱሳ ካለ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","የይ ግሾስ፥ ስሞን ጵጽሮሳ ኤዛ ቃምኦቲ፥ «ኤ ኦና ግዛኮ አን ኦይጮባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","የይ ግሾስ፥ የ ታማራይ የሱሳኮ ሀየ ካለ ሺቂ፥ «ጎዳዮ፥ ኤ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","የሱሳ ማሂ፥ «ታኒ ሶሎ ዱሺ ባርስዛያ» ዬጌዛ። ማ ሶሎ ዱꬂ ኤኪ፥ ዱሺ፥ ስሞና ናአ አስቆሮቶ ይሁዳ ባርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ይሁዳና ሶሎ ባሬዛይፕ ጉየ ጻላሄ ኤልሲ ይሁዳ ጋንጨ ገሌዛ። የሱሳ ኤኮ፥ «ነ ኦꬆዳይስ ቆፔዛኖ ኤልሲ ኦꬆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ዝን ሙንታል አፋ በቴዝታይፕ ኦንካ የሱሳ የያ አብስ ጌዛኮ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ይሁዳ ሚሸ አይክዝ ግሾስ ኤ ታማርታይፕ ፐታይ ፐታይ የሱሳ ኤ፥ «ፓዝቃ ቦንችዛ ጋላስስ ፓስ ኮሽዛ ባዝ ዎንጎባ ዎይ ማንቅታይስ ሙጻታ እንጎባ ጌዛ» ዬጊ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ይሁዳ ሶሎ ባሬዛን ጋርክ እዝራ ባለ ከዜዝ። የ ዎደ ሳአ ቃማ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ይሁዳ ባለ ከዜዛይፕ ጉየ፥ የሱሳ፥ «Ꮊት አስ ናአይ ቦንችንቴዛ፤ ጾሳይካ ኤ ባጋር ቦንችንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ጾሳይ ኤ ባጋር ቦንችንትኮ ኤ ፋ ኦማስ አስ ናአ ቦንቾዳ፤ ማ ኤ የያ ኤልሲ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ታ ናኡንꬆ፥ ታኒ ይንታር ጋመ ዎደ ጋምአሚ። ይ ታና ኮዮዳ፥ ዝን ታኒ አይሁድታይስ ኦዴዛን ጋርክ፥ ‹ይ ታኒ Ꮊንግዛ አቆ Ꮊማዳይስ ዳንዳኦያ› ");
INSERT INTO mfxe_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ታኒ ይንትስ እንግዝ ኦሮꬅ ኪታይ Ꮊያ፤ ፐታይ ፐታ ቃꬎይታ። ታኒ ይንታን ቃꬌዛይ ጋርክ ይ ፐታይ ፐታ ቃꬎዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ይ ፐታይ ፐታይራ ዶስንትኮ ይ ታ ታማረ ማቅዛና አሲ ኡባይ ኤሮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ስሞን ጵጽሮሳ የሱሳኮ፥ «ጎዳዮ፥ ነ አና Ꮊንጌ?» ዬጌዛ። የሱሳ ማሂ፥ «ታኒ Ꮊንግዛ አቆ ኔኒ Ꮊት ካሎዳይስ ዳንዳኦያ፥ ዝን ጉየፕ ታና ካሎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጵጽሮሳ፥ «ጎዳዮ፥ ታኒ ነና Ꮊት ካሎዳይስ አብስ ዳንዳኦሳ? ታኒ ነ ግሾስ Ꮊይቆዳይስ ጊግ በቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","የሱሳ ማሂ፥ «ታ ግሾስ Ꮊይቆዳይስ ቱማ ጊግ በቴኔ? ታኒ ኔስ ቱሮ ኦድዛ፤ ሹጉላ ኡኮዳይፕ ቲና ኔኒ ታና ሀይꬒ ቶክ ካዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","የሱሳ ፋ ታማርታይኮ፥ «ይ ዎዝናይ ኡንእንትፐ፥ ጾሳ አማኖይታ፥ ታናካ አማኖይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ታ አዳይ ካራ ጋመ አቆ የዛ። ታኒ ይንትስ በስ ጊግሶዳይስ Ꮊንግዛ። የያ ማቀካዛኮ ታኒ ይንትስ ኦዶድዝን። ");
INSERT INTO mfxe_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ታኒ Ꮊንጊ በስ ጊግሴዛይፕ ጉየ ታኒ የዛ አቆ ይ የዞድ ጋርክ ማቂ ይኢ ይንታን ታኮ ካንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ይ ታኒ Ꮊንግዛ አቆ ካንግዝ ኦገ ይ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","የዝን፥ ቶማሳ፥ «ጎዳዮ፥ ኔኒ Ꮊንግዛ አቆ ኑኒ ኤሮያ፤ ኦጋ ዋይዚ ኤሮዳይስ ዳንዳኦዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","የሱሳ ማሂ፥ «ኦገ፥ ቱማይኔ ደኦ ታና። ታ ባጋር ማቃም እጽኮ ኦንካ ታ አዳይኮ Ꮊማዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ይ ታና ኤርዛ ባዝ ማቄዛኮ፥ ታ አዳካ ኤሮዳ። ዝን Ꮊይፕ አይኪ ይ ኤዛ ኤርዛኔ ኤዛ በኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፍልጶሳ የሱሳኮ፥ «ጎዳዮ፥ አዳ ኑና ቤዞባ፤ የይ ኑስ ግዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","የሱሳ ማሂ፥ «ታኒ Ꮊይ ጋርክ ዎደ ይንታር የዝንካ ታና ኤሮሳ? ታና በኤዝ አꬃይ አዳካ በኤዛ። የዝን፥ ኔኒ ዋጊ፥ ‹ኣዳ ኑና ቤዞዬ› ጌ? ");
INSERT INTO mfxe_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ታኒ አዳይር የዛኔ አዳይካ ታር የዛና ኔኒ አማኖሳኔ? ታኒ ይንትስ ኦድዝ ቃላ ታኒ ታፕ ኦዶያ፥ ዝን ታር የዛ አዳይ ፋ ኦꬆ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ታኒ አዳይር የዛናኔ አዳይካ ታር የዛና ይ አማኖይታ። የያ አማናምጽኮ ታ ኦꬄዝ ማላ ባዝታይል ታና አማኖይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«ታኒ ይንትስ ቱሮ ኦድዛ፤ ታና አማንዛ አꬃይ ታኒ ኦꬅዛ ኦሶ ኦꬆዳ። ታኒ አዳይኮ Ꮊንግዛ ግሾስ ታና አማንዛ ኦንካ Ꮊይፕ ኣꬊዝ ኦስታ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","አዳይ ናአይ ባጋር ቦንችንቶድ ጋርክ ታ ሱንꬃር ይ ዎስዛ ባዝ ኡባ ታ ይንትስ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ታ ሱንꬃር አባባዝካ ይ ኦይጭኮ ታ ይንትስ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«ይ ታና ቃꬍኮ ታ ኪታ ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ታኒ አዳ ዎሶዳ፤ ይንታር መꬍናስ የዞድ ጋርክ ምንꬃꬅዛ ይንትስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ꮊ አላመ አሳይ ኤዛ በኤካዛይ ግሾኔ ኤሮዋ ግሾስ ኤዛ ኤኮዳይስ ዳንዳኦያ ቱማ አያና። ዝን ኤ ይንታር የዛ ግሾኔ ይ ጋንጨ የዞድ ግሾስ ይ ኤዛ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«ታኒ ይንታን እንዳ አደ ባ ናአ ጋርክ ይ ኣዳ አሻሚ፤ ማቂ ይንትኮ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ጽቃ ዎደፕ ጉየ አላማይ ታና ማሂ በኤና፥ ዝን ይ በአዳ። ታኒ ደኦር የዛ ግሾስ ይንትካ ደኦር የሳዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ታኒ ታ አዳይር፥ ይ ታር፥ ማ ታኒ ይንታር የዛና ይ የ ጋላስ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«ታ ኪታ ኤኪ ናግዛይ ታና ቃꬍዛ። ታና ቃꬍዛና ታ አዳይካ ቃꬍዛ፤ ታንካ ኤዛ ቃꬍዛ፤ ታኒ ኤስ በንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","አስቆሮቶ ይሁዳ ባዝን Ꮊንኮ ይሁዳ የሱሳኮ፥ «ጎዳዮ፥ ኔኒ ዋይዚ አላማይስ ባዝን ኑስ ነና ቤዞዴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","የሱሳ ማሂ፥ «ታና ቃꬍዛ ኦንካ ታ ቃላይስ ኪትንቶዳ። ታ አዳይ ኤዛ ቃꬎዳ። ማ ታ አዳይራ ታራ ኤዝኮ ይኢ ኤዛር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ታና ዶሶዋ ኦንካ ታ ቃላይስ ኪትንቶያ። ይ ስእዝ ቃላይ ታና ኪቴዝ አዳይ ባዛፕ አትን ታባዝ ባያ።» ");
INSERT INTO mfxe_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«ታኒ ይንታር Ꮊት የዛር የያ ይንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ዝን አዳይ ታ ሱንꬃር ኪቶዳ ምንꬃꬅዛ ጌሻ አያናይ፥ ይንታን ኡባ ባዝ ታማርሶዳ። ታኒ ይንትስ ኦዴዝ ኡባ ኤ ይንታን ሀሳይሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ሳሮትꬅ ይንትስ አሾዳ። ታኒ ታ ሳሮትꬃ ይንትስ እማዳ። ታ እንግዝ ሳሮትꬃይ አላማይ እንግዝ ሳሮትꬃይ ጋርክ ባያ። የይ ግሾስ፥ ኡንእንትፓተ፥ ያሽትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","«ታኒ Ꮊማዳ፥ ማቂ ይንትኮ የኦዳ» ጌዛና ይ ስኤዛ። ይ ታና ቱማ ዶስዝባዝ ማቄዛኮ ታ አዳይ ታፕ ኣꬊዝ ግሾስ ታኒ ኤዝኮ Ꮊንግዛይድ ይ ኡፋይቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","የይ ሀኖዳር ይ አማኖድ ጋርክ የይ ሀነካዝን ቲናቲ ታኒ ይንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ꮊ አላማ አቅስዛይ ይእዛ ግሾስ Ꮊይፕ ጉየ ይንታር ጋመ ኦድንታሚ። ታና ኤ አብካ ኦꬆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ዝን ታኒ አዳ ቃꬍዛና አላማይ ኤሮድ ጋርክ ታ አዳይ ታና አዛዜዛና ኡባ ኦꬅዛ። ደንዶይታ፤ Ꮊይፕ ዎላ Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«ታኒ ዎይነስ ቱማ ኡባ። ኦስዛይ ታ አዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ታል አፋ የዚ ኣፈ ኣፎዋ ሻቆ ኡባ ኤ ካርዛ። ኣፍዝ ሻቆ ቲናሳይፕ ኣꬊ ኣፎዳይ ጋርክ የ ሻቃ ኤ ጊግሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ታኒ ይንትስ ኦዴዝ ቃላይ ግሾስ ይ ጌሽታ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ታር የዞይታ፤ ታንካ ይንታር የዞዳ። ዎይኔ ሻቃይ ኡባይር የዘካ አትኮ የ ሻቃይ ፋ ኣዳስ ኣፈ ኣፎዳይስ ዳንዳኦያ። የይ ጋርከካ፥ ይንትካ ታል የዘካ አትኮ ኣፈ ኣፎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«ታኒ ዎይነስ ኡባ፤ ይ ሻቂታ። ታር የዝዛይኔ ታኒ ኤዛር የዝዛይ፥ ኤ ጋመ ኣፈ ኣፎዳ። ታ ባዝን ይ ይ ኡባስ አብካ ኦꬆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ታር የዞዋዛይ ሻቆ ጋርክ ባለ ኦልንቲ መሎዳ። ኡንታን ሺሺ ታማ ኦሎዳ፥ ኤጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ይ ታር የዝኮ፥ ታ ቃላይካ ይንታር የዝኮ፥ ይ ኮይዝ ባዝ አብ ማቅኮካ ዎሶይታ፤ ይ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ይ ጋመ ኣፈ ኣፍኮኔ ታ ታማረ ማቅኮ፥ የይድ ታ አዳይ ቦንችንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","አዳይ ታና ቃꬍዛይ ጋርክ ታንካ ይንታን ቃꬍዛ፤ ታ ሲቃይር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ታኒ ታ አዳይ ኪታ ናጊ ኤ ሲቃይድ የዜዛይ ጋርክ ይንትካ ታ ኪታ ናግኮ ታ ሲቃይድ የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«ታ ኡፋይሳይ ይንታር ማቃዳይ ጋርከኔ ይ ኡፋይሳይ ፎሎ ማቃድ ጋርክ ታኒ ይንትስ የያ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ታ ኪታይ Ꮊያ፤ ታኒ ይንታን ቃꬌዛይ ጋርክ ይንትካ ዎል ዎል ቃꬎይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ፋ ሸምፖ ፋ ላጋይስ ኣꬂ እንግዛይፕ ኣꬊዝ ዳማ ሲቆ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ታኒ ይንታን ኪቴዝ ኡብታ ይ ኦꬅኮ ይ ታ ዳብታ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","«አይለ ፋ ጎዳይ ኦꬅዛባዝ ኤሮዋ ግሾስ ታኒ ይንታን Ꮊይፕ ጉየ አይልታ ጋሚ። ዝን ታ አዳይፕ ስኤዝ ኡብታ ታኒ ይንትስ ኦዴዝ ግሾስ ይንታን ዶስንቴዝታ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ታኒ ይንታን ዶሬዛይፕ አትን ይ ታና ዶረካያ። ይ Ꮊንጊ ꬋቦዋ ኣፈ ኣፎድ ጋርክ ታኒ ይንታን ሹሜዛ። ዬዛኮ ታ አዳይ ይ ታ ሱንꬃር ዎሴዝባዝ ኡባ ይንትስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ታ ኪታይ Ꮊያ፦ ዎል ዎል ቃꬎይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«አላማይ ይንታን እጽኮ ቲናቲ ታና እጼዛ ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ይ አላመ ባዝ ማቄዛኮ አላማይ ፋባዝ ጋርክ ይንታን ቃꬎዳ። ዝን ታኒ ይንታን አላመፕ ሻጊ ዶሬዝ ግሾኔ ይ አላመ ባዝ ባ ግሾስ አላማይ ይንታን እጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹አይለ ፋ ጎዳይፕ ኣꬎያ› ግ ታኒ ይንትስ ኦዴዛና ቆፖይታ። ኡንቲ ታና ባይኤዝ ባዝ ማቅኮ ይንታናካ ባይኦዳ። ኡንቲ ታ ቃላ ናጌዝባዝ ማቅኮ ይ ቃላካ ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ዝን ኡንቲ ታና አዛዜዛና ኤሮዋ ግሾስ Ꮊ ኡባ ታ ባጋር ይንታል አፋ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ታኒ ይኢ ኦደካባዝ ማቄዛኮ ኡንትስ ናጋራ ማቀና። ዝን Ꮊት ኡንቲ ኦꬄዝ ናጋራይስ ኦዶድ ሳላምበ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ታና እጽዛይ ታ አዳካ እጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ኦንካ ኦꬄካ ኦሶ ታ ኡ ጋንጨ ኦꬅበኤካባዝ ማቄዛኮ ኡንትስ ናጋራ ማቃም ዝን Ꮊት ኡንቲ ታኒ ኦꬄዛ ብኢ ታናካ ታ አዳካ እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ዝን ኡ ህጋይድ፥ ‹ታና ጨር እጼዛ› ግንትንቲ ጻፍንቴዛይ ፖልንቶድ ጋርክ የይ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«አዳይፕ ይእዝ ቱማ ቤዝዛ አያና ታ ይንትስ ኪቶዳ። ኤ ይንታን ምንꬃꬆዳ፥ ታባዝ ማርኮቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ይንትካ ቲናፕ አይኪ ታር የዛ ግሾስ ታባዝ ማርኮቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«ታኒ የያ ይ አማናይ ꬋባም ጋርክ ይንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ኡ ይንታን አይሁድታይ ዎሳ ኬꬅታይፕ ከሲ ዳኮዳ። የይ ጋርከካ፥ ይንታን ዎꬍዛ ኦንካ ጾሲ ኮይዝ ባዝ ኦꬅዛ አዝዛ ዎደ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ኡንቲ የያ ይንታል አፋ ኦꬅዛይ ታና ዎይ አዳ ኤሮዋ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ዝን ኡንቲ የያ ይንታል አፋ ኦꬅዛ ዎደ ሄሎዳር ታኒ ይንትስ ኦዴዛና ይ አካኮድ ጋርክ ታኒ ይንትስ Ꮊያ ኦዴዛ። ቲናቲ ታኒ Ꮊያ ይንትስ ኦደካ ጋምኤዛይ ታ ይንታር የዛ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«ዝን Ꮊት ታኒ ታና ኪቴዛይኮ Ꮊንግዛ፤ ይንታፕ ኦንካ፥ ‹አና Ꮊንጌ?› ግ ታና ኦይጭዛይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ዝን ታኒ የያ ኦዴዝ ግሾስ ይ ዎዝናይ አዛኖር ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ዝን ታኒ ይንትስ ቱሮ ኦድዛ፤ ታኒ Ꮊንግኮ ይንትስ ሎኦ። አብስ ጊኮ፥ ታኒ Ꮊንጋም እጽኮ ምንꬃꬅዛይ ይንትኮ የኤና። ዝን ታኒ Ꮊንጊ ኤዛ ይንትኮ ዳኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ምንꬃꬅዛይ ይኢ፥ ናጋራባጋ፥ ጽሎትꬅ ባጋኔ ፕርዳ ባጋ Ꮊ አላመ አሳ ኤርሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ናጋራባጋይ፥ አሳይ ታና አማኖዋ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ጽሎትꬅባጋይ፥ ታኒ አዳይኮ Ꮊንግዛ ግሾኔ ይ ታና ማቂ ቦኦዋ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ፕርዳባጋይ፥ ማ አላመ አቅስዛይ ፕርድንቴዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«ታኒ ይንትስ ኦድዛ ጋመ ባዝ የዛ፥ ዝን Ꮊት ይንትስ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ቱማ አያና ይኢ ይንታን ቱማትꬂ ኡባይኮ ካልꬆዳ። ኤ ስኤዝ ባዝ ኦድዛፕ አትን ፓፕ አባባዝካ ኦዶያ። ማ ቲናፕ የኦድባዝ ይንትስ ኤ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ኤ ታስ የዛይፕ ኤኪ ይንትስ ኦድዛ ግሾስ ኤ ታና ቦንቾዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","አዳይስ የዛ ባዝ ኡቢታይ ታባዝ፤ ‹አያናይ ታስ የዛይፕ ኤኪ ይንትስ ኦዶዳ› ታኒ ጌዛይ የይ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«ጽቃ ዎደፕ ጉየ ይ ታና በኣሚ፤ ማካ ጽቃ ዎደፕ ጉየ ይ ታና በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ኤ ታማርታይፕ ፐታይ ፐታይ ዎል ጋንጨ፥ «ጽቃ ዎደፕ ጉየ ይ ታና በኣሚ፤ ማ ጽቃ ዎደፕ ጉየ ይ ታና በአዳ፤ ማካ ታኒ አዳይኮ Ꮊንግዛ ጉሳይ ዋጉሶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«ጽቃ ዎደፕ ጉየ ዋጉሶ? ኤ አብ ኦድንትዛኮ ኑስ ኤርንቶያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ኡንቲ ፋና ኦይጮዳይስ ኮይዛና የሱሳ ኤሪ፥ «ታኒ፥ ‹ጽቃ ዎደፕ ጉየ ይ ታና በኣሚ፤ ማ ጽቃ ዎደፕ ጉየ ይ ታና በአዳ› ዬጌዝ ግሾ ይ ዎል ዎል ኦይጭኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ታኒ ይንትስ ቱሮ ኦድዛ፤ ይ ዬኮዳኔ አፉጾዳ፥ ዝን Ꮊ አላማይ ኡፋይቶዳ። Ꮊት ይ አዛኖዳ፥ ዝን ይ አዛናይ ኡፋይሳ ላምንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ዎደꬅ አስታ ናአ የሎድ ሀኖዳር ፋ የሎ ዎዳይ ሄሌዝ ግሾስ ህርግዛ። ዝን ናአ የሌዛይፕ ጉየ ናአ Ꮊ አላማይል የልንቴዛይ ኡፋይስዛ ግሾስ ፋ መታ እዛ ዶግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","የይ ጋርክ፥ ይንትካ ይ ዎዝናር አዛንዛ፥ ዝን ታኒ ይንታን ማቂ በአዳ። ይ ዎዝናይ ሎእꬂ ኡፋይቶዳ፤ የ ኡፋይሳ ኦንካ ይንታፕ ኤከና። ");
INSERT INTO mfxe_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«የ ጋላስ ይ ታና አባባዝካ ዎሴና። ታኒ ይንትስ ቱሮ ኦድዛ፤ ይ ታ ሱንꬃር ዎስዛ ባዝ ኡባ አዳይ ይንትስ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ꮊኖ ሄሎዳይስ ታ ሱንꬃር አባባዝካ ይ ዎሰካያ። ይ ኡፋይሳይ ፎሎ ማቃድ ጋርክ ጾሳ ዎሶይታ፤ ይ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ታኒ Ꮊኖ ሄሎዳይስ ይንትስ ኣዝሶር ኦዴዛ፥ Ꮊይፕ ታኒ ኣዝሶር ኦዶዋ ዎደ የኦዳ። ዝን አዳይባጋ ታኒ ይንትስ ቆንጭሲ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","የ ጋላስ ይ ታ ሱንꬃር አዳ ዎሶዳ፤ ይ ግሾስ ታኒ አዳ ዎሳሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","አብስ ጊኮ፥ አዳይ ፋ ኡባስ ይንታን ቃꬍዛ። ይ ታና ቃꬍዛ ግሾኔ ታኒ አዳ ላንቀፕ የኤዛና ይ አማኔዝ ግሾስ ኤ ይንታን ቃꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ታኒ አዳይ ላንቀፕ Ꮊ አላመ የኤዛ፤ ማ አላመ አሺ አዳይኮ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ኤ ታማርታይ ማቂ፥ «ዬዛኮ፥ Ꮊት ኔኒ ቆንጨ ኦድዛ፤ ኣዝሶር አብካ ኦዶያ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ኔኒ ኡባ ባዝ ኤርዛና ኑኒ Ꮊት ኤርዛ፤ ማ ነና ኦንካ ኦይጮድ ጋርክ ኔኒ ኮዮያ። የይ ኑና ኔኒ ጾሳፕ ኪትንቴዝ አስ ማቄዛይ አማንꬅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","የዝን፥ የሱሳ ማሂ ኡንትኮ፥ «Ꮊት አማንኔ? ");
INSERT INTO mfxe_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ዬዛኮ፥ ይ፥ ይ ካራ ላልንትዝ ዎዳይኔ ታ ኡባስ ኦሊ አሺ ቆስንትዛ ዎዳይ የኦዳ፤ Ꮊተካ ይኢ ሄሌዛ። ዝን አዳይ ታር የዛ ግሾስ ታ ታ ኣዳ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ይ ታር የዝኮ ሳሮ ይንትስ የዞዳይ ጋርክ ታኒ የያ ኦዴዛ። አላመል የዝታር ይ መትንቶዳ። ዝን ሚንጎይታ፤ ታኒ አላማ ጋሜዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","የሱሳ የያ ኦዴዛይፕ ጉየ ፑደ ሳሎ ብኢ፥ Ꮊይ ጋርክ ዬጌዛ፦ «አዳዮ፥ ሳታይ ሄሌዛ፤ ነ ናአይ ነና ቦንቾድ ጋርክ ኔኒ ነ ናአ ቦንቾባ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ኔኒ ኤዝስ እንጌዝ ኡባይስ ኤ መꬍናስ ደኦ እማዳይ ጋርክ አስ ኡባይል አፋ ኤዝስ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","መꬍና ደኦካ ነና፥ ፐቲ ቱማ ጾሳኔ ነ ኪቴዝ የሱስ ክርስቶሳ ኤሮ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ነ ታ ኦꬆድ ጋርክ እንጌዝ ኦሳ ፖሊ ነና ሳአል ቦንቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ꮊተካ፥ አዳዮ፥ አላመ መꬊንቶዳይፕ ቲና ነ ካለ ታስ የዝ ቦንቻይር ታና ቦንቾባ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«አላመ አሳይፕ ኔኒ ታስ እንጌዝታ ነና ኤርሴዛ። ኡንቲ ኔስታ፤ ኔኒ ኡንታን ታስ እንጌዛ። ኡንቲ ነ ቃላይስካ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ኔኒ ታስ እንጌዝ ኡባ ባዝ ኔፕ የኤዛና ኡንቲ Ꮊት ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ኔኒ ታስ እንጌዝ ቃላ ታኒ ኡንትስ እንጌዛ፤ ኡንትካ የ ቃላ ኤኬዛ። ታኒ ነ ላንቀፕ የኤዛይ ቱማ ማቅዛና ኤሪ ኔኒ ታና ኪቴዛናካ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«ታኒ ኡንትስ ዎስዛ። ኡ ኔስታ ማቄዝ ግሾስ ኔኒ ታስ እንጌዝ አሳይስ ዎስዛይፕ አትን አላማይስ ዎሳሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ታስ የዛ ኡባባዛይ ነባዝ፤ ኔስ የዝ ኡቢታይካ ታባዝ። ታኒ ኡ ባጋር ቦንችንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ታኒ Ꮊይፕ ጉየ አላመል የዛሚ፤ ኡንቲ አላመል የዛ። ታኒ Ꮊት ኔኮ Ꮊንግዛ። ጌሻ አዳዮ፥ Ꮊ ኔኒ ታስ እንጌዝታይ ኔራኔ ታራ ፐቶ ማቄዛይ ጋርክ ኡንቲ ፐቶ ማቃድ ጋርክ ኡንታን ነ ታስ እንጌዝ ነ ሱንꬃይር ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ታኒ ኡንታር ሳአል የዛር፥ ነ ታስ እንጌዝ ነ ሱንꬃይ ዎልቃር ኡንታን ናጌዛ። ጌሻ ማጻፋይ ጌዛይ ፖልንቶድ ጋርክ ꬋቦዳይስ ቤዝዛ አꬃይፕ አትን ኡንታፕ ሀራ ኦንካ ꬋበካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Ꮊት ታ ኔኮ Ꮊንግዛ። ታ ኡፋይሳይ ኡ ዎዝና ጋንጨ ፎሎ ማቃድ ጋርክ Ꮊያ ታኒ አላመል የዛር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ታኒ ኡንትስ ነ ቃላ እንጌዛ። ታኒ አላመፕ ማቀካዛይ ጋርክ፥ ኡንትካ አላመፕ ማቀካ ግሾስ አላመ ኡንታን እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ኔኒ ኢታፕ ኡንታን ናጎድ ጋርከፕ አትን አላመፕ ከሶዳይ ጋርክ ዎሳሚ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ታኒ አላመፕ ማቀካዛይ ጋርክ ኡንትካ አላመፕ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ኔኒ ነ ቱማትꬃር ኡንታን ነባዝ ኦꬆባ፤ ነ ቃላይካ ቱማ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ኔኒ ታና አላመ ኪቴዛይ ጋርክ ታንካ ኡንታን አላመ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ማ ኡንቲ ቱማ ጌሽ ማቃድ ጋርክ ታኒ ታ ኡባ ኡ ግሾስ ታና ታ ጌሽ ኡድዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«ታኒ ኡ ኣዳስ ባዝን ኡንቲ ቃላ ኦድን፥ ታና አማኖድ አስታይስካ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ኡንቲ ኡቢታይ ፐቶ ማቃድ ጋርክ ታኒ ዎስዛ። አዳዮ፥ ነ ታር የዛይ ጋርክ፥ ማ ታ ኔር የዛይ ጋርክ ኡንቲ ኑር የዞድ ጋርክ ዎስዛ። የ ዎደ ኔኒ ታና አዛዜዛና አላማይ አማኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ኔኔ ታኔ ፐቶ ማቄዛይ ጋርክ፥ ኡንቲ ፐቶ ማቃድ ጋርክ፥ ኔኒ ታና ቦንቼዛይ ጋርክ፥ ታንካ ኡንታን ቦንቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ታኒ ኡ ጋንጨ፥ ኔኒ ታር የዛይ ጋርክ ኡንቲ ፎሎ ፐቶ ማቃድ ጋርክ ነና ዎስዛ። የይካ፥ ነ ታና ኪቴዛናኔ ነ ታና ቃꬌዝ ቃꬋይር ኡንታን ቃꬌዛና አላመ ኤሮድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«አዳዮ፥ ኔኒ ታስ እንጌዝታይ ታኒ የዛ አቆ ታር የዞዳይ ጋርክ ኮይዛ። አላማይ መꬊንቶዳይፕ ቲና ኔኒ ታና ቃꬌዝ ግሾስ ታስ እንጌዝ ታ ቦንቻ ኡንቲ በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«ጌሻ አዳዮ፥ አላመ ነና ኤሮያ፥ ዝን ታን ነና ኤርዛ። ማ ኔኒ ታና አዛዜዛና Ꮊይትታይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ኔኒ ታና ሲቄዝ ሲቃይ ኡንታር የዞድ ጋርክ፥ ማ ታኒ ኡንታር ማቃድ ጋርክ፥ ታኒ ነ ሱንꬃ ኡንታን ኤርሴዛ፤ ቲናስካ ኤርሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","የሱሳ ዎሳ ዉርሰዛይፕ ጉየ ፋ ታማርታይር ቀድሮና ሎጳ ፒንጊ፥ የ በሳይድ የዝ ዎይራ ጋደ ጋንጨ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","የሱሳ ጋመ ዎደ ፋ ታማርታይር ኤዛይድ ሺቅዛ ግሾስ የሱሳ ኣꬂ እንጌዝ ይሁዳ የ አቃት ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","የይ ግሾስ፥ ይሁዳ ፓኖሰ፥ ዣበ፥ ቶራራኔ ጎንዳለራ አይኬዝ ጋመ ዎታዳርታ፥ ቄሰ ሀላቅታይኔ ፈርሳወ አሳይ ኪቴዝ ጾሳ ኬꬅ ናግዝ ፖልስታ ካልꬂ ኤኪ፥ የ አቆ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","የሱሳ ፋና ሄሎድ ሀንዛ ባዝ ኡባ ኤሪ፥ ጋጻ ከዚ፥ «ኦና ኮዬ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ኡንቲ ማሂ፥ «ናዝረተ የሱሳ ኮይዛ» ዬጌዛ። ኤ ማሂ፥ «ታና» ዬጌዛ። የሱሳ ኣꬂ እንጌዝ ይሁዳ ኤዛይድ ኡንታር ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ኤ፥ «ታና» ጌዝ ዎደ ኡንቲ ጉየ ሺቂ፥ ፎኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","የሱሳ ማካ፥ «ኦና ኮይኔ?» ዬጊ ኦይጬዛ። ኡንቲ፥ «ናዝረተ የሱሳ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ኤ ማሂ፥ «ታና ማቄዛና ታ ይንትስ ኦዴዛ። ይኬ፥ ይ ታና ኮይዝ ባዝ ማቅኮ Ꮊይትታ ዳኮይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ኤ የያ ጌዛይ፥ «አዳዮ፥ ኔኒ ታስ እንገዝታይፕ ሀራ አቶዝን ፐታካ ꬋብሰካ» ጌዝ ቃላይ ፖልንቶድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ስሞን ጵጽሮሳ ማሻ አይኬዛ ግሾስ ፋ ማሻ ሾዲ ቄሰ ሀላቃ አይላይስ ኡሻች ሀይቶ፥ ቃꬊ ኦሌዛ። የ አይላይ ሱንꬃይ ማልኮሳ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","የሱሳ ጵጽሮሳኮ፥ «ነ ማሻ ሾካይድ ማሆባ። ታ አዳይ ታስ እንጌዝ ጹአይፕ ታ ኡዣማ ኔስ አዝኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","አይሁደ ዎታዳርታይር ኡ ሀላቃይ ጾሳ ኬꬅ ናግዝ ፖልስታይራ ዎላ የሱሳ አይኪ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ቲና የሱሳና ሃናኮ ካንጌዛ። ሃና የ ላይꬅ ቄሰ ሀላቃ ማቅዝ ቃያፋ ቦለ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቃያፋ፥ «ዎያ ግሾስ ፐቲ አሲ Ꮊይቅኮ ሎኦ» ግ ቲና አይሁድታና ዞሬዛያ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ስሞን ጵጽሮሳኔ ሀራ ፐቲ ታማራይ የሱሳ ካሊ ቅቴዛ። ቄሰ ሀላቃይ የ Ꮊንኮ ታማራ ሎእꬂ ኤርዛ። የይ ግሾስ፥ ኤ የሱሳር ቄሰ ሀላቃይ ዛባ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ዝን ጵጽሮሳ ባለር ጋሰ ፐንገል ኤቄዛ። ቄሰ ሀላቃይ ኤርዛ ሀራ ታማራይ ባለ ከዚ፥ ፐንገ ናግዛ አስትስ ኦድን፥ ጵጽሮሳ ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ፐንገ ናግዝ አስታ ጵጽሮሳኮ፥ «ኔኒ፥ የ አꬃይ ታማርታይፕ ፐታ ባሳ?» ዬጌዛ። ጵጽሮሳ ማሂ፥ «ዋኣ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ሳአይ ሜግዛ ግሾስ አይልታይራኔ ናግዝታይ ጺፈ ታማ ኤꬂ፥ ማሪ ኤቂ ካዥዛ። ጵጽሮሳካ ኡንታር ኤቂ ታማ ካዥዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ቄሰ ሀላቃይ የሱሳ፥ ኤ ታማርታይባጋኔ ኤ ትምርታይባጋ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","የሱሳ ማሂ፥ «ታኒ አስ ኡባስ ጌሻ ኦዴዛ። ታኒ አይሁደ ኡቢታይ ሺቅዛ አይሁድታይ ዎሳ ኬꬃ ግዶኔ ጾሳ ኬꬃ ኡባ ዎደ ታማርሴዛ። ጌማ አብካ ኦደካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","የዝን፥ ኔኒ ታና አብስ ኦይጨ? ታ ኦዶዳር ስኤዝ አሳ ኦይጮባ። የ አሳይ ታኒ ኦዴዛና ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","የሱሳ የያ ጌዝ ዎደ የ በሳይድ ኤቄዝ ዎታዳርታይፕ ፐታይ የሱሳ ባቂ፥ «ቄሰ ሀላቃይስ Ꮊይ ጋርክ ዬጊ ማህኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","የሱሳ ማሂ፥ «ታኒ ኢታ ባዝ ኦድንቴዝ ማቅኮ ማርካ ኮኦባ። ዝን ታኒ ቱሮ ኦድንቴዝ ማቅኮ ታና አብስ ባቄ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","የይ ግሾስ፥ ሃና፥ የሱሳ አጭንቴዛን ጋርክ ቄሰ ሀላቃ ቃያፋኮ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ጵጽሮሳ ኤዛይድ ኤቂ፥ ታማ ካዦዳር፥ አቴዝ አሳይ ኤዝኮ፥ «ኔኒ Ꮊ አꬃይ ታማርታይፕ ፐታ ባሳ?» ዬጌዛ። ጵጽሮሳ ማሂ፥ «ዋኣ፥ ታኒ ኤ ታማረ ባያ» ዬጊ ካዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ቄሰ ሀላቃይ አይልታይፐ ፐታይ፥ ጵጽሮሳ ሀያ ጋቼዝ አꬃይ ዳባይ፥ ጵጽሮሳኮ፥ «ታኒ ነና ኤዛር አታክልታይ ጋንጨ በኤካሳኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጵጽሮሳ ማካ ካዴዛ። ኤ የያ ጌዛን ጋርክ ሹጉላ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ዎንታ ጉራ፥ ኡንቲ የሱሳና ቃያፋ ካራፕ ጋደ አቅስዛይ ኦሶ ኬꬃ ካንጌዛ። አይሁድታይ ፓዝቃ ባለ ካꬃ ማዳይስ ፋና ቱንሳማይ ጋርክ ጋደ አቅስዛይ ኦሶ ኬꬃ ገለካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","የይ ግሾስ፥ ጵላጾሳ ኡንትኮ ባለ ከዚ፥ «Ꮊ አꬃ አብስ ሞቴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ኡንቲ፥ «ኤ ኢታ ኦꬄካባዝ ማቄዛኮ ኑኒ ኤዛ ኔኮ ከኣሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጵላጾሳ ማሂ፥ «ይ ኤዛ ኤኪ ካንጊ፥ ይ ህጋይ ግዛይ ጋርክ ኤዛል አፋ ፕርዶይታ» ዬጌዛ። አይሁድታይ፥ «ኦናካ ዎꬍዛ ማዉተ ኑስ ባያ» ዬጌዛ፤ ");
INSERT INTO mfxe_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","የይ ሀኔዛይ የሱሳ አብ ጋርክ Ꮊይቆ Ꮊይቆዳዛኮ ኤርሶዳይስ ኦዴዝ ቃላይ ፖልንቶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጵላጾሳ ፋ ኦሶ ኬꬃ ማቂ ገሊ፥ የሱሳ ጼጊ፥ «ኔኒ አይሁደ ካቶ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","የሱሳ ጵላጾሳኮ፥ «Ꮊ ኦይቻ ኔኒ ኔፕ ኦይጭነኔ ዎይ ሀራ አሲ ኔስ ታባዝ ኦዴኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጵላጾሳ ማሂ፥ «ታ አይሁደ አሶ? ነ አሳይራ ቄሰ ሀላቅታይ ነና ታስ ኣꬂ እንጌዛ። ነ አብ ኦꬄኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","የሱሳ፥ «ታ ካተትꬃይ Ꮊ አላማይድ ባያ። ኤ Ꮊይዳ ማቄዛኮ ታ አይሁድታይ ሀላቅታይስ ኣꬊ እንግንቶድ ጋርክ ታ አይልታይ ታስ ኦልንቶዳ። ዝን ታ ካተትꬃይ Ꮊ አላማይድ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","የይ ግሾስ፥ ጵላጾሳ የሱሳኮ፥ «የዝን፥ ኔኒ ካቶኔ?» ዬጊ ኦይጬዛ። የሱሳ ማሂ፥ «ቱማ ታ ካተ ማቅዛና ነ ጌዛ። ታኒ የልንቴዛይኔ Ꮊ አላመ የኤዛይ ቱማትꬅስ ማርካቶዳይስ። ቱማ ባጋ ማቄዝ ኦንካ ታኒ ግዛ ስእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጵላጾሳ፥ «ቱማ አባ ባዞ?» ዬጌዛ። ጵላጾሳ የያ ጌዛይፕ ጉየ አይሁድታይኮ ባለ ከዚ፥ «ታኒ ኤፕ አባ ኢታካ ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ዝን ፓዝቃ ባለ ጋላስ፥ ፐቲ አሲ ይንትስ አቻፕ ብልእዝ ዎጋ የዛ። ታኒ ይንትስ አይሁድታይ ካታ ብሎድ ጋርክ ኮይኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ኡንቲ ማሂ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ባርባና ብሎባፕ አትን ኤዛ ባያ» ዬጌዛ። ዝን ባርባና ፓኖ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","የይፕ ጉየ፥ ጵላጾሳ የሱሳና ጋራፍሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ዎታዳርታይ አንጉንꬅ ዛዉደ መꬊ ኤ ኦማይል ጋዴዛ። ማ ዞቆ አፍላ ኤዛ ማእሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ኤዝኮ ሺቂ፥ «አይሁደ ካታዮ፥ መꬍናስ ካዉቶባ» ዬጊ ኤዛ ባቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ጵላጾሳ ማካ ባለ ከዚ፥ አይሁድታይኮ፥ «ዬዛኮ፥ ታኒ ኤፕ አባ ኢታካ ደንገካዛ ይ ኤሮድ ጋርክ ኤዛ ይንትኮ ባለ ከሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","የይፕ ጉየ፥ የሱሳ አንጉንꬅ ዛዉደ ፋ ኦማል ጋዲ፥ ዞቆ አፍላ ማኢ፥ ባለ ከዜዝ። ጵላጾሳ አይሁድታይኮ፥ «አꬃ Ꮊያ ቦኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ቄሰ ሀላቅታይኔ ጾሳ ኬꬅ ናግዝታይ ኤዛ በኤዝ ዎደ ፋ ቃላ ꬎቅ ኡዲ፥ «ማዝቃለል አፋ ሶቶባ! ሶቶባ!» ዬጌዛ። ጵላጾሳ ኡንትኮ፥ «ይ ኤዛ ካንጊ፥ ማዝቃለል አፋ ሶቶይታ። ታኒ ኤፕ አባ ኢታካ ደንገካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","አይሁድታይ ማሂ፥ «ኑስ ህጋይ የዛ። ኤ ፋና ጾስ ናአ ኦꬄዝ ግሾስ ኑ ህጋይ ጋርክ ኤ Ꮊይቆዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ጵላጾሳ የያ ስኤዝ ዎደ ቲናሳይፕ ኢታ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ማካ ጵላጾሳ ፋ ኦሶ ኬꬅ ማቂ ገሊ የሱሳኮ፥ «ኔኒ አናፕ የኤኔ?» ዬጊ ኦይጬዛ። ዝን የሱሳ ኤዝስ አብካ ማሄካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","የይ ግሾስ፥ ጵላጾሳ፥ «ታስ ኦዶሳ? ነና ብሎዳይስ ዎይ ማዝቃለል አፋ ሶቶዳይስ ታስ ማዉተ የዛና ኤሮሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","የሱሳ፥ «ጾሳይ ኔስ ስልጻኔ እንገካባዝ ማቄዛኮ ታል አፋ ስልጻኔ ኔስ ባቦናዝን። የይ ግሾስ፥ ታና ኔስ ኣꬂ እንጌዛይ ኣꬊዝ ናጋራ ኦꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ጵላጾሳ የያ ስኤዝ ዎደ የሱሳ ብሎዳይስ ኦገ ኮዬዛ። ዝን አይሁድታይ ፋ ቃላ ꬎቅ ኡዲ፥ «ኔኒ ኤዛ ብልዝባዝ ማቅኮ ካታይ ቄሳረ ባጋ ባያ። ፋና ካተ ግዝ ኦንካ ቄሳረስ ሞርከ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጵላጾሳ የያ ስኢ የሱሳ ባለ ከሲ «ሎቼ ሹች» ዬግዝ ቤስ ፕርደ ኦይደል በቴዛ። እብራይስጸ ቃላይር የ አቃይ «ገበታ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","የ ጋላሳይ ፓዝቃ ባለ ቦንቾዳይስ ጊግንቶ ጋላስ። የ ዎደ ሳአ ኡሱፑን ሳተ ሄራ። ጵላጾሳ አይሁድታይኮ፥ «ይ ካታ Ꮊያ ቦኦይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","አይሁድታይ ፋ ቃላ ꬎቅ ኡዲ፥ «ꬋብሶባ! ꬋብሶባ! ማዝቃለል አፋ ሶቶባ» ዬጌዛ። ጵላጾሳ ማሂ፥ «ይ ካታ ታኒ ማዝቃለል አፋ ሶቶዳይስ ኮይኔ?» ዬጊ ኦይጬዛ። ቄሰ ሀላቅታይ፥ «ቄሳረፕ ሀራ ካት ኑስ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","የይፕ ጉየ፥ ኡንቲ የሱሳ ማዝቃለል አፋ ሶቶድ ጋርክ ጵላጾሳ ኡንትስ ኣꬂ እንጌዛ። ኡንቲ የሱሳ አይኪ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","የሱሳ ፋ ማዝቃላ ቶኪ፥ «ኦማ ኦታ» ግዝ አቆ Ꮊንጌዛ። «ኦማ ኦታ» ጉሳይ እብራይስጸ ቃላይር «ጎልጎታ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ኡንቲ የ አቃይድ ማዝቃለል አፋ የሱሳ ሶቴዛ። ማ ኤዛር ሀራ ናምኢ አስታ፥ ፐታ ገደ ባጋር Ꮊንካ Ꮊና ባጋር ማዝቃለል አፋ ሶቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጵላጾሳ፥ «አይሁድታይ ካት፥ ናዝረተ የሱሳ» ዬግዝ ጹፈ ጻፊ ማዝቃለል አፋ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","የሱሳ ማዝቃለል አፋ ሶትንቴዝ አቃይ ካታማስ ካለ የዝ ግሾስ ጋመ አይሁድታይ የ ጹፋ ናባቤዛ። ጹፋይ ጻፍንቴዛይ እብራይስጸ ዶናር፥ ላትኔ ዶናራኔ ግርከ ዶናራ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","የይ ግሾስ፥ ቄሰ ሀላቅታይ ጵላጾሳኮ፥ «‹Ꮊ አꬃይ ፋና አይሁደ ካት ዬጌዛ› ግ ጻፎባፕ አትን ‹አይሁደ ካት› ግ ጻፍፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","የዝን፥ ጵላጾሳ፥ «ታ ጻፌዛና ጻፌዛ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ዎታዳርታይ ማዝቃለል አፋ ኤዛ ሶቴዛይፕ ጉየ ኤ አፍላ ኤኪ፥ ኦይዲ አቆ ዎላ ቆእንቲ፥ ፐቶ ፐቶ ኤኬዛ። ኤ አፋር ኦሊ ማእዛ አዱሰ አፍላ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ዎታዳርታይ፥ «ኦና ሄሎዳዛኮ፥ እጻ ኦሎዳይፕ አትን አፍላ ፐርአሚ» ዬጌዛ። የይ ሀኔዛይ ጌሻ ማጻፋይድ፥ «ታ አፍላ ሻኪ ኤኬዛ፤ ታ አዱሰ አፍላ ጉጅካ እጻ ኦሌዛ» ግንትንትዛይ ፖልንቶድ ጋርከ። የይ ግሾስ፥ ዎታዳርታይ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ዝን የሱሳ ማዝቃለ ካለ ኤ እንዳት፥ ኤ እንዳት ምሽት፥ ቀልዮጰ ማቻት ማይራምራ ማግዴላ ማይራማ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","የሱሳ ፋ እንዳትኔ ኤ ቃꬍዛ ታማራይ ኤዛይድ ኤቄዝታ ብኢ፥ ፋ እንዳትኮ፥ «ታ እንዳቴ፥ ነ ናአ Ꮊያ ቦኦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","የይፕ ጉየ፥ የ ታማራይኮ፥ «ነ እንዳት Ꮊኖ ቦኦባ» ዬጌዛ። የ ታማራይ እዞ የ ዎደፕ አይኪ ፋ ካራ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","የይፕ ጉየ፥ የሱሳ ኡባይ Ꮊት ፖልንቴዛና ኤሪ፥ ጌሻ ማጻፋይድ ጻፍንቴዛይ ፖልንቶድ ጋርክ «ታና ሳምዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","የ አቃይድ ፐቲ ጹጋ ኩንꬅ ጫላ ዎይነ የዛ። ኡንቲ ዛንዛ የ ዎይናይድ ኦሊ፥ ህሶጰ ምꬂ ጼራል ጋዲ፥ የሱሳ ዶናይኮ ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","የሱሳ ዎይና ጋንጺ ብኢ፥ «ፖልንቴዛ» ዬጌዛ። የይፕ ጉየ፥ ፋ ሞርጋ ዝቅ ኡዲ ፋ ሸምፓ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","የ ጋላስ ጊግንቶ ጋላስ ማቅዝ ግሾኔ ዎንትꬃ ጋላሳይ ቦንቾ ማላ ማቅዝ ግሾስ አሳይ አሃይ ማዝቃለል አፋ ማላ ጋላስ ፔዣም ጋርክ ኡንታን ቶካ መንꬂ፥ ማዝቃላይፕ ዎꬍሶዳይ ጋርክ አይሁድታይ ጵላጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","የይ ግሾስ፥ ዎታዳርታይ Ꮊንጊ፥ የሱሳር ሶትንቴዝ ናምኢ አሳይ ቶካ መንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ዝን የሱሳኮ የኤዝ ዎደ ኤ Ꮊይቄዛ ብኢ፥ ኤ ቶካ መንꬄካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ዝን ዎታዳርታይፕ ፐታይ ኤ ምያ ቶራር ጫድን ኤለ ሱꬅኔ ሃꬂ ጎጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ይ አማኖድ ጋርክ የያ በኤዛይ ማርካቴዛ። ኤ ማርካትꬃይካ ቱማ። ማ የይፕ ኤ ኦሳ ኦድዛይ ቱማ ማቄዛ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","የይ ሀኔዛይ ጌሻ ማጻፋይ፥ «ኤ መቀꬅታይፕ ፐቲ ባዝካ መቀና» ጌዛይ ፖልንቶድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ማካ ጌሻ ማጻፋይ ሀራ አቆ፥ «ኡንትካ ፋ ጫዴዛና በአዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","የይፕ ጉየ፥ አርማታሳ ግዝ ካታማፕ የኤዝ ዮሴፋ የሱሳ አሃ ኤኮዳይስ ጵላጾሳ ዎሴዛ። ዮሴፋ አይሁድታይስ ያሽቴዝ ግሾስ ቆሶር የሱሳ ካልዛ። ጵላጾሳ፥ «ኤኮባ» ዬጌዛ። የይ ግሾስ፥ ዮሴፋ ሺቂ የሱሳ አሃ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ማ የይፕ ንቆድሞሳ፥ Ꮊይፕ ቲን የሱሳኮ ቃማ የኤዛይ፥ ካርበኔ ጎዳረ ኡꬃራ ዋላክንቴዝ ፐቲ ክሎ ግራመ ማቅዝ ሽቶ ኤኪ ዮሴፋር ዎላ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","የ ናምኢ አስታይ የሱስ አሃ ኤኪ፥ አይሁድታይ አሃ ዚꬍꬅ ዎጋር፥ ሽቶራ፥ ሞጎ አፍላር ሳዋጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","የሱሳ ሶትንቴዝ አቃይ አታክልተ ጋደ። የ አታክልተ ጋንጨ ሹቻፕ ዎጭንት ጊጌዝ ቲና ኦንካ ሞግንተካ ኦሮꬅ ዱፋይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","የ ዱፋይ ላንቀ የዝ ግሾኔ አይሁድታይ ማላስ ጊግንትዛ ጋላስ ማቄዝ ግሾስ የሱሳ አሃ ሞጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ያ ሳምንታትስ ቲና ጋላስ ሳአ ጌዠካዝን፥ ማግዴላ ማይራማ፥ የሱሳ ሞግንቴዝ ዱፋይኮ Ꮊንጊ ሹቻይ የ ዱፋይ ዶናይፕ ሀልኤዛና በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","እዛ ስሞን ጵጽሮሳኮኔ የሱሳ ቃꬍዛ Ꮊንኮ ታማራይኮ ዎጺ Ꮊንጊ፥ «ዱፋይፕ ጎዳ ኤኪ ꬋብሴዛ፤ ኤዛ አባ ጋዴዛኮ ኑ ኤሮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","የይ ግሾስ፥ ጵጽሮሳኔ Ꮊንኮ ታማራይ ከዚ ዱፎ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ናምእታይካ ዎላ ዎጼዛ፤ ዝን Ꮊንኮ ታማራይ ጵጽሮሳፕ ኣꬊ ቲናቲ ዱፎ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","የ ታማራይ ዙጊ፥ ሞጎ አፍላ በኤዛ፥ ዝን ዱፎ ጋንጨ ዎካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ስሞን ጵጽሮሳ ኤዛ ካሊ ይኢ፥ ዱፎ ዎꬊ ሞጎ አፍላይ ኤዛይድ የዛና በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ማ የሱሳ ኦማስ ጻጽንቴዝ አፍላይ ዳክንꬅንቲ ዱማ ፐቲ አቆ የዛና በኤዛ። የ አፍላይ ዱማ የዛይፕ አትን ሞጎ አፍላይር ዎላ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","የ ዎደ ቲናቲ ዱፎ ሄሌዝ Ꮊንኮ ታማራይ ገሊ ብኢ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","የሱሳ Ꮊይቆፕ ደንዶ ቤዝዛና ኦድዛ ጌሻ ማጻፈ ቃላ ኡንቲ ሀጋ አካከካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","የይፕ ጉየ፥ ኤ ታማርታይ ፋ ካራ ማቂ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ዝን ማይራማ የ ዱፋይ ዶናይድ ኤቂ ዬክታር ዙጊ ዱፋይ ጋንጨ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ቦꬅ አፍላ ማኤዝ ናምኢ ኪታንችታይ የሱሳ አሃይ ዎይኤዝ አቃይድ ፐታይ ኦማ አቻራ Ꮊንካይ ቶኬ አቻራ በቴዝታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ኡንቲ ኢኮ፥ «Ꮊን አስተ፥ አብስ ዬኬ?» ዬጊ ኦይጬዛ። እዛ፥ «ኡንቲ ታ ጎዳ ኤኪ ꬋቤዛ፤ ኡንቲ አባ ጋዴዛኮ ታኒ ኤሮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","የያ ጌዛይፕ ጉየ፥ እዛካ ጉየ ማቂ በአዳር የሱሳ ኤዛይድ ኤቄዛና በኤዛ። ዝን ኤ የሱሳ ማቄዛና ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","የሱሳ እዝኮ፥ «Ꮊን አስተ፥ አብስ ዬኬ? ኦና ኮዬ?» ዬጊ ኦይጬዛ። ማይራማ አታክልተ ናግዛ አሲ ኣዝን፥ «ጎዳዮ፥ ነ ኤኬዝባዝ ማቅኮ፥ ኤዛ አባ ጋዴዛኮ ታስ ኦዶየ። ታኒ ኤዛ ኤኮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","የሱሳ እዝኮ፥ «ማይራመ» ዬጌዛ። እዛ ኤዝኮ ማሂ፥ እብራይስጸ ዶናር «ረቡኒ» ዬጌዛ። የይስ ብርሽꬃይ «አስታማራዮ» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","የሱሳ እዝኮ፥ «ታኒ ሀጋ ታ አዳይኮ Ꮊንገካ ግሾስ ታና አይኪ አሾዳይስ ኮይፐ። ዝን ታ እሽታይኮ Ꮊንጊ፥ ‹ታኒ ታ አዳይኮኔ ይ አዳይኮ፥ ታ ጾሳይኮኔ ይ ጾሳይኮ፥ Ꮊማዳ ጌዛ› ግ ኡንትስ ኦዶባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ማግዴላ ማይራማ ጎዳ በኤዛናኔ እዝስ የያ ኤ ኦዴዛና Ꮊንጊ ኤ ታማርታይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ሳምንታይፕ ቲና ጋላስ ኦማርሰ፥ ኤ ታማርታይ አይሁድታይስ ያሽቲ እብꬅ ጎርዲ ሺቂ በቴዝን፥ የሱሳ ይኢ፥ ኡ ጋንጨ ኤቂ፥ «ሳሮ ይንትስ ማቆ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","የያ ግ ማቂ ፋ ኩሻኔ ፋ ምያ ኡንታን ቤዜዛ። ኤ ታማርታይ ጎዳ ብኢ ጋመ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","የሱሳ ማሂ ኡንትኮ፥ «ሳሮ ይንትስ ማቆ፤ ታ አዳይ ታና ኪቴዛይ ጋርክ ታንካ ይንታን ኪትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","የያ ጌዛይፕ ጉየ፥ ኡንታል አፋ ኡፍ ግ ፑጌዛ። ማ፥ «ጌሻ አያና ኤኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ይንቲ አቶ ጌዝ አሳይ ናጋራይ አቶ ግንትንቶዳ። ይ አቶ ጌካዝታይስ ናጋራይ አቶ ጊንትንታሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ዝን ታጶ ናምኢ ታማርታይፕ ፐታይ፥ ድድሞሳ ግንትንትዝ ቶማሳ፥ የሱሳ የኤዝ ዎደ ኡንታር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","የይ ግሾስ፥ Ꮊንኮ ኤ ታማርታይ ቶማሳኮ፥ «ኑኒ ጎዳ በኤዛ» ዬጌዛ። ዝን ቶማሳ ኡንትኮ፥ «ምስማረር ኤ ጫድንቴዝ ኤ ኩሻይድ የዝ ቤታ በኤካዛር የ ቤታ ታ ብራር ቦቼካዛር፥ ማ ታ ኩሻ ኤ ምያይድ ዳኪ በኤካዛር አማናሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ሳምንታፕ ጉየ፥ የሱሳ ታማርታይ ማካ ካራ ሺቂ በቴዛ፤ ቶማሳካ ኡንታር የዛ። እብꬂ ጎርድንቲ የዝን የሱሳ ይኢ፥ ኡ ጋንጨ ኤቂ፥ «ሳሮ ይንትስ ማቆ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","የይፕ ጉየ፥ የሱሳ ቶማሳኮ፥ «ታ ኩሻ ነ ብራር ቦቺ ቦኦባ። ማ ነ ኩሻ ታ ምያይድ ዳኪ ቦኦባ፤ ስꬊፐ፥ አማኖባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማሳ ማሂ፥ «ታ ጎዳዮ፥ ታ ጾሳዮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","የዝን የሱሳ፥ «ኔኒ ታና በኤዝ ግሾስ አማኔዛ፥ ዝን ታና በኤካዛር አማኔዝታይ አንጅንቴዝታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","የሱሳ Ꮊ ማጻፋይ ጋንጨ ጻፍንቴዝ ባዝ ሀራ ጋመ ማልታ ፋ ታማርታይ ቲና ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ዝን የሱሳ ኤ ክርስቶሳ፥ ጾሳ ናአ ማቅዛና ይ አማኖድ ጋርክ አማኒ ኤ ሱንꬃይር ደኦ ደማዳይ ጋርክ Ꮊይ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","የይፕ ጉየ፥ የሱሳ ጽባሮሳ አባ ካለ ፋ ታማርታይስ ማቂ በንቴዛ። ኤ ኡንትስ Ꮊይፕ ካሊ የዝ ሀኖር በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ስሞን ጵጽሮሳ፥ ድድሞሳ ግንትንትዝ ቶማሳ፥ ቃና ጋልላፕ የኤዝ ናትናኤላ፥ ዛብዶሳ ናእታይኔ የሱሳ ታማርታይፕ ሀራ ናምእታይ ዎላ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ስሞን ጵጽሮሳ ኡንትኮ፥ «ታኒ ሞሎ አይኮዳይስ Ꮊንግዛ» ዬጌዛ። ኡንቲ፥ «ኑካ ኔር Ꮊማዳ» ዬጊ፥ ዎጎሎ ጋንጨ ገሌዛ። ዝን ኡንቲ የ ቃማ አባ ሞሎካ አይከካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ዎንታ ጉራ ጻልቀ ዶሎዳይፕ ቲና፥ የሱሳ አባ ጋጻ ኤቄዛ፥ ዝን ኤ ታማርታይ የሱሳ ማቄዛና ኤርበኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","የሱሳ ኡንትኮ፥ «ታ ላጊታዮ፥ ሞሎ አይከካሳ?» ዬጌዛ። ኡንቲ ማሂ፥ «አኮካ አይከካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ኤ ማሂ፥ «ይ ግታ ዎጎላይፕ ኡሻች ባጋር ኦሎይታ፤ ይ ሞሎ አይኮዳ» ዬጌዛ። የይ ግሾስ፥ ኡንቲ ፋ ግታና ኡሻች ባጋር ኦሌዛ። ጋመ ሞሎ አይከዝ ግሾስ ጎቺ ከሶዳይስ ጋምንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","የሱሳ ቃꬍዛ ታማራይ ጵጽሮሳኮ፥ «Ꮊይ ጎዳ ባይ!» ዬጌዛ። ስሞን ጵጽሮሳ ኤ ጌዛና ስኢ ካሎ የዝ ግሾስ ፋ አፍላ ማኢ አባ ግዶ ጉፒ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ዝን ዎጎሎ ግዶ አቴዝ Ꮊንኮ ታማርታይ ሞሎ ኩሜዝ ግታ ጎቺ፥ አባፕ ጋጻ ከዜዝ። ኡ አባፕ ናምኢ ጼት Ꮊꬋ ጋርክ ሃክዛ ዝን። ");
INSERT INTO mfxe_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ኡንቲ አባፕ ጋጻ ከዜዝ ዎደ ጺፈ ቃቃር ሞሎ የዛኔ ሶሎ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","የሱሳ ኡንትኮ፥ «Ꮊት ይ አይኬዝ ሞላይፕ ጽቃ Ꮊና እንጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ስሞን ጵጽሮሳ ዎጎልተ ገሊ፥ ጼት እሻታማኔ ሀይꬒ ዳሞ ሞልታይ ኩሜዝ ግታ ጎቺ አባፕ ጋጻ ከሰዛ። ሞላይ የይ ጋርክ ጋመ ማቅኮኔ ግታይ ፌꬍንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","የሱሳ ኡንትኮ፥ «Ꮊና ይኢ ሞይታ» ዬጌዛ። ኤ ጎዳ ማቄዛና ኡንቲ ኤሬዝ ግሾስ ኤ ታማርታይፕ ፐታይካ፥ «ኔኒ ኦኖ?» ግ ኤዛ ኦይጮዳይስ ይባቴዛይ ባያ። ኤ ጎዳ ማቄዛና ኡቢታይ ኤሬዛ ");
INSERT INTO mfxe_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","የሱሳ ይኢ፥ ሶሎ ኤኪ ኡንትስ እንጌዛ፤ ሞላካ የይ ጋርክ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","የሱሳ Ꮊይቆፕ ደንዲ ፋ ታማርታይስ በንቶዳር Ꮊይ ሃይꬓንꬆ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ኡ ሜዛይፕ ጉየ፥ የሱሳ ስሞን ጵጽሮሳኮ፥ «ዮና ናአ ስሞና፥ ታና Ꮊይትታይፕ ኣꬂ ቃꬊኔ?» ዬጌዛ። ስሞን ጵጽሮሳ፥ «ኤ ጎዳዮ፥ ታኒ ነና ቃꬍዛና ነ ኤርዛ» ዬጌዛ። የሱሳ ኤዝኮ፥ «ታ ዱር ናኡንꬃን ሄንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","የሱሳ ናምአንꬆ፥ «ዮና ናአ ስሞና፥ ታና ቃꬍኔ?» ዬጌዛ። ስሞን ጵጽሮሳ፥ «ኤ ጎዳዮ፥ ታኒ ነና ቃꬍዛና ነ ኤርዛ» ዬጌዛ። የሱሳ፥ «ታ ሆግታ ሄንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","የሱሳ ሃይꬓንꬆ፥ «ዮና ናአዮ ስሞና፥ ታና ቃꬍኔ?» ዬጌዛ። የሱሳ ሃይꬓንꬆ ስሞን ጵጽሮሳኮ፥ «ታና ቃꬍኔ?» ዬጊ ኦይጬዝ ግሾስ ጵጽሮሳ አዛኒ፥ «ጎዳዮ፥ ኔኒ ኡባ ባዝ ኤርዛ፤ ታኒ ነና ቃꬍዛና ነ ኤርዛ» ዬጌዛ። የሱሳ፥ «ታ ዱርታ ሄንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ታኒ ኔስ ቱሮ ኦድዛ፤ ኔኒ ናአትꬃር የዝ ዎደ ነ ኣዳስ ዳንጭንቲ፥ ነ ኮዤዝ በስ Ꮊንግዛ። ዝን ነ ጭሜዝ ዎደ ነ ኩሻ ምጪ ቤዞዳ። ሀራይ ዳንጭሶዳ፤ ነ አቆ በስ ካንጎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","የሱሳ የያ ጵጽሮሳ አብ ጋርክ Ꮊይቆ Ꮊይቂ፥ ጾሳ ቦንችሶዳዝኮ ኤርሶዳይስ ጌዛ። የያ ጌዛይፕ ጉየ፥ የሱሳ ጵጽሮሳኮ፥ «ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጵጽሮሳ ጉየ ማቂ፥ የሱሳ ቃꬍዛ ታማራይ ፋፕ ጉየር ይእዛና በኤዛ። የ ታማራይ፥ ካሆ ሚዝ አቆ የሱሳኮ ሺቂ፥ «ጎዳዮ፥ ነና ኣꬂ እማዳይ ኦኖ?» ጌዛና። ");
INSERT INTO mfxe_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጵጽሮሳ የ ታማራ ብኢ፥ «ጎዳዮ፥ Ꮊ አꬃይ ማ ዋያዴ?» ዬጊ የሱሳ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","የሱሳ ኤዝኮ፥ «ታኒ የኦዳ ሄሎዳይስ ኤ ሸምፖር የዞድ ጋርክ ታኒ ኮይኮ፥ የይ ነና አብ መተኔ? ኔኒ ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","የይ ግሾስ፥ የ ታማራይ Ꮊይቃም ግዝ ኦዳይ ኤ እሽታ ኡብታ ሄሌዛ። ዝን የሱሳ፥ «ታኒ የኦድ ጋꬆ፥ ኤ የዞድ ጋርክ ታኒ ኮይኮ ነና አብ መተኔ?» የጌዛይፕ አትን «Ꮊይቀና» ጌካያ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ꮊ ኦዳይ ባጋ ማርካተዛይነ Ꮊያ ጻፌዛይ የ ታማራ። ኤ ማርካትꬃይ ቱማ ማቅዛና ኑኒ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","የሱሳ ኦꬄዝ ሀራ ጋመ ባዝ የዛ። ታ ቆፕን፥ ኡባ ባዝ ኦማር ኦማር ጻፍንቴዛኮ፥ ጻፍንትዛ ማጻፍታይስ ኩንꬅ አላማይ ግዶድባዝ ኣዞያ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","ቶፍሎሳ፥ የሱሳ ፋ ኦሳ አይኬዝ ዎደፕ ሳሎ Ꮊንጌዝ ጋላስ ሄሎዳይስ፥ ኦꬄዝባዝኔ ታማርሴዝባዝ ኡባ ታኒ ታ ቲና ማጻፋይድ ጻፌዛ። ሳሎ Ꮊንጎዳይፕ ቲና ኤ ፋ ዶሬዝ ሀዋርታ ጌሻ አያናር አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ኤ ፋ ኢታ ዋያ ኤኬዛይፕ ጉየ Ꮊይቆፕ ደንዴዛና ጋመ ማርካትꬃር ስ ባይꬅ ቆንጭሲ ኡንትስ ፋና ቤዜዛ። ኦይታም ጋላስ ኡንትስ ቆንጪ ጾስ ካተትꬅባጋ ኡንታን ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ፐቲ ዎደ ኡንታራ ዎላ የዛር ኡንታን Ꮊይ ጋርክ ዬጊ ኪቴዛ፦ «ታ ይንትስ ኦዴዛ፥ ታ አዳይ እማድ ጌዝ ኡፋይስ ቃላ ናጎይታፕ አትን የሩሳላመፕ ኬዝፓተ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","አብስ ጊኮ፥ ዋንሳ ሃꬃር ጻማቄዛ፥ ዝን ጽቃ ዎደፕ ጉየ ጌሻ አያናር ይ ጻማቅንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ሀዋርታይ የሱሳና ሄሊ ኤኮ፥ «ጎዳዮ፥ እስራኤልታይስ ነ ካተትꬃ ማህዝ ዎዳይ Ꮊያኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","የሱሳ ኡንትኮ፥ «ታ አዳይ ፋ ማዉተር ኦꬅዛ ዎዳኔ ላይꬃ ይ ኤሮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ዝን ጌሻ አያናይ ይንታል አፋ ዎꬍዝ ዎደ ይ ዎልቃ ኤኮዳ። የይፕ፥ ጉየ የሩሳላመ፥ ይሁዳ ጋደ ኡባይል፥ ሳማረራኔ ቢታ ጋጻፕ ጋጻ ሄሎዳይስ ይ ታስ ማርክታ ማቆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","የያ ጌዛይፕ ጉየ ኡንቲ በአዳር፥ ꬎቅ ꬎቅ ግ፥ ሳሎ ኬዝን ሻራካ ኤዛ ኡ ኣፋይፕ ጌንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","የሱሳ Ꮊማዳር ኡንቲ ሳሎ ፉደ በአዳር፥ ቦꬅ ማኦ ማኤዝ ናምኢ አስታይ ቆፐካዝን ኡ አቻ ኤቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«ጋልላ አሳዮ፥ ሳሎ ብእታር፥ ይ አብስ ኤቄኔ? Ꮊ ይ በአዳር ሳሎ ቅቴዝ የሱሳ Ꮊኒ ጋርክ ማቂ የኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","የይፕ ጉየ፥ ሀዋርታይ ዳብረ ዛይተ አምባላፕ የሩሳላመ ማቄዛ። ዳብረ ዛይተ አምባይ የሩሳላመፕ ማላ ጋላሳ የꬍꬅ ጋርክ ሃክዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ኡንቲ የሩሳላመ ገሊ፥ ፎቄል አፋ ከዜዛ። ኡንትካ ፦ ጵጽሮሳ፥ ዋንሳ፥ ያይቆባ፥ እንድራሰ፥ ፍልጶሳ፥ ቶማሳ፥ ባርቶሎሞሳ፥ ማቶሳ፥ ኢልፎሳ ናአ ያይቆባ፥ ቃናትዛ ስሞናኔ ያይቆባ ናአ ይሁዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ꮊይትታይ ኡባይ ማችታይር፥ የሱሳ እንዳት ማራምራኔ የሱሳ እሽታይራ ኡባይ ፐቲ ዎዝናር ማቂ ኡባ ዎደ ሚንጊ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","የ ዎደ ጵጽሮሳ ጼታኔ ላታም ማቅዝ አማንዛ አሳይ ሺቄዝ አቆ ደንዲ ኤቂ፥ Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«ታ እሹንꬆ፥ የሱሳና አይኬዝታ ካልꬄዝ ይሁዳ ባጋ ጌሻ አያናይ ቲና ዳዉተ ዶናር ኦዴዝ ጾስ ቃላይ ፖልንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ይሁዳ ኑር ዎላ Ꮊ ኦሳ ኦꬆዳይስ ማራጽንቴዝ አሲ።» ");
INSERT INTO mfxe_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ዝን ይሁዳ ኢታ ኦሶር ደንጌዝ ሚሻይር ጋደ ዎንጌዛ። ኤ ስኖር ፖክን፥ ኤ ኡላይ ፔꬊንትን፤ ኤ ማራጫይ ዛዝንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ይሁዳል አፋ ሀኔዝባዛ የሩሳላመ የዝ አስ ኡባይ ስኤዛ። የይ ግሾስ፥ የ ጋዳ ፋ ጋደ ዶናር «አካልዳማ» ጌዛ። አኬልዳማ ጉሳይ ሱꬅ ቢታ ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«የይካ ማዝሙረ ማጻፋይድ፥ «‹ኤ ካራይ ካሎ አቶ፤ ኦንካ ኤዛይድ የዝፔ። ማ ኤ ሹማትꬃ ሀራይ ኤኮ› ግንትንቲ ጻፍንቴዛ።» ");
INSERT INTO mfxe_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«የይ ግሾስ፥ ጎዳ የሱሳ ኑ ጋንጨ ዩዜዝ ዎደ ኡባይድ ኑር የዝታይፐ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ማ ጻማቅዛ ዋንሳ ዎዳይፕ አይኪ ጎዳ የሱሳ ሳሎ Ꮊንጌዝ ጋላስ ሄሎዳይስ ኑር የዝታይፕ ፐቲ አሲ ኤ ደንዳይስ ኑር ማርካ ማቆዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","የይ ግሾስ፥ አሳይ ዶሮዳይስ ዮስጾሳ ግዝ ባርሳባሳ ግንትንትዛ ዮሴፋኔ ማታሳ ናምእታ ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","የይፕ ጉየ፥ ጾስ ዎስታር፥ «አስ ኡባ ዎዝና ኤርዛ ጎዳዮ፥ Ꮊ ናምእታይፕ ነ ኦና ዶሬዛኮ ኑና ቤዞባ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ይሁዳ ፋ አቃ ቅቲ፥ አሼዝ ኦሳኔ ሀዋረትꬅ ኦሳ ኤኮዳይ ጋርክ Ꮊይትታይፕ ኑና ቤዞባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ኡንታል አፋ እጻ ኦልን ኢጻይ ማታሳል አፋ ዎꬍን ማታሳ ታጶ ፐቲ ሀዋርታይል አፋ ጉዥንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ጰንጸቆስጸ ግዝ ጋላሳይ ሄሌዝ ዎደ አማንዛ አስ ኡባይ ፐቲ አቆ ሺቂ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ቆፐካዝን ዎልቃማ ጎተ ጋርክ ጉምዝ ጉምꬃይ ሳሎፕ ይኢ ኡንቲ የዝ ኬꬃ ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ታማ ላꬅ ኣዝዝ እራንꬅታይ ኡንትስ በንትታር፥ ሻግንቲ ሻግንቲ ኡንታል ኡባይል አፋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ኡንቲ ኡባይ ጌሻ አያናር ኩሚ ዱማ ዱማ ዶናር ኦድንቶዳይ ጋርክ ጌሻ አያናይ ኡንታን ኡድን ኦድንቶ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","የ ዎደ ቢታ ኡባፕ የኤዝ ጾስስ Ꮊሽትዝ አይሁድታይ የሩሳላመ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","የ ጉምꬃ ስኢ ጋመ አሳይ ሺቄዛ። አማንዛ አሳይ ኡ ጋደ ዶናር ኦድንቶዳር ስኤዝ ግሾስ ");
INSERT INTO mfxe_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ꮊይ ማላባዝ ግ፥ «Ꮊ ኦድንትዛ አስ ኡባይ ጋልላ አስ ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","የዝን፥ ኑኒ፥ ኑ የልንቴዝ ቢታ ዶናር ኡንቲ ኦድንቶዳር ዋይዚ ስኦዳይስ ዳንዳኤኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ኑኒ ጳርጸ፥ ሜደ፥ ኤላመ፥ መሶጶታመ የዝታይ፥ ይሁዳ፥ ቃጳዶቃ፥ ጳንጾሳ፥ ኢስያ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ጵርገ፥ ጵንፍለ፥ ግብጸ፥ ቃርና አቻ የዝ ሊባ የዝታ። ኑፕ ባግትይካ ኦሮመፕ የኤዝ አስታ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","አይሁድታይኔ አይሁደትꬃ አማኖ ገሌዝ አስታይ፥ ቃርጼሳኔ አራበ አስታይ፥ ጾሲ ኦꬄዝ ግታ ኦሳ ኑ ቃላይር ኦዶዳር ስእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ኡባይ ማላባዝ ግ፥ ጎድባዝ ꬋብን ዎልኮ፥ «Ꮊይ አብ ማቆደሻ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ዝን Ꮊንክታይ፥ «የይትታይ ኡዢ ማꬄምባይ» ዬጊ ኡንታል አርኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ዝን ጵጽሮሳ፥ ታጶ ፐቲ ሀዋርታይራ ደንዲ ኤቂ፥ ፋ ቃላ ꬎቅ ኡዲ፥ ኡንትኮ Ꮊይ ጋርክ ዬጊ ኦዴዛ፦ «አይሁድታዮ፥ የሩሳላመ የዝ ኡቢታዮ፥ ታኒ ኦድዛ ስኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ዎንታፕ ሀይꬒ ሳተ ማቄዝ ግሾስ ይ ቆፕዛይ ጋርክ Ꮊ አስታይ ማꬄካያ፤ የይ ይንትስ ኤርንቶ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ዝን Ꮊይ ሀኔዛይ ናበ ኢዩኤላ ኦዴዛይ ፖልንቶዳይ ጋርከስ ");
INSERT INTO mfxe_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«‹ጾሲ፥ ዎደ ዉርስꬃ Ꮊይ ጋርክ ሀኖዳ ዬግዛ፦ ታኒ አስ ኡባይል አፋ ታ አያና ጎግሶዳ። ይ ꬊራꬅ ናእታይኔ ማች ናእታይ፥ ትንቢተ ኦዶዳ። ይ ፓንꬅታይ ቆንጭꬅ በአዳ፤ ይ ጭምታይ አሁሞ አሁሞዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","የ ጋላሳታይድ ታና አማንዛ ꬊራꬅ አይልታይል አፋኔ ማች አይልታይል አፋ ታኒ ታ አያና ጎግሶዳ፤ ኡንቲ ትንቢተ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ማ ታኒ አፋ ሳሎር ኦሮꬅ ባዝ፥ ኦሞ ሳአራካ ማላ ቤዞዳ። ሱꬂ፥ ታማኔ ዎልቃማ ጩያ ፉሎ በንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ግታኔ ቦንቾ ማቄዝ ጎዳይ ጋላሳይ ሄሎዳይፕ ቲና አዋ ꬉሞዳ፤ አጌናካ ሱꬂ ኣዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","የ ዎደ Ꮊይ ጋርክ ሀኖዳ፤ ጎዳይ ሱንꬅ ጼግዝ ኦንካ አቶዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«እስሬለ አሳዮ፥ Ꮊ ቃላ ስኦይታ። ናዝረተ የሱሳ ኦናትꬃይ፥ ጾሲ ይ ጋንጨ ኦꬄዝ ዎልቃማ ኦሳይራኔ ማላትታይር ይንትስ ቆንጭዛ ይ፥ ይ ኡባስ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ጾስ ቲና ፋ ኤራራኔ ፋ ሸናይር የሱሳ ይንትስ አꬊ እንግንቴዛ። ይ ኤዛ ህገ ባ አስታይ ኩሸር ማዝቃለል አፋ ሶትስ ይ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ዝን ጾስ Ꮊይቆ ዎልቃ ꬋብሲ ኤዛ ደንꬄዛ። የይ ግሾስ፥ Ꮊይቆ ኤዛ አይኮዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳዉተ ኤ ባጋ ኦድታር፥ «‹ታኒ ዳጋማማይ ጋርክ፥ ጎዳይ ታ ኡሻቻ የዛ። ጎዳ ኡባ ዎደ ታ ታ ቲና ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","የይ ግሾስ፥ ታ ዎዝናይ ኡፋይቴዛ፤ ታ ዶናይ ኡፋይሳር ኩሜዛ፤ Ꮊይቅዝ ታ አሰትꬃይ ኡፋይሳር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","አብስ ጊኮ፥ ታ ሸምፓ ስኦለ አሻሚ። ማ ነ ጽላይ አሃ ዎቅꬃም። ");
INSERT INTO mfxe_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ኔኒ ታና ደኦ ኦጋ ኤርሴዛ። ነ ታር የዛይ ግሾስ ታ ኡፋይሳይ ኩንꬅ ማቅዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«ታ እሹንꬆ፥ ኑ አዳ ዳዉተ ባጋ ታ ይንትስ ጌሺ ኦዶዳ። ዳዉተ Ꮊይቂ ሞግንቴዛ፤ ኤ ዱፋይ Ꮊይኖ ሄሎዳይስ ኑ ካለ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ዳዉተ ናበ ማቄዝ ግሾስ ጾስ ኤ ሼሻይፕ ፐታ ኤ ካተትꬃ ዙፋናይል አፋ በትꬆዳይስ ኤስ ጫቄዝ ጫቃ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","የይ ግሾስ፥ ክርስቶሳ ደንዳ ቲና ብኢ፥ ‹ኤ ሸምፓይ ስኦለ አተካያ፤ ኤ አሰትꬃይካ ዎቀካያ› ግ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«ጾሲ፥ Ꮊ የሱሳ Ꮊይቆፕ ደንꬄዛይስ ኑኒ ኡባይ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","የይ ግሾስ፥ ጾሲ ፋ ኡሻቻ ኤዛ ꬎቅ ꬎቅ ኡዲ፥ ኤስ እንጎድ ግንትንቴዝ ጌሻ አያናይ ኡፋይሳ ፋ ጾስ አዳይፕ ኤኪ፥ Ꮊያ ይ Ꮊት ብእዛኔ ስእዛ ኑል አፋ ጎግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","የይካ፥ ዳዉተ ፋ ኦማስ ሳሎ Ꮊንገካያ ዝን፦ «‹ጎዳይ፥ ታ ጎዳ፥ «ታኒ ነ ሞርክታ ነ ቶከስ የꬍꬅ አቆ ኡዶድ ሄሎዳይስ Ꮊይዳ ታፕ ኡሻች ባጋ በቶባ ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«የይ ግሾስ፥ Ꮊ ይ ማዝቃለል አፋ ሶቴዝ የሱሳ፥ ጾሲ ኤዛ ጎዳኔ ክርስቶሳ ማሄዛና እስሬለ አስ ኡባይ ቱማፕ ኤሮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","አሳይ ጵጽሮሳ ጌዛ ስእን ኡ ዎዝናይ ቦችንትን ጵጽሮሳኔ Ꮊንኮ ሀዋርታይኮ፥ «ኑ ኢሹንꬆ፥ የዝን ኑኒ አብ ኡዶ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጵጽሮሳ ኡንትኮ፥ «ይ ናጋራይ አቶ ግንትንቶዳይ ጋርክ ናጋራይፕ ማቂ፥ ይ ፐታይ ፐታይ የሱስ ክርስቶሳ ሱንꬃር ጻማቅንቶይታ። ጾስ እንግዛ ጌሻ አያና ይ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","የይካ ጾሲ እንጎድ ጌዝ ኡፋይስ ቃላይ ይንትሲ፥ ይ ናእታይስኔ ጎዳይ ኑ ጾሳይ ፋክ ጼግዝ ሃኮ የዝ ኡቢታይስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ጵጽሮሳ ኡንትስ ሀራ ቃላካ ጉጂ ማርካቲ፥ «Ꮊ ዎደ ዡጫ አሳይል አፋ የኦዳይስ የዝ ፕርዳይፕ ይንታን አሾይታ» ዬጊ ዞሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ጵጽሮሳ ኦዴዛና ኤኬዝታይ ጻማቅንቴዛ። የ ጋላስ ሀይꬒ ሙኩለ ማቅዝ አሳይ አማኒ ጉጅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ኡንቲ ሀዋርታይ ትምርታይድ፥ ፐትፐተꬃር፥ ካꬃ ዎላ ሙሳራኔ ጾስ ዎሳር ሚንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ሀዋርታይ ኩሸ ጋመ ኦሮꬅባዝኔ ማላባዝ ሀኔዛይ ግሾስ አስ ኡባይ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","አማኔዝ ኡቢታይ ዎላ የዝዛ፤ ፓስ የዛ ባዝ ኡባ ፐትፕ ሻግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ኡንቲ ፓስ የዛ ባዝ ባይዚ ሚሸ ፐታይስ ፐታይስ ኮሽዛይ ጋርክ ሻግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ኡባ ጋላስ ፐቲ ዎዝናር ማቂ ጾስ ካራ ሺቅዛ። ፋ ካራ ፐታይ ፐታ ጼጊ ኡፋይሳራኔ አሽከ ዎዝናር ካꬃ ሚዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ጾስ ጋላትታር አስ ኡባይር ሳብንቴዛ። ጎዳይ አማኒ አትዝታ ጋላስ ጋላስ ኡንታል አፋ ጉጅዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ፐቲ ጋላስ ጵጽሮሳኔ ዋንሳ ጾስ ዎሶዳይስ ኡዱፉን ሳተር ጾስ ካራ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","የልንቴዝ ጋላሳፕ አይኪ ቶኬ ስሌዝ ፐቲ አꬃይ ጾስ ካራ ገልዛ አሳይፕ ሚሸ ዎሶዳይ ጋርክ ኡባ ዎደ ሎኦ ግዝ ጾስ ካራ ፐንገ ጋላስ ጋላስ ክኢ ጋድዛዝን። ");
INSERT INTO mfxe_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","የ ቶኬ ስሌዝ አꬃይ ጵጽሮሳኔ ዋንሳ ጾስ ካራ ገሎድ ሀኖዳር ብኢ ኡንታን ሚሸ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ኡንትካ ኤዛ ዳኪ ብኢ፥ ጵጽሮሳ «ኑኮ Ꮊና ቦኦባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ቶኬ ስላ አꬃይ ኡንታፕ አኮ ባዝ ደማዳ ኣዝን ኡንታን በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ዝን ጵጽሮሳ ኤዝኮ፥ «ታስ ብራኔ ዎርቃ ባያ፥ ዝን ታስ የዛ ባዝ ታ ኔስ እማዳ። ናዝረተ የሱስ ክርስቶሳ ሱንꬃር ደንዲ የꬎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","የይፕ ጉየ፥ ስላ አꬃይስ ኡሻች ኩሻ አይኪ ደንꬄዛ። ኤልሲ ኤ ቶካይኔ ቅልጫይ ሚንጊ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","አꬃይ ጉፒ ደንዲ ኤቄዛ። ገደኔ Ꮊና የꬅ አይኬዛ። የይፕ ጉየ፥ የꬍታራኔ፥ ጉፕታር ጾስ ጋላትታር ኡንታር ዎላ ጾስ ካራ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ኤ የꬎዳራኔ ጾስ ጋላቶዳር አሲ ኡባይ ኤዛ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","በኤዝ ኡቢታይካ ሚሸ ዎሶዳይስ ሎኦ ግዝ ጾስ ካራ ፐንገል በቴዛይ ኤዛ ማቄዛ ኤሬዛ፤ ኤ ሀኔዝባዛ ብኢ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","አꬃይ ጵጽሮሳፐኔ ዋንሳፕ ዱጻም ግ አይኪ የዝን አሲ ኡባይ ማላባዝ ግ፥ ሶሎሞነ ባራንዳ ግዝ አቆ ዎላ ኡንትኮ ዎጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጵጽሮሳ አሳ ብኢ አሳይኮ፥ «እስሬለ አሳዮ፥ አብስ Ꮊያ ማላባዝ ጌ? ዎይ አብስ ኑና ዳኪ በኤ? ኑኒ ኑ ዎልቃር ዎይ ኑ ሎኦትꬃይር Ꮊ አꬃ የꬄዝባዝ ይንትስ ኣዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","አፍራመ፥ እሳቃ፥ ያይቆባ ጾሳይ፥ ኑ አድታይ ጾሳይ፥ ፋ ናአ የሱሳ ቦንቼዛ። ዝን ይ Ꮊይቆስ ኣꬂ እንጌዛ ጵላጾሳ ብልኦዳይስ ኮይኮካ ይ ኤ ቲና፥ ‹ኑኒ ኤዛ ኮዮያ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ይ ጌሻኔ ጽላ፥ ካዲ፥ ሸምፖ ዎꬌዛ ይንትስ ብሎዳይ ጋርክ ጵላጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ደኦ እንግዛ ይ ዎꬌዛ፥ ዝን ጾሲ Ꮊይቆፕ ኤዛ ደንꬄዛ። የይስ ኑኒ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ꮊ ይ ብእዛይኔ ኤርዛ አሳይ ፓጺ ምንጌዛይ የሱሳ ሱንꬃር አማኔዝ ግሾ። Ꮊ ይ ኡባይ ቲና ኤዛ Ꮊይ ጋርክ ፓꬄዛይ ኤ የሱሳ አማኔዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Ꮊተካ ታ እሹንꬆ፥ ይንትካ ይንታን ካልꬅዝታይካ፥ ኤረካዛር ኦꬄዛና ታኒ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ዝን ጾሲ ብኒ ናብታይ ኡባ ዶናር፥ ‹ክርስቶሳ ዋየ ኤኮዳይስ ቤዝዛ› ዬጌዛይ ፖልንቶዳይ ጋርክ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ይኬ፥ ጾሲ ይ ናጋራ አቶ ጎዳይ ጋርክ ማሮቶꬅ ገሊ ጎዳይኮ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ጎዳይ ካለፕ ምንꬃꬆ ዎደ ይንትስ የኦዳ። ጎዳይ ቲናቲ ዶሬዝ ክርስቶሳ ይንትስ ዳኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ጾሲ ፋ ጌሽ ናብታይ ዶናር ብኒ ኦዴዛይ ጋርክ ኡባ ባዝ ኦሮጽዛ ዎደ ሄሎዳይስ Ꮊ የሱሳ ሳሎ ጋምኦዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙሰ፥ ‹ጎዳ ጾሳይ ታና ደንꬄዛይ ጋርክ ይ ጋንጨፕ ይንትስ ናበ ደንꬆዳ። ይ ኤ ግዛ ኡባ ስኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","የ ናባይ ኦዳ ስኦዋ አስ ኦንካ አስ ጋንጨፕ ሻክንቲ ꬋቦ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«ማ ሳምኤላፕ አይኪ የዝ ናብታይ ኡቢታይ Ꮊ ዎደ ባጋ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ይ ናብታይ ናእታ፤ ማ ጾስ አፍራመስ፥ ‹ሳአል የዝ አስ ኡባ ታኒ ነ ሼሻይ ባጋር አንጆዳ› ዬጊ ኑ አድታይስ ገሌዝ ቃላ ጫቆ ላትዛ ናእታ። ");
INSERT INTO mfxe_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ጾስ ይንታን ኡባ ይ ኢታ ኦጋይፕ ማሂ አንጆዳይ ጋርክ ፋ ናአ ደንꬂ ይንትስ ቲና ዳኬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጵጽሮሳኔ ዋንሳ አሳይስ ኦዶዳር ቄስታይ፥ ጾስ ካራ ናግዝታይ ሀላቃይኔ ሳዱቃውታይ ኡንትኮ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ኡንቲ የሱሳ Ꮊይቆፕ ደንዴዛኔ የይፕ ደንዴዛይድ Ꮊይቆፕ ደንዶ የዛና ዎያ ታማርሴዝ ግሾስ ይሎቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","የይ ግሾ፥ ኡንታን አይኪ ሳአ ኦማꬄዛይፕ ዎንቶድ ሄሎዳይስ አች ካራ ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ዝን ቃላ ስኤዝታይፕ ጋምታይ አማኔዛ። አማኔዝ ꬊራꬅ አሳይ ታይባይ እችን ሙኩለ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ዎንትꬃ ጋላስ ካልꬅዝታይ፥ ጭምታይኔ፥ ህገ አስታማርታይ የሩሳላመ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","የ አሳይ ጋንጨ ቄሰ ሀላቃ ሃና፥ ቃያፋ፥ ዋንሳ፥ ኢስክንድረኔ ቄሰ ሀላቃይ ካራ አስታይ ኡባይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ሀዋርታ ፋ ቲና ኤስ፥ «አባ ዎልቃር ዎይ ኦ ሱንꬃር Ꮊያ ይ ኦꬄኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","የ ዎደ ጵጽሮሳ ጌሻ አያናር ኩሚ፥ «ዎያ ሀላቅታዮኔ፥ ጭምታዮ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ꮊይኖ Ꮊ ዎቦ አꬃይስ ኦስንቴዝ ሎኦ ኦሳይል ኤ ዋይዚ ፓጼዛኮ ይ ኑና ኦይጭኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ማዝቃለል አፋ ይ ሶጽን፥ ጾሲ Ꮊይቆፕ ደንꬄዝ ናዝረተ የሱስ ክርስቶሳ ሱንꬃይር Ꮊ አꬃይ ፓጺ ይ ቲና ኤቄዛይ ይንትስኔ እስሬለ አስ ኡባይስ ኤርንቶ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","«‹ይንቲ ግምቢዝታይ ቦሪ እጼዝ ሹቻይ፥ ኬꬄ ሙመር ቶኪ አይክዝ ክርክሮ ጋርከ፥ ኡባይፕ ኣꬊዝ ሹች ማቄዛ፤ የ ሹቻይ የሱሳ።› ");
INSERT INTO mfxe_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","የይ ግሾስ፥ አቶትꬂ ኤ ባጋራፕ አትን ሀራ ኦ ባጋራካ ባያ። ኑኒ ኤ ሱንꬃር አቶድ ጋርክ አስ ኡባይስ ጾሲ ሳሎፕ ኦሞር እንጌዝ ሀራ ሱንꬂ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ሺቄዝ አሳይ ጵጽሮሳኔ ዋንሳ ያሻ ባይꬅ ቆንጨ ኦዴዛና ብኢ ዎደ ኡንቲ ታማረካ ጨረ አስ ማቄዛና አካኪ ማላባዝ ጌዛ፤ ኡንቲ የሱሳር የዛያና ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ማ ፓጼዝ አꬃይ ጵጽሮሳራኔ ዋንሳራ ኤቄዛና አሳይ ብእን ጎድባዝ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ዝን ጵጽሮሳኔ ዋንሳ ባለ ከዞዳይ ጋርክ ኡዲ ፋ ጋንጨ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Ꮊ አስታ ኑ አብ ኡዶ? ኡ ኩሸ ኦስንቴዝ ግታ ማላ ባዛይ የሩሳላመ የዝ ኡባይስ በንትዛ። ኑኒ የያ ኤሮዋ ጎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ዝን Ꮊ ኦዳይ አስ ጋንጨ ላልንታማይ ጋርክ ይከፕ ጉየ Ꮊ አስታይ የሱሳ ሱንꬃይር ኦስካ ኦዳማይኔ ታማርሳማይ ጋርክ ሚንꬂ ኦዲ» ዬጊ ዞርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ኡንታን ጼጊ፥ የሱሳ ሱንꬃይር Ꮊንፕ ገደ የሻ ኦዳማይ ጋርከኔ ታማርሳማይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ዝን ጵጽሮሳኔ ዋንሳ ኡንትኮ ማሂ፥ «ጾስስ ኪትንቶዳይፐኔ ይንትስ ኪትንቶዳይፕ ጾስ ቲና ኣይ ሎኦዛኮ አን ይ ፕርዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ኑኒ በኤዝ ባዝኔ ስኤዝባዝ ኦዳ አሾዳይስ ዳንዳኦያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ዎያ ጭምታይኔ ካልꬅዝታይ ካሴሳይፕ ሚንꬂ ናግሲ ኡንታን ዳኪ አሼዛ። አሳይ ሀኔዝባዛይስ ጾስ ጋላትዛ ግሾስ ኡንታን ሴሮዳይስ ዳንዳእበኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","የ ማላታይር ሀርገፕ ፓꬄዝ አꬃይስ ላይꬃይ ኦይታማፕ ኣꬎ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጵጽሮሳኔ ዋንሳ ብልእንቲ ኡንታር አማንዛ ዳብታይኮ Ꮊንጊ፥ ቄሰ ሀላቅታይኔ ጭምታይ ፋኮ ጌዝባዝ ኡባ ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ኡንቲ የያ ስኤዝ ዎደ ፐቲ ዎዝናር ማቂ ጾሳ Ꮊይ ጋርክ ዬጊ ዎሴዛ፦ «ኡባ ሞድዝ ጎዳዮ፥ ሳሎ፥ ሳአ፥ አባኔ ኡ ጋንጨ የዝ ኡባ ባዝ መꬌዛዮ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ኔኒ ነ አይላና፥ ኑ አደ ዳዉተ ዶና ጌሻ አያናር፥ «‹ዎያ አብስ ይሎቴኔ? አሳይ አብስ ጨረ ቶቤኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ሳአ ካትትይኔ ጋደ ሀርዝታይ ፐትፕ ጎዳይል አፋኔ ኤ ክርስቶሳል አፋ ደንዴዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«ቱማካ፥ ሄሮዶሳኔ ጰንጸ ጵላጾሳ አይሁደ ባ አሳይራኔ እስሬለ አሳይራ ነ ትዤዝ ነ ጌሻ ናአ የሱሳል አፋ ደንዶዳይስ Ꮊ ካታማይ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ማ ነ ዎልቃይዳኔ ነ ሸናይድ ኡዶድ ግ ቆፕ በቴዛ ኡባ ኡንቲ ፖሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ꮊተካ ጎዳዮ፥ ኡ ማንድꬃ ቦኦባ፤ ኑኒ ነ አይልታይ ነ ቃላ ኩንꬅ ዎዝናር ኦዶዳ ጋርክ ኑና ዳንዳእሶባ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ነ ጌሻ ኦሳንቾ የሱሳ ሱንꬃር ሀርጋንችታ ፓꬆዳይስ፥ ኦራꬅባዝኔ ማላትታይ ኦስንቶዳይ ጋርክ ነ ኩሸ ምጮባ» ግ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ኡንቲ ጾስ ዎሴዛይፕ ጉየ የ ኡንቲ ሺቄዝ አቃይ ኤንኤዛ። ኡ ኡባይ ጌሻ አያናር ኩምን ጾስ ቃላ ጎብ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","አማንዝታይ ኡባይ ቆፋራኔ ዎዝናር ፐቶ ማቄዛ። ኡንቲ ፓስ የዛ ባዝ ታባዝ ጌካዛር ፐትፕ ሻክንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ሀዋርታይ ጎዳ የሱሳ Ꮊይቆፕ ደንꬄዝ ግታ ዎልቃር ማርካትዛ። ጾስ ኡንትስ ኡባይስ ኣꬎ ኬሃትꬃይፕ ጋንꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ቢታ ዎይ ካምፓ የዝታይ ኡባይ ባይዚ ኤኬዝ ሚሻ ክእዛ ግሾስ አማንዝታይ ጋንጨ መትንቴዛይ ፐታካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ሚሸ ክኢ ሀዋርታይስ እንግዛ፤ የ ሚሻ ፐታይስ ፐታይስ ኮሽዛይ ጋርክ ሻጊ ሻጊ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ቆጲሮሳ ግዝ አቆ የልንቴዝ ዮሴፋ ግዝ ለወ ሼሻይፕ ማቄዝ ፐታይ የዛ። ኤ ሱንꬃ ሀዋርታይ ባርናባሳ ጌዛ። ባርናባሳ ጉሳይ ምንꬃꬆ ናአ ጉሲ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ባርናባሳ ፓስ የዝ ቢታ ባይዚ ሚሻ ክኢ ሀዋርታይስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ፐቲ ሀናና ግዝ አꬃይ ፋ ማቻት ሳጵርር ዎላ ጋደ ባይዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","የ ባይዜዝ ሚሻይፕ ፋ ማቻት ኤሮዳር ሻጊ አሺ፥ አቴዛና ክኢ ሀዋርታይ ቶኬ ካለ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ዝን ጵጽሮሳ ሀናናኮ፥ «ኔኒ ጌሻ አያና ዶሾዳይ ጋርኬኔ ቢታ ባይዜዝ ሚሻይፕ ሻጊ አሾዳይ ጋርክ ጻላሄ ነ ዎዛና አብስ ገሌኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ኔኒ ባይዞዳይፕ ቲና ቢታይ ኔስ ባሳኔ? ማ ነ ባይዝ ማቅንካ ሚሻይ ኔስ ባሳኔ? የዝን፥ የይ ጋርክ ኦꬆዳይስ አብስ ነ ዎዝናር ቆፔኔ? ኔኒ ጾሳል አፋ ዎርዶቴነፕ አትን አሳል አፋ ዎርዶተካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሀናኔ የ ቃላ ስኤዛን ጋርክ ፖኪ Ꮊይቄዛ፤ የያ ስኤዝ ኡባይ ኢታ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ናአትꬃ አስታይ ደንዲ ኤ አሃ ዚꬊ አፍላር ጻጺ ካንጊ ሞጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ሀይꬒ ሳተፕ ጉየ ሀናና ማቻት የያ ኤረካዛር ጵጽሮሳ የዛ አቆ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጵጽሮሳ ኢኮ፥ «ይ ቢታ Ꮊኒ ጋርክ ሚሸስ ባይዜኔ? አን ታስ ኦዶባ» ዬጌዛ። እዛካ፥ «ኤ፥ Ꮊይ ጋርክ ሚሸስ ባይዜዝ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጵጽሮሳ ኢኮ፥ «ኔራኔ ነ አዝናይራ ጎዳ አያና ፋጮዳይስ አብስ ዞርንቴኔ? ዬዛኮ፥ ነ አዝና ሞጌዝ አሳይ ባለር የዛ፤ ነናካ ኡንቲ ባለ ከሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","እዛካ እዝር ጵጽሮሳ ቶኬ አቻ ፖኪ Ꮊይቂ አቴዛ፤ ናአትꬅታይ ገሎዳር Ꮊይቄዛኖ ደንጊ ባለ ከሲ፥ እ አዝናይ ካለ ሞጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ዎሳ ኬꬅ ኡባይኔ የያ ስኤዝ ሀራ አስ ኡባይ እታ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ሀዋርታይ ጋመ ማላትታኔ ኦሮꬃባዝታ አስ ጋንጨ ኦꬄዛ። አማንዛ ኡባይ ሶሎሞነ ባራንዳ ፐትፕ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ሀራ አሳይፕ ፐቲ አስካ ኡንታን ሄሎዳይስ ምንገካያ፥ ዝን አሳይ ኡንታን ቦንችዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","አማንዛ ꬊራꬅታይኔ ማችታይ ታይባይ ካሴሳይፕ ጋንግታር ጋግታር ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","የይ ግሾስ፥ አሳይ ሀርጋንችታ ሀላራኔ አርሳር ቶኪ ጵጽሮሳ ኣꬎዳር ኤ ኩያይ ኡንታፕ ፐታይል ፐታይል አፋ ሸምፖዳይ ጋርክ ኦገ ዶና ከሲ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ማ ጋመ አሳይ የሩሳላመ ካለ የዝ ካታምታይፕ ሀርጋንችታኔ ቱና አያና ዋይስዛ አስታ ኤኪ ይእዛ፤ ኡባይካ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ቄሰ ሀላቃይኔ ኤዛር የዝ ሳዱቃውታይ ኡባይ ቅናተር ኩሚ ሀዋርታይል አፋ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ሀዋርታና አይኪ ዎያ አች ካራ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ዝን ጎዳ ኪታንቻይ ቃማ አች ካራ ፐንጋ ዶዪ ሀዋርታ ባለ ከሲ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ꮊንጊ፥ ጾስ ካራ ኤቂ Ꮊ ደኦ ቃላ አስ ኡባይስ ኦዶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ሀዋርታይ የያ ስኤዝ ዎደ ዎንት ጉራ ጾስ ካራ ገሊ ታማርሶ አይኬዛ። ቄስታይ ሀላቃይኔ ኤዛር የዝታይ ይኢ፥ እስሬለ ጭምታ ኡባ ጼጊ ሺሺ ሀዋርታ ፋ ቲና ኮኦዳይ ጋርክ ዎታዳርታ አች ካራ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ዝን ዎታዳርታይ አች ካራ Ꮊንጊ ሀዋርታ ደንገካያ። ጉየ ማቂ ይኢ ዎያስ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«ኑኒ Ꮊንጎዳር አች ካራ እብꬃይ ሚንꬂ ጎርደትን፥ ናግዝታይ ፐንገል ኤቄዝታ ደንጌዝ። ዝን ኑኒ ፐንጋ ዶዮዳር ጋንጨ ሀራ አቶዝን ፐቲ አስካ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","የይ ግሾስ፥ ጾስ ካራ ዎታዳርታ ኪትዛይኔ ቄሰ ሀላቅታይ የያ ስኤዝ ዎደ «ሀዋርታይል አፋ አብ ሀነኔ?» ዬጊ ታዌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","የ ዎደ ፐቲ አꬃይ ኡንትኮ ይኢ፥ «አች ካራ ይ ገልሴዝ አስታይ ጾስ ካራ ኤቂ አሳ ታማርስዛ» ዬጊ ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ጾስ ካራ ዎታዳርታ ኪትዛይ ፋ ዎታዳርታይራ Ꮊንጊ ሀዋርታ ከኤዛ። ዝን ኡንቲ ፋና አሳይ ሹቻር ሾጮዳ ግ ያሽቴዝ ግሾስ ኡንታን አዳሺ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ኡንቲ ሀዋርታ ክኢ፥ ሺቄዝ ሻንጎ ቲና ክእን ቄሰ ሀላቃይ ኡንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«ይንታን ኑኒ ያ አꬃይ ሱንꬃር ታማርሳማይ ጋርክ ሚንꬂ ኪተካሳ? ዬዛኮ፥ ይ ትምርታ ይ የሩሳላመ ካታማ ኡባ ሄልꬄዛ። የ አꬃይ ሸምፖይስ ኑና ኦይጭሾዳይስ ይ ቆፕነ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጵጽሮሳኔ Ꮊንኮ ሀዋርታይር ኡንትስ ማህታር፥ «ኑኒ አስስ ኪትንቶዳይፕ ጾስስ ኪትንቶዳይስ ኑስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ማዝቃለል አፋ ይ ሶቲ ዎꬌዝ የሱሳ ኑ አድታይ ጾሳይ Ꮊይቆፕ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","እስሬልታይ ናጋራይፕ ማቆዳይ ጋርከኔ ኡ ናጋራይ አቶ ግንትንቶዳይ ጋርክ ጾሲ የሱሳ ሃርዛኔ አሽዛ ኡዲ ቦንቾር ፋፐ ኡሻች ባጋር በትꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","የይስ ኑኒ ማርካ፤ ማ ጾሲ ፋስ ኪትንትዝታይስ እንጌዝ ጌሻ አያናይካ ማርካ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ሺቄዝ አሳይ የያ ስኤዝ ዎደ ኢታ ይሎቲ፥ ሀዋርታ ዎꬎዳይስ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ዝን አስ ኡባይድ ሎኦ ቦንችንቴዝ፥ ህገ አስታማራይ፥ ጋማላለ ግዝ ፐቲ ፈርሳዋይ ደንዲ ኤቂ ሀዋርታ ጽቃ ዎደስ ባለ ከሶዳይ ጋርክ አዛዘዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","የይፕ ጉየ፥ ሺቄዝ አሳይኮ፥ «እስሬለ አሳዮ፥ Ꮊ አስታይል አፋ ይ ኡዶዳይስ ቆፕዛባዝፕ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","አብስ ጊኮ፥ Ꮊይፕ ቲና ተዎዳሳ ፋና፥ ‹ታኒ ዳማ› ግ ደንድን፥ ኦይዲ ጼት ማቅዝ አስታይ ኤዛር ማእንቴዛ። ዝን ኤዛ ዎꬍን፥ ኤዛ ካሌዝ ኡባይ ላልንቲ ፓꬆዋ አስታ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","የይፕ ጉየ፥ አሳይ ታይብንትዛ ዎደ ጋልላ የዝ ይሁዳ ደንዲ ጋመ አስ ፓንጋ ማሂ ካልꬄዝ፥ ዝን ኤዛካ ዎꬍን ኤዛ ካሌዝ አስ ኡባይ ላልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ꮊተካ ታ ይንትስ ኦድዛ፤ Ꮊ አስታይፕ ሻክንቶይታ፤ ኡንታን ቦችፓተ። አብስ ጊኮ፥ Ꮊ ቆፋኔ Ꮊ ኦሳ አሲ ኦꬅዛባዝ ማቅኮ ꬋቦዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ዝን Ꮊ ቆፋይኔ Ꮊ ኦሳይ ጾሳፕ የኤዝ ባዝ ማቅኮ፥ ይ ኡንታን ꬋብሶዳይስ ዳንዳኦዋ። ዬይታር ይ ጾሳር ካጭንቶዳ» ዬጊ ኦዴዛ። የይ ግሾስ፥ ሺቄዝ አሳይ ጋማላለ ዞርዛ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ሀዋርታ ካራ ጼጊ ገልሲ አላንጋር ጋራፌዛ። የይፕ ጉየ፥ ኡንትኮ፥ «የሱሳ ሱንꬃ ናምእንꬆ ደንꬅፓተ» ግ ብልእ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","የሱሳ ሱንꬃይ ግሾስ ኡንቲ ካዉዦዳይ ቤዝዛ ባዝ ማቄዛና ኤሬዝ ግሾስ ሻንግታይ ቲናፕ ኡፋይትታር ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ኡንቲ ኡባ ዎደ ጾስ ኬꬃኔ አስ ካራ የሱሳ ኤ ክርስቶሳ ማቄዛና ታማርስዛናኔ ሳባክዛና አሸካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","የ ዎደ ካልዝታይ ታይባይ ጋንጊ ጋንጊ Ꮊንጎዳር፥ ግርኬ ዶና ኦድንትዛ አይሁድታይ ይሁዳ የልንቲ የዝ አይሁድታይል አፋ ኦሌዛ። አብስ ጊኮ፥ ግርኬ ዶና ኦድንትዛ አይሁድታይ፥ «ጋላስ ጋላስ እንግንትዛ ካꬃይፕ አዝኒ Ꮊይቄዝ ማችታ ኡ ዶግዛይ ግሾስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ታጶ ናምኢ ሀዋርታይ ዎሳ ኬꬅ አስ ኡባ ጼጊ፥ «ኑኒ ጾስ ቃላ ኦድዛና አሺ ካꬃ ግሾዳይስ ኑስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ይኬ፥ ኑ እሹንꬆ፥ ሎኦ አስታ፥ ጌሻ አያናራኔ ኤጨትꬃር ኩሜዝ ላፑን አስታ ይ ጋንጨፕ ዶሮይታ፤ ኑኒ ኡንታን Ꮊ ኦሳይስ ሹሞዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ዝን ኑኒ፥ ኑ ኩንꬅ ዎደ ጾሳ ዎሳላኔ ቃላ ታማርሶል ፔሾዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ሀዋርታይ ኦዴዝ ኦዳይ አስ ኡባ ኡፋይሴዛ። የይ ግሾስ፥ አማኖራኔ ጌሻ አያናር ኩሜዝ ኢስጽፋኖሰ፥ ፍልጶሳ፥ ጵሮኮሮሳ፥ ንቃሮነ፥ ጽሞና፥ ጳርሜናኔ አይሁደ አማኖ ገሊ ማቄዝ አንጾካ ንቆሎሳ ማራጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ኡንታን ሀዋርታይ ቲና ክእን፥ ሀዋርታይ ኡንታል አፋ ኩሸ ጋዲ ጾስ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ጾስ ቃላይ ዳልግታር ዳልግታር Ꮊንጌዛ። የሩሳላመ የዝ አማንዝታይ ታይባይ ጋንጊ ጋንጊ ቅቴዛ፤ ቄስታይፐካ ጋምታይ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ኢስጸፋኖሰ አꬎ ኬሃተꬃይራኔ ዎልቃር ኩሚ አስ ጋንጨ ኦሮꬅባዝታኔ ማላባዝታ ኡድዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","አይለትꬃፕ ከዝዝታይስ ግንትንተዝ አይሁደ ዎሳ ኬꬅ አሳይ ቀረናፐኔ ኢስክንድረፐ ክልቀፐኔ ኢስያፕ የኤዝ ፐቲ ፐቲ አስታይ ደንዲ ኢስጽፋኖሳር ፓላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ዝን ኢስጽፋኖሰ ኦድንትታር የዝ ኤጨትꬃኔ አያና ኡንቲ ኤቅንቶዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","የ ዎደ ኡንቲ፥ «ሙሰናኔ ጾሳ ኤ ጫዦዳር ስኤዛ» ግዝ ዎርዶ ማርክታ ደንꬅꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","የይ ጋርክ ኡዲ ዎያ ጋደ ጭምታኔ ህገ አስታማርታ ኤዛል አፋ ደንꬅꬅሴዛ። ኢስጽፋኖሰና አይኪ ሻንጎ ቲና ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ኤዛል አፋ ፓይዴዝ ዎርዶ ማርክታይ፥ «Ꮊ አꬃይ Ꮊ ጾስ ካራኔ ሙሰ ህጋ ማሂ ማሂ ጫዥዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ኤ፥ ‹Ꮊይ ናዝረተ የሱሳ፥ Ꮊ ጾስ ካራ ላሎዳ፤ ማ ሙሰ ኑስ እንጌዝ ህጋ ላሞዳ› ዬጎዳር ኑኒ ስኤዝ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ሻንጎ ሺቆል በቴዝ አስ ኡባይ ኢስጽፋኖሰ ዳኪ በአዳር ኤ ስናይ ኪታንቾ ስኖ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ቄስታይ ሀላቃይ ኢስጽፋኖሰኮ፥ «Ꮊ ሞታይ ቱማ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ኢስጽፋኖሰ፥ «ታ እሹንꬆ፥ ታ አድታዮ፥ ስኦይታ! ኑ አዳ አፍራመ ካራነ የዞዳይስ Ꮊንጎዳይፕ ቲና ማሰጰጾመ የዝን፥ ቦንቾ ጾሳይ ኤስ ቆንጪ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹ነ ጋዳይፐኔ ነ ዳብታይፕ ሻክንቲ ታኒ ነና ቤዝዛ ቢታ ቅቶባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","የ ዎደ አፍራመ ካላዳውታይ ቢታፕ ከዚ ካራነ የዞዳይስ ቅቴዛ። ኤ አዳይ Ꮊይቄዛይፕ ጉየ ጾሲ ኤዛ Ꮊ ቢታ Ꮊት ይ የዝ ጋዳ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ኤ ሀራ አቶዝን ቶካይ የꬍዝ አቆካ አፍራመስ እንገካ። ዝን ናአ ኤስ ባ ዎደ ጾስ Ꮊ ቢታ ኤስኔ ኤ ሼሻይስ ላታ ኡዲ እንጎዳና ቃላ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ጾሲ አፍራመኮ፥ ‹ነ ሼሻይ ሀራ ቢታ እማꬄትꬃር የዞዳ፤ ኤዛይድ ኦይዲ ጼት ላይꬅ ኡንቲ አይለትꬃ ሃርንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ዝን ታኒ ነ ሼሻ ሞድዝ ጋዳይል አፋ ፕርዶዳ። የይፕ ጉየ፥ ኡንቲ የ ቢታይፕ ከዚ Ꮊይዳ ታስ ጎይኖዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ጾሲ አፍራመ ሼሻይ ዶካልንቶዳይ ጋርክ ኤዛር ጫቂን፥ እሳቃ የልንቴዝ ሆስፑንꬃ ጋላሳር ዶካሌዛ። እሳቃ ያይቆባና ዶካሌዛ፤ ማ ያይቆባ ፋ ታጶ ናምኢ ናእታ፥ ኑ አድታይ ማይዝታ ዶካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«ያይቆባ ናእታይ ዮሴፋና ቅናቲ ግብጸ ቢታ አይለትꬅስ ባይዜዛ፥ ዝን ጾሲ ኤዛር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ኤዛ፥ ኤ ዋየ ኡባይፕ ከሴዛ። ግብጸ ካት ፓሮና ቲና ዴተኔ ኤጨትꬅ ኤስ እንጌዛ። ግብጸ ካታይ ዮሴፋስ ግብጸ ቢታኔ ፋ ካራ ኡባ አቅሶድ ሀላቃትꬅ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«ግብጸ ቢታይዳኔ ካንአነ ጋደ ኡባይድ ናየ ገሊ ጋመ አሳ ኡንእꬄዛ። የ ዎደ ኑ ማይዝታይ ካꬃ ደንጎዳይስ ዳንዳእበኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያይቆባ ግብጸ ቢታ ካꬃ የዛና ስኢ ኑ አድታይ ቲና ገድ ኤዛ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ናምእንꬅ Ꮊማይር ዮሴፋ ፋ እሽታይስ ፋና ኤርሴዛ። ግብጸ ካት ፋሮና ዮሴፋ ሼሻና ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ዮሴፋ ፋ አደ ያይቆባኔ ፋ ዳቦ ኡባ፥ ላፑን ታማን እችን አሳይ ፋኮ የኦዳይ ጋርክ ኪቲ ክእሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ያይቆባ ግብጸ ቢታ ዎꬌዛ፤ ኤነ ኤ ናእታይ ኤዛይድ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ኡ መቀꬃ የ አቃይፕ ሴኬመ ቶክንቲ Ꮊንጊ፥ ኤዛይድ አፍራመ ሀሞረ ናእታይፕ ጋም ብራር ዎንጌዝ ዱፋይድ ሞጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«ዝን ጾሳይ አፍራመስ እንጎድ ጌዛ ፖልዛ ላይꬅ ሄሎዳይስ ሄሌዝ ዎደ ግብጸ ቢታይድ የዝ ኑ አሳይ ጋንጊ ጋንጊ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","የይፕ ጉየ፥ ዮሴፋ ኤሮዋ ሀራ ካት ግብጸ ቢታይድ ካዉቶድ ሄሎዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","የ ካታይ ኑ ዘርꬃ ገኒ ጽቃ ናእታይ Ꮊይቆዳይ ጋርክ ኡንታን ባለ ከሲ ኦሎዳይ ጋርክ ኑ አድታ ኡንእꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«የ ዎደ ሙሰ የልንቴዝ፤ ኤ ጾስ ቲና ኡሳ ሎኦ ናአ። ፋ አዳይ ካራ ሀይꬒ አግና ሄሎዳይስ ድጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ሙሰ ዎራ ጋዴዝ ዎደ ግብጸ ካታይ ናእታ ደንጊ ኤኪ ፋ ናአ ኡዲ ኤዛ ድቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙሰ ግብጽታይ ኤጨትꬅ ኡባ ታማሪ ኦዳራኔ ኦሶር ምኖ አስ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«ሙሰስ ላይꬃይ ኦይታም ኩሜዝ ዎደ ፋ እሽታ፥ እስራኤልታ በአዳይስ ፋ ዎዝናይድ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","እስራኤልታይፕ ፐታያ ግብጸ አስ ፐታይ ቆሆዳር ብኢ የ እስሬለ አꬃ ማዲ፥ የ ቆሄዝ ግብጸ አꬃ ዎꬊ ኩሸ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ሙሰ ፋ እሽታ ፋ ባጋር ጾሲ አሾዳይስ ሀንዛና ኡንቲ አካኮዳ ግ ቆፔዛ፥ ዝን ኡንቲ አካኬካ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«ዎንትꬃ ጋላስ ናምኢ እስሬለ አስታይ ፐታይ ፐታይር Ꮊꬊንቶዳር ደንጌዛ ኡንታን ዳቦꬆዳይስ ከዚ፥ ‹አሱንꬆ፥ ይ እሽታ፤ አብስ ፐታይ ፐታ ቆህነ?› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«ዝን ፐታይ ፋ ላጋ ቆህዛይ ሙሰኮ፥ ‹ነና ኑል አፋ ሃርዛኔ ዳይና ኦꬄዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ኔኒ ዝቅን ግብጸ አꬃ ዎꬌዛይ ጋርክ ታና ዎꬎዳይስ ኮይኔ?› ዬጊ ሙሰና ኡርቂ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሰ የያ ስኢ ግብጸፕ በቲ ሚዳመ ቢታ በተ አስ ማቂ የዝታር ናምኢ ꬊራꬅ ናእታ የሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«ጎዳይ ኪታንቻይ ኦይታም ላይꬃፕ ጉየ ሲና አምባ ካለ የዝ ሊዦ ቱሸ ጋንጨ ኤጽዝ ታማ ላጮ ጋንጨ ሙሰስ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙሰ ፋ በኤዛይድ ማላባዝ ግ፥ ሎእꬂ በአዳይስ ቱሻይኮ ሺቂ የዝን፥ ጎዳ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹ታኒ ነ አድታይ፥ አፍራመ ጾስ፥ እሳቃ ጾስ፥ ያይቆባ ጾስ› ዬግታር ሙሰኮ የኤዛ። ሙሰ ያሻር ኩኩሪ በአዳይስ ዳንዳኤካ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«ጎዳይ ሙሰኮ፥ ‹ኔኒ ኤቄዝ ቢታይ ጌሽ ማቄዝ ግሾስ ነ ቶካይድ የዝ ጫማ ከሶባ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ታኒ ግብጸ የዝ ታ አሳይ ኡንእንታ በኤዛ። ኡ ኡፋ ስኢ ኡንታን አሾዳይስ ዎꬌዛ። Ꮊት Ꮊና የኦባ! ታኒ ነና ግብጸ ኪቶዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«እስሬልታይ ሙሰ፥ ‹ነና ኑና ሃርዛኔ ዳይና ኦꬄዛይ ኦኖ?› ዬጊ እጼዛ። ዝን ሙሰ ቱሸ ጋንጨ ኤስ በንቴዝ ኪታንቻይ ባጋር ሃርዛኔ አሽዛ ኡዲ ጾሲ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","የ ሙሰ እስራኤልታ ግብጸ ቢታይር ዞቆ አባኔ ሊዦ ቢታር ኦይታም ላይꬅ ማላባዝታኔ ኦሮꬃባዝታ ኦꬅታር ኡንታን ካልꬅ ከሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«እስሬለ አሳይኮ፥ ‹ጾሲ ታና ደንꬄዛይ ጋርክ ይ ሼሻይ ጋንጨፕ ታ ጋርክ ናበ ይንትስ ደንꬆዳ› ዬጌዛይ Ꮊ ሙሰ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ሊዦ ቢታ ሺቄዝ እስሬለ አሳይራ የዜዛይ፥ ኑ አድታይራኔ ሲና አምባል አፋ ኤስ ኦዴዝ ኪታንቻይራ የዜዝ። የ ሙሰ ደኦ ቃላ ኑስ እንጎዳይስ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«ዝን ኑ ማይዝታይ ሙሰስ አዛዝንቶዳይስ ኮየካያ፤ ኤዛ እጺ ጉየ ግብጸ ማቆዳይስ አሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ማ አሮናኮ፥ ‹ኑና ካልꬅዛ ጾስታ ኑስ ኦꬆባ። አብስ ጊኮ፥ Ꮊይ ኑና ግብጸፕ ከኤዝ ሙሰ፥ ዋዬዛኮ ኑኒ ኤሮያ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","የ ዎደ ኦጎና አዝዝ ኤቃ ኦꬄዛ። የ ኤቃይስ ያርሾ ያርሼዝ ፋ ኩሸር ኦꬄዝ ኦሳይር ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ዝን ጾሲ ኡንትስ ዞኮ ማሄዛ። ኡንቲ ሳሎ ጾልንትታ ጎይኖዳይ ጋርክ ኡንታን አሺ አሼዛ። ናብታይ ማጻፋይድ፥ «‹እስሬለ አስታዮ፥ ኦይታም ላይꬅ ኩንꬅ ሊዦ ቢታ ሹኬዝ መሄኔ ያርሼዝ ያርሻ ታስ ያርሼነኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ይ፥ ይንትስ ጎይኖዳይስ ኮቼዝ ኤቃነ ሞሎኬ ዱንካና ረፋና ግዝ ይ ጾሳ ጾልንቶ ምስላ ቶኬዛ። ታኒ ይንታን ባብሎነፕ ሰኮ ባጋ ዳኮዳ› ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«ኑ አድታይስ ሊዦ ቢታ ማርካ ዱንካናይ የዛ። ኤዛካ ጾሲ ሙሰ አዛዜዛኔ ኤ ቤዜዛይ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ማ ኑ አድታይ የ ዱንካና ፋ አድታይፕ ኤኪ ጾስ ቲና ባይእꬄዝ አይሁደ ማቀካ አሳይ ቢታ አይኬዝ ዎደ ኢያሱር ዎል ኤኪ ገሌዛ። የ ዱንካናይ ዳዉተ ዎደ ሄሎዳይስካ የ ጋዳይድ የዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ዳዉተ ጾሳር ሳብንቴዛ። ማ ያይቆባ ጾሳይስ ኬꬅ ኬጾዳይስ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ዝን ኤስ ኬꬅ ኬጼዛይ ሶሎሞነ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«ሀኖ ዝን፥ ኡባይፕ አፋ ጾሳይ አሲ ኬጼዝ ኬꬃ የዞያ። ናበ ጌዛይ ጋርክ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«‹ሳሎ ታ ዙፋነ፥ ሳአይካ ታ ቶካይ የꬍዝ አቆ። የዝን፥ ታስ ይ አብ ጋርክ ኬꬅ ኬጾደ? ዎይ ታኒ ሸምፕዛ አቃይ አባ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ꮊ ኡባ ኦꬄዛይ ታ ኩሸ ባሳ?› ዬግዛ ጎዳይ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«ይ ዋይዚ ስኦዋ አሶ? ይ ዎዝናይ ጾስ ቃላ ኤኮዳይስ አብስ እጼኔ? ይ ሀያይ አብስ ቱሌኔ? ይ፥ ይ አድታይካ ኡባ ዎደ ጌሻ አያናራ ኤቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ናብታይ ጋንጨፕ ይ አድታይ ባይኤዛይ ኦኖ? ጽላይ የኦዳና ቲናቲ ኦዴዛና ዎꬌዛ። Ꮊት ይ ኤዛ ኣꬂ እንጊ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ይ ኪታንቻ ኩሸፕ ጾስ ህጋ ኤኬዛ፥ ዝን ኪትንተካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ኡንቲ የያ ስኤዝ ዎደ ፋ ዎዝናይድ ኢስጽፋኖሰል አፋ ጋመ ይሎቲ፥ ፋ አች ꬋቂ ማንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ዝን ኢስጽፋኖሰ ጌሻ አያናር ኩሚ፥ ሳሎ ኡዴ ብኢ፥ ጾስ ቦንቾኔ የሱሳ ጾስ ኡሻች ባጋር ኤቄዛና በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«ዬዛኮ፥ ታኒ ሳሎ ዶይንትን፥ አስ ናአይ፥ ጾሳ ኡሻቻ ኤቄዛ በኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ቃላ ꬎቅ ኡዲ ኡክታር፥ ፋ ሀያ ቱጪ ዎላ ኤኮ ዎጼዛ ");
INSERT INTO mfxe_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ኤዛ ካታማይፕ ጋጻ ከሲ፥ ሹቻር ጫዴዛ። ማርካቲ ፋ ማአ ፐቲ ሳኦላ ግዝ ናአትꬃይ ካለ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ኢስጽፋኖሰ፥ «ታ ጎዳ የሱሳ፥ ታ ሸምፓ ኤኮባ» ዬጊ ጼጎዳር ኡንቲ ኤዛ ሹቻር ጫዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ቡንቅቲ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «ታ ጎዳዮ፥ Ꮊ ናጋራ ኡንትስ አቶ ጎባ» ዬጌዛ። የያ ጌዛፕ ማቂ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ሳኦላ ኢስጽፋኖሰ Ꮊይቃይድ ማእንቴዛ። የ ጋላስ የሩሳላመ የዝ ዎሳ ኬꬃ ግታ ባይእꬅ ደንዴዛ። ሀዋርታይ አትን አማንዝታይ ኡባይ ይሁዳ ቢታኔ ሳማረ ቢታ ላልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ፐቲ ፐቲ ጾስ አስታይ ኢስጽፋኖሰ ሞጌዛ፤ ማ ኤስ ኢታ ዬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ዝን ሳኦላ ዎሳ ኬꬅ ꬋብሶዳይስ ኮይዛ። ካራ ካራ ዩዪ ገሊ፥ አማንዛ ꬊራꬅታኔ ማችታ ጎቺ ጎቺ ከሲ አች ካራ ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ላልንቴዝ አማንዝታይ Ꮊንጌዝ አቆ ኡባይድ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፍልጶሳ ሳማረ ካታማ Ꮊንጊ ክርስቶሳ ባጋ አሳይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ጋመ አሳይ ፍልጶሳ ጌዛ ስኤዝ ዎደኔ ኤ ኦꬅዛ ማላባዝታ በኤዝ ዎደ ኤዛ አካኪ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ቱና አያንታይ ኡኪ ጋመ አሳይፕ ከዜዝ፤ ማ ጋመ ጉንድታይኔ ዎብታይ ብልእንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","የ ካታማይድ የዝ አሳይ ጋመ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ዝን ስሞና ግዝ ፐቲ አꬃይ የ ካታምተ የዛ። ኤ፥ «ታኒ ግታ ግታ አስ» ግ ሳማረ አሳ ካዮር Ꮊይ ማላባዝየግስታር ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ጽቃፕ አይኪ ዳማ ሄሎዳይስ የዝ አስ ኡባይ፥ «ዳማ ጾሳ ዎልቃይ Ꮊያ» ግ ኤዛ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ጋመ ዎደፕ አይኪ ካዮር ሳማረ አሳ ማላባዝ ግሴዝ ግሾስ አሳይ ኤዛ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ዝን ፍልጶሳ ጾሳ ካተትꬃኔ የሱስ ክርስቶሳ ሱንꬅባጋ ꬊራꬅታይስነ ማችታይስ ኦድን፥ ኡንቲ ኤባዝ አማኒ ጻማቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ማ ስሞናካ አማኒ ጻማቅንቲ ፍልጶሳራ ዎላ Ꮊንጊ በኤዝ ባዝ ኡባይዳኔ ኦስንቴዝ ግታ ማላትታ ብኢ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","የሩሳላመ የዝ ሀዋርታይ ሳማረ አሳይ ጾስ ቃላ ኤኬዛ ስኢ ጵጽሮሳኔ ዋንሳ ኡንትኮ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ጵጽሮሳኔ ዋንሳ Ꮊንጊ፥ አማንዝታይ ጌሻ አያና ኤኮዳይ ጋርክ ኡንትስ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","አብስ ጊኮ፥ ሳማረ አስታይ ጎዳ የሱሳ ሱንꬃር ኣዳ ጻማቅንቴነፕ አትን ኡንታፕ ፐታይል አፋካ ጌሻ አያና ሀጋ ዎካ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","የ ዎደ ጵጽሮሳኔ ዋንሳ ፋ ኩሸ ኡንታል አፋ ጋድን፥ ኡንቲ ጌሻ አያና ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ሀዋርታይ ፋ ኩሸ ኡንታል አፋ ጋድን፥ ኡንትስ ጌሻ አያናይ እንግንቴዛ ስሞና በኤዝ ዎደ ጵጽሮሳስኔ ዋንሳስ ሚሸ ክኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«ታንካ ታ ኩሸ ጋዴዝ ኡባይ ጌሻ አያና ኤኮዳይ ጋርክ Ꮊ ማዉተ ታስካ እንጎይተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ዝን ጵጽሮሳ ኤኮ፥ «ኔኒ ጾስ እሞታ ሚሸር ዎንጎዳይስ ቆፔዛይ ግሾስ ነ ሚሽትር ነና ኤኪ ꬋቦ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ነ ዎዝናይ ጾስ ቲና ሉሎ ማቀካ ግሾስ ኔስ Ꮊይዳ ሻጎ ዎይ ቃዳ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ይኬ፥ Ꮊ ነ ዎዝና ኢታትꬃይ ግሾስ ናጋራይፕ ማቆባ። ነ ዎዛና የዝ ኢታ ቆፋ ጾሲ አቶ ጎዳይ ጋርክ ጎዳ ዎሶባ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ነ ኢታ ጫሞ ቅናተራኔ ናጋራ አቻ የዛያ ታኒ ብእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ስሞና ማሂ፥ «ይ ጌዛይፕ ፐታካ ታና ሄላማይ ጋርክ ታስ ጎዳ ዎሶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጵጽሮሳኔ ዋንሳ ማርካቴዛይፐኔ ጎዳ ቃላ ኦዴዛይፕ ጉየ የሩሳላመ ማቄዛ። ሳማረ የዝ ጋመ ሄራ ዎንግለ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ጎዳ ኪታንቻይ ፍልጶሳኮ፥ «ደንዲ ሱለ ባጋር የሩሳላመፕ ጋዛ ካንግዛ ሊዦ ቢታ ኦጋይኮ Ꮊንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ፍልጶሳ ደንዲ ቅቴዛ። ህንደኬ ግዝ ቶጰ ካታትስ እ ሚሻ ኡባ ናግዛ ቶጰ አስ የዛ። ኤካ ጎይኖዳይስ የሩሳላመ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ጋረል በቲ፥ የሩሳላመፕ ፋ ቢታ ማቅታር ናበ ኢስያሳ ማጻፈ ናባብዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ጌሻ አያናይ ፍልጶሳኮ፥ «የ ጋራይኮ Ꮊንጊ ካለ ሺቆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","የዝን ፍልጶሳ ዎጺ Ꮊንጊ ሄሎዳር ዣንዳርባይ ናበ ኢስያሳ ማጻፈ ናባቦዳር ስኢ፥ «ነ ናባብዛይ ኔስ ገልኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ዣንዳርባይ፥ «ታና ታማርስዛ አስ ባዝን ዋይዚ ገሎደ?» ዬጌዛ። ጋረል ከዚ በቶዳይ ጋርክ ፍልጶሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ዣንዳርባይ ናባብዛ ማጻፋይ ክፍላይ Ꮊያ፥ «ኤ ዱር ጋርክ ሹክንቶዳይስ ላግንቴዛ፤ ዱር ናአ ፋ እክሳ ሜድዝታይ ቲና ስእ ግዛይ ጋርክ፥ ኤካ ፋ ዶና ዶየካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ኤ ካዉዤዛ፤ ኤስ ጽሎ ፕርዳካ ꬋቤዛ። ኤ የሳይ Ꮊ ሳአይፕ ጋችንቴዝ ግሾስ ኤ ሼሽባጋ ኦኖ ኦዶዳይ?» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ዣንዳርባይ ማሂ ፍልጶሳኮ፥ «ናበ ኦባዝ ኦዴ? ፋ ባጋ ኦድነኔ ሀራ አስባዝ ኦዴ? ታስ ኦዶየ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፍልጶሳ ማሂ፥ ጾስ ቃላ የ አቃይፕ አይኪ፥ የሱሳ ባጋ ኦድዛ ዎንግለ ኤስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ኡንቲ Ꮊንግታር ሃꬂ የዛ አቆ ሄሌዛ። ዣንዳርባይ፥ «ሃꬄ Ꮊያ ቦኦባ፤ ታ ጻማቅንታማይ ጋርክ አቢ ካየ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፍልጶሳ ኤኮ፥ «ኔኒ ነ ኩንꬅ ዎዝናይፕ አማንኮ ዳንዳእዛ» ዬጌዛ። ኤ ማሂ፥ «የሱስ ክርስቶስ ጾሳ ናአ ማቄዛና ታኒ አማንዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ጋራይ ኤቆድ ጋርክ ዣንዳርባይ ኪትን፥ ናምአይ ዎꬊ ሃꬃ ገሌዛ፤ ፍልጶሳ ኤዛ ጻማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ኡንቲ ሃꬃፕ ጋጻ ከዜዛን ጋርክ ጎዳ አያናይ ፍልጶሳ ቆፐካዝን ኤኬዛ። ናምእንꬃ ዣንዳርባይ ፍልጶሳ በኤካያ፥ ዝን ፋ ኦጋ ኡፋይትታር ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ፍልጶሳ አዛጾና ኦሌዛ። ማ ቅሳረ የኦድ ሄሎዳይስ ካታምታይር ዩዪ ዎንግለ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","የ ዎደ ሳኦላ ጎዳ ካልዝታ ዎꬎዳይስ ማንድታር ቄሰ ሀላቅታይኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ጎዳይ ኦገ ካልዛ ꬊራꬅታኔ ማችታ ደንግኮ፥ አጪ የሩሳላመ ኮኦዳይስ፥ ዳማስቆ የዝ አይሁደ ዎሳ ኬꬅታይስ ዳብዳበ ጻፍንቶዳይ ጋርክ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ኤ Ꮊንጊ፥ ዳማስቆ ካታማ ሄሎዳይስ ኡኮዳር፥ ቆፐካ ሳሎፕ ዎልቃማ ፖኦ ኤ ዩሻይር ፖኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ኤ ሳአ ፖኬዛዝን፥ «ሳኦላ፥ ሳኦላ፥ አብስ ታና ባይꬅኔ?» ግዝ ቃላ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳኦላ፥ «ጎዳዮ፥ ነ ኦኖ?» ዬጊ ኦይጬዝ። «ታኒ፥ ነ ባይእꬅዝ የሱሳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ጎዳይ ኤኮ፥ «ደንዲ ካታማ ገሎባ፤ ነ ኦꬆዳይስ ቤዝዛባዛይ ኤዛይድ ኔስ ኦድንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ሳኦላራ ኦገ Ꮊንግዝ አስታይ አኮካ ኦድንተካ ኤቂ አቴዛ። ጊርꬂ ስእንትዛ፥ ዝን ኦንካ በንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳኦላ ፖኬዝ አቃይፕ ደንዲ በአዳር ኤ ኣፋይ ደንጋም እጼዛ። የይ ግሾስ፥ ኡንቲ ኤ ኩሻ አይኪ ካልꬂ ዳማስቆ ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ሀይꬒ ጋላስ ሄሎዳይስ ኤ በአዳይስ ዳንዳኤካያ፤ አኮካ ሜካያ፤ ኡዠካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ዳማስቆ ፐቲ ሀናና ግዝ የሱሳ ታማራይ የዛ። ጎዳይ ቆንጭꬃር፥ «ሀናና» ዬጊ ጼጌዛ። ሀናኔ ማሂ፥ «ታ ጎዳዮ፥ ታ Ꮊይዳ የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ጎዳይ ኤኮ፥ «ደንዲ ሉሎ ግንትንትዝ ኦገ Ꮊንጊ፥ ይሁዳ ካራ ሳኦላ ግዝ ጸርሰሰፕ የኤዝ ዎስ ዎስዝ አꬃ ኮዮባ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ማ ሀናና ግንትዝ አꬃይ ገሊ፥ ሳኦላ ናምእንꬆ በአዳይ ጋርክ ፋ ኩሸ ኤዛል አፋ ጋዶዳር ቆንጭꬃር በኤዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ሀናና ማሂ፥ «ጎዳዮ፥ የሩሳላመ ነ ጌሽ አሳይል አፋ የ አꬃይ አብ ጋርክ ኢታ ባዝ ኦꬄዛኮ ታኒ ጋመ አሳይፕ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ማ ዳማስቆ ነ ሱንꬃ ጼግዝታ ኡባ አጮዳይስ፥ ቄሰ ሀላቅታይ ኤስ ማዉተ እንጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ዝን ጎዳይ ኤኮ፥ «ሳኦላ አይሁደ ማቀካ አሳይ ቲና፥ ካትታይ ቲናኔ እስሬለ አሳይ ቲና፥ ታ ሱንꬃ ኤርሶዳይስኔ ታስ ኦꬆዳይስ ማራጽንቴዝ ሚሻ ማቄዝ ግሾስ ነ ኤኮ Ꮊንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","አብስ ጊኮ፥ ታ ሱንꬃይ ግሾስ ኤ ዋፋ ዋየ ኤኮዳይስ ቤዝዛኮ ታኒ ኤዛ ቤዞዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ሀናኔ Ꮊንጊ፥ ካራ ገሊ፥ ፋ ኩሸ ሳኦላል አፋ ጋዲ፥ «ታ እሻ ሳኦላ፥ ነ የኤዝ ኦጋይል ኔስ በንቴዝ ጎዳ የሱሳ፥ ነ በአዳይ ጋርከኔ ጌሻ አያናር ኩሞዳይ ጋርክ ታና ኪቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ኤልሲ፥ ሳኦላ ኣፋይፕ ፐቲ ፑቆ ጋርከዝ ባዛይ ዎꬍን፥ ሳኦላ ናምእንꬆ በኤዛ። ማ ደንዲ ጻማቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ካꬃ ም ሚንጌዛ፥ ዳማስቆ የዝ አማንዝታይር ጽቃ ጋላስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ኤልሲ ሳኦላ፥ «የሱሳ ጾስ ናአ» ዬጊ ዳማስቆ የዝ አይሁደ ዎሳ ኬꬅታይድ ቃላ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","የያ ስኤዝ ኡባይ ማላባዝ ግ፥ «Ꮊይ የሩሳላመ የሱሳ ሱንꬃ ጼግዝታ ꬋብስዛ ባሳኔ? ማ Ꮊና የኤዛይ ኡንታን አጪ፥ ቄሰ ሀላቅታይ ቲና ካንጎዳይስ ባሳኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ዝን ሳኦላ ቃላ ኦዶር ምንግታር ምንግታር Ꮊንጌዛ። የሱሳ፥ ኤ ክርስቶሳ ማቄዛና ምልጽ ኡዲ ኦዴዝ ግሾስ ዳማስቆ የዝ አይሁድታይ ኤስ ማሆድባዝ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ጋመ ጋላሳፕ ጉየ አይሁድታይ ሺቂ፥ ሳኦላ ዎꬎዳይስ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ዝን አይሁድታይ ፋና ዎꬎዳይስ ቆፔዛ ሳኦላ ስኤዛ። ኡንቲ ኤዛ ዎꬎዳይስ ቃማኔ ጋላስ ካታማ ፐንገ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ዝን ኤ ታማርታይ ኤዛ ቃማ ካንጊ፥ ግምበ ጋሰ ሉኮር ዳቾራ ዎꬍሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳኦላ የሩሳላመ ሄሌዝ ዎደ አማንዝታይር ዋላክንቶዳይስ ኮዬዛ። ዝን ኤ ክርስቶሳ አማኔዛይ ኡንትስ ቱማ ኣዛም እጽን ኤስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ዝን ባርናባሳ ሳኦላ ሀዋርታይኮ ካንጌዝ። ኦገል ጎዳይ ዋይዚ ቆንጬዛኮኔ ናሼዛኮ፥ ማ ሳኦላ ዳማስቆ የሱሳ ሱንꬃይር ያሽተካ ዋይዚ ቃላ ኦዴዛኮ ኡንትስ ጌሺ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ሳኦላ የሩሳላመ ዉቲ ጎዳይ ሱንꬃይር ያሽተካ ቃላ ኦድታር፥ ሀዋርታይራ ዎላ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ማ ሳኦላ ግርኬ ቃላ ኦዴዝ አይሁድታይራ ኦድንትታር ፓላምዛ። ዝን ኡንቲ ኤዛ ዎꬎዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","አማንዛ አስታይ የያ ስኢ፥ ሳኦላ ቅሳረ ካንጊ ተርሰሰ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ይሁዳ፥ ጋልላራኔ ሳማረ ኡባይድ የዝ ዎሳ ኬꬅታይ ሳሮር የዜዛ። ማ ሚንጌዛ፤ ጎዳይስ Ꮊሽትታር ጌሻ አያና ምንꬃꬆር ጋንጊ ጋንጊ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጵጽሮሳ ጋደ ኡባ ዩይታር ሊዳ የዝ አማንዛ አስታይኮ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ኤዛይድ ሆስፑን ላይꬅ ሙዳ ስሊ አርሳል ዎይኢ የዝ ኤንያ ግዝ አꬃ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጵጽሮሳ፥ «ኤንያ፥ የሱስ ክርስቶሳ ነና ፓꬄዛ፤ ደንዲ ነ ሂጻ ደንꬆባ» ዬጌዛ። ኤካ ኤልሲ ደንዲ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ሊዳራኔ ሳሮና የዝ አስ ኡባይ ኤንያ ብኢ፥ ጎዳይኮ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ዮጰ ካታማ ፐቲ ጻብቶ ግንትዝ አማንዛ አስታ የዛ። (ጻብቶ ጉሳይ ገንኤ ጉሲ) እዛ ፋ የዛ ዎደ ኡባይድ ሎኦ ባዝ ኦꬅታራኔ ማንቅታ ማድታር የዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","የ ዎደ እዛ ሀርግንቲ Ꮊይቂን፥ አሳይ እ አሃ ሜጪ፥ ፖቄል አፋ ከሲ ዎይꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ሊዳ ዮጰስ ካለ የዛ። አማንዝታይ ጵጽሮሳ ሊዳ የዛ ስኢ፥ «ሀያና ኑኮ ኤልሲ የኦባ» ዬግዝ ኪታ ናምኢ አስታ ኤኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","የይ ግሾስ፥ ጵጽሮሳ ደንዲ፥ ኡንታራ Ꮊንጌዛ። ሄሊ፥ ፖቄል አፋ የዝ ክፍለ ኤዛ ገልሴዛ። አምእታይ ጵጽሮሳ ካላይር ኤቂ ዬክታር ዶርቃ ኡንታራ ፓጻ የዛር ኦꬄዝ ቃምስታኔ አፍልታ ኡባ ጵጽሮሳ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጵጽሮሳ ኡንታን ኡባ ባለ ከሲ፥ ጉልባቲ ጾሳ ዎሴዛ። ማ አሃይኮ ማቂ፥ «ጻብተ፥ ደንዶባ» ዬጌዛ። ጻብታ ፋ አፋ ዶዪ ጵጽሮሳ ብኢ፥ ደንዲ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ጵጽሮሳ እዞ ፋ ኩሸር ማዲ ደንꬅ ኤሴዛ። የይፕ ጉየ፥ አማንዝታኔ አምእታ ጼጊ፥ ደንዴዛኖ ኡ ቲና ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ꮊ ኦዳይ ዮጰ ካታማ ኡባ ሄሌዛ። ጋመ አሳይ ጎዳ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጵጽሮሳ ዮጰ ስሞና ግዝ ደገላይ ካራ ኡንደና ጋላስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቅሳረ፥ «ጻለ ኦላ አስታይ ጩጋ» ግንትንትዝ ኦላ አስታይ ጋንጨ ፐቲ ቆርነሎሳ ግንትንትዝ ማቶ ሀላቃይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ቆርነሎሳ ፋ ካራ አሳይራ ጾሳ ሚንꬂ አማንዛ አስኔ ጾሳ ጎይንዛ አስ። አይሁደ ማንቅታካ ጋመ ማድዛ፥ ማ ጾሳ ኡባ ዎደ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ፐቲ ጋላስ ኡዱፉን ሳተ ሄራ ጾስ ኪታንቻይ ኤኮ ይኢ፥ «ቆርነሎሳ» ግ ጼጎዳር ኤ ቆንጭꬃር ጌሺ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ቆርነሎሳ ዳጋሚ ኪታንቻ ቶል ኡዲ ብኢ፥ «ጎዳዮ፥ አባ?» ዬጌዛ። ኪታንቻይ ማሂ፥ «ነ ዎሳኔ ማንቅታ ነ ማድዛይ ጾስ ቲና ቆፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ꮊት ዮጰ አስ ኪቲ፥ ጵጽሮሳ ግዝ ስሞና ክእሶባ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ጵጽሮሳ አባ ካለር ደገላ ስሞና ካራ እማꬄትꬅ በቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ቆርነሎሳ ፓስ ኦዴዝ ኪታንቻይ Ꮊንግን፥ ፋ አይልታይፕ ናምእታኔ ጾስ ጎይንዛ ፋ ካለ ዎታዳርታይፕ ፐታ ጼጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ኡንትስ ኡባ ባዝ ኦዲ ዮጰ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ዎንትꬃ ጋላስ ኡንቲ Ꮊንጊ፥ ዮጰ ካታማ ኡኮዳር ኡሱፑን ሳተ ሄራ ጾስ ዎሶዳይስ ጵጽሮሳ ፖቄል አፋ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ኤ ናይንቲ ካꬅ ማዳይስ ኮዬዝ፥ ዝን ካꬃ ካጾዳር ኤ አሁሞ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ሳሎ ዶይንትን፥ ዳማ አፍላ ኣዝዛባዝ ኦይዲ ባጋር አይክንቲ ዎꬎዳር ኤ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ኤዛይድ ኦይዲ ቶከር የዝ መህታይ፥ ዎራ ዶእታ፥ ኡሎራ ጎችንትዛ መትꬃይኔ ሳሎ ካፍታ ኡባይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","የ ዎደ «ጵጽሮሳ፥ ደንዲ ኤቂ ሹኪ ሞባ» ግዝ ቃላ ኤኮ የኤዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ዝን ጵጽሮሳ፥ «ጎዳዮ፥ ዋኣ! ታ ቱና ባዝ ኡባራካ ም ኤሮያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ማ፥ «ጾሳይ ጌሼዛ ኔኒ ቱና ጊፐ» ግዝ ቃላ ናምእንꬆ ኤኮ የኤዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","የይካ፥ ሀይꬒ ቶኬ ሀኔዛይፕ ጉየ የ ግታ አፍላ ኣዝዛይ ኤልሲ ኡዴ ሳሎ ኤክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጵጽሮሳ ፋ በኤዝ ቆንጭꬃይስ ብልእꬃይ፥ «አብ ማቃደሻ?» ግ ፋ ዎዝናር ቆፖዳር፥ ቆርነሎሳ ኪቴዝ አስታይ ስሞና ካራ ኦይጭች ደንጊ ባለር ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ፋ ቃላ ኡ ꬎቅ ኡዲ፥ «ጵጽሮሳ ግንትዝ ስሞና እማꬃይ Ꮊይዳ የኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጵጽሮሳ ቆንጭꬃር በኤዝ ባዛ ቆፕꬃል አፋ የዝን፥ ጌሻ አያና ኤኮ፥ «ዬዛኮ፥ ሀይꬒ አስታይ ነና ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ደንዲ ዎꬎባ፥ ታኒ ኡንታን ኪቴዝ ግሾስ ሰኤካ ኡንታር Ꮊንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጵጽሮሳ አስታይኮ ዎꬊ፥ «ይ ኮይዛይ ታናኔ፤ ይ አብስ የኤኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ኡንቲ ማሂ፥ «ኑና ማቶ ሀላቃይ ቆርነሎሳ ኪቴዛ። ኤ ጌሻ፥ ጾሳ ጎይንዛ አስኔ አይሁደ አስ ኡባይድ ጋመ ቦንችንቴዝ አስ። ቆርነሎሳ፥ ነና ፋ ካራ ካንጊ ቃላ ኔፕ ስኦዳይ ጋርክ ጌሻ ኪታንቻይ ኤስ ኦዴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ጵጽሮሳ አስታ ካራ ገልሲ ሞኬዛ። ዎንትꬃ ጋላስ፥ ደንዲ ኡንታራ ቅቴዛ። ዮጰ ካታማ የዝ አማንዝታይፕ ፐታይ ፐታይ ኤዛር ዎላ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ዎንትꬃ ጋላስ፥ ቅሳረ ሄሌዛ። ቆርነሎሳ ፋ እግንታኔ ፋ ላግታ ፐትፕ ጼጊ ሺሺ፥ ጵጽሮሳ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጵጽሮሳ ካራ ገሎድ ሀኖዳር፥ ቆርነሎሳ ኤዛ ሄሊ ኤ ቲና ጹጉኒ ኤስ ጎይኖዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ዝን ጵጽሮሳ፥ «ደንዶባ፥ ታካ ታ ኦማስ ነ ጋርክ አስ» ዬጊ ኤዛ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ጵጽሮሳ ቆርነሎሳር ኦድንትታር ካራ ገሎዳር ጋማይ አሳይ ሺቄዛ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ኤ አሳይኮ፥ «አይሁደ አስ ሀራ ጋደር ፐትፖዳይስ ዎይ ዎል ሄሎዳይስ ዎጋ ባዛ ይ ኤርዛ። ዝን ታኒ ኦናካ ቱና ዎይ ጌሽ ባያ ጋማይ ጋርክ ጾስ ታና ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","የይ ግሾስ፥ ይ ታኮ ኪትን እጾ ባይꬅ የኤዛ። Ꮊት ታና አብስ ጼግሴዛኮ ታስ ኦዶይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርነሎሳ፥ «ታኒ Ꮊይኖ ኦይዲ ጋላሳፕ ቲና Ꮊኖንተ ኡዱፉን ሳተ ዎሳ ዎሶዳር፥ ፎጭዝ ማኦ ማኤዝ አስ ታ ቲና ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ኤ ታኮ፥ ‹ቆርነሎሳ፥ ጾሲ ነ ዎሳ ስኤዛ፥ ኔኒ ማንቅታ ማዴዛናካ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ይኬ፥ አስ ዮጰ ኪቲ፥ ስሞን ጵጽሮሳ ግዛ ጼግሶባ። ኤ፥ ስሞና ግዝ ደገላ አꬃይ ካራ አባ ዶናር በቴዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","የይ ግሾስ፥ ታኒ ኔኮ ኤልሲ ኪቴዛ፤ ነ ይእꬃይር ሎኦ ኦꬄዛ። ይኬ፥ ጾሲ ነና ኪቴዝባዝ ኡባ ስኦዳይስ Ꮊት ኑኒ ኡባይ Ꮊይዳ ጎዳይ ቲና የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ካልካ፥ ጵጽሮሳ፥ «ጾሲ አስ ኣፈ ብኢ አሳፕ አሰ ሻኮያ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ዝን ዱማ ዱማ ቢታ አስ ኡባ ኦና ማቅኮካ ፓስ ያሽትዛኔ ጽሎ ኦሶ ኦꬅዛይድ ጾሲ ኡፋይትዛ ታኒ ቱማ አካኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ጾሳይ፥ ኡባ ጎዳ ማቄዝ የሱስ ክርስቶሳ ባጋር ሳሮትꬅ ኦድታር Ꮊ ዎንግላ እስሬለ አሳይስ ኪቴዛ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዋንሳ ጽንቃተባጋ ሳባኬዛይፕ አይኪ ጋልላፕ አይኪ ይሁዳ ቢታ ኡባ ሄሎዳይስ ሀኔዝባዛ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ጾሲ ናዝረተ የሱሳና ጌሻ አያናር ትዤዛኔ ዎልቃ እንጌዛ። ጾሲ ኤዛር የዝ ግሾስ ሎኦ ባዝ ኦꬅታር ሀርግንቴዝታ ፓꬅታራኔ ጻላሄ ኩሸ ሃርንቴዝ ኡባ ከስታር ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«አይሁደ ቢታኔ የሩሳላመ ኤ ኦꬄዝ ኡባ ባዛይስ ኑኒ ማርክታ። ኡንቲ ማዝቃለል አፋ ሶቲ ኤዛ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ዝን ጾሲ ሃይꬒንꬃ ጋላስ Ꮊይቆፕ ኤዛ ደንꬂ አሳይስ በንቶዳይ ጋርክ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","የ በንትꬃይ ጾስ ቲና ማራጼዝ ኤስ ማርካ ማቄዝ ኑስ ማርካትዛፕ አትን አስ ኡባይስ ባያ። ኤ Ꮊይቆፕ ደንዴዛይፕ ጉየ ኑር ሜዛኔ ኡዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ኑኒ ዎንግለ አሳይስ ኦዶዳይ ጋርከኔ ፓጻ የዝታይል አፋኔ Ꮊይቄዝታይል አፋ ፕርዶዳይስ ጾሲ ሹሜዛይ የሱሳ ማቄዛና ማርካቶዳይ ጋርክ ኑና ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ጾስ አማንዛ ኡባይ ናጋራይ፥ ኤ ሱንꬃይር አቶ ግንትንትዛ ናብታይ ማርካትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጵጽሮሳ ሀጋ ኦዳ ሃሰካዝን ቃላ ስኦዳር ኡባይል አፋ ጌሻ አያና ጎጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጵጽሮሳር ዮጰፕ የኤዝ አማንዛ ዶካልንቴዝ አይሁደ ኡባይ፥ አይሁደ ባዝታይላካ ጌሻ ሻያና ጎጌዝ ግሾስ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","የያ ጎዳይስ ዳንዳኤዛ፥ ኡንቲ ዱማ ዱማ ዶናር ናሽታራኔ ጾሳ ጋላቶዳር ስኤዝ ግሾስ። የ ዎደ ጵጽሮሳ ማሂ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«የይትታይ ማ ኑ ጋርክ ጌሻ አያና ኤኬዝታይ ሃꬃር ጻማቅንታማይ ጋርክ ካዮዳይስ ዳንዳእዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ኡንቲ የሱስ ክርስቶሳ ሱንꬃይር ጻማቅንቶዳይ ጋርክ ኡንታን አዛዜዛ። የይፕ ጉየ፥ ኡንቲ ፓር ጽቃ ጋላስ በቶዳይ ጋርክ ጵጽሮሳና ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ሀዋርታይኔ ይሁዳ የዝ አማንዝታይ፥ አይሁደ ባዝታይካ ጾሳ ቃላ ኤኬዛ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጵጽሮሳ የሩሳላመ Ꮊንጌዝ ዎደ ዶካልንቴዝ አማንዝታይ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ኤኮ፥ «ኔኒ ዶካልንተካዝትይኮ ገሊ ኡንታራ ካꬃ አብስ ሜኔ?» ዬጊ ፋላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ዝን ጵጽሮሳ ሀኔዝባዝ ቲናፕ አይኪ ማራር ኦዴዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«ታኒ ዮጰ ካታማ ጾስ ዎስታር አጁታ በኤዛ። ዳማ አፍላ ኣዝዛባዝ ኦይዲ ባጋር አይክንቲ ሳሎፕ ዎꬍታር ታኮ የኤዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ታኒ ዳኪ በአዳር ኦይዲ ቶከር የዝ መህታ፥ ዎራ ዶእታ፥ ኡሎራ ጎችንትዛ መትꬅታኔ ሳሎ ካፍታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹ጵጽሮሳ፥ ደንዶባ፥ ሹኪ ሞባ› ግዝ ቃላ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«ዝን ታኒ፥ ‹ጎዳዮ፥ ዋኣ፥ ቱና ባዝ ዎይ ጌዠካባዝ ኡባራካ ታ ዶናኮ ሄሊ ኤሮያ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«‹ጾሳይ ጌሼዛ ኔኒ ቱና ጊፐ› ዬግዝ ቃላ ናምእንꬆ ሳሎፕ የኤዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«የይ ሀይꬒ ቶኬ ሀኔዛ፥ ማሂ ኡባይ ሳሎ ፉድ ኤክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","የ ሳታተካ ሀይꬒ አስታይ ቅሳረፕ ታኮ ኪትንቲ ታኒ የዝ ካራ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ስካዛር ኡንታራ Ꮊማዳይ ጋርክ አያና ታስ ኦዴዛ። ማ Ꮊ ኡሱፑን እሽታይ ዮጰፕ ታራ ቅሳረ Ꮊንጌዝታይር ቆርነሎሳ ካራ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ኪታንቻይ ኤ ካራ ጋንጨ ኤቂ፥ ‹ዮጰ ኪቲ ጵጽሮሳ ግንትንትዝ ስሞና ጼግሶባ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ነናኔ ነ ካራ አስ ኡባ አሽዛ ቃላ ኤ ኔስ ኦዶዳ› ጌዛና ቆርነሎሳ ኑስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«ታኒ ናሻ አይኮዳር ጌሻ አያና ቲን ኑል አፋ ዎꬌዛይ ጋርክ ኡንታል አፋካ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","የ ዎደ ‹ዋንሳ ሃꬃር ጻማቄዝ፥ ዝን ይ ጌሻ አያናር ጻማቅንቶዳ› ዬጌዝ ጎዳ ቃላይ ታስ ቆፕንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ጾሳይ ኑስ ጎዳ የሱስ ክርስቶሳ አማኔዝታይስ እንጌዝ እሞታ እዞ አይሁደ ባዝታይስካ እንግኮ፥ የዝን ጾሳ ካዮዳይስ ታኒ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ኡንቲ የያ ስኤዝ ዎደ ፋ ፓላማ አሺ፥ «የያ ማቅኮ፥ ጾሳይ አይሁደ ባዝታይካ ናጋራፕ ማቂ ደኦ የዞዳይ ጋርክ ማሮተꬅ እንጌዛ» ዬጊ ጾስ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","እስጸፋኖሳና Ꮊይቆስ ሄልꬄዝ ባይእꬃይፕ ደንዴዛይድ ላልንቴዝ አማንዝታይ ቃላ አይሁድታይ ኣዳስ ኦድታር ፕንቀ፥ ቆጲሮሳኔ አንጾካ ሄሎዳይስ ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ዝን ቆጲሮሳፐኔ ቀረናፕ የኤዝ ፐቲ ፐቲ አማንዛ አስታይ አንጾካ Ꮊንጊ፥ ጎዳ የሱሳ ዎንግለ ግርኬ አሳይስካ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ጎዳ ዎልቃይ ኡንታራ የዛ፤ ማ ጋመ አሳይ አማኒ ጎዳይኮ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","የ ኦዳ የሩሳላመ የዝ ዎሳ ኬꬃይ ስኤዝ ግሾስ ባርናባሳና አንጾካ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ባርናባሳ አንጾካ Ꮊንጌዝ ዎደ ጾሲ ፋ ኣꬎ ኬሄትꬃይፕ ፋ ዎያይስ ዋይዚ እንጌዛኮ ብኢ ኡፋይቴዛ። ኡንቲ ኡባይ ፋ ኩንꬅ ዎዝናር ጎዳይል ሚንጊ የዞዳይ ጋርክ ኡንታን ዞሬዛይ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ባርናባሳ ጌሻ አያናራኔ አማኖር ኩሜዝ ኬሃ አስ ማቄዝ ግሾሲ። ጋመ አሳይካ ጎዳ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","የይፕ ጉየ፥ ባርናባሳ ሳኦላ ኮዮዳይስ ጸርሴሰ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ኤዛይድ ሳኦላ ደንጊ አንጾካ ኤኪ የኤዛ። ባርናባሳኔ ሳኦላ ዎሳ ኬꬃ አሳይራ ላይꬅ ሙዳ በቲ ጋመ አሳ ታማርሴዛ። አማንዝታይ አንጾካ «ክርስታነ» ግንትንቲ ቲና ጼግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","የ ዎደ ፐቲ ፐቲ ናብታይ የሩሳላመፕ አንጾካ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ኡ ጋንጨፕ አጋቦሳ ግዛይ ደንዲ ጋደ ኡባይል ኢታ ናየ ደንዶዳና አያና ዎልቃር ትንቢተ ኦዴዛ። የይ ሀኔዛይ ኦሮመ ካታይ ቃላዉዶሳ ዎዳይዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","አማንዝታይ ኦማር ኦማር ፋ ዎልቃ ጋርክ ሚሸ ከሲ ይሁዳ የዝ አማንዝታይስ ማዴ ዳኮዳይስ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ኡንቲ የይ ጋርክ ኡዲ፥ ሚሻ ባርናባሳላኔ ሳኦላል ዎሳ ኬꬅ ጭምታይስ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","የ ዎደ ካታይ ሄሮዶሳ ዎሳ ኬꬅ አሳይፕ ባጋ ባይእꬅ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ዋንሳ እሻ ያይቆባ ማሻር ዎꬍሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","የይ አይሁድታ ኡፋይሴዛና ብኢ፥ ጉጂ ጵጽሮሳካ አይስሴዛ። የይ ሀኔዛይ ቦራ ባለ ቦንችዛ ጋላስታይዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ጵጽሮሳና አይኪ አጬዛ። ፓዝቃ ቦንችዛ ጋላስታይፕ ጉየ ዎያ ቲና ኤዛ ከሶዳይስ ቆፒ፥ ኦይዲ ኦይዲ ዎታዳርታይ ኦይዲ አቆ ናግዝታይ ኤዛ ናጎዳይ ጋርክ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","የይ ግሾስ፥ ጵጽሮሳ አች ካራ ናግንትዛ። ዝን ዎሳ ኬꬅ አሳይ ኤስ ሚንꬂ ጾስ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮዶሳ ጵጽሮሳና ዎያ ቲና ሺሾዳይፕ ቲና ቃማ ጵጽሮሳ ናምኢ ባጋር ናምኢ ዎታዳርታይ ጋንጨ ሳንꬃላተር አጭንቲ ገንቴዛ። ናግዝታይ አች ካራይ ፐንግታይድ ኤቂ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ቆፐካዝን ጎዳ ኪታንቻይ ቆንጬዛ። አች ካራይድ ፖኦ ፖኤዛ። ኪታንቻይ ጵጽሮሳ ምያ ቦቺ ባርክꬂ «ኤለ ደንዶባ» ዬጌዛ። እዝራካ ሳንꬃላታይ ኤ ኩሻይፕ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ኪታንቻይ ኤኮ፥ «ነ ማአ ማኦባ፥ ነ ጫማካ ኣꬆባ» ዬጌዛ። ጵጽሮሳ የይ ጋርክ ኦꬄዛ፤ ኪታንቻይ፥ «ነ አፋር ማእዝ ማአ ማኢ ታና ካሎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ጵጽሮሳ አች ካራፕ ከዚ ኪታንቻ ካሌዛ። ኤስ አሁሞ ብእዛይ ጋርክ ኣዝዛፕ አትን ኪታንቻይ ኦꬅዛባዛይ ቱማ ኣዘካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ኪታንቻይራኔ ጵጽሮሳራ ቲናሳኔ ናምእንꬆ ዎታዳራ ኣꬊ ካታማ ካንግዛ ብራታ ፐንጋይኮ ሄሌዛ። ፐንጋይካ ኡንትስ ፋ ኣዳስ ዶይንቴዛ። ኡንቲ ከዚ ፐቲ ሁሳ ኦገል ከዘዛን ጋርክ ቆፐካዝን ኪታንቻይ ጵጽሮሳፕ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጵጽሮሳስ ዎዝናይ ማቅን፥ «ታ ጎዳይ ፋ ኪታንቻ ኪቲ፥ ሄሮዶሳ ኩሸፐኔ ናጊ በቴዝ አይሁደ አስ ኡባይፕ አሼዛና Ꮊት ቱማ ታ ኤሬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ኤ የያ አካኬዝ ዎደ ጋመ አሳይ ፐትፕ ሺቂ ጾሳ ዎስዛ አቃ፥ ማርቆሳ ግዝ ዋንሳ እንዳት ማይራሚ ካራ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ኤዛይድ ባለር ኤቂ ጼጌዛ። ፐቲ ሮዳ ግዝ ኦሶ አስታ ፐንጋ ኤስ ዶዮዳይስ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ሮዳ ጵጽሮሳ ቃላ ማቄዛና ኤሪ ኡፋይሳር ኩሚ ጋዛራ ዶዮዳ አሺ ጉየ ዎጺ Ꮊንጊ፥ «ጵጽሮሳ ባለ ኤቄዛ» ዬጊ አሳይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","አሳይ ኢኮ፥ «ኔኒ ኤይኔ!» ዬጌዛ። ሮዳ ጵጽሮሳ ማቄዛ ጌሺ ኦዴዛ። ኡንቲ፥ «የይ ኤ ኪታንቻ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ዝን ጵጽሮሳ ባለር ኤቂ ጼስ አሻም እጽን አሳይ ጋዛራ ዶዪ ኤዛ ብኢ ማላባዝ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ዝን ኡንቲ ስእ ጎዳይ ጋርክ ጵጽሮሳ ፋ ኩሻይር ማሊ ጎዳይ አች ኬꬃይፕ ኤዛ ዋይዚ ከሴዛኮ ኡንትስ ቆንጭሲ ኦዲ፥ «Ꮊያ ያይቆባስኔ አማንዛ አሳይስ ኦዶይታ» ግ ኤዛይፕ ከዚ ሀራ አቆ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ሳአ ዎንቶዳር «ጵጽሮሳ አና ቅቴኔ» ግ ዎታዳርታይ ዎል ጋንጬ ጋመ ዋላሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮዶሳ ጵጽሮሳ ኮይን በንተካዛይ ግሾስ ናግዝታ ቁሪ፥ ኡንታን ዎꬎዳይ ጋርክ አዛዜዛ። የይፕ ጉየ፥ ሄሮዶሳ ይሁዳፕ ቅሳረ ዎꬊ ኤዛይድ ጽቃ ዎደ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮዶሳ ጽሮሳ አሳይራኔ ስዶና አሳይር ዎላ ሞርከ። ኡንቲ ቢታይ ካꬃ ሄሮዶሳ ቢታፕ ደንግዛ ግሾስ ኡንቲ ፐትፕ ማቂ ኤ ዣንዳርባ ብላስጾሳ ፓስ ጭማ ኡዲ ዳቦቶዳይስ ሄሮዶሳኮ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ሄሮዶሳ ሱንꬄዝ ጋላስ ፋ ካተትꬅ አፍላ ማኢ፥ ዙፋናይል አፋ በቲ አሳይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","አሳይ፥ «የይ ጾስ ቃላ፥ አስ ቃላ ባያ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ሄሮዶሳ ጾሳ ቦንቼካ ግሾስ እዝራ ጎዳ ኪታንቻይ ኤዛ ሾጭን ጉጽነር ምንትንቲ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ዝን ጾስ ቃላይ ድጭታራኔ ዳልግታር ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ባርናባሳኔ ሳኦላ ፋ ኦሳ ፖሊ ማርቆሳ ግዝ ዋንሳ ፓር ኤኪ የሩሳላመፕ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","አንጾካ የዝ ዎሳ ኬꬃ ናብታይኔ አስታማርታይ የዛ። ኡንቲ ባርናባሳ፥ ካርꬅ ግንትንትዝ ስሞና፥ ቀረናፕ የኤዝ ሉኮሳ፥ ካታይ ሄሮድሳራ ድጬዝ ምናሄኔ ሳኦላ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ኡንቲ ጎዳ ጎይንታራኔ ጾምታራኔ ጌሻ አያናይ፥ «ታኒ ጼጌዝ ኦሳይስ ባርናባሳኔ ሳኦላ ታስ ሻጎይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","የይ ግሾስ፥ ኡንቲ ጾሜዛፐኔ ዎሴዛይፕ ጉየ ፋ ኩሻ ኡንታል አፋ ጋዲ ዎሲ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","የይ ግሾስ፥ ጌሻ አያና ኡንታና ኪቴዛ። ሰለዉቀ Ꮊንጌዛ፤ ኤዛይፕ ማርካበ ገሊ ቆጲሮሳ ሃꬃር ተቅንቴዝ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ኡንቲ ስልማና ሄሊ አይሁደ ዎሳ ኬꬅታይድ ጾስ ቃላ ኦዴዛ። ዋንሳ ማድታር ኡንታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ኡንቲ ቆጲሮሳ ሃꬃር ተቅንቴዝ ቢታ ካንꬂ ጳፉ ሄልዛ ዎደ ፐቲ ዎርዶ ናበ ባር-የሱሳ ግዝ አይሁደ አምታ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","አቅስዝ ሳርጎሳ ጳዉሎሳ ግዝ ዎዛናማ አꬃይራ የዛ። ሳርጎሳ ጳዉሎሳ ባርናባሳነ ሳኦላ ፋኮ ጼጊ ጾስ ቃላ ስኦዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ዝን ግርኬ ዶናር አምታይ ሱንꬃይ «ኤልማሳ» ብልꬃይ ጋደ ሃርዛይ አማናማይ ጋርክ ካዮዳይስ ኮዪ ባርናባሳራኔ ጳዉሎሳር ኤቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ዝን ጳዉሎሳ ግዝ ሳኦላ ጌሻ አያናር ኩሚ አምታና ዳኪ ብኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«ናት፥ ጻላሄ ናአዮ፥ ኢታትꬅ ኡባይ ኩሜዛዮ፥ ጽሎትꬅ ኡባይስ ሞርካዮ፥ ሉለ ጎዳ ኦጋ ምርቅዛ አሻሞ? ");
INSERT INTO mfxe_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ዬዛኮ፥ Ꮊት ጎዳይ ካች ኩሻይ ኔል አፋ የዛ። ኔኒ ቆቀ ማቆዳ፤ ጽቃ ዎደስ አዋ ፖኦ በአሚ» ዬጌዛ። እዝር ጫጋናኔ ꬉማ ኤ አፋ ጎዝን፥ ፋ ኩሻ አይኪ ካልꬅዛ አስ ኮይታር ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ጋደ ሃርዛይ የያ በኤዝ ዎደ ጎዳባዝ ታማርስዛይድ ማላባዝ ግ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ጳዉሎሳኔ ኤዛር የዝታይ ጳፉፕ ደንዲ፥ ጵንፍላ የዝ ጰርገ ማርካበር Ꮊንጌዛ። ዋንሳ ኡንታፕ ሻክንቲ የሩሳላመ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ዝን ኡንቲ ጰርገፕ ኣꬊ ጵስዳ የዝ አንጾካ ሄሌዛ። ማላ ጋላስ ጋላስ አይሁደ ዎሳ ኬꬅ ገሊ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሙሰ ህጋይድ ናብታይ ማጻፋይ ናባብንቴዛይፕ ጉየ አይሁደ ዎሳ ኬꬅ ሀላቅታይ፥ «ኑ እሹንꬆ፥ አስ ምንꬃꬅዛ ቃላ ይንትስ የዛኮ አሳይስ ኦዶይተ» ዬጊ ኡንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ጳዉሎሳ ደንዲ ኤቂ ፋ ኩሸር ማሊ፥ «እስሬለ አስታኔ፥ ጾሳ ጎይንዛ አይሁደ ማቀካ አሳዮ፥ ስኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ꮊ እስሬለ አሳ ጾሳይ፥ ኑ ማይዝታ ዶሬዛ። ግብጸ ቢታ እማꬃትꬃር ኡንቲ የዝን፥ ኡንታን ጋንꬂ ፋ ግታ ዎልቃር ግብጸ ቢታፕ ከሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ሊዦ ቢታ ኦይታም ላይꬅ ማቆዳ ኡንታን ዳንዳኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ካንአነ ቢታ አይሁደ ማቀካ ላፑን ካተትꬅታ ሃሲ ኡ ቢታ ፋ አሳ ላትሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","የይ ኡባይ ኦይዲ ጼታኔ እሻታም ማቃድ ላይꬅ ጋንጨ ሀኔዛ። የይፕ ጉየ ናበ ሳምኤላ ዎደ ሄሎዳይስ ዳይንታይ አቅሶዳይ ጋርክ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«የይፕ ጉየ፥ ኡንቲ ፓስ ካት እንጎዳይ ጋርክ ዎስን፥ ጾሲ ቢናመ ሼሻይፕ ቂሰ ናአ፥ ሳኦላ ኦይታም ላይꬅ ካዉቶዳይ ጋርክ ኡንትስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ጾሳይ ሳኦላ ሻሬዛይፕ ጉየ ኡንታል አፋ ዳዉተ ካዉትሴዛ። ጾሳይ ዳዉተ ባጋ ማርካትታር፥ ‹ታኒ ታ ሸነ ኡባ ኦꬅዝ ታ ዎዝና ማቄዝ ኢሳየ ናአ ዳዉተ ደንጌዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«ጾሳይ፥ ‹ታኒ ዳዉተ ሼሻይፕ እስሬለ አሽዛ ኮኦዳ› ግ ቃላ ገሌዛይ ጋርክ የሱሳና ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","የሱሳ የኦዳይፕ ቲና እስሬለ አስ ኡባይ ፋ ናጋራይፕ ማቂ ጻማቅንቶዳይ ጋርክ ዋንሳ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ማ ዋንሳ ፋ ኦሳ ዉርሶድ ሀንታር አሳይኮ፥ ‹ታና ይ ኦና ግ ቆፔ? ታኒ ይ ናግዛ ክርስቶሳ ባያ፥ ዝን ታኒ ኤ ጫማ ብሎዳይስ ታስ ቤዞዋዛይ ታፕ ጉየር ይእዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«ኑ ኢሹንꬆ፥ አፍራመ ሼሹንꬆ፥ ማ Ꮊይዳ አይሁደ ባዝን ጾስስ ያሽትዝታዮ፥ Ꮊ አቶትꬃ ቃላይ ኑስ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","አብስ ጊኮ፥ የሩሳላመ የዝ አሳይኔ ኡ ሀላቅታይ የሱሳና ኤረካያ። ማላ ጋላስ ኡባይድ ናባብንትዛ ናብታይ ቃላ አካኬካ ግሾስ ኤዛል አፋ ፕርዲ ናብታይ ኦዴዝ ቃላ ፖሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","የሱሳ ዎꬍሶዳይስ ፐቲ ሳንከካ ꬋብን ጵላጾሳ ኤዛ ዎꬎዳይ ጋርክ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ኡንቲ የሱሳባዝ ጌሻ ማጻፋይድ ጻፍንቴዝባዝ ኡባ ፖሌዝ ዎደ ማዝቃለፕ ኤዛ ዎꬍሲ ሞጌዛ ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ዝን ጾሳይ Ꮊይቆፕ የሱሳ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","የይፕ ጉየ፥ ኤ ፓር ጋልላፕ የሩሳላመ የኤዝታይስ ኡንደና ጋላስ በንቴዛ። ኡንቲ Ꮊት ኤባዝ አሳይስ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«ጾሲ ኑ አድታይስ እማድ ጌዝ ዎንግለ ኑኒ ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ዳዉተ ፋ ማዝሙረ ማጻፋይድ ናምእንꬆ ሸምፓይድ፥ « ‹ኔኒ፥ ታ ናአ፥ ታኒ Ꮊይኖ ነና የሌዛ› ጊንትንቴዛይ ጻፍንቴዛ የሱሳ፥ ጾሲ Ꮊይቆፕ ደንꬂ ኑ ማይዝታይስ እንጎድ ጌዛ ኑስ ኡ ናእታይስ ፖሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ኤ ዎቃማይ ጋርክ ጾሳይ Ꮊይቆፕ ኤዛ ደንꬆር ኤርሶዳይስ፥ « ‹ታኒ ዳዉተስ እንጎድ ጌዝ አማንንቴዝ ጌሽ አንጆ ይንትስ እንጎዳ› ዬጊ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","የይ ግሾስ፥ ማዝሙረ ማጻፋይድ ሀራ አቆ ማ ‹ነ ጽላይ አሃ ዎቅሳሚ ዬግዛ።› ");
INSERT INTO mfxe_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«ዳዉተ ፋ ዎደ ጾሳ ቆፋ ፖሌዛይፕ ጉየ Ꮊይቂ ፋ አድታይር ሞግንቲ ዎቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ዝን ጾሳይ Ꮊይቆፕ ደንꬄዛይ ዎቀካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«የይ ግሾስ፥ ታ እሹንꬆ፥ ናጋራ አቶትꬃይ የሱሳ ባጋር ቲናቲ ይንትስ ኦድንቴዛ ኤሮይታ። ሙሰ ህጋይ ናጋራፕ ጽልሶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ዝን የሱሳ አማንዛ ኡባይ ናጋራፕ ጽልዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","የይ ግሾስ፥ ናብታይ ጌዛይ ይንታል አፋ ሄላማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","« ‹ጾሳይ ጌዝባዝ ሌቅስዙንꬆ! ቦኦይታ! ማላባዝ ጎይታ! ꬋቦይታ! ኦንካ ኦድን፥ ይ አማኖዋ ኦሳ ታኒ ይ ዎደ ኦꬆዳ› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ጳዉሎሳኔ ባርናባሳ አይሁደ ዎሳ ኬꬃፕ ከሳዳር፥ ካልዛ ማላ ጋላሳይድ የያ ጉጂ ኦዶዳይ ጋርክ አሳይ ኡንታን ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ሺቆ ላልንቴዛይፕ ጉየ ጋመ አይሁድታይኔ አይሁድታይ አማናይድ ገሊ ጾሳ ጎይንዛ ጋምታይ ጳዉሎሳኔ ባርናባሳ ካሌዛ። አማኔዝታይ ጾስ ኣꬎ ኬሃትꬃይድ ሚንጊ የዞዳይ ጋርክ ኡንታን ዞሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ካልዛ ማላ ጋላስ ካታማ የዝ አሳይፕ ኦንክ አተካ ጎድ ሄሎዳይ ጋምታይ ጾስ ቃላ ስኦዳይስ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ዝን አይሁድታይ ጋመ አሳ በኤዝ ዎደ ጳዉሎሳ ቅናቲ ኤ ናሻ እጺ ኤዛ ጫዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ጳዉሎሳኔ ባርናባሳ ያሽተካያ፥ «ጾሳ ቃላይ ቲናቲ ይንትስ ኦድንቶዳይስ ኮሽዛ። ዝን ይ ቃላ እጺ መꬍና ደኦ ኤኮዳይስ ኑስ ቤዞያ ግ ይ፥ ይ ኦማስ ፕርዴዝ ግሾስ ይኬ ኑኒ አይሁደ ባዝታይኮ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","የይካ ጎዳይ፥ « ‹አላመ ኩንꬃይ ነ ባጋር አቶዳይ ጋርክ፥ ታኒ ነና አይሁደ ባ ዎያስ ፖኦ ኦꬄዛ ዬጊ ኑና ኪቴዛ› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","አይሁደ ባዝታይ የያ ስኢ ኡፋይቲ ጾስ ቃላ ቦንቼዛ። ማ መꬍና ደኦስ ማራጽንቴዝ ኡባይ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ጎዳ ቃላይ የ ጋደ ኡባ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ዝን አይሁድታይ፥ አይሁደ ባዛር ጾሰ ጎይንዛ ቦንችንቴዝ ማችታኔ ካታማ የዝ ግታ አስታ ጳዉሎሳል አፋኔ ባርናባሳል አፋ ደንꬅꬄዛ። የ አስታይ ኡንታን ባይእꬅ አይኪ ፋ ቢታፕ ከሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ዝን ጳዉሎሳራኔ ባርናባሳራ እጽዝታይስ ማላ ማቆዳይ ጋርክ ፋ ቶኬ ቡልአ ትቅሲ ኢቆኖኔ ካታማ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ማ አንጾካ የዝ አማንዝታይ ጌሻ አያናራኔ ኡፋይሳር ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ካሴሳይ ጋርክ፥ ጳዉሎሳኔ ባርናባሳ ኢቆኖነ አይሁድታይ ዎሳ ኬꬅ ገሊ ጋመ አይሁድታይኔ አይሁደ ባዝታይ አማኖድ ሄሎዳይስ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ዝን አማነካ አይሁድታይ፥ አይሁደ ባዝታይ ዎዛና ላሚ እሽታይል አፋ ደንꬅꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ሀዋርታይ ኤዛይድ ጋመ ዎደ ጋምኤዛ። ኡንቲ ያሽተካ ጎዳይ ባጋ ኦዴዛ። ጎዳይ ማላትታኔ ኦርꬃባዝ ኡንቲ ኦꬆዳይ ጋርክ ኡንትስ ማዉተ እንጊ ፋ ኣꬎ ኬሄትꬅ ቃላይ ቱማ ማቄዛና ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ዝን የ ካታማ አሳይ ሻክንቲ፥ ባጋይ አይሁድታይር ባጋይ ማ ሀዋርታይር ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","አይሁደ ባዝታይኔ አይሁድታይ ፋ ሀላቅታይር ዎላ ማቂ ሀዋርታ ቆሆዳይስኔ ሹቻር ሾጮዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ሀዋርታይ የያ ኤሪ፥ ልስጽራኔ ደርበ ግዝ ልቃኦነ ካታምታኔ ኡ ሄራ የዝ ቢታ ቆስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ኤዛይድ ዎንግለ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","የልንቴዛይፕ አይኪ ናምእ ቶክታይ ስሌዝ የꬊ ኤሮዋ ፐቲ አꬃይ ልስጽራ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","የ አꬃይ ጳዉሎሳ ኦዶዳር በቲ ስእዛዝን። ጳዉሎሳ ኤዛ ዳኪ በአዳር ፓጾዳይስ ኤስ አማኖ የዛ ብኢ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ፋ ቃላ ꬎቅ ኡዲ፥ «ስት ግ ነ ቶካይር ኤቆባ» ዬጌዛ። የዝን፥ ፑꬁክ ግ ደንዲ ኤቂ የꬅ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ጳዉሎሳ ኦꬄዛ አሳይ ብኢ ኡ ፋ ቃላ ꬎቅ ኡዲ ልቃኦነ ዶናር፥ «ጾስታይ አስ ኣዚ ኑኮ ዎꬌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ባርናባሳና፥ «ድያ» ግ፥ ጳዉሎሳ Ꮊይዳ ኦዳር ኤርንቴዛያ ማቄዝ ግሾስ ኤዛ፥ «ሄርሜሳ» ግ ሱንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ካታማይፕ ጋጻ የዝ ድያ ግዝ ኤቃ ካራ ካህናይ ኮርምታኔ ፉ ዶስታ ሀዋርታይስ ያርሾዳይስ ከዚ ካታማ ጋጻ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ዝን ባርናባሳኔ ጳዉሎሳ የያ ስኢ ፋ ማአ ፔꬌዛ። አሳይ ጋንጨ ዎጺ ገሊ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ፋ ቃላ ꬎቅ ኡዲ፥ «አሳዮ፥ Ꮊያ አብስ ኦꬄ? ኑንካ ይ ጋርክ አሰ። Ꮊ ፓꬆዋባዛይፕ ሳሎኔ ሳአ፥ አባኔ ኡ ጋንጨ የዝ ኡባ ባዝ መꬌዝ ደኦ ጾሳይኮ ይ ማቆዳይ ጋርክ ይንትስ ኑኒ ዎንግለ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ኤ ብኒ አሳይ ፋ ኦገ ፋ ኦገ Ꮊማዳይ ጋርክ ዳኪ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ዝን እራ ሳሎፕ ቡክሴዛ፥ ካꬃካ ዎደር ዎደር እንጌዝ፥ ካꬅ እንጊ ይንታን ጋመ ኡፋይሴዛ፥ ዬዚ ይንትስ ሎኦ ባዝ ኡዲ ፓስ ማርካ ꬋብሰካ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ሀዋርታይ የያ ግ ፓስ አሳይ ያርሻማይ ጋርክ ዋየር ካይሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","አንጾካፐኔ ኢቆኖነፐ የኤዝ አይሁድታይ፥ አሳ ፋ ባጋ ማሂ ሹቻር ጳዉሎሳ ጫዴዛ። ኡንትስ ኤ Ꮊይቄዝባዝ ኣዝን ካታማፕ ጋጻ ጎቺ ካንጊ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ዝን አማንዝታ ይኢ፥ ኤ ዩሻይድ ጋልቺ ኤቄዛዝን ኤ ደንዲ ካታማ ገሌዛ። ዎንትꬃ ጋላስ ባርናባሳር ፐትፕ ደርበ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ኡንቲ ደርበ ካታማ ዎንግለ ኦዲ ጋምታ አማንꬄዛይፕ ጉየ ልስጽራ፥ ኢቆኖነኔ ጵስዳ አንጾካ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","የ ካታምታይድ የዝ አማንዝታ ምህꬅታራ ኡንቲ አማኖር ምንጎድ ጋርክ ዞርታር፥ «ጾሳ ካተትꬃ ገሎዳይስ ኑኒ ጋመ ዋየ ኤኮዳይስ ቤዝዛ» ዬጊ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ማ ዎሳ ኬꬅታይስ ኦማስ ኦማስ ጭምታ ዶሬዛ። ጾሜዛይፐኔ ዎሴዛይፕ ጉየ ኡንቲ አማኔዝ ጎዳይስ ኡ ሀዳራ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ጵስዳ ቢታ ካንꬂ ኣꬊ ጵንፍለ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ጰርገ ቃላ ኦዴዛይፕ ጉየ አጻላ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","የይፕ ኡንቲ ፋ ፖሌዝ ኦሳይስ ጾስ ኣꬎ ኬሃትꬃይስ ኡንታን ሀዳራ እንጌዝ አንጾካ ማርካበር ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","አንጾካ ሄሊ ዎሳ ኬꬅ አሳ ሺሺ ጾሳይ ኡንታራ ኦꬄዝ ኦሳ ኡባይኔ አይሁደ ማቀካ አሳይ አማኖዳይ ጋርክ ኡንትስ ዋይዚ ኦገ ዶዬዛኮ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ኤዛይድ አማንዝታይር ጋመ ዎደ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ፐቲ ፐቲ አሳይ ይሁዳፕ አንጾካ Ꮊንጊ፥ «ሙሰ ዎጋይ ጋርክ ይ ዶካልንታም እጽኮ አቶዳይስ ዳንዳኦያ» ግ አማንዝታ ታማርሶ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","የይ ጳዉሎሳኔ ባርናባሳ ኡንታር ጋመ ፓላሞዳይ ጋርከኔ ዋጮዳይ ጋርክ ኦꬄዛ። የይ ግሾስ፥ አንጾካ የዝ ፐቲ ፐቲ አሳይ ጳዉሎሳራኔ ባርናባሳራ የሩሳላመ Ꮊንጊ ሀዋርታይራኔ ጭምታይር ዎል ሄሊ የ ኦዳ ብሎዳይ ጋርክ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ዎሳ ኬꬃይ ኡንታን ኪትን Ꮊንጌዛ። ኡንቲ ፍንቀ ሳማረራ ኣꬊታር አይሁደ ባዝታይ ጾስኮ ዋይዚ ማቄዛኮ ኦዴዛ። የይ አማንዝታ ኡባ ጋመ ኡፋይሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ኡንቲ የሩሳላመ ሄልን ዎሳ ኬꬃይ፥ ሀዋርታይኔ ጭምታይ ኡንታን ሞኬዛ። ጾሳይ ኡንታር ኦꬄዝ ባዝታ ኡባ ኡ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ዝን ፈርሳውታይ ባጋፕ አማኔዝ ፐቲ ፐቲ አሳይ ደንዲ ኤቂ፥ «አይሁደ ባዛር አማኔዝ አሳይ ዶካልንቶዳይስኔ ሙሰ ህጋ ናጎዳይስ ቤዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ሀዋርታይኔ ጭምታይ የያ ቶቦዳይስ ሺቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ጋመ ኦድንቴዛይፕ ጉየ፥ ጵጽሮሳ ደንዲ ኤቂ፥ «ታ እሹንꬆ፥ አይሁደ ባዝታይ ዎንግለ ቃላ ታ ዶናይፕ ስኢ አማኖዳይ ጋርክ ቲናቲ ታና ጾሲ ይ ጋንጨፕ ዶሬዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","አስ ዎዝና ኤርዛ ጾሳይ ጌሻ አያና ኑስ እንጌዛይ ጋርክ ኡንትስካ እንጌዛና ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","አማኖር ኡ ዎዝና ጌሼዝ ግሾስ ኑ ጋንጨኔ ኡ ጋንጨ ዱማትꬅ ጋደካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","የይ ግሾስ፥ ኑ አድታይኔ ኑኒ ቶኮዳይስ ዳንዳእንቶዋ ቃምባራ አማንዝታይ ሞርጋይል ጋዲ Ꮊት አብስ ጾሳ ፓጨ? ");
INSERT INTO mfxe_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ጎዳ የሱሳ ኣꬎ ኬሃትꬃይድ ኡንቲ አቴዛይ ጋርክ ኑካ አቴዛና አማኖዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","አሳይ ስእ ግ፥ ባርናባሳኔ ጳዉሎሳ አይሁደ ማቀካ አሳይ ጋንጨ ፋ ባጋር ጾሲ ኦꬄዝ ማላትታኔ ኦሮꬅባዝ ኡባ ኦዶዳር ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ኡንቲ ናሻ ሃሴዛይፕ ጉየ ያይቆባ፥ «ኢሹንꬆ፥ ታ ግዛ ስኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ጾሲ አይሁደ ባዝታይ ጋንጨፕ ፋ አስ ዶሮዳይስ ከዚ ኡንታን ቲን ዋይዚ ቆፔዛኮ ስሞና ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ናብታይ ቃላይ Ꮊይር ቃርዛ። ጌሻ ማጻፋይድ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«‹Ꮊይፕ ጉየ፥ ታኒ ማቆዳ፥ ዎꬌዝ ዳዉተ ኬꬃ ደንꬆዳ። ላልንቴዝ ኬꬃካ ታ ማሂ ኤሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","አቴዝ አስ ኡባይ ታኮ የኦዳ፥ ታኒ ጼጌዝ አይሁደ ማቀካ አስ ኡባይ ታና ኮዮዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ብንፕ አይኪ የይ ኤርንቶዳይ ጋርክ ኡዴዝ ጎዳይ፥ ታና› ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«የይ ግሾስ፥ ታ ቆፋይ ጾስኮ ማቄዝ አይሁደ ባዝታ ኑኒ ዋይꬃማይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ዝን ኡንቲ ኤቃስ ያርሽንቲ ቱኔዝባዝ ማማይ ጋርክ፥ ላግታማይ ጋርክ፥ ባዉታ ማማይ ጋርከኔ ሱꬂ ኡዣምኔ ማማይ ጋርክ ኡንትስ ኑኒ ዳብዳበ ጻፎዳይስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ሙሰ ህጋይ ብንፕ አይኪ ማላጋላስ አይሁደ ዎሳ ኬꬅ ናባብንትዛ ካታማ ኡባይድ ሳባክንትዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","የይፕ ጉየ፥ ሀዋርታይኔ ጭምታይ ዎሳ ኬꬅ አስ ኡባይር ዎላ ፋ ጋንጨፕ ጽቃ አስታ ዶሪ ጳዉሎሳራኔ ባርናባሳራ አንጾካ ዳኮዳይስ ቆፋ አጬዛ። ኡንቲ ኡንደና ኤርንቴዝ ካልꬅዛ ናምኢ አስታ ባርሳባሳ ግንትንትዛ ኤ ይሁዳኔ ስላሰ ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ꮊይ ጋርክ ግንትንቲ ጻፍንቴዝ ዳብዳባ ኡንታል አፋ ዳኬዛ፦ «ኑኒ ሀዋርታይኔ ጭምታይ ይ እሽታይ፥ አንጾካ፥ ሶራራኔ ክልቀ የዝ አይሁደ ማቀካ እሽታይስ ኑ ሳሮꬃ ኪቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«ኑኒ ኪተካ አስታይ ኑ ጋንጨፕ Ꮊንጊ፥ ‹ይ ዶካልንቶዳይስኔ ህገ ናጎዳይስ ቤዝዛ ግ› ይንታን ዋይꬄዛኔ ይሎꬄዛ ኑ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ኑኒ ዶስዛ ባርናባሳኔ ጳዉሎሳ ዶርንቴዝ አሳይር ዎላ ይንትኮ ኪቶዳይስ ፐቲ ዎዝናር ኑ ሙርቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ኡንቲ ኑ ጎዳ የሱስ ክርስቶሳ ግሾስ ፋ ሸምፖ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","የይ ግሾስ፥ ኑኒ ጻፌዛና ኡንቲ ፋ ዶናራካ ጉጂ ይንትስ ኦዶዳይ ጋርክ ኤ ይሁዳኔ ስላሰ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","«Ꮊ ኮሽዝታይፕ አትን ሀራ ቶፎ ይንታን ቶሳማይ ጋርክ ኑኔ ጌሻ አያናይ ሎኦ ቆፋ ማቄዛና በኤዛ ");
INSERT INTO mfxe_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ኤቃስ ያርሽንት ቱኔዝባዝ ሚፓተ፥ ሱꬅ ኡዥፓተ፥ ባዉታ ሚፓተ፥ ላግተ አይክፓተ። Ꮊ ኡባይፕ ይ፥ ይንታን ናግኮ ሎኦ ባዝ ኡድዛ። ሳሮ የዞይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","የይ ግሾስ፥ ኪትንቴዝታይ ሞይዝንቲ አንጾካ Ꮊንጊ አማንዛ አስታ ሺሺ፥ ዳብዳበ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ኡንቲ የ ምንꬃꬆ ዳብዳባ ናባቤዛይፕ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ማ ኤ ይሁዳኔ ስላሰ ኡ ፋ ኦማስ ናብታ ማቄዝ ግሾስ አማንዝታ ሎእꬂ ዞሪ ምንꬃꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ኡንቲ አንጾካ ጽቃ ጋላስ በቴዛይፕ ጉየ እሽታይ ሎኦር ሞይዝን ፋና ኪቴዝታይኮ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ዝን ስላሰ ኤዛይድ አቶዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ማ ጳዉሎሳራኔ ባርናባሳር ሀራ ጋመ አስታይር ዎላ ጎዳይ ቃላ ታማርስታራኔ ዎንግለ ኦድታር አንጾካ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ጽቃ ጋላሳፕ ጉየ ጳዉሎሳ ባርናባሳኮ፥ «ኑኒ ጎዳይ ቃላ ኦዴዝ ካታማ ኡቢታይድ አማንዝታይ ዋፋ የዛኮ ጉየ ማቅታር ዎላ በአዳኔ ኤሮዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ባርናባሳ ማርቆሳ ግንትንትዛ ዋንሳ ፓር Ꮊንጎዳይ ጋርክ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ዝን ጳዉሎሳ ማርቆሳ ፓር Ꮊንጎዳይ ጋርክ ኮየካያ። የይካ፥ ኤ ጵንፍላ ሻክንቲ ኡንታር ኦꬆዳይስ Ꮊንገካ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ኡ ጋንጨ ኢታ ካቺ ኬዝን ፐታይ ፐታይፕ ሻክንቴዛ። ባርናባሳ ማርቆሳ ኤኪ ማርካበር ቆጲሮሳ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ዝን ጳዉሎሳ ስላሰና ዶሬዛ፤ አማንዝታይ ጳዉሎሳ ጾስ ኣꬎ ኬሃትꬃይስ ሀዳራ እንጌዛይፕ ጉየ ኤ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ዬዚ፥ ዎሳ ኬꬅታ ምንꬃꬅታር ሶራራኔ ክልቃራ ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳዉሎሳ ደርበኔ ልስጽራ ሄሌዛ። ኤዛይድ ጽማቶሳ ግዝ አማንዛ አስ የዛ። ኤ እንዳታካ አማንዛ አይሁደ ማች፥ ኤ አዳይ ግርኬ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ልስጽራራኔ ኢቆኖነ የዝ አምዝታይ ጽማቶሳ ባጋ ሎእꬂ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳዉሎሳ ጽማቶሳ ፓር ካንጎዳይስ ኮዬዛ፥ ኤ አዳይ ግርኬ አስ ማቄዛ የ አቆ የዝ አይሁደ ኡባይ ኤርዛ ግሾስ ኤዛ ዶካሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ኡንቲ ካታምታይራ Ꮊንግታር የሩሳላመ የዝ ሀዋርታይኔ ጭምታይ አጬዝ ቆፋ አማንዝታይ ናጎዳይ ጋርክ ኡንትስ ኦድታር ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","የይ ግሾስ፥ ዎሳ ኬꬅታይ አማኖር ምንግታር፥ ፓይዶራካ ጋላስ ጋላስ ጋንጊ ጋንጊ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ኢስያ ቃላ ኦዳማይ ጋርክ ጌሻ አያናይ ኡንታን ካዬዝ ግሾስ ጵርገራኔ ጋላትያ ቢታር ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ኡንቲ ሚሳ ዛዋ ሄሌዝ ዎደ ብታና Ꮊማዳይስ ቡትንቴዛ። ዝን የሱሳ አያናይ ኡንታን ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","የይ ግሾስ፥ ኡንቲ ሚሳ ካንታር ኣꬊታር ጽሮአዳ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ጳዉሎሳ ቃማ ቆንጭꬃር ፐቲ ማቃዶና አስ ፋኮ፥ «ማቃዶና ፒንጊ ኑና ማዶየ» ዬግታር ኤቂ ዎሶዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","አጁታ ኤ በኤዛይፕ ጉየ ኤልሲ ኑኒ ማቃዶና Ꮊማዳይስ ኮዬዛ። የይካ፥ ዎንግለ ኤዛይድ የዝ አሳይስ ኦዶዳይስ ጾሳይ ኑና ጼጌዝ አዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ጽሮአዳፕ ደንዲ ማርካበ ገሊ ሳሞትራቀ Ꮊንጌዛ፥ ዎንትꬃ ጋላስ ናጱለ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","የይፕ ደንዲ ማቃዶና ቢታ የዝ ፍልጲሶሳ ግዝ ኤርንቴዝ ዎራዳ ካታማ Ꮊንጌዛ። ማ ፍልጲሶሳ ኦሮመ ካታይ ኦላር ሞዴዝ ካታማ። ኑኒ የ ካታማይድ ጽቃ ጋላስ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ማላ ጋላስ ካታማይፕ ጋጻ ቦርካ ካለ አይሁድታይ ጾስ ዎስዛ አቆ የዛና ቆፒ ገድ Ꮊንጌዛ። የ አቃይድ ሺቄዝ ማችታይስ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ኑና ስእዝ አሳይፕ ፐቲ ሊዳ ግንትንትዛና ትያትሮና ካታማፕ የኤዛ፥ ጾስ አማኔዛ ዞቆ አፍላ ዛልእዛ፥ አስታ የዛ። ጳዉሎሳ ኦድዛ እዛ ስኦዳ ጋርክ ጎዳይ እ ዎዝና ዶዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ሊዳ ፋ ካራ አሳይር ፐትፕ ጻማቅንቴዛይፕ ጉየ ኑኮ፥ «ይ ታና ጎዳ ቱማ አማኔዛ ጊኮ ታ ካራ ይኢ የዞይታ» ግ ሚንꬂ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ኑኒ ጾሳ ዎስዛ አቃ Ꮊማዳር ኢታ አያና ኢል አፋ የዛና ካዮር ፋ ጎድታይ ጋመ ሚሸ ክእዝ ፐቲ አይላታ ኑና ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ጳዉሎሳኔ ኑና ካሊ፥ «Ꮊይትታይ ኡባይፕ አፋ ጾስ አይልታ! ኡንቲ ይ አቶዳ ኦጋ ኦድዝታ» ግ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ኡባ ጋላስ የይ ጋርክ ግዛ። ዝን ጳዉሎሳ ይሎቲ ጉየ ማቂ፥ የ አያና፥ «የሱስ ክርስቶሳ ሱንꬃይር እዝፐ ከዞባ» ግ ኪቴዛ። እዝራካ ኢታ አያናይ እዝፐ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ዝን እ ጎድታይ ኡ ሚሸ ደንግዝ ኦጋይ ꬋቤዛ ብኢ፥ ጳዉሎሳኔ ስላሰ አይኪ፥ አዉዳረ ዳይንታይ ቲና ጎቺ ካንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ዳይንታይ ቲና ኡ ካንጊ፥ «Ꮊይትታይ አይሁደ አስ ማቅታር ኑ ካታማ አሳ ኢታ ዋይꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ኑኒ ኦሮመ ጋደ አስ ማቆዳር ኤኮዳይስኔ ኦꬆዳይስ ዎጋ ባባዝ ታማርስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","አሳይ ፐቲ ባጋ ማቂ፥ ጳዉሎሳል አፋኔ ስላሰል አፋ ደንዴዛ። ዳይንታይ ኡ አፍላ ቃሪ ጉፈር ኡንታን ሾጮዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ኡንታን ጋመ Ꮊꬌዛይፕ ጉየ አች ካራ ገልሴዛ። አች ኬꬃ ናግዛይ ኡንታን ሚንꬂ ናጎድ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","አች ካራ ናግዛይ የ ኪታ ኤኪ፥ ጳዉሎሳኔ ስላሰ አች ካራይስ ቆልአ ገልሴዛ። ኡ ቶካ ዱꬃር ዱጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ዝን ግዲ ብላሄ ማቆዳር ጳዉሎሳራኔ ስላሰራ ዎስታራኔ ማዝሙረ የጽታር ጾሳ ጋላትዛ። አች ካራ የዝ ሀራ አስታይካ ኡንቲ ግዝባዝ ስእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ቆፐካ አች ካራ ባሳይ ኤንኦድ ሄሎዳይስ ቢታ ኤንኦ ማቄዛ። የ ሳታተካ ፐንገ ኡባይ ዶይንቴዛ፤ አጭንቴዝ አስ ኡባ ሳንꬃላታይ ብልንቲ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","አች ካራ ናግዛይ ገንታፕ ባርኮዳር አች ካራ ፐንገ ኡባይ ዶይንቴዛ ብኢ አች አሳይ ከዚ ቅቴዛ ኣዝን ፋና ዎꬎዳይስ ማሻ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ዝን ጳዉሎሳ ቃላ ꬎቅ ኡዲ «ኑ ኡባይ Ꮊይዳ የዛ ነና ቆህፐ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","አች ካራ ናግዛይ ጾምፐ ዎሲ ኤኪ ኤልሲ ጋንጨ ላሲ ኩኮርታር ጳዉሎሳ ቲናኔ ስላሰ ቲና ጹጉኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ኡንታን ባለ ከሲ፥ «ታ ጎድታዮ፥ ታኒ አቶዳይስ አብ ኡዶዳይስ ቤዜ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ጳዉሎሳራኔ ስላሰር ኤዝኮ፥ «ጎዳ የሱስ ክርስቶሳ አማኖባ፤ ኔራኔ ነ ካራ አሳይራ አቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ኡንቲ ኤስኔ ኤ ካራ የዝ ኡባይስ ጎዳይ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ቃማ የ ሳታተካ አች ካራ ናግዛይ ኡንታን ካንጊ ኡ ሳምባራ ሜጬዛ። ኤልሲ ፋ ካራ አስ ኡባይር ጻማቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ጳዉሎሳኔ ስላሰ ፋ ካራ ካንጊ ኡንትስ ካꬃ ኣꬄዛ። ኤ ፋ ካራ አስ ኡባይር ጾስ አማኔዝ ግሾስ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ሳአይ ዎንትን ዳይንታይ፥ «የ አስታ ብልኦባ» ዬጊ ፖልሰ ሀላቅታ ኤዝኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","አች ካራ ናግዛይ፥ «ይ ብልንቶዳይ ጋርክ ዳይንታይ አዛዜዛ። ይኬ፥ ከዚ ሳሮ Ꮊንጎይታ» ዬጊ የ ኪታ ጳዉሎሳስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ዝን ጳዉሎሳ የ ፖልሰ ሀላቅታይኮ፥ «ኑኒ ኦሮመ አስ ማቃዳር ኡንቲ ኑና ፕርዳ ባጋ አሳይ ቲና Ꮊꬊ፥ አች ካራ ኦሌዛ። Ꮊት ኑና ጌማር ከዚ ቅቶ ግኔ? ሀነና፥ ኡንቲ ፋ ኦማስ ይኢ ኑና ከሶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖልሰ ሀላቅታይ ዳይናይስ የያ ኦድን፥ ጳዉሎሳራኔ ስላሰራ ኦሮመ ጋደ አስ ማቄዛ ስኤዝ ዎደ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","የይ ግሾስ፥ ዳይንታይ ይኢ ኡንትኮ፥ «ኑኒ ይንታን ቆሄዛ» ጌዛ። አች ካራፕ ባለ ኡንታን ከሲ፥ ካታማይፕ ከዚ ቅቶዳይ ጋርክ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳዉሎሳራኔ ስላሰራ አች ካራፕ ከዚ ሊዳ ካራ Ꮊንጌዛ። ኤዛይድ አማንዝታ ሄሊ ኡንታን ምንꬃꬂ ከዚ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ጳዉሎሳራኔ ስላሰራ አምፍጶሊናራኔ አጶሎናር ኣꬊ ተሰሎንቀ Ꮊንጌዛ። ኤዛይድ አይሁደ ዎሳ ኬꬅ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳዉሎሳ ካሴሳይ ጋርክ ኤዛይድ ገሌዛ። ኤዛይድ ሀይꬒ ሳምንታ ጾስ ቃላፕ አሳይስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ክርስቶሳ ዋየ ኤኮዳይስኔ Ꮊይቆፕ ደንዶዳይስ ቤዝዛና ኡንትስ ቆንጨር ኦድታር፥ «የሱሳ Ꮊ ታኒ ይንትስ ኦድዛይ ክርስቶሳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ኡንታፕ ፐታይ ፐታይ ኦዳይ ቱማ ማቄዛና ማኢ ጳዉሎሳራኔ ስላሰራ ቶቤዛ። የይ ጋርከካ፥ ጾሳ ጎይንዛ ጋመ ግርኬ አሳይኔ ጋመ ቦንችንቴዝ ማችታይካ ኡንታር ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ዝን አይሁድታይ ቅናቲ አዛልዛ ኢታ አስታ ጋበ ኦገፕ ሺሼዛ። ካታማ ጋንጨ ጫቦ መꬌዛ፤ ጳዉሎሳኔ ስላሰ አሳይስ ኣꬂ እማዳይስ ከዚ ያሶነ ካራ ኤልሲ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ጳዉሎሳኔ ስላሰ ኡንትስ በንታም እጽን፥ ያሶነኔ እሽታይፕ ፐቲ ፐቲ አማንዝታ ካታማ ሀላቅታይኮ ጎቺ ካንጊ፥ «የይትታይ ቢታ ኡባ ቡቂዝታይ Ꮊት ማ ኑኮ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ያሶነ ኡንታን ፋ ካራ ጋዴዛ። Ꮊይትታይ፥ ‹የሱሳ ግዝ ሀራ ካታይ የዛ› ግ ቄሳረ ኪታ እጽዝታ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ሺቄዝ አሳይኔ ካታማ ሀላቅታይ የያ ስእን ኤዝስ ሀኖድ ባዝ ꬋቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ሀላቅታይ ያሶናኔ ሀርታ ዋሰር ብልኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","አማንዝታይ ጳዉሎሳኔ ስላሰ ቃማር ቤራ ዳኬዛ። ቤራ ሄሊ፥ አይሁደ ዎሳ ኬꬅ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ቤራ አስታይ ተሰሎንቀ አስታይፕ ኣꬌዝ ዎዝና ሉልታ። ኡንቲ ቃላ ኩንꬅ ዎዝናፕ ኤኬዛ፤ ጋላስ ጋላስ ጌሻ ማጻፍታ ናባብታር ጳዉሎሳ ጌዛይ ቱማ ማቄዛና ሻኪ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","የይ ግሾስ፥ ኡንታፕ ጋምታይ፥ ግርክታይፐካ ቦንችንቴዝ ጽቃ ማችታይኔ ꬊራꬅታይ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ዝን ተሰሎንቀ የዝ አይሁድታይ ጳዉሎሳ ጾስ ቃላ ቤራ ጋደካ ኦዴዛና ስኢ ቤራ ይኢ አሳ ቡቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","የይፕ ጉየ፥ አማንዝታይ ኤልሲ ጳዉሎሳ አባ ካለ ዳኬዛ። ዝን ስላሰኔ ጽማቶሳ ቤራ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳዉሎሳና ሞይዜዝ አሳይ አቴና ሄልꬂ አሼዛ። የ አሳይ ስላሰኔ ጽማቶሳ ኡንትስ ዳንዳእንትኮ ኤልሲ ፋኮ የኦድ ጋርክ ጳዉሎሳ ኪቴዝ ኪታ ኤኪ ቤራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳዉሎሳ አቴና ስላሰናኔ ጽማቶሳ ናግታር፥ ካታማይ ኤቃር ኩሜዛና ብኢ ሸንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","የይ ግሾስ፥ አይሁደ ዎሳ ኬꬃ አይሁድታይራኔ ጾሳ ጎይንዛ አይሁደ ማቀካ አሳይር ማ ጋበላካ ፋና ሄሌዝ አሳይር ኡባ ዎደ ፓላምዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ኤጲቆሮሳ ባጋፐኔ ኢስቶይካንታ ግንትንትዝ ኤራንችታይፕ ፐታይ ፐታይ ጳዉሎሳር ፓላሜዛ። ኡንታፕ ፐታይ ፐታይ፥ «Ꮊ ዶናንቻይ አብ ኦዶዳይስ ኮይነሻ?» ዬጌዛ። Ꮊንክታይ ጳዉሎሳ የሱሳኔ Ꮊይቆፕ ደንዶ ባጋ ኡንትስ ኦዴዝ ግሾስ «ኦሮꬅ ኤቅታይ ባጋ ኦድዝ ኣዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ጳዉሎሳ አይኪ አርዮስፓጎሳ ግንትዝ ሺቆ አቃ ካንጊ፥ «Ꮊ ኔኒ ታማርስዛ ኦሮꬅባዛይ አብዛኮ ኑና ኤርሳሞ? ");
INSERT INTO mfxe_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","አብስ ጊኮ፥ ኔኒ ኑስ ኦሮꬅባዝ ኦድዛይ፤ አብዛኮ ኑኒ ኤሮዳይስ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","አቴና አስ ኡባይኔ ኤዛይድ የዝ እማꬅታይ ኦሮꬅባዝ ኦድንተካዛራኔ ስኤካ ፔዦያ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ጳዉሎሳ አርዮስፓጎሳ ሺቄዝ አሳይ ቲና ኤቂ፥ «አቴና አሳዮ፥ ይ ጾስታይስ ኡባ ባዛር ጋመ ያሽትዛ ታኒ ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ታኒ ይ ካታማይር ዩይታር ይ ጎይንዛ አቅታ በአዳር ‹ኤርንቶዋ ጾስስ› ግንትንቲ ጻፍንቴዝ ያርሾ አቆ ደንጌዛ። Ꮊ ይ ኤረካዛር ጎይንዛና ታኒ ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ሳአኔ ሳአል የዝ ኡባ ባዝ መꬌዝ ጾሳይ፥ ሳሎኔ ሳአ ጎዳይ፥ አሲ ኬጼዝ ኬꬃ የዞያ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ኤ ደኦኔ፥ ሸምፖኔ ኡባ ባዝ አስ ኡባይስ እንግዛ ግሾስ ፓጨ የዝ አስ ጋርክ አስ ማዴ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","አሲ የዞድ ዎዳይስኔ አቃይስ ዛዋ እንጌዛ። ጾሳይ አስ ዘርꬅ ኡባ ፐቲ አꬃይፕ መꬊ ቢታ ኡባይድ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ኤ የያ ኦꬄዛይ አሲ ኤዛ ኮዮዳይ ጋርከኔ ኮዪ ደማዳይ ጋርከሲ። ሀንኮካ ኤ ኑፕ ሃከካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ይንትፕ ፐቲ ፐቲ የጽዝታይ፥ ‹ኑኒ ኤ ናእታ› ጌዛይ ጋርክ፥ ኑኒ ኤዛይድ ፓꬅ የዚ፥ ኤንእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ይኬ፥ ኑኒ ጾስ ናእታ ማቅዝ ግሾስ ‹ጾሳይ አስ ኤጨትꬃራኔ ቆፋር ዎርቃፕ ዎይ ብራፕ ዎይ ሹቻፕ ኦስንቴዝባዝ ኣዝዛ› ዬጊ ቆፖዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","የይ ግሾስ፥ ጾሲ ቲና አሳይ ኤረካ ኦꬄዛና አሺ ኣꬌዛ፥ ዝን Ꮊት ኡባ አቆ የዝ አስ ኡባይ ናጋራፕ ማቆዳይ ጋርክ አዛዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","አብስ ጊኮ፥ ጾሲ ፋ ዶሬዝ አꬃይር ሳአል የዝ አስ ኡባይል አፋ ጽሎ ፕርዳ ፕርዶዳይስ ቃማ ጊግሲ ጋዴዛ። ኤዛ Ꮊይቆፕ ደንꬂ የያ አስ ኡባይስ ቱማሴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ኡንታፕ ፐቲ ፐቲ አስታይ Ꮊይቆፕ ደንዶ ባጋ ጳዉሎሳፕ ስኢ፥ ኤዛል አፋ አርኤዛ። ዝን Ꮊንክታይ፥ «ኑኒ የያ ኔፕ ጉጂ ስኦዳይስ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","የይ ግሾስ፥ ጳዉሎሳ ኡ ጋንጨፕ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ዝን ፐቲ ፐቲ ꬊꬅታይ ጳዉሎሳ ሄሊ አማኔዛ። ኡ ጋንጨፕ አርዮስፓጎሳ ፕርደ ዳይና ድዮናሶሳ ግንትዝ አስታ፥ ዳማርሶ ግንትዝ ፐቲ አስትኔ Ꮊንክታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","የይፕ ጉየ፥ ጳዉሎሳ አቴናፕ ከዚ፥ ቆሮንቶሳ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ኤዛይድ አቂላ ግንትዝ ጳንጾሳ የልንቴዝ ፐቲ አይሁደ አስ ደንጌዛ። አይሁደ አስ ኡባይ ኦሮመፐ ከዞዳይ ጋርክ ካታይ ቃላዉዶሳ ኪቴዝ ግሾስ ጽቃ ዎደፕ ቲና ኤ ፋ ማቻት ጵርስቅላር ኢጻለፕ የኤዛ። ጳዉሎሳ ኡንታን ሄሎዳይስ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ኤ ኦሳይ ኡንቲሳይ ጋርክ ዱንካነ ስኮ ማቄዝ ግሾስ ኡንታር በቲ ዎላ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ጳዉሎሳ ማላ ጋላስ ኡባይድ አይሁድታኔ ግርክታ አማንꬆዳይስ አይሁደ ዎሳ ኬꬃ ኡንታር ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ስላሰኔ ጽማቶሳ መቅዶናፕ ይእን ጳዉሎሳ ፋ ዎደ ኡባ እንጊ አይሁድታይስ የሱሳ ኤ፥ ክርስቶሳ ግ አዛላ ባይꬅ ማርካትታር ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ዝን ኡንቲ ጳዉሎሳና እጺ ኤዛ ጫዥን ጳዉሎሳ ፋ አፍላይፕ ቡልአ ትቂስታር፥ «ይ ሱꬃይስ ይንታን ኦይጮ፤ ታኒ Ꮊንፕ ጌሽ። Ꮊንፕ ማቂ፥ ታኒ አይሁደ ማቀካ አሳይኮ Ꮊማዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","የይፕ ከዚ ጾስ ጎይንዛ ትቶሳ ዮስጾሳ ግዝ አꬃይ ካራ Ꮊንጌዛ። ዮስጾሳ ካራይ አይሁደ ዎሳ ኬꬃይ ካለ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","አይሁደ ዎሳ ኬꬅ ሀላቃይ ቃርስጶሳ ፋ ካራ አስ ኡባይር ጎዳ አማኔዛ። ቆሮንቶሳ አስታይፐካ ጋምታይ ጾስ ቃላ ስኤዝ ዎደ አማኒ ጻማቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ጎዳይ ፐቲ ቃማ ጳዉሎሳስ ቆንጭꬃር ይኢ፥ «ያሽትፐ፤ ኦዶባፕ አትን ስእ ጊፐ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ታኒ ኔር የዛ። ታስ Ꮊ ካታማይድ፥ ጋመ አስ የዝ ግሾስ ነና ቆህ ኢታ ባዝ ኦꬆድ አስ ኦንካ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","የይ ግሾስ፥ ጳዉሎሳ ጾስ ቃላ አሳ ታማርስታር ፐቲ ላይꬅኔ ኡሱፑን አጌና ኡንታር በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋሎሳ አካያ ቢታ አቅሶዳር አይሁድታይ ፐትፕ ጳዉሎሳል አፋ ደንዲ ፕርደ ኬꬅ ካንጊ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Ꮊ አꬃይ ህገ እጺ፥ አሳይ ጾስ ጎይኖዳይ ጋርክ ኡድዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጳዉሎሳ ናሾድ ሀኖዳር፥ ጋሎሳ አይሁድታይኮ፥ «አይሁድታዮ፥ የይ ኢታ ኦሶ ዎይ ናቆ ማቄዛኮ ታኒ ይ ባጋ ዳንዳእ ስኦዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ዝን ቃላስ፥ ይ ሱንꬃይስኔ ይ ህጋይስ ይ ፓላምዛ ባዝ ማቅኮ ይ፥ ይንትስ ብሎይታ፤ የያ ታኒ ፕርዳሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ዬዚ፥ ኡንታን ፕርዳ ኬꬃይፕ ባለ ከሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","የይፕ ጉየ፥ አስ ኡባይ አይሁደ ዎሳ ኬꬅ ሀላቃ ሶስቴንሳ አይኪ ፕርደ ኬꬅ ቲና Ꮊꬌዛ። ዝን ጋሎሳስ የይ አብካ ኣዘካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳዉሎሳ ጋመ ጋላስ ቆሮንቶሳ በቴዛይፕ ጉየ አማንዛ አሳ ሳሮꬅ፥ ጵርስቅልራኔ አቂላራ ማርካበር ሶራ Ꮊንጌዛ። ዝን ኤ Ꮊንጎዳይፕ ቲና ኤስ ጋꬆ የዝ ግሾስ ክንክሮሳ ካታማይድ ፋ ኦማ ሜዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ኡንቲ ኤፈሶነ ሄሊ ጳዉሎሳ ጵርስቅላኔ አቂላ ኤዛይድ አሼዛ። ዝን ፓስ አይሁደ ዎሳ ኬꬅ ገሊ አይሁድታይራ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ኡንቲ ፓር ጋመ ዎደ በቶዳይ ጋርክ ጳዉሎሳና ዎሴዛ ዝን ኤ እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ኡንታፕ ሻክንቲ፥ «ጾሲ ጊኮ ይንትኮ ማቂ የኦዳ» ዬጊ ኤፍሶነፕ ማርካበር ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ቅሳረ ሄሊ የሩሳላመ Ꮊንጊ ዎሳ ኬꬅ አሳይ ሳሮꬄዛይፕ ጉየ አንጾካ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ኤዛይድ ጽቃ ዎደ ጋምኤዛይፕ ጉየ ታማርታ አስታ ኡባ ምንꬃꬅታር ጋላትያራኔ ጵርገር ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ኢስክንድረ የለታ ማቄዝ ፐቲ አጵሎሳ ግዝ አይሁደ አስ ኤፈሶነ ቅቴዛ። ኤ ኦዳ ኤርዛ አስኔ ጾስ ቃላ ሎእꬂ ኤርዛ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ኤ ጎዳ ኦጋ ታማሪ፥ አያናር ጹግንቲ የሱሳ ባጋ ሉለ ኦድዛኔ ታማርስዛ። ሀኖ ዝን፥ ዋንሳ ጽንቃታ ኣዳ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ኤ አይሁደ ዎሳ ኬꬃ ያሽተካዛር ታማርሴዛ። ጵርስቅላኔ አቂላ ኤ ኦድዛና ስኢ ኤዛ ፓር ካራ ካንጊ ጾሳ ኦጋ ቲናሳይፕ ኣꬂ ኤስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","አጵሎሳ አካዛ Ꮊማዳይስ ኮይን ኤፈሶና የዝ አማንዛ አሳይ ኤ ቆፋ ኤኪ አካያ የዝ አማንዝታይ ኤዛ ሞኮዳይ ጋርክ ኡንትስ ዳብዳበ ጻፌዛ። ኤ ኤዛይድ ሄሊ ጾስ ኣꬎ ኬሄትꬃር የሱስ ክርስቶሳ አማኔዝታ ጋመ ማዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","የሱሳ ኤ ክርስቶሳ ማቄዛና አይሁድታይስ ጾስ ቃላይፕ ቆንጭሲ ዎያ ኡባይ ቲና ሚንꬂ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","አጵሎሳ ቆሮንቶሳ የዝን፥ ጳዉሎሳ ዎክ ባጋ ጋደር ኣꬊ ኤፈሶነ ሄሌዛ። ኤዛይድ ፐቲ ፐቲ አማንዛ አስታ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ኡንታናካ፥ «ይ አማኔዝ ዎደ ጌሻ አያና ኤኬኔ?» ዬጊ ኦይጬዛ። ኡንቲ፥ «ዋኣ፥ ኤከካያ፤ ሀራ አቶዝን፥ ጌሻ አያና የዛናካ ኑ ስኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ጳዉሎሳ ኡንትኮ፥ «የዝን፥ ይ አባር ጻማቅንቴኔ?» ዬጌዛ። ኡንቲ፥ «ኑኒ ዋንሳ ጽንቃታ ጻማቅንቴዛ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳዉሎሳ፥ «ዋንሳ ፓፕ ጉየር ይእዝ የሱስና አሳይ አማኖዳይ ጋርክ አሳይስ ኦድታር፥ ማሮትꬅስ ቤዝዛ ጽንቃታ ጻማቄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ኡንቲ የያ ስኢ ጎዳ የሱሳ ታማርታ ማቆዳይስ ኤ ሱንꬃር ጻማቅንቴዛ ጋላስ ጋላስ ጌሻ ማጻፍታ ናባብዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳዉሎሳ ፋ ኩሻ ኡንታል አፋ ጋድን ጌሻ አያና ኡንታል አፋ ዎꬍን፥ ዱማ ዱማ ዶናር ኦድንቴዛ፤ ማ ትንቢተ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","የ አቃይድ ታጶ ናምኤ ማቅዝ አስታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ጳዉሎሳ አይሁደ ዎሳ ኬꬅ ገሊ፥ ጾስ ካተትꬂ ባጋ ያሽተካዛር ፓላምታራኔ ሎእꬂ ቆንጭስታር ኡንታር ሀይꬒ አጌና ሄሎዳይስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ዝን ኡንታፕ ፐታይ ፐታይ ꬉበ ማቂ ጋመ አሳይ ቲና ጎዳይ ኦጋ ጫዢ አማናም እጼዛ። ጳዉሎሳ አማንዝታ ኡንታፕ ሻጊ ኤኪ ጽራኖሳ ግዝ ትምርተ ኬꬃ ኡባ ዎደ ኡንታን ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ጳዉሎሳ ናምኢ ላይꬅ ሄሎዳይስ ቃላ ኦዴዛ። የይ ግሾስ፥ ኢስያ የዝ አስ ኡባይ፥ አይሁድታይኔ አይሁደ ባዝታይ ጎዳይ ቃላ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ጾሳይ ጳዉሎሳ ኩሸ ዎልቃማ ማላባዝታ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","የይ ግሾስ፥ አሳይ ኤ ጋላ ቦቼዝ ማራበ ዎይ ማኦ ሀርግንቴዝ አሳይስ ካንግዛ። ኡንትካ ፓጽዛ፤ ቱና አያንታይካ ኡንታፕ ከዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ቱና አያንታ ከስታር ዩይዛ አይሁድታይፕ ፐታይ ፐታይ፥ «ጳዉሎሳ ሳባክዛ የሱሳ ሱንꬃይር ከዞይታ ግ ይንታን አዛዝዛ» ዬጊ፥ ቱና ጋለንታይ አይኬዝ አስታይል አፋ ጎዳ የሱሳ ሱንꬃ ጼጌዛ ");
INSERT INTO mfxe_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","አይሁደ ቄሰ ሀላቅታይፕ ፐታ ማቄዝ አስቄዋ ግንትዝ አꬃይስ የያ ኦꬅዛ ላፑን ꬊራꬅ ናእታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ዝን ቱና አያናይ ኡንትኮ፥ «ታኒ የሱሳካ ጳዉሎሳ ባጋካ ኤርዛ፥ ዝን ይንቲ ኦናንታራ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ቱና አያና አይኬዝ አꬃይ ኡንታል አፋ ዶንጊ ዎꬊ፥ ኡንታል ማዶꬅ ከሲ፥ የ ካርትፕ ካሎ ላሲ ꬋቦድ ሄሎዳይስ ዎልቃሚ ጋሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ኤፈሶና የዝ አይሁድታይኔ አይሁደ ባዝታይ ኡባይ የያ ስኢ ኢታ ያሽቴዛ። ጎዳ የሱሳ ሱንꬃይ ጋመ ቦንችንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","አማንዝታይፕ ጋምታይ ፋ ኦꬄዝ ኢታ ኦሳ ቡጽታራኔ ቆንጨ ኦድታር ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ሙሩንታይፕ ጋምታይ ፋ ማጻፍታ ሺሺ አስ ኡባይ ቲና ምቼዛ። የ ማጻፍታይ ዋጋይ ዋጋይ እሻታም ሙኩለ ብራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","የይ ጋርክ ሀኒ ጾስ ቃላይ ዎልቃር ድጭታራኔ ዳልግታር ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","የይ ፖልንቴዛፕ ጉየ ጳዉሎሳ፥ «ታኒ የሩሳላመ ማቂ ኦሮመ Ꮊማዳይስ ቤዝዛ» ዬጊ ማቃዶናራኔ አካያራ ኣꬊ የሩሳላመ Ꮊማዳይስ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ማ ፋና ማድዝታይፕ ናምእታ ጽማቶሳኔ ኤራስጾሳ ማቃዶና ኪቲ፥ ፓስ ኢስያ ጽቃ ዎደ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","የ ዎደ Ꮊ ኦጋይ ግሾስ ኢታ ካቺ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ፐቲ ብራ ኦꬅዝ ድመጽሮሳ ግንትዝ አꬃይ አርጸምሳ ኤቃ ካራ ምስለ ብራፕ መꬊ ጋመ ዎ ደንግዛዝን። ");
INSERT INTO mfxe_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","የይ ግሾስ፥ የይ ጋርክ ኦሶ ኦꬅዝታ ፐትፕ ሺሺ፥ «አሳዮ፥ ኑ ዱረትꬃይ Ꮊ ኦሳይፕ ማቄዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ጳዉሎሳ፥ Ꮊይ ‹አስ ኩሸ ኦስንቴዝታይ ጾስ ባያ› ዬጊ፥ ኤፈሶናራኔ ጽቃ ቢትታይፕ አትን ሙመ ኢሳ ቢታ ኡባይል የዝ ጋመ አሳይስ ኦዲ አማንꬄዛኔ ማሄዛ ይ በኤዛኔ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","መቶ ማቄዛይ፥ ኑ ኦሳይ ለቅንቴዝታ ኣዳ ባዝን ኢሳኔ ጋደ ኡባይል የዝ አስ ጎይንዛ ግታ ጾስኔ አርጸምሳ ካራይ ኦድንተካ አቶዳይኔ ኤ ዳሞትꬃይካ ዎꬎዳይ ያሽዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","አሳይ የያ ስኢ ሸነር ኩሚ፥ «ኤፍሶና አርጸምሳ ባይራ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","የ ኡፋይ ካታማ ኡባ ሄሌዛ። ጳዉሎሳ ላግታ ማቃዶና አስታ፥ ጋዮሳኔ አርስጽሮኮሳ ኡንታር ዎላ ዳፍ ኤኪ ካእዛ አቃ ዎጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳዉሎሳካ አሳይ ሺቄዝ አቆ ገሎዳይስ ኮዬዛ፥ ዝን አማኔዝታይ ኤዛ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ኢሳ ቢታ ሀላቅታይፕ ጳዉሎሳስ ዣመ ማቄዝ ፐታይ ፐታይ ጳዉሎሳኮ ኪቲ፥ «ካእዛ አቆ ቆንጨር ከዚ በንትፐ» ግ ኤዛ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ሺቄዝ አሳይስ ሀኖድ ባዝ ꬋቤዛ፤ ጋንግዛ ባጋ አሳይ ሀራ አቶዝን አብስ ሺቄዛኮ ኤረካዛይ ግሾስ ፐታይ ፐትባዝ ግ ኡክዛ ማ Ꮊንክታይ ሀራ ባዝ ግ ኡክዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","አይሁድታይ ኢስክንድሮሰ ግዝ አꬃ ዎያ ጋንጨፕ ቲና ኡርቄዝ፥ ፐቲ ፐቲ አሳይ ኤ ጎድባዛ ኦድን ኤዚ አሳይ ስእ ጎዳይ ጋርክ ፋ ኩሻይር ማሊ ቤዚ፥ አሳይስ ሞትንቶዳይስ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ዝን ኢስክንድረ አይሁደ አስ ማቄዝ አሳይ ኤሪ ናምኢ ሳተ ማቆድ ሄሎዳይስ ኡባይ ፐቲ ቃላር፥ «ኤፈሶና አርጸምሳ ዳማ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ዉርስꬃ የ ካታምቲ ጻፋይ ዎያ ስኢ ኡዲ፥ «ኤፈሶና አሶ! ኤፈሶና ካታማይ ግታ አርጸሚሳስ ኤቃ ካራኔ ሳሎፕ ዎꬌዝ፥ ግታ ሹች ናግዛ ማቄዛና ኤሮዋ አስ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ꮊያ ላህዛ አስ ባ ማቅኮ ይ ስእ ጎዳይስነ ኤልሲ እታ ባዝ ኦꬆፕ ናግንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ይ Ꮊ አስታ፥ ኤቃ ኬꬅ ሚሸ ካስተካዝታኔ ኑ ጾስታ ጫዢ በኤካዝታ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","የይ ግሾስ፥ ድመጽሮሳኔ ኤዛር የዝ ኦሳንችታይ ኦራካ ሞትንቶ ኮይኮ፥ ፕርደ ኬꬅ የዛ፤ ዳይንታይካ የዛ፤ ኡ ሞቶዳይስካ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ዝን ይ ሀራ ኦዳ ኮይኮ፥ ሻንጎ ሺቆል ኦዳይ ብእንቶ። ");
INSERT INTO mfxe_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","የይ ማቃም እጽኮ Ꮊይኖ ሀኔዝባዛይስ ኦሮመ ካተትꬃይ ኑና ኦይጮዳ። Ꮊ ቡቅꬃይስ ጋሶ ባ ግሾስ ኑኒ ማልሰ ማሆዳይስ ዳንዳኦያ» ");
INSERT INTO mfxe_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ዬጊ ሺቃ ላሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ጫቦትꬃይ ሀይዜዝን ጳዉሎሳ አማንዛ አስታ ጼግሲ ኡንታን ምንꬃꬄዛይፕ ጉየ ሳሮꬅ ማቃዶና Ꮊማዳይስ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ኤ ኣꬊዝ ቢታይድ የዝ አማንዛ አሳይስ ዞረ ቃላ ኦዲ ምንꬃꬄዛይፕ ጉየ ግርኬ ጋደ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ኤ ኤዛይድ ሀይꬒ አጌና በቲ፥ ማርካበር ሶራ Ꮊማዳይስ ሙርቲ የዝን፥ አይሁድታይ ኤዛ ዎꬎዳይስ ኮዥዛና ኤሪ ማቃዶናር ጉየ ማቆዳይስ ኮዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ጳዉሎሳ ሞይዜዛ ቤራፐ ጳርሁሳ ናአ ሶጳጽሮሳ፥ ተሰሎንቀፕ አርስጽሮኮሳኔ ስኮንዱሳ፥ ደርበፕ ጋዮሳ፥ ኢስያፕ ትክቆሳ፥ ጽሮፍሞሳኔ ጽማቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","የይትታይ ቲና Ꮊንጊ ኑና ጽሮአዳል ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ኑኒ ቦራ ባለ ቦንቼዛይፕ ጉየ ፕልጲሶሳፕ ማርካበር ደንዲ፥ እችንꬃ ጋላስ ኡንታን ጽሮአዳ ሄሊ ኤዛይድ ላፑን ጋላስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ሳምንታፕ ቲና ጋላስ ኑኒ ቦራ ዎላ ማዳይስ ሺቂ የዝን፥ ጳዉሎሳ ዎንትꬃ Ꮊማዳይስ ቆፔዝ ግሾስ ኡንትስ ቃላ ኦድታር ግዲ ብላሄ ሄሎዳይስ ኦዳ አዱስሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ኑኒ ሺቂ በቴዝ ፖቃይል ፖኦ ዋዢ ጌዝን። ");
INSERT INTO mfxe_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ኤዉጽኮሳ ግንትዝ ፐቲ ፓንꬃይ ማስኮተል አፋ በቲ፥ ፋና ዶጊ ገንቴዛ። ጳዉሎሳ ኦዳ አዱሴዛይፕ ኤዉጽኮሳ ገንታ ኣፈር ሃይꬒንꬆ ፖቃይፕ ዎꬊ Ꮊይቄዛና አሳይ ደንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ዝን ጳዉሎሳ ዎꬊ፥ ኤዛል አፋ ጹጉኒ። ኤዛ እድንጊ፥ «ኤ Ꮊይቀካያ፥ ህርግፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","የይፕ ጉየ፥ ፉደ ፖቄል አፋ ከዚ ቦራ ባጺ ሜዛ። ሳአ ዎንቶድ ሄሎዳይስ አሳይስ ኦዴዛይፕ ጉየ ደንዲ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","የ ፓጼዝ ፓንꬃ ካራ ካንጊ ጋመ ኡፋይቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ዝን ጳዉሎሳ ፋና ኤዛይፕ ሞኮዳይ ጋርክ ኑስ ኦዴዛይ ግሾስ ኑ ቲናቲ ማርካበኮ Ꮊንጊ፥ አሶና Ꮊማዳይስ ደንዴዛ። አብስ ጊኮ፥ ኤ ቶከር Ꮊማዳይስ ቆፔዝ ግሾስ ኑና የይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ኤ ኑና አሶና ሄልን ማርካበር ኤዛ ኤኪ ምጽልነ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ዎንትꬃ ጋላስ ኤዛይፕ ደንዲ ማርካበር ክዮሳስ ቲና ባጋር የዝ አቃ ሄሌዛ፤ ማ ዎንትꬃ ጋላስ ሳሞሳ ፒንጊ ካልዛ ጋላስ ምልጸ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳዉሎሳ ኢስያ ጋመ ጋምኦዳይስ ኮየካ ግሾስ ኤፈሶነ ካንታር ኣꬎዳይስ ቆፔዛ። ፓስ ዳንዳእንትኮ ጰንጸቆስጸ ባለ ጋላስ የሩሳላመ ሄሎዳይስ ኤልስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳዉሎሳ ምሊጸፕ ኤፈሶና ኪቲ ዎሳ ኬꬅ ጭምታ ጼግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ዎሳ ኬꬅ ጭምታይ ኤዝኮ ይእን፥ ኡንትኮ Ꮊይ ጋርክ ዬጌዛ፦ «ታኒ ኢሳ ገሌዝ ቲና ጋላሳፕ አይኪ ይንታር የዜዝ ዎደ ኡባይድ ዋይዚ የዜዛኮ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","አይሁድታይ ማቅንቲ ታል አፋ መቶ ሄልꬅኮካ ታኒ ሃዮትꬃራኔ ጋመ አፉꬃር ጎዳይስ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","አይደካ ይ ካራ ካራ ይንታን ታማርስታር ይንታን ማዴዛይፕ ፐትባዝካ ፓጭንቸካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ታኒ አይሁድታይስኔ አይሁደ ባዝታይስ ናጋራፕ ጾስኮ ማቆዳይ ጋርከኔ ኑ ጎዳ የሱሳ አማኖዳይ ጋርክ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«ኤዛይድ ታና አብ ሄሎዳዛኮ ኤሮያ፥ Ꮊት ታኒ ጌሻ አያናስ ኪትንቲ የሩሳላመ Ꮊንግዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ዝን ጌሻ አያናይ አችኔ ዋየ ታና ናግዛና ካታማ ኡባይድ ታስ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ዝን ታ ላሶ ፖሎዳይስኔ ጎዳ የሱሳፕ ኤኬዝ ኦሳ፥ ጾስ ኣꬎ ኬሃትꬅ ዎንግለ ማርካትዛ ፖልዛ ታ ሸምፓቶ ፓꬆዋ ባዝ ጋርክ ፓይድዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«ታኒ Ꮊተካ ጾስ ካተትꬅ ማርካትታር ይ ኡቢታይ ጋንጨር ዩዬዛ። ይከፕ ጉየ ይንትፕ ኦንካ ታና በአማና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","የይ ግሾስ፥ ይንትፕ ፐቲ አስ ꬋብኮካ ታ ኦይጭንታማና Ꮊይኖ ይንትስ ምልጽ ኡዲ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ጾስ ዞረ ኡባ ይንትስ አብካ አሸካዛር ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«ፋ ኣዳስ ፋ ሱꬃር ዎዜዝ ጾሳ ዎሳ ኬꬃ ናጎይታ። ጌሻ አያናይ ይንታን ዉደ ሄንግዝታ ኡዲ ሹሜዝ ዉዳይስኔ ይ ኡባይስ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ታኒ Ꮊንጌዛይፕ ጉየ፥ ዉዳይስ ቃꬊንቶዋ ኢታ ፑግታይ ይ ጋንጨ ገሎዳና ታ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","አማንዝታ ፋ ላሳ ካልꬅዛ ዎርዶ አስታማርታይ ይ ጋንጨፕ ደንዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","የይ ግሾስ፥ ታኒ ሀይꬒ ላይꬅ ቃማኔ ጋላስ አፉꬃር ይንታን ኦማስ ኦማስ ምንꬃꬄዛ ቆፕታር ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Ꮊተካ ይንታን ምንꬆዳይስ ጌሽ አሳይር ላትሶዳይስ ዳንዳእዛ ጾስስኔ ኤ ኣꬎ ኬሃተꬅ ቃላይስ ይንታን ሀዳራ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«ታኒ ኦፐካ ብራ ዎይ ዎርቃ ዎይ አፍላ አሞተካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ታኒ ታ ኩሸር ኦꬂ ታናኔ ታር የዝታ ኮሽዛ ባዝ ማዴዛ ይ፥ ይ ኦማስ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ይ Ꮊይ ጋርክ ዳቡሪ ኦꬅታር ዳቡሬዝታ ማዶዳያኔ ጎዳ የሱሳ፥ ‹ኤክዛይፕ እንግዛይ አንጅንቴዛ› ጌዝ ቃላ ይ ቆፖዳይስ ቤዝዛ ታኒ ይንታን ኡባ ባዛር ቤዜዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ጳዉሎሳ የያ ኦዲ ሃሲ ኡ ኡቢታይራ ጉልባቲ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ኡ ኡቢታይካ ጳዉሎሳና እድንጊ ዬክታር ዬሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ኤ ማሂ፥ «Ꮊይኖፕ ጉየ ታና ይ በኣሚ» ዬጌዝ ቃላይ ኡንታን ኢታ አዛንꬄዛ። ኡንቲ ማርካባ ሄሎዳይስ ኤዛ ሞይዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ኑኒ ኤፈሶና ጭምታይፕ ሻክንቴዛን ጋርክ ማርካበር ቆሰ Ꮊንጌዛ። ዎንትꬃ ጋላስ ሩደ ሄሊ ኤዛይፕ ጳጽራ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ፕንቀ ፒንግዝ ማርካበ ደንጊ ኤዛይድ ገሊ Ꮊማዳይስ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ኑኒ ቆጲሮሳ በኤዛን ጋርክ፥ ሀድርስ ባጋ አሺ ሶራ Ꮊንጌዛ። ማርካባይ ፋ ጫና ኤዛይድ ዎꬆዳይስ ኮዬዝ ግሾስ ጽሮሳ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ኤዛይድ አማንዛ አስታ ደንጌዛ ኡንታር ላፑን ጋላስ በቴዛ። ጳዉሎሳ የሩሳላመ Ꮊንጋማይ ጋርክ ኡንቲ ኤስ አያናር ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ኑኒ ኡንታር በትዛ ዎዳይ ዉርን ከዚ Ꮊንጌዛ። ኡንቲ ኡባይ ፋ ማችታይራኔ ፋ ናእታይር ፐቲ ካታማፕ ጋጻ ከሲ ኑና ሞይዜዛ። ኑኒ አባ ላንቀ ቡንቂቲ ጾሳ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","የይፕ ጉየ፥ ዎል ሳሮꬂ ኑ ማርካባይድ ገሌዛ፤ ኡንትካ ፋ ካራ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ኑኒ አባል አፋር ኦጋ ሃሲ፥ ጽሮሳፕ ጰጸለማሳ ሄሌዛ። ኤዛይድ አማንዛ አስታ ሳሮꬂ፥ ኡ ካለ ፐቲ ጋላስ ፔዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ዎንትꬃ ጋላስ ከዚ፥ ቅሳረ Ꮊንጌዛ። ሳባኬ ፍልጶሳ ካራ ሄሊ ኤ ካለ በቴዛ። ኤ የሩሳላመ ቲን ዶርንቴዝ ላፑንታይፕ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ፍልጶሳስ ናበ ማቄዝ ኦይዲ ዉድር ናእታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ኑኒ ኡንደና ጋላስ ኤዛይድ በቲ የዝን አጋቦሳ ግዝ ናባይ ይሁዳፕ ቅሳረ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ኑኮ ይኢ ጳዉሎሳፕ ሳቃ ኤኪ ፋ ኩሻኔ ፋ ቶካ አጪ፥ «ጌሻ አያናይ Ꮊ ሳቃይ ጎዳ፥ የሩሳላመ አይሁድታይ Ꮊይ ጋርክ አጪ፥ አይሁደ ማቀካ አሳይስ ኣꬂ እማዳ ዬግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ኑኒ የያ ስኢ ኑኔ ኤዛይድ የዝ አስታይ ጳዉሎሳ የሩሳላመ Ꮊንጋማይ ጋርክ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ዝን ጳዉሎሳ ማሂ፥ «ይ Ꮊይ ጋርክ ዬክታር አብስ ታ ዎዝና ሹግሸ? ታኒ፥ ጎዳ የሱሳ ሱንꬃይ ግሾስ አች ኣዳ ባዝን የሩሳላመ Ꮊይቆዳይስካ ጊግንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ኑ ዞራ ኤ ኤካም እጽን፥ «ጎዳይ ሸነ ማቆ» ዬጊ ስኢ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ኤዛይድ ጽቃ ዎደ ጋምኤዛይፕ ጉየ ጊግንቲ የሩሳላመ Ꮊማዳይስ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ቅሳረ የዝ አማንዛ አስታይፕ ጽቅታይ ኑር Ꮊንጎይታ ጌዛ። ኡንቲ ኑኒ ሸምፖዳይስ ምናሶና ግዝ ቆጲሮሳ አꬃይ ካራ ካንጌዛ። ምናሶና ቲን አማኔዝ አሳይፕ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ኑኒ የሩሳላመ ሄልን አማንዛ አሳይ ኑና ኡፋይሳር ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ዎንትꬃ ጋላስ ጳዉሎሳ ኑር ዎላ ያይቆባኮ Ꮊንጌዛ። ዎሳ ኬꬅ ጭምታይ ኡቢታይካ ኤዛይድ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳዉሎሳ ኡንታን ሳሮꬄዛይፕ ጉየ አይሁደ ማቀካ አሳይ ጋንጨ ፋ ባጋር ጾሲ ኦꬄዝ ባዝታ ኡባ ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ኡንቲ የያ ስኢ ጾሳ ጋላቲ ጳዉሎሳኮ Ꮊይ ጋርክ ዬጌዛ፦ «ኑ እሻዮ፥ አይሁድታይ ጋንጨ ኣፑን ሙኩልታይ ጾሳ አማኔዛኮ ነ ብእዛ፤ ኡንቲ ኡባይካ ህጋ ሚንꬂ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ኔኒ አይሁደ ባዝታይ ቢታ የዝ አይሁደ ኡባይ ፋ ናእታ ዶካላማይ ጋርክ፥ አይሁድታይ ዎጋ ካላማይ ጋርከኔ ሙሰ ህጋ እጾዳይ ጋርክ ኔኒ ታማርስዛና የሩሳላመ የዝ አይሁድታይ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","የዝን አቢ ሎኦ? ኔ ይእꬃ ቱማካ ኡ ስኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«የይ ግሾስ፥ ኑኒ ኔስ ኦድዛና ስኦባ፤ ጋꬆ የዝ ኦይዲ አስታይ ኑ ካለ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ኡንታን ኤኪ ኡንታራ ጌዦባ፤ ማ ኡንቲ ፋ ኦማ ሜድንቶዳይ ጋርክ ኡንትስ ሚሸ እንጎባ። ኡንቲ ቲና ነ ባጋ ስኤዛይ ቱማ ባዛኔ ኔኒ ነ ኡባስካ ህገ ናግዛ አስ ማቄዛና ኡባይ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«ዝን አማኔዝ አይሁደ ማቀካ አስታ ማቅኮ፥ ኡንቲ ኤቃስ ያርሽንቴዝ ባዝ ማማይ ጋርክ፥ ሱꬅ ኡዣማይ ጋርክ፥ ባዉታ ማማይ ጋርከኔ ላግታማይ ጋርክ፥ ኑኒ ኦዳ አጪ፥ ኡንትስ ዳብዳበ ጻፌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","የይፕ ጉየ፥ ጳዉሎሳ ዎንትꬃ ጋላስ አስታ ኤኪ፥ Ꮊንጌዛ። ኤ ፋ ጌዥዝ ጋላሳይ አይደ ፖልንቶዳዛኮ ኤርሶዳይስኔ ፋ ያርሾ አይደ ያርሾዳዛኮ ኤርሶዳይስ ጾስ ኬꬃ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ላፑን ጋላሳይ ዉሮድ ሀኖዳር፥ ኢሳፕ የኤዝ አይሁድታይ ጾስ ኬꬃ ጳዉሎሳ ብኢ፥ አስ ኡባ ደንꬅꬂ ጳዉሎሳ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«እስሬለ አሳዮ፥ ኑና ማዶይታ፤ Ꮊ አꬃይ፥ ኑ ህጋኔ Ꮊ ጾስ ካራና እጾዳይ ጋርክ አስ ኡባ ኡባ አቆ ታማርስዛ አꬃይ Ꮊያ። የይካ ግዳም እጽን አይሁደ ባዝታ ጾስ ካራ ገልሲ፥ Ꮊ ጌሽ አቃ ቱንሴዛ» ዬጊ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ኡንቲ የያ ጌዛይ ቲና ኤፈሶና ጽሮፍሞሳና ጳዉሎሳር ዎላ ካታማይድ በኤዝ ግሾስ Ꮊት ጳዉሎሳ ጾስ ካራ ኤዛ ኤኪ ገሌዝባዝ ኡንትስ ኣዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ካታማ ኡባይ ሻርክሻርኬዛ፤ አሲ ኡባይ ሺቂ ጳዉሎሳ አይኪ ጾስ ካራፕ ጎቺ ባለ ከሴዛ። ጾስ ካራ ፐንግታይ ኤልሲ ጎርድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","አሳይ ጳዉሎሳ ዎꬎድ ሀኖዳር፥ «የሩሳላመ ካታማ ኩንꬃይ ቡቂንቴዛ» ግዝ ኦዳይ ኦሮመ ሻላቃይኮ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ሻላቃይ ዎታዳርታኔ ማቶ ሀላቅታ ኤኪ ላስታር የኤዛ። አሳይ ሻላቃኔ ዎታዳርታ ብኢ ጳዉሎሳ Ꮊꬍዛና አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","የ ዎደ ሻላቃይ ሺቂ፥ ጳዉሎሳ አይኪ፥ ናምኢ ሳንꬃላተር አጭንቶዳይ ጋርክ ኪቴዛ። ዬዚ፥ ኤ ኦናዛኮኔ አብ ኡዴዛኮ አሳ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","አሳይፕ ባጋይ Ꮊያ ግ ኡኮዳር Ꮊንክታይ የያ ግ ኡክዛ። ጫቦታይ ዳሬዝ ግሾስ ሻላቃይ ቱማ ሻኮዳይስ ዳንዳእንታም እጽን፥ ዎታዳርታይ ጳዉሎሳ ፋ የዛ አቆ ካንጎዳይ ጋርክ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ጳዉሎሳ የꬊ ከዜዝ ደꬃ ሄሎዳር አስ ኡርቅꬃይ ግሾስ ዎታዳርታይ ኤዛ ቶኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ጋመ አሳይ፥ «ኤ Ꮊይቆ!» ዬጊ ኡክታር ካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ዎታዳርታይ ጳዉሎሳ ፋ የዛ አቆ ገልሶድ ሀኖዳር፥ ጳዉሎሳ ሻላቃይኮ፥ «ታ ኔስ ፐትባዝ ኦዶዳይ ጋርክ ኡዶዴ?» ዬጌዛ። ኤ ጳዉሎሳኮ፥ «ኔኒ ግርኬ ዶና ኤርኔ? ");
INSERT INTO mfxe_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ኔኒ Ꮊይፕ ቲና ቡቅꬅ መꬊ ሸምፖ ዎꬌዝ ኦይዲ ሙኩለ አስታ ኤኪ ሊዦ ጋꬋ ገሌዝ ግብጸ አꬃይ ነና ባሳ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ዝን ጳዉሎሳ፥ «ታኒ፥ ክልቃ የዝ ኤርንቴዝ ተርሰሰ ካታማ አስ ማቄዝ አይሁደ አሲ። ሀያና ታና አሳይስ ኦድሶየ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ሻላቃይ ኤዝኮ፥ «ኦዶባ» ዬግን ጳዉሎሳ ደꬃል አፋ ኤቂ፥ አሳይ ስእ ጎዳይ ጋርክ ፋ ኩሸር ማሌዛ። አሳይ ስእ ግን እብራይስጸ ዶናር Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«ታ እሹንꬆ፥ ታ አዱንꬆ፥ ታኒ Ꮊት ይንትስ እንግዛ ማልሳ ስኦይታ።» ");
INSERT INTO mfxe_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ጳዉሎሳ ኡንትስ እብራይስጸ ዶናር ኦድዛ ስኢ ካሴሳይፕ አꬂ ስኢ አቴዛ። ኤ ዬጌዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«ታኒ ክልቃ የዝ ጸርሴሰ የልንቲ Ꮊ ካታማይድ ድጬዛ። ታ አስታማረይካ ጋማላለ፤ ታኒ ኑ አድታይ ህጋ ሚንꬂ ታማሬዛ፥ Ꮊይኖ ይ ኡባይ ሀንዛይ ጋርክ ጾሳይስ ምሽንትዛ አይሁደ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ታኒ Ꮊ ኦጋ ካልዛ ማችታይኔ ꬊራꬅታ አይኪ አች ኬꬃ ኦልታራኔ ኡንታን ዎꬍሶድ ሄሎዳይስ መቶ ቤዜዝ አሲ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","የይ ጋርከካ፥ ቄሰ ሀላቃይኔ ሻንጎ ኡባይ ታባዝ ማርካቶዳይስ ዳንዳእዛ። ታኒ ዳማስቆ የዝ ኡ እሽታይስ ኡንታፕ ዳብዳበ ኤኪ ኤዛይድ የዝ አስታይ አጭንቲ ሴርንቶድ ጋርክ የሩሳላመ ኮኦዳይስ Ꮊንጌዛ።» ");
INSERT INTO mfxe_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«ታኒ Ꮊንጊ ዳማስቆ ሄሎዳር ሴታ ጋላስ ቆፐካ ሳሎፕ ግታ ፖኦ ታ ካላይር ፖኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ታኒ ሳአ ፖኪ የዝን፥ ‹ሳኦላ፥ ሳኦላ፥ ታና አብስ ባይእኔ?› ግዝ ቃላ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ታኒ ማሂ፥ ‹ጎዳዮ፥ ኔኒ ኦኖ?› ዬጌዛ። «ኤ ማሂ፥ ‹ታኒ፥ ነ ባይእꬅዝ ናዝረተ የሱሳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ታር የዝታይ ፖአ በኤዛይፕ አትን ታስ ኦድዛ ቃላ ስኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«ታኒ፥ ‹ጎዳዮ፥ ታ አብ ኡዶ?› ዬጌዛ። «ጎዳይ ታኮ፥ ‹ደንዲ ዳማስቆ Ꮊንጎባ። ነ ኡዶዳይ ጋርክ ጾስ ቆፔዝባዝ ኡባ ባዝ ኤዛይድ ኔስ ኦድንቶዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","የ ዎልቃማ ፖአይፕ ደንዴዛይድ ታ ኣፋይ በአም እጽን፥ ታር የዝ አስታይ ታ ኩሻ አይኪ፥ ታና ጎችን ዳማስቆ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«ዳማስቆ የዝ አይሁደ ኡባይ ኡንደና ቦንችዛ ፐቲ ሀናና ግዝ አꬃይ፥ ኑ ህጋ ቦንችዛይኔ ጾሳ ሚንꬂ ዎስዛይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ሀናና ታኮ ይኢ፥ ታ ካለ ኤቂ፥ ‹ታ እሻዮ ሳኦላ፥ ቦኦባ› ዬጌዛ። ኤልሲ ታኒ ኤዛ በኦ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«ኤ ታኮ፥ ‹ኑ አድታይ ጾሳይ ኔኒ ኤ ሸነ ኤሮዳይ ጋርክ፥ ጽላ በአዳይ ጋርከኔ ኤ ዶናፕ ቃላ ስኦዳይ ጋርክ ቲናቲ ነና ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ነ በኤዝባዝኔ ስኤዝ ባዝ አስ ኡባ ቲና ኤስ ማርካ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ꮊት አብስ ጋምኤ? ደንዲ ጻማቅንቶባ፤ ኤ ሱንꬃ ጼግታር ነ ናጋራይፕ ሜጭንቶባ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«ታኒ ጉየ የሩሳላመ ማቂ ጾስ ኬꬃ ዎሶዳር፥ ታስ ቆንጭꬂ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ቆንጭꬃር ጎዳይ ታኮ፥ ‹ነ ታስ ማርካትዝ ማርካትꬃ አሳይ ኤከካ ግሾስ ኤልሲ የሩሳላመፕ ከዞባ› ዬጎዳር ታ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«ታኒ፥ ‹ጎዳዮ፥ አይሁደ ዎሳ ኬꬅ ኡባይድ ነና አማንዝታ አይኪ Ꮊꬌዛኔ አች ካራ ኦሌዛ ኡንቲ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ኡንቲ ነ ማርካ ኢስጽፋኖሰ ዎꬎዳር ታኒ የ ኦዳይድ አሳይር ቶቤዛ። ማ ኡ ካለ ኤቂ ኤዛ ዎꬌዝታይስ ማኦ ናግዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«ጎዳይ ታኮ፥ ‹ታኒ ነና አይሁደ ማቀካ አሳይኮ ሃኮ አቆ ኪቴዛይ ግሾስ ደንዲ ቅቶባ› » ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ጳዉሎሳ የ ቃላ ኦዲ ሃሶድ ሄሎዳይስ አሳይ ኤ ግዛ ስእዛ። የይፕ ጉየ፥ ፋ ቃላ ꬎቅ ኡዲ፥ «Ꮊያ ቢታይፕ ꬋብሶባ! ኤ ሸምፖር የዞዳይስ ቤዞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ኡንቲ ኡክታራኔ፥ ፋ ማኦ አፋ ዳክታራኔ ባና አፋ ደንꬆዳር፤ ");
INSERT INTO mfxe_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ሻላቃይ ብኢ ዎታዳርታይ ጳዉሎሳና ኡ ፋ የዛ አቆ ካንጎዳይ ጋርክ ኪቴዛ። ማ አሳይ አብስ የይ ጋርክ ኡክዛኮ ኤሮዳይስ ኮዪ ጳዉሎሳ አላንጋር ጋራፊ ፕላጎዳይ ጋርክ ኡንታን ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ዝን ዎታዳርታይ ጳዉሎሳ ዳፈር ሚንꬂ አጪ ጋራፎድ ሀኖዳር ጳዉሎሳ ፋ ካለ ኤቄዝ ማቶ ሀላቅታይኮ፥ «ኦሮመ አስ ፕርዳ ባይꬅ ጋራፍዛይ ይንትስ ዎጋ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ማቶ ሀላቃይ የያ ስኢ ሻላቃይኮ Ꮊንጊ፥ «Ꮊ አꬃይ ኦሮመ አሲ። ኔኒ አብ ኦꬆዳይስ ቆፔኔ?» ዬጊ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ሻላቃይ ጳዉሎሳኮ ሺቂ፥ «ኔኒ ኦሮመ አሶ? አን ታስ ኦዶባ» ዬጌዛ። ጳዉሎሳ፥ «ኤ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ሻላቃይ ማሂ፥ «ታኒ Ꮊ ጋደትꬃ ጋመ ሚሸር ዎንጌዛ» ዬጌዛ። ዝን ጳዉሎሳ፥ «ታ Ꮊ ጋደትꬃ የለትꬃር ደንጊ ኤኬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","የይ ግሾስ፥ ጳዉሎሳ ፕላጎዳይስ ቆፔዝታይ እዝር ኤፕ ሻክንቴዛ። ሻላቃይ ኦሮመ አስ ማቄዛና ኤሪ አጭሴዛይስ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ዎንትꬃ ጋላስ ሻላቃይ፥ አይሁድታይ ጳዉሎሳ አብስ ሞቴዛኮ ጌሺ ኤሮዳይስ ኮዬዛ። ቄሰ ሀላቅታይኔ ሻንጎ ኡባይ ሺቆዳይ ጋርክ አዛዜዛ፤ ማ ጳዉሎሳ አቻፕ ብልእሲ ኡ ቲና ኤሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ጳዉሎሳ ሻንጋና ዳኪ ብኢ፥ «ታ እሹንꬆ፥ ታኒ Ꮊይኖ ሄሎዳይስ ጾስ ቲና ታ የስ ኡባይድ ሎኦ ዎዝናር የዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ቄሰ ሀላቃይ ሀናና፥ ጳዉሎሳ ዶናተ ባቆዳይ ጋርክ ኤ ካለ ኤቄዛና ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","የ ዎደ ጳዉሎሳ ኤኮ፥ «ናት ነ ቦርሾንቶ ትዤዝ ጋባራ ኣዝዛዮ፥ ጾሳይ ነና ባቆዳ። ኔኒ ታል አፋ ህገ ጋርክ ፕርዶዳይስ በቲ ህገ መንꬅ ታና ባቆዳይ ጋርክ ኪትኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ጳዉሎሳ ካንታ ኤቄዝታይ ኤኮ፥ «ነ ጾስ ቄሰ ሀላቃ ጫዥኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳዉሎሳ፥ «ታ እሹንꬆ፥ ኤ ቄሰ ሀላቃ ማቄዛ ታ ኤረካያ፤ አብስ ጊኮ ጾስ ቃላይድ፥ ‹ነ ዎያ አቅስዛይል አፋ ኢታ ቃላ ኦድፐ› ግንትንቲ ጻፍንቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ዝን ጳዉሎሳ የ አቃይድ የዝ አሳይፕ ባግታይ ሳዱቃውታ፥ ባግታይ ፈርሳውታ ማቄዛና ኤሪ፥ «ታ እሹንꬆ፥ ታኒ ፈርሳወኔ ፈርሳወ ናአ፤ ‹Ꮊይቄዝታይ Ꮊይቆፕ ደንዶዳ› ግ ታኒ ኡፋይሳር ናግዛ ግሾስ ኡንቲ ታል አፋ ፕርድዛ» ዬጊ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ጳዉሎሳ የያ ጌዝ ዎደ ፈርሳውታይ ጋንጨኔ ሳዱቃውታይ ጋንጨ ካቺ ኬዝን ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","አብስ ጊኮ፥ ሳዱቃውታይ፥ «Ꮊይቄዝ አስ ደንዶያ፤ ኪታንቾካ አያንካ ባያ» ዬግዛ። ዝን ፈርሳውታይ ኡባካ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ኦላ ኡፎ ከሴዛ፤ ፈርሳውታይ ባጋ ማቄዝ ህገ አስታማርታይ ደንዲ ኤቂ፥ «Ꮊ አꬃይል አፋ አባ ቡታካ ደንጌካያ፤ ኤስ አያና ዎይ ኪታንቻይ ኦዶ አተና» ዬጊ ፓላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ካቻይ ሜእꬅ አይክን አሳይ ጳዉሎሳ ሻቅርቻማይ ጋርክ ግ፥ ሻላቃይ ፋ ዎታዳርታይ ዎꬊ ኡንታን ጋንጨፕ ኤዛ ኤልሲ ከሲ ኡ ፋ የዛ አቆ ካንጎዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","የ ቃማ ጎዳይ ጳዉሎሳ ካለ ኤቂ፥ «ጳዉሎሳ፥ ኔኒ ታስ የሩሳላመ ማርካቴዛ ኦሮመካ ማርካቶዳይስ ቤዝዛ፤ ምንጎባ፤ አኮ ባያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ዎንትꬃ ጋላስ አይሁድታይ፥ «ጳዉሎሳና ዎካዛር ካꬃ ማሚ ሃꬅ ኡዣሚ» ግ ጫቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ጳዉሎሳል አፋ የያ ማቅንቴዝ አስታይ ኦይታማፕ ጋመ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ኡንቲ ቄሰ ሀላቅታይኮኔ ጋደ ጭማታይኮ Ꮊንጊ፥ «ኑኒ ጳዉሎሳ ዎካዛር ካꬃ ግዝባዝ ማሚ ግ ጫቄዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ይኬ፥ ይንታን ሻንጋይ ኤባዝ ጌሺ ፕላጎድባዝ የዝ ኣዝሲ፥ ጳዉሎሳ ይንትኮ ኮኦዳይ ጋርክ ሻላቃ ኦይጮይታ። ኑኒ ኤ Ꮊ ሺቆ ሄሎዳይፕ ቲና ኤዛ ዎꬎዳይስ ጊጊ በቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ዝን ጳዉሎሳ ምሺ ናአይ የ ማቅንታ ስኢ Ꮊንጊ ዎታዳርታይ የዛ አቆ ገሊ፥ ጳዉሎሳስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳዉሎሳ ማቶ ሀላቅታይፕ ፐታ ጼጊ፥ «Ꮊ ናአይ ሻላቃይስ ኦድዛ ባዝ የዛ ግሾስ ኤዛ ሻላቃይኮ ካንጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ማቶ ሀላቃይ ናአ ሻላቃይኮ ካንጊ፥ «አች ካራ የዝ ጳዉሎሳ ታና ፋኮ ጼጊ፥ Ꮊ ናአይ ኔስ ኦድዛ ባዝ የዝ ግሾስ ኤዛ ኔኮ ኮኦዳይ ጋርክ ታና ዎሴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ሻላቃይ ናአይ ኩሻ አይኪ፥ ዱማ ባለ ከሲ፥ «ኔኒ ታስ ኦዶድባዛይ አባ?» ዬጊ ኦይጬዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ናአይ ሻላቃይኮ፥ «አይሁድታይ ጳዉሎሳ ባጋ ካሰፕ ሚንꬂ ፕላጎዳይስ ኮዬዝ ባዝ ኣዝሲ ኔኒ ዎንታ ኤዛ ሺቆ ኮኦዳይ ጋርክ ነና ዎሶዳይስ ዞረ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ዝን ኔኒ ኡንቲ ግዝባዝ ስእፐ። አብስ ጊኮ፥ ኦይታማፕ ጋመ አስታይ ጳዉሎሳ ዎካዛር ‹ካꬃ ማሚ፥ ሃꬄ ኡዣሚ› ግ ጫቂ፥ ቆስንቲ ኤዛ ናግዛ። Ꮊት ነ ግዝባዝ ኣዳ ስኦዳይስ ናግዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ሻላቃይ ማሂ፥ «Ꮊያ ነ ታስ ኦዴዛና ሀራ ኦስካ ኦድፐ» ዬጊ ናአ ጉየ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ሻላቃይ ማቶ ሀላቅታይፕ ናምእታ ጼጊ፥ «ቃማፕ ሀይꬒ ሳተር ቅሳረ Ꮊንጎዳይስ፥ ናምኢ ጼት ዎታዳርታ፥ ላፑን ታም ፋራ አስታኔ ናምእ ጼት ቶራንችታ ጊግሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ጋደ አቅስዛ ፍልክሳኮ ጳዉሎሳ ሳሮር ሄሎዳይ ጋርክ ቶጋ መህታ ጊግሶይታ» ዬጊ ኡ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ሻላቃይ ፍልክሳስ Ꮊይ ጋርክ ግዝ ዳብዳበ ጻፌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«ቃላዉዶሳ ሉሶሳፐ ጋደ አቅስዛ ቦንቾ ፍልክሳስ፥ ሳሮ ኔስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","አይሁድታይ Ꮊ አꬃ አይኪ ዎꬎድ ሀኖዳር፥ ኤ ኦሮመ ጋደ አስ ማቄዛያ ኤሪ ዎታዳርታይራ ሄሊ ኤዛ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ታ ኡንቲ ኤዛ አብስ ሞትዛኮ ኤሮዳይስ ኮዪ ኡንታን ኡ ሻንግታይኮ ኤዛ ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ኡንቲ ፋ ህጋይስ ኤዛ ሞቴዛይፕ አትን ኤዛ ዎꬍስዛባዝ ዎይ አጭስዝባዝ ባዛ ታ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ኡንቲ Ꮊ አꬃይል አፋ ማቅንቴዝ ዝግርሳይ ታና ሄልን፥ ታኒ ኤልሲ ኤዛ ኔኮ ዳኬዛ። ኤዛ ሞትዝታይ ነ ቲና Ꮊንጊ ሞቶዳይ ጋርክ አዛዜዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","የይ ግሾስ፥ ዎታዳርታ አዛዜዛይ ጋርክ ጳዉሎሳ ኤኪ፥ ቃማ አንትጳጽርሳ ሄልꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ዎንትꬃ ጋላስ ፓር አስታይ ኤዛ ኤኪ Ꮊማዳይ ጋርክ አሺ ቶኬ አስታይ ጉየ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ቶጋር የዝ አሳይ ቅሳረ ሄሊ ዳብዳበ ጋደ አቅስዛይስ እንጊ፥ ጳዉሎሳና ኤ ቲና ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ጋደ አቅስዛይ ዳብዳባ ናባቤዛይፕ ጉየ «ጳዉሎሳ፥ ነ አባ አዉራጃ አሶ?» ግ ኤዛ ኦይጬዛ። ኤ ክልቃ አስ ማቄዛያ ኤሪ ");
INSERT INTO mfxe_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ታኒ ነና ሞትዝታይ ይእኮ ነ ግዛ ስኦዳ» ዬጌዛ። ዎታዳርታይ ጳዉሎሳ ሄሮዶሳ ዛባ ናግንቶዳይ ጋርክ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","እችን ጋላሳፐ ጉየ ቄሰ ሀላቃይ ሀናኔ፥ ጭምታይራኔ ጸርጸሉሳ ግዝ ፐቲ አፋካታይር ዎላ ቅሳረ ቅቴዛ። ኡንቲ ጋደ አቅስዛይል አፋ ጳዉሎሳና ሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ጳዉሎሳ ጼግንቲ ገሌዝ ዎደ ጸርጸሉሳ ኤዛ Ꮊይ ጋርክ ዬጊ ሞቴዛ፦ «ቦንቾ ፍልክሳ፥ ኑኒ ነ ባጋር ኡንደና ሳሮትꬅ ደንጌዛ፥ ነ ሎኦ አቅሳይድ ኑ ቢታይ ኡንደና ላምንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ቦንችንቴዝ ፍልክሳ፥ ኑኒ አባካ አይደካ ማቅን ኡንደና ጋላታር የያ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ታኒ ነና ጋምእሰካዛር ኔኒ ነ ኬሄትꬃይር ኑባዝ ኤለር ስኦድ ጋርክ ነና ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ꮊ አꬃይ ꬉበ ማቂ ጋደ ኡባይድ የዝ አይሁድታይ ጋንጨ ጫቦ መꬊ ናዝራውታይ ባጋ አሳ ካልꬅዛ ማቄዛና ኑ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ሀራ አቶዝን፥ ጾስ ካራ ቱንሶድ ሀኖዳር ኑ ኤዛ አይኬዛ፤ ኑ ህጋይ ግዛይ ጋርክ ኤዛል አፋ ፕርዶዳይስ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ዝን ሻላቃ ሉስዮሳ ይኢ፥ ዎልቃር ኑ ኩሸፐ ኤዛ ከሲ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ኤዛር ሞትንትዝታይካ ኔኮ የኦድ ጋርክ ኪቴዛ። ኔኒ ነ ኦማስ Ꮊ አꬃ ፕላጊ ኑ ኤዛ ሞትዛ ሞታ ኡባ ኤሮዳይስ ዳንዳእዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","አይሁድታይካ፥ «Ꮊ ኦዳይ ቱማ» ግ ኤ ቆፋ ማኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ጋደ አቅስዛይ ጳዉሎሳ ኦዶድ ጋርክ ማልን ጳዉሎሳ Ꮊይ ጋርክ ዬግ ማሄዛ፦ «ኔኒ ኡንደና ዎደፕ አይኪ፥ Ꮊ አሳይስ ፕርድታር የዛና ኤሪ ታኒ ኦዳይስ ኡፋይሳር ማህꬅ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ታኒ ጎይኖዳይስ የሩሳላመ ኬዝን ታጶ ናምኢ ጋላሳፕ ኣꬎዛና ኔኒ ነ ኦማስ ኤሮዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","አይሁድታይ ታና ጾስ ካራ ማቅን አይሁደ ዎሳ ካራ ማቅን ካታማ ማቅን ኦራካ ፓላሞዳር ዎይ አስ ሺሺ ሳሮ ꬋብሶዳይስ ቶቦዳር ፐቲ አስካ ታና ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ꮊተካ ኡንቲ ታና ሞትዛባዛይስ ማርካ ደንጎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«ዝን ታኒ ፐትባዝ አማንዛ፤ ታኒ ህገር የዛባዝኔ ናብታይ ጻፌዝ ኡባ ባዝ አማኒ፥ ኑ አድታይ ጾሳ፥ ኡንትካ ዎርዶ ግዝ ኦጋይር ታ ጎይንዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ኡንቲ ፋ ኣዳስ አማንዛይ ጋርክ ጽልታይኔ ጽሎባዝታይካ Ꮊይቆፕ ደንዶዳና ታካ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","የይ ግሾስ፥ ታኒ ጾስ ቲናኔ አስ ቲና ኡባ ዎደ ሎኦኔ ካሃማ ዋዝና ታስ የዞዳይ ጋርክ ሚንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«ታኒ የሩሳላመፐ ከዜዛይፕ ኡንደና ላይꬃፕ ጉየ ታ ዳቦ ማንቅታይስ ማዴ እማዳይስኔ ያርሾ ያርሾዳይስ የሩሳላመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ታኒ ጾስ ካራ የያ ኡዲ ቃሾ ዎጋ ፖሊ ማቅን ታና ደንጌዛ። የ ዎደ ታራ ጋመ ዎያ ባያ፥ ካችካ ከዘካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ዝን ኢሳፕ የኤዝ ፐቲ ፐቲ አይሁድታይ ኤዛይድ የዛ፤ ኡንቲ ታል አፋ ኦዳ ኮይኮ ይኢ ታና ኔል አፋ ሞቶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ዎይ ታኒ ሻንጎ ቲና ሺቄዝ ዎደ ኦꬄዝ ቡታ የዝኮ Ꮊይትታይ ነ ቲና የዝታይ ኦዶ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","‹ታኒ ኡ ጋንጨ ኤቂ፥ Ꮊይቄዝታይ ደንዶዳ› ግ ኡኪ ኦዴዝ ግሾስ Ꮊይኖ ይ ቲና ፕርዳስ ሺቄዛ፥ የይፕ ሀራ ባዝ ኦꬄካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ዝን ፍልክሳ ጎዳይ ኦጋይ ባጋ ጌሺ ኤሬዝ ግሾስ «ታኒ ይ ኦዳ ጋቼዛ» ዬጊ ዎዳ አዱስሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ማቶ ሀላቃይ ጳዉሎሳና ናግታር ማዶድ ጋርከኔ ኤ ዳብታይፕ ኦንካ ኦይጮዳይስ የኦዳር ካያማይ ጋርክ ማቶ ሀላቃይስ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ጽቃ ጋላሳፕ ጉየ፥ ፍልክሳ አይሁደ ባጋ ማቄዝ ፋ ማቻት ድሩስላራ ይኢ ጳዉሎሳ ኪቲ ክእሲ ክርስቶሳ የሱስ አማኖ ባጋ ኤፕ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ጳዉሎሳ ጽሎትꬅ ባጋ፥ ፋ ኡባ አቅሶ ባጋኔ የኦዳይስ የዝ ፕርዳ ባጋ ኦዶዳር፥ ፍልክሳ ያሽቲ፥ «ኔኒ Ꮊተስ ቅቶባ ታስ ጊጌዝ ዎደ ነና ጼግሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","የ ዎደ ጳዉሎሳፕ ጉቦ ኤኮዳይስ ቆፒ ኤዛ ማሂ ማሂ ጼጊ ኤሪ ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ናምኢ ላይꬃፕ ጉየ፥ ፍልክሳ አቃና ጶርቂዮዳ ፍስጾሳ ኤኬዝ። ፍልክሳ አይሁድታ ኡፋይሶዳይስ ከዚ ጳዉሎሳ ብለካ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፍስጾሳ ፋ አቅስዛ አዉራጃ ገሊ ሃይꬒንꬆ ጋላሳፕ ጉየ ቅሳረፕ የሩሳላመ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ኤዛይድ ቄሰ ሀላቅታይኔ አይሁድታይ ባይርታይ ጳዉሎሳ ሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ጳዉሎሳና የሩሳላመ ኮኦር ፓስ ሎኦ ባዝ ኦꬆዳይ ጋርክ ግ ፍስጾሳና ኡ ዎሴዛ። የያካ ጌዛይ ኦገል ቆስንቲ ኤዛ ዎꬎዳይስ ኡንትስ ጊጎዳይ ጋርከ ");
INSERT INTO mfxe_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፍስጾሳ ኡንትኮ፥ «ጳዉሎሳ፥ ቅሳረ አች ካራ የዛ፤ ታኒ ታ ኡባስካ ኤልሲ ገድ ጉየ ማቃድ ሀንዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ኤ ቡቴዝባዝ የዛኮ ይ ጋንጨ ማዉተር የዝታይ ታር ቅሳረ Ꮊንጊ ኤዛ ሞቶ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፍስጾሳ ኡ አቻ ሆስፑን ዎይ ታጲ ጋላስ ጋርክ ጋምኤዛይፕ ጉየ ቅሳረ ቅቴዛ። ዎንትꬃ ጋላስ ፕርዳ ኦይደል በቲ ጳዉሎሳ ኮኦዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ኤ ይእን የሩሳላመፕ የኤዝ አይሁድታይ ኤ ካላይድ ኤቂ ኡንቲ ላꬆዳይስ ዳንዳኦዋ ዴጾ ሞቶ ሺሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳዉሎሳ ማሂ፥ «ታኒ አይሁደ ህጋ ማቅን ጾስ ካራ ዎይ ኦሮመ ካታ ቄሳረካ ቆሄካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ዝን ፍስጾሳ አይሁድታ ኡፋይሶዳይስ ከዚ ጳዉሎሳኮ፥ «የሩሳላመ Ꮊንጊ Ꮊ ሞታይባጋ ኤዛይድ ታ ቲና ፕርድንቶዳይስ ኮይኔ?» ዬጊ ኦይጬዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ዝን ጳዉሎሳ፥ «ታኒ ፕርድንቶዳይስ ቤዝዛ ቄሳረ ፕርደ ኬꬃ ኤቄዛ። ኔኒ ሎእꬂ ኤርዛይ ጋርክ ታኒ አይሁድታ አባራካ ቆሄካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ይኬ፥ ታኒ ቆሄዝባዝ Ꮊይቆስካ ሄልꬅዛ ባዝ ቡታ ኦꬄዝባዝ ማቅኮ Ꮊይቆፕ ታና አሾባ ጋሚ። ዝን ኡንቲ ታና ሞትዛ ሞታይ ጨረ ማቅኮ ኦንካ ታና ኡንትስ አꬂ እንጎዳይስ ዳንዳኦያ። ቄሳረ ታባዝ ፕርዶ ግ ኦይጭዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","የ ዎደ ፍስጾሳ ፋ ዞራንችታይራ ዞርንቲ፥ «ኔኒ ቄሳረ ታባዝ ፕርዶባ ግ ኦይጬዛ፤ ቄሳረኮ Ꮊንግዛ» ዬጊ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ጽቃ ጋላሳፕ ጉየ ካታይ አግርጳኔ ባርኒቀ ፍስጾሳ ሳሮꬆዳይስ ቅሳረ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ኤዛይድ ኡንቲ ኡንደና ጋላስ ጋምእን፥ ፍስጾሳ ካዋይስ ጳዉሎሳባጋ Ꮊይ ጋርክ ዬጊ ኦዴዛ፤ «ፍልክሳ ብለካ አሺ Ꮊንጌዝ ፐቲ አꬃይ Ꮊይዳ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ታኒ የሩሳላመ Ꮊንጌዝ ዎደ ቄሰ ሀላቅታይኔ አይሁደ ጭምታይ ኤዛል አፋ ፕርዶዳይ ጋርክ ታና ዎሲ ኤባዝ ታስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ታኒ፥ ‹ሞትንትዛ አꬃይ ታና ሞትዝታይ ቲና ኤቂ ፋና ሞቴዝባዛይስ ማህꬅ እንገካዝን፥ ኦና ማቅኮካ ኣꬊ እንግንትዛይ ኦሮመ ዎጋ ባያ› ዬጊ ኡንትስ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","«የይ ግሾስ፥ ኡንቲ Ꮊይዳ ሺቄዝ ዎደ ታኒ ጋምኤካ ዎንትꬃ ጋላስ ፕርደ ኬꬅ ገሊ ጳዉሎሳ ኮኦዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ኤዛ ሞትዝታይ ኤ ካንታር ማር ኤቂ፥ ኢታባዛር ኤዛ ሞተካ አሸና ግ ታኒ ቆፔዛይ ጋርክ ኤዛ ሞተካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ዝን ኡንቲ ፋ አማኖ ባጋኔ ጳዉሎሳ፥ ‹ኤ ፓꬅ የዛ› ግዝ Ꮊይቄዝ የሱሳ ግንትንትዝ አꬃይ ባጋ ኤዛር ፓላምዛዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ታካ Ꮊ ኦዳ ሻኮዳይስ መትꬄዝ ግሾስ ጳዉሎሳ የሩሳላመ Ꮊንጊ፥ ኤዛይድ ፕርድንቶዳይስ ኮይዛኮ ግ ኤዛ ኦይጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ዝን ጳዉሎሳ ፋ ኦዳ ቄሳረ ብሎድ ሄሎዳይስ አች ኬꬃ ጋምኦዳይስ ኦይጬዛ። ታኒ ኤዛ ቄሳረኮ ዳኮድ ሄሎዳይስ ኤ አጭንቶዳይ ጋርክ ኪቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","የይ ግሾስ፥ አግርጳ ፍስጾሳኮ፥ «ታኒ ታ ኡባስካ የ አꬃይ ግዝባዝ ስኦዳይስ ኮይዛ» ዬጌዛ። ፍስጾሳ ኤኮ፥ «ኔኒ ዎንታ ኤ ግዝባዝ ስኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ዎንትꬃ ጋላስ አግርጳኔ ባርንቀ ግታ ቦንቾር ሻላቅታይራኔ ካታማ የዝ ዎልቃማ አስታይር ይኢ ፕርደ ኬꬃ ገሌዛ። ፍስጾሳ ጳዉሎሳ ጼግሲ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ፍስጾሳ፥ «ካት አግርጳ፥ Ꮊይዳ ኑር የዝ አስታዮ፥ አይሁድታይ የሩሳላመካ Ꮊይ ጋርክ ኡኪ፥ ‹ኤ ይከፕ ጉየ ፓꬅ የዞዳይስ ቤዞያ› ዬጊ፥ ታና ዎሴዝ አꬃ Ꮊያ ይ ብእዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ዝን ኤዛ Ꮊይቆስ ሄልꬅዛ ባዝ አብካ ታኒ ደንገካያ። ኤ ፋ ኦማስ፥ ‹ቄሳረ ታባዝ ፕርዶ ዬጊ ኦይጬዛ› ጌዝ ግሾስ ቄሳረኮ ኤዛ ዳኮዳይስ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ታኒ ኤባዝ ታ ካት ቄሳረስ ጻፍስዛ ኦገ አብካ ባያ። የይ ግሾስ፥ ኤባዝ ይ ብእኮ ታ ጻፍዛይ በንቶዳዛኮ ግ ይ ቲና ኡባራካ ካት፥ አግርጳ፥ ነ ቲና ኤዛ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","አብስ ጊኮ፥ አጭንቴዝ አስ ꬎቃ ዳይናስ ኣꬅታር ኤ አብስ ሞትንቴዛኮ ኤርሰካዛር አሽዛይ ታስ ቦዘትꬅ ኣዝዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","አግርጳ ጳዉሎሳኮ፥ «ኔኒ ነ ባጋ ኦዶዳይስ ዳንዳእዛ» ዬጌዛ። የ ዎደ ጳዉሎሳ ፋ ኩሸ ደንꬂ Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ካት፥ አግርጳ፥ አይሁድታይ ታና ሞቴዝ ባዝ ኡባይስ ማህꬅ እንጎዳይስ Ꮊይኖ ነ ቲና ኤቂታር ታ አንጃይ ሎኦ ግ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","የይካ ኔኒ አይሁደ ዎጋኔ ፓላማ ኡባ ሎእꬂ ኤርዛ የይ ግሾስ ታና ዳንዳአር ስኦዳይ ጋርክ ታ ነና ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«ታኒ ናአትꬃፕ አይኪ ታ አሳይ ጋንጨራኔ የሩሳላመ የዜዝ ታ የሳ አይሁደ ኡባይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ታኒ ቲናፕ አይኪ፥ ኑ አማኖ ዎጋ ሚንꬂ ናግዛ ፈርሳውታይ ባጋይፕ ማቄዛና ኡንቲ ማርካቶዳይስ ኮይኮ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ꮊተካ ታኒ ጾስ ኑ አድታይስ እንጎድ ጌዝ ኡፋይሳ ናግዛ ግሾስ ሞትንቲ Ꮊይዳ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ማ ታጶ ናምኢ ኑ አድታይ ሼሻይ ጾሳ ቃማኔ ጋላስ ሚንꬂ ጎይንታር ጾስ እንጎድ ጌዛ ኤኮዳይስ ኡፋይሳር ናግዛ። ካት አግርጳ፥ አይሁድታይ ታና ሞትዛይ ታኒ ኡፋይሳር የያ ናግዛ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ጾስ Ꮊይቄዝታ ደንꬅዛያ ማቄዛይ ይ ካንታ አብስ አማንንቶሳ? ");
INSERT INTO mfxe_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«ብኒ ታኒ ታ ኡባስካ ናዝረተ የሱሳ ሱንꬃ እጽዛ ዳንዳእንቴዝባዝ ኡባ ኦꬆዳይስ ቤዝዛ ግ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ታኒ የሩሳላመ ኦꬄዛይ Ꮊያ። ቄሰ ሀላቅታይፕ ማዉተ ኤኪ ጾሳ አስታይፕ ጋምታ አጭሴዛ። ኡንታን ዎꬎዳር ኡ Ꮊይቆዳና ታ ዶሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ጋመ ዎደ አይሁደ ዎሳ ኬꬅ ኡባይድ ኡንቲ ሴርንቶዳይ ጋርከኔ የሱሳና ጫዦዳይ ጋርክ ታ ዎጽቴዛ። ታኒ አቆፕ ኣꬂ ኡንታን ካጬዛ ሀራ አቶዝን፥ ሀራ ቢታ ካታምታ ሄሎዳይስ Ꮊንጊ ታ ኡንታን ባይእꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«ታኒ Ꮊ ኦዳይስ ቄሰ ሀላቅታፕ ማዉተኔ ኪታ ኤኪ ዳማስቆ Ꮊንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ካታዮ፥ ታኒ ሴታ ጋላስ ኦገል የዝን አዋ ፖኦፕ ሎእꬂ ኣꬊዝ ፖኦ ታ ዩሻይራኔ ታራ Ꮊንግዝታይ ዩሻይር ሳሎፕ ፖኦዳር በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ኑኒ ኡባይካ ሳአ ፖኬዝን እብራይስጸ ዶናር፥ ‹ሳኦላ፥ ሳኦላ፥ ታና አብስ ባይꬅኔ? ኔኒ ነና ጫድዛ ብራታ ቃክኮ ነና ቆህዛ› ዬጊ ታስ ኦዶዳር ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«ታኒ፥ ‹ጎዳዮ፥ ኔኒ ኦኖ?› ዬጌዛ። «ጎዳይ፥ ‹ታኒ፥ ኔኒ ባይእꬅዝ የሱሳ፤ ");
INSERT INTO mfxe_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ዝን ደንዶባ። Ꮊይኖ ኔኒ በኤዛይፐኔ ቲናፕ ታ ነና ቤዞዳና ሀራስ ማርካቶዳይ ጋርክ ታስ ኦሳንቾ ኡዲ ነና ሹሞዳይስ ኔስ ታ በንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","እስሬለ አስታይፐኔ ታኒ ነና ኡንትኮ ኪትዛ አይሁደ ባዝታይፕ ነና አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ኔኒ ኡ አፋ ዶዮዳይ፥ ꬉማፕ ፖኦኮ፥ ጻላሄ ኩሸፕ ጾስኮ ኡንታን ማሆዳ። ኡንቲ ታና አማኒ ናጋራ አቶትꬅ ኤኮዳ። ጾስ ጌሼዝ አሳይ ጋንጨ ፋ ላታ ደንጎዳ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«ካት አግርጳ፥ የይ ግሾስ፥ ታስ ሳሎፕ በንቴዝ ቆንጭꬃይስ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ዝን ታኒ ቲናቲ ዳማስቆ የዝታይ የይፕ ጉየ የሩሳላመኔ ይሁዳ ቢታ ኡቢታይድ የዝታይኔ አይሁደ ባዝታይካ ፋ ናጋራፕ ጾስኮ ማቆዳይ ጋርከኔ ናጋራይፕ ማቆዳይስ ቤዝዛ ኦሶ ኦꬆድ ጋርክ ቃላ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","የይ ግሾስ፥ አይሁድታይ ታና ጾስ ካራ አይኪ ዎꬎዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ꮊይኖ ሄሎዳይስ ጾስ ማዴ ታፕ ሻክንተካያ፤ የይ ግሾስ፥ ጽቅታይስኔ ዳምታይስ ማርካትታር Ꮊይዳ ኤቄዛ። ናብታይኔ ሙሰ ሀኖዳ ግ ኦዴዛይፕ ሀራ ፐትባዝካ ታኒ ኦዴዝባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","የይካ፥ ‹ክርስቶሳ ዋየ ኤኮዳይስ ቤዝዛ፤ ማ Ꮊይቆፕ ቲና ደንዲ አይሁድታይስኔ አይሁደ ባዝታይስ ፖኦ ቤዞዳይስ ኤስ ቤዝዛ› ጌዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳዉሎሳ የያ ዬጊ ማሆዳር፥ ፍስጾሳ ፋ ቃላ ꬎቅ ኡዲ፥ «ጳዉሎሳ፥ ነ ኤዬዛ፤ ነ ጋመ ትምርታይ ነና ኤይሶስ ሄልꬄዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ዝን ጳዉሎሳ፥ «ቦንቾ ፍስጾሳ፥ ታኒ ቱማባዝኔ ቤዝዛ ባዝ ኦድዛፕ አትን ኤየካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ታኒ ቆንጨ ኦድዛ ኦዳ ካታይ ኤርዛ። Ꮊ ኦዳይ ጌማ ኦስንተካ ግሾስ ፐታካ ኤፕ ቆስንቲ አታማያ ታኒ ሎእꬂ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","«ካት አግርጳ፥ ኔኒ ናብታ አማንኔ? ኔኒ ኡንታን አማንዛና ታኒ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ካታይ አግርጳ፥ ጳዉሎሳኮ፥ «Ꮊ ጽቃ ሳታይድ ታና ክርስታኔ ማሆዳይስ ኮይኔ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳዉሎሳ፥ «ጋመ ዎደ ማቅን ጽቃ ዎደ ነ ኣዳ ባዝን Ꮊይኖ ታ ኦዳ ስእዝ ኡባይ Ꮊ አቻይፕ አትን ታ ጋርክ ማቆዳይ ጋርክ ታ ጾስ ዎስዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","የይፕ ጉየ፥ ካት አግርጳ፥ ጋደ አቅስዝ ፍስጾሳ፥ ባርንቀኔ ኡንታር በቴዝ ኡቢታይካ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","የይፕ ከዚ Ꮊንግታር ፐታይ ፐታይር፥ «Ꮊ አꬃይ Ꮊይቆስ ዎይ አችስ ሄልꬅዛ ባዝ አኮካ ኦꬄካያ» ዬጊ ኦድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","አግርጳ ፍስጾሳኮ፥ «Ꮊ አꬃይ ‹ቄሳረ ታባዝ ፕርዶ› ጌካዛኮ ብልንቶዳይስ ዳንዳእዛዝን አቴዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ኑኒ ማርካበር ኢጻለ ዳኮዳይስ ኡ ሙርቴዝ ዎደ ካትታይ ካት ዎታዳርታ ግንትንትዝታይፕ ፐቲ ዩልዮሳ ግዝ ማቶ ሀላቃይስ ጳዉሎሳኔ ሀራ ጽቃ አች አስታ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ኢሳ ላንቀ የዝ ሄርታ Ꮊንጎዳር አድራምጾሳ ማርካበ ገሊ ደንዴዛ። ማቃዶና አስ ማቄዝ ተሰሎንቀ አርስጽሮኮሳ ኑር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ዎንትꬃ ጋላስ ኑኒ ስዶና ሄሎዳር፥ ዩሎሳ ጳዉሎሳስ ቃꬊንቲ ፋ ላግታይኮ Ꮊንጊ ኮሽዛ ባዝ ማድንቶዳይ ጋርክ ኡንትኮ ዳኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","የይፕ ደንዲ ኑ ቲናር ጫርክዛ ግሾስ ሃꬃር ተቅንቴዝ ቢታ፥ ቆጲሮሳር ምይꬂ ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ክልቃኔ ጵንፍላ የዝ አባ ፒንጊ ሉቃ የዝ ሙራ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ኤዛይድ ማቶ ሀላቃይ ኢጻለ Ꮊንግዝ ኢስክንድረ ማርካበ ደንጊ፥ እዘ ኑና ገልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ኑኒ ጋመ ጋላስ ሎደራ Ꮊንጊ፥ ጋመ ኡንአር ቃንዶሳ ካታማ ካለ ሄሌዛ። ኤዛይር Ꮊንጎዳይስ ኑና ጫርኮ ካይን ሳልሞናር ኣꬊ ሃꬃር ተቅንቴዝ ቢታ፥ ቃርጼሳ ምይꬂ ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ጋመ መቶር ጋጻ ጋጻ አይኪ ላሳ ካታማስ ኡከ የዝ ሎኦ ግንትንትዝ ማርካበ ሸምፕዛ ሄራ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ኑኒ ኤዛይድ ኡንደና ዎደ ጋምኤዛይፕ ጉየ ጾማ ዎደ ኣꬌዝ ግሾ፥ ማርካበር Ꮊሞ መትዛ ግሾስ ጳዉሎሳ ኡንታን ዞሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«ይንታኖ አስታዮ፥ ኑ Ꮊማይ ግታ ꬋቦኔ ጋመ ቆሆ የዛይ ታስ በንትዛ፤ ቆሀይ ጫናል አፋኔ ማርካበል አፋ ኣዳ ባዝን ኑ ሸምፓይል አፋካ ሄሎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ዝን ማቶ ሀላቃይ ጳዉሎሳ ጌዛይፕ ኣꬂ ማርካባ ላግዛይኔ ማርካባ ጎዳይ ግዛ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","የ አባ ዶና የዝ ካታማይ ባልጎ አግና አꬆዳይስ ኡንትስ ጊገካ ግሾስ ጋመ አስታይ ፓስ ዳንዳእንትኮ ፍንቀ ካታማ ሄሊ ባልጎ አጌና ኤዛይድ አꬆዳይስ ዞርንቴዛ። ፍንቀ አዋ ገሎስ ፑደ ባጋፐኔ አዋ ገሎፕ ሱለ ባጋስ ጋንጨ አባ ካንታ የዝ ማርካበ ኤቂ ጫን ዎꬍስዝ አቆ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ካዉሻ ሱለ ጫርኮ ሎዳር ጫርኬዝ ዎደ ፋ ቆፔዛይ ጋርክ ሀኔዝባዝ ኣዝን ደንዲ፥ ማርካበ ኤንአማይ ጋርክ አይክዝ ብራታ ኡዴ ኤኪ ቃርጼሳ ካንታር ኣꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ዝን ጋመ ጋምኤካዛር «አዉራቅሳ» ግዝ ዎልቃማ ጎተ ሃꬃር ተቅንቴዝ ቢታፕ ሱለ ኡንታል አፋ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","የ ጎታይ ማርካባ ኡርቂ Ꮊሞ ካዬዝ ግሾስ ጫርካይ ማርካባይ ፋ ዶሴዝ ኦገ ካንጎዳይ ጋርክ አሺ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ኑኒ ቄዳ ግዝ ሃꬃር ተቅንቴዝ ቢታ ምይꬅ Ꮊንግታር ጋመ መትንቲ ማርካብት ዎጎልቶ አይኪ አሾዳይስ ዳንዳኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ኡንቲ ዎጎላ ፑደ ከሴዛይፕ ጉየ ዎዶሮር ማርካባይል አፋ ጻጺ፥ ሚንꬂ አጬዛ። ስርቲሳ ግዝ ሻፈል ዶምእንቶዳ ግ ህርጊ፥ ማርካበ ሻራ ዎꬂ ማርካባይ ጨረ ላግንቶድ ጋርክ ዳኪ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ጎታይ ዎልቃምታር Ꮊንግን ዎንትꬃ ጋላስ ጫናይፕ ባጋ አባ ጋንጨ ኦሎ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ሃይꬒንꬆ ጋላስ ማርካበ ሚሸ ኤኪ ኑ ኩሻይር ꬉጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ኑኒ ጋመ ጋላስ አዋኔ ጾልንቶ በኤካዛይ ግሾኔ ዎልቃማ ጫርኮ ኑል አፋ ምንጌዝ ግሾስ ቲናፕ ሸምፖር አቶዳ ግ ቆፐካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","የ ዎደ ኡንቲ ኡንደና ጋላስ ካꬃ ሜካ ጋምኤዝ ግሾስ ጳዉሎሳ ኡ ጋንጨ ደንዲ ኤቂ፥ «አስታዮ፥ ይ ታ ዞራ ኤኪ ቃርጼሰፕ ደንደካዛኮ Ꮊ መታይኔ ቆሀይ ኑና ሄላምዝን። ");
INSERT INTO mfxe_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ዝን ታኒ ይንታን ያሽትፓተ ግ ዞርዛ፤ አብስ ጊኮ፥ Ꮊ ማርካባይ ꬋቦዳይፕ አትን ይንትፕ ፐቲ አስ ሸምፖካ ꬋበና። ");
INSERT INTO mfxe_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ዝን ቃማ ታ ኤባዝ ማቄዛይኔ ታ ጎይንዛ ጾሳይ ኪቴዝ ኪታንቻይ ታ ካለ ኤቂ፥ ");
INSERT INTO mfxe_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹ጳዉሎሳ፥ ያሽትፐ፤ ኔኒ ኦሮመ ካታይ ቄሳረ ቲና ኤቆዳይስ ቤዝዛ። ዬዛኮ ጾስ ነ ግሾስ ኔር Ꮊንግዝታ ኔስ እንጌዛ› ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","የይ ግሾስ፥ አስታዮ፥ ያሽፓተ። የ ኪታንቻይ ታስ ኦዴዛይ ሀኖዳና ታኒ ጾሳል አማንንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ዝን ጫርኮ ኑና ካንጊ ፐቲ ሃꬃር ተቅንቴዝ ቢታ ጋጻ ኦሎዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ታጶ ኦይዳንꬆ ቃማ አድራ አባ ኑና ጫርካይ ገደኔ Ꮊና ኡርቆዳር፥ ግዲ ብላሄ ማቄዝ ዎደ ማርካበ ኦꬅዝታይስ ቢታኮ ኡኬዛ አዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ኡንቲ ጪሞትꬃ ኤሮዳይስ ኮዪ ዎዶሮ ጼራ ዴጽዛባዝ አጪ አባ ጋንጨ ኦልን፥ አባይ ሆስፑን ታም Ꮊꬋ ማቄዛ። ጽቃ ጋምኢ፥ ማሂ ኦልን ኡሱፑንታም Ꮊꬋ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ኡንቲ አባ ጋጻ የዝ ሹቻር ዶምእንታማይ ጋርክ ያሽቲ፥ ማርካባይ Ꮊንጋማይ ጋርክ አይክዝ ኦይዲ ብራትታ ማርካባይፕ ጉየር አባ ኦሊ፥ ሳአ ዎንቶዳይ ጋርክ ጾስ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ማርካበል ኦꬅዝታይ ማርካባይፕ ዎጺ ከዚ፥ ማርካባይ Ꮊንጋማይ ጋርክ አይክዝ ብራትታ ማርካባይፕ ቲና ባጋር አባ ኦልዛ ኣዝን ዎጎላ አባ ጋንጨ ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ጳዉሎሳ ማቶ ሀላቃይኮኔ ዎታዳርታይኮ፥ «የይትታይ ማርካባይድ ሸምፒ በታም እጽኮ ይ አቶዳይስ ዳንዳኦዋ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","የይ ግሾስ፥ ዎታዳርታይ ዎጎላይ አጭንቴዝ ዎዶራ ጋቺ ዳኪ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ሳአ ዎንቶድ ሀኖዳር ኡቢታይ ካꬃ ማዳይ ጋርክ ጳዉሎሳ አሳይኮ፥ «ይ ካꬃ ሜካ ናግታር Ꮊይኖር ታጶ ኦይዲ ጋላስ ጋምኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","የይ ግሾስ፥ ጽቃ ካꬃ ይ ማዳይ ጋርክ ታ ይንታን ዎስዛ። ይንትስ ሎኦ ማቃዳ፤ ሀራ አቶዝን ይ ኦማ ብናናይፕ ፐታካ ꬋባሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ጳዉሎሳ የያ ግ ቦራ ኤኪ ኡባይ ቲና ጾስ ጋላቴዛ፤ ባጺ ሙንታ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ኡባይ ሚንጊ ፋ ኡባስ ካꬃ ኤኪ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ኑኒ ማርካባይድ የዝታይ ናምኢ ጼታኔ ላፑን ታም ኡሱፑን። ");
INSERT INTO mfxe_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ኡንቲ ም ምዤዝ ዎደ ጫኔዝ ግስታ አባ ጋንጨ ኦሊ ማርካባይ ዴጻ ሻዉክሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ሳአ ዎንትን ማርካባ ኦሳንችታይ አባ ሄሌዛኮ ኤረካዛር፥ አባ ጋጻ የዝ ሻፈኔ ስልማ በኤዛ። ፓስ ዳንዳእንትኮ ማርካባ የ ስልማይኮ ሺሾዳይስ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ዬዚ፥ ማርካባይ Ꮊንጋማይ ጋርክ አይክዝ ብራትታ ብልእ አባ ጋንጨ ኦሌዛ። የ ዎደ ላግዛ ምꬃ አጭዝ ዎዶራ ብልኤዛ። የይፕ ጉየ፥ ጫርካይ ማርካባ ቲና ኡርቆዳይ ጋርክ ማርካባ ካንግዛ ሻራ ቲና ባጋር ꬎቅ ኡዲ Ꮊሞ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ዝን ማርካባይ ሻፈ ደꬃር ዶምእንቲ ምትንቴዛ። ማርካባይስ ቲና ባጋይ ሞግንቲ ኤንአም እጽን፥ ጉየ ባጋይ ዙሎ ኡርቅꬃይፕ ደንዲ መቅቶ አይኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ዎታዳርታይ አች አሳይፕ ፐታካ ሃꬃ Ꮊꬊ ኬዛማይ ጋርክ ኡንታን ዎꬎዳይስ ቶቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ዝን ማቶ ሀላቃይ ጳዉሎሳ አሾዳይስ ቆፕ ዎታዳርታይ ቶባ እጼዛ። ሃꬄ Ꮊꬎ ኤርዛ ኡባይ ማርካባይፕ ሃꬃይድ ዶንጊ ዶንጊ ዎꬊ ቲናቲ ጋጻ ከዞዳይ ጋርክ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","አቴዝታይ ሳንቃል አፋኔ፥ ማርካበ መቃይል አፋ ከዞዳይ ጋርክ ኪቴዛ ኡባይ ጋጻ ሳሮር ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ኑኒ ጋጻ ሳሮ ከዜዝ ዎደ ሄሌዝ ሃꬃር ተቅንቴዝ ቢታይ ማላጻ ግንትንትዛና ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ማላጻ አሳይ ኑና ቃꬊ ኡፋይሳር ኤኬዛ። እራ ቡክዛ ግሾኔ ሜግዛ ግሾስ ታማ ኤꬂ ኑና ኡባ ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳዉሎሳ ጋመ አፍራ ሺሺ ታማ ጋዶዳር፥ ሾሺ ታማይ ምቼዝ ግሾስ ከዚ ኤ ኩሻይል አፋ ጻጽንቲ ኤዛ ዱኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ማላጻ አሳይ ሾሺ ጳዉሎሳ ኩሻይል ጻጽንቴዛ ብኢ ፐታይ ፐታይኮ፥ «ቱማ Ꮊ አꬃይ ሸምፖ ዎꬌዝ አስ፤ ሀራ አቶዝን አባፕ ኤ አትንካ ጾሳ ፕርዳይፐ አቲ ፓꬅ የዞዳይስ ዳንዳኤካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ዝን ጳዉሎሳ ፋ ኩሻይፕ ሾሻ ዉጻርኪ፥ ታማ ኦሌዛ፤ ኤዛ አኮካ ቆሄካ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ኡንቲ፥ «ኤ አሰትꬃይ አይደፕ አይደ፥ ኤልዛ ዎይ ፖኪ Ꮊይቅዛ» ግ ናግዛ። ዝን ኡንደና ዎደ ናጌዝን ኤ አሰትꬃይል አብካ ላምንቴዝባዝ ꬋብን፥ «Ꮊይ ቱማ ጾሰ» ዬጊ ፋ ቆፋ ላሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","የ ሄራ ሃꬃር ተቅንቴዝ ቢታይስ ሀላቃ፥ ፑፕሎሳ ግዛይስ ጋደ የዛ፤ ሀይꬒ ጋላስ ሄሎዳይስ ኤ ኑና ሲቆር ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ፑፕሎሳ አዳይ ኦጸ፥ ምሻራኔ ጉሶር ሀርግንቲ ዎይኢ የዛ። ጳዉሎሳ ኤ ካራ ገሊ ኤስ ጾሳ ዎሴዛ፤ ፋ ኩሻ ኤዛል አፋ ጋዲ ፓꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","የይፕ ጉየ፥ ማላጻ የዝ ሀርግንትዛ ሀራ አስታይካ ይኢ ፓጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ኡንቲ ኑና ጋመ ቦንቼዛ፤ ኑኒ ማርካበር Ꮊንጎዳይስ ደንዴዝ ዎደ ኦገስ ቤዝዛ ባዝ ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ሀይꬒ አጌናፕ ጉየ፥ ማላጻ ባልጎ ኣꬂ ኢስክንድረ ማርካበር Ꮊማዳይስ ደንዴዛ። የ ማርካባይል አፋ ድዮስቆሮሳ ግዝ መንተ ኤቅታይ ምስለ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ስራኩሰ ካታማ ገሊ ኤዛይድ ሀይꬒ ጋላስ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","የይፕ ደንዲ ረግዩመ ካታማ ሄሌዛ። ፐቲ ጋላሳፕ ጉየ፥ ሱለ ባጋ ጫርካይ ጫርክን፥ ዎንትꬃ ጋላስ ፑትዮለ ካታማ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ኤዛይድ ኑኒ ፐቲ ፐቲ አማንዛ አስታ ደንግን፥ ፓር ሳምንታ ጋምኦድ ጋርክ ኑና ዎሴዛ። የይፕ ጉየ፥ ኦሮመ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ኦሮመ የዝ አማንዛ አስታይ ኑ ባጋ ስኢ፥ ኣፎሳ ፋሩስናኔ፥ ሀይꬒ አቅዛ አቆ ግዝ አቆ ሄሎዳይስ ኑና ሞኮዳይስ የኤዛ። ጳዉሎሳ ኡንታን ብኢ ጾሳ ጋላቴዛ ኤ ዎዝናይካ ሚንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ኑኒ ኦሮመ ገሌዝ ዎደ ጳዉሎሳ ፋና ናግዛ ዎታዳርታይር ፋ ኣዳስ በቶድ ጋርክ ግንትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ሀይꬒ ጋላሳፕ ጉየ፥ ጳዉሎሳ አይሁድታይ ሀላቅታ ፋኮ ጼግሴዛ። ኡንቲ ሺቄዝ ዎደ ኡንትኮ፥ «ታ እሹንꬆ፥ ታኒ ኑ አሳይ ዎይ ኑ አድታይ ዎጋል አፋ አባ ቆሆካ ኦꬄካያ፥ ዝን ታና የሩሳላመ አጪ ኦሮመ አሳይስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ኡንቲ ታ ሞታ ብኢ Ꮊይቆስ ሄልꬅዛ ባዝ ታል አፋ አብካ ደንገካ ግሾስ ታና ብልኦዳይስ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ዝን አይሁድታይ የያ እጽን ‹ታባዝ ቄሳረ ፕርዶ› ዬጌዛፕ አትን ታኒ ታ ጋድታ ሞትዛባዝ የዝን ባያ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ታኒ ይንታን ጼግሴዛይ ይንታን በአዳይስኔ ይንትስ Ꮊያ ኦዶዳዳይሲ። ታኒ Ꮊ ሳንꬃላታይር አጭንቴዛይ እስሬለ አሳይ ናግዛ ኡፋይሳይ ግሾስ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","አይሁደ ሀላቅታይ ጳዉሎሳኮ፥ «ኑስ ይሁዳፕ ኔስ ጻፍንቴዝ ዳብዳበ ሄለካያ። የይፕ የኤዝ አስታይፕ ፐታካ ኔስ ኢታ ኦዴዛይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ዝን Ꮊ ነ ካልዛ አማና ዱማ ዱማ አቆ አሳይ እጽዛና ኑኒ ኤርዛ ግሾስ ነ ቆፋ ስኦዳይስ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ኡንቲ ፋ የኦድ ጋላስ ጳዉሎሳስ ቃማ ኤኪ፥ የ ጋላስ ጋንጊ ኤ የዛ አቆ የኤዛ። ኤ ዎንታፕ ኦማꬅ ሄሎዳይስ ጾስ ካተትꬂ ባጋ ኡንትስ ማርካቴዛ። ማ ኡንቲ የሱሳ ባጋ አማኖዳይ ጋርክ ሙሰ ህገኔ ናብታይ ማጻፍታ ሎእꬂ ታማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ፐታይ ፐታይ ጳዉሎሳ ጌዛና አማኔዛ፥ ዝን Ꮊንክታይ አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ኡንቲ ዎል ጋንጨ ኦዳይል ማኣም እጼዛይፕ ጳዉሎሳ ፐትባዝ ጌዛይፕ ጉየ Ꮊንጌዛ። ኤ Ꮊይ ጋርክ ዬጌዛ፦ «ጌሻ አያናይ ኑ አድታይስ ናበ ኢስያሳ ዶናር ኦዴዛይ ቱማ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«‹ኔኒ Ꮊ አሳይኮ Ꮊንጊ፥ ይ ስስ ስእዛ፥ ዝን አካኮያ፤ ይ በኦ ብእዛ፥ ዝን ደንጎያ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ꮊ አሳይ ዎዝናይ ሙሜዛ፤ ኡ ሀያይ ቱሌዛ፤ ኡ ኣፋይካ ጎዝንቴዛ። የይ ባዛኮ፥ ኡንቲ ፋ ኣፋይር ብኢ፥ ፋ ሀያይር ስኢ፥ ፋ ዎዛናይር አካኪ፥ ታኮ ማቆዳዝን፤ ታካ ኡንታን ፓꬆዳዝን› ዬጎባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ይኬ፥ Ꮊይ ጾስ አቶትꬅ ኪታይ አይሁደ ባዝታይስ ማቄዛና ኤርዛ። ኡንትካ ስኦዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ጳዉሎሳ የያ ጌዛይፕ ጉየ አይሁድታይ ዎል ጋንጨ ዳሮ ፓላምታር ከዚ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳዉሎሳ ከራ ኬꬃ ናምኢ ላይꬅ ሙዳ በቴዛ፤ ኤዛይድ የዛር ፋኮ የኤዝታ ኡባ ሞክዛ። ");
INSERT INTO mfxe_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ያሻ ባይꬅኔ ኦካ ካየካዝን ጾስ ካተትꬅባዝ ሳባኬዛ፤ ጎዳ የሱስ ክርስቶሳ ባጋ ምልጽ ኡዲ ታማርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","የሱስ ክርስቶሳ አይለ ማቄዝ፥ ሀዋረ ማቃዳይስ ጼግንቴዛይፐኔ ጾሳ ዎንግለ ሳባኮዳይ ጋርክ ሻክንቴዝ ጳዉሎሳ ኪቴዝ ኪታ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ጾሳይ ጋመ ዎደፕ ቲና ፋ ናብታይ ባጋር እማድ ጌዝ ጾስ ዎንግላይ ጌሻ ማጻፍታይድ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","የ ዎንግላይ አሾር ዳዉተ ሼሻፕ የልንቴዝ፥ ጾስ ናአ፥ ኑ ጎዳ የሱስ ክርስቶሳ ባጋ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ማ ኤ ፋ ጌሻ አያናር Ꮊይቆፕ ደንዲ፥ ጾስ ናአ ማቅዛና ዳማ ዎልቃር ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ኤ ባጋር አይሁደ ባዝታይ ኡቢታይ፥ አማኒ ኪትንቶድ ጋርክ ክርስቶሳ ሱንꬃይ ግሾስ ጾሳይ ኣꬎ ኬሃትꬃር ሀዋረትꬅ ማዉተ ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","የሱስ ክርስቶሳስ ማቃድ ጋርክ ጼግንቴዝታይፕ ባግታይ ይንታና። ");
INSERT INTO mfxe_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ኦሮመ ጋንጨ የዝ፥ ጾሳይ ቃꬊዝታይስኔ ኤ ጌሽ ዎያ ማቃድ ጋርክ ማራጼዝታይስ፦ ጾሳ ኑ አዳይፐኔ ጎዳ የሱስ ክርስቶሳፕ ኣꬎ ኬሄትꬅኔ ሳሮትꬃይ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ኡባፕ ቲናቲ፥ ይ አማናይ ቢታ ኡባይል ስንቴዝ ግሾስ የሱስ ክርስቶስ ባጋር ይ ግሾስ ታ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ታኒ ኤ ናአይ ዎንግላይ ባጋ ኩንꬅ ዎዝናር ኦድዛ ጾሳይ፥ ታኒ ታ ዎሳይድ ኡባ ዎደ ይንታን ቆፕዛይስ ኤ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ዉርስꬃል፥ ጾስ ሸነ ማቅኮ፥ ታኒ ይንትኮ Ꮊማዳይስ ኦጋይ ታስ ኡሻቾድ ጋርክ ኡባ ዎደ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ታኒ ይንትስ አያና እሞትꬅ ሻጎዳይስኔ ይንታን በአዳይስ ላሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","የይካ፥ ታኒ ይ አማናይር፥ ማ ይ ታ አማናይር ሚንጎዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ታ እሹንꬆ፥ ታኒ አይሁደ ባ አሳይፕ ኣፈ ደንጌዛይ ጋርክ፥ ይንታፐካ ኣፈ ደንጎዳይስ ይንትኮ Ꮊማዳይስ ቆፔዛ፥ ዝን ታና ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ግርኬ አሳይስኔ ታማረካ አሳይስ ማ ኤጭታይስኔ ቦዝታይስ ታስ አጮ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","የይ ግሾስ፥ ኦሮመ ጋንጨ የዝ ይንትስካ ዎንግለ ኦዶዳይስ ታ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ዎንግላይር ዬላታም፥ ቲናቲ አይሁደ፥ ኤዛይፕ ግርኬ አሳይስ አማንዝታ ኡባ አሾዳይስ ዎንግላይ ጾስ ዎልቃ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ጽሎ አማኖር ደኦ የዞዳ ግንትንቲ ጻፍንቴዛ። ጾስ ጽሎትꬃይ በንቴዛ፤ ቲናፕ ዉርስꬂ ሄሎዳይስ አሲ ጽልዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ቱማይ ኤርንታም ጋርክ ፋ ኢታ ኦሶር ካይዛ አሳል አፋኔ ናጋራ ኡባይል አፋ፥ ጾስ ሴራ ሳሎፕ ዎꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ጾሳይ ኡንትስ በንቶዳይስ ቤዝዛ ባዝ ቆንጭሴዝ ግሾስ ኡንቲ ጾስባዝ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","አላመ መꬊንቴዛይፕ አይኪ፥ አስስ በንቶዋ ጾስ ሀኖታ፥ የይካ ኤ መꬍና ዎልቃኔ ጾሳትꬃይ ኤ መትꬃይር በንቲ የዛ ግሾስ አሳይ ፋ ኢታትꬅስ ሳላምቦድባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ኡንቲ ጾሳ ኤርታር፥ ኤዛ ቦንቼካያኔ ጋላተካያ። ኡ ቆፋይ ማዶዋ ባዝ ማቄዛ፤ ኡ አካኮዋ ዎዝናይ ꬉሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ኡንቲ ፋና ኤጭታ ግዛ፥ ዝን ቦዝታ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ꬋቦዋ ጾሳ ጎይኖዳና አሺ፥ Ꮊይቅዝ አስ ምስለ፥ ካፍታይ ምስለ፥ ዶእታይ ምስለኔ ኡሎር ጎችንትዛ ባዝታ ኣዝሲ ኦꬄዝ ምስልታ ጎይኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","የይ ግሾስ፥ ኡንቲ ፐታይ ፐታይር ቦርሶ ባዝ ኦꬂ፥ ፋ ጋላ ቶቾድ ጋርክ ጾሳይ ኡንታን ኡ ዎዝናይ አሞትዝ ቱና ኦሶስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","የይ ሀኔዛይ ኡንቲ ጾስ ቱሮትꬃ ዎርዶር ላሜዝ ግሾኔ መꬌዝ ጾሳ አሺ፥ መትꬂ ጎይኔዝ ግሾስ። ጾሳይ መꬍናስ ጋላትንቴዛያ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","የይ ግሾስ፥ ጾሳይ ኡንታን ኡ ቦርሶ አሞትꬃይስ ኣꬂ እንጌዛ። ኡ ማችታይ ፓስ ቤዝዛ ꬊራꬃር አቆዳ አሺ፥ ቤዞዋ ባዝ ሀኒ ማቺ ማቻር ዎላ አቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","የይ ጋርክ፥ ꬊራꬅታይ ፓስ ቤዝዛ ማቻር አቅዛ አሺ፥ ꬊራꬅ ꬊራꬃር ዎላ አቄዛ። ꬊራꬅ ፐታይ ፐታይር አሞትꬃር ጹግንቲ፥ ቦርሶ ባዝ ኦꬄዛ። ፋ ኦꬄዝ ቡታይስ ቤዝዛ ፕርደ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ኡንቲ ጾሳ ኤሮዳይስ እጼዝ ግሾስ ቤዞዋ ባዝ ኦꬆድ ጋርክ ጾሳይ ኡ ካሃ ፓꬃም ቆፋስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ኡንታር ዡጫትꬅ፥ ኢታትꬂ፥ ኡዛትꬂ፥ ገነ፥ ቅናተ፥ ሸምፖ ዎꬎ፥ ፓላማ፥ ዶሻኔ ኢታ አሞ ኩሜዛ። ኡንቲ ዝግርዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","አስ ሱንꬅ ኢስዝታ፥ ጾስ እጽዝታ፥ ጫዥዝታ፥ ኡትርትዝታ፥ ጬቅንትዝታ፥ ኢታ ባዝ ኦꬆዳይስ ኮይዝታኔ ፋ እንድስኔ ፋ አዴስ ኪትንቶዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","አካኮዝታ፥ ጫቆ መንꬅዝታ፥ ሲቆ ባዝታ፥ ቃ ባዝታ። ");
INSERT INTO mfxe_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","የይትታይ ጋርክ ኦꬅዝታይስ Ꮊይቆ ቤዝዛ ግዝ ጾሳ ህገ ኤርታር፥ Ꮊይትታ ኦꬅዛ። ኡ ፓስ ኦሶ ኣዳ ባዝን ኦꬅዛ Ꮊንክታካ ሳቢዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","የይ ግሾስ፥ ነኖ ሀራ አሳል አፋ ፕርድዛዮ፥ ኔኒ ሳንከ ሽሽዛባዝ ባያ። ኔኒ ሀራ አሳል አፋ ፕርድታር፥ የ ነ ፕርድዛ አꬃይ ጋርክ ኦꬅኮ፥ ነ፥ ኔል አፋ ፕርድዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","የይ ጋርክ ኦꬅዝታይል አፋ ጾሲ ጽሎ ፕርዳ ፕርድዛ ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ነኖ፥ የይ ጋርክ ኦሶ ኦꬅዝታይል አፋ ፕርድዛዮ፥ ኡንቲ ኦꬅዛኒ ጋርክ ኦꬅዛዮ፥ ኔኒ ጾስ ፕርዳፕ አቶድባዝ ኣዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ዎይ ጾስ ኬሄትꬃ፥ ጋርዦኔ ዳንዳአ ዱረትꬃ ነ ለቅኔ? ጾሲ ኔስ ኬሄዛይ ነና ናጋራፕ ማሆዳይስ ማቅዛና ኤሮሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ዝን ይንትስ ምኖኔ ማሮተꬅ ገሎዋ ዎዝና የዛ። የይ ግሾስ፥ ጾስ ሴራይኔ ጽሎ ፕርዳይ በንትዝ ጋላስ፥ ኔል አፋ ፕርዳይ ኩሮድ ጋርክ ኡድዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ጾሳይ ፐታይስ ፐታይስ ኤ ኦሳት ጋርክ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ሎኦ ኦሶር ሚንጊ፥ ጋላታ፥ ቦንቾኔ ꬋቦዋ ደኦ ኮይዝታይስ ጾሳይ መꬍና ደኦ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ዝን ፋና ሲቅዝታ፥ ቱማ እጽዝታኔ ኢታ ባዝ ኦꬆዳይስ ኮይዝታይል አፋ ጾስ ሴራኔ ጋዶ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ኢታ ባዝ ኦꬅዝ አስ ኡብታ፥ ቲናቲ አይሁድታ፥ ኤዛይፕ ግርኬ አሳ መቶኔ ኡንአ ሄሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ዝን ጾስ ሎኦ ኦሶ ኦꬅዝ ኡባይስ፥ ቲናቲ አይሁድታይስ፥ ካሊ ግርኬስ ጋላታ፥ ቦንቾኔ ሳሮትꬅ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ጾሳይ አስ ኣፈ ብኢ ሻኮያ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ህገ ባ ናጋራ ኦꬄዝ ኡቢታይ ህገ ባ ꬋቦድ። ህገ የዝን፥ ናጋራ ኦꬄዝ ኡባይ ህገር ፕርድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ጾስ ቲና ጽልዝታይ ህገ ናግዝታይፕ አትን ህገ ስስ ኣዳ ስእዝታ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ህገ ባ አይሁደ ባ አሳይ መꬎር ህገ ኪትዛ ኦꬅዛ። ኡንትስ ህጋይ ባ እጽኮካ ኡንቲ ፋ ዎዝናር ህገ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ኡ ሀኖታይ፥ ህገ ኪታይ ኡ ዎዝናይድ ጻፍንቴዛና ቤዝዛ። ማ ኡ ካሃይ ኡንታል አፋ ማርካትዛ። ኡ ቆፋይ ፐቲ ፐቲ ቶኬ ኡንታል ቡታ ግ ሞትዛ፤ ፐቲ ፐቲ ቶኬ ኡንታን ሉለ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ታ ታማርሴዝ ዎንግለ ጋርክ ጾሳይ የሱሳ ክርስቶሳ ባጋር አስ ዎዝና ጋንጨ ቆስንቴዝ ቆፋ ፕርድዛ ዎደ የይ ኤርንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ዝን ነ ነና አይሁደ ግዛ፤ ህገል ካትዛ፤ ጾሳር የዝ የሳይድ ነ ጋይርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ነ ኦꬆድ ጋርክ ጾሲ ኮይዝ ባዝ አብዛኮ ኤርዛ። ህገ ታማሬዝ ግሾስ ቱማ ማቅዝባዝ ሻጊ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ኔኒ ቶእታ ካልꬅዛ፥ ማ ꬉማ የዝታይስ ፖኦ ማቅዛና ሻኪ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ኔኒ ህጋይፕ ደንጌዝ ኤረትꬃይራኔ ቱማትꬃይር ቦዝታ ኤርስዛኔ ዱድታ ታማርስዛ ማቅዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","የዝን፥ ነ ሀራ አስ ታማርስዛይ ነ ነና አብስ ታማርሶሳ? ኔኒ፥ «ካስትፐ» ግ ሳባክታር፥ ኔኒ ነ ኡባስ ካስትኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ኔኒ፥ «ላምፐ» ጊታር፥ ኔኒ ነ ኡባስ ላምኔ? ኔኒ ኤቃ እጽታር፥ ኤቃር የዝ ካራ ቦንቂኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ኔኒ ጾስ ህጋይድ ጬቅንትዛ፥ ዝን ህጋይስ ኪትንታም እጺ ጾሳ ዬላꬅኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ጌሻ ማጻፋይድ፥ «ይ ሳንከር ጾሳ ሱንꬃይ አይሁደ ባ አሳይር ጫዥንትዛ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ነ ህገስ ኪትንትኮ፥ ነ ዶካልንታይ አድዛ፥ ዝን ኔኒ ህገስ ኪትንታም እጽኮ ነ ዶኮልንተካዛይ ጋርክ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","አይሁደ ማቀካ አስ ዶካልንተካ የዛር፥ ህገስ ኪትንትኮ፥ ጾሳይ ኤዛ ዶካልንቴዝ ጋርክ ፓይዶሳ? ");
INSERT INTO mfxe_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ይ፥ አይሁደ አሳይ፥ ይንትስ ጻፍንቴዝ ህጋይኔ ዶኮልንቲ የዝን፥ ይ ህገስ ኪትንታም እጽኮ፥ አይሁደ ባ አሳይ ዶካልንታም እጽኮካ ህገስ ኪትንቲ፥ ይንታል አፋ ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ይኬ፥ ሱንꬃር አይሁደ ማቄዝ ኡቢታይ ቱማ አይሁደ ባያ። በንትዝ አሾ ዶካልንታይ ቱማ ዶኮልንቶ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ዝን ቱማ አይሁደትꬅ ጋንጨ ባጋር አይሁደ ማቅዛ። ቱማ ዶካልንታይ ጾስ አያናር ሀንዝ ዎዝና ዶካልንቶፕ አትን ጻፍንቴዝ ህጋይድ ሀንዝ ጋላ ጋቾ ባያ። የ አꬃይ ጋላታ ጾሳፕ ኤክዛፕ አትን አሳፕ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","የዝን፥ አይሁደትꬅ አብስ ማዴ? ዎይ ዶካልንቶስ አባ ማዴ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ቱማ አይሁደ ማቅꬃይ ጋመ ኦገር ማድዛ። ኡባፕ ቲን ጾሳይ ፋ ቃላ ሀዳራ አይሁድታይስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","የዝን፥ ኡንታፕ ፐታይ ፐታይ ቃላ አማናም እጽኮ፥ ኡ እጻይ ጾስ ጌሸትꬃ ካይነኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ካዮያ! አስ ኡባይ ዎርዶ ማቅኮካ ጾሳይ ቱማ ማቆ። ጌሻ ማጻፋይድ፥ «ነቃላይር ነ ጽሎዳ፤ ነና ሞትዛና ፕርዳር ላꬆዳ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","የዝን፥ ኑ ዎርዣይ ጾሳይ ጌሻ ማቅዛና ቤዝዛ ባዝ ማቅኮ፥ ኑ ዋጎዴ? ጾሳይ ኑ ናጋራ ግሾስ ኑል አፋ ፕርድኮ፥ ሉሎ ባሳኔ? Ꮊያ ታኒ አስ ቆፋ ጋርክ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","የያ ባያ። የይ ጋርክ ሀንኮ፥ ጾሲ Ꮊ አላማይል አፋ ዋይዚ ፕርዶደ? ");
INSERT INTO mfxe_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ዝን ታ ዎርዶትꬃይ ጾስ ቱማ ቆንጭሲ፥ ኤ ቦንቻ ዳምሲ ቤዝዛ ባዝ ማቅኮ፥ የዝን፥ አብስ ታል አፋ ናጋራንቾ ጋርክ ፕርድኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ፐቲ ፐቲ አሳይ፥ «ሎኦ ባዝ የኦድ ጋርክ ኢታ ኦꬅዛ» ዬጊ ታማርስዛይ ጋርክ ኡዲ ታና ሞትዛ። የይ ጋርክ አሳል ይእዛ ጾስ ፕርዳይ ቤዝዛያ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","የዝን፥ ኑኒ ዋጎዴ? ኑ ኣꬆኔ? የያ ባያ! አይሁደ ማቅን፥ ግርኬ ማቅን ኡቢታይ ናጋራ ኦሞ የዛና ታኒ ቲናቲ ይንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ጌሻ ማጻፋይድ፥ «ጽሎ አስ ፐታካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","አካክዛ አስ ባያ፥ ጾስ ኮይዝ ኦንካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ኡቢታይ ባልንቴዛ ፐትፐ አዶዝታ ማቄዛ ሃዮትꬅ ኦꬅዛይ ባያ። ፐቲ አስካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ኡ ዶናይ ዶይንቴዝ ዱፎ፥ ፋ እራንꬃይር ዶሽዛ። ኡ ዶናይፕ፥ ሾሺ ማርዘ ከዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ኡ ዶናይድ ጫሞ ኦዳኔ ባድꬂ ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ኡ ቶካይ ሱꬅ ላሎዳይስ ኤልስዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ኡ ኦጋይድ ꬋቦኔ ዳቡርስ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ኡንቲ ሳሮትꬅ ኦገ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ፋ የሳይድ ጾስስ ያሽቶያ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","አስ ኡባ ዶና አይꬆዳይስኔ አላማ ሙመር ጾስ ፕርደፕ ኦሞር ሺሾዳይስ፥ ህገ እንግንቴዛይ ህገፕ ኦሞ አቅዝታይስ ማቄዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","የይ ግሾስ፥ ኦንካ ህገስ ኪትንቲ ጾስ ቲና ጽሎዳይስ ዳንዳኦያ። ህገ አስ ኡቢታይ ናጋራንቾ ማቄዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ዝን Ꮊት ህገኔ ናብታይ ማርካቴዝ ጾስ ጽሎትꬃይ ህገ ባዝን ቆንጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ꮊ ጽሎትꬃ፥ ጾስ የሱስ ክርስቶሳ አማኖ ባጋር አስ ኡባስ ሻኮ ባዝን እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","አሲ ኡባይ ናጋራ ኦꬄዛ፤ ጾሲ ኡንትስ እንጌዝ ቦንቻይፕ ፋጨዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ዝን ኡንቲ ጾስ ኣꬎ ኬሃትꬃር፥ ዎዝዛ ክርስቶስ የሱሳ ባጋር ጨር ጽሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ጾሳ የሱስ ክርስቶሳ ያርሾ ኡዲ እንጌዛይ፥ ኤዛ አማንዛ ኡቢታይ ኤ ሱꬃይር ናጋራ ማሮትꬅ ደማድ ጋርከ። ጾሳይ የያ ኦꬄዛይ ፋ ዳንዳአይር ቲን ናጋራ ታይበካ አሺ፥ ፋ ጽሎትꬅ ቤዞዳይስ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ꮊ ዎዳይድ የሱሳ አማንዛ ኡባ ጽልሶር፥ ጾሳይ ፋ ኡባስ ጽሎ ማቄዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","የዝን፥ ኑ ጬቅንታይ አባ የኔ? የይካ አቴዛ። ኑኒ ጬቅንትዛይ ህገስ ኪትንትዛ ግሾኔ? ዋኣ! አማኖ ህገራፕ አትን። ");
INSERT INTO mfxe_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ጾሲ አስ ጽልስዛይ አማኖራፕ አትን ህገ ናጎር ባዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ዎይ ጾሳይ አይሁድታይስ ኣዳ ጾሶኔ? አይሁደ ባዝታይስ ጾስ ባሳኔ? ቱማ፥ አይሁደ ባዝታይስካ ኤ ጾሰ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ጾሲ ፐቶ፤ አይሁድታኔ አይሁደ ባዝታይስካ አማኖር ጽልስዛይ ኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","የዝን፥ ኑኒ ህገ አማኖ ግሾስ ሻሮዳ ጉሶኔ? የያ ባያ! ህገ ምንꬆዳይፕ አትን። ");
INSERT INTO mfxe_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","የዝን፥ ኑ አሾ አደ አፍራመ አብ ደንጌኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","አፍራመ ኦሶር ጽሌዝባዝ ማቄዛኮ፥ ኤ ጬቅንትዛባዝ የዛ፥ ማቆዝን፥ ጾስ ቲና ጬቅንቶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ጌሻ ማጻፋይ፥ «አፍራመ ጾሳ አማኔዛ፤ ጾሳይ የያ ኤዝስ ጽሎትꬅ ኡዲ ኤኬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ኦꬅዛ አꬃይ ኤክዛ ዳሞዛይ፥ ኤ ኦሶ ዎልቃስ ጭግንትዛ አጮፕ አትን ኤዝስ እሞታ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ዝን ኦሶ ኦꬆዋ ኦንካ ናጋራንቻና ጽልስዛ ጾሳ አማንኮ፥ ኤ አማናይ ኤዝስ ጽሎትꬅ ማቂ ፓይድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ጌሻ ማጻፋይድ ዳዉተ፥ ኦሶ ባዝን ጾሲ ጽልስዛ አꬃይ አብ ጋርክ አንጅንቴዛኮ Ꮊይ ጋርክ ዬጊ ቆንጭሲ ቤዝዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ኡ ቡታይ አቶ ግንትንትዝታይኔ ኡ ናጋራይ ኡጭንቴዝታይ አንጅንቴዝታ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ጎዳይ ኤ ናጋራ ፓይደካ አሲ አንጅንቴዛያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","የዝን፥ ዳዉተ ኦዴዝ አንጆ ዶካልንቴዝ አስ ኣዳሶኔ? ዎይ ዶካልንተካ አስሶ? ኑኒ፥ «ጌሻ ማጻፋይ፥ አፍራመ ጾሳ አማኔዛ፤ ጾሳይ የያ ኤዝስ ጽሎትꬅ ኡዲ ኤኬዛ ዬጌዛ»። ");
INSERT INTO mfxe_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","የዝን፥ የይ አይደ ሀኔ? አፍራመ ዶካልንትነኔ? ዎይ ዶካልንተካ የዝን? ዶካልንቶዳይፕ ቲን ሀኔዛፕ አትን ጉየ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","አፍራመ ዶካልንቶዳይፕ ቲና ኤ አማናይ ኤዝስ ጽሎትꬅ ማታመ ማቂ ፓይድንቴዛና ኤርሶዳይስ፥ ኤ ዶካሎስ ማላ ማቄዛ። የይ ግሾስ፥ አፍራመ ዶካልንተካ አማንዝታይስኔ አማኖር ጽልዝታይስ ኡቢታይስ አደ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ኤ ዶካልንቴዝታይስካ አደ። አፍራመ ኡንትስ አደ ማቄዛይ ኡንቲ ዶካልንቴዝ ግሾስ ኣዳ ባዝን ኤ ዶካልንቶዳይፕ ቲን አማኔዝ አማና ኡንቲ ካሌዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","አፍራመስኔ ኤ ሼሻይስ፥ «አላመ ታ ይንትስ እማድ» ዬጌዝ ኡፋይሳይ፥ አፍራመ አማኖር ጽሌዝ ግሾስፕ አትን ህገ ናጊ ፖሌዝ ግሾስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ህገስ ኪትንቴዝታይ ጾሳይ እማድ ጌዝ ኡፋይሳ ኤክዝታ ማቅኮ፥ አስ አማኖ ጨረ፤ ጾስ ኡፋይሳይካ ሻርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ህገ መንꬆ ጾስ ካች ክእዛ፥ ዝን ህገ ባ አቆ ህገ መንꬆካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","የይ ግሾስ፥ ጾሲ እንጌዝ ኡፋይሳይ አማኖር ኤክንትዛ። Ꮊ ኡፋይሳይ አፍራመ ሼሽ ኡባስ ጾስ ኣꬎ ኬሄትꬅ ባጋር እንግንቴዛና ቤዝዛ። የይካ ህገ ናግዝታይ ኣዳስ ባዝን አፍራመ ጋርክ አማኔዝ ኡቢታይስ። አፍራመ ኑ ኡባይስ አደ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ጌሻ ማጻፋይድ፥ «ታ ነና ጋመ ዎይታይስ አደ ማሄዛ» ግንትንቲ አፍራመ ግሾስ ጻፍንቴዛ። Ꮊ ኡፋይሳይ አፍራመስ እንግንቴዛይ Ꮊይቄዝታይስ ደኦ እንግዛይኔ ኦሮꬅባዝ ኦꬅዛ ጾሳይ ኤዛ ማቅዛና ኤ አማኔዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ጾሳይ አፍራመስ ጋመ ዘርꬅ እማዳና ጫቄዛ። ኡፋይስ ኦꬆዳይስ አብካ ዳንዳእንቶዋ ዎደ አፍራመ ጾሳ አማኔዝ ግሾኔ ኡፋይስ ኦꬄዝ ግሾስ ጋመ ዎይታይስ አደ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","አፍራመስ ጼት ላይꬅ ኩሞድ ሀንኮካ፥ ዳቡሬዝ ꬊራꬄትꬃኔ ሳራ ናአ የሎዳይስ ዳንዳኦዛ ኤርታር ፋ አማናይር ዳቡረካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ማቆዝን፥ ኤ ፋ አማናይር ሚንጊ ጾሳይስ ቦንቾ እንጌዛፕ አትን ጾሳይ እንጌዝ ኡፋይሳ አማናም እጺ፥ ስካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","አፍራመ፥ ጾሳይ ጫቄዝ ጫቃ ፖሎዳና ፋ ኩንꬅ ዎዝናር አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","የይ ግሾስ፥ ጾሲ ኤ አማና ጽሎትꬅ ኡዲ ፓይዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ዝን፥ «ኤዝስ ጽሎትꬃ ታይቤዛ» ግዝ ቃላይ አፍራመ ኣዳስ ጻፍንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","የ ቃላይ ኑ የሱሳ Ꮊይቆፕ ደንꬄዝ ጾሳ አማንዛ ኑስካ ኑ አማኖ ጽሎትꬃር ታይብንቶዳይ ጋርክ ጻፍንቴዛይ ");
INSERT INTO mfxe_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ኑ ናጋራ ግሾስ Ꮊይቆስ አꬂ እንጌዛ፤ ኤ ኑና ጽልሶዳይስ Ꮊይቆፕ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ይኬ፥ ኑ አማኖር ጽሌዝ ግሾስ ኑ ጎዳ የሱስ ክርስቶሳ ባጋር ጾስ ባጋር ኑስ ሳሮትꬅ አይኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ኑኒ ኤ ባጋር Ꮊት ኑ ኤቄዝ ኣꬎ ኬሄትꬃይ ጋንጨ አማኖር ገሌዛ። የይ ግሾስ፥ ኑ ጾሳይ ቦንቻ ሻክንቶዳይስ የዝ ኡፋይሳይር ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","የይ ኣዳ ባዝን መቶ ዳንዳአ ክእዛና ኑ ኤርዛ ግሾስ ኑ መቶ ጋንጨራካ ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ዳንዳአ ፋጨ ጋንጨ ጋርዦ ጋርዦካ ኡፋይስ እንግዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ጌሻ አያናይ ባጋር ጾሳይ ፋ ቃꬋ ኑ ዎዝና ጋንጨ ጋዴዝ ግሾስ የ ኡፋይሳይ ኑና ዬላꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ኑኒ ሀጋ ዳቡሬዝታ ማቂ የዝን፥ ጾስ ዎደ ሄልን፥ ክርስቶሳ ናጋራ ኦꬄዝታይ ግሾስ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ጌሽ አስ ግሾስ Ꮊይቆድ አስ ዋዪ ደማዳ፥ ዝን ኬሃ አስ ግሾስ Ꮊይቆድ አስ ኦኒ ኤሬ በንተካ አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ዝን ኑኒ ሀጋ ናጋራንቾ ማቂ የዝን፥ ክርስቶሳ ኑ ግሾስ Ꮊይቄዛ። ጾሳይ ኑና አብ ጋርክ ቃꬍዛኮ ኤ ቃꬋ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ይኬ፥ ኑኒ ክርስቶሳ ሱꬃይር ጽሌዝባዝ ማቅኮ፥ ኡባይፕ ኣꬂ ኤ ባጋር ጾስ ሴራይፕ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ኑኒ ቲና ጾሳር ሞርክታ፥ ዝን ኤ ናአይ Ꮊይቆ ባጋር ኤዛር እግንቴዛ። የይፕ ኣꬂ፥ Ꮊት ኑኒ ጾሳር ዳቦቴዝ ኤ ናአይ ደኦ ባጋር ኑኒ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","የይ ኣዳ ባዝን Ꮊት ኑና ጾሳር ዳቦꬄዝ ኑ ጎዳ የሱስ ክርስቶሳ ባጋር ኑ ጾሳር ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ዝን ፐቲ አꬃይ ባጋር ናጋራ Ꮊ አላማ ገሌዛ። የ ናጋራይ ባጋር Ꮊይቆ የኤዛ። አሲ ኡቢታይ ናጋራ ኦꬄዝ ግሾስ Ꮊይቆ አስ ኮች ኡባ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ህገ እንግንቶዳይፕ ቲና አላመል ናጋራ የዛ፥ ዝን ህገ ባ ዎደ ናጋራ ናጋራ ማቂ ፓይድንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ዝን አዳመፐ ሙሰ ሄሎዳይስ Ꮊይቆ አስ ኡባ ሞዴዛ። ሀራ አቶዝን፥ አዳማ ጋርክ ህገስ ኪትንታም እጺ፥ ናጋራ ኦꬄካዝታይስ ጉጅካ Ꮊይቆ ካዉቴዛ። አዳማ የኦዳይስ የዛይስ ኣዝሶ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ዝን ጾስ ኣꬎ ኬሃትꬃይ ፐቲ አꬃይ ናጋራይ ጋርክ ባያ። ፐቲ አስ ናጋራ ባጋር ጋመ አሳይ Ꮊይቄዛ። ዝን የሱስ ክርስቶሳ ባጋር ጾስ ኣꬎ ኬሄትꬃይ ጋምታይስ ኣꬊ ጋንጊ እንግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ፐቲ አꬃይ ናጋራይ ጋንጨኔ ጾስ እሞታይ ጋንጨ ጋመ ዱማትꬂ የዛ። ፐቲ አስ ናጋራ ባጋር ጾሲ ፕርዳ ከኤዛ። ዝን አሳይ ጋመ ናጋራ ኦꬅኮካ ጾስ ኣꬎ ኬሄትꬃይ ጽሎትꬅ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ፐቲ አሳይ ናጋራ ባጋር Ꮊይቆ ካዉቴዛ። ዝን የሱስ ክርስቶሳ ባጋር ፑጬዝ ጾስ ኣꬎ ኬሄትꬅኔ ጽሎትꬅ እሞታ ኤክዛ ኡባይ፥ ጋሚ ደኦር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ይኬ፥ ፐቲ አሲ ናጋራ ኦꬄዝ ባጋር አስ ኡባይል አፋ ፕርዳ የኤዛይ ጋርክ ፐቲ አሲ ጽሎ ኦꬄዝ ባጋር፥ ጾስ አስ ኡባ ጽልሲ ደኦ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ፐቲ አሲ ኪትንታም እጼዝ ባጋር፥ ጋመ አሳይ ናጋራንቾ ማቄዛይ ጋርክ ፐቲ አስ ኪትንትꬃር ጋመ አሳይ ጽሎ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","አሳይ ናጋራ ዎልቃ ኤሮድ ጋርክ ህገ የኤዛ፥ ዝን ናጋራ ዎልቃይ ጋንጌዝ ዎደ ጾስ ኣꬎ ኬሄትꬃይ ኣꬊ ጋንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ናጋራ Ꮊይቆ ዎልቃር ካዉቴዛይ ጋርክ ጾስ ኣꬎ ኬሄትꬃይ ጽሎትꬅ ዎልቃር ካዉቲ፥ ኑ ጎዳ የሱስ ክርስቶሳ ባጋር ኑና መꬍናስ ደኦኮ ካልꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","የዝን፥ ኑኒ ዋጎዴ? ጾስ ኣꬎ ኬሄትꬃይ ጋጎዳይ ጋርክ ናጋራራ ሚንጊ ዎላ የዞደነ? ");
INSERT INTO mfxe_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ዋኣ፥ ኑኒ ናጋራስ Ꮊይቄዝባዝ ማቅኮ፥ የዝን፥ ኑኒ Ꮊይፕ ዋይዚ ናጋራራ የዞዴ? ");
INSERT INTO mfxe_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ኑ ኡቢታይ የሱስ ክርስቶሳር ፐቶ ማቃዳይስ ጻማቅንቲ ኤ Ꮊይቃይድ ኤዛር ፐቶ ማቃዳይስ ጻማቅንቴዛና ኤሮሳ? ");
INSERT INTO mfxe_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ኑ ጻማቅንቴዝ ዎደ ክርስቶሳር Ꮊይቂ ሞግንቴዛ። ክርስቶሳ ጾስ አዳይ ቦንቾ ዎልቃር Ꮊይቆፕ ደንዴዛይ ጋርክ ኑካ ኦሮꬅ የስ የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ኑ ኤ Ꮊይቃይድ ኤዛር ፐቶ ማቅኮ፥ የይ ጋርከካ፥ ኤ ደንዳይድ ኤዛር ዎላ ፐቶ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ኑ Ꮊይፕ ጉየ ናጋራስ አይለ ማቃም ጋርከኔ ኑ ናጋራንቾ አሾ ዎልቃይ ꬋቦድ ጋርክ ኑ ጭማ አሰትꬃይ ክርስቶሳር ሶትንቴዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ፐቲ አስ Ꮊይቅዝ ባዝ ማቅኮ፥ ኤ ናጋራ ዎልቃፕ ዎዝንቲ ከዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ኑኒ ክርስቶሳር Ꮊይቅኮ፥ ኤዛር ደኦ የዞዳና አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ክርስቶሳ Ꮊይቆፕ ደንዴዝ ግሾስ ማቂ ኤ Ꮊይቃምዛኔ Ꮊይቆ ቲናፕ ኤዛ ሞዳምዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ኤ Ꮊይቄዝ ዎደ ፐቲ ቶኬ ዉርሲ Ꮊይቄዛ፥ ዝን Ꮊት ደኦ ጾስስ የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","የይ ጋርከካ፥ ይ ናጋራስ Ꮊይቂ፥ ጎዳ የሱስ ክርስቶሳ ባጋር ጾስስ ደኦ የዛና ቆፖይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","የይ ግሾስ፥ ይንቲ፥ ይ አሾ እናስ ኪትንታም ጋርክ Ꮊይቅዝ ይ አሻይል ናጋራ ካዉትፐ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ማ ይ አባ አሰትꬅ ክፍለ ናጋራ ኦꬆዳይስ ዎርዠ ሚሸ ኡዲ እንግፓተ። ዝን ይ Ꮊይቆፕ ደንዲ፥ ደኦ የዛ አስ ጋርክ ይ አሾ ጾስስ እንጎይታ። ማ ይ ኩንꬅ አሾ ጽሎ ኦሶ ሚሸ ኡዲ ጾስስ ኣꬂ እንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ይ ጾስ ኣꬎ ኬሄትꬃይ ኦሞር የዛፕ አትን ህገፕ ኦሞር ባ ግሾስ ናጋራ ይንታን ሞዶዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","የዝን፥ ኑ ዋጎዴ? ህገፕ ኦሞር ባዝን ጾስ ኣꬎ ኬሄትꬃይ ኦሞር የዛ ግሾስ ናጋራ ዎላ ኦꬆኔ? ዋኣ! ");
INSERT INTO mfxe_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ይ ኪትንቶዳይስ ይንታን አይለ ኡዲ እንግዝ ዎደ የ ይ ኪትንትዛይስ አይለ ማቅዛና ይ ኤርዛ። የይ ጋርከካ፥ ይ ናጋራስ ኪትንትኮ፥ ይንትስ Ꮊይቆ ክእዝ ናጋራስ አይለ ማቅዛ። ዎይ ይ ጾስስ ኪትንትኮ ጽሎትꬅ ክእዝ ጾሳይስ አይለ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ካሰ ይ ናጋራስ አይለ፥ ዝን Ꮊት ይ ይንታን ኣꬂ እንጌዝ ቱማ ትምርታይስ ኩንꬅ ዎዝናፕ ኪትንቴዝ ግሾስ ጾስስ ጋላታ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ይ ናጋራ አይለትꬅ አቻፕ ብልንቲ ጽሎትꬅስ አይለ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ይንቲ ይ ቆፋር ዳቡራ ማቄዝ ግሾስ ታኒ ኦስካ ገልዛ ኦገር ኦድዛ። ካሰ ይንቲ፥ ይ አሰትꬅ ክፍለ ኡባ ቱናኔ ኢታ ባዝ ኦꬆዳይስ አይለ ኡዲ እንጌዛይ ጋርክ Ꮊት ይ አሰትꬅ ክፍለ ኡባ ጌሽ ማቃድ ጋርክ ጽሎትꬅ አይለ ኡዲ እንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ይ ናጋራስ አይለቲ የዛ ዎደ ጽሎትꬅስ ሃኮር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ይንታን Ꮊት ዬላꬅዛ ቢን ይ ኢታ ኦሳይፕ አባ ኣፈ ደንጌኔ? የይስ ዉርስꬃይ Ꮊይቆ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ዝን ይ ናጋራ አይለትꬅ አቻፕ ብልንት፥ ጾስስ አይለ ማቅዛ። የይ ይንታን ጽሎ ኣፈ አፍስዛ ኤ ዉርስꬃይ መꬍና ደኦ። ");
INSERT INTO mfxe_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ናጋራስ ዳሞዛይ Ꮊይቆ። ዝን ጾሳይ፥ ኑ ጎዳ ክርስቶስ የሱሳ ባጋር እንግንትዛይ መꬍና ደኦ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ታ እሹንꬆ፥ ታኒ ኦድዛይ ህገ ኤርዛ አሳይሲ። ህገ ፐቲ አሲ ፓꬅ የዛ ዎደ ኡባይድ ኤዛ ሞድዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ኣዝሶስ፥ አዝን ገሌዝ አስታ እ አዝናይ ፓꬅ የዛ ዎደ ህገር ኤዛር አጭንቴዛ። ዝን እ አዝናይ Ꮊይቅኮ ኤዛር እዛ ጫቄዝ ጫቃይ እዞ ሞዶያ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","የይ ግሾስ፥ እዛ ፋ አዝናይ ፓꬅ የዝን፥ ሀራ ꬊራꬅ ገልኮ፥ እዛ ላሜዛኖ ግንትትዛ። ዝን እ አዝናይ Ꮊይቅኮ፥ ጫቃይ እዞ ሞዶዋ ግሾስ እዛ ሀራ አዝን ገልኮ፥ እዛ ላሜዛኖ ጊንትንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","የይ ግሾስ፥ ታ እሹንꬆ፥ ይ ክርስቶሳ አሾ ባጋር ህገ ዎልቃስ Ꮊይቂ፥ ጾስስ ኣፈ ኣፎዳይስ Ꮊይቆፕ ደንዴዝ ክርስቶሳስ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ኑ አሾ አሞ ኑና ሞድን፥ ኑ የዝን ህገ ጉጂ ናጋራ ኦꬆድ ጋርክ ኑና ደንꬅꬅዛ። ኑ አሾ ጋንጨ ኢታ አሞትꬂ የዛ ግሾስ ኑኒ Ꮊይቆ ኣፈ ኣፎድ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ዝን Ꮊት ኑኒ ኑና አጬዝ ህጋይስ Ꮊይቄዝ ግሾስ ኑኒ ህገ አቻፕ ብልንቴዛ። የይ ግሾስ፥ ኦሮꬅዛ አያና ኦገል ጾስስ ኪትንትዛፕ አትን ጻፍንቴዝ ጭማ ህገስ ኪትንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ዬዝን፥ ኑ ዋጎዴ? ህገ ናጋራኔ? የያ ባያ! ዝን ህገ ናጋራ አብዛኮ ታና ኤርሴዛ። ህገ፥ «አሞትፐ» ጎዛኮ፥ አሞትꬂ አብዛኮ ታ ኤራምዝኒ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ዝን ታ ኡባ ባዝ አሞቶድ ጋርክ ናጋራ ህገ ባጋር ታል ኦገ ደንጌዛ። ህገ ባዛኮ ናጋራ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ካሰ ህገ ባ ዎደ ታ ፓꬅ፥ ዝን ህገ እንግንቴዝ ዎደ ናጋራ ፓጽን ታ ማ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ታኒ ደኦር የዞድ ጋርክ ጾሳይ እንጌዝ ህጋይ ታስ Ꮊይቆ ከኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ናጋራ ህገ ባጋር ታና ዶሽዛ ኦገ ደንጊ፥ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","የይ ግሾስ፥ ህገ ጌሺ፤ ኤዛር ጻፍንቴዝ ኪታይካ ጌሺ፥ ጽሎኔ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","የዝን፥ ሎኦ ማቄዝ ባዝ ታል አፋ Ꮊይቆ ከኤነኔ? አኣ! ዝን ናጋራ ናጋራ ማቅዛይ በንቶድ ጋርክ ሎኦ ባዛር ማድንቲ ታስ Ꮊይቆ ከኤዛ። የይ ግሾስ፥ ናጋራ ናጋራትꬃይ ህገ ባጋር ኣꬊ ኤርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ኑኒ ህገ አያና ባዝ ማቅዛና ኤርዛ። ዝን ታኒ ናጋራስ ባይዝንቴዝ አሾ ኣሲ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ታኒ ኦꬅዛባዝ አካኮያ፤ ታኒ ዶስዛባዝ ኦꬆዳና አሺ ታ እጽዛባዝ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ታ እጽዛባዝ ኦꬅዛባዝ ማቅኮ፥ ህገ ሎኦ ማቅዛና ታ ማእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","የያ ማቅኮ፥ የ ኦሳ ታር የዛ ናጋራይ ኦꬅዛፕ አትን ታ ኦꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ታር፥ የይካ ታ አሾር ሎኦ ባዝ ባዛና ታ ኤርዛ። ሎኦ ባዝ ኦꬅዛ አሞትꬂ ታር የዛ፥ ዝን ሎኦ ባዝ ኦꬆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ታኒ እጽዛ ኢታ ባዝ ኦꬅዛፕ አትን ታ ቃꬍዛ ሎኦ ኦꬆ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ታኒ እጽዛባዝ ኦꬅዛባዝ ማቅኮ፥ የያ ታር የዛ ናጋራይ ኦꬅዛፕ አትን ኦꬅዛይ ታና ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ይኬ፥ ታ ሎኦ ባዝ ኦꬆዳይስ ዶሶዳር፥ ኢታ ባዝ ኦሶ ህገ ማቅዛና ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ታኒ ታ ዎዝናር ጾስ ህጋይድ ኡፋይትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ዝን ታ አሾ ጋንጨ የዛ ታ ካሃ ህገር ኦልንትዛ ዱማ ህገ ብእዛ። የ ህጋይ ታ አሾ ጋንጨ ኦꬅዛ ናጋራ ህገስ ታና ድኢ አይለ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ታኒ ዋይዚ ሶንቄዝ አሶ? Ꮊይቆስ ካንግዝ Ꮊ አሳትꬃይፕ ታና አሾዳይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ኑ ጎዳ የሱስ ክርስቶሳ ባጋር ጾስስ ጋላታ ማቆ። ይኬ፥ ታኒ ታ ቆፋር ጾስ ህገስ ሞድንቴዛ፤ ዝን ታ አሻይር ናጋራ ህገስ ሞድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","የይ ግሾስ፥ ክርስቶስ የሱሳር የዝታይስ Ꮊት ፕርዳ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ክርስቶስ የሱሳ ባጋር ኑስ ደኦ እንግዝ ጌሻ አያና ህጋይ፥ ታና ናጋራኔ Ꮊይቆ ህገ አይለትꬃፕ ከሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ኑ ናጋራ አሻይ ባጋር፥ ህጋይ ዳቡሬዝ ማቄዝ ግሾስ ኑና አሾዳይስ ዳንዳኤካያ። ጾሳይ ፋ ናአ ናጋራንቾ አስ ኣዝሶር ናጋራስ ያርሾ ማቃድ ጋርክ ኪቲ የያ ኦꬄዛ። ዬዚ፥ ጾሳይ ክርስቶሳ አሻይ ባጋር ናጋራ፥ ናጋራንቾ አስ ጋንጨ ፕርዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ጾሳይ የያ ኦꬄዛይ፥ ኑ አሾ አሞ ኮይዛይ ጋርክ ባዝን ጌሻ አያናይ ኮይዛይ ጋርክ የዛ ኑል አፋ ህገ ጌሽ ኪታይ ፖልንቶድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ፋ አሾ አሞ ጋርክ የዝታይ ፋና ኡፋይስዝ ባዝ ቆፕዛ። ዝን ጌሻ አያና ሸነ ጋርክ የዝታይ ጌሻ አያና ባዝ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","አሾ ቆፋይ Ꮊይቆ፥ ዝን አያና ባጋ ቆፖ ደኦኔ ሳሮትꬅ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","አሾ ባጋ ቆፋ ጾስ ካንታ ሞርከትꬅ ጾስ ህገስ ኪትንቶያ ኪትንቶዳይስ ዳንዳኦዋ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ፋ አሾ አሞስ ሞድንትዝታይ ጾስ ኡፋይሶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ዝን ጾስ አያናይ ይንታር የዝኮኔ ይንታን ሞድኮ፥ ይ አያና ሸነር የዛፕ አትን አሾ አሞስ ሞድንቴና። ክርስቶሳ አያናይ ባ ኦንካ ክርስቶሳ ባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ዝን ክርስቶሳ ይንታር የዝኮ፥ ይ አሻይ ናጋራ ባጋር Ꮊይቄዛ። ዝን ይ አያናይ ጽሎትꬅ ባጋር ደኦ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ዝን የሱሳ Ꮊይቆፕ ደንꬄዝ ጾስ አያናይ ይንታር የዝኮ፥ ክርስቶሳ Ꮊይቆፕ ደንꬄዝ ጾሳይ፥ ይንታር የዝ ፋ ጌሻ አያናይር Ꮊይቅዝ ይ አሻይስ ደኦ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ይኬ፥ ታ እሹንꬆ፥ ኑል አጮ የዛ ኑ አሾ ሸነስ የዞዳይስ ኑ አሾስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ይንቲ፥ ይ አሾ አሞስ የዝኮ Ꮊይቆዳይስ የዛ፥ ዝን ጌሻ አያና ዎልቃር ናጋራ ኦሶ ዎꬍኮ ይ ደኦር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ጾሳ አያናይ ካልꬅዛ ኡባይ ጾስስ ናእታ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ኑኒ፥ «ኣቦ፥ አዳዮ» ዬጊ ጼግዝ፥ ጾስስ ናእታ ኡድዛ ጌሻ አያና ኤኬዛይፕ አትን ማቂ ያሻር የዞዳይስ አይለ ኡድዝ አያና ኤከካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ጾስ አያናይ ኑ አያናይር ማቂ ኑ ጾስስ ናእታ ማቅዛ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ኑኒ ኤ ናእታ ማቅኮ ጾሳ ላትዝታ፤ ክርስቶሳር ዎላ የያ ላቶዳ። ማ ኑኒ ክርስቶሳር መቶ ኤክኮ ኤዛር ዎላ ኤ ቦንቻ ሻክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ኑኒ Ꮊት ዋይንትዛ ዋያ፥ ቲናፕ ኑስ በንቶድ ቦንቻይር ዎልሄልꬅ በአዳር፥ አብካ ኣዚ በንቶዛ ታ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","መትꬂ ኡቢታይ ጾስ ናእታይ ቆንጭꬃ ጋመ ላሞꬃር ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","መትꬂ ኡቢታይ ጨረ ባዝስ ሞድንቴዛ፤ የይካ፥ መትꬂ ዶሮር ባዝን ኡፋይስስ ሞድንቶድ ጋርክ ኦꬄዝ ጾስ ሸነር ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","መትꬃይ ፋ ኦማር ꬋብስዛ አይለትꬃፕ ዎዝንቲ፥ ጾስ ናእታይር ዎላ ቦንቾ ዎዞ ሻክንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","መትꬃይ ኡባይ Ꮊኖ ሄሎዳይስ እቅꬅ አይኬዝ ማች ጋርክ ኦለራኔ መቶር የዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ማ መትꬅ ኣዳ ባዝን ጌሻ አያና ባይራ እሞታ ጋርክ ኤኬዝ ኑኒ፥ ኑ ኡባስ ኑ አሻይስ ዎዞ ማቄዝ ጾስ ናእታ ማቃድ ኡፋይስ ናግታር ኑ አሻይር ኦልዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ꮊ ኡፋይሳይር ኑኒ ፓጼዛ። ዝን ኑኒ ኡፋይስ ጋድዛባዛይ በንትዝ ማቅኮ የያ ኦኒ ኡፋይስ ኡዴ? ");
INSERT INTO mfxe_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ዝን ኑ በኤካ ባዝ ደማዳ ግ ኡፋይሳር ናግኮ የያ ዳንዳአር ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","የይ ጋርክ ጌሻ አያናይ ኑ ዳቡርሳ ማድዛ። ኑኒ ጾሳ ዋይዚ ዎሶዳይስ ቤዝዛኮ ኤሮያ፥ ዝን አያናይ ፋ ኡባስ፥ አሲ ኦዶዳይስ ዳንዳእንቶዋ ቃላር ኑስ ጋናትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ማ አስ ዎዝና ኤርዛ ጾሳይ፥ ጌሻ አያና ቆፋይ አብዛኮ ኤርዛ። ጌሻ አያናይ ጾስ ሸናይ ጋርክ ጌሽታይስ ጋናትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ጾሳ ቃꬍዝታይስኔ ኤ ሸናይ ጋርክ ጼግንቴዝታይስ ጾሳይ ኡባ ባዝ ሎኦስ ኦꬅዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ጾሳይ ቲናቲ ኤሬዝታ ፋ ናአ ኣዞድ ጋርከራ ናአይካ ጋመ እሽታይ አማንዝታይ ጋንጨ ባይራ ማቃድ ጋርክ ኡንታን ዱማሲ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ጾሳይ ቲናቲ ቆፒ ጋዴዚታ ዝታ ጼጌዛ፤ ጼጌዝታ ጽልሴዛ፤ ጽልሴዝታ ማ ቦንቼዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","የዝን፥ ኑ Ꮊ ኡባይስ ዋጎዴ? ጾሳይ ኑ ባጋ ማቅኮ ኑር ኦኖ ኤቅንቶዳይ? ");
INSERT INTO mfxe_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ኤ ሀራ አቶዝን፥ ፋ ናአይስ ቃካዛር፥ ኑ ግሾስ ኣꬂ እንጌዛ። የዝን፥ ፋ ጋዛ ናአ ኑስ ኣꬂ እንጌዛይ ዋይዚ ኡባ ባዝ ጨር እንጋሞ? ");
INSERT INTO mfxe_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ጾስ ዶሬዝታ ሞቶዳይ ኦኖ? ጽልስዛይ ጾሰ የዝን ፕርዶዳይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ꮊይቄዛይ Ꮊይቆፐካ ደንዲ ጾስ ኡሻቻ በቴዝ፥ ክርስቶስ የሱሳ፥ ኤ ኑስ ጋናትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ይኬ፥ ኑና ክርስቶሳ ሲቆፕ ሻኮዳይ ኦኖ? መቶነ ዎይ ዋየነ ዎይ ባይእꬆነ ዎይ ናየነ ዎይ ካሎትꬆኔ ዎይ ያሻነ ዎይ ኦላነ? ");
INSERT INTO mfxe_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ጌሻ ማጻፋይድ፥ «ኑ ነ ግሾስ ኡባ ጋላስ ቡትንትዛ፤ ሹክንትዛ ዱርታይ ጋርከካ ታይብንቴዛ» ግንትንቲ ጻፍንቴዛይ ጋርክ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ዝን ኑ Ꮊ ኡባይድ ኑና ቃꬌዝ ክርስቶሳር ጋምዝ ኡቢታይፕ ኣꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","የይ ግሾስ፥ Ꮊይቆ ማቅን የስ ማቅን ኪታንችታ ማቅን ሞድዝታ ማቅን Ꮊት የዛና ማቅን ቲናፕ የኦዳ ማቅን ዎልቃምታ ማቅን፥ ");
INSERT INTO mfxe_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ꬎቀካ ማቅን ዝቀካ ማቅን አባ መትꬂ ማቅን ኑ ጎዳ፥ ክርስቶሳ የሱሳር የዛ ጾስ ሲቃይፕ ኑና ሻኮዳይስ ዳንዳኦዛና ታኒ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ታኒ ክርስቶሳር ማቂ ቱሮ ኦድዛ፥ ዎርዶቶያ። ጌሻ አያናይ ካልꬅዛ ታ ካሃይ ታኒ ዎርዶቶዛና ታስ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ታ ዎዝናር እስራኤልታይስ ጋመ ቆፋራኔ ዱጾዋ ኡንአራ ቃማ ጋላስ ታ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ታኒ፥ ታስ አሾር ዳቦ ማቄዝ ታ እሽታይ ግሾስ ክርስቶሳፕ ሻክንቲ ጾስ ባድꬅ ጋንጨ የዜዛኮ ዶስዛዝን። ");
INSERT INTO mfxe_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ኡንቲ እስራኤልታ፥ ጾሳይ ኡንታን ፋ ናእታ ኡዴዛ፥ ፋ ቦንቻ ኡንትስ ቆንጨ ኦዴዛ። ኡንታር ጫቄዛ፤ ህገ ኡንትስ እንጌዛ። ኡ ጾሳ ጎይኖድ ቱማ ኦጋ ቤዜዛ፤ ጾሳይ ኡፋይስ ቃላ ኡንትስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ኡ የለትꬃይድ ማይዝታይ ኮች፤ ማ ክርስቶሳ አሾር ኮቼ ማቂ የኤዛ። ኡባይፕ ኣꬎ ማቄዝ ጾሳይ መꬍናስ ጋላትንቶ። አምንኤ! ");
INSERT INTO mfxe_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ማቆዝን፥ ጾሳ ቃላይ ፖልንተካ አቴዛ ጉስ ባያ። እስራኤለፕ የልንቴዝ አስ ኡቢታይ እስሬለ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ማ አፍራመ ዛረ ኡቢታይ አፍራመ ናእታ ባያ። ጾሳይ አፍራመስ፥ «ነ ሼሻይ እሳቃ ባጋር ጼግንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","የያ ጉሳይ አሾር የልንቴዝ ናእታይ ኡቢታይ ጾስ ናእታ ባያ። ዝን ቱማ እስሬለ ናእታይ ጾሳይ ገሌዝ ቃላይ ጋርክ የልንቴዝ ናእታ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","እንጎዳ ግ ገሌዝ ቃላይ፥ «ታኒ ላይꬅ ዎደ Ꮊኖደ የኦዳ፤ ሳራካ ꬊራꬅ ናአ የሎዳ» ዬጌዛኖ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","የይ ኣዳ ባዝን እርብቃ ማ ፐቲ ኑ አዳ እሳቃስ ዎደጼዝ ዎደ፤ ");
INSERT INTO mfxe_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","መንተ ናእታይ የልንቶዳይፕ ዎይ ኢታ ዎይ ሎኦ ኡደካዝን ጼግዛይፕ አትን ኦሶፕ ባዝን ዶሮ ጾሳ ቆፋይ ሚንጎዳይ ጋርከ ");
INSERT INTO mfxe_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","«ባይራይ ጌዳይስ ሃርንቶዳ» ዬጊ ጎዳይ ኢስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","የይካ ጌሻ ማጻፋይድ፥ «ያይቆባ ዶሲ፥ ኤሳወ ታ እጼዛ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","የዝን፥ ኑኒ ዋጎዴ? ጾሳይ አሰ አሳፕ ቁርኔ? ጾሲ ቁርዛ ጎዳይስ ኑ ዳንዳኦያ! ");
INSERT INTO mfxe_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ጎዳይ ሙሰኮ፥ «ታ ማሮዳይስ ኮዬዝታና ማሮዳ፤ ታ ቃꬊንቶዳይስ ኮይዛይስ ቃꬊንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ይኬ፥ ጾስ ዶሮ አስ ሸነር ዎይ አስ ኦሶር ባዝን ኤ ማሮትꬃይራ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ጌሻ ማጻፋይድ፥ ግብጸ ካታይኮ፥ «ታኒ፥ ታ ዎልቃ ኔል ቤዞዳይስኔ ታ ሱንꬃይ አላመ ኡባይል ኤርንቶድ ጋርክ የይስ ነና ካዉትሴዛ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ይኬ፥ ጾሳይ ማሮዳይስ ኮይዛና ማርዛ፤ ዎዝና ሙምሶዳይስ ኮይዛይ ዎዝና ሙምስዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ይንትፕ ፐታይ፥ «የዝን፥ ጾሳይ አስ አብስ ቦሮ? ጾስ እጽዛይ ኦኖ?» ዬጊ ኦይጮዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ዝን ነኖ አሶ፥ ጾሳር ፓላሞዳይስ ነ ኦኖ? ኦሶ ፋና ኦꬄዛይኮ፥ «ታና Ꮊይ ጋርክ ኡዲ አብስ ኦꬄኔ?» ግ ኦይጮዳይስ ዳንዳእኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ዎይ ኡርቃ መꬌዛይ ፐቲ ኡርቃፕ ፐታ ቦንቾ ሚሸ፥ Ꮊንካ ማ ቶሸ ሚሸ ኡዲ መꬎዳይስ ማዉተ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ጾሳይ ፋ ሴራ ቤዞዳይስኔ ፋ ዎልቃ ኤርሶዳይስ ኮይ ꬋቦስ ጊግሴዝ ሴራ ሚሽታ ጋመ ጋርዦር ዳንዳኤዛኮ አብ ኤሬ? ");
INSERT INTO mfxe_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ኤ የያ ኦꬄዛይ ዳማ ቦንቾስ ጊግሴዝ፥ ፋ ዶሬዝ ናእታይስ ፋ ቦንቻ ኤርሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","አይሁደ ማቅን፥ ዎይ አይሁደ ባ አስ ኡብታ ጾሲ ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ናበ ሆሳኤ ማጻፋይ ጋንጨ፥ «ታ ታ ዎያ ባዝታካ፥ ‹ታ ዎያ› ግ ጼጎዳ። ዶስንተካ ዎይታካ፥ ‹ዶስንቴዝታ› ግ ጼጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ኡንቲ ‹ታ ዎያ ባያ› ግንትንቲ ጼግንቴዝ አቃይድ፥ ‹ደኦ ጾስ ናእታ› ግንትንቲ ጼግንቶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ናበ ኢስያሳ እስሬለ አስ ባዝ፥ «እስሬለ አስ አባ ሻፈ ጋርክ ጋንግኮካ፥ ኡንታፕ ጽቃ አስ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ጎዳይ ቢታ ኡባይል አፋ ኤልሲ ሙርቲ ኡከር Ꮊያ ኡዶዳ።» ");
INSERT INTO mfxe_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ማካ ኢስያሳ፥ «ኡባፕ ዎልቃማ ጎዳይ ኑስ ጽቃ ዘርꬅ አሸካዛኮ፥ ኑኒ ሶዶማኔ ጋሞራ ካታማ ጋርክ ꬋቦዳዝን» ዬጊ ቲናቲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","የዝን፥ ኑ ዋጎዴ? ጽሎትꬅ ኮይበኤካ አይሁደ ባ አሳይ አማኖር ጽሎትꬅ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ዝን ጽሎትꬃይኮ ሄልꬅዝ ህገ የዛ እስሬለ አሳይ ጽሎትꬅ ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","አብስ ደንገካሳ? ኡንቲ ጽሎትꬅ አማኖር ባዝን ኦሶር ኤኮዳይስ ኮዤዝ ግሾስ። የይ ግሾስ፥ ኡንቲ፥ «ꬉቢዛ ሹቻር» ꬉብንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ማጻፋይድ፥ «ቦኦይታ ታኒ ጽዮነ ꬉበ ሹችኔ ፎክስዝ ዛላ ጋዶዳ። ኤዛ አማንዛ ኦንካ ዬላተና» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ታ እሹንꬆ፥ ታ ኩንꬅ ዎዝናር ታ አሞትዛይኔ ጾሳ ዎስዛይ እስሬልታይ አቶድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ኡንቲ ጾስስ ምጭንትዛዝን፥ ቱማ ኤረትꬅ ꬋቦር ምጭንቶዛና ታ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ኡንቲ ጾስ ጽሎትꬅ ኦገ ኤራም እጺ፥ ፋ ኣዳ ጽሎትꬅ ካሌዛፕ አትን ጾስ ጽሎትꬅ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","አስ ኡባይ አማኖር ጽሎድ ጋርክ ክርስቶሳ ህገስ ፎሎ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ሙሰ አስ ህገ ናጊ ኤክዝ ጽሎትꬅባዝ፥ «ህገ ናግዝ ኦንካ የ ህጋ ናጌዛይ ጋርክ ደኦ የዞዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ዝን አማኖር ኤክዝ ጽሎትꬅ ባጋ ጊንትንቴዛይ Ꮊያ፦ «ነ ዎዝናር፥ ‹ኦኒ ሳሎ ከዞዴ?» ዬግፐ፤ የይ ክርስቶሳ ዎꬆዳይስ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ዎይ፥ «ሱለ ሳአ ኦሞ ዎꬎዳይ ኦኖ?» ጊፐ፤ የይ ክርስቶሳ ዱፎፕ ከሶዳይስ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ዝን ዬጊ ጻፍንቴዝ፦ «ቃላይ ነ ካለ የዛ፤ ነ ዶና ጋንጨኔ ነ ዎዝና ጋንጨ የዛ» ኑኒ ይንትስ ኦድዝ አማኖ ቃላይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","«የሱሳ ጎዳ» ግ ነ ዶናር ማርካትኮኔ ጾሳይ ኤዛ Ꮊይቆፕ ደንꬄዛና ነ ዎዝናር አማንኮ፥ ነ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","አሲ ፋ ዎዝናር አማኒ ጽልዛ፤ ፋ ዶናር ማርካቲ አትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ማጻፋይ፥ «ኤዛ አማንዛ ኦንካ ዬላተና» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ፐቲ ጾሳይ ኡቢታይ ጎዳ ማቄዝ ግሾስ አይሁድታይ ጋንጨኔ አይሁደ ባ አስ ጋንጨ ዱማትꬂ ባያ። ኤ ፋና ጼግዝ ኡባይስ ጋመ ኬሃ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ጎዳ ሱንꬅ ጼግዝ ኦንካ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","የዝን፥ ኡንቲ አማነካ የዝታር ዋይዚ ኤዛ ጼጎዳይስ ዳንዳኤ? ኡ ኤባዝ ስኤካ የዝታር ዋይዚ ኤዛ አማኖዳይስ ዳንዳእኔ? ማ ኡንትስ ቃላ ኦድዝ አስ ባዝን፥ ዋይዚ ስኦዳይስ ዳንዳእኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ኪትንቴዝ አሲ ባዝን ቃላይ ዋይዚ ኦድንቶዳይስ ዳንዳኤ? ማጻፋይድ፥ «ኡፋይስ ዎንግለ ኦድዝ አስስ ቶክታይ ዋፋ ሎእነሻ» ዬጊ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ዝን ኢስያሳ፥ «ጎዳዮ፥ ኑ ማርካትꬅ ኦኒ አማኔኔ?» ዬጌዛይ ጋርክ፥ ኡቢታይ ዎንግለ አማነካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","የይ ግሾስ፥ አማናይ ስሳፕ ይእዛ፤ ስስ ክርስቶሳ ቃላፕ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ማቆዝን፥ ኡ ቃላ ስኤካ ጉሶኔ? ዋኣ ስኤዛ። ማጻፋይድ፥ «ኡ ኦዳይ ቢታ ኡባይል ስንቴዛ፥ ኡ ቃላይ ሳአ ጋጻ ሄሌዛ» ዬግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ዝን እስሬለ አሳይ ኤረካያ ጉሶኔ? ሙሰ ቲና፥ «ታኒ ይንታን ለቂንቴዝ አሳይ ጋንጨ ቂርሶዳ፤ ማ አካኮዋ አሳይ ጋንጨ ይንታን ይሎሶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ማ ኢስያሳ፥ «ታና ኮየካ አሳይስ ታ በንቴዛ፤ ታና ኦይጨካ አሳይስ ታ ታና ቤዜዛ» ዬጊ ያሽተካዛር ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ዝን ኢሳያሳ እስሬልታይ ባጋ ኦድታር፥ «ጋላስ ሙዳ ኪትንቶዋ አሳይስኔ ታና እጽዛ አሳይስ ታ ኩሸ ሚጬዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","አን ታ ኦይጭዛ፦ የዝን፥ ጾሳይ ፋ ዎያ ኦሊ አሸነኔ? አሸካያ! ታኒ ታ ኡባስ እስሬለ፤ አፍራመ ሼሺ፤ ቢናማ ኮቼ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ጾሳይ ቲን ዶሬዝ አስታ ኦሎያ። ማጻፋይድ፥ ኤላሳ እስራኤልታ ጾስ ቲና ዋይዚ ሞቴዛኮ፥ ይ ኤሮሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ኤላሳ፥ «ጎዳዮ፥ ኡንቲ ነ ናብታ ዎꬌዛ፥ ነ ያርሾ አቃካ ላሌዛ። ታ ታ ኣዳስ አቴዛ፤ ኡንቲ ታናካ ዎꬎዳይስ ኮይዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ጾሳይ ኤኮ ዋጊ ማሄኔ? «ባኣለ ግዝ ኤቃስ ጎይነካ ላፑን ሙኩለ አሲ ታስ አሼዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","የይ ጋርከካ፥ Ꮊ ዎዳይድ ጾሳይ ፋ ኣꬎ ኬሃትꬃር ማራጼዝ ጽቅታይ እስሬለ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ኤ ኡንታን ዶሬዛይ ፋ ኣꬎ ኬሄትꬃይራፕ አትን ኡ ኦሶር ባያ። ዶራይ ኦሶር ማቅኮ፥ ኤ ኣꬎ ኬሄትꬃይ ጨረ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","የዝን፥ ዋየኔ? እስሬልታይ ፋ ኮይዝ ባዝ ደንገካያ፥ ዝን ጾሲ ዶሬዝ ጽቅታይ ደንጌዛ። አቴዝታይ ፋ ዎዛና ሙምሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","የይካ፥ ማጻፋይድ፥ «ኡ ኣፋይ ቦኦያ ሀያይካ ስኦያ፥ Ꮊኖ ሄሎዳይስ ኡንትስ፤ ጾሳይ አዛላ አያና እንጌዛ» ግንትንቲ ጻፍንቴዛይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ማ ዳዉተ፥ «ኡ ሚዝ ሌማታይ ኡንታን ጽኬኔ ኦላ አይኮ፤ ኡንታን ጎልእስዛ ጋጋ ማቆ፤ ኡ ኢታትꬃይ ኡንታን ሄሎ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ኡ በአማይ ጋርክ ኡ ኣፋይ አይክንቶ፤ ኡባ ዎደ መቶ ኡንታን ኩንሶ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","የዝን፥ ꬉብንቴዝታይ ፖኮድ ጋርከኔ? የያ ባያ! ኡ ዎꬍꬃይ አይሁደ ባ አሳይ አቶድ ጋርክ ሳንከ ማቄዛ። የይካ አይሁድታይ ኡንታል አፋ ቅናታማይ ጋርክ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","አይሁድታይ ናጋራይ አላማይስ ጋመ አንጆ ከኤዛ፤ ማ ኡ ጋምንትꬃይ አይሁደ ባ አሳይስ ጋመ አንጆ ማቄዛ። የዝን፥ ዶርንቴዝ አይሁድታይ ኩንꬅ አትዝ ዎደ አንጆ አብ ጋርክ ዳሮደሻ? ");
INSERT INTO mfxe_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ታኒ፥ ይንትስ አይሁደ ባ አሳይስ ኦድዛ። አይሁደ ባ አሳይስ ሀዋረ ማቂ ኦꬅዛይራ ታኒ ጋመ ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ታ የያ ኦꬄዛይ ታስ አሾ ዳቦ ማቄዝ እስሬልታ ቂርሲ ኡንታፕ ጽቅታ አሾዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ጾሳይ ኡንታን ኦሊ አሼዝ ዎደ Ꮊ አላማይ ጾሳር ዳቦቴዛ። ጾሳይ ኡንታን ሺሺ ኤክዛ ዎደ Ꮊይቄዝ አሲ Ꮊይቆፕ ደንዳይ አብ ጋርክ ማቆዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ቲና ኦሌዝ ሙኑቃይ ሎኦ ማቅኮ Ꮊንካይካ ጌሺ። ምꬅስ ጻጶ ጌሺ ማቅኮ፥ ሻቃይካ ጌሺ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ጋደ ቱኬዝ ዎይራ ሻቆ ካርንትን፥ ይንቲ ዎራ ዶሌዝ ዎይራ ሻቆ ማቄዝታይ ኡ አቃይድ ꬋንꬅስንቲ ጻጶር ከዝዝ ዛይተ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ይኬ፥ ይንቲ ሻቆ ጋርክ ካርንቲ ዎꬌዛይል አፋ ኡትርትፓተ። ይ ኡትርትዛባዝ ማቅኮ፥ ጻጳይ ይንታን ቶኬዛፕ አትን ይ ጻጳ ቶከካዛ አካኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ኔኒ፥ «የ ሻቅታይ ካርንቴዛይ፥ ታኒ ኡ አቃይድ ꬋንድንቶዳይ ጋርከ» ይ ጎዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","የይ ቱማ። ኡንቲ አማናም እጼዝ ግሾስ ካርንቴዛ። ኔኒ አማኔዝ ግሾስ የ አቃይድ ኤቄዛ። ነ ያሽቶዳይስ ቤዝዛፕ አትን ኡትርቶዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ጾሳይ መꬍንቶ ሻቆ ማቄዝ አይሁድታይስ ቃꬊንታም እጽኮ ይንትስካ ቃና። ");
INSERT INTO mfxe_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ይኬ፥ ጾሲ አብ ጋርክ ኬሃዛኮኔ አብ ጋርክ ምንꬅዛኮ ቦኦይታ። ኤ ምንꬃትꬃይ ፎኬዝታይስ፥ ማ ኤ ኬህዛይ ይንትሲ። ሚንጊ ኤቃም እጽኮ ይንትካ ጋችንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ኡንቲ አማንኮ፥ ቲን ፋ የዛ አቃ ማቆዳ። ጾሳይ ዎልቃማ ኡንታን ማሂ፥ ጋዶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ይንታን ዎራ የዝ ዎይራ ማቄዝታ ጋቺ፥ ካራቻ ቱክንቴዝ ዎይራይል አፋ ይንታን ቱክኮ፥ መꬍንቶ ጋደ ዎይራ ማቄዝታ ቲና አቃይድ ማሂ ቱኮዳይስ ዋይዚ ዳንዳእንቶሳ? ");
INSERT INTO mfxe_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ታ እሹንꬆ፥ ይ ይንታን ኤራ ግ ጋይርፓተ። ታ ይንትስ ፐቲ ኦድዛ ጹሮድ ባዝ የዛ። የይካ እስራኤልታይፕ ባግታይ ዎዝና ሚንꬂ ስኣም እጼዛይ ዉርስꬂ ሄሎዳይስ ባዝን አቶዳይስ የዝ አይሁደ ባ አስታይ ኡባይ ኩንꬃር ጾስኮ የኦዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","የይ ጋርከ፥ እስሬለ አስታይ ኡቢታይ አቶዳ። ማጻፋይድ፦ «ኑና ዎዝዛይ ጽዮነፕ የኦዳ፤ ያይቆባ ዘርꬃፕ ኢታ ኡባ ꬋብሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ታኒ ኡ ናጋራ አቶ ግዛይ ኡንታር ጫቆድ ጫቃይ Ꮊያ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ዎንግለ ኤካም እጺ፥ ይ ግሾስ ሞርከ ማቄዛ። ማቆዝን፥ Ꮊተካ ኡንቲ ዶርንቴዝታ፥ ጾሲ ኡ አድታይ ግሾስ ኡንታን ቃꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ጾሲ ፋ እማይራኔ ፋ ጼሳይር ቂራቶያ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ይንቲ ቲን ጾሳይስ ኪትንተካ፤ ዝን Ꮊት አይሁድታይ ኪትንታም እጽን፥ ይ ጾስ ማሮትꬅ ኤኬዝታ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","የይ ጋርከ፥ ይ ኤኬዝ ማሮትꬃ አይሁድታይ ኤኮድ ጋርክ Ꮊት ኡ ጾስስ ኪትንታም እጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ጾሲ አስ ኡብታ ፋ ማሮትꬃ ቤዞዳይስ ኮይ፥ አሲ ኡቢታይ ኪትንታም እጾዳይ ጋርክ ጎርዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ጾስ ዱረትꬃ፥ ኤጨትꬃኔ ኤረትꬃ አካኪ ኦዶዳይ ኦኖ? ኤ ፕርዳይ ፕላግንቶያ፥ ኤ ኦጋይ ኤርንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ማጻፋይድ፥ «ጾስ ካሃ ኤርዛይ ኦኖ? ኤዛ ዞሮዳይስ ዳንዳእዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ጾስስ ታልእዛይኔ ታልኤ ማሂ ኤክዛይ ኦኖ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ኡባይ ኤፕ፤ ኤዛራኔ ኤሲ፤ ኤስ መꬍናስ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ይኬ፥ ታ እሹንꬆ፥ ይንቲ፥ ይ አሰትꬃ ጾስ ኡፋይስዛ፥ ፓꬅኔ ጌሻ ያርሾ ኡዲ፥ እማድ ጋርክ ታ ይንታን ጾስ ከሃትꬃይር ዎስዛ። ጾሳ ይ ጎይኖዳይስ ቤዝዛ ቱማ ኦጋይ የያ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ሎኦ፥ ኡፋይስዛኔ ፎሎ ማቄዝ ጾሳ ኪታ ይ ሻኪ ኤሮዳይስ ይ ቆፋር ላምንቶይታፕ አትን Ꮊ አላማ ኣዝፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ጾሲ ይንትስ ፐታይስ ፐታይስ እንጌዝ አማናይ ጋርክ ካሃር የዝ አስ ጋርክ ቆፖይታ። ቆፖዳይስ በዝዛይፕ ኣꬂ ይንታን ዱማሲ፥ ኡትራር ቆፕፓተ ግ ታስ እንግንቴዝ ኣꬎ ኬሃትꬃይር ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ኑ ፐቲ አሰትꬃይል አፋ ዱማ ዱማ ክፍልታይ የዛ፤ የ ዱማ ዱማ ክፍልታይስ ዱማ ዱማ ኦሶ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","የይ ጋርክ፥ ኑኒ ጋመ አስ ማቅኮካ ክርስቶሳር ፐቲ አሾ ማቄዛ። ኑኒ ፐቲ አሾ ማቂ ዱማ ዱማ ክፍልታይ ፐታይ ፐታይራ አይክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ኑስ እንግንቴዝ ኣꬎ ኬሃትꬃር ዱማ ዱማ እሞትታይ የዛ። ኑ እሞትꬃይ ትንቢተ ኦዶ ማቅኮ፥ ኑስ የዝ አማናይ ጋርክ ኦዶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ኑ እሞትꬃይ ሀራ አስ ማዴ ማቅኮ፥ የ ኦሳይር ምንጎዳይስ ቤዝዛ፤ ታማርሶ ማቅኮ፥ የ ታማርሳይር ምንጎዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ኑ እማይ ሀራ አስ ዞርꬅ ማቅኮ፥ ሚንጊ ዞሮዳይስ ቤዝዛ። ኑ እሞትꬃይ ኑስ የዛ ባዛፕ ሀራ አስስ እሞ ማቅኮ፥ ዎዝናፕ እንጎዳይስ ቤዝዛ። ኑ እሞትꬃይ አቅሶ ማቅኮ፥ ሚንጊ አቅሶዳይስ ቤዝዛ። ኑ እሞትꬃይ ሀራ አስስ ኬህꬅ ማቅኮ፥ ኡፋይሳር ኬሆዳይስ ቤዝዛ። ኑ እሞትꬃይ ማሮ ማቅኮ ኡፋይሳር ማሮዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ይ ሲቃይ ቆፕ ቆሞ ማቆዳይስ ቤዞያ። ኢታ ባዝ እጾይታ፤ ሎኦ ባዝ ሚንꬂ አይኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ፐታይ ፐታይራ ዎል እሸ ጋርክ ዶስንቶይታ፤ ፐታይ ፐታ ቦንቾይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ኦሶር አዛልፓተ ሚንጎይታ፤ ይ አያናር ጹግንቲ ጎዳይስ ሞድንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ጾሲ እንጌዝ ኡፋይሳይር ኡፋይቶይታ፤ መቶ ዳንዳኦይታ፤ ኡባ ዎደ ጾሳ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","አማንዛ ጌሽታ ኮሽዛ ባዛር ማዶይታ፤ እማꬅታ ሞኮዳይስ ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ይንታን ባይእዝታ አንጆይታ፤ አንጆይታፕ አትን ባድፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ኡፋይትዝታይር ኡፋይቶይታ፤ ዬክዝታይር ዬኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ፐታይ ፐታይር ፐቲ ቆፋር የዞይታ። ኡትራ ቆፋ አሺ፥ ሃዮትꬃር የዞዳይስ ሚንጎይታ። ይ ይንታን ኤጫ ግ ቆፕፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ኦንካ ይንትስ ኢታ ባዝ ኦꬅኮ፥ የ አꬃይስ ኢታ ባዝ ማህፓተ ኡባ አስ ቲና ሳቢስዛ ሎኦ ኦሶ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ይንትስ ዳንዳእንትኮ ኡባ አሳር ሳሮ የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ታ እሹንꬆ፥ ይንቲ፥ ይ ኡባስ አስስ ኩሸ ከስፓተ። ጾሲ ኩሸ ከሶዳይ ጋርከ ኤዝስ አሺ አሾይታ። ጌሻ ማጻፋይድ፥ «ታ ኩሸ ከሶዳ፤ ታኒ ኩሸ ማሆዳ» ዬጌዛ ጎዳይ፥ ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ዝን ጌሻ ማጻፋይድ፥ «ነ ሞርካይ ናይንትኮ ሙዞባ፤ ኤ ሳምንትኮ ኡሾባ። ነ የያ ኦꬅኮ ኤ ኦማይል ታማ ቃቃ ካችዛ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ኢታ ሎኦር ጋሞይታፕ አትን ኢታር ጋምፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","አባ ማውተካ ጾስ ሸነር እንግንትዛ ግሾስነ Ꮊት ማዉተር የዝታይካ ጾስ ሸነር ማዉተ ኤኬዝ ግሾስ አሲ ኡባይ ጋደ አቅስዝታይስ አዛዝንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","የይ ግሾስ፥ ማዉተር የዝታይስ ኪትንታም እጽዛ ኦንካ ጾስ አዛዞ እጽዛ። ኪትንታም እጽዛ ኦንካ ፋል አፋ ፕርዳ ክእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","አቅስዝታይ ኢታ ባዝ ኦꬅዝታፕ አትን ሎኦ ኦꬅዝታ ያሽሶያ። አቅስዝታይስ ያሽታማይስ ኮይኔ? የዛኮ ሎኦ ባዝ ኦꬆባ፤ ነና ጋላቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ኡንቲ ኔስ ሎኦ ባዝ ኦꬆዳይስ ሹምንቴዝ ጾስ አይለ። ዝን ኔኒ ኢታ ባዝ ኦꬅኮ፥ ኡንቲ ኢታ ባዝ ኦꬄዛና ሴርዛ ግሾስ ኤዝስ ያሽቶባ ኡንቲ ቃዋ አይኬዛይ ጨረ ባያ። ኡንቲ ኢታ ባዝ ኦꬅዝታ ሴሪ፥ ጾሲ ካጭዛና ቤዝዛ ጾስ አይለ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","የይ ግሾስ፥ ጾስ ካች ኣዳስ ባዝን ይ ካሃይ ማርካትዝ ግሾስ ጋደ አቅስዝታይስ ኪትንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ይ ጊራ ጊርዛይካ የይ ግሾሲ። ጋደ አቅስዝታይ የ ኦሳ ኦꬅዛይ፥ ኡንቲ ጾስ አይሊታ ማቄዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ኡባይስ ቤዝዛና እንጎይታ። ጊራ ቤዝዝታይስ ጊሮይታ፤ ቃራጸ ቤዝዝታይስ ቃራጸ ጋቾይታ፤ ያሽቶዳይስ ቤዝዝታይስ ያሽቶይታ፤ ቦንቾ ቤዝዛና ቦንቾይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ፐታይ ፐታይር ሲቅንቶይታ። ሲቆ አጮፕ አትን ይንታል አፋ ሀራ አጮ የዝፐ። አስ ዶስዛ ኦንካ ህጋይ ግዛና ፖሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«ላምፐ፤ ዎꬍፐ፤ ካስትፐ፤ ዎርዶ ማርካትፐ፥ አሞትፐ» ግዝ አዛዛይኔ ሀራ አዛዞ ኡባይ፥ «ነ ዣማ ነ ኡባይ ጋርክ ቃꬎባ» ግዝ አዛዞር አጭንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ሲቆ ፋ ዣማይል አፋ ኢታ ባዝ ኦꬆያ። የይ ግሾስ፥ ሲቆ ህገስ ፎሎ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ገንታፕ ይ ባርክዛ ዎዳይ Ꮊት ሄሌዝ ማቄዛይስ ላይꬃ ኤሮይታ። ኑ አቶትꬅ ዎዳይ ቲና ኑ አማኔዝ ዎደፕ ኣꬂ Ꮊት ኑኮ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ቃማይ ኣꬌዛ፤ ጋላሳይ ኡኬዛ። ይኬ፥ ኑኒ ꬉማ ኦሶ አሺ ፖኦ ኦላ ሚሸ ዎላ አይኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","አን ጋላሳ ፖኦ የዝ አስ ጋርክ ዎላ ማራር የዞዳ። የꬃራኔ ማꬄራ፥ ላመራኔ ቃይጸራ ፓላማራኔ ቅናተራ ማቅፐ። ");
INSERT INTO mfxe_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ጎዳ የሱስ ክርስቶሳና ማኦይታ፤ ይ ናጋራ ኦꬅዝ አሻይ ፋ እና ፖሎድ ጋርክ ኤዝስ ቆፕፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","አማኖር ዳቡሬዝ ኦናካ ሺሺ ኤኮይታፕ አትን ኤ ቆፋይል አፋ ፕርድፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ኣዝሶስ፥ አማኖር ምንጌዝ ፐቲ አስ አባ ካꬃካ ማዳይስ ዳንዳእዛ። ዝን አማኖር ሚንገካ አስ አታክልተ ኣዳ ሚዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ሚዝ አስ ሞዋ አꬃ ቦርፐ። ሞዋ አስ ሚዝ አꬃይል ፕርድፐ። ጾሲ ኡብታ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ሀራ አስ አይለል አፋ ፕርድዛይ ኔኒ ኦኖ? ኤ ዳቡርን ዎይ ምንግን ፋ ጎዳይሲ። ጎዳይ ኤዛ ኤሶዳይስ ዳንዳእዛ ግሾስ ኤ ሚንጊ ኤቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ማ «ፐቲ ጋላሲ Ꮊንኮ ጋላሳፕ ኣꬍዛ» ዬጊ ቆፕዛ አሲ የዛ። ሀራይ ማ፥ «ጋላስታይ ኡቢታይ ዎል ጋርክ ግና ቦንቾር የዛ» ግ ቆፕዛ። ዝን ፐታይ ፐታይ ፋ ቆፋ አካኪ አጮ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ጋላስ ቦንችዝ ኦንካ ጎዳይስ ግ ቦንችዛ። ኡባ ካꬃ ሚዝ አሲ ጎዳይ ቦንቾስ ግ ሚዛ። ኤ ሚዝ የ ካꬃት ግሾስ ጾሳ ጋላትዛ። ኡባ ካꬃ ሞዋ አሲ ጎዳይ ቦንቾስ ሞያ፤ ማ ሜካ አሾራካ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ኑፕ ኦንካ ፓስ ባያ፤ ማ ኑ ጋንጨፕ ኦንካ ፓስ Ꮊይቃም። ");
INSERT INTO mfxe_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ኑ ሸምፖር የዝኮ ጎዳይስ የዞዳ፤ ማ Ꮊይቅኮካ ጎዳይስ Ꮊይቆዳ። ይኬ፥ ኑ ሸምፖር የዝን ዎይ Ꮊይቂን ጎዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ክርስቶሳ Ꮊይቂ Ꮊይቆፕ ደንዴዛይ፥ ደኦር የዝታይስኔ Ꮊይቄዝታይስ ጎድ ማቃዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","የዝን፥ ኔኒ ነ እሻይል አፋ አብስ ፕርዴ? ዎይ ኔኒ ነ እሻ አብስ ለቄ? ኑኒ ኡቢታይ ጾስ ፕርዳ ዙፋነ ቲና ኤቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ጌሻ ማጻፋይድ ጎዳይ፥ «ታኒ ፓꬅ የዛ፤ አስ ኡቢታይ ታ ቲና ቡንቂቶዳ፤ ታኒ ጾስ ማቄዛና እንጻርስ ኡባይ ማርካቶዳ» ዬጊ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ይኬ፥ ኑ ኦꬄዝ ባዝስ ኑ ኦማር ኦማር ጾስ ቲና ሺቂ ማህꬅ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","የይ ግሾስ፥ ኑኒ ፐታይ ፐታይል አፋ ፕርድዛና ዎላ አሾዳ። ዝን ይ እሻ ꬉብꬅዛ ዎይ ቃጽꬅዛ ባዝ ኦꬃማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ጎዳ የሱሳ አማንዛ አስ ጋርክ፥ ፋ ኡባስ ቱና ማቄዝ ባዝ ባዛና ታኒ ጌሺ ኤርዛ። ዝን ፐቲ አሲ ፐትባዝ ቱና ግ ቆፕኮ የይ ኤዝስ ቱና ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ነ ሚዝ ካꬃ ግሾስ ነ እሻ ꬉቢዛባዝ ማቅኮ፥ ክርስቶሳር የዛ ነ እሻ ቃꬎያ። ክርስቶሳ ኤ ግሾስ Ꮊይቄዝ አꬃ ነ ሚዝ ካꬃ ግሾስ ኤዛ ꬋብስፐ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ይኬ፥ ይንትስ የዝ ሎኦ ባዛ Ꮊንክታይ ቦሮድ ጋርከ ኦꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ጾስ ካተትꬃይ ጌሻ አያናይር በንትዝ ጽሎትꬅ፥ ሳሮትꬅኔ ቱማ ኡፋይሳፕ አትን ሙስ ባጋኔ ኡሽ ባጋ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","የይ ጋርክ ክርስቶሳስ ሞድንትዝ አስ ጾስ ኡፋይስዛ፤ አሳይ ጋንጨካ አንጅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","የይ ግሾስ፥ አን ኑኒ ሳሮትꬅ በንትዝ ኦገኔ ዎል አማኖር ሚንꬅዛ ኦገ ካልዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ካꬃ ግሾስ ግ ጾሳ ኦሶ ꬋብስፐ። ኡባ ካꬃ ጌሺ፥ ዝን ሀራ አስ ሰእስዛ ካꬃ ሙሲ ኢታ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ነ እሻይ ꬉብንታም ጋርክ አሾ ማም ዎይ ኡሽ ኡዣም ዎይ ꬉቢዛ ሀራ ባዝ ኦꬃምንጽኮ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ይኬ፥ Ꮊ ነ አማና ኔስኔ ነ ጾሳይ ጋንጨ ናጎባ። ልኬ ግ ቆፔዝባዝ ኦꬅዛ ዎደ ኤ ካሃይ ሞቶዋ አꬃይ አንጅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ዝን ስꬊታር ሚዝ አꬃይስ ኤ ሙሳይ አማኖር ማቀካ ግሾስ ፕርድንትዛ። አማኖ ባይꬅ ኦꬅንቴዝ ኦሶ ኡቢታይ ናጋራ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ኑ ምንꬅታይ ዳቡሬዝታይ ዳቡራ ቶኮዳይስ ቤዝዛ። ኑኒ ኑና ኡፋይሶዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ኑኒ ዎል ምንꬆዳይስ ዣምታ ማዶዳይስኔ ኡፋይሶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ክርስቶሳ ፋና ኡፋይስበኤካያ። ዝን ጌሻ ማጻፋይድ፥ «አሳይ ነና ጫዤዝ ጫሻይ ታና ሄሌዛ» ግንትንቲ ጻፍንቴዛይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ጌሻ ማጻፋይ እንግዛ ጋርዦራኔ ምንꬃꬆራ ኑ ኡፋይሳ ኤኮድ ጋርክ ጌሻ ማጻፋይድ ጻፍንቴዝ ኡቢታይ ኑና ታማርሶዳይስ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ጋርዦኔ ምኖትꬅ እንግዛ ጎዳይ ይንቲ የሱሳ ክርስቶሳ ካሎዳር ፐትፐተꬅ ይንትስ እንጎ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","የይካ፥ ኑ ጎዳ የሱስ ክርስቶሳ ኣዳ፥ ጾሳ፥ ፐቲ ዎዛናራኔ ፐቲ ቃላር ይ ቦንቾድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ክርስቶሳ ይንታን ኤኬዛይ ጋርክ ጾስ ቦንቾስ ፐታይ ፐታ ኤኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ጾሲ ብኒ አድታይስ እንጌዝ ኡፋይሳይ ፖልንቶድ ጋርክ ኤ ቱማትꬃይ ኤርንቶዳይ ጋርክ ክርስቶሳ ዶካልንቶ አይለ ማቂ የኤዛና ታ ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ክርስቶሳ ዶካልንቶስ አይለ ማሄዝ ባዛይ ማ አይሁደ ባ አሳይ ጾሳ ኤ ማሮትꬃይ ግሾስ ጋላቶድ ጋርከ። ጌሻ ማጻፋይድ፥ «ታ ነና አይሁደ ባ አስ ጋንጨ ጋላቶዳ፤ ነ ሱንꬃ ሳቦዳ» ግንትንቲ ጻፍንቴዛይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ማ፥ «አይሁደ ባ አሳይስ፥ ጾስ ዎያይራ ኡፋይቶይታ» ዬግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ማ ማሂ፥ «አይሁደ ባ አሳይ ኡባይ፥ ጎዳ ጋላቶይታ፤ ካተትꬂ ኡቢታይ ኤዛ ሳቦይታ» ዬግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","የይ ጋርክ ኢስያሳ፥ «ኢሳየ ጻጶፕ የልንቴዝ ፐታይ የኦዳ፤ ኤ ፋ ካተትꬃ ኡብታ አቅሶዳ። ኡ ፋ ኡፋይሳ ኤዛል አፋ ጋዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ጌሻ አያና ዎልቃር ይ ድጮድ ጋርክ ኡፋይስ እንግዝ ጾሳይ፥ ይ አማናይ ባጋር ይንትስ ኡፋይሳራ ሳሮትꬃር ኩንꬅ እንጎ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ታ እሹንꬆ ይንት ሎኦትꬅኔ ኤረትꬂ ኩሜዛና ማ ፐታይ ፐታ ዞሮዳይስ ዳንዳእዛና ታ ጌሺ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ታኒ ይንታን ፐቲ ፐትባዝ ጉጂ አካክሶዳይስ ኮይ ያሽተካዛር Ꮊ ዳብዳባ ይንትስ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ታኒ ክርስቶስ የሱሳ አይለ ማቂ፥ አይሁደ ማቀካ አሳይስ ቄሰ ጋርክ ኦꬂ፥ ዎንግለ ኦዶድ ጋርከ ጾሳይ ታስ ኣꬎ ኬሄትꬅ እንጌዛ። አይሁደ ባ አሳይ ጌሻ አያናር ጌዢ፥ ጾስ ኡፋይስዛ ያርሾ ማቃድ ጋርክ ጾሳይ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ታኒ ክርስቶስ የሱሳር ማቂ ጾስስ ኦꬅዛ ኦሶር ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","አይሁደ ባ አሳይ ጾሳይስ ኪትንታ ማቃዳይ ጋርክ፥ ክርስቶሳ ታ ቃላኔ ታ ኦሶ ባጋር ኦꬄዝ ኦሳይፕ አትን ሀራ ታ ጬቅንትዛባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ጾስ የያ ማላታራኔ ጌሻ አያና ዎልቃር ዋይዚ ኦꬄዛኮ ታ ይንትስ ኦዶዳ። ታኒ የሩሳላመፕ አይኪ፥ ኢልዋርቆኔ ሄሎዳይስ ክርስቶሳ ዎንግለ ሳባኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ታኒ ሀራ አስ ባሴዝ አቃይድ ኬጾዳይስ ኮዮያ። ክርስቶሳ ሱንꬃይ ጼግንተካ አቆ ዎንግለ ሳባኮዳይስ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ጌሻ ማጻፋይድ፥ «ኤባጋ ኦድንተካ አሳይ ኤዛ በአዳ፤ ኤ ባጋ ስኤካ አሳይ አካኮዳ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","የይ ባጋር፥ ታኒ ጋመ ዎደ ይንትኮ የኦዳይስ ኮይን ዳንዳእንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ዝን ታኒ Ꮊተ Ꮊ ሄራር የዝ አቆ ኡባ ሄሌዝ ግሾስ ጋመ ላይꬃፕ አይኪ ይንታን በአዳይስ ላሞቴዝ ግሾስ ");
INSERT INTO mfxe_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ታኒ ኢስጴኔ Ꮊንግታር ይንታን በአዳይስ ቆፔዛ። ማ ጽቃ ዎደ ይንታር ኡፋይቴዛይፕ ጉየ ኢስጴኔ Ꮊንጎዳር ይ ታ ኦጋይስ ታና ማዶድ ጋርክ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ዝን Ꮊተ ታኒ ጾሳ አስታ ማዶዳይስ የሩሳላመ Ꮊንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ማቃዶናራኔ አካያ የዝ ጾስ አስታይ፥ የሩሳላመ ጌሽታይ ጋንጨ የዝ ማንቅታ ሚሸር ማዶዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ኡንቲ ማንቅታ ማዶዳይ ኡንትስ አቶዋ ባዝ ማቄዝ ግሾስ ፋ ኡባስ የያ ኦꬆዳይስ ቆፋ አጬዛ። አይሁድታይ አይሁደ ባዝታይራ አያና አንጆ ሻግንትኮ፥ ኡንቲ ማ ፓስ የዛባዛር አይሁድታ ማዶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","የይ ግሾስ፥ ታኒ የ ሺቄዝ ሚሻ ኡንትስ እንገዛይፐኔ ኤኬዛና ኤሬዛፕ ጉየ ኢስጴኔ Ꮊንግታር ይ ላንቀር ኣꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ታኒ ይንትኮ Ꮊንግዛ ዎደ ክርስቶሳ አንጆ ኩንꬃር Ꮊማዳና ታ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ታ እሹንꬆ፥ ታስ ጾስ ዎስታር ታ ቡትንቶዳር ታር ኤቆድ ጋርክ ጎዳ የሱስ ክርስቶሳራኔ ጌሻ አያና ሲቃይር ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ጾሳይ ታና ይሁዳ ጋንጨ የዝ አማኖዋ አስታይፕ አሾድ ጋርከኔ የሩሳላመ ታ ኦꬆድ ኦሶ ጾስ አሳይ ላንቀ ኤክንቶድ ጋርክ ታስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ማ ጾስ ጊኮ፥ ታኒ ይንትኮ Ꮊንጊ ኡፋይሳር ይንታር ሸምፖድ ጋርክ ታስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ሳሮትꬅ ጾሳይ ይንታር ኡባይር ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ክንክራ ካታማ ጋንጨ የዝ ዎሳ ኬꬃ ኦꬅዛ ኑ ምሽት ፌበና ሎኦ ማች ማቅዛና ይ ኤሮድ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ይ እዞ አማንዛ አስታይ ጎዳይ ሱንꬃር ሞኮዳይስ ቤዝዛ አማንዛ አስታይፕ ፐታይ ጋርክ ሞኮይታ። እዛ ይንታፕ ኮይዝ ባዝ ኡባ እዞ ማዶይታ። እዛ ፋ ኡባስ ጋመ አስ ማዴዛ፤ ማ ታና ታ ባጋር ኡንደና ማዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ክርስቶሳ የሱሳ ኦሳ ታር ዎላ ኦꬅዝ ጵርስቅላራኔ አቅላ ታ ቆ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ኡንቲ ታ ግሾስ ፋ ሸምፖ Ꮊይቆስ ኣꬂ እንጌዛ። ታ ኣዳ ባዝን አይሁደ ባ አሳይ ዎሳ ኬꬅታይ ኡቢታይ ኡንታን ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ኡ ካራ ሺቅዝ አማንዛ አሳ ታ ቆ ሳሮ ጎይታ። ኢስያ ቢታ ክርስቶሳና ቲን አማኔዛኔ፥ ታ ቃꬍዛ ኤጳነጾሳስ ታ ሳሮꬃ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ይ ግሾስ ኦሶር ጋመ ዳቡሬዝ ማይራሞ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ታር አች ካራ ጋምኤዝታ አይሁደ ዳብታ አንድሮንቆሳራኔ ዩልያናራ ሳሮ ጎይታ። ኡንቲ የሱሳ ሀዋርታይ ጋንጨ ኤርንቴዝታ። ማ ኡንቲ ክርስቶሳ ታፕ ቲና አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ጎዳ አማንዛ ታ ሲቆ ላጋ፥ አምጲልያጾሳ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ክርስቶሳ ኦሳ ኑር ዎላ ኦꬅዝ ኡርባኖሰራ ታ ቃꬍዛ እስታኩሳ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ክርስቶሳር የሳይ ማርካትንቴዝ አጸልሳስ ታ ሳሮꬃ ኦዶይታ። አርስጻቡሎ ካራ አሳይስ ታ ሳሮꬃ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ታ አይሁደ ላጋ ሄሮድዮና ሳሮ ጎይታ። ናርስሳራ ኤ ካራ አሳይፕ ክርስቶሳ አማኔዝታ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ጎዳይ ኦሶር ዳቡርዝ ማች ጽሩፋይናራኔ ጽሩፎሳ ሳሮ ጎይታ። ማ ጎዳይስ ጋመ ዳቡሪ ኦꬅዝ፥ ታ ቃꬍዛ ጸርስሶ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ጎዳይ ኦሶር ሎእꬂ ኤርንቴዝ ሩፎሳሳራኔ ታና ፋ ናአ ጋርክ ብእዛ ኤ እንዳትስ ታ ሳሮꬃ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","አስቂርጾሳ፥ ፍለሶንጻ፥ ሄርመንሳ፥ ጳትሮባሳስራ ኡንታር የዝ አማንዛ እሽታ ኡባይስ ታ ሳሮꬃ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ፍሎሎጉሳ፥ ዩልያ፥ ኔራ፥ ኤ ምሽቶ፥ ኦሉምፖሳራ ኡንታር የዝ ጌሽታ ኡብታ ሳሮ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ጌሽ ዬራ ዬርንትታር፥ ፐታይ ፐታ ሳሮꬆይታ። ክርስቶሳ ዎሳ ኬꬅ ኡቢታይ ይንታን ሳሮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ታ እሹንꬆ፥ ይ ታማሬዝ ትምርታ እጺ፥ ይ ጋንጨ ሻክንቶኔ መቶ መꬍዝ አስታይፕ ናግንቶይታ። ኡንታፕ ሃኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","የይ ጋርክ አሳይ ፋ ኡሎስ ኦꬅዛፕ አትን ኑ ጎዳ ክርስቶሳስ ኦꬆያ። ፋ ሊቆ ዶናራኔ ዎርዶ ቃላር ሃዮ ዎዛና ባልꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ዎንግላይስ ይ ኪትንቴዛና አስ ኡቢታይ ስኤዛይ ታና ኡፋይስዛ። ዝን ይ ሎኦ ባዝስ ኤጫ ኢታ ባዝስ ቦዞዳና ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ሳሮ ጾሳይ ጻላሃና ይ ቶካይፕ ኦሞር ኤልሲ ጋጮዳ። ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሄትꬃይ ይንታር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ታር ኦꬅዝ ጽማቶሳ፥ ታ ዳብታይ ሉቅዮሳ፥ ያሶነራ ሶስጲጽሮሳ ይንታን ሳሮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ꮊ ዳብዳባ ጻፌዝ ታኒ፥ ጻርጽዮሳ፥ ይንታን ጎዳይ ሱንꬃር ሳሮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ታና ሞኬዛይኔ ዎሳ ኬꬅ ኡቢታይ ሞክዛ ጋዮሳ፥ ይንታን ሳሮ ጌዛ። ካታማ ሚሸ አይክዝ ኤራስጾሳራ ኑ እሻ ቃርጾሳ ይንታን ሳሮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሄትꬃይ ይ ኡባይር ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ጾስስ ጋላታ ማቆ። ታኒ፥ የሱስ ክርስቶሳ ባዝ ኦድዝ ዎንግለ ቃላይር ብኒ ዎደፕ አይኪ ቆስንቲ ጋምኤዝ ቱማትꬃር፥ ጾሳይ ይንታን አማኖር ሚንꬂ ኤሶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ዝን Ꮊት የ ቱማይ በንቴዛ። ካተትꬂ ኡቢታይ አማኒ ኪትንቶዳይ ጋርክ መꬍና ጾሳ ኪታር ናብታይ የ ቱማባዝ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","የሱስ ክርስቶሳ ባጋር ኤጨትꬂ ኤ ኣዳስ የዛ፥ ፐቲ ጾሳይስ መꬍናስ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ጾስ ሸነር የሱስ ክርስቶሳስ ሀዋረ ማቆዳይስ ጼግንቴዝ ጳዉሎሳኔ፥ ኑ እሻ ሶስተናሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ቆሮንቶሳ የዝ ጾስ ዎሳ ኬꬅስ፥ የሱስ ክርስቶሳር ጌዤዝታኔ ጌሽ ማቆዳይ ጋርክ ጼግንቴዝታይስ፤ ማ ኡንትስኔ ኑስ ጎድ ማቄዝ ኑ ጎዳ የሱስ ክርስቶሳ ሱንꬃ ኡባ አቆ ጼግዝ ኡባይስ፤ ");
INSERT INTO mfxe_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ጾስ፥ ኑ አዳይፐኔ ኑ ጎዳ የሱስ ክርስቶሳፕ ኣꬎ ኬሄትꬅኔ ሳሮትꬅ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ጾሳይ ክርስቶሳ የሱሳ ባጋር ይንትስ እንጌዝ ኣꬎ ኬሃትꬃይ ግሾስ ታኒ ኡባ ዎደ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ኤዛይድ ኦዳራኔ ኤራትꬅ ኡባይር ይ ዱርቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ታኒ ክርስቶሳ ባጋ ማርካቴዛይ ቱማ ማቄዛይ ይንታል ሚንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","የይ ግሾስ፥ ይ ኑ ጎዳ የሱስ ክርስቶሳ ይእꬃ ናግታር የዝን፥ አባ አያና እሞካ ይንትስ ፓጨና። ");
INSERT INTO mfxe_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ኑ ጎዳ የሱስ ክርስቶሳ ማቅዝ ዎደ ይ ቦሮኔ ቦርሶ ባይꬅ ዉርስꬂ ሄሎዳይስ ይንታን ሚንꬂ ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ፋ ናአ፥ ኑ ጎዳ የሱስ ክርስቶሳር ፐትፐተꬃይ የዞዳይ ጋርክ ይንታን ጼጌዝ ጾሳይ አማንንትዛያ። ");
INSERT INTO mfxe_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ታ እሹንꬆ፥ ይ ጋንጨ ሻክንቶ የዛማይ ጋርክ ይ ፐቲ ዎዛናራኔ ፐቲ ቆፋር ፐቶ ማቂ፥ የዞድ ጋርክ ኑ ጎዳ የሱስ ክርስቶሳ ሱንꬃይር ታ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ታ እሹንꬆ፥ ቀሎኤ ካራ አሳይ ይ ጋንጨ እጾ የዛና ታስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ታ ግዛይ ይንታፕ ፐታይ ፐታይ፥ «ታኒ ጳዉሎሳስ፤ ታኒ አጵሎሳስ፤ ታኒ ጵጽሮሳስ፤ ታኒ ክርስቶሳስ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ክርስቶሳ ሻክንቴኔ? ይ ግሾስ ማዝቃለል አፋ ሶትንቴዛይ ጳዉሎሳኔ? ዎይ ይ ጳዉሎሳ ሱንꬃይር ጻማቅንቴነኔ? ");
INSERT INTO mfxe_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ታኒ ቃርስጶሳኔ ጋዮሳፕ አትን ይንትፕ ኦናካ ጻማቀካ ግሾስ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","የይ ግሾስ፥ ኦንካ ይንታን ታ ሱንꬃይር ጻማቅንቴዛ ጎዳይስ ዳንዳኦያ።  ");
INSERT INTO mfxe_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ማ ኢስጼፋኖሳ ካራ አሳካ ታ ጻማቄዛ፥ ዝን ሀራ ኦና ጻማቄዛኮ ታስ ቆፕንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ክርስቶሳ ታና ኪቴዛይ ዎንግለ ኦዶዳይ ጋርከፕ አትን ጻማቆዳይ ጋርክ ባያ። ክርስቶሳ ማዝቃለል አፋ Ꮊይቄዛይ ጨረ ማቃም ጋርክ ታኒ አስ ኤጨትꬅ ቃላር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ክርስቶሳ ማዝቃለል አፋ Ꮊይቄዛና ኦድዛ ቃላይ ꬋብዝታይስ ቦዞትꬂ፥ ዝን ኑስ አትዝታይስ ጾስ ዎልቃ። ");
INSERT INTO mfxe_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ጌሻ ማጻፋይድ፥ «ታኒ ኤጭታይ ኤጨትꬃ ꬋብሶዳ፤ አካካንችታይ አካካ ባልꬆዳ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","የዝን፥ ኤጫ አባ የኔ? ህገ አስታማረ አባ የኔ? ዎይ Ꮊ ሳአ ኤራንቻይ አባ የኔ? ጾሲ Ꮊ ሳአ ኤጨትꬃ ኤያትꬅ ኦꬄካሳ? ");
INSERT INTO mfxe_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ꮊ ሳአ አሳይ ፋ ኤጨተꬃር ጾሳ ኤራማይ ጋርክ ጾሲ ፋ ኤጨትꬃር ካይ፥ ቦዛትꬃር ፓይድንትዛ፥ ኑኒ ኦድዛ ቃላይድ አማንዝታ አሾዳይስ ጾሳ ሸነ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","አይሁድታይ ማላታ በአዳይስ ኮይዛ፤ ማ ግርክታይ ኤጨትꬅ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ዝን ኑኒ ማዝቃለል አፋ ሶትንቴዝ ክርስቶሳ ሳባክዛ። የይ አይሁድታይስ ꬉበ፤ ማ ግርክታይስ ቦዘትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ዝን ጾሳይ ጼጌዝታይስ፥ አይሁደ ማቅን፥ ግርኬ ማቅን ክርስቶሳ ጾስ ዎልቃኔ ኤ ኤጨትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ጾሳ ቦዘትꬃይ አስ ኤጨትꬃይፕ ኣꬍዛ፤ ማ ጾስ ዳቡራይ አስ ምኖትꬃይፕ ሚንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ይኬ፥ ታ እሹንꬆ፥ ጾሳይ ይንታን ጼጎዳር ይ አብ ጋርክ አስዛኮ ቆፖይታ። አስ ቆፋር ይ ጋንጨ ጋምታይ ኤጭታይ፥ ዎልቃምታይኔ ꬎቃ ኮችታይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ዝን ጾሳይ ኤጭታ ዬላꬆዳይስ አላመል የዝ ቦዝታ ዶሬዛ፤ ማ ምንꬅታ ዬላꬆዳይስ አላመል የዝ ዳቡሬዝታ ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ጾሳይ Ꮊ አላመል ግታ ግንትንቴዝባዝ ꬋብሶዳይስ፥ Ꮊ ሳአ ካዉዤዝባዝ፥ እጽንቴዝባዝኔ ፓꬆዋባዝ ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ኦንካ ጾስ ቲና ጬቅንታማይ ጋርክ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ዝን ጾሳይ ይንትስ ክርስቶሳ የሱሳር ፐትፐተꬃር የዞድ ጋርክ ኦꬄዛ። ኤ ኑስ ጾሳፕ ኤጨትꬂ፥ ጽሎትꬅ፥ ጌሸትꬅኔ ዋሎትꬅ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","የይ ግሾስ፥ ጌሻ ማጻፋይድ፥ «ጬቅንትዛ ኦንካ ጎዳይል ጬቆ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ታ እሹንꬆ፥ ታኒ ቲና ጾሳ ቃላ ይንትስ ኦድታታር የኤዝ ዎደ ዶና ቢላሞትꬃራኔ ኤጨትꬃር የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ታኒ ይንታር የዛ ዎደ ማዝቃለል አፋ ሶትንቴዝ የሱስ ክርስቶሳፕ አትን ሀራ ባዝ ኤራም ግ ታ ሙርቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ታ ይንታር የዝ ዎደ ዳቡራር፥ ያሻራኔ ኩኩርሳር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ታ ኪታኔ ታ ትምርታ ዶና ቢላሞትꬃራኔ ኤጨትꬃር ባዝን ጌሻ አያና ዎልቃ ቆንጭስꬃራ። ");
INSERT INTO mfxe_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","የይካ፥ ይ አማናይ ጾሳ ዎልቃይራፕ አትን አስ ኤጨትꬃል ካታማይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","አያና ደኦር ድጬዝታይስ ኑኒ ኤጨትꬅ ቃላር ኦድዛ። ዝን Ꮊ ኤጨትꬃይ፥ Ꮊ ሳአ ኤጨትꬅ ዎይ ꬋቦስ የዝ Ꮊ ሳአ ሀርዝታይ ኤጨትꬅ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ዝን ኑኒ ኦድዛ ኤጨትꬃይ፥ ጋመ ዎደፕ ቲና ጾሳይ ኑ ቦንቻይስ ጊግሴዛኔ ጌማ የዝ ጹራ ኤጨትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ꮊ ሳአ ሀርዝታይፕ ፐታካ Ꮊ ኤጨትꬃ ኤረካያ። ኡንቲ ኤሬዝባዝ ማቄዛኮ፥ ቦንቾ ጎዳ ማዝቃለል አፋ ሶታምዝን። ");
INSERT INTO mfxe_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ዝን ጌሻ ማጻፋይድ፥ «ኣፈ በኤካ ባዝ፥ ሀየ ስኤካባዝ፥ ዎዝና ቆፐካባዝ፥ ጾሳይ ፋ ዶስዝታይስ ጊግሴዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ጾሳይ ፋ ጹራ ፋ አያና ባጋር ኑስ ቆንጭሴዛ። ጌሻ አያናይ ሀራ አቶዝን ጌሜዝ ጾስ ጹራ ኡባ ፕላግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","አስ ጋንጨ የዝ አስ አያናፕ አትን አስባዝ ኦካ ኤሮያ። የይ ጋርከካ፥ ጾስ ባዝ ጾስ አያናፕ አትን ኦካ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ጾሳይ ኑስ ጨረ እንጌዝባዝ ኑ ኤሮዳይ ጋርክ ጾሳ አያና ኤኬዛፕ አትን Ꮊ ሳአ አያና ኤከካያ። ");
INSERT INTO mfxe_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ኑኒ አያና ባዝ፥ አያና አሳይስ አስ ኤጨትꬃር ባዝን ጾስ አያናይ እንግዛ ኤጨትꬃር ታማርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ዝን ጌሻ አያና ባ አስ ጾስ አያና እሞትታ ኤካሚ። የይ ኤስ ቦዘትꬂ፤ ኡባይ ጌሻ አያናር ፕላግንትዝ ግሾስ ኤ ኤሮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ዝን ጌሻ አያና የዝ አሲ ኡባ ባዝ ፕላግዛ፥ ዝን ኤዛ ኦካ ፕላጎያ። ");
INSERT INTO mfxe_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ጌሻ ማጻፋይድ፥ «ጎዳ ዎዝና ኤርዛይ ኦኖ? ኤዛ ዞሮዳይስ ዳንዳእዛይ ኦኖ?» ግንትንቲ ጻፍንቴዛይ ጋርከ። ኑስ ክርስቶሳ ዎዝና የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ታ እሹንꬆ፥ ይ አሾ አስኔ ክርስቶሳር ሀጋ ኦቼካ ዱደ ናአ ጋርክ የዝ ግሾስ ታኒ አያና ባዝ ይንትስ ኦዶዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ይ ሚንꬅ ካꬃ ማዳይስ ዳንዳኤካ ግሾስ ታኒ ይንታን ማꬅ ፓኬዛ፤ Ꮊተካ ይ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Ꮊተካ ይ አማኖዋ አስ ጋርክ የዛ። ይ ጋንጨ የዝ ቅናታይኔ ዎል እጻይ አማኖዋ አስ ጋርክ የዛና ኤርሶሳ? ይ አማኖዋ አስ ጋርክ ሀንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ይንታፕ ፐታይ፥ «ታኒ ጳዉሎሳስ» ሀራይ ማ፥ «ታኒ አጵሎሳስ» ጊኮ፥ አማኖዋ አስ ጋርክ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","የዝን፥ አጵሎሳ አባ? ጳዉሎሳ አባ? ኑኒ ይንታን አማንꬄዝ ጾስ ኦሳንችታ። ጾሳይ ፐታይስ ፐታይስ እንጌዝ ኦሳይ ጋርክ ኦꬅዛ ኦሳንችታ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ታ ቱኬዛ፤ አጵሎሳ ሃꬅ ኡሼዛ፥ ዝን ድቼዛይ ጾሰ። ");
INSERT INTO mfxe_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","የይ ግሾስ፥ ድቼዝ ጾሳይፕ አትን ቱክዛይካ ሃꬅ ኡሽዛይካ አኮካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ቱክꬅኔ ሃꬄ ኡሾ ዎል ጋርከ፥ ዝን ፐታይ ፐታይ ፋ ኦሳይ ጋርክ ጾሳይ እንግዛ ዎይታ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ኑኒ ፐትፕ ጾሳይስ ኦꬅዛ ኤዝ ኦሳንችታ ማቄዝ ግሾስ ይ ጾስ ኦሶ ጋደ፤ ጾስ ኬꬄ። ");
INSERT INTO mfxe_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ጾሳይ ታስ እንጌዝ ኣꬎ ኬሃትꬃይ ጋርክ ሂላንቾ አናጸ ጋርክ ባሶ ባሴዛ። ሀራይ ኤዛል አፋ ኬጽዛ። ዝን ኤዛል አፋ ኬጽዛ ኦንካ ዋይዚ ኬጽዛኮ፥ ፋሳ ናግንቶ። ");
INSERT INTO mfxe_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ፐቲ ቶኬ ባስንቴዝ ባሳይፕ ሀራ ባሶ ባሶዳይስ ኦንካ ዳንዳኦያ። የ ባሳይካ የሱስ ክርስቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ዝን Ꮊ ባሳይል አፋ ኦንካ ዎርቃር ዎይ ብራር ማቅን፥ አልኦ ሹቻር ዎይ ምꬃር ማቅን፥ ማታር ዎይ ሀዉለር ኬጽኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ፐቲ ፐቲ አስ የ ባሳይል አፋ አባር ኬጼዛኮ ፕርዳ ጋላስ ታማር ፓጭንት ኤርንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ኦንካ የ ባሳይል አፋ ኬጼዝ ኬꬃይ ታማር ጹግንተካ አትኮ፥ ፋ ዎይታ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ዝን ኦ ኦሶይካ ታማር ጹግንትኮ፥ የ አꬃይስ ዎይቶ ባያ። ሀኖ ዝን፥ ኤ ፋ ኦማስ ታማፕ ቡቲ ከዜዝ አስ ጋርክ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ይ ጾስ ኬꬅ ማቄዛኔ ጾስ አያናይ ይንታራ የዛና ኤረካሳ? ");
INSERT INTO mfxe_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ኦንካ ጾስ ኬꬃ ላልኮ፥ ጾስካ ኤዛ ላሎዳ። ጾስ ኬꬃይ ጌሺ፤ የ ኬꬃይካ ይንታና። ");
INSERT INTO mfxe_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ኦንካ ፋና ዶሽፐ። Ꮊ ሳአ ኤጨተꬃር ፋና ኤጫ ኡዲ ኤክዝ ኦንካ ጾስ ቲና ኤጫ ማቆዳይስ ቦዞ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ꮊ ሳአ ኤጫትꬃይ ጾስ ቲና ቦዘትꬂ። ጌሻ ማጻፋይድ፥ «ጾሲ ኤጭታ ኡ ገነ ቆፋይር አይኮዳ» ዬግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ማ፥ «ኤጭታይ ቆፋይ ማዶዋባዝ ማቄዛና ጎዳይ ኤርዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","የይ ግሾስ፥ ኡባይ ይንትስ ማቄዝ ግሾስ ኦንካ አሳል ጬቅንትፕ። ");
INSERT INTO mfxe_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳዉሎሳ ማቆ፥ አጵሎሳኔ ጵጽሮሳ ማቆ፥ Ꮊ አላማ ማቆ፥ ደኦ ማቆ፥ Ꮊይቆ ማቆ፥ Ꮊት የዛያ ማቅን፥ ቲናፕ የኦድ ኡባይ ይንትሲ። ");
INSERT INTO mfxe_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ይ ክርስቶሳሲ፤ ክርስቶሳካ ጾስሲ። ");
INSERT INTO mfxe_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","አሳይ ኑና ክርስቶሳ አይለ ጾስ ጹረ ቆንጭሶዳይስ ሀዳራ እንግንቴዝ አስ ጋርክ ኡዲ ቆፖ። ");
INSERT INTO mfxe_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","የ ሀዳራ ኤኬዝ አስታይ ፋ ጎዳይስ አማንንቴዝታ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ዝን ይንቲ ዎይ ሀራይ ታና ፕርድኮ፥ ታስ አኮካ ባያ። ሀራይ አቶ፥ ታካ ታል አፋ ፕርዳሚ። ");
INSERT INTO mfxe_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ታ ኤርዛይ ጋርክ ማቅኮ ታ ካሃይ ካጮያ፥ የይካ ታ ፎሎ ጌሽ ማቄዛና ቤዞያ። ታል አፋ ፕርዶዳይ ጎዳይ ኣዳ። ");
INSERT INTO mfxe_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","የይ ግሾስ፥ ዎደ ሄለካዝን፥ ጎዳይ የኦዳይፕ ቲና ኦላካ ፕርድፓተ። ኤ ꬉማ ጌንጌዝ ጹራ ፖኦ ከሶዳ፤ አስ ዎዛና ቆስንቴዝ ቆፋ ቆንጭሶዳ። የ ዎደ ፐታይ ፐታይ ጾሳይፕ ጋላታ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ታ እሹንꬆ፥ ይ ግሾስ ግ አጵሎሳናኔ ታና ኣዝሶ ኡዲ ይንትስ ኦዴዛ። የያ ታ ኦꬄዛይ፥ «ጻፍንቴዛይፕ ኣꬊፐ» ዬጊ ዞርዛና ይ ኑፕ ታማሮዳይ ጋርከሲ። የይ ግሾስ፥ ኦንካ ፐታ ጋይርንቶር Ꮊንካ ካꬎዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ነ Ꮊንክታይፕ አባር ኣꬊኔ? ኔኒ ኤከካባዝ አቢ የኔ? የዝን፥ ኔኒ ኤኬዝባዝ ሀራ አሳይፕ ኤኬዝ ማቅኮ፥ ኤከካ አስ ጋርክ አብስ ጬቅንትኔ? ");
INSERT INTO mfxe_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Ꮊት ይንትስ ቤዝዛ ባዝ ኡባ ይ ኤኬዛ። Ꮊት ይ ዱርቴዛ። ኑ ባይꬅ ይ ኣዳ ካዉቴዛ። ይ ቱማ ካዉቴዝባዝ ማቄዛኮ፥ ኑካ ይንታር ካዉቶዳዝን። ");
INSERT INTO mfxe_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ጾሳይ ኑና ሀዋርታ፥ Ꮊይቆስ ፕርድንቴዝ አስ ጋርክ አስ ኡባፕ ኑና ጉየ ኣꬄዛ ታስ ኣዝዛ። ኑኒ Ꮊ አላማይስ፥ ኪታንችታይስኔ አሳይስ ካስባዝ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ኑኒ ክርስቶሳ ግሾስ ቦዞ ማቄዛ፥ ዝን ይ ክርስቶሳር ኤጭታ ማቄዛ። ኑኒ ዳቡራ፥ ዝን ይ ሚንꬅ ማቄዛ። ይ ቦንችንቴዛ፥ ዝን ኑኒ ቶሽንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Ꮊኖ ሄሎዳይስ ኑ ናይንትዛ፥ ሳምንትዛ፥ ካሎትዛ፥ Ꮊꬊንትዛ፤ የዞድ ካምፓ ꬋብን ካእንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ኑኒ ኑ ኩሸ Ꮊንታር አቆድ ግ ዳቡርዛ። ኑና አሲ ባዶዳር ኑ አንጅዛ፤ ኑና ባይእꬆዳር ኑ ጋርዥዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ኑል አፋ ኢታ ባዝ ኦድንትዛ ዎደ ሎኦ ቃላ ኑ ማህዛ። ኑ Ꮊኖ ሄሎዳይስ Ꮊ አላመ ፕጻባዝኔ ዎራ ዎꬌዝ ቡሬ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ታኒ የያ ጻፍዛይ፥ ታ ሲቅዛ ናእታይ ጋርክ፥ ይንታን ዞሮዳይስ ጻፈዛይፕ አትን ዬላሶዳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ክርስቶሳር ይንታን ካልꬅዛ ፓይዶፕ ኣꬂ የዝኮካ፥ ጋመ አድታይ ባያ። ታ ይንታን ክርስቶሳ የሱሳ ዎንግላይር የሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ይኬ፥ ይ ታና ኣዝሶ ኡዲ ካሎድ ጋርክ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","የይ ግሾስ፥ አማንንቴዝ፥ ታ ሲቅዛ፥ ጎዳይ ባጋር ታ ናአ፥ ጽማቶሳ ይንትኮ ኪቴዛ። ኤ ዱማ ዱማ አቆ የዝ ዎሳ ኬꬃ ታ ታማርሴዝ፥ ክርስቶሳ የሱሳር የዝ ታ ኦጋ ይንታን ቆፍሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ታኒ ይንትኮ የአምባዝ ኣዝን፥ ኡትርትዛ ፐቲ ፐቲ አስታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ዝን ጎዳይ ጊኮ፥ ኡከራ ታኒ ይንትኮ የኦዳ። የ ዎደ ኡትራንችታይ ኦዳ ኣዳ ባዝን ኡንትስ አባ ዎልቃካ የዛኮ ታ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ጾስ ካተትꬃይ ኦዳ ኣዳ ባዝን ጾስ ዎልቃ። ");
INSERT INTO mfxe_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ታኒ ይንትኮ ጉፈራ Ꮊንጎነ ሲቆራኔ ሃዮ አያናራ Ꮊንጎ? ይ ኣያ ዶርኔ? ");
INSERT INTO mfxe_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ይ ጋንጨ ላግተ የዛይ ዝግርንትዛ። የይ ጋርክ ላግታ ሀራ አቶዝን፥ አማኖዋ አሳይካ ኦꬆያ። ይ ጋንጨ ፋ አደ ማችራ ቱኔዝ አሲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","የዝን ይ ቂራꬎዳይስኔ ዬላቶዳይስ ቤዝዛ፥ ዝን ኡትርትዛ። የይ ጋርክ ቦርሶ ባዝ ኦꬄዝ አꬃ ይ ጋንጨፕ ከሶዳይስ ቤዞሳ? ");
INSERT INTO mfxe_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ታኒ አሾር ይንታር የዛም እጽኮካ አያናር ታ ይንታር የዛ። ታኒ ይንታር የዝ አስ ጋርክ ሀኒ የይ ጋርክ ኦሳ ኦꬄዝ አꬃይል አፋ ፕርዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ኑ ጎዳ የሱስ ክርስቶሳ ሱንꬃር ይ ሺቆዳር ታኒ አያናር ይንታር የዞዳ። ኤዛይድ ጎዳ የሱስ ክርስቶሳ ዎልቃይ ይንታር ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","የ አꬃይ ናጋራ አሻይ ꬋብን፥ ኤ አያናይ ጎዳ የሱሳ ፕርዳ ጋላስ አቶዳይ ጋርክ ኤ ጻላሄስ ኣꬊ እንግንቶ። ");
INSERT INTO mfxe_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ይ ጋይርንታይ ሎኦ ባያ። ጽቃ እርሾ ሙኑቆ ኡባ ደንꬅዛና ይ ኤሮሳ? ");
INSERT INTO mfxe_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ይ Ꮊት እርሾ ባ ሙኑቆ ማቆዳይ ጋርክ፥ ናጋራ እርሾ ይንታፕ ከሶይታ። ኑስ ፓዝቃ ዱር ማቄዝ ክርስቶሳ ያርሽንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","የይ ግሾስ፥ ገነኔ ኢታትꬂ የዝ እርሾር ባዝን ቱማትꬃራኔ ጌሻትꬅ የዝ ቦራር ኑ ባለ ቦንቾዳ። ");
INSERT INTO mfxe_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ታ ቲና ጻፌዝ ዳብዳባይድ ይ ላግትዛ አሳና ሄላማይ ጋርክ ይንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","የያ ጉሳይ Ꮊ አላመል የዝ ላግትዝታ ዎይ ናጋራስ ተንቶትዝታ ዎይ ሱቃትዝታ ዎይ ቦንቂዝታ ዎይ ኤቃስ ጎይንዝታ ኡባር ሄልፓተ ጉስ ባያ። የያ ማቅኮ፥ Ꮊ አላማይፕ ይ ከዞዳይስ ቤዝዛ ዝን አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ዝን አማንዛ ጊንቲ ላግትዝታ ዎይ ተንቶትዛ ዎይ ኤቃስ ጎይንዝታይር ዎይ ጫዥዝታይር ዎይ ማꬅዝታይር ዎይ ቦንቂዝታይር ወል ሄልፓተ ግ ይንትስ ኦድዛ። የይ ጋርክ አሳይራ ሀራ አቶዝን፥ ካꬃካ ሚፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ዎሳ ኬꬃፕ ባለር የዝታይል አፋ ፕርዶዳይስ ታና አብ ሄልꬄ? ዎሳ ኬꬃ የዝታይል አፋ ይ ፕርዶሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ዝን ባለራ የዝታይል አፋ ጾስ ፕርዶዳ። የ ኢታ ባዝ ኦꬅዝ አꬃ ይ ጋንጨፕ ከሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ይ ጋንጨፕ ፐታይ ፐታይር ሞቶ የዛኮ፥ የያ አማንዛ አሳይ ቲና ፕርድንቶዳና አሺ አማኖዋ አስ ቲና ፕርድንቶዳይስ ዋይዚ ቤዜ? ");
INSERT INTO mfxe_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ጌሽታይ አላመል አፋ ፕርዶዳና ይ ኤሮሳ? የዝን፥ ይ አላመል አፋ ፕርድዛ ባዝ ማቅኮ፥ Ꮊይ ጋርክ ጽቃባዝ ፕርዶዳይስ ዋይዚ ዳንዳእንቶሳ? ");
INSERT INTO mfxe_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ኑኒ ኪታንችታይል አፋ ፕርዶዳና ይ ኤሮሳ? የዝን፥ Ꮊ ሳአ የሳል አፋ ፕርዶዳይስ ይንታን ዋይዚ ጋመ? ");
INSERT INTO mfxe_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","የዝን፥ የይ ጋርክ መቶ ይ ጋንጨ መꬍንትኮ፥ ዎሳ ኬꬅ ፐትፐተꬃፕ ባለር የዝታይኮኔ ቦርንቴዝ አሳይ ቲና ፕርድንቶዳይስ ዋይዚ ካንጌ? ");
INSERT INTO mfxe_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ታኒ ይንታን ዬላሶዳይስ የያ ግዛ። ይ ጋንጨ ካጭንቴዝ አስታ እንግꬆዳይስ ዳንዳእዛ አካክዛ አሲ ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","የዝን፥ ፐቲ አማንዛ እሻይ Ꮊንኮ አማንዛ እሻና ፕርዳ ኬꬅ አማኖዋ አሳይ ቲና ሞቶዳይስ ቤዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ይኬ፥ ይ ፐታይ ፐታ ሞትዛባዝ ማቅኮ የይ ይ ፖክꬃ ቤዝዛ። የይፕ ይ ቆህንትኮኔ ዶሽንትኮ ሎኣሞ? ");
INSERT INTO mfxe_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ዝን ይ ዎል ጋንጨ አማንዝታይ ፐታይ ፐታ ቆህዛኔ ዶሽዛ፥ የይካ ይ እሽታ። ");
INSERT INTO mfxe_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ዎርዥታይ ጾስ ካተትꬃ ላታማና ይ ኤሮሳ? ይንታን ዶሽፓተ፤ ተንቶትዝታይኔ ላግትዝታይ ዎይ ኤቃ ጎይንዝታይ ዎይ ቃይጽንትዝታይ ዎይ ꬊራꬂ ꬊራꬃር ፔዥዝታይ፥ ");
INSERT INTO mfxe_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ዎይ ካይዝታይ ዎይ ኡዝታይ ዎይ ማꬅዝታይ ዎይ ጫዥታይ ዎይ ቦንቅዝታይ ጾስ ካተትꬃ ላታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ይንታፕ ፐቲ ፐቲ አሳይ ቲና የይ ጋርከ። ዝን ይ Ꮊት ጎዳ የሱስ ክርስቶሳ ሱንꬃራኔ ጾስ አያናር ሜጭንቴዛ፤ ጌዤዛ፤ ጽሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","«ታስ ኡባ ባዝ እንግንቴዛ» ዝን ኡባይ ታና አዳሚ። «ታስ ኡባ ባዝ እንግንቴዛ»፥ ዝን አብካ ታና ሃራሚ። ");
INSERT INTO mfxe_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","«ካꬃ ኡሎስ፤ ኡሎካ ካꬃስ» ዝን ጾሳይ ኡሎካ ካꬃካ ꬋብሶዳና ታ ይንትስ ኦድዛ። ኑ አሰትꬃይ ጎዳይስፕ አትን ላግታስ ባያ። ጎዳይካ ኑ አሰትꬃይስ። ");
INSERT INTO mfxe_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ጾሳይ ጎዳ Ꮊይቆፕ ደንꬄዛይ ጋርክ፥ ኑናካ Ꮊይቆፕ ፋ ዎልቃር ደንꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ይ አሰትꬃይ ክርስቶሳ አሰትꬃይፕ ባጋ ማቄዛና ኤሮሳኔ? የዝን፥ ታኒ ክርስቶሳ አሰትꬃይፕ ባጋ ካንጊ ላግታ አሰትꬅ ማቆዳይ ጋርክ ኡዶ? ሀነና! ");
INSERT INTO mfxe_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ላግትዛ አꬃይ ኤ ፔዥዝ አስትራ ፐቲ አሰትꬅ ማቄዛና ይ ኤሮሳ? ጌሻ ማጻፋይድ፥ «ኡንቲ ናምአይ ፐቲ አሰትꬅ ማቆዳ» ግንትንት ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ዝን ጎዳይራ ፐትፕዛ አꬃይ ኤዛር አያናራካ ፐቶ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ላግታፕ ሃኮይታ። ፐቲ አꬃይ ኦꬅዝ ሀራ ናጋራ ኤ አሰትꬃፕ ባለራ ኦስንትዛ፥ ዝን ላግትዛ አስ ፋ አሰትꬃይል ናጋራ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ይ አሰትꬃይ ጾሳይ ይንትስ እንጌዝ ይንታር የዝ ጌሻ አያና ካራ ማቄዛና ይ ኤሮሳኔ? ይ ይንትስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ጾሳይ ይንታን ጋተር ዎንጌዛ። የይ ግሾስ፥ ይ አሰትꬃይር ጾስ ቦንቾይታ። ");
INSERT INTO mfxe_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ይ ታስ ጻፌዝ ዳብዳባይ ባጋ አሲ ማች ቦቻምንጽኮ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ዝን ላግታፕ አቶዳይስ ፐታይ ፐታይ ማቾ ፓስ ኤኮ፤ ማ ፐቲ ፐቲ ማችስካ አዝኒ የዞ። ");
INSERT INTO mfxe_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","አዝናይ ፋ ማችስ፥ ማ ማቻት ፋ አዝናይስ ቤዝዛ ባዝ ኡዶ። ");
INSERT INTO mfxe_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ማቻት ፋ አሰትꬃይል አፋ ኢስ ማዉተ ባያ፥ ዝን ማዉተ እ አዝናይስ። የይ ጋርከካ፥ አዝናይስ ኤ አሰትꬃይል አፋ ማዉተ ባያ፥ ዝን ማዉታይ ማቻትስ። ");
INSERT INTO mfxe_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ይ ዎሳር ጽቃ ዎደ ጋምኦዳይስ ዞረር ማቃም እጽኮ፥ ፐታይ ፐታ ካይፓተ። የይፕ ደንዴዛይድ ይንትናትꬃ ሃሮዳይስ ጋምንትን፥ ጻላሄ ይንታን ፓጫማይ ጋርክ ዎላ የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ዝን ታኒ ይንታን ዞሮዳይስ Ꮊያ ጌዛይፕ አትን አዛዞ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","አሲ ኡባይ ታ ጋርክ ማቾ ኤከካ የዝዛኮ ታ ዶስዛ፥ ዝን ጾሳይ ፐታይስ ፐታይስ እንጌዝ ዱማ ዱማ እሞታይ የዛ። ፐታይስ Ꮊይ ጋርክ Ꮊንካይስ ሀራ እሞታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ማቾ ኤከካዝታይስኔ አዝን ገለካዝታይስ ማ አምእታይስ ታኒ ግዛይ፥ ታ ጋርክ የዞይታ ግ ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ዝን አሞር ጹግንቶዳይፕ ኤክዛይኔ ገልዛይ ሎኦ ማቄዝ ግሾስ ኡንቲ ፋና ሃሮዳይስ ዳንዳአም እጽኮ፥ ኤኮነ ገሎ። ");
INSERT INTO mfxe_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ታኒ ኤኬዝታይስኔ ገሌዝታይስ Ꮊይ ጋርክ ግ ዞርዛ፤ ታና ባያ ጎዳይ አዛዝዛ፤ ማቻት ፋ አዝናይፕ ሻክንትፐ። ");
INSERT INTO mfxe_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ዝን ሻክንትኮ ሀራ አዝን ገለካ ፋ ኡባስ የዞ ዎይ ፋ አዝናይራ ጊጎ። አዝናይ ፋ ማቻት ብልፐ። ");
INSERT INTO mfxe_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ዝን Ꮊንክታይስ ጎዳ ባዝን ታኒ Ꮊይ ጋርክ ግዛ። አማኖዋ ማቻ የዝ አማንዛ አዝናይ የዚኮ፥ ማቻት ኤዛር ፐትፕ የዞዳይስ ኮይኮ እዞ ብልፐ። ");
INSERT INTO mfxe_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ማ አማኖዋ አዝኒ የዝ አማንዛ ማቻ የዚኮ፥ እ አዝናይ ኢር ፐትፕ የዞዳይስ ኮይኮ ኤፕ ብልንትፔ። ");
INSERT INTO mfxe_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","አማኖዋ አዝናይ ፋ አማንዛ ማቻት ባጋር ጌዥዛ፤ ማ አማኖዋ ማቻት ፋ አማንዛ አዝናይ ባጋር ጌዥዛ። የያ ባዛኮ፥ ይ ናእታይ ቱና ማቅዛ፥ ዝን Ꮊት ኡንቲ ጌሺ። ");
INSERT INTO mfxe_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ዝን አማኖዋ አዝና ዎይ ማቻት ብሎዳይስ ኮይኮ ብሎ። አማንዛ ማቻ ዎይ አዝናይ የይ ጋርክ ባዛር አጭንትፐ። ጾሳይ ኑና ሳሮትꬃር የዞዳይ ጋርክ ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","አማንዛ አስተ፥ አማኖዋ ነ አዝናይ ነ ባጋር አማኖዳዛኮ ነ ኤርኔ? ዎይ አማንዛ አꬃዮ፥ አማኖዋ ነ ማቻት ነ ባጋር አማኖዳዛኮ ነ ኤርኔ? ");
INSERT INTO mfxe_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ፐቲ ፐቲ አስ ጎዳይ ኤስ እንጌዝ እሞታይ ጋርከኔ ጾሳይ ኤዛ ጼጌዛይ ጋርክ የዛ። ዎሳ ኬꬅ ኡባይድ ታኒ ታማርሴዝ ዎጋይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ኦንካ ዶካልንቲ ጼግንቴዝባዝ ማቅኮ፥ ዶካልንቴካዛይ ጋርክ ሀንፔ። ዶካልንተካ አማኔዝ ኦንካ የዝኮ፥ ዶካልንቶዳይስ ኮይፐ። ");
INSERT INTO mfxe_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ጾስ ኪታ ፖሎዳይስ ቤዝዛይፕ አትን ዶካልንትን ዶካልንታም እጽን አኮስካ አዶያ። ");
INSERT INTO mfxe_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ፐቲ ፐቲ አስ ጾሳይ ፋና ጼጌዝ ዎደ የዛን ጋርክ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ጾሳይ ነና ጼጌዝ ዎደ ኔኒ አይለ? አኮካ ባያ የይስ ኡንእንትፐ። ዝን ኔኒ አይለትꬃፕ ዎዝንቶዳይስ ዳንዳእኮ ዎዝንቶባ። ");
INSERT INTO mfxe_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","አይለ ማቂ የዛር ጎዳር ጼግንቴዝ አስ ጎዳይፕ ደንዴዛይድ አይለትꬃፕ ዎዝንቴዛ። የይ ጋርከካ፥ አይለ ማቀካ የዛር፥ ጎዳይር ጼግንቴዝ አስ ክርስቶሳ አይለ። ");
INSERT INTO mfxe_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ጾሳይ ይንታን ጋተ ጭግ ዎንጌዝ ግሾስ አስ አይለ ማቅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ታ እሹንꬆ፥ ይ ፐታይ ፐታይ ጼግንቴዝ ዎደ የዝ የሳይር ጾሳር ዎላ የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ዉድርታይኔ ፓንꬅታይ ባጋ ጎዳይ ታና አዛዜዝ ባዝ ባያ። ዝን ጎዳይ ታስ እንጌዝ ማሮትꬃይ ጋርክ ታኒ ይንታን ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ይኬ፥ Ꮊ ዎዳይድ የዝ መታይ ግሾስ ኤከካ ዎይ ገለካ የስ ታስ ሎኦ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ነ ማቾ ኤኬዝ ባዝ ማቅኮ፥ አንጆዳይስ ኮይፐ። ነ ማቾ ኤከካባዝ ማቅኮ፥ ኤኮዳይስ ኮይፐ። ");
INSERT INTO mfxe_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ዝን ነ ማቾ ኤክኮ ናጋራ ባያ። የይ ጋርክ ዉድርታካ አዝን ገልኮ ናጋራ ባያ። ዝን ኤክዛ ገልዛ አሳይስ Ꮊ ሳአ ኢታ መቶ የዛ ግሾስ ይ የይፕ አቶዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ታ እሹንꬆ፥ ታ ግዛይ የያ፤ ዎደ ዉሬዛ። ይከፕ ቲና ማቻ የዛይ ማቾ ኤከካዛይ ጋርክ የዞ። ");
INSERT INTO mfxe_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ዬክዝታይ ዬኮዝታይ ጋርክ ማቆ፥ ኡፋይትዝታይ ኡፋይቶዚታይ ጋርክ፥ ዎንግዝታይ አኮካ ባዚታይ ጋርክ ፋና ፓይዶ። ");
INSERT INTO mfxe_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Ꮊ ሳአ ሻሎር ማድንትንትዝታይ ማድንቶዚታይ ጋርክ ማቆ። Ꮊ አላመ ማላይ ኣꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ይ ህርጋ ባይꬅ የዞዳይ ጋርክ ታ ዶስዛ። ማቾ ኤከካዛይ ጎዳ ኡፋይሶዳይስ ኮይዝ ግሾስ ጎዳይባዝ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ዝን ማቾ ኤኬዛይ ፋ ማቻቶ ኡፋይሶዳይስ ኮይዝ ግሾስ Ꮊ ሳአባዝ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ኤ ቆፋይ ናምእ አቆ ሻክንትዛ። አዝን ገለካ ዉድርታ ፋ አሰትꬃይራኔ ፋ ሸምፓይድ ጌዢ ጎዳ ኡፋይሶዳይስ ኮዬዝ ግሾስ ጎዳይ ባዝ ቆፕዛ። ዝን ኣዝን ገሌዛና ፋ አዝና ኡፋይሶዳይስ ኮይዝ ግሾስ ሳአባዝ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ታኒ የያ ይንትስ ኦዴዛ፥ ይ ማድንቶዳይ ጋርከፕ አትን ጽኬ ጋንጨ ገሊ ይ ኡንእንቶዳይ ጋርክ ባያ። ዝን ይ ቆፋይ ላልንተካ ማራር የዚ ጎዳ ኡፋይስዛ ባዝ ይ ኡዶድ ጋርክ ታኒ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ኦንካ ፋ ኦይጬዝ ዉድርቶ ገሎ ዎደ ኣꬌዛ ግ እዞ አሾዳይስ ቆፕኮ፥ የይ ማ ኢስ ሎኦ ባዛይ ስእንትኮ፥ ፋ ኮዬዛ ኦꬆ፤ ኡ ዎል ኤክኮ፥ ገልኮ፤ የይ ናጋራ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ዝን ፐቲ አስ ኡንእꬅዛ ባዝ ꬋብኮ፥ ፋ ዎዝናይር ሚንጊ፥ ፋና ሃሪ፥ ፋ ኦይጬዝ ዉድርቶ ኤከካ አሾዳይስ ኮይኮ ሎኦ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","የይ ግሾስ፥ ዉድርቶና ኤኬዝ አꬃይ ሎኦ ኦꬄዛ፤ ማ ኤከካ አꬃይ ኡባር ሎኦ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ማቻታ አዝናይ ፓጻ የዝ ዎደ ኡባይድ ኤዛር አጭንቴዛኖ። ዝን እ አዝናይ Ꮊይቅኮ፥ ፋ ዶሴዝ አዝና ገሎዳይስ ዳንዳእዛ። ሀኖ ዝን፥ እዛ ገልዛ አꬃይ አማንዛ አስ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ታ ቆፋር ማቅኮ፥ እዛ ገለካ የዝኮ ኡፋይሳር የዞዳ። ማ ታስ፥ ታር ጾሳ አያና የዛ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ኤቃስ ያርሽንቴዝ ካꬃ ባጋ ማቅኮ ኑ ኡባይ ኤርዛ። ኤራትꬂ ኡትርስዛ፥ ዝን ሲቆ ድችዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ኦንካ ፋና ኤርዛ ግ ቆፕኮ፥ ኤ ሀጋ ኤሮዳይስ ቤዝዛይ ጋርክ ሀጋ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ዝን ኦንካ ጾስ ሲቅኮ ኤ ጾስ ካንታ ኤርንቴዛያ። ");
INSERT INTO mfxe_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","የይ ግሾስ፥ ኤቃስ ያርሽንቴዝ ካꬃ ሙስባጋ ማቅኮ Ꮊ አላመል ጎዲ ፐቲ ጾሳይፕ አትን ሀራ ባ ግሾስ ኤቃ ፓꬆዋ ባዝ ማቄዛና ኑኒ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ጾስ ባዛር ሳሎራኔ ሳአር ጾሰ ግንትንቲ ጼግንትዝ ጋመ ጾስታይኔ ጎድታይ የዝኮካ፥ ");
INSERT INTO mfxe_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ኡባ ባዝ መꬌዝ፥ ኑ ኤ ባጋ ማቄዝ፥ ፐቲ ጾሳይ፥ አዳይ ኣዳ፥ ኑስ የዛ። ኡባይ ኤ ባጋር መꬍንቴዛ፥ ኑካ ኤ ባጋር የዝዝ ፐቲ ጎዳይ፥ የሱስ ክርስቶሳ ኑስ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ዝን የያ ኤርዝታይ ኡብታ ባያ። ፐቲ ፐቲ አሳይ ኤቃ ጎይንዛ ግሾስ ካꬃ ሚዝ ዎደ ኤቃስ ያርሽንቴዝ ባዝ ኡዲ ኤክዛ። የ ዎደ ኡ ካሃይ ዳቡራ ማቄዝ ግሾስ ቱንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ዝን ካꬃ ኑና ጾሳር ዳቦꬆያ። ኑ ማም እጽኮ አኮካ ቆህንታሚ፤ ማ ሚኮካ ማዳሚ። ");
INSERT INTO mfxe_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ዝን ይ ኮዬዝ ባዝ ማዳይስ ማዉተ ይንትስ የዝኮካ የይ አማኖር ምንገካዝታ ꬉባማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ኔኒ ነና ኤራንቾ ግ ኤቃስ ያርሽንቴዝ ካꬃ ማዳይስ ኤቃ ካራ በቴዝን፥ አማኖር ምንጌካዛይ ነና ብእኮ የይ ኤዛ ኤቃስ ያርሽንቴዝ ካꬃ ማዳይ ጋርክ ደንꬅꬆሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ይኬ፥ ነ ኤራትꬃይፕ ደንዴዛይድ ክርስቶሳ ኤ ግሾስ Ꮊይቄዝ፥ አማኖር ምንገካ ነ እሻይ፥ ꬋብዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","የይ ጋርክ ኡዲ፥ አማኖር ምንገካ ይ እሽታ ቆህታራኔ ኡ ካሃ ሱꬅታር ክርስቶሳና ቆህዛ። ");
INSERT INTO mfxe_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","የይ ግሾስ፥ ካꬃ ታ እሻ ꬉቢዛባዝ ማቅኮ፥ ኤ ꬉብንታማይ ጋርክ አሾ የሻ ታ ማሚ። ");
INSERT INTO mfxe_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ታኒ ማዉተር የዛ አስ ባሳኔ? ታ ሀዋረ ባሳኔ? ታኒ ኑ ጎዳ የሱስ ክርስቶሳ በኤካሳኔ? ጎዳይር ይ ታ ዳቡራ ኣፈ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ይ ጎዳይባዝ ማቄዝ ግሾስ ታ Ꮊንክታይስ ሀዋረ ማቃም እጽኮካ፥ ይንትስ ሀዋረ ማቅꬃይስ ይ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ታና ሀዋረ ባያ ግዝ አሳይስ ታ እንግዛ ማህꬃይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ኑ ማዳይስኔ ኡዦዳይስ ቱማ ኑስ ማዉተ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Ꮊንኮ ሀዋርታይ ጋርከኔ፥ ጎዳይ እሽታይ ጋርክ፥ ጵጽሮሳ ጋርክ፥ አማንዛ ኑ ማችታ ኤኪ የꬎዳይስ ኑስ ማዉተ ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ዎይ ኦꬆር አቆዳይስ ቤዝዛይ ታራኔ ባርናባሳ ኣዳ? ");
INSERT INTO mfxe_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ፋ ሚሻይር ዎታዳረትꬅ ኦꬅዛይ ኦኖ? ዎይ ዎይነ ቱኪ፥ ኤዛይፕ ኣፈ ሞዛይ ኦኖ? ዎይ ዉደ ሄንግታር፥ የ ዉዳይፕ ማꬅ ኡዦዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ታኒ የያ አስ ቆፋ ጋርክ ግነነ? ህገ የያ ግን ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ሙሰ ህጋይድ፥ «ዉዱማ ካꬃ ቡክዛ ገማተ ዶና አጭፐ» ግንትንት ጻፍንቴዛ። የዝን ጾሳይ የያ ገማታይስ ቆፒ ጌኔ? ");
INSERT INTO mfxe_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ጾሳይ የያ ጌዛይ ኑስ ቆፒ ባሳኔ? ኤ ኑ ግሾሲ። ቢታ ኦꬅዛይካ፥ ካꬃ ጌሽዛይካ ፋና ሄልዛ ግሻ ኤኮድ ግ ኡፋይሳር ኦꬆዳይስ ቤዝዛ ጊንትንቴዛይ ቱማ ኑ ግሾስ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ኑኒ ይ ጋንጨ አያና ዘርꬅ ዘሬዝ ማቅኮ አሾስ ቤዝዛ ባዝ ኑ ይንትፕ ማጽኮ፥ የይ ዳማ ባዞኔ? ");
INSERT INTO mfxe_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Ꮊንክታይ የያ ይንትፕ ኤኮዳይስ ኡንትስ ማዉተ የዝኮ፥ ኑስ ኡንቲሳይፕ ኣꬅ ማዉተ የዛ። ዝን ኑኒ ክርስቶሳ ዎንግለስ ꬉበ ማቃም ጋርክ፥ ኡባ ጋርዥነፕ አትን የ ማዉታይር ማድንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ጾስ ካራ ኦꬅዛ አስታይ ፋ ካꬃ ጾስ ካራፕ ኤክዛኔ ማ ያርሾ አቆ ኦꬅዝታይ ያርሾላፕ ኤኪ ሚዛና ይ ኤሮሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","የይ ጋርከካ፥ ዎንግለ ማርካትዝታይ የስስ ቤዝዛ ባዝ ዎንግላይፕ ኤኮዳይ ጋርክ ጎዳይ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ዝን ታኒ Ꮊ ማዉተ ኡቢታይድ አኮካ ማድንተካያ። ታኒ Ꮊያ ጻፌዛይ ታ ማዉተ ቦንችሶዳይስ ኮዪ ባያ። ኦንካ ታ ጬቃ ጨረ አሾዳይፕ Ꮊይቆ ታስ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ታኒ ዎንግለ ኦድዛይ ኪትንቴዝ ግሾሳፕ አትን ታና ጬቅስዛባዝ ባያ። ዎንግለ ኦዳም እጽኮ፥ ታና አየ። ");
INSERT INTO mfxe_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ታኒ ዎንግለ ዶሶር ሳባክኮ ታስ ዎይቶ የዛ። ዝን ታኒ ዎንግለ ዶሰካ አዛዝንቲ ሳባክዛባዝ ማቅኮ የያ ታ ሀዳራ ፖሌነፕ አትን ሀራ ታ ኦꬄዝ ባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","የዝን፥ ታ ዎይታይ አባ? ታኒ ዎንግለ ሳባክዛ ዎደ ታ ማዉተር ማድንተካ ዎንግለ ዳሞዘ ባይꬅ ጨረ ሳባክዛይ ታስ ዎይቶ። ");
INSERT INTO mfxe_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ታኒ ኦስካ አይለ ባያ፥ ዝን ጋምታ አሾዳይስ ኡባይስ አይለ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ታኒ አይሁድታ አሾዳይስ ኡንታር ኡንታን ማቄዛ። ታ ኦማስ ህገፕ ኦሞር ባያ፥ ዝን ህገፕ ኦሞር የዝታ አሾዳይስ ህገፕ ኦሞ የዝ አስ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ጾስ ህጋይፕ ባለ ከዘካ፥ ክርስቶሳ ህጋይስ ኪትንትታር፥ ህገ ባዝታ አሾዳይስ ህገ ባ አስ ጋርክ ታ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ታኒ ዳቡሬዝታ አሾዳይስ ዳቡራ ማቄዛ። ታኒ ጽቃ አስታ አሾዳይስ ኡባይር ኡባ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ታኒ ዎንግለ አንጆ ሻክንቶዳይስ፥ Ꮊ ኡባ ዎንግለ ግሾስ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ላሶ ኣላልዝ ኡባይ ላስዛ፥ ዝን ፐታይ ኣዳ ዎይቶ ኤክዛና ኤሮሳኔ? የይ ጋርክ ይንትካ ዎይታ ኤኮዳይስ ላሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ላስዛ አስ ኡባይ ኡባ ባዛር ፋና ሃርዛ። ኡንቲ የያ ዳቡርዛይ ꬋቦድ ዛዉደ ዎይቶ ኤኮዳይሲ። ዝን ኑኒ ዳቡርዛይ መꬍና ዛዉደ ዎይታ ኤኮዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","የይ ግሾስ፥ ታኒ ቆፋ ባ አስ ጋርክ ላሳም። ጫርኮ ዡልትዝ አስ ጋርክ ጨረ ኩሸ ዳካሚ። ");
INSERT INTO mfxe_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ዝን ታኒ ሀራይስ ዎንግለ ሳባኬዛይፕ ጉየ ታ ኦማስ ዎꬌዝ አስ ማቃማይ ጋርክ ታ አሰትꬃ ዎልቃር ዡልትታር ታስ አዛዝንቶዳይ ጋርክ ኡድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ታ እሹንꬆ፥ ታኒ ይ Ꮊያ አካኮዳይ ጋርክ ኮይዛ። ኑ አድታይ ኡባይ ሻራ ካልꬅን ሻራ ኦሞራ የꬌዛ፤ ኡባይ አባ ፒንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ኡንቲ ሙሰራ ፐትፖዳይስ ሻራራኔ አባ ጻማቅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ኡንቲ ኡባይ ፐቲ አያና ካꬃ ሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ማ ኡባይ ፐቲ አያና ኡሽ ኡዤዛ። ኡንታን ካልዛ አያና ዛላፕ ፑልቴዝ ኡሻ ኡዤዛ፤ የ ዛላይካ ክርስቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ዝን ጾሳይ ኡንታፕ ጋምታይል ኡፋይተካዛይ ግሾስ ኡ አሃይ ሊዦ ደምባ ዎꬊ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ኡንቲ ኢታ ባዝ አሞቴዛይ ጋርክ፥ ኑካ ኢታ ባዝ አሞታማይ ጋርክ የይ ኡባይ ኑስ ኣዝሶ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ጌሻ ማጻፋይድ፥ «አሳይ ማዳይስኔ ኡዦዳይስ በቴዛ፤ ማ የጾዳይስ ደንዴዛ» ግንትንቴዛይ ጋርክ ኡንታፕ ፐታይ ፐታይ ኤቃ ጎይኔዛይ ጋርክ ይ ኤቃ ጎይንፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ኡንታፕ ፐታይ ፐታይ ላሜዛይ ጋርክ ኑካ ናጋራ ኦꬆ። የይፕ ደንዴዛይድ ኡንታፕ ፐቲ ጋላስ ላታማኔ ሀይꬒ ሙኩሎ አስ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ኡንታፕ ፐታይ ፐታይ ጎዳ ፓጪ ሾሻር ዱክንቲ Ꮊይቄዛይ ጋርክ ኑ ጎዳ ፋጮዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ኡንታፕ ፐታይ ፐታይ ኦሊ Ꮊይቆ ክእዝ ኪታንቻይር ꬋቤዛይ ጋርክ ይንትካ ኦልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Ꮊ ኡንታል አፋ ሄሌዝ ኡባይ ኑ ናግንቶዳይ ጋርክ ኑስ ኣዝሶ ማቄዛ። ማ ዎደ ዉርስꬃል አፋ የዝ ኑስ ትምርተ ማቆዳይ ጋርክ Ꮊ ኡባይ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","የይ ግሾስ፥ ኤቄዛ ኣዝዝ ኦንካ ፖካማይ ጋርክ ፋና ናጎ። ");
INSERT INTO mfxe_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","አስ ኡባ ሄልዛ ፓጨፕ አትን ዱማ ፓጨ ይንታን ሄለካያ። ይ ዎልቃይ ዳንዳእዛይፕ ኣꬅ ፓጨር ይ ፓጭንታማይ ጋርክ ኣꬂ እንጎዋ ጾሳይ አማንንቴዛያ። ይንታን ፓጨ ሄልዛ ዎደ የ ፓጫይድ ኤ ይንታን ዳንዳእሶዳ። ማ የ ፓጫይፕ ይ ከዞድ ኦጋ ኤ ጊግሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ይኬ፥ ታ አልኦ እሹንꬆ፥ ኤቃ ጎይኖፕ ሃኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ይ ካሃማ አስ ማቄዝ ግሾስ ታ Ꮊያ ኦድዛ። ታኒ ግዛይ ቱማ ማቄዛና ይ ይ ኡባስ ፕርዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ኑኒ ጾስ ጋላቲ ሻክንትዛ አንጆ ጹአይ ክርስቶሳ ሱꬃር ፐትፐተꬂ የዛ ባሳኔ? ማ ኑኒ ሚዝ ቦራይ ክርስቶሳ አሻይራ ፐትፐተꬂ የዛ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ኑኒ ጋመ ማቅኮካ ቦራይ ፐቶ፥ ኑ የ ፐቲ ቦራ ሻክንትዛ ግሾስ ፐቲ አሰትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","አን እስሬለ አሳይ ኦꬄዛ አካኮይታ። ያርሽንቴዝ ያርሾ ሚዝታይስ ያርሾ በሳይራ ፐትፐተꬂ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ታኒ አብ ጎዳይስ ኮዪ ግኔ? ኤቃስ ያርሽንቴዝ ካꬃይ ዎይ ኤቃይ ፓꬅዛባዝ ጉሶኔ? ");
INSERT INTO mfxe_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ዋኣ፥ ኡንቲ ያርሽዛይ ጾስስ ባዝን ቱና አያንታይሲ። የይ ግሾስ፥ ይንትስ ቱና አያንታይራ ፐትፐተꬂ የዞዳይ ጋርክ ታ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ይ ጎዳይ ጹአይፕ ኡዥታር፥ ማ ቱና አያንታይ ጹአይፕ ኡዦዳይስ ይ ዳንዳኦያ። ጎዳ ጋይታይፕ ሚታር ማ ቱና አያንታይ ጋይታይፕ ማዳይስ ዳንዳኦዋ። ");
INSERT INTO mfxe_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ኑ የያ ኡዲ ጎዳ ሸንꬆ? ኑ ምኖትꬃር ኤፕ ኣꬊነኔ? ");
INSERT INTO mfxe_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ይ «ኡባ ባዝ ኑስ እንግንቴዛ» ዝን ኡባይ አዶያ። «ኡባ ባዝ ኑስ እንግንቴዛ» ግዛ ዝን ኡባ ባዝ አዶያ። ");
INSERT INTO mfxe_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ፐቲ ፐቲ አስ፥ ሀራ አስ ማድዛ ባዝ ቆፖዳይስ ቤዝነፕ አትን ፋና ማድዛ ባዝ ኣዳ ቆፕፐ። ");
INSERT INTO mfxe_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ይ ካሃይድ ስ መꬍዛ ሃሲ ጋበል ባይዝንትዛ አሾ ስእ ግ ሞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","አብስ ጊኮ፥ «ሳአኔ ሳአል የዝ ኡባይ ጎዳይሲ።» ");
INSERT INTO mfxe_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ፐቲ አማኖዋ አስ ይንታን እማቶስ ኮይ ጼግኮ Ꮊንጎዳይስ ኮይኮ Ꮊንጎይታ። ይ ካሃይድ ስካ ይ ቲና ኣꬅዛባዝ ኡባ ሞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ዝን ፐቲ አስ፥ «Ꮊይ ኤቃስ ያርሽንቴዝ ባዚ» ጊኮ፥ የ ይንትስ ኦዴዝ አꬃይ ግሾኔ ኤ ካሃይ ግሾስ የ ካꬃ ሚፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ታኒ፥ ካሃ ግሾስ ግ ይንትስ ኦድዛይ አꬃይ ካሃ ግነፕ አትን ይ ካሃ ባያ። ሀራ አስ ካሃ ግሾስ ግ ታኒ ታ ዋሎትꬃይል አብስ ፕርዶ? ");
INSERT INTO mfxe_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ታኒ ሚዝ ካꬃ ጾስ ጋላቲ ሚኮ ባልንቴዛያ ጋርክ አብስ ቦርንቶዴ? ");
INSERT INTO mfxe_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ይኬ፥ ይ አብ ሚኮ አብ ኡዥኮ፥ ዎይ አብ ኦꬅኮካ ኡባ ባዝ ጾስ ቦንቾስ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","አይሁድታ ማቅን ግርክታ ማቅን ዎይ ጾስ ዎሳ ኬꬃ ማቅን ኦስካ ꬉበ ማቅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ታኒ ኡባ ዎደ ጋምታ አሾዳይስ ኡንቲ ማድንትዛ ኦገ ኮይነፕ አትን ታና ማድዛ ኦገ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ታኒ ክርስቶሳ ኣዝዛይ ጋርክ፥ ይንትካ ታና ኣዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ይ ኡባ ባዛር ታና ቆፕዛ ግሾኔ ታ ታማርሴዝ ትምርትታ ሚንꬂ ናጌዝ ግሾስ ታ ይንታን ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ዝን ክርስቶሳ ꬊራꬅ ኡቢታይስ ኦማ፥ ꬊራꬂ ማችስ ኦማ፥ ማ ጾሳይ ክርስቶሳስ ኦማ ማቄዛና ይ ኤሮዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ፋ ኦማ ጉላንቲ ጾስ ዎስዛ ዎይ ትንቢተ ኦድዛ ꬊራꬂ ኡባይ ኦማ ማቄዝ ክርስቶሳ ቶችዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ፋ ኦማ ቃጨካ ጾስ ዎስዝ ዎይ ትንቢተ ኦድዝ ማቻት ኦማ ማቄዝ ፋ አዝና ቶችዛ። ፋ ኦማ ቃጨካ ማቻት ፋ ኦማ ሜድንቴዝ ማች አስ ጋርክ ፋይድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ማች አሲ ፋ ኦማ ቃጫም እጽኮ፥ ፋ ኦማ ጋችንቶ። ዝን ኢስ ኦማ ጋቾ ዎይ ሜዶ ቦርሶ ባዝ ማቅኮ ፋ ኦማ ቃጮ። ");
INSERT INTO mfxe_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ꬊራꬂ ጾስ ኣዝሶኔ ጾስ ቦንቾ ማቄዝ ግሾስ ፋ ኦማ ቃጮዳይስ ቤዞያ፥ ዝን ማቺ ꬊራꬅ ቦንቾ። ");
INSERT INTO mfxe_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ማቺ ꬊራꬃፕ መꬊንቴዛፕ አትን ꬊራꬂ ማቻፕ መꬍንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ማች አስ ꬊራꬅስ መꬍንቴነፕ አትን ꬊራꬂ ማችስ መꬍንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ꮊይ ግሾኔ ኪታንችታይ ግሾስ ማች አሲ ፓስ ማዉተ የዛና ቤዝዛ ማላ ፋ ኦማ ቃጮዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ዝን ጎዳይ ቆፋይድ ማች አሲ ꬊርꬅ ባይꬅ የዛሚ፤ ꬊራꬅካ ማች ባይꬅ የዛም። ");
INSERT INTO mfxe_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ማች አሲ ꬊራꬃፕ መꬍንቴዛይ ጋርክ ꬊራꬅካ ማቻፕ የልንቴዛ። ዝን ኡባይካ ጾሳፕ መꬍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","አን ይ ፕርዶይታ። ማች ፋ ኦማ ቃጨካ ጾስ ዎሶዳይስ ቤዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ꬊራꬂ ፋ ኦማ ድችኮ ኤስ ቦርሶ ማቄዛና ሀራ አቶዝን መትꬂ ታማርሶሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ዝን ማች ፋ ኦማ ድችኮ ኢስ ቦንቾ ባሳኔ? ማችስ ኦማ እንግንቴዛይ እዛ ፋና ካሞዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ዝን Ꮊይል አፋ ፓላሞዳይስ ኮዬዝ አስ የዝኮ፥ ኑስ ማቅን ዎይ ጾስ ዎሳ ኬꬅታይስ ማቅን Ꮊይፕ ሀራ ዎጋ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ይ ፐትፕ ሺቅዛይ ማድዛ ባዝ ባዝን ቆህዛ ማቄዝ ግሾስ Ꮊት ታ እንግዛ አዛዛይድ ይንታን ናሽቻሚ። ");
INSERT INTO mfxe_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ታ ቲና ስኤዛይ፥ ይ ዎሳ ኬꬃ ሺቆዳር ይ ጋንጨ ሻኮትꬂ የዛ። የያ ታ ስኤዛይፕ ባጋይ ቱማ ማቄዛና ታ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ይ ጋንጨፕ ቱማር የዝታይ ኦናንታዛኮ ኤርንቶዳይ ጋርክ ይ ጋንጨ ሻኮ የስ አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ይ ፐትፕ ሺቅዛ ዎደ ይ ሺቂ ሚዛይ ጎዳይ ካሆ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ይ ካꬃ ሚዝ ዎደ ፐታይ ፐታ ናገካ ፓሳ ፓሳ ሚዝ ግሾስ ፐታይ ናይንትዛ Ꮊንካይ ማ ማꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ቱማ ይ ማዳይኔ ኡዦዳይስ ይንትስ ካራ ባሳ? ዎይ ጾስ ዎሳ ኬꬅ ካꬊኔ? አኮካ ባ ማንቅታ ዬላꬆዳይሶኔ? ታ ይንታን ዋጎ? Ꮊይር ታ ይንታን ናሽቾ? ናሽቻሚ። ");
INSERT INTO mfxe_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ታኒ ይንትስ እንጌዝ ትምርትታ ጎዳይፕ ኤኬዛ። ጎዳ የሱሳ ኣꬊ እንግንትዝ ቃማ ቦራ ኤኪ፥ ");
INSERT INTO mfxe_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ጾስ ጋላቲ። ቦራ ባጺ «Ꮊሽተ፤ ሞይታ። Ꮊይ ይንትስ እንግንትዛ ታ አሾ። Ꮊያ ሚታር ታና ቆፖይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","የይ ጋርከካ፥ ካሃ ም ማቅን፥ ጹአ ኤኪ፥ «Ꮊ ጹአይ ታ ሱꬃር ጫቅዝ ኦሮꬅ ጫቆ። ይ ኤዛይፕ ኡዥታር ኡባ ዎደ ታና ቆፖይታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ይ Ꮊ ቦራ ሚዝ ዎደኔ Ꮊ ጹአ ኡዥዝ ዎደ ኡባይድ ጎዳይ የኦድ ሄሎዳይስ ኤ Ꮊይቃ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","የይ ግሾስ፥ ቤዞዋ ኦገር ጎዳይ ቦራ ሚዝ ዎይ ጎዳይ ጹአ ኡዥዝ ኦንካ ኤዝ አሻኔ ሱꬃ ቶቼዝ ግሾስ ፋ ናጋራይስ ኦይጭንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ዝን አስ ፋና ፋጮ። ዬዚ ቦራ ሙዬ፤ ጹአይፐካ ኡዦ። ");
INSERT INTO mfxe_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ጎዳይ አሻይ ባጋ ሻኪ ኤረካ፥ ቦራ ሚኮኔ ጹአይፕ ኡዥኮ፥ ፋል አፋ ፕርዳ ሺሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","የይ ግሾስ፥ ይ ጋንጨፕ ጋምታይ ዳቡሬዛ፤ ሀርግንቴዛ፤ ማ ጋመ አስታይ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ዝን ኑ ኑና ፓጪ በኤዝ ባዝ ማቄዛኮ፥ ኑል አፋ ፕርድንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","አላመ ፕርድንትዛ ዎደ ኑ አላማይራ ፕርድንታማይ ጋርክ Ꮊት ጎዳይ ኑና ሴርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","የይ ግሾስ፥ ታ እሹንꬆ፥ ጎዳይ ካሆ ማዳይስ ይ ሺቅዛ ዎደ ዎል ናጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ይ ሺቃይ ፕርዳስ ማቃማይ ጋርክ ናይንቴዝ ኦንካ የዝኮ፥ ፋ ካራ ሙየ። አቴዝባዝ ታኒ ገድ Ꮊንጊ ይንትስ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ታ እሹንꬆ፥ ጌሻ አያና እሞትታይ ባዝካ ይ ኤሮዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ይ ጾስ አማኖዋ ዎደ ዶና ባ ኤቃኮ ጎሽንት፥ ይ ኤሮዋዝታይራካ Ꮊንጌዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ጾስ አያናይ ካልꬅዛ አስ ኦንካ፥ «የሱስ ቃንግንቶ» ዬጎያ። ማ ጌሻ አያናይ ካልꬄካዝን፥ ኦንካ፥ «የሱስ ጎዳ» ጎዳይስ ዳንዳኦዛና ይ ኤሮዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ዱማ ዱማ አያና እሞትታይ የዛ፥ ዝን እሞትታ እንግዛ አያናይ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ኑ ጎዳይስ ኦꬅዛ ዱማ ዱማ ኦስታይ የዛ፥ ዝን ጎዳይ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ኑ ጎዳይስ ኦꬅዛ ዱማ ዱማ ኦግታይ የዛ፥ ዝን የ ኦጋይር አስ ኡባይር ኦꬅዝ ጾሳይ ፐታ። ");
INSERT INTO mfxe_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ዝን ፐታይስ ፐታይስ እንግንቴዝ ቆንጭꬅ እሞትታይ ዎላ ማድንቶዳይ ጋርክ። ");
INSERT INTO mfxe_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ጌሻ አያናይ ፐታይስ ኤጨትꬂ ኩሜዝ ቃላ እንግዛ፤ ማ ፐታይስ ኤራትꬂ ኩሜዝ ቃላ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","የ ጌሻ አያናይ ፐታይስ አማኖ፥ Ꮊንካይስ ማ ፓꬅዛ ዎልቃ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ጌሻ አያናይ ፐታይስ ማላታ ኦꬅዛ ዎልቃ፥ ፐታይስ ትንቢተ ኦድዛ ዎልቃ እንግዛ። ፐታይስ አያናፕ አያና ሻኪ ኤርዛ ዎልቃ፥ ፐታይስ ዱማ ዱማ ዶናር ኦድዛ ዎልቃ፥ ማ ፐታይስ ዱማ ዱማ ዶናር ኦድንቴዛና ብልዝ ዎልቃ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ዝን Ꮊ ኡባ ኦꬅዛይ የ ፐቲ ጌሻ አያና። ኤ ኮዬዛይ ጋርክ ፐታይስ ፐታይስ ዱማ ዱማ እሞታ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ፐቲ አሰትꬃል ጋመ ብልትታይ የዛ፥ ዝን የ ዱማ ዱማ ብልትታይ ፐቲ አሰትꬅ ማቅዛ። የይ ጋርከካ፥ ክርስቶሳ ዱማ ዱማ ብልትታይ የዝ ፐቲ አሰትꬅ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ኑኒ አይሁደ ማቅን ግርኬ ማቅን አይለ ማቅን ዎማኖ ማቅን፥ ኡባይ ፐቲ አሰትꬅ ማቆዳይስ ጌሻ አያናር ጻማቅንቴዛ። ማ ኑ ኡባይ ፐቲ ጌሻ አያና ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ኑ አሰትꬃል ዱማ ዱማ ብልትታይ የዛፕ አትን ፐቲ ብልተ ኣዳ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ቶካይ፥ «ታኒ ኩሸ ማቀካ ግሾስ ብልተ ባያ» ጊኮ፥ ኤ የያ ጌዝ ግሾስ ብልተትꬃይ አትኔ? ");
INSERT INTO mfxe_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ሀየ፥ «ታኒ ኣፈ ማቀካ ግሾስ ብልተ ባያ» ጊኮ፥ ኤ የያ ጌዝ ግሾስ አሰትꬃፕ ፐቲ ብልተ ማቅꬃይ አትነኔ? ");
INSERT INTO mfxe_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","አሰትꬅ ኡባይ ኣፈ ኣዳ ማቅኮ፥ ኑ አባር ስኦዴ? ማ አሰትꬅ ኡባይ ሀየ ኣዳ ማቅኮ ኑ አባር ስንጎደ? ");
INSERT INTO mfxe_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ዝን ጾሳይ ፋ ኮዬዛይ ጋርክ፥ አሰትꬅ ጋንጨ ዱማ ዱማ ብልትታ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ኡባይ ፐቲ ብልተ ማቄዛኮ አሰትꬂ አናፕ በንቶደ? ");
INSERT INTO mfxe_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ዝን ብልትታይ ጋመ ማቅኮካ፥ አሰትꬃይ ፐቶ። ");
INSERT INTO mfxe_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ኣፈ ኩሸኮ፥ «ነ ታስ ኮሾያ» ጎዳይስ ዳንዳኦያ፥ ዎይ ኦማ ቶሄኮ፥ «ነ ታስ ቤዞያ» ጎዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ዝን ዳቡራ ኣዝዝ አሰትꬅ ብልትታይ ኑስ ኡሳ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ቦንቾ ኮሾዋ ግ ኑ ቆፕዛ ኑ ብልትታ ሎእꬂ ቦንቾዳ። ማ ኑ ቦርስንትዛ ኑ አሰትꬅ ብልትታ ኣꬂ ቦንቺ ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ኑ ብእን ቦርሶዋ አሰትꬅ ብልታይስ ቦንቾ ኮሾያ። ዝን ጾሳይ ኑ አሰትꬅ ብልትታ ዎል ሄልꬂ ቦርስዛ ብልታይስ ኣꬊዝ ቦንቾ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","አሰትꬅ ብልትታይ ፐታይ ፐታይር ሻኮ መካ ዎል ቆፖዳይ ጋርክ ኡዲ መꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","አሰትꬅ ብልትታይፕ ፐታይ ሀርግንትኮ ብልትታይ ኡባይ ኤዛር ሀርግንትዛ። አሰትꬅ ብልትታይፕ ፐታይ ቦንችንትኮ ብልትታይ ኡባይ ኤዛር ኡፋይትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ይ ኡባይ ክርስቶሳ አሰትꬅ፤ ማ ይ ፐታይ ፐታይ ኤ ብልትታ። ");
INSERT INTO mfxe_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ዎሳ ኬꬃ ጾሳይ፥ ቲና ሀዋርታ፥ ናምእንꬆ ናብታ፥ ሃይꬒንꬃ አስታማርታ፥ ካሊ ማላትታ ኦꬅዝታ፥ ፓꬅዝታ፥ Ꮊንክታ ማድዝታ፥ ዎሳ ኬꬅ አቅዝታኔ፥ ዱማ ዱማ ዶናር ኦድዝታ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ኡባይ ሀዋረ? ኡባይ ናበ? ኡባይ አስታማረ? ኡባይ ማላታ ኡድነ? ");
INSERT INTO mfxe_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ኡባይ ፓꬅኔ? ኡባይ ዱማ ዱማ ዶናር ኦድንትኔ? ኡባይ ዱማ ዱማ ዶናር ኦድንትዛና ብልእኔ? ");
INSERT INTO mfxe_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ዝን ኡባይፕ ኣꬊዝ እሞታ ሚንꬂ ኮዮይታ። ማ ኡባይፕ ኣꬊዝ ኦጋ ታ ይንታን ቤዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ታኒ አስ ዶናራኔ ኪታንቾ ዶናር ኦድንቶዳይስ ዳንዳእኮካ፥ ታስ ሲቆ ꬋብኮ፥ ጊርዝ ዳላ ዎይ ኦሽዝ ዎርለ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ትንቢተ ኦድዝ እሞታ ታስ የዝኮካ፥ ጹራ ኡባ ኤርኮካ፥ ኤራትꬂ ኡባይ የዝኮካ፥ ማ አምባ ደንꬂ ሀራ አቆ ካንግዛ አማኖ ታስ የዝኮካ፥ ሲቆ ꬋብኮ፥ ታ ጨር ሀንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ታስ የዛ ባዝ ኡባ ማንቆስ እንግኮካ፥ ሀራ አቶዝን፥ ታና ታማስ ኣꬂ እንግኮካ፥ ሲቆ ꬋብኮ ታና አኮካ አዳሚ። ");
INSERT INTO mfxe_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ሲቆ ዳንዳእዛ። ሲቆ ኬሃ። ሲቆ ቃናቶያ። ሲቆ ጬቅንቶያ። ሲቆ ኡትርቶያ። ");
INSERT INTO mfxe_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ሲቆ ቤዞዋባዝ ኦꬆያ። ሲቆ ኡዛቶያ። ሲቆ ይሎቶያ። ሲቆ ቆሆ ፓይዶያ። ");
INSERT INTO mfxe_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ሲቆ ቱማር ኡፋይትነፕ አትን ዎርዠር ኡፋይቶያ። ");
INSERT INTO mfxe_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ሲቆ ኡባ ዳንዳእዛ፤ ኡባ አማንዛ፤ ሎኦ ባዝ ሀኖዳ ግ፥ ኡፋይሳር ናግዛ፤ ኡባ ባዛር ሚንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ሲቆ ዉርስꬂ ሄሎዳይስ ꬋቦያ። ዝን ትንቢተ አቶዳ፤ ዱማ ዱማ ዶናር ኦድንትዛይ አቶዳ፤ ኤራትꬃይካ ኣꬎዳ። ");
INSERT INTO mfxe_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ኑ ኤራትꬃፕ ላፋ ኤርዛ፤ ትንቢተፕ ባጋ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ዝን ፎሎ ማቄዛይ የኤዝ ዎደ ፎሎ ባዛይ አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ታኒ ናአዛር ናአ ጋርክ ናሽዛ፤ ናአ ጋርክ ቆፕዛ፤ ናአ ጋርክ አካክዛ። ታ ዎዛናማ ማቄዝ ዎደ ናአትꬅ ሀና አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","Ꮊት ፖኦ ባ አቆ ማስቶተር ብእዛይ ጋርክ ኑ ብእዛ፥ ዝን የ ዎደ ኑ ቆንጨር በአዳ። Ꮊት ኑ ኤረትꬃፕ ጽቃ ኤርዛ፥ ዝን የ ዎደ ጾሳይ ኑና ኤርዛይ ጋርክ ፎሎ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ይኬ፥ አማኖ፥ ኡፋይስኔ ሲቆ፥ Ꮊ ሃይꬒታይ ኤቂ የዞዳ። ዝን Ꮊይትታይፕ ኣꬍዛይ ሲቆ። ");
INSERT INTO mfxe_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ሲቆ ካሎይታ። አያና እሞትታ ሚንꬂ ኮዮይታ፤ ኡባፕ ኣꬂ፥ ትንቢተ እሞታ ሚንꬂ ኮዮይታ። ");
INSERT INTO mfxe_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ዱማ ዱማ ዶናር ኦድንትዛ አሲ ጾሳይስ ኦድዛፕ አትን አስስ ኦዶያ። ዝን አስስ ቆንጨካ ጹራ አያና ዎልቃር ኦድንትዛ ግሾስ ኦንካ ኤ ኦድንትዛና አካኮያ። ");
INSERT INTO mfxe_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ዝን ትንቢተ ኦድዝታይ አስ ድቾዳይስ፥ ምንꬃꬆዳይስኔ ጻልሶዳይስ አስስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ዱማ ዱማ ዶናር ኦድዛ አስ ፋና ድችዛ። ዝን ትንቢተ ኦድዛ አስ ዎሳ ኬꬅ ድችዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ይ ኡባይ ዱማ ዱማ ዶናር ኦድንትዛኮ ታ ዶስዛ፥ ዝን ትንቢተ ኦድዛኮ ታ ኡሳ ዶስዛ። ዱማ ዱማ ዶናር ኦድንትዛና ዎሳ ኬꬅ ድችስ ብልእዝ አስ ꬋብኮ፥ ዱማ ዱማ ዶና ኦድንትዛይፕ ትንቢተ ኦድዛይ ኣꬍዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ዝን ታ እሹንꬆ፥ ታኒ ይንትኮ Ꮊንጊ ቆንጭꬃር ዎይ ኤራትꬃር ዎይ ትንቢተ ኦዶር ዎይ ትምርተ ባይꬅ ዱማ ዱማ ዶናር ኦደንትኮ ይንታን አብ ማዶዴ? ");
INSERT INTO mfxe_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ዱማ ዱማ የꬅ ሚሻይስ ፐቲ ግርꬂ የዝኮ፥ ሹልሹሎ ግርስነ ዲꬅ ግርስ ዋይዚ ሻኪ ኤሮዴ? ");
INSERT INTO mfxe_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ማ ቱልቱሎ ፑጎ ሻኪ ኤርንታም እጽኮ ኦላስ ጊግንትዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","የይ ጋርከካ፥ ዱማ ዱማ ዶናር ይ ኦድንትዛይ ቆንጨ ማቃም እጽኮ ይ ኦድዛ ኦኒ ኤሮዴ? የይ ጫርኮር ኦድንትዛይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Ꮊ አላመል ጋመ ዶንታይ የዛ፤ የ ኡባይስ ብልእꬂ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ዝን ፐቲ አሲ ኦድንትዛ ዶና ታኒ ኤራም እጽኮ ኤ ታስ እማꬄ ማቅዛ፤ ታካ ኤስ እማꬄ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","የይ ጋርከካ፥ ጌሻ አያና እሞታ ይ ኤኮዳይስ ሚንꬂ ኮይኮ፥ ዎሳ ኬꬅ ድቻይስ ኡባፕ ኣꬊዝ እሞታ ኮዮይታ። ");
INSERT INTO mfxe_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ዱማ ዱማ ዶናር ኦድንትዛ አስ ፋ ኦዳ ብሎዳይስ ብርሽꬅ እሞታይ እንግንቶዳይ ጋርክ ጾሳ ዎሶ። ");
INSERT INTO mfxe_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ታኒ ዱማ ዱማ ዶናር ጾስ ዎስኮ፥ ታ አያናይ ዎስዛ፥ ዝን ታ ዎዝናይ አኮካ ማድንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","የዝን፥ ታ አብ ኦꬆዳይስ ኮሼ? ታኒ ታ አያናር ዎስዛ፤ ታ ካሃይራካ ዎስዛ። ታኒ ታ አያናር የጽዛ፤ ታ ካሃይራካ የጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","የያ ማቃም እጽኮ ኔኒ ነ አያናር ጾስ ጋላትዛ ዎደ የ አቃይድ ኔኒ ግዛ ኤረካ አስ ነ ጋላትዛ ዎደ፥ «አምንኤ» ጎደ? ");
INSERT INTO mfxe_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ኔኒ ጾስ ጋላትዛይ ሎኦ፥ ዝን ሀራ አስ ማዶያ። ");
INSERT INTO mfxe_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ታ ይ ኡባይፕ ኣꬂ ዱማ ዱማ ዶናር ኦድንትዛ ግሾስ ጾስ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ዝን ታኒ ዎሳ ኬꬃ ሀርታ ታማርሶዳይስ ዱማ ዱማ ዶናር ታጲ ሙኩሎ ቃላ ኦድንትዛይፕ ኤርንትዛ ዶናር እችን ቃላ ኦዶ ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ታ እሹንꬆ፥ ይ ኢታ ቆፋስ ናእታይ ጋርክ ማቆይታፕ አትን ቆፓር ናአ ማቅፓተ ዎዛናምታ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ጎዳይ፥ ጌሻ ማጻፋይድ፥ «ታኒ Ꮊ አሳይስ፥ ዱማ ዱማ ዶናር ኦድንትዛ አሳይራኔ እማꬅ ዶናር ኦድንትዛ አሳይር ኦድዛ። ዝን የይ ሀንንካ ታና ስኦያ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ይኬ፥ ዱማ ዱማ ዶናር ኦዳይ፥ አማኖዋ አሳይስ ማላ ማቅነፕ አትን አማንዛ አሳይስ ባያ። ትንቢተ አማንዛ አሳይስ ማላ ማቅነፕ አትን አማኖዋ አሳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ዎሳ ኬꬅ አሳይ ፐትፕ ሺቄዝ ዎደ ኡባይ ዱማ ዱማ ዶናር ኦድንትኮ ኤሮዋ ዎይ አማኖዋ አሳይ ይ ሺቆ ይኢ፥ «Ꮊይትታይ ኤይዛ» ጎሳነ? ");
INSERT INTO mfxe_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ዝን ኤሮዋ ዎይ አማኖዋ አሳይ ዎሳ ኬꬅ ገልዛ ዎደ አሳይ ትንቢተ ኦዶዳር፥ ስእኮ ፋ ናጋራ አካኮዳ፤ ማ ኤ ስኤዝ ቃላይድ ፕርድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ኡንቲ ኤ ዎዛና ጌሜዝ ቆፋ ቆንጭሶዳ። የይ ጋርከካ፥ «ቱማ ጾሳይ ይ ጋንጨ የዛ» ዬጊ ማርካቲ፥ ጹጉኒ ጾሳይስ ጎይኖዳ። ");
INSERT INTO mfxe_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ታ እሹንꬆ፥ ኑ ዋጎ? ይ ፐትፕ ሺቅዛ ዎደ ፐታይስ ማዝሙረ የዛ፤ ፐታይስ ታማርሶ እሞታይ የዛ፤ ፐታይስ ቆንጭꬂ የዛ፤ ፐታይስ ዱማ ዱማ ዶናር ኦድንቶ የዛ፤ ፐታይስ ብልእዝ እሞታይ የዛ። የ ኡባይ ዎሳ ኬꬃና ድችዛባዝ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ዱማ ዱማ ዶናር ኦድንትዛ አስታይ የዝኮ፥ ናምኤ ዎይ ጋንግኮ ሀይዝ ማቅኮ ማራር ማራር ናግንቲ ኦዶዳይስ ቤዝዛ። ኡንቲ ኦድንትዛና ሀራ አስ ብሎ። ");
INSERT INTO mfxe_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ዝን ብልዝ አስ ꬋብኮ፥ ዱማ ዱማ ዶናር ኦድንትዛይ ዎሳ ኬꬃ ስእ ጎ። ፋስኔ ፋ ጾሳይስ ኦዶ። ");
INSERT INTO mfxe_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ትንቢተ ኦድዝታይ ናምኤ ዎይ ሀይዝ ማቂ ኦዶ። ማ Ꮊንክታይ ኡንቲ ግዝባዝ ሻኮ። ");
INSERT INTO mfxe_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","የ ሺቃይድ የዝ ሀራ አስስ ፐትባዝ ቆንጭኮ ቲና ኦድንትዛይ ስእ ጎ። ");
INSERT INTO mfxe_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ኡባይ ታማሮዳይ ጋርከኔ ኡባይ ሚንጎዳይ ጋርክ ማራር ማራር ትንቢተ ኦዶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ናብታይ አያናይ ናብታይስ አዛዝንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ጾሳይ ሳሮትꬅ ጾሳፕ አትን ጫቦ ጾስ ባያ። ጌሽታይ ዎሳ ኬꬅታይ ኡባይ የይጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ማችታይ ዎሳ ኬꬅ ሺቆ ስእ ጎ። ህገ ግዛይ ጋርክ ኡንቲ ሃርንቶፕ አትን ዎሳ ኬꬃ ኦዶዳይስ ኡንትስ ማዉተ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ማችታይ ዎሳ ኬꬃ ኦድንቶ ቦርሶ ማቄዝ ግሾስ ፐቲ ፐትባዝ ኤሮዳይስ ኮይኮ ካራ ፋ አዝና ኦይጮ። ");
INSERT INTO mfxe_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ጾስ ቃላ ቲና ይ ከኤኔ? ዎይ ጾስ ቃላይ ይ ኣዳኮ የኤኔ? ");
INSERT INTO mfxe_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ኦንካ ፋና ናበ ዎይ ፋና ጾስ አስ ግ ቆፕኮ፥ ታኒ ይንትስ ጻፌዛይ ጎዳይ አዛዞ ማቄዛና አካኮ። ");
INSERT INTO mfxe_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ዝን ኦንካ ኤራም እጽኮ ኤካ ኤርንትፐ። ");
INSERT INTO mfxe_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","የይ ግሾስ፥ ታ እሹንꬆ፥ ትንቢተ ኦዶዳይስ ሚንꬂ አሞቶይታ፤ ማ ዱማ ዱማ ዶናር ኦድንታካ ካይፓተ። ");
INSERT INTO mfxe_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ዝን ኡባይካ ዎጋራኔ ማራር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ታ እሹንꬆ፥ ታ ይንትስ ማርካቴዝ ዎንግለ ይ ኤኬዛኔ ይ አማናይድ ሚንጊ ኤቄዛና ይ አካኮዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ታ ታማርሴዝ ዎንግለ ሚንꬂ አይክኮ ይ ኤዛይር አቶዳ። የይ ሀናም እጽኮ ይ አማናይ ጨረ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ታኒ ኤኬዝ ኡባይፕ ኣꬊዝ ኪታ ቲናቲ ይንትስ እንጌዛ። የይካ፥ ጌሻ ማጻፋይ ግዛይ ጋርክ፥ ክርስቶሳ ኑ ናጋራ ግሾስ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ሞግንቴዛ፤ ጌሻ ማጻፋይ ግዛይ ጋርክ፥ ሃይꬒንꬃ ጋላስ Ꮊይቆፕ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ጵጽሮሳስ ቆንጬዛ። የይፕ ጉየ፥ ታጶ ናምኢ ሀዋርታይስ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","እችን ጼታፕ ጋንግዛ አማንዝታይስ ፐቲ ቶኬ በንቴዛ። ኡንታፕ ጋምታይ Ꮊኖ ሄሎዳይስ ፓጻ የዛ፥ ዝን ጽቅታይ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","የይፕ ጉየ፥ ያይቆባስ በንቴዛ፤ ጉየፐካ ፋ ሀዋርታይስ ኡባይስ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ማ ዉርስꬃ ቡልꬅ ጋርክ ማቄዝ ታስ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ታኒ የሱሳ ሀዋርታይ ኡባይፕ ላፋ። ታኒ ጾስ ዎሳ ኬꬅ ባይእꬄዝ ግሾስ የሱሳ ሀዋረ ግንትንቲ ጼግንቶዳይስ ቤዞዋዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ዝን ጾስ ኣꬎ ኬሃትꬃይድ Ꮊት ማቄዛይ ታና፤ ኤ ታስ እንጌዝ ኣꬎ ኬሃትꬃይ ጨር አተካያ። ታኒ Ꮊንኮ ሀዋርታይፕ ኣꬂ ዳቡሬዛ። ዝን ታራ የዝ ጾስ ኣꬎ ኬሃትꬃይ ኦꬄነፕ አትን ታና ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ይኬ፥ ታና ማቅን ኡንቲ፥ ኑ ኡባይ ታማርስዛይ የያ፤ ይንትካ የ ኪታ አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ክርስቶሳ Ꮊይቆፕ ደንዴዛና ኑ ሳባክዛ ዎደ ይንትፕ ፐታይ ፐታይ የዝን፥ ዋይዚ፥ «Ꮊይቆፕ ደንዶ ባያ» ዬግኔ? ");
INSERT INTO mfxe_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Ꮊይቆፕ ደንዶ ባባዝ ማቅኮ ክርስቶሳ Ꮊይቆፕ ደንደካ ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ክርስቶሳ Ꮊይቆፕ ደንደካባዝ ማቅኮ ኑ ትምርታይካ ይ አማናይካ ጨረ። ");
INSERT INTO mfxe_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Ꮊይቆፕ ደንዶ ባዝን፥ ኑኒ ጾሳይ፥ «ክርስቶሳና Ꮊይቆፕ ደንꬄዛ» ዬጊ ሳባክታር ዎርዶ ጾስ ማርክታ ማቄዝ ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","Ꮊይቄዝ አሳይ Ꮊይቆፕ ደንዶዋባዝ ማቅኮ ይኬ፥ ክርስቶሳ Ꮊይቆፕ ደንደካያ። ");
INSERT INTO mfxe_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ክርስቶሳ Ꮊይቆፕ ደንደካባዝ ማቅኮ፥ ይ አማናይ ጨረ፤ ማ ይ Ꮊኖ ሄሎዳይስ ይ ናጋራራ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ይኬ፥ ክርስቶሳ አማኒ Ꮊይቄዝታይካ ꬋቤዛ ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ኑኒ Ꮊ አላመ የስ ኣዳስ ክርስቶሳር ኡፋይሳ ኦꬄዝባዝ ማቅኮ፥ Ꮊ ሳአል የዝ አስ ኡባይፕ ኑባዝ ኣꬎ አዛንꬅዛባዝ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ዝን ክርስቶሳ Ꮊይቄዝታይስ Ꮊይቆፕ ደንዶር ባይራ ማቂ ቱማ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Ꮊይቆ ፐቲ አስ ባጋር Ꮊ አላመ የኤዛይ ጋርክ Ꮊይቆፕ ደንዶካ ፐቲ አስ ባጋር የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","አዳመ ባጋር አስ ኡባይ Ꮊይቄዛይ ጋርክ ክርስቶሳ ባጋር አስ ኡባይ ደኦ የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ዝን ፐታይ ፐታይ ፋ ሙራር ሙራር ደንዶዳ። ክርስቶሳ ኡባይፕ ባይራቲ ደንዴዛ፤ የይፕ ጉየ፥ ክርስቶሳስታይ ኤ ይእዛ ዎደ ደንዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","የይፕ ጉየ፥ ክርስቶሳ ሀርዝታ፥ ማዉተኔ ዎልቃ ኡባ ꬋብሲ፥ ካተትꬃ ጾስ አዳይስ እንግዛ ዎደ ዎደ ዉርስꬃይ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ጾሳይ ኤ ሞርክታ ኡባ ኤ ቶኬ ኦሞ ኦሎድ ሄሎዳይስ ክርስቶሳ ካዉቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ዉርስꬃል ኤ ꬋብሶዳይስ የዝ ሞርካይ Ꮊይቆ። ");
INSERT INTO mfxe_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ጌሻ ማጻፋይድ፥ «ጾሳይ ኡባ ባዝ ኤ ማዉተ ኦሞ ሃርሴዛ» ግንትንቲ ጻፍንቴዛ። ዝን ኡባ ኤ ማዉታይፕ ኦሞ ሃርሴዛ ግዛይ፥ ጾስ አዳይ ኣዳ አትኮ ኡባ ባዝ ኤ ማዉታይፕ ኦሞ ሃርሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ኡባ ባዝ ክርስቶሳ ማዉታይፕ ኦሞ ሃርንቴዛይፕ ጉየ ክርስቶሳ ማ ፋ ኦማስ ኡባ ባዝ ፓስ ሃርሴዝ ጾሳይስ ሃርንቶዳ። የ ዎደ ጾሳይ ፋ ኣዳ ኡባ ሃሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","Ꮊይቄዝታይ ደንዶዋባዝ ማቅኮ ኡ ግሾስ ጻማቅንትዛ አሳይ አብስ ዋይኔ? Ꮊይቄዝታይ ደንዶዋባዝ ማቅኮ የዝን፥ አብስ፥ አሳይ Ꮊይቄዝታይ ግሾስ ጻማቅንትኔ? ");
INSERT INTO mfxe_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","የዝን፥ ኑኒ አብስ ኡባ ዎደ ኑናትꬃ መቶስ ኣꬂ እንግኔ? ");
INSERT INTO mfxe_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ታ እሹንꬆ፥ ታ ጋላስ ጋላስ Ꮊይቆስ ኣꬊ እንግንትዛ። የይካ፥ ጎዳ የሱስ ክርስቶሳል የዝ ደኦ ፐትፐተꬃይድ ይንታል ጬቅዛ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","አስ ቆፋ ጋርክ ማቅኮ፥ ታኒ ኤፈሶነ ዶአራ ቡትቴዛይ ታና አብ ማዴ? Ꮊይቄዝታይ Ꮊይቆፕ ደንዶዋባዝ ማቅኮ፥ «ዎንቲ ኑ Ꮊይቅዝ ግሾስ Ꮊይኖ ማዳ ኡዦዳ» ዬግዝ አሳይ ጋርክ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ባልንትፓተ! ኢታ ዣመትꬂ ሎኦ ሀኖ ኢስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ይ ካሃይኮ ማቆይታ። ናጋራ ኦꬅፓተ። ይንታፕ ፐቲ ፐቲ አሳይ ጾስ ኤሮያ። ታኒ ይንታን ዬላꬆዳይስ የያ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ፐቲ አስ፥ «Ꮊይቄዝ አሳይ ዋይዚ ደንዴ? ኡንቲ አብ ጋርክ አሰትꬃራ የኦዴ?» ዬግꬅ አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ነኖ ቦዛዮ፥ ኔኒ ቢታል ዘርዝ ዘርꬃይ Ꮊይቀካ ዶሎያ። ");
INSERT INTO mfxe_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ኔኒ ዘርዛይ ግስተ ማቆ ዎይ ሀራ ካꬃ ዎቆዋ አፋ ኣዳ ዘርነፕ አትን ዶሌዝ ዶላ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ዝን ጾሳይ ዘረꬅታይስ ፋ ዶሴዛይ ጋርክ መትꬂ እንግዛ። ዱማ ዱማ ዘርꬅታይስ ዱማ ዱማ አሰትꬅ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","መትꬅ ኡባይ አሾ ፐቶ ባያ። ዝን አስ አሾ ፐቶ፤ መሄ አሾ ሀራ፤ ካፍታይ አሾ ሀራ፤ ማ ሞሎ አሾካ ሀራ። ");
INSERT INTO mfxe_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ሳሎ አሰትꬅ የዛ፤ ማ ሳአ አሰትꬅካ የዛ። ዝን ሳሎ አሰትꬅ ቦንቾ ፐቲ ማላ፤ ማ ሳአ አሳተꬅ ቦንቾ ሀራ። ");
INSERT INTO mfxe_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","አዋ ቦንቾ ሀራ፤ አጌና ቦንቾ ሀራ፤ ጾልንትታይ ቦንቾ ሀራ፤ ፐቲ ጾልንታይ ሀራ ጾልንቶፕ ቦንቾር ዱማትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","Ꮊይቄዝታይ Ꮊይቆፕ ደንድዛ ዎደ የይ ጋርክ ሀኖዳ። ዎቅዛ አሰትꬃይ ዘርንትዛ፤ ዎቆዋ አሰትꬅ ማቂ ደንድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ቶቼር ዘርንቲ፥ ቦንቾር ደንዶዳ፤ ዳቡርሳር ዘርንቲ፥ ዎልቃር ደንዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","መትꬅ አሰትꬃር ዘርንቲ፥ አያና አሰትꬅ ማቂ ደንዶዳ። መታ አሰትꬅ የዝኮ፥ አያና አሰትꬅ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","የይ ጋርከካ፥ ጌሻ ማጻፋይድ፥ «ቲና አꬃይ፥ አዳማ፥ ፓꬅ የዝ አስ ማቂ መꬍንቴዛ» ዬግዛ። ዝን ጉየ አዳማ፥ ክርስቶሳ፥ ደኦ እንግዛ አያና ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ዝን መታ አስ ቲና ይእን፥ ጉየፕ አያና አስ የኤነፕ አትን አያና አስ ቲና የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ቲና አዳም ቢታፕ መꬍንቴዝ ቢታ አስ፤ ናምእንꬆ አዳማ ሳሎፕ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ቢታፕ መꬍንቴዝታይ ቢታይፕ መꬍንቴዛና ኣዝዛ። ሳሎስታይ ሳሎፕ የኤዛና ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ኑኒ ቢታፕ መꬍንቴዝ አꬃ ኣዝዛይ ጋርክ ሳሎፕ የኤዝ አꬃካ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ታ እሹንꬆ፥ ታ ግዛይ የያ፤ አሾኔ ሱꬂ ጾስ ካተትꬅ ላቶዳይስ ዳንዳኦያ። ዎቅዛ አሰትꬃይ ዎቆዋ አሰትꬃ ላቶያ። ");
INSERT INTO mfxe_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ታ ይንትስ ፐቲ ጹረ ኦዶዳ። ኑ ኡባይ Ꮊይቃሚ፥ ዝን ዉርስꬃል ኡባይ ላምንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ቱልቱሎ ፑግንቶዳር ኣፈ ቅጲ በአዳይስ ቆፐካ ላምንቶዳ። Ꮊይቄዝ አሳይ ዎቃም አስ ማቂ ደንዶዳ፤ ኑካ ላምንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Ꮊይ ዎቅዛይ ዎቃማና፥ Ꮊይ Ꮊይቅዛይ Ꮊይቃማና ማኦዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","Ꮊይ ዎቅዛይ ዎቃማና፥ ማ Ꮊይ Ꮊይቅዛይ Ꮊይቃማና ማእዛ ዎደ ጌሻ ማጻፋይድ፥ «Ꮊይቆ ጋምꬃር ምትንቴዛ» ግዝ ቃላይ ፖልንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","የይ ጋርከካ፥ «Ꮊይቆ፥ ነ ጋምꬃይ አባ የኔ? Ꮊይቆ፥ ነ ዪሻይ አባ የኔ?» ");
INSERT INTO mfxe_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Ꮊይቆ ዱክዛ ዪሻይ ናጋራ፤ ማ ናጋራ ዎልቃይ ህገ። ");
INSERT INTO mfxe_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ዝን ኑ ጎዳ የሱስ ክርስቶሳ ባጋር ኑስ ጋምꬅ እንግዛ ጾሳና ጋላታ ሄሎ። ");
INSERT INTO mfxe_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","የይ ግሾስ፥ ታ ሲቆ እሹንꬆ፥ ኤንኤካ ሚንጊ ኤቆይታ። ጎዳይ ኦሳይድ ይ ዳቡርዛይ ጨረ ባዛና ኤሪ ኡባ ዎደ ጎዳይ ኦሳ አዛለካዛር ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","አማንዛ አሳይስ ሚሻ ሺሾ ባጋ ጋላትያ ዎሳ ኬꬅታይስ ታኒ አዛዜዛይ ጋርክ ይንትካ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ሚሸ ሺሾ ታ ይንትኮ Ꮊንጎዳር ማቃማይ ጋርክ ፐታይ ፐታይ ሳምንታፕ ቲና ጋላስ፥ ዎጋ ዎደ ዎጋ ዎደ ፋ ደንግዛ ባዛፕ ከሲ ፋ ካራ ጋንꬆ። ");
INSERT INTO mfxe_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ታኒ ገድ Ꮊንጌዝ ዎደ ሚሸ የሩሳላመ ሄልꬆዳይ ጋርክ ይ ዶሬዝ አሳይስ ዳብዳበ እንጊ ኡንታን የሩሳላመ አዛዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ኡንታር ታና Ꮊሞ ቤዝዛ ባዝ ማቅኮ ኡንቲ ታራ Ꮊንጎዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ታኒ ማቃዶናር ኣꬎዳይስ ቆፔዝ ግሾስ ገድ Ꮊንጊ ይንትኮ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ታ Ꮊንግዛ አቆ አና ማቅኮካ፥ ታ Ꮊማይድ ይ ታና ማዶዳይ ጋርክ ይ ካለ ጽቃ ዎደ ጋምኤካ አታሚ። ባርጎ አግንታ ይ ካለ ኣꬆ ዋዪ አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ታኒ ኦገራ ኣꬊታር ይንታን በአዳይስ ኮዮያ። ጎዳይ ጊኮ፥ ይ ካለ ኡንደና ዎደ ካታምኦዳይስ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ዝን ታኒ ጰንጸቆስጸ ባለ ሄሎዳይስ ኤፈሶና ጋምኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ታስ ኦሶ ኩሜዛ ዳልገ ፔንጋይ ዶይንቴዛ፥ ዝን ጋመ ኤቅንትዛ ሞርክታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ኤ ታ ጋርክ ጎዳ ኦሶ ኦꬅዛ አስ ማቄዝ ግሾስ ጽማቶሳ ይንትኮ Ꮊንግኮ፥ ይ ካለ ኤ ያሽተካዛር የዞዳይ ጋርክ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ኦንካ ኤዛ ካꬊፐ። ኤ ታኮ ሳሮ ማቆዳይ ጋርክ ኤዛ ማዲ ሞይዞይታ። ታኒ ኤ Ꮊንኮ አማንዝታይር ማቆዳና ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ኑ እሻ አጵሎሳ Ꮊንኮ አማንዝታይር ይንትኮ Ꮊማዳይ ጋርክ ታ ኤዛ ሚንꬂ ዎሴዛ። Ꮊት ይንትኮ Ꮊንጎዳይስ ኮየካያ፥ ዝን ኤስ ጊጌዝ ዎደ ይንትኮ Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ባርኮይታ፤ አማኖር ኤቆይታ፤ ጻሎይታ፤ ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ኦሶ ኡባ ሲቆር ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ታ እሹንꬆ፥ ኢስጽፋኖሰኔ ኤ ካራ አሳይ አካያ ቢታ ኡንቲ ቲና አማኔዝታ ማቄዛኔ አማንዝታ ማዶዳይስ ፋና ኣꬂ እንጌዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ይንትካ ኡ ጋርክ አስስኔ፥ ኡንታራ ኦሶር ዳቡርዛ ኡባይስ ኪተንቶዳይ ጋርክ ታ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","እስጸፋኖሳ፥ ፍርዶናጽሰኔ አካይቆሳ ታኮ የኤዛይ ታና ኡፋይሴዛ። ይ ባ አቆ ኡንቲ ይንታን ማቂ ታ ፓጫ ኩንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ኡንቲ ይንታን ኡፋይሴዛይ ጋርክ ታናካ ኡፋይሴዛ። የይ ጋርክ አስታ ደንꬅꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ኢሳ ዎሳ ኬꬅ አሳይ ይንታን ሳሮ ግዛ። አቅላኔ ጵርስቅላ ፋ ካራ ሺቅዛ ዎሳ ኬꬅ አሳይራ ፐትፕ ይንታን ጎዳይ ሱንꬃይር ሳሮꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","አማንዛ እሽታይ ኡባይ ይንታን ሳሮ ዬግዛ። ጌሽ ዬርንቶ ዬርንትታር ዎል ሳሮꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ታኒ፥ ጳዉሎሳ፥ Ꮊ ሳሮꬃ ታ ኩሸር ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ጎዳ ዶሶዋ አስ የዝኮ፥ ባድንቴዛ ማቆ። ኑ ጎዳዮ፥ Ꮊና የኦባ! ");
INSERT INTO mfxe_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ ይንታር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ታ ሲቃይ ክርስቶሳ የሱሳር የዝ ይ ኡባይራ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ጾስ ሸነር የሱስ ክርስቶሳ ሀዋረ ማቄዝ ጳዉሎሳኔ፥ ኑ እሻ ጽማቶሳ፥ ቆሮንቶሳ የዝ ጾስ ዎሳ ኬꬅስኔ አካያ ቢታ የዝ ጾስ አሳይር ፐትፕ ጾስ አስ ማቄዝታይስ ጻፌዝ ኪታ። ");
INSERT INTO mfxe_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ጾስ ኑ አዳይፐኔ ጎዳ የሱስ ክርስቶሳፕ፥ ኣꬎ ኬሃተꬅኔ ሳሮትꬅ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ማሮትꬅ አዳይስ፥ ኡባ ዎደ ኑና ሚንꬄꬅዛ ጾሳይስ፥ ኑ ጎዳ የሱስ ክርስቶሳ አዳይስ ጋላታ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ጾሳይ ኑስ እንጌዝ ምንꬃꬆር፥ መቶር የዝታ ኑ ምንꬃꬆዳይ ጋርክ ጾሳይ ኑና ኑ መቶ ኡባይድ ምንꬃꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ክርስቶሳ ጋመ ዋያይ ኑል ጋንጌዛይ ጋርክ ማ ክርስቶሳ ባጋር ኤ ምንꬃꬃይ ጋንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ኑኒ ዋይንትኮ የይ ይንታን ምንꬃꬆዳይስኔ ይንታን አሾዳይሲ። ማ ኑኒ ምንግኮ ኑኒ ዋያይድ ጋርዤዛይ ጋርክ ይንትካ ጋርዢ፥ ጾሳይ ይንትስ እንግዛ ምንꬃꬆር ምንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ይ ኑ ኤኬዝ መታይ ጋርክ ኤኪ፥ ኑ ምንꬃꬃ ሻክንቶዳና ኑ ኤርዛ ግሾስ ኑ ይንታል ጋዴዝ ኡፋይሳይ ምኖ። ");
INSERT INTO mfxe_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ኑ እሹንꬆ፥ ኢሳ ቢታ ኑና ሄሌዝ መታ ይ ኤሮዳይ ጋርክ ኑ ኮይዛ። የ ኑና ሄሌዝ መታይ ኑ ዎልቃይፕ አꬊን፥ ሸምፖር አቶድባዝካ ኑስ ኤርንተካዝን። ");
INSERT INTO mfxe_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ኑኒ ኑል አፋ Ꮊይቆ ፕርዳ ፕርድንቴዛይ ጋርክ ቆፔዛ። ዝን ኑኒ ኑ ኦማስ ባዝን፥ Ꮊይቄዝታ ደንꬅዛ ጾሳይል አማንንቶዳይ ጋርክ የይ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ጾሳይ የይ ጋርክ ኢታ Ꮊይቆፕ ኑና አሼዛ፤ Ꮊተካ አሽዛ፤ ቲናፐካ ኤ ኑና አሾዳ ግ ኤዛል ኡፋይስ ጋድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ዎሳር ኑና ማዶይታ። ጋመ አሳይ ዎሳፕ ደንዴዛይድ ጾስ እሞታ ኑ ደንግዛ ዎደ ጋመ አሳይ ኑ ግሾስ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ኑ ጬቃይ Ꮊያ። ኑኒ Ꮊ አላመል የዜዝ የሳይድ ኡባራካ ይንታር የዜዝ የሳይድ ጾሳፕ ማቄዝ ጽሎትꬃራኔ ሉለትꬃር ይንታር የዜዛና ኑ ካሃይ ማርካትዛ። የይካ፥ Ꮊ አላመ ኤጨትꬃር ባዝን ጾስ ኣꬎ ኬሃትꬃይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ኑ ይንትስ ጻፌዝ ዳብዳበ ይ ናባቦዳይስኔ አካኮዳይስ ዳንዳኦዋ ባዝ ኑ ይንትስ ጻፓሚ። ይ ኤዛ አካኮዳይስ ዳንዳእዛያ ታ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Ꮊት ይ ኑና ዉርሲ ኤሮያ፥ ዝን ቲናፕ ዉርሲ ኤሮዳያ ታ አማንንትዛ። ኑ ጎዳ የሱሳ ማቅዛ ዎደ ኑ ይንታል ጬቅንትዛይ ጋርክ ይንትካ ኑል ጬቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","የያ ታኒ ሎእꬅ ኤሬዝ ግሾስ ይ ናምእንꬆ ማድንቶዳይ ጋርክ ይንትኮ Ꮊንጎዳይስ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ታኒ ማቃዶና Ꮊንግታራኔ ኤዛይፕ ማቅታር ይንታን በአዳ። ታኒ ኤዛይፕ ይሁዳ Ꮊንጎዳር ይ ታና ታ ኦጋይድ ማዶዳ ግ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ታኒ የያ ጊታር አብ ኦꬆዳይስ ቤዝዛኮ ኤረካ አስ ኣዝኔ? ዎይ ታኒ ታ ቆፋ አጭዝ ዎደ አስ ቆፋ ጋርክ፥ ፐቲ ቶኬ «ኤ» ማ ፐቲ ቶኬ «ዋኣ» ግዝ አስ ጋርከኔ? ");
INSERT INTO mfxe_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ዝን ጾሳይ አማንንቴዛ ማቄዝ ግሾስ ኑ ይንትስ ኦድዛ ቃላይ «ኤ» ዎይ «ዋኣ» ግዛ ዋላካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ታራ፥ ስላሰራኔ ጽማቶሳር ይንትስ ማርካቴዝ ጾስ ናአይ፥ የሱስ ክርስቶሳ ኡባ ዎደ «ኤፕ» አትን «ኤ» ኔ «ዋኣ» ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ጾሳይ እንጎድ ጌዝ ኡባይ ክርስቶሳ ባጋር «ኤ» ማቅዛ። ኑኒ ክርስቶሳ ባጋር ጾስ ቦንቾስ፥ «አምንኤ» ግዛይ የይ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ኑራኔ ይንታራ ክርስቶሳር ሚንጊ ኤቆዳይ ጋርክ ኡዴዛይኔ ፋ ኦሳይስ ዶሬዛይ ጾሰ። ");
INSERT INTO mfxe_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ኑኒ ኤባዝ ማቄዛና ኤርሶዳይስ ፋ ማታማ ኑል አፋ ጋዴዛ፤ ማ ፋ ጌሻ አያና ሳꬅ ኡዲ ኑ ዎዛና ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ታኒ ቆሮንቶሳ Ꮊንገካ አቴዛይ ይ አዛናማይ ጋርከሲ፤ የይ ዎርዶ ማቅኮ ጾስ ታስ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ይ፥ ይ አማናይድ ሚንጊ የዝ ግሾስ ኑ ይንታን ኡፋይሶዳይስ ይንታር ዎላ ኦꬅዝታይፕ አትን ይንታን ይ አማናይል ዎልቃንꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ታኒ ማቂ ይንትኮ የአም ግ ቆፋ አጬዛይ ይንታን አዛንꬃማይስ። ");
INSERT INTO mfxe_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ታኒ ይንታን አዛንꬅኮካ ታ አዛንꬄዝ ይንትፕ ሀራ ታና ኡፋይሶዳይስ የዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ታኒ ይንትስ የ ዳብዳባ ጻፌዛይ፥ ታ ይንታን በአዳይስ Ꮊንጎዳር ታና ኡፋይሶዳይስ ቤዝዛ አሳይር ታ አዛኖዳይስ ኮዮዋ ግሾስ። ታ ኡፋይሳይ ይ ኡባይ ኡፋይስ ማቅዛና ታ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ታኒ ጋመ ዋየራኔ ኡንአር ማ ጋመ አፉꬃር ጻፌዛይ፥ ይንታን አዛንꬆዳይስ ባዝን ታኒ ይንታን ኡባ ዋፋ ጋርክ ዶስዛኮ ይንታን ኤርሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","አስ አዛንꬄዝ ኦንካ የዝኮ ታ ኤ ቡታ ሱቅꬅ ማቅፐፕ አትን ታና ባዝን ይንትፕ ጋምታ አዛንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ይንትፕ ጋመ አሳይ የ አꬃ ሴሬዝ ሴራይ ኤስ ግዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","የይ ግሾስ፥ የ አꬃይ ኢታ አዛኒ፥ ኡፋይስ ጋቻማይ ጋርክ ይ ኤዛ ማሮዳይስኔ ምንꬃꬆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ይ ኤዛ ሲቅዛና ማሂ ኤዛ ቤዞዳይ ጋርክ ታ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ታ የ ዳብዳባ ይንትስ ጻፌዛይ፥ ይ ፓጭንት፥ ኡባ ባዛር ታስ ኪትንትዛ ኤሮዳይስ ኮዬዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ይ ማርዛ አስ ታካ ማሮዳ። ታኒ ማሮድባዝ አቢ የዛኮካ፥ ክርስቶሳ ቲና ይ ግሾስ ግ ማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ታኒ የያ ኦꬄዛይ ጻላሄ ዶሻ ኦሳ ኑ ኤርዛ ግሾስ ጻላሄር ዶሽንታማይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ታኒ ክርስቶሳ ዎንግለ ሳባኮዳይስ ጽሮአዳ Ꮊንጌዝ ዎደ ጎዳይ ኤዛይድ ታስ ኦሶ ፐንገ ዶዪ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ዝን ታኒ ታ እሻ ትቶ ኤዛይድ ደንገካ ግሾስ ታ ዎዝናይ ሸምፐካያ። የይ ግሾስ፥ ኤዛይድ የዝ አሳ ሳሮꬅ ኤዛ ኮዮዳይስ ማቃዶና Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ዝን ክርስቶሳ ባጋር ኡባ ዎደ ኑና ጋምዝታ ኡዲ ካልꬅዛይኔ ሽቶ ጋርክ ቶንክ ግ ሳዉዛ ክርስቶሳ ባጋ ኑ ኤርዛ ኤራትꬃ ኡባ አቆ ሄልꬆዳይ ጋርክ ኡዴዛ ጾሳ ጋላታ ሄሎ። ");
INSERT INTO mfxe_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ኑኒ አቶድ አሳይስኔ ꬋቦድ አሳይ ጋንጨ ክርስቶሳ ባጋር ጾስስ እንግንቴዝ ሳዉዛ ሽቶ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ꬋቦድ አሳይስ Ꮊይቆክ ካንግዝ Ꮊይቆ ሳዎ፤ ማ አትዝ አሳይስ ደኦኮ ካንግዛ ደኦ ሳዎ፤ የዝን፥ የይ ጋርክ ኦሳይስ ማቃዳይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ኑኒ ጾስ ቃላ ዎ ደንጎዳይስ ኮዪ ዋላኪ ዛልእዝ ጋመ አሳይ ጋርክ ባያ። ዝን ጾሳይ ኪቴዝ ሉለ አስታይ ጋርክ ክርስቶሳር የዚ ጾስ ቲና ቃላ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ኑኒ ማሂ ኑና ሳቦ አይኮደኔ? ዎይ ሀራ አስ ጋርክ፥ ጋላታ ዳብዳበ ይንትስ ዳኮዳይስ ዎይ ይንታፕ ኤኮዳይስ ኑና ኮሽኔ? ");
INSERT INTO mfxe_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","አሲ ኡባይ ይንታን ኤሮድ ጋርከኔ ናባቦዳይ ጋርክ ይ ኑ ዎዝናይድ ጻፍንቲ የዝ ኑ ዳብዳበ። ");
INSERT INTO mfxe_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ይ ቃላመር ባዝን ጾስ አያናር፥ ሹቻል አፋ ባዝን አስ ዎዝና ጻፍንቴዝታኔ ኑ ኦሶር በንቴዝ ክርስቶሳ ዳብዳበ ማቄዛና ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ኑ የያ ጌዛይ፥ ክርስቶሳ ባጋር ጾሳል አማኖ ኑስ የዛ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ኑ የያ ኦꬆዳይስ ዳንዳኤዛይ ጾስ ዎልቃራፕ አትን ኑኒ ኑ ዎልቃር አኮካ ኡዶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ኑ ኦሮꬅ ጫቆ ኦሳንችታ ማቆዳይ ጋርክ ጾሳይ ኑና ኡዴዛ። የ ኦሮꬅ ጫቃይ ጌሻ አያናር በንቴዛይፕ አትን ጻፍንቴዝ ህገር ባያ። ህገ ዎꬍዛ፥ ዝን ጌሻ አያናይ ደኦ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ሹቻል አፋ ጻፍንቴዝ ህገ እንግንትዛ ዎደ ጾስ ቦንቾ በንቴዛ። ሙሰ ስናይል የዝ ቦንቻይ ꬋብታር Ꮊንግዛባዝ ማቅኮካ፥ እስሬለ አሳይ ኤ ስና ꬎቅ ግ በአዳይስ ዳንዳኤካያ። ይኬ፥ Ꮊይቆ ክእዝ ህገ የይ ጋርክ ቦንቾር በንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","የዝን፥ ጌሻ አያናር ኦስንቴዝ ኦሳይ ቦንቻይ ዋይዚ ኣꬊ በንቶዴ? ");
INSERT INTO mfxe_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","አሳል አፋ ፕርዳ ክእዝ ህገ ቦንቾ ማቅኮ የዝን፥ አስ ጽልስዛ ኦሮꬅ ኦጋይ ዋይዚ ኣꬊ ቦንችንቶሳ? ");
INSERT INTO mfxe_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ጉየ ቦንቻይ ኡባፕ ኣꬅ ማቄዛይፕ ደንዴዛይድ ቲና ቦንቻይ አኮካ ባዛይ ጋርክ ፓይድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ጽቃ ዎደስ በንቲ ጉየፐ ꬋቤዛይ የይ ጋርክ ቦንችንትኮ፥ መꬍናስ የዛይ ዋይዚ ኣꬎ ቦንችንቶሳ? ");
INSERT INTO mfxe_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ኑስ Ꮊይ ጋርክ ኡፋይሳይ የዛ ግሾስ ዬላተካ ኦድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ሙሰ ꬋብታር Ꮊንግዝ ኤ ስኖ ፖጭꬃይ ደስኬሞድ ሄሎዳይስ እስራኤልታይ በአማይ ጋርክ ፋ አፋ ጎዝዛ። ኑና ማቅኮ ኤ ጋርክ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ዝን ኡ ዎዝናይ ዶጬዛ። Ꮊይኖ ሄሎዳይስ ጭማ ጫቃ ናባቦዳር ኡ ዎዝናይ የ ካማይር ካምንት የዛ። የ ካማይ ክርስቶሳ ኣዳር ሀልእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ዝን Ꮊይኖ ሄሎዳይስካ ሙሰ ማጻፋ ናባቦዳር ኡባይድ የ ካማይ ኡ ዎዝናይል ካምንቲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ዝን ኦንካ ጎዳይኮ ማቄዝ ዎደ አይደካ የ ካማይ ሀልእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ጎዳይ አያና፤ ጎዳ አያናይ የዝ አቆ ዋሎትꬂ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ኑኒ ኡባይ ካምንተካ ስኖ ማስቶተር ብእዛይ ጋርክ ጎዳይ ቦንቻ በአዳ። ኑኒ አያና ማቄዝ ጎዳይ ማላ ኣዞዳይስ ቦንቾፕ ቦንቾኮ ላምንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ይኬ፥ ጾሳይ ፋ ማሮተꬃር Ꮊ ኦሳ ኑስ እንጌዝ ግሾስ ኑኒ ኡፋይስ ጋቻሚ። ");
INSERT INTO mfxe_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ኑኒ ዬላꬅዛ ጌማ ኦሶ ኡባ አሺ፤ ገነ ኦሶ ኦꬃሚ፤ ጾስ ቃላ ዎርዶር ዋላካሚ። ቱማ ቆንጨር ናሽታር፥ አስ ኡባይ ካሃይ ኑና ኤኮዳይ ጋርክ ጾስ ቲና ኑና ሺሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ኑ ኦድዛ ዎንግላይ ካምንቴዝ ባዝ ማቅኮካ፥ ካምንቴዛይ ꬋቦ ኦገል የዝ አሳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Ꮊ አላማ ሃርዛ ጾሳይ አማኖዋ አሳይ ዎዝና ጎዜዛ። ኡንቲ ጾስ ኣዚ በንቴዝ ክርስቶሳ ቦንቾ ዎንግለ ፖአ በኣማይ ጋርክ ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ኑኒ፥ የሱስ ክርስቶሳ ጎዳ ማቄዛኔ ኑ ኤ ግሾስ ይ አይልታ ማቄዛና ኦድነፕ አትን ኑባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","«ፖኦ ꬉማ ጋንጨ ፖኦ» ጌዝ ጾሳይ፥ ክርስቶሳ ቲና ፖእዛ ጾስ ቦንቾ ኤራትꬅ ፖአ እንጎዳይስ ፋ ፖአ ኑ ዎዝናይድ ፖኦዳይ ጋርክ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ዝን ኡባይፕ ኣꬊዝ ዎልቃይ ኑፕ ባዝን ጾሳፕ ማቄዛና ቤዝዛ Ꮊ ቦንቾ ሚሻይ ቢታፕ መꬍንቴዝታ ማቄዝ ኑ ጋንጨ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ኑ ኡባ ባጋር ኡርቅንትዛ ዝን ጋምንታሚ። ኑስ ሀድርስ ማቄዛ፥ ዝን ኡፋይስ ጋቻሚ። ");
INSERT INTO mfxe_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ኑ ባይእንትዛ፥ ዝን ዶግንታሚ። ኑ ፖክዛ፥ ዝን ꬋባሚ። ");
INSERT INTO mfxe_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","የሱሳ ደአይ ኑ አሳተꬃይድ በንቶዳይ ጋርክ ኤ Ꮊይቃ ኡባ ዎደ ኑ አሳተꬃይድ ቶኪ ዩይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","የሱሳ ደአይ Ꮊይቅዝ ኑ አሳተꬃይድ በንቶዳይ ጋርክ ፓꬅ የዝ ኑኒ ኤ ግሾስ ኡባ ዎደ Ꮊይቆስ ኣꬊ እንግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ይኬ፥ Ꮊይቆ ኑል ኦꬅዛ፥ ዝን ደኦ ይንታል ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ጌሻ ማጻፋይድ፥ «ታ አማኔዛ፤ የይ ግሾስ ኦዴዛ» ዬግንቴዛ። የይ ጋርከካ ፐቲ አማኖ አያና ኑስ የዛ ግሾስ ኑ አማንዛ፤ የይ ግሾስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ጎዳ የሱሳና Ꮊይቆፕ ደንꬄዝ ጾሳይ፥ ኑናካ የሱሳር ደንꬆዳኔ ይንታር ዎላ ሺሾዳና ታ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","የይ ኡባይ ሀኔዛይ ይ ግሾስ። ፑጬዝ ኣꬎ ኬሃትꬃይ ጋመ አሳ ሄሌዛይ ጋርክ አሳይ ጾስ ቦንቾስ ማቅዝ ጋላታ ጋንጎዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","የይ ግሾስ፥ ኑኒ ኡፋይስ ጋቻሚ። በንትዝ ኑ አሰትꬃይ ዳቡርታር Ꮊንግዛባዝ ማቅኮካ፥ ኑ አያና አሰትꬃይ ጋላስ ጋላስ ኦሮጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Ꮊተስ ኑኒ ዋይንትዛ Ꮊ ካዉሻ ዋያይ፥ ኡባፕ ሎእꬆ ኣꬊዝ መꬍና ቦንቻ ኑስ እንግሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ኑኒ በንትዝባዝ ባዝን በንቶዋባዛ ብእዛ። በንትዝባዛይ Ꮊተስ፥ ዝን በንቶዋባዛይ መꬍናሲ። ");
INSERT INTO mfxe_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Ꮊት ኑ የዝ ዱንካነ ኣዝዝ Ꮊ ሳአ አሰትꬃይ ላልንትኮካ፥ አስ ኬጸካ፥ ጾሲ ኬጼዝ መꬍና ካራይ ኑስ ሳሎ የዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ሳሎ አሰትꬃ ማኦዳይስ አሞትታር Ꮊት Ꮊ ሳአ የሳር ቡትትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ኑኒ የያ ማኤዝ ዎደ ካሎታም። ");
INSERT INTO mfxe_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ዱንካነ ኣዝዝ Ꮊ ሳአ አሰትꬃይድ ኑ የዛር ዴጽን ሸምትዛ። Ꮊይቅዝ ኑ አሰትꬃይ ደኦ ላምንቶዳይ ጋርክ ሳሎ አሰትꬃ ማኦዳይስ ኮይነፕ አትን ካሎቶዳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ኑና Ꮊይስ ጊግሴዛይ ጾሰ። ኤዝካ ሳꬅ ኡዲ ፋ አያና ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","የይ ግሾስ፥ ኑኒ Ꮊ ሳአ አሰትꬃር የዝ ዎደ ኡባይድ ጎዳይፕ ሃኪ የዛና ኤርኮካ ኡባ ዎደ አማንንቲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ኑኒ የዝዛይ ጎዳ አማኖራፕ አትን ኤዛ ብእꬃር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ኑ Ꮊ ሳአ አሰትꬃፕ ሻክንቲ፥ ኑ ካራ Ꮊንጊ ጎዳይር ፐትፕ የዞዳይስ አሞትዝ ግሾስ አማንንቲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","የይ ግሾስ፥ ኑ Ꮊ አሰትꬃይር የዝን ዎይ Ꮊ አሰትꬃፕ ሻክንትን፥ ኑ አማይ ኤዛ ኡፋይሶዳያ። ");
INSERT INTO mfxe_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ኑኒ ፐታይ ፐታይ Ꮊ ሳአ የሳር ሎኦ ማቅን ኢታ ማቅን፥ ኦꬄዝ ኦሳይስ ቤዝዛ ፕርዳ ኤኮዳይስ ክርስቶሳ ፕርዳ ዙፋናይ ቲና ሺቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ይኬ፥ ኑኒ ጎዳ ያሽትꬂ አብ ጉስዛኮ ኤርዛ ግሾስ አሳይ ኑ ኦድዛ ኤኮዳይ ጋርክ ዞሮዳ። ጾሳይ፥ ኑኒ ኦናዛኮ ኑና ኤርዛ፤ ማ ይንትካ ይ ካሃይድ ኑ ኦናዛኮ ኤርዛ ግ ኑ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ዎዛና ጋንጨ የዝ ባዛር ባዝን ማላር ጬቅንትዛ አሳ ዶና አይꬆዳይስ ይ ኑር ጬቅንቶዳይ ጋርክ ይንትስ ኦገ ማቆዳይስ ኮይነፕ አትን ኑ ኑና ማሂ ናሾዳይስ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ኑ ኤይታ ማቅኮ ጾስ ቦንቾስ፤ ካሃምታ ማቅኮ ይ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ፐታይ ኡባይስ Ꮊይቄዛኔ ኡባይ ማ ኤ Ꮊይቃ ሻክንቴዛና ኑ ኤርዛ ግሾስ ክርስቶሳ ሲቃይ ኑና ሃርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ደኦር የዝታይ ይከፕ ጉየ ፓስ ባዝን ኡንትስ Ꮊይቄዛይስኔ Ꮊይቆፕ ደንዴዛይስ የዞዳይ ጋርክ ክርስቶሳ አስ ኡባይ ግሾስ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ይከፕ ጉየ፥ ኑኒ ኦናካ አሾ ኣፈር በኣሚ። Ꮊይፕ ቲና ኑኒ ክርስቶሳናካ አሾ ኣፈር በኤዝ ባዝ ማቅኮካ፥ ይከፕ Ꮊይ ጋርክ በኣሚ። ");
INSERT INTO mfxe_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","የይ ግሾስ፥ ኦንካ ክርስቶሳር የዝኮ ኦሮꬅ መትꬂ፤ ጭማ መትꬃይ ኣꬌዛ፤ ኡባይካ ኦሮꬅ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","የያ ኡባ ጾሳይ ኦꬄዛ። ኤ ክርስቶሳ ባጋር ኑና ፓር ዳቦꬄዛ። ማ Ꮊንክታ ፓር ዳቦꬆዳይ ጋርክ ኑስ ዳቦꬆ ኦሶ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ጾሳይ ክርስቶሳ ባጋር አስ ኡባ ፓር ዳቦꬅዛ። ኡ ናጋራ ፓይዶያ፤ ማ አሳ ፓር እግንꬅዛ ቃላ ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ጾሳይ አሳ ኑ ባጋር ጼግዝ ግሾስ ኑ ክርስቶሳስ ኪትንትዝታይ አሳ ጾሳር እግንቶ ግ ክርስቶሳ ግሾስ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ኑኒ ጾስ ጽሎትꬅ ክርስቶሳ ባጋር ኤኮዳይ ጋርክ፥ ናጋራ ኤሮዋ ክርስቶሳ ኑ ግሾስ ናጋራንቾ አስ ጋርክ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ኑኒ ጾሳር ዎላ ኦꬅዛ አስ ማቄዛይ ጋርክ፥ ይ ኤኬዝ ኣꬎ ኬሃትꬃ ጨረ ማሃማይ ጋርክ ኑ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ጾሳይ፥ «ታ ነና ስኦድ ዎደ ስኤዛ፤ አቶትꬅ ጋላስ ነና ማዴዛ» ዬግዛ። ዬዛኮ፥ ታ ስኦድ ዎዳይ Ꮊተ፤ አቶትꬅ ጋላሳይካ Ꮊይኖ። ");
INSERT INTO mfxe_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ኦንካ ኑ ኦሳ ቦራማይ ጋርከኔ ኑር ꬉብንቶዳይ ጋርክ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ሀኖ ዝን፥ ኑ ቱማ ጾስ ኦሳንችታ ማቄዛና ኑ ኦꬅዛ ኡባ ባዛር ቤዜዛ። ጋመ ጋርዦር፥ ዋዬር፥ መቶር፥ ኡንኣር፥ ");
INSERT INTO mfxe_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ጋራፍንትꬃር፥ አቻር፥ ጫቦትꬃር፥ ኦꬆር ዳቡራር፥ ገንታ ꬋቦር፥ ጾማር፥ ");
INSERT INTO mfxe_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ጌሸትꬃር፥ ኤራትꬃር፥ ዳንዳአር፥ ኬሃትꬃር፥ ጌሻ አያናር፥ ቱማ ሲቆር፥ ");
INSERT INTO mfxe_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ቱማ ኦዳራኔ ጾስ ዎልቃር ኑኒ ኤ ኦሳንችታ ማቄዛና ቤዜዛ። ማ ጽሎትꬃይ ኑስ ቶራኔ ጎንዳለ። ");
INSERT INTO mfxe_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ኑኒ ቦንችንቶዳይስ ቶሽንቶዳይስ፤ ጫዥንቶዳይስኔ ጋላትንቶዳይሲ ጊግንቴዛ። ቱማ ናሼዝታ፥ ዝን አሳይ ኑና ዎርዶትዝታ ጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ኑ ኤርንቶዋ አስ ኣዝታር ኤርንቴዝታ ማቄዛ። Ꮊይቄዝታ ዬግንቴዝታ፥ ዝን ፓጻ የዛ፤ ሾጭንቴዛ፥ ዝን Ꮊይቀካያ። ");
INSERT INTO mfxe_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ኑኒ አዛንኮካ ኡባ ዎደ ኡፋይትዛ። ኑኒ ማንቆ ኣዝዛ፥ ዝን ጋመ አሳ ዱርሴዛ። ማ አኮካ ባ አስ ኣዜዛ፥ ዝን ኡባይ ኑባዝ። ");
INSERT INTO mfxe_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ይንትኖ ቆሮንቶሳ አሳዮ፥ ኑ ይንትስ ጌሺ ኦዴዛ፤ ኑ ኡላ ይንታን ዉርሲ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ይ ኑና ይ ሲቆ ቤዞዋ ካየነፕ አትን ኑ ኑ ሲቆ ይንታን ካየካያ። ");
INSERT INTO mfxe_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","አደ ፋ ናእታይስ ኦድዛይ ጋርክ ታ ይንትስ ኦድዛ፤ ኑ ይንታን ኑ ኡላ ቤዜዛይ ጋርክ፥ ይንትካ ይ ኡላ ኑና ቤዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","አማኖዋ አሳይር ቤዞዋ ኦገር ዋጽንትፓተ። ጽሎትꬅኔ ናጋራ አብ ዎል ሄልꬄ? ፖኦስኔ ꬉማስ አባ ፐትፐተꬂ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ክርስቶሳኔ ጻላሄ ዎል ሄልꬅዛ ባዝ አባ? ማ አማንዛይኔ አማኖዋዛይ ፐትፕ ኮጽዛባዝ አባ? ");
INSERT INTO mfxe_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ጾስ ኬꬃይስ ኤቅታይር አባ ፐትፐተꬂ የኔ? ጾሳይ፥ «ታኒ ኡ ጋንጨ የሳዳ፥ ኡ ጋንጨር የꬎዳ። ታኒ ኡ ጾስ ማቆዳ፤ ኡንትካ ታ ዎያ ማቃዳ» ጌዛይ ጋርክ፥ ኑኒ ደኦ ጾስ ኬꬄ። ");
INSERT INTO mfxe_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","የይ ጋርከካ፥ ጎዳይ፥ «ኡንቲ ጋንጨፕ ሻክንቲ ከዞይታ፤ ቱና ማቄዝ ባዝ ቦችፓተ፤ ታ ይንታን ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ታ ይንትስ አደ ማቃዳ፤ ይ ታስ ዲርꬅ ናእታኔ ማች ናእታ ማቃዳ፤ ዬግዛ ኡባፕ ዎልቃማ ጎዳይ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ይኬ፥ ታ ዳብታዮ፥ Ꮊ ኡፋይሳይ ኑስ የዝ ግሾስ ኑ አሻኔ ኑ ሸምፖ ቱንስዛ ባዝ ኡባይፕ ኑና ናጎዳ። ጾሳይስ ያሽቲ ኑ ጌሻትꬃ ዎላ ፎሎ ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ይ ዎዝናፕ ኑና ኤኮይታ። ኑኒ ኦናካ ናቀካያ፤ ኦናካ ቆሄካያ፤ ኦናካ ዶሸካያ። ");
INSERT INTO mfxe_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ታኒ የያ ይንታል አፋ ፕርዶዳይስ ጎያ። Ꮊይፕ ቲና ታ ይንትስ ኦዴዛይ ጋርክ፥ ይ ኑ ዎዝናይድ የዛ፤ ኑ ፓጻ የዝንካ Ꮊይቅንካ ይንትፕ ሻክንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ይንታል አፋ የዝ ታ አማናይ ዳማ፤ ታ ይንታል አፋ ጬቅንትዛይ ዳማ፤ ኑ ዋየ ኡባይድ ኑ ኡፋይትዛ፤ ማ ምንꬃꬅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ኑኒ ማቃዶና Ꮊንጌዝ ዎደ ጋመ ኦገር ዋይንቴዛፕ አትን አባ ሸምፎካ ደንገካያ። ባለራ ሞርከር፥ ጋንጨራ ያሻር ኡንእንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ዝን አዛኔዝታ ምንꬃꬅዛ ጾሳይ፥ ትቶ ይእꬃይር ኑና ምንꬃꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ኑና ምንꬃꬄዛይ ትቶ ይእꬃይድ ኣዳ ባዝን ይንትካ ኤዛ ምንꬃꬄዛ። ይ ታና ላሞቴዛያ፥ ታስ አዛንዛኔ ታስ ቆፕዛና ታ ስኤዝ ዎደ ታና ኡሳ ኡፋይሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ታ ጻፔዝ ኪታይ ይንታን አዛንꬅኮካ አብስ ጻፌነሻ ግ ቂራꬋሚ። ታ ቂራꬌዛይ ታ ጻፌዝ ኪታይ ይንታን ጽቃ ዎደስ አዛንꬄዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Ꮊት ታኒ ኡፋይቴዛይ፥ ታ ይንታን አዛንꬄዝ ግሾስ ባዝን ይ አዛናይ ይንታን ይ ናጋራይፕ ማሄዝ ግሾስ። ጾሳይ ፋ ሸነ ጋርክ ይንታን አዛንꬄነፕ አትን ኑ ይንታን አባራካ ቆሄካያ። ");
INSERT INTO mfxe_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ጾስ ሸነ ማቄዝ አዛናይ፥ አቶትꬅኮ ሄልꬅዛ ናጋራፕ ማቅꬅኮ ክእዛ፤ የይካ ቂርሶያ። ዝን Ꮊ ሳአ አዛናይ Ꮊይቆ ክእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Ꮊይ ጾስ ሸነ ጋርክ ማቄዝ አዛናይ አብ ጋርክ ደንꬅꬆ፥ አብ ጋርክ ማህꬅ፥ አብ ጋርክ ካቺ፥ አብ ጋርክ ያሻ፥ አብ ጋርክ ላሞꬅ፥ አብ ጋርክ ቅናተ፥ አብ ጋርክ ኩሸ ከሶ ይ ጋንጨ ከኤዛኮ ሎእꬂ ቦኦይታ። Ꮊ ኡባ ባዛር ይ ጌሽ ማቄዛና ማርካሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","የይ ግሾስ፥ ታኒ Ꮊ ዳብዳባ ይንትስ ጻፌዛይ፥ ቆሄዝ አꬃ ዎይ ቆህንቴዝ አꬃይ ግሾስ ባያ። ዝን ይ ኑስ አብ ጋርክ ቆፔዛኮ ጾስ ቲና ይ፥ ይንታን በአዳይ ጋርክ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ኑኒ ኡፋይቴዛይ የይ ግሾሲ። ኑ ኡፋይሳይፕ ኣꬊ ኑና ሎእꬅ ኡፋይሴዛይ፥ ይ ትቶ ኡፋይሴዛይዳኔ ኤ ዎዝና ሸምፕሴዛይዳ። ");
INSERT INTO mfxe_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ታኒ ይንታን ናሽቺ ኤስ ኦድን ይ ታና ዬላሰካያ። ዝን ኑኒ ኡባ ዎደ ይንትስ ቱሮ ኦዴዛ፤ Ꮊይ ጋርክ ኑኒ ትቶ ቲና ይንታን ናሼዛይ ቱማ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ይ ኤስ ያሻር ኩኩሪ፥ ኤዛ ሞኬዛኔ ማ ኤስ አብ ጋርክ ኪትንቴዛኮ ኤ ቆፒ ኤ ይንትስ የዝ ሲቃይ ምንግታር ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ታኒ ኡባ ባዛር ይንታን አማንንትዛ ግሾስ ኡፋይትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ኑ እሹንꬆ፥ ጾሳይ ማቃዶና የዝ ዎሳ ኬꬅታይስ እንጌዝ ኣꬎ ኬሃትꬃ ይ ኤሮዳይ ጋርክ ኑ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ኡንቲ ኢታ መቶር ፓጭንቴዛ፥ ዝን ኡ ኡፋይሳይ ዎልቃማ። ኡ ማንቆትꬃይስ ዛዋ ባያ፥ ዝን ኡ ፋ እሞ ዱረትꬃ ጋንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ኡንቲ ፋ ዎልቃይ ጋርከኔ ፋ ዎልቃይፕ ኣꬅ ቃꬊ እንጌዛይስ ታ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ኡንቲ ጾስ አሳይ ማድዛ ሎኦ ኦሶ ኑራ ኦꬆዳይስ ኮዪ ኑና ሚንꬂ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ኡንቲ ኑ ቆፔዛይፕ ኣꬂ ኦꬄዛ። ቲናቲ ጾስ ሸነ ጋርክ ኡ ፋና ጎዳይስ እንጌዛ፤ ማ የይፕ፥ ፋና ኑስካ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Ꮊ ሎኦ ኦሳ ቲናቲ አይኬዛይ ትቶ ማቄዝ ግሾስ Ꮊተካ የ ኦꬆዳይድ ይንታን ማዲ፥ የ ኦሳ ፖልሶዳይ ጋርክ ኤዛ ኑ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ዝን ይ ኡባ ባዛር፥ አማኖር፥ ኦዳር፥ ኤረትꬃር፥ አዛላ ባይꬅ፥ ኑና ሲቆራኔ ኡባ ባዛር ይ ኣꬍዛይ ጋርክ Ꮊ ሎኦ ኦሳይዳካ ይ ኬሃ ማቆዳይ ጋርክ ኑ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ታኒ የያ ይንታን አዛዞዳይስ ጎያ። ዝን Ꮊንክታይ አዛላ ባይꬅ እንግዛና ይ ሲቃይር ሄልꬂ ብኢ ይ አብ ጋርክ ቱማዛኮ ኤሮዳይስ ታ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ይ ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሄትꬃ ኤርዛ። ክርስቶሳ ዱረዛር፥ ይ ኤ ማንቆትꬃይር ዱርቶዳይ ጋርክ ይ ግሾስ ማንቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ታኒ Ꮊ ኦዳይድ ይንታን ማድዛ ዞረ ዞሮዳይስ ኮይዛ። ይ ዝቅነበረ እንጎዳይስ ኣዳ ባዝን የያ ኦꬆዳይስ ይ ቲና አሞቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ይ ኦꬆዳይስ አይኬዝ ኦሳ Ꮊት ፖሎይታ። ይ ይንትስ የዛይ ጋርክ እንግኮ፥ የይ ይ እንጎዳይስ ጋመ አሞትዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","ፐቲ አስ እንጎዳይስ አሞትኮ፥ ኤ እማይ ጾስ ቲና ኤክንትዛይ፥ ኤ ፓስ የዛይ ጋርክ እንግኮፕ አትን ባዛይፕ እንጎዳይስ ኡንእንትን ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ታኒ የያ ግዛይ፥ ይ ኡባይ ፐቲ ቃራ ማቆዳይ ጋርከፕ አትን Ꮊንክታይ ጋመ ዋያይፕ ሸምፕን ይ ዋይንቶዳ ጋርከስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ይ መትንቴዝ ዎደ ኡ ፑጫይ ይ ፓጫ ኩንꬆዳይ ጋርክ Ꮊት ይ ፑጫይ ኡ ፓጫ ኩንꬆ። ኤዛይድ ይ ፐቲ ቃራ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ጌሻ ማጻፋይድ፥ «ጋመ ሺሼዛይስ ፑጨካያ፤ ጽቃ ሺሼዛይስካ ፓጨካያ» ግንትንቲ ጻፍንቴዛይ ጋርክ። ");
INSERT INTO mfxe_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ኑ ይንትስ ቆፕዛይ ጋርክ ትቶካ ይንትስ ቆፖድ ጋርክ ኦꬄዝ ጾሳይ ጋላትንቶ። ");
INSERT INTO mfxe_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ትቶ ይንትኮ Ꮊንጌዛይ፥ ኑ ኤዛ ደንꬅꬄዝ ግሾስ ባዝን ኤ ፋ ሸነር Ꮊንጎዳይስ አሞቴዝ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ዎንግለ ማርካትꬃር ዎሳ ኬꬅ ኡባይድ ሎእꬂ ኤርንቴዝ እሻ፥ ኑኒ ትቶራ ፐትፕ ኪቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","የይል አፋ ኑኒ Ꮊ ኬሃ እማ ካንጎዳር ኤ ኑራ Ꮊማዳይ ጋርክ Ꮊ ሎኦ ኦሳይድ ጎዳ ቦንቾዳይስኔ Ꮊንክታ ማዶዳይስ የዝ አማ ቤዞዳይስ ዎሳ ኬꬃ ኤ ዶርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","Ꮊ እንግንቴዝ ኬሃ እማ፥ ኑ ኦሶል አፋ ፔሽታር ቦርንታማይ ጋርክ ናግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ኑኒ ጎዳይ ቲና ኣዳ ባዝን አስ ቲናካ ሎኦ ማቄዝ ባዝ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ማ ጋመ ዎደ ፓጭንቲ ምኖ ማቂ በንቴዝ ኑ እሻ፥ ኡንታራ ይንትኮ ኪቴዛ። ኤ ይንታል ሎእꬅ አማንንትዛ ግሾስ Ꮊት ይንታን ማዶዳይስ ጋመ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ትቶ ባጋ ኤሮዳይስ ኮይኮ፥ ኤ ይንታን ማዶዳይስ ታራ ኦꬅዝ ታ ኦሶ ዣመ። Ꮊንኮ እሽታይ ባጋ ማቅኮ ዎሳ ኬꬅታይ ኪቴዝታ፤ ማ አሳይ ኡ የሳ ብኢ ክርስቶሳና ቦንችዛ። ");
INSERT INTO mfxe_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","የይ ግሾስ፥ ዎሳ ኬꬅታይ ይ ሲቃኔ ኑ ይንታን ናሽዛይ ቱማ ማቄዛና ቆንጭሶዳይስ ይ ሲቆ Ꮊ አስታ ቤዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","አማንዛ አሳይስ ከስዛ ሚሽያባጋ ታ ይንትስ ጻፎዳይስ ኮሾያ። ");
INSERT INTO mfxe_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","ይ ማዶዳይስ ሎእꬅ አሞትዛና ታ ኤርዛ። ይ አካያ አሳይ፥ ዝቅነበረፕ አይኪ ማዶዳይስ ጊግንቴዛና ታኒ ማቃዶና አሳይስ ዶና ኩንꬅ ኦዴዛ። ይ ግታ አማይካ ኡንታፕ ጋምታ ደንꬅꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","Ꮊ ኦሳይድ ይንታል ኑ ጬቅንትዛ ጬቃይ ጨረ ማቃማይ ጋርክ ቲና ይ ባጋ ታ ኦዴዛይ ጋርክ ይ ጊግንቲ ናጎዳይ ጋርክ Ꮊ እሽታ ይንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ማቃዶና አሳይ ታራ ይኢ፥ ይ ጊግንተካዝን፥ ደንግኮ፥ ኑ ይንታል ዬላቶዳ፤ ማ ይ ኑፐ ኣꬎ ዬላቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","የይ ግሾስ፥ Ꮊ እሽታይ ታፕ ቲናቲ ይንትኮ Ꮊንጊ፥ ይ እንጎድ ጌዝ እሞ ቲናቲ ጊግሶድ ጋርክ ታ ኡንታን ኪቴዛ። ታኒ ሄሎዳር ያ እማይ ጊጊ በትዛ። የ ዎደ የ ኬሃትꬃር እማይ ዎልቃር ባዝን ዶሶር ማቄዛና ኤርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","ጽቃ ዘሬዛይ ጽቃ ሺሾዳ፤ ጋመ ዘሬዛይ ጋመ ቡጮዳ ዬግዛያ አካኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ጾስ ኡፋይሳር እንግዛ አꬃ ዶስዛ ግሾስ ዎልቃር ዎይ ሞርኤር ባዝን ፐቲ ፐቲ አስ ፋ ዎዛናይር ቆፔዛይ ጋርክ ዶሶር እንጎዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ኡባ ዎደ ኡባ ባዛር ይንታን ዳንዳእ ሎኦ ኦሶ ኡባይስ ፔሾዳይስ ይንትስ ግዶዳይ ጋርክ ጾሳይ ይንትስ ፋ አንጆ ጋንꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ጌሻ ማጻፋይድ፥ «ኤ ፋ ሻላ ማንቅታይስ ላሌዛ፤ ኤ ጽሎትꬃይ መꬍናስ የዝዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ዘርዛይስ ዘረꬅ፥ ማዳይስ ካꬃ እንግዛ ጎዳይ፥ ይ ዘርዝ ዘርꬃ ጋንꬂ እንጎዳ። ይ ጽሎትꬅ ኣፋካ ጋንꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ጋመ አሳይ ይ እንግዛ እማ ኑፕ ኤኪ፥ ጾስ ጋላቶዳይ ጋርክ፥ ይ ኡባ ዎደ ጋንꬂ እንግዝታ ማቆዳይ ጋርክ ጾሳይ ይንታን ኡባ ባጋር ዱርሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Ꮊ ይ እንግዛ እማይ አማንዛ አሳይ ፓጨ ኩንꬆ ኣዳ ባዝን አሳይ ጾሳ ጋላትዛ ኦገ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","Ꮊ ይ ኦሳይ ይ አማና ኤርሲ ክርስቶሳ ዎንግለ ይ አማኔዛኔ ኤስ ኪትንቲ ይንትስ የዛ ባዝ ኡንታራኔ Ꮊንክታይር ሻክንቴዝ ግሾስ ኡባይ ጾሳ ቦንቾዳ። ");
INSERT INTO mfxe_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ጾሳይ ይንትስ እንጌዝ ኣꬎ ኬሃትꬃይ ግሾስ ኡ ይንትስ ጾሳ ዎስታር ይንታን በአዳይስ ላሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ዛዋ ባ ጾስ እማይስ ጾሳይ ጋላትንቶ። ");
INSERT INTO mfxe_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ታ ይንታር የዛ ዎደ ሃዮ፥ ማ ይንትፕ ሃክን ኑል አፋ ሚንግዛ ዬግንቴዝ፥ ጳዉሎሳ፥ ኬሃኔ አሽከ ማቄዝ ክርስቶሳ ሱንꬃር ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ታኒ ይንትኮ Ꮊንጎዳር ኑና አሾ ቆፋር ዩይዛ አስ ኡዲ ቆፕዛ አሳይል አፋ ምኖ ቃላር ኦድንቶዳይስ ቆፔዛ። ይንታል አፋ የይ ጋርክ ኦድንቶዳይ ጋርክ ይ ታና ኦꬃማይ ጋርክ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","ኑኒ Ꮊ ሳአል የዝኮካ Ꮊ ሳአ አስ ጋርክ ኦልንታም። ");
INSERT INTO mfxe_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ኑ ኦላ ሚሻይ Ꮊ ሳአሳ ባያ። ዝን ምሽገ ላሎዳይስ ዎልቃር የዝ ጾስ ቶራ። ");
INSERT INTO mfxe_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ጾስ ኤራትꬃል አፋ ꬉበ ማቂ ደንድዝ ፓላማኔ ኡትራ ቆፋ ኡባ ላሎዳ። አስ ቆፋ ኡባ ድኢ ክርስቶሳስ አዛዝንቶዳይ ጋርክ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ይ ኪትንታይ ፎሎ ማቄዝ ዎደ ኑኒ ኪትንቶ እጾ ኡባ ሴሮዳይስ ጊግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ይ ብእዛይ አሾ ኣፋይር በንትዛያ። ኦንካ ፋና ክርስቶሳ ባጋ ግ አማንንቲ ቆፕዛባዝ ማቅኮ፥ ኑካ ክርስቶሳ ባጋ ማቄዛና ኤሮ። ");
INSERT INTO mfxe_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ጎዳይ ታስ እንጌዝ ማዉተር ጬቅንትኮካ የይድ ዬላታሚ። የ ማዉታይ ታስ እንግንቴዛይ ይንታን ድቾዳይሳፕ አትን ቆሆዳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ታኒ ታ ጻፌዝ ኪትታይድ ይንታን ያሽሾዳይስ ኮዪ ጻፌዝ ባዝ ይንትስ ኣዝፐ። ");
INSERT INTO mfxe_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","ፐቲ ፐቲ አሳይ፥ «ጳዉሎሳ ጻፌዝ ኪታይ ዴጾኔ ዎልቃማ፥ ዝን ኤዛ በአዳር ኤ ዳቡራንቻ፤ ኤ ኦዳይካ ፓꬆዋ ባዝ» ዬግዝ ኣዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","የ አስታይ ኑ ሃኮ የዛር ጻፍዛ ዳብዳባይራኔ ኡከ ይንታር የዛር ኦꬅዛ ኦሳይ ጋንጨ ዱማትꬂ ባዛና አካኮ። ");
INSERT INTO mfxe_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ኑኒ ፋና ሳብዛ አስታይር ኑና ፓይዶዳይስ ዎይ ቃራሶዳይስ ኮዮያ። ዝን ኡንቲ ፋና ፓር ሄልꬂ ዎይ ቃራስ ብእታር የዛይር ኡንትስ አካኬዛ ኣዝፐ። ");
INSERT INTO mfxe_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ዝን ኑኒ ጾሳይ ኑስ እንጌዝ ꬋሳይድ ጬቅንትነፕ አትን ዛዋ ኣꬊ ጬቅንቶያ፤ የ ዛዋይ ይንትኮካ ሄልዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ኑኒ ቤዝዛይፕ ኣꬂ ጬቅንቶያ፥ ዝን ክርስቶሳ ዎንግለ ይንትኮ ሄልꬄዛይድ ጬቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ኑኒ ጾሳይ ኤሴዝ ዛዋ ፒንጊ፥ Ꮊንክታይ ኦꬄዝ ኦሶር ጬቅንታሚ። ሀኖ ዝን፥ ይ አማናይ ድጮዳይ ጋርክ ጾሳይ እንጌዝ ዛዋይድ ይ ጋንጨ ኑ ኦꬅዛ ኦሳይ ዳልጎዳ ግ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ኑኒ ሀራ አስ ፋ ዛዋይል ኦꬄዝ ኦሶል ገሊ ጬቅንተካር ይንትፕ ፒንጊ ሀራስ ዎንግለ ማርካቶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ዝን፥ ጌሻ ማጻፋይድ፥ «ጬቅዛ ኡባይ ጎዳይል ጬቆ» ዬጊ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ጎዳይ ናሽዛ አꬃይፕ አትን ፋና ፓስ ናሽዛ አꬃይ ናሽንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ታ ጽቃ ቦዘትꬃ ይ ጋርዦዳና ታ አሞትዛ፤ ሀያና ዳንዳኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ጾሳይ ይንትስ ቆፔዛይ ጋርክ፥ ታካ ይንትስ ቆፕዛ። ታኒ ይንታን ፋና ናጌዝ ዉድርቶ ፐቲ ፓንꬃይ ማእስዛይ ጋርክ፥ ክርስቶሳስ እንጎዳይስ ኦይጪ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ዝን ሾሺ ፋ ገናይር ህዋኖ ባልꬄዛይ ጋርክ ኦ ኤሬ ይ ዎዝናይ ኢቲ ክርስቶሳስ የዝ ይ ሉለትꬃኔ ጌሸትꬃ ይ አሾደሻ ግ ታ ህርግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ፐቲ አስ ይኢ፥ ኑኒ ይንትስ ማርካቴዝ የሱሳፕ ሀራ የሱሳ ይንትስ ማርካትኮ፥ ዎይ ይ ኤኬዝ አያናይፐኔ ዎንግላይፕ ሀራ አያናኔ ዎንግለ ይንትስ ኦድኮ፥ ይ ስእ ግ ኤክዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ዝን ታኒ ኡንቲ ፋና «ኑ ዳማ ሀዋርታ» ግዝታይፕ ታ ታና ጽቅዛ ግ ቆፓሚ። ");
INSERT INTO mfxe_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ታኒ ኦዳ ኤሮዋ አስ ማቅኮካ፥ ኤራትꬂ ታስ የዛ። የያ ታ ይንትስ ጋመ ኦገር ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ታኒ ሚሸ ኦይጨካ ጾስ ዎንግለ ይንትስ ጨረ ኦዴዛኔ ይንታን ꬎቅ ኡዲ ታና ቶቼዛይ ታስ ናጋራ ጋርክ ፓይድንቶደሻ? ");
INSERT INTO mfxe_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ታኒ ይንታን ማዶዳይስ ሀራ ዎሳ ኬꬅታይፕ ሚሸ ቦንቂ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ታ ይንታር የዝ ዎደ ታና መትንካ ይንትፕ ፐቲ አስካ ዋይꬄካያ። ማቃዶናፕ የኤዝ እሽታይ ታና ኮሽዛ ባዝ ኡባይድ ማዴዛ። Ꮊይኖ ሄሎዳይስ ታ ይንትስ ቶፎ ማቀካያ ቲናስካ ቶፎ ማቃሚ። ");
INSERT INTO mfxe_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ክርስቶሳ ቱማትꬃይ ታል የዝን፥ ታ ጬቃ አካያ ቢታ ታና ኦንካ ካየና። ");
INSERT INTO mfxe_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ታ Ꮊያ አብስ ግኔ? ይንታን ዶሶዋ ግሾሶነ? ታኒ ይንታን ዶስዛና ጾስ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Ꮊንኮ ሀዋርታይ «ኑካ ኡ ጋርክ ኦꬆዳ» ዬጊ ጬቅዛ ኡ ጬቃይስ ኦገ ꬋብሶዳይስ Ꮊት ታ ኦꬅዛና ቲናስካ ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Ꮊይ ጋርክ አስታይ ክርስቶሳ ሀዋረ ኣዞዳይስ ፋና ላምዛ ዎርዶ ሀዋርታኔ ዶሻ ኦሳንችታ። ");
INSERT INTO mfxe_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","የይ ማላባዝ ባያ፤ አብስ ጊኮ፥ ጻላሄ ፖኦ ኪታንቾ ኣዞዳይስ ፋና ላምዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","የይ ግሾስ፥ ጻላሄ ኦሳንችታይ ጽሎትꬅ ኦሳንችታ ኣዞዳይስ ፋና ላምኮ የይ ዳማባዝ ባያ። ኡንቲ ዉርስꬃል ፋ ኦሳይ ጋርክ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","ኦንካ ታና ቦዞ ግ ቆፓማይ ጋርክ ማህካ ኦድዛ። ታ ይንትስ ቦዞ ኣዝኮካ ታ ላፋር ጬቅንቶዳይ ጋርክ ታና ቦዞ ኡዲ ኤኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ታኒ Ꮊይ ጋርክ ጬቅንቲ ኦድንታይ፥ ጎዳይ ኮይዝ ጋርክ ባዝን ቦዘትꬃር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ጋመ አሳይ Ꮊ ሳአባዛር ጬቅንትዛ ግሾስ ታካ ጬቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ይ ዎዛናማ ማቄዝ ግሾስ ቦዞ አስባዝ ኡፋይሳር ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ኦንካ ይንታን አይለ ኡድኮ ዎይ ይንታን ቦንቂኮ ዎይ ፓስ ማድንቶዳይስ ይንትኮ ሺቅኮ ዎይ ይንታል አፋ ኡትርትኮ ዎይ ይንታን ባቂኮ ይ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ኑኒ የያ ኦꬆዳይስ ጋመ ዳቡራ ማቄዛና ዬላትታር ታ ኦድዛ። ዝን ኦንካ ሚንጊ ጬቅንትኮ፥ ታካ ሚንጊ ጬቅንቶዳ። ታኒ የያ ቦዞ አስ ጋርክ ኦድንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ኡንቲ እብራወ? ታካ እብራወ። ኡንቲ እስሬለ? ታካ እስሬለ። ኡንቲ አፍራመ ሼሾ? ታካ አፍራመ ሼሺ። ");
INSERT INTO mfxe_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ኡንቲ ክርስቶሳ ኦሳናቾ? ታኒ ኤያ አስ ጋርክ ኦድዛ፥ ኡንታፕ አꬊዝ ክርስቶሳ ኦሳንቾ። ታኒ ኦሶር ጋመ ዳቡሬዛ፤ ኡንደና ዎደ አጭንቴዛ፤ ጋራፍንቴዛ፤ ጋመ ዎደ Ꮊይቆስ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","አይሁድታይ ታና ሀስታማኔ ኡዱፉን እችን ቶኬ ጋራፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ሀይꬒ ቶኬ ጉፈር ሾጭንቴዛ፤ ፐቲ ቶኬ ሹቻር ሾጭንቴዛ፤ ማርካበ ሀይꬒ ቶኬ መቄዛ፤ አባ ጋንጨ ፐቲ ቃማ ኩንꬅ አቅ ፔዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ታኒ ጋመ ኦገ ዳቡራር የꬌዛ። ክጻ ሃꬅ ድኦፐኔ ፓኖፕ ዋየ ታና ሄሌዛ። አይሁድታይኔ አይሁደ ማቀካ አሳይ ታል አፋ መቶ ሄልꬄዛ። ካታማ፥ ሊዦ፥ አባ፥ ታና ያሼዛ፤ አማንዛ ኣዝዛ አስታይ ታና ዋይሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ታኒ ኦሶር ዳቡረዛኔ ጫዌዛ፥ ጋመ ቶኬ ገንታ ꬋቤዛ፥ ናይንቴዛ፥ ሳምንቴዛ፥ ጋመ ቶኬ ጾሜዛ፥ ሜግንቴዛ፥ ካሎቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ሀራ ባዝ ኡባ ፓይዳምጽኮካ ኡባ ዎደ ታና ዎሳ ኬꬃታይባዝ ቆፍስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ፐቲ አስ ዳቡሮዳር ኤዛር ታ ዳቡረካዛይ አይደ? ፐቲ አስ ናጋራራ ꬉብንትን ታ አይደ ካጨካ አሼነ? ");
INSERT INTO mfxe_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ታ ጬቅንቶዳይስ ቤዝዛ ባዝ ማቅኮ ታኒ ዳቡራ ማቄዛና ኤርስዛባዛር ጬቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","መꬍናስ ቦንችንቴዝ ጾሳይ፥ ኑ ጎዳ የሱስ ክርስቶሳ ኣዳ፥ ታ ዎርዶቶዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ዳማስቆ ካታማይድ አረታሳ ግዝ ካታይፕ ኦሞር ሃርዛይ ታና አይꬆዳይስ ከዚ ዳማስቆ ካታማ ፐንጋ ናግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ዝን አሳይ ታና ዳቾ ጋንጨ ኦሊ፥ ካታማ ጋሰ ማስኮተር ዎꬍስን ታኒ ኤ ኩሸፕ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ጬቅንቶ አብካ አዶያ። ዝን ጬቅንታይ ኮሽኮ፥ ጎዳይፕ ኤኬዝ ቆንጭꬃይር ጬቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ታጶ ኦይዲ ላይꬃፕ ቲና፥ ክርስቶሳ አማንዛ ፐቲ አꬃይ ሃይꬓንꬆ ሳሎ Ꮊንጌዛና ታ ኤርዛ። የ አꬃይ Ꮊንጌዛይ አሾር ማቆ ዎይ አሾር ማቃምንጾ ታ ኤሮያ፤ ጾሲ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","የ አꬃይ ሃይꬒንꬃ ሳሎ ኤክንቴዛና ታ ኤርዛ። ዝን ኤ ኤክንቴዛይ አሾር ዎይ አሾር ማቃምንጾ ታ ኤሮያ፤ ጾሲ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","የ አꬃይ ገነተ ኤክንቲ አሲ ቆንጭሶዳይስኔ አሲ ኦዶዳይስ ዳንዳኦዋ ባዝ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ታኒ የ አꬃያ ባዛይ ግሾስ ጬቅንቶዳ፥ ዝን ታኒ ታ ዳቡራይፕ አትን ታል ጬቅንትዛባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ታኒ ቱሮ ኦድንትዝ ግሾስ ጬቅንቶዳይስ ኮይኮካ ቦዞ ባያ። ዝን አሲ ታ ኦꬅዛና ብእዛይፐኔ ስእዛይፕ ኣꬂ ቆፓም ጋርክ ግ ጬቅንቶፕ ናግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ታስ ቆንጬዝ ዳማ ቆንጭꬃር ታ ኡትርታማይ ጋርክ ታና ኡንእስዛ ታ አሻይድ ጫድዛ ጻላሄ ኪታንቻይ ታስ እንግቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","Ꮊ ኡንእꬅዛ ባዝ ታፕ ሃሶዳይ ጋርክ ታኒ ጎዳ ሀይꬒ ቶኬ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ዝን ጎዳይ፥ «ታ ዎልቃይ ነ ዳቡራር በንትዝ ግሾስ ታ ኣꬎ ኬሃትꬃይ ኔስ ማቆዳ» ዬጌዛ። ክርስቶሳ ዎልቃይ ታል በንቶዳይ ጋርክ ታ ዳቡራር ኡፋይትታር ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ታኒ ክርስቶሳ ግሾስ ዳቡርዛ ዎደ ጫዥንትዛ ዎደ ዋይዛ ዎደ ባይእንትዝ ዎደ መትንትዛ ዎደ ታ ዳቡርሳይር ኡፋይትዛ። አብስ ጊኮ፥ ታ ዳቡርዛ ዎደ የ ዎደ ሚንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ታኒ ቦዞ አሲ ጋርክ ኦዴዛ። የይ ጋርክ ታ ጬቅንቶዳይ ጋርክ ኦꬄዛይ ይንታና። ታ፥ ታ ኡባስ ኤርንቶዋ አስ ማቅኮካ፥ «ዳሞ ሀዋርታይፕ» አባራካ ላፎያ። የያ ታስ ማርካቶዳይስ ቤዝዛይ ይንታና። ");
INSERT INTO mfxe_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","ታ ይ ጋንጨ የዛር ዳንዳአር ኦꬄዝ ማላባዝታኔ ማሊታይ ዎልቃ ኦስታይ ታ ቱማ ሀዋረ ማቄዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","ታ ይንትስ ቶፎ ማቀካ አቴዛይፕ አትን Ꮊንኮ ዎሳ ኬꬅታይፕ ይ አባር ጽቄኔ? የይ ባላ ማቅኮ ታና ማሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ታኒ ይንትኮ Ꮊንጎዳይስ ጊግንቶዳር Ꮊይ ታስ ሃይꬒንꬆ። ታ ይንታፕ አትን ይንትስ የዛ ባዝ ኮዮዋ ግሾስ ይንታን ዋይሶዳይስ ኮዮያ። የሌዝታይ ፋ ናእታይስ ሻሎ ምንጅነፕ አትን ናእታይ ፋና የሌዝታይስ ሻሎ ምንጆያ። ");
INSERT INTO mfxe_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ታ ይ ግሾስ ታስ የዛባዝኔ ታና ኣꬂ እንግኮካ ታና ኡፋይስዛ። የዝን፥ ታኒ ይንታን Ꮊይ ጋርክ ዎልቃማ ሲቆ ሲቅዛ ዎደ ይ ታና ላፋር ሲቅነኔ? ");
INSERT INTO mfxe_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ሀኖፕ አትን፥ ታ ይንትስ ቶፎ ማቀካያ፤ ዋይሰካያ፤ ዝን ይንታን ዶሻራኔ ገነር አይኬዝባዝ ይንትስ ኣዞ አታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ሀራ አቶዝን፥ ታ ይንትኮ ኪቴዝ አስታይፕ ይንታን ዶሼዝ አስ የኔ? ");
INSERT INTO mfxe_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ትቶ ይንትኮ Ꮊንጎዳይ ጋርክ ታ ዎሴዛ፤ ማ አማንዛ እሻካ ኤዛር ዳኬዛ። የዝን፥ ትቶ ይንታን ዶሽኔ? ኑኒ ኑ ኦሳ ፐቲ አያናር ኦꬄካሳ? ማ ኑ ሀናይራካ ፐቶ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ኑ ኡባ ዎደ ይ ቲና ኑና ጽልሶዳይስ ሞትንትዛባዝ ይንትስ ኣዝኔ? ኑ ክርስቶሳር የዚ ጾስ ቲና Ꮊኖ ሄሎዳይስ ኦድዛ። ኑ ሲቆ እሹንꬆ፥ ኑ Ꮊ ኡባ ኦድዛይ ይንታን ድቾዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ታ ይንትኮ Ꮊንግዛ ዎደ ኦኒ ኤሬ ይ ታ ኮይዛይ ጋርክ ሀነካ፥ ማ ታካ ይ ኮይዛይ ጋርክ ሀነካዛር ዎል ሄሎ አታሚ ግ ያሽትዛ። ማ ኦኒ ኤሬ ይ ጋንጨ ፓላማ፥ ቅናተ፥ ካቺ፥ ፋና ቃ፥ ሀዎዛ አስ ሱንꬅ ኢሶ ኡትራኔ ጫቦቶ የሰ አታሚ ግ ታ ያሽትዛ። ");
INSERT INTO mfxe_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ታኒ ናምእንꬆ ይንትኮ Ꮊንጎዳር ጾሳይ ይ ቲና ታና ካዉሾዳ ግ ታ ያሽትዛ። ብኒ ናጋራ ኦꬂ ፋ ኦꬄዝ ቱናትꬃይፕ፥ ላግታ ቃይጸ ዬላꬅዛ ኦሶፕ ማቀካ አስታ ብኢ አዛኖ አሻሚ ግ ህርግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ታ ይንትኮ የኦዳር Ꮊይ ሃይꬒንꬆ። አባ ሞቶካ ናምአር ዎይ ሀይꬒ ማርካር ሚንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ታኒ ናምእንꬆ ይንታን ሄሌዝ ዎደ ይ ጋንጨ ቲና ናጋራ ኦꬄዝ አꬃኔ Ꮊንክታ ኡባ ሴሮ አሻሚ ግ ኦዳይል ጉጄዛ። Ꮊት ታ ሃኪ የዝኮካ ማቂ ይንትኮ Ꮊንጌዝ ዎደ ኦስካ ቃꬊንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ታር የዝ ኦድዛይ ክርስቶሳ ማቄዛና ይ ኤሮዳይስ ኮይዛ። ኤ ይንታር ኦድታር ዎልቃማፕ አትን ይ ጋንጨ ዳቡራ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ክርስቶሳ ማዝቃለል አፋ ዳቡራር ሶትንቴዛ፥ ዝን ጾስ ዎልቃር ደኦ የዝዛ። ኑካ ኤዛር ዳቡርታ ማቄዛ። ዝን ይንታር ኦꬅዛ ኦሳይር ጾስ ዎልቃር ደኦ የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","አማኖር ሚንጊ የዛኮ ይንታን ይንትስ ፓጪ ቦኦይታ። ፓጨር ይ ፖከካ አትኮ፥ ክርስቶሳ ይንታር የዛና ይ ኤርዛ። ዝን ክርስቶሳ ይንታር የዛም እጽኮ ይ ፖኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ኑኒ ፓጨር ፖኮዋዛና ይ ኤርዛ ግ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ይ ኢታ ባዝ ኦꬃማይ ጋርክ ኑኒ ጾስ ዎስዛ። ኑኒ ምኖ ማቄዛና አሳይ በአዳይ ጋርክ ባዝን ኑኒ ምኖ ማቃም እጽኮካ፥ ይ ሎኦ ባዝ ኡዶድ ጋርክ ኑኒ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ኑኒ ቱማስ ኦꬅነፕ አትን ቱማር ኤቅንትዛባዝ አብካ ኦꬃሚ። ");
INSERT INTO mfxe_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ኑ ዳቡሮዳር ይ ማ ምንግኮ ኑና ኡፋይስዛ። ይ ቦሮ ባዝታ ማቆዳይ ጋርክ ኑ ይንትስ ጾሳ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ታኒ ይንትፕ ሃኮ የዛር ጻፌዛይ የይ ግሾስ። ታኒ ይንትኮ Ꮊንጌዝ ጋላስ ጎዳይ ታስ እንጌዝ ማዉታይል አንክቲ ይንታል አፋ ጎዳቶዳይስ ኮዮያ። ጎዳይ ታስ ማዉተ እንጌዛይ፥ ይንታን ሚንꬆዳይሳፕ አትን ላሎዳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Ꮊይፕ ገደ ታ እሹንꬆ፥ ሳሮ የዞይታ። ቦሮ ባይꬅ የዞይታ፤ ታ ዞራ ስኦይታ። ፐቲ ዎዛና ማቂ የዞይታ፤ ሳሮትꬃር የዞይታ። ሲቆኔ ሳሮ እንግዝ ጾሳይ ይንታር ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ጌሽ ዬራ ዬርንቶር፥ ዎል ሳሮꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","ጾሳ አሳይ ኡባይ ይንታን ሳሮ ሳሮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ፥ ጾስ ሲቃይ፥ ጌሻ አያና ፐትፐተꬃይ ይ ኡባይር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","አሳፕ ዎይ አስ ባጋር ባዝን የሱስ ክርስቶሳፕ ኤዛ Ꮊይቆፕ ደንꬄዝ ጾስ አዳይፕ ሀዋረ ማቃድ ጋርክ ኪትንቴዝ ታ ጳዉሎሳ፥ ");
INSERT INTO mfxe_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ታር የዝ አማንዛ እሽታይ ኡቢታይፕ፥ ጋላትያ ጋደ የዛ ዎሳ ኬꬅታይስ ኪትንቴዝ ኪታ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","ጾስ ኑ አዳይፐ ኑ ጎዳ የሱስ ክርስቶሳፐ ይንትስ ኣꬎ ኬሃትꬅኔ ሳሮትꬂ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","Ꮊ ኢታ አላማይፕ ኑና አሾዳይስ፥ ኑ ጾሳይኔ ኑ አዳይ ሸነር ክርስቶሳ ኑ ናጋራ ግሾስ ፋና ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ጾሳይስ መꬊናፕ መꬍና ሄሎዳይስ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ክርስቶሳ ኣꬎ ኬሃትꬃር ይንታን ጼጌዝ ጾሳ አሺ፥ ሀራ ዎንግላይኮ ይ ኤልሲ ዋይዚ ማቄዛኮ ታስ ማላባዝ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ይንታን ባልꬅታራኔ ክርስቶሳ ዎንግለ ዎብሶዳይስ ኮይዝ ፐቲ ፐቲ አስታይ የዛፕ አትን ቱማ ዎንግላይ ፐቶ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ዝን ኑና ማቅን ዎይ ሳሎ ኪታንቾ ማቅን ኑን ይንትስ ቲና ኦዴዝ ዎንግላይፕ ዱማትዛ ሀራ ዎንግለ ይንትስ ኦዴዝባዝ ማቅኮ፥ ኤ ጫዥንቴዛ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","Ꮊይፕ ቲና ታኒ ጌዛይ ጋርክ Ꮊተካ ማሂ ግዛ። ይ ኤኬዝ ዎንግላይፕ ዱማትዛ ዎንግለ ኦንካ ይንትስ ኦድኮ የ አꬃይ ጫዥንቴዛ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","የዝን፥ ታና አሲ ናሽቾድ ጋርክ ኮይነኔ? ጾሲ ናሽቾድ ጋርኬ? ታ አስ ኡፋይሶዳይሶኔ? ታ አስ ኡፋይሶዳይስ ኮይዝ ባዝ ማቅኮ፥ ክርስቶሳ አይለ ማቃምዝን። ");
INSERT INTO mfxe_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","ታ እሹንꬆ፥ ታ ይንትስ ኦዴዝ ዎንግላይ አሳፕ ሀነካዛ ይ ኤሮድ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ታስ Ꮊ ዎንግላ የሱስ ክርስቶሳ ዶዬዛፕ አትን አሳፕ ኤከካያ ዎይ አሲ ታና ታማርሰካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ታ ቲና አይሁድታይ አማናይድ የዝ ዎደ ዋይዚ የዜዛኮ፥ ይ ስኤዛ። ታ ጾሳ ዎሳ ኬꬅ ባይኦዳይስኔ ꬋብሶዳይስ ቡትቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","አይሁድታይ አማና ናጎር ታኒ፥ ታ ዎዳይድ የዝ ጋመ አይሁደ ዳብታይፕ ኣꬍዛ። ኑ አድታይ ዎጋይስካ ኡባፕ ኣꬂ ምጭንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ዝን ታ ሀጋ የልንቶዳይፕ ቲና ጾሳይ ታና ዶሬዛ፤ ፋ ኣꬎ ኬሃትꬃራ ታና ጼጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","አይሁደ ባ አሳይስ ዎንግለ ኦዶድ ጋርከ ጾሳይ ፋ ናአ ታስ ቆንጭሶዳይስ ኮዬዝ ዎደ ታ ኦራካ ዞርንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ዎይ ታፕ ቲና ሀዋረ ማቄዝታይር ዎል ሄሎዳይስ የሩሳላመ Ꮊንገካያ። ዝን ታ ቲናቲ አራበ ቢታ Ꮊንጌዛ፤ የይፕ ማቂ ዳማስቆ ካታማ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ሀይꬒ ላይꬃፕ ጉየ፥ ኬፋ ግንትዝ ጵጽሮሳ ሄሎዳይስ የሩሳላመ Ꮊንጊ ኤዛር ዎላ ታጶ እችን ቃማ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ዝን ጎዳይ እሻ ያይቆባፕ አትን Ꮊንኮ ሀዋርታ ታ በኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ታ ይንትስ ጻፍዛይ ዎርዶ ባዛና ጾስ ቲና ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","የይፕ ጉየ፥ ታኒ ሶራ ቢታኔ ክልቃ ቢታ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ይሁዳ ጋንጨ የዝ ዎሳ ኬꬅ አሳይ ታና ብኢ ኤረካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ዝን ኡንቲ፥ «ካሰ ኑና ባይእꬅዝ አꬃይ፥ Ꮊት ኤ ꬋብሶዳይስ ኮይዝ አማናይ ባጋ ሳባክዛ» ዬግዛና ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ስኤዝ ኡባይ ታ ባጋስ ጾሳ ጋላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ታጶ ኦይዲ ላይꬃፕ ጉየ፥ ባርናባሳር ማቂ የሩሳላመ ታ Ꮊንጌዛ። የ ዎደ ትቶና ታ ታር ኤኪ Ꮊንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ጾሳይ ታስ ቆንጭሴዝ ቆንጭꬃይር ኤዛይድ Ꮊንጊ አይሁደ ባ አስ ጋንጨ ታ ሳባክዛ ዎንግላ ኡንትስ ቆንጨ ከሴዛ። ቲና ታ ዎጼዝ ዎꬃይኔ Ꮊተካ ታ ዎጽዛ ዎꬃይ ጨረ ማቃም ጋርክ ግ ካልꬅዝታ ዱማ ሺሺ ኡንትስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ሀራ አቶዝን፥ ታር የዝ ትቶ ግርከ አስ ማቅኮካ፥ ዶካልንቶ ግ ኤዛ ጪጲቸካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ማቆዝን፥ አማንዛ እሽታ ኣዚ ኑ ጋንጨ ገሌዝ ፐታይ ፐታይ ኤ ዶካልንቶድ ጋርክ ኮዬዛ። የ አስታይ ክርስቶስ የሱሳር ኑስ የዝ ዋሎትꬃ ቦንቂ ኤኮዳይስ ዙርቅንቲ ኑ ጋንጨ ገሊ ማሂ ኑና አይልꬆዳይስ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ዝን ቱማ ዎንግላይ ይንታር ሚንጊ የዞድ ጋርክ ኑኒ ሀራ አቶዝን፥ ጽቃ ዎደስካ ኡንትስ ኩሸ እንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ዝን አቅስዝታ ኣዝዝ አሳይ ኦናትꬃይ ታስ አብካ ማቀካያ። ጾሲ አስ ኣፈ ብኢ ፕርዶያ። Ꮊ አስታይ ታ ማርካትዝ ዎንግላይል አፋ ጉጄዝ ባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ዝን ጵጽሮሳ፥ አይሁድታይስ ዎንግለ ኦዶ ግ ጾሳይ ኤዝስ ሀዳራ እንጌዛይ ጋርክ ታስካ አይሁደ ባ አሳይስ ዎንግለ ኦዶድ ሀዳራ እንጌዛና ኡንቲ ጉየፕ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ይኬ፥ ጵጽሮሳ አይሁድታይ ሀዋረ ማቃዳይ ጋርክ ኦꬄዝ ጾሳይ፥ ታናካ አይሁደ ባ አሳይስ ሀዋረ ማሄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ማ ቱስ ኣዚ በንትዝ ያይቆባ፥ ጵጽሮሳኔ ዋንሳ፥ ታስ እንግንቴዝ ኣꬎ ኬሄትꬃ ብኢ ኑር ማድንቶዳይስ ታስኔ ባርናባሳስ ፋ ኡሻች ኩሻ እንጌዛ። ኑኒ አይሁደ ባ አሳይኮ፥ ማ ኡንትካ አይሁደ አስታይኮ Ꮊማዳይስ ማእንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ኡ ኑና ሚንꬂ ሀዳራ ጌዛይ፥ ኑኒ ማንቅታይስ ቆፖዳና። ካሰካ ታ የያ ኦꬆዳይስ አሞትዛይሲ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጵጽሮሳ አንጾካ ካታማ Ꮊንጊ ባልንቴዝ ግሾስ ታኒ ኤ ቲና «ኔኒ ባልንቴዛ» ግ ጋይሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ያይቆባ ኪቲ ዳኬዝ ጽቃ አሳይ የኦዳይፕ ቲና ኤ አይሁደ ባ አስታይር ዎላ ሚዛ፥ ዝን ኡንቲ የኤዛይፕ ጉየ፥ «አይሁደ ባ አሳይፕ አማኔዝታይ ዶካልንቶዳይስ ቤዝዛ» ግዝ አሳይስ ያሽቲ ኡንታፕ ሻክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ማ Ꮊንኮ አማኔዝ አይሁድታይ ጵጽሮሳ ሀና ካሌዛ። ሀራ አቶዝን፥ ባርናባሳካ ኤ ቆፋይድ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ዝን ኡንቲ ዎንግለ ቱማትꬃር ሉለ የꬎዛና ታ ብኢ፥ ጵጽሮሳና አስ ኡቢታይ ቲና፥ «ኔኒ አይሁደ ማቅታር፥ አይሁደ ዎጋይ ጋርክ ባዝን አይሁደ ባ አስ ጋርክ የዝዛ፤ የዝን፥ ዋይዚ አይሁደ ባዝታይስካ፥ አይሁደ ዎጋይድ የዞይታ ግ ነ ዎልቃቴ?» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ኑኒ የልንቶ አይሁደ፥ ዝን ናጋራ ኦꬅዝ አይሁደ ባ አስ ጋርክ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ዝን አሲ የሱስ ክርስቶሳ አማኒ ጽልዛፕ አትን ህገ ናጊ ጽሎዛና ኑ ኤርዛ። ኦንካ ህገ ናጊ ጽሎዋ ግሾስ ኑካ ህገ ናጎር ባዝን ክርስቶሳ አማኒ ጽሎድ ጋርክ ክርስቶስ የሱሳና አማኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ክርስቶሳ ባጋር ጽሎዳይስ ኮይታር፥ ኑካ ናጋራ ኦꬅዛባዝ ማቅኮ የዝን፥ ኑ ናጋራ ኦꬆድ ጋርክ ደንꬅꬅዛይ ክርስቶሳ ጉሶኔ? ዋኣ! ");
INSERT INTO mfxe_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ይኬ፥ ታ ላሌዛና ህገ ዎጋ ማሂ ኬጽዛ ማቅኮ ታኒ ታ ኡባስ ህገ መንꬅዛ ማቄዛና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ታኒ ጾስስ ፓꬅ የዞዳይ ጋርክ ህገ ባጋር ህገስ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ታኒ ክርስቶሳር ዎላ ሶትንቴዛ። ታኒ Ꮊይፕ ታስ የዛሚ፥ ዝን ክርስቶሳ ታር የዛ። ታ Ꮊት የዝ የሳ፥ ታና ቃꬊ ታ ግሾስ ፋና ኣꬂ እንጌዝ ጾስ ናአ አማኒ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ታኒ ጾስ ኣꬎ ኬሄትꬃ ጨረ ኡዳሚ። ጽሎትꬂ አስስ ህገ ባጋር በንትዝ ባዝ ማቄዛኮ፥ ክርስቶሳ ጨር Ꮊይቄዝ ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","ይንታኖ፥ አካካ ባ ጋላትያ አስታዮ፥ ይ ኣፋይ ቲናይድ ክርስቶሳ ማዝቃለል አፋ ሶትንቴዛይ ጋርክ ምስልንቲ ፕ በንትዛ። የዝን፥ ቱማስ ይ ኪትንታማይ ጋርክ ይንታን ብቴዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ፐት ባዝ ታ ኤሮዳይስ ኮይዛ፤ ይ ጌሻ አያና ኤኬዛይ ህገ ናጎራኔ ዎይ ይ ስኤዝ ዎንግላ አማኖራ? ");
INSERT INTO mfxe_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ይ Ꮊይ ጋርክ ቦዞ? ይ ጾስ አያናር አይኪ፥ Ꮊት አሾር ፖሎዳይስ ኮይኔ? ");
INSERT INTO mfxe_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ይ ዎንግለ ባጋር ጋመ ዳቡሬዛይ ጨሬ? የ መቶ ኡባይ ጨረ ማቃሬ? ");
INSERT INTO mfxe_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ጾሳይ ይንትስ ጌሻ አያና እንግዛይኔ ይ ጋንጨ ማላ ባዝ ኦꬅዛይ፥ ይ ህገ ናጌዛይ ግሾኔ? ዎንግለ ስኢ አማኔዝ ግሾሶ? ");
INSERT INTO mfxe_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","አን አፍራመና ቦኦይታ፥ «ኤ ጾሳና አማኔዛ፤ ጾሳይ ኤዝስ የያ ጽሎትꬅ ማሂ ታይቤዛ» ዬግንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ይኬ፥ አማንዝታይ አፍራመ ናእታ ማቅዛና ኤሮይታ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ጾሳይ አይሁደ ባ አስ አማኖር ጽልꬆዳና ጌሻ ማጻፋይ ቲና ብኢ፥ «ዎያ ኡባይ ነ ባጋር አንጅንቶዳ» ዬጊ፥ ምሽራቾ ቃላ አፍራመስ ቲናቲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","የይ ግሾስ፥ አማንዛ ኡባይ አማኔዝ አፍራመር ዎላ አንጅንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","ህገ ናጊ ጽሎድ ግዝ ኦንካ ጫዥንቴዛ። አብስ ጊኮ፥ ጌሻ ማጻፋይድ፥ «ህገ ማጻፋይ ጋንጨ ጻፍንቴዝ ኡባ ናጎዋ ኦንካ ጫዥንቴዛ ማቆ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","«ጽሎ አስ አማኖር የዞዳ» ግንትንቲ ጻፍንቴዝ ግሾስ ኦንካ ጾስ ቲና ህገ ናጊ ጽሎዛይ ኤርንቴዝ ባዚ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ህገ አማኖር ዎላ Ꮊንጎያ። ዝን፥ «ህገ ህገር የዞዳይስ ዳንዳእዛይ ህገ አዛዞ ኡባ ፖልኮ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","«ምꬃል አፋ ሶትንቲ Ꮊይቅዝ ኦንካ ጫዥንቴዛ» ግንትንቲ ጻፍንቴዝ ግሾስ ክርስቶሳ ኑ ግሾስ ጫዥንቴዛ ማቂ፥ ኑና ህገ ጫሻፕ ዎዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ጾሳይ አፍራመስ እንጌዝ አንጆ፥ የሱስ ክርስቶሳ ባጋር አይሁደ ባ አስ ሄሎድ ጋርከኔ ጾሳይ እማድ ጌዝ ጌሻ አያና ኑኒ አማኖር ኤኮድ ጋርክ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ታ እሹንꬆ፥ ታ ይንትስ አስ የሳር ጋምእ የዛ ባዝ ኣዝሶ ኡዲ ኦድዛ። አሲ ጫቄዝ ጫቆ ቃላይ ምንጌዛይፕ ጉየ፥ ኦንካ የ ጫቆ ቃላ ሻሮዳይስ ዎይ ኤዛል አፋ ሀራ ጉጆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ጾሳይ የ ኡፋይስ ቃላ አፍራመስኔ ኤ ሼሻይስ እንጌዛ። ጌሻ ማጻፋይ፥ ጋመ አስስ ኦድዛይ ጋርክ፥ «ነ ሼሽታይስ» ጎያ። ዝን ፐቲ አስስ ኦድዛይ ጋርክ፥ «ነ ሼሻይስ» ዬግዛ፤ ኤዝካ ክርስቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ታኒ ግዛይ Ꮊያ፤ ኦይዲ ጼታኔ ሀስታም ላይꬃፕ ጉየ እንግንቴዝ ህጋይ፥ ቲና ጾሳይ ምንꬄዝ ጫቆ ቃላ ሻሪ ኡፋይስ ቃላ ꬋብሶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ጾሳይ እንግዝ ላታይ ህገር ኤክንትዛባዝ ማቄዛኮ ጾሳይ እንጌዝ ኡፋይሳይ ባጋር ማቅዛይ አትዛ። ዝን ጾሳይ ፋ ኣꬎ ኬሃትꬃር ላታ አፍራመስ ኡፋይስ ቃላ ባጋር እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","የዝን፥ ህጋይ አብስ እንግንተኔ? ህገ እንግንቴዛይ፥ አፍራመስ ኡፋይስ ቃላ እንግንቴዝ ዘርꬃይ የኦድ ጋꬆ ኢታ ኦሶ አብዛኮ ኤርሶዳይሲ። ህገ ኪታንችታይ ባጋር እንግንቲ፥ ጋንጨ ማቂ ዳቦꬅዛ ፐቲ አስ ባጋር ኦሶል አፋ ፔዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ጋንጨ ማቂ ዳቦꬅዛ አꬃይ ፐቲ ባጋ ኣዳፕ ባያ፥ ዝን ጾሳይ ፐቶ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","የዝን፥ ህጋይ ጾስ ኡፋይስ ቃላ እጽነኔ? እጾያ! ህገ እንግንቴዛይ ደኦ እማዳይስ ማቄዛኮ፥ ጽሎትꬂ ህገ ባጋር በንቶዳዝን። ");
INSERT INTO mfxe_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ዝን የሱስ ክርስቶሳ አማንን በንትዝ ኡፋይስ ቃላይ አማንዝታይስ እንግንቶድ ጋርክ አላማይ ኩንꬃይ ናጋራ አቻ የዛና ጌሻ ማጻፋይ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","ዝን አማኖ የኦዳይፕ ቲና ህገ ኑና አጪ ጋዴዛ። የ አማናይ በንቶድ ጋꬆ ህጋይ ኑል አፋ ጎርዲ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","የይ ግሾስ፥ ኑኒ አማኖር ጽሎዳይ ጋርክ ክርስቶሳ የኦድ ጋꬆ ህጋይ ናአ ናግዝ አስ ጋርክ ኑና ናግዛያ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ዝን Ꮊተ አማኖ የኤዝ ግሾስ ህገ Ꮊይፕ ጉየ ናአ ናግዝ አስ ጋርክ ማቄዝ ህጋይ ኦሞር አቅꬅ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","ይ ኡቢታይ የሱስ ክርስቶሳና አማኒ ጾስ ናእታ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ክርስቶሳር ፐቶ ማቆዳይስ ጻማቅንቴዝ ኡቢታይ ክርስቶሳና አፍላ ጋርክ ማኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ይ ኡቢታይ ክርስቶሳር ፐቶ ማቄዝ ግሾስ አይሁደ አስ ጋንጨኔ ግርኬ አስ ጋንጨ፥ አይለ ጋንጨኔ ዎማኖ ጋንጨ፥ ꬊራꬅ ጋንጨኔ ማች ጋንጨ ዱማትꬂ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ይኬ፥ ይ ክርስቶሳስ ማቅኮ ይ አፍራመ ኮቺ። ጾስ ኡፋይስ ቃላይ ጋርክ ይ ላትዝታ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","Ꮊተካ ታ ግዛይ Ꮊያ። ላትዛ ናአይ ዱደትꬃ የዛ ዎደ፥ ሻሎ ኡባይ ኤባዝ ማቅኮካ፥ ኤ አይለፕ አባራካ ዱማቶያ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ዝን ኤ አዳይ ጌዝ ዎዳይ ሄሎዳይስ ኤ ሀዳራ ኤኬዝታይ ኩሸኔ ናግዝታይ ኩሸ የዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","የይ ጋርክ፥ ኑኒ አያና ባዝስ ዱደ ማቂ የዝ ዎደ አላመ ዎጋስ አይልቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ዝን ዎዳይ ሄልን ጾሳይ ማቻፕ የልንቴዝ ፋ ናአና ኪቴዛ። ኤዝካ ህገስ አዛዝንቴዛያ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ኤ የያ ኦꬄዛይ፥ ህገስ ሃርንቲ የዝታ ዎዞዳይስኔ ኑና ፋ ናእታ ኦꬆዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ኑ ጾስ ናእታ ማቄዝ ግሾስ «አቦ፥ ታ አዳዮ» ዬጊ ጼግዝ ፋ ናአይ አያና ኑ ዎዛና ጋንጨ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","የይ ግሾስ፥ Ꮊይፕ ኔኒ ጾስ ናአፕ አትን አይለ ባያ። ኔኒ ኤ ናአ ማቅኮ፥ ጾሳ ላትዛ አስ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ይ ቲና ጾስ ኤሮዋ ዎደ ጾስ ባዝታይስ አይለ ማቂ ሃርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ዝን Ꮊት ይ ጾስ ኤሬዛ፤ ኡባራካ ጾሳር ኤርንቴዛ። የዝን ፓꬆዛይኮኔ ማዶዋ አላመ ዎግታይኮ ጉየ ዋይዚ ማቄ? ዎꬊ ኤቂ፥ ዋይዚ ኡንትስ አይለ ማቆዳይስ ኮዬ? ");
INSERT INTO mfxe_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ዱማ ማቄዝ ጋላስታ፥ አግንታ፥ ዎድታኔ ላይꬅታ ይ ሎእꬂ ቦንችዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ታ ይ ጋንጨ ይንትስ ዳቡሬዛይ ጨረ አቶደሻ ግ ታ ያሽቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","ታ እሹንꬆ፥ ታ ይ ጋርክ ሀኔዝ ግሾስ ይንትካ ታ ጋርክ ሀኖይታ ግ ይንታን ዎስዛ። ይ ታና አባራካ ቆሄካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ታኒ ቲና ሀርግንትታር ይንትስ ዎንግለ ኦዴዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ታ ሀርጋይ ይንትስ ፓጨ ማቅኮካ፥ ይ ታና ሳልንተካያ፤ እጸካያ። ዝን ታና ጾስ ኪታንቾ ዎይ ክርስቶስ የሱሳ ሞክዛይ ጋርክ ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","የዝን፥ የ ይንትስ የዛ ኡፋይሳይ ኡባይ አና Ꮊንጌኔ? ይንትስ ዳንዳእንቴዛኮ፥ ይ ይ ኣፋ ከሲ ታስ እንግዛኮ እጻምዛና ታ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","የዝን፥ ታ ይንትስ ቱማ ኦዴዝ ግሾስ ይንትስ ሞርከ ማቃረኔ? ");
INSERT INTO mfxe_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","የ አሳይ ይንታን ፋኮ ማሆዳይስ ኮይዛ፥ ዝን ኡ ቆፋይ ሎኦስ ባያ። ኡ ቆፋይ ይንታን ሻጎዳይስኔ ይ ኡንትስ ቆፖድ ጋርክ ኦꬆዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ሎኦ ባዝ ኦꬆዳይስ አሞትኮ ሎኦ፥ ዝን የይ ታ ይንታር የዝ ዎደ ኣዳ ባዝን ኡባ ዎደ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ታ ሲቆ ናኡንꬆ፥ ክርስቶሳ ይንታል ምስልንቶድ ጋꬆ የሎስ ማች እቅንትዛይ ጋርክ ታ ይ ግሾ ማካ እቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ካሴሳይፕ ታ ቆፋ ላሞዳይስ ኮዬዛዝን ታስ ኤርንታም እጽን ታ መትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","ህገስ ሃርንቲ የዞዳይስ ኮይዝታዮ፥ አን ታስ ኦዶይታ፤ ህጋይ ዋግዛኮ ይ ኤሮሳ? ");
INSERT INTO mfxe_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ጌሻ ማጻፋይ፥ «አፍራመስ ጋꬊንዳትፐኔ ጎዳታትፕ የልንቴዝ ናምኢ ናእታይ የዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ጋꬊንዳቲ ናአይ አስ ናአ የልንትዛይ ጋርክ የልንቴዛ፥ ዝን ጎዳታቲ ናአይ ጾስ ኡፋይሳ ቃላር የልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","Ꮊ ማችታይ ናምኢ ጫቅታይስ ኣዝሶ ማቂ ኤክንትዛ። ኡንታፕ ፐታት፥ ሲና ደረላፐ የኤዛና፥ ፋ ናእታ አይለትꬅስ የሌዛ፤ እዛካ አጋሮ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","አጋራ አራበ ቢታል የዝ ሲና ደረር ኣዝስንቲ Ꮊት የዝ የሩሳላመ ኣዝዛ። አብስ ጊኮ፥ እዛ ፋ ናእታይራ አይለትꬃ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ዝን ሳሎፕ ማቄዝ የሩሳላመ አይለትꬃር የዞያ፤ እዛ ኑስ ኡባይስ እንዶ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","ጽሎ ማጻፋይ፥ «ቡሽተ፥ የለካ ꬎንꬃቴ ኡፋይቶባ፤ ቡሽተ እቅንት ኤሮዛኔ እልሶባ። አዝናር የዝ ማቻትፕ፥ አዝኒ ባ ማቻትስ ናእታይ ጋመ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ታ እሹንꬆ፥ ይ እሳቃ ጋርክ ጾስ ኡፋይስ ቃላር የልንቴዝ ናእታ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ዝን የ ዎደ አስ ዎጋር የልንቶዳይስ፥ አያና ዎልቃር የልንቴዛና ባይኤዛ። Ꮊይኖካ የይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ዝን ጌሻ ማጻፋይ ዋጌ? «ጋꬊንዳቲ ናአይ ጎዳታቲ ናአይራ ዎላ ላቶዋ ግሾ ጋꬊንዳቶ እ ናአይራ ዎላ ከሲ ዳኮባ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","የይ ግሾ፥ ታ እሹንꬆ፥ ኑኒ ጎዳታቲ ናእታይፕ አትን ጋꬊንዳቲ ናእታ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ኑኒ ዋሎትꬃር የዞዳይ ጋርክ ክርስቶሳ ኑና አይለትꬃፕ ከሴዛ። ይኬ፥ ሚንጊ ኤቆይታ፤ ማቂ አይለትꬅ ቃምባራይድ ገልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ታ፥ ጳዉሎሳ፥ ግዛ ስኦይታ። ይ «ዶካልንቶ ማድዛ» ግ ይ ዶካልንቶዳይስ ኮይኮ፥ ክርስቶሳ ይንታን አብካ ማዶያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ዶካልንትዛ ኦንካ ህጋይ ኪትዛ ኡብታ ፖሎዳይስ ቤዝዛና ማሂ ታ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ህገ ናጊ ጽሎዳይስ ኮይዝታይ፥ ክርስቶሳፕ ሻክንቴዛ፤ ጾስ ኣꬎ ኬሃትꬃይፕ ይ ሃኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ዝን ኑኒ ጾስ አያና ባጋር አማኖር ጽሎዳይስ ኡፋይሳር ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ይኬ፥ ክርስቶስ የሱሳር የዝኮ፥ ሲቆር በንትዝ አማኖፕ አትን ዶካልንትን፥ ዶካልንተካ አትን ኑና አብካ ማዶያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ቲና ይ ሎኦ ዎጽዛ፥ ዝን Ꮊት ቱማስ አዛዝንታማይ ጋርክ ይንታን ካዬዛይ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","Ꮊይ ጋርክ ኢታ ዶሻይ ይንታን ጼጌዝ ጾሳይፕ የኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","የይካ፥ «ጽቃ እርሾ ሙኑቆ ኡባ ደንꬅዛ» ግንትንቲ ጻፍንቴዛይ ጋርክ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ይንትስ ሀራ ቆፋ ባዛይስ ታ ጎዳይል አማንንትዛ። ዝን ይንታን ቡቅዝ ኦንካ ጾሳፕ ፋ ፕርዳ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","ታ እሹንꬆ፥ ታ Ꮊያ ሄሎዳይስ ዶካልንቶ ሳባክዛባዝ ማቅኮ፥ የዝን ታና አብስ ባይኤ? የይ ቱማ ማቄዛኮ ክርስቶሳ ማዝቃላይ ባጋ ታማርሳይ አስስ ꬉበ ማቃምዝን። ");
INSERT INTO mfxe_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ይንታን ቡቅዝታይ ፋና ዶካልꬅ ኣዳ ባዝን ፋና ቃራትዛኮካ ታ ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","ታ እሹንꬆ፥ ይ ዋሎ የዞዳይስ ጼግንቴዛ። ማቆዝን፥ ይ ዋሎትꬃይ አሾ አሞትꬅ ፖሎዳይስ ይንትስ ሳንከ ማቅፐ፤ የይፕ ኣꬂ ፐታይ ፐታ ሲቆር ማዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ህገ ኡባይ፥ «አስ ነ ኡባይ ጋርክ ቃꬎባ» ዬግዝ ፐቲ ቃላር አጭንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ዝን ይ ፐታይ ፐታይር ሳጽንትዝባዝኔ ሚንትንትዝባዝ ማቅኮ፥ ይ ዎል ዉርሳማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ይኬ፥ ታ ይንትስ ኦድዛ፤ አያናር የዞይታ፤ ይ አሾ አሞ የሻ ፖልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","አሾ አሞ አያና አሞር ሞርከ፤ ማ አያና አማይካ አሾ አሞራ ሞርከ። ኡንቲ ፐታይ ፐታይር እጽንትዛ ግሾስ ይ ዶስዛባዝ ኦꬆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","ዝን አያናይ ይንታን ካልꬅዛ ባዝ ማቅኮ ህገ ይንታን ሃሮያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","አሾ ኦስታይ ኤርንቴዝታ፤ ኡንትካ፥ ላግተ፥ ቱና ኦꬆ፥ ቃይጸ፥ ");
INSERT INTO mfxe_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ኤቃስ ጎይኖ፥ ቢታ፥ ሞርክንቶ፥ ካቺ፥ ቅናተ፥ ጫሺ፥ ፋና ዶስꬂ፥ ሻክንቶ፥ ኢታ ቶባ ");
INSERT INTO mfxe_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ገነ፥ ማꬄ፥ የꬅኔ የይትታ ኣዝዝታ። ቲና ታ ይንትስ ኦዴዛይ ጋርክ Ꮊተካ ታ ይንትስ ኦድዛ። Ꮊይ ጋርክ ባዝታ ኦꬅዝታይ ጾስ ካተትꬂ ላቶያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ዝን አያና ኣፋይ፥ ሲቆ፥ ኡፋይሲ፥ ሳሮትꬂ፥ ምንꬃꬆ፥ ሃዮትꬂ፥ ሎኦትꬂ፥ አማኖ፥ ");
INSERT INTO mfxe_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","አሽከትꬂ፥ ፋና ሃሮ። Ꮊይ ጋርክ ባዝታ እጽዛ ህገ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ክርስቶሳ የሱሳስ ማቄዝታይ ፋ አሾ ኤ ኢታ ቆፋይራኔ ኤ አማይራ ዎላ ማዝቃለል አፋ ሶቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","ኑ አያናር የዛ ባዝ ማቅኮ፥ ኑና አያናይ ካልꬆ። ");
INSERT INTO mfxe_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","አን ፐታይ ፐታ ይሎስታራኔ ቅናትታር ጨር ጬቅንትꬃ ዎላ አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","ታ እሹንꬆ፥ አሲ ባልንቲ ቡታ ባዝ ኦꬅኮ፥ አያናር የዝ ይ የ አꬃ አሽከትꬃር ሉልሶይታ። ዝን ኔኒ የይ ጋርከ ባዛር ፓጭንታም ጋርክ ነና ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ፐታይ Ꮊንካይ ዴጾ ቶፋ ቶኮ፥ ዬዝኮ ክርስቶሳ ህጋ ይ ፖልዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ፐቲ አሲ አኮካ ባዝን፥ ፋና Ꮊንክታይፕ ሎኦ ግ ቆፕኮ፥ ኤ ፋና ዶሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ዝን ፐቲ ፐቲ አሲ ፋ ኦሳ ፋጮ። የይፕ ጉየ፥ ሀራ አሳር ፋና ቄልꬅዛ አሺ ፓስ ጬቅንትዛ ባዝ ደንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ፐቲ ፐቲ አሲ ፋ ቶፎ ፓስ ቶኮዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ጾስ ቃላ ታማርዛ ኦንካ ሎኦ ባዝ ኡባ ፋ አስታማራይራ ግሽንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ይ፥ ይንታን ባልꬅፓተ። አሲ ፋ ዘሬዛኖ ማሂ ማጽዛ ግሾ ጾሳ ዶሽፓተ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ፋ አሾ አሞ ኩንꬆዳይስ ዘርዝ ኦንካ፥ ፋ አሾ እናፕ Ꮊይቆ ማጾዳ። ዝን አያና ኡፋይሶዳይስ ዘርዝ ኦንካ አያናፕ መꬍና ደኦ ማጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","አን ሎኦ ኦሶ ኦꬆዳይስ አዛልዛና ዎላ አሾዳ። ኑኒ አዛላም እጽኮ ዎዳይ ሄሌዝ ዎደ ኑ ዘሬዛና ማጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ኑ ጊጋ ዎደ ደንግኮ፥ አስ ኡባይስ፥ ኣꬅካ አማንዛ አስስ ሎኦ ባዝ ኦꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ታኒ ታ ኩሻይር፥ አብ ጋርክ ዳማ ፕዳለር ይንትስ ጻፌዛኮ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","አስ ቲና ሎኦ ማቂ በንቶዳይስ ኮይዝ አሳይ ይ ዶካልንቶድ ጋርክ ኮይዛ። ዝን የያ ኡንቲ ኦꬅዛይ፥ ክርስቶሳ ማዝቃለ ግሾ ኡንታን ባይእꬂ ሄላማይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ኡንቲ ይ ዶካልንታይር ጬቅንቶዳይስ ኮዪ ይንታን ዶካልንቶ ግዛፕ አትን ዶካልንቴዝታይካ ፋ ኡባስ ህገ ናጎያ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ዝን ኑ ጎዳ የሱስ ክርስቶሳ ማዝቃላይፕ አትን ሀራ አላማይ ታስ ሶትንቴዛይኔ ታንካ አላማይስ ሶትንቴዝ ጬቅንታይ ታፕ ሃኮ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ይኬ፥ ዶካልንትን ዶካልንተካ አትን አብካ ማዶያ። ማድዛይ የሱስ ክርስቶሳር ኦሮꬅ መትꬂ ማቅꬂ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","Ꮊ ዎጋ ካልዛ ኡቢታይስኔ ጾስስ ዎያ ማቄዝ እስራኤለስ ሳሮትꬅኔ ማሮትꬂ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","ታኒ የሱሳስ ሾጭንቴዝ ታ አሻይል የዝ ቤታይ ታ የሱሳስ አይለ ማቄዛና ቤዝዛ ግሾ Ꮊይፕ ገደ ታና ኦንካ ዋይꬅፐ። ");
INSERT INTO mfxe_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","ታ እሹንꬆ፥ ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ ይንታር ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ጾስ ሸነር ክርስቶሳ የሱሳ ሀዋረ ማቄዝ ጳዉሎሳፕ፥ ኤፍሶነ የዝ ጌሽታይስኔ ክርስቶሳ የሱሳ አማንዝታይስ ጻፍንቴዝ ኪታ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ጾስ ኑ አዳይፐኔ ጎዳ የሱስ ክርስቶሳፕ ኣꬎ ኬሃትꬅኔ ሳሮትꬅ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ሳሎ የዝ አያና አንጆ ኡባይር ክርስቶሳ ባጋር ኑና አንጄዝ፥ ኑ ጎዳ የሱስ ክርስቶሳ አዳይ፥ ጾሳይ ጋላትንቶ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ኑኒ ኤ ቲና ገሸትꬃር ቦሮ ባዝታ ማቆዳይ ጋርክ ጾሲ አላመ መꬊንቶዳይፕ ቲና ክርስቶሳ ባጋር ፋ ሲቆር ኑና ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ጾሲ ፋ ሸናይድ ፋ ዶሴዛይ ጋርክ የሱስ ክርስቶሳ ባጋር ኑና ፋ ናእታ ኡዶዳይስ ቲናቲ ቆፒ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ጾሲ ፋ ሲቅዛ ናአይ ባጋር ኑስ ጨረ እንጌዝ ቦንችንቴዝ ኣꬎ ኬሃትꬃይ ጋላትንቶዳይ ጋርክ የያ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","ጾሳ ኣꬎ ኬሃትꬅ ዱረትꬃይ ጋርክ ክርስቶሳ ሱꬃር ዎዝንቲ ናጋራስ አቶትꬅ ኑ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ፋ ኣꬎ ኬሃትꬃ ኤጨትꬃራኔ ኤራትꬃር ጋንꬂ ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ጾሳይ ፋ ቆፒ ጋዴዛይ ጋርክ ክርስቶሳ ባጋር ኤ ሸነ ጹራ ኑ ኤሮዳይ ጋርክ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ዎደ ሄሎዳር ጾሲ ፖሎዳይስ ቆፔዝ ቆፋይ፥ ሳሎኔ ሳአ የዝ መትꬅ ኡባ ክርስቶሳፕ ኦሞ ኡዶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ኡባ ባዝ ፋ ሸነ ጋርክ ኦꬅዛ ጾሳይ፥ ቲናቲ ፋ ቆፒ ጋዴዛይ ጋርክ ክርስቶሳ ባጋር ኑኒ ኤ እርስታ ላቶዳይ ጋርክ ኑና ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","የይ ሀኔዛይ፥ ክርስቶሳል ኡፋይስ ጋዲ ናጎር ቲና ማቄዝ ኑኒ ጾስ ቦንቻ ጋላታር ቆንጭሶዳይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","ይንትካ ይ አቶትꬅ ዎንግለ፥ የይካ ቱማ ቃላ ስኤዝ ዎደ ክርስቶሳ አማኔዛ። ጾሳይ ይንትስ እንጎድ ጌዝ ጌሻ አያና ማታመ ይንታል ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","የይካ ጾስ ቦንቻይ ጋላትንቶዳይ ጋርክ ጾሳይ ፋ አሳ ዎዞድ ጋꬆ ጌሻ አያና ኑ ላቶድ ጋዳይስ ኑስ ሳꬅ ኡዲ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","የይ ግሾስ፥ ጎዳ የሱሳል ይንትስ የዝ አማናኔ ጌሽታይስ የዝ ይ ሲቃ ታ ስኢ ");
INSERT INTO mfxe_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ታ ዎሳይር ይንታን ቆፕታር ይ ግሾስ ጾሳ ጋላትዛና አሸካያ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ኑ ጎዳ የሱስ ክርስቶሳ ጾሳ፥ ቦንቾ ኣዳ ይ ኣꬂ ኤሮዳይ ጋርክ ኤጨትꬅኔ ቆንጭꬅ አያና ይንትስ እማዳይ ጋርክ ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ጾሳይ ይንታን ጼጌዝ ኡፋይሳይኔ ጌሽታይ ላትዛ ቦንቾ ላታይ አብ ጋርክ ጋሜዛኮ ይ ኤሮዳይስ ጾሳይ ይ ዎዝና አፋ ዶዮድ ጋርክ ታኒ ጾሳ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ማ ኤዛ አማንዛ ኑር ኦꬅዛ ኤ ዎልቃይ አብ ጋርክ ኣꬎ ዳማዛኮ ይ ኤሮዳይ ጋርክ ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ክርስቶሳ Ꮊይቆፕ ደንꬂ፥ ሳሎ ፋ ኡሻች ባጋር በትꬄዝ ክርስቶሳር ኦꬄዝ ግታ ዎልቃ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","ኤ ሱንꬃይ፥ አቅስዝታይፐነ ማዉተር የዝታይፕ፥ ሞድዝታይፐኔ ጎድታይፕ፥ ኣꬅ ማቂ Ꮊ አላማይል ኣዳ ባዝን ቲናፕ የኦድ አላማይዳካ ሀራ ሱንꬅ ኡቢታይፕ ኣꬎ ቦንቾ ሱንꬅ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ጾሳይ ኡባ ባዝ ክርስቶሳ ቶኬ ኦሞ ሃርሴዛ፤ ማ ዎሳ ኬꬅስ ኡባ ባዛር ኩስተ ማቃዳይ ጋርክ ኤዛ ሹሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ዎሳ ኬꬃይ ክርስቶሳስ አሰትꬂ። እዛካ ክርስቶሳ ኡባባዛር ኩንꬅዝ ኤስ እዛ ኤ ኩንꬃቶ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Ꮊይፕ ቲና ይ፥ ይ ናጋራይራኔ ይ ቆሀይር Ꮊይቄዝታ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","የ ዎደ ይ Ꮊ አላማይ ኢታ ኦጋ ካሌዛ። ጫርኮል አፋ የዝ ዎልቂታይ ሀላቃይስኔ Ꮊተካ ጾሳይስ አዛዝንቶዋ ናእታይር ኦꬅዝ አያናስ ይ አዛዝንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ኑ ኡባይካ ቲና የ አስታይ ጋንጨ ኑ አሾ አሞኔ ኑ ዎዝና ሸነ ካሊ የዜዛ። ኑንካ Ꮊንክታይ ጋርክ ኑ መትꬃር ፕርዳ ኤኮዳይስ የዜዝታ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ዝን ጾሳ ግታ ማሮትꬃይፐኔ ኑስ የዝ ኤ ግታ ሲቃይፕ ደንዴዛይድ፥ ");
INSERT INTO mfxe_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ሀራ አቶዝን ኑኒ ኑ ቆሆፕ ደንዴዛይድ Ꮊይቂ የዝን ክርስቶሳ ባጋር ኑስ ደኦ እንጌዛ። ጾስ ኣꬎ ኬሃትꬃይር ይንትካ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ጾሲ ኑና ክርስቶሳ የሱሳር ፐትፕ Ꮊይቆፕ ደንꬂ ሳሎ ኤዛር ዎላ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ኤ የያ ኦꬄዛይ፥ ክርስቶሳ የሱሳ ባጋር ኑስ ቆንጭሴዝ ፋ ኬሄትꬅኔ ዛዋ ባ ፋ ኣꬎ ኬሄትꬅ ዱረትꬃ የኦድ ላይꬅታይድ ኑና ቤሳዳይስ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","ይ ፓጼዛይ አማኖ ባጋር ኤ ኣꬎ ኬሃትꬃይራ። የይካ፥ ጾስ እሞታፕ አትን ይ ኦሶር በንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ኦንካ ጬቅንታማይ ጋርክ ፓጾትꬅ ኣꬎ ኬሃትꬃይ በንቴዛይ አስ ኦሶር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ጾሲ ኑስ ቲናቲ ጊግሲ ጋዴዝ ሎኦ ኦስታ ኦꬆዳይ ጋርከኔ ኤዛይር የሳዳይስ ክርስቶስ የሱሳ ባጋር ማቂ መꬍንቴዝ ጾስ መትꬅታ፤ ");
INSERT INTO mfxe_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","የይ ግሾስ፥ ይንታኖ ስሳ ይ የልንቶ አይሁደ ባዝታዮ፥ አይሁድታይ ፋና አስ ኩሸር ዶካልንቴዝታ ግ ጋይርታር፥ ይንታን ማ ዶካልንተካዝታ ግ ቦርዛና አካኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","የ ዎደ ይ ክርስቶሳፕ ሻክንቲ የዜዛና፥ እስሬለ አሳይስ አላጋ ማቂ የዜዛና፥ ጾስ ቃላ ጫቃይስ ሃኪ የዜዛኔ Ꮊ አላመል ኡፋይስኔ ጾሲ ባይꬅ የዜዛና አካኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ዝን ይ ቲና ሃኪ የዜዝታይ፥ Ꮊት ክርስቶሳ የሱሳር የዝ ኤ ሱꬃይ ባጋር ጾስኮ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","ናምኤ ሻኪ ጋዴዝ ሞርከትꬅ ጋባራ ፋ አሻይር ላሊ አይሁደኔ አይሁደ ባ አሳ ትሚ ፐቶ ኡዴዛይ ክርስቶሳ ሳሮትꬃ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ኤ ፓር Ꮊ ናምኢ ዛርታይፕ ፐቲ ኦሮꬅ አስ መꬎዳይስ፥ ህገ አዛዛኔ ዎግታ ፐትፕ ፋ አሻይር ꬋብሲ ሳሮትꬅ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ክርስቶሳ ማዝቃለል አፋ Ꮊይቂ ሞርክንቶ ꬋብሴዛ፤ ማ ናምኢ ኮችታ ፐቲ አሾ ኡዲ ጾሳር እግንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ክርስቶሳ ይኢ፥ ጾሳፕ ሃኪ የዝ ይንትስ፥ ማ ኡኪ የዝ ኡንትስ ሳሮትꬅ ዎንግለ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","ኑ ኡባይ ኤ ባጋር ፐቲ አያናር አዳይ ቲና ሺቆዳይስ ዳንዳኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Ꮊይፐ ይ አላጋ ዎይ እማꬅታ ባያ፥ ዝን ይ Ꮊት ጌሽታይር ጋደ አስኔ ጾስስ ካራ አስታ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ይንቲ ሀዋርታይኔ ናብታይ ባሴዝ ባሳይል አፋ ኬጽንቴዛ። ኬꬃ ሙመር ቶኪ አይኬዝ ክርክሮ ጋርክ ሹቻይ ክርስቶሳ የሱሳ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ኤዛል ኬꬅ ኡባይ ፐትፕ አይክንቲ ጎዳይል ጌሻ ጾስ ካራ ማቆዳይስ ድጭዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","ይ ማ ጾሲ ፋ አያናር የዝዛ ኬꬅ ማቆዳይስ ክርስቶሳር ፐትፕ ኬጽንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","የይ ግሾስ፥ ታኒ፥ ጳዉሎሳ፥ አይሁደ ባ ማቄዝ ይ ግሾስ ክርስቶሳ የሱሳር አች አስ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ታ ይንታን ማዶዳይ ጋርክ ጾሲ ፋ ኣꬎ ኬሃትꬃይር ታስ እንጌዝ Ꮊ ኦሳይ ባጋ ይ ሎእꬂ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","ታ ይንትስ ቲና ሃታር ጻፌዛይ ጋርክ ጾሲ ፋ ጹራ ቆንጭꬃር ታስ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ታ ጻፌዛና ይ ናባብዛ ዎደ ክርስቶሳ ጹራ ታ አብ ጋርክ ኤሬዛኮ ይ አካኮዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Ꮊ ጹራይ ጌሻ ሀዋርታይስኔ ናብታይስ Ꮊት አያና ባጋር ቆንጭሴዛይ ጋርክ ብኒ ዎደ አሳይስ Ꮊይ ጋርክ ቆንጭሰካያ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Ꮊ ጹራይ ቤዝዛይ፦ አይሁደ ማቀካ አሳይ ዎንግለ ባጋር እስራኤልታይራ ፐትፕ ጾስ እርስተ ላትዛ። እስራኤልታይር ፐቲ አሰትꬅ ማቅዛ፤ ክርስቶሳ የሱሳ ባጋር ጾስ ኡፋይስ ቃላ ኤክዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","ጾሲ ፋ ኦꬅዛ ዎልቃይ ባጋር ታስ እንጌዝ ኣꬎ ኬሄትꬃይድ ታ Ꮊ ዎንግላይስ ኦሳንቾ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ታኒ ጌሽታይ ኡባይፕ ላፋ ማቅኮካ አይሁደ ማቀካ አሳይስ ዛዋ ባ ክርስቶሳ ዱረትꬅ ዎንግለ ኦዶዳይ ጋርክ Ꮊ ኣꬎ ኬሃትꬃይ ታስ እንግቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ማ ብኒ ዎደ ኡባ መꬌዝ ጾሳር ቆስንቲ የዝ ጹራይስ፥ ጾሳ ቆፋይ አብዛኮ ኡባይስ ቆንጭሶዳይስ ኣꬎ ኬሃትꬃይ ታስ እንግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ጾሲ የያ ኦꬄዛይ Ꮊተ ዎደ ዎሳ ኬꬃይ ባጋር ሳሎ የዝ ሀላቅታይስኔ ማዉተር የዝታይስ ፋ ዱማ ዱማ ኤጨትꬃ ኤርሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ጾሲ ፋ መꬍና ቆፋ ኑ ጎዳ ክርስቶሳ የሱሳ ባጋር ፖሎዳይስ የያ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ኑ አማኖር ያሻ ባይꬅ ጾስኮ ሺቆዳይ ጋርክ ክርስቶሳ ኑስ ምኖተꬅኔ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ታኒ ይ ባጋ ኤክዛ መታይ ይንትስ ቦንቾ። የይ ግሾስ ይ ታን መትንትዛና ብኢ ኡፋይስ ጋቻማይ ጋርክ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ታኒ ጾስ አዳይ ቲና ቡንቂንቲ ዎስዛይ የይ ግሾስ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ሳሎኔ ሳአ የዝ መትꬅ ኡባይስ ሱንꬂ ጾሳፕ እንግንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ጾሲ ፋ ቦንቾ ዱረትꬃይፕ ይ ጋንጨ አሰትꬃ ምንꬅዛ ዎልቃ ፋ አያና ባጋር እንጎድ ጋርክ ይንትስ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ማካ አማኖር ክርስቶሳ ይ ዎዝናይድ የሳዳይ ጋርከኔ ይ ሲቆር ጻጶ ዳኪ ሚንጊ የዞዳይ ጋርክ ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","የይ ጋርከካ፥ ክርስቶሳ ሲቃይ ዋፋ ጋርክ ዳልጌዛኮ፥ አዱስዛኮ፥ ꬎቃዛኮኔ ጪሞዛኮ ጌሽታይ ኡባይራ ኤርዛ ዎልቃ ይ አካኮዳይ ጋርክ ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","ኤራትꬃፕ ኣꬊዝ ክርስቶሳ ሲቆ ይ ኤሮዳይ ጋርክ እንግዛ ጾሳፕ ማቄዝ ኩንꬃትꬃይር ይ ኩሞድ ጋርክ ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ይኬ፥ ኑ ጋንጨ ኦꬅዛ ፋ ዎልቃይ ባጋር ኑኒ ዎስዛይፕ ዎይ ቆፕዛይፕ ኣꬂ ኦꬆዳይስ ዳንዳእዛ ጾሳይስ፥ ");
INSERT INTO mfxe_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ዎሳ ኬꬃኔ ክርስቶሳ የሱሳ ባጋር ጾስስ መትꬅ ኡባይፕ ዎደ ኡባይድ መꬊናፕ መꬍና ሄሎዳይስ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ይኬ፥ ጎዳይ ግሾስ አጭንቴዝ ታኒ፥ ይ ጼግንቴዝ ጼግንትꬃይድ ቤዝዛ የስ የዞዳይ ጋርክ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ይ ኡባ ዎደ አዳኔ ሃዮ ማቆይታ፤ ፐታይ ፐታ ዳንዳኦይታኔ ሲቆር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ሳሮትꬃር አጭንቲ አያና ፐትፐተꬃ ናጎዳይስ ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","ጾሲ ይንታን ጼጌዝ ዎደ ፐቲ ኡፋይሳስ ጼጌዛይ ጋርክ ፐቲ አሰትꬅኔ ፐቲ አያና የዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ፐቲ ጎዳ፥ ፐቲ አማኖኔ ፐቲ ጽንቃተ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ኡባፕ አꬃይ፥ ኡባይር ኦꬅዛይኔ ኡባይ ጋንጨ የዝዝ ፐቲ ጾስ፥ ኡባይስ አደ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ዝን ክርስቶሳ እንጎዳይስ ኮዬዝ እሞታይ ጋርክ ኑ ፐታይስ ፐታይስ ኣꬎ ኬሃትꬂ እንግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","የይ ግሾስ፥ ጾስ ቃላይ፥ «ኤ ኡዴ ከዜዝ ዎደ ድኢ ጋምታ ፓር ኤኪ ቅቴዛ፤ አሳይስካ እሞትታ እንጌዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","የዝን፥ «ኡዴ ከዜዝ» ጉሳይ ኤ ቲና ሱለ፥ ሳአ ዝቃ አቆ ዎꬌዛ ጉስ ማቃም እጽኮ አብ ጉሶ? ");
INSERT INTO mfxe_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Ꮊ ሱለ ዎꬌዛይ፥ ኡባ ኩንꬆዳይስ ኡባፕ ꬎቃ ሳሎ ከዜዛይ ኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ኤ ፐትታ ፐትታ ሀዋረ፥ ፐትታ ፐትታ ናበ፥ ፐትታ ፐትታ ዎንግለ ሳባክታ፥ ፐትታ ፐትታ ዎሳ ካራ አቅስዝታኔ አስታማርታ ማቃዳይ ጋርክ እሞታ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ኤ የያ ኡዴዛይ ክርስቶሳስ አሰትꬅ ማቄዝ ዎሳ ኬꬃ ድቾዳይስኔ አማንዛ አሳ ጾስ ኦሶስ ጊግሶዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","የይ ጋርከካ፥ ኑ ኡባይ ጾስ ናአ ኤሪ አማኖር በንትዝ ፐትፐተꬅኮ ሄሊ፥ ክርስቶሳ አያና ደኦ ኩንꬄትꬅይኮ ሄሊ ፎሎ አስ ማቂ ድጮዳይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ይከፕ ጉየ፥ አሳይ ዶሻ ገነር ማቄዝ ባልꬅዛ ዎርዶ ትምርተ ጫርኮራኔ አባ ጎተራ ገደኔ Ꮊና ኩሎ ካእዛ ዱድታይ ጋርክ ማቆዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ዝን ኑኒ ቱማና ሲቆር ኦድታር ኡባ ባዛር አሰትꬅስ ኩስተ ማቄዝ ክርስቶሳኮ ድጮዳ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ኩንꬅ አሰትꬃይ ክርስቶሳር አይክንትዛ ማ ዱማ ዱማ አሰትꬅ ብልትታይ ፐታይ ፐታይር አይክንቲ በቴዛ። ፐቲ ፐቲ አሰትꬅ ክፍላይ ፋ ኦሶ ኦꬆዳር ኩንꬅ አሰትꬃይ ሲቆር ሚንጎዳይ ጋርክ አሰትꬃ ድችዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Ꮊይፕ ገደ ካሃ ꬋብን ጨረ ቆፋር አማኖዋ አስ ጋርክ የዝፓተ፥ ታኒ Ꮊያ ይንትስ ጎዳይ ሱንꬃይር ኦድዛኔ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ኡ ቆፋይ ꬉሜዛ፤ ኡ ፋ ዎዝና ሙምሴዛ። ኡንቲ ኤረትꬅ ꬋቦራኔ እጾራ ጾሲ እንግዛ ደአይፕ ሃኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ኡንቲ ዬላ ግዝባዝ ኤሮዋ፤ ኡንቲ ቱና ኦሶ ኡባ ፖሎዳይስ ዥምባሮስኔ አሾ አሞስ ፋና ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ዝን ይ ክርስቶሳ ባጋ ታማሬዛይ የይ ጋርክ ኦገር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ኤ ባዝ ቱማ ስኤዛ። ማ የሱሳር የዝ ቱማ ይ ኤፕ ታማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ይ ቲና የዜዝ ኦጋ አሾይታ። ማ ዶሺ አሞር ꬋብስዛ ይ ጭማ አꬃ ቃሪ ኦሎይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ይ ዎዝና ቆፋይር ኦሮጾይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ቱማ ጽሎትꬃራኔ ጌሸትꬃር ጾስ ኣዝሶር መꬍንቴዝ ኦሮꬅ አሰትꬃ ማኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ይክ፥ ዎርዶ ኦድንትፓተ። ኑኒ ኡባይ ክርስቶሳ አሰትꬅ ብልትታ ማቄዝ ግሾስ አስ ኡባይራ ቱሮ ኦድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ጋይልንቶይታ ዝን ይ ጋይላይር ናጋራ ኦꬅፓተ። ይ ጋይልንቲ የዝን አዋ ይንታል ገልፐ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ዳቡሎሳስ ኦገ ዶይፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ካስትዛ አꬃይ ይከፕ ጉየ ካስትፐ። ዝን ማንቅታ ማድዛ ባዝ ኤስ የዞዳይ ጋርክ ፋ ኩሸር ሎኦ ባዝ ኦꬆ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ይ ዶናይፕ ኢታ ቃላ ከዝፐ። ዝን ስእዝታይስ ማዶዳይ ጋርከኔ Ꮊንክታ ምንꬃꬆስ ኮሽዛ ሎኦ ቃላ ይ ዶናይፕ ከዞ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ጾሲ ይንታን ዎዜዛና ኤርሶዳይስ የ ጋላስስ ይንታናል አታሚ ጋዴዝ ጾስ አያና አዛንꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ጫንግንቶ፥ ይሎ፥ ካቺ፥ ኡፎ፥ ጫሸኔ ኢታትꬅ ኡባ ይንትፕ ሃክꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","አꬂ ዎልስ ኬሃኔ ቃꬊንትዝታ ማቆይታ። ጾስ ክርስቶሳ ባጋር ይንትስ አቶ ጌዛይ ጋርክ ይንትካ ዎልስ አቶ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ይኬ፥ ጾሲ ዶስዛ ናእታይ ጋርክ ኤዛ ኣዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ክርስቶሳ ኑና ዶሲ ፋና ኑ ግሾስ ጾስስ ቶንክ ግ ሳዉዛ እሞኔ ያርሾ ኡዲ እንጌዛይ ጋርክ ይንትካ ሲቆር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ዝን ላሞ፥ ቱናትꬅኔ ኡዘትꬂ አማንዛ አሳይስ ቤዞዋ ግሾስ ይ ጋንጨ ኡባራካ ስእንትፐ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ጾስ ጋላቶይታፐ አትን ዬላꬅዛ ባዝ ቦዞትꬅ ናሻ ዎይ አርኤ ይንትስ ቤዞዋዛይ ግሾስ ይ ጋንጨ ኡባራካ የዝፐ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ꮊያ ኤሮይታ፤ ኦንካ ላመ ዎይ ቱና ባዝ ኦꬆ ዎይ ኡዛቶ ኤቃስ ጎይኖስ ተንተቶ ክርስቶሳ ካተትꬅኔ ጾስ ካተትꬃ ላቶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Ꮊይትታይፕ ደንዴዛይድ ጾስ ካቺ አዛዝንቶዋ አሳይል አፋ የኦድ ግሾስ ኦንካ ይንታን ፓꬆዋ ኦዳር ዶሽፐ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","የይ ጋርክ አሳይር ፐትፐተꬂ ኦꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ብኒ ይ ꬉማ፥ ዝን Ꮊት ጎዳይ ባጋይር ፖኦ። ይኬ፥ ፖኦ አስ ጋርክ ፖኦር የꬎይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ፖኦ ሎኦትꬅ፥ ጽሎትꬅኔ ቱማትꬅ ኣፍዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ጎዳ ኡፋይስዝ ባዝ ኦꬆዳይስ ኮዮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ኣፈ ባ ꬉማ ኦሶ ቆንጭሶይታፕ አትን ኤዛር ማቅንትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ኡንቲ ጌማ ኦꬅዛ ኦሳይ ሀራ አቶዝን ኦዶዳይስካ ዬላꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ዝን ኡባ ባዝ ፖኦል ከዜዝ ዎደ ቆንጨር በንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","ፖኦ ኡባ ባዝ ቆንጨር ቤዝዛ። የይ ግሾስ፥ «ናት ገንትዛዮ ባርኮባ፤ Ꮊይቆፕ ደንዶባ፤ ክርስቶሳ ኔስ ፖእዛ» ዬግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ይኬ፥ ይ ዋይዚ የዝዛኮ አካኪ ቦኦይታ። ኤጭታ ማቆይታፕ አትን ቦዝታ ማቅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ጋላስታይ ኢታ ማቄዝ ግሾስ ላይꬃ ዎዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","የይ ግሾስ፥ ጎዳይ ሸናይ አብዛኮ አካኮይታፕ አትን ቦዝፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ጌሻ አያናር ኩሞይታፕ አትን ꬋቦኮ ይንታን ካልꬅዝ ዎይነ ኡሻር ማꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ማዝሙረር፥ ሳባራኔ አያና የꬃር፥ ፐታይ ፐታይር ኦድንቶይታ። ማ ይ ዎዛናይር ማዝሙርታራነ ሳቢታር ጎዳ ጋላቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ኑ ጎዳ የሱስ ክርስቶሳ ሱንꬃይር ኡባ ዎደ ጾስ ኣዳ ኡባባዝስ ጋላቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ክርስቶሳ ቦንቾስ ግ ፐታይ ፐታይስ ሃርንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ማችታዮ፥ ጎዳይስ ሃርንትዛይ ጋርክ ይ አዝንታይስካ ሃርንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ክርስቶሳ ዎሳ ኬꬅስ ኩስተ ማቄዛይ ጋርክ አዝናይካ ፋ ማችስ ኩስተ። ማ ክርስቶሳ ፋ አሰትꬅ ማቄዝ ዎሳ ኬꬅ አሽዛያ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ዝን ዎሳ ኬꬃይ ክርስቶሳስ ሃርንትዛይ ጋርክ ማችታይ ፋ አዝንታይስ ኡባ ባዛር ሃርንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","አዝንታዮ፥ ክርስቶሳ ዎሳ ኬꬅ ዶሲ እ ግሾስ ፋና እንጌዛይ ጋርክ ይንትካ ይ ማችታ ዶሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ኤ የያ ኦꬄዛይ ዎሳ ኬꬅ ጌሾዳይስ ኮዪ ኡዴዛ፥ ጌሼዛይካ ፋ ቃላይ ባጋር ሃꬃር ሜጪ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ክርስቶሳ ዎሳ ኬꬅ ቅታ ዎይ ስኖ ቱክꬅ ዎይ የይ ጋርከዝ ባዝ ባይꬅ ኤ ኩንꬅ ቦንቾር ጌሽኔ ቦርንቶዛኖ ኡዲ ፋኮ ሺሾዳይስ ኮዪ የያ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","የይ ጋርከካ፥ አዝንታይ ፋና ዶስዛይ ጋርክ ፋ ማችታ ዶሶዳይስ ቤዝዛ። ፋ ማቻት ዶስዛይ ፋና ዶስዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ፋና እጽዛ አስ ኦንካ ባያ፥ ዝን ክርስቶሳ ዎሳ ኬꬅስ ኦꬅዛይ ጋርክ ፋ አሰትꬃ ሙዝዛኔ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ኑኒ ክርስቶሳ አሰትꬅ ብልትታ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","ጾስ ቃላይ፥ «የይ ግሾስ፥ አሲ ፋ አዳኔ ፋ እንዳቶ አሺ፥ ፋ ማቻትር ዎላ የሳዳ፤ ኡንቲ ናምእታይካ ፐቲ አሾ ማቅዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Ꮊይ ግታ ጹራ፥ ዝን ታኒ የያ ክርስቶሳ ባጋኔ ዎሳ ኬꬅባጋ ኣዝሶ ኡዲ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","የይ ጋርከካ፥ ይ ፐታይ ፐታይ ፋ ማቻት፥ ፋና ዶስዛይ ጋርክ ዶሶ። ማቻካ ፋ አዝና ቦንቾዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ናእታዮ፥ ጎዳይ ግሾ ግ ይንታን የሌዝታይስ አዛዝንቶይታ። የይ ይንትስ ቤዝዛ ባዚ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«ነ አዳኔ ነ እንዳቶ ቦንቾባ።» የይ ኡፋይሳ ቃላ የዝ ቲና አዛዞ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","«ነ የያ ፖልዛባዝ ማቅኮ ኡባይ ኔስ ሀኖዳ፤ ነ ላይꬃይካ ሳአል አፋ አዱቆዳ።» ");
INSERT INTO mfxe_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","የሌዝታዮ፥ ይ ናእታ ጎዳይ ቃላር ታማርሶራኔ ኡንታን ካልꬆር ድቾይታፕ አትን ኡንታን ይሎꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","አይልታዮ፥ ክርስቶሳስ አዛዝንትዛይ ጋርክ አሾ ጎድታይስ ያሻራ፥ ቦንቾራኔ ሉለ ዎዝናር አዛዝንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","ክርስቶሳ አይለ ጋርክ ጾስ ሸነ ዎዝናፕ ፖሎይታፕ አትን ጋላታ ደንጎዳይስ ኡ ቲና ኣዳ ኦꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","አስስ ባዝን ጎዳይስ ኦꬅዛይ ጋርክ ይ ኩንꬅ ዎዝናይፕ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","አይለ ማቅን ጎድ ማቅን ፐታይ ፐታይ ፋ ኦꬅዝ ሎኦ ኦꬃይስ ጎዳይፕ ዎይቶ ኤኮዳና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ጎድታዮ፥ አስ ኣፈ ዞቆ ብኢ ፕርዶዋ ይንትስኔ ኡንትስ ጎዳይ፥ ሳሎ የዛና ይ ኤርዛ። የይ ግሾስ፥ ይ አይልታ ማንድዛ አሺ ኡንቲ ይንትስ ኪትንትዛይ ጋርክ ይ ኡንትስ ሎኦ ባዝ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ይከ Ꮊይፐ፥ ጎዳይራኔ ኤ ዳማ ዎልቃይር ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ዳቡሎሳ ዶሻ ኤቅንቶዳይስ ዳንዳኦድ ጋርክ ጾሲ ይንትስ እንጌዝ ኦላ ሚሸ ኡባ ዳንጮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ኑ ኦላይ አሳር ባዝን ሳሎ የዝ ቱና አያንታይር ኦልዝታይራ፥ ማዉተ አድታይር፥ ሃርዝታይራኔ Ꮊ ꬉማ አላመ ዎልቅታይራ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","የይ ግሾስ፥ ኢታ ጋላስ ሞርከ ተቆዳይስኔ ኡባ ፖሊ፥ ሚንጊ ኤቂንቶዳይስ ይ ዳንዳኦዳይ ጋርክ ጾስ ኦላ ሚሽታ ኡባ ዳንጮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","ቱማ፥ ጼሳል ዝናረ ጋርክ ዳንጪ፥ ጽሎትꬅ ጹሩረ ጋርክ ትራል ጋዲ፥ ");
INSERT INTO mfxe_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ሳሮትꬅ ዎንግለ ይ ቶኬ ጫማ ጋርክ ኣꬂ ሚንጊ ኤቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","የ ኡባይፕ ኣꬂ፥ ጻላሄ ዳክዝ ላጽዝ ታማ ዶንገ ኡባ ቶእሶዳይስ ዳንዳእዛ አማኖ ኡባ ዎደ ጎንዳለ ጋርክ አይኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ጾስ አቶትꬃና ብራታ ባርኔጻ ጋርክ ይ ኦማይል ጋዶይታ፤ ማ ጌሻ አያና ማሻ፥ የይካ ጾስ ቃላ አይኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ዎሳ አሽፓተ፤ Ꮊንክታይስካ ጉሮይታ፤ ኡባ ዎደ አያናር ዎሶይታ። ኤዛይድ፥ ጌሽታይስ አዛለካዛር ሚንጊ ኡባ ዎደ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ታኒ ዎንግለ ጹራ ያሻ ባይꬅ ቆንጭሲ ኦዶዳይ ጋርክ ጾሲ ታስ ቃላ እንጎድ ጋርክ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ታኒ የያ ኦꬆዳይስ ኪትዛይኔ Ꮊተካ አቻ የዛይ የ ዎንግላይ ግሾስ። የይ ግሾስ፥ ታኒ ያሻ ባይꬅ ቤዝዛይ ጋርክ ኦዶዳይ ጋርክ ታስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ታኒ ዋይዚ የዛኮኔ አብ ኦꬅዛኮ ይ ኤሮድ ጋርክ ኑ ሲቆ እሻይ፥ ጎዳይ ኦሶር አማንንቴዝ ኦሳንቻይ፥ ትክቆሳ፥ ታ ባዝ ኡባ ይንትስ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ኑኒ ኡባይ ዋይዚ የዛኮ ይንትስ ኦዶዳይ ጋርከኔ ይ ዎዛና ምንꬃꬆድ ጋርክ ታኒ ኤዛ ይንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ጾስ አዳይፕ፥ ጎዳ የሱስ ክርስቶሳፕ ሳሮትꬅኔ ሲቆ አማኖር ዎላ ኑ እሽታይ ኡቢታይስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","እርጾዋ ሲቆር ኑ ጎዳ የሱስ ክርስቶሳ ዶስዛ ኡባይራ ጾስ ኣꬎ ኬሃትꬃይ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","ክርስቶስ የሱሳስ ማቄዝ፥ ፍልጲሶሳ ካታማ የዝ ዎሳ ኬꬅ ጭምታይስ ዳቆንታይስኔ የሱስ ክርስቶሳር የዝ ጌሽታይስ ኡባይስ የሱስ ክርስቶሳ አይለ ማቄዝ፥ ጳዉሎሳፐኔ ጽማቶሳፕ ኪትንቴዝ ኪታ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ኑ አዳ ኑ ጾሳይፐኔ ጎዳ የሱስ ክርስቶሳፕ ኣꬎ ኬሄትꬅኔ ሳሮትꬅ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","ታኒ ይንታን ቆፕዛ ዎደ ኡባይድ፥ ታ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","ታኒ ይ ኡባይስ ጾሳ ዎስታር ኡፋይሳር ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ይ ብንፕ Ꮊይኖ ሄሎዳይስ፥ ዎንግለ ማርካትታር ታር ዎላ ማቂ፥ ታና ማዴዝ ግሾ ታ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ይንታር ሎኦ ኦሶ አይኬዝ ጾሳይ፥ የሱስ ክርስቶሳ ማቅዝ ጋላሳይ ሄሎዳይስ፥ ፖሎዳና ታ ሎእꬅ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ታኒ አቻ ገሎዳይፕ ቲናኔ Ꮊት አቻ የዝንካ ዎንግለ ናጎራኔ ዎንግለ ሚንꬂ አይꬃር ጾሳይ ታስ እንጌዝ ኣꬎ ኬሄትꬃ ይንትካ ታር ሻግንቴዛ። ይ ኡባ ዎደ ታ ዎዝና ጋንጨ የዛ። ታኒ ይንትስ ኡባ ዎደካ ሎኦ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","ታ ይንታን ኡብታ የሱስ ክርስቶሳ ሲቃይር አብ ጋርክ ላሞትዛኮ ጾሳይ ታስ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ይ ሲቃይ ቱማ ኤረትꬃራኔ አካካር ጉጂ ጉጂ ድጮድ ጋርክ ታ ጾሳ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","የይካ ይ ሎኦ ባዝ ሻኪ ኤሪ ክርስቶሳ ማቂ የኦዳር ጌሽታኔ ቦርንቶዝታ ማቃዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ይ የሳይ የሱስ ክርስቶሳ ባጋር በንትዝ ጽሎትꬅ ኣፈር ኩሚ ጾስ ቦንቾኔ ጋላታ ክእዝታ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","ታ እሹንꬆ፥ ታና ሄሌዝ ባዛይ ዎንግለ ዳልጎድ ጋርክ ቱማ ማዴዛና ይ ኤሮዳይ ጋርክ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ታኒ ክርስቶሳስ ኦꬅዝ ግሾ አጭንቴዛና፥ ካት ካራ ናግዝታይኔ Ꮊንክታይ ኡቢታይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ታ አቻይ ባጋር ኑ እሽታይፕ ጋምታይ ጎዳይል ሎእꬂ አማንንቴዛ። የይ ግሾ፥ ጾሳ ቃላ ያሻ ባይꬅ ቲናሳይፕ ኣꬂ ሚንጊ ኦዶድ ጋርክ ኡ ምኖትꬅ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ማቆዝን፥ ፐታይ ፐታይ ቅናተራኔ ፓላማር ክርስቶሳ ባዝ ኦድዛ፥ ዝን Ꮊንክታይ ሉለ ዎዝናፕ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ሉለ ዎዝናፕ ኦድዝታይ፥ ጾሳይ ታስ ዎንግለ ናጎ ኦሶ እንጌዛና ኤርዛ ግሾ ሲቆር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ዝን የይትታይ ክርስቶሳ ባጋ ዎብꬅ ሳባክዝታይ ታ አቻይል አፋ ሀራ መቶ ኮኦዳይስ ፋና ዶሲ ክርስቶሳ ባዝ ኦድዛፕ አትን ቱማ ዎዝናፕ ኦዶያ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","የ ኡባይድ ታና ኡፋይስዛ። ቱማ ዎዝናር ማቅን ዎይ ዎርዶ ዎዝናር ማቅን የ ኡባይር ክርስቶሳ ሳባክንትዛይ የይ ታና ኡፋይስዛ። ማ ቲናስካ ታና ኡፋይስዛ ባዛይ፥ ");
INSERT INTO mfxe_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ታኒ ይ ዎሳራኔ የሱስ ክርስቶሳ አያና ማደር አቻፕ ከዞዳና ታ ኤርዛ ግሾስ ታና ኡፋይስዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ታ ግታ አሞትꬃራኔ ኡፋይሳር ታ ኦሶ ኡባይራ ታ ዬላታማና ናግዛ። ዝን ኡባ ዎደ ኦꬅዛይ ጋርክ፥ Ꮊተካ ታኒ ፓꬅ የዝን ዎይ Ꮊይቂን ያሽተካዛር ታ ኩንꬅ አሰትꬃይድ ክርስቶሳ ቦንችንቶዳ ግ ምኖትꬃር ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ታስ ደኦ ጉሳይ ክርስቶሳ ኣዳስ የሰ፤ ማ ታ Ꮊይቅኮካ ታስ ኡሳ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ዝን ታ ፓꬅ የዝኮ ኣፈር በንትዝ ኦሶ ኦꬆዳ። የያ ማቅኮካ ፓꬅ የዛይፐኔ Ꮊይቆፕ ኣያ ዶሮዳዛኮ ታስ ኤርንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ታኒ Ꮊ ናምእታይፕ ኣያ ዶሮዳዛኮ ታና ዋይꬄዛ። Ꮊ የሳይፕ ሻክንቲ ክርስቶሳር ዎላ የዞዳይስ ታ አሞትዛ፤ ክርስቶሳር ዎላ የዝዛይ ኡሳ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ሀራ ባጋር ታኒ ይ ግሾስ ፓꬅ የዝዛይ ይንትስ ኡሳ ሎኦ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ታኒ፥ ይ አማኖር ድጮድ ጋርከኔ ኡፋይቶድ ጋርክ ይንታር ፓꬅ የዝዛ። የያ ታኒ ሎእꬂ ኤርዛ ");
INSERT INTO mfxe_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","የይ ግሾስ፥ ታኒ ይንትኮ ማቂ የኦዳር ታ ባጋር ክርስቶሳ የሱሳር የዝ ይ የሳይድ ይ ጬቅንታይ ጋንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ኡባፕ ኣꬂ፥ ይ ክርስቶሳ ዎንግላይስ ቤዝዛ የስ የዞይታ። ታ ይ ይንታን ብእን በአም እጽን ይ ፐቲ ቆፋር ሚንጊ ኤቂ፥ ሀራ አሳይ ዎንግላ አማኖድ ጋርክ ፐቲ ዎዛና ማቂ ፐትፕ ዎላ ቡትትዛና ታ ስኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ይ ሞርክታይስ ያሽትፓተ። የይ ይ ምኖትꬃይ ኡንትካ ይንታር ኤቅንትዛባዝ ማቅኮ ይንትስ አቶትꬅስ ኡንትስ ꬋቦስ ጾሳፕ ማቄዝ ማላ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ክርስቶሳስ ኦꬅዝ አንጃይ ይንትስ እንግንቴዛይ፥ ይ ኤዛ አማኖድ ጋርክ ኣዳ ባዝን ይ ኤ ግሾ መቶ ኤኮድ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","የይ ግሾ፥ ይ ታ ዋያ ቲና በኤዛ፤ Ꮊተካ ታ መቶትዛና ይ ስእዛ። ይንትካ ታ መታይ ጋርክ መትንትዛ ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ክርስቶሳር ይንትስ ምኖትꬂ የዝኮ፤ ማ ኤ ሲቃይራካ ይ ምንꬃꬅንቴዝባዝ ማቅኮ፥ ጌሻ አያናር ይንትስ ፐትፐተꬂ የዝኮ፤ ይ ዎልስ ኬህኮኔ ቃꬊንትኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ይኬ ይ ፐቲ ቆፋር፥ ሲቆር፥ ፐቲ ዎዛናራኔ አያናር ፐቶ ማቂ ታና ፎሎ ኡፋይሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ይንታን ዶሶር ዎይ ጬቅንታር ፐትባዝካ ኦꬅፓተ። ዝን ይ ፐታይ ፐታይፕ ታ ኣꬍዛ ዬጊ ቆፐካዛር ይንታን ዝቂ ኡዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ይ ፐታይ ፐታይ፥ ሀራ አስ ማድዛ ባዝ ኮዮይታፕ አትን ይንታን ማድዛ ባዝ ኣዳ ኮይፓተ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ክርስቶስ የሱሳር የዝ ቆፋይ ይንታር የዞዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ኤዝስ ኡባ ዎደ ጾሳትꬅ ሃኖትꬂ የዛ። ማቆፕ አትን፥ ኤዛ ጾሳር ፐቶ ኡድዝ ጾሳትꬅ ሀኖታ፥ ዎልቃር ኤኮዳይስ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ማቆዝን፥ ኤ ፋስ የዛ ቦንቻ ኡባ አሺ፥ አይለ ጋርክ ማቂ አስ ኣዚ በንቴዛ፤ አስ ጋርክ የልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ኤ ፋና ላፍꬄዛ፤ Ꮊይቆድ ጋꬆ፥ ሀራ አቶዝን ማዝቃለል አፋ Ꮊይቆድ ሄሎዳይስ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","የይ ግሾ፥ ጾሳይ ኤዛ ኣꬂ ꬎቅ ꬎቅ ኡዴዛ፤ ማ ሱንꬅ ኡባፐካ ኣꬊዝ ꬎቀ ሱንꬅ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ሳሎኔ ሳአል፥ ሳአፕ ኦሞር የዝ ኡቢታይ፥ የሱሳ ሱንꬃይ ቦንቻይስ ቡንቂቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","አስ ኡባይ ፋ እራንꬃይር፥ የሱስ ክርስቶሳ ጎዳ ዬጊ ማርካቲ፥ ጾስ አዳይስ ቦንቾ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ታ እሹንꬆ፥ ታኒ ይንታር የዛ ዎደ ኡባይድ ይ ኪትንቴዛይ ጋርክ፥ Ꮊት ታኒ ይ ላንቃይፕ ሃክኮካ፥ ቲናሳይፕ ኣꬂ፥ ኪትንቶዳይስ ቤዝዛ። ጾሳይስ ያሻራኔ ኩኩርሳር ይ አቶትꬃ ቤዝዛ ኦሶ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ጾሳይ፥ ይ ሀኖድ ጋርክ ኤ ኮይዝ ባዝ ይ ኮዮዳይ ጋርከኔ ኦꬆዳይ ጋርክ ኡባ ዎደ ይ ጋንጨ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","አባ ኦሶ ኦꬅታራካ ዝግረካዛራኔ ፓላመካዛር ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ዡጫኔ ናጋራ ኦꬅዝ አስ ጋንጨ ቦርንቶዝታ፥ ቦርሶ ባዝታኔ ጌሻ ጾስ ናእታ ማቆይታ። ይ ኡ ጋንጨ ሳሎ ጾልንቶ ጋርክ ፖኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","የይካ ሀንዛይ ደኦ እንግዝ ቃላ ሚንꬅ አይክꬃራ። የ ዎደ ታ ዳቡርሳይ ታ ኦሳይ ጨረ አተካ ግሾስ ክርስቶሳ ይእዛ ጋላስ ታ ይንታል ጬቅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ሀኖ ዝን ይ ጾስስ አማኖር እንግዝ ያርሻይላኔ ኦሳይል አፋ ታካ ጉጅንቲ ያርሽንትዛኮ ታና ኡፋይስዛ። ይንትካ ታር ኡፋይቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","የይ ጋርክ ይንትካ ኡፋይቲ ታናካ ይንታር ኡፋይሶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ታኒ ይ የስ ባጋ ስኢ ኡፋይቶዳይስ ጽማቶሳ ይንትኮ ኤልሲ ዳኮዳይ ጎዳ የሱሳ ሸነ ማቆዳና ታ አማንዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ይንትስ ዎዝናፕ ቆፕዝ ኤ ጋርከ አስ ሀራ ኦንካ ታስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Ꮊንክታይ ፋና አድዛ ባዝ ኮዥዛፕ አትን የሱስ ክርስቶሳ ኮይዝ ባዝ ኦꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ኤ ታራ ዎላ ማቂ ናአ ፋ አደስ ኦꬅዛይ ጋርክ ዎንግለ ኦሶ ኦꬄዛኔ አማንንትዛ አስ ማቄዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","የይ ግሾ፥ ታባዚ አብ ሀኖዳዛኮ ብኢ ኤልሲ ኤዛ ይንትኮ ዳኮዳ ግ ታ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ታኒ፥ ታ ኡባስ ኡከር ይንትኮ Ꮊማዳና ጎዳይል አማንንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ኡባራካ፥ ታኒ፥ ታ እሻ ኤጳፍሮድቱሳ፥ ታር ዎላ ታ ባጋ ማቂ ኦꬄዛና፥ ዎታዳረ ማቄዛኔ፥ ታና ማዶዳይስ ይ አዛዜዛና፥ ይንትኮ ኪቶዳይስ ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ኤ ይንታን ኡብታ በአዳይስ ኢታ ላሞትዛ። ማ ኤ ሀርግንቴዛና ይ ስኤዝ ግሾስ ፋ ዎዝናር ሎእꬂ ኡንእንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ኤ ቱማ ሀርግንቲ Ꮊይቂ ዉሪ አቴዛ። ዝን ጾሳይ ኤዝስ ቃꬊንቴዛ። ኤ ኣዳስ ባዝን አዛናይ አዛኖል አፋ ጉዥንታም ጋርክ፥ ታስካ ቃꬊንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ይኬ፥ ይ ኤዛ ማሂ ብኢ ኡፋይቶድ ጋርክ ታስካ ታ ዎዛና ጹሳይ እርጾድ ጋርክ ታኒ ኤዛ ኤልሲ ይንትኮ ዳኮዳይስ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ጎዳ አማንዛ አስ ጋርክ ኤዛ ኩንꬅ ኡፋይሳር ሞኮይታ። ማ ኤ ጋርክ አስ ኡብታካ ቦንቾይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ይ ታ ላንቀ ማቂ ኦꬆዳይስ ዳንዳኦዋ ማዴ ማዲ ክርስቶሳ ኦሳይ ግሾስ ፋ ሸምፖስ ምጭንተካዛር Ꮊይቂ ዉሪ አቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ይከፕ ገደ፥ ታ እሹንꬆ፥ ይ ጎዳይል ኡፋይቶይታ። ታኒ ቲን ጻፌዛና ማሂ ጻፎዳይ ታና አዛልሶያ፥ ዝን ይንታን ቡታፕ ናጎዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ኢታ ባዝ ኦꬅዝ ካንታይፐኔ ዶካልንቶዳይስ ኮሽዛ ግዝ ኢታ አስታይፕ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ኑኒ ጾሳ ጌሻ አያናር ጎይንዝ ግሾኔ ኑ የሳይር ክርስቶስ የሱሳል ጬቅንትዛ ግሾስ ቱማ ዶካልንቶ ዶካልንቴዝታ። ኑኒ አፋር አሾ ጋላል አፋ ኦስንትዝባዛር ጬቅንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ታ አሾር ጬቅንቶዳይስ ኮሽኮ ታ ጋመባዛር ጬቅንቶዳይስ ዳንዳእዛ። አባ አስካ አሾር ጬቅንትዛባዝ ፓስ የዛ ግ ቆፕኮ፥ ታኒ ኤዛፕ ኣꬎ ኡባፕ ኣꬂ ጬቅንትዛባዝ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ታኒ የልንቴዝ ሆስፑንꬃ ቃማር ዶካልንቴዛ። ታኒ የልንቶር ትላ እስሬለ፤ ታኒ ቢናማ ኮቺ፤ ታኒ ዋላካ ባ እብራወ አሲ። አይሁደ ህገ ናጎር ማቅኮ ታኒ ፈርሳወ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","አይሁደ አማኖ ህገስ ቅናተር ማቅኮ ታኒ ዎሳ ኬꬅ ባይእዛያ። ፐቲ አሲ ህገ ናጊ ጽልዛባዝ ማቅኮ፥ ታል ቦሮ በንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ዝን ቲን ታና ማድዛ ግ ቆፔዝባዝ ኡባ፥ ክርስቶሳ ግሾስ ግ ማዶዋ ባዝ ኡዲ ታይቤዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","የይ ኣዳ ባዝን ታኒ ታ ጎዳ ክርስቶስ የሱሳ ኤርዛይ ሀራ ባዝ ኡባፕ ሎእꬂ ኣꬊዝ ግሾስ የ ኡባ ዎ ባባዝ ጋርክ ታይቤዛ። ታኒ ኤ ግሾስ ኡባ ባዝ ቆህንቴዛ። ክርስቶሳ ደንጎዳይስ ኡባ ባዝ አላ ዎꬌዝ ቡረ ጋርክ ታይቤዛ። ታኒ የሱሳር ፐቶ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ታኒ ህገ ናጊ ደንግዝ ታ ጽሎትꬃ አሺ ክርስቶሳ አማንን በንትዝ ጽሎትꬃይ፥ ጾስ ላንቀፕ ይእዝ ጽሎትꬃይ Ꮊት ታስ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","ታኒ ክርስቶሳኔ ኤ ደንዶ ዎልቃ ኤሮዳይስ ኮይዛ። ታኒ ኤ መታ ኤዛር ሻክንቶዳይስኔ ኤ Ꮊይቃይር ኤዛ ኣዞዳይስ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ኡባራካ፥ Ꮊይቆፕ ደንዲ መꬍናስ ደኦር የዞዳና ኡፋይስ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ታኒ Ꮊት ጋጻ ሄሌዛ ዎይ ታር ባላ ባያ ጎያ። ዝን ክርስቶስ የሱሳ ታና አይኬዝ ግሾስ ታኒ ታ ቲና የዝ ዎይታ አይኮዳይስ ዎጽዛኔ ቡትንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ታ እሹንꬆ፥ ታኒ የያ ሄሌዛ ግ ቆፖያ፥ ዝን ታኒ ፐትባዝ ኡዶዳ። ታፕ ጉየር የዛና ዶግታር ቲና የዛና አይኮዳይስ ዛቱርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","የይ ግሾስ፥ ታኒ ፎሎ ሄሎዳይስ ላስዛ። ጾሳይ ክርስቶስ የሱሳ ባጋር ሳሎ ጼጊ እማድ ዎይታይ ሳሎ ደኦ። ይን እዞ ኤኮዳይስ ዳቡርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ይኬ፥ ኑኒ አያናር ምንጌዝ ኡባይ የያ ቆፖዳይስ ቤዝዛ። ይንታፕ ባግታይስ ዱማትዛ ቆፋ የዛኮ፥ የያካ ጾሳይ ይንትስ ምልጽ ኡዲ ቤሳዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ማቅኮካ፥ ኑኒ Ꮊኖ ሄሎዳይስ ጾስስ ቤዝዛ የሳይር፥ አን ቲና ዎላ Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","ታ እሹንꬆ፥ ታና ኣዞይታ፤ የይ ጋርከካ፥ ኑ ኣዝሳ ካልዛ አስታ አካኪ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ታኒ Ꮊይፕ ቲና ማሂ ማሂ ኦዴዛ፥ ዝን Ꮊተካ ማሂ አፉꬃር ኦድዛ። ፋ የሳር ክርስቶሳ ማዝቃላይስ ፋና ሞርክታ ማሄዝ ጋመ አሳይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ኡ ዉርስꬃይ ꬋቦ፤ ኡ ኡላይ ኡንትስ ጾሰ። ዬላꬅዛ ባዝ ኡንትስ ቦንቾ፤ ማ ኡ Ꮊ ሳአባዝ ኣዳ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ኑ ጋዳይ ሳሎ የዛ። ሳሎፕ የኦድ ꬋለ ጎዳ የሱስ ክርስቶሳ ኑ ላሞꬃር ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ክርስቶሳ ኡባ ባዝ ፋ ዎልቃይፕ ኦሞ ኡዶዳይስ ዳንዳእዛ ፋ ዎልቃይር ካዉዤዝ ኑ አሻ ላሚ ፋ ቦንቾ አሾ ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ታ እሹንꬆ፥ ታ ቃꬍዙንꬆ፥ ታ ላሞትዙንꬆ፥ ታ ኡፋይስታይኔ ታ ኦሶ አክልሉንꬆ ይኬ ጎዳይል ሚንጊ ኤቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ኤዎዳራነ ስንጺካ፥ ይ ናምእታይ፥ ፐቲ ቆፋር ጎዳይ ባጋር ዎልስ ምሽታ ማቂ የዞድ ጋርክ ታኒ ይንታን ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ታር ኦꬅዝ አማንꬅዛዮ፥ ኔኒ Ꮊ ማችታ ማዶድ ጋርክ ታ ነና ዎስዛ። Ꮊ ማችታይ ታር፥ ቀለምንጾሳራ ኡ ሱንꬃይ ጾስ ደኦ ማጻፋይ ጋንጨ ጻፍንቴዝ ሀራ አሳይር ዎላ ዎንግለ ኡባ አቆ ሄልꬆዳይስ ዳቡሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ኡባ ዎደ ጎዳይር ኡፋይቶይታ። ታኒ የያ ጉጅካ ኦድዛ፤ ኡፋይቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","አስ ኡቢታይ ይ ሃዮትꬃ ኤሮ፤ ጎዳይ ኡከር የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ጾሳ ይ ዎስታር ኡባ ዎደ ኤዛ ጋላትታር፥ ይንታን ኮሽዛ ባዝ ኡባይስ ዎሶይታፕ አትን አባባዝስካ ህርግፓተ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","አስ ኤረትꬅ ኡባይፕ ኣꬊዝ ጾስ ሳሮትꬃይ፥ ይ ዎዛናኔ ይ ቆፋ ጎዳ የሱስ ክርስቶሳ ባጋር ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ዉርስꬃል፥ ታ እሹንꬆ፥ ይ ካሃይራ ሎኦ ባዝኔ ጋላትስዛባዝ ቆፖይታ። ቱማ ማቄዝባዝ ኡባ፥ ቦንቾ ማቄባዝ ኡባ፥ ቆሆ ማቆዋ ባዝ ኡባ፥ ጌሽ ባዝ ኡባ፥ ሲቆ ባዝ ኡባኔ ኡፋይስዛ ባዝ ኡባ ቆፖይታ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ይንቲ ታፕ ታማሬዝ ባዝ፥ ኤኬዝባዝ፥ ስኤዝባዝኔ በኤዝ ባዝ ኡባ ኦꬆይታ። ሳሮትꬅ እንግዝ ጾሳይ ይንታር ዎላ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ጋመ ዎደፕ ጉየ፥ ይ ታባዝ ማሂ ቆፕꬅ አይኬዝ ግሾስ ታኒ ጎዳይል ሎእꬂ ኡፋይትዛ። የያ ጉሳይ፥ ታስ ቆፖዳይስ ይንትስ ሀናም እጼዛይፕ አትን ታስ ቆፖያ ጉስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ታኒ የያ ግዛይ መቴዝ ግሾስ ጎያ፤ ታስ የዛ ባዝ ግዶድ ጉሳ ታ ታማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ታኒ መትንቲ የዝዛ የሳ ኤርዛ፤ ደሞካ ꬋቦካ ኤርዛ። አባ ማቅን ማ አባ ዎደካ ታኒ ምሽስ ናየስ፥ ፓጨስካ ኩንꬅስካ የዝ ጹራ ታ ታማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ዎልቃ እንግዝ ክርስቶሳር ኡባ ባዝ ታ ኦꬆዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ማቅኮካ፥ ይ ታ መቶ ታር ሻክንቴዛይድ ሎኦ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ፍልጲሶሳ አሳዮ፥ ዎንግለ ቲና ኦዶዳይስ ታኒ ማቃዶናፕ ከዝዝ ዎደ እሞር ማቅን ኤኮራካ ይ ዎሳ ኬꬃፕ አትን ሀራ ኦንካ ታና ማደካዛ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ተሰሎንቀ ታ የዛ ዎደካ ይ ታና ማቂ ማቂ ማዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ታኒ፥ ይንታፕ ይ እሞታ ኤኮዳይስ ኮዪ ባዝን እሞፕ ይእዝ አንጆ ይ ኤኮዳይ ጋርኬ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ታኒ፥ ይ እንጌዝ ኡባባዝታኔ ግዲ ፉጭዛባዝ ኤኬዛ። ይ ዳኬዝ ኡብታ ኤጳፍራድቱሳፕ ኤኬዛ፤ ኮሽዛ ባዝ ኡባይ ታስ የዛ። ይ ታስ ዳኬዝ እማይ ጾስስ ቶንክ ግዝ ሳዎ፥ ኤ ቃꬍዛ፥ ኤ ኡፋይትዛ ያርሾ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ታ ጾሳይ ፋ ቦንቾ ዱረትꬃይ ጋርክ፥ የሱስ ክርስቶሳ ባጋር ይንትስ ኮሽዛ ባዝ ኡባ እማዳ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ኑ አዳይስኔ ኑ ጾሳይስ መꬊናፕ መꬍና ሄሎዳይስ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","ክርስቶስ የሱሳ ባጋር ጾስ አማንዝታ ኡብታ ሳሮ ጎይታ። ታር የዝ እሽታይ ይንታን ሳሮ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ጾስ አማኔዝ አሳይ ኡባይ፥ ኡባፕ ኣꬂ ካት ቄሳረ ኬꬃ የዝታይ ይንታን ሳሮ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ ይንታር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ጾስ ሸነር ክርስቶሳ የሱሳ ሀዋረ ማቄዝ ጳዉሎሳፐኔ ኑ እሻ ጽማቶሳፕ፥ ");
INSERT INTO mfxe_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቆላስያሳ ካታማ የዝ ክርስቶሳስ አማንንቴዝ ጌሽታይስ ጻፌዝ ኪታ። ጾሳ ኑ አዳይ ኣꬎ ኬሃትꬃይኔ ሳሮትꬃይ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ኑኒ ይንትስ ዎስታር ጾሳ ኑ ጎዳ፥ የሱስ ክርስቶሳ ኣዳ ኡባ ዎደ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ኑኒ ክርስቶሳ የሱሳር የዝ ይ አማናኔ ጌሽታይስ ኡባይስ የዝ ይ ሲቃ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ይ ቱማ ኪታ ማቄዝ ዎንግለ ቲና አማኔዝ ዎደ የ ኡፋይሳ ስኤዛ። የያ ይ ኦꬄዛይ ይ ኡፋይሳይ ሳሎ ይንትስ ናግንቴዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ይ Ꮊ ዎንግላ ስኤዝ ዎደኔ ጾስ ኣꬎ ኬሃትꬅ ቱማትꬃ ሻኪ ኤሬዝ ዎደፕ አይኪ ይ ጋንጨ ሀኔዛይ ጋርክ ቢታ ኡባይድ ዳልግታራኔ ኣፍታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ይ የያ ኑር ዎላ ክርስቶሳስ ኦꬅዛ አማንንቴዛኔ፥ ዶስንቴዝ ኤጳፍራፕ ታማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ኤ የይል አፋ ጉጂ አያናይ ይንትስ እንጌዝ ሲቆር ይ ዎል ቃꬍዛና ኑስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","የይ ግሾስ፥ ኑኒ ይ ባዝ ስኤዝ ጋላሳይፕ አይኪ፥ ጾሳይ ፋ ሸና ይንታን ቤዞዳይ ጋርከ፥ ጌሻ አያናይ እንግዛ ኤራትꬅራኔ ኤጨትꬅ ኡባይር ይንታን ኩንꬆዳይ ጋርክ ኡባ ዎደ ይንትስ ጾስ ዎስዛና አሻሚ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","የይ ጋርከካ፥ ጎዳይ ኮይዛይ ጋርክ ይ የዞድ ጋርክ፥ ኡባ ዎደ ኤ ኡፋይቶዳይ ጋርክ፥ ሎኦ ኦሶ ኡባይድ ይ ኣፈ ኣፎድ ጋርከኔ ጾሰ ኣꬂ ኤርታር ድጮዳይ ጋርክ ጾሳ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","ጾሳይ ፋ ግታ ዎልቃይር ምኖትꬅ ኡባ ይንትስ እንጎ። ይ ዳንዳአራካ ጋርዦዳይ ጋርክ ኡፋይሳር ጊግንቴዝታ ማሆ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ማ ጾስ አስታ ፖኦ ካተትꬃ ላቶዳይ ጋርክ ይንታን ኦꬄዝ ጾስ ኣዳ ጋላቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ኤ ኑና ꬉማ ዎልቃፕ ሻኪ አሺ ፋ ዶስዛ ናአይ ካተትꬃ ገሎዳይ ጋርክ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ኤ ዎዝን ኑ ኑ ናጋራይስ አቶትꬅ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ክርስቶሳ በንቶዋ ጾሳይስ ቱማ ኣዝሶ። ኤ መትꬅ ኡቢታይፕ ኣꬎ ግታ ባይራ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ኡባ ባዝ ኤ ባጋር መꬍንቴዛ። በንትዝባዝታይኔ በንቶዋባዝታይኔ፥ ዎልቅታይኔ ጎድታይ፥ ሞድዝታይኔ ማዉተ አድታይ፥ ሳሎኔ ሳአ የዝ ኡብታ ጾሲ ኤ ባጋራኔ ኤስ መꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ኤ ኡባባዛፕ ካሰ የዛ። ኡባ ባዝ ክርስቶሳ ባጋር ፋ አቆ አቆ አይክንቲ ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ኤ ፋ አሰትꬅ ማቄዝ ዎሳ ኬꬃይስ ኩስተ። ኤ ኡባይፕ ኣꬅ ማቆዳይስ Ꮊይቆፕ ደንዶር ቲናኔ ባይራ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ጾሲ ፋ ኩንꬅ ጾሳትꬃይ ፋ ናአይ ጋንጨ የዞዳና ኮዬዛይ ጾስ አዳይ ሸነ ማቄዝ ግሾስ የይካ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ማ ማዝቃለል አፋ ላሌዝ ፋ ናአ ሱꬃይር ሳሮትꬅ መꬊ ሳሎኔ ሳአ የዝ ኡባ ኤ ባጋር ፓር ዳቦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","Ꮊይፕ ቲና ይ ቆፋይኔ ይ ኦሶ ኢታትꬃይ ይንታን ጾሳፕ ሻጌዛኔ ኤስ ሞርክታ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ዝን Ꮊት ክርስቶሳ አሾር Ꮊይቄዝ Ꮊይቃይ ባጋር ጾሲ ይንታን ፓር እግንꬂ፥ ጌሽታ፥ ቦሮ ባዝታኔ ጽልታ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ይ፥ ይ አማኖር ኤንኤካ ሚንጊ ጻጲ የዞዳይስ ቤዝዛ። ይ ዎንግለ ቃላ ስኤዝ ዎደ ኤኬዝ ኡፋይሳ ሚንꬂ አይኮይታ። የ ዎንግላ ይ ስኤዛኔ አላመ ኡባይል ሳባክንቴዛ። ታ፥ ጳዉሎሳካ Ꮊ ዎንግላይስ ኦሳንቾ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ታኒ ይ ግሾስ Ꮊት ኤክዝ መታይ ታና ኡፋይስዛ። ክርስቶሳ ኤ አሰትꬅ ማቄዝ ዎሳ ኬꬃትስ ኤኮዳር ፋጬዝ መታ ታኒ ታ አሻይል ፖሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ጾሳ ቃላ ይንትስ ዉርሲ ኦዶዳይ ጋርክ ታስ እንግንቴዝ ማዉታይር ዎሳ ኬꬅስ ኦሳንቾ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","Ꮊ ቃላይ ብኒ ኣꬌዝ ላይꬅታይድ የለትꬅ ኡባይፕ ጌንጊ ጋምኤዛ። ዝን Ꮊት ጾሲ Ꮊ ጹራ አማንዛ ኡባይስ ቆንጭሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ጾሲ አይሁደ ማቄዝ አሳይ ጋንጨ Ꮊ ጹራ ቦንቾ ዱረትꬃ ቆንጭሴዛ። ኤካ ቦንቾ ኡፋይስ ማቄዝ ይ ጋንጨ የዝ ክርስቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","የይ ግሾስ፥ ፐቲ ፐቲ አሳ ክርስቶሳር ኩንꬅ አስ ኡዲ ሺሾዳይስ ኤጨትꬅ ኡባይር አሳ ታማርሶራኔ ዞረር ክርስቶሳ ባጋ ሳባክዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ጾሲ ፋ ዳማ ዎልቃር ታል ኦꬅዛ ግሾስ Ꮊኖ ሄሎዳይስ ኤ ዎልቃር ቡትትዛኔ ዳቡርዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ታ ይንትስኔ ሎዶቃ ካታማ የዝ አሳይስ፥ Ꮊይ ጋርክ ታና ኣፈር በኤካ አስ ኡባይስ አብ ጋርክ ቡትትዛኮ ይ ኤሮድ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ታ ቡትትዛይካ ኡንቲ ፋ ዎዛናይር ሚንጊ፥ ሲቆር አጭንቲ፥ ፎሎ ማቄዝ ኩንꬅ አካካ ዱረትꬅ ደንጊ ጾስ ጹራ ክርስቶሳ ኤሮድ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ኤረተꬅኔ ኤጨትꬅ ሻሎ ኡባይ ቆስንቲ የዛይ ክርስቶሳራ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ታ የያ ግዛይ ኦንካ ይንታን ዶሻ ቃላር ባልꬃም ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ታ ይንትፕ ሃኪ የዝኮካ አያናር ይንታር የዛ። ይ የሳይ ዎጋኔ ክርስቶሳ ይ ሚንጊ አማንዛና ብእን ታና ኡፋይስዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ይ ጎዳ ክርስቶሳ የሱሳ ኤኬዛን ጋርክ ኤዛር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ኤዛል ጻጶይታ፤ ኤዛል ኬጽንቶይታ። ይ ታማሬዛን ጋርክ አማኖር ሚንጎይታ፤ ጾሳይስ ኩሚ ፑጬዝ ጋላታ እንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ክርስቶሳፕ ባዝን አስ ዎጋራኔ Ꮊ አላማይ ጨረ ዎጋል ኤቄዝ አስ ኤረትꬃር መꬊ ከሴዝ ትምርታይራኔ ጨረ ዶሻር ኦንካ ይንታን ባልꬂ ድኣማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ጾስ ጾሰትꬅ ፎሎ ኩንꬄትꬃይ አሰትꬃር ቆንጭ የዝዛይ ክርስቶሳራ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ይንትካ ማዉተስኔ ዎልቃ ኡባይስ ኩስተ ማቄዝ ክርስቶሳር ኩንꬅ ደኦ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ይ ክርስቶሳና አማኖር ዶካልንቴዛ። የይካ አስ ኩሸር ባዝን ይ ኢታ ናጋራራ ኩሜዝ ሀኖትꬅ ሃስዝ ክርስቶሳር ኦስንቴዝ ዶካልንቶ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ይ ጻማቅንቴዝ ዎደ ክርስቶሳር ዎላ ሞግንቲ፥ ክርስቶሳ Ꮊይቆፕ ደንꬄዝ ጾስ ዎልቃ አማኒ፥ ክርስቶሳር ዎላ ደንዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ይ፥ ይ ናጋራ ግሾኔ ይ ጬጋ አሰትꬃ ዶካልንተካ ግሾስ Ꮊይቂ የዝን፥ ጾሲ ይ ናጋራ አቶ ጌዛ። ክርስቶሳር ይንትስ ደኦ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ኤ ኑ ሞታኔ ኑር ኤቅንትዛ፥ ኑል አፋ ጻፍንቴዝ አጮ ጹፋ ፔꬊ ማዝቃለል አፋ ምክንቲ ኦገፕ ታጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ክርስቶሳ ዎልቂታኔ ማዉተ አድታ ማዝቃለል ጋሚ፥ ኡ ዳንጫ ብልእሲ፥ ድእንቴዝ አስ ጋርክ ኡዲ ኡንታን ቆንጨ ከሲ ቤዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","የይ ግሾስ፥ ሚዝባዛር ዎይ ኡዥዝ ባዛር፥ አጌና ጼርዛ ቃማ ዎይ ማላ ቦንቾ ባጋ ኦንካ ይንታል አፋ ፕርድፐ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","የይትታይ ቲናፕ የኦዳይስ የዛ ባዝታይስ ኤሾ፥ ዝን ኡባይ ክርስቶሳ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ቆፕ ቆሞ ሃዮትꬅኔ ኪታንቾስ ጎይኖር ጬቅንትዛ ኦንካ ይንታን ይ ዎይታይፕ አሽፐ። የይ ጋርክ አሲ ፋ በኤዝ ቆንጭꬃር ሳብንትታር ፋ አሾ ቆፋር ጨረ ኡትርትዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","የይ ጋርክ አሳይስ ኩስተ ማቄዝ ክርስቶሳኮ ሺቆ ባያ። ኤ አሰትꬃ ኡባ ሻሻራኔ ዎል ሄልꬂ አይꬂ ሙዚ ድችዛ። ጾሲ የይ ጋርክ ኦገር አሰትꬃ ኡባ ድችዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","ይ ክርስቶሳር Ꮊይቂ Ꮊ አላማ ሃርዛ አያንታይ ዎልቃፕ ዎዝንቴዛ። የዝን፥ አብስ ሻክንተካ አስ ጋርክ ማቂ Ꮊ ዎግታይስ ሞድንቴ? ");
INSERT INTO mfxe_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","Ꮊ ዎግታይ፥ «አይክፐ፤ ላእፐ፤ ቦችፐ» ግንትንትዝታ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","Ꮊ ኡባይ አስ ዎጋኔ ትምርተ ማቄዝ ግሾስ ኦሶል አፋ ፔዤዛይፕ ጉየ ꬋቦዳይስ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","Ꮊ አዛዝታይ አሲ ፋ ኡባ ቆፋፕ መꬌዝ ጎይኖ፥ አቆፕ ኣꬌዝ ሃዮትስኔ አሰትꬃ ቆሆር ኤርንቶ ኡንትስ ኤጨትꬂ ኣዝዛ፥ ዝን ኑ ኢታ አሞትꬅ ሃሮዳይስ ኡንትስ ዎልቃ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ይኬ፥ ይ ክርስቶሳር Ꮊይቆፕ ደንዴዛይ ጋርክ፥ ጾሳይፕ ኡሻች ባጋ በቴዝ ክርስቶሳ የዝ አቆ፥ ሳሎ የዛባዝታ ኮዮይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ሳሎ የዝታይል አፋ ይ ቆፋ ጋዶይታፕ አትን ሳአ የዝባዝታይል አፋ ጋድፓተ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","Ꮊይቆር ሻግንትዛይ ጋርክ ይ Ꮊ አላመ ኢታ ሀኖፕ ሻክንቴዛ። ይ ደአይ ክርስቶሳር ዎላ ጾስ ጋንጨ ቆስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ይንትስ ደኦ ማቄዝ ክርስቶሳ ቆንጭዝ ዎደ የ ዎደ ይንትካ ኤዛር ቦንቾር ቆንጮዳ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","የይ ግሾስ፥ ይንታል የዝ Ꮊ ሳአ አሾ ቆፍታ ዎꬎይታ። የይትታይካ ላግተ፥ ቱናትꬂ፥ ላግተስ ተንትቶ፥ ኤቃስ ጎይኖ ጋርከ ማቄዝ አሞትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","የይፕ ደንዴዛይድ ጾስ ካቻይ አዛዝንቶዋ አሳይል አፋ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","ይንትካ ቲና የ ኢታ ኦጋይር የꬍታር Ꮊይትታ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","Ꮊት ማቅኮ ይ የይትታ ኦꬅፓተ። የይትታይክ ካቺ፥ ይሎ፥ ገነኔ ቦርሶ ናሻ ይንትፕ ሃሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","ጬጋ ሀኖትꬃ ኤ ኦሳይር ይንትፕ ቃሬዝ ግሾስ ዎልስ ዎርዶትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","መꬊዛያ ኣዝዝ፥ ኤረትꬃር ላምንቴዝ ኦሮꬅ ሀኖትታ ማኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","Ꮊ ኦሮꬅ መትꬃይር፥ ግርኬ አስ ዎይ አይሁደ አስ፥ ዶካልንቴዛይ ዎይ ዶካልንተካዛይ፥ ታማሬዝ አስ ዎይ ታማረካ አስ አይለ ዎይ ጎዲ ባያ። ክርስቶሳ ኡባ፤ ኤ ኡባይዳካ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","የይ ግሾስ፥ ጾሲ ማራጼዝ አስ ጋርክ ገሸትꬃር ዶስንቴዝታ ማቂ፥ ማሮትꬅ፥ ቃ፥ አሽከትꬅ፥ ሃዮትꬅ ኬሃትꬅኔ ዳንዳአ ማኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","ዎል ዳንዳኦይታ። ኦንካ ፋ ላጋይፕ ቆህንቴዝ ባዝ ዬዝኮ ኤስ አቶ ጎይታ። ጎዳይ ይንትስ አቶ ጌዛይ ጋርክ ይንትካ ዎልስ አቶ አቶ ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","የ ኡባይል አፋር ኡባ ባዝ ዎላል ሺሺ አጭዝ ሲቆ ማኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","ጾሲ ይንታን ፐቲ አስ ኡዲ ጼጌዛይ፥ ሳሮተꬅስ ማቄዝ ግሾስ ክርስቶሳ ሳሮትꬃይ ይ ዎዝና ሃሮ። ጋላታር ኩሜዝታ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","ክርስቶሳ ቃላይ ይ ዎዝናይድ ኩሚ የዞ። ኤጨትꬅ ኡባር ዎል ታማርሶይታኔ ዞሮይታ። ማዝሙረር፥ ሳባራኔ አያና የꬃር ጾሳ ዎዝናፕ ጋላትታር የጾይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","ጾስ አዳ የሱሳ ባጋር ጋላትታር ይ ኦድንትዛ ዎይ ኦꬅዛ ባዝ ኡባ ጎዳ የሱሳ ሱንꬃይር ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ማችታዮ፥ ጎዳይ ቲና ቤዝዛ ባዝ ማቄዝ ግሾስ ይ አዝንታይስ አዛዝንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","አዝንታዮ፥ ይ ማችታ ዶሶይታ፤ ኡንትስ ኢትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ናእታዮ፥ ይንታን የሌዝታይስ ኡባ ባዛር አዛዝንቶይታ፤ የይ ጎዳ ኡፋይስዛባዚ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","የሌዝታዮ፥ ይ ናእታይ ኡፋይስ ጋቻማይ ጋርክ ኡንታን ይሎስፓተ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","አይልታዮ፥ ሳአል አፋ ይንትስ ጎድ ማቄዝታይስ ኡባ ባዛር አዛዝንቶይታ። ጎዳ ቦንችታር ሉለ ዎዝናፕ ኪትንቲ ኡንታን ኡፋይሶይታፕ አትን አሲ ቦኦ ግ ኦꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","ይ ኦꬅዛ ኦሶ ኡባ አስስ ባዝን ጎዳይስ ኦꬅዛይ ጋርክ ዎዝናፕ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ጎዳይፕ ሳሎ ቢታ ዎይቶ ኡዲ ናጎዳና ኤሮይታ፤ ይ ጎዳ ክርስቶሳስ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ጾሲ አስ ኣፈ ዞቆ ብኢ ፕርዶዋ ግሾስ ኦንካ ኢታ ኦሶ ኦꬅኮ ፋ ኢታ ኦሳይ ግሾስ ማህꬅ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ጎድታዮ፥ ይንትስካ ማ ሳሎ ጎድ የዛና ኤሪ፥ ይ አይልታይስ ጽሎትꬃራኔ ፐታ ፐታይፕ ሻከካዛር አቅሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ጾሳ ሚንጊ ጋላትታር ጋቼካዛር ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","ጾሲ ፋ ቃላ ፐንጋ ዶዮዳይ ጋርከኔ ታኒ ኤ ግሾስ አጭንቴዝ ክርስቶሳ ጹራ ማርካቶድ ጋርክ ኑስካ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ማ ታካ ቤዝዛይ ጋርክ ቃላ ቆንጭስ ኦዶዳይ ጋርክ ታስ ጾሳ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","ዎዳ ዎዝታር አማኖዋ አሳይ ላንቀ ኤጨትꬃር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","ይ አስ ኡባይስ ኮሽዛ ማህꬅ ኤሮድ ጋርክ ይ ናሻይ ኡባ ዎደ ኣꬎ ኬሄትꬃር ኩሜዛኔ ማጽነ ጋርክ ማልእዛ ባዝ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ኑ ሲቆ እሻይ ትክቆሳ፥ ታር ዎላ ጎዳይ ኦሳይድ አይለ ማቄዝ፥ አማንንቴዝ ኦሳንቻይ፥ ታ የስ ባጋ ይንትስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ታኒ ኤዛ ይንትኮ ኪቴዛይ፥ ኑ ዋይዚ የዛኮ ይንትስ ኦዲ ይንታን ምንꬃꬆዳይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","አናስሞሳ፥ አማንንትዛ ሲቆ እሻይ፥ ይ ባጋይ፥ ኤዛ ይንትኮ ኪቴዛ። ኡንቲ Ꮊይዳ ሀንዛ ባዝ ኡባ ይንትስ ኦዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","ታር ዎላ አጭንቴዝ አርስጽሮኮሳኔ ባርናባሳ እሻይ ናአይ ማርቆሳ፥ ይንታን ሳሮ ዬግዛ። ታ ይንትስ ቲና ኦዴዛይ ጋርክ ማርቆሳ ይንትኮ Ꮊንግኮ ኤዛ ሞኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ኢያሱ ግዝ ያስጾሳ ይንታን ሳሮ ዬግዛ። ጾስ ካተትꬅ ግሾስ ታር ኦꬅዛ አሳይ ጋንጨፕ አይሁደ ማቄዝታይ ኡ ኣዳ። ኡንትካ ታና ምንꬃꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","ይ ዳቦ፥ ክርስቶስ የሱሳ አይለ፥ ኤጳፍራ ይንታን ሳሮ ዬግዛ። ኤ ይ ጾስ ቲና ሚንጊ ኤቆድ ጋርከኔ ጾስ ሸነ ኤሪ ፖሎዳይ ጋርክ ኡባ ዎደ ጾሳ ይ ግሾስ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ኤ ይ ግሾስ ሎዶቃኔ ህራፖልሳ ካታማ የዝ አሳይ ግሾስ ኢታ ዳቡሬዛና ታ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ኑ ሲቆ እሻይ አክመ ሉቃሳኔ ዴማሳ፥ ይንታን ሳሮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ሎዶቃ የዝ ኑ እሽታይሲ፥ ንምፋስኔ እ ካራ ሺቅዛ አሳይስ ኑ ሳሮꬃ ኦዶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","Ꮊ ዳብዳባ ይ ናባቤዛይፕ ጉየ፥ ሎዶቃ ዎሳ ኬꬃ ናባብሶይታ። ይንትካ ሎዶቃ ዎሳ ኬꬃይ ይንትስ ዳክዝ ዳብዳባ ናባቦይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","ማ አርክጳሳና፥ «ጎዳይ ኔስ እንጌዝ ኦሳ ፖሎዳና ዶግፐ» ዬጊ ቆፍሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ታኒ፥ ጳዉሎሳ፥ Ꮊ ሳሮꬃ ታ ኩሸር ጻፌዛ። ታ አቻ የዛና ቆፖይታ። ጾስ ኣꬎ ኬሃትꬃይ ይንታር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","ጳዉሎሳ ስላሰኔ ጽማቶሳ ተሰሎንቀ ዎሳ ኬꬃ የዝ አማንዛ አስታይስ፥ ጾሳ አዳይ ባጋኔ ጎዳ የሱስ ክርስቶሳ ባጋ ማቄዝ አሳይስ ጻፌዝ ኪታ። ኣꬎ ኬሃተꬃይኔ ሳሮ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","ኑኒ ኡባ ዎደ ጾስ ዎስታር ይንታን ቆፕታር ይ ግሾስ ኡባ ዎደ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ኑ ጎዳኔ አዳይ ቲና አማኖር ይ ኦꬄዝ ኦሳ፥ ሲቆር ይ ዳቡሬዝ ዳቡራኔ የሱስ ክርስቶሳር የዝ ይ ኡፋይሳ ሚንጊ ኤቄዝ ኤቃ ኡባ ዎደ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","ጾሳ ዶሴዝ ኑ እሹንꬆ፥ ጾሲ ይንታን ዶሬዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","አብስ ጊኮ፥ ኑኒ ዎንግለ ዶና ኣዳር ባዝን ዎልቃር፥ ጌሻ አያናራኔ ዎንግለ ቱማትꬃር ይንትስ ከኤዛ። ኑኒ ይንታር ጋምኤዝ ዎደ ኡባይድ ይ ግሾስ ዋይዚ የዜዛኮ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ይ ጋመ መቶ ኤክኮካ ጌሻ አያናይ እንግዛ ኡፋይሳይ ባጋር ኪታ ኤኬዛ፤ ኑናኔ ጎዳይ ኣዝሳ ካልዝታ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","የይ ግሾስ፥ ማቃዶናኔ አካያ ቢታ የዝ አማንዛ ኡባይስ ሎኦ ኣዝሶ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ጎዳ ቃላይ ይንትፕ ከዚ፥ ማቃዶናራኔ አካያ ኣዳ ባዝን ጾሳ ይ አማንዛይ ኡባ አቆ ስንቴዛ። ይኬ፥ ኑኒ ጎድባዝ አኮካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","ኑኒ ይንትኮ Ꮊንጌዝ ዎደ ይ ኑና ሞኬዝ ሞካኔ ይ፥ ይ ኤቃ አሺ ቱማኔ ደኦ ጾሳይስ ኦꬆዳይስ ይ ዋይዚ ማቄዛኮ ኡንቲ ፋ ኦማስ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ማ ጾስ ናአይ፥ የሱሳ፥ ጾሲ Ꮊይቆፕ ደንꬄዛይ፥ ቲናፕ የኦድ ጾስ ካቻይፕ ኑና አሾዳይ፥ ሳሎፕ የኦዳና ይ ዋይዚ ናግዛኮ ኡንቲ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","ታ እሹንꬆ፥ ኑኒ ይንትኮ Ꮊንጌዛይ ጨረ ባዛና ይ፥ ይ ኦማስ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","ዝን ኑኒ ይንትኮ ተሰሎንቀ የኦዳይፕ ቲና ፍልጲሶሳ ካታማይድ መትንቴዛኔ ጫዥንቴዛ ይ ኤርዛ። ጋመ እጾ የዝኮካ ይንትስ ዎንግለ ኦዶድ ጋርክ ጾሲ ኑስ ምኖትꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","ኑኒ ይንታን ዞሬዛይ ባልꬆር ዎይ ቱና ቆፋር ዎይ ገነር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","ዝን ጾሲ ኑል አማንቲ ፋ ዎንግለ ኦዶዳይ ጋርክ ኑስ ሀዳራ እንጌዝ ጋርክ ኦዶዳ። ኑ የያ ኦꬄዛይ ኑ ዎዝና ብእዛ ጾሳ ኡፋይሶዳይስፕ አትን አስ ኡፋይሶዳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","ኑ ሚሸ ዶሲ ዎርዶር ይንታን ሳቆꬅታር ይንትኮ የኤካዛና ይ ሎእꬂ ኤርዛ፤ ጾስካ ኑስ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","ኑኒ ይንታፕ ማቅን ዎይ ሀራ ኦፐካ ቦንቾ ኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","ኑኒ ክርስቶሳ ሀዋረ ማቄዛይ ጋርክ ኑስ ቤዝዛ ባዝ እንጎይታ ግ ኤኮዳይስ ዳንዳእዛዝን እንዳ ፋ ናእታ ድችዛይ ጋርክ ይ ጋንጨ ኑ አሽከትꬃር ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","ኑ ይንታን ዶሴዝ ግሾስ ጾስ ዎንግለ ይንትስ ሻኮ ኣዳ ባዝን ኑ ሸምፓካ ይንትስ እንጎዳይስ ጊጊ በቴዛ። ይ ኑር ጋመ ዶስንትዝታ። ");
INSERT INTO mfxe_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","ኑ እሹንꬆ፥ ኑ ኦሳኔ ኑ ዳቡርሳ ይ ኤርዛ። ይንትስ ጾስ ዎንግለ ኦድታር፥ ይንታን ዋይꬃማይስ ቃማኔ ጋላስ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","ኑ ደአይ ይ አማንዝታይ ካለኔ ጾስ ቲና ጌሺ፥ ጽሎኔ ቦርንቶዋዝታ ማቂ የዜዛይስ ጾስኔ ይንቲ ማርካ። ");
INSERT INTO mfxe_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","ኑኒ ይንትስ ኦማስ ኦማስ አደ ፋ ናእታይስ ሀንዛይ ጋርክ ሀኔዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ኑ ይንታን ዞሬዛ፥ ምንꬄꬄዛ። ማ ኤ ካተትꬃኔ ኤ ቦንቻ ይ ሻክንቶዳይስ ይንታን ጼጌዝ ጾስ ኡፋይስዛ የስ ይ የዞዳይ ጋርክ ይንትስ ሚንꬂ ኦዴዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","ማካ ኑ ይ ባጋ ጋቼካዛር ጾስ ጋላትዛ ባዝ የዛ፥ የይካ ይ ኑፕ ስኤዝ ጾስ ቃላ ይ ኤኬዝ ዎደ ይንታር አማንዝታይር ኦꬅዛ Ꮊ ቃላ ይ አስ ቃላ ጋርክ ባዝን ቱማ ጾስ ቃላ ጋርክ ኤኬዛ። የይካ ቱማ ጾስ ቃላ። ");
INSERT INTO mfxe_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","ታ እሹንꬆ፥ ይ ይሁዳ ቢታ የዝ ዎሳ ኬꬅታኔ ኤዛይድ ክርስቶሳ የሱሳ ካልዛ አሳይ ጋርክ ሀኔዛ። ኡንታን አይሁድታይ ዋይꬄዛይ ጋርክ ይንታናካ ይ ቢታ አሳይ ዋይꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","የ አይሁድታይ ጎዳ የሱሳኔ ናብታ ዎꬌዛ፤ ማ ኑናካ ባይእꬅ ቢታፕ ከሴዝታ። ኡንቲ ጾስ ኡፋይሶዝታኔ አስ ኡባ እጽዝታ። ");
INSERT INTO mfxe_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","ኡንቲ ሀራ አቶዝን፥ አይሁደ ማቀካ አሳይ አቶዳይ ጋርክ ኑ ኡንትስ ቃላ ኦድዛናካ ካይዛ። የይ ጋርክ ሀኒ ኡ ኡባ ዎደ ናጋራ ናጋራል ኦꬄዝ ግሾስ፥ ዉርስꬃል፥ ጾስ ካቻይ ኡንታል አፋ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","ዝን ኑ እሹንꬆ፥ ኑኒ አያናር ባዝን አሾር ይንትፕ ሻክንቲ ጽቃ ዎደ ጋምኤዛይድ ይንታን ኢታ ላሞቲ አሾር በአዳይስ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ኑ ማቂ ይንትኮ Ꮊንጎዳይስ ኮዬዛ። ታኒ ታ ኦማስ ይንትኮ Ꮊንጎዳይስ ኮዬዛ፥ ዝን ጻላሄ ኑና ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","የዝን፥ ኑ ጎዳ የሱስ ክርስቶሳ ይእዛ ዎደ ኑ ኡፋይሳይ ዎይ ኑ ጬቅንትዛ ኑ ዛዉዳይ ኦኖ? ይንታን ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","ቱማ ይ ኑ ቦንችታኔ ኑ ኡፋይስታ። ");
INSERT INTO mfxe_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","የይ ግሾስ፥ ይንታን በኤካ ጋርዦ ኑስ ዳንዳእንታም እጽን፥ አቴና ካታማ ኑ ኣዳስ አቶዳይስ ቆፋ አጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","ይንታን ዞሮድ ጋርከኔ አማኖር ምንꬃꬆድ ጋርከ ኑራ ዎላ ጾስስ ኦꬅዛኔ ክርስቶሳ ዎንግለ ኦድዛ ኑ እሻ ጽማቶሳ ይንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","የይካ ይንታን ሄሌዝ መታይድ ይንትፕ ኦንካ ጉየ ማቅፐ። የ ባይእꬃይ ኑስ ጾስ ሸነ ማቄዛና ይ፥ ይ ኦማስ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","ኑ ይንታር የዝ ዎደ ባይእꬅ ሄሎዳና ይንትስ ቲናቲ ኦዴዛ። ይ ኤርዛይ ጋርክ ሀኔዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","የይ ግሾስ፥ ታስ ጋርዦዳይስ ዳንዳእንታም እጽን፥ «ኦኒ ኤሬ ጻላሄ ኡንታን ፓጪን ኑ ዳቡርሳይ Ꮊር አቶደሻ» ግ ይ አማናይ ባጋ ኤሮዳይስ ጽማቶሳና ይንትኮ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Ꮊት ጽማቶሳ ይ ካለፕ ይኢ፥ ይ አማኖ ባጋኔ ይ ሲቆ ባጋ ሎኦ ዎረ ኦዴዛ። ማ ይ ኡባ ዎደ ኑስ ሎኦ ቆፕዛኔ ኑኒ ይንታን በአዳይስ ላሞትዛይ ጋርክ ይንትካ ኑና በአዳይስ ላሞቴዛና ኤ ኑስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","ታ እሹንꬆ፥ ኑኒ ዋያይ ጋንጨኔ መቶ ጋንጨ የዝኮካ ይ አማናይ ግሾስ ኑ ሚንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","ይ ጎዳይል ሚንጊ የዝኮ ኑ ፋጻት ይኖ። ");
INSERT INTO mfxe_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","ይኬ፥ ኑኒ ይንትፕ ደንዴዛይድ ደንጌዝ ኡፋይሳይስ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","ኑኒ ይንታን ኣፈር በአዳይስነ ይ አማናይድ ፓጬዝ ባዝ ኩንꬆዳይስ ቃማኔ ጋላስ ኑ ኩንꬅ ዎዝናር ጾሳ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","ጾስ ኑ ጎዳይኔ ኑ አዳይ ኤ ኑ ጎዳይ የሱስ ክርስቶሳካ ፋ ኦማስ ኑ ይንትኮ Ꮊንግዛ ኦጋ ጊግሶ። ");
INSERT INTO mfxe_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","ኑ ይንታን ሎእꬂ ዶስዛይ ጋርክ ይ ዎል ሲቅዛ ሲቃኔ አስ ኡባ ሲቅዛ ሲቃ ጎዳይ ይንትስ ጋንꬆኔ ጉጆ። ");
INSERT INTO mfxe_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","ኑ ጎዳይ የሱስ ፋ ጌሽታይር ይእዛ ዎደ ጾሳይ፥ ኑ አዳይ ቲና ይ ዎዝና ጌሽኔ ቦሮ ባዛ ኡዲ ኤ ይንታን ምንꬃꬆዳ። ");
INSERT INTO mfxe_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","ዉርስꬃ፥ ታ እሹንꬆ፥ ጾሳ ኡፋይሶዳይስ ይ ዋይዚ የዞዳይስ ቤዝዛኮ ኑፐ ይ ታማሬዛ። Ꮊተካ ይ Ꮊይ ጋርክ የዝዛ፥ ዝን Ꮊት ይ ካሴሳይፕ ኣꬂ ኦꬆዳይ ጋርክ ጎዳ የሱሳ ሱንꬃይር ኑ ይንታን ዎስዛኔ ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","ኑኒ ጎዳ የሱሳ ማዉተር ይንታን አዛዜዝ ህጋይ ኣያዛኮ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","ጾሳይ፥ ይ ጌሽ ማቆዳይ ጋርከኔ ላግታፕ ሃኮዳይ ጋርክ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","ይ ፐታይ ፐታይ፥ ይ ማችታይራ ጌሻትꬃራኔ ቦንቾር የዞዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","ጾስ ኤሮዋኔ አማኖዋ አስ ጋርክ ላግታስ ተንትቶር የዝፓተ። ");
INSERT INTO mfxe_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","ኑ ቲና ይንትስ ኦዴዛይ ጋርከኔ ሚንꬂ ዞሬዛይ ጋርክ ጎዳይ የይ ጋርክ ኦꬅዛ ኡባ ፕርድዛ ግሾስ ኦካ Ꮊይ ጋርክ አማንዛ ኦናካ ናቆዳይስኔ ዶሾዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","ጾሲ ኑኒ ጌሸትꬃር የዞዳይ ጋርከፕ አትን ቱናትꬃር የዞዳ ጋርክ ጼገካያ። ");
INSERT INTO mfxe_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","የይ ግሾስ፥ Ꮊ ትምርታ እጽዛ ኦንካ ይንትስ ጌሻ አያና እንግዛ ጾሳ እጽነፕ አትን አሰ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","ይ ዎል ዋይዚ ዶሶዳዛኮ ጾሲ ይንታን ታማርሴዝ ግሾስ Ꮊት ዶሶ ባጋ ኑ ይንትስ ኦዶዳይስ ኮሾያ። ");
INSERT INTO mfxe_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","ማ ማቃዶና ቢታ የዝ አማንዝታ ኡባ ቱማ ይ ዶስዛ። ዝን ኑ እሹንꬆ፥ ዬዝካ ይ ኡንታን ኡሳ ዶሶዳይ ጋርክ ኑ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","ኑኒ ቲና ይንትስ ኦዴዛይ ጋርክ ዳጭ ግ የዞይታ። ይ፥ ይ ኩሸር ኦꬂ ይ የስስ ቤዝዛ ባዝ ደንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","የይ ጋርክ ሀንኮ፥ አማኖዋ አስታይ ካንታይድ ይ ቦንችንቶዳ፤ ማ ይንታን ኮሽዛባዝስ ኦናካ ኣዳሻሚ። ");
INSERT INTO mfxe_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","ኑ እሹንꬆ፥ ኡፋይሲ ባ አስ ጋርክ ይ ካያꬋማይ ጋርከኔ Ꮊይቄዝ አሳይ ባጋ የዝ ቱማ ይ ኤሮዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","ኑኒ፥ የሱሳ Ꮊይቄዛናኔ Ꮊይቆፕ ደንዴዛና አማንዛባዝ ማቅኮ፥ ጾሲ የሱሳና አማኒ Ꮊይቄዝታ ኤዛር ዎላ ኮኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","ጎዳይ ኑስ ኦዴዛይ ጋርክ ኑ ይንትስ ግዛይ Ꮊያ። ጎዳይ የኦድ ጋላስ ሄሎዳይስ ኑኒ ፓጻ የዝታይ፥ Ꮊይቄዝታይፕ ቲናታሚ። ");
INSERT INTO mfxe_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","ጎዳይ ዎልቃማ አዛዞር፥ ኪታንችታይ ሀላቃ ግርꬃራ፥ ቱልቱሎ ፑጊ አዋጆር ጾሲ፥ ሳሎፕ ዎꬎዳ። ክርስቶሳ አማኒ Ꮊይቄዝታይ ቲናቲ Ꮊይቆፕ ደንዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","የይፕ ጉየ፥ የ ዎደ ኑኒ ሸምፖር የዝታይ፥ ጎዳ ጫርኮል ሞኮዳይስ ሻራር ኤክንቶዳ። የይፕ ጉየ፥ ኑኒ ጎዳይራ ዎላ መꬍናስ የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","የይ ግሾስ፥ Ꮊ ቃልታይድ ዎል ምንꬃꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","ታ እሹንꬆ፥ Ꮊይትታይ ሀኖድ ላይꬅታይኔ አግንታይ ባጋ ይንትስ ጻፎዳይስ ኮሾያ። ");
INSERT INTO mfxe_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","ጎዳይ ጋላሳይ ካይዞ ቃማ ይእዛይ ጋርክ የኦዳና ይ ሎእꬂ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","አሳይ፥ «ሳአ ሳሮ፥ አኮካ ባያ» ዬጎዳር፥ ማች እቅꬂ አይክዛይ ጋርክ ꬋቦ ኡንቲ ቆፐካዝን ኡንታል አፋ የኦዳ። ኡንቲ አባ ኦገርካ የሻ ቡታሚ። ");
INSERT INTO mfxe_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","ዝን ኑ እሹንꬆ፥ የ ጋላሳይ ይንትስ ካይዞ ይእዛይ ጋርክ የኦዳይስ ይ ꬉማ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","ይ ኡባይ ፖኦ አስኔ ጋላሳ የዝ አሲ፤ ኑኒ ቃማ አስ ዎይ ꬉማ አስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","የይ ግሾስ፥ ኑኒ Ꮊንክታይ ገንትዛይ ጋርክ ገንቶዳይስ ቤዞያ፤ ኑኒ ባርኮዳይስኔ ጊጊ የዞዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","ገንትዝታይ ቃማ ገንትዛ፤ ማꬅዝታይካ ቃማ ማꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","ዝን ኑኒ ፖኦ አስ ማቄዝ ግሾስ ቤዝዛይ ጋርክ የዞዳይስ ቤዝዛ። አማኖኔ ሲቆ ጹሩረ ጋርክ ትራል ማኢ፥ አቶትꬅ ኡፋይሳ ኦማ ኦላ ብራታ ባርኔጻ ጋርክ ጋዲ የዞዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","ጾሲ ኑና ኑ ጎዳ የሱሳ ባጋር ኩንꬅ አቶትꬅ ኤኮዳይ ጋርክ ዶሬዛፕ አትን ካችስ ዶረካያ። ");
INSERT INTO mfxe_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","ኑኒ ፓꬅ የዝን ዎይ Ꮊይቂን፥ ክርስቶሳር የዜዝ ዎደ ኤዛር ፐትፕ የዞዳይ ጋርክ ክርስቶሳ ኑ ግሾስ Ꮊይቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","የይ ግሾስ፥ ይ ቲና ኦꬄዛይ ጋርክ፥ ፐታይ ፐታ ምንꬃꬆይታኔ ድቾይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","ኑ እሹንꬆ፥ ይ ጋንጨ ኦꬅዝታ፥ ይንታን ካልꬆዳይ ጋርከኔ ዞሮዳይ ጋርክ ጎዳይ ዶሬዝታ ቦንቾዳይ ጋርክ ይንታን ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","ኡንቲ ኦꬅዛ ኦሳይ ግሾስ ኡንታን ኡሳ ቦንቾይታኔ ሲቆይታ። ዎላ ሳሮር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","ኑ እሹንꬆ፥ ቦዝታ ካጮይታ፤ ያሽትዝታ ምንꬆይታ፤ ዳቡሬዝታ ማዶይታ፤ አስ ኡባ ዳንዳኦይታ የጊ ኑኒ ይንታን ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","ኦንካ ኢታ ግሾስ ኢታ ማሃማይ ጋርክ ናግንቶይታ። ይ ዎልስኔ አስ ኡባይስ ሎኦ ባዝ ኦꬆዳይስ ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","ኡባ ዎደ ኡፋይቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","ኡባ ዎደ ጾሳ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","ኡባ ባዛር ጋላቶይታ። ክርስቶሳ የሱሳ ባጋር ጾሲ ይንታፕ ኮይዛይ የያ። ");
INSERT INTO mfxe_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","ጌሻ አያና ኦሳ ዱጭፓተ። ");
INSERT INTO mfxe_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ትንቢተ ለቅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ኡባ ባዝ ፋጮይታ፤ ሎኦ ባዛ ኤኮይ። ");
INSERT INTO mfxe_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ኢታ ኦሶ ኡባይፕ ሃኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","ሳሮ እንግዛ ጾሳይ ፋ ኦማስ ይንታን ፎሎ ጌሾ። ኑ ጎዳይ የሱስ ክርስቶሳ የኦድ ጋላስስ፥ ጾሲ ይ አያና፥ ይ ሸምፓኔ ይ ኩንꬅ አሰትꬃ ቦሮ ባይꬅ ናጎ። ");
INSERT INTO mfxe_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","ይንታን ጼግዛይ አማንንቴዛያ ማቄዝ ግሾስ የያ ኤ ፖሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","ኑ እሹንꬆ፥ ኑስ ጾሳ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","አማንዛ አስ ኡባ ጌሽ ዬራር ሳሮꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ይ Ꮊ ኪታ አማንዛ አስ ኡባይስ ናባቦዳይ ጋርክ ጎዳይ ሱንꬃይር ይንታን ታ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ ይንታር ዎላ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","ጳዉሎሳፐ፥ ስላሰፐኔ ጽማቶሳፐ ተሰሎንቀ ዎሳ ኬꬃ የዝ አማንዛ አሳይስ፥ ጾሳ አዳይባጋኔ ጎዳ የሱስ ክርስቶሳ ባጋ ማቄዝ አሳይስ ጻፌዝ ኪታ። ");
INSERT INTO mfxe_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","ጾሳ ኑ አዳይፐኔ ጎዳ የሱስ ክርስቶሳፕ ኣꬎ ኬሃትꬃይኔ ሳሮትꬃይ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","ኑ እሹንꬆ፥ ይ አማናኔ ይ ዎል ሲቅዛ ሲቃይ ሎእꬂ ድጭዛ ግሾስ ኑኒ የይስ ጾሳ ኡባ ዎደ ጋላትዛ፥ ጋላቶዳይስካ ቤዝዛ ");
INSERT INTO mfxe_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ይንታን ሄሌዝ ባይእꬃይዳኔ ዋየ ኡባይድ ጋርዦራኔ አማኖር ሚንጊ ኤቄዝ ግሾስ ኑኒ ኑ ኦማስ ጾስ ዎሳ ኬꬃ ይ ባጋ ማርካትታር ይንታል ጬቅንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","ይ ኤ ግሾስ ግ መቶ ኤክዝ ጾስ ካተትꬃይስ ቤዝዝታ ማቂ ታይብንቶዳይ ጋርክ ጾስ ጌሽ ፕርዳይስ Ꮊይ ማላ። ");
INSERT INTO mfxe_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","ጾሲ ቱማ ፕርዳ ፕርዶዳ። ጾሲ ይንታን ዋይስዝታይል አፋ ዋየ ክኢ ኡ ጋታ ጭጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","ጎዳ የሱሳ ፋ ዎልቃማ ኪታንችታይራ ይኢ Ꮊት ዋይንትዛ ይንታናኔ ኑና ሸምፕሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","ኤ ላጽዝ ታማር በንቶዳ፥ ማ ጾሲ ፋና ኤሮዋዝታኔ ኑ ጎዳ የሱስ ክርስቶሳ ዎንግላይስ ኪትንቶዋዝታ ኤጽዝ ታማር ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","ኡንቲ ጎዳይ ቲናፐኔ ኤ ቦንቾ ዎልቃፕ ሻክንቲ መꬍና ꬋቦር ፕርድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","የ ጋላስ፥ ኤ ፋስታይራኔ ፋና አማንዝታይል ኡባይል ቦንችንቶዳይስኔ ሳብንቶዳይስ የኦዳር ኑ ይንትስ ኦዴዝ ኪታ ይ አማኔዝ ግሾስ ይ ኤዛ ቦንችዝታይ ጋንጨኔ ሳቢዝታይ ጋንጨ ፓይድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","ኑኒ ይንትስ ኡባ ዎደ ቆፋ ጋቼካዛር ጾስ ዎስዛይ የይሲ። ኑ ጾሲ ይንታን ጼጌዝ ጼግꬃይስ ቤዝዝታ ማቂ ፓይድንቶዳይ ጋርክ ዎስዛ። ይ ሎኦ ባዝ ኦꬆዳይስ አሞትዝ አማኔ ይ አማኖ ኦሳ ኤ ፋ ዎልቃር ፎሎ። ");
INSERT INTO mfxe_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","ኤዛይድ ኑ ጾሳኔ ኑ ጎዳ የሱስ ክርስቶሳ ኣስ ኬሃትꬃይድ፥ ጎዳ የሱሳ ሱንꬃ ይ ቦንቾዳ፤ ይንትካ ኤር ቦንችንቶዳይ ጋርክ ኑ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","ኑ እሹንꬆ፥ ኑ ጎዳ የሱስ ክርስቶሳ ይእꬅ ባጋኔ ኑ ኤዛ ሄሎዳይስ ሺቆባጋ ኑ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","ትንቢተር ዎይ ቃላ ስኤዛይ ጋርክ ዎይ ኑፐ ኤኬዝ ኪታ ኡዲ፥ «ጎዳይ ጋላሳይ ሄሌዛ» ዬጊ ይ ዎዝናይ ዳጋምፐኔ ꬋብፐ። ");
INSERT INTO mfxe_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","ይንታን ኦንካ አባ ኦገራካ ባልꬅፐ። ቲናቲ አሳይ ጾሳ ካዶ አይከካዝን ዉጨ አꬃይ ዡጫትꬃይ ቆንጨካኔ ꬋቦስ ቤዝዛ አꬃይ የኤካዝን፥ ጎዳይ ጋላሳይ ሄላሚ። ");
INSERT INTO mfxe_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Ꮊ ዉጨ አꬃይ ጎድ ጊንቲ ጎይንትዛ ኡባይፕ ኣꬂ ፓና ꬎቅ ኡዶዳ። ሀራ አቶዝን ያሻ ባይꬅ፥ ጾስ ካራ ገሊ በቲ፥ «ታኒ ጾሰ» ጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","ታኒ ይንታር የዛር ይንትስ ኦዴዛና አካኮሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Ꮊ ዉጨ አꬃይ ፋ ጋላሳር የኦዳይፕ አትን Ꮊት የአማይ ጋርክ አቢ ኤዛ ካይዛኮ ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","አሳይስ በንተካዛር ዉጨ አꬃይ ዎልቃይ Ꮊተካ ጌማር ኦꬅዛ፥ ማቆዝን Ꮊት ኤዛ ካይዛይ የዛ። ኤዛ ካይዛይ ኦገላፕ ሀልኦድ ሄሎዳይስ ኤ በንታሚ። ");
INSERT INTO mfxe_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","የይፕ ጉየ፥ ዉጨ አꬃይ በንቶዳ፥ ዝን ጎዳ የሱሳ ፋ ዶናይፕ ከዝዝ ፔናይራኔ ፋ ይእꬃይ ዴታይር ኤዛ ꬋብሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ዉጨ አꬃይ ጻላሄ ዎልቃር ይኢ ባልꬅዛ ማልታኔ ማላባዝታ ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","የይ ጋርከካ፥ ꬋቦስ የዝ አስታ ዱማ ዱማ ዶሽዛ ኢታ ኦሶር ባልꬆዳ። ኡንትካ ꬋብዛይ አሽዛ ቱማና ዶሲ ኤካም እጼዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","የይ ግሾስ፥ ኡንቲ ዎርዶ አማኖዳይ ጋርክ ጾሲ ኢታ ባልꬆ ዎልቃ ኡንታል አፋ ዳኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","የይካ፥ ቱማ አማናም ግ፥ ናጋራ ኦሶር ኡፋይትዛ ኡባይ ፕርድንቶዳይ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","ጎዳይ ዶስዛ ኑ እሹንꬆ፥ ኑኒ ጾሳ ይ ግሾስ ኡባ ዎደ ጋላቶዳይስ ቤዝዛ። ጋላትዛይካ ይ አቶዳይ ጋርክ ጌሻ አያና ዎልቃር ይንታን ጌሼዛኔ ይንትካ ቱማ አማኒ አቶዳይ ጋርክ ኤ ይንታን ባይራꬂ ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ጾሲ፥ ኑ ይንትስ ኦዴዝ ዎንግላይ ባጋር ይንታን ጼጌዛይ፥ ይ ኑ ጎዳ የሱስ ክርስቶሳር ዎላ ቦንችንቶዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","ይኬ፥ ኑ እሹንꬆ፥ ሚንጊ ኤቆይታ። ኑኒ ይንታን ዶናር ዎይ ዳብዳበር ታማርሴዝ ትምርታ ሚንꬂ አይኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","ኤ ኑ ጎዳ የሱስ ክርስቶሳኔ ኑና ቃꬊ ኑስ ፋ ኣꬎ ኬሄትꬃር መꬍና ምንꬃꬆኔ ሎኦ ኡፋይስ ጾስ አዳይ ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","ይ ኡባ ዎደ ሎኦ ባዝ ኦꬆዳይስኔ ኦድንቶዳይስ ኤ ምንꬃꬆዳይ ጋርከኔ ማዶዳይ ጋርክ ኑ ጎዳ ጾሳ ኑ አዳ ዎሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","ዉርስꬃል ኑ እሹንꬆ፥ ጎዳይ ቃላይ ይ ጋንጨ ኤልሲ ዳልጎዳይ ጋርከኔ ቦንችንቶዳይ ጋርክ ኑስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","የይ ጋርከካ፥ ቃላ ስእዝ አስ ኡባይ አማንዝታ ባያ: የይ ግሾስ ጾሲ ዡጭታይፐኔ ኢታ አስታይፕ ኑና አሾዳይ ጋርክ ኑስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","ዝን ጎዳይ አማንንትዛያ፤ ኤ ይንታን ምንꬃꬆዳኔ ጻላሄፕ ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","ኑኒ ይንታን ኪትዛይ Ꮊተካ ቲናፐካ ይ ኦꬆዳያ ጎዳይል ኑ ይንታል አማንንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","ጎዳይ ይ ዎዝና ጾስ ሲቆኮኔ ክርስቶሳ ዳንዳአይኮ ካልꬆ። ");
INSERT INTO mfxe_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","ኑ እሹንꬆ፥ ይ ኑፕ ኤኬዝ ኪታ ካሎዝታይፐኔ ኦሶ ዶሶዋ አዛላ አማንዛ አስታይፕ ይ ሻክንቶዳይ ጋርክ ጎዳ የሱስ ክርስቶሳ ሱንꬃይር ይንታን ኑ አዛዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","ኑ ኣዝሶ ጋርክ ሀኒ የዞዳይስ ቤዝዛና ይ፥ ይ ኦማስ ኤርዛ። ኑኒ ይንታር የዝ ዎደ ኦሶ ብልኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","ኑኒ ኦፐካ ካꬃ ጨረ ሜካያ። ኑስ ዳንዳእንቴዛይ ጋርክ ቃማኔ ጋላስ ዳቡርታር የነፕ አትን ኦስካ ቶፎ ማቀካያ። ");
INSERT INTO mfxe_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","ኑኒ የያ ኦꬄዛይ፥ ይንትስ ኣዝሶ ማቆዳይስፕ አትን ይንትፕ ማዴ ኦይጮዳይስ ኑስ ማዉተ ꬋብን ባያ። ");
INSERT INTO mfxe_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","ኑ ይንታር የዛ ዎደካ፥ «Ꮊንቶዳይስ ኮዮዋ አስ ኦንካ ሚፐ» ዬጊ አዛዜዛ። ");
INSERT INTO mfxe_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ኑኒ የያ ጌዛይ፥ ይ ጋንጨ ፐቲ ፐቲ አዛልታይ የዛ ስኤዝ ግሾስ። የ አስታይ ገልሶዋ አቆ ገሊ ሀርታ ኦሶ ብልስነፕ አትን አባ ኦꬆካ ኦꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","ኑኒ የይ ጋርክ አስታይ ሸምፕ ዎጋር የሳዳይ ጋርከኔ ፓስ ቤዝዛ ባዝ ፋ ኩሸር ኦꬂ ደማዳይ ጋርክ ጎዳ የሱስ ክርስቶሳ ሱንꬃር ኡንታን አዛዝዛኔ ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","ዝን ኑ እሹንꬆ፥ ኑ ዳቡሬዛ ግ ሎኦ ኦሶ ኦꬆዳይስ አዛልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ꮊት ኑኒ Ꮊ ዳብዳባይድ ኪቴዝ ኪታይስ ኪትንቶዋ አስ ኦንካ የዝኮ የ አꬃ ኤሮይታ። ኤ ዬላቶዳይ ጋርክ ኤፕ ሻክንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","ዝን ኤዛ እሸ ጋርክ ሴሮይታፕ አትን ሞርከ ጋርክ ብእፓተ። ");
INSERT INTO mfxe_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","ሳሮ ጎዳይ፥ ፋ ኦማስ ይንትስ ኡባ ዎደኔ ኡባ ባጋር ሳሮ እንጎ። ጎዳይ ይንታር ኡቢታይር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","ታኒ ጳዉሎሳ፥ Ꮊ ሳሮꬃ ታ ኩሸር ጻፌዛ። ታ ኪታ ኡባይስ ማላይ Ꮊያ፤ ታኒ የይ ጋርክ ጻፍዛ። ");
INSERT INTO mfxe_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ ይንታር ኡቢታይር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","ኑና አሽዛ ጾሳይኔ ኑ ኡፋይሳ ማቄዝ የሱስ ክርስቶሳ አዛዞር፥ የሱስ ክርስቶሳ ሀዋረ ማቄዝ፥ ጳዉሎሳፕ፥ ");
INSERT INTO mfxe_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","አማኖር ታስ ቱማ ናአ ማቄዝ ጽማቶሳስ። ጾሳ ኑ አዳይፕ፥ ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይ፥ ማሮተꬃይኔ ሳሮትꬃይ ኔስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","ታኒ ማቃዶና Ꮊንግታር ነና ሀዳሬዛይ ጋርክ፥ ፐቲ ፐቲ አስታይ ዎርዶ ትምርተ ታማርስዛና ካዮዳይስ ነ ኤፈሶነ ጋምኦዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","ኡንቲ ማዶዋ ቶሰ ኦዶኔ ዉርስꬂ ባ ፋ ኮቺ ፓይዶ አሾዳይ ጋርክ ኦዶባ። የይ ጋርከዝ ባዝ ፓላማ ካልꬅነፕ አትን አማኖር ኦስንትዝ ጾስ ኦሳይስ ማዶያ። ");
INSERT INTO mfxe_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Ꮊ አዛዛይ ኣፈ ቆፋይ ጌሽ ዎዝናፕ፥ ሎኦ ካሃፐኔ ቱማ አማኖፕ በንትዝ ሲቆ። ");
INSERT INTO mfxe_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","ፐቲ ፐቲ አስታይ Ꮊያ አሺ፥ ፓꬆዋ ጨረ ፓላማኮ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","ኡንቲ ጾስ ህገ አስታማረ ማቆዳይስ ኮይዛ። ዝን ኡንቲ አብ ኦድዛኮ ዎይ ኑሳይ ቱማ ግ ኦድዛናካ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","አሲ ቤዝዛይ ጋርክ ህገር ማድንትኮ ህገ ሎኦ ማቄዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","አካኮዳይስ ቤዝዛይ ህገ ሃዮ አሳይስ መꬍንተካዛ ኑ ኤርዛ፥ ዝን ህገ፥ ህገ መንꬄዝታ፥ ዳፋ ኦꬅዝታ፥ ጾሰ ያሽቶዝታ፥ ሸምፖ ዎꬍዝታ፥ ናጋራንችታ፥ ጌሻትꬂ ባዝታ፥ ቱንታ፥ ሀራ አቶዝን ፋ እንዶ ዎይ አደ ዎꬍዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ላምዝታ፥ ꬊራꬂ ꬊራꬃር ላምዝታ፥ አስ ባይዝዝታ፥ ዎርዳንችታ፥ ዎርዶር ጫቂዝታ፥ ዎይ ቱማ ትምርተራ ዎል ሄሎዋ አባ ኦሶ ኡባ ኦꬅዝታይሲ። ");
INSERT INTO mfxe_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Ꮊ ቱማ ትምርታይ ቦንቾኔ አንጅንቴዝ ጾሳይ ታ አዋጆዳይ ጋርክ ታስ ሀዳራ እንጌዝ ዎንግለ ጋንጨ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","ታና ፋ ኦሶስ ሹሚ የ ኦሳይስ ቤዝዛ ግ ፓይዲ ታ ኦꬅዛ ኦሳይስ ታስ ዎልቃ እንጌዝ ኑ ጎዳ ክርስቶሳ የሱሳና ታ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","ታኒ Ꮊይፕ ቲና ጫዥዛያ፥ ባይእዛኔ ካውሽሴዛ ማቅኮካ ታኒ የያ ኤረካኔ አማነካ ኦꬄዝ ግሾስ ጾሲ ታና ማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","ኑ ጎዳይ ፋ ኣꬎ ኬሃትꬃይፕ ታል አፋ ጎግሲ፥ የ ኣꬎ ኬሄትꬃር አማኖኔ ሲቆ ክርስቶሳ የሱሳ ባጋር ታስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","«ክርስቶሳ የሱሳ ናጋራንችታ አሾዳይስ Ꮊ አላመ የኤዛ» ግዝ ቃላይ አማንꬅዛኔ አስ ኡባይ ኤኮዳይስ ቤዝዛያ። ኡባፕ ኣꬌዝ ናጋራንቻይ ታና። ");
INSERT INTO mfxe_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","ዝን መꬍና ደኦ ኤኮዳይስ ኤዛ አማንዛ አሳይስ ታኒ ኣዝሶ ማቆዳይ ጋርክ የሱስ ክርስቶሳ ታና ጋመ ዳንዳኤዛ። ታስ ኡባይፕ ኣꬊዝ ናጋራንቻይስ ጾሲ ፋ ማሮትꬅ ጋንትꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ኣፈር በንቶዋዝታይስ፥ ፐቲ ጾሳይስ፥ Ꮊይቆዋዛይስ፥ መꬍና ካታይስ፥ መꬊናፕ መꬍና ሄሎዳይስ ጋላታኔ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","ታ ናአ ጽማቶሳ፥ ካሰ ነባጋ ናብታይ ኦዴዝ ቃላይል አፋ ኤቂ Ꮊ ኪታ ሀዳራ ኔስ እንግዛ። ነ የ ቃላ ካሊ ሎኦ ኦላ ኦልንቶባ። ");
INSERT INTO mfxe_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","አማኖኔ ሎኦ ካሃ ኔስ የዞ። ፐታይ ፐታይ ካሃይ ግዛያ እጺ ማረ ባ ማርካበ ꬋብዛይ ጋርክ ፋ አማና ꬋብሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","ያ አስታይ ጋንጨ ሄመኔሳኔ ኢስክንድረ የዛ። ኡንቲ ታማሪ ጾሳ ጫሸ አሾዳይ ጋርክ ታኒ ጻላሄስ ኡንታን ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","ጾስ ጎይኖኔ ቦንቾ ኩሜዝ ደኦር አሳይስ፥ ዎሶዳይስ፥ ጉሮዳይስኔ ጋላቶዳይስ ቤዝዛና ታኒ ነና ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","ኑኒ ሎኦ አያና የሳራኔ ጌሸትꬃር ጾስ ጎይንታር ሳሮትꬅራኔ ዳጭ ጌዝ የስ የዞዳይ ጋርክ ካትታይስኔ ሹምታይ ኡባይስ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","የይ ጋርክ ዎሳይ ኑና አሽዛ ጾሳይ ቲና ሎኦኔ ኡፋይስዛባዚ። ");
INSERT INTO mfxe_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","ጾሲ አስ ኡባይ አቶዳይ ጋርከኔ ቱማ ኤሮዳይ ጋርክ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","ፐቲ ጾስ የዛ። ጾስስኔ አስስ ጋንጨ ማቂ ዳቦꬅዛ ፐታይ የዛ፤ ኤካ አስ ማቄዝ ክርስቶሳ የሱሳ። ");
INSERT INTO mfxe_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","ኤ አስ ኡባ ዎዞዳይስ ፋና ኣꬂ እንጌዛ። ጾሲ ፋ ዎደር አስ ኡባ ዎዞዳይስ ኮይዛና ቤዝዛ ማርካይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","ጾሲ ታና ዎንግለስ አስታማረኔ ሀዋረ ኡዲ ዶሬዛይ የይሲ። ታኒ ቱማ ኦድዛ፤ ዎርዶቶያ፤ አማኖኔ ቱማ ቃላ አይሁደ ማቀካ አሳይስ ታማርሶዳይ ጋርክ ጾሲ ታና ሹሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","የይ ግሾስ፥ ኡባ አቆ የዝ ꬊራꬅታይ፥ ፋና ጾሳይስ ዱማሲ፥ ዋችኔ ካች አሺ፥ ፋ ጌዤዝ ኩሽታ አፋ ደንꬂ ጾስ ዎሶዳይ ጋርክ ታ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","የይ ጋርከካ ማችታይ ፋ ኦማ ዳꬃራ ዎይ ዎርቃራ ዎይ እንቆ ዎርቃራ ዎይ አልኦ አፍላር ፋና ቡቁሮር ባዝን፥ ያሻትꬃራኔ ሃዮትꬃር ቤዝዛ ዎማኖትꬅ አፍላ ማኦ። ");
INSERT INTO mfxe_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","ዝን ጾሳይስ ታ ጎይንዛ ግዝ ማችታይ ፓስ ቤዝዛይ ጋርክ ሎኦ ባዝ ኦꬆ። ");
INSERT INTO mfxe_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","ማቺ ኡባ ባዛር ኪትንትꬃር ስእ ግ ታማሮ። ");
INSERT INTO mfxe_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ታኒ ማችታይ ታማርሶዳይ ጋርክ ዎይ ꬊራꬃል አፋ ማዉተ ኤኮዳይ ጋርክ ባዝን ስእ ግ የዞዳይ ጋርክ ኮይዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","አዳማ ቲና መꬍንቴዛ፤ ጉየፐ ህዋና መꬍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ዶሽንቴዛናኔ ጾስ ህጋ መንꬄዛን ማቻትፕ አትን አዳማ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","ዝን ማቺ አማኖር፥ ሲቆራኔ ጌሻትꬃር ፋና ሃሪ የዝኮ ናእታ የሎር አቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","ኦንካ፥ «ዎሳ ኬꬅ ካልꬅዛ አስ ማቆዳይስ ኮይኮ ሎኦ ባዝ አሞትዛ» ግዝ ኦዳይ ቱማ። ");
INSERT INTO mfxe_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","ዎሳ ኬꬅ ካልꬅዛ አስ ቦርንቶዋዛ፥ ፐቲ ማቾ ኣዳ ኤኬዛያ፥ ማራር የዛያ፥ ፋና ሃርዛያ፥ ቤዝዛይ ጋርክ ኦꬅዛያ፥ እማꬄ ሞክዛያ፥ ታማርሶ ዳንዳእዛያ፥ ");
INSERT INTO mfxe_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","ማꬆዋዛ፥ ዋላሶዋዛ፥ ፓላሞዋዛ፥ ሃዮ፥ ሚሸ ሲቆዋዛ፥ ");
INSERT INTO mfxe_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","ኤ ናእታይ ኤስ ኪትንትዛኔ ቦንችዝታያ፥ ፋ ካራ አሳ አቅሶ ዳንዳእዛያ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","ፐቲ አስ ፋ ካራ አቅሶዳይስ ዳንዳኣም እጽኮ፥ ጾስ ዎሳ ኬꬅ ዋይዚ አቅሶዳይስ ዳንዳኤ? ");
INSERT INTO mfxe_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","ኡትራር ኩሚ፥ ዳቡሎሳ ፕርድንቴዛይ ጋርክ ፕርድንታማይ ጋርክ፥ ሀጋ አማኔዝ አስ ማቆዳይስ ቤዞዋ። ");
INSERT INTO mfxe_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","ቦርንታማይ ጋርከኔ ጻላሄ ጽኬ ጋንጨ ገላማይ ጋርክ የ አꬃይ አማኖዋ አስ ካለ ሎኦ ማርካትꬂ የዛ አስ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","የይ ጋርከካ ማ ዎሳ ኬꬅ ዳቆንታይ ቦንችንቴዝታ፥ ናምኢ እንጻርስ ኦድንቶዋዝታ፥ ማꬅስዝ ኡሽ ኡዦዝታ፥ ሚሸ ዶሶዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","አማኖ ጹራ ጌሻ ካሃር ናግዝታ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","ኡንቲ ቲናቲ ፓጭንቶዳይስ ኮሽዛ፤ ኡንታል አፋ ቦረ ባዝታ ማቅኮ፥ ዎሳ ኬꬅ ዳቆነ ማቂ ኦꬆ። ");
INSERT INTO mfxe_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","የይ ጋርከካ፥ ማችታይ ቦንችንቴዝታ፥ ዝግሮዝታ፥ ማራር የዝታ፥ ኡባ ባዛር አማንንትዝታ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ዎሳ ኬꬅ ዳቆንታይ ፐቲ ማቻ ኣዳ የዛ ማቆ። ፋ ናእታኔ ፋ ካራ ሎእꬂ አቅስዝታያ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","ዎሳ ኬꬅ ዳቆነ ማቂ፥ ሎኦ ኦሶ ኦꬅዝታይስ፥ ኡንትስ ግታ ቦንቾ ቤዝዛ ማ ክርስቶሳ የሱሳል ፓስ የዝ አማኖ ባጋ ኦዶዳይስ ምኖትꬅ ደንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","ታኒ Ꮊ ኪታ ኔስ ጻፍታር፥ ኤልሲ ኔኮ የኦዳ ግ ኡፋይስ ጋድዛ። ");
INSERT INTO mfxe_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","ዝን ታኒ የኤካ ጋምእኮ፥ ጾስ ካራ አሳይ ዋይዚ የዞዳይስ ቤዝዛኮ ኤሮድ ጋርክ Ꮊያ ኔስ ጻፍዛ። ደኦ ጾስ ካራይ ቱማትꬅስ ቱስኔ ባሶ። ");
INSERT INTO mfxe_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","ኑ አማኖ ጹራይ ስ ባይꬅ ግታ። ክርስቶሳ አስ ማቂ በንቴዛ፤ ኤ ቱማትꬃ ጌሻ አያናይ ማርካቴዛ። ኪታንቾስ በንቴዛ፤ ኤ ካተትꬃይ ኡባይስ ሳባክንቴዛ። አላመል የዝ አሳይር አማንንቴዛ፤ ቦንቾር ሳሎ ኤክንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","ዉርስꬅ ዎደ ባልꬅዛ አያናታኔ ቱና አያንታይ ትምርታ ካሊ፥ ፐቲ ፐቲ አሳይ አማና ካዶዳና ጌሻ አያናይ ቆንጭሲ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","የይ ጋርክ ትምርተ ኡ ካሃይ ዶጭን፥ አሳ ባልꬅዛ ዎርዶ አስታማርታይፕ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","የይ ጋርክ አስታይ ኤኮኔ ገሎ ካይዛ፥ አማንዝታይኔ ቱማ ኤርዛ አስታይ ኤዛ ጋላትታር ማዳይ ጋርክ ጾሲ መꬌዝ ካꬃ «ሚፓተ» ግ ካይዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","ጾሲ መꬌዝ ባዝ ኡባይ ሎኦ። ጾሳ ጋላቲ ኤክኮ አላ ዎꬍዛባዝ አብካ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","ኡባ ባዝ ጾሳ ቃላራኔ ዎሳር ጌሽ ማቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ꮊ ትምርታ አማንዛ አሳ ታማርስኮ የሱስ ክርስቶሳስ ሎኦ አይለ ነ ማቃዳ። አማኖ ቃላኔ ነ ካልዛ ሎኦ ትምርታ ታማርኮ ነ ድጫይ ኤርንቶዳ ");
INSERT INTO mfxe_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","ዝን ማዴ ባ ቱማ ማቀካ ኦዳፐኔ ጭማ ማችታይ ካእዛ ቶሴፕ ሃኮባ። ጾስ ኣዞር ነና ሎህሶባ። ");
INSERT INTO mfxe_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","አሲ ፋ አሰትꬃ አሾ ኦሶስ ሎህሶ ጽቃ ዎደስ ማድዛ። ዝን ጾስ ኣዞ ሎህሳይ Ꮊተካ የኦድ ደኦስ ኡፋይስ የዝ ግሾስ ኡባባዝስ ማድዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Ꮊ ቃላይ አስ ኡባይ ኤኮዳይስ ቤዝዛ ቱሮ ኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","ኑኒ አስ ኡባ፥ ኡባፕ ኣꬂ አማንዝታ አሽዛ ደኦ ጾሳይፕ ኤኮድ ግ ኡፋይሳር ናግዛ ግሾስ፥ ኑኒ ኦሶር ዳቡርዛኔ ቡትትዛ። ");
INSERT INTO mfxe_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Ꮊያ አዛዞባኔ ታማርሶባ። ");
INSERT INTO mfxe_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","ኔኒ ናአ ማቄዝ ግሾስ ነና ኦንካ ለቂፐ። ዝን አማንዝታይስ ኔኒ ኦዳር፥ ኦሶር፥ ሲቆር፥ አማኖራኔ ጌሸትꬃር ኣዝሶ ማቆባ። ");
INSERT INTO mfxe_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","ታኒ የኦድ ሄሎዳይስ አሳይስ ጌሻ ማጻፋ ናባቦር፥ ሳባኮራኔ ታማርሶር ምንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","ትንቢተ ኦዶራኔ፥ ጭምታይ ፋ ኩሸ ኔል አፋ ጋዴዝ ዎደ ኔኒ ኤኬዝ፥ ኔል የዝ ጌሻ አያና እምታ ለቂፐ። ");
INSERT INTO mfxe_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","ነ ድጫይ አስ ኡባይስ ቆንጮዳይ ጋርክ የያ ሚንꬂ ቆፖባ፥ Ꮊያ ኡባ ዎደ ኦꬆባ። ");
INSERT INTO mfxe_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","ነ ኦማስኔ ነ ትምርታይስ ናግንቶባ። ኔኒ የያ ኡባ ዎደ ኦꬅኮ ነናኔ ነና ስእዝታ አሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","ꬊራꬅ ጭምታ ነ አደ ጋርክ ቦንቾር ዞሮባፕ አትን ካጭፐ። የላጋ ꬊራꬅታ ነ እሸ ኡዲ ቦኦባ። ");
INSERT INTO mfxe_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","ጭማ ማችታ ነ እንዲ ጋርክ፥ የላጋ ማችታ ነ ምሺ ጋርክ፥ ፎሎ ጌሸትꬃር ቦኦባ። ");
INSERT INTO mfxe_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","አዝኒ Ꮊይቄዝታ ቱማ ማዴ ኮሽዛ አምእታ ቦንቾባ። ");
INSERT INTO mfxe_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","ዝን አምእታይ ናእታይ ዎይ ናአ ናእታይ የዝኮ፥ የ ናእታይ ጾስ ኣዞ ቤዞዳይስ ፋና የሌዝትይስኔ፥ ፋ ዎጋ ኣይስኔ ዎጋ አደ ማዲ ኩሸ ማህꬅ ታማሮ። የይ ጾስ ኡፋይስዛ ባዚ። ");
INSERT INTO mfxe_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ፋ ኡባስ የዝ ቱማ አምአት ጾሳፕ ማዴ ደንጎዳይስ ኡፋይሳር ናግዛ። ጋላሳኔ ቃማ ጾሲ ፋና ማዶዳይ ጋርክ ዎስዛኔ ኦይጭዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","ዝን Ꮊ አላመል ሎኦ የስ ኣዳ ኮይዝ አምአት ፓꬅ የዛር Ꮊይቄዛኖ። ");
INSERT INTO mfxe_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","ኦንካ ኡንታን ቦራማይ ጋርክ Ꮊ ኪታ አስታ ታማርሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","ዝን ፋ ዳቦስ፥ ኡባይፕ ኣꬂ ፋ ካራ አሳይስ ቆፖዋ ኦንካ ፋ አማና ካዴዛ፤ አማኖዋ አሳፐካ ኣꬌዝ ኢታ። ");
INSERT INTO mfxe_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","ላይꬂ ኡሱፑን ታም ኩመካ አዝኒ Ꮊይቄዝ ማችታ አምኤ ሱንꬅ ማዝጋባል ጻፍፐ። ማ የይል አፋ ፐቲ አዝና የዛኖ ማቆዳይስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ናእታ ድሾር፥ እማꬄ ሞኮር፥ ጌሽታይ ቶኬ ሜቻር፥ መትንትዛ አሳ ማደር፥ ሎኦ ኦሶ ኡባይስ ፋና ኣꬂ እንጌዛኖ ሎኦ ኦሶር ኤርንቴዛኖ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","ዝን አዝንታይ Ꮊይቄዝ ናአትꬅ ማችታይ ሱንꬃ ማዝጋባ ጻፕፐ። ኡንታን አዝን ገሎ ገሎ ግዝ አሾ አማይ አይክዝ ዎደ ክርስቶሳ ካዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","ኡንቲ ቲና ገሌዝ ቃላ መንꬄዝ ግሾስ ፕርድንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","የይል አፋ ኡንቲ ኦሶ ꬋብን ኬꬃፕ ኬꬅ ዩዮዳ። ዩሻ ኣዳ ባዝን ሀዎዛራኔ ፋና ገልሶዋ አቆ ገሊ ቤዞዋባዚ ኦድንትንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","የይ ግሾስ፥ ኑ ሞርክታይ ኑል አፋ ኦድንትዛ ኢታ ባዝ ደንጋም ጋርክ ናአትꬅ ማችታይ አዝን ገሊ፥ ናአ የሊ፥ ፋ ኬꬅ አቅሶዳይ ጋርክ ታ ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Ꮊይፕ ቲና ፐቲ ፐቲ አዝኒ Ꮊይቄዝ ማችታይ ጻላሄ ካሊ አማኖ ኦገፕ ባለ ከዜዝ። ");
INSERT INTO mfxe_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","ፐቲ አማንዛ ማች አስታ ፋ ካራ ማችታይ የዝኮ እዛ ኡንታን ማዶዳይስ ቤዝዛ። የይ ጋርክ ኦꬅኮ፥ ዎሳ ኬꬅስ ቶፓይ ሻዉክዛ። የ ዎደ ዎሳ ኬꬃይ ማዴ ቤዝዛ ቱማ ማችታ ማዶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","ዎሳ ኬꬅ ሎእꬂ ሄንግዝ ጭምታይ፥ ኡባይፕ ኣꬂ፥ ቃላ ሳባኮራኔ ታማርሶር ዳቡርዝታይ ዳኮ ቦንቾ ኤኮዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","ጌሻ ማጻፋይ፥ «ዉዱማ ካꬃ የꬍዝ ገማታይ ዶና አጭፐ» Ꮊይ ጋርክ፥ «ኦሳንቻይ ፋ ዳሞዛ ኤኮዳይስ ቤዝዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ናምኢ ዎይ ሀይꬒ ማርካ ማርካተካዝን፥ ዎሳ ኬꬅ ጭማል አፋ ሺቄዝ ሞቶ ስእፐ። ");
INSERT INTO mfxe_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Ꮊንክታይ ያሽቶዳይ ጋርክ ናጋራ ኦꬅዛ ኦናካ አስ ኡባይ ቲና ጋይሎይታ። ");
INSERT INTO mfxe_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","ኔኒ አስ ስኖ በኤካ፥ ፐታ ፐታይፕ ሻከካ Ꮊ ኪታ ናጎድ ጋርክ ጾሳ፥ ጎዳ የሱስ ክርስቶሳኔ ማራጽንቴዝ ኪታንችታይ ቲና ታ ነና ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","ኦል አፋካ ነ ኩሸ ጋዲ ሹሞዳይስ ኤለስፐ። ሃርታይ ናጋራይድ ገልፐ፤ ነና ጌሸትꬃር ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ኔኒ ኡባ ዎደ ሀርግንትዛ ግሾኔ ነ ኡሎ ሀርጋይ ግሾስ ሃꬅ ኣዳ ኡዥፐ፤ ጽቃ ዎይነ ኡዦባ። ");
INSERT INTO mfxe_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","ፐቲ ፐቲ አስታይ ናጋራይ ቆንጨ፤ ኡ ናጋራይ ኡንታን ፕርዶዳይስ ኡንታፕ ቲና ኣꬍዛ፥ ዝን Ꮊንክታይ ናጋራይ ጉየፐ ጋምኢ ቆንጭዛ። ");
INSERT INTO mfxe_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","የይ ጋርክ፥ ሎኦ ኦሳይካ ቆንጨ፤ ቆንጨር ኦꬃም እጽኮካ ጌሞዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","ጾስ ሱንꬃይኔ ኑ ትምርታይ ጫዥንታማይ ጋርክ አይለትꬃ የዝታይ ፋና ሃርዛ ጎድታ ቦንቾ። ");
INSERT INTO mfxe_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","አማንዛ ጎድታይ የዝ አይልታይ፥ ኡ ጎድታይ ኡንትስ እሸ ማቄዝ ግሾስ ኡንታን ለቂፐ። ኡ ኦሳይድ ማድንትዛ ጎድታይ፥ አማንንቴዝታኔ ዶስንቴዝታ ማቄዝ ግሾስ ኡንቲ ካሴሳይፕ ኣꬂ ኦꬆዳይስ ቤዝዛ። ኔኒ Ꮊያ ታማርሶዳይስኔ ኡ ኡዶድ ጋርክ ዞሮዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","ኦንካ ዱማ ትምርተ ታማርስኮ፥ ኑ ጎዳ የሱስ ክርስቶሳ ቱማ ቃላራይኔ ኑ አማኖ ትምርታይር ዎል ሄሎያ። ");
INSERT INTO mfxe_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","የ አꬃይ ኡትራር ዳፕንትነፕ አትን አኮካ ኤሮያ። ኡንትስ ፐቲ ቆፋል አፋ ፓላሞዳይስኔ ካጮዳይስ ኢታ አሞ የዛ። የይ ቃናተ፥ ዋላሰ፥ ጫሸ፥ ኢታ ስኔ፥ ");
INSERT INTO mfxe_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","ጊጎዋ ፓላማ ካልꬅዛ። ማ ኡንትስ ዡጫ ዎዝና የዛ፤ ቱማካ ባሌዛ፤ ኡንቲ ጾስ ጎይኖ ዱረትꬅ ደንጎዳይስ ኦገ ግ ቆፕዛ። ");
INSERT INTO mfxe_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","ዝን ታስ የዛና ግዶዳ ግዝ አስስ ጾሳ ጎይኖ ግታ ዎ። ");
INSERT INTO mfxe_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","ኑኒ Ꮊ አላማ አብካ ኤኪ የኤካያ። ማ ኤፕ አኮካ ኤኪ Ꮊንጋሚ። ");
INSERT INTO mfxe_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","ኑስ ካꬃኔ ማኦ የዝኮ የይ ግዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","ዝን ዱረትꬂ ኮይዝታይ ፓጨኔ ጽሄ ጋንጨ ገልዛ። አስ ቦዝꬅዛኔ ቆህዛ ኢታ አሞር ፖክዛ። ");
INSERT INTO mfxe_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","ሚሸ ሲቆ ኢታትꬅ ኡባይስ ፑልቶ። ፐታይ ፐታይ ሚሸ አሞትታር አማኖፕ ባልንቲ ጋመ ኡንአኔ አዛኖ ጋንጨ ፋና ኦሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","ጾሳ አሶ፥ ኔኒ የይፕ ሃኮባ። ጽሎትꬅ፥ ጾስ ጎይኖ፥ አማኖ፥ ሲቆ፥ ዳንዳአኔ ሃዮትꬂ ካሎባ። ");
INSERT INTO mfxe_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","አማኖ ቡተ ሎእꬅ ቡትቶባ። ነ ጼግንቴዝ ዎደ ጋመ አሳይ ቲና ነ ሉለ ማርካቴዝ መꬍና ደአና አይኮባ። ");
INSERT INTO mfxe_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","ኡባይስ ደኦ እንግዝ ጾስ ቲናኔ፥ ጰንጸ ጵላጾሳ ቲና ሎኦ ማርካ ማርካቴዝ ክርስቶስ የሱሳ ቲና ታ ነና አዛዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ኑ ጎዳ የሱስ ክርስቶሳ ቆንጮድ ሄሎዳይስ Ꮊ አዛዛ ቡታኔ ቦሮ ባይꬅ ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","ፋ ኣዳ ኡባ ሃርዛ ቦንቾ ጾሳይ፥ ካትታይ ካታይ፥ ጎድታይ ጎዳይ፥ ፋ ቆፔዝ ቃማ የሱስ ክርስቶሳና ማሂ ኪቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","ፐቲ ኤ ኣዳይ Ꮊይቆዋዛ። ኦንካ ሺቆዳይስ ዳንዳኦዋ ፖኦ የዛ። ኦንካ ኤዛ በኤካያ፤ ማ በአዳይስካ ዳንዳኦያ። ቦንቾኔ መꬍና ዎልቃይ ኤስ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Ꮊ አላመ ዱርታይ ጨረ ꬋብዝ ሻሎር ኡፋይስ ጋዳማይ ጋርከኔ ጬቃማይ ጋርክ ኦዶይታ። ኑስ ቤዝዛ ባዝ ፑጭሲ እንግዛ ኑና አንጅዛ፥ ዱረ ጾሳይል አማንንቶዳይ ጋርክ ኡንታን አዛዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","ኡንቲ ሎኦ ኦሶ ኦꬆዳይ ጋርክ ሎኦ ኦሶር ዱርቶዳይ ጋርክ፥ ኬህታኔ ሀራስ ሻክዝታ ማቆዳይ ጋርክ አዛዞባ። ");
INSERT INTO mfxe_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","የይ ኡንትስ ቲናስ ምኖ ባሶ ማቄዝ ግሾስ የ ዎደ ኡንቲ ቱማ ደአይ አብ ኣዝዛኮ ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","ጽማቶሳ፥ ፐቲ ፐቲ አሳይ፥ «ኤራትꬂ» ግዝ ቦዞ ፓላማፐኔ ጨረ ኦዳይፕ ሃኮባ፤ ኔስ እንግንቴዝ ሀዳራ ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ፐታይ ፐታይ ኑስ ኤራትꬂ የዛ ዬግታር አማና አሼዛ። ጾስ ኣꬎ ኬሃትꬃይ ይንታር ኡባይር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","ጾስ ሸነር፥ የሱስ ክርስቶሳፕ በንቴዝ ደኦ ኡፋይሳፕ ደንዴዛይድ የሱስ ክርስቶሳስ ሀዋረ ማቄዝ ጳዉሎሳፕ፥ ");
INSERT INTO mfxe_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ታ ዶስዛ ናአ ጽማቶሳስ፤ ጾስ አዳይፐኔ ኑ ጎዳ ክርስቶሳ የሱሳፐ ኣꬎ ኬሄትꬅ፥ ማሮትꬅኔ ሳሮትꬅ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ታኒ፥ ታ ዎሳይድ ቃማኔ ጋላስ ነና ቆፕዛ። ታኒ ዎስዛ ዎደ ታ አድታይ ጋርክ ታ ሎኦ ካሃር ኤስ ኦꬅዛ ጾሳ ነ ግሾስ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","ታኒ ነ አፉꬃ ቆፕዛ፤ ነና ብኢ ኡፋይትዛና ጋመ ላሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","ማ ኔስ የዝ ቱማ አማና ኤርዛ። የ አማናይ ብኒ ነ ዎጋ እንዳት ሎይድራኔ ነ እንዳት ኤዉንቀስ የዝ አማናይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","የይ ግሾስ፥ ታኒ ታ ኩሻ ኔል አፋ ጋዴዝ ዎደ ጾሲ ኔስ እንጌዝ እሞታ ኔኒ ማሂ ኤꬆዳይ ጋርክ ታ ነና ቆፍስዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","አብስ ጊኮ፥ ጾሲ ኑስ ዎልቃ፥ ሲቆኔ ኑ ኡባ ሃርዛ ጌሻ አያና እንጌዛፕ አትን ያሻ አያና እንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ይኬ፥ ኑ ጎዳይስ ማርካቶዳይስ ዬላትፐ፤ ማ ኤ ግሾስ አጭንቴዝ ታ ባጋራካ ዬላትፐ። ዝን ጾሲ ኔስ እንግዛ ዎልቃር ዎንግለ ግሾስ ታር መቶ ኤኮባ። ");
INSERT INTO mfxe_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ጾሲ ፋ ሸነራኔ ፋ ኣꬎ ኬሄትꬃይር ኑና ዱማሲ፥ ፋ ጌሻ ዎያ ኡዶዳይስ ኑና ዶሬዛፕ አትን ኑኒ ኦꬄዝ ኦሶ ግሾስ ባያ። Ꮊ ኣꬎ ኬሃትꬃ ክርስቶሳ የሱሳ ባጋር አላመ መꬊንቶዳይፕ ቲን ኑስ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Ꮊት Ꮊ ኣꬎ ኬሄትꬃይ ኑና አሽዛ ክርስቶስ የሱሳ ይእꬃይር በንቴዛ። ኤ Ꮊይቆ ዎልቃ ꬋብሲ፥ ዎንግለ ባጋር Ꮊይቆዋ ደኦ ኑስ ቆንጭሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","ታኒ ዎንግለ ሳባኬ፥ ሀዋረኔ አስታማረ ማቃዳይ ጋርክ ጾሲ ታስ ማዉተ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ታኒ የይ ግሾስ Ꮊ መታ ኤክዛ፤ ዝን ታ አማኔዛይ ኦናዛኮ ኤርዛ ግሾስ ዬላታሚ። ታስ እንግንቴዝ ሀዳራ የሱሳ ማቂ የኦድ ጋላሳይ ሄሎዳይስ ኤ ናጎዳይስ ዳንዳእዛና ታ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","ታኒ ነና ታማርሴዝ ቱማ ቃላ ኣዝሶ ኦሳ አይኪ ክርስቶሳ የሱሳር የዝ አማናይራኔ ሲቃይር የዞባ። ");
INSERT INTO mfxe_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","ኑ ጋንጨ የዝ ጌሻ አያና ዎልቃር ኔስ እንግንቴዝ ሎኦ ሀዳራ ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","ኢሳ አዉራጃ የዝ ኡባይ ታፕ ሃኬዛና ነ ኤርዛ፤ ኡ ጋንጨ ፍገሉሳራኔ ሄርሞገኔሳራ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","አነስፎራ ታና ኡንደና ዎደ ምንꬃꬄዝ ግሾስ ጎዳይ ኤ ካራ አሳይስ ቃꬊንቶ። ታኒ አች ካራ የዝ ዎደ ኤ ታ አቻይዳካ ዬላተካያ። ");
INSERT INTO mfxe_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","የይል አፋ ኤ ኦሮመ ካታማ የኤዛን ጋርክ ታና ሚንꬂ ኮይ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","ዉርስꬅ ጋላስ ጎዳይ ኤስ ቃꬊንቶዳይ ጋርክ ታኒ ጎዳ ዎስዛ። ኤፈሶና ካታማ የዝ ዎደ ኤ ታና አብ ጋርክ ማዴዛኮ ነ ሎእꬂ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","ይኬ፥ ታ ናአዮ፥ ክርስቶሳ የሱሳር የዝ ኣꬎ ኬሄትꬅይር ምንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","ጋመ ማርክትꬃር ቲና ታኒ ነና ታማርሴዝ ትምርታ፥ ሀራ ታማርሶዳይስ ዳንዳእዛ አማንንቴዝ አሳይስ ሀዳራ እንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","የሱስ ክርስቶሳስ ሎኦ ዎታዳረ ማቂ ታር ዎላ መቶ ኤኮባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","ዎታዳረ ፋና አዛዜዝ ፋ ሀላቃ ኡፋይሶዳይስ ጊግንትዛይፕ አትን ሀራ ኦሶር ፋና ግቶያ። ");
INSERT INTO mfxe_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","የይ ጋርከካ፥ ኣላሎ ዎጽዛ ኦንካ ህጋይስ ቤዝዛ ኦገር ዎጻም እጽኮ ጋምꬅ ዎይቶ ኤኮያ። ");
INSERT INTO mfxe_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","ቢታ ዎታር ዳቡርዛ ኦሶ አꬃይ ፋ ዳቡራ ኣፋይፕ ሚዝ ቲና አስ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","ጎዳይ ኡባባዛር ኔስ አካካ እንጎድ ግሾስ ታ ኔስ ኦዴዝባዛና ነ ዎዝናይድ ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","ታኒ ማርካትዝ ዎንግላይ Ꮊያ፥ Ꮊይቆፐ ደንዴዝ፥ ዳዉተ ዘረꬅ ማቄዝ የሱስ ክርስቶሳ ቆፖባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ታኒ ዎንግለ ኦድዛ ግሾስ ዳፋ ኦꬄዝ አስ ጋርክ፥ አጭንቲ መቶ ኤኬዛ። ዝን ጾሳ ቃላይ አጭንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","የይ ግሾስ፥ ጾሲ ማራጼዝ አስታይ ክርስቶሳ የሱሳፕ ደንጌዝ አቶትꬃይ ባጋር መꬍና ቦንቾ ኤኮዳይ ጋርክ ኡ ግሾስ ኡባ ባዛር ታ ዋይዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Ꮊይ ጋርክ ዬግዝ ቃላይ አማንንቴዛያ፤ «ኑኒ ኤዛር Ꮊይቄዝ ባዝ ማቅኮ፥ ኤዛር ዎላ ደኦር የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","ኑኒ ጋርዦር ምንግኮ፥ ኤዛር ዎላ ካዉቶዳ። ኑኒ ኤዛ ካድኮ፥ ኤዝካ ኑና ካዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","ኑኒ አማንንታም እጽኮ፥ ኤ አማንንቴዛያ ማቂ የዞዳ። አብስ ጊኮ፥ ኤ ፋና ካዶዳይስ ዳንዳኦያ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","ኔኒ ኡንታን Ꮊያ ቆፕሶባ፤ ኡ ቃላይፕ ደንዴዛይድ ፓላማማይ ጋርክ፥ ጾስ ቲና ኡንታን ዞሮባ። የይ ስእዝታ ꬋብስዛፕ አትን አኮካ ማዶያ። ");
INSERT INTO mfxe_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","ኔኒ ቱማ ቃላ ሉለትꬃር ታማርስዛኔ ዬላꬆዋ ኦሶ አስ ማቂ፥ ጾሳር ዶስንቴዝ አስ ጋርክ፥ ነናትꬃ ኤስ እንጎዳይስ ምንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","ዝን Ꮊ አላማይስ ሀንዛ ማዶዋ ባልቡቂꬅ ኦዳይፕ ሃኮባ። የይ ጋርክ ኦዳይ አስ ጾሳፕ ሃክꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","የይ ጋርክ ትምርታይ አሰትꬅ ም ሃስዝ ጭቶ ክጻ ጋርከ። የይ ጋርክ ኦዳ ኦድንትዝታይ ጋንጨፕ ሄመኖሳራኔ ፍልጾሳር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Ꮊ አስታይ ቱማ ኦጋ አሺ፥ «Ꮊይቄዝ አሳይ Ꮊይቆፐ ብኒ ደንዴዛ» ዬጊ ፐቲ ፐቲ አስታይ አማና ꬋብሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ሀኖ ዝን፥ «ጎዳይ ኤስ ማቄዝታ ኤርዛ» ኡባራክ «ጎዳይ ሱንꬅ ጼግዝ ኦንካ ኢታ ኦሶፕ ሃኮ» ዬግዝ ማታመር የዝ ኤንኦዋ ጾስ ባሳይ ሚንጊ የዞዳ። ");
INSERT INTO mfxe_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","ፐቲ ዳማ ኬꬃ ዎርቃፕ ዎይ ብራፕ ኦስንቴዝ ሚሸ ኣዳ ባዝን ምꬃፐኔ ዢጨ ቢታፕ ኦስንቴዝ ሚሽታይካ የዛ። የይትታይፕ ባግታይ ቦንቾ ኦሶስ፥ ማ ባግታይ ቶሽንትዛ ኦሶስ ፔዥዛ። ");
INSERT INTO mfxe_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","የይ ግሾስ፥ ኦንካ ኢታ ኡባ አሽኮኔ ፋና ጌሽኮ፥ ቦንቾ ኦሶ ኦꬅዛ ሚሸ ማቆዳ። ኡ የሳይ ጌሽኔ ጎዳ ኡፋይስዝ ባዝ፥ ማ ኡንቲ ሎኦ ኦሶ ኡባ ኦꬆዳይስ ዳንዳእዝታ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","ናአትꬅ ኢታ አሞትꬃፐ ሃኮባ። ጌሽ ዎዝናር ጎዳ ጼግዝ አሳይር ፐትፕ፥ ጽሎትꬅ፥ አማኖ፥ ሲቆኔ ሳሮትꬅ ካሎባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","ዝን ካች መꬍዛና ኤሪ ቦዘትꬅኔ ጨረ ፓላማፕ ሃኮባ። ");
INSERT INTO mfxe_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","ጎዳ ኦሳንቻይ አስ ኡባይስ ኬሃ፥ ሎኦ ታማርስዛኔ ዳንዳአንቾ ማቆዳይስ ቤዝዛፕ አትን ካጭንቶዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","ኤ ፓር ኤቅንትዝታ አሽከትꬃር ሴርዛ ማቆዳይስ ቤዝዛ። ኡንቲ ፋ ናጋራይፕ ማቂ ቱማ ኤሮዳይ ጋርክ ጾሲ ኦꬆዳዛኮ ኦኒ ኤረ። ");
INSERT INTO mfxe_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","ኡንቲ ፋ ዎዛናኮ ማቂ ፋ ሸነ ኡዶድ ጋርክ ኡንታን አይኬዝ ጻላሄ ጽካይፕ ቡቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","ዉርስꬅ ጋላስ ኡንእꬅዛ ዎደ የኦዳና ኤሮባ። ");
INSERT INTO mfxe_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","አሳይ ፋና ዶስዝታ፥ ሚሸ ዶስዝታ፥ ጬቅንትዝታ፥ ኡትርትዝታ፥ ጫዥዝታ፥ ፋና የሌዝታይስ ኪትንቶዝታ፥ ጋላቶዝታ፥ ጌሸትꬂ ባዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ሲቆ ባዝታ፥ ማሮዝታ፥ ዝግርዝታ፥ ፋና ሃሮዝታ፥ ቃ ባዝታ፥ ሎኦ ዶሶዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","ካድዝታ፥ ኤልስዝታ፥ ኡትራር ዳፍንትዝታ፥ ጾሳፕ ኣꬂ አሾ ኡፋይሶዳይስ ዶስዝታ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","ኡንቲ ጾስ ጎይንዝታ ኣዝዛፕ አትን ኤ ዎልቃ ካድዝታ፤ ኔኒ የይ ጋርክ አሳይፕ ሃኮባ። ");
INSERT INTO mfxe_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","ኡንታፕ ፐታይ ፐታይ አስ ካራ ዙርቅንቲ ገሊ ጋመ ናጋራ ዶርንቴዝታኔ ዱማ ዱማ አሞር ጹግንትዝ አያና ዳቡሬዝ ማችታ ባልꬅዝታይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","የ ማችታ ኡባ ዎደ ታማርስዛ፥ ዝን ቱማ ኤሮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","ያነሳኔ ያምባሬሳ ሙሰር ኤቅንትቴዛይ ጋርክ Ꮊ አስታይ ካሃ ኦꬆዝታኔ አማኖር ዳቡሬዝ አስታ ማቄዝ ግሾስ ቱማር ካዝንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","ዝን ኢያነሳኔ ኢያምብሬሳ ቦዘትꬃይ ቆንጬዛይ ጋርክ ኡ ቦዘትꬃይካ አስ ኡባይ ቲና ቆንጮድ ግሾስ ኡንትስ ሀነና። ");
INSERT INTO mfxe_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","ዝን ኔኒ ታ ትምርታ፥ ታ የሳ፥ ታ ቆፋ፥ ታ አማና፥ ታ ዳንዳአ፥ ታ ሲቃ፥ ታ ጋርዣ፥ ");
INSERT INTO mfxe_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","ታ ባይእንትꬃኔ ታ መታ ነ ኤርዛ። አንጾካ፥ ኢቆኖነ፥ ልስጽራ ካታምታይድ ታና ሄለዝባዝኔ ታኒ ዳንዳኤዝ መታ ነ ኤርዛ፤ ጎዳይ ታና የ ኡባይፕ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","ክርስቶሳ የሱሳር ጾስ ኡፋይስዛ የስ የዞዳይስ ኮይዝ ኡባይ ባይእንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ኢታ አሳይኔ ባልꬅዝታይ ፓስ ባልንትታራኔ ሀርታ ባልꬅታር ካሴሳይፕ ኣꬂ ኢትታር ኢትታር Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","ዝን ነ ታማሬዛይዳኔ ነ አማኔዝ ቱማይድ ሚንጊ ኤቆባ። ነ ኦፕ ታማሬዛኮ ነ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","ኔኒ ነ ናአትꬃፕ አይኪ ክርስቶሳ የሱሳ አማኒ አቶትꬅ ደንግዝ ኤጨትꬅ እንጎዳይስ ዳንዳእዛ ጌሻ ማጻፍታ ታማሪ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","ጌሻ ማጻፈ ኡባይ ጾስ አያና ጻፎድ ባዝ እንግን ጻፕንቴዝ ቃላ። የ ማጻፋይ ቱማ ታማርሶዳይስ፥ ባልንቴዝታ ሴሮዳይስ፥ ቡታ ሉልሶዳይስኔ ጽሎትꬅ የስስ ኮሽዛ ባዝ ዞሮዳይስ ማድዛ። ");
INSERT INTO mfxe_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","ጾስ አሲ ፖሎኔ ሎኦ ኦሶ ኡባይስ ጊግንቴዛ ማቆዳይ ጋርክ ማድዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","ታኒ ነና ጾስ ቲና፥ ፓꬅ የዝታይላኔ Ꮊይቄዝታይል ፕርዶዳይስ የዝ ክርስቶሳ የሱሳ ቲና ኤ ቆንጭꬃይራኔ ኤ ካተትꬃይር ዞርዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ቃላ ሳባኮባ፤ ዎደ ጊግን ጊገካ አትን ሚንጊ ማርካቶባ። ጋመ ዳንዳአራኔ ታማርሶር አሳ ዞሮባ፥ ሴሪ ሉልሶባኔ ደንꬅꬆባ። ");
INSERT INTO mfxe_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","አሳይ ቱማ ትምርተ ስኣም እጾድ ዎደ የኦዳ። ኡንቲ ፋ አሞ ካሊ፥ ፓስ ስኦዳይስ ኡፋይስዝ ባዝ ኦድዝ አስታማርታ ሺሾዳ። ");
INSERT INTO mfxe_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","ኡንቲ ቱማ ባጋ ኦድዝ ትምርተ አሺ፥ ቱማ ማቀካ ኦዳ ስኦዳይስ ፋ ሀየ ማሆዳ። ");
INSERT INTO mfxe_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","ዝን ኔኒ ኡባ ባዛር ናግንቶባ። መቶ ዳንዳኦባ። ዎንግለ ማርካትꬃ ኦሶ ኡዶባ። ኔስ እንግንቴዝ ጾስ ኦሶ ኡባ ፖሎባ። ");
INSERT INTO mfxe_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","ታኒ ያርሾ ያርሽዛይ ጋርክ ያርሽንቶዳይስ ዎዳይ ሄሌዛ፤ Ꮊ አላማ አሺ Ꮊንግዛ ዎዳይ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","ታኒ ሎኦ ኦላ ኦልንቴዛ፤ ታ ኣላሎ ላሳ ሃሴዛ፤ አማና ናጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Ꮊይፕ ጉየስ ጽሎትꬅ ዛዉደ ታና ናግዛ። የያ ጌሽ ፕርዳ ፕርድዝ ጎዳይ የ ጋላስ ታስ እንጎዳ። የይ ታ ኣዳስ ባዝን ኤ ማቂ ይእꬃ አሞትዝ ኡባይስ እንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","ኤልሲ ታኮ የኦዳይስ ምንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","ዴማሳ Ꮊ አላማ ዶሲ፥ ታና አሺ፥ ተሰሎንቀ ካታማ ቅቴዛ። ቀርቅስማ ጋላትያ፥ ትቶኔ ድልማጻ ቢታ ቅቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ሉቃሳ ኣዳ ታር የዛ። ማርቆሳ ጾስ ኦሶር ታና ማዶዳይስ ዳንዳእዛ ግሾስ ኔር ኤኪ የኦባ። ");
INSERT INTO mfxe_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","ታኒ ትክቆሳና ኤፈሶና ካታማ ኪቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ኔኒ ይእታር፥ ጽሮአዳ ካታማ ካርፖሳ ላንቀ አሺ የኤዝ ታ ኮታኔ ማጻፍታ ታስ ኤኪ የኦባ። ኡባይፐካ ጻꬅ ማጻፍታ ኤከካዛር ይእፐ። ");
INSERT INTO mfxe_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","ጻርቂማለ ኦꬅዝ ኢስክንድረ ታና ኢታ ቆሄዛ፤ ጎዳይ ኤ ኦሳይ ጋርክ ኤስ ጭጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","ኤ ኑ ትምርታ እጽዛ ግሾስ ኤፕ ነና ናጎባ። ");
INSERT INTO mfxe_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","ቲና ታ ሞትንቴዝ ዎደ ኡባይ አሺ ቅቴዛፕ አትን ኦንካ ታና ማደካያ። ጾሲ የ ቡታ ኡንትስ ታይብፐ። ");
INSERT INTO mfxe_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","ዝን ታኒ ኩንꬅ ኪታ አይሁደ ባ አስ ኡባይስ ማርካትን፥ ኡንቲ ስኦዳይ ጋርክ ጎዳይ ታ ካንታ ኤቂ ታስ ዎልቃ እንጌዛ። ማ ጋሞ ጋርክ ዶና ዶዬዝ Ꮊይቆፕ ታና አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ጎዳይ ታና ኢታ ኡባይፕ አሺ ሳሎ ካተትꬅ ሳሮር ሄልꬆዳ። ኤስ መꬊናፕ መꬍና ሄሎዳይስ ቦንቾ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ጵርስቅላስ፥ አቂላስኔ አነስፎራ ካራ አሳይስ ታ ሳሮꬃ ሄልꬆባ። ");
INSERT INTO mfxe_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ኤራስጾሳ ቆሮንቶሳ ካታማ አቴዛ። ጽሮፍሞሳ ሀርግንቴዝ ግሾስ ምልጸ ካታማ ኤዛ አሼዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","ባርጎ ገሎዳይፕ ቲና ኤልሲ የኦባ። ኤዉቡሎሳ፥ ጱዴሳ፥ ልኖሳ፥ ቅላደኔ ሀራ አማንዛ አስታይ ኡባይ ነና ሳሮ ሳሮ ግዛ። ");
INSERT INTO mfxe_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ጎዳ የሱስ ክርስቶሳ ኔር ማቆ። ጾስ ኣꬎ ኬሄትꬃይ ይንታር ኡባይር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","የሱስ ክርስቶሳ ሀዋረኔ ጾስ አይለ ማቄዝ፥ ጳዉሎሳ፥ ጻፌዝ ዳብዳበ። ጾሲ ዶሬዝ አሳይ አማና ድቾድ ጋርከኔ ቱማ አያና የስ ዋይዚ የሳዳዛኮ ቤዝዛ ቱማ ኤረትꬅኮ ኡንታን ካልꬆዳይስ ታኒ ኪትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","የ አማናይ መꬍና ደኦ ኡፋይሳል አፋ ኤቄዛ። የይ ጋመ ዎደፕ ቲና ዎርዶቶዋ ጾሳይ ኑስ እንጎድ ግ ቃላ ገሌዛያ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","ኑና አሽዛ ጾሳይ ፋ ዎደ ሄልን Ꮊ ኪታ ኦዶዳይ ጋርክ ታስ ሀዳራ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","ኑስ ኮꬄ ማቄዝ አማናይድ ታስ ቱማ ናአ ማቄዝ ትቶስ፥ ጾስ አዳይፐኔ ኑና አሽዛ የሱስ ክርስቶሳፕ ኣꬎ ኬሄትꬃይ፥ ማሮትꬃይኔ ሳሮትꬃይ ኔስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","ታኒ ነና ቃርጼሳ አሼዛይ፥ ኔኒ አቴዝ ባዝ ሎእꬆድ ጋርከኔ ታኒ ኪቴዛይ ጋርክ ካታማ ኡባይድ ዎሳ ኬꬅ አቅስዝታ ዶሮድ ጋርከሲ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","ዎሳ ኬꬅ ጭማ ቦርንቶዛ፥ ፐቲ ማቻት አዝን፥ የዳ የሳር ዎይ ኪትንቶ እጾር አሲ ቦሮዋ አማንዛ ናእታይ የዝ አስ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","ዎሳ ኬꬅ አቅስዝታይ ጾስ ኦሶ ሀዳራ ኤኬዝ ግሾስ ቦርንቶዛ፥ ኡትርቶዛ፥ ኤልሲ ይሎቶዛ፥ ማꬆዛ፥ ኦዳ ኮዮዛኔ ቤዞዋ አዳስ ኩኩሮዛ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","ዝን እማꬅ ሞክዛያ፥ ሎኦ ባዝ ኡባ ቃꬍዛያ፥ አካካር የዛያ፥ ሱረ፥ ጌሽኔ ፋና ሃርዛያ ማቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","ቱማ ትምርተ ታማርሶራ፥ ዞረራኔ የ ትምርታ እጽዝታይስ ማህꬅ እንጎዳይስ ፋ ታማሬዝ አማንꬅዛ ቃላይል ሚንጊ ኤቆ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","ኪትንቶዝታይ፥ ፓꬆዋ ኦዳ ኦድንትዝታይ፥ ዶሽዝታይ ኡባራካ ዶካልንቶ ዎጋ ናግዛ ጋመ አስታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","ኡንቲ ቤዞዋ ኦገር ሚሸ ደንጎዳይስ ኮዪ፥ ቤዞዋ ባዝ ታማርስታር ካራ አስ ኡባ ቡቂዝ ግሾስ ኡ ትምርታ ተቆዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","ኡንታፕ ፐታይ ኡንትስ ናበ ማቄዛይ፥ «ቃርጼሳ አሳይ ኡባ ዎደ ዎርዶ ኦድንትዝታ፤ ኢታ ዶእታኔ አዛላ ናፍሳምታ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Ꮊ ማርካትꬃይ ቱማ። የይ ግሾስ፥ ኡንትስ ቱማ አማኖ የዞዳይ ጋርክ ኡንታን ካጮይታ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","ቱማ እጽዛ አሳይ ትምርታኔ አይሁድታይ ፓꬆዋ ቶሳ ስአማይ ጋርክ ኡንታን ሚንꬂ ሴሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","ጌሽታይስ ኡባ ባዝ ጌሺ፥ ዝን ቱንታይስኔ አማኖዝታይስ ኡ ቆፋይኔ ካሃይ ቱኔዝ ግሾስ ኡንትስ አብካ ጌሺ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","ኡንቲ ኑ ጾስ ኤርዛ ግዛ፥ ዝን ፋ ኦሳይር ኤዛ ካድዛ። ኡንቲ ጾሳር እጽንቴዝታ፥ ኪትንቶዋዝታኔ ሎኦ ኦሶ ኡባ ኦꬆዳይስ ፒልዝታ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","ዝን ኔኒ ደኦ እንግዝ ትምርታ ቤዝዛይ ጋርክ ታማርሶባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","ዎዛንቶ ꬊራꬅታይ ፋና ሞድዝታ፥ ጊጋር የዝዝታ፥ ቦንችንቴዝታ፥ አማኖር፥ ሲቆራኔ ዳንዳአር፥ ምንጎድ ጋርክ ዞሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","የይ ጋርከካ፥ ዎዛንቶ ማችታይ ፋ የሳይድ ጌሽታ፥ ሀዎዞዋዚታ፥ ኡሽ ዣሮዝታኔ ሎኦ ባዝ ታማርዝታ ማቆዳይ ጋርክ ታማርሶባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","ኡንቲ Ꮊይ ጋርክ ሀንኮ የላጋ ማችታይ ፋ አዝንታኔ ፋ ናእታ ሲቆዳይ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ጾስ ቃላይ ቦርንታማይ ጋርክ ፋና ሞድዝታ፥ ጌሽታ፥ ፋ ካራ ካርስዝታ፥ ኬህታኔ ፋ አዝንስ ኪትንትዝታ ማቃድ ጋርክ የላጋ ማችታ ታማርሶ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","የይ ጋርከካ፥ ፓንꬅታይ ፋና ሃሮዳይ ጋርክ ዞሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","ኔኒ ነ ኦማስ ሎኦ ኦሶ ኡባይር ኡንትስ ኣዝሶ ማቆባ። ኔኒ ነ ትምርታይር ኤቆራኔ አማንንቶር ነና ቤዞባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","ኑ ሞርክታይ ኑና ዝግርዝ ኦገ ꬋብን ኡንቲ ዬላቶዳይ ጋርክ ኔኒ ቦርንቶዋ ሎኦ ኦሶ ኦꬆባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","አይልታይ ኡባ ባዛር ፋ ጎድታይስ ኪትንቶዳይ ጋርክ፥ ኡንታን ኡፋይሶድ ጋርከኔ ኡንታር ፓላማም ጋርክ ዞሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","ኡንቲ ፋ ጎድታይፕ ሚሸ ካስታማይ ጋርክ ዞሮባ። የይካ፥ ኑና አሽዛ ጾሳይ ትምርተ፥ ኡባ ኦገር ቦንችንቴዛ ማቃዳይ ጋርክ ፋ ኦꬅዛ ኦሳይድ ፎሎ አማንንትዝታ ማቄዛና ቤዞዳይ ጋርክ ኡንታን ዞሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","አስ ኡባ አሽዛ ጾስ ኣꬎ ኬሄትꬃይ ቆንጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","የ ኣꬎ ኬሃትꬃይ፥ ኑኒ ናጋራኔ Ꮊ አላማይ አሞ አሺ፥ Ꮊ ዎዳይድ ኑና ሞዲ፥ ቱማ አያና የስስኔ ጽሎትꬃር የዞድ ጋርክ ኑና ታማርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ኑኒ አንጅንቴዝ ኡፋይስ ማቄዝ ግታ ጾሳኔ ኑና አሽዛ የሱስ ክርስቶሳ ቦንቾ ቆንጭꬃ ናጎል የዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","ኢታ ኦሶ ኡባይፕ ኑና ዎዞዳይስኔ ሎኦ ባዝ ኦꬆዳይስ አሞትዝ ፓስ ጌሽ ዎያ ማሆዳይስ ፋና ኑ ግሾስ ኣꬂ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","ኔኒ Ꮊያ ታማርሶባ፥ ኩንꬅ ማዉተር ዞሮባ፥ ሴሮባ ኦንካ ነና ለቂፐ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","አሳይ ጋደ አቅስዝታይስኔ፥ ማዉተር የዝታይስ ሞድንቶድ ጋርክ፥ ሃዮትꬃር ኪትንቶዳይስኔ ሎኦ ኦሶ ኡባ ኦꬆዳይስ ጊግንቴዝታ ማቆዳይ ጋርክ ቆፕሶባ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","ማ ኡንቲ ኦላካ ኢታ ኦድንታማይ ጋርክ፥ ሳሮ አስ ማቃዳይ ጋርክ፥ አሽክታኔ አስ ኡባይስ ኬህዝታ ማቃዳይ ጋርክ ዞሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","ኑኒ ቲና ቦዝታ፥ ኪትንቶዝታ፥ ባልንቴዝታ፥ ዱማ ዱማ አሾ ኡፋይስስኔ አሞስ አይልቴዝታ። ኑኒ ኢታትꬃራኔ ቅናተር ኩሜዝታ፤ ኑ አስ እጽዝታ፥ አስካ ኑና እጽዝታ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","ዝን ꬋለ ማቄዝ ጾስ ኬሄትꬃኔ ሲቃይ ቆንጬዝ ዎደ ");
INSERT INTO mfxe_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ኑ ኦꬄዝ ጌሽ ኦሳይ ግሾስ ባዝን ፋ ማሮትꬃይ ግሾስ ኑና አሼዛ። ኤ ኑና አሼዛይ፥ ናምአንꬆ የልንቶ ሜቻራኔ ጌሻ አያና ባጋር እንጌዝ ኦሮꬅ የሳራ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","የ አያና፥ ጾሲ ኑና አሽዛ የሱስ ክርስቶሳ ባጋር ኑል አፋ ጋንꬂ ጎግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ፋ ኣꬎ ኬሄትꬃይ ባጋር ኑና ጽልሲ መꬍና ደኦ ላታ ኡፋያሳ ኤኮድ ጋርክ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Ꮊ ቃላይ አማንንቴዛያ። ጾስ አማንዝታይ ሎኦ ኦሶ ኦꬆዳይስ ጊጌዝታ ማቃዳይ ጋርክ ነ Ꮊ ቃላ ሚንꬂ ኦዶድ ጋርክ ታ ኮይዛ። የይትታይ አስ ኡባይስ ሎኦኔ ማድዝታ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","ዝን ቦዝታይ ፓላማይፐ፥ ኮቼ ታይቦፕ፥ ካቻፐኔ ህገፕ ደንዴዛይድ ደንድዛ ጫቻፕ ናግንቶባ። የይ ማዶዋ ዎ ባ ባዝ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","ጳልቂꬅ መꬍዛ አꬃ ፐቲ ቶኬ ዎይ ናምኢ ቶኬ ዞሪ የይፕ ጉየ የይ ጋርክ አꬃይፕ ሃኮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","የይ ጋርክ አስ ዡጫኔ ናጋራንቾ፤ ኤ ፋል አፋ ፕርዴዛና ኤሮባ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","ታኒ ባልጎ ኤዛይድ ሻጮዳይስ ቆፔዝ ግሾስ አርጸማሳ ዎይ ትክቆሳ ኔኮ ኪትዛ ዎደ ነ ታኮ ንቆጲሎና የኦዳይስ ምንጎባ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ህገ ኤርዝ ዜናሳኔ አጵሎሳ ኦገ Ꮊንጎዳር ኡንትስ ኮሽዛ ባዝ ፓጫማይ ጋርክ ኡንታን ማዶባ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","ኑ አሳይካ ፓꬆዋ አስ ማቂ አታማይ ጋርክ ፓስ ቤዝዛ ባዝ ደንጎዳይ ጋርክ ሎኦ ኦሶ ኦꬆዳይስ ሚንጊ ታማሮ። ");
INSERT INTO mfxe_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ታራ የዝ ኡባይ ነና ሳሮ ግዛ፤ አማኖር ኑና ሲቅዛ አስታ ሳሮ ጎባ። ጾስ ኣꬎ ኬሃትꬃይ ይ ኡባይራ ማቆ። አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","የሱስ ክርስቶሳስ አጭንቴዝ ታ ጳዉሎሳፐኔ ኑ እሻ ጽማቶሳፕ ዶስንቴዝ ኑር ዎላ ኦꬅዝ ፍልሞናስ ");
INSERT INTO mfxe_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ኑ ምሽቲ ኣፍብያስኔ ኑር ክርስቶሳስ ዎታዳረ ማቄዝ ኣርክጳሳስኔ ነ ካራ ሺቅዛ አማንዛ አስ ኡባይስ ");
INSERT INTO mfxe_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","ጾሳ ኑ አዳይፐኔ ኑ ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሃትꬃይኔ ሳሮትꬃይ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","ታ ዎሳይድ ኡባ ዎደ ነና ቆፕ ታ ጾሳ ጋላትዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","ጎዳ የሱሳል የዝ ነ አማናኔ አማንዛ አሳይስ የዝ ነ ቃꬋ ታ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","ኔኒ ነ አማና ሀራ አስስ ሻግዛይ ኑስ ክርስቶስ የሱሳ ባጋር ይእዛ ሎኦ ባዝ ኡባይ ኤርንቶድ ጋርክ ታኒ ጾሳ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","ታ እሻዮ አማንዝታይ ዎዝናይ ነ ኦሳይር ሼምፔዝ ግሾስ ነ ሲቃይር ጋመ ኡፋይስኔ ምንꬃꬆ ታ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","የይ ግሾስ ነ ኦꬆዳይስ ቤዝዛ ባዝ ኦꬆባ ግ ክርስቶሳ ባጋር ያሻ ባይꬅ ኪቶዳዝን፥ ");
INSERT INTO mfxe_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ኡባር Ꮊይ ጋርክ ሀኔዝ ታ ጳዉሎሳ ጭማይ፥ Ꮊተካ ማ የሱስ ክርስቶሳስ አች ማቄዛይ፥ ሲቆ ባጋ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","11","ካሰ ነና ማደካ አትኮካ Ꮊት ማቅኮ ነናካ ታናካ ማድዛ ግሾስ ታ አቻ የዛር ክርስቶሳ ባጋር የሌዝ ታ ናአ አናስሞሳ ግሾ ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","ታ ኤዛ ኔኮ ማሂ ዳኮዳ፥ ኔኒ ታ ዎዝናይ ጋርክ ኔኮ ዳኬዛይ ጋርክ ኡዲ ኤኮባ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","ታ ዎንግለ ግሾስ አጭንቲ የዝን ኤ ነ አቆ ታና ማዶድ ጋርክ ታ ኤዛ አሾድ ጌዝን። ");
INSERT INTO mfxe_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ዝን ነ ሎኦትꬃይ ዎልቃንꬆር ባዝን ዶሶር ማቃድ ጋርከ ግ ኔር ዞርንተካዛር አሾዳይስ ታኮየካያ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","ኤ ኔፕ ሻግንቲ ጋምኤዛይ ኡባ ዎደ ኔር የዞድ ግሾስ ማቃዳ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Ꮊይፕ ጉየ ኔር የዞዳይ አይለ ጋርክ ባዝን አይለፕ ኣꬎ ዶስንቴዝ እሸ ጋርከ፥ ኤ ታስ ዶስንቴዝ እሸ ማቅኮ ኔስ አሾራኔ አያናር ሲቆ እሸ ዋይዚ ማቆሳ? ");
INSERT INTO mfxe_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","ይኬ ታና ኔስ እሸ ኡዲ ኤክኮ ኤዛካ ታ ጋርክ ኡዲ ኤኮባ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","አባባዝካ ነና ቆሄዝ ባዝ የዝኮኔ አጮ ኤዛል የዝኮ ታል ኦሎባ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","ታ ጳዉሎሳ ታ ኩሸር ኤ አጫ ጭጎዳ ግ ኔስ ጻፌዛ፥ ነ ነ ኡባስ ታ አጮር የዛና ታ ቆፕሳሚ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","ይኬ ታ እሻዮ Ꮊ ሎኦ ኦሳ ነ ታስ ኦꬆድ ጋርክ ታ ነና ዎስዛ። ሀያና ታ ዎዝና ጎዳይ ባጋር ሸምፕሶባ ");
INSERT INTO mfxe_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","ታ ኔስ ጌዛይፕ ኣꬂ ነ ኦꬅዛይ ግሾስነ አዛዝንትዛ ግሾስ ታ ኤሪ ኦድዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","የይዳካ ጾሳይ ይ ዎሳ ስኢ ታና ይንትኮ ካማዳና ታ ኡፋይትዛ ግሾስ ታስ ሸምፕዛ አቆ ጊግሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","የሱስ ክርስቶሳ ግሾ ታር አጭንቴዝ ኤጳፍራ ሳሮꬆ ሺሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ታር ዎላ ኦꬅዛ ማርቆሳራ አርስጽሮኮሳ ዴማሳ ሉቃሳካ ሳሮꬃ ሺሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","ጎዳ የሱስ ክርስቶሳ ኣꬎ ኬሄትꬃይ ይንታር ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","ብኒ ብንኮ ጾስ፥ ኑ አድታይስ ናብታይ ባጋር ዱማ ዱማ ኦገር ጋመ ዎደ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","ዝን Ꮊ ዉርስꬅ ዎደ ኡባ ባዝ ኤዛ ላትሴዝ፥ ማ አላማካ ኤ ባጋር መꬌዝ ፋ ናአይ ባጋር ኑስ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","ናአይ ጾስ ቦንቾ ፖጭꬅኔ ሀናይር ሙመር ጾስ ኣዚ ኩንꬅ ጾስ ጾሳትꬅ ኤኪ፥ ፋ ማዉተ ቃላይር Ꮊ አላማ ሚንꬂ አይኬዛ። አሳ ኡ ናጋራይፕ ሻግሼዛይፕ ጉየ ኡባፕ አፋ ጾስ ኡሻች ሳሎ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","ኤስ እንግንቴዝ ሱንꬃይ ኪታንችታይ ሱንꬃይፕ ኣꬅ ማቄዛይ ጋርክ ኤ ኡንታፕ ሎእꬂ ኣꬊዝ ግሾሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","ይኬ፥ ጾስ ኪታንችታይፕ ኦኮ፥ «ኔኒ ታ ናአ፤ ታ Ꮊይኖ ኔስ አደ ማቄዛ» ዬጌኔ? ዎይ ኦኮ፥ «ታኒ ኤስ አደ ማቆዳ፤ ኤካ ታስ ናአ ማቆዳ» ዬጌኔ? ");
INSERT INTO mfxe_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","ማ ጾሲ ፋ ባይራ ናአ Ꮊ አላመ ኪትታር፥ «ጾስ ኪታንችታይ ኡባይ ኤስ ጎይኖ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","ጾስ ኪታንችታይ ባጋ ኦድታር፥ «ጾሲ ፋ ኪታንችታ ጫርክታ፥ ፋ አይልታ ታማ ላꬅ ኡድዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","ዝን ፋ ናአይ ባጋ ኦድታር፥ «ጾሶ፥ ነ ካተትꬃይ መꬍናስ የዝዛ። ነ ካተትꬃ ነ ጽሎትꬃር አቅሶዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","ኔኒ ጽሎትꬅ ዶሴዛ፤ ኢታትꬅ እጼዛ። ጾሳይ፥ ነ ጎዳይ፥ ነና ነ ዣምታይፕ ኣꬂ ዶሬዛ፥ ኡፋይስ ዛይተ ነና ትዤዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","ጾሲ ማሂ፥ «ጎዳዮ፥ ቲና ኔኒ ሳአ መꬌዛ፤ ሳልታይ ነ ኩሸ ኦስታ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","የይትታይ ኡባይ ꬋቦዳ፤ ዝን ኔኒ የዞዳ። ኡንቲ ኡባይ አፍላ ጋርክ ዉሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","ኔኒ ኡንታን ሳልነ ጋርክ ጻጾዳ፤ ማ ኡንቲ አፍላ ጋርክ ላምንቶዳ። ዝን ኔኒ ኡባ ዎደ ነና፤ ነ ላይꬅታይስካ ዉርስꬂ ባያ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","ዝን ጾሲ ኪታንችታይፕ ኦኮ፥ «ታኒ ነ ሞርክታ ነ ቶካይ የꬍዝ አቆ ኡዶድ ሄሎዳይስ፥ Ꮊይዳ ታፕ ኡሻች ባጋር በቶባ» ዬጌኔ? ");
INSERT INTO mfxe_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","ኪታንችታይ ኡባይ አቶትꬅ ደንጎዳይስ የዝ አስታ ማዶዳይስ ጾስ ኪቴዝ አያንታ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","የይ ግሾስ፥ ኑኒ ስኤዝ ቱማይፕ ሀራ ባዝ ኑና ኤካማይ ጋርክ የ ኑ ስኤዛና ሚንꬂ ናጎዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","ይኬ፥ ኪታንችታይ ባጋር ኦድንቴዝ ቃላይ ቱማ ማቅኮ፥ ኤዛ ለቆኔ ኪትንታም እጻይ ፕርዳ ክእዛባዝ ማቅኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","የዝን፥ ኑኒ Ꮊይ ጋርክ ግታ አቶትꬃ እጽኮ፥ ዋይዚ ቡቲ አቶዴ? ቲና ጎዳይ ፋ ኦማስ የ አቶትꬃ ኦዴዛ፤ ማ ኤፕ ስኤዝታይ ኑስ ጌሺ ማርካቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","ማ ጾሲ ማልታይር፥ ኦሮꬅባዝታይር፥ ዱማ ዱማ ማላ ባዝታይዳኔ ፋ ሸነ ጋርክ እንጌዝ ጌሻ አያና እሞትꬅታይር ማርካትꬃ ሚንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","ጾሲ Ꮊ ኑኒ ኦድዛ ቲናፕ የኦድ አላማ፥ ኪታንችታይስ ሞድሰካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","ጌሻ ማጻፋይ ፐቲ አቆ Ꮊይ ጋርክ ዬግዛ፦ «ኔኒ አስስ ቆፖዳይስ አስ ናአ አባ ባዞ? ዎይ ኔኒ ኤዛ ናጎዳይስ አስ ናአ አባ ባዞ? ");
INSERT INTO mfxe_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","ነ ኤዛ ኪታንችታይፕ ጽቃር ላፍꬄዛ፤ ኤ ኦማይል ቦንቾኔ ጋላታ ዛዉደ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","ማ ኡባ ባዝ ኤ ቶኬ ኦሞ ጋዴዛ» ዬግዛ። ጾሲ ኡባ ባዝ ኤስ ሞድሴዝ ዎደ ኤስ ሞድንቴካ አብካ ባያ። ዝን Ꮊት ኡባ ባዝ ኤስ ሃርንቶዳር ኑኒ ሀጋ በኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","ዝን ኑኒ ኪታንችታይፕ ጽቃር ላፌዛ የሱሳ ጾስ ኣꬎ ኬሃትꬃይፕ ደንዴዛይድ የሱሳ አስ ኡባይስ Ꮊይቄዛ። ኤ ዋየ Ꮊይቆ Ꮊይቄዝ ግሾስ ቦንቾኔ ጋላታ ዛዉደ ኤ ኦማይል ጋድን በአዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","ኡባ ባዝ ኤፐኔ ኤስ መꬍንቴዛይ፥ ጋመ ናእታ ፓር ቦንቾኮ ኮኦዳይስ ኡንትስ አቶትꬅ ኩስተኔ ዋዬር ፎሎ ማቃዳይ ጋርክ ኦꬆዳይስ ኤስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","የሱሳኔ Ꮊ ኤ ጌሼዝ አሳይ ኡባይ ፐቲ አዳይ ናእታ። የሱሳ ኡንታን፥ «ታ እሹንꬆ» ግ ጼጎዳይስ ዬላተካዛይ የይሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","የሱሳ፥ «ታኒ ነ ሱንꬃ ታ እሽታይስ አዋጆዳ፤ ዎያ ጋንጨ ነና የꬃር ጋላቶዳ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","ማ ኤ፥ «ታኒ ኤዛል አፋ አማንቶዳ» ዬግዛ። ማካ፥ «ታኔ ጾሲ ታስ እንጌዝ ናእታይር ታ Ꮊይዳ የዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","ይኬ ናእታይ አሾኔ ሱꬂ የዝታ ማቄዝ ግሾስ የሱሳካ ኡ ጋርክ አስ ማቄዛ። ኤ የያ ኡዴዛይ፥ Ꮊይቆል አፋ ዎልቃ የዝ ጻላሄ ፋ Ꮊይቃይር ሻሮዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","ማ ፋ የዛ ላይꬅ ኡባይድ Ꮊይቆስ ያሻር አይልቲ የዝታ አይለትꬃፕ ዎዞዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","የሱሳ የኤዛይ አፍራመ ዘረꬅ ማዶዳይሳፕ አትን ኪታንችታ ማዶዳይስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","አስ ናጋራስ ያርሽንቶዳይስ ጾስ ቲና ማርዛኔ አማንንቴዝ ቄሰ ሀላቃ ማቄዛ። የይ ግሾስ፥ ኤ ኡባ ባዛር ፋ እሽታ ኣዞዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","ኤ ፋ ኦማስ ፓጭንት ዋየ ኤኬዝ ግሾስ ፓጭንትዝታ ማዶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","የይ ግሾስ፥ ጾስ ጼስ ሻግንቴዝ ጌሽ እሹንꬆ፥ ኑ አማኖስ ጎዳ ግ ጼግዝ ሀዋረኔ ቄሰ ሀላቃ የሱሳ ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","ሙሰ ጾስ ካራ ኡባይድ አማንንቴዛይ ጋርክ የሱሳካ ፋና ሹሜዝ ጾሳይስ አማንንቴዛያ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","ኬꬅ ኬጽዛይ ኬꬃይፕ ኣꬊ ቦንችንትዛይ ጋርክ የሱሳ ሙሰፕ ኣꬊዝ ቦንቾ ኤኮዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","ፐቲ ፐቲ ኬꬅስ ኬጼዝ አሲ የዛ፥ ዝን ኡባ ሀንሴዛይ ጾሰ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","ሙሰ ጾስ ካራ ኡባይድ አማንንቴዝ አይለ ማቂ፥ ጾሲ ቲናፕ ጎድባዛይስ ማርካ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","ዝን ክርስቶሳ ጾስስ ናአ ጋርክ አማንንቴዛያ። ኑኒ ኤኮዳ ግ ያሻ ባይꬅ ጬቆር ናግዛ ኡፋይሳ ሚንꬂ ናግኮ ኑ ኤ ካራ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","የይ ግሾስ፥ ጌሻ አያናይ ግዛይ ጋርክ፥ «Ꮊይኖ ይ ጾሳይ ግዛ ስእኮ ");
INSERT INTO mfxe_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","ሊዦ ቢታ ይ ታና ፓጬዝ ጋላስ፥ ይ ዎርዣቴዛይ ጋርክ፥ ይ ዎዝና ምንꬅፓተ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","ኤዛይድ ይ አድታይ ታና ፓጬዛ፤ ኦይታም ላይꬅ ታ ኦሳ በኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","የይ ግሾስ፥ ታ የ የለትꬃ ሴሬዛ፥ ‹ኡንቲ ኡባ ዎደ ፋ ዎዛናይር ባልንትዛ፤ ታ ኦጋ ኤረካያ› ታ ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","የይ ግሾስ፥ ‹ታ ሸምፖ አቃ ኡባራካ ገላሚ› ዬጊ፥ ታኒ ታ ሴራይድ ጫቄዛ፥ ዬጌዛ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","ታ እሹንꬆ፥ ይንትፕ ኦ ጋንጨካ፥ ደኦ ጾሳይፕ ይንታን ሻክዛ ኢታኔ አማኖዋ ዎዝና የዛማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","ይንትፕ ኦናካ ናጋራ ባልꬅን፥ ፋ ዎዝና ምንꬃማይ ጋርክ «Ꮊይኖ» ዬግንቲ ጼግንቶዳር ጋላስ ጋላስ ዎልር ዞርንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","ኑ ቲና አማና ኑኒ ዉርስꬂ ሄሎዳይስ ሚንꬂ ናግኮ፥ ክርስቶሳር ፐትፕ ላቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","ጌሻ ማጻፋይድ፥ «Ꮊይኖ ጾስ ግዛ ይ ስእዝ ዎደ የ ዎደ ኡንቲ ዎርዠትꬃር ሀኔዛይ ጋርክ፥ ይ ዎዝና ሚንꬅፓተ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","ጾስ ግዝባዝ ስኢ ዎርዠቴዝታይ ኦናንታራ? ሙሰ ግብጸፕ ካልꬂ ከሴዝ ኡብታ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","ጾስ ኦይታም ላይꬅ ኦና ሴሬኔ? ናጋራ ኦꬄዝታኔ ኡ አሃይ ሊዦ ቢታ ዎꬊ አቴዝ አስታ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","ማ ጾስ፥ «ታ ሸምፖ አቃ ኡ ገላሚ» ዬጊ ጫቄዛይ፥ ኤስ ኪትንታም እጼዝ አሳይሳፕ አትን ኦሶ? ");
INSERT INTO mfxe_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","ይኬ፥ ኡንቲ የ ሸምፖ አቃ ገለካ አቴዛይ አማነካ ግሾስ ማቄዛና ኑ ቦኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","ይኬ፥ ጾሲ ኑና ፋ ሸምፖ አቆ ገልሶዳ ጌዝ ቃላይ ሀጋ ቲናፕ የዝ ግሾስ ይንትፕ ኦንካ የ ሸምፖ አቃ ገለካ አታማይ ጋርክ ዎላ ናግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","ኡንትስ ዎንግላይ ሳባክንቴዛይ ጋርክ፥ ኑስካ ሳባክንቴዛ። ዝን ኡንቲ ስኤዝባዝ አማኖር ኤከካ ግሾስ ኡንታን ማደካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","ሀኖ ዝን፥ አላመ መꬊንቴዛይፕ አይኪ ጾሳ ኦሳይ ፖልንቴዝ ማቅኮካ፥ ጾሲ፥ «ታኒ ታ ካቻይድ ጫቄዛ፥ ታ ሸምፖ አቆ ኡባራካ ኡ ገላሚ» ጌዛይ ጋርክ፥ ኑኒ አማኔዝታይ ኤ ሸምፖ አቆ ገሎዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","ላፑንꬃ ጋላስባጋ ፐቲ አቆ፥ «ጾሲ ላፑንꬃ ጋላሳ ፋ ኦሶ ኡባይፕ ሸምፔዛ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","ማካ የ አቃይድ፥ «ኡንቲ ታ ሸምፖ አቃ ኡባራካ ገላሚ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","ቲና ዎንግለ ስኤዝታይ ኪትንታም እጺ ሸምፖ አቃ ገለካያ። የያ ማቅኮካ፥ Ꮊተካ የ ሸምፖ አቃ ገሎ ግንትንቴዝ ፐቲ ፐቲ አስታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","የይ ግሾስ፥ ጾሲ፥ «Ꮊይኖ» ግ ጼጎዳር ፐቲ ጋላስ ኑስ ቃማ ጋዴዛ። ጋመ ዎደፕ ጉየ ጾሲ ዳዉተ ባጋር፥ «ጾሲ ግዝባዝ Ꮊይኖ ይ ስእዝ ዎደ ይ ዎዝና ምንꬅፓተ» ዬጊ ኦዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","ኢያሶ ኡንትስ ሸምፖ እንጌዝባዝ ማቄዛኮ፥ ጾሲ ሀራ ጋላሰ ባጋ ጉየፐ ኦዳምዝን። ");
INSERT INTO mfxe_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","ይኬ፥ ጾስ አሳይስ ማላ ጋላስ ሸምፖ ጋርክ ሸምፓይ ናግንቲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","ጾስ ሸምፖ አቃ ገልዛ ኦንካ፥ ጾሲ ፋ ኦሳይፕ ሸምፔዛይ ጋርክ ኤካ ፋ ኦሳይፕ ሸምፖዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","የይ ግሾስ፥ ኦንካ የ አሳይ ኪትንቶ እጻ ካሊ፥ ፖካማይ ጋርክ ዎላ ጾስ ሸምፖ አቃ ገሎዳይስ ምንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","ጾስ ቃላይ ደኦር የዛኔ ኦꬅዛያ። ናምኢ ባጋር ሌፍንቴዝ ማሻፕ ኣꬊ ኦጮ። ኤ ሸምፖ፥ አያና፥ ጻጶኔ ኮልእዘ ሄሎዳይስ ሳትሲ ጫድዛ። ማ አስ ዎዛና የዝ ቆስንቴዝ ቆፋኔ አሞ ሻኪ ፕርድዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","ጾስ ቲናፕ ቆስንቴዝ አባ መትꬅካ ባያ። ኤ ኣፈ ቲና ኡባ ባዝ ቆንጨኔ ካሎ የዛ። ኑኒ ማህꬅ እንጎዳይስ ቤዝዛይ ኤ ቲናይዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","ይኬ፥ ሳልታይል አፋ ከዜዝ ኡባይፕ ኣꬅ ቄሰ ሀላቃይ፥ ጾስ ናአ የሱሳ፥ ኑስ የዛ ግሾስ ኑ አማና ሚንꬂ ናጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","ኑ ቄሰ ሀላቃይ ኑ ዳቡሮዳር ኑስ ቃꬊንቶዳይስ ዳንዳእዛያ። ኤ ናጋራ ኦꬄካ፥ ዝን ኑ ጋርክ ኡባ ባዛር ፓጭንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","ይኬ፥ ማሮትꬅ ኤኮዳይስኔ ማዴ ኮሽዛ ዎደ ኣꬎ ኬሃትꬃይፕ ደንጎዳይስ ኣꬎ ኬሃትꬃይ የዛ አቆ ጾስ ዙፋናይኮ ያሽተካ ሺቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","ፐቲ ፐቲ ቄስታይ ሀላቃ አሳይ ጋንጨፕ ማራጽንቲ፥ ጾሳር ሄልꬅዛ ባዛ አሳይ ግሾስ እሞታራኔ ናጋራ ያርሾ ያርሾዳይስ ሹምንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","ኤ ፋ ኦማስ ዳቡራ ማቄዝ ግሾስ ኤሮዝታይስኔ ባልንትዝታይስ ቃꬊንቶዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","ኤ ፋ ናጋራ ግሾኔ አስ ኡባ ናጋራ ግሾስ ያርሾ ያርሾዳይስ ቤዝዛይ የይሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","ኦንካ Ꮊ ቦንቻ ፓስ ኤኮዳይስ ዳንዳኦዋ፥ ዝን ኣሮና ቄስታይ ሀላቃ ማቆዳይስ ጼግንቴዛይ ጋርክ ጾሳር ጼግንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","የይ ጋርከካ፥ ክርስቶሳ ቄስታይ ሀላቃ ማቅꬅ ቦንቻ ታስ ቤዝዛ ግ ፋ ኦማስ ኤከካያ። ዝን ጾሲ ኤዛ፥ «ኔኒ ታ ናአ። Ꮊይኖ ነና ታ የሌዛ» ኤኮ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","ማ ሀራ አቆ፥ «ማልከጻድቀ ቄሰ ማቄዛይ ጋርክ፥ ኔኒ መꬍናስ ቄሰ ማቆዳ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","የሱሳ አስ ማቂ Ꮊ አላመል የዝ ዎደ ፋና Ꮊይቆፐ አሾዳይስ ዳንዳእዛ ጾሳ ጋመ ዬፎራኔ አፉꬃር ዎሴዛ። ኤ፥ ኤዛ ቦንቺ ኪትንቴዝ ግሾስ ጾስ ኤ ዎሳ ስኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","የሱሳ ጾስ ናአ ማቅኮካ ፋ ዋይንቴዝ ዋያይድ ኪትንታ ታማሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","የይዳካ፥ የሱሳ ፎሎ ማቄዛይፕ ጉየ ፓስ ኪትንትዛ ኡባይ መꬍና አቶትꬃ ደንጎዳይ ጋርክ ኦገ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","ጾስ ማልከጻድቀ ቄሰትꬅስ ሹሜዛይ ጋርክ ቄስታይ ሀላቃ ኡዲ ኤዛ ሹሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","ያ ኑ ኦዳይል አፋ ጉጂ ናሾድ ጋመ ባዝ የዛ፥ ዝን ይ አካካይ ጽቃ ማቄዝ ግሾስ ይንትስ ኦዲ ገልሶዳይ ዋይꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","ይ Ꮊኖንተ አስታማረ ማቆዳይስ ቤዝዛ፥ ዝን ጾስ ቃላ ቲና ትምርታ ይንታን ማሂ ታማርስዛ ሀራ አስ ኮሽዛ። ይ ምኖ ካꬃ ማዳይስ ዳንዳኦዛይ ግሾስ ማꬅ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","ማꬅ ፓክንትዛ ኦንካ ዱደ ናአ ማቄዝ ግሾስ ሎኦኔ ኢታ ሻኪ ኤሮያ። ");
INSERT INTO mfxe_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","ዝን ምኖ ካꬃ ሎኦኔ ኢታ ሻኪ ኤሮር ሎሄዝ አሳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","ይኬ፥ ክርስቶሳ ባጋ ታማርስዛ ቲና ትምርታ አሺ ክርስቶሳር ፎሎኮ Ꮊማዳ። Ꮊይቄዝ ኦሶፕ ገሎኔ ጾስ አማኖ ባጋ ቲና ትምርታይኮ ጉየ ማቂ ማሂ ባሳሚ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","የይትታይካ፥ ጽንቃትታይ ባጋ፥ ኩሸ ጋዶ ባጋ፥ Ꮊይቆፕ ደንዶ ባጋኔ መꬍና ፕርዳ ባጋ ማሂ ታማራም። ");
INSERT INTO mfxe_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","ጾስ ጊኮ ኑ የያ ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","ፐቲ ቶኬ ፖኦ ኡንትስ ፖኤዝታ፥ ሳሎ እሞታ ኤኬዝታ፥ ጌሻ አያናር ሻክንቴዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","ሎኦ ጾስ ቃላኔ ቲናፕ የኦድ አላማይ ዎልቃ በኤዝታ፥ ");
INSERT INTO mfxe_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ጉየፐ ካዴዝታ ናጋራይፕ ናምእንꬆ ማሆዳይስ ዳንዳእንቶያ። አብስ ጊኮ፥ ኡንቲ ፋ ꬋቦስ ጾስ ናአ ማሂ ሶትዛይ ጋርክ ማዝቃለል አፋ ኤዛ ሶቴዛ ዎያ ቲና ካዉሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","ኡባ ዎደ ኢል አፋ ቡክዛ እራ ኡዢ፥ ዎቴዝ አꬃ ማድዛ ካꬅ እንግዛ ቢታይ ጾስ አንጄዛኖ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","ዝን አንጉንꬅኔ ግጀ ዶልዝ ቢታት አብካ አዳሚ፤ ኢስ ቃንግꬂ ኡኬዛ፤ ዉርስꬃል እዛ ጹግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","ኑ ሲቆ እሹንꬆ፥ ኑኒ Ꮊይ ጋርክ ኦድዛ ባዝ ማቅኮካ፥ ይንታን አቶትꬅኮ ካልꬅዛ ሎኦ ባዝ ይንትስ የዛና ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","ጾስ ሉለ ፕርድዛ። ጾስ፥ ይ ኦꬄዝ ኦሶኔ ቲና ማቅን Ꮊተካ አማንዝታ ማዲ፥ ኤስ የዝ ሲቆ ቤዜዛና ዶጎያ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","ይ ኡባይ ኡፋይሳር ናግዛና ደንጎድ ሄሎዳይስ Ꮊ ምኖትꬃ ዉርስꬂ ሄሎዳይስ ቤዞዳይ ጋርክ ኑ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","ይ አማኖራኔ ዳንዳአር ናግዛ ኡፋይሳ ላትዛ አሳ ኣዞዳይ ጋርከፐ አትን አዛላ ማቆዳና ኑ ኮዮያ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","ጾሲ አፍራመስ ኡፋይስ ቃላ እንጎድ ግ ጫቆዳር ፋፐ ኣꬊዝ ሀራ ግታ ባ ግሾስ ፋ ኦማስ ጫቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","ኤኮ፥ «ታኒ ነና አንጆዳ፤ ነ ዘርꬃካ ጋንꬆዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","አፍራመ ዳንዳአር ናጌዝ ጾሳይ እንጎድ ጌዝ ኡፋይሳ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","አሲ ጫቂታር ፋፕ ዳምዛ አꬃይር ጫቂዛ፤ ኡ ፋ ኦዳ ጫቆር ሚንꬂ፥ ዎል ጋንጨ የዝ ፓላማ ኡባ ተቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","የይ ግሾስ፥ ጾስ ፋ ላምንቶዋ ቆፋ ኡፋይስ ቃላ ላትዝታይስ ቆንጭሶዳይስ ኮዬዝ ግሾስ ጫቆር ኡንትስ ሚንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","ጾስ ላምንቶዋዝታኔ ዎርዶቶዋ ናምኢ ባዝታ ጉሳይ ኡፋይስኔ ጫቃ ኑስ እንጌዛ። Ꮊ ናምኢ ባዝታይፕ ደንዴዛይድ ኑ ቲናይድ የዝ ኡፋይሳ ሚንꬅ አይኮዳይስ ዳንዳኦዳይስ ዘምፖ ደንጎዳይስ ኤኮ ቆስንቴዝ ኑኒ ዎልቃማ ምንꬃꬆ ደንጎዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","ያ ኡፋይሳይ ኑ ሸምፖስ፥ ማርካበ ኤንአማይ ጋርክ ሚንꬂ አይክዝ ዎዶሮ ጋርከ። የ ኡፋይሳይ ማጋራዣፕ ጉየ ባጋ የዝ ጌሽ አቃ ገልዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","የሱሳ ማልከጻድቀ ሹማተꬃይ ጋርክ መꬍናስ ቄስታይ ሀላቃ ማቂ፥ ኑ ግሾስ ኑፕ ቲናቲ የ አቃ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","ማልከጻድቄ፥ ሳሌመ ካታይ፥ ኡባፕ ኣꬅ ጾስ ቄሰ። የ ማልከጻድቀ አፍራመ ካትታና ኦሊ ጋሚ ማቆዳር ኤዛ ሄሊ አንጄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","አፍራመ ፋ የዛ ባዝ ኡባይፕ ኤስ አስራታ ከሲ እንጌዛ። ማልከጻድቀ ሱንꬃይ ቲና «ጽሎትꬅ ካት»፥ ናምእንꬆ፥ «ሳሌመ ካት» ብልእꬃይ፥ «ሳሮትꬅ ካት» ጉሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","ማልከጻድቀስ እንዳ ዎይ አደ ዎይ ዛረ ታይቦ ባያ። ኤ ላይꬃይስ ደንዶ ዎይ ኤ ላይꬃይስ ዉርስꬂ ባያ፥ ዝን ጾስ ናአ ኣዚ መꬍናስ ቄሰ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","ማልከጻድቀ አብ ጋርክ ዳማዛኮ ቦኦይታ። ኑ አድታይስ ማይዛይ፥ አፍራመ፥ ፋ የዛ ባዛይፕ ኤስ አስራታ እንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","ቄሰ ማቄዝ ለወ ዛራይ እስሬለ አሳይፕ፥ የይካ አፍራመ ዘረꬅ ማቄዝ ፋ እሽታይፕ አስራታ ኤኮዳይ ጋርክ ህገ ኪትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","ማልከጻድቀ ለወ ዛረ ማቃም እጽኮካ አፍራመፕ አስራታ ኤኬዛ፤ ኡፋይስ ቃላ የዝ አፍራመና አንጄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","ጽቃይ ዳማይር አንጅንትዛይ ፓላምꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","ፐቲ ባጋር፥ አስራታ ኤክዝታይ Ꮊይቅዝ አስታ፥ ዝን ሀራ ባጋር አስራታ ኤክዛይ Ꮊይቀካ የዛ ዬጊ ኦድንቴዝ መልከጻድቀ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","ይኬ፥ አስራታ ኤክዝ ለወ፥ አፍራመ ባጋር አስራታ እንጌዝ ጎዳይስ ዳንዳእንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","አብስ ጊኮ፥ ማልከጻድቀ አፍራመር ዎል ሄሎዳር ለወ ሀጋ የልንተካ ማቅኮካ፥ ፋ ማይዛ አፍራመ ጉልባታይድ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","እስሬለ አሳይስ ህገ ለወ ቄሰትꬃይ ባጋር እንግቴዛ። የ ለወ ቄሰትꬃይ ፎሎ ማቄዝ ባዝ ማቄዛኮ ኣሮናሳይ ጋርክ ባዝን፥ ማልከጻድቀ ጋርክ ሀራ ቄሰ ሹሞዳይስ ኮሻምዝን። ");
INSERT INTO mfxe_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","ይኬ፥ ቄስታይ ላምንቶዳር ህጋይካ ማ ላምንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","የያ ኑ ኤባዝ ኦድዛ አꬃይ ሀራ ዛረ፤ ኤ ሼሻይፕ ኦንካ ያርሾ አቆ ቄሰትꬅ ኦꬄካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","ኑ ጎዳይ ይሁዳ ሼሻይፕ የኤዛይ ኤርንቴዛያ። ሀኖ ዝን፥ ሙሰ ቄስታይ ባጋ ኦድታር ይሁዳ ኮች ባጋ አብካ ኦደካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","ማልከጻድቀ ጋርክ ሀራ ቄሰ የኤዝባዝ ማቄዛኮ Ꮊ ኑ ኦድዛባዛይ ኣꬊ ቆንጮዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","ኤ ቄሰ ማቄዛይ ꬋቦዋ ደኦ ዎልቃይራፕ አትን ኤ ማይዛ ህገራኔ ዎጋይር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","ጌሻ ማጻፋይ፥ «ማልከጻድቀ ቄሰትꬃይ ጋርክ፥ ኔኒ መꬍናስ ቄሰ» ዬጊ ማርካትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","ቲና ህጋይ ዳቡራኔ ማዳማ ማቄዝ ግሾስ ሻርንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","ሙሰ ህጋይ አባራካ ፎሎ ማቆዳይስ ዳንዳኤካያ። ዝን ኑኒ Ꮊት ጾስኮ ሺቆዳይስ ኡባይፕ ኣꬊዝ ኡፋይስ ቃላይ ኑስ እንግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","ክርስቶሳ ቄሰ ማቄዝ ዎደ ጾሲ ጫቄዛ፥ ዝን Ꮊንክታይ ቄሰ ማቄዝ ዎደ የይ ጋርክ ጫቃይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","ዝን የሱሳ ቄሰ ማቄዛይ ጾስ ጫቆራ፤ «ጎዳይ ኤኮ ‹ኔኒ መꬍና ቄሰ› ዬጊ ጫቄዛ፤ ኤ ፋ ቆፋ ላሞያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","ያ ጫቃይፕ ደንዴዛይድ የሱሳ ኑስ ኡባይፕ ኣꬊዝ ቃላ ጫቃይስ ዋሰ ማቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","ቲና ቄስታይ ታይባይ ጋመ ዝን ቄሰትꬅ ኦꬃማይ ጋርክ Ꮊይቆ ኡንታን ካዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","ዝን የሱሳ መꬍናስ የዝዛ ግሾስ ኤ ቄሰትꬃይ ላምንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","የይ ግሾስ፥ ኤ ኡባ ዎደ ኡ ግሾስ ጉሮዳይስ መꬍናስ የዝ ግሾስ ጾስኮ ኤ ባጋር ይእዝታ ፎሎ አሾዳይስ ዳንዳእዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","ይኬ፥ ኑስ ቤዝዛ ባዝ እንግዛ፥ ጌሻይ፥ ቦሮኔ ቱና ባዛይ፥ ናጋራንችታይፐ ሻክንቴዛይኔ ሳሎፕ ኣꬊ ꬎቄዝ ቄሰ ሀላቃይ ኑስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","ኤ Ꮊንኮ ቄሰ ሀላቅታይ ጋርክ ቲና ፋ ናጋራ ግሾስ ካሊ አስ ናጋራ ግሾስ ጋላስ ጋላስ ያርሾ ያርሾዳይስ ኮሾያ። ኤ ፋና ያርሼዝ ዎደ Ꮊያ ላማማይስ ፐቲ ቶኬ ዉርሲ አሼዛ ");
INSERT INTO mfxe_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","ሙሰ ህጋይ ዳቡራ አሳ ቄሰ ሀላቃ ኡዲ ሹምዛ። ዝን ህጋይፕ ጉየ የኤዝ ጫቆ ቃላይ መꬍናስ ፎሎ ማቄዝ ጾስ ናአና ሹሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","ኑኒ ኦዴዝ ባዛይፕ ኣፈ ቆፋይ የያ። ሳሎ ኡባፕ አፋ ጾስ ዙፋናይፕ ኡሻች ባጋ በቴዝ Ꮊይ ጋርክ ቄሰ ሀላቃይ ኑስ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","ኤ ኦꬅዛይ ቱማ ዱንካነ ማቄዝ ጌሽ አቆ፥ የ ዱንካናት ቱክንቴዛና አስ ኩሸር ባዝን ጎዳይ ኩሸራ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","ቄሰ ሀላቃ ኡባይ ሙጻታስኔ ያርሾ ያርሾዳይስ ሹምንትዛ። የይ ግሾስ፥ Ꮊ ቄሳይ ያርሾዳይስ ፐትባዚ የዞዳይስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","ህገ ኪትዛይ ጋርክ ያርሽዛ ቄስታይ የዝ ግሾስ ክርስቶሳ ሳአ የዛ ባዝ ማቄዛኮ ቄሰ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","ኡንቲ ቄሰትꬅ ኦꬅዛ ዱንካናይ ሳሎ የዛይስ ኣዝሶኔ ኤሾ። ሙሰ ዱንካና ኤስዛ ዎደ ጾሲ ኤኮ፥ «ታኒ ነና ደረል አፋ ቤዜዝ ኣዝሳ ካሊ ናግንቶር ኦꬆባ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","Ꮊት ማቅኮ የሱሳ ጋንጨ ገሊ ዳቦꬅዛ ቃላ ጫቃይ፥ ቲና ቃላ ጫቃይፕ ኣꬍዛይ ግሾስ ኤ ኤኬዝ ኦሳይ ኡንቲሳይፕ ኣꬍዛ። የይ ኤቄዛይ ኣꬊዝ ኡፋይስ ቃላይዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","ቲና ቃላ ጫቃይድ ቦሮ ባ ማቄዛኮ ናምእንꬅ ቃላ ጫቆ ኮሾያ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","ዝን ጎዳይ ኤዛ ቦሪ፥ Ꮊይ ጋርክ ዬጌዛ፦ «ታኒ እስሬለ አሳይራኔ ይሁዳ አሳይራ ኦሮꬅ ቃላ ጫቆ ጫቂዛ ዎደ የኦዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","የ ቃላ ጫቃይ ታ ኡ አድታይ ግብጸ ቢታፕ ኩሸ አይኪ፥ ጎቺ ከሴዝ ዎደ ኡንታር ጫቄዝ ጫቃይ ጋርክ ባያ። ጎዳይ ኡንቲ ታ ጫቃይድ አማንንተካዛይ ግሾስ ታኒ ኡንታን ኦሊ አሼዛ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","ዝን ይከፕ ጉየ እስሬለ አሳይራ ታ ጫቆድ ጫቃይ Ꮊያ ዬግዛ ጎዳይ። ታኒ ታ ህጋ ኡ ካሃይድ ጋዶዳ፤ ኡ ዎዝናይዳካ ጻፎዳ። ታኒ ኡ ጾሳ ማቆዳ፤ ኡንትካ ታ ወያ ማቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","ኡንታፕ ኦንካ ፋ ሾራ ዎይ ፋ እሻ፥ ‹ጎዳ ኤሮባ› ዬጊ ታማርሳሚ። ኡንቲ ጽቃፕ ዳማ ሄሎዳይስ ኡባይ ታና ኤሮዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","ታኒ ኡ ናቃ አቶ ጎዳ፤ ኡ ቆሃ ማሂ ቆፓሚ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","ጾሲ Ꮊ ጫቃ «ኦሮꬅ ቃላ ጫቆ» ጉሳይ ቲናሳ ጭማ ማሄዛ። ይኬ፥ ጭማይኔ ጬጋይ ꬋብዛ ዎደ ሄሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","ቲና ጫቃይስ ጾስ ጎይኖ ዎጋይኔ ሳአ ዱንካናይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","ቲና ዱንካናይ ጊጌዛ። ኤዛይድ ጾምፐ ጋድዝ ኮች፥ ጻርጴዛኔ ያርሾ ቦራ የዛ፤ የ አቃይ ጌሺ ግንትትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","ናምአንꬆ ማጋራዣይፕ ጉየ ባጋር የዝ አቃይ ኡባይፕ ኣꬎ ጌሽ አቆ ግንትንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","ኤ ጋንጨ እጻኔ ጩይሽዝ ዎርቃ ቀንደለኔ ዎርቃር ጎልንቴዝ ቃላ ጫቆ ታቦታይ የዛ። የ ጫቆ ታቦታይድ ማና የዝ ዎርቃ ጻሮ፥ አጬዝ ኣሮና ጉፋይኔ ሙሰ ህገ ጻፍንቴዝ ናምኢ ሎቼ ሹችታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","የ ታቦታይል አፋ ባጋር አቶትꬅ ካመ ፋ ቀፋይድ ካምዛ ቦንቾ ክሩቤልታይ የዛ። ዝን Ꮊት የ ኡባ ቆንጭሲ ኦዶዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","ያ ኡባይ Ꮊይ ጋርክ ጊጌዛይፕ ጉየ፥ ቄስታይ ኡባ ዎደ ፋ ኦሳ ኦꬆዳይስ ዱንካናይስ ቲና ባጋ ክፍላ ገልዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","ዝን ቄሰ ሀላቃይ ኣዳ ዱንካናይስ ናምእንꬆ ክፍለ ላይꬃፕ ፐቲ ቶኬ ገልዛ። ኤ የያ ገልታር ፋ ናጋራ ግሾኔ አሳይ ኤረካ ኦꬄዝ ናጋራ ግሾስ ሱꬅ ያርሾ ኤከካ ገሎያ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","ቲና ዱንካናይ ኤቂ የዝን፥ ኡባፕ ጌሽ አቆ ካንግዛ ኦገ ሀጋ ዶይንተካዛ ጌሻ አያናይ የያ ኤርስዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","የይ Ꮊ ዎዳይስ ኣዝሶ፤ ጾስስ እንግንትዛ እማኔ ያርሻይ ጎይንዛ አꬃይ ካሃ ጌሾዳይስ ዳንዳኦዛና Ꮊይ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","የይትታይ ሙስ ባጋ፥ ኡሽ ባጋ ዱማ ዱማ ሜች ዎግታይ ኦድዝታ። ኡንቲ ኦሮጽዛ ዎደ የኦድ ሄሎዳይስ ኦስንትዛ ባለ ዎግታ ባጋ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","ዝን ክርስቶሳ Ꮊት ኑ ደንጌዝ ሎኦ ባዝታይስ ቄስታይ ሀላቃ ማቂ የኤዛ። ኤ ገሌዝ ዱንካናይ ዳማኔ ፎሎ ማቄዛ። የ ዱንካናይ አስ ኩሸር ኦስንተካዛኔ Ꮊ አላማይፕ መꬍንቴዛኖ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","ክርስቶሳ ኡባፕ ጌሽ አቆ ገልታር ዴሽ ሱꬅኔ ኦጎና ሱꬅ ኤኪ ገለካያ። ዝን መꬍና አቶትꬃ እንጎዳይስ ፋ ሱꬅ ኤኪ ላማማይስ ፐቲ ቶኬ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","ዴሽ ሱꬅኔ ዎፋኖ ሱꬅ፥ ጹግንቴዝ ኡስ ቡዶ፥ ቱኔዝ አሳይል አፋ ꬋርጭንቲ ኡንታን ጌሽዛባዝ ማቅኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","መꬍና አያና ባጋር ቦሮ ባ ያርሾ ኡዲ፥ ጾሳይስ ፋና እንጌዝ ክርስቶሳ ሱꬅ፥ የዛ ደኦ ጾስ ጎይኖዳይ ጋርክ Ꮊይቆ ካልꬅዛ ኦሳይፕ ኑ ካሃ ዋይዚ ኣꬂ ጌሾሳ? ");
INSERT INTO mfxe_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","የይ ግሾስ፥ ጼግንቴዝታይ ጾሲ እንጌዝ መꬍና ላታ ኤኮዳይ ጋርክ ክርስቶሳ ኦሮꬅ ጫቃይስ ጋንጨ ገሊ ዳቦꬅዛ ማቄዛ። የይ ሀኔዛይ አሳይ ቲና ጫቃይፕ ኦሞ የዝ ዎደ ኦꬄዝ ናጋራይፕ ኡንታን ዎዞዳይስ ኤ Ꮊይቃይዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","ይኬ፥ ኬኬ ዬዝኮ፥ የ ኬኬዝ አꬃይ Ꮊይቅꬃይ ኤርንቶዳይስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","ኬኬዝ አꬃይ Ꮊይቅኮ ኤ ኬካይ ሚንግዛ። ኬኬዝ አꬃይ Ꮊይቀካ አትኮ ኤ ኬካይ ኦꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","ሀራ አቶዝን፥ ቲና ጫቃይካ ሱꬂ ባይꬅ ምንገካ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","ሙሰ ህገ አዛዝታ ኡባ አሳይስ ኦዴዛይፕ ጉየ ኦጎና ሱꬅኔ ዴሽ ሱꬂ ሃꬃር ዋላኪ፥ ዞቆ ዱር እክሰኔ ህሶጰ ኤኪ፥ ማጻፋይል አፋኔ አሳይል አፋ ዉርጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","ሙሰ አሳይኮ፥ «ይ ናጎዳይ ጋርክ ጾሲ ኪቴዝ ሱꬅ ጫቃይ Ꮊያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","የይ ጋርከካ፥ ዱንካናይዳኔ ኦꬅዛ ሚሸ ኡባይል አፋ ሱꬅ ዉርጼዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","ቱማካ ህጋይ ግዛይ ጋርክ ጽቃባዝታይፕ አትን ኡባ ባዝ ሱꬃር ጌዥዛ። ሱꬂ ላልንተካዝን ናጋራ ባራንችንቶያ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","ሳሎባዝ ኣዝሶ ማቄዝታይ ኡባይ መሄ ያርሾር ጌዦዳይስ ኮሽዛ። ዝን ሳሎባዝታይ ፋ ኦማስ የይፕ ኣꬊዝ ያርሾር ጌዦዳይስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","ክርስቶሳ ቱማ ጾስ ኬꬃይስ ኣዝሶ ማቄዛ፥ አስ ኩሸር ኦስንቴዝ ኡባፕ ጌሽ አቆ ገለካያ። ዝን ኤ Ꮊት ኑ ግሾስ ጾስ ቲና በንቶዳይስ ሳሎ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","ቄሰ ሀላቃይ ላይꬃ ላይꬃ ፋ ሱꬂ ባዛ ኤኪ፥ ኡባይፕ ኣꬊዝ ጌሽ አቆ ገልዛይ ጋርክ ክርስቶሳ ጋመ ቶኬ ፋና ያርሾዳይስ ማቂ ማቂ ገለካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","የይ ጋርክ ሀኔዝባዝ ማቄዛኮ፥ ክርስቶሳ አላመ መꬊንቴዛይፕ አይኪ ጋመ ቶኬ ዋይንቶዳይስ ኮሽዛ። ዝን Ꮊተ ዎደ ዉርስꬃ ናጋራ ꬋብሶዳይስ ፋና ያርሼዝ ላምሶዋ ኦገር ፐቲ ቶኬ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","አስ ኡባይስ ፐቲ ቶኬ Ꮊይቆዳይስ የይፕ ጉየ ፕርድንቶዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","የይ ጋርከካ፥ ክርስቶሳ ጋመ አሳይ ናጋራ ꬋብሶዳይስ ፐቲ ቶኬ ያርሽንቴዛ። ማቅካ ኤ ናጋራ ቶኮዳይስ ባዝን ፋና ናግዝታ አሾዳይስ ናምእንꬆ ቆንጮዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","ሙሰ ህጋይ የኦዳይስ የዝ ሎኦ ባዝታይስ ኤሾፕ አትን ጋማ ባያ። የይ ግሾስ፥ ላይꬃ ላይꬃ ፓጨ ባይꬅ ያርሽንትዝ ያርሻይ ጎይኖዳይስ ሺቅዛ አሳይ ፎሎ ኦꬆዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","ህገ ኡንታን ፎሎ ኦꬆዳይስ ዳንዳኤዛኮ ኡንቲ ያርሾ ያርሽዛ አሾዳዝን። ማ ጎይኖዳይስ ሺቅዛ አሳይ ፋ ናጋራይፕ ጌዦዳ፤ ኡ ካሃይካ ኡንታን ባላ ግ ሞታሚ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","ዝን የ ያርሽታይ ላይꬃ ላይꬃ ናጋራ ቆፍስዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","አብስ ጊኮ፥ ዎፋኖ ሱꬅኔ ዴሽ ሱꬂ ናጋራ ካዮዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","የይ ግሾስ፥ ክርስቶሳ Ꮊ አላመ የኤዝ ዎደ Ꮊይ ጋርክ ዬጌዛ፦ «ኔኒ ያርሾኔ እሞ ኮየካያ፤ ዝን ታስ አሾ ጊግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","ኔኒ ጹግንትዝ ያርሻይዳኔ ናጋራ ያርሻይድ ኡፋይተካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","የ ዎደ ‹ታ ግሾስ ማጻፋይድ ጻፍንቴዛይ ጋርክ፥ ጎዳዮ፥ ታኒ ነ ሸነ ኦꬆዳይስ የኤዛ› ዬጌዛ።» ");
INSERT INTO mfxe_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","ያርሾ ያርሽንቶዳይ ጋርክ ህገ ኪትዛባዝ ማቅኮካ፥ ክርስቶሳ ቲና፥ «ኔኒ ያርሾኔ ሙጻታ፥ ጹግንትዝ ያርሾኔ ናጋራ ያርሾ ኮየካያ፤ ኡንታል ኡፋይተካያ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","ካልካ ኤ፥ «ጎዳዮ፥ ዬዛኮ ታኒ ነ ሸነ ኦꬆዳይስ የኤዛ» ዬጌዛ። የይ ግሾስ፥ ክርስቶሳ ናምአንꬃና ኤሶዳይስ ቲናሳ ሻሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","የሱስ ክርስቶሳ ጾስ ሸነ ኡዲ፥ ላማማይስ ፐቲ ቶኬ ፋ አሾ ያርሼዝ ግሾስ ኑኒ ጌዤዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","ቄሰ ኡባይ፥ ናጋራ ꬋብሶዳይስ ዳንዳኦዳይ የ ያርሽታ ጋላስ ጋላስ ያርሽታር ኤቂ ፋ ኦሳ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","ዝን ክርስቶሳ መꬍናስ ማቄዝ ፐቲ ናጋራ ያርሾ ያርሼዝ፥ ጾሳይፕ ኡሻች ባጋ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","የ ዎዳይፕ አይኪ ኤ ሞርክታይ ኤ ቶካይስ የꬍዝበሳ ኡዶድ ሄሎዳይስ ናግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","ኤ ፐቲ ቶኬ ፋና ያርሼዝ ያርሻይድ ጌሽታ መꬍናስ ፎሎ ኡዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","ማ ጌሻ አያናይ ኑስ Ꮊይስ ማርካትዛ። ቲና Ꮊይ ጋርክ ዬጌዛ፦ ");
INSERT INTO mfxe_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","«የ ጋላስታይፕ ጉየ፥ ታኒ ኡንታር ጫቂዛ ጫቃይ Ꮊያ፦ ታኒ ታ ህጋ ኡ ካሃይድ ጋዶዳ፤ ኡ ዎዝናይድ ጻፎዳ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","ካልካ፥ «ታኒ ኡ ናጋራኔ ኡ ኢታ ኦሳ ማሂ ቆፓሚ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","ይኬ፥ ናጋራ አቶ ግንትንቴዛይፕ ጉየ ናጋራስ ያርሽንትዛ ያርሻይ ኮሾያ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","ይኬ፥ ታ እሹንꬆ፥ ኑኒ የሱሳ ሱꬅ ባጋር ኡባፕ ጌሽ አቆ ገሎዳይስ ኑስ አማንꬅዛባዝ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","ኑ ገሎዳና ክርስቶሳ ፋ ማጋራዣ፥ የይካ ፋ አሾ ባጋር ኑስ ዶዬዝ ኦሮꬅኔ ደኦ ማቄዝ ኦጋይራ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","ኑስ ጾስ ካራል አፋ ሹምንቴዝ ግታ ቄሰ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","ኑኒ ኢታ ካሃይፕ ጌዦዳይስ ኑ ዎዝና ዉርጽንቲ፥ ኑ አሰትꬃ ጽሎ ሃꬃር ሜጭንቲ፥ ሉለ ዎዝናራኔ ፎሎ አማኖር ጾስኮ ሺቆዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","ኑስ ኡፋይስ ቃላ እንጌዝ ጾሳይ አማንንቴዛይ ግሾስ ኑ ማርካትዝ ኡፋይሳ ኡሻች ሀድርስ ጌካ ሚንꬂ አይኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","ፐታይ ፐታ ሲቆራኔ ሎኦ ኦሶር ኑ ዋይዚ ባርክ የዞዳይስ ቤዝዛኮ ቆፕሶ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","ፐታይ ፐታይ ካሴ ሺቅዝ ሺቃ አሸካዛይ ጋርክ ኑኒ ፐትፕ ሺቅ ዞርንትዛና አሻሚ። ማቅካ ጎዳ ጋላሳይ ኡኬዛያ ይ ብእዛ ግሾስ የያ ካሴሳይፕ ኣꬂ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","ኑኒ ቱማ ኤራትꬅ ኤኬዛይፕ ጉየ ኤርታር ናጋራ ኦꬅኮ፥ ይከፕ ኑ ናጋራ ግሾስ ያርሽንቶድ ያርሻይ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","ይኬ አቴዛይ ያሽዝ ፕርዳኔ ጾስ ሞርክታ ጹጎዳይስ ማቄዝ ዎልቃማ ታማ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","ሙሰ ህጋ ኪትንታም እጼዝ ኦንካ ናምኢ ዎይ ሀይꬒ አስ ኤዛል አፋ ማርካትኮ ማሮትꬅ ባይꬅ Ꮊይቅዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","የዝን፥ ጾስ ናአ ካꬌዝ አꬃይ፥ ፋና ጌሼዝ ጾስ ቃላ ጫቆ ሱꬃ ቱና ባዝ ጋርክ ቆፔዝ አꬃይ፥ ማ ኣꬎ ኬሃትꬅ አያና ጫዤዝ አꬃይ፥ አብ ጋርክ ኢታ ፕርዳ ኤኮዳይስ ቤዝዛኮ አን ቆፖይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","ይኬ፥ «ኩሸ ከሶ ታባዝ፥ ታ ኩሸ ከሶዳ» ጌዛ ኑ ኤርዛ። ማካ፥ «ጎዳይ ፋ አሳይ ፕርዶዳ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","ደኦ ጾስ ኩሸ ፖክꬂ ኢታ ያሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","ይንትስ ጾስ ፖኦ ፖኤዛይፕ ጉየ ይ ጋመ ዋዬር፥ ግታ ቡተር ጋርዤዝ ብኒ ዎደ ቆፖይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","ፐቲ ፐቲ ቶኬ ይ አስ ቲና ጫዥንቴዛ፤ ባይእንቴዛ፤ ፐቲ ፐቲ ቶኬ የይ ጋርክ ዋየ ሄሌዝ አሳይር ፐትፕ ዋዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","ኣꬎዋኔ ኡባ ዎደ የዝዝ ሚሸ ይንትስ ሳሎ የዛና ኤሬዛይግሾስ አቻ የዝ አሳይስ ታ ቃꬌዛ፥ ይ ሻላይ ኤክንቶዳራካ ዳንዳአር የያ ይ ኡፋይሳር ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","ግታ ዎይቶ የዛ ግሾስ ይ ጎበትꬃ ኦልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","ጾስ ሸነ ኦꬂ ይንትስ እንግንቴዝ ኡፋይስ ቃላ ይ ደማድ ጋርክ ይባቲ ናጎዳይስ ኮሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","ሀጋ ጽቃ ዎደ የዛ፥ «የኦዳይስ የዛይ የኦዳ ጋምኤና። ");
INSERT INTO mfxe_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","ጌሽ አሲ አማኖር የዝዛ፥ ጉየ ሶልእኮ ታ ሸምፓታ ኤዛል ኡፋይቶያ።» ");
INSERT INTO mfxe_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","ኑና ማቅኮ ፋ ሸምፖ አሾዳይስ አማንዛ አሳይር የዛፕ አትን ꬋቦስ ጉየ ሶልእዝ አሳይር ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","አማኖ ጉሳይ ኡፋይስ ጋዲ በኤካ ባዝ በኤዛይ ጋርክ ኡዲ ቤዝዛ ባዝ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","ብኒ አሳይ ባዝ ማርካትንቴዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","አላማይ ጾስ ቃላር መꬍንቴዛና ኑ ኤርዛይ አማኖራ፥ የይ ግሾስ በንትዝ ባዝ ኡባይ በንቶዋ ባዛፕ ሀኔዛና ኑ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","አቤላ ቃኤላሳይፕ ኣꬊዝ ያርሾ ሺሼዛይ አማኖራ። ጾሳይ አቤላ ያርሻ ኡፋይሳር ኤክን አቤላ ፋ አማናይር ጌሽ ማቄዛይ ማርካትንቴዛ፥ ኤ Ꮊይቄዝባዝ ማቅኮካ ኤ አማናይ ባጋር Ꮊተካ ኦድታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","እኖኬ Ꮊይቆ በአማይ ጋርክ ፉደ ኤክንቴዛይ አማኖራ፥ ጾሲ ኤዛ ኤኬዝ ግሾስ በንተካያ፥ ኤ ኤክንቶዳይፕ ቲና ኤ ጾስ ኡፋይሴዛይ ኤስ ማርካትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","አማኖ ባይꬅ ጾሳ ኡፋይሶዳይስ ዳንዳኦያ፥ ጾስኮ ሺቅዛ ኣꬂ ጾስ የዛናኔ ኤዛ ኮይዝ አሳይስ እሞታ እንግዛ ማቄዛና አማኖዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","ኖሄ ሀጋ ኣፈር በንቶዋ ባዝታይስ ጾሲ ኤዛ ናግንቶዳይ ጋርክ ኤርሴዝ ዎዳ ጾስስ ያሽትታር ፋ ካራ አሳ አሾዳይስ አማኖር ማርካበ ኮቼዛ፥ ኖሄ አማናይር አላማይ ናጋራንቾ ማቄዛይ ኤርንትን ፕርድንቴዛ፥ ኖሄ አማኖር በንትዝ ጽሎትꬅ ላቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","አፍራመ ኤስ ኦድንቴዛና ፋ ጋደ ኡዲ ኤኮዳይስ ከዞ ግ ጼግን አና Ꮊንግዛኮ ኤረካዛር ከዜዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","ኤዛር ዎላ ኡፋይሳ ቃላ ላትዝታ ማቄዝታይ እሳቃራኔ ያይቆባር ዎላ በተትꬅ ጋደ እማꬅ ማቂ ዱንካነ የዜዛይ አማኖራ ");
INSERT INTO mfxe_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","ባሶር የዛኖ ጾሲ መꬌዛኖኔ ኮቼዝ ካታምቶ ኤኮዳይስ ናግታር የዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","ሳርስ ኡፋይስ እንጌዝ ጾሳይ አማንንትዛ ማቄዛና ኤሬዝ ግሾስ ላይꬅ ዉርኮካ ዎደጾዳይስ ዎልቃ ደንጌዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","የይ ግሾስ Ꮊይቄዝ አስ ጋርክ ታይብንቴዝ ፐቲ አፍራመፕ ሳሎ ጾልንቶ ጋርከኔ ሳአ ሻፈ ጋርክ ኮቺ በንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","Ꮊይትታይ ኡቢታይ አማኖር የዛር Ꮊይቄዛ፥ ጾሳይ ኡንትስ እማዳይስ ቃላ ገሌዛኖካ ደንገካያ፥ ማቆዝን ሃኮር ብኢ ደንጌዛይ ጋርክ ኡዲ ኡፋይሳር ኤኬዛ። ቢታል አፋ ኡ እማꬅኔ በተ ማቄዛናካ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","Ꮊይ ጋርክ ዬግዝ አሳይ ፓስ ማቅዝ ጋደ ናግዛና ቲሺ ኡዲ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","ኡ ፋ ከዜዝ ጋዳ ቆፔዛኮ ገድ ጉየ ማቆዳይስ ዳንዳኦዳዝኒ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","Ꮊት ማቅኮ ኣꬊዝ ሳሎ የዝ ጋዳ ላሞትዛ፥ የይ ግሾስ ጾስ ኡንትስ ካታማ ጊግሴዝ ግሾስ ኑ ጎዳ ግ ጼጎዳይስ ዬላꬆያ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","አፍራመ ፓጭንቴዝ ዎደ እሳቃና ያርሾስ ሺሼዛይ አማኖራ። ኤ ኡፋይስ ቃላ ኤኬዛይ ፋ ምጺ ናአ ያርሾዳይሲ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","የዝን ጾሲ እሳቃ ኮቻር ጼግንትዛ ጌዝን። ");
INSERT INTO mfxe_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","ጾሳይ Ꮊይቆፕ ደንꬆዳይስ ዳንዳእዛና አፍራመ አማኔዝ ግሾስ Ꮊይቄዝ ኣዝዝ አፍራመ እሳቃ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","እሳቃ ቲናፕ ሀኖድ ባዝ ብኢ ያይቆባኔ ኤሳወ አንጄዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","ያይቆባ Ꮊይቆስ ሄሊ ጉፈር ኤቂ ዮሴፋ ናእታ አንጄዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","ዮሴፋካ Ꮊይቆስ ሄሊ አማኖር እስሬለ ናእታይ ከሲ ባጋ ቆፔዛ። ፋ መቀꬃይ ባጋካ ኬኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","ሙሰ የልንቴዝ ዎደ ካራ አሳይ የገልስ ናአ ማቄዛና ብኢ ሀይዝ አግና ቆሴዛይ አማኖራ። ካታይ አዋጃይስካ ያሽተካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","ሙሰካ ድጬዛይፕ ጉየ ፋሮናስ ናአ ናአ ግንቶዳና እጼዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","የይ ግሾስ ኤዚ ናጋራራ በንትዝ ኡፋይሳፕ ኣꬂ ጾስ ዎያር መቶ ኤኮዳና ዶሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","ቲናስካ ፋ ኤኮድ ጋታ ትሽ ኡዲ በኤዝ ግሾስ ግብጸ ሻሎፕ ክርስቶሳ ግሾስ ካዉዥዛይ ኣꬎ ማቄዛና ቆፔዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","ካታይ ካቻይስ ያሽተካዛር ግብጸፕ ከዜዛይ አማኖራ፥ ኣፈር በኤካ ጎዳካ በኤዛይ ጋርክ ኡዲ ፋ ቆፋይድ ሚንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","ባይራ ናእታ ዎꬎዳይስ ኪትንቴዝ ኪታንችታይ እስሬልታይ ካራ ገላማይ ጋርክ ፓዝቃ ኡዴዛይኔ ሾንችታ ሱꬂ ትዤዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","እስሬልታይ መላ ቢታር ፒንጎዳይ ጋርክ ኡድን ዞቆ አባ ፒንጌዛይ አማኖራ፥ ግብጸ አሳይ ኡንቲሳይ ጋርክ ቁሊ ገሊ ምትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","እስሬልታይ ኢያርኮ ጋሰ ካለር ላፑን ጋላስ ዉቴዛይፕ ጉየ ኬꬃይ ዎዴዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","ዉሹምዛ ራአባ አዉዥዝታ ሳሮር ሞኬዝ ግሾስ አዛዝንቶዋ አሳይር Ꮊይቀካ አቴዛይ አማኖራ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","ይክ ታ ሀራ አብ ጎ ጌዶና ባጋ፥ ባረቃ ባጋ፥ ሳምሶኔ ባጋ፥ ዮፍታሄ ባጋ፥ ዳዉተ ባጋ፥ ሳምኤላ ባጋ፥ ናብታይ ባጋ ታ ቶሳማይ ጋርክ ታስ ዎዳይ ሃቴዛ ");
INSERT INTO mfxe_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","ኡንቲ አማኖር ካተትꬅታ ላꬄዛ ጽሎ ኦሶካ ኦꬄዛ፥ ኡንትስ እንግንቴዝ ኡፋይስ ቃላ ደንጌዛ ጋምታይ ዶናካ ጎርዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","ታማ ዎልቃ ꬋብሴዛ፥ ማሻ ኦጮፐ ቡቴዛ፥ ዳቡርሳፕ ምኖትꬃ ላምንቴዛ፥ ኦላር ቃርታ ማቄዛ፥ አላጋ ኦላንችታ ባይኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","ማችታይ Ꮊይቄዝ ኡ ዳብታይ ደንድን በኤዛ፥ ባግታይ አቶትꬅ ደንገካዛር ቲናፕ ደንዶዳይስ ቆፕ ዱማ ዱማ መቶ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","Ꮊንክታይ ካስ ባዝ ማቂ ሾጭንቲ የይፕ ኣꬎ አቻር ዱጽንቲ ዎይነ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","ሹቻር ሾጭንቲ፥ ማጋዘር ቆእንቴዛ፥ ማሻር ጋችንቲ Ꮊይቄዛ፥ ኡባ ባዝ ꬋብን መትንቴዛ፥ ማንቆነ በተ አስ ጋርክ ዋዬዛ፥ ዴሽ ማኦኔ ዱር ማኦ ማኢ ዩዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","ሊዦ ጋꬋራ፥ አምባ ጼራራ፥ ቢታ ኦላ ጋንጨራ ኮምኦር ዩዬዛ። የይ ጋርክ Ꮊን አላማት ኡንትስ ቤዝዛ አቆ ማቀካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","Ꮊይትታይ ኡቢታይ ኡ አማናይ ባጋ ማርካትኮካ ኡንትስ እንግንቴዝ ኡፋይሳ ሀጋ ደንጌካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","ኑ ባይꬂ ኡ ፎሎ ማቃማይ ጋርክ ጾሳይ ኑስ ኡባፕ ኣꬎ ባዝ ብኢ ጋዴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","ይኬ Ꮊይትታ ኣዝዝ ማርክታይ ሻራ ጋርክ ኑ ላንቃይር የዝኮ ኑካ ቶፎ ኡባ ኤልሲ ኑና ማርዛ ናጋራ ኑፕ ሃሲ፥ ኑ አማናይስ ኦማኔ ፎሎ ማቅዝ የሱሳና ብኢ ኑ ቲናይድ የዝ ዎꬃ ዳንዳአር ዎላ ዎጾዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","ኤዚ ኢታ ባዝ ኡባ ለቂ ፋ ቲናይድ የዝ ኡፋይሳይስ ማዝቃለል ጋርዢ ጾስ ዙፋነ ኡሻቻ በቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","ይኬ ይ አዛለካዛራኔ ዳቡረካዛር ናጋራንችታይፕ ኤዛ ሄሌዝ እጾ ኡባ ጋርዤዝ የሱሳና ቦኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","ይ ናጋራራ ቡትንትታር ሀጋ ሱꬂ ላልንቶድ ጋꬆ እጸካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","ጾሲ ፋ ናአ ጋርክ ይንታን፥ ዬጊ ዞሬዛና ይ ዶጌዛ። «ታ ናአዮ ጎዳይ ሴራ ለቂፐ፥ ኤ ነና ካጭዝ ዎደ ዳቡርፐ፥ ");
INSERT INTO mfxe_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","ጎዳይ ፋ ቃꬍዛ ናአ ካጭዛ» ፋ ናአ ጋርኪ ኡዲ ቢኢዛና ሴሪዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","ጾሲ ፋ ናአ ግ ይንታን ሴርዛ ግሾስ ዳንዳኦይታ። አደ ሴሮዋ ናአ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","ናአ ማቄዝ ኡቢታይ ኤክዛ ሴራ ይንትካ ኤካም እጽኮ አደ ኤርንቶዋ ናእታፕ አትን ናእታ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","የይፐካ ኣꬅ ኑና ሴርዛ አሾ አድታይስ ኑካ ያሽትዛ፥ የዝን ሸምፖር የዞዳይስ አያና አደ ማቄዛይስ አዛዝንቶዳይስ ዋይዚ ቤዞሳ? ");
INSERT INTO mfxe_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","ኡንቲ ፓስ ሎኤዛይ ጋርክ ጽቃ ዎደስ ኑና ሴሬዛ፥ ኤዛ ማቅኮ ኑና ኤ ጽሎትꬃ ግሽንቶድ ጋርክ ኑና አዶዳይስ ሴርዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","ሴራ ኡባይ የ ሳታይድ አዛንꬅዛ ባዛፕ አትን ኡፋይስዛ ኣዞያ፥ ጉየፕ ኤሪ ዉርኮ ሳሮትꬅ ኩሜዝ ጽሎትꬅ ኣፈ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","የይ ግሾስ ዶልኤዝ ኩሽታኔ ልቄዝ ይ ቡንቂታ ምንꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","ሾልዛይ ፓጾድ ጋርከፕ አትን ቡርቃማይ ጋርክ ይ ቶካይስ ሉለ ኦገ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","ጌሸትꬅ ባይꬂ አሲ ጾሳ በአዳይስ ዳንዳኦዋ ግሾስ አስ ኡባር ሳሮ የዞይታ፥ ጌሸትꬃር የዞዳይስ ሚንጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","ይንትፕ ኦስካ ጾስ ኣꬎ ኬሄትꬅ ፓጫማይ ጋርክ ናግንቶይታ የይ ጋርከካ አባ ጫሞ ኣፈ ኣፍዝ ጻጶ ይ ጋንጨ ዶላማይ ጋርከኔ ይንትፕ ጋምታ ዋይꬃማይ ጋርክ፥ ቱንሳማይ ጋርክ ይ ጋንጨ የዛማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","ተንቶትዛኔ ፐቲ ቶኬ ሙስስ ግ ፋ ባይራትꬅ ባይዜዝ ኤሳወ ጋርክ ማቃማይ ጋርክ ናግንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","ኤሳወ ጉየፕ አንጆ ኤኮዳይስ ኮይንካ አንጆ ካይንቴዛና ይ ኤርዛ፥ ዬኪ አፉጽ ሚንጊ ኮይንካ ደማዳይስ ዳንዳኤካያ፥ ማሮትꬅስካ ዎደ ደንገካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","ኩሸር አይክንቶዳይስ ዳንዳእንትዛ ኤጽዝ ታማይኮ፥ ሻራይኮ፥ ꬉማይኮ፥ ጎታይኮ፥ ናሳይኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","የ ቱልቱላ ጊርꬃይኮ ዎይ ኦድንትዛ ቃላ ስእንትዛይኮ ይ ሄለካያ፥ ያ ቃላ ስኤዝ አሳይ ሀራ ቃላ ኑስ ጉጅንትፐ ግ ዎሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","«ሀራ አቶዝን ዶአ የ አምባቶ ቦችኮ ሹቻር ሾጭንቲ Ꮊይቆ» ዬግዝ አዛዛይ ዴጼዝ ግሾስ ጋርዦዳይስ ዳንዳኤካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","ሙሰካ «ታ ያሽትዛ ታ ኩኩርዛ» ጎድ ጋꬆ በንትዝ ባዝ ኡባይ ጋመ ያሽዝ ባዝ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","ይንታን ማቅኮ ጽዮነ አምባኮ ኡኬዛ፥ እዛካ ደኦ ጾሳይስ ካታማ ሳሎ የዝ የሩሳላማቶ፥ ይንቲ ፓይዶባ ኪታንችታይኮ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","ኡ ሱንꬃይ ሳሎ ጻፍንቴዝ፥ ዎሳ ኬꬅስ ባይራ ናአ ማቄዝ አማንዛ አሳይ ሺቆ፥ ኡባይስ ፕርድዝ ጎድ ማቄዛይኮ፥ ፎሎ ደንጌዝ ጌሽ ሸምፕታይኮ ይ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","ኦሮꬅ ጫቆስ ግዶ ማቄዝ የሱሳኮ፥ አቤላ ሱꬃይፕ ኣꬊ ኦድዝ ዉርጽንቴዝ ሱꬃይኮ ይ ኡኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","የ ኦድዛና ይ ኤካሚ ጋማይ ጋርክ ናግንቶይታ፥ የይትታይ ሳአ አሲ ኦዴዝ ባዝ ስኤካ አቲ ቡተካዝን ኑኒ ሳሎፕ ኦድንቴዝ ባዝ ኤካም እጺ ዋይዚ ቡቶደ? ");
INSERT INTO mfxe_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","የ ዎደ ኤ ጊርꬃይ ቢታ ኤንእሴዛ፥ Ꮊት ማቅኮ «ታ ሳአ ኣዳ ባዝን ፐቲ ቶኬ ማሂ ሳሎካ ኤንእሶዳ» ዬጊ ቃላ ገሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","ሀኖ ዝን ፐቲ ቶኬ ታ ማሂ ግዛይ ኤንኦዋ ባዝታይ ጻጲ የዞዳይ ጋርክ ኤንእዛ ባዝታይ መꬍንቴዝ ባዝ ማቄዛይስ ꬋቦዳና ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","ይኬ ኑኒ ኤንኦዋ ካተትꬅ ኤኮድ ግሾስ ጾሳ ቦንችታራኔ ያሻር ጾሳ ኡፋይስታር ጎይንዛ አያና ዎላ አይኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","ኑ ጾሳይ ጹግዝ ታማ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","ኡባ ዎደ እሸትꬅ ሲቆ ይንትስ የሰ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","እማꬅ ሞኮ ዶግፓተ ፐቲ ፐቲ አሳይ እማꬅ ሞክታር ኤረካዛር ፐቲ ጋላስ ኪታንቾ ሞኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","ኡንታር ዎላ አጭንቴዝ አስ ጋርክ አጭንቴዝ አሳ ዶግፓተ፥ መቶ ኡንታር ዎላ ኤክዛ አስ ማቂ መትንቴዝ አሳ ቆፖይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","ገሎኔ ኤኮ ኡባ አስ ካለ ቦንችንቴዛ ሂጻይካ ጌሽ ማቆ፥ ናጋራስ ተንቶትዝታ ላምዝታ ጾሳይ ፕርዶዳ፥ ማችኔ አዝኒ አማንንታም እጺ ገሎኔ ኤኮ ቱንስፐ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","ሚሸ ዣረፕ ሃኮይታ፥ ይንትስ የዛና ግዶ፥ ጾስ «ታ ኡባር ነና አሻሚ ኡባራካ ኦላሚ» ዬጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","የይ ግሾስ ኤዛል አማንንቲ «ጎዳይ ታና ማዶዳ ታ ያሽታሚ፤ አሲ ታና አብ ኡዶዴ?» ኑ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","ይንትስ ቲና ጾሳ ቃላ ኦዴዝ ዋንታ አስታ ቆፖይታ፥ ኡ የሳኔ ኡ ኦሳይ አፋ ብኢ ቆፒ አማኖር ኣዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","የሱስ ክርስቶሳ ዝቅነኔ Ꮊይኖ መꬍና ሄሎዳይስካ ኤ ኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","ዱማ ዱማ ኦሮꬅ ትምርተር ኤክንትፓተ፥ ይ ዎዝናይ ሙስ ዎጋር ባዝን ጾስ ኣꬎ ኬሃትꬃር ጻጲኮ ሎኦ፥ ሙስ ዎጋ ካሌዝ አሳይ ማድንተካያ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","ኑስ ያርሾ አቆ የዛ፥ ማቅኮካ ዱንካነ ጋንጨ ኦꬅዛ ቄስታይ ያርሾ አቆ ካꬃ ኤኪ ማዳይስ ዳንዳኦያ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","አይሁደ ቄስታይ ሀላቃይ ናጋራ ባራንቾዳይስ መሄ ሱꬅ ኤኪ ጾስ ካራ ቆልአ ገልዛ፥ አሻና ሄራፕ ጋጻ ከሲ ጹግዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","የሱሳ የይ ጋርክ ፋ ጋዛ ሱꬃይር አሳ ጌሾዳይስ ካታማይፕ ጋጻ ከዚ መቶ ኤኬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","ኑካ ሄራፕ ከዚ ዎላ ኤኮ Ꮊማዳ፥ ኤ ካዉሻትꬃካ ዎላ ሻግንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","ኑኒ ሀጋ የኦዳይስ የዝ ካታምቶ ናግነፕ አትን ሚንጊ የዝዝ ካታማ Ꮊ ሳአል ኑስ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","ይኬ የሱስ ክርስቶሳ ባጋር ጋላታ ያርሾ ኡባ ዎደ ጾስስ ዎላ ሺሾዳ፥ የይካ ኤ ሱንꬃይስ ማርካትዝ መተርሽታይፕ ሺቅዛ ጋላታ ያርሾ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","ሎኦ ባዝ ኦꬆኔ የዛ ባዛፕ ሀራስ ሻጎ ዶግፓተ፥ ጾስ ኡፋይስዛይ የይ ጋርክ ያርሾ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","ይንታን አቅስዝታይስ ኪትንቶይታ፥ ኡ ማዉታይፐካ ኦሞር የዞይታ፥ ኡንቲ ኦይጭንትዝ ማዉተ የዛ ግሾ ይ ሸምፓይስ ዋይዛ፥ ይ ኡንትስ ኪትንትኮ ኡ ፋ ኦሳ ኡፋይሳር ኦꬆዳ፥ የይፕ አትኮ አዛንታር ኦꬅዛ፥ የይ ይንታን ማድዛ ባዝ ባያ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","ኑስ ዎሶይታ፥ ኡባ ባዛር ኑ ሎኦር የዞዳይ ጋርክ ኑስ ሎኦ ካሃ ኑስ የዛና ኑ ኤሬዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","ኡባራካ ታ ይንትኮ ኤልሲ ማቃዳይ ጋርክ ሚንጊ ዎሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","መꬍና ጫቆ ሱꬃር ባይራ ዱርታይስ ሄንꬃንቾ ማቄዝ ኑ ጎዳ የሱሳና Ꮊይቆፕ ደንꬄዝ ሳሮትꬅ ጎዳ ");
INSERT INTO mfxe_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","ኤ ሸና ፖሎድ ጋርክ ሎኦ ኦሶ ኡባር ይንታን ዳንጭሾ፥ ኤዛ ኡፋይስዛ ባዝ የሱስ ክርስቶሳ ባጋር ኑል ኦꬆ፥ የሱስ ክርስቶሳስ መꬊናፕ መꬍና ሄሎዳይስ ቦንቾ ማቆ አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","ታ እሹንꬆ Ꮊና ታ ጻፌዛና ሃታ ኪታ ማቄዝ ግሾስ ታ ዞረ ቃላቶ ዳንዳአር ናጎድ ጋርክ ሚንꬂ ታ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","ኑ እሻ ጽማቶሳ አቻፕ ብልእንቴዛና ኤሮይታ። ኤ ኤልሲ Ꮊና ይእኮ ታ ኤዛር ዎላ ይንታን በአዳይስ Ꮊማዳ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","ይንታን አቅስዛ አሳይስኔ ጌሽ አስ ኡባይስ ሳሮꬃ ሺሾይታ፥ ጻላነፕ ይኢ Ꮊይዳ የዝ አማኔዝ አሳይ ሳሮꬆ ይንትስ ሺሽዛ። ");
INSERT INTO mfxe_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","ኣꬎ ኬሄትꬂ ኑር ኡባይር ማቆ አምንኤ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","ጾሳ ጎዳ የሱስ ክርስቶሳ አይላይ፥ ያይቆባ፥ አላመ ኡባይል ላልንቴዝ ታጶ ናምኢ ሼሽታይስ ኪቴዝ ኪታ። ሳሮ፥ ይንትስ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","ታ እሹንꬆ፥ ይንታን ዱማ ዱማ ፓጨ ሄልኮ ይ ሎኦ ባዝ ደንጌዛይ ጋርክ ኡዲ ኩንꬅ ኡፋይሳር ኤኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","ይ አማናይ ፓጭንታይ ይንትስ ጋርዦ እንግዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","ይ ዉርስꬅ ሄሎዳይስ ይባታር ዳንዳእኮ አብካ ፓጨካ ይንታን ፖሎኔ ኩንꬅ ማሆ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","ይንታፕ ኦስካ ኤጨትꬂ ꬋብኮ ጾስ ዎሶ። ኤ ይንትስ እንጎዳ። ጾሳይ ኦናካ ቦረካዛር ኡባይስ ኬሃትꬃር እንግዛ ጾስ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","ዝን ዎስታር አማኖር ሰኤካዛር ጾሳ ዎሶ። ሰእዛ ኦንካ ጫርኮ ኤንእስን ኤንእዛ አባ ዙሎ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","8","ናምኢ ቆፋ የዛይነ ፋ ኦጋይል ኤቆያ ኦንካ ጎዳይፕ አብካ ደማዳ ኣዝፐ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","አማንዛ ማንቆ አሳይ፥ ጾሳይ ኡንታን ꬎቅ ኡዶድ ግሾ ኡፋይቶ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","አስ ዱረትꬂ ፉ ጋርክ ꬋብዛ ግሾስ አማንዛ ዱረ አሳይ ጾሳይ ኡንታን ዝቂ ኡድኮካ ኡፋይቶ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","አዋይ ፋ ምሻር ከዚ ማታ መልስዛ፥ ፉꬋ ጉፍስዛ፤ ኤ ሎኦትꬃይካ ꬋብዛ። የይ ጋርከካ፥ ዱረ አሳይ ፋ ኦሶር ዳቡርታር ꬋቦዳ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","መቶ ጋሚ ኣꬌዛይፕ ጉየ፥ ጾሳይ ፋና ቃꬊዝታይስ እማድ ግ ቃላ ጫቆ ገሌዝ ደኦ ዛዉደ ኤኮድ ግሾስ መቶር ጋርዥዛ አስ አንጅንቴዛያ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","ኦንካ ፓጭንትዛ ዎደ «ታና ጾሳይ ፓጬዛ» ጊፐ። ጾሳይ ኢታር ፋጮያ፤ ማ ኤ ኦናካ ፋጮያ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","ዝን ፐቲ ፐቲ አስ ፋ ኢታ አሞትꬃር ጎሽንትታራነ ዶሽንትታር ፓጭንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","የይፐ ጉየ፥ አሞትꬅ ዎደጺ ናጋራ የልዛ፤ ማ ናጋራ ድጪ Ꮊይቆ የልዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","ታ ሲቆ እሹንꬆ፥ ዶሽንትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","ሎኦ እሞኔ ኩንꬅ አንጆ ኡቢታይ ሳሎፕ ይእዛ። የይካ ኩያ ጋርክ ኡባ ዎደ ዉቶዋ ዎይ ላምንቶዋ ፖእታይ አዳይ ጾሳይፕ ይእዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","ኑኒ፥ ኤ መትꬅስ ባይራ ማቃድ ጋርክ ኑና ቱማ ቃላር ፋ ሸነር የሌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","ታ ሲቆ እሹንꬆ፥ Ꮊያ ዶግፓተ። አስ ኡባይ ስኦዳይስ ኤልሶ፥ ዝን ኦድንቶዳይስኔ ካጭንቶዳይስ ኤልስፐ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","አስ ካቺ ጾሳይ ጽሎትꬃ ኮኦያ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","የይ ግሾስ፥ ቱና ሀኖኔ ኢታትꬅ ኡባ ꬋብሲ፥ ጾሳይ ይ ዎዝና ጋንጨ ቱኬዝ ይ ሸምፖ አሾዳይስ ዳንዳእዛ ቃላ ሃዮትꬃር ኤኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","ዝን ጾስ ቃላ ኦሶል ፔሾይታፕ አትን ስእꬅ ኣዳር ይንታን ዶሽፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","ቃላ ስኢ ኦꬆዋ አሲ፥ ኤ ፋና ማስቶተር ብእዝ አስ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","ኤ ፋና ብኢ ማቂ ቅትዛ፥ ዝን ኤ አብ ኣዝዛኮ ኤልሲ ዶግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","ዝን ኦንካ ዋሎ ከስዛ ፎሎ ህገ አካካር ብኢ፥ ካሊ ናግዛይ፥ ስኤዛና ዶገካ ኦሶል ፔሽዛ አꬃይ፥ ፋ ኦሶ ኡባይር አንጅንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","ፋ እራንꬃ ናገካዛር ጎይንዛ ግዝ አꬃይ ፋና ዶሽዛ፤ ኤ ጎይናይ ጨረ። ");
INSERT INTO mfxe_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","ጾስ አዳይ ቲና ቦሮ ባ ጌሽ ጎይናይ Ꮊያ፦ ዥኦ ናእታኔ አምእታ ኡ መታይድ ማደኔ አላመ ቱናፕ ፋና ናጎ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","ታ እሹንꬆ፥ ይ ኑ ቦንቾ ጎዳ የሱስ ክርስቶሳ አማንዛ ማቅኮ፥ አስ ኣፈ ብኢ አስ ቦንችፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","ኣዝሶስ፥ ዎርቀ ምግዶ ኣꬂ፥ ሎኦ አፍላ ማኤዝ ዱረ አስ ይ ሺቃይድ የኤዛ። ማ ጩርቃ አፍላ ማኤዝ ማንቆ አስካ የኤዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","ሎኦ አፍላ ማኤዝ አꬃ ይ ኣꬂ ቦንቺ፥ «ነ Ꮊኔ ሎእዛ ኦይዳትል በቶባ» ግ፥ ማ ማንቆ አꬃ፥ «ነ ኤዛይድ ኤቆባ ዎይ Ꮊኔ ታ ቶኬ ላንቃተ ሳአ በቶባ» ይ ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","የዝን፥ ይንቲ፥ ይ ጋንጨ ሻኮ መꬌዝታኔ ኢታ ቆፋር የዝ ዳይንታይ ጋርክ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","ታ ሲቆ እሹንꬆ፥ ስኦይታ። አማኖር ዱረ ማቃድ ጋርክ ፋና ቃꬍዝታይስ እማድ ጌዝ ሳሎ ካተትꬂ ላቶድ ጋርክ Ꮊ ሳአል ዬዚ ማንቅታ ጾሳይ ዶረካሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","ዝን ይ ማንቅታ ቶችዛ። ይንታን ጪጵችዝታይኔ ፕርደ ኬꬅ ጎችዝታይ ዱርታ ባሳኔ? ይንታን ዳይና ቲና ጎችዝታይ ኡንታን ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","ይ ጼግንቴዝ ቦንቾ ሱንꬃ ጫዥዝታይ ኡንታን ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","ዝን ጌሻ ማጻፋይድ፥ «አስ ኡባ ነና ነ ቃꬍዛይ ጋርክ ቃꬎባ» ግንትንቲ ጻፍንቴዝ ጾስ ካተትꬅ ህጋ ይ ፖልኮ ሎኦ ባዝ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","ዝን ይ አስ ኣፈ ብኢ ቦንችኮ፥ ናጋራ ኦꬅዛ፥ ማ ህጋይ ይንታን ህገ መንꬄዝ አስ ጋርክ ፕርዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","ኦንካ ጾስ ህገ ኡባፕ ፐታ አሺ፥ አቴዝታ ኡባ ናግኮ ኡባና መንꬄዛይ ጋርክ ታይብንትዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","«ላምፐ» ጌዝ ጎዳይ፥ ማ «ዎꬍፐ» ጌዛ። ዝን ኔኒ ላመካ አቲ ዎꬌዝ ማቅኮ፥ ህገ መንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","ዋሎ ከስዛ ህገ ቲና ፕርደ ኤኮዳይስ የዝ አስ ጋርክ ኦድንቶይታነ ኦꬆይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","አስ ማሮዋ ኦናካ ጾሲ ፕርዶዳ ማሮትꬅ ባይꬅ ፕርዶዳ። ማቆዝን ማሮትꬅ ፕርዳ ጋምዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","ታ እሹንꬆ፥ ይንትፕ ፐቲ አሲ ታስ አማኖ የዛ ግ፥ ፋ አማኖ ኦሶር ቤዘካ አትኮ ኤዛ አብ ማዶዴ? ኤ አማናይ ኤዛ አሾዳይስ ዳንዳእኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","ኣዝሶስ ፐቲ እሻይ ዎይ ፐቲ ምሽታ ካሎትኮኔ ኡንትስ ሚዝባዝ ꬋብኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ይንትፕ ፐቲ አሲ ኡንትኮ፥ «ሳሮ Ꮊንጎይታ! ይንታን ሆኦ! ም ምዦይታ!» ግ፥ ኮሽዛ ባዝ ኡንትስ እንገካ አትኮ ኡንታን አብ ማዴ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","የይ ግሾስ፥ ኦሶ ባ አማኖ ፋ ኣዳስ Ꮊይቆ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","ዝን ፐቲ አሲ፥ «ኔስ አማኖ የዛ፤ ማ ታስ ኦሶ የዛ። ነ ነ አማና ነ ኦሳይፕ ሻኪ ታና ቤዞባ፤ ታካ ታ አማና ታ ኦሶር ነና ቤዞዳ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","ኔኒ፥ ፐቲ ጾሲ የዛና አማንዛ፤ የይ የሰ። ቱና አያንታይካ አማንዛ፤ ያሻር ኩኩርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","ነኖ ቦዛዮ! አማኖ ኦሶፕ ሻክንቲ Ꮊይቆ ማቄዛና ኤሮዳይስ ኮይኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","ኑ አዳይ አፍራመ፥ ፋ ናአ እሳቃ ያርሾ አቆል አፋ ጋዴዝ ዎደ ጽሌዛይ ፋ ኦሶር ባሳ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","ኤ አማናኔ ኤ ኦሳይ ዎላ ኦꬄዛኔ ኤ አማናይ ኦሶር ፖልንቴዛና ቦኦሳ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","ጌሻ ማጻፋይ፥ «አፍራመ ጾስ አማኔዛ። ጾሳይ የያ ኤዝስ ጽሎትꬅ ኡዲ ታይቤዛ» ጌዛይ ፖልንቴዛ። ማ ኤ ጾስ ዳቦ ግንትንቲ ጼግንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","አሲ አማኖ ኣዳር ባዝን ኦሶር ጽልዛና ነ ብእኔ። ");
INSERT INTO mfxe_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","የይ ጋርከ፥ ዉሹምዛና ራአባ እስራኤለፕ ኪትንቴዝታ ሞኪ ሀራ ኦገር ኡንታን ሞይዜዝ ዎደ ፋ ኦሶር ጽለካሳ? ");
INSERT INTO mfxe_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","ሸምፖፕ ሻክንቴዝ አሻይ Ꮊይቆ ማቄዛይ ጋርክ፥ ኦሶፕ ሻክንቴዝ አማናይካ Ꮊይቄዝባዝ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","ታ እሹንꬆ፥ ይንታፕ ጋምታይ አስታማረ ማቅፐ። ኑ፥ አስታማርታይ Ꮊንክታይፕ ኣꬊዝ ፕርዳ ኤኮዳና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","ኑ ኡቢታይ ጋመባዛር ባልንትዛ። ፋ ኦዳይር ባልንቶዋ ኦንካ ፋናትꬃ ናጎዳይስ ዳንዳእዛ ፎሎ አስ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","ፓርታይ ኑስ ኪትንቶድ ጋርክ ብጻላ ባርሲ ኑ ኮይዝ አቆ ኡባ ካንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","ማርካበ አብ ጋርክ ግታ ማቅኮካ ዎልቃማ ጫርኮር ኡርቅንትኮካ፥ ላግዛይ ፋ ኮይዝ አቆል ማሂ ላግዛ ጽቃ ምꬃር ላግንቲ Ꮊንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","የይ ጋርክ እራንꬅ አሰትꬅ ክፕለፕ ጽቃት ማቅኮካ ጋመ ዳማባዛል ጬቅንትዛ። ጽቃ ታማ ዳማ ዎራ ጹግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","እራንꬂ ታማ ጋርከ። እራንꬅ ኑ አሰትꬅ ጋንጨ የዝ ኢታ አላመ፤ አሰትꬅ ኡባ ቱንስዛ። ጋናመፕ ከዝዝ ታማ ጋርክ ኑ ደኦ ላሶ ኡባ ጹግዛ። ፋ ኦማስካ ጹግንቶዳ ");
INSERT INTO mfxe_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","ቢታ ዶእታኔ ካፍታ፥ ኡሎር ጎሽንትዝታኔ አባ የዝ መትꬅታካ ኡባ አሲ ሞድዛ፤ ኡንትካ ሞድንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","ዝን ኦንካ እራንꬅ ሞዶዳይስ ዳንዳኤካያ። እራንꬂ ዎꬍዛ ማርዘ ኩሜዝ ሞድንቶዋ ኢታ መትꬂ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","ኑ እራንꬃር ኑ ጎዳነ ኑ ኣዳ ጾሳ ጋላትዛ። ማ ኤዛር ጾስ ኣዚ መꬍንቴዝ አስ ባድዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","ፐቲ ዶናፐ ጋላታኔ ባድꬂ ከዝዛ። ታ እሹንꬆ፥ Ꮊይ ጋርክ ሀኖዳይስ ቤዞያ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","ፐቲ ኦላፕ ማልእዛ ሃꬅኔ ጫንግዛ ሃꬂ ፑልቶዳይስ ዳንዳእኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","ታ እሹንꬆ፥ ባላሰ ምꬂ ዎይራ ኣፎዳይስ ዳንዳእኔ? ዎይ ዎይነ ምꬂ ባላሰ ምꬅ ኣፈ ኣፎዳይስ ዳንዳእኔ? ጫሞ ሃꬃፕ ማልእዛ ሃꬂ በንቶዳይስ ዳንዳእኔ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","ይ ጋንጨ ኤጫኔ አካክዛይ ኦኖ? ፋ ሎኦ የሳር፥ ሃዮትꬃር ኤጨትꬃር ፋ ኦꬄዝ ኦሳ ቤዞ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","ዝን ይ ዎዝናይድ ጫንግዛ ቅናተኔ ፋና ቃꬍዝ ኤጨትꬂ የዝኮ ጋይርንትፓተ፤ ቱማል አፋ ዎርዶትፓተ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","የይ ጋርክ ኤጨትꬃይ ሳሎፕ የኤዝ ባዝ ባዝን የይ አሾፐ፥ አላመፐኔ፥ ጻላሄፐ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","ቅናተኔ ፋና ዶሶ የዝ አቆ ካችኔ ኢታ ኦሶ ኡቢታይ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","የያ ማቆዝን ኣፋፕ ይእዝ ኤጨትꬃይ ኡባይፕ ቲና ጌሺ። ማ የይፐ ሳሮትꬅ፥ ሎኦትꬅ፥ ስኢ ኤክዛ፥ ቃꬊንትዛ፥ ሎኦ ኣፈ ኩሜዛኔ፥ አስ ሻጎዝታኔ ጩቦተꬅ ባዛያ። ");
INSERT INTO mfxe_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","ሳሮትꬅ ዶስዝታይ ሳሮትꬅ ዘሪ ጽሎትꬅ ማጽዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","ካችኔ ኦላ ይ ጋንጨ አናፕ የኤኔ? የይትታይ ይ አሰትꬅታይ ጋንጨ ኦልንትዛ ይ አሾ እናፕ ባሳኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","ይንቲ አሞትዛ፥ ዝን ደንጋሚ፤ የይ ግሾስ ዎꬍዛ። ሚንꬂ ኮይዛ፥ ዝን ደንጎዳይስ ዳንዳኦያ፤ የይ ግሾስ ካጭንትዛኔ ኦልንትዛ። ይ ጾሳ ዎሶዋ ግሾስ ኮይዝ ባዝ ደንጋም። ");
INSERT INTO mfxe_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","ይ ዎስዛ፥ ዝን ደንጋሚ። ይ አሾ አሞ ፖሎዳይስ ዡጫ ኦገር ዎስዛ ግሾስ ደንጋሚ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","ይንታኖ፥ ካድዝታዮ! Ꮊ አላመ ዶስዛይ ጾሳር ሞርከ ማቅዛና ይ ኤሮሳ? Ꮊ አላማይር ዳቦቶዳይስ ኮይዝ ኦንካ ጾሳር ሞርከ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","ጌሻ ማጻፋይ፥ «ጾሳይ ኑር የዞድ ጋርክ ኦꬄዝ አያናይ፥ ኑኒ ኤዝስ ቡዞ ማቃድ ጋርክ ሎእꬂ አሞትዛ» ጌዛይ ጨረ ኦድዝባዝ ኣዝኔ? ");
INSERT INTO mfxe_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","ዝን ጌሻ ማጻፋይ፥ «ጾሳይ ኡትርትዛ አስታ እጽዛ፥ ዝን ሀይታይስ ኣꬎ ኬሄትꬅ እንግዛ» ዬግዝ ግሾስ ጾሳይ ኣꬎ ኬሄትꬅ ጋንꬂ እንግዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","የይ ግሾስ፥ ጾስስ ሞድንቶይታ፤ ዳቡሎሳር ኤቅንቶይታ፤ ኤ ይንታፕ ሃኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","ጾስኮ ሺቆይታ፤ ኤ ይንትኮ ሺቆዳ። ይንታኖ፥ ናጋራንችታዮ፥ ይ ኩሻ ሜጮይታ፤ ናምኢ ቆፋር የዝታዮ፥ ይ ዎዝና ጌሾይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","ካያቶይታ፥ ዬኮይታኔ አፉጾይታ። ይ ሚቻይ ዬፎር፥ ይ ኡፋይሳይ አዛኖር ላምንቶ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","ጎዳይ ቲና ይ ኡባ ዝቃ ኡዶይታ፤ ኤ ይንታን ꬎቅ ꬎቅ ኡዶዳ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","ታ እሹንꬆ፥ ፐታይ ፐታ ዝግርፓተ። ፋ እሻ ዝግርዛይኔ ኤዛል አፋ ፕርድዛይ ህገ ዝግርዛኔ ህገል አፋ ፕርድዛ። ኔኒ ህገል አፋ ፕርድኮ ህገል አፋ ፕርድዛ ማቅዛፕ አትን ህገ ፖልዛ አስ ነ ማቆያ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","ህገ እንግዛይኔ ፕርድዛይ ጾስ ኣዳ። አሾዳይስኔ ꬋብሶዳይስ ዳንዳእዛይ ኤዛ። የዝን፥ አሳል አፋ ፕርድዛይ ነ ኦኖ? ");
INSERT INTO mfxe_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","ይ፥ «ኑኒ Ꮊይኖ ዎይ ዎንታ የ ካታማ ዎይ Ꮊ ካታማ Ꮊማዳ፤ ኤዛይድ ላይꬅ በቶዳ፤ ዛልእ ዎꬍሶዳ» ዬግዝታዮ፥ ስኦይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","ዎንታ አቢ ሀኖዳዛኮ ይ ኤሮያ። ይ የሳይ ዋያዳዛኮ ኤርዛይ ኦኖ? ይንቲ ጽቃ ዎደ በንቲ ꬋብዛ ሻራ ጋርከ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","የያ አሺ፥ «ጎዳይ ጊኮ ኑኒ የዞዳ፤ Ꮊያ ዎይ የያ ኦꬆዳ» ዬጎዳይስ ቤዝዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","ዝን ይ Ꮊተ ኡትርትዛኔ ጬቅንትዛ። የይ ጋርክ ጬቅንታ ኡባይ ኢታ። ");
INSERT INTO mfxe_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","የይ ግሾስ፥ ሎኦ ባዝ ኦꬆዳይስ ኤርታር ኦꬆዋ አꬃይስ የይ ናጋራ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Ꮊተካ ይንታኖ፥ ዱርታዮ፥ ይንታል አፋ ኢታ መታይ ይእዛ ግሾስ ዎ ዎ ግ ዬኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","ይ ሻላይ ቡቄዛ፤ ይ አፍላይካ ብላር ሚንትንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","ይ ዎርቃይኔ ይ ብራይ ባልቴዛ። የ ባልትꬃይ ይንትስ ማርካ ማቃዳ። የይካ ይ አሻ ታማ ጋርክ ማዳ። ይ Ꮊ ዉሬዝ ቃምታይድ ይንትስ ሻሎ ጋንꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","ይንቲ ጋደ ኦꬂ ፔዤዝ አሳይ ከራ ሚሸ ይ ጭግበኤካያ። የይ ይንታል አፋ ኡክዛ። የ አሳይ ኡፋይ ዎልቃማ ጎዳይ ሀየ ስንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Ꮊ ሳአል ይንትስ ጊግን ኡፋይሳር የሳዳይስ ቆፒ፥ ሹኮስ ጊግንቴዝ መሄ ጋርክ ይንታን ꬊክ ኦርድሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","ይንታር ኤቅንቶዋዝን ጽላያ ይ ፕርዴዛ፤ ኤዛ ዎꬌዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","ታ እሹንꬆ፥ ጎዳይ ይእꬃ ጋርዢ ናጎይታ። ዎታር አቅዝ አꬃይ ቶርቼል ቲና እራኔ ጉየ እራ የኦድ ጋꬆ ጋርዢ አልኦ ካꬃ ቢታፕ ዋይዚ ናጊ ሄልꬂ ኤክዛኮ ቆፖይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","ይንትካ ጋርዦይታ። ጎዳ ይእꬃይ ኡኬዝ ግሾስ ኡፋይሳር ናጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","ታ እሹንꬆ፥ ጾሳይ ይንታል አፋ ፕርዳም ጋርክ ፐታይ ፐታይል አፋ ዝግርፓተ። ፕርድዛይ ፐንገል ኤቄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","ታ እሹንꬆ፥ ዋዬር ጋርዤዝ፥ ጎዳይ ሱንꬃር ኦዴዝ ናብታ ኣዝሶ ኡዲ ኤኮይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","ዳንዳአር ጋርዤዝታ ኑኒ አንጅንቴዝታ ግዛ። ኢዮባ ዋይዚ ጋርዤዛኮ ይ ስኤዛ። ጎዳይ ዉርስꬃል ኤዛ ዋይዚ ማዴዛኮ ይ በኤዛ። ኤ ማሮትꬅኔ ቃ ኩሜዝ ጎዳ ማቄዝ ግሾስ የያ ኦꬄዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","ዝን ኡባፕ ቲና፥ ታ እሹንꬆ፥ ሳሎር ማቅን ዎይ ሳአር ማቅን ዎይ ሀራ አባራካ ጫቂፓተ። ጾስ ፕርዳ ይ ገላማይጋርከ ይ ኦዳይ ኤ ማቅኮ፥ «ኤ» ጎይታ፤ ዋኣ ማቅኮ፥ «ዋኣ» ጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","ይ ጋንጨ መቶ ኤክዛ ኦንካ የዝኮ ጾሳ ዎሶ። ኡፋይትዛ ኦንካ የዝኮ ጋላታር የጾ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","ይንትፕ ሀርግንቴዝ ኦንካ የዝኮ ዎሳ ኬꬅ ጭምታ ጼጎ። ኡ ጎዳይ ሱንꬃር ዎይራ ዛይተ ትዢ ኤዝስ ጾሳ ዎሶ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","አማኖር ዎሴዝ ዎሳይ ሀርገር የዛና ፓꬅዛ። ጎዳይ ኤዛ፥ ሀርገፕ ደንꬅዛ፤ ኤ ናጋራ ኦꬄዝ ባዝ ማቅኮካ ጎዳይ ኤዛ ማርዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","የይ ግሾስ፥ ይ ፓጾድ ጋርክ ይ ናጋራ ፐታይ ፐታይስ ፓጾይታኔ ፐታይ ፐታይስ ዎሶይታ። ጽሎ አስ ዎሳይ ዎልቃማ ኦሶ ኦꬅዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","ኤላሳ ኑ ጋርክ አስ ዝን እራ ሳአል ቡካማይ ጋርክ ሚንꬂ ጾስ ዎስን ሀይꬒ ላይꬅኔ ኡሱፑን አግና ሳአል እራ ቡከካያ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","ማቂ ኤ ጾሳ ዎስን ሳሎፕ እራ ቡኬዛ፤ ሳአይካ ካꬃ ዶልሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","ታ እሹንꬆ፥ ይንታፕ ኦንካ ቱማ ኦገፐ ቡትኮ፥ ሀራይ ኤዛ ቱማኮ ማህኮ፥ ");
INSERT INTO mfxe_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","ናጋራ ኦꬅዛና የ ቡታ ኦገፐ ማህዝ ኦንካ፥ ኤ ሸምፖ Ꮊይቆፕ አሽዛኔ ኤ ጋመ ናጋራይስ ማሮትꬅ እንግዛና ኤሮ። ");
INSERT INTO mfxe_vpl VALUES ("P11_1","090_1_1","1PE","1","1","1","ታኒ፥ የሱስ ክርስቶሳ ሀዋራይ ጵጽሮሳ፤ ጳንጾሳ፥ ጋላትያ፥ ቃጳዶቃ፥ ኢሳኔ ብታና ጋደ በተ አስ ጋርክ ላልንቲ የዝ ጾሲ ዶሬዝ፥ አሳይስ Ꮊ ዳብዳባ ጻፌዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_2","090_1_2","1PE","1","2","2","የሱስ ክርስቶሳስ ይ ኪትንቶድ ጋርከኔ ኤ ሱꬃይር ጌዦዳይ ጋርከ፥ ጾስ አዳይ ፋ ቲና ኤራር ዶሬዝታይስኔ ጌሻ አያናር ጌዤዝ፥ ይንትስ ኣꬎ ኬሃትꬅኔ ሳሮትꬅ ማቆ። ");
INSERT INTO mfxe_vpl VALUES ("P11_3","090_1_3","1PE","1","3","3","የሱስ ክርስቶሳና Ꮊይቆፕ ደንꬂ ፋ ግታ ማሮትꬃይር ናምአንꬆ የልንታይር ꬋቦዋ ኡፋይስ እንጌዝ ኑ ጎዳ የሱስ ክርስቶሳ አዳይ፥ ጾሳይ ጋላትንቶ። ");
INSERT INTO mfxe_vpl VALUES ("P11_4","090_1_4","1PE","1","4","4","ማ ጾሲ ይንትስ ꬋቦዋ፥ ኢቶዛኔ ቡቆዋ ጋደ ሳሎ ጊግሴዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_5","090_1_5","1PE","1","5","5","የ ላታይ ዎደ ዉርስꬃ ቆንጮዳይስ የዝ አቶትꬅስ ጾስ ዎልቃር አማኖር ይንትስ ናግንቲ የዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_6","090_1_6","1PE","1","6","6","Ꮊት ጽቃ ዎደስ ይ ዱማ ዱማ ፓጨር ኡንእንትኮካ የይድ ኡፋይቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("P11_7","090_1_7","1PE","1","7","7","የ ፓጫይ ይንታን ሄሌዛይ፥ ታማ ኦልን ꬋብዛ ዎርቀፕ ይ አማናይ ኣꬎኔ ቱማ ማቄዛና ቤዝዛ። የ ፓጭንቴዝ አማናይድ የሱስ ክርስቶሳ ማቂ የኦዳር ጋላታ፥ ቦንቾኔ ሳባ ይ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("P11_8","090_1_8","1PE","1","8","8","ይ የሱሳ በኤካያ፥ ዝን ኤዛ ሲቅዛ። ይ Ꮊት ኤዛ በኤካ ባዝ ማቅኮካ፥ ኤዛ አማንዛ። ማ ኦዳር ቆንጭሶዳይስ ዳንዳእንቶዋ ኡፋይሳራኔ ቦንቾር ኩሜዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_9","090_1_9","1PE","1","9","9","ይ አማኖር ናግዛ ይ ሸምፖ አቶትꬃ ኤኮዳ። ");
INSERT INTO mfxe_vpl VALUES ("P11_10","090_1_10","1PE","1","10","10","ኣꬎ ኬሄትꬃይ ባጋር ይንትስ ማቄዝ Ꮊ አቶትꬃይ ባጋ ናብታይ ኤሮዳይስ ሎእꬂ ፕላጊ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_11","090_1_11","1PE","1","11","11","ኡ ጋንጨ የዝ ክርስቶሳ አያናይ ኤዛ ሄሎድ ዋያኔ የይፕ ጉየ የኦድ ቦንቾ ባጋ ቲናቲ ማርካትታር፥ አይደ ዎይ ዋይዚ ሀኖዳዛኮ አካካር ፕላጊ ኮዬዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_12","090_1_12","1PE","1","12","12","ናብታይ ኦዴዝ ትንቢታይ ፓስ ባዝን ይንትስ ማቄዛና ጾሲ ኡንትስ ቆንጭሴዛ። Ꮊት አሳይ ይንትስ ኦዴዝ ዎንግለ ሳሎፕ ኪትንቴዝ ጌሻ አያና ዎልቃር ይንትስ ኦዴዛ። ኪታንችታይካ የያ በአዳይስ አሞትዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_13","090_1_13","1PE","1","13","13","የይ ግሾስ፥ ይ ዎዝና ባርክꬂ ኦሶስ ጊግንቲ፤ ይንታን ሞዲ የሱስ ክርስቶሳ ማቂ የኦዳር ይ ኤኮድ ኣꬎ ኬሃትꬃ ኡፋይሳር ናጎይታ። ");
INSERT INTO mfxe_vpl VALUES ("P11_14","090_1_14","1PE","1","14","14","ኪትንትዛ ናእታ ኣዚ ኤረካዛር ቲና ይ የዜዝ ኢታ አሞ ካልፓተ። ");
INSERT INTO mfxe_vpl VALUES ("P11_15","090_1_15","1PE","1","15","15","ዝን ይንታን ጼጌዝ ጾሳይ ጌሺ ማቄዛይ ጋርክ ይንትካ ይ የሳ ኡባይድ ጌሽታ ማቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("P11_16","090_1_16","1PE","1","16","16","ጌሻ ማጻፋይድ፥ «ታኒ ጌሽ ማቄዝ ግሾስ ይንትካ ጌሽታ ማቆይታ» ግንትንቲ ጻፍንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_17","090_1_17","1PE","1","17","17","አስ ስኖ በኤካዛር ፐታይስ ፐታይስ ኤ ኦሳይ ጋርክ ፕርድዛ ጾሳ፥ «አደ» ግ ጼግዝ ባዝ ማቅኮ፥ Ꮊ ሳአ እማꬃትꬅ የሳ ያሻር የዞይታ። ");
INSERT INTO mfxe_vpl VALUES ("P11_18","090_1_18","1PE","1","18","18","ይ፥ ይ አድታይፕ ላቴዝ ፓꬆዋ የሳይፕ ዎዝንቴዛይ፥ ꬋብዛ ብራር ዎይ ዎርቃር ባዛና ይ ኤርዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_19","090_1_19","1PE","1","19","19","ቦሮ ዎይ ቦርሶ ባ ዱር ማቄዝ አልኦ ክርስቶሳ ሱꬃር ይ ዎዝንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_20","090_1_20","1PE","1","20","20","ኤ አላመ መꬊንቶዳይፕ ቲና ኤርንቴዛ፥ ዝን Ꮊ ዉርስꬅ ዎደ ይ ግሾስ ቆንጬዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_21","090_1_21","1PE","1","21","21","ይ አማናይኔ ይ ኡፋይሳይ ጾሳል ማቆዳይ ጋርክ ጾሲ ኤዛ Ꮊይቆፕ ደንꬂ፥ ቦንቼዝ ክርስቶሳ ባጋር ጾሳል አማንንቶዳ። ");
INSERT INTO mfxe_vpl VALUES ("P11_22","090_1_22","1PE","1","22","22","ይ ቱማስ አዛዝንትታር ኡትራባይꬅ እሸትꬅ ሲቆር ሚንꬂ ዎልር ዎዝናፕ ሲቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("P11_23","090_1_23","1PE","1","23","23","ይ ናምአንꬆ የልንቴዛይ ꬋብዛ ዘርꬃፕ ባዝን መꬍናስ የዝ ጾስ ቃላይድ ꬋቦዋ ሼሻፕ የልንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_24","090_1_24","1PE","1","24","24","ጾስ ቃላይ፥ «አሾ ማኤዝ ኡባይ ማታ ጋርከ፤ ኤ ቦንቻይ ኡባይካ ማታ ፉ ጋርከ። ማታይ መልዛ፥ ፉꬍታይካ ጉፍዛ። ");
INSERT INTO mfxe_vpl VALUES ("P11_25","090_1_25","1PE","1","25","25","ዝን ጎዳይ ቃላይ መꬍናስ ሚንጊ የዞዳ» ዬግዛ። ይንትስ ኦድንቴዝ ዎንግለ ቃላይ Ꮊያ። ");
INSERT INTO mfxe_vpl VALUES ("P12_1","090_2_1","1PE","2","1","1","ይኬ ኢታትꬅ ኡባ፥ ዶሻ ኡባ፥ ጩቦትꬅ ቅናተኔ ዝግርስ ኡባ ይንትፕ ሃሶይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_2","090_2_2","1PE","2","2","3","ጎዳይ ኬሃ ማቄዛና ይ ኤሬዛይ ጋርክ Ꮊት የልንቴዝ ጽቃ ናእታይ ጋርክ ይ አቶትꬃር ድጮዳይስ ገነ ባ ቃላ ማስ ኡባ ዎደ አሞቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_4","090_2_4","1PE","2","4","4","አሳር ቦርንቲ ጾሳር ዶርንቴዝ ቦንቾ ማቄዝ ሹች፥ ጎዳ የሱሳኮ ሺቆይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_5","090_2_5","1PE","2","5","5","ይ ደኦ ሹችታ ማቂ፥ የሱስ ክርስቶሳ ባጋር ጾስ ኡፋይስዛ አያና ያርሾ ያርሽዛ ጌሽ ቄስታ ማቆዳይ ጋርክ አያና ኬꬅ ማቂ ኬጽንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_6","090_2_6","1PE","2","6","6","ጌሻ ማጻፋይድ፥ «ዬዛኮ፥ ታኒ ጽዮነ ካታማ ኬꬃ ሙመር ቶኪ አይክዝ ክርክሮ ጋርክ፥ ዶርንቴዝ፥ ቦንቾ ሹች ጋዶዳ፤ ኤዛ አማንዛ ኦንካ የሻ ዬላታሚ» ዬግዛ። ");
INSERT INTO mfxe_vpl VALUES ("P12_7","090_2_7","1PE","2","7","7","Ꮊ ሹቻይ ይንትስ አማንዝታይስ ቦንቾ፥ ዝን አማኖዋዝታይስ፥ «ግምቢዝታይ ለቂ እጼዝ ሹቻይ ኬꬃ ሙመር ቶኪ አይክዝ ክርክሮ ጋርክ፥ ኡባይፕ ኣꬊዝ ሹች ማቄዛ።» ");
INSERT INTO mfxe_vpl VALUES ("P12_8","090_2_8","1PE","2","8","8","ማካ፥ «Ꮊ ሹቻይ አስ ꬉቢዛ ሹችኔ አስ ፖክስዝ ዛላ» ዬግዛ። ኡንቲ የይስ ቃድንቴዝ ግሾስ ጾስ ቃላ ኪትንታም እጺ ꬉብንቴዛ። ");
INSERT INTO mfxe_vpl VALUES ("P12_9","090_2_9","1PE","2","9","9","ዝን ጾሲ ꬉማፕ ማላልስዛ ፋ ፖአይኮ ይንታን ጼጌዛይ፥ ይ ኤ ሎኦትꬃ ሀርታይስ ኦዶዳይስ ዶርንቴዝ ኮች፥ ካት ቄሰ፥ ጌሻ የለትꬅኔ ጾስ ዱማ ዎያ። ");
INSERT INTO mfxe_vpl VALUES ("P12_10","090_2_10","1PE","2","10","10","ይ ቲና ጾስ ዎያ ባያ፥ ዝን Ꮊት ይ ኤ ዎያ። ይ ቲና ማሮትꬅ ደንገካዝታ፥ ዝን Ꮊት ማሮትꬅ ደንጌዛ። ");
INSERT INTO mfxe_vpl VALUES ("P12_11","090_2_11","1PE","2","11","11","ታ እሹንꬆ፥ ይ Ꮊ ሳአ እማꬅኔ በተ አስ ማቄዛይ ጋርክ ይ ሸምፖ ኦልዛ አሾ አሞፕ ሃኮድ ጋርክ ታኒ ይንታን ዎስዛ። ");
INSERT INTO mfxe_vpl VALUES ("P12_12","090_2_12","1PE","2","12","12","አማኖዋ አሳይ ይንታን ኢታ ኦꬅዝ አስ ጋርክ ዝግርኮ ጾሲ ኑና በአዳይስ ይእዛ ጋላስ፥ ኡንቲ ይ ሎኦ ኦሳ ብኢ ጾስ ጋላቶዳይ ጋርክ ይንትስ ሎኦ ደኦ የዞ። ");
INSERT INTO mfxe_vpl VALUES ("P12_13","090_2_13","1PE","2","13","13","ጎዳይ ግሾስ ግ ማዉተር የዝ አሳይስ ሃርንቶይታ፤ ኡባይፕ አፋ ማቄዝ ግሾስ ካታይስካ ሞድንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_14","090_2_14","1PE","2","14","14","ኡንቲ ኢታ ኦꬅዝታ ሴሮዳይስኔ ሎኦ ኦꬅዝታ ሳቦዳይስ ካታይፕ ኪትንቴዝ ግሾስ ጋደ አቅዝታይስ ሃርንቶይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_15","090_2_15","1PE","2","15","15","ይ፥ ይ ሎኦ ኦሶር ኤሮዋ ቦዞ አሳይ ናሻ ዶና አይꬆዳይ ጾስ ሸነ። ");
INSERT INTO mfxe_vpl VALUES ("P12_16","090_2_16","1PE","2","16","16","ጾስ አይለ ማቂ ዋሎ የዞይታፕ አትን ይ ዋሎትꬃ ኢታ ኦሶስ ካመ ኡድፓተ። ");
INSERT INTO mfxe_vpl VALUES ("P12_17","090_2_17","1PE","2","17","17","አስ ኡባ ቦንቾይታ፤ አማንዛ አሳ ሲቆይታ፤ ጾስስ ያሽቶይታ፤ ካት ቦንቾይታ። ");
INSERT INTO mfxe_vpl VALUES ("P12_1