﻿USE sofia;
DROP TABLE IF EXISTS sofia.nmx_vpl;
CREATE TABLE nmx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nmx_vpl WRITE;
INSERT INTO nmx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Fútar Tiafilus: Tárfár árém mwighé yaitotaménd ménát faroghét némé té kufrotawét téfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yémofem yafrotaménd kétamé némé si té yinjoyénd ufroghan a emofem yéfarotaménd. ");
INSERT INTO nmx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yéndon té merkéráye téfandawan méinyotio yam kétándmé ufrogh, mer kéretau tayot faroghét ménát merkéráye ndenéfifi némé té kufrotau. Yéndon yafrotan feyot minde merfifi Tiafilus, ");
INSERT INTO nmx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yéndon yéné yafrotan ménát fém so mat ném efalo si méinyotio árkéméné fém té káyáretau. ");
INSERT INTO nmx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yéné efghon Erod njam témorwén Judiamén warsagh ár, kété témorwén ghéngén wárogh ár yétkwén Jakaraya efe tafnyangérwén ghéngén wárogh ár Abiane mérén, yáne amaf Elisabet Aron ákimén. ");
INSERT INTO nmx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jakaraya a Elisabet Ngánjánene ghékfan mer ghérsaye tamorarwén, méinyotio Yurane nák tawaitoghét. ");
INSERT INTO nmx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wénde ambumofnar tarwén, ménamén Elisabetéf mwinu tárwén, a fá bulu náyáteyayénd. ");
INSERT INTO nmx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ámb efghon Jakarayane mérénta ghéngén ásáfogh efogh nawerai, yémon ghéngén wárogh ásáfogh yérnyai Ngánján sáfrére. ");
INSERT INTO nmx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yéfene túmén témndan Ngánjánam taferngai ménát mer wimafé rokar wároghét Ngánján wáwefnogh méngo kénjút. ");
INSERT INTO nmx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Njam efogh náwerai mer wimafé rokar wároghét, méinyotio ár náumendaménd wáwefnogh méngo sifayan Ngánjánafé oraighét. ");
INSERT INTO nmx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Féyo Ngánjánene njafar si résagh ár nufaryéng yáfaf, nokayoyéng ghéngén wárogh séki tambénta. ");
INSERT INTO nmx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Njam Jakarayam yinjoyéng, fá sélngwél yémormén a férféram yifoyéng. ");
INSERT INTO nmx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wénde njafar si résagh árom yémndayéng, “Yau férfér ném, Jakaraya, fene Ngánjánafé orayégh si té náyárang. Fene amaf Elisabet so nésle ghakér ambum, fémon táf yétkwén taram Jon. ");
INSERT INTO nmx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Fá so yém áuwégh a remngogh feyot, a tárfár so náuwetat ménamén yáne éslaghmén. ");
INSERT INTO nmx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Fá ndimbal so yém Ngánjánene ghékfan, wéri nénefnar a ámb táikér nu, a fá so yém Ngánján Mbérmbér wafoghkaf kétándmayo éslagh. ");
INSERT INTO nmx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tárfár ár Israilmén yémon so ewangote kétán Yuré yéfenjo Ngánjánefaf. ");
INSERT INTO nmx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A fá so yéngém Yurane frondeta, mbérmbéran a waftayan ndenanit Elaija kés témorwén, ménát afafene tikéf wangoghét kétán yéfenjo ambumafefaf, a ayáréghofnaye ghérsata wangoghét kétán káfeté; efalo ghérsat táfrendau Yurai.” ");
INSERT INTO nmx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakarayam yémotai njafar si résagh ár, “Ndernáye wét yénd mat so kamndan yénémamén? Yénd swém bulu wém a tane amaf siyém ndenéyameyo ausé.” ");
INSERT INTO nmx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Njafar si résagh árom yawangoi, “Yénd wém Geibrél. Yénd Ngánjáne kaka wakai a yénd kwénmáfárete siafé sái kémaufron yéné mer si. ");
INSERT INTO nmx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A sénonjo fém kékmbo métar a yau noraya kétánotio yéné ufroghene efogh kawerangé ménamén fémo efalo yau tane si so táyáto. Árkéméné so efalo kénamndangi yánjo efghon.” ");
INSERT INTO nmx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Yéné tekan árém Jakaraya njam tanjetawét a mwighé uwérsoghan tamorwén ménamén tekfifi télawangérwén wáwefnogh méngo kénjún. ");
INSERT INTO nmx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Njam fá nétoryéng, fá yau korayau yéfefaf. Yémofem yáyámngoyénd ménamén yémon ghékéf waingégh Ngánján yinjoi wáwefnogh méngo kénjún, fá siofnar namndai yéfeyot ngángayero tawaweindau. ");
INSERT INTO nmx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Njam yáne wáwefnogh efogh nefoyénd, fá néngangoi méngot. ");
INSERT INTO nmx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Soramé yáne amaf Elisabet namndai suafé a 5 ghérare méngo kénjúnro témorangérwén yau kétonau. ");
INSERT INTO nmx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet norayai, “Yuram yéné tafrote tayot, yéné efghon Ngánjánam yauyafoi yáne ménde a yitérmboi tane wáiwáiafé yam árfe tambén.” ");
INSERT INTO nmx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Táf Elisabetene 6 ghérareyan, Ngánjánam yáfáretam njafar si résagh ár Geibrél Najaret Galili yuwot, ");
INSERT INTO nmx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","yéné méinyo mérésoefaf efe yéreindaménd awerghét Josefefaf, Deifidene mérén kénjút, yáne yétkwén témorwén Meri. ");
INSERT INTO nmx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Njafar si résagh ár yéngmormén Meri yémndai, “Mer frengégh siafé! Yuré siyém fefaf yém.” ");
INSERT INTO nmx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri ndimbal sélngwél yémorméng yáne sian a mwighé uwérsoghét yéméindai ndernáye yéné áuwéghfifi so yém. ");
INSERT INTO nmx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wénde njafar si résagh árom yémndai, “Yau férfér ném, Meri, fémon Ngánjánene ménde té yinjo. ");
INSERT INTO nmx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fém so ném ambumafé a fém so nésle ghakér ambum, a yétkwén táf taram Yesu. ");
INSERT INTO nmx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Fá so yém ndimbal a so yémndetat Minde tukén Ambum. Yuré Ngánjánam so tiyátongé warsagh ár ndenáye fété yáne áki Deifid kés témorwén. ");
INSERT INTO nmx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A fá so yém Israil limánégh ár tuotot. Yáne méngotu yau so yiyato!” ");
INSERT INTO nmx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Merim yémotai njafar si résagh ár, “Ndernáye so yéné yém, ménamén yénd swém méinyo mérés?” ");
INSERT INTO nmx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Njafar si résagh árom yawangoi, “Efalo, Ngánján Mbérmbér fefaf so yéném, a Minde Tukén waftayam fém so kémafarngé. Yéné téfnan njúnnjúnofnar ambum so yémndetat Ngánjánene Ambum. ");
INSERT INTO nmx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elisabet fene mérénmén ambumafé so yém ausayan a efe témndetawét ndené mwiné téfnár yém, sénonjo suafé yém 6 ghérare kénjún. ");
INSERT INTO nmx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yénémamén Ngánjáneyot yau táikér yém.” ");
INSERT INTO nmx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Merim yawangoi, “Yénd wém Yurane faiofnar ásáfogh ár. Féyotaro so nufrote némé té wémndé.” Si soramé njafar si résagh árom yéfrangoi. ");
INSERT INTO nmx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Yéné efghon Meri wékeye álighét náfrendam tesenot Judia tunakéf yuwot. ");
INSERT INTO nmx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Fá nélawai Jakarayane méngot a frengégh si yaramai Elisabete. ");
INSERT INTO nmx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Njam Elisabet náyárai Meriene frengégh si, ambum táf nalinai fút kénjún, a táf Elisabet témorwén Ngánján Mbérmbér wafoghkaf. ");
INSERT INTO nmx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Fá tuk kéme norayai, “Frengéghkaf ném méinyotio amaf kénjún, a frengéghafé ambum fémon so yéráfteǃ ");
INSERT INTO nmx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Némamén yénd méndefé wém, tane Yurane amé sái yéném tafaf? ");
INSERT INTO nmx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Njam fene frengégh si náyárai, táf ambum tane fút kénjún notanai áuwéghafé. ");
INSERT INTO nmx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nderé áuwéghafé yém yáyot si némé té norayai Ngánjánene efalo si sái nufrota yáfaf.” ");
INSERT INTO nmx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri norayai, “Tane tikfam Yuré yuwete ");
INSERT INTO nmx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","a tane mbérmbér áuwéghan yém Ngánján tane Wanjarégh ár kénjún, ");
INSERT INTO nmx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ménamén yémon yénd wafarotam yuwan ghérsafé yáne ásáfogh mérés! Yénandmé sénonjo méinyotio árém so wémndetat yénd ndené frengéghmén ném, ");
INSERT INTO nmx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ménamén Minde tukén waftafé sélngwélafé yam tayot yafrotam. Yáne yétkwén yém njúnnjúnofnar. ");
INSERT INTO nmx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yáne ghérghérsisé so néngusamngote yéfeyot emofem férférafé yéfandat fá kétándmé ámb ár saté kétánotio ámb ár saté. ");
INSERT INTO nmx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yémon té yuyafotam muyé yánjo ngángaye, yémon té ewafarnai fá efe tuktuk mwighé emarghan tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yémon té eweworyéng yuwot limánégh ár yéfenjo limánégh ámnjogh sifayata, wénde euyoyéng tukét métar ár. ");
INSERT INTO nmx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yémon té eremngoi siogh ár tárfár rokare wénde engwatembayéng wemár ár sotro. ");
INSERT INTO nmx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yémon té yáutánam yánjo faiofnar ásáfogh ár Israil yafarotai ghérghérsisaye. ");
INSERT INTO nmx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ebraamefaf a yánjo mérénfaf tuot, ndernáye té nénorayayéng téfene afafefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Merif emorarmén Elisabetfé nambio ghérare soramé Meri néngangoi méngotuot. ");
INSERT INTO nmx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetene efogh njam nawerai yáne ambummén, fá náráftam ghakér. ");
INSERT INTO nmx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yáne kaka ár a fútaréf náyárayénd ndené Yuram ndimbal ghérghérsisé yuyafoi a fá káuwétawét yémafé. ");
INSERT INTO nmx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","8 efogh nawerayéng fá engmormén ghéngan néfghét a yémofem yétkwén yéramayénd yárefé Jakaraya soramé, ");
INSERT INTO nmx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","wénde yátmé norayai, “Yau! Yáne yétkwén so yém Jon.” ");
INSERT INTO nmx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yémofem yémndayénd, “Ámb yéné yétkwén yau yém féfene mérnan.” ");
INSERT INTO nmx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yémofem ngángaye yéngwaghnyayénd yárefai ménát ambumoe yétkwén ramghét. ");
INSERT INTO nmx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Fá namotayéng farogh fefat ngángé awaunyéghe, méinyotio ár sélngwél emorméng yémon yéfarotam, “Yáne yétkwén siyém Jon.” ");
INSERT INTO nmx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Táf fété Jakaraya si néngufngoi a tuwetau Ngánján. ");
INSERT INTO nmx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ár fútar Ngánján férféram ewifoi, Judia yu árém taruindawét yéné yammén. ");
INSERT INTO nmx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Méinyotio ár efe náyárayénd mwighé uwérsoghan tamorwén, a namotayénd, “Efe yéné ambum so yém?” Ménamén Yurane ngángé kété témorwén. ");
INSERT INTO nmx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yárefé Jakaraya Ngánján Mbérmbéram yafoi si nufngoi, ");
INSERT INTO nmx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Áuwégh yém Yurai, Israilmén Ngánján! Fá té téném yánjo ár wanjarghét. ");
INSERT INTO nmx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Fá yénmáfáretam téfe wanjarégh ár yáne faiofnar ásáfogh ár Deifid yáne mérénmén. ");
INSERT INTO nmx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Némé fá norayai yáne Ngánjánene mat yátogh ár kénjúmé tándái, ");
INSERT INTO nmx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Wanjarégh yém kétándmé téfene mék téfnárafene ngángata emofem méndméndat yénfandat yénd. ");
INSERT INTO nmx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ghérghérsisé yuyafoi téfene afafefaf a ewafarotai yánjo njúnnjúnofnar árnyégh. ");
INSERT INTO nmx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wengéghofnar si norayai téfene afé Ebraamefaf. ");
INSERT INTO nmx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Yénd yénmutoryéng kétándmé mék téfnárfene ngángata a yénméindai yénd yáyot férférofnar yam wafarerghét: ");
INSERT INTO nmx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","njúnnjúnofnar a mbarkánd kér ro Ngánjáne sáfan méinyotio téfene efghon. ");
INSERT INTO nmx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Fém, tane ambum, so ném Minde Tuk Ngánjánene mat yátogh ár, so ném Yurane sáfréré end frengéghét yáyot, ");
INSERT INTO nmx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","yánjo árét so ewaramete wanjarégh mat yéfene yaufi wányányégh kénjúmé. ");
INSERT INTO nmx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ménamén téfene Ngánjánene ghérghérsisé njafar tambén árnyégh efogh so yéném téfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","So télálángé fá efe kwéfkwéfan em a kér mbanmbanan efe em so engwambete téfene kafkaf krufrát endmé.” ");
INSERT INTO nmx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ambum nanotam a muyafé namndai mbérmbéran, a fá tékmangérwén fanfne yuwon kétánotio marataye nufaryéng Israilét. ");
INSERT INTO nmx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yéné efghon Kaisar Augustusam muyé si yéramai marataye yétkwén kayoghét Rom yuwon. ");
INSERT INTO nmx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yéné simormén frondefifi yam yétkwén kayoghét njam Kwirinius gafana témorwén Sirian. ");
INSERT INTO nmx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Méinyotio ár nuwanoyénd yéfenjo tesenot yétkwén yáuwéghét. ");
INSERT INTO nmx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Féyo, ménamén Josef siyém Deifidene ákimén, fá néngwanoi Najaret tesenta Galili yuwot kétán Betliem Judia kénjút, yéné tesen siyém ánde Deifid nanotam. ");
INSERT INTO nmx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Fá nuwaneyayénd Merifé yétkwén kayoghét, efe té yémndayénd awerghét Josefefaf a táf áráféghétro témorwén ambum. ");
INSERT INTO nmx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Njamandio tarwén kété, efogh nawerai ambum áráfghét, ");
INSERT INTO nmx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","a fá fronde sénko ambum náráftam. Sálámeye yéfiyaryéng ambum yéflayéng wérárafene njamke téruan ménamén kété yau sifayé témorwén yéfeyot méngon. ");
INSERT INTO nmx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A sif wanjengégh ár tékmangérwén kaka sifayan ghékéf tawafayotawét sifafet sémbáran. ");
INSERT INTO nmx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yurane njafar si résagh ár sélngwéle nufaryéng yéfefaf a Yurane ndimbal kwayaghayam etremngoi, a fá férfér tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wénde njafar si résagh árom emndai fá, “Férfér yau em. Yéndon enwarsan mer si féfeyot ndimbal áuwégh méinyotio árét. ");
INSERT INTO nmx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sénonjo Deifidene tesen kénjún Wanjarégh ár té káráfte féfeyot, fá yém Yuré Keriso. ");
INSERT INTO nmx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yéné siyém féfeyot wayamngoghét: fémofem so tinjongi ambum sáláme fiyaréghkaf wérárafene njamke téruan.” ");
INSERT INTO nmx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Sélngwélafé minde tárfár njafar si résagh ár nufaryénd yéné njafar si résagh árfé, tuwetawét Ngánján a korayawét, ");
INSERT INTO nmx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Áuwégh yém Ngánjáneyot minde tukén, yéné mbandan krufrát yém yéfeyot yáne méndefé árét.” ");
INSERT INTO nmx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Njam njafar si résagh árém efrangoyénd a nuwanoyénd njafarot, sif wanjengégh ár fáro norayayénd, “Kuwanongém Betliemét fandaghét némé yam nufrote kété, árkémamén Yuram té yénmaufroi.” ");
INSERT INTO nmx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sif wanjengégh ár nuwanoyénd wékeye ewinjoyénd Meri, Josef, a tosé efe tékmangérwén wérárafene téruan. ");
INSERT INTO nmx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yémofem njam yinjoyénd fá, si yétarnayénd némé njafar si résagh árom té ewaufroyéng yéné ambumoenemén. ");
INSERT INTO nmx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Efe méinyotio náyárayénd sélngwél emormén némé sif wanjengégh árém ewafroyénd yéfeyot. ");
INSERT INTO nmx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meriene tikfan si tamorwén a mé kawafarotau. ");
INSERT INTO nmx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sif wanjengégh ár nangoyénd áuwéghafé tuwetawét Ngánján ménamén némé náyárayénd a ghékfe yinjoyénd, árkémamén té yéfe ewaufroyénd. ");
INSERT INTO nmx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ménayan 8 efghon, efogh nawerayéng yáne ghéngan néfghét, yáne yétkwén Yesu, njafar si résagh árom fronde yétkwén yaramai soramé su nawanai. ");
INSERT INTO nmx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Njam efogh nawerai wányányégh téménd wafroghét ndernáye Mosesene nák témorwén, Josef a Meri ambum yérséménd Jerusalemét Yurafaf wateghét ");
INSERT INTO nmx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yurane nák ndernáye té yéfarotam, “Méinyotio fronde sénko ghakér ambum wateghét Yurafaf.” ");
INSERT INTO nmx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A fá nuwanoyénd ghéngén ramghét ménamén Yurane nák ndernáye noraye ménát sómbio mamuot o sómbio duf tosat. ");
INSERT INTO nmx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ár témorwén Jerusalem kénjún yétkwén Simion, efe témorwén mbarkándro a Ngánján férférafé ár. Fá kawanjetau ménát Israil wanjarghét, a témorwén Ngánján Mbérmbér wafoghkaf. ");
INSERT INTO nmx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ngánján Mbérmbéram mwighé yaramai, “Fém yau so kér ném fronde Yurane Keriso so tinjo.” ");
INSERT INTO nmx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ngánján Mbérmbéram yimndai Simion kétán wáwefnogh méngo kénjút. Njam yárefafem ambum Yesu yérséménd kétán túmén yam wafroghfaf ánde témorwén nákan, ");
INSERT INTO nmx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simioném ambum yambnai ngángaye a áuwégh yawangoyéng Ngánjáne táf norayai, ");
INSERT INTO nmx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Wanjarégh ár Yuré, fémon némé té wémndai, sénonjo yénd fene faiofnar ásáfogh ár kér so wém áuwéghafé. ");
INSERT INTO nmx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ménamén tane ghékfam fene wanjarégh té yinjo, ");
INSERT INTO nmx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ménát méinyotio árém so yéfandat árkéméné fémon té néusénam. ");
INSERT INTO nmx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Fá so yém ndenanit kwayaghé sái yuyafotam fene efalofifi Téndo árét, a yémon so eméinde ár sái nemnat tukén Israil árfenemén.” ");
INSERT INTO nmx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ambumoe yárefé a yátmé sélngwél ermén némé Simion té norayai yánemén. ");
INSERT INTO nmx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioném efrendai fá a yémndai Meri, yátmé, “Yéné ambumom so eméinde ámb Israil ár sái nékmbotat Ngánján efalo yiyátoghét, a tárfár ár so kawengongi Ngánjánefaf a fá so yém waufarogh ménát mat yátoghét árét wénde tárfár árém so yékenat fá. ");
INSERT INTO nmx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ménát tárfár árfene tikéfta yaufi mwighé so nufanat. Yaufi wafroghyam yémofem so ewafrotat yáfaf árkéménayam so tawaramangé ndimbal ghérghérsisé.” ");
INSERT INTO nmx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kété témorwén Ngánjánene mat yátogh amaf, Anna, Fanuelene mérés, Aserene mérénmén. Fá témorwén auséfifi, a fá enmorarmén yánjarfé sefen yunjfro. ");
INSERT INTO nmx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A kwiré náyátoi kétánotio 84 yunjéf namndayéng. Yémon yau yéfrangoi wáwefnogh méngo wénde táwefnotau sémbár a efghon Ngánjánafé koraiwét a kawafarmetau. ");
INSERT INTO nmx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yéné efogh féneféneyan yénmormén yéfefaf, yémon kánjo yaramai Ngánjáne a ewaufroi ambumoenemén efe kawanjetawét Jerusalem wanjarghét. ");
INSERT INTO nmx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Njam Yurane nák némé wafroghét tamorwén Merifém Josefé té ewifeyayénd, fá táf nangeyayénd Galili yuwot yéfenjo tesenot Najaret. ");
INSERT INTO nmx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ambum nanotam muyafé namndai, fá káfeté mwighé wafoghkaf témorwén, Ngánjánene ngárám yáfaf témorwén. ");
INSERT INTO nmx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Méinyotio yunjfan yárefaf tayowéng Jerusalemét Waingégh téméndfaf. ");
INSERT INTO nmx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Njam fá 12 yunjéf namndai, fá nuwanoyénd kétán, túmén yam wafarogh téméndfaf. ");
INSERT INTO nmx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Téménd soramé njam yárefaf kénangowét méngotuot, ghakér ambum Yesu nawangsoi Jerusalemén, wénde mat yau tarwén ambumoenemén. ");
INSERT INTO nmx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Fá kéma kemarwét ndené mérne kar álighan kénangotawét, ámbiro efogh eyoméng. Yémofem ronjagh yafngeyayénd yéfenjo mérén kénjún a fútarfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Njam yau fá yinjeyayénd, fá nangeyayénd Jerusalemét yá ronjaghét. ");
INSERT INTO nmx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nambio efogh soramé yémofem yinjeyayénd wáwefnogh méngon, témorangérwén watamegh téfnárafé, káyáretau yéfefaf a ámogh si tawarametau. ");
INSERT INTO nmx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Méinyotio emofem tiyáretawét fá emormén sélngwél yáne uwangoghan mwighé kwayaghé térsawét. ");
INSERT INTO nmx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Njam yárefafem yinjeyayénd fá, sélngwél ermén, a yatmam yémndai, “Ambum, ndené fémo némamén yénmafrowé? Yénd afafé ténre ndémkefé fe ronjaghan.” ");
INSERT INTO nmx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesum ewawangeyai, “Némémén yénd fémofem wéronjét? Fém mat fiya tarwén ndené yénd tane Afane méngo kénjún wém.” ");
INSERT INTO nmx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wénde fá mé katambarwét némé si yémon té tamndéwéng. ");
INSERT INTO nmx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Fá nuwanoyénd Najaretét yárefafé a fá áyárégh ár náyátoi yárefafefaf. Wénde yatmam méinyotio si ewanai yánjo tikéf kénjút. ");
INSERT INTO nmx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu nanotam fifiyan a káfeté mwighayan a yáne ménde Ngánjánafé a ár. ");
INSERT INTO nmx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Njam tuk warsagh ár Kaisar Tiberiusém télimndau Rom 15 yunjéf, táf Fontius Failet témorwén Judiamén gafana, Erod témorwén limánégh ár Galili yuwon, Erode yánngén Filif témorwén limánégh ár Itulia a Trakonitisan a Lisanias témorwén limánégh ár Abileneyan, ");
INSERT INTO nmx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","a táf Anas a Kayafas ghéngén wárogh sénko ár tarwén, Buk si yénmormén Jonefaf Jakarayane ambumoefaf fanfne yuwon. ");
INSERT INTO nmx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yémon yarendam méinyotio Joden yu, si táitotau walitoghmén a tawalitotau yaufita awengoghét. ");
INSERT INTO nmx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ndernáye yéfarotaménd Buk sian Ngánjánene mat yátogh ár Aisayane si, “Ámb ár ke nutne fanfne yuwon, 'End frengéghét Yuraye álighét, wafrogh mbarkánd end yáyot. ");
INSERT INTO nmx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Méinyotio yékwyékw wéfángéghét a méinyotio mband tunakéf fénarghét a fafatot. Méinyotio ménjuté end so em mbarkánd a yaufi end so em frengéghkaf. ");
INSERT INTO nmx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A méinyotio árém so tinjongi Ngánjánene wanjarégh.'” ");
INSERT INTO nmx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon norayai ár mérénfaf árké tanmorwén nuwot walitoghét yáfaf, “Fém kamban ghérsafé ár mérén! Emon fém emndai Ngánjánene nékwta sái kenngongi? ");
INSERT INTO nmx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yénayam so ewafrotati árkéménayam féfe so tayaufrongi ndené té nawengongi yaufita. A yau yaufi si kufngongi féfenjo kénjún ndené, 'Ebraam siyém téfene áki.' Yéndo emndetan fém ndené yéné wím tambén Ngánjánam so tautorngé ambum Ebraameyot. ");
INSERT INTO nmx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbilé siyém frengéghkaf yém wén sérémb néfghét, a árké wénam yau njam mer mbwe yéfuna yéné wén siyém néfghét a fését wighét.” ");
INSERT INTO nmx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ár mérnam yémotayénd, “Némé yéndfem so yafrotam yénandmé?” ");
INSERT INTO nmx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Joném ewawangoi, “Ár efe sómbio sodafé njam yém ámb ároe so taramangé, a efe njamkefé yém ndenéyameyo so yafrote.” ");
INSERT INTO nmx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mani kafégh ár ndenéyameyo enmormén nu walitoghét, fá namotayénd, “Watamegh ár, némé so yafrotam?” ");
INSERT INTO nmx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yémon emndai fá, “Yau féfenjo méndeye takafangi kétamé némé té engémndan.” ");
INSERT INTO nmx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ámb fiyaram wéi yémotayéng, “Yéndfem némé so yafrotam?” Yémo ewawangoi, “Yau ewarémnati maniot ár o ekafetati unyéghe a eremngotati féfenjo fayam.” ");
INSERT INTO nmx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ár kawanjetawét oyárghafé a méinyotio tikfan kéwérsotawét nde Jon némé Keriso namndé. ");
INSERT INTO nmx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joném ewawangoi méinyotioat, “Yéndon ewalitotan fém nue. Wénde efe tane soramé yéném tane muyé so taindangé, endene sandol ángégh fénaghét yénd féyotarofnar wém. Yémon so ewalitote fém Ngánján Mbérmbére a fése. ");
INSERT INTO nmx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Fá siyém frengéghkaf yém njénro faloghét kétándmé fifiyafé mbwe yánjo foke. Kétándmé yémon so yésámbune saf, so euménde fifiyafé mbwe yánjo méngo kénjún, wénde so tawarongé njénro kémboghofnar fése.” ");
INSERT INTO nmx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","A ámb tárfár sie Joném tawawéngsotau ár a mer si tawawaitotau yéfeyot. ");
INSERT INTO nmx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wénde njam Joném yarnam Erod limánégh ár ménamén yémon nawerai yánngnoene amaf, Erodias a ámb yaufiyam ewafrotam, ");
INSERT INTO nmx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erodém yasamngoi yénandmé yéfefaf. Jon yélawayénd kwéfkwéf méngon. ");
INSERT INTO nmx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Njam méinyotio ár ewalitotam, Yesu wéi yálitotam. Njam fá Ngánjánafé oraighan témorwén njafar táf nasawéryéng, ");
INSERT INTO nmx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","a Ngánján Mbérmbér néneworyéng Yesuefaf men kénjúmé ndenanit mamu. Si yénmormén kétándmé njafarta, “Fém ném tane uwéghafé ambum, yénd minde náuwétan fefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu namndai 30 yunjéf táf yánjo ásáfogh yérnyai. Yesu maratan nakmai ndené Josefene ambum yém Josef témorwén Eliene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matatene ambum, Lefiene ambum, Melkiene ambum, Yanaiene ambum, Josefene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatiasene ambum, Amosene ambum, Nakumene ambum, Esliene ambum, Nagaiene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Matene ambum, Matatiasene ambum, Semeinene ambum, Josekene ambum, Jodene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joananene ambum, Resane ambum, Jerufafelene ambum, Sialtielene ambum, Neriene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melkiene ambum, Adiene ambum, Kosamene ambum, Elmadamene ambum, Erene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josuane ambum, Elieserene ambum, Jorimene ambum Matatene ambum, Lefiene ambum. ");
INSERT INTO nmx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simionene ambum, Judane ambum, Josefene ambum, Jonamene ambum, Eliakimene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meliane ambum, Menane ambum, Matatane ambum, Natanene ambum, Deifidene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesiene ambum, Obedene ambum, Boasene ambum, Samonene ambum, Nasunene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadafene ambum, Ramene ambum, Ejronene ambum, Feresene ambum, Judane ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jeikofene ambum, Aisekene ambum, Ebraamene ambum, Terane ambum, Naorene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serukene ambum, Reuene ambum, Felekene ambum, Eferene ambum, Selane ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Keinanene ambum, Afasadene ambum, Semene ambum, Noane ambum, Lamekene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metuselane ambum, Inokene ambum, Jaredene ambum, Maalalelene ambum, Kenanene ambum, ");
INSERT INTO nmx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosene ambum, Setene ambum, Edémene ambum, Ngánjánene ambum. ");
INSERT INTO nmx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu, Ngánján Mbérmbér afoghkaf, kangotau Jodenta a Ngánján Mbérmbéram yalimai fanfne yuwomé, ");
INSERT INTO nmx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","40 efghon fá yufotam Sáifram. Yémon yau enetam yéné efghon, yéné soramé siogh témorwén. ");
INSERT INTO nmx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sáifram yémndai, “Fém njam ném Ngánjánene ambum, yéné wím tengo njamkeyot.” ");
INSERT INTO nmx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesum yawangoi, “Buk sian yékai, 'Ár njamkeyero yau so yémor.'” ");
INSERT INTO nmx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sáifram yalimai mband tunakfot a yauyafotam yáyot méinyotio mband marat. ");
INSERT INTO nmx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sáifram yémndai, “Yéndon so kémaraman méinyotio muyé a meryam, ménamén tane em, so tawaraman méndefé árfet ende téu. ");
INSERT INTO nmx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Fémon njam kwáwefno ta, méinyotio fene so em.” ");
INSERT INTO nmx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesum yawangoi, “Buk sian yékai, 'Yáwefnota fene Yuré Ngánjánoe a yausáfota yandro.'” ");
INSERT INTO nmx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sáifram yalimai Jerusalemét a nokayoi minde tukén wáwefnogh méngon. Yémon yémndai, “Fém njam ném Ngánjánene ambum, fém yénamé kátna yuwot.” ");
INSERT INTO nmx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Buk sian yékai ndené, “Yémon so enwáfárete njafar si résagh ár fe wambghét, ");
INSERT INTO nmx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","yémofem so kémerangi yéfenjo ngángaye, ménát fene kafkaf yau so kawambangi wíman.” ");
INSERT INTO nmx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesum yawangoi, “Ndené noraye, fémo yau yékmeta fenjo Yuré Ngánján ufoghan.” ");
INSERT INTO nmx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Njam Sáifram yánjo ufogh yam ewifoi Yesu táf yéfrangoi ámb efghot. ");
INSERT INTO nmx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu nénangoi Galili yuwot Ngánján Mbérmbérene waftafé, si marat náyátoi yánemén méinyotio yuwomé. ");
INSERT INTO nmx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yémon tawatametau yéfenjo áumengégh méngomé, a méinyotio árém tuwetawét fá. ");
INSERT INTO nmx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Fá nuwanoi Najaretét, ánde fá nanotam, Safatan nuwanoi nélawai áumengégh méngot yáne túmén yam témorwén. Fá nokayoi wafghét. ");
INSERT INTO nmx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ngánjánene mat yátogh ár Aisayane kanéghkaf buk témorwén yaramayénd. Yémon yéferyéng a yinjoyéng si tékayongérwén, ");
INSERT INTO nmx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yurane Mbérmbér siyém tafaf yém, ménamén yénd yémon wékafai mer si waitoghét yauyau árét. Yémon yénd kwamáfárete siot yéfeyot efe kwéfkwéf méngon elau wanjarghét, kwéfkwéf ár so kretangé, kérté téfnár so em ofé, ");
INSERT INTO nmx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","yéné yunjfan Ngánjánene ménde nufrotam.” ");
INSERT INTO nmx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Féyo yémon yéknam kénaghkaf buk, ewawangoi áumengégh méngo wanjengégh árét a námnjoyéng si waitogh sifayan. Méinyotio árfene ghékfam téfandawét fá áumengégh méngo kénjún. ");
INSERT INTO nmx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Fá si orayégh nufngoi yéfefaf, “Sénonjo yéné si efalo náyáto féfene áyárégh kénjún.” ");
INSERT INTO nmx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Méinyotio korayawét yánemén frengégh si a sélngwélafé mer simén emormén yáne mbírmbírta njam nétoryéng. Yémofem namotayénd, “Yéné Josefene ambum yém?” ");
INSERT INTO nmx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesum emndai fá, “Fémofem so tanangi yéné káfeté si tafaf, 'Jokté, fémyo káfrenda!' A Fémofem so kwémndangi, 'Tafrota yéna fenjo tesenan némé yénd náyárangém ndené fémo némé tafrote Kafenamén.'” ");
INSERT INTO nmx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yémon yasamngoi, “Efalo ewaufrotan, méinyotio Ngánjánene mat yátogh ár yau eumyoi yánjo méngotuot. ");
INSERT INTO nmx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yéndon fém mat eyátotan ndené kété tárfár kwiré tamorwén Israilén Elaijane efghon, njam nu yau kafamndau nambio yunjéf a mbarmbar yafrotai ámb yunjéf. Kété táf káukáu nuyai yuwon. ");
INSERT INTO nmx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Wénde Elaija yau yáfáretaménd ámb Jumén ároefaf, wénde kwirafaftro Jarefatét Sidon kénjún. ");
INSERT INTO nmx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kété tamorwén tárfár Israilén yaufi ghéngan enjnefé Elisane efghon, efe ámb yau mer témorwén Naamanro Siriamén.” ");
INSERT INTO nmx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Méinyotio ár áumengégh méngo kénjún nékw tamorwén yéné sian njam yiyárayénd ");
INSERT INTO nmx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Fá nékwafé nafghetaménd yifnayénd tesenta, yerayénd mband tunakéffaf ánde méngotu témorwén, kétándmé sái titawét yékwét. ");
INSERT INTO nmx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wénde fá tiotau ár mérén kénjúmé a kété néngwanoi. ");
INSERT INTO nmx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Féyo fá nuwanoi kétán Káfenam tesen Galili yu kénjún a Safatan ár watamegh ewafngoi. ");
INSERT INTO nmx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Fá tamorwén sélngwél yáne watameghan, ménamén yáne si waitogh témorwén muyafé. ");
INSERT INTO nmx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Áumengégh méngon kété témorwén ár tasérmbotau yaufi mbérmbéram. Fá nutnayéng minde tukén. ");
INSERT INTO nmx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Fém némat ménde ném téfefaf, Yesu Najaretmén? Fém téfe wasérmboghét kéném? Yénd mat wém fém efe ném. Fém ném Ngánjánene njúnnjúnofnar ár.” ");
INSERT INTO nmx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesum yarnam, “Métar mé! Kéntor yá tambén.” Féyo yaufi mbérmbéram ár yétarmai árfe ghékfan a néngtoryéng yéfrangoi ár wasérmboghofnar. ");
INSERT INTO nmx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ár méinyotio sélngwél emormén a korayawét fáro, “Némé watamegh yéné yém? Muyafé a waftafé yémon yaufi mbérmbér ewitrote a fá néngtonat!” ");
INSERT INTO nmx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A si yánemén marat namndai kaka méngotuamé ");
INSERT INTO nmx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesum yéfrangoi áumengégh méngo a nuwanoi kétán Saimonene méngot. Saimone yánat témorwén minde waftafé enjne, a yémofem Yesu yamnendayénd yá wáutárghét. ");
INSERT INTO nmx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Fá náwefnoi yáfaf a enjne yémndai, “Kitér!” a yéfrangoi minde waftafé enjneyam. Fá nurtotam táf fété a yémon njamke ewaneyam yéfeyot. ");
INSERT INTO nmx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Njam efogh ngironau, árém tánémnjawét Yesuefaf méinyotio efe tamorwén fénaté enjnefé, a ngángé tafayongai yéfefaf, mer káyátotawét. ");
INSERT INTO nmx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yaufi mbérmbér kétonawét tárfár ár tambén, kutnawét, “Fém ném Ngánjánene ambum!” Wénde Yesum ekmboi fá siofnar, ménamén fá mat tamorwén ndené Keriso yém. ");
INSERT INTO nmx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Faurghan Yesu nuwanoi fanfne yuwot. Árém téronjawét Yesu a njam fá enmormén kétán ánde Yesu témormén, yémofem yékmboyénd fá ménát yau so tafrangongai fá. ");
INSERT INTO nmx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Wénde yémon emndai, “Yéndon so yaitotan mer si Ngánjánene limánéghmén ámb tesenan, ménamén yénat yénd wémáfáretam.” ");
INSERT INTO nmx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Mé fá témorwén si waitogh áumengégh méngon Judian. ");
INSERT INTO nmx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ámb efghon Yesu témorwén Genesaret sau téndon tákáyongérwén, ár mérénafé tamorwén yarendayénd a Buk sifaf káyáretawét. ");
INSERT INTO nmx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yémon ewinjeyai sómbio bout nu téndon, efrangeyayénd kété susi árém, efe tarwén yéfenjo net umbarghan. ");
INSERT INTO nmx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Fá nuflai ámb boutan, árké témorwén Saimonene, yémndayéng bout witroghét kor némbnare. Féyo fá námnjoi a ár watamegh ewafngoi bout kénjúta. ");
INSERT INTO nmx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Njam yémon si ewifoi, Saimonefaf norayai, “Sumbét tangérsa net a tanwam wagifot.” ");
INSERT INTO nmx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimoném yawangoi, “Watamegh ár, sémbár tombé téfé násáfotam a némé ámb yau ernyangém. Wénde ménamén fém té kés noraya, yénd so wéngém net tanwaman.” ");
INSERT INTO nmx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Njam yémofem yafrotaménd némat té engémndai, yémofem ereindaménd tárfár wagif a yéfene net aftéraréghétro tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yénémamén yémofem engwaunyeyayénd yéfe fútarfet ámb boutot wáutárghét, fá enmormén a sómbio boutan tawaflitawét minde tárfár wagif a olitoghétro tárwén. ");
INSERT INTO nmx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Njam Saimon Fitam yinjoi yéné, yémon yáwefnoi Yesue budme a norayai, “Nguwano ta tambén, Yuré, yénd wém yaufiyamafé ár!” ");
INSERT INTO nmx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Fá a méinyotio yáne wáutárégh ár yéné wagif arnyéghmén sélngwél emormén, ");
INSERT INTO nmx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ndenéyameyo wéi Jems a Jon, Jebediene ambum a Saimonene fútaréf. Yesu norayai Saimonefaf, “Yau férfér ném. Sénonjo yénandmé fém so ném ár tárfár rényégh ár.” ");
INSERT INTO nmx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yémofem yéfenjo bout tunat engwimndangeyayénd a méinyotio rokar eureyayénd yéngwaitoyénd fá. ");
INSERT INTO nmx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Njamandio Yesu témorwén ámb tesenan, ámb ár yaufi ghéngan enjnefé témorwén. Yémo njam Yesu yinjoi, fá yáne sáfe nuyai mbandot a yamnendai, “Yuré, fém njam ménde ném, fémon mer kwiyáto yénd.” ");
INSERT INTO nmx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesum ngángé ewatembai a yiyánjai ár a norayai, “Yénd ménde fété wém. So mer ném!” A táf fété yaufi ghéngan enjneyam yéfrangoi. ");
INSERT INTO nmx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesum yémndai fá, “Ende yau taufro, téu nguwano, kauyafo fémyo ghéngén wárogh téfnárafefaf a ghéngén taram némé Mosesene nákan noraye frengéghmén ánde árém so kémwinjongi ndené fene ghéngan mer té namndé.” ");
INSERT INTO nmx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wénde si yánemén marat náyátoi. Ár tárfár tanmorwén áyárghét yáfaf a tárfár frengégham tarsau enjne téfnár. ");
INSERT INTO nmx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Wénde Yesu túmén kitérmbongai métar sifayat Ngánjánafé oraighét. ");
INSERT INTO nmx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ámb efghon njamandio Yesum tawatametau, Farasi ár a nák watamegh ár, efe té enmormén fénaté méngotuta Galili yumén, Judiamén a Jerusalemén tamorangérwén. Yurane wafté kété témorwén ménát enjne téfnár frengéghét. ");
INSERT INTO nmx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ámb árém térsawét aknyégh ár yame sutafé yéta résaghét téngrametawét kétán méngot Yesuene sáfrére kémghét. ");
INSERT INTO nmx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wénde yémofem yau ámb end yinjoyénd ménamén ár tárfármén, yénémamén tarmbotawét méngo sémsot tukét, a kend enendayénd némbne fénemé ángéghe tewénawét ár néndkfot Yesuene sáfrére. ");
INSERT INTO nmx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Njam Yesum ewawinjoi yéfene ndimbal mwighé, fá norayai, “Fútar, fene yaufi té wawalinda.” ");
INSERT INTO nmx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Farasi ár a nák watamegh ár mwighé tawaitotawét yéfenjomén, “Efe yéné ár yém wanyogh si kés noraye? Efe yaufi so tawalindangé wénde Ngánjánamro?” ");
INSERT INTO nmx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu mat té náyátoi fá némé kemnawét a emotai, “Fém némamén nemnati féfene tikfan? ");
INSERT INTO nmx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Árkéméné áfrátaye yém sái korayangén, 'Fene yaufi sem wawalingéghkaf em,' o sái korayangén, 'Kokai a kuano'? ");
INSERT INTO nmx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wénde fém mat so em ndené Ároene Ambum muyafé yém yéné mbandan ménát yaufi wawalingéghét.” Fá norayai akényégh ároefaf, “Yéndon némndetan fém, kokai, tané fenjo yame a kuano méngot.” ");
INSERT INTO nmx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Táfandio fá fété nénokayoi yéfe sáfrére, yékafai némayan té tékmangérwén a néngwanoi méngot Ngánján ténguwetau. ");
INSERT INTO nmx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Méinyotio ár sélngwél emormén a Ngánjánoe áuwégh tawangotawét. Fá Ngánján férféram ewafoi a norayayénd. “Yéndfem téfé efandam sélngwélafé yam sénonjo!” ");
INSERT INTO nmx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yéné soramé, Yesu néngwanoi a yinjoi mani kafégh ár yétkwén Lefi témorangérwén mani kafégh sifayan. Yesum yémndai fá, “Kwénmaito yénd.” ");
INSERT INTO nmx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A Lefi nokayoi, efrangoi méinyotio rokar a yáitoi fá. ");
INSERT INTO nmx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kétándmé Lefim ndimbal téménd néusénam Yesueyot yánjo méngon, a ndimbal mérén mani kafégh ár a ámb kés em njamke tánetawét yémafé. ");
INSERT INTO nmx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wénde Farasi ár a nák watamegh ár káwatarnawét yáne waitogh árfefaf, “Némamén fémofem enetati njamke a nu mani kafégh árfé a yaufiyam wafrogh árfé?” ");
INSERT INTO nmx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesum ewawangoi, “Yau mer árém njokté yarawetat wénde enjne téfnáramro. ");
INSERT INTO nmx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yénd yau mbarkánd ár moghét wénmormén, wénde yaufiyam ár wengoghét.” ");
INSERT INTO nmx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yémofem norayayénd yáfaf, “Jonene waitogh ár túmén awafarmanéghan a Ngánjánafé oraighan em a wéi ndenéyameyo Farasi árfene waitogh ár, wénde fene sem njamke a nu néneyanro em.” ");
INSERT INTO nmx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesum ewawangoi, “Féyotaro fémofem so taméindangi awerégh ároene wan téfnár awafarmanéghét njamandio yémafé em? ");
INSERT INTO nmx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wénde efogh yéna yéném njam awerégh ár so nguwanongé yéfe tambén, yéné efghon fá so nawafarmetat.” ");
INSERT INTO nmx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesum tawaufrotau yéné rengerenge si, “Emo yau so tétirarngé totér sálámeta mbékwbékwot tékayongé namghét tándáwár sálámeyan. Njam yémon yafrota, yémo so tétirarngé totér sáláme, a yau so katmangé tándáwár sálámeyan. ");
INSERT INTO nmx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A emon yau so yararoté totér wéri nu tándáwár wéri nu ndimbayan. Njam yémon yafrota, totér wéri nu so tétembarngé a taghnangé wéri nu ndimbé, wéri nu so nasune a wéri nu ndimbé so taghnangé. ");
INSERT INTO nmx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yau, totér wéri nu fété so yararote totér wéri nu ndimbat. ");
INSERT INTO nmx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A yau efe ámb tándáwár wéri nu néne soramé wéi ménde so yéngém totrot, ménamén fá ndené noraye, 'Tándáwár siyém merfifi.'” ");
INSERT INTO nmx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ámb Safatan Yesu tiotau mbwe ndawan, a yánjo waitogh árém ámb wén mbwe kafégh ewafngoyénd, yéfenjo ngángaye tasénawét mbwe a tánetawét. ");
INSERT INTO nmx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ámb Farasi árém yémotayénd, “Némamén fémo nák eráfne Safatan?” ");
INSERT INTO nmx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesum ewawangoi yéfeyot, “Fémofem yau yaftaménd némé Deifidém tafrotau njam fá a yánjo mérnafé siogh tamorwén? ");
INSERT INTO nmx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Fá nélawai Ngánjánene méngot, a yékafai frengéghkaf féskaf flawé, yémon enetam árké nák témorwén yéfe ghéngén wárogh árfetro nénet. A yémon wéi ewaramai ámb yánjo mérnat.” ");
INSERT INTO nmx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu norayai yéfefaf, “Ároene Ambum siyém Safatoe Yuré.” ");
INSERT INTO nmx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ámb Safatan fá nénguwanoi áumengégh méngo kénjút a watamegh ewafngoi, a ár kété témorwén endene tambén ngángé akényégh áre tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farasi ár a nák watamegh árém téfén tronjawét Yesue éwighét, féyo yémofem ghékéf tafayotawét ménát yémon ámb frengégh ásáfogh kar so tawafrotau Safatan. ");
INSERT INTO nmx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Wénde Yesu mat náyátoi yéfene mwighé némé kemnawét a norayai ngángé aknyégh ároefaf, “Kunjé a kokai méinyotio ár safan.” Féyo fá nunjai a nokayoi kété. ");
INSERT INTO nmx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Féyo Yesu norayai yéfefaf, “Yéndo emotan fém, árkéméné yém nák Safatan: mer wafroghét o yaufi wafroghét, ghérsé wanjarghét o wirorghét?” ");
INSERT INTO nmx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yémon ghékfe fá tafandau méinyotio, a norayai ároefef, “Fenjo ngángé tásáfo.” Akényégh árom yafrotam ndené, a yáne ngángé táf mer namndai. ");
INSERT INTO nmx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wénde fá tamorwén nékwafé a warunyégh yafngoyénd yéfene kénjúnro némé so tafrotawét Yesuefaf. ");
INSERT INTO nmx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ámb efghon Yesu néngwanoi mband tunakéf téndot Ngánjánafé oraighét, a korayau Ngánjánefaf sémbár tombé faurghétio. ");
INSERT INTO nmx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Njam akw efawéryéng, yémon emotai yánjo waitogh ár ewaferyéng 12ro, emo yéfe yétkwén ewaramai yánjo muyafé árét, ");
INSERT INTO nmx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon ende yétkwén yaramai Fité, yánngén Endru, Jems, Jon, Filif, Batolome, ");
INSERT INTO nmx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metyu, Tomas, Jems Alfesene ambum, Saimon efe ménde témorwén ndené Ju ár so kawanjetawét fáyo yau Rom waftayan, ");
INSERT INTO nmx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jemsene ambum, Judas Iskariot efe namndai sén téfnár. ");
INSERT INTO nmx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Fá Yesufé néneworyénd tunakéfta a nokayoyénd fafat sifayan. Tárfár Yesuene waitogh ár kété tamorwén a tárfár wéi enmormén Judiamén, ndenáyo Jerusalem, Taire a Sidon arakaf téndomén, ");
INSERT INTO nmx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","efe té enmormén si áyárghét yáfaf a yéfene enjneta mer yátoghét. Efe yaufi mbérmbéram tawasérmbotau mer náyátoyénd, ");
INSERT INTO nmx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","a méinyotio árém yéta yanjaghét trametawét fá, ménamén wafté ngétonau Yesueta a mer ngáyátotawét. ");
INSERT INTO nmx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yémon tafandau yánjo waitogh ár a norayai, “Frengégh yém féfeyot efe em yauyau, ménamén féfeyot siyém Ngánjánene limánégh. ");
INSERT INTO nmx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Frengégh yém féfeyot efe em siogh sénonjo, ménamén fém so em remngoghkaf. Frengégh yém féfeyot efe ye nendat sénonjo, ménamén fém so em fénan. ");
INSERT INTO nmx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Frengégh yém féfeyot njam árém méndméndat efandat, njam árém ekarotat fém a ewasalitat, a ekenat fém emndetat yaufi mbérmbér em, ménamén Ároene Ambummén. ");
INSERT INTO nmx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Áuwégh yém yéné efghon a ermángégh áuwéghafé, ménamén fene fai siyém ndimbal njafaran. Ndenéyameyo yéfene ákifem takarotawét Ngánjánene mat yátogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Wénde tékrát yém féfeyot efe em wemár, ménamén fém té tamorwén áfrát ghérsaye. ");
INSERT INTO nmx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tékrat yém féfeyot efe remngoghkaf sénonjo em, ménamén fém siogh so engém. Tékrat yém féfeyot efe em fénan sénonjo, ménamén fém so em ghérghérsisayan a yeyan. ");
INSERT INTO nmx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nderé mámáfi so yém féfeyot njam méinyotio árém norayat mer si féfenemén ndenáye yéfene ákifem tamndetawét unyégh mat yátogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Wénde yéndon emndetan fém emofem wiyáretat yénd: Féfene mék téfnár euwetati, mer ewawafrotati yéfeyot emofem méndméndat efandat fém. ");
INSERT INTO nmx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Efrendati fá emofem ewafángotat fém, Ngánjánafé orayégh yéfeyot emofem ekenat féfe. ");
INSERT INTO nmx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Njam ámb árém fétkaman kénésmangé, kawengo wéi witmé yáfaf. Njam ámb árém kémawanangé fene sénjté sodé, yau táf tékmbo téngéumyo a ámb sodé téngwaram. ");
INSERT INTO nmx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ewarameta méinyotio árét emofem némamnendat fém, emo njam kémawanangé fene némé yém, yau táf tango. ");
INSERT INTO nmx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ámb árét ewafrotati fene méndefé némé em árfeyot wénde so némawafrotat. ");
INSERT INTO nmx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Njam fémofem euwetati fá emofem fém némuwetat, némamén fémofem frengégh so tanangi? Ndenéyameyo yaufiyam árém euwetat emofem fá euwetat. ");
INSERT INTO nmx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A njam fémofem ewawafrotati mer yéfeyotro efe mer em féfefaf, némamén fémofem frengégh so tanangi? Ndené yam yaufiyam árém yéné ewafrotat. ");
INSERT INTO nmx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A njam fém méghmégh em yéfefaf kétamé emofem fai so kémawangongi, némamén fémofem frengégh so tanangi? Ndenéyameyo yaufiyam árém méghméghafé so némanjetat fai wangoghét. ");
INSERT INTO nmx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wénde euwetati féfene mék téfnár, mer ewawafrotati yéfeyot, yau nawanjetati fai wangoghétro. Féyo féfene fai so yém ndimbal, a fém so em Minde tuk Ngánjánene Ambum, ménamén fá siyém mer yéfefaf kánjo si emofem yau yawangotat a em yaufian. ");
INSERT INTO nmx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aem ghérghérsisafé, ndené fété Féferafé ghérghérsisafé kés yém. ");
INSERT INTO nmx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Árfene yaufi yau ewaftati ménamén Ngánjánam féfene yaufi yau so ewafte. Ár yau ewafalngotati emndetati ndené yaufiyamafé em ménamén yau wéi fém so ewafalngotat. Tawawalindangé yéfene yaufimén, a féfene so wéi fá tawawalindangé. ");
INSERT INTO nmx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ramégh ámb árét ménát Ngánjánam féfe wéi so tawaramangé. Fémofem njam yéné yam yafrotati so ewinjotati tárfár, so ewaramete kétán féfene ngángé afoghare so ewam a nasunat. Nderé tárfár fémofem njam ewarametati, ndenéyameyo féfe so ewaramete.” ");
INSERT INTO nmx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesum tawaufrotau yéné rengerenge si, “Féyotaro kwéfkwéf árém so yémnje kwéfkwéf ár? Wét yau so kélawend yékwét? ");
INSERT INTO nmx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Waitogh árém yau so taindangi yéfene watamegh ár, wénde efe njam ewatametat méinyotio yam, fá so em ndenáyo yéfene watamegh ár. ");
INSERT INTO nmx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Némamén fémo yéfande fe fútarene ghékéf fémégh a yau nofande wén ténj féfenjo ghékfan? ");
INSERT INTO nmx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndernáye fémo so fe fútar témnde, 'Fútar, kwumyo yénd fene ghékéf fémégh utorghét,' táf yéfande wén ténj fenjo ghékfan? Fém unyégh ár, fronde tutor wén ténj fenjo ghékfan, fém táf so kéreta kwayaghayan fe fútarene ghékéf fémégh utorghét. ");
INSERT INTO nmx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mer wénam yau efune yaufi mbwe, yaufi wénam yau efune mer mbwe. ");
INSERT INTO nmx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Méinyotio wén so tawayamngo yéfenjo mbweyan. Árém yau so ekafetat wiwi kétándmé féfta o ás kétándmé mbita. ");
INSERT INTO nmx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mer árom efune meryam mer tikéfta, a wéi ndenéyameyo yaufi árom yaufiyam efune yaufi tikéfta. Tikfan némé afoghare yém yéné noraye. ");
INSERT INTO nmx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Némamén wét yénd wémndetati 'Yuré, Yuré,' a yau ewafrotati ndenáye yéndon némé norayan? ");
INSERT INTO nmx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yéndon so safén tékman fá nderé safot nérete efe tafaf yéném tane si áyárghét a wafroghan yékmete. ");
INSERT INTO nmx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Fá siyém ndenanit méngo ramégh ár, emo kénjkam yétanam a wíman méngo yeitam. Njam kéfér nénengoi, méngo yéta yutaryéng, wénde yau yésámbnetai, ménamén sotafé raméghmén tétnongérwén. ");
INSERT INTO nmx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wénde emon njam tane si náyáreta a yau ekmete wafroghyaman, ndenanit yéné ár yém emo méngo yeitam faru mbandan. Njam kéfram yutaryéng yéné méngo, yiroryéng ambino.” ");
INSERT INTO nmx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesum njam si ewifoi árét, fá nuwanoi Káfenamét. ");
INSERT INTO nmx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rom fiyaré sénko ároene faiofnar ásáfogh ár, efe tutémndawét ndimbal kéráye, yéné ár enjne témorwén a kaka témorwén krotro. ");
INSERT INTO nmx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Rom fiyaré sénko ár náyárai Yesuenemén, yémo ewáfáretam Ju ndimbal ár yamnendai Yesu álighét enjne téfnárfaf frengéghét. ");
INSERT INTO nmx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Njam fá nénuwanoyénd Yesuefaf, féyo yamnendayénd, “Yéné árom nénémnde álighét fém yá frengéghét,” ");
INSERT INTO nmx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ménamén yémon yuwetam téfene ndimbal yu a áumengégh méngo yeitam téfeyot. ");
INSERT INTO nmx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Féyo Yesuf nuwanoyénd yémafé. Fá nayuofnar néngaflayénd méngota táf Rom fiyaré sénko árom njam ewáfáretam yá fútaréf yáfaf siot, “Yuré, mwighayan yau nuita fém. Yéndon yau so fém kénémndan tane méngo álighét ménamén yénd wém yaufiyam ár. ");
INSERT INTO nmx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yéné téfnan yénd yau mer kafandan sái kwénmorwén fefaf. Wénde mé siro koraya táf tane faiofnar ásáfogh ár mer so káyátongé. ");
INSERT INTO nmx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yénd yéndio wém muyayan, fiyaré em tane mbanmbanan. Yéndon némat tafaretangén yénat, 'Kuwano,' so kuwanongé. Yénat njam tafaretangén 'kénaf,' a fá so yéném a njam tafaretangén tane faiofnar ásáfogh ár, 'Yéné tafrota,' a yémon so yafrote.” ");
INSERT INTO nmx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Njam Yesum náyárai sélngwélafé si yá tambén, a fá nawengoi kétán ár mérénfaf táitotawét, “Yéndo emndetan fém, yéndon yau yinjon ndené ndimbal mwighé Israil yuwon.” ");
INSERT INTO nmx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Táf ár nénangoyénd méngot a yinjoyénd faiofnar ásáfogh ár merro. ");
INSERT INTO nmx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ámb efghon Yesuf nuwanoyénd yánjo waitogh árfé a ár mérnafé kétán tesen yétkwén Nain. ");
INSERT INTO nmx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Fá njam kaka ufarghétro témorwén tesen sésafnefaf, yémofem yinjoyénd kwirane féfét ambum kér fu ténérsawét, a tesenmén ár mérnafé tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yuram njam amaf yinjoi, fá ghérghérsisayam yifoi amafoefaf a yémndai, “Yau nenda.” ");
INSERT INTO nmx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kaka nitroi taté yiyánjai, fá emofem ténérsawét nokayoyénd. Fá norayai, “Tot ambum, yéndon némndetan, kano!” ");
INSERT INTO nmx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kér ambum nanoyéng námnjoi a si nufngoi. Yesum yéngramai yatmafaf. ");
INSERT INTO nmx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Fá sélngwél emormén a soramé áuwégh nufngoyénd a norayayénd, “Ndimbal Ngánjánene mat yátogh ár té nufar téfefaf. Ngánján té nufar yánjo ár wáutárghét.” ");
INSERT INTO nmx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yéné si marat náyátoi Yesuenemén Judia yuwon a ámb yu kaka kés tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonene waitogh árém yaufroyénd yá yéné yammén. Joném sómbio emotangeyai, ");
INSERT INTO nmx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","yémon sómbio ár ewafareméng Yurafaf moghét, “Fém yénéf ném efe kéném, o so néngawanjetam ámb ároe?” ");
INSERT INTO nmx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sómbio ár njam enérmén Yesuefaf, fá korayangénd, “Jon walitogh árém tanmafarwe fefaf moghét. 'Fém yénéf ném efe kéném o so néngawanjetam ámb ároe?'” ");
INSERT INTO nmx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ámb mer efghon Yesum tárfár ár efe fénataye enjnefé tanmorwén a yaufi mbérmbérafé mer táyátotau, a éregh ár náyátoyénd efe ghékéf kwéfkwéf tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Féyo yémo ewawangeyai si résagh árfet, “Ngangend a taufrend Jone némé fémofem tafandet a fénáyáret. Kwéfkwéf ár éregh ár káyátotawét, yaufi kafkaf téfnár áligh ár náyátoyénd, yaufi ghéngan téfnár mer náyátoyénd, téngan méngu áyárégh ár náyátoyénd, kér téfnár kanotawét, a yauyau árét mer si tawawaitotawét. ");
INSERT INTO nmx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Frengégh ár yénéf em efe yau nékmbotat efalo yátoghét tafaf.” ");
INSERT INTO nmx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yéné soramé Jonene si résagh ár nuwaneyayénd, Yesum si yérnyai árfefaf Jonenemén, “Fém némé fandaghét néngtor fanfne yuwot? Yéné tombé yus mbormboram kés efnje? ");
INSERT INTO nmx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yau njam, némé fandaghét fém néngtor? Ár takayongérwén mer sáláme umaneghkaf? Yau, efe tawongérwén mer sáláme a efe tamorwén sotafé mer rokarafé warsagh ár sifayan fá tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wénde némé fandaghét fém néngtor? Ngánjánene mat yátogh ár? O, yéndon némndetan, fá ewainde méinyotio ámb Ngánjánene mat yátogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yéné fiyém endenemén yéfarotaménd: 'Yéndon so yéngwáfáretan fronde si résagh ár, emon so fene end yéfrende.'” ");
INSERT INTO nmx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kor norayai, “Yéndon emndetan, Jon walitogh árom ewainde méinyotio ár efe náráftat yéné mband maratan. Wénde efe yém némbnar ambumnit Ngánjánene limánéghan, yémo so taindangé Jon.” ");
INSERT INTO nmx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesuene si njam náyárayénd, méinyotio ár, kété tawafnyangérwén mani kafégh ár, mat namndayénd ndené Ngánjánene yam siyém efalo, ménamén Joném té tawawaitotau. ");
INSERT INTO nmx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wénde Farasi ár a nák watamegh árém yékenayénd Ngánjánene ménde yéfendio, ménamén fá nakenayénd Joném sái tawalitotau. ");
INSERT INTO nmx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Némafaf yéndo so yétémndan yéné árfenemén? Némanit fá em? ");
INSERT INTO nmx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ndenanit em ambumtértér yénau emorang rokar térarégh sifayan a fárofáro námotat, “'Yénd nambnam sifraféré feyot, a fém yau neremndé Yénd neremndam ghérghérsisafé kérmén wagh, a fém yau nende.' ");
INSERT INTO nmx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Jon walitogh ár yénmormén, njamke a wéri nu yau tánetau, a fém norayati, 'Fá yaufi mbérmbérafé yém.' ");
INSERT INTO nmx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ároene Ambum yénmormén, njamke a nu nénet, a fém norayati, 'Yéna yém amanjarégh ár a wéri nu nénero, mani kafégh ár a yaufi árfene fútar.' ");
INSERT INTO nmx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Káfeté mwighé siyém mbarkánd yiyátotat méinyotio yáne waitogh árém.” ");
INSERT INTO nmx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ámb Farasi ároene waráuwégh yénmormén Yesueyot séite njamket, fá néngwanoi kétán Farasi ároene méngot námnjoi nénet. ");
INSERT INTO nmx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ámb amaf efe témorangérwén yaufi ghérsayan yéné tesenan mat náyátoi ndené Yesum njamke tánetau ámb Farasi ároene méngon, yéné amafom yénérsam séfkwénafé mer wimafé wékwér, ");
INSERT INTO nmx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","amaf nokayoi yá sémta Yesuene kafkafot a niyai yáfaf, yáne yengam kuitawét Yesuene kafkafot. Yémon wányányogh yawafngoi yánjo séfe, a esnetai a yawasuryéng mer wimafé wékwére. ");
INSERT INTO nmx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Njam yéné Farasi árom yinjoi yéné yam, fá norayai yánjo kénjún, “Yéné ár njam Ngánjánene mat yátogh ár yém, fá mat té yém emo fá yiyanje a nderé sáfot amaf yéné yém, fá siyém yaufiyamafé amaf.” ");
INSERT INTO nmx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesum yawangoi, “Saimon, yéndon ámb si so kémaufron.” Yémo korayangé, “Kwaufro, watamegh ár.” ");
INSERT INTO nmx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Sómbio árét mani ewarameyai maniafé árém, ámb ároe 5,000 kina, ámb ároe 500 kina. ");
INSERT INTO nmx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sómbio ár maniofnar namndeyayénd wangoghét, féyo yémo mwighafnar ewawaineyai. Emo so minde méndefé yéfande?” ");
INSERT INTO nmx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon nuwangoi, “Yénd ndené nemnan endene ndimbal fai mwighafnar yawitam.” Yesum yémndai, “Fémo mer nuwango.” ");
INSERT INTO nmx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Féyo fá nawengoi amafoe tambén a yémndai Saimon, “Té yéfande yéné amaf? Yénd njam kwéném fene méngot, fémo yau nu waram tane kafkaf umbarghét, wénde amafom yengam fétre kwaramete a tawaine yánjo séfe. ");
INSERT INTO nmx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fémo yau wésneta, wénde yéné amafamro, kétándmayo yénd nélawan, yau fá nékmbo tane kafkaf séneghan ta umyoghét. ");
INSERT INTO nmx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fémo yau yéfai oil tane sénkoyan ta umyoghét, wénde amafom mer wimafé wékwér yasuryéng tane kafkafan. ");
INSERT INTO nmx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yénémamén nde yéndon némaufrotan fe, yéné amafoene tárfár yaufi té yawalindangén, ménamén minde uwéghafé téfandau. Wénde emon njam ewawalinde némbne kuyafongé némbnar uwéghafé wéi ndenáyo.” ");
INSERT INTO nmx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Féyo Yesum yémndai amaf, “Fene yaufi té némawalindangén.” ");
INSERT INTO nmx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ámb wan téfnár si nufngoyénd yéfene kénjúnro, “Efe yéné yém emo yaufi tawainangé?” ");
INSERT INTO nmx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesum yawangoi amafoe, “Fene ndimbal mwighayam té némanjar, nguwano mere a némor.” ");
INSERT INTO nmx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yéné soramé, Yesu karendau tesenamé a méngotuamé, mer si téngwaitotau Ngánján limánéghmén. 12ro tamorwén yémafé, ");
INSERT INTO nmx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ámb amaf tamorwén efe mer eyátoi yaufi mbérmbérafé a enjnefé, Meri Makdalin ende tambén 7 yaufi mbérmbér néntoryénd. ");
INSERT INTO nmx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Erodene méngo wanjengégh ár Kusa, yáne amaf Joana, Susanaf a amaf tárfár. Yéné amafém tawáutánwét yéfenjo rokare. ");
INSERT INTO nmx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Njamandio tárfár ár káumendawét Yesuefaf fénatafénaté tesenta, yémon rengerenge si tawaitotau: ");
INSERT INTO nmx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ndau téfnár nuwanoi yánjo wén mbwe taranéghét. Njam yémon téngtarnau, ámb nuyáyénd téndomé, yéné tatumndawét kafkafe, a menam tánetawét. ");
INSERT INTO nmx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ámb nuyáyénd wímafé mbandan, njam kanotawét, kér emormén ménamén nuofnarmén. ");
INSERT INTO nmx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ámb mbwe nuyáyénd wétwét sifayan wétwétam njangénjangén eyátoyénd anoghan. ");
INSERT INTO nmx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ámb mbwe nuyáyénd mer mbandot. Kanotawét a nafoyénd kwéki 100 mindefifi tárfár ndené kés eitaménd.” Fá njam norayai yéné, yémon emndai, “Fá efe njam ténganafé em áyárghét, fá so káyárangi.” ");
INSERT INTO nmx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yáne waitogh árém yémotayénd yéné rengerenge fifi némé yém. ");
INSERT INTO nmx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yémon emndai, “Ngánjánam yuyafote féfe fronde némé yau tauyafotau Ngánján limánéghmén, wénde ámb árét yéndon norayan rengerenge sie, ménát, “'Ghékfe so yéfandat, wénde yau so tinjongi, so náyáretat, wénde yau so tayamngongi.' ");
INSERT INTO nmx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Rengerengeyoene fifi siyém: Mbwe siyém Buk si. ");
INSERT INTO nmx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Áyárégh ár efe em endmé fá em, féyo Sáifér kénwanongé yéfene tikéfta si orot, ménát yémofem yau so efalo tiyátongi a kawanjarngi. ");
INSERT INTO nmx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yéné wímafé mbandan fá em emofem si tanangi áuwéghafé njam yémofem náyáretat, wénde fá yénéf em sérémbofnar. Yéfene efalo yiyátogh siyém tekofnar, wénde ufogh efghon fá kuyangi. ");
INSERT INTO nmx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Árké mbwe nuyáyénd wétwét sifayan, fá esérmbéne efe náyáretat, wénde fá méghmégh em tárfár rokarmén ménát so em wemár yéfene ghérsayan, a yéfene ndimbal mwighé yau kénamndangi muyafé. ");
INSERT INTO nmx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wénde árké mbwe mer mbandot nuyáyénd fá esérmbéne efe em mer a efalo ár tikfan, efe náyáretat si, yarawenat wafroghyamot yékmetat a ámb mbwe nafotat. ");
INSERT INTO nmx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Árom yau lambefé korongé tétnongé sin kénjún o tékmangé yáf mbanmbanan. Wénde yémon so téfayongé kitarékitarayan. ");
INSERT INTO nmx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Warambnoghe némé yém so tinjongi, a némé ténoghe yém sáfét so kakmangi. ");
INSERT INTO nmx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kor fété ndernáye fém náyárete. Efe ár rokarafé em yéfe minde fifi so tawaramangé, wénde endefene yau ewam, a nemnat ndené tane féyotaro em so tawakawangé.” ");
INSERT INTO nmx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesue yátmé a yanngnéf enmormén yá fandaghét, wénde ménamén ár tárfár tamorwén, fá yau kaka tamorwén yáfaf. ");
INSERT INTO nmx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ámb árom yaufroi yá, “Fene amé a fenngnéf kétándmé ewakai safén, nawanjetat fe fandaghét.” ");
INSERT INTO nmx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesum ewawangoi, “Tane amé a nénngnéf fá em efe náyáretat Ngánjánene si a wafroghyaman ekmetat.” ");
INSERT INTO nmx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ámb efghon Yesum emndai yánjo waitogh ár, “Kuwanongém sawot kéférmangém witmé karéf.” Féyo fá nuflitaménd boutan nuwanoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Njamandio fá karayawét, Yesu nakmai. Ndimbal mbormboram eutfoi sawan, féyo bout táfandio olitoghétro témorwén, fá tamorwén ndimbal kértayan. ");
INSERT INTO nmx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Waitogh ár naflayénd yanoyénd fá, nutnayénd, “Yuré, Yuré, yénd yéném olitoghétro!” Fá nanoyéng ekmbeyai mbormbor a sof. Táf fété ndimbal mbormbor nékmboyéng méinyotio métar namndai. ");
INSERT INTO nmx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yémo emndai yánjo waitogh ár, “Ánde yém féfene ndimbal mwighé?” Waitogh ár férfér a sélngwél emormén, fáro yémndayénd, “Efe fá yém? Njam fá korayangé mbormbor a sofam tiyárangi fá!” ");
INSERT INTO nmx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Fá nufaryénd Gerasenes yuwot, árké yém witmé karéf kétamé Galili yu. ");
INSERT INTO nmx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesum njam kafkaf eyai, yaufi mbérmbérafé árom yéfángoi. Teke yéné ár yau sáláme tawongérwén a yau témorangérwén méngon, wénde mbéwé sifayan. ");
INSERT INTO nmx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Njam Yesu yinjoi, fá nutnai a nuyai yáne kafkafot, nutnam tukén, “Fém némé ménde ném tafaf, Yesu, Minde Tukén Ngánjánene ambum? Yéndon némamnendan, yau tékrátan kwékém!” ");
INSERT INTO nmx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ménamén Yesum yémndai yaufi mbérmbér étorghét ároe tambén. Túmén yaufi mbérmbéram tusérmbotawét a árém yumbetaménd ngángayan a kafkafan wambégh mbanmbanan témorwén, yémon etiaryéng sein a yaufi mbérmbéram yalimai fanfne yuwot. ");
INSERT INTO nmx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesum yémotai, “Fene yétkwén efe yém?” Yémo yawangoi, “Tárfár” ménamén tárfár yaufi mbérmbér té engmormén yáfaf. ");
INSERT INTO nmx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A yémofem yamnendayénd fá férghe, “Yénd yau so yéngém kétán kémboghofnar yékwét.” ");
INSERT INTO nmx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tárfár mérén kimb taménjnawét mband tunakéf téndon. Yaufi mbérmbéram yamnendayénd Yesu ménát élaughét yéfefaf féyo wafté ewaramai. ");
INSERT INTO nmx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Njam yaufi mbérmbér nétoryénd árta, fá nélawayénd kimbafefaf, a néngengoyénd ngewonawét sawot a kolitotawét. ");
INSERT INTO nmx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Njam kimb wanjengégh téfnáram yinjoyénd némé yam kufrotau, fá nétonaménd a nafroyénd yéné tesenan a witmé karéf yuta. ");
INSERT INTO nmx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A nuwanoyénd fandaghét némé kufrotau. Fá njam engmorménd kétán Yesuefaf, yémofem yinjoyénd ár ende tambén yaufi mbérmbér ewifnam témorangérwén Yesuene kafkaffaf. A umaneghkaf témorwén a mer mwighafé. Wénde fá férfér tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yémofem efe yinjoyénd ewafroyénd árét ndernáye yaufi mbérmbér wasérmboghkaf ár mer namndai. ");
INSERT INTO nmx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kétamé Gerasenes méinyotio árém Yesu yamnendayénd sái tafrangongai, ménamén fá férféram ewifoi. Féyo fá boutan nuflayénd álighét. ");
INSERT INTO nmx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yéné ár kétándmé ende tambén yaufi mbérmbér tawifnau, yémon yamnendai Yesu yémafé álighét, wénde Yesum yéngwatembai ndené siafé, ");
INSERT INTO nmx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ngangota méngotuot a tawaufro nderé ndimbal Ngánjánam kémawafrote feyot.” Féyo ár nuwanoi, a kafrotau tesenamé nderé ndimbal Yesum yawafrotam yáyot. ");
INSERT INTO nmx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu njam néngangotam, ár mérnam yumyoyénd, ménamén yémofem méghméghafé tanjetawét. ");
INSERT INTO nmx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ár yétkwén Jairus, wáwefnogh méngo ndimbal ár yénmormén a nénuyai Yesuene kafkafot, yamnendai álighét yánjo méngot ");
INSERT INTO nmx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ménamén yáne féfét mérés, 12 yunjéf krotro témorwén. Njam Yesu néndkfan néngayatoi, tárfár árém téngsotawét fá. ");
INSERT INTO nmx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A amaf kété témorwén efe férék kertau 12 yunjéf, wénde emon yau yéfrendai. ");
INSERT INTO nmx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Fá sémta yénmormén a yiyánjai Yesuene sáláme fétfétro férék táf nékmboi. ");
INSERT INTO nmx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu namotai, “Emo wiyánja?” Njam fá méinyotio nawanyotayénd, Fité norayai, “Yuré, ár mérnam némarendangi a néngsotat fém.” ");
INSERT INTO nmx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wénde Yesu norayai, “Ámb árom té wiyánja. Yénd mat náyáton wafté té néngférém ta tambén.” ");
INSERT INTO nmx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Njam amaf yénmormén fandaghofnar a mat siofnar, férférafé ténmorwén nénuyai yáne kafkafot. Méinyotio árfene sáfréré, yémon yémndai némamén yémon yiyánjai a ndernáye fá táfandio frengégham yanai. ");
INSERT INTO nmx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ndenaye Yesum yémdayéng, “Mérés, fenjo ndimbal mwighayam mer niyáto. Kuwano mer so ném.” ");
INSERT INTO nmx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Njamandio Yesu mé korayau, ámb ár yénmormén Jairusene méngota, efe témormén áumengégh méngo ndimbal ár. Yémon yémndai, “Fene mérés kér tém. Yau yawérsota watamegh ár nde nayu.” ");
INSERT INTO nmx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu njam náyárai yéné, fá yémndai Jairus, “Yau férfér ném. Efalo tiyáto a so mer káyátongé.” ");
INSERT INTO nmx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Njam fá nufaryéng Jairusene méngot, yémon yau efe yumyoi yémafé álighét fáro Fité, Jon, Jems a ambumoe yárefé a yátmé. ");
INSERT INTO nmx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Njamandio méinyotio ár kendawét a kutnawét ghérghérsisé tamorwén yáfaf. Yesum emndayai, “Yau nendati, yau kér tém wénde kémégh yékém.” ");
INSERT INTO nmx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yémofem turtawét ménamén fá mat tamorwén ndené kér tém. ");
INSERT INTO nmx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wénde yerayéng ngángayan a yémndai, “Tane ambum, kano!” ");
INSERT INTO nmx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yáne mbérmbér nénangoi, táfandio nénokayoi. Féyo Yesum emndai njamke taraménd nénet. ");
INSERT INTO nmx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yárefaf sélngwél emormén, wénde Yesum emndayéng yau nafrotati némé kufrote. ");
INSERT INTO nmx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ámb efghon Yesum eumendai yáne 12 waitogh ár mérne a ewarametam wafté a muyé ménát yaufi mbérmbér étorghét a enjneta mer yátoghét. ");
INSERT INTO nmx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A fá ewáfáretai Ngánjánene limánéghmén si waitoghét a enjne téfnár frengéghét ");
INSERT INTO nmx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yémon emndai, “Némé yau álighan tawanangi-yau wétu, yau yáf, yau njamke, yau mani, yau ámb awalogh sáláme. ");
INSERT INTO nmx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Árké méngo njam kélawangi, kétémiya emor kétánotio yéné tesen téfrangongi. ");
INSERT INTO nmx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Árém yau njam taumyongi, kafkaf ngwérméng tasénangi táf ténfrangongi yéfene tesen, awéfarogh so yém yéfeyot njam Ngánjánene nékw kufarngé ménamén yáne si yékenayénd.” ");
INSERT INTO nmx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Féyo fá náfrendaménd a tayotau méinyotio méngotuamé, Ngánjánene mer si táitotawét a ár tangéfrendawét méinyotio sifayan. ");
INSERT INTO nmx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erod limánégh ár náyárai méinyotio némé kufrotawét. A fá kéwérsotawét ménamén ámb korayawét, “Yéné siyém Jon kér tambén nénano,” ");
INSERT INTO nmx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ámb kemnawét, “Elaija nufar,” a ámb kemnawét nde ámb tándáwár Ngánjánene mat yátogh ár nénango ghérsat. ");
INSERT INTO nmx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wénde Erod norayai, “Yéndon emndayén Jonene sénko néfghét. Efe yéné yém yénd tárfár si náyáretan yánemén?” A fá ménde témorwén sái tinjongai Yesu. ");
INSERT INTO nmx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Njam Yesuene muyafé ár nénangoyénd, yémofem nafroyénd Yesuefaf némé tawafrotawét. Yémon engwasroi a fá néngwanoi enaghét tesen yétkwén Betsaidat. ");
INSERT INTO nmx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wénde tárfár ár mat náyátoyénd yénémamén a yaitoyénd fá. Yémon eumyoi a emndayeng Ngánjánene limánéghmén a efrendayéng fá efe frengégh ménde tamorwén. ");
INSERT INTO nmx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Seitefifi 12 waitogh ár enmormén Yesuefaf a yémndayénd, “Tawafarna ár mérén, fá so néngangotat kaka méngotuot a téndo yuwot ménát njamke a kémégh sifayat áronjaghét, ménamén yénd yéném yauyau sifayan.” ");
INSERT INTO nmx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yémon ewawangoi, “Fémofem némndafi tawaramangi nénet yéfeyot.” Yémofem yawangoyénd, “Téfene em 5 féskaf flawé a sómbio wagif, yénd njam ménde yéném yéné ár manjarghét, yénd so kuwanongém yéfene njamke résaghét.” ");
INSERT INTO nmx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yéné ár tamorwén 5,000nit. Wénde emndai yánjo waitogh ár, “Kámnjongi mérén tawafrotangi 50nit.” ");
INSERT INTO nmx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Féyo waitogh árém yafrotaménd, a méinyotio ár námnjotaménd. ");
INSERT INTO nmx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesum euyoi 5 féskaf flawé a sómbio wagif, a néwewoi njafar tukét, kánjo yaramai a etfotam. Féyo eramai waitogh árfefaf tawarametawét árét. ");
INSERT INTO nmx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Méinyotio árém enetaménd eremngoi, a waitogh árém ekafayénd 12 yáf afoghare njamke mbarmbar árkéméné ninamoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ámb efghon Yesum efrangoi ár mérén Ngánjánafé oraighét yambia a yánjo waitogh árfé tamorwén, yémon emotai fá, “Efe mérén korayawét yénd efe wém?” ");
INSERT INTO nmx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yémofem yawangoyénd, “Ámb korayawét Jon walitogh ár, ámb árém korayawét Elaija, wénde ámb árém korayawét ndené tándáwár ámb Ngánjánene mat yátogh ár kénangote ghérsat.” ");
INSERT INTO nmx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yémon emotai, “Wénde fém wét? Fém korayangi yénd efe wém?” Fitam yawangoi, “Ngánjánene Keriso.” ");
INSERT INTO nmx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesum táikér si tawawéngsotau yéfe ende yau taufrongi yénémamén. ");
INSERT INTO nmx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A fá norayai, “Ároene Ambumom so fété kérté yéngfande tárfár yaman a yékarotat sénko árém, limánégh ghéngén wárogh árém a nák watamegh árém, a fá so fété yésmetat a nambio efogh soramé Ngánjánam so tanongé ghérsat.” ");
INSERT INTO nmx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Féyo yémo emndayeng méinyotio: “Njam efe waitoghét kénufngo ta soramé, fá so fété kakenangé fáyo a tanangé yánjoyo wafatarégh wén méinyotio efghon a kwénmaitongé yénd. ");
INSERT INTO nmx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Efe ménde njam yém yánjo ghérsé wanjarghét so yétarne, wénde emo njam yáne ghérsé yétarna tanemén so tanjarngé. ");
INSERT INTO nmx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A nderé mer yém ároe sái tanangé méinyotio mband marat, wénde yétarna o nawasérmbota fáyo? ");
INSERT INTO nmx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Njam wáiwáiafé efe yém tanemén a tane simén, Ároene Ambum so yém wáiwái yánemén njam fá nénangota yáne ndimbal kwayaghé kénjún a Yárefane ndimbal kwayaghé kénjún a kétándmé njúnnjúnofnar njafar si résagh ár. ");
INSERT INTO nmx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yéndon efalo ewaufrotan, ámb efe ewakai yéna, yémofem so yéfandati Ngánjánene limánégh soramé so kér em.” ");
INSERT INTO nmx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","8 efogh soramé Yesum ewasroi Fité, Jon a Jems yémafé néngwanoyénd mband tunakfot Ngánjánafé koraiwét. ");
INSERT INTO nmx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Njamandio fá Ngánjánafé koraiwét, yáne sáf natambnai, a yáne sáláme náyátoi mé kwayagharo nálálai toyanit. ");
INSERT INTO nmx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sómbio ár, Moses a Elaija, ndimbal kwayaghé nufaryéng, Yesufé korayawét. ");
INSERT INTO nmx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yémofem korayawét yáne álighmén, árké témorwén Ngánjánene ménde so kufrotau sái kér témorwén Jerusalemén. ");
INSERT INTO nmx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fité a yáne mérén kémégh kér tákmangéwén, wénde njam fá nanoyénd, yémofem yinjoyénd yáne ndimbal kwayaghé a sómbio ár tawakayarwén yémafé. ");
INSERT INTO nmx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Njamandio Moses a Elaijafem téfrangowét Yesu, Fitam yémndai, “Yuré, mer nérete fémafé sái yéna yéném. So erametam nambio méngo, ámbiro feyot, ámbiro Mosese a ámbiro Elaija.” Fá mafina témorwén némamén korayau. ");
INSERT INTO nmx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Njamandio fá korayau, njafar kwamkwam nufaryéng a fá engwafaryéng, a fá férfér tamorwén njam ewafaryéng njafar kwamkwaman. ");
INSERT INTO nmx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Si kém yénmormén njafar kwamkwamta, nénorayai, “Yéné siyém tane ambum, efe yéndon yaferyén, yiyáretati fá.” ");
INSERT INTO nmx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Si njam nefoi, Yesuro yinjoyénd yambia. Endefet ámb yau ewafroyénd yéné efghon némé yémofem yinjoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ámb efghon, njam fá kénangotawét mband tunakéfta, ndimbal mérnam yéfángoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ár nutnai mérén kénjúta, “Watamegh ár, yéndon némamnendan ménát tane ambum so tinjo, ménamén tane yénaro ambum fiyém. ");
INSERT INTO nmx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yaufi mbérmbéram yarsote fá a sunsune kutnangé, yémo tétarmangé táikram yafrote a féfokam ewétote táf sénfneta. Yaufi mbérmbéram yau téfrangongé fá mé yasérmbote. ");
INSERT INTO nmx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yéndon ewamnendan fene waitogh ár ménát yaufi mbérmbér witérmboghét, wénde fá féyotarofnar em.” ");
INSERT INTO nmx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesum ewawangoi, “Fém ndimbal mwighafnar a áyáréghofnar ár, nderé teke fémafé so yénmor a ewamarotan fém? Ténémnjo fene ambum yénan.” ");
INSERT INTO nmx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Njamandio ambum ténmorwén, yaufi mbérmbéram yitam mbandot kosénau. Wénde Yesum yaufi mbérmbér yifnai, yéfrendai ambum a yangoi yárefafaf. ");
INSERT INTO nmx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A fá sélngwél emormén Ngánjánene ndimbal yam wafroghan. Njam méinyotio ár sélngwél emormén a korayawét Yesuene yam wafroghmén, yémon emndai yánjo waitogh ár, ");
INSERT INTO nmx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mer kéráye káyárangi yéndon némé waufroghét féfe ewawafngon. Ároene Ambum so sén yérametat árfene ngángat.” ");
INSERT INTO nmx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wénde fá yau mat náyátoyénd némé tésérmbnau. Ménamén ténoghe témorwén yéfefaf, fá yau mat náyátoyénd, a fá férfér tamorwén ámoghét yáfaf yénémamén. ");
INSERT INTO nmx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yáne waitogh ár mwighayan ásnanéghan tamorwén efe so yém ndimbal. ");
INSERT INTO nmx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Wénde Yesu mat náyátoyéng yéfene mwighé, féyo yémon yakayoi némbnar ambum tosé kété yá téndon. ");
INSERT INTO nmx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Féyo yémon emndai fá, “Emo njam tumyongé yéné némbnar ambum tosé tane yétkwénan kumyongé yénd, a emofem yénd umyotat fá kumyongé emo wémáfáretam. Efe némbne yém féfefaf méinyotio fá siyém ndimbal.” ");
INSERT INTO nmx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon norayai, “Yuré, yéndfem ár yinjongém yaufi mbérmbér tawifnau fene yétkwénan a yéta tékmbotawém, ménamém fá yau téfene yém.” ");
INSERT INTO nmx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesum emndai, “Yau yékmbotati ménamén emo njam yau nékarota fá siyém téfeta.” ");
INSERT INTO nmx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuene efogh kaka kénamndetau angoghét njafarot, Yesum sotafé mwighé yékmai álighét Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yémon engwáfáretam si résagh ár frondeyo, efe engmormén Samaria méngotuot rokar frengéghét yáyot, ");
INSERT INTO nmx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","wénde árém kété yau umyoyénd fá, ménamén fá tiotau Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Njam waitogh ár Jems a Jon yinjeyayénd yéné, yémofem yémotangeyayénd, “Yuré, fém ménde ném yénd fésot kutnangém njafarot yéfe wasérmboghét.” ");
INSERT INTO nmx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Wénde Yesu nawengoi ewárnam fá. ");
INSERT INTO nmx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","A fá néwanoyénd ámb méngotuot. ");
INSERT INTO nmx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Fá njam endmé tangmormén árom yémndai Yesu, “Yéndon so némaitotan árkamé fém njam niota.” ");
INSERT INTO nmx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesum yawangoyéng, “Ághéághafene féne té em a menafene njén té em, wénde Ároene Ambumoene sifayé yau yém kéméghét a enághét.” ");
INSERT INTO nmx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yémon yémndai ámb ár, “Kwénmaito yénd.” Wénde árém yawangoi, “Yuré, yénd so fronde nangotan méngot kétán tane afé kér njam yém yéndon so yiyátotan soramé yéndon so kémaiton.” ");
INSERT INTO nmx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesum yémndai fá, “Kér ár yémofem so eyátotat efe em mbérmbére kérwén, wénde fém nguwano Ngánjánene limánéghmén si waitoghét.” ");
INSERT INTO nmx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wéi ámb norayai, “Yéndon so kémaiton fém, Yuré, wénde so fronde néngangotan tane mérén watembghét.” ");
INSERT INTO nmx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesum yawangoyéng, “Emo tarégh ásáfogh térnyangé a néreta sémta, fá féyotarofnar yém Ngánjánene limánégh ásáfoghét.” ");
INSERT INTO nmx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yéné soramé Yuram ewaferyéng 72 ámb waitogh ár a sómbiosómbioe ewáfáretam méinyotio tesenot a yuwot ándan fá álighét ménde témorwén. ");
INSERT INTO nmx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yémon emndai, “Wau yu njamke téfén tarégh siyém tárfár, wénde ásáfogh ár em nambio. Yénémaménnde témndangi wau yuwan njamke téfén Yuré, so ewáfárete ásáfogh ár yáne njamke téfén ndawot. ");
INSERT INTO nmx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kuwanongiǃ Yéndon fém ewáfáretan ndené wáutáréghofnar tosé sifnit yéfe kénjún munjan ághé. ");
INSERT INTO nmx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yau ersati mani yáf a áwogh yáf. Ámb sandol yau ersati. Yau teke árfé asneghét endén. ");
INSERT INTO nmx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Njam fém kélawangi méngon fronde korayangi, 'Frengégh yém yéné méngon.' ");
INSERT INTO nmx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yéné frengégh ár njam kété yém, féfene frengégh so nene yáfaf, yau njam, féfefaf so kénangongé. ");
INSERT INTO nmx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kété táf emor yéné méngon, njamke nu némé njam ewarametat nénet, ménamén ásáfogh árém táf ersat yéfenjo fai. Yau nusanati wélafé méngomé. ");
INSERT INTO nmx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Njam tesenot kélawangi a taumyongi, enetati féfeyot némé em frengéghkaf. ");
INSERT INTO nmx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Enjne téfnár mer eyátotati efe kété em ewaufrotati ndené, 'Ngánjánene limánégh siyém kaka yém féfefaf.' ");
INSERT INTO nmx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wénde njam tesenot kélawangi a yau taumyongi, endmé kuwanongi a korayangi, ");
INSERT INTO nmx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Féfene tesenmén ngwérméng nakayongi téfene kafkafan, yéndfem ewainangém féfe matot. Wénde nawafarotati yénémamén: Ngánjánene limánégh kaka yém.' ");
INSERT INTO nmx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yéndon ewaufrotan, falogh efghon Sodommén némbnare yénmormén wénde minde tukén falogh so yém yéné tesenan. ");
INSERT INTO nmx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nderé yaufi so yém féfeyot, Korasinǃ Nderé yaufi so yém féfeyot, Betsaidaǃ Yéné sélngwélafé yam árké kufrotawét féfefaf té kufrotawét kété Taire a Sidonén, fá fiya kawengongayénd tándái, fá tamorangérwén saghafé a sakwéfafé. ");
INSERT INTO nmx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Falogh efghon Taire a Sidon yéfene tékrat so yém minde tukén, wénde féfene tékratam so taindangé yéfene tékrat. ");
INSERT INTO nmx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A fém, Káfenam, so kuyongi njafarot? Yau, fém so keworngi kémboghofnar yékwét.” ");
INSERT INTO nmx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesum emndai yánjo waitogh ár, “Emo fém njam niyáreta, yénd yémon so wiyárete, Njam emo fém nékena, yénd yémon wékene, wénde emo wékene yénd, fá yékene emo yénd wénmáfáretam.” ");
INSERT INTO nmx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","72 waitogh ár kénangotawét áuwéghafé fá nafroyénd, “Yuré, yaufi mbérmbér mé kénamnyongayénd téfefaf fene yétkwénan.” ");
INSERT INTO nmx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesum ewawangoi, “Yéndon yinjon Sáifér nénuyai toyanit njafarta. ");
INSERT INTO nmx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Káyárangiǃ Yéndon muyé ewaramayénd álighét kamban a ndérkamé yátmé a waingéghét mék téfnárfene wafté, némé yam yau so némaghne. ");
INSERT INTO nmx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wénde yau náuwétati ménamén yaufi mbérmbér namnyongi féfefaf, wénde áuwégh féfeyot ménamén féfene yétkwén ekai njafaran.” ");
INSERT INTO nmx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yéné efghon, Ngánján Mbérmbéram Yesu áuwéghe yafoi norayai, “Yéndon némuwetan fém, Afé, Yuré njafarmén a mbandmén, ménamén fémon némé etnoi yéné yam kétándmé mer mwighé ár a matyam ár tambén wénde sáfét tawakmetau kor matyamofnar árét ambumnit. Néméwét, Afé, yéné témorwén fene mer frengéghafé. ");
INSERT INTO nmx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Méinyotio yam enramai tafaf tane Afam. Efe ámb yau mat yém Ambumoenemén mé Afaro, a efe ámb yau mat yém efe Afé yém mé Ambumro a fáro efe Ambumom ewaferyéng yá uyafoghét.” ");
INSERT INTO nmx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Féyo Yesu nawengoi yánjo waitogh árfefaf emndai yéfembiaye, “Frengégh yém yéfeyot emofem yinjoyénd fémofem némé yéfandati. ");
INSERT INTO nmx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ménamén yéndo emndetan ndené tárfár Ngánjánene mat yátogh ár a warsagh ár ménde em fandaghét fémofem némé yinjongi, wénde yau yinjoyénd, a náyárangi fémofem némé náyáretati, wénde yau náyárayénd.” ");
INSERT INTO nmx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ámb efghon ámb nák watamegh ár nokayoi Yesue ufoghét a yémotai, “Watamegh ár, yéndon némé so yafrotan efalo tuot ghérsé résaghét?” ");
INSERT INTO nmx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesum yawangoi, “Némé si yékai nák kénjún? Fémo ndernáye yafene?” ");
INSERT INTO nmx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yémo yawangoi, “'Yuwetang Yuré fene Ngánján méinyotio fene tikfe, méinyotio fene mbérmbére, méinyotio fene waftaye, méinyotio fene mwighaye,' a 'Yuweta fenjo kaka ár ndenéyameyo fémyo ndernáye náuwete.'” ");
INSERT INTO nmx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesum yawangoi, “Efalo, yéné yafrota a fém so nakete.” ");
INSERT INTO nmx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wénde fá ménde témorwén fáyo sái kauyafongai, féyo yémo Yesu yémotai, “A efe yém tane fútar?” ");
INSERT INTO nmx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesum yawangoi, “Ár nuwanoi Jerusalemta kétán Jeriko, endén yésmetamén oro téfnáram. Yémofem sáláme yéfitérnaménd, yésmetaménd yéfrangoyénd krotro fá nuwanoyénd táf, ");
INSERT INTO nmx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ghéngén wárogh ár téngmorwén yéné endmayo wénde njam yinjoi ár, yamnjai téndomé. ");
INSERT INTO nmx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yéné endmayo Lefi mérénmén ár ténmorwén yinjoi fá yamnjai téndomé. ");
INSERT INTO nmx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Wénde Samariamén ár nénwanoi yéné endmayo njam yinjoi karémbkarémb a tikfan ghérghérsisé nawerai. ");
INSERT INTO nmx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Fá néwanoi yáfaf, tiyátotau olif wékére a wéri nue, tumbwetau ngifafmé. Féyo yémon yéfayoi yánjo ndonkiyan a térsau fá kétán yánjo wanjengégh méngot a tanjetau. ");
INSERT INTO nmx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ámb efghon yémo sómbio silfé mani mbwe yaramai méngo wanjengégh téfnárai. Fá noyarai, 'Yanjeta fá, yénd njam nénangotan, fémon njam tárfár mani etarna, yéndon so kémawasongén.' ");
INSERT INTO nmx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Yéné nambio mérénta fém ndernáye nemne efe fútar yém yáyot efe oro téfnáram yésmetaménd?” ");
INSERT INTO nmx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nák watamegh árom yawangoi, “Yéné ár fiyém emon ghérghérsisafé yinjoi.” Yesum yémndai, “Nguwano a yénéyamyo yafrota.” ");
INSERT INTO nmx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu a yánjo waitogh ár tanmorwén néndkéfan, nufaryénd méngotuot, amaf yétkwén Mata Yesu yumyoi yánjo méngot. ");
INSERT INTO nmx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Matane yánngén yétkwén Meri efe námnjoi Yurane kafkaffaf tiyáretau fá némé korayau. ");
INSERT INTO nmx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wénde Mata mwighayam tawérsotau ásáfogh tárfármén. Féyo Mata yénmormén Yesuefaf yémotai, “Yuré, fém mat ném Merim yénd té wéfrango tambia ásáfoghan? Ténémnde ta wáutárghét.” ");
INSERT INTO nmx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yuram yawangoi, “Mata, Mata, fém némawérsotat a mwighat néméindat tárfár rokaram, ");
INSERT INTO nmx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","wénde ámbiro rokar náláite. Merim té yafer némé mer yém, a yau so tanangé yá tambén.” ");
INSERT INTO nmx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ámb efghon Yesu Ngánjánjafé koraiwét fénaté sifayan. Njam yifoi, ámb yánjo waitogh árém yémndai fá, “Yuré, ténmatameta Ngánjánafé orayégh, ndené fété Joném ndernáye tawatametau yánjo waitogh ár.” ");
INSERT INTO nmx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesum emndai fá, “Fém njam Ngánjánafé norayet, ndené koraya: “Afé, utmanéghafé fene njúnnjúnofnar yétkwén, fene limánégh so yéném. ");
INSERT INTO nmx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Méinyotio efghon njamke so yénmaramete. ");
INSERT INTO nmx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kénmawalindangé téfene yaufi, ménamén yénd yéfene yaufi yénmawalinda emofem ewafrotat téfefaf. A yau yénd yénérsa ufoghan.” ");
INSERT INTO nmx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Féyo Yesum emndai fá, “Fém ámb njam ném fútarafé, a fá nuwanoi yáfaf sémbár néndkéfan a norayai, 'Fútar, kwaram nambio féskaf flawé, ");
INSERT INTO nmx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ménamén tane fútar té téném nayuta tafaf, a yéndon némé ámb yau téfrendan yáyot!' ");
INSERT INTO nmx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Efe kénjún témorwén yawangoi, 'Yau wawérsota. Sésafne siyém manéghkaf yém, tane ambumtértér a yénd kémégh yénkém. Yénd yau so kanon a némé yau so kémaraman.' ");
INSERT INTO nmx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yéndon némndetan fém, fá yau njam kanongé a kémaramangé féskaf flawé ménamén fém ném yáne fútar, wénde fá so kanongé a kémaramangé méinyotio fém némat ménde ném, fém yau wáiwái ném ménamén mé sái nómnenda. ");
INSERT INTO nmx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Féyo yénd norayan féfefaf: Kamota a so kémaramangé; yéronja a so tinjo; náutána a feyot sésafne so kasawérngé. ");
INSERT INTO nmx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ménamén méinyotio ár emofem namotat so yanangi, méinyotio ár efe yéronjat so tinjongi; fá efe náutánat, sésafne so kasawérngé. ");
INSERT INTO nmx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Fém afé, fenjo ambumom njam kénmamnendangé wagifot, némé so taram kamban? ");
INSERT INTO nmx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O njam kénmamnendangé ghakér kowi mbweyot, némé so taram ndérkamé yátmé? ");
INSERT INTO nmx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Féyo fém ndemamén yaufi ném, fém mat ném mer rokar ramégh fenjo ambumafet. Nderé mer yém minde tukén fene Afé njafaran tawaramangé Ngánján Mbérmbér yéfeyot efe nómnendat yáfafǃ” ");
INSERT INTO nmx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ámb efghon Yesum yaufi mbérmbér yutoryéng babé ároeta, a njam yaufi mbémbéram yéfrangoi, ár efe babé témorwén si nufngoi. Ár mérén sélngwél emormén. ");
INSERT INTO nmx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wénde ámb ár norayayénd, “Yaufi mbérmbérafene sénko téfnároene yétkwénan Beljebab, Yesum yaufi mbérmbér eutone.” ");
INSERT INTO nmx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ámb árém yufotam Yesu ámogh sie yémotayénd njafar tukmén yam wiyafoghét. ");
INSERT INTO nmx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu mat namndai yéfene mwighé, féyo emndai fá: “Árké yu afaloghét kufngongé yambiayot so kirorngé a árké méngo mérén afaloghét kufngongé yambiayot so kuyangé. ");
INSERT INTO nmx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Njam Sáifér afaloghét kufngongé yambiayot, ndernáye yáne yu so yakai? Yéndon norayan yéné ménamén fém nemnati ndené Beljebabene yétkwénan yéndon kar yaufi mbérmbér eutonan. ");
INSERT INTO nmx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Njam yéndo eutonan yaufi mbérmbér Beljebabene yétkwénan, wét endene yétkwénan eutonat fene waitogh árém? Fenjo waitogh árém efalo niyátotat fém yau mbarkánd ném. ");
INSERT INTO nmx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wénde njam yéndon eutonan yaufi mbérmbér Ngánján waftaye táf nde Ngánján limánégh yéna yém féfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Njam muyafé ár yakai umaneghkaf yambwete yánjo méngo táf yáne rokar mer so em. ");
INSERT INTO nmx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wénde njam minde muyafé árom tésmangé a taindangé fá, yémon tangwanangé mék rokar árkéménayan yuré kamyotau a efaloi némé yémon ewanai oroe. ");
INSERT INTO nmx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Efe yau yéndfé yénre, fá siyém ta kenagh ár, a emon yénd yau sái wáutána umengan, fá so nironat. ");
INSERT INTO nmx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Yaufi mbérmbér njam kéntorngé ár tambén, fá nguwanongé fanfne yuwot sifayé ronjaghét enághét. Wénde yau njam sifayé tinjongé, so korayangé, 'Yénd so nangotan kétán árké méngota wénmormén.' ");
INSERT INTO nmx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Njam kénangongé tinjongé méngo sámburéghkaf njúnnjúnofnar a mer frengéghkaf. ");
INSERT INTO nmx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Féyo yaufi mbérmbér kuwanongé a tanwasrongé ámb 7 mbérmbér minde yaufi ndené fáyo, fá kélawangi a emor kété. A ároene ghérsé minde mámáfi kamndangé kétándmé fronde ndernáye témorwén.” ");
INSERT INTO nmx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesum njam korayau yénémamén, amaf nutnayéng ár mérén kénjún, “Frengéghkaf amaf yém emo náráftam a endene nonoyan kanotau.” ");
INSERT INTO nmx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesum yawangoi, “Frengéghkaf fá em efe náyáretat Ngánjánene si a wafroghan tékmangi.” ");
INSERT INTO nmx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Njam ár mérén tárfár kénáyátotau, Yesu norayai, “Yéné yaufiyaufi ár mérén em. Fá namotat Ngánjánene wafroghyamot, wénde némé yau so tawaramangan mé Jonane ufarogh yamro. ");
INSERT INTO nmx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ndené Jona témorwén Ninéfa tesenmén árét yam ufarogh, ndené endeyo Ároene Ambum so wéi yém yam ufarogh yéné ár mérnat. ");
INSERT INTO nmx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sifa ndimbal yuoene warsagh amé so kokayongé moghét yéné ár mérnafefaf a so tawafalngonga ndené fá srem yaufiyamafé; ménamén yéné amaf yénmormén yu nayu Solomonene káfeté mwighé áyárghét, a ámb ár yéna yém yá tukén Solomon. ");
INSERT INTO nmx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ár Ninéfamén so kokayongi moghan yéné ár mérénfaf a so tafalngongi, ménamén fá nawengoyénd Jonane si waitoghan, a ámb ár yéna yém yá tukén Jona. ");
INSERT INTO nmx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Árké árom kwayaghé yau so tékmangé kété ánde so yétno, o mbáfyáf mbanmbanan. Wénde yémon téfayongé yánjo fayogh sifayan, ménát efe njam eném yémofem kwayaghé so yéfandat. ");
INSERT INTO nmx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fene ghékéf sem kwayaghé em fene fifiot. Fene ghékéf njam mer ere, fene méinyotio fifi so yém kwayaghayan. Wénde njam mámáfi ere fene ghékéf, fene fifi so yém méinyotio kwéfkwéfan. ");
INSERT INTO nmx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kor fém aném ménát kwayaghé fene kénjún yau táf yém kwéfkwéf. ");
INSERT INTO nmx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Féyo táf fene méinyotio fifi sái yém ndimbal kwayaghayan, ámb fifi kafe yau so yém kwéfkwéfan, so yém méinyotio kwayaghayan njam lambefane kwayaghé kátremngongé fefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesum njam si yifoi Farasi árom yumyoi yémafe nénet. Féyo Yesu naflai a námnjoi nénet. ");
INSERT INTO nmx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Wénde Farasi ár sélngwél yémormén ménamén ngángé umbarghofnar Yesum néne ewafngoi. ");
INSERT INTO nmx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yuram yémndai Farasi ár, “Fém Farasi ár kafusi a sin faruro esénnati, wénde kénjún fém sem kwénjta a yaufi kér ro. ");
INSERT INTO nmx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fém afrengéghofnar árǃ Fém mat em emo faru yafrotam, wéi ndenáyo yafrotam kénjú? ");
INSERT INTO nmx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wénde tawaram némé enyau fene kénjún yauyau árét, méinyotio so em féfeyot njúnnjúnofnar. ");
INSERT INTO nmx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nderé mámáfi so yém Farasi ár féfeyot, ménamén féfene ramégh siyém Ngánjáneyot méinyotio ndau tambén, wénde fémofem yékenati Ngánjánene uwégh a mbarkánd yam. Fémofem so otameghét yékmetati Ngánjánene uwégh a mbarkánd yam, a yau nékmbotati ndau njamke raméghta. ");
INSERT INTO nmx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nderé mámáfi so yém Farasi ár féfeyot, ménamén fémofem méndefé yéfandati mer ámnjogh sifayé áumengégh méngon, a áuwégh si utmanégh térarégh sifayan. ");
INSERT INTO nmx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Nderé mámáfi so yém Farasi ár féfeyot, ménamén fém ndenanit em wayamngoghofnar mbéwé, árkamé ár eyota matofnar.” ");
INSERT INTO nmx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ámb nák watamegh árom yawangoi, “Watamegh ár, njam fém noraye yénémamén, fémon mámáfi yénd yényátote ndenáye.” ");
INSERT INTO nmx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesum yawangoi, “Fém, nák watamegh ár, nderé mámáfi so yém féfeyot, ménamén fémofem árét ewafayotati kérté résaghét, wénde fémofem yau so ewáutánati kérté résaghét ámbiro tombé min ngángaye yéfe wáutárghét. ");
INSERT INTO nmx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nderé mámáfi so yém féfeyot, ménamén fémofem mbéwé méngo erametati yéfeyot Ngánjánene mat yátogh árfet, efe féfene ákifem té esmetaménd. ");
INSERT INTO nmx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fém nafrotati efalo yiyátotati féfene ákifem némé té yafrotaménd; yémofem esmetaménd Ngánjánene mat yátogh ár a fémofem yéfene mbéwé méngo erametati. ");
INSERT INTO nmx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yéné téfnan, Ngánján yánjo káfeté mwighé norayam, 'Yéndon so ewáfáretan Ngánjánene mat yátogh ár a Yesuene muyafé ár, wénde ámb so esmetat, ámb wéi so ewifnat.' ");
INSERT INTO nmx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Féyo ár mérén yénanotio sénonjo efogh so em téfnot ménamén Ngánjánene mat yátogh árfene férék eréghmén kétándmayo rényégh, ");
INSERT INTO nmx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kétándmé Abelene férék kétán Jakarayane férék, efe yésmetaménd ghéngén wárogh kitaré a njúnnjúnofnar sifayé yéné néndkéfan. Néméwét, yéndon némaufrotan fe, ár mérén yénanotio sénonjo efogh so em téfeyot méinyotioat. ");
INSERT INTO nmx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nderé mámáfi so yém nák watamegh téfnárét, ménamén fémofem mé té tamndawét yéné ki matyam sésafne sauréghmén. Fémyo yau so kélawangi kénjút, a fémofem ekmbotati fá efe élaughét narametat.” ");
INSERT INTO nmx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Njam Yesu nuwanoi kété, Farasi ár a nák watamegh téfnár nékwe tasotawét a ámogh si tarametawét tárfár yammén, ");
INSERT INTO nmx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kawanjetawét sái terangayénd Yesu ménáyan némé yaufi si sái korayangai. ");
INSERT INTO nmx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Njam ár mérén náumendaménd, féyo fárofáro kafkafe katumndawét. Yesum si yérnyai fronde yánjo waitogh árfefaf korayau, “Fém so nawarawenati kétándmé Farasi árfé unyégh ghérsé tambén. ");
INSERT INTO nmx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Efogh yéném némé méinyotio yafar so kanendangé, a némé ténoghe yém so nufanat. ");
INSERT INTO nmx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Fém némé noraye kwéfitayan so kufarngé kwayaghat, a fémon némé yawanjai ténganan kénjúnro so yaitote kétándmé méngo sémsota. ");
INSERT INTO nmx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Yéndon ewaufrotan, tane fútaréf, férfér yau em emofem fifi esmetat a yéné soramé yémofem yau némé so yafrotat. ");
INSERT INTO nmx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wénde yéndon ewauyafotan féfeyot efe so férférafé yéfandati: férférafé yéfandati Ngánján, féfene ngi soramé, fá muyafé yém emo so ewite fését. Néméwét, fá yéné yém efalofifi fémofem efe so férférafé yéfandati. ");
INSERT INTO nmx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Némé 5 némbne men tamorwén 20 toyaye? Wénde némé yau wawalingé yém Ngánjánene kénjún. ");
INSERT INTO nmx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Néméwét, féne sénko séf sem Ngánjánene waféghkaf em. Fém yau férférafé em. Fémofem ewaindati némbne men tértér. ");
INSERT INTO nmx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Yéndon ewaufrotan, emofem yénd wiyátotat safén nde fá em tane, ndenéyameyo Ároene Ambumom so efalo tayátongé nde fá em tane kété Ngánjánene njafar si résagh árfene sáfrére. ");
INSERT INTO nmx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wénde emofem njam wékenat yénd ár safén wéi so ekenan Ngánjánene njafar si résagh árfene sáfrére. ");
INSERT INTO nmx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Efe njam noraya Ároene Ambumoeta so tawalindangé, wénde efe njam noraya yaufi si Ngánján Mbérmbéroefaf yau so tawalindangé. ");
INSERT INTO nmx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Njam fém nénémnjat áumengégh méngot, limánégh ár a muyafé árfefaf, fém yau mámé mwighé em ndernáye fém so nawamarotati o fém némé so norayati, ");
INSERT INTO nmx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ménamén Ngánján Mbérmbéram so ewatamete fém yéné efghon némé so norayati.” ");
INSERT INTO nmx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ámb ár norayai mérén kénjún yáfaf, “Watamegh ár, témnde tane ané faloghét némé tane afam euroi.” ");
INSERT INTO nmx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesum yawangoi, “Fútar, emo wékafai yénd ménát yéndon efalotan rokarrokar féfene néndkéfan sómbio ár?” ");
INSERT INTO nmx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndenaye fá norayai yéfefaf, “Kor fété! Ménamén féfene méinyotio fénatafénaté kwénjtamén; ménamén féfene ghérsé yau so rokaram tawanjarngé.” ");
INSERT INTO nmx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Féyo Yesum emndayéng yéné rengerenge si: “Kété témorwén ámb wemár ár efe témorwén mband yuré némé kanotawét mer rokar ndawan. ");
INSERT INTO nmx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Fá nemnayéng, 'Yéndo némé so yafrotan? Tane yau kor sifayé yém ánde tane méinyotio rokar so ewamndan.' ");
INSERT INTO nmx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Féyo fá norayai, 'Yéné fiyém yéndon némé so yafrotan. Yéndon so yironan tane wamángégh méngo so yérametan ndimbalfifi, a kété yéndon tanjo ndau rokar a tanjo ámb rokar so ewamndan. ");
INSERT INTO nmx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yénd so korayangén tandio táf, “Tafaf em tárfár mer rokar ekmang tárfár yunjéf. Afrát ghérsaye so némor; njamke néne kénjún, wéri nu néneyan a so náuwéte.”' ");
INSERT INTO nmx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Wénde Ngánjánam yémndai fá, 'Fém mámáfi árǃ Yéné sémbáran fémon fene ghérsé so téram. Féyo emon so tawanangé méinyotio rokar fémon némé té táfrende fendio?' ");
INSERT INTO nmx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Yéné fiyém ndernáye so yém ámb ár emon rokar ewamnde yandio wénde yau em wemár ár Ngánján kénjún.” ");
INSERT INTO nmx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Féyo Yesum emndai yánjo waitogh ár, “Yénémamén yéndon emndetan, mwighayam yau ewawérsota ménamén féfene ghérsamén, némé so enetati; ménamén féfene fifimén a némé so ewawo. ");
INSERT INTO nmx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ghérsé siyém minde tukén, wénde njamke siyém yuwanyo yém, a fifi siyém minde tukén, wénde sáláme siyém yuwanyo yém. ");
INSERT INTO nmx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kéretangi kétán kwagh kés em: yémofem yau eitat o etanat, yéfene wamángégh méngo yau ewam; wénde Ngánjánam emanjne fá. Fém em minde tukén Ngánjánene ghékfan a ewaindati yéné men! ");
INSERT INTO nmx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Fém so féyotaro em ndené teke sái emor ménáyan mwighé wawérsoghan yénémamén? ");
INSERT INTO nmx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Táf njam yau ewafrotati yéné némbne rokar, fém némamén mámé mwighé so nemnati ámb rokarmén? ");
INSERT INTO nmx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kéretangi ndernáye kéghat mbumbu nanotat. Fá yau násáfotat minde yéfenjo sálámet. Wénde yéndon emndetan, yau mer ndené Solomon yáne méinyotio merfifi rokar kénjún fá umaneghkaf témorwén ndené mbumbu kés em. ");
INSERT INTO nmx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Fá Ngánján yém emo ewamanete kéghat yus, árkéméné sénonjo yéna em káye kawaindangi a ewite fését. Nderé minde tukén yémon némamanete fém? Nderé némbne mwighafé fém emǃ ");
INSERT INTO nmx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Fém yau féfenjo tikéfan nuitati njamkemén a numén, fém yau mwighayam ewawérsota yénémamén. ");
INSERT INTO nmx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ménamén téndo ár yéné mband maratan nérsat yéné rokarot, a fene Afé mat yém féfene némé ménde em. ");
INSERT INTO nmx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wénde yéronjati Ngánjánene limánégh, a yéné rokar so tawaramangé féfeyot féyotaro. ");
INSERT INTO nmx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Férfér yau em, némbne mérén, ménamén féfene Afé áuwéghan yém so tawaramangé Ngánjánene limánégh. ");
INSERT INTO nmx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fémofem tátérnangi féfene némé ewam a tawaramangi yauyau árét. Néusnati mani yáf féfendio árkéméné yau so kefongi, féfene ngonjél so njafaran yém kété ánde yau so kefongi, ménamén yau oro téfnáram so tawanangi a yau so ghénjam ewasérmbotat. ");
INSERT INTO nmx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ménamén ánde féfene ngonjél yém, féfene tikéf kété so em. ");
INSERT INTO nmx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Túmén afrengéghkaf aem Ngánjánene ásáfoghét méinyotio efogh a sémbár, ");
INSERT INTO nmx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ndenanit ásáfogh ár kawanjetawét ménát yéfene ndimbal ár so nénangote awerégh téméndta, fá njam nénangota a náutána, yémofem sésafne táfandio so tasawérngi yáyot. ");
INSERT INTO nmx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nderé áuwégh so yém yéfeyot yéné ásáfogh árét yéfenjo yuram tawinjongé fá táf afrengéghkaf njam em fá sái nénangota. Yéndon féfe ewaufrotan efaloe, yémon so téfitrarngé awerégh sáláme ménát sái efrenda faiofnar ásáfogh ár, so tamndangé ámnjoghét njamke sifayan a sái ewarameta yéfeyot njamke. ");
INSERT INTO nmx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nderé áuwégh so yém yéfeyot ásáfogh árét yéfene yuram njam tawinjongé afrengéghkaf, fá njam nénangota yéné efghon sémbár néndkéfan o akwan faurghan. ");
INSERT INTO nmx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Wénde fém so mat em: Méngo yuré mat njam té témorwén árké efogh fénefénean oro téfnár so ténmorwén, yémo yau so tumyongé oro téfnár yáne méngo fétrarghét. ");
INSERT INTO nmx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Fém so afrengéghkaf em, ménamén Ároene Ambum sái yéném yéné efoghféneféneyan fém yau njam nawanjeta afrengéghofnar.” ");
INSERT INTO nmx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Fitam yémotai, “Yuré, Fémo yéné rengerenge si noraye téfendro o méinyotio árét?” ");
INSERT INTO nmx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yuram yawawangoi, “Efe ndené yém ndimbal mwighafé a mer wanjengégh ár? Fá yéné féyém yánjo yuram so tékmangé méngo wanjengét sái ewarameta njamke efoghféneféneyan? ");
INSERT INTO nmx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nderé mer yém yéné ásáfogh téfnárai yáne yuram tinjongé yáne ásáfoghan fá njam nénangota. ");
INSERT INTO nmx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yéndon némaufrotan efaloe, yémo so tékmangé fá wanjengét yáne méinyotio rokaran. ");
INSERT INTO nmx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wénde táf faiofnar ásáfogh ár norayai yandio, 'Tane yuram yérse teke efogh angoghét,' a yémon ngi ewafngoi ásáfogh ár a amaf, a njamke nénet a wéri nu nénet ménát wériot. ");
INSERT INTO nmx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yéné ásáfogh téfnárane yuré so nénangote yéné efghon njam fá yau yánjeta fá a yau yéné efghon mat yém. Yáne yuram so tékrátan tékmangé kéran a yémon so ewite yémafé áyáréghofnar árfé. ");
INSERT INTO nmx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ásáfogh téfnár efe mat yém yáne ndimbaloene ménde wénde yau náfrenda o yau yafrota yáne yurane ménde, fá so efmote minde. ");
INSERT INTO nmx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wénde ásáfogh téfnár efe yau mat yém a emo yaufi yafrote, fá so efmote némbnare. Kétándmé méinyotio árét endefet ewaramete ndimbal yéfeyot, ndené ndimbalyo so taramangé. A kétándmé emon njam efalo yiyátota ndimbale, ndené ndimbaleyo so taramangé. ");
INSERT INTO nmx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Yénd wénmormén fés yénérsamén yéné mbandot, yénd nemnan fés té nawaro wénde yau nawaroǃ ");
INSERT INTO nmx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Fronde yénd táf so wém ndimbal tékrátan, a nderé kérté yamamé so wiota kétánotio tane tékrát kefongéǃ ");
INSERT INTO nmx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Fém nemne yénd wénmormén krufrát yénérsamén yéné mbandot? Yau, yau krufrát, wénde falogh. ");
INSERT INTO nmx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yénandmé sénonjo ámbiro mérén 5 so nafalotat mé fáro, nambiota kétándmé sómbio a sómbiota kétándmé nambio. ");
INSERT INTO nmx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Fá so nafalotat, afé kétándmé ambum a ambum kétándmé afé, amé kétándmé mérés a mérés kétándmé amé, tanat alé kétándmé nakum alé a nakum alé kétándmé tanat alé.” ");
INSERT INTO nmx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Fá norayai mérénfaf, “Njam fémofem tawinjongi nu kwéf nénarmbotat mbormborta, efaloe fém so korayangi, 'Nuwét yém,' a so nafamnde. ");
INSERT INTO nmx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A njam náikái mbormbor yénéfnje, fém so korayangi, 'So yém wafté,' a so nufrote. ");
INSERT INTO nmx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Efe farun mer néretati wénde kénjún yauǃ Fém mat em ndernáye so tayamngongi yam mbandan a njafaran. Fém yau mat em ndernáye so tayamngongi sénonjo efoghmén. ");
INSERT INTO nmx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Fém fémyo mat em némé yém mbarkánd. ");
INSERT INTO nmx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Emon njam tawinjongé fém kérté wafroghan mato kérté efrendati soramé so engém mogh sifayat. Yau njam, so tawerangi mogh sifayat. Féyo nák wanjengégh árém taramangi kétán félismanefaf a félismaném tákmangi kwéfkwéf sifayan. ");
INSERT INTO nmx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Yéndon emndetan, fem yau so kéntorngi kétánotio fém njam méinyotio fai nufrotati.” ");
INSERT INTO nmx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Táf yéné efghon ámb ár tamorwén emofem Yesue yaufroyénd ménamén Galili yu árfene férék Failetém térémnau yéfene ghéngénafé. ");
INSERT INTO nmx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesum yawangoi, “Fém nderé nemnati yéné Galili yu árfene yaufiyam árké ewafrotat yémofem ewaindat yaufiyam yéfene ámb ár kés em Galili yumén, yéné ende yémofem tékrát téfandawét? ");
INSERT INTO nmx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yéndon emndetan, yauǃ Wénde fém yau njam Ngánjánefaf kawengongi, fém méinyotio wéi kér so em. ");
INSERT INTO nmx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O efe 18 kér emormén njam tuk méngo Siloam kénjún nuyai yéfefaf, fém némé nemnati yéfene yaufiyamam ewaindayénd yéfene yaufiyam ámb kés tamorangérwén Jerusalemén? ");
INSERT INTO nmx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yéndon emndetan, yauǃ Wénde fém yau njam Ngánjánefaf kawengongi, fém méinyotio wéi kér so em.” ");
INSERT INTO nmx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Féyo yémo tamndetau yéné rengerenge si, “Ár témorwén wén mbwe tiyangérwén yáne géreif mbwe ménj ndau kénjún, a fá téngémorwén wén mbwe ereghét, wénde yémon yau ewinjoi. ");
INSERT INTO nmx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Féyo fá norayai ároefaf emo tanjetau géreif mbwe ménj ndau, 'Yénanotio nambio yunjéf sénonjo yénd té kwénmorwén wén mbwe ereghét yéné wén mbweyot, wénde yéndo yau yinjon. Ténfend! Némamén mé anogh so nanote yéné mbandan?' ");
INSERT INTO nmx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Árom yawangoi, 'Yuré, mé koro ámbiro yunjfot, a yéndon so yétanan téndomé dégwrot. ");
INSERT INTO nmx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Njam kafongé kétamé yunjfan, merǃ Yau njam, téngnéf.'” ");
INSERT INTO nmx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ámb Safatan Yesum tawatametau ámb áumengégh méngon, ");
INSERT INTO nmx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","a amaf témorwén kété yaufi mbérmbéram yékeindam 18 yunjéf. Fá témorwén kanémafé a yau tawalinjotau. ");
INSERT INTO nmx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Njam Yesum yinjoi fá, yémo yémotai fá a yémndai, “Amaf, fém ném mer.” ");
INSERT INTO nmx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Féyo Yesum ngángé efayoi yáfaf, a táfandio nolinjoyénd a Ngánján tuwetau. ");
INSERT INTO nmx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Áumengégh méngo limángégh ár nékw témorwén ménamén Yesum mer táyátotau Safatan, fá korayau árfefaf, “Kété sem 6 efogh ásáfoghét. Féyo eném frengéghét yéné efghon, yau Safatan.” ");
INSERT INTO nmx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yuram yawangoi yá, “Fém efe farun mer néretati wénde kénjún yauǃ Fémofem túmén taférngi kau o ndonki kétándmé kwélalta a talimángi nuot Safatan. ");
INSERT INTO nmx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Féyo yéné amaf, Ebraamene mérés, efe Sáifram yumbai yékeindam 18 yunjéf. Fá fété nawanjar Safatan kétándmé némé yam yékeinda.” ");
INSERT INTO nmx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesum njam korayau yéné, yáne mék téfnár wáiwái yam ewifoi, wénde ár káuwetawét némé mer Yesum tawafrotau. ");
INSERT INTO nmx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Féyo Yesum namotai, “Ndernáye nérete Ngánjánene limánégh? Némayafé so yétémndan? ");
INSERT INTO nmx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ndenanit némbne mbwe, árom yéngwanai yiyai yánjo ndawan a nanotam wén náyátoi, a menam njén tarametawét yéné kafeyamé.” ");
INSERT INTO nmx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wéikor Yesu namotai, “Yéndon némayafé so yétémndan Ngánjánene limánégh? ");
INSERT INTO nmx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ndené fété yist amafom yanai a yérémnam nambio flawé baik. Féyo méinyotio flawé néminam ndimbal kofékofé namndai.” ");
INSERT INTO nmx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu njam tiotau Jerusalemét, yémo tangwatametau tesenamé a méngotuamé. ");
INSERT INTO nmx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ámb árom yémotai Yesu, “Yuré, féyotaro nambio árro so tawanjar?” Yémon emndai fá, ");
INSERT INTO nmx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Minde násáfotati ménát fém so kélawangi némbne sésafnemé, ménamén yéndon emndetan, tárfár ár yéta so nufotati élaughét a yau so nufrote. ");
INSERT INTO nmx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Táf méngo yuré njam so kénangongé a so témnangé sésafne, fém so ewakai sésafne téndota náutánati a norayati, 'Yuré, sésafne tésawér téfe.' “Wénde yémon so tawawangongé, 'Yénd mafina wém fém, o fém árkamé eném.' ");
INSERT INTO nmx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Féyo fém so korayangi, 'Yéndfem njamke a nu tánetawém fémafé, a fémon ténmatametau endmé.' ");
INSERT INTO nmx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Wénde yémon so tawawangongé, 'Yénd mafina wém fém o fém árkamé eném. Kitrongi ta tambén, fém méinyotio yaufiyam wafrogh téfnárǃ' ");
INSERT INTO nmx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kété siyém yengam a sén krarégh, njam fémon tawinjo Ebraam, Aisek a Jeikof a méinyotio Ngánjánene mat yátogh ár efe em Ngánjánene limánéghan, wénde fém té kéméwitat. ");
INSERT INTO nmx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ár so eném kétándmé wérwérta a mbormborta a náikáita a yambérméta, a so tawanangi yéfenjo sifayé kété téménd kénjún Ngánjánene limánéghan. ");
INSERT INTO nmx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Efe soramé em fá so kénáyátongi frondeyot, efe fronde em fá so kénáyátongi soramat.” ");
INSERT INTO nmx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ámb efghon ámb Farasi ár enmormén Yesuefaf a yémndayénd, “Koro yéné yu a kuano ámb sifayat. Erodém ngiot némafngo fém.” ");
INSERT INTO nmx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesum yawangoi, “Nguwano taufro yéné ághéághai, 'Yéndon so ewitrotan yaufi mbérmbér, a engéfrendan ár sénonjo a káye, a nambio efogh soramé yéndon so tifon tanjo ásáfogh.' ");
INSERT INTO nmx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wénde yénd mé so wéngém sénonjo a káye a ámb efghon, ámb Ngánjánene mat yátogh ár yau so kér em Jerusalem sémta. ");
INSERT INTO nmx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem, Jerusalem, fém emofem esmetat Ngánjánene mat yátogh ár a ewafiyátotat wíme efe enwáfáretam féfefaf, yénd ménde wém fene ár so eumendan, ndenéyame amé ghakér kowiam yáne tosétosé yénau tawamongé njambe, wénde fém yau ménde kénémǃ ");
INSERT INTO nmx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kéreta, fene tesen so kafrangongé. Yéndon némaufrotan feyot, fémon yau so kwinjo wéi kétánotio fém njam koraya, 'Nderé frengégh yém efe yéném Yurane yétkwénan!'” ");
INSERT INTO nmx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ámb Safatan, njam Yesu téngmorwén Farasi árfene utmanégh ároene méngot nénet, árém kor téfandawét Yesu kakafifi. ");
INSERT INTO nmx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ámb ár efe témorwén kafkaf a ngángé mbwefé yénmorméng Yesuefaf. ");
INSERT INTO nmx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesum emotai Farasi ár a nák watamegh téfnár, “Némé nák yém ménát ár frengéghét Safatan o yau?” ");
INSERT INTO nmx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wénde fá métar nufrotaménd. Yesum yéngwasroi ár yéfrendai a yéngwatembai. ");
INSERT INTO nmx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesum emotai, “Njam endene ámbiro ambum o kau kuyangé kétán yékwét Safatan, fémo wékeye yau so turto?” ");
INSERT INTO nmx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A yéfeyot ámb yau si. ");
INSERT INTO nmx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Njam fá mat náyátoi wan téfnáram yaferyéng mer sifayé njamke sékian, yémon tawaufrotau yéné rengerenge si: ");
INSERT INTO nmx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Njam ámb árom kémumyongé fém kétán awerégh téméndfaf, yau tané yéné tuk sifayé. Yau aem ndené yéné sifayé kés yém nawamnde ároe yémo té yumyo endene em tukén yam a kémaindangé fém. ");
INSERT INTO nmx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Njam nufrota, emon njam taumiye fém so kénaflend a tamndend fém, 'Fene sifayé taram yéné ároe.' Nderé wáiwáiafé yém, fémon so tané yuwon sifayé. ");
INSERT INTO nmx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wénde fém njam kémumyongi, yuwon sifayé tané, fene téménd yuré njam yéném, yémon so kénémndangé, 'Fútar, kimnda tuk sifayat.' Fém so némutémndat wan téfnárafene sáfan. ");
INSERT INTO nmx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Efe nawarmbotat fáyo so newonat yuwot, efe njam néwonat fá so kayátongi ndimbal.” ");
INSERT INTO nmx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Féyo Yesu norayai yánjo téménd yurafaf, “Fémon njam ewarameta efoghméf néne o séite néne, fémo yau taumyo fe fútaréf a fene anéf a fene mérén o fene wemár fútaréf, fémon njam yafrota, fém so kémumyongi a so némawafángotat. ");
INSERT INTO nmx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wénde fémon njam tawaram njamke, taumyo yauyau ár, aknyégh ár, wawér, ghékéf kwéfkwéf ár. ");
INSERT INTO nmx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yémofem yau so fai némawafángotat. Wénde Ngánjánam so néfrende a fai kémawangogé njam yáne ár nénanotat kérta.” ");
INSERT INTO nmx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Soramé Yesum si waitogh yifoi, ámb wan ár norayai, “Frengégh yém yáyot emo so enete téménd kénjún Ngánjánene limánéghan!” ");
INSERT INTO nmx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesum yawangoi, “Ámb árom téfrendau ndimbal téménd a eumyoi tárfár wan téfnár. ");
INSERT INTO nmx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Téménd efghon, yémo ewáfáretam yánjo ásáfogh ár tanwaufrongi efe té eumyon, 'Taném, sénonjo méinyotio rokar siyém frengéghkaf yém.' ");
INSERT INTO nmx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Wénde yémofem si waufrogh ewafngoyénd. Fronde ár norayai, 'Yéndon mband té yanan, a yénd so wéngém fandaghét. Ghérghérsisé kwawalo tayot.' ");
INSERT INTO nmx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ámb norayai, 'Yéndo té ewanan 5 kau, a yénd álighan wém so eufotan. Ghérghérsisé kwawalo tayot.' ");
INSERT INTO nmx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Wéi ámb norayai, 'Yénd somé naweran. Féyo yénd yau so wéném.' ");
INSERT INTO nmx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ásáfogh téfnár nangotam a kafrotau yéné yánjo yurafaf. Féyo méngo yuré nékwafé naféghetam a yáfáretam yánjo ásáfogh téfnár, 'Nguwano kétor wékeye némbne endmé a kéghat endmé yéné tesenan a tanwasro yauyau ár, aknyégh ár, ghékéf kwéfkwéf ár a wawér.' ");
INSERT INTO nmx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ásáfogh téfnárom yémndai 'Yuré, fémon némé wémndai té kufrote, wénde kété mé em sifayé.' ");
INSERT INTO nmx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Féyo yuram yémndai yánjo ásáfogh téfnár, 'Nguwano kétor némbne endmé a kéghat endét a tanwaurémnau, 'Kénaflangi kénjút,' ménát tane méngo so yém afoghare. ");
INSERT INTO nmx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yéndon némndetan, efe fronde eumyongén yémofem yau so tufongi tane njamkeǃ'” ");
INSERT INTO nmx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ndimbal mérén tayotau Yesufé, a nawengoi yéfefaf yémon emndai: ");
INSERT INTO nmx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Efe njam yéném tafaf sái kamndangé tane waitogh ár, yénd so uwete mindefifi, yénamayo so euwete yánjo afé a amé, yánjo amaf a ambumtértér, yáne ghakér a mérésmérés, néméwét, ndenáyo yánjo ghérsé. Yau njam, fá yau so yém tane waitogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A emo yau njam yérsa yánjo wafatarégh wén a kwénmaitongé yénd fá yau so yém tane waitogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Njam efe ár ménde yém ndimbal méngo ramghét, fá fronde so kámnjongé a nufénmeta yéfanda njénamb mani yém wifoghét. ");
INSERT INTO nmx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yémon so tafngongé méngo ramégh, wénde yau so tifongé. Féyo méinyotio árém yéfandat némé nufrote so yurtat fá. ");
INSERT INTO nmx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Fá korayawét, 'Yéné árom yérnyai ramégh wénde yau yifoi.' ");
INSERT INTO nmx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Némé so yafrote warsagh árom táf yáne njam em 10,000 fiyaré yandio awamaroghét kétamé ámb warsagh ár emafé so násmét 20,000 fiyarafé? Fronde njam kuwanongé mékot, féyo fá so kámnjongé mwighé so yéfarone waingéghét? ");
INSERT INTO nmx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Fá yau njam yém féyotarofnar, yémon so yáfárete si résagh ár táfandio ámb mé esio a fá so kwómnendangé krufrátot. ");
INSERT INTO nmx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yéné endeyo, fémon tafrango méinyotio rokar, fém so ném tane waitogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol siyém mer yém, wénde yáne ménde njam kefongé, ndernáye so sol nawafarnjé wéikor? ");
INSERT INTO nmx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yau mer yém mbandot o ámb rokarot, árém táf yéngwitat. Efe njam ténganafé yém, so káyárangé yéné si.” ");
INSERT INTO nmx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mani kafégh ár a yaufiyam téfnár méinyotio káumendawét áyárghét yáfaf. ");
INSERT INTO nmx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Wénde Farasi ár a nák watamegh ár mike nufngoyénd, “Yéné árom eumyote yaufiyam ár ménát yémafe nénet.” ");
INSERT INTO nmx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Féyo Yesum tawaufrotau yéné rengerenge si, ");
INSERT INTO nmx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Njam ámbiro ároene em 100 sif a kolindangé ámbiro, némé so yafrote? Yémon efaloe so tafrangongé 99 marat sifayan a nguwanongé olingégh sif ronjaghét kétánotio yémo tinjongé. ");
INSERT INTO nmx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Táf yémon njam tinjongé, yémo áuwéghafé tambnangé sif téfayongé yáne fader tukén. ");
INSERT INTO nmx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Fá so nguwanongé méngot. Féyo yémon emotai yáne fútaréf a ámb kaka ár a norayai yéfefaf, 'Áuwégh yangotam yéndfé. Yéndon té yinjon tane olingégh sif.' ");
INSERT INTO nmx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yéndon emndetan fém kété njafaran ndenéyameyo kété so yém ndimbal áuwégh. Efaloe áuwégh 99 mbarkánd árfenemén efe em yaufiyamofnar, yéné siyém némbnarfifi, wénde minde áuwégh yém ámbiro yaufiyam ár efe njam kawengongé yánjo yaufita. ");
INSERT INTO nmx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Némé so yafrote amafom táf yáne 10 silfé mani mbwe em a kolindangé ámbiro? Yémon táf lambefé tuwarongé a sámburégh méngo tafngongé ronjagh merkéráye kétánotio yémon tinjongé. ");
INSERT INTO nmx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Féyo yémon njam yinjoi, yémon emotai fútaréf a ámb kaka ár a norayai yéfefaf, 'Áuwégh yangotam yéndfé, yéndon té yinjon tane olingégh mani mbwe.' ");
INSERT INTO nmx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yéndon emndetan fém, ndené endeyo, kété so yém áuwégh Ngánjánene njafar si résagh ár sáfrére ámbiro yaufiyam ár efe njam kawengongé yaufita.” ");
INSERT INTO nmx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesum wéikor si yéngwafngoi, “Kété témorwén ár sómbio ambumafé. ");
INSERT INTO nmx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kertrom yémndai yárefé, 'Afé, yénd yau so nawanjetan kétán fém kér ném. Sénonjo kwaram fene rokarta tane némé so em.' Féyo yémon ewafaleyai rokar néndkéfan yánjo sómbio ambumat. ");
INSERT INTO nmx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Féyo tekofnaye, kertrom ewanai yáne némé tamorwén, náfrendam nuwanoi nayu yuwot a mani taranégh yéngwafngoi yaufi ghérsayan. ");
INSERT INTO nmx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yéné soramé yémon njam ewifoi méinyotio rokar, kété nuyai káukáu yéné yuwon, féyo fá áronjagh nufngoi sioghmén. ");
INSERT INTO nmx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Féyo fá nuwanoi ásáfoghét nómnendai ámb árfefaf yéné yuwon, a árom yéngwáfáretam fá kimb wanjengét. ");
INSERT INTO nmx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Fá minde siogh témorwén, fá ménde témorwén kimbafene njamke mbarmbar nénet. Wénde emo yau taramangai yáyot némndafi. ");
INSERT INTO nmx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Fá njam nénangoi mwighat, fá norayai, 'Méinyotio tane afane faiofnar ásáfogh ár féyotaro njamkeyan em, a yéna yénd swém krotro wémǃ ");
INSERT INTO nmx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yénd so nangotan tane afafaf a témndan, “Afé, yéndon yaufiyam té tafrotan njafarot a fefaf. ");
INSERT INTO nmx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yénd yau féyotaro wém sái wémndeta fene ambum. Yénd kuyáto ndenanit fene faiofnar ásáfogh ár.”' ");
INSERT INTO nmx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Féyo fá nokayoi a nuwanoi yárefafaf. “Njam kété mé ténmorwén nayu, yárefam yéngwinjoi fá a ghérghérsisé yam yafoi yánemén. Fá néngengoi yánjo ambumoefaf a yambnai a tésnetau. ");
INSERT INTO nmx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ambumom yémndai yárefé, 'Afé, yéndon yaufiyam té tafrotan njafarot a fefaf. Yénd yau wémndeta fene ambum yénd wém.' ");
INSERT INTO nmx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Wénde yárefam yémndai yáne faiofnar ásáfogh ár, 'Wékeyeǃ Mer totér sáláme ténmawanangi a tawongi. Talawend ghil yáne ngángayan tawend sandol kafkafan. ");
INSERT INTO nmx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ténmanengi yarsafé kau tésmangi. So téménd yafrotam a áuwégh yangotam, ");
INSERT INTO nmx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ménamén yéné tane ambum efe kér yémormén sénonjo ghérsé yém. Fá té nolindai a sénonjo té yinjongém.' Féyo yémofem áuwégh tangotawét. ");
INSERT INTO nmx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Táfandio, fronde sénko ambum témorwén ndawan. Fá njam nénáyátoi méngo kaka, fá náyárayéng wagh ke a ermángégh. ");
INSERT INTO nmx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Féyo yémon yanmoi ámb faiofnar ásáfogh ár a yémotai némé yam nufrote. ");
INSERT INTO nmx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yémon yawangoi, 'Fene néngén té nufar, a fene afam yarsafé kau té yésém ménamén fá yéna yém a merro yém.' ");
INSERT INTO nmx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Féyo fronde sénko ambum nékw náwerai a yau nélawai méngo kénjút. Yárefé néntoryéng a yamnendai élaughét. ");
INSERT INTO nmx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wénde yémo yawangoi yárefai, 'Kéretaǃ Méinyotio yunjéf yéndon ásáfogh tafrotan feyot a yau kwawalinde fene si. Wénde fémon némé ámb yau waramai ta tosé gout ménát yéndfem téménd sái tafrotawém tane fútarafé. ");
INSERT INTO nmx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Wénde njam yéné fene ambum emo fene mani tátérnawéng yaufi ghérayan kénangote méngot, fémon yesmang yarésafé kau yáyotǃ' ");
INSERT INTO nmx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Yárefé norayai, 'Tane ambum, fém túmén yéndfé ténre. Méinyotio rokar tane sem fene em. ");
INSERT INTO nmx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wénde yéndfem ásneghafé a áuwégh tafrotam ménamén fengén kér yémormén a sénonjo ghérsé yém. Fá nolindai a sénonjo yéna yém.'” ");
INSERT INTO nmx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesum emndai yáne waitogh ár, “Ámb wemár árom yékafai ár yáne rokar wanjengét. Wénde wemár ároe yaufroyénd ndené rokar wanjengégh árom fene mani té ewalinda. ");
INSERT INTO nmx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Féyo yémo yanmoi fá a yémotai, 'Némé yéné yém yénd náyáran fenemén? Kwaram fene ásáfoghmén mat ndernaye tanjete, ménamén fém yau so ném wanjengégh ár yéné soramé.' ");
INSERT INTO nmx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Wanjengégh ár norayai yáfafétio, 'Yéndon némé so yafrotan sénonjo? Tane yuram tane ásáfoghta wutér. Yénd muyafnar wém targhét, a yénd wáiwái wém ómnengéghét. ");
INSERT INTO nmx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yénd mat wém némé yéndon so yafrotan ménát árém mé so umyotat yénd yéfene méngomé njam yéndon tanjo ásáfogh koron.' ");
INSERT INTO nmx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Féyo yémon tamotau ámbiroámbiroe yáne yurane fai wangoghét. Yémo yémotai fronde ár, 'Njénamb fai ekmang tane yurane?' ");
INSERT INTO nmx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yémo yawangoi, '20 dram olif wékwér.' Wanjengégh árom yémndai fá, 'Téngwan fenjo fefé, kámnjo wékeye, a tafarota 10 dram.' ");
INSERT INTO nmx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Wéi yémo yémotai yénamayo ár, 'Fefaf njénamb em?' Yémon yawangoi yá, '1,000 flawé baik.' Yémon yémndai fá, 'Téngwan fenjo fefé. Tafarota kétán 800 flawé baikot.' ");
INSERT INTO nmx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Yuram tuwetau yáne unyégh rokar wanjengégh ár ménamén fá kawarawenau merkéráye. Ár yéné mbandan nawarawenat merkéráye wénde kwayaghane ár yau ndené em. ");
INSERT INTO nmx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yéndon ewaufrotan féfe, fútar náyátotati fémyo mband rokere, njam tafrango, fém so kémumyongé tuot méngotuot. ");
INSERT INTO nmx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Efe njam ndimbal mwighafé yém némbne yaman, ndenáyo wéi so yém ndimbal yaman. Efe njam unyégh ár némbne yaman yém, ndenáyo wéi ndimbal yaman so yém. ");
INSERT INTO nmx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Féyo fém yau njam efalo ném mbandoene rokar wanjengét, ndernáye fém so niyátotat efalo wemáran? ");
INSERT INTO nmx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A fém yau njam efalo kéném ámb ároene rokar wanjengét, emon so kémaramangé fenjo rokar? ");
INSERT INTO nmx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ásáfogh ár yau so yém sómbio yurafene limánégh mbanmbanan. Fémon so yékene ámb a so yuwete ámb, o fém so kamnyong ámbfaf a tékena ámb. Yénémamén fém yau so sómbio limánégh mbanmbanan ném, Ngánján a mani.” ");
INSERT INTO nmx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farasi ár sem mani méndero ár em. Yémofem njam náyárayénd yéné si a fén yafngoyénd Yesu. ");
INSERT INTO nmx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesum emndai fá, “Fém yéné féyém efe mer nitaro kénamndangi árfene ghékfan, wénde Ngánján mat yém féfene tikéf. Némé minde tukén árfene mwighayan fifiofnar yém Ngánjánene ghékfan. ");
INSERT INTO nmx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosesene nák a Ngánjánene mat yátogh ároene watamegh si táitotawét kétánotio Jonene efogh. Kétándmé yéné efghon, Ngánjánene limánéghmén mer si waitogh yérnyai, méinyotio árém end táronjawét kétán Ngánjánene limánéghfaf. ");
INSERT INTO nmx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Áfráte yém njafar a mband so kawaindangend, wénde némbne si Ngánjánene sian yau so titrém. ");
INSERT INTO nmx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Emon njam yánjo amaf tatembangé a kawerangé ámb amaf kamndangé amafanyo wanégh ár a emon njam watembégh amaf kawerangé káyátongé áranyo wanégh ár. ");
INSERT INTO nmx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kété témorwén wemár ár efe kumanetau minde tukén sáláme a témorangérwén yánjo meran méinyotio efghon. ");
INSERT INTO nmx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yáne méngo sésafnefaf kété témorwén ómnengégh ár yétkwén Lajarus efe témorwén fénend kér ro ");
INSERT INTO nmx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","a ménde témorwén nénet némé kuitawét kétándmé wemár ároene njamke kitarata. Táfandio ághé tanmorwén tasambnawét yáne fénend. ");
INSERT INTO nmx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ómnengégh ár kér yémormén a njafar si résagh ár yénmormén a yéngwasroyénd fá kétán Ebraamefaf. Féyo wemár ár kér yémormén a yiyátotaménd. ");
INSERT INTO nmx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Efoghofnar yékw sifayan, wemár ár tékrátan témorwén, njam fá néretai tukét yinjoi Ebraam nayuta, yémafé Lajarus yáne téndota. ");
INSERT INTO nmx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Féyo fá nutnai, 'Afé Ebraam, tayot ghérghérsisé a témnde Lajarus ngángé tauwarngé nuan a tane kánké krufrát tiyáto ménamén yénd fés kénjún tékrátan wém. ");
INSERT INTO nmx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Wénde Ebraamém yawangoi, 'Ambum, kawafarota kété fene ghérsé ámnjogh efghon, fém meran kénmorwén, táf Lajarus yauyauan, wénde sénonjo fá enaghan yém yéna a fém tékrátan. ");
INSERT INTO nmx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ámb téfén siyém, féyotarofnar yém yéné ménamén yékw ndimbalam yénfalowé, ménát efe ménde éférmanéghét yénandmé fefaf siyém táikér yém.' ");
INSERT INTO nmx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Yémo yawangoi, 'Féyo yéndon némamnendan fém, afé, téngwáfáreta Lajarus kétán tane afane méngot, ");
INSERT INTO nmx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ménamén tane em 5 néngnéf. Mat so táyátongé fá yau so eném yéné tékrát sifayat.' ");
INSERT INTO nmx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ebraamém yawangoi, 'Buk kété em Moses a Ngánjánene mat yátogh ár efarotaménd, fá sái náyáretat yéfendio.' ");
INSERT INTO nmx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Fá norayai, 'Yau, afé Ebraam, ámb kér ár njam néngangota kétán yéfefaf, fá so kawengongi.' ");
INSERT INTO nmx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Fá norayai yáfaf, 'Yau njam náyáretat Moses a Ngánjánene mat yátogh ároefaf, fá yau so nawengotat wéi ndenéyameyo kér tambén njam kénangongé ghérsat.'” ");
INSERT INTO nmx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu norayai yánjo waitogh árfefaf, “Árké yaman eméinde ár túmén yaufiot, wénde tékrát yém yéné ároe emo eméinde. ");
INSERT INTO nmx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yéné ároefaf ndimbal wím so yumbetat kéman a yitat arakafot, yéné mé té yém némbne kérté. Wénde emo taméinde némbne ambumtértér yaufiot, fene kérté so yém ndimbal. ");
INSERT INTO nmx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Féyo kor kafandangi fémyo. “Njam fenam yaufi yafrota, yárna, a fá njam kawengongé, tawalinda. ");
INSERT INTO nmx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Njam yémo yaufi yafrota fefaf 7 mbinotmé ámbiro efogh kénjún, a 7 mbinotmé nénangota wéikor fefaf a korayangé, 'Yénd té nawengon,' fémon tawalinda.” ");
INSERT INTO nmx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesuene muyafé ár norayayénd Yurafaf, “Yuré, ténmamina téfene ndimbal mwighéǃ” ");
INSERT INTO nmx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesum yawangoi, “Njam fene ndimbal mwighé yém ndenanit némbne mbwe, fém féyotaro so koraya yéné ndimbal wénfaf, 'Karufang a kayang arakafan,' a so kényárángé fém. ");
INSERT INTO nmx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Njam fene faiofnar ásáfogh ár nénangota tarégh tambén o sif wanjengégh tambén, ndimbal ár so korayangé, 'Kénaf kámnjo njamke nénet'? ");
INSERT INTO nmx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wénde fá so korayangé, 'Tane njamke kwanegh, kwáfrenda a kwanjeta njam enetan. Yéné soramé fémo so enete.' ");
INSERT INTO nmx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kánjo yaramai faiofnar ásáfogh ároe ménamén yáne áyáréghmén némat yémon yémndai wafroghét? ");
INSERT INTO nmx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ndenéyameyo fémofem njam ewafrotati méinyotio némat té emndai wafroghét, norayayénd, 'Yénd siéném faiofnar ásáfogh árro yéném. Yéndfem tanwafrotam téfenjo ásáfoghro.'” ");
INSERT INTO nmx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu álighan témorwén Jerusalemét, tiotau Samaria a Galili yu néndkéfan. ");
INSERT INTO nmx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Fá njam kufanau méngotuot, 10 ár yaufi ghéngan enjnefé tamorwén yéfángoyénd fá. Fá nénokayoyénd nayu ");
INSERT INTO nmx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a nutnayénd minde tukén, “Yesu, Yuré, ghérghérsisé téfeyotǃ” ");
INSERT INTO nmx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesum ewinjoi fá a norayai, “Nguanongi, ngauyafongi fémyo ghéngén wárogh árfefaf.” A njamandio néngwanoyénd, fá mer néngamndayénd. ");
INSERT INTO nmx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ámbiroam, njam yinjoi frengégham yanai, nénangoi, Ngánján tuwetawét minde tukén. ");
INSERT INTO nmx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Fá budme niyai Yesuene kafkaffaf, kánjo yaramai yáyot. Fá témorwén Samariamén ár. ");
INSERT INTO nmx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesum yémotai, “Némé 10 ár méinyotio frengéghkaf em? Ánde ámb 9 ár em? ");
INSERT INTO nmx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Némamén yéné Téndo árro nénangoi Ngánján frengéghét?” ");
INSERT INTO nmx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Féyo Yesum yémndai fá, “Kokai a nguwano. Fenjo ndimbal mwighayam mer té niyáto.” ");
INSERT INTO nmx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ámb efghon Farasi árém yémotai Yesu, “Njam so Ngánjánene limánégh yéném?” Yesum ewawangoi, “Ngánjánene limánégh yau yéném yéné ende fémon so tinjo fenjo ghékfe. ");
INSERT INTO nmx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Fém yau so norayati, 'Siyém' o 'Kété yém' ménamén Ngánjánene limánégh siyém féfene kénjún yém.” ");
INSERT INTO nmx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Féyo Yesu norayai yánjo waitogh árfefaf, “Efogh yéna yéném fém njam so ménde em winjoghét ámb efghon Ároene Ambumoenemén, wénde fémofem yau so tinjongi. ");
INSERT INTO nmx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Árém so tawaufrongi féfe, 'Kété fá yém,' o 'Yéna fá yém.' Yau néwaitotati yéfe soramé yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ménamén Ároene Ambum njam nénangota, méinyotio árém so yéfandat ndenanit toyé kwayaghanit so télálángé witmé njafar kwéndkwéndta kétán witmé njafar kwéndkwénd. ");
INSERT INTO nmx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wénde fronde yémon so tárfár tékrát efande a so yékenat yéné saté ár mérnam. ");
INSERT INTO nmx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ndenaye fété Noane efghon kés tamorwén, ndenéyameyo so yém Ároene Ambumoene efghon. ");
INSERT INTO nmx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Árém njamke a nu tánetawét, amaf ár kaweretawét kétán efogh nawerai Noa nélawai minde ndimbal ngárndot. Féyo táf kéfér nakmai a yérambaryéng méinyotio ár. ");
INSERT INTO nmx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ndenéyameyo tamorwén Lotene efghon. Árém njamke a nu tánetawét, kéufnamotawét rokar, njamke yéghan a méngo raméghan. ");
INSERT INTO nmx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wénde yéné efghon Lotém yéfrangoi Sodom, fés a fésafé wím kénuitawét njafarta nunit kafamndau, a yérambaryéng méinyotio ár. ");
INSERT INTO nmx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ndenéyameyo Ároene Ambumoene efghon so nufrote. ");
INSERT INTO nmx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Yéné efghon efe méngo téndon em yau so kényawangi méngo kénjút rokar résaghét. Ndenéyameyo, efe ndawan em yau so néngangotat rokar résaghét. ");
INSERT INTO nmx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yafarotati Lotene amafǃ ");
INSERT INTO nmx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Emo njam yéta yánjo ghérsé yambeta so yétarne, emo njam yétarna yánjo ghérsé so kawanjarngé. ");
INSERT INTO nmx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yéndon némaufrotan fe, yéné sémbáran sómbio ár so ekmare ámbiro kémégh sifayan, ámb Ngánjánam so téngwanangé ámb so téfrangongé. ");
INSERT INTO nmx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Sómbio amaf so néusénanét njamke mérne, ámb so yémon téngwanangé, ámb so téfrangongé.” ");
INSERT INTO nmx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yémofem yémotayénd, “Ándan, Yuré?” Yesum ewawangoi, “Ánde kér fú yém, ndikáké kété so náumendat.” ");
INSERT INTO nmx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesum tawaufrotau yánjo waitogh árét a rengerenge si ewauyafoi yéfe fá so túmén Ngánjánafé norayat a yau so kékmbongi. ");
INSERT INTO nmx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesu norayai, “Ámb tesenan kété témorwén mwighé farorégh ár efe Ngánján férférofnar témorwén utmanéghofnar árfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kété témorwén ámb kwiré yéné tesen kénjún efe katérnau túmén yáfaf siafé, 'Ta kwaram mbarkánd yéné si éwighmén mék téfnárafé siyénmare.' ");
INSERT INTO nmx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Nák sénko árom yékenai ámb efghot, wénde ambinomén norayai yánjomén, 'Yénd férférofnar wém Ngánjánefaf a utmanéghofnar árfefaf, ");
INSERT INTO nmx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wénde yéné kwiram túmén wawérsote yénd, yéndon so tinjon yáfaf mbarkánd, ménát yau so nénatérne tafaf túménǃ'” ");
INSERT INTO nmx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Féyo Yuré norayai, “Káyárangi kétán némé yéné mbarkándofnar mwighé farorégh ár norayai. ");
INSERT INTO nmx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngánjánam so fété enwarse mbarkánd yánjo waferégh árét, efe nendat yáfaf efogh a sémbár. Yémon yau so túmén ekarote fá. ");
INSERT INTO nmx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yéndon némaufrotan fe, yémon so tinjongé nde yémafém mbarkánd yanangi wékeye. Wénde njam Ároene Ambum nénangota, yémon so tawinjongé efe em ndimbal mwighafé yéné mbandan?” ");
INSERT INTO nmx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesum tawaufrotau yéné rengerenge si ámb ároefaf efe tawewonawét ndené kemnawét ndené yénd yéném mbarkánd ár a fá yau: ");
INSERT INTO nmx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Sómbio ár nuwaneyayénd kétán wáwefnogh méngot Ngánjánafé oraighét, ámb témorwén Farasi ár a ámb témorwén mani kafégh ár. ");
INSERT INTO nmx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasi ár nokayoi Ngánjánafé koraiwét, 'Ngánján, kánjo fe ndené yénd yau wém ndené ámb ár kés em, oro téfnár, yaufi wafrogh ár, amaf wanégh ár, o ndenanit yéné mani kafégh ár kés em. ");
INSERT INTO nmx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yénd nawafarmetan sómbio efogh ámbiro Safatan a yéndon túmén ramégh yam so yafrotam Mosesene nákam noraye Ngánjáneyot.' ");
INSERT INTO nmx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Wénde mani kafégh ár takayongérwén nayu. Fá yau néwewoi ndenáyo njafarot, wénde yánjo kafan nasmai a norayai, 'Ngánján, ghérghérsisé tayot, yénd yaufi ár wém.' ");
INSERT INTO nmx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Yéndon némndetan fém, yéné yaufi ár, yau ndené Farasi ár, fá kangotau méngot áuwéghafé Ngánjánene sáfrére. Fém njam nawarmbota ámb árfefaf, fém so kémeworngi, a fém njam yuwan ném, fém so ném tukén.” ");
INSERT INTO nmx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Árém tanérsawét ambumtértér Yesuefaf ménát frengéghét. Njam waitogh árém yinjoyénd yéné, yémofem ekmboyénd yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wénde Yesum emotai ambumtértér yáfaftio norayai, “Tanumyongi ambumtértér kénaflangi tafaf, yau ekmbotati ambumtértér ménamén Ngánjánene limánégh siyém ndené árét ambumtértér kés em. ");
INSERT INTO nmx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yéndon efalo si ewaufrotan, ámb árom emo yau tanangé Ngánján limánégh ndenanit ambumtértér sem yau so kényawangi.” ");
INSERT INTO nmx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ámb Ju sénko árom yémotai fá, “Mer watamegh ár, némé yéndon so yafrotan tuot ghérsé résaghét?” ");
INSERT INTO nmx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesum yawangoi, “Némamén wémndete yénd mer? Efe yau mer yém fá Ngánjánro. ");
INSERT INTO nmx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Fém mat ném náknák, 'Amafanyo wanégh yau, ár ngi yau, oro yau, unyégh yau, eutmanwé afé a amé.'” ");
INSERT INTO nmx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yémo yémndai, “Kétándmayo yénd tosé kwémorwén, yéndon yéné méinyotio nák tawarawénawén.” ");
INSERT INTO nmx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesum njam náyárai yéné, fá norayai yáfaf, “Fefaf mé náláite ámb yam wafroghét. Etérna maniot fene némé em méinyotio, ewarameta yéfeyot yauyau árét, a fém so ném wemár njafaran. Féyo kénaf, kwénmaito yénd.” ");
INSERT INTO nmx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yémon njam náráyai yéné si, fá nawinjoi ghérghérsisafé ménamén fá témorwén minde wemár ár. ");
INSERT INTO nmx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesum yéfandai a yémndai, “Nderé táikér yém ndené wemár árét Ngánjánene limánégh élaughétǃ ");
INSERT INTO nmx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Taikre kemole élawégh nidul fénemé siyém ndimbal, wénde taikre wemár ároe élaughét Ngánjánene limánéghét yéné yam yáinde.” ");
INSERT INTO nmx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Fá efe náyárayénd yéné ámoghan, “Efe so wét kunjarngé?” ");
INSERT INTO nmx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesum ewawangoi, “Némé táikér yém árét Ngánjáneyot siyém áfrat.” ");
INSERT INTO nmx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Fité norayai yáfaf, “Yéndfem enfrangongém méinyotio téfene némé tam fém némaitongémǃ” ");
INSERT INTO nmx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu norayai yéfefaf, “Yéndon ewaufrotan féfe efaloe, yéndon mat eyátotan méinyotio ár emo efrango méngo, amaf, yanaf, yárefaf, ambumtértér Ngánjánene limánégh téfnan ");
INSERT INTO nmx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","so kor ewinjotati tárfár mbinotmé sénonjo yéné ghérayan, a so akegh ghérsé tinjongi Ngánjáneta soramé yuwon.” ");
INSERT INTO nmx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesum ewasroi 12 waitogh ár téndot a emndai fá, “Yénd kuwanongém kétán Jerusalemét, a méinyotio yéné yéfarotaménd Ngánjánene mat yátogh árém Ároene Ambumoenemén so nufrote. ");
INSERT INTO nmx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Fá so téramangi Téndo árfefaf, a yémofem so si yawafrotat, yasalitat fá, mbérme yéfarndat. ");
INSERT INTO nmx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yémofem so yéfmotat a yésmetat krot. Nambio efogh soramé fá wéikor so kanongé.” ");
INSERT INTO nmx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wénde waitogh ár yau mat náyátoyénd yénémamén. Yénayoene fifi tétnongérwén kétándmé yéfe tambne, a fá yau mat náyátoyénd némémén fá korayau. ");
INSERT INTO nmx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Njamandio Yesum tánetau Jeriko, ghékéf kwéfkwéf ár témorangérwén end téndon kómnendau. ");
INSERT INTO nmx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Njam yémon eyárai ár mérén álighan kawaindawét, fá namotai némé yam nufrote. ");
INSERT INTO nmx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yémofem yaufroyénd yá, “Yesu Najaretmén siyém nawainde.” ");
INSERT INTO nmx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Fá nutnayéng, “Yesu, Deifidene ambum, so ghérghérsisé ném tafafǃ” ");
INSERT INTO nmx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fá efe tangmorwén endmé yarnayénd fá a yémndayénd, “Métar kékmboǃ” Wénde fá yéméindayénd minde keyot, “Deifidene ambum, so ghérghérsisé ném tafafǃ” ");
INSERT INTO nmx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu nékmboi a tamndangé ár yáfaf ménjaghét. Njam nénaflai kaka, Yesum témotangé fá, ");
INSERT INTO nmx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Némé wafroghét ménde ném tafaf?” Yémon yawangoi, “Yuré, yénd ménde wém éreghét.” ");
INSERT INTO nmx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A Yesum yémndai fá, “Féyotaro so kéretaǃ Fenjo ndimbal mwighayam némanjar fém.” ");
INSERT INTO nmx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Táf fété fá ghékéf néretai a yémon yáitoi Yesu, tuwetau Ngánján. Njam méinyotio árém yinjoyénd, yémofem wéi ndenáyo Ngánján tuwetawét. ");
INSERT INTO nmx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu téngmorwén Jerikomé. ");
INSERT INTO nmx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ár yétkwén kété témorwén Jekies, fá témorwén mani kafégh sénko ár efe témorwén wemár. ");
INSERT INTO nmx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Fá ménde témorwén Yesue fandaghét, wénde ndémbndémb ármén yau yinyoyéng ménamén ár mérén kénjún takayongérwén. ");
INSERT INTO nmx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Féyo fá frondeyo nengoi a narmboi ndimbal wénan ndenanit wanj wén Yesue winjoghét, táf Yesu mé téngmorwén yéné endmé. ");
INSERT INTO nmx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Njam Yesu nufaryéng yéné sifayan, Yesu néwewoi tukét a yémndai fá, “Jekies, kénewor wékeye yuwot. Fene méngon sénonjo so wémor.” ");
INSERT INTO nmx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Féyo fá néneworyéng wékeye a Yesu áuwéghafé yumyoi yánjo méngot. ");
INSERT INTO nmx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Méinyotio árém yinjoyénd yéné yam a mikemike nufngoyénd, “Fá néngwanoi wan téfnár náyátoi yaufi ároefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wénde Jekies nokayoi a norayai Yurafaf, “Kéreta, Yuréǃ Sénonjo yénandmé yéndon efalotan néndkéfan tane rokar yauyau árét, a yénd njam té kuindan árfefaf rokarmén, so ewangotan yéfene fai fo mbinotma.” ");
INSERT INTO nmx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu norayai yáfaf, “Sénonjo wanjarégh yém yéné méngot, ménamén yéné ár siyém Ebraamene ákimén. ");
INSERT INTO nmx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ménamén Ároene Ambum yénmormén ronjaghét olingégh ár wanjarghét.” ");
INSERT INTO nmx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Njam fá káyáretawét yénémamén, yémon tawawaitotau rengerenge si ménamén fá témorwén Jerusalem kaka a ár kemnawét ndenénde Ngánjánene limánégh kar sélngwéle so kufarngai. ");
INSERT INTO nmx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Fá norayai, “Ámb sénko ár nuwanoi nayu yuwot ménát fáyo náyátoi warsagh ár a so wéi nénangote. ");
INSERT INTO nmx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Féyo yémon emotai ten faiofnar ásáfogh ár a yéfeyot ewarametam ámb rérero ndimbal mani. Fá norayai, 'Takmangi yéné mani ásáfoghét kétánotio yénd nénangotan.' ");
INSERT INTO nmx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Wénde yánjo árém méndméndat tafandawét a ewáfáretam fénaté ásáfogh mérén soramé fá norayayénd, 'Yénd méndefnar yéném yéné ár sái kamndangé téfene warsagh ár.' ");
INSERT INTO nmx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Fá náyátoi warsagh ár féyo fá nénangotam méngotuot. Féyo yémon ewáfáretam faiofnar ásáfogh ár kétán endefet mani ewarametam ménát matot njénamb mani ewafrotaménd. ");
INSERT INTO nmx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Fronde ámbiro ár yénmormén a norayai, 'Yuré, fene maniam té efuna ámb ten.' ");
INSERT INTO nmx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Yáne yuram yawangoi, 'Mer yém. Tane mer faiofnar ásáfogh árǃ Ménamén fém té efalo náyáto némbne mani funaghan, fémon so ewanjete ten ndimbal tesen.' ");
INSERT INTO nmx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Sómbiomén yénmormén a norayai, 'Yuré, fene maniam té efuna ámb 5.' ");
INSERT INTO nmx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Yáne yuram yawangoi, 'Fémon so ewanjete 5 ndimbal tesen.' ");
INSERT INTO nmx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nambiomén faiofnar ásáfogh ár yénmormén a norayai, 'Yuré, fene mani siyém. Yéndon fene mani tamndan a etnoyén sáláme sutafé. ");
INSERT INTO nmx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yénd fenemén férfér kwémorwén ménamén fém ném táikér ár. Fémon totér némé yau yélawai a yétane némé yau yiyáyéng.' ");
INSERT INTO nmx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Yánjo yuram yawangoi, 'Yéndon so kémawitérmbon fe fenjo sieyo, fém yaufi faiofnar ásáfogh árǃ Fém mat ném ndené yénd wém táikér ár a yéndon ewangotan árkéméné yau em tane a etanan yéné árkéméné yéndon yau eitamén. ");
INSERT INTO nmx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Némamén wét tane mani yau yélawai mani funagh sifayan ménát yénd njam nénangotan, yéndon so tinjongén minaghkaf?' ");
INSERT INTO nmx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Féyo yémon fá emndai efe tawakayongérwén kaka, 'Takawangi yáne mani yá tambén a taramangi yá efe ten maniafé yém.' ");
INSERT INTO nmx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Fá norayayénd, 'Yuré, té náyátongi ten mani yáneǃ' ");
INSERT INTO nmx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Yémon tawangongé, 'Yéndon némndetan ndenáye méinyotio endene tárfár em, yá so taramangi tárfár, wénde endene yau em, so takawangi. ");
INSERT INTO nmx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wénde tane mék téfnár efe em méndefnar fá em yénd sái wém yéfene warsagh ár, tanwasrongi a tásmetangi tane sáfrére.'” ");
INSERT INTO nmx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yéné si soramé Yesu téngmorwén frondeyo Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Njam kaka náyátoi Betefes a Betani mband tunakéf yu yétkwén olifén, yémon ewáfáretangeyai yánjo sómbio waitogh ár, emndeyai fá, ");
INSERT INTO nmx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kuwanend méngotuot fronde, njam kélawend, so tinjend ndonki rényéghkaf, efe yau yéfayongérmén. Ténferend a yénémnjét yénan. ");
INSERT INTO nmx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ámb árom njam tamotangé, 'Némat fémofem yéferét?' taufrend yá, 'Yuré ménde yém.'” ");
INSERT INTO nmx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yéné efe ewafareméng nuwaneyayénd a yinjeyayénd ndernáye té engémndeyai fá. ");
INSERT INTO nmx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Njamandio yémofem téferwét ndonki, yéné yuram emotangeyai fá, “Némamén fémofem yéferét ndonki?” ");
INSERT INTO nmx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yémofem yawangeyayénd, “Yurane ménde yém.” ");
INSERT INTO nmx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yémofem yénémnjeménd Yesuefaf, yéfenjo sáláme efayeyayénd ndonkiyan a Yesu nafayoi yéné tukén. ");
INSERT INTO nmx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Njamandio Yesu téngmorwén, árém yéfenjo sáláme tangéfyangotawét endmé. ");
INSERT INTO nmx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Fá njam téngmorwén kaka néngamndai yéné sifayan ánde end ngewonau Olif Mband tunakfot, méinyotio Yesuene waitogh ár nufngoyénd wagh áuwéghafé Ngánjánefaf marat kéme, téfén ménamén sélngwélafé ásáfogh téfandawét Yesuefaf: ");
INSERT INTO nmx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Frengégh ném warsagh ár efe néném Yurane yétkwénanǃ Krufrat njafar tukén a ndimbal kwayaghé minde tukén!” ");
INSERT INTO nmx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ámb Farasi ár kénjún norayayénd Yesuefaf, “Watamegh ár, táwárna fene waitogh árǃ” ");
INSERT INTO nmx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yémon ewawangoi, “Yéndon emndetan fém, njam fá métar ekmbo, wím so nutnatǃ” ");
INSERT INTO nmx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Njam Yesu kaka ufarghétro témorwén Jerusalemét, yéngwinjoi yéné tesen, Yesu táf ye nufngoi yénémamén ");
INSERT INTO nmx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a norayai, “Jerusalemén ár, yénd ménde wém fém mat kamndangi sénonjo némé yam krufrát yénérse féfefaf, wénde yau mat em. Ménamén ténoghe yém kétándmé féfene ghékéfta. ");
INSERT INTO nmx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Efogh yéna eném féfeyot njam féfene mék téfnáram so tawarendangi fém a tawanawangi féfe méinyotio téndomé. ");
INSERT INTO nmx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yémofem so tawalindangi fém kétán mbandot, fém a ambumtértér fene sifayan. Yémofem ámb yau so taurongi wím kwéndkwéndan yaufifi, ménamén fémofem yau yáyamngongi Ngánjánene wanjarégh féfeyot.” ");
INSERT INTO nmx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Féyo Yesu nélawai wáwefnogh méngo sifayan a wifarégh ewafngoi emofem rokar téwáfnamotawét. ");
INSERT INTO nmx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Fá norayai yéfefaf, “Buk sian yékai, 'Tane méngo so yém Ngánjánafé orayégh méngo,' wénde fémofem yiyátongi oro téfnárafene átnogh yékw.” ");
INSERT INTO nmx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Méinyotio efghon fá témorwén watameghan wáwefnogh méngon. Wénde limánégh ghéngén wárogh ár, nák watamegh ár a limánégh ár ménde tamorwén Yesue ngiot. ");
INSERT INTO nmx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wénde yémofem yau end ewinjoyénd yá ngiot, ménamén méinyotio árfene mwighé tarnyangérwén yáne sifaf. ");
INSERT INTO nmx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ámb efghon yémon njam tawatametau ár wáwefnogh méngo sifayan a táitotau mer si, limánégh ghéngén wárogh ár a nák watamegh ár nafghayénd yémafe ámb sénko árfé, enmormén yáfaf. ");
INSERT INTO nmx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yémofem norayayénd, “Ténmaufro némé muyaye fémon ewafrote yéné ásáfogh. Emon fe yéné muyé némaramai?” ");
INSERT INTO nmx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yémon ewawangoi, “Yéndon so ndenéyameyo fém témotangén ámogh si. Ta kwaufrongi, ");
INSERT INTO nmx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","'Jonene walitogh yénmormén njafarta o árta?'” ");
INSERT INTO nmx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yémofem táruindawét yéfe kénjúnro a korayawét nde, “Njam yénd korayangém 'Kétándmé njafarta,' fá so kamotangé, 'Némamén yau wét fá efalo yiyátongi?' ");
INSERT INTO nmx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wénde njam yénd korayangém, 'Kétándmé árta,' méinyotio árém so yénamndat yénd wíme ménamén fá em mat nde Jon témorwén Ngánjánene mat yátogh ár.” ");
INSERT INTO nmx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Féyo yémofem yawangoyénd, “Yénd mafina yéném fá árkémamén yém.” ");
INSERT INTO nmx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu norayai, “Yéndon wét yau so tawaufron féfe némé muyaye yéndon ewafrotan yéné ásáfogh.” ");
INSERT INTO nmx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Fá téngmorwén tawawaitotau árét rengerenge si, “Árém yeitam géreif mbwe ménj ndawan, noroi faiofnar ásáfogh árfefaf a nuwanoi teke. ");
INSERT INTO nmx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wau yuwon yémon yáfaretam faiofnar ásáfogh ár kétán ndau wanjengégh árfefaf ménát yémofem so téramangi yáyot ámb géreif mbwe ménj mbwe yéné ndaumén, wénde wanjengégh árém tésmetawét fá a yátembayénd firo rokarofnar. ");
INSERT INTO nmx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yémon yáfáretam yénamayo faiofnar ásáfogh ár, wénde yéné árém ndenéyameyo tésmetawét, mámé wáiwáiafé yátembayénd firo rokarofnar. ");
INSERT INTO nmx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yémon yáfáretam nambiomén a tésmetawét férkafé yitaménd fá. ");
INSERT INTO nmx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Géreif mbwe ménj ndau yuré norayai, 'Yéndon némé so yafrotan? Yéndon so yéngwáfáretan tane ambum efe yéndon yuwetan. Efalo yiyátoi yémofem so yutémndat.' ");
INSERT INTO nmx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Wénde njam ndau wanjengégh árém yinjoyénd fá, yémofem korayawét yéfenjo kénjúnro, 'Yéné siyém ndau yurane ambum yém. Wét yésmetam krotio fá, a ndau rokar so kénamndangi téfene.' ");
INSERT INTO nmx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Féyo yémofem yitaménd géreif mbwe ménj ndau kénjúta a yesmayénd krotio fá. “Némé so yafrote géreif mbwe ménj ndau yuram yéfefaf? ");
INSERT INTO nmx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Fá so yéném a engésmete krotio yéné ár mérén a tawaramangé géreif mbwe ménj ndau ámb árét.” Njam árém náyárayénd yénémamen, fá norayayénd, “Yénandmé yaufifi so yémǃ” ");
INSERT INTO nmx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu néngretai yéfefaf mbarkándaye a emotai, “Féyo némé fifi yéné yém árkéméné yéfarotaménd, 'Sérasér árké méngo ramégh téfnáram yékenayénd a namndayéng néndkéf sérasér.' ");
INSERT INTO nmx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Méinyotio ár efe njam nénuitat wíman so karéfkaréf nufrotat, a njam kénuyangé árfefaf fá so tásénangé.” ");
INSERT INTO nmx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nák watamegh ár a limánégh ghéngén wárogh ár end táronjawét werghét wékeye, ménamén fá mat náyátoyénd nde fá korayau yéné rengerenge si yéfenemén. Wénde fá férfér tamorwén árfenemén. ");
INSERT INTO nmx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yémofem ghékéf tafayotawét yáyot, a ewáfáretaménd ufénmanégh téfnár efe mermer kuindawét. Fá yéta kemnawét Yesue werghét ménát ámb si so korayangai, ménát yémofem so tramangayénd gafanafaf. ");
INSERT INTO nmx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ufénmanégh téfnáram yémotayénd fá, “Watamegh ár, yénd mat yéném ndené fém noraye a ewatamete némé mbarkánd yém a fém yau namnyote árfene mwighafaf, wénde ewatamete Ngánjánene ende efaloyero. ");
INSERT INTO nmx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Téfeyot mbarkánd yém mani sái ekmetam Kaisare o yau?” ");
INSERT INTO nmx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesum ewawinjoi yéfene unyégh a norayayéng yéfefaf, ");
INSERT INTO nmx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kwauyafongi yáne mani. Endene ár sáf a yétkwén ekayong?” Yémofem yawangoyénd, “Kaisarene.” ");
INSERT INTO nmx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesum emndai, “Taramangi Kaisare yáne némé yém, a Ngánjáne taramangi némé yém yáne.” ");
INSERT INTO nmx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fá endofnar namndayénd Yesue werghét némé yaufimén korayau kété árfene sáfrére. Sélngwél emormén yáne uwangoghan, a fá métar namndayénd. ");
INSERT INTO nmx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ámb Saduki ár enmormén efe norayayénd ndené kété ámb yau anogh yém. Fá enmormén Yesuefaf moghét. ");
INSERT INTO nmx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Fá norayayénd, “Watamegh ár, Mosesém yéfarotam nák téfeyot ndené njam yánngénoene yané kér yém tatembangé amaf wénde ambumofnar, yánngnom fété so kwiré tékayongé a ambum eunjeta yanai. ");
INSERT INTO nmx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kété tamorwén sefen ghakér ambum. Fronde sénkom nawerai a kér yémormén ambumofnar. ");
INSERT INTO nmx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yénamayom kwiré nawerai, wénde fá ndenéyameyo kér yémormén, yéfrangoyéng ambumofnar. ");
INSERT INTO nmx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A nambiomén nawerai kwiré, ndenéyamanro sefen kér emormén, yéfrangoyéng ambumofnar. ");
INSERT INTO nmx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Soramayo amaf kér yémormén. ");
INSERT INTO nmx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Anogh efghon endene amaf so yém? Ménamén yéné sefenam té naweretaménd.” ");
INSERT INTO nmx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesum ewawangoi yéfe, “Árém amaf so fété naweretat yéné mbandan. ");
INSERT INTO nmx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wénde soramé efghon, fá efe so tawanongé kérta yau so nawerétat. ");
INSERT INTO nmx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A fá yau kér so em. Fá so ndené kamndangi njafar si résagh árnit. Fá so em Ngánjánene ambumtértér ménamén Ngánjánam so tawanongé kérta. ");
INSERT INTO nmx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wénde Mosesém njam yufarotaméng kéghat fés awároghan, yémon yuyafoi ndené kér so nanotat ghérsat. Yémon témotau Yuré 'Ebraamene Ngánján, Aisekene Ngánján a Jeikofene Ngánján.' ");
INSERT INTO nmx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Fá yau yém kér árfene Ngánján, wénde ghérsé árfene Ngánján, ménamén fá méinyotio ghérsé em yáfaf.” ");
INSERT INTO nmx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ámb nák watamegh ár namnyoyénd, “Mer norayayénd, watamegh árǃ” ");
INSERT INTO nmx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A árém yau yémotayénd fá ámb ámogh si kor. ");
INSERT INTO nmx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesum emotai fá, “Némamén ndené árém norayat nde Keriso yém Deifidene ambum? ");
INSERT INTO nmx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Deifid fáyo safén nakmai Sams bukan a norayai, 'Yuré noyarai kétán tane Yurafaf: “Kámnjo yénandmé tane tambén ngángata. ");
INSERT INTO nmx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kétánotio yéndon tákman fene mék téfnár fene kafkaf mbanmbanan.”' ");
INSERT INTO nmx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Deifidém tanmotau fá 'Yuré.' Ndernáye fá yáne ambum so yém?” ");
INSERT INTO nmx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Njamandio méinyotio árém tiyáretawét, Yesum emndai yánjo waitogh ár, ");
INSERT INTO nmx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kor nawarawenati nák watamegh árfenemén. Fá ménde em tombé sálámefé arengét a sái eutémndat térarégh sifayan, a yéfene mwighé témorwén minde mer sifayan ámnjoghét áumengégh méngo kénjún a yémofem méndefé tafandawét limánégh ámnjogh sifayé témndan. ");
INSERT INTO nmx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yémofem unyéghe kwirafene rokar tawarsawét a fá mermer kuindawét tombé sie Ngánjánafé orayégh ár sáfan. Ndené árém tékrát so yérsat minde tukén.” ");
INSERT INTO nmx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Njamandio Yesu néngretai, yémon ewinjoi wemár árém takmetawét ramégh rokar wáwefnogh méngon. ");
INSERT INTO nmx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yémon yinjoi yauyau kwiré sómbio némbne mani mbwe kémghan. ");
INSERT INTO nmx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yémon emndai, “Yéndon efalo ewaufrotan, yéné yauyau kwiram ewaindai fá emofem mani takmetawét. ");
INSERT INTO nmx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Méinyotio yéné árém takmetawét némbnare tárfár rokarta, wénde kwiram ekmeyai méinyotio yánjo ghérsé ámnjoghmén.” ");
INSERT INTO nmx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ámb yáne waitogh ár tamorwén sian ménamén ndernáye wáwefnogh méngo yamanetaménd mer wíme a ramégh yam wateghkaf Ngánjáne. Wénde Yesu norayai, ");
INSERT INTO nmx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Méinyotio fémo némé yéfande yéna, efogh yéna yéném ánde ámbiro wím yau so kafrangongé kétándmé ámbta, méinyotio so ewite yuwot.” ");
INSERT INTO nmx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Fá namotayénd, “Watamegh ár, njam so yéné yam nufrotat? A némé yamam so tufarotangé ménát yéné yam ufroghétro em?” ");
INSERT INTO nmx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yémon ewawangoi, “Kor fété aem fém warsoghmén. Mwighé sénté ménamén tárfár ár so eném tane yétkwénan, ndené siafé, 'Yénd wém Yesu,' a 'Efogh siyém kaka yém.' Yau ewaitotati fá. ");
INSERT INTO nmx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Njam fém náyáretati mékmén a sélngwélafé yammén, yau táf férfér em. Yéné yam fété so nufrotat frondeyo, wénde mbandoene yátogh yau mé so yéném.” ");
INSERT INTO nmx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Féyo fá norayai yéfefaf, “Ámb yu a ámb yu, fá so násmét, ámb ndimbal yu a ámb ndimbal yu, fá so násmét. ");
INSERT INTO nmx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kété so yém ndimbal sokrere, káukáu, ndimbal enjne tárfár yuwomé a férférafé yam a ndimbal sélngwélafé yam njafaran. ");
INSERT INTO nmx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Wénde yémofem so kémerangi a kértayan kénékmangi fém soramé yéné yam so nufrotat. Fém so némumbetat áumengégh méngon a kémarmbnangi kwéfkwéf méngot, a néngemnjat warsagh ár a gafanafene sáfrére tane yétkwén téfnan. ");
INSERT INTO nmx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Wénde yéné so fiyém efoghféneféne si waitoghét fene ndimbal mwighamén. ");
INSERT INTO nmx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wénde fém mwighayam yau némaworsota frondeyo ndernáye fém so nawamarote fémyo. ");
INSERT INTO nmx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yéndo so kémaramangén si a káfeté mwighé ménát fene mék téfnáram yau so kémitrombongé o kénémndangé fém ném unyégh ár. ");
INSERT INTO nmx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Fém so sén erametat afafemyo, amafemyo, anafemyo, mérnamyo, fútaramyo a yémofem fém so ámb krot ekmetat. ");
INSERT INTO nmx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Méinyotio árém fém so méndméndat efandat ménamén tanemén. ");
INSERT INTO nmx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Wénde fene ámbiro sénko séf yau so kolindangé. ");
INSERT INTO nmx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Fém so taikrataye ewakai ménát fémo so tinjo efalo ghérsé. ");
INSERT INTO nmx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Fémofem njam Jerusalem tinjongi fiyaré warengéghkaf em táf fém so mat káyátongi nde yáne wasérmbogh siyém kaka yém. ");
INSERT INTO nmx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mat táyátongi efe Judiamén ár em táf kangongi kétán mband tunakfot, efe tesenan em táf kétorngi, efe em tesen sémta yau kélawangi tesenot. ");
INSERT INTO nmx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yéné efogh fifiyafé náyátoi árké tékrátmén yéfarotaménd. ");
INSERT INTO nmx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nderé mámáfi so yém suafé amafafet yéné efogh a mbrake amafafetǃ Kété so yém ndimbal tékrát yéné mbandan a nékw yéné árfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Fá so enfetat naifaye krotio a ámb so eweretat kwéfkwéf méngo árot méinyotio ndimbal yuwot. Jerusalem so yésénat Téndo árém kétánotio Téndo árfene efogh ufroghfaf. ");
INSERT INTO nmx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kété sélngwélafé yam so em efghan, ghérareyan a kéndafefaf. Mband tukén, méinyotio ndimbal yuwomé so yém mwighé ndémke a uwérsoghan ménamén arakaf sóf su kemén. ");
INSERT INTO nmx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ár férfére so nuitat, ménamén kérté némé yéném yéné mbandot, njafarmén fifi so násámbnetat. ");
INSERT INTO nmx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yéné efghon yémofem so tinjongi Ároene Ambum angoghan njafar kwamkwaman ménáyafé waftafé a ndimbal kwayaghafé. ");
INSERT INTO nmx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Njam yéné yam ufrogh kufngongi, kokayongi a tauyongi féfene sénko, ménamén féfene wanjarégh siyém kaka yém.” ");
INSERT INTO nmx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yémon tawaufrotau yéné rengerenge si, “Téfandangi fig wén a méinyotio wén. ");
INSERT INTO nmx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Njam wén mbambam éwiwogh kufngongi, fémofem so tinjongi féfendio a mat kamndangi nde efogh yu siyém kaka yém. ");
INSERT INTO nmx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yéné endeyo, njam yefandati yéné yam ufroghan, fém mat so kamndangi nde Ngánjánene limánégh siyém kaka yém. ");
INSERT INTO nmx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Yéndon ewaufrotan féfe efalo si, ámb ár mérén yéné satamén so mé em ghérsé njam méinyotio yam nufrotat. ");
INSERT INTO nmx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Njafar a mband so kawaindangend, wénde tane si yaufifi so kawaindangé. ");
INSERT INTO nmx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kor nawarawenati, féfenjo tikéf yau ewaghnati wéri nuye, wagh témnde a mbandoene méghméghe ménamén yéné efgham so táf kémerangé sunsune ndenanit urérnit. ");
INSERT INTO nmx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ménamén yéné efogh so yéném méinyotio yéfefaf efe emor yéné mbandan. ");
INSERT INTO nmx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aya túmén ghékéf sénté aem néretati a Ngánjánafé orayégh ménát fém so kawanjarngi kétándmé némé ufroghét em, a fém so taikrataye ewakai Ároene Ambum sáfrére.” ");
INSERT INTO nmx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Méinyotio efghon Yesu témorwén watameghan wáwefnogh méngon, a fá tangmorwén méinyotio sémbáran Olif Mband tunakfan. ");
INSERT INTO nmx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Méinyotio ár tanmorwén túmén tándái akwan áyárghét yáfaf wáwefnogh méngot. ");
INSERT INTO nmx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Minaghofnar flawamén téménd, yétkwén Waingégh téménd kaka kénamndetau. ");
INSERT INTO nmx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Limánégh ghéngén wárogh ár a nák watamegh árém ámb end táronjawét Yesue werghét, ménamén fá férfér tamorwén árfenemén. ");
INSERT INTO nmx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Féyo Sáifér nélawai Judas Iskariotefaf, efe ámbiro nafaloi 12 ármén. ");
INSERT INTO nmx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","A Judas téngmorwén kétán limánégh ghéngén wárogh árfefaf a wáwefnogh méngo wanjengégh árfefaf a taruindawét yémafé ndernáye yémon so sén téramangai Yesu. ");
INSERT INTO nmx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Fá káuwétawét a nuwangoyénd mani ramghét yáyot. ");
INSERT INTO nmx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas nuwangoi a kéretau end táronjau Yesue werghét árofnar sifayan. ");
INSERT INTO nmx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Efogh nawerai Minaghofnaye flawamén árké yém Waingégh sif tosane ghéngénmén. ");
INSERT INTO nmx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesum ewafareméng Fité a Jon a norayai, “Kuwanend yéfrengéghét Waingégh njamke téfe nénet.” ");
INSERT INTO nmx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yémofem yémotangeyayénd, “Ándan fene ménde yém téfeyot frengéghét?” ");
INSERT INTO nmx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesum ewawangeyai, “Njam ngélawend tesenot, ár so tinjend nu séfkwénafé yémon so tafange. Fémofem téngwaitend árké méngot njam ngélawangé, ");
INSERT INTO nmx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","a témndend méngo yuré, 'Watamegh árém namote, “Ánde yém wan téfnároene méngo saté, ánde yéndon so enetan Waingégh njamke tane waitogh árfé?”' ");
INSERT INTO nmx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yémon so tawauyafé féfe ndimbal méngo saté tukén, méinyotio teghkaf yém. Afrengégh kété ayém.” ");
INSERT INTO nmx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Fá néwaneyayénd rokar ewinjeyayénd ndenáye fété Yesum ndernáye tamndéwéng. Féyo yémofem yéfrengéménd Waingégh njamke. ");
INSERT INTO nmx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Njam efoghféneféne nawerai, Yesu a yánjo muyafé ár nénámnjoyénd njamke sifayan. ");
INSERT INTO nmx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A Yesum emndai fá, “Yénd minde ménde kwém njamke nénet fémafé soramé tékrát so yéfandan. ");
INSERT INTO nmx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yéndon ewaufrotan féfe, yéndon yau so enetan wéikor kétánotio yéné nufrota Ngánjánene limánéghan.” ");
INSERT INTO nmx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Soramé kafusi yerai, yémon kánjo yaramai a norayai, “Tawanangi yéné a tafalotangi féfene kénjúnro. ");
INSERT INTO nmx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yéndon ewaufrotan féfe yéndon yau so yéfértan wéri nu kor kétánotio Ngánjánene limánégh kénufarngé.” ");
INSERT INTO nmx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yémon féskaf flawé yerai, kánjo yaramai a etfoi, a ewaramai, yéné siafé, “Yéné siyém tane fifi, árkéméné so téraman féfeyot. Yéné yafrotati awafaroghét tanemén.” ");
INSERT INTO nmx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ndené endeyo, njamke soramé yémon yerai kafusi, ndené siafé, “Yéné kafusi siyém totér rényégh tane férék kénjún árké so nasune féfeyot. ");
INSERT INTO nmx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wénde yéné ár emo yénd so sén wéramuete siyém yéna yéndfé yénmorare. ");
INSERT INTO nmx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ároene Ambum so kér yém Ngánjánene méndeyan, wénde nderé mámáfi yém yéné ároe emo sén yéramete.” ");
INSERT INTO nmx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Fá ámogh nufngoyénd yéfenjo kénjúnro efe yéna yafnyang téfefaf emon so sén yéramete. ");
INSERT INTO nmx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Féyo éwigh nufngoyénd yéfenjo kénjúnro efe so yém ndimbal. ");
INSERT INTO nmx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu norayai yéfefaf, “Téndo árfene warsagh ár yuré kamndangi waftafé yéfenjo ár limánghét, wénde fá emndetat, 'Fútar em árfene.' ");
INSERT INTO nmx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wénde fém yau so ndené em. Wénde efe ndimbal yém so yém ndenanit ambumtosé, a efe limánégh ár yém fá so yém ndenanit faiofnar ásáfogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Efe yém ndimbal, yéné ár efe yémor kitarayan o yéné ár efe faiofnar ásáfogh ár yém? Yéné ár efe yémor kitarayan. Wénde yénd wáféin féfefaf faiofnar ásáfogh ár. ");
INSERT INTO nmx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Fém fá em efe tanwakai tafaf tane ufoghan. ");
INSERT INTO nmx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","A Yéndon ewaraman féfe wafté Ngánjánene limánghét ndené fété tane Afam wafté waramai ta, ");
INSERT INTO nmx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ménát fémofem so enetati njamke a nu tane kitarayan Ngánjánene limánéghan, a so emorang limánégh ámnjogh sifayan, Israilmén 12 ár mérén moghan so ewakai. ");
INSERT INTO nmx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yémon yémndai, “Saimon, Saimon, Ngánjánam muyé yaramai Sáifére fe ufoghét ndenanit ndau téfnáram yafrote witrémboghét kétándmé mer mbweta yaufiot. ");
INSERT INTO nmx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wénde yénd Ngánjánafé koraiwam feyot, Saimon, nde fene ndimbal mwighé yau so kuyangé. Fém njam kénawengo tafaf, fémon so muyafé eyátote fengénéf.” ");
INSERT INTO nmx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Wénde yémon yawangoi, “Yuré, yénd afrengéghkaf wém fémafé álighét kwéfkwéf sifayat a kétán krot.” ");
INSERT INTO nmx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesum yawangoi, “Yéndon némndetan fém, Fité, fémon so kwékena nambinotmé nde fém mafina ném tanemén soramé ghakér kowi kutnangé sénonjo.” ");
INSERT INTO nmx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Féyo Yesum emotai fá, “Yéndon njam ewáfáretan fém mani yáfofnaye, awogh yáfofnaye o sandolofnaye, némé rokar ámb náláite?” Yémofem yawangoyénd, “Yau.” ");
INSERT INTO nmx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yémon emndai fá, “Wénde táf sénonjo mani yáf tanangi a awogh yáf tawanangi, a njam yau ewam féfene náifé, sálámeyafé tétérnangi ámbiro náifat. ");
INSERT INTO nmx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Buk si yékai, 'A fá témorwén waféghkaf yaufi árfe kénjún.' Yéndon ewaufrotan féfeyot nde yéné yam efalo so nufrote tafaf. Néméwét, némé yéfarotaménd tanemén so efalo nufrote.” ");
INSERT INTO nmx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Waitogh ár norayayénd, “Téfanda, Yuré, sómbio náifé sere.” Yémon ewawangoi, “Féyotaro ere.” ");
INSERT INTO nmx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu tiotau túmén mband tunakéf yétkwén Olif, a yánjo waitogh árém yénamayo táitotawét fá. ");
INSERT INTO nmx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Njam nufaryénd yéné sifayan, yémon emndai fá, “Ngánjánafé norayatati ménát fém yau so kuyangi ufoghan.” ");
INSERT INTO nmx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Fá nitroi nayuofnaye yéfetambén a budme niyai Ngánjánafé oraighét, ");
INSERT INTO nmx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Afé, fene ménde téu yém, yéné tékrát titro ta tambén, tane ménde yau, wénde fene méndero so nufrote.” ");
INSERT INTO nmx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Njafar si résagh ár nufaryéng yáfaf a yáutánam fá. ");
INSERT INTO nmx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesum ndimbal tékrát yáyárai, fá minde tikfe Ngánjánafé koraiwét a yáne mélmél témorwén ndenanit férék njélkéfnit kasunau mbandot. ");
INSERT INTO nmx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Njam fá nokayoi Ngánjánafé orayéghta fá néngangoi yánjo waitogh árfefaf, yémon ewinjoi kémghan, yongnai ghérghérsisamén. ");
INSERT INTO nmx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesum emotai fá, “Némamén fém kémégh ekém? Kanongi a Ngánjánafé norayati ménát fém yau so ufogham tawutfongé.” ");
INSERT INTO nmx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Njamandio Yesu mé sian témorwén, ár mérén enmormén a ár yétkwén Judas efe témorwén 12 waitogh ármén, yémon tanlimndau fá. Yémon yánetai Yesu a yésnetai. ");
INSERT INTO nmx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wénde Yesum yémotayéng fá, “Judas, fémon sénot yafngo Ároene Ambum ménaye séneghé?” ");
INSERT INTO nmx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Njam Yesuene waitogh árém yinjoyénd némé ufroghétro témorwén, fá norayayénd, “Yuré, wét yéndfem so enfetam téfenjo naifaye?” ");
INSERT INTO nmx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A ámb árom yanfai limánégh ghéngén wárogh ároene faiofnar ásáfogh ároene tambén téngan. ");
INSERT INTO nmx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wénde Yesu norayai, “Yéné yau yafrotatiǃ” A Yesum yéné ároene téngan yayanjai a mer yiyátoi fá. ");
INSERT INTO nmx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Féyo Yesu norayai limánégh ghéngén wárogh árfefaf, wáwefnogh méngo wanjengégh ár a sénko ár, efe té enmormén yáyot, “Némé yénd áyárghofnar árfene sénko ár wém? Árkémamén fém taném naifayafé a timayafé? ");
INSERT INTO nmx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Méinyotio efghon yénd fémafé ténmorwén wáwefnogh méngon, fémofem yénd yau kwéfandawét nékwafé. Wénde sénonjo féfene efogh té nawer, njamandio kwéfkwéfoene wafté féfefaf yém.” ");
INSERT INTO nmx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yémofem yerayénd Yesu, yéngémnjoyénd kétán limánégh ghéngén wárogh ároene méngot. Fitam tangwaitotau nayu kéráye. ");
INSERT INTO nmx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A njam yémofem fés yuwaroyénd mogh sifayé néndkéfan a fá námnjoyénd mérne, Fité wéi námnjoi yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ásáfogh mérsom yinjoi fá fés kwayaghayan témorangérwén. Mérsom yáyamngoi fá a yémndai, “Yéné ár ámb fiyém Yesue waitogh ár.” ");
INSERT INTO nmx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wénde yémon yanyotayéng a yémndai, “Mérés, yénd mafina wém fá.” ");
INSERT INTO nmx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tekofnaye ámb árom wéi yinjoi fáyo a yémndai, “Fém ámb yéné fékéném.” Yémon yawangoi, “Ár, yénd yauǃ” ");
INSERT INTO nmx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ámbiro efoghféneféne soramé ámb árom ménjtaye korayawét ndené, “Fá fété yém Yesue kaka ár, efe yém Galili yumén.” ");
INSERT INTO nmx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Fitam yawangoi, “Ár, yénd mafina wém fém némamén norayeǃ” Njamandio korayau, ghakér kowi táf nutnayéng. ");
INSERT INTO nmx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yuré nawengoi téfandangé Fité. Fité nawafarotayéng Yurane si ndernáye yénémndai fá, “Fémon so kwékenang yénd nambinotmé soramé ghakér kowi so kutnangé sénonjo.” ");
INSERT INTO nmx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A fá nétoryéng sáfét ndimbal ye nendam. ");
INSERT INTO nmx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Árém emofem Yesu tanjetawét si tawafrotawét a ngi yafngoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yémofem ghékéf yawamoyénd a témndetawét, “Koraya! Emon nésém fém?” ");
INSERT INTO nmx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A yémofem korayawét tárfár yaufi si yáfaf. ");
INSERT INTO nmx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Fauréghan árfene sénko ár náumendayénd limánégh ghéngén wárogh ár a nák watamegh ár a yéfene sáfrére Yesu yéngémnjoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Fá norayayénd, “Fém njam Keriso ném, téfe ténmaufro.” Yesum ewawangoi, “Yéndon njam tawaufron féfe, fémofem yau so yénd efalo kwiyátongi, ");
INSERT INTO nmx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","a yéndon njam fém tamotangén, fémofem yau so ta kwawangongi. ");
INSERT INTO nmx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wénde sénonjo yénandmé Ároene Ambum so kámnjongé Minde waftafé Ngánjánene tambén téndon.” ");
INSERT INTO nmx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Fá méinyotio namotayénd, “Fém fété ném Ngánjánene ambum?” Yémon ewawangoi, “Fém sian mbarkánd em fété yénd wém.” ");
INSERT INTO nmx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Féyo yémofem norayayénd, “Yéndfem némé si so yéronjam ndenayu? Yéndfem téfendio té náyárangém yá tambén.” ");
INSERT INTO nmx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Méinyotio árém Yesu yénémnjoyénd Failetefaf. ");
INSERT INTO nmx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yémofem Yesu usérmbogh yafngoyénd yéné sie, “Yéné árom ewarsote téfene ár yéné sie, 'Yau ekmetati mani Kaisarefaf, Rom tuk warsagh ároefaf a yéné yétkwénan nawarse nde yénd wém Keriso, warsagh ár.'” ");
INSERT INTO nmx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Féyo Failetém yémotayéng Yesu, “Fém fété ném Ju árfene warsagh ár?” Yesum yawangoi, “A, fém némé noraye.” ");
INSERT INTO nmx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Failetém marataye korayau limánégh ghéngén wárogh árfefaf a ár mérénafefaf, “Yéndon némé mámáfi yau yinjon yéné ároefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wénde fá ménjtaye korayawét, “Yémon kértat taméinde ár méinyotio Judiamén yáne watameghe, kétándmé Galili yu a yénanotio Jerusalemǃ” ");
INSERT INTO nmx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Njam Failetém náyárai yénémamén, fá namotai, “Yéné ár Galili yumén yém?” ");
INSERT INTO nmx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Njam fá mat náyátoi nde Yesu témorwén Erodene limánégh mbanmbanan, Failetém yáfáretam Erodefaf, efe témorwén Jerusalemén yéné efghon. ");
INSERT INTO nmx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Njam Erodém Yesu yinjoyéng, fá ndimbal áuwégh káuwetau ménamén fá teke kawanjetau Yesue winjoghét. Kétándmé Erodém némé té káyáretau yánemén, fá ménde témorwén ámb sélngwélafé yam fandaghét. ");
INSERT INTO nmx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Erodém tárfár ámogh si tarametau, wénde Yesum yau yawangoi. ");
INSERT INTO nmx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Limánégh ghéngén wárogh ár a nák watamegh ár tawakayongérwén kété, nékwafé témndetawét. ");
INSERT INTO nmx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Féyo Erod a yánjo fiyaré si tawafrotawét a tasalitawét fá. Fá yamanetaménd Yesu warsagh árfene sáláme, yémofem táf kor yéngwangoyénd Failetefaf. ");
INSERT INTO nmx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yéné efghon Erod a Failet fá fútar namndeyayénd, fronde kété fá tanérwén mék téfnár. ");
INSERT INTO nmx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Failetém eumendai limánégh ghéngén wárogh ár, limánégh ár a ámb ár, ");
INSERT INTO nmx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a norayai yéfefaf, “Fémofem ténémnjati Yesu tafaf efe témorwén kérté wafrogh ár. Wénde yéndon yéta témotan fá féfene sáfrére a ámb yaufi yau yinjon yáfaf árkémamén fém korayati yémo té tafrote. ");
INSERT INTO nmx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodém yau yaufi yawinjoi féyo yénmangoi téfefaf, 'Yéné ár yau so tékém krot.' ");
INSERT INTO nmx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Yénémaménnde yéndon so yéfmotan soramé téngéfrangon.” ");
INSERT INTO nmx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wénde ámbiro mwighayan fá nutnayénd, “Tésmetangi, Barabas ténmutorngi téfeyotǃ” ");
INSERT INTO nmx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas yélawayénd kétán kwéfkwéf sifayat ménamén fá stémorwén ámb ár mérén limánégh ár Jerusalemén yéné efe kásmetawét Rom gafamanafé a ár ngimén. ");
INSERT INTO nmx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Failet ménde témorwén Yesue utorghét, féyo fá kor norayai ár mérnafefaf. ");
INSERT INTO nmx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Wénde fá ménj tarnyangérwén keyan, “Téngwamend, Téngwamendǃ” ");
INSERT INTO nmx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nambinotmé wéikor fá norayai, “Némamén? Némé yaufi yémon yafrotam? Yéndon ámb yau yáne fifi yinjon yáfaf krot. Féyo yéndon so yéfmotan soramé téngéfrangon fá.” ");
INSERT INTO nmx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Wénde fá minde kutnawét ménjtaye, “Téngwamendǃ” a yéfene minde ke efalo namndai Yesue waméghét. ");
INSERT INTO nmx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Féyo Failetém yéfene ménde efalo yiyátoyéng. ");
INSERT INTO nmx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yémon yéngéumyoi Barabas efe yélawayénd kwéfkwéf sifayan gafamanafé ásméghmén a ár ngimén, Yesu yéngéumyoi yéfene méndefaf. ");
INSERT INTO nmx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Njam fiyaram yéngémnjoyénd Yesu, kété ár yétkwén Saimon témorwén Sairene méngotumén, efe ténmorwén álighan ámb tesenot, a Yesuene wafatarégh wén yéfayoyénd yáne faderan térsawéng Yesue sémta. ");
INSERT INTO nmx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tárfár árém Yesu táitotawét, amaf tangwafnyangérwén efe ye kéngéndawét yánemén. ");
INSERT INTO nmx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu néngawengoi a emndai fá, “Jerusalemén amaf, fém yau ye nendati tanemén. Fém ye nendati féfenjomén a féfenjo ambumtértérafenemén. ");
INSERT INTO nmx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Efogh yéna yéném njam fémofem so korayangi, 'Frengégh yém ambumofnar amafafet, árké kafkalam ambum yau yéráftam a ndenéyameyo nono yau tafamndawétǃ' ");
INSERT INTO nmx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Fá so norayat mband tunakéfafefaf, 'Kénuyangi téfefafǃ' a némbne mband tunakéfafefaf, 'Ténmafarngi yéndǃ' ");
INSERT INTO nmx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ménamén njam árém yéné rokar ewafrotat njam wén ghérsé yém, némé so nufrote táf sértan?” ");
INSERT INTO nmx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ámb sómbio ár, tárwén oro téfnár, ndenáyo tangémnjowét Yesufé naméghét kérotio. ");
INSERT INTO nmx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Njam fá nufaryénd yu yétkwén Golgota, “Yáne fifi Sénko sot sifayé,” kété yémofem enamndaménd Yesuf yémafé sómbio oro téfnárafé ámb yáne tambénta, ámb yáne fatrata. ");
INSERT INTO nmx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu norayai, “Afé, tawawalinda yéfene yaufi, fá mafina em némé yémofem yafrotat.” A yémofem Yesuene sáláme kawaftawét ménaye dais kembneye. ");
INSERT INTO nmx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ár tárfár tawakayongérwén téfandawét yam ufroghan, limánégh árém sénkér tawafrotawét Yesue. Yémofem korayawét, “Yémon tawanjane ámb ár. Fáyo kawanjarngé, njam fá yém Ngánjánene Keriso, yáne waferghkaf ambum.” ");
INSERT INTO nmx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Fiyaré enmormén si tawafrotawét. Yémofem yénmarsaménd njérmat wéri nu yáyot, ");
INSERT INTO nmx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","a norayayénd, “Fém njam ném Ju árfene warsagh ár, fémyo kawanjarǃ” ");
INSERT INTO nmx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kété témorwén farogh férén yá tukén, árké yémndetat, “Yéné fiyém Ju árfene warsagh ár.” ");
INSERT INTO nmx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ámb oro téfnár tamangérwén yá téndon, yémo yémndayéng Yesu, “Fém fété ném Keriso? Kawanjar fémyo a yénd ténmanjareǃ” ");
INSERT INTO nmx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Wénde ámb oro téfnáram yarnaméng fá a yémndai, “Fefaf Ngánján férfér té yém? Fém ndenéyameyo féu ném. ");
INSERT INTO nmx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yénd ámb rérero tékrátan yéném mérne, ménamén téfenjo yaufimén yéndfem tékrát yérsuwam. Wénde yéné árom yaufi yau yafrotam.” ");
INSERT INTO nmx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Féyo yémon yémndai, “Yesu, yénd táf wafarota fém njam néngém fenjo Ngánjánene limánghét.” ");
INSERT INTO nmx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesum yawangoi yá, “Yéndon némndetan fém efalo, sénonjo yénd fémafé so yénre áuwégh méngotuan.” ");
INSERT INTO nmx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Efoghméf témorwén, a kwéfkwéfam yu yafaryéng kétánotio séite karéf efogh náyátoi, ");
INSERT INTO nmx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ménamén efogh nékmboi atremngogh. Wáwefnogh méngon sénjté sáláme tamangérwén nénatiraryéng tukta nde yuwot sómbio karéf. ");
INSERT INTO nmx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu minde nutnayéng, “Afé, fene ngángat tane mbérmbér yérametan.” Njam yémon yéné si norayai, fá kér táf yémormén. ");
INSERT INTO nmx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rom fiyaré sénko árom yinjoi némé kufrotau, Ngánján tuwetau a norayai, “Efalo yiyátoi yéné ár témorwén mbarkánd.” ");
INSERT INTO nmx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Njam méinyotio ár efe káumendawét téfandawét néméyam kufrotau, ghérghérsisamén wéfan káutánawét a nénguwanoyénd. ");
INSERT INTO nmx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wénde méinyotio fá efe mat tamorwén yánemén a amaf tawafnyangérwén efe kuwaitotau yáfaf kétándmé Galili yu, nayu nénokayoyénd yam téfandawét ufroghan. ");
INSERT INTO nmx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kété témorwén ár yétkwén Josef, Ju sénko árfene áumengégh utmanégh ár, mer a mbarkánd ár, ");
INSERT INTO nmx_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","emon yau yéfene mwighé wafroghyam efalo yiyátoi. Fá kétándmé yénmormén Judia árfene tesen Aramatiat a fá kawanjetau Ngánjánene limánégh ufarghét. ");
INSERT INTO nmx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Fá yéngmormén Failetefaf ámoghét Yesuene fifimén. ");
INSERT INTO nmx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Féyo yémon yeworyéng yuwot, sáláme fiyarghét ménát mbéwé méngon kémghét kété ámb ár ánde yau yélawayénd ");
INSERT INTO nmx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yéné ásáfogh tafrotau wékeye Fraide séiten ménamén Safat rényégh kaka témorwén. ");
INSERT INTO nmx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yéné amaf efe Yesufé enmormén kétándmé Galili yuta yéngwaitoyénd Josef mbéwé fandaghét a ndernáye yékmayénd yáne fifi. ");
INSERT INTO nmx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Fá néngangoyénd méngot mer wimafé wékwér frengéghét. Wénde fá kenawét Safatan ndené fété Mosesene nák. ");
INSERT INTO nmx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande tándái akwan, amafam tangérsawét mer wimafé wékwér árkéméné yénfrendaménd a néngwanoyénd mbéwafaf. ");
INSERT INTO nmx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yémofem yinjoyénd wím feghkaf mbéwata, ");
INSERT INTO nmx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","wénde fá njam nélawayénd, yémofem yau yinjoyénd Yuré Yesuene fifi. ");
INSERT INTO nmx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Njamandio fá mwighayan kéwérsotawét Yesuene fifi árkamé yémorwén, tekofnaye sómbio ár nufaryayénd ghékéf waufaroghe kwayaghé sálámeyafé yéfene téndota nokayeyayénd. ");
INSERT INTO nmx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yéné férféran amaf ninyayénd mbandot, wénde yéné árém emndayénd fá, “Fémofem némamén yéronjati kér árfene sifayan efe yém ghérsé? ");
INSERT INTO nmx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Fá siyém yéna yau yém! Fá té nénganoǃ Mé kawafarotangi fém ndernáye tamndetau, táf fémafé njam mé témorwén Galili yuwon, ");
INSERT INTO nmx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","'Ároene Ambum so téramangi yaufi árfene ngángat, wafatarégh wénan so yénamndat a nambio efghon so kanongé wéikor.'” ");
INSERT INTO nmx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Táf nawafarotayénd yáne si. ");
INSERT INTO nmx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Njam fá nénangoyénd kétándmé mbéwata, yémofem ewaufroyénd méinyotio némé téfandawét 11 waitogh árét a méinyotio ámb árfet. ");
INSERT INTO nmx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Meri Makdalin, Joana, Meri Jemse yátmé, ámb amaf efe tamorwén yémafé ewaufroyénd Yesuene muyafé árét. ");
INSERT INTO nmx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wénde yémofem efalo yau eyátoyénd yéfene si, ménamén yéfene si afrogh témorwén yéfeyot ndenanit onon ár kar korayawét. ");
INSERT INTO nmx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wénde Fité táf fété nurtotam a nétonam mbéwé yafoghét. Fité néngáwefnoi, engwinjoi sálámero tákmangérwén kénaghkaf, a fá néngwanoi uwérsoghan témorwén némé té nufrotam. ");
INSERT INTO nmx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yéné efghonyo sómbio ár tangérwén Jerusalemta kétán Emausét 11 kilomité ");
INSERT INTO nmx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yémofem téngwarunwét endmé yéfe kénjúnro némé yam kufrotau. ");
INSERT INTO nmx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Njamandio fá ngoraiwét a téngwarunwét mérne, Yesu fáyo yénmormén a tayotau yémafé. ");
INSERT INTO nmx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wénde yémofem yau yayamngeyayénd Yesu. ");
INSERT INTO nmx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yémon emotangeyai fá, “Némamén fémofem yarunyét táf fém seyowé?” Fá áligh nékmbeyayénd, ghérghérsisé sáfafé. ");
INSERT INTO nmx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ámb témorwén yétkwén Klofas, yémotai fá, “Fém némé wan téfnár ném Jerusalemén a mafina ném némé yam nufrotat yéné efghon?” ");
INSERT INTO nmx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesum emotangeyai, “Némé yam nufrotat?” Yémofem yawangeyayénd, “Yesu Najaretmén. Fá témorwén Ngánjánene mat yátogh ár wafté kér ro sian a sélngwélafé yam wafroghan Ngánján sáfrére a méinyotio ár. ");
INSERT INTO nmx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Limánégh ghéngén wárogh ár a téfene limánégh árém yémnjoyénd a yéramayénd krot, a yénamndaménd wafatarégh wénan. ");
INSERT INTO nmx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wénde téfene méghmégh nafayoi nde fá so témorwén emo so tanjarngai Israil. Nambio efogh sénonjo yém yéné yam té kufrotat. ");
INSERT INTO nmx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Féyo ámb amaf téfene mérénmén sélngwél yéramayénd. Fá tangém mbéwafaf sénonjo tándái akwan ");
INSERT INTO nmx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wénde yau yinjoyénd Yesuene fifi. Fá nénangoyénd téfefaf yénmaufroyénd téfe ndené fá yinjongi njafar si résagh ár, efe noraya ndené fá siyém ghérsé yém. ");
INSERT INTO nmx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Féyo ámb téfene mérénmén ár néngwanoyénd mbéwafaf a yinjoyénd ndené fété amaf némé kafrotawét, wénde Yesu yéné amafam yau yinjoyénd.” ");
INSERT INTO nmx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Fá norayai yéfefaf, “Nderé mwighafnar fém em, a nderé táikér yéfandati efalo yátoghét tikfan méinyotio Ngánjánene mat yátogh árém némé korayawétǃ ");
INSERT INTO nmx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kerisoe áfrat témorwén tékratot soramé fá nélawai yánjo ndimbal kwayaghat?” ");
INSERT INTO nmx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yémon sie yérnyai Moseseta a méinyotio ámb Ngánjánene mat yátogh ár, yémon tawawafenau yéfeyot némé té korayau méinyotio Ngánjánene sian yánjomén. ");
INSERT INTO nmx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yémofem kaka méngotu yéngiyátoyénd ándan fá tangmorwén, Yesu awaingétro téngmorwén. ");
INSERT INTO nmx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Wénde yémofem yamnendayénd Yesu ménjtaye, “Yéndfé kámnjongém ménamén yéférte.” Féyo fá néngwanoi yéfefaf ámnjoghét. ");
INSERT INTO nmx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Fá njam námnjoi njamke sifayan yémafé, yémon féskaf flawé yékafai, kánjo yéramai a yétfoi ewarametam yéfeyot. ");
INSERT INTO nmx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Féyo táf yéfene ghékéf nasawéryénd a yáyamngoyénd efe Yesu témorwén, a fá néngolindai kétándmé yéfene ghékéfta. ");
INSERT INTO nmx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Fá korayawét yéfenjo kénjúnro, “Téfene tikéf nakérnat téfene kénjún njamandio fá korayau téfefaf endén a si yénmasawéryéng téfeyot?” ");
INSERT INTO nmx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Fá wékeye nuwanoyénd a kangotawét Jerusalemét. Kété fá ewinjoyénd 11 waitogh ár a ámb ár emafé káumendawét ");
INSERT INTO nmx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","a korayawét, “Efalo yémǃ Yuré té nénano a nufar Saimonefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Féyo sómbioyam ewaufreyayénd némé kufrotau yéfefaf endén, a ndernáye yémofem Yesu yayamngeyayénd Yesum njam féskaf flawé ewatfeyai. ");
INSERT INTO nmx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Njamandio fá mé korayawét yénémamén, Yesu fáyo nénokayoi yéfene kénjún a norayayéng yéfefaf, “Krufrat féfefaf so yémǃ” ");
INSERT INTO nmx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yéné mérén férféram ewifoi ndené kemnawét nde yémofem kar yinjoyénd bérsebérse. ");
INSERT INTO nmx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Fá norayai yéfefaf, “Némamén fém néworsotati, némamén féfene mwighé déudéu nanote? ");
INSERT INTO nmx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tafandangi tane sómbio ngángé a sómbio kafkaf. Yénd yéndio efalo fété wémǃ Kwiyánja yénd a kwéfandangi. Bérsebérse yau yém fifiyafé a sotafé, fémofem kés wéfandati yénd fété wém.” ");
INSERT INTO nmx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Njam fá korayau yénémamén, yémon tawauyafotau yáne ngángé kabu a kafkaf. ");
INSERT INTO nmx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yémofem mé tétambnawét efalo yau tiyátotawét ménamén áuwégh a sélngwélafé yammén, yémon emotayéng fá, “Féfene ámb némndafi té ewam yéna nénet?” ");
INSERT INTO nmx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yémofem yaramayénd Yesue bélamén wagif mbarmbar, ");
INSERT INTO nmx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a yémon yékafai a yerai ténetau yéfene ghékfan. ");
INSERT INTO nmx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Fá norayai yéfefaf, “Yéné fiyém némé yénd korayawén táf yénd njam mé ténmorwén fémafé. Méinyotio si efalo so náyátote némé yéfarotaménd tanemén Mosesene nák kénjún, Ngánjánene mat yátogh árfene Buk a Sams.” ");
INSERT INTO nmx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Féyo yémon ewasawéryéng yéfene mwighé mat áyátoghét Buk si némé yéfarotaménd. ");
INSERT INTO nmx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yémon ewaufroi yéfeyot, “Yéné fiyém némé yéfarotaménd tanemén. Keriso so tékrátan yém a kénanongé kétándmé kérta nambiomén efghon, ");
INSERT INTO nmx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","a yaufi awengoghmén a wányányéghmén so yaitotat yáne yétkwénan méinyotio yuwomé so térnyangi kétándmé Jerusalemta. ");
INSERT INTO nmx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Fém em fandagh ár yéné yammén. ");
INSERT INTO nmx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yéndon ewáfáretan fém némat tane Afam unyéghofnar si norayai. Wénde tesenan so nawanjetati kétánotio njafar tukta waftaye kéneworngé féfefaf.” ");
INSERT INTO nmx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yémon njam elimai Betani tesenta, Yesum ngángé euyoi a efrendai fá. ");
INSERT INTO nmx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Njamandio fá táfrendawéng, yémon engfrangoi fá táf nénguyoi njafarot. ");
INSERT INTO nmx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Féyo yémofem yáwefnoyénd Yesue a kangotawét Jerusalemét ndimbal áuwéghafé. ");
INSERT INTO nmx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","A fá túmén kawanjetawét wáwefnogh méngon méinyotio efghon, Ngánján tuwétawét. ");
INSERT INTO nmx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tane fronde bukan, Tiafilus, yéndo yéfarotamén ménamén méinyotio Yesum némé wafrogh ewafngoi a watamegh ");
INSERT INTO nmx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","a tawarametau yánjo muyafé árét efe yémo té ewaferyéng watamegh yam Ngánján Mbérmbér kénjúmé, a féyo efogh nawerai fá njam yéngwanayéng njafar tukét. ");
INSERT INTO nmx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yáne tékrát soramé, fá auyafogh nufngoi fáyo yéné árfefaf a efalo si waufrogh ewafngoi ndené yénd ghérsé wém. Fá njam nufaryéng yéfefaf safét 40 efogh soramé a korayau Ngánjánene limánéghmén. ");
INSERT INTO nmx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ámb efghon, yémofem njam njamke tánetawét yémafé, yémo emndai, “Yau téfrangongi Jerusalem, wénde nawanjetati yéné merot tane Afam némé unyéghofnar si té emndai, fémofem té káyáretawét némamén yénd korayawén. ");
INSERT INTO nmx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Joném nuwan tawalitotau, wénde nambio efogh soramé fém so Ngánján Mbérmbére ewalitote.” ");
INSERT INTO nmx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Féyo njam fá nafángoyénd Yesufé, yémofem yémotayénd fá, “Yuré, fém féyotaro ném yéné efghon Israil yu sái yérameta wéikor?” ");
INSERT INTO nmx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yémo emndai fá, “Yéné féfeyot yau mat efogh o efoghféneféne em, wénde Ngánjánro mat yém. ");
INSERT INTO nmx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wénde fémofem so tawinjongi wafté táf Ngánján Mbérmbér njam yéném féfefaf, a fém so em tane si ghékéf fandagh ár Jerusalem kénjún, méinyotio Judian a Samarian a kétánotio mband marat árkamé yiyato.” ");
INSERT INTO nmx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yéné soramé fá njam yéné si norayai, fá táf nuwanoi yéfene méinyotio ghékfanro, njafar kwamkwamam yéngwamoi yéfene ghékéfta. ");
INSERT INTO nmx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Fá mé tawewotawét njafarot fá njam téngmorwén, sélngwéle sómbio ár kwayaghé sálámefé nokayeyayénd yéfe téndota. ");
INSERT INTO nmx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Fá norayangeyayénd, “Ár Galili yumén, fém némamén yéna ewakai néwewetati njafarot? Yéné Yesuyo efe té yéngwanang féfe tambén njafarot, so nénangote yéné endmayo fémofem kés yéfandati néngwano njafarot.” ");
INSERT INTO nmx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Féyo fá nénangoyénd Jerusalemét kétándmé mband tunakéf Olif tambén nayuofnar kétán Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Fá njam nufaryénd, narmboyénd ámb saté méngo kénjút ánde fá tamorangérwén. Fá kété tamorwén Fité, Jon, Jems a Endru, Filif a Tomas, Batolome a Metyu, Jems Alfasene ambum a Saimon efe ménde témorwén ndené Ju ár so kawanjetawét fáyo yau Rom waftayan, a Judas Jemsene ambum. ");
INSERT INTO nmx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Fá méinyotio túmén káumendawét Ngánjánafé orayéghét méinyotio amaf a Yesuene amé Meri a Yesuene nénngnéf. ");
INSERT INTO nmx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yéné efghon Fité nokayoi 120 efalo yátogh ár mérén kénjún ");
INSERT INTO nmx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","a norayai, “Fútaréf, Buk si so nufrote árkéméné Ngánján Mbérmbér korayau fronde Deifidene mbírmbírta némé korayau Judasenemén, efe náyátoyéng wambégh ár yéfeyot emofem Yesu yerayénd, ");
INSERT INTO nmx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ámb tém téfene kénjún a si waitogh ár.” ");
INSERT INTO nmx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judasém mani ewanai yaufi ásáfoghmén, yémon yanayéng mband, kété numai yáne fifi néfnoi marataye a yáne ghérghér nétoryénd. ");
INSERT INTO nmx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Méinyotio ár Jerusalemén náyárayénd yénémamén, féyo yémofem yéné sifayé témndetawét yéfenjo sie Akeldama, yáne fifi siyém “Férék sifayé.” ");
INSERT INTO nmx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Fité norayai, “Fété yékai Sams bukan, 'Yáne sifayé so yém fanfnero, efe yau so yémor yáne sifayan,' a 'Ámb árom téngwanangé yáne limánégh sifayé.' ");
INSERT INTO nmx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yénémamén so fété tékafangém ámb ár efe yéndfé té téném méinyotio efghon njam Yuré Yesufé yénd tényotau, ");
INSERT INTO nmx_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kétamé yéné efghon Joném njam nue yálitotam Yesu kétánotio fá néngwanoi téfe tambén. Ámbiro so kénamndangé ghékéf fandagh ár yéndfé Yesuene anoghmén.” ");
INSERT INTO nmx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Féyo sómbio ár euyafeyayénd, Matias a Josef Barsabas efe témorwén yétkwén Jéstus. ");
INSERT INTO nmx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Féyo fá Ngánjánjafé koraiwét, “Yuré, fém mat ném méinyotio árfene tikéf. Ténmauyafo téfe yéné sómbiota fémo efe té yékaf ");
INSERT INTO nmx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ménát téngwanangé Yesuene muyafé ásáfogh, árkéméné Judasém yéfrango a yéngém kétán ánde kérté so tanangé.” ");
INSERT INTO nmx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Féyo yémofem wén kembne yérnyayénd ménát so tinjongayénd efe Ngánjánam yafer, a wén nuyáyéng Matiasefaf, féyo fá nafghayéng kétán ámb 11 Yesuene muyafé ár kés tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Njam Fentikost efogh yénmormén, fá náumendaménd ámbiro sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sunsune ke yénmormén ndenanit ndimbal mbormbornit njafarta a yafoi méinyotio méngo ánde fá tamorangérwén. ");
INSERT INTO nmx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Féyo yémofem yinjoyénd némé kéretau ndenanit fés kánkékánkénit árkéméné nófarnayénd a námnjoyénd ámbiroámbiro árfefaf kété. ");
INSERT INTO nmx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Méinyotio ár tamorwén Ngánján Mbérmbér wafoghkaf a Ngánján Mbérmbéram eméindai nufngoyénd si fénatayero orayégh. ");
INSERT INTO nmx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kété tamorangérwén Jerusalemén Ngánján férférafé Ju ár fénaté ndimbal yumén mband maratan. ");
INSERT INTO nmx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yémofem njam yéné ke náyárayénd, ár mérén enmormén nafghayénd mwighé déudéuafé, ménamén ámbiroámbiro ár káyáretawét yéfenjo sie korayawét. ");
INSERT INTO nmx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Minde sélngwélafé, fá korayangi, “Yéné ár efe norayat ndenanit Galili yumén ár em. ");
INSERT INTO nmx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ndernáye so náyáretam téfenjo si yéfe tambén? ");
INSERT INTO nmx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yénd yéné yéném Farsiamén, Medemén, Elammén, Mesofotamiyamén, Judiamén, Kafadokiamén, Fontosmén, Esiamén, ");
INSERT INTO nmx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiamén, Famfiliamén, Ijifmén, Sailen kaka Libiamén, wan ár kétándmé Rommén, ");
INSERT INTO nmx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ju ár a fénaté yumén wáwefnogh ár, Kéretamén a Arabmén, yéndfem eyáretam fá norayat téfenjo sie, yéné ndimbal yammén némé Ngánjánam tawafrotauǃ” ");
INSERT INTO nmx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sélngwélafé a mwighé déudéuafé, fá namotayénd ámbiroámbiroe, “Némé fifi yém?” ");
INSERT INTO nmx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wénde ámb árém tawértawét a emndayénd, “Yémofem tánetat totér wéri nu.” ");
INSERT INTO nmx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Féyo Fité nokayoi 11 waitogh árfé, yáne kém narmboi a si kafrotau ár mérnan, “Fém Judiamén ár a méinyotio efe emor Jerusalem kénjún, yéndon so ewawafenan yéné yam féfeyot, káyárangi merkéráye yéndon némé norayan. ");
INSERT INTO nmx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yéné ár sem wéri yau em, ndené kés nemnati. Sénonjo siyém 9 aklokro akwǃ ");
INSERT INTO nmx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wéndende, némé té kufrote téfefaf yém Ngánjánene mat yátogh ár Joel némé korayau, ");
INSERT INTO nmx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Ngánján noraye, 'Sénonjo kerker efghon, yéndo so téngwasurén tane Mbérmbér méinyotio árfefaf, a féfene ambum a mérésmérés so nafrotat Ngánjánene si, a féfene totér árém ghékéf waingégh yam so efandat, a féfene ákif onjo so ekém. ");
INSERT INTO nmx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wénde tane faiofnar ásáfogh árfet, ár a amaf, yéndon so téngwasurén tane Mbérmbér yéné efghon, fá so nafrotat Ngánjánene si. ");
INSERT INTO nmx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yéndon so sélngwélafé yam ewauyafotan njafaran a ufarogh yam mband mbanmbanan, férék, fés a sénjté kwam. ");
INSERT INTO nmx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Efogh so kawengongé kwéfitat a ghérare so kawengongé férkot yéné soramé Yurane efogh yéném ndimbal a ndimbal kwayaghafé. ");
INSERT INTO nmx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A méinyotio ár efe kómnendangi Yurane yétkwénan, fá so kawanjarngi.' ");
INSERT INTO nmx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israilmén ár, káyárangi yénémamén, Yesu Najaretmén ár témorwén Ngánjánam efe yuyafoi féfeyot fénataye wafroghyamafé, sélngwélafé yam a ufarogh yamafé, árkéméné Ngánjánam tawafrotau féfefaf yáne kénjúmé ndené fété fém mat em féfenjomén. ");
INSERT INTO nmx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ngánján fá mat témorwén némé kufrotau, a yáne fronde mwighé yanayénd njam Yesu ngi yafngoyénd, a fémofem yékmayénd krot yénamndaménd wafatarégh wénan Téndo árém. ");
INSERT INTO nmx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wénde Ngánjánam yanoi kérta, yaloi kér tékrát tambén, ménamén kéram yau so terangé. ");
INSERT INTO nmx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Deifid norayai yánemén, “'Yéndo yéfandan Yuré túmén ta frondeta. Ménamén fá tane kaka yém, yénd yau so nasambnetan. ");
INSERT INTO nmx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Féyo tane tikéf siyém nasnete a tane kánké náuwete, tane fifi so ndenéyameyo nene kamnangan, ");
INSERT INTO nmx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ménamén fémo yau so kwéfrango kér árfé, o tumyo fene njúnnjúnofnar ár sái nornda mbéwé méngon. ");
INSERT INTO nmx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fém mat té náyátoi tafaf ghérsé endmén, fémo yénd so kwafo ménaye áuwéghe fene sáfrére.' ");
INSERT INTO nmx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Fútaréf, yéndon so ewaufrotan efaloe ndené áki Deifid kér yémormén a yiyatotaménd a yáne mbéwé méngo yéna yém yéné efghon. ");
INSERT INTO nmx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wénde fá témorwén Ngánjánene mat yátogh ár a mat namndai ndené Ngánjánam némé yémndetam ndené yáne áki so kámnjongé yáne limánégh ámnjogh sifayan. ");
INSERT INTO nmx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deifidém téfandau soramé yu a korayau Kerisoene anoghmén, fá ndené korayau Ngánjánam yau so téfrangongé kér kénjún o yau so tumyongé yáne fifi kérkfot mbéwé méngon. ");
INSERT INTO nmx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ngánjánam té yanoyéng Yesu ghérsat, a yénd yéné yéném fandagh ár efaloe. ");
INSERT INTO nmx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Fá té yuyoi Ngánjánene tambén ngángat, ndené fété Ngánjánam némé té norayai, yémon té yumyoi Afé tambén Ngánján Mbérmbér a té yénmasuryéng némé fémofem sénonjo yéfandati a náyáretati. ");
INSERT INTO nmx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ménamén Deifid yau yáfáretam njafarot, wénde fáyo norayai, 'Yuré norayai tane Yurafaf, “Kámnjo tane tambén ngángata ");
INSERT INTO nmx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kétánotio yéndo so tákman fene mék téfnár fene kafkaf mbanmbanan.”' ");
INSERT INTO nmx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Féyo méinyotio Israil ár mat kamndangi ndené fémofem yéné Yesu té ténamndati wafatarégh wénan, wénde Ngánjánam té yiyátoi Yuré a Keriso.” ");
INSERT INTO nmx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Njam árém Fité yiyárayénd yéné si snorayai, fá táf nuyáyénd tikfan a norayayénd Fitafaf a ámb Yesuene muyafé árfefaf, “Fútaréf, némé yéndfem so ewafrotam?” ");
INSERT INTO nmx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Fitam ewawangoi, “Kawengongi walitoghét, fém méinyotio, Yesu Kerisoene yétkwénan ménát féfene yaufiyam so mwighafnar tawayangé. A Ngánjánam so tawaramangé Ngánján Mbérmbér. ");
INSERT INTO nmx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Yéné unyéghofnar si sem féfeyot a féfene ambumafet a méinyotio efe nayu em, ndenáyo méinyotio efe Yuram téfene Ngánjánam so tamotangé yandio.” ");
INSERT INTO nmx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Fitam tárfár sie tawawéngsotau fá, a yémon tamndetau, “Fém kawanjarngi yéné yaufi saté árta.” ");
INSERT INTO nmx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fá emofem yáne si waitogh yumyoyénd walitogh ewafngoi, a táf 3,000 ár farun nafayoyénd yéné efghon. ");
INSERT INTO nmx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Fá naramayénd ámb efogh Yesuene muyafé árfefaf watameghét a áumengéghét, féskaf flawé faloghét a Ngánjánafé orayéghét. ");
INSERT INTO nmx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Méinyotio ár férféram ewifoi a tárfár sélngwélafé yam a ufarogh yam téfandawét Yesuene muyafé árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Méinyotio efalo yátogh ár náumendayénd a tafalotawét yéfenjo rokar. ");
INSERT INTO nmx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yémofem tawafnamotawét yéfenjo ásáfogh sifayé a méndefé rokar, yémofem tawarametawét yéfeyot efe káronjawét. ");
INSERT INTO nmx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Méinyotio efghon fá túmén káumendawét wáwefnogh méngo sifayan. Yémofem tatfotawét féskaf flawé yéfenjo méngo kénjún a mérne tánetawét áuwéghafé a mer tikfe, ");
INSERT INTO nmx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ngánjáne wagh tawerémndawét a tayamnetawét mer méinyotio árém. A Yuram farun ámb ár efayoi méinyotio efghon fá efe ewanjaryéng. ");
INSERT INTO nmx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ámb efghon Fité a Jon tayowéng wáwefnogh méngot Ngánjánafé orayéghét 3 aklok séite karfe. ");
INSERT INTO nmx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ámb ár aknyégh áre témorwén kétamayo áráfégh fá yénérsaménd kétán wáwefnogh méngo sésafnet yétkwén Merfifi, ánde fá tumnjongayénd túmén efghon ómnengét yéfefaf efe tangmorwén wáwefnogh méngot. ");
INSERT INTO nmx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yémo njam ewinjeyai Fité a Jon wáwefnogh méngo élaughétro tárwén, yémo emotangeyai ménát maniot. ");
INSERT INTO nmx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Fitam yéfandayéng mbarkánde fá, ndenéyameyo Joném. Féyo Fitam yémndai, “Yénd ténfandangeǃ” ");
INSERT INTO nmx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Féyo yéné árom ewarameyai utmanégh, ndené kemnau némndafi kar so tarameyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Féyo Fitam yémndai, “Tane ámb yau yém manikéf o gol, wénde némé tane yém, yéndo so kémaraman fe. Yesu Keriso Najaretmén yáne yétkwénan, kokai áligh kufngoǃ” ");
INSERT INTO nmx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Fitam yerai tambén ngángata, yémo yáutánam okayoghét, táfandio ároene kafkaf a kagh muyafé namndeyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Fá natnaméng yánjo kafkafe a áligh nufngoi. Féyo fá nuwanoyénd yémafé wáwefnogh méngot, tiyotawéng a kátnawéng tuwetau Ngánján. ");
INSERT INTO nmx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Njam méinyotio árém yinjoyénd fá álighan a Ngánjánene waghan, ");
INSERT INTO nmx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","yémofem yáyámngoyénd fá yéné ár efe túmén témorangérwén ómnengéghan wáwefnogh méngo sésafne yétkwén Merfifi, a fá sunsun emormén a sélngwélafé yammén némé kufrotau yáfaf. ");
INSERT INTO nmx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Njamandio ómnengégh ár kaweretau Fité a Jonefaf, méinyotio ár sélngwél emormén kénérsawét yéfefaf yéné sifayat yétkwén Solomonene méngo sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Njam Fitam yéné yinjoi, fá norayai yéfefaf, “Israilmén ár, némamén yéné yammén fém sélngwél em? Némamén fémofem ghékfe yénmámnjotati yénd ndenanit téfenjo wafté a Ngánján wáwefnogh yame yéndfem kar yéné ár yéméindangem álighét? ");
INSERT INTO nmx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraamene Ngánján, Aisekene Ngánján, Jeikofene Ngánján, téfene ákifene Ngánján, tuwetawét yáne faiofnar ásáfogh ár Yesu. Fémofem yéramayénd fá kétán ngiot a fémofem yékenayénd Failetene sáfrére, soramé yémon mwighé yáitoi yáyot umyoghét. ");
INSERT INTO nmx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Fémofem yékenayénd Njúnnjúnofnar a Mbarkánd Ár a namotayénd ndené ngi téfnár tumyongi féfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Fémofem yésmetaménd ghérsé téfén ár, wénde Ngánjánam yanoyéng kérta. Yénd yéné yéném fandagh ár yénémamén. ");
INSERT INTO nmx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ndimbal mwighaye Yesuene yétkwéne, yéné ár efe fémofem yéfandati a mat em, fá muyafé náyáto. Yéné siyém Yesuene yétkwéne a ndimbal mwighaye árké yéném yá kénjúmé yéramayéng yéné mer yátoghét yáyot, árkéméné fémofem méinyotio yéfandati. ");
INSERT INTO nmx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Fútaréf, yénd mat wém ndené féfene wafroghyam siyém mwighé kwéfkwéf em, ndenéyameyo féfene limánégh ár tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wénde yéné yém ndernáye Ngánjánam efalo yiyátote némé fá korayau méinyotio yánjo Ngánjánene mat yátogh ár kénjúmé, korayawéng ndené yéné Kerisom tékrát so yéfande. ");
INSERT INTO nmx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kakenangi yaufita a kawengongi Ngánjánefaf, ménát féfene yaufi so tawawayangé, ménát Yurata frengégh so yéném, ");
INSERT INTO nmx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","wamarogh efogh so kawerangé kétamé Yurata a Ngánjánam Yesu so ténmáfáretangé, efe yém Keriso efe té yuyafoi féfeyot. ");
INSERT INTO nmx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesu nawanjete njafaran kétán yéné efogh kawerangé Ngánjáneyot ménát Ngánjánam so ewafarnje méinyotio rokar, némé unyéghofnar si norayayéng tándái yánjo njúnnjúnofnar Ngánjánene mat yátogh ár kénjúmé. ");
INSERT INTO nmx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses norayai, 'Yuré féfene Ngánjánam so tunjangé Ngánjánene mat yátogh ár ndené fété yénd swém féfenjo ár kénjún, fémofem táf yiyáretati némat fém njam emndeta. ");
INSERT INTO nmx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Efe yau náyáretat yéné Ngánjánene mat yátogh ároefaf Ngánjánam so titérmbongé yéfenjo árta.' ");
INSERT INTO nmx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Kétándmé Samuel yénanotio sénonjo, méinyotio Ngánjánene mat yátogh ár kénorayawét némé ufroghan sénonjo em. ");
INSERT INTO nmx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A fém srem Ngánjánene mat yátogh árfene ambum a fém ewafnyang Ngánjánefaf némé mwighé yéréindam féfekifé. Yémon norayai Ebraamefaf, 'Fene áki ambum kénjún méinyotio ár yéné mbandan frengéghan so em.' ");
INSERT INTO nmx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Njam Ngánjánam yuyoi yánjo faiofnar ásáfogh ár, yémo yénmáfáretam fá fronde féfefaf Ju árfefaf frengéghét ménát awengogh féfenjo yaufita ámbiroámbiroe.” ");
INSERT INTO nmx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ghéngén wárogh ár a wáwefnogh méngo wanjengégh sénko ár a Saduki ár enmormén Fité a Jonefaf njamandio koraiwét árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Fá nékwan tamorwén ménamén Yesuene muyafé árém tawaufrowét árét Yesuene kénjún ndernáye kér ár so nanotat. ");
INSERT INTO nmx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yémofem ewereyayénd Fité a Jon. Fá kwéfkwéf méngon elaweyayénd. Fá so kawanjengwét kaitau, ménamén férégh témorwén ");
INSERT INTO nmx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wénde tárfár ár efe náyárayénd si efalo yiyátoyénd, a yéné efghon áyárégh ár náyátoyénd 5,000 ár. ");
INSERT INTO nmx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ámb efghon, limánégh ár, sénko ár a nák watamegh ár nafángoyénd Jerusalem kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas limánégh ghéngén wárogh ár kété témorwén, a Kayafas, Jon, Aleksendé a ámb efe limánégh ghéngén wárogh ár mérénmén tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yémofem enémnjéménd yéfene sáfrére Fité a Jon a mogh ewafngeyayénd fá, “Némé waftaye o némé yétkwéne yéné ásáfogh ewafrot?” ");
INSERT INTO nmx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Féyo Fité, Ngánján Mbérmbér wafoghkaf, norayai yéfefaf, “Limánégh ár a árfene sénko árǃ ");
INSERT INTO nmx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Njam té yénd yénmot mer ásáfoghmén aknyégh ároenemén efe mer namndai a ndernáye mer náyátoi, ");
INSERT INTO nmx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","fém fái mat kamndangi, a méinyotio Israilmén ár. Yéné siyém Najaretmén Yesu Keriso yáne yétkwénan, efe fémofem yénamndaménd wénde efe Ngánjánam yanoyéng kérta, yéné ár yakai féfene sáfrére merro. ");
INSERT INTO nmx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu siyém ndenanit wím, “'wím fémofem méngo ramégh árém yékenayénd, árké té namndé néndkéf sérasér.' ");
INSERT INTO nmx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wanjarégh siyém endefaf yau so tinjongi, ménamén ámb yétkwén yau yém mband maratan yéramai árét árkéménaye yénd so ténmanjarngé.” ");
INSERT INTO nmx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Yémofem njam ewinjeyayénd Fité a Jon férférofnar koraiwét a mat náyátoyénd ndenénde fá tárwén skulofnar o ménd ár, fá sélngwél emormén a fá mat tamorwén ndenénde yéné ár Yesufé tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wénde ménamén yémofem yinjoyénd aknyégh ár efe mer namndai tawakayongérwén yémafé, féyo némé si yau norayayénd. ");
INSERT INTO nmx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Féyo Ju sénko árém ewafáretangeyayénd téndot Ju sénko árfene áumengéghta, mérne nafghayénd a si taruindawét. ");
INSERT INTO nmx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Fá namotayénd, “Yéndfem némé yam so yafrotam yéné sómbio árfefaf? Méinyotio ár tamorangérwén Jerusalemén fá mat em nde némé yémofem sélngwélafé yam yafroménd árkéméné yéndfem yau so tékenangém. ");
INSERT INTO nmx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wénde yéné yam kémboghét marat mété káyátongé árfe kénjún, féyo yénémamén yéndfem mat yéné ár so táyátem yau so norayét yéné yétkwénan ámb árfefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Féyo wéikor emotangeyayénd yéné sómbio ár a táikér si emndéménd fá yau so norayét o ewatamet Yesuene yétkwéne. ");
INSERT INTO nmx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wénde Fité a Jonfem ewawangeyayénd, “Fém kemnangi kor ndené mbarkánde Ngánjánene ghékfan yém ár so tiyáré o Ngánján. ");
INSERT INTO nmx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yénd yau so kékmbongém sian téfén yéndfem némé tafandam a káyáretam.” ");
INSERT INTO nmx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kémbogh si soramé, yémofem engéumieyayénd. Yémofem ámb yau end ewinjoyénd ndernáye so fá tékrátan takmeyayénd, ménamén méinyotio árém Ngánján tuwetawét ménamén némé nufrotam. ");
INSERT INTO nmx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yéné ár efe Ngánjánam mer yiyátoi 40 yunjéf té yáindai. ");
INSERT INTO nmx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Fá njam engéfrangeyayénd, Fité a Jon néngangeyayénd kétán yéfenjo árfefaf a tawaufrowét méinyotio limánégh ghéngén wárogh ár a limángégh árém némé korayawét yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Fá njam káyáretawét yénémamén, féyo yémofem kém efghayénd mérne oraighan Ngánjánefaf, fá norayayénd, “Yurafene Yuré, fémo yafrotam njafar, mband a arakaf, a méinyotio rokar yéné kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fém korayau Ngánján Mbérmbére fenjo faiofnar ásáfogh ár, téfene afé Deifidefafmé, “'Némamén mband marat nékw em a némamén árém fifiofnar mwighé nemnat? ");
INSERT INTO nmx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mbandmén warsagh ár kafrendawét ngiot a limángégh ár náumendat mérne Yurafé ásméghét a wéi yémafé Keriso.' ");
INSERT INTO nmx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Efalo yátogh ár mé Ngánjánjafé koraiwét, “Erod a Fontius Failet kafángotawét mérne yémafé Téndo árfé a Israilmén árfé yéné ndimbal tesen kénjún ménát fene njúnnjúnofnar ásáfogh ár Yesue ngiot, efe fémon té yiyátoi Keriso. ");
INSERT INTO nmx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yémofem méinyotio yam tawafrotawét, fém mat kénmorwén frondeyo fene waftaye a méndeyan soramé nufrotam. ");
INSERT INTO nmx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yuré, kéreta yéfene nékw téfanda a fémon taméinda fenjo faiofnar ásáfogh ár fene siot so norayat férférofnar. ");
INSERT INTO nmx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Fenjo ngángé tásáfote ménát mer yátoghét a ufarogh yam a sélngwélafé yam wafroghét, Yesuene yétkwén kénjúmé, fene njúnnjúnofnar faiofnar ásáfogh ár.” ");
INSERT INTO nmx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Soramé fá Ngánjánjafé koraiwét, yéné sifayan ánde kafángotawét kété kásámbnetau. Féyo fá Ngánján Mbérmbéram ewafoi a Ngánjánene si táitotawét férférofnar. ");
INSERT INTO nmx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Méinyotio efalo yátogh ár tamorwén ámbiro tikfan a mwighayan. Efe ámb yau korayau ndené yéfene rokar yéfendro tamorwén, wénde yémofem tafalotawét yéfene némé tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Minde waftafé Yesuene muyafé ár ménjté tamorwén afroghan Yuré Yesuene kér anoghmén. Ngánjánene ngárám kafamndau méinyotio árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kété ámb ár yau káronjau rokarot yéfene kénjún. Efe mband a méngo yuré tamorwén yémofem tatérnawét a térarégh mani tanérsawét ");
INSERT INTO nmx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a takmetawét Yesuene muyafé árfene kafkafot, a tawarametawét yéfeyot efe káronjawét maniot. ");
INSERT INTO nmx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josef, Lefi mérénmén kétamamén Sáifres, efe Yesuene muyafé ár tanmotawét Banabas, yáne yétkwénone fifi siyém “Wawéngsogh ár ambum,” ");
INSERT INTO nmx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","yéramai yánjo mband maniot a yékmai mani Yesuene muyafé árfene kafkafot. ");
INSERT INTO nmx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ámb ár yétkwén Ananias, yátnofé tárwén Safairafé, yémofem mband yérameyayénd maniot. ");
INSERT INTO nmx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yémon ámb mani ewerai yandio, a yatén mat témorwén méinyotio yénémamén, a wénde enwanai ámbro a ekmai Yesuene muyafé árfene kafkafot. ");
INSERT INTO nmx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Féyo Fité norayai, “Ananias, ndernayan Sáifram fene tikéf yafoi ménát fémon tawinde Ngánján Mbérmbéroe a fémon ewer fendio ámb mani fémon árké ewan mbandmén? ");
INSERT INTO nmx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Fronde fene mband témorwén, soramé fémon yétérnai maniot. Mband résagh soramé, yéné mani náyátoi fene. Némayam fém néméindam yéné yamot? Fém yau kuinde árfefaf wénde Ngánjánefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Njam Ananias náyárai yéné si, fá táf fété nuyai krotio. A ndimbal férféram ewanai méinyotio efe náyárayénd némé yam nufrotam. ");
INSERT INTO nmx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Féyo totér ár nénuwanoyénd yáne fifi yéfinaménd, a yéngwanayénd a mband yaramayénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nambio efoghféneféne soramé yáne amaf yénmormén, yau mat náyátoi némé nufrotam. ");
INSERT INTO nmx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fitam amaf yémotai, “Ta kwaufro, yéné fai fiyém fém a Ananias yéné mbandmén sewaneyayénd?” Amafom yawangoi, “A, yéné fai fété yém.” ");
INSERT INTO nmx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Fité norayai amafoefaf, “Némamén fémofem yéné mwighé kemarét Yurane Mbérmbér ufoghét? Kéretaǃ Yéné totér ár emofem fene ár tiyatotat kété ewakai méngo sésafneyan, a fém yémofem ndenéyameyo so nérsat.” ");
INSERT INTO nmx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Táf fété amaf nuyai yáne kafkafot krotio. Féyo yéné totér ár nélawayénd a amaf yinjoyénd kérwén, yéngwanayénd yiyatotaménd a yánjarfé esareyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ndimbal férféram ewanai méinyotio Yesuene mérén a méinyotio ár efe náyárayénd yénémamén némé nufrotam. ");
INSERT INTO nmx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesuene muyafé árém tawafrotawét tárfár ufarogh yam a sélngwélafé yam árfene sáfan. A méinyotio Yesuene efalo yátogh ár túmén kafángotawét Solomonene méngo sifayan. ");
INSERT INTO nmx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fá férfér tamorwén ufényéghét yéfefaf, wéndende árém mer si korayawét yéfenemén ");
INSERT INTO nmx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tárfár árém a amafam efalo tiyátotawét Yuré a yéné téfnan ndimbal mérén kénáyátotau. ");
INSERT INTO nmx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yéné téfnan, árém tanérsawét enjne téfnár endét a takmetawét tatayafé a yameyafé ménát Fitane mbanmban so kuitau yéné árfefaf táf Fité njam kawaindau endmé. ");
INSERT INTO nmx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ndenayo ár mérén náumendaménd Jerusalem tesenmén, tanérsawét yéfenjo enjne téfnár a efe yaufi mbérmbéram tawasérmbotau a méinyotio mer káyátotawét. ");
INSERT INTO nmx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Féyo limánégh ghéngén wárogh ár a ámb yáne wáutárégh ár Saduki mérénmén waramnjagh ár náyátoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yémofem Yesuene muyafé ár ewerayénd a elawayénd marataye kwéfkwéf méngon. ");
INSERT INTO nmx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wénde yéné sémbáran Yurane njafar si résagh árom kwéfkwéf méngo sésafne esawéryéng a enéutoryéng. ");
INSERT INTO nmx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Yémon emndai, “Nguwanongi, kokayongi wáwefnogh méngo sifayan, a árét yéné tawaufrongi méinyotio totér ghérsamén si.” ");
INSERT INTO nmx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Táf njam akw yéfawéryéng fá nélawayénd wáwefnogh méngo sifayat, ndernáye té njafar si résagh árom emndai, a ár watamegh ewafngoyénd. Limánégh ghéngén wárogh ár a yáne mérén eumendayénd Sanedrin árké yém méinyotio Israilmén sénko árfene áumengégh, féyo ewáfáretaménd wanjengégh ár kwéfkwéf méngot Yesuene muyafé árét wasroghét yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wénde njam nufaryénd kwéfkwéf méngofaf, yémofem yau ewinjoyénd. Féyo fá néngangoyénd a nafroyénd, ");
INSERT INTO nmx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Yéndfem yinjongém kwéfkwéf méngo sésafne manéghkaf, kwéfkwéf méngo wanjengégh árfé tawakayongérwén sésafnefaf, wénde yéndfem njam esawérngém, efe yau ámb yinjongém kénjún.” ");
INSERT INTO nmx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Njam wáwefnogh méngo wanjengégh sénko ár a limánégh ghéngén wárogh ár káyáretau afrogh si, fá katambnawét némé mété nufrota Yesuene muyafé árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ámb ár yénmormén norayai, “Kéretangiǃ Yéné ár efe elawangi kwéfkwéf méngon ewakai wáwefnogh méngo sifayan ár ewatametat.” ");
INSERT INTO nmx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wáwefnogh méngo wanjengégh sénko ár nuwanoi yánjo ásáfogh árfé Yesuene muyafé ár enwasroyénd. Yémofem yau wauwirorghe enwasroyénd ménamén fá férfér tamorwén árém mété wíme tawafiyátowét. ");
INSERT INTO nmx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yesuene muyafé ár njam enémnjoyénd, yémofem ewakayoyénd Ju árfene sénko árfene áumengégh sáfrére ménát limánégh ghéngén wárogh árom sái tamotau. ");
INSERT INTO nmx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Fá norayai, “Yéndfem ewaramangém táikér si féfeyot ménát yau sái ewatametat yéné yétkwénan, wénde fémofem féfenjo watameghe Jerusalem té yafongi a yéné téfnan féfenjo mwighaye yényátongi Yesuene krot.” ");
INSERT INTO nmx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Fité a ámb Yesuene muyafé árém yawangoyénd, “Yénd so kámyongém wafroghét Ngánjánefaf yau árfefafǃ ");
INSERT INTO nmx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Téfene ákiafene Ngánjánam yanoi Yesu kétándmé kérta-efe fémofem yésmetaménd wafatarégh wénan yamayénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ngánjánam yuyoyéng fá yánjo tambén ngángat ndené fété warsagh ár a wanjarégh ár ménát yémon yéné yafrote Israilmén ár so nakenat yéfenjo yaufita a Ngánján so tawalindangé. ");
INSERT INTO nmx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yénd fandagh ár yéném yéné yammén, a ndenáyo Ngánján Mbérmbér efe Ngánjánam yéramai yéfeyot efe námyotat yáfaf áyárghét.” ");
INSERT INTO nmx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Njam fá náyárayénd yéné si, fá nékwafé namndayénd a ménde tamorwén krot sái tákmangayénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wénde Farasi ár yétkwén témorwén Gamaliel, nák watamegh ár, efe tutémndawét méinyotio árém, fá nokayoi Ju árfene sénko árfene áumengégh kénjún a si ewaramai yéné ár so tautoreyayénd téndot ménát fáro kénjún so korayangayénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Féyo nokayoi siot yéfefaf, “Israilmén ár, kor kemnangi merkéráye némé fémofem wafroghét yafngongi yéné árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ámb efghon, ár kété témorwén yáne yétkwén Téudas, efe kuindawéng nde ndimbal kar témorwén, 400 ár nufnyayénd yáfaf. Wénde fá yésmetaménd, méinyotio yáne waitogh ár nófarnayénd a yáne imángégh yamot nefoi. ");
INSERT INTO nmx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yá soramé, Judas Galili yumén nufaryéng yétkwén kayogh efghon, ár mérén tanlimndau nékwafé. Fá wéi yésmetaménd krotio, a yáne méinyotio waitogh ár semormén nófarnayénd. ");
INSERT INTO nmx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yéné téfnan yéndo ewawéngsotan fém. Yéné ár tafrangongiǃ Fá so nguwanongi. Némé yau so yafrotamǃ Njam yéfene mwighé o wafroghyam yém árfe tambén, so kefongé. ");
INSERT INTO nmx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wénde njam Ngánjáneta yéném, fémofem yéné ár yau so takmbongi, fém fémyo so kawinjongi Ngánjánafé ásmégh ár.” ");
INSERT INTO nmx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yáne si ewanayénd yémofem. Yémofem emotayénd Yesuene muyafé ár kénjút ényawéghét a fá fémogh ewafngoyénd. Féyo yémofem emndayénd fá yau so norayat Yesuene yétkwénan, a fá tangéumyend a nguwanongi. ");
INSERT INTO nmx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesuene muyafé árém yéfrangoyénd Ju sénko árfene áumengégh áuwéghafé ménamén fá Yesuene yétkwén téfnan tékrátan tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Méinyotio efghon wáwefnogh méngo sifayan a méngomé, fá yau nékmboyénd watameghan a mer si waitoghan Yesu Kerisoenemén. ");
INSERT INTO nmx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Yéné efghon njam efalo yátogh ár wékeye tárfár káyátotawét, Grik si téfnár tawafnyangérwén yéfefaf káwatarnawét Ibru si téfnárfefaf. Fá korayawét, “Njam fémofem Ibru si téfnár tafénawét njamke kétán kwirafefaf méinyotio efghon, fémofem yau ewarametati féyotaroyan njamke Grik si kwirafet.” ");
INSERT INTO nmx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Féyo yénémamén 12am eumendayénd méinyotio efalo yátogh ár a norayayénd, “Kor yau mbarkánd yém téfeyot Ngánjánene si ásáfogh sái nawaneta ménáyan njamke faloghan. ");
INSERT INTO nmx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Fútaréf, tawaferngi sefen ár féfenjo kénjúmén efe féfene matkaf em a Ngánján Mbérmbér afoghkaf a káfeté mwighafé. Yéndfem yéné ásáfogh so tawaramangém yéfeyot. ");
INSERT INTO nmx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yénd yéndio so karamangém méinyotio efogh Ngánjánafé oraighan a si waitoghan.” ");
INSERT INTO nmx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yéné si orayéghmén méinyotio ár náuwetaménd. Yémofem Stifen yaferyénd, yéné ár ndimbal mwighé afoghkaf a Ngánján Mbérmbérafé, ndenéyameyo Filif, Frokorus, Nikanor, Timon, Farmanas a Nikolas kétamamén Antiok yumén efe témorwén Téndo ár soramé náyátoi Ju árfé wáwefnogh ár. ");
INSERT INTO nmx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yémofem eramayénd yéné ár Yesuene muyafé árfene ngángat, efe Ngánjánjafé korayawét a ngángé efayoyénd yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Féyo Ngánjánene si marat náyátoyéng. Efalo yátogh ár Jerusalemén wékeye tárfár káyátotawét, a ndenéyameyo tárfár ghéngén wárogh ár námyoyénd áyárghét kétán ndimbal mwighafaf. ");
INSERT INTO nmx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stifen, yéné ár Ngánjánene ngárám afoghkaf a waftafé, yémon tawafrotau ndimbal sélngwélafé yam a ufarogh yam árfene kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wénde ámb Ju ár kétamamén tamorwén Sairene a Aleksandriamén a Silisia a Esia yumén efe korayawét ndené yénd siyéném Yuwek ár. Yéné ár éwigh nufngoyénd Stifenfé, ");
INSERT INTO nmx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","wénde fá féyotarofnar tamorwén yémafé éwighét ménamén Stifen témorwén káfeté mwighafé a Ngánján Mbérmbéroene muyayan korayau. ");
INSERT INTO nmx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yémofem kwankwane ewaferyénd ámb ár ndené siot, “Yéndfem té yiyárayém Stifen yaufi si korayau Mosesefaf a Ngánjánefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Féyo yéné ende yémofem ewasemnayénd ár, sénko ár, a nák watamegh ár. Yémofem yénmerayénd Stifen yénémnjoyénd Ju árfene sénko árfene áumengégh sáfrére. ");
INSERT INTO nmx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yémofem yéfunayénd unyégh si, efe norayayénd, “Yéné ár yau kékmbongé wanyogh si orayégh yéné wáwefnogh méngo sifayamén a nákmén. ");
INSERT INTO nmx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yéndfem fété tiyáretawém fá korayau ndené yéné Najaretmén Yesum so yirone yéné sifayé a so ewengote ákiafene nák Mosesém árkéméné té ewafnamoi téfefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Méinyotio efe tamorangérwén Ju árfene sénko árfene áumengéghan Stifen yémofem téfandawét yáne sáf náyátoi ndenanit njafar si résagh árnit. ");
INSERT INTO nmx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Féyo limánégh ghéngén wárogh árom yémotai Stifen, “Yéné wátaranégh efalo em?” ");
INSERT INTO nmx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yéné ámoghmén yémo yawangoi, “Fútaréf a afaf, kénáyárangi tafafǃ Minde kwayaghafé téfene Ngánján nufaryéng kétán téfene áki Ebraamefaf njam fá mé témorwén Mesofotamiyan, táf fronde njam fá témorangérwén Aranan. ");
INSERT INTO nmx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ngánjánam yémndai, 'Téfrango fenjo yu a fenjo ár, a kuwano kétán árké mband yéndon so kémauyafon.' ");
INSERT INTO nmx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Féyo yémon yéfrangoi Kaldia árfene mband a námnjoi Aranan. Yárefane kér soramé, Ngánjánam yéngwáfáretam fá yéné mbandot ánde fém sénonjo emor. ");
INSERT INTO nmx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ngánjánam yau yaramai ámb mband yéna. Wénde Ngánjánam unyéghofnar si yémndai fá, 'Fém a fene ákif fe soramé mband so tawaramangé.' Yéné efghon Ebraam ambumofnar témorwén. ");
INSERT INTO nmx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ngánján korayau yáfaf yéné ende, 'Féfene ákif so em dabi ár ámb árfene ndimbal yuwon yau yéfenjo ndimbal yuwon, fá so em árfene faiofnar ásáfogh ár a so taftawét 400 yunjéf. ");
INSERT INTO nmx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wénde yéndon so tékrátan tékman yéné ndimbal yu faiofnar ásáfoghétro ár eyátotat, a soramé yuwon fá so kéntorngi yéné ndimbal yuta a so wáwefnotat ta yéné sifayan.' ");
INSERT INTO nmx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ngánján a Ebraam si yéreinyéménd ghéngan néféghmén. Ebraam nénamndai Aiseke yárefé a ghéngan yanfai 8 efogh yáne áráfégh soramé. Soramé Aisek nénamndai Jeikofe yárefé, a Jeikof nénamndai 12 ambumafene yéferafé. ");
INSERT INTO nmx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jeikofene ambumam waramnjagh yafngoyénd yéfenngén Josef, yémofem fá yéramayénd Ijifét faiofnar ásáfogh ár. Wénde Ngánjánafé fá tárwén ");
INSERT INTO nmx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a Ngánjánam tambetau fá kétándmé méinyotio yánjo kértata. Farawa Ijifmén warsagh árom méndefé téfandau Josef ménamén Ngánjánam yaramai káfeté mwighé, yéné téfnan Farawam yémndai Ijif yu limánéghét a méinyotio yáne méngo. ");
INSERT INTO nmx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Féyo káukáu nuyai Ijif a Kanan yuwon, káukáuam yénérsam ndimbal yauyau njamke téfnan a téfene ákif njamkefnar náyátoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Njam Jeikof náyárayéng ndené rais kété tamorwén Ijifén, yémo ewáfáretam yáne ambum efe téfene náyátoyénd ákif fronde yafoghan. ");
INSERT INTO nmx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Yéfene yénamayo yafoghan, Josefém ewaufroi yánafet efe fá témorwén, a Farawa mat náyátoi Josefene mérénmén. ");
INSERT INTO nmx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yéné soramé, Josefem ewáfáretam yárefé Jeikofeyot a yáne méinyotio mérén, 75 méinyotio. ");
INSERT INTO nmx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Féyo Jeikof néwanoi Ijifét, ánde Jeikof a téfene ákif kér emormén. ");
INSERT INTO nmx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yéfene fifi enwangotaménd kétán Sekemét a ekmayénd mbéwé méngon Ebraamém árké yanayéng Amorene ambumta Sekemmén manie. ");
INSERT INTO nmx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Efogh kaka kénáyátotau Ngánjánam yánjo si efalo sái tiyátongai Ebraamefaf, téfene ár marat té náyáto Ijifén. ");
INSERT INTO nmx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Féyo totér warsagh ár efe mat yau témorwén Josefenemén nénamndai warsagh ár Ijifén. ");
INSERT INTO nmx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yémon yaufiyam tawafrotau téfene ár a tawasérmbotau téfene ákif wáfareghe tawáfáretau ménát yéfene totér ráfégh ambumtértér wighét krot. ");
INSERT INTO nmx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Yéné efghon Moses náráftam a Ngánjánene ghékfan fá kéretau mer ambum. Nambio ghérare kénjún yémon tarawenau yárefane méngon. ");
INSERT INTO nmx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Njam yémon yénmutoryéng, Farawane mérsom yérnyai yandio ambumot. ");
INSERT INTO nmx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses méinyotio káfeté mwighé yatametaménd Ijif árém a témorwén wafté kér ro sian a wafroghan. ");
INSERT INTO nmx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Njam Moses témorwén 40 yunjéf, yémon mwighé yaitotam yafoghét yánjo Israil árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Mosesém yinjoi ámb ár Israilmén Ijifmén árom tusérmbotau, féyo fá nuwanoi yá wáutárghét a fai wangoghét Ijifmén ár yésmetam. ");
INSERT INTO nmx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses kéma kemnau ndené yánjo árém kar so tayamngongayénd ndené Ngánjánam fá télimndau yéfe wanjarghét, wénde yémofem yau yáyámngoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ámb kwéfon Moses yénmormén sómbio Israilmén ár ewinjeyai ásméghan. Yémon yéta krufrát taramwéng yéné sie, 'Ár sómbár, fémro ere fútarfé, fém némamén nawaghanét?' ");
INSERT INTO nmx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Wénde yéné árom efe tusérmbotau yá fútar, yémon yéférngotai Moses téndot a norayai, 'Emo fém niyátoi limánégh árot a téfe ghékéf fayoghét? ");
INSERT INTO nmx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fémo yénd krot wafngo ndenéyame Ijifmén ár káye fémon yénau tésmete?' ");
INSERT INTO nmx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Njam Mosesém yéné si náyárai, fá nuwanoi Midian mbandot dábi náyátoi nawerai amaf sómbio ambumafé náyátoi. ");
INSERT INTO nmx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“40 yunjéf soramé, njafar si résagh ár nufaryéng Mosesefaf kéghat fés kánkékánké kénjúmé fanfne yuwon mband tunakéf yétkwén Sainai kaka. ");
INSERT INTO nmx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Njam Mosesém yéné fés yinjoyéng, fá sélngwél yémormén. Njamandio fá yéngmormén kaka fandaghét, yémon náyárai Yurane kém: ");
INSERT INTO nmx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Yénd wém Ngánján endeyot táwefnotawét féfene ákiam, Ebraam, Aisek, a Jeikof.' Moses ngernger témorwén férférafé fandaghét. ");
INSERT INTO nmx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Féyo Yuram yémndai, 'Tafitrar fenjo sandol, yéné sifayé ánde fém némakai siyém njúnnjúnofnar mband. ");
INSERT INTO nmx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yéndon té téfandan tane árfene tékrát Ijifén tekfifi. Yénd té kénáyáretan yéfene ye ke a yéné téfnan yénd néneworén yéfe wanjarghét. Sénonjo kuwano, yéndon so kémangon Ijifét.' ");
INSERT INTO nmx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Yéné Mosesyo féu yém efe yémofem yékenayénd yéné siafé, 'Emo fém téfene limánégh ár a ghékéf fayogh ár niyáto?' Ngánjánam yáfáretam yéfe limánéghét a wanjarghét, njafar si résagh ár kénjúmé efe nufaryéng yáfaf kéghatan. ");
INSERT INTO nmx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosesém enéutoryéng Ijifta, sélngwélafé yam a ufarogh yam tawafrotau Ijif kénjún, kété Férkat Árákafan a fanfne yuwon 40 yunjéf. ");
INSERT INTO nmx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Yéné Moses fiyém emo tawaufrotau Israil árét, 'Ngánjánam so yénmáfárete féfeyot Ngánjánene mat yátogh ár ndené yénd swém féfenjo árta.' ");
INSERT INTO nmx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Fá fiyém efe témorwén Israil árfé káumendawét fanfne yuwon; fá témorwén téfene ákiafé njam njafar si résagh ár efe korayau yáfaf Sainai Mband tunakfan, a yémon Ngánjánene akegh si ewinjoi a téfeyot ewafnamoi. ");
INSERT INTO nmx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Wénde téfene ákif yau námyoyénd wafroghét a yémofem yékenayénd a fá ménde tamorwén Ijifét angoghét. ");
INSERT INTO nmx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Yémofem yémndayénd Aron, 'Téfe ténmawafrota némbne ngánján efe so yém téfene limánégh ár. Ménamén yéné ár Moses emo yénmutoryéng yénd Ijifta, yénd mat yau yéném némé nufrotam yáfafǃ' ");
INSERT INTO nmx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Yéné efghon yémofem yafrotaménd unyéghunyégh mewang ndenanit kau. Yémofem ghéngén tanérsawét kétán a téménd yafrotaménd utmanéghafé némé yéfenjo ngángaye tafrotawét. ");
INSERT INTO nmx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wénde Ngánjánam sém ewawengoi a engéumyoi kénd, ghérare, a efogh wáwefnoghét. Ndenaye fété nátém némé té yéfarotaménd Ngánjánene mat yátogh árfene bukan, “'Fém Israilmén ár! Fémofem ta yau kwémarsati ghéngén a ramégh rokar 40 yunjfan fanfne yuwon. ");
INSERT INTO nmx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Fémofem té térsati Molek mewangoene némbne farai méngo a féfenjo ngánján Réfan kénd, árké mewangoe fémofem tawefnotati. Féyo yéndon so tawitrombon kétán Babilonét.' ");
INSERT INTO nmx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Téfene ákifem térsawét Farai méngo Ngánján ánde korayau fanfne yuwomé. Yéné ásáfogh témorwén Ngánjánam némé yauyafotam Mosese wafroghét. ");
INSERT INTO nmx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ámb yunjéf soramé, téfene ákifem emofem yanayénd farai méngo kétándmé yéferafafeta térsawét yémafé fá njam tayotau Josuwafé a yanayénd mband kétándmé ndimbal yuta árké Ngánjánam ewitérmboi yéfene sáfrére. A kété tékmangérwén kétánotio Deifidene efogh nawerai. ");
INSERT INTO nmx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Deifidém tayamnetau Ngánjánene ménde a yémotai ndené yéndon so yéfrendan Jeikofene Ngánjánene ámnjogh sifayé. ");
INSERT INTO nmx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wénde Solomon yémormén emo méngo yérametam yáyot. ");
INSERT INTO nmx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Wénde Minde tukén Ngánján yau yémor ár wafroghmén méngon. Ndené Ngánjánene mat yátogh ár noraye, ");
INSERT INTO nmx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“'Yuré noraye, 'Njafar siyém tane limánégh ámnjogh sifayé, a yéné mband siyém tane kafkaf enaghfaf. Fém féyotarofnar em méngo sái yérametati tayot. Yénd méndefnar wém tane enagh sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tane ngángayam ewafrotam méinyotio rokar.' ");
INSERT INTO nmx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Fém áyáréghofnar árǃ Fém sem tikéf táikér a téngan dudu efalo sifaf. Fém ndené fété em féferafaf kés em. Fémofem túmén Ngánján Mbérmbér yékarotatiǃ ");
INSERT INTO nmx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Féfene ákifem esmetaménd méinyotio Ngánjánene mat yátogh árǃ Ndenéyameyo yémofem esmetaménd fá efe korayawét Mbarkánd Ároene álighmén, Keriso efe fémofem yékenangi a yesmangi krotio. ");
INSERT INTO nmx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Fém yéné féyém Ngánjánene nák ewanayénd njafar si résagh ároene kénjúmé wénde yau námyoyénd wafroghét.” ");
INSERT INTO nmx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Njam stifén noyarai ndené, Ju sénko ár nékw nawérayénd a sén tangsotawét. ");
INSERT INTO nmx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wénde Stifen témorwén Ngánján Mbérmbér afoghkaf, njafar tuk téfandau a Ngánjánene ndimbal kwayaghé yinjoi, a Yesu takayongérwén Ngánjáne tambén. ");
INSERT INTO nmx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Fá norayai, “Kéretangi, yéndon yéfandan njafar tuk sauréghkaf a Ároene Ambum yakai Ngánjáne tambénǃ” ");
INSERT INTO nmx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Féyo Yémofem ngángaye ewamoyénd téngan a kutnawét tukén, méinyotio ár nénguférmoyénd yáfaf, ");
INSERT INTO nmx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","tutonawét tesenta a wíme tafiyátotawét. Yéné efghon ghékéf fandagh árém yéfenjo farun sáláme tafitérnawét a totér ambum Solene kafkaf mbanmbanan takmetawét. ");
INSERT INTO nmx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Njam fá tafiyátotawét wíme, Stifen Ngánjánafé koraiwét, “Yuré Yesu, tane mbérmbér tumyo.” ");
INSERT INTO nmx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Féyo Stifen budme niyai nutnai, “Yuré, kémawalindangé yéfene yaufiyam.” Fá njam norayai yéné, kér yémormén. ");
INSERT INTO nmx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol namyoi stifén tésmetawét kérotio. Yéné efghon ndimbal ngi marat namndai Jerusalem Yesuene mérénfaf, méinyotio efalo yátogh ár niroryénd Judian a Samarian, wénde Yesuene muyafé árro tamorangérwén Jerusalemén. ");
INSERT INTO nmx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ngánján férférafé árém Stifen yiyatotaménd mbandan a ghérghérsisé tamorwén minde. ");
INSERT INTO nmx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wénde Solém yiroréng Yesuene mérén. Fá téngmorwén méngot a ámb méngot, ár a amaf, taweretau a talawetau kwéfkwéf méngot. ");
INSERT INTO nmx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Fá efe nófarnayénd si táitotawét yénamé árkamé fá tayotawéng. ");
INSERT INTO nmx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filif nuwanoi tesenot Samaria yuwot a si táitotau Kerisoenemén kété. ");
INSERT INTO nmx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Njam tárfár árém tiyárawét Filif a téfandawét ufarogh yam yémon tawafrotau, fá káyáretawét merkéráye fá némé korayau. ");
INSERT INTO nmx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Yaufi mbérmbér kétonawét ár tárfár tambén kefé, a tárfár aknyégh ár a wawér ár mer táyátotau. ");
INSERT INTO nmx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Féyo ndimbal áuwéghafé tamorwén yéné tesenan. ");
INSERT INTO nmx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ár yétkwén Saimon kété témorwén emo ghar ngiyam tawafrotau ndimbal tesenan a méinyotio ár tawarsotau sélngwélafé yame Samarian. Fá kawarsau ndené minde waftafé kar témorwén, ");
INSERT INTO nmx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","a méinyotio ár yéné ndimbal tesenan, waftafé ár a waftafnar ár, yémofem tiyáretawét a yéné si korayawét ndenáye, “Yéné ár siyém minde waftafé yém Ngánjánam yéné wafté yaram.” ");
INSERT INTO nmx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yémofem fá táitotawét ménamén yémon sélngwélafé yam tawafrotau túmén yánjo ghar yame. ");
INSERT INTO nmx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wénde njam yémofem efalo yiyátoyénd Filif Ngánján limánéghmén mer si waitoghan a Yesu Kerisoene yétkwénmén, féyo ár a amaf nuan walitogh ewafngoi. ");
INSERT INTO nmx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimoném efalo yiyátoi a nuwan yálitotam. A Filif táitotau méinyotio yuwomé, árkamé tiotau sélngwél témorwén ménáyan ndimbal ufarogh yam a fénaté wafroghyam yémon tafandau. ");
INSERT INTO nmx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Njam Yesuene muyafé ár Jerusalemén náyárayénd nde Samaria méngotu árém Ngánjánene si té yumyongi, yémofem engwáfáreménd Fité a Jon kétán Samaria. ");
INSERT INTO nmx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Njam fá nufareyayénd, Ngánjánafé orayégh tafrowét totér efalo yátogh árfet ménát yémofem Ngánján Mbérmbér so tanangayénd, ");
INSERT INTO nmx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ménamén Ngánján Mbérmbér yau somé yénmormén yéné árfefaf, fronde fá té árém ewalitotaménd Yuré Yesuene yétkwénan. ");
INSERT INTO nmx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Fité a Jon ngángé fáyo ewafngeyayénd sénkoyan, yumyoyénd Ngánján Mbérmbér. ");
INSERT INTO nmx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Njam Saimoném yinjoi nde Ngánján Mbérmbér té yumyoyénd táf Yesuene muyafé árém ngángé efayeyayénd yéfefaf, yémon mani ewauyafeyai, ");
INSERT INTO nmx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ndené siafé, “Kwaramend yéné wafté ménát endefefaf yéndon téu efayotan tane ngángé so Ngánján Mbémbér ndenáyo yumyotatǃ” ");
INSERT INTO nmx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Fitam yawangoi, “Fém fenjo maniafayo so néngém tuot fését fémafayo, ménamén fém nemne Ngánján ramégh wafté kar manie résaghét yém! ");
INSERT INTO nmx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Fene sifayé yéna yau yém yéné ásáfoghan, ménamén fene tikéf yau yém mbarkánd Ngánjánene sáfrére. ");
INSERT INTO nmx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kawengo yéné yaufita a orayégh kufngo Yurafaf ménát so tawalindangé fene yaufi mwighamén. ");
INSERT INTO nmx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yéndon fém néfandan waramnjagh ár ném a fenjo yaufiyam némumbetat.” ");
INSERT INTO nmx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimoném yawangoi, “Orayégh kufngo Yurafaf tanemén ménát némé fém noraye yau so nufrote tafaf.” ");
INSERT INTO nmx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yéné soramé fá Yurane si kafrowét, Fité a Jon nangeyayénd Jerusalemét, mer si taitowét tárfár Samaria méngotuamé. ");
INSERT INTO nmx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yurane njafar si résagh ár norayai Filifefaf, “Kuwano náikái endét, yéné fanfne end kétándmé Jerusalemta kétán Gasa.” ");
INSERT INTO nmx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Féyo yémon áligh yérnyai, a néndkéfan yémon yéfángoi Etiofiyamén ár, mani wanjengégh sénko ár Kandake, yáne fifi warsagh amaf Etiofiyamén. Yéné ár téngmorwén kétán Jerusalemét wáwefnoghét, ");
INSERT INTO nmx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","a fá néngangoi méngotuot téfayongérwén osafene roagh kitarayan, taftau Ngánjánene mat yátogh ár Aisayane buk. ");
INSERT INTO nmx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ngánján Mbérmbéram yémndai Filif, “Kuwano kétán yéné osafene roagh kitarafaf a kaka kété fai némor.” ");
INSERT INTO nmx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Féyo Filif táf néngenngoi osafene roagh kitarafaf a yiyárayéng ár taftau Aisaya Ngánjánene mat yátogh ároene buk. Filifém yémotai, “Fém mat té náyátote némamén fémon yafte?” ");
INSERT INTO nmx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Fá norayai, “Yénd ndernáye mat so káyáton, táfandro ámb árom njam ta wawafena?” Féyo yéné téfnan yémon yumyoi Filif armboghét yémafé ámnjoghét. ");
INSERT INTO nmx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yéné Buk saté siyém yémo taftau, “Fá télimndawét sifnit kétán ngifaf, a sif tosanit síf néfégh téfnároene sáfrére siofnar, yémon yau yáne mbírmbír yasawéryéng. ");
INSERT INTO nmx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Fá yewonaménd a yanayénd yáne mbarkánd. Fá ambumofnar yémormén, féyo efe yau so noraye yáne ákiambumafenemén. Ménamén yáne ghérsé té yanayénd yéné mbandta.” ");
INSERT INTO nmx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Árom yémotai Filif, “Ta kwaufro, endenemén Ngánjánene mat yátogh ár norayai, yánjomén o ámb ároenemén?” ");
INSERT INTO nmx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Féyo Filifém waitogh yawafngoi yéné Aisayane Buk satayan a yaufroi mer si Yesuenemén. ");
INSERT INTO nmx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Njamandio fá tangérwén endmé, fá nufareyayénd nufaf a árom norayai, “Kéreta, nu siyém. Yénd ménde wém walitoghét.” ");
INSERT INTO nmx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A yémon yémndai wawerégh ár ose résaghmén kémboghét. Féyo Filif a ár nuwot neworeyayénd, a Filifém nuan yalitoyéng fá. ");
INSERT INTO nmx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Njam fá nénurteyayénd nuta, Yurane Mbérmbéram Filif táf fété yéngwanayéng, a ár yau yinjoi wéikor, wénde néngwanoi endmé áuwéghafé. ");
INSERT INTO nmx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wénde Filif nufaryéng Ajotus tesenot a téngmorwén mer si téngwaitotau méinyotio tesenamé kétánotio fá nufaryéng Kaisariat. ");
INSERT INTO nmx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol ménj térnyangérwén Yesuene waitogh ár ngiot. Fá néngwanoyéng limánégh ghéngén wárogh ároefaf ");
INSERT INTO nmx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a yémon yémotai férénot áumengégh méngofaf Damaskos ndimbal tesenan, ménát yémon njam tinjongai ámb ár a amaf emofem Yesuene End táitotawét, yémon so tangémnjau ndené fété kwéfkwéf méngo ár kétán Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Yémon njam kaka Damaskos yéngiyátoi álighan, táf fété njafarmén kwayaghayam yétremngoi a yarendai fá. ");
INSERT INTO nmx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Fá nuyáyéng mbandot a sioene kém náyárai ndené, “Sol, Sol, némamén yénd fémon wesmete?” ");
INSERT INTO nmx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol namotai, “Yuré, efe fém ném?” Yémon yawangoi, “Yénd wém Yesu, efe fémon yesmete. ");
INSERT INTO nmx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sénonjo kokai a kuwano ndimbal tesenot, a ár kété yém yémon so kénémndangé némé so fémon yafrote.” ");
INSERT INTO nmx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yéné ár emafé endmé tangmorwén Solfé nokayoyénd siofnar; fá náyárayénd sioene kém wénde yau efe yinjoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol nurtotam mbandta, wénde njam yémon ghékéf esawéryéng yémon némé yau ámb yinjoi. Féyo yémofem ngángayan yerayénd a téngémnjawét Damaskosét. ");
INSERT INTO nmx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nambio efogh fá ghékéf kwéfkwéf yémorangérmén, njamke nu yau enetam. ");
INSERT INTO nmx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskosén kété témorwén waitogh ár yétkwén Ananias. Yuram yémotai ghékéf waingéghe, “Ananiasǃ” Yémon yawangoi, “Wai, Yuré.” ");
INSERT INTO nmx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yuram yémndai, “Kuwano Judasene méngot Mbarkánd Endmé a kamota Tarsusmén ár yétkwén Sol, fá Ngánjánafé oraighan yém. ");
INSERT INTO nmx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ghékéf waingéghe yémon téfandau ár yétkwén Ananias ténmorwén yáfaf a ngángé efayoi a yáne ghékéf nasawéryénd a nawafarnjaménd wéikor.” ");
INSERT INTO nmx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiasém yawangoi, “Yuré, yéndon káyáretawén tárfár si yéné ároenemén ménamén yémon tékrát tawarametau fene árfet Jerusalemén. ");
INSERT INTO nmx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A fá téném yénan si muyafé limánégh ghéngén wárogh ároe tambén ménát yéfe werghét méinyotio efe norayat fene yétkwénan.” ");
INSERT INTO nmx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wénde Yuré norayai Ananiasefaf, “Kuwanoǃ Yéné ár siyém tane waferéghkaf ménát tane si résaghét Téndo árét a yéfene warsagh ár a Israilmén ár. ");
INSERT INTO nmx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yéndon so yauyafotan yáyot nderé mámáfi yémon so yáyarete tane yétkwén téfnan.” ");
INSERT INTO nmx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Féyo Ananias néngwanoi a nénglawayéng méngo kénjún. Ngángé efayoi Solefaf, fá norayai, “Fútar Sol, Yuré Yesu, efe nufar fefaf endén fém njam kéném endmé yénan, yénd yémon kwémáfárete ménát fém so ghékéf kéreta a kémafongé Ngánján Mbérmbéram.” ");
INSERT INTO nmx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Táf fété ndélindnit nuyai Solene ghékéfta, a néretai. Fá nokayoi a nuan yálitotam, ");
INSERT INTO nmx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","a yáne njamke soramé, yáne muyé nawafarnjam kétánotio. Sol yémorangérmén ámb efogh waitogh árfé Damaskosén. ");
INSERT INTO nmx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Yémon táf fété si waitogh yérnyai áumengégh méngon ndené Yesu siyém Ngánjánene Ambumǃ ");
INSERT INTO nmx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Efe méinyotio náyárayénd sélngwél emorméng a namotayénd, “Yéné ár fiyém emo tásmetau Yesuene waitogh ár Jerusalemén. Fá fété téném waitogh árfet werghét ndené fété kwéfkwéf méngo ár limánégh ghéngén wárogh árfefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Solene si waitogh minde waftafé káyátotau a Ju ár féyotarofnar tamorwén Fole wawangoghét Damaskosén ménamén yémon tawauyafotau Yesu siyém Keriso. ");
INSERT INTO nmx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tárfár efogh soramé, ámb Ju árém mwighé táitotawét Sole ngiot, ");
INSERT INTO nmx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","wénde Sol mat náyátoi yéfene mwighé. Efogh sémbár fá kumnjotawét tesen sésafnen Sole ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Wénde yánjo waitogh árém yanayénd Sol sémbáran a ndimbal yáfe tewonawét tesen áráke sémta. ");
INSERT INTO nmx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Njam Sol yénmormén Jerusalemét, fá yéta karametau ufnyéghét waitogh árfefaf, wénde fá méinyotio férfér tamorwén yánemén, yémofem efalo yau tiyátotawét nde fá fété yém waitogh ár. ");
INSERT INTO nmx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Wénde Banabasém yénmasroi Sol kétán Yesuene muyafé árfefaf. Banabasém ewaufroi yéfe ndernáye Solém endén yinjoi Yuré a norayai Yuré yáfaf, a ndernáye Damaskosén yémon si táitotau férférofnar Yesuene yétkwénan. ");
INSERT INTO nmx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sol a Yesuene muyafé árfé tamorangérwén kimndawét férférofnar Jerusalemén, korayau férférofnar Yurane yétkwénan. ");
INSERT INTO nmx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol korayau a kéwitawét Grik si Ju árfé, wénde yémofem yéta ngiot térametawét. ");
INSERT INTO nmx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Njam efalo yátogh ár mat náyátoyénd yénémamén, yémofem yéngwasroyénd Sol Kaisaria tesenot a yéngwatembayénd Tarsus tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Féyo Yesuene mérén yénamé Judia, Galili yu a Samaria, yémofem tayamnetawét krufrát yéné efghon. Ngánján Mbérmbéram tawáutánau muyafé sái kamndangayénd, ár tárfár káyátotawét a Yurane férférafé tamorangérwén. ");
INSERT INTO nmx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Njamandio Fité karendau ámb yuwomé, fá kété néngwanoi Ngánjánene efalo yátogh ár yafoghét Lida méngotuot. ");
INSERT INTO nmx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kété yémon yinjoi ár yétkwén Enias, aknyégh ár efe yéknyangérmén 8 yunjéf. ");
INSERT INTO nmx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Fité norayai yáfaf, “Enias, Yesu Kerisom fém mer so kényátonga. Kokai a fenjo yame tékna.” Táf fété Enias nokayoi. ");
INSERT INTO nmx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Méinyotio efe kété tamorangérwén Lidan a Saronén, fá yinjoyénd a awengogh nufngoyénd Yurafaf. ");
INSERT INTO nmx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jofa tesenan kété témorwén waitogh ár amaf yétkwén Tabita, Grik yétkwéne siyém Dorkas, emo túmén tawafrotau mer yam a tawáutánau yauyau ár. ");
INSERT INTO nmx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Yéné efghon amaf enjne nawerai kér yémormén, a yáne fifi nue yumbnaménd a yarmboyénd méngo kénjút. ");
INSERT INTO nmx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida méngotu témorwén Jofa tesen kaka, féyo njam waitogh ár náyárayénd ndené Fité témorwén Lida méngotuan, yémofem ewáfáreménd sómbio ár yáfaf a taufrend yá, “Wékeye álighét.” ");
INSERT INTO nmx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Fitaf néngwanoyénd yémafé, a njam fá nufaryénd, fá néngarmboi méngo kénjút. Méinyotio kwiram yarendayénd fá, ye kendawét a tauyafongi sáláme a ámb sáláme Dorkasém árké enamndam njam yémafé mé ghérsé tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fitam fá méinyotio eutonam méngo saté kénjúta, féyo fá budme niyai a Ngánjánafé koraiwét. Nde fá néngawengoi kér amafoefaf, fá norayai, “Tabita, kano.” Táf fété Amafom ghékéf ensawéryéng, a féyo amofom yéfandayéng Fité a námnjoi. ");
INSERT INTO nmx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yémon ngángayan yérai a yamarotai okayoghét. Féyo yémon emotayéng Yesuene efalo yátogh ár a kwiré, ewauyafoi yéfeyot ghérsé amaf. ");
INSERT INTO nmx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kér anoghmén si marat náyátoi yénamé Jofa tesenamé a tárfár árém efalo Yuré yiyátoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Fité yémorangérmén Jofa tesenan tárfár efogh yémafé wérár ghéngan watorégh árfé yétkwén Saimon. ");
INSERT INTO nmx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisaria tesenan ár yétkwén témorwén Konelias, Rom fiyarafene sénko ár emo tawanjetau 100 fiyaré yéné yétkwén siyém Italiamén fiyaré mérén. ");
INSERT INTO nmx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Fá méinyotio yánjo mérnafé tamorwén Ngánján férférafé ár a wáwefnogh ár; yémon tawarametau rokar marataye yéfe áronjagh árfet a túmén Ngánjánafé koraiwét. ");
INSERT INTO nmx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ámb efghon séite witmé karéf 3 aklokan yáfaf nofatanam ghékéf waingégh yam. Yémon yinjoi Ngánjánene njafar si résagh ár, efe yénmormén yáfaf a yémndai, “Koneliasǃ” ");
INSERT INTO nmx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koneliasém yinjoi férférafé a yémotai, “Némé yém, Yuré?” Njafar si résagh árom yawangoi, “Ngánján náuwéte fene Ngánjánafé orayéghmén a rokar raméghmén yauyau árét. ");
INSERT INTO nmx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sénonjo ár tawáfáreta Jofa tesenot ár yétkwén Saimon yá wangoghét efe ámb yétkwén yanmotat Fité. ");
INSERT INTO nmx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Fá tamorarwén Saimonfé, wérár ghéngan watorégh árofé, endene méngo arakaf téndon témorwén.” ");
INSERT INTO nmx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Njam njafar si résagh ár efe korayau yáfaf néngolindai, Koneliasém ewanmeyai yáne sómbio faiofnar ásáfogh ár a Ngánján férférafé fiyaré. ");
INSERT INTO nmx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Koneliasém si ewaufrotam yéfeyot méinyotio némé kufrotau yáfaf a soramé engwáfáretai fá Jofa tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ámb efghon séite karéfta Koneliasene faiofnar ásáfogh ár tangmorwén endmé a kaka tengiyátotawét Jofa ndimbal tesen, Fité narmbotam méngo semsotot ámnjogh sifayat Ngánjánafé orayéghét. ");
INSERT INTO nmx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Fité siogham yifoi njamke nénet, a njam njamke frengéghkaf tamorwén, yémon ghékéf waingéghe téfandawéng ámb yam Ngánjáneta. ");
INSERT INTO nmx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yémon yinjoi njafar nasawéryéng a ámb yam ndené kéretau marat sálámenit kénewonau fo mband kwéndkwénd féyotaroyan. ");
INSERT INTO nmx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yéné marat sálámeyan kété tamorwén méinyotio fénataye wérár a fute aroghagh wérár a men. ");
INSERT INTO nmx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Féyo Ngánján norayai yáfaf, “Kokai, Fité. Fémon tásmeta a eneta.” ");
INSERT INTO nmx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Fitam yawangoi, “Yau, Yuré. Yéndo yaufifi enetamén tayot ufi yém.” ");
INSERT INTO nmx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ngánján norayai yáfaf wéikor ndené, “Yau. Fémo so enete. Yau noraya ndené mámáfi em némé Ngánjánam ewafrota mer.” ");
INSERT INTO nmx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yéné yam nufrotam nambinotma, a táf fété yéné sáláme yénamayo nangoi njafarot. ");
INSERT INTO nmx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Njam Fité mé katambnau ghékéf waingéghoene fifimén, ár engwáfáretam Koneliasém fá namotayénd ánde Saimonene méngo yém a nékmboyénd méngo sésafnefaf. ");
INSERT INTO nmx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Fá namotayénd, “Yéna wan téfnár yém yáne yétkwén Saimon Fité?” ");
INSERT INTO nmx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Njam Fité mé kemnau yéné ghékéf waingéghmén, Ngánján Mbérmbéram yémndai, “Saimon, nambio árém fém néronjat. ");
INSERT INTO nmx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Féyo kokai a kewor. Yau nautémnda yémafé álighét, ménamén yéndon tanwáfáretan fá.” ");
INSERT INTO nmx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Fité néneworyéng a yéné ár emndai, “Yénd yéné fwém fémofem efe yéronjati. Némamén fém taném?” ");
INSERT INTO nmx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yéné árém yawangoyénd, “Yénd téném kétándmé Konelias Rom fiyaré sénko ároe tambén. Fá siyém mbarkánd a Ngánján férférafé ár, efe yutémndat méinyotio Ju árém. Njúnnjúnofnar njafar si résagh árom yémndai ár tangwáfáreta yáne méngot ménát yémon so niyárete némé fém so noraye.” ");
INSERT INTO nmx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Féyo Fitam eumyoi yéné ár yáne méngot. Féyo yáne wan téfnár náyátoyénd. Ámb efghon Fité káfrendau yémafé álighét, a ámb efalo yátogh ár kétamamén Jofa tesenmén néngwanoyénd yémafé. ");
INSERT INTO nmx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ámb efghon Fité nufaryéng Kaisaria tesenot. Konelias kawanjetau yáyot a eumendai méinyotio yáne mérén a kaka fútaréf. ");
INSERT INTO nmx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Njam Fité nénglawai méngot, Koneliasém yéfángoi a yáwefnoi yáne kafkafot utmanéghafé. ");
INSERT INTO nmx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wénde Fitam yéméindai fá anoghét a yémndai, “Kokai, yau wáwefnota tayot. Yénd ndené fété wém fém yéf ném.” ");
INSERT INTO nmx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Fité a Konelias koraiwét, yéné soramé Fité nénglawai méngo kénjút ewinjoi ár mérén. ");
INSERT INTO nmx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Fité norayai yéfefaf, “Fém Téndo ár mer mat em téfene Ju árfene nák, Ju ár yau so Téndo árfene méngot nélawetat a nawaréindat Téndo árfé. Wénde Ngánjánam ta té wauyafoi yéndon efe yau so kénkarotangén ndené fém ném yaufi o njúnnjúnafé. ");
INSERT INTO nmx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yénémamén njam fémofem tangwáfáretati tafaf, yénd kwéném ámoghofnar. Yénd namotan féfefaf, 'Némamén yénd fémofem kwarawetati?'” ");
INSERT INTO nmx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Koneliasém yawangoi, “Fo efogh soramé yénd kwémorwén tanjo méngo kénjún Ngánjánafé oraighan yéné efoghféneféneyan, 3 aklok séite karéf. Sunsune ár nufaryéng álálégh sálámeyafé tane sáfrére. ");
INSERT INTO nmx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","A njafar si résagh ár norayai, 'Konelias, Ngánján té náyáré fene Ngánjánafé orayéghmén a némawafarote fene rokar raméghmén yauyau árét. ");
INSERT INTO nmx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ár tawáfáreta Jofa tesenot Saimonefaf efe yanmotat Fité. Fá siyém wan téfnár Saimon, wérár ghéngan watorégh ár, endene méngo yém arakaf téndon.' ");
INSERT INTO nmx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Féyo yéndon tangwáfáretan feyot táf fété, a nderé mer yém fém kés kéném. Sénonjo yénd méinyotio yéna yéném Ngánjánene sáfrére ménát méinyotio si áyárghét Yuram fém kénmáfárete téfe waufroghét.” ");
INSERT INTO nmx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Féyo Fitam si yérnyai: “Yéndon sénonjo yáyamngon efalo yém Ngánjánam yau yuyafote witmaro ménde yam ");
INSERT INTO nmx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","wénde eumyote ár méinyotio yumén emofem férférafé yéfandat fá a ewafrotat némé yém mbarkánd. ");
INSERT INTO nmx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Fém si mat em Ngánjánam yénmáfáretam Israil árfefaf, táitotau mer si krufrátmén Yesu Keriso kénjúmé, efe Yuré yém méinyotio árét. ");
INSERT INTO nmx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Fém mat em némé kufrotawét Judia kénjúmé, nénarnyai kété Galili yuwon walitogh soramé Joném si táitotau. ");
INSERT INTO nmx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ndernáye Ngánjánam yaferyéng Yesu Najaretmén Ngánján Mbérmbére a waftaye, a ndernáye fá tiyotawéng mer tawafrotau a mer táyátotau méinyotio fá efe tamorwén Sáifroene wafté mbanmbanan, ménamén Ngánjánafé fá tárwén. ");
INSERT INTO nmx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Yénd fandagh ár yéném méinyotio yammén yémon stawafrotau Ju yuwon a Jerusalemén. Yémofem yésmetaménd fá yénamayo yamayénd wafatarégh wénan, ");
INSERT INTO nmx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","wénde Ngánjánam yanoi fá kérta nambio efogh soramé ménát fandaghét, ");
INSERT INTO nmx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","méinyotio árém yau yinjoyénd, wénde fandagh árémro efe Ngánjánam tándái ewaferyéng, ndené yénd emafé tánetawém njamke a nu yémafé soramé fá nanoi kérta. ");
INSERT INTO nmx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yémon yénémndayéng yénd si waitoghét árét a afroghét ndené fá siyém ámbiro efe Ngánjánam yaferyéng ndené fété mogh ár ghérsé a kér árét. ");
INSERT INTO nmx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Méinyotio Ngánjánene mat yátogh árém nafrotat yánemén ndené méinyotio árém emofem efalo yiyátotat fá tawalindangé yéfene yaufimén yáne yétkwén kénjúmé.” ");
INSERT INTO nmx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Njamandio Fité mé korayau yéné si, Ngánján Mbérmbér néneworyéng yéfefaf efe méinyotio káyáretawét yéné si. ");
INSERT INTO nmx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ju efalo yátogh ár efe té nénuwanoyénd Fitafé sélngwél emormén ndené Ngánján Mbérmbéroene tambén té nasuryéng ndenéyameyo Téndo árét, ");
INSERT INTO nmx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ménamén yémofem táyáretawét fá ámb yumén sie korayawét a tuwetawét Ngánján. Féyo Fité norayai, ");
INSERT INTO nmx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Yémofem té yanangi Ngánján Mbérmbér ndené fété yéndfem. Árké árom yau so takmbongé nu walitoghét.” ");
INSERT INTO nmx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yénémaménnde yémon emndai fá fété so ewalitote Yesu Kerisoene yétkwénan. Féyo yémofem yamnendayénd Fité ámnjoghét yémafé nambio efghotro. ");
INSERT INTO nmx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesuene muyafé ár a efalo yátogh árém Judia yuwomé náyárayénd ndené Téndo árém ndenéyameyo yanangi Ngánjánene si. ");
INSERT INTO nmx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Njam Fité néngwanoyéng Jerusalemét, Ju efalo yátogh árém tanangotawét fá ");
INSERT INTO nmx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","a norayai, “Fém tangém Téndo árfene méngot a yémafé tánetati njamke.” ");
INSERT INTO nmx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Fitam tawaufrotau méinyotio si yéfefaf némé kété kufrotau kétándmé ufrogh, ");
INSERT INTO nmx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yénd kwémorwén ndimbal tesenan Jofan Ngánjánafé oraighan, a yéndo yinjoyén ghékéf waingégh yam. Yéndon yinjoyén ámb rokar ndenanit marat sáláme kénewonau kétándmé njafarta fo kwéndkwéndafé, a kénewonau kétán yénd ánde kwémorwén. ");
INSERT INTO nmx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Yénd néngretayén kénjút ewinjoyén fo ghambérafé wérár, munjan wérár, fute aroghagh wérár a men. ");
INSERT INTO nmx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yénd náyárayén si kwémndetau ndené, 'Kokai, Fité. Tásmeta a táneta.' ");
INSERT INTO nmx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Yénd nuwangoyén, 'Yau, Yuré. Njúnnjúnafé a fenjfenjafé wérár yau nélawai tane sénfnet.' ");
INSERT INTO nmx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ngánján norayai kétamé njafarta wéikor, 'Yau. Fémo so enete. Yau noraya ndené mámáfi em némé Ngánjánam ewafrota mer.' ");
INSERT INTO nmx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yéné yam kufrotau nambinotma, a yéné sáláme yénamayo nangoi njafarot wéikor. ");
INSERT INTO nmx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Táf fété nambio ár efe enwáfáretaméng tafaf kétándmé Kaisaria tesenta nékmboyénd méngon ánde yénd kwémorangérwén. ");
INSERT INTO nmx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ngánján Mbérmbéram wémndayéng yau nautémnda álighét yémafé. Yéné siks fútarfé ndenáyo nénuwanoyém yéndfé, a yénd nénglawayém Rom fiyaré sénko ár Koneliasoene méngot. ");
INSERT INTO nmx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Koneliasém yénmaufroi téfe ndernáye yémon yinjoi njafar si résagh ár yane méngon a yéné njafar si résagh ár norayai, 'Ár ewáfáreta kétán Jofa tesenot Saimonefaf efe yanmotat Fité. ");
INSERT INTO nmx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Fitam so féfe enwarse si árké kénjúmé fém a méinyotio mérén so kawanjarngi.' ");
INSERT INTO nmx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Njamandio yéndon yérnyayén si, Ngánján Mbérmbér yénmormén yéfefaf ndenéyameyo ndernáye yémormén téfefaf frondeyan. ");
INSERT INTO nmx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Féyo yénd nawafarotayén némé Yuré norayai, 'Joném tawalitotau nue, wénde fém so ewalitote Ngánján Mbérmbére.' ");
INSERT INTO nmx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kwayaghayan yéné yém ndené Ngánjánam ewaramai yéfe ndené sáfot tambén téfe sinmaramai, emofem efalo yiyátoyém Yuré Yesu Keriso; yénémamén yéndo yau so tékmbongayén némé Ngánjánam tafrotau.” ");
INSERT INTO nmx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Njam fá náyárayénd yénémamén, fá nékmboyénd éwigh a Ngánjánro tuwetawét, korayawét, “Féyo Ngánjánam mwighé ewaramai Téndo árét yaufita awengoghét ghérsat.” ");
INSERT INTO nmx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Fá efe té nófarnayénd ménáyan Stifenene ngian soramé eyotaméng ndenáye Fonisiya, Sáifras, a Antiok, tawaufrotawét si Ju árfetro. ");
INSERT INTO nmx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wénde ámb ár kétamamén Sáifras a Sairene tesenmén, nuwanoyénd kétán Antiokét a si yérnyayénd Téndo árét, yéfe tawaufrotawét mer si Yuré Yesuenemén. ");
INSERT INTO nmx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yurane ngángé témorwén yéfefaf, a tárfár téndo árém efalo yiyátoyénd a nawengoyénd yéfene yaufita Yurafaf. ");
INSERT INTO nmx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Njam Yesuene mérén náyárayénd Jerusalemén yénémamén ndené tárfár téndo ár nawengoyénd Yurafaf, féyo yémofem yéngwáfáretaménd Banabas kétán Antiok tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Njam fá néngufaryéng a yinjoyéng Ngánjánene frengégh, fá áuwéghan témorwén a tawawéngsotau fá méinyotio ménát efalo sái em Yurafaf méinyotio yéfenjo tikfe. ");
INSERT INTO nmx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas témorwén mer ár, Ngánján Mbérmbérafé a ndimbal mwighé wafoghkaf, yémon tárfár ár tánémnjau kétán Yurafaf. ");
INSERT INTO nmx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Féyo Banabas nuwanoyéng kétán Tarsus tesenot Sole ronjaghét, ");
INSERT INTO nmx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","a yémon njam yinjoi Sol, Banabasém yénmasroi fá kétán Antiok tesenot. Ámbiro méinyo yunjéf, Banabas a Sol tafángowét Yesuene mérén a tawatamewét tárfár ár. Waitogh ár tawanmotawét árém frondefifi Kerisoene ár Antiok tesenan. ");
INSERT INTO nmx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Yéné efghon ámb Ngánjánene mat yátogh ár tanmorwén kétándmé Jerusalemta Antiok tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ámb ár yétkwén Agabus nokayoyéng Ngánján Mbérmbér kénjúmé norayai ndené minde káukáu so marataye yém Rom yuwon. (Yéné nufrotam táf Klaudiusene limánégh efghon) ");
INSERT INTO nmx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Waitogh árém mwighé yéfaronaménd wáutárghét yéfe fútarét efe tamorangérwén Judia yuwon. ");
INSERT INTO nmx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Yémofem eumendaménd mani a eramayénd kétán Banabas a Sol, emofem engérsaménd kétán sénko árfefaf Judia yuwon. ");
INSERT INTO nmx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Yéné efghon warsagh ár Erodém ewerai ár Yesuene mérénmén kemnau yéfe ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Erodém fiyaré ewafáretai Jone yánngén Jemse ngiot witmafé sénté naifaye krot. ");
INSERT INTO nmx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Njam Erodém Jems kérotio yésmetam káuwétawét Ju ár, féyo néngwanoi Fité werghét wéikor. Yéné kufrotau táf Minaghofnar flawé témndan. ");
INSERT INTO nmx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Werégh soramé, Erodém yénglawai Fité kwéfkwéf méngot, yéngwafnamoi 4 fiyaré mérén kénjúmé ámbiro mérnan 4 fiyaré tamorwén, méinyotio 16 fiyaré. Erod nemnai yá utorghét moghét yéné Waingégh téménd soramé. ");
INSERT INTO nmx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Féyo Fité kwéfkwéf méngon télawangérwén, wénde Yesuene mérén ndimbal kéráye oraighan Ngánjánefaf tamorwén yánemén. ");
INSERT INTO nmx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yéné sémbáranyo Erodém mwighé yéfaronam yáfaf sái ténémnjawét moghét, Fité tékmangérwén sómbio fiyarafene néndkéfan, sómbio seinafé, ámb ghékéf fayogh ár tawakayarwén sésafneyan. ");
INSERT INTO nmx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sunsune Yurane njafar si résagh ár nufaryéng kwayaghé natremngoi kwéfkwéf méngo kénjún. Yémo yésmai Fité kwasayan a yanoyéng a témndangé “Kano wékeyeǃ” a sein nuyáyénd Fitane ngángata. ");
INSERT INTO nmx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Féyo njafar si résagh árom témndangé fá, “Kawo fenjo sáláme a sandol.” A Fitam ewafrotam yéné yam. Njafar si résagh árom yémndai, “Fenjo sálámeye káfyar a kwénmaito.” ");
INSERT INTO nmx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Fitam yéngwaitoi néngtoreyayénd kwéfkwéf méngota, wénde fá yau mat témorwén némé njafar si résagh árom tafrotau wénde fété kufrotau; fá kéma kemnau nde ghékéf waingégh kar témorwén. ");
INSERT INTO nmx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Yémofem engwaindangeyayénd frondemén a yénamayomén ghékéf fayogh ár mérén a nénafleyayénd tot téfén sésafnefaf árké end témorwén ndimbal tesenot. Fáyo nasawéryéng yéfeyot, a néngwaneyayénd endmé. Fá njam tangérwén yéné endmé, sélngwéle njafar si résagh árom yéfrangoi. ");
INSERT INTO nmx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Fité mwighat nangoi a norayai, “Sénonjo mat náyáton atambaréghofnar nde Yuram ténmáfárete njafar si résagh ár ta wanjarghét kétándmé Erodene ngángata a kétándmé méinyotio Ju árfene kamnangta.” ");
INSERT INTO nmx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Njam yémon yéné yáyamngoi, fá nuwanoi Meriene méngot Jon Make yátmé, ánde tárfár ár káumendawét Ngánjánafé orayéghét. ");
INSERT INTO nmx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Fité áutárégh kufngongé sésafneyan, a ásáfogh mérés yétkwén Roda néngaflai sésafnefaf uwangoghét. ");
INSERT INTO nmx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Njam mérsom yáyamngoi Fitane kém, mérés yémormén áuwégham yáindai, fá néngangoi wérseye sésafne sauréghofnaye a néngorayai, “Fité sésafnefaf yémǃ” ");
INSERT INTO nmx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yémofem témndangi, “Fe mwighayam némauwéinde!” Njam fá mé kafrotau ndené efalo fété yém, fá norayayénd, “Mété táf njafar si résagh ár yém yá wáutárghét.” ");
INSERT INTO nmx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Wénde Fité ménjtaye mé káutanau. Njam yémofem sésafne yésawéryénd a yinjoyénd Fité, fá sélngwél emormén. ");
INSERT INTO nmx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Fitam ngángaye engwaunyai métar a tawawalinjotau ndernáye Yuram yénmutoryéng kwéfkwéf méngota. Fá norayai, “Tawaufrongi Jems a ámb fútarét yénémamén.” A féyo fá táf nuwanoi ámb yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ámb akwan kété ndimbal atambarégh témorwén fiyarafefaf némé nufrotam Fitafaf. ");
INSERT INTO nmx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Soramé Erodém yéta ronjagh yafngoi wénde yau yinjoi Fité, yémon mogh ghékéf fayogh ár ewafngoi a krot takmetau. Féyo Erod néwanoi kétándmé Judia yuta Kaisaria tesenot féyo kété témorangérwén. ");
INSERT INTO nmx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erod nékw témorwén Taire a Sidon Yumén árfefaf, yénémamén fá nuwanoyénd mérne Erode fandaghét. Fronde yémofem yamnendayénd Blastus, Erodene méngo wanjéngégh sénko ár ménát yéfe wáutárghét. Féyo fá nuwanoyénd Erodefaf a yamnendayénd yau so ménjtaye tékmbotau njamkemén ménamén túmén Taire a Sidon Yu tarsawét njamke warsagh ár Erodene ndimbal yuta. ");
INSERT INTO nmx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ufoghmén kwéfon Erod numanetaméng yáne yétkwén sáláme, námnjoi yánjo limánégh ámnjogh sifayan a marataye si térametau árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Fá nutnayénd, “Yéné siyém ngánjánene si kém, yau ároene.” ");
INSERT INTO nmx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Táfandio, ménamén Erodém áuwégh yau tawangotau Ngánjáne, féyo Yurane njafar si résagh árom yésmai fá, féyo Erod ndéndam néne yafngoyénd a kér yémormén. ");
INSERT INTO nmx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Wénde Ngánjánene si mulmulafé kanotau a marat káyátotau. ");
INSERT INTO nmx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Njam Banabas a Sol yéfenjo ásáfogh yifeyayénd, fá kénangowét kétándmé Jerusalemta kétán Antiokét yémafé Jon Mak. ");
INSERT INTO nmx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokén Yesuene mérén kénjún kété tamorwén Ngánjánene mat yátogh ár a watamegh ár. Fá tamorwén Banabas, Saimon kwéfité ár, Luses Sairia tesenmén, Manayen(efe Erodene kaka fútar témorwén), a Sol. ");
INSERT INTO nmx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yémofem njam táwefnotawét Yurai awafarmanéghafé, Ngánján Mbérmbér norayai, “Tafalend tayot Banabas a Sol ménát ásáfoghét yéndon árké ménát ewafereyayén.” ");
INSERT INTO nmx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Féyo yéfene awafarmanégh a Ngánjánafé orayégh soramé, yémofem ngángé efayoyénd yéfefaf a nuwaneyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Fá sómbio nuwaneyayénd yéfenjo endmé Ngánján Mbérmbéran, nuwaneyayénd kétán Selusia tesen a karaiwét kétándmé kétán Saifrus tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Njam fá nufareyayénd kétán Salamis tesenot, yémofem Ngánjánene si waitogh yafngeyayénd Ju árfene áumengégh méngomé. Jonfé tamorwén yéfene wáutárégh ár. ");
INSERT INTO nmx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Fá karendawét méinyotio yuwomé kétánotio nénufaryénd Fafos méngotuot. Kété yémafé nafángoyénd Bar-Yesu. Fá témorwén Ju ghar téfnár a unyégh si afrogh ár. ");
INSERT INTO nmx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Fá yáyot kásáfotau Sargius Faulus, efe témorwén minde matyamafé a témorwén Rom fiyarafene sénko ár yéné yuwon. Sargius Faulus ménde témorwén Ngánjánene si áyárghét a yémon ewáfáretam yéfefaf Banabas a Sol. ");
INSERT INTO nmx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wénde ghar téfnár Elimas (yéné siyém Bar-Yesuene yétkwén fifi yém) taufotau a yéta tawengotau gafanane ndimbal mwighé. ");
INSERT INTO nmx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Féyo Sol, efe tanmotawét Fol, Ngánján Mbérmbér wafoghkaf, néretai mbarkánde yáfaf Elimas a korayangé, ");
INSERT INTO nmx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Fém sném Sáiférene ambum a méinyotio mbarkándoene mék téfnárǃ Fém sném méinyotio yaman warsogh ár a unyégh ár. Kékmbo, Yurane mbarkánd yamta yau ewasemna ár unyéghe! ");
INSERT INTO nmx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sénonjo Yurane nékwam so kémanangé. Fém so ném ghékéf kwéfkwéf, a yéné efghétro fémon yau so yéfande efghoene kwayaghé.” Táfandio esam a kwéfkwéfam yafaryéng fá, a fá korsotau yénémamén káronjau árot ménjághét. ");
INSERT INTO nmx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Njam Rom fiyarafene sénko árom yinjoi némé kufrotau, fá sélngwél yémormén Ngánjánene si watameghan, yémon táf efalo yiyátoi Yuré. ");
INSERT INTO nmx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kétándmé Fafosta, Fol a yáne mérnafé tayotawét ndimbal boute kétán Fargat Famfilia kénjún, wénde Joném efrangoi a kangotau kétán Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kétamé Fargata fá nuwanoyénd Antiok tesenot Fisidia ndimbal yuwon. Safatan fá nélawayénd áumengégh méngot a námnjoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mosesene nák a Ngánjánene mat yátogh árfene si wafégh soramé, Ju árfene áumengégh méngo limángégh árém si yéngwatembayénd yéfefaf, “Fútaréf, njam féfefaf wawéngsogh si yém yéné árét, féyotaro korayangi.” ");
INSERT INTO nmx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Fol nokayoyéng, ngángé euyoi a tamndangé, “Israilmén ár a fém Téndo ár emofem Ngánjáne yáwefnotati, kénáyárangi tafafǃ ");
INSERT INTO nmx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israil árfene Ngánjánam ewaferyéng téfene ákif a marat ár eyátoyéng táf fá stamorangérwén Ijif kénjún, a Ngánjánam yánjo waftaye eutoryéng, elimai fá yéné yuta, ");
INSERT INTO nmx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","fá mé kawamarotau yéfene yaufiyaman kétánotio 40 yunjéf fanfne yuwon, ");
INSERT INTO nmx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","yémon ewasérmbotam sefen ndimbal yu Kananén a mband ewaramai yuré náyátoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Méinyotio yéné yamam yénérsam 450 yunjéf. “Yéné soramé, Ngánjánam ewaramai yéfe mogh sénko ár kétánotio Ngánjánene mat yátogh ár Samuelene efogh nawerai. ");
INSERT INTO nmx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Fá nómnendayénd warsagh árot, a yémon ewaramai Kisene ambum Sol, Benjamin mérénmén, emon elimndam 40 yunjéf. ");
INSERT INTO nmx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Wénde Ngánjánam Sol yitérmboi a yémon yasoi Deifid yéfene warsagh árot. Fá norayai yánemén, 'Yéndon yinjoyén Deifid Jesiene ambum, yéné ár efe tane tikéfmén yém, yémon so ewafrote méinyotio yam tane ménde némat yém.' ");
INSERT INTO nmx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kétándmé yéné ár mérénta Ngánjánam enwarsam Israil árét Ghérsé urtogh ár Yesu, ndené fété fá nénorayai unyéghofnar si. ");
INSERT INTO nmx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Soramé Yesuene ufarégh, Joném fronde si táitotawéng yaufiyam awengoghmén a nu walitoghmén méinyotio Israil árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Joném njam yáne ásáfogh tifotau, yémon tamndangé, 'Fém ndernáye nemnati yénd efe wém? Yénd yau wém Keriso. Wénde fá siyém ta soramé yéném, endene sandol ferghét yénd féyotarofnar wém.' ");
INSERT INTO nmx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Fútaréf, Ebraamene ambumtértér, a fém Ngánján férférafé Téndo ár, téfeyot yéné wanjarégh si ténmáfáretat. ");
INSERT INTO nmx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalemén ár a yéfene limánégh árém yau yáyámngoyénd Yesu endenemén Ngánjánene mat yátogh ár kénorayawét. Wénde yémofem ngi yafngoyénd Yesu, yéné si efalo káyátotau némé Ngánjánene mat yátogh árém kénorayawét árké taftawét méinyotio Safatan. ");
INSERT INTO nmx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yémofem yau yinjoyénd téfén yáne krot, wénde yémofem yamnendayénd Failet yá ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Njam yémofem ásáfogh yafrotaménd méinyotio yéné bukan árké tékayarwén yánemén, yémofem yeworyénd wafatarégh wénta a yélawayénd mbéwé méngon. ");
INSERT INTO nmx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wénde Ngánjánam yanoi fá kétándmé kérta, ");
INSERT INTO nmx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","a tárfár efogh fá nufaryéng yéfefaf emafé tayotau kétándmé Galili yu kétán Jerusalem. Fá fem sénonjo yáne ghékéf fandagh ár Israil árét. ");
INSERT INTO nmx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Yéndfem ewaufrotam féfe mer si, Ngánjánam némé nénorayam unyéghofnar si téfene ákifefaf ");
INSERT INTO nmx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ngánjánam té tawafrote téfeyot, yéfene ákiambumat, ménaye Yesu kés yanoi. Ndené fété kés yékai yénamayo Sams bukan, “'Fém ném tane Ambum, sénonjo yénd nénáyáton fene Afé.' ");
INSERT INTO nmx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ngánjánam fá yanoi kérta, yénémamén yau so nornde, némé noraye yéné sian, “'Yéndon so tawaraman njúnnjúnofnar a efalo frengégh némé té nénorayam Deifidefaf.' ");
INSERT INTO nmx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ámb Sams bukan yéné yékai, “'Fémon yau so tumyo fenjo Njúnnjúnofnar Ambum kérkfot.' ");
INSERT INTO nmx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Njam Deifidém Ngánjánene ásáfogh tawafrotau yánjo ár satafaf, fá táf kémégh nakmai, fá esareyayénd yákifé a yáne fifi norndam. ");
INSERT INTO nmx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wénde ámbiro ár efe Ngánjánam yanoi kérta yau norndam. ");
INSERT INTO nmx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Yénémaménnde, tane fútaréf, yénd ménde wém fém mat kamndangi ndené Yesuene kénjúmé wawalingégh yém féfene yaufimén. ");
INSERT INTO nmx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Emo efalo yiyátota Yesu, Ngánjánam so tanmongé fá siyém mbarkánd ár, yau Mosesene náke so yém. ");
INSERT INTO nmx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kor nawarawenati fémǃ Ngánjánene mat yátogh árém árké yammén korayawét yau so féfefaf nufrote: ");
INSERT INTO nmx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“'Fém Ngánján karogh ár, sunsunan kér so em, némamén yéndon so ewafrotan ámb yam féfene efghon fémofem efalo yau so eyátotati, ndemamén ámb árom so kémaufrongé feyot.'” ");
INSERT INTO nmx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Njamandio Fol a Banabasfem téfrangowét Ju árfene áumengégh méngo, árém eumieyayénd fá kor ámb Safatot siot. ");
INSERT INTO nmx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Njam ár mérén kófarnawét, tárfár Ju ár a Téndo árém ewáiteyayénd Fol a Banabas, efe korayawét yémafé a ewamnendangeyayénd fá ménát mé sái engérnyang Ngánjánene ngárám kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ámb Safatan ndenanit témorwén méinyotio tesen kar káumendawét Yurane si áyárghét. ");
INSERT INTO nmx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Njam Ju árém ewinjoyénd ár mérén, fá waramnjagh mwighayam ewafoi a si karogh yafngoyénd némé Fol korayau. ");
INSERT INTO nmx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Féyo Fol a Banabasfem ewawangeyayénd yéfe férférofnaye, “Yénd so fété noraiwam Ngánjánene si féfefaf Ju árfefaf fronde. Ménamén fémofem yékenati a nawafénmetati fémyo féyotarofnar em tuot ghérsé résaghét, yéndfem fém so tafrangem a kuwanem Téndo árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yénat yénd ténmafarewé Yuram, “'Yéndon fém té eyáteyayén kwayaghé yéfe téndo árét, ménát fémofem so yérset wanjarégh kétánotio mband ánde yiyato.'” ");
INSERT INTO nmx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Njam Téndo árém náyárayénd yéné si, fá áuwéghan tamorwén a kánjo tarametawét Yurane simén; a efe méinyotio ewaferyéng tuot ghérsat efalo yiyátoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yurane si marat náyátoi méinyotio yuwomé. ");
INSERT INTO nmx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wénde Ju árém sénanégh ewafngoyénd tesenmén limánégh ár a Ngánján férférafé ndimbal amaf. Yémofem Fol a Banabas ngi ewafngeyayénd a ewitreyayénd yéfene yuta. ");
INSERT INTO nmx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Féyo yéné téfnan yémofem kafkaf ngwérméng esenangeyayénd matyamot yéfefaf a nuwaneyayénd Ikonium méngotuot. ");
INSERT INTO nmx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A waitogh ár áuwégham ewafoi a Ngánján Mbérmbéram. ");
INSERT INTO nmx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikonium yu kénjún Fol a Banabas túmén tangérwén Ju árfene áumengégh méngot. Kété fá koraiwét sotafé Jumén a téndo yumén ndimbal ár mérnafefaf Ngánján efalo yiyátoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wénde yéné Ju ár efe nakenayénd Ngánjáne efalo yátoghét norayayénd Téndo árfefaf a tawasérmbotawét yéfene mwighé sénanégh ewafngeyayénd Fol a Banabas. ");
INSERT INTO nmx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Féyo Fol a Banabas teke kété tárwén, koraiwét férférofnar Yurai, a Yuramyo ngárámmén si tékmetau safén ndené efalo yém ménáyan tawafrowét ufarogh yam a sélngwélafé yam. ");
INSERT INTO nmx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tesenmén ár nafaloyénd; ámb Ju árfeta, ámb Yesuene muyafé árfeta. ");
INSERT INTO nmx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Féyo Téndo ár a Ju ár mérne nafghayénd yéfenjo sénko árfé ménát Fol a Banabasfe ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Njam Yesuene muyafé ár mat náyáteyayénd yénémamén, fá nitreyayénd kétán Likonia yuwot Listran a Derbe tesen a ámb kaka yuwomé, ");
INSERT INTO nmx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","kété wéikor yéngérnyeyayénd mer si waitogh. ");
INSERT INTO nmx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra tesenan kété ár témorangérwén aknyégh ár, efe tékmangérwén wawér kétándmayo áráfégh yau tiyotawéng. ");
INSERT INTO nmx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Yémon tiyáretau Fol sian. Fol néngretai mbarkánde yáfaf, a yawinjoi yáne ndimbal mwighé mer yátoghét ");
INSERT INTO nmx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","a témotangé, “Kokai mbarkánde fenjo kafkafeǃ” Táf fété ár natnam tukét a áligh nufngoyéng. ");
INSERT INTO nmx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Njam ár mérnam yinjoyénd sélngwélafé yam némé Folém yafrotam, fá kutnawét Likonia sie, “Efalo sómbio ngánján té néneworend téfefaf árnitǃ” ");
INSERT INTO nmx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabas témndangi Jeus, yáne fifi Grik sie ndimbal ngánján a Fol témndangi Ermes yáne fifi Grik sie si sénko ár. ");
INSERT INTO nmx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jeusene wáwefnogh méngo témorwén tesen téndota, ghéngén wárogh ár enwanai kau a mbumbu kétán tesen sésafnefaf ménamén fá a ár mérén ménde tamorwén ghéngén ramghét yéfeyot. ");
INSERT INTO nmx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wénde njam Yesuene muyafé ár Banabas a Fol náyáreyayénd yénémamén, yémofem eftráreyayénd yéfenjo sáláme a néngenngeyayénd ár mérnafefaf, kutnawét, ");
INSERT INTO nmx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Fútaréf, némamén fémofem yéné yafrotati? Yénd yénre ár, ndené fété fém sem. Yéndfem enwarsuwam féfeyot mer si, ménát awengoghét kétándmé fifiofnar yamta kétán akegh Ngánjánefaf, emo ewafrotam njafar, mband, arakaf a méinyotio rokar yéné kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tándái yémon engéumyoi méinyotio ár yéfenjo méndeye néngwanoyénd, ");
INSERT INTO nmx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","wénde yémon yau efrangoi ambino wénde yémon mé tawauyafotau meryam ménaye nu raméghe kétándmé njafarta a njamke raméghe yéfenjo wérwéran a yémon mé nouséne yéfeyot tárfár njamke a yéfene tikéf yafote áuwéghét.” ");
INSERT INTO nmx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ndemamén yéné sie, Fol a Banabas emnyangménd ár mérén yau so ghéngén tarametawét yéfeyot, wénde yau témorwén afrát yéfeyot ménát sái tawanauwét kétamé sái tafrowét. ");
INSERT INTO nmx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Féyo ámb Ju ár enmormén kétándmé Antiok a Ikonium tesenta a ár ewasemnaménd Fol a Banabasfé ngiot. Yémofem wíme tafiyátotawét Fol a téroghawét fá tesenta yutoryénd, kéma kemnawét fá kér kar yémormén. ");
INSERT INTO nmx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wénde yéné soramé waitogh árém yarendayénd Fol, fá nurtotam a néngwanoi tesen kénjút. Ámb efghon Fol a Banabas néwaneyayénd Derbe tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Yémofem taitowét mer si Derbe tesenan a tárfár ár náyátoyénd waitogh ár. Féyo fá kangowét Listra, Ikonium a Antiokét, ");
INSERT INTO nmx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","muyé tawaramwét waitogh árét a tawawéngsowét ménát fá mé sái efalo em ndimbal mwighayan. Yémofem tamndend, “Yénd mé so yénngém tárfár táikér yam kénjúmé ménát Ngánján limánégh élaughét.” ");
INSERT INTO nmx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Fol a Banabasfem ekafeyayénd Yesuene mérén wáutárégh ár yéfeyot fénatayero Yesuene mérnot. Orayéghe a awafarmanéghe, fá ewateménd Yurafaf endefaf yéfene méghmégh témorwén. ");
INSERT INTO nmx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Soramé tangérwén Fisidia yuwomé, fá enérmén kétán Famfilia yuwot, ");
INSERT INTO nmx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","a yémofem si waitogh yafngeyayénd Ferga yuwon, yéné soramé fá néngwaneyayénd Atalia tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kétándmé Ataliata fá ndimbal boute kangowét Antiokét. Antiok yéné sifayé témorwén ánde fronde efalo yátogh ár karamangayénd fá ménát Ngánjánene ngárám ngángayam so tawafrotau Ngánjánene ásáfogh. Yéné sómbio árém ewifeyayénd ásáfogh némé té ewarameyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiok nufareyayénd, yémofem eumendangeyayénd Yesuene mérén a tawaufrowét méinyotio Ngánjánam némé tawafrotau yéfe kénjúmé a ndernáye Ngánjánam yésawéryéng ndimbal mwighé sésafne Téndo árét. ");
INSERT INTO nmx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A fá kété teke emorarmén waitogh árfé. ");
INSERT INTO nmx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ámb ár enmormén Judiata Antiokét a efalo yátogh ár tawatametawét: “Táf féfene ghéngan yau njam tánfangi, ndené Mosesene nákam yénémndete, yau so kawanjar.” ");
INSERT INTO nmx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Yéné watamegh yamam eméindangeyai Fol a Banabas éwighét yémafé yéné watameghmén. Fol a Banabas ekafeyayénd a ámb efalo yátogh árfé, angoghét Jerusalemét Yesuene muyafé ár fandaghét a ámb sénko árfé yéné watameghmén. ");
INSERT INTO nmx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yesuene mérénam engwatembayénd Fol a Banabas tangmorwén yénamé Fonisiya a Samariamé, a yémofem ewaufroyénd ndernáye Téndo ár té kawengotat. Yéné siam eméindayéng méinyotio efalo yátogh ár áuwéghét. ");
INSERT INTO nmx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Fá njam nufaryénd Jerusalemét, Yesuene mérénam a Yesuene muyafé ár a ámb sénko árém eumieyayénd Fol a Banabas, endefet yémofem tawaufrowét méinyotio yammén Ngánjánam némé tafrotau yéfe kénjúmé. ");
INSERT INTO nmx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Féyo ámb efalo yátogh ár efe tawafnyangérwén Farasi mérénmén nokayoi a tamndangé, “Téndo ár so fété ghéngan enfetat ndenáye Mosesene nákam kés noraye.” ");
INSERT INTO nmx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yesuene muyafé ár a ámb sénko ár náumendayénd yéné watamegh simén. ");
INSERT INTO nmx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Yéné watamegh si tombé warunyégh soramé, Fité nokayoi a korayangé yéfefaf: “Fútaréf, fém mat em ndené tándái Ngánjánam waferyéng féfene kénjún ménát téndo árém sái káyárangi tane mbírmbírta mer si a efalo tiyátongi. ");
INSERT INTO nmx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ngánján, efe mat yém árfene tikéf, ewauyafote ndené yémon eyátote téndo ár ménaye Ngánján Mbérmbér raméghe ndené fété téfe kés yénmaramai. ");
INSERT INTO nmx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yémon mwighé yéfaronam ménát ámbiro so tényátonga téndo árfé, ménamén yémon ewáwáine yéfene tikéf ménaye ndimbal mwighaye. ");
INSERT INTO nmx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Féyo fémofem yau so ufoghan Ngánján yékmetati sénonjo ménaye kérté fayoghe téndo efalo yátogh árét ndenéyameyo téfene ákifet a téfeyot árkéméné yau so tanangém. ");
INSERT INTO nmx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yéndfem efalo yiyátotam ndené téfene Yuré Yesuene ngárám kénjúmé yénd nawanjanam, ndenéyame fá kés em.” ");
INSERT INTO nmx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ár mérén métar nufrotaménd fá káyáretawét yéfefaf Banabas a Fol kafrowét ménamén ufarogh yam a sélngwélafé yam Ngánjánam tawafrotau Téndo árfefaf yéfe kénjúmé. ");
INSERT INTO nmx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Njam Banabas a Fité yifeyayénd si, Jems nokayoi siafé: “Fútaréf, yénd kwiyárangi. ");
INSERT INTO nmx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon Fitam tafenau téfefaf ndernáye Ngánjánam fronde yuyafotam yánjo mwighé ménaye ndernáye Téndo ár té eyátoi yáyot. ");
INSERT INTO nmx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A yéné téndo árfene awengogh siyém yénayanfifi némé Ngánjánene mat yátogh ár kénorayawét. Ndené kés yékai: ");
INSERT INTO nmx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Yéné soramé yénd so nénangotan, a kor so yafarnjan Deifidene méngotu. Yéndon kor so yérametan wasérmboghkaf yém, a yéndon so kor yafrotan, ");
INSERT INTO nmx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ménát méinyotio árém so yéronjat Yuré, so tanéfghangé Téndo ár emofem tane yétkwén so yuyotat, Yuré noraye, emo ewafrote yéné yam ");
INSERT INTO nmx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","tándái árkéméné mat náyátoyénd.' ");
INSERT INTO nmx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Yénémaménnde tane mwighé yém yéndfem yau so táikér yiyátotam ménát ghéngan néfghét yéfe Téndo árét efe nawengotat Ngánjánefaf. ");
INSERT INTO nmx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wénde yéndfem férén so yéfarotam yéfeyot a engwaufrotam ménát yau so enetat njamke árkéméné mewang sifayamén em, yau táf téndo wal, yau táf enetat férék eréghofnar wérár a férék yau táf enetati. ");
INSERT INTO nmx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ménamén Mosesene nák si téngwaitotawét méinyotio tesenan fronde efghon a taftawét Ju árfene áumengégh méngon méinyotio Safatan.” ");
INSERT INTO nmx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Féyo Yesuene muyafé ár a sénko ár yémafé méinyotio Yesuene mérén mwighé yéfaronaménd yéfenjo ár kafghét álighét kétán Antiok yémafé Fol a Banabas. Yémofem ekafayénd Judas efe tanmotawét Barsabas a Sailes, yéné ár efe tárwén limánégh ár efalo yátogh árfene kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yéfe kénjúmé yémofem yatembayénd yénamayo férén: “Yesuene muyafé ár a sénko ár, fene fútaréf Jerusalemén, Kétán téndo efalo yátogh árfefaf kétán Antiok, Siria a Silisia: Áuwégh si. ");
INSERT INTO nmx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Yénd té náyárangém ndené ámb té nétorngi téfe tambén téfene matofnaye a fene mwighé kémawasérmbotat, ménaye fá némé korayat. ");
INSERT INTO nmx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yénémamén yéndfem méinyotio efalo yiyátongém ekafangém ámb ár a engwatembangém féfefaf yémafé téfene tikfafé fútar Banabas a Fol, ");
INSERT INTO nmx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ár emofem yéfenjo ghérsé kértat ekmend Yuré Yesu Kerisoene yétkwénot. ");
INSERT INTO nmx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yénémaménnde yéndfem Judas a Sailes engwáfárewam féfefaf ménát yémofem yénayo si so efalo yiyátot mbírmbíre némé yéndfem yéngwafnamotam. ");
INSERT INTO nmx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ngánján Mbérmbér a yénd efalo té yiyátongém ndené yéndfem yau so kérté ewarametam táikér yame wénde mé nambio yamero: ");
INSERT INTO nmx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Fém so nafrangotati kétándmé njamke árkéméné mewang sifayamén em, férékta, férék eréghofnar wérárta a téndo walta. Merfifi yém yéné yamta kékmbongi. Yénaro fai.” ");
INSERT INTO nmx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ár ewatembayénd a tayotau Antiok yuwot. Kété fá káumendawét Yesuene mérén mérne a kété férén yéramayénd. ");
INSERT INTO nmx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Árém njam taftawét áuwéghan tamorwén yéné wawéngsogh simén. ");
INSERT INTO nmx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas a Sailes, efe tárwén Ngánjánene mat yátogh ár, ndimbal wawéngsogh a muyé si koraiwét efalo yátogh árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ámb efogh soramé kété, Judas a Sailes ewatembeyayénd fútarfem frengéghafé a áuwéghafé kangowét yéfefaf emofem enwáfáreménd. ");
INSERT INTO nmx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Wénde Fol a Banabas mé tamorarwén kété Antiokén, ánde fá a tárfár árfé Yurane si táitotawét a tawatametawét. ");
INSERT INTO nmx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ámb efogh soramé Folém yémndayéng Banabas, “So nangowam kétán a eyafowam efalo yátogh ár méinyotio tesenan ánde yéndfem Yurane si taitowém a tanwinjem némé yémofem ewafrotat.” ");
INSERT INTO nmx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas ménde témorwén Jon Make wasroghét yémafé, ");
INSERT INTO nmx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","wénde Fol yau ndené kemnau sái tasrongai fá, ménamén Jon Makém efrangoi kété Famfilia yuwon a nékmboyéng kétamé ásáfogh tambén. ");
INSERT INTO nmx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kété ewarmén ndimbal éwigh a nafalotaménd. Banabasém yasroi Mak a tayowéng ndimbal boute kétán Sáifras, ");
INSERT INTO nmx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","wénde Folém yaferyéng Sailes a efalo yátogh árém erameyayénd Fol a Sailes Yurane ngárám kénjút. Féyo sómbio nuwaneyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Fá nuwaneyayénd yénamé Siria a Silisia yu, yémofem taitoghwét si ménát muyé tawaramwét Yesuene mérnat. ");
INSERT INTO nmx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Fol yénmormén Derbe tesenot a yénamé kétán Listra tesen, ánde waitogh ár yétkwén Timoti témorangérwén. Yátmé témorwén Ju amaf a efalo yátogh ár, wénde yárefé témorwén Grikmén ár. ");
INSERT INTO nmx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Efalo yátogh ár mer si korayawét Timotienemén Listran a Ikoniummén. ");
INSERT INTO nmx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Fol ménde témorwén yémafé álighét, féyo yémo ghéngan yanfai ménamén Ju árfenemén efe tamorangérwén yéné yuwon, ménamén fá méinyotio mat tamorwén ndené yárefé témorwén Grikmén ár. ");
INSERT INTO nmx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Yéfene áligh yam kétándmé ámb tesen kétán ámb tesen, yémofem tawawéngsotawét efalo yátogh ár ménát so táitotawét yéné férén árké yéfarotaménd Yesuene muyafé árém a ámb sénko árém Jerusalemén. ");
INSERT INTO nmx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Féyo Yesuene mérén táf káyátotawét muyafé ndimbal mwighayan a kanotawét méinyotio efghon. ");
INSERT INTO nmx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Fol yánjo mérnafé tayotau yéné yuwomé Frigia a Galasia, Ngánján Mbérmbéram yau eumyoi si waitoghét Esia yuwon. ");
INSERT INTO nmx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Fá engmormén Misia mbandot néngufaryénd, féyo fá ménde tamorwén sái kényawangai Biténiat, wénde Yesuene Mbémbéram yau eumyoi élaughét. ");
INSERT INTO nmx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Féyo yémofem yéngwaindayénd Misia a néngaflayénd kétán Troasot. ");
INSERT INTO nmx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yéné sémbáran Folém téfandau ghékéf waingéghe Makedoniamén ár takayongérwén tamnendau fá, “Kénaf Makedonia ndimbal yuwot téfe wáutárghét.” ");
INSERT INTO nmx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Folene ghékéf waingégh fandagh soramé, yénd wékeye káfrendawém álighét kétán Makedoniat. Ménamén mat náyátoyém ndené Ngánjánam yénmanmoi yénd mer si waitoghét kétán yéfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Yénd ndimbal boute tényotau Troasta kétán Samotrasét, a ámb efghon néngufaryém Neafolisét. ");
INSERT INTO nmx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kétamé yénd néngwanoyém kétán Filifi, Rom mwighafé yu a limánégh tesen Makedonia ndimbal yuwot. Kété yénmorangérmén tárfár efogh. ");
INSERT INTO nmx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ámb Safatan yénd néngtoryém tesen sésafneta kétán wanjet, yéné mwighafé Ngánjánafé orayégh sifayé kété so yém. Yénd námnjoyém a si yérnyayém yéné amafafefaf efe nénáumendayénd kété. ");
INSERT INTO nmx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ámb amaf efe káyáretau yáne yétkwén Lidia, efe témorwén Tayatira tesenmén. Yémon ndéndák ngarot sáláme faian yékmai a fá témorwén Ngánjánene wáwefnogh amaf. Yuram yasawéryéng yáne tikéf áyárghét kétán Folene sifaf. ");
INSERT INTO nmx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Amaf a yáne mérén ewalitotam, yéné soramé amafom yénumyoi yánjo méngot. Amafom témndangé, “Njam fém nemnati ndené yénd wém efalo yátogh ár Yurane kénjún, kénaflangi tane méngon so emor.” Féyo amafom yénmamnendai yénd, féyo yénd kété yénmorangérmén. ");
INSERT INTO nmx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ámb káye yénd ténngérwén Ngánjánafé orayégh sifayat, yénd yénfangeyai faiofnar ásáfogh mérsom efe yaufi mbérmbéroene waftaye korayau soramé yumén. Yémon tawinjotau ndimbal mani árfe tambén ménamén korayau soramé yumén. Yémon tawarametau mani yánjo wanjengégh téfnárat. ");
INSERT INTO nmx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yéné mérsom Fol a yénd yénmaitoyéng ndené keyafé, “Yéné ár fem Minde Tukén Ngánjánene faiofnar ásáfogh ár, emofem ewafrotat end féfe wanjarghét.” ");
INSERT INTO nmx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Mérés ménj mé térnyangérwén tárfár efogh yéné sian. Kerkeran Fol nékwafé náindam nawengoi a témndangé mbérmbér, “Yesu Kerisoene yétkwénan fém kétor yá tambénǃ” Táf fété mbérmbéram mérés yéfrangoi. ");
INSERT INTO nmx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Njam faiofnar ásáfogh mérésoene yuram yáyámngoyénd ndené mani winjo end té nefo, yémofem Fol a Sailes ngi ewafngeyayénd taroghwét fá marat sifayamé kétán sénko árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Yémofem enémnjéménd yéné yumén gafanane sáfrére a norayayénd, “Yéné ár sere Jumén, yémofem ár mwighayan ewanjmengét, ");
INSERT INTO nmx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","yémofem ár ewatamet fénaté si yéné mbarkánd yau árké nérete téfe Rom árét wafroghét.” ");
INSERT INTO nmx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ár mérén nafghayénd Fol a Sailes yéfe ngiot, a yéné ndimbal yumén mogh árfene wáfáreghan so yéfene sáláme tawaftérarwét a tafmowét. ");
INSERT INTO nmx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Féyo yaufi fémogh efmoménd, a fá ewiménd kétán kwéfkwéf méngot, a yéné sifayé wanjengégh ár yémndayénd merkéráye wanjengéghét. ");
INSERT INTO nmx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Njam fá náyárai wáfaregh si, yémon ewármbneyai sómbio ár a ewangseyayénd wéne yéfene ghambér. ");
INSERT INTO nmx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Sémbár néndkéfan Fol a Sailes Ngánjánjafé korayawét a wagh kermangwét Ngánjánefaf, a ámb ár kwéfkwéf méngon talawangérwén táyárwét waghan. ");
INSERT INTO nmx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sunsune ndimbal sokrereyam kwéfkwéf méngo sérasér esámbnetam. Táf fété méinyotio kwéfkwéf méngo sésafne kasaunawét, a méinyotio árfene sein naferyénd. ");
INSERT INTO nmx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kwéfkwéf méngo wanjengégh ár nanoi, a njam néngretai kwéfkwéf méngo sésafne sauréghkaf tamorwén, fá witmafé sénté naifaye akunyéghét féf nufngoi krotio ménamén fá kéma kemnau nde kwéfkwéf méngo ár kar té nétoryénd. ");
INSERT INTO nmx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Wénde Fol nutnai, “Yau nawaghna fémyoǃ Yénd méinyotio yéna mé yénémǃ” ");
INSERT INTO nmx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kwéfkwéf méngo wanjengégh ár néngutnai kwayaghat a soramé ewawanayénd kwayaghé, néngénngoi kwéfkwéf méngo kénjút a nénguyai ngerngerafé Fol a Sailesfene sáfrére. ");
INSERT INTO nmx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Féyo yémon enutoreyai kénjúta a emotangeyai, “Ndimbal, yéndon némé so yafrotan awanjarghét?” ");
INSERT INTO nmx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yémofem yawangeyayénd, “Yuré Yesu efalo tiyáto, a táf fém so kawanjar fene mérnafé.” ");
INSERT INTO nmx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Féyo fá kafrowét Yurane si yáfaf a méinyotio ámb árfefaf yáne méngon. ");
INSERT INTO nmx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Yéné sémbáranyo kwéfkwéf méngo wanjengégh árom emnjéméng a yéfene fénend tawaumbarwéng; féyo táf fété fá yánjo mérnafayo nuan ewalitoménd. ");
INSERT INTO nmx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kwéfkwéf méngo wanjengégh árom emnjéméng yáne méngot a ewémnjeyai nénet; fá áuwégham yafoi ménamén yémon Ngánján efalo yiyátoi yánjo méinyotio mérnafé. ");
INSERT INTO nmx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Njam akw yéfauwéryéng, Rom mogh árém ewáfáretayénd yéfene ásáfogh ár kwéfkwéf méngo wanjengégh ároefaf: “Tautorend yéné ár nguwanend.” ");
INSERT INTO nmx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kwéfkwéf méngo wanjengégh árom taufrongé Fole, “Rom mogh árém nénorayangi ndené fém a Sailes so tautorend. Sénonjo fémofem yéné sifayé téfrangend kuwanend krufráte.” ");
INSERT INTO nmx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Wénde Folém korayangé ásáfogh árfefaf: “Yémofem yénd ténsémét marataye moghofnar yuwon, ndemamén yénd yénre Rom yumén ár, a yénmiménd kwéfkwéf méngo kénjút. Sénonjo yénd yémofem métare yénmutorend? Yauǃ Fá fáyo táf kénaflangi a téngémnjend yénd.” ");
INSERT INTO nmx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ásáfogh árém njam ewaufroyénd Rom mogh árfet ndené Fol a Sailes tárwén Rom yumén ár, fá férféram ewifoi. ");
INSERT INTO nmx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Fá nénaflayénd yéfefaf ghérghérsisé siot a enémnjeyayénd kétándmé kwéfkwéf méngota, ewamnendangeyayénd tesen frangoghét. ");
INSERT INTO nmx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Soramé Fol a Sailes néntoreyayénd kwéfkwéf méngota, fá néngwaneyayénd Lidiane méngot, ánde nafángoyénd efalo yátogh árfé tawawéngsowét fá. Féyo yémofem táf efrangeyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Njam Fol yáne fútarfé nawaindayénd Amfifolis a Afoloniamé, fá enmormén Tesalonikat, kété témorwén Ju árfene áumengégh méngo. ");
INSERT INTO nmx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yáne túmén yam témorwén, Fol téngmorwén Ju árfene áumengégh méngo kénjút, a nambio Safat efghon yémon yérnyai warunyégh árfé, ");
INSERT INTO nmx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","a Buk si tawawafenau ndené Keriso tékrátan so yém a kérta kanongé. Fá norayai, “Yéné Yesu siyém Keriso yéndon endenemén yaitotan féfeyot.” ");
INSERT INTO nmx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ámb Ju árém efalo yiyátoyénd a nufnyayénd Fol a Sailesfefaf. Kété tamorwén tárfár Téndo ár Ngánján férférafé a tárfár sénko amaf. ");
INSERT INTO nmx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Wénde ámb Ju ár kawaramnjawét, yénémamén yémofem eumendayénd kérté wafrogh ár mérén marat sifayan, awifarégh yérnyayénd tesenan. Fá néngenngoyénd Jasonene méngot Fol a Sailes yéfe ronjaghét a wasroghét ár mérénfaf. ");
INSERT INTO nmx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Wénde njam yémofem yau ewinjeyayénd Fol a Sailes, yémofem Jason a ámb efalo yátogh ár tesenmén tawafaretawét gafanane sáfrére, yéné keyafé, “Yéné ár fem emofem yéfunat kérté méinyotio mband maratan sénonjo yéna em, ");
INSERT INTO nmx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a Jasoném eumyoi fá yáne méngot. Fá fem emofem méinyotio Rom tuk warsagh ár Kaisarene nák erafnat ndené siafé Yesu siyém ámb warsagh ár.” ");
INSERT INTO nmx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Njam fá náyárayénd yéné si, ár mérén a tesenmén gafana fá nékw nawerayénd. ");
INSERT INTO nmx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Féyo yémofem fai ewafrotaménd Jason a ámb efalo yátogh ár utorghét. ");
INSERT INTO nmx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Yéné sémbáranyo, ámb efalo yátogh árém engwatembeyayénd Fol a Sailes Bereya tesenot. Ufarghan Fol a Sailes, fá néngwaneyayénd Ju árfene áumengégh méngot. ");
INSERT INTO nmx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ménamén Bereyamén Ju ár tamorwén minde mer ár, yéfene wafroghyamam ewaindayéng Tesalonika yumén ár, yémofem yumyoyénd si áuwéghafé a tafénmetawét Buk si túmén efghon téfandawét némé Fol efalo korayau. ");
INSERT INTO nmx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tárfár Ju árém efalo yiyátoyénd si a ámb ndimbal yétkwén amafam a ámb Grikmén árém. ");
INSERT INTO nmx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Njam Ju ár mat náyátoyénd Tesalonika kénjún ndené Folém táitotau Ngánjánene si Bereyan, ámb ár wéi kétán néngwanoyénd a amrorégh yérnyayénd ár mérén tawanjmetawét. ");
INSERT INTO nmx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Táf fété efalo yátogh árém Fol yáfáretaménd arakaf tambén, wénde Saileséf Timotifé tamorarwén Bereyan. ");
INSERT INTO nmx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Njam yéné árém yénémnjaménd Fol Atenét, Fol norayai yéfefaf ndené, “Sailes a Timoti tafaf táf enre wékeye.” Féyo táf néngwanoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Njam Fol kawanjetau yéfeyot Sailes a Timoti Aten tesenan, fá áuwéghofnar témorwén ménamén yinjoi yéné tesen mewang afoghare. ");
INSERT INTO nmx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yémon éwigh yérnyai yémafé Ju árfene áumengégh méngon Ju ár a Ngánján férférafé Téndo ár. Fá wéi táf téngmorwén marat sifayat méinyotio efghon a ár kété tamndetau. ");
INSERT INTO nmx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Mérén tárwén sómbio, ámb Efikuria mérén a ámb Stoik mérén ndimbal matyamafé ár éwigh yérnyayénd Folfé. Ámb kamotangi, “Némé siot yéné waréwaré nufngo?” Ámb korayangi, “Fá mété noraya ámb ngánjánmén.” Fá korayawét yéné si ménamén Folém táitotau mer si Yesuenemén a yáne anoghmén. ");
INSERT INTO nmx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yémofem yéngwasroyénd fá sénko árfene áumengégh sifayé yétkwén Areyofagus, ánde yémofem fá témndetawét, “Féyotaro fémo so ténmaufro matot némé totér watamegh fémo yaitote? ");
INSERT INTO nmx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Fémon téfe yénérse fénataye watamegh náyáretam, a yénd ménde yéném mat sái káyátongém némé yáne fifi yém.” ");
INSERT INTO nmx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Méinyotio Atenmén ár a ámb yuta ár efe tamorangérwén kété efogh tifotawét ámnjoghanro wénde korayawét a káyáretawét soramamén siot) ");
INSERT INTO nmx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Féyo Fol nokayoi sénko árfene áumengégh sifayé yétkwén Areyofagus a tamndangé, “Atenmén árǃ Yéndon tawafandan fémofem ewáwefnotati tárfár ngánjánafet mindefifi. ");
INSERT INTO nmx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ménamén yénd njam karendan táf kor ewawinjon féfene wáwefnogh rokar. Yéndon tawafandan kitarékitaré yéné yétkwénafé: Kétán Mat Yátoghofnar Ngánján. Fém mat yau em némayoe fémofem yáwefnotati, sénonjo yéndon so ewaufrotan féfeyot yánemén. ");
INSERT INTO nmx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Ngánján emo yafrotam mband marat a méinyotio rokar yéné kénjún. Ménamén yémo elimnde méinyotio rokar njafaran a mbandan, fá yau yémor ár ngángé raméghmén wáwefnogh méngon. ");
INSERT INTO nmx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","A fá yau náronje yéné rokarot árém árké ewafrotat yáyot, ménamén fá fáyo méinyotio árfene ghérsé ramégh ár yém a méinyotio rokar kés. ");
INSERT INTO nmx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Rényéghan Ngánjánam yafrotam ámbiro ár, Yá tambén Ngánjánam ewafrotam méinyotio ár mérén efe sénonjo emorang méinyotio mband maratan. A yémon wéi mwighé yéfaronam ánde fénatayero ár mérén so emor a nderé teke fá so emor. ");
INSERT INTO nmx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ngánján ménde yém árém sái yéronjat. Ménamén fá yau nayu yém téfeta, féyo yémofem mété táf yéronjat fá a tinjongi. ");
INSERT INTO nmx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","'Ménamén yáne waftayan yénd ghérsé yénmor a nimndam a naketam.' Ndenanit féfenjo ár efe mat em férénafene fifi, fá norayat ndenanit, 'Yénd yéném yáne ambumtértér.' ");
INSERT INTO nmx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ménamén yénd Ngánjánene ambumtértér kés yéném, yénd yau so nemnam ndené árém so ewafrotat Ngánján kétamé gol o silfé o wím yéfenjo matyame. ");
INSERT INTO nmx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tándái ár njam yau mat tamorwén némé Ngánján ménde témorwén yéfefaf wafroghét, Ngánjánam yau kértayan tákmangai ménamén yéfene matyam yau, wénde sénonjo Ngánjánam emndete méinyotio ár méinyotio yuwomé yaufita awengoghét. ");
INSERT INTO nmx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Efogh té yaferyéng njam mband so moghan tékmangé. Yémo té yékafai ár emo so moghan ténékmangé mbarkánde. Ngánjánam té yuyafoi yéné ár, efe Ngánjánam té yékafai ménát sái emota mband marat, yémo so moghan tékmangé mband marat ménamén Ngánjánam yanoi kérta.” ");
INSERT INTO nmx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Njam fá náyárayénd ároene kér anoghmén si, ámb árém turtawét, wénde ámb korayawét, “Yénd ménde yéném fém sái kor koraya téfefaf yéné si téfén.” ");
INSERT INTO nmx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yéné áumengégh soramé Folém efrangoi. ");
INSERT INTO nmx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ámb ár namndayénd Folene waitogh ár a efalo yiyátoyénd. Yéfene kénjún tafnyangérwén Dionisus, efe témorwén Areyofagus mérénmén, ndenáyo amaf yétkwén Damaris, a ámb ár kés. ");
INSERT INTO nmx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yéné soramé, Folém yéfrangoi Aten tesen a néngwanoi Korint tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kété yémon yéfángoi Ju ár yétkwén Akwila Fontusmén. Fá yénmormén kétándmé Italia yánjo amafafé yétkwén Frisila, ménamén Rom tuk warsagh ár Kaisar Klaudiasém emndai “Fém Ju ár, fémofem so téfrangongi Rom.” Fol néngaflai Akwila a Frisila fandaghét, ");
INSERT INTO nmx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","a ménamén Fol témorwén farai méngo ramégh ár ndené fá kés tamorwén, Fol námnjoyéng a kásáfotawét yémafé. ");
INSERT INTO nmx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Méinyotio Safatan Folfem taruindawét Ju árfene áumengégh méngon, ménát sái tikéf áfrat táyátongayénd Ju ár a Téndo ár. ");
INSERT INTO nmx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Njam Sailes a Timoti nufareyayénd kétándmé Makedoniata, yéna Folém yéta Ju ár matot tarametau ndené Yesu siyém Keriso. ");
INSERT INTO nmx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Wénde Ju árém tékarotawét Fol a yaufi si témndetawét. Féyo yénémamén yémon ngwérméng yétnendai yánjo sálámeta a tamndangé fá, “Njam Ngánjánam tékratan tákmangé, so yém féfenjo téfnan, yau so yém tane téfén. Yénd nawafenan féfefaf yénd yau kérté so wém. Yénandmé yénd so kuwanon sénonjo Téndo árfefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Féyo Folém yéngéfrangoi Ju árfene áumengégh méngo a néngaflai kaka méngot, Taitus Jéstusene méngot efe témorwén Ngánján wáwefnogh ár. ");
INSERT INTO nmx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krisfus, Ju árfene áumengégh méngo limánégh ár, a yánjo mérnam Yuré efalo yiyátoyénd a tárfár Korintmén ár efe káyáretawét, efalo yiyátoyénd a nuwan ewalitotam. ");
INSERT INTO nmx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ámb sémbáran Yuré norayai Folefaf ghékéf waingégh kénjún, “Yau férfér ném, sian miya néngém, yau métar ném a nékmbo. ");
INSERT INTO nmx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ménamén yénd fémafé yénre, a emo yau so nékmbote a némasérmbote fém, ménamén tane tárfár ár em yéné tesenan.” ");
INSERT INTO nmx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yéné téfnan Fol yémorangérmén Korintén ámbiro yunjéf ámb yunjéf rér yéramai fá tawatametau Ngánjánene si. ");
INSERT INTO nmx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Njam Galio témorwén gafana Akaya ndimbal yumén, ámb Ju ár nafghayénd Fole kékmboghét a yénmasroyénd moghét. ");
INSERT INTO nmx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yémofem yémndayénd, “Yéné árom elimnde ár Ngánján wáwefnoghét yéné ende téfene nák eráfne.” ");
INSERT INTO nmx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Fol siotro témorwén, Galio norayai Ju árfefaf, “Fém Ju ár njam nawatarnati yéné kértamén tayot mer nérete, fém so eyáretan sian. ");
INSERT INTO nmx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Wénde yéna ewafnyang ámogh ménamén orayaghmén a yétkwénmén a féfenjo nákmén, táfrendangi yéné yam fémofemyo. Yénd yau so yéna wém féfene moghan yéné yammén.” ");
INSERT INTO nmx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Féyo yémon engéutoryéng moghta. ");
INSERT INTO nmx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Féyo méinyotioyam yerayénd Sostenes Ju árfene áumengégh méngo limánégh ároefaf ngi yafngoi mogh méngo safén. Wénde Galiom yau kemnau yénémamén. ");
INSERT INTO nmx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Fol yémorangérmén Korintén tárfár efogh. Féyo yémon engéfrangoi fútaréf kété, a nuwanoyénd yémafé Frisila a yánjar Akwila. Fá néngwanoyénd kétán Senséri. Kété Fol séf natértam ménamén yane unyéghofnar simén Ngánjánefaf. Fá ndimbal boute nénguwanoyénd Siria yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Fá nékmboyénd Efesos tesenan, Folém efrangeyai Frisila a Akwila. Fá yambia néngwanoi Ju árfene áumengégh méngot a tarundawét Ju árfé. ");
INSERT INTO nmx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Njam yémofem yaunendayénd ámb efogh ámnjoghét yémafé, yémon yékenai. ");
INSERT INTO nmx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Wénde njam Folém engéfrangoi, yémon unyéghofnar si emndai, “Yénd so kénangon Ngánjánene méndeyan.” Féyo yémon yéfrangoi Efesos a mé tanmorwén Kaisariat. ");
INSERT INTO nmx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Njam fá nufaryéng Kaisaria yuwot, fá néngwanoi Jerusalemét a áuwégh si ewaramai Yesuene mérnat, a néngangoi kétán Antiok yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ámb efogh ámnjogh soramé, Antiokta kétamé Fol néngwanoi yéné yuwomé karendau Galasia yu a Frigia yu, muyé tawarametau méinyotio waitogh árét. ");
INSERT INTO nmx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jumén ár yétkwén Afolos Aleksandria yumén yénmormén Efesos. Fá témorwén Buk si matyamafé. ");
INSERT INTO nmx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Fá yatametaménd Yurane ende, korayau tikéf fésafé a tawatametau Yesuenemén merkéráye, wénde fá mat témorwén Jonene nu walitoghménro. ");
INSERT INTO nmx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yémon si yafngoi férférofnaye Ju árfene áumengégh méngo kénjún. Njam Frisila a Akwilafem yiyáreyayénd fá, yémofem yumyeyayénd kétán yéfenjo méngot a tawaferwét Afolose mbarkánde Ngánjánene end. ");
INSERT INTO nmx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Njam Afolos ménde témorwén Akaya ndimbal yuwot álighét, fútarém yawéngsotaménd fá a yéfarotaménd férén waitogh árfefaf Akaya ndimbal yuwon yá umyoghét. Yáne ufarghan, fá náyátoi ndimbal wáutárégh yéfeyot emofem efalo yiyátoyénd ménaye Ngánjánene ngáráme. ");
INSERT INTO nmx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Fá kéwitawét marataye Ju árfé, yémon yéta safét tawakmetau Buk sita ndené Yesu témorwén Keriso. ");
INSERT INTO nmx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Njam Afolos témorwén Korint tesenan, Fol tiotau mband tunamé kétán Efesos tesen néngufaryéng. Kété yémon ewinjoi ámb waitogh ár ");
INSERT INTO nmx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","a yémon emotai, “Fémofem Ngánján Mbérmbér té yanayénd njam fémofem efalo yiyátoyénd Yesu?” Yémofem yawangoyénd, “Yau, yénd yau náyárayém ndené yéna yém Ngánján Mbérmbér.” ");
INSERT INTO nmx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Féyo Folém emotai, “Endene walitogh fémofem yanayénd?” Yémofem yawangoyénd, “Jonene nu walitogh.” ");
INSERT INTO nmx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Folém norayai, “Jonene nu walitogh yémormén yaufita awengoghét. Joném tamndetau ár efalo yátoghét Yesu efe so yéném yá soramé.” ");
INSERT INTO nmx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Yéné si áyárghan, Folém ewalitotam Yuré Yesuene yétkwénan. ");
INSERT INTO nmx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Njam Folém ngángé efayoi yéfefaf, Ngánján Mbérmbér táf yénmormén yéfefaf, a ámb sie korayawét a táitotawét Ngánjánene si. ");
INSERT INTO nmx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kété mété tamorwén 12 ár. ");
INSERT INTO nmx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Fol nénglawai Ju árfene áumengégh méngot a férférofnar korayau kété nambio ghérare. Yémo taruindau yémafé a yéta taméindau ménát sái efalo tiyátongayénd Ngánján limánéghmén. ");
INSERT INTO nmx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Wénde ámb ár namndayénd tikéf táikér; fá kakenawét efalo yátoghét a marataye yaufi si korayawét Ngánjánene endmén. Féyo yéné yammén Folém efrangoi fá. Yémon engwasroi waitogh árfé téngwaruindawét si méinyotio efghon yétkwén Taranusoene watamegh méngon. ");
INSERT INTO nmx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Fá yérsam sómbio yunjéf sian, féyo méinyotio Ju ár a Téndo ár Esia kénjún efe tamorwén náyárayénd Yurane si. ");
INSERT INTO nmx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ngánjánam yéramai Fole wafté sélngwélafé ásáfoghét. ");
INSERT INTO nmx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Árém muku o sáláme Folém árké tiyánjangai tafayotawét enjne téfnárefaf, táf mer káyátotawét a yaufi mbérmbér kitérmbotawét. ");
INSERT INTO nmx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ámb Ju ár nuwanoyénd yéta yaufi mbérmbér tawifnawét Yuré Yesuene yétkwénan fá efe yaufi mbérmbéram tawasérmbotau. Ámb árém norayai, “Yesuene yétkwénan, endenemén Folém yaitote, yéndo némndetan, 'Kéntor.'” ");
INSERT INTO nmx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jumén limánégh ghéngén wárogh ár Skefane sefen ambumam yéné ásáfogh tafrotawét. ");
INSERT INTO nmx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ámb efghon yaufi mbérmbéram ewawangoi yéfe, “Yénd mat wém Yesu a yénd mat wém Folenemén, wénde fém efe em?” ");
INSERT INTO nmx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Féyo yéné yaufi mbérmbérafé ár néngatnam yéfefaf a ewifnai méinyotio tásmetau. Fá méngota néngenngoyénd firo kérsawét férkafé. ");
INSERT INTO nmx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kété Efesosén njam Ju ár a Téndo árém náyárayénd yénémamén, fá férfér tamorwén, yémofem tuwetawét Yuré Yesuene yétkwén. ");
INSERT INTO nmx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tárfár efe efalo yátogh ár náyátoyénd afrogh nufngoyénd yéfenjo yaufi wafroghmén. ");
INSERT INTO nmx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ámb ár efe kotametawét ghar yémofem tanérsawét yéfenjo ghar buk a tawarotawét maratan. Njam yémofem taftawét árfene bukmén fai kétán narsam tárfár milion kinat. ");
INSERT INTO nmx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Féyo táf Yurane si marat káyátotau a kamndetau waftafé. ");
INSERT INTO nmx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Méinyotio yéné yam njam kufrotau soramé, Folém mwighé yaitotam yafoghét Makedonia a Akaya a Jerusalemét. Fol norayai, “Yénandmé yénd so kuwanon kétán Rom.” ");
INSERT INTO nmx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Féyo yémon ewáfáreméng yáne sómbio wáutárégh ár, Timoti a Erastus, kétán Makedoniat, wénde fá mé témorangérwén Esian. ");
INSERT INTO nmx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Yéné efghon Efesos yuwon kérté yéfunayénd Ngánjánene Endmén. ");
INSERT INTO nmx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kété témorwén ár yétkwén Demetrios, emo tawafrotau silfé wáwefnogh méngo Artemis mewangoe. Fá efe kásáfotawét yémofem tawinjotawét tárfár mani. ");
INSERT INTO nmx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriosém eumendai yánjo ásáfogh ár a tamndangé, “Fútaréf, káyárangi, fém mat em yéndfem tawinjotam tárfár mani yéné ásáfoghmén. ");
INSERT INTO nmx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Fémofem té yinjongi a yáyamngongi ndernáye Folém áfrat yényátote a ámb watameghe tárfár ár elimnde Efesos tesenan a méinyotio Esia yuwomé. Yémon noraye ndené ár wafroghmén ngánján yau em ngánján. ");
INSERT INTO nmx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Yéné yam siyém áuwéghofnar yém ménamén téfene mani winjogh end so kefongé. Ndenéyameyo ndimbal amaf ngánján Atemisene wáwefnogh méngo so kamndangé fifiofnar, endeyot táwefnotat Esia a mband maratan. Árém yau so nemnat ndené amaf ngánján Atemis siyém ngánján.” ");
INSERT INTO nmx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Njam fá náyárayénd yéné si, fá nékw tamorwén a ke kutnawét ndené siafé, “Ndimbal ngánján amaf siyém Atemis Efesosén.” ");
INSERT INTO nmx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ndimbal tesen nufnyai a ke kutnawét ménamén ámbiro mwighayan tamorwén. Árém ewanetangeyayénd Gayus a Aristakus, Folene arengégh fútaréf kétamé Makedonia yuta, a árém tawafarewét kétán áumengégh sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Fol ménde témorwén álighét áumengégh sifayat, wénde waitogh árém yau yéngéumyoyénd kétán álighét. ");
INSERT INTO nmx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ámb gafanane ásáfogh ár efe tamorwén Folene fútar, si wékeye yénmawatembayénd yau álighét kétán áumengégh sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ár mérén kéwérsotawét ménamén fénatayero ke kutnawét. Tárfár ár yau mat tamorwén némamén fá kété tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ju árém yéngwáfáretayénd Aleksenda yéfefaf siot. Yémon árét ngángaye ewaunyai métar ekmboghét. Fá ménde témorwén ménát sái tamndangai fá ndené Ju ár yau kérté yéfunayénd. ");
INSERT INTO nmx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wénde njam yémofem yáyámngoyénd nde fá témorwén Ju ár, fá kutnawét sómbio efoghféneféne ndené keyafé, “Ndimbal yém Atemis Efesosménǃ” ");
INSERT INTO nmx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tesenmén gafanane ásáfogh árom ekmboi a norayai, “Efesosmén ár, fém mat em ndené Efesos tesen siyém wanjengégh ár ndimbal amaf ngánján Artamisene wáwefnogh méngo a yéné amafoene sáf mbanmban árké néneworyéng njafarta. ");
INSERT INTO nmx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Efe yau so korayangé fá yau nénui njafarta. Fém métar. Némé yau yafrotati namname. ");
INSERT INTO nmx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Fémofem yéné ár tánémnjati yénan, yémofem yau yaufi si korayat téfene ngánjánefaf a yau némndafi oroe tarsat téfene ngánjánene wáwefnogh méngota. ");
INSERT INTO nmx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Féyo njam Demetrios a yáne ásáfogh árfé kérté ewam, mogh siyém sauréghkaf yém a yéna em mogh ár. Féyotaro fá so norayat yéné yammén. ");
INSERT INTO nmx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Njam kérté mé em, so tanwanangi kétán moghfaf. ");
INSERT INTO nmx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A féyo mat ayéném yéné, ndené njam sénko ár káyárangi némé yéndfem tafrotam sénonjo, yémofem mété yénémndetat ndimbal kérté funaghmén. Yéndfem yéné tafrotam fifiofnar, féyo némé yénd so norayam njam yénd yénmotat yénémamén.” ");
INSERT INTO nmx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Féyo yéné si soramé, yémon ár ewáfárnayéng. ");
INSERT INTO nmx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Njam tesenan sarake nefoi, Fol néngwanoi kétán waitogh árfefaf, a tawawéngsotau yéfe. Féyo fá emndayéng “Yao” a táf néwanoi Makedonia yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Fá ngrendau yéné yuwomé, ngorayau tárfár wawéngsogh si árfefaf soramé Fol néngufaryéng Grik yuwot, ");
INSERT INTO nmx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kété fá yémorangérmén nambio ghérare. Féyo mwighé yaitotam Siria yuwot angoghét ndimbal boute, wénde fá náyárai ndené ámb Ju árém yá ngiot mwighé táitotawét. Féyo yémon mwighé yaitotam tunamé angoghét Makedoniamé. ");
INSERT INTO nmx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sofata Firusene ambum kétándmamén Bereya yumén, Aristakus a Sekundus kétándmamén Tesalonika yumén, Gaius kétándmamén Derbe yumén, Timoti ndenéyameyo, Tukikus a Trofimus kétándmamén Esia marat yumén yémafé Folfé tayotau. ");
INSERT INTO nmx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yéné ár engmormén frondeyo ténmanjetawét yénd Troas tesenan. ");
INSERT INTO nmx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wénde yénd ndimbal boute ténngmorwén kétamé Filifi tesenta Minaghofnar flawé téménd soramé. Ámb 5 efogh soramé yénd nufnyayém kété Troas tesenan, ánde yénd yémorangérmén sefen efogh. ");
INSERT INTO nmx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Sande efghon yénd yénngmormén mérne ménát féskaf flawé nénet. Folém korayau árfefaf a sian mé téngmorwén kétánotio sémbár néndkéf, ménamén ámb efghon álighét karametawét. ");
INSERT INTO nmx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Yéné méngo kénjún kété kánetawét tárfár kwayaghé ánde yénd káumendawém. ");
INSERT INTO nmx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kété ámb totér ár yétkwén Yutikus témorangérwén mbormbor sésafneyan, njamandio Fol mé korayau teke, Yutikus kémégham térametau. Kerkeran, fá kémégh nakmai nambio kitaré satayan kétándmé nénuyai mbandot. Yémofem yékafayénd kérwén. ");
INSERT INTO nmx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Fol néngeworyéng yuwot, néngáwefnoi ngángé efayoi yáfaf. Féyo Folém tamndangé, “Yau mámé mwighé em, fá mé ghérsé yémǃ” ");
INSERT INTO nmx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Féyo Fol wéikor néngarmboi tukét, a ténetau féskaf flawé. Fol mé korayau kétánotio akw yéfawéryéng soramé yémo efrangoi. ");
INSERT INTO nmx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Árém totér ár yéngwanayénd méngot a yéfeyot ndimbal áuwéghafé témorwén ménamén kérta nanoi. ");
INSERT INTO nmx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Fol té norayai ndené yémo so ténfángongai kété Asosén, ménamén fá tiyotau álighe. Féyo fronde yénd nénguwanoyém Boutfaf a ngérsawém kétán Asos tesenot. Kété yénd ménde ténmormén sái téfángongayém fá a téngwanangayém bout. ");
INSERT INTO nmx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Njam yémon yénfángoyéng Asosén, yéndfem fá yéngwaflayém a néngwanoyém Mitilan tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ámb efghon yéndfem yéfrangoyém yéné a néngwanoyém ndimbal boute kétán Kios tesenot. Yéné efogh soramé wéi néngurtoyém Samos tesenot, sómbio efogh soramé néngufaryém Miletus tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Fol yau ménde témorwén ménát sái témorangérwén Esia marat yuwon, féyo mwighé yéfaronam yau so kékmbongai Efesosén. Ménamén fá ménde témorwén wékeye ufarghét Jerusalemét wafarogh téménd yétkwén Fentikost ");
INSERT INTO nmx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kétándmé Miletus tesenta, Folém si yatembai kétán Efesos yumén Yesuene mérén sénko árét álighét yémafé siot. ");
INSERT INTO nmx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Njam sénko ár nufaryénd, Fol norayai yéfefaf, “Fém mat em ndernáye yénd kásáfotan féfe kénjún kétándmayo frondefifi efghon yénd njam nufaryén Esia marat yuwon. ");
INSERT INTO nmx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Yénd kásáfotan ndimbal yuwan mwighaye a yengamafé. Yénd tékrátan kawamarotan ménamén Ju árém ngiot kwérametawét. ");
INSERT INTO nmx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Fém mat em ndené yénd yau férfér kwém si waitoghét árkéméné féfe wáutárghafé tém wénde tawatametawén fém marataye méinyotio méngomé. ");
INSERT INTO nmx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Yéndon táitotawén si yéfe Ju ár a Grikmén árét ménát fá so nawengotat yaufita Ngánjánefaf a efalo so yiyátotat téfene Yuré Yesu. ");
INSERT INTO nmx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Sénonjo Ngánján Mbérmbéroene sian, yénd so kuwanon Jerusalemét, mat yau wém némé yam so nufrote kété tafaf. ");
INSERT INTO nmx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wénde yénd yénaro mat wém méinyotio tesenan Ngánján Mbérmbéram waufrote ndené Jerusalemén árém so kwényawangi yénd kwéfkwéf méngon a yénd so tékratan kwékmangi. ");
INSERT INTO nmx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Wénde tane fifie ghérsé siyém fifiofnar yém, wénde yéné fifiyafé tafaf yém: ndené yéndo so tifon wérse Yuré Yesum árké waramai, mer si waitogh ásáfoghét Ngánjánene ngárámmén ");
INSERT INTO nmx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Yénd mat wém féfefafmé té karendan Ngánján limánéghmén si táitotan. Wénde sénonjo yénd mat wém ndené fémofem yau so wéikor kwinjongi. ");
INSERT INTO nmx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yénémamén sénonjo yénd sotafé si norayan. Njam fém ámb kér ném Yesu efalo yátoghofnar, fémofem yau so kwéfayongi yénd yénémamén. ");
INSERT INTO nmx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Yénd yau férfér kwém méinyotio Ngánjánene ménde waitoghét féfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Fém kor nawarawenati fémyo a méinyotio Yesuene mérén árké Ngánján Mbérmbéram té ewaferyéng ár wanjengét. Ngánjánene Yesuene mérén wanjengégh ár aem, yémon yánjo férke té yénmanai. ");
INSERT INTO nmx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yénd ndené mat wém, yénd njam kuwanon munjan ághé so kufarngi féfene kénjúnyo a yau so ewarawenat wénde so esmetat krot. ");
INSERT INTO nmx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Yénémamén féfenjo mérén kénjúmén ár so kénokayongi a elimndat efalo yátogh ár ménát so ewaitotat yéfene unyégh watamegh. ");
INSERT INTO nmx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Aya kor fém nawarawenatiǃ Té nawafarotati ndené nambio yunjéf yéndon tawawéngsotawén ekmboghofnar fém ámbiroámbiroe yengamafé méinyotio efogh a sémbár. ");
INSERT INTO nmx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Yénémamén sénonjo yéndon ewatetan fém kétán Ngánjánefaf a kétán ngárám sifaf, árké siam fém so ewanote a efrende méinyotio efe té efaloi yandio. ");
INSERT INTO nmx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Yéndon yau féfene sáláme o mani mwighaye takwnan tayot. ");
INSERT INTO nmx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Fém méinyo mat em ndené yénd tanjo ngángaye kásáfotawén tanjo sálámet a maniot a ndenéyameyo tane fútarat. ");
INSERT INTO nmx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yéné ende yéndo té tawauyafotan ndernáye fém so emor. Fém so násáfotati táikrataye ménát yauyau ár so ewáutánati, so nawafarotam Yuré Yesuene si fá árké korayau: 'Ramégh ároene áuwégham yáinde yáne áuwégh emo rokar tanangé.'” ");
INSERT INTO nmx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Njam Folém si ewifoi, fá méinyotio budme neitaménd Ngánjánafé orayéghét. ");
INSERT INTO nmx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Féyo táf yémofem yengamafé yambnayénd a Fol tésnetawét. ");
INSERT INTO nmx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Fá áuwéghofnar tamorwén ménamén Fol árké norayai ndené ámb káye tane sáf yau so kor yéfandati. Féyo yémofem engémnjoyénd ndimbal boutfaf. ");
INSERT INTO nmx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yéndfem yao si engwaramayém yéfeyot, yéné soramé yénd boutan nénguflayém a tényotau kétán Kos férot. Ámb efghon yénd nénguflayém kétán Rodas férot a kétándmé kétán Fatara yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Yéndfem ndimbal bout yinjoyém kéférmetau kétán Fonisia yuwot, wéi nénguflayém ténngmorwén. ");
INSERT INTO nmx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Soramé Saifrus yu yéngwinjoyém, yéngwaindayém náikáita kétán Siria yuwot. Yénd nurtoyém Taire yuwon, kété árém turtotawét rokar ndimbal boutta. ");
INSERT INTO nmx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yesuene waitogh ár ewinjoyém kété, yémafé yénmorangérmén sefen efogh. Ngánján Mbérmbér waftayan yémofem yémndayénd Fol yau álighét kétán Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Efogh njam nawerai frangoghét, yéndfem yéfrangoyém a néngwanoyém boutfaf mérne méinyotio waitogh ár a yéfene amaf a ambumtértér tesenta. Kété arakaf téndon yénd budme niayém Ngánjánafé korayawém. ");
INSERT INTO nmx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Yao si soramé norayayénd yéfendio, yénd nénguflayém ndimbal boutan, a fá nénangoyénd méngot. ");
INSERT INTO nmx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Yéné soramé yéndfem áligh yéngwasamngoyém kétándmé Taireta a néngamghayém Tolemais tesen. Kété yénd áuwéghafé nawinjoyém fútarafé kété yénmorangérmén ámbiro efogh. ");
INSERT INTO nmx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ámb efghon yénd néngufaryém Kaisaria tesen a yénmorangérmén Filifene méngon. Yéné Filif siyém si waitogh ár a ámb sefenmén efe yékafayénd ménát kwiré amafat wáutáréghét. ");
INSERT INTO nmx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Yáne awerghofnar mérés tamorwén fo emofem Ngánjánene si táitotawét. ");
INSERT INTO nmx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Yénd kété yénmorangérmén tárfár efogh, Ngánjánene mat yátogh ár yétkwén Agabus yénmormén kétándmé Judiata. ");
INSERT INTO nmx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Téfefaf nénaflai, yémon tékafangé Folene beles. Féyo yémo yánjo ngángé a kafkaf eumbai yéné siafé, “Ngánján Mbérmbér norayai, 'Yéné ende Jerusalemén Ju árém so yumbetat yéné beles yuré a so téramangi Téndo árfene ngángat.'” ");
INSERT INTO nmx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Yénd njam náyárayém yéné si, yénd a ámb ár norayayém Fol, “Fém yau so niota Jerusalemét.” ");
INSERT INTO nmx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Féyo Folém yénmawangoi, “Némamén fém ye nendati tane tikéf karéfkaréf yafrotati? Yénd wém afrengéghkaf umbghét a kérot Jerusalemén Yuré Yesuene yétkwénot.” ");
INSERT INTO nmx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yéndfem ndernáye ende yau so áfrat kényátongém, féyo yénd nékmboyém a norayayém, “Yurane méndero so nufrote.” ");
INSERT INTO nmx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Yéné soramé, yénd nafrendamém a néngwanoyém Jerusalemét. ");
INSERT INTO nmx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ámb waitogh ár kétamamén Kaisaria yénngmaitoyénd a yénngémnjoyénd kétán Nasonene méngot ánde yénd so ténmorangérwén kété. Fá témorwén Saifrusmén ár a ámb fronde waitogh ár. ");
INSERT INTO nmx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Njam yénd néngufaryém Jerusalemét, efalo yátogh árém yénmumyoyénd yénd áuwéghafé. ");
INSERT INTO nmx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ámb efghon Fol a ámb ár néngaflayém kétán Jemsefaf, méinyotio sénko ár kété tamorwén. ");
INSERT INTO nmx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Folém áuwégh si ewaramai a tawaufrotau méinyotio yam némé Ngánjánam tafrotau Téndo árfefaf yáne ásáfoghan. ");
INSERT INTO nmx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Yémofem njam káyáretawét yéné si, yémofem Ngánján tuwetawét. Féyo yémofem korayangi Folefaf, “Fútar, téfanda nderé tárfár 1,000 Ju árém efalo yiyátoyénd, yémofem méinyotio sote mé táitotawét nák. ");
INSERT INTO nmx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Yéné Ju ár té náyárangi fémon némé taitote Ju árfefaf efe tamorangérwén Téndo árfefafmé. Fá ndené kemnawét fémo kar tamndetau, 'Fém yau táf náyáretati Mosesene nákfaf ndenayu. Fémofem yau táf ghéngan enfetati féfene ambumtértér. Fém yau so emor ndené ende Ju ár kés emor.' ");
INSERT INTO nmx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Némé yéndfem so yafrotam? Fá so káyárangi ndené fém té kéném. ");
INSERT INTO nmx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Féyo tafrota némé yéndfem némndetam. Yéna em yéndfé fo Ju efalo yátogh ár emofem unyéghofnar si norayayénd Ngánjánefaf. ");
INSERT INTO nmx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tangémnjongi yéné ár wáwefnogh méngot, so ngufnyangi yéfenjo wányányégh téméndfaf a so fai nufrotat ghéngén raméghmén. Yéné soramé yémofem so yéfenjo sénko séf ewérnat. Féyo méinyotio ár mat so em kété siyém efalo si yau yényau afrogh sian fenemén, wénde fém fémyo némor ndernáye nák noraye. ");
INSERT INTO nmx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ndenaye téndo efalo yátogh árfenemén, yéndfem téfarotam yéfe téfene mwighé ndené yémofem yau táf enetat mewang njamke, a férék, a férék eréghofnar wérár, ndenéyameyo téndo wal.” ");
INSERT INTO nmx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ámb efghon Foléf engmormén ámb árfé a yémofem yafrotaménd yéné téméndmén yam ndernáye témorwén wányányéghmén. Yéné soramé, fá néngwanoi wáwefnogh méngo sifayat a tamndetau ghéngén wárogh ár, “Kétán árké efghot so em sái kénamndangi njúnnjúnofnar yam so kefongé, yéndfem so enérsam ghéngén yénat.” ");
INSERT INTO nmx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Njam sefen efogh awaingétro tamorwén, ámb Ju ár kétándmé enmormén Esia marat yuta Fol yinjoyénd wáwefnogh méngo sifayan. Fá nékwafé naindaménd ár mérén eumendayénd a Fol yerayénd. ");
INSERT INTO nmx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","A fá korayawét ndené, “Israil ár, ténmáutánangiǃ Yéné ár fiyém emo ewatamete méinyotio ár méinyotio yuwomé téfene ár ewasérmbote a téfene nák a yéné wáwefnogh méngo. Yémon enwasroi Grikmén ár wáwefnogh méngot a taghnawét yéné njúnnjúnofnar sifayé.” ");
INSERT INTO nmx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Méné téfnan fá norayayénd ndené ende ménamén yémofem té ewinjeyayénd Téndo ár Trofimus Efesosmén Folfé tesenan a fá nemnayénd ndené Folém ténémnje wáwefnogh méngot. ");
INSERT INTO nmx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Méinyotio tesen ár néngenngoyénd wéla end kafemé. Kété Fol yerayénd, yémofem téngroghawét kétándmé wáwefnogh méngota. Tekofnaye wáwefnogh méngo sésafne emnayénd. ");
INSERT INTO nmx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Yémofem ngiot yafngoyénd Fol njam Rom fiyaré ndimbal sénko árom náyárai ndené méinyotio Jerusalem tesen sarakeyan témorwén. ");
INSERT INTO nmx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yémon táf fété ámb fiyaré sénko ár a fiyaré ewerai a néngenngoyénd kétán ár mérnafefaf. Njam ngi téfnáram yinjoyénd fiyaré ndimbal sénko ár a yáne fiyaré, fá nékmboyénd Fole ngita. ");
INSERT INTO nmx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Fiyaré ndimbal sénko ár nénaflai a yerai Fol a ewáfáretai umbghét ménaye sómbio seine. Féyo fá namotai, “Efe fá yém a némé yémo tafrote?” ");
INSERT INTO nmx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ámb yéné mérén kénjún kutnawét, yémo tafrotau yéné yam a ámb fénatayam tafrote. Wénde ménamén fá ménjtaye kutnawét minde ke, fiyaré ndimbal sénko árém efalo si yau yékafai. Féyo yémo emndai, “Téngémnjongi yéné ár kétán fiyarafene sifayat!” ");
INSERT INTO nmx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Njam Fol raté kaka namndai, ár mérén minde nékwafé nafghetaménd. Yénémamén fiyaram yuyoyénd ménát yambayénd. ");
INSERT INTO nmx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ár mérén efe kuwaitotawét ménjtaye mé kutnawét, “Téngésmangiǃ Téngésmangiǃ” ");
INSERT INTO nmx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Njam Fol ménjághétro témorwén kétán fiyarafene sifayat, yémo témotangé fiyaré ndimbal sénko ár, “Féyotaro yénd so korayangén ámb si fefaf?” Fiyarafene ndimbal sénko árom yémotai Fol, “O, fém mat ném Grik si? ");
INSERT INTO nmx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Fém yéné ném Ijifmén ár emo yérnyai awifarégh nambétio elimai 4,000 fiyaré kétán fanfne sifayat?” ");
INSERT INTO nmx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Folém yawangoi, “Yau, yénd yau! yénd swém Ju ár, kété náráftamén Tarsus tesenan, árké yém mer marataye matkaf tesen Silisia kénjún. Féyotaro yénd so kwumyo yéné árfefaf siot.” ");
INSERT INTO nmx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Fiyaré ndimbal sénko árom yumyoi siyot, Fol nokayoi ratayan a ekmboi ár. Fá njam métar náyátoyénd, fá korayangé yéfefaf Ibru sie. ");
INSERT INTO nmx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Fútaréf a afaf, kénáyárangi tane awamarogh sifaf.” ");
INSERT INTO nmx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Njam yémofem yiyárayénd Fol korayau Ibru sie, fá métar namndayénd. Féyo Folém korayangé, ");
INSERT INTO nmx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yénd swém Ju ár, náráftamén Tarsus tesenan Silisia yuwon, wénde nanotamén Jerusalemén. Wémormén watametaménd afafene náke a Gamaliel siyém tane watamegh ár. Yénd ménde kwémorwén sái tiyáretawén Ngánján merkéráye ndené méinyotio fémofem sewafrotati sénonjo. ");
INSERT INTO nmx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Yéndon tásmetawén ár kérotio efe kuwaitotawét yéné Endén, taweretawén ár a amaf a tangwitawén kwéfkwéf méngot. ");
INSERT INTO nmx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ghéngén wárogh sénko téfnár a méinyotio Ju sénko árfene áumengégh téfnáram so nafrotat yéné simén efalo yém. Yémofem kwaramangayénd férén Ju árfefaf Damaskos kénjún. Féyo yénd kwéngmorwén kétán yéné ár tánémnjawén ndené fété kwéfkwéf méngo ásáfogh ár kétán Jerusalemét kértayan kémghét. ");
INSERT INTO nmx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ámb efogh sotan, njam kaka yéngyátoyén Damaskos, sélngwéle njafarmén ndimbal kwayaghayam wélálái yénd. ");
INSERT INTO nmx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Yénd nuyáyén mbandot a náyárayén kém a norayai tafaf ndené, 'Solǃ Solǃ Fémo némamén yénd wésmete?' ");
INSERT INTO nmx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Yénd namotayén, 'Fém efe ném, Yuré?' “Yémon ta wawangoi, 'Yénd wém Yesu Najaretmén. Fémo wésmete.' ");
INSERT INTO nmx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Tane mérnam yinjoyénd kwayaghé, wénde yémofem yau yáyámngoyénd yáne kém efe korayau tafaf. ");
INSERT INTO nmx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Yéndon yémotayén, 'Némé so yéndon yafrotan, Yuré?' “Yuram kwémndetau, 'Kokai, kuwano kétán Damaskosét. Kété árém so kémaufrongé méinyotio fene ásáfogh némé so yém.' ");
INSERT INTO nmx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tane mérnam kwémnjawét Damaskos kénjút, ménamén ndimbal kwayaghayam ghékéf kwéfkwéf wiyátoi. ");
INSERT INTO nmx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ár yétkwén Ananias yénmormén ta fandaghét. Fá témorwén Ngánján wáwefnogh ár a ndimbal kéráye tutémndawét Ju árém efe méinyotio kété tamorangérwén. ");
INSERT INTO nmx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Fá nokayoi ta kaka korayangé, 'Fútar Sol, kéretaǃ' Táf fété néretayén yinjoyén Ananias. ");
INSERT INTO nmx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Féyo Ananias norayai, 'Téfene ákifene Ngánjánam némafer fém ménát yáne mwighé mat fém so ném a ménát so tinjo mbarkánd ár a náyáreta si yáne mbírmbírta. ");
INSERT INTO nmx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Fém so ném yáne fandagh ár méinyotio árfefaf némé té téfandau a káyáretau. ");
INSERT INTO nmx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sénonjo némat fém nawanjete? Kokai, so némálitotat a Ngánján so tawalindangé fene yaufi táf njam Ngánjánafé oraighan ném Kerisoene yétkwénan.' ");
INSERT INTO nmx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Yéné soramé yénd néngangoyén Jerusalemét a Ngánjánafé koraiwém wáwefnogh méngon. Yéndon yinjoyén ghékéf waingégh yam ");
INSERT INTO nmx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","a Yuram kwémndetau, 'Wékeye kuwano Jerusalem téfrango ménamén yémofem yau so tumyongi fene afrogh si tanemén.' ");
INSERT INTO nmx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Yéndon yawangoyén, 'Yuré, yéné ár mat em tanemén ndené yénd kwiotau tárfár Ju árfene áumengégh méngomé. Yéndon taweretawén kwéfkwéf méngot élaughét a tásmetawén ár emofem efalo kényátotawét fém. ");
INSERT INTO nmx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Njam árém yésmetaménd Stifen ménamén fá korayau árfefaf fenemén, yénd kété kwakayongérwén a ámbiro tikéfan ténmorwén yémafé. Yéndo tawanjetawén yéfene sáláme emofem tésmetawét kérot Stifen.' ");
INSERT INTO nmx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Féyo Yuré norayai tafaf, 'Kuwano, yéndon so némáfáretan fém nayu yuwot kétán Téndo árfefaf.'” ");
INSERT INTO nmx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ár mérnam kor merkéráye káyáretawét Folefaf kétánotio njam fá norayai téndo árfenemén. Yémofem kém euyoyénd nékwan a kutnawét, “Yéné ár titérmbongi yéné yutaǃ Fá yau féyotaro yém mé ghérsé sái yémǃ” ");
INSERT INTO nmx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Fá ke kutnawét a tafnendawét yéfenjo sáláme a ngwérméng tétnendawét tukét. ");
INSERT INTO nmx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Fiyaré ndimbal sénko árém yánjo ár ewáfáretai Fole wasroghét kétán fiyarafene sifayat. Yémon emndai yánjo ár Fole ngiot. Yéné ende fá ménde témorwén yáne árém so tinjongayénd némamén ár mérén kutnawét Folefaf. ");
INSERT INTO nmx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Njam fiyaram ngiot yafngoyénd, yémon yémndai fiyaré sénko ár, “Yufi yém Rommén ár ngiot endene yaufi yau yinjongi!” ");
INSERT INTO nmx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Njam fiyaré sénko ár náyárai yéné si, fá naflai kétán fiyaré ndimbal sénko ároefaf a yémndai, “Yau yafrota yéné yam yéné árofefaf. Yéné ár siyém Rommén ár.” ");
INSERT INTO nmx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Fiyaré ndimbal sénko ár néngaflai Folefaf a yémotai, “Kwaufro ta, fém fété ném Rommén ár?” Folém yawangoi, “A, yénd fété wém.” ");
INSERT INTO nmx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Féyo fiyaré ndimbal sénko ár norayai, “Yéndo ndimbal mani té ekman so kamndangé Rommén ár.” Folém yawangoi, “Wénde yénd náráftamén Rommén árot.” ");
INSERT INTO nmx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Fiyaré efe ngiot a ámoghétro femormén Folefaf, táf fété yau yafrotaménd. Fiyaré ndimbal sénko ár férféram yifoi, ménamén yémon emndai yánjo ár Fole umbghét, wénde Fol témorwén Rommén ár. ");
INSERT INTO nmx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ámb efghon, fiyaré ndimbal sénko árom téronjau téfén némamén Fol tékarotawét Ju árém. Féyo ámb efghon fiyaré ndimbal sénko árom Folene sein yaferyéng. Fá wéi emndai limánégh ghéngén wárogh ár a méinyotio Ju sénko ár áumengéghét. Yémon yéngémnjoi Fol a Ju sénko árfene sáfrére nokayoi. ");
INSERT INTO nmx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Fol néngretai mbarkánde kétán Ju sénko árfene áumengéghfaf a norayai, “Tane fútaréf, yéndon tafrotan tanjo ásáfogh Ngánjáne sénonjo méinyotio mer mwighaye.” ");
INSERT INTO nmx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Féyo Ananias limánégh ghéngén wárogh árom ewáfáretai ár efe kaka tawakayongérwén Folefaf mbírmbíran ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Féyo Fol norayai yáfaf, “Ngánjánam so kéntarmangé, fém farun nérete mer wénde kénjún yau! Fém yéné nénámnjo ta moghét Mosesene nákafé, wénde fémon yéráfne nák yénaye yénd swésmetati.” ");
INSERT INTO nmx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Efe tawakayongérwén Fole kaka norayayénd, “Fémon yasalite Ngánjánene limánégh ghéngén wárogh ár!” ");
INSERT INTO nmx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Folém ewawangoi, “Fútaréf, yénd yau mat kwémorwén ndené fá siyém limánégh ghéngén wárogh ár. Ménamén si ndené yékai, 'Yaufi si yau norayati féfenjo limánégh ároefaf.'” ");
INSERT INTO nmx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Fol mat náyátoi ndené ámb ár tamorwén Saduki ár a ámb Farasi ár, fá néngutnayéng ár mérnafefaf, “Tane fútaréf, yénd swém Farasi ár, Farasi árfene ambum. Yénd wakayong ufoghamé ménamén tane méghmégh kérta anoghmén.” ");
INSERT INTO nmx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Njam fá norayai yéné si, Farasi ár a Saduki ár nafaloyénd a éwigh yérnyayénd. ");
INSERT INTO nmx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ménamén Saduki ár korayawét ndené kér ár yau so nanotat ghérsat, yémofem efalo yau tiyátotawét ndené njafar si résagh ár a mbérmbér kété em. Wénde Farasi árém efalo tiyátotawét méinyotio yéné yam. ");
INSERT INTO nmx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Yénémamén kété témorwén ndimbal sarake, ámb nák watamegh ár efe tamorwén Farasi ár tawakayongérwén éwigh nufngoyénd, yémofem norayayénd, “Yéndfem yau yinjongém yéné ároene yaufi, némé mbérmbér o njafar si résagh ár korayat yáfaf?” ");
INSERT INTO nmx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Yéné éwigh minde tukén namndai, yénémamén fiyarafene ndimbal sénko ár férféram yifoi ménamén Fol mété téftérnawét árém. Yémon ewáfáretai fiyaré yéngwanayénd Fol yéfenemén wékeye kétán fiyarafene sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yéné sémbáran Yuré nokayoi kaka Folefaf a yémndai, “Férfér yau némǃ Ndené fété kés noraye tanemén Jerusalem kénjún, ndenéyameyo tanemén so wéi nafrote kété Romén.” ");
INSERT INTO nmx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ámb akwan ámb Ju ár náumendayénd a unyéghofnar si norayayénd, “Njamke a nu yau so enetam kétánotio Fol kor yésmetam krotio.” ");
INSERT INTO nmx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kété tamorwén tárfáryo 40 Ju ár tambén emofem mwighé téfaronawét mérne. ");
INSERT INTO nmx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Fá néngaflayénd limánégh ghéngén wárogh árfefaf a norayayénd, “Yéndfem unyéghofnar si norayam ndené yau so mé enetam kétánotio Fol kor yésmetam krotio. ");
INSERT INTO nmx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Fém a áumengégh ár tangém kétán fiyaré ndimbal sénko ároefaf a taunyangi ndené ménde yéném kor ronjaghét matot Folenemén. Tamnendangi fá a ténmasrongi fene sáfrére moghét. Yénd yéna so nawanjetam end néndkéfan Fole ngiot.” ");
INSERT INTO nmx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Wénde njam Fole yánjafam náyárai ndernáye Ju ár mwighé kémnawét yá ngiot, fá táf néngaflai fiyarafene sifayat a Fole yaufroi. ");
INSERT INTO nmx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Féyo Folém yémotai ámb fiyaré sénko ár a témndangé, “Téngwasro yéné totér ár kétán fiyaré ndimbal sénko ároefaf, ménamén yáfaf ámb si em yá waufroghét.” ");
INSERT INTO nmx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Féyo yémo yéngémnjoi fiyaré ndimbal sénko ároefaf. Fiyaré sénko árom témotangé, “Fol, kwéfkwéf méngo árom wémnde. Fá ténmasro yéné totér ambum fefaf, ménamén yáfaf ámb si em fe sái kémaufrongé.” ");
INSERT INTO nmx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Fiyaré ndimbal sénko árom yéngwasroi totér ár téndot ménát ár yau so káyárangayénd a témotangé, “Fene ménde némé yém kwaufro?” ");
INSERT INTO nmx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yémon korayangé, “Ámb Ju árém mwighé téfaronat ménát fém sái kénmotangi Fole wasroghét Ju sénko árfene áumengégh sifayat kaitau. Fá ménde em kor sái tawinjongi mbarkánd si yánemén, wénde fá so nuindat. ");
INSERT INTO nmx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Yau yafrota némat fá namotangi wafroghét, ménamén tárfáryo 40 árta nawanjetat Fole ngiot. Yémofem unyéghofnar si norayayénd yau njamke a nu nénet kétánotio Fol yésmetat. Sénonjo fá nawanjetat fene uwangogh siotro.” ");
INSERT INTO nmx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Fiyaré ndimbal sénko árom yémndai totér ár, “Yau taufro ende ndené fémo té waufro yéné ta.” Féyo yémo yéngwatembai totér ár. ");
INSERT INTO nmx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yémon emotangeyayai yánjo sómbio fiyaré sénko ár a emndeyai, “Takafend 200 fiyaré, 70 os wérse ár a 200 námb táikér ár so kuwanongi Kaisariat 9 aklok sénonjo sémbár. ");
INSERT INTO nmx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ámb os taramend Fole ménát fá merro so néngérse gafana Feliksefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yémo yéné férén yéfarotam ndené, ");
INSERT INTO nmx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudius Lisias, Kétán fene utmanégh yétkwén Gafana Feliks, Áuwégh yém. ");
INSERT INTO nmx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yéné ár yerayénd Ju árém a yémofem ngiot térametawét, wénde yénd tanjo fiyaré mérnafé wénmormén wanjarghét, ménamén yénd mat namndayén ndené fá témorwén Rommén ár. ");
INSERT INTO nmx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yénd ménde kwémorwén matot némamén yémofem tánangotawét, yénémamén yéndon yéngwasroyén yéfene sénko árfene áumengégh sifayat. ");
INSERT INTO nmx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Yéndon yinjon yéné wátaranégh siyém moghan so yém yéfene nákan, wénde kété ámb téfén yau témorwén yáfaf árkémamén krot so yém o kwéfkwéf méngon tényawangi. ");
INSERT INTO nmx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Njam yénd mat wiyátoyénd yéfene wátaranéghmén krot yéné ároenemén, yéndon táf fété yéngwáfáretayén fefaf. ");
INSERT INTO nmx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Fiyaram yéfenjo si ewaitoyénd. Yémofem yéngwasroyénd Fol sémbáran a yéngémnjoyénd Antifatris yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ámb efghon ámb fiyaré nénangotaménd Jerusalemét fiyarafene sifayat, wénde os wérse ár mé tangmorwén Folfé. ");
INSERT INTO nmx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Njam fá nufaryénd Kaisariat, yémofem yaramayénd férén Gafana Felikse, a yafnamoyénd Fol yáfaf. ");
INSERT INTO nmx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gafanam férén yaftam a yémotai árké yumén fá témorwén. Njam fá mat náyátoi ndené Silisiamén témorwén, ");
INSERT INTO nmx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","yémon yémndai, “Yénd so náyáretan fene kérté njam fene wátaranégh ár kufarngi.” Féyo yémon ewáfáretai fiyaré Fole wanjengét warsagh ár Erodene méngon. ");
INSERT INTO nmx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Faif efogh soramé limánégh ghéngén wárogh ár Ananias néwanoi Kaisariat yémafé ámb sénko árfé a néndkéf ár Tétulus, yémofem yénérsaménd yéfenjo áwátaranégh Folenemén gafanafaf. ");
INSERT INTO nmx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Njam Fol yanmoyénd kénjút, Tétulusém yáne áwátaranégh yéramai Feliksefaf. Fá norayai, “Fémo té yénmaramai tombé yu krufráte, a fene mwighé té yénérsam mer téfene yuwot. ");
INSERT INTO nmx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Utmanéghafé Feliks, méinyotio yéné yammén yéndfem kánjo némarametam mindefifi yénémamén feyot. ");
INSERT INTO nmx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Wénde yénd yau ménde wém yongnayafé sái kényátongén fém, yéndo némamnendan fémo so kwumyo sénonjo siot. ");
INSERT INTO nmx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Yéndfem té yinjongém yéné ár ndené kérté wafrogh ár yém, kérté té tawafrote Ju árfefaf méinyotio yuwon. Fá siyém yéné mérénmén sénko ár yémndetat Najaretmén ár, ");
INSERT INTO nmx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","wéi téfé yafngoi wasérmbogh wáwefnogh méngo, féyo yéndfem yerayém fá. ");
INSERT INTO nmx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Wénde fiyaré ndimbal sénko ár Lisias yénmormén a yéngwasroi fá téfe tambén minde waftafé. ");
INSERT INTO nmx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Fémon so tinjo efalo si téfene wátaranéghmén ménaye fémonyo sái yafénmeta fá.” ");
INSERT INTO nmx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ámb Ju ár nufnyayénd wátaranégh kénjút, fá norayayénd ndené méinyotio yam Tétulusém árké noyarai efalo yém. ");
INSERT INTO nmx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Njam Gafanam yéméindai fá siot, Folém yawangoi, “Yénd mat wém yéné yunjéf tárfár fém té kéném mwighé farorégh ár yéné ndimbal yuwot, féyo yéndon áuwéghafé tanjo awamarogh yafrotan fene sáfrére. ");
INSERT INTO nmx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Fémon so wékeye tayamngo ndené 12 efogh soramé yénd nufaryén Jerusalemét wáwefnoghét. ");
INSERT INTO nmx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tane wátaranégh árém yau winjoyénd yénd éwighan ámb árofé wáwefnogh méngon, yau taméindan awifaréghét ár mérén Ju árfene áumengégh méngomé o árkamé ámb yau ndimbal tesenan. ");
INSERT INTO nmx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Fá féyotarofnar em yátoghét safén fefaf yéné yammén árkémamén yénd watarnat. ");
INSERT INTO nmx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Wénde ámb si kafe némé fá norayat siyém efalo, árké yém ndené yéndon yáwefnotan tane ákifene Ngánjáne ndené fété End waitogh ár. Fá norayat yémofem wáwefnogh yafrotat efalo Ju árfene ende, wénde fá norayat yéndo wáwefnogh yafrotan fénaté efalo yátoghe. Wénde yéndon efalo eyátotan méinyotio némé ekai nákan a némé efarotaménd Ngánjánene mat yátogh árém. ");
INSERT INTO nmx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Tafaf yém ndené méghméghyo Ngánján kénjún yéné árfefaf kés em, kété so anogh yém mbarkánd árfefaf a yaufi árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yénémamén yénd so nufotan túmén ménát tane emarégh kwayaghé so yém Ngánjánrére a árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Tárfár yunjéf yukér soramé, yénd wénmormén Jerusalemét engérsamén tane árfene mani yauyau árét a ghéngén ramghét. ");
INSERT INTO nmx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tane wátaranégh árém winjoyénd yénd wáwefnogh méngon njamandio yénd kwémorwén wányányégh wifogh tárfáran. Kété yau ár mérén tamorwén yéndfé, yau ámb usérmbogh. ");
INSERT INTO nmx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Wénde kété ámb Ju ár tamorwén kétamamén Esia yumén. Táf yéfene njam ewam áwátaranégh tafaf, fá fiya tanmorwén yéna fene sáfrére a tanérsawét wátaranégh. ");
INSERT INTO nmx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Tamotangi yéné ár yéna, yémofem so tawaufrongi ndené mámáfi yau yinjoyénd njam yémofem wéngwanayénd moghfaf Ju sénko árfene áumengégh kénjút. ");
INSERT INTO nmx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ámbiro yaman yénd nutnayén njam yénd kwakayongérwén yéfene sáfan: 'Yénd ufoghan wém féfene sáfan sénonjo ménamén tane efalo yátogh yém árfene anoghmén kérta!'” ");
INSERT INTO nmx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks mer mat náyátoi Yesuene Endmén, féyo njam náyárai yéné sioene fifi, yékmboi mogh a yémndai, “Njam fiyaré ndimbal sénko ár Lisias kénaflangé, yéndon so mwighé yéfaronan fene awataranéghmén.” ");
INSERT INTO nmx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Yémon yáfáretam fiyaré sénko ár Fole wanjengét wénde yaramai ámb enagh a yumyoi yáne fútaram so tawarametawét yáne méndefé rokar. ");
INSERT INTO nmx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Tárfár efogh soramé Felikséf enérmén yánjo amaf Drusila, efe témorwén Jumén amaf. Yémo yáfáretam yánjo ásáfogh ár Fole wasroghét. Fá ménde tamorwén sái káyáretawét Folefaf árfene ndimbal mwighamén Keriso Yesuene kénjún. ");
INSERT INTO nmx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Fol korayawéng mbarkánd ghérsamén, fémyo awaraweréghmén a mogh efoghtaumén árkéméné yéném, Feliks férfér témorwén a norayai, “Féyo tém sénonjoyot. Fém téu kuwano. Efogh njam wam yéndon so kéngmotangén ménát sái néném tafaf wéikor.” ");
INSERT INTO nmx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Yéné efghonyo fá témorwén emarghan ndené Folém so mani taramangai, féyo fá túmén yémafé kafángowét a koraiwét yémafé. ");
INSERT INTO nmx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Sómbio yunjéf soramé, Forsius Festus nosoi Gafana Feliksene sifayan. Wénde ménamén Feliks ménde témorwén Ju árfene ménde sái tawawafrotau, yémo yéfrangoi Fol kwéfkwéf méngon. ");
INSERT INTO nmx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus namndai gafana, nambio efogh soramé fá nuwanoi Kaisariata kétán Jerusalem. ");
INSERT INTO nmx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Jerusalem kénjún, limánégh ghéngén wárogh ár a Ju árfene sénko ár nufaryénd yáne sáfrére a yéramayénd wátaranégh si Folenemén. ");
INSERT INTO nmx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Yémofem yamnendayénd Festus yéfene méndeyot Fole wasarghét Jerusalemét, ménamén fá káfrendawét yá ngiot endén. ");
INSERT INTO nmx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festusém ewawangoi, “Fol siyém té yangongi kwéfkwéf méngo ár yém Kaisarian, a yéndio so wéngém tekofnaye. ");
INSERT INTO nmx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","So ámb féfene limánégh árfé yénngém yéndfé, a njam yéné árom némndafi mámáfi yafrota, yémofem so wátaranéghan tékmangi fá.” ");
INSERT INTO nmx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","8 o 10 efogh ámnjogh soramé yémafé, Festus néwanoi Kaisariat. A ámb efghon yémon yanmoi mogh a emndai Fol sái ténémnjongayénd yáfaf. ");
INSERT INTO nmx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Njam Fol nélawai kénjút, Ju ár efe enmormén kétándmé Jerusalemta yarendayénd fá. Yémofem enérsaménd yáfaf tárfár kwérnarafé wátaranégh si, wénde fá féyotarofnar emormén yátoghét yéfene wátaranéghan. ");
INSERT INTO nmx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Féyo Fol fáyo nawamarotai, “Yéndon yau ámb mámáfi tafrotan kétán Ju árfene nákfaf o wáwefnogh méngofaf o Rom tuk warsagh ár Kaisarefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus ménde témorwén Ju ár sái áuwéghét taméindau, Folefaf norayai, “Fém ménde té ném álighét Jerusalemét a sái némakai tane sáfrére yéné wátaranéghan?” ");
INSERT INTO nmx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Folém yawangoi, “Yénd sénonjo wakai Rom tuk warsagh ár Kaisarene mogh sáfrére, árké yém mbarkánd sifayé tayot moghét. Fém fémyo mer mat em ndené yéndo ámb yau mámáfi tafrotan Ju árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Wénde yéndon njam té tafrotan mámáfi, féyo moghan yénd so wésmetat kérotio, yénd yau nawatnan kérot. Wénde njam fá nuindat moghan féyo emo yau so kwengongé yénd kétán yéné árfefaf ménát sái wésmetat kérotio. Yénd mé nawatarnan Rom tuk warsagh ár Kaisar sái náyáreta tane mogh!” ");
INSERT INTO nmx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus yánjo árfé korayawét, yéné soramé fá norayai Folefaf, “Fém té norayai, 'Kaisarém so náyárete tane mogh.' Yénémaménnde, fém so kuwano Rom tuk warsagh ár Kaisarefaf!” ");
INSERT INTO nmx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nambio efogh soramé warsagh ár Agrifa a Bernisa nufareyayénd Kaisariat. Fá enérmén ménát sái tumyeyayénd Festus. ");
INSERT INTO nmx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Njam fá emorarmén tárfár efogh kété, Festusfem taruinwét Agrifafé Ju árfene wátaranéghmén Folefaf. Fá norayai, “Ár yéna yém kwéfkwéf méngo ár efe Feliksém yéngéfrango. ");
INSERT INTO nmx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Njam yénd wéngmormén Jerusalemét, limánégh ghéngén wárogh ár a Ju árfene sénko árém enérsaménd wátaranégh a wémotayénd ménát Fol sái kértayan tékmangayén. ");
INSERT INTO nmx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Yéndon ewawangoyén, 'Fém ndené norayati yéné árom té tafrote mámáfi yam. Fá fronde so kokayongé féfene sáfrére efe nawatarnat yáfaf. Féyo yémon so tawawangongé féfe, féyo yéndo so táf moghan tákman efe yém mbarkánd. Yéné fiyém téfene Rom nák.' ");
INSERT INTO nmx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Njam yáne wánangogh ár yénmormén yénan, yéndon yau yalayén yéné kérté. Wénde yénd náumendayém moghét ámb efghon a emndayén yéné ár yénmasroyénd kénjút. ");
INSERT INTO nmx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Yáne wánangogh ár nokayoyénd a norayayénd. Yénd kemnan ndené fá so norayat ndené Folém té ámb minde mámáfi yam tafrote. Wénde fá yau yéné si norayayénd. ");
INSERT INTO nmx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Wéndende, fá yémafé kéwitawét Folfé ménamén némé Ju árém tawatametawét Ngánjánenemén. Fá kéwitawét yánemén efe kér té yémormén Yesu. Wénde Fol ndené korayau fá ghérsé mé yém. ");
INSERT INTO nmx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Yénd yau mat wém ndernáye so tawafénmetawén yéné áwátaranégh. Féyo yéndon yémotayén fá, 'Fém té ménde ném ménát álighét Jerusalemét a némakai kété ufoghan yéné wátaranéghan.' ");
INSERT INTO nmx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wénde Folém wawangoi ta, 'Yau, yénd ménde wém Kaisarém sái náyáreta tane si.' Yénayan yénd norayayén tane fiyarafaf, 'Ménát Fol sái tumbetau yéna kétánotio yéndon téngwatemban Kaisarefaf.'” ");
INSERT INTO nmx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Féyo Agrifa norayai Festusefaf, “Yéndon so yiyáretan fá némé si njam noraya.” Yémon yawangoi, “Káye fémo so yiyárete.” ");
INSERT INTO nmx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ámb efghon Agrifa a Bernisam numaneménd mer sáláme. Fá nélaweyayénd Gafaman méngot yémafé fiyaré sénko árfé a utmanégh ár tesenmén. Festusém emndai yánjo ár, “Ténmasrongi Fol yénan.” ");
INSERT INTO nmx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus norayai, “Warsagh ár Agrifa a méinyotio efe yéna em yéndfé, fémofem téfandangi yéné ár! Méinyotio Ju árém wamnendangi yénd Jerusalemén a yéna Kaisarian, kutnawét ndené fá yau so nakete. ");
INSERT INTO nmx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Wénde yéndon yau yinjoyén yáne yaufi wafroghyam árkémamén fá krot yékmetat. Wénde ménamén fá wéikor norayai fá ménde témorwén Kaisar sái káyáretau yáne áwátaranégh. Féyo yéndon mwighé yafrotamén yá watembghét kétán Rom. ");
INSERT INTO nmx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","“Yénd yau mat wém némé yéndon so yéfarotan Rom tuk warsagh árfefaf yánemén. Yénémaménnde yéndon té ténémnjan fá méinyotio féfefaf. Warsagh ár Agrifafaf, yéndon némamnendan fém kor merkéráye náyáreta némé Fol noraye. Féyo yénd so táf norayam yéné kértamén mérne. Soramé yéndon so mbarkánde férén yéfarotan kétán Kaisarefaf. ");
INSERT INTO nmx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Yénd norayan yéné ménamén njam yéndfem tatembangém kwéfkwéf méngo ár kétán Rom tuk warsagh ároefaf téfnofnar yuwon, féyo yéné yau so mer yém.” ");
INSERT INTO nmx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Féyo Agrifa norayai Folefaf, “Koraya sénonjo.” Féyo Folém ngángé euyoi a norayai awamarogh si, ");
INSERT INTO nmx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Warsagh ár Agrifa, yénd áuwéghafé wém fe sáfrére sénonjo táf yéndon norayan awamarogh si méinyotio Ju árfene wánangoghmén, ");
INSERT INTO nmx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ménamén fém mer mat ném ndernáye Ju ár emor a yéfene fénatayam. Féyo fém náyáreta tafaf métare! ");
INSERT INTO nmx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Méinyotio Ju ár mat em tanemén kétándmayo yénd tosé. Fá mat em némé sáfot ghérsafé yénd kwémorangérwén tanjo yuwon a ndenáyo Jerusalemén. ");
INSERT INTO nmx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Fá mat té tamorwén tanemén tekefifi. Fá so nafrotat ndené yénd kwémorwén Farasi ár. Yéndo mbarkánde ewaitotan Ngánjánene nák ndenanit méinyotio Farasi árém kés ewafrotat. ");
INSERT INTO nmx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Tane méghmégh siyém ménáyan némé Ngánjánam té nénorayai téfene ákiafefaf, yéné téfnan yénd ufoghan wém sénonjo. ");
INSERT INTO nmx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ngánjánam unyéghofnar si norayam ndimbal yammén kétán téfene 12 Israil ár mérénfaf. Yéndfem méinyotio yánjetam ménát so tanangém némé Ngánjánam unyéghofnar si néngorayai téfefaf. Yéné téfnan yéndfem Ju árém túmén yáwefnotam Ngánjáne sémbár a efogh. Ndené yéné Ju ár sem yéna, yéndo efalo yiyátotan Ngánjánene unyéghofnar si. Wénde yéné yém téfén ndené fá nawatarnat tafaf. ");
INSERT INTO nmx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ngánjánam so taméindangé kér ár sái kanongi ghérsat wéikor. Fémofem so efalo wiyátotati yénd njam norayan yéné si. ");
INSERT INTO nmx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Yénd yéndio ménde kwémorwén sái kásáfotawén tékarotawén Yesu Najaretmén. ");
INSERT INTO nmx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yéné fiyém yéndon némé tafrotawén Jerusalemén. Limánégh ghéngén wárogh árfene si muyayan, yéndon efalo yátogh ár tárfár takmetawén kwéfkwéf méngot. Njam téfene limánégh árém korayangayénd, 'Yéné efalo yátogh ár táf kér em,' Yéndon yéfene mwighé ámbiro tiyátongayén. ");
INSERT INTO nmx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Tárfár mbinotma yénd kwiyotau Ju árfene áumengégh méngomé ménát yéfe tékrátan kémghét. Yéndon tawáfáretawén fá yaufi siot Ngánjánefaf. Yéndon tawakeindawén nékw kwémorwén yéfefaf a tawifnawén dábi árfene tesenamé. ");
INSERT INTO nmx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Ámb efghon yénd álighan kwémorwén Damaskosét limánégh ghéngén wárogh árfene si muyafé a wáfáretayénd. ");
INSERT INTO nmx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Warsagh ár Agrifa, séite karéfta, njam yénd kwéngmorwén endmé, yéndo yinjoyén kwayaghé njafarta, yau ndené efogh kwayaghé, wénde yéné yáindai, a warendai yénd a yéndfé áligh ár. ");
INSERT INTO nmx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yénd méinyotio nuyáyém mbandot, a yénd náyárayén kém korayau Ibru sie, 'Sol, Sol, némamén fémo yénd wesmete? Fémo njam kafkaf tautar wím minan, fémon ndémke so yéfande.' ");
INSERT INTO nmx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Féyo yéndon yémotayén, 'Efe fém ném, Yuré?' “Yuram wawangoi, 'Yénd wém Yesu, efe fémon yésmete. ");
INSERT INTO nmx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kano a kokai fenjo kafkafe. Yénd té nufarén fefaf fém némuyafon tane ásáfoghét a fandagh ár. Fémon so ewaufrote tanemén némé fémon téfande a so mé yéngfande. ");
INSERT INTO nmx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Yéndon so kémanjarén kétamé Ju ár a Téndo ár. Yéndon némáfáretan téndo árfefaf ");
INSERT INTO nmx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ménát yéfene ghékéf sauréghét a so ewangote kwéfkwéfta kwayaghat, kétamé Sáiféroene waftata kétán Ngánjánefaf. Féyo yémofem so tanangi yaufiyam wighét yaufita a sifayé tawaramangi Ngánjánene árfefaf emofem yénd efalo wiyátotat.' ");
INSERT INTO nmx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Féyo warsagh ár Agrifa, yénd áyárégh kwémorwén ghékéf waingégh yaman njafarmén. ");
INSERT INTO nmx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Fronde ewaufrotan kétán efe tamorwén Damaskosén, ndenáyo yéfefaf Jerusalemét a méinyotio Judiat a méinyotio Téndo árfefaf. Yéndon táitotawén ménát fá so nawengotat yaufita Ngánjánefaf a so yufarotat yéfenjo awengogh yam wafroghe ");
INSERT INTO nmx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yéné téfnan ámb Ju árém wérayénd wáwefnogh méngo sifayan a kwérametawét ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Wénde Ngánjánam kwáutáne ta méinyotio efogh kétánotio sénonjo. Féyo yénd wakai yéna a nafrotan efalo si yétkwénofnar ár a yétkwénafé árfefaf. Yéndo yéné norayan némé Ngánjánene mat yátogh ár a Moses korayau so nufrotat: ");
INSERT INTO nmx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kerisom so tékrát yáyárete, a fronde so yém anoghét kétamé kérta, so yénérse si kwayaghé yánjo árfefaf a Téndo árfefaf.” ");
INSERT INTO nmx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Njam Folém mé korayau, Festusém nutnai, “Fol, fém onon ném! Fenjo ndimbal otamegham néméinde ononot!” ");
INSERT INTO nmx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Folém yawangoi, “Minde utmanéghafé Festus. Yénd yau onon wém. Yénd némé norayan siyém efalo a fifiyafé. ");
INSERT INTO nmx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Warsagh ár mat yéné yammén yém. Yénd so norayan férférofnaye fefaf. Yénd mat wém ndené warsagh ár mat yém némé yénd norayan, ménamén yéné yam yau nufrotam átnoghe kwéndkwéndan. ");
INSERT INTO nmx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Warsagh ár Agrifa, fémon efalo té eyátote Ngánjánene mat yátogh ár? Yénd mat fémo fété.” ");
INSERT INTO nmx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Féyo Agrifa norayai Folefaf, “Fém ndené nemne yéné tekofnare fémon so kwiyáto wékeye yénd ndené fété efalo yátogh ár?” ");
INSERT INTO nmx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Folém yawangoi, “Ténjfi o tombé kéráye, tane orayégh Ngánjánefaf feyot a méinyotio emofem wiyáretat yénd sénonjo so kénamndangi efalo yátogh ár ndené yénd swém, wénde yénd yau ménde wém fém sái kamndangi kwéfkwéf méngo ár ndené yénd.” ");
INSERT INTO nmx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Warsagh ár, gafana, Bernis a méinyotio efe tamorangérwén yémafé fá nokayoyénd. ");
INSERT INTO nmx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Soramé yémofem yéfrangoyénd a fá nufngoyénd si yéfe kénjúnro, “Yéné árom némé yau tafrote némndafi árkémamén krot so tékmangi o kwéfkwéf méngot tényawangi.” ");
INSERT INTO nmx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrifa norayai Festusefaf, “Njam yéné ár yau té norayai Kaisarefaf ménát sái káyáretau yane si, féyo yéndfem so téngwurtongém.” ");
INSERT INTO nmx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Njam mwighé nufaryéng nde yénd so kuwanongayém ndimbal boute kétán Italia, yémofem eramayénd Fol a ámb kwéfkwéf méngo ár yáfaf Rom fiyaré sénko ár Juliés. Fá tafnyangérwén tukén warsagh ároene fiyaré mérnan. ");
INSERT INTO nmx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Yénd nuwanoyém ndimbal boutfaf árkéméné yénmormén kétamé Adramitum. Yéné bout témorwén kafrendau. Yéné so kuwanongai yénamé tesenamé arakaf téndomé Esia ndimbal yuwon. Yénd nuflayém yéné boutan. Ár yétkwén Aristakus efe témorwén Tesalonika tesenmén Makedonia yuwon nuwanoyém yémafé. ");
INSERT INTO nmx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ámb kwéfon nufaryém Sidonét. Juliésém mere Fol yumyoi fandaghét yá fútarfefaf ménát yémofem so taramangayénd yáne méndefé rokar. ");
INSERT INTO nmx_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Njam yéndfem yéfrangoyém Sidon tesen, ménamén ndimbal mbormboram wangogh yénmafngoi, féyo yénd kérsawém Saifrés fér téndomé árkamé mbormbor yau téfnjawéng muyafé. ");
INSERT INTO nmx_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Yéné soramé néférmayém marat arakaffaf kaka kétán arakaf téndot Silisia a Famfilia yuwon, nénufaryém kétán Mirat tesen Lisia yuwon. ");
INSERT INTO nmx_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mira tesenan, fiyaré sénko árom yinjoi Aleksandria árfene ndimbal bout árké kafrendawét álighét Italiat, féyo yémo yénmaflai boutan. ");
INSERT INTO nmx_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Yénd áfráe kérsawém tárfár efogh, a táikér mé téfandawém ufarghét Sénidus yuwot. Yau mbormboram ténmumyotau yénd álighét yéné sifayamé, féyo yénd téndomé nuwanoyém kétán náikái tambén Krit fér, yéngwaindayém Salmone ghém. ");
INSERT INTO nmx_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Yénd áfráe kérsawém arakaf téndomé a nufaryém yéné sifayé yétkwén Wanjarégh Sur, yau nayu témorwén kétándmé Lasia tesenot. ");
INSERT INTO nmx_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Yénandmé yéndfem té tárfár efogh tanérsam, féyo yéné so yém mámáfi njam mé nérsam boute ménamén Ju árfene ndimbal awafarmanégh efogh soramé arakaf namndai minde mbormborafé. Féyo Folém emndai ár boutan, ");
INSERT INTO nmx_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Fútaréf, káyárangi tafaf yénd njam kuwanongém sénonjo téfene ndimbal bout rokarafé so kértayan yém, a tárfár ghérsé so etarnam.” ");
INSERT INTO nmx_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Wénde fiyaré sénko ár yau náyárai Folefaf némé fá norayai, wénde ewaiteyai ndimbal bout wawerégh ár a ndimbal bout yurane si. ");
INSERT INTO nmx_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ménamén sur yau mer témorwén yunjfan yéfe kémghét, tárfár ár ménde tamorwén awaingéghét kétán sur yétkwén Finiks yunjéf ámnjoghét kété. Finiks sur témorwén sauréghkaf kétán arakafot sómbio ende a muyafé mbormbor yau kor ténéfnjau kété. ");
INSERT INTO nmx_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Njam métar náikái mbormbor waufégh yénmafngoi, yémofem yinjoyénd mer témorwén álighét. Féyo táf yurtoyénd werégh téfén ndimbal boutoene a nuwanoyénd Krit arakaf téndomé. ");
INSERT INTO nmx_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Wénde ndimbal mbormbor yétkwén Yambérmawér Mbormboram eutfoi fá a yénmaufetai kétamé férta. ");
INSERT INTO nmx_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Mbormbor témaufetau minde muyafé ndimbal boutfaf. Féyotarofnar tamorwén wawerégh téfnáram sái taweretawét ndimbal bout mbarkánde kétán mbormborfaf. Féyo yumyoyénd ndimbal bout mbormboram yéngwanai. ");
INSERT INTO nmx_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Yénd yénamé yéngmormén Kauda fér néndkéfamé. Bout wawerégh téfnáram wénmauyoyénd Boutoene ndingi nutambén ménát wanjarghét. ");
INSERT INTO nmx_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Féyo yémofem yarmboyénd ndingi ndimbal bout tukét. Yéné soramé yémofem wumbégh yafngoyénd ángéghe ndimbal bout ménát taikrot. Ménamén fá férfér tamorwén nde mété táf kásmetawét wíman Siritisén, yémofem yeworyénd boutoene wérégh tot téfén yumyoyénd ndimbal bout yéngwanayéng mbormboram. ");
INSERT INTO nmx_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ndimbal mbormbor mindefifi taufetau, féyo ámb efghon ámb rokar taranégh ewafngoyénd ndimbal boutta. ");
INSERT INTO nmx_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Nambiomén efghon yémofem taranégh ewafngoyénd ámb bout ásáfoghmén rokar. ");
INSERT INTO nmx_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tárfár efghon yéndfem yau tafandawém efogh a kénd. Ndimbal mbormbor mé ténmaufetau muyafé a yénd féyo yénmormén a téfene kamnang nefoyénd awanjarghét. ");
INSERT INTO nmx_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Yéné téfnan yéndfem yau njamke tánetawém ndené teke. Fol nokayoi emndai ár: “Fém fai káyáretawét tafaf njam tamorwén kété Krit féran, fémofem yau yéné wasérmbogh so tinjongayénd a té kawaghnat. ");
INSERT INTO nmx_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Wénde sénonjo yéndon ewamnendan fém, yau férfér em ménamén emo ámb yau ghérsé so yétarne, mé ndimbal boutro so nawasérmbote. ");
INSERT INTO nmx_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Yénd wém Ngánjánene, a yéndon yáwefnotan yáyot. Sémbáran yémon ténmáfárete njafar si résagh ár ");
INSERT INTO nmx_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ta waufroi, 'Fol, yau férfér ném! Fém so némakai ufoghan Rom tuk warsagh ároene rére. Ménamén fenemén Ngánjánam so tawanjarngé efe méinyotio em ndimbal boutan.' ");
INSERT INTO nmx_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Féyo férfér yau em! Yénd mat wém ndené Ngánjánam so yafrote mbarkánd némé fá norayai. ");
INSERT INTO nmx_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Wéndende, ndimbal bout so nirone ámb féran.” ");
INSERT INTO nmx_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","14 sémbáran yénd ténmimndau mbormboram yénamé Mediterian arakafamé. Wénde sémbár néndkéf ndimbal bout ásáfogh ár mat náyátoyénd yénd kaka náyátoyém mbandfaf. ");
INSERT INTO nmx_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Yémofem yufotaménd nuoene kénjkam ndené 40 mité. Yéné soramé wéi yufotaménd a yinyoyénd 30 mité kénjkam témorwén. ");
INSERT INTO nmx_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ndimbal bout ásáfogh ár férfér tamorwén ménamén mété táf kásmetawét wíman. Féyo yémofem ewitaménd 4 werégh tot téfén ndimbal boutoene kwémb tambén a fá Ngánjánafé orayégh nufngoyénd efogh kwayaghat. ");
INSERT INTO nmx_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bout ásáfogh ár ménde tamorwén sái téfrangongayénd ndimbal bout. Féyo yémofem yeworyénd ndingi arakafot. Fá yéta kwankwane álighét nufngoyénd. Fá norayayénd, “Yénd yéngém kétán ndimbal bout sénkofaf ménát ndimbal boutoene werégh tot téfén so taweworngém arakafot.” Wénde kuindawét. ");
INSERT INTO nmx_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Wénde Folém emndai fiyaré sénko ár a fiyaré, “Ndimbal bout ásáfogh ár yau njam emor ndimbal boutan, féfene kamnang ámb yau yém ménát awanjarghét.” ");
INSERT INTO nmx_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Féyo fiyaram yénfayénd ángégh árké teretawét ndingi a nuyai arakafot. ");
INSERT INTO nmx_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Fauréghétro témorwén Folém ewamnendai njamke nénet, a emndai, “14 efogh fém té tam mámé mwighé a ámb njamke yau tánetati. ");
INSERT INTO nmx_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Yéndon ewamnendan fém, féyo, njamke tánetangi, ghérsé sái mé em. Yéné yafrotati a fém so mer em.” ");
INSERT INTO nmx_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Si soramé, Folém yanayéng ámb féskaf flawé karéf a kánjo si yaramayéng Ngánjáne. Féyo méinyotio árfene sáfrére, yémo yétfoi féskaf flawé a ténetau. ");
INSERT INTO nmx_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Fá méinyotio náuwétaménd a ámb njamke enetaménd. ");
INSERT INTO nmx_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Kété tamorwén méinyotio 276 ár ndimbal boutan. ");
INSERT INTO nmx_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Njam yémofem enetaménd a eremngoi, yémofem tawitawét flawé baik kétán arakafot ndimbal bout ofat. ");
INSERT INTO nmx_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ámb akwan, yémofem yau yáyámngoyénd mband, wénde yémofem yinjoyénd trewar ménáyafé miri mbandafé. Féyo yémofem mwighé yinjoyénd ménát wérset miriamé. ");
INSERT INTO nmx_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yémofem enfayénd werégh téfén ángégh féyo engéfrangoyénd arakafan. Táfandio yémofem eferyénd ángégh árkéménayam teretawét ndimbal bout waknyéghmén. Yénamayo yémofem yakayoyénd sáimai ndimbal bout sénko tambén a mbormboram ndimbal bout résagh yafngoi kétán mirifaf. ");
INSERT INTO nmx_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Wénde ndimbal bout miri mbandot náyátoi. Féyo ndimbal bout sénko nékmboi kété yau kimndau, a ndimbal sófam yésmai ndimbal bout kwémbta méinyotio yiroryéng. ");
INSERT INTO nmx_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Fiyaré méndefnar tamorwén efe yau so kakmetawét tunat a kéngongayénd, féyo yémofem mwighé téfrendawét kwéfkwéf méngo árfe ngiot. ");
INSERT INTO nmx_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Wéndende, fiyaré sénko ár ménde témorwén Fole wanjarghét a yémo yau taumyotau yéné yam wafroghét. Wéndende, “Méinyotio ár efe mat em akmégh, katnangi arakafot, a kakmetangi tunat. ");
INSERT INTO nmx_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ámb árém táf ewaitotat. Nawéretat wén karfan o ndimbal bout karéfkaréfan.” Féyo fá nufaryénd merro kétán tunat. ");
INSERT INTO nmx_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Njam yénd merro nufaryém, yéndfem yáyamngoyém fér yétkwén Malta. ");
INSERT INTO nmx_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Fér ár efe tákmangérwén yémofem yénmumyoyénd mere a fútar náyátoyém. Yémofem fés yétayaménd a yénmumyoyénd yénd méinyotio ménamén nu kafamndau a kurférmén. ");
INSERT INTO nmx_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Folém ámb fés sut enwanai a efayoi fését. Fés waftayam yéméindai kamban étorghét a yararyéng yáne ngángé. ");
INSERT INTO nmx_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Njam fér árém yinjoyénd kamban térnyangérwén yáne ngángayan, fá korayangi yéfe kénjúnro, “Yéné ár mété yém ár ngi téfnár! Fá yau kolitote arakafan, wénde ngánjánam yau yumyo ghérsat.” ");
INSERT INTO nmx_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Wénde Folém yéfnendai kamban fését yéneghoi a ámb némé kérté yau yanai. ");
INSERT INTO nmx_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ár kemnawét yáfaf ndené mbwe kar so tarenau o sune kér témorwén. Wénde teke awanjengégh soramé yau némndafi nufrotam yáfaf, yéfefaf mwighé nufaryénd a norayayénd, “Fá siyém ngánján.” ");
INSERT INTO nmx_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Gafana témorwén Fablis yéné féran, yáne ámb mband kété témorwén. Fablis témorwén ngárám ár téfefaf a yénmumyoi yánjo méngot nambio efogh ámnjoghét. ");
INSERT INTO nmx_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Yárefé enjne tékmangérwén yameyan fifi waftamén a oghanemén. Fol nénglawai kénjút Ngánjánafé orayéghét a ngángé yéfayoi yáfaf a mer yiyátoi. ");
INSERT INTO nmx_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Njam yéné yam nufrotam, yéné férta enjne téfnár tanmorwén a mer táyátotau. ");
INSERT INTO nmx_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Yémofem ténmutémndawét yénd tárfár ende, a yénd njam álighétro ténmorwén, yémofem ténmarametawét téfene méndefé rokar. ");
INSERT INTO nmx_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nambio ghérare soramé mbormboram yiroyéng ndimbal bout. Ndimbal bout yéméghangérmén Maltan mbormbormén yunjfan. Yéné témorwén Aleksandriamén ndimbal bout a kété tárwén sómbio wafroghmén ngánján ndimbal bout sénkoyan. Yénd néngufaryém ndimbal boute. ");
INSERT INTO nmx_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Yénd ngérsawém arakafamé nungufaryém Sirakus tesen a yénmorangérmén kété nambio efogh. ");
INSERT INTO nmx_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kétándmé yénd nufaryém Regium tesen. Ámb efghon náikái mbormbor waufégh yafngoi, sómbio efogh soramé yénd nufaryém Fotioli tesen. ");
INSERT INTO nmx_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kété yéndfem ewinjoyém Yesuene waitogh ár, emofem yénmumyoyénd yémafé ámnjoghét 7 efghot. A féyo yénd néngwanoyém Rom. ");
INSERT INTO nmx_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ámb Yesuene waitogh ár Rommén náyárayénd téfenemén a enmormén téfe wanféghét Afius térarégh sifayat a méngotu yétkwén Nambio wan téfnár méngot. Njam Folém ewinjoi fá, yémon kánjo yaramai Ngánjáne a frengégh yanai. ");
INSERT INTO nmx_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Yénd njam nufaryém Rom, Fol yumyoyénd yambia ámnjoghét fiyaram tambetau. ");
INSERT INTO nmx_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nambio efogh soramé yémo eumendai Ju árfene sénko ár a Fol norayai yéfefaf, “Tane fútaréf, yéndon némé yau tafrotan téfene árfefaf o téfene ákifene túmén yam, wénde yénd werayénd Jerusalemén a wéramayénd Rom árfene ngángat. ");
INSERT INTO nmx_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Yémofem kwémotawét yénd a ménde tamorwén ta utorghét, ménamén yaufi yau yinjoyénd tafaf árkémamén kér so kwémorwén. ");
INSERT INTO nmx_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ju sénko ár korayawét tafaf, féyo yéné yamam kwéméindangé yénd sái korayangén Kaisar náyáreta tane si, ndemamén tane ámb yau témorwén wánangogh tane árfefaf. ");
INSERT INTO nmx_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Féyo yéndo té kénmarawetan fém yénan álighét ménát yéndo so némaufrotan némamén yénd wém kwéfkwéf méngon. Yéné ménamén yém yéndo efalo yiyátotan Keriso, efe yém Israil árfene kamnang té yénmormén.” ");
INSERT INTO nmx_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Yémofem yawangoyénd, “Yéndfem ámb yau némé férén ewinjoyém Judiamén fenemén. Ámb yau téfene ár efe enmormén kétándmé nafroyénd o norayayénd yaufi si fenemén. ");
INSERT INTO nmx_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Wénde yénd ménde yéném áyárghét fene si némé em, ménamén yénd mat yéném árém norayat yaufi si marataye yéné totér mérénmén.” ");
INSERT INTO nmx_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Yémofem yufoyénd ámb efogh Fole álighét. Njam yéné efogh nawerai, tárfár ár enmormén mérne yéné sifayat ánde fá tékmangérwén. Yémo táitotau yéfefaf akw kétán férégh, tawawafenau Ngánján limánéghmén, a kétamé Mosesene nák a kétamé Ngánjánene mat yátogh árfenemén. Yémo tamndetau ménát yaufiyamta awengoghét a ménát awengoghét Yesuefaf. ");
INSERT INTO nmx_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ámb árém efalo tiyátotawét némé fá korayau, wénde ámb árém yau efalo tiyátotawét. ");
INSERT INTO nmx_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Fá kéwitawét yénémamén yéfenjo kénjún. Njam yémofem frangoghét yafngoyénd, Fol norayai, “Ngánján Mbérmbéram norayai efalo si Ngánjánene mat yátogh ár Aisaya kénjúmé féfene ákifefaf: ");
INSERT INTO nmx_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“'Kuwano yéné árfefaf a koraya, “Fém so náyáretati wénde mat yau so náyátotati. Fémofem so yéfandati wénde yau so tayamngongi. ");
INSERT INTO nmx_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ménamén yéné árfene tikéf té nénamndai táikér, yémofem táikér yéfandat áyárghét, a yémofem yéfenjo ghékéf té eumbértongi. Féyo mété táf yau néretat yéfenjo ghékfe, a yau náyáretat yéfenjo téngane, a efalo yau yiyátotat yéfenjo tikfe a kawengongi ménát yéndon so mer táyáton fá.”'” ");
INSERT INTO nmx_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Yénémaménnde yénd Fol ménde wém fém mat so em Ngánjánene wanjarégh té yéngramai kétán Téndo árfefaf, a fá so náyáretat! ");
INSERT INTO nmx_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Sómbio yunjéf Fol yémorangérmén kété yáne mani faimén méngon a taumyotau fá efe tanmormén yá fandaghét. ");
INSERT INTO nmx_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yémo tawaufrotau Ngánján limánéghmén a tawatametau Yuré Yesu Kerisoenemén férférofnar a emo yau tékmbongai. ");
ALTER TABLE nmx_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
