﻿USE sofia;
DROP TABLE IF EXISTS sofia.oydl_vpl;
CREATE TABLE oydl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES oydl_vpl WRITE;
INSERT INTO oydl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yinnippa kaallii xaafinttide Dawute na7a Abrahama na7a maaqqide Yesuus Kiristtoosa yelintto. ");
INSERT INTO oydl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahama Yisaaqa yelida; Yisaaqa Yayqooba yelida; Yayqooba Yihudan E ishuntsana yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yihuda Ti7imarippa Faaresenen Zaaran yelida; Faaresa Asroome yelida; Asroome Raame yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raame Aminaadabe yelida; Aminaadabe Na7asoona yelida; Na7asoona Salmoone yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoone Re7aabippa Boo7eza yelida; Boo7eza Uruutippa Iyobeede yelida; Iyobeede Issey yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isseyen kaati Dawute yelida; Dawute Ooriyo machchitippa Solomone yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomone Robi7aama yelida; Robi7aama Abiya yelida; Abiye Asaafa yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaappa Iyosaafixe yelida; Iyosaafixe Iyoraame yelida; Iyoraame Ooziyane yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ooziyane Iyo7ataama yelida; Iyo7ataama Akkaza yelida; Akkaza Hiziqiyasa yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiziqiyasa Minaase yelida; Minaase Amoona yelida; Amoona Iyosiyaasa yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Isra7eele asuntsi di7intti Baabiloone gaaze sa7a hyanggide wode Iyosiyaasa Ikoniyaanan E ishuntsana yelida. ");
INSERT INTO oydl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baabiloone sa7a Isra7eele asuntsi di7inttii hyanggideppa maaqqii Ikoniyaana Salatiyaale yelida. Salatiyaale Zerubaabela yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaabela Abdiyu yelida; Abdiyu Eliyaaqeme yelida; Eliyaaqeme Azaara yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azaara Sadooqe yelida; Sadooqe Akime yelida; Akime Eliyuuda yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuuda Alaazare yelida; Alaazare Maatane yelida; Maatane Yayqooba yelida; ");
INSERT INTO oydl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yayqooba Yoosefa yelida; Yoosefa Kiristtoosa gaaze Yesuusa yelide Mayrami azini. ");
INSERT INTO oydl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yikke, yelintta Abrahameppa Dawute yellodes taphpho oyddii. Dawuteppa hyanggi Baabiloone di7e yellodes taphpho oyddii. Baabiloone di7eppa hyanggi Kiristtoosa yellodes taphpho oyddii yelintte maaqqane. ");
INSERT INTO oydl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesuus Kiristtoosa yelintta taarike hyannippa kaallizanno. E intta Mayrama Yoosefas oocintti yezite Yoosefa ekkikaayzin Geeshi Ayyaanappa wodaxida. ");
INSERT INTO oydl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoosefa xillo as maaqqide gisho izo as gidda kessodes koykaaya. Yinnii gisho aachchii izo ashshodes qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E yinna qofite yezin Xoozze kiitanchcho abukkora qonccii, «Dawute na7ay, Yoosefa, ne oocide Mayrama wodaxide Geeshi Ayyaanappa maaqqide gisho izo ekkodes zhashtippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iza dhiiratsi na7a yeloda, E fa worzhito un nagarttippa ashshize gisho E suntsito ne Yesuusa ga7i xeegoda. ");
INSERT INTO oydl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Laatstse nabe Isayaasa doona. ");
INSERT INTO oydl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Yikke wudurtta wodaxoda; dhiiratsi na7an yeloda; E suntsita Ammanu7eela ga7inttoda» ga7inttidanna folinttode fana hyanna ubbanna hyanida. Ammanu7eela gaazannis bilitsita «Xoozii nuura yene» ga7e. ");
INSERT INTO oydl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoosefa genttoppa barkki Laatstse kiitanchchuntsi kiittidanni fana Mayramo fa kara kanggida. ");
INSERT INTO oydl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yezin fa anggis na7aya yelode wontsis izo girmmikaaya; Yelinttide na7aya Yesuusa ga7i xeegida. ");
INSERT INTO oydl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kaat Heroodosa wode Yesuusa Yihuda sa7a Beetaleme katama yelinttidannippa suuba xoolintto bi7i asuntsi awa kessappa Yerusalaame yi7i, ");
INSERT INTO oydl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«Yelinttide Ayhude kaatize aba yene? Nuunii awa kessi zalara kezii E xoolinttiza bi7i eesi goynodes yi7ida» Yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kaati Heroodosa yinno si7ide wode tannida. Yerusalaame yeze asuntsi ubbanna tannida. ");
INSERT INTO oydl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heroodosa kahinunts hyalaquntsanan higge asttamaaruntsana faago xeegii, «Kiristtoosa aba yelinttessa?» yaga7i unttana oocida. ");
INSERT INTO oydl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Unttin, Yihuda Beeteleme; nabize, ");
INSERT INTO oydl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","« ‹Yihuda yeze Beetaleme, Yihuda yeze damma Katamuntsappa, neenii akkon eroos. Ta worzhito Isra7eele ahoday, neeppa kezoda› ga7i xaafida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yinnippa suuba, Heroodosa awa kessappa yi7ide asuntsana aachchii xeegii, xoolinttiza un bi7ide wode unttappa loytsii erida. ");
INSERT INTO oydl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","E unttana Beetaleme dakkitera, «Hyanggi yelinttide na7aya mintsii koyote; eza yin denggide wode taanin hyanggi eesi goynode gaar maaqqii yi7itera taas ohote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Unttin Kaat Heroodosa gaydanno si7i hyanggida. Un awa kessi zalara hyanggi xoolinttize unttana kaalitsitera na7ay yeze besito yellodes kanggida. ");
INSERT INTO oydl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Un ye xoolinttiza bi7ide wode damma ufays ufayttida. ");
INSERT INTO oydl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Keetstsa gelii na7ay fa inttii Mayramira yezaya bi7ida. Eesi bunqqunttii goynida. Fa saaxintto bugii worqqan, ixaanen karbbe eesi shiishida. ");
INSERT INTO oydl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Un Heroodosago suub maaqqaame fana Xoozii abukkora unttis ohin, melle ogera fa gade maaqqida. ");
INSERT INTO oydl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Awa kessi zalara yi7ide asuntsi qitidannippa suuba, Laatstse kiitanchchize Yoosefas abukkora qonccii, «Heroodosa na7aya wodhodes koyze gisho denddii; ellisii na7ayan na7ay intton ekkii Gibxxe gade qito. Ne maaqqade wode ta nees ohode wontsis yeyga gam77o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yinnii gisho, Yoosefa yinna qammite denddii, na7ayan na7a intto ekkii Gibxxe qitida. ");
INSERT INTO oydl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nabe doontte Xoozii, «Taanii, ta na7aya, Gibxxe gadeppa xeegida»ga7inttide qaaltta folinttode gaar Heroodosa hyayqqode wontsis E yeyga yezida. ");
INSERT INTO oydl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yinnippa suuba, awa Kessi zalara yi7ide asuntsi eza cimmidanno eride wode gaama zhilidhdhida. E tiino unttappa si7idanni fana Beetelemen yinna gutute yeze lam77i bere kumiduntsanan lam77i bereppa yeekkara yeze dhiiratsi na7untsana ubba fa wottaddaruntsana dakkii wodhizida. ");
INSERT INTO oydl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nabe Ermmiyasa doontte, «Yeefon yeefo dentse, Raama katama sinttida. Raahela fa na7untsis yeekkane; un hyayqqide gisho minggodes dandda7ikaaya» ga7i ohinttidanna folinttida. ");
INSERT INTO oydl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroodosa hyayqqidanippa suuba Gibxxe Laatstse kiitanchcho Yoosefas abukkora qonccii, ");
INSERT INTO oydl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Na7aya wodhodes koyze asuntsi hyayqqide gisho denddii na7ayan na7ay intto ekkii Isra7eele gade maaqqo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yoosefa denddii na7ayan na7ay intto ekkii Isra7eele gade maaqqida. ");
INSERT INTO oydl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Yezin Arkkeliyoosa Yihuda fa ade Heroodisa besite ka7itidanno si7ide wode yeyga hyanggodes zhashtida. Xoozii abukkora eesi qonccizin Galila gade qitida. ");
INSERT INTO oydl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nabunts doontte, «Naazirete asi ga7inttoda» yaga7i ohinttidanna folinttode fana Naazirete katama hyanggi yeyga yezida. ");
INSERT INTO oydl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Ye wode Xammaqize Wahannisa, «Xoozze ka7itumo ukkide gisho yin nagarappa maaqqote» yaga7i sabbakitera Yihuda akko baayze ganasa qitida. ");
INSERT INTO oydl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nabe Isayaasa Wahannisa baz ohidanni fana, «Akko baayze ganasa, fetay fa qaaltto dhoqi yiizi, ‹Laatstse ogito giigizote. E worogito luulizote› gayda» yaga7inttidanna eesi yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Wahannisa gimale isintseppa oochinttide afula ma77ane. Fa qazintten dafe saqqe danccane. E mu7ize katsitan boolen dekera shida. ");
INSERT INTO oydl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Asuntsi ye wode Yerusalaame katamappa, Yihuda sa7a ubbappa Yorddaanosa borkka kaleppa eego ye7ine. ");
INSERT INTO oydl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Fa nagartto buuxi Yorddaanosa borkka Wahannisa kushe xammaqinttida. ");
INSERT INTO oydl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wahannisa, gaama Farisaawuntsin saduqaawuntsi xammaqinttodes faago yi7izuntsana bi7i, unttago, «Hyantsi iita shooshuntso, yo7ode Xoozze kachchappa attode fana yinttana oode zoride? ");
INSERT INTO oydl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yikke, Yin, yin nagarttippa maaqqidanno beezze oocha oochchote. ");
INSERT INTO oydl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yin, yin wozintte, ‹Abrahama, nu aday yene› yaga7i qoppipete. Loytsii si7ote! Xoozii hyanna shuchchitippa Abrahamas na7a kessodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gandde minxiti xaphite giigii yene; lo77o aafe aafoosse minxa ubba gachchii tama olinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Yin, yin nagarttippa maaqqidanno ersodes ta yinttana hyaatsa xammaqane. Yezin taappa suubara ye7ize yinttana Geeshi ayyaanaran tamara xammaqoda. E taappa gaama wolqqara yene; ta melle atto yezin E caammito tukkodesin beezoos. ");
INSERT INTO oydl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Katstsa geeshize fitsita E kushite yene. Katsito loytsii geeshane; zargito fa fachite gussoda, yezin fugito dhaboosse tama michchoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ye wode Yesuusa Wahannisa kushe xammaqinttodes Galilappa Yorddaanosa borkka hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yezin Wahannisa eza kayodes koyi «Taanii neera xammaqinttodes beezzin ne taago ye7ine?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yezin Yesuusa mahi, «Xoozii nuuppa koyze baz ubba nu folodes beezze gisho hyatte taas ero ga7o» yagayda. Wahannisa ees yee7e yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesuusa xammaqinttide fana hyaatsitippa kezida. Iira salo bugunttin Xoozze Ayyaana wolle fana ye7oderan mahi faalla afa wodhdhodera bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ye wode «Hyaychche ta kadhize, E tana ufaysize ta na7ay hyaya» yagaaze qaala saloppa yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yinnippa suuba, Xalahe Yesuusa fattanode gaar Geeshi Ayyaana Yesuusa akko baayze ganasa kanggida. ");
INSERT INTO oydl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oyttam qamman oyttam awara xoomidannippa suuba naydhdhida. ");
INSERT INTO oydl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xalahe Yesuusago yi7i «Ne Xooz na7a maaqqiko, ane hyay shuchchiza soollo maaqqade fana kiitto» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesuusa mahi, « ‹Asi Xoozze doonappa kezze qaala ubbanne yessadep attin soollo xalaalara yezoos› ga7intti Xoozze qaaltte xaafinttida»yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mahin, Xalahe Yesuusa geeshi katama kanggi, Xoozze keetsitis ommite kessii, ");
INSERT INTO oydl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«Ne Xooz na7a maaqqiko, ane sulle sa7a gol7o. Akkos gayko, « ‹Ne tohita shuchchalla dhubunttaame fana, fa kushtira nena dentsode fana, Xoozii fa kiitanchchuntsana ne gisho kiittoda› ga7intti Xoozze qaaltte xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuusa eego, «mahi, ‹Xoozze qaaltte ne Laatstsa, ne Xoozza fatanippe› yaga7i xaafinttida» ga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wurssutsite Xalahe Yesuusa fettii damma dere omma kessii alame ka7itumo un bonchchtira fettilla beezii, ");
INSERT INTO oydl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«Ne taas gol7i goyniko ta nees hyanno ubba inggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesuusa mahi, «Hyay Xalahizayo, taappa hyaakko! ‹Ne Laatstsa, ne Xoozza goyno, E xalaalas kiitintto› gayntti Xoozze qaaltte xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yinnippa suuba, Xalahe ashshii qitida; kiitanchchuntsi yi7i eza maaddida. ");
INSERT INTO oydl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesuusa, Wahannisa acinttidanno si7ide wode Galila gade qitida. ");
INSERT INTO oydl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naazirete katama ashshii Zaabiloonen Niftaaleme guta, abba kale yeze Qifirnahoome katama hyanggi yeyga yezida. ");
INSERT INTO oydl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yinna hyanidanna nabe Isayaasa doontte, ");
INSERT INTO oydl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Zaabiloone gaden, Niftaaleme gade, Yorddaanosa borkkappa seko fintsa abba oge, Ayhude maaqqoosse worzhuntsis yeze Galila, ");
INSERT INTO oydl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","dhuma yeze worzha, damma foo7o bi7ida. Hyayqo dasho gade, yezuntsis foo7o kezida» yaga7i ohinttide qaaltta folinttode fana. ");
INSERT INTO oydl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ye wodeppa dentsii Yesuusa, «Xooz ka7itumo ukkide gisho yin nagarttippa maaqqote» yaga7i qaala sabbakida. ");
INSERT INTO oydl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuusa Galila Abba kalera aadhitera lam77i ishuntsana, Phexiroosa ga7inttize Simoonan E isha Inddirase bi7ida. Un molo aykkizuntsana maaqqide gisho fa gitito abballa olida. ");
INSERT INTO oydl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuusa unttana, «Hyankka yo7ote; tana kaallote! Molo aykkizanno ashshii, ta yinttana as ayfo tamaarssoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Un, ellisii fa gitito olii ashshii Yesuusa kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuusa yeygappa hyaga gode tiino aadhitera melle lam77i ishuntsana, Zabdiyoosa na7untsana, Yayqooban Wahannisan bi7ida. Fa aday Zabdiyoosara wolla gongge gidda fa gitito loytsizuntsana xeegida. ");
INSERT INTO oydl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Un, ellisii fa gonggiton fa adayan ashshii Yesuusa kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuusa Ayhude woosa keetstsa tamaarssitera, salo ka7itumo Wonggele ohitera dumma dumma hyarggeppa asuntsana fatstsitera Galila sa7a ubbanne wutida. ");
INSERT INTO oydl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yinnippa denddii E suntsita Sooriya gade ubba erinttida. Dumma dumma hyarggera aykinttiduntsanan waayinttizuntsana, tuna ayyaanara aykinttiduntsana, biicora yezuntsana, wobbuntsana eego ki7ida; ezin unttana fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Asuntsi Galilappa, taphphi katamuntsappa, Yerusalaameppa, Yihudappan Yorddaanosa borkka seko fintsa yeze gadeppa yi7ide gaama asuntsi eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gaama worzha shiiqidanno Yesuusa bi7i derella afa kezii bettida. E tamaaruntsi eego shiiqin, ");
INSERT INTO oydl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hyannii gaar yaga7i tamaarssida: ");
INSERT INTO oydl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Fa ayyaantte daha maaqqiduntsi anjjinttiduntsana, salo ka7itumo unttis. ");
INSERT INTO oydl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yeekizuntsi anjjinttiduntsana, un mintsitse denggoda. ");
INSERT INTO oydl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wozina aaduntsi anjjinttiduntsana, un sa7a laattoda. ");
INSERT INTO oydl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xillotitsi oochchodes naydhdhizuntsin bardhdhizuntsi anjjinttiduntsana, un mishshada. ");
INSERT INTO oydl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maarizuntsi anjjinttiduntsana, un maarotitsi denggoda. ");
INSERT INTO oydl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wozina geeshshuntsi anjjinttiduntsana, un Xoozii be7ada. ");
INSERT INTO oydl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Giigizuntsi anjjinttiduntsana, un Xooz na7a ga7intti xeeginttoda. ");
INSERT INTO oydl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xillotitsi oochchize gisho ga7i, bay7inttizuntsi anjjinttiduntsana, salo ka7itumo unttis. ");
INSERT INTO oydl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Asuntsi yinttana ta gisho ga7i cazhize wode bay7ize woden yinttalla afa iita baz ubba worddora ohize wode yin anjjinttiduntsana. ");
INSERT INTO oydl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yin anjjita salo damma maaqqide gisho ufayttote, loytsii ufayttote. Yinttappa tiino yezide nabuntsana yinnii gaar bay7ida. ");
INSERT INTO oydl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Yin sa7as sooge; sooge fa mal77itumtto ashshiko, wayzi mahi denggode? Bale dhogiko asara yedhinttanep attin akkosin maaddoos. ");
INSERT INTO oydl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Yin sa7as foo7o; derella afa yeze katamita aachinttodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xomppe aytsii keetstsa yeze asuntsi ubbuntsis foo7ode gaar dhoqqa bessa gaddanep attin gabate gidda gaddize baaya. ");
INSERT INTO oydl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yinnii gaar asuntsi yin lo77o oochito bi7i, salo yeze yin adaya bonchchode gaar yin foo7ita as tiino foo7o. ");
INSERT INTO oydl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Taanii Muse higgiton nabunts qaala shaarodes yi7ida yinttis aazippe. Taanii, un ohidanna turo maaqqidanno qonccissades yi7idap attin shaarodes yi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta yinttis turo ohine; salon sa7a aadhode wontsis higge ubba folinttodep attin higgitifa fettii qaala woy fidaale aadhoos. ");
INSERT INTO oydl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yinnii gisho, hyanna kiititippa eerize fettii kiitan mentsize ooden mahi melluntsana yinnii gaar oochchode gaar tamaarssize ooden salo ka7itumo ubbuntsappa eeratsi maaqqada. Yezin hyanna kiitto folizen melluntsanan folode gaar tamaarssize salo ka7itumo damma maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta yinttis ohine; yin xillotitsita Farisaawunts xillotitsappan higge asttamaarunts xillotitsappa aadhanxiko, salo ka7itumo geloos. ");
INSERT INTO oydl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Yin mayzuntsis, ‹Wodhippete; shemppo wodhide ooden firdinttoda› ga7inttidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yezin ta yinttis ohine; fa ishaya cazhize ooden firdinttoda. Fa ishaya cazhize ooden daynna tiino firddas shiiqoda. Fa ishego, ‹Eeyay› gaaze ooden mahi gaanname tamite firdinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Yinnii gisho, ne ne zharsho zharshize wode ne ishaya qohide baz nees tiirnttiko, ");
INSERT INTO oydl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ne zharshito iza besite ashshii ashshii qito; tiino hyanggi ne ishayra giigo; yeyzi maaqqii, ne zharshito Xoozis zharsho. ");
INSERT INTO oydl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Nena mootizera firdda keetstsa hyanggitera ogella eera giigo. Yinna atto gayko E nena daynna tiino kanggoda. Daynnize nena accizes aatsii inggoda; E nena woyne oloda. ");
INSERT INTO oydl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta turo ohine; neella afa firddinttide acito fettii santtime attikaayzin ciggii hyaasode wontsis achi keetstsappa mulon kezaama. ");
INSERT INTO oydl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Hyannippa zaga, ‹Olale hyanttippete› ga7inttidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yezin ta yinttis ohine, maacho bi7i, amudhdhide ubba fa wozintte iira olalida. ");
INSERT INTO oydl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne mizaqi aafize nees nagaras mikinaate maaqqiko, kessii olo. Ne galtta kumutsita gaanname tama wodhdhodannippa ne gallitippa fetay dhabiko nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne mizaqi kushize nees nagaras mikinaate maaqqiko, eza gachchii olo. Ne galtta kumutsita gaanname tama wodhdhodannippa ne gallitippa fetay dhabiko, nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«‹Fa machchito dakkize ooden dafo warqqate inggo› ga7inttida. ");
INSERT INTO oydl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yezin ta yinttis ohine; fa machchito olalikaayzin billize ooden iza olalode gaar oochchane. Yinnii gaaran, dakinttide machchito ekkize ubba olalida. ");
INSERT INTO oydl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Yin mayzuntsago, ‹Worddo caaqqippete; yin Xoozze tiino caaqqidanno folote› ga7inttidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yezin ta yinttis ohine; mulon caaqqippete. Xoozii bettize oyda maaqqide gisho salora caaqqippete. ");
INSERT INTO oydl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","E tohita yedhdhize bessi maaqqide gisho sa7ara caaqqippete. Damma kaat katama maaqqide gisho Yerusaalaameran caaqippete. ");
INSERT INTO oydl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yin ommitippa fetaya bootsi woy kartsi mahodes dandda7oosse gisho yin yin ommite caaqqippete. ");
INSERT INTO oydl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yinnii gisho, yin qaaltta, ‹Yee› woy ‹Ade› maaqqo. Yinnippa bale kezize xalaheppa ye7ine. ");
INSERT INTO oydl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹Aafe gisho aafe; achchi gisho achchi› ga7inttidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yezin ta yinttis ohine; yinttalla afa iita baz oochchize atstsa ixxippete. Ooden ne mizaqi dhookiza baqqiko ne workkita dhookizan beezo. ");
INSERT INTO oydl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Fettii asi ne shaamiza wolqqara ekkodes nena mootiko, ne kootizan gujjii inggo. ");
INSERT INTO oydl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Fettii asi nena wolqqara fa baz toossii fettii saate oge faara hyanggode gaar nena un7itsiko, eera lam77i saate oge hyanggo. ");
INSERT INTO oydl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Woossize oodesin inggo; neeppa tal77odes koyko oonan kayippe. ");
INSERT INTO oydl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«‹Nena kadhiza kadho; nena ixxizaya ixxo› ga7inttidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yezin ta yinttis ohine; yin morkkuntsana kadhote; yinttana qohizuntsis woossote. ");
INSERT INTO oydl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yinnii gaar yin oochchiko, salo yeze yin adays yin na7untsana maaqqada. E iituntsisin lo77untsis awa kassane; xilluntsisin nagaranchchuntsisin fa ira bukkizane. ");
INSERT INTO oydl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yinttana kadhize asuntsana xalaala yin kadhiko, yinttis akko tirfe yeze? Melle atto yezin, gabe qaraxe gachchizuntsin yinno oochchane. ");
INSERT INTO oydl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yin, yin ishuntsana xalaala saritsiko, melluntsappa akko aadhizebaz oochchidote? Melle atto yezin, Xooz ammanoose asuntsi yinno oochchane. ");
INSERT INTO oydl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yikke, salo yeze yin aday folo maaqqidanni fana yinttin folo maaqqote. ");
INSERT INTO oydl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Asi bo7o ga7i yin lo77o oochito as tiino oochaame fana naaginttote. Yinnii gaar yi7anxiko salo yeze yin adayppa anjjo denggaama. ");
INSERT INTO oydl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«Yin dahuntsis inggize wode as tiino bonchchinttodes ga7i cubbuntsi oge gaxan Ayhude woosa keetstsan oochchizanni fana asi bo7o ga7i oochippete. Ta yinttis turo ohine un fa kumutsi anjjito ekkida ");
INSERT INTO oydl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yezin yin dahuntsis inggize wode yin mizaqi kushe oochchizanno yin workkita kushe erippe; ");
INSERT INTO oydl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","yin imotta geema maaqqe. Geema bessa oochchizanno be7ize yin aday yinttis anjjito qoncce inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Woosa woossittera cubbuntsi gaar yiippete. Un, fana asi bo7o ga7i Ayhude woosa keetstsa oge doontte eqqii woossizanno kadhane. Ta yinttis turo ohine; un fa kumutsi anjjito ekkida. ");
INSERT INTO oydl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yezin ne woossize wode ne qol7a gelo, furtsito gorddii geema yeze ne adaya woosso; geema oochinttidanno be7ize ne aday nees anjjo inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yin woossize wode ammanoosse asunts gaara cer qaala gaantsi woossippete. Un qaalito mahi mahi woossin Xoozii si7ine ga7i qoppane. ");
INSERT INTO oydl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yinnii gisho, unttinni gaar yiippete. Akkos gayko, yin aday yinttis akko koshshizako yin woossodanippa tiino erane. ");
INSERT INTO oydl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Yikke, yin yaga7i woossote: «Salo yeze nu adayo, ne geeshi suntsita anjjintto. ");
INSERT INTO oydl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne ka7itumtta yo7o, ne qoftta salo hyanidanni fana sa7an hyano. ");
INSERT INTO oydl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hyayno qumtto nuus inggo. ");
INSERT INTO oydl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nu nuna qohiduntsis, atto gaazanni fana, nuusin nu qohito atto ga7o. ");
INSERT INTO oydl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nuna iitappa ashshop attin faatana geltsippe. Ka7itumon, wolqqan bonchchon medhina nees. Amin77e. ");
INSERT INTO oydl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Yin yinttana qohizuntsana atto gayko, salo yeze yin Aday yin qohito atto gawuda. ");
INSERT INTO oydl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yezin yin melle as nagara atto ga7anxiko yin Aday yin nagartto atto ga7oos. ");
INSERT INTO oydl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Yin xoomize wode cubbuntsi fana yiippete. Akkos gayko, un xoomizanno asi erode fana fa sintto bootstsane. Ta turo ohine; un fa shilimaatto ekkida. ");
INSERT INTO oydl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","«Yezin ne xoomize wode ne sintto meecco, ne ommito tizho. ");
INSERT INTO oydl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yinnii gaar ne yiiziko ne xoomize xoomtta asappa genggida, yezin geema yeze ne Aday erize xooma maaqqada. Geema oochinttidanno be7ize ne Aday nees shilmaate inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Bila mu7ize bessa, meqo birize sa7a, kayzo bookkii ekkize sa7a, hyanna sa7ite, yinttis qolo shiishippete. ");
INSERT INTO oydl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yezin bila mo7oosse bessa, meqo biroosse bessa, kayzo bookkii ekkoosse bessa salo yinttis qolo shiishote. ");
INSERT INTO oydl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ne qoltta yeze besite ne wozintta yessada. ");
INSERT INTO oydl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Aafe asatitsis xomppe. Yinnii gisho, ne aafita faxa maaqqiko ne kumutsi asatitsita foo7o maaqqane. ");
INSERT INTO oydl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne aafita hyargginttiza maaqqiko ne kumutsi asatitsita dhuma maaqqane. Yikke, ne gidda yeze foo7ize dhuma maaqqiko, dhuma akko gaar aadhii dhuma maaqqade! ");
INSERT INTO oydl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Fettii asi lam77i Laatstsis aqodes dandda7oos. Fetaya kadhiko hyankkaya ixxane; woy fetaya bonchchiko hyankkaya leqqane. Xoozisin miishesin wolal aqodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Yikke, si7ote! yin de7o yessades, ‹Akko ma7ade? Akko ushshade? Akko ma77ode?› ga7i un7inttippete; shemppo katstsappa woy galla ma7oppa aadhoso? ");
INSERT INTO oydl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Afa landduntsana bo7ote; un budoos, maxoos, facha geltsoos, yezin yin salo aday unttana muuzane. Yin unttappa gaama aadhoso? ");
INSERT INTO oydl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yin giddappa gaama un7intti fa laytsitilla afa fettii qamma gujjodes dandda7ize yene? ");
INSERT INTO oydl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Mahi yin ma7ize bazis akkos un7intte? Ane fudhuntsana bo7ote, oochchii labboos woy suqqoos. ");
INSERT INTO oydl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Si7ote! Melle atto yezin, kaat Solomone fa bonchcho ubbanne hyanna fudhitippa fetay gaar ma77ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yin, ammano faccezuntso, Xoozii hyayno benttii wontta tama wodhdhodes yeze maata yeyzi ma7isizebaz maaqqiko, yinttana unttappa aatsii wayzi ma7isoso? ");
INSERT INTO oydl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yinnii gisho, ‹Akko mo7ode? Akko ushshade? Akko ma7ade?› ga7i un7inttippete. ");
INSERT INTO oydl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yinno ubbanno Xooz ammanoose asuntsi gaantsi denggodes un7inttane. Yin salo aday yinna ubbanna yinttis koshshizanno erane. ");
INSERT INTO oydl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yezin ubbappa tiino Xoozze ka7itumtton E xillotitsito koyote; yinna ubbanna yinttis gujunttoda. ");
INSERT INTO oydl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yinnii gisho, wonttas qoppittera un7inttippete. Wonttana wonttas aqo; fettii fettii qammize faas maaqqade madhara yene. ");
INSERT INTO oydl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Yinttalla afa firddinttaame fana melluntsalla afa firddippete. ");
INSERT INTO oydl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Akkos gayko, melluntsalla afa yin firddizanni fana yinttalla afa firddinttoda; yin melluntsis makkide bazite yinttis mahi makinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne aafte yeze tuus fana yezaya bi7ikaayzara ne ishay aafte yeze buuriza akkos be7e? ");
INSERT INTO oydl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ne aafte tuusi yessadera ne ishay aafte yeze buuriza kesso gawudes wayzi dandda7e? ");
INSERT INTO oydl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Naate cubbuzayo, tiinii ne aafte yeze tuusi fana yezaya kesso. Yinnippa suuba, ne ishay aafte yeze buuriza kessodes ne geeshi be7ada. ");
INSERT INTO oydl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Suuba maaqqii yinttana dha7aame fana geeshi baz kanuntsis olippete. Fa tohite yedhdhii iissaame fana yin al77o baz gudayluntsi tiino olippete. ");
INSERT INTO oydl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Woossote yinttis ingginttoda, koyote yin denggoda, furtsito qunkkote yinttis buginttoda. ");
INSERT INTO oydl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Woossize oodesin ingginttoda, koyze oodesin benttoda, furtsito qunkkizesin buginttoda. ");
INSERT INTO oydl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«Yin giddappa na7ay boora woossiko shuchchi inggize oode? ");
INSERT INTO oydl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Woy molo woossiko shooshi inggize yene? ");
INSERT INTO oydl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yeezin yin iita maaqqitera yin na7untsis lo77o baz ingge eriko, yin salo aday fana woossizuntsis lo77o baz wayzi gaantsi inggaamo? ");
INSERT INTO oydl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Melluntsi yinttis oochchode fana yin koyze baz ubba yinttin melluntsis oochchote. Akkos gayko, Muse higgiten nabuntsi tamaarssizannan hyanno. ");
INSERT INTO oydl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Xuuntsi furtsara gelote; akkos gayko, dhabses kanggize ogize damma, furtsitan dalgga. Iira gelize asuntsi gaama. ");
INSERT INTO oydl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yezin de7ogo kanggize ogitan furtsitan xuuntsi; yeyga gelize asuntsin eeratsi. ");
INSERT INTO oydl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Afara duro aazii fa gaatsite suudhume maaqqii yin gidda gelize worddo nabuntsappa naaginttote. ");
INSERT INTO oydl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yin unttana, un aafitippa eroda; anggatsappa woyne aafe, kenchikeloppa hyalimo maxinttoos. ");
INSERT INTO oydl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yinnii fana lo77o minxa ubba lo77o aafe aafane; iita minxa iita aafe aafane. ");
INSERT INTO oydl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo77o minxa iita aafe aafoos, mahi iita minxa lo77o aafe aafodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lo77o aafe aafoosse minxa ubba gachchintti tama olinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yinnii gisho, yin unttana, un aafte eroda. ");
INSERT INTO oydl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Salo yeze ta aday qoftto oochchize asi salo ka7itumo geloddepp attin cer tana ‹Laatstso, Laatstso› gaaze ubba salo ka7itumo geloos. ");
INSERT INTO oydl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Firdda qamma gaamuntsi, ‹Laatstso, Laatstso, ne suntsite tinbbite ohika? Ne suntsite tuna ayyaana kessika? Ne suntsite kille baz oochchika?› yaga7oda. ");
INSERT INTO oydl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ye wode taanii, ‹Ta yinttana mulon eroos, yin iita oochchizuntso taappa hyaakkote› gawuda. ");
INSERT INTO oydl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Yikke, hyanna ta qaaltto si7i oochchize ooden fa keetsito lallalla afa keexxide wozinara yeze asi fana. ");
INSERT INTO oydl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ira bukkida, hyaro goggida, baqo baqii ye keetsiza urqqida. Yezin keetsita lallalla keexinttide gisho gol7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hyanna ta qaaltto si7i oochchoose ooden fa keetsito shafella afa keexxide booza atstsa aazane. ");
INSERT INTO oydl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ira bukkida, hyaro goggida, baqo baqii, ye keetsiza urqqin, ye keetsize gol7ida; E gol7itan damma» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesuusa fa ohito hyaaside wode E timirttita higge asttamaarunts fana maaqqaanxi adetits wolqqar maaqqide gisho asuntsi E timirttite gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuusa derizeppa wodhize wode gaama asuntsi eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yikke fettii qursuma hyargginttize eego shiiqii, E tiintte bunqqunttii, «Laatstso, ne qofa maaqqiko tana geeshi fatstsodes dandda7ane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuusa fa kushito dakkii eza bochchii, «Yee, ta qofa, faxo» yagayda. Atstse iira geezhi attida. ");
INSERT INTO oydl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesuusa eego, «Ne faxito oodesin ohippe. Yezin hyanggi ne geezhi faxidanno kahinunts beezo. Ne faxidannis markka maaqqade fana hyanggi Muse kiittide zharshito zharsho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuusa Qifirnahoome katama yellide wode fettii mato hyalaqize eego shiiqii, ");
INSERT INTO oydl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Laatstso, ta arize wobbii gaama waayintti, kara woy7i yene» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuusa mahi, «Taanii hyanggi eza fatstsoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yezin mato hyalaqize mahi, «Laatstso, ne ta kara gelodes ta beezze as baaya, yezin ne hyayga bettii qaala xalaala oho, ta arize faxoda. ");
INSERT INTO oydl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Akkos gayko, taappa kattara ta kiitinttize asuntsi yene, mahi taappa gaatsara taas kiitinttizuntsi yene. Unttappa fetaya, ‹Qito› gayko qitane; hyankkaya mahi ‹hyankka yo7o!› gayko ye7ine. Ta ariza, ‹Hyanno yiizo› gayko yiizane» gayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuusa yinno si7ide wode gaama qoppii, fana kaallize asuntsago, «Ta yinttis turo ohine; taanii hyannii gaarize ammano Isra7eele as giddan bi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta yinttis ohine; gaamuntsi awa kessappan awa geloppa yi7i, salo ka7itumo Abrahamara, Yisaaqaran Yayqoobara fettilla bettoda. ");
INSERT INTO oydl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yezin salo ka7itumo laattodes beezzin attiduntsana bale dhuma oloda. Ize unttis yeefon achchi garccingge maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuusa mato hyalaqizego, «Ne kara hyanggo, ne ammanttii fana nees hyano» yagayda. E arize iira faxii attida. ");
INSERT INTO oydl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuusa Phexiroosa kara gelize wode Phexiroosa machiti intta omma otstsi misha hyarggera hyarggintti woy7i yezanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesuusa I kushito bochchide wode otsitan michita ashshii ashshida. Faxii denddii eza mokkida. ");
INSERT INTO oydl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ye wode ugure tuna ayyaanara aykinttide gaama asuntsana, asuntsi Yesuusago ki7ida. Ezin tuna ayyaanuntsana fa qaaltte kessida, hyargginttizuntsana ubba fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yinnen nabe Isayaasa, «E nu iita hyarggito faas ekkida, E nu hyarggito tookkida» gayde qaaltta folinttida. ");
INSERT INTO oydl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuusa gaama asuntsi E kale eqqidanno bi7i, abbappa seko fintsa fiinggode fana fa tamaaruntsana kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Higge asttamaaruntsappa fetay, «Asttamaarzayo, ne hyanggize bessa ubbanne ta kaalloda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuusa eego «Workkanuntsis olla yene, salo landduntsis keetstsi yene. Yezin As na7ays fa ommito shemppize bessi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesuusa kaallize asuntsappa fetay, «Laatstso, taanii tiino hyanggi ta adaya moogii yo7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yezin Yesuusa, «Hyayqqiduntsi fa hyayquntsana moogo; ne tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuusa yedhdhades gongge gelide wode E tamaaruntsin eera qitodes gelida. ");
INSERT INTO oydl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Un qoppikaayzara yezin, damma zuluntte hyaatsitilla afa denddin gonggito qoodhdhodes yellida. Yezin Yesuusa genttida. ");
INSERT INTO oydl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","E tamaaruntsi eego shiiqii eza barkkitsii, «Laatstso, nu dhabane nuna ashshoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuusa unttago, «Yin, ammano faccezuntso, akkos zhashitete?» yagayda. Denddii, zuluntton zhuubito si7i yizida. Ellisi ubba baz si7i gayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","E tamaaruntsi gaama qoppii, «Hyay, melle atto yezin, zuluntten zhuubban kiitinttize wayde aso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuusa abbappa seko fintsa yeze Gerggesoone gaaze sa7a yellide wode tuna ayyaana aykkide lam77i asuntsi boozappa kezii eera yellinttida. Un gaama iitan zhashize as maaqqide gisho asi yinna bestira aadhodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Unttin, «Xoozze na7ayo, neera nuna akko yelitsize? Wode yellikaaya yezin nuna firddodes yi7ida?» ga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Unttappa gaama hyakkikaayzar guudayile wude yengginttane. ");
INSERT INTO oydl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tuna ayyaanuntsi Yesuusa, «Ne nuna kessode baz maaqqiko, seko gudayluntsi wude gidda dakkoya» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuusa, «Qitote» yagayda. Tuna ayyaana asuntsappa kezii gudayluntsago gelida. Gudayluntsin ubba gaga doonara woxxii hyanggi abba qoodhintti hyayqida. ");
INSERT INTO oydl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gudayille wude yenggizuntsin woxxii katama hyanggi, hyanide bazin tuna ayyaana aykkide asuntsalla afa oochchidanno ubba ohida. ");
INSERT INTO oydl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yeezin, katama yeze asuntsi ubbuntsi Yesuusa bo7odes kezida. Un Yesuusa bi7ide wode fa gaditippa kezii qitode fana woossida. ");
INSERT INTO oydl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yinnippa suuba, Yesuusa gonggite gelii, abba fiinggi fa katama qitida. ");
INSERT INTO oydl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ize eerats asuntsi fettii wobbo atstsa alggara tookkii Yesuusago ki7ida. Yesuusa un ammantto bi7i, wobbo atstsa, «Ta na7ayo, zhashtippe! Ne nagartta atto ga7inttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yinna saate, Ayhude higge asttamaaruntsappa fete fete, «Hyanna Xooz cazhe baane» yaga7i fa wozintte qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuusa un qoftto erii, «Iita baz yin wozintte akkos qoppete? ");
INSERT INTO oydl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yezin, ‹Ne nagartta atto ga7inttida› gaazannippan ‹Denddii eqqii qito› gaazannippa ayye foolle? ");
INSERT INTO oydl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yezin sa7alla afa nagara atto gawudes As na7as adetita wolqqa yezanno ta yinttana erisoda» yaga7i, wobbo atstsego, «Denddii, ne alggiza tookkii, kara qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wobbo atstse denddii fa kara qitida. ");
INSERT INTO oydl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Worzhita yinno bi7i gaama qoppida. Yinnii fana adetits wolqqa asis inggide Xoozza galatida. ");
INSERT INTO oydl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuusa yeygappa denddii hyanggitera Maatoosa gaaze qaraxe gachchize bessa bettii yezin bi7i, «Tana kaallo» yagayda. Ezin denddii kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuusa Maatoosa kara leematella bettii yezin, qaraxe gachchize gaama asuntsin nagaranchchuntsi yi7i eeran E tamaaruntsara wolla mo7odes bettida. ");
INSERT INTO oydl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fettii fettii Farisaawuntsi yinno bi7i, Yesuusa tamaaruntsara, «Yin asttamaarize qaraxe gachchizuntsaran nagaranchchuntsara akkos me7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesuusa yinno si7i, «Gaalla koshshize hyargginttizuntsap fattin faxuntsis baaya. ");
INSERT INTO oydl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yezin yin hyanggi, ‹Taanii yin zharshito baayzin yin melluntsana maarode fana koyane› ga7intti xaafinttidanna waagizako erote. Akkos gayko, taanii nagaranchchuntsana xeegodes yi7idap attin xilluntsana xeegodes yi7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ye wode Wahannisa tamaaruntsi Yesuusago shiiqin, «Nuunin Farisaawuntsin xoomane, yezin ne tamaaruntsi akkos xoomoso?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuusa mahi unttago, «Mushura unttara yezin xeegintti yi7ide asuntsi azzanodes dandda7ane? Mushura un kaleppa ekkinttode wode yo7oda, un ye wode xoomoda. ");
INSERT INTO oydl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Kille ma7oppa feedhii gal77a ma7olla sikkize ooden baaya. Yinnii fana yeyziko killize gal77iza feedhane. Feedhitsitan wozzii dalggane. ");
INSERT INTO oydl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kille woyne gal77a silphe gujjize ooden baaya. Yinnii fana yeyziko kille woynize gal77a silphiza dhuussane woynizen lanttane; silphizen lam7intsa maaddoose baz maaqqane. Yezin kille woyne kille silphe gujjodes beezane. Yinnii fana yeyziko lam77untsin iitikaayzara naaginttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuusa yinna ohitilla afa yezin, Ayhude hyalaquntsappa fetay eego yi7i, E tiino bunqqunttii, «Ta na7ita hyatte hyayqqida, yezin iza faxode fana ne yi7i ne kushito iilla afa gaddoyo» ga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesuusa denddii eera hyanggida; E tamaaruntsin kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","E hyanggizin taphpho lam77i bere kumutsi suutsi googii waaytsize fettii maachita suubara shiiqii Yesuusa ma7iti macartto bochchida. ");
INSERT INTO oydl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Iza fa wozintte, «Ta E ma7iti macartto xalaala bochchizako faxoda» yaga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuusa suub maaqqii izo bi7i, «Ta na7ite, zhashitippe! Nena ne ammantta fatstsida» yagayda. Astan iira faxii attida. ");
INSERT INTO oydl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuusa Ayhude hyalaqize kara yellide wode zaye fuggizuntsanan yeekizuntsana bi7i, ");
INSERT INTO oydl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ane hyal7ote; eerats na7ita genttidap attin hyayqqikaaya» yagayda. Yezin asuntsi eella afa miicida. ");
INSERT INTO oydl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Asuntsana bale kessidannippa suuba keetstsa gelii, na7iti kushito aykkida, na7itan denddii eqqida. ");
INSERT INTO oydl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yinna ohita yinna sa7ito ubba yellida. ");
INSERT INTO oydl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuusa yeygappa denddii gode tiino hyanggodera lam77i qooquntsi fa qaaltto dhoqi yiizii, «Dawute na7ayo, nuna maaroya» yagaytira eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesuusa keetstsa gelize wode qooquntsi eza kaallii yellida. Yesuusa unttago, «Taanii yinno oochchodes dandda7izanno yin ammananete?» yagayda. Unttin, «Yee, Laatstso» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yinnippa suuba, Yesuusa un aafto bochchii unttago, «Yinttis, yin ammanttii fana hyano» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Un aafitan bugunttida. Yesuusa unttago, «Hyanno oodesin ohippete» yaga7i mintsii ohida. ");
INSERT INTO oydl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yezin asuntsi hyanggi Yesuusa baz yinna sa7ite ubba ohida. ");
INSERT INTO oydl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Un yeygappa kezze wode asuntsi tuna ayyaana aykkii muumuzide fettii asi Yesuusago ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tuna ayyaana kezideppa suuba muume atstse ohinttida. Asuntsin gaama qoppida, «Yinnii fana kille baz Isra7eele sa7a hyanikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yezin Farisaawuntsi, «Tuna ayyaanunts hyalaqara tuna ayyaanuntsana kessane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuusa Ayhude woosa keetstsa tamaarssitera, salo ka7itumo Wonggele sabbakitera, asuntsana hyargge ubbappa fatstsitera kataman kara gancce ubbanne wutida. ");
INSERT INTO oydl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gaama worzhita, yenggize asi baayze duro fana unttana be7ize asi dhabin un yezanno bi7i unttis yiqsinttida. ");
INSERT INTO oydl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Fa tamaaruntsago, «Shiiqode katsita gaama, yezin katsito shiishize asuntsi eeratsi. ");
INSERT INTO oydl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yinnii gisho, Laatstsi katstsa shiishode oochanchchuntsana dakkode fana woossote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuusa taphpho lam77i tamaaruntsana faago xeegii, tuna ayyaana kessode fanan hyargge ubbappa fatstsode fana unttis adetits wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesuusa kiittide taphpho lam77i hawaaruntsi suntsita; tiinize Phexiroosa gaaze Simoona E ishe Inddiriyase, Zabdiyoosa na7a Yayqooban E ishe Wahannisan, ");
INSERT INTO oydl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filphoosa Bartolomiyoosa, Toomaasa qaraxe gachchize Maatoosa, Ilfiyoosa na7a Yayqooba, Taadiyosa, ");
INSERT INTO oydl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","fa gaditis yiqsinttize Simoonan Yesuusa aatsii inggide Yesqorootu Yihuda. ");
INSERT INTO oydl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yinna taphpho lam77untsi Yesuusa kiittii dakkitera, «Ayhude maaqqoosse worzhago hyanggippete, mahi Samaara asunts kataman gelippete. ");
INSERT INTO oydl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yezin Isra7eele keetstsappa maaqqide sekka dhabide duruntsago hyanggote. ");
INSERT INTO oydl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ize hyanggi, ‹Salo ka7itumo ukkida› ga7i ohote. ");
INSERT INTO oydl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hyargginttizuntsana fatstsote, hyayqqiduntsana hyayqqoppa dentstsote, qursuma hyargginttizuntsana geeshii fatstsote, tuna ayyaana kessote. Yin hyarii ekkidanno hyarii inggote. ");
INSERT INTO oydl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yin kiistte worqqa, woy bira santtime aykkippete. ");
INSERT INTO oydl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yin oges karxite, lam77i ma7o, woy caamma woy gufe aykkippete; oochchizuntsis hyayno quma beezane. ");
INSERT INTO oydl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Yin fettii katama woy kara gancce gelize wode yinttana mokkii ekkodes ufayttize asi koyi E kara gelote; yin qitode wontsis ize gam7ote. ");
INSERT INTO oydl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mahi oode karan gelitera saritsote. ");
INSERT INTO oydl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yinna keetsita yinttana mokkiko yin saritside sartta unttana yello, yezin un mokkanxiko yin saritside sartta yinttis suub maaqqo. ");
INSERT INTO oydl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ooden yinttana mokkanxiko yin ohize baz si7anxiko yinna keetsitifa woy yinna katamttippa kezitera yin tohite yeze xurito fixxii kezote. ");
INSERT INTO oydl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta yinttis turo ohine; Xoozze firdda qamma yinna katamttippa Soodomasin gamoora katamitis firdda eeroda. ");
INSERT INTO oydl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Ta yinttana duro fana suudhumuntsi gidda dakkoda. Yinnii gisho, shooshi fana cincca, wolle fana aada maaqqote. ");
INSERT INTO oydl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Asuntsi yinttana firddize daynnuntsis aatsii inggoda, mahi Ayhude woosa keetstsa yinttana garaafoda. Yinnii gisho, unttappa naaginttote. ");
INSERT INTO oydl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta gisho ga7i yinttana worzhito ahizunts tiino kaatuntsi tiino kanggoda. Un tiintte Ayhude maaqqoosse worzhunts tiino eqqii yin ta baz markkidhoda. ");
INSERT INTO oydl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yezin yinttana firddas aatsii inggize wode waaga7i mahode ga7i un7inttippete; yinna saate yin gawude baz Xoozii yinttis inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Akkos gayko, yinttana ohize yin Aday Geeshi Ayyaanappa attin yinttana baaya. ");
INSERT INTO oydl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ishay fa ishaya, aday fa na7aya, hyayqos aatsii inggoda, na7untsi fana yeliduntsalla afa denddii unttana wodhissada. ");
INSERT INTO oydl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta gisho ga7i asi ubbuntsi yinttana ixxoda, yezin wurssutsi yellodes miinggide attoda. ");
INSERT INTO oydl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Fettii kara gancceppa yinttana un bay7iko melle katama bettote. Taanii yinttis turo ohine; As Na7ay yo7ode wontsis, yin Isra7eele katama ubba kantsaama. ");
INSERT INTO oydl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Tamaaruntsi fa asttamaarzeppa, arizen fa laatstseppa aadhoos. ");
INSERT INTO oydl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tamaarize fa asttamaarize, arize fa laatstsize fana yiiko ees maaqqada. Karttii aday Bi7elzebuula gayko E kara asuntsana wayzi wozzii iissii xeegoso? ");
INSERT INTO oydl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Yikke, asis zhashitippete. Geenggide baz qonccoda, Aachinttide baz geesha kezikaayzara attoos. ");
INSERT INTO oydl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Taanii yinttis dhuma ohize baz yin foo7o ohote; ta yinttis hyaye kalkashide baz zoozella awaajjote. ");
INSERT INTO oydl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ashop attin shemppo wodhodes dandda7osuntsis zhashitippete. Yezin shemppiton ashton gaanname dhabssodes dandda7ize Xoozzes zhashtote. ");
INSERT INTO oydl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Lam77i buubbe landduntsi fettii santtime bayzinttoossane? Yi7op attin, unttappa fetayn yin Xoozze gaykaayzin sa7a wodhdhoos. ");
INSERT INTO oydl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Melle atto yezin, yin omma isintsitan faydintti yene. ");
INSERT INTO oydl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yikke, gaama buubbe landduntsappa yin aadhize gisho zhashitippete. ");
INSERT INTO oydl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«As tiino taas markkidhize ubbuntsis taanin salo yeze ta aday tiino markkidhada. ");
INSERT INTO oydl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yezin as tiino tana kaddizaya taanin salo yeze ta aday tiino kaddoda. ");
INSERT INTO oydl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Taanii sa7alla lo77o ko7odes yi7ida yinttis aazippe. Taanii olappa attin sarotits ko7odes yi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Taanii yi7idanna, «Na7aya adeppa maachi na7ito inttippa Na7ay machchito azinze inttippa shaakkodes. ");
INSERT INTO oydl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Asis morkkuntsi E kara asuntsana maaqqoda.» ");
INSERT INTO oydl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Taappa aatsii fa adaya woy fa intto kadhize, ta baz maaqqodes beezoos. Fa dhiiratsi na7aya woy fa maachi na7ito taappa aatsii kadhize, ta baz maaqqodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Fa masqala tookkii tana kaalloosse ooden ta baz maaqqodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Fa shemppito ashshodes koyze dhabssoda, yezin fa shemppito ta gisho aatsii inggize ashshoda. ");
INSERT INTO oydl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Yinttana mokkize tana mokkane, tana mokkize mahi tana kiittidaya mokkane. ");
INSERT INTO oydl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nabe nabe suntsite mokkize, nabe fana waaga ekkoda; mahi xilliza xillo suntsite mokkize, xillize fana waaga ekkoda. ");
INSERT INTO oydl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta yinttis turo ohine; hyantsi ta tamaaruntsappa eerize fetay tana kaallize gisho melle atto yezin eeratsi toya hyaatsi inggiko E waagita dhaboos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuusa taphpho lam77i tamaaruntsana kiittii hyaasidannippa suuba izippa denddii tamaarssodesin sabbakodes Galila katama qitida. ");
INSERT INTO oydl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wahannisa achi keetstsa yezara Kiristtoosa oochito si7i, fa tamaaruntsappa eego kiittii, ");
INSERT INTO oydl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Yo7oda ga7inttide nenane? Woy nu melle kafode?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuusa unttago mahi, «Hyanggi yin si7ide bazin yin bi7idebaz Wahannisas ohote. ");
INSERT INTO oydl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Qooquntsi be7ine, wobbuntsi yedhdhane, qursuma hyargginttizuntsi geezhane, tulluntsi si7ine, hyayqqiduntsi hyayqoppa denddane; dahuntsis Wonggele sabbakinttane. ");
INSERT INTO oydl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Taara dhubunttoosse anjjinttidaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wahannisa tamaaruntsi suub maaqqii hyanggin, Yesuusa worzhuntsis Wahannisa baz ohitera, «Hyanna akko baayze ganasa akko be7ades yi7idate? Baqo en7ize shombboqo be7ades yi7idate? ");
INSERT INTO oydl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yeezin, akko be7ades yi7idate? Bonchcho ma7o ma77ide asuntsana be7adesine? Bonchcho ma7o ma77iduntsi kaat kara yene. ");
INSERT INTO oydl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yeezin, akko be7ades kezidote? Nabe be7adesine? Yee, yin nabeppan aadhizaya be7ine. ");
INSERT INTO oydl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","«Ne ogito ne tiintte giigize ta kiitanchchiza neeppa tiino kiittoda» ga7intti xaafinttidanna ees. ");
INSERT INTO oydl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta yinttis turo ohine; maachippa yelinttiduntsi giddappa xammaqize Wahannisappa aadhize oonin denddikaaya; yezin salo ka7itumo ubbuntsappa eerize E, eeppa aadhoda. ");
INSERT INTO oydl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xammaqize Wahannisa wodeppa dentsii hyayno yellodes salo ka7itumo gaama urqqinttane, miinggi butunttizunts denggoda. ");
INSERT INTO oydl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nabunts ubbuntsi higgen Wahannisa baz tinbbite ohida. ");
INSERT INTO oydl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yikke, yin un kiitto ammanodebaz maaqqiko, yo7oda ga7inttide Eeliyaasa, E Wahannisa. ");
INSERT INTO oydl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yikke, si7ize hyaye yeze si7o. ");
INSERT INTO oydl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Yikke, taanii hyanna wode yeletto akkora aazissade? Gabe gidda bettii wol xeegii, ");
INSERT INTO oydl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","« ‹Nu yinttis suulunqe fuggin; yin yexxikaaya. Nu nashshii gayrin; yin yeekkikaaya› yagaaze na7untsana aazane. ");
INSERT INTO oydl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xammaqize Wahannisa mu7ikaayzaran uzhikaayzara yi7in, ‹Tuna ayyaana yene› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","As na7ay mu7iteran uzhitera yi7in, ‹Zhimbbaran ushi asi, qaraxe gachchizuntsisin nagaranchchunts igina› yagayda. Yikke, cinccatitsin turetitsi E oochite qonccane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yinnippa suuba, Yesuusa gaama kille baz oochchide katamuntsi gidda yeze asuntsi fa nagarttippa maaqqii maarotitsi gelanxi ixxide gisho unttana, ");
INSERT INTO oydl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Bade Koraaziine katamite, bade Beetesayida katamite, akkos gayko, yin gidda oochinttide kille baz Xiroosa giddan Sidoona gidda oochinttidebaz maaqqizako, un zaga budo tizhintti, kayo afula ma77i fa nagarttippa maaqqii attod yeshsha. ");
INSERT INTO oydl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yezin ta yinttis ohine; firdda qamma yinttappa aatsii Xiroosasin Sidoonasi firddita eeroda. ");
INSERT INTO oydl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mahi, Qifirnahoome, neenii ude salo kezodes koyane? Hyanoos! Ne si7oole olinttoda. Akkos gayko, ne gidda oochchinttide kille baz Soodoma oochchinttidebaz maaqqizako, Soodoma hyayno yellodes yessad yeshsha. ");
INSERT INTO oydl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yezin ta nees ohine; firdda qamma neeppa aatsii Soodomas firdda eeroda». ");
INSERT INTO oydl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ye wode Yesuusa, «Adayo, salo sa7a Laatstso, ne hyanno eruntsappan cincuntsappa aachchii na7untsis qonccizide gisho nena galatane. ");
INSERT INTO oydl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yee, ta Adayo, hyanna ne lo77o qoftti fana hyanida. ");
INSERT INTO oydl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Ubbanna taas ta Adeppa ingginttida. Adayppa melle na7aya erize baaya, na7ayppan E qonccodes koyezuntsappa melle Adaya erodes dandda7ize baaya. ");
INSERT INTO oydl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Yin, labbiduntso, toofo deexide ubbuntsi taago hyanka yo7ote; ta yinttana shemppisada. ");
INSERT INTO oydl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Taanii ta wozintte dalggan aada maaqqide gisho ta qambbartto tookkote, taappa tamaarote; yin, yin shemppitis shemppo denggoda. ");
INSERT INTO oydl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta qambbartta sila, mahi ta toofitan foollo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ye wode, Sambbata qamma, Yesuusa gade giddara aadhida. Yesuusa tamaaruntsi naydhdhide gisho tizha bangga shicci dha7ane. ");
INSERT INTO oydl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yezin Farisaawuntsi yinno bi7i Yesuusago, «Hyaychche, ne tamaaruntsi Sambbata qamma oochchodes beezoosse baz oochchane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuusa unttago mahi, «Dawute naydhdhide wode eera yezuntsara akko oochchezako nabbabikate? ");
INSERT INTO oydl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawute Xoozze keetstsa gelii kahinuntsi xalaalap attin eesin eera yezuntsis beezoosse geeshi daabbo mu7ida. ");
INSERT INTO oydl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Woy kahinuntsi Sambbata woga shaarii Xoozze keetstsa Sambbata qamma oocha oochchiko unttis bala baayzanno Muse higgeppa nabbabikate? ");
INSERT INTO oydl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yezin ta ohine! Xoozze keetstsappa aadhize hyanne yene. ");
INSERT INTO oydl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹Taanii yin zharshito baayzin yin melluntsana maarode fana koyda› gaaze qaaltta waagizako yin erezako geeshi asuntsalla afa firddaama yeshsha. ");
INSERT INTO oydl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","As na7ay Sambbata Laatstsi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuusa yeygappa kezii Ayhude woosa keetstsa gelida. ");
INSERT INTO oydl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ize kushe wobbo fettii asi yene. Yesuusa mootodes mikinaate koyze asuntsi, «Sambbata qamma fatstsodes beezanene beezoso?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","E unttago, «Yin giddappa fetays duro Sambbata qamma gaga qitiko, gochchii keesoose oode? ");
INSERT INTO oydl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yeezin asi duroppa wayzi gaama aadhoso? Yinnii gisho, Sambbata qamma ubba lo77o baz oocha beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yinnippa suuba, Yesuusa atstsego, «Ne kushito luulizo yaga7in,» atstse luulizida. E kushize faxii hyankay kushe fana yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yezin Farisaawuntsi yeygappa bale kezii, Yesuusa wayzi wodhod yezako zorinttida. ");
INSERT INTO oydl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuusa un qoftto erii yinna besito ashshii melle bessa qitida. Gaama asuntsi eza kaallii qitida, hyargganchchuntsana ubba fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yesuusa, «Ta baz melle oodesin ohippete» yaga7i mintsii ohida. ");
INSERT INTO oydl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yinnan nabize Isayaasa, ");
INSERT INTO oydl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Hyaychche ta dooride arize, ta kadhize, tana ufaysize, taanii ta ayyaana, eella afa gaddoda; E, Ayhude maaqqoosse worzhitis firdda awaajjoda. ");
INSERT INTO oydl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E lalloos woy uukkoos; E qaaltton oge cer si7ize baaya. ");
INSERT INTO oydl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Firdda gamii denddode wontsis, donccinttide shombboqo mentsoos, cugize shombboqo fana dhabsoos. ");
INSERT INTO oydl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Worzha ubba eella ufayssi gaddoda» yaga7i xaafinttidanna folinttode fana. ");
INSERT INTO oydl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yinnippa suuba, tuna ayyaanara aykinttide qooqen doona muume asi yezaya eego ki7ida. Yesuusa atstsa fatstsin, atstse be7inen ohinttane. ");
INSERT INTO oydl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Asuntsi ubbuntsi gaama qoppii, «Hyay Dawute na7a maaqqada yessane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yezin Farisaawuntsi yinno si7i, «Hyay atstse tuna ayyaanuntsana kessize tuna ayyaanunts hyalaqa Bi7elzebuula wolqqara» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuusa un qoftto erii, «Wol gidda shaakkinttize ka7itumo ubba gol7oda; mahi wol gidda shaakkinttize katamita woy keetsita miinggi eqqoos. ");
INSERT INTO oydl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xalahe xalahe kessizebaz maaqqiko fa gidda shaakkinttane ga7intte. Yinnii fana hyanizebaz maaqqiko E ka7itumtta wayzi miinggi eqqodes dandda7e? ");
INSERT INTO oydl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taanii tuna ayyaana kessize Bi7elzebuula wolqqara maaqqiko yinttana kaallize asuntsi oode wolqqara kessode? Yinnii gisho, yinttana kaallize asuntsi yinttana firddoda. ");
INSERT INTO oydl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yezin taanii tuna ayyaana kessize Xooz Ayyaanara maaqqiko, Xoozze ka7itumo yinttago yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Woy fettii asi wolqqara yeze atstse kara gelii E qoltto bonqodes koyko tiinii ye atstsa accanxiko wayzi bonqodes dandda7ode? Yeyziko E qoltto bonqodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Taara maaqqoosse ooden tana ixxane; mahi taara fettilla shiishoosse ubba lalane. ");
INSERT INTO oydl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yinnii gisho, ohine; asuntsi oochchize akko nagaran cashshi qaala ubba atto ga7inttoda, yezin Geeshi Ayyaana cazhize oodesin E nagartta atto ga7inttaama. ");
INSERT INTO oydl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ooden As na7alla afa iita baz ohiko ees atto ga7inttoda, yezin Geeshi ayyaanalla afa iita baz ohize oodesin hyanne sa7ite maaqqikon yo7ode alamite E nagartta atto ga7inttaama. ");
INSERT INTO oydl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Lo77o minxa lo77o aafe aafane; mahi iita minxa iita aafane. Yikke, minxa erinttize fa aafte. ");
INSERT INTO oydl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yin, shooshi na7untso, yin iita maaqqitera wayzi lo77o baz oochchodes dandda7e? Asi fa wozina kumidanno doonara ohine. ");
INSERT INTO oydl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lo77o asi fa wozinttippa, lo77o baz kessane; iita asi fa wozinappa, iita baz kessane. ");
INSERT INTO oydl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yezin si7ote, asuntsi ohinttize cer ohe ubbas firdda qamma mahe inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Akkos gayko, ne ohize ne qaaltte xilloda; ne ohize ne qaaltte neella afa firddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yinnippa suuba, fettii fettii Farisaawuntsin higge asttamaaruntsi Yesuusago, «Asttamaarzayo, neeppa kille baz be7ades koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yezin Yesuusa mahi, «Ammaninttoosen iita yeletuntsi kille baz koyane. Yezin nabe Yoonasa kille bazappa melle kille baz unttis ingginttoos. ");
INSERT INTO oydl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonasa molo saza hyaydzdzii awaran hyaydzdzii qamma gam7idanni fana As na7a hyaydzdzii awaran hyaydzdzii qamma sa7a gaatsa gam7oda. ");
INSERT INTO oydl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nenewe asuntsi firdda qamma denddii hyanna yeletuntsara wolla unttalla afa firddoda; akkos gayko, un Yoonasa sibkketo si7i fa nagarttippa maaqqida. Yikke, Yoonasappa aadhize hyanne yene. ");
INSERT INTO oydl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Firdda qamma yeekka kaatita denddii hyanna yeletuntsara wolla unttalla afa firddoda; akkos gayko, iza Solomone cinccatitsito si7odes sa7a gaxappa yi7ida. Hyaychche, Solomonappa aadhize hyanne yene. ");
INSERT INTO oydl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Tuna ayyaana atstseppa kezideppa suuba faas shemppize bessi koyi hyaatsi baayze bessa hyanttane, Yezin fa koyze shemppo denggoos. ");
INSERT INTO oydl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yezin, ‹Ta ashshii kezide keetstsite maaqqii hyanggoda› yagaane. E maaqqize wode keetsita kaysi maaqqidannon fixinttii lo77i bettidanno denggane. ");
INSERT INTO oydl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yikke, maaqqii hyanggi, faappa iita melle laappun iita ayyaanuntsana ekkii ye7ine; unttin ize gelii yezane. Ye atstses tiinostippa suubanna gaama iitane. Ye iita yeletuntsalla afa yinnii fana yi7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuusa worzhitis ohella afa yezin E inttan E ishuntsi eza ohissades koyi bale eqqida. ");
INSERT INTO oydl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Fettii asi eego, «Ne inttan ne ishuntsin nena ohissades koyi bale eqqida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesuusa mahi, «Ta intta oode? Ta ishuntsin oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Fa kushtira tamaaruntsana mallitera, «Bo7ote, ta inttan ta ishuntsin hyantsesana. ");
INSERT INTO oydl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Salo yeze ta Aday qoftto oochchize ubbuntsi taas ishe, taas mishon taas inddo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ye wode Yesuusa karappa kezii abba gaxa bettida. ");
INSERT INTO oydl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gaama asuntsi E kale shiiqin asuntsana abba gaxa ashshii ashshii gongge gelii bettida asuntsin ubba abba gaxa eqqida. ");
INSERT INTO oydl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Asuntsis gaama baz aazizera yaga7i ohida: «Fettii budutsi budize budutsi budodes kezida. ");
INSERT INTO oydl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E budize wode fettii fettii budutsita oge gaxalla wodhdhida; unttana landduntsi yi7i maxii muyda. ");
INSERT INTO oydl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Fettii fettii budutsita oomora lalla yeze sa7a wodhdhida. Gaama sa7a baayze gisho ellisii dolida. ");
INSERT INTO oydl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Yezin awa kezin shullida; xapho baayze gisho melida. ");
INSERT INTO oydl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fettii fettii budutsita anggats gidda wodhdhida; anggatsita diccii yinna doltto cuullida. ");
INSERT INTO oydl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Melluntsi mahi aradda sa7alla wodhdhida; dolii aafe aafida. Fetay xeeti, fetay izipuntam, fetay mahi hyasttam aafida. ");
INSERT INTO oydl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Si7ize hyaye yeze si7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuusa tamaaruntsi eego shiiqii, «Akkos ne worzhitis aazizera ohe?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E mahi, Yinttis salo ka7itumo gaatsi qofa era ingginttida, Yezin unttis ingginttikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yeze ubbuntsis gujunttoda, ees gaammada, yezin baayzeppa melle atto yezin ees yezayin ekkinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yinnii gisho, taanii un, bi7itera denggaame fana, si7ittera si7aame fana woy qoppaame fana unttis aazizera ohine. ");
INSERT INTO oydl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isayaasa fa maxaafite ohidanna unttalla afa folinttida. E ohitera, «Yin sisi si7ine, yezin qoppoos; yin be7ine, yezin bo7oos. ");
INSERT INTO oydl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Akkos gayko, hyantsi asunts wozintta muumida; fa hyayto doozhizida, fa aafto goozida. Yinnippa denddii Fa aaftira bo7oos, fa hyaytiran si7oos, fa wozintten tiiroos, taago maaqqades dandda7oos, taanin unttana fatstsoos yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Yezin yin aafta be7ize gishon yin hyayta si7ize gisho anjjinttiduntsana. ");
INSERT INTO oydl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta yinttis turo ohine; gaama nabuntsin xillo asuntsi yin be7izanno be7ades yin si7izanno si7odes amudhdhida, yezin unttis hyanikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Yikke, hyay budutsito budize atstse aazizto si7ote. ");
INSERT INTO oydl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oge gaxa wodhdhide budutsiti aazizta hyanno; salo ka7itumo qaala si7i tiiroosse atstse wozinttippa Xalahe yi7i E wozintte yeze budutsito maxii hyaasane. ");
INSERT INTO oydl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lalla oomo yeze sa7alla budinttide qaala si7i ellisii ufaytti ekkizuntsana. ");
INSERT INTO oydl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yezin xapho dakkodes dandda7oosse gisho gam7oos. Qaala gisho madha woy baytsi ye7ize wode ellisii dhubinttane. ");
INSERT INTO oydl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Anggats gidda budinttide qaala si7ine, yezin hyanna alame yessi yirgappan durtumo qofappa qaaltto cuullide gisho aafe aafanxii attida. ");
INSERT INTO oydl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yezin aradda sa7a buduninttide budutse qofara qaaltto si7ize asi. E aafe aafane; fetay xeet, fetay izipuntam fetay mahi hyasttam aafane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuusa unttis melle aazize ohida, «Xoozze ka7itumo fa gadite lo77o budutsi budide atstsa aazane. ");
INSERT INTO oydl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yezin asi ubba genttin E morkkize yi7i zargiti gidda zarddo budi qitida. ");
INSERT INTO oydl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Zargita diccii aafodera zarddizen ye wode benttida. ");
INSERT INTO oydl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«Gaditii aday aruntsii adego hyanggi, ‹Laatstso, ne gadite ne lo77o budutsi budika? Yeezin, zarddo anappa yi7ido? yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«E unttago, ‹Yinno morkke oochchida› yagayda. «Aruntsii laatstsego, ‹Nu hyanggi zarddito shoddode gaar koyane?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Yezin E, ‹Atto bochchippe; yin zarddito shoddane gawudera zargita shoddinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bochchippete; maxize wode yellodes wolla dicco. Ye wode maxizuntsi zarddito tiinii shoddii tamar eetsodes mirqera mirqera gaddote. Yezin zargito shiishii ta fachite geltsote› gawuda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mahi melle aazize yaga7i ohida; «Salo ka7itumo fettii asi fa gadite budide eeratsi minxa aafe aazane. ");
INSERT INTO oydl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yinna aafita melle minxa aafe ubbappa eeratsi, yezin doltta diccii melle minxa ubbappa aadhii dammane. I zhanggitilla landduntsi keexii bettode wontsis damma minxa maaqqane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mahin, Yesuusa melle aazize ohida; «Salo ka7itumo fettii maachita hyaydzdzii gabate dhiilla ekkii munuqide, munuqita denddode fana ize gujjide irshsho aazane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuusa worzhitis yinna aazizto ubba ohida. Aazize baayzin fettii bazin ohikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nabize fa maxaafite, «Taanii ta doona, aazizera bugane; salon sa7an medhinttidannippa, aachinttidanno ohine» yaga7i ohidanna hyanne folinttida. ");
INSERT INTO oydl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuusa worzhito moyzii keetstsa gelida. E tamaaruntsi eego shiiqii, «Gade yeze zarddo bilitsito nuus oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E mahi, «Lo77o budutsito budide As Na7a. ");
INSERT INTO oydl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gadita hyanna alamito. Lo77o budutsita salo ka7itumo na7untsana. Zarddize Xalahe na7untsana. ");
INSERT INTO oydl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zarddiza budide morkke Xalahe. Maxize wodita, wode wurssutsite. Maxizuntsi kiitanchchuntsana. ");
INSERT INTO oydl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«Zarddo maxii tama eetsizanni gaar wode wurssutsite yinnii gaar maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","As Na7ay fa kiitanchchuntsana kiittoda. Un nagaras mikinaate maaqqiduntsana iita oochchize ubba maxii E ka7itumttippa kessoda. ");
INSERT INTO oydl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yeefon achchi garccingge aadhii eexize tama oloda. ");
INSERT INTO oydl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ye wode geeshuntsi fa aday ka7itumtte awa gaar foo7oda. Si7ize hyaye yeze si7o! ");
INSERT INTO oydl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Salo ka7itumo gade mooginttide miishe fana. Fettii asi yinna miishito denggi mahi moogida. Gaama ufaytti hyanggi faas yeze baz ubba bayzi yinna oocha gadito wonggida. ");
INSERT INTO oydl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Yinnii gaara, mahi salo ka7itumo inqo gaaze al77o shuchchi koyze zali7ancho aazane. ");
INSERT INTO oydl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gaama al77o inqiza denggi hyanggi faas yeze baz ubba bayzi eza woonggida. ");
INSERT INTO oydl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Mahi Salo ka7itumo abba olinttide dumma dumma molo aykkize gite aazane. ");
INSERT INTO oydl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Molo aykkize asuntsi molo gitite kumin abbappa gaxa kessida. Ize bettii lo77ito qurii qurii daachcho olida, yezin iitto alla olida. ");
INSERT INTO oydl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wode wurssutsite yinnii fana hyanoda. Kiitanchchuntsi yi7i nagaranchuntsana xilunsappa shaakkii, ");
INSERT INTO oydl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yeefo achchi garccinggen aadhii eexize tama oloda. ");
INSERT INTO oydl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«Hyanna ubbanna yinttis gelida?» yaga7i unttana oocida. Un mahi, «Yee» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesuusa, «Yikke, salo ka7itumo kaallizen higge tamaare ubba, fa minjjide qoloppa killen gal77a kessize asi aazane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuusa yinna aazizito ohi hyaasidannippa suuba yeygappa denddii qitida. ");
INSERT INTO oydl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Fa yelinttide sa7a hyanggi Ayhude woosa keetstsa worzhito tamaarssida. Un gaama qoppii, «Hyay atstse hyanna cinccatitsiton wolqqa kumide kille bazito anappa ekkido? ");
INSERT INTO oydl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hyay anaaxize na7a baane? E inttii suntsita Mayramo baane? E ishuntsi Yayqooba, Yoosefa, Simoonan Yihuda baane? ");
INSERT INTO oydl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E mishuntsi nuura yezuntsana baane? Yeezin, hyay atstse hyanno ubbanno anappa ekkido?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yinnii gisho, E gaaze bazito ekkanxi ixxida. Yezin Yesuusa, «Nabe fa yelinttide sa7an fa kara asunts kale bonchinttoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Un ammananxide gisho gaama kille baz yinna besite oochchikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ye wode ahize Heroodisa Yesuusa baz si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Fa aruntsago, «Yikke Xammaqize Wahannisa; E hyayqoppa denddida. Yinnii gisho hyanno ubba kille bazito E oochchane» gayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","E yinno gaydanna Heroodisa fa ishe Filphoosa machchiti Heroodiyada mikinaatera Wahannisa achi keetstsa geltside gisho. ");
INSERT INTO oydl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Wahannisa Heroodisago, «Ne izo ekkodes beezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodisa Wahannisa wodhodes koyda, yezin worzhita Wahannisa nabe mahi be7ize gisho zhashtida. ");
INSERT INTO oydl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Heroodisa fa yelinttide qammito bonchchize wode Heroodiyada na7ita asunts tiino yexxitera doollii eza ufayssida. ");
INSERT INTO oydl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yeezin, E, «Iza koyze baz ubba inggoda ga7i» caaqqida. ");
INSERT INTO oydl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na7ita fa inttii zore si7i Heroodisago, «Xammaqize Wahannisa ommito gabate gaddii taas inggo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Iza yaga7in kaatize qoppii azzanida, yezin fa caaqqiti gishon faara yeze zaqqunts gisho ga7i iza oocidanno folode fana kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kaatize as kiittii Wahannisa achi keetstsa yezin E afurtto gachchida. ");
INSERT INTO oydl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ommito gabate gaddii ki7i na7itis inggida; na7itan ekkii fa inttis kanggida. ");
INSERT INTO oydl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wahannisa tamaaruntsi yi7i E ahito kanggi moogida. Yinnippa suuba hyanide baz ubba hyanggi Yesuusas ohida. ");
INSERT INTO oydl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuusa hyanide bazito si7ide wode gongge gelii yinna bestippa fettii geema bessa faas qitida. Asuntsi yinno si7i katamappa denddii tohera eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuusa gonggeppa wodhdhii gaama asuntsana bi7i unttis yiqsinttida. Un gidda yeze hyargginttizuntsana fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa7ita ugurodera Yesuusa tamaaruntsi eego shiiqii, «Hyanna besita akko baayze ganas bessi, sa7itan qammida. Yinnii gisho, kale yeze kara gancce hyanggi faas katstsa wonggode fana asuntsana dakko» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yezin Yesuusa unttago, «Asuntsi qitodes beezoos; un mo7odebaz yin inggote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Un mahi, «Nuura hyanne ichchin boorappan lam77i moloppa melle baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ezin, «Ane yezanno hyankka ko7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mahi, worzhito maatalla bettode fana ohida. Ichchin booriton lam77i moltto ekkii, salo bi7i galatii maaqqii, booritippa baxxi fa tamaaruntsis inggida; un mahi asuntsis inggida. ");
INSERT INTO oydl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ubbuntsi mu7i mizhida. Unttin mu7in attide taphpho lam77i leemate dentsida. ");
INSERT INTO oydl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Katsito muyde asuntsi maachuntsin na7untsin attin ichchin mukul maaqqane. ");
INSERT INTO oydl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ellisii Yesuusa tamaaruntsi gongge gelii faappa tiinii abbappa seko fintsi fiinggode fana kiittii faas asuntsana moyzodes suub attida. ");
INSERT INTO oydl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Asuntsana moyzii maaqqii faas woossodes fettii derella afa kezida. Sa7ita qammin E faas yeyga gam7ida. ");
INSERT INTO oydl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ye wode gonggize abballa sa7appa eerats kilo mitire hyanggizin tiino zalara gote denddii zuluntta gonggiza un7itsida. ");
INSERT INTO oydl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wontimaatsella Yesuusa abballa yedhdhitera fa tamaaruntsago yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E tamaaruntsi, E abballa yedhdhitera unttago yi7izanno bi7i zhashtida. Unttin, «Hyay meeshe» ga7i zhashtii uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yezin Yesuusa ellisii, «Akkon baaya! zhashtippete! Tana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Phexiroosa eego, «Laatstso, nena maaqqiko, taanii hyaatsitilla afa yedhdhii neego hyanggode fana tana kiitto» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuusa Phexiroosago, «hyankka yo7o» yagayda. Phexiroosan gonggizeppa wodhdhii hyaatsitilla afa yedhdhitera Yesuusago hyangge aykkida. ");
INSERT INTO oydl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yezin wolqqaama gote bi7i zhashtida. Hyaatsitan qoodhdhe aykkide wode «Laatstso, tana ashshoya» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesuusa ellisii fa kushito dakkii eza aykkii, «Naate, ammano faccidayo akkos so7e» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesuusaran Phexiroosara gongge gelide wode gotita si7i gayda. ");
INSERT INTO oydl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gonggite yeze E tamaaruntsi, «Ne turii Xooz Na7a» ga7i goynida. ");
INSERT INTO oydl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Un abba fiinggi Gensareexe gade yellida. ");
INSERT INTO oydl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yinna gadite yeze asuntsi Yesuusa eride wode fa kara gancce yeze gutute ubbanne kiita dakkida. Asuntsi hyargginttizuntsana ubba eego ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hyargginttizuntsi E afula gaxito xalaala bochchode fana woossida. Bochchide ubbuntsi faxida. ");
INSERT INTO oydl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yinnippa suuba, fettii fettii Farisaawuntsin higge asttamaaruntsi Yerusalaameppa Yesuusago yi7i, ");
INSERT INTO oydl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Ne tamaaruntsi akkos nu adunts wogito mentse? Un katstsa ma7adeppa tiino fa kushito meecinttoos» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuusa mahi, «Yin, yin woga gisho Xoozze kiita folizanno akkos ixxe? ");
INSERT INTO oydl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akkos gayko, Xoozii, ‹Ne adayan ne intto bonchcho. E fa adaya woy fa intto cazhize hyayqo gayka?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yezin yin, fettii asi fa adaya woy fa intto maaddodebaz yezin, ‹Yin taappa denggize maadito Xoozzes zharshida gayko, ");
INSERT INTO oydl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Fa adaya woy intto bonchchodes beezoos› yagaane. Yezin yin, yin woga folodes Xoozze qaala mentsane. ");
INSERT INTO oydl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yin, cubbuntso, Isayaasa yin baz likke ohida, ");
INSERT INTO oydl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«‹Hyantsi asuntsi tana fa doontte bonchchane, Yezin un wozuntta taappa hyaako yene. ");
INSERT INTO oydl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Asuntsi tana cer goynane; un asi medhdhide woga Xoozze higge aazizi tamaarssane› gayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuusa gaama asuntsana faago xeegii, «Si7ote! Qoppote! ");
INSERT INTO oydl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asi tunize baz doonara gelizebaz baayzin doonappa kezze baz» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yinnippa suuba, Yesuusa tamaaruntsi eego yi7i, «Farisaawuntsi ne gaydanno si7i dhubunttidanno erane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yezin Yesuusa unttis mahi, «Salo yeze ta aday tukkikaayze minxa ubba shodinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Unbaz ashshii ashshote; un qooqe kaalisize qooquntsana. Qooqe qooqe kaalitsiko, lam77untsin gaga qitane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phexiroosa mahi, «Yinna aazize bilitsito nuus ohoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuusa unttago, «Yinttisin hyanno yellodes gelikaane? ");
INSERT INTO oydl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Doonara gelidebaz ubba saza gelii bale kezizanno erosite? ");
INSERT INTO oydl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yezin doonara kezze baz wozinappa kezane. Asi tunize baz yentsesana. ");
INSERT INTO oydl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Unttin as wozina giddappa kezize iita qofa, wodhe, olale, gome woy7e, kayzo, worddo markkidhe, cashshi. ");
INSERT INTO oydl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yentsesana aazize bazita asi tunizanep attin meeccinttikaayze kushera muuzanna tunizoos» gayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yinnippa suuba, Yesuusa yeygappa kezii Xiroosan Sidoona katama qitida. ");
INSERT INTO oydl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Fettii Kanaane sa7a maachita Yesuusago yi7i, fa qaaltto dhoqi yiizii, «Laatstso, Dawute na7ayo, taas yiqsinttoya; ta naato tuna ayyaana aykkii iita waytsane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yezin Yesuusa fettii qaala mahikaaya si7i gayda. Yesuusa tamaaruntsi eego yi7i, «Hyanna maachita nu suubito kaallii wuyssane. Yinnii gisho, ne izo moyzoya» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuusa mahi, «Taanii wudeppa dhabide duruntsana Isra7eele keetstsappa dhabide asunts xalaalas kiitinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yezin iza, E tiintte bunqqunttii, «Laatstso, tana maaddoya?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E mahi, «Na7unts katstsa ekkii kanuntsis olzanna lo77o baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maachitan, «Laatstso, yinna turo, yezin melle atto yezin kanuntsi fa laatstsuntsi muuzin, leematippa wodhdhize gufa muune» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesuusa mahi, «Hyanna maachite, ne ammantta damma; ne koydanni fana nees hyano» yagayda. I naata iira faxii attida. ");
INSERT INTO oydl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuusa yinnippa denddii Galila Abba kale hyanggida. Fettii derella afa kezii, ize bettida. ");
INSERT INTO oydl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Gaama asuntsi, wobbuntsana, qooquntsana, kuunniduntsana, doona muumuntsana, melle gaama hyargganchchuntsana ekkii, eego ki7i E tiintte gaddida. Yesuusa unttana fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yinnii gisho, muumuntsi ohinttizin, guundduntsi luulezin, wobbuntsi yedhdhizin, qooquntsi be7izin asuntsi bi7i gaama qoppida, Isra7eele Xoozza galatida. ");
INSERT INTO oydl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuusa fa tamaaruntsana faago xeegii, «Hyantsi gaama asuntsi taara hyaydzdzii qamma gam7ide gishon unttis hyatte muuze baz baayze gisho taanii unttis yiqsinttane. Un oge labbii gol7aame fana akko muuzikaayzara unttana hyarii dakkodes koyoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","E tamaaruntsi mahi, «Nuunii hyanna akko baayze sa7a hyannii fana yeze asuntsis maaqqade katstsa anappa denggode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuusa unttago, «Yinttis wantsi boora yeze?» yaga7i oocida. Un mahi, «laappun booriton yishsha eerats molo yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesuusa asuntsana sa7alla bettote fana kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yinnippa suuba, yinna laappun booriton moluntsana ekkii Xooz galatida. Baxxi fa tamaaruntsis inggida. E tamaaruntsi asuntsis gishida. ");
INSERT INTO oydl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asuntsin ubba mu7i mizhida. Unttin, mu7in attide gufa laappun leemate kumutsi dentsida. ");
INSERT INTO oydl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Muyde asuntsi maachan na7an faydinttikaayzin dhiiratsi xalaala oyddii mukul. ");
INSERT INTO oydl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuusa asuntsana dakkideppa suuba gongge gelii Magedoona sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisaawuntsin Saduqaawuntsi Yesuusago yi7ida. Eza fattanodes koyi, fana saloppa malla beezo ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yezin E unttago, «Sa7a ugurize wode ‹Salo zoqqide gisho wontta awoda› yagaane. ");
INSERT INTO oydl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wonttize wode, ‹Salo zoqqii dhonidhide gisho ira bukkoda› yagaane. Yeezin yin salo malla bi7i erane, Yezin wode malla erodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iitan ammaninttoose yeletuntsi malla koyane. Yezin unttis Yoonasa mallappa melle malla ingginttoos» yagayda. Yinnippa suuba, unttana ize ashshii melle bessa qitida. ");
INSERT INTO oydl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Un abbap gode fintsa fiinggide wode daabbo ekkii yo7odanno botida. ");
INSERT INTO oydl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuusa unttago, «Farisaawuntsappan Saduqaawuntsi irshshoppa naaginttote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Unttin fa gidda, «E yinno gaydanna nu daabbo ekkii yi7ikaayze gisho maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesuusa un qoftto erii, «Yin, ammano faccezuntso! Daabbo ekkanxi yi7ide gisho wol gidda akkos ohintte? ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hyatten yin tiirostte? Ichchin mukul asuntsi ichchin beshe boora gishidannon un mu7i mizhin yin wantsi leemate kumutsi dentsezako botidate? ");
INSERT INTO oydl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yinnii gaaran, laappun boora oyddii mukul asuntsis gishidanno un mu7i mizhin, yin wantsi leemate kumutsi dentsezako tiirostte? ");
INSERT INTO oydl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yikke, taanii Farisaawuntsin Saduqaawuntsi irshshoppa naaginttote ga7i ohizanna daabbo baz maaqqoosanno tiirostte?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yeezin, E tamaaruntsi Yesuusa ohize buka dentsodes olinttize irshshobaz maaqqikaayzin Farisaawuntsin Saduqaawuntsi timirtteppa naaginttode fana maaqqidanno tiirida. ");
INSERT INTO oydl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuusa Qisaariya Filphoosa sa7a yellide wode fa tamaaruntsago, «Asuntsi, As Na7aya oona ga7e?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Un, «Fete fete Xammaqize Wahannisa, melluntsi Eeliyaasa mahi hyankkuntsi Ermmiyasa woy nabuntsappa feta gaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesuusa mahi, «Yeezin, yin tana oona ga7ete?» ga7i unttana oocida. ");
INSERT INTO oydl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoon Phexiroosa mahi, «Neenii Kiristtoosa, de7o Xoozze na7a» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuusa Phexiroosago, «Yoona na7a Simoona, ne anjjinttidaya! Hyanno nees qonccizide salo yeze ta adayap attin asi baaya. ");
INSERT INTO oydl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta nees ohine Phexiroosa, ne lalla! Taanii hyay lallizella afa ta woosa keetstsi keexxoda. Gaaname wolqqan izo gamoos. ");
INSERT INTO oydl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Salo ka7itumo qulfe ta nees inggoda. Sa7a ne accidebaz ubba salo Xoozze kale acinttidebaz maaqqada. Sa7a ne billide baz ubba salo Xoozze kale bilinttidebaz maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yinnippa suuba, E, Kiristtoosa maaqqidanno oodesin ohaame fana fa tamaaruntsis mintsii kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Yinna woditippa dentsii Yesuusa fa tamaaruntsis, «Taanii Yerusalaame hyanggodes beezane. Yeyga worzha cimuntsi, kahinunts hyalaquntsin higge asttamaarunts kushe madha ekkodes beezane. Un tana wodhoda, Yezin taanii hyaydzintsa qamma hyayqoppa denddoda» yaga7i qonccizida. ");
INSERT INTO oydl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phexiroosa Yesuusa gaxa kessii, «Laatstso, Yinnii fana yeze baz nena mulon yellippe!» yaga7i kaccida. ");
INSERT INTO oydl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuusa Phexiroosago suub maaqqii, «Hyay xalahizayo, taappa hyaako! Neenii as qofa qoppanep attin Xoozze qofa qoppoosse gisho taas dhube maaqqane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yinnippa suuba, Yesuusa fa tamaaruntsago, «Ooden tana kaallodes koyze baz maaqqiko fana kaddo, fa masqaltto tookkii tana kaallo. ");
INSERT INTO oydl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Fa shemppito ashshodes koyze ubbuntsi dhabsoda. Yezin fa shemppito ta gisho ga7i aatsii inggize ashshoda. ");
INSERT INTO oydl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asi alame kumutsi fa baz mahi, fa shemppito dhabsiko eza akko maadde? Woy asi fa shemppito wozodes akki inggodes dandda7e? ");
INSERT INTO oydl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","As na7a fa aday bonchchora fa kiitanchchuntsara yo7oda. Ye wode fettii fettii atstses E oochchiti fana inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta turo ohine; as Na7a fa ka7itumo bonchchora maaqqii yo7odera be7ade wontsis hyanne eqqide asuntsappa hyayqqaamuntsi yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Izippun qammappa suuba Yesuusa, Phexiroosa, Yayqooban E isha Wahannisa faara ekkii unttana xalaala derella afa kezida. ");
INSERT INTO oydl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ize un tiintte Yesuusa bishshita laaminttida; E sinttan awa fana focida. E afulttan loytsii booxxida. ");
INSERT INTO oydl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yikke, Musen Eliyaasan eera ohinttizin bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phexiroosa Yesuusago, «Laatstso Nuunii hyanne dhuga yi7ida. Ne koyko feta nees, feta Muses, feta Eliyaasas hyanne hyaydzdzii gaabba gaabboda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Phexiroosa yinno hyaga ohizin bootsi focide dhonne unttana goozida. Dhonttii giddara, «Tana ufayssize, ta kadhize na7ay hyaya, eza si7ote!» yagaaze qaala yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","E tamaaruntsi yinno si7ide wode tannii fa sinttira sa7alla gol7ida. ");
INSERT INTO oydl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yezin Yesuusa unttago shiiqii unttana bochchii, «Denddote, zhashtippete!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Un dhoqi ga7i be7ize wode Yesuusappa melle oonan biikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Un derizeppa wodhdhizin Yesuusa unttago, «As Na7a hyayqoppa denddode wontsis hyanno yin bi7idanno oodesin ohippete» ga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesuusa tamaaruntsi, «Yeezin, higge asttamaaruntsi Eeliyaasa Kiristtoosappa tiino yo7oda gaydanna akkoso?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesuusa mahi, «Yee! Eeliyaasa tiino yi7i ubba baz giigizoda. ");
INSERT INTO oydl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yezin ta yinttis turo ohine; Eeliyaasa tiino yi7ida. Unttin eella afa koydebaz oochchidap attin eza shaakkii erikaaya. Yinnii gaar As Na7a un kushe madha ekkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ye wode Yesuusa gaydanna Xammaqize Wahannisa baz maaqqidanno tiirida. ");
INSERT INTO oydl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Un derizeppa asuntsago maaqqize wode fettii asi Yesuusa tiintte bunqqunttii, ");
INSERT INTO oydl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Laatstso, aade ta na7aya maaroya; eza guuddii olize hyargge gaama wode un7itsi taman hyaatsan olane. ");
INSERT INTO oydl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne tamaaruntsago ki7ida, Yezin un fatstsodes dandda7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuusa mahi, «Yin, ammanoose wobbo yeletuntso ayde yellodes ta yinttara yessade? Ayde yellodes ta yinttana dandda7ode? Ane na7aya hyankka ekkii yo7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesuusa tuna ayyaaniza qoddin, tuna ayyaanize na7ayppa kezida; yinna saate na7ay faxida. ");
INSERT INTO oydl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yinnippa suuba, Yesuusa tamaaruntsi fa faas eego shiiqii, «Nu tuna ayyaaniza kessodes dandda7ikaayzanna akkoso?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E unttago, «Yinttis ammano eeride gishos. Ta yinttis turo ohine; gaashe aafe fana ammano yinttis yeziko ‹Hyay deriza hyannippa denddii gode aadho› gayko yinttis kiitinttoda. Yinttis dandda7inttoose baaya. ");
INSERT INTO oydl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yezin yinnii gaarize woosaran xoomarapp attin hyarii kezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesuusa tamaaruntsi Galila shiiqii yezin Yesuusa unttago hyanna folinttodes beezane, «As Na7ay as kushe aadhii ingginttoda. ");
INSERT INTO oydl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Un eza wodhoda, Yezin E hyaydzdzintsa qamma hyayqoppa denddoda» yagayda. E tamaaruntsi gaama azzanida. ");
INSERT INTO oydl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuusaran E tamaaruntsara Qifirnahoome katama yellide wode Xoozze keetstsa giira gachchizuntsi Phexiroosago yi7i, «Yin asttamaarize Xoozze keetstsi giira lam77i dinaare giiroso?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Phexiroosa mahi, «Giirane» yagayda. Phexiroosa keetstsa gelize wode Yesuusa tiinidhii, «Phexiroosa, nees akko aaze? Hyanna sa7a ka7itumo qaraxen giira ooppa ekke? Gade asappa woy as gade asappa?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phexiroosa «As gade asappa» ga7i mahida. Yesuusa mahi, «Yeezako gade asuntsi giira giroos ga7e. ");
INSERT INTO oydl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yezin un dhubunttaame fana abba hyanggi molo aykkize manxxako olo. Tiino ne aykkize molize doona bugii giiras maaqqize oyddii dinaare ne gishon ta gisho ekkii kanggi giiro» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ye wode Yesuusa tamaaruntsi yi7i, «Salo ka7itumo ubbappa aadhize oode?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesuusa fettii eeratsi na7a xeegii un gidda essi hyannii fana yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«Taanii yinttis turo ohine; yin laaminttanxiko eerats na7unts fana yi7anxiko salo ka7itumo mulon gelodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yikke, hyanna eerats na7unts gaar fana kawushize ooden salo ka7itumo ubbappa aadhiza maaqqoda. ");
INSERT INTO oydl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hyay fana na7a ta suntsite mokkize ooden tana mokkane. ");
INSERT INTO oydl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Yezin tana ammanze hyanna eeratsuntsappa feta nagara oochchode fana dhube maaqqize ooden damma gaachi woxa fa afurtte accii ciimmo abba olinttizako ees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Alame gidda asi nagara oochchode fana oochchizuntsi yeze gisho alamito bade. Yinnii fana yeze baz yi7ikaayzara attoos, yezin dhube E baggar ye7ize atstsa bade. ");
INSERT INTO oydl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Ne kushize woy ne tohize nena balitsiko neeppa gachchii olo. Ne lam77i kushera woy lam77i tohera medhina tama olinttodeppa kushe woy tohe duuxa maaqqii de7o yeziko nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mahi ne aafize nena balitsiko woocii kessii alla olo. Ne lam77i aafera gaanname tama olinttodeppa fettii aafera de7o yeziko nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ta yinttis ohine; salo yeze unttana naagize kiitanchchuntsi ubba wode salo yeze ta Aday tiino yeze gisho yin hyanna eeratsuntsappa fetaya leqqaame fana naaginttote. ");
INSERT INTO oydl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","As Na7a dhabiduntsana ashshodes yi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mahi Yesuusa, «Yinttis akko aaze? Fettii atstses xeet duro yezuntsappa fetay dhabiko uddufun tam uddufununtsana derella olii ashshii ye dhabidaya koyodes qitosaane? ");
INSERT INTO oydl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta turo ohine; E denggide wode uddufun tam uddufununtsappa aatsii dhabii benttide fettii durizera ufayttane. ");
INSERT INTO oydl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yinnii fana, salo yeze yin aday hyanna eeratsuntsappa fetay dhabode fana koyoos. ");
INSERT INTO oydl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Ne ishay nena qohiko ne xalaala eego hyanggi E baltto ees oho. E nena si7iko ne ishaya nees ishe maho. ");
INSERT INTO oydl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yezin E nena si7anxi ixxiko, lam77i woy hyaydzdzii asi markkara ohita latstsinttize gisho fettii woy lam77i asi ekkii eego hyanggo. ");
INSERT INTO oydl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","E unttana si7anxiko, woosa keetstsa oho. Woosa keetstsi gaazebaz si7anxiko ammanoose asi fana woy qaraxe gachchize asi fana eza faydo. ");
INSERT INTO oydl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Ta yinttis turo ohine; sa7alla yin accidebaz ubba salo accinttidebaz maaqqada. Sa7alla yin billide baz ubba salo bilinttidebaz maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Mahi ta yinttis ohine; sa7alla yinttappa lam77untsi fa woossize baz fettii wozina maaqqii Xooz woossize baz maaqqiko salo yeze ta aday yinttis oochchoda. ");
INSERT INTO oydl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tana kaallizuntsappa lam77i woy hyaydzdzii maaqqii shiiqize bessa taanii un gidda benttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ye wode Phexiroosa Yesuusago yi7i, «Laatstso, ta ishay tana qohiko wantsi tohe taanii atto ga7odes beeze? Laappun tohe yellodesine?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuusa mahi, «Ade, laappun tam tohe laappunap attin laappun tohe xalaala baaya. ");
INSERT INTO oydl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Yinnii gisho, salo ka7itumo faas oochchizuntsara fa miishita faccezakon gujunttezako be7ades qoppide kaatiza aazane. ");
INSERT INTO oydl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ye kaatize miishita faccezakon gujunttezako be7ize wode gaama gale yeze fettii atstsa eego ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yezin ye arize galtto ciggodes gamin eeran, E machchitira, E na7untsara eesi yeze baz ubba bayzintti galtta ciginttode fana laatstse kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yeezin arize fa laatstse tohitilla gol7i, ‹Aade eerats wode gam7o, ta galtto ubba ta ciggoda› yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","E laatstsize ees yiqsintti, dakkii ashshida; E aciton maarida. ");
INSERT INTO oydl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Yezin ye arize kezii hyanggi faas lagge mahiduntsappa fetaya faappa eerats miishe tal7idaya, ‹Neella afa yeze ta miishito taas ciggo› ga7i afurtto aykkida. ");
INSERT INTO oydl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«E laggize arize E tiintte bunqquntti, ‹Aade eerats wode gam7o taanii ta acito ubba ciggoda› yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Yezin ixxii ekkii kanggi fa laggize acito ciggode wontsis achi keetstsa geltsida. ");
INSERT INTO oydl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yinnii gisho, melle laggizes oochchizuntsi yinno bi7ide wode gaama zhilidhdhida, hyanggi fa laatstses E oochchide bazito ubba ohida. ");
INSERT INTO oydl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Yeezin laatstse ye ariza xeegizi, ‹Hyay iita arzayo, ne tana woosside gisho ta ne acito ubba nees maarida. ");
INSERT INTO oydl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yeezin, ta ne acito maaridanni fana ne ne lagge maaqqide arize acito maarodes nena beezoso?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yinnii gisho, laatstse gaama zhilidhdhi, E fa acito ubba ciggode wontsis un7inttode fana achi keetstsa olida. ");
INSERT INTO oydl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Yinnii fana, yin fete fete yin isha wozinappa maaranxiko salo yeze ta Aday yinttana yinnii fana oochchoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuusa yinno ohi hyaasidannippa suuba Galilappa denddii Yorddaanosa borkkappa seko zala yeze yihuda sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Gaama asuntsi eza kaallii hyanggin E fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisaawuntsi eza fattanodes koyi eego yi7i, «Fettii asi akko baggaran fa machchito dakkodes beeze?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuusa mahi, «Xoozii tiino dhiiratsin maachon mahi medhdhidanno yin nabbabikate? ");
INSERT INTO oydl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹Yinnii gisho, Fettii asi fa adayan fa intto ashshii fa machchitira fetto maaqqane, lam77untsin fettii asho maaqqane.› ");
INSERT INTO oydl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yinnii gisho, un fettii asho maaqqanep attin lam77i maaqqoos. Yikke, Xoozii accidanno asi shaakkippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisaawuntsi, «Yeezin, Muse fettii asi dafo warqqate inggi dakkode fana akkos kiittido?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesuusa Mahi, «Yin, yin machchuntsana dakkode fana Muse yinttis gaydanna, yin wozina mintsiti gishop attin tiinoppa yinnii gaar baaya. ");
INSERT INTO oydl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta yinttis ohine; fa machchito gome wayinttikaayzin dakkii melle ekkize ooden olalida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E tamaaruntsi eego, «Azinii bazin machchi bazi yinnii gaar maaqqiko ekken gelen attiko lo77o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuusa Mahi, «Yinnii gaarize timirtte Xoozii dandda7a inggiduntsis fattin as ubbuntsis baaya. ");
INSERT INTO oydl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yikke, yelinttitera ashttime maaqqii yelinttiduntsi yene, mahi asi qaaratiduntsi yene, mahi salo ka7itumo gisho ga7i fana ashttime mahiduntsi yene. Yinnii gisho, hyanno ekkodes dandda7ize ooden ekko» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yesuusa fa kushito eerats na7untsalla gaddii unttis woossode fana fettii fettii asuntsi na7untsana eego ki7ida. Yezin E tamaaruntsi asuntsana kaccida. ");
INSERT INTO oydl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yezin Yesuusa, «Salo ka7itumo hyantses fana yezuntsis maaqqide gisho eeratsi na7untsi taago ye7izanno kayppete; yo7o ga7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fa kushito unttalla gaddidannippa suuba yinna bestippa ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fettii qamma fettii atstse Yesuusago yi7i, «Asttamaarzayo, taanii medhina de7o denggodes akko lo77o baz oochcho?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesuusa eego, «Lo77o bazis ne tana akkos ooce? Fettii Xoozzap attin melle lo77o baaya. Yezin ne medhina de7o ekkodes koyiko kiitto naago» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Atstse mahi, «Aanno kiitta» yaga7i oocida. Yesuusa mahi, «Wodhippe, olalippe, kaystippe, worddo markkidhippe, ");
INSERT INTO oydl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ne adayan ne intto bonchcho, asi ubba ne fana kadho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ye shakanize, «Taanii hyanno ubba na7atitsappa dentsi naagida. Yeezin, melle taas faccide baz akko bazo?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuusa mahi, «Ne folo maaqqodes koyko hyanggi nees yeze baz bayzi dahuntsis inggo; ne salo duretitsi denggoda. Yeyzi maaqqii yi7i tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yezin ye shakanize gaama dure maaqqide gisho yinno si7ide wode azzanitera ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yinnippa suuba, Yesuusa fa tamaaruntsana, «Ta yinttis turo ohine; dure salo ka7itumo gelodanna gaama madha. ");
INSERT INTO oydl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dure asi Xoozze ka7itumo gelodannippa gimale marppe uruntsara aadhizanna laafa» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesuusa tamaaruntsi yinno si7i gaama qoppii, «Yeezin, oode attodes dandda7ode?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuusa unttana dakkii bi7i, «Hyanna asis dandda7inttoos, yezin Xoozis ubbanna dandda7inttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phexiroosa mahi, «Nuunii ubba baz ashshii nena kaallida. Yeezin, nu akko denggode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuusa unttago hyannii gaar yagayda: «Taanii yinttis turo ohine; As na7ay yo7ode kille alamite fa bonchcho araatalla bettize wode yin taphpho lam77untsi, tana kaalliduntsi, taphpho lam77i araatalla bettii taphpho lam77i Isra7eele bagguntsalla afa firddoda. ");
INSERT INTO oydl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta suntsiti gisho keetsito woy ishuntsana woy mishuntsana woy adaya woy intto woy na7untsana woy gadito ashshide ooden xeet kushe ekkoda. Mahi medhina de7o ekkoda. ");
INSERT INTO oydl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yezin gaamuntsi hyatte yestte tiino maaqqiduntsi suuba maaqqoda, mahi suuba maaqqiduntsi tiino maaqqoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Salo ka7itumo fa woyne gidda oocizuntsis kira inggodes wontta gooda kezide karttii adaya aazane. ");
INSERT INTO oydl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E oochchizuntsis hyayno hyayno fettii dinaare inggodes unttara giigii, unttana fa woyne gidda dakkida. ");
INSERT INTO oydl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Mahi wonttappa hyaydzdzii saate maaqqizin kezii oocha dhabin gabe bessa eqqide melle asuntsana denggida. ");
INSERT INTO oydl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","E unttago, ‹Yinttin ta woyne gidda hyanggi oochchote, taanii yinttis tana lo77ide miishe inggoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Unttin hyanggida. Mahi E izipun saateran uddufun saatera kezii yinnii fana oochchida. ");
INSERT INTO oydl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Taphpho fettii saate maaqqizin E kezize wode melluntsana yeyga eqqiduntsana denggi, ‹Yin oocha billii awara feesho hyanne akkos eqqii feezhidote? yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Un mahi, ‹Nuna kira oocize asi dhabide gisho› yagayda. «Ezin, ‹Yinttin ta woyne gidda hyanggi oochchote› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Saata ugurin, woyne aday oochchizunts hyalaqizego, ‹Oochchizuntsana xeegii lassa oocha geliduntsappa dentsii tiino geliduntsana yellodes un miishito inggo› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Taphpho fettii saater oocha aykkiduntsin yi7i, omma omma fettii fettii dinaare ekkida. ");
INSERT INTO oydl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tiino oocha aykkiduntsi yi7i, faas gaama ingginttoda ga7i qoppida. Yezin unttin omma omma fettii fettii dinaare ekkida. ");
INSERT INTO oydl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Fa miishito ekkii maaqqii karttii adaylla afa zuuzinggida. ");
INSERT INTO oydl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹Hyantses suubappa yi7i fettii saate xalaala oochchida. Yezin awara feesho labbii feezhide nuura un wayzi fetto maaqqe› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Woyne ataakilte aday oochchizuntsappa fetaygo, ‹Ta ishayo, ta nena qohikaaya; ne taara wulidhdhidanna fettii dinaares baane? ");
INSERT INTO oydl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne miishito ekkii ne kara qito. Ta ugure yi7idesin neenii fana inggodes koyane. ");
INSERT INTO oydl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taanii ta miishitira koydebaz oochchodes taas adetits wolqqa baane? Woy ta dalgga maaqqide gisho ne qinaatane?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«Yinnii gaaran hyatte de7ite suub maaqqiduntsi tiinoda, tiiniduntsi mahi suuboda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuusa Yerusalaame hyanggitera, taphpho lam77i tamaaruntsana dumma gaxa kessii unttago yagayda: ");
INSERT INTO oydl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Yikke, nuunii hyatte Yerusalaame hyanggella afa yene. Ize as na7a kahinunts hyalaquntsisin higge asttamaaruntsis aatsii ingginttoda. Unttin eella afa hyayqo firdda firddoda. ");
INSERT INTO oydl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eza Ayhude maaqqoosse worzhas aatsii inggoda. Un eza kawushshoda, garaafoda, yeyzi eza masqlalla afa suxxoda. Yezin E hyaydzintsa qamma hyayqoppa denddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ye wode zabdoosa machchita fa lam77i dhiiratsi na7untsara Yesuusago yi7i, E tiino bunqqunttii fettii baz eza woossida. ");
INSERT INTO oydl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuusa iigo, «Ne akko koye?» gayda. Iza mahi, «Ne ka7itumtte hyantsi ta lam77i na7untsi fetaya nees mizaqi zala fetaya nees workkita zala betto ga7oya!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yezin Yesuusa unttago mahi, «Yin akko woossizako eroos; taanii ushshades yeze madha xuu7uto ushshades dandda7ode?» yagayda. Unttin, «Yee dandda7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesuusa, «Turo taanii ushshades yeze xuu7uto yin ushshada. Yezin ta mizaqiten workkite bettoduntsana doorize tana baaya. Yinna besita ingginttize, ta aday inggodes giigizide asuntsis» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Attide taphphi E tamaaruntsi yinno si7ide wode lam77i ishuntsana kaccida. ");
INSERT INTO oydl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yezin Yesuusa unttana ubba xeegii hyannii gaar yagayda. «Ayhude maaqqoosse asuntsana ahizuntsii fa asuntsalla laatsidhizannon unttana kaalitsizuntsi mahi unttana adetitsi wolqqara ahizanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yezin yin gidda yinnii gaar maaqqippe. Yinttappa dhoqqodes koyze ooden yinttis aro maaqqe. ");
INSERT INTO oydl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yin gidda ubbappa dhoqqa maaqqodes koyze ooden yinttis aro maaqqodes beezane. ");
INSERT INTO oydl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yinnii fanan, As Na7a as maaddodesin gaama asuntsana wozodes fa shemppito inggodes yi7idap attin asara maaddinttodes yi7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yinnippa suuba, Yesuusa fa tamaaruntsara Iyaarkkoppa kezii hyanggizin, gaama asuntsi unttana kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oge gaxa bettide lam77i qooquntusi Yesuusa yeygara aadhizanno si7i, «Laatstso, Dawute na7ayo, nuna maaroya» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gaama asuntsi unttana, «Hyayzote» yaga7i kaccida. Yezin un, «Laatstso, Dawute na7ayo, nuna maaroya» ga7i gujjii uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesuusa eqqii, unttana xeegii, «Ta yinttis akki yissade fana koyete?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Unttin, «Laatstso, nu aafita be7ade gaar koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuusa unttis yiqsinttii, un aafto bochchida. Ellisii un aafita bi7ida; unttin eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesuusaran E tamaaruntsara Yerusalaame ukkii, Shamahe derizella yeze beetefaage gaaze gutute yellitera, Yesuusa fa tamaaruntsappa lam77untsana faappa tiino hyanggote ga7i kiittida: ");
INSERT INTO oydl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«Yinttappa tiino yeze gutute hyanggote. Yeyga fettii hyare achcha yezanno I na7itira yin denggoda. Unttana billii taago ekkii yo7ote. ");
INSERT INTO oydl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ooden yinttana oociko, ‹Laatstsii unttana koyane› yaga7ote. E unttana elle mahoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yinnan nabize, ");
INSERT INTO oydl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Xiyoone katamas, ‹Yikke, ne kaatize aada maaqqii, hyartillan hyariti na7itilla bettii, neego ye7ine› ga7ote» ga7i xaafinttidanna folinttode gaar yinna hyanida. ");
INSERT INTO oydl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","E tamaaruntsi hyanggi Yesuusa unttana kiittidanni fana oochchida. ");
INSERT INTO oydl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hyarton hyartti na7iton ki7i kattara fa ma7ito un bantte gaddida. Yesuusa ma7itilla afa bettida. ");
INSERT INTO oydl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gaama asunts fa ma7ito ogite yiixxida. Melluntsi tashe tarshii ogite olida. ");
INSERT INTO oydl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yesuusappa tiinora hyanggizuntsin eeppa suubara kaallizuntsi gaama asuntsi, «Hosaana! Dawute na7ay galatintto! Laatstse suntsite yi7ize anjjnttidaya! Bonchcho Ubbappa Dhoqqa Salo Xoozis maaqqe!» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuusa Yerusalaame katama gelide wode yinna katamite yeze asunts ubbuntsi, «Hyay oode?» yaga7i turtuurida. ");
INSERT INTO oydl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Asuntsi, «Hyay Galila yeze Naazirete katamappa yi7ide nabe Yesuusa» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuusa Xoozze keetstsa gelii, yeyga baayzuntsanan wonggizuntsana ubba bale bay7ida. Miishe laamizuntsana xarpheziton wolle bayzize oydito shirii olida. ");
INSERT INTO oydl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ezin unttago, «Xoozze qaaltte, ‹Ta keetsita Xooz woossize keetstsi ga7inttane› ga7intti xaafinttida. Yezin yin faanno aachinttize wom7o mahidate» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesuusa Xoozze keetstsa yessadera qooquntsin wobbuntsi eego yi7in unttana fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yezin kahinunts hyalaquntsin higge asttamaaruntsi Yesuusa oochchide gaama qofize bazito bi7idannen zhooga na7untsi Xoozze keetstsa, «Dawute na7ay, galatintto» yaga7i uukkizanno si7i kaccida. ");
INSERT INTO oydl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Un Yesuusago, «Hyantses gaazanno ne si7ine?» yagayda. Yesuusa, «Yee si7ine, Xoozze qaaltte, ‹Zhooga na7unts doontten dhanggize na7unts doontte galata giigizane› ga7intti xaafinttidanno yin nabbabikate?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Unttana yeyga ashshii Bitaaniya katama hyanggi aqida. ");
INSERT INTO oydl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesuusa wontta gooda katama maaqqii yi7itera naydhdhida. ");
INSERT INTO oydl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oge gaxa fettii belese minxa bi7i iigo hyanggida. Yezin hyayep attin melle akkon denggikaaya. Yinnii gisho, izo, «Yikkeppa lam7intsa aafe aafippe!» yagayda. Yinna belese minxita ellisii melii attida. ");
INSERT INTO oydl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","E tamaaruntsi yinno bi7i, «Hyanna belesita wayzi ellisii melido?» yaga7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuusa mahi, «Taanii yinttis turo ohine; yinttis ammano yeziko, mahi yin sidhanxiko belesitilla taanii oochchidanni fana xalaala oochchoos, yezin ‹Hyay deriza shodintti abba wodhdho› yagayko hyanoda. ");
INSERT INTO oydl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ammanii yin woossize baz akkon maaqqiko yin ekkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuusa Xoozze keetstsa gelii tamaarssodera, kahinunts hyalaquntsin Ayhude cimuntsi eego yi7i, «Ne hyanno oochchode fana nees akko adetits wolqqa yeze? Nees hyanno adetits wolqqito inggide oode?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuusa unttago, «Taanii yinttana fettii baz oocane; yin taas yinno mahiko, taanin akko adetits wolqqara oochchizako yinttis ohoda. ");
INSERT INTO oydl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wahannisa xinqqate anappa? Xoozappane asappa?» yagayda. Un fa gidda zorintti, «Nu, ‹Xoozappa› gayko, E nuna, ‹Yeezin akkos ammananxido?› yaga7oda. ");
INSERT INTO oydl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nu, ‹Asappa› gayko, asi ubbuntsi Wahannisa nabe mahi be7ize gisho nu asuntsana zhashitane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yinnii gisho, «Nu eroos» yaga7i mahida. Ezin, «Yikke, taanin hyanno akko adetits wolqqara oochchizako yinttis ohoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«Yesuusa mahi hyannii gaar yagayda: lam77i dhiiratsi na7untsi yeze fettii atstse yene. Ye atstse fettii na7aygo hyanggi, ‹Ta na7ayo, hyayno woyne gidda hyanggi oochcho› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na7ay mahi, ‹Atto hyanggoos› yagayda. Yezin suubappa fa wozintte qoppii oochchodes hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aday fa hyankkay na7aygo hyanggi, fa tiino na7aygo gaydanni fana kiittida. Ezin, ‹Ye7e, ta adayo› yagayda. Yezin hyanggikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hyantsi lam77i na7untsappa fa adays kiitinttide aayo?» yagayda. Unttin, «Tiinoya» yagayda. Yesuusa unttago, «Ta yinttis turo ohine; qaraxe gachchizuntsin olalizuntsi yinttappa tiinii Xoozze ka7itumtto geloda. ");
INSERT INTO oydl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Xammaqize Wahannisa luule oge tamaarssitera yi7in E gaazanno ammanikaaya. Yezin qaraxe gachchizuntsin olalizuntsi ammanida. Yin melle atto yezin, unttana bi7i yin nagarttippa maaqqii ammanikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mahi Yesuusa hyannii gaar yagayda; «Melle aazize si7ote, woyne tukkide fettii atstse yene. Ye woynize kantto wututsi gasida. Woyne cicize ollan bookkida. Woyniza naagodes shakkon shakkida. Yinnippa suuba, gadito kotstse inggi melle sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Woyne aafto maxize agina yellin fana yellize baggito ekkii ko7ode gaar fa aruntsana unttago dakkida. ");
INSERT INTO oydl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kotstse inggide aday E aruntsana aykkii fetaya hyadhdhida, hyankkaya wodhida mahi attiduntsana shuchchara dhogida. ");
INSERT INTO oydl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Woyne atakiltti aday tiinuntsappa aadhize melle aruntsana kiittida. Kotstse ekkiduntsi unttana hyankkuntsalla afa oochchidanni gaar oochchida. ");
INSERT INTO oydl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wurssutsite E, ‹Ta na7aya un bonchchoda!› yaga7i fa na7aya unttago kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Yezin gaditii aday na7aya bi7i wol gidda ‹Gadito laattode hyaya, eza wodhii gadito nu ekkoda!› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na7aya aykkii woyne giditippa gaxa kessii wodhida. ");
INSERT INTO oydl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«Yikke, woyne atakiltti laatstse ye7ize wode ye kotstse ekkide aduntsana wayssade?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Un mahi, «E yentsi iita asuntsana iita wodhe wodhii, woynize aafize wode eza yellize baggito wodera wodera inggize melle asis kotstse inggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuusa mahi unttago, Xoozze qaaltte, Keexxizuntsi borii ixxide shuchchize, mayzenes omma maaqqane, ubbappa aadhize shuchchi maaqqane. Yinno laatstsii oochchidebaz; nu aaftis gaama qofize baz ga7intti xaafinttidanno nabbabikate? ");
INSERT INTO oydl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Yinnii gisho, taanii yinttis ohine; Xoozze ka7itumo yinttappa ekkinttii lo77o aafe aafize asuntsis ingginttoda.  ");
INSERT INTO oydl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hyay shuchchizella afa gol7ize ubba meqqoda. Mahi hyay shuchchize eella afa wodhdhize atstsen gaacinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kahinunts hyalaquntsin Farisaawuntsi Yesuusa ohide aazizito si7ide wode fana ohidanno erida. ");
INSERT INTO oydl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Un Yesuusa aykkodes koyda, yezin asuntsi Yesuusa nabe mahi be7ize gisho asuntsis zhashtida. ");
INSERT INTO oydl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuusa asuntsis mahi hyannii gaar yaga7i aazize ohida. ");
INSERT INTO oydl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Xoozze ka7itumo fa na7ays zhagana giigizide kaati aazane. ");
INSERT INTO oydl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ye kaatize zhagana yo7ode fana ohi gaddide asuntsana xeegodes fa aruntsana kiittida. Yezin asuntsi yo7odes koykaaya. ");
INSERT INTO oydl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mahi melle aruntsana xeegii, xeeginttide asuntsago hyanggi, ‹Taanii ta sangguntsanan modhdhuntsana shukkida; ubbanna giigida. Ta zhagana diggisago hyankka yo7ote ga7ote› ga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yezin xeeginttiduntsi xeegito ixxii, fa oocha oocha qitida. Fetay fa wootas, hyankkay fa zal77e qitida. ");
INSERT INTO oydl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mellunts mahi kaat aruntsana aykkii, iissii hyadhdhii wodhida. ");
INSERT INTO oydl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Kaatize gaama zhilidhdhii, fa wottaddaruntsana dakkii shemppo wodhiduntsana wodhizida, un katamito eetsida. ");
INSERT INTO oydl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yinnippa suuba, fa aruntsago, ‹Zhagantta giigida, yezin xeeginttiduntsi zhaganas beezze asi baaya. ");
INSERT INTO oydl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yinnii gisho, dalgga oge hyanggi, denggide asi ubba zhagana yo7ode fana xeegote› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aruntsin ogella hyanggi faas denggide asi ubba lo77untsanan iituntsana ki7i zhagana daase geltsii kuntsida. ");
INSERT INTO oydl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Yezin kaatize katstsa ma7ades bettide asuntsana be7ades gelide wode zhagana afula ma77ikaayze fettii asi denggida. ");
INSERT INTO oydl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eego, ‹Naate, ne zhagana afula ma77ikaayzara wayzi hyanne gelido?› yagayda. Yezin atstse si7i gayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Kaatize fa aruntsago, ‹Hyay atstse kushiton tohito accii, bale dhuma kessii olote. Ize yeefon achchi garccingge maaqqoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«Yinnii fanan, Xoozze ka7itumos xeeginttiduntsi gaama yezin doorinttiduntsi eeratsi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yinnippa suuba, Farisaawuntsi hyanggi, Yesuusa wayzi ohera aykkod yezako zorinttida. ");
INSERT INTO oydl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Fa tamaaruntsanan kaat Heroodisa bagguntsappa feta feta kiittida. Unttin, «Asttamaarzayo, ne turo ohizanno nu erane. Ne asappa as shagoos, asi woyganddes ga7i akkon oochchoos, Xoozze ogito turetitsara tamaarssane. ");
INSERT INTO oydl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ane nuus oho, nuunii Roome kaatis giira giirodes beezanen beezosa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yezin Yesuusa un iita qoftto erii, «Hyantsi cubbuntso, tana akkos fattanete? ");
INSERT INTO oydl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Giira giirize miishe tana beezote» yagayda. Unttin ees dinaare ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","E, «Hyays suntsitan bishshita oodeso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Unttin, «Roome kaatays» yagayda. Yeezako Yesuusa unttago, «Yikke, kaatis beezanno kaatis, Xoozis beezanno Xoozis inggote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Unttin yinno si7ide wode gaama qoppii E kaleppa ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yinna qammite hyayqoppa denddo baaya yagaaze Saduqaawuntsi Yesuusago yi7i, yaga7i eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Asttamaarzayo, ‹Muse, fettii asi na7a yelikaayzara hyayqiko, ye hyayqide ishay E machchito ekkii, fa ishays na7a yelo› yaga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nu erize laappun ishuntsi yene. Anggisse machcho ekkii na7a yelikaayzara hyayqida. E machchito E geeze mahida. ");
INSERT INTO oydl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yinnii fana, ye lam7antsen, hyaydzantsen, hyanggi laappununtsa yellodes. ");
INSERT INTO oydl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ubbappa suuba yinna maachita hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yeezin, laappununts ubbuntsi izo mahide gisho hyayqoppa denddize qamma, yinna maachita laappununtsappa aaye machcho maaqqade?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuusa mahi, «Yin Xoozze qaalan E wolqqito eroosse gisho balinttane. ");
INSERT INTO oydl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asuntsi hyayqoppa denddize wode salo yeze kiitanchchuntsi fana maaqqanep attin ekkosin geloos. ");
INSERT INTO oydl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mahi hyayqqide asuntsi hyayqoppa denddode baz Xoozii yinttis ohidanno nabbabikate? ");
INSERT INTO oydl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Xoozii, ‹Taanii Abrahama Xooz, Yisaaqa Xooz, Yayqooba Xooz› yagayda. Yinnii gisho, Xoozii faxa yezunts Xoozap attin hyayqqiduntsi Xooz baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gaama asunts yinno si7i, E timirttite gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuusa Saduqaawuntsis gawude baz dhabsidanno Farasawuntsi si7ide wode fettilla shiiqida. ");
INSERT INTO oydl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Un giddappa fettii higge asttamaarize Yesuusa faatana ooce oocida. ");
INSERT INTO oydl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Asttamaarzayo, higge ubbappa aadhize aayya?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuusa mahi, Ne Laatstsa, ne Xoozza, ne kumutsi wozinappa, ne kumutsi shemppoppa, ne kumutsi qofappa kadho. ");
INSERT INTO oydl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ubbappa aadhizen tiino kiita hyanno. ");
INSERT INTO oydl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lam7intsa ubbappa aadhize kiita, as ubba ne ommito ne kadhizanni fana kadho yagaazanno. ");
INSERT INTO oydl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Muse higgen nabunts timirtte ubba hyanna kiittilla afa katane yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisaawuntsi fettilla shiiqii yezin, Yesuusa unttana, ");
INSERT INTO oydl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kiristtoosa baz yin waaga7ete? E oode na7a?» yaga7i oocida. Un, «E Dawute na7a» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuusa unttago, «Yeezin, Dawute Geeshi Ayyaanara maaqqii wayzi Kiristtoosa, ‹Laatstso› ga7i xeege? Dawute ga7itera, ");
INSERT INTO oydl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Laatstsii Xoozii, ta Laatstsego, ne morkkuntsana ne tohita yedhdhize bessi mahode wontsis, hyanne taappa mizaqi zalar betto»gayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yikke, Dawute Kiristtoosa Laatstso ga7i xeegiko, wayzi Kiristtoosa Dawute na7a maaqqe? yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesuusas fettii qaala mahodes dandda7ide asi ooden baaya. Mahi yinna qammitippa dentsii melle ooce oocodes ooden dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yinnippa suuba, Yesuusa shiiqide asuntsisin fa tamaaruntsis hyannii gaar yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Higge asttamaaruntsin Farisaawuntsi Muse higge tamaarssodes adetits wolqqara yene. ");
INSERT INTO oydl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yinnii gisho, un yinttana kiittide ubba oochito naagote. Yezin un oochchizanni fana oochchippete. Akkos gayko, un ohizanni fana oochchoos. ");
INSERT INTO oydl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Un tookkodes dandda7inttoose toofo accii as toossane. Yezin faas melle atto yezin, ye toofiza asuntsi tookkize wode gil7a bertstsara bochchodes koyoos. ");
INSERT INTO oydl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Yezin un fa oochito ubba asi be7ade fana oochchane. Fa sintten kushite accize maxaafe xiqise yeze kiitaafe dalggizane, fa afultii macartton pharggizane. ");
INSERT INTO oydl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mokinttize bessa bonchcho bessin Ayhude woosa keetstsa gaama lo77o oyda kadhane. ");
INSERT INTO oydl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Asuntsi gabe unttana bonchchora saritsizannon ‹Asttamaarzayo› ga7i xeegizanno koyane. ");
INSERT INTO oydl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Yezin yin asttamaarize fetto xalaala maaqqide gishon yin ubba ishuntsana maaqqide gisho ‹Asttamaare› ga7intti xeeginttippete. ");
INSERT INTO oydl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Yinttis salo fettii aday xalaala yeze gisho hyanne sa7alla ooden ‹Adayo› ga7i xeeginttippete. ");
INSERT INTO oydl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yinttis fettii Laatstsii Kiristtoosa xalaala yeze gisho ‹Laatstso› ga7intti xeeginttippete. ");
INSERT INTO oydl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yin gidda anggistize yinttis aro maaqqe. ");
INSERT INTO oydl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Fana dhoqi yiize ooden toochoda; fana toochize ooden dhoqi gawuda. ");
INSERT INTO oydl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Yin, cubbuntso, higge asttamaaruntso Farsaawuntso, asunts tiino salo ka7itumo gorddizuntso yinttana bade. Yin, yin ommite geloos mahi melluntsanan geltsoos. ");
INSERT INTO oydl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Yin cubbuntso, higge asttamaaruntson, Farisaawuntso budanuntsi keetsito yin bonqite, asi bo7o ga7i woosa pharggizane. Yinnii gisho yinttana bade. Ubbappa aadhize firdda yinttana naagane. ");
INSERT INTO oydl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Yin, cubbuntso, higge asttamaaruntso Farsaawuntso, yin fettii asi ammantsodes abbaran sa7aran wutane. Yezin yin eza ammantside wode ye atstsa yinttappa aatsii Gaannames giigize gisho yinttana bade. ");
INSERT INTO oydl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ooden Xoozze keetstsara caaqqiko akkon baaya. Yezin Xoozze keetstsa yeze worqqara caaqqiko, yinna caaqita eza gomoda gaaze qooquntso, yinttis qooqii melluntsana kaalitsizuntso, yinttana bade. ");
INSERT INTO oydl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yin, eeyuntso, qooquntso, worqqa aadhanene? Worqqiza geeshize Xoozze keetsita aadhe? ");
INSERT INTO oydl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mahi ‹Ooden zharsho zharshize besite caaqqiko, akkon baaya. Yezin ooden E kattara yeze zharshite caaqqiko, yinna caaqita eza gomoda› yaga7i tamaarssane. ");
INSERT INTO oydl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yin, qooquntso, zharshita aadhanene? Zharshito geeshize besita aadhe? ");
INSERT INTO oydl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yinnii gisho, zharsho besite caaqqize atstse, yinna zharsho besiten eella afa yeze ubbanne caaqqane. ");
INSERT INTO oydl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Xoozze keetstsa caaqqize atstse, yinna Xoozze keetsiten ize yeze Xoozzella caaqqane. ");
INSERT INTO oydl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Salo caaqqize atstse Xoozze araatiten ye araatizella bettide Xoozzella caaqqane. ");
INSERT INTO oydl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Yin, cubbuntso, higge asttamaaruntson Farsaawuntso, yinttana bade. Yin kartsi gaallappa, nattirappan xalooteppa asraata kessane. Yezin higgite yeze aadhii koshshizuntsana ashshida. Yinnan luule firdda, maarotitsin ubba baza ammanintte. Melluntsanan ashshikaayzara hyantsesana yin oochchodes beezane. ");
INSERT INTO oydl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yinttis qooqii melle asi kaallitsizuntso, yin ushitippa wununo kessii gimale qoodhdhane. ");
INSERT INTO oydl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Yin, cubbuntso, higge asttamaaruntso Farsaawuntso, yinttana bade. Yin burccuqosin saanes katta zaltto geeshane. Yezin un ganccite bonqan qiiratitsi kumida. ");
INSERT INTO oydl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Naate qooqe Farisaawuzayo, burccuqosin saanes ganccito tiinii geesho. Yinnippa suuba, katta zalttan geeshi maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Yin, cubbntso, higge asttamaaruntson Farisaawuntso, yinttana bade. Bale zalara bootsi qalame tizhintti lo77i, ganccite meqatsin wooqidebaz kumide booza yin aazane. ");
INSERT INTO oydl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yinnii fana, katta zalara asis lo77o aazane. Yezin yin ganccite cubbon iitatitsi kumida. ");
INSERT INTO oydl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Yin, cubbuntso, higge asttamaaruntson Farisaawuntso, yinttana bade. Yin nabuntsis booza keexxane, mahi xilluntsi boozan loytsane. ");
INSERT INTO oydl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mahi yin, ‹Nuunii zaga nu adunts wode yeze baz maaqqizako, unttara wolla nabunts suutsito gussaama yeshsha› yagaane. ");
INSERT INTO oydl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yinnii gisho, yin nabuntsana wodhide as na7untsana maaqqidanno yin yin ommite markkidhane. ");
INSERT INTO oydl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yikke, yin aduntsi aykkidanno yin folote. ");
INSERT INTO oydl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Hyantsi shooshuntso, goppi na7untso, yin Gaanname firddappa wayzi attode? ");
INSERT INTO oydl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yinnii gisho, ta ohizanno si7ote; taanii nabuntsana, cincca asuntsanan asttamaaruntsana yinttago kiittoda. Unttappa feta feta yin wodhodan masqalalla afa suxxoda. Bagguntsana Ayhude woosa keetstsa alanggara garafodan katamappa katama bay7oda. ");
INSERT INTO oydl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yinnii gisho, xillo Aabeela suutsappa dentsii, Xoozze keetstsappan zharsho bessappa gidite yin wodhide Barakiya na7a Zakkariyaasa wode yellodes hyayqqide xillo as ubba gisho yinttana yelloda. ");
INSERT INTO oydl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Taanii yinttis turo ohine; yinttin yin aduntsi oochchide balttis hyanna firddita ubba hyantsi yeletuntsalla yelloda. ");
INSERT INTO oydl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yerusalaame, Yerusalaame, nabuntsana wodhizanne! Xoozii neego kiittiduntsana shuchchara dhogizanne! Lukule fa na7untsalla afa qefera hyaphphizanni fana taanii ne asuntsana ta shuphite shiishodes wantsi tohe koydo! Yezin tana ne ixxida. ");
INSERT INTO oydl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yikke, yin Xoozze keetsita kaysi maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taanii yinttis ohine; ‹Laatstse suntsite ye7ize anjjinttidaya› yin ga7ode wontsis lam7intsa tana bo7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuusa Xoozze keetstsappa kezii qitizin, E tamaaruntsi eego yi7i, Xoozze keetsi gimbito beezida. ");
INSERT INTO oydl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesuusa unttago mahi, «Yee! Hyanno ubbanno be7inete? Taanii yinttis turo ohine; shuchchi shuchchalla afa keellinttide fana fettin wul7inttikaayzara attoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuusa Shamahe Derella afa bettezin, E tamaaruntsi fa xalaala eego yi7i, «Yinna ayde hyanod yezako nuus oho. Mahi ne ye7itisin wode wurssutsitis malla akko? yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","«Yesuusa mahi, Yinttana ooden balitsaame fana naaginttote! ");
INSERT INTO oydl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Akkos gayko, gaama asuntsi ta suntsite, ‹Taanii Kiristtoosa, Xoozii as ashshodes kiittidaya› yagaytira yi7i gaama asi balitsoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yin olan ola wore si7odes yene. Yinnii gaarize baz hyanodes beezize gisho yirggippete. Yezin wurssutsita hyaga. ");
INSERT INTO oydl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Worzha worzhara, fettii ka7itumo melle ka7itumora olinttoda. Nayen sa7a en7e dumma dumma bessa maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yinna ubbanna yelo dha7es zooqe fana. ");
INSERT INTO oydl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«Ye wode asuntsi yinttana waayes aatsii inggoda, accodan wodhoda. Ta suntsiti gisho asi ubba yinttana ixxoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ye wode gaamuntsi ammano ashshoda. Fa gidda fete fetaya aatsii inggoda, fete fetaya ixxoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mahi gaama worddo nabuntsi denddii gaamuntsana balitsoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Iitatitsi gaanggize gisho gaama asuntsi siiqita toyoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yezin wurssutsi yellodes genccide atstse attoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","As ubbas markka maaqqade fana Xoozze ka7itumo Wonggele Sa7a ubba ohinttoda. Yinnippa suuba, wurssutsita yo7oda. ");
INSERT INTO oydl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Yinnii gisho, nabize Daanela ohide dhabsse tunatitsi geeshi bessa eqqidaya yin bo7oda. Qoppize Yinna waagizako nabbabize qoppo! ");
INSERT INTO oydl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yinnii wode Yihuda sa7a yezuntsi derego woxxo. ");
INSERT INTO oydl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Fooqella afa yeze atstse fa keetstsite yeze baz ekkodes keetstsa gelanxi woxxo. ");
INSERT INTO oydl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gade yeze fa ma7o ekkodes suub maaqqippe. ");
INSERT INTO oydl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ye wode wodatsi maachuntsin dhantsize maachuntsis gaama un7intte maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Barggo woy Sambbata yin woxxii dhabizanna maaqqaame fana Xooz woossote. ");
INSERT INTO oydl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Akkos gayko, sa7a medhinttidannippa hyayno yellodes hyanikaayze baz, mahi tiinosin mulo hyanoose madha hyanoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yinna qammiti faydito hyaatitsikaayzako as maaqqide ooden attoos. Yezin E fa dooride asunts gisho yinna qammiti faydito hyaatitsoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Ye wode ooden yinttana, ‹Yikke, Kiristtoosa hyanne› woy ‹Sekka yene› yagayko ammanippete. ");
INSERT INTO oydl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Akkos gayko, worddo Kiristtoosuntsin worddo nabuntsi denddoda. Unttis dandda7inttiko, melle atto yezin Xoozis doorinttiduntsana balitsodes damma mallan gaama qofize baz oochchoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Qoppote, ta yinttis hyanno tiinii ohine. ");
INSERT INTO oydl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Yinnii gisho, asunts yinttago, ‹Yikke, Kiristtoosa akko baayze ganas sa7a yene› gayko, ize hyanggippete. Woy yinttago, ‹Yikke, qol7a yene› gayko, unbaz ammanippete. ");
INSERT INTO oydl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Akkos gayko, zeelintsi salo zeelinggii, awa kessappa gelo yellodes benttizanni gaar, As Na7a ye7ita yinnii gaar maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","«Bawuta yeze bessa ankkuntsii shiiqoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ye wode yinna waaye qammitippa suuba, «Iira awa dhumoda, aginan fa foo7ito kayoda. Xoolintton saloppa wodhdhoda, mahi salo yeze wolqqa buqunttoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ye wode As Na7a ye7e malla salolla afa benttoda. Sa7a yeze asi ubba yeekkoda. Mahi As Na7ay, wolqqaran damma bonchchora salo dhonne giddara yeezin yin bo7oda. ");
INSERT INTO oydl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","E fa kiitanchchuntsana damma fuggize moyzera kiittoda. Un sa7a oyddii zala qitii, hyayga gaxappa seko gaxa yellodes yeze ees doornttiduntsana shiishoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Belese minxappa tamaarote. Iza aaci hyaye kessize wode torchche ukkidanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yinnii gaaran, yin hyanno ubba be7ize wode furtsa ukkidanno erote. ");
INSERT INTO oydl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Taanii yinttis turo ohine; hyanna ubbanna folinttode wontsis, hyanna yeletunts aadhaama. ");
INSERT INTO oydl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Salon sa7an aadhoda, yezin ta qaaltta aadhoos. ");
INSERT INTO oydl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Yinna qammiton yinna saatto salo yeze ta adayp attin melle salo kiitanchchuntsana maaqqin woy Na7aya maaqqin ooden eroos. ");
INSERT INTO oydl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","As Na7a ye7ita, Nohe wode hyanidanni gaar maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ye wode dhabsse hyaatsi yo7odeppa tiino Nohe markkabe gelide qamma yellodes, asuntsi mu7iten uzhite, ekkitera gelitera gam77ida. ");
INSERT INTO oydl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dhabsse hyaatsi yi7i, unttana ubba dhabsode wontsis qoppikaaya. As Na7a ye7itan yinnii fana yi7ada. ");
INSERT INTO oydl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«Ye wode lam77i asunts gade oochchoda. Unttappa fetay ekkinttoda, hyankkay attoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Lam77i maachuntsi wolla gaaccoda. Unttappa feta ekkinttoda hyankkanna attoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Yikke, yin Laatstse akko qamma yo7od yezako yin eroosse gisho miinggi naagote. ");
INSERT INTO oydl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yezin kayzo qammappa akko saate yo7ode yezako karttii aday erizako, fa keetsita bookinttaame fana barkki naagoda yeshsha. ");
INSERT INTO oydl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yinnii gaaran, As Na7ay yin qoppikaayze saate yo7ode gisho yin giigii yezote. ");
INSERT INTO oydl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Yeezin, fa kara asuntsis katstsa koshshize wode inggode fana E laatstsize dooride ammaninttizen wozinara yeze aro oode? ");
INSERT INTO oydl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","E fa laatstse kiittidanno oochchizin E laatstse yi7i denggide arize anjjnttida. ");
INSERT INTO oydl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taanii yinttis turo ohine; laatstsii ye ariza fa bazitilla ubba shuumoda. ");
INSERT INTO oydl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yezin ye arize iita maaqqiko, ‹Ta laatstse gam77i yo7oda› yaga7i fa wozintte qoppii, ");
INSERT INTO oydl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","fa lagge oochchizuntsana hyadhdhe aykkiko, matsinttizuntsara muyko uzhiko, ");
INSERT INTO oydl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ye arize laatstse E qoppikaayze qamman E eroosse saate, ");
INSERT INTO oydl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","yi7i eza gachchoda. E ixiton cubbuntsara mahoda. Yinna besite ees yeefon achchi garccingge maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ye wode salo ka7itumo fa kuraazito aykkii, machcho ko7odes qitide dhiiratsaya mokkodes kezide taphphi wuduruntsana aazane. ");
INSERT INTO oydl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Unttappa ichchinuntsi booza, mahi ichchinuntsi cincca. ");
INSERT INTO oydl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Boozuntsi kuraaze aykkida, yezin melle lambba aykkikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yezin cinccuntsi fa kuraazite melle guja lambba aykkida. ");
INSERT INTO oydl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Machchito ekkize gam77in, yentsi wuduruntsi gentto aykkin genttida. ");
INSERT INTO oydl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Giddii bilahe maaqqize wode ‹Yikke, machchito ekkizay yellida, eza mokkodes kezote› yagaaze damma dentsitsize kiita sinttida. ");
INSERT INTO oydl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Ye wode yentsi wuduruntsi ubbuntsi barkki, fa kuraazito giigizida. ");
INSERT INTO oydl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Boozuntsi cinccuntsago, ‹Nu xomppita hyayqqodes yiize gisho shagii yin lambbitippa nuus inggoyate› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«Yezin cinccuntsi unttago mahi, ‹Ade, nuusin yinttisin maaqqize lambba baaya. Yinnii gisho, yinttis hyanggi wonggi ekkote› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Booza wuduruntsi lambba wonggodes qitin, machchito ekkize yi7ida. Giiginttii bettide ichchin wuduruntsi eera wolla zhagana keetstsa muusis gelida; furtsiton gorddii ashshida. ");
INSERT INTO oydl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Suubappa hyankko wuduruntsi yi7i, ‹Laatstso, Laatstso, nuus bugoya› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Yezin E unttago mahi, ‹Taanii yinttis turo ohine; ta yinttana eroos!› ");
INSERT INTO oydl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Yikke, As Na7a yo7ode qammito woy saatto yin eroosse gisho barkki naagote. ");
INSERT INTO oydl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Salo ka7itumo fa oochchizuntsana xeegii faas yeze baz unttis inggi oge qitodes kezide atstsa aazane. ");
INSERT INTO oydl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Unttis ommara ommara un wolqqiti gaar fetays ichchin mekiliite, fetays lam77i mekiliite mahi fetays fettii mekiliite inggi fa oge qitida. ");
INSERT INTO oydl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ichchin mekiliite ekkide arize iira hyanggi zal77i, melle ichchin mekiliite tirfizida. ");
INSERT INTO oydl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yinnii gaar, mahi lam77i mekiliite ekkide arize melle lam77i tirfizida. ");
INSERT INTO oydl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yezin fettii mekiliite ekkiday hyanggi, olla bookkii, fa laatstsize birza moogida. ");
INSERT INTO oydl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Gaama wodeppa suuba yentsi arunts laatstse yi7i, fa miishito unttara bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ichchin mekiliite ekkide arize yi7i, melle ichchin mekiliite ki7i, ‹Ta Laatstso, ne taas ichchin mekiliite inggida. Yezin taanii melle ichchin mekiliite tirfizida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","E laatstse, ‹Zambbay! Ne lo77on ammantsize aro; ne eerats baza ammaninttida. Taanii nena gaama bazalla afa shuumoda; hyanne gelii ne laatstsera ufaytto› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Mahi lam77i mekiliite ekkiday yi7i, ‹Ta Laatstso, ne taas lam77i mekiliite inggida. Yezin taanii melle lam77i mekiliite tirfizida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","E laatstse, ‹Zambbay! Ne lo77on ammantsize aro; ne eerats baza ammaninttida. Taanii nena gaama bazalla afa shuumoda; hyanne gelii ne laatstsera ufaytto› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Mahi fettii mekiliite ekkiday yi7i, ‹Ta Laatstso, ne budikaayzara maxizan burggikaayzara shiishize iita asi maaqqidanno ta erane. ");
INSERT INTO oydl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yinnii gisho, zhashti ne mekiliitiza sa7a moogida. Ne mekiliitize hyaynishe› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«E laatstse mahi, ‹Hyay iita azal7a arzayo, taanii budikaayzara maxizannon burggikaayzara shiishize asi maaqqidanno erida. ");
INSERT INTO oydl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yeezin, ne ta mekiliitiza bankke gaddezako, taanii maaqqize wode ta mekiliitiza tirfera ekkodanno kayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Yinnii gisho, mekiliitiza eeppa ekkii, taphphi mekiliite yezes inggote. ");
INSERT INTO oydl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Akkos gayko, yeze ubbuntsis gujinttodan gaanggoda. Yezin baayzeppa melle atto yezin, ye ees yezayin ekkinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hyay maaddoose ariza bale dhuma kessii olote. Ize ees yeefone achchi garccingge maaqqada› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«As Na7a, kiitanchcho ubbuntsara, fa bonchchora ye7ize wode E fa bonchcho ka7itumo araatalla bettoda. ");
INSERT INTO oydl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa7a yeze asi ubba E tiino shiiqoda. Wude aday duruntsana deeshuntsappa shaakkizanni fana E ye asuntsana lam77i bessa shagoda. ");
INSERT INTO oydl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mahi duruntsana mizaqi zalara deeshuntsana workkita zalara essoda. ");
INSERT INTO oydl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Yinnippa suuba, kaatize mizaqi zalara yezuntsago hyannii fana yagawuda: ‹Ta aday anjjiduntso, hyankka yi7i sa7a medhinttize wode yinttis giigide ka7itumtto laattote. ");
INSERT INTO oydl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Akkos gayko, taanii naydhdhin muuzida, baridhdhin ushshida, zaqqo as maaqqii yi7in mokkida, ");
INSERT INTO oydl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kallidhin ma7isida, hyargginttin oocida, acinttin tana oocida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Yinnippa suuba, xilluntsi mahi, ‹Laatstso, ne naydhdhin ayde bi7i muuzido? Woy ne baridhdhin ayde bi7i ushshido? ");
INSERT INTO oydl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ne zaqqo maaqqii yi7in ayde bi7i mokkido? Woy ne kallidhin ayde mayzido? ");
INSERT INTO oydl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ne hyargginttin woy acinttin neego hyanggi nena ayde oocido?› yagawuda. ");
INSERT INTO oydl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kaatize mahi, ‹Taanii yinttis turo ohine; yin tana kaallize hyantsi ishuntsappa eerizes oochchidanna taas oochchida› yagawuda. ");
INSERT INTO oydl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ye wode workkita zalara yezuntsago, ‹Hyantsi baaddinttiduntso, ta kaleppa hyaakkote. Xalahesin E kiitanchchuntsis giigide medhina tama qitote. ");
INSERT INTO oydl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Akkos gayko, naydhdhin tana muuzikaaya; baridhdhin ushshikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Taanii zaqqo maaqqii yi7in tana mokkikaaya, kallidhin mayzikaaya, hyarggin acinttin tana oocikaaya yagawuda. ");
INSERT INTO oydl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Ye wode un, ‹Laatstso, ne naydhdhin woy baridhdhin woy zaqqo maaqqii hyanggin woy kallidhin woy hyarggin woy acinttin bi7i nena ayde maaddanxi ixxido?› yaga7i mahoda. ");
INSERT INTO oydl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Ye wode kaatize mahi unttago, ‹Taanii yinttis turo ohine; yin tana kaallize hyantsi ubbuntsappa eerizaya maaddanxi ixxiko, tana maaddanxi ixxida› gawuda. ");
INSERT INTO oydl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yinnii gisho, yentsi asuntsi medhina firddas mahi xilluntsi medhina de7oos qitoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuusa yinna timirttito ubba hyaaside wode fa tamaaruntsago, ");
INSERT INTO oydl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Lam77i qammappa suuba, Faasika ba7ale bonchchize qamma maaqqizanno yin erane. Yinna qammite As Na7ay masqalalla afa suxunttodes as kushe aadhii inggnttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ye wode kahinunts hyalaquntsin cimuntsi, Qayyaafa gaaze kahinunts hyalaqize keetstsa shiiqii, ");
INSERT INTO oydl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","asi erikaayzin Yesuusa aykkii, wodhodes zorinttida. ");
INSERT INTO oydl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yezin un, «Asuntsi gidda kachchi denddaame fana ga7i, Faasika bonchchize qamma maaqqippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuusa Bitaaniya katama qursuma hyarggide Simoona kara yene. ");
INSERT INTO oydl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesuusa leematella yezin fettii maachita albasxiroose bilqqaaxe kumutsi gaama al77o shitto ekkii yi7i Yesuusa ommite gussida. ");
INSERT INTO oydl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yezin Yesuusa tamaaruntsi yinno bi7i zhilidhdhi, «Hyanna shittita hyarii iitizanna akkoso? ");
INSERT INTO oydl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hyanna shittita al77o waagas bayzinttii, birtta dahuntsis ingginttodes dandda7inttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuusa un gaazanno erii, unttago, «Hyanna maachito akkos waytsete? Iza taas lo77o baz oochchida. ");
INSERT INTO oydl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dahuntsi ubba wode yinttara yessada. Yezin taanii yinttara ubba wode yezoos. ");
INSERT INTO oydl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iza hyanna shittito taalla afa gussidanna tana moogodes giigisades. ");
INSERT INTO oydl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Taanii yinttis turo ohine; sa7a ubba hyay Wonggelize sabbakinttize bessa aban, asuntsi izo ohode gaar iza oochchidanna ohinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ye wode taphpho lam77i Yesuusa tamaaruntsappa fetay, Yesqorootu sa7a Yihuda ga7inttize kahinunts hyalaquntsago, ");
INSERT INTO oydl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hyanggi, «Taanii yinttis Yesuusa aatsii inggiko, yin taas akko inggode?» yaga7i unttana oocida. Un zorintti hyasttam shuchchi bira santime inggida. ");
INSERT INTO oydl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Yinnippa suuba, Yihuda Yesuusa aatsii inggodes wottize wode koyane. ");
INSERT INTO oydl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Boora ba7ale bonchchize tiino qamma, Yesuusa tamaaruntsi eego yi7i, «Faasika bonchchize qamma ne ma7ade katstsa nu aba giigisade?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesuusa unttago, «katama yeze atstsego hyanggi, ‹Asttamaarize, taas wode yellide gisho ta tamaaruntsara Faasika bonchchize qamma ne kara aatstsoda gayda› yaga7ote» gayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","E tamaaruntsi Yesuusa fana kiittidanni fana oochchii, Faasika ba7ale qamma ma7ade katstsa giigizida. ");
INSERT INTO oydl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa7ita ugurize wode Yesuusa taphpho lam77i hawaaruntsara katstsa ma7ades bettida. ");
INSERT INTO oydl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Un muuzin, Yesuusa unttago, «Taanii yinttis turo ohine; yinttappa fettii atstse tana aatsii inggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Un gaama tannii, fete fete, «Laatstso, turo tana yessane?» ga7i eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuusa mahi, «Fa kushito taara wolla gabate dakkizay E tana aatsii inggoda. ");
INSERT INTO oydl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","As na7a, Xoozze qaaltte ees xaafinttidanni gaar hyayqqoda. Yezin As na7a aatsii inggize atstsa bade; ye atstse yelinttikaayzara attezako ees lo77o yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eza aatsii inggodes yeze Yihuda mahi, «Asttamaarzayo, ne gaaze tanane?» yagayda. Yesuusa mahi, «Ne gayde fana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Un muuzin, Yesuusa daabbo boora ekkii Xooz galatida. Ye booriza baxxi fa tamaaruntsis inggi, «Hya7ate, mo7ote, hyanna ta ashito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ushiton ekkii, Xooz galatida. Unttis inggi, «Ubbuntsi hyannippa uzhote. ");
INSERT INTO oydl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hyanna gaama asunts nagartta atto ga7inttode fana lanttize ta suutsito. Hyanna suutsita Xoozii yinttara gelize kille caaqito. ");
INSERT INTO oydl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yezin taanii yinttis ohine; taanii ta aday ka7itumo kille woyne ushi yinttara ushshade qamma yellodes mahi hyanno woyne ushito uzhoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Galata mazmure yexxideppa suuba shamahe dere hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ye wode Yesuusa unttago, «‹Xoozii yenggizaya guuddoda durntsin lalinttoda› ga7intti Xoozze qaaltte xaafinttidanni gaar hyayno qamma yin ubbuntsi tana ashshii lalinttoda. ");
INSERT INTO oydl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yezin taanii hyayqqoppa denddidannippa suuba yinttappa tiinii Galila qitoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phexiroosa mahi, «Un ubbanna nena ashshii kaddikon, taanii nena kaddoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuusa Phexiroosago, «Taanii nees turo ohine; hyayno qamma lukule oollodannippa tiino ne tana hyaydzdzii tohe kaddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phexiroosa mahi, «Taanii neera wolla hyayqqep attin nena mulon kaddoos» yagayda. Hyankko E tamaaruntsi ubba yinnii fana yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ye wode, Yesuusa fa tamaaruntsara Geetesemaane gaaze besite hyanggi, unttago, «Taanii gode hyanggi Xooz woossoda, yin hyanne bettote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Phexiroosan Zabdiyoosa na7untsana lam77untsana faara ekkii hyanggi gaama azzanora un7intte aykkida. ");
INSERT INTO oydl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mahi unttago, «Taanii hyayqos yeltsize un7a un7inttida. Hyanne gam7ote taara miinggi naagote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eerats tiino hyanggi sa7a bunqqunttii, «Ta Adayo, dandda7inttize baz maaqqiko hyanna waaye xuu7uto taappa hyaaso. Yezin ne qoftta hyanop attin ta qoftta hyanippe» yaga7i Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesuusa fa tamaaruntsago maaqqii yi7i un genttezin denggida. Phexiroosago, «Yin fettii saate yezakon taara miinggi naagodes dandda7osa? ");
INSERT INTO oydl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Faatana yin gelaame gaar barkki naagoten Xooz woossote. Ayyaana giiginttida, yezin asho labbitsi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesuusa mahi lam7intsa hyanggi, «Ta Adayo, taanii hyanna waaye xuu7uzeppa uzhikaayzara aadhodes dandda7inttoosa maaqqiko ne qoftta hyano» yaga7i Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mahin maaqqii yi7ize wode E tamaaruntsi aafto gentto goozin, woy7ezin denggida. ");
INSERT INTO oydl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mahi unttana ashshii hyanggi, tiino qaaltto mahi hyaydzdzintsa woossida. ");
INSERT INTO oydl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yinnippa suuba, fa tamaaruntsago yi7i, «Hyanno yellodes genttii shemppii yene? Yikke, As na7a, nagaranchchunts kushe aadhii ingginttize saate yellida. ");
INSERT INTO oydl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Denddii yedhdhote, tana aatsii inggize hyaynishe yellida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuusa hyaga ohizin, taphpho lam77i tamaaruntsappa fetay, Yihuda yellida. Kahinunts hyalaquntsin gade cimuntsi kiittide gaama asuntsi mashshan gufe aykkii eera wolla yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesuusa aatsii inggide Yihuda yentsi gaama asuntsago, «Taanii yeerizay yin koyze eza, eza aykkote» yaga7i malla inggi gaddida. ");
INSERT INTO oydl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iira Yesuusago shiiqii, «Asttamaarzayo, saro nees maaqqe» yaga7i eza yeerida. ");
INSERT INTO oydl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuusa eego, «Ta laggizayo, ne hyanne akkos yi7ido?» yagayda. Yinnippa suuba, shiiqii, Yesuusa kushera aykkida. ");
INSERT INTO oydl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesuusara yezuntsappa fetay fa mashito shoddii kahinunts hyalaqize ariza guuddii, E hyayto gachchii olida. ");
INSERT INTO oydl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yezin Yesuusa, «Ne mashito suuba shookite maho. Akkos gayko, mashsha shoddize ubba mashshara hyayqqoda. ");
INSERT INTO oydl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ta, ta Adaya woossizako taphpho lam77i mukulappa aadhize kiitanchchuntsana dakkodes dandda7oosa nees aazane? ");
INSERT INTO oydl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yeezin, Xoozze qaaltte yinnii gaar hyanodes beezane gaynttidanna wayzi folinttode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yinna saate, Yesuusa yentsi shiiqide gaama asuntsago, «Tana faanno mahi aykkodes mashshan gufe aykkii yi7idate? Taanii Xoozze keetstsa qamman awara tamaarsitera yinttara yeze wode tana aykkikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yezin hyanna ubba hyanidanna nabuntsi Xoozze qaaltte xaafidanna folinttode fana» yagayda. Ye wode E tamaaruntsi ubba eza ashshii lalinttida. ");
INSERT INTO oydl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesuusa aykkiduntsi kahinunts hyalaqa Qayyaafago eza kanggida. Ize higge asttamaaruntsin gade cimuntsi shiiqii yene. ");
INSERT INTO oydl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yezin Phexiroosa kahinunts hyalaqize woofa yellodes hyaakora eza kaallane. E folito be7ade wontsis gidda gelii naagizuntsara bettida. ");
INSERT INTO oydl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kahinunts hyalaquntsin shiiqide asunts ubba Yesuusa wodhodes eella afa worddo markka koyda. ");
INSERT INTO oydl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Gaamuntsi yi7i eella afa worddo markka markkidhida, yezin akkon denggikaaya. Suubappa lam77i asuntsi yi7i, ");
INSERT INTO oydl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Hyay atstse, ‹Taanii Xoozze keetsito lalii hyaydzdzii qammara mahi keexxodes ta dandda7ane› gayda» yaga7i un ohida. ");
INSERT INTO oydl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kahinunts hyalaqize denddii eqqii Yesuusago, «Hyantses nena mootize moottis ne mahizebaz baa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yezin Yesuusa si77i gayda. Mahi kahinunts hyalaqize, «Taanii nena de7o Xoozze suntsite aykkane; neenii Xoozze na7a Kiristtoosa maaqqiko nuus oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuusa Mahi, «Neenii ne ommite gayda. Yezin taanii yinttis ohine; yikkeppa suuba, As na7a wolqqaama Xoozze mizaqi zalar bettezin, mahi salo dhonnera ye7izin yin be7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ye wode kahinunts hyalaqize fa afultto feedhii, «Hyaya bo7ote Xooz cazhida! Nuna melle markka akkos koshshe? E hyatte cazhidanno yin si7ida. ");
INSERT INTO oydl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yin qoftta akko?» yagayda. Unttin, «Ees hyayqo beezane» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yeezin, un E sintte cuttii guuddida. Malluntsi eza baqqii, ");
INSERT INTO oydl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«Kiristtoosa! Nena guuddide oode? Ane nuus tinbbite oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phexiroosa bale bettezin, fettii arta eego yi7i, «Neenin Galila Yesuusara wolla yezaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yezin E un ubbuntsi tiino yinna artigo, «Ne gaazanna akko yezakon ta eroos» yaga7i kaddida. ");
INSERT INTO oydl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mahi hyanggi gase furtsa yellodera melle arta eza bi7i, ize yeze asuntsago, «Hyay atstse Naazirete Yesuusara yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Phexiroosa lam7intsa caaqqii, «Taanii ye atstsa eroos!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Eerats gam7odera, yeyga eqqide asuntsi Phexiroosago yi7i, «Neenii turo unttara wolla yezaya; ne ne ohite erinttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yinnippa suuba, Phexiroosa, «Taanii ye atstsa eroos!» yaga7i, fana baadden caaqo aykkida. Ye wode iira lukule oollida. ");
INSERT INTO oydl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yesuusa eego, «Ne lukule oollodeppa tiino tana hyaydzdzii tohe kaddoda» ga7idanno Phexiroosa tiirii, bale kezii iita yeefo yeekkida. ");
INSERT INTO oydl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wontta gooda kahinunts hyalaquntsin gade cimuntsi ubbuntsi Yesuusa wodhissades zorinttida. ");
INSERT INTO oydl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Un Yesuusa accii kanggi worzha ahize Philaaxoosas aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ye wode Yesuusa aytstside Yihuda, Philaaxoosa Yesuusalla afa firddidanno bi7i, azzanii, ye hyasttam biriza kahinunts hyalaquntsisin gade cimuntsis suub mahida. ");
INSERT INTO oydl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«Taanii xillo asi hyayqos aatsii inggi nagara oochchida» yagayda. Yezin un, «Yinna nu madha baaya ne madha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yihuda birto Xoozze keetstsa olii ashshii un kaleppa hyanggi, suxuntti hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kahinunts hyalaquntsi birto ekkii, «Hyanna birtta suuts bira maaqqide gisho nu Xoozze Keetstsa birara yeltsizanna woga baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yinnippa suuba, wolla zorintti, bete asi moogodes man gade woonggida. ");
INSERT INTO oydl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yinnii gisho, yinna gadita hyayno yellodes suutsi gade ga7intti xeeginttane. ");
INSERT INTO oydl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nabe Ermmiyasa, «Isra7eele asuntsi ees ciggodes gammatide hyasttam bira ekkida. ");
INSERT INTO oydl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Laatstse tana kiittidanni fana man gade wonggodes inggida» gaydanna ye wode folinttida. ");
INSERT INTO oydl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuusa gade ahize Philaaxoosa tiino shiiqin, Philaaxoosa eego, «Ne Ayhude kaato?» yaga7i oocida. Yesuusa mahi, «Ne gayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kahinunts hyalaquntsin gade cimuntsi eza mootize wode unttis akko mahen inggikaaya. ");
INSERT INTO oydl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ye wode Philaaxoosa Yesuusago, «Hyantses nena mootize mootto ubba si7oso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesuusa melle attoyzin, fettii qaalan mahanxin, gade ahizay gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gade ahize berite berite Faasika Ba7ale bonchchize qamma, asuntsi koyze fettii asi achchappa billize woga yene. ");
INSERT INTO oydl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ye wode fettii Barbbaana gaaze iitatitsara gaama erinttide achi keetstsa yene. ");
INSERT INTO oydl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Yinnii gisho, gaama asuntsi shiiqii yezin Philaaxoosa, «Taanii yinttis Barbbaana billonene, woy Yesuusa gaaze Kiristtoosa billone?» yaga7i asuntsana oocida. ");
INSERT INTO oydl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","E yinno gaydanna un qanaatii Yesuusa aatsii inggidanno erize gishos. ");
INSERT INTO oydl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Philaaxoosa firdda keetstsa bettezin, E machchita, «Taanii hyayno qamma abukkora E baz gaama waayinttitera aqide gisho ye xillo atstsella akko bazin oochchippe» yaga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yezin kahinunts hyalaquntsin gade cimuntsi Philaaxoosa Barbbaana billii, Yesuusa wodhode fana, asunts eza woossode fana, asuntsana zorii mahida. ");
INSERT INTO oydl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Philaaxoosa mahi unttago, «Taanii un lam77untsappa yinttis oona billode fana koyete?» yaga7i oocida. Un, «Barbbaana billode fana koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philaaxoosa, «Yeezin, Yesuusa gaaze Kiristtoosa wayssa?» yaga7i unttana oocida. Ubbuntsin, «Masqalalla eza suxxo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Philaaxoosa asuntsago, «Akkos? E akko iita baz oochchido?» yaga7i oocida. Yezin asuntsi tiinostippa aatsii, «Masqalalla suxxo» ga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kachchi dentsitseppa melle akko bazin oochchodes dandda7oosanno Philaaxoosa bi7i, hyaatsi ekkii, «Hyay xillo atstse suutsite ta baaya. Hyanno oochchize yinttana» yaga7i asunts tiino fa kushito mattida. ");
INSERT INTO oydl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Asunts ubbuntsi mahi, «E suutsiti gomtta nunan nu na7untsana yello» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yezin, Philaaxoosa Barbbaana unttis billii, Yesuusa alanggara garafii, masqalalla suxuntti hyayqqode fana unttis aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yinnippa suuba, Philaaxoosa wottaddaruntsi Yesuusa worzhito ahize kara ekkii kanggin, gaama wottaddaruntsi ubba E kale eqqida. ");
INSERT INTO oydl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","E afultto gaarii ekkii zoqo afula ma7isida. ");
INSERT INTO oydl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mahi anggats barneexa giigizii, E ommite gaddida. E mizaqi kushite shombboqo gufe aytsii, E tiintte bunqqunttii, «Ayhude kaatayo, saro nees maaqqe!» yaga7i, eella afa miicida. ");
INSERT INTO oydl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eella afa cuttida. Ye shombboqo gufiza ekkii, E ommite guuddida. ");
INSERT INTO oydl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Un eella afa miicidannippa suuba zoqo afulza eeppa gaarii ekkii, E afultto eza ma7isida. Masqalalla eza suxxodes ekkii kanggida. ");
INSERT INTO oydl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Un bale kezii, fettii Simoona gaaze Qereena gade asi denggi, Yesuusa masqala wolqqara toossida. ");
INSERT INTO oydl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golggotta gaaze bessi yellida. «Golggotta» gaazanna «Omma ota» ga7e. ");
INSERT INTO oydl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ize un cizhera worqqinttide woyne ushi uzho ga7i ees inggida. Yezin E yinno qamasi ekkii, uzhanxi ixxida. ");
INSERT INTO oydl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Un masqalalla eza suxxidannippa suuba E afultto shaakkii, ixa olii ekkida. ");
INSERT INTO oydl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yinnippa suuba, yeyga bettii eza naagida. ");
INSERT INTO oydl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mahi, «Hyay Ayhude kaati Yesuusa» yagaaze mooto xuufe E omma guro gaddida. ");
INSERT INTO oydl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesuusara ye wode lam77i faanuntsana fetaya eeppa mizaqi zalara, hyankkaya eeppa workkita zalara, masqalalla afa suxxida. ");
INSERT INTO oydl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ogera aadhize asuntsi Yesuusa fa ommito en7izitera cazhane, ");
INSERT INTO oydl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«Xoozze keetstsa lalii hyaydzdzii qamma gidda keexizayo, nena ashsho. Ne Xoozze Na7a maaqqiko, ane masqalappa wodhdho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yinnii fana, kahinunts hyalaquntsi, higge asttamaaruntsin gade cimuntsi wolla Yesuusalla afa miicida. Hyannii fana yagayda: ");
INSERT INTO oydl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Melluntsana ashshida, yezin fana ashshodes dandda7ikaaya. E Isra7eele kaati maaqqiko, ane masqalappa hyatte wodhdho, nuunin eza ammanoda. ");
INSERT INTO oydl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xoozalla E ammaninttane, Xoozii eza ashshodes koyko ane ashsho. Akkos gayko, E fana, ‹Taanii Xooz Na7a› gaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mahi melle attoyzin, eera masqalalla afa suxunttide faannuntsin yinnii gaar ga7i eella afa miicida. ");
INSERT INTO oydl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Izippun saateppa hyanggi, uddufun saate yellodes sa7ita ubba dhumida. ");
INSERT INTO oydl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Uddufun saate maaqqize wode Yesuusa, «Elohee, Elohee, laama sabaqitani?» ga7i damma uufo uukkida. «Elohee, Elohee, laama sabaqitani?» gaazanni bilitsita «Ta Xoozzayo, ta Xoozzayo, tana akkos ashshido?» ga7e. ");
INSERT INTO oydl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ize eqqide asuntsappa fete fete yinno si7i, «Hyay atstse Eeliyaasa xeegane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iira unttappa fetay woxxii hyanggi, ispponjje ekkii, caala woyne ushi kuntsida. Ye shombboqo gufize bertsite gaddii ushshodes E doonttigo shiishida. ");
INSERT INTO oydl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yezin hyankkuntsi, «Naago, Eeliyaasa eza ashshodes ye7odyezako ane be7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuusa lam7intsa damma uufo uukki, hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yinna saate Xoozze keetstsa suxunttide magaraajjita wookkappa yeekka yellodes lam77i kezii, feedhinttida. Sa7ita en7ida, lallan za77ida. ");
INSERT INTO oydl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Booza bugunttin geeshi asuntsappa gaamuntsi hyayqoppa denddida. ");
INSERT INTO oydl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Un boozappa kezii, Yesuusa hyayqoppa denddidannippa suuba geeshi katama qitida; ize un gaama asuntsis benttida. ");
INSERT INTO oydl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mato hyalaqizen eera Yesuusa naagize wottadaruntsi sa7a en7idanno ize hyanidanno bi7ide wode gaama zhashtii «Turo hyay Xoozze Na7a» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ize gaama maachuntsi, Galilappa dentsii Yesuusa maadditera kaalliduntsi hyaakora eqqii be7ine. ");
INSERT INTO oydl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Un gidda Magdela Mayrama, Yayqooban Yoosefa intta Mayraman Zabdiyoosa na7unts intta yene. ");
INSERT INTO oydl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa7a ugurize wode Yoosefa gaaze fettii dure atstse, Armmatiyasa katamappa yi7ida. E fa ommite Yesuusa kaallize asi. ");
INSERT INTO oydl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yoosefa Philaaxoosago hyanggi, Yesuusa ahito ekkodes woossida. Philaaxoosa ahito Yoosefas ingginttode fana kiittida. ");
INSERT INTO oydl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yesuusa ahito ekkii, kille afulara xaaxida. ");
INSERT INTO oydl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Faas mooginttodes shuchchappa woocide kille booza E ahito moogida. Mahi yinna booziti doontte damma shuchchi shirii gaddii ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdela Mayramiran hyankko Mayramira yinna booziti tiintte bettida. ");
INSERT INTO oydl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wontta Sambbata qamma, kahinunts hyalaquntsin Farasawuntsi Philaaxoosago yi7i, hyannii gaar yagayda: ");
INSERT INTO oydl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«Laatstso, hyay worddo ohize faxa yezara, ‹Taanii hyaydzdzii qammappa suuba hyayqoppa denddoda› yagaydanna nuus tiirinttida. ");
INSERT INTO oydl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Yinnii gisho, E moogunttide boozto hyaydzdzii qamma yellodes, mintsii naagode fana kiitto. Yinna yi7anxiko, E tamaaruntsi hyanggi E ahito kaysti dhabsi, ‹Hyayqoppa denddida› yaga7i asuntsis ohiko lam7intsa worddita tiinostippa ubba hyankka iitoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philaaxoosa unttago, «Yinttis naagizuntsi yene; hyanggi yinttis dandda7inttide fana naagizote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yinnii gisho, un hyanggi booztta bochinttaame fana shuchchizella mahitame gaddii wottadaruntsara naagizida. ");
INSERT INTO oydl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambbata aadhin wogga wode wontta gooda, Magdela Mayramiran hyankko Mayrama Yesuusa moogunttide boozto be7ades hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Qoppikaayzin wolqqaama sa7a en7e maaqqida. Laatstse kiitanchcho saloppa wodhdhii booza doontte yeze shuchchito gol7izi kattara bettida. ");
INSERT INTO oydl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","E bishshita zeelintsi aazane. E afulttan shachchi fana bootsi. ");
INSERT INTO oydl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naagizuntsi kiitanchchiza bi7i, zhashtii goqii, hyayqqide asi fana yii7ida. ");
INSERT INTO oydl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kiitanchchize maachuntsago, «Yin masqalalla afa suxunttide Yesuusa koyzanno taanii erize gisho zhashtippete. ");
INSERT INTO oydl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E kase ohidanni fana hyayqoppa denddida; hyanne baaya. Hyayga yi7i eza moogide besito bo7ote. ");
INSERT INTO oydl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yin hyatte ellisii hyanggi, E tamaaruntsis, ‹Yesuusa hyayqqoppa denddida. Mahi E yinttappa tiinidhii Galila qitoda; yin eza yeyga be7ada› yaga7i ohote. Taanii yinttis hyanno ohodes yi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Un zhashtiteran gaama ufayttitera, booziti kaleppa ellisii hyanggi, E tamaaruntsis ohodes woxxida. ");
INSERT INTO oydl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Qoppikaayzin Yesuusa unttara yellintti unttago, «Saro yinttis maaqqe» yagayda. Un eego shiiqii, E tohito aykkii ees goynida. ");
INSERT INTO oydl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ye wode Yesuusa unttago, «Zhashtippete; hyanggi ta tamaaruntsi Galila hyanggode gaar unttis ohote. Un ize tana be7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yentsi maachuntsi hyanggodera, boozto naagize wottaddaruntsappa bagguntsi katama hyanggi, hyanide bazito ubba kahinunts hyalaquntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kahinunts hyalaquntsin cimuntsi shiiqii zorintti, wottaddaruntsis gaama bira inggi, ");
INSERT INTO oydl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","«‹Nu genttezin E tamaaruntsi qamma yi7i, E ahito kaystida› yaga7ote. ");
INSERT INTO oydl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hyanna ohito gade ahizay si7iko, yinna yin bala baayzanno nu ees ohi ammantsoda. Yinttana akkon yirggizippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wottaddaruntsi birto ekkii, ohidanni gaar oochchida. Hyanna ohita Ayhudunts kale hyayno yellodes ohinttitera yene. ");
INSERT INTO oydl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taphpho fettii tamaaruntsi Yesuusa kiittide Galila yeze derego qitida. ");
INSERT INTO oydl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ize un eza bi7ide wode ees goynida, yezin unttappa fete fete so7ida. ");
INSERT INTO oydl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuusa unttago shiiqii, «Salon sa7an adetits wolqqa ubba taas ingginttida. ");
INSERT INTO oydl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yikke, yin ubba bessa qitote, Aday, Na7ay, Geeshi ayyaana suntsite as ubba tamaarssi, xammaqi ta kiittidanno ubba naagode fana tamaarssitera tana kaallizuntsana mahote. ");
INSERT INTO oydl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Taanii yinttana kiittidebaz ubba un naagode fana unttana tamaarssote. Taanii wode wurssutsi yellodes ubba wode yinttara yene» yagayda.");
INSERT INTO oydl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hyay Xoozze Na7a Yesuus Kiristtoosa Wonggele dentstse. ");
INSERT INTO oydl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nabe Isayaasa xaafide maxaafite Xoozii, «Yikke, taanii ta Kiitanchcho neeppa tiino dakkoda. E ne ogito giigisada. ");
INSERT INTO oydl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Fetay akko baayze ganasa fa qaaltto dhoqi yiizii, ‹Laatstse ogito giigizote; E yedhdhade wustto ees giigizote gayda› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xammaqize Wahannisa asuntsana xammaqittera, «Yin nagarttippa maaqqii xammaqinttote; Xoozii yin nagartto atto ga7oda» yaga7i qaala ohitera akko baayze ganasara yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yihuda sa7a yeze asuntsi ubban Yerusalaame katama asuntsi ubba Wahannisago ye7ine. Fa nagartto faaxin, Wahannisa unttana Yorddanoosa borkka xammaqida. ");
INSERT INTO oydl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wahannisa gimale isintseppa dadinttide afula ma77ida. Fa qazintte saqqe danccida; mahi boolen dekera shida mu7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wahannisa qaala ohitera, «Taappa suubara damma miinggize ye7ine. Melle atto yezin, taanii E caamma gaadiza zuggii billodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taanii yinttana hyaatsara xammaqane, yezin E yinttana Geeshi Ayyaanara xammaqoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yesuusa ye wode Galila awrajja yeze Naazirete katamappa yi7in, Wahannisa Yorddaanosa borkka xammaqida. ");
INSERT INTO oydl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesuusa hyaatsitippa kezze wode salo bugunttin, Geeshi Ayyaana eella afa wolle gaara wodhdhodera bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mahi saloppa, «Taanii kadhize ta na7ay nena; ta neella ufayttane» yagaaze qaala yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iira Geeshi Ayyaana Yesuusa akko baayze ganasa kanggida. ");
INSERT INTO oydl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesuusa akko baayze ganasa Xalahera fattaninttitera oyttam qamma gam7ida. Xootsara yezida, yezin kiitanchchuntsi yi7i eza maaddida. ");
INSERT INTO oydl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wahannisa acinttidannippa suuba Yesuusa Xoozze ka7itumo Wonggele ohitera Galila awrajja qitida. ");
INSERT INTO oydl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ize, «Wode yellida; Xoozze ka7itumo ukkida. Yin nagarttippa maaqqii, Wonggele ammanote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuusa Galila Abba kalera aadhitera, molo aykkize, Simoonaran E ishe Inddirasera, fa gitito Abba olizuntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Unttago, «Tana kaallote; ta yinttana as ayfo tamaarssoda» yagayda ");
INSERT INTO oydl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Unttii iira fa gitito olii ashshii Yesuusa kaallida. ");
INSERT INTO oydl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuusa eeratsi tiino hyanggi, lam77i ishuntsana Zabdoosa na7untsana, Yayqoobaran Wahannisara gongge gidda fa gitito giigizuntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E unttana bi7ide gaar xeegida. Un fa adaya Zabdoosan, ees oochchizuntsara gongge gidda olii ashshii Yesuusa kaallii qitida. ");
INSERT INTO oydl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Unttii Qifirnahoome katama yellida. Sambbata gelide gaar Yesuusa ellisii Ayhude woosa keetstsa gelii tamaarsse aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Adetits wolqqara yeze asi fana tamaarssanep attin higge asttamaarunts fana tamaarssoosse gisho asuntsi E timirttite gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ye wode tuna ayyaana aykkide fettii atstse Ayhude woosa keetstsa gelii fa qaaltto dhoqi yeyzi, ");
INSERT INTO oydl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Naazirete Yesuusa, neenii nuuppa akko koye? Nuna dhabssodes ne yi7ida? Ne oona yezako ta erane; ne Xoozze Geeshi.» Yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuusa ye tuna ayyaanza, «Hyayzo, hyay atstseppa kezo» ga7i seerida. ");
INSERT INTO oydl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuna ayyaana atstsa labbizii, wuysizii ezappa kezida. ");
INSERT INTO oydl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Asuntsi ubba gaama qoppii, «Hyanna akko? Hyay atstse fa adetits wolqqara melle atto yezin tuna ayyaanan kiittane. Unttii ees kiittinttane; hyanna akko kille timirtte?» yaga7i, fa gidda fete feta oocida. ");
INSERT INTO oydl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesuusa markkatitsita ellisii Galila sa7a yeze guta ubba kezida. ");
INSERT INTO oydl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuusa Ayhude woosa keetstsappa kezii, Yayqoobaran Wahannisaran Simoona karan Inddirase kara qitida. ");
INSERT INTO oydl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoona machchiti intta damma otstsi michara hyarggintti woy7idanno Yesuusa ize yellin ees ohida. ");
INSERT INTO oydl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","E iigo shiiqii, I kushito aykkii, izo dentsii essida. Otstsi michita ashshin iza unttana mokkida. ");
INSERT INTO oydl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hyargginttide asuntsanan tuna ayyaana aykkide asuntsana ubba ugure awa gelin eego ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Katamite yeze asunts ubbuntsi yinna keetsiti bale shiiqida. ");
INSERT INTO oydl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuusa dumma dumma hyarggera aykinttide gaama asuntsana fatstsi, gaama tuna ayyaanuntsana kessida. E oode yezako tuna ayyaanuntsi eride gisho unttana ohaame fana kayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesuusa wontti maatse denddii, asi baayze bessa hyanggi, ize Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoonaran eera yezuntsi eza koyitera qitida. ");
INSERT INTO oydl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Unttii eza denggi, «Asi ubba nena koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesuusa mahi unttana, «Yinna gutute yeze seko katamite yedhdhote. Taanii yi7idanna Wonggele ohodes maaqqide gisho ize yeze guta ohodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayhude woosa keetstsa qaala ohiteran tuna ayyaanuntsana kessitera, Galila sa7a ubba wutida. ");
INSERT INTO oydl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Qursuma hyargge aykkide fettii atstse Yesuusago yi7i, E tiintte bunqqunttii, «Neenii koyko tana geeshodes dandda7ane» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuusa ees yiqsinttii, fa kushito dakkii eza bochchi, «Taanii kadhane, geezho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iira qursumtta atstsa dakkin atstse geezhida. ");
INSERT INTO oydl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuusa atstsa mintsii naagintto ga7i kessii dakkida. ");
INSERT INTO oydl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Yesuusa eza, «Nena ero, hyanno oodesin ohippe. Yezin hyanggi ne galtto kahine beezo. Neenii hyatte geeshi maaqqidanno asuntsana ersodes, Muse kiittide zharshito zharsho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yezin atstsay hyanggi, kara gancce as ubbuntsis ohida. Yinnii gisho, Yesuusa benttii kezii, katama gelodes dandda7ikaaya. Yezin asi baayze bessa gaxa yezida; mahi asuntsi ubba fa yeze bessappa eego ye7ine. ");
INSERT INTO oydl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Eeratsi qammappa suuba Yesuusa Qifirnahoome maaqqii, keetstsa yene gaaze wore sinttida. ");
INSERT INTO oydl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Asuntsana keetstsita ekkaanxxi ixxin, melle atto yezin balttan un7ode wontsis gaama asuntsi shiiqin, Yesuusa qaala tamaarssane. ");
INSERT INTO oydl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oyddii asunts fettii wobbo atstsa tookkii eego ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Asuntsi gaanggide gisho atstsa Yesuusago shiishodes unttis dandda7inttanxi ixxin, Yesuusa yeze zalara keetstsi aafto tookkii atstsa E woy7ide alggizera sulle ketstsii Yesuusa tiintte gaddida. ");
INSERT INTO oydl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesuusa un ammantto bi7i, ye wobbo atstsa, «Ta na7ayo, ne nagartta atto ga7inttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Higge asttamaaruntsappa yinna besite bettide fete fete fa wozintte, ");
INSERT INTO oydl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Naate hyay atstse hyannii gaar iita baz Xoozalla akkos ohe? Xoozza xalaalap attin melle oode nagara atto ga7odes dandda7ize?» ga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Unttii fa wozintte yinnii gaara qoppidanno Yesuusa iira fa ayyaantte erii, unttago, «Yinttii yin wozintte akkos hyannigaara qoppete? ");
INSERT INTO oydl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wobbo atstsa, ‹Ne nagartta atto ga7inttida› gaazanna ukkeene? Woy, ‹Denddii eqqii ne alggiza tookkii qito› gaazanna ukke? ");
INSERT INTO oydl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yezin taas, As Na7ays, sa7alla afa nagara atto ga7odes adetits wolqqa yezanno yin erode gaar» ga7i ye wobbo atstsa, ");
INSERT INTO oydl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Nena gaane, denddii eqqii ne alggiza tookkii ne kara qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Atstse ellisii denddii eqqii, fa alggiza tookkii asi ubba be7izin qitida. Asuntsi ubba gaama qoppii, «Nuunii hyannii gaar gaama qofize baz bi7i eroos» yaga7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuusa mahi Galila Abba gaxa hyanggi, faago yi7ide asuntsana ubba tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iira aadhitera, Ilfiyoosa na7ay Leewe ga7inttize qaraxe gachchize besite bettidaya bi7i, «Tana kaallo» yagayda. Leewize denddii eqqii eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuusa katstsa ma7ades Lewii keetstsa bettida. Eza kaallize asuntsi gaama maaqqide gisho qaraxe gachchize gaama asuntsin nagaranchchuntsi eeran E tamaaruntsara wolla bettida. ");
INSERT INTO oydl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Higge asttamaare maaqqide fettii fettii Farisaawuntsi Yesuusa nagaranchchuntsaran qaraxe gachchizuntsara katstsa ma7adera bi7i, «E akkos nagaranchchuntsaran qaraxe gachchizuntsara katstsa me7e?» yaga7i, E tamaaruntsana oocida. ");
INSERT INTO oydl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesuusa un gaazanno si7i, «Hyargginttizes fattin faxas akime koshshoos. Taanii nagaranchchuntsana xeegodes yiiddap attin xilluntsana xeegodes yi7ikaaya» yaga7i unttis mahida. ");
INSERT INTO oydl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xammaqize Wahannisa tamaaruntsin Farisaawuntsi xoomane. Fettii fettii asunts Yesuusago yi7i, «Wahannisa tamaaruntsin Farisaawunts tamaaruntsi xoomane, yezin ne tamaaruntsi akkos xoomoso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesuusa unttago, «Sarge yi7ide asunts machcho ekkize unttara yezin, xoomodes dandda7ane? Machcho ekkize unttara yezin, xoomodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yezin machcho ekkize un kaleppa ekinttodes wode ye7oda, un ye wode xoomoda. ");
INSERT INTO oydl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Gal7a ma7olla kille carqqe gaddii sikkize asi baaya. Gaddii sikkikon, killize gal7a ma7iza feedhane; feedhitsitan kasennippa aadhane. ");
INSERT INTO oydl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mahi mal7antto woyne gal7a silphe gujjize asi baaya. Mahi gujjikon, ye woynize silphiza feedhane, faasin lanttane, silphizen iitane. Yezin mal7antto woyne kille silphe gujjinttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesuusa fettii Sambbata qamma bangga gade giddara aadhodera, E tamaaruntsi eera hyanggitera bangga tizha shiccii dha7ane. ");
INSERT INTO oydl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisaawuntsi Yesuusago, «Yikke, ne tamaarunts Sambbata qamma woga baayze baz akkos oochche?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuusa unttago, «Dawute naydhdhii, muuze baz koyde wode faara yezuntsara oochchidanno ne nabbabika? ");
INSERT INTO oydl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyaatar kahinunts hyalaqa maaqqii yeze wode Dawute Xoozze keetstsa gelii, kahinunts xalaala ma7adep attin ooden ma7ades woga baayzanno Laatstse tiino gaddide daabbuto mu7ida, faara yezuntsisin inggida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mahin Yesuusa unttago, «Sambbata as na7a maades ga7i medhinttidap attin asi Sambbatas medhinttikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yinnii gisho, As Na7ay, melle atto yezin Sambbatasin Laatstsii» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuusa Ayhude woosa keetstsa maaqqii gelida. Ize kushe gunddide fettii asi yene. ");
INSERT INTO oydl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fettii fettii asuntsi Yesuusa mootodes kezii, kushe gunddide atstsa Sambbata wode E fatstsikon ashshiko ga7i be7ades koyi mintsii naagane. ");
INSERT INTO oydl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuusa kushe gunddide atstsa, «Denddii eqqii hyankka gidda yo7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yinnippa suuba, asuntsago, «Sambbata wode lo77o baz oochchizanna wogaane iita baz oochchizanna woga? As shemppo ashshizannone woy wodhizanno?» yaga7i oocida. Yezin asuntsi si77i gayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuusa antsinttii, unttana wututsii dakkii bi7i, un ohin si7oosuntsana maaqqide gisho unttalla afa gaama zhilidhdhida. Ye atstsego, «Ne kuciza fiddii yiizo» yagayda. Ezii fiddii yiizin E kucizen faxida. ");
INSERT INTO oydl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ellisii Farisaawuntsi Ayhude woosa keetstsappa bale kezii, Yesuusa wayzi wodhod yezako zorinttodes Heroodisa bagguntsara fettii bessa shiiqida. ");
INSERT INTO oydl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuusa fa tamaaruntsara Galila Abbago hyanggida. Galilappan Yihudappa yi7ide gaama asuntsi eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mahin Yerusalaameppa, Edumiyasappa, Yorddaanosa borkka fintsappa, Xiroosa katamappan Sidoona katamappa Yesuusa oochchidanno si7i, gaama asuntsi eego yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Asi gaanggidannippa denddii eza un7itsaame fana E tamaaruntsi gongge ees giigisade gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gaama asuntsana E fatstside gisho hyargginttize asunts ubba eza bochchodes urqqinttane. ");
INSERT INTO oydl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tuna ayyaana aykkide asuntsi eza bi7ide wode E tiintte bunqitii, fa qaaltto dhoqi yiizii, «Neenii Xoozze Na7a baane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesuusa gaama wode tuna ayyaanuntsi fa oonatitsito qonccizaame fana unttana mintsii kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesuusa derella afa kezii, fa koyze asuntsana faago xeegida; unttin eego shiiqida. ");
INSERT INTO oydl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Un faara yessade gaaran qaala tamaarssode gaar taphpho lam77untsana doorii, unttana, «Hawaare» ga7i suntsida. ");
INSERT INTO oydl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tuna ayyaana kessode gaar unttis adetitsi wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E dooride taphpho lam77untsi hyantsesana: Phexiroosa ga7i suntside Simoona, ");
INSERT INTO oydl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Bo7anergges (Dada aazize asuntsana) yaga7i suntsiduntsana, Zabdoosa na7unts Yayqoobaran Yayqooba ishe Wahannisa, ");
INSERT INTO oydl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Inddirase, Filphoosa, Barttolomiyoosa, Maatoosa, Toomaasa, Ilfiyoosa na7a Yayqooba, Taadiyosa, Kananeppa yi7ide Simoonara, ");
INSERT INTO oydl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesuusa aatsii inggide Asqorootu Yihuda. ");
INSERT INTO oydl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yinnippa suuba, Yesuusa kara hyanggida. Mahi gaama asunts shiiqin, ezin E tamaarunts melle atto yezin katstsa ma7adesin un dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Asunts eza, «Zhaashtane» gaaze gisho E iginuntsi yinno si7i eza ekkodes hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Higge asttamaaruntsappa fete fete Yerusalaameppa yi7i, «Eella afa Bi7elzebuula yene», E, «Xalahe wolqqara tuna ayyaana kessane» yaga7i wolla ohinttida. ");
INSERT INTO oydl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesuusa asuntsana faago xeegii aazizer ohida. «Xalahe Xalahe wayzi kessodes dandda7e? ");
INSERT INTO oydl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Fettii ka7itumo fa gidda shaakkinttiko yinna ka7itumtta eqqodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yinnii gaara, fettii keetstsa asuntsi fa gidda shaakkinttiko dhabodap attin yessades dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yikke, Xalahe faara kacinttii shaakkinttiko dhabodap attin yessades dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Yinnii gaara tiino wolqqar yeze atstsa accikaayzara E keetstsa gelii, E qoltto bonqodes dandda7ize asi baaya. Accii maaqqii E keetsito bonqodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Taanii yinttis turo ohine; Xoozii as na7untsis nagara ubbannon un cazhize cashito ubba atto ga7oda. ");
INSERT INTO oydl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yezin Geeshi Ayyaanalla iita baz ohize medhinas nagara gale maaqqadep attin Xoozii mulon eza maaroos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuusa yinno ga7idanna, fettii fettii asunts, «Eella afa tuna ayyaana yene» yagayde gisho. ");
INSERT INTO oydl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E inttan E ishuntsin yi7i bale eqqii, eego asi kiittii eza xeegida. ");
INSERT INTO oydl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","E kale bettide gaama asuntsi, «Yikke, ne inttan ne ishuntsin bale eqqii nena koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesuusa mahi, «ta intta oode? Mahi ta ishuntsin aanuntsana?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Fa kantte bettide asuntsana wututsii dakkii bi7i, «Yikke, ta inttan ta ishuntsin hyantsesana. ");
INSERT INTO oydl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xoozze qofa oochchize ubbuntsi taas ishen, taas mishon taas inddo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuusa mahi Galila Abba kale tamaarssane. Gaama asunts E kantte wutii shiiqin, abballa yeze gonggite gelii bettida, asunts ubba Abba kale yene. ");
INSERT INTO oydl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","E unttana gaama baz aazizera tamaarssida. Tamaarssitera hyannigaara yagayda: ");
INSERT INTO oydl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Yikke! Fettii atstse budutstsi budodes kezida. ");
INSERT INTO oydl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E budodera, fettii fettii budutstsita oge gaxa wodhdhida; Landda yi7i mu7ida. ");
INSERT INTO oydl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Fettii fettii budutstsita forchcho sa7alla wodhdhida. Gaama sa7a baayze gisho yinna budutstsita ellisii dolida. ");
INSERT INTO oydl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Yezin awa kezze wode shullida. Loytsii xapho dakkikaayze gisho ellisii melida. ");
INSERT INTO oydl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fettii fettii budutsita anggatsi gidda wodhdhida. Dolidanno anggatsita diccii cuullide gisho aafe aafikaayzara attida. ");
INSERT INTO oydl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Fettii fettii budutstsita aradda sa7a wodhdhii dolida. Diccii fete hyasttam, fete izippun tam fete xeet aafida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","«Si7ize hyaye yeze ooden si7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesuusa ohidanno si7ide fettii fettii asuntsi taphpho lam77i tamaaruntsara yezunts Yesuusa fa xalaala yessadera, eego shiiqii yinna aazizitis bilitsito oocida. ");
INSERT INTO oydl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesuusa unttago hyannii gaar yagayda: «Yinttis Xoozze ka7itumo gaatsi qofa erodes ingginttida. Yezin melluntsis ka7itumoppa balera yezuntsis ubba bazi aazizera ohinttane. ");
INSERT INTO oydl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hyanna hyanidanna, «Unttii be7ine, yezin denggoos. Si7ine, yezin tiiroos. Unttii denggizakon tiirzako, Xoozago maaqqada ezin unttana maaroda yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuusa unttago, «Hyanna aazizta yinttis geloso? Yeezin, aazize ubba yin wayzi tiirode? ");
INSERT INTO oydl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Budizay Xoozze qaala budane. ");
INSERT INTO oydl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Qaala budinttize wode oge gaxa wodhdhidunts qaala si7izuntsana. Yezin Xalahe iira yi7i, un wozintte budinttide qaaltto maxii hyaasane. ");
INSERT INTO oydl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yinnii gaara, forchcho sa7a budinttide qaala si7i, ellisii ufaytti ekkizuntsana. ");
INSERT INTO oydl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yezin unttis mintsii xapho baayze gisho hyattes fattin gam7oos. Eerats wodeppa suuba qaala gisho madhan woy baytstsii yellide wode ellisii dhubunttane. ");
INSERT INTO oydl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Anggatsi gidda budinttide qaala si7izuntsana. ");
INSERT INTO oydl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Yezin hyanna sa7a yessis yirggan, durtumo kadhen dumma dumma amotitsi un wozintte gelii qaaltto cuullize gisho aafe aafikaayzara attida. ");
INSERT INTO oydl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yezin aradda sa7a budunttezuntsi qaala si7i ekkizuntsana. Unttii fete hyasttam, fete izipuntam fete xeet aafida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuusa gujjii, «Xomppe ekkii, gabate gidda woy algga oomo gaddize asi yene? Dhoqqa bessa gaddosaane? ");
INSERT INTO oydl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yikke, aachinttide baz ubba qoncce kessada; aachinttide baz ubba erinttikaayzara attaama. ");
INSERT INTO oydl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si7ize hyaye yeze ooden si7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mahi unttago, «Yin si7ize baz qofar si7ote! Xoozze qaala yin si7izanni fana E yinttis qofa inggoda. Yinttis makkizanne gaantsi inggoda. ");
INSERT INTO oydl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yeze atstses gaantsi ingginttoda, baayze atstseppa melle atto yezin, ees yeze yinna eeratsitan ekinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuusa mahi, «Xoozze ka7itumo fa gadite budutstsi budize atstse fana. ");
INSERT INTO oydl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ye atstse qamma genttane wontta denddane. E fa ommite wayzakon erikaayzara yessadera yinna budutsita dolii diccane. ");
INSERT INTO oydl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gaditan katstsa fa faas inggane. Tiino dolii diccane, suubite aafodes gambbuxane, wurssutsite kumutsi aafe aafane. ");
INSERT INTO oydl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yezin katsita yellide wode atstse maxane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuusa, «Nuunii Xoozze ka7itumo akko fana ga7ode? Woy akkora aazissade? ");
INSERT INTO oydl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xoozze ka7itumo aafe eerats minxa aazane. Ye minxa aafize budize wode sa7alla yeze minxa aafe ubbappa laafane. ");
INSERT INTO oydl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Budin dolii minxa ubbappa dammane; damma daashi daazhane. Landduntsi E tirshitilla afa keexxii bettode wontsis daazhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuusa hyannii gaar gaama aazizera asunts tiirodes dandda7ode gaar qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asuntsis aazize baytsi ohoos. Yezin Yesuusa fa tamaaruntsara xalaala yeze wode unttis ubbabazito billii ohida. ");
INSERT INTO oydl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ye wode sa7ita ugurin, Yesuusa fa tamaaruntsago, «Abbappa seko gaxa fiinggoda» gayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","E tamaarunts gaama asuntsana olii ashshii ashshii, Yesuusa tiino gelii bettide gonggize gidda gelii Yesuusa faara ekkii qitida. Melle gongguntsin ize yene. ");
INSERT INTO oydl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Damma gote denddii, zuluntta gonggiza guuddin, hyaatsita kumode wontsis gonggize gidda gelida. ");
INSERT INTO oydl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ye wode Yesuusa gonggizes suuba zalara borkkotsi gaddii genttida. E tamaarunts eza barkkizii, «Asttamaazayo, nu dhabize wode nena yiqsosaane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yezin, E barkki zuluntto, «Seerii», abbizan, «Si7i ga7o» yagayda. Zulunttan si77i ga7in ubba bazi woppu gayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesuusa fa tamaaruntsago, «Akkos hyannigaara zhashitete? Yinttis ammano wayzi dhabido?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Unttii gaama zhashtii fa gidda, «Hyay melle atto yezin, goten abban kiitinttize oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuusan E tamaaruntsi abba fiinggi, Gerggesoone gaaze sa7a yellida. ");
INSERT INTO oydl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesuusa gonggizeppa wodhdhize wode tuna ayyaana aykkide fettii atstse boozappa kezii eera yellinttida. ");
INSERT INTO oydl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ye atstse booza gidda aqii feezhii yene. Eza ooden gaadera accodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","E gaama tohe duullaran santsalaatara acinttii yene. Yezin santsalaaton duutsane, duullizan mentsitsane. Eza mahodes dandda7ize ooden baaya. ");
INSERT INTO oydl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","E qamman awara yinna booziten derellan wuyssane, fa galtton shuchchara qawuxane. ");
INSERT INTO oydl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesuusa hyaakora bi7ide wode woxxii hyanggi E tiintte bunqunttida. ");
INSERT INTO oydl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ye atstse fa qaaltto dhoqi yiizii, «Ubbappa kattara yeze Xoozze Na7a Yesuusa, neera tana akko yeltsize? Tana dhabssaame gaar taanii nena Xoozze suntsite woossane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","E yinno gaydanna Yesuusa eza, «Naate hyay tuna ayyaanzayo, hyay atstseppa kezo» yagayde gisho. ");
INSERT INTO oydl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesuusa eego, «Ne suntsita oode?» yaga7i oocida. E, «Nuunii gaama maaqqide gisho ta suntsita Leegiyona» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tuna ayyaanuntsi fana yinna gaditippa kessii dakkaame gaar Yesuusa mintsii woossida. ");
INSERT INTO oydl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ye derizella gaama gudayille wude yengginttane. ");
INSERT INTO oydl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tuna ayyaanuntsi Yesuusago, «Nuna sekka gudayille wudute dakkoya, un gidda hyanggi geloda» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesuusa unttago, «Qitote» yagayda. Yeezin tuna ayyaanuntsi atstseppa kezii gudayluntsi gidda gelida. Lam77i mukul maaqqade gudayille wude gaga doonara woxxii hyanggi abba gelii qoodhdhinttida. ");
INSERT INTO oydl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gudayille wude yenggizuntsi woxxii hyanggi hyanidanno katamaran gaxarera ohida. Yezin asuntsi hyanidanno be7ades kezida. ");
INSERT INTO oydl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Asuntsi Yesuusago ye7ize wode tuna Ayyaanara aykinttide atstsa bi7ida. E fa wozintte maaqqii, ma7o ma77i, ize bettidanno be7ize wode ubbuntsi zhashtida. ");
INSERT INTO oydl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yinno bi7ide gaar asuntsi tuna ayyaanuntsi aykkide atstsella afan gudayluntsalla afa hyanidanno ubba asuntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yinnii gisho, asunts fa sa7itippa Yesuusa kezode gaar woossida. ");
INSERT INTO oydl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuusa gonggite gelze wode tiino tuna ayyaana aykkii dakkide atstse, Yesuusara hyanggodes eza woossida. ");
INSERT INTO oydl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yezin Yesuusa ixxii eego, «Ne kara maaqqii, Laatstsii nees akko gaar damma baz oochchezakon akko gaar maarezako ne kara asuntsis oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Atstsay hyanggi Taphphi Katama ga7inttize sa7a wutii, Yesuusa faas akko gaar damma baz oochchezako ohida. E ohidanno si7ide asunts ubbuntsi gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuusa maaqqii, gongge gelii, abba fiinggidannippa suuba gaama asuntsi abba gaxa E kale wutii shiiqida. ");
INSERT INTO oydl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iyaroosa gaaze Ayhude woosa Keetstsa hyalaquntsappa fete, Yesuusa bi7ide wode eego yi7i E tohitilla afa ");
INSERT INTO oydl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","gol7i, «Ta naata hyargginttii hyayqqodes yi7ine. Iza faxii yessade gaar yi7i ne kushito iilla afa gaddoya» yaga7i Yesuusa mintsii woossida. ");
INSERT INTO oydl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesuusa Iyaroosara qitida. E hyammadera gaama asuntsi Eza kaallii un7itsida. ");
INSERT INTO oydl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Taphpho lam77i bere I gallitippa suutsi goggize fettii maachita yene. ");
INSERT INTO oydl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Gaama akimuntsi izo akimida, yezin iza faxa ka7inttida. Iza fa qoltto ubba hyaasinin iisi hyanka iitidap attin akkon maaddikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yinna maachita Yesuusa baz si7i, asuntsana aadhii Yesuusa suubara yi7i E ma7ito bochchida. ");
INSERT INTO oydl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iza, «Taanii melle atto yezin E ma7ito bochchizako faxoda» ga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iippa goggize suutsita iira eqqii attida. Iza fa waaytippa faxidanno fa gallite erida. ");
INSERT INTO oydl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuusa iira faappa wolqqa kezidanno fa ommite erii, gaama as gidda suub maaqqii, «Ta ma7ito bochchide oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E tamaaruntsi, «Asuntsi nena urqqizanno bi7itera, ‹Wayzi tana oode bochchide ga7e?› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesuusa yinno oonii oochchezako be7ades wututsii dakkii bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yezin maachita faas hyanidanno erii, zhashimora goqitera yi7i Yesuusa tiintte gol7ida; mahi hyanidanno ubba turtto ees ohida. ");
INSERT INTO oydl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeyin, Yesuusa iigo, «Na7ite, nena ne ammantta fatstsida, sarora qito, ne waaytippa faxo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuusa hyaga yinno ohodera, Ayhude woosa Keetstsa hyalaqa karappa kiitinttide asuntsi yi7i, «Ne naata hyayqqida, asttamaariza akkos labbize?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yezin Yesuusa un gaazanno si7i, Ayhude woosa Keetstsa hyalaqizego, «Ammano xalaala ammanop attin zhashtippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuusa Phexiroosappa, Yayqoobappan Yayqooba ishe Wahannisappa melle ooden fana kaallaame gaar kayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Unttii Ayhude woosa Keetstsa hyalaqize kara yellide wode Yesuusa asuntsi wozina dhabii yeekkizuntsanan zeleluntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gelii asuntsago, «Akkos muuzhii yeekkete? Naata genttidap attin hyayqqikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Asuntsi eella afa miicida. Yezin asuntsana ubba bale kessii, naatii adayan, intton hyaydzdzii tamaaruntsana faara ekkii naata yeze besite gelida. ");
INSERT INTO oydl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuusa naatii kushito aykkii, «Xaalita, quumii» (Eeratsi na7ite, nena gaane denddo) yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Naata iira denddii eqqii yedhdhida. Iza taphpho lam77i bere na7a. Yinne asuntsi gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuusa yinno un oodesin ohaame gaar unttana mintsii kiittida. Unttii iis mu7ize baz immade gaar ohida. ");
INSERT INTO oydl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuusa izippa kezii, fa tamaaruntsana kaalitsi, fa katama Naazirete yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sambbata wode Ayhude woosa Keetstsa tamaarsse aykkida. E tamaarssizanno si7ide gaama asuntsi gaama qoppii, «Hyay hyanno ubba abappa denggido? Hyanna cinccatitsita ees anapp inginttido? Hyanna E kushite oochinttize kille bazito oochchize wolqqa Ees oonii inggido? ");
INSERT INTO oydl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hyay anaaxe na7a baane? Mayrami na7a, Yayqooba, Yoosa, Yihudan Simoona ishe baane? E mishuntsi nuura hyanne yezuntsana baane?» yaga7i, E gaazanno si7anxi ixxida. ");
INSERT INTO oydl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesuusa yentsi asuntsago, «Nabe fa gade, fa iginuntsi giddan fa kara asunts gidda bonchchinttoos fattin melluntsi kale bonchchinttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E yinna besite fa kushito eeratsi asuntsalla afa gaddii fatstsidannip attin melle gaama qofize baz oochchodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Asuntsi ammanikaayze gisho gaama qoppida. Yinnippa suuba Yesuusa yinna gutute yeze asuntsana tamaarssane. ");
INSERT INTO oydl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuusa taphpho lam77i tamaaruntsana faago xeegii, lam77i lam77i mahi kiittida. Unttis tuna ayyaanalla adetits wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Unttana, «Oges gufep attin katstsa, karxite, yin kiistte bira akko bazin aykkippete. ");
INSERT INTO oydl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yin tohite caamma aatstsote, fattin lam77i afula aykkippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mahin, «Yinttana asi mokkize keetstsa aba maaqqikon yinna bessitippa kezii qitode wontsis yinna keetstsite gam7ote. ");
INSERT INTO oydl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yinttana asi mokkoosse bessa woy yin ohizanno si7oosse bessa aban maaqqiko, yinna sa7ite yeze asuntsis yin markka maaqqade gaar yinna bessitippa kezitera, yin tohite yeze xurito fixxote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Taphpho lam77i tamaaruntsi hyanggi, asuntsi fa nagarttippa maaqqade gaar qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Unttii asappa gaama tuna Ayyaana kessida. Gaama hyargginttizuntsana zayte tizhii fatstsida. ");
INSERT INTO oydl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuusa suntsita ubba bessa kezide gisho Kaat Heroodisa E baz si7ida. Fettii fettii asuntsi, «Xammaqize Wahannisa hyayqoppa denddida, yinnii gisho hyanna kille bazito oochchize eza» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bagguntsi, «Hyay Eeliyaasa» yagayda. Melluntsi mahi, «Hyay zaga wode nabuntsappa fetaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yezin Heroodisa yinno si7ide wode «Hyay taanii afurtto gachchizide Xammaqize Wahannisa. E hyayqoppa denddida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Heroodisa fa ishe Filphoosa machchito Heroodiyada ekkide gisho I mikinaatis Wahannisa aytstsii accizida. ");
INSERT INTO oydl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Wahannisa Heroodisago, «Neenii ne ishe machchito ekkodes beezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heroodiyada Wahannisa fa wozintte ixxii eza wodhissades koyda, yezin dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Wahannisa xillon geeshi as maaqqidanno Heroodisa eride gisho ees zhashtii loytsii naagizane. Heroodisa Wahannisa gaaze baz si7ize wode tannane. Yezin ufaytti si7ine. ");
INSERT INTO oydl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heroodisa fa yelinttide qammito bonchchodes gade ahizuntsana, shaalaquntsisin Galila yeze damma asuntsis diggisa giigizida. Yinna Heroodiyadas wottize wode maaqqida. ");
INSERT INTO oydl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heroodiyada na7ita zaqquntsi mokunttize keetstsa gelii durii, Heroodisan E zaquntsana ufayssida. Kaatize naatigo, «Ne koyze akko maaqqikon tana ooco, ta nees inggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mahi iisi caaqqii, «Neenii oocize akko maaqqikon, taanii nees inggoda. Melle atto yezin, ta ka7itumtti baggito maaqqikon ta nees inggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Naata bale kezii fa inttigo, «Akko inggo gawune?» ga7i oocida. I intta, «Xammaqize Wahannisa ommito inggo ga7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naata ellisii kaatizego hyanggi, «Xammaqize Wahannisa ommito saane gidda gaddii hyatte taas immade gaar koyane» gayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yaga7in Kaatize gaama zhilidhdhida, yezin fa zaqqunts gisho iisi caaqqide fa caaqito ashshodes koykaaya. ");
INSERT INTO oydl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yinnii gisho, ellisii naagizego Wahannisa ommito ko7ode gaar kiittida. Naagizen achchi keetstsa hyanggi Wahannisa afurtto gachchida. ");
INSERT INTO oydl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ye gachchinttide ommiza saane gidda gaddii ki7i naatis inggida. Naata mahi fa inttis inggida. ");
INSERT INTO oydl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wahannisa tamaaruntsi yinno si7ide wode hyanggi E ahito ekkii kanggi moogida. ");
INSERT INTO oydl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Taphpho lam77i hawaaruntsi maaqqii yi7i un oochchidannon tamaarssidanno ubba Yesuusas ohida. ");
INSERT INTO oydl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Unttago yi7ize asuntsin qitize asuntsi gaanggide gisho Yesuusaran E tamaaruntsara, melle atto yezin katstsa maadesin unttana yeltsanxi ixxida. Yeyin, Yesuusa unttago, «Ye7ote wolla eeratsi shemppodes asi baayze bessa yedhdhote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yinnii gisho, unttii fa faas gongge gelii asi baayze bessa qitida. ");
INSERT INTO oydl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Unttii hyammadera gaama asuntsi unttana bi7i erida. Yezin, katama ubbappa asuntsi tohera woxxii hyanggi un qitize bessito unttappa tiinii yellida. ");
INSERT INTO oydl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuusa gonggizeppa wodhdhii gaama asuntsana bi7ida. Asuntsi yenggize asi baayze duro fana maaqqidanno bi7i unttis yiqsinttii unttana gaama baz tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa7ita ugurize wode Yesuusa tamaaruntsi eego yi7i, «Hyanna bessita asi baayze bessi; hyatte sa7itan qammida. ");
INSERT INTO oydl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Asuntsi kara ganccen katama hyanggi faas muuze baz wonggode gaar asuntsana dakko» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yezin Yesuusa mahi unttago, «Asuntsis muuze baz yin inggote» yagayda. Un, «Nuunii hyanggi lam77i xeet dinaarer boora wonggi asuntsana muuzode gaar koyane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesuusa unttago, «Yinttis wantsi boora yeze? Ane hyanggi bo7ote» yagayda. Unttii bi7i, «Ichchin booran lam77i molon» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesuusa fa tamaaruntsana asuntsana ubba gachcho gachcho tagii betitsode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Asuntsi baggita xeet, bagita ichintam maaqqii likkera likkera tagintti bettida. ");
INSERT INTO oydl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesuusa ichchin boortton lam77i moluntsana ekkii, ude salo bi7i Xooz galatida. Boortto baxxi asuntsis yeltsode gaar tamaaruntsis inggida. Mahi lam77i moluntsana un ubbuntsis gishida. ");
INSERT INTO oydl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Asunts ubba mu7i mizhida. ");
INSERT INTO oydl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Attide boora gupan molo gufan, E tamaaruntsi taphpho lam77i leemate kumutsi dentstsida. ");
INSERT INTO oydl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Boortto mu7ide dhiiratsi asuntsi xalaala ichchin mukul maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ellisii Yesuusa fa tamaaruntsi gongge gelii, abbappa seko fintsa yeze Beetesayda faappa tiinii qitode gaar kiittida. Yezin faas asuntsana moyzodes suub attida. ");
INSERT INTO oydl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Asuntsana moyzidannippa suuba Xooz woossodes derella afa kezida. ");
INSERT INTO oydl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sa7ita qammize wode gonggize abba gidda yene, yezin Yesuusa abbappa gaxa faas yene. ");
INSERT INTO oydl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Baqo E tamaaruntsago baqize gisho abba fidhizanna waaysizanno Yesuusa bi7ida. Wontti maatse Lukule oollodes yi7ize wode E abballa afa yedhdhitera unttago yi7i, unttana olii aadhades koyda. ");
INSERT INTO oydl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yezin E abballa afa yedhdhadera, un bi7i, unttis meeshe aazin uukkida. ");
INSERT INTO oydl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Un ubbuntsi eza bi7i, zhashmora tannida. Yezin Yesuusa ellisii unttago, «Tana, akkon baaya; zhashtippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E gongge gelii unttara wolla bettin baqita woppu gayda. Unttii gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Un wozintta doccide gisho un boorttii baz tiirikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Unttii abba fiinggi, Gensareexe sa7a yellii, gonggiza gaxalla shiishii accida. ");
INSERT INTO oydl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Unttii gonggizeppa wodhdhize wode asunts ellisii Yesuusa erida. ");
INSERT INTO oydl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Unttii kara gancce yeze sa7a ubba woxxii yellii hyargginttizuntsana shanchafara tookkii, «Yesuusa yene» ga7in si7ide besite ki7ida. ");
INSERT INTO oydl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Asuntsi E hyanggide keetstsa ubba, gaxare maaqqikon, katama, yeze hyargginttizuntsana asi shiiqize bessa kanggane. Hyargganchchuntsii E afula macartto maaqqikon bochchode gaar asuntsi eza woossida. Bochchide ubbuntsi faxida. ");
INSERT INTO oydl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yerusalaameppa yi7ide fettii fettii Farisaawuntsin higge asttamaaruntsin Yesuusa kale shiiqida. ");
INSERT INTO oydl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesuusa tamaaruntsappa fete fete geezhikaayze kushera, yinnan kushe meeccikaayzara katstsa muuzuntsana un bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisaawuntsin Ayhude asunts ubba fa adunts wogiti gaar fa kushito meeccikaayzara mo7oos. ");
INSERT INTO oydl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Yinnii gaara, un gabeppa wonggi maaqqii meeccinttikaayzar mo7oos. Mahi un fa aduntsappa ekkide melle gaama woga yene: yinnan sine, xaaro, meqo miishe datsan geeshize woga naagane. ");
INSERT INTO oydl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisaawuntsin higge asttamaaruntsin Yesuusa, «Ne tamaaruntsi akkos adunts woga mentsii fa kushito meeccikaayzara katstsa me7e?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesuusa unttago, «Isayaasa yin cubbuntso, «Hyantsi asuntsi tana fa doonara xalaala bonchchanep, attin un wozintta taappa hyaako yene. ");
INSERT INTO oydl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Asi medhdhide woga Xoozze higge aazizi tamaarssize gisho un tana hyappo goynane» ga7i xaafide tinbita turo. ");
INSERT INTO oydl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«Yinttii Xoozze kiita ashshii as woga naagane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mahin Yesuusa, «Yin yin woga naagii Xoozze kiitto olii ashshodes lo77o oge denggida. ");
INSERT INTO oydl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Muse, ‹Ne adayan ne intton bonchcho›, mahi ‹Fa adayan woy fa intto cazhide hyayqqodes beezane› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yezin fettii asi fa adayan woy fa intton maaddodanno ashshii, ‹Yinna Xoozze zharsho› ga7iko, ");
INSERT INTO oydl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E fa adayan woy fa intton maaddaame gaar oochchane. ");
INSERT INTO oydl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yinnii gaara, yin melluntsana tamaarsside yin wogitira Xoozze qaala leqqida. Yinnii fana melle gaama baz oochchane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuusa gaama asuntsana mahi faago xeegii, «Ubbuntsi ta ohizanno si7ote tiirote. ");
INSERT INTO oydl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","As wozinappa kezze baz asi tunizanep attin baleppa as saza gelii asi tunize akkon baaya. ");
INSERT INTO oydl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Si7ize hyaye yeze ooden si7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuusa gaama asuntsana ashshii ashshii keetstsa gelin E tamaaruntsi yinna aaziziti baz eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","E unttago, «Yinttisin mahi gelikaane? Baleppa as wozina gelize akko bazin asi tunissades dandda7osanna gelosaane? ");
INSERT INTO oydl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Akkos gayko, katstsa as saza gidda gelii fa ogitira aadhanep attin as wozina gidda geloos» yagayda. Yinne Yesuusa katstsa ubba geeshi maaqqizanno ersida. ");
INSERT INTO oydl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kaallii, Yesuusa, «Asi tunize baz as wozina giddappa kezze baz. ");
INSERT INTO oydl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","As wozina giddappa kezze bazi iita qofa, gome woy7e, kayzo, as wodhe, ");
INSERT INTO oydl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","olale, zhinbbartimo, iitatitsi, gene, qayxe, cimo, qana7e, cashshi, uturan boozatitsi. ");
INSERT INTO oydl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hyanna iitabazita ubba as wozina giddappa kezii asi tunizane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuusa yinnippa kezii, Xiroosa katama kale yeze sa7a qitida. E fettii keetstsa gelii ize yezanno ooden erode gaar koyikaaya. Yinno maaqqikon aachintti gam77odes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yezin I eeratsi na7ito tuna ayyaana aykkide fettii maachita Yesuusa baz si7i ellisii eego yi7i E tohitilla afa gol7ida. ");
INSERT INTO oydl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iza yelinttidanna Sooriya gidda Finqqe gaaze sa7a yelinttide Grike maacho. Iza, fa naatippa tuna ayyaanza kessode gaar Yesuusa woossida. ");
INSERT INTO oydl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yezin Yesuusa mahi, «Na7untsi tiinidhii katstsa mu7i mizho; na7unts katsito ekkii kanuntsis olizanna lo77o maaqqoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Maachita mahi, «Ta Laatstsayo yinna turo, yezin leemate kale yeze kanuntsi na7untsappa wodhdhide gufto muune» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesuusa mahi iigo, «Hyanno ne ohide gisho ne kara qito; tuna ayyaanze ne naatippa kezida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Maachita fa kara hyanggize wode tuna ayyaanze naatippa kezin yitstsa woy7idanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuusa Xiroosa katamappa kezii, Sidoonaran Taphphi Katama gaaze sa7ara aadhii Galila Abbago qitida. ");
INSERT INTO oydl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Asuntsi tullen doona muume asi Yesuusago ki7i, fa kushito eella gaddode gaar eza woossida. ");
INSERT INTO oydl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuusa faas ye atstsa gaama asappa gaxa kessii, fa gil7iza E hyayte dakkida. Mahi cuchchi cuttii E il7antsito bochchida. ");
INSERT INTO oydl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Salo ude bi7i, gaddii shemppii, «Eftah» gayda. Bilitsitan «Buguntto» ga7e. ");
INSERT INTO oydl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Atstse hyayta ellisii buginttida, acinttide il7antsitan bilinttida, atstse geeshi ohinttida. ");
INSERT INTO oydl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuusa asuntsago, «Hyanno oodesin ohippete» yagayda. Yezin E gaama mintsii ohippete ga7in, asuntsi ohito gode gaantsida. ");
INSERT INTO oydl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yinno si7ide asuntsi ubba gaama qoppii, «Ubbabazito E loytsii oochchane. Melle atto yezin, tulliza sissane, muumiza ohizane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Eerats wodeppa suuba, gaama asuntsi Yesuusago shiiqida. Asuntsis mu7izebaz dhabin Yesuusa fa tamaaruntsana faago xeegii, ");
INSERT INTO oydl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Hyantsi asuntsi taara hyaydzdzii qamma yellodes gam7i, akkon muuze baz denggikaayze gisho tana asunts bazita yiqsane. ");
INSERT INTO oydl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Taanii asuntsana nayera kara dakkiko asunts hyanggitera oge labbii gol7oda, bagge asuntsi hyaako bessappa yi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesuusa tamaarunts mahi, «Hyanna akko baayze ganasa hyantsi asuntsana ubba muussades maaqqade katstsa denggodes dandda7ode oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuusa unttago, «Yin kale wantsi boora yeze?» ga7i oocida. Un mahi, «Laappun boora yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesuusa asunts sa7alla bettode gaar kiittida. Yeyzi, laappun boortto ekkii Xooz galatii maaqqii boortto baxxi, asuntsana yeltsode gaar fa tamaaruntsis inggida. E tamaarunts asuntsis gizhida. ");
INSERT INTO oydl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Unttis mahi eeratsin yishsha molunts yene. Yesuusa yentsi molunts gisho Xooz galatii, asuntsis yeltsode gaar fa tamaaruntsana kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Asunts ubbuntsi mu7i mizhida. E tamaaruntsi mu7in attide gufa laappun leemate kumutsi dentsida. ");
INSERT INTO oydl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Katstsa mu7ide asunts faydita oyddii mukul maaqqada. Yinnippa suuba, Yesuusa asuntsana moyzida. ");
INSERT INTO oydl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E mahi fa tamaaruntsara ellisii gongge gelii Dalmmanuuta gaaze sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisaawuntsi yi7i Yesuusa oocodes koyi, saloppa fana malla beessade gaar Yesuusara lalle aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuusa gaddii shemppii, «Hyanna wode asuntsi akkos malla koye? Taanii yinttis turo ohine; hyanna wode asuntsis akko mallan ingginttoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E unttana ize olii ashshii mahi gongge gelii abbappa seko fintsa fiinggida. ");
INSERT INTO oydl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","E tamaaruntsi katstsa aykkodanno botida; unttis gongge gidda fettii boorappa melle baaya. ");
INSERT INTO oydl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuusa unttago, «Yinttana erote. Farisaawunts irshitippan Heroodisa irshitippa naaginttote» yaga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Un wol gidda, «E hyanno gaazanna nuus boora baayze gisho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesuusa un gaazanno erii unttago, «Yinttis boora baayze gisho akkos ohintte? Hyatten erosite? Woy tiirosite? Yin wozintta doccida? ");
INSERT INTO oydl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yinttis aafe yezin bo7osite? Hyaye yezin si7osite? Yin tiirane? ");
INSERT INTO oydl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Taanii ichchin boora ichchin mukul asuntsis yeltsize wode wantsi leemate kumutsi gufa dentsido?» yagayda. Unttin, «Taphpho lam77i leemate kumutsi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Yinnii gaara, taanii laappun boora oyddii mukul asuntsis yeltside wode wantsi leemate kumutsi gufa dentsido?» yagayda. Un, «Laappun leemate kumutsi dentsida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yeezin, «Hyatten tiirikaane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Unttii Beetesayda katama qitida. Eerats asuntsi qooqe atstsa Yesuusago ki7i ye atstsa girmode gaar eza woossida. ");
INSERT INTO oydl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuusa qooqe atstse kushito aykkii katamappa gaxa kessida. E aafte cuttii fa kushito aafitilla afa gaddii, «Nees akko benttane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Atstsay dhoqi ga7i bi7i, «Taas asunts benttane, yezin asuntsi minxa gaar en7ane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yinnippa suuba, Yesuusa mahi, atstse aafte fa kushito gaddida. Atstsayin loytsii bi7ida, faxin ubba baz shaakkii bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuusa atstsego, «Ne kara qito, yezin katama gelippe» yaga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuusa fa tamaaruntsara Qisaariya Filphoosa kale yeze kara gancce qitida. Unttii hyammadera ogella yezin Yesuusa, «Tana asuntsi oona ga7e?» yaga7i fa tamaaruntsana oocida. ");
INSERT INTO oydl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","E tamaaruntsi, «Fettii fettii asuntsi nena, ‹Xammaqize Wahannisa› gaane; melluntsi, ‹Eeliyaasa gaane› mahi melluntsi, ‹Nabuntsappa feta› gaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesuusa unttago, «Yeezin yin tana oona ga7e?» yaga7i oocida. Phexiroosa, «Neenii Kiristtoosa» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuusa, «Ta baz oodesin ohippete» yaga7i unttana kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuusa fa tamaaruntsago, «As Na7ay, gaama madha ekkodes beezane; cimuntsi, kahinunts hyalaquntsin higge asttamaaruntsi eza ixxodes beezane. Unttii eza wodhodesin hyaydzdzii qammappa suuba, E hyayqoppa denddodes beezane» yaga7i unttana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E yinno unttis loytsii ohida. Phexiroosa eza fettii zala mahi kaccida. ");
INSERT INTO oydl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yezin Yesuusa suuba maaqqii, fa tamaaruntsana bi7i, Phexiroosa kaccii, «Hyay Xalahizay, taappa hyaakko. Neenii asi kadhizebaz qoppanep attin Xoozii kadhizebaz qoppoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mahika Yesuusa gaama asin fa tamaaruntsana faago xeegii, «Tana kaallodes koyze ooden fana kaaddo; fa masqaltto tookkii tana kaallo. ");
INSERT INTO oydl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Fa shemppito ashshodes koyze atstse dhabssoda. Yezin ta gishon Wonggele gishon fa shemppito dhabsize atstse ashshoda. ");
INSERT INTO oydl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Asi sa7alla yeze alamito tirfizako, fa shemppito dhabsiko eza akko maaddode? ");
INSERT INTO oydl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Asi fa shemppito wozodes akko immades dandda7e? ");
INSERT INTO oydl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Xooz ammanoose hyanna iita yeletuntsappa, fettii asi ta giddan ta qaaltten yeellidhiko, As Na7ay, mahi fa Aday bonchchora geeshi kiitanchchuntsara ye7ize wode yeyga yeellidhoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuusa unttago, «Taanii yinttis turo ohine; Xoozze ka7itumo wolqqara yi7izanno bi7ikaayzara hyayqqaame fettii fettii asuntsi hyanne yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesuusa izipun qammappa suuba, faara Phexiroosa, Yayqooban Wahannisa ekkii, unttana xalaala damma derella afa kessii un tiino laaminttida. ");
INSERT INTO oydl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E ma7itan focida; sa7alla ma7o meeccize ooden geeshshodes dandda7oose fana gaama booxxida. ");
INSERT INTO oydl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliyaasan Musen Yesuusara ohinttodera un bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phexiroosa Yesuusa, «Asttamaarizayo, nuunii hyanne yezanna nuus lo77o; nu hyaydzdzii gaabba feta nees, feta Muses, mahi feta Eliyaasas gaabboda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hyankkuntsi gaama tannide gisho E akko gaazakon erikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yinnippa suuba, dhonne yi7i unttana goozin dhonne garsappa, «Hyayni ta kadhize, ta Na7aya, E gaazanno si7ote» gaaze qaala yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ellisii unttii wututsi dakkii be7ize wode Yesuusa fattin melle ooden fa kale bi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Unttii derizeppa wodhdhodera, Yesuusa unttago, «As Na7ay, hyayqoppa denddode wontsis, yin bi7idanno oodesin ohippete» yaga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E kiittidanno un, «Ye7e» ga7i, «Hyanna hyayqoppa dendde gaazanna akko ga7e» ga7i, wol gidda ohinttida. ");
INSERT INTO oydl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Un mahi, «Higge asttamaaruntsi, ‹Eeliyaasa tiinidhii yo7odes beezane› akkos ga7e?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesuusa mahi «Eeliyaasa tiinidhii yi7i, ubbabazito loytsoda; yeezin, akkos Geeshi Maxaafite, ‹As Na7ay gaama waayinttoda ixinttoda› yagaane ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yezin taanii yinttis ohine; Eeliyaasa yi7ida; mahi E baz Geeshi Maxaafite xaafinttidannigaara, asuntsi eella afa fa koydanno oochchida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuusan, hyaydzdzuntsi tamaaruntsago maaqqii ye7ize wode gaama asuntsi un kale eqqiduntsanan higge asttamaare maaqqide eerats asuntsi unttara lallizanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yinna gaama asuntsi Yesuusa bi7ide wode gaama qoppii, ellisii eego woxxii yi7i, eza sarotsida. ");
INSERT INTO oydl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuusa, Xaafuntsago «Unttara akko lalle?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yentsi gaama asunts giddappa fettii atstse mahi, «Asttamaarizayo, ta na7aylla afa ohinttodanno kayze tuna ayyaana yeze gisho eza neego ekkii yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Hyay tuna ayyaanze eza aykkide wode ubba, eza guuddii olane; E donttira dubba ye7ine; mahi achchi garccizane; gallitan minggane. Eeppa hyay tuna ayyaanza kessode gaar, ne tamaaruntsis ohida, yezin kessodes un dandda7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesuusa mahi unttago, «Ammanoose hyanna wode asuntso! Taanii yinttara ayde yellodes yessade? Mahi yinttana ayde yellodes dandda7ode? Na7aya taas hyanka ekkii yo7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Unttii na7aya eego ki7ida; ye tuna ayyaanze Yesuusa bi7ide fana na7aya goqizida; na7ay sa7a gol7i, doonara goppuntto cuttitera gol7inttida. ");
INSERT INTO oydl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuusa ye na7ay adaygo, «Hyay ne na7aya aykkidannippa wantsi wode maaqqade?» yaga7i oocida. Na7ay aday, «E eerats yezin aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eza wodhodes gaama wode taman hyaatsan olane, yezin nees dandda7inttiko, nuus yiqsinttoya, nuna maaddoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuusa eego, « ‹Ne dandda7iko gaane?› Ammanze oodesin ubba bazi dandda7inttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ellisii na7ay aday fa qaaltto dhoqi yiizii, «Taanii ammanane, yezin gujjii ammanode gaar tana maaddoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuusa asunts gaanggi gaanggi hyanggizanno bi7i, tuna ayyaanza, «Hyay tullen muume ayyaanzayo, hyay na7ayppa kezo ga7i nena ta kiittane; mahi lam7intsa E gidda gelippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ye tuna ayyaanze uukki, na7aya gaama goqizii, eeppa kezida. Na7ay hyayqqide gaara yi7in, gaama asuntsi, «Na7ay hyayqqida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yezin Yesuusa na7ay kushito aykkii dentsin, na7ay denddii eqqida. ");
INSERT INTO oydl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuusa keetstsa gelidannippa suuba E tamaaruntsi, «Nuunii ye tuna ayyaanza kessodes akkos dandda7ikaaya?» yaga7i Yesuusa shaakkii dumma oocida. ");
INSERT INTO oydl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesuusa mahi, «Yinnii gaarize woosaran xoomaran fattin melle bazara kessades dandda7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Unttii yinna bestippa denddii, Galilara aadhii qitida; Yesuusa fa yeze bestto ooden erode gaar koykaaya. ");
INSERT INTO oydl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","E fa tamaaruntsago, «As Na7aya, asi asis aatsii inggoda wodhoda; E hyaydzdzii qammappa suuba, hyayqoppa denddoda» yaga7i tamaarssitera yene. ");
INSERT INTO oydl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yezin unttis E gaazanna gelikaaya; mahi eza oocodesin zhashtida. ");
INSERT INTO oydl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Unttii Qifirnahoome katama hyanggi keetstsa gelidannippa suuba Yesuusa unttago, «Oge akkos lalle?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yezin un, «Nu gidda ubbappa aadhode oode?» yaga7i lallide gisho si77i gayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesuusa bettii, taphpho lam77i tamaaruntsana xeegii, «Ooden tiino aadhodes koyko, ubbappa suuba aadhii, ubbuntsis aro maaqqades beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Fettii eeratsi na7a ekkii, un gidda essida; ye eerats na7aya iringgi unttago, ");
INSERT INTO oydl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Hyantses gaar eerats na7untsappa feta ta suntsite mokkize ooden tana mokkane; mahi tana mokkize ooden tana kiittezayan mokkanep attin tana xalaala mokkoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wahannisa, «Asttamaarizayo, fettii asi ne suntsite tuna Ayyaana kessodera nuunii bi7i, nu bagga maaqqoosse gisho eza kayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yezin Yesuusa, «Ooden ta suntsite Xoozii oochchize gaama qofize baz oochchii, ellisii taalla afa iita baz ohinttodes dandda7ize baayze gisho kayppete. ");
INSERT INTO oydl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nu baz ixxoose atstse nu bagga. ");
INSERT INTO oydl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taanii yinttis turo ohine; yin taasuntsana maaqqide gisho ooden yinttis ta suntsite hyale hyaatsi ushshades inggikon, fa anjjito ekkoda. ");
INSERT INTO oydl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Tana ammanze hyantsi eeratsuntsappa feta balitstsize ooden, gaacize damma woxa fa afurtte accii, Abba gidda gelizako ees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ne kushita nena balitstsizako, gachchii olo. Neenii lam77i kushera dhaboose gaanname tama olinttodannippa, duuxutsi kushera de7o gelzako nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Gaanname zaqiltta hyayqoosse taman dhaboose bessi. ");
INSERT INTO oydl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne tohita nena balitstsizako, gachchii olo. Neenii lam77i tohera gaanname tama olinttodannippa, duuxa maaqqii de7o gelizanna nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Gaanname zaqiltta hyayqoosse taman dhaboose bessi. ");
INSERT INTO oydl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne aafta nena balitstsizako, woocii kessii olo. Neenii lam77i aafera gaanname tama olinttodannippa, fettii aafera Xoozze ka7itumo gelizanna nees lo77o. ");
INSERT INTO oydl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ize zaqilttan hyayqqoos, tamttan dhaboos. ");
INSERT INTO oydl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Zharsho soogera geezhanni fana asi ubba tamara geeshshada. ");
INSERT INTO oydl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sooge lo77o, yiikon E mal7anxi ixxiko, mahi wayzi mal7issade? Yin gidda sooge yesse. Yi7i fetay fetayra sarora yezote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuusa yinnippa denddii, Yihuda sa7a hyanggi Yorddaanosa borkka fiinggida. Gaama asuntsi mahi eego shiiqin, tiinosttifana yentsi asuntsana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fettii fettii Farisaawuntsi fattanodes koyi Yesuusa, «Fettii asi fa machchito dakkode gaar Muse higgita kiittane?» yaga7i eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E mahi, «Muse yinttana waaga7i kiittido?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Unttii, «Muse, ‹Fettii asi fa machchitis dafo warqqate inggi dakko› gayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuusa mahi, unttana «Yin ohin si7oosuntsana maaqqide gisho Muse hyanna kiitto yinttis xaafida. ");
INSERT INTO oydl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yezin Xoozii tiino medhdhize wode dhiiratsin maachon mahi medhdhida. ");
INSERT INTO oydl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yinnii gisho, fettii asi fa adayan fa intton ashshii, fa machchitira wolla yezane. ");
INSERT INTO oydl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Un lam77untsi fettii asho maaqqane; yikkeppa, un fettii asho maaqqanep attin lam77i asi maaqqoos. ");
INSERT INTO oydl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yinnii gisho, Xoozii accidanno asi shagippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Un kara maaqqide wode E tamaaruntsi hyanna ohiti baz Yesuusa lam7intsa oocida. ");
INSERT INTO oydl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesuusa unttago, «Fa machchito dakkii melle ekkize ooden olalane. ");
INSERT INTO oydl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mahi machchitan fa azinzeppa kezii melle azinii geliko olalida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesuusa eerats na7untsana bochchode fana, fettii fettii asunts na7untsana eego ki7ida, yezin E tamaaruntsi yentsi asuntsana kaccida. ");
INSERT INTO oydl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuusa yinno bi7i, fa tamaaruntsana kaccii; unttago, «Eerats na7untsi taago yi7izanno kayppete; Xoozze ka7itumo yentses gaarzuntsis. ");
INSERT INTO oydl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taanii yinttis turo ohine; Xoozze ka7itumo eerats na7a fana ekkoosse atstse ooden yinna ka7itumtto mulon geloos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eerats na7untsana iringgi, fa kushito fetella fetella afa gaddii anjjida. ");
INSERT INTO oydl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuusa qitodes kezide wode fettii atstse woxxii yi7i, E tiintte bunqqunttii, «Keeha asttamaarzayo, medhina de7o laattodes taanii akko oochcho?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesuusa, «Akkos tana keehizayo ga7i xeege? Xoozze xalaalap attin melle keeha ooden baaya. ");
INSERT INTO oydl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xoozze kiitto, wodhippe; olalippe; kaystippe; worddo markkidhippe; il7antsite laammippe; ne adayan ne intto bonchcho yagaazanno erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Atstse, «Asttamaarizayo, taanii yinno ubba na7atitsappa aykkii hyayno yellodes naagane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuusa atstsa dakkii bi7i kadhida; «Nees fettii bazi faccane; hyanggi nees yeze baz mulo bayzi, yinna birtto dahuntsis inggo; neenii salo duridhdhada. Yeyzi maaqqii tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yezin atstse yinno si7i, E gaama dure maaqqide gisho fa sintto kartsii, ufayttikaayzara ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuusa fa tamaaruntsana wututsii dakkii bi7i, «Dure asi Xoozze ka7itumo gelodanna wayzi madhodyessa!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","E tamaaruntsi E timirttite gaama qoppida. Yezin Yesuusa mahi unttago, «Na7untso, Xoozze ka7itumo gelodanna wayzi madhodyessa! ");
INSERT INTO oydl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dure asi Xoozze ka7itumo gelodannippa, gimale marppe uruntsara aadhizanna laafane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","E tamaaruntsi gaama qoppii, «Yeezin, oode attode?» yaga7i, fete feta oocida. ");
INSERT INTO oydl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesuusa unttana dakki bi7i, «Hyanna Xoozzes dandda7inttanep attin asis dandda7inttoos; Xoozzes ubba bazi dandda7inttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phexiroosa Yesuusago, «Ero; nuunii nu baz ubba ashshii, nena kaallane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesuusa «Taanii yinttis turo ohine; ta gishon Wonggele gishon keetsito woy ishuntsana woy mishuntsana woy adaya woy intto woy machchito woy na7untsana woy oochchize gadito ashshize ooden, ");
INSERT INTO oydl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hyatte hyanna wodite xeet kushe keetsito, ishuntsana, mishito, intto, na7untsana, oochchize gadito, baytstsara wolla ekkoda. Tiinoppa ye7ode woden medhina de7o ekkoda. ");
INSERT INTO oydl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yezin gaamuntsi tiino maaqqiduntsi suub maaqqada, mahi gaamuntsi hyatte suub maaqqiduntsi tiino maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuusaran E tamaaruntsara Yerusalaame hyammadera, Yesuusa fa tamaarunts tiintte yedhdhane. Un gaama qoppida. Eza kaallizuntsin zhashtida. Lam7intsa, taphpho lam77i tamaaruntsana gaxa kessii, fana yellode baz shagii unttago hyannigaara yaga7i ohida. ");
INSERT INTO oydl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Hyaychche, nuunii Yerusalaame hyatte kezane. Ize As Na7ay, kahinunts hyalaquntsisin higge asttamaaruntsis aatsii ingginttoda. Unttii eella afa hyayqo firdda firddoda; mahi Ayhude maaqqoosse asuntsis eza aatsii inggoda. ");
INSERT INTO oydl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ye Ayhude maaqqoosse asuntsi eza leqqoda, eella afa cuttoda, allanggara garaafoda wodhoda. E hyaydzdzii qammappa suuba, hyayqoppa denddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zabdoosa na7unts Yayqooban Wahannisa Yesuusago yi7i, «Asttamaarizayo, nuunii nena woossize fettibaz nuus oochchoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesuusa unttago, «Taanii yinttis akko oochcho?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Unttii, «Neenii ne bonchcho ka7itumtte bettize wode nuuppa feta mizaqi zalara mahi feta workkita zalara betitsoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yezin Yesuusa unttago, «Yinttii akko woossizako eroos, ta ushshades yeze xuu7a ushshades dandda7odate? Mahi taanii xammaqinttodes yeze xinqqatto xammaqinttodes dandda7odate?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Un mahi, «Ye dandda7oda» yagayda. Yesuusa mahi, «Turo ta ushshades yeze xuu7a yin ushshada, taanii xammaqinttodes yeze xinqqatto yin xammaqinttoda. ");
INSERT INTO oydl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yezin taappa mizaqi zalaran workkita zalara bettoduntsana doorodes taas adetits wolqqa baaya, yezin yinna bessita Xoozii immades giigizii gaddiduntsis» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Attiduntsi taphphi tamaaruntsi yinno si7ide wode Yayqooballan Wahannisalla shenidhdhida. ");
INSERT INTO oydl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesuusa unttana ubba faago xeegii, «Ayhude maaqqin Ayhude maaqqoosse asunts hyalaquntsi worzha ahizuntsana ga7intti xeeginttizuntsanan ahizuntsis worzhuntsalla afa adetits wolqqa yezanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yezin yin gidda yinnii fana maaqqades beezoos; yin gidda damma maaqqades koyze ooden yinttis aro maaqqades beezane. ");
INSERT INTO oydl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mahi yin gidda ubbappa aatsii maaqqades koyze ooden yin ubbuntsis aro maaqqades beezane. ");
INSERT INTO oydl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Melle atto yezin, As Na7ayin, as maaddodesin gaamuntsana ashshodes fa shemppito aatsii immades yi7idap attin asi ees oochchode gaar yi7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Unttii Iyaarkko katama hyanggida. Yesuusa fa tamaaruntsaran gaama asara Iyaarkkoppa kessadera, Ximoosa na7a, qooqize, Barxximoosa ga7inttize, oge gaxa woossittera bettida. ");
INSERT INTO oydl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barxximoosa, yeygara aadhize Naazirete Yesuusa maaqqidanno si7ide wode fa qaaltto dhoqi yiizii, «Dawute na7a Yesuusa, tana maaroya!» yaga7e aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gaama asuntsi eza, «si7i ga7o!» ga7i kaccida. Yezin, E fa qaaltto kasennippa gaama dhoqi yiizii, «Dawute na7ayo, tana maaroya!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesuusa eqqii, «Eza hyankka xeegote» yagayda. Unttii qooqizego, «Akko baaya, denddii eqqo, nena xeegane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Qooqize fa ma7ito olii ashshii, doollii denddii eqqii, Yesuusago hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuusa, «Taanii nees akko oochchode gaar koye?» yagayda. Qooqize, «Asttamaarizayo, ta be7ades koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuusa eego, «Qito, ne ammantta nena fatstsida» yagayda. Iira E aafta bi7in, Yesuusa kaallida. ");
INSERT INTO oydl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Un Yerusalaame ukkitera, Shamahe Derize kale yeze Beetefaagen Bitaaniya katamito yellida. Yesuusa fa tamaaruntsappa lam77untsana tiino dakkii, ");
INSERT INTO oydl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«Yinttappa tiino yeze kara gancce qitote; ize gelide gaar ooden toggii bi7ikaayze acinttii yeze hyare na7a yin denggoda, eza billii, hyayga ekkii yo7ote. ");
INSERT INTO oydl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ooden yinttana, ‹Hyanno akkos oochche?› yaga7i oociko, ‹Laatstsii eza koyane, ellisii eza hyankka dakkoda› ga7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Un hyanggi, hyare na7aya bale oge kale acinttii yezaya denggi billida. ");
INSERT INTO oydl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yinna besite eqqide fettii fettii asunts unttago, «Hyare na7aya wayssades bille?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","E tamaaruntsi Yesuusa fana kiittezanno ohin, asunts ashshii ashshida. ");
INSERT INTO oydl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Unttii hyare na7aya Yesuusago ki7i, fa ma7ito E bantte yiixxin Yesuusa ye hyare na7aya toggida. ");
INSERT INTO oydl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gaama asuntsi fa ma7ito ogite yiixxida; mahi melluntsi minxa tashe shaqqii, ogite yiixxida. ");
INSERT INTO oydl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesuusappa tiino yedhdhize asuntsin eza kaallize asuntsi fa qaaltto dhoqi yiizii, «Hosaana! Laatstse suntsite ye7ize anjjinttidaya. ");
INSERT INTO oydl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ye7ize nu aday Dawute ka7itumtta anjjinttidanno. Hosaana! Salo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuusa Yerusalaame hyanggi, Xoozze Keetstsa gelida. Mahi ubbabazito wutii bi7idannippa suuba, sa7ita qammize gisho taphpho lam77i tamaaruntsara Bitaaniya katama qitida. ");
INSERT INTO oydl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wonttistti wode un Bitaaniyappa kezii hyammadera, Yesuusa nayzida. ");
INSERT INTO oydl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hyaakora fettii belese minxitis zhil7o hyaye yezanno bi7i, Iilla afa aafe benttiko ga7i, be7ades izigo hyanggida, yezin izigo E hyanggize wode hyaye xalaalap attin fettii aafen denggikaaya; akkos gayko, belese aafze wode yellikaayze gisho. ");
INSERT INTO oydl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesuusa yinna belesito, «Yikke, neeppa asi aafe miippe» yagayda. E tamaaruntsi E gaazanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Un Yerusalaame qitida; Yesuusa Xooze Keetstsa gelii, ize bayzizuntsanan wonggizuntsana bale bay7e aykkida; mahi bira laammizuntsana xarphezan wolle bayzizuntsana oyda dakkii olii, ");
INSERT INTO oydl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","asi akko bazin tookkii, Xoozze Keetstsa giddara aadhaame fana kayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesuusa asuntsana hyannigaara yaga7i tamaarssida: «Geeshi Maxaafite, ‹Ta keetsita asi ubba Xooz woossize keetstsi maaqqada› ga7intti xaafinttida. Yezin yinttii izo faanno aachinttize wom7o mahida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kahinunts hyalaquntsin higge asttamaaruntsi yinno si7i, eza wodhodes oge koye aykkida. Yezin gaama asuntsi E timirttite gaama qoppize gisho ees zhashtida. ");
INSERT INTO oydl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa7ita ugurize wode Yesuusan E tamaaruntsin katamappa gaxa kezida. ");
INSERT INTO oydl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Un wonttistti wode yinna ogitira aadhitera, yinna belesta xaphora melidaanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phexiroosa tiirii, «Asttamaarizayo, yikke, neenii baaddide belesita melida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesuusa mahi, «Xoozza ammanote. ");
INSERT INTO oydl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taanii yinttis turo ohine; ooden fa wozintte so7ikaayzara gaydebazi hyanodanno ammanii, hyay deriza, ‹Denddii Abba wodhdho› yagayko ees hyanoda. ");
INSERT INTO oydl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yinnii gisho, taanii yinttis ohine; Xoozza yin woossize bazin oocizebaz akko maaqqikon ekkide gaara ammanote, yin ekkoda. ");
INSERT INTO oydl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Xooz woossodes yin eqqize wode salo yeze yin Aday yin nagartto atto gawude fana, ooden yinttana naaqqidebaz yeziko, ees atto ga7ote. ");
INSERT INTO oydl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yezin as nagara yin atto ga7anxi ixxiko, salo yeze yin Adayn yin nagartto yinttis atto ga7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Un mahi Yerusalaame hyanggida. Yesuusa Xoozze Keetstsa hyanttodera, kahinunts hyalaquntsi, higge asttamaaruntsin cimuntsi eego yi7i, ");
INSERT INTO oydl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«Neenii hyanno oochchodes nees akko adetits wolqqa yeze? Woy nees hyanna adetits wolqqito inggide oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuusa mahi unttago, «Ta yinttana fettibaz oocoda, taas ohote. Ta mahi hyanno akko adetits wolqqara oochchizako, yinttis ohoda. ");
INSERT INTO oydl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wahannisa xinqqata Xoozappane woy asappa? Taas ohote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Unttii fa gidda lalle aykkii, «Nuunii, ‹Xoozappa› gayko, E nuugo, ‹Yeezin, Wahannisa ohizanno akkos ammananxido?› yagawuda. ");
INSERT INTO oydl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹Asappa gayko› asi ubba Wahannisa nabe maaqqizanno erane.» Maaqqide gisho asuntsis zhashtida. ");
INSERT INTO oydl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yinnii gisho, unttii Yesuusago, «Nuunii eroos» yaga7i mahida; Yesuusa, «Taanin hyanno akko adetits wolqqara oochchizako, yinttis ohoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuusa unttis aazizera yaga7i ohida; «Fettii atstse woyne atakiltte tukkii, gaxito wututsii gase gasida. Mahi ye woyniza cicize ollan bookkida. Eza kafodes pharggo shakko shakkida. Yinnippa suuba, kotstse oochchize asuntsis inggi, melle sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Woyne aafta diilii maxize wode yellin, fana yellizanno ekkii ye7ode gaar, fettii fa ariza kotstse aduntsago kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kotstse ekkide asuntsi E ariza aykkii hyadhdhii, hyarii kushe dakkida. ");
INSERT INTO oydl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lam7intsa melle aro unttago kiittin, un ye arizes ommito shuchchara qawuxii kawushizii dakkida. ");
INSERT INTO oydl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Woyne taakilte laatstsay mahin melle aro kiittida. Ye ariza wodhida, mahi melle gaamuntsana yinnii gaara yeyzida, feta feta hyadhdhii, melluntsana wodhida. ");
INSERT INTO oydl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Woyne atakiltte laatstses kiittodes ubbappa lasite E gaama kadhize fa na7aya dakkodanna xalaala attida. E, ‹Un ta na7aya bonchchikaayzara ashshaama› ga7i, fa na7aya unttago kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Yezin kotstse aduntsi fa gidda, ‹Laattoday hyaya; yedhdhote eza wolla wodhoda; E laatita nuus maaqqada!› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na7aya aykkii wodhii, E ahito woyne atakiltte giddappa gaxa kessii olida. ");
INSERT INTO oydl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Yikke, woyne atakiltte laatstsay wayssade? Yi7i yentsi kotstse aduntsana wodhii hyaasii, woyne kotstse oochchize melle asis inggoda. ");
INSERT INTO oydl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","« ‹Keexizuntsi leqqii ixxide shuchchize Keetsiti mayzentto xaalize, ubbappa aadhize mintsi shuchchi maaqqida. Hyanno Laatstsii oochchidebaz; mahi nu aaftisin gaama qofize baz yagaazanno Geeshi Maxaafeppa nabbabika?› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kahinunts hyalaquntsi, higge asttamaaruntsin cimuntsi Yesuusa yinna aazizito unttalla afa ohidanno eride gisho eza aykkodes koyda, yezin asuntsis zhashtii, ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mahi yinna ohitippa bala denggi, eza aykkode gaar, Farisaawuntsappa Heroodisa bagguntsappa eerats asuntsana eego kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Unttii eego yi7i, «Asttamaarizayo, neenii turibaz ohinttizanno asappa as shaakkoosanno nuunii erane. Neenii as shaakkoos; mahi Xoozze ogito turetitsara tamaarssane. Nuunii Roome gade Kaat Qeesares giira giirizanna likken likke baa? Giira giironene ashshone?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yezin un cubbotitsito Yesuusa erii, «Tana akkos fattane? Ane fettii santime tana beezote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Unttii ees ki7ida, «Hyanna bishshitan suntsita oodeso?» yaga7i unttana oocida. Unttii, «Qeesares» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuusa mahi, «Yeezako, Qeesarestto Qeesares, Xoozzesito Xoozis inggote» yaga7in un E baz gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hyayqqide asi denddoos gaaze Saduqaawuntsappa fettii fettii asuntsi Yesuusago yi7i, hyannigaara yaga7i, eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Asttamaarizayo, Muse nuus higge xaafittera, ‹Machcho ekkide asi na7a yelikaayzara hyayqqiko, ye hyayqqide ishe E machchito ekkii, fa ishes na7a yelodes beezane› yagaazanno xaafida. ");
INSERT INTO oydl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Zaga wode laappun ishuntsi yezuntsappa anggisse machcho ekkii, na7a yelikaayzara hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lam7antsize izo ekkida, ezin na7a yelikaayzara hyayqqida. Hyaydzantsize yinnii gaar yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Laappununtsin yinnii gaara izo ekkii, na7a yelikaayzara hyayqqida. Ubbappa suuba, mahi yinna maachita hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yeezin, laappununtsi mulo izo ekkide gisho hyayqqide asuntsi hyayqoppa denddide wode, iza unttappa aayyes machcho maaqqade?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuusa mahi, «Yinttii balinttizanna, Geeshi Maxaafito woy Xoozze wolqqa erikaayze gisho! ");
INSERT INTO oydl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hyayqqide asuntsi hyayqoppa denddide wode, salo yeze kiitanchcho maaqqanep attin dhiiratsin ekkoos; maachan geloos. ");
INSERT INTO oydl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yezin hyayqqiduntsi denddebaz maaqqiko, Muse maxaafite xaafinttide eexize hyaburtutibaz ohize besite, Xoozii Musego, ‹Taanii, Abrahama Xoozii, Yisaaqa Xoozii, Yayqooba Xoozii› gaydanno nabbabikate? ");
INSERT INTO oydl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yinnii gisho, E, shemppora yezunts Xoozap attin hyayqqiduntsi Xoozii baaya. Yin gaama balida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Higge asttamaaruntsappa fete un lallizanno shiiqii si7ida. Mahi Yesuusa unttis loytsii mahidanno si7i, «Kiita ubbappa aadhize kiitta aanno?» yaga7i Yesuusa oocida. ");
INSERT INTO oydl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuusa mahi, eego hyannigaara yagayda: «Kiita ubbappa aadhize kiita si7ote; ‹Isra7eele asuntso, Laatstse nu Xoozze fettii Laatstsii. ");
INSERT INTO oydl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ne Laatstsa ne Xoozza ne kumutsi wozinappa, ne kumutsi shemppoppa, ne kumutsi qofappa, ne kumutsi wolqqappa kadho› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mahi kiita ubbappa aadhize lam7intsa kiitize; ‹As ubba ne ommiti gaar kadho› yagaazanno; hyantsesappa aadhize melle kiita baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Higge asttamaarize Yesuusago, «Asttamaarzayo, turo gayda; neenii ‹Xoozii fettii Xoozii xalaala. Eeppa melle baaya› gaydanna turo. ");
INSERT INTO oydl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xoozza kumutsi wozinappa, kumutsi qofappa kumutsi wolqqappa kadhizannon mahi as ubba fa ommiti gaar kadhizanna, michchize zharshoppan melle zharsho ubbappa aadhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuusa higge asttamaarize mahidanna aadhize era as mahe maaqqidanno bi7i, «Neenii Xoozze ka7itumoppa hyaakkikaaya» yagayda; yinnippa suuba, Yesuusa mellebaz oocodes ooden miinggikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuusa Xoozze Keetstsa tamaarssite, hyannigaara yagayda: «Higge asttamaaruntsi Kiristtoosa ‹wayzi Dawute na7a ga7e?› ");
INSERT INTO oydl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawute Geeshi Ayyaanara kaallii, « ‹Laatstsii, ta Laatstsaya, «Taanii ne morkkuntsana ne tohita yedhdhize bessi mahode wontsis, hyanne taappa mizaqi zala betto» gayda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawute fa ommite Kiristtoosa, ‹Laatstso› ga7i xeegiko, yeezin, Kiristtoosa wayzi, Dawute na7a maaqqe» yagayda. Gaama asuntsi Yesuusa gaazanno ufaytti si7ida. ");
INSERT INTO oydl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuusa tamaarssitera, hyannigaara yagayda: «Higge asttamaaruntsappa naaginttote; un pharggo ma7o ma77i wutizannon gaben asi unttana bonchchii sarotsizanno koyane. ");
INSERT INTO oydl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Unttii Ayhude woosa keetstsa gaama lo77o oyda koyane; mahi asi fana mokkize bessa bonchcho bessi koyane. ");
INSERT INTO oydl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Un budan keetstsi bonqii, fana beessades pharggizii woossane; un ubbappa aadhize firdda ekkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuusa Xoozze Keetstsa muxaate olize saaxine kale bettii, asuntsi fa birtto yinna saaxintte olizanno bi7ida; gaama dure asuntsi gaama bira yinna saaxintte olane. ");
INSERT INTO oydl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Fettii daha budantta yi7i, lam77i sikkinna yinna saaxintte olida. ");
INSERT INTO oydl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuusa fa tamaaruntsana xeegii, «Taanii yinttis turo ohine; muxaate saaxintte olide asunts ubbappa hyanna daha budantta gaantsi olida. ");
INSERT INTO oydl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Akkos gayko, melluntsi ubba faas kumii attide birappa olane. Yezin iza fa facitippa, faas yeze qoltto ubba inggida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuusa Xoozze keetstsappa kessadera, E tamaaruntsappa fete, «Asttamaarizayo, hyanna lo77o shuchchiton hyanna lo77o shuchchi keetsito be7ine!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuusa mahi, «Hyanna damma shuchchi keetsito be7ine? Hyanna keetsita shuchchi shuchchalla afa gimbbinttide fana wul7inttikaayzara attoos; fettii shuchchin attikaayzara ubba wul7inttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuusa Xoozze keetstsappa seko zalara Shamahe Derizella afa bettezin, Phexiroosa, Yayqooba, Wahannisan Inddiriyase eego yi7i, ");
INSERT INTO oydl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Hyanna ayde yi7adyezako, nuus oho; hyanna ubba folinttodes wodito erisize mallita akko?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuusa mahi unttago hyannigaara yaga7i ohida: «Yinttana ooden balitsaame fana naaginttote. ");
INSERT INTO oydl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gaama asuntsi ta suntsite, ‹Taanii Kiristtoosa› ga7i gaama asuntsana balitstsoda. ");
INSERT INTO oydl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Olan ola wore si7ize wode yirggippete. Yinnii gaarize hyanodes beezane, yezin wurssutsita hyaga. ");
INSERT INTO oydl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Fettii gade asuntsi melle gade asuntsara olinttoda; mahi fettii ka7itumo melle ka7itumora olinttoda; sa7a eni7e ubba bessa hyanoda; naye yessada, yezin yinna ubbanna yelo zooqe fana. ");
INSERT INTO oydl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Yezin yinttii, yin ommite naaginttote. Akkos gayko, asi yinttana aykkii, firdda keetstsis aatsii inggoda; mahi Ayhude woosa Keetstsiten yinttana alanggara garaafoda; gade ahizuntsii tiinon kaatuntsi tiino ta gisho yin markkidhades eqqoda. ");
INSERT INTO oydl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wurssutsita yellodannippa tiino Wonggele asi ubbas ohinttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Unttii yinttana firdda keetstsa ki7ize woden aatsii inggize wode waagii ohodyezako tiino yirggippete; yinna saate Xoozii yinttis inggide baz ohote. Yin gidda Geeshi Ayyaana ohinep attin yinttana baaya. ");
INSERT INTO oydl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«Ishe fa isha, aday fa na7aya wodhissada. Na7untsi fana yeliduntsalla denddii, unttana wodhoda. ");
INSERT INTO oydl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Asi ubba yinttana ta suntsiti gisho ixxoda, yezin wurssutsi yellodes miinggide attoda. ");
INSERT INTO oydl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Yezin dhabsize tunize eqqodes beezoosse bessa eqqezin yin be7ada.» Yinna akko ga7inttizako nabbabize akaako! «Yihuda sa7a ye wode yezuntsi derego woxxii aachintto. ");
INSERT INTO oydl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bale yeze keetstsa gelii keetstsappa fettibaz ekkodes gode, fa keetstsa gelippe. ");
INSERT INTO oydl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gade yeze fa ma7ito ekkodes suuba maaqqippe. ");
INSERT INTO oydl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ye wode wodatsi maachuntsisin dhantsize maachuntsis gaama madha maaqqada. ");
INSERT INTO oydl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yezin hyanna ubba hyanize wodita seete maaqqaame gaar, Xooz woossote. ");
INSERT INTO oydl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Akkos gayko, Xoozii alamito medhdhide woditippa aykkii, hyayno yellodes hyanikaayze madhan tiinosin hyanoosse kille madha asalla afa ye wode hyanoda. ");
INSERT INTO oydl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Laatstsii yinna qammiti faydito eeritsikaayzako, asi maaqqide ooden attoos. Yezin E fa dooride asunts gisho yinna faydito eeritsane. ");
INSERT INTO oydl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Ye wode ooden yinttana, ‹Yikke, Kiristtoosa hyanne yene woy Kiristtoosa sekka yene› yagayko, yinno ammanippete. ");
INSERT INTO oydl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Worddo Kiristtoosan worddo nabuntsi denddii faas dandda7inttiko, melle atto yezin Xoozii dooriduntsappa balitstsode wontsis kille bazin gaama qofize baz beessada. ");
INSERT INTO oydl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yezin yinttii naaginttote, taanii yinttis ubba baz tiinidhii ohida. ");
INSERT INTO oydl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Yezin ye wode yinna madhitippa suuba, «Awa dhumoda; agina foo7ito ashshoda; ");
INSERT INTO oydl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Xoolinttuntsi saloppa gol7oda; mahi salo yeze wolqqitan en7oda. ");
INSERT INTO oydl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ye wode As Na7ay, damma wolqqaran bonchchora dhonne giddara ye7odera un be7ada. ");
INSERT INTO oydl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ye wode E kiitanchchuntsana kiittoda. Oyddii zala sa7a gaxappa salo gaxa yellodes, Xoozze dooride asuntsana shiishoda. ");
INSERT INTO oydl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Aaziztto belese minxappa tiirote; belesta aacize wode I hyayta cil7e aykkide wode torchche yellidanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yinnii gaar, yinttii yinna ubba bazita hyanizanno be7ize wode ukkii furtsa yellidanno erote. ");
INSERT INTO oydl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taanii yinttis turo ohine; hyanna ubba bazita hyanode wontsis hyanne yeze asuntsi ubba hyayqqoos. ");
INSERT INTO oydl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Salon sa7an aadhoda, yezin ta qaaltta mulon aadhoos. ");
INSERT INTO oydl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Yezin yinna qammiton yinna saatto Aday xalaalap attin melle atto yezin salo yeze kiitanchchuntsana maaqqikon woy Na7aya maaqqikon ooden erize baaya. ");
INSERT INTO oydl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yinna wodita ayde maaqqizako, yin eroosse gisho naaginttoten minggote. ");
INSERT INTO oydl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta ye7ita fa keetsito ashshii, oge qitide atstse gaara. Atstsay fa aruntsis ommar ommar oocha inggi unttana oochitis ade mahida; mahi naagizen mintstsii naagode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Yinnii gisho, minggote. Akkos gayko, karttii aday ugure maaqqiko woy qamma bilahe maaqqin woy Lukule oollize wode maaqqin woy wontta gooda maaqqin ayde ye7ode yezako, yin eroos. ");
INSERT INTO oydl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yin tiirikaayzin E yi7i yinttana gentto yezin denggaame gaar minggote. ");
INSERT INTO oydl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Taanii yinttis ohizanno asi ubbuntsis ohine; minggote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Faasiga Ba7aale bonchchize qamman boora Ba7ale bonchchize qamma yellodes lam77i qamma attida. Kahinunts hyalaquntsin higge asttamaaruntsi asi erikaayzin Yesuusa genii aykkii wodhodes oge koyane. ");
INSERT INTO oydl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","«Asuntsi kachchi kessaame fana Faasiga bonchchize qammite yinno oochchoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuusa Bitaaniya katamite qursumara hyargginttide Simoona keetstsa munttalla afa bettezin, fettii maachita albasxiroose bilqqaaxe kumutsi narddoosa gaaze gaama al77o shitto ekkii yi7ida. Ye bilqqaaxiza mentsii shitto Yesuusa ommite gussida. ");
INSERT INTO oydl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yinna besite yeze asuntsappa fete fete zhilidhdhii, «Hyay shittiza cer hyarii lalizanna akkoso? ");
INSERT INTO oydl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hyay shittiza hyaydzdzii xeet dinaares bayzi, birtto dahuntsis immades dandda7inttane» yaga7i fa gidda ohinttida. Yeyzi, yinna maachito gaama leqqida. ");
INSERT INTO oydl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yezin Yesuusa «Hyanna maachito akkon ga7ippete; izo akkos waytsete? Iza taas lo77o baz oochchida. ");
INSERT INTO oydl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dahuntsi ubba wode yinttara yene. Yin koyeze wode ayden yin unttana maaddodes dandda7ane, yezin taanii ubba wode yinttara yezoos. ");
INSERT INTO oydl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iza fa dandda7idanno oochchida; mahi tana mooges giigisades tiinidhdhii shitto tizhida. ");
INSERT INTO oydl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Taanii yinttis turo ohine; sa7a ubbanne Wonggele ohinttize aban, asuntsi izo tiirode fana hyanna iza oochchidanna ohinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taphpho lam77i tamaaruntsappa fete Asqorootu Yihuda ga7inttize Yesuusa kahinunts hyalaquntsis aatsii immades unttago hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Unttii yinno si7eze wode ufaytti, «Nuunii nees bira inggoda» yagayda; Yihuda Yesuusa aatsii immades wottize wode koyane. ");
INSERT INTO oydl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Boora Ba7aale bonchchinttize tiino qamma, Faasiga katstsa ma7ades mara shukkize wode Yesuusa tamaaruntsi eego, «Faasiga bonchchize qamma ne ma7ade katstsa nu aba hyanggi giigisade?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuusa fa tamaaruntsappa lam77untsana hyannii gaara yaga7i kiittida: «Katama qitote; yin hyammadera, xuggara hyaatsi tookkii fettii atstse yinttara yellinttoda; eza kaallote. ");
INSERT INTO oydl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","E hyanggi gelize karttii adego, ‹Asttamaarize neego, «Taanii ta tamaaruntsara Faasiga ma7ades zaqqo keetstsita aba yene?» gayda› yaga7ote. ");
INSERT INTO oydl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Karttii adday yinttana fooqella yeze giigii bettide dalgga kifile beessada; yeyga giigizote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yentsi tamaaruntsi kezii, katama hyanggida; Yesuusa unttago ohidanni gaara denggi, Faasiga katstsa giigizida. ");
INSERT INTO oydl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Saata ugurize wode Yesuusa taphpho lam77i tamaaruntsara yeyga hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Unttii bettii katstsa ma7adera, Yesuusa unttago, «Taanii yinttis turo ohine; yinttappa fete taara mu7ize, tana aatsii inggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","E tamaaruntsi azzanii, fa ommite ommite, «Turo tana yessane?» yaga7i eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuusa mahi, «Ye atstse yin taphpho lam77untsappa feta; E taara fettilla fa kushito gabate dakkizaya. ");
INSERT INTO oydl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","As Na7ay, Geeshi Maxaafite hyayqqoda ga7idanni gaara hyayqqoda, yezin As Na7aya, aatsii inggize atstsa bade. Ye atstse yelinttikaayzar attezako ees lo77o yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Unttii ma7adera, Yesuusa boora ekkii, Xooz galatida; ye booriza baxxi, fa tamaaruntsis inggitera, «Hya7ate, hyanna ta ashito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xuu7a ekkii, Xooz galatii, unttis inggin ubbuntsin ye xuu7izeppa uzhida. ");
INSERT INTO oydl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesuusa, «Hyanna gaama asuntsi gisho goggize caaqo suutsi. ");
INSERT INTO oydl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taanii yinttis turo ohine; ta Xoozze ka7itumtte kille woyne ushshade qammita yellodes mahi hyay woynizeppa uzhoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mazmure yexxidannippa suuba Shamahe Derizella afa kezida. ");
INSERT INTO oydl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuusa unttago, «Yin ubba tana ashshii ashshii lalinttoda;» Xaafinttidanni fana, « ‹Xoozze duro yenggizaya wodhoda, duruntsi ubbanna lalinttoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yezin taanii hyayqoppa denddidannippa suuba yinttappa tiinidhii Galila aadhoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phexiroosa mahi, «Unttii ubbuntsi nena ashshii ashshii dhabikon, ta nena ashshoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuusa Phexiroosago, «Taanii nees turo ohine; hyayno qamma lukule lam77i tohe oollodannippa tiino ne tana hyaydzdzii tohe kaddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yezin Phexiroosa kasennippa mintstsii, «Taanii melle atto yezin, neera wolla hyayqqizakon, nena kaddoos» yagayda. Mahi melluntsi ubbuntsi yinnii fana gayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Geetesemaane gaaze bessa hyanggida; Yesuusa fa tamaaruntsago, «Taanii Xooz woossii maaqqade wontsis yin hyanne bettote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesuusa Phexiroosa, Yayqoobaran Wahannisa faara ekkii qitida; gaama waayintti un7inttida. ");
INSERT INTO oydl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Mahi unttago, «Taanii hyayqqode wontsis azzanida, hyanne gam7ote; genttippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eeratsi tiino shiiqii, sa7alla bunqunttii, dandda7inttize baz maaqqiko, hyanna waaye saata faappa aadhode gaar, Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Mahi, «Ababa, ta Adayo, ubba bazita nees dandda7inttane, hyanna waaye xuu7uto taappa hyaaso. Yezin ne qoftta hyanop attin ta qoftta hyanippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesuusa maaqqii yi7i, un genttezin denggi, Phexiroosago, «Simoona, genttida? Neenii fettii saaten barkki naagodes dandda7osa? ");
INSERT INTO oydl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Madha yin gelaame gaar barkki naagii Xooz woossote. Ayyaana giigida, yezin yin ashita labbitsi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mahika hyanggi tiinosttifana Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Fa tamaaruntsago suub maaqqii ye7ize wode genttezin denggida. Un aafto gentto goozii aykkide gisho E akko ohizakon eroos. ");
INSERT INTO oydl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hyaydzintsa unttago yi7i, «Hyanno yellodes genttii shemppolla? Yikke, maaqqada; saata yellida; bo7ote! As Na7ay, nagaranchcha asuntsis aadhii ingginttode wodita yellida. ");
INSERT INTO oydl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Denddii yedhdhote; bo7ote, tana aatsii inggoday yellida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuusa yinno hyaga ohodera, taphpho lam77i E tamaaruntsappa fete, Yihuda, ellisii yellii ashshida. Mahi kahinunts hyalaquntsi, higge asttamaaruntsin cimuntsi kiittin, mashshan gufen aykkii gaama asuntsi eera wolla yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesuusa aatsii inggiday yentsi gaama asuntsis, «Taanii yeerizay eza; eza aykkii, mintstsii naagii, ekkii kanggote» yaga7i malla ohi gaddida. ");
INSERT INTO oydl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yihuda yellii wodhdhide gaar Yesuusago shiiqii, «Asttamaarzayo» yaga7i Yesuusa yeerii ekkida. ");
INSERT INTO oydl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yentsi gaama asuntsi Yesuusa aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Yezin kale eqqiduntsappa fete fa mashshiza shoddii kahinunts hyalaqize ariza guuddii, E hyayza gachchii olida. ");
INSERT INTO oydl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuusa mahi, yentsi asuntsago, «Tana faanno mahi, faanno aykkzefana aykkodes mashshan gufen aykkii yi7idate? ");
INSERT INTO oydl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Taanii Xoozze Keetstsa tamaarsitera, ubba wode yinttara yeze wode tana aykkikaayzara, yezin Geeshi Maxaafite ga7idanna folinttodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","E tamaaruntsi ubbuntsi eza ashshii ashshii lalinttida. ");
INSERT INTO oydl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Laxana xalaala ma77ide fettii na7atitsi atstsa Yesuusa kaallizaya asuntsi aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yezin ye atstse laxinza ashshii ashshii, xira kallo woxxii qitida. ");
INSERT INTO oydl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Asuntsi Yesuusa kahinunts hyalaqize keetstsa kanggida. Ize kahinunts hyalaquntsi, cimuntsin higge asttamaaruntsi shiiqii yene. ");
INSERT INTO oydl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phexiroosa kahinunts hyalaqize woofa yellodes hyaakora eza kaallii hyanggi ize kiitinttizuntsara bettii tama kaazhane. ");
INSERT INTO oydl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kahinunts hyalaquntsin firdda shangguntsi ubba Yesuusa wodhodes eella afa markka koyda, yezin akkon denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gaama asuntsi eella afa worddo markkidhida, yezin un markkatitsita fetto baaya. ");
INSERT INTO oydl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Fettii fettii asuntsi denddii eqqii Yesuusalla, «E, ‹Taanii asi keexide hyanna Xoozze Keetsito lalii, asi kushera keexinttikaayze melle Xoozze Keetstsi hyaydzdzii qamma gidda keexxoda› ga7odera nuunii si7ida» yaga7i worddo markkidhida. ");
INSERT INTO oydl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Maaqqo yezin, un markkatitsita yinnan fetto baaya. ");
INSERT INTO oydl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kahinunts hyalaqize as ubbunts tiintte denddii eqqii, «Hyantses nena mootize mootis ne mahizebaz baa?» yaga7i Yesuusa oocida. ");
INSERT INTO oydl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yezin Yesuusa si77i gayda; akkon mahikaaya. Kahinunts hyalaqize, «Anjjinttide Xoozze Na7ay, Kiristtoosa nenane?» yaga7i mahi oocida. ");
INSERT INTO oydl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuusa mahi, «Yee tana, yin As Na7ay, wolqqaama Xoozzeppa mizaqi zalara bettezin mahi salo dhonnera ye7odera be7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kahinunts hyalaqize fa ma7ito feedhii, «Nuus melle markka akko koshshe? ");
INSERT INTO oydl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yin E cashito si7ida; yin qoftta akko?» yagayda. Un ubbuntsi, «E hyayqqodes beezane» yaga7i eella afa firddida. ");
INSERT INTO oydl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Unttappa fete fete eella afa cutte aykkida. E aafto goozii baqqittera, «Nena qoxxide oode? Ane nuus oho!» yagayda. Naagizuntsi eza guudditera kanggida. ");
INSERT INTO oydl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phexiroosa kahinunts hyalaqize woofa yeekka zalara yezin, kahinunts hyalaqize maachi aruntsappa fetta ize yi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Phexiroosa tama kaazhanno bi7i, dakkii loytsii bi7i, «Neenin Naazirete Yesuusara yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yezin Phexiroosa, «Ne gaazana akko yezakon ta eroosin, taas tiirinttoos» yaga7i kaddida. Yaga7i maaqqii woofa kezida iira lukule oollida. ");
INSERT INTO oydl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yinna arita Phexiroosa bi7i, E kale eqqide asuntsago, «Hyay atstsen unttara yene» ga7i mahi ohida. ");
INSERT INTO oydl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yezin Phexiroosa mahin kaddida. Eeratsi gam7odera, kale eqqide asuntsi mahi Phexiroosago, «Neenii Galila sa7a asi maaqqide gisho turo unttara yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yezin Phexiroosa, «Taanii yin gaaze atstsa eroos!» yaga7i fana baadditera caaqo aykkida. ");
INSERT INTO oydl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iira lukule lam7intsa oollii ashshida. Phexiroosa Yesuusa eego, «Neenii lukule lam77i tohe oollodannippa tiino hyaydzdzii tohe tana kaddoda» eego gaydanno tiirii yeekkida. ");
INSERT INTO oydl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wontta gooda ellisii kahinunts hyalaquntsi, cimuntsi, higge asttamaaruntsin firdda shangguntsi ubba shiiqii zorinttida. Unttii Yesuusa accii kanggi Philaaxoosas aatsii inggidda. ");
INSERT INTO oydl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philaaxoosa eego, «Neenii Ayhudunts kaati?» yaga7i oocida. Yesuusa mahi, «Ne gayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kahinunts hyalaquntsi Yesuusa gaama bazara mootida. ");
INSERT INTO oydl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yezin Philaaxoosa mahi Yesuusago, «Nees mahizebaz baa? Unttii neella akko mooto ke7izako bo7oso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yezin Yesuusa mellebaz mahanxi ixxin, Philaaxoosa gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Philaaxoosas Faasiga Ba7aale bonchchize qammite asuntsi koyze fettii asi achchappa billize woga yene. ");
INSERT INTO oydl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ye wode fettii Barbaana gaaze atstse kachchi dentsii shemppo wodhide asuntsara wolla achi keetstsa yene. ");
INSERT INTO oydl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gaama asuntsi Philaaxoosago yi7i tiinoppa yiizitera gam7ide fana oochchode gaar eza oocida. ");
INSERT INTO oydl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philaaxoosa asuntsana mahi, «Taanii yinttis Ayhudunts kaatiza billode gaar koyane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Yinno E ga7idanna, kahinunts hyalaquntsi Yesuusa qanaatii aatsii inggidanno erize gisho. ");
INSERT INTO oydl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yezin kahinunts hyalaquntsi E gisho Barbaana billode gaar, yentsi shiiqide asuntsi Philaaxoosa woossode gaar asuntsana zorida. ");
INSERT INTO oydl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philaaxoosa mahi, «Yeezin, yin Ayhude kaati gaazaya wayssa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asuntsi Philaaxoosalla afa uukki, «Masqalalla afa eza suxxo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philaaxoosa asuntsago, «Akkoso? E akko iita baz oochchido?» yagayda. Yezin asuntsi tiinostippa gujjii uukki, «Masqalalla eza suxxo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philaaxoosa asuntsana ufayssodes koyi, Barbaana asuntsis billida; yeyzi allanggara Yesuusa garafii, masqalalla afa suxxode gaar aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yinnippa maaqqii, wottaddaruntsi Yesuusa ekkii Piratoriya gaaze Poolis xaaba kanggi, melle wottaddaruntsana ubba fettilla xeegida. ");
INSERT INTO oydl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mahi zoqo afula eza mayzida; anggatsi zawude giigizii, E ommite gaddida. ");
INSERT INTO oydl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yinnippa maaqqii, eego, «Ayhudunts kaatizayo saro» yaga7i, kushe dentsida. ");
INSERT INTO oydl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","E ommite gufera guuddida; mahi eella cuttida; bunqquntii ees goynida. ");
INSERT INTO oydl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eza toochidannippa maaqqii zoqo afula eeppa qaarii ekkii, E afultto eza ma7isii masqalalla afa eza suxxodes ekkii kanggida. ");
INSERT INTO oydl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Un hyanggitera, Iskkinddirenen Rufoosa aday, Simoona gaaze Qereena sa7a asi, gaxareppa katama ye7izera yellintti, Yesuusa masqala wolqqara toossida. ");
INSERT INTO oydl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yeyzi Golggotta gaaze bessa Yesuusa kanggida. «Golggotta» gaazanna «Omma ota» ga7e. ");
INSERT INTO oydl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hyargaame fana karbbe gaaze gaalla worqqinttide woyne uzho ga7i ees inggida. Yezin E uzhanxi ixxida. ");
INSERT INTO oydl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Unttii masqalalla afa eza suxxida. Oona akko yellodyezakon ga7i E afultto shagii ixa olida. ");
INSERT INTO oydl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Un masqalalla afa eza suxxize wode wonttappa hyaydzdzii saate. ");
INSERT INTO oydl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Un, «Ayhudunts kaat» yaga7i eza mootize xuufe xaafii gaddida. ");
INSERT INTO oydl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesuusara lam77i faanuntsana feta eeppa mizaqi zalara hyankkaya eeppa workkita zalara masqalalla afa suxxida. ");
INSERT INTO oydl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Geeshi Maxaafite, «Iita baz oochchide asuntsara E faydinttida» ga7inttidanna folinttida. ");
INSERT INTO oydl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ogera aadhize asuntsi Yesuusa leqqii, fa ommito en7izi cazhida; «Zambbay! Xoozze Keetsito lalii hyaydzdzii qamma gidda keexizayo, ne ommito ashsho; ");
INSERT INTO oydl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ane masqalizeppa wodhdhii nena ashsho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yinnii gaara, kahinunts hyalaquntsi higge tamaarssizuntsara fettilla Yesuusa leqqii, «Melluntsana ashshida, yezin fana ashshodes dandda7oos; ");
INSERT INTO oydl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","nuunii bi7i ammanode gaar Kiristtoosa, Isra7eele Kaati, ane masqalappa hyatte wodhdho» yagayda. Mahi melle atto yezin, eera masqalalla afa suxunttiduntsappa eza leqqida. ");
INSERT INTO oydl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Izippun saateppa dentsii, uddufun saate yellodes sa7ita ubba dhumida. ");
INSERT INTO oydl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Uddufun saate Yesuusa fa qaaltto dhoqi yiizii, «Elohee, Elohee, laama sabaqitani?» yagayda. Yinnii bilitsita, «Ta Xoozayo, ta Xoozayo, tana akkos ashshido?» ga7e. ");
INSERT INTO oydl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ize eqqide asappa fete fete yinno si7i, «Yikke, Eeliyaasa xeegane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Yentsi asuntsappa fete woxxii, gurba fuzara caala woyne baazhii; gufe bertstsalla gaddii, «Naagote; Eeliyaasa masqalappa eza ketstsodes ye7odyezako ane bo7oda» yaga7i Yesuusa doonago ushshodes shiishida. ");
INSERT INTO oydl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesuusa fa qaaltto dhoqi yiizii uukki, hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Xoozze Keetstsa suxunttide magaraajita wokkappa sulle gaxa yellodes, lam77i kezii feedhinttii wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Masqalzeppa tiino zalara ize eqqide fettii mato hyalaqize, Yesuusa wayzi hyayqqezako bi7ide wode «Hyay atstse turo Xoozze Na7a» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Yinno hyaakora eqqii be7ize eerats maachuntsi yene. Un gidda Magdela Mayrama, geezze Yayqooban Yoosa intta Mayramiran Salooma yene. ");
INSERT INTO oydl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yentsi maachuntsi Yesuusa Galila yeze wode eza kaalliduntsanan eza mokkiduntsana mahi Yesuusara wolla Yerusalaame hyanggide melle gaama maachuntsi ize yene. ");
INSERT INTO oydl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sa7ita uguride wode shiiqide asunts gidda bonchchinttide Ayhude shangguntsappa fete, Yoosefa gaaze atstse, Xoozze ka7itumo yo7odanno naagitera yeze, Armmatiyasa katama asi yezay yi7ida. Wonttistte Sambbatas giiginttize qamma maaqqide gisho Yoosefa miinggi Philaaxoosago hyanggi, Yesuusa ahito ekkodes woossida. ");
INSERT INTO oydl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philaaxoosa Yesuusa hyayqqidanno si7ide wode gaama qoppida; mato hyalaqiza xeegii, «E hyayqqi gam7ida?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Philaaxoosa Yesuusa hyayqqidanno mato hyalaqizeppa si7i E ahito Yoosefas inggida. ");
INSERT INTO oydl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoosefa moogo afula wonggi; Yesuusa ahito masqalappa ketstsii, afulara xaaxii, shuchchappa woocinttide booza gidda E ahito moogida. Mahi yinna booziti doontte damma shuchchi gol7izi gaddida. ");
INSERT INTO oydl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdela Mayramiran Yoosa intta Mayrama Yesuusa ahito un aanne gaddizako be7ine. ");
INSERT INTO oydl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sambbata aadhidannippa suuba Magdela Mayramo, Yayqooba intta Mayramiran Salooma hyanggi, Yesuusa ahito tishshades shitto wonggida. ");
INSERT INTO oydl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wogga wode wontta gooda xalqe kessadera, booza hyanggida. ");
INSERT INTO oydl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Un fa gidda fetay fetayra, «Booziti doonttippa nuus shuchchito oode gol7izi hyaasode?» yaga7i ohinttida. ");
INSERT INTO oydl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Un be7ize wode ye anddir damma shuchchize bunbbulunttii hyal7idanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yesuusa mooginttide booziti gidda gelize wode fettii yidhdho dhiiratsay bootsi ma7o ma77i, mizaqi zalara bettiday bi7i tannida. ");
INSERT INTO oydl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yezin E unttago, «Tannippete; masqalalla afa suxunttide, Naazirete Yesuusa yin koyzanno taanii erane. E hyanne baaya, hyayqoppa denddida. Un eza moogide bessito hyanno bo7ote. ");
INSERT INTO oydl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hyatte hyanggi Yesuusa tamaaruntsisin Phexiroosas, ‹Yesuusa yinttappa tiinidhii Galila aadhida. E yinttis ohidanni fana yin eza yeyga be7ada› ga7i ohote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Maachuntsi zhashmora goqii boozitippa kezii aachinttida. Mahi un zhashtize gisho yinno oodesin akkon ohikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuusa hyayqoppa denddidannippa maaqqii wogga wode wontta, laappun tuna ayyaanuntsana kesside Magdela Mayramis tiinidhii benttida. ");
INSERT INTO oydl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iza hyanggi eera tiino yezuntsis, un azzaniteran yeekkittera yezin ohida. ");
INSERT INTO oydl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yezin Yesuusa faxa yezannon iis benttidanno un si7ide wode iza gaazanno ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yinnippa suuba, unttappa lam77untsi katamappa kezii hyammadera, ogella afa Yesuusa tiinoppa dumudhii unttis benttida. ");
INSERT INTO oydl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Un suub maaqqii, melluntsis ohidap, attin melluntsin un ohito turo gaykaaya. ");
INSERT INTO oydl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Suubappa taphpho fettii E tamaaruntsi katstsa ma7adera, Yesuusa unttis benttida. Unttis ammano baayze gishon hyayqoppa E denddidanno bi7ide asuntsi ohin un ammananxii ixxide gisho E unttana borida. ");
INSERT INTO oydl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E unttago, «Sa7a ubba qitii as ubbuntsis Wonggele ohote. ");
INSERT INTO oydl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ammanidayin xammaqinttiday attoda, yezin ammanoose firddinttoda. ");
INSERT INTO oydl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ammanzuntsis hyanna mallita ingginttoda. Un ta suntsite tuna ayyaana kessoda, kille doonara ohinttoda. ");
INSERT INTO oydl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Un shooshi aykkikon woy wodhizebaz uzhikon unttana qohaama. Mahi un fa kushito hyargginttizuntsalla afa gaddii unttana fatstsoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Laatstsii Yesuusa tamaaruntsara ohinttidannippa suuba ude salo kezida; Xoozzeppa mizaqi zalara bettida. ");
INSERT INTO oydl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E tamaaruntsi qitide bessa ubba qaala ohida. Laatstsin unttara wolla oochchane. Unttii ohize qaaltta turo maaqqidanno Xoozii unttis inggide mallite miintsane.");
INSERT INTO oydl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bonchcho Tewofiloosa, nu gidda folinttide bazis gaamuntsi, faas dandda7inttide gaar xaafida. ");
INSERT INTO oydl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yinna taarikito un xaafidanna tiinoppa aykkii aafe markkuntsin qaala xaafii nuus ohidanno. ");
INSERT INTO oydl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Taanin ta baggara tiinoppa qoppii bi7idanippa suuba yinna taarikita hyanidanno luulizii nees Tewofiloosas xaafizanna taas lo77o maaqqii benttida. ");
INSERT INTO oydl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yinnan, ne tamaaridanna turo maaqqidanno erisodes. ");
INSERT INTO oydl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yihuda kaat Heroodisa wode Abiya baggappa maaqqide Zakkariyaasa gaaze Ayhude kahine yene. E machchitan Aarona kochchappa. I suntsitan Elssabeexo. ");
INSERT INTO oydl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Lam77untsin Laatstse wogan kiitto ubba naagii bore baayzin Xoozze tiintte xillotitsara yezida. ");
INSERT INTO oydl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yi7op attin Elssabeexa dhoontsi maaqqide gisho unttis na7a baaya. Lam77untsin cinggida. ");
INSERT INTO oydl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Fettii wode Zakkariyaasa fa tarttii ode Xoozze tiino kahinetitsara oochchane. ");
INSERT INTO oydl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kahinetitsi wogara Xoozze keetstsa gelii ixaane cugissades eza ixa yellida. ");
INSERT INTO oydl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ixaane cugize wode asuntsi ubba bale woossane. ");
INSERT INTO oydl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Laatstse kiitanchchize zharsho zharshize bestippa mizaqi zalara eqqii benttida. ");
INSERT INTO oydl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkariyaasa eza bi7i tannii gaama zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yezin kiitanchchize eego, «Zakkariyaasa zhashtippe; ne woosita sinttida. Ne machchita Elssabeexa dhiiratsi na7a yeloda, eza Wahannisa ga7i ne suntsoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","E nees wallon ufayssi maaqqada; gaamuntsi E yelintte ufayttoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Laatstse tiino E damma maaqqada; woyne ushshii maaqqin melle matstsize ushshii uzhaama. Fa inttii sazite yezara Geeshi Ayyaanara kumoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isra7eele asuntsappa gaamuntsana fa Laatstse, Xoozzego mahoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aduntsi wozintto na7untsago mahoda, kiitinttoosuntsana xillotitsi cinccatitsago mahode gaar, Laatstsis koshshize worzha giigisades Eeliyaasa ayyaanaran wolqqara Laatstse tiintte hyammada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakkariyaasa kiitanchchizego, «Ta yinno akkora erode? Taaran ta machchitira cinggida» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kiitanchchize mahi, «Taanii Xoozze tiintte eqqize Gabre7ele. Hyanna misiraachchito nees ohodes Xoozappa kiitinttida. ");
INSERT INTO oydl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yikke, wodito naagii folinttode ta qaaltto ne ammananxii ixxide gisho hyanna folinttode wontsis ne doontta muume maaqqada, ohinttodesin ne dandda7aama» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ye wode Zakkariyaasa Xoozze keetstsite gelii gam7ide gisho akko yi7ido ga7i asuntsi bale naagitera gam7ida. ");
INSERT INTO oydl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","E bale kezii unttana ohissades dandda7ikaaya. Malla kushera beezanip attin ohinttodes dandda7oosanno bi7ide wode qonccitsi bi7idanno erida. ");
INSERT INTO oydl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakkariyaasa oocha wodito folii fa kara maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Yinnippa suuba, E machchita Elssabeexa wodaxida. Ichchin agina kumutsi fana geentsi asis benttikaayzara gam7ida. ");
INSERT INTO oydl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iza, «Laatstsii fa maarotitsite ta toochito as giddappa hyaasodes bi7i hyanna wodite hyanno taas oochchida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elssabeexa wodaxidannippa izippuntsa agintte, Xoozii Kiitanchcho Gabre7ele Galila gade yeze Naazirete katama kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ezin Yoosefa gaaze kaat Dawute kochchappa maaqqide atstses oocinttide wudurttigo kiitinttida. Yinna wudurtta Mayramo ga7inttane. ");
INSERT INTO oydl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kiitanchcho iigo hyanggi, «Gaama kadhinttidanne, saro nees maaqqe, Xoozii neera yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mayrama E ohite gaama tannii, «Hyanna akko saritse» ga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiitanchchize mahi, «Mayrame, zhashtippe; ne Xoozze tiintte nashsho denggida. ");
INSERT INTO oydl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yikke ne wodaxoda dhiiratsi na7a yeloda, E suntsiton Yesuusa ga7i suntsoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E damma maaqqada, Ubbappa kattara Xoozze na7a ga7intti xeeginttoda. Laatstse Xoozze E aday Dawute araata ees inggoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","E Yayqooba kochchalla afa medhina ka7itoda; E ka7itumttis hyal7e baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayrama kiitanchchizego, «Yinna wayzi hyanode? Ta dhiiratsara yellinttikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kiitanchchize mahi, «Geeshi Ayyaana neella afa wodhdhoda, Ubbappa kattara Xoozze wolqqita neella afa shemppoda. Yinnii gisho, yelinttide geeshi na7ay Xoozze Na7a ga7inttoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yikke, ne igintta Elssabeexa fa cimatitsi laytsite dhiiratsi na7a wodaxida. Iza dhoontsi ga7inttidanno, yezin hyatte izippuntsa agina aykkida. ");
INSERT INTO oydl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xoozza gamizebaz baaya»yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayrama, «Yeezako, taanii Laatstse arttis, ne qaaltti gaar taas yi7o» yagayda. Yinnippa suuba, kiitanchchize iippa shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mayrama yinna saamintte denddii Yihuda sa7a yeze fettii ale katama qitida. ");
INSERT INTO oydl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakkariyaasa kara gelii Elssabeexo sarotsida. ");
INSERT INTO oydl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elssabeexa Mayrama sarotsizanno si7ize wode I saztte yeze na7ay ufayssara dollida. Elssabeexa Geeshi Ayyaanara kumii, ");
INSERT INTO oydl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","fa qaaltto dhoqi yiizii, «Neenii maachuntsappa anjjinttidanno, ne wodaxide na7ayin anjjinttidaya. ");
INSERT INTO oydl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yi7o yezin, ta Laatstse intte, neenii taago ye7ode gaar ta oode? ");
INSERT INTO oydl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yikke ne sarotitsito ta si7ize wode ta sazite yeze na7ay ufayssappa dollida. ");
INSERT INTO oydl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Laatstsii foloda ga7i inggide qaaltto ammanidanna, iza anjjinttidanno» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mayrama hyannii gaara yagayda: «Ta shemppita Laatstsa bonchchane, ");
INSERT INTO oydl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ta Ayyaanze gaalla Xoozzella ufayttane. ");
INSERT INTO oydl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","E fa arttii toochito bi7ida. Hyaynoppa aykkii yeletitsi ubba tana anjjinttidanno ga7oda. ");
INSERT INTO oydl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Wolqqaama maaqqide E, taas damma baz oochchida. E suntsita Geeshi. ");
INSERT INTO oydl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eza bonchchizuntsalla afa, E maarotitsita medhinappa medhina yellodes. ");
INSERT INTO oydl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Fa qesite mintsi baz oochchida, fa wozintte uturtizuntsanna lalida. ");
INSERT INTO oydl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Damma kaatuntsana araatizeppa wodhizida; Fa ommito toochizuntsana bonchchida. ");
INSERT INTO oydl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Naydhdhiduntsana lo77o bazara mishshida, yezin duruntsana kallo kushe dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Fa maarotitsito qoppii, Fa ariza Isra7eele maaddida. ");
INSERT INTO oydl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yinnan nu aduntsis ohide qaala, Abrahamasin E zarttis ga7idanno medhinas folodes» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayrama Elssabeexi kale hyaydzdzii agina gaar gam77i fa kara maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elssabeexis yelo qamma yellin dhiiratsi na7a yelida. ");
INSERT INTO oydl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I dootsuntsin I iginuntsi Laatstsii damma maarotitsi oochchidanno si7i, iira wolla ufayttida. ");
INSERT INTO oydl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Osfuntso qammite zhooga na7aya garrazodes yi7ida. E aday suntsite Zakkariyaasa ga7i suntsodes koyda. ");
INSERT INTO oydl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yezin intta, «Ade, Wahannisa ga7inttodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Unttin, «Ne iginutsappa hyay suntsera xeeginttide ooden baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","E aday oode ga7i suntsodyezako erodes koyi eza malla oocida. ");
INSERT INTO oydl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","E xaafizebaz oocii ekkii, «E suntsita Wahannisa» ga7i xaafida. Ubbuntsi E xaafidanno bi7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iira Zakkariyaasa il7antsita bilinttida, Xooz galatittera ohintte aykkida. ");
INSERT INTO oydl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dootsuntsi ubba zhashmora kumida. Hyanna hyanidanna ale Yihuda sa7a ohinttida. ");
INSERT INTO oydl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yinno si7eze ubbuntsi, «Hyay na7ay akko yi7ad yessa?» ga7i fa gidda ohinttida. Laatstse kushita eera yene. ");
INSERT INTO oydl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wahannisa aday Zakkariyaasa Geeshi Ayyaanara kumii hyannii gaara yaga7i tinbbite ohida. ");
INSERT INTO oydl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Isra7eele Laatstse Xoozze galatintto, yi7i fa asuntsana wozida. ");
INSERT INTO oydl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Fa arize Dawute keetstsa atotits wolqqa dentsida. ");
INSERT INTO oydl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yinnan zaga wode geeshi nabunts doontte ohinttidanni fana, ");
INSERT INTO oydl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","E ashita nu morkkuntsappan nuura olinttize ubbunts kushtippa. ");
INSERT INTO oydl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yinno E oochchidanna nu aduntsis fa maarotitsito beessadesin, fa geeshi caaqito naagodes. ");
INSERT INTO oydl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nu aday Abrahamas caaqqide caaqito qoppodesin ");
INSERT INTO oydl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nu morkkuntsi kushtippa kessii zhashimo baytsi ees kiitinttode fana. ");
INSERT INTO oydl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nu laytsite ubbanne geeshshatitsaran xillotitsara fa tiintte nuna essodes. ");
INSERT INTO oydl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta na7ayo, neenii Ubbappa kattara Xoozze nabe ga7inttoda. Laatstse ogito loytsodes ne E tiintte hyanggoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Un nagartta uccinttin, un atotitsi era denggodanno ne Laatstse worzhitis ohoda. ");
INSERT INTO oydl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nu Xoozze lo77o maarotitsitippa denddii wontta xalqe nuus saloppa kezida. ");
INSERT INTO oydl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yinnan dhuma giddan, hyayqo dasho oomo yezuntsis foo7issades, nu tohiton saro ogego mahodes» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na7ay diccida, Ayyaanara minggida, Isra7eele asuntsis benttode wontsis akko baayze ganasa yezida. ");
INSERT INTO oydl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ye wode Roome gade yeze as ubbuntsi faydinttode fanan suntsita xaafinttode fana kaati Awugisxoosa kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yinnan Qerenoosa Sooriya gade ahize wode oochinttide tiino faydo. ");
INSERT INTO oydl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yinnii gisho, fettii fettii asi fa suntsito xaafinttodes fa yelinttide gade qitida. ");
INSERT INTO oydl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoosefan Dawute keetstsappan kochchappa maaqqide gisho Galila Naazirete katamappa denddii Dawute katama maaqqide Yihuda Beeteleme qitida. ");
INSERT INTO oydl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hyanggodera, yelodes wode hyal7ide E oocii gaddide, Mayramira wolla xaafinttodes hyanggida. ");
INSERT INTO oydl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Un ize yezin iis yelo wode yellida. ");
INSERT INTO oydl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Fa anggis na7aya yelida. Curqqara xaaxii zaqqo aqize keetsi bessi dhabide gisho gongga gidda woytstsida. ");
INSERT INTO oydl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Yinna gadite qamma duro wude yenggite zooze aqize wude yenggizuntsi yene. ");
INSERT INTO oydl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Laatstse kiitanchcho yi7i un kale eqqida. Laatstse bonchcho un kantto wutii foo7ida; unttin damma zhashimo zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kiitanchchize unttis, «Zhashtippete! Yikke, as ubbannis maaqqide damma ufayssi misiraachcho ekkii yi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yinnan, Dawute katamite ashshizay yinttis hyayno yelinttida. Ezin Laatstse Kiristtoosa. ");
INSERT INTO oydl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yinnan yinttis malla maaqqe; zhooga na7ay curqqara xaaxintti gongga gidda woy7idaya yin demmada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Qoppikaayzin gaama Salo kiitanchchuntsi kiitanchchizera fettilla benttii, yaga7i galatida, ");
INSERT INTO oydl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Bonchcho Xoozzes afa salo, sarotitsi sa7alla afa Xoozii kadhize asis maaqqe.» Yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiitanchchuntsi unttappa shaakkintti salo kezidannippa suuba wude yenggizuntsi, «Ane Laatstsii nuus qonccizide bazin hyanidanno be7ades Beeteleme yedhdhote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Unttin ellisii hyanggida. Mayramo, Yoosefan zhooga na7ay gongga gidda woy7idaya bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bi7i maaqqii na7ibaz unttis ohidanno, geeshi yinna besite yeze asuntsis markkidhida. ");
INSERT INTO oydl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yinno si7ide ubba wude yenggizuntsi ohidanno gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mayrama hyanide baz ubba fa wozintte qoppittera yene yeshsha. ");
INSERT INTO oydl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yenggizuntsi unttis ohidanni gaara yi7in bi7ida. Yinnii gisho, fa si7idebazisin bi7idebaz ubbannis Xoozze bonchchiten galatitte maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osfuntsa qammite, garraze wode yellin, iis agina attodannippa tiino kiitanchcho gaddide suntsite Yesuusa ga7inttida. ");
INSERT INTO oydl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muse higge fana un geezhize wode folinttidanippa suuba Yoosefaran Mayramira zhooga na7a fa Laatstses immades Yerusalaame qitida. ");
INSERT INTO oydl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yinnan, Laatstse higgera, «Dhiiratsi maaqqide anggis na7a ubbuntsi Laatstsis dummudhidaya maaqqe» ga7intti xaafinttidanno folodes. ");
INSERT INTO oydl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mahi Laatstse higge, lam77i koka woy wolle zharshodes kanggida. ");
INSERT INTO oydl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ye wode geeshin ammanora mintsii maaqqide Simoona ga7inttize atstse Yerusalaame yene. E Isra7eeluntsana ashshiza naagitera yene. Geeshi Ayyaanan eella afa yene. ");
INSERT INTO oydl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mahi Kiristtoosa bi7ikaayzara hyayqqamanno Geeshi Ayyaana ees beezin erii yene. ");
INSERT INTO oydl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","E ye wode Ayyaana kaalitsin Xoozze keetstsa qitida. Na7ay inttiran adera woga folodes zhooga na7aya Yesuusa ekkii gelide wode. ");
INSERT INTO oydl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoona mokkii ekkii na7aya iringgi, yaga7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Laatstso ne taas gelide qaaltti fana, hyatte ne ariza sarora moyzo. ");
INSERT INTO oydl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ta aafta asi ubbunts tiino ne giigizide, ");
INSERT INTO oydl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne atotitsito bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yinnan Ayhude maaqqoosse ubbuntsis, Xoozze ogito geeshize foo7o, ne asunts Isra7eeluntsis bonchcho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yoosefaran Mayramira E baz ohinttidanne gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoona unttana anjjida. Intta Mayramigo, «Yikke hyay na7ay Xoozappa doorinttide gaama Isra7eeluntsis un gol7itisin un dendditis malla maaqqada. Yinnon gaamuntsi ixxane. ");
INSERT INTO oydl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne shemppitan mahi mashshara cadinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Mahi Aseere kochchappa maaqqide Faanu7ela na7ita Haanna ga7inttize nabita yene. Iza gaama cinggida; iza azinzera laappun bere yezida. ");
INSERT INTO oydl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","I azinze hyayqqin osfun tam oyddii bere maaqqade wontsis qamman awara face baytsi woosaran xoomara Xoozze Keetstsa oochchane. ");
INSERT INTO oydl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iza yinna saate hyanggi Xooz galatida; Yerusalaame atotitsi wode naagize ubbuntsis zhooga na7ay baz markkidhida. ");
INSERT INTO oydl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yoosefaran Mayramira Laatstse higgite kiitinttide wogito ubbanno folidannippa suuba Galila sa7a yeze fa katama Naazirete maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na7ay dicciteran minggitara hyanggida. Cinccatitsara kumida; Xoozze aadho keehatitsita eella afa yene. ");
INSERT INTO oydl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yoosefaran Mayramira Faasika Ba7ale bonchchodes ubba bere Yerusalaame qitane. ");
INSERT INTO oydl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuusas taphpho lam77i bere maaqqide wode tiinoppa hyanggizanii fana baalito bonchchodes hyanggida. ");
INSERT INTO oydl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ba7ale bonchchidanippa suuba kara maaqqize wode na7ay Yesuusa Yerusalaame attida. Yezin Yoosefaran Mayramira E Yerusalaame attidanno erikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E kara maaqqide asara yeze gaara yi7in un fettii qamma oge yedhdhida. E baayzanno eridannippa suuba fa iginuntsi kalen lagguntsi kale koyda. ");
INSERT INTO oydl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","E ize dhabin koyitera suuba Yerusalaame yellodes yi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hyaydzdzii qammappa suuba Xoozze Keetstsa asttamaarunts gidda bettii unbaz si7itten unttana oocitera yezin denggida. ");
INSERT INTO oydl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eza si7ize ubbuntsi E qofiten mahite gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kara asuntsi eza denggide wode gaama qoppida. E inttan, «Ta na7ayo, akkosi nuna hyannigaara oochchido? Ne aderan taaran nena koyitera waayida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesuusa unttago, «Tana akkos koye? Taanii, ta aday keetstsa yessades beezanno eroso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yezin E unttago gaydanno un tiirikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yinnippa suuba, unttara wolla Naazirete katama yi7ida. Unttis kiitinttii yezida. E intta yinna ubbabazito wozintte gaddii naagane. ");
INSERT INTO oydl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuusa, cinccatitsera, ude dichcharan sabara Xooz tiinon as tiino diccane. ");
INSERT INTO oydl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kaati Xibaaryoosa Roome gade ka7itin, taphpho ichchintsa bere, Phenxe Philaaxoosa Yihuda ahize wode Heroodisa Galila ahize wode E ishe Filphoosa Ixuuriyasan Xirakkonddoosa ahize wode Lisaniyoosa Ablaanisa ahize wode ");
INSERT INTO oydl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haannaran Qayyaafara kahinunts hyalaqa maaqqii yezin, Xoozze qaala Zakkariyaasa na7a Wahannisago akko baayze ganasa yi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wahannisa, «Yin nagarttippa maaqqii xammaqinttote. Xoozii yin nagartto atto ga7oda» yaga7i tamaarssite Yorddaanosa borkka gaxara yeze sa7a ubba qitida. ");
INSERT INTO oydl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yinnan nabe Isayaasa fa maxaafite, «Akko baayze ganasa gidda fa qaaltto dhoqi yiizi, uukkize atstse qaaltta, ‹Laatstse ogito giigizote, worogiton luulizote. ");
INSERT INTO oydl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Doochii ubba kumoda, deren dhoqqa bessin ziqqi gawuda. Wobbo ogita luuloda, giigoose horogita giigoda. ");
INSERT INTO oydl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","As kochchi ubba, Xoozze atotitsito be7ada› » ga7i xaafidanifanna hyanida. ");
INSERT INTO oydl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wahannisa, fa kushite xammaqinttodes yi7ide gaama asuntsago, «Hyantsi, shooshi na7untso yo7odes yeze hyanqoppa attode gaar yinttana zoride oode? ");
INSERT INTO oydl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yikke, yin maarinttes beezze lo77o oocha oochchote, yin wozintte, ‹Nuus, nu aday Abrahama yene ga7i ceeqinttippete.› Hyankka si7ote, hyantsi shuchchuntsappa Xoozii Abrahamas na7a kessodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hyatte, gandde minxa xapho yene. Yikke, lo77o aafe aafoosse minxa ubba gachchinttii tama ollinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Asuntsi, «Yeezin nuunii akko oochchode?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wahannisa mahi, «Lam77i afula yeze asi baayzes shago. Katstsa yeze baayzes shago» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qaraxe gachchizuntsii xammaqinttodes yi7i, «Asttamaarizayo, nuunii akko oochchode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","E mahi, «Yin gachchisades beezanippa aatsii ekkippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mahi wottaddaruntsi yi7i, «Nuunii akko oochchode» yaga7i oocida. Wahannisa, «Obazin wolqqara dafii ekkippete, ooden worddora mootippete, yin damoozita yinttis maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asuntsi Kiristtoosa ufayssara naagii yeze gisho Wahannisa, «E Kiristtoosa maaqqane?» yaga7i fa wozintte qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wahannisa ubbuntsis mahi, «Taanii yinttana hyaatsara xammaqane, yezin taappa aadhii miinggize ye7oda. Taanii E caamma gadito billodes beezoosse asi. E yinttana Geeshi Ayyaanaran tamara xammaqoda. ");
INSERT INTO oydl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Uduma yeze katstsa geeshodes fitstse E kushite yene. Geeshi katstsa fa fachite gussoda; buurtto dhaboose tamar michchoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mahi Wahannisa asuntsana gaama zorii Wonggele ohida. ");
INSERT INTO oydl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yezin Wahannisa Heroodisa fa ishe machchito, Heroodiyada, ekkide gishon melle iita oochiti gisho kaccide wode ");
INSERT INTO oydl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroodisa kasenilla afa melle iita baz ubba gujjii Wahannisa woyne geltsida. ");
INSERT INTO oydl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wahannisa accinttodanippa tiino as ubba xammaqii maaqqin, Yesuusan mahi xammaqinttida. E woossodera salo bugunttida. ");
INSERT INTO oydl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Geeshi Ayyaana wolle fana benttitera eella afa bettida. Saloppa «Ta kadhize na7ay nena; ne tana ufayssane yaga7ize» qaala yi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuusa tamaarse aykkize wode ees hyasttam bere maaqqadera, asuntsi eza Yoosefa na7a ga7i qoppida. Yoosefa Eele na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eele Maate na7a, Maate Leewe na7a, Leewe Malkka na7a, Malkka Yoona na7a, Yoona Yoosefa na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoosefa Mataate na7a, Mataate Amoxe na7a, Amoxe Nahoome na7a, Nahoome Asiliime na7a, Asiliime Naage na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naage Ma7aate na7a, Ma7aate Mataatiye na7a, Mataatiye Samaye na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Samaye Yoosefa na7a Yoosefa Yihuda na7a, Yihuda Yoonane na7a, Yoonane Rase na7a, Rase Zerubaabela na7a, Zerubaabela Salatiyaale na7a, Salatiyaale Neere na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neere Miilkkii na7a, Miilkkii Haade na7a, Haade Qoosame na7a, Qoosame Elmodaane na7a, Elmodaane Eera na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eera Yoose7e na7a, Yoose7e Alaazare na7a, Alaazare Yoorame na7a, Yoorame Maate na7a, Maate Leewe na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leewe Simoona na7a, Simoona Yihuda na7a, Yihuda Yoosefa na7a, Yoosefa Yoonane na7a, Yoonane Eliyaaqeme na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyaaqeme Maliyye na7a, Maliyye Maynaane na7a, Maynaane Maate na7a, Maate Naatane na7a, Naatane Dawute na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawute Issey na7a, Issey Iyobeede na7a, Iyobeede Boo7eza na7a, Boo7eza Salmoona na7a, Salmoona Na7asoona na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na7asoona Aminaadabe na7a, Aminaadabe Raame na7a, Raame Arnne na7a, Arnne Asroome na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Asroome Faarese na7a, Faarese Yihuda na7a, Yihuda Yayqooba na7a, Yayqooba Yisaaqa na7a, Yisaaqa Abrahama na7a, Abrahama Taara na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Taara Naakkore na7a, Naakkore Saruuge na7a, Saruuge Rehu na7a, Rehu Faaleqe na7a, Faaleqe Ebeera na7a, Ebeera Seela na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seela Qaynaane na7a, Qaynaane Arfakisaada na7a, Arfakisaada Seeme na7a, Seeme Nohe na7a, Nohe Laamehe na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laamehe Matusaala na7a, Matusaala Heenoke na7a, Heenoke Yaarede na7a, Yaarede Malaal77ela na7a, Malaal77ela Qaynaane na7a, ");
INSERT INTO oydl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Qaynaane Heenosa na7a, Heenosa Seeta na7a, Seete Addaama na7a, Addaama Xooz na7a. ");
INSERT INTO oydl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuusa Geeshi Ayyaanara kumii Yorddaanosa borkkappa maaqqide fana Ayyaana eza akko baayze ganasa kanggida. ");
INSERT INTO oydl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ize oyttam awaran qamma xalahera fattaninttida. Ye wodite akkon mu7ikaayzara gam77ide gisho wurssutsite naydhdhida. ");
INSERT INTO oydl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xalahe eego, «Neenii Xoozze na7a maaqqiko ane hyay shuchchiza daabbo maaqqo ga7i kiitto» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuusa mahi, «Asi daabbo xalaalara yezoos ga7intti Xoozze qaaltte xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yinnippa suuba, Xalahe Yesuusa pharggo derella afa kessii hyanna alamtti ka7itumtto aafe qiphii maaqqades beezida. ");
INSERT INTO oydl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xalahe, «Hyanna ubbannis adetits wolqqa bonchchon taas ingginttida. Taanii kadhize oodesin inggize gisho nees inggoda. ");
INSERT INTO oydl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yinnii gisho, ne taas goynizako ubba nees maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuusa mahi, «Ne Laatstsa, ne Xoozza, eza xalaala goynon ees oochcho ga7intti Xoozze qaaltte xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wurssutsite Xalahe Yesuusa Yerusalaame kanggi Xoozze Keetsitis kusttella afa essi, Neenii Xoozze na7a maaqqiko ane sulle sa7a nena olo. ");
INSERT INTO oydl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Akkos gayko, « ‹Nena naagize fa Kiitanchcho ne gisho kiittoda ga7intti Xoozze qaaltte xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Un ne tohita shuchchalla dhubunttaame gaar, fa kushite dhoqi yiizii nena dentsoda› ga7intti Xoozze qaaltte xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesuusa mahi, «Ne Laatstsa Xoozza fattanippe ga7intti Xoozze qaaltte xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Xalahe Yesuusa fatantto ubba hyaasidanippa suuba melle wottize wode denggode wontsis eeppa shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuusa Geeshi Ayyaana wolqqara kumii Galila maaqqida. E suntsita kale yeze sa7a ubba kezida. ");
INSERT INTO oydl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","E Ayhude woosa keetstsa gelii tamaarssida; asuntsi ubbuntsi eza galatida. ");
INSERT INTO oydl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Izippa E diccide katama Naazirete yi7ida. Tiinop oochchizanni fana Sambbata wode Ayhude woosa keetstsa gelida. Nabbabodesin denddii eqqida. ");
INSERT INTO oydl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nabe Isayaasa maxaafize xaxinttidaya ees inggin, bugii, hyannigaara yaga7i xaafinttidanno denggida: ");
INSERT INTO oydl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Laatstse Ayyaana taalla afa yene, dahuntsis Wonggele ohode fana Xoozii tana doorida. Acinttiduntsis bilintte, qooqiduntsis be7e un7inttiduntsana wallo kessodes, ");
INSERT INTO oydl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xoozii ashshodes qoppide bertto ohode fana tana kiittida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yinnippa suuba, maxaafiza xaaxii Ayude woosa keetstsa inggida. Ayhude woosa Keetstsa yeze asuntsi ubba dakkii be7ine. ");
INSERT INTO oydl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","E, «Hyaychche yin hyaytira yin si7ize hyanna maxaafe qaaltta hyayno folinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ubbuntsi E baz lo77o baz ohinttane. Mahi E doonttippa kezze aadho keehatitsi kumide qaalttippa denddi gaama qoppii, «Hyay Yoosefa na7a baane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","E, « ‹Akimzayo ane nena ashsho, Qifirnahoome gidda ne oochchidanno nu si7idanno mahi hyanne ne katamite oochcho› yaga7ize aazizera yin tana gawudannis so7e baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mahi, «Turo ohine; nabe fa yelinttide gadite bonchchinttoos. ");
INSERT INTO oydl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Ta yinttis turo ohine; salo hyaydzdzii beren bagge gorddinttin mintsi naye sa7alla ubba yeze Eeliyaasa wode gaama budanuntsi Isra7eele gidda yene yeshsha. ");
INSERT INTO oydl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eeliyaasa unttappa fettigon kiitinttikaaya. Yezin Saraptta gidda yeze fettii budanttigo kiitinttida. ");
INSERT INTO oydl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nabe Elssa7e wode Isra7eele gidda gaama qursumara hyargginttizuntsi yene yeshsha. Yezin Sooriya atstse Ni7imaanep attin ooden faxikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayhude woosa Keetstsa yeze asi ubbuntsi yinno si7eze wode gaama zhilidhdhida. ");
INSERT INTO oydl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Fa bettide bestippa denddii derella afa keexinttide katamttippa gaxa kessii urqqii dakkodes gaga doona kanggida. ");
INSERT INTO oydl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yezin E un giddara kantsii aadhida. ");
INSERT INTO oydl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Izippa Galila sa7a yeze Qifirnahoome katama qitida. Ize Sambbata wode asuntsana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","E tamaarssizanna adetits wolqqara maaqqide gisho ubbuntsi E timirttite gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayhude woosa Keetstsa tuna ayyaana aykkide atstse yene. ");
INSERT INTO oydl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","E, «Naazirete Yesuusa nuna akkos waaytse nuuppa hyaakko; ne yi7idanna nuna dhabssodesine? Ne oona yezako ta erane. Neenii Xoozzeppa yi7ide Geeshi» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesuusa tuna ayyaanzego, «Si7i ga7i hyay atstseppa kezo» yaga7i seerida. Tuna ayyaanze atstsa as ubbunts tiino olii ashshii akkon qohikaayzara dakkii kezida. ");
INSERT INTO oydl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Asuntsi ubba gaama qoppida. Woligo, «Yeezin, hyanna akko timirtte? Tuna ayyaanuntsana adetits wolqqara kiittane; unttin kezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","E suntsita kara gancce ubba kezida. ");
INSERT INTO oydl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yinnippa suuba, Yesuusa Ayhude woosa keetstsappa kezii Simoona keetstsa gelida. Simoona machchitii intta mintsii omma otstsin micha hyargginttida. Izo fatstsode gaar Yesuusa woossida. ");
INSERT INTO oydl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I yitsitigo shiiqii zuggii I hyarggiza seerida. Michita ashshin ellisii denddii unttana mokkida. ");
INSERT INTO oydl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Awa gelodes yi7adera dumma dumma hyarggera aykinttide asuntsana eego ki7ida. E fetella fetella afa fa kushito gaddii fatstsida. ");
INSERT INTO oydl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tuna ayyaanuntsi mahi, «Neenii, Xoozze na7a» ga7i wuysitera gaama asappa kezida. Yezin E unttana seerida. E Kiristtoosa maaqqidanno un erize gisho fettii bazin ohaame fana kayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hyaga wonttize wode Yesuusa fettii asi baayze bessa qitida. Asuntsi koytera E yeze besite yi7ida. Unttappa E shaakkintti qitaame gaar kayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yezin E, «Taanii melle katama hyanggi Xoozze ka7itumo Wonggele markkidhades beezane. Ta kiitinttidanna yinnisi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yihuda sa7a yeze Ayhude woosa Keetstsa sabbakida. ");
INSERT INTO oydl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Fettii wode Yesuusa Gensareexe Abba kale eqqezin gaama asuntsi E kantto wutii eza un7itsi, E tamaarssize Xoozze qaaltto si7ine. ");
INSERT INTO oydl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ize hyaatsi gaxa yeze lam77i gongguntsana bi7ida. Molo aykkize asuntsi gongguntsappa wodhdhii fa molo aykkize gitto meeccane yeshsha. ");
INSERT INTO oydl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yentsi gongguntsappa Simoonasse gidda gelii sa7appa eeratsi gidda shiishode fana oocida. Yeyzi, ye gonggizella afa bettii asuntsana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Fa tamaarssizanno hyaasidanippa suuba Simoonago, «Gode geenttigo shiishii molo aykkodes yin gitiza olote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoona mahi, «Asttamaarizayo, qamma kumutsi labbii aqii akkon aykkikaaya, yezin ne gayko gitiza oloda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Un gitiza olide wode gitize fedhinttode wontsis gaama molo aykkida. ");
INSERT INTO oydl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Melle gongge yeze fa lagguntsi yi7i, fana maaddode gaar wuttii xeegida. Un yi7i lam77i gonggita, hyaatsite qoodhinttode wontsis molora kuntsida. ");
INSERT INTO oydl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoon Phexiroosa yinno be7eze wode Yesuusa tiintte bunqqunttii, «Laatstso, taanii nagarar yeze as maaqqide gisho taappa hyaakko» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yinno E ga7idanna ezin eera yezuntsi aykkide molo gaamatitsite gaama qoppide gisho. ");
INSERT INTO oydl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Mahi Simoona zhame maaqqide Zabdoosa na7untsi Yayqoobaran Wahannisaran gaama qoppida. Yesuusa Simoonago, «Zhashtippe! Yikkeppa neenii as aykkize asi maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Un gonggito gaxa shiishidannippa suuba ubbanno ashshii Yesuusa kaallida. ");
INSERT INTO oydl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuusa katamuntsappa fete gidda yezin fettii qursuma hyarggera aykkinttide asi yinna katamite yene. Ye atstsay Yesuusa bi7i E tiintte bunqqunttii, «Laatstso, ne qofa maaqqiko tana geeshodes dandda7ane» ga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuusa fa kushito dakkii bochchii, «Yee, ta qofa; geezho» yagayda. Izira qursuma hyarggize atstsa dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuusa, «Hyanno oodesin ohippe, yezin hyanggi ne galtto kahinze beezo. Ne geezhidannis markka maaqqade fana Muse kiittide zharshito zharsho» ga7i kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Maaqqo yezin, Yesuusa suntsita kasennippa aadhii dalggitera hyanggida. Gaama asuntsi E ohizanno si7odesin fa hyarggitippa faxodes ye7ine. ");
INSERT INTO oydl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yezin E gaama wode geema bessa qitii woossane. ");
INSERT INTO oydl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Fettii wode Yesuusa tamaarssodera Galilappan Yihuda kara gancce ubbappa mahi Yerusalaameppan ye7eze Farisaawuntsin higge asttamaaruntsi ize bettida. As fatstsize Laatstse wolqqitan eera yene. ");
INSERT INTO oydl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ye wode asuntsi fettii wobbo atstsa alggara tookkii ki7ida. Keetstsa geltsii E tiintte gaddodes qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yezin as gaamappa denddii keetstsa geltsodes gamin keetstsalla afa kezii, keetstsi aafto qawuxii, hyargginttiza alggizera Yesuusa tiino ketstsida. ");
INSERT INTO oydl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuusa un ammantto bi7i, «Naate atstsayo, ne nagartta uccinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Higge asttamaaruntsin Farisaawuntsi, «Hyay Xoozzella afa yaga7i ohize oode? Fettii Xoozzep attin melle nagara uccodes dandda7ize oode?» yaga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuusa un qoftto eride gisho unttago, «Yin wozintte hyannii gaar akkos qoppete? ");
INSERT INTO oydl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹Ne nagartta ucinttida ga7izanippan denddii qito ga7izannippa aaye foolle?› ");
INSERT INTO oydl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yezin ta yinno gaydanna As Na7ay sa7alla afa nagara uccodes adetits wolqqa yezanno yin erode gaara.» Yinnippa kaallii, wobbo atstsa, «Denddo; ne alggiza tookkii ne kara qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","E iira denddii un tiintte eqqida; E tookkintti yi7ide alggiza tookkii Xooz galatitera fa kara qitida. ");
INSERT INTO oydl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ye wode ubbuntsi gaama qoppida. Xooz galatitera, «Hyayno damma kille baz bi7ida» yaga7i zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yinnippa suuba, Yesuusa yeygappa kezii qitida. Leewe ga7inttize fettii qaraxe gachchizay qaraxe gachchize besite bettidaya bi7i, «Tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","E ubba baz ashshii denddii eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ye Leewize fa kara damma diggisa giigizida. Gaama giira gachizuntsin melle asuntsi katstsa ma7ades bettida. ");
INSERT INTO oydl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisaawuntsin higge asttamaaruntsi, «Giira gachizuntsaran nagaranchchuntsara akkos me7e uzhe?» yaga7i Yesuusa tamaaruntsalla afa zuuzinggida. ");
INSERT INTO oydl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuusa unttago, «Hyargginttizuntsis fattin faxas akime koshshoos. ");
INSERT INTO oydl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taanii nagaranchchuntsana maarotitsago mahodes fattin geeshshuntsana xeegodes yi7ikaaya» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Un Yesuusago, «Wahannisa tamaaruntsi gaama wode xoomane, woossane; mahi Farisaawuntsi tamaaruntsin yinnii gaara yiizane. Yezin neesuntsi ubba wode muune uzhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuusa unttago, «Mushura unttara yezin xeeginttide asuntsi xoomode gaar yissades dandda7anete? ");
INSERT INTO oydl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yezin mushurze unttappa shaakkinttode wode ye7oda, ye wode un xoomoda.» ");
INSERT INTO oydl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mahi yaga7i aazize ohida; «Kille ma7oppa feedhii gal77a ma7olla afa sikkize ooden baaya. Yinnii fana yeyziko kille ma7iza feedhane, killize gal77izes giigoos. ");
INSERT INTO oydl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mal7antto woyne cima silphe gujjize ooden baaya. Yinno yeyziko, mal77antto woynize cima silphiza dhuussane; woynttan lanttane silphizen maaddoose baz maaqqane. ");
INSERT INTO oydl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yinnii gisho, mal7antto woyne kille silphe gujunttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yikke, caalize lo77o gaaze gisho caala woyne uzhii maaqqii caalikaayza mal7antto koyze ooden baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Fettii Sambbata wode Yesuusa zarga gade giddara aadhane. Yesuusa tamaaruntsi tizha zarga duutsii fa kushite shiccii dha7ane. ");
INSERT INTO oydl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yezin Farisaawuntsi giddappa fete fete, «Sambbata wode higges beezoosse baz akkos oochche?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuusa unttago mahi, «Dawute naydhdhide wode faara yezuntsara wolla oochchidanno nabbabika? ");
INSERT INTO oydl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xoozze keetstsa gelii Ayhude kahinuntsi xalaalasin Xoozis beezze daabbuto mu7ida; faara yezuntsisin inggida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mahi Yesuusa, «As Na7ay Sambbata Laatstsi» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Melle Sambbata qamma Yesuusa Ayhude woosa keetstsa gelii tamaarssida. Yinna besite mizaqi kushe gunddide fettii asi yene. ");
INSERT INTO oydl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Higge asttamaaruntsin Farisaawuntsin eza mootodes oge koyi Sambbata wode fatstsiko be7ada ga7i kafane. ");
INSERT INTO oydl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yezin Yesuusa un qoftto erii kushe gunddide atstsego, «Denddii asunts gidda eqqo» yagayda. Atstsayin denddii eqqida. ");
INSERT INTO oydl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesuusa, «Ane ta yinttana fettibaz oocane; Sambbata qamma higgite oochchodes beezizanna lo77o bazone iita bazo? Shemppo ashshene woy dhabsse?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mahi Yesuusa E kale wutii yeze asuntsana ubba wututsi bi7i atstsego, «Ne kushito fiddii yiizo» yagayda. Atstsayin E gayidanni gaara yeyzin kushize faxida. ");
INSERT INTO oydl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yezin higge asttamaaruntsin Farisaawuntsin gaama zhilidhdhida. Yesuusalla afa akko oochcho ga7i fa gidda zorinttida. ");
INSERT INTO oydl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ye wode yinna qammitippa fete gidda Yesuusa woossodes derella afa kezida. Qamma kumutsi Xooz woossittera aqida. ");
INSERT INTO oydl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wonttistto fa tamaaruntsana xeegii un giddappa taphpho lam77untsana doorii, unttana, «Hawaaruntsana» ga7i suntsida. ");
INSERT INTO oydl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Unttin, Phexiroosa ga7i suntside Simoona, E ishe Inddirase, Yayqooba, Wahannisa, Filphoosa, Bartolomiyoosa, ");
INSERT INTO oydl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatoosa, Toomaasa, Ilfiyoosa na7a Yayqooba, fa gaditis qana7ize Simoona, ");
INSERT INTO oydl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yayqooba na7a Yihudan Yesuusa aatsii inggide Asqorootu Yihuda. ");
INSERT INTO oydl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuusa Hawaaruntsara wolla derizeppa wodhdhii ganas bessa eqqida. E tamaaruntsappa gaamuntsi yinna besite yene Yihuda sa7a ubbappa Yerusalaameppa, Xiroosappan Sidoona abba gaxappa yi7ide gaama asuntsi yene. ");
INSERT INTO oydl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Un yi7idanna E tamaarssizebaz si7odesin fa hyarggitippa faxodes. Tuna ayyaanara waayinttize asuntsin faxida. ");
INSERT INTO oydl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wolqqa eeppa kezii asuntsana ubba fatstsize gisho asuntsi eza bochchodes koyane. ");
INSERT INTO oydl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Fa tamaaruntsago bi7i hyannigaara yagayda: «Hyantseso, dahuntso, yin anjjinttiduntsana; Xoozze ka7itumo yinttis. ");
INSERT INTO oydl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yin hyatte naydhdhizuntsi anjjinttiduntsana, yin mishshada. Yin hyatte yeekkizuntsi anjjinttiduntsana yin miicoda. ");
INSERT INTO oydl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Asi yinttana ta gisho ixxize wode yinttana shaakkize wode yinttana un toochize wode, iita suntsi un yinttis inggize wode yin anjjinttiduntsana. ");
INSERT INTO oydl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«Yikke, yin anjjita salo damma maaqqide gisho ye wode ufayssara dollote. Akkos gayko, zaga un aduntsi nabuntsalla afa yinnii gaar oochchida» ");
INSERT INTO oydl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Yezin dure asuntso yinttana bade; yin hyatte lo77o yestto ekkida. ");
INSERT INTO oydl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Hyatte mizhiduntso yinttana bade; yin naydhdhoda. Hyatte miicizuntso yinttana bade yin kaydhdhoda yeekkoda. ");
INSERT INTO oydl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Asi ubbuntsi yin lo77otitsito xalaala ohize wode yinttana bade. Un aduntsi zaga worddo nabuntsalla afa yinnii gaar oochchida. ");
INSERT INTO oydl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Yezin tana si7ize yinttis ta ohine; yin morkkuntsana kadhote; yinttana ixxizuntsis lo77o baz oochchote. ");
INSERT INTO oydl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yinttana baaddizuntsana anjjote, yinttana qohizuntsis woossote. ");
INSERT INTO oydl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Fettii zala dhookiza baqqiko hyankko zalza beezo. Ne kootiza ekkoda gaazes ne shaamizayan gujjii inggo. ");
INSERT INTO oydl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nena woossize ubbuntsis inggo; neeppa ekkiza ooden maho ga7i oocippe. ");
INSERT INTO oydl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Asuntsi yinttis oochchode gaar yin koyzanni fana yinttin asuntsis oochchote. ");
INSERT INTO oydl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Yin yinttana kadhize asuntsana xalaala kadhiko, akko galata yinttis yeze? Melle atto yezin, nagaranchchuntsin fana kadhizuntsana kadhane. ");
INSERT INTO oydl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yinttis lo77o baz oochchizuntsis xalaala lo77o baz oochchiko yinttis akko galata yeze? Nagaranchchuntsin yinnii gaara oochchane. ");
INSERT INTO oydl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tal77e mahode asuntsis xalaala yin tal77iko akko dumma galata yeze? Nagaranchchuntsin suub mahode as bi7i tal7ane.» ");
INSERT INTO oydl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Yezin yin morkkuntsana kadhote; unttis lo77o baz oochchote. Suuba ekkodes qoppikaayzara tal77ote. Yinne yin ekkode anjjita damma maaqqada. Yin Ubbappa kattara yeze Xoozze na7untsana maaqqada. E fana galatosuntsisin iituntsisin dalgga. ");
INSERT INTO oydl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yin salo aday maariza maaqqidanni gaara yinttin maarizuntsana maaqqote. ");
INSERT INTO oydl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Asalla firddippete; yinttalla afa firddinttoos. Yin borinttaame fana oonan borippete. Atto ga7ote; Xoozii yinttis atto ga7oda. ");
INSERT INTO oydl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Inggote; yinttis ingginttoda. Yin makkidanne yinttis mahi makkinttoda, lo77o makkize bazite baqqii, kumutsi, lanttode wontsis yinttis makinttii ingginttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Manin Yesuusa yaga7i unttis aazize ohida; «Qooqize qooqe kaalitsodes dandda7ane? Kaalitsiko lam77untsi wol ekkii gaga qitosaane? ");
INSERT INTO oydl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamaare asttamaareppa aadhoos. Yiikon loytsii tamaaride atstse fa asttamaarize fana yi7ane. ");
INSERT INTO oydl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Ne ishe aafte yeze buuriza akkos be7e? Ne aafte yeze tuusi fana yeza akkos bo7osa? ");
INSERT INTO oydl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne aafte yeze tuusi fana yeza bi7ikaayzara ne ishego, ‹Ta ishayo ne aafte yeze buuriza kesso› ga7odes wayzi dandda7e? Hyay cubbuzayo, tiinidhii ne aafte yeze tuusi fana yeza kesso. Yinnippa suuba, ne ishe aafte yeze buuriza kessodes geeshi be7ada. ");
INSERT INTO oydl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Lo77o minxa iita aafe aafoos; yinnii gaara iita minxa lo77o aafe aafoos. ");
INSERT INTO oydl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aafe aafize minxa ubbanna fa aafte erinttane. Anggatsappa belese minxa aafe maxinttoos mahi hyalimoppa woyne aafe maxinttoos. ");
INSERT INTO oydl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lo77o asi fa wozintte kumide lo77o baztippa lo77o baz kessane. Iita asi fa wozintte kumide iita bazitippa iita baz kessane. Asi fa wozintte kumii tirfide bazappa fa doonara ohine. ");
INSERT INTO oydl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ta gaazanno yin oochchoos, yezara yeezin akkos tana, ‹Laatstso, Laatstso, ga7ete?› ");
INSERT INTO oydl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Taago ye7izen ta qaaltto si7i folize ubbuntsi oona aazizako ta yinttana beessada. ");
INSERT INTO oydl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","E keetstsi keexxodes ziqqii yiizii, olla bookkide, oomora yeze lallalla afa keetstsi esside cincca atstsa aazane. Hyaro goggii ye keetstsa urqqida, yezin mintsii keexide gisho en7isades dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yezin ta qaaltto si7i oochchoose fa keetstsito shafella afa baasikaayzara keexxide atstsa aazane. Hyaro goggii ye keetstsa urqqide wode ellisii gol7ida. Ye keetstsize damma gol7e gol7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuusa yinno ubba asuntsi tiino tamaarssi hyaasidanippa suuba, Qifirnahoome katama qitida. ");
INSERT INTO oydl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yinna besite fettii Roome mato hyalaqa yene. E gaama kadhize arize hyargginttii hyayqos yellida. ");
INSERT INTO oydl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E Yesuusa baz si7ide wode fa ariza fatstsode fana eza woosso ga7i fettii fettii Ayhude cimuntsana Yesuusago kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiitinttiduntsi, Yesuusago hyanggi, «Ne ees hyanno oochchodes beezane. ");
INSERT INTO oydl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Akkos gayko, hyay atstsay nu asuntsana kadhane, Ayhude woosa Keetstsin keexxida» yaga7i mintsii woossida ");
INSERT INTO oydl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesuusan unttara hyanggida. Mato hyalaqize karago ukkide wode fa lagguntsana eego kiittii, «Laatstso, ta keetstsa ne gelodes beezoosse gisho labbippe. ");
INSERT INTO oydl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Taanin tana ne tiintte shiiqodes beezze asi ga7i qoppoos. Yezin ne fettii qaala oho; ta arize faxoda. ");
INSERT INTO oydl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taas taappa kattara hyalaqa yene, taappa yeekkara ta kiittize wottaddaruntsi yene. Feta, ‹Qito› gayko qitane, hyankaya, ‹Yo7o› gayko ye7ine. Ta arizego, ‹Hyanno yiizo› gayko yiizane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuusa yinno si7ide wode gaama qoppida. Suub maaqqii fana kaallize asuntsago, «Ta yinttis turo ohine; melle atto yezin Isra7eeluntsappan hyannii gaar damma ammano denggikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kiitinttiduntsi kara maaqqide wode arize faxin denggida. ");
INSERT INTO oydl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eeratsi wodeppa suuba Yesuusa Nayne katama qitida. E tamaaruntsaran melle gaama asuntsi eera qitida. ");
INSERT INTO oydl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","E katama gelodes yi7ize wode aha tookkii gaama asi katamappa kezane. Hyayqqide na7ay fa inttis fetto, izan budano maaqqii yene. Katama asuntsappa gaamuntsi iira yene. ");
INSERT INTO oydl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Laatstsii izo bi7i yiqsinttii, «Yeekkippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Shiiqii shanchafiza bochchin tookkide asuntsi eqqida. Yesuusa, «Naate, na7atitsayo denddo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hyayqqiday denddii bettii ohe aykkida. Yesuusa na7aya dentsii inttis inggida. ");
INSERT INTO oydl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Asuntsi ubbuntsi zhashtii, «Damma nabe nu gidda denddida; Xoozii fa asuntsana bi7ida» yaga7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","E suntsita Yihudan yinna kara gancce yeze sa7ite ubbanne sinttida. ");
INSERT INTO oydl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Xammaqize Wahannisa tamaaruntsi yinno ubbanno Wahannisas ohida. E un giddappa lam77untsana xeegii, ");
INSERT INTO oydl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«Yo7oda ga7inttide nenane? Woy melle naagode?» yaga7i oocote ga7i Laatstsago kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Asuntsi Yesuusago hyanggi, Xammaqize Wahannisa, «Yo7oda ga7inttide nenane? Woy melle naagode?» ga7ote ga7i nuna neego kiittida yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Yinna saate Yesuusa gaama asuntsana hyarggeppa fatstsida. Gaama tuna ayyaanuntsana kessida, qooqide aafen bi7izida. ");
INSERT INTO oydl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wahannisa kaleppa kiitinttii ye7ezuntsago, «Hyanggi yin bi7idannon si7idannon Wahannisas ohote. Aafe qooquntsi be7ada, tohe gundduntsi billinttii yedhdhoda, qursumara hyarggnttizuntsi faxoda, tulluntsi si7oda, hyayqqiduntsi hyayqoppa denddoda, dahuntsis Wonggele sabbakinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ta gidda dhubunttoosse ooden anjjinttidaya.» ");
INSERT INTO oydl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wahannisa kiittiduntsi qitidannippa suuba Yesuusa asuntsis Wahannisa baz yaga7i ohida: «Yin akko be7ades akko baayze ganasa kezido? Baqo en7isize shombboqo be7adesine? ");
INSERT INTO oydl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yeezin, akko be7ades kezido? Bonchcho ma7o ma77ide asuntsana be7adesine? Bonchcho ma7o ma77iduntsin sa7a lo77ide asuntsi kaati keetstsa yene. ");
INSERT INTO oydl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yeezin, akko be7ades kezido? Nabe be7adesine? Yee, ta yagaane: yin be7ades kezidanna nabeppa aadhizaya. ");
INSERT INTO oydl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","« ‹Ne ogito ne tiintte giigize ta Kiitanchchiza neeppa tiino ta kiittoda› ga7intti xaafinttidanna yinnisi. ");
INSERT INTO oydl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta yinttis ohine; maachippa yelinttiduntsi giddappa Wahannisappa aadhize baaya. Xoozze ka7itumtte ubbappa eerizay, E ubbappa damma maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Melle atto yezin, giira gachchizuntsii ubbuntsi Wahannisa kushite xammaqinttiduntsi Yesuusa qaaltto si7i Xoozii xillo maaqqidanno qonccizida. ");
INSERT INTO oydl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yezin Farisaawuntsin higge asttamaaruntsi Wahannisa kushite xammqinttanxxi Xoozze zortto leqqida. ");
INSERT INTO oydl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuusa kaallii hyannigaara yagayda: «Yikke, hyanna wode yeletuntsana akkora aazizo? Unttin oona aazane yessa? ");
INSERT INTO oydl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gabe gidda bettii wol xeegii, ‹Nu yinttis suulunqe fuggin, yin yexxoos. Nu nashshii gayrin, yin yeekkoos› yagaaze na7untsana aazane. ");
INSERT INTO oydl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xammaqize Wahannisa mu7ikaayzaran uzhikaayzara yi7in, ‹Iita ayyaanara yene gayda.› ");
INSERT INTO oydl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","As Na7ay mu7iteran woyne uzhittera yi7in, hyay atstse ‹Muus zhimbbaran ushi asi, giira gachchuzuntsisin nagaranchchuntsi zhame› gayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yikke, Xoozze cinccatitsi oochara qonccida». ");
INSERT INTO oydl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fettii Farisaawize Yesuusa katstsa muussades fa kara xeegida. E Farisaawize kara hyanggi leemate kale bettida. ");
INSERT INTO oydl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Yinna katamite fettii nagaranchcho maacha yezanna Yesuusa Farisaawize kara muusalla afa yezanno si7ide wode gaama al77o Albasxiroose bilqqaaxe shitto ekkii yi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesuusas suuba zalara, iza tohiti kale eqqii yeekkitera iza tohito fa afutsitira laakitsane. Fa ommitira iza tohito ucciteran yeerite shitto tizhida. ");
INSERT INTO oydl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mu7ize bazito giigizide Farisaawize yinno be7eze wode fa wozintte, «Hyayni nabe yezako hyanna maachita eza bochchizanna oode yezako mahi iza nagara de7or maaqqidanno E erod yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuusa, «Simoona, ta nees ohize baz yene» yagayda. Ezin, «Asttamaarizayo, taas oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesuusa eego, «Lam77i asuntsi fettii atstseppa bira tal77ida. Fete ichchin xeeti bira hyankay mahi ishintam bira tal77ida. ");
INSERT INTO oydl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lam77untsin tal77ito ciggodes gamin, lam77untsisin tal77ito maarida. Yikke, hyantsi lam77untsappa ye atstsa gaama kadhode nees aaya aaze» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoona, «Gaama gale atto ga7inttide atstse gaama kadhoda aazane» yagayda. Yesuusa, «Ne turo firddida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yinnippa suuba, Yesuusa maachitigo maaqqii bi7i, Simoonago, «Hyanno maachito be7ine? Taanii ne kara gelin melle attin ne taas tohe hyaatsi inggikaaya, yezin iza ta tohito fa afutsitira laakitsii fa ommitira uccida. ");
INSERT INTO oydl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne tana yeerii biikaaya, yezin iza ta ne kara gelidannippa aykkii ta tohito yeere ashshikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne ta ommite zayte tizhikaaya, yezin iza ta tohito shitto tizhane. ");
INSERT INTO oydl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iza tana gaama kadhide gisho I gaama nagartta atto ga7inttida. E eerats nagartta atto ga7inttide eeratsi kadhane.» ");
INSERT INTO oydl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesuusa maachitigo, «Ne nagartta atto ga7inttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ezara wolla leemate bettii mu7ize zaqquntsi, «Nagara atto gayde, E hyayni oode?» yaga7i fa wozintte qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuusa maachitigo, «Ne ammantta nena ashshida; saro qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yinnippa suuba, Yesuusa Xoozze ka7itumo Wonggele sabbakitera katamaran kara ganccera aadhida. Ye wode taphpho lam77untsin eera yene. ");
INSERT INTO oydl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Maaqqii tuna ayyaanappan dumma dumma hyarggeppa faxide fettii fettii maachuntsi eera yene. Unttin, laappun tuna ayyaanuntsi kezide Magdela Mayramo, ");
INSERT INTO oydl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Heroodisa shuumide Kuuza machchito Yohaanna, Soosinaran mahi melle gaamuntsi unttana birara maaddizuntsi yene. ");
INSERT INTO oydl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gaama asuntsi dumma dumma katamappa eego shiiqin aazizera unttis ohida. ");
INSERT INTO oydl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Fettii wooti aqizay budutsi budodes kezida. E budodera fettii fettii budutsita ogella wodhdhii yedhdhinttida, Landda maxida. ");
INSERT INTO oydl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Melluntsi lalla oomora yeze sa7alla afa wodhdhida. Hyaga dolodera sa7ite laako baayze gisho miccida. ");
INSERT INTO oydl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Melle budutsita mahi anggatsi gidda wodhdhida. Anggatstira wolla diccide gisho anggatsita cuullii besite ashshida. ");
INSERT INTO oydl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Melluntsi lo77o sa7alla afa wodhdhida. Dolide wode xeeti kushe aafida.» Yinno ohi hyaasii, fa qaaltto dhoqi yiizii, «Si7ize hyaye yeze ubbuntsi si7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","E tamaaruntsi, «Hyanna aaziztis bilitsita akko?» yaga7i oocida ");
INSERT INTO oydl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","E, «Xoozze ka7itumo gaatsi qofa erode fana yinttis ingginttida. Yezin melluntsi bi7ite denggaame gaar, si7ite tiiraame gaar aazizera ohine. ");
INSERT INTO oydl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Yikke, hyanna aazizitis bilitsita hyanno: budutsi ga7inttide Xoozze qaala. ");
INSERT INTO oydl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ogella wodhdhide budutsita qaala si7izuntsana. Maaqqo yezin, un ammanii attaame fana Xalahe qaaltto un wozinttippa maxii hyaasane. ");
INSERT INTO oydl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lalla oomo yeze sa7alla afa wodhdhide budutsita qaala si7i ufayssara ekkizuntsana. Un hyattes ammananep attin xapho baayze gisho faatana yellide wode ellisii kaaddane. ");
INSERT INTO oydl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Anggats gidda budunttezuntsi qaala si7izuntsana. Unttin alame qofara, duretitsara sa7a yessi giigara cuulunttii koshshize fana aafikaay. ");
INSERT INTO oydl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lo77o sa7alla wodhdhide budutsita lo77o wozinara qaala si7i naagizuntsanan dandda7ara miinggi aafe aafizuntsana. ");
INSERT INTO oydl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Xomppe xomppii, kurkuro guphii woy datsappa oomora gaddize baaya. Gelize asi be7ade gaar dhoqqa bessa gaddane. ");
INSERT INTO oydl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«Yinnii gisho, aachinttide qoncce kezikaayzara geenggide geesha kezikaayzara attode baz baaya. ");
INSERT INTO oydl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«Yikke, yin qaala wayzi si7izako tiirote. Yeze ubbuntsis gujintti ingginttoda, baayzes melle atto yezin ees yeze eeratsitan eeppa ekinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuusa inttiran ishuntsara eego yi7ida. Yezin as gaamatitsappa denddi eza denggodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Fettii asi Yesuusago, «Ne inttiran ne ishuntsara nena koyi bale kafane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesuusa mahi, «Xoozze qaala si7i oochalla feeshizuntsi ubba taas inddon taas ishen» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Fettii wode Yesuusaran E tamaaruntsara wolla gongge gelii, Abba fiinggoda yagayda. Unttin qitodes denddida. ");
INSERT INTO oydl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Abballa afa un fiinggodes hyammadera Yesuusa genttida. Tiirikaayzin mintsii baqo abballa denddida. Hyaatsita gonggite gelin gonggize qoodhintte aykkide wode ubbuntsi zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","E tamaaruntsi eego shiiqii, «Nu Laatstsayo, nu Laatstsayo, nu dhabane yaga7i» Yesuusa dentsida. Yesuusa denddii baqiton zuluntton kaccida. Ellisii baqitan zulunttan woppu gayda. Sarotitsin maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesuusa fa tamaaruntsago, «Yin ammantta ane» yagayda. Unttin, zhashtiteran gaama qopitera fete fetego, «Baqqon hyaatsin kiitinttize, E hyay oode» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Abba fiinggi Galila zalara yeze Gerggesoone sa7a yellida. ");
INSERT INTO oydl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesuusa gonggeppa kezii sa7a wodhdhodera tuna ayyaanara aykkinttide atstse katamappa kezii eera yellinttida. Gaama bere afula ma77anxi kallo booza yenep attin kara geloos. ");
INSERT INTO oydl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yesuusa be7eze wode E tiintte bunqqunttii, fa qaaltto dhoqi yiizii, «Ubbappa kattara yeze Xoozze na7ayo Yesuusa neera taas akko fettetitsi yeze? Aade tana hyatte un7itsippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yinno E gaydanna, tuna ayyaanze atstseppa kessade gaar Yesuusa kaccide gisho. Gaama wode tuna ayyaana eza aykkii gam7ide gisho santsalaataran tohe accize meqora acinttii naaginttane. Yezin achito duutsii tuna ayyaanara izhintti akko baayze ganasa gelida. ");
INSERT INTO oydl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuusa, «Ne suntsita oode» yaga7i oocida. E, gaama tuna ayyaanuntsi eza aykkide gisho fana, «Leegiyona» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tuna ayyaanuntsi fana Si7oole kiittaame fana woossida. ");
INSERT INTO oydl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yinna besite zoozella afa mu7ize gudayille wude hyanttane. Seko gudayluntsi gidda gelone ga7i woossida, ezin «Gelote» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tuna ayyaanuntsi atstseppa kezii gudayluntsi gidda gelida. Wudita derttippa sulle gurgguxii abba geenna gidda qoodhdhinttida. ");
INSERT INTO oydl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yenggizuntsi hyanidanno be7eze wode woxxii hyanggi, katamaran kara gancce ubba ohida. ");
INSERT INTO oydl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Asuntsi hyanidanno be7ades kezii Yesuusago yi7ida. Tuna ayyaana kezide atstse ma7o ma77i, E wozintta maaqqin, Yesuusa tohe kale bettezin denggi zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eza be7eze asuntsi tuna ayyaanara aykkinttide atstse wayzi faxezako ohida. ");
INSERT INTO oydl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerggesoone kantto wutii yeze asuntsi damma zhashimo zhashtii Yesuusa fa kaleppa qitode gaar woossida. E gonggize gidda gelii suub maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tuna ayyaana kezide atstse Yesuusara yessades woossida. ");
INSERT INTO oydl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Yezin Yesuusa eego, «Ne kara maaqqo, Xoozii akko gaar damma baz nees oochchezako oho» yaga7i moyzida. Atstsayin Yesuusa akko gaar damma baz ees oochchezako katama ubba markkidhite qitida. ");
INSERT INTO oydl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Asuntsi naagii gam77ide gisho Yesuusa maaqqide wode mokkii ekkida. ");
INSERT INTO oydl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ayhude woosa Keetstsa hyalaqa maaqqide Iyaroosa gaaze atstse fa kara ye7ode fana Yesuusa tohitilla afa wodhdhii woossida. ");
INSERT INTO oydl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ees taphpho lam77i bere maaqqide fettii maachi na7a yezanna hyarginttii hyayqos yellii yene. Yesuusa hyanggize wode asuntsi eza un7itsida. ");
INSERT INTO oydl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Taphpho lam77i bere suutsii eqqanxxi goggitera gam7ide maacha yene. Iza faas yeze miishito akimes inggi hyaasida. Yezin Faxodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iza Yesuusas suub zalara shiiqii, E afula macartto bochchida, iira goggize suutsita eqqida. ");
INSERT INTO oydl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuusa, «Tana bochchide oode?» yagayda. Ubbuntsi «Nu bochchikaaya» yaga7in, Phexiroosa, «Asttamaarizayo, gaama asuntsi kaallizannon un7itsizanno bi7itera wayzi, ‹Tana bochcheze oode?› ga7e» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yezin Yesuusa, «Fettii asi tana bochchida; akkos gayko, wolqqa taappa kezidanna taas erinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Maachita, I baz qonccidanno eride wode goqitera yi7i Yesuusa tohitilla afa gol7ida. Akkos bochchezakon wayzi ellisii faxezako as ubba tiino markkidhida. ");
INSERT INTO oydl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","E, «Ta na7ite, ne ammantta nena fatstsida; sarora qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuusa hyaga ohi hyaasikaayzin, Ayhude woosa Keetstsa hyalaqa, Iyaroosa karappa fettii asi yi7i, «Iyaroosa, ne na7ita hyayqqida; asttamaariza hyarii labbizippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yezin Yesuusa yinno si7i Iyaroosago, «Zhashtippe! Ammano, ne na7ita faxoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesuusa Iyaroosa kara yellide wode Phexiroosappa, Wahannisappa, Yayqoobappa, naatii adeppan inttippa attin melle gelode gaar koykaaya. ");
INSERT INTO oydl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yinna besite yeze asunts ubbuntsi naatis yiqsinttii yeekkoder, Yesuusa, «Yeekkippete! Naata genttidap attin hyayqqikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Asuntsi naata hyayqqidanno eride gisho E ohito leqqii miicida. ");
INSERT INTO oydl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yezin Yesuusa naatii kushito aykkii, «Na7ite denddo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na7itis shemppita yi7in denddii eqqida. Yesuusa unttago, «Iis muuze baz inggote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naatii aderan inttira gaama qoppida. Yezin Yesuusa hyanno, «Oodesin ohippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuusa taphpho lam77i hawaaruntsana faago xeegii, tuna ayyaana kessode gaaran hyargge ubba fatstsode gaar wolqqan adetits wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xoozze ka7itumo baz markkidhade fana hyargginttizuntsana fatstsode fana kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","E unttago, «Gufe maaqqin silphe maaqqin katstsa maaqqin bira maaqqin lam77i ma7ize afula maaqqin oges ga7i akkon aykkippete. ");
INSERT INTO oydl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yinna katamttippa yin kessade wontsis zaqqotitsi yin gelide bessa gam7ote. ");
INSERT INTO oydl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ooden yinttana mokkanxi ixxiko yinna katamttippa kezitera unttis ersize markka maaqqade fana yin tohite yeze xurtto fixxii kezote.» ");
INSERT INTO oydl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Unttin kiitinttidanni fana kezii Wonggele ohitera dumma dumma kara gancce hyargganchuntsana fatstsitera aadhida. ");
INSERT INTO oydl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galila sa7a ahize Heroodisa Yesuusara oochinttidebazito mulo si7eze wode yirggida. Akkos gayko, fettii fettii asuntsi Wahannisa hyayqoppa denddikaayzara attaama yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bagguntsi, «Eeliyaasa benttida» gaane; melluntsi mahi, «Zaga nabuntsappa fete hyayqoppa denddida» yaga7i ohinttane. ");
INSERT INTO oydl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yezin Heroodisa, «Wahannisa afurtto ta gachchizii wodhida. Yeezin, hyannigaara yaga7intti E baz ohinttize, E oode?» yaga7i Yesuusa fa aafte be7ades koyane. ");
INSERT INTO oydl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Taphpho lam77i hawaaruntsi suuba maaqqii yi7i, un oochchidanno mulo Yesuusas ohida. E unttana ekkii Beetesayda katamappa gaxa kanggida. ");
INSERT INTO oydl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yezin gaama asuntsi Yesuusa maaqqizanno erii eza kaallida. E unttana mokkii ekkii Xoozze ka7itumo baz tamaarssida; Faxodes koyzuntsana fatstsida. ");
INSERT INTO oydl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sa7a uguride wode taphpho lam77i hawaaruntsi eego shiiqii, «Nu yeze akko baayze sa7a maaqqide gisho asuntsi dumma dumma kara ganccen kataman qitii, katstsan aqize bessi koyode fana asuntsana moyzo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yezin E, «Unttis muuze baz yin inggote» yagayda. Un, «Nuus yeze ichchin booran lam77i molon maaqqide gisho hyantsi asuntsis maaqqize katstsa nuunii hyanggi wongganxiko maaqqoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Yinna besite ichchin mukul maaqqade dhiiratsuntsii yene. Yesuusa fa tamaaruntsago, «Ichintam ichintam shaakkii shaakkii asuntsana betitsote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","E tamaaruntsi, E kiittidanni fana asuntsana betitsida. ");
INSERT INTO oydl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","E ichchin booriton lam77i moltto ekkii, Salo bi7i, Xooz galatii, baxxi asuntsana mulo yeltsode fana fa tamaaruntsis inggida. ");
INSERT INTO oydl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ubbuntsi mu7i mizhida. Unttappa attide taphpho lam77i leemate kumutsi maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Fettii wode Yesuusa fa xalaala woossodera, E tamaaruntsi eego yi7ida. E, «Asuntsi tana oona ga7e?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Un mahi «Fete fete, ‹Xammaqize Wahannisa, bagguntsi Eeliyaasa, melluntsi mahi, zaga nabuntsappa fete hyayqoppa denddida› yagaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","E mahi, «Yeezin yin tana oona ga7e» yagayda. Phexiroosa, «Neenii Xoozappa doorinttide Kiristtoosa» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesuusa hyanno oodesin ohippete ga7i mintsii ohida. ");
INSERT INTO oydl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mahin Yesuusa, «As Na7ay gaama madha ekkoda. Gade cimuntsis, kahinunts hyalaquntsisin, higge asttamaarunts kale ixinttoda. Un eza wodhoda, yezin E hyaydzintsa qamma hyayqoppa denddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuusa asunts ubbuntsago, «Tana kaallodes koyze ooden yeziko fana kaaddo, fa masqaltto ubba qamma tookkii tana kaallo. ");
INSERT INTO oydl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Fa shemppito ashshodes koyze ubbuntsi izo dhabssane, fa shemppito ta gisho ga7i dhabsize ooden izo ashshane. ");
INSERT INTO oydl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Asi alame mulobaz denggiza, maaqqikon fa shemppito dhabsize baz woy qohize baz maaqqiko eza akko maadde? ");
INSERT INTO oydl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ooden ta giddan ta qaaltten yeellidhiko As Na7ay fa bonchchora yinnii gaara aday bonchchoran Geeshi kiitanchchuntsi bonchchora ye7ize wode ize yeellidhoda. ");
INSERT INTO oydl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta yinttis turo ohine; hyanne eqqiduntsi giddappa Xoozze ka7itumo bi7ikaayzara hyayqqoosse asuntsi yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuusa yinna ohito ohin, osfun qammappa suuba Phexiroosa, Yayqooban Wahannisan faara ekkii woossodes derella afa kezida. ");
INSERT INTO oydl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","E woosalla afa yezin E sintta laaminttida; afulttan awa fana foo7i booxxida. ");
INSERT INTO oydl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lam77i asuntsi, unttin Museran Eliyaasara bonchchora benttii, ");
INSERT INTO oydl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yerusalaame folinttodes yeze baz, yinnan, E hyanna alamttippa shaakkinttode baz eera ohinttane. ");
INSERT INTO oydl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phexiroosan eera yezuntsi genttii attin, un genttoppa denddize wode E bonchchiton eera eqqide lam77i asuntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Asuntsi Yesuusappa shaakkintti qitodes yi7adera, Phexiroosa Yesuusago, «Laatstso, hyanne yezanna nuus akko gaar lo77o! Feta nees, feta Muses, feta Eliyaasas mahi hyaydzdzi gaabba gaabboda» gayda. Yezin E faas akko ga7ezakon eroos. ");
INSERT INTO oydl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","E yaga7i ohinttodera dhonne yi7i unttana goozida. Tamaaruntsi dhonttii gidda gelitera zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dhonne giddappa, «Ta dooride na7ay hyaya eza si7ote» yagaaze ootsii sinttida. ");
INSERT INTO oydl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ye ootsize sinttidannippa suuba Yesuusa faas yezite benttida. Ye wode un bi7idanno oodesin ohikaayzara, fa wozintte aykkii si77i gayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wonttistto un derizeppa wodhdhize wode gaama asuntsi yi7i eera yellinttida. ");
INSERT INTO oydl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ye wode asunts giddappa fettii asi, «Asttamaarizayo, ta fettii na7aya yi7i bo7oyo. ");
INSERT INTO oydl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tuna ayyaana qoppikaayzin aykkii wuysizane; goppuntto cooshi gudutstsane, ashito qohi un7itsi kessades koyoos. ");
INSERT INTO oydl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne tamaaruntsi kessode gaar woossida, yezin un dandda7ikaaya» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesuusa, «Ammano baayze wobbo yeletuntso, ayde yellodes ta yinttara yessade, yinttana dandda7ode? Ne na7aya hyanggi hyanka ekkii yo7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na7aya ekkii ye7ize wode tuna ayyaanze sa7a olii guuddii goqizida. Yezin Yesuusa tuna ayyaanza kaccii na7ayppa kessin fatstsida. Na7ayan na7ay ades inggida. ");
INSERT INTO oydl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Asuntsi ubbuntsi Xoozze damma wolqqito bi7i gaama qoppida. Un E oochchide bazite gaama qoppodera, Yesuusa fa tamaaruntsago, ");
INSERT INTO oydl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Hyanno ta yinttis ohizanno loytsii si7ote; As Na7ay Ayhuduntsi kushite aadhii ingginttoda» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yezin E gaydanna unttis gelikaayze gisho un tiirikaaya. Yinnii gisho, mahi oocodes zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesuusa tamaaruntsi, «Nu gidda damma maaqqade oode?» ga7i lalle aykkida. ");
INSERT INTO oydl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuusa un wozina qoftto erii zhooga na7a fa kale essi, ");
INSERT INTO oydl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«Hyay zhooga na7aya ta suntsite ekkize ooden tana ekkane, tana ekkize tana kiittezaya ekkane, yin ubbuntsappa eerizay, E damma maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wahannisa, «Laatstso, fettii asi ne suntsite tuna ayyaana kessodera bi7i E nuura maaqqoosse gisho kayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesuusa mahi, «Yinttana ixxoose, E yin bagga. Yinnii gisho, eza kayppete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuusa Salo qitize wode ukkide gisho Yerusalaame qitodes qoftto mintsii denddida. ");
INSERT INTO oydl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samaara sa7a yeze fettii kara gancce hyanggitera, ubba baz ees giigisade fana asi yeyga kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yezin E hyanggizanna Yerusalaame maaqqidanno un erize gisho un eza mokkii ekkikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesuusa tamaaruntsi Yayqoobaran Wahannisaran yinno bi7i, «Laatstso, saloppa tama wodhdhii unttana mo7o gawude fana ne koyane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yezin Yesuusa suuba maaqqii unttana kaccii, Yin gidda akko ayyaana yezako yin eroos. As Na7ay asi ashshodes yi7idap attin dhabsodes baaya yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yeygappa denddii melle kara gancce qitida. ");
INSERT INTO oydl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Un ogera hyammadera, fettii asi, «Ne qitize bessa ubba ta kaalloda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuusa mahi, «Workkanas doochii, Landdas keetstsi yene, yezin As Na7ay fa ommito shemppize bessi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hyankkayan, «Ne tana kaallo» yagayda. Yezin atstse, «Laatstso, tiinii ta adaya moogii ye7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yezin Yesuusa, «Hyayqo yezuntsi hyayqqiduntsana moogode fana unttis ashshii ashsho; ne hyanggi Xoozze ka7itumo sabbako» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mahi melle asi, «Laatstso, ta nena kaalloda, yezin tiinii ta kara asuntsana sarotsi ye7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuusa mahi, «Koxe aykkii suub bi7ize ooden Xoozze ka7itumos beezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yinnippa suuba, Laatstsii melle laappun tam lam77i asuntsana doorida. E hyammades qoppide katamiten kara gancce ubba tiinii hyammade gaara lam77i lam77i mahi kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesuusa unttago, «Yikke shiiqode katstsa gaama yezin oochchizuntsi eeratsi. Maaqqide gisho, katstsa laatstsay oochchizuntsana kiittode fana woossote. ");
INSERT INTO oydl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yikke, qitote, duruntsi fana suudhumuntsi gidda yinttana ta dakkoda. ");
INSERT INTO oydl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yin qitize ogitis, bira maaqqikon karxite caamma aykkippete. Ogella afa ooden sarotsippete. ");
INSERT INTO oydl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yin gelize keetstsa ubba tiinii, ‹Saro hyanna keetsitis maaqqe› yaga7ote. ");
INSERT INTO oydl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Saro kadhize asi yinna besite yeziko, yin sartta ize shemppoda; koyoos gayko yin sartta yinttis maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Oochchizes damooze beezze gisho yin gelide keetstsite yinttis shiishidebaz ubba mu7iteran uzhitera ize gam7ote. Fete karappa fete kara wutippete. ");
INSERT INTO oydl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Akko kataman yin gelize wode asuntsi yinttana mokkii, yinttis shiishidebaz ubba mo7ote. ");
INSERT INTO oydl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Yinna katamite yeze hyargginttizuntsana fatstsitera, ‹Xoozze ka7itumo yinttago ukkida› yaga7i ohote. ");
INSERT INTO oydl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yezin fettii katama gelize wode asuntsi yinttana mokkanxi ixxiko bucalla kezii hyannigaara ga7ote: ");
INSERT INTO oydl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Nu tohitilla yeze yin katamiti xurtto fixxane, yezin Xoozze ka7itumo yinttago ukkidanno erote› ");
INSERT INTO oydl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Xoozze firdda qamma hyanna katamttippa Soodome katamas firdda eeratsi maaqqadanno ta yinttis ohine» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaallii, Yesuusa, «Bade Koraaziine, bade Beetesayda, bade, yin gidda oochinttide kille bazita Xiroosa giddan Sidoonan oochinttezako ize yeze asuntsi azzano afula ma77i, budolla afa bettii zaga maarotitsi gelii attod yeshsha. ");
INSERT INTO oydl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yinnii gisho, yinttappa aadhii Xiroosasin Sidoonasi Xoozze firddita laafoda. ");
INSERT INTO oydl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Bade Qifirnahoome, salo yellodes nena dhoqi oochchodes koyane? Ne sulle Si7oole olinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mahin Yesuusa fa tamaaruntsago, «Yinttana si7ize tana si7ine, yinttana ekkoosay tana ekkoos, tana ekkoosay tana kiittezaya ekkoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Laappuntam lam77i tamaaruntsi kiitinttide bestippa gaama ufayttitera maaqqida. Yesuusago shiiqii, «Laatstso, ne suntsite tuna ayyaanuntsin nuus kiitinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuusa unttago, «Xalahe saloppa dada fana wodhdhodera ta bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yikke, shooshin masmaso yedhdhode fanan morkke wolqqa teqqode fana wolqqa yinttis inggida. Yinttana qohodebaz akkon baaya. ");
INSERT INTO oydl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Maaqqikon, yin suntsita salo mazggabe xaafinttide gisho ufayttotep attin tuna ayyaanuntsi kiitinttide gisho ufayttippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ye wode Yesuusa Geeshi Ayyaanara ufaytti, «Salo sa7a Laatstso, hyanno cinccuntsappan eruntsappa aachchii tamaarikaayzuntsis qonccizide gisho galatintto. Yee ta adayo, yinno ne oochchodes lo77o qofa maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Ubba bazita ta adeppa taas ingginttida. Na7ay oode yezako adeppa attin melle woy na7ay qonccissades koyzeppa melle ooden adaya erize baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kaallii, Yesuusa dumma fa tamaaruntsago, «Yin be7izanno be7izuntsi anjjinttiduntsana. ");
INSERT INTO oydl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Turo gaama nabuntsin kaatuntsi yin be7izannon si7izanno be7adesin si7odes amudhdhida, yezin bi7ikaaya, si7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yikke, fettii wode Muse woga erize fettii atstse denddii Yesuusa yaga7i faatana oochi oocida. «Asttamaarizayo, medhina de7o laattodes taanii akko oochcho?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuusa, «Muse maxaafite xaafinttidanna waage? Ne wayzi nabbabe?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Atstsay mahi, « ‹Ne Laatstsa ne Xoozza, ne kumutsi wozinappa, ne kumutsi shemppoppa, ne kumutsi wolqqappan ne kumutsi qofappa kadho. Mahi asi ne dootsiza ne ommiti gaar kadho› yagaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuusa eego, «Ne likke mahida, neenin yinnii gaara oochcho. Ne medhina de7o yessada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yezin atstse fana xillo mahodes koyi, «E ta dootsize oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","E oocidannis Yesuusa yaga7i mahe inggida, «Fettii asi yezay Yerusalaame katamapa sulle Iyaarkko katama wodhodera ogella afa faanuntsi kezii guuddida. E ma7ito gaarii ekkii hyayqoppan faxappan gidda ashshii qitida. ");
INSERT INTO oydl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Suubappa, Ayhude kahine fete yinna ogitira fa aadhe ga7i aadhittera atstsa bi7i deshshi ga7i aadhida. ");
INSERT INTO oydl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mahi fettii Leewe yezay yinna bestto yellittera atstsa bi7i melle bessara aadhii qitida. ");
INSERT INTO oydl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Yezin, fettii Samaara gade asi yezay yinna ogitira yi7itera atstsa bi7i ees yiqsinttii ");
INSERT INTO oydl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eego shiiqii, E hyarggize bessitilla zayten woynen gujjii accida. Fa hyarizella bettitsii zaqqo aqize keetstsa kanggida. Yinna besite ees koshshize baz mulo oochchida. ");
INSERT INTO oydl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wonttistto lam77i dinaare kessii zaqqo mokkize karttii ades inggi, ‹Woy7a hyay atstsa loytsii bo7o. Ta nees inggidannippa kattara ne kesside baz mulo ta nees ciggoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«Yikke, hyantsi hyaydzdzii asuntsappa faanuntsi guuddide atstses dootsidhade nees oona aaze?» ");
INSERT INTO oydl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Atstsay mahi, «Ees yiqsinttidaya» gayda. Yesuusa, «Neenin hyanggi yinnii gaara oochcho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuusa fa tamaaruntsara oge hyanggitera fettii kara gancce yellida. Yeyga Martta ga7inttize fettii maachita iza fa kara mokkida. ");
INSERT INTO oydl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iisin Mayramo gaaze misha yene, Mayrama qaala si7ite Laatstse tohe kale bettida. ");
INSERT INTO oydl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yezin Martta gaama oochara un77intti Yesuusago shiiqii, «Laatstso, ta mishta oochito ta xalaalas ashshii bettii attin ta labbize wode ne bi7itera si77i gaane? Iza tana maaddode fana ohoso» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yezin Laatstsii hyannigaara ga7i mahida, «Martta, Martta, neenii gaamabazar un77intti madhidhane. ");
INSERT INTO oydl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maaqqikon, koshshize fettibaz xalaala. Mayrama lo77o baz doorida, yinnan iippa ekinttoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Fettii wode Yesuusa fettii bessa woossane. Woosa hyaaside wode E tamaaruntsappa fete, «Laatstso, Wahannisa fa tamaaruntsana woosa tamaarsside fana neenin nuna woosa tamaarsso» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesuusa, «Hyannigaara yaga7i woossote: « ‹Salo yeze nu adayo ne geeshi suntsita anjjintto; ne ka7itumtta yo7o. ");
INSERT INTO oydl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nu hyayno qumtto nuus inggo. ");
INSERT INTO oydl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nuna qohiduntsis nu atto gaazanni fana, nu nagartto atto ga7o; faatana gidda nuna geltsippe› » yagawute yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kaalli, Yesuusa fa tamaaruntsago yagayda: «Aazizes yinttappa fetes lagge yene. E giddii bilahe fa dootsize kara hyanggi, ‹Dootso, hyaydzdzii soollo taas inggoya. ");
INSERT INTO oydl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Taas lagge maaqqide fettii asi ogeppa yi7in, ees aatsodebaz dhabida› yagaazako, ");
INSERT INTO oydl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«E laggize keetstsa gidda yezara, ‹Aade tana waaytsippe, furtsita gorddinttida. Ta na7untsin taara datsalla afa woy7ida. Yinnii gisho, denddii ne koyizebaz immades dandda7oos› yagaanene? ");
INSERT INTO oydl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta yinttis ohine; laggetitsiti gisho denddii immades koyanxi ixxikon woosara waytside gisho denddii koshshize baz mulo inggane. ");
INSERT INTO oydl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«Yinnii gisho, taanii yinttis ohine; woossote yinttis ingginttoda; koyote yin demmada; furtstsa yi7i xeegote yinttis bugunttoda. ");
INSERT INTO oydl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Akkos gayko woossize ubbuntsi ekkane; koyze denggane; furtstsa yi7i xeegizes bugunttane. ");
INSERT INTO oydl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Aduntso yin giddappa na7a molo woossin shooshi inggize oode? ");
INSERT INTO oydl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woy phuuphule woossin masmaso inggane? ");
INSERT INTO oydl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yin iituntsana maaqqii yin na7untsis lo77o baz ingge eriko, salo yeze yin aday woossizuntsis Geeshi Ayyaana wayzi aatsii inggoso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Fettii wode Yesuusa doona muumizide tuna ayyaana fettii atstseppa kessida. Tuna ayyaanize kezide fana doona muume atstse ohinttida. Asuntsin gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yezin fete fete, «Tuna ayyaana hyalaqa, Bi7elzebuula wolqqara tuna ayyaanuntsana kessane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Melluntsi mahi fattanodes saloppa malla beezode fana koyda. ");
INSERT INTO oydl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yezin Yesuusa un qoftto erii unttago, «Wol gidda shaakkinttize ka7itumo ubbanna dhabane; wol gidda shaakkinttize keetstsi gol7ane. ");
INSERT INTO oydl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xalahe ka7itumo wol gidda shaakkinttiko wayzi miinggi eqqode? Yin tana, ‹E tuna ayyaanuntsana Bi7elzebuula wolqqara kessane› yagaane. ");
INSERT INTO oydl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yikke, taanii tuna ayyaana Bi7elzebuula wolqqara kessizebaz maaqqiko kaallizuntsi oode wolqqara kessod yeshsha? Yinnii gisho, un yinttalla afa firddizuntsna maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yezin taanii tuna ayyaanuntsana Xoozze gil7ara kessizebaz maaqqiko yikke Xoozze ka7itumtta yinttago ukkidanno erote. ");
INSERT INTO oydl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Mintsii asi danccinttii fa keetsito naagizebaz maaqqiko, E qoltta bochinttoos. ");
INSERT INTO oydl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yiikon, eeppa aadhii mintsii maaqqide asi yi7i, eza wolqqidhi gamiko ammaninttii danccide danccito billizii, E qoltto bonqii melle asis shaakkane. ");
INSERT INTO oydl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Taara maaqqikaazay tana ixxane; taara shiishoosay lalane. ");
INSERT INTO oydl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Tuna ayyaana asappa kezide wode shemppize bessi koyi hyaatsi baayze bessara wutane. Shemppize bessi dhabide wode ‹Ta kezide besite maaqqada› yagaane. ");
INSERT INTO oydl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E maaqqize wode keetsita fixinttii lo77i yezin denggida. ");
INSERT INTO oydl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yinnippa suuba, hyanggi eeppa aadhii iitide melle laappun tuna ayyaanuntsana ekkii ye7ine. E gidda gelii yessi aykkane. Ye atstses tiinostippa suubanna aadhii iita maaqqane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuusa yinna ohitilla afa yessadera fettii maachita as giddappa denddii, fa qaaltto dhoqi yiizii, «Nena tookkide sazitan ne dhanggide dhantsita anjjinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yezin E, «Anjjinttiduntsi Xoozze qaaltto si7i kiitinttizuntsana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Gaama asuntsi shiiqide wode Yesuusa, «Hyanna yeletuntsi iita; kille malla koyane. Yezin Yoonasa mallitip melle unttis ingginttoos. ");
INSERT INTO oydl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yoonasa Nenewe asuntsis malla maaqqide fana As Na7ayin hyanna yeletuntsis malla maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Saaba kaatita firdda wode hyantsi yeletuntsara denddii firddoda. Akkos gayko, iza Solomona cinccatitsito si7odes sa7a gaxappa denddii yi7ida. Yikke Solomonappa aadhizay hyanne yene ");
INSERT INTO oydl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nenewe asuntsi firdda wode hyantsi yeletuntsara denddii unttalla afa firddoda. Akkos gayko Yoonasa sibkketer maarotitsi gelida. Yikke, Yoonasappa aadhize hyanne yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Xomppe xomppii aachichcha bessa woy ota gidda gaddize asi baaya. Asi foo7ito be7ade fana dhoqqa bessa gaddane. ");
INSERT INTO oydl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne gallitis foo7o ne aafto. Ne aafta lo77o maaqqiko, ne kumutsi galtta foo7ane. Nena aafe hyarggiko ne galtta ubbanna dhumane. ");
INSERT INTO oydl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yinnii gisho, ne gidda yeze foo7ize dhumaame gaar naagintto. ");
INSERT INTO oydl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yikke, ne kuntsi galtta foo7o maaqqiko, ne galtten melle dhuma bessi dhabiko, ne gallita kumutsita foo7o fana maaqqane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuusa fa ohito hyaaside fana fettii Farisaawuze faara katstsa ma7ade fana xeegida. E eera fettilla gelii muusalla bettida. ");
INSERT INTO oydl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisaawuze Yesuusa katstsa ma7adeppa tiinii kushe meeccosanno bi7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Laatstsii eego, «Yin Farisaawuntsi burccuqosin shaatesin katta zaltto meeccane. Yezin yin ganccita uuzatitsaran iitabazaran kumida. ");
INSERT INTO oydl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yin, eeyuntso, katta zaltto medhdhide ganccito medhdhiday eza baane? ");
INSERT INTO oydl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yezin burccuqon shaaten yezanno dahuntsis inggote. Ye wode yinttis ubba bazita geeshi maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Farisaawuntso yinttana bade, kartsi gaalappa, xalooteppa, yinnii fana yeze bazappa asraata kessane. Yezin xillotitsin Xooz kadhe yin gidda baaya. Melluntsana ashshikaayzara hyantsesana oochchodes beezane, yezin ashshida. ");
INSERT INTO oydl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Farisaawuntso yinttana bade, Ayhude woosa Keetstsite bonchcho oyda, gabe gidda bonchcho sarotse kadhane. ");
INSERT INTO oydl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Bestta dhabin asuntsi erikaayzara kattara yedhdhize booza aazuntso yinttana bade» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Higge asttamaarize mahi, «Asttamaarizayo, ne yinno ga7ite nuna cazhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuusa, «Yin, higge asttamaaruntso, yinttana bade, asuntsi tookkodes dandda7oose deexo toofo toossane, yezin yin yin omitis melle atto yezin gil7a bertstsaran bochchoos. ");
INSERT INTO oydl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«Yin aduntsi wodhide nabunts boozito yin giigize gisho yinttana bade. ");
INSERT INTO oydl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yikke, yin aduntsi oochito mintsodes un wodhide nabunts boozito yin loytsize gisho un iita oochchitis yin markka. ");
INSERT INTO oydl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yinnii gisho, Xoozii fa cinccatitsite, ‹Nabuntsanan hawaaruntsana ta yinttis kiittoda, yezin yin bagguntsana wodhoda; melluntsana bay7oda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yinnii gisho, hyanna yeletuntsi alame medhinttidannippa hyanno yellodes goggide nabunts ubbunts suutsitis oocinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabeelappa dentsii zharsho besttisin Xoozze Keetstsappa gidda goggide Zakkariyaasa suutsiti gisho hyanna yeletuntsi oocinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Higge asttamaaruntso, yinttana bade, eratitsi qulfe yin kushe aykkida, yezin yinttisin geloos melluntsanan geltsoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuusa yeygappa qitodes kezze wode higge asttamaaruntsin Farisaawuntsi eera ixxintti oocera waytsane. ");
INSERT INTO oydl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","E doonttippa keze qaaltte eza aykkodes koyi yinno oochchida. ");
INSERT INTO oydl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ye wode gaama mukular faydinttize asuntsi wolal afa yedhdhinttode wontsis asi asalla afa shiiqii yessadera, Yesuusa fa tamaaruntsago, «Farisaawunts irshitippa naaginttote. Yinnan un cubbotitsito. ");
INSERT INTO oydl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Qonccikaayzar aachintti, erinttoose genggii attizebaz akkon baaya. ");
INSERT INTO oydl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yikke, yin dhuma ohidebaz ubba foo7o sinttoda, qol7a gidda kalkashide baz qoncce bessa ohinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ta bagguntso, ta ohizanno si7ote; asho wodhane fattin melle akkon oochchodes dandda7osuntsana zhashtippete. ");
INSERT INTO oydl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yiikon, yin zhashitodes beeziza ta yinttis qonccissada. Yinnan wodhidannippa suuba Gaanname olodes wolqqa yezes ees zhashtote. Yee, turo gaane; ees zhashtote. ");
INSERT INTO oydl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ichchin buubbuntsi fettii santimes bayzinttoossane? Yi7op attin unttappa feten Xoozze tiintte botinttoos. ");
INSERT INTO oydl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Melle atto yezin, yin omma isintsitan faydinttii yene. Yikke, zhashtippete; gaama buubbuntsappa yin aadhane. ");
INSERT INTO oydl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Ta ohizanno si7ote; as tiino taas markkidhize ubbuntsis As Na7ay Xoozze kiitanchchuntsi tiintte markkidhoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","As tiino tana kaaddizes Xoozze kiitanchchuntsi tiintte ta eza kaaddoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","As Na7alla afa leqqo qaala ohize ubbuntsi maarotitsi demmada, yezin Geeshi Ayyaanalla afa leqqo qaala ohizes maarinttoos. ");
INSERT INTO oydl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Asi yinttana aykkii Ayhude woosa Keetstsa, daynnuntsi tiintten kaatuntsi tiintte gochichize wode akko ohodyezakon waagii mahod yezako yirggippete. ");
INSERT INTO oydl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ye wode yin ohodebaz Geeshi Ayyaana yinttana tamaarssoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","As giddappa fettii asi Yesuusago yi7i, «Ta ishe taas nu aday laatappa shagode fana ees oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuusa mahi, «Naate atstsayo, yinttalla afa tana daynnan laata shaakkize cima mahide oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mahika Yesuusa, «Asi yessi qolo gaamatitsara maaqqoosse gisho iira ashshii mintsii yinttana naaginttote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaallii aazizera, «Gade gaama katstsa inggize fettii dure atstse yene. ");
INSERT INTO oydl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ye atstse, ‹Ta katsito ta shiishodes bessi eeride gisho akko oochcho?› yaga7i fa wozintte qoppida. ");
INSERT INTO oydl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yikkeppa yeyssada; tiino yeze fachito lalii melle dalggii facha keexxoda. Katsiton taas yeze baz mulo ize shiishoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Fa shemppitigo, ‹Ta shemppite, gaama beres nees maaqqade qolo shiishida. Yikke, shemppii mo7o, uzho, ufaytto› yaga7oda. ");
INSERT INTO oydl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Yezin Xoozii, ‹Naate, eeya hyay atstsayo, hyayno qamma ne shemppita neeppa ekkinttane. Yikke, ne shiishide bazita oodes maaqqade?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«Yinnii gisho, faas duretitsi sa7a shiishize asis, Xoozze kale dure maaqqoosse asis foltta hyay atstsestii fana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yinnippa suuba, Yesuusa fa tamaaruntsago, «Yikke, ta ohizanno si7ote, yin shemppitis akko mo7o yin galttis akko ma77o yaga7i un7inttippete. ");
INSERT INTO oydl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Shemppo katstsappa galla afulappa aadhane. ");
INSERT INTO oydl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Landduntsana bo7ote budoos, maxoos, elen fachan baaya. Yezin Xoozii unttana muuzane. Yin landduntsappa gaama aadhane. ");
INSERT INTO oydl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yeezin, yinttappa un7intti fa berttilla afa fettii qamma gujjodes dandda7ize oode? ");
INSERT INTO oydl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yikke, hyanna eeratsi bazito oochchodes dandda7oose yin mellebazis akkos un7intte? ");
INSERT INTO oydl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ane fudhe wayzi diccizako bo7ote. Waayoos suqqoos. Melle atto yezin, Solomonan fa yeze bonchchite ubbanne unttappa fete gaarzan ma77ikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Yin, ammano faccezuntso, yikke, Xoozii hyayno benttii wontta tama olinttode fudhito hyannigaara ma7isiko, yinttana wayzi aatsii ma7isoso? ");
INSERT INTO oydl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yinnii gisho, akko mo7o woy akko uzho ga7i un wozintto izilla afa mahippe. ");
INSERT INTO oydl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yinno ubba Xooz ammanoosse asuntsi fa wozintto izilla mahane. Yezin yin aday Xoozay yinna ubbanna yinttis koshshizanno erane. ");
INSERT INTO oydl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ubbannippa aatsii Xoozze ka7itumo koyote yinna ubbanna yinttis gujjii ingginttoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Yin, eeratsi worzhuntso, zhashtippete; yin aday Xoozze ka7itumtto yinttis immades ufayttane. ");
INSERT INTO oydl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yinttis yeze baz bayzi dahuntsis inggote. Kayzo ekkosanne, bila mo7osanne, cinggoosse karxite, hyal7oose qoltto salo shiishote. ");
INSERT INTO oydl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yin wozintta yin qoltta yeze besite maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Danccinttii giiginttote; yin xomppita foo7izanno maaqqe. ");
INSERT INTO oydl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Fa laatstse zhaganappa maaqqade wontsis barkki naagizuntsi fana, laatstsii yi7i xeegize wode ellisii bugodes giigide asunts fana yi7ote. ");
INSERT INTO oydl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Fa laatstse maaqqize wode genttikaayzara naagizuntsi anjjinttiduntsana. Turo gaane; laatstsii danccii leemate kale betitsii mokkane. ");
INSERT INTO oydl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Laatstsii giddii bilahe maaqqin woy wontti maatse maaqqin yi7i, yinnii fana genttikaayzara naagizin denggide yentsi aruntsi anjjinttiduntsana. ");
INSERT INTO oydl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yezin hyanno erote; kayzo ayde ye7odyezako karttii aday erizako keetsita bookkinttize wode si77i ga7i bo7oos. ");
INSERT INTO oydl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yinttin giigii naagote; As Na7ay yin qoppikaayze wode ye7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phexiroosan, «Laatstso hyanna aazizto nu xalaalas ohinene woy as ubbuntsis?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Laatstsii mahi, «Yikke, katstsa muussades beezze wodite inggode fana laatstse fa aruntsalla afa shuumide ammantsizayin wozinaama hyalaqize oode? ");
INSERT INTO oydl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Laatstsii maaqqize wode yinnii fana oochitera benttize arize E anjjinttidaya ");
INSERT INTO oydl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta yinttis turo ohine; fa laatstses yeze qolo ubbannilla afa E shuuminttoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yezin ye arize, ‹Ta laatstsay elle ye7oos› yaga7i fa wozintte qoppii, maachi aruntsanan dhiiratsi aruntsana hyadhdhiko, mahi faas koyde fana mu7iteran uzhitera matstsiko, ");
INSERT INTO oydl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ye arize laatstse E qoppikaayze qamman yirggoosse wode ye7oda. Yi7i eza gachchii, E iddilto ammanoose asuntsara mahoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Laatstse qofa gaara giigosen E laatstse akko kadhizako eriite oochchoose arize gaama garafinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yezin fa laatstse qoftto eranxii attii garafinttodes beezanno oochcheze eeratsi garafinttoda. Akkos gayko gaama ingginttideppa gaama koynttane, gaama hyadara ekkiduntsappa gaama inggoda ga7i naaginttane. ");
INSERT INTO oydl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Taanii yi7idanna sa7alla afa tama aytsodes. Hyatte tama aykkizako tana wayzi ufayssod yeshsha! ");
INSERT INTO oydl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Maaqqo yezin, ta hyatte xammaqinttode xinqqate yene. E folinttode wontsis ta shemppita shemppoos. ");
INSERT INTO oydl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sa7alla afa sarotitsi ko7odes yi7ida yinttis aazane? Baaya, ta yi7idanna shagodes. ");
INSERT INTO oydl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Hyatteppa aykkii woli gidda shaakkinttide ichchin keetsi asuntsi fettilla yene. Lam77untsi hyaydzuntsalla afa, hyaydzuntsin lam77untsalla afa, denddii shaakkinttane. ");
INSERT INTO oydl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aday na7illa afa, na7in adella afa, intta naatilla afa, naata inttilla afa, azinze intta naaze machchitilla afa, na7ay machchita azinze inttilla afa, denddii shaakkinttoda.» ");
INSERT INTO oydl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Manin asuntsago, «Awa gelo zalara salo dhonidhize wode bi7i, ellisii, ‹Ira ye7oda› yagaane, gayde fana hyanane. ");
INSERT INTO oydl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yeekka zala baqo baqqize wode ‹Saata awoda› yagaane, gayde fana hyanane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yin, cubbuntso, Salobazin sa7abaz shaakkii erane yezin hyanna wodito shaakkii ere yinttana wayzi gamido? ");
INSERT INTO oydl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Yeezin, yin omitis akkos turtto erii firddoso? ");
INSERT INTO oydl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ne morkkizera wolla daynna tiino eqqodes hyanggitera ogella afa giigodes koyo. Ne giiganxi ixxiko goshichchii daynna tiino nena kanggoda. Daynnize nena poolises aatsii inggoda. E nena woyne oloda. ");
INSERT INTO oydl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Si7ote, fettii bakkana ashshikaayzara ciggii hyaasode wontsis ne izippa kezaamanno ero» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ye wode Yesuusago asuntsi yi7i Philaaxoosa wodhii un suutsitira un zharshito worqqide Galila asuntsbaz ohide asuntsi yinna besite yene. ");
INSERT INTO oydl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E hyannigaara yaga7i mahida; «Yeezin yentsi Galila asuntsi yinna iita hyayqito hyayqqide gisho Galila yeze asi ubbannippa aadhide nagaranchcho aazane? ");
INSERT INTO oydl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Baaya! Maaqqo yezin, yinttin maarotitsar maaqqaanxi ixxiko, ubbanna yinnii gaara dhaboda. ");
INSERT INTO oydl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Woy mahi Salihoome gaaze besite gimbbe woddii wodhide taphpho osfun asuntsi Yerusalaame yeze as ubbannippa aadhize nagaranchcho aazane? ");
INSERT INTO oydl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Baaya! Yezin yinttin maarotitsar maaqqaanxi ixxiko ubbanna yinnii gaara dhaboda.» ");
INSERT INTO oydl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mahin Yesuusa hyannigaara ga7i aazize ohida: «Fettii atstses woyne gade tukinttide belese minxa yene. E iippa aafe koyi yi7i akkon denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gaditii aday woyne oochchizego, ‹Aafe denggodes koyi hyaydzdzii bere yi7i bi7in akkon denggikaaya. Yinnii gisho, gachchii hyaaso; akkos sa7ito melize?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Yezin oochchizay, ‹Laatstso, I kantto oochchii ozha olode wontsis hyay berizes ashshoya. ");
INSERT INTO oydl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wontsi bere aafiko lo77o, ixxiko gachchii ashsho› » yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesuusa Sambbata qamma Ayhude woosa Keetstsa tamaarssane. ");
INSERT INTO oydl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yinna besite taphpho osfun bere tuna ayyaana bantto kuunizide fettii maachita yene. Iza kuunnidanippa denddii luule eqqodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuusa izo bi7ide wode xeegii, «Hyanna maachite, ne hyarggitippa faxida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Fa kushito iilla afa gaddin, iza iira luule eqqida. Xooz mana galatida. ");
INSERT INTO oydl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yezin Ayhude woosa Keetstsa hyalaqize zhilidhdhii astigo, «Oocha oochchize izippun qammita yene. Yinnii gisho, yinna qammite yi7i faxote fattin Sambbata qamma koshoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Laatstsii, «Cubbuntso, yin giddappa bora woy hyaarii Sambbata qamma zadaloppa billii hyaatsi ushshodes kanggoosse oode? ");
INSERT INTO oydl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yeezin, hyanna maachita Abrahama na7a maaqqitera xalahera acinttii taphpho osfun bere kumutsi yezidannis Sambbata qamma bilinttodes beezosaane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","E yinno ohide wode ixxizuntsi ubba yeellidhida. Yezin asuntsi ubba E oochchide gaama qofize oocha ubbanne ufayttida. ");
INSERT INTO oydl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yinnippa suuba, Yesuusa hyannigaara yagayda, «Xoozze ka7itumtta akko aaze? Izo akkora aazisade? ");
INSERT INTO oydl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xoozze ka7itumo fettii asi fa gadite tukkide wala aafe fana. E diccii minxa maaqqida. Landda E koshtilla afa shemppida.» ");
INSERT INTO oydl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mahi, «Xoozze ka7itumtto akkora aazisade? ");
INSERT INTO oydl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Fettii maachita gaama dhiillara worqqii munuqide eerats irshsho aazane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yinnippa suuba, Yesuusa Yerusalaame qititera E aadhize ogite yeze katamiten kara gancce tamaarssite aadhida. ");
INSERT INTO oydl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Fettii asi Yesuusago, «Laatstso, attoduntsi eeratsi as xalaalane?» ga7i oocida. Yesuusa unttago, ");
INSERT INTO oydl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Si7ote, xuuntsi furtsara gelodes minggote. Gaamuntsi gelodes koyane yezin unttis hyanoos. ");
INSERT INTO oydl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kartti aday denddii furtsito gorddidannippa suuba ‹Nuus bugoya› ga7i bale eqqii xeege aykkoda. Yezin E, ‹Yin oona yezakon abappa ye7ezakon ta eroos› ga7i mahoda. ");
INSERT INTO oydl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ye wode yin, ‹Neera wolla mu7ida, uzhida, nu bucalla tamaarssida› yagawuda. ");
INSERT INTO oydl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«E mahi, ‹Yin oona yezakon abappa ye7ezakon eroos. Yin, wobbuntso taappa hyaakkote› yagawuda. ");
INSERT INTO oydl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abrahama, Yisaaqa, Yayqooban nabunts ubbunts Xoozze ka7itumtte bo7oda, yezin yin bale wodhdhii attize wode yinttis yeefon achchi garcingge maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asuntsi awa kessappa, awa geloppa, wookka zalappan yeekka zalappa yi7i Xoozze ka7itumtte muusalla afa bettoda. ");
INSERT INTO oydl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yinnii gisho, hyatte yestte suub maaqqiduntsappa tiino maaqqaduntsi, tiino maaqqiduntsappa suub maaqqaduntsi yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ye wode Farisaawutsappa fete fete yi7i, «Heroodisa nena wodhodes koyze gisho hyanna bestippa denddii qito» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","E mahi, «Hyanggi, ye workkanzes yikke, ‹Hyaynon wontta tuna ayyaanuntsana kessoda, hyargginttizuntsana fatstsoda, hyaydzintsa qamma fololla afa yelloda› yagayda ga7ote. ");
INSERT INTO oydl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yi7op attin, nabe Yerusalaameppa melle bessa hyayqqodes beezoos. Yinnii gisho, hyaynon, wonttan yintton feezhii yinna bestto qitodes denddida. ");
INSERT INTO oydl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yerusalaame, Yerusalaame, nabuntsana wodhizanne, neego kiitinttiduntsana shuchchara wodhizanne, lukule fa na7untsana fa qefiti gancce shiishizanifana ne na7untsana ta kushtippa oomora wantsi tohe shiishodes koydo, yezin yin koyoos gayda. ");
INSERT INTO oydl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ta yinttis ohine; yin keetsita kayzoda. Laatstse suntsite ye7ize anjjinttidaya yin gawude wontsis tana denggoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Fettii Sambbata qamma Yesuusa fettii Farisaawunts hyalaqize kara katstsa ma7ades gelize wode asuntsi dakkii be7ine. ");
INSERT INTO oydl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yinna besite shafe wodatsi hyargginttize fettii asi ees tiino zalara woy7ida. ");
INSERT INTO oydl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuusa Farisaawuntsagon higge asttamaaruntsago «Sambbata qamma hyargginttiza fatstsizanna wogaane woga baa?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Un si77i gayda. Yesuusa hyargginttize atstsa bochchii fatstsi moyzida. ");
INSERT INTO oydl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mahin yinttappa fetes na7a woy bora Sambbata qamma gaga qitiko ellisii kessoose oode?yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Un fettibazin mahodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuusa sarges xeeginttiduntsi bonchcho bessi doorizanno bi7i, hyanna aazizto ohida: ");
INSERT INTO oydl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Fettii asi nena sarge xeegiko bonchcho bessa bettipe. Neeppa aadhii bonchchinttize asi xeeginttodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yinttana lam77untsana xeegide yi7i, ‹Ne bestto hyay zaqqizes dakko› yagaaze wode ne yeellidhittera ziqqa bessa wodhdhoda. ");
INSERT INTO oydl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yezin, ne xeeginttide wode tiinidhii ziqqa bessa bi7i betto. Xeegize yi7i, ‹Ta laggizayo, hyanna bonchcho besite betto› yaga7oda. Ye wode neera fettilla xeeginttide as ubbunts tiintte ne bonchchinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Fana dhoqi dhoqi yiize ubbanna yeellidhada; fana ziqqii ziqqii yiize ubbanna dhoqi dhoqi ga7oda.» ");
INSERT INTO oydl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mahi Yesuusa eza mokkide keetstsiti adego, «Quma woy kawo sarge xeegize wode neenii kushe mahiza xeegaame fana ne lagguntsana woy ne ishuntsana woy ne iginutsana woy ne dure dootsuntsana sarge xeegippe. ");
INSERT INTO oydl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yezin, ne sarge giigizeze wode dahuntsana, wobbuntsana, gunddiduntsana qooquntsana xeego; ne anjjinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hyantses kushe mahodes dandda7oose gisho kushe mahita geeshshuntsi denddize qamma nees maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuusara wolla diggisalla afa bettizunts giddappa fete yinno si7i, «Xoozze ka7itumtte diggisalla afa bettide anjjinttidaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuusa, «Fettii asi damma diggisa giigizii gaama asuntsana xeegida. ");
INSERT INTO oydl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Diggisa mokunttize saata yellide wode xeeginttide zaquntsana, ‹Yikke ubba bazita giigida, hyayga yo7ote› yaga7i xeegode gaar fa ariza kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Yezin ubbuntsi faas madha madha medhdhida. Fete, ‹Hyatte hyaga gade wonggide gisho hyanggi be7ades beezane aade tana ashshoya yaga7o› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hyankkay, ‹Ichchin waaxa bora wonggida unttana waaxi be7ade gisho aade tana lanccipe› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mahi hyankkay, ‹Taanii hyaga medda yeze gisho ye7odes dandda7oos› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Arize maaqqii yi7i yinna ubbanno fa laatstses ohida. Ye wode diggisa aday zhilidhdhi arizego, ‹Ellisii katama yeze dalgga ogen oge gaxa hyanggi, dahuntsana, wobbuntsana, qooquntsanan gundduntsana hyankka ko7o› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Arize, ‹Ta laatstsayo, ne kiittide ubbanna folinttida, yezin hyatten bessi yene› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Laatstsii arizego, ‹Oge woralla afan, katamappa gaxa kessize oge kezo, ta keetsita kumode wontsis denggide ubbuntsi ye7ode fana oochcho. ");
INSERT INTO oydl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta yinttis ohine; xeegintti ixxiduntsappa ooden ta diggisttippa mo7osanno erote› gayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Gaama asuntsi eera wolla hyammadera Yesuusa unttago suub maaqqii, ");
INSERT INTO oydl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Taago yi7ide ubbuntsi fa adayan fa intton, fa machchiton fa na7untsana, fa ishuntsana fa mishuntsana, melle atto yezin fa de7ito ixxoose ta tamaare maaqqades dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Fa masqaltto tookkii tana kaalloose ta tamaare maaqqades dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Yinttappa fettii asi shuchchi keetstsi keexxodes koyko, keetsito keexii hyaasodes akko gaar miishe koshshizako tiinidhii erodes qoppii bo7oose oode? ");
INSERT INTO oydl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yinno maaqqanxiko, ye atstse baasa yiitsi shuchchito yiixxin fole gamiko, ");
INSERT INTO oydl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be7ize ubbanna, ‹Hyay atstse keetsi aykkin folodes eza gamida› yaga7i leqqane. ");
INSERT INTO oydl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Woy fettii kaati melle kaatara olinttodes dendditera lam7itam mukul wottadaruntsana ekkii ye7ize kaatizera taphphi mukul wottadaruntsara olintti dandda7odannon dandda7oosanno bettii zorinttoosse oode? ");
INSERT INTO oydl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Olinttodes dandda7inttoosebaz maaqqiko, ye ye7ize kaatizera hyaakora yezin giigodes tiinidhii cima dakkii oocane. ");
INSERT INTO oydl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yinnii gaara, yinttappa ooden faas yeze baz mulo ashshanxii ixxiko ta tamaare maaqqades dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Sooge lo77o, yezin sooge fa mal77ito ashshiko, wayzi sooge ga7inttodes dandda7e? ");
INSERT INTO oydl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gade araddizesin maaddoose baz maaqqize gisho alla olinttane. Yikke, si7ize hyaye yeze asi si7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Fettii wode qaraxe gachchizuntsin nagaranchchuntsi Yesuusa timirttito si7odes E kale shiiqida. ");
INSERT INTO oydl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yezin Farisaawuntsin higge asttamaaruntsi, «Hyay atstse nagaranchchuntsana shiishii ekkane, unttara fettilla muune» yaga7i zuuzinggida. ");
INSERT INTO oydl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesuusa yaga7i hyanna aazizto unttis ohida: ");
INSERT INTO oydl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Yin giddappa fetes xeet duruntsi yeze baz maaqqiko unttappa fetay dhabiko uddufun tam uddufununtsana yenggize bessa ashshii dhabidaya demmade wontsis koyoose oode? ");
INSERT INTO oydl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Denggide wode ufaytti fa gannite tookkii, ");
INSERT INTO oydl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","fa kara maaqqane. Fa lagguntsanan dootsuntsana fettilla xeegii, ‹Dhabide ta duriza denggida, taara wolla ufayttote› yagaane. ");
INSERT INTO oydl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yinnii gaara, maarotitsi koshshoosse uddufun tam uddufun xilluntsappa aatsii maarotitsi gelize fettii nagaranchchize gisho salo damma ufayssi maaqqane. ");
INSERT INTO oydl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Woy taphphi shuchchi bira yeze fettii maachita taphphitippa fettii shuchchi birize dhabiko denggode wontsis xomppe aytsii keetstsi fixxii mintsii koyosanna oode? ");
INSERT INTO oydl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Denggide wode fa lagguntsanan fa dootsuntsana xeegii ‹Dhabide ta fettii birza denggide gisho taara ufayttote› yagaane. ");
INSERT INTO oydl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Si7ote, yinnii fana fettii maarotitsi gelize nagaranchchize gisho Xoozze kiitanchchuntsi tiino ufayssi maaqqane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mahi Yesuusa, «Fettii atstses lam77i na7untsi yene. ");
INSERT INTO oydl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Unttappa geez na7ay fa adego, ‹Ta adayo, ne qolttippa ta gishtto taas inggo› yagayda. Aday fa qoltto fa na7untsis gizhida. ");
INSERT INTO oydl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eerats qammappa suuba geez na7ay fa gishtto mulo accii ekkii hyaako sa7a qitida. Yeyga kaasara qoltto lalii hyaasida. ");
INSERT INTO oydl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","E faas yezebazito mulo hyaasidannippa suuba yinna sa7ite ubbanne mintsii naye kezin madhidhida. ");
INSERT INTO oydl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yinnii gisho, yinna sa7ite asuntsappa fete kara yessades gelida. Atstsay eza gudayille yemmade gaar yenggize bessa dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gudayluntsi muuze hyarqqoppa ma7ades amudhdhida, yezin izon ees inggize asi benttikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wozina maaqqin, ‹Wantsi ta aday aruntsis katstsa alla attin ta hyanne nayera hyayqqodes yellido?› ");
INSERT INTO oydl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Denddii ta adego hyanggi, ‹Ta adayo, Xoozin, nenan qohida. ");
INSERT INTO oydl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yikkeppa ne na7a ga7intti xeeginttodes taas beezoosse gisho ne kara yeze aruntsappa fetay fana tana faydo› yaga7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yinnii gisho, denddii fa adego qitida. «Yiikon, E hyaga hyaakora yezin aday yiqsinttii, eego woxxii hyanggi iringgi yeerida. ");
INSERT INTO oydl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naazen, ‹Ta adayo Xoozin, nenan ta qohida. Yikkeppa ne na7a ga7intti xeeginttodes beezosi› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«E aday aruntsana xeegii, ‹Ellisii ubbuntsappa lo77o maaqqide ma7o ki7i eza mayzote; E gil7ite migiddo, E tohite caamma aatstsote. ");
INSERT INTO oydl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Modhdho wofaano ki7i shukkote, ma7ada, ufayttoda. ");
INSERT INTO oydl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta na7ay hyayni hyayqqida, yezin hyatte faxida; dhabida, yezin benttida› yagayda. Yinnippa suuba, ufaytte aykkida. ");
INSERT INTO oydl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Ye wode anggis na7ay oocha gade yene. Yeygappa yi7itera kara ukkodera yetstsin doolle ootsi si7ida. ");
INSERT INTO oydl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","E, aruntsappa feta xeegii hyanide bazita akko yezakon erodes oocida. ");
INSERT INTO oydl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Arizen, ‹Ne ishe saro yi7ide gisho ne aday modhdho wofaano ees shukkida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Anggis ishe zhilidhdhi keetstsa gelodesin koyikaaya. Aday bale kezii keetstsa gelode fana eza woossida. ");
INSERT INTO oydl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yezin E fa adego, ‹Yikke, hyannii gaar bere ta nees aridhdhii ne kiittippa fetton faccizikaayzara nees kiitinttin ta ta lagguntsara ufayttode fana melle atto yezin fettii gashe deeshi inggikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yezin, hyayni ne na7ay ne qoltto olaluntsara lalii yi7in modhdho wofaano shukkida› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Aden, ‹Ta na7ayo, neenii ubba wode taara yene, ta baz ubbanna nees. ");
INSERT INTO oydl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hyayni ne ishe hyayqqida, yezin faxida; dhabida, yezin benttida. Yinnii gisho, gaama ufayttodes beezane› ga7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuusa fa tamaaruntsago, «Fettii dure atstses eeppa yeekkara fettii shuuma yene. Ye shuumize fa laatstse qoltto lalane yagaaze wore karttii adaya yellida. ");
INSERT INTO oydl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Karttii aday shuumiza xeegizi, ‹Ta wagizebaz si7ido? Yikkeppa neenii ta keetstsitis shuuma maaqqii oochchodes dandda7oosse gisho ta qoltto tana yeltso› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Ye shuumizen fa wozintte hyannigaara yaga7i qoppida. ‹Ta laatstsay tana shuumatitsitippa hyaasodes yi7ine, wooti aqodes wolqqa baaya, woossii ma7ades yeellizane; yeezin ta waya? ");
INSERT INTO oydl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Shuumatitsitippa ta wodhdhize wode asuntsi tana mokkode fana oochchode baz ta erane› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Yinnii gisho, E laatstse gale yeze asuntsana feta feta xeegii ki7i tiino atstsego, ‹Neella afa ta laatstse gale wantsi yeze?› yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«E, ‹Lam7itam barmeele zayte gale yene› yagayda. «Shuumize, ‹Wule warqate hyatte, ellisii, taphphi barmeele zayte gale yene ga7i xaafo› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Yinnippa kaallii lam7antsizego, ‹Nees wantsi yeze?› yagayda. «E, ‹370 kunttaale zarga gale yene› yagayda. «Shuumize, ‹Ne wule warqate hyatte, ellisii, 296 kunttaale yaga7i xaafo› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Karttii aday ammaninttikaayze shuumiza E cinccatitsitis nashshida. Hyanna alamtti na7untsi as ayfora foo7o na7untsappa aadhide wozinaama. ");
INSERT INTO oydl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«Yinnii gisho, ta yinttis ohine; hyanna alamtti bira hyal7ize wode medhina keetstsite mokkinttode fana hyanna miishitira yinttis lagge wonggote. ");
INSERT INTO oydl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ubbappa eerats baza ammaninttide gaama baza ammaninttidaya maaqqane. Mahi ubbappa eerats baza ammaninttoose gaama baza ammaninttoos. ");
INSERT INTO oydl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yikke, hyanna alamtti birara yin ammaninttanxii ixxiko turii bira yinttis oode hyadara immade? ");
INSERT INTO oydl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yin melle as birtte ammaninttanxiko, yin buzo bira yinttis oode immade? ");
INSERT INTO oydl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Fettii arize lam77i laatstsuntsis aqodes dandda7oos. Feta ixxiko hyankkaya kadhane woy fetego shiiqiko hyankkaya leqqane. Yinnii gaara, yin Xoozisin birasin aqodes dandda7oos.» ");
INSERT INTO oydl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bira kadhize Farisaawuntsi yinno si7i Yesuusa leqqida. ");
INSERT INTO oydl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E, «Yin yinttana as tiino beezane, yezin Xoozii yin wozintto erane. As tiino bonchchinttiday Xoozze tiino borunttidaya. ");
INSERT INTO oydl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Muse higgitan nabunts kiita Wahannisa yellodes yinttis oochitera gam7ida. Yinnippa suuba, Xoozze ka7itumo Wonggeltta sabbakinttite gam7ida. Asi ubba yeyga gelodes dafinttane. ");
INSERT INTO oydl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yezin, higgitippa fettii yishsha fidaale attodannippa salon sa7an aadhizanna laafane. ");
INSERT INTO oydl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Fa machchito dakkii melle ekkize ubba olalane. Fa azinzeppa anjjinttidanno ekkizayin olalane» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Al7on lo77o bonchcho afula ma7ize, sa7a giigin ubba wode ufayssara yeze fettii dure asi yene. ");
INSERT INTO oydl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Melle mahi galtta kumutsi hyargitsi maaqqide fettii Alaazare ga7inttize dahize ye dure atstse bale olintti attiday yene. ");
INSERT INTO oydl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nayeppa denddii dure atstse leematippa wodhdhize gufa ma7ades amudhdhii yene. Melle atto yezin, kanuntsi yi7i E hyarggits besito laa7ane. ");
INSERT INTO oydl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Ye dahize hyayqqida; kiitanchchuntsi eza Abrahama shuphite ekkida. Mahi dure atstsen hyayqqii mooginttida. ");
INSERT INTO oydl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Si7oole un7intti yezitera dhoqi ga7i hyaakora Abrahaman E shuphite yeza Alaazare bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","E, ‹Aabbo Abrahama, taas yiqsinttoya; hyanna loxize tamtte un7intti yeze gisho Alaazare fa gil7iza hyaatsa dakkii ta il7antsito laakitsode fana aade eza dakkoya› yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Yezin Abrahama eego, ‹Ta na7ayo, ne sa7a yeze wode lo77o bazito ekkidanno, mahi Alaazare iita baz ekkidanno qoppo. Yezin hyatte E hyanne ufayttane, mahi ne waayintti yene› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hyanna ubbannippa aadhii, ‹Hyaygappa yinttago, sekkappa hyankka nuugo aadhodes koyzuntsi finggaame fana nuusin yinttis gidda damma gaga yene› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Dure atstse, ‹Ta adayo, yeezako Alaazare ta aday kara kiittode fana ta nena woossane. ");
INSERT INTO oydl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Taas ichchin ishuntsi yene, unttin hyanna madha besite ye7aame fana unttis wodhdhii markkidho› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Yezin Abrahama, ‹Unttis Musen nabuntsin yene; un ohizanno si7o› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Dure atstse, ‹Aabbo Abrahama, yinnii fana baaya; fettii asi hyayqoppa denddii wodhdhiko un maarotitsi geloda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Abrahama, ‹Musen nabuntsna si7anxiko, melle atto yezin hyayqoppa fettii asi denddii ohikon ammanoos› yagayda.» ");
INSERT INTO oydl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuusa fa tamaaruntsago, «As dhubutsi nagara geltsizebaz yi7ikaayzara attaama. Maaqqikon, nagara gidda gelode fana oochchize atstsa bade» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ye atstse eeratsuntsappa feta balitsodannippa woxa fa afurtte accii abba geliko ees lo77o. ");
INSERT INTO oydl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yinnii gisho naaginttote. «Ne ishe nagara oochchiko kacco; azzanii maarotitsar maaqqiko, ees atto yaga7o. ");
INSERT INTO oydl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Fettii qammite laappun tohe qohii, laappun tohe, ‹Taanii ta isidanno erida tana maaro› yaga7i neego yiiko ees atto ga7o.» ");
INSERT INTO oydl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hawaaruntsi Laatstsago, «Ammano nuus gujjoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Laatstsii, «Gaashe aafe fana ammano yinttis yeziko ‹Hyay waliza shodintti abba gidda tukintto› yagayko yinttis kiitinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gujjii Yesuusa, «Yin giddappa fetes oochchize woy duro yenggize aro yeziko oocha gadeppa woy wudeppa kara yi7ide wode ‹Elle hyayga yi7i katstsa ma7ades betto› gaaze yene? ");
INSERT INTO oydl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Baaya, ‹Taas kawo giigizo; ta mu7i, uzhii ashshode wontsis eqqii muuzo. Yinnippa suuba, ne mu7i ushshada› yaga7osaane? ");
INSERT INTO oydl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yikke, laatstse, arize kiitto folide gisho anjjanene? ");
INSERT INTO oydl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yinnii gisho, yinttin kiitinttidanno mulo folide wode ‹Nu fatsoosse aruntsana; oochchodes beezze oochito folida› ga7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuusa Yerusalaame hyanggitera Samaarasin Galila sa7asin giddara kantsii aadhida. ");
INSERT INTO oydl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Fettii kara gancce gelize wode qursuma hyarggera aykkinttide taphphi asuntsi eza denggida. Unttin hyaakora eqqii, ");
INSERT INTO oydl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«Laatstsi Yesuusa, nuus yiqsinttoya» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","E unttana bi7ide wode «Hyanggi yin galtto Ayhude kahinuntsis beezote» yagayda. Un ogella hyanggitera geezhida. ");
INSERT INTO oydl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unttappa fetay fa geezhidanno be7eze wode dhoqi gayde qaalara Xooz bonchchitera Yesuusago maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","E Samaara sa7a asi, yezin Yesuusa tohitilla afa gol7i eza galatida. ");
INSERT INTO oydl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuusa, «Geezhiduntsi taphphi asi maaqqosane? Yeezin, uddufununtsi aba qitido? ");
INSERT INTO oydl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hyay allaga atstseppa attin melle maaqqii Xooz galatide baaya ga7ene?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Atstsego, «Ne ammantta nena geeshida; denddii qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisaawuntsi, «Xoozze ka7itumo ayde ye7ode?» ga7i Yesuusa oocida. E, «Xoozze ka7itumtta benttize mallara ye7oos. ");
INSERT INTO oydl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mahin izo, ‹Hyanne woy sekka yaga7odes dandda7oos. Akkos gayko, Xoozze ka7itumtta yin gidda yene› » yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuusa fa tamaaruntsago, «As Na7a qammitippa feta bo7odes yin amudhdhode wode ye7oda, yezin yin be7aama. ");
INSERT INTO oydl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Asuntsi, ‹E yeyga yene› woy, ‹Hyanne yene› yaga7oda, yezin unttana kaallii qitippete. ");
INSERT INTO oydl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Zeelintsi zeelinggii salo gaxappa gaxa foo7ize fana As Na7a ye7iti qammita yinnii fana yi7ada. ");
INSERT INTO oydl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yezin yinna hyanodannippa tiino As Na7ay gaama madhidhadesin hyanna yelette ixinttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nohe wode yi7ide fana As Na7ay woditen yinnii fana yi7ada. ");
INSERT INTO oydl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohe Markkabe gelide qammito yellodes asuntsi mu7iteran uzhitera, ekkiteran gelitera yessadera dhabsse hyaatsita yi7i ubba dhabsida. ");
INSERT INTO oydl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Looxe beren yinnii fana yi7ida. Asuntsi mu7iteran uzhitera, wonggiteran bayzitera, tukkiteran keexitera, gam7ida. ");
INSERT INTO oydl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Looxe Soodomeppa kezide qamma diinne ga7inttize michizebaz saloppa bukkii ubbuntsana dhabsida. ");
INSERT INTO oydl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","As Na7ay qonccize woditen yinnii gaara yi7oda. ");
INSERT INTO oydl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«Ye wode ooden bale yeze keetstsa gidda yeze baz ekkodes keetstsa gelippe. Yinnii fana, gade yeze asi akko bazisin kara maaqqippe. ");
INSERT INTO oydl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Looxe machchito tiirote; ");
INSERT INTO oydl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","fa shemppito ashshodes koyze asi ooden dhabssoda; fa shemppito aatsii inggize ooden E ashshoda. ");
INSERT INTO oydl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta yinttis ohine; ye wode lam77i asuntsi fettii datsalla woy7oda. Fete ekinttoda, hyankkay attoda. ");
INSERT INTO oydl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Lam77i maachuntsi wolla gaaccodera fetta ekkinttoda, hyankkanna attoda. ");
INSERT INTO oydl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Lam77i asuntsi wolla gade oochchizuntsappa fetay ekinttoda, hyankkay attoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Un, «Laatstso aba ekinttode?» yaga7i oocida. E, «Gawuxa yeze bessa ankko shiiqane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuusa fa tamaaruntsana azal7ikaayzar ubba wode woossode fana tamaarssodes koyi yaga7i aazize ohida: ");
INSERT INTO oydl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Fettii katama Xoozis zhashtoosse asin yeellidhoosse fettii daynna yene ");
INSERT INTO oydl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Yinna katamite fettii budantta yene. Izan, ‹Taasin ta morkkizes gidda yeze mootto firddo› yaga7i ubba wode ye daynnizego mahi mahi yi7ine. ");
INSERT INTO oydl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Daynnize eerats wodes I ohito si7anxi ixxida, yezin suubappa fa wozintte, ‹Taanii Xoozis zhashtoosa, asis yeellidhanxi ixxikon, ");
INSERT INTO oydl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hyanna budantta tana waayetsize gisho iisi firddoda; yeyzanxiko ubba wode yi7i tana labbisada› yaga7i qoppida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Laatstsin, «Iita daynnize ga7idanno si7ida; ");
INSERT INTO oydl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xoozii qamman awara eego uukkize fa dooriduntsis firddosaane? Unttana maaddodes gam7odaane? ");
INSERT INTO oydl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta yinttis ohizanno si7ote, ellisii firddoda. Maaqqikon, As Na7ay ye7ize wode sa7alla afa ammano demmadyessane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mahi, Yesuusa, fana xillo asi fana mahi ceeqinttizuntsisin melluntsana leqqizuntsis hyannigaara yaga7i aazize ohida: ");
INSERT INTO oydl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Lam77i asuntsi woossodes Xoozze keetstsa hyanggida. Fete Farisaawe hyankkay mahi qaraxe gachchizize asi. ");
INSERT INTO oydl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisaawuze eqqii faas woossitera, ‹Xoozzayo taanii mellunts fana bonqize asi, iitan olale asi, aadhii mahi hyay qaraxe gachizize atstse fana maaqqikaayze gisho nena galatane. ");
INSERT INTO oydl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Saaminttappa lam77i tohe xoomane, ta denggizebaz ubbannippa asiraata kessane› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Yezin qaraxe gachizize mahi hyaakora eqqii melle atto yezin Salo dhoqi ga7i be7adesin zhashtii fa dadabito qoxxittera ‹Xoozayo, tana nagaranchchiza maaroya› ga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta yinttis ohizanno si7ote; Farisaawizeppa hyayni qaraxe gachizize Xoozze tiintte xillo maaqqii fa kara maaqqida. Akkos gayko, fana dhoqi dhoqi yiize asi toochinttoda, fana toochize asi dhoqi dhoqi ga7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesuusa zhooga na7untsalla afa fa kushito gaddii anjjode fana asuntsi eego ke7ine. Yesuusa tamaaruntsi yinno bi7i akkos Yesuusago ke7e yaga7i kaccida. ");
INSERT INTO oydl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yezin Yesuusa na7untsana faago xeegii, «Na7untsi taago yo7odanno kayppete; yo7o ga7ote. Akkos gayko, Xoozze ka7itumo un fana yi7iduntsis. ");
INSERT INTO oydl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Taanii yinttis turo ohine; Xoozze ka7itumo zhooga na7unts fana ekkoosse ooden yeyga geloos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayhude hyalaquntsappa fete, «Keeha asttamaarzayo, medhina de7o denggodes akko oochcho?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesuusa eego, «Akkos tana keehizayo yaga7i xeege? Fettii Xoozzeppa attin melle keeha baaya. ");
INSERT INTO oydl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Olalippe, wodhippe, kaystippe, worddo markkidhippe, ne adayan ne intton bonchcho yagaaze kiitto erane» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Atstsayin, «Yentsesana ubba taanii na7atitsappa aykkii naagitera gam77ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuusa yinno si7eze wode «Yikke, nees fettibaz faccane; nees yeze baz mulo bayzi dahuntsis inggo; salo nena qoltta naagane. Yeyzi maaqqii tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yezin atstse yinno si7ide wode ees gaama qolo yeze gisho gaama zhilidhdhida. ");
INSERT INTO oydl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuusa atstsa bi7i, «Dure asis Xoozze ka7itumo gelizanna wayzi un7ode! ");
INSERT INTO oydl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Dure Xoozze ka7itumo gelodannippa gimale marppe uruntsara aadhizanna laafane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yinno si7ide asuntsi, «Yeezako oode attode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesuusa, «Asis dandda7inttoose Xoozis dandda7inttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phexiroosa, «Yikke nuunii nu baz mulo ashshii nena kaallane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","«Yesuusa turo ta yinttis ohine; Xoozze ka7itumos ga7i fa keetsito woy fa machchito woy fa ishuntsana woy fa adayan fa intton woy fa na7untsana ashshide; ");
INSERT INTO oydl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hyanna wodite gaama dakko, ye7ode alamite medhina de7o ekkoosse ooden baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuusa taphpho lam77untsana faago xeegii, «Ane Yerusalaame yedhdhote, nabuntsi As Na7ay baz xaafidanna ubbanna yeyga folinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","E Ayhude maaqqoosse asis aadhii ingginttoda. Un eza leqqoda, cazhoda eella afa cuttoda. ");
INSERT INTO oydl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eza garafidannippa suuba wodhoda, yezin hyaydzintsa qamma E hyayqoppa denddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yezin E tamaaruntsi yinna ubbannippa fettibazin tiirikaaya. E qoftta unttis aachinttide gisho E waaga7ezako erikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuusa Iyaarkko ukkize wode fettii qooqe atstse oge gaxa bettii woossane. ");
INSERT INTO oydl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Qooqe atstse asuntsi yinna besttira aadhodera si7i, «Yinna akko?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Un, «Naazirete Yesuusa hyannira aadhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","E, «Dawute na7ay, Yesuusa, tana maaroya» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tiino tiino hyanggize asuntsi, «Si7i ga7o» ga7i kaccida. Yezin E, «Dawute na7ayo, tana maaro» yaga7i gaantsi uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesuusa eqqii atstsa faago ko7ode fana kiittida. Atstsayin, eego shiiqin, ");
INSERT INTO oydl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ta nees akko oochchode fana koye?» yaga7i oocida. Qooqize, «Laatstso ta bo7odes koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesuusa, «bo7o, ne ammantta nena fatstsida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Atstsay iira bi7i ashshida. Xooz bonchchitera Yesuusa kaallida. Asi ubbuntsi yinno bi7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuusa Iyaarkko katama gelii aadhane. ");
INSERT INTO oydl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yeyga Zakkiyoosa ga7inttize qaraxe gachizuntsi hyalaqize yene. E gaama dure. ");
INSERT INTO oydl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E Yesuusa oode yezako be7ades koyda. E hyaata maaqqide gisho as gaamappa denddii Yesuusa be7ades dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesuusa be7ades koyi E hyanggize ogitis tiino woxxii hyanggi fettii boobba minxalla afa kezida. ");
INSERT INTO oydl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuusa yinna besite yellittera dhoqi ga7i bi7i, «Zakkiyoosa, hyayno ta ne kara feeshades beeze gisho elle wodhdho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","E ellisii wodhdhii ufayssara Yesuusa mokkida. ");
INSERT INTO oydl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yinna besite yeze asunts ubbanna yinno bi7i, «Nagaranchchize keetstsa gelii mokinttodes yi7ane» yaga7i zuuzinggida. ");
INSERT INTO oydl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Maaqqo yezin, Zakkiyoosa eqqii Laatstsago, «Laatstso, yikke taas yeze qolo ubbannippa baggito dahuntsis inggoda. Asappa akko bazin worddora balitsii ekkidebaz maaqqiko oyddii kushe mahoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesuusa mahi, «Hyay atstse Abrahama kochchi maaqqide gisho hyayno atotitsi hyanna kartte yi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","As Na7ay yi7idanna dhabiduntsana koyodesin ashshodes» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asuntsi yinno si7ize wode Yesuusa Yerusalaame ukkide gishon Xoozze ka7itumo hyatte ukkera qonccode fana yi7ize gisho unttis aazize ohida. ");
INSERT INTO oydl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yinnii gisho, Yesuusa, «Fettii erinttide asi yeze faas kaatetitsi ekkii yo7odes melle sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ees oochchize aruntsappa taphphuntsana xeegii fetes fetes fettii minaane inggi ‹Ta maaqqii ye7ode wontsis hyanna miishitira zal7ote› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Yinna sa7ite yeze asuntsi eza ixxize gisho hyay atstse nuulla afa ka7itode fana nu koyoos yaga7i asi E suubara kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«Maaqqikon, ye atstse kaati maaqqii fa sa7a maaqqida. Yentsi taphphi aruntsii E inggide miishito akko gaar zal7i tirfizezako erodes koyi unttana xeegizida. ");
INSERT INTO oydl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«Tiinosse yi7i, ‹Laatstso, ne taas inggide minaanize melle taphpho tirfida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Eza Laatstse, ‹Naate ammaninttide arizayo lo77o oochchida. Ne eerats baza ammaninttide gisho nees taphphi katamalla afa adetits wolqqa inggida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Lam7antsizay yi7i, ‹Laatstso, ne taas inggide minaanize melle ichchin tirfida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Laatstsii eego, ‹Neesin mahi ichchin katamalla afa adetits wolqqa inggida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«Yikke hyaydzantsize yi7i, ‹Laatstso, ta curqqara xaaxii naagide ne miishita hyannashe. ");
INSERT INTO oydl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Akkos gayko, neenii nebaz maaqqoosse baz ekkizannon ne budikaayzebaz maxize iita wozina mintsi asi maaqqide gisho nees zhashtida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Eza laatstse mahi, ‹Naate iita arizayo ne doonttii gaar ta nena firddoda. Ta gaddikaayzebaz ekkizannon budikaayzebaz maxize asi maaqqizanno ne erizako, ");
INSERT INTO oydl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ta yi7i ta minaaniza tirfera ekkode fana zal7ize asis akkos inggika?› ");
INSERT INTO oydl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Eza laatstse yinna besite eqqiduntsago, ‹Eera yeze minaaniza ekkii taphpho tirfizidays inggote› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Un, ‹Laatstso, ees tiinon taphphi minaane yene› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«Laatstsii, ta yinttis ohine; ‹Yeze ubbuntsis melle gujunttoda, yezin bazeppa melle atto ees yezannan ekkinttoda. ");
INSERT INTO oydl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Maaqqo yezin, ta unttalla afa ka7itaame fana koyduntsi yentsi ta morkkuntsana hyankka ta tiintte ki7i wodhote› gayda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuusa yinno ohidannippa suuba unttappa tiino aadhii yedhdhii Yerusalaame qitida. ");
INSERT INTO oydl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Shamahe Derizella afa yeze Beetefaagen Bitaaniya ukkide wode fa tamaaruntsappa lam77untsana yaga7i kiittida: ");
INSERT INTO oydl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Yin tiino yeze kara gancce qitote, yin yeyga yellize wode ooden toggikaayze acinttii yeze hyare na7a demmada. Eza billii hyayga ekkii yo7ote. ");
INSERT INTO oydl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ooden, ‹Akkos bille?› ga7i oociko, ‹Laatstsii eza koyane› yaga7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiitinttiduntsi hyanggi E gaydanni fana yi7in bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Un hyare na7aya billodera laatstsuntsi bi7i, «Hyare na7aya akkos bille?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Un mahi, «Laatstsii eza koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yeygappa hyare na7aya Yesuusago ki7ida. Fa ma7ito hyare na7ay bantte gaddii Yesuusa hyare na7ayilla betitsida. ");
INSERT INTO oydl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asuntsin E yedhdhize ogitilla fa ma7ito yiixxida. ");
INSERT INTO oydl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Shamahe dere sulle wodhdhize ogizego ukkize wode faydora loytsii gaama asuntsana un bi7i kille bazite ufaytti fa qaaltto dhoqi yiizii, ");
INSERT INTO oydl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«Laatstse suntsite ye7ize kaatize anjjinttidaya salo gidda saro Ubbappa dhoqqa salo bonchcho Xoozis maaqqe.» Yaga7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Asunts giddappa fettii fettii Farisaawuntsi Yesuusago, «Asttamaarizayo, ne tamaaruntsana hyayzote ga7i kacco» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","E unttago, «Un si77i gayko shuchchuntsi uukkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuusa Yerusalaame ukkite katamito bi7i iis yeekkida. ");
INSERT INTO oydl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«Nees saro maaqqadanno hyayno ne erizebaz maaqqizako yezin, hyatte ne aaftippa genggida. ");
INSERT INTO oydl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne morkkuntsi ne kantto gasii dumma dumma ogera nena teqqii un7itsize wode ye7oda. ");
INSERT INTO oydl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nenan ne gasiti gidda yeze ne na7untsana dhabssoda. Fettii fettii shuchchi dentsii wul7oda, akkos gayko Xoozii nena ashshodes ye7ize wodito erikaaya» yaga7i iisi yeekkida. ");
INSERT INTO oydl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yinnippa suuba, Yesuusa Xoozze keetstsa gelii zal77izuntsana yeygappa bay7ida. ");
INSERT INTO oydl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mahi, «‹Ta keetsita Xooz woossize keetstsi maaqqada› ga7i xaafinttida, yezin yin ta keetsito faanuntsi wom7o mahida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Awara awara Xoozze Keetstsite tamaarssane. Kahinunts hyalaquntsi, higge asttamaaruntsin gade cimuntsi eza wodhodes oge koyane. ");
INSERT INTO oydl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Maaqqo yezin, asuntsi ubbanna E timirttito fa wozintto olii si7ize gisho unttis oochchode baz dhabida. ");
INSERT INTO oydl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Fettii qamma Yesuusa Xoozze Keetstsa asuntsana tamaarssitteran Wonggele markkidhite, kahinunts hyalaquntsi, higge asttamaaruntsin gade cimuntsi fettilla eego yi7i, ");
INSERT INTO oydl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«Ne hyantsesana akko adetitsi wolqqara oochchizako nuus oho. Hyanna adetitsi wolqqito nees inggide oode?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","E unttago, «Taanin yinttana fettibaz oocoda, ane taas mahote. ");
INSERT INTO oydl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Xammaqize Wahannisa xinqqata Xoozappane asappa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Un wol gidda yaga7i zorinttida: «Xoozappa gayko yeezin, akkos ammananxido?» yaga7oda. ");
INSERT INTO oydl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","«Asappa gayko, asuntsi ubbanna Wahannisa nabe maaqqizanno ammanze gisho nuna shuchchara dhogoda.» ");
INSERT INTO oydl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yinnii gisho, «Abap yezako nu erosi» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesuusa mahi, «Yikke, taanin akko adetitsi wolqqara hyantsesana oochchizako yinttis ohoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yinnippa suuba, Yesuusa yaga7i hyanna aazizto asuntsis ohida: «Fettii asi woyne tukkida. Oochchizuntsis kotstse inggi gaama wode gam77i yo7odes melle sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woyne aafto maxize wode yellin woyne aaftippa ees dakkode fana oochchizuntsago fa ariza kiittida. Yezin oochchizuntsi ye ariza aykkii hyadhdhii hyarii kushe dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mahin melle ariza kiittida. Mahi oochchizuntsi eza hyadhdhii, kawushshizii hyarii kushe dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hyatten mahi hyaydzintsa ariza kiittida. Wootizuntsi ezan hyadhdhii hyarggizii woyne giddappa gaxa kessii olida. ");
INSERT INTO oydl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Woyne laatstse, ‹Yeezin ta akko oochcho? Ane mahi ta kadhize ta na7aya dakkoda; oode erode un eza bonchchikaayzara attaama› yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Yezin oochchizuntsi atstse na7aya bi7ide wode ‹Hyayni eza laattodaya, hyayga yo7ote eza wodhoda, yeyziko laatita nuus maaqqada› yaga7i zorinttida. ");
INSERT INTO oydl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Woyne giddappa gaxa kessii wodhida. «Yeezin, woyne laatstse yentsi asuntsana wayssade? ");
INSERT INTO oydl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yi7i yentsi oochchizuntsana dhabssoda, woyne bestto melle asuntsis inggoda. Asuntsi yinno si7eze wode ‹Shinchchalle yinnii gaarzebaz ki7ippe› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuusa unttana dakkii bi7i, Yeezin «Gimbbe keexxize asuntsi boride shuchchize, keetstsis mintsin xalatitsi inggize ubbannippa aadhize shuchchi maaqqida» «ga7intti xaafinttidanni bilitsita akko? ");
INSERT INTO oydl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ye shuchchizella afa gol7ize ubbanna meqqoda, shuchchize eella afa wodhdhize ubbanna gaacinttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Higge asttamaaruntsin kahinunts hyalaquntsi yinna aazizita ohinttidanna unttalla afa maaqqidanno erii ye wode eza aykkodes koyda, yezin asuntsis zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yinnii gisho, Yesuusa worzhito ahize Roome kaatizes aatsii immades koyi E doonttippa bala qaala naagane. Yinno folisades xillo gaara yi7i cimmize asuntsana eego kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kiitinttii hyanggide asuntsi, «Asttamaarizayo, neenii ohizannan tamaarssizanna likke maaqqizanno, mahi Xoozze ogito turira tamaarssizannon oonan shagoosanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yi7o yezin, Roome kaatis giira giirodes beezanene beezosa?» yaga7i eza oocida. ");
INSERT INTO oydl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yezin E un wozina iitatitsito eride gisho ");
INSERT INTO oydl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ane tana fettii santime beezote, Eella yeze misiltan suntsita oodebazo?» yagayda. Un mahi, «Roome Kaati» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","E mahi, «Yeezako, Qeesarestto Qeesares, Xoozzesito Xoozis inggote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yinnii gisho, E mahide mahite asuntsi tiintte bala denggodes dandda7ikaaya. E mahite gaama qoppii si77i gayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hyayqoppa denddo baaya yagaaze Saduqaawuntsappa fete fete Yesuusago yi7i, ");
INSERT INTO oydl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Asttamaarizayo, fettii asi machcho ekkii na7a yelikaayzara hyayqqiko, E ishe yinna machchito ekkii na7a yelii fa ishes kochchi ashshode fana Muse xaafida. ");
INSERT INTO oydl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yikke laappun ishuntsi yene. Anggisse machcho ekkii na7a yelikaayzara hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lam7antsize izo ekkii na7a yelikaayzara hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hyaydzantsize yinnii fana yi7ida. Laappununtsi ubbanna yinnii gaara yi7i izo ekkida, yezin na7a yelikaayzara hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ubbappa suuba machchita hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Yikke, laappun dhiiratsi izo ekkide gisho hyayqoppa denddize wode iza oode machcho maaqqade?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesuusa mahi, «Asi hyanna wodite ekkane gelane. ");
INSERT INTO oydl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yezin hyayqoppa denddii ye7ode alamite yessades beezuntsii ekkosi geloos. ");
INSERT INTO oydl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Un kiitanchcho fana maaqqize gisho tiinoppa hyayqqoos. Hyayqoppa denddide gisho un Xoozze na7a. ");
INSERT INTO oydl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Muse Laatstsii, ‹Abrahama Laatstsii, Yisaaqa Laatstsii, Yayqooba Laatstsii› ga7i cil7o gidda eexize tama taarikito xaafidanne hyayqqide asuntsi denddizanno beezane. ");
INSERT INTO oydl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ubbuntsi ees faxa yezuntsana maaqqade gisho E faxa yezunts Laatstsap attin hyayqqiduntsi Laatstsii baaya» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Higge asttamaaruntsappa fete fete, «Asttamaarizayo, lo77o baz ohida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yinnippa suuba, melle ooce oocodes zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yinnippa kaallii Yesuusa unttago, «Asuntsi Kiristtoosa wayzi Dawute na7a ga7e? ");
INSERT INTO oydl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Akkos gayko, Dawute fa ommite Mazmure maxaafite, « ‹Xoozii ta Laatstsego «Ta ne morkkuntsana ne tohita yedhdhize bessi mahode wontsis taappa mizaqi zalara betto» gayda yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Yikke, Dawute Kiristtoosa, ‹Laatstso ga7i xeegittera ees na7a wayzi maaqqe?› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Asi ubba si7adera fa tamaaruntsago, ");
INSERT INTO oydl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Pharggo ma7o ma77i wuta kadhizuntsappa, gabe bonchcho sarotse, Ayhude woosa Keetstsite bonchcho oyda, mokunttize keetstsan bonchcho bessi koyze higge asttamaaruntsappa naaginttote. ");
INSERT INTO oydl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Un budan keetstsi kallo ashshizuntsana, xillo asi gaar yi7i woosa pharggizane. Un iita firdda ekkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dure asi Xoozze Keetstsa muxaate saaxintte olodera Yesuusa dhoqi ga7i asuntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mahi fettii daha budantta lam77i sikkina olodera bi7i, ");
INSERT INTO oydl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«Ta yinttis turo ohine; hyanna daha budantta ubbannippa aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Akkos gayko, hyantsi asuntsi ubbanna faas yeze bazappa inggida, yezin iza fa facitippa, faas yeze yestto mulo inggida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesuusa tamaaruntsappa fete fete Xoozze Keetsita gaama lo77ize shuchcharan asi Xoozis inggide imora lo77idanno ohinttane. ");
INSERT INTO oydl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yezin Yesuusa, «Hyanna yin be7ize bazita ubbanna lanttikaayzara, shuchchi shuchchalla afa gimbbinttide fana hyannira attoose wode ye7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Unttin, «Asttamaarizayo, hyanna ubbanna hyanodanna ayde? Mahi hyanna hyanodannis mallita akko?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesuusa yaga7i unttis mahe inggida: «Balinttaame gaar naaginttote. Gaamuntsi fana, ‹Ta Kiristtoosa, wodita ukkida› yaga7ite ta suntsite ye7oda, yezin yin unttana kaallippete. ");
INSERT INTO oydl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yin olabazin as iitatitsi si7ize wode tannippete. Yinna tiinidhii yi7odanna attaamebaz maaqqade gisho wode wurssutsita ellisii ye7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kaallin, «Worzha worzhalla afa, ka7itumo ka7itumolla afa denddoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Damma sa7a eni7e hyanoda, gado hyargge naye bay7en dumma dumma bessa gaammada, zhashize bazin damma malla saloppa benttoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Yezin hyanna ubbanna hyanodannippa tiino ta suntsiti gisho ga7i asi yinttana baytsoda aykkoda. Ayhude woosa Keetstsa firddi achchi keetstsa yinttana oloda. Kaat tiinon worzha ahizuntsii tiino yinttana kanggoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yinnan ta baz yin unttis markkidhades lo77o oge maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yinnii gisho, yin oocinttize wode waaga7i mahe immade ga7i yin wozintte un7inttaame fana qoppote. ");
INSERT INTO oydl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Akkos gayko, yin morkkuntsi yinttara eqinttodesin lallodes dandda7oosse doonan cinccatitsi ta yinttis inggoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Melle atto yezin, yinttana yeliduntsi, yin ishuntsi, yin iginuntsi lagguntsi yinttana aatsii inggoda. Yin giddappa feta feta wodhoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta suntsiti gisho asi ubba tiintte yin ixinttiduntsana maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yezin melle atto yezin, yin omma isintsitippa feten dhaboos. ");
INSERT INTO oydl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mintsii dandda7ara yin, yin shemppito ashshoda.» ");
INSERT INTO oydl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Yerusalaame katamita allaga wottaddarera gasintti bettezin yin bi7iko iis dhabe ukkidanno erote. ");
INSERT INTO oydl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ye wode Yihuda yeze ubbanna derego woxxii dhabo, katamite yezuntsi yeygappa kezo, gaxare yezuntsi katama gelippe. ");
INSERT INTO oydl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Akkos gayko, hyanna xaafinttidanna folinttode gaar yinna Xoozze kushe mahize wode. ");
INSERT INTO oydl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sa7alla afa damma madha ye7oda, hyannen asalla afa Xoozze baadditsi ye7oda. Yinnii gisho, wodatsi maachuntsisin dhantsizuntsis bade. ");
INSERT INTO oydl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Un mashshara hyayqqoda, asi ubbanna allaga sa7a yessada. Ayhude maaqqoosse asunts wodita folinttode wontsis Yerusalaame unttara yedhinttidanno maaqqada. ");
INSERT INTO oydl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Awan, aginan, xoolinttolla afa malla benttoda. Abbappan zuluntte en7e denddidannippa sa7a yeze asi un7inttoda yirggoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Salo wolqqita buqunttode gisho asi zhashmoran sa7alla afa akko yi7adyessa ga7i naagora tannoda. ");
INSERT INTO oydl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ye wode As Na7ay wolqqaran damma bonchchoran dhonnera ye7odera un be7ada. ");
INSERT INTO oydl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yinttana ashshize ukkide gisho hyanna hyanizanna folinttodes aykkize wode giiginttii eqqote, yin ommito dhoqi yiizii bo7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kaallin, hyannigaara ga7i aazize ohida: «Belese minxan melle minxa ubba bo7ote. ");
INSERT INTO oydl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Un aacize wode torchche ukkidanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yinnii gaara hyanna hyanizanna folinttodera yin bi7iko Xoozze ka7itumo ukkidanno erote. ");
INSERT INTO oydl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«Ta yinttis turo ohine; hyanna ubbanna folinttode wontsis hyanna yeletitsita aadhoos. ");
INSERT INTO oydl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Salon sa7an aadhoda, yezin ta qaaltta aadhoos. ");
INSERT INTO oydl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Yikke, bore baayze yessara, ushi gaantsera yesi bazis un7inttera yin wozintta aykkinttaame gaaran yinna qammita tiirikaayzin xike fana yinttana aykaame fana naaginttote. ");
INSERT INTO oydl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yinna qammita sa7a kumutsite yeze ubbuntsalla afa yelloda. ");
INSERT INTO oydl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yinnii gisho, ye7ize baz ubbappa attodesin As Na7a tiintte eqqodes dandda7inttode fana ubba wode miinggi woossote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Awara awara Yesuusa Xoozze Keetstsite tamaarssite, qamma qamma Shamahe Derizella afa kezii aqane. ");
INSERT INTO oydl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asi ubba eza si7odes wontta gooda eego Xoozze keetstsa ye7ine. ");
INSERT INTO oydl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ye wode Faasika gaaze boora Ba7ale ukkida. ");
INSERT INTO oydl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kahinunts hyalaquntsin higge asttamaaruntsi asuntsis zhashtide gisho wayzi Yesuusa fa giddappa dhabssodyezako oge koyane. ");
INSERT INTO oydl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xalahe taphpho lam77untsappa feta maaqqide Asqorootu Yihuda ga7inttize gidda gelida. ");
INSERT INTO oydl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yihuda kahinunts hyalaquntsisin Xoozze Keetstsa naagizuntsi hyalaquntsago hyanggi Yesuusa wayzi aatsii immadyezako unttara zorinttida. ");
INSERT INTO oydl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Unttin yinne ufaytti bira immades eera zorinttida. ");
INSERT INTO oydl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ezin zorinttidanne giigida. Aatsii unttis immades asi baayze wottize wode naagitera yene. ");
INSERT INTO oydl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yinnippa suuba, Faasika duro shukinttize boora Ba7ale yellida. ");
INSERT INTO oydl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesuusa, «Faasika kawo ma7ade gaar hyanggi nuus giigizote» yaga7i Phexiroosan Wahannisan kiittida. ");
INSERT INTO oydl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Un, «Nu aba giigisade gaar ne koye» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E unttago, «Yikke yin katama gelodera hyaatsi otara tookkide atstse yinttara yelinttoda. E hyanggi gelize keetstsite eza kaallii gelote. ");
INSERT INTO oydl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kartti adego asttamaarize, ‹Ta ta tamaaruntsara wolla Faasika kawo ma7ades zaqqo keetsita aba yene? yagayda› ga7ote. ");
INSERT INTO oydl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","E fooqella afa yiixxintti giigii yeze dalgga kifile yinttana beessada, yeyga giigizote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Un hyanggi Yesuusa ga7idanni gaara hyanin denggida. Faasika ba7ale kawo yeyga giigizida. ");
INSERT INTO oydl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saatan yellide wode Yesuusa hawaaruntsara wolla kawolla bettida. ");
INSERT INTO oydl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","E unttago, «Ta madha ekkodannippa tiinii hyanna faasika kawuto yinttara ma7ades gaama amudhdhida. ");
INSERT INTO oydl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yikke, si7ote! Xoozze ka7itumtte hyannis bilitsita folinttode wontsis hyanna kawuto mahi mo7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ushito ekkii galatii maaqqii, «Hya7ate hyanno yin gidda gishinttote. ");
INSERT INTO oydl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Si7ote! Xoozze ka7itumo ye7ode wontsis hyaynoppa aykkii hyanna woyne ushitippa mahi uzhoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Booriza ekkii, galatii maaqqii, «Hyanna yinttis ingginttidanna ta ashtto. Hyanno oochitera tana tiirote» yaga7i baxxi unttis inggida. ");
INSERT INTO oydl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yinnii fana, kawutippa suuba ushshito ekkii, «Hyanna ushshita yinttis goggide ta suutsite folinttize kille caaqo. ");
INSERT INTO oydl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Maaqqikon, tana aatsii inggode atstse kushita taara fettilla gabate. ");
INSERT INTO oydl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","As Na7ay ees Xoozii gayde fana hyayqqodes yene, yezin eza aatsii inggize atstsa bade» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Un fa gidda, «Hyanno oonii oochchode» ga7i wol oocida. ");
INSERT INTO oydl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mahi un gidda damma maaqqade oode gaaze lalle medhinttida. ");
INSERT INTO oydl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesuusa unttago, «Alame kaatuntsi fa asuntsana wolqqara ahane; fa derttilla afa laatsidhizuntsanan fana, ‹Lo77o oochchizuntsana› yaga7i xeegane. ");
INSERT INTO oydl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yezin yin gidda yinnii fana maaqqippe. Yin gidda angisize geezze fana yi7o;kaalitsize kaallizefana yi7o. ");
INSERT INTO oydl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yeezin, mokkizeppan Mokinttizeppa aaye aadhe? Mokinttiza baane? Yezin taanii yin gidda mokkize fana. ");
INSERT INTO oydl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Yinttin ta madhite taappa shaakkinttikaayzar taara miinggi eqqiduntsana. ");
INSERT INTO oydl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Yin ta leematippa ma7ade fana, ushshade fanan araatalla afa bettii taphpho lam77i Isra7eele sheeshuntsalla afa firddode gaar ta aday tana shuumide fana taanin yinttana ta ka7itumtte shuumoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kaallii Yesuusa, «Simoona, Simoona, Xalahe yinttana zarga fana hyarqqodes woossida. ");
INSERT INTO oydl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yezin ta ne ammantta dhabaame fana nees cimidhdhane. Neenin maaqqide wode ne ishuntsana miintso» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simoona, «Laatstso, ta neera acinttodesin hyayqqodes giiginttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuusa Phexiroosago, «Ta nees ohine; hyayno lukule uukkodannippa tiino ne tana hyaydzdzii tohe kaddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kaallii, Yesuusa unttago, «Taanii yinttana korojjo, karxitten caamma baayzin kiitteze wode yinttis faccidebaz yene?» yaga7i oocida. Un mahi, «Akkon faccikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","E unttago, «Hyatte korojjon karxite yeze aykko; mashsha baayze fa afultto bayzi mashsha wonggo. ");
INSERT INTO oydl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hyanno si7ote! ‹Genuntsara faydinttida› ga7intti xaafinttidanna ta gidda folinttodes beezane. Yee, ta gisho xaafinttidanna folinttizanna turidhida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","E tamaaruntsi, «Laatstso hyanne lam77i mashsha yene» yagayda. E, «Maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuusa tiinoppa kezizanni gaara denddii Shamahe Derizella kezida. E tamaaruntsi eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yinna besite yellide wode «Madha gelaame fana woossote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Unttappa shuchchi dhogin yellode bessi gaar hyaakki bunqqunttii woossida. ");
INSERT INTO oydl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Ta adayo, ne qofa maaqqiko hyanna madha xuu7uto taappa aatstso. Yezin ta qofa maaqqippe ne qofa hyano» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kiitanchcho saloppa benttii mintsitsida. ");
INSERT INTO oydl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gaama un7intti mintsii woossane. E cawutan suutsi xokkize gaar sa7ite xokkane. ");
INSERT INTO oydl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesuusa woosa polii fa tamaaruntsago yi7ida. Un, azzanoppa denddii labbii genttezin denggi, ");
INSERT INTO oydl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«Akkos gentte? Faatana gelaame fana denddii woossote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","E hyaga ohella afa yezin gaama asuntsi yi7ida. Taphpho lam77untsappa fete Yihuda ga7inttize unttana kaalitsane. E Yesuusa yeerodes kale shiiqida. ");
INSERT INTO oydl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yezin Yesuusa, «Yihuda, As Na7aya yeerii aatsii inggoda?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesuusa tamaaruntsi yinna hyanzanno bi7i, «Laatstso mashshara gachcho?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Un giddappa fete kahinunts hyalaqiza guuddii mizaqi hyayza gachchii olida. ");
INSERT INTO oydl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yezin Yesuusa, «Ashsho! Kayppete» yagayda. Atstse hyayza bochchii fatstsida. ");
INSERT INTO oydl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yinnippa suuba, Yesuusa fana aykkodes yi7ide kahinunts hyalaquntsago, Xoozze Keetstsa naagizunts shuumuntsagon cimuntsago, «Faanno aykkize asi fana mashshan gufe aykkii yi7idate? ");
INSERT INTO oydl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ubba wode Xoozze Keetstsite ta yinttara yeze wode taalla afa kushe gaddikaaya. Yezin hyanna dhuma ka7itumo ahide woden yin woden» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yinnippa suuba, Yesuusa aykkii kahinunts hyalaqize woofa kanggida. Phexiroosa hyaakora Yesuusa kaallane. ");
INSERT INTO oydl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asuntsi kahinunts hyalaqize woofa tama eetsii wolla bettezin Phexiroosa unttara wolla bettida. ");
INSERT INTO oydl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Fettii arita Phexiroosa tama kale bettidanno dakkii bi7i, «Hyay atstse eera yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yezin Phexiroosa, «Hyanna maachite ta ye atstsa erosi» yaga7i kaddida. ");
INSERT INTO oydl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Eerats wodeppa suuba fettii melle asi eza bi7i, «Neenin unttappa feta» yagayda. Yezin Phexiroosa, «Hyay atstsayo tana baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Fettii saate gaar gam77idannippa suuba fettii melle atstse loytsii, «Hyay atstsay Galilappa maaqqade gisho so7e baayzin eera yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yezin Phexiroosa, «Hyay atstsayo, ne gaazaya ta eroos» yagayda. E yinna ohito hyaasikaayizin lukule oollida. ");
INSERT INTO oydl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Laatstsii suuba maaqqii Phexiroosa bi7ida. Phexiroosa, «Hyayno lukule oollodannippa tiino ne tana hyaydzdzii tohe kaddoda» yaga7i, Laatstsii ohide qaaltto tiirida. ");
INSERT INTO oydl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phexiroosa bale kezii gaama goqii yeekkida. ");
INSERT INTO oydl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuusa naagize asuntsi eza leqqen hyadhdhe aykkida. ");
INSERT INTO oydl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","E aafito goozii «Ane tinbbite oho; nena hyadhdhide oode?» yaga7i oocane. ");
INSERT INTO oydl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Melle gaama leqqii cazhane. ");
INSERT INTO oydl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa7a wonttize wode Ayhude sa7a cimuntsi, kahinunts hyalaquntsin higge asttamaaruntsagon shangguntsago shiiqii, Yesuusa fa tiino shiishida. ");
INSERT INTO oydl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Un, «Ne Kiristtoosa? Ane nuus oho?» yaga7i oocida. Yesuusa, «Ta ohizako ammanoos. ");
INSERT INTO oydl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta oocizako mahoos. ");
INSERT INTO oydl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yezin As Na7ay hyannippa gode bagga wolqqaama Xoozze mizaqi zalar bettoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ye wode ubbanna, «Yeezin, ne Xooz na7a?» yagayda. E, «Ta Xoozze na7a yin gaydanni fana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Un, «Yikke, melle markka akko koshshe? E fa il7antsite ohodera nu si7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yinna besite shiiqide shangguntsi ubbanna denddii Yesuusa Philaaxoosago kanggida. ");
INSERT INTO oydl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«Hyay atstse nu asuntsana balitsodera, Roome kaatis giira giiraame fana kayoderan mahi, ‹Taanii Kiristtoosa yin kaati› yagaazin denggida» yaga7i mootida. ");
INSERT INTO oydl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philaaxoosa Yesuusa, «Neenii Ayhuduntsi kaatine?» yaga7i oocida. Yesuusa, «Ye, ne ga7idanni gaar» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Philaaxoosa kahinunts hyalaquntsagon asuntsago, «Hyay atstsella afa ta fettii bala baz denggikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yezin un, «Hyay atstse Galilappa aykkii hyanno yellodes Yihuda kumutsi iitabazis dentsitsane» yaga7i mintsii ohida. ");
INSERT INTO oydl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Philaaxoosa yinno si7eze wode Yesuusa Galila asi yezako erodes koyi eza oocida. ");
INSERT INTO oydl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesuusa Heroodisa sa7appa yi7ide asi maaqqizanno Philaaxoosa eride wode Heroodisa ye wode Yerusalaame yeze gisho eego dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroodisa Yesuusa be7ades gaama wodeppa koyitera yeze gisho eza be7eze wode gaama ufayttida. Akkos gayko, E baz si7ide gisho gaama qofize baz oochchin be7ades amudhdhiter yene. ");
INSERT INTO oydl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroodisa Yesuusa gaama oochi oocida, yezin E akkon mahikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kahinuntsi hyalaquntsin higge asttamaaruntsi ize eqqii mintsii eza mootane. ");
INSERT INTO oydl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroodisaran E wottaddaruntsara Yesuusa toochii leqqida. Bonchcho afula ma7isii Philaaxoosago mahi dakkida. ");
INSERT INTO oydl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Heroodisaran Philaaxoosara tiino morkke yezar ye wode wolla giigida. ");
INSERT INTO oydl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philaaxoosa kahinunts hyalaquntsana, as ahizuntsanan fettilla xeegii, ");
INSERT INTO oydl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹Hyay atstse asi wobbo bazis dentsitsane› ga7i taago ki7ida. Taanin yin tiintte qurichin yin shiishide mootis akko bala baz denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroodisa, yinnii gaar akko bala baz eella afa denggikaayze gisho nuugo dakkida. Turon hyay atstse hyayqos yeltsize akko bala baz oochchikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yinnii gisho, eza garafii billii dakkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yinno E ga7idanna Faasika Ba7ale wode fettii asi unttis billodanna ees attaamebaz maaqqide gishos. ");
INSERT INTO oydl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Worzhuntsi ubba fettilla, «Hyay atstsa wodho, nuus Barbbaane billo» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbbaane katama gidda asuntsana iitabazis dentsitsii asi wodhii acinttide asi. ");
INSERT INTO oydl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philaaxoosa Yesuusa billodes koyi asuntsis mahi ohida. ");
INSERT INTO oydl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Maaqqikon, asuntsi, «Suxxo! Suxxo!» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philaaxoosa hyaydzintsa, «Hyay atstse qohide baz akko? Wodhes yeltsize bala ta denggikaaya. Yinnii gisho, garafii dakkii ashshoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Un fa qaaltto dhoqi yiizii, «Suxunttodes beezane» ga7i mintsii uukkida. Un uukki gamida. ");
INSERT INTO oydl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Un oociti gisho ga7i Philaaxoosa eella firddida. ");
INSERT INTO oydl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Asi iitabazis dentsitsizayan as wodhii acinttidaya billode fana woossida, ye atstsa unttis billida. Yezin Yesuusa un koydebaz oochchode gaar unttis aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesuusa aykkii kanggodera Simoona gaaze Qereena sa7a atstse gaxareppa ye7odera, denggi masqala toossii Yesuusa kaallii hyammade fana un7itsida. ");
INSERT INTO oydl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Gaama asuntsin fa dadabito qoxxitera yeekkize maachuntsi E suubara kaallane. ");
INSERT INTO oydl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yezin Yesuusa unttago suuba maaqqii, «Yin, Yerusalaame maachuntso, yin ommitisin yin na7untsis yeekkotep attin taas yeekkippete. ");
INSERT INTO oydl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹Yikke dhoontsuntsin, yelikaayze sazttan dhantsikaayze ammita anjjinttida› yin yagawude qamma ye7oda. ");
INSERT INTO oydl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ye wode dertto, ‹Nuulla afa gol7o›, zooziton, ‹Nuna aachcho› gawuda. ");
INSERT INTO oydl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yikke, qaye minxalla hyanni gaar yiiziko mela minxa wayssad yessa?» gayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ezara wodhodes melle lam77i iita baz oochchiduntsana kanggida. ");
INSERT INTO oydl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Qeeraniyo ga7inttize besito yeltsi suxxida. Iita baz oochchiduntsappa feta mizaqi zalara hyankkaya workkita zalara suxxida. ");
INSERT INTO oydl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesuusa, «Ta adayo, un akko oochchizako eroosse gisho ne unttis atto ga7o» yagayda. Un E afulttilla afa ixa olii shaakkintti ekkida. ");
INSERT INTO oydl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Asuntsi eqqii be7ine, yezin gade ahizuntsii, «Melluntsana ashshida; Xoozii dooride Kiristtoosa E maaqqizako ane fana ashsho» yaga7i leqqida. ");
INSERT INTO oydl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wottaddaruntsi E kale shiiqii, caala woyne ushi inggida. ");
INSERT INTO oydl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yeyzi, «Neenii Ayhudunts kaati maaqqiko ne ommito ashsho» yaga7i leqqida. ");
INSERT INTO oydl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ees omma zalara, «Hyay Ayhudunts kaati» yagaaze xuufe gaddida. ");
INSERT INTO oydl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Suxunttide iita baz oochchiduntsappa fete cashshi sa7ara gochchitera, «Ane neenii Kiristtoosa maaqqiko, nenan nunan ashsho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yezin hyankkay, «Ne hyannii gaar firdda yezite melle atto yezin, Xoozis zhashtoosa? ");
INSERT INTO oydl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuunii nu balttis beezize firdda ekkane, yezin hyay atstse fettii iitabazin oochchikaaya» yaga7i kaccida. ");
INSERT INTO oydl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mahin, «Yesuusa, ne ne ka7itumora ye7ize wode tana qoppo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesuusa, «Ta nees turo ohine; hyayno ne taara gannate maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ye wode izippun saateppa hyanggi uddufun saate yellodes awa foo7ito kayde gisho sa7a ubbanne dhuma maaqqida. Xoozze Keetstsa magaraajjita feedhinttii lam77i shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesuusa, qaaltto dhoqi yiizii, «Ta adayo, ta ta shemppito ne kushite inggane» yaga7i hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mato hyalaqize, hyanidanno bi7i, «Hyay atstse turo xillo» yaga7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yinna hyanide bazito bo7odes yinna besite shiiqide asi ubbanna hyanidanno be7eze wode fa dadabito qoxxitera fa kara maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Maaqqikon, Yesuusa kalera erize asuntsi ubbanna, yinnii gaara Galilappa kaallii yi7ide maachuntsi yinno bi7ite hyaakora eqqida. ");
INSERT INTO oydl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ayhude shangguntsappa fetay, Yoosefa ga7inttize atstse yene. E Armmatiyasa ga7inttize Yihuda katamappa yi7ida. E lo77on Xillo asi maaqqide gisho Xoozze ka7itumo ye7ito naagane. Shangguntsappa feta maaqqii un zorintten oochite baaya. ");
INSERT INTO oydl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ye atstse Philaaxoosago hyanggi, Yesuusa ahito moogodes taas inggo ga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yesuusa ahito ketstsii afulara xaaxida. Laallappa woocinttide wom7o melle asi mooginttikaayze boozite gaddida. ");
INSERT INTO oydl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sambbata gelodes yiize gisho yinna wodita giigintte qamma. ");
INSERT INTO oydl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilappa denddii Yesuusa kaallii yi7ide maachuntsi Yoosefara hyanggi E ahito wayzi moogizako booztto akaakii bi7ida. ");
INSERT INTO oydl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Izippa maaqqii shitton qibaate giigizida. Higge kiittizanni gaar Sambbata awarito shemppii peezhida. ");
INSERT INTO oydl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saaminttappa tiino qamma, wogga wode wontta gooda, maachuntsi fa giigizide shitto ekkii booza hyanggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Un ize yellize wode booza doontte yeze shuchchita gol7i hyal7idanno denggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Un booza gaatsi gelida, yezin Laatstse Yesuusa ahito denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Un ize eqqii akko hyanido ga7i qoppodera akaakikaayzin gaama foo7ize afula ma77ide lam77i asuntsi un kale eqqida. ");
INSERT INTO oydl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maachuntsi zhashti fa omito sa7a ziqqii yiizii yessadera, asuntsi unttago, «Faxa yezaya hyayquntsi gidda akkos koyete? ");
INSERT INTO oydl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","E hyanne baaya; hyayqoppa denddida, ‹As Na7ay nagaranchchuntsi kushite aadhii ingginttoda; unttin eza suxxoda.E hyaydzintsa qammite hyayqoppa denddoda› yaga7i, E yinttara Galila yezite yinttis ohide qaaltto qoppote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Maachuntsi ye wode E qaaltto tiirida. ");
INSERT INTO oydl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Maachuntsi boozappa maaqqii hyanide bazito ubba taphpho fettuntsisin melluntsisin ohida. ");
INSERT INTO oydl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yentsi hawaaruntsis ohide Magdela Mayramo, Yohaanna, Yayqooba intta Mayramon unttara yeze melle maachuntsana. ");
INSERT INTO oydl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yezin unttis maachuntsi ohidanna abukko gaara yi7in ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yezin Phexiroosa denddii woxxii booza qitida. Yinna bestto yellii zuggii gidda be7ize wode moogide afula xalaala bi7ida. Hyanidanne gaama qoppii fa kara maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ye wode kaallize tamaaruntsappa lam77untsi Yerusalaameppa taphpho fettii kilo mitire hyaakkize Emmahuse kara gancce hyanggane. ");
INSERT INTO oydl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Un wolla hyanide bazito ubba ohinttane. ");
INSERT INTO oydl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Un yinna hyanidanni baz tiiriteran ohinttitera yedhdhize wode Yesuusa fa ommitis shiiqii unttara hyanggane. ");
INSERT INTO oydl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yezin, un eza eraame fana un aafta aykkinttida. ");
INSERT INTO oydl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","E, «Yin wolla ogella yezite ohinttizanna akko?» yagayda. Un azzanii si77i ga7i eqqida. ");
INSERT INTO oydl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unttappa fete Qeliyoopha ga7inttize, «Hyanna qammiti gidda Yerusalaame hyanidanno eroosse, ne sa7itis zaqqone?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E mahi, «Ize hyanidanna akko?» ga7i oocida. Un, «Xoozze tiinon asi tiinon oocharan ohera mintsii nabe maaqqide Naazirete Yesuusa baz. ");
INSERT INTO oydl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Eza kahinunts hyalaquntsin nuna kaalitsizuntsi hyayqo firddas aatsii inggi, suxxida. ");
INSERT INTO oydl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuunii Isra7eele asuntsana ashshoda ga7i ufaytti naagezin hyanna hyanin hyayno hyaydzintsa qamma. ");
INSERT INTO oydl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mahi nu giddappa fettii fettii maachuntsi nuna gaama qofizida. Un hyayno wontta gooda booza hyanggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","E ahita dhabide wode maaqqii yi7i, ‹E faxa yene› yagaaze kiitanchchuntsi qonccin bi7ida yaga7i ohida. ");
INSERT INTO oydl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nu giddappan fete fete booza hyanggi maachuntsi ohidanni fana hyanin bi7ida, yezin eza bi7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","E unttago, «Yin, tiiroosse asuntso, yin wozintta nabuntsi ohidanno ubba ammanodes gam7izuntso, ");
INSERT INTO oydl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiristtoosa yinna madhito ekkodesin fa bonchchora gelodes beezosa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Museppan nabunts ubbannippa denddii Geeshi Maxaafite E baz xaafinttidanno ubba unttis qonccizida. ");
INSERT INTO oydl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Un hyanggize kara gancce ukkide wode Yesuusa aadhii hyaako bessa qitize gaara yi7in, ");
INSERT INTO oydl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Un, «Sa7ita qammide gisho nuura aqo» yaga7i mintsii woossida. Yinnii gisho, unttara aqodes gelida. ");
INSERT INTO oydl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Unttara wolla leematella bettii, soollo dentsii, feedhii anjjii unttis inggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ye wode un erode gaar un aafta bugunttida. Unttin erida. Yezin E unttappa genggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Un, «Nu ogella afa yezin E nuus Geeshi Maxaafe billiteran nuna ohizitera nu wozintta eexika?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ye wode denddii suuba Yerusalaame yi7ida. Taphpho fettuntsin melluntsi fettilla shiiqii yessadera denggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Un, «Laatstsii turo denddida; Simoonas benttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yentsi lam77i tamaaruntsi Emmahuuse ogella yezin hyanidannon soollo feedhide wode wayzi eza erezako unttis ohida. ");
INSERT INTO oydl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lam77i tamaaruntsi yinna ohitilla yezin, Yesuusa un gidda eqqii, «Saro yinttis maaqqe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Maaqqikon, un tannii, meeshe bi7ide gaara yi7in zhashtida. ");
INSERT INTO oydl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","E unttago, «Akkos zhashtido? Akkos so7e yin wozintte gelido? ");
INSERT INTO oydl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta kushiton ta tohito bo7ote; ta tana. Mahi aykkii bo7ote; tana yin be7izannigaara, meeshes ashon meqatsii baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yaga7i, fa tohiton fa kushiton unttana beezida. ");
INSERT INTO oydl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Un ufayssappa denddidannippa ammananxii gaama qoppii yezin, Yesuusa unttago, «Hyanne yinttis mu7izebaz yene?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Un fettii michinttide molo ees inggida. ");
INSERT INTO oydl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","E ekkii un tiintte mu7ida. ");
INSERT INTO oydl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","E, «Ta yinttara gam7ide wode ubbanne Muse higge maxaafite, nabuntsi maxaafiten Mazmure maxaafite, ta gisho xaafinttidanna ubbanna folinttodes beezane yaga7i ta yinttis ohide qaaltta hyanno» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ye wode Geeshi Maxaafito tiirode gaar wozintto unttis bugida. ");
INSERT INTO oydl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yinnii fana, «Kiristtoosa madha ekkoda, hyaydzdzintsa qammite hyayqoppa denddoda yaga7i xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yerusalaameppa denddii asi ubbanna nagarappa maarotitsin atotetsi E suntsite markkidhoda. ");
INSERT INTO oydl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yin yinnis markka. ");
INSERT INTO oydl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yikke, taanin ta aday inggide ufayssito yinttis dakkoda. Yin saloppa wolqqa ekkode wontsis Yerusalaame katama gam7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yinnippa suuba, Bitaaniya katama unttana ekkii hyanggida. Fa kushito dentsii anjjida. ");
INSERT INTO oydl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Unttana anjjite unttappa shaakkintti ude Salo ekinttida. ");
INSERT INTO oydl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Un zuggii goynii gaama ufayssara Yerusalaame maaqqida. ");
INSERT INTO oydl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Xoozza ubba wode galatitera Xoozze Keetstsa gam7ida.");
INSERT INTO oydl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qaala tiino yene. Qaalizen Xoozara yene; ye Qaalize Xoozii. ");
INSERT INTO oydl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ezin tiinoppan Xoozara yene. ");
INSERT INTO oydl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xoozze ubbabazito Qaala baggara medhdhida. Medhinttide bazappa fettibazin E baytsi medhinttide bazi baaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","E gidda de7o yene; yinna de7itan asis foo7o. ");
INSERT INTO oydl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Foo7ize dhuma gidda foo7ane; dhumita foo7iza gamikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xoozapp kiitinttide, Wahannisa ga7inttize fettii asi yene. ");
INSERT INTO oydl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Asi ubba foo7iza ammanode fana E foo7ize markka maaqqii yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","E foo7ize baz markkidhodes yi7idap attin fa ommite foo7o baaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Asi ubbas foo7ize turii foo7o alame ye7ine. ");
INSERT INTO oydl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Qaalize alame yene. Xoozze Qaalara alamito medhdhida, yezin alamita eza erikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E fa bagguntsago yi7ida, yezin E bagguntsin eza ekkikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yezin E fana ekkiduntsisin E suntsite ammaniduntsis unttis Xoozze na7a maaqqade gaar adetits wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Un Xoozappa yelinttidap attin asi yelinttize wogara woy dhiiratsi qofappa woy as qofappa yelinttikaaya. Xoozze E unttis ade. ");
INSERT INTO oydl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Qaala asho maaqqida; aadho keehatitsaran turetitsara kumii nu gidda aqida. Fettii na7ays E aday kale yeze bonchchiti fana yeze bonchcho nu bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wahannisa E baz markkidhida. Fa qaaltto dhoqi yiizii, «Taanii, ‹Taappa suubara ye7ize taappa tiino yeze gisho taappa aadhane› ga7i markkidhidanna hyanno» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nu ubbuntsi E aadho keehatitsite kumutsitippa anjjolla afa anjjo ekkida. ");
INSERT INTO oydl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Xoozze higge Muse baggara inggida, yezin aadho keehatitsin turetitsi Yesuus Kiristtoosa baggara yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xoozza bi7ide asi ooden baaya; fa Aday kale yeze fettii Na7ay Xooz maaqqide E qonccizida. ");
INSERT INTO oydl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yerusalaame yeze hyalaquntsi, kahinuntsin Leewuntsin, «Ne oode?» ga7i, Wahannisa oocode gaar eego kiittin, Wahannisa unttis markkidhide markkatitsita hyanno. ");
INSERT INTO oydl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wahannisa, «Ta Kiristtoosa baaya» yaga7i, loytsii markkidhidap attin kaddikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Un, «Yeezin, ne oode? Neenii Eliyaasane?» ga7i oocida. Wahannisa, «Ade tana baaya» gayda. Mahi un, «Neenii ye7odes ga7intteze nabene?» ga7i oocida. Wahannisa, «Ade» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yeezin, «Ne oode? Nu nuna kiittezuntsis ohode fana neenii nena oona ga7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wahannisa mahi, Nabe Isayaasa ga7idanni gaara, « ‹Laatstse ogito luulizote!› ga7i akko baayze ganasa uukkize atstse qaalize tana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yezin Farisaawuntsi kiittide asuntsi ");
INSERT INTO oydl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wahannisago, «Neenii Kiristtoosa woy Eeliyaasa woy nabe maaqqaanxi ixxiko, yeezin akkos xammaqe?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Wahannisa mahi, «Taanii hyaatsara xammaqane, yezin yin eroosse asi yin gidda eqqida. ");
INSERT INTO oydl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E taappa suubite ye7ine. Ta melle atto yezin Ees caamma gaadiza billodes beezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yinna ubba Yorddaanosa borkkappa seko fintsa, Bitaaniya katamite, Wahannisa xammaqize besite hyanida. ");
INSERT INTO oydl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wahannisa wonttisti wode Yesuusa faago ye7odera bi7i, «Alame nagara uccize Xoozze Durzay hyaychche! ");
INSERT INTO oydl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taanii, ‹Taappa suubara fettii asi ye7oda. E taappa tiino yeze gisho taappa aadhane› ga7i ohide hyaya. ");
INSERT INTO oydl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","E oode yezako ta eroos. Yezin Isra7eele asuntsis eza qonccissades hyaatsara xammaqittera yi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wahannisa hyannigaara ga7i markkidhida: «Geeshi Ayyaana saloppa wolle gaar wodhdhizin bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yinna hyanodannippa tiino taanii eza eroos. Yezin hyaatsara xammaqodes tana kiittide Xoozze, ‹Geeshi Ayyaana wodhdhii eera yessadera neenii be7ize Geeshi Ayyaanara xammaqoday eza› yaga7i taas ohida. ");
INSERT INTO oydl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Taanii yinna hyanodera bi7i, E Xoozze Na7a maaqqidanno markkidhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mahi wonttisti wode Wahannisa fa tamaaruntsappa lam77untsara wolla eqqida. ");
INSERT INTO oydl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesuusa aadhodera Wahannisa bi7i, «Xoozze durize hyaynishe!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lam77i Wahannisa tamaaruntsi Wahannisa gaazanno si7i Yesuusa kaallida. ");
INSERT INTO oydl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuusa fana kaallizuntsana suub maaqqii bi7i, «Akko koye?» yaga7i oocida. Un mahi, «Rebbii, ne aba yene?» yagayda. (Bilitsita Asttamaarizayo ga7e.) ");
INSERT INTO oydl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesuusa unttago, «Hyankka yi7i bo7ote» yagayda. Un hyanggi E yezebezito bi7ida. Ye wode sa7ita taphphi saate gaar maaqqide gisho E kale feezhida. ");
INSERT INTO oydl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wahannisa gaydanno si7i, Yesuusa kaallide lam77i tamaaruntsappa fete, Simoon Phexiroosa ishe Inddiriyase. ");
INSERT INTO oydl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Inddiriyase tiino fa ishe Simoonara yellintti, «Nuunii Mesiihi denggida» yagayda. (Bilitsitan Kiristtoosa ga7e.) ");
INSERT INTO oydl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Inddiriyase Simoona Yesuusago ki7ida. Yesuusa Simoona bi7i, «Ne Yoona na7a Simoona; ne suntsita Keefa ga7i xeeginttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wonttisti wode Yesuusa Galila qitodes qofa accida. E Filphoosa denggi, «Tana kaallo!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filphoosa, Inddiraseran Phexiroosaran yezide Beetesayda katama asi. ");
INSERT INTO oydl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filphoosa Natina7eela yellii, «Muse higge maxaafite, mahi nabuntsin E baz xaafide Yoosefa na7a Naazirete Yesuusa nu denggida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natina7eela mahi, «Naazirete katamappa lo77o baz kessades dandda7ane?» yagayda. Filphoosa, «Yi7i bo7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natina7eela faago ye7izaya Yesuusa bi7i, «Gene baayze turii Isra7eele asi hyaynishe!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natina7eela Yesuusago, «Ne tana aba ere?» yagayda. Yesuusa mahi, «Filphoosa nena xeegodannippa tiino, ne belese minxa oomo yezin ta nena bi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natina7eela mahi, «Asttamaarizayo, ne Xoozze Na7a! Ne Isra7eele kaati!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesuusa eego, «Ta nena belese minxa oomo bi7ida gayde gisho ammanane? Ne hyannippa aadhizebaz be7ada!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mahi Yesuusa, «Taanii yinttis turibaz ohine; salo bugunttin, Xoozze kiitanchchuntsi As Na7alla afa kessaderan keddoderan yin be7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hyaydzintsa wode Galila Qaana katama zhagana yene. Yesuusa intta yinna zhagantte yeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuusan E tamaaruntsin wolla yinna zhagantte xeeginttida. ");
INSERT INTO oydl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Woyne ushita hyal7in, Yesuusa intta Yesuusago, «Unttis woyne ushita hyal7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesuusa mahi, «Immo, ne hyanne gelippe? Ta wodita hyaga yelikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesuusa intta oochchizuntsago, «E yinttis ohizanno ubba oochchote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayhudunts fa geeshe wogas maadinttize izippun shuchchi ganuntsi yinna besite yene. Fete fete gaanuntsi lam77i woy hyaydzdzii xugga aykkane. ");
INSERT INTO oydl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuusa kiitinttizuntsago, «Gaantte hyaatsi kuntsote» yagayda. Un gaanuntsis doontto yellodes hyaatsi kuntsida. ");
INSERT INTO oydl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesuusa unttago, «Hyatte duuqqii zhagantto adidhii folizes inggote» yagayda. Un ees kanggi inggida. ");
INSERT INTO oydl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Zhagantto adidhii folizay woyne ushita laaminttide hyaatsito qamasi bi7i anappa ye7ezakon erikaaya, yezin hyaatsito kuntside kiitinttizuntsi erane. Zhagantto adidhii folizay machcho ekkizaya xeegii, ");
INSERT INTO oydl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«Ooden lo77o woyne ushito asi tiinidhii ushshane. Yeyzi asuntsi uzhii mizhidannippa suuba zhagginttida inggane. Yezin neenii lo77o woyne ushito hyanno yellodes gaddii gam7izida» gayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuusa hyay tiino kille oochchiza Galila Qaana katama oochchida; ize fa bonchchito beezida. E tamaaruntsin eza ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yinnippa maaqqii, Yesuusa fa inttira, fa ishuntsaran fa tamaaruntsara wolla Qifirnahoome katama hyanggi eeratsi qamma gam7ida. ");
INSERT INTO oydl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayhudunts bonchchize Faasiga Ba7ale qammita ukkin Yesuusa Yerusalaame qitida. ");
INSERT INTO oydl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hyanggi Xoozze Keetstsa bora, hyaari, duron wollen baayzuntsanan fa oyditilla bettii bira laammizuntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","E xurqqaafa giigizii asuntsana ubba unttana un hyaaruntsara Xoozze keetstsappa bay7i bale kessida. Bira laammizuntsana xarpheziton shirii olii un birto lalida. ");
INSERT INTO oydl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wolle bayzizuntsana, «Hyantsi wolluntsana hyannippa kessote; ta Aday keetsito gabe mahippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","E tamaaruntsi Geeshi Maxaafite, «Ta ne keetsitis yiqsinttize yiqsintta tana tama gaara michchane» ga7intti xaafinttidanno tiirida. ");
INSERT INTO oydl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yinnippa suuba, Ayhuduntsi mahi, «Ne hyanno oochchodes nees wolqqa yezannis nuna akko malla oochchii beessade?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuusa, «Hyanna Xoozze keetsito wul7ote ta hyaydzdzii qammara mahi keexxoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yinnii gisho Ayhuduntsi, «Hyanna Xoozze Keetsito keexxodes oyttam izippun bere ekkida, yezin neenii hyaydzdzii qammara keexxoda?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yezin Yesuusa ohize Xoozze Keetsita fa ashtibaz. ");
INSERT INTO oydl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yinnii gisho, Yesuusa hyayqoppa denddidannippa suuba eza tamaaruntsi E yinno gaydanno tiirida. Mahi un Geeshi maxaafite xaafinttidannon Yesuusa ohidanno ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuusa Faasiga bonchchize bessa Yerusalaame yessadera, E oochchide kille bazito bi7i gaama asuntsi eza ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yezin Yesuusa asuntsana ubba erize gisho unttana ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","As wozintte yeze baz E fa ommite erize gisho asi baz ooden ees ohode gaar koshshikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisaawunts baggappa maaqqide, Ayhudunts hyalaqa, Niqodimoosa ga7inttize fettii asi yene. ");
INSERT INTO oydl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ezin qamma Yesuusago yi7i, «Bonchcho Asttamaarizayo, neenii Xoozii kiittide asttamaare maaqqizanno nuunii erane. Akkos gayko, Xoozii eera yezanxiko hyanno neenii oochchize kille bazito oochchodes dandda7ize asi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuusa mahi, «Taanii nees turo turo gaane; ooden lam7intsa yelinttanxiko Xoozze ka7itumo be7ades dandda7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niqodimoosa, «Cinggii asi wayzi lam7intsa yelinttodes dandda7e? Fa inttii saza maaqqii gelii mahi yelinttodes dandda7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuusa mahi, «Taanii nees turo turo gaane; asi hyaatsappan Geeshi Ayyaanappa yelinttanxiko, Xoozze ka7itumo gelodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Asho na7atitsi adeppan inddippan yelinttane; Xoozze na7atitsi Geeshi Ayyaanappa yelinttane. ");
INSERT INTO oydl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taanii, ‹Yin lam7intsa yelinttodes beezane› ga7i yinttis ohide gisho neenii gaama qoipippe. ");
INSERT INTO oydl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Baqo fa koyze zala baqqane. Ne E ootsito si7izanno fattin E abappa ye7izako woy aba qitizako ne eroos. Ayyaanappa yelinttide ubba yinnii fana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yeezin Niqodimoosa, «Yinna wayzi hyanodes dandda7e?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuusa mahi, «Neenii Isra7eeluntsi asttamaare maaqqitera hyanno erosa? ");
INSERT INTO oydl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taanii nees turo turo gaane; nu erizebaz ohinen bi7idebaz markkidhane, yezin nu markkatitsito yin ekkoos. ");
INSERT INTO oydl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Taanii yinttis sa7abaz ohin yin ammanoosuntsi salobaz ohin wayzi ammanode? ");
INSERT INTO oydl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Saloppa wodhdhide As Na7ayip attin salo kezide ooden baaya; salo yeze As Na7ay tana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Muse akko baayze ganas sa7a shooshi suxxidannifana tana ammanze ubbuntsi medhina de7o ekkode fanan dhabaame fana As Na7ay suxunttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Eza ammanze ubbuntsi medhina de7o laattodep attin dhabaame gaar Xoozii hyanna alamito loytsii kadhide gisho fa fettii Na7aya inggida. ");
INSERT INTO oydl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Xoozii fa Na7aya hyanna alamite kiittidanna alamito firddodes maaqqikaayzin alamito E baggara ashshodes. ");
INSERT INTO oydl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na7aya ammanze ooden firddinttoos, yezin Na7aya ammanoose ooden fettii Xoozze Na7aya ammanikaayze gisho hyatte firddinttida. ");
INSERT INTO oydl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Firdditan hyanno: foo7o alame yi7ida, yezin asunts oochita iita maaqqide gisho asuntsi foo7itippa aatsii dhuma kadhane. ");
INSERT INTO oydl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iita baz oochchize ooden foo7o ixxane. Akkos gayko, fa oochita qonccaame fana foo7ogo ye7oos. ");
INSERT INTO oydl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yezin turtto oochchize ooden Xoozze kiittidanni fana E oochchidanno foo7o qonccissade fana foo7ogo ye7ine. ");
INSERT INTO oydl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yinnippa suuba, Yesuusan E tamaaruntsin Yihuda sa7a qitida. Yesuusa yeyga xammaqittera unttara eerats wode bettida. ");
INSERT INTO oydl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mahi Wahannisa Saleeme kale yeze Henoona gaaze bessa gaama hyaatsi yeze gisho asuntsana yeyga xammaqane. Asuntsin yeyga hyanggi xammaqinttane. ");
INSERT INTO oydl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ye wode Wahannisa hyaga acinttikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yinnippa suuba, Wahannisa tamaaruntsin fettii Ayhude atstsay geeshe wogabaz wolla lallida. ");
INSERT INTO oydl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Un Wahannisago hyanggi, «Asttamaarizayo, Yorddaanosa borkkappa seko fintsa neera yeze, neenii E baz markkidhiday, hyaychche xammaqane. Asunts ubba eego hyanggane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Wahannisa mahi, «Xoozii inggikaayze asi akko bazin ekkodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹Taanii Kiristtoosa baaya, yezin eeppa tiino kiitinttida› gaydannis yin, yin ommite taas markka. ");
INSERT INTO oydl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gelodes giiginttdanna ekkodes giigezes. Ekkizes lagguntsi E kale eqqii E gaazanno si7ize wode gaama ufayttane. Yinnii gisho, hyanna ta ufayssita folinttida. ");
INSERT INTO oydl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","E dammodes ta eerodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Afappa yi7ize ubbappa dhoqqa. Sa7appa benttide sa7a asi; E sa7abaz ohine. Saloppa yi7ide ubbappa aatsii. ");
INSERT INTO oydl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","E fa bi7idebazin si7idebaz izo markkidhane, yiikon E markkatitsito si7ize baaya. ");
INSERT INTO oydl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","E markkatitsito ekkize ooden Xoozze turo maaqqidanno tillizane. ");
INSERT INTO oydl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xoozii fa Geeshi Ayyaana ees kuntsi inggize gisho Xoozii kiittide Xoozze qaala ohine. ");
INSERT INTO oydl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aday fa Na7aya kadhii ubbabazito E kushite gaddida. ");
INSERT INTO oydl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na7aya ammanzes medhina de7o yene. Yezin Na7aya ammanoosella Xoozze firdda yenep attin E de7o denggoos. ");
INSERT INTO oydl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuusa Wahannisappa aatsii kaallizuntsana faago shiishii xammaqizanno Farisaawuntsi si7ida. ");
INSERT INTO oydl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Maaqqikon Yesuusa tamaaruntsi xammaqidap attin Yesuusa oonan xammaqikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesuusa asuntsi E baz gaazanno si7ide wode Yihudappa denddii maaqqii Galila qitida. ");
INSERT INTO oydl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galila qititera Samaarera aadhodanna ees attaamebaz maaqqida. ");
INSERT INTO oydl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yinnii gisho, Yayqooba fa na7ay Yoosefas inggide gaditii kale yeze Sikaare gaaze Samaara katama yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yinna besite Yayqoobas hyaatsi doochii yene. Yesuusa hyanggitera labbii yinna hyaatsi doochiti kale bettida. Ye wode sa7ita awarappa izippun saate gaara. ");
INSERT INTO oydl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Fettii Samaara katama maachita yinna doochitippa hyaatsi kixxodes yi7ida. Yesuusa yinna maachitigo, «Tana hyaatsi ushshoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yinna wodite Yesuusa tamaaruntsi katstsa wonggodes katama qitenyeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yinna maachita mahi, «Ne Ayhude asi maaqqitera, Samaara maacho maaqqide tana wayzi hyaatsi ushsho ga7e?» yagayda. Yinno iza gaydanna Ayhudunts Samaaruntsara yellinttoosse gisho. ");
INSERT INTO oydl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesuusa mahi, «Ne Xoozze imotitsin hyaatsi tana ushsho gaaze oode yezako erizebaz maaqqizako eza ne woossoda; yezin nees de7o inggize hyaatsi inggodyeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Maachita mahi, «Laatstsayo, nees duuqqize hyale baaya; doochitan hyaako. Yeezin, de7o inggize hyaatsi ne abappa ekkode? ");
INSERT INTO oydl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nuus hyanna hyaatsi doochito inggide nu aday Yayqoobappa ne aadhode? Een, E na7untsin E hyaaruntsii hyanna hyaatsi doochitippa uzhida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuusa, «Hyanna hyaatsitippa uzhize ooden mahi baridhdhada. ");
INSERT INTO oydl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yezin ta inggode hyaatsito uzhize ooden medhinas baridhdhaama. Ta inggode hyaatsita E gidda medhina de7o inggize goggize hyaatsi aafe maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Maachita mahi, «Laatstso, taanii baridhdhaame gaaran hyaatsi duuqqodes hyanna besite ye7aame fana taas yinna hyaatsito inggo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesuusa iigo, «hyanggi ne azinza xeegii yo7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Maachita mahi, «Taas azini baaya» yagayda. Yesuusa iigo, «Taas azinii baaya ga7i turo ohida. ");
INSERT INTO oydl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nees tiino ichchin azinutsi yene. Hyatte neera yeze atstsay nees azinii baaya. Ne hyatte turo ohida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Maachita mahi, «Laatstso, ne nabe maaqqidanno ta erida. ");
INSERT INTO oydl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu aduntsi hyay derizella Xoozi goynida. Yezin yin Ayhudunts asi Xoozi goynodes beezize besita Yerusalaame yene gaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuusa, «Hyanna maachite tana ammano; hyay derizella woy Yerusalaame Adaya yin goynaame wode ye7oda. ");
INSERT INTO oydl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yin Samaaruntsi erinttooses goynane. Yezin nuunii ashshize Ayhudeppa ye7ize gisho nu erizaya goynane. ");
INSERT INTO oydl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yezin Adaya turippa goynizuntsi Ayyaanaran turotitsara goynize wodita ukkida; hyatten yellida. Yikke, Aday koyze hyannii gaar ogera goynizuntsana. ");
INSERT INTO oydl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Xoozze Ayyaana; ees goynizuntsi Ayyaanaran turotitsara goynodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Maachita mahi, «Kiristtoosa gaaze tizhinttide yo7odanno ta erane. E ye7ize wode nuus ubba baz ohoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesuusa, «Hyay neera ohinttize taanii eza» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Un ohinttodera, Yesuusa tamaaruntsi hyanggide besitippa maaqqida. Yesuusa maachitira ohinttodera un bi7i gaama qoppida. Yezin maachitigo, «Akko koye?» Woy Yesuusago, «Izira akkos ohintte?» gayde ooden baaya. ");
INSERT INTO oydl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yinnippa maaqqii, maachita fa hyaatsi otto ashshii suuba katama hyanggi asuntsago, ");
INSERT INTO oydl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Taanii oochchidanno ubba taas ohide atstsa bo7odes yedhdhote. E Kiristtoosa maaqqane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Asuntsi katamappa kezii Yesuusago hyanggida. ");
INSERT INTO oydl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yinna yi7adera, E tamaaruntsi Yesuusago, «Mo7oyo» ga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yezin E, «Taas yin eroosse katstsa ta muuze yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yinnii gisho, E tamaaruntsi fa gidda, «Ees muuze baz asi ki7ikaayzara attaama?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesuusa unttago, «Ta katsita tana kiitteze qoftto oochchodannon E oochito faaddodanno. ");
INSERT INTO oydl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yin, ‹Oyddii aginappa suuba katstsa maxinttoda› gaane baa? Yezin taanii yinttis ohine; katsita kaxxin shiishes yellidanno loytsii bo7ote. ");
INSERT INTO oydl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Budizen maxizen wolla ufayttode gaar maxizay damooze ekkane mahi katstsa medhina de7oos aafe shiishane. ");
INSERT INTO oydl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Yikke, ‹Fete budane; hyankkay mahi maxane› gaaze ohita turo. ");
INSERT INTO oydl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yin labbikaayzanno shiishode gaar ta yinttana kiittida. Melluntsi oochchii labbidanne gelii yin un labbide aafto ekkida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Maachita, «E, ta oochchide ubbabazito ohida» ga7i markkidhide gisho yinna katamite yeze Samaara asuntsappa gaamuntsi Yesuusa ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaara asuntsin Yesuusago yi7i, un kale gam7ode gaar Yesuusa woossin E ize lam77i qamma bettida. ");
INSERT INTO oydl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E ohide qaaltti gisho kasennippa gaama asuntsi ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mahi un maachitigo, «Hyatte nu ammanidanna nu ommite E gaazanno si7ide gishop attin ne markkidhide gisho baaya. Mahin E turo hyanna alamito ashshiza maaqqizanno nu erida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lam77i qammappa suuba, Yesuusa yinnippa kezii Galila qitida. ");
INSERT INTO oydl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesuusa fa ommite, «Nabe fa gadite bonchchinttoos» yaga7i tiinidhii ohida. ");
INSERT INTO oydl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuusa Galila yelide wode Galila asuntsi eza mokkida. Akkos gayko, Faasiga Ba7ale bonchchize wode un Yerusalaame yeze gisho E oochchidanno ubba bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesuusa hyaatsito woyne ushi laammide besite, Galila yeze Qaana katama hyanggida. Qifirnahoome kaati keetstsa oocize shuumizes na7i hyargginttane. ");
INSERT INTO oydl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesuusa Yihudappa Galila yiidanno ye shuumize si7i eego yi7ida. Hyayqqodes yellide fa na7aya hyanggi fatstsode gaar Yesuusa woossida. ");
INSERT INTO oydl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuusa Shuumizego, «Xoozii oochchize gaama qofizen kille bazi bi7ikaayzara yin mulon ammanoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Shuumizen mahi, «Laatstsayo, ta na7ay hyayqqikaayzin taara yedhdhoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuusa, «Ne kara qito; ne na7ay faxoda» yagayda. Ye shuumize Yesuusa ohide qaaltto ammanii fa kara qitida. ");
INSERT INTO oydl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E fa kara hyanggodera eza arunts eego yi7itera ezar oge yellintti, «Ne na7ay faxida» gayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","E fa aruntsana fa na7ays akko saate lo77ezako oocida. Un mahi, «Omatse laappun saate michita ashshida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na7ay aday Yesuusa faago, «Ne na7ay faxoda» gaydanna yinna saate maaqqidanno tiirida. Yinnii gisho, ezin E kara asunts ubbuntsara ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yinna Yesuusa Yihudappa Galila yi7i oochchide lam7intsa kille baz. ");
INSERT INTO oydl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yinnippa maaqqii, Yesuusa Ayhuduntsi bonchchize baales Yerusalaame qitida. ");
INSERT INTO oydl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalaame Duro furtsi kale Ibraysxe doonara Beetesayda gaaze teqinttide geenna yene. Ye teqintti yeze hyaatsiti kale kanggizen ke7ize ichchin oge yene. ");
INSERT INTO oydl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yinne hyaatsita en7inttizanno naagize gaama hyargginttizuntsi, qooquntsi, wobbuntsin galla siliduntsi woy7ida. ");
INSERT INTO oydl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Akkos gayko, fettii fettii tohe Laatstse kiitanchcho geenite wodhdhii hyaatsito en7izane. Hyaatsita en7ize wode tiinii gelide atstse fana aykkide akko hyarggeppa faxane. ");
INSERT INTO oydl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yinna besite hyastam osfun bere hyargginttide fettii asi yene. ");
INSERT INTO oydl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuusa ize woy7ide atstsa bi7i, mahi gaama wode hyargginttidanno erii atstsego, «Faxodes koyane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hyargganchchize mahi, «Laatstso, hyaatsita en7inttize wode tana hyaatsite olize asi baaya. Ta gelodes yiyoder melluntsi taappa tiinii gelane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesuusa eego, «Denddii eqqo; ne alggiza tookkii qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Atstsay iira faxida; fa alggiza tookkii qitida. Yinna Sambbata wode hyanida. ");
INSERT INTO oydl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yinnii gisho, Ayhudunts faxide atstsego, «Hyayno sa7ita Sambbata; neenii ne alggiza tookkizanna woga baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yezin atstsay, «Tana fatstseze, ‹ne alggiza tookkii qito› gayda» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Un eego, «Nena, ne alggiza tookkii qito gayde E oode?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Yezin Yesuusa yinna besite gaama as giddappa deshshi gayde gisho atstsay fana fatstside oode yezako erikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yesuusa suubappa ye atstsa Xoozze Keetstsa denggi, «Hyaychche, ne faxida; hyannippa aadhize iita baz nena yellaame gaar mahi nagara oochchippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yinnippa maaqqii, atstsay hyanggi fana fatstside Yesuusa maaqqizanno Ayhuduntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuusa yinno Sambbata ode oochchide gisho Ayhudunts Yesuusa baytstse aykkida. ");
INSERT INTO oydl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuusa mahi, «Ta Aday ubba wode oochchane; taanin oochchodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuusa Sambbata bonchchikaayze gisho xalaalas maaqqikaayzin Xoozza fa Ade ga7i fana Xoozara wolkkizide gisho Ayhudunts eza wodhodes tiinonnippa mintsii koyda. ");
INSERT INTO oydl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuusa mahi, «Ta yinttis turo turo gaane; Na7ay faas akkon oochchodes dandda7oos. E fa Aday oochchodera bi7idanno xalaala oochchane. Aday oochchizanno Na7ayin oochchane. ");
INSERT INTO oydl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aday fa Na7aya kadhize gisho oochchize oocha ubba fa Na7aya beezane. Yin gaama qoppode gaar E hyannippa aadhize oocha fa Na7aya beezoda. ");
INSERT INTO oydl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aday hyayqqiduntsana hyayqoppa dentsii unttis de7o inggizannigaara Na7ayin fa koyezuntsis de7o inggane. ");
INSERT INTO oydl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aday Na7ays firddode gaar adetits wolqqa inggidap attin E oonan firddoos. ");
INSERT INTO oydl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yinno E oochchidanna Asi ubba Adaya bonchchizanni gaar Na7ayan bonchchode fana. Na7aya bonchchoosse ooden Na7aya kiittide Adayan bonchchoos. ");
INSERT INTO oydl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Ta yinttis turo turo gaane; ta qaaltto si7izes tana kiitteza ammanzes medhina de7o yene. E hyayqoppa de7o fiinggide gisho firddinttoos. ");
INSERT INTO oydl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ta yinttis turo turo gaane; hyayqqide asuntsi Xoozze Na7ay qaaltto si7ize wode ye7oda; yinnan hyatte. E qaaltto si7ize de7o yessada. ");
INSERT INTO oydl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aday faas de7o yezanni fana Na7aysin de7o yessade fana inggida. ");
INSERT INTO oydl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na7ay As Na7a maaqqide gisho Aday Na7ays firddode gaar adetits wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«Booza yezuntsi E qaaltto si7i denddize wode ye7ode gisho hyanne gaama qoppipete. ");
INSERT INTO oydl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lo77o oochchiduntsi de7o dendddes mahi iita oochchiduntsi firdda ekkodes boozappa denddoda. ");
INSERT INTO oydl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Taanii ta adetitsi wolqqara akko bazin oochchodes dandda7oos. Xoozze taas ohidanni gaar firddane. Taanii tana kiittide koyze baz oochchanep attin ta koyze baz oochchoose gisho ta firddita turo. ");
INSERT INTO oydl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Taanii ta baz markkidhiko ta markkatitsita turo maaqqoos. ");
INSERT INTO oydl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ta baz markkidhize melle yene; E ta baz markkidhizanna turo maaqqizanno ta erane. ");
INSERT INTO oydl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Yin Wahannisago asi kiittin E turis markkidhida. ");
INSERT INTO oydl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ta yinno yinttis ohizanna, yin attode gaar gaydap attin asi markkatitsi taas koshshin baaya. ");
INSERT INTO oydl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Wahannisa goga gaar eexize foo7o. Yin eerats wode E foo7ite ufayttodes koyda. ");
INSERT INTO oydl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Yezin taas Wahannisappa aadhize markka yene. Ta oochchode gaar ta Aday taas inggide oochita ta baz markkidhane; Aday tana kiittezanno beezane. ");
INSERT INTO oydl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«Mahin tana kiittide Aden fa ommite ta baz markkidhane. Yin E qaaltto mulo si7ikaaya woy E bishshito bi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","E kiittezanno yin ammanoose gisho E qaaltta yin wozintte baaya. ");
INSERT INTO oydl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Geeshi Maxaafuntsappa medhina de7o denggodebaz yinttis aazin un qurichchane; qaalttan ta baz markkidhane. ");
INSERT INTO oydl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yezin yin de7o denggodes taago yo7odes koyoos. ");
INSERT INTO oydl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Asappa taanii bonchcho koyoos. ");
INSERT INTO oydl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yezin taanii yin wozintte Xoozze siiqo baayzanno erane. ");
INSERT INTO oydl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taanii ta Aday suntsite yi7ida, yezin tana mokkikaaya. Hyankay fa suntsite ye7iza mokkane. ");
INSERT INTO oydl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yin fete feteppa bonchcho koyzuntsi, fettii Xoozzeppa ye7ize bonchcho ekkodes koyoosuntsi, wayzi tana ammanodes dandda7ode? ");
INSERT INTO oydl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Taanii ta Aday tiino yinttana mootizebazi yinttis aazippe. Yinttana mootode yin ufaytti kafize Muse. ");
INSERT INTO oydl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yin Muse ammanezako E ta baz xaafide gisho tanan ammanodyeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Yezikon yin E xaafidanno ammanaanxxiko ta qaaltto wayzi ammanode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Yinnippa maaqqii, Yesuusa Xibaaryoosa gaaze Galila Abbap seko gaxa fiinggida. ");
INSERT INTO oydl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","E hyargganchchuntsana fatstsi kille baz oochchidanno bi7ide gisho gaama asuntsi eza kaallida. ");
INSERT INTO oydl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuusa derella kezii, yeyga fa tamaaruntsara wolla bettida. ");
INSERT INTO oydl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayhuduntsi bonchchize Faasiga Ba7ale ukkida. ");
INSERT INTO oydl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuusa gaama asunts faago ye7izanno bi7i Filphoosago, «Hyantsi asuntsana ubba muusades maaqqade katstsa abappa wonggode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E yinno Filphoosa fattanodes gaydap attin E fa ommite akko oochchodyezako erane. ");
INSERT INTO oydl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filphoosa mahi Yesuusago, «Melle atto yezin, omma omma, fettii fettii baaritsi yelitsodes, lam77i xeet dinaarera boora wonggikon maaqqoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mahi Yesuusa tamaaruntsappa fete, Simoon Phexiroosa ishe Inddiriyase, ");
INSERT INTO oydl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ichchin beshe bangga booran lam77i molo aykkide fettii na7a hyanne yene, yezin hyantsi asunts ubbas yinna akko maaddode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuusa fa tamaaruntsago, «Asuntsana betitsote» yagayda. Yinna besite gaama buca yene; asuntsi ubba bettida. Dhiiratsi asunts faydita ichchin mukul maaqqada. ");
INSERT INTO oydl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuusa booriza ekkii Xooz galatii maaqqii fa tamaaruntsis inggida. Unttin bettide asuntsis yeltsida. Moltton ekkii yinnii fana yiizii inggin, asuntsi fa koydanni gaar muyda. ");
INSERT INTO oydl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Un ubbuntsi mizhidannippa suuba Yesuusa fa tamaaruntsago, «Fettibazin iitaame gaar attide gufto shiishote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yinnii gisho, un ubba shiishida. Asuntsi mu7in attide bangga boora gufa shiishin taphpho lam77i leemate maaqqida. ");
INSERT INTO oydl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asuntsi Yesuusa oochchide kille baz be7eze wode «Hyay turo hyanna alamtte ye7oda ga7inttide nabiza» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuusa un eza aykkii wolqqara kaati mahodes hyanzanno erii, faas derella mahi kezida. ");
INSERT INTO oydl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sa7ita ugurin Yesuusa tamaaruntsi abbago wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sa7ita qammide gishon Yesuusa hyaga unttago yi7ikaayze gisho E tamaaruntsi gonggite gelii abba fiinggi Qifirnahoome qitodes denddida. ");
INSERT INTO oydl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Damma baqo baqqide gisho abba hyaatsita en7ida. ");
INSERT INTO oydl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ichchin woy izippun kilo mitire maaqqade gaar un abballa hyanggidannippa suuba Yesuusa abballa yedhdhitera ye7izanno bi7i zhashtida. ");
INSERT INTO oydl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yezin E, «Zhashtippete, tana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Un ufaytti eza gonggite geltsida; iira gonggize un hyanggize abba gaxa yellida. ");
INSERT INTO oydl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wonttistti wode abbappa seko gaxa attide gaama asuntsi fettii gongge xalaala yezanno bi7ida. Yesuusa fa tamaaruntsara gonggite gelii, unttara hyanggoosannon un fa faas hyanggidanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yezin Xibaaradoosappa melle gongguntsi Yesuusa Xooz galatin, asuntsi boora muyde bessito yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asuntsi Yesuusa woy E tamaaruntsi ize baayzanno bi7i, Yesuusa koyodes gonggite gelii Qifirnahoome qitida. ");
INSERT INTO oydl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asuntsi Yesuusa abbappa seko fintsa denggide wode «Asttamaarizayo, hyanne ayde ne yiido?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuusa mahi, «Taanii yinttis turo turo gaane; yin tana koyzanna boora mu7i mizhide gishop attin kille baz bi7ide gisho baaya. ");
INSERT INTO oydl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dhabize katstsas oochippete, yezin medhina de7o yeze katstsa inggize As Na7ays oochchote. Ezan Xoozze Aday attamii tillizida.» ");
INSERT INTO oydl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yeezin un, «Nuunii Xoozze oocha oochchodes akko oochchode?» yaga7i Yesuusa oocida. ");
INSERT INTO oydl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesuusa mahi, «Yin oochchode gaar Xoozze koyze oochita hyanno: E kiittidaya ammanode fana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Un mahi, «Nuunii bi7i, nena ammanode gaar akko kille baz ne beessade? Ne akko oochchode? ");
INSERT INTO oydl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Geeshi Maxaafite, ‹Un ma7ade gaar boora saloppa inggida› ga7intti xaafinttidannigaara nu aduntsi akko baayze ganasa manna muyda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesuusa, «Ta yinttis turo ohine; yinttis saloppa turii boora inggide ta Adayp attin Muse baaya. ");
INSERT INTO oydl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Yikke, Xoozii inggize boora saloppa wodhdhide alames de7o inggizaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Un mahi, «Laatstso, nuus ye booriza ubba wode inggo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuusa, «Taanii de7o boora; taago ye7ize ooden mulo naydhdhoos. Mahi tana ammanze atstsen baridhdhoos. ");
INSERT INTO oydl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yezin ta yinttis ohida; yin tana bi7ida, yezin ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta Aday taas inggide ubbuntsi taago yo7oda; mahi taago ye7iza oonan bale dakkoos. ");
INSERT INTO oydl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taanii ta koyze baz oochchodes maaqqikaayzin tana kiittide koyze baz oochchodes saloppa yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tana kiittide koyzanna hyanno: taanii E taas inggide ubbuntsana wurssutsi wode hyayqoppa dentsode gaarap attin feten dhabode gaar koyoos. ");
INSERT INTO oydl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yikke, ta Aday koyzanna yinno: Na7aya bi7i ammanze ubba medhina de7o ekkoda; taanii yentsana ubba wurssutsi wode medhina de7os hyayqoppa dentsoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuusa, «Taanii saloppa wodhdhide boora» gayde gisho Ayhuduntsi eella zuuzinggida. ");
INSERT INTO oydl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Un, «Hyayni nu E adayan E intto erize Yoosefa Na7a Yesuusa baane? Yeezin, E wayzi, ‹Ta saloppa wodhdhida› gawudes dandda7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuusa mahi, «Fete fetera zuuzinggizanno ashshote. ");
INSERT INTO oydl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tana kiittide ta Aday taago ki7ize asappa attin taago yo7odes dandda7ize ooden baaya. Ta wurssutsi wode eza medhina de7os hyayqoppa dentsoda. ");
INSERT INTO oydl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabuntsi, ‹Asi ubba Xoozappa tamaariduntsana maaqqada› ga7i xaafida. Adaya si7izen eeppa tamaaride ooden taago ye7ine. ");
INSERT INTO oydl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xoozze kaleppa yi7idayip attin Adaya be7eze ooden baaya; E xalaala Adaya bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Ta yinttis turo turo gaane; tana ammanize medhina de7o yene. ");
INSERT INTO oydl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taanii de7o boora. ");
INSERT INTO oydl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yin aduntsi akko baayze ganas sa7a manna mu7ida, yezin hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saloppa yi7ide boora hyaya; hyay booriza mu7ide ooden hyayqqoos. ");
INSERT INTO oydl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saloppa yi7ide de7o boorize tana. Ooden hyay booriza mu7iko medhinas yessada. Mahi hyanna alamita de7o yessade gaar taanii yinttis inggode boorize ta ashito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayhuduntsi, «Hyay atstsay fa ashito nu ma7ade gaar nuus wayzi inggodes dandda7e?» yaga7i fa gidda wolla lallida. ");
INSERT INTO oydl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yinnii gisho, Yesuusa unttago, «Taanii yinttis turo turo gaane; As Na7ay ashito, yin ma7anxko, mahi E suutsito yin uzhanxiko, yinttis de7o baaya. ");
INSERT INTO oydl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta ashito mu7izen ta suutsito uzhize atstses medhina de7o yene. Taanii wurssutsi wode eza hyayqoppa dentsoda. ");
INSERT INTO oydl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta ashita turii katstsa; ta suutsitan turii ushi. ");
INSERT INTO oydl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ta ashito mu7izen ta suutsito uzhize atstse ta gidda yene; taanin E gidda yene. ");
INSERT INTO oydl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","De7o Aday tana kiittin, ta E baggara de7o yezannigaara, tana mu7ize atstsen ta baggara de7o yessada. ");
INSERT INTO oydl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Saloppa wodhdhide boorize hyaya: yin aduntsi mu7i hyayqqide manna fana baaya; hyay booriza mu7ize atstse medhina yessada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuusa Qifirnahoome katama Ayhude woosa Keetstsa hyanno tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuusa tamaaruntsappa gaama baggita yinno si7eze wode «Hyanna geloose timirtte; oodes gele?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuusa fa tamaaruntsi yinnis zuuzinggidanno erii, «Hyanna yinttana balitsane? ");
INSERT INTO oydl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yeezin, As Na7ay tiino fa yeze bessa ude kessadera yin bi7izako wayade? ");
INSERT INTO oydl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Geeshi Ayyaana de7o inggane; as wolqqa akkon maaddoos. Ta yinttis ohize qaaltta de7o inggize Geeshi Ayyaanappa yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yezin yin gidda ammanoosunts yene» yagayda. Ammanoosuntsi ood yezako Yesuusa tiinoppan erane. Mahi fana aatsii inggode oona yezako erane. ");
INSERT INTO oydl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mahin Yesuusa, «Aday yo7o gaykaayze ooden taago yo7odes dandda7oos ga7i ta ohizanna yinnii gisho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yinnii baggara, Yesuusa kaallizuntsappa gaamuntsi eza ashshii suub maaqqida; maaqqin eera hyanggikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesuusa taphpho lam77i fa tamaaruntsana, «Yinttin ashshii qitodes koyane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoon Phexiroosa mahi, «Laatstso, nuunii oodego qitode? Nees medhina de7o qaala yene. ");
INSERT INTO oydl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ne Xoozze Geeshi maaqqidanno nuunii ammananen erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesuusa unttago, «Ta yinttana taphpho lam77untsana doorikaane? Yezin yinttappa fete Xalahe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesuusa yinno gaydanna Simoona Na7ay Asqorootu Yihuda gisho. Yihuda Yesuusa aatsii inggodes yeze taphpho lam77i tamaaruntsappa feta. ");
INSERT INTO oydl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yinnippa maaqqii, Ayhuduntsi Yesuusa wodhodes koyde gisho E Yihuda ashshii Galilara wutida. ");
INSERT INTO oydl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayhuduntsi bonchchize daase Ba7ale ukkida. ");
INSERT INTO oydl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yinnii gisho, Yesuusa ishuntsi, «Ne tamaaruntsi ne oochchize kille bazito be7ade gaar hyannippa denddii Yihuda sa7a qito. ");
INSERT INTO oydl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Faas qonccii erinttodes koyze asi ooden fa oochito aachoos. Ne hyantsesana oochchii nebaz alames qonccizo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","E ishuntsi yinno gaydanna ammanikaayze gisho. ");
INSERT INTO oydl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesuusa unttago, «Taas wode hyaga yellikaaya, yezin yinttis ubba wode wottane. ");
INSERT INTO oydl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Alame yinttana ixxodes dandda7oos, yezin taanii alame oochita iita maaqqizanno markkidhize gisho tana ixxane. ");
INSERT INTO oydl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yin ba7aalito qitote; taas wode yellikaayze gisho taanii ba7alito hyanggoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","E yinno ga7i Galila attida. ");
INSERT INTO oydl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","E ishuntsi ba7ale bonchchodes qitidanippa maaqqii Yesuusa ooden erikaayzin benttikaayzara yinna besite hyanggida. ");
INSERT INTO oydl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayhudunts ba7ale bonchchize besite, «E aba yene?» yaga7i eza koyda. ");
INSERT INTO oydl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Asuntsi zuuzinggii E baz ohinttane. Bagguntsi, «E lo77o asi» gaaze wode melluntsi mahi, «Ade, E as balitstsane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Yezin Ayhude hyalaquntsis zhashtide gisho ooden E baz qoncce ohinttoos. ");
INSERT INTO oydl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ba7ale bonchchii gidda yellodera Yesuusa Xoozze keetstsa hyanggi tamaarsse aykkida. ");
INSERT INTO oydl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayhuduntsi, «Hyay atstse timirtte tamaarikaayzara maxaafe wayzi erido?» ga7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesuusa mahi, «Ta tamaarssize timirttita tana kiitteze Xoozze kaleppa ye7ize timirttep attin ta baz baaya. ");
INSERT INTO oydl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xoozze qofa oochchodes koyze ooden hyanna timirttita Xoozze kaleppa ye7izakon woy taanii taappa ohizako erane. ");
INSERT INTO oydl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Fa baz ohize ooden fa bonchcho koyane. Yezin fana kiitteze bonchcho koyze ooden E turii asi; E gidda worddo baaya. ");
INSERT INTO oydl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Muse yinttis higge inggida, yezin yinttappa ooden higge naagikaaya. Yeezin akkos tana wodhodes koye?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Asuntsi mahi, «Neera Xalahe yene; nena wodhodes oode koyze?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuusa, «Ta fettii kille baz oochchin yin ubbuntsi gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Yin, yin na7untsana garrazode gaar Muses woga inggida. Yezin yin mayzuntsappa aykkii yeze wogap attin Muse baaya. Yinnii gisho, yin Sambbata wode dhiiratsi na7untsana garrazane. ");
INSERT INTO oydl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Muse higge sharinttaame fana yin Sambbata wode garrazzebaz maaqqiko, ta fettii atstse kumutsi gallito Sambbatar fatstside gisho taara akkos kacintte? ");
INSERT INTO oydl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Turii firdda firddotep attin as sino bi7i firddippete» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalaame asuntsappa fete fete, «Un wodhodes koyze atstse hyaya baane? ");
INSERT INTO oydl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yikke, E qoncce ohine; un eza akkon ga7oos. E Kiristtoosa maaqqidanno Ayhude hyalaquntsi turo eresoone? ");
INSERT INTO oydl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kiristtoosa ye7ize wode E abappa yezako ooden eroos, yezin hyay atstse anappa ye7ezako nu erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesuusa Xoozze Keetstsa tamaarssitera fa qaaltto dhoqi yiizii, «Turo yin ta oona yezakon ta abap ye7ezako erane? Taanii ta wolqqara yi7ikaaya, yezin tana kiitteze turii ade; yin eza eroos. ");
INSERT INTO oydl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yezin taanii E kiittin E kaleppa yi7ide gisho eza erane» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yinnii gisho, un eza aykkodes koyda. Yezin Ees wode hyaga yellikaayze gisho ooden eella kushe gaddikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yezin gaama asuntsi Yesuusa ammanii, «Kiristtoosa ye7ize wode hyay atstse oochchize kille bazappa aatsii oochchodaane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisaawunutsi gaama asuntsi Yesuusa baz kalkashizanno si7ida. Kahinunts hyalaquntsin Farisaawunutsi eza aytsii acissades Xoozze keetstsa naagizuntsana kiittida. ");
INSERT INTO oydl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuusa, «Ta yinttara eerats wode gam77oda; yinnippa suuba tana kiittezego qitoda. ");
INSERT INTO oydl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yin tana koyoda, yezin denggaama. Ta yeze bestto yin yo7odes dandda7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayhuduntsi fete fetera, «Hyay nu denggaame bessa aba qitodes yiye? Girike katama bettii yeze Ayhuduntsana hyanggi tamaarssodes qitodaane? ");
INSERT INTO oydl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹Yin tana koyoda, yezin denggaama› mahi, ‹Taanii yeze bessa yin yo7odes dandda7aama› gaazanna akki ga7intte?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ba7ale bonchchize hyal7e qammite Yesuusa denddii, fa qaaltto dhoqi yiizii, «Baridhdhide ooden taago yi7i uzho. ");
INSERT INTO oydl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tana ammanze ooden Geeshi Maxaafta gaydannigaara de7o inggize hyaatsi aafe E giddappa goggane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E yinno gaydanna eza ammanezunts ekkodes yeze Geeshi Ayyaanabaz ohida. Yesuusa hyaga bonchchinttikaayze gisho ye wode Geeshi Ayyaana ingginttikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yentsi asuntsappa gaamuntsi E gaazanno si7i, «Hyay turo yo7oda ga7inttide nabizaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Melluntsi mahi, «Hyay Kiristtoosa» yagayda. Mahin mellunts, «Kiristtoosa Galilappa ye7inene? ");
INSERT INTO oydl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Geeshi Maxaafite, ‹Kiristtoosa Dawute kochchappa Dawute yezide Beeteleme katamappa ye7oda› gaykaane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yinnii gisho, Yesuusa baggara asunts wol gidda shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yentsi asuntsappa fete fete eza aykkodes koyda, yezin ooden eella kushe gaddikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xoozze Keetstsi naagizuntsi kahinunts hyalaquntsagon Farisaawunutsago suub maaqqii yi7in un, «Akkos eza ke7anxxido?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xoozze Keetstsi naagizuntsi unttago, «Hyay atstse ohizanni gaara ooden ohoos» ga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisaawununtsi mahi, «E yinttanan balitstsida? ");
INSERT INTO oydl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ayhude hyalaquntsappa woy Farisaawuntsappa eza ammanide asi yene? ");
INSERT INTO oydl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Muse higge eroosse hyantsi asuntsi tuneezuntsana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisaawuntsappa fete qamma Yesuusago hyanggide Niqodimoosa unttago, ");
INSERT INTO oydl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Fettii asi gaazanno si7ikaayzara woy E akko oochchezako erikaayzara tiino eella firddizanna nu higgite yene?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Un mahi, «Neenin Galila asi? Galila sa7appa nabe kezaamanno Geeshi Maxaafeppa qurichchi ero» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yinnippa suuba fete fete fa kara qitida. ");
INSERT INTO oydl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fete fete ashshii fa kara fa kara qitida, yezin Yesuusa Shamahe dere qitida. ");
INSERT INTO oydl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mahi wonttistti wode gooda Xoozze keetstsa yi7ida. Gaama asuntsi eego yi7in bettii unttana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Higge asttamaaruntsin Farisaawunutsi olalodera aykkide fettii maachito eego ki7ida. Un as ubba tiino izo essi, ");
INSERT INTO oydl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«Asttamaarizayo, hyanna maachita olalodera nu aykkida. ");
INSERT INTO oydl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muse higge hyannii gaarize maachito shuchchara dhogii wodhode gaar kiittane. Yeezin, ne ibaz waage?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Un yinno gaydanna Yesuusa fattanii eza mootodebaz denggodes. Yezin Yesuusa zuggii fa gil7izera sa7alla xaafida. ");
INSERT INTO oydl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Un eza mahi mahi oocii ashshanxin, ude dhoqi ga7i, «Yin gidda nagara oochchikaayze asi tiinii izo shuchchara dhogo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mahin zuggii sa7alla xaafida. ");
INSERT INTO oydl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Un yinno si7ide wode un qoftta un7in cimuntsappa aykkii fete fete kezitera hyal7ida. Yesuusa xalaala yinna besite eqqide maachitira attida. ");
INSERT INTO oydl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","E ude dhoqi ga7i maachitippa melle asi bi7ikaayze wode, «Maachite, mootizunts aba qitido? Neella firddizuntsappa ooden baa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Maachita, «Laatstso, ooden baaya» yagayda. Yesuusa mahi, «Taanin neella firddoos. Qito; mahi nagara oochchippe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mahin Yesuusa asuntsago, «Taanii alames foo7o. Tana kaallize ooden de7o inggize foo7o ekkodap attin dhuma hyanttoos» yaga7i ohida. ");
INSERT INTO oydl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisaawuntsi, «Ne nebaz markkidhane, yezin ne markkatitsita turo baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuusa mahi, «Taanii ta baz markkidhizakon ta markkatitsita turo. Akkos gayko, taanii abappa ye7ezako mahi aba qitizako erane, yezin yin ta abappa ye7izakon mahi aba qitizako eroos. ");
INSERT INTO oydl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yin as qofa gaar firddane; taanii fettii asallan firddoos. ");
INSERT INTO oydl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Taanii firddizebaz maaqqikon ta firddita turo. Akkos gayko, tana kiitteze ta Aday taara yenep attin taanii ta xalaala yezoos. ");
INSERT INTO oydl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lam77i asi markkatitsi turo maaqqizanna yin higgite xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Taanii ta baz ta ommite markkidhane; mahi tana kiitteze ta Aden ta baz markkidhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Un, «Ne aday aba yene?» yagayda. Yesuusa mahi, «Yin tana woy ta Adaya eroos. Tana erizebaz maaqqizako, yin ta Adayan eroda yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuusa Xoozze Keetstsa muxaate bira olize saaxine yeze besite yinno tamaarssida. E qammita hyaga yellikaayze gisho ooden eza aykkikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Mahin Yesuusa unttago, «Ta qitoda; yin tana koyoda, yezin yin yin nagarttira hyayqqoda. Ta qitize bestto qitodes yin dandda7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayhude hyalaquntsi, «E, ‹Ta qitize bestto yin yo7odes dandda7oos› yagayda. E fana faas wodhoda yessane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesuusa mahi, «Yin oomoppa; ta afappa. Yin hyanna alamttippa, ta hyanna alamttippa baaya. ");
INSERT INTO oydl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yin yin nagarttira hyayqqoda ga7i ta yinttis ohidanna yinnis. Taanii Tana maaqqizanno yin ammananxiko yin yin nagarttira hyayqqoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Un, «Ne oode?» yaga7i oocida. Yesuusa mahi, «Taanii, tiinoppa yinttis ohide ezii tana. ");
INSERT INTO oydl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Taanii yin baz ohi firddize gaama baz yene. Yezin tana kiitteze turo; mahi taanii eeppa si7ezanno xalaala alames ohine» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesuusa fa Adebaz ohizanno un tiirikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yinnii gisho, Yesuusa unttago, «Yin As Na7aya ude dhoqi yiize wode Taanii Tana Maaqqizanno yin eroda. Mahin taanii ta adetitsi wolqqara akkon oochchosannon ta Aday tana tamaarssidanno ohizanno yin eroda. ");
INSERT INTO oydl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tana kiitteze taara yene. Ta ubba wode eza ufayssize baz oochchize gisho E tana ta xalaala ashshikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuusa yinno ohodera si7eze gaama asuntsi eza ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuusan fana ammanide Ayhuduntsago, «Yin ta qaaltte yeziko turii ta tamaaruntsana. ");
INSERT INTO oydl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yin turo eroda; turitan yinttana arotitsappa kessoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Un mahi, «Nu Abrahama kochchi; nu oodesin aridhdhikaaya. Ne wayzi, ‹Yin arotitsappa kessada› ga7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuusa mahi, «Ta yinttis turo turo gaane; nagara oochchize ooden nagaras aro. ");
INSERT INTO oydl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aro medhinas kara asara yezoos, yezin na7a medhinas kara asara yezane. ");
INSERT INTO oydl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na7ay yinttana arotitsappa kessiko yin arotitsappa turo kessada. ");
INSERT INTO oydl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yin Abrahama kochchi maaqqizanno ta erane. Yezin ta qaaltta yin gidda baayze gisho tana wodhodes koyane. ");
INSERT INTO oydl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taanii ta Aday tana beezidanno ohine, yezin yinttin yin adeppa be7ezanno oochchane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Un mahi, «Nu aday Abrahama» yagayda. Yesuusa unttago, «Yin Abrahama na7untsana maaqqizako E oochchidanno oochchodyeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yezin Xoozappa si7eze turtto ohide tana yin wodhodes koyane. Abrahama yinnii gaara yiizikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yin, yin aday oochchidanno oochchane» yagayda. Un mahi, «Nuunii olale na7a baaya turii Xoozze na7untsana; nuus fettii Aday Xoozze xalaala yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuusa unttago, «Xoozii turii yinttis aday maaqqizako yin tana kadhodyeshsha; akkos gayko, taanii Xoozze kaleppa yi7ida. Tana E kiittanep attin taanii ta adetits wolqqara yi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ta ohizanno yin si7osanna tiiroso? Ta qaaltto yin si7anxide gisho. ");
INSERT INTO oydl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yin, yin aday Xalahe na7a. Mahin yin, yin aday amudhdhizebaz oochchodes koyane. E tiinoppa aykkii shemppo wodhizaya. Turii E gidda baayze gisho E turo ixxane. Worddo ees yeze baz maaqqide gishon E worddos ade maaqqide gisho worddo ohitera faappa ohine. ");
INSERT INTO oydl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta turito ohine, yezin yin tana ammanoos. ");
INSERT INTO oydl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yinttappa, ‹Ne nagara oochchodera ta bi7ida› gawudes dandda7ize oode? Ta turito ohize baz maaqqiko tana akkos ammanoste? ");
INSERT INTO oydl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xoozze asi maaqqide Xoozii gaazanno si7ine. Yin Xoozze asi maaqqikaayze gisho Xoozii gaazanno si7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayhuduntsi mahi, « ‹Ne Samaara asi; neella tuna ayyaana yene› ga7itera likke nu baane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuusan unttago «Taalla tuna ayyaana baaya. Taanii ta Adaya bonchchane, yezin yin tana leqqane. ");
INSERT INTO oydl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taanii ta bonchcho koyoos; ta bonchchinttode gaar koyzen taas firddize yene. ");
INSERT INTO oydl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ta yinttis turo turo gaane; ta qaaltto naagize ooden hyayqqoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayhuduntsi mahi, «Neella tuna ayyaana yezanno nuunii hyatte erida. Abrahama hyayqqida; nabuntsin hyayqqida. Yezin ne, ‹Ta qaaltto naagize ooden hyayqqoos› yagaane. ");
INSERT INTO oydl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ne hyayqqide nu aday Abrahameppa aadhane? Nabuntsin hyayqqida. Ne nena oona ga7i qoppe?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuusa, «Taanii tana bonchchiko ta bonchchita hyarii. Yin, ‹Nu Xoozza› gaaze ta Aday E tana bonchchane. ");
INSERT INTO oydl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yin eza eranxikon ta eza erane. Ta eza eroos gayko yin fana taanin worddidhdhane. Yezin ta eza erane; mahi E qaaltton naagane. ");
INSERT INTO oydl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Yin aday Abrahama ta ye7ize qammito bi7i ufayttodes amudhdhane; bi7in ufayttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayhuduntsi mahi, «Melle atto yezin, nees ichintam bere kumikaayze wayzi Abrahama bi7ida ga7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuusan unttago, «Ta yinttis turo turo gaane; Abrahama yelinttodannippa tiino Taanii Tana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yinnii gisho, un Yesuusa dhogodes shuchchi ekkida. Yezin Yesuusa unttappa genggii Xoozze keetstsappa kezii qitida. ");
INSERT INTO oydl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuusa hyanggitera yelinttidannippa aafe qooqe maaqqii yeze fettii atstsa bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E tamaaruntsi, «Asttamaarizayo, hyay atstse aafe qooqe maaqqii yelinttode gaar nagara oochchide oode? Ezaane woy eza yeliduntsi oochchido?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuusa, «Xoozze oochita eella qonccode gaarap attin ezii woy eza yeliduntsi nagara oochchide gisho baaya. ");
INSERT INTO oydl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sa7a awara yezin tana kiittide oochito oochchodes beezane. Ooden oochchodes dandda7oosse qamma yo7oda. ");
INSERT INTO oydl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ta alamite yezitera alamttis foo7o» gayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesuusa yinno ga7i sa7alla cuttida. Fa cuchchitira eerats sa7a laakitsii yinna looqitira aafe qooqe atstse aafto tizhida. ");
INSERT INTO oydl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yeyzi, «Hyanggi Salihoome (Salihoome ga7inttizanna Kiitinttidaya ga7e) gaaze teqinttide hyaatsite ne aafto matto» yagayda. Yinnii gisho, atstse hyanggi fa aafto mattii bi7itera maaqqida. ");
INSERT INTO oydl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Dootsuntsin atstse tiino woossodera bi7ide asuntsi, «Hyay bettii woossize atstsa baane?» gayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Fettii fettii asuntsi, «Hyay eza» yagayda. Melluntsi mahi, «Ade, hyayni eza aazanep attin eza baaya» yagayda. Yezin ezin, «Yee, tana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Un eego, «Yeezin ne aafta wayzi bi7ido?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","E mahi, «Yesuusa gaaze atstse looqa laakitsii ta aafto tizhii, ‹Salihoome hyanggi ne aafto matto› yaga7in, ta hyanggi mattii bi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Un eego, «E aba yene?» yaga7i oocida. Atstsay, «Ta eroos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Un aafe qooqe yezara, bi7ide atstsa Farisaawuntsago kanggida. ");
INSERT INTO oydl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuusa looqa laakitsii atstse aafto fatstside qammita Sambbata. ");
INSERT INTO oydl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yinnii gisho, atstse wayzi be7ezako Farisaawuntsi eza mahi oocida. Atstsay unttago, «E ta aafte looqa tizhida, mattii hyatte be7ine» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisaawuntsappa fete fete, «Hyanno oochchide atstse Sambbata higge naagoosse gisho Xoozze kaleppa yi7ikaaya» yagayda. Yezin melluntsi, «Nagaranchcho asi hyannii gaar kille baz wayzi oochchodes dandda7e?» ga7i wol gidda shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yinnii gisho, Farisaawuntsi atstsego, «E ne aafto bugide gisho ne ebazito waage?» yagayda. Atstsay, «E nabe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayhude hyalaquntsi, E intton adayan xeegii oocode wontsis, atstse tiino aafe qooqe maaqqizannon hyatte E be7izanno ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Un E inttigon E adego, «Yin ‹aafe qooqe maaqqii yelinttida› gaaze yin na7ay hyaya? Yeezin, hyatte wayzi bi7ido?» ga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eza yeliduntsi, «Hyay nu na7a maaqqidannon aafe qooqe maaqqii E yelinttidanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yezin hyatte E wayzi be7ezako mahi E aafto oode fatstsezako nu eroos. Eza oocote. E fana shaakkide asi maaqqide gisho fa baz ohodes dandda7ane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Eza yeliduntsi yinno gaydanna Ayhuduntsis zhashtize gisho. Akkos gayko, Ayhuduntsi, Yesuusa E Kiristtoosa yaga7i markkidhize asi yeziko ye atstsa Ayhude woosa keetstsappa bay7odes tiinii zore accida. ");
INSERT INTO oydl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eza yeliduntsi, «E fana shaakkide asi; eza oocote» yagaydanna yinnisi. ");
INSERT INTO oydl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yinnii gisho, qooqe maaqqii yelinttide atstsa un lam7intsa xeegii, «Xoozza bonchcho; hyay atstsay nagaranchcho maaqqidanno nu erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Atstsay mahi, «E nagaranchcho maaqqizanno ta eroos. Ta qooqe maaqqidannon hyatte bi7idanno yinno fettii baz erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Un mahi, «E nees akko baz oochchido? E ne aafto wayzi fatstsido?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","E unttago, «Ta yinttis tiino ohida, yezin yin si7odes koykaaya. Akkos mahi si7odes koye? Yinttin E tamaare maaqqades koyanene?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Un eza cazhiter yagayda, «Ne ye atstse tamaare; nuunii Muse tamaare. ");
INSERT INTO oydl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xoozii Musera ohinttidanno nu erane, yezin hyay atstse E anappa ye7ezakon nu eroos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Atstsay unttago, «E anappa ye7ezako yin erosanna gaama qofize baz, maaqqikon E ta aafto fatstsida. ");
INSERT INTO oydl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xoozzes zhashtizan E koyze baz oochchize atstsa Xoozii si7inep attin nagaranchchuntsana si7oos. ");
INSERT INTO oydl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Salon sa7a medhinttidannippa aafe qooqe maaqqii yelinttide as aafe fatstside ooden baaya. ");
INSERT INTO oydl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hyay atstse Xoozappa maaqqikaayzako fettibazin oochchodes dandda7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Un mahi, «Ne kumutsi medhintte nagarar yelintti diccize nuna tamaarssodes koyane?» yagayda. Eza Ayhude woosa keetstsappa bay7ida. ");
INSERT INTO oydl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuusa un atstsa bale kessidanno si7ide wode eza denggi, «As Na7aya ammanane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Atstsay Yesuusago, «Laatstso, ta eza ammanode gaar E oode? Taas ohoya?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuusa atstsego, «Ne eza bi7ida; hyay neera ohinttize eza» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Atstsay mahi, «Laatstso, ta ammanane» yaga7i Yesuusas goynida. ");
INSERT INTO oydl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuusa, «Qooqunts be7ade gaaran be7izuntsi qooqode gaar taanii firddodes hyanna alamite yi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ezara yeze eerats Farisaawuntsi yinno si7i, «Nu qooqene?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuusa, «Yin qooqe maaqqizako yinttis nagara maaqqoos yeshsha. Yezin hyatte yin be7ine gaaze gisho yin, yin nagarite yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuusa, «Ta yinttis turo turo gaane; duro kales furtstsara maaqqikaayzin melle bessara gelize ooden kayzon faannon. ");
INSERT INTO oydl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yezin furtsara gelize ezii duruntsana yenggizaya. ");
INSERT INTO oydl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Furtsito naagize ees furtsito bugane; duruntsin E qaaltto si7ine. E fa duruntsana un suntsitira suntsitira xeegane; unttana kaalitsi bale kessane. ");
INSERT INTO oydl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","E fa duruntsana ubba bale kessidannippa maaqqii unttap tiinor yedhdhane. Un E qaaltto erize gisho eza kaallane. ");
INSERT INTO oydl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Melle qaala un eroosse gisho eeppa hyaakkanep attin eza kaalloos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuusa unttis hyanna aazizito ohida, yezin E akko ga7ezakon un tiirikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Mahi Yesuusa unttago, «Ta yinttis turo turo gaane; taanii duruntsis furtsi. ");
INSERT INTO oydl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taappa tiino ye7eze ubba kayzon faannop, attin duruntsi unttana si7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Furtsize tana; ta baggara gelize ooden attoda. E ta baggara gelodan kessada; lo77o yengginttize bessi demmada. ");
INSERT INTO oydl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kayzo kaystodes, shukkodesin dhabsodes ye7inep attin mellebazis ye7oos. Ta unttis de7o yessade gaaran gaanggode gaar yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ta lo77o wude ade; lo77o wude adaya fa duruntsi gisho fa shemppito aatsii inggane. ");
INSERT INTO oydl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kira yenggize atstse duruntsis ade maaqqikaayze gisho suudhume ye7ize wode bi7i duruntsana ashshii woxxane. Yinnii gisho, suudhume duruntsana bonqane duruntsin lanttane. ");
INSERT INTO oydl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kira yenggizay miishes yenggize gishon duruntsbaz ees sinttoosse gisho duruntsana ashshii woxxane. ");
INSERT INTO oydl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«Ta lo77o wude ade. Ta Aday tana erzanni fana taanin ta Adaya erane. Yinnii fana, taanii ta duruntsana erane; ta duruntsin tana erane. Taanii ta duruntsi gisho ta shemppito aatsii inggane. ");
INSERT INTO oydl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hyanna kaltte baayze melle duruntsi taas yene. Ta unttana ko7odes beezane. Un ta qaaltto si7oda; un fettii wude maaqqada; yenggizayin fetto. ");
INSERT INTO oydl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Taanii ta shemppito aatsii inggi mahi ekkize gisho ta Aday tana kadhane. ");
INSERT INTO oydl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta qofar ta shemppito aatsii ingganep attin taappa ooden ekkoos. Ta ta shemppito aatsii inggodesin mahi ekkodes adetits wolqqa taas yene. Ta oochchode gaar ta Aday tana kiittezanna hyanno» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yinna E gayde qaaltti gisho Ayhuduntsi gidda mahi dummatitsi medhinttida. ");
INSERT INTO oydl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Unttappa gaamuntsi, «E gidda tuna ayyaana yene! E zhaashitane! E gaazanno akkos si7e?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Melluntsi mahi, «Xalahe aykkide asi ohinttize fana baaya. Xalahe qooqe aafe bugodes dandda7anene?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalaame Xoozze Keetsito geeshide qammito bonchchize ba7ale yellida; sa7ita barggo. ");
INSERT INTO oydl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuusa Xoozze Keetstsa Solomone furtstsara goden hyankka hyanttane. ");
INSERT INTO oydl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayhuduntsi Yesuusa kale eqqii, «Ne nuna ayde yellodes so7era gam7isade? Ne Kiristtoosa maaqqiko ane nuus geeshi oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuusa mahi unttago, «Ta yinttis ohida; yezin tana ammananxida. Taanii ta Aday suntsite oochchize oochita ta baz markkidhane. ");
INSERT INTO oydl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yezin ta yinttis ohidanni gaara yin ta duro maaqqikaayze gisho ammananxida. ");
INSERT INTO oydl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta duruntsi ta qaaltto si7ine. Ta unttana erane; unttin tana kaallane. ");
INSERT INTO oydl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ta unttis medhina de7o inggane; un mulon dhaboos. Ooden ta kushtippa unttana bonqoos. ");
INSERT INTO oydl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Unttana taas inggide ta Aday ubbappa aadhane Ooden ta Aday kushtippa unttana bonqii ekkodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Taanin ta Adayin fetto» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayhuduntsi Yesuusa dhogodes mahi shuchchi dentsida. ");
INSERT INTO oydl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesuusa unttago, «Taanii oochchode gaar ta Aday taas inggide gaama lo77o oochito yinttana oochchii beezida. Yentsesappa aaye gisho tana shuchchara dhogodes koye?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayhuduntsi mahi, «Nu nena ne lo77o oochiti gisho shuchchar dhogodes koyoos. Yezin ne Xoozza cazhize gishon as maaqqitera ne nena Xooz mahize gisho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuusa mahi, «Yin higgite, ‹Ta, Yin xoozuntsana gayda› ga7i xaafinttika? ");
INSERT INTO oydl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Geeshi Maxaafe medhinas laaminttoos. Xoozii fa qaaltto inggide asuntsana, ‹xoozuntsana› ga7i xeegiko, ");
INSERT INTO oydl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aday doorii anjjii hyanna alamite kiittide tana ‹Xoozze Na7a› gayde gisho wayzi ‹Xooz cazhane› yaga7e? ");
INSERT INTO oydl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taanii ta Aday oochchizanno oochanxiko tana ammanippete. ");
INSERT INTO oydl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yezin taanii oochchiza maaqqiko yin tana ammananxikon, ta Aday ta gidda yezannon taanin ta Aday gidda yezanno yin erode gaar qoppode gaar ta oochito ammanote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yikke mahi un eza aykkodes koyda, yezin E un kushtippa kezida. ");
INSERT INTO oydl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wahannisa tiino xammaqize besite, Yorddaanosa borkkappa seko fintsa Yesuusa fiinggi yeyga yezida. ");
INSERT INTO oydl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gaama asuntsi Yesuusago yi7i, «Wahannisa melle atto yezin fettii kille bazin oochchikaaya, yezin E hyay atstsebaz ohidanna ubba turo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ize gaama asuntsi Yesuusa ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bitaaniya guta Alaazare gaaze fettii asi hyargginttida. Bitaaniya Mayramiran I mishta Martta yeze sa7a. ");
INSERT INTO oydl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mayrama Laatstse tohitilla shitto tizhii fa ommitira E tohito uccidanno. Hyargginttize I ishe Alaazare. ");
INSERT INTO oydl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yinnii gisho, mishuntsi, «Laatstso, ne kadhize nu ishe hyargginttida» ga7i Yesuusago kiittida. ");
INSERT INTO oydl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuusa yinno si7ide wode «Hyanna hyarggita, Xoozze Na7ay bonchchitode gaaran Xoozze bonchchosp attin hyayqos yeltsize hyargge baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuusa Marttan, I mishito Mayramon Alaazaren kadhane. ");
INSERT INTO oydl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yezin Alaazare hyargginttidanno Yesuusa si7i fa yeze besite lam77i qamma aqida. ");
INSERT INTO oydl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yinnippa maaqqii, Yesuusa fa tamaaruntsago, «Maaqqii Yihuda sa7a yedhdhote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E tamaaruntsi mahi, «Asttamaarizayo, eerats wodeppa tiino Ayhuduntsi nena shuchchar dhogii wodhodes koyda; hyatten ize hyanggodane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuusa, «Fettii awa taphpho lam77i saate baane? Awarara yedhdhize asi hyanna alame foo7ito be7ize gisho dhubinttoos. ");
INSERT INTO oydl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yezin qamma yedhdhize ooden foo7o baayze gisho dhubinttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuusa yinno gaydannippa maaqqii unttago, «Nu kadhize Alaazare genttida, yezin eza dentsodes ta hyammada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E tamaaruntsi mahi, «Laatstso, E genttezebaz maaqqiko denddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuusa Alaazare hyayqqidanno ohida, yezin unttis cer gentto aazida. ");
INSERT INTO oydl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yinnii gisho, Yesuusa geeshi unttago, «Alaazare hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yin ammanode fana ta yinna besite baayzanna yin gisho ufayssane. Ane yedhdhote; eego hyammada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yinnippa maaqqii, Didimoosa ga7inttize Toomaasa fa lagge tamaaruntsago, «Eera hyayqqodes nuusin yedhdhote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuusa yellize wode Alaazare mooginttin oyddii qamma maaqqida. ");
INSERT INTO oydl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaaney Yerusalaameppa hyaydzdzii kilo mitire gaar hyaakkane. ");
INSERT INTO oydl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Gaama Ayhudunts Marttan Mayramon un ishe hyayqqidannis mintsitsodes yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martta Yesuusa yi7idanno si7i eza mokkodes kezida, yezin Mayrama keetstsa attida. ");
INSERT INTO oydl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martta Yesuusago, «Laatstso, ne hyanne yeze baz maaqqizako ta ishe hyayqaamyeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yezin hyatte maaqqikon ne woossize baz Xoozii nees inggodanno ta erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuusa, «Ne ishe hyayqoppa denddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martta eego, «Wurssutsi qamma E hyayqoppa denddodanno erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesuusa iigo, «Taanii denddon de7on; tana ammanze ooden hyayqikon de7o yessada. ");
INSERT INTO oydl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Mahi de7o maaqqiden tana ammanze ooden medhinas hyayqqoos. Yinno ne ammanane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martta mahi, «Laatstso, yee ta ammanane! Ne Xoozze Na7a, alame yo7odes yeze Kiristtoosa maaqqidanno ta ammanane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martta yinno gaydannippa maaqqii, hyanggi fa mishto aachintti xeegii, «Asttamaarize yi7i nena xeegane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mayrama yinno si7ide wode ellisii denddii eqqii Yesuusago hyanggida. ");
INSERT INTO oydl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ye wode Yesuusa Marttara yellinttide besite yene; hyaga kara gancce yellikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mayramo mintsitsiter iira keetstsa yeze Ayhuduntsi, iza denddii eqqii ellisii bale kezidanno bi7i, booza hyanggi yeekkodes yi7iza aazin izo kaallii kezida. ");
INSERT INTO oydl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayrama Yesuusa yeze besito hyanggi eza bi7ide wode E tohitilla gol7i, «Laatstso, ne hyanne yeze baz maaqqezako ta ishe hyayqqaam yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuusa Mayramiran iira yeze, Ayhuduntsi yeekkizanno bi7i, fa wozintte gaama yiqsinttii, ");
INSERT INTO oydl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«Aba moogido?» ga7i oocin, «Laatstso, yi7i bo7o» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuusa afuxxida. ");
INSERT INTO oydl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yinnii gisho, Ayhuduntsi, «E Alaazare akko gaar kadhezako bo7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yezin unttappa fete fete, «Hyay qooqize aafto bugide hyay atstse hyayqqaame gaar yissades dandda7oso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mahi Yesuusa yiqsinttii, Alaazare mooginttide boozttigo hyanggida. Boozttan shuchchara keellinttide wom7o. ");
INSERT INTO oydl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesuusa, «Shuchchito dentstsote» yagayda. Martta, «Laatstso, E hyayqqidannippa hyayno oyddii qamma maaqqide gisho hyatte zeeqqoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesuusa Marttago, «Ne ammanzebaz maaqqiko Xoozze bonchcho bo7odanno ta nees ohika?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Un boozitilla yeze shuchchito dentsin Yesuusa salo ude bi7i, «Adayo, tana ne si7eze gisho nena galatane. ");
INSERT INTO oydl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne ubba wode tana si7izanno ta erane. Yezin hyanne eqqide asuntsi ne tana kiittezanno ammanode gaar ta un gisho hyanno gaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuusa yinno gaydannippa maaqqii, fa qaaltto dhoqi yiizii, «Alaazare, ude kezo!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hyayqqide atstse ziidhinttidannira kushitan tohito shalora acinttii yezin E aafta goozinttidannira boozttippa kezida. Yesuusa unttana, «Billote! Yedhdho ga7o!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yinnii gisho, Mayramigo yi7ide Ayhuduntsappa gaamuntsi Yesuusa oochchidanno bi7i eza ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yezin unttappa fete fete Farisaawuntsago hyanggi Yesuusa oochchidanno unttis ohida. ");
INSERT INTO oydl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yinnippa maaqqii, kahinunts hyalaquntsin Farisaawuntsi shanggos shiishii, «Hyay atstse gaama kille baz oochchize gisho nu akko oochcho? ");
INSERT INTO oydl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu eza cer ashshiko asi ubba eza ammanoda. Mahi Roome sa7a asuntsi yi7i nu Xoozze Keetsiton nu bagguntsana dhabsoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Unttappa fete Qayyaafa gaaze, yinna berite kahinunts hyalaqa maaqqide, «Yin akkon eroos! ");
INSERT INTO oydl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Worzha ubba dhabodannippa fettii asi worzhiti gisho hyayqqodanna lo77o maaqqizanno erosa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","E yinno faappa gaykaaya. Yezin yinna berite kahinunts hyalaqa maaqqide gisho Yesuusa Ayhude asunts gisho hyayqqodes beezanno tinbbite ohida. ");
INSERT INTO oydl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mahi Yesuusa Ayhude asuntsi xalaalas maaqqikaayzin lalinttii yeze Xoozze as ubba fettilla shiishodesin fettii asi mahodes hyayqqoda. ");
INSERT INTO oydl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Yinna qammitippa aykkii un eza wodhodes zorinttida. ");
INSERT INTO oydl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yinnii gisho, Yesuusa Ayhuduntsi gidda qoncce bessa hyanttikaaya. Yezin akko baayze sa7a kale yeze Efreeme guta qitida. Fa tamaaruntsara yinna besite gam7ida. ");
INSERT INTO oydl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayhuduntsi bonchchize Faasiga qamma ukkida. Mahi gaama asuntsi fana geeshodes Faasiga bonchchize qamma yellodannippa tiino yinna sa7itippa Yerusalaame qitida. ");
INSERT INTO oydl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Un Xoozze Keetstsa eqqii Yesuusa ye7ito naagize gisho «Akko qoppe? Yesuusa ba7ale bonchchodes ye7am yessane?» yaga7i fete feta oocida. ");
INSERT INTO oydl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kahne hyalaquntsin Farisaawuntsi Yesuusa aykkodes, E yeze bestto erize ooden faas mallode fana kiittida. ");
INSERT INTO oydl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Faasiga bonchchize izipun qammappa tiino, Yesuusa hyayqoppa dentstside Alaazare yeze guta, Bitaaniya hyanggida. ");
INSERT INTO oydl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yinna besite un ees kawo giigizida. Alaazare Yesuusara wolla leematella bettezin Martta unttis kiitinttane. ");
INSERT INTO oydl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mayrama narddoosa gaaze gaama al77o geeshi shitto ki7i Yesuusa tohitilla gussida. Fa ommitira E tohito uccida; keetsite ubba shitto sawora tonkku gayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yezin Yesuusa tamaaruntsappa fete, Yesuusa aatsii inggodes yeze, Asqorootu Yihuda, ");
INSERT INTO oydl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Hyanna shittita hyaydzdzii xeet dinaares bayzinttii, miishita dahuntsis ingginttosa?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","E kayzo maaqqide gisho yinno gaydap attin dahas yiqsinttii gaykaaya. E bira aykkiza maaqqide gisho ubba wode iippa faas ekkane. ");
INSERT INTO oydl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesuusa, «Iza faas yeze baz ta mooginttize qammas minjjide gisho izo ashshii ashshote. ");
INSERT INTO oydl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Dahuntsi ubba wode yinttara yessada, yezin ta ubba wode yinttara yezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ye wode gaama asuntsi Yesuusa Bitaaniya yezanno si7i ize yi7ida. Un Yesuusa xalaala maaqqikaayzin E hyayqoppa dentside Alaazaren be7ades yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Yinnii gisho, kahinunts hyalaquntsi Alaazaren gujjii wodhodes zorinttida. ");
INSERT INTO oydl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Akkos gayko, Alaazare baggara gaama Ayhuduntsi unttana ixxii Yesuusa ammanze gisho. ");
INSERT INTO oydl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wonttisti wode Faasiga bonchchize besite ye7ize gaama asuntsi Yesuusa Yerusalaame yi7izanno si7i, ");
INSERT INTO oydl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Qiile hyaye ekkii eza mokkodes kezida. Un fa qaaltto dhoqi yiizii, «Hosaana! Laatstse suntsite ye7ize! Isra7eele Kaati anjjintto!» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Geeshi Maxaafite, «Xiyoone katamite, zhashtippe! Yikke, ne Kaatize hyare na7alla bettii yi7ida» gaynttidanni fana Yesuusa hyare na7a denggi eza toggida. ");
INSERT INTO oydl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesuusa tamaaruntsi yinno tiino tiirikaaya. Yezin Yesuusa bonchchinttidannippa suuba un yinno ubba tiirida. Yinna ubba Geeshi Maxaafta gaydannigaara hyanida. ");
INSERT INTO oydl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesuusa Alaazare boozappa xeegii, hyayqoppa dentside wode eera yeze gaama asuntsi Yesuusa baz markkidhida. ");
INSERT INTO oydl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gaama asuntsi eza mokkodes kezide, E yinna kille bazito oochchezanno si7ide gisho. ");
INSERT INTO oydl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yinnii gisho, Farisaawuntsi fete fetego, «Nu akkon oochchodes dandda7oosanno bo7ote; worzhita ubba eza kaallida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Faasiga bonchchize wode goynodes Yerusalaame hyanggezunts gidda fettii fettii Girike asuntsi yene. ");
INSERT INTO oydl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Unttin Galila sa7a Beetesayda katamappa yi7ide Filphoosago yi7i, «Laatstso, nuunii Yesuusa be7ades koyane» yaga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filphoosa hyanggi Inddiriyases ohin lam77untsi hyanggi, Yesuusas ohida. ");
INSERT INTO oydl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesuusa unttago, «As Na7ay, bonchchinttize wode yellida. ");
INSERT INTO oydl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta yinttis turo turo gaane; fettii zarga aafe sa7a wodhdhii dolanxiko faas attane. Yezin ye zarga aafize doliko gaama aafe aafane. ");
INSERT INTO oydl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Fa shemppito kadhize ooden dhabssane; fa shemppito hyanna alamite ixxize ooden medhina de7oos naagane. ");
INSERT INTO oydl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ta yeze besite taara yessade gaar taas oochchodes koyeze ooden tana kaallodes beezane. Taas oochchiza oonan ta Aday bonchchoda. ");
INSERT INTO oydl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Hyatte ta shemppita gaama un77inttida; yeezin waago? ‹Ta Adayo, tana hyanna saattippa ashsho› yagawune? Ade, ta yi7idanna hyanna madha saatis. ");
INSERT INTO oydl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta Adayo, ne suntsito bonchcho» yagayda. Ye wode saloppa, «Taanii ta suntsito bonchchida; mahin bonchchoda» yagaaze qaala yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yinna besite eqqide gaama asuntsi yinna qaaltto si7i, «Yinna dada dhoge» yagayda. Melluntsi mahi, «Kiitanchcho ees ohida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuusa mahi unttago, «Hyay ootsize yin gisho yi7idap attin ta gisho baaya. ");
INSERT INTO oydl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hyanna alamita firddinttize wodita hyatte; hyanna alamito ahize kaatize hyatte bale olinttoda. ");
INSERT INTO oydl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Mahi ta sa7appa dhoqi dhoqi gayde wode as ubba taago ko7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E yinno gaydanna akko gaar hyayqo hyayqqodyezako unttis qonccissades. ");
INSERT INTO oydl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Gaama asuntsi mahi, «Nu higgita Kiristtoosa medhina yezanno ohine. Yeezin, ne waaga7i, ‹As Na7ay dhoqi dhoqi gawudes beezane› ga7e? ‹E, As Na7ay oode?› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesuusa, «Foo7o yinttara eerats wode gam77oda. Yinttis dhumaame gaar foo7o yezin, foo7ite hyanttote. Dhuma yedhdhize asi ana qitizako eroos. ");
INSERT INTO oydl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Foo7o na7untsana maaqqade gaar foo7o yezin foo7iza ammanote» yagayda. Yesuusa yinno ohidannippa maaqqii hyanggi unttappa genggida. ");
INSERT INTO oydl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E yinnii fana kille baz un tiino oochchinin ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nabe Isayaasa, «Laatstso, nu markkatitsito oonii ammanide? Laatstse fa wolqqito oos qonccizido?» Gaydanna turo maaqqade fana un eza ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Mahin Isayaasa, «un aafta be7aame gaar, un wozintta tiiraame gaar, un Xoozago maaqqin, E unttana fatstsaame gaar, Xoozii un aafto qooqizida. Un wozintta minggida» gayde gisho un ammanodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayaasa yinno gaydanna, Yesuusa bonchchito bi7ide gishone ebazin ohide gisho. ");
INSERT INTO oydl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Maaqqikon, Ayhude hyalaquntsappa gaamuntsi Yesuusa ammanida. Yezin Farisaawuntsi fana Ayhuduntsi woosa keetstsappa kessoda ga7i zhashtide gisho ammanida ga7i qoncce markkidhikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yinno un oochchide, Xoozze bonchchoppa aadhii as bonchcho kadhide gisho. ");
INSERT INTO oydl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuusa fa qaaltto dhoqi yiizii, «Tana ammanze ooden tana kiittezan ammananep attin tana xalaala ammanoos. ");
INSERT INTO oydl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tana be7ize ooden tana kiittezan be7ine. ");
INSERT INTO oydl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tana ammanze ubba dhuma yezaame fana ta foo7o maaqqii alame yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta qaaltto si7i kiitinttoosa oonan ta firddoos. Akkos gayko, ta alamito ashshodes yi7idap attin firddodes yi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tana ixxizayan ta qaaltto ekkoossa oonan firddize yene. Ta ohide qaaltta wurssutsi qamma ye atstsa firddoda. ");
INSERT INTO oydl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Akkos gayko, ta yinno taappa ohoos, yezin tana kiitteze ta Aday ta gawudannon ohodanno kiittida. ");
INSERT INTO oydl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mahi E kiittan medhina de7o maaqqidanno ta erane. Yinnii gisho, ta ohizanna ta Aday taas ohidanno» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Faasiga bonchchize qammita yellodannippa tiino hyanna alamito ashshii Adego qitize wode yellidanno Yesuusa erane. Hyanna alamite yeze fa asuntsana ubba wode kadhane; wurssutsi yellodes unttana kadhane. ");
INSERT INTO oydl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesuusaran E tamaaruntsara wolla kawo muune. Yinnippa tiino Xalahe Simoona na7a Asqorootu Yihuda Yesuusa aatsii inggodegaara E wozintte iita qofa gaddida. ");
INSERT INTO oydl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuusa Aday ubbabazito E kushite gaddidanno, E Xoozze kaleppa yi7idannon maaqqii eego uddodanno erane. ");
INSERT INTO oydl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesuusa kawoppa denddii kattara yeze ma7ito qaarii gaddii, afula lodo ekkii fa qazintte danccida. ");
INSERT INTO oydl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yinnippa maaqqii, hyaatsi gabate faqii, fa tamaaruntsi tohito meeccida; mahi fa qazintte danccide afula lodora uccida. ");
INSERT INTO oydl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesuusa Simoon Phexiroosago yellide wode Phexiroosa, «Laatstso, ne ta tohito meeccodaane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesuusa mahi eego, «Ta oochchizanno ne hyatte eroos, yezin suubappa tiiroda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yeezin, Phexiroosa, «Ne ta tohito medhinas meecaama» yagayda. Yesuusa eego, «Ta ne tohito meeccanxxiko neesin taas fettetitsi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Phexiroosa Yesuusago, «Laatstso, yeezako, ta tohito xalaala maaqqikaayzin ta kushiton ta ommiton ubba meecco» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuusa mahi, «Galla mattinttide ooden toheppa mellebaz mattinttodes beezoos; ees ubba galtta geeshi. Yin geeshi, yezin ubbuntsi geeshi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesuusa fana aatsii immade atstse oona yezako erize gisho «Yin ubbuntsi geeshi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Un tohito meeccidannippa maaqqii Yesuusa fa ma7ito mahi ma77ida. Maaqqii un gidda bettii unttago, «Taanii yinttis oochchidanno tiirane? ");
INSERT INTO oydl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yin tana asttamaaren Laatstsin gaane; taanii yin gaazanni fana maaqqide gisho lo77o gayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ta yinttis Laatstsin asttamaare maaqqitera yin tohito meecciko yinttin fete fetes yinnii gaara oochchodes beezane. ");
INSERT INTO oydl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yikke, ta yinttis oochchidanni gaar yinttin oochchode gaar ta yinttis aazize inggida. ");
INSERT INTO oydl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta yinttis turo turo gaane; aro fa laatstseppa, kiitinttizen kiittideppa aadhoos. ");
INSERT INTO oydl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yin yinno erii oochchiza maaqqiko anjjinttiduntsana. ");
INSERT INTO oydl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Ta yin ubbuntsana ga7oos; ta dooriduntsana ta erane. Yezin Geeshi Maxaafite, ‹Ta booriza muyde taalla denddida› ga7inttidanna turo maaqqades beezane. ");
INSERT INTO oydl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Taanii tana maaqqizanno yin ammanode gaar yinna hyanodannippa tiino yinttis ohine. ");
INSERT INTO oydl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ta yinttis turo turo gaane; ta kiittide atstsa mokkize tana mokkane. Tana mokkize ooden tana kiitteza mokkane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuusa yinno ohidannippa maaqqii fa wozintte gaama un77intti, «Ta yinttis turo turo gaane; tana yinttappa fete aatsii inggoda» ga7i qonccizi ohida. ");
INSERT INTO oydl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","E ohidanna tamaaruntsis erinttanxin wol bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","E tamaaruntsappa fete, Yesuusa kadhize, Yesuusa kale bettida. ");
INSERT INTO oydl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yinnii gisho, Simoon Phexiroosa eza mallii, «E oona gaazako ane ooco» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yinnii gisho, ye tamaarize Yesuusago shiiqii, «Laatstso, E oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuusa mahi, «Ta boora baxxi tushii baarsizaya» yagayda. Mahin boora baxxi ekkii, tushii, Simoona na7ays Asqorootu Yihudas inggida. ");
INSERT INTO oydl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yihuda booriza baaridannippa maaqqii Xalahe iira Yihuda gidda gelida. Yesuusa eego, «Ne oochchodes qoppezanno ellisii oochcho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yezin betteezuntsappa ooden Yesuusa yinno akkos eego ga7ezako erikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yihuda bira aykkize gisho eza tamaaruntsappa fete fete Yesuusa eza, «Faasiga bonchchize qammas faas beezize baz wonggo woy dahuntsi muxaate inggo gayda» yaga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yihuda booriza ekkide fana iira bale kezida. Ye wode sa7ita qamma. ");
INSERT INTO oydl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yihuda bale kezidannippa maaqqii, Yesuusa, «Hyatte As Na7ay bonchchinttida; Xoozin E baggara bonchchinttida. ");
INSERT INTO oydl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xoozii E baggara bonchchinttin E fa ommite As Na7aya bonchchoda; mahi E yinno ellisii yiissada. ");
INSERT INTO oydl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta na7untso, ta yinttara gaama wode gam77oos. Yin tana koyoda, yezin ta Ayhuduntsis ohizanni gaar, ‹Yin taanii qitide bestto yo7odes dandda7oos.› ");
INSERT INTO oydl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ta yinttis inggize kille kiitta hyanno; fete feta kadhote. Ta yinttana kadhidannifana yin fete feta kadhodes beezane. ");
INSERT INTO oydl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Yin fete fetera kadhinttiko yin ta tamaaruntsana maaqqizanno asi ubba yinne eroda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoon Phexiroosa Yesuusago, «Laatstso, ne aba qite?» yagayda. Yesuusa mahi, «Ta qitize bessa ne hyatte kaallodes dandda7oos, yezin suubappa tana kaalloda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phexiroosa, «Laatstso, ta nena hyatte kaallodes akkos dandda7osa? Ta ne gisho hyayqqodesin giigii bettida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesuusa mahi, «Ta gisho hyayqqodes turo giigii bettida? Ta nees turo turo gaane; lukule uukkodannippa tiino ne tana hyaydzdzii tohe kaddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuusa fa tamaaruntsago, «Yin wozintta yirggippe, Xoozza ammanote, tanan ammanote. ");
INSERT INTO oydl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Aday keetstsa gaama bessi yene. Ta yinttis bessi giigissades qitane. Yinna baayzako ta yinttis ohod yeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta uddii bessi giigizidannippa suuba ta yeze besite yin yessade gaar lam7intsa yi7i yinttana taago ekkoda. ");
INSERT INTO oydl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yin ta qitize besiton ogito erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yeezin, Toomaasa, «Laatstso, ne qitize bestto nu eroos; ogito wayzi erodes dandda7ode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuusa mahi, «Oge, turon de7on tana. Ta baggara maaqqanxiko ooden ta Adego yo7odes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yin tana erizako, ta Adayan eroda. Yezin yikkeppa aykkii yin eza eranen eza bi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filphoosan Yesuusago, «Laatstso, Adaya nuna beezzako; nuus maaqqada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuusan mahi, «Ta hyannii gaarize wode yinttara yezin tana erosite? Tana bi7ide atstse Adayan bi7ida. Yeezin, ne wayzi, ‹Adaya nuna beezo› ga7e? ");
INSERT INTO oydl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taanii Adera fetto maaqqidannon Aden taara fetto maaqqidanno ne ammanosane? Ta yinttis ohize qaaltto ta taappa ohoos, yezin ta gidda yeze Aday E fa oochito oochchane. ");
INSERT INTO oydl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taanii Aday gidda yezannon Aden ta gidda yezanno ammanote. Yinno ammananxiko ta oochite tana ammanote. ");
INSERT INTO oydl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Ta yinttis turo turo gaane; tana ammanze atstse ta oochchize oocha E oochchoda. Ta Adego qitize gisho tana ammanze ooden hyannippa aadhize oocha oochchoda. ");
INSERT INTO oydl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aday Na7ay baggara bonchchinttode fana ta suntsite yin woossize baz ubba ta yinttis yiissada. ");
INSERT INTO oydl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ta suntsite akko bazin yin oociko ta yinttis oochchoda. ");
INSERT INTO oydl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Yin tana kadhiko ta kiitto naagote. ");
INSERT INTO oydl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Taanii ta Adaya woossoda; yinttara medhina yessade gaar mintsitsiza yinttis inggoda. ");
INSERT INTO oydl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ye Ayyaanize Xoozze turo beezane. Hyanna alamite asuntsi eza bi7ikaayze gishon eroosse gisho eza ekkodes dandda7oos. Yezin E yinttara yeze gishon yin gidda yessade gisho yin eza erane. ");
INSERT INTO oydl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Ta yinttana inddan aden baayze na7a gaar yin xalaala ashshoos; maaqqii yinttago yo7oda. ");
INSERT INTO oydl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Eeratsi wodeppa suuba alame tana mahi bo7oos, yezin yin bo7oda. Ta de7o maaqqide gisho yinttin de7o yessada. ");
INSERT INTO oydl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta ta Aday gidda, yin ta gidda, mahi ta yinttara yezanno yin ye wode eroda. ");
INSERT INTO oydl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Ta kiitto ekkii naagize tana kadhane. Tana kadhizaya ta Aden kadhane; taanin eza kadhane; taanin tanatitsito yinttis qonccisada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asqorootu Yihuda maaqqikaayze Yihuda Yesuusago, «Laatstso, ne wayzi alames maaqqikaayzin nuus nena qonccissade?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesuusa mahi, «Tana kadhize ooden ta qaaltto naagoda. Ta Aday eza kadhoda. Eego nu yo7oda. Eera yessada. ");
INSERT INTO oydl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tana kadhoosse ooden ta qaaltto naagoos. Yin si7ize qaaltta tana kiittide Ade bazep attin ta baz baaya. ");
INSERT INTO oydl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«Ta yinttara hyatte yeze gisho yinno yinttis ohida. ");
INSERT INTO oydl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yezin Aday ta suntsite kiittize mintsitsize Geeshi Ayyaana, yinttana ubbabazito tamaarssoda. Ta yinttis ohidanno ubba E yinttana qofissada. ");
INSERT INTO oydl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Saro yinttis ashshoda. Taanii ta sarito yinttis inggoda. Ta inggize sarotitsita alame inggize sarotitsiti fana baaya. Yinnii gisho, yin wozintta yirggippen, zhashtippe. ");
INSERT INTO oydl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹Ta qitoda, yezin maaqqii yinttago yo7oda› gaydanno yin si7ida. Yin tana turo kadhizebaz maaqqiko ta Aday taappa aadhize gisho ta eego qitizanne yin ufayttoda. ");
INSERT INTO oydl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yinna yiize wode yin ammanode gaar yinna hyanikaayzin tiino ta yinttis ohida. ");
INSERT INTO oydl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","«Hyanna alamito ahize ye7ize gisho yikkeppa suuba yinttara gaama ohinttoos. Tana E akkon oochchodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yezin ta Adaya kadhizanno alame erode gaar ta Aday tana kiittezanno ubba yiissada. Denddote; hyannippa yedhdhote. ");
INSERT INTO oydl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ta woynes turii uzuma, wootizen ta Adaya. ");
INSERT INTO oydl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta gidda yeze aafe aafoosse tashito ubba E gachchii hyaasoda. Aafize tashito kasennippa gaantsi aafode fana yinna tashito E koshii giigissada. ");
INSERT INTO oydl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta yinttis ohide qaaltti gisho yin geeshi. ");
INSERT INTO oydl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ta gidda yezote; taanin yin gidda yessada. Woynes tashe uzumzella yezanxiko ye tashize fa faas aafe aafodes dandda7oos. Yinnii fana, yinttin ta gidda yezanxiko aafe aafodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Taanii woynes uzuma; yin tashe. Taalla yezen taanin E gidda yeze, E gaama aafe aafoda. Ta baayzin yin xalaala akkon oochchodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Taalla yezoosse tashe fana alla olintti meloda. Yinnii fana tashuntsan shiishii tama oloda, michchoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yin taar yeziko, ta qaalttan yinggida yeziko, yin koyze baz akko maaqqikon woossote; yin ekkoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yin gaama aafe aafize ta tamaaruntsana maaqqiko, yinne ta Aday bonchchinttoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aday tana kadhizanni gaara taanin yinttana kadhane; ta siiqite yezote. ");
INSERT INTO oydl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Taanii ta Aday kiitto naagii E siiqite yezidannigaara yinttin ta kiitto naagiko ta siiqite yessada. ");
INSERT INTO oydl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Ta ufayssita yinggida folinttode fanan yin ufayssita folo maaqqade fana ta yinttis yinno ohida. ");
INSERT INTO oydl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ta kiitta hyanno; ta yinttana kadhizanni fana yinttin fete feta kadhote. ");
INSERT INTO oydl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Fa shemppito fa lagguntsis inggizannippa aadhize damma siiqo baaya. ");
INSERT INTO oydl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ta yinttana kiittidanno ubba oochchiko yin ta lagguntsana. ");
INSERT INTO oydl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","«Aro fa laatstsay oochchizebaz eroosse gisho ta yinttana yikkeppa maaqqii aruntsana ga7oos. Yezin ta Adaya si7ize ubba ta yinttis ohide gisho yinttana ta lagguntsana gayda. ");
INSERT INTO oydl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ta yinttana dooridap attin yin tana doorikaaya. Yin hyanggi aafe aafode fanan aafera yin yessade fana shuumida. Yinno maaqqiko ta Aday yin ta suntsitira woossidebaz ubba inggoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ta kiitta hyanno: fete feta kadhote. ");
INSERT INTO oydl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Alame yinttana ixxiko tiino tana ixxidanno erote. ");
INSERT INTO oydl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Yin alamebaz maaqqizako alame fa baz fana yinttana kadhodyeshsha. Yezin ta yinttana alameppa dooride gishon yin alamebaz maaqqikaayze gisho alame yinttana ixxane. ");
INSERT INTO oydl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹Aro fa laatstseppa aadhoos› ga7i ta yinttis ohidanno qoppote. Un tana bay7izebaz maaqqiko yinttanan bay7oda. Un ta qaaltto naagezebaz maaqqiko yin qaaltton naagoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yezin un tana kiittezaya eroosse gisho hyanno ubba ta gisho yinttalla oochchoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ta yi7i ohikaayzako unttis nagara maaqqamyeshsha. Yezin hyatte un oochchide nagarttis miknaate baaya. ");
INSERT INTO oydl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tana ixxize ta Adayan ixxane. ");
INSERT INTO oydl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ooden oochchikaayze oocha ta un gidda oochchii bi7ikaayze baz maaqqizako unttis nagara maaqqamyeshsha. Yezin hyatte un ta oochchide oochchito bi7i tanan ta Adayan ixxida. ");
INSERT INTO oydl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yezin un higgite, ‹Tana hyarii ixxida› ga7intti xaafinttidanna folinttode fana yinna yii7ida. ");
INSERT INTO oydl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Adeppa ye7ize turii Ayyaana ta yinttis kiittoda. E yinttana mintsitsoda, ta baz markkidhoda. ");
INSERT INTO oydl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yinttin tiinoppa aykkii taara yeze gisho ta baz markkidhoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Ta yinno yin ammanttippa dhubinttaame fana yinttis ohida. ");
INSERT INTO oydl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Un yinttana Ayhude woosa Keetstsappa kessoda. Yinnippan aadhii, yinttana wodhize ooden Xoozii koyze baz oochchiza aazize wode ye7oda. ");
INSERT INTO oydl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Un yinno yinttalla oochchize tana woy Adaya erikaayze gisho. ");
INSERT INTO oydl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yezin un yinno yinttalla oochchize wodita yellide wode ta yinttis ohidanno yin qoppode gaar ta yinttis hyanno ohida. «Tiino ta hyanno yinttis ohikaayzara gam7idanna ta yinttara yeze gisho. ");
INSERT INTO oydl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yezin hyatte taanii tana kiittezego qitane; yinttappa ooden, ‹Aba qite?› ga7i tana oocize baaya. ");
INSERT INTO oydl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yezin ta yinno ohide gisho yin wozintte gaama kayo qofara kumida. ");
INSERT INTO oydl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Yezin ta yinttis turo ohine; ta qitizako yinttis lo77o. Akkos gayko, ta qitanxiko mintsitsize yinttago ye7aama. Yezin ta qitiko eza yinttago dakkoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mintsitsize yi7i, nagaras, xillotitsisin firddas hyanna alame asuntsana oocoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nagaras, asuntsi tana ammanoose gisho. ");
INSERT INTO oydl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Xillotitsis, ta Adego qitize gishon yin tana mahi be7aame gisho. ");
INSERT INTO oydl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Firddas, mahi alamito ahize firddinttide gisho. ");
INSERT INTO oydl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Ta yinttis ohode gaama baz yene, yezin hyatte yinttana deexxoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Turii Ayyaana yi7ide wode yinttana turetits ubbago kaalitsoda. E si7idebaz ohodap attin faappa akko bazin ohoos. Mahi tiinoppa ye7odebaz yinttis E ohoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","E taas yezannippa ekkii yinttis ohize gisho E tana bonchchoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ades yeze baz ubbanna ta baz; ‹Mintsitsize taas yezannippa ekkii yinttis ohoda› ta gaydanna yinnisi. ");
INSERT INTO oydl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Eerats wodeppa suuba tana yin be7aama; mahi eerats wodeppa suuba yin tana bo7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","E tamaaruntsappa fete fete wol gidda, «‹Eerats wodeppa suuba yin tana be7aama; mahi eerats wodeppa suuba yin tana bo7oda›; mahin ta Adego qitoda gaazanna akko ga7intte?» ga7i wolla ohinttida. ");
INSERT INTO oydl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yikke «Eerats wodeppa suuba gaazanna akko ga7e? E akko ohizako nuus erinttoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Un eza oocodes koyzanno Yesuusa erii, «Taanii, ‹Eerats wodeppa suuba tana be7aama; mahi eerats wodeppa suuba yin tana bo7oda› gaydannis yin fete feta oocane? ");
INSERT INTO oydl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taanii yinttis turo turo gaane; yin yeekkodan zeleloda, yezin hyanna alamita ufayttoda. Hyatte yin azzanoda, yezin yin azzantta ufayssa laaminttoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Fettii maachita na7a yelodes yii7ize wode fa yelize wodita yellide gisho yirgane. Yezin na7a yelidannippa suuba na7a hyanna alamite yelinttide ufaysiti gisho fa un7ito botane. ");
INSERT INTO oydl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yinnii gaar, yinttin yin wozintte azzanane, yezin taanii yinttana mahi bo7oda. Yin wozintta gaama ufayttoda; yinna ufaysito ooden yinttappa ekkoos. ");
INSERT INTO oydl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Ye wode yin tana akko bazin woossaama. Ta yinttis turo turo gaane; yin ta suntsite woossize baz ubba Aday yinttis inggoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hyanno yellodes ta suntsite akko bazin woossikaaya. Yin ufayssita folo maaqqade gaar woossote; yin ekkoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Taanii hyanno yellodes yinttis aazizera ohida, yikkeppa taanii aazizera ohoose wode ye7oda. Yezin Adebaz ta yinttis qonccizi ohoda. ");
INSERT INTO oydl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ye wode yin ta suntsite Adaya woossoda; yin gisho taanii ta Adaya woossoda ga7e baaya. ");
INSERT INTO oydl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Akkos gayko, Aday fa ommite yinttana kadhane. Yin tana kadhize gishon ta Aday kaleppa yiidanno ammanze gisho E yinttana kadhane. ");
INSERT INTO oydl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ta Aday kaleppa hyanna alamite yiida; mahi alamito ashshii Adego qitoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","E tamaaruntsi mahi, «Yikke, hyatte neenii qonccizi ohinep attin; aazizera akkon ohoos. ");
INSERT INTO oydl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ne ubba baz erizanno oonan oocodes koyosanno nu hyatte erane. Yinnii gisho ne Xoozappa kiitinttidanna ammantsane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeezin, Yesuusa mahi unttago, «Hyatte yin ammanane? ");
INSERT INTO oydl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yikke, yin, yin kara yin kara lalinttii tana ta xalaala ashshii ashshii aachinttode wode ye7oda; hyatten yellida. Yezin Aday taara yeze gisho ta ta xalaala baaya. ");
INSERT INTO oydl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yin taara yezin saro yinttis yessade fana ta yinno ohida. Alame gidda yeziter yin waayinttoda. Yezin minggote; taanii alamito gamida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuusa yinno ohidannippa suuba ude salo bi7i, hyannigaara yagayda: «Ta Adayo, qammita yellida; ne Na7ay nena bonchchode gaar neenii ne Na7aya bonchcho. ");
INSERT INTO oydl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne ees inggide ubbuntsis E medhina de7o inggode fana as ubballa ees adetits wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Medhina de7o, nena, fettii turii Xoozzan ne kiittide Yesuus Kiristtoosa ere. ");
INSERT INTO oydl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne ta oochchode fana inggide oochito faaddii nena sa7alla bonchchida. ");
INSERT INTO oydl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hyatten, Adayo, alame medhinttodannippa tiino ne kale taas yeze bonchchite tana bonchcho. ");
INSERT INTO oydl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Alame asappa ne taas inggiduntsana nena erisida. Un nebaz; ne unttana taas inggida. Un ne qaalttisin kiitinttida. ");
INSERT INTO oydl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ne taas inggide ubba bazita neeppa yiidanno un hyatte erane. ");
INSERT INTO oydl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ne taas inggide qaaltto ta unttis inggida; unttin yinna qaaltto ekkida. Ta ne kaleppa yi7idanna turo maaqqidanno erii ne tana kiittidanno ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Ta unttis woossane. Un nebaz maaqqide gisho ne taas inggide asuntsis woossanep attin alames woossoos. ");
INSERT INTO oydl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taas yezanna ubba nebaz; nees yezanna ubba taas. Ta un baggara bonchchinttida. ");
INSERT INTO oydl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ta yikkeppa suuba alamite gam7oos; un alamite yene. Ta hyatte neego qitane. Geeshi Adayo, hyantses ne taas inggiduntsi neeran taaran fetto maaqqidanni gaara un fetto maaqqade gaar unttana ne taas inggide ne suntsite naago. ");
INSERT INTO oydl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta unttara sa7a yezitera, ne taas inggide ne suntsite unttana naagida. Geeshi Maxaafita gaydanna folinttode gaar dhabe beezze atstsep attin unttappa melle ooden dhabikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Hyatte ta neego ye7oda. Ta ufayssita un wozintte folo maaqqade gaar hyanno ta alamite yezara ohine. ");
INSERT INTO oydl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ta unttis ne qaaltto inggida. Ta alameppa maaqqikaayzanni fana, unttin alameppa maaqqikaayze gisho alame unttana ixxida. ");
INSERT INTO oydl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne iitappa unttana naagode gaarap attin alameppa kessoda gaar woossoos. ");
INSERT INTO oydl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taanii alameppa baayzanni fana unttin alameppa baaya. ");
INSERT INTO oydl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Neenii ne turite unttana geesho; ne qaalttan turo. ");
INSERT INTO oydl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne tana alame kiittidanni fana taanin unttana alame kiittida. ");
INSERT INTO oydl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mahi un turo geeshi maaqqade gaar un gisho ta ta ommito geeshoda. ");
INSERT INTO oydl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Taanii un xalaalas maaqqikaayzin un qaalttippa denddii, tana ammanoduntsisin woossane. ");
INSERT INTO oydl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Un ubbuntsi fetto maaqqade gaar ta woossane. Adayo, ne ta gidda yezannigaara, mahi ta ne gidda yezannigaara un ne gidda yessade gaar woossane. Ye wode ne tana kiittezanno alame ammanoda. ");
INSERT INTO oydl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neenin taanin fetto maaqqidanni gaara, unttin fetto maaqqade gaar, ne tana bonchchidanni gaara, taanin unttana bonchchida. ");
INSERT INTO oydl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ta un gidda, neenii ta gidda yezannigaara un folo fetto maaqqade gaar nena woossane. Yinnan, ne tana kiittezanno ne tana kadhide kadhite un kadhidanno alame erode gaar. ");
INSERT INTO oydl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Adayo, ne taas inggiduntsi ta yeze besite taara yessade gaar koyane. Alame medhinttodannippa tiino ne tana kadhide gisho taas inggide ta bonchchito un bo7oda. ");
INSERT INTO oydl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«Geeshi ta Adayo, alame nena eroos, yezin nena ta erane. Mahi ne tana kiittezanno hyantses erane. ");
INSERT INTO oydl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne tana siiqide siiqita un gidda yessade gaar, mahi taanii un gidda yessade gaar, ta ne suntsito unttana erisida; tiinosin erisoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuusa woosa hyaasidannippa maaqqii fa tamaaruntsara Qediroone borkka fiinggi, yinna besite yeze atakiltte gidda gelida. ");
INSERT INTO oydl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuusa ubba wode fa tamaaruntsara ize shiiqize gisho Yesuusa aatsii inggide Yihuda yinna bessito erane. ");
INSERT INTO oydl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yinnii gisho, Yihuda faanoose, xomppe, ola miishe aykkide gaama wottaddaruntsana, kahinunts hyalaquntsin Farisaawuntsi kiittide Xoozze Keetsito naagize poolisuntsana kaalitsi ekkii, yinna bessito hyanggida. ");
INSERT INTO oydl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuusa fana yellode baz ubba erii, gaxa kezii, «Oona koyete?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Un mahi, «Naazirete Yesuusa koyane» yagayda. E mahi, «Taanii Yesuusa» yagayda. Yesuusa aatsii inggide Yihuda ize unttara eqqida. ");
INSERT INTO oydl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","E, «Taanii Yesuusa» gayde wode un suub shiiqii, sa7a gol7ida. ");
INSERT INTO oydl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesuusa mahi, «Oona koyete?» yaga7i oocida. Unttin, «Naazirete Yesuusa koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","E mahi, «Taanii Yesuusa maaqqizanno yinttis ohida. Yikke, yin tana koyze baz maaqqiko hyantses qito ga7o ashshote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E yinno gayde, «Adayo, ne taas inggiduntsappa melle atto yezin fetan dhabsikaaya» gayde qaaltta folinttode fana. ");
INSERT INTO oydl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoon Phexiroosas mashsha yene. E ye mashshiza shoddii kahinunts hyalaqa arizes mizaqi hyayza gachchii olida. Ye arize suntsita Malkkoosa. ");
INSERT INTO oydl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuusa Phexiroosago, «Ne mashshiza shookite geltso. Ta Aday taas inggide xuu7itippa ta uzhamaane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Roome wottaddaruntsin un hyalaqize Xoozze Keetsito naagize poolisuntsara wolla Yesuusa aykkii accida. ");
INSERT INTO oydl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tiino Yesuusa Haannago kanggida. Haanna yinna berite kahinunts hyalaqa maaqqide Qayyaafa bolle. ");
INSERT INTO oydl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Qayyaafa, «Worzha gisho fettii asi hyayqqiko lo77o» ga7i tiino Ayhuduntsana zoridaya. ");
INSERT INTO oydl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoon Phexiroosan melle fettii tamaarize Yesuusa kaallii hyanggida. Kahine hyalaqize ye melle tamaariza loytsii erane. Yinnii gisho, E Yesuusara kahinunts hyalaqize gibbe gelida. ");
INSERT INTO oydl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yezin Phexiroosa gaseppa balera eqqida. Kahinunts hyalaqize erize melle tamaarize bale kezii, furtsito naagize naatis ohi, Phexiroosa geltsida. ");
INSERT INTO oydl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Furtsito naagize naata Phexiroosago, «Ne, ye atstse tamaaruntsappa feta baane?» yagayda. Phexiroosa mahi, «Aday, tana baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sa7ita ciishize gisho aruntsin naagizuntsin kenchchelo qaaqa tama eetsii, wutii aadhii eqqii kaazhane. Phexiroosan unttara eqqii tama kaazhane. ");
INSERT INTO oydl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ye wode Kahinunts hyalaqize Yesuusa, E tamaarunts bazin E timirttitibaz oocida. ");
INSERT INTO oydl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuusa mahi, «Ta asi ubbas qonccizi ohida. Ta Ayhude ubbuntsis shiiqize Ayhude woosa Keetstsan Xoozze Keetstsa ubba wode tamaarssida. Aachchii akkon ohikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yeezin, ne tana akkos ooce? Ta ohodera si7ide asuntsana ooco. Yentsi asuntsi ta ohidanno erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuusa yinno ohize wode yinna besite eqqide zabe naagizuntsappa fete Yesuusa baqqii, «Kahinunts hyalaqago yaga7i mahine?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuusa mahi, «Ta iita baz ohidebaz maaqqiko hyanne yeze as ubba tiino markkidho. Yezin ta turo ohidebaz maaqqiko tana akkos baqqe?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yinnii gisho, Haanna, Yesuusa acinttii yezin kahinunts hyalaqize Qayyaafago dakkida. ");
INSERT INTO oydl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Phexiroosa ize eqqii, tama kaashadera, hyankkunts eego, «Ne hyay atstse tamaaruntsappa feta baane?» yagayda. Phexiroosa mahi, «Ade, tana baaya» yaga7i kaddida. ");
INSERT INTO oydl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kahinunts hyalaqize aruntsappa fete, Phexiroosa hyaye gachchide atstses iginze, Phexiroosago, «Ta nena eera atakiltte gidda bi7ika?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Phexiroosa mahin kaddida. Iira lukule uukkida. ");
INSERT INTO oydl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wontta gooda, un Yesuusa Qayyaafa karappa Roome gade ahize oocha keetstsa kanggida. Ayhuduntsi Faasiga Ba7ale katstsa ma7ades fana tunizaame gaar kaatize oocha keetstsa gelikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yinnii gisho, Philaaxoosa unttago bale kezii, «Hyay atstsa akkos moote?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Un, «E iita oochchosako nuunii eza neego ke7aama yeshsha» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philaaxoosa mahi, «Yin eza ekkii kanggi, yin higgita gaazanni gaara eella firddote» yagayda. Ayhudunts, «Oodellan hyayqo firdda firddize adetits wolqqa nuus baaya» yagayda; ");
INSERT INTO oydl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yinna yi7idanna Yesuusa akko gaar hyayqo hyayqqod yezako erisodes ohidanna folinttodes. ");
INSERT INTO oydl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philaaxoosa fa oocha keetstsa mahi gelii, Yesuusa xeegii, «Ne Ayhude kaato?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuusa Philaaxoosago, «Hyanna oocito ne neeppa oocanene woy melle asi nees ta baz ohida?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philaaxoosa mahi, «Ta Ayhude aso? Ne asuntsin kahinunts hyalaquntsi nena taas aatsii inggida. Ne akko oochchido?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuusa, «Ta ka7itumtta hyanna alamttippa baaya. Hyannippa maaqqizako ta Ayhudunts hyalaquntsis aadhii ingginttaame fana taas oochchizuntsi olinttodyeshsha. Yezin ta ka7itumtta hyanna alamttippa baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yinnii gisho, Philaaxoosa Yesuusago, «Yeezin, ne kaat baa?» yaga7i oocida. Yesuusa mahi, «Ta kaati maaqqidanno ne gayda. Taanii yelinttidannan hyanna alamite yi7idanna turetitsis markkidhades. Turippa maaqqide ooden ta gaazanno si7ine» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philaaxoosa, «Turii akko?» yagayda. Philaaxoosa yinno gaydannippa maaqqii Ayhuduntsago bale kezii, «Taanii eza mootize bala denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yezin Faasiga Ba7ale ode, fettii asi yinttis achchappa billize woga yene. Ta yinttis Ayhuduntsi kaatiza billode gaar koyane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Un mahi, fa qaaltto dhoqi yiizii, «Barbbaana billop attin eza billippe» yagayda. Yezin Barbbaane faanno. ");
INSERT INTO oydl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yinnippa suuba, Philaaxoosa Yesuusa kanggi garafizida. ");
INSERT INTO oydl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wottaddaruntsi anggats barneexa medhdhii E ommite gaddida. Mahi zoqo ma7o eza ma7isida. ");
INSERT INTO oydl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Eego yi7itera, «Ayhude kaatizayo, saro nees maaqqe» yaga7i eza baqqida. ");
INSERT INTO oydl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philaaxoosa mahi bale kezii, Ayhuduntsago, «Yikke, taanii eeppa akko iitabazin denggikaayzanno yin erode gaar eza yinttago bale kessoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yinnippa maaqqii, Yesuusa anggats barneexa fa ommite gaddii, zoqo ma7o ma77i, bale kezida. Philaaxoosa Ayhuduntsago, «Atstsa hyaya bo7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kahinunts hyalaquntsin Xoozze Keetsito naagizuntsi eza bi7ide wode fa qaaltto dhoqi yiizii, «Masqalalla suxxo! Suxxo!» yagayda. Philaaxoosa unttago, «Yin eza kanggi, masqalalla suxxo. Ta eeppa akko iitabazin denggikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayhuduntsi mahi, «Nuus higge yene. E fana Xoozze na7a mahide gisho nu higgiti gaara E hyayqqodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Philaaxoosa yinno si7ide wode tiinonnippa gaama zhashtida. ");
INSERT INTO oydl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Mahin Philaaxoosa fa oocha keetstsite maaqqii gelii Yesuusago, «Ne abappa yi7ido?» yaga7i oocida. Yezin Yesuusa ees akkon mahikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yinnii gisho, Philaaxoosa, «Taas ohoso? Nena billodes woy masqalalla suxxodes taas adetits wolqqa yezanno eroso?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuusa, «Xoozii nees adetits wolqqa inggikaayzako taalla adetits wolqqa nees yezamayeshsha. Yinnii gisho, tana nees aatsii inggide aadhize nagara oochchida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Philaaxoosa yinno si7eze wode Yesuusa billodes oge koyda. Yezin Ayhuduntsi fa qaaltto dhoqi yiizii, «Ne eza billizebaz maaqqiko Kaat Qeesare ne bagga baaya. Fana kaati gaaze ooden Qeesare ixxizaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philaaxoosa yinno si7i Yesuusa bale kessida. Yeyzi, «Lochche Shuchchi» gaaze bessa firdda oydalla bettida. Ibraysxe qaalara yinna bessita «Gebeta» ga7inttane. ");
INSERT INTO oydl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yinna qammita Faasiga Ba7aale bonchchodes giigize wode. Ye wode sa7itan awarappa izipun saate gaar. Philaaxoosa Ayhuduntsago, «Yin kaat hyaya bo7ote» gayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ayhuduntsi fa qaaltto dhoqi yiizii, «Hyaaso! Hyaaso! Masqalalla suxxo» yagayda. Philaaxoosa mahi, «Yin kaatiza ta masqalalla suxxodanno koyane?» yaga7i oocida. Kahinunts hyalaquntsi, «Qeesareppa melle kaati nuus baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yinnippa maaqqii, un Yesuusa masqalalla suxxode fana Philaaxoosa unttis aatsii inggida. Un Yesuusa aykkii kanggida. ");
INSERT INTO oydl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuusa fa masqaliza tookkii, «Yeras qil» gaaze bessa kezida. «Yeras qil» ga7inttizanna Ibraysxe qaalara «Golggotta» ga7inttane. ");
INSERT INTO oydl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Un yinna besite masqalalla Yesuusa suxxida. Mahin eera melle lam77i asuntsana, feta seko zalara hyankkaya hyankka zalara masqalalla suxxida. ");
INSERT INTO oydl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philaaxoosa, «Ayhuduntsi Kaati, Naazirete Yesuusa» yagaaze xuufe xaafii masqalalla gaddida. ");
INSERT INTO oydl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesuusa masqalalla suxunttide besita katamas kale yeze gisho gaama Ayhuduntsi yinna xuufito nabbabida. Xuufize xaafinttidanna Ibraysxe doonara, Laatine doonaran Girike doonara. ");
INSERT INTO oydl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yinnii gisho, kahinunts hyalaquntsi Philaaxoosago, « ‹Hyay atstse fana Ayhude kaati gaydanni gaar› ga7i xaafop attin eza E ommite ‹Ayhude kaati› ga7i xaafippe yagayda.» ");
INSERT INTO oydl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yeezin, Philaaxoosa, «Taanii xaafidanno xaafida» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wottaddaruntsi masqalalla eza suxxidannippa suuba E ma7ito ekkii, oyddii bessa shaakkii, fetto fetto ekkida. Dakitsi ma7inttize pharggo ma7o yeshsha. ");
INSERT INTO oydl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wottaddaruntsi, «Oona yellodyezako, ixa olidap attin ma7iza fer7oos» yagayda. Yinna hyanidanna Geeshi Maxaafite, «Ta ma7ito gizhintti ekkida; ta pharggo ma7izella ixa olida» gaynttidanna folinttode gaar.Yinnii gisho, wottaddaruntsi yinno yiizida. ");
INSERT INTO oydl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yezin Yesuusa masqala kale E inttan, E inttii mishta, Qeliyoopha machchita Mayramiran Magdela Mayrama eqqida. ");
INSERT INTO oydl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuusa fa intton E kadhize tamaarize ize eqqiduntsana bi7i, fa inttigo, «Ta intte, ne na7aya hyaya bo7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yinnippa suuba, ye tamaarizego, «Ne intto hyanno bo7o» yagayda. Ye tamaarize izo yinna woditippa aykkii faara yessade gaar kara kanggida. ");
INSERT INTO oydl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yinnippa suuba, Yesuusa ubbanna hyatte folinttidanno erii, Geeshi Maxaafite xaafinttidanna folinttode gaar «Tana barida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yinna besite fettii gonbbo kumutsi caala woyne yene. Un fuza yinna woyntte dakkii, hisophe minxa bertstsa gaddii, Yesuusa doonago shiishida. ");
INSERT INTO oydl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesuusa woyniza qamasi bi7i, «Folinttida» yagayda. Yinnippa suuba, fa ommito soxor yiizii fa shemppito inggida. ");
INSERT INTO oydl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yinna qammita giiginttize qamma maaqqide gishon wonttize qammize bonchcho Sambbata maaqqide gisho asuntsana ahita masqalalla Sambbata wode feezhaame gaar un bunqito mentsii, masqalappa ketstsode gaar Ayhuduntsi Philaaxoosa woossida. ");
INSERT INTO oydl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yinnii gisho, wottaddaruntsi hyanggi, Yesuusara suxunttide lam77i asuntsis bunqito mentsida. ");
INSERT INTO oydl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yezin Yesuusago yi7ide wode E hyayqqidanno bi7i, E bunqito mentsikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yezin wottaddaruntsappa fete E millite toorara caddin iira suutsin hyaatsin goggida. ");
INSERT INTO oydl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yinno ammanode fana yinno bi7ide markkidhida. E markkatitsitan turo. Mahi E hyanidanna turo maaqqizanno erane. ");
INSERT INTO oydl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yinna hyanidanna Geeshi Maxaafite, «E meqatsitippa fettin meqqoos» gaydanna folinttode fana. ");
INSERT INTO oydl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Mahin Geeshi Maxaafite melle bessa, «Un fa caddidanno bo7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yinnippa suuba, Armmatiyasa katamapa yi7ide Yoosefa Yesuusa ahito ekkodes Philaaxoosa woossida. Yoosefa Ayhuduntsis zhashtide gisho aachintti Yesuusa kaallizaya. Philaaxoosa, «Ekko» yagayda. Yinnii gisho, Yoosefa hyanggi Yesuusa ahito ekkida. ");
INSERT INTO oydl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mahi Niqodimoosa, hyannippa tiino Yesuusago qamma yi7iday, karbberan arkkintteran worqqinttide hyastam fettii kilo giiraame maaqqade shitto ekkii Yoosefara yi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yentsi lam77i asuntsi Yesuusa ahito ekkii, Ayhuduntsi aha ziidhize wogara, shittora, moogize afulara xaaxida. ");
INSERT INTO oydl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesuusa masqalalla suxunttide besite gaama atakiltte yene. Yinna atakilttiti gidda shuchchappa woocii giigizide hyaga ooden mooginttikaayze kille booza yene. ");
INSERT INTO oydl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ye wom7ize kale yeze gishon Ayhuduntsi Sambbatas giiginttize wode maaqqide gisho Yesuusa ahito ize moogida. ");
INSERT INTO oydl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wogga ode wontta hyaga sa7a geezhikaayzin, Magdela Mayrama, Yesuusa mooginttide booza hyanggi shuchchita booza doonttippa denddidanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Simoon Phexiroosagon Yesuusa kadhize hyankkay tamaarizego woxxii hyanggi, «Boozitippa Laatstsa ekkida; eza aba gaddezako nu eroos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yinnii gisho, Phexiroosan hyankkay tamaarize kezii woxxittera booza hyanggida. ");
INSERT INTO oydl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lam77untsin fettilla woxxida, yezin hyankkay tamaarize Phexiroosappa aadhii tiino boozite yellida. ");
INSERT INTO oydl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ye tamaarize zuggii, eza xaaxide afultto bi7ida, yezin booziti gidda wodhdhikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoon Phexiroosa eza kaallii yi7i, booziti gidda wodhdhii eza xaaxide afultta ize yezanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mahi Yesuusa ommito xaaxide afula xaaxintti boozite omma guro yezin bi7ida. Ye afulize dumma bessa yenep attin booza afulara wolla baaya. ");
INSERT INTO oydl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ye wode tiinii booztte yellide hyankkay tamaarize gelii bi7i ammanida. ");
INSERT INTO oydl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesuusa hyayqoppa denddodes beezanno ohize Geeshi maxaafe yeze qaaltto un hyaga tiirikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yinnippa suuba, E tamaaruntsi fa kara maaqqii qitida. ");
INSERT INTO oydl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Yezin Mayrama yinna booziti doontte eqqii yeekkitera zuggii boozito bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bootsi ma7o ma77ide lam77i kiitanchchuntsi Yesuusa ahita woy7ide besite fete omma gurora fete tohe guro bettezin bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Un iigo, «Maachite, akkos yeekke?» yaga7i oocida. Iza, «Un ta Laatstsa ekkida; un aba gaddezako ta eroos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yinno gaydannippa suuba, iza suub maaqqii be7ize wode Yesuusa ize eqqezin bi7ida. Yezin E Yesuusa maaqqidanno erikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuusa iigo, «Maachite, akkos yeekke? Oona koye?» yaga7i oocida. Mayrama atakiltte oochchize asi aazin, «Laatstso, ne ekkezako, eza aba gaddezako taas ohoya. Ta eza ekkoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuusa iigo, «Mayrame» yagayda. Iza eego maaqqin, Ibraysxe doonara «Rebuunii» yagayda. Bilitsitan «Asttamaarizayo» ga7e. ");
INSERT INTO oydl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuusa iigo, «Ta hyaga ta Adego kezikaayze gisho tana aykkippe. Yezin ta ishuntsanan hyanggi, ‹Taanii ta Adegon yin Adego, ta Xoozzegon yin Xoozzego, kessada gayda› ga7i unttis oho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdela Mayrama Laatstsa bi7idannon iis E ohidanno hyanggi E tamaaruntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wogga ode ugure, E tamaaruntsi Ayhuduntsis zhashtii furtsito gorddii shiiqii bettezin, Yesuusa yi7i, un gidda eqqii, «Saro yinttis maaqqe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yinno ga7i maaqqii fa kushiton fa millito unttana beezida. E tamaaruntsi Laatstsa bi7ide wode gaama ufayttida. ");
INSERT INTO oydl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuusa mahi unttago, «Saro yinttis maaqqe; ta Aday tana kiittidannigaara taanin yinttana kiittoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yinno ga7idannippa suuba, unttalla ufi ga7i fuggida. Mahi, «Geeshi Ayyaana ekkote. ");
INSERT INTO oydl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yin atto gayde as nagartta atto ga7inttoda. Yin atto gaykaayze nagartta atto gaynttoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yezin taphpho lam77i tamaaruntsappa fete, Didimoosa ga7inttize Toomaasa, Yesuusa ye7ize wode unttara baaya. ");
INSERT INTO oydl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yinnii gisho, hyankko E tamaaruntsi Toomasago, «Nuunii Laatstsa bi7ida» yagayda. Yezin Toomaasa unttago, «Misimarera E cadinttide E kushite yeze beetto bi7ikaayzara yinna beetto ta gil7ara bochchikaayzara, mahi ta kushito E millite dakkii bi7ikaayzara ammanoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Osfun qammappa suuba, Yesuusa tamaaruntsi mahi keetstsa shiiqii bettida; Toomaasan unttara yeshsha. Furtsita gorddinttii yezin Yesuusa yi7i, un gidda eqqii, «Saro yinttis maaqqe» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yinnippa suuba, Yesuusa Toomasago, «Ta kushito ne gil7itira bochchii bo7o. Mahi ne kushito ta millite dakkii bo7o; so7ippe, ammano» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomaasa mahi, «Ta Laatstsayo, ta Xoozayo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeezin Yesuusa, «Ne tana bi7ide gisho ammanida, yezin bi7ikaayzara ammaniduntsii anjjinttiduntsana» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuusa maxaafite xaafinttikaayze melle gaama kille baz fa tamaarunts tiintte oochchida. ");
INSERT INTO oydl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yezin Yesuusa E Kiristtoosa, Xoozze Na7a maaqqizanno yin ammanode gaaran ammanii E suntsite de7o denggode gaar hyanna xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yinnippa suuba, Yesuusa Xibaaryoosa Abba kale fa tamaaruntsis mahi qonccida. E unttis hyannippa kaallii yeze hyanotitsar qonccida. ");
INSERT INTO oydl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoon Phexiroosa, Didimoos ga7inttize Toomaasa, Qaana Galilappa yi7ide Natina7eela, Zabdoosa na7untsin Yesuusa tamaaruntsappa melle lam77unts wolla yene. ");
INSERT INTO oydl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoon Phexiroosa unttago, «Ta molo aykkodes qitane» yagayda. Un, «Nuunin neera hyammada» yaga7i, gongge gidda gelida. Yezin un yinna qammite akko molon aykkikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wontta gooda xalqe kessadannippa tiino, Yesuusa abba gaxa eqqida, yezin E tamaaruntsi Yesuusa maaqqidanno erikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuusa unttago, «Na7untso, akko muuze baz yene?» gayda. Un mahi, «Akkon baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E mahi, «Yin molo aykkize gitto gonggizeppa mizaqi zalara olote; molo yin aykkoda» yagayda. Yinnii gisho, molo aykkize gitto mizaqi zalara olida. Molo gelii kumide gisho gochchii kessodes gamida. ");
INSERT INTO oydl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesuusa kadhize tamaarize Phexiroosago, «Hyayni Laatstsi!» yagayda. Simoon Phexiroosa E Laatstsi maaqqidanno si7ide wode gaarii gaddide fa ma7ito ma77i abba gidda doollii gelida. ");
INSERT INTO oydl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yezin gonggite attide hyankko tamaaruntsi molo kumide gitto gochchii, abbappa gaxa kezida. Un abbappa lam77i xeet hyadha fana hyaakkida. ");
INSERT INTO oydl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Un abbappa gaxa kezide wode kenchchelo tama qaaqa, molon booran bi7ida. ");
INSERT INTO oydl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuusa unttago, «Hyatte yin aykkide molttippa ane taas ko7ote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoon Phexiroosa gonggite gelii, xeeti ichintam hyaydzdzii damma molo aykkide gitto gochchii abbappa gaxa kessida. Moltta yinnii gaar gaama maaqqikon molo aykkide gitto fer7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuusa unttago, «Hyankka yi7i dayxe mo7ote» yagayda. E Laatstsi maaqqidanno un eride gisho E tamaaruntsappa fettin, «Ne oode?» ga7i eza oocodes miinggide baaya. ");
INSERT INTO oydl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuusa yi7i, boora ekkii unttis inggida; moloppan yinnii gaara inggida. ");
INSERT INTO oydl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuusa hyayqoppa denddii fa tamaaruntsis benttide hyannira hyaydzintsa. ");
INSERT INTO oydl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Un dayxito mu7idannippa suuba, Yesuusa Simoon Phexiroosago, «Yoona na7a Simoona, tana hyantsesappa aatsii kadhane?» yagayda. Simoon Phexiroosa, «Yee Laatstso, ta nena kadhizanno ne erane» yagayda. Yesuusa eego, «Ta dhanggize duro na7untsana yenggo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuusa lam7intsa, «Yoona na7a Simoona, tana kadhane?» yagayda. Simoon Phexiroosa, «Yee Laatstso, ta nena kadhizanno ne erane» yagayda. Yesuusa, «Ta duruntsana yeenggo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuusa hyaydzintsa, «Yoona na7a Simoona, tana kadhane?» yagayda. Yesuusa hyaydzintsa Simoon Phexiroosago, «Tana kadhane?» yaga7i oocide gisho Phexiroosa azzanii, «Laatstso, ne ubbabazito erane; ta nena kadhizanno ne erane» yagayda. Yesuusa, «Ta duruntsana yeenggo. ");
INSERT INTO oydl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta nees turo turo gaane; ne na7atitsa yeze wode nenes ma77i, ne koyze bessa qitane. Yezin ne cinggide wode ne kushito miccii beessada. Melle asi danccisada; ne kadhoosse bessa kanggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuusa yinno Phexiroosa akko gaar hyayqo hyayqqii, Xoozza bonchchisad yezako beessades gayda. Yinno gaydannippa suuba, Yesuusa Phexiroosago, «Tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phexiroosa suuba maaqqii, Yesuusa kadhize tamaarize faappa suubara ye7izanno bi7ida. Ye tamaarize, kawo muuze bessa Yesuusago shiiqii, «Laatstso, nena aatsii immade oode?» gaydaya. ");
INSERT INTO oydl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phexiroosa ye tamaariza bi7i, «Laatstso, hyay atstse wayade?» yaga7i Yesuusa oocida. ");
INSERT INTO oydl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuusa eego, «Ta ye7ode wontsis E shemppora yessade gaar ta koyko, nena akko madhe? Ne tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yinnii gisho, ye tamaarize hyayqqoos gaaze ohe ishuntsana ubba yellida. Yezin Yesuusa, «Ta ye7ode wontsis, E shemppora yessade gaar ta koyko nena akko madhe?» gaydap attin «Hyayqqoos» gaykaaya. ");
INSERT INTO oydl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hyanna ohiti baz markkidhidayin hyanno xaafide ye tamaarize eza. E markkatitsitan turo maaqqidanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuusa oochchide melle gaama baz yene. Ta qoppin, ubba bazi fete fete ommara xaafinttizako, xaafinttize maxaaftis alame gaddodes bessi maaqqada aazoos.");
INSERT INTO oydl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tewofiloosa, Yesuusa fa oochito aykkide wodeppa salo qitode wode yellodes, oochchidannon tamaarssidannon ubba taanii ta tiino maxaafite xaafida. Salo kessadannippa tiino E fa dooride hawaaruntsana Geeshi Ayyaanara kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","E fa madhitip suuba hyayqoppa denddidanno de7o maaqqii unttis fana beezida. Oyttam qamma unttis benttii Xoozze ka7itumo unttana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Fettii ode unttara wolla mu7itera unttana hyannigaar ga7i kiittida: «Ta yinttis ohide, ta Aday inggoda gayde ufays qaaltto naagotep attin Yerusalaameppa kezippete. ");
INSERT INTO oydl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Akkos gayko, Wahannisa hyaatsara xammaqida, yezin eerats wodeppa suuba Geeshi Ayyaanara yin xammaqinttoda» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Unttin wolla shiiqide wode, «Laatstso, Isra7eeluntsis ka7itumtto ne mahode wodita hyanno?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesuusa unttago, «Ta Aday fa adetits wolqqite oochchize woditon beriton yin erodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yezin Geeshi Ayyaana yinttalla wodhdhide wode yin wolqqa ekkoda. Yeyizi maaqqii, Yerusalaame, Yihuda sa7a ubba, Samaaran sa7a gaxa yellodes yin taas markka maaqqada» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yinno gaydannip maaqqii un be7izin, dhoqi dhoqi ga7i, salo kezin dhonne eza un aafittippa geentsida. ");
INSERT INTO oydl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesuusa qitodera un salo mahi be7adera, bootsi ma7o ma77ide lam77i asuntsi tiirikaayzin un kale eqqii, ");
INSERT INTO oydl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Galila asuntso, salo bi7itera, yin akkos eqqidote? Hyay yin be7izin salo qitide Yesuusa yinnii fana maaqqii ye7oda» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yinnippa maaqqii, hawaaruntsi Shamahe Derizeppa Yerusalaame maaqqida. Shamahe Derize Yerusalaames fettii kilo metire fana yene. ");
INSERT INTO oydl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Un Yerusalaame gelii, fa yeze fooqe keetsitilla kezida. Unttin: Phexiroosa, Wahannisa, Yayqooba, Inddirase, Filphoosa, Toomaasa, Bartolomiyoosa, Maatoosa, Ilfiyoosa na7a Yayqooba, fa sa7itis yiqsinttize Simoonara Yayqooba na7a Yihuda. ");
INSERT INTO oydl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hyantses ubbuntsi maachuntsara, Yesuusa intta Mayramiran Yesuusa ishuntsaran ubba fettii wozina maaqqii mintsii woossane. ");
INSERT INTO oydl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ye wode Phexiroosa xeeti lam7itam maaqqade ammanze asuntsi shiiqide besite denddii eqqii, hyannigaar gayda: ");
INSERT INTO oydl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Asuntso, Yesuusa aykkiduntsana kaalitside Yihudabaz Geeshi Ayyaana tiino Dawute doontte ohide Xoozze qaaltta folinttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yihuda nuura wolla hyanna oochito oochchodes doorinttide asi.» ");
INSERT INTO oydl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yezin Yihuda fa gene oochitira denggide miishera gade wonggida. E tiinor guphunttii gol7in, E sazita feedhinttida; E merqita wul7inttida. ");
INSERT INTO oydl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yihudalla afa hyanidanno Yerusalaame yeze as ubbuntsi si7ida. Yinnii gisho, yinna sa7ito fa doonara Akelddaama (Suuts gade) ga7i xeegida. ");
INSERT INTO oydl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Yinnan mazmure maxaafite, «E keetsita hyarii atto; ooden ize yezippe. Mahi ‹E shuumatitsito melle ekko› ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Yinnii gisho, Laatstse Yesuusa nu gidda wutii hyanttide wode ubba nuura yezuntsappa, ");
INSERT INTO oydl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","mahi Xammaqize Wahannisa woditippa aykkii Laatstse Yesuusa salo kezide wode yellodes nuura yezuntsappa fettii asi E dendditis nuura markka maaqqades beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yinnii gisho, asuntsi dooritis Yosxoosa gaaze Barssabaasa ga7inttize Yoosefan Maatiyasa lam77untsana shiishida. ");
INSERT INTO oydl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yinnippa suuba, Xooz woossittera, «As ubba wozina erize Laatstso, hyantsi lam77untsappa ne oona doorezako nuna beezo. ");
INSERT INTO oydl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yihuda fa bessa qitii, ashshide oochchite hawaaretitsi oocha ekkode gaar hyantsesappa nuus shago» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Unttis ixa olida. Ixitan Maatiyasas wodhdhin Maatiyasa taphpho fettii hawaaruntsalla gujinttida. ");
INSERT INTO oydl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Phenxeqosxe gaaze qamma yellide wode ammanzunts ubba wolla fettii bessa shiiqii yene. ");
INSERT INTO oydl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Qoppikaayzin damma tookkii ekkii qitode fana yeze baqo guumii saloppa yi7i un yeze keetsite kumida. ");
INSERT INTO oydl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mahi tama loxe fana aazize lissanuntsi unttis benttida, shaakkintti shaakkintti un ubbuntsalla bettida. ");
INSERT INTO oydl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Un ubbuntsi Geeshi Ayyaanara kumii dumma dumma doonara ohinttode fana Geeshi Ayyaana unttis ohode fana inggidannigaar ohe aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ye wode saloppa oomora yeze sa7a ubbappa yi7ide Xooz zhashtize Ayhuduntsi Yerusalaame yene. ");
INSERT INTO oydl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Yinna ootsito si7ide wode gaama asi shiiqida. Ammanze asuntsi un fa doonara ohinttodera si7ide gisho ");
INSERT INTO oydl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","gawude baz dhabin gaama qoppii, «Hyantsi ohinttize asuntsi ubba Galila as baane? ");
INSERT INTO oydl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yeezin, nuunii, nu yelinttide gade doonar un ohinttodera wayzi si7odes dandda7ido? ");
INSERT INTO oydl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nuunii Phartte, Meedona, Elaamen, Mesphexomiya, Yihuda gidda, Qaphadooqiya, Phanxoosa, Isiya, ");
INSERT INTO oydl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phirgge, Phinfile, Gibxxe, Qaarena kale yeze Liibiya worada yezuntsana. Nuuppa bagguntsi Roomeppa yi7ide asi. ");
INSERT INTO oydl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayhuduntsin Ayhuduntsi ammano gelide asuntsi, Qarxeesan Arabe asuntsi, Xoozii oochchide damma oochito nu doonar ohinttodera nu si7ine» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ubbuntsi gaama qoppii, ga7odebaz dhabin woligo, «Yii7i hyanno akko gawude?» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yezin melluntsi, «Hyantses kaxxikaayze woyne uzhii matsinttida» yaga7i leqqida. ");
INSERT INTO oydl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yezin Phexiroosa, taphpho fettii hawaaruntsara denddii eqqii, fa qaaltto dhoqi yiizii, unttago hyannigaara yaga7i ohida: Ayhuduntso, Yerusalaame yeze ubbuntso, ta ohizanno si7ote. ");
INSERT INTO oydl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wonttappa hyaydzdzii saate maaqqide gisho yin qoppizannigaara hyantsi asuntsi matsinttikaaya; yinna yin achcha erinttidebaz maaqqo. ");
INSERT INTO oydl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yezin hyanna hyanidanna nabe Iyu7eella ohidanna folinttode fana. ");
INSERT INTO oydl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹Xoozii, wode wurssutsite hyannigaara hyanoda yagaane: taanii as ubballa ta Ayyaana gussoda. Yin dhiiratsi na7untsin maachi na7untsi, tinbbite ohoda. Yin yidhdhuntsi qonccitsi be7ada; yin cimuntsi abukko abukkoda. ");
INSERT INTO oydl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Yinna wodite tana ammanze dhiiratsi aruntsallan maachi aruntsalla ta ta Ayyaantto gussoda; un tinbbite ohoda. ");
INSERT INTO oydl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mahi taanii afa salo kille baz, yeekka sa7a malla beessada. Suutsi, taman damma cuga qayqayo benttoda. ");
INSERT INTO oydl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Damman bonchcho maaqqide Laatstse wode, yellodannippa tiino awa dhumoda; aginan suutsi fana yi7ada. ");
INSERT INTO oydl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yinna wodite hyannigaara yi7oda; Laatstse suntsito xeegize ooden attoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Isra7eele asuntso, hyanna qaaltto si7ote. Naazirete Yesuusa oona yezako, Xoozii yin gidda oochchide kille bazin mallan yinttis qonccidanno yin, yin ommite erane. ");
INSERT INTO oydl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Xoozze tiino qofiten E eritii baggara Yesuusa aadhii ingginttida. Yinttin eza higge baayzuntsi kushe masqalalla suxxii wodhida. ");
INSERT INTO oydl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yezin hyayqo eza aykkodes dandda7oosse gisho Xoozii hyayqo wolqqa dhabsi eza dentstsida. ");
INSERT INTO oydl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawute E baz ohitera, « ‹Taanii tannaame fana, Laatstsii ta mizaqite yene. Laatstsa ubba wode ta tiino be7ine. ");
INSERT INTO oydl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yinnii gisho, ta wozintta ufayttida; ta il7antsite ufayssi kumida; hyayqqize ta ashita ufayssara yessada. ");
INSERT INTO oydl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Akkos gayko, ta shemppito si7oole gidda ashshoos. Mahi ne Geesha wooqas ashshoos. ");
INSERT INTO oydl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ne tana de7o oge erisida; Ne taara yezannippa ta ufaysita kumutsi maaqqane›yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Ishuntso, nu aday Dawutebaz ta yinttis geeshi ohoda. Dawute hyayqqii mooginttida; E boozita hyayno yellodes nu kale yene. ");
INSERT INTO oydl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawute nabe maaqqide gisho Xoozii E na7untsappa feta E ka7itumo araatalla bettitsodes ees caaqqide caaqito erane. ");
INSERT INTO oydl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yinnii gisho, Kiristtoosa denddito tiino bi7i, ‹E shemppita si7oole benttaamannon; E ashita wooqaamanno› ohida. ");
INSERT INTO oydl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«Xoozii, hyaya Yesuusa hyayqoppa dentsidannis nuunii ubbuntsi markka. ");
INSERT INTO oydl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yinnii gisho, Xoozze mizaqi zalara eza dhoqi dhoqi yiizii, ees inggoda ga7inttide Geeshi Ayyaan Adeppa ekkii, hyanno yin hyatte be7izannon si7izanno nuulla afa gussida. ");
INSERT INTO oydl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Akkos gayko, Dawute fa ommite salo kezikaaya yezin: «Laatstsi, ta Laatstsa, ‹Ta ne morkkuntsana ne tohita yedhdhize bessi mahode wontsis hyanne taappa mizaqi zala betto gayda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Yinnii gisho, hyay yin masqalalla suxxide Yesuusa, Xoozii Laatstsin Kiristtoosa mahidanno Isra7eele as ubbuntsi turip ero» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asuntsi Phexiroosa ga7idanno si7eze wode fa wozintte azzanii bochinttii Phexiroosan hyankuntsi hawaaruntsago, «Ishuntso, yeezin nuunii akko oochcho?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phexiroosa unttago, «Yin nagartta atto ga7inttode gaar nagarttippa maaqqii, yin fete fete Yesuus Kiristtoosa suntsite xammaqinttote. Xoozii inggize Geeshi Ayyaana imo ekkoda. ");
INSERT INTO oydl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Xoozii inggoda gayde ufays qaala yinttis, yin na7untsisin Laatstsii nu Xoozay faago xeegize hyaako yeze ubbuntsis» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phexiroosa unttis melle qaalan gujjii markkidhii, «Hyantsi wobbo asuntsalla yo7odes yeze firddappa yin ommito ashshote» yaga7i zorida. ");
INSERT INTO oydl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Phexiroosa ohidanno ekkiduntsi xammaqinttida. Ye wode hyaydzdzii mukul maaqqade asuntsi ammanii gujunttida. ");
INSERT INTO oydl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Un hawaaruntsi timirttera, fettetitsara, wolla katstsa me7eran Xooz woosara miinggi yene. ");
INSERT INTO oydl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hawaaruntsi kushe gaama kille bazin malla oochinttize gisho asunts ubba zhashtida. ");
INSERT INTO oydl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ammanze ubbuntsi fettilla yene; faas yezebaziton ubba fettilla gishinttane. ");
INSERT INTO oydl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Un faas yezebazito bayzi birtto fetes fetes koshshide fana gishane. ");
INSERT INTO oydl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ubba wode fettii wozinara maaqqii Xoozze Keetstsa shiiqane. Fa keetstsan fete feta xeegii ufayssaran lo77o wozinara katstsa muune. ");
INSERT INTO oydl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xoozza galatittera as ubba gidda nashshinttida. Laatstsi attize shemppo qammite qammite unttalla gujjane. ");
INSERT INTO oydl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Fettii ode Phexiroosan Wahannisan Xooz woossodes uddufun saate Xoozze keetstsa hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yelinttidannippa denddii tohe wobbo maaqqide fettii asi Xoozze keetstsa gelize asappa muxaata woossode fana ubba wode lo77o gaaze Xoozze Keetsitis furtsite tookkii ki7i gaddane. ");
INSERT INTO oydl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ye atstse Phexiroosan Wahannisan Xoozze keetstsite gelodes ye7odera bi7i unttana muxaata woossida. ");
INSERT INTO oydl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Unttin eza dakkii bi7i, Phexiroosa «Nuna hyankka bo7o» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tohe wobbo atstse un akko baz inggoda aazin unttana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yezin Phexiroosa eego, «Taas biran worqqan baaya, yezin taas yezanno ta nees inggoda. Naazirete Yesuus Kiristtoosa suntsite denddii goden hyankan yedhdho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yinnippa maaqqii, E mizaqi kushito aykkii dentstsida. Ellisii E tohitan qilchitan minggida. ");
INSERT INTO oydl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Atstsay doollii denddii eqqida. Goden hyankan yedhdhe aykkida. Yinnippa maaqqii, yedhdhitera, doolliteran Xooz galatittera unttara wolla Xoozze keetstsa gelida. ");
INSERT INTO oydl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","E yedhdhodera Xooz galatoderan asunts ubba eza bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bi7ide ubba muxaata woossodes lo77o gaaze Xoozze Keetstsa furtsite bettide eza maaqqidanno erida; E hyanidanno bi7i gaama qofara kumida. ");
INSERT INTO oydl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Atstsay Phexiroosappan Wahannisappan duuxoos ga7i aykkii yezin asuntsi ubba gaama qoppii, Solomona furtsi gaaze bessa wolla unttago yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phexiroosa asuntsana bi7ide wode asuntsago, «Isra7eele asuntso, akkos hyanne gaama qoppete? Woy akkos nuna dakkii be7ete? Nuunii nu wolqqara woy nu Xooz zhashtide gisho hyay atstsa fa toher yedhdhode gaar yiissada yinttis aazane? ");
INSERT INTO oydl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahama, Yisaaqa, Yayqooba Xoozze, nu aduntsi Xoozze, fa na7aya Yesuusa bonchchida. Yezin yin hyayqos aatsii inggidaya Philaaxoosa billodes koyin yin E tiino, ‹Nu eza koyoos› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Yin geeshizan xillizan, ‹Nu eza koyoos› ga7i, shemppo wodhidaya yinttis billode gaar Philaaxoosa woossida. ");
INSERT INTO oydl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","De7o inggizaya yin wodhida, yezin Xoozii hyayqoppa eza dentstsida. Yinnis nu markka. ");
INSERT INTO oydl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Hyay yin be7izen erize atstse faxii miinggidanna Yesuusa suntsite ammanidanne. Hyay yin ubbunts tiintte eza hyannigaar fatstside E Yesuusa ammanide gisho. ");
INSERT INTO oydl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Hyatten ta ishuntso, yinttin yinttana kaalitsizunts gaar, erikaayzara oochchidanno ta erane. ");
INSERT INTO oydl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yezin Xoozii zaga nabunts ubbunts doontte, ‹Kiristtoosa madha ekkodes beezane› yagaydanno yi7i folinttode fana oochchida. ");
INSERT INTO oydl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Yikke, Xoozii yin nagartto atto gawude gaar maarotitsi geloten Laatstsago maaqqote. ");
INSERT INTO oydl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Laatstse kaleppa mintsitsize wode yinttis ye7ode fana Xoozii eza tiinidhdhii dooride Kiristtoos Yesuusa yinttis dakkoda. ");
INSERT INTO oydl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xoozii fa geeshi nabunts doontte zaga ohidanni gaar ubba bazi killidhdhode wode yellodes Yesuusa salo gam7odes beezane. ");
INSERT INTO oydl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muse, ‹Laatstse Xoozii tana dentsidanni gaar yin gidda fa yinttis nabe dentstsoda. Yin E gaazanno ubba si7ote. ");
INSERT INTO oydl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ye nabize ohizanno si7oosse atstse ooden as giddappa shaakkintti dhaboda› gayda. ");
INSERT INTO oydl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Mahi Saamu7eelappa aykkii yeze nabunts ubba yinna qammitibaz ohida. ");
INSERT INTO oydl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yin nabunts na7untsana; mahi Xoozii Abrahamas, ‹Sa7a yeze as ubba ta ne kochchiti baggar anjjoda› ga7i nu aduntsis gelide caaqo qaala laattode na7untsana. ");
INSERT INTO oydl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Xoozii yinttana ubba yin iita ogitippa mahi anjjode fana fa na7aya dentsii yinttis tiinii dakkida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phexiroosan Wahannisan asuntsis ohodera kahinunts hyalaquntsi, Xoozze Keetstsito naagizunts hyalaqizen Saduqaawuntsi unttago yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Un Yesuusa hyayqoppa denddidannon E baggara hyayqoppa denddo yezanno asuntsana tamaarsside gisho kaccida. ");
INSERT INTO oydl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yinnii gisho, unttana aykkii sa7ita uguride gisho wonttode wontsis achi keetstsa geltsida. ");
INSERT INTO oydl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Yezin qaala si7iduntsappa gaamuntsi ammanida. Ammanide dhiiratsi asunts faydita ichchin mukul yellida. ");
INSERT INTO oydl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wonttitsiti ode gade ahizunts, cimuntsin, higge asttamaarunts Yerusalaame shiiqida. ");
INSERT INTO oydl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Yentsi asunts gidda kahinunts hyalaqize Haannan, Qayyaafa, Wahannisa, Iskkinddiroyan kahinunts hyalaqa iginuntsi ubba yene. ");
INSERT INTO oydl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Phexiroosan Wahannisan fa tiintte essi, «Akko wolqqara woy oode suntsite hyanno yin oochchido?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ye wode Phexiroosa Geeshi Ayyaanar kumii, «Ahizuntson, cimuntso, ");
INSERT INTO oydl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","hyayno hyay tohe wobbo atstses oochinttide lo77o oochchitisin E wayzi faxezako yin nuna qurichchiko, ");
INSERT INTO oydl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","masqalalla yin suxxin, Xoozii hyayqoppa dentstside Naazirete Yesuus Kiristtoosa suntsite hyay atstse faxii yin tiintte eqqiday yinttisin Isra7eele as ubbuntsis erinttidebaz maaqqe. ");
INSERT INTO oydl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","«Yin ‹Keexxizuntsi leqqii ixxide shuchchize, keetsi mayzenes omman, ubbappa aadhize shuchchi maaqqida; ye shuchchize Yesuusa.› ");
INSERT INTO oydl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yinnii gisho, atotitsi E baggarap attin melle oode baggaran yi7ikaaya. Nu E suntsite attode gaar as ubbas Xoozii saloppa oomora inggide melle suntsi baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Shiiqide asuntsi Phexiroosan Wahannisan qonccizi ohidanno bi7ide wode un tamaarikaayze cer asi maaqqidanno qoppii gaama nashshida; un Yesuusara yezanno erida. ");
INSERT INTO oydl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mahi faxide atstse Phexiroosaran Wahannisara eqqidanno asuntsi bi7in gawude baz dhabida. ");
INSERT INTO oydl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yezin Phexiroosan Wahannisan bale kessade gaar yiizii fa gidda, ");
INSERT INTO oydl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Hyantsi asuntsalla nu akko oochcho? Un kushite oochinttide damma kille baz Yerusalaame yeze ubbuntsis qonccida. Nu yinno aachchodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yezin hyanna ohita as gidda dalggaame gaar yikkeppa hyantsi asuntsi Yesuusa suntsite mulon ohaame fanan tamaarssaame fana kayoda» ga7i zorinttida. ");
INSERT INTO oydl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Unttana xeegii, Yesuusa suntsite yikkeppa ohaame gaar woy tamaarssaame gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yezin Phexiroosan Wahannisan unttago mahi, «Xoozzes kiitinttodanippan yinttis kiitinttodannippa Xoozze tiino aanna lo77o yezako ane yin firddote. ");
INSERT INTO oydl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nu bi7idannon si7idannon ohikaayzara si7i gawudes dandda7oos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Cimuntsin worzha ahizuntsii tiinostippa miintsi kaccii unttana dakkii ashshida. Asuntsi hyanidannis Xooz galatii bonchchide gisho unttana firddodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yinna kille oochite hyarggitippa faxide atstses laytsita oytamappa aadhane. ");
INSERT INTO oydl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phexiroosan Wahannisa billinttii ammanze bagguntsago hyanggi, kahinunts hyalaquntsin cimuntsi faago gaydebaz ubba unttis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Un yinno si7ide wode fettii wozina maaqqii Xoozza hyannigaara yaga7i woossida: «Ubba Ahize Laatstsayo, salo, sa7a, abban un gidda yezanno ubba medhdhidayo, ");
INSERT INTO oydl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Neenii ne arize, nu aday Dawute doontte Geeshi Ayyaanara, «Ayhude maaqqoosuntsi akkos zuuzinggido? Worzhuntsi akkos cer zorinttido? ");
INSERT INTO oydl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sa7a kaatuntsin worzha ahizuntsi wolla Laatstsellan Tizhinttidellan denddida yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Turon, Heroodisan Phenxe Philaaxoosa Ayhude maaqqoosse asuntsaran Isra7eele asuntsara ne tizhide ne geeshi Na7ay Yesuusalla denddodes hyanna katamtte shiiqida. ");
INSERT INTO oydl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mahi neenii ne wolqqaran ne qofar oochchoda ga7i qoppii bettide baz ubba un folida. ");
INSERT INTO oydl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hyatten Laatstso, un manddizanno bo7o; nuunii ne aruntsii ne qaaltto kumutsi wozinar ohode gaar nuus wolqqa inggo. ");
INSERT INTO oydl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne geeshi oochanchchize Yesuusa suntsite hyargginttizuntsana fatstsodes, kille bazin gaama qofize baz oochinttode gaar ne kushito micco» ga7i woossida. ");
INSERT INTO oydl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Un Xooz woossidannippa suuba un shiiqide bessita en7ida. Un ubbuntsi gidda Geeshi Ayyaana kumin Xoozze qaaltto qonccizi ohida. ");
INSERT INTO oydl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ammanzuntsi ubbunts qofaran wozinaran fetto maaqqida. Un faas yeze baz ubba ta baz ga7i ohoos. Yezin faas yezanno ubba wolla maadinttane. ");
INSERT INTO oydl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hawaaruntsi Laatstse Yesuusa hyayqoppa denddidanno damma wolqqara markkidhane. Xoozii un ubbuntsis damma aadho keehatitsi inggida. ");
INSERT INTO oydl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gade maaqqin keetstsi yeze ubba bayzi birtto wolalla gaddane. Yinnii gisho ammanzunts gidda madhidhize fettin baaya. ");
INSERT INTO oydl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Birtto ki7i hawaaruntsis inggane; yinna birtto fetes fetes koshshide fana shaakkii shaakkii inggane. ");
INSERT INTO oydl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qoophiroosa gaaze besite yelinttide Yoosefa gaaze Leewe kochchappa maaqqide fete yene. E suntsito hawaaruntsi Barnnabaasa (Mintsitsize na7a) gayda. ");
INSERT INTO oydl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnnabaasa faas yeze gadito bayzi birtto ki7i hawaaruntsis inggida. ");
INSERT INTO oydl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Fettii Hananiya gaaze atstse fa machchita Saphphiirira gade bayzida. ");
INSERT INTO oydl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yinna bayzide birtippa fa machchita erizin ashshii, attidanno ki7i hawaaruntsis inggida. ");
INSERT INTO oydl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yezin Phexiroosa Hananiyago, «Ne Geeshi Ayyaana cimmode gaaran gadito bayzide birtippa shaakkii ashshode gaar Xalahe ne wozintte akkos gelido? ");
INSERT INTO oydl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Neenii bayzodannippa tiino gadize nebaz baane? Mahi ne bayzi maaqqinin miishita nebaz baane? Yeezin, yinnii gaarize baz oochchodes akkos ne wozintte qoppido? Ne Xooz tiino worddidhdhidap attin as tiino worddidhdhikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananiya yinna qaaltto si7ide gaar gol7i hyayqqida; yinno si7ide ubbuntsi damma zhashtida. ");
INSERT INTO oydl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na7atitsuntsi denddii E ahito ziidhii xaaxii kanggi moogida. ");
INSERT INTO oydl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hyaydzdzii saateppa suuba Hananiya machchita yinno erikaayzara Phexiroosa yeze besite gelida. ");
INSERT INTO oydl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phexiroosa iigo, «Yin gadito yinna birtis gammatii bayzidate? Ane taas oho» yagayda. Izan, «Yee, yinna birtis gammatii bayzida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phexiroosa maachito, «Neeran ne azinzera Laatstse Ayyaana fattanodes akkos zorinttidote? Yikke, ne azinza moogide asuntsi bale yene; nenan un bale kessoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Maachita iira Phexiroosa tohiti kale gol7i hyayqqida; shakanuntsi gelize wode hyayqqidanno denggi bale kessii, I azinze kale kanggi moogida. ");
INSERT INTO oydl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kumutsi woosa keetsitan yinno si7ide melle asunts ubba damma zhashtida. ");
INSERT INTO oydl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hawaaruntsi gaama qofize bazin kille baz asunts gidda oochchiter yene. Ubbuntsi fettii wozinar Solomone furtstsa shiiqane. ");
INSERT INTO oydl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Melle asappa fettii asin unttar maadinttodes miinggikaaya, yezin asuntsi unttana bonchchida. ");
INSERT INTO oydl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ammanze dhiiratsuntsin maachunts faydita tiinostippa gaanggite qitida. ");
INSERT INTO oydl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Yinnii gisho, asuntsi hyargganchchuntsana shanchafaran alggara tookkii Phexiroosa aadhize wode E dashita unttappa fetalla fetalla dashode gaar oge doona kessii gaddane. ");
INSERT INTO oydl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mahi gaama asuntsi Yerusalaame kale yeze katamappa hyargginttizuntsana tuna ayyaana waayitsize asuntsana ekkii ye7ine; ubbuntsin faxane. ");
INSERT INTO oydl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kahinunts hyalaqizen eera yeze Saduqaawuntsi ubba ixxera kumii hawaaruntsalla denddida. ");
INSERT INTO oydl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hawaaruntsana aykkii worzha achi keetstsa olida. ");
INSERT INTO oydl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yezin Laatstsi kiitanchcho qamma achi keetstsa furtsito bugii hawaaruntsana bale kessii, ");
INSERT INTO oydl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Hyanggi, Xoozze Keetstsa eqqii hyanna kille de7o qaaltto asuntsis ubba ohote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hawaaruntsi yinno si7ide wode wontta gooda Xoozze keetstsa gelii tamaarsse aykkida. Kahinunts hyalaqizen eera yezuntsi yi7i, Isra7eele cimuntsana ubba xeegii shiishii hawaaruntsana fa tiino ko7ode gaar wottaddaruntsana achi keetstsa kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yezin wottaddaruntsi achi keetstsite hyanggi hawaaruntsana denggikaaya. Suub maaqqii yi7i asuntsago, ");
INSERT INTO oydl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Nu hyanggize wode achi keetsiti furtsita mintstsii gorddinttin, naagizuntsi furtsite eqqiduntsana denggida. Yezin nu furtsito bugize wode gidda melle atto yezin fettii asin baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yinnii gisho, Xoozze Keetstsite wottaddaruntsana kiittize kahinunts hyalaquntsi yinno si7eze wode «Hawaaruntsalla akko hyanido?» ga7i tawida. ");
INSERT INTO oydl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ye wode fettii asi unttago yi7i, «Yikke, yin accide asuntsi Xoozze Keetstsite eqqii asuntsana tamaarssane» yaga7i unttis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Xoozze Keetstsite wottaddaruntsana kiittize fa wottaddaruntsara hyanggi hawaaruntsana ki7ida. Yezin un fana asuntsi shuchchara dhogoda ga7i zhashtide gisho unttana aaddashi ki7ida. ");
INSERT INTO oydl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Un hawaaruntsana ki7i, shiiqide shanggunts tiintte essin kahinunts hyalaqize unttago, ");
INSERT INTO oydl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Yinttana nuunii ye atstse suntsite tamaarssaame gaar mintstsii kiittikaane? Yikke, yin timirttito Yerusalaame katama ubba yeltstsida. Ye atstse shemppitis nuna galisades koyanene?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phexiroosaran hyankko hawaaruntsara unttis mahite, «Nuunii asis kiitinttodannippa Xoozis kiitinttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Masqalalla yin suxxii wodhide Yesuusa nu adunts Xoozze hyayqoppa dentsida. ");
INSERT INTO oydl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isra7eeluntsi nagarappa maaqqade gaaran un nagartta atto ga7inttode gaar Xoozii Yesuusa ahizayan ashshizaya mahi bonchchora faappa mizaqi zalar bettitsida. ");
INSERT INTO oydl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yinnis nu markka; mahi Xoozze fana kiitinttizuntsis inggide Geeshi Ayyaanan markka» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Shiiqide asuntsi yinno si7eze wode damma zhilidhdhii, hawaaruntsana wodhodes qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yezin as ubba gidda damma bonchchinttide, higge asttamaare maaqqide, Gamaaliyale gaaze fettii Farisaawuze denddii eqqii hawaaruntsana eerats gode bale kessode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yinnippa suuba, shiiqide asuntsago, «Isra7eele asuntso, hyantsi asuntsalla yin oochchodes qoppide bazitippa naaginttote. ");
INSERT INTO oydl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Akkos gayko, hyannippa tiino Tewodaasa fana, ‹Ta damma› ga7i denddin, oyddii xeet maaqqade asuntsi eera wolla maaqqida. Yezin eza wodhin eza kaallize ubbuntsi laanttin fatstsoosse as maaqqii attida. ");
INSERT INTO oydl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yinnippa suuba, asuntsi faydinttide wode Galilappa yeze Yihuda denddii gaama asuntsi fana kaallode gaar yiizida, yezin eza wodhin eza kaallize asuntsi ubba lanttida. ");
INSERT INTO oydl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hyatten ta yinttis ohine; hyantsi asuntsappa shaginttote; unttana bochchippete. Akkos gayko, hyanna qoftton hyanna oochito asi oochchizebaz maaqqiko dhaboda. ");
INSERT INTO oydl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Yezin hyanna qofttan hyanna oochita Xoozappa yi7idebaz maaqqiko, yin unttana dhabssodes dandda7oos. Turippa yin Xoozara kaccinttitera benttaame fana» yaga7i ohida. Yinnii gisho, shiiqide asuntsi Gamaaliyale zoridanno ekkida. ");
INSERT INTO oydl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hawaaruntsana hyankka faago xeegii alanggara garafizida. Yinnippa suuba, unttago, «Yesuusa suntsito lam7intsa ohippete» ga7i billii dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesuusa suntsiti gisho un borintte beezzebaz maaqqidanno erize gisho shanggunts tiinoppa ufayttitera kezida. ");
INSERT INTO oydl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Un ubba wode Xoozze keetstsan as keetstsan Yesuusa E Kiristtoosa maaqqidanno tamaarssen sabbaken ashshikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ye wode kaallizunts faydita gaanggi gaanggi hyanggodera, Girike doona ohinttize Ayhuduntsi Yihuda gidda yelintti yeze Ayhuduntsalla zuuzinggida. Akkos gayko, Girike doonara ohinttize Ayhuduntsi, «Awaras ingginttize katsite nu azinii baayze maachuntsi qohinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Taphpho lam77i hawaaruntsi woosa keetstsa as ubba xeegii, «Nu Xoozze qaala ohizanno ashshii katstsa muuzanna nuus beezoos. ");
INSERT INTO oydl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yikke, ishuntso, lo77o oochara, Geeshi Ayyaanaran cinccatitsara kumide laappun asuntsana yin giddappa doorote; nuunii unttana hyanna oochitis shuumoda. ");
INSERT INTO oydl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yezin nuunii, ubba wode Xooz woosaran qaala tamaarssera minggoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hawaaruntsi ohide ohita asuntsana ubba ufayssida. Yinnii gisho, ammanon Geeshi Ayyaana kumide Isxifaanosa, Filphoosa, Phirokoroosa, Niqaarona, Ximoona, Pharmmeenan Ayhude ammano gelii maaqqide Anxookiya Niqolawoosa doorida. ");
INSERT INTO oydl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Unttana hawaaruntsi tiino essin, hawaaruntsi unttalla kushe gaddii Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xoozze qaala dalggitter hyanggida. Yerusalaame yeze ammanzunts faydita loytsii gaanggitter hyanggida; gaama kahinuntsin ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Isxifaanosa aadho keehatitsaran wolqqara kumii asunts gidda gaama qofize bazin kille baz oochchane. ");
INSERT INTO oydl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Arotitsappa kezide Ayhude woosa Keetstsa asuntsi Qereenappan Iskkinddiriyappa Kilqiyappan Iisiyappa yi7ide fettii fettii asuntsi denddii Isxifaanosara lallida. ");
INSERT INTO oydl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yezin Isxifaanosa ohite yeze cinccatitsiton Ayyaanza un ixxodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yinna wodite un, «Musen Xoozin E cashshadera si7ida» gaaze worddo asuntsana dentsida. ");
INSERT INTO oydl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yinnii gaar yiizii asuntsana, cimuntsanan higge asttamaaruntsana eella afa dentsitsida. Isxifaanosa aykkii Shanggo tiino kanggida. ");
INSERT INTO oydl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eella afa faydide worddo markkuntsi, «Hyay atstse hyanna Geeshi Keetsiton Muse higgiton mahi mahi cazhane. ");
INSERT INTO oydl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","E, ‹Hyay Naazirete Yesuusa, hyanna Xoozze Keetsito laloda; mahi Muse nuus inggide higgito laammoda› yagaaze worddo markka essida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Shanggo shiiqite bettide asuntsi ubbanna Isxifaanosa loytsii be7ize wode E sintta kiitanchcho sino maaqqii benttida. ");
INSERT INTO oydl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kahinunts hyalaqize Isxifaanosago, «Hyanna turo?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Isxifaanosa, «Ta ishuntson, ta aduntso, si7ote! Nu aday Abrahama Kaarane yessades hyammadannippa tiino Masephexoomiya yessadera, bonchcho Xoozze ees qonccii, ");
INSERT INTO oydl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹Ne gaditippan ne iginuntsappa shaakkintti ta nena beezze sa7a qito› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ye wode Abrahama Kalddaawyane gadeppa kezii Kaarane sa7a yezida. E aday hyayqqidannippa suuba Xoozii eza hyanna sa7ite hyatte yin yezanne ki7ida. ");
INSERT INTO oydl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","E hyanna gaditippa melle atto yezin toher yedhdhize bessin Abrahamas inggikaaya. Yezin na7a eesi baayze wode Xoozii hyanna sa7ite eesin E kochchitis laattode bessi mahi inggodanno qaala gelida. ");
INSERT INTO oydl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xoozii Abrahamago, ‹Ne kochchita melle sa7a zaqqotitsa yessada; ize oyddii xeet bere un aro maaqqii aqode fanan un7inttode fana ohida. ");
INSERT INTO oydl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yezin ta ne kochchito ahize worzhuntsalla firddoda. Yinnippa maaqqii, un yinna gaditippa kezii hyanne taas goynoda› gayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xoozii Abrahama kochchita garrazinttode gaar eera caaqin, Yisaaqa yelinttide osfuntsa qammite garrazinttida. Yisaaqa Yayqooba yelida; mahi Yayqooba taphpho lam77i fa na7untsana, zartii ade maaqqiduntsana garrazida. ");
INSERT INTO oydl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Yayqooba na7untsi Yoosefa ixxii Gibxxe gade arotetsis bayzida, yezin Xoozze eera yene. ");
INSERT INTO oydl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Eza, E madhiti ubbappa kessida. Gibxxe kaat Faroona tiino saban cinccatitsin eesi inggida. Gibxxe kaati Yoosefas Gibxxe sa7an fa keetstsito ubba ahode fana adetitsi wolqqa inggida. ");
INSERT INTO oydl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Gibxxen Kanaane sa7a ubba naye gelii gaama asi waytsida. Ye wode nu aday Yayqooba na7untsi katstsa denggodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yayqooba Gibxxe sa7a katstsa yezanno si7i nu aduntsana tiino yeyga dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lam7intsa hyanggite Yoosefa fa ishuntsis fana erisida. Gibxxe kaatizen Yoosefa kochchito erida. ");
INSERT INTO oydl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yoosefa fa aday Yayqoobaran fa kara asuntsana, laappun tam ichchin asuntsana faago ye7ode gaar dakkii ki7izida. ");
INSERT INTO oydl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yayqooba Gibxxe sa7a wodhdhida; ezin E na7untsi ize hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Un ahita yinna bessitippa Seekeme tookkintti hyanggi, ize Abrahama Emoore na7untsappa gaama birara wonggide boozite mooginttida. ");
INSERT INTO oydl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Yezin Xoozii Abrahamas inggoda gaydanno folize wodita yellodes ukkide wode Gibxxe sa7a yeze nu asuntsi gaanggi gaanggi hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yinnippa suuba, Yoosefa eroosse melle kaati Gibxxe sa7a ka7itida. ");
INSERT INTO oydl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ye kaatize nu kochchito genii eerats na7untsi hyayqqode fanan unttana bale kessii olode fana nu aduntsana un7itsida. ");
INSERT INTO oydl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«Yinna wodite Muse yelinttida; E Xoozze tiino gaama lo77o bishshar yeze na7a. Fa aday keetstsa hyaydzdzii agina yellodes diccida. ");
INSERT INTO oydl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Muse kanggi hyaatsi gaxa gaddide wode Gibxxe kaat naata denggi ekkii faas na7a mahi eza dichchida. ");
INSERT INTO oydl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Muse Gibxxuntsi eratitsi ubba tamaarii oheran oocharan mintsii as maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Muses laytsita oyttam kumide wode fa ishuntsana, Isra7eeluntsana be7ades fa wozintte qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isra7eeluntsappa feta Gibxxe atstse qohodera bi7i ye Isra7eele atstsa maaddii, ye qohiza Gibxxe atstsa wodhii kushe mahida. ");
INSERT INTO oydl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muse fa ishuntsana fa baggara Xoozii ashshodes yiizanno un tiiroda gayda, yezin un tiirikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Wonttistti wode lam77i Isra7eele asuntsi fete fetera hyadhinttodera denggi unttana giigissades koyi, ‹Asuntso, yin wolis ishe; akkosi fete feta qohe?› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«Yezin fa laggiza qohize Musego, ‹Nena nuulla ahize asin daynna mahide oode? ");
INSERT INTO oydl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ne omatse Gibxxe atstsa wodhidannigaara tana wodhodes koyane?› yaga7i Muse urqqii dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muse yinno si7ide wode Gibxxeppa bettii Miidiyaame sa7a bete asi maaqqii yezitera lam77i dhiiratsi na7untsana yelida. ");
INSERT INTO oydl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Laatstse kiitanchcho oyttam bereppa suuba Siina dere kale yeze akko baayze ganasa zhil7o kube gidda eexize tama loxe gidda Muses benttida. ");
INSERT INTO oydl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muse fa bi7idanne gaama qoppii, loytsii be7ades zhil7o kube kale shiiqii yezin, Laatstse qaala, ");
INSERT INTO oydl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Taanii ne aduntsi, Abrahama Xooz, Yisaaqa Xooz, Yayqooba Xooz› yaga7itera Musego yi7ida. Muse zhashimora goqii be7ades dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«Laatstsi Musego, ‹Neenii eqqide sa7ita geeshi maaqqide gisho ne tohite yeze caammito kesso. ");
INSERT INTO oydl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taanii Gibxxe yeze ta asunts madharan firddara un7inttizanno bi7ida. Un uuftto si7i unttana ashshodes wodhdhida. Hyatte hyayga! Ta nena Gibxxe kiittoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Isra7eeluntsi hyaya Muse, ‹Nena nuulla hyalaqan daynna mahide oode?› yaga7i ixxidanno hyay atstsa zhil7o kube gidda eesi benttide Kiitanchchuntsi baggara hyalaqan ashshiza mahi Xoozii kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hyay atstse Muse Isra7eeluntsana Gibxxeppa kessii gaama qofize bazin kille baz oochchii unttana Gibxxe sa7a, Erttera Abban, akko baayze ganasa oyttam bere kaalitsida. ");
INSERT INTO oydl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«Hyay atstse Isra7eele asuntsago, ‹Xoozii tana dentsidanni fana yin kochchitii giddappa ta gaar nabe yinttis dentsoda› gayday eza Muse. ");
INSERT INTO oydl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Akko baayze ganasa shiiqide Isra7eele asuntsara yeziday, nu aduntsara yeziday Siina Derizella ees ohide kiitanchchuntsara yezide Muse eza. Yeyzi, Xoozze de7o qaala nuus inggodes ekkida. ");
INSERT INTO oydl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Yezin nu mayzuntsi Muses kiitinttodes kadhikaaya; eza ixxii suub Gibxxe maaqqades amudhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mahi Aaronan, ‹Nuna kaalitsize eequntsana nuus medhdho. Akkos gayko, hyayni nuna Gibxxeppa ki7ide Muse, wayezako nuunii eroos› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ye wode hyarina aazizi eequntsana medhdhida. Yentsi eequntsis zharsho zharshi fa kushite oochchide oochita un qoftti fana hyanide gisho ufayttida. ");
INSERT INTO oydl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yezin Xoozii unttis bantte mahida. Un salo xoolintto goynode gaar unttana olii ashshida. Nabunts maxaafite, « ‹Isra7eele asuntso, oyttam bere ubba akko baayze ganas sa7a shukkide hyarsin zharshide zharshito taas shiishidaane? ");
INSERT INTO oydl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yin, yinttis goynodes kesside Moloke dunkkaane Refaane ga7inttize yin eeqize xoolintto misile tukkida. Ta yinttana Baabilooneppa gode dakkoda› ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Nu aduntsis akko baayze ganasa markka dunkkaane yene. Ezan Xoozii Muse kiittidannigaaran eza beezidanni gaaran medhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mahi nu aduntsi yinna dunkkaantto fa aduntsappa ekkii Xoozii tiino bay7ide Ayhude maaqqoosse asunts gadito aykkide wode Iyyaasura yeyga ekkii gelida. Ye dunkkaaniza Dawute wode yellodes yinna besite yezida. ");
INSERT INTO oydl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawute Xoozappa nashshinttida. Mahi Yayqooba Xoozzes yessade keetstsi keexades Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Yezin eesi keetstsi keexxide Solomona. ");
INSERT INTO oydl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Maaqqikon, Ubbappa kattara yeze Xoozze asi keexxide keetstsa yezoos. Nabize gaydanni gaar, ");
INSERT INTO oydl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","« ‹Salo taas araata, sa7an ta tohita yedhdhize bessi. Yeezin, taas yin akko gaarize keetstsi keexxode? Woy ta shemppize besita aba? ");
INSERT INTO oydl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hyanno ubba ta kushite medhdhika?› yagayda Laatstsi. ");
INSERT INTO oydl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Yin wayde si7oosse aso? Yin wozintta Xoozze qaala ekkodes akkosi ixxido? Yin hyayta akkosi tullido? Yin, yin aduntsi gaar ubba wode Geeshi Ayyaana ixxane. ");
INSERT INTO oydl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabunts giddappa yin aduntsi bay7ikaayze oode? Xillizay yo7odanno tiinidhii ohiduntsana wodhida. Hyatte yin eza aatsii inggi wodhida. ");
INSERT INTO oydl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yin Kiitanchcho kusheppa Xoozze higgito ekkida, yezin kiitinttikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Un yinno si7ide wode fa wozintte Isxifaanosalla gaama zhilidhdhi, fa doontto dha7i manddida. ");
INSERT INTO oydl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Yezin Isxifaanosa Geeshi Ayyaanara kumii, Salo ude bi7i, Xoozze bonchchiton Yesuusa Xoozze mizaqi zalara eqqidanno bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«Yikke, taanii salo bugunttin, As Na7ay, Xoozze mizaqi zalara eqqidaya bi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Fa qaaltto dhoqi yiizii wuysittera, fa hyayito aykkii fettilla eego woxxida ");
INSERT INTO oydl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Eza katamappa gaxa kessii, shuchchara dhogida. Markkuntsi fa ma7ito fettii Saawula gaaze na7atitsi atstse kale gaddida. ");
INSERT INTO oydl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Isxifaanosa, «Ta Laatstso Yesuusa, ta shemppito ekko» yaga7i xeegodera un eza shuchchara dhogane. ");
INSERT INTO oydl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bunqqunttii, fa qaaltto dhoqi yiizii, «Ta Laatstsayo, hyanna nagartto unttis atto ga7o» yagayda. Yinno yaga7i maaqqii hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saawula Isxifaanosa wodhe qofite gelida. Ye wode Yerusalaame yeze woosa keetstsite damma bay7e denddida. Hawaaruntsap attin ammanze ubbuntsi Yihuda sa7an Samaara sa7a lalinttida. ");
INSERT INTO oydl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Fettii fettii Xooz asuntsi Isxifaanosa moogida; mahi ees damma yeekkida. ");
INSERT INTO oydl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yezin Saawula woosa keetsito lalodes koyane. Ubbunts kara wutii gelii, ammanze dhiiratsuntsanan maachuntsana gochchii kessii achi keetstsa geltsane. ");
INSERT INTO oydl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lalinttide ammanzuntsi qitide bessa ubba qaala ohine. ");
INSERT INTO oydl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filphoosa Samaara katama gelii Kiristtoosa baz asuntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gaama asuntsi Filphoosa gaydanno si7ide woden E oochchide kille bazito bi7ide woden eza akaakii si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tuna ayyaana uukki gaama asuntsappa kezida; mahi gaama tohe gundduntsin wobbuntsin bilinttida. ");
INSERT INTO oydl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yinna katamite yeze asuntsi damma ufayttida. ");
INSERT INTO oydl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yezin Simoona gaaze fettii atstse yinna katamite yene. E, Taanii damma ga7i Samaara asuntsana maridhdhitera gaama qofizittera gam77ida. ");
INSERT INTO oydl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Eeratsappa damma yellodes yeze asuntsana ubba, «Damma Xoozze wolqqita hyanno» ga7i eza si7ine. ");
INSERT INTO oydl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gaama wodeppa aykkii maridhittera Samaara asuntsana gaama qofize gisho asuntsi eza si7ine. ");
INSERT INTO oydl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Yezin Filphoosa Xoozze ka7itumon Yesuus Kiristtoosa suntsitibaz dhiiratsuntsisin maachuntsis ohin, un E baz ammanii xammaqinttida. ");
INSERT INTO oydl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mahi Simoonan fa ommite ammanii xammaqinttida. Filphoosar wolla hyanggide bessa ubba oochinttize damma kille baz bi7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalaame yeze hawaaruntsi Samaara asuntsi Xoozze qaala ekkidanno si7ide wode Phexiroosan Wahannisan unttago dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Phexiroosan Wahannisan hyanggi, ammanzuntsi Geeshi Ayyaana ekkode gaar unttis Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Akkos gayko, Samaara asuntsi Laatstse Yesuusa suntsite xalaala xammaqinttidap attin unttappa fetellan Geeshi Ayyaana hyaga wodhdhikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ye wode Phexiroosan Wahannisan fa kushito unttalla gaddin, un Geeshi Ayyaana ekkida. ");
INSERT INTO oydl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hawaaruntsi fa kushito unttalla gaddin, unttis Geeshi Ayyaana ingginttidanno Simoona bi7ide wode Phexiroosasin Wahannisas miishe ki7i, ");
INSERT INTO oydl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«Taanin ta kushito gaddize ubbuntsi Geeshi Ayyaana ekkode fana hyanna adetits wolqqito taasin inggoya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yezin Phexiroosa eego, «Ne Xoozze imotitsi miishera ekkodes qoppide gisho ne miishita neera dhabo. ");
INSERT INTO oydl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne wozintta Xoozze tiino likke maaqqikaayze gisho nees hyanne gisho woy ixa baaya. ");
INSERT INTO oydl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Yikke, hyanna ne wozina iitatitsiti gisho nagarttippa maaqqo. Ne wozintte yeze iita qoftto Xoozii atto gawude gaar Laatstsa woosso. ");
INSERT INTO oydl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Akkos gayko, neenii iita ixxeran nagara achchara yezanno ta be7ine» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoona mahi, «Yin ga7idannippa fettin tana yellaame gaar taas Laatstsa woossote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Phexiroosan Wahannisan markkidhidannippan Laatstse qaala ohidannippa suuba Yerusalaame maaqqida. Samaara yeze gaama guta Wonggele ohida. ");
INSERT INTO oydl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Laatstse kiitanchcho Filphoosago, «Denddii Yerusalaameppa Gaaza kanggize akko baayze ganasa ogizera hyanggo. Yinna ogita yeekka zalara yene» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filphoosa denddii qitida. Hinddeko gaaze Tophphe kaattis I miishito ubba naagize Tophphe asi yene. Ezin goynodes Yerusalaame yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Fara gaarella bettii, Yerusalaameppa fa sa7a maaqqitera nabe Isayaasa maxaafe nabbabane. ");
INSERT INTO oydl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Geeshi Ayyaana Filphoosago, «Ye gaarizego hyanggi E kale shiiqo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yeezin Filphoosa woxxii hyanggi yellize wode moorinnize nabe Isayaasa maxaafeppa nabbabodera si7i, «Ne nabbabizanna nees gelane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Moorinnize «Taas ohi geltsize as baayzin wayzi gelode?» yagayda. Fara gaarzella kezii bettode fana Filphoosa woossida. ");
INSERT INTO oydl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Moorinnize nabbabize maxaafe kifilize, «E duro fana shukinttodes izhinttida; Duro na7a fa isintsito meedizunts tiino si77i gaazanni fana, ezin fa doontto bugikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","E toochinttida; ees xillo firdda dhabida. E de7ita hyanna sa7itippa hyal7ide gisho E yeletuntsappa oonii ohode?» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Moorinnize mahi Filphoosago, «Nabize obaz ohe? Fa baz ohinen woy melle asi baz ohine? Taas ohoya» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filphoosa mahi, Xoozze qaala yinna besstippa aykkii, Yesuusa baz ohize Wonggele ees ohida. ");
INSERT INTO oydl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Un hyanggiter hyaatsi yeze bessa yellida. Moorinnize, «Hyaatsi hyanno bo7o; ta xammaqinttaame fana akko kayze?» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filphoosa eego, «Neenii ne kumutsi wozinappa ammaniko dandda7ane» gayda. E mahi, «Yesuus Kiristtoosa Xoozze Na7a maaqqidanno ta ammanane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gaarize eqqode fana moorinnize kiittin, lam77untsi wodhdhii hyaatstsa gelida; Filphoosan eza xammaqida. ");
INSERT INTO oydl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Un hyaatsitippa gaxa kezide wode Laatstse Ayyaana Filphoosa qoppikaayzin ekkida. Lam7intsa moorinnize Filphoosa bi7ikaaya, yezin fa ogito ufayttiter qitida. ");
INSERT INTO oydl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filphoosa Azaaxone benttida. Mahi Qisaariya ye7ode wontsis katamar wutii Wonggele markkidhida. ");
INSERT INTO oydl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ye wode Saawula Laatstsi tamaaruntsana wodhodes manddii kahinunts hyalaqizego qitida. ");
INSERT INTO oydl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Laatstse ogito kaallize dhiiratsuntsanan maachuntsana denggiko, accitera Yerusalaame ko7odes, Demasqqo yeze Ayhude woosa Keetstsis dabddaabbe xaafinttode gaar eza woossida. ");
INSERT INTO oydl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","E hyanggi, Demasqqo katama yellodes ukkodera, qoppikaayzin saloppa damma foo7o E kantte foo7ida. ");
INSERT INTO oydl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","E sa7ite gol7in, «Saawula, Saawula, akkos tana bay7e?» gaaze qaala si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saawula, «Laatstso, ne oode?» yaga7i oocida. «Taanii, ne bay7ize Yesuusa» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Laatstsi eego, «Denddii katama gelo; ne oochchodes koshshize baz ize nees ohoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saawulara ogito hyanggize asuntsi akkon ohikaayzara eqqii attida. Ootsito si7ine, yezin oona yezakon bi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saawula gol7ide bessitippa denddii be7ize wode E aafita dengganxida. Yinnii gisho, un E kushito aykkii kaalitsi Damasqqo geltsida. ");
INSERT INTO oydl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Hyaydzdzii qamma yellodes E be7ades dandda7ikaaya; akkon mu7ikaaya; uzhikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasqqo gidda fettii Hananiya gaaze Yesuusa tamaarize yene. Laatstsi qonccitsara, «Hananiya» yaga7i xeegida. Hananiya mahi, «Ta Laatstso, yoo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Laatstsii eego, «Denddii moolo ga7inttize ogito hyanggi, Yihuda keetstsa Saawula gaaze Terseseppa ye7eze atstsa koyo; Saawula hyatte woosalla yene. ");
INSERT INTO oydl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mahi Hananiya gaaze atstse gelii, Saawula lam7intsa be7ade gaar fa kushito eella gaddodera qonccitsara bi7ida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiya mahi, «Laatstso, Yerusalaame ne geeshi asuntsalla ye atstse akko gaar iita baz oochchezako ta gaama asappa si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mahi Damasqqo gidda ne suntsito xeegizuntsana ubba accodes, kahinunts hyalaquntsi ees adetits wolqqa inggidda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yezin Laatstsi eego, «Saawula Ayhude maaqqoosse asunts tiino, kaatuntsi tiinon Isra7eele asunts tiinon, ta suntsito tookkodesin taas oochchodes doorinttide miishe maaqqide gisho ne eego qito. ");
INSERT INTO oydl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Akkos gayko, ta suntsiti gisho E wantsi madha ekkodes koshshizako ta eza beessada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananiya hyanggi, keetstsa gelii, fa kushito Saawulalla gaddii, «Ta ishe Saawula, ne yi7ize ogite nees benttide E Laatstse Yesuusa, ne be7ade gaaran Geeshi Ayyaanara kumode gaar tana kiittida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ellisii, Saawula afttippa fettii quro fana yeze baz wodhdhin, Saawula lam7intsa bi7ida. Mahi denddii xammaqinttida. ");
INSERT INTO oydl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Katstsa mu7i minggida. Damasqqo gidda yeze tamaarutsara eeratsi qamma gam77ida. ");
INSERT INTO oydl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ellisii Saawula, «Yesuusa Xoozze Na7a» yaga7i Damasqqo gidda yeze Ayhude woosa keetstsa qaala tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yinno si7ize ubbuntsi qoppii, «Hyay Yerusalaame Yesuusa suntsito xeegizuntsana bay7izaya baane? Mahi hyayga yi7idanna unttana accii, kahinunts hyalaquntsi tiino kanggodes baane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yezin Saawula qaala ohera miinggiter hyanggida. Yesuusa, E Kiristtoosa maaqqidanno qonccizi ohide gisho Damasqqo gidda yeze Ayhuduntsi ees mahodebaz dhabida. ");
INSERT INTO oydl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gaama qammappa maaqqii Ayhuduntsi shiiqii, Saawula wodhodes zorinttida. ");
INSERT INTO oydl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Yezin Ayhuduntsi fana wodhodes qoppidanno Saawula erida. Un eza wodhodes qamman awaran katama furtsite naagane. ");
INSERT INTO oydl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mahi E tamaaruntsi eza qamma kanggi, gimbbe gase wulunqqera kessii daachchora ketstsida. ");
INSERT INTO oydl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saawula Yerusalaame yellide wode ammanzuntsara yellinttodes qoppida. Yezin E Kiristtoosa ammanidanna unttis turo aazanxi ixxin ees zhashtida. ");
INSERT INTO oydl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yezin Barnnabaasa Saawula hawaaruntsago kanggida. Oge Laatstsi wayzi qonccezakon ohizezako, mahi Saawula Damasqqo gidda Yesuusa suntsite zhashtikaayzara wayzi qaala ohezako unttis geeshi ohida. ");
INSERT INTO oydl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saawula Yerusalaame wutii Laatstse suntsite zhashtikaayzara qaala ohitera, hawaaruntsara wolla yezida. ");
INSERT INTO oydl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mahi Saawula Girike doona ohize Ayhuduntsara ohintti lallida. Yezin un eza wodhodes koyda. ");
INSERT INTO oydl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ammanze asuntsi yinno si7i, Saawula Qisaariya kanggi Terseese dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yihuda, Galilan Samaaran ubba gidda yeze woosa keetsita sarora yezida. Mahi minggida; Laatstsis zhashtiter Geeshi Ayyaana miintsitsodera gaanggitter hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phexiroosa sa7a ubba wutii Liida yeze ammanze asuntsago yellida. ");
INSERT INTO oydl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ize osfun bere kumutsi wobbii yiitsa woy7i yeze Eeniya gaaze atstsa denggida. ");
INSERT INTO oydl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phexiroosa, «Eeniya, Yesuus Kiristtoosa nena fatstsoda; denddii ne yitsito dentso» yagayda. Ezin ellisii denddii eqqida. ");
INSERT INTO oydl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liidan Saaronan yeze asuntsi ubba Eeniya bi7i, Laatstsago maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iyoophe katama fettii Xaabito gaaze ammanzanna yene. (Xaabito ga7inttizanna gen77e ga7intte) Iza fa yezide wodite ubba lo77o baz oochiteran dahuntsana maaddite yezida. ");
INSERT INTO oydl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ye wode iza hyargginttii hyayqqin, asuntsi I ahito meeccii, fooqella kessii woytstsida. ");
INSERT INTO oydl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liida Iyoophes kale. Ammanzuntsi Phexiroosa Liida yezanno si7i, «Woy7a nuugo ellisii yo7o» yagaaze kiita lam77i asara eego kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yinnii gisho, Phexiroosa denddii, unttara qitida. Yeyga yellin, fooqella yeze kifilite eza geltsida. Azini baayze maachuntsi Phexiroosa kantte eqqii yeekkitera Dorqqa unttara faxa yezitera oochchide qamistton afultto ubba Phexiroosa beezida. ");
INSERT INTO oydl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phexiroosa unttana ubba bale kessii, bunqqunttii Xooz woossida. Mahi ahitigo maaqqii, «Xaabite, denddo» yagayda. Xaabita fa aafto bugii Phexiroosa bi7i, denddii bettida. ");
INSERT INTO oydl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phexiroosa izo fa kushite katizii dentsii essida. Yinnippa maaqqii, ammanzuntsanan azinii baayzuntsana xeegii, un tiino shiishida. ");
INSERT INTO oydl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Hyanna ohita Iyoophe katama ubba yellida. Gaama asuntsi Laatstsa ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phexiroosa Iyoophe Simoona gaaze qole hyaashize kara gaama wode gam77ida. ");
INSERT INTO oydl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qisaariya, «Xaaliya ola asuntsana» ga7inttize olinttizunts gidda fettii Qornneliyoosa ga7inttize mato hyalaqa yene. ");
INSERT INTO oydl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Qornneliyoosa fa kara asuntsara Xooz goynizen zhashtize asi, dahuntsanan maaddane, mahi ubba wode Xooz woossane. ");
INSERT INTO oydl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Fettii wode uddufun saate kumizin Xooz kiitanchcho eego yi7i, «Qornneliyoosa» ga7i xeegodera E qonccitsara geeshi bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qornneliyoosa zhashtii Kiitanchchiza dakkii loytsii bi7i, «Laatstso, yinna akko?» yagayda. Kiitanchchize mahi, «Ne woositan dahuntsana ne maaddidanna Xoozze tiino qofinttes yellida. ");
INSERT INTO oydl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hyatte asuntsana Iyoophe dakkii, Phexiroosa gaaze Simoona ki7izo. ");
INSERT INTO oydl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Phexiroosa abba gaxa qole hyaashize Simoona kara zaqqottetsi bettida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qornneliyoosa faas ohide kiitanchchize qitin, fa aruntsappa lam77untsana Xooz goynize fa kale wottaddaruntsappa feta xeegii, ");
INSERT INTO oydl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","unttis ohi Iyoophe kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wonttisti wode un hyanggi, Iyoophe katama ukkodera izipun saate gaar yezin Xooz woossodes Phexiroosa fooqella kezida. ");
INSERT INTO oydl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","E naydhdhii katstsa maades koyda, yezin katstsa kaxxodera E ayyaanara maaqqii qonccitsi bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Salo bugunttin, damma afula aazize baz oyddii zalara aykkinttii wodhdhodera E bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iza besite oyddii tohera yeze gurdde xootsi, sazara gochinttize medhetitsin salo landda ubba yene. ");
INSERT INTO oydl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ye wode «Phexiroosa, denddii eqqii shukkii mo7o» gaaze qaala eego yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yezin Phexiroosa, «Laatstso, ade! Ta tuna baz mulon mu7i eroos» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mahi, «Xoozii geeshidanno ne tuna ga7ippe» gaaze qaala lam7intsa eego yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yinnan, hyaydzdzii tohe yi7idannippa maaqqii ye damma afula aazize ellisii ude salo ekinttida. ");
INSERT INTO oydl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phexiroosa fa be7eze qonccitsiti bilitsita, «Akko maaqqad yessa?» ga7i fa wozintte qoppodera, Qornneliyoosa kiitteze asuntsi Simoona kara oocii denggi bale eqqida. ");
INSERT INTO oydl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Fa qaaltto un dhoqi yiizii, «Phexiroosa gaaze Simoona zaqqotits yeze hyanne yene?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phexiroosa qonccitsara bi7idanno tawodera, Geeshi Ayyaana eego, «Hyaychche, hyaydzdzii asuntsi nena koyane. ");
INSERT INTO oydl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Denddii wodhdho, ta unttana kiitteze gisho so7ikaayzara unttara qito» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phexiroosa asuntsago wodhdhii, «Yin koyze tana; akkos yi7idote?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Un mahi, «Nuna mato hyalaqize Qornneliyoosa kiittida. E xillo, Xooz goynize asin Ayhude asunts gidda ubba gaama bonchchinttide asi. Qornneliyoosa, nena fa kara ki7izii qaala neeppa si7ode fana geeshi kiitanchcho ees ohida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phexiroosa asuntsana kara geltsii mokkida. Wonttisti wode, denddii unttara qitida. Yoophe katama yeze ammanzuntsappa fettii fettii asunts eera wolla qitida. ");
INSERT INTO oydl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wonttistti wode, Qisaariya yellida. Qornneliyoosa fa iginuntsanan fa kale lagguntsana fettilla xeegii shiishii, Phexiroosa naagane. ");
INSERT INTO oydl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phexiroosa kara gelodes yi7adera, Qornneliyoosa eera yellintti E tiino gol7i ees goynodes koyda. ");
INSERT INTO oydl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Yezin Phexiroosa, «Denddo, taanin ta ommite ne gaar asi» yaga7i eza dentstsida. ");
INSERT INTO oydl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phexiroosa Qornneliyoosara ohitera kara gelize wode gaama asuntsi shiiqidanno denggida. ");
INSERT INTO oydl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","E asuntsago, «Ayhude asi melle worzhara wolla maaqqades woy yellinttodes woga baayzanno yin erane. Yezin taanii ooden tuna woy geeshi ga7aame gaar Xoozii tana beezida. ");
INSERT INTO oydl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yinnii gisho, yin taago kiittin ixxikaayzara yi7ida. Hyatte tana akkos xeegizezako taas ohote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qornneliyoosa, «Taanii hyayno oyddii qammappa tiino hyannii wode uddufun saate woosa woossodera, foo7ize ma7o ma77ide asi ta tiino eqqida. ");
INSERT INTO oydl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","E taago, ‹Qornneliyoosa, Xoozii ne woosito si7ida, neenii dahuntsana maaddidanno qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Yikke, asi Yoophe kiittii, Simoon Phexiroosa gaazaya xeegizo. E, Simoona gaaze qole hyaashize atstse kara abba gaxa bettida› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yinnii gisho, ta neego ellisii kiittida; ne yi7idanna lo77o. Yikke, Xoozii nena Kiittidebaz ubba si7odes hyatte nu ubbuntsi hyanne Laatstse tiino yene» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kaallii, Phexiroosa, «Xoozii asis sino bi7i asi asappa shagoos. ");
INSERT INTO oydl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Yezin asi ubba oona maaqqikon faas zhashtizayan xillo oocha oochchizella Xoozii ufayttizanno ta turo qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xoozii, ubbuntsi Laatstsii maaqqide Yesuus Kiristtoosa baggara sarotitsi ohitera hyanna wonggeltto Isra7eele asuntsis kiittezanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wahannisa xinqqate baz sabbakide wodeppa aykkii Galilan Yihuda sa7a ubba yellodes hyanidanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xoozii Naazirete Yesuusa Geeshi Ayyaanara tizhii wolqqa inggida. Xoozii eera yeze gisho lo77o baz E oochchitera Xalahe kushe aqiduntsana ubba fatstsitera wutida. ");
INSERT INTO oydl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Ayhude sa7an Yerusalaame E oochchide ubbabazitis nu markka. Un masqalalla suxxii eza wodhida. ");
INSERT INTO oydl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yezin Xoozii hyaydzdzintsa wode hyayqoppa eza dentsii asuntsis qonccode gaar yiizida. ");
INSERT INTO oydl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Yinna qonccitsita Xoozii tiino dooride markkuntsis fattin as ubbas maaqqoos. E hyayqoppa denddidannippa maaqqii eera mu7i uzhida. ");
INSERT INTO oydl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nu Wonggele asuntsis ohode gaaran faxa yezuntsallan hyayqqiduntsalla firddodes Xoozii shuumide Yesuusa maaqqizanno markkidhade gaar nuna kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Xoozii eza ammanize ubba nagartta, E suntsite atto ga7inttizanno nabuntsi markkidhane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phexiroosa hyaga yinna ohito hyaasikaayzin qaala si7ize ubbuntsalla Geeshi Ayyaana wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Phexiroosara Yoopheppa yi7ide ammanize garrazinttide Ayhude ubbuntsallan, Ayhude maaqqoosuntsallan Geeshi Ayyaana wodhdhidanno bi7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Akkos gayko, un melle melle doonara ohiteran Xoozze dammatitsito sabbodera si7ida. Ye wode Phexiroosa mahi, ");
INSERT INTO oydl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Hyantses mahi nu gaar Geeshi Ayyaana ekkiduntsi xammaqinttaame gaar hyaatsi kayode oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Un Yesuus Kiristtoosa suntsite xammaqinttode gaar unttana kiittida. Yinnippa maaqqii, un faara eerats wode bettode gaar Phexiroosa woossida. ");
INSERT INTO oydl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Hawaaruntsin Yihuda yeze ammanzuntsi, Ayhude maaqqoosuntsin Xoozze qaala ekkidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phexiroosa Yerusalaame qitide wode garrazinttide ammanzuntsi, ");
INSERT INTO oydl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","eego, «Ne garrazinttikaayzuntsago gelii unttara katstsa akkos mu7ido?» ga7i lallida. ");
INSERT INTO oydl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yezin Phexiroosa hyanidanno tiinoppa aykkii tarar tarar ohida: ");
INSERT INTO oydl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Taanii Yoophe katama Xooz woossittera qonccitsi bi7ida. Damma afula aazize baz oyddii zalara aykkinttii saloppa wodhdhitera taago yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Taanii dakkii loytsii E gidito be7ize wode oyddii tohera yeze gurdde xootsuntsi, sazara gochinttize medhon salo landduntsana bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹Phexiroosa, denddii, shukkii mo7o› gaaze qaala si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Yezin taanii, ‹Laatstso, ade, tuna baz woy geezhikaayzebaz mulon doonago shiishii eroos› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","« ‹Xoozii geeshidanno neenii tuna ga7ippe› yagaaze qaala lam7intsa saloppa yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«Yinna hyaydzdzii tohe hyanidannippa suuba, maaqqii ubba bazita salo ude ekinttida. ");
INSERT INTO oydl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yinna saate hyaydzdzii asuntsi Qisaariyappa taago kiitinttii ta yeze keetstsite yellida. ");
INSERT INTO oydl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","So7ikaayzara unttara qitode gaar Ayyaana taas ohida. Mahi hyanna izippun ishuntsi Yoopheppa taara Qisaariya hyanggiduntsara Qornneliyoosa kara gelida. ");
INSERT INTO oydl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kiitanchcho E kara eqqii, ‹Yoophe kiittii Phexiroosa ga7inttize Simoona xeegizo. ");
INSERT INTO oydl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nenan ne kara as ubba ashshize qaala E nees ohoda› gaydanno Qornneliyoosa nuus ohida. ");
INSERT INTO oydl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Taanii ohe aykkize wode Geeshi Ayyaana tiino nuulla wodhdhidannigaara unttallan wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ye wode ‹Wahannisa hyaatsara xammaqida, yezin yin Geeshi Ayyaanara xammaqinttoda› yagayde Laatstse qaaltta taas tiirinttida. ");
INSERT INTO oydl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Xoozii nuus Laatstse Yesuus Kiristtoosa ammanzuntsis inggide imotitsito mahi izo Ayhude maaqqoosuntsisin inggiko, yeezin Xooz kayodes ta oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Un yinno si7ide wode fa lallizanno ashshii, «Yinno maaqqiko, Xoozii Ayhude maaqqoosuntsin nagarappa maaqqii de7o yessade gaar ixa inggida» yaga7i Xooz galatida. ");
INSERT INTO oydl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isxifaanosa hyayqos yeltside bay7e gisho lalinttide ammanzuntsi qaala Ayhudunts xalaalas ohitera Siroofinqe, Qoophiroosan Anxookiyan yellodes wutida. ");
INSERT INTO oydl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Yezin Qoophiroosappan Qereenappan yi7ide fettii fettii ammanize asuntsi Anxookiya hyanggi, Laatstsi Yesuusa Wonggele Girike asuntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Laatstse wolqqa unttara yene; mahi gaama asuntsi ammanii Laatstsago maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Yinna ohito Yerusalaame yeze woosa keetsita si7ide gisho Barnnabaasa Anxookiya kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnnabaasa Anxookiya qitide wode Xoozze aadho keehatitsi oocha bi7i ufayttida. Un ubbuntsi fa kumutsi wozintte Laatstse gidda miinggi yessade gaar unttana zorida; ");
INSERT INTO oydl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","yinnii gisho Barnnabaasa Geeshi Ayyaanaran ammanora kumide lo77o asi. Gaama asuntsi Laatstsa ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yinnippa maaqqii, Barnnabaasa Saawula koyodes Terseese qitida. ");
INSERT INTO oydl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ize Saawula denggide wode Anxookiya ekkii yi7ida. Barnnabaasan Saawula woosa keetstsi asuntsara fettii bere mulo bettii gaama asuntsana tamaarssida. Tamaaruntsi Anxookiya woosa keetstsa «Kiristtaane» ga7intti tiinii xeeginttida. ");
INSERT INTO oydl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ye wode fettii fettii nabuntsi Yerusalaameppa Anxookiya wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Un giddappa Agaboosa ga7inttize denddii sa7a ubba damma naye kessadanno Ayyaana wolqqara tinbbite ohida. Yinna hyanidanna Roome Kaat Qalawudiyoosa wode. ");
INSERT INTO oydl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ammanzuntsi fete fete fa wolqqiti gaar miishe kessii Yihuda yeze ammanzutsis maade dakkodes qofa accida. ");
INSERT INTO oydl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Un hyannigaara yeyzi, miishito Barnnabaasaran Saawularan woosa keetstsa cimuntsis dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ye wode Kaat Heroodisa woosa keetstsi asuntsappa bagguntsana bay7e aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wahannisa ishe Yayqooba mashshara wodhida. ");
INSERT INTO oydl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yinna Ayhuduntsana ufayssidanno bi7i, gujjii Phexiroosan aytsida. Yinna hyanidanna boora Ba7ale bonchchize qammite. ");
INSERT INTO oydl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phexiroosa aykkii accida. Faasiga bonchchize woditippa maaqqii worzhunts tiino aatsodes qoppii, oyddii oyddii wottaddaruntsi eza naagode gaar taphpho izippun wottaddaruntsis aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Yinnii gisho, Phexiroosa achi keetstsa naaginttane. Yezin woosa keetstsa asuntsi ees mintsii Xooz woossane. ");
INSERT INTO oydl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Heroodisa Phexiroosa asunts tiino shiishodannippa tiino qamma Phexiroosa lam77i zalara lam77i wottaddaruntsaran lam77i santsalaatara acinttii un gidda genttida. Naagizuntsi achi keetstsa furtsite eqqii naagane. ");
INSERT INTO oydl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tiirikaayzin Laatstse kiitanchcho benttida. Achi keetstsa foo7o foo7ida. Kiitanchchize Phexiroosa millito bochchii barkkizii, «Elle denddo» yagayda. Iira santsalaatan E kushtippa wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kiitanchchize eego, «Ne ma7ito ma77o, ne caammiton aatso» yagayda. Phexiroosa hyannigaara oochchida; kiitanchchize, «Ne laxinza ma77i tana kaallo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phexiroosa achi keetstsappa kezii kiitanchchiza kaallida. Ees qonccitsi be7izegaara yi7idap attin kiitanchchize oochchize bazita turo aazikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kiitanchchizen Phexiroosan tiinon lam7intsa naagize zabiza aadhii katama kanggize birita furtsitigo yellida. Furtsita unttis fa faas erii bugunttida. Un kezii fettii ogera hyanggodera kiitanchchize tiirikaayzin Phexiroosappa shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Phexiroosas wozintta maaqqin, «Tana Laatstsi fa Kiitanchchiza dakkii, Heroodisa kushtippan naagii bettide Ayhude asunts ubbappa ashshidanno hyatte turo erida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","E yinno akaakide wode gaama asuntsi wolla shiiqii Xooz woossize besite, Marqqoosa gaaze Wahannisa intta Mayrami kara qitida. ");
INSERT INTO oydl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ize bale eqqii xeegida. Fettii Rooda ga7inttize arita furtsito bugodes yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rooda Phexiroosa qaala maaqqidanno eride wode ufayssar kumii bale bugikaayzin suub woxxii hyanggi, «Phexiroosa bale eqqida» yaga7i asuntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Asuntsi iigo, «Ne zhaashtane!» yagayda. Rooda Phexiroosa maaqqidanno geeshi ohida. Un, «Ye E kiitanchcho» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yezin Phexiroosa bale eqqii xeegii ashshanxin asuntsi furtsito bugii eza bi7i gaama qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yezin un si77i gawude gaar Phexiroosa fa kushite mallii Laatstsi achi keetstsappa eza wayzi kessezako unttis qonccizi ohi, «Hyanno Yayqoobasin ammanze asuntsis ohote» ga7i izip kezii melle bessa qitida. ");
INSERT INTO oydl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sa7a wonttize wode «Phexiroosa aba qitido?» ga7i wottaddaruntsi wol gidda gaama kacinttida. ");
INSERT INTO oydl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroodisa Phexiroosa koyzin, E dhabide wode naagizuntsana qurii, unttana wodhode gaar kiittida. Yinnippa suuba, Heroodisa Yihudappa Qisaariya wodhdhii ize eerats wode bettida. ");
INSERT INTO oydl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroodisa Xiroosa asuntsallan Sidoona asuntsalla gaama kaccida. Un wolla fettilla yi7i kaat moorinna Bilasxoosa maadinttode gaara woossii yee7e ga7izii faas cima mahi giigodes Heroodisago hyanggida. Un gadita katstsa kaatize gadeppa denggane yeshsha. ");
INSERT INTO oydl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Heroodisa shuuminttide wode fa ka7itumo afultto ma77i, araatalla bettii asuntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Asuntsi, «Yinna Xoozze qaala, as qaala baaya» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Heroodisa Xooz bonchchikaayze gisho iira Laatstse kiitanchcho eza guuddin zaqilara mu7intti hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yezin Xoozze qaala dicciteran dalggitera hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnnabaasan Sawulan fa oochito faaddii Marqqoosa gaaze Wahannisa faara ekkii Yerusalaamep maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anxookiya yeze woosa keetstsa nabuntsin asttamaaruntsin yene. Un Barnnabaasa, Kartsi ga7inttize Simoona, Qereenappa yi7ide Lukiyosa, Kaat Heroodisara diccide Minaahenen Saawulan. ");
INSERT INTO oydl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Un Laatstsi goynoderan xoomodera Geeshi Ayyaana, «Taanii xeegide oochitis Barnnabaasan Sawulan taas shaakkote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Yinnii gisho, un xoomidaanippan woossidannippa maaqqii fa kushito unttalla gaddii dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yinnii gisho, Geeshi Ayyaana unttana kiittida. Selewuqe hyanggida; iippa markkabe gidda gelii Qoophiroosa hyaatsara teqinttide sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Un Silmmaana yellii Ayhude woosa keetstsa Xoozze qaala ohida. Wahannisa maadditera unttara yene. ");
INSERT INTO oydl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Un Qoophiroosa hyaatsara teqinttide sa7a aadhii Phaafu yellize wode fettii worddo nabe Bar-Yesuusa gaaze Ayhude maro denggida. ");
INSERT INTO oydl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ye marize worzha ahize Sarggiyoosa Phawuloosa gaaze qofara yeze atstsera yene. Sarggiyoosa Phawuloosa Barnnabaasan Sawulan faago xeegii Xoozze qaala si7odes koyda. ");
INSERT INTO oydl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yezin Girike doonara marizay suntsitan «Elmmaasa» ga7inttane. E gade ahize ammanaame gaar kayodes koyi Barnnabaasan Phawuloosan ixxida. ");
INSERT INTO oydl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yezin Phawuloosa gaaze Saawula Geeshi Ayyaanara kumii marizaya dakkii bi7i, ");
INSERT INTO oydl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Naate, Xalahe na7ayo, iitatitsi ubba kumidayo, xillotitsi ubbas morkkizayo, luule Laatstse ogito mirqqizanno ashshoso? ");
INSERT INTO oydl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Yikke, hyatte Laatstse kushe neella yene. Ne qooqe maaqqada; eerats wodes awa foo7o ba7aama» yagayda. Iira qayqayon dhuman E aafto goozin, fa kushito aykkii kaalitsize as koyitera wutida. ");
INSERT INTO oydl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gade ahize yinno bi7ide wode Laatstse baz tamaarssizanne gaama qoppii ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phawuloosan eera yezuntsi Phaafuppa denddii, Phinfiliya yeze Phergge markkabera qitida. Wahannisa unttappa shaakkintti Yerusalaame maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yezin un Pherggeppa aadhii Phisidiya yeze Anxookiya yellida. Sambbata wode Ayhude woosa keetstsa gelii bettida. ");
INSERT INTO oydl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muse higgiton nabunts maxaaftan nabbabinttidannippa maaqqii Ayhude woosa Keetstsi hyalaquntsi, «Nu ishuntso, asi mintsitsize qaala yinttis yezako asuntsis ohoyate» ga7i unttago kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phawuloosa denddii eqqii fa kushtira mallitera, «Isra7eele asuntsis, mahi Xooz goynize Ayhude maaqqoosse asuntso, si7ote. ");
INSERT INTO oydl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hyantsi Isra7eele asunts Xoozze, nu mayzuntsana doorida. Gibxxe sa7a zaqqotitsa un yessadera, unttana gaantsi fa damma wolqqara Gibxxe sa7appa unttana kessida. ");
INSERT INTO oydl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Akko baayze sa7a oyttam bere gaar unttana dandda7ida. ");
INSERT INTO oydl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaane sa7a Ayhude maaqqoosse laappun ka7itumo kayi un gadito fa asuntsana laattizida. ");
INSERT INTO oydl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Yinna ubba hyanidannippa oyddii xeet ichintam bere maaqqida. Yinnippa maaqqii Saamu7eela wode yellodes ahize daynna unttis inggida. ");
INSERT INTO oydl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yinnippa maaqqii, un faas kaati inggode gaar woossin, Xoozii Biniyame kochchappa Qiise na7a, Saawula oyttam bere ka7itode gaar unttis inggida. ");
INSERT INTO oydl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xoozii Saawula shaaridannippa maaqqii unttalla Dawute ka7itsida. Xoozii Dawutebaz markkidhite, ‹Ta wozintti gaar maaqqidaya ta qoftto ubba oochchiza Issey na7a Dawute denggida› gayda. ");
INSERT INTO oydl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Xoozii, taanii Dawute kochchappa Isra7eele asuntsana ufayssiza ko7oda gaydanni gaar Yesuusa ki7ida. ");
INSERT INTO oydl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuusa yo7odannippa tiino Isra7eele asuntsi ubba fa nagarttippa maaqqii xammaqinttode gaar Wahannisa qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Mahi Wahannisa fa oochchito folodes yi7ite asuntsago, ‹Tana oona ga7i qoppete? Taanii yin naagize Kiristtoosa baaya, yezin ta E caamma billodes taas beezoosse taappa suubite ye7ine› gayda. ");
INSERT INTO oydl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Ishuntso, Abrahama kochchuntso, mahi hyanne Ayhude maaqqikaayzara Xoozis zhashtizuntso, hyanna ashshize qaaltta nuus kiitinttida. ");
INSERT INTO oydl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Akkos gayko, Yerusalaame yeze asuntsin un hyalaquntsi Yesuusa erikaaya. Sambbata ubbanne nabbabinttize nabunts qaaltto tiirikaayze gisho ezalla firddi nabuntsi ohide qaaltto folida. ");
INSERT INTO oydl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yesuusa wodhissades fettii miknaaten benttaanxin Philaaxoosa eza wodhodes inggode gaar woossida. ");
INSERT INTO oydl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Un Yesuusa baz Geeshi Maxaafite xaafinttidanno ubba folide wode masqalappa eza ketstsii moogida. ");
INSERT INTO oydl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Yezin Xoozii hyayqoppa Yesuusa dentsida. ");
INSERT INTO oydl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yinnippa maaqqii, E faara Galilappa Yerusalaame yi7iduntsis gaama qamma benttida. Un hyatte E baz asuntsis markkidhane. ");
INSERT INTO oydl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Xoozii nu aduntsis inggoda gayde Wonggele nuunii yinttis ohine. ");
INSERT INTO oydl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dawute fa Mazmure Maxaafite lam7intsa zofantte, « ‹Neenii, ta Na7aya, ta hyayno nena yelida› ga7intti xaafinttide Yesuusa, Xoozii hyayqoppa dentsii nu mayzuntsis inggoda gaydanno nuus un na7untsis folida. ");
INSERT INTO oydl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E wooqaame gaar Xoozii hyayqoppa eza dentsite erisodes, « ‹Taanii Dawutes inggoda gayde ammaninttide geeshi anjjo yinttis inggoda› yaga7i ohida. ");
INSERT INTO oydl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Yinnii gisho, Mazmure Maxaafite melle bessa mahi, « ‹Ne Geeshize ahito wooqqizoos› gayda. ");
INSERT INTO oydl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Dawute fa wode Xoozze qoftto folidannippa maaqqii hyayqqii fa aduntsara mooginttii wooqqida. ");
INSERT INTO oydl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Yezin Xoozii hyayqoppa dentsiday wooqqikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Yinnii gisho, ta ishuntso, nagara ashshize Yesuusa zalara tiinidhdhii yinttis ohinttidanno erote. Muse higgita nagarappa xillissades dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Yezin Yesuusa ammanze ubbuntsi nagarappa xillane. ");
INSERT INTO oydl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Yinnii gisho, nabuntsi gaydanna yinttana yellaame fana naaginttote. ");
INSERT INTO oydl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","« ‹Xoozii gaydebaz leqqizuntso! Bo7ote! Gaama qoppote! Dhabote! Ooden ohin, yin ammanoose oocha ta yin wodite oochchoda› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phawuloosan Barnnabaasan Ayhude woosa keetstsappa kessadera, kaallize Sambbata yinno gujjii ohode gaar asuntsi unttana woossida. ");
INSERT INTO oydl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shiiqita lanttidannippa maaqqii gaama Ayhuduntsin Ayhudunts ammantte gelii Xooz goynize gaamuntsi Phawuloosan Barnnabaasan kaallida. Ammaniduntsii Xoozze aadho keehatitsite mintstsii yessade gaar unttana zorida. ");
INSERT INTO oydl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lam7intsa Sambbata katama yeze asuntsappa attide baaya yagawude wontsis Xoozze qaala si7odes shiiqida. ");
INSERT INTO oydl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yezin Ayhuduntsi gaama asuntsana be7eze wode Phawuloosa antsinttii E ohito ixxii eza cazhida. ");
INSERT INTO oydl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Phawuloosan Barnnabaasan zhashtikaayzara, «Xoozze qaaltta tiinidhdhii yinttis ohinttodes beezane. Yezin yin qaala ixxii medhina de7o ekkodes nuus beezoos ga7i yin, yin ommite firddide gisho yikke nuunii Ayhude maaqqoosuntsago maaqqada. ");
INSERT INTO oydl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Akkos gayko Laatstsi, « ‹Alame kumutsita ne baggara attode gaar, ta nena Ayhude maaqqoosse asuntsis foo7o mahida› ga7i nuna kiittida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayhude maaqqoosuntsi yinno si7ide wode ufaytti Xoozze qaala bonchchida. Mahi medhina de7oos doorinttide ubba ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Laatstse qaaltta yinna sa7ito ubba yellida. ");
INSERT INTO oydl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Yezin Ayhuduntsi, Ayhude maaqqoosse Xooz goynize bonchchinttide maachuntsanan katama yeze damma asuntsana Phawuloosallan Barnnabaasallan dentsitsida. Yentsi asuntsi unttana bay7e aykkii fa sa7itippa kessida. ");
INSERT INTO oydl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Yezin Phawuloosaran Barnnabaasaran ixxizuntsis malla maaqqade gaar fa tohitippa xura fixxii Iqooniyone katama qitida. ");
INSERT INTO oydl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mahi Anxookiya yeze ammanzuntsi Geeshi Ayyaanaran ufayssara kumida. ");
INSERT INTO oydl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kasennigaara, Phawuloosan Barnnabaasan Iqooniyonen Ayhudunts woosa keetstsa gelii gaama Ayhuduntsin Ayhude maaqqoosuntsi ammanode wodes qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Yezin ammanikaayze Ayhuduntsi, Ayhude maaqqoosutsi wozintto laammii ishuntsalla dentsitsida. ");
INSERT INTO oydl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hawaaruntsi ize gaama wode gam77ida. Un zhashtikaayzara Laatstse baz ohida. Laatstsii mallan kille baz un oochchode gaar unttis adetits wolqqa inggi fa aadho keehatitsi qaaltta turo maaqqizanno beezida. ");
INSERT INTO oydl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yezin yentsi katama asuntsi shaakkintti, baggita Ayhuduntsara baggita mahi Hawaaruntsara maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayhude maaqqoosuntsin Ayhuduntsin fa hyalaquntsara wolla maaqqii hawaaruntsana qohodesin shuchchara dhogodes koyda. ");
INSERT INTO oydl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hawaaruntsi yinno erii, Lisxiran Derbbe ga7inttize Liqaa7oniya katamuntsi giddan un guta yeze sa7a aachinttida. ");
INSERT INTO oydl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ize Wonggele ohida. ");
INSERT INTO oydl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yelinttidannippa aykkii lam77i tohita wobbin yedhdhii eroosse fettii asi Lisxira yene. ");
INSERT INTO oydl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ye atstsay Phawuloosa ohodera bettii si7ine. Phawuloosa eza dakkii be7ize wode faxodes ees ammano yezanno bi7i, ");
INSERT INTO oydl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","fa qaaltto dhoqi yiizii, «Moolii ne tohitira eqqo» yagayda. Yeezin, doollii denddii eqqii yedhdhe aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Phawuloosa oochchidanno asuntsi bi7i fa qaaltto dhoqi yiizii Liqaa7oniya doonara, «Eequntsi asi aazii nuugo wodhdhida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnnabaasa, «Diya» ga7i, Phawuloosa ohize waannize gisho eza, «Hermmeene» ga7i suntsida. ");
INSERT INTO oydl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamappa gaxa yeze Diya goyno keetstsa kahinzen asuntsi kormman bonchcho fudhe hawaaruntsis zharshodes koyi katama furtsa ki7ida. ");
INSERT INTO oydl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Yezin Barnnabaasan Phawuloosan yinno si7eze wode un oochchodes qoppidanno ixxii fa ma7ito feedhida. Asunts gidda woxxii gelii, ");
INSERT INTO oydl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","fa qaaltto dhoqi yiizii, «Asuntso, hyanno akkos oochchete? Nuunin yin fana asi. Hyanna fatstsoosse bazitippa salon sa7an, abba un gidda yeze ubbabazito medhdhide de7o Xoozzego yin maaqqade gaar yinttis nuunii Wonggele ohine. ");
INSERT INTO oydl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","E zaga asuntsana fa ogito yedhdhade gaar dakkii ashshida. ");
INSERT INTO oydl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yezin ira saloppa bukkizida, katstsan woder woder inggida, katstsa inggi yinttana gaama ufayssida, yeyzi yinttis lo77o baz oochchii faas markka dhabsikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hawaaruntsi yinno ga7i faas asuntsi zharshaame gaar waayi kayda. ");
INSERT INTO oydl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Anxookiyappan Iqooniyoneppan yi7ide Ayhuduntsi, asuntsana fa zala mahi shuchchara Phawuloosa dhogida. Unttis E hyayqqide gaar aazin katamappa gaxa gochchii kanggi olida. ");
INSERT INTO oydl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yezin ammanzuntsi yi7i, E kale wutii eqqezin E denddii katama gelida. Wonttisti wode Barnnabaasara wolla Darbbe qitida. ");
INSERT INTO oydl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Un Darbbe katama Wonggele ohi gaamuntsana ammanzuntsana mahidannip suuba Lisxira, Iqooniyonen Phisidiya Anxookiya maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ize ammanzuntsi ammanora miinggi yessade gaar zorii, «Xoozze ka7itumo gelodes nuunii gaama madha ekkodes beezane» yaga7i tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Mahi woosa keetstsis ommite ommite cimuntsana doorida. Xoomidannippan woossidannippa maaqqii un ammanize Laatstses un hyadarito inggidda. ");
INSERT INTO oydl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Phisidiya sa7a kantsii aadhii Phinfiliya qitida. ");
INSERT INTO oydl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pherggen qaala ohidannippa maaqqii Axaaliya qitida. ");
INSERT INTO oydl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Iippa un fa folide oochitis Xoozze aadho keehatitsitis unttis hyadara inggide Anxookiya markkabera maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anxookiya yelide wode woosa keetstsa asuntsana shiishii Xoozii unttara oochchide oochito ubba Ayhude maaqqoosse asuntsi ammanode gaar unttis wayzi furtsi bugezako ohida. ");
INSERT INTO oydl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ezin ammanzuntsara gaama wode gam77ida. ");
INSERT INTO oydl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Fettii fettii asuntsi Yihudappa Anxookiya hyanggi, «Muse wogiti gaar yin garrazinttanxiko attodes dandda7oos» ga7i ammanzuntsana tamaarsse aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Yinna Phawuloosan Barnnabaasan unttara gaama lallode gaaran kacinttode gaar yiizida. Yinnii gisho, Anxookiya yeze fettii fettii asuntsi Phawuloosaran Barnnabaasara Yerusalaame hyanggi Hawaaruntsara cimuntsara yellintti yinna ohito billode gaar qofa accinttida. ");
INSERT INTO oydl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Woosa keetsita unttana kiittin qitida. Un Finqeran Samaarera aadhittera Ayhude maaqqoosuntsi Xoozago wayzi maaqqezako ohida. Yinna ammanzuntsana ubba gaama ufayssida. ");
INSERT INTO oydl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Un Yerusalaame yellide wode woosa keetsita, Hawaaruntsin cimuntsi unttana mokkida. Xoozii unttara oochchidanno ubba ohida. ");
INSERT INTO oydl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Yezin Farisaawunts baggappa ammanide fettii fettii asuntsi denddii eqqii, «Ayhude maaqqoosse ammanize asuntsi garrazinttodesin Muse higgito naagodes beezane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hawaaruntsin cimuntsi yinno zorinttodes shiiqida. ");
INSERT INTO oydl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Gaama ohinttidannippa maaqqii, Phexiroosa denddii eqqii, «Ta ishuntso, Ayhude maaqqoosuntsi Wonggele qaala ta doonappa si7i ammanode gaar tiinidhii tana Xoozii yin giddappa dooridanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","As wozina erize Xoozze Geeshi Ayyaana nuus inggidannigaar unttisin inggi turizida. ");
INSERT INTO oydl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ammanora un wozintto geeshide gisho nu giddan un gidda shaako gaddikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Yinnii gisho, nu aduntsin nuunii tookkodes dandda7oos qambbara ammanzuntsi geetalla gaddii hyatte akkos Xooz fattanete? ");
INSERT INTO oydl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Laatstse Yesuus aadho keehatitsite un attidanni gaara nuunin attidanno ammanane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Asuntsi si77i ga7i, Barnnabaasan Phawuloosa Ayhude maaqqoosse asunts gidda un baggara Xoozii oochchide mallan kille bazi ubba ohodera si7ine. ");
INSERT INTO oydl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Un ohi hyaasidannippa maaqqii Yayqooba, «Ishuntso, ta gaazanno si7ote. ");
INSERT INTO oydl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Xoozii Ayhude maaqqoosuntsi gidda fa fa suntsito xeegize worzha doorodes koyi unttana tiino wayzi qoppezako Simoona ohida. ");
INSERT INTO oydl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nabunts qaaltta hyannira giigane. Geeshi Maxaafite, ");
INSERT INTO oydl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","« ‹Hyannippa suuba, ta maaqqada, Woddide Dawute keetsito keexxoda. Wul7inttide keetsiton mahi essoda. ");
INSERT INTO oydl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Attide asuntsi ubba taago ye7oda, ta xeegide Ayhude maaqqoosse asuntsi ubba tana koyoda. Zagappa aykkii yinna erinttode fana yiizide Laatstse, ohine› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«Yinnii gisho, ta qoftta Xoozago maaqqize Ayhude maaqqoosuntsana nuunii waaytsosako lo77o. ");
INSERT INTO oydl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Yezin un eeqas zharshinttii tunidebaz ma7aame gaar, olalaame gaar, bawuta ma7aame gaaran suutsi uzhaame gaaran ma7aame gaar unttis nuunii dabddaabbe xaafodes beezane. ");
INSERT INTO oydl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Muse higge zagappa aykkii Sambbata Sambbata Ayhude woosa keetstsa nabbabinttii katama ubba sabbakinttane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yinnippa maaqqii, hawaaruntsin cimuntsi woosa keetstsa as ubbuntsara fettilla fa gidda fa eerats asuntsana doorii Phawuloosaran Barnnabaasara Anxookiya dakkodes qofa accida. Gaama erinttide kaalitsizuntsana Barssabaasa ga7inttize Yihudan Sillaasen doorida. ");
INSERT INTO oydl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Hyannigaara ga7intti dabddaabbe unttalla dakkida: «Nu hawaaruntsin cimuntsi yin ishuntsi, Anxookiya, Sooriya Kilqiya yeze Ayhude maaqqoosse ishuntsis nu sarotits kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«Nuunii kiittikaayze asuntsi nu giddappa hyanggi, ‹Yin garrazinttodesin higgito naagodes beezane› ga7i, yinttana waaytsidannon zhilizidanno si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nuunii kadhize Barnnabaasan Phawuloosa doorinttide asuntsara wolla yinttago dakkodes fettii wozinara nu qoftto accida. ");
INSERT INTO oydl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Un nu Laatstse Yesuus Kiristtoosa gisho fa de7ito aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Yinnii gisho, nu xaafidanno un fa doonara gujjii yinttis ohode fana Yihudan Sillaasen kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","«Hyanna koshshizuntsap attin melle toofo yinttana toossame gaar nuunin Geeshi Ayyaana ohito accida. ");
INSERT INTO oydl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Eeqas zharshinttii tunidebaz mu7ippete, suutsi uzhippete, bawuta mu7ippete, olalippete. Hyantsi ubbappa yin, yin ommito naagiko lo77o baz oochchane. Lo77o yezote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yinnii gisho, kiitinttiduntsi moyzinttii Anxookiya qitii ammanze asuntsana shiishii, dabddaabbiza inggidda. ");
INSERT INTO oydl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Un ye mintsitsize dabddaabbiza nabbabide wode ufayttida. ");
INSERT INTO oydl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mahi Yihudan Sillaasen fa ommite nabuntsana maaqqide gisho ammanzuntsana loytsii zorii mintsitsida. ");
INSERT INTO oydl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Un Anxookiya eeratsi wode bettidannippa suuba ammanze ishuntsi loytsi moyzin fana kiittezuntsago maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Yezin Sillaasen ize attodes koyda. ");
INSERT INTO oydl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Mahi Phawuloosan Barnnabaasan melle gaama asuntsara wolla Laatstse qaala tamaarssitera Wonggele ohitera Anxookiya gam77ida. ");
INSERT INTO oydl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Eerats qammappa suuba Phawuloosa Barnnabaasago, «Nu Laatstse qaala ohide katamite ubba ammanizuntsi wayzi yezako suuba maaqqitera be7ada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnnabaasa Marqqoosa ga7inttize Wahannisa faara hyammade fana koyda. ");
INSERT INTO oydl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Yezin Phawuloosa Marqqoosa faara hyammade fana koykaaya. Akkos gayko, E Phinfiliya shaakkintti unttara oochchodes hyanggikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Un gidda iita kachchi kezin fetay fetayppa shaakkinttida. Barnnabaasa Marqqoosa ekkii markkabera Qoophiroosa qitida. ");
INSERT INTO oydl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Yezin Phawuloosa Sillaase doorida; ammanzuntsi Phawuloosa Xoozze aadho keehatitsi hyadarito inggidannippa maaqqii E kezii qitida. ");
INSERT INTO oydl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yeyzi, woosa keetstsi mintsitsitera Sooriyaran Kilqiyaran wutida. ");
INSERT INTO oydl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phawuloosa Darbben Lisxiran qitida. Ize Ximotiyoosa gaaze ammanize asi yene. E intta ammanze Ayhude maacho, E aday Girike asi. ");
INSERT INTO oydl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lisxiran Iqooniyone yeze ammanzuntsi Ximotiyoosa baz loytsii markkidhida. ");
INSERT INTO oydl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phawuloosa Ximotiyoosa faara ekkodes koyi, E aday Girike asi maaqqidanno yinna besite yeze Ayhude ubbuntsi erize gisho eza garrazida. ");
INSERT INTO oydl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Un katamara aadhitter Yerusalaame yeze hawaaruntsin cimuntsin accide qoftto ammanzuntsi naagode gaar unttis ohitera aadhida. ");
INSERT INTO oydl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Yinnii gisho, woosa keetsita ammanora miinggite, faydoran qammite qammite gaanggitter hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Isiya gidda qaala ohaame gaar Geeshi Ayyaana unttana kayde gisho Phirggeran Galaatiya sa7ara aadhida. ");
INSERT INTO oydl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Un Miisiya gaxa yellide wode Bitiiniya qitodes qoppida yeshsha. Yezin Yesuusa Ayyaana unttana kayda. ");
INSERT INTO oydl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Yinnii gisho, un Miisiya kalera aadhitera Xiro7aada wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Phawuloosa qamma qonccitsara fettii Maqedooniya asi faago, «Maqedooniya fiinggi nuna maaddoya» ga7i eqqii woossodera bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Qonccitsi E bi7idannippa maaqqii nu Maqedooniya qitodes koyda. Yinnan, Wonggele ize yeze asuntsis ohodes Xoozii nuna xeegida aazida. ");
INSERT INTO oydl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Xiro7aadappa denddii markkabe gidda gelii Samotiraaqe hyanggide, wonttisti wode Naaphule hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Izippa denddii Maqedooniya sa7a yeze Filphisiyusa ga7inttize worada katama hyanggida. Mahi Filphisiyusa Roomuntsi ahize katama. Nu yinna katamite eeratsi wode bettida. ");
INSERT INTO oydl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sambbata wode katamappa gaxa borkka doona Ayhuduntsi Xoozze woossize bessi yezanno qoppii ize hyanggida. Yinna besite shiiqide maachuntsis qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nuna si7ize asuntsappa fettii Liidiya ga7inttize Tiyaxiroone katamappa yi7ide, Xooz ammanze zoqo ma7o zal77ize, maachita yene. Phawuloosa ohizanno iza si7ode gaar Laatstsii I wozintto bugida. ");
INSERT INTO oydl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Liidiya fa kara asuntsara wolla xammaqinttidannippa maaqqii nuugo, «Yin tana Laatstsa turo ammanida gayko ta kara yi7i shemppote» ga7i mintsii woossida. ");
INSERT INTO oydl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nu Xooz woossize besite hyanggodera iita ayyaana iilla afa yezii maridhdhize fettii wudur arita nuura yellinttida. Iza maridhdhii gaama bira fa laatstsuntsis ke7ine. ");
INSERT INTO oydl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Phawuloosan nunan kaallii, «Hyantses Ubbappa kattara Xoozze aruntsana! Un yin attode ogito ohizuntsana» ga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ubba wode yinnii gaar gaane. Yezin Phawuloosa zhilidhdhi suub maaqqii, ye ayyaanza, «Yesuus Kiristtoosa suntsite iippa kezo» ga7i kiittida. Iira iita ayyaanze iippa kezida. ");
INSERT INTO oydl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Yezin I laatstsuntsi faas bira denggize ogita dhabidanno bi7i, Phawuloosan Sillaasen aykkii, firdda keetstsa daynnuntsi tiino gochchii kanggida. ");
INSERT INTO oydl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Daynnuntsi tiino unttana kanggi, «Hyantses Ayhude asi maaqqii nu katama asuntsana gaama waaytstsane. ");
INSERT INTO oydl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nu Roome gade asuntsi ekkodesin oochchodes woga maaqqoosse baz tamaarssane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Asuntsi fettii zala maaqqii, Phawuloosallan Sillaaselan denddida. Daynnuntsi un ma7ito gaarii gufer unttana guuddade fana kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Unttana gaama hyadhdhidannippa suuba achi keetstsa geltsida. Achi keetstsito kafizay unttana mintsii kafode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Achi keetstsito kafize yinna kiitto ekkii, Phawuloosan Sillaasen achi keetstsitis qol7a geltsida. Un tohito dutstsara accida. ");
INSERT INTO oydl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Yezin qamma bilahe maaqqize wode Phawuloosaran Sillaaseran woossitteran mazmure yexxitteran Xooz galatane. Achi keetstsite yeze melle asuntsin un gaazanno si7ine. ");
INSERT INTO oydl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Qoppikaayzin achi keetsiti sa7ita en7inttode wontsis sa7a en7ida. Yinna saatte furtsita ubba bugunttii attida; acinttide asuntsi ubbuntsi santsalaata bilinttii wodhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Achi keetstsito kafize genttoppa barkkide wode achi keetsiti furtsita ubba bugunttidanno bi7i acinttide asuntsi kessii ekkii qitide gaar aazin fana wodhodes mashsha ekkida. ");
INSERT INTO oydl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Yezin Phawuloosa fa qaaltto dhoqi yiizii «Nu ubbanna hyanne yeze gisho ne nena qohippe» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Achi keetstsito kafize xomppe woossii ekkii ellisii gidda woxxida. Goqitera Phawuloosa tiinon Sillaase tiino zuggida. ");
INSERT INTO oydl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Unttana bale kessii, «Ta laatstsuntso, ta attodes akko oochchodes beeze?» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Phawuloosaran Sillaasera eego, «Laatstsi Yesuus Kiristtoosa ammano; neeran ne kara asuntsaran attoda» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Un eesin E kara yeze ubbuntsis Laatstse qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Qamma yinna saatte achi keetsito kafize unttana kanggi un hyarggize bessito meeccida. Ellisii fa kara as ubbuntsara xammaqinttida. ");
INSERT INTO oydl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Phawuloosan Sillaasen fa kara kanggi unttis katstsa aatstsida. E fa kara asi ubbuntsara Xooz ammanide gisho ufayttida. ");
INSERT INTO oydl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sa7ita wonttin daynnuntsi, «Yentsi asuntsana billo» yaga7i foolisuntsana eego kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Achi keetsito kafize, «Yin bilinttode gaar daynnuntsi kiittida. Yikke, kezii saro qitote» yaga7i yinna kiitto Phawuloosas ohida. ");
INSERT INTO oydl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Yezin Phawuloosa yentsi foolisuntsago, «Nu Roome asi maaqqadera un nuna firdda baytsi as tiino hyadhdhii, achi keetstsa olida. Hyatte nuna aachintti kezii qito gaane? Hyanoos, un fa ommitis yi7i nuna kesso» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Foolisuntsi daynnuntsis yinno ohin, Phawuloosaran Sillaaseran Roome sa7a asi maaqqidanno si7ide wode zhashtida. ");
INSERT INTO oydl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yinnii gisho, daynnuntsi yi7i unttago, Nu yinttana qohida yaga7i maarotitsi oocida. Achi keetsitippa bale unttana kessii, katamappa kezii qitode gaar woossida. ");
INSERT INTO oydl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phawuloosaran Sillaaseran achi keetsitippa kezii Liidiya kara hyanggida. Ize ammanzuntsara yellintti unttana mintsitsii kezii qitida. ");
INSERT INTO oydl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phawuloosara Sillaaseran Amfipholisaran Apholoniyara aadhii Teselonqe qitida. Ize Ayhude woosa keetstsi yene. ");
INSERT INTO oydl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phawuloosa zaganni gaara ize gelida. Ize hyaydzdzii sambbata Xoozze qaalappa asuntsis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristtoosa madha ekkodesin hyayqoppa denddodesin beezanno unttis geeshi ohitera, «Yesuusa hyay ta yinttis ohizay Kiristtoosa» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Unttappa fete fete ohidanna turo maaqqidanno ekkii Phawuloosaran Sillaasera wolla fetto maaqqida. Yinnii fana, Xooz goynize gaama Girike asuntsin gaama bonchchinttide maachuntsin unttara wolla maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yezin Ayhuduntsi ixxii fettii fettii oocha baayze iita asuntsana ogeppa shiishida. Katamito buqe aykkida; Phawuloosan Sillaasen asuntsis aatsii inggodes koyi Iyaasone keetstsito teqqida. ");
INSERT INTO oydl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Phawuloosan Sillaasen unttis benttaanxin, Iyaasonen fettii fettii ammanzuntsana katama hyalaquntsago gochchii kanggi, «Hyantses sa7ito ubba buqizuntsi hyatte nuugo yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Iyaasone unttana fa kara gaddida. Hyantses, ‹Yesuusa gaaze melle kaati yene› ga7i Qeesare kiitto ixxane» ga7i dhoqi gayde qaalara ohida. ");
INSERT INTO oydl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Shiiqide asuntsin katama hyalaquntsi yinno si7i hyanodebaz dhabida. ");
INSERT INTO oydl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Hyalaquntsi Iyaasonan melluntsana waaser billida. ");
INSERT INTO oydl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ammanzuntsi Phawuloosan Sillaasen qammara Beeriya dakkida. Beeriya yellii, Ayhude woosa keetstsa gelida. ");
INSERT INTO oydl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beeriya asuntsi Teselonqe asuntsappa aadhii wozina dalgga. Un qaaltto kumutsi wozinappa ekkida; Phawuloosa gaydanna turo maaqqidanno shaakkii erodes ubba wode Geeshi Maxaafe nabbabane. ");
INSERT INTO oydl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yinnii gisho, unttappa gaamuntsi, Girikuntsappa bonchchinttide gaama maachuntsin gaama dhiiratsuntsii ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yezin Teselonqe yeze Ayhuduntsi Phawuloosa Xoozze qaala Beeriy giddan ohidanno si7ide wode Beeriya yi7i asuntsana buqida. ");
INSERT INTO oydl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yinnippa maaqqii, ammanzuntsi ellisii Phawuloosa abba kale dakkida. Yezin Sillaasen Ximotiyoosan Beeriya attida. ");
INSERT INTO oydl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Phawuloosa moyzide asuntsi Ateena yeltsida. Yentsi asuntsi Sillaasen Ximotiyoosan faas dandda7inttide gaar ellisii faago ye7ode gaar Phawuloosa kiitteze kiitto ekkii Beeriya maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phawuloosa Ateena Sillaasen Ximotiyoosan kafittera, katama eeqa kumidanno bi7i zhilidhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yinnii gisho, Ayhude woosa Keetsite Ayhuduntsaran Xooz goynize Ayhude maaqqoosse asuntsara mahi faara yellinttize asuntsara ubba wode gabe lallane. ");
INSERT INTO oydl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ephiqoroosan Isttoyke ga7inttize bagguntsappa fettii fettii eruntsi Phawuloosara wolla lallida. Unttappa fete fete, «Hyay canccize akko ohodes koye?» yagayda. Melluntsi Phawuloosa Yesuusan hyayqoppa denddo baz faas ohide gisho «Melle eequntsi baz ohiza aazane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Phawuloosa aykkii Aryoospaagosa gaaze shiiqo besite kanggi, «Hyanna ne tamaarssize kille bazita akko yezakon nuna eriso? ");
INSERT INTO oydl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Akkos gayko, ne nuus kille baz ohine; yikke yinna akko yezakon nu erodes koyane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateena asuntsi ubbuntsin ize yeze zaqquntsi kille baz ohikaayzaran si7ikaayzaran feezhoos. ");
INSERT INTO oydl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Phawuloosa Aryoospaagosa gidda shiiqide asuntsi tiino eqqii, «Ateena asuntso, yin eequntsis ubba baza gaama zhashtizanno ta bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Taanii yin katamara wutittera yin goynize besite be7ize wode ‹Erinttoose Xoozzes› ga7intti xaafinttide zharsho bessito denggida. Hyanna yin erikaayzara goynizaya ta yinttis ohoda. ");
INSERT INTO oydl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sa7an sa7alla yeze ubbabazito medhdhide Xoozze, salon sa7a Laatstse, asi keexxide keetstsa yezoos. ");
INSERT INTO oydl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","E de7o, shemppon ubba baz as ubbas inggide gisho face yeze asi fana as maade koyoos. ");
INSERT INTO oydl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xoozii un yessade wodesin bessis wuzula inggida. Yinnippa as kochchi ubba fettii asappa medhdhii sa7a ubba gaddida. ");
INSERT INTO oydl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","E yinno oochchidanna asi eza koyode fanan qurichchi denggode fana. Maaqqikon E nuuppa hyaako baaya. ");
INSERT INTO oydl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Yinttappa fettii fettii yexxizuntsi, ‹Nu E na7untsana› maaqqidanni fana, Nu E gidda faxa yene, en7inttane. ");
INSERT INTO oydl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yikke, nu Xoozze na7untsana maaqqide gisho ‹Xoozii as yiillatitsaran qofara worqqappa woy birappa woy shuchchappa oochinttidebaz aazane› ga7i qoppodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Yinnii gisho, Xoozii tiino wode asi erikaayzara oochchidanno ashshii aadhida, yezin hyatte ubba bessa yeze asi ubba nagarappa maaqqade gaar kiittane. ");
INSERT INTO oydl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Akkos gayko, Xoozii fa dooride atstsera sa7alla yeze asi ubballa xillo firdda firddodes qamma giigizii gaddida. Eza hyayqoppa dentsii yinno as ubbas geeshida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Unttappa fettii fettii asuntsi hyayqoppa denddebaz Phawuloosappa si7i, eza leqqida. Yezin melluntsi, «Nuunii yinno neeppa gujjii si7odes koyane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Yinnii gisho, Phawuloosa un giddappa kezida. ");
INSERT INTO oydl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yezin fettii fettii dhiiratsuntsii Phawuloosara yellii ammanida. Un giddappa Aryoospaagosan shiiqite yeze Diyonasyoosa gaaze atstse, Damariso gaaze fettii maachitan melluntsin unttara yene. ");
INSERT INTO oydl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Yinnippa suuba, Phawuloosa Ateenappa kezii, Qoronttoosa qitida. ");
INSERT INTO oydl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ize Aqiila gaaze Phanxoosa yelinttide fettii Ayhude as denggida. Ayhude asuntsana ubba Roomeppa kessade gaar kaati Qalawudiyoosa kiittide gisho eeratsi wodeppa tiino E fa machchitii Phirisqilara Xaaleppa yi7ida. Phawuloosa unttara yellinttodes hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","E oochita unttinnigaara dunkkaane sikke maaqqide gisho unttara bettii wolla oochchida. ");
INSERT INTO oydl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Phawuloosa Sambbata ubba Ayhuduntsanan Girikuntsana ammantsodes Ayhude woosa Keetstsa miinggi ohine. ");
INSERT INTO oydl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillaasen Ximotiyoosan Maqedooniyappa yi7ide wode Phawuloosa fa kumutsi wodito inggi Ayhuduntsis Yesuusa E, Kiristtoosa ga7i qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yezin un Phawuloosa ixxii eza cazhin Phawuloosa fa ma7itippa xura tiqizi, «Yin gomtta yinttana yello; ta yinne yezoos. Yikkeppa suuba, ta Ayhude maaqqoosse asuntsago qitane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Izip kezii Xooz goynize Titoos Yosxoosa gaaze atstse kara qitida. Yosxoosa keetsita Ayhude woosa Keetstsi kale yene. ");
INSERT INTO oydl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ayhude woosa Keetsiti hyalaqize Qarisphoosa fa kara asuntsi ubbuntsara Laatstsii ammanida. Qoronttoosa asuntsappa gaamuntsi Xooz qaala si7ide wode ammanii xammaqinttida. ");
INSERT INTO oydl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Laatstsii fettii qamma Phawuloosas benttii, «Zhashtippe; oho, si77i gayppe. ");
INSERT INTO oydl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Taanii neera yene. Taas hyanna katamite, gaama asi yeze gisho nena qohii iitabessa olode asi ooden baaya» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yinnii gisho, Phawuloosa Xoozze qaala asuntsana tamaarssittera fettii beren izippun agina unttara bettida. ");
INSERT INTO oydl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gaaliyoosa Akkaya sa7a ahize wode Ayhuduntsi fettilla Phawuloosalla denddii firdda keetstsa eza kanggi, ");
INSERT INTO oydl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«Hyay atstsay higge ixxii, asuntsi Xooz goynode gaar yiizane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phawuloosa ohodes yi7adera, Gaaliyoosa Ayhuduntsago, «Ayhuduntso, yinna iita oocha woy qohe maaqqiko ta yin baz dandda7i si7odes beezane. ");
INSERT INTO oydl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Yezin qaalasin, suntsisin yin higgitisin yin lallizebaz maaqqiko yin, yinttis billote; yinno ta firddoos» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yeyzi, unttana firdda keetstsappa bale kessida. ");
INSERT INTO oydl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yinnippa suuba, asuntsi ubba Ayhude woosa Keetstsa hyalaqiza Sostenisa aykkii firdda keetstsi tiino hyadhdhida. Yezin Gaaliyoosas yinna akkon aazikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phawuloosa gaama wode Qoronttoosa gidda bettidanippa suuba ammanze asuntsana sarotsi, Phirisqiliran Aqiilara markkabera Sooriya qitida. Yezin E qitodannippa tiino faas qayinggidebaz yeze gisho Kinkkiriya katama fa ommito medinttida. ");
INSERT INTO oydl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Un Efesoone yelide wode Phawuloosa Phirisqilan Aqiilan ize ashshida. Yezin faas Ayhude woosa keetstsa gelii Ayhuduntsara ohinttida. ");
INSERT INTO oydl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Un faara gaama wode bettode gaar Phawuloosa woossida yezin E ixxida. ");
INSERT INTO oydl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Unttappa shaakkinttiter; «Xoozii gayko yinttago maaqqii yo7oda» yaga7i Efesooneppa markkabera qitida. ");
INSERT INTO oydl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Qisaariya yellide wode Yerusalaame hyanggi woosa keetstsa asuntsana saritstsidannippa suuba Anxookiya qitida. ");
INSERT INTO oydl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ize eeratsi wode gam77idannippa suuba ammanize asuntsana ubba mintsitsitera Galaatiyaran Phirggeran aadhida. ");
INSERT INTO oydl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iskkinddiriya yelinttide fettii Aphiloosa gaaze Ayhude asi Efesoone qitida. E ohe erize asin Xoozze qaala gaama erize asi. ");
INSERT INTO oydl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","E Laatstsii ogito tamaarii, ayyaanara eexii Yesuusa baz luule tamaarssane. Maaqqo yezin, Wahannisa xinqqate xalaala erane. ");
INSERT INTO oydl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","E Ayhude woosa Keetstsite zhashtikaayzara tamaarssane. Phirisqilan Aqiilan E ohizanno si7ide wode eza faara kara kanggi Xoozze ogito tiinositippa geeshi ees ohida. ");
INSERT INTO oydl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aphiloosa Akkaya qitodes koyin Efesoone yeze ammanize asuntsi E qoftto ekkii Akkaya yeze ammanzuntsi eza mokkode gaar unttis dabddaabbe xaafida. E ize yelide wode Xoozze aadho keehatitsiti baggara Yesuus Kiristtoosa ammaniduntsana gaama maaddida. ");
INSERT INTO oydl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Akkos gayko, Yesuusa E Kiristtoosa maaqqizanno Ayhuduntsis Xoozze qaalappa qonccizi asunts tiino mintsii ohi unttana latstsida. ");
INSERT INTO oydl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aphiloosa Qoronttoosa yessadera, Phawuloosa wookka zalara aadhii Efesoone qitida. Izen fettii fettii ammanze asuntsana denggida. ");
INSERT INTO oydl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Unttago, «Yin ammanide wode Geeshi Ayyaana ekkidate?» ga7i oocida. Un, «Ade, ekkikaaya; melle atto yezin, Geeshi Ayyaana yezannon si7ikaaya» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phawuloosa unttago, «Yeezin, akkor xammaqinttidote?» gayda. Un, «Nuunii Wahannisa xinqate xammaqinttida» ga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phawuloosa, «Wahannisa faappa suubar ye7ize Yesuus ammanode gaar asuntsis ohiter, nagarappa maaqqes koshshize xinqate xammaqinttida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Un yinno si7ide wode Laatstse Yesuusa tamaare maaqqades xammaqinttida. ");
INSERT INTO oydl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phawuloosa fa kushito unttalla gaddize wode Geeshi Ayyaana unttalla wodhdhin, melle melle doonara wolla ohinttida; mahi tinbbite ohida. ");
INSERT INTO oydl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Yinna besite taphpho lam77i maaqqize asuntsi yene. ");
INSERT INTO oydl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phawuloosa Ayhude woosa Keetstsa gelii, Xoozze ka7itumo baz zhashtikaayzara markkidhiter loytsii qoncciziter unttara hyaydzdzii agina yellodes gam7ida. ");
INSERT INTO oydl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yezin unttappa fete fete dhube maaqqii gaama asunts tiino Laatstse ogito cazhi ammananxii ixxida. Phawuloosa ammanzuntsana unttappa shagii ekkii Xiranoosa gaaze timirtte keetstsa ubba wode unttana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Phawuloosa lam77i bere yellodes qaala ohida. Yinnii gisho, Isiya yeze asuntsi ubba, Ayhuduntsin Ayhude maaqqoosuntsi Laatstse qaala si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Xoozii Phawuloosa kushite damma kille baz oochchida. ");
INSERT INTO oydl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yinnii gisho, asuntsi E gallito bochchide maarabito woy ma7ito hyargganchchuntsis kanggane. Unttin faxane; tuna ayyaanuntsin unttappa kezane. ");
INSERT INTO oydl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tuna ayyaana kessitera wutize Ayhuduntsappa fete fete, «Phawuloosa sabbakize Yesuusa suntsite kezote ga7i yinttana kiittane» ga7i, tuna ayyaana aykkide asuntsalla Laatstse Yesuusa suntsito xeegida ");
INSERT INTO oydl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ayhude maaqqide Kahinunts hyalaqappa fettii Asqeewe gaaze atstses yinno oochchize laappun dhiiratsi na7unts yene. ");
INSERT INTO oydl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Yezin tuna ayyaanze unttago, «Taanii Yesuusan erane Phawuloosa bazin erane, yezin yin oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tuna ayyaanze aykkide atstse unttalla doollii wodhdhi, unttana hyarggizi, yinna keetsitippa kallo woxxi dhabode wontsis wolqqidhdhida. ");
INSERT INTO oydl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efesoone yeze Ayhuduntsin Ayhude maaqqoosuntsi ubba yinno si7i gaama zhashtida. Laatstsii Yesuusa suntsita gaama bonchchinttida. ");
INSERT INTO oydl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ammanzuntsappa gaamuntsi fa oochchide iita oochito buuxitera qoncce ohiter yene. ");
INSERT INTO oydl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bitizuntsappa gaamuntsi fa maxaafito shiishii as ubba tiino michchida. Yinna maxaafti waagita ichintam mukul shuchchi bira santime maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Yinnii gaar yi7i Xoozze qaala wolqqar dicciteran dalggitter qitida. ");
INSERT INTO oydl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Yinna folinttidanippa suuba Phawuloosa, «Taanii Yerusalaame qitii maaqqii Roomen hyanggodes beezane» ga7i Maqedooniyaran Akkayaran aadhii Yerusalaame hyanggodes qofa accida. ");
INSERT INTO oydl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Mahi fana maaddizuntsappa lam77untsana Ximotiyoosan Erasxoosa Maqedooniya kiittii, faas Isiya gidda eerats wode gam7ida. ");
INSERT INTO oydl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ye wode Laatstse ogiti gisho Efesoone gidda damma kachchi kezida. ");
INSERT INTO oydl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Fettii bira qoxxize Dimexiroosa gaaze atstse Arxemiisa eeqa keetstsa misile birappa medhdhii gaama tirfe dinggizanne. ");
INSERT INTO oydl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yinnii gisho, yinnii fana oocha oochchizuntsana fettilla shiishii, «Asuntso, nu duretitsita hyanna oochite maaqqidanno yin erane. ");
INSERT INTO oydl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hyay Phawuloosa, ‹As kushe medhinttide eequntsana baane› ga7i, Efesoonen eeratsi sa7ap attin kumutsi Isiya ubba yeze gaama asuntsana ohi ammantsidannon balitsidannon yin bi7ida si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Madha maaqqidanna, nu oochita leqqinttizanno xalaala maaqqikaayzin Isiya sa7a ubba yeze asi goynize damma eeqa Arxemiisa keetsita bonchchinttikaayzar attodanna I dammatitsita gol7odanno» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Asuntsi yinno si7eze wode zhilidhdhi, «Efesoone Arxemiisa damma» ga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Yinna uufita katama ubba yellida. Phawuloosara yedhdhize Maqedooniya asuntsana, Gaayoosan Arsxirokoosan aykkii gochchiter kaa7ize bessa woxxida. ");
INSERT INTO oydl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phawuloosan asuntsi shiiqide besite gelodes koyda, yezin ammanzuntsi eza kayda. ");
INSERT INTO oydl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Isiya sa7a hyalaquntsappa Phawuloosa lagge maaqqide fete fete Phawuloosago kiittii, «Kaasi besite qoncce kezii benttippe» ga7i eza woossida. ");
INSERT INTO oydl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Shiiqide asuntsi hyanodebaz dhabida; gaanggize bagga asuntsi melle atto yezin akkos shiiqezako eroosse gisho fete fettibazis uukkize wode hyankkay mellebazis uukkane. ");
INSERT INTO oydl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayhuduntsi Iskkinddire gaaze atstsa aatsii beezin, fettii fettii asuntsi E gawude baz ohi eza tiino aatsida. E asuntsi si77i gawude gaar fa kushite mallii beezi, asuntsis mootinttodes eqqida. ");
INSERT INTO oydl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Yezin Iskkinddire Ayhude asi maaqqidanno asuntsi eride wode lam77i saate maaqqade gaar ubbuntsi fettii qaalara, «Efesoone Arxemiise damma» ga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wurssutsite Katama xaafize asuntsana si77i yiizii, «Efesoone asuntso! Efesoone katama damma Arxemiise eeqa keetstsin saloppa wodhdhide damma shuchchiza naagizanno eroosse asi baaya. ");
INSERT INTO oydl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hyanno kaddize asi baayze gisho yin si77i ga7odesin ellisii akko baz yiizaanxxi ashshodes beezane. ");
INSERT INTO oydl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Yin hyantsi asuntsana, eeqa keetstsa bira kaystikaayzuntsanan nu Xoozza cazikaayzuntsana ki7i. ");
INSERT INTO oydl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yinnii gisho, Dimexiroosan eera yeze oochchize asuntsi mootodes oona koyzako, firdda keetsita bugutsi yene; daynnuntsin yene; un mootodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Yezin yin melle ohe koyko, Shanggo shiiqite ohita bi7intto. ");
INSERT INTO oydl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yinno maaqqanxiko hyayno hyanide bazis Roome ka7itumtta nuna oocoda. Hyanna buqutsitis miknaate baayze gisho nu mikinaato ohodes dandda7oos» ");
INSERT INTO oydl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","yaga7i shiiqito lalida. ");
INSERT INTO oydl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Uukita si7i gaydannippa suuba Phawuloosa ammanze asuntsana xeegizi unttana zorii mintsitsidannippa suuba saritstsi Maqedoona qitodes kezida. ");
INSERT INTO oydl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","E aadhize sa7a yeze ammanze asuntsis qaala ohi mintsitsidannippa suuba Girike sa7a qitida. ");
INSERT INTO oydl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","E ize hyaydzdzii agina bettii, markkabera Sooriya qitodes qoppii yezin, Ayhuduntsi fana wodhodes koyizanno erii Maqedooniyara suub maaqqades koyda. ");
INSERT INTO oydl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Phawuloosa moyziduntsi Beeriyappa Pharhuusa na7aya Sophaxiroosa, Teselonqeppa Arsxirokoosan Sikondduusa, Derbbeppa Gaayoosa, Iisiyappa Tikiqoosa, Xirofimoosan Ximotiyoosan. ");
INSERT INTO oydl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Hyantses tiino hyanggi nuna Xiro7aadalla kafane. ");
INSERT INTO oydl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nu Boora Ba7ale bonchchidannippa suuba Filphisiyusappa markkabera denddii, ichchintsa qammara unttana Xiro7aada yellii ize laappun qamma gam77ida. ");
INSERT INTO oydl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Saaminttappa tiino qamma nu boora baxxodes shiiqii yezin, Phawuloosa wonttistto qitodes qoppide gisho unttis qaala ohitera giddii bilahe yellodes ohito gam7izida. ");
INSERT INTO oydl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nu shiiqii bettide fooqite gaama foo7o yene. ");
INSERT INTO oydl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ewuxikoosa gaaze fettii yidhdhize maskkootella bettii, fana botii genttida. Phawuloosa ohito pharggizide wode Ewuxikoosa gentti hyaydzdzintsa fooqizeppa gol7i hyayqqezin asuntsi dentsida. ");
INSERT INTO oydl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Yezin Phawuloosa wodhdhii, eella zuggida. Eza iringgi, «E hyayqqikaaya, tannippete» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yinnippa suuba, ude fooqella kezii boora baxxi mu7ida. Sa7a wonttode wontsis asuntsis ohidannippa suuba denddii qitida. ");
INSERT INTO oydl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ye faxide yidhdhiza kara kanggi gaama ufayttida. ");
INSERT INTO oydl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Yezin Phawuloosa fana izippa mokkode gaar nuus ohide gisho tiinidhii markkabego hyanggi, Asoosa qitodes denddida. Akkos gayko, E tohera qitodes qoppide gisho nuna hyannii gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","E nuura Asoosa yellinttin markkabera eza ekkii Mixiliine hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wonttistti wode izippa denddii markkabera Kiyoosa tiino yeze besite yellida; mahi wonttistti wode Saamosa fiinggi kaallize wodite Miliixe yellida. ");
INSERT INTO oydl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phawuloosa Isiya gidda gaama gami7ikaayzara Efesoone kalera aadhodes qoppida. Faas dandda7inttiko Phenxeqosxe Ba7ale wode Yerusalaame yellodes ellisane. ");
INSERT INTO oydl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Phawuloosa Miliixeppa Efesoone kiittii woosa keetstsa cimuntsana xeegizida. ");
INSERT INTO oydl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Woosa keetstsa cimuntsi eego yi7in, unttago hyannigaara yagayda: «Taanii Isiya gelide tiino qammitippa aykkii yinttara yezide wode ubba wayzi yezezako yin erane. ");
INSERT INTO oydl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayhuduntsi shiiqii taalla madha yeltsikon ta ashkketitsaran gaama afutstsara Laatstsis oochchida. ");
INSERT INTO oydl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bucan yin keetsite keetsite yinttana tamaarssittera yinttana maaddize bazappa fettibazin faccizikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Taanii Ayhuduntsisin Ayhude maaqqoosuntsis nagarappa Xoozago maaqqade gaaran nu Laatstse Yesuusa ammanode gaar markkidhida. ");
INSERT INTO oydl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ize tana akko yellode yezako eroos, yezin hyatte taanii Geeshi Ayyaanas kiitinttii Yerusalaame qitane. ");
INSERT INTO oydl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Yinno maaqqikon Geeshi Ayyaana katama ubba achchin madhan tana naagizanno taas markkidhida. ");
INSERT INTO oydl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yezin ta wotsito folodes Laatstse Yesuusap ekkide oochito, Xoozze aadho keehatitsi Wonggele markkidhizanno folodes ta shemppito fatstsoosse baz fana faydane. ");
INSERT INTO oydl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Taanii hyatten Xoozze ka7itumo markkidhitera yin gidda wutida. Yikkeppa suuba yinttappa ooden tana be7aamanno erane. ");
INSERT INTO oydl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yinnii gisho, yinttappa fettii asi dhabikon ta oocinttaamanno hyayno qamma yinttis geeshi ohine. ");
INSERT INTO oydl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Akkos gayko, Xoozze qofa ubba yinttis akko bazin ashshikaayzara ohida. ");
INSERT INTO oydl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«Fa na7ay suutsite wonggide Xoozze woosa keetsito naagote. Geeshi Ayyaana yinttana yenggizuntsana mahi dooride wuditisin yin ommitisin naaginttote. ");
INSERT INTO oydl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Taanii hyanggidannippa suuba, wuditis yiqsinttoosse iita suudhumuntsi yin gidda gelodanno ta erane. ");
INSERT INTO oydl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tamaaruntsana fa suub kaalitsodes worddo tamaarssize asuntsi yin giddappa denddoda. ");
INSERT INTO oydl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yinnii gisho, ta hyaydzdzii bere qamman awaran afutstsara yinttana ommite ommite kaccidanno qoppitter minggote. ");
INSERT INTO oydl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Hyatten yinttana mintsodesin geeshi asuntsara laata immades dandda7ize Xoozzesin E aadho keehatitsi qaalas yinttana hyadara inggane. ");
INSERT INTO oydl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«Taanii oodeppan bira woy worqqa woy afula ekkikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Taanii ta kushite oochchii taasin taara yezuntsana beezzebaz maaddidanno yin, yin ommite erane. ");
INSERT INTO oydl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Yin hyannifana labbii oochitera labbiduntsana maaddodannon Laatstsii Yesuusa, ‹Ekkizeppa aadhii inggizay anjjinttidaya› gayde qaaltto yin qoppodes beezanno ta yinttana ubbabazite beezida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Phawuloosa yinno ohi hyaasii un ubbuntsara bunqqunttii Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Un ubbuntsi Phawuloosa iringgi yeekkii yeerida. ");
INSERT INTO oydl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","E Mahi, «Tana be7aama» yagayde qaaltta unttana gaama azzantsida. Un markkabe yellodes eza moyzida. ");
INSERT INTO oydl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nu Efesoone cimuntsappa shaginttideppa suuba markkabera Qoose qitida. Wonttistti wode Rooda yellii izippa Phaxira qitida. ");
INSERT INTO oydl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Fenqqe fiinggize markkabe denggi E gidda gelii qitodes denddida. ");
INSERT INTO oydl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nu Qoophiroosa bi7ide wode, Qoophiroosa workkita bagga ashshii Sooriya yedhdhida. Markkabize fa caantto ize ketstsodes koyde gisho Xiroosa qitida. ");
INSERT INTO oydl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ize ammanze asuntsana denggi unttara laappun qamma bettida. Phawuloosa Yerusalaame qitaame gaar un ees Ayyaanara ohida. ");
INSERT INTO oydl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nuunii un kale gam7ize wodita hyal7in kezii qitida. Un ubba fa machchuntsaran fa na7untsara wolla katamappa gaxa kessii nuna moyzida. Nu abba kale bunqqunttii Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Yinnippa suuba, wol sarotsin nu markkabite gelida; un fa kara maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nu abba ogito hyaasii, Xiroosappa Phexelemaysa yellida. Ize ammanze asuntsana saritstsi, un kale fettii qamma feezhida. ");
INSERT INTO oydl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wonttistti wode kezii, Qisaariya qitida. Sabaake Filphoosa kara yellii E kale bettida. E Yerusalaame tiino doorinttide laappuntsafa feta. ");
INSERT INTO oydl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filphoosas nabe maaqqide oyddii wudur na7untsi yene. ");
INSERT INTO oydl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nuunii unddenna qamma ize bettezin Agaboosa gaaze nabe Yihudappa Qisaariya yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nuugo yi7i Phawuloosa saqqe ekkii nabize fa kushiton fa tohito accii, «Geeshi Ayyaana hyay saqqize adaya, Yerusalaame Ayhuduntsi hyannigaara accii, Ayhude maaqqoosse asuntsis aatsii inggoda gaane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nuunii yinno si7ide wode nuunin yeze asuntsi Phawuloosa Yerusalaame qitaame gaar woossida. ");
INSERT INTO oydl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yezin Phawuloosa mahi, «Yin hyannigaara yeekkitera akkos ta wozintto tannize? Taanii, Laatstse Yesuusa suntsiti gisho acintte xalaala maaqqikaayzin Yerusalaame hyayqqodesin giiginttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nu zoridanno E ekkanxi ixxin, «Laatstse qofita hyano» ga7i si77i gayda. ");
INSERT INTO oydl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ize eeratsi wode gam77idannippa suuba giiginttii Yerusalaame qitodes kezida. ");
INSERT INTO oydl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qisaariya yeze ammanze asuntsappa eeratsuntsi nuura hyanggida. Un nuunii shemppode bessi Minaasone gaaze Qoophiroosa atstse kara kaalitsida. Minaasone tiino ammanide asuntsappa feta. ");
INSERT INTO oydl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nuunii Yerusalaame yellide wode ammanze asuntsi nuna ufaytti mokkida. ");
INSERT INTO oydl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wonttistti wode Phawuloosan nuunii Yayqoobara yellinttodes qitida. Woosa keetstsa cimuntsi ubbuntsi ize yene. ");
INSERT INTO oydl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phawuloosa unttana saritstsidannippa suuba Ayhude maaqqoosse asunts gidda fa baggara Xoozii oochchidanno ubba unttis ohida. ");
INSERT INTO oydl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Un yinno si7ide wode Xooz galatii Phawuloosago hyannigaara yagayda: «Nu ishayo, Ayhuduntsi gidda wantsi mukuluntsi Xooz ammanezako ne be7ine; un ubbuntsin higge mintsii naagane. ");
INSERT INTO oydl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Neenii Ayhude maaqqoosuntsana sa7a yeze Ayhude ubba fa na7untsi garrazinttaame gaar, Ayhuduntsi woga kaallaame gaaran Muse higge ixxode gaar neenii tamaarssizanno Yerusalaame yeze Ayhuduntsi si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yeezin akko lo77o? Ne yi7idanno turo si7oda. ");
INSERT INTO oydl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«Yinnii gisho, nuunii nees ohizanno si7o; gefa yeze oyddii asuntsi nu kale yene. ");
INSERT INTO oydl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Unttana ekkii unttara geezho; mahi un fa ommito meedinttode gaar unttis miishe inggo. Un zaga nebaz si7idanna turo maaqqikaayzannon neenii ne ommiten higge naagize asi maaqqidanno ubbuntsi erane. ");
INSERT INTO oydl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«Yezin ammanze Ayhude maaqqoosse asuntsana maaqqizako, un eeqas zharshinttidebaz ma7aame gaar, suutsi uzhaame gaar, bawuta ma7aame gaaran olalaame gaar, nuunii ohito accii, firddi unttis kiita xaafida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yinnippa suuba, Phawuloosa wonttistti wode asuntsana ekkii, unttara geezhida. E fa geezhe wodita ayde folinttode yezako erisodesin fa zharshito ayde zharshode yezako erisodes Xoozze keetstsa gelida. ");
INSERT INTO oydl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Laappun qamma folinttodes ukkodera, Iisiyappa yi7ide Ayhuduntsi Xoozze Keetstsa Phawuloosa bi7i, as ubba dentsitsii Phawuloosa aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«Isra7eele asuntso, nuna maaddote; hyay atstse, nu worzhito, nu higgiton hyanna Xoozze Keetsito ixxode gaar as ubbuntsana ubba bessa tamaarssane. Yinnan maaqqaanxi ixxin Ayhude maaqqoosuntsana Xoozze keetstsa gelitsii, hyanna geeshi bessito tunizida» yaga7i uukkida. ");
INSERT INTO oydl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Un yinno gaydanna zaga Efesoone Xirofimoosa Phawuloosara katama bi7ide gisho hyatte Phawuloosa Xoozze keetstsa eza ekkii gelidebaz unttis aazida. ");
INSERT INTO oydl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Katamita ubba buqinttida; asuntsi ubba shiiqii Phawuloosa aykkii Xoozze keetstsappa bale gochchida. Xoozze Keetstsa furtsita ellisii gorddinttida. ");
INSERT INTO oydl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Asuntsi Phawuloosa wodhodes yi7adera, «Yerusalaame katama kumutsi buqinttida» gaaze wortta Roome shaalaqago yellida. ");
INSERT INTO oydl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Shaalaqize wottaddaruntsanan mato hyalaquntsana ekkii woxxittera yi7ida. Asuntsi shaalaqizan wottaddaruntsana bi7ide wode Phawuloosa guuddizanno ashshida. ");
INSERT INTO oydl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ye wode shaalaqize shiiqii, Phawuloosa aykkii, lam77i santsalaatara acinttode gaar kiittida. Yeyzi, E oona yezakon akko oochchezako asuntsana oocida. ");
INSERT INTO oydl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Asuntsappa baggita fettibaz ga7i uukkize wode hyankuntsi mellebaz ga7i uukkane. Uukita gaanggide gisho shaalaqize turtto shagodes dandda7inttaanxin, wottaddaruntsi Phawuloosa fa yeze bessa kanggode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Phawuloosa yedhdhii kezize darajjito yellize wode asuntsi urqqizanni gisho wottaddaruntsi eza tookkida. ");
INSERT INTO oydl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Gaama asuntsi, «E hyayqqo!» ga7i uukkitera kaallane. ");
INSERT INTO oydl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wottaddaruntsi Phawuloosa fa yeze bessito geltsodes yi7adera, Phawuloosa shaalaqizego, «Taanii nees fettibaz ohiko si7odate?» gayda. E Phawuloosago, «Ne Girike doona erane? ");
INSERT INTO oydl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Neenii hyannippa tiino buqutsi medhdhii shemppo wodhide oyddii mukul asuntsana ekkii akko baayze ganas gelide Gibxxe atstsa baane?» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Yezin Phawuloosa, «Taanii, Kilqiya yeze erinttide Terseese katama asi maaqqide Ayhude asi. Tana asuntsis ohizoya?» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Shaalaqize eego, «Oho» ga7in Phawuloosa darajjalla eqqii, asuntsi si77i gawude gaar fa kushtira mallida. Asuntsi si77i ga7in Ibraysxe doonara hyannigaara gayda: ");
INSERT INTO oydl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Ta ishuntson, ta aduntso, taanii hyatte yinttis inggize mahito si7ote.» ");
INSERT INTO oydl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Phawuloosa unttis Ibraysxe doonara ohizanna si7i kasennippa aatsii si77i gayda. E kaallii, ");
INSERT INTO oydl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Taanii Kilqiya yeze Terseese yelintti hyanna katamtte diccida. Ta asttamaarizen Gamaaliyale; taanii nu aaduntsi higgito mintsii tamaarida, hyayno yin ubba hyanizannigaara Xoozis mishinttize Ayhude asi. ");
INSERT INTO oydl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ta hyanna ogito kaallize maachuntsanan dhiiratsunsana aykkii achi keetstsa oliteran unttana wodhissade wontsis madha beezze asi. ");
INSERT INTO oydl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Yinnii gaara, kahinunts hyalaqizen Shanggo ubba ta baz markkidhades dandda7ane. Taanii Damasqqo yeze un ishuntsis unttappa dabddaabbe ekkii ize yeze asuntsi acinttii seerinttode gaar Yerusalaame unttana ko7odes ize qitida. ");
INSERT INTO oydl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Ta hyanggi Damasqqo ukkide wode awara saate qoppikaayzin saloppa damma foo7o ta kantto wutii foo7ida. ");
INSERT INTO oydl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ta sa7ite gol7i yessadera, ‹Saawula, Saawula, tana akkos baytstse?› gaaze qaala si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Taanii mahi, ‹Laatstso, neenii oode?› yagayda. «E mahi, Taanii, ne baytsize Naazirete Yesuusa» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taara yezuntsi foo7ito bi7idap attin taas ohize qaaltto si7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«Taanii, ‹Laatstso, ta akko oochcho?› yagayda. «Laatstsi taago, ‹Denddii Damasqqo qito. Ne oochchode gaar Xoozii qoppidebaz ubba ize nees ohinttoda› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Yinna damma foo7itippa denddii ta aafita dhumin, taara yeze asuntsi ta kushito aykkii, tana gochchii Damasqqo yeltstsida. ");
INSERT INTO oydl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Damasqqo yeze Ayhuduntsi ubba markkidhezen gaama bonchchize fettii Hananiya gaaze atstse, nu higgito bonchchizen Xooz mintsii woossize yene. ");
INSERT INTO oydl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","E taago yi7i, ta kale eqqii, ‹Ta ishe Saawula, bo7o› gayda. Ellisii ta eza bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«E taago, ‹Nu aaduntsi Xoozze neenii E qoftto erode gaar, Xilliza be7ade gaaran E doonttippa qaala si7ade gaar tiinii nena doorida. ");
INSERT INTO oydl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Neenii bi7idebazisin si7idebaz as ubba tiino ees markka maaqqade fana. ");
INSERT INTO oydl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Hyatte akkos gam77e? Xammaqintto; E suntsito xeegii ne nagarttippa meecintto› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Taanii suuba Yerusalaame maaqqii Xoozze Keetstsa woossodera, taas qonccitsi benttida. ");
INSERT INTO oydl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Qonccisite Laatstsii taago, ‹Ne taas markkidhize markkatitsito asuntsi ekkoosse gisho ellisii Yerusalaameppa kezo› yaga7odera bi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«Taanii, ‹Laatstso, Ayhude woosa Keetstsa ubba nena ammanzuntsana aykkii hyadhdhidayan achi keetstsa olidaya maaqqizanno un erane. ");
INSERT INTO oydl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Un ne markka Isxifaanosa wodhize wode ta yinna oochchite wolla yene. Mahi un kale eqqii eza wodhizunts ma7ito naagane› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«Laatstsii taago, ‹Taanii nena Ayhude maaqqoosse asuntsago hyaako sa7a kiittode gisho denddii qito› » yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Phawuloosa yinna qaaltto ohi hyaasode wontsis asuntsi E gaazanno si7ine. Yinnippa suuba, fa qaaltto dhoqi yiizii, «Hyanna sa7itippa dhabiso! E yessades beezoos» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Un kacinttii, fa ma7ito eella afa dhogii xura ude lalodera; ");
INSERT INTO oydl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Shaalaqize bi7i wottaddaruntsi Phawuloosa un fa yeze bessa kanggode gaara kiitida. Mahi asuntsi akkos hyannigaara kacinttezako erodes koyi Phawuloosa dafera garafii loytsii oocode gaar unttana kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Yezin wottaddaruntsi Phawuloosa dafera mintsii accii garafodes yiize wode Phawuloosa fa kantte eqqide mato hyalaqizego, «Roome asi firdda baayzin garafizanna yinttis woga?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mato hyalaqize yinno si7ide wode shaalaqizego hyanggi, «Hyay atstse Roome asi. Neenii akko oochchodes qoppe?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Shaalaqize Phawuloosago shiiqii, «Ne Roome aso? Ane taas oho» yagayda. Phawuloosa, «Yee» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Shaalaqize mahi, «Taanii hyanno gadetitsito gaama miishera ekkida» yagayda. Yezin Phawuloosa, «Ta hyanna gadetitsito yelintti ekkida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yinnii gisho, Phawuloosa loytsii oocodes qoppiduntsi iira eeppa shaakkinttida. Shaalaqize Roome asi santsalaatara accidanno eride wode zhashtida. ");
INSERT INTO oydl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wonttisti wode Shaalaqize, Ayhuduntsi Phawuloosa akkos mootezako shaakkii erodes koyi billida. Kahinunts hyalaquntsin shanggo ubbuntsi shiiqode gaar kiittida; mahi Phawuloosa ki7i un tiino essida. ");
INSERT INTO oydl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phawuloosa firddize asuntsana dakkii bi7i, «Ta ishuntso, ta hyayno yellodes Xoozze tiino ta yestte ubba lo77o wozinara yezida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kahinunts hyalaqize Hananiya, Phawuloosa doontto baqqode gaar E kale eqqiduntsana kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ye wode Phawuloosa eego, «Naate bootsi forchcho tizhinttide dochey, Xoozii nena baqqoda. Neenii taalla higgera firddodes bettii yezite higge ashshii tana baqqade gaar kiittane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Phawuloosa kale eqqiduntsi eego, «Ne Xoozze kahinunts hyalaqa cazhane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phawuloosa, «Ta ishuntso, E kahinunts hyalaqa maaqqidanno ta erikaaya; akkos gayko Xoozze qaaltte, ‹Ne worzha ahizella iita qaala ohippe› yaga7intti xaafinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Yezin Phawuloosa yinna besite yeze asuntsappa bagguntsi Saduqaawuyane, bagguntsi Farisaawuyane maaqqizanno erii, «Ta ishuntso, ta Farisaawuyane Farisaawuyane na7a; ‹Hyayqqiduntsi hyayqoppa denddoda› ga7i taanii ufayssara naagize gisho un taalla firddane» yaga7i ohida. ");
INSERT INTO oydl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Phawuloosa yinno gayde wode Farisaawunts giddan Saduqaawuntsi gidda kachchi kezin shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Akkos gayko, Saduqaawuntsi, «Hyayqqide asi denddoos; kiitanchchon, ayyaanan baaya» yagaazuntsana. Yezin Farisaawuntsi ubba yezanno ammanane. ");
INSERT INTO oydl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Damma kachchi kezida; Farisaawunts zala maaqqide higge asttamaaruntsi denddii eqqii, «Hyay atstsella akko bala baz denggikaaya; ees ayyaana woy kiitanchcho ohikaayzara ashshoos» yaga7i wolla lallida. ");
INSERT INTO oydl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kachchita ganggin asuntsi Phawuloosa shaqitsi ekkaame gaar ga7i, shaalaqize fa wottaddaruntsi wodhdhii un gidda fa eza ellisii kessii fa yeze bessa kanggode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yinnii qamma Laatstsii Phawuloosa kale eqqii, «Phawuloosa, ne taas Yerusalaame markkidhidanni fana Roomen markkidhades beezane; minggo; akko baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wonttisti wode Ayhuduntsi, «Phawuloosa wodhikaayzara mo7oos uzhoos» ga7i caaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Phawuloosalla yinno zorintti caaqqide asuntsi oytamappa aadhane. ");
INSERT INTO oydl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Un kahinunts hyalaquntsi gade cimuntsago hyanggi, «Nuunii Phawuloosa wodhikaayzara katstsa gaazebaz mo7oos ga7i caaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Yikke, yinttin shangguntsin E baz loytsii qurichchizebaz yeze baz mahi, Phawuloosa yinttago ko7ode gaar shaalaqiza oocote. Nuunii E hyanna shiiqita yellodannippa tiino eza wodhodes giigii bettida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Yezin Phawuloosa mishti na7ay yinna zorinttidanno si7i hyanggi wottaddaruntsi yeze bessito gelii, Phawuloosas ohida. ");
INSERT INTO oydl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phawuloosa mato hyalaquntsappa feta xeegii, «Hyay na7aya shaalaqizes ohize baz yeze gisho eza shaalaqizego kanggo» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mato hyalaqize na7aya shaalaqizego kanggi, «Achi keetstsa yeze Phawuloosa tana faago xeegii, hyay na7ay nees ohize baz yeze gisho eza neego ko7ode gaar tana woossida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Shaalaqize na7ay kushito aykkii, bale kessii, «Ne taas ohode qoftta akko?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na7ay shaalaqizego, «Ayhuduntsi Phawuloosabaz tiinoppan miintsii qurichchodes koyze gaar aazin neenii wontta eza shiiqite ko7ode gaar nena woossodes zore accida. ");
INSERT INTO oydl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Yezin neenii un gaazanno si7ippe. Akkos gayko, oytamappa aadhize asuntsi Phawuloosa wodhikaayzara ‹Katstsa mo7oos, hyaatsi uzhoos› ga7i caaqqii, aachintti eza kafane. Hyatte ne gaazebaz xalaala si7odes kafane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Shaalaqize mahi, «Hyanna ohito ne taas ohidanno melle oodesin ohippe» yaga7i na7aya suub dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Shaalaqize mato hyalaquntsappa lam77untsana xeegii, «Qammappa hyaydzdzii saate Qisaariya qitodes, lam77i xeet wottaddaruntsana, laappun tam faara asuntsanan lam77i xeet toora woringgizuntsana giigizote. ");
INSERT INTO oydl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Gadito ahize Filkkisago Phawuloosa saro yelitsodes toggize faara giigizote» yaga7i unttana kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Shaalaqize Filkkisas hyannigaara gaaze dabddaabbe xaafida: ");
INSERT INTO oydl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Qalawudiyoosa Luusiyosappa gade ahize bonchcho Filkkisasa, saro nees maaqqe. ");
INSERT INTO oydl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayhuduntsi hyay atstsa aykkii wodhodes yi7adera, E Roome sa7a asi maaqqidanno erii wottaddaruntsara yellii eza ashshida. ");
INSERT INTO oydl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Un eza akkos mootizako erodes koyi un shiiqite eza ta shiishida. ");
INSERT INTO oydl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Un fa higgitis eza mootidap attin eza wodhizebaz woy accizebaz baayzanno ta denggida. ");
INSERT INTO oydl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Un hyay atstsella zorinttide zigirsita tana yellin, ta ellisii eza neego dakkida. Eza mootizuntsi ne tiino hyanggi mootode gaar kiittida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Yinnii gisho, wottaddaruntsi kiitinttidanni fana Phawuloosa ekkii, qamma Antiphaxirisa yeltsida. ");
INSERT INTO oydl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wonttisti wode faara asuntsi eera hyanggode gaar yeyizi asuntsi suub maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Toggiduntsi Qisaariya yellii dabddaabbiza gade ahizes inggi, Phawuloosa E tiino aatsida. ");
INSERT INTO oydl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gade ahizay dabddaabbiza nabbabidannippa maaqqii «Phawuloosa, ne aba gade aso?» ga7i eza oocida. E Kilqiya asi maaqqidanno eride wode ");
INSERT INTO oydl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«Taanii nebaz nena mootizuntsi yi7ide wode si7oda» yagayda. Wottaddaruntsi Phawuloosa Heroodisa gibbe naagode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ichchin qammappa suuba kahinunts hyalaqize Hananiya, cimuntsaran Xerxeluusa gaaze fettii xabaqizera Qisaariya qitida. Un gade ahizuntsalla Phawuloosa mootida. ");
INSERT INTO oydl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Phawuloosa xeegintti gelide wode Xerxeluusa eza hyannigaara yaga7i mootida: «Bonchcho Filkkisa, nuunii ne baggara gaama saro denggida, ne lo77o ahizanne nu gadita gaama laaminttida. ");
INSERT INTO oydl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bonchcho Filkkisa, nuunii aban ayde maaqqin folo galatara yinno ekkane. ");
INSERT INTO oydl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Taanii nena gam77izikaayzara neenii ne keehatitsite nu baz hyaatara si7ode gaar nena woossane. ");
INSERT INTO oydl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Hyay atstse dhube maaqqii sa7a ubba yeze Ayhudunts gidda buqutsi medhdhii Naazirawunts bagga asuntsana kaalitsizaya maaqqidanno erida. ");
INSERT INTO oydl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Melle atto yezin, Xoozze Keetsito tunissades yi7adera nuunii eza aykkida; nu higgitigaara ezalla firddodes qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Yezin shaalaqize Luusiyosa yi7i, wolqqara nu kushtippa eza kessii ekkida. ");
INSERT INTO oydl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Eza mootizuntsin neego ye7ode gaar kiittida. Neenii ne ommite hyay atstsa qurichchi nuunii eza mootize mootto ubba erodes dandda7ane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayhuduntsin, «Hyanna ohita turo» ga7i E qoftto ma77ida. ");
INSERT INTO oydl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gade ahizay Phawuloosa oho ga7i mallida. Phawuloosa hyannigaara ga7i mahida: «Neenii gaama wodeppa aykkii, hyantsi asuntsis firdditera yezanno erii ta ohitis ufayssi wodhin mahe inggane. ");
INSERT INTO oydl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Taanii goynodes Yerusalaame kezin taphpho lam77i qammappa aadhosanno neenii ne ommite erodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ayhuduntsi tana Xoozze Keetstsa maaqqin Ayhuduntsi woosa Keetstsa maaqqin katama maaqqin ooderan lallodera woy as shiishii buqutses dentsitsodera fettii asin denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Hyatten un tana mootize bazitis markka denggodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«Yezin taanii fettibaz ammanane; taanii higge gidda yezebazin nabuntsi xaafide ubbabazito ammanii, nu aduntsi Xoozza, un worddo timirttite ogite goynane. ");
INSERT INTO oydl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Un fa ommite ammanizanni gaar xilluntsin nagaranchuntsin hyayqoppa denddodanno taanin ammanane. ");
INSERT INTO oydl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yinnii gisho, taanii Xoozze tiinon as tiino ubba wode lo77o qofa taas yessade gaar minggane. ");
INSERT INTO oydl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«Taanii Yerusalaameppa kezidannippa gaama bereppa suuba ta bagga dahuntsis maade immadesin zharsho zharshodes Yerusalaame yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Taanii Xoozze Keetstsite yinno oochchii geezhe woga folii maaqqadera tana denggida. Ye wode taara gaama asi baaya, kachchin kezikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yezin Iisiyappa yi7ide fettii fettii Ayhuduntsi ize yene; un taalla ohodes koyko yi7i tana neella mootodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Woy taanii shanggo tiino shiiqide wode oochchide bala yeziko hyantses ne tiino yezuntsi oho. ");
INSERT INTO oydl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Turo taanii un gidda eqqii ‹Hyayqqiduntsi denddo yene ga7i hyayno firddas yin tiino shiiqida› ga7i uukki ohida; yinnippa melle yiizide baz baaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Yezin Filkkisa Laatstse oge baz shaakkii eride gisho «Taanii yin ohito shaalaqa Luusiyosa yi7ide wode firddoda» ga7i qaxaro inggi dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Filkkisa mahi Phawuloosa accikaayyezara naagode gaaran E iginuntsappa ooden eza oocodes ye7odera kayaame fana mato hyalaqizes ohida. ");
INSERT INTO oydl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Eeratsi qammappa suuba, Filkkisa Ayhude maaqqide fa machchiti Dirusillara yi7i Phawuloosa kiittii ki7izii Kiristtoos Yesuusa ammano baz eeppa si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Phawuloosa xillotitsibaz, fa omma ahizebazin yo7odes yeze firddabaz ohodera, Filkkisa zhashtii, «Ne hyattes qito; taas wottide wode nena xeegisada» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ye wode Phawuloosappa gubbo ekkodes qoppii eza mahi mahi xeegizi eera ohinttane. ");
INSERT INTO oydl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Lam77i bereppa suuba, Filkkisa besite Phorqiyoos Fisxoosa shuumunttida. Filkkisa Ayhuduntsana ufayssodes koyi Phawuloosa billikaayzara ashshida. ");
INSERT INTO oydl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fisxoosa fa awurajja gelii hyaydzdzii qammappa suuba Qisaariyappa Yerusalaame qitida. ");
INSERT INTO oydl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ize kahinunts hyalaquntsin Ayhuduntsana kaalitsizuntsi Phawuloosa mootida. ");
INSERT INTO oydl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","«Phawuloosa Yerusalaame ki7izii nuus lo77o baz oochchoya» ga7i woossida; yinno un gaydanna Phawuloosa oge naagii eza wodhodes koyde gisho. ");
INSERT INTO oydl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fisxoosa unttago, «Phawuloosa, Qisaariya achi keetstsa yene; taanii ta ommiten ellisii suuba maaqqades yi7ine. ");
INSERT INTO oydl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","E balidebaz yeziko yin shuumuntsi taara Qisaariya wodhdhii eza mooto» yaga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fisxoosa un kale osfun woy taphphi qamma gaar gam77idannippa suuba Qisaariya wodhdhida. Wonttisti wode firdda oydalla bettii Phawuloosa ko7ode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","E yi7in Yerusalaameppa yi7ide Ayhuduntsi E kale eqqii un markka shiishodes dandda7oosse damma mintsi mooto eella shiishida. ");
INSERT INTO oydl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Phawuloosa mahi, «Taanii Ayhuduntsi higge maaqqin Xoozze Keetstsa maaqqin woy Roome Kaat maaqqin Qeesare qohikaaya» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Yezin Fisxoosa Ayhuduntsana ufayssodes koyi Phawuloosago, «Yerusalaame hyanggi hyanna moottis ize ta tiintte firddinttodes koyane?» yaga7i oocida. ");
INSERT INTO oydl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Yezin Phawuloosa, «Taanii firddinttodes beezize Qeesare firdda keetstsa tiino eqqida. Neenii loytsii erzanni gaar ta Ayhuduntsana akkoran qohikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Yikke, taanii qohidebazin hyayqos yeltsidebaz oochchidebaz maaqqizako hyayqoppa tana ashsho ga7oos. Yezin un tana mootize mootta cer maaqqiko ooden tana unttis aatsii inggodes dandda7oos. Qeesare ta baz firddo ga7i oocane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ye wode Fisxoosa fa zorinttizuntsara zorintti, «Neenii Qeesare ta baz firddo ga7i oocida; Qeesarego qitoda» ga7i mahida. ");
INSERT INTO oydl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Eeratsi qammappa suuba Kaat Agirphan Barnniiqen Fisxoosa saritsodes Qisaariya hyanggida. ");
INSERT INTO oydl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ize un gaama wode gam77in, Fisxoosa Kaatizes Phawuloosabaz hyannigaara yaga7i qonccizida; «Filkkisa billikaayzara ashshii qitide fettii atstse hyanne yene. ");
INSERT INTO oydl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Taanii Yerusalaame hyanggide wode kahinunts hyalaquntsin Ayhude cimuntsi eella afa firddode gaar tana woossii E baz taalla mootida. ");
INSERT INTO oydl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Taanii, ‹Mootinttide atstse fana mootizunts tiino eqqii fa mootidannis mahe inggikaayzin, oona maaqqikon aadhii ingginttizanna Roome woga baaya› ga7i unttis mahida. ");
INSERT INTO oydl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","«Yinnii gisho, un hyanne shiiqide wode taanii gami7ikaayzara wonttisiti wode firdda keetstsa gelii Phawuloosa ko7ode gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eza mootizuntsi E kale wutii eqqii, iitabazara eza mootikaayzar ashshaama ga7i taanii qoppidanni gaar eza mootikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Yezin un fa ammanobazin Phawuloosa, ‹Faxa yene› gaaze fettii hyayqqide Yesuusa ga7inttize atstsebaz eera lallane. ");
INSERT INTO oydl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Hyanna ohita tana shaakkodes deexide gisho Phawuloosa Yerusalaame hyanggi, ize firddinttodes koyzako ga7i eza oocida. ");
INSERT INTO oydl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Yezin Phawuloosa fa ohito Qeesare be7ade wontsis achi keetstsa gam7odes oocida. Taanii eza Qeesarego dakkode wontsis E accinttode gaar kiittida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Yinnii gisho, Agirpha Fisxoosago, «Taanii ta ommiten hyay atstse gaazanno si7odes koyane» gayda. Fisxoosa eego, «Neenii wontta E gaazanno si7oda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wontistti wode Agirphin Barnniiqen damma bonchchora shaalaquntsara katama yeze ahize asuntsara yi7i firdda keetstsa gelida. Fisxoosa Phawuloosa xeegizi ki7ida. ");
INSERT INTO oydl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fisxoosa, «Kaati Agirphan, hyanne nuura yeze asuntso, Ayhuduntsi Yerusalaamen hyannen uukki, ‹E yikkeppa suuba faxa yessades beezoos› yaga7i, tana woosside atstsa hyaya yin be7ine. ");
INSERT INTO oydl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Yezin eza hyayqos yeltsizebaz akko bazin taanii denggikaaya. E fa ommite, ‹Qeesare ta baz firddo ga7i oocane› gayde gisho Qeesarego eza dakkodes qofa accida. ");
INSERT INTO oydl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Taanii E baz ta laatstse Qeesares xaafodes maaqqize erinttidebaz akkon baaya. Yinnii gisho, E baz yin bi7iko ta xaafodebaz benttod yezako ga7i yin tiino aatsii Kaati, Agirpha, ne tiino eza ki7ida. ");
INSERT INTO oydl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Akkos gayko, acinttide atstsa aatsize wode E akkos mootinttezako mikinaato ersizikaayzara ashshizanna taas eeyatitsi aazane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripha Phawuloosago, «Neenii nebaz ohodes dandda7ane» gayda. Ye wode Phawuloosa fa kushito dentsii hyannigaara gayda: ");
INSERT INTO oydl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Kaati, Agripha, Ayhuduntsi tana mootide bazis ubba mahe inggodes hyayno ne tiino eqqitera taas ixa lo77o ga7i qoppane. ");
INSERT INTO oydl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Yinnan Neenii Ayhude wogan lallen loytsii erane; yinnii gisho tana azal7ikaayzara si7ade gaar woossane. ");
INSERT INTO oydl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«Taanii na7atitsappa aykkii ta asunts giddan Yerusalaame yezide ta yestto Ayhuduntsi ubba erane. ");
INSERT INTO oydl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Taanii tiinoppa aykkii, nu ammano higgito mintsii naagize Farisaawunts kochchappa maaqqidanno un markkidhades koyko erane. ");
INSERT INTO oydl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Hyatten taanii Xoozii nu aduntsis inggoda gayde ufayssito naagize gisho mootinttii hyanne eqqida. ");
INSERT INTO oydl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Mahi taphpho lam77i nu aduntsi kochchita Xoozza qamman awaran mintsii goyniter Xoozii inggoda ga7idanno ekkodes ufayssara naagii yene. Kaati Agirpha, Ayhuduntsi tana mootizanna taanii ufayssara yinno naagize gisho. ");
INSERT INTO oydl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Xoozii hyayqqiduntsana dentsizanna akkos yin gidda ammaninttoose baz maaqqido? ");
INSERT INTO oydl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Zaga taanii ta ommiten Naazirete Yesuusa suntsito ixxodes dandda7inttide baz ubba oochchodes beezane ga7i qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Taanii Yerusalaame oochchidanna hyanno. Kahinunts hyalaquntsappa adetits wolqqa ekkii Xooz asuntsappa gaamuntsana accizida. Unttana wodhize woden hyayqo qofite giigida. ");
INSERT INTO oydl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Gaama wode Ayhude woosa Keetstsa ubba un seerinttode gaaran Yesuusa cazhode fana wolqqidhes qoppida. Taanii wogabaz unttana kaccii melle atto yezin, bale sa7a katama yellii unttana bay7ane. ");
INSERT INTO oydl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Taanii hyanna ohitis kahinunts hyalaquntsappa adetits wolqqan kiita ekkii Damasqqo qitane. ");
INSERT INTO oydl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaatayo, taanii awara saate oge yessadera awa foo7oppa gaama aadhize foo7o bi7ida; yinnan ta kantton taara yedhdhizunts kantto wutii saloppa foo7ida. ");
INSERT INTO oydl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nuunii ubbuntsi sa7ite gol7eze wode Ibraysxe doonara, ‹Saawula, Saawula, tana akkosi bay7e? Neenii nena caddize biratiza ixxiko nees wozzi iitoda› ga7i taas ohodera si7ida. ");
INSERT INTO oydl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«Taanii, ‹Laatstso, ne oode?› gayda. «Laatstsi, ‹Taanii, ne bay7ize Yesuusa; ");
INSERT INTO oydl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Yezin denddii eqqo. Hyayno neenii tana bi7idannon tiinoppa ta nena beessadanno melluntsis markkidhade gaar ta taas oochchiza mahi nena shuumodes nees benttida. ");
INSERT INTO oydl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Isra7eele asuntsappan taanii nena unttago kiittize Ayhude maaqqoosuntsappa nena ashshoda. ");
INSERT INTO oydl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Neenii un aafto bugoda, dhumappa foo7ogo, Xalahe kusheppa Xoozago unttana mahoda. Un tana ammanii nagara atotitsi ekkoda. Xoozii ammanii geezhide asuntsi gidda fa laatto demmada› yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Kaati Agripha, yinnii gisho, taas saloppa benttide qonccitsitis kiitinttodanno ixxikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Yezin taanii tiinidhii Damasqqo gidda yinnippa suuba Yerusalaame gidda Yihuda sa7a ubba yezuntsin Ayhude maaqqoosuntsi fa nagarappa Xoozago maaqqade gaaran nagarappa maaqqidanno beezize oocha oochchode gaar qaala ohida. ");
INSERT INTO oydl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yinnii gisho, Ayhuduntsi tana Xoozze Keetstsa aykkii wodhodes koyda. ");
INSERT INTO oydl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hyayno yellodes Xoozze maade taappa shaakkinttikaaya; yinnii gisho, eeratsisin dammas markkidhitera hyanne eqqida. Nabuntsin Musen hyanoda ga7i ohidannippa melle fettibazin taanii ohidebaz baaya. ");
INSERT INTO oydl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Yinnan, ‹Kiristtoosa madha ekkodes beezane; mahi hyayqoppa tiino denddii Ayhuduntsisin Ayhude maaqqoosuntsis foo7o awajjane› ga7i.» ");
INSERT INTO oydl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phawuloosa yinno ga7i mahodera, Fisxoosa fa qaaltto dhoqi yiizii, «Phawuloosa, ne zhaashtida; ne gaama tamaaridanna nena zhaashas yeltstsida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Yezin Phawuloosa, «Bonchcho Fisxoosa, taanii turibazin koshshize bazin ohinep attin zhaashtikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Taanii qoncce ohize ohito Kaati erane. Hyanna ohita aachichcha oochinttikaayze gisho fettin eeppa genggoosanno taanii geeshi erane. ");
INSERT INTO oydl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","«Kaati Agripha, neenii nabuntsna ammanane baane? Ne ammanzanno taanii erane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kaati Agripha, Phawuloosago, «Hyanna eerats saate tana kiristtaane mahodes koyane?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Phawuloosa, «Gaama wode maaqqin eerats wode ne xalaala maaqqikaayzin hyayno tana si7ize ubbuntsi hyanna achitip attin ta fana maaqqade fana Xooz woossane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Yinnippa suuba, Kaati Agripha gade ahize Fisxoosa, Barnniiqen unttara bettide ubbuntsi denddida. ");
INSERT INTO oydl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Izippa kezii qititera fete fetera, «Hyay atstse hyayqos woy achchis yeltsizebaz akkon oochchikaaya» ga7i wolla ohinttida. ");
INSERT INTO oydl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripha Fisxoosago, «Hyay atstse ‹Qeesare ta baz firddo› gaykaayzako bilinttodes dandda7ane, yezin attida» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nuunii markkabera Xaaliya qitode fana un accide wode kaatuntsi kaat maaqqides wottaddaruntsana olas kiittize fete Yuuliyoosa gaaze mato hyalaqizes Phawuloosan melle eeratsi achcha yeze asuntsana inggida. ");
INSERT INTO oydl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Isiya gaxa yeze guta qitize Adiramixiyoone markkabe gidda gelii denddida. Maqedooniya asi maaqqide Teselonqe Arsxirokoosa nuura yene. ");
INSERT INTO oydl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wonttistti wode nuunii Sidoona yellodera, Yuuliyoosa Phawuloosas loytsii fa lagguntsago hyanggi koshshize baz maadinttode gaar unttago dakkida. ");
INSERT INTO oydl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Izippa denddii tiinora nuulla baqqize gisho hyaatstsara teqinttide sa7a, Qoophiroosara kate mahi yeekka zalara aadhida. ");
INSERT INTO oydl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilqiyan Phinfiliya kale yeze abba fiinggi Liiqiyan yeze Muura yellida. ");
INSERT INTO oydl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ize mato hyalaqize Xaaliya qitize Iskkinddiriya markkabe denggi, ize nuna geltsida. ");
INSERT INTO oydl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nuunii gaama wode leemi yedhdhii, gaama madhara Qanddoosa katama kale yellida. Yeygara qitodes nuna gote kayin Salmoonara aadhii hyaatsara teqinttide sa7a, Qarxeesara katii aadhida. ");
INSERT INTO oydl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gaama madhara gaxa gaxa aykkii Laasiya katama kale yeze abba gaxite «Lo77o markkabe Shemppize bessi» ga7inttize besite yellida. ");
INSERT INTO oydl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nuunii ize gaama wode gam77idannippa suuba xooma bilinttin, markkabera yedhdhizanna wayitstsize gisho Phawuloosa unttana zorida. ");
INSERT INTO oydl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Asuntso, nu hyanggize ogite damma qohen damma dhabe yezanna taas benttane; qohita caanaallan markkabella xalaala maaqqikaayzin nu ommitillan yelloda» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Yezin mato hyalaqize Phawuloosa gaydannippa aadhii markkabe izhizayin markkabiti adayin gaazanno ammanida. ");
INSERT INTO oydl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Yinna abba gaxa yeze katama balggo agina aatsodes unttis giigoose gisho gaama asuntsi faas dandda7inttiko Finqqe katama yellii sila agina yeyga aatsodes zorinttida. Finqqe ude awa geloppan sulle awa geloppan gidda abba gaxa yeze markkabe caana ketstsize bessi sila agina ize aatstsodes qofa shiishida. ");
INSERT INTO oydl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Eerats yeekka baqo baqqide wode un qoppidannigaara hyanide fana yi7in denddii, markkabize en7aame gaar aykkize meqiza ude ekkii Qarxeese kalera aadhida. ");
INSERT INTO oydl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Yezin gaama gam77ikaayzin «Awuraqiis» gaaze damma gote hyaatsara teqinttide sa7itippa sulle unttalla afa denddida. ");
INSERT INTO oydl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ye gotize markkabiza urqqii hyanggaame fana kayde gisho baqize markkabiza fa koyde bessa kanggode fana dakkii ashshida. ");
INSERT INTO oydl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nuunii Qeeda gaaze hyaatsara teqinttide sa7a katii hyanggitera gaama waayera markkabize gonggiza ashshodes dandda7ida. ");
INSERT INTO oydl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Un gonggiza ude kessidannippa suuba gaadera markkabizella xaaxii, mintsii accida. Surtiisa gaaze shaftte fana gol7izaame gaar yirggii, markkabize shartto ketstsii markkabiza hyarii izhida. ");
INSERT INTO oydl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gotize miinggi hyanggodera wonttisti wode caanttippa baggito Abba ole aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Hyaydzdzintsa qamma markkabize miishito ekkii fa kushtira olida. ");
INSERT INTO oydl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nuunii gaama wode awa aafen xoolintton bi7ikaayze gishon damma gote nuulla baqqide gisho tiinoppa shemppora attoda ga7i qoppikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ye wode un gaama wode katstsa miikaayzara gam77ide gisho Phawuloosa un gidda denddii eqqii, «Asuntso, yin ta zortto ekkii Qarxeesappa denddikaayzara attezako hyanna qohitan dhabitan nuna yellaama yeshsha. ");
INSERT INTO oydl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Yezin taanii yinttana zhashtippete ga7i zorane; akkos gayko, hyay markkabize dhabodap attin yinttappa fettii as shemppon dhaboos. ");
INSERT INTO oydl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Hyayno qamma ta E baz maaqqidayin ta goynize Xoozze kiittide kiitanchcho ta kale eqqii, ");
INSERT INTO oydl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹Phawuloosa, zhashtippe; neenii Roome Kaati Qeesare tiino eqqodes beezane. Yikke Xoozii ne gisho neera hyanggize asunts ubbunts shemppito ashshida› gayda. ");
INSERT INTO oydl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yinnii gisho, asuntso, zhashtippete. Ye kiitanchchize taas ohidanna hyanodanno ta Xoozza ammanane. ");
INSERT INTO oydl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Yezin baqize nuna kanggi fettii hyaatsara teqinttide sa7a gaxa oloda» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Taphpho oydintsa qamma Adiriya Abba gidda nuna baqita goden hyankan urqqodera, qamma giddii bilahe maaqqize wode markkabite oochchizuntsis sa7ago ukkide gaar aazida. ");
INSERT INTO oydl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Un geennatitsito erodes koyi gaade bertstsa deexobaz accii Abba olin, abba gentta osfun tam hyadha maaqqida. Eeratsi gam77i, mahi olin izippun tam hyadha maaqqida. ");
INSERT INTO oydl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Un abba gaxa yeze shuchchalla dom7inttaame gaar zhashtii, markkabize qitaame gaar aykkize oyddii meqo markkabizeppa suubara abba dakkii, sa7ita wonttode gaar Xooz woossida. ");
INSERT INTO oydl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markkabite oochchizuntsi markkabizeppa dhabodes koyi, markkabize qitaame gaar aykkize meqito markkabizeppa tiino zalara abba olize gaar aazizi gonggiza abba olida. ");
INSERT INTO oydl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Phawuloosa mato hyalaqizegon wottaddaruntsago, «Hyantses markkabite shemppii bettanxiko yin attodes dandda7oos» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yinnii gisho, wottaddaruntsi gonggize acinttide gaadiza gachchii dakkii ashshida. ");
INSERT INTO oydl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sa7a wonttodes yi7adera ubbuntsi katstsa ma7ade gaar Phawuloosa asuntsago, «Yin katstsa mu7ikaayzara gam7ide hyaynora taphpho oyddii qamma gam7ida. ");
INSERT INTO oydl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Yinnii gisho, eeratsi katstsa yin ma7ade gaar taanii yinttana woossane. Yin minggode gaaran shemppora yessade gaar eeratsi katstsa ma7ades koshshane; melle atto yezin yin omma isintsitip fettin dhaboos» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Phawuloosa yinno ga7i boora ekkii ubbunts tiino Xooz galatida; booriza baxxi me7e aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ubbuntsi miinggi fa faas katstsa ekkii mu7ida. ");
INSERT INTO oydl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nuunii markkabite yezuntsi lam77i xeeti laappun tam izippun. ");
INSERT INTO oydl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Un mu7i mizhide wode caana zargito abba olin markkabize deexito foollizida. ");
INSERT INTO oydl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sa7a wonttide wode markkabe oochchizunntsi aba sa7a yellezako erikaayzara, abba gaxa yeze shafe silimo bi7ida. Faas dandda7inttiko markkabiza yinna shafttigo shiishodes qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yeyzi, markkabize qitaame gaar aykkize meqito billii Abba olida. Ye wode izhize minxa accize gaadiza billida. Yinnippa suuba, baqita markkabiza tiino urqqode gaar markkabiza kanggize shara tiino zalara dhoqi yiizii yedhdhe aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Yezin markkabize shafe nadinttidella dom7inttii qoodhinttida. Markkabizes tiino zaltta xosinttii shaftto caddii aykkii en7anxi ixxin, suuba zaltto gote urqqizannippa denddii meqqe aykkida. ");
INSERT INTO oydl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wottaddaruntsi achi asuntsappa fettin hyaatsite hyadhdhii kezii dhabaame gaar unttana wodhodes zorinttida. ");
INSERT INTO oydl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Yezin mato hyalaqize Phawuloosa ashshodes koyi wottaddaruntsara zorintto ixxida. Hyaatsi hyadhdhii erize ubba markkabizeppa hyaatsite doollii doollii wodhdhii tiinidhdhii gaxa kessade gaar kiittida. ");
INSERT INTO oydl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Attiduntsi sanqqitillan, markkabize meqitsitilla afa kessade gaar kiittida. Yinnii gaara yi7i ubbuntsi gaxa sarora kezida. ");
INSERT INTO oydl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nuunii gaxa sarora kezide wode yellidanna hyaatsara teqinttide sa7ita Maltta ga7inttizanno erida. ");
INSERT INTO oydl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Maltta asuntsi nuus gaama lo77ida. Ira bukkide gishon ciishize gisho tama eetsii nuna ubba mokkida. ");
INSERT INTO oydl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Phawuloosa gaama hyayxe shiishii tama gaddodera, goppi michiti gisho kezii E kushtilla xaaxintti eza dhayda. ");
INSERT INTO oydl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Maltta asuntsi goppi Phawuloosa kushite xaaxinttidanno bi7ide wode fetay fetego, «Turo hyay atstse shemppo wodhide asi; melle atto yezin abbappa E attinin xoozze firddappa attii faxa yessades dandda7ikaaya» yagayda. ");
INSERT INTO oydl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Yezin Phawuloosa fa kushtippa shooshiza wuxurkki, tama olida; eza akkon qohikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Un, «E galtta kixxane, woy tiirikaayzin gol7i hyayqqane» ga7i naagane. Yezin gaama wode naagii E gallite akkon dummudhide baz dhabin, «Hyay eeqa» ga7i fa qoftto laammida. ");
INSERT INTO oydl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Yinna kara ganccite hyaatsara teqinttide sa7a hyalaqize, Pupliyoosa gaazes gade yene; hyaydzdzii qamma yellodes E nuna siiqora mokkida. ");
INSERT INTO oydl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pupliyoosa aday omma otstsi, micharan gancce hyarggera woy7i yene. Phawuloosa E kara gelii ees Xooz woossida; fa kushito eella gaddii fatstsida. ");
INSERT INTO oydl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Yinnippa suuba, Malttan yeze hyargginttize melle asuntsin yi7i faxida. ");
INSERT INTO oydl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Un nuna gaama bonchchida; nuunii markkabera qitodes denddide wode oges koshshize baz nuus inggidda. ");
INSERT INTO oydl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Hyaydzdzii aginappa suuba, Maltta gidda seete aatsii Iskkinddiriya markkabera hyammades denddida. Ye markkabizella Diyosqoroosa gaaze mentte eequntsi misile yene. ");
INSERT INTO oydl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sirakuuse katama gelii ize hyaydzdzii qamma bettida. ");
INSERT INTO oydl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Izippa denddii Regiyume katama yellida. Fettii qammappa suuba, yeekka zalara baqo baqqin, wonttisti wode Futiyulosa katama yi7ida. ");
INSERT INTO oydl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ize nu fettii fettii ammanze asuntsana denggin, faara saamintta gam77ode gaar nuna woossida. Yinnippa suuba, Roome nu qitida. ");
INSERT INTO oydl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roome yeze ammanze asuntsi nu baz si7i, Afiyoosa Gabe, Hyaydzdzii Aqize bessi ga7inttize bessito yellodes nuna mokkodes yi7ida. Phawuloosa unttana bi7ide wode Xooz galatii minggida. ");
INSERT INTO oydl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nu Roome gelide wode Phawuloosa naagize wottaddare ingginttin faas yezo ga7inttida. ");
INSERT INTO oydl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Hyaydzdzii qammappa suuba, Phawuloosa Ayhudunts hyalaquntsana faago xeegizida. Un shiiqide wode unttago, «Ta ishuntso, taanii nu asuntsana woy nu aduntsi wogalla akko qohize bazin oochchikaaya, yezin tana Yerusalaame accii Roome asuntsis aatsii inggidda. ");
INSERT INTO oydl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Un ta mootto bi7i hyayqos yeltsizebaz taalla akko bazin denggikaayze gisho tana billodes qoppida. ");
INSERT INTO oydl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Yezin Ayhuduntsi yinno ixxide wode un7intti ‹Ta baz Qeesare firddo› gaydap attin taanii ta worzhito mootizebaz yezin baaya. ");
INSERT INTO oydl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ta yinttana xeegizidanna yinttana be7adesin yinttis hyanno ohodes. Ta hyanna santsalaatar acinttidanna Isra7eele asuntsi naagize ufayssiti gisho» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ayhude hyalaquntsi Phawuloosago, «Nuus Yihudappa nebaz dabddaabbe yellikaaya. Izippa ye7eze asuntsappa fettin nebaz iita ohize baaya. ");
INSERT INTO oydl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Yezin hyanna ne kaallize ammantto melle melle besite asuntsi ixxizanno nuunii erize gisho ne qoftto si7odes koyane» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Un fa ye7ode qammito Phawuloosas qaxarii, yinna qammite gaanggi E yeze besite yi7ida. E wonttappa ugure yellodes Xoozze ka7itumo baz unttis markkidhida. Mahi un Yesuusa baz ammanode gaar Muse higgefan nabunts maxaafeppa geeshi unttana tamaarssida. ");
INSERT INTO oydl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Fete fete Phawuloosa gaydanno ammanida, yezin melluntsi ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Un wol gidda ohito ekkanxide wode Phawuloosa fettibaz gaydannippa suuba qitida. E hyannigaara gayda: «Geeshi Ayyaana yin aduntsis nabe Isayaasa doontte ohidanna turo. ");
INSERT INTO oydl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«Neenii yentsi asuntsago hyanggi, yin sissi si7ine, yezin yin qoppoos; yin be7e be7ine, yezin denggoos. ");
INSERT INTO oydl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Hyantsi asunts wozintta muumida; un hyayta tullida; un aaftan goozinttida. Yinna baayzako, un fa aafte bi7i, fa hyayte si7i, fa wozintte tiirii, un taago maaqqiko; taanin unttana fatstsod yeshsha ga7o» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«Yikke, hyanna Xoozze ashshize kiita Ayhude maaqqoosuntsis maaqqidanno erane. Unttin si7oda» gayda. ");
INSERT INTO oydl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Phawuloosa yinno ga7idannippa suuba Ayhuduntsi fa gidda gaama lallite kezii qitida. ");
INSERT INTO oydl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phawuloosa kira keetstsa lam77i bere kumutsi yezida; ize yezitera faago yi7iza ubba mokkane. ");
INSERT INTO oydl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Zhashimo baytsi ooden kaykaayzin Xoozze ka7itumo sabbakida; Laatstse Yesuus Kiristtoosa baz qonccizi tamaarssida.");
INSERT INTO oydl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yesuus Kiristtoosa aro maaqqide, hawaare maaqqade gaara xeeginttideppan Xoozze Wonggele sabbakode gaara doorinttide Phawuloosa kiittide kiita. ");
INSERT INTO oydl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Xoozii gaama wodeppa tiino fa nabunts baggara inggoda yagayde Xoozze geeshi Maxaafite xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Hyay Wonggelize ashora Dawute kochchappa yelinttide, Xoozze na7a, nu Laatstse Yesuus Kiristtoosas. ");
INSERT INTO oydl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Mahi E fa geeshi ayyaanara hyayqoppa denddii, Xoozze na7a maaqqidanno damma wolqqara beezida. ");
INSERT INTO oydl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","E baggara Ayhude maaqqoosse asuntsi ubba, ammanii kiitinttode gaar Kiristtoosa suntsiti gisho Xoozze aadho keehatitsin hawaaretitsi adetits wolqqa nu ekkida. ");
INSERT INTO oydl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yesuusa Kiristtoosas maaqqade fana xeeginttide asuntsappa bagguntsi yinttana. ");
INSERT INTO oydl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Roome yeze, Xoozii yiqsinttizuntsana ees geeshi worzha maaqqade fana dooriduntsis. Xoozze nu Adeppan Laatstse Yesuus Kiristtoosappa aadho keehatitsin sarotitsi yinttis maaqqe. ");
INSERT INTO oydl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ubbappa tiinii, yin ammantta sa7a ubba sinttide gisho Yesuus Kiristtoosa baggara yin gisho ta Xoozza galatane. ");
INSERT INTO oydl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Taanii E na7ay wonggelebaz kumutsi wozintte ohize Xoozze, taanii ta woostte ubba wode yinttana qoppizannis E markka. ");
INSERT INTO oydl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Wurssutsite, Xoozze qofa maaqqiko, taanii yinttago hyanggodes oge taas giigode fana ubba wode woossane. ");
INSERT INTO oydl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Taanii yinttis ayyaana anjjo shaakkodesin yinttana be7ades amudhdhane. ");
INSERT INTO oydl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Yinnan, taanii yin ammantten, mahi yin ta ammantte minggode fanas. ");
INSERT INTO oydl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ta ishuntso, taanii Ayhude maaqqoosse asuntsappa aafe denggidanni fana, yinttappan aafe denggodes yinttago hyanggodes qoppida, yezin kayinttida. ");
INSERT INTO oydl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Girike asuntsisin Girike maaqqoosse asuntsis mahi cincunsisin boozuntsis taas gale yene. ");
INSERT INTO oydl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Yinnii gisho, Roome yeze yinttisin Wonggele ohodes amudhdhane. ");
INSERT INTO oydl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Tiinidhii Ayhuduntsana, mahi Ayhude maaqqoosuntsanan ammanza ubba ashshodes Wonggele Xoozze wolqqa maaqqide gisho ta Wonggelera yeellidhoos. ");
INSERT INTO oydl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Xillo ammanora de7o yessada ga7intti Geeshi Maxaafite xaafinttida. Wonggele Xoozze xillotitsito qonccizida; tiinoppa wurssutsi yellodes asi xillidhize ammanora. ");
INSERT INTO oydl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Turita ernttaame fana fa iita oochara kammize asuntsalla afa nagara ubballa afa, Xoozze hyanqqo saloppa wodhdhoda. ");
INSERT INTO oydl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Xoozii unttis qonccissades beezzebaz qonccizide gisho un Xoozze baz erane. ");
INSERT INTO oydl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Alame medhinttideppa dentsii, asis benttoosse Xoozze hyano, yinnan E medhina wolqqan Xoozzetitsi E medhetitsite qonccii yeze gisho asuntsi fa iitatitsitis mikinaate maaqqize baz baaya. ");
INSERT INTO oydl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Un Xoozza erittera, eza bonchchikaayan galatikaaya. Un qofita maaddoosse baz maaqqida; un qoppoosse wozintta dhumida. ");
INSERT INTO oydl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Un fana cinccuntsana gaane, yezin boozuntsana. ");
INSERT INTO oydl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Un hyayqqoosse Xoozza goynodanno ashshii, hyayqqize as medhon, landdan, xootsin sazara gochunttize baz aazizi medhdhide misile goynane. ");
INSERT INTO oydl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Yinnii gisho, un fetay fetayra iita baz oochchii, fa gallito kawushode gaar Xoozii un wozintto amudhdhize tuna oochas unttana olida. ");
INSERT INTO oydl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Yinna hyanidanna un Xoozze turtto worddo laammide gishon medhdhide Xoozza ashshii, medhinttide baz goynide gisho. Xoozii medhinas galatinttida. Amin77e. ");
INSERT INTO oydl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Yinnii gisho, Xoozii unttana tuna amotitsis aatsii inggida. Un maachuntsi faas beezize dhiiratsara yellinttizanno ashshii, beezoosse baz hyanii maacha maachira yellinttane. ");
INSERT INTO oydl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Yinnii gaar, dhiiratsi faas beezize maachira yellinttizanno ashshii, dhiiratsi dhiiratsara yellinttane. Dhiiratsuntsii fetay fetayra amotitsara eexinttii, yeellize baz oochchida. Fa oochchide bala oochitis beezize firdda ekkida. ");
INSERT INTO oydl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Un Xoozza erittera, melle atto yezin E baz qoppodes koyanxi ixxide gisho beezoosse baz oochchode gaar Xoozii unttana maaddoose qofas aatsii inggida. ");
INSERT INTO oydl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Un qohera, iitatitsara, zhimbbarara, genera, qinaatera, shemppo wodhera, lallera, cimoran iita amora kumida. Un zigirizuntsana, ");
INSERT INTO oydl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","As suntsi iissizuntsana, Xooz ixxizuntsana, cazhizuntsana, utirzuntsana, ceeqizuntsana, iita baz oochchodes koyzuntsana fa adaysin inttisin kiitinttoosuntsana, ");
INSERT INTO oydl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","tiiroossuntsana, qaala laamizuntsana, siiqo baayzuntsana, yiqsimo baayzuntsana. ");
INSERT INTO oydl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hyantses fana oochchizuntsis hyayqo beezane gaaze Xoozze higge erittera, hyanno oochchane. Un fa faas oochchizanno xalaala maaqqikaayzin oochchize melluntsanan likke ga7i nashshane. ");
INSERT INTO oydl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Yinnii gisho, naate melluntsalla afa firddizayo, ne mikinaate mahize baaya. Ne melluntsalla afa firdditera, ye ne firddize atstse gaar oochchiko, ne, neella afa firddane. ");
INSERT INTO oydl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Yinnii fana oocha oochchizuntsalla afa Xoozze xillo firdda firddizanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Naate, yinnii gaar oocha oochchizuntsalla afa firddizayo, un oochchizanni gaar oochchizayo, ne Xooz firddappa attode gaar aazane? ");
INSERT INTO oydl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Woy Xoozze keehatitsi, genccon dandda7a duretitsito leqqane? Xoozze nees dalgga maaqqidanna nena nagarappa mahodes maaqqidanno erosaane? ");
INSERT INTO oydl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Yezin yinttis shuchchi wozinan si7oosse hyaye yene. Yinnii gisho, Xoozze hyanqon xillo firdda qonccize qamma, neella afa firdda shiishane. ");
INSERT INTO oydl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Xoozze fetays fetays E oochiti gaar inggoda. ");
INSERT INTO oydl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lo77o oochara miinggi, galata, bonchchon dhaboosse de7o koyzuntsis Xoozze medhina de7o inggoda. ");
INSERT INTO oydl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Yezin fana siiqizuntsana, turtto ixxizuntsana iita baz oochchodes koyzuntsalla afa Xoozze kachchin bosha yo7oda. ");
INSERT INTO oydl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Iita baz oochchize asuntsi ubba, tiinii Ayhuduntsana, kaallii Girikuntsana madhan waayen yelloda. ");
INSERT INTO oydl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Yezin Xoozze lo77o oocha oochchize ubbuntsis, tiinii Ayhuduntsi, kaallii Girikuntsis galata, bonchchon sarotitsi ingginttoda. ");
INSERT INTO oydl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Xoozii sino bi7i asi shaakkoos. ");
INSERT INTO oydl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Higge baayzin nagara oochchide ubbuntsi higge baytsi dhaboda. Higge yezin, nagara oochchide ubbuntsi higgera firddinttoda. ");
INSERT INTO oydl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Xoozze tiintte xillizuntsi higge naagizuntsap attin higge si7e xalaala si7izuntsana baaya. ");
INSERT INTO oydl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Higge baayze Ayhude maaqqoosse asuntsi medho higge kiittizanno oochchane. Unttis xaafinttide higge baayzinin un fa wozintte higge erane. ");
INSERT INTO oydl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Un hyanotitsita, higge kiita un wozintte xaafinttidanno beezane. Mahi un wozintta unttalla afa markkidhane. Un wozintta fettii fettii tohe unttana balida gaane; fettii fettii tohe unttana turo gaane. ");
INSERT INTO oydl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ta tamaarsside Wonggele fana Xoozze Yesuus Kiristtoosa baggara as wozintte aachinttide qoftta firddize wode erinttoda. ");
INSERT INTO oydl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Yezin ne nena Ayhude gaane; higgella katane; Xoozalla ceeqane. ");
INSERT INTO oydl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ne oochchode gaar Xoozii koyze baz akko yezako erane. Higge tamaaride gisho turo maaqqize baz shaakkii erane. ");
INSERT INTO oydl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ne qooquntsana kaallizanno, mahi dhuma yezuntsis foo7o maaqqizanno shaakkii erane. ");
INSERT INTO oydl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ne higgefa denggide eratitsin turetitsara boozuntsana erisizayan zhooguntsana tamaarssizaya maaqqidanno erane. ");
INSERT INTO oydl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yeezin, ne melluntsana tamaarssizay ne nena akkos tamaarssoso? Ne, «Kaysitippe» ga7itera, ne ne ommite kaystanen? ");
INSERT INTO oydl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ne, «Olale hyanttippete» ga7itera, ne ne ommite olale hyanttane? Ne eeqa ixxitera, eeqa yeze keetsito bonqane? ");
INSERT INTO oydl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ne Xoozze wogite ceeqinttane, yezin higgitis kiitinttanxi ixxii Xoozza yeellizane? ");
INSERT INTO oydl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Geeshi Maxaafite, «Yin mikinaate Xoozze suntsita Ayhude maaqqoosse asuntsara cazhinttane» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ne higges kiitinttiko, ne garrazinttis maade yene, yezin ne higgitis kiitinttanxi ixxko ne garrazinttidanna garrazinttikaayze fana maaqqane. ");
INSERT INTO oydl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ayhude maaqqoosse asuntsi garrazinttikaayzara, higgitis kiitnttiko, Xoozii eza garrazinttide fana faydosoone? ");
INSERT INTO oydl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Yin, Ayhude asuntsi, yinttis xaafinttide higgiton garrazinttii yeezittera, yin higges kiitinttanxi ixxiko, Ayhude maaqqoosse asuntsi garrazinttanxi ixxikon higges kiitinttii, yinttalla afa firddoda. ");
INSERT INTO oydl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Yikke, suntsara Ayhude maaqqide ubbuntsi turii Ayhude baaya. Mahi bale galla garrazizanna turii garraze baaya. ");
INSERT INTO oydl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Yezin turii Ayhudetitsi gaatstsa Ayhude maaqqizanno. Turii garrazintte Xoozze Ayyaanara oocinttize wozina garrazinttep attin xaafinttide wogite oochinttize galla garraze baaya. Ye atstse galata Xoozappa ekkanep attin asappa baaya. ");
INSERT INTO oydl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Yeezin, Ayhude maaqqizanna akko maadde? Woy garrazinttes akko maaddize bazi yeze? ");
INSERT INTO oydl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ubbappa tiino Xoozii fa qaala hyadarito Ayhuduntsis inggida. ");
INSERT INTO oydl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Yeezin, unttappa fetay fetaya qaala ammananxii ixxiko, un ixxizanna Xoozii ammaninttide Xooz maaqqizanno kayanene? ");
INSERT INTO oydl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Kayoos! Asi ubba worddo maaqqikon Xoozii turo maaqqe. Geeshi Maxaafite, «Ne qaaltte ne xillane; nena mootizaya firddara latstsane» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Yeezin, nu nagartta Xoozze xillo maaqqizanno beezize baz maaqqikon, nu waagawude? Xoozii nu nagartti gisho nuulla afa firddiko, likke baane? Yinno taanii as qofa fana gaane. ");
INSERT INTO oydl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Yinnii fana hyanippe. Yinnii gaar hyaniko, Xoozii hyanna alamttilla afa wayzi firddode? ");
INSERT INTO oydl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Yezin ta worddotitsita Xoozze turtto qonccizi, E bonchchito gaantsi beezzebaz maaqqiko, yeezin, akkos taalla fana nagaranchcho fana firdde? ");
INSERT INTO oydl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Fettii fettii asuntsi, «Lo77o yo7ode fana iita oochchoda?» yaga7i tamaarssize asi fana mahi tana mootane. Yinnii gisho yagaaze asalla afa ye7ize Xoozze firddita likke. ");
INSERT INTO oydl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yeezin, nu waagawude? Nu Ayhuduntsi, Girikeppa aadhanene? Ade! Ayhude maaqqin, Ayhude maaqqanxin ubbuntsi nagaranchcho maaqqizanno taanii tiinii yinttis ohida. ");
INSERT INTO oydl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Geeshi Maxaafite, «Xillo asi fetton baaya. ");
INSERT INTO oydl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Akaakize asi baaya, Xoozza koyze oonin baaya. ");
INSERT INTO oydl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Asi ubba balinttida; ubbuntsi fettippa maaddoosse baz maaqqida. Lo77o oochchize oonin baaya; fettii asin baaya. ");
INSERT INTO oydl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Un doontta, bugunttide booza fana; fa il7antsite worddidhdhane. Un doonttippa as wodhize, shooshi marze kezane. ");
INSERT INTO oydl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Un doontte camon baaditsi kumida. ");
INSERT INTO oydl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Un tohita suutsi lalodes ellisane. ");
INSERT INTO oydl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Un ogite dhaben qohe yene. ");
INSERT INTO oydl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Un saro oge eroos. ");
INSERT INTO oydl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Fa de7ite Xoozis zhashtoos» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","As ubba doona gordinttode fana kumutsi alamito Xoozze firddappa oomora shiishodes, higge ingginttide higgeppa oomora yezuntsis maaqqidanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Yinnii gisho, ooden higges kiitinttii Xoozze tiino xillodes dandda7oos. Higge asi ubba nagaranchcho maaqqizanno beezane. ");
INSERT INTO oydl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Yezin hyatte Xoozii asi xillize oge higge baytsi qonccizida. Yinna ogito Muse higgen nabuntsin markkidhida. ");
INSERT INTO oydl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Yinna ammanze ubbas hyanida, Xoozii Yesuus Kiristtoosa baggara as ubbas shaako baytsi inggida. ");
INSERT INTO oydl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Asi ubba nagara oochchida; Xoozze bonchcho faccizida. ");
INSERT INTO oydl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Yezin un Xoozze aadho keehatitsara, ashshize Kiristtoosa Yesuusa baggara cer xillida. ");
INSERT INTO oydl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Xoozii Yesuus Kiristtoosa zharsho mahi inggida, eza ammanze ubba E suutsite nagara atotitsi denggode fana. Xoozii yinno oochchide fa dandda7ara zaga nagartto faydikaayzara ashshii, fa xillotitsito beessades. ");
INSERT INTO oydl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Yesuusa ammanze ubba xillode fana hyatte wode Xoozze fa ommite xillo maaqqizanno beessades. ");
INSERT INTO oydl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Yeezin, nu ceeqinttize baz akko yeze? Akkon baaya. Nuunii ceeqinttizanna higges kiitinttize gishone? Ade! Ammano higgera. ");
INSERT INTO oydl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Xoozii asi xillize ammanorap attin higges kiitinttera baayzanno nu qoppane. ");
INSERT INTO oydl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Woy Xoozii Ayhuduntsi xalaala Xoozoone? Ayhude maaqqoosuntsisin Xoozii baane? Turo, Ayhude maaqqoosuntsisin E Xoozii. ");
INSERT INTO oydl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Xoozii fetto; Ayhuduntsanan Ayhude maaqqoosuntsana ammanora xillize eza. ");
INSERT INTO oydl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yeezin, nuunii higge ammano gisho dhabssodane? Ade! Higgito mintsanep attin. ");
INSERT INTO oydl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Yeezin, nu aday Abrahama akko denggido? ");
INSERT INTO oydl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abrahama oochara xillidebaz maaqqiko, E ceeqinttize baz yene, Yezin, Xoozze tiino ceeqinttodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Geeshi maxaafite, «Abrahama Xooz ammanida; Xoozii yinno ees xillotitsi mahi faydida» gayda. ");
INSERT INTO oydl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Oochchize atstses ekkize damoozita, E oocha wolqqitis ciginttize galep attin ees imo baaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Yezin oocha oochchoosse oonin nagaranchcho xillize Xoozza ammaniko, E ammantta ees xillotitsi maaqqii faydinttane. ");
INSERT INTO oydl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Geeshi Maxaafite Dawute, oocha baytsi Xoozii xillize asuntsi akko gaar anjjintezako hyannii gaar yaga7i qonccizida: ");
INSERT INTO oydl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Un balita atto ga7inttiduntsi un nagartta kaminttiduntsi anjjinttida. ");
INSERT INTO oydl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Laatstsii E nagartto faydoosse atstse anjjinttida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Yeezin, Dawute ohide anjjita garrazinttide asuntsis xalaalasone? Woy garrazinttikaayze asuntsiso? Nuunii, «Geeshi Maxaafta, ‹Abrahama Xooz ammanida; Xoozii yinno ees xillotitsi mahi faydida› gaane» nu yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Yeezin, yinna ayde hyanido? Abrahama garrazinttinine? Woy garrazinttikaayzin? Garrazintteppa tiino hyanidap attin suuba baaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahama garrazinttodannippa tiino E ammantta ees xillotetsi maaqqii faydinttidanno ersodes, E garrazintta malla maaqqida. Yinnii gisho, Abrahama garrazinttikaayzara ammanzuntsisin ammanora xillizuntsis ubba ade maaqqida. ");
INSERT INTO oydl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","E garrazinttezuntsisin ade. Abrahama unttis aday maaqqide un garrazinttide gisho xalaala baayzin E garrazinttodannippa tiino ammanide ammantto un kaallide gishos. ");
INSERT INTO oydl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abrahamasin E zerttis, «Alamito ta yinttis inggoda» yagayde ufayssita, Abrahama ammanora xillide gishos fattin higge naagii folide gisho baaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Higges kiitinttiduntsi Xoozze ufayssito laatizuntsana maaqqiko, ammano maaddoos; Xoozze ufayssitan cer maaqqane. ");
INSERT INTO oydl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Higge Xoozze kachchi ke7ine, yezin higge baayze bessa higge aadhen ashshen baaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Yinnii gisho, Xoozii inggide ufayssita ammanora ekkinttane. Hyanna ufayssita Abrahama kochchi ubbas Xoozze aadho keehatitsi baggara ingginttidanno qonccizane. Yinnan higge naagizuntsis xalaalas baayzin Abrahama fana ammanide ubbuntsis. Abrahama nu ubbuntsis ade. ");
INSERT INTO oydl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Geeshi Maxaafite, «Ta nena gaama worzhas ade mahida» ga7intti Abrahama gisho xaafinttida. Yinna ufayssita Abrahamas ingginttide hyayqqiduntsis de7o inggizen baayze baz yezize Xoozze eza maaqqidanno E ammanide gishos. ");
INSERT INTO oydl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Xoozii Abrahamas ne kochchita ganggoda gaydanna, ufayssi gaddodes akkon dandda7inttoose wode Abrahama Xooz ammanide gishon ufayssi gaddide gisho gaama worzhas ade maaqqida. ");
INSERT INTO oydl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abrahamas xeet bere kumida maaqqikon, fa cinggide ashiten Saara na7a yelodes dandda7oosanno erittera fa ammantte labbikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","E fa ammantte miinggi Xoozis bonchcho inggidap attin Xoozii inggide ufayssito ammananxii, so7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Abrahama, Xoozii inggide ufaysito folodanno fa kumutsi wozintte ammanida. ");
INSERT INTO oydl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Yinnii gisho, Xoozii E ammantto xillotitsi mahi faydida. ");
INSERT INTO oydl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Yezin, «Faydinttida» gaaze qaalize Abrahamas xalaala xaafinttikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ye qaalize nu Laatstse Yesuusa hyayqoppa dentside Xoozza ammanze nuusin nu ammantta xillotitsi maaqqii faydinttode gaar xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Xoozii eza nu nagartti gisho hyayqos aatsii inggida; E nuna xillissades hyayqoppa denddida. ");
INSERT INTO oydl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Yikke, nu ammanora xillide gisho nu laatstse Yesuus Kiristtoosa baggara Xoozara nuus sarotitsi yene. ");
INSERT INTO oydl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Nu E baggara hyatte nu eqqide aadho keehatitsite ammanora gelida. Yinnii gisho, nu Xoozze bonchcho ufayssite ceeqinttane. ");
INSERT INTO oydl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Yinno xalaala baayzin madha dandda7a ki7izanno nu erize gisho nu madhiten ceeqinttane. ");
INSERT INTO oydl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Mahi dandda7a faatana, fatanan ufayssi inggizanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Nuus inggide Geeshi Ayyaana baggara Xoozii fa siiqito nu wozintte gusside gisho yinna ufayssita nuna yeellizoos. ");
INSERT INTO oydl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nu hyaga labbiduntsana maaqqii yezin, Xoozze wode yellin, Kiristtoosa nagaranchchuntsi gisho hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Xillo as gisho hyayqqode asi denggodanna damma madha, yezin lo77o as gisho hyayqqode asi oode erize benttikaayzara attoos. ");
INSERT INTO oydl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Yezin nuunii hyaga nagaranchcho maaqqii yezin, Kiristtoosa nu gisho hyayqqida. Yinna Xoozii nuna akko gaar siiqizako E siiqito beezane. ");
INSERT INTO oydl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Yikke, nuunii Kiristtoosa suutsite xilldebaz maaqqiko, ubbappa aatsii E baggara Xoozze hyanqoppa attoda. ");
INSERT INTO oydl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nuunii Xoozara morkke, yezin E na7ay hyayqite eera giigida. Yinnippa aatsii, hyatte nuunii Xoozara giigideppa suuba E na7ay de7o mikinaatera nuunii attoda. ");
INSERT INTO oydl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Yinno xalaala baayzin hyatte nuna Xoozara giigizide nu laatstse Yesuus Kiristtoosa baggara nu Xoozalla ceeqinttane. ");
INSERT INTO oydl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Addaama baggara nagara hyanna alamite gelida. Yinna nagartti baggara hyayqo yi7ida. Asi ubba nagara oochchide gisho hyayqo as kochchi ubba yellida. ");
INSERT INTO oydl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Higge ingginttodannippa tiino alame nagara yene, yezin higge baayze wode nagara nagara maaqqii faydinttoos. ");
INSERT INTO oydl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Yezin Addaamappa Muse yellodes hyayqo as ubba ahida. Melle atto yezin, Addaama higges kiitinttanxide gisho, Addaama fana nagara oochchikaayzuntsalla afa hyayqo ka7itida. Addaama yo7odes yeze Yesuusas aazize. ");
INSERT INTO oydl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Yezin Xoozze aadho keehatitsi as nagartti fana baaya. Fettii as nagara baggara gaama asuntsi hyayqqida. Yezin Yesuus Kiristtoosa baggara Xoozze aadho keehatitsi as ubbas gaantsi ingginttida. ");
INSERT INTO oydl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Addaama nagara giddan Xoozze imo gidda gaama dummatitsi yene. Fettii as nagara baggara Xoozii eella afa firddida. Yezin asi gaama nagara oochchinin Xoozze aadho keehatitsita xillotitsi ki7ida. ");
INSERT INTO oydl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Fettii as nagara baggara hyayqo ka7itida. Yezin Yesuus Kiristtoosa baggara Xoozze aadho keehatitsin xillotitsi imo ekkize ubbuntsi, game de7or yessada. ");
INSERT INTO oydl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Yikke, fettii asi nagara oochchide baggara as ubballa firdda yi7idanni fana fettii asi xillo oochchide baggara, Xoozii as ubba xillizii unttis de7o inggane. ");
INSERT INTO oydl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Fettii asi kiitinttanxi ixxide baggara, gaama asuntsi nagaranchcho maaqqidanni fana fettii as kiitintter gaama asi xilloda. ");
INSERT INTO oydl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Asuntsi nagara wolqqa erode fana higge yi7ida, yezin nagara wolqqa gaanggide wode Xoozze aadho keehatitsi aadhii ganggida. ");
INSERT INTO oydl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nagara hyayqo wolqqara ka7itidanni fana Xoozze aadho keehatitsi xillotits wolqqara ka7iti, nu Laatstse Yesuus Kiristtoosa baggara nuna medhina de7ogo kaalitsane. ");
INSERT INTO oydl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Yeezin, nu waagawude? Xoozze aadho keehatitsita gaanggode fana nagarara miinggi yessane? ");
INSERT INTO oydl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Atto hyanoos, nuunii nagaras hyayqidebaz maaqqiko, yeezin, nuunii yikkeppa wayzi nagarara yessade? ");
INSERT INTO oydl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nu ubbuntsi Kiristtoosa Yesuusara fetto maaqqades xammaqinttide wode E hyayqite eera wolla mooginttida. ");
INSERT INTO oydl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nu xammaqinttide wode Kiristtoosara hyayqqidanne moogunttida. Kiristtoosa Xoozze Aday bonchcho wolqqara hyayqqoppa denddidanni fana nuunin kille de7o yessada. ");
INSERT INTO oydl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nu E hyayqite eera fetto maaqqiko, yinnii gaaran, E denddite eera fetto maaqqada. ");
INSERT INTO oydl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nu yikkeppa nagaras aro maaqqaame fanan nu nagaranchcho asatitsito wolqqita dhabode fana nu gal77a asatitsito Kiristtoosara suxxidanno erane. ");
INSERT INTO oydl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Fettii asi hyayqidebaz maaqqiko, E nagara wolqqappa wallo kezane. ");
INSERT INTO oydl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nuunii Kiristtoosara hyayqiko, eera de7o yessadanno ammanane. ");
INSERT INTO oydl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kiristtoosa hyayqoppa denddide gisho mahi E hyayqosannon hyayqo tiinosin eza ahosanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","E hyayqqide wode nagaras fettii tohe wurssutsi yellodes hyayqida, yezin hyatte de7o Xoozis yene. ");
INSERT INTO oydl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Yinnii fanan, yin nagaras hyayqqii, Laatstse Kiristtoos Yesuusa baggara Xoozis de7o yezanno qoppote. ");
INSERT INTO oydl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Yinnii gisho, yin, yin asatetsito amos kiitinttaame fana hyayqqize yin asatetsito nagara ahippe. ");
INSERT INTO oydl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mahi yin asatits kifiltto nagara oochchodes gene ola miishe mahi inggippete. Yezin yin hyayqoppa denddii, de7o yeze asi fana yin asatetsito Xoozis inggote. Mahi yin kumutsi asatetsito xillo ola miishe mahi Xoozis aatsii inggote. ");
INSERT INTO oydl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Yin Xoozze aadho keehatitsis oomora yenep attin higgeppa oomora yezoosse gisho nagara yinttana ahodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Yeezin, nu waagawude? Higgeppa oomora maaqqikaayzin Xoozze aadho keehatitsappa oomora yeze gisho nagara oochchodaane? Mulon hyanoos! ");
INSERT INTO oydl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Yin fettii asis kiitinttodes yinttana aro mahi inggiko yinna yin kiitinttizes aro maaqqizanno erote. Yinnii gaara, yin nagaras kiitinttiko, yinttis hyayqo ki7ize nagaras aro maaqqane. Woy yin Xoozis kiitinttiko xillotitsi ki7ize Xoozis aro maaqqane. ");
INSERT INTO oydl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Zaga yin nagaras aro, yezin hyatte yin ekkide turii timirttes kumutsi wozinappa kiitinttide gisho Xoozis galata maaqqe. ");
INSERT INTO oydl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Yin nagara arotitsi achchappa bilnttii xillotits aro maaqqida. ");
INSERT INTO oydl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Yin yin qofite labbezuntsana maaqqide gisho taanii oodesin gelize ogera ohine. Zaga yin, yin asatetsito tunan iita baz oochchodes aro mahi inggidanni fana hyatte yin asatets kifiltto geeshi maaqqade fana xillotetsi aro mahi inggote. ");
INSERT INTO oydl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Yin nagaras aro yeze wode xillotitsis aqoos. ");
INSERT INTO oydl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Yinttana hyatte yeellize zaga yin iita oochitippa akko maade denggidote? Yinna oochitis wurssutsita hyayqo. ");
INSERT INTO oydl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Yezin yin nagara arotitsappa bilinttii, Xoozze aro maaqqida. Yinna yinttana geeshi mahi medhina de7o kaalitsane. ");
INSERT INTO oydl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nagara damooze hyayqo. Yezin Xoozze, nu Laatstse Kiristtoos Yesuusa baggara inggize imotitsita medhina de7o. ");
INSERT INTO oydl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ta ishuntso, taanii higge erize asuntsis ohine. Higge fettii asi faxa yeze wode eza ahizanno eroso? ");
INSERT INTO oydl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Aazizes, azinii gelide maachita I azinze faxa yeze wode higgera ezara acinttida. Yezin I azinze hyayqiko ezara iza caaqide caaqita izo ahoos. ");
INSERT INTO oydl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Yinnii gisho, iza fa azinze faxa yezin, melle dhiiratsi geliko, iza laammida ga7inttane. Yezin I azinze hyayqiko, caaqo izo ahoosse gisho iza melle azinii geliko, iza olalida ga7inttoos. ");
INSERT INTO oydl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Yinnii gisho, ta ishuntso, yin Kiristtoosa asho baggara higge wolqqas hyayqqii, Xoozis aafe aafodes hyayqoppa denddide Kiristtoosas maaqqida. ");
INSERT INTO oydl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nu asho amo nuna ahin, nu yeze wode higge gujjii nagara oochchode gaar nuna dentsitsane. Nu ashtii gidda iita amotitsi yeze gisho nuunii hyayqo aafe aafode fana oochchane yeshsha. ");
INSERT INTO oydl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Yezin hyatte nuunii nuna accide higgitis hyayqide gisho nuunii higge achchappa bilnttida. Yinnii gisho, kille Ayyaanar Xoozis kiitinttanep attin xaafinttide gal77a higgitis kiitinttoos. ");
INSERT INTO oydl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Yeezin, nuunii waagawude? Higge nagarane? Ade! Yezin higge nagara akko yezako tana erssida. Higge, «Amudhdhippe» gaykaayzako, amudhdhe akko yezako ta eroos. ");
INSERT INTO oydl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Yezin ta ubba baz amudhdhode fana nagara higge baggara ta gidda oge denggida. Higge baayzako nagara hyayqqide baz. ");
INSERT INTO oydl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Zaga higge baayze wode ta faxa, yezin higge ingginttide wode nagara faxin ta hyayqqida. ");
INSERT INTO oydl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Taanii de7o yessade fana Xoozii inggide higge taas hyayqo ki7ida. ");
INSERT INTO oydl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nagara higge baggara tana cimmize oge denggi, wodhida. ");
INSERT INTO oydl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Yinnii gisho, higge geeshi; ize xaafinttide kiittan geeshi, xillon lo77o. ");
INSERT INTO oydl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Yeezin, lo77o maaqqide baz taalla afa hyayqo ki7idaane? Ade! Yezin nagara nagara maaqqizanna qonccode fana lo77o bazara maaddinttii taas hyayqo ki7ida. Yinnii gisho, nagara nagara maaqqidanna higge baggara aadhii erinttida. ");
INSERT INTO oydl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nuunii higge ayyaanabaz maaqqizanno erane. Yezin taanii nagaras bayzinttide asho asi. ");
INSERT INTO oydl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Taanii ta oochchizanno tiiroos; taanii kadhizebaz oochchodanno ashshii ta ixxizebaz oochchane. ");
INSERT INTO oydl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Taanii ixxizebaz oochchizebaz maaqqiko, higge lo77o maaqqizanno ta markkidhane. ");
INSERT INTO oydl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Yinno maaqqiko, yinna oochito ta gidda yeze nagartta oochchanep attin ta oochchoos. ");
INSERT INTO oydl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ta gidda, yinnan ta ashite lo77o baz baazanno erane. Lo77o baz oochchize amotitsi ta gidda yene, yezin lo77o baz oochchodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Taanii ixxize iita baz oochchanep attin ta kadhize lo77o baz oochchoos. ");
INSERT INTO oydl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Taanii ixxizebaz oochchizebaz maaqqiko, yinna ta gidda yeze nagartta oochchanep attin oochchize tana baaya. ");
INSERT INTO oydl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Yikke, ta lo77o baz oochchodes kadhizin, iita baz oochchizanno beezize higge denggida. ");
INSERT INTO oydl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Taanii ta wozintte Xoozze wogite ufayttane. ");
INSERT INTO oydl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Yezin ta asatitsite yezay ta guugite yeze higgera olinttize dumma higge be7ine. Ye higgize ta asatitsite oochchize nagara higges tana aro mahi inggida. ");
INSERT INTO oydl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Taanii wayzi alla wodhdhide aso? Hyayqos kanggize hyanna asatitsitippa tana ashshode oode? ");
INSERT INTO oydl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Nu Laatstse Yesuus Kiristtoosa baggara tana ashshize Xoozzes galata maaqqe. Yikke, taanii ta qofite Xoozze higges aqane; yezin ta asatitsite nagara higges aqane. ");
INSERT INTO oydl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Yinnii gisho, Kiristtoos Yesuusara yezuntsi hyatte firdda baaya. ");
INSERT INTO oydl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kiristtoos Yesuusa baggara nuus de7o inggize Geeshi Ayyaana higge, tana nagaran hyayqo higge arotitsappa kessida. ");
INSERT INTO oydl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nu nagara asatitsiti baggara, higge leppide gisho nuna ashshodes dandda7ikaaya. Xoozii fa na7aya nagaranchcho asuntsis aazizi nagaras zharsho maaqqode fana kiittii yinno oochchida. Yeyzi, Xoozii Kiristtoosa ashtii baggara, nagara firddi hyaasida. ");
INSERT INTO oydl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Xoozii yinno oochchidanna, nu asho amo koyzanni fana baayzin Geeshi Ayyaana koyzanni fana yeze nuulla afa higge xillo kiita folinttode fana. ");
INSERT INTO oydl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Asho qofar yezuntsi ashobaz qoppane. Yezin Geeshi Ayyaana qofar yezuntsi Geeshi Ayyaanabaz qoppane. ");
INSERT INTO oydl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nu qoftta asho amos aqiko hyayqo ke7ine, yezin ayyaanas aqiko de7on sarotits ke7ine. ");
INSERT INTO oydl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Asho amos aqize asi Xoozze higges kiitinttodes koyoosse gishon kiitinttodes dandda7oosse gisho Xoozara morkke. ");
INSERT INTO oydl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Asho amos aqizuntsi Xooz ufayssodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Yezin Xoozze Ayyaana yinttara yeziko yinttalla aqiko, yin Ayyaana qofa yenep attin yin asho amos aqoos. Kiristtoos Ayyaana baayzin oonin Kiristtoosas maaqqoos. ");
INSERT INTO oydl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Yezin Kiristtoosa yin gidda yeziko, yin asatitsito nagara baggara hyayqqidanno. Yezin yin ayyaanize xillotitsi baggara de7o yene. ");
INSERT INTO oydl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Yezin Yesuusa hyayqoppa dentside Xoozze Ayyaana yin gidda yeziko, Kiristtoosa hyayqoppa dentside Xoozii, yinttara yeze fa Geeshi Ayyaanara hyayqqide yin asatitsitis de7o inggoda. ");
INSERT INTO oydl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Yikke, ta ishuntso gale yene, nuunii nu asho amo kaallii yessades beezoos. ");
INSERT INTO oydl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Yin, yin asho amos yeziko hyayqoda, yezin Geeshi Ayyaana wolqqara nagara oochito wodhiko yin de7o yessada. ");
INSERT INTO oydl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Xoozze Ayyaana kaallize ubbuntsi Xoozze na7untsana. ");
INSERT INTO oydl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nuunii, «Abbo, ta Adayo» yaga7i xeegize, Xoozze na7untsana mahize Geeshi Ayyaana ekkidap attin mahi zhashimora yessades aro mahize ayyaana ekkikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Xoozze Ayyaana nu ayyaanara maaqqii nuunii Xoozze na7a maaqqizanno markkidhane. ");
INSERT INTO oydl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nuunii E na7a maaqqiko Xoozza laattoda; Kiristtoosara wolla yinno laattoda. Mahi nuunii Kiristtoosara waaye ekkiko eera wolla E bonchchito shaakkinttoda. ");
INSERT INTO oydl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nuunii hyatte waayize waayito, tiinoppa nuus qonccode bonchchora yeltsi bi7iko, wolkkissades dandda7inttoos ga7i qoppane. ");
INSERT INTO oydl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Medhetitsi ubba Xoozze na7a qonccitsito gaama amudhdhii kafane. ");
INSERT INTO oydl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Medhetitsi ubba hyarii maaqqida; yinnan, medhetitsita dooror baayzin ufayssara naagode fana oochchide Xoozze qofa hyanida. ");
INSERT INTO oydl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Medhetitsi fa ommite dhabe arotitsappa kezii, Xoozze na7untsara wallo bonchcho gishinttoda. ");
INSERT INTO oydl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Medhetitsi wolla hyayno yellodes yelo dha7e aykkide maachiti fana inxixeran un7ara yezanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mahi yinno medhetitsiti xalaala baayzin Geeshi Ayyaana imo ekkide nuunii, nu ommite nu asatitsitis wozo maaqqide Xoozze na7a maaqqize ufayssito naagitera nu asatitsite inxixane. ");
INSERT INTO oydl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Yinna ufaysite nuunii attida. Yezin nuunii ufayssi oochchizebaz benttize baz maaqqiko yinno oonii ufayssi oochchize? ");
INSERT INTO oydl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Yezin nu bi7ikaayze baz denggodes ga7i ufayssara naagiko yinno dandda7ara naagane. ");
INSERT INTO oydl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Yinnii gaar Geeshi Ayyaana nu labitsite maaddane. Nuunii Xooz wayzi woosodes beezizako eroos, yezin Geeshi Ayyaana fa ommite, asi ohodes dandda7oosse qaalar nuus shoobbane. ");
INSERT INTO oydl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Mahi asi wozina erize Xoozze Geeshi Ayyaana qoftta akko yezako erane. Geeshi Ayyaana Xoozze qoftti gaar geeshshuntsis shoobbane. ");
INSERT INTO oydl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Xoozza siiqizuntsisin E qoftti gaar xeeginttezuntsis Xoozii ubba baz lo77oos oochchizanno nu erane. ");
INSERT INTO oydl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Xoozza eriduntsi fa na7aya aazode fanan na7ayin ammanizunts gidda anggis maaqqade fana unttana doorii gaddida. ");
INSERT INTO oydl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Xoozii tiino dooriduntsana xeegida; xeegiduntsana xillizida; xilliziduntsana mahi bonchchida. ");
INSERT INTO oydl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Yeezin, nu hyanna ubbannis waagawude? Xoozii nu bagga maaqqiko nuna oode ixxode? ");
INSERT INTO oydl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","E melle atto yezin, fa na7ays yiqsinttikaayzara, nu gisho aatsii inggida. Yeezin, fa na7aya nuus aatsii inggide wayzi E ubba baz cer inggoso? ");
INSERT INTO oydl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Xoozii dooriduntsana oode mootode? Xillize Xoozii firddize oode? ");
INSERT INTO oydl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yeezin, unttalla afa firddodes dandda7ize oode? Oonin baaya. Hyayqoppa denddii Xoozze mizaqite bettide, Kiristtoos Yesuusa, E nuus shoobbane. ");
INSERT INTO oydl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yikke, nuna Kiristtoosa siiqoppa shagode oode? Waayene woy madhane woy bay7ene woy naye woy kallotitsone woy zhashimone woy olane? ");
INSERT INTO oydl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Geeshi Maxaafite, «Nuunii ne gisho awara kumutsi hyayqqane; shufos kanggize duro fana faydinttida» ga7intti xaafinttide fana maaqqida. ");
INSERT INTO oydl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Yezin nuunii hyanne ubba, nuna siiqize Kiristtoosara gamizuntsappa aadhane. ");
INSERT INTO oydl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Yinnii gisho, hyayqo maaqqin de7o maaqqin kiitanchchuntsana maaqqin ahizuntsana maaqqin hyatte yezaya maaqqin tiinoppa yo7odaya maaqqin wolqqamuntsana maaqqin, ");
INSERT INTO oydl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","dhoqqa maaqqin ziqqa maaqqin akko medhetitsi maaqqin nu Laatstse, Kiristtoos Yesuusara yeze Xoozze siiqoppa nuna shaakkodes dandda7oosanno taanii erida. ");
INSERT INTO oydl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Taanii Kiristtoosar turo ohine, worddidhdhoos. Geeshi Ayyaana kaalitsize ta wozintta taanii worddidhoossanno taas markkidhane. ");
INSERT INTO oydl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ta wozintte Isra7eeluntsis gaama azzanon ashshoosse waaye ta gidda yene. ");
INSERT INTO oydl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Taanii, ta ishuntsin ta iginuntsi gisho Kiristtoosappa shaakkintti Xoozze baadditsappa oomora yezezako kadhane. ");
INSERT INTO oydl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Unttin Isra7eeluntsana, Xoozii unttana fa na7untsana mahida, fa bonchchito unttis qonccizida. Unttara caaqqida; higge unttis inggida. Un Xooz goynode turii oge beezida; Xoozii ufays qaala unttis inggida. ");
INSERT INTO oydl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Un yelinttera mayzunts kochchi; mahi Kiristtoosa ashora un kochchi maaqqii yi7ida. Ubbappa kattara maaqqide Xoozze medhinas anjjinttida. Amin77e! ");
INSERT INTO oydl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Yezin, Xoozze qaaltta shaarinttida ga7e baaya. Isra7eeleppa yi7ide ubba turii Isra7eele maaqqoos. ");
INSERT INTO oydl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Mahi Abrahama kochchi ubba Abrahama na7a maaqqoos. Xoozii Abrahamas, «Ne zartta Yisaaqa baggara xeeginttoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Yinno gaazanna ashora yelinttide na7a ubbuntsi Xooz na7a maaqqoos. Yezin turii Isra7eele na7a Xoozii Abrahamas gelide qaaltti gaar yelinttide na7a. ");
INSERT INTO oydl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","yagaazanno. Xoozii inggoda ga7i gelide qaaltta, «Taanii wontsi bere hyannii wode yo7oda; Saaran dhiiratsi na7a yeloda» ");
INSERT INTO oydl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Yinno xalaala baayzin Irbbiqa fettii nu aday Yisaaqappa mentte na7untsana wodaxide wode, ");
INSERT INTO oydl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","un yelinttodeppa iita woy lo77o oochchodeppa tiino oochara baayzin doorer maaqqize Xoozze qoftta minggode fana, ");
INSERT INTO oydl_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","«Anggisse geezes kiitinttoda» yaga7i Laatstsii Irbbiqas ohida. ");
INSERT INTO oydl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ga7intti xaafinttida. Yinnan Geeshi Maxaafite, «Yayqooba kadhida, Eesawo ixxida» ");
INSERT INTO oydl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Yeezin, nu waagawude? Xoozii firdda deshizane? Ade. ");
INSERT INTO oydl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Laatstsii Musego, «Ta maarodes koyduntsana maaroda; ta yiqsinttodes koyduntsis yiqsinttoda»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Yikke, Xoozze doore as qofa woy oochara baayzin E maarotitsite. ");
INSERT INTO oydl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Geeshi Maxaafite, Gibxxe kaatizego, «Taanii, ta wolqqito neella beezodesin ta suntsita alame ubba gidda erinttode fana yinnis nena ka7itizida»ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Yikke, Xoozii maarodes koyzaya maarane; wozintto muumisades koyzay wozintto muumizane. ");
INSERT INTO oydl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Yinttappa fetay, «Yeezin, Xooz asi iita oocha gisho akkos bore? Xoozze qoftto atto gawude oode?» Ga7i oocodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Yezin ta ishayo, Xoozara lallodes ne oode? Looqappa medhinttide miishe fana medhdhidego, «Tana hyannii gaar oochchii akkos medhdhido?» ga7i oocodes dandda7ane? ");
INSERT INTO oydl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Woy looqa medhdhiday fettii looqappa fetaya bonchcho miishe, hyankkaya mahi bore miishe mahi medhdhodes adetits wolqqa baaya? ");
INSERT INTO oydl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Xoozii fa kachchito beezodes fa wolqqito erssodes koyi, firddas giigide hyanqqo na7untsana gaama genccera dandda7ezako ne akko ere? ");
INSERT INTO oydl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Yinno E oochchidanna tiinii bonchchos giigizide, fa dooride na7untsis fa bonchchito qonccissades. ");
INSERT INTO oydl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ayhuduntsana xalaala maaqqikaayzin, Ayhude maaqqoosse nuunin Xoozara doorinttida. ");
INSERT INTO oydl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nabe Hose7e maxaafite, «Ta asi maaqqikaayzuntsana, Ta asi ga7i xeegoda. Ta siiqikaayze worzhito, ‹Siiqinttiduntsana› ga7i xeegoda. ");
INSERT INTO oydl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Un, ‹Ta worzha baaya› ga7intti xeeginttide besite, ‹De7o Xoozze na7a› ga7intti xeeginttoda»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nabe Isayaasa Isra7eele asuntsbaz, «Isra7eele asuntsi abba gaxa yeze shafe fana gaanggikon, unttappa eeratsi asuntsi xalaala attoda. ");
INSERT INTO oydl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Yinna sa7alla afa ellisii folinttoda.» ");
INSERT INTO oydl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Mahi Isayaasa, «Ubbappa wolqqaama Laatstse nuus eeratsi kochchi ashshikaayzako, nuunii Soodoman gamoora katama fana dhabod yeshsha» yaga7i tiinii ohida. ");
INSERT INTO oydl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Yeezin, nu waagawude? Xillotitsi kaalloosse Ayhude maaqqoosse asuntsi ammanora xillotitsi denggida. ");
INSERT INTO oydl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Yezin xillotitsago yeltsize higge yeze Isra7eele asuntsi xillotitsi denggikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Akkos denggaanxido? Un xillotitsita ammanora baayzin oochara ekkodes koyde gishos. Yeyize gisho, un, «Dhubbize shuchchara» dhubbnttida. ");
INSERT INTO oydl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Geeshi Maxaafite, bo7ote «Taanii Xiyoone dhubbize shuchchin lallan gaddoda. Eza ammanze oonin yeellidhoos» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ta ishuntso, ta kumutsi wozintte ta amudhizannan Xooz woosizanna Isra7eele attode fana. ");
INSERT INTO oydl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Un Xoozis mishinttane yezin, turii eratitsappa mishinttosanno ta markkidhane. ");
INSERT INTO oydl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Un Xoozze xillotits ogito eranxii ixxii, fa omma xillotitsi kaallidap attin Xoozze xillotitsi koyikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Asi ubba ammanora xillode fana Kiristtoosa higge folida. ");
INSERT INTO oydl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Asi higge naagii ekkize xillotitsibaz Muse xaafittera, «Higge naagize oonin yinna higgito naagii de7o yezane»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Yezin ammanora ekkize xillotitsbaz ga7inttidanna hyanno: «Ne wozintte, ‹Oonii salo kessade?› yaga7ippe; yinna Kiristtoosa wodhissades. ");
INSERT INTO oydl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Woy, ‹Sulle sa7a oomo wodhdhode oode?› ga7ippe; yinna Kiristtoosa boozappa kessodes. ");
INSERT INTO oydl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Yezin yaga7i xaafinttida: ‹Qaala ne kale; ne doontte ne wozintte yene› Nuunii yinttis ohize ammano qaaltta hyanno. ");
INSERT INTO oydl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","«Yesuusa Laatstsii» ga7i ne doontte markkidhiko Xoozii eza hyayqoppa dentsidanno ne wozintte ammaniko, ne attoda. ");
INSERT INTO oydl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Asi fa wozintte ammanii xillane; fa doontte markkidhii attane. ");
INSERT INTO oydl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Geeshi maxaafite, «Eza ammanze oonin yeellidhoos»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Fettii Xoozze ubbunts Laatstsii maaqqide gisho Ayhuduntsana maaqqin Ayhude maaqqoosse asuntsi gidda dummatitsi baaya. E fana xeegize ubbuntsis fa anjjito gaantsi inggane. ");
INSERT INTO oydl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","«Laatstse suntsito xeegize oonin attoda.» ");
INSERT INTO oydl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Yeezin, un ammanosara wayzi eza xeegodes dandda7e? Un E baz si7ikaayzara wayzi eza ammanodes dandda7e? Mahi unttis qaala ohize asi baayzin, wayzi eza si7odes dandda7e? ");
INSERT INTO oydl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kiitinttide asi baayzin, qaala wayzi ohinttodes dandda7e? Geeshi Maxaafite, «Ufays Wonggele ohize asuntsi tohita wayzi lo77o yessa!» yaga7i xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Yezin Isayaasa, «Laatstso, nu markkatitsito oode ammanido?» yaga7idanni fana, ubbuntsi Wonggele ammanikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Yinnii gisho, ammano sissappa ye7ine; si7izannan Kiristtoosa qaalappa ye7ine. ");
INSERT INTO oydl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Maaqqo yezin, Isra7eele asuntsi qaala si7ikaaya ga7ene? Ade si7ida. Geeshi Maxaafite, «Un ootsita sa7a ubba sinttida, un qaaltta sa7a gaxa yellida»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Yezin Isra7eele asuntsi erikaaya ga7ene? Muse zaga, «Taanii yinttana leqinttide asuntsara qiirissada; mahi eeya asuntsara yinttana qiirissada»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Mahi Isayaasa, «Tana koykaayze asuntsis benttida; tana oocikaayze asuntsis qonccida» yaga7i zhashtikaayzara ohida. ");
INSERT INTO oydl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Yezin Isra7eele baz ohittera, «Ubba qamma kiitinttoosse asuntsisin tana ixxize asuntsis ta kushito miccida»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ane ta oocane: yeezin, Xoozii fa asuntsana olidaane? Olikaaya! Taanii ta ommite Isra7eele; Abrahama kochchi; Biniyame kochchi. ");
INSERT INTO oydl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Xoozii tiino dooride fa asuntsana olikaaya. Geeshi Maxaafite, Eeliyaasa Isra7eeluntsana Xoozze tiino wayzi mootezako, yin eroso? ");
INSERT INTO oydl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Eeliyaasa, «Laatstso, un ne nabuntsana wodhida, ne zharsho bestton lalida. Ta ta xalaalla attida; un tanan wodhodes koyane»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Xoozii ees waaga7i mahido? «Ba7aale eeqas goynikaayze laappun mukul asuntsana taas ashshida»yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Yinnii gaaran, hyanna wodite Xoozii fa aadho keehatitsite dooriduntsappa attide (Isra7eeluntsi) yene. ");
INSERT INTO oydl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","E unttana dooride fa aadho keehatitsitep attin un oochara baaya. Doore oochara maaqqiko, E aadho keehatitsita aadho keehatitsi maaqqoos. ");
INSERT INTO oydl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Yeezin, waydo? Isra7eele fa koyzanno denggikaaya, yezin Xoozii dooriduntsii denggida. Attiduntsi fa wozintto muumizida. ");
INSERT INTO oydl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Yezin, Geeshi Maxaafite, «Un fa aafte be7aame fana fa hyayte si7aame fana, hyanno yellodes unttis Xoozii doccize ayyaana inggida» ga7intti xaafinttide gaar hyanida. ");
INSERT INTO oydl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Mahi Dawute, «Un mu7ize gabita unttana xike fana aykko; unttana gol7ize gaga maaqqo; un iitatitsita unttana yello. ");
INSERT INTO oydl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Un be7aame fana un aaftta goozintto; ubba wode waayeppa denddi yin bantta kuunnii yezo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Yeezin, Ayhuduntsi mahi denddaame fana gol7idaane? Baaya! Un gol7ita Ayhude maaqqoosse asuntsi attode fana mikinaate maaqqida. Yinnan Ayhuduntsi unttalla afa qana7ode fana oochchida. ");
INSERT INTO oydl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ayhudutsi nagartta alamttis gaama anjjo ki7ida; mahi un gol7ita Ayhude maaqqoosse asuntsis gaama anjjo maaqqida. Yeezin, doorinttide Ayhuduntsi kumutsi attize wode anjjo akko fana ganggod yeshsha! ");
INSERT INTO oydl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Taanii, hyatte yinttis Ayhude maaqqoosse asuntsis ohine. Ayhude maaqqoosse asuntsi hawaare maaqqii oochchizanne taanii gaama ceeqinttane. ");
INSERT INTO oydl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ta yinno oochchidanna taas asho kochchi maaqqize Isra7eeluntsana qiirizidanna unttappa eeratsito ashshodes. ");
INSERT INTO oydl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Xoozii unttana olii ashshide wode hyanna alamtta Xoozara giigida. Xoozii unttana shiishii ekkize wode hyayqide asi hyayqoppa denddize fana maaqqida. ");
INSERT INTO oydl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Tiino minxa aafize Xoozis zharshinttide geeshi maaqqiko, mulo minxa aafttan geeshi. Minxizes xaphita geeshi maaqqiko, zhanggitan geeshi. ");
INSERT INTO oydl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Gade tukkide shamahe zhangge maaqqide Ayhuduntsi meqqiko, yin gurdde dolide shamahe zhangge maaqqize Ayhude maaqqoosuntsin un bessa dhantsinttii un aafe anjjiton duretitsito shaakkinttida. ");
INSERT INTO oydl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Yikke, yin zhangge fana sarfinttii wodhdhide Ayhuduntsalla afa uturtippete. Yin uturtize baz maaqqiko, xapho yinttana tookkidap attin yin xapho tookkoosanno qoppote. ");
INSERT INTO oydl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Neenii, «Yikke ta un besite gelode fana» ga7i qoppoda. ");
INSERT INTO oydl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Yinna turo. Un ammanikaayze gisho sarfinttida. Ne ammanide gisho yinna besite eqqida. Ne zhashtodes beezanep attin uturtodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Xoozii medho zhangge maaqqize Ayhuduntsis yiqsinttanxiko yinttisin yiqsinttoos. ");
INSERT INTO oydl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Yikke, Xoozii akko gaar dalggan akko gaar zhashizako bo7o. E zhashizanna kiitinttosuntsalla, mahi E dalggatitsita yin ammanii miinggi eqqiko yinttis. Miinggi eqqanxiko yinttin sarfinttoda. ");
INSERT INTO oydl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ayhuduntsi ammaniko, zaga yeze besite maaqqada. Xoozii unttana mahi, geltsodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Yinttana gurdde yeze shamahe maaqqide Ayhude maaqqikaayzuntsana gachchii, gade tukkide shamahella afa yinttana dhantsiko, medho gade shamahe maaqqide Ayhuduntsana fa tiino bessa mahi tukkodes wayzi dandda7inttoosa? ");
INSERT INTO oydl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ta ishuntso, yin yinttana eranchcha ga7i ceeqinttippete. Ta yinttis ohize fettii saza qofa yene. Yinnan Isra7eeluntsi si7anxi ixxidanna wurssutsi yellodes maaqqikaayzin attodes yeze Ayhude maaqqoosse asuntsi kumutsi Xoozago ye7ode wontsis. ");
INSERT INTO oydl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Yinnii gaar, Isra7eele asuntsi ubbanna attoda. Geeshi Maxaafite, «Nuna ashshizay Xiyooneppa yo7oda; Yayqooba kochchappa iita ubba hyaasoda. ");
INSERT INTO oydl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Taanii un nagartto atto gaaze wode unttara gelize caaqita hyanno» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ayhuduntsi Wonggele ekkanxide gisho yinttara morkke. Maaqqoyezin, hyatten un doornttide gishon, Xoozii un adunts gisho unttana kadhane. ");
INSERT INTO oydl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Xoozii fa imoten fa xeegiten qiiridhdhoos. ");
INSERT INTO oydl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Yin Ayhude maaqqoosuntsi zaga Xoozis kiitinttikaaya. Yezin hyatte Ayhuduntsi kiitinttanxi ixxin, yin Xoozze maarotitsito ekkida. ");
INSERT INTO oydl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Yinnii gaar, yin ekkide maarotitsito Ayhuduntsi ekkode fana hyatte Xoozis kiitinttanxi ixxida. ");
INSERT INTO oydl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Xoozii as ubbuntsis fa maarotitsito beezodes koyi, asi ubba kiitinttoosuntsana ga7i faydida. ");
INSERT INTO oydl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Xoozze duretitsi, cinccatitsin eratitsi qoppii ohode oode? E firddita qurichinttoos, E ogita erinttoos. ");
INSERT INTO oydl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Geeshi Maxaafite, «Laatstse qofa erize oode? eza zorodes dandda7ize oode? ");
INSERT INTO oydl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Xoozis tal77izen tal7idanno mahi ekkize oode?» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ubbanna eeppa; eeran eesi. Ees medhinas bonchcho maaqqe. Amin77e. ");
INSERT INTO oydl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Yikke, ta ishuntso, Xoozza ufayssize, de7on geeshi zharsho mahi, yin galtto shiishode fana taanii yinttana Xoozze maarotitsite woossane. Yinnan Xoozza yin goynodes beezize turii oge. ");
INSERT INTO oydl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Lo77o, ufayssizen folo maaqqide Xoozze qofa shaakkii erodes yin wozintte laaminttotep attin hyanna alamito aazippete. ");
INSERT INTO oydl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Xoozii yin fetays fetays inggide ammanttii fana wozinaama asi fana qoppote. Qoppodes beezizannippa aatsii yinttana dummuzii, uturara qoppipete ga7i taas ingginttide aadho keehatitsite yinttis ohine. ");
INSERT INTO oydl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nu fettii gallitii gidda dumma dumma billituntsi yene; yinna dumma dumma billituntsis dumma dumma oocha yene. ");
INSERT INTO oydl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Yinnii gaar, nuunii gaama asi maaqqikon Kiristtoosara fettii galla maaqqida. Nuunii fettii galla maaqqii dumma dumma billite fetay fetayra aykinttida. ");
INSERT INTO oydl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Nuus ingginttide aadho keehatitsite dumma dumma imo yene. Nu imotta tinbbite ohe maaqqiko, nuus yeze ammanttii gaar ohodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Nu imotta melluntsana maade maaqqiko, yinna oochite minggodes beezane; tamaarsse maaqqiko, yinna tamaarssite minggodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Nu imotta melluntsana mintsitse maaqqiko, miinggi mintsitsodes beezane. Nu imotta nuus yeze bazappa melluntsis ingge maaqqiko, wozinappa inggodes beezane. Nu imotta ahe maaqqiko, miinggi ahodes beezane. Nu imotta melluntsis keehe maaqqiko, ufayssara keehodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Yin siiqita afurappa kattara maaqqodes beezoos. Iita baz ixxote; lo77o baz mintsii aykkote. ");
INSERT INTO oydl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Fetay fatayra ishe fana siiqinttote; fetay fetaya bonchchote. ");
INSERT INTO oydl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Azal7ippete; yin ayyaanar miinggi Laatstsis oochchote. ");
INSERT INTO oydl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Xoozii inggide ufayssara ufayttote; madha dandda7ote; ubba wode Xooz woossote. ");
INSERT INTO oydl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ammanze geeshshuntsana koshshize bazara maaddote; zaqqo mokkote. ");
INSERT INTO oydl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Yinttana bay7izuntsana anjjote; anjjotep attin baaddippete. ");
INSERT INTO oydl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ufayttizuntsara ufayttote; yeekkizuntsara yeekkote. ");
INSERT INTO oydl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Fetay fetayra fettii qofite yezote. Utura qofa ashshii, yinttana ziqii yiizii, aada asuntsara wolla yezote. Yin yinttana era ga7i qoppipete. ");
INSERT INTO oydl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ooden yinttis iita baz oochchiko, ye atstses iita mahippete. As ubba tiino nashshize lo77o oocha oochchote. ");
INSERT INTO oydl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Dandda7inttiko as ubbara saro yessades yinttis dandda7inttizanno ubba oochchote. ");
INSERT INTO oydl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ta ishuntso, yin, yin ommite asis qime mahippete. Xoozii qime mahode fana ees ashshote. Geeshi Maxaafite, «Taanii qime mahoda; taanii kushito mahoda» yagaane Laatstsii, ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Yezin Geeshi Maxaafite, «Ne morkkizaya naydhdhiko muzo; E baridhdhiko ushsho. Ne yinno oochchiko E ommite tama qaaqa gussane» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Iita lo77or gamotep attin iitara gaminttippe. ");
INSERT INTO oydl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Xoozze qofa baayzin adetits wolqqa ingginttoose gishon hyatte yeze shuumuntsin Xoozze qofara shuumunttide gisho asi ubba worzha ahizuntsis kiitnttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Yinnii gisho, adetits wolqqara yezuntsis kiitinttanxi ixxize oonin Xoozze kiita ixxane. Kiitinttanxi ixxize oonin faalla afa firdda ke7ine. ");
INSERT INTO oydl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ahizuntsii iita oochchizuntsana fattin lo77o oochchizuntsana zhashoos. Ahizuntsis zhashitaanxodes koyane? Yeezako lo77o oochcho; un nena galatoda. ");
INSERT INTO oydl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Un lo77o baz oochchodes shuumunttide Xoozze aro. Yezin ne iita baz oochchiko, un iita baz oochchiza seerize mashsha aykkide gisho unttis zhashito. Un iita oochchizuntsana seerii, Xoozze hyanqqo qonccize Xoozze aro. ");
INSERT INTO oydl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Yinnii gisho, Xoozze kachchi xalaalas baayzin yin qoftta markkidhize gisho worzha ahizuntsis kiitinttodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Yin giira giirizannan yinnis. Worzha ahizuntsii yinna oochito oochchizanna, un Xoozze aro maaqqide gishos. ");
INSERT INTO oydl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Fetes fetes beezanno inggote. Giira giirodes beezays giirote; qaraxe gachchodes beezays qaraxe gachchote; zhashtodes beezays zhashtote; bonchcho beezaya bonchchote. ");
INSERT INTO oydl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Fetay fetera siiqinttote. Siiqo galep attin yinttalla afa melle gale yezippe. Asi siiqize oonin higge gaazanno folida. ");
INSERT INTO oydl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«Laammippe; wodhippe; kaystippe; amudhdhippe» gaaze kiittan melluntsin ubba, «Asi ne ommiti fana kadho» gaaze kiitte accinttida. ");
INSERT INTO oydl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Asi siiqize oonin ezalla afa iita baz oochchoos. Yinnii gisho, asi siiqize higge kiita folida. ");
INSERT INTO oydl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Genttoppa yin barkkize wode hyatte yellidanno erote. Nu ammanide woditippa aadhii atotitsi hyatte nuugo ukkida. ");
INSERT INTO oydl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Qamma aadhida; wontta ukkida. Yikke, nuunii dhuma oocha ashshii foo7o ola miishe aykkoda. ");
INSERT INTO oydl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ane awara foo7o yeze asi fana wogara yezote. Beezoosse yetstsaran matstsera maaqqippe olale hyantteran qayxer aykkinttide dumma dumma tuna oocha, Lalleran qinaatera maaqqippe. ");
INSERT INTO oydl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Laatstse Yesuus Kiristtoosa ma77ote; yin nagara asho fa amuto folode fana qoppipete. ");
INSERT INTO oydl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ammanora labbide oonan shiishii ekkotep attin E qoftilla afa firddippete. ");
INSERT INTO oydl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Aazizes, ammanora miinggide fettii asi akko katstsan ma7ades dandda7ane. Yezin ammanora labbide asi atakiltte xalaala muune. ");
INSERT INTO oydl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Muuze asi mo7oosse atstsa borippe. Mo7oosse atstse muuze atstsella afa firddippe. Xoozii ubbuntsana ekkane. ");
INSERT INTO oydl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Melle as arolla firddize ne oode? E labbin woy miinggin E Laatstse erane. Laatstsii eza essodes dandda7ize gisho E miinggi eqqoda. ");
INSERT INTO oydl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Mahi «Fettii awara melle awarappa aadhane» yaga7i qoppize asi yene. Melle mahi, «Awara ubba fettii fana» ga7i qoppane. Yezin fete fete fa qoftto qoppii oochcho. ");
INSERT INTO oydl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Fettii qammiza melle qammitipa aatsii bonchchize oonin Laatstse bonchchos ga7i oochchane. Katstsa muuze asi Laatstse bonchchos ga7i muune. E muuze yinna katsitii gisho Xooz galatane. Katstsa mo7oosse asi Laatstse bonchchos me7anxi ashshane; mahi me7anxi ashsheran Xooz galatane. ");
INSERT INTO oydl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nuuppa oonin faas yezoos; mahi nu giddappa oonin faas hyayqoos. ");
INSERT INTO oydl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nu de7or yeziko Laatstsis yessada; mahi hyayqqikon Laatstsis hyayqqoda. Yikke, nu de7or yezin woy hyayqqikon Laatstsis. ");
INSERT INTO oydl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kiristtoosa hyayqqii hyayqqoppa denddide, de7or yezuntsisin hyayqqiduntsis Laatstse maaqqades. ");
INSERT INTO oydl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Yeezin, ne ne ishella afa akkos firdde? Woy ne ne isha akkos leqqe? Nuunii ubbanna Xoozze firdda oyda tiino eqqoda. ");
INSERT INTO oydl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Geeshi Maxaafite Laatstsii, «Taanii de7o; asi ubba ta tiino bunqqinttoda; taanii Xooz maaqqizanno markkidhoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Yikke, nu oochchide bazitis nu ommite ommite Xooz tiino shiiqii mahe inggoda. ");
INSERT INTO oydl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Yinnii gisho, nuunii fetay fetaylla afa firddizanno ashshote. Yezin yin ishaya dhubutsaame fana woy qaxxaame fana naaginttote. ");
INSERT INTO oydl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Laatstse Yesuusa ammanze asi maaqqii, fa ommite tuna maaqqide baz baayzanno taanii geeshi erane. Yezin fettii asi fettii baz tuna mahi qoppiko yinna ees tuna maaqqane. ");
INSERT INTO oydl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ne muuze katstsa gisho ne ishaya dhubbize baz maaqqiko, Kiristtoosa yeze ne ishaya siiqoos. Kiristtoosa E gisho hyayqqide atstsa ne muuze katstsiti gisho dhabsippe. ");
INSERT INTO oydl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Yikke, yinttis yeze lo77o bazito cazhizippete. ");
INSERT INTO oydl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Xoozze ka7itumo Geeshi Ayyaanara benttize xillotetsi, sarotitsin turii ufayssap attin muuze bazin uzhize bazi baaya. ");
INSERT INTO oydl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Yinnii gaar Kiristtoosas oochchize asi Xooz ufayssane; as giddan anjjinttane. ");
INSERT INTO oydl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Yinnii gisho, ane nuunii sarotitsi benttize ogen fete fetaya ammanora mintsize oge koyote. ");
INSERT INTO oydl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Katstsa gisho ga7i Xoozze oochito lalippe. Katstsa ubba geeshi, yezin melle asi nagarara dhubbize katstsa mu7izanna iita. ");
INSERT INTO oydl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ne ishay dhubunttaame fana asho mo7oosanna woy ushi uzhoosanna woy ne ishay dhubbize akko bazin oochchoosanna lo77o. ");
INSERT INTO oydl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Yikke, ne ammantto ne giddan ne Xoozze gidda naago. Likke ga7i qoppidebaz oochchize wode E wozintta mootoosse atstse anjjinttidaya. ");
INSERT INTO oydl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Yezin so7itter muuze atstses E muuze ammanora maaqqikaayze gisho firddinttane. Ammano baayzin oochinttide oocha ubba nagara. ");
INSERT INTO oydl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nuunii minggiduntsi labbiduntsi toofito tookkodes beezane. Nuunii nuna ufayssodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nuunii nu dootsiza mintsitsodes maaddodesin ufayssodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kiristtoosa fana ufayssikaaya. Yezin Geeshi Maxaafite, «Nena boride borita nuna yellida»ga7intti xaafinttidanni gaar hyanida. ");
INSERT INTO oydl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Geeshi Maxaafite inggize genccon mintsitsera nu ufayssito ekkode fana Geeshi Maxaafite xaafinttide ubbanna nuna tamaarssodes xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Genccon mintsitimo inggize Laatstse yin Kiristtoos Yesuusa kaallize wode fettetitsi yinttis imme. ");
INSERT INTO oydl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Yinnan, nu Laatstse Yesuus Kiristtoosa Adaya, Xoozza, fettetitsaran fettii qaalara yin bonchchode fana. ");
INSERT INTO oydl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kiristtoosa yinttana ekkidanni fana Xoozze bonchchos fetay fetaya ekkote. ");
INSERT INTO oydl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Xoozii zaga aduntsis inggide ufayssita folinttode fanan E turetitsita erinttode fana Kiristtoosa Ayhudunts garraze woga folera aro maaqqii yi7idanno ta yinttis ohine. ");
INSERT INTO oydl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Kiristtoosa Ayhudunts garraze woga aro maaqqide melle mikinaata mahi Ayhude maaqqoosse asuntsi Xoozze maarotitsiti gisho galatode fana. Geeshi Maxaafite, «Ta nena Ayhude maaqqoosse asunts gidda galatoda; Ne suntsito mazmurer sabboda» ga7intti xaafinttide gaar hyanida. ");
INSERT INTO oydl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Mahi, «Ayhude maaqqoosse asuntso, Xoozze asuntsara ufayttote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Hyatten mahi, «Ayhude maaqqoosse asuntso, Laatstsa galatote; worzha ubba eza sabbote» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Yinnii gaar Isayaasa, «Issey kochchappa yelinttode fetay ye7oda; E ka7itumo ubba ahoda. Un fa ufayssito eella afa gaddoda» yagayda. ");
INSERT INTO oydl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Geeshi Ayyaana wolqqara yin diccode fana ufayssi inggide Xoozze, yin ammanttii baggara yinttis ufayssin sarotits kumutsi imme. ");
INSERT INTO oydl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ta ishuntso, yinttara lo77otitsin eratitsi kumiduntsana mahi fetay fetaya zorodes dandda7izanno ta loytsii erane. ");
INSERT INTO oydl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Taanii yinttana fettii fettibaz qofissades koyi zhashtikaayzara Xoozze aadho keehatitsara yinttis xaafida. ");
INSERT INTO oydl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Taanii Kiristtoos Yesuusa aro maaqqii, Ayhude maaqqoosuntsis kahine fana maaqqii, Wonggele ohode fana Xoozii taas aadho keehatitsi inggida. Ayhude maaqqoosse asuntsi Geeshi Ayyaanara geezhi, Xooz ufayssize zharsho maaqqode fana Xoozii yinno oochchida. ");
INSERT INTO oydl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Taanii Kiristtoos Yesuusar maaqqii ta Xoozzes oochchize oochite ceeqinttane. ");
INSERT INTO oydl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ayhude maaqqoosse asuntsi Xoozis kiitinttode fana, Kiristtoosa ta qaaltten ta oochchiti baggara oochchide oochchitippa melle ta ceeqinttize baz baaya. ");
INSERT INTO oydl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Xoozii yinno kille baz oocharan Geeshi Ayyaana wolqqara wayzi oochchezako ta yinttis ohoda. Taanii Yerusalaameppa dentsii, Iliwarqoone yellodes Kiristtoosa Wonggele sabbakida. ");
INSERT INTO oydl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Taanii melle asi baaside baasalla keexxodes koyoos. Kiristtoosa suntsita xeeginttikaayze bessa Wonggele ohodes amudhdhane. ");
INSERT INTO oydl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Geeshi Maxaafite, «E bazi ohinttikaayze asuntsi eza be7ada; E baz si7ikaayze asuntsi qoppoda» ga7intti xaafinttida. ");
INSERT INTO oydl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Yinnii mikinaatera, taanii yinttago yo7odes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Yezin taanii hyatte hyanna gututo ubba ta yellii hyaaside gishon gaama bereppa dentsii yinttana be7odes amudhdhide gisho ");
INSERT INTO oydl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","taanii Isppeene hyanggitera yinttana be7odes qoppida. Mahi eeratsi wode yinttara ufayttideppa suuba Isppeene hyanggize wode yin oges tana maaddode fana koyane. ");
INSERT INTO oydl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Yezin hyatte taanii Xoozze asuntsana maaddodes Yerusalaame hyanggoda. ");
INSERT INTO oydl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Maqedooniyan Akkaya gidda yeze Xoozze asuntsi, Yerusalaame yeze dahuntsana miishera maaddodes koyde gisho. ");
INSERT INTO oydl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Un dahuntsana maaddizanna unttis attoossebaz maaqqide gisho fa ommite yinno oochchodes qofa accida. Ayhuduntsara Ayhude maaqqikaayzuntsin ayyaana anjjo shaginttiko, un mahi unttis yeze bazara Ayhuduntsana maaddodes beezane. ");
INSERT INTO oydl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Yinnii gisho, taanii yinna shiiqide miishito unttis inggi un ekkidanno erideppa suuba Isppeene hyanggitera yin kalera aadhoda. ");
INSERT INTO oydl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Taanii yinttago hyanggize wode Kiristtoosa anjjo kumutsi ekkii hyanggodanno erane. ");
INSERT INTO oydl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ta ishuntso, taas Xooz woossittera ta butuntte taara eqqode fana Laatstse Yesuus Kiristtoosaran Geeshi Ayyaana siiqite yinttana woossane. ");
INSERT INTO oydl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Xoozii tana Yihuda yeze ammanoose asuntsappa ashshode fana Yerusalaame ta oochchode oochita Xooz asunts kale ekkinttode fana taas woossote. ");
INSERT INTO oydl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Mahi Xoozii gayko, taanii yinttago hyanggi ufayssara yinttara shemppode fana taas woossote. ");
INSERT INTO oydl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Sarotits Xoozze yin ubbuntsara maaqqe. Amin77e. ");
INSERT INTO oydl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kinkkiriya katama yeze woosa keetstsite oochchize nu mishita Feeba lo77o maacho maaqqidanno yin erode fana koyane. ");
INSERT INTO oydl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Yin izo ammanze asuntsi Laatstse suntsite mokkodes beezize ammanze asuntsappa fete fana mokkite. Iza yinttappa koyze baz ubba izo maaddote. Iza fa ommite gaama asi maaddida; mahi tana ta ommite gaama maaddida. ");
INSERT INTO oydl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kiristtoos Yesuusa oocha taara wolla oochchize Phirisqilan Aqiila saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Un ta gisho fa shemppito aatsii inggida. Ta xalaalas baayzin Ayhude maaqqoosse asunts woosa keetsuntsin ubba unttana galatane. ");
INSERT INTO oydl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Un kara shiiqize ammanzunts saro ga7ote. Isiya sa7a Kiristtoosa tiino ammanide, ta kadhize Ephanexoosas ta saritsito yeltsote. ");
INSERT INTO oydl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Yinnii gisho oochara gaama labbide Mayramo saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Taara achi keetstsa yezide ta Ayhude lagguntsana Anddironiqoosan Yuuniyasa saro ga7ote. Un Yesuusa hawaaruntsi gidda erinttiduntsana. Mahi un Kiristtoosa taappa tiino ammanida. ");
INSERT INTO oydl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Laatstse ammanze ta siiqo laggiza, Amphiliyaxoosa saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Kiristtoosa oocha nuura wolla oochchize Urbbanoosan ta kadhize Isttakuusa saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Kiristtoosas yezanna fattanintti ammantsize Apheliisa saro ga7ote. Arsxobuloosa kara asuntsana saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ta Ayhude laggiza Heroodiyoona saro ga7ote. Narssisanen E kara asuntsappa Kiristtoosa ammaniduntsana saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Laatstse oocha labbize Tirufaynan Tirufoosa saro ga7ote. Mahi Laatstsis gaama labbii oochchize, ta kadhize Phersiiso saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Laatstse oochara gaama erinttide Rufoosasin tana fa na7a fana be7ize E intto saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asinikirttoosas, Filegoonas, Hermmeesas, Patirobaasasin unttara yeze ammanze ishuntsi ubbuntsis ta saritsito ohote. ");
INSERT INTO oydl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filoloogusa, Yuuliya, Neeriya, E mishito, Olumppoosan unttara yeze ammanze asuntsana ubba saro ga7ote. ");
INSERT INTO oydl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Geeshi yeerintte yeerinttitera, fetay fetaya saritsote. Kiristtoosa woosa keetstsi ubba yinttana saro gaane. ");
INSERT INTO oydl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ta ishuntso, yin tamaaride timirttito ixxii, yin gidda shaakkintten madha medhdhize asuntsappa naaginttote. Unttappa hyaakkote. ");
INSERT INTO oydl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Yinnii fana yeze asuntsi fa sazasip attin nu Laatstse Kiristtoosas oochchoos. Fa mal77ize doonaran yiqsize qaalara akko eroosse asunts wozintto balitsane. ");
INSERT INTO oydl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Wonggeles yin kiitinttidanno asi ubba si7ide gisho tana ufayssane. Yezin yin lo77o baz erode fana iita bazappa hyaakkode fana ta koyane. ");
INSERT INTO oydl_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Sarotits Xoozze Xalahe yin tohitippa oomora gaacii oloda. Nu Laatstse Yesuus Kiristtoosa aadho keehatitsita yinttara maaqqe. ");
INSERT INTO oydl_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Taara oochchize Ximotiyoosa yinttana lo77o yagayda. Yinnii gaaran, ta iginuntsi Luqiyosa, Iyaasonen Sosphaxiroosa yinttana saro gaane. ");
INSERT INTO oydl_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Hyay dabddaabbiza Phawuloosas xaafide taanii, Xarxiyoosa, yinttana Laatstse suntsite saro gaane. ");
INSERT INTO oydl_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Tana mokkize woosa keetsito ubba E kara shiiqize Gaayoosa, yinttana saro gayda. Katama miishe aykkize Erasxoosan nu ishe Qarxoosa yinttana saro gaane.  ");
INSERT INTO oydl_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Nu Laatstse Yesuus Kiristtoosa aadho keehatitsi yin ubbara maaqqe. Amin77e. ");
INSERT INTO oydl_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Xoozis galata maaqqe. Taanii, Yesuus Kiristtoosa baz ohize Wonggele qaaltte gaama wodeppa aachintti gam7ide turetitsara, Xoozii yinttana ammanora mintsii essodes dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Yezin hyatte yinna turita qonccida. Ka7itumo ubba ammanii kiitinttode fana medhina Xoozze kiitte nabuntsi yinna turttibaz xaafida. ");
INSERT INTO oydl_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Yesuus Kiristtoosa baggara cinccatitsi E xalaalas yeze, fettii Xoozzes medhinas bonchcho maaqqe. Amin77e.");
INSERT INTO oydl_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Xoozze qofara Yesuus Kiristtoosa hawaare maaqqades xeeginttide Phawuloosan, nu ishe Sostenisa, ");
INSERT INTO oydl_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Qoronttoosa yeze Xoozze woosa keetsitis, Yesuus Kiristtoosara geezhiduntsis unttisin nuus Laatstsi maaqqide nu Laatstse Yesuus Kiristtoosa suntsito ubba bessa xeegize ubbuntsis; ");
INSERT INTO oydl_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Xoozze, nu Adeppan Laatstse Yesuus Kiristtoosappa yinttis aadho keehatitsin sarotitsi maaqqe. ");
INSERT INTO oydl_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Xoozii Kiristtoos Yesuusa baggara yinttis inggide aadho keehatitsiti gisho taanii ubba wode Xoozza galatane. ");
INSERT INTO oydl_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ubba bazara oheran maaqqin eratitsara Kiristtoosara duridhdhida. ");
INSERT INTO oydl_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Nu Kiristtoosa baz ohide markkatitsita yin gidda minggida. ");
INSERT INTO oydl_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Yinnii gisho, yin nu Laatstse Yesuus Kiristtoosa qonccitsito naagitera yeziko akko ayyaana imon yinttis faccoos. ");
INSERT INTO oydl_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ezin mahi nu Laatstse Yesuus Kiristtoosa lam7intsa ye7ite bore baayzuntsana maaqqii wurssutsi yellode gaar yinttana miintsoda. ");
INSERT INTO oydl_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Fa Na7aygo, nu Laatstse Yesuus Kiristtoosa fettetitsago xeegide Xoozze ammaninttidaya. ");
INSERT INTO oydl_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ta ishuntso, yin gidda shaakkintte yezippe; ubbuntsi giigii fettii wozinaran fettii qofara maaqqii yezote, yaga7i nu Laatstse Yesuus Kiristtoosa suntsite ta yinttana woossane. ");
INSERT INTO oydl_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ta ishuntso, Qelo7e kara asuntsi yin gidda lalle yezanno taas ohida. ");
INSERT INTO oydl_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Yinttappa fete fete, «Taanii Phawuloosas; taanii Aphiloosas; taanii Phexiroosas; taanii Kiristtoosas» yagaane. ");
INSERT INTO oydl_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Yeezin Kiristtoosa shaakkinttidaane? Yin gisho masqalalla afa suxunttide Phawuloosaane? Woy yin Phawuloosa suntsite xammaqinttidane? ");
INSERT INTO oydl_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Taanii Qarisphoosappan Gaayoosappan melle yinttappa ooden xammaqikaayze gisho Xooz galatane. ");
INSERT INTO oydl_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Yinnii gisho, ooden yinttana ta suntsite xammaqinttida ga7i ohodes dandda7ize baaya. ");
INSERT INTO oydl_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Mahi Isxifaanosa kara asuntsana ta xammaqida, gujjii melle oona xammaqezakon tiirinttoos. ");
INSERT INTO oydl_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kiristtoosa tana kiittidanna Wonggele ohode gaarap attin xammaqode gaar baaya. Kiristtoosa masqala cer maaqqaame gaar Wonggele qaala ta tamaarssizanna as cinccatitsi qaalara baaya. ");
INSERT INTO oydl_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Masqala qaaltta dhabizuntsis eeyatitsi, yezin nuus attiduntsis Xoozze wolqqa. ");
INSERT INTO oydl_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Geeshi Maxaafite, «Taanii cinccuntsi cinccatitsito dhabssoda; eruntsi eratitsito dhabisoda» yagaane. ");
INSERT INTO oydl_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Yeezin, cincca aba yene? Higge asttamaarize aba yene? Woy hyanna alame eruntsi aba yene? Xoozii hyanna alame cinccatitsito eeyatitsi mahikaane? ");
INSERT INTO oydl_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Hyanna alame asuntsi fa cinccatitsara Xoozza eraame fana Xoozii fa cinccatitsara gorddida; yezin eeyatitsara faydinttize, nu ohize Wonggele qaala ammaniduntsii attode gaar Xoozze lo77o qofa maaqqida. ");
INSERT INTO oydl_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ayhuduntsi kille baz be7ades koyane; mahi Girikuntsi cinccatitsi koyane. ");
INSERT INTO oydl_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Yezin nuunii masqalalla afa suxunttide Kiristtoosa sabbakane. Yinna Ayhuduntsis dhube; mahi Girikuntsis eeyatitsi. ");
INSERT INTO oydl_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Yezin Xoozii xeeginttiduntsis, Ayhude maaqqin, Girike maaqqin Kiristtoosa Xoozze wolqqan Xoozze cinccatitsi. ");
INSERT INTO oydl_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Xoozze eeyatitsita as cinccatitsappa aadhane; mahi Xoozze labitsita as xaalatitsappa aadhane. ");
INSERT INTO oydl_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Yikke, ta ishuntso, yin xeegitsito bo7ote; asi fana cincca maaqqide gaamuntsi, wolqqara yeze gaamuntsi, shuuma maaqqide gaamuntsi xeeginttikaaya. ");
INSERT INTO oydl_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Yezin Xoozii cinccuntsana yeellisades alame yeze eeyuntsana doorida; mahi miintsuntsana yeellisades alame yeze labitsuntsana doorida. ");
INSERT INTO oydl_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Xoozii hyanna alamite damma ga7inttidebaz dhabssodes, hyanna alamite labitsuntsana, leqqinttiduntsana akko hyanosuntsana doorida. ");
INSERT INTO oydl_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Ooden Xoozze tiino ceeqqinttippe. Yezin ceeqinttize ooden Xoozalla ceqintto. ");
INSERT INTO oydl_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Yezin Xoozii yinttis Kiristtoos Yesuusara fettetitsa yessade gaar yiizida. E nuus Xoozappa cinccatitsi, xillotitsi, geeshshatitsin wozon maaqqida. ");
INSERT INTO oydl_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Yinnii gisho, Geeshi Maxaafite, «Ceeqinttize ooden Laatstsara ceeqqo» yagayda. ");
INSERT INTO oydl_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ta ishuntso, taanii yinttago Xoozze qaala yinttis ohitera yi7ize wode qaalaran cinccatitsara aadhii yi7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Taanii yinttara yeze wode Yesuus Kiristtoosa ezin masqalalla afa suxunttideppa melle erodes koyoos ga7i ta qofa accida. ");
INSERT INTO oydl_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ta yinttara yeze wode labitsimora, zhashimoran gaama goqera yezida. ");
INSERT INTO oydl_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ta ohitan ta sabbakita sa7a eraran doona cinccatitsara maaqqikaayzin Xoozze Geeshi Ayyaana wolqqa qonccitsite. ");
INSERT INTO oydl_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Yinnan, yin ammantta Xoozze wolqqara fattin as cinccatitsalla kataame fana. ");
INSERT INTO oydl_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ayyaana de7o dicciduntsis nuunii cinccatitsi qaalara ohine. Yezin yinna cinccatitsita, hyanna alame cinccatitsito woy dhabodes yeze hyanna alamito ahizunts cinccatitsito baaya. ");
INSERT INTO oydl_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Yezin nuunii ohize cinccatitsita, gaama wodeppa tiino Xoozii nu bonchchos giigizidannon aachintti yeze Xoozze cinccatitsito. ");
INSERT INTO oydl_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Hyanna alamtto ahizuntsappa ooden hyanna cinccatitsito erikaaya. Un erizebaz maaqqezako, bonchcho Laatstse masqalalla afa suxxaama yeshsha. ");
INSERT INTO oydl_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Yezin Geeshi Maxaafite, «Aafe bi7ikaayze baz, hyaye si7ikaayzebaz, wozina qoppikaayzebaz, Xoozii fana siiqizuntsis giigizida» yagaane. ");
INSERT INTO oydl_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Nuus Xoozii Geeshi Ayyaana baggara qonccizida. Geeshi Ayyaana melle atto yezin Xoozze gaatsi qofa ubba qurichchane. ");
INSERT INTO oydl_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","As gidda yeze baz atstse gidda yeze ayyaanza fattin as baz ooden eroos. Yinnii gaar, Xoozze baz Xoozze Ayyaana fattin ooden eroos. ");
INSERT INTO oydl_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Xoozii nuus hyarii inggidanno nu erode gaar Xoozze Ayyaana ekkida fattin hyanna alamtti ayyaana ekkikaaya. ");
INSERT INTO oydl_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Yinnii gisho nuunii ayyaana qofa, ayyaana asuntsana tamaarssizanna as cinccatitsara maaqqikaayzin Xoozze Ayyaana inggize cinccatitsara. ");
INSERT INTO oydl_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Yezin Geeshi Ayyaana baayze asi Xoozze Ayyaanappa ingginttize imo ekkodes dandda7oos. Yinna ees eeyatitsi; ubbanna Geeshi Ayyaanara qurichinttizanni gisho E erodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Yezin Geeshi Ayyaana yeze asi ubba baz qurichchane, yezin eza ooden qurichchoos. ");
INSERT INTO oydl_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Geeshi Maxaafite, «Laatstse wozintto erize oode? eza zorodes dandda7ize oode?» ga7intti xaafinttidanni fana. Yezin nuus Kiristtoosa wozina yene. ");
INSERT INTO oydl_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Ta ishuntso, yin Kiristtoosa gidda hyaga zhoogan ammanoose asuntsi fana yeze gisho taanii ayyaanabaz yinttis ohodes dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Yin mintsi katstsa maades dandda7ikaayze gisho taanii yinttana maatsi shichchida; hyatten maaqqiko yin dandda7ikaaya. ");
INSERT INTO oydl_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Hyatten hyaga yin asho qofara yene. Yin gidda yeze qanaaten lallen yin ammanoose asi fana yezanno erisosaane? Yin oochchizanna asho qofara yeze asi fana baane? ");
INSERT INTO oydl_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Yinttappa fete, «Taanii Phawuloosas» melluntsi mahi, «Taanii Aphiloosas» gayko, Xooz Ayyaana baayze asi fana baane? ");
INSERT INTO oydl_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Yeezin, Aphiloosa oode? Phawuloosa oode? Un yin ammanode fana oochchide Xoozze oochanchcho. Xoozii fetes fetes inggide oochiti gaar oochchane. ");
INSERT INTO oydl_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ta tukkida; Aphiloosa hyaatsi ushshida, yezin dichchide Xoozii. ");
INSERT INTO oydl_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Yinnii gisho, dichchide Xoozza fattin tukkizen hyaatsi ushshizen akkon baaya. ");
INSERT INTO oydl_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tukkizen hyaatsi ushshizen wolla fetto, yezin fete fete fa oochchii labbide gaar anjjo ekkoda. ");
INSERT INTO oydl_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Nuunii Xoozis oochchize gade; Xoozze keetstsa eera wolla oochchizuntsana. ");
INSERT INTO oydl_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Xoozii taas inggide aadho keehatitsiti gaar yiillar yeze anaaxe fana baasa olida. Melle asi eella afa keexxane. Yezin eella afa keexxize ooden wayzi keexizako, faas naagintto. ");
INSERT INTO oydl_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Fettii tohe olinttide baasappa melle ooden baasa olodes dandda7oos. Ezin Yesuus Kiristtoosa. ");
INSERT INTO oydl_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Yezin hyay baasizella afa ooden worqqara woy birara maaqqin, al77o shuchchara woy minxara maaqqin, maatara woy hyawulera keexxiko, ");
INSERT INTO oydl_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","fete fete ye baasizella afa akkora keexizako firdda wode tamar qonccoda. ");
INSERT INTO oydl_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Ooden ye baasizella afa keexxide keetsita tamar mu7inttanxiko, fa anjjito ekkoda. ");
INSERT INTO oydl_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Yezin oode oochitan tamar mu7inttiko, qohinttoda; yezin, E fa ommite attodan tamappa attizaya maaqqoda. ");
INSERT INTO oydl_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Yin Xoozze keetsi maaqqidannon Xoozze Ayyaana yinttara yezanno erosaane? ");
INSERT INTO oydl_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ooden Xoozze keetsito laliko, Xoozin eza laloda. Xoozze keetsita geeshi; yinnan yinttana. ");
INSERT INTO oydl_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ooden fana cimmippe. Hyanna alamite cincca fana aazizide yeziko Xoozze turii cinccito denggode fana ooden cinccatitsito eeyatitsi mahi faydo. ");
INSERT INTO oydl_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Hyanna alamiti cinccatitsita Xoozze tiino eeyatitsi. Geeshi Maxaafite, «Xoozii cinccuntsana un gene oochitira aykkida» yagayda. ");
INSERT INTO oydl_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Mahi, «Cinccuntsi qoftta maaddoose baz maaqqidanno Laatstsi erane» yagayda. ");
INSERT INTO oydl_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Yinnii gisho, ubba bazi yinttis maaqqade gisho ooden asalla ceeqinttippe. ");
INSERT INTO oydl_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Phawuloosa maaqqin, Aphiloosa maaqqin Phexiroosa maaqqin, hyanna alamito maaqqin, de7o maaqqin, hyayqo maaqqin, yezaya maaqqin, tiinoppa ye7odaya maaqqin, ubbanna yinttis. ");
INSERT INTO oydl_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Yinttin Kiristtoosas; Kiristtoosan Xoozis. ");
INSERT INTO oydl_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Yinnii fana asi nuna Kiristtoosa aro fana Xoozze gaatsi qofa qonccizi tamaarssize hyadara ingginttide asi fana mahi faydo. ");
INSERT INTO oydl_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Tamaarssizuntsi Laatstses ammaninttiduntsana maaqqades beezane. ");
INSERT INTO oydl_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Yezin yin woy melluntsi taalla firddiko, taas akkon baaya. Melle atto, taanin taalla afa firddodes dandda7oos. ");
INSERT INTO oydl_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ta erzanni gaar maaqqiko ta wozintta taalla firddoos, yezin yinnan ta xillotitsito beezoos. Taalla afa firddoday Laatstsa xalaala. ");
INSERT INTO oydl_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Yinnii gisho, wode yellikaayzin, Laatstsii yi7ikaayzin oodellan firddifete. E dhuma aachinttide baz foo7o kessoda; as wozina aachinttide qofa qonccissada. Ye wode fete fete Xoozzeppa beezize galata ekkoda. ");
INSERT INTO oydl_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Ta ishuntso, yinttana maaddo ga7i tanan Aphiloosan aazize mahi ta ohida. Yinno ta yiizidanna, «Xaafinttidannippa aadhifite» yagaaze zortto yin nuuppa tamaarode fana. Yinnii gisho, ooden feta nashshii hyankkaya leqqodes beezoos. ");
INSERT INTO oydl_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Neenii melluntsappa akkora aadhe? Neenii ekkikaayzebaz akko yeze? Yeezin, neenii ubba baz melle asappa ekkidebaz maaqqiko, ekkikaayze asi fana akkos ceeqintte? ");
INSERT INTO oydl_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Hyatte yin mizhida. Hyatte yin duridhdhida. Nu shaakkintti yin xalaala ka7itida. Yin turo ka7itezako, nuunin yinttara ka7itod yeshsha. ");
INSERT INTO oydl_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Xoozii nuna hawaaruntsana, hyayqo firddinttide asi fana as ubbappa nuna suub aatsida taas aazane. Nuunii hyanna alamitis, kiitanchchosin asisin kaas baz maaqqida. ");
INSERT INTO oydl_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Nuunii Kiristtoosa gisho eeya maaqqida, yezin yin Kiristtoosa gidda cinccuntsana maaqqida. Nuunii labitsi, yezin yin mintsi maaqqida. Yin bonchchinttida, yezin nuunii toochinttida. ");
INSERT INTO oydl_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Hyayno yellodes nu naydhdhane, baridhdhane, kallidhane, hyadhinttane; yessade keetsi dhabin madha be7ine. ");
INSERT INTO oydl_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Nuunii nu kushite oochchii aqane. Nuna asi cazhodera anjjane; nuna bay7ize wode dandda7ane. ");
INSERT INTO oydl_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Un nuna cazhize woden nu suntsito iissize wode aadatitsara mahane. Nu hyano yellodes alame buuren alla olinttide fixo maaqqida. ");
INSERT INTO oydl_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Taanii yinno xaafidanna, ta kadhize na7unts fana, yinttana zorodes xaafida fattin yeellisades baaya. ");
INSERT INTO oydl_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Kiristtoosa gidda yinttana dichchize gaama kaalitsizunts yezikon, yinttis gaama aduntsi baaya. Ta yinttana Kiristtoos Yesuusa Wonggelera yelida. ");
INSERT INTO oydl_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Yikke, yin tana aazote ga7i yinttana woossane. ");
INSERT INTO oydl_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Yinnii gisho, ammantsizen, ta kadhize, Laatstse baggara ta na7a maaqqide, Ximotiyoosa yinttago kiittida. E dumma dumma bessa yeze woosa keetstsa ta tamaarsside, Kiristtoosa Yesuusa gidda yeze ta ogito yinttana qofissada. ");
INSERT INTO oydl_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Taanii yinttago ye7aame fana aazin, uturara kumide fettii fettii asuntsi yene. ");
INSERT INTO oydl_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Yezin Laatstsii gayko, ukkera taanii yinttago yo7oda. Ye wode taanii uturanchchunts ohito xalaala baayzin un wolqqiton erodes koyane. ");
INSERT INTO oydl_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Xoozze ka7itumo wolqqara fattin ohera baaya. ");
INSERT INTO oydl_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Taanii yinttago gufera yo7onene woy siiqoran aadatits ayyaanara yo7one? Yin aayya doorete? ");
INSERT INTO oydl_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Yin gidda olale hyantta yezanna zigirinttane. Yinnii fana yeze olale hyantta melle atto yezin, ammanoose asuntsin oochchoos. Yin gidda fa aday machchitira tunide asi yene. ");
INSERT INTO oydl_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Yinne yin azzanodesin yeellidhodes beezane, yezin yin utirida. Yinnii gaar borsizebaz oochchide atstsa yin giddappa kessodes beezoso? ");
INSERT INTO oydl_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Taanii ashora yinttara yezanxikon ayyaanara ta yinttara yene. Taanii yinttara yeze asi fana yii7i yinnii gaarize oocha oochchide atstsella firddida. ");
INSERT INTO oydl_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Nu Laatstse Yesuus Kiristtoosa suntsite yin shiiqize wode taanii ayyaanara yinttara yessada. Yinne Laatstse Yesuus Kiristtoosa wolqqa yinttara maaqqada. ");
INSERT INTO oydl_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Ye atstse nagara ashita dhabii, E ayyaanize Laatstse Yesuusa firdda wode attode fana E Xalahes aadhii inggintto. ");
INSERT INTO oydl_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Yin ceeqita lo77o baaya. Eerats irshsho buka ubba dentsizanno erosaane? ");
INSERT INTO oydl_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Yin hyatte irshsho baayze buka maaqqade gaar, nagara irshsho yinttappa kessote. Nu Faasiga duro maaqqide Kiristtoosa zharshinttida. ");
INSERT INTO oydl_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Yinnii gisho, genen iitatitsi yeze irshshora maaqqikaayzin turetitsin geeshshatitsi yeze boorara nu baalito bonchchoda. ");
INSERT INTO oydl_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Ta tiino xaafide kiitite yin olale asuntsara yellinttaame gaar yinttis ohida. ");
INSERT INTO oydl_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Yinno gaazanna hyanna alamite yeze olale hyanttizuntsana woy zhaaridhizuntsara woy kaystizuntsara woy eeqa goynizuntsara mulo yellinttippete ga7e baaya. Yinno maaqqiko, hyanna alamttippa yin kessades beezane yeshsha. ");
INSERT INTO oydl_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Yezin ammanane ga7ite olale hyanttizuntsara woy zhaaridhizuntsara woy eeqa goynizuntsara woy cazhizuntsara woy matsnttizuntsara woy kaystizuntsara yellinttippete ga7i yinttis ohine. Yentses gaarize asara melle atto yezin, katstsan mu7ippete. ");
INSERT INTO oydl_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Woosa keetstsappa balera yezuntsalla afa firddodes tana akko madhe? Woosa keetsite yezuntsalla afa yin firddosaane? ");
INSERT INTO oydl_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Yezin balera yezuntsalla afa Xoozii firddoda. Yinna iita baz oochchize atstsa yin giddappa kessote. ");
INSERT INTO oydl_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Yin giddappa fete fetera mooto yeziko, yinno ammanze as tiino firddinttodanno ashshii ammanoose as tiino firddinttodes wayzi qite? ");
INSERT INTO oydl_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Geeshshuntsi alamella firddodanno yin eroso? Yeezin, yin alamella firddizebaz maaqqiko, hyannii fana eeratsbaz firddodes wayzi dandda7oso? ");
INSERT INTO oydl_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Nuunii kiitanchcholla firddodanno erosaane? Yeezin, hyanna sa7a yessi bazalla afa firddodanna yinttana wayzi game? ");
INSERT INTO oydl_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Yeezin, yinnii fana mooto yin gidda medhinttiko, woosa keetstsa leqinttide asunts tiino firddinttodes wayzi kanggete? ");
INSERT INTO oydl_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Taanii yinttana yeellisades yinno gaane. Yin gidda kacinttide asuntsana giigisades dandda7ize akaakize asi baa? ");
INSERT INTO oydl_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Yeezin, fettii ammanzay hyankkay ammanzaya firdda keetstsa