﻿USE sofia;
DROP TABLE IF EXISTS sofia.pll_vpl;
CREATE TABLE pll_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pll_vpl WRITE;
INSERT INTO pll_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ယာမ်စ ဆဒါင်ကျ ကွံန်ဖြာ အကျံင်ယေဆုခရိ မိူဝ်ႈခိူည်အီုဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ပ်ုန်တဲမ်အူန် တန်ုဘေဲႇကျံမ် ပရောဖက်ဟေရှာယမိူဝ်ႈ၊ “ဖြာဒါႈ၊ ‘ငိူပ်မေန်၊ အောဒီပ္လေါည်လေႈ ဖဇ်ုတပ္လေင်အော ရအာတ်မီ၊ အတွ ရဲန်ပိူဝ်ႈဒဲႈ ရဒေင်လာ်ႈ ကီုရ်ညာဖြာ။’ ");
INSERT INTO pll_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","တန်ုကန္တာရ ဘီအူကူပြိုႈဒါႈ၊ ‘ရဲန်ဘြဲရဒေင် အတွစွလေႈ ကီုရ်ညာဖြာ၊ ရ်ုရ်ဒဲႈ ရဒေင်လာ်ႈအ်ုန် ဆီုဝ်ဆီုဝ်အေ့။’ ” ");
INSERT INTO pll_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ကောပ်ခိူည်ဒီန် ယောဟန် ပေါရောတ်ဒေ ဟောဂြည်တရာ တန်ုကန္တာရ ဒဲႈပွံတ် မံင်ဂလာဗတ္တိဇံ။ အ်ုန်ဒါႈ တဘီဂဲ၊ “ဒဲႈပဲလှောႇဖိူမ် ဒိုရ်အပေတ်ဒေ ခါမ်ပွံတ် မံင်ဂလာဗတ္တိဇံ၊ က်ုန်ညာခိူည်ဒီန် ဖြာ ဒီပ္လိုတ်ခွါင်ဒဲႈ အပေတ်ပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","အခိင်ဒီန် ဘီကုင်ဘီရူ တကုင်ယေရုရှလင်၊ ဘီကပီုန်ကုင်ယုဒ ဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲဒီန် လေႈလာ်ႈဇူ တယောဟန်။ ဂဲလာည်ဂြည်ပျဒိုည်ႇ အပေတ် ပ်ုန်က်ုရ်လူတ်ဒေ တအ်ုန် ဂဲခါမ်ဒိုည်ႇပွံတ် မံင်ဂလာဗတ္တိဇံ န်ုအိုမ်ယော်ဒန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ယောဟန် ချူပ်ဒေဒါ ဂြူရ်ုရ် တဟုကလာအု၊ တုပွံတ်ႎံရ်ဆဲႇဆရေ တညွည်ဒေ၊ အ်ုန်ဟောမ် ႎါႇဆျှံတ်ငှေါဂါရ် ငါမ်ဖျံရ်ဘြီ။ ");
INSERT INTO pll_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","အ်ုန်ပြိုႈဂြည် တဘီဂဲ၊ “အီအ်ုန်မျြံတ်ဒါင် ဒိုရ်အော ဒီစွလေႈရဘံန်အောယာ့်။ ကူပ်အောကာႈဒဲႈ ႎံရ်ချှူပ်စာပ်အ်ုန်လိုည် အောကာထိူဝ်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","အောအီုဝ် ဒဲႈတပဲ မံင်ဂလာဗတ္တိဇံ ဇ်ုတ်တအိုမ်၊ ကောည်လိုည် အ်ုန်ဒီဒါႎိငျံန်ဆပဲ ဒဲႈမံင်ဂလာဗတ္တိဇံ တပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","အခိင်ဒီန် ယေဆု ယိူဝ်ႇဒိုရ် ကုင်နာဇရက် တကပီုန်ဂါလိလဲ၊ စွလေႈဇူ ခါမ်ပွံတ် မံင်ဂလာဗတ္တိဇံ တယောဟန် တအိုမ်ယော်ဒန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ယာမ်ယေဆု ယိူဝ်ႇဇံင် ဒိုရ်န်ုအိုမ်၊ အ်ုန်ယိူဝ်ဒေငိူပ် ပ္လေင်က်ုရ်ပိူဝ်ႈပွံတ်ဒေ၊ ႎိငျံန်ဖြာ ညာခိူည်ဆီမ်အပ္လိုည် လေႈစံပ် ဒါ့်တပါင်ယာႇဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ဟွည်ႇဒီန် ဂံရ်ႈလေႈ ဒိုရ်န်ုပ္လေင်ဒီန် ဒါႈ၊ “မီ မိူဝ်ႈညှိုႈ ကွံန်ပ်ုန်ရံက်အောယာ့်၊ မီဇူႈညှိုႈ နွံရ်ႈဖိူမ်အော။” ");
INSERT INTO pll_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ဟွည်ႇဒီန် ႎိငျံန် တောႇလာ်ႈပွံတ် ယေဆု တန်ုကန္တာရ အူဒီန်တောအူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ယာမ်ဒီန် အ်ုန်ဂွည်ဒေ တန်ုကန္တာရ ဖိုန်ကိူရ်ဆငီ၊ ဘ်ုပ်က်ုရ်တူႈ စာတန် ကီုရ်နံမ်ချှိုဂဲ ကဝ်ဆျှူစုင်ဇာမ်ဒေ။ အ်ုန်ဂွည်ရူမ် ဇောမ်တိုဘြီချှိုဂဲ အရာပ်ဒီန်၊ တမန်ဇ်ုဂဲတပ္လေင်မိူဝ်ႈ လေႈပေါဒေ ဟျံင်လူမ်လာပွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ယောဟန် ဟွည်ႇ က်ုရ်တူႈ ဘ်ုပ်ဇာ်ႈထံင်၊ ယေဆု စွလာ်ႈပွံတ်ဒေ တကပီုန်ကုင် ဂါလိလဲ၊ ဟွည်ႇဒီန် အ်ုန်ဟောဂြည် ဆဒါင်ကျဖြာ၊ ");
INSERT INTO pll_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","အ်ုန်ဒါႈ “အခိင်ဟွည်ႇပြေ့စုင်၊ ကပီုန်ကုင်ဖြာ ဟွည်ႇဒံတ်တဲယာ့်၊ ဒဲႈပဲလှောႇဖိူမ် ဒိုရ်အပေတ်ဒေ၊ ညှိုမ်ဆဒါင်ကျအီုဝ်အေ့။” ");
INSERT INTO pll_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ယာမ်ယေဆု စွလာ်ႈရာင်ကောည်ဒေ တပြါအိုမ်ဆက္လုင် ဂါလိလဲ၊ အ်ုန်ယိူဝ်ဒေငိူပ် ရှိမုန် ဇီုဝ်ပေတရုဂါရ် အန္ဒြေ ႎါႎည် မိူဝ်ႈအီဘဲႇကာ၊ ဂါရ်ဒါ့်ပျာ်ႈ ရရ်ုပ်ကာဒေ တန်ုအိုမ်ဆက္လုင်။ ");
INSERT INTO pll_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ယေဆုဒါႈ တဂါရ်၊ “လာ်ႈ ဇောမ်ရဘံန်အော၊ ပါရ်အာရ်ကူဒီန် အောဒီဒဲႈပဲပဲန် အီဘဲႇတိုဘီ။” ");
INSERT INTO pll_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ဂဲဒီန်မိူဝ်ႈ ပဲတ်ပွံတ်ရရ်ုပ်ကာဒေ အူဒီန်တောအူဒီန် လာ်ႈဇောမ်ပွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ဘံန်ဟွည်ႇ စွလာ်ႈဘိုန် အရာပ်ဒီန်တရီတ် အ်ုန်ယိူဝ်ဒေငိူပ် ကွံန်အီမဲဇေဗေဒဲ ယာကုပ်ဂါရ် ယောဟန် ႎါႎည်အာရ်ကူ၊ ဂဲ ဒါ့်က်ုန်ဘာန် ရရ်ုပ်ကာဒေ တပါင်ရိူဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ဘံန်ယေဆု ယိူဝ်ဒေငိူပ် အ်ုန်တောႇပွံတ်ဂါရ် အူဒီန်တောအူဒီန်၊ ဂါရ်ဒီန် ပဲတ်ပဲတ် ကူန်ဒေ ဇေဗေဒဲ ဒါ့်ဂွည်ဒေဇောမ်ဘီစာင်ဂဲ တပါင်ရိူဝ် လာ်ႈဇောမ်ပွံတ် ရဘံန်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ဟွည်ႇဒီန် ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ လာ်ႈလီပ်ဒိုည်ႇ တန်ုကုင် ကပေရနောင်၊ ဘံန်ရောတ် ဆငီဆဒါင် ယေဆုလီပ်ပွံတ် တကျောင်ရဆောန်ဒဲႈတရာ အ်ုန်ဆာင်ဆောန်ပွံတ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ယာမ်ဒီန်ဖုင်ဘီဂဲ ယိူဝ်ဒေဆတီုင် ငဲပ်ုန်ဆာင်ဆောန်အ်ုန် ဂဲညာအာမ်ဒိုည်ႇပွံတ်ဒေ။ ပ်ုန်ဆာင်ဆောန်ဒဲႈအ်ုန် ကာနှေရ်စိ ခိူည်တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ၊ ညာခိူည် ဘီယိူဝ်အခွါင်အာဏာ ဆုင်မဆာင်ဆောန်ဒဲႈ တဘီဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ဟွည်ႇဒီန် တန်ုကျောင်ရဆောန်ဒဲႈတရာ ယိူဝ်ကီုရ်နံမ်ကာကျကာလ လီပ်စံပ် တအီအူကူ လာ်ႈရောတ် အ်ုန်ပြိုႈဒေဒါႈ၊ ");
INSERT INTO pll_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“အိူဝ် ကွံန်ကုင်နာဇရက် ယေဆု၊ ဆေမီ က်ုရ်ဆဴင် တယဲ၊ မီလာ်ႈရောတ် တအရာပ်အီုဝ် မိူဝ်ႈအတွ ပ်ုန်လူယဲအဲႈ။ အဆေမီမိူဝ်ႈ ယဲနံပ်အေ့၊ မီမိူဝ်ႈ ဘီမျြံတ်ဆပဲဖြာ။” ");
INSERT INTO pll_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ယေဆု ဒါႈငဲဆုင်မပွံတ် တကီုရ်နံမ်ကာကျကာလဒီန်၊ “ဂွည်ညီမ်ညီမ်၊ လေႈပွံတ်မီ ဒိုရ်အ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","အခိင်ဒီန် ကီုရ်နံမ်ကာကျကာလ ဟွည်ႇယူႈရဲင်ပ်ုန်ခေါပွံတ် အီကူဒီန်၊ ပြိုႈဂံရ်ႈရဲင်ရဲင် လေႈပွံတ်ဒေ ဒိုရ်တိုအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ဟွည်ႇဒီန် ဘီဂဲ ညာအာမ်ဒိုည်ႇပွံတ်ဒေ၊ ဂဲလာည်က်ုရ်မိုန်တဒေ အူကူတောအူကူ ဂဲဒါႈ၊ “ပ်ုန်ဆာင်ဆောန်အ်ုန် က်ုန်မဲအီုဝ် ဆေမိူဝ်ႈအဲႈ။ အီကူအီုဝ် ယိူဝ်အခွါင်အာဏာ ဘံန်အ်ုန်ဒဲႈအမိင် တကီုရ်နံမ်ကာကျကာလဂဲ ဂဲဇူဒိုည်ႇငဲပ်ုန်ဂြည်အ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ဘံန်ညာခိူည်ဒီန် အကျံင် ဆဒါင်ယေဆုမိူဝ်ႈ ပြံတ်ဖာည်ပွံတ်ဒေ တန်ုကပီုန်ဂါလိလဲ အရာပ်တွံန်တီတွံန်တီ။ ");
INSERT INTO pll_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ဟွည်ႇဒီန် ယေဆုလေႈရူမ်ဇောမ် တဘဲႇဒေ ယာကုပ်ဂါရ် ယောဟန် ဒိုရ်ကျောင်ရဆောန်ဒဲႈတရာ၊ လာ်ႈပွံတ်တဂါင် ရှိမုန်ဂါရ် အန္ဒြေ။ ");
INSERT INTO pll_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ကန်ရှိမုန်ပီ စံပ်ဆူဖိူဝ်နာ ဒါ့်အီတ်နှေရ်ဒေ တရအီတ်၊ ဂဲဂြည်ပွံတ် အကျံင်အ်ုန် တယေဆု အူဒီန်တောအူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","အ်ုန်လာ်ႈဇူပွံတ် အီပ်ုန်ဒီန်၊ ဘာတီပျိုႇယိူဝ်ႇပွံတ်အ်ုန်၊ ဒံင်အူကပြေ့ ဆူဖိူဝ်နာအ်ုန်ဒီန် ဟြာည်ပွံတ်ဒေ။ အ်ုန်ယိူဝ်ႇဘဲပွံတ်ဒေ ရ်ုရ်ခါမ်ခဲႇ ဟျံင်လူမ်လာပွံတ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","အခိင်ဆငီလီပ် စူန်မှိူဝ်ဒီန် ဘီဂဲ ဒေါလာ်ႈဒေဒိူည် ဘ်ုရ်ယိူဝ်ဘီဆူနာဂဲဂါရ် ဘီကီုရ်နံမ်ချှို လီပ်စံပ်တဂဲ တရအာတ်ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ဘီပည်ကုင်ဂဲဒီန် လာ်ႈရောတ်ဒေက်ုရ်စုဒိုည်ႇ တရအာတ်ဘာင်ဘိုႈဂါင်။ ");
INSERT INTO pll_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","အခိင်ဒီန် ဘီဘ်ုပ်ရောဂါ တွံန်မျိုတွံန်နဲ ယေဆု ဟွည်ႇဒဲႈဂဲချံမ်ဆာ၊ ရူပ်လေႈဒိုည်ႇပဲတ် ကီုရ်နံမ်ချှိုတဂဲ။ ကောပ်ကီုရ်နံမ်ချှိုဂဲဒီန် နံပ်အ်ုန်မိူဝ်ႈအဆေ၊ ငဲအူမိုတ်လိုည် အ်ုန်ကာဒဲႈစိ အခွါင်တဂဲဂြည်။ ");
INSERT INTO pll_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ဆငီဘံန် အခိင်ရႎါရ်ႈဇံဝ်ဇံဝ်၊ ယေဆု ယိူဝ်ႇလေႈဒိုရ်ဂါင် စွလာ်ႈဆုတောင် တအရာပ်ယေန်ညီမ်။ ");
INSERT INTO pll_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","အခိင်ဒီန် ရှိမုန်ဂါရ် ဘူဂေါဘူဆေဂဲ ဇောမ်ဒေလဲမ်ဒိုည်ႇအ်ုန်၊ ");
INSERT INTO pll_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ဘံန်ဂဲယိူဝ်ဒေငိူပ်အ်ုန် ဂဲဒါႈ၊ “ဘီဂဲ လဲမ်ဒိုည်ႇမီ။” ");
INSERT INTO pll_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ကောည်လိုည် ယေဆုဒါႈတဂဲ၊ “အယ်လာ်ႈဒိုည်ႇ အတွဒဲႈအောဘိူန်အော ဟောဂြည်တရာ တရူက်ုရ်ဒံတ်အရာပ်အီုဝ်။ ကောပ်မိူဝ်ႈခိူည်ဒီန် အောတလာ်ႈပေါရောတ် ဟာအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ဘံန်ညာခိူည်ဒီန် အ်ုန်လာ်ႈဒေင် တကပီုန်ကုင်ဂါလိလဲ အရာပ်တွံန်တီတွံန်ဒဲန်၊ အ်ုန်ဟောဂြည်တရာ တကျောင်ရဆောန်ဒဲႈတရာဂဲ ရူပ်လေႈဒိုည်ႇ ကီုရ်နံမ်ချှို။ ");
INSERT INTO pll_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ဘီဘ်ုပ်တူတ်အူကူဒီန် လာ်ႈရောတ်ဒေ မာ့်ပ်ုရ်ဒ်ုပ်ပွံတ် တရအာတ်ယေဆု၊ အ်ုန်မှာန်ဒါႈ၊ “မီက်ုန်ယိူဝ်နွံရ်ႈဖိူမ်၊ မီဘဲအေ့ဒေ ရ်ုရ်ဒဲႈအောဆပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ယေဆု ယိူဝ်နွံရ်ႈဖိူမ်က်ုရ်ႎေအ်ုန်၊ ဆာတ်တီဒေ ထိပွံတ်တိုအီကူဒီန်။ အ်ုန်ႎီရ်ဒါႈ၊ “အောယိူဝ်အေ့ နွံရ်ႈဖိူမ်၊ ဒဲႈမီရောတ်တဆပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ဒံင်အူကပြေ့ တူတ်ပ်ုန်ဘ်ုပ်အ်ုန်ဒီန် မိူဝ်ႈဟြာည် ဆပဲပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ဟွည်ႇဒီန် ယေဆု တံမ်ရံတ်ငဲတအ်ုန် ဒဲႈအ်ုန်ႎေင်ပွံတ်ဒေ အူဒီန်တောအူဒီန်၊ ");
INSERT INTO pll_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ဘံန်ဟွည်ႇဒါႈတအ်ုန်၊ “ဆတီုင်ဘိူဝ်၊ မီမာည်ဂြည်တအဆေ အကျံင်အီုဝ်၊ လာ်ႈပွံတ်မီ တတာယဇ်ပုရောဟိတ် ဒဲႈဂဲစဲတ်မီ၊ က်ုန်ဟွည်ႇ ပျတိုဒေတဂဲ၊ ခိူည်မီရောတ်တဆပဲအီုဝ် ဒဲႈမီပဲန်ဆာ့်ဆေ တရအာတ်ဘီဂဲ၊ လှူအာပ်ကာပ်ဒဲႈပ်ုန်လှူ ခိူည်ပ်ုန်ပိင်ငျှံပ်အူန် မောရှေ တပဲအေ့။” ");
INSERT INTO pll_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ကောည်လိုည် အီကူဒီန် လေႈပွံတ်ဒေ လာ်ႈဂြည်ဆဒါင်ဒီန် တအရာပ်တွံန်တီ၊ ဘံန်အ်ုန်ဂြည်ဆဒါင်ဒီန်ဘ္လံမ် ယေဆုကာဂိူပ်ယာႇလီပ်ဂွည် တက်ုန်ဒီဘီ လိူရ်ႈလိူရ်ႈ။ ဆဲႈဒီန်၊ အ်ုန်ဂွည်ဂိူဝ်ဒေ တဘြီရိူဝ်ႇကုင် အရာပ်ယေန်ညီမ်၊ အခိင်ဒီန် ဘီအရာပ်တွံန်တီ လာ်ႈရောတ်ပေါဒိုည်ႇတအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ဟွည်ႇဇီုဝ့်အူႎံင် ယေဆု ႎီရ်လီပ်ဒေ တကုင်ကပေရနောင်၊ ဘီဂဲယိူဝ်ဒေဆတီုင် ဆဒါင် အ်ုန်ဒါ့်ဂွည်ဒေတဂါင်။ ");
INSERT INTO pll_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ လာ်ႈက်ုရ်စုဒိုည်ႇဒေ တရအာတ် ဘာင်ဘိုႈဂါင် မောဂိူပ်ကာယိူဝ်ရဂွည်၊ ယေဆု ဒါ့်ဟောဂြည် ဒဲႈဂဲဆတီုင် ငဲတရာ။ ");
INSERT INTO pll_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ယာမ်ဒီန် ဘီဖိုန်ကူဂဲ က်ုရ်ကွံက်ဒေဒိူည်လာ်ႈ ဘီဘ်ုပ်တီဇိူင်ဇ်ုမ် အူကူ ပေါတယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ကောပ်ဘီက်ုရ်စု ကီုန်လူတ်လာည်၊ ဘံန်ဂဲကာဘိူန်ဒေဒိူည်လာ်ႈ တအ်ုန်၊ ဂဲဟာ့်ပွံတ်တကြောင်ဂါင် တက်ုရ်ႎိူည်ယေဆု။ ဘံန်ဂဲဟွည်ႇစာ်ႈ လျှပိူဝ်ႈက်ုရ်ဘာ့်ဂါင်၊ ပျာ်ႈတခြုံရ်လေႈပွံတ် ဘီဘ်ုပ်တီဇိူင်ဇ်ုမ်ဂါရ် ပေရ်ရအီတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ဘံန်ယေဆုယိူဝ်ဒေငိူပ် ဖိူမ်ညှိုမ်ဂဲ၊ အ်ုန်ဒါႈ တဘီဘ်ုပ်တီဇိူင်ဇ်ုမ်ဒီန်၊ “အိူဝ် ကွံန်အီမဲအော၊ ပ္လိုတ်ခွါင်ဒဲႈ အပေတ်ပ်ုန်လူတ်မီယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ကောည်လိုည် တာဆရာနံပ်ဘေဲႇကျံမ်ပ်ုရ်ဒီဂဲ မာ့်အရာပ်ဒီန် ဒါ့်စေ့ကူရာင်ကွည်ဒေ တန်ုဖိူမ်၊ ");
INSERT INTO pll_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“အီကူအီုဝ် ကောပ်ဆေ အ်ုန်ယာႇဂြည်ငဲ ခိူည်အီုဝ်။ အ်ုန်အီုဝ် မိူဝ်ႈဂြည်ငဲ ပ်ုန်ဘဝ်ဖြာ။ ဆဲႈဖြာအူပါ အဆေဘဲဒေ ပ္လိုတ်ခွါင်ဒဲႈ အပေတ်ပ်ုန်လူတ်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ခိူည်မောဂဲ စေ့ကူဆာင်ချာင်တန်ုဖိူမ်ဒေ ယေဆု နံပ်ပွံတ် အူဒီန်တောအူဒီန်၊ အ်ုန်ဒါႈတဂဲ၊ “ကောပ်ဆေ ပဲစေ့ကူဆာင်ချာင် တန်ုဖိူမ်ပဲ ညာခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ငဲခိူည်မောငှိူည်တဒါႈ တဘီဘ်ုပ်တီဇိူင်ဇ်ုမ်အီုဝ်၊ ငှိူည်တဒါႈ၊ ‘ပ္လိုတ်ခွါင်ဒဲႈ အပေတ်ပ်ုန်က်ုရ်လူတ်မီ’ က်ုန်ကာမိူဝ်ႈ ‘ယိူဝ်ႇဇံင်၊ ဒေါပေရ်ရအီတ်မီ လာ်ႈပွံတ်အဲႈ။’ ");
INSERT INTO pll_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","အောဒီပျဆာ့်ဆေ ဒဲႈပဲနံပ်၊ ခိူည်မောကွံန်ဘီအီုဝ် ယိူဝ်အခွါင်အာဏာ ပ္လိုတ်ခွါင်ဒဲႈ အပေတ်ပ်ုန်လူတ်ဘီ တပါင်ကံမ်ဖာအီုဝ်။” ဘံန်ညာခိူည်ဒီန် အ်ုန်ဒါႈတဘီဘ်ုပ်တီဇိူင်ဇ်ုမ်ဒီန်၊ ");
INSERT INTO pll_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“အောဂြည်တမီ၊ ယိူဝ်ႇဇံင်၊ ဒေါပေရ်ရအီတ်မီ ႎေင်ပွံတ်တဂါင်။” ");
INSERT INTO pll_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","အခိင်ဒီန် ဘီဘ်ုပ်တီဇိူင်ဇ်ုမ်ဒီန်မိူဝ်ႈ၊ ယိူဝ်ႇဇံင် တိူဝ်ႈပွံတ်ပေရ်ရအီတ်ဒေ၊ လာ်ႈဖာည်ဖာည်ပွံတ် တဟာရဆငါည်။ ဂဲညာအာမ်ဒိုည်ႇပွံတ်ဒေ၊ ဂဲဒါႈ၊ “ညာခိူည်ပ်ုန်ပဲန်အ်ုန်အီုဝ် အူလိူဝ်ႈမိူဝ်ႈ အယ်ကာကျာင်ယိူဝ်စိ အယ်ငိူပ်။” ဟွည်ႇဒီန် ဂဲဟိုင်တာင်ပွံတ်ဂုင်ဖြာ။ ");
INSERT INTO pll_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ယေဆု ႎီရ်လာ်ႈထဲင် တပြါအိုမ်ဆက္လုင်ဂါလိလဲ။ ဘံန်ဘီက်ုရ်စုဂဲဒီန် လာ်ႈရောတ် တအ်ုန်၊ အ်ုန်ဆာင်ဆောန်ပွံတ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ယာမ်ယေဆုစွလာ်ႈ ရာင်ကွည်ဒေ၊ အ်ုန်ယိူဝ်ဒေငိူပ် ကွံန်အီမဲအာလဖဲ လေဝိ၊ ဒါ့်မာ့်ဒေ တလူမ်ကာ့်အခူန်။ ယေဆုဒါႈတအ်ုန်၊ “ဇောမ်လာ်ႈ ရဘံန်အော။” လေဝိဒီန်မိူဝ်ႈ ယိူဝ်ႇဇောမ်လာ်ႈပွံတ် ရဘံန်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ယာမ်ယေဆု လီပ်မာ့်ဟောမ်မှိူဝ် တန်ုဂါင်လေဝိ။ အီအ်ုန်ကာ့်အခူန်ဂဲဂါရ် အီအ်ုန်ယိူဝ်အပေတ်ဂဲဒီန် လာ်ႈက်ုရ်စုဒေဟောမ် ဇောမ်ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ တဘွည်။ ");
INSERT INTO pll_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","အခိင်ဒီန် အီအ်ုန်မိူဝ်ႈ ဖာရိရှဲ တာဆရာနံပ်ဘေဲႇကျံမ်ပ်ုရ်ဒီဂဲ၊ ဘံန်ယိူဝ်ဒေငိူပ် ယေဆု ဒါ့်တျံင်ဟောမ်ရူမ် ဇောမ်အီအ်ုန်ယိူဝ်အပေတ်ဂါရ် အီအ်ုန်ကာ့်အခူန်ဂဲဒီန်၊ ဂဲဆ်ုရ်မွံတ်ပွံတ် တဘဲႇအ်ုန်ဂဲ၊ “ကောပ်ဆေ အ်ုန်တျံင်ရူမ်ဟောမ်ရူမ် ဇောမ်ဘီဂဲ ညာခိူည်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ဘံန်ယေဆု ယိူဝ်ဒေဆတီုင်၊ အ်ုန်ႎီရ်ဒါႈတဂဲ၊ “ဘီချံမ်ဆာကာယိူဝ်ရောဂါဂဲအီုဝ် ကာလိုစိ ဆရာႎူန်၊ ဘီကာချံမ်ဆာဆူဖိူဝ်ဂဲအီုဝ်ဂိူဝ် လိုဆရာႎူန်။ ကာမိူဝ်ႈစိ အောလာ်ႈပေါ အတွတောႇ ဘီရိုဆီုဝ်ဂဲ၊ မိူဝ်ႈအောလာ်ႈပေါ အတွဝောာႇ အီအ်ုန်ယိူဝ်အပေတ်ဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ယာမ်ဒီန်အူဆငီ တဘဲႇဇောမ်ရဘံန် ဗတ္တိဇံဆရာယောဟန်ဂါရ် ဖာရိရှဲဂဲဒီန် ဒါ့်စံင်ႎဲႈပ်ုန်ဟောမ်။ ဘီဂဲ ပ်ုရ်ဒီလာ်ႈရောတ်ဒေ ဆ်ုရ်မွံတ်တယေဆု၊ “တဘဲႇဗတ္တိဇံယောဟန်ဂဲဂါရ် တဘဲႇဖာရိရှဲဂဲ ဘိူည်စံင်ႎဲႈပ်ုန်ဟောမ်၊ ကောပ်ဆေ တဘဲႇမီဂဲ ကာပဲန်ဒေ စံင်ႎဲႈပ်ုန်ဟောမ်။” ");
INSERT INTO pll_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ယေဆု ႎီရ်ဒါႈ၊ “ယာမ်ခြိူဝ်မျို၊ ဘူဂေါဘူဆေ ရလျံင်ကူခံတ်ဂဲဒီန် ဂွည်ရူမ်ဇောမ်အ်ုန် ဂဲဒီပဲန်ကောဒေ စံင်ႎဲႈပ်ုန်ဟောမ်အဲႈ။ ဒံင်ဂဲဂွည်ရူမ် ဇောမ်ရလျံင်ကူခံတ်ဒီန် ဂဲကာပဲန်စိဒေ စံင်ႎဲႈပ်ုန်ဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ကောည်လိုည် ဒီရောတ်ပေါ ဆငီတောႇဒိူည်လာ်ႈ ရလျံင်ကူခံတ်ဒီန် ဒိုရ်ဂဲ၊ က်ုန်ရောတ် ခိင်ခါဝ်ဆငီဒီန် ဂဲဒီန် ဒီစံင်ႎဲႈဒိုည်ႇပ်ုန်ဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“အဆေမိူဝ်ႈ ကာကျာင်စိဒေ ဒါပိဘံန်က်ုန်မဲ က်ုန်ဘာင်ဆဒေါပြီမ်၊ က်ုန်ညာခိူည်ဒီန် ပ်ုန်က်ုန်ဘာင်အူန် ပိဘံန်က်ုန်မဲပီ ဘံန်အ်ုန်ဟောမ်ဆဒေါပြီမ် ဘီုင်ဆမာႎါႈနာပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","စံမ်ညာခိူည်ဒီန် အဆေမိူဝ်ႈ ကာကျာင်လှ်ုပ်စိ အိုမ်မရာတ်က်ုန်မဲ တပေါႇဆရေပြီမ်။ က်ုန်လှ်ုပ်ညာခိူည်ဒီန် ဘံန်အိုမ်မရာတ်က်ုန်မဲ ဒဲႈပေါႇဆရေပြီမ်ဒီန် က်ုရ်ဆဲႈ ပည်အိုမ်မရာတ်၊ ပည်ပေါႇဆရေ ဒီလူပွံတ်ဒေ။ အိုမ်မရာတ်က်ုန်မဲဒီန် ဘိူန်ဂိူဝ်လှ်ုပ် တပေါႇဆရေက်ုန်မဲ။” ");
INSERT INTO pll_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","တန်ုဆငီဆဒါင်၊ ယာမ်ယေဆု စွက်ုရ်ခါမ်လာ်ႈ ကီုရ်ဘူမ်ရဆ်ုမ်ငှေါ ပ်ုရ်ဒီ။ တဘဲႇအ်ုန်ဂဲ လာ်ႈရူမ်ဇောမ်အ်ုန်၊ ပ်ုတ်ပွံတ်ပ္လေငှေါ။ ");
INSERT INTO pll_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ကောပ်ခိူည်ဒီန် ဖာရိရှဲ ဂဲဒါႈ တယေဆု၊ “ငိူပ်မေန်၊ တန်ုဆငီဆဒါင်၊ ကောပ်ဆေ တဘဲႇမီဂဲ ရ်ုရ်ညာ ထုင်ပ်ုန်ကာမှိူမ်ရ်ုရ်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ယေဆု ႎီရ်ဒါႈတဂဲ၊ “ပဲကာတိူမ်ဒီရ်ႈဂံတ်၊ အခိင်ဒါဝိဒ်ဂါရ် ဘူဂေါအ်ုန်ဂဲ ကာယိူဝ်ပ်ုန်ဟောမ် ဘံန်က်ုန်ဘြာန်လူတ်လာည်၊ ဆေဂဲရ်ုရ်ဒေဒိူည်။ ");
INSERT INTO pll_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ဘံန်ညာခိူည်ဒီန် အ်ုန်လီပ်ပွံတ် တန်ုဂါင်ဖြာ တိူဝ်ႈဒေဟောမ် မုင်ပ်ုန်လှူကာပ်ဒဲႈ တဖြာ။ အ်ုန်ရ်ုရ်ညာခိူည်ဒီန် မိူဝ်ႈယာမ်လာႇထာႇ အဗျာသာ ပဲန်တာဒါင်ယဇ်ပုရောဟိတ်။ က်ုန်မိူဝ်ႈထုင်ပိင်ငျှံပ်အယ် ဆဲႈတာယဇ်ပုရောဟိတ် အဆေမိူဝ်ႈကာယိူဝ်စိ အခွါင်ဟောမ် မုင်ပ်ုန်လှူဒီန်၊ ကောည်လိုည် ဒါဝိဒ် ဟွည်ႇဟောမ် အ်ုန်ဒဲႈ ပည်ဘူဂေါဒေဂဲ ဟောမ်။” ");
INSERT INTO pll_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ဟွည်ႇဒီန် ယေဆုႎီရ်ဒါႈထဲင်၊ “ဆငီဆဒါင်အီုဝ် မိူဝ်ႈဖာန်ဇာမ်အူန် အကျိုကျ အတွဘီ။ ကာမိူဝ်ႈစိ ဖာန်ဇာမ်ဘီ အတွဆငီဆဒါင်။” ");
INSERT INTO pll_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","“ကောပ်ခိူည်ဒီန် ကွံန်ဘီအီုဝ်မိူဝ်ႈ ပည်ကီုရ်ညာ ဆငီဆဒါင်။” ");
INSERT INTO pll_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ဟွည်ႇဒီန် အခိင်ယေဆု ႎီရ်လီပ်ထဲင် တကျောင်ရဆောန်ဒဲႈတရာ၊ ယိူဝ်ဘီဘ်ုပ်တီဇ်ုမ် အူခေါန် ဂွည်က်ုရ်တောဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ဘီပ်ုရ်ဒီဂဲ ဒဲႈဒေဘိူန်ဒေ အတွတာင်အပေတ် တယေဆု၊ ဂဲရဲ့ဒိုည်ႇဒေငိူပ် အ်ုန်ဒီရ်ုရ်ဒဲႈကော အီကူဒီန် ချံမ်ဆာ၊ ကာချံမ်ဆာ တန်ုဆငီဆဒါင်။ ");
INSERT INTO pll_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ယေဆု ဒါႈတဘီဘ်ုပ်တီဇ်ုမ် အူခေါန်ဒီန်၊ “လာ်ႈဇံင်ပွံတ်မီ တရအာတ်ဘီဂဲတည်။” ");
INSERT INTO pll_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ဟွည်ႇဒီန် အ်ုန်ဆ်ုရ်မွံတ်ဘီဂဲ၊ “ခိူည်န်ုထုင်တရာအယ် တဆငီဆဒါင်အီုဝ် မှိူမ်ဇောည် က်ုန်ကာမိူဝ်ႈ မှိူမ်ဒဲႈဒုခအဲႈ။ မှိူမ်ပ်ုန်လောတ်ဒဲႈ အဆာႇဘီအူကူအူဆိူဝ် က်ုန်ကာမိူဝ်ႈ မှိူမ်ပျံမ်ပဲတ်အဲႈ။” ကောည်လိုည် ဂဲဒီန် ညာဂွည်ညိမ်ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","အခိင်ယေဆု က်ုရ်ပံတ်ဒေငိူပ်ပွံတ် က်ုရ်ႎျံရ်ဒေ၊ ဘိူည်ဒေါဆလေႈဂံတ်တဂဲ ယာမ်ဒီန်၊ ကောပ်မိူဝ်ႈဂဲဖိူမ်ခေါ အတွဂဲက်ုရ်လူတ် ဖိူမ်အ်ုန်ကာပျော။ အ်ုန်ဒါႈတအီကူဒီန်၊ “ဆာတ်ပွံတ်တီမီ။” အီကူဒီန်မိူဝ်ႈ ဆာတ်ပွံတ်တီဒေ၊ တီအ်ုန်ႎီရ်ညာပွံတ်ခိူည်ပြီမ်။ ");
INSERT INTO pll_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ဘံန်ညာခိူည်ဒီန် ဖာရိရှဲဂဲ လေႈပွံတ်ဒေ ဒိုရ်ကျောင်ရဆောန်ဒဲႈတရာ အူဒီန်တောအူဒီန်၊ ဂဲလာ်ႈက်ုရ်မိုန်ဇောမ် ဘီလီပ်ဖုင် တာပ်ုရ်မာင်ဟေရုဒ်ဂဲ ပ်ုရ်ဒီ၊ အတွခိူည်မောဂဲ ဒီဘိူန်ဒေခြီုမ် ပ်ုန်လူပျံမ်ပဲတ်ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ဟွည်ႇဒီန် ယေဆု စွလာ်ႈရူမ်ဇောမ် တဘဲႇဒေဂဲ လ်ုပ်အိုမ်ဆက္လုင်ဂါလိလဲ၊ ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ ယိူဝ်ႇဒိုရ်အရာပ် ကပီုန်ကုင်ဂါလိလဲဒီန် ဇောမ်လာ်ႈဒိုည်ႇရဘံန်အ်ုန်။ ဆဲႈဒီန် ယိူဝ်ႇဒိုရ်ကပီုန်ကုင်ယုဒ၊ ");
INSERT INTO pll_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ဒိုရ်ကုင်ယေရုရှလင်၊ ဒိုရ်ကပီုန်ကုင်ဣဒုမဲ၊ စပည် ဒိုရ်ဆဲႈပြါအိုမ်ယော်ဒန် လ်ုပ်လေႈဆငီ၊ ကုင်တုရုဂါရ် က်ုရ်ႎျံရ်ကုင်ဇိဒုန်၊ ကောပ်ဘီဂဲဒီန် ယိူဝ်ဒိုည်ႇဒေဆတီုင် ခံင်ပ်ုန်ရ်ုရ်ယေဆု ဂဲလာ်ႈပေါဒိုည်ႇဒေတအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ဘံန်ဖုင်ဘီက်ုရ်စုဂဲ ကီုန်လူတ်လာည်၊ ယေဆုဒါႈ တတဘဲႇဒေဂဲ ရဲန်အူန်ရိူဝ်အူကြောင် ဒဲႈယိူဝ်ပဲတ်ဆေဆေ အတွအ်ုန်၊ မာည်ဒဲႈဘီဂဲက်ုရ်အီဒေ တိူဝ်တိုအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ကောပ်မိူဝ်ႈအ်ုန်ဆန်ုမ်ဒဲႈ ရောဂါဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ ချံမ်ဆာဟြာည်၊ ဘ်ုရ်ယိူဝ် ဘီဘ်ုပ်ရောဂါႎိုည်ဒနာဂဲအီုဝ် က်ုရ်ညဲတ်ဒေလီပ်ဒိုည်ႇ အတွဒဲႈဂဲဘိူန်ဒေ တိူဝ်ထိအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","အခိင်ဘီ ကီုရ်နံမ်ကာကျကာလ လီပ်စံပ်ဒီန် ယိူဝ်ဒေငိူပ်အ်ုန်၊ ဂဲမာ့်ဆကူပ်ပွံတ် တရအာတ်အ်ုန်၊ ပြိုႈဒေဒါႈ၊ “မီမိူဝ်ႈညှိုႈ ကွံန်ဖြာယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ယေဆု ပိင်ငျှံပ်ရံတ်ရံတ်အူန် တကီုရ်နံမ်ချှိုဒီန် မာည်ဒဲႈဂဲဂြည် အကျံင်ဒေ တအဆေ။ ");
INSERT INTO pll_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","အခိင်ဒီန် ယေဆု လာ်ႈဟာ့်တဆိုရ် ဘံန်အ်ုန်တောႇ ဘီအ်ုန်ဇူႈနွံရ်ႈဒေ၊ ဂဲလာ်ႈပေါရောတ်ဒိုည်ႇ တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","အခိင်ဒီန် အ်ုန်ရံရ်ႈဂဲ ကိူရ်အာရ်ကူ၊ တာင်ဒဲႈဂဲဇီုဝ် တမန်ဇ်ု။ အ်ုန်ဒါႈတဂဲ၊ “အောရံရ်ႈ ဒဲႈပဲဂွည်ရူမ်ဇောမ်အောအီုဝ် မိူဝ်ႈအတွဟောဂြည်တရာ အောဒီပ္လေါည်လာ်ႈပဲ၊ ");
INSERT INTO pll_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ဆဲႈဒီန် အောဒဲႈပဲဘိူန် အခွါင်အာဏာ ဘဲဒေရူပ်လေႈ ကီုရ်နံမ်ချှိုဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ပ်ုန်ရံရ်ႈအူန်အ်ုန် ကိူရ်အာရ်ကူဒီန်၊ မိူဝ်ႈရှိမုန် (အီကူအီုဝ်မိူဝ်ႈ ယေဆု တာင်ဒဲႈအ်ုန်ဇီုဝ် ပေတရု)၊ ");
INSERT INTO pll_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ကွံန်အီမဲဇေဗေဒဲ ယာကုပ်ဂါရ် ယောဟန်၊ (ယေဆုတာင်ဒဲႈဂဲဇီုဝ် ဗောနေရဂက်၊ အိုမ်ငဲအ်ုန်မိူဝ်ႈ ကွံန်ကနံမ်ကဆံရ်ႈ)၊ ");
INSERT INTO pll_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","အန္ဒြေ၊ ဖိလိပ္ပု၊ ဗာသောလမဲ၊ မဿဲ၊ သောမ၊ ကွံန်အီမဲအာလဖဲ ယာကုပ်၊ သဒ္ဒဲ၊ မိူဝ်ႈအီရံက်ခြိူဝ်ဘီကာနနိတ် ရှိမုန်ဂါရ် ");
INSERT INTO pll_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ယုဒရှကာရုတ်၊ ကူအ်ုန်ယာႈဆေတ်စာ တယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ဟွည်ႇဒီန် ယေဆု စွလီပ်တန်ုဂါင်။ ဘံန်ဖုင်ဘီက်ုရ်စုဂဲ ႎီရ်လာ်ႈဇူထဲင် တယေဆုဂါရ် တဘဲႇအ်ုန် ဂဲကာယိူဝ်ပဲတ် အခိင်ဟောမ်ပ်ုန်ဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ဘံန်ခြိူဝ်မျိုႎါႎည်အ်ုန်ဂဲ ယိူဝ်ဒေဆတီုင် အကျံင်ငဲပ်ုန်ဂြည် ဘီဂဲဒါႈ၊ “ဖိူမ်အ်ုန်ဟွည်ႇဖောက်ပျန်၊” ကောပ်ခိူည်ဒီန် ဂဲဒါႈဒေတိုည်တုအ်ုန် ဂဲလာ်ႈဇူဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ ပ်ုရ်ဒီ ယိူဝ်ႇရောတ် ဒိုရ်ကုင်ယေရုရှလင် ဂဲဒါႈ၊ “အ်ုန်အီုဝ် မိူဝ်ႈဗေလဇေဗုလ လီပ်စံပ်တအ်ုန်၊ မိူဝ်ႈအ်ုန်ဒါ တီုင်ဂို တာဒါင်ကီုရ်နံမ်ချှို အ်ုန်တဘဲဒေရူပ်လေႈ ကီုရ်နံမ်ချှိုဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","အခိင်ဒီန် ယေဆုတောႇဒေဂြည် ငဲပုင်တဲႇ တဂဲ၊ “စာတန်အီုဝ် ခိူည်မောအ်ုန်ဒီညာဒေ ဘဲဒေရူပ်လေႈ စာတန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“ကပီုန်ကုင် အူကုင်အီုဝ် က်ုန်က်ုရ်ခံတ် ဇောမ်တန်ုဖုင်ဒေ ဒီကာဘဲစိဒေတဲ။ ");
INSERT INTO pll_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ဂါင်အီုဝ် က်ုန်လာည်နွံရ်ႈလာည်ဖိူမ် တန်ုဒေ၊ ဂါင်ဒီန် ဂဲကာဘဲစိဒေဇံင်မြဲ။” ");
INSERT INTO pll_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","“ကောပ်ခိူည်ဒီန် ကပီုန်ကုင် စာတန်ဂဲအီုဝ် က်ုန်က်ုရ်ခံတ် ဇောမ်ဖုင်ဒေ၊ ဂဲကာဘဲစိဒေဇံင်မြဲ မောဂိူပ်ပေါ တအခိင်ဟာဆူတ်။” ");
INSERT INTO pll_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","က်ုန်ကာတုဘိူဝ် ဘီႎါဝ်ဒီန် ရအာတ်၊ အဆေကာဘိူန်စိဒေ လီပ်တန်ုဂါင် တိူဝ်ႈဂြူအုဇာအ်ုန်၊ က်ုန်ဟွည်ႇတုဘိူဝ် ဘီႎါဝ်ဒီန် ဒီဘိူန်ဒေ လီပ်တန်ုဂါင် တိူဝ်ႈဂြူအုဇာအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“အောဂြည်ညှိုႈတပဲ၊ ဘီဂဲအီုဝ် ဒီဘိူန်ဒေခါမ်ဇာ ပ္လိုတ်ခွါင် အပေတ်ဒေတွံန်နဲဂါရ် ဘ်ုရ်ယိူဝ်ငဲပ်ုန်ဘဝ်ဒေဂဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ကောည်လိုည် အဆေမိူဝ်ႈဟွည်ႇ က်ုန်ဂြည်ငဲပ်ုန်ဘဝ် တႎိငျံန်ဆပဲ ယာမ်မောမိူဝ်ႈဟွည်ႇ ဒီကာဘိူန်စိ ပ္လိုတ်ခွါင် ဒိုရ်အပေတ်ဒေ၊ ကောပ်မိူဝ်ႈအ်ုန်လူတ်ဘိုန် ဘ်ုပ်ဒေက်ုရ်တူႈ တာမ်တန်ုအပေတ်ထာဝရ။” ");
INSERT INTO pll_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(ကောပ်ယေဆု ဒါႈဒေငဲခိူည်ဒီန် ဘီပ်ုရ်ဒီဂဲဒါႈ၊ “အ်ုန်အီုဝ် မိူဝ်ႈကီုရ်နံမ်ကာကျကာလ လီပ်ဂွည်တန်ုတိုအ်ုန်။”) ");
INSERT INTO pll_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","အခိင်ဒီန် မာယေဆုဂါရ် ႎါအ်ုန်ဂဲ ရောတ်ပေါ။ ဘံန်ဂါရ် ဒါ့်ဇံင်ဒေရရိူဝ့် ဂဲပ္လေါည်ဘီအူကူ လာ်ႈတောႇအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ဖုင်ဘီက်ုရ်စု ဒါ့်မာ့်က်ုရ်ႎျံရ် ယေဆုဒီန် ဒါႈတအ်ုန်၊ “ငိူပ်မေန်၊ မာမီ၊ ႎါအီမဲဂါရ် ႎါရပျာမီဂဲ လာ်ႈလဲမ်မီ ဒါ့်ဂွည်ဒိုည်ႇဒေရရိူဝ့်။” ");
INSERT INTO pll_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ယေဆု ႎီရ်ဒါႈ၊ “အဆေမိူဝ်ႈ မာအောဂါရ် ႎါအောဂဲအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ဟွည်ႇဒီန် အ်ုန်ငိူပ်ပွံတ်ဘီမာ့် တပြောက်ုရ်ႎျံရ်ဒေဂဲ အ်ုန်ဒါႈ၊ “ငိူပ်မေန်၊ ဘီဂဲအီုဝ် မိူဝ်ႈဒိုည်ႇမာအောဂါရ် ႎါအောဂဲယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“ဘီအ်ုန်ရ်ုရ် ဇောမ်နွံရ်ႈဖိူမ်ဖြာအီုဝ် မိူဝ်ႈဒိုည်ႇႎါအော၊ ႎါရပျာအော၊ မာအောဂဲယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","လိူဝ်ႈရဘံန် ယေဆု ဆုင်မဆာင်ဆောန်ဒဲႈ တပြော ပြါအိုမ်ဆက္လုင်ဂါလိလဲ။ ဘံန်ဘီက်ုရ်စု ဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ လာ်ႈရောတ်ဒိုည်ႇ တပြောအ်ုန်၊ အ်ုန်ဟာ့်မာ့်ပွံတ်ဒေ တပါင်ရိူဝ် န်ုအိုမ်ဆက္လုင်။ ဖုင်ဘီက်ုရ်စုဂဲဒီန်မိူဝ်ႈ လာ်ႈဂွည်ဒိုည်ႇဒေ တပြောပြါအိုမ်ဆက္လုင် ပါင်ဆိုရ်။ ");
INSERT INTO pll_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","အခိင်ဒီန် အ်ုန်ဒါငဲပုင်တဲႇ ဆာင်ဆောန်ဒဲႈတဂဲ တွံန်မျိုတွံန်နဲ၊ ပ်ုန်ဒါႈအ်ုန် တဂဲဒီန်မိူဝ်ႈ၊ ");
INSERT INTO pll_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ဆတီုင်ဘိူဝ်။ ယိူဝ်ဘီအူကူ လေႈလာ်ႈပွံတ်ဒေ အတွပြံတ်ကအာင်ဆမာရ်။ ");
INSERT INTO pll_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ယာမ်အ်ုန် ပြံတ်ကအာင်ဆမာရ် တနာ၊ ကအာင်ဆမာရ် ပ်ုရ်ဒီ ဘံန်ဇာ်ႈ တပါင်ရဒေင်၊ ဆီမ်ဂဲတပ္လေင် လာ်ႈပေါဒေ ထွံရ်ဒိုည်ႇဒေဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ပ်ုရ်ဒီ ဇာ်ႈတအရာပ် ကတဲဘြေ့ မိုဘ္လံမ်၊ ကအာင်ဆမာရ်ဒီန် ဘိူည်လဲ့ဖာည်ဂံတ်၊ ကောပ်ကတဲဘြေ့၊ ");
INSERT INTO pll_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","အခိင်ဆငီလေႈ တာတ်ရဲင်လူတ်လာည်၊ ဘံန်ရျံရ်ႈကာစံပ်ရံတ် တကတဲ ဟောင်ဟျံတ်ဒိုည်ႇဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ကအာင်ဆမာရ်ပ်ုရ်ဒီ ဘံန်ဇာ်ႈတယူပ်ပ်ုရ်အောႇ၊ တီုင်ယူပ်ပ်ုရ်အောႇ ဟံန်ဒါင်လာ်ႈ ကောပ်ပိဖလူမ်ဒိုည်ႇတီုင်အ်ုန် ကာဘဲဒေပ္လေ။ ");
INSERT INTO pll_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ကောည်လိုည် ကအာင်ဆမာရ်ပ်ုရ်ဒီ ဘံန်ဇာ်ႈတကတဲကျ တီုင်အ်ုန်လဲ့ဟံန်ဒါင်၊ ဆမာဒဲႈပ္လေလေႈ ပ်ုရ်ဒီ ပူန်အွည်ကိူရ်၊ ပ်ုရ်ဒီ ပူန်တောရ်ကိူရ်၊ ပ်ုရ်ဒီ ပူန်အူပ်ုရ်ယာႈ။” ");
INSERT INTO pll_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ဟွည်ႇဒီန် ယေဆုဒါႈငဲပ်ုန်ဟွည်ႇ၊ “အီအ်ုန်ယိူဝ်ဟျာ့် ဒဲႈပဲယိူဝ်ဒေဆတီုင်။” ");
INSERT INTO pll_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ယာမ်ယေဆု ဂွည်ရာင်ကွည်ဒေ တအရာပ်ယေန်ညိမ်၊ ဘီဆတီုင်တရာ ပ်ုရ်ဒီ လာ်ႈရူမ်ဇောမ် တဘဲႇကိူရ်အာရ်ပါ ဂဲဆ်ုရ်မွံတ် အိုမ်ငဲပုင်တဲႇဒီန် တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ယေဆုႎီရ်ဒါႈ၊ “အောဟွည်ႇဒဲႈဒိုည်ႇပဲနံပ် ခံင်လီုဝ့်လီုဝ့်လံမ်လံမ် က်ုရ်အူပ်က်ုရ်မော ကပီုန်ကုင်ဖြာအီုဝ်။” ကောည်လိုည် က်ုန်မိူဝ်ႈ ဘီရရိူဝ့်ဂဲတည် ဘိူန်ဂိူဝ်ဂြည်ပျ ဇောမ်ငဲပုင်တဲႇ တဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ကောပ်ဆေတဒါႈခိူည်ဒီန်၊ “ဂဲဘိူည်ငိူပ်ဂံတ်လလ၊ ကာယိူဝ်ပဲတ်ဒေငိူပ်။ ဂဲဘိူည်ဆတီုင်ဂံတ်လလ၊ ကာနံပ်ပဲတ် တီုင်အိုမ်ငဲ၊ ဂဲက်ုန်က်ုရ်လှာည် အချံင်ဒေ ႎီရ်ဇူလ်ုပ်ဖြာ၊ အ်ုန်ဒီ ပ္လိုတ်ခွါင်ဒဲႈတဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ဟွည်ႇဒီန် ယေဆုဆ်ုရ်မွံတ်ဂဲ၊ “ပဲက်ုန်ကာနံပ် ငဲပုင်တဲႇအီုဝ်၊ ခိူည်မော ပဲဒီညာဒေနံပ် ဘ်ုရ်ယိူဝ်ငဲပုင်တဲႇ ဒိုည်ႇဒိုည်ႇအီုဝ်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","အီကူပြံတ်ကအာင်ဆမာရ်ဒီန် မိူဝ်ႈဘီပြံတ် ငဲတရာဖြာ။ ");
INSERT INTO pll_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ဘီပ်ုရ်ဒီ နှေရ်ကအာင်ဆမာရ် ဇာ်ႈတပါင်ရဒေင်။ အခိင် ဂဲယိူဝ်ဒေဆတီုင်ငဲတရာ ဘိူည်ဆွံင်လီပ်ဂံတ် တန်ုဖိူမ်ဒေ အူဒီန်တောအူဒီန် စာတန်ရောတ်ဒေ တိူဝ်ႈပဲတ်ပဲတ် ငဲတရာ ပ်ုန်ပြံတ်အူန် တဂဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ဘီပ်ုရ်ဒီ နှေရ်ကအာင်ဆမာရ် ပြံတ်ဇာ်ႈ တအရာပ်မိုဘ္လံမ်။ အခိင်ဂဲယိူဝ်ဒေ ဆတီုင်ငဲတရာ ပည်နွံရ်ႈရျံင်ဖိူန်ပျော ရံပ်တိူဝ်ႈအူန်ဒေဆတီုင် အူဒီန်တောအူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ကောည်လိုည် ဘံန်ရျံရ်ႈကာစံပ်ရံတ် တန်ုဖိူမ်ဂဲ ခါမ်ဂိူဝ် အူကာပြေ့။ ကောပ်ငဲတရာဒီန် အခိင်ဒုခနာ့်နွံရ်ႈ က်ုန်ကာမိူဝ်ႈ ဆဂေလာလီညာ ရောတ်ပေါ နွံရ်ႈဖိူမ်ဂဲ ဆမာလူဒိုည်ႇ အူဒီန်တောအူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ဘီပ်ုရ်ဒီဂဲ နှေရ်ကအာင်ဆမာရ် က်ုရ်တူႈပြံတ် တန်ုပ်ုရ်အောႇ။ ပ်ုန်ဆ်ုန်ဒါႈအ်ုန်မိူဝ်ႈ၊ ဘိူည်ယိူဝ်ဂံတ်ဒေ ဆတီုင်ငဲတရာ၊ ");
INSERT INTO pll_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ကောည်လိုည် ဘံန်ယိူဝ်ဖိူမ်နွံရ်ႈဟ တလောကီ၊ ဆ်ုန်ဘိူန် အုဇာခြ်ုမ်ဆာဂါရ် ဆ်ုန်ဘိူန် ပ်ုန်ဟံရ်တွံန်မျိုတွံန်နဲ လီပ်ပေါဒေ ဒံန်ခြဲငဲတရာဒီန် ကာနံပ်ယာ့်ဒေပ္လေ။ ");
INSERT INTO pll_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ဘီပ်ုရ်ဒီဂဲ နှေရ်ကအာင်ဆမာရ် က်ုရ်တူႈပြံတ် တပါင်ကတဲကျဒီန်။ ပ်ုန်ဆ်ုန်ဒါႈအ်ုန်မိူဝ်ႈ ယိူဝ်ဒေဆတီုင်ငဲတရာ ဘံန်ရံပ်တိူဝ်ႈအူန်တဒေ၊ ဆမာဒဲႈ ပ္လေလေႈ ပ်ုရ်ဒီ ပူန်အွည်ကိူရ်၊ ပ်ုရ်ဒီ ပူန်တောရ်ကိူရ်၊ ပ်ုရ်ဒီ ပူန်အူပ်ုရ်ယာႈ။ ");
INSERT INTO pll_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ယေဆုႎီရ်ဒါႈထဲင်၊ “ဘီအူကူအူဆိူဝ် ကျာင်တိူဝ်ႈကောဒေဒိူည် ငံရ်ရာင်ကာ့် အတွအူန် တရခြူမ်ဘာ့်ခွံရ် က်ုန်ကာမိူဝ်ႈ အတွအူန်တရခြူမ်ချှံင်။ ကာမိူဝ်ႈ တိူဝ်ႈဒေဒိူည် ငံရ်ရာင်ကာ့်ဒီန် အတွဂံမ်အူန် တပါင်ခုင်ငံရ်ရာင်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ဘ်ုရ်ယိူဝ်ခံင်က်ုရ်အူပ်က်ုရ်မောဒီန် ဒီဘ်ုပ်ပိူဝ်ႈလိူရ်ႈဒိုည်ႇ။ ခံင်ဖလူမ်အူန် နဲမောမိူဝ်ႈဟွည်ႇ ဒီဘ်ုပ်ပိူဝ်ႈလိူရ်ႈဒိုည်ႇဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“အီအ်ုန် ယိူဝ်ဒေဟျာ့်၊ ဒဲႈပဲယိူဝ်ဒေဆတီုင်။” ");
INSERT INTO pll_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ဟွည်ႇဒီန် အ်ုန်ႎီရ်ဒါႈထဲင်တဂဲ၊ “ပဲယိူဝ်ဒေဆတီုင်ဘ်ုရ်မော အူန်တနွံရ်ႈဖိူမ်ပဲ။ ခိူည်ပဲဂ်ုမ်တရာ တဘီဟံရ်ဂဲ ဘ်ုရ်မော၊ ဖြာ ဒီဂ်ုမ်တရာ တပဲခိူည်ဒီန် — ကောည်လိုည် ႎရနာထဲင်ဒိုရ်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ဆဲႈဒီန် တဘီအ်ုန်ယိူဝ် ဒီႎီရ်ဒဲႈထဲင်။ တဘီအ်ုန်ကာယိူဝ် ဒီႎီရ်တိူဝ်ႈဆီမ်ဒိုည်ႇ ဘ်ုရ်ယိူဝ်တဂဲဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ဆဲႈဒီန် ယေဆုႎီရ်ဒါႈ၊ “ကပီုန်ကုင်ဖြာဒီန် ညာခိူည် အီကူပြံတ်ကအာင်ဆမာရ် တပါင်ကတဲ။ ");
INSERT INTO pll_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","အီကူဒီန် ဟွည်ႇပြံတ်ကအာင်ဆမာရ် အခိင်ရမှိူဝ်၊ ရဆငီ၊ ယာမ်အ်ုန် ဒါ့်အီတ်အီတ်ဂွည်ဂွည်ဒေ ညာခိူည်ဒီန် ကအာင်ဆမာရ်ပီ တီုင်လဲ့ဟံန်ဒါင်လာ်ႈပွံတ်ဒေ။ ခိူည်မောတီုင်ဒီန် ညာဒေဟံန်ဒါင်လာ်ႈ အီကူဒီန်ကာနံပ်ပဲတ်။ ");
INSERT INTO pll_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ကတဲဒီန် ဒဲႈငှေါ ပ္လေရာင်ဒေ၊ ယာမ်စ မိူဝ်ႈတီုင်၊ ဟွည်ႇဒီန် ကီုရ်ယိုင်၊ တန်ုကီုရ်ယိုင်ဒီန် ပဲန်ပွံတ်ဒေ ကအာင်ဂြါ။ ");
INSERT INTO pll_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ဘံန်ပ္လေဒီန် ဟွည်ႇဆီန် ရောတ်ခါဝ်ႎေါႇတိူဝ်ႈအူန်ပ္လေ၊ အီကူဒီန် တိူဝ်ႈဒေဒါစာန် ႎေါႇပွံတ်အ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ယေဆုႎီရ်ဒါႈထဲင်တဂဲ၊ “ကပီုန်ကုင်ဖြာအီုဝ် ဇောမ်ခိူည်မောဒီက်ုရ်တဲႇ ဒဲႈတပဲ က်ုန်ကာမိူဝ်ႈ၊ တိူဝ်ႈဒါငဲပုင်တဲႇ ဇောမ်ခိူည်မော အောဒီဘ်ုပ်ဂြည်ပျတပဲ။ ");
INSERT INTO pll_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","အီအီုဝ်မိူဝ်ႈ နှေရ်ပွံတ် ကအာင်ဆမာရ်တူဂိုန်။ ဘီအူကူ ယာမ်အ်ုန်တိူဝ်ႈ ကအာင်ဆမာရ်တူဂိုန် ပြံတ်တကတဲ၊ အ်ုန်ဘိူည်ဒျံတ်ဂံတ် ဒိုရ်ဘ်ုရ်ယိူဝ် ကအာင်ဆမာရ်ဒိုည်ႇဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ကာဇီုဝ့် တီုင်အ်ုန်ဟံန်ဒါင်လာ်ႈညှိုႈ ဒိုရ်ဘ်ုရ်ယိူဝ် ကာႇပ္လေတူပ္လေလှာ ဒိုည်ႇဒိုည်ႇ။ ဆီမ်တပ္လေင်ဂဲလာ်ႈပေါ ရ်ုရ်ဟူန်ဂါင် တကာႇဟေဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ဖုင်ဘီဂဲ ဘဲဒေနံပ်ဘ်ုရ်မော ယေဆု ဒါငဲပုင်တဲႇဟံရ်တွံန်နဲ ဟောဂြည်ငဲတရာဒေ တဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","က်ုန်ကာပါငဲပုင်တဲႇ အ်ုန်ကာဟောဂြည်စိ တရာတဂဲ။ ကောည်လိုည် က်ုန်မိူဝ်ႈတဘဲႇဒေဂဲ အ်ုန်ဂြည်ဆာင်လာင်ဒဲႈ ရာင်ကောည် ခိူည်မိူဝ်ႈခိူည်ပိုည် ဒိုည်ႇဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ဆငီဒီန် ရောတ်အခိင်ရမှိူဝ် ယေဆု ဒါႈတ တဘဲႇဒေဂဲ၊ “ဆာ်ႈ အယ်ႎါည်လာ်ႈဒိုည်ႇ ဆဲႈပြါအိုမ်ဆက္လုင် လ်ုပ်တည်။” ");
INSERT INTO pll_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ကောပ်ခိူည်ဒီန် ဂဲပဲတ်အူန်ပဲတ် ဖုင်ဘီက်ုရ်စုဂဲ၊ တဘဲႇအ်ုန်ဂဲ လာ်ႈဇူပွံတ် ယေဆုမာ့် တပါင်ရိူဝ်ဒီန် ဂဲႎါည်လာ်ႈပွံတ်။ ရိူဝ်ဟံရ်ဂဲမိူဝ်ႈ ဇောမ်လာ်ႈဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ယာမ်ဒီန် ဘံန်ခူရ်ဒါင်ဇုင်ဒါင်ရဲင် ပေါရောတ်၊ က်ုရ်ပံရ်အိုမ်ဒီန် ပါ်ႈပွံတ်ရိူဝ်ဂဲ အိုမ်ဂိူပ်ဆ်ုန်နာ့်ပွံတ် တန်ုရိူဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ကောည်လိုည် ယေဆုဒါ့်အီတ် ဂံမ်ကိင်ဒေ မှောန်လ်ုပ်ရဘံန်ရိူဝ်။ တဘဲႇအ်ုန်ဂဲ ပျိူဝ်ႇအ်ုန် ဒါႈ၊ “အိူဝ် တာဆရာ၊ ယဲဒီဘ်ုပ်ယံမ်ဒိုည်ႇခိူည်အီုဝ် ဆေညာမီကာတိူဝ်ႈအရေယဲ။” ");
INSERT INTO pll_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","အခိင်ဒီန် ယေဆုယိူဝ်ႇဒိုရ်အီတ်ဒေ အ်ုန်ငဲဆုင်မပွံတ် ခူရ်ဂါရ် က်ုရ်ပံရ်အိုမ်၊ “ယေန်ညီမ်အေ့” ဘံန်အ်ုန် ပိင်ငျှံပ်ခိူည်ဒီန် ခူရ်ဒီန် ညာယေန်ညီမ် ဆာယာညှိုႈညှိုႈပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","အခိင်ဒီန် ယေဆုဆ်ုရ်မွံတ် တဘဲႇဒေဂဲ၊ “ကောပ်ဆေ ပဲနံပ်ဒေယော ညာခိူည်အီုဝ်၊ ပဲညှံမ်ယိူဝ်ဂံတ် ဖိူမ်ညှိုမ် မောအူဒီန်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ဘီဂဲဒီန် ယောလူတ်လာည် ညာယူႈယူႈယ်ုရ်ယ်ုရ် ဂဲက်ုရ်မိုန်ဒိုည်ႇတဒေ အူကူတောအူကူ။ “အီကူအီုဝ် အဆေအ်ုန်မိူဝ်ႈအဲႈ၊ ခူရ်ဂါရ် က်ုရ်ပံရ်အိုမ်လိုည် ဆတီုင်ဒိုည်ႇငဲပ်ုန်ဒါႈအ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ဟွည်ႇဒီန် ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ ရောတ်ဒိုည်ႇ အရာပ်ဂါရစ၊ ဆဲႈပြါ အိုမ်ဆက္လုင်ဂါလိလဲ လ်ုပ်တည်။ ");
INSERT INTO pll_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ယေဆုစွလေႈ ဒိုရ်တပါင်ရိူဝ် ဒံင်အူကပြေ့၊ အီကူကီုရ်နံမ်ကာကျကာလ လီပ်စံပ်တအ်ုန်ဒီန် လေႈဒိုရ်ဆာင်ခဲင် လာ်ႈက်ုရ်ယိူဝ်ပွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","အ်ုန်ဂွည်ဂိူဝ်ဒေ တဆာင်ခဲင်၊ အဆေမိူဝ်ႈ ကာဘိူန်ဒေ ဒါႎံရ်ဟီရ် တိုည်တုအူန်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ကောပ်ဆေတဒါႈညာခိူည်ဒီန် ဂဲဘိူည်တုဂံတ်ဇိူင်အ်ုန် တႎံရ်ဟီရ် တွံန်လိူဝ်ႈတွံန်လိူဝ်ႈ၊ အ်ုန်တီုတ်က်ုရ်တ်ုတ်ပဲတ် ႎံရ်ဟီရ်ကျံင်ဇိူင် ပ်ုန်တုဂဲဒီန်၊ ကောပ်ရဲင်အ်ုန်ဒါင်လူတ်လာည် အဆေမိူဝ်ႈ ကာဘဲဒေထိင်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ကာဒါႈ ရဆငီ၊ ရမှိူဝ် အ်ုန်ပြိုႈဒေရျံင် တဆာင်ခဲင်ဂါရ် တပါင်ဆိုရ်၊ ဒါမိုဟေတ်တိုဒေ ဒဲႈပဲန်ဒိုည်ႇတိူဝ်ဆူ တပါင်တိုအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ဘံန်အ်ုန်ယိူဝ်ဒေငိူပ် ယေဆု တအရာပ်ဆငါည် ခူန်ဒေလာ်ႈ မာ့်ပ်ုရ်ဒ်ုပ်ကိင်ကေရ်ဒေ တရအာတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","အ်ုန်ပြိုႈဒါႈ ပည်ဂံရ်ႈရဲင်၊ “အိူဝ် ယေဆု ကွံန်ဖြာ မျြံတ်ဇာရ်၊ ဆေမီ ဆ်ုန်ဘိူန်တအောအဲႈ။ ဒါဇီုဝ် ဖြာ၊ အောတောင်ဘာန်မီ မာည်ဆဂေအောစိ။” ");
INSERT INTO pll_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(အ်ုန်ဒါႈခိူည်ဒီန်မိူဝ်ႈ၊ ကောပ်ယေဆုဒါႈ၊ “အိူဝ် ကီုရ်နံမ်ကာကျကာလ၊ လေႈပွံတ်မီ ဒိုရ်တိုအီကူအီုဝ်။”) ");
INSERT INTO pll_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ဘံန်ညာခိူည်ဒီန် ယေဆုဆ်ုရ်မွံတ်အ်ုန်၊ “ဆေမီဇီုဝ်၊” အီကူဒီန် ႎီရ်ဒါႈ၊ “ဇီုဝ်အောမိူဝ်ႈ လေဂေါင်၊ ယဲကီုန်ညှိုႈ။” ");
INSERT INTO pll_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ဟွည်ႇဒီန် အ်ုန်တောင်ဘာန်ယေဆု မာည်ရူပ်လေႈဂဲ ဒိုရ်အရာပ်အီုဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ယိူဝ်ဖုင်လေ့ဒါင်အူက်ုရ်စု ဂဲဟောမ်ဂွည် တပါင်ဆိုရ် တပြောအရာပ်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ဘံန်ညာခိူည်ဒီန် ႎိငျံန်ကီုရ်နံမ်ချှိုဂဲ တောင်ဘာန် တယေဆု၊ “ပ္လေါည်ဒဲႈယဲ လီပ်ဂွည် တန်ုလေ့စိ။” ");
INSERT INTO pll_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ဘံန်အ်ုန်ဒဲႈပွံတ်အခွါင် တကီုရ်နံမ်ကာကျကာလဂဲ၊ ဂဲလေႈပွံတ် ဒိုရ်တိုအီကူဒီန် ဂဲလာ်ႈလီပ်ဒိုည်ႇပွံတ် တဖုင်လေ့၊ ဖုင်လေ့ က်ုရ်ပံတ်အာရ်ဟြဲင် ဟောမ်ဂွည်တအရာပ်ဒီန် လှောဒေခူန်ဇောမ်ကြောင်ဆိုရ် လေႈယံမ်ဒိုည်ႇဒေ တန်ုအိုမ်ဆက္လုင်။ ");
INSERT INTO pll_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","အီအ်ုန်ဟျံင်လေ့ဂဲ ခူန်လီပ်ပွံတ်တန်ုကုင်ရူ၊ ဘံန်ဂဲလာ်ႈဂြည်ဆဒါင်ဒီန် ဘီဂဲလာ်ႈငိူပ်ဒိုည်ႇ ပ်ုန်ပဲန်အ်ုန်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","အခိင်ဂဲရောတ်ဒိုည်ႇ တယေဆု၊ အီကူကီုရ်နံမ်ချှိုလေဂေါင် တိူမ်လီပ်စံပ်တအ်ုန်ဒီန် ဟွည်ႇချှုပ်ဒေဒါဂြူ ဒါ့်မာ့်ဒေ ပဲန်ပွံတ်ခိူည်ပြီမ်၊ ဘံန်ဂဲယိူဝ်ဒေငိူပ်ခိူည်ဒီန် ဂဲညာယောဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ဘီအ်ုန်ယိူဝ်ဒေငိူပ် တရအာတ်ငါည်ဒေဒီန် ဂြည်ပျဒိုည်ႇ တဘီဂဲ အကျံင်ကီုရ်နံမ်ချှိုစံပ်တအီကူ ခိူည်မောအ်ုန်ပဲန်ဂါရ် အကျံင်လေ့ဂဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ဘံန်ညာခိူည်ဒီန် ဘီဂဲတောင်ဘာန် ယေဆု ဒဲႈအ်ုန်လေႈပွံတ်ဒေ ဒိုရ်အရာပ်ဂဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ယာမ်ယေဆု ရဲန်ဒေဟာ့်တပါင်ရိူဝ် အီကူကီုရ်နံမ်ချှို လီပ်စံပ်ဒီန် တောင်ဘာန်အ်ုန်၊ “ဒဲႈအောလာ်ႈ ဇောမ်မီစိ။” ");
INSERT INTO pll_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ကောည်လိုည် ယေဆု ကာဒဲႈစိ အခွါင်။ အ်ုန်ႎီရ်ဒါႈတအ်ုန်၊ “ႎေင်ပွံတ် တဂါင်တရမာမီ၊ ဂြည်ပျတဂဲ ဘ်ုရ်မောကီုရ်ညာဖြာ ရ်ုရ်ဒဲႈကေစူတပါင်မီဂါရ် ခိူည်အ်ုန်ညာဒေ က်ုရ်ႎေမီဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ဘံန်ညာခိူည်ဒီန် အီကူဒီန်လေႈလာ်ႈပွံတ်ဒေ၊ အ်ုန်လာ်ႈဂြည်ပျဆဒါင် ဘ်ုရ်မောယေဆု ရ်ုရ်ဒဲႈကေစူတပါင်ဒေ တကပီုန်ကုင်ဒေကာပေါလိ၊ ဘ်ုရ်ယိူဝ်ဘီဂဲဒီန် ဘံန်ယိူဝ်ဒေဆတီုင် ဂဲအာမ်ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ဟွည်ႇဒီန် ယေဆုဘရိူဝ် ႎီရ်လာ်ႈထဲင် ဆဲႈပြါအိုမ်ဆက္လုင်ဂါလိလဲ လ်ုပ်တည်၊ ယာမ်အ်ုန်ဂွည် တပြါအိုမ်ဆက္လုင် ဘီက်ုရ်စုဒါင်ဂဲ လာ်ႈက်ုရ်စုဒိုည်ႇဒေ က်ုရ်ႎျံရ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","အခိင်ဒီန် တာအွံရ်ကိင် ကျောင်ရဆောန်ဒဲႈတရာ အီကူဇီုဝ် ယာဣရု လာ်ႈပေါပွံတ်၊ ဘံန်ယိူဝ်ဒေငိူပ်ယေဆု အ်ုန်လာ်ႈ ဆကူပ်ပွံတ် တရအာတ်ဇိူင်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","အ်ုန်နွံရ်ႈရဲင်ဖိူမ်ရဲင်ဒေ တောင်ဘာန်ဒါႈ၊ “ကွံန်ရပျာဒျံတ်အော ဘ်ုပ်ဆူဖိူဝ်နာ။ ရာ့်မီ စွလာ်ႈဂံမ်တီမီ တပါင်အ်ုန်စိ၊ က်ုန်ညာခိူည်ဒီန် အ်ုန်ဒီဘိူန်ဒေချံမ်ဆာ အဆာႇအီမ်။” ");
INSERT INTO pll_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ဟွည်ႇဒီန် ယေဆု ဇောမ်လာ်ႈပွံတ်အ်ုန်။ ဘံန်ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ က်ုရ်ညဲတ်ဒေလာ်ႈ ဇောမ်ယေဆု ဂဲတ်ုရ်တိူဝ်ဒိုည်ႇအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ယာမ်ဒီန် ယိူဝ်အီပ်ုန်အူကူ ဘ်ုပ်ဒေခါမ်ဇာ ရောဂါနှာမ်တခူႈနာ ဒံင်ကိူရ်အာရ်ဆန်ုမ်၊ ");
INSERT INTO pll_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","တာဆရာႎှုန်ဘာ့်ဘိူဝ်ဂဲ ဘိူည်ဆန်ုမ်ဒဲႈဂံတ် မောအုဇာဂြူဂြိမ် ဘ်ုရ်ယိူဝ်အ်ုန် ဂိူပ်ဒိုည်ႇ၊ ဆဲႈကာဟြာည် ရောဂါအ်ုန် ယိူင်ရဲ့ယိူင်နာ။ ");
INSERT INTO pll_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ဘံန်အ်ုန်ယိူဝ်ဒေဆတီုင် အကျံင်ယေဆု၊ အ်ုန်လာ်ႈဇောမ်ပွံတ် လ်ုပ်ရဘံန် ဘီက်ုရ်စုဂဲ အတွထိဆဒေါလှိူင်အ်ုန်၊ ");
INSERT INTO pll_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","အ်ုန်ဒါႈရာင်ကွည်ဒေ၊ “အောက်ုန်ဘိူန်အော ထိဂိူဝ်ဆဒေါလှိူင်အ်ုန်၊ ရောဂါအော ဒီဘိူန်ဒေဟြာည်။” ");
INSERT INTO pll_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ဘံန်ညာခိူည်ဒီန် အ်ုန်လာ်ႈထိပွံတ် ဆဒေါလှိူင်ယေဆု၊ ဒံင်အူကပြေ့ အ်ုန်နံပ်ပွံတ် ရောဂါနှာမ်တခူႈ ပ်ုန်ဘ်ုပ်တန်ုတိုဒေဒီန် ဟြာည်။ ");
INSERT INTO pll_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ယေဆုနံပ်ပွံတ် အဖုင်တီုင်ဂိုဒေ လေႈဒိုရ်တို အူဒီန်တောအူဒီန်၊ အ်ုန်က်ုရ်ပံတ်ပွံတ်ဒေငိူပ် လ်ုပ်တန်ုဘီက်ုရ်စုဂဲ အ်ုန်ဆ်ုရ်မွံတ်ဒါႈ၊ “အဆေ ထိဆဒေါအော။” ");
INSERT INTO pll_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","တဘဲႇအ်ုန်ဂဲ ႎီရ်ဒါႈတအ်ုန်၊ “မီယိူဝ်ဘိူဝ်ဒေငိူပ် ဖုင်ဘီဂဲ က်ုရ်စုညဲတ်ဒေလီပ် ခိူည်အီုဝ်၊ ဆေညာ မီဆ်ုရ်မွံတ်ယဲ၊ ‘အဆေတိူဝ်အောဒီန်။’ ” ");
INSERT INTO pll_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ကောည်လိုည် ယေဆုငိူပ်ပွံတ်က်ုရ်ႎျံရ်ဒေ အ်ုန်ဆ်ုန်နံပ် အဆေထိဒေဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ဘံန်အီပ်ုန်ဒီန်နံပ် ခိူည်မောဟွည်ႇပဲန်တတိုဒေ အ်ုန်ယောလူတ်လာည် လာ်ႈမာ့်ပ်ုရ်ဒ်ုပ်ကိင်ကေရ်ဒေ တရအာတ်ဇိူင်အ်ုန်၊ အီပ်ုန်ဒီန် ဂြည်ဆီုဝ်ပွံတ် ခိူည်ပဲန်တတိုဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ယေဆုဒါႈတအ်ုန်၊ “အိူဝ် ကွံန်အီပ်ုန်အော၊ ဖိူမ်ညှိုမ်မီဒီန် ဒဲႈမီချံမ်ဆာယာ့်။ လာ်ႈယေန်ညီမ်ပွံတ်မီ၊ မီချံမ်ဆာ ဒိုရ်ႎိုည်ဒနာဒေဒီန်ယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ယာမ်ယေဆုဒါႈငဲခိူည်ဒီန်၊ ဘီပ်ုရ်ဒီ ဂွည်တဂါင် တာအွံရ်ကိင်ယာဣရု လာ်ႈပေါဒေ ဒါႈတယာဣရု၊ “ကွံန်ရပျာမီ ဟွည်ႇယံမ်၊ မာည်ဒါ့်ကဝ်ဆျှုယာ့် တာဆရာဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ကောည်လိုည် ယေဆု ကာတိူဝ်ႈငဲဂဲလီပ်တနွံရ်ႈဒေ အ်ုန်ဒါႈတတာအွံရ်ကိင် ကျောင်ရဆောန်ဒဲႈတရာ ယာဣရု၊ “မီမာည်နွံရ်ႈဟ၊ ဒဲႈဂိူဝ် မီညှိုမ်။” ");
INSERT INTO pll_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","အခိင်ဒီန် ဆဲႈပေတရု၊ ယာကုပ်ဂါရ် ႎါအ်ုန် ယောဟန် အဆေမိူဝ်ႈ အ်ုန်ကာဒဲႈစိ ဂဲလီပ်ဇောမ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","အခိင်ဂဲရောတ်တဂါင် တာအွံရ်ကိင်ယာဣရု ယေဆုယိူဝ်ဒေငိူပ် ဘီဂဲဒါ့်ကန်ုမ်က်ုရ်ႎှ်ရ်၊ ယိူဝ်ပည်ဒေဆတီုင် ဂဲဒါ့်ယာမ်ဂံရ်ႈရဲင်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","အ်ုန်ဒါႈတဂဲ၊ “ဆေညာ ပဲဒါ့်ယာမ်ကန်ုမ်က်ုန်ႎှ်ရ် ခိူည်ဒီန်။ ကွံန်ကညောမ်အီုဝ် ကာမိူဝ်ႈစိအ်ုန်ယံမ်၊ မိူဝ်ႈအ်ုန်ဒါ့်အီတ်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","အခိင်ဒီန် ဘီဂဲပ်ုန်ဘဝ် ယူမ်ဒိုည်ႇအ်ုန်။ ဘံန်ညာခိူည်ဒီန် ဆဲႈကူန်မာကွံန်ကညောမ်ဂါရ် တဘဲႇဒေဂဲအွည်ကူ အ်ုန်ဆူတ်ဘီဂဲ လေႈဒိုည်ႇဒေရရိူဝ်ႇ၊ ဂဲလီပ်ပွံတ်တအခါန် ကွံန်ကညောမ်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","အ်ုန်ဘာပွံတ်တီ ကွံန်ရပျာဒီန်၊ အ်ုန်ဒါႈ “တလိသ ကုမိ” တီုင်အိုမ်ငဲ ပ်ုန်ဒါႈအ်ုန်ဒီန်မိူဝ်ႈ “အိူဝ် ကွံန်ရပျာ၊ အောဒါႈတမီ ယိူဝ်ႇ။” ");
INSERT INTO pll_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ဒံင်အူကပြေ့ ကွံန်ရပျာဒီန် ယိူဝ်ႇလာ်ႈပွံတ်ဒေ။ (အ်ုန်ဘိူန်ဂိူဝ်ဒေအဆာႇ ကိူရ်အာရ်ဆနံမ်။) အခိင်ဒီန် ဂဲညာအာမ်ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ကောည်လိုည် ယေဆု ပိင်ငျှံပ်ရံတ်ရံတ်ဂဲ မာည်ဂြည် အဆေနံပ် အကျံင်အီုဝ်၊ ဟွည်ႇဒီန် အ်ုန်ဒါႈ၊ “ဒဲႈအ်ုန်ဟောမ် အူနဲအူနဲ။” ");
INSERT INTO pll_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ယေဆု လေႈဒိုရ်အရာပ်ဒီန် ႎီရ်ႎေင်ပွံတ် တကုင်ဇာဒိဒေ၊ တဘဲႇအ်ုန်ဂဲမိူဝ်ႈ ဇောမ်လာ်ႈဒိုည်ႇ ရဘံန်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ရောတ်ဆငီဆဒါင် အ်ုန်ဆာင်ဆောန် တန်ုကျောင်ရဆောန်ဒဲႈတရာ။ ဘံန်ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ် ဂဲယိူဝ်ဒေဆတီုင် ဂဲညာအာမ်ဒိုည်ႇ။ ဂဲဒါႈ၊ “ငျံန်ပိင်ငျာအီုဝ် ဟာမောအ်ုန်ဘိူန်ဒေဒိူည်အဲႈ၊ အဖုင်တီုင်ဂို ခံင်မှိူမ်အာမ်အီုဝ် ခိူည်မောအ်ုန်ညာဒေရ်ုရ်။ ");
INSERT INTO pll_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","အ်ုန်ကာမိူဝ်ႈ လံက်ဆမာ၊ အ်ုန်ကာမိူဝ်ႈ ကွံန်အီမဲ မာရိ၊ အ်ုန်ကာမိူဝ်ႈ ႎည်ယာကုပ်၊ ယောသေ၊ ယုဒဂါရ် ရှိမုန်ဂဲအဲႈ၊ ကာမိူဝ်ႈႎါရပျာအ်ုန်ဂဲ ဂွည်ရူမ်ဇောမ်အယ် အရာပ်အီုဝ်။” ဟွည်ႇဒီန် ဂဲကာရံပ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ယေဆုဒါႈတဂဲ၊ “ပရောဖက်အီုဝ် ဆဲႈတကုင်ဇာဒိဒေ၊ တက်ုန်ဒီ ခြိူဝ်မျိုဒေဂဲဂါရ် တဂါင်ဒေ၊ ယိူဝ်ဘီရိုဆေအ်ုန် တအရာပ်တွံန်တီ။” ");
INSERT INTO pll_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ဆဲႈအ်ုန်ဂံမ်တီဒေ တပါင်ဘီ ကာချံမ်ဆာဂဲ ပ်ုရ်ဒီ ဒဲႈရောဂါဂဲဟြာည်၊ ဆံင်မှာ်ႈမိူဝ်ႈ အ်ုန်ကာရ်ုရ်ပျစိ နမိလက္ခဏာ ခံင်မှိူမ်အာမ် တအရာပ်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ကောပ်ဘီဂဲ ကာယိူဝ်ဖိူမ်ညှိုမ်ညာခိူည်ဒီန် အ်ုန်အာမ်ညှိုႈ။ ဟွည်ႇဒီန် ယေဆု လာ်ႈတကုင်ရူဟံရ် က်ုရ်ႎျံရ်ကုင်ဒီန် အ်ုန်ဆာင်ဆောန်ပွံတ် ဘီဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","အ်ုန်တောႇ တဘဲႇဒေကိူရ်အာရ်ကူ ဒဲႈအခွါင်အာဏာ ဘဲဒေရူပ် ကီုရ်နံမ်ကာကျကာလဂဲ၊ အ်ုန်ပ္လေါည်လာ်ႈပွံတ် အာရ်ကူ အာရ်ကူ။ ");
INSERT INTO pll_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ဟွည်ႇဒီန် အ်ုန်တံမ်ပွံတ်ဂဲ၊ “ဆဲႈဂြိုန်အူညံင် ဆံင်မှာ်ႈမိူဝ်ႈ ပဲမာည်တိူဝ်ႈဒေဒိူည် အတွဒေင်လာ်ႈပဲ။ မုင်ပ်ုန်ဟောမ်၊ ရပျိုဂါရ် ရိူန်ဒဲင်ဂါမိူဝ်ႈ ပဲမာည်ဆ်ုရ်ဒေဒိူည် တရပျိုႎံရ်ညွည်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ချူပ်ချှူစာပ်ပဲ၊ ကောည်လိုည် ပဲမာည်ဒိူည် ဆဒေါလှိူဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","အ်ုန်ႎီရ်တံမ်ထဲင်ဂဲ၊ “ဂါင်မောမိူဝ်ႈဟွည်ႇ ဘီက်ုန်ရဲ့ရံပ်က်ုရ်တူႈပဲ၊ ဂွည်ဂိူဝ်တဂါင်ဂဲ မောပဲႎီရ်လေႈဒိုရ်အရာပ်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ပဲက်ုန်ပေါတကုင် ကာရဲ့ရံပ်ဒေက်ုရ်တူႈပဲ က်ုန်ကာမိူဝ်ႈ က်ုန်ကာဆတီုင်ငဲပဲ လေႈလာ်ႈပွံတ်ပဲ၊ အခိင်ပဲလေႈ ဒိုရ်အရာပ်ရဂွည်ဂဲဒီန် အတွဒဲႈအ်ုန်ပဲန် ဆာ့်ဆေလ်ုပ်ဂဲ တခြ်ုရ်ႈပဲတ် မှုင်က်ုန်ဘူႈ တတာႇဇိူင်ပဲအေ့။” ");
INSERT INTO pll_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ဘံန်ညာခိူည်ဒီန် တဘဲႇအ်ုန်ဂဲ လာ်ႈဟောဂြည်ပွံတ် တဘီဂဲ ဒဲႈဂဲလှောႇဖိူမ် ဒိုရ်အပေတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ဂဲရူပ်လေႈပဲတ် ကီုရ်နံမ်ချှိုဘ္လံမ်၊ ဖွံန်ဒဲႈအိုမ်နံမ်ငါတာန်လူန် တဘီဆူကာချံမ်ဆာဂဲ ဒဲႈရောဂါဂဲဟြာည်ဒိုည်ႇဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ဟွည်ႇဒီန် ဆဒါင်ယေဆု ဂံရ်ႈဟိုဟို လာ်ႈရောတ်ပွံတ်တဟျာ့် တာပ်ုရ်မာင်ဟေရုဒ် ဘီဂဲပ်ုရ်ဒီဒါႈ၊ “ဗတ္တိဇံဆရာယောဟန်အီုဝ် အ်ုန်ႎီရ်ယိူဝ်ႇအီမ်ဒိုရ်ယံမ်။ ကောပ်ခိူည်ဒီန် အ်ုန်ဘဲဒေရ်ုရ်ပျ အဖုင်တီုင်ဂို နမိလက္ခဏာ။” ");
INSERT INTO pll_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ပ်ုရ်ဒီဂဲဒါႈ၊ “အ်ုန်အီုဝ် မိူဝ်ႈဧလိယ။” ပ်ုရ်ဒီဂဲဒါႈ၊ “အ်ုန်အီုဝ် မိူဝ်ႈပရောဖက် ခိူည်ပရောဖက်အူဟိူဝ် အူကူကူ။” ");
INSERT INTO pll_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ဘံန်တာပ်ုရ်မာင်ဟေရုဒ် ယိူဝ်ဒေဆတီုင်၊ အ်ုန်ဒါႈ၊ “အီအီုဝ်မိူဝ်ႈ ပ်ုန်က္လက်ုရ်တ်ုတ်ကိင် ပျံမ်ယံမ်ပဲတ်အော ဗတ္တိဇံဆရာယောဟန် ႎီရ်ယိူဝ်ႇအီမ်ဒေယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","အာတ်ဒီန် တာပ်ုရ်မာင်ဟေရုဒ်အီုဝ် ကောပ်အ်ုန်တိူဝ်ႈဆီမ် ပ်ုန်လဲႎါဒေဖိလိပ္ပု ဟေရောဒိ၊ မိူဝ်ႈတိုအ်ုန် ပ္လေါည်လာ်ႈဘီဒေဂဲ တိုည်ယောဟန် ချပဲတ်တန်ုထံင်။ ကောပ်မိူဝ်ႈအ်ုန် တိူဝ်ႈဆီမ်ပ်ုန်လဲႎါဒေ အ်ုန်တရ်ုရ်ခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ဗတ္တိဇံဆရာယောဟန်ဒါႈ တတာပ်ုရ်မာင်ဟေရုဒ်၊ “မီတိူဝ်ႈဆီမ်ပဲတ် ပ်ုန်လဲႎါဒေဒီန် ကာက်ုရ်ဖြေင်စိဒေ ဇောမ်ထုင်။” ");
INSERT INTO pll_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ဘံန်ညာခိူည်ဒီန် ဟေရောဒိ အူန်ဖိူမ်ရာန်တယောဟန်၊ ဘိူည်ဆ်ုန်ပျံမ်ဂံတ်အ်ုန် ကောပ်တာပ်ုရ်မာင်ဟေရုဒ် အ်ုန်ကာဘိူန်ပဲတ်အခွါင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ကောပ်တာပ်ုရ်မာင်ဟေရုဒ် နံပ်ယောဟန်မိူဝ်ႈ ဘီရိုဆီုဝ်အူကူ၊ အ်ုန်ယောရိုဆေ ယောဟန် ငိူပ်မေန်အူန်လလပွံတ်အ်ုန်၊ တွံန်အ်ုန်ယိူဝ်ဒေဆတီုင် ငဲပ်ုန်ဂြည် ယောဟန် ဘိူည်ပဲန်ဂံတ် ဖိူမ်ဆျှုဆာႇညှိုႈ အ်ုန်အုင်ဒေဆတီုင် ငဲပ်ုန်ဂြည်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ဘံန်လာ ဟေရောဒိ ဘိူန်ပွံတ်အခွါင်ကျ။ တာပ်ုရ်မာင်ဟေရုဒ်အီုဝ် ဘံန်ရောတ်ဆငီကိူတ်ဒေ အ်ုန်ရ်ုရ်ပ္လေါည်၊ ဖီတ်ပါင် တာဒါင်အစိုယဂဲ၊ တာဒါင်အူပ်ဆီုဝ့်ဂါရ် ဘီအွံရ်ကိင်ဂါလိလဲဂဲ အတွဟောမ်ပ္လေါည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ဘံန်ကွံန်ရပျာ ဟေရောဒိ လီပ်ကာပျ တပ္လေါည်ဂဲ၊ ဒဲႈဟေရုဒ်ဂါရ် ခဲႇအ်ုန်ဂဲ ပဲန်နွံရ်ႈဖိူမ်ပျော။ ကောပ်ခိူည်ဒီန် တာပ်ုရ်မာင်ဒါႈ တကွံန်ရပျာဒီန်၊ “ဆေမီဆ်ုန်ဘိူန်၊ ဘ်ုရ်ပ်ုန်ဆ်ုန်ဘိူန်မီ အောဒီဒဲႈတမီ။” ");
INSERT INTO pll_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ပည်ငဲကီန်တိူင် ႎီရ်ဒါႈထဲင် တအ်ုန်၊ “ဘ်ုရ်ပ်ုန်မှာန်မီ အောဒီဒဲႈ မောတကပီုန်ကုင်အော အူက်ုန်ဒါႇ။” ");
INSERT INTO pll_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ဘံန်ညာခိူည်ဒီန် ကွံန်ရပျာပီ လာ်ႈဆမွံတ်ပွံတ် မာဒေ၊ “ဆေအောဒီမှာန်အဲႈ။” မာအ်ုန်ႎီရ်ဒါႈတအ်ုန်၊ “မှာန်ပွံတ်ကိင် ဗတ္တိဇံဆရာယောဟန်။” ");
INSERT INTO pll_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ကွံန်ရပျာဒီန် ႎီရ်လီပ်ဖါည်ဖါည် မှာန်ပွံတ်တတာပ်ုရ်မာင် အူဒီန်တောအူဒီန်၊ “အောဆ်ုန်ဘိူန် ဒဲႈမီတိူဝ်ႈကိင် ဗတ္တိဇံဆရာယောဟန် ဂံမ်တပါင်ဘာန်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","တတာပ်ုရ်မာင်အီုဝ် ဘိူည်ပဲန်ဂံတ် နွံရ်ႈဖိူမ်ကာပျော၊ ကောပ်အ်ုန်အူန်ပဲတ် ငဲကဒိဆေတ်စာ တရအာတ်ခဲႇဒေ၊ အ်ုန်ကာပဲန်ဒေ ႎဲႈထေင် ငဲကွံန်ရပျာဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ဘံန်ညာခိူည်ဒီန် အ်ုန်ပ္လေါည်လာ်ႈပွံတ် ဘီရဲ့အူကူ တန်ုထံင် အတွတိူဝ်ႈဒေဒိူည် ကိင်ယောဟန် အူဒီန်တောအူဒီန်။ ဘီရဲ့ဒီန်မိူဝ်ႈ လာ်ႈက္လက်ုရ်တ်ုတ်ပွံတ် ကိင်ယောဟန် တန်ုထံင် တိူဝ်ႈပွံတ်ဒေဒိူည်။ ");
INSERT INTO pll_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ဟွည်ႇဒီန် အ်ုန်ဂံမ်ကိင်ဒီန် တပါင်ဘာန် ဒဲႈပွံတ်တကွံန်ရပျာ။ ကွံန်ရပျာဒီန်မိူဝ်ႈ လာ်ႈဒဲႈပွံတ် တမာဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ဘံန်တဘဲႇယောဟန်ဂဲ ယိူဝ်ဒေဆတီုင်အကျံင်ဒီန် ဂဲလာ်ႈ တိူဝ်ႈဒေဒိူည် တိုဘီယံမ် ဆာင်ဂျိုပွံတ် တဘီုင်ဆာင်ခဲင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","တမန်ဇ်ုဂဲ ႎီရ်လာ်ႈက်ုရ်စုဒိုည်ႇဒေ တရအာတ်ယေဆု၊ ဘ်ုရ်မောဂဲဆာင်ဆောန် ရ်ုရ်ဒေဒိူည် ဂဲဂြည်ဒိုည်ႇ အ်ုန်ဆတီုင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","အကျံင်ဒီန်မိူဝ်ႈ ဘံန်ဘီလီပ်လီပ်လေႈလေႈ ကီုန်လူတ်လာည် ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ ဂိူပ်ကာတံန်ဒေဟောမ် ပ်ုန်ဟောမ်၊ ဘံန်ညာခိူည်ဒီန် အ်ုန်ဒါႈတဂဲ၊ “အယ်လာ်ႈရလူဘိူဝ် ရာင်ကောည် တအရာပ်ကာယိူဝ်ဘီ။” ");
INSERT INTO pll_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ကောပ်ခိူည်ဒီန် ဂဲဘရိူဝ် ရာင်ကောည်ဒေ လာ်ႈပွံတ် တအရာပ်ယေန်ညီမ်။ ");
INSERT INTO pll_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ဘံန်ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ ယိူဝ်ဒေငိူပ် ဂဲလေႈလာ်ႈပွံတ်ဒိုည်ႇဒေ ညာခိူည်ဒီန်၊ ဂဲနံပ်ပွံတ် အဆေဂဲမိူဝ်ႈ။ ဘံန်ညာခိူည်ဒီန် ဂဲလေႈဒိုည်ႇ ဒိုရ်ကုင်ဒိုရ်ရူဒေ ခူန်လာ်ႈဇောမ်ရဒေင်ဆိုရ် ဂဲလာ်ႈရောတ်ဇံဝ်ပွံတ် ဒိုရ်ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","အခိင်ယေဆု လေႈဒိုရ်ပါင်ရိူဝ်၊ အ်ုန်ယိူဝ်ဒေငိူပ် ဖုင်ဘီက်ုရ်စုဒါင် ညာခိူည်ဆို ကာယိူဝ်ဘီထိင်။ ဘံန်ညာခိူည်ဒီန် အ်ုန်ယိူဝ်ပွံတ် နွံရ်ႈဖိူမ်က်ုရ်ႎေဂဲ ဆာင်ဆောန်ပွံတ်ဂဲ အကျံင်တွံန်နဲ။ ");
INSERT INTO pll_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ဘံန်စူန်အံပ် တဘဲႇအ်ုန်ဂဲ လာ်ႈဇူအ်ုန် ဂဲဒါႈ၊ “အရာပ်အီုဝ် မိူဝ်ႈအရာပ်ကာယိူဝ်ဘီ၊ အခိင်မိူဝ်ႈဟွည်ႇလာယာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ပ္လေါည်ဒဲႈဘီဂဲအီုဝ် လာ်ႈဇိူရ်ႈအူနဲအူနဲ အတွပ်ုန်ဟောမ်ဒေ တက်ုရ်ႎျံရ်ရူအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ယေဆုႎီရ်ဒါႈတဂဲ၊ “ဒဲႈပဲဒဲႈ အတွပ်ုန်ဟောမ်ဂဲ အူနဲအူနဲ။” အခိင်ဒီန် ဂဲႎီရ်ဒါႈ၊ “တယဲအီုဝ် ယိူဝ်ဂိူဝ်ရိူန်ဒဲင်ဂါ အာရ်ပ်ုရ်ယာႈ၊ ခိူည်မောယဲဒီညာ ယဲလာ်ႈဇိူရ်ႈဒဲႈမုင် အတွပ်ုန်ဟောမ်ဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ကောပ်ခိူည်ဒီန် ယေဆုဆ်ုရ်မွံတ်ဂဲ၊ “လာ်ႈငိူပ်မေန်၊ တပဲယိူဝ်မုင် ဒါင်ပံင်အဲႈ၊” ဘံန်ဂဲဟွည်ႇလာ်ႈငိူပ်၊ ဂဲႎီရ်ဒါႈတအ်ုန်၊ “ယိူဝ်ဂိူဝ်မုင်ဖံန်ပံင်ဂါရ် ကာအာရ်တို။” ");
INSERT INTO pll_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ဟွည်ႇဒီန် ယေဆုဆူတ် တဘဲႇဒေဂဲ ဒဲႈဘီဂဲမာ့် တပါင်ကီုရ်ဘာန်ငျံရ် ပေန်က်ုရ်စု ပေန်က်ုရ်စု။ ");
INSERT INTO pll_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ဘံန်ညာခိူည်ဒီန် ဘီဂဲမာ့်က်ုရ်တျံရ်ဒေ အူပ်ုရ်ယာႈက်ုရ်စု၊ ဖံန်ကိူရ်က်ုရ်စု။ ");
INSERT INTO pll_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","အခိင်ဒီန် ယေဆု တိူဝ်ႈပွံတ်မုင်ဖံန်ပံင်ဂါရ် ကာအာရ်တို ဆိူန်ဂိူဝ်ႈပွံတ်တပ္လေင်၊ ဟွည်ႇတာင်ဂုင်ကေစူဖြာ။ အ်ုန်က်ုရ်ပ္လဲႈပွံတ်မုင် ဒဲႈတဘဲႇဒေဂဲ က်ုရ်ဆာင်တဘီဂဲ။ စံမ်ညာခိူည်ဒီန် အ်ုန်က်ုရ်ဆာင်ဒဲႈပွံတ် ကာအာရ်တိုဒီန် တဘီဂဲဒိုည်ႇဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ဘီဒိုည်ႇဒိုည်ႇဂဲဒီန် ဟွည်ႇဟောမ်ဟိူဝ့်။ ");
INSERT INTO pll_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ဟွည်ႇဒီန် တဘဲႇအ်ုန်ဂဲ ထွံရ်အူန်ပ်ုန်ကီုတ် မုင်ဂါရ် ကာ က်ုရ်ပူက်ုရ်ပိုတ်ဒီန် ဘိူန်ပွံတ်ဂုဒါင် အူကိူရ်အာရ်ဂုနာ့်နာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ဘ်ုရ်ဂွည် အီအ်ုန်ဟောမ်မုင်ဒီန် မိူဝ်ႈဂိူဝ်အီမဲဒါင်ဂဲ လာပ်လာပ် ယိူဝ်ဖံန်ဟြဲင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ယာမ်ယေဆု ဒဲႈဖုင်ဘီက်ုရ်စုဂဲႎေင် အ်ုန်ဆူတ်ပွံတ်တဘဲႇဒေဂဲ ဟာ့်တပါင်ရိူဝ်၊ ဒဲႈဂဲႎါည်လာ်ႈပွံတ်ရအာတ် ဆဲႈပြါအိုမ်ဆက္လုင် လ်ုပ်တည် ကုင်ဗက်ဇဲဒ အူဒီန်တောအူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ဟွည်ႇဒီန် အ်ုန်ငဲက်ုရ်ကာႈ တဘီဂဲ၊ အ်ုန်စွဟာ့်ပွံတ်ဒေ တပါင်ဆိုရ် အတွဆုတောင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ရောတ်အခိင်ရမှိူဝ် ရိူဝ်ဂဲဒီန် ဂွည်ပဲတ်ဒေ တက်ုန်ဒီအိုမ်ဆက္လုင်။ ယာမ်ဒီန် ကီုတ်ဂိူဝ်ယေဆု ဒါ့်ဂွည်ပဲတ်ဒေ တပြါအိုမ်။ ");
INSERT INTO pll_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","အ်ုန်ယိူဝ်ဒေငိူပ် တဘဲႇဒေဂဲ ဒါလာႇဒါ့်ႎါည်အိုမ် ကောပ်ခူရ်တာ်ႈကာက်ုရ်တော ဂဲအိူရ်ဒိုည်ႇဒေ၊ ဘံန်ညာခိူည်ဒီန် ရႎါရ်ႈစူန်ပ္လါင် အ်ုန်လာ်ႈပွံတ်ပါင်အိုမ် ရဲန်ဒေက်ုရ်ခါမ် လာ်ႈပြောဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ဘံန်တဘဲႇအ်ုန်ဂဲယိူဝ်ဒေငိူပ် အ်ုန်လာ်ႈပါင်အိုမ် ညာခိူည်ဒီန် ဂဲထာင်အ်ုန်မိူဝ်ႈကီုရ်ဘူ ဂဲပြိုႈဒိုည်ႇဒေရျံင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ဘံန်ဂဲ ယိူဝ်ဒေငိူပ်အ်ုန် ဂဲယောလူတ်လာည် ယူႈယူႈယ်ုရ်ယ်ုရ်ဒိုည်ႇဒေ။ ကောည်လိုည် ယေဆုငဲပွံတ်တဂဲ အူဒီန်တောအူဒီန်၊ “ဒဲႈနွံရ်ႈဖိူမ်ပဲညီမ်၊ မိူဝ်ႈအောမိူဝ်ႈ၊ ပဲမာည်ယော။” ");
INSERT INTO pll_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ဟွည်ႇဒီန် အ်ုန်ဟာ့်ဇူပွံတ်ဂဲ တပါင်ရိူဝ်၊ ခူရ်ဒါင်မိူဝ်ႈ ညီမ်ပွံတ်ဒေ၊ ဘံန်ညာခိူည်ဒီန် တဘဲႇအ်ုန်ဂဲ ညာအာမ်ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ကောပ်မိူဝ်ႈနွံရ်ႈဖိူမ်ဂဲ ခေါလူတ်လာည် ဂဲကာနံပ်ပဲတ်အိုမ်ငဲ အကျံင်အ်ုန်ဟျံင်ဘီဖံန်ဟြဲင် ဟောမ်မုင်။ ");
INSERT INTO pll_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ဟွည်ႇဒီန် ဂဲႎါည်က်ုရ်ခါမ်လာ်ႈ အိုမ်ဆက္လုင် ဘံန်ဂဲရောတ် ဆဲႈပြါအိုမ် တကုင်ဂင်္နေသရက်၊ ဂဲဒါ့်ပွံတ်ရိူဝ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","အခိင်ဂဲလေႈ ဒိုရ်ရိူဝ်၊ ဘံန်ဘီဂဲတံင်ပွံတ်ယေဆု အူဒီန်တောအူဒီန်၊ ");
INSERT INTO pll_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ဘံန်ညာခိူည်ဒီန် ဂဲခူန်လာ်ႈပွံတ် တအရာပ်တွံန်တီ၊ ဟွည်ႇဒီန် ဂဲဒေါဒေဒိူည်လာ်ႈပွံတ် ဘီဆူဖိူဝ်ဂါရ် ရအီတ်ဂဲ တအရာပ် ယိူဝ်ဒေဆတီုင် ဟာရဂွည် ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","အရာပ်ရစွလာ်ႈ ယေဆုတွံန်တီ၊ တကုင်မိူဝ်ႈဟွည်ႇ၊ တရူမိူဝ်ႈဟွည်ႇ က်ုန်ကာမိူဝ်ႈ တနာမိူဝ်ႈဟွည်ႇ ဘီဂဲဒီန် ဒေါဒေဒိူည် ဘီဆူဖိူဝ်ဂဲ လာ်ႈချအူန်ပဲတ်ဂဲ တအရာပ်တကာတ်၊ ဂဲမှာန်အခွါင်တအ်ုန် ဒဲႈဂဲဘိူန်ဒေဒါတီ ထိကဆိုည်ဆဒေါအ်ုန်။ ဘ်ုရ်ယိူဝ်ဘီဂဲဘိူန်ဒေထိဒိုည်ႇ ကဆိုည်ဆဒေါအ်ုန်ဒီန် ဂဲဘိူန်ဒိုည်ႇဒေချံမ်ဆာ။ ");
INSERT INTO pll_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","အခိင်ဒီန် ဖာရိရှဲဂဲ ပ်ုရ်ဒီဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ ယိူဝ်ႇဒိုရ်ကုင်ယေရုရှလင် လာ်ႈပေါဒေ က်ုရ်စုဒိုည်ႇ တပြောယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ဖာရိရှဲဂဲ နွံရ်ႈလှူႈဒေငိူပ် တဘဲႇအ်ုန်ဂဲ ပ်ုရ်ဒီ တီဂဲကာဆပဲ၊ ပ်ုန်ဆ်ုန်ဒါႈအ်ုန်မိူဝ်ႈ၊ ဖာရိရှဲဂဲဒါႈ ထုင်ကာမှိူမ်ရ်ုရ်ဘီ ဂဲရ်ုရ်၊ တီဒေဂဲကာပါည် ဟောမ်ပ်ုန်ဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(က်ုန်မိူဝ်ႈ ဖာရိရှဲဂဲဂါရ် ဘီယုဒဂဲဒီန်၊ တိူဝ်ႈဒေဇောမ်ထုင် ပ်ုန်ဆာင်ဆောန်ဒဲႈ တာယာဒေအူဟိူဝ်၊ က်ုန်ကာပါည်ဘိူဝ်တီဒေ ကာကျာင်စိဒေ ဟောမ်ပ်ုန်ဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","အခိင်ဂဲႎီရ်ရောတ် ဒိုရ်တကာတ်မိူဝ်ႈ က်ုန်ကာပါည်ဆပဲဘိူဝ် ပ်ုန်ဒိူည်ဒေရအာတ် ဂဲကာကျာင်စိဒေဟောမ်။ ဆဲႈဒီန် ဂဲတိူဝ်ႈပည်ဒေဒါထဲင် ထုင်ဇာမ်ပ်ုန်ဟံရ် ခိူည်ခိုည်ႇ ဆလောႇ၊ တလုင်ဒေါင်၊ က္လိုဒေါင်ဂါရ် ရအီတ်ဒေဂဲ။) ");
INSERT INTO pll_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ဘံန်ညာခိူည်ဒီန် ဖာရိရှဲဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ ဆ်ုရ်မွံတ်ယေဆု၊ “ကောပ်ဆေ တဘဲႇမီဂဲ ကာဇောမ် ထုင်အူန်ကူန်မာ တာယာအယ်အူဟိူဝ်၊ ဂဲဒါတီ ကာဆပဲဒေ ဒါ့်ဟောမ်ပ်ုန်ဟောမ်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ယေဆု ႎီရ်ဒါႈတဂဲ၊ “အခိင်ဟေရှာယ ရ်ုရ်ပရောဖက် ဂြည်အူန် အကျံင်ပဲမှာန်ညှိုႈ၊ ခိူည်ပ်ုန်ဒါႈအ်ုန် ပဲမိူဝ်ႈညှိုႈ ညာရာင်ဘီဆူဒေါ၊ ပ်ုန်တဲမ်အူန်အ်ုန်ဒီန်မိူဝ်ႈ၊ “ ‘ဖြာဒါႈ၊ ဘီဂဲအီုဝ်၊ မူရ်ဂဲ ဘိူည်ရိုဆေဂံတ်အော၊ က်ုန်မိူဝ်ႈနွံရ်ႈဖိူမ်ဂဲ ဆငါည်ညှိုႈ ဒိုရ်အော။ ");
INSERT INTO pll_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ပ်ုန်ကိုကွည်ဂဲ တအော ကာထူစိ၊ ကောပ်ဆေတဒါႈခိူည်ဒီန် ဂဲဆာင်ဆောန် ဒဲႈဂိူဝ်ဥပဒေ ဒေင်လာ့်လာည်ဘီဂဲ၊ ညာခိူည် ပိင်ငျှံပ်အော။’ ");
INSERT INTO pll_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ပဲထေင်ဒိုည်ႇပဲတ် ပိင်ငျှံပ်ဖြာ ပဲတိူဝ်ႈဒိုည်ႇဒေဒါ ပ်ုန်ဆာင်ဆောန်ဘီဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ဟွည်ႇဒီန် ယေဆုႎီရ်ဆီုပ်ဒေဒါႈ၊ “အတွပဲဒဲႈထုင် ပ်ုန်ဆာင်ဆောန်ဒေမြဲ ပဲလှညှိုႈဒေ ထေင်ဒိုည်ႇပဲတ် ပိင်ငျှံပ်ဖြာ။ ");
INSERT INTO pll_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","မောရှေ ပိင်ငျှံပ်အူန်၊ ‘ရိုဆေကူန်မာပဲ၊ အဆေမိူဝ်ႈဟွည်ႇ က်ုန်အေႈကီန်တိူင် ကူန်မာဒေ ဒီဘ်ုပ်ဒေခါမ် တာမ်ယံမ်။’ ");
INSERT INTO pll_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ကောည်လိုည် ပဲက်ုန်ဒါႈ၊ ဘီအူကူ ဘိူည်ယိူဝ်ဂံတ် ပ်ုန်လှူ ဒဲႈအကျိုအူနဲနဲ တကူန်မာဒေ အ်ုန်က်ုန်ဒါႈ ‘မိူဝ်ႈကော်ဘန်ယာ့်’ (အိုမ်ငဲအ်ုန်မိူဝ်ႈ၊ ပ်ုန်လှူအီုဝ် ဟွည်ႇကာပ်ဒဲႈ တဖြာ)၊ ");
INSERT INTO pll_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","အီကူဒီန် ကာလိုယာ့် ရ်ုရ်ဇောည် ကူန်မာဒေ၊ ပဲဆမာနံပ်ဒေ ဆာင်ဆောန်ညာခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ပဲဆာင်ဆောန်ဒဲႈ တဘီဟံရ် ဒါဒေင်လာ့်လာည်အီုဝ် မိူဝ်ႈညှိုႈပဲထေင်ဒိုည်ႇပဲတ် ငဲဖြာ။ ဆဲႈဒီန် ခံင်ရ်ုရ်ပဲ ပ်ုန်ဟံရ် ယိူဝ်ထဲင်ဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","အခိင်ဒီန် ယေဆု ႎီရ်တောႇထဲင် ဖုင်ဘီက်ုရ်စု လာ်ႈတဒေ၊ အ်ုန်ဒါႈတဂဲ၊ “ဆတီုင်ဘိူဝ်ငဲအော ဒဲႈပဲနံပ်ဒိုည်ႇတွံန်ကူ။” ");
INSERT INTO pll_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ခံင်ယိူဝ်ႇဒိုရ်ရရိူဝ်ႇဘီ လီပ်တရန်ုဘီဒီန်၊ အူနဲမောမိူဝ်ႈ ကာယိူဝ်စိ အ်ုန်ဘဲဒေဒဲႈ ဘီပဲန်ကာဆပဲ။ မိူဝ်ႈဂိူဝ် ခံင်ယိူဝ်ႇဒိုရ်တရန်ုဘီ လေႈရရိူဝ်ႇဒီန် အ်ုန်ဆမာဒဲႈ ဘီပဲန်ကာဆပဲ။ ");
INSERT INTO pll_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","အခိင်ယေဆု ဟွည်ႇလေႈ ဒိုရ်ဖုင်ဘီက်ုရ်စုဂဲ ယာမ်အ်ုန်လီပ်တန်ုဂါင်၊ တဘဲႇအ်ုန်ဂဲဆ်ုရ်မွံတ် အကျံင်ငဲပုင်တဲႇဒီန်တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","အခိင်ဒီန် ယေဆုဒါႈတဂဲ၊ “ပဲကာယိူဝ်ဂံတ် ငျံန်ပိင်ငျာ ဒိုရ်ဘီဟံရ်ဂဲ။ ပဲကာနံပ်၊ ယိူဝ်ႇဒိုရ်ရရိူဝ်ႇဘီ လီပ်တရန်ုဘီ ခံင်နဲမောမိူဝ်ႈဟွည်ႇ ကာဘဲစိဒေရ်ုရ်ဒဲႈပဲကာဆပဲ၊” ");
INSERT INTO pll_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","“ကောပ်ဆေတဒါႈ ခံင်ကာဆပဲဒီန် ကာမိူဝ်ႈစိ အ်ုန်လီပ်တန်ုပ္လေဖိူမ်ဘီ၊ အ်ုန်က်ုန်ဟွည်ႇလီပ်ရောတ် တရန်ုႎဲ့ပုင်ဟောမ် လေႈဒိုည်ႇပွံတ်ဒေ တဘီုင်ရအိင်။” (တန်ုငဲအီုဝ်မိူဝ်ႈ ယေဆုဒါႈတဂဲ ခံင်ပ်ုန်ဟောမ်တွံန်နဲ ဘိူန်ဒိုည်ႇဟောမ်။) ");
INSERT INTO pll_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ဆဲႈဒီန် အ်ုန်ႎီရ်ဒါႈထဲင် တဂဲ၊ “ခံင်လေႈဒိုရ် တရန်ုဘီဒီန်၊ အ်ုန်ဆမာဒဲႈ ဘီပဲန်ကာဆပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","အကျံင်ဒီန်မိူဝ်ႈ တရန်ုပ္လေဖိူမ်ဘီအီုဝ် ဆမာခံပ်က်ုရ်ယေင် ကာကျကာလ၊ ဆမာက်ုရ်လူတ်တပ်ုန်လဲဘီ၊ ဆမာရာတ်ဂြူဘီ၊ ဆမာပျံမ်အဆာႇဘီ၊ ");
INSERT INTO pll_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","လောဖဒါင်၊ ဆမာအူန်ဖိူမ်ကာကျ၊ ကာအိုတ်၊ ဇောမ်ဂုင်ကာမ၊ ဆမာဒဲႈကာလနွံရ်ႈဖိူမ်ဒေ၊ ဆမာငဲအေႈ၊ ယိူဝ်မာနဒါင်ဂါရ် ဆမာႎါဝ်ရိူဝ်ဒီန် မိူဝ်ႈလေႈဒိုည်ႇ ဒိုရ်န်ုပ္လေဖိူမ်ဘီ။ ");
INSERT INTO pll_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ဘ်ုရ်ယိူဝ်ဖိူမ်ကာကျ ခံင်မှိူမ်ရအီရ်ႈ လေႈဒိုရ်ရန်ုတိုဘီအီုဝ် ဆမာဒဲႈဘီပဲန် ခံင်ကာဆပဲ။ ");
INSERT INTO pll_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ဘံန်ယေဆု ယိူဝ်ႇဒိုရ်အရာပ်ဒီန် အ်ုန်စွလာ်ႈ တအရာပ်ပြော ကုင်တုရု။ အ်ုန်လီပ်ပွံတ်ဒေ တဂါင်အူဂါင်၊ အ်ုန်ဘိူည်ကာဆ်ုန်ဒဲႈဂံတ် ဘီဂဲနံပ် ကာပဲန်စိဒေ မောတိုဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","မာကွံန်ရပျာ ကီုရ်နံမ်ကာကျကာလ လီပ်စံပ်ဒီန်၊ ဘံန်အ်ုန်ယိူဝ်ဒေဆတီုင် အကျံင်ယေဆု၊ အ်ုန်လာ်ႈဇူပွံတ်ယေဆု အူဒီန်တောအူဒီန် မာ့်ဂြူပ်ပွံတ် တပြောဇိူင်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","အီပ်ုန်ဒီန်မိူဝ်ႈ ခြိူဝ်မျိုဟေလသ၊ ကိူတ်တကပီုန်ကုင်ရှုရိဖိနိတ်။ အ်ုန်မှာန် ဒဲႈယေဆု ရူပ်လေႈပဲတ်ကီုရ်နံမ်ချှို ဒိုရ်တိုကွံန်ရပျာဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ကောည်လိုည် ယေဆုႎီရ်ဒါႈတအ်ုန်၊ “ဒဲႈဘိူဝ် ကွံန်ႎါအောဂဲ ဟောမ်ဟိူဝ့်ရအာတ်။ ကာကျစိ တတိူဝ်ႈပ်ုန်ဟောမ် ကွံန်ႎါအောဂဲ ဂံမ်ဒဲႈအအို့ဂဲဟောမ်။” ");
INSERT INTO pll_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","အီပ်ုန်ဒီန် ႎီရ်ဒါႈ၊ “မိူဝ်ႈအေ့ ကီုရ်ညာ၊ ပ်ုန်ဟောမ်ကွံန်ႎါ ဇာ်ႈရခြူမ်ဘွည် တရူတရီတ်ဒီန် အအို့ဂဲအီုဝ် ယိူဝ်အေ့ထုင်ဇာမ် ထွံရ်ဒေဟောမ်။” ");
INSERT INTO pll_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ယေဆုဒါႈတအ်ုန်၊ “ကောပ်ငဲပ်ုန်ဂြည်မီအီုဝ် ႎေင်ပွံတ်မီတဂါင်၊ ကီုရ်နံမ်ချှိုဒီန်ဟွည်ႇလေႈ ဒိုရ်ကွံန်ရပျာမီယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ဘံန်အီပ်ုန်ဒီန် ႎီရ်ႎေင်ပွံတ်ဒေတဂါင် အ်ုန်ယိူဝ်ဒေငိူပ် ကွံန်ရပျာဒေ ဒါ့်အီတ်နှေရ်ဒေတပါင်ချှံင်၊ ကီုရ်နံမ်ချှိုမိူဝ်ႈ ဟွည်ႇလေႈပွံတ်ဒေ ဒိုရ်တိုကွံန်ရပျာအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ဟွည်ႇဒီန်ယေဆု ႎီရ်လေႈဒိုရ်အရာပ်တုရု လာ်ႈက်ုရ်ခါမ်ပွံတ် ကုင်ဇိဒုန်၊ အ်ုန်လာ်ႈရောတ်ပွံတ် တအိုမ်ဆက္လုင်ဂါလိလဲ ကပီုန်ကုင်ဒေကာပေါလိ။ ");
INSERT INTO pll_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","အခိင်ဒီန် ဘီဂဲပ်ုရ်ဒီ တောႇဒေဒိူည် အီအူကူ ဟျာ့်ဇံန်ကာခီုတ်ငဲ ပေါတယေဆု၊ ဂဲမှာန် ဒဲႈယေဆု ဂံမ်တီဒေ တပါင်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ဘံန်ညာခိူည်ဒီန် ယေဆု တောႇလာ်ႈပွံတ်အီကူဒီန် တအရာပ်ယေန်ညီမ် ဒိုရ်န်ုဖုင်ဘီက်ုရ်စုဂဲ၊ အ်ုန်ဒါရ်ုန်ဂိုရ်တီဒေ စီလီပ်ပွံတ် တန်ုဘီုင်ဟျာ့်အ်ုန် အာရ်ခေါန်၊ ဟွည်ႇဒီန် ဘဲ့အိုမ်ဘဲ့ဒေ စူတ်ပွံတ် တကီုရ်တာႇ အီကူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","အခိင်ဒီန် ယေဆု ဆိူန်ဂိူဝ်ႈဒေငိူပ် တပ္လေင် အ်ုန်ငှူရ် ဒါႈ၊ “ဧဖသ” အိုမ်ငဲဧဖသဒီန်မိူဝ်ႈ၊ “ဒဲႈအ်ုန်က်ုရ်ပိူဝ်ႈ။” ");
INSERT INTO pll_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ဒံင်အူကပြေ့ ဟျာ့်အ်ုန်ဒီန်မိူဝ်ႈ က်ုရ်ပိူဝ်ႈ၊ ဘံန်ဆနာႇကီုရ်တာႇအ်ုန် ညောတ်ညောတ် ဘိူန်ပွံတ်ဒေငဲလလ။ ");
INSERT INTO pll_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","အခိင်ဒီန် ယေဆု ပိင်ငျှံပ်အူန်ဘီဂဲ မာည်ဂြည်အကျံင်အီုဝ် တအဆေ၊ အ်ုန်ဘိူည်ပိင်ငျှံပ်အူန်ဂံတ်ဂဲ ညာခိူည်ဒီန် ဂဲယိူင်ႎရဂြည်လှိူဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ဘံန်ဘီဂဲ ယိူဝ်ဒေဆတီုင် အကျံင်ဒီန် ဂဲအာမ်ညှိုႈညှိုႈ။ “အ်ုန်နံပ်ဒေရ်ုရ်ညာခိူည်အီုဝ် ဘ်ုရ်မောဒါႈဒေကျညှိုႈ၊” ဂဲဒါႈဒိုည်ႇခိူည်ဒီန်။ “အီအ်ုန်ဟျာ့်ဇံန်ကာခီုတ်ငဲလိုည် ဟွည်ႇဒဲႈအ်ုန်ယိူဝ်ဒေဆတီုင် ဘဲဒေငဲယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ဘံန်ကာဇီုဝ့် ဖုင်ဘီက်ုရ်စုဒါင် ပ်ုန်ဟံရ်ဂဲ လာ်ႈက်ုရ်စုရူမ်ဒိုည်ႇဒေ။ ကောပ်ကာယိူဝ်ပ်ုန်ဟောမ် တဂဲဒီန်၊ ယေဆု တောႇပွံတ် တဘဲႇဒေဂဲ အ်ုန်ဒါႈ၊ ");
INSERT INTO pll_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“အောက်ုရ်ႎေညှိုႈ ဘီဂဲအီုဝ်၊ ဂဲဟွည်ႇဂွည်ရူမ် ဇောမ်အော ဘိူန်အွည်ဆငီ၊ ပ်ုန်ဟောမ် ဆံင်မှာ်ႈမိူဝ်ႈ ကာယိူဝ်တဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","က်ုန်ကာဟျံင်ဘိူဝ် ဂဲဟောမ်ပ်ုန်ဟောမ် ပ္လေါည်ႎေင်တဂါင် ဘီပ်ုရ်ဒီမိူဝ်ႈ ကောပ်ယိူဝ်ႇ ဒိုရ်တအရာပ်ဆငါည်၊ ဂဲဒီအိူရ် မဝ်ဂေႈဒိုည်ႇဒေ တရဒေင်။” ");
INSERT INTO pll_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","တဘဲႇအ်ုန်ဂဲ ႎီရ်ဒါႈတအ်ုန်၊ “တန်ုဘြီအရာပ်အီုဝ် အဆေဒီဘဲဒေလဲမ်မုင် ဟျံင်ဂဲဟောမ် မောဂိူပ်ဟိူဝ့်။” ");
INSERT INTO pll_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ယေဆု ဆ်ုရ်မွံတ်ဂဲ၊ “တပဲယိူဝ်မုင် ဘ်ုရ်မော၊” ဂဲႎီရ်ဒါႈတအ်ုန်၊ “တယဲ ယိူဝ်ဂိူဝ်မုင်ပူရ်ပံင်။” ");
INSERT INTO pll_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","အခိင်ဒီန် အ်ုန်ဆူတ် ဖုင်ဘီက်ုရ်စုဂဲ မာ့်ဒိုည်ႇဒေ တပါင်ကတဲ။ ဟွည်ႇဒီန် အ်ုန်တိူဝ်ႈပွံတ် မုင်ပူရ်ပံင်ဒီန် တာင်ဂုင်ကေစူ တဖြာ၊ အ်ုန်ပ္လဲႈမုင်ဒီန် ဒဲႈပွံတ်တဘဲႇဒေဂဲ က်ုရ်ဆာင်ဒဲႈ တဖုင်ဘီက်ုရ်စုဂဲ၊ ဂဲဒီန်မိူဝ်ႈ လာ်ႈက်ုရ်ဆာင်ဒဲႈပွံတ် ခိူည်ပ်ုန်ဒါႈအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ဘံန်တရန်ုဂဲ ယိူဝ်ပည်ကာဒျံတ်ဒျံတ် တရီတ်၊ ယေဆုဟွည်ႇတာင် ဂုင်ကေစူ အတွဒီန်၊ အ်ုန်ဆူတ်ပွံတ် တဘဲႇဒေဂဲ က်ုရ်ဆာင်ဒဲႈ တဖုင်ဘီက်ုရ်စုဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ဘီဂဲတွံန်ကူ ဟွည်ႇဟောမ်ဟိူဝ့်ဒိုည်ႇ၊ တဘဲႇအ်ုန်ဂဲ ထွံရ်ပ်ုန်ကီုတ် က်ုရ်ပူက်ုရ်ပိုတ်ဒီန် ဘိူန်ပွံတ်ပူရ်ဂုနာ့်နာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","တအရာပ်ဒီန် ယိူဝ်ဘီက်ုရ်ပံတ် ဖိုန်ဟြဲင်။ ယေဆု ပ္လေါည်ႎေင်ပွံတ်ဂဲဒီန်၊ ");
INSERT INTO pll_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","အခိင်ဒီန် အ်ုန်ဟာ့်ရူမ် ဇောမ်တဘဲႇဒေဂဲ တပါင်ရိူဝ် အူဒီန်တောအူဒီန် ဂဲလာ်ႈပွံတ် တအရာပ် ဒါလမနုသ။ ");
INSERT INTO pll_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","အခိင်ဒီန် ဖာရိရှဲဂဲပ်ုရ်ဒီ လာ်ႈရောတ်ဒေ က်ုရ်မိုန်က်ုရ်ထေင် ဇောမ်ယေဆု၊ ကောပ်ဂဲဆ်ုန်စာမ်ဒေ ခြီုမ်အ်ုန် ဂဲမှာန်ဒဲႈအ်ုန်ပျ နမိလက္ခဏာ ယိူဝ်ႇဒိုရ်ပ္လေင်။ ");
INSERT INTO pll_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ကောည်လိုည် ယေဆု က်ုန်အိူဝ်ႈဖိူမ်ဒါင်ဒေ ဒါႈတဂဲ၊ “ကောပ်ဆေ ဘီခြိူဝ်မျိုဂဲအီုဝ် နံပ်ဒေမှာန်နမိလက္ခဏာအဲႈ၊ အောဂြည်ညှိုႈတပဲ၊ ဆံင်မှာ်ႈမိူဝ်ႈ အောကာပျဒဲႈစိ နမိလက္ခဏာ တဘီခြိူဝ်မျိုဂဲအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","အ်ုန်လေႈပွံတ်ဒေဒိုရ်ဂဲ ႎီရ်ဟာ့်ဒေတပါင်ရိူဝ် ဂဲႎါည်လာ်ႈပွံတ် ဆဲႈပြါအိုမ်ဆက္လုင်လ်ုပ်တည်။ ");
INSERT INTO pll_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ဘံန်တဘဲႇအ်ုန်ဂဲ ဘီရ်တိူဝ်ႈဒေဒိူည် မုင်လုင်လုင်လာ့်လာ့်၊ တရန်ုရိူဝ်ဂဲဒီန် ယိူဝ်ဂိူဝ်မုင်အူပံင်။ ");
INSERT INTO pll_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","အခိင်ဒီန် ယေဆုဒဲႈဆဒိတဂဲ၊ “ဒဲႈပဲအူန်ဆဒိ၊ ပဲလိုႎဲႈဆန်ုမ်ဂိူဝ်ႈ ဖာရိရှဲဂဲဂါရ် ဆန်ုမ်ဂိူဝ်ႈ ဟေရုဒ်အေ့။” ");
INSERT INTO pll_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ဂဲက်ုရ်မိုန်က်ုရ်ဂြည်တဒေ အူကူတောအူကူ ဂဲဒါႈ၊ “ကောပ်အယ်ကာဒိူည်မုင် အ်ုန်ဒါႈဒေငဲ တအယ်ခိူည်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ဘံန်ယေဆုနံပ် ဂဲက်ုရ်မိုန်က်ုရ်ဂြည်ခိူည်ဒီန်၊ အ်ုန်ဆ်ုရ်မွံတ်ဂဲ၊ “ဆေညာ ပဲဒါ့်က်ုရ်မိုန်က်ုရ်ဂြည် အကျံင်ပဲ ကာဒိူည်မုင်ဒီန်အဲႈ။ ပဲညှံမ်နံပ်၊ ညှံမ်လှူႈဘိူဝ် တဖိူမ်ဒေ၊ ပ္လေဖိူမ်ပဲဒါ့်ခေါပဲတ် မောအူဒီန်အီုဝ်အဲႈ။ ");
INSERT INTO pll_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ပဲယိူဝ်ဘိူဝ်ဒေပ္လေငါည် ကာယိူဝ်ဒေငိူပ်၊ ပဲယိူဝ်ဘိူဝ်ဒေဟျာ့် ကာယိူဝ်ဒေဆတီုင်၊ ပဲကာတံင်ဘိူဝ်အဲႈ၊ ");
INSERT INTO pll_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ယာမ်အောက်ုရ်ပ္လဲႈဒဲႈ မုင်ဖံန်ပံင် အတွဘီဖံန်ဟြဲင် ဒါင်ဂုပဲဘိူန်ဒေ ထွံရ်တကျြံတ် ပ်ုန်ကီုတ် က်ုရ်ပူက်ုရ်ပိုတ်အ်ုန်ဒီန်” ဘံန်အ်ုန်ဆ်ုရ်မွံတ်ဂဲ ခိူည်ဒီန်။ ဂဲႎီရ်ဒါႈတအ်ုန်၊ “ဘိူန်ကိူရ်အာရ်ဂု။” ");
INSERT INTO pll_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ယာမ်အောက်ုရ်ပ္လဲႈဒဲႈ မုင်ပူရ်ပံင် အတွဘီဖိုန်ဟြဲင် ဒါင်ဂုပဲဘိူန်ဒေ ထွံရ်တကျြံတ် ပ်ုန်ကီုတ် က်ုရ်ပူက်ုရ်ပိုတ်ဒီန်” ဘံန်ယေဆု ႎီရ်ဆ်ုရ်မွံတ်ဂဲခိူည်ဒီန်။ ဂဲႎီရ်ဒါႈတအ်ုန်၊ “ဘိူန်ပူရ်ဂု။” ");
INSERT INTO pll_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","အ်ုန်ႎီရ်ဒါႈတဂဲ၊ “ပဲညှံမ်နံပ်ဘိူဝ် မောအူဒီန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","အခိင်ဂဲရောတ်ဒိုည်ႇ တရူဗက်ဇဲဒ၊ ဘီပ်ုရ်ဒီဂဲ တောႇဒေဒိူည် အီငါည်အံပ်အူကူ လာ်ႈရောတ် တယေဆု၊ ဂဲမှာန် ဒဲႈအ်ုန်ထိ အီကူဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ယေဆု တီုတ်ဒေဘာတီ အီကူငါည်အံပ်ဒီန် တောႇလေႈပွံတ်အ်ုန်ရိူဝ့်ရူ။ ဟွည်ႇဒီန် ယေဆုဘဲ့ပွံတ် အိုမ်ဘဲ့ဒေတပ္လေငါည်အ်ုန်၊ ဂံမ်တီဒေ တပါင်အ်ုန် ဆ်ုရ်မွံတ်ပွံတ်၊ “မီပည်ယိူဝ်ဒေငိူပ် အူနဲအူနဲ။” ");
INSERT INTO pll_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","အီကူဒီန် ဆိူန်ဂိူဝ်ႈဒေငိူပ် ဒါႈတအ်ုန်၊ “အောယိူဝ်ယာ့် အောငိူပ်ဘီဂဲ၊ ကောည်လိုည် ဂဲနှေရ်ဒိုည်ႇပဲတ် တီုင်ဟေဂဲ လာ်ႈလာ်ႈႎေင်ႎေင်။” ");
INSERT INTO pll_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ဟွည်ႇဒီန် ယေဆုႎီရ်ဂံမ်တီဒေ တပါင်ပ္လေငါည်အ်ုန်။ အခိင်ဒီန် အ်ုန်ငိူပ်ပွံတ်လလ၊ ပ္လေငါည်အ်ုန် ပ္လါင်ဆာင်လာင် ယိူဝ်ပွံတ်ဒေငိူပ် ကတီကရီ။ ");
INSERT INTO pll_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ယေဆုဒါႈ၊ “မီမာည်ဂွည်ႇလီပ်ယာ့် တရူ” ဟွည်ႇဒါႈခိူည်ဒီန် ပ္လေါည်ႎေင်ပွံတ်အ်ုန် တဂါင်။ ");
INSERT INTO pll_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","အခိင်ဒီန် ယေဆု စွလာ်ႈရူမ်ဇောမ် တဘဲႇဒေဂဲ အရာပ်ဒံတ်ရူ တကုင်ကဲသရိဖိလိပ္ပိ။ ယာမ်ဂဲလာ်ႈတဒေင် အ်ုန်ဆ်ုရ်မွံတ်တဘဲႇဒေဂဲ၊ “ဂြည်ဘိူဝ်တအော၊ ဆေဘီဂဲအီုဝ် ဒါႈအောမိူဝ်ႈအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ဂဲႎီရ်ဒါႈ၊ “ပ်ုရ်ဒီဒါႈ မီမိူဝ်ႈ ဗတ္တိဇံဆရာယောဟန်၊ ပ်ုရ်ဒီဒါႈ မီမိူဝ်ႈ ဧလိယ၊ ပ်ုရ်ဒီဒါႈ မီမိူဝ်ႈ ပရောဖက် အူကူအူကူ။” ");
INSERT INTO pll_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ဟွည်ႇဒီန် အ်ုန်ႎီရ်ဆ်ုရ်မွံတ်ဂဲ၊ “က်ုန်မိူဝ်ႈပဲ၊ ဆေပဲ ဒါႈအောမိူဝ်ႈ။” ပေတရု ႎီရ်ဒါႈတအ်ုန်၊ “မီမိူဝ်ႈ မေရှိယ။” ");
INSERT INTO pll_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","အခိင်ဒီန် ယေဆုပိင်ငျှံပ် ဒဲႈဆဒိတဂဲ၊ “ပဲမာည်လာ်ႈဂြည် အကျံင်အော တအဆေအေ့။” ");
INSERT INTO pll_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ဟွည်ႇဒီန် ယေဆုဆာင်ဆောန် တဘဲႇဒေဂဲ၊ “ကွံန်ဘီအီုဝ် ဒီဘ်ုပ်ဒေက်ုရ်တူႈ ႎိုည်ဒနာဘ္လံမ်ဂါရ် ဘီအဆာႇဒါင်ဝါဒါင်ဂဲ၊ ယဇ်ပုရောဟိတ်ဒါင်ဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ ႎဲႈထေင်ပဲတ်ဒေ။ ဒီဘ်ုပ်ဒေက်ုရ်တူႈထဲင် ဂဲပျံမ်ယံမ်ပဲတ်ဒေ၊ ကောည်လိုည် က်ုန်ဟွည်ႇဘိူန်အွည်ဆငီ အ်ုန်ဒီႎီရ်ယိူဝ်ႇအီမ်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ဘံန်အ်ုန်ဂြည်ဆာင်လာင် အကျံင်ဒီန်တဂဲ ပေတရု တောႇလာ်ႈအ်ုန်လ်ုပ်ဟံရ် တာင်အပေတ်တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ကောည်လိုည် ယေဆုက်ုရ်ပံတ်ငါည်ဒေ ငိူပ်ပွံတ်လ်ုပ်တဘဲႇဒေဂဲ၊ အ်ုန်တာင်အပေတ် ဒါႈဒေဆုင်မပွံတ် ပေတရု၊ “အိူဝ် စာတန် လေႈပွံတ်မီဒိုရ်အော၊ ပ်ုန်စေ့ကူမီဒီန် ကာမိူဝ်ႈစိ ယိူဝ်ႇဒိုရ်တဖြာ၊ မိူဝ်ႈယိူဝ်ႇ ဒိုရ်တဘီဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","အခိင်ဒီန် ယေဆု တောႇပွံတ် တဘဲႇဒေဂဲဂါရ် ဖုင်ဘီက်ုရ်စု၊ အ်ုန်ဒါႈတဂဲ၊ “အဆေမိူဝ်ႈဟွည်ႇ က်ုန်ဆ်ုန်ဇောမ်ရဘံန်အော ဒီဘ်ုပ်ဒေထေင်တိုဒေ၊ ဒီဘ်ုပ်ဒေကွံတ် တီုင်ဒါ်ႈစံပ်တာႇတီဒေ။ ဟွည်ႇဒီန် တဘိူန်ဒေဇောမ်လာ်ႈ ရဘံန်အော။ ");
INSERT INTO pll_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ကောပ်ဆေတဒါႈခိူည်ဒီန် အီအ်ုန်ဆ်ုန်ပ်ုန်လောတ် အဆာႇဒေအီုဝ်၊ ဒီဘ်ုပ်ချှူမ် အဆာႇဒေ။ ကောည်လိုည် အီအ်ုန်ခါမ် အဆာႇဒေချှူမ် ကောပ်အောဂါရ် ကောပ်ဆဒါင်ကျအောဒီန် ဒီဘိူန်ဒေပ်ုန်လောတ်။ ");
INSERT INTO pll_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ဘီအီုဝ် ဘိူည်ဘိူန်ဂံတ်ဒေ ဘြောင်ဒိုည်ႇကံမ်ဖာ က်ုန်ချှူမ်အဆာႇႎိငျံန်ဒေ ဆေဒီယိူဝ်အကျိုအဲႈ။ ");
INSERT INTO pll_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","က်ုန်ချှူမ် အဆာႇႎိငျံန်အယ်၊ ဒါခံင်နဲမော ဒီဘဲဒေႎီရ်ရံရ်ႈဒဲႈ အဆာႇအယ်အဲႈ။ ");
INSERT INTO pll_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ခိင်ခါဝ်ကာပ်ကာကျ ဘီကာနံပ်ဖြာတရာ၊ အဆေမိူဝ်ႈဟွည်ႇ က်ုန်ကဆေ ကောပ်အောဂါရ် ကောပ်ငဲပ်ုန်ဆာင်ဆောန်အော၊ အခိင်ကွံန်ဘီအီုဝ် ဒါအဖုင်တီုင်ဂို ကူန်ဖြာဒေ စွလေႈရူမ် ဇောမ်တမန်ဇ်ုဆပဲဂဲတပ္လေင် အ်ုန်ဒီဘ်ုပ်ဒေကဆေ အတွဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ဟွည်ႇဒီန် အ်ုန်ဒါႈတဂဲ၊ “အောဂြည်ညှိုႈတပဲ၊ ဘီပ်ုရ်ဒီ ဒါ့်ဇံင်က်ုရ်တောအီုဝ် ကြိူည်ဂဲယိူဝ်ဒေငိူပ် ကပီုန်ကုင်ဖြာ ပြေ့စုင် တအဖုင်တီုင်ဂိုဒေ ဂဲညံမ်ဘိူန်စိယံမ်။” ");
INSERT INTO pll_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ဟွည်ႇဘိုန်တောရ်ဆငီ ယေဆု တောႇဂိူဝ်ဒေဒိူည်လာ်ႈ ပေတရု၊ ယာကုပ်ဂါရ် ယောဟန် ဟာရဂွည်ကွည်ဒေ တပါင်ဆိုရ်ဇာရ်။ အခိင်ဒီန် ပုင်ရံင်ယေဆု က်ုရ်လှာႇပွံတ်ဒေ တရအာတ်ဂဲ၊ ");
INSERT INTO pll_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ဂြူဒါအ်ုန်ဒီန် ညာဘ္လောႇဘ္လူႇ ဂူႈလာ်ႈပွံတ်ဒေ၊ တန်ုကတဲကံမ်ဖာအီုဝ် အဆေမိူဝ်ႈ ကာဘဲစိဒေလ်ုရ်ႈ မောအ်ုန်ဂိူပ်ဘ္လောႇဘ္လူႇ ညာခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","အခိင်ဒီန် တဘဲႇအ်ုန်ဂဲ အွည်ကူ ယိူဝ်ဒေငိူပ် မောရှေဂါရ် ဧလိယ ပေါရောတ်ဒေက်ုရ်မိုန် ဇောမ်ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","အခိင်ဒီန် ပေတရုဒါႈဒေဂြည် တယေဆု၊ “အိူဝ် တာဆရာ၊ အရာပ်အီုဝ် ကျညှိုႈတဂွည် အတွအယ်။ ဒဲႈယဲရ်ုရ်ဘိူဝ် ကီုရ်ဟူပ်အွည်ကြောင် အတွမီ အူကြောင်၊ အတွမောရှေ အူကြောင်၊ အတွဧလိယ အူကြောင်။” ");
INSERT INTO pll_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ဘံန်ဂဲ ယောလူတ်လာည်၊ ပေတရု ကာနံပ်ပ်ုန်ဒါႈဒေ ပဲန်အ်ုန်ဒါႈညာခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","အခိင်ဒီန် ဆိုရ်အူတ်လှိူရ်ႈပေါ ကီုရ်မုအ်ုန်ဖလူမ်ဒိုည်ႇဂဲ၊ ငဲဂံရ်ႈလေႈ ဒိုရ်တဆိုရ်အူတ်ဒီန်ဒါႈ၊ “အ်ုန်အီုဝ် မိူဝ်ႈကွံန်ရံက်အော၊ ဒဲႈပဲဆတီုင် ငဲအ်ုန်အေ့။” ");
INSERT INTO pll_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ဘံန်ညာခိူည်ဒီန် ဂဲက်ုရ်ပံတ်ဒေငိူပ်ပွံတ် က်ုရ်ႎျံရ်ဒေ၊ ဆဲႈယေဆုအူကူ ဂွည်ရူမ်ဇောမ်ဂဲ၊ အဆေမိူဝ်ႈကာယိူဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ယာမ်ဂဲလေႈဒိုည်ႇဒေ ဒိုရ်တဆိုရ် ယေဆုပိင်ငျှံပ်အူန်ဂဲ၊ “ပဲမာည်လာ်ႈဂြည်တအဆေ ခိူည်ပ်ုန်ယိူဝ်ပဲငိူပ်ဒေဒိူည်အီုဝ် ကြိူည်ကွံန်ဘီအီုဝ် ႎီရ်ယိူဝ်ႇအီမ်ဒိုရ်ယံမ်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ဂဲဘိူည်ဇူဂံတ်ငဲ ပ်ုန်ပိင်ငျှံပ်အ်ုန် ဂဲလာည်က်ုရ်မိုန်က်ုရ်ဂြည်တဒေ၊ “ဆေမိူဝ်ႈ ခိူည်အကျံင်ဟွည်ႇယံမ် ႎီရ်ယိူဝ်ႇအီမ်ဒေဒီန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ဟွည်ႇဒီန် ဂဲဆ်ုရ်မွံတ်ယေဆု၊ “ကောပ်ဆေ တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ တဒါႈ ဧလိယ ဒီဘ်ုပ်ဒေ လာ်ႈရောတ်ပေါဇံဝ် ရအာတ်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ယေဆုႎီရ်ဒါႈ၊ “ဧလိယ လာ်ႈရောတ်ပေါဇံဝ်ရအာတ်ဒီန် မိူဝ်ႈအေ့ အတွရဲန်ဒေရ်ုရ်တွံန်နဲ။ က်ုန်ညာခိူည်ဒီန် ကွံန်ဘီအီုဝ် ဒီဘ်ုပ်ဒေခါမ်ဇာ ဒုခႎိူည်ဒနာဂါရ် ဒီဘ်ုပ်ဒေက်ုရ်တူႈထဲင် ဘီဂဲႎဲႈထေင်ဒေ၊ ကောည်လိုည် ဆေညာ တန်ုဘေဲႇကျံမ်တဲမ်အူန် ညာခိူည်ဒီန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“ကောည်လိုည် အောဂြည်ညှိုႈတပဲ ဧလိယ ဟွည်ႇရောတ်ယာ့်။ ခိူည်ပ်ုန်တဲမ်အူန် တန်ုပံပ်ဘေဲႇကျံမ် ဘီဂဲဒီန်မိူဝ်ႈ ဟွည်ႇရ်ုရ်ဒိုည်ႇ ပ်ုန်ဆ်ုန်ရ်ုရ်ဒေ တပါင်အ်ုန်ယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","အခိင်ဂဲရောတ်ဒေလာ်ႈက်ုရ်စု တရဂွည် တဘဲႇဟံရ်ဂဲ၊ ဂဲယိူဝ်ပဲတ်ဒေငိူပ် ဖုင်ဘီက်ုရ်စုဂဲ က်ုရ်ႎျံရ်ဒိုည်ႇပြော တဘဲႇဟံရ်ဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲပ်ုရ်ဒီ ဒါ့်က်ုရ်ထေင်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ဘံန်ဘီဂဲ ယိူဝ်ဒေငိူပ်ယေဆု ဂဲညာအာမ်၊ ဂဲခူန်ဒေလာ်ႈဇူ ငဲတက်ုရ်ယိူဝ်ပွံတ် တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ယေဆုဆ်ုရ်မွံတ် တဘဲႇဒေဂဲ၊ “အကျံင်ဆေ ပဲဒါ့်က်ုရ်ထေင် ဇောမ်ဂဲအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ယာမ်ဒီန် န်ုပါင်ဘီက်ုရ်စုဂဲ ယိူဝ်ဘီအူကူဒါႈ၊ “အိူဝ် တာဆရာ၊ အောဒိူည်လာ်ႈ ကွံန်ရလျံင် ကာခီုတ်ငဲအော တမီ ကီုရ်နံမ်ချှိုလီပ်စံပ် တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","တွံန်ကီုရ်နံမ်ချှိုဒီန် လီပ်စံပ်တအ်ုန်၊ အ်ုန်ဆမာ ပ်ုန်ဂေႈဆကြ်ုပ်ပဲတ်အ်ုန် တပါင်ကတဲ၊ ဟွည်ႇဒဲႈဘူရ်ႈလေႈ တမူရ်အ်ုန်၊ က်ုရ်ဂြီတ်ဟြာင်ဟောမ်ဒေ ဆမာပ်ုန်ခေါပဲတ်တိုအ်ုန်။ အောဘိူည်ဒါႈဂံတ်တ တဘဲႇမီဂဲ ရူပ်လေႈဒဲႈ ကီုရ်နံမ်ချှိုအီုဝ် ဂဲကာဘဲလိုည်ဒေရူပ်။” ");
INSERT INTO pll_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ကီုရ်ညာဒါႈတဂဲ၊ “အိူဝ် အမျိုကာယိူဝ်ဖိူမ်ညှိုမ်၊ ခိင်ခါဝ်ဘ်ုရ်မော အောဒီဘ်ုပ်အောဂွည်ရူမ်ထဲင်ဇောမ်ပဲ၊ ခိင်ခါဝ်ဘ်ုရ်မော အောဒီဘ်ုပ်ရျံတ်အောတပဲအဲႈ၊ ဒိူည်လာ်ႈကွံန်ရလျံင်ဒီန် တအော။” ");
INSERT INTO pll_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ဂဲဒိူည်လာ်ႈကွံန်ရလျံင်ဒီန် တယေဆု။ ဘံန်ကီုရ်နံမ်ချှိုဒီန် ယိူဝ်ဒေငိူပ်ယေဆု၊ အ်ုန်ပ်ုန်ခေါဟာ့်ပွံတ် ကွံန်ရလျံင်ဒီန် အူဒီန်တောအူဒီန်၊ အ်ုန်ဟွည်ႇပ်ုန်ဂေႈဆကြ်ုပ်ပဲတ် ကွံန်ရလျံင်ဒီန် တပါင်ကတဲ ဘူရ်လေႈပွံတ်တမူရ်အ်ုန်၊ ညာအီတ် က်ုရ်ပ္လူက်ုရ်ပ္လါႇပွံတ်တိုဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ယေဆု ဆ်ုရ်မွံတ် ကူန်ကွံန်ရလျံင်ဒီန်၊ “အ်ုန်ပဲန်ညာခိူည်အီုဝ် ဘ်ုရ်မောဟွည်ႇဇီုဝ့်အဲႈ။” ကူန်အ်ုန်ဒါႈ၊ “အ်ုန်ပဲန် ညာခိူည်အီုဝ် အိုရ်ယာမ်အ်ုန်ဒျံတ်ဒျံတ်။” ");
INSERT INTO pll_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ကီုရ်နံမ်ချှိုအီုဝ် ဆ်ုန်ဒဲႈအ်ုန်ယံမ် ပ်ုန်ဂေႈဆကြ်ုပ်အ်ုန် တပါင်ငံရ်၊ တရန်ုအိုမ် က်ုရ်စံပ်က်ုရ်ဘာ၊ ကောည်လိုည် မီက်ုန်ဘဲ က်ုရ်ႎေဇောည်ဘိူဝ်ယဲစိ။” ");
INSERT INTO pll_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ယေဆုဒါႈတအ်ုန်၊ “ဆေညာ မီနံပ်ဒေဒါႈတအော မီက်ုန်ဘဲဒီန်၊ အတွဘီအ်ုန်ယိူဝ်ဖိူမ်ညှိုမ်အီုဝ် ဘိူန်ပဲန်တွံန်နဲ။” ");
INSERT INTO pll_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ကူန်ကွံန်ရလျံင်ဒီန် ပြိုႈရျံင်ဒေဒါႈ အူဒီန်တောအူဒီန်၊ “အောညှိုမ်အေ့၊ မစဘိူဝ်အောစိ ဒဲႈအောဘိုန်ပဲတ် ဖိူမ်ကာညှိုမ်အောအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ဘံန်ယေဆု ယိူဝ်ဒေငိူပ် ဖုင်ဘီက်ုရ်စုဂဲ ခူန်လာ်ႈဇူဒေ အ်ုန်ပိင်ငျှံပ်ဆုင်မ ဒဲႈဆဒိ တကီုရ်နံမ်ကာကျကာလဒီန်၊ “အိူဝ် ကီုရ်နံမ်ချှိုဟျာ့်ဇံန်ကာခီုတ်ငဲ၊ အောဒဲႈငဲအမိင်တမီ၊ လေႈပွံတ်မီ ဒိုရ်တို ကွံန်ကညောမ်ဒီန်၊ မီမည်ဂွည်ႇလီပ်ယာ့်ထဲင် ရန်ုအ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","အခိင်ဒီန် ကီုရ်နံမ်ချှိုပီ ပည်ပြိုႈဒေရျံင်၊ ဘံန်အ်ုန်ဟွည်ႇဒဲႈ ကွံန်ရလျံင်ဒီန် တကြိုတ် လေႈပွံတ်ဒေဒိုရ်တိုအ်ုန်၊ အ်ုန်ပဲန်ပွံတ် ညာခိူည်တိုဘီယံမ်၊ ဘီတွံန်ကူဂဲ ဒါႈဒိုည်ႇ၊ “အ်ုန်ယံမ်ယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ကောည်လိုည် ယေဆု ဘာပွံတ်တီ ကွံန်ရလျံင်ဒီန် ပျိူဝ်ႇယိူဝ်ႇပွံတ်တိုအ်ုန် အ်ုန်မိူဝ်ႈယိူဝ်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ဟွည်ႇဒီန် ယေဆု လီပ်ပွံတ်ဒေ ရန်ုဂါင်၊ တဘဲႇအ်ုန်ဂဲ က်ုရ်ရာတ်က်ုရ်မောဒေ ဆ်ုရ်မွံတ်အ်ုန်၊ “ကောပ်ဆေ ယဲကာဘဲယဲ ရူပ်လေႈပဲတ် ကီုရ်နံမ်ချှိုဒီန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ယေဆုႎီရ်ဒါႈ၊ “ခိူည်ကီုရ်နံမ်ချှိုအီုဝ် ဆဲႈဆုတောင်အူနဲ ကာဘဲစိ ရူပ်လေႈအ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ လေႈဒိုရ်အရာပ်ဒီန် ဂဲက်ုရ်ခါမ်လာ်ႈပွံတ် တကပီုန်ကုင်ဂါလိလဲ။ ကောည်လိုည် ယေဆု ကာဆ်ုန်ဒဲႈအဆေနံပ် ဒေရောတ်က်ုရ်တောဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ကောပ်ဆေတဒါႈခိူည်ဒီန် အ်ုန်ဆာင်ဆောန်ဒဲႈ တတဘဲႇဒေဂဲ၊ “ကွံန်ဘီအီုဝ် ဒီဘ်ုပ်က်ုရ်တူႈအာပ် တတီဘီဂဲယာ့်၊ ဂဲဒီပျံမ်ယံမ်ပဲတ်အ်ုန်။ ကောည်လိုည် က်ုန်ဟွည်ႇဘိူန်အွည်ဆငီ အ်ုန်ဒီႎီရ်ယိူဝ်ႇအီမ်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","တဘဲႇအ်ုန်ဂဲ ဘိူည်ကာနံပ်ဂံတ် ငဲပ်ုန်ဂြည်အ်ုန်၊ ဂဲကာယာႇပဲတ် ဆ်ုရ်မွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ဟွည်ႇဒီန် ဂဲရောတ်ဒိုည်ႇ တကုင်ကပေရနောင်၊ ယာမ်ဂဲဂွည်တရန်ုဂါင် ယေဆုဆ်ုရ်မွံတ် တဘဲႇဒေဂဲ၊ “ယာမ်ပဲလာ်ႈတရဒေင် အကျံင်ဆေ ပဲဒါ့် က်ုရ်ထေင်ဒေဂြည်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ကောည်လိုည် ဂဲကာႎီရ်ဒါႈယာ့်ဆံင်မှာ်ႈ ဂွည်ညီမ်ညီမ်ပွံတ်ဒေ၊ ကောပ်ဆေတဒါႈခိူည်ဒီန် ယာမ်ဂဲလာ်ႈတရဒေင် ဂဲမေန်ဟွည်ႇက်ုရ်ထေင် အကျံင်အဆေမိူဝ်ႈညှိုႈ အီမျြံတ်ဒါင်။ ");
INSERT INTO pll_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","အခိင်ဒီန် ယေဆုဒါ့်မာ့်ဒေ၊ အ်ုန်တောႇပွံတ် တဘဲႇဒေကိူရ်အာရ်ကူ ဒါႈတဂဲ၊ “အဆေမိူဝ်ႈဟွည်ႇ က်ုန်ဆ်ုန်ပဲန်ဘီဇူႈအူ ဒီဘ်ုပ်ရောတ်ဘိူဝ်ရဘံန် ဘ်ုပ်ပဲန် မှာည်ဘီဒိုည်ႇဒိုည်ႇ။” ");
INSERT INTO pll_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ဟွည်ႇဒီန် အ်ုန်တောႇပွံတ် ကွံန်ကညောမ်ဒျံတ်အူကူ ဒဲႈအ်ုန်ဇံင်ဒေ တက်ုန်ဒီဂဲ။ ဇာ့်ပွံတ်အ်ုန် တပေါႇတီဒေ ဒါႈတဂဲ၊ ");
INSERT INTO pll_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ကောပ်ဇီုဝ်အော အီအ်ုန်ရံပ်အူန် ကွံန်ကညောမ်ဒျံတ်ဂဲ အူကူအူဆိူဝ်အီုဝ် မိူဝ်ႈဂဲရံပ်အူန်အောယာ့်။ အီအ်ုန် ရံပ်အူန်အောဒီန် ကာမိူဝ်ႈစိဂဲ ရံပ်အူန်ဂိူဝ်အောအူကူ၊ မိူဝ်ႈဂဲရံပ်အူန်ပါည် အီအ်ုန်ပ္လေါည်လေႈအော။ ");
INSERT INTO pll_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ယောဟန်ဒါႈတအ်ုန်၊ “အိူဝ် တာဆရာ၊ ယဲယိူဝ်ယဲငိူပ် အီအူကူ ဒါဇီုဝ်မီရူပ်လေႈပဲတ် ကီုရ်နံမ်ချှို၊ ကောပ်အ်ုန် ကာမိူဝ်ႈဘီဇောမ်ယဲ ယဲခြဲအေ့ယဲဒိူည်အ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ယေဆုဒါႈတဂဲ၊ “ပဲမာည်ခြဲအ်ုန်၊ ကောပ်ဆေတဒါႈခိူည်ဒီန် အကျံင်အ်ုန်ဒါဇီုဝ်အော ဟွည်ႇပျ ဖုင်တီုင်ဂိုလက္ခဏာဒီန် ကာဇီုဝ့် အဆေမိူဝ်ႈ ကာယာႇယာ့် ငဲပ်ုန်ဘဝ်တအော။” ");
INSERT INTO pll_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","အီအ်ုန်ကာက်ုရ်ခံတ် ဇောမ်အယ် မိူဝ်ႈဘီလ်ုပ်အယ်ယာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","အောဂြည်ညှိုႈတပဲ၊ ကောပ်ပဲမိူဝ်ႈတဘဲႇအော အီအ်ုန်ဒဲႈပဲတျံင်အိုမ် အူဆလောႇ ဒီဘ်ုပ်ဘိူန်ညှိုႈ အကျိုကေစူအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“အီအ်ုန်ဒဲႈ တန်ုကညောမ်ညှိုမ်အော အူကူအူကူ ရ်ုရ်ပဲန်အပေတ်ဒီန်၊ အီကူဒီန် ဟောည်မိုပံရ်ဒါင် တရမောင်အ်ုန် က်ုန်ဘ်ုပ်ဒေခါမ် ပျာ်ႈလေႈ တန်ုအိုမ်ပါင်လာည် အတွအ်ုန်ႎရကျ။ ");
INSERT INTO pll_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","တီမီဒီန် က်ုန်ဒဲႈဖိူမ်ပ်ုန်ညှိုမ်မီ ပဲန်က်ုရ်လူတ် က္လပဲတ်အ်ုန်၊ လဒိုရ် မီဒိူည်တီဒေအာရ်ခေါန် လီပ်တရန်ုငံရ်ရာည် ကာနံပ်ဒေယံတ်၊ က်ုန်ဒါတီအူခေါန် လီပ်ဂွည် တန်ုအဆာႇအီမ် အတွမီႎရကျ။ ");
INSERT INTO pll_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ဇိူင်မီဒီန် က်ုန်ဒဲႈဖိူမ်ပ်ုန်ညှိုမ်မီ ပဲန်က်ုရ်လူတ် က္လပဲတ်အ်ုန်၊ လဒိုရ် မီဒိူည်ဇိူင်ဒေအာရ်ခေါန် လီပ်တရန်ုငံရ်ရာည် ကာနံပ်ဒေယံတ် က်ုန်ဒါဇိူင်အူခေါန် လီပ်ဂွည် တန်ုအဆာႇအီမ် အတွမီႎရကျ။ ");
INSERT INTO pll_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ပ္လေငါည်မီဒီန် က်ုန်ဒဲႈဖိူမ်ပ်ုန်ညှိုမ်မီ ပဲန်က်ုရ်လူတ် စာ့်လေႈပဲတ်အ်ုန်၊ လဒိုရ် မီဒိူည်ပ္လေငါည်ဒေ အာရ်ခေါန် လီပ်တငံရ်ရာည် ကာနံပ်ဒေယံတ် က်ုန်ဒါပ္လေငါည်အူခေါန် လီပ်ဂွည်တရန်ု ကပီုန်ကုင်ဖြာ အတွမီႎရကျ။ ");
INSERT INTO pll_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","တအရာပ်ဒီန် ‘ႎါႇဘြဲ့ဆမာဂဒေဟောမ်မိူဝ်ႈ ကာနံပ်ဒေယံမ်၊ ငံရ်ရလာရ်ႈမိူဝ်ႈ ကာနံပ်ဒေယံတ်။’ ” ");
INSERT INTO pll_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ညာခိူည်ဒါဆောႇ ဒဲႈတိုယဇ်ဆပဲ၊ ဘီတွံန်ကူအီုဝ် ဒီဘ်ုပ်ဒေက်ုရ်တူႈ ဒါငံရ် ဒဲႈတိုအ်ုန်ဆပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ဆောႇဒီန်ကျအေ့။ ကောည်လိုည် ဆောႇအီုဝ် က်ုန်ကာယိူဝ်စဲမ် ခိူည်မောပဲညာဒေ ႎီရ်ဘဲဒေဘိူန်ထဲင် အိုမ်ဆငဲႈအ်ုန်အဲႈ။ “ဒဲႈတတိုပဲဒီန် ယိူဝ်ဆောႇ၊ ပဲလိုက်ုရ်ရံက်ဒေ အူကူတောအူကူ ဂွည်ရူမ်ရူမ်ရာႈရာႈအေ့” အ်ုန်ဒါႈတဂဲခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ယေဆု ဟွည်ႇယိူဝ်ႇဒိုရ်အရာပ်ဒီန်၊ ႎက်ုရ်ခါမ်လာ်ႈ အိုမ်ယော်ဒန် ရောတ်ပွံတ်ဒေ ဆဲႈပြာအိုမ်လ်ုပ်တည် တကပီုန်ကုင်ယုဒ၊ ဖုင်ဘီက်ုရ်စုဂဲ ႎီရ်လာ်ႈက်ုရ်စုဒိုည်ႇထဲင်ဒေ တအ်ုန်၊ အ်ုန်ဆာင်ဆောန်ဒဲႈတဂဲ ခိူည်ပ်ုန်ကျာင်ရ်ုရ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ဘံန်ဖာရိရှဲဂဲပ်ုရ်ဒီ ဆ်ုန်စာမ်အ်ုန် ဂဲလာ်ႈဇူ ဆ်ုရ်မွံတ်ဒါႈ၊ “ဂြည်ဘိူဝ်တယဲ၊ အီမဲအူကူအူကူ က်ုန်က်ုရ်ပဲတ်ဇောမ် ပ်ုန်လဲဒေ က်ုရ်ဖြေင်ကော ဇောမ်ဥပဒေအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ယေဆု ႎီရ်ဆ်ုရ်မွံတ်ဂဲ၊ “ခိူည်မော မောရှေဒါႈဒေ ပိင်ငျှံပ်အူန်တပဲအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ဂဲဒီန်ႎီရ်ဒါႈ၊ “မောရှေ ဒဲႈအူန်အခွါင်တယဲ က်ုန်ဆ်ုန်က်ုရ်ပဲတ်ဇောမ် ပ်ုန်လဲဒေ လိုတဲမ်ဒါဘေဲႇက်ုရ်ကာႈ ဒီဘိူန်က်ုရ်ပဲတ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ယေဆု ဒါႈတဂဲ၊ “ကောပ်မိူဝ်ႈပဲ နွံရ်ႈဖိူမ်ခေါ ဆောန်ကျူ မောရှေဘ်ုပ်ဒေတဲမ်အူန်ပိင်ငျှံပ်အီုဝ် အတွပဲ။ ");
INSERT INTO pll_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ကောည်လိုည် တန်ုဘေဲႇကျံမ်ဒါႈ၊ ‘အိုရ်ယာမ်ဖြာ စဒေဖာန်ဇာမ် ရ်ုရ်ပဲန်အီမဲဂါရ် အီပ်ုန်။’ ");
INSERT INTO pll_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ကောပ်မိူဝ်ႈခိူည်ဒီန် အီမဲဂဲအီုဝ် ဒီပဲတ်ပဲတ် ကူန်မာဒေ လာ်ႈဂွည်ရူမ် ဇောမ်ပ်ုန်လဲဒေ၊ ");
INSERT INTO pll_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ဂါရ်ဒီန်အာရ်ကူမိူဝ်ႈ ပဲန်ပွံတ်ဒေ အူယီုင်အူနှာမ်။ ကောပ်ခိူည်ဒီန် ဂါရ်ကာမိူဝ်ႈယာ့်အာရ်ကူ ပဲန်ပွံတ်အူကူ။ ");
INSERT INTO pll_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ကောပ်ခိူည်ဒီန် မာည်ဒဲႈ ဘီဂဲက်ုရ်ကာႈ က္လံင်ရကွံတ် ပ်ုန်တာင်က်ုရ်ပိုမ် ဖြာအေ့။” ");
INSERT INTO pll_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ယာမ်တဘဲႇအ်ုန်ဂဲ ဂွည်ဒေတရန်ုဂါင် ဂဲႎီရ်ဆ်ုရ်မွံတ် ခိူည်အကျံင်ဒီန် တယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","အ်ုန်ဒါႈတဂဲ၊ “အီမဲအူကူအီုဝ် က်ုန်က်ုရ်ပဲတ်ဇောမ်ပ်ုန်လဲဒေ ႎီရ်လာ်ႈခံတ်ထဲင်ဒေ ဇောမ်အီပ်ုန်ဟံရ်၊ မိူဝ်ႈအ်ုန်ဖေါက်ပျန် တရမာဒေယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“စံမ်ညာခိူည်ဒီန် အီပ်ုန်အူကူအီုဝ် က်ုန်က်ုရ်ပဲတ်ဇောမ်ရလေႈဒေ ႎီရ်လာ်ႈလေႈထဲင်ဒေ တအီမဲဟံရ်၊ မိူဝ်ႈအ်ုန်ဖေါက်ပျန် တရမာဒေယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","အခိင်ဒီန် ဘီဂဲပ်ုရ်ဒီ တောႇဒေဒိူည်လာ်ႈ ကွံန်ကညောမ်ဂဲ တယေဆု၊ အတွဂဲဆ်ုန်ဒဲႈ ယေဆု ဂံမ်တီဒေ ဟိုင်ဒဲႈကျဒဲႈလ တပါင်ဂဲ။ ကောည်လိုည် တဘဲႇအ်ုန်ဂဲ ဟီုတ်ပွံတ် ဘီဂဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ဘံန်ယေဆု ယိူဝ်ဒေငိူပ်ခိူည်ဒီန် ဒေါဆအ်ုန်လေႈ တတဘဲႇဒေဂဲ အ်ုန်ဒါႈ၊ “ပဲတ် ကွံန်ကညောမ်ဂဲ လာ်ႈဇူအော၊ ပဲမာည်ထိင် မာည်ခြဲဂဲ၊ ကပီုန်ကုင်ဖြာအီုဝ် မိူဝ်ႈအတွ ညာခိူည် ကွံန်ကညောမ်ဂဲအီုဝ်ယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“အောဂြည်ညှိုႈတပဲ၊ အီအ်ုန်ကာရံပ် ကပီုန်ကုင်ဖြာ ညာခိူည် ကွံန်ကညောမ်အူကူ၊ ယာမ်မောမိူဝ်ႈ အ်ုန်ကာဘိူန်စိဒေလီပ် ကပီုန်ကုင်ဖြာ။” ");
INSERT INTO pll_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ဟွည်ႇဒီန် အ်ုန်တိူဝ်ႈဒေဇာ့်ပွံတ် ကွံန်ကညောမ်ဂဲ တပေါႇယာႇဒေ ဟိုင်ဒဲႈကျဒဲႈလပွံတ် တဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ယာမ်ယေဆု စွလာ်ႈတရဒေင် ဘီအူကူ ခူန်ဒေလာ်ႈမာ့်ပ်ုရ်ဒ်ုပ်ပွံတ် တရအာတ်အ်ုန်၊ အ်ုန်ဒါႈ၊ “အိူဝ် တာဆရာကျမျြံတ်၊ ခိူည်မောအောလိုရ်ုရ် အတွဘိူန် အဆာႇထာဝရ။” ");
INSERT INTO pll_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ယေဆုဒါႈတအ်ုန်၊ “ဆေညာ မီတောႇအောမိူဝ်ႈ ဘီကျမျြံတ်။ ဆဲႈဖြာအူပါ အူကူမိူဝ်ႈကာယိူဝ်စိ ဘီကျမျြံတ်။ ");
INSERT INTO pll_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","မီနံပ်အေ့ ပိင်ငျှံပ်ကာမိူဝ်ႈ၊ ‘မာည်ကဝ်ရမာဘီ၊ မာည်ပျံမ်အဆာႇဘီ၊ မာည်ရာတ်ဂြူအုဇာဘီ၊ မာည်ခါမ် ဆာ့်ဆေကာမှာန်၊ မာည်လာလီတိူဝ်ႈဆီမ်အူန် အုဇာဘီ၊ ဒဲႈပဲရိုဆေ ကူန်မာဒေအေ့။’” ");
INSERT INTO pll_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","အီကူဒီန်ဒါႈ၊ “အိူဝ် တာဆရာ၊ ပိင်ငျှံပ် ပ်ုန်ဒါႈမီဒိုည်ႇဒိုည်ႇဒီန် အောဟွည်ႇထိင်အူန်အောဒိူည် အိုရ်ယာမ်အောဒျံတ်ဒျံတ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ယေဆု ပ်ုန်ရိူဝ်ငိူပ်ပွံတ်အ်ုန် ယိူဝ်ဖိူမ်ရံက်က်ုရ်ႎေ ဒါႈတအ်ုန်၊ “တမီဒီန် လိုဂိူဝ်အူနဲ။ လာ်ႈ၊ မီက်ုန်ဟွည်ႇယံင်ပဲတ် ဘ်ုရ်ယိူဝ်အုဇာဒေ စာဂဒဲႈဒိုည်ႇတဘီဖ္လာန်ဂဲ။ က်ုန်ညာခိူည်ဒီန် မီဒီဘိူန်အုဇာဘဏ္ဍာ တန်ုပ္လေင်အေ့၊ ဟွည်ႇဒီန် မီတဇောမ်လာ်ႈ ရဘံန်အော။” ");
INSERT INTO pll_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","အ်ုန်မေန်မိူဝ်ႈဘီခြ်ုမ်ဆာ အုဇာဂြူဂြိူမ်ဘ္လံမ် ဘံန်အ်ုန်ယိူဝ်ဒေဆတီုင် ငဲပ်ုန်ဒါႈအ်ုန်ဒီန် ငါည်အ်ုန်ငှဝ်နွံရ်ႈကာပျော လေႈလာ်ႈပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","အခိင်ဒီန် ယေဆုငိူပ်ပွံတ် က်ုရ်ႎျံရ်ဒေ အ်ုန်ဒါႈတတဘဲႇဒေဂဲ၊ “ဘီခြ်ုမ်ဆာဂဲအီုဝ် ကျူညှိုႈတလီပ် တန်ုကပီုန်ကုင်ဖြာ။” ");
INSERT INTO pll_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ဘံန်တဘဲႇအ်ုန်ဂဲ ယိူဝ်ဒေဆတီုင်ငဲဒီန်၊ ဂဲညာအာမ်ဒိုည်ႇပွံတ်ဒေ။ ကောည်လိုည် ယေဆု ႎီရ်ဒါႈထဲင်တဂဲ၊ “အိူဝ် ကွံန်အောပဲ၊ ကျူညှိုႈတလီပ် တန်ုကပီုန်ကုင် ဖြာအာ်။ ");
INSERT INTO pll_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ကလာအုအီုဝ် ငှိူည်ဘိူဝ်တပ္လီပ်လီပ် တန်ုဘီုင်ဟျာ့်ပ်ုန်လဲ့၊ က်ုန်မိူဝ်ႈ ဘီခြ်ုမ်ဆာဂဲအီုဝ် ကျူညှိုႈတလီပ် တန်ုကပီုန်ကုင် ဖြာ။” ");
INSERT INTO pll_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","အခိင်ဒီန် တဘဲႇအ်ုန်ဂဲညာအာမ်ပွံတ်ဒေ ဂဲက်ုရ်ဆ်ုရ်မွံတ်တဒေ အူကူတောအူကူ၊ “က်ုန်ဒါႈခိူည်ဒီန်၊ အဆေဒီဘိူန် ပ်ုန်လောတ်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ယေဆု ပ်ုန်ရိူဝ်ငိူပ်ပွံတ်ဂဲ အ်ုန်ဒါႈ၊ “အီအီုဝ် အတွဘီဂဲ ဘိူည်ကာဘဲဂံတ်ဒေပဲန် က်ုန်မိူဝ်ႈ အတွဖြာ ကာမိူဝ်ႈစိခိူည်ဒီန်၊ အတွဖြာ ဘဲဒေပဲန်ဒိုည်ႇတွံန်နဲ။” ");
INSERT INTO pll_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","အခိင်ဒီန် ပေတရု ဒါႈတအ်ုန်၊ “ငိူပ်ဘိူဝ်၊ ယဲပဲတ်ဒိုည်ႇပဲတ် ဘ်ုရ်ပ်ုန်ယိူဝ်ယဲ ဇောမ်လာ်ႈဒိုည်ႇရဘံန်မီယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ယေဆုဒါႈတဂဲ၊ “မိူဝ်ႈအေ့၊ အောဂြည်ညှိုႈတပဲ အဆေမိူဝ်ႈဟွည်ႇ ကောပ်အောဂါရ် ကောပ်ဆဒါင်ကျ က်ုန်ပဲတ် ဂါင်၊ နာ၊ ႎါႎည်၊ ႎါရပျာ၊ ကူန်မာ၊ ကွံန်၊ ႎါ ဘူရမာဒေ အူနဲအူနဲ၊” ");
INSERT INTO pll_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","အီကူဒီန် ခိူည်မိူဝ်ႈအကျိုပူန်အူပ်ုန်ယာႈ ဂါင်၊ နာ၊ ႎါရပျာ၊ ႎါည်အီမဲ၊ ကူန်မာ၊ ကွံန်ႎါဒေဂဲဂါရ် ဆဂေလာလီညာ ဒီဘ်ုပ်ဒေခါမ်ဇာ တန်ုဇာတ်အီုဝ်၊ အ်ုန်ဒီဘိူန် အဆာႇထာဝရ တဇာတ်ဘံန်။ ");
INSERT INTO pll_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“ကောည်လိုည် အီအ်ုန်ရောတ် လ်ုပ်ရအာတ်ဒီန် ဒီဘ်ုပ်ဒေရောတ် လ်ုပ်ရဘံန်၊ အီအ်ုန်ရောတ် လ်ုပ်ရဘံန်ဒီန် ဒီဘ်ုပ်ဒေရောတ် လ်ုပ်ရအာတ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ယာမ်ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ လာ်ႈဟာ့်ဇောမ်ဒေင် တကုင်ယေရုရှလင်၊ ယေဆု ပည်ပြိုႈဟိုရ်ဂြည် အွံရ်လာ်ႈ တဘဲႇဒေဂဲ၊ အီအ်ုန်လာ်ႈဇောမ်ရဘံန်ဂဲဒီန် ယောဒိုည်ႇပွံတ်ဒေ။ အခိင်ဒီန် ယေဆုႎီရ်တောႇထဲင် တဘဲႇကိူရ်အာရ်ကူ၊ အ်ုန်ဂြည်ပျတဂဲ ခိူည်မောဒီပဲန် တအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","အ်ုန်ဒါႈတဂဲ၊ “ဆတီုင်ဘိူဝ်၊ အယ်လာ်ႈ တကုင်ယေရုရှလင် အူဒီန်၊ ကွံန်ဘီအီုဝ် ဒီဘ်ုပ်က်ုရ်တူႈ အာပ်တတီ ယဇ်ပုရောဟိတ်ဒါင်ဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ။ ဂဲဒီန် ဒီပ်ုန်ဘဝ် ဟွည်ႇဂ်ုမ်တာမ်ယံမ်တအ်ုန်၊ အာပ်ဒဲႈပွံတ် တတီခြိူဝ်မျိုဟံရ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","“ခြိူဝ်မျိုဟံရ်ဂဲဒီန် ဒီပ်ုန်ဘဝ်၊ ဘဲႇအိုမ်ဘဲႇဒေတအ်ုန်၊ ဂဲဟွည်ႇဒဲႈတာမ်လ်ုရ်ႈ၊ ပျံမ်ယံမ်ပဲတ်အ်ုန်။ ကောည်လိုည် က်ုန်ဟွည်ႇဘိူန်အွည်ဆငီ အ်ုန်ဒီႎီရ်ယိူဝ်ႇအီမ်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","အခိင်ဒီန် ကွံန်အီမဲဇေဗေဒဲ ယာကုပ်ဂါရ် ယောဟန် လာ်ႈဇူ တယေဆု။ ဂါရ်ဒါႈတအ်ုန်၊ “အိူဝ် တာဆရာ၊ ယာရ်ဆ်ုန်ဒဲႈမီရ်ုရ်ဒဲႈ ဘ်ုရ်ပ်ုန်မှာန်ယာရ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ယေဆုဆ်ုရ်မွံတ်ဂါရ်၊ “ဆေပါရ်ဆ်ုန်ဒဲႈ အောရ်ုရ် အတွဒေ၊” ");
INSERT INTO pll_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ဂါရ်ဒီန် ႎီရ်ဒါႈတအ်ုန်၊ “အခိင်မီမာ့် တပါင်ရာဇပလာင်ဒေ တကပီုန်ကုင် ယိူဝ်အဖုင်တီုင်ဂို ဒဲႈယာရ်ဘိူန်အခွါင် မာ့်လ်ုပ်ခေါန်ညှိုႈမီအူကူ၊ လ်ုပ်ခေါန်ကာတ်မီအူကူ။” ");
INSERT INTO pll_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ယေဆု ဒါႈဒေဆ်ုရ်မွံတ်တဂါရ်၊ “ဆေပါရ်အာရ်ကူမှာန် ပါရ်ကာနံပ်။ ဆလော့ဒုခ ပ်ုန်ဒီတျံင်အော ပါရ်ဘဲကောဒေတျံင် က်ုန်ကာမိူဝ်ႈ ဗတ္တိဇံ ပ်ုန်ဒီဘ်ုပ်ခါမ်အောအီုဝ် ပါရ်ဘဲကောဒေခါမ်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ဂါရ်ႎီရ်ဒါႈတအ်ုန်၊ “ယာရ်ဘဲအေ့။” ယေဆုဒါႈတဂါရ် “ဆလော့ပ်ုန်တျံင်အော ပါရ်ဒီဘ်ုပ်တျံင်၊ ဗတ္တိဇံ ပ်ုန်ခါမ်အော ပါရ်ဒီဘ်ုပ်ခါမ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“ကောည်လိုည် လ်ုပ်တီခေါန်ညှိုႈအောဂါရ် လ်ုပ်တီခေါန်ကာတ်ဒီန် အောကာယိူဝ်စိ အခွါင်ရံရ်ႈဒဲႈ အဆေမာ့်။ က်ုန်မိူဝ်ႈအရာပ်ဒီန် ဖြာ ရဲန်အူန်ဂိူဝ် အတွဘီဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","အခိင်ဒီန် ဘံန်တဘဲႇဟံရ်အူကိူရ်ကူဂဲ ယိူဝ်ဒေဆတီုင် အကျံင်ဒီန် ဂဲရဝ်ဒိုည်ႇ တယောဟန်ဂါရ် ယာကုပ်။ ");
INSERT INTO pll_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ဘံန်ညာခိူည်ဒီန် ယေဆု တောႇဒိုည်ႇဒေဒါႈ တဂဲ၊ “ပဲဟွည်ႇနံပ်ဒိုည်ႇ၊ န်ုခြိူဝ်မျိုဟံရ်ဂဲ အီအ်ုန်ဘိူန်ဒေဘြောင် ကုင်အီုဝ် ဆမာဒါအာဏာဒေ အူပ်ဘြောင်ဆာင်ဒိုည်ႇ တပါင်ဘီကုင်ဘီရူဂဲ၊ အီအ်ုန်မိူဝ်ႈ ဘီအွရ်ကိင်ဂဲအီုဝ် ဆမာဒါအာဏာဒေ ရ်ုရ်ဒိုည်ႇတပါင်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ကောည်လိုည် က်ုန်မိူဝ်ႈတရန်ုပဲ ကာဘိူန်စိ ညာခိူည်ဒီန်။ တရန်ုပဲ အီအ်ုန်ဆ်ုန်ပဲန်ဘီအွံရ်ကိင်ဒီန် ဒီဘ်ုပ်ဒေပဲန်ဘိူဝ်မှာည်ပဲ။ ");
INSERT INTO pll_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","အီအ်ုန်ဆ်ုန်ပဲန် ဘီဇူႈအူအီုဝ် ဒီဘ်ုပ်ဒေပဲန် ဒိုည်ႇမှာည်ဘီ။ ");
INSERT INTO pll_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","အကျံင်အ်ုန်မိူဝ်ႈ ကွံန်ဘီအီုဝ် ကာမိူဝ်ႈစိ အ်ုန်လာ်ႈပေါ အတွဒဲႈဘီဂဲဟျံင်လူမ်လာဒေ၊ မိူဝ်ႈအတွရံရ်ႈအဆာႇဘီ ဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ လာ်ႈပေါဒေ စူန်အဆာႇဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ဂဲလာ်ႈရောတ်ဒိုည်ႇ တကုင်ယေရိခေါ၊ ဟွည်ႇဒီန် ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲဒိုည်ႇဒိုည်ႇ ပါပည်ဖုင်ဘီက်ုရ်စုဂဲ ယာမ်ဂဲလေႈရူမ်ဒိုည်ႇ ဒိုရ်ကုင်ယေရိခေါ၊ ယိူဝ်အီငါည်အံပ်အူကူ ဇီုဝ်ဗာတိမဲ၊ (အ်ုန်မိူဝ်ႈ၊ ကွံန်တီမဲ) ဒါ့်မာ့်မှာန်ဒေဟောမ် တပြောရဒေင်။ ");
INSERT INTO pll_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ဘံန်အ်ုန်ယိူဝ်ဒေဆတီုင် မိူဝ်ႈနာဇရက်ယေဆု၊ အ်ုန်ပြိုႈဒေဒါႈ၊ “အိူဝ် ကွံန်ဒါဝိဒ်၊ ယေဆု၊ က်ုရ်ႎေဘိူဝ်အောစိ။” ");
INSERT INTO pll_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ ဟီုတ်ပွံတ်အ်ုန် ဆူတ်အ်ုန်ဂွည်ညီမ်ညီမ်ဒေ။ ကောည်လိုည် အ်ုန်ႎရပြိုႈထဲင်ဒေဒါႈ၊ “အိူဝ် ကွံန်ဒါဝိဒ်၊ က်ုရ်ႎေဘိူဝ်အောစိ။” ");
INSERT INTO pll_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","အခိင်ဒီန် ယေဆု ဒါ့်ပွံတ်ဒေ၊ အ်ုန်ဒါႈ၊ “တောႇပဲဒိူည်အ်ုန်။” ဘံန်ညာခိူည်ဒီန် ဘီဂဲတောႇပွံတ်အီငါည်အံပ်ဒီန် ဂဲဒါႈတအ်ုန်၊ “မာည်အူန်ဖိူမ်ဒေဒျံတ်၊ ယိူဝ်ႇပွံတ်၊ အ်ုန်တောႇမီယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ဘံန်ညာခိူည်ဒီန် အ်ုန်ဘေည်ပဲတ် ဆဒေါဒါင်ဒေ၊ ယိူဝ်ႇစာ့်တဲႇလာ်ႈဇူပွံတ် ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ယေဆုဆ်ုရ်မွံတ်အ်ုန်၊ “ဆေမီဆ်ုန်ဒဲႈ အောရ်ုရ် တဒေအဲႈ။” အီငါည်အံပ်ဒီန်ဒါႈ၊ “အိူဝ် တာဆရာ၊ အောဆ်ုန်ႎီရ်ယိူဝ်ထဲင်အောငိူပ်။” ");
INSERT INTO pll_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ယေဆုဒါႈတအ်ုန်၊ “လာ်ႈပွံတ်၊ ဖိူမ်ပ်ုန်ညှိုမ်မီဒီန် ဒဲႈမီချံမ်ဆာယာ့်။” ဒံင်အူကပြေ့ ငါည်အ်ုန်ႎီရ်ယိူဝ်ပွံတ်ဒေငိူပ်၊ ဟွည်ႇဒီန် အ်ုန်ဇောမ်ပွံတ် ရဘံန်ဒေင်လာ်ႈ ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ဂဲလာ်ႈဒံတ်ပွံတ် တကုင်ယေရုရှလင်၊ အခိင်ဂဲလာ်ႈရောတ်ဒိုည်ႇ တဇိူင်ဆိုရ်တာန်လူန် ကုင်ရူဗက်ဖာဂေဂါရ် ရူဗေသနိ၊ ယေဆု ပ္လေါည်လာ်ႈပွံတ် တဘဲႇဒေဂါရ်အာရ်ကူ ရအာတ်။ ");
INSERT INTO pll_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","အ်ုန်ဒါႈဒေတံမ်ငဲ တဂါရ်၊ “လာ်ႈပွံတ် တန်ုရူ ရအာတ်ပါရ်။ ပါရ်က်ုန်လီပ်တန်ုရူဒီန် ပါရ်ဒီယိူဝ်ဒေငိူပ် အဆေမိူဝ်ႈ ကာတိူမ်ဘလီအူတို ဂဲတုအူန်အ်ုန် က်ုရ်တောဒီန်။ ကာႈႎံရ်လီဒီန် တိူဝ်ႈပွံတ်ပါရ်ဒိူည်အေ့။ ");
INSERT INTO pll_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ဘီအူကူကူ က်ုန်ဆ်ုရ်မွံတ်ပါရ်၊ ‘ကောပ်ဆေ ပါရ်ရ်ုရ်ခိူည်အီုဝ်’ ပါရ်ဒီႎီရ်ဒါႈ တအ်ုန်၊ ‘တာဆရာ ဆ်ုန်ဘိူန်၊ က်ုန်ဟွည်ႇ ယာရ်ဒီႎီရ်တိုန်အ်ုန် က်ုရ်တောအီုဝ် အူဒီန်တောအူဒီန်အေ့။’” ");
INSERT INTO pll_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ကောပ်ခိူည်ဒီန် ဂါရ်လေႈလာ်ႈပွံတ်ဒေ၊ ဘံန်ဂါရ်ယိူဝ်ဒေငိူပ် ဘီတုအူန်လီအူတို တဘာင်ဘိုႈရိူဝ့်ဂါင် ပြောဒေင် ဂါရ်ကာႈပွံတ်ႎံရ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","အခိင်ဒီန် ဘီပ်ုရ်ဒီ ဒါ့်ဇံင်ငိူပ်က်ုရ်တောဒီန် ဆ်ုရ်မွံတ်ဂါရ်၊ “ဆေပါရ်ကာႈဒေညာ ႎံရ်လီဒီန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ဂါရ်ႎီရ်ဒါႈပွံတ်တဂဲ ခိူည်ငဲပ်ုန်တံမ်အူန် ယေဆုတဒေ၊ ဘီဂဲဒီန်မိူဝ်ႈ ဒဲႈပွံတ်အခွါင် တဂါရ်။ ");
INSERT INTO pll_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ဘံန်ဂါရ် တီုတ်ဒံရ်လာ်ႈ ပွံတ်ဒေဒိူည် လီဒီန် တယေဆု၊ ဂဲပ္လါရ်ႈပွံတ် ဆဒေါလှိူင်ဒေ တပါင်ကြောင်လီ ဒဲႈပွံတ်ယေဆုဘ။ ");
INSERT INTO pll_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ ပ္လါရ်ႈဒိုည်ႇဂြူဒေ တပါင်ရဒေင်။ ပ်ုရ်ဒီဂဲ က္လႇဒေဒိူည် ကာႇလှာဟေလှာယူပ် ပ္လါရ်ႈပွံတ် တပါင်ရဒေင်။ ");
INSERT INTO pll_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","အီအ်ုန်ဇောမ်လာ်ႈ ရအာတ်၊ ရဘံန်ဂဲဒီန် ပြိုႈဒေဒါႈ၊ “ဟောရှဏ္ဏ၊ ဒဲႈဖြာ ဟိုင်ဒဲႈကျဒဲႈလ တအီအ်ုန်စွလေႈ တဇီုဝ် ကီုရ်ညာဖြာအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“ကူန်အယ် ခူန်ဟောခံမ်ဒါဝိဒ် ဒီရောတ်ဒေတဲ ကပီုန်ကုင်အီုဝ် ဒဲႈယိူဝ်မံင်ဂလာ၊ တအရာပ်မျြံတ်ဇာရ် ဒဲႈပဲန်ဟောရှဏ္ဏ။” ");
INSERT INTO pll_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ယေဆု လီပ်ပွံတ်ရန်ုကုင်ယေရုရှလင် စွလာ်ႈ တကျောင်ဗိမာန်၊ အ်ုန်က်ုရ်ပံန်ဒေငိူပ်ပွံတ် က်ုရ်ႎျံရ်တွံန်တီ။ ဘံန်ရောတ်အခိင်ရမှိူဝ် အ်ုန်လာ်ႈရူမ် ဇောမ်တဘဲႇဒေ ကိူရ်အာရ်ကူဂဲ တရူဗေသနိ။ ");
INSERT INTO pll_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ဆငီရဘံန်၊ ယာမ်ဂဲႎီရ်ႎေင် ဒိုရ်ရူဗေသနိ ယေဆု က်ုန်ဘြာန်ပ်ုန်ဟောမ်။ ");
INSERT INTO pll_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ဘံန်အ်ုန်ယိူဝ်ဒေငိူပ် တီုင်ပ္လေပ္လေါႇအူတီုင်လှာက္လ်ုမ် အိုရ်အရာပ်ဆငါည် အ်ုန်လဲမ်ပ္လေကာယိူဝ်။ ကောည်လိုည် ကောပ်ကာမိူဝ်ႈ အခိင်ဟောမ်ပ္လေ ယိူဝ်ဂိူဝ်လှာအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ယေဆုဒါႈ တတီုင်ပ္လေပ္လေါႇဒီန်၊ “စမံင်အူဒီန်အီုဝ် ယာမ်မောမိူဝ်ႈ မည်ဒဲႈဘီဘိူန်ထဲင် ဒေဟောမ်ပ္လေပ္လေါႇ တတီုင်မီဒီန်။” တဘဲႇအ်ုန်ဂဲဒီန် ယိူဝ်ဒိုည်ႇဒေဆတီုင် ငဲပ်ုန်ဒါႈအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","အခိင်ဂဲရောတ် တကုင်ယေရုရှလင်၊ ယေဆု လီပ်ပွံတ်ဒေ န်ုကျောင်ဗိမာန်၊ အ်ုန်ရူပ်လေႈဒိုည်ႇပဲတ် ဘီက်ုရ်ဇိူရ်ႈက်ုရ်ယံင်ဂဲ။ ဟွည်ႇဒီန် အ်ုန်ကြူန်ရႎိူဝ်ႈဒိုည်ႇပဲတ် ခုင်ပွည်ဇာက်ုရ်လှာည်ရိူန်ဂဲဂါရ် ခုင်ရမာ့်ဘီယံင်ဆီမ်ကာႇကဲဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ဆဲႈဒီန်အဆေမိူဝ်ႈဟွည်ႇ အ်ုန်ကာဒဲႈစိအခွါင် ဒေါဒေဒိူည်ကူမ် ႎက်ုရ်ခါမ် တကျောင်ဗိမာန်။ ");
INSERT INTO pll_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ဟွည်ႇဒီန် အ်ုန်ဒါႈဒေဆာင်ဆောန် ဘီဂဲ၊ “တန်ုဘေဲႇကျံမ် တဲမ်အူန် ဖြာဒါႈ၊ ‘ကျောင်ဗိမာန်အီုဝ် ဒီဘ်ုပ်တောႇ ဒဲႈအ်ုန်မိူဝ်ႈဂါင် ဟာရဆုတောင် အတွဘီတွံန်မျို။’ ကောည်လိုည် ပဲဒဲႈပဲတ် ဂါင်အီုဝ်ပဲန် အတွရမောဘီစိုန်ဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ဘံန်ယဇ်ပုရောဟိတ်ဒါင်ဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ ယိူဝ်ဒေဆတီုင်အကျံင်ဒီန်၊ ဂဲလဲမ်ဒေင်လာ့်လာည် ဒဲႈဘိူန်ဒေပျံမ်ယံမ်ယေဆု။ ကောပ်ဖုင်ဘီက်ုရ်စုဂဲ အာမ်ဒိုည်ႇ တငဲပ်ုန်ဆာင်ဆောန်အ်ုန် ဂဲယောဒိုည်ႇဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ဘံန်ရောတ်စူန်မှိူဝ်၊ ယေဆုဂါရ် တဘဲႇအ်ုန်ဂဲ လေႈပွံတ်ဒေဒိုရ်ကုင်။ ");
INSERT INTO pll_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","အခိင်ရႎါရ်ႈဇံဝ်ဇံဝ် ယာမ်ဂဲလာ်ႈ တရဒေင်၊ ဂဲယိူဝ်ဒေငိူပ် တီုင်ပ္လေပ္လေါႇဟောင် အိုရ်တရျံရ်ႈဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ဘံန်ပေတရု နွံရ်ႈလှူႈ ဆေအ်ုန်ပဲန်ဒေဒိူည် အ်ုန်ဒါႈတယေဆု၊ “ငိူပ်မေန်၊ တာဆရာ တီုင်ပ္လေပ္လေါႇ ပ်ုန်ကီန်တိူင်မီအီုဝ် ဟောင်ဟျံတ်ပွံတ်ဒေယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ယေဆု ႎီရ်ဒါႈတဂဲ၊ “ဒဲႈပဲညှိုမ်ဖြာ။ ");
INSERT INTO pll_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","အောဂြည်ညှိုႈတပဲ အဆေမိူဝ်ႈဟွည်ႇ ကာယိူဝ် ဖိူမ်ကာဆာင်ခါ တန်ုဖိူမ်ဒေ က်ုန်ဒါႈတဆိူရ်၊ ‘က်ုရ်ခြါည်မီ လာ်ႈဇာ်ႈပွံတ် တန်ုအိုမ်ပါင်လာည်’ က်ုန်ညှိုမ်တငဲပ်ုန်ဒါႈဒေ ဒီပဲန်ပွံတ် ခိူည်ပ်ုန်ဒါႈအ်ုန်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ကောပ်ခိူည်ဒီန် အောဆ်ုန်ဂြည်တပဲ၊ အခိင်ပဲဆုတောင် က်ုန်မှာန်အူနဲအူနဲ ဒဲႈပဲညှိုမ်ဒေ ရံပ်တိူဝ်ႈညှိုႈ ခံင်ပ်ုန်မှာန်ပဲ၊ အ်ုန်ဒီဒဲႈ ဘ်ုရ်မှာန်ပဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","အခိင်ပဲဒါ့်ဇံင်ဆုတောင် က်ုန်ယိူဝ်ပ်ုန်တာင်အပေတ် တပါင်ဘီအူကူ အူနဲအူနဲ ပ္လိုတ်ခွါင်ဒဲႈဒိုည်ႇတအ်ုန်အေ့။ က်ုန်ညာခိူည်ဒီန် ကူန်ပဲဂွည်တပ္လေင် ဒီပ္လိုတ်ခွါင်ဒဲႈ အပေတ်ပ်ုန်လူတ်ပဲအေ့။” ");
INSERT INTO pll_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ဟွည်ႇဒီန် ဂဲႎီရ်ရောတ်ဒိုည်ႇ တကုင်ယေရုရှလင်။ ယာမ်ယေဆု လာ်ႈ တန်ုကျောင်ဗိမာန်၊ ယဇ်ပုရောဟိတ်ဒါင်၊ တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲဂါရ် ဘီအဆာႇဒါင်ဝါဒါင်ဂဲ လာ်ႈဇူဒိုည်ႇတအ်ုန်၊ ");
INSERT INTO pll_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ဂဲဆ်ုရ်မွံတ်အ်ုန်၊ “ခိူည်အမူအီုဝ် မီဒါအခွါင်အာဏာ အဆေရ်ုရ်၊ အဆေဒဲႈ အခွါင်တမီ ရ်ုရ်အမူအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ယေဆု ႎီရ်ဒါႈတဂဲ၊ “အောဆ်ုရ်မွံတ်ဘိူဝ်ပဲ အူနဲ၊ ဒဲႈပဲႎီရ်ဂြည်၊ ပဲက်ုန်ဟွည်ႇဂြည် ပ်ုန်ဆ်ုရ်မွံတ်အော အောဒီႎီရ်ဂြည် အခွါင်အာဏာအဆေ အောဒါ။” ");
INSERT INTO pll_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“ဂြည်ဘိူဝ်တအော၊ တရာဗတ္တိဇံ ယောဟန်အီုဝ် ယိူဝ်ႇဒိုရ်တပ္လေင်၊ က်ုန်ကာမိူဝ်ႈ ယိူဝ်ႇဒိုရ်တန်ုဘီဂဲအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","အခိင်ဒီန် ဂဲဒါ့်က်ုရ်မိုန်တဒေ အူကူတောအူကူ၊ “ခိူည်မော အယ်ကျတဒါႈ၊ အယ်က်ုန်ဒါႈ ‘ယိူဝ်ႇဒိုရ်တဖြာ’ အ်ုန်ဒီဒါႈ တအယ် ‘ဆေညာ ပဲကာညှိုမ်ယောဟန်အဲႈ။’ ");
INSERT INTO pll_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ကောည်လိုည် က်ုန်မိူဝ်ႈအယ်ဒါႈ၊ ‘ယိူဝ်ႇဒိုရ်တဘီ’ ” (ကောပ်ဘီဂဲဒီန် ဒါႈထာင်ဒိုည်ႇ ယောဟန် မိူဝ်ႈပရောဖက်၊ အယ်ဘ်ုပ်ယောဒိုည်ႇ ဂဲတွံန်ကူ။) ");
INSERT INTO pll_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ဘံန်ညာခိူည်ဒီန် ဂဲႎီရ်ဒါႈ တယေဆု၊ “ယဲကာနံပ်စိ။” ယေဆု ဒါႈတဂဲ၊ “အောမိူဝ်ႈ ကာပဲန်စိ အောဂြည်တပဲ အခွါင်အာဏာအဆေ အောဒါရ်ုရ်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","အခိင်ဒီန် ယေဆုဂြည်ငဲပုင်တဲႇ တဂဲ၊ “ဘီအူကူ ဆ်ုမ်ကီုရ်ဘူမ်မရာတ်၊ ဟွည်ႇ ရ်ုရ်ရောင်ကာင်လံင်၊ အ်ုန်ကိူဝ်ႈပွံတ်ဘီုင် အတွရဒူည်ပ္လေမရာတ်၊ ရ်ုရ်ပွံတ်ရရဲ့ယာမ်။ ဟွည်ႇဒီန် အ်ုန်က်ုရ်ႎါည်ပွံတ် က်ုရ်ဘူမ်မရာတ်ဒေ တဘီရ်ုရ်စာင် အ်ုန်လေႈပွံတ်ဒေဒေင်။ ");
INSERT INTO pll_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ဘံန်ရောတ်အခိင် ပဲႈပ္လေမရာတ် အ်ုန်ပ္လေါည်လာ်ႈပွံတ် မှာည်ဒေအူကူ တဘီက်ုရ်ႎါည် ကီုရ်ဘူမ်ဒေဂဲ အတွတိူဝ်ႈပ္လေဒိုရ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ဘီက်ုရ်ႎါည်ကီုရ်ဘူမ်ဂဲ ဟွည်ႇတိုည်မှာည်အ်ုန်ဒီန် ဂဲလ်ုရ်ႈပွံတ်အ်ုန် ဆူတ်အ်ုန်ႎေင်ပွံတ်ဒေ ဆံင်မှာ်ႈမိူဝ်ႈကာဒဲႈအ်ုန်ဒိူည်။ ");
INSERT INTO pll_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ဟွည်ႇဒီန် စံဝ်ကီုရ်ဘူမ်ဒီန် ႎီရ်ပ္လေါည်လာ်ႈထဲင် မှာည်ဟံရ်ဒေတဂဲ အူကူ၊ ဘီက်ုရ်ႎါည် ကီုရ်ဘူမ်ဂဲဒီန် ဒါ်ႈပွံတ်ကိင်အ်ုန် ဂဲကဝ်ဆူ ဒဲႈအ်ုန်ဘ်ုပ်ဒေကဆေ။ ");
INSERT INTO pll_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ဘံန်ႎီရ်ပ္လေါည်လာ်ႈ မှာည်ဟံရ်ဒေအူကူ ဂဲပျံမ်ယံမ်ပဲတ်အ်ုန်။ အ်ုန်ဘိူည်ပ္လေါည်လာ်ႈဂံတ်ထဲင် တဘဲႇဟံရ်ဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဒေ ခိူည်ရအာတ်နာန်၊ ပ်ုရ်ဒီ ဂဲလ်ုရ်ႈ၊ ပ်ုရ်ဒီ ဂဲပျံမ်ယံမ်ဒိုည်ႇပဲတ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","တအ်ုန်ဒီန် အတွပ္လေါည်လာ်ႈ ကီုတ်ဂိူဝ် ကွံန်ရံက်အူကူ၊ အ်ုန်ဒါႈ၊ ‘ဂဲစံမ်ဒီရိုဆေ ကွံန်ရံက်အောအီုဝ်ယာ့်၊’ ဘံန်လာ အ်ုန်ပ္လေါည်လာ်ႈပွံတ် ကွံန်ရံက်ဒေ တဘီက်ုရ်ႎါည်ကီုရ်ဘူမ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ကောည်လိုည် ဘီက်ုရ်ႎါည် ကီုရ်ဘူမ်ဂဲဒါႈ တဘူဂေါဟံရ်ဒေ၊ ‘အ်ုန်မိူဝ်ႈကွံန်အီမဲ စံဝ်ကီုရ်ဘူမ်၊ လာ်ႈအယ်ပျံမ်ပဲတ်အ်ုန်၊ က်ုန်ညာခိူည်ဒီန် အုဇာအ်ုန်အီုဝ် ဒီပဲန်ဒိုည်ႇအုဇာအယ်။’ ");
INSERT INTO pll_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ဘံန်ညာခိူည်ဒီန်၊ ဂဲတိူည်ပွံတ် ကွံန်အီမဲအ်ုန်၊ ဂဲဟွည်ႇပျံမ်ယံမ် ထုလေႈပဲတ်တိုအ်ုန် ရရိူဝ့်ကီုရ်ဘူမ်မရာတ်။” ");
INSERT INTO pll_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ယေဆု ဆ်ုရ်မွံတ်ဂဲ၊ က်ုန်ညာခိူည်ဒီန် စဝ်ကီုရ်ဘူမ်မရာတ်ပီ ခိူည်မောအ်ုန်ဒီညာအဲႈ။ အ်ုန်ဒီလာ်ႈပျံမ်ယံမ်ပဲတ် ဘီက်ုရ်ႎါည်ကီုရ်ဘူမ်ဒေဂဲဒီန်၊ ဟွည်ႇဒီန် အ်ုန်ဒီအာပ်ဒဲႈပွံတ် ကီုရ်ဘူမ်မရာတ်ဒေဒီန် တတီဘီဟံရ်။ ");
INSERT INTO pll_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ကာမိူဝ်ႈပဲ ဟွည်ႇယိူဝ်ဒေဒီရ်ႈ တန်ုဘေဲႇကျံမ်၊ “ ‘မိုပ်ုန်ပဲတ် ဘီရ်ုရ်ဂါင်ဂဲဒီန်၊ ဒီႎီရ်ပဲန်ဒေမိုအရေဒါင် ဒိုရ်မိုဒိုည်ႇဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ကီုရ်ညာဖြာ ဟွည်ႇရ်ုရ်အမှုအီုဝ် ပဲန်ခံင်မှိူမ်အာမ် တရအာတ်ငါည်အယ်။’” ");
INSERT INTO pll_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ဘံန်ဘီအွံရ်ကိင်ယုဒဂဲနံပ် ယေဆု ဟောဂြည်ငဲပုင်တဲႇ ဒံင်ဒါႈတဒေ ဂဲရီန်ဒိုည်ႇဒေ တိုည်အ်ုန်၊ ကောည်လိုည် ကောပ်ဂဲယော ဖုင်ဘီကီုန် ဂဲလေႈလာ်ႈဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ဘီအွံရ်ကိင်ဂဲဒီန် ပ္လေါည်လာ်ႈပွံတ် ဖာရိရှဲဂဲပ်ုရ်ဒီဂါရ် ဘီလီပ်န်ုဖုင်ဟေရုဒ်ဂဲပ်ုရ်ဒီ တယေဆု ဆူတ်ဂဲဆ်ုရ်မွံတ် ဒဲႈဘိူန်ဒေတိုည်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ဂဲလာ်ႈဇူပွံတ်အ်ုန် ဒါႈ၊ “အိူဝ် တာဆရာ၊ ယဲနံပ်အေ့ မီဂြည်ငဲဆီုဝ်ငဲမှာန်၊ ငါည်အဆေမိူဝ်ႈ မီကာထာ့်၊ မီဆာင်ဆောန်ဆီုဝ်မှာန် ဒဲႈတဘီဂဲ ဒေင်တရာဖြာ။ အခူန်ပ်ုန်ထာမ်ယဲ တအင်ပါယာဆီဇာအီုဝ် က်ုရ်ဖြေင်ကော ဇောမ်ထုင်ဥပဒေ။ ယဲကျကော တထာမ် က်ုန်ကာမိူဝ်ႈ ကာကျ။” ");
INSERT INTO pll_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ကောည်လိုည် ယေဆုနံပ် ဂဲညာခိူည်ဘီဆူဒေါ ဆ်ုရ်မွံတ်၊ အ်ုန်ႎီရ်ဒါႈ၊ “ကောပ်ဆေ ပဲကဝ်ဆျှု စုင်ဇာမ်ဒိုည်ႇအော ညာခိူည်အီုဝ်အဲႈ။ တိူဝ်ႈပဲဒိူည်အောငိူပ် ရိူန်ဒဲင်ဂါအူပံင်။” ");
INSERT INTO pll_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ဂဲတိူဝ်ႈဒေဒိူည် ဒဲင်ဂါအူပံင် ဒဲႈတအ်ုန်၊ အ်ုန်ဆ်ုရ်မွံတ်ဂဲ၊ “အီအီုဝ်မိူဝ်ႈ ပုင်ရာင်အဆေဂါရ် ဇီုဝ်အဆေအဲႈ။” ဂဲႎီရ်ဒါႈတအ်ုန်၊ “အီအီုဝ်မိူဝ်ႈ ပုင်ငါည်အင်ပါယာဆီဇာဂါရ် ဇီုဝ်အ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ဘံန်ညာခိူည်ဒီန် ယေဆု ဒါႈတဂဲ၊ “အုဇာက်ုရ်ဆဴင်ဒေ တအင်ပါယာဆီဇာ လိုအာပ်ဒဲႈ တအင်ပါယာဆီဇာ၊ က်ုန်မိူဝ်ႈအုဇာ က်ုရ်ဆဴင်ဒေ တဖြာ လိုအာပ်ဒဲႈ တဖြာ။” အခိင်ဒီန် ဂဲညာအာမ်ဒိုည်ႇပွံတ် ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ဟွည်ႇဒီန် ကာယိူဝ်စိထုင်ဇာမ် မျိုဘီအီုဝ် က်ုန်ဟွည်ႇယံမ်ႎီရ်ယိူဝ်ႇအီမ်ဒေ အီအ်ုန်ကျာင်ဒေဒါႈ ဇဒ္ဒုကဲဂဲပ်ုရ်ဒီ လာ်ႈဇူဒိုည်ႇတယေဆု ဂဲဒါႈဒေငဲ၊ ");
INSERT INTO pll_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“အိူဝ် တာဆရာ၊ မောရှေ တဲမ်အူန်ထုင်ပိင်ငျှံပ် အတွယဲ၊ ‘ဘီအူကူအီုဝ် ယိူဝ်ဒေပ်ုန်လဲ ကာယိူဝ်ပဲတ်ကွံန်ႎါ အ်ုန်က်ုန်ယံမ်ပွံတ်ဒေ၊ အတွမာည်ဒဲႈ ခြိူဝ်မျိုႎည်ဒေဟြာည် ႎါအီမဲအ်ုန် ဒီဘ်ုပ်ဒေႎီရ်တိူဝ်ႈ ပ်ုန်လဲႎည်ဒေ ယာကမာည်ဒီန်။’ ");
INSERT INTO pll_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","အာတ်ဒီန် ယိူဝ်ဂဲအူႎါႎည်ပူရ်ကူ၊ ႎည်ဒါင်ဂဲ ဟွည်ႇခံတ်ဒေ ကာယိူဝ်ကွံန်ႎါ ယံမ်ပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ဟွည်ႇဒီန် ႎါအ်ုန်ႎီဒီ ႎီရ်တိူဝ်ႈဆိမ်ပွံတ် ပ်ုန်လဲႎီဒါင်ဒေ ကာယိူဝ်ဒေကွံန်ႎါ ႎီရ်ယံမ်ထဲင်ဒေ။ ႎါအ်ုန်ႎီဒျံတ် စံမ်ညာထဲင်ခိူည်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ဂဲႎါႎည်ပူရ်ကူ အူကူဟွည်ႇအူကူ တိူဝ်ႈဆိမ်ပွံတ် ပ်ုန်လဲႎည်ဒေဒီန် ကာဒဲႈအူန်ကွံန်ႎါဒေကီုတ် ဂဲယံမ်ဒိုည်ႇဒေ၊ ဘံန်လာ အီပ်ုန်ဒီန်မိူဝ်ႈ ယံမ်ပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ရောတ်ခိင်ခါဝ် ႎီရ်ယိူဝ်ႇအီမ် ဂဲက်ုန်ႎီရ်ယိူဝ်ႇအီမ် ဒိုည်ႇဒေ အီပ်ုန်ဒီန် ပ်ုန်လဲအဆေ အ်ုန်ဒီပဲန်ပွံတ်အဲႈ။ ကောပ်ဆေတဒါႈခိူည်ဒီန် ဂဲအူႎါႎည်ပူရ်ကူ ဟွည်ႇရမာဒိုည်ႇဒေ တအ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ယေဆုႎီရ်ဒါႈတဂဲ၊ “ကောပ်မိူဝ်ႈပဲကာနံပ်ဘေဲႇကျံမ်ဂါရ် အဖုင်တီုင်ဂိုဖြာ ပဲကျာင်ဒေက်ုရ်လူတ် ညာခိူည်အီုဝ် ကာမိူဝ်ႈအဲႈ။ ");
INSERT INTO pll_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ဘီအ်ုန်ဟွည်ႇယံမ်ဂဲအီုဝ် အခိင်ဂဲႎီရ်ယိူဝ်ႇအီမ်ဒေ ဂဲဒီကာယိူဝ်ယာ့် ဘီရ်ုရ်ခံတ်လေႈ၊ ဒီပဲန် ညာခိူည်တမန်ဇ်ုဂဲ ဂွည်တပ္လေင်။ ");
INSERT INTO pll_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ဆဲႈဒီန်၊ အကျံင်ဘီဟွည်ႇယံမ် ႎီရ်ယိူဝ်ႇအီမ်ဒေအီုဝ် တန်ုဘေဲႇကျံမ် မောရှေ တဲမ်အူန် ပဲကာတိူမ်ဒီရ်ႈဒေဒိူည် အကျံင်ဖြာ ငဲတမောရှေ န်ုယူပ်၊ ‘အောမိူဝ်ႈ ဖြာ အာဗြဟံ၊ ဖြာ ဣဇက်၊ ဖြာ ယာကုပ်။’ ");
INSERT INTO pll_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ဖြာအီုဝ် ကာမိူဝ်ႈစိ ဖြာ ဘီဟွည်ႇယံမ်၊ မိူဝ်ႈဖြာ ဘီဒါ့်အီမ်ဂဲ။ မိူဝ်ႈညှိုႈ ပဲက်ုရ်လူတ်ဒိုည်ႇယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","အီအ်ုန်မိူဝ်ႈ တာဆရာနံပ်ဘေဲႇကျံမ် လာ်ႈပေါ ယိူဝ်ဒေဆတီုင် ပ်ုန်က်ုရ်မိုန်ဂဲ။ အ်ုန်နွံရ်ႈလှူႈဒေငိူပ် ယေဆု ႎီရ်ဂြည် က်ုရ်တောက်ုရ်ငျာ တဇဒ္ဒုကဲဂဲ၊ အ်ုန်ဆ်ုရ်မွံတ်၊ “ပိင်ငျှံပ်နဲမော မိူဝ်ႈညှိုႈ ပိင်ငျှံပ်မျြံတ်ဒါင်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ယေဆု ႎီရ်ဒါႈတဂဲ၊ “ပိင်ငျှံပ်မျြံတ်ဒါင်ဇူႈအူ မိူဝ်ႈ၊ ‘အိူဝ် ခြိူဝ်မျိုဣသရေလ၊ ဆတီုင်ဘိူဝ်၊ ကီုရ်ညာဖြာ ဖြာအယ်အီုဝ် မိူဝ်ႈညှိုႈ ကီုရ်ညာဖြာအူဆူ။ ");
INSERT INTO pll_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","လိုရံက် ကီုရ်ညာဖြာ ဖြာမီ၊ ဘ်ုရ်ယိူဝ်နွံရ်ႈဖိူမ်၊ ဘ်ုရ်ယိူဝ်ႎိငျံန်၊ ဘ်ုရ်ယိူဝ်အိုမ်ငျံန်ဂါရ် ဘ်ုရ်ယိူဝ်ရဲင်ဆွံန်မီ။’ ");
INSERT INTO pll_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ပိင်ငျှံပ်မျြံတ်ဒါင်ဇူႈအာရ်ဒီန် မိူဝ်ႈ၊ ‘လိုရံက်ဘူဂါင်ဘူရာပ် ခိူည်မီရံက်တိုဒေ’ ဆဲႈပိင်ငျှံပ် အာရ်ပါအီုဝ် ကာယိူဝ်ယာ့် ပိင်ငျှံပ်ဟံရ် ဒါင်ဒိုရ်အ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","တာဆရာနံပ်ဘေဲႇကျံမ် ဒါႈတယေဆု၊ “ပ်ုန်ဒါႈမီမိူဝ်ႈအေ့၊ တာဆရာ၊ ထာဝရကီုရ်ညာဖြာအီုဝ် မိူဝ်ႈညှိုႈ ယိူဝ်ဂိူဝ်အ်ုန်အူဆူ၊ ဆဲႈကီုရ်ညာဖြာအီုဝ် ကာယိူဝ်ယာ့်ဖြာဟံရ်။ ");
INSERT INTO pll_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","လိုရံက်ဖြာမီ တဘ်ုရ်ယိူဝ်နွံရ်ႈဖိူမ်၊ ဘ်ုရ်ယိူဝ်အိုမ်ငျံန်၊ ဘ်ုရ်ယိူဝ်ရဲင်ဆွံန်ဒေ၊ လိုရံက်ဘူဂါင်ဘူရာပ် ခိူည်မီရံက်တိုဒေ၊ က်ုန်ဒါဇောမ် ပိင်ငျှံပ်အာရ်ပါအီုဝ် မျြံတ်ဒိုရ်လှူအာပ်ကာပ်ဒဲႈ တိုဆံတ်ဂါရ် ယဇ်ပ်ုန်ဟံရ် ပါင်ယဇ်ပလာင် တဖြာ။” ");
INSERT INTO pll_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ယေဆုယိူဝ်ဒေငိူပ် အီကူဒီန် ဒါပိင်ငျာဒေႎီရ်ဂြည်၊ ဘံန်ညာခိူည်ဒီန် အ်ုန်ဒါႈတအ်ုန်၊ “မီကာဆငါည်ယာ့် ဒိုရ်တကပီုန်ကုင်ဖြာ။” စမံင်အခိင်ဒီန် အဆေမိူဝ်ႈ ကာယာႇဆ်ုရ်မွံတ်ယာ့် ပ်ုန်ဆ်ုရ်မွံတ်လှာည်အူနဲ တယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ယာမ်ယေဆု ဆုင်မဆာင်ဆောန်ဒဲႈ တန်ုကျောင်ဗိမာန်၊ အ်ုန်ဆ်ုရ်မွံတ်ဂဲ ပ်ုန်ဆ်ုရ်မွံတ်၊ “ကောပ်ဆေ တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ နံပ်ဒေဒါႈ မေရှိယ မိူဝ်ႈကွံန်ဒါဝိဒ်အဲႈ။ ");
INSERT INTO pll_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ႎိငျံန်ဆပဲဆောနွံရ်ႈဖိူမ် ဆူတ်ဒါဝိဒ်ဒါႈ၊ “ကီုရ်ညာဖြာ ဒါႈတကီုရ်ညာအော၊ မာ့်မီ လ်ုပ်ခေါန်ညှိုႈအော မောဂိူပ်ပေါအခိင် အောဂံမ်အူန်ရာန်ဆူမီဂဲ ရခြူမ်ဇိူင်မီ။” ");
INSERT INTO pll_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ဒါဝိဒ် က်ုန်တောႇ အ်ုန်မိူဝ်ႈ ‘ကီုရ်ညာ၊’ ခိူည်မော ညာဒေပဲန် ကွံန်ဒါဝိဒ်အဲႈ။” ဖုင်ဘီက်ုရ်စုဒါင်ဂဲ နွံရ်ႈရျံန်ဖိူမ်ပျောဒေ ဆတီုင်ဒိုည်ႇငဲပ်ုန်ဂြည်ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","အ်ုန်ဆီုပ်ထဲင်ဒေ ဆုင်မဆာင်ဆောန်ဂဲ၊ အ်ုန်ဒါႈ၊ “ပဲလိုအူန်ဆဒိ ႎဲႈတာဆရာနံပ်ဘေဲႇကျံမ်ဂဲအေ့။ ဂဲဆမာ ချူပ်ဒေဒါ ဆဒေါလှိူင် လာ်ႈလာ်ႈႎေင်ႎေင် တအရာပ်တကာတ် ဂဲယိူဝ်ဖိူမ် ဆ်ုန်ဒဲႈဘီရိုဆေကူပ်ယောမ်တဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","တန်ုကျောင်ရဆောန်ဒဲႈတရာ ဂဲဆမာအုင်ဒေရံရ်ႈ ရမာ့်ကျ၊ တပ္လေါည်ဟောမ် ပ္လေါည်တျံင်မိူဝ်ႈ ဂဲဆမာအုင်ရဂွည်ကျ။ ");
INSERT INTO pll_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ဂဲဟွည်ႇတိူဝ်ႈဆီမ် ဂါင်ယာကမာည်ဂဲ၊ ဆမာညာရာင် ဆုတောင်လှိူင်လှိူင်။ ဂဲဒီဘ်ုပ်ဒေခါမ် ဂ်ုမ်အပေတ်ဇံန်။” ");
INSERT INTO pll_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ယာမ်ယေဆု မာ့်ပြောတိူဝ့်ခါမ်ရိူန်လှူ တကျောင်ဗိမာန်၊ အ်ုန်ငိူပ်ပုင်ဇာမ်ဘီဂဲ ဆ်ုရ်ရိူန်လှူတန်ုတိူဝ့်။ ဘီခြ်ုမ်ဆာဂဲဒီန် ဆွံင်လီပ်ဘ္လံမ်။ ");
INSERT INTO pll_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ဟွည်ႇဒီန် ယာကမာည်ဖ္လာန်အူကူ လာ်ႈပေါဒေဆွံင်လီပ် ရိူန်ဒဲင်ဂါအာရ်ပံင် တာန်အူပဲ။ ");
INSERT INTO pll_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","အခိင်ဒီန် အ်ုန်တောႇဒေဒါႈတ တဘဲႇဒေဂဲ၊ “အောဂြည်ညှိုႈတပဲ၊ ရိူန်ပ်ုန်ဆွံင်လီပ် ယာကမာည်အီုဝ် ဘ္လံမ်ဒိုရ်ဘ်ုရ်ယိူဝ်အီအ်ုန်ဆွံင်လီပ် တန်ုတိူဝ့်ခါမ်ရိူန်လှူ။” ");
INSERT INTO pll_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","“အကျံင်အ်ုန်မိူဝ်ႈ ဂဲဒိုည်ႇဒိုည်ႇအီုဝ် တိူဝ်ႈဒိုရ်န်ုအုဇာခြ်ုမ်ဆာဒေ ဂဲဆွံင်လီပ်။ ကောည်လိုည် က်ုန်မိူဝ်ႈယာကမာည်အီုဝ်၊ အ်ုန်ဘိူည်ဖ္လာန်ဂံတ်၊ အ်ုန်တိူဝ်ႈတန်ုပ်ုန်ဟျံင်အဆာႇဒေ ဆွံင်လီပ်ဒိုည်ႇ။” ");
INSERT INTO pll_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ယာမ်ယေဆု လေႈဒိုရ်ကျောင်ဗိမာန်၊ န်ုတဘဲႇအ်ုန်ဂဲအူကူ ဒါႈတအ်ုန်၊ “ငိူပ်ဘိူဝ် တာဆရာ၊ က်ုန်လူမ်မိုဒါင်ဂါရ် ဂါင်ခီုဝ့်ဂါင်ဒါင် ဘ္လံမ်ညှိုႈအာ်။” ");
INSERT INTO pll_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ယေဆု ႎီရ်ဒါႈ၊ “မီယိူဝ်ဂိူဝ်ဒေငိူပ် ခိူည်ဂါင်ခီုဝ့်ဂါင်ဒါင်ညှိုႈအီုဝ် ကာမိူဝ်ႈ။ အရာပ်အီုဝ် က်ုန်လူမ်မိုဒိုည်ႇဒိုည်ႇ ဒီဘ်ုပ်က်ုရ်တူႈယာႈဒိုည်ႇ၊ က်ုန်လူမ်မိုအူပံင်လိုည် ကာဒါ့်ကီုတ်ယာ့်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ဟွည်ႇဒီန် ယေဆုဟာ့်မာ့်ဒေ တပါင်ဆိုရ်တာန်လူန်၊ က်ုရ်ပံတ်ငါည်ဒေ လ်ုပ်ကျောင်ဗိမာန်၊ ယာမ်အ်ုန်ဂွည်ရာင်ကောည်ဒေ ပေတရု၊ ယာကုပ်၊ ယောဟန်ဂါရ် အန္ဒြေ လာ်ႈဇူဒိုည်ႇဒေဆ်ုရ်မွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ဂဲဒါႈ၊ “ခိူည်ပ်ုန်ဒီပဲန်လာ်ႈဒိုည်ႇဒိုည်ႇအီုဝ် ဘံန်မောအ်ုန်ဒီပဲန်ဂါရ် အကျံင်နမိလက္ခဏာအီုဝ် ဘံန်မောအ်ုန်ဒီဇာ်ႈရောတ် ဂြည်ဘိူဝ်တယဲစိ။” ");
INSERT INTO pll_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ယေဆုဒါႈ တဂဲ၊ “မာည်ဒဲႈအဆေ ဘိူန်ဒေချှောႇကဝ်ပဲ အူန်ဒိုည်ႇဆဒိအေ့။ ");
INSERT INTO pll_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲဒီန်၊ ဒီတိူဝ်ႈဒေဒါဇီုဝ်အော ရောတ်ပေါဒေဒါႈ၊ ‘အောမိူဝ်ႈ အ်ုန်ယာ့်၊’ ဟွည်ႇဒါႈခိူည်ဒီန် ဒီချှောႇကဝ်ဒိုည်ႇဘီဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","အခိင်ပဲယိူဝ်ဒေဆတီုင် ဆဒါင်က်ုရ်တီုဝ့်ဆီုဝ့်ဂါရ် ဆဒါင်ဘီဂဲရဲန်ဒေက်ုရ်တီုဝ့်ဒီန် ပဲမာည်အူန်နွံရ်ႈဖိူမ်ဒေယော။ ခိူည်အကျံင်ဒီန် ဒီဘ်ုပ်ပဲန်ညှိုႈ၊ ကောည်လိုည် ညှံမ်ရောတ်စိ တဟာတိူဝ်ႇဟာဆူတ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ခြိူဝ်မျိုဘီ အူမျိုတော အူမျိုဂါရ် ကပီုန်ကုင် အူကုင်တော အူကုင် ဒီက်ုရ်ရာန်ဒိုည်ႇဒေ၊ တအရာပ်တွံန်တီမိူဝ်ႈ အီမ်ယာဒီယူႈ၊ ဒီက်ုရ်တူႈရာႇဟောမ်ရာႇဒါ။ အီအီုဝ်မိူဝ်ႈ ႎိုည်ဒနာ စဒေတဲကိူတ်ႎါ။ ");
INSERT INTO pll_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ဒဲႈပဲအူန်ဆဒိ တတိုဒေ။ ဘီဂဲ ဒီအာပ်ဒိုည်ႇပဲ တလူမ်တရာ။ ပဲဒီဘ်ုပ်ဒေက်ုရ်တူႈ ဘီဂဲလ်ုရ်ႈဒိုည်ႇဒေ တကျောင်ရဆောန်ဒဲႈတရာ၊ ကောပ်ပဲဂြည်ဆဒါင်ကျ ပဲန်ဆာ့်ဆေအတွအော ပဲဒီဘ်ုပ်ဒေဇံင် တရအာတ်ဘီအူပ်ဘြောင်ဂါရ် တရအာတ်ခူန်ဟောခံမ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ဟွည်ႇဒီန် ဒီဘ်ုပ်ဟောဂြည်ဇံဝ် ဆဒါင်ကျအီုဝ် တခြိူဝ်မျိုဘီဂဲ ဒိုည်ႇဒိုည်ႇ။ ");
INSERT INTO pll_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","အခိင်ဘီဂဲတောႇဒေဒိူည် လာ်ႈအာပ်ဒိုည်ႇပဲ တလူမ်၊ ခိူည်မောပဲ ဒီညာဒေဂြည် ပဲမာည်ယိူဝ်နွံရ်ႈဟဇံဝ်၊ အခိင်ဒီန် ကာမိူဝ်ႈစိတိုပဲ ဂြည်၊ မိူဝ်ႈႎိငျံန်ဆပဲ ဒီဂြည်။ ");
INSERT INTO pll_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ခိင်ခါဝ်ဒီန် အူႎါႎည် အူကူတောအူကူ ဒီက်ုရ်အာပ်ဒိုည်ႇဒေ တယံမ်၊ စံမ်ညာခိူည်ဒီန် ကူန်မိူဝ်ႈ ဒီအာပ်ဒိုည်ႇကွံန်ႎါဒေ တယံမ်။ ကွံန်ႎါဂဲမိူဝ်ႈ ဒီရာန်ကူန်မာဒေ အာပ်ဒဲႈဒိုည်ႇဂဲတယံမ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ကောပ်ဇီုဝ်အော ဘီဂဲတွံန်ကူ ဒီရအီရ်ႈဒိုည်ႇပဲ။ ကောည်လိုည် အဆေမိူဝ်ႈဟွည်ႇ က်ုန်ယိူဝ်ဆတ်စာ မောဂိူပ်ပေါ တဟာတိူဝ်ႇဟာဆူတ် ဒီဘိူန်ပ်ုန်လောတ်။” ");
INSERT INTO pll_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ပဲဒီယိူဝ်ဒေငိူပ် ‘ခံင်မှိူမ်ရအီရ်ႈမှိူမ်ယော’ ဒါ့်ဇံင်ဒေ တအရာပ်ကာမှိူမ်ဇံင်ဒီန်။” (အီအ်ုန်ဒီရ်ႈဘေဲႇ၊ ဒဲႈအ်ုန်နံပ်အိုမ်ငဲ ပ်ုန်ဒါႈအ်ုန်)။ ဟွည်ႇဒီန် အီအ်ုန်ဂွည် တကပီုန်ကုင်ယုဒ ဒဲႈဂဲဒူဟာ့်ဒိုည်ႇဒေ တပါင်ဆိုရ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","အီအ်ုန်ဂွည်ဒေ တပါင်ကြောင်ဂါင် ဆံင်မှာ်ႈမိူဝ်ႈမာည်ဒဲႈအ်ုန်ႎီရ်လေႈတိူဝ်ႈ တရန်ုဂါင်။ ");
INSERT INTO pll_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","အီအ်ုန်ဂွည်တနာ မာည်ဒဲႈအ်ုန် ႎီရ်ႎေင်တိူဝ်ႈဆဒေါဒါင်ဒေ တဂါင်။ ");
INSERT INTO pll_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","တန်ုဆငီဒီန် အီပ်ုန်ဂွည်တတိုဒေဂါရ် အီပ်ုန်ယိူဝ်ႎါဒါ့်ဘူတဒေဒီန် ဒီပဲန်ဒုခနာ့်နွံရ်ႈ ကျူညှိုႈအတွဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ဒဲႈပဲဆုတောင် တဖြာ အခိင်ဒီန် မာည်ဒဲႈအ်ုန် ရောတ်ခိင်ခါဝ်ကံတ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","အကျံင်အ်ုန်မိူဝ်ႈ၊ အိုရ်စတဲကံမ်ဖာ ပ်ုန်ဖာန်ဇာမ်ဖြာ မောအူဒီန်အီုဝ် ကာတိူမ်ပဲန်၊ ဘံန်ဒီန်မိူဝ်ႈ ကာနံပ်ဒေပဲန် ဒုခနာ့်နွံရ်ႈအီုဝ် ဒီဇာ်ႈရောတ်တန်ုဆငီဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ကီုရ်ညာဖြာ က်ုန်ကာဒဲႈ ဆငီဒီန်ဒံတ် အဆေမိူဝ်ႈကာဘိူန်စိ ပ်ုန်လောတ်တိုဒေ။ ကောည်လိုည် က်ုန်မိူဝ်ႈ ဘီပ်ုန်ရံရ်ႈအူန်အ်ုန် တဆငီဒီန် ဒီဒဲႈဆငီဒံတ်အတွဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“အခိင်ဒီန် ဘီအူကူကူ က်ုန်ဒါႈတပဲ၊ ‘ငိူပ်ဘိူဝ်၊ အရာပ်အီုဝ် ယိူဝ်ခရိ၊’ က်ုန်ကာမိူဝ်ႈ ‘ငိူပ်ဘိူဝ်၊ အ်ုန်ဂွည် အရာပ်တည်’ ပဲမာည်ညှိုမ်အေ့။ ");
INSERT INTO pll_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","အီအ်ုန်ယိူင်ဒေပဲန်ခရိဂါရ် အီယိူင်ဒေပဲန်ပရောဖက်ဂဲ ဒီရောတ်ပေါ။ ဂဲက်ုန်ဘဲဒေချှောႇကဝ် ဘီပ်ုန်ရံရ်ႈအူန်ဖြာ ဂဲဒီရ်ုရ်နမိလက္ခဏာ ခံင်မှိူမ်အာမ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ကောပ်ခိူည်ဒီန် ဒဲႈပဲအူန်ဆဒိအေ့၊ အောဟွည်ႇဂြည်အူန်ဇံဝ် အကျံင်ဒီန်တပဲယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“န်ုဆငီဒီန် ဒုခနာ့်နွံရ်ႈ က်ုန်ဟွည်ႇဇာ်ႈရောတ် ဆငီအီုဝ်ဒီအံပ်လာ်ႈပွံတ်ဒေ၊ ပ္လါင်ကျံရ်မိူဝ်ႈ ဒီကာဒဲႈယာ့်ပ္လါင်ဒေဂူႈ၊ ");
INSERT INTO pll_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ဆမိင်ဂဲမိူဝ်ႈ ယိူဝ်ႇဒိုရ်တပ္လေင် ဒီဇာ်ႈလေႈဒိုည်ႇဒေ၊ ရဲင်ဒေင်နက္ခတ်မိူဝ်ႈ ဒီက်ုရ်ခြါည်ဒိုည်ႇဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","အခိင်ဒီန် ဘီဂဲဒီယိူဝ်ဒိုည်ႇဒေငိူပ် ကွံန်ဘီအီုဝ် ဒိူည်အဖုင်တီုင်ဂိုဂုင်ဒါင်ဒေ ဒီဘဆိုရ်အူတ်စွလေႈ။ ");
INSERT INTO pll_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ဟွည်ႇဒီန် အ်ုန်ဒီပ္လေါည် တမန်ဇ်ုဂဲတပ္လေင် လေႈတဘီပ်ုန်ရံရ်ႈအူန် ဖြာ၊ အ်ုန်ဒီက်ုရ်စုဒိုည်ႇ အရာပ်လ်ုပ်ငါည်ဖိုန်တီ ယိူဝ်ႇဒိုရ်တပါင်ကံမ်ဖာ မောဂိူဝ့်ပေါ တဟာတိူဝ်ႇဟာဆူတ် တပ္လေင်။ ");
INSERT INTO pll_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ဒဲႈပဲပ်ုရ်နောအူန်ဒေဒါ ပုင်တဲႇ ဒိုရ်တီုင်ပ္လေပ္လေါႇအေ့၊ အခိင်ကာႇလှာညောတ်အ်ုန် က္လဲႇဒေလေႈ၊ ပဲစံမ်နံပ် အ်ုန်ဒံတ်တခါဝ်မည်။ ");
INSERT INTO pll_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","စံမ်ညာခိူည်ဒီန် အခိင်ပဲယိူဝ်ဒေငိူပ် ပဲန်အကျံင်ခိူည်ဒီန်၊ ဒဲႈပဲနံပ် ကွံန်ဘီအီုဝ် ဟွည်ႇမိူဝ်ႈဒံတ်ရောတ် တဘာင်ဘိုႈယာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","အောဂြည်ညှိုႈတပဲ၊ ဘီအ်ုန်ဒါ့်အဆာႇအီမ် အူဒီန်အီုဝ် ကြိူည်ဂဲယံမ် ဒဲႈပဲတံင်အူန် အကျံင်ပ်ုန်ဒီပဲန်အီုဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ပ္လေင်ဂါရ် ကတဲ ဘိူည်ကာမြဲ ငဲအောကာနံပ်စိဒေဟြာည်။ ");
INSERT INTO pll_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ကောည်လိုည် အခိင်ဆငီနာရီ ဒီပေါဒီန်၊ အဆေမိူဝ်ႈကာနံပ်၊ တမန်ဇ်ုဂဲတပ္လေင်မိူဝ်ႈကာနံပ်၊ ကွံန်မိူဝ်ႈကာနံပ်၊ မိူဝ်ႈဂိူဝ်ကူန်အူကူနံပ်။ ");
INSERT INTO pll_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ကောပ်ပဲကာနံပ် အခိင်ဆငီနာရီ ဒီပေါဒီန် ဒဲႈပဲဂွည်ရဲ့အူန်ဆဒိအေ့။ ");
INSERT INTO pll_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ပ်ုန်ဆ်ုန်ဒါႈအ်ုန်မိူဝ်ႈ ညာခိူည်ဘီအူကူ ရဲန်ဒေလေႈဒေင်၊ ယာမ်အ်ုန်ဒီလေႈ ဒိုရ်ဂါင်ဒေ အ်ုန်တံမ်အူန်မှာည်ဒေဂဲ တွံန်ကူတွံန်ကူ၊ အ်ုန်အာပ်ဒဲႈတဂဲ ကာန်ပ်ုန်လိုရ်ုရ်ဂဲဂါရ် အခွါင်အာဏာ၊ ဟွည်ႇဒီန် အ်ုန်တံမ်အူန် အီရဲ့ဘာင်ဘိုႈဒီန် ဒဲႈအ်ုန်ယိူဝ်ဆဒိ ဒါ့်ဂွည်ငိူပ်လလဘာင်ဘိုႈ။ ");
INSERT INTO pll_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","စဝ်ဂါင်ဒီန် အခိင်စူန်အံပ်၊ အခိင်ရဆိူမ်၊ အခိင်အျံရ်စဒေတဂေါႇ၊ အခိင်ရႎါရ်ႈဇံဝ်ဇံဝ် ဘံန်မောအ်ုန်ဒီႎီရ်ပေါ ကောပ်ပဲကာနံပ် ဒဲႈပဲအူန်ဆဒိ ဒါ့်ရဲ့အေ့။ ");
INSERT INTO pll_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","အ်ုန်က်ုန်ပေါဘြုပွံတ်တပဲ၊ မာည်ဒဲႈအ်ုန်ယိူဝ်ဒေငိူပ်ပဲ ဒါ့်အီတ်ဆငဲႈဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ဆေအောဂြည်အူန်တပဲအီုဝ်၊ အောဟွည်ႇဂြည်ဒိုည်ႇ တဘီတွံန်ကူယာ့်၊ ‘အူန်ဆဒိ ဒါ့်ရဲ့အေ့။’” ");
INSERT INTO pll_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ဒံတ်ရောတ် ပ္လေါည်ပသခါဂါရ် မုင်ကာယိူဝ်ဆနံမ်ဂိူဝ်ႈ လိုဂိူဝ်အာရ်ဆငီ။ ယဇ်ပုရောဟိတ်ဒါင်ဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ အတွဘိူန်ဒေတိုည် ပျံမ်ယေဆု ဂဲလဲမ်ဒိုည်ႇဒေင်လာ့်လာည်။ ");
INSERT INTO pll_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ကောည်လိုည် ဂဲဒါႈ၊ “မာည်က်ုရ်နဲတ်တိုည်အ်ုန် တန်ုဆငီပ္လေါည်အီုဝ်၊ ဘီဂဲဆမာပဲန် က်ုရ်မှူရ်က်ုရ်မီုင်ဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ယေဆု ဂွည်တဂါင် အီအ်ုန်ဘ်ုပ်တူတ်ဇီုဝ်ရှိမုန် တရူဗေသနိ၊ ယာမ်ယေဆု ဒါ့်မာ့်ဟောမ်ပ်ုန်ဟောမ်၊ အီပ်ုန်အူကူလီပ်ပေါ တိူဝ်ႈဒေဒိူည် အိုမ်နံမ်ငါနာဒု အူရ်ႈငှူရ်စဲတ်စဲတ် ဆ်ုရ်နာ့်တပြဴင်မိုဘ္လောႇ ပည်ငွံရ်ႈရဲင်၊ အ်ုန်ဟွည်ႇပ်ုန်တဲႈပွံတ်ပြဴင်ဒီန် ထောႇလေႈပွံတ် အိုမ်နံမ်ငါအူရ်ႈငှူရ် တပါင်ကိင်ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","အခိင်ဒီန် ဘီဂဲပ်ုရ်ဒီ ပည်ဒေါဆလေႈ ရဝ်ဒါႈတဘီဟံရ်အူကူ၊ “ဆေမိူဝ်ႈ အ်ုန်တပ်ုန်ချှူမ်ပဲတ် အိုမ်နံမ်ငါအူရ်ႈငှူရ်အီုဝ်အဲႈ၊ ");
INSERT INTO pll_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","က်ုန်ယံင် အိုမ်နံမ်ငါအူရ်ႈငှူရ်အီုဝ် တရိူန်ဒဲင်ဂါ အွည်ပ်ုရ်ယာ်ႈပည့်ပါည်ပါည် ဘိူန်ဒဲႈရိူန်ဒီန်တဘီဖ္လာန်ဂဲ၊” ဂဲတာင်အပေတ် ဒါႈငဲတအီပ်ုန်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ကောည်လိုည် ယေဆုဒါႈ၊ “လိုင်ပဲတ် အီပ်ုန်ဒီန် ရ်ုရ်ပ်ုန်ဆ်ုန်ရ်ုရ်ဒေ၊ ကောပ်ဆေပဲ ကဝ်ဆျှူအ်ုန်အဲႈ၊ အ်ုန်ရ်ုရ်ဒဲႈအမှုကျ တအောမိူဝ်ႈ။ ");
INSERT INTO pll_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ဘီဖ္လာန်ဂဲအီုဝ် ဒီယိူဝ်ဇောမ်ပဲဆေဆေ၊ အခိင်ပဲယိူဝ်နွံရ်ႈဖိူမ် ပဲဘိူန်ဒေဇောည်ဂဲ။ က်ုန်မိူဝ်ႈအော ကာဂွည်စိ ဇောမ်ပဲဆေဆေ။ ");
INSERT INTO pll_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","အ်ုန်ဘဲဘ်ုရ်မော အ်ုန်ဟွည်ႇရ်ုရ်ဒေဒိူည် အတွရဲန်ဆာင်ဂျိုဒဲႈ တိုအော၊ အ်ုန်ဟွည်ႇ ထောႇဖွံန်အူန်ဇံဝ် အိုမ်နံမ်ငါအူရ်ႈငှူရ် တတိုအောယာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","အောဂြည်ညှိုႈတပဲ၊ စမံင်အူဒီန် အရာပ်ဟောဂြည် တရာဆဒါင်ကျ တန်ုကံမ်ဖာအီုဝ်တွံန်တီ၊ ဂဲဒီဂြည် အမှုပ်ုန်ရ်ုရ်အီပ်ုန်အီုဝ် ဒဲႈပဲန်ကာဘီရ်ကာပြါႈ တအ်ုန်။” ");
INSERT INTO pll_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ဟွည်ႇဒီန် အီအ်ုန်လီပ်န်ုတဘဲႇ အူကိူရ်အာရ်ကူ၊ ယုဒရှကာရုတ်ဒီန်၊ အတွအာပ်ယေဆု အ်ုန်လေႈလာ်ႈပွံတ်ဒေ တယဇ်ပုရောဟိတ်ဒါင်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ဘံန်ဂဲယိူဝ်ဒေဆတီုင် နွံရ်ႈဖိူမ်ဂဲရျံန်ပျော ဂဲဒဲႈကဒိ ဒါႈဒေဒဲႈရိူန် တအ်ုန်။ ကောပ်ခိူည်ဒီန် ယုဒခံပ်က်ုရ်ယေင် လဲမ်ဒေင်လာ့်လာည် အခိင်ကျ အတွဘိူန်ဒေအာပ် ယေဆု တတီဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ဆငီဇူႈအူ ပ္လေါည်မုင် ကာပါဆနံမ်ဂိူဝ်ႈ၊ အတွပ္လေါည်ပသခါဆိုဒျံတ် ဆငီဂဲပျံမ်တိုယဇ်ဒီန် တဘဲႇယေဆု ဆ်ုရ်မွံတ်အ်ုန်၊ “အတွဟောမ်ပ္လေါည်ပသခါ မီယိူဝ်နွံရ်ႈဖိူမ် ဆ်ုန်ဒဲႈယဲလာ်ႈရဲန် အတွဒေ အရာပ်မောအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ဟွည်ႇဒီန် ယေဆု ပ္လေါည်လာ်ႈပွံတ် တဘဲႇဒေအာရ်ကူ အ်ုန်ဒါႈ၊ “လာ်ႈပွံတ်ပါရ် တန်ုကုင်၊ ပါရ်ဒီလာ်ႈယိူဝ်ဒေငိူပ် ဘီအူကူကွံတ်အဴင်။ ဒဲႈပါရ်လာ်ႈဇောမ်ပွံတ်အ်ုန် ");
INSERT INTO pll_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","တဂါင်ဟာရလီပ်အ်ုန်၊ ဆ်ုရ်မွံတ် တစဝ်ဂါင်ဒီန်၊ ‘တာဆရာယဲဒါႈ၊ အခါန်ဟောမ်ပ္လေါည်ပသခါ ဇောမ်တဘဲႇအော ဟာမောအ်ုန်ဂွည်အဲႈ။’ ");
INSERT INTO pll_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ဟွည်ႇဒီန် အ်ုန်ဒီယီုဝ်ဒဲႈတပါရ် အခါန်ဒါင်လ်ုပ်က်ုရ်ႎိူည်၊ ဂဲဟွည်ႇရဲန်ဒဲႈအူန် အတွအယ်တွံန်နဲ ဟာဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ဘံန်တဘဲႇအ်ုန်ဂဲ လာ်ႈပွံတ်ဒေ တကုင်ဒီန်၊ ဂဲယိူဝ်ဒေငိူပ်ပွံတ် ခိူည်ပ်ုန်ဂြည် ယေဆု တဒေ၊ ဂဲရဲန်ပွံတ် ရဟောမ်ပ္လေါည်ပသခါ။ ");
INSERT INTO pll_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ဘံန်ရောတ်အခိင် စူန်ဒီအံပ် ယေဆုစွလာ်ႈရူမ် ဇောမ်တဘဲႇဒေ အူကိူရ်အာရ်ကူ။ ");
INSERT INTO pll_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ယာမ်ဂဲမာ့် ဟောမ်ဒေတဘွည်၊ ယေဆုဒါႈ၊ “အောဂြည်တပဲ၊ ရန်ုပဲဒီန် ဒီယိူဝ်ဘီယာႈဆေတ်စာ တအော အူကူ အီအ်ုန်ဟောမ်ရူမ် ဇောမ်အော တဘွည်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","တဘဲႇအ်ုန်ဂဲ ညာဖိူမ်ကာပျောပွံတ်ဒေ ဂဲဒါႈဒေဆ်ုရ်မွံတ်အ်ုန်၊ “ကာမိူဝ်ႈစိ မီဒါႈအောယို” ဂဲလာည်က်ုရ်ဆ်ုရ်မွံတ်ဒိုည်ႇ အူကူဟွည်ႇအူကူ။ ");
INSERT INTO pll_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ယေဆုႎီရ်ဒါႈ၊ “မိူဝ်ႈတန်ုပဲ ကိူရ်အာရ်ကူ၊ အီအ်ုန်ဟောမ်ရူမ်မုင် ဇောမ်အော န်ုတလုင်အီုဝ်ယာ့်။ ");
INSERT INTO pll_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ခိူည်ပ်ုန်တဲမ်အူန် တန်ုဘေဲႇကျံမ်ဒါႈ၊ မိူဝ်ႈညှိုႈကွံန်ဘီအီုဝ် ဒီဘ်ုပ်ခါမ်ဒေယံမ်၊ ကောည်လိုည် အီအ်ုန်အာပ် ကွံန်ဘီအီုဝ် ယိူဝ်အမံင်ဂလာ။ အီကူဒီန် က်ုန်ကာကိူတ်လေႈ အတွအ်ုန်ႎရကျ။” ");
INSERT INTO pll_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ယာမ်ဂဲဒါ့်ဟောမ်၊ ယေဆုတိူဝ်ႈပွံတ်မုင်၊ အ်ုန်ဟွည်ႇတာင်ဂုင်ကေစူ တဖြာ၊ က်ုရ်ပ္လဲႈမုင် ဒဲႈပွံတ်တတဘဲႇဒေဂဲ၊ အ်ုန်ဒါႈ၊ “အီအီုဝ် မိူဝ်ႈတိုအော၊ တိူဝ်ႈပဲဟောမ်။” ");
INSERT INTO pll_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ဟွည်ႇဒီန် အ်ုန်တိူဝ်ႈဆလော့၊ တာင်ဂုင်ကေစူ တဖြာ၊ ဒဲႈပွံတ်တဂဲ၊ ဂဲတျံင်ဒိုည်ႇပွံတ် တွံန်ကူ။ ");
INSERT INTO pll_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ယေဆုဒါႈတဂဲ၊ “အီအီုဝ်မိူဝ်ႈ နှာမ်အော ပ်ုန်ထောႇလေႈဒဲႈ အတွဘီဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ်ဂဲ၊ နှာမ်အောအီုဝ် က်ုရ်ဆဴင်ဒေ တတရာပဋိညာဉ်ဖြာ။ ");
INSERT INTO pll_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","အောဂြည်ညှိုႈတပဲ၊ အောကာတျံင်ယာ့် ခိူည်အိုမ်မရာတ်အီုဝ် မောဂိူပ်ပေါဆငီ အောတျံင်အိုမ်မရာတ်က်ုန်မဲ တန်ုကပီုန်ကုင်ဖြာ။” ");
INSERT INTO pll_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ဟွည်ႇဒီန် ဂဲဟိုင်ဒါႈတချံင် တာင်ဂုင်ဖြာ ဂဲလာ်ႈဒိုည်ႇပွံတ်ဒေ တဆိုရ်တာန်လူန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ယေဆုဒါႈ တဂဲ၊ “ပဲဒီဒူလာ်ႈဆငါည်ဒိုည်ႇဒေ ပဲတ်ပဲတ်အောအူကူ၊ တဘေဲႇကျံမ် ဂြည်အူန်၊ ‘ဘံန်ဖြာ ပျံမ်ယံမ်ပဲတ် ဘီရဲ့ဆိုဒီန်၊ ဆိုဂဲမိူဝ်ႈ ညာပြံတ်ပြံတ်စာႈစာႈ က်ုရ်ကာႈဒိုည်ႇဒေ။’ ");
INSERT INTO pll_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ကောည်လိုည် အောက်ုန်ဟွည်ႇ ႎီရ်ယိူဝ်ႇအီမ်၊ အောဒီလာ်ႈအွံရ်ပွံတ် ရအာတ်ပဲ တကပီုန်ကုင်ဂါလိလဲ။” ");
INSERT INTO pll_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ပေတရုႎီရ်ဒါႈ၊ “ဂဲဘိူည်ပဲတ်ဂံတ်မီ၊ ယာမ်မောမိူဝ်ႈ အောကာပဲတ်စိမီ။” ");
INSERT INTO pll_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ယေဆုဒါႈ တပေတရု၊ “အောဂြည်ညှိုႈတမီ၊ ရမှိူဝ်အီုဝ် ကြိူည်အျံရ်တဂေါႇ အာရ်လိူဝ်ႈ၊ မီဒီႎဲႈထေင်ပဲတ်အော ဒါႈဒေကာနံပ်အော အွည်လိူဝ်ႈ။” ");
INSERT INTO pll_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ပေတရု ႎီရ်ဒါႈညှိုႈထဲင်၊ “အောဘိူည် ဘ်ုပ်ယံမ်ရူမ်ဂံတ်ဇောမ်မီ၊ ယာမ်မောမိူဝ်ႈ အောကာႎဲႈထေင်စိမီခိူည်ဒီန်။” တဘဲႇဟံရ်အ်ုန်ဂဲမိူဝ်ႈ ဒါႈဒိုည်ႇခိူည်ပ်ုန်ဒါႈအ်ုန်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ဟွည်ႇဒီန် ဘံန်ဂဲရောတ်ဒိုည်ႇဒေ တအရာပ်ဇီုဝ်ဂေသရှေမန်။ ယေဆုဒါႈ တဘဲႇဒေ၊ “အခိင်အောဆုတောင် ဒဲႈပဲမာ့်ဒေအရာပ်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","အ်ုန်တောႇ ပေတရု၊ ယာကုပ်ဂါရ် ယောဟန်ဂဲ လာ်ႈရူမ်ဇောမ်ဒေ။ အခိင်ဒီန် ဘံန်ႎိုည်ဒနာပေါ နွံရ်ႈဖိူမ်အ်ုန်ကာပျော၊ ");
INSERT INTO pll_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","အ်ုန်ဒါႈတဂဲ၊ “တန်ုနွံရ်ႈဖိူမ်အောအီုဝ် ဇံန်လူတ်လာည် ခိူည်မိူဝ်ႈအော ဂိူပ်ဆ်ုန်ယံမ်။ ဒဲႈပဲဒါ့်ဂွည်ရဲ့ငိူပ်အော အရာပ်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ဟွည်ႇဒီန် အ်ုန်စွလာ်ႈဒေ ဘိုန်တရီတ်၊ အ်ုန်ဆကူပ်ပွံတ်ဒေ တပါင်ကတဲ ဆုတောင်၊ က်ုန်ပဲန်ဘိူန် ဒဲႈအ်ုန်ဘိုန်ပွံတ် အခိင်နာရီႎိုည်ဒနာအီုဝ်။ ");
INSERT INTO pll_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","အ်ုန်ဆုတောင်ဒါႈ၊ “အိူဝ် ကူန်၊ အိူဝ် ကူန်အော အတွမီဘဲဒေပဲန်ဒိုည်ႇ တွံန်မျိုတွံန်နဲ။ ႎဲႈဒဲႈပဲတ် ဆလော့ႎိုည်ဒနာအီုဝ် ဒိုရ်အော။ ကောည်လိုည် မာည်ဒဲႈအ်ုန်ပဲန် ခိူည်အလိုအောစိ၊ ဒဲႈအ်ုန်ပဲန် ခိူည်အလိုမီ။” ");
INSERT INTO pll_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ဟွည်ႇဒီန် ဘံန်အ်ုန်ႎီရ်ရောတ် အ်ုန်ယိူဝ်ဒေငိူပ် တဘဲႇဒေဂဲ အွည်ကူ ဒါ့်အီတ်ဆငဲႈဒေ။ အ်ုန်ဒါႈ တပေတရု၊ “ရှိမုန် မီဒါ့်အီတ်ဆငဲႈဒေအဲႈ၊ အူနာရီလိုည် မီကာဘဲဒေ အူန်ဆဒိရဲ့ငိူပ်အာ်။” ");
INSERT INTO pll_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","အခိင်ဒီန် အ်ုန်ဒါႈတဂဲ၊ “ဒဲႈပဲအူန်ဆဒိ ဒါ့်ဆုတောင်ရဲ့ငိူပ် အတွမာည်ဒဲႈပဲရောတ် တစုင်ဇာမ်ကဝ်ဆျှူဒီန်။ ဖိူမ်ႎိငျံန်ပဲ ဘိူည်ယိူဝ်ဂံတ်နွံရ်ႈရဲင်၊ တိုပဲဒီန် ရဲင်ဘြေ့ညှိုႈအာ်။” ");
INSERT INTO pll_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","အ်ုန်ႎီရ်လာ်ႈဆုတောင်ထဲင် ခိူည်ပ်ုန်မှာန်ဒေ ရအာတ်ပီ။ ");
INSERT INTO pll_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ဟွည်ႇဒီန် အ်ုန်ႎီရ်လာ်ႈဇူ ရဂွည်တဘဲႇဒေဂဲ အ်ုန်ယိူဝ်ဒေငိူပ် ဘံန်ပ္လေငါည်ဂဲဇံန် ဒါ့်အီတ်ဆငဲႈဒေ။ ခိူည်မောဂဲဒီဒါႈဒေ ႎီရ်ဂြည်တအ်ုန် ဂဲကာနံပ်။ ");
INSERT INTO pll_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","အခိင်ဒီန် အ်ုန်ႎီရ်လာ်ႈထဲင် လိူဝ်ႈအွည်၊ အ်ုန်ဒါႈတဂဲ၊ “ဆေညာ ပဲနံပ်ဒေဒါ့်အီတ် ဂွည်ရလူဒိုည်ႇဒေ မောအူဒီန်အီုဝ်အဲႈ၊ ဆာင်တောယာ့်၊ ငိူပ်မေန်၊ ဟွည်ႇရောတ်ယာ့် အခိင်အာပ်ကွံန်ဘီအီုဝ် တတီဘီယိူဝ်အာဏာ အပေတ်ဘ္လံမ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ယိူဝ်ႇ၊ အယ်လာ်ႈငိူပ်၊ အီအ်ုန်အာပ်အော ရောတ်ဟာအီုဝ်ယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ယာမ်ယေဆုဒါ့်ဂြည်ငဲ၊ အီအ်ုန်လီပ် န်ုတဘဲႇကိူရ်အာရ်ကူ ယုဒပေါရောတ်။ ပ်ုန်ပ္လေါည်လာ်ႈ ယဇ်ပုရောဟိတ်ဒါင်ဂဲ၊ တာဆရာနံပ်ဘေဲႇကျံမ်ဂါရ် ဘီအဆာႇဒါင်ဂဲ၊ ဖုင်ဘီအူက်ုရ်စုဂဲဒီန် ကံင်ဒေဒိူည် ဘိုတ်၊ ဒု လာ်ႈရူမ်ဇောမ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","အီအ်ုန်ယာႈဆေတ်စာဒီန် ရမာည်တံမ်အူန် ဖုင်ဘီအူက်ုရ်စုဂဲ၊ “ဘီပ်ုန်ဆ်ုန်ဘိူန်ပဲ မိူဝ်ႈအီကူ ပ်ုန်ဒီအူရ်ႈအောယာ့်။ ဒဲႈပဲတိုည် ဒိူည်လာ်ႈအ်ုန်လလ။” ");
INSERT INTO pll_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ဘံန်ယုဒရောတ်၊ အ်ုန်လာ်ႈဇူပွံတ်ယေဆု အူဒီန်တောအူဒီန်၊ အ်ုန်တောႇဒါႈ၊ “အိူဝ် တာဆရာ” ဟွည်ႇဒီန် အ်ုန်လာ်ႈအူရ်ႈပွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ဘံန်ညာခိူည်ဒီန် ဘီဂဲ တိုည်ပွံတ်ဒေငံန်ရံတ် ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ယာမ်ဒီန် ယိူဝ်ဘီအူကူတန်ုဂဲ ဒါ့်ဇံင်တပြောဟာဒံတ်ဒီန် ထုလေႈဘိုတ်ဒေ က္လႇပွံတ် မှာည်တာဒါင်ယဇ်ပုရောဟိတ် လှာဟျ်ာ့အ်ုန် တ်ုတ်ဇာ်ႈပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","အခိန်ဒီန် ယေဆုဒါႈ တဂဲ၊ “ပဲလာ်ႈတိုည်အော ညာခိူည်ဘီလာ်ႈတိုည်ဘီစိုန်၊ ကံင်ဒေဒိူည်ဘိုတ်၊ ဒိူည်ဒု ပဲပေါရောတ်အဲႈ။ ");
INSERT INTO pll_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ယာမ်အောဂွည်ရူမ်ဇောမ်ပဲ ပ်ုရ်နောဆာင်ဆောန်ပဲတွံန်ဆငီ တန်ုကျောင်ဗိမာန်၊ ပဲကာတိုည်လိုည်အော။ ကောည်လိုည် အ်ုန်ပဲန်ခိူည်အီုဝ် မိူဝ်ႈအကျံင်တန်ုဘေဲႇကျံမ် ရောတ်တပြေ့စုင်ယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","အခိင်ဒီန် တဘဲႇအ်ုန်ဂဲ ပဲတ်ပဲတ်အ်ုန်၊ ဒူလာ်ႈဆငါည်ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ကွံန်ရလျံင်အူကူ၊ ဖလူမ်ဂိူဝ် ပိဘံန်ချောအူဖီုန် တပါင်တိုဒေ ဘံန်အ်ုန်ဇောမ်လာ်ႈပွံတ် ရဘံန်ယေဆု၊ ဘီဂဲဒီန် ရီန်ပွံတ်ဒေတိုည်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ကောည်လိုည် အ်ုန်ပဲတ်အူန်ပဲတ် ပိဘံန်ချောဒေ လ်ုပ်ရဘံန် ပည်ကာဒါဂြူ ဒူပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ဟွည်ႇဒီန် ဘံန်ဘီဂဲဒိူည်လာ်ႈပွံတ်ယေဆု တဂါင် တာဒါင်ယဇ်ပုရောဟိတ်၊ ယာမ်ဒီန် ယဇ်ပုရောဟိတ်ဒါင်ဂဲ၊ ဘီအဆာႇဒါင်ဝါဒါင်ဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲဒီန် လာ်ႈက်ုရ်စုဒိုည်ႇဒေ တပါင်က်ုရ်မိုန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ပေတရု ဇောမ်လာ်ႈရဘံန်အ်ုန် ဟာကာဒံတ်ကာဆငါည်ဂဲ မောတရန်ုကာင်လာင်က္လာႇဂါင် တာဒါင်ယဇ်ပုရောဟိတ်။ အ်ုန်လာ်ႈ မာ့်ႎငံရ် ဇောမ်ဘီရဲ့ယာမ်ဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ယဇ်ပုရောဟိတ်ဒါင်ဂဲဂါရ် တာဒါင်လူမ်ကောင်ဆီဂဲဒီန် အတွဒဲႈဒေဘိူန် ချတာမ်အမိင်ယံမ် တယေဆု၊ ဂဲဘိူည်လဲမ်ဂံတ် ဆာ့်ဆေ ငဲက်ုရ်ခံတ်လေႈ ဒိုရ်တအ်ုန် ကာယိူဝ်ပဲတ်ဆံင်မှာ်ႈ။ ");
INSERT INTO pll_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ဖုင်ဘီကီုန်ဂဲ ဘိူည်ချောႇဂြည်ဂံတ် ဆာ့်ဆေကာမှာန် တပါင်ယေဆု၊ ကောည်လိုည် ဂဲကာယိူဝ်ပဲတ် ဆာ့်ဆေက်ုရ်တောက်ုရ်ဖြေင်။ ");
INSERT INTO pll_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ဟွည်ႇဒီန် ဘီဂဲပ်ုရ်ဒီ ယိူဝ်ႇဂြည်ဆာ့်ဆေကာမှာန် တပါင်ယေဆု၊ ");
INSERT INTO pll_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ယဲဟွည်ႇယိူဝ်ယဲဆတီုင် ပ်ုန်ဒါႈအ်ုန်၊ ‘အောဒီယာ်ႈလူပဲတ် ဘီဒါတီဒေရ်ုရ် ကျောင်ဗိမာန်အီုဝ်၊ က်ုန်ဟွည်ႇဘိူန်အွည်ဆငီ ကာဒါစိတီဘီရ်ုရ် အောဒီႎီရ်တဲထဲင် ကျောင်ဗိမာန်ဟံရ်။’ ” ");
INSERT INTO pll_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ဘိူည်ဒါႈခိူည်ဒီန် ဆာ့်ဆေပ်ုန်ခါမ်ဂဲ ကာယိူဝ်ပဲတ် အ်ုန်က်ုရ်ဖြေင်ဒေ တပ်ုန်ဂြည်ဂဲဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","တာဒါင်ယဇ်ပုရောဟိတ် ယိူဝ်ႇဇံင်ပွံတ်ဒေ တရအာတ်ဂဲ အ်ုန်ဆ်ုရ်မွံတ်ပွံတ် ယေဆု၊ “ဘီဂဲညာဒေဒါႈငဲတမီခိူည်အီုဝ် မီကာယိူဝ်ငဲ ပ်ုန်ႎီရ်ဒါႈဒေတဂဲအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ကောည်လိုည် ယေဆု ငဲအူမိုတ်လိုည် ကာႎီရ်ဒါႈတဂဲ ဂွည်ညီမ်ညီမ်ဂိူဝ်ဒေ။ တာဒါင်ယဇ်ပုရောဟိတ် ႎီရ်ဆ်ုရ်မွံတ်အ်ုန်၊ “မီမိူဝ်ႈကောမေရှိယ၊ ကွံန်ဖြာ ယိူဝ်မံင်ဂလာ။” ");
INSERT INTO pll_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ယေဆု ႎီရ်ဒါႈ၊ “မိူဝ်ႈအေ့။ ပဲဒီယိူဝ်ဒိုည်ႇဒေငိူပ် ကွံန်ဘီအီုဝ် မာ့်ဒေ လ်ုပ်ခေါန်ညှိုႈ အဖုင်တီုင်ဂိုဖြာ ဘပွံတ်ဆိုရ်အူတ် ပ္လေင် စွလေႈ။” ");
INSERT INTO pll_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","တာဒါင်ယဇ်ပုရောဟိတ်ဒီန် က်ုရ်ဘျဲႈပွံတ်ဂြူဒါဒေ အ်ုန်ဒါႈ၊ “ဆေအယ်လိုထဲင် ဆာ့်ဆေအဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“ပဲဟွည်ႇ ယိူဝ်ဒိုည်ႇဒေ ဆတီုင် ငဲအေႈပ်ုန်ဘဝ်အ်ုန် တဖြာ ကာမိူဝ်ႈ။ ခိူည်မောပဲထာင်အဲႈ။” ဖုင်ဘီဂဲဒီန် ဒါႈဒေဂ်ုမ်ဒိုည်ႇတအ်ုန်၊ အ်ုန်ထိူဝ်ႇဒေခါမ် တာမ်ယံမ်။ ");
INSERT INTO pll_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ဘီပ်ုရ်ဒီဂဲ ဟွည်ႇဘဲ့အိုမ်ဘဲ့ တယေဆု၊ ဂဲအူပ်ငါည် ဒါတီဒေတ်ုမ်ပွံတ်အ်ုန်၊ ဂဲဒါႈတအ်ုန် “အဆေတ်ုမ်မီ ဟောဂြည် ရ်ုရ်မေန်ပရောဖက်။” ဘီဆီုဝ့်ရဲ့ယာမ်ဂဲဒီန်မိူဝ်ႈ တောႇလာ်ႈအ်ုန် ဟွည်ႇဒီန် ပါ်ႈပွံတ်ကီုရ်လာအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ယာမ်ပေတရု ဂွည်ဒေရခြူမ် န်ုလံင်မိုကာင်လာင်က္လာႇ တရခြူမ်ဂါင် တန်ုမှာည်အီပ်ုန် တာဒါင်ယဇ်ပုရောဟိတ်ဂဲဒီန် အူကူရောတ်ပေါ။ ");
INSERT INTO pll_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ဘံန်အ်ုန်ယိူဝ်ဒေငိူပ် ပေတရု ဒါ့်ႎငံရ်ဒေ၊ အ်ုန်ပ်ုန်ရိူဝ်ဒေငိူပ် ဒါႈတအ်ုန်၊ “မီမိူဝ်ႈ အီအ်ုန်ဂွည်ရူမ်ဇောမ် ကွံန်ကုင်နာဇရက် ယေဆုပီ။” ");
INSERT INTO pll_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ကောည်လိုည် ပေတရုဒါႈတအ်ုန်၊ “ပ်ုန်ဒါႈမီဒီန် အောကာနံပ်၊ ကာလှူႈစိ တဖိူမ်အော” အ်ုန်ဟွည်ႇႎဲႈထေင်ငဲဂဲ အ်ုန်လေႈပွံတ်ဒေ လ်ုပ်ရလီပ် ရအာတ်ဂါင်၊ အခိင်ဒီန် အျံရ်တဂေါႇလေႈ ပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ဘံန်မှာည်အီပ်ုန်ဒီန် ယိူဝ်ထဲင်ဒေငိူပ်ပေတရု လိူဝ်ႈရဘံန်၊ အ်ုန်ဒါႈ တဘီအ်ုန်ဇံင်ဒံတ် တပြောဒေဂဲ၊ “အီကူအီုဝ် မိူဝ်ႈဘီလီပ်န်ုဂဲဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ကောည်လိုည် ပေတရု ႎီရ်ႎဲႈထေင်ထဲင်။ ဒံင်အူကာပြေ့ ဘီအ်ုန်ဇံင် တပြောဂဲဒီန် ႎီရ်ဒါႈ တပေတရု၊ “မီမိူဝ်ႈညှိုႈ ဘီလီပ်န်ုဖုင်ဂဲအူကူ ကောပ်မီမိူဝ်ႈ ကွံန်ကုင်ဂါလိလဲ၊ မီကာဘဲဒေ ႎီရ်ထေင်ငဲယဲ။” ");
INSERT INTO pll_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ဟွည်ႇဒီန် ပေတရုဒါႈ၊ “အောယာႇကီန်တိူင်၊ အောဒါႈညှိုႈမိူဝ်ႈ၊ က်ုန်မိူဝ်ႈညှိုႈအောနံပ် ဒဲႈဖြာ ဒဲႈတာမ်တအော။ အောကာနံပ်စိ ဘီပ်ုန်ဂြည်မီဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ဒံင်အူကပြေ့ဒီန် အျံရ်ႎီရ်တဂေါႇထဲင် လိူဝ်ႈဇူႈအာရ်။ အခိင်ဒီန် ပေတရု နွံရ်ႈလှူႈငဲပ်ုန်ဂြည် ယေဆုတဒေ၊ “ကြိူည်အျံရ်တဂေါႇအာရ်လိူဝ်ႈ မီဒီႎဲႈထေင် ဒါႈဒေကာနံပ်အော အွည်လိူဝ်ႈ။” ဟွည်ႇဒီန် အ်ုန်ယာမ်လေႈပွံတ် နီုဝ့်နီုဝ့်ခေါႇခေါႇ။ ");
INSERT INTO pll_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","အခိင်ရႎါရ်ႈဇံဝ် ယဇ်ပုရောဟိတ်ဒါင်ဂဲ၊ ဘီအဆာႇဒါင်ဂဲ၊ တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲဂါရ် တာဒါင်လူမ်ကောင်ဆီဂဲဒီန် ဘံန်ဂဲဟွည်ႇ က်ုရ်မိုန်ဖာည်ဖာည် ဂဲတုယေဆု ဒိူည်လာ်ႈအာပ်ပဲတ်အ်ုန် တတာမျိုဇာပိလတ်။ ");
INSERT INTO pll_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","အခိင်ဒီန် တာမျိုဇာပိလတ် ဆ်ုရ်မွံတ်အ်ုန်၊ “မီမိူဝ်ႈကော ခူန်ဟောခံမ်ယုဒဂဲအဲႈ၊” ယေဆု ႎီရ်ဒါႈ၊ “မိူဝ်ႈအေ့၊ ခိူည်ဒါႈမီဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ယဇ်ပုရောဟိတ်ဒါင်ဂဲ တာင်အပေတ် တွံန်မျိုတွံန်နဲ တယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ကောပ်ခိူည်ဒီန် တာမျိုဇာပိလတ် ႎီရ်ဆ်ုရ်မွံတ်ထဲင် အ်ုန်၊ “ဆေညာ ငဲအူမိုတ်လိုည် မီကာႎီရ်ဒါႈအဲႈ။ ဆတီုင်မေန် ဘ်ုရ်မောဂဲဒါႈဒေ တာင်အပေတ် တပါင်မီ။” ");
INSERT INTO pll_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ဘံန်ယေဆု ကာႎီရ်ဒါႈငဲတဂဲ ဆံင်မှာ်ႈ၊ ပိလတ် ညာအာမ်ပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","တွံန်ရောတ် အခိင်ပ္လေါည်ပသခါ အတွပ်ုန်မှာန်ဘီဂဲ တာမျိုဇာပိလတ် ကျာင်ဒေပ္လေါည်ဒဲႈ ဘီဇာ်ႈထံင် အူကူအူကူ။ ");
INSERT INTO pll_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ယာမ်ပဲန်ႎှီုန် ဘံန်ဘီႎှီုန်ဂဲ ပျံမ်အဆာႇဘီ ဂဲဘ်ုပ်ဒေဇာ်ႈထံင် ဘ္လံမ်၊ တန်ုဂဲဒီန် ပါပည်အီကူဇီုဝ်ဗာရဗ္ဗ။ ");
INSERT INTO pll_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ဖုင်ဘီကီုန်ဂဲ လာ်ႈပေါဒေမှာန် တတာမျိုဇာပိလတ် အတွရ်ုရ်ဒဲႈတဂဲ ခိူည်ပ်ုန်ကျာင်ဒေရ်ုရ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ပိလတ်ဆ်ုရ်မွံတ်ဂဲ၊ “ပဲဆ်ုန်ဒဲႈကော အောပ္လေါည် ခူန်ဟောခံမ်ယုဒအီုဝ် အတွပဲ။” ");
INSERT INTO pll_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ကောပ်ဆေ အ်ုန်တဆ်ုရ်မွံတ်ဂဲ ညာခိူည်ဒီန်၊ အ်ုန်မေန်နံပ် ယဇ်ပုရောဟိတ်ဒါင်ဂဲ ယိူဝ်ဖိူမ်ကနာလို ဆ်ုန်အာပ်ယေဆု တဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ကောည်လိုည် ယဇ်ပုရောဟိတ်ဒါင်ဂဲ ဆောနွံရ်ႈဖိူမ် ဖုင်ဘီက်ုရ်စုဂဲမှာန် တတာမျိုဇာပိလတ် ပ္လေါည်ဒဲႈဂိူဝ်ဗာရဗ္ဗ အတွဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","အခိင်ဒီန် တာမျိုဇာပိလတ် ႎီရ်ဒါႈ တဖုင်ဘီကီုန်ဂဲ၊ “က်ုန်ဒါႈခိူည်ဒီန် ပ်ုန်တောႇပဲ ခူန်ဟောခံမ်ယုဒအီုဝ် ခိူည်မောပဲ ဆ်ုန်ဒဲႈအောရ်ုရ် တအ်ုန်အဲႈ။” ");
INSERT INTO pll_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ဂဲႎီရ်ပြိုႈဒေဒါႈ၊ “တာင်စံပ်အ်ုန် တတီုင်ဒါ်ႈစံပ်တာႇတီ။” ");
INSERT INTO pll_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ပိလတ်ဆ်ုရ်မွံတ်ဂဲ၊ “အပေတ်ဆေ အ်ုန်က်ုရ်လူတ်အဲႈ။” ဂဲဒီန် ႎရပြိုႈဒေဒါႈ၊ “တာင်စံပ်အ်ုန် တတီုင်ဒါ်ႈစံပ်တာႇတီ။” ");
INSERT INTO pll_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ပိလတ် ဆ်ုန်ဒဲႈဖိူမ်ဖုင်ဘီက်ုရ်စုဂဲဟျာႈ၊ အ်ုန်ပ္လေါည်ဒဲႈပွံတ် ဗာရဗ္ဗ အတွဂဲ။ ဟွည်ႇဒီန် အ်ုန်ဆူတ်ဂဲ ဒါရဖျြံတ်လ်ုရ်ႈပွံတ်ယေဆု အာပ်ဒဲႈပဲတ်တဂဲ အတွပျံမ်ယံမ်အ်ုန် တတီုင်ဒါ်ႈစံပ်တာႇတီ။ ");
INSERT INTO pll_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","အခိင်ဒီန် ဘီဆီုဝ့်ဂဲ တောႇဒေဒိူည်လာ်ႈယေဆု န်ုကာင်လာင်က္လာႇ တရခြူမ်ဟော တလူမ်တရာ၊ ဂဲဒဲႈပွံတ် ဘီဆီုဝ့်ဂဲက်ုရ်စုဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ဟွည်ႇဒီန် ဂဲဒဲႈပွံတ်ယေဆု ချူပ်ဂြူ ညောတ်မိုင်ကံမ်၊ ဘံန်ဂဲဟွည်ႇ တဲင်ကာႇတီုင်ႎံရ်ပ်ုရ်အောႇ ဒဲႈအ်ုန်ပဲန် မှာ့်ပါန်ဂုင် ချူပ်ဒဲႈပွံတ် တပါင်ကိင်အ်ုန်၊ ");
INSERT INTO pll_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ဟွည်ႇဒီန် ဂဲကူပ်ကိင်ဒေရိုဆေ ဒါႈတအ်ုန်၊ “ဒဲႈအဆာႇ ခူန်ဟောခံမ်ယုဒ လှိူင်။” ");
INSERT INTO pll_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ဆဲႈဒီန် ဂဲလ်ုရ်ႈပွံတ်ကိင်အ်ုန် တဒု တီုင်ခွည်ခဲ၊ ဂဲဘဲ့အိုမ်ဘဲ့၊ ဂဲမာ့်ပ်ုရ်ဒ်ုပ်ဒေ ညာရာင်ဂြူပ်ပွံတ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","အခိင်ဂဲဟွည်ႇ ပ်ုန်ဘဝ်ယူမ်ဆငဲႈအ်ုန်၊ ဂဲလူည့်ပဲတ် ဂြူညောတ်မိုင်ကံမ်အ်ုန်ဒီန် ဂဲႎီရ်ဒဲႈအ်ုန် ချူပ်ဒေဒါ ဆဒေါဒေ။ ဟွည်ႇဒီန် ဂဲထုဒေဒိူည်လာ်ႈပွံတ်အ်ုန် အတွတာင် တတီုင်ဒါ်ႈစံပ်တာႇတီ။ ");
INSERT INTO pll_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ယာမ်ဒီန် ဘံန်ဂဲလာ်ႈယိူဝ် အီကူဇီုဝ်ရှိမုန် ယိူဝ်ႇဒိုရ်တရူ ႎက်ုရ်ခါမ်ဂဲတဒေင်၊ ဘီဆီုဝ့်ဂဲ ဘဲဒေဟောမ် ဆူတ်အ်ုန်ကွံတ်ပွံတ် တီုင်ဒါ်ႈစံပ်တာႇတီ ယေဆု။ (ရှိမုန်ဒီန် မိူဝ်ႈကွံန်ကုင်ကုရေနေ၊ မိူဝ်ႈကူန် အာလေဇန္ဒြုဂါရ် ရုဖု။) ");
INSERT INTO pll_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ဂဲတောႇဒေဒိူည်လာ်ႈယေဆု တအရာပ်ဂေါလဂေါသ၊ တီုင်အိုမ်ငဲအ်ုန်ဒီန်မိူဝ်ႈ၊ “အရာပ်က်ုန်အာင်ကိင်။” ");
INSERT INTO pll_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","အရာပ်ဒီန် ဂဲဒဲႈအ်ုန်တျံင် အိုမ်မရာတ်က်ုရ်ဆူရ် ဇောမ်ဆန်ုမ် ဇီုဝ်မုရန်၊ ကောည်လိုည် ယေဆုကာတျံင်စိ။ ");
INSERT INTO pll_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ဟွည်ႇဒီန် ဂဲတာင်ပွံတ်အ်ုန် တပါင်တီုင်ဒါ်ႈစံပ်တာႇတီ၊ က်ုန်မိူဝ်ႈဂြူရ်ုန်ဒါအ်ုန် ဂဲက်ုရ်ချမဲတဒေ အဆေဒီဘိူန်။ ");
INSERT INTO pll_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ယာမ်ဂဲတာင်အ်ုန် တတီုင်ဒါ်ႈစံပ်တာႇတီဒီန် မိူဝ်ႈအခိင်ရႎါရ်ႈ တီမ်နာရီ။ ");
INSERT INTO pll_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ဘေဲႇပ်ုန်ဘဝ်ဒဲႈဆဒိ တပါင်တီုင်အ်ုန်ဒီန် ဒါႈ၊ “ခူန်ဟောခံမ်ယုဒဂဲ။” ");
INSERT INTO pll_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ဂဲတာင်ရူမ်ပွံတ် ဘီစိုန်အာရ်ကူဒီန် ဇောမ်ယေဆု၊ တတီုင်ဒါ်ႈစံပ်တာႇတီ တီုင်လ်ုပ်ခေါန်ညှိုႈအူကူ၊ တီုင်လ်ုပ်ခေါန်ကာတ်အူကူ။ ");
INSERT INTO pll_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ဘီအ်ုန်လာ်ႈက်ုရ်ခါမ် အရာပ်ဒီန် ႎံတ်ႎံတ်ပွံတ်ကိင်ဒေ ငဲပ်ုန်ဘဝ်ဒါႈ တယေဆု၊ “ဟိူည်၊ မီဒါႈဒေယာ်ႈပ်ုန်လူ ကျောင်ဗိမာန် တန်ုအွည်ဆငီ အီအ်ုန်ဒါႈဒေႎီရ်ရ်ုရ်ဒီန်။” ");
INSERT INTO pll_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","“လေႈပွံတ်မီ ဒိုရ်တီုင်ဒါ်ႈစံပ်တာႇတီ အူဒီန်အီုဝ် ပ်ုန်လောတ် ကောည်ဘိူဝ်တိုမီ။” ");
INSERT INTO pll_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","စံမ်ညာခိူည်ဒီန် ယဇ်ပုရောဟိတ်ဒါင်ဂဲဂါရ် တာဆရာနံပ်ဘေဲႇကျံမ်ဂဲ ပ်ုန်ဘဝ်ယူမ်ဆငဲႈဒိုည်ႇ ယေဆု၊ ဂဲက်ုရ်ဒါႈတဒေ အူကူတောအူကူ၊ “အ်ုန်ဘိူည်ပ်ုန်လောတ်ဒဲႈဂံတ် ဘီဟံရ်၊ အ်ုန်ကာဘဲလိုည်ဒေ ပ်ုန်လောတ်တိုဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","အယ်က်ုန်ယိူဝ်အယ်ငိူပ် မေရှိယ၊ ခူန်ဟောခံမ်ဣသရေလ လေႈပွံတ်ဒေ ဒိုရ်တီုင်ဒါ်ႈစံပ်တာႇတီ အူဒီန်အီုဝ်၊ အယ်ဒီညှိုမ်အ်ုန်။” ယာမ်ဒီန် ဘီအာရ်ကူ ဘ်ုပ်တာင်ရူမ်ဇောမ်ယေဆု တတီုင်ဒါ်ႈစံပ်တာႇတီဒီန်မိူဝ်ႈ ပ်ုန်ဘဝ်ယူမ်ဆငဲႈဒိုည်ႇအ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ရောတ်အခိင်က်ုန်ဒီဆငီ အံပ်လံပ်ဆီင်ပေါဒေ ဖလူမ်ဒိုည်ႇတကပီုန်ကုင်ဒီန် မောဟိူဝ့်ဆံန် အွည်နာရီ။ ");
INSERT INTO pll_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","တအခိင်အွည်နာရီ ယေဆုပြိုႈဒေဒါႈ၊ “ဧလိ၊ ဧလိ၊ လာမရှာဗခသာနိ” အိူမ်ငဲအ်ုန်ဒီန် မိူဝ်ႈ၊ “အိူဝ် ဖြာအော၊ အိူဝ် ဖြာအော၊ ကောပ်ဆေ မီပဲတ်ပဲတ်အော ညာခိူည်အီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ဘံန်ဘီဂဲပ်ုရ်ဒီ ဒါ့်ဇံင်တပြောဒီန် ယိူဝ်ဒေဆတီုင်ငဲအ်ုန် ဂဲဒါႈ၊ “ဆတီုင်ဘိူဝ်၊ အ်ုန်ဒါ့်တောႇ ဧလိယ။” ");
INSERT INTO pll_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","အခိင်ဒီန် ဘီအူကူ ခူန်လာ်ႈတိူဝ်ႈဒေဒိူည် အိုမ်ဘူရ်ႈပ္လိူည်၊ ဟွည်ႇစူတ် တအိုမ်မရာတ်ဘြာင် ဒဲႈအ်ုန်နာ့်၊ ႎှတကီုရ်တောႇတီုင်ခွည်ခဲ ယီုဝ်ပွံတ်တမူရ်ယေဆု ဒဲႈအ်ုန်တျံင်၊ ဟွည်ႇဒီန် အ်ုန်ဒါႈ၊ “ရဲ့ဘိူဝ်အယ်ငိူပ်၊ ဧလိယ ဒီရောတ်ကောဒေ ချလေႈအ်ုန်ရခြူမ် ဒိုရ်တီုင်ဒါ်ႈစံပ်တာႇတီအီုဝ်။” ");
INSERT INTO pll_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ယေဆု ဟွည်ႇပြိုႈရျံင်ယာမ် အဆာႇအ်ုန် ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","အခိင်ဒီန် ဖကံင် န်ုကျောင်ဗိမာန် က်ုရ်ဆဲႈပဲန်ပွံတ်ဒေ အာရ်က်ုန်ဒါႈ ယိူဝ်ႇဒိုရ်တကီုရ်ႎိူည် မောဂိူပ်ရောတ်ရခြူမ်။ ");
INSERT INTO pll_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","တာဒါင်ဟိုဆီုဝ့်အူကူ ဒါ့်ဇံင်ဒေတရအာတ် တီုင်ဒါ့်စံပ်တာႇတီဒီန် ဘံန်အ်ုန်ယိူဝ်ဒေငိူပ် ခိူည်မောယေဆု ညာဒေယံမ်။ အ်ုန်ဒါႈ၊ “ဘီကူအီုဝ် မိူဝ်ႈညှိုႈ ကွံန်ဖြာယာ့်။” ");
INSERT INTO pll_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","အီပ်ုန်ဂဲပ်ုရ်ဒီ ဒါ့်ဇံင်ရဲ့ဒေငိူပ် တအရာပ်ဟာရဆငါည်။ တန်ုဂဲဒီန်မိူဝ်ႈ မာရိ ကွံန်ကုင်မာဂဒလ၊ မာရိ မာယာကုပ်ဒျံတ်ဂါရ် ယောသေ၊ ပါပည် ရှာလုံ။ ");
INSERT INTO pll_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ယာမ်ယေဆု ဂွည်တန်ုကပီုန်ကုင်ဂါလိလဲ ဂဲဒီန် မိူဝ်ႈဒိုည်ႇဘီဇောမ်ရဘံန် ကျာင်ဒေဟျံင်လူမ်လာအ်ုန်။ ဆဲႈဂဲဒီန် ယိူဝ်ထဲင်ဘိူဝ် အီပ်ုန်ဟံရ်ဂဲ ဘာ့်ဘာ့်ဘိူဝ်ဘိူဝ် လာ်ႈရူမ်ဇောမ်အ်ုန် တကုင်ယေရုရှလင်။ ");
INSERT INTO pll_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ဆငီဒီန် မိူဝ်ႈဆငီရဲန် (ကြိူည်ဆငီဆဒါင်)။ ဘံန်ရောတ် အခိင်စူန်ဆငီဒံတ်လီပ်၊ ");
INSERT INTO pll_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ကွံန်ကုင်အရိမဿဲ ယောသပ် ရောတ်ပေါ။ အ်ုန်မိူဝ်ႈ ဘီလီပ်န်ုဖုင်ကောင်ဆီဂဲ၊ ယိူဝ်ဂုင်ဒါင် ထိူဝ်ႇဘီရိုဆေဒေ အ်ုန်မိူဝ်ႈဘီရဲ့မောင် ကပီုန်ကုင်ဖြာ။ အ်ုန်ပ်ုန်ႎါဝ်ပွံတ်ဒေ လီပ်တရအာတ် တာမျိုဇာပိလတ် မှာန်ပွံတ်တိုယံမ်ယေဆု။ ");
INSERT INTO pll_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ဘံန်တာမျိုဇာပိလတ် ယိူဝ်ဒေဆတီုင် ယေဆုဟွည်ႇယံမ် အ်ုန်ညာအာမ်ပွံတ်ဒေ၊ အ်ုန်တောႇပွံတ်ဒေဆ်ုရ်မွံတ် တာဒါင်ဟိုဆီုဝ့် ယေဆုဟွည်ႇယံမ်ဇီုဝ့်၊ ညှံမ်ဇီုဝ့်။ ");
INSERT INTO pll_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ဘံန်တာမျိုဇာပိလတ် ဟွည်ႇယိူဝ်ဒေဆတီုင် ငဲပ်ုန်တာင်ပျ တာဒါင်ဟိုဆီုဝ့်ဒီန်၊ အ်ုန်ဒဲႈပွံတ်တိုဘီယံမ် တယောသပ်။ ");
INSERT INTO pll_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","အခိင်ဒီန် ယောသပ် ပျာ်ႈလေႈပွံတ်တိုဘီယံမ်ဒီန်၊ ဒိုရ်တီုင်ဒါ်ႈစံပ်တာတီ၊ ဘံန်ဟွည်ႇဇိူရ်ႈဒေဒိူည် ပိဘံန်ချော၊ အ်ုန်က်ုရ်ပ်ုရ်ပွံတ်အ်ုန် လာ်ႈအူန်ပဲတ် တဘီုင်ဆာင်ခဲင်မို ပ်ုန်စာ်ႈအူန်ဒေ။ ဟွည်ႇဒီန် အ်ုန်ဂ္လိင်ပိအူန်ပဲတ်မို တမူရ်ဘီုင်ဆာင်ခဲင်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","မာရိ ကွံန်ကုင်မာဂဒလဂါရ် မာရိ မာယောသေဂဲဒါ့်ငိူပ်၊ ယိူဝ်ပွံတ်ဒေငိူပ် အရာပ်ရအူန်တိုယေဆုဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ဟွည်ႇဘိုန်ဆငီဆဒါင် မာရိ ကွံန်ကုင်မာဂဒလ၊ မာရိ မာယာကုပ်ဂါရ် ရှာလုံဂဲ ဒါႈဒေလာ်ႈဖွံန်ဒဲႈနံမ်ဆာ တတိုယံမ်ယေဆု ဂဲဇိူရ်ႈဒေဒိူည် နံမ်ဆာအူရ်ႈငှူရ်။ ");
INSERT INTO pll_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","န်ုပူရ်ဆငီ တဆငီဇူႈအူ ရႎါရ်ႈဇံဝ်ဇံဝ်၊ အခိင်ဆငီလေႈ ဂဲလာ်ႈပေါဒိုည်ႇဒေ တဘီုင်ဆာင်ခဲင်။ ");
INSERT INTO pll_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ယာမ်လာ်ႈတရဒေင် ဂဲလာည်က်ုရ်မိုန်တဒေ အူကူတောအူကူ၊ “အဆေဒီဂ္လိင်ပိူဝ်ႈဒဲႈ မိုပိတမူရ် ဘီုင်ဆာင်ခဲင်ဒီန် အတွအယ်အဲႈ။” (ကလူမ်မိုဒီန် ဒါင်ညှိုႈညှိုႈ။) ");
INSERT INTO pll_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","အခိင်ဒီန် ဂဲယိူဝ်ဒေငိူပ် မိုဒီန်ဟွည်ႇဂ္လိင်ပိူဝ်ႈပဲတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ဘံန်ညာခိူည်ဒီန် ဂဲလီပ်ပွံတ် တန်ုဘီုင်ဆာင်ခဲင်၊ ဘံန်ဂဲယိူဝ်ဒေငိူပ် ကွံန်ရလျံင်အူကူ ဒါဆဒေါလှိူင်ဘ္လောႇဘ္လူႈ ဒါ့်မာ့်ဒေလ်ုပ်ခေါန်ညှိုႈ ဂဲညာယောယ်ုရ်ယ်ုရ်ဒိုည်ႇပွံတ်ဒေ။ ");
INSERT INTO pll_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","အ်ုန်ဒါႈ၊ “ပဲမာည်ယိူဝ်ဖိူမ် ယောယ်ုရ်ယ်ုရ်။ အောနံပ်အေ့ ပဲလာ်ႈပေါဒေလဲမ် ကွံန်ကုင်နာဇရက်ယေဆု ဘ်ုပ်ခါမ်တာင် တပါင်တီုင်ဒါ်ႈစံပ်တာႇတီဒီန်။ အ်ုန်ဟွည်ႇႎီရ်ယိူဝ်ႇအီမ်ဒိုရ်ယံမ်၊ ကာယိူဝ်ယာ့်အ်ုန် က်ုရ်တောအီုဝ်။ ငိူပ်မေန်၊ ဟာရအူန်တိုယံမ်အ်ုန်နာန်။ ");
INSERT INTO pll_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","အူဒီန်ဒဲႈပဲလာ်ႈ ဂြည်ပွံတ်ဆဒါင်အီုဝ် တတဘဲႇအ်ုန်ဂဲဂါရ် ပည်တပေတရု၊ ‘အ်ုန်စွလာ်ႈ တကုင်ဂါလိလဲ ရအာတ်ပဲယာ့်၊ ပဲဒီလာ်ႈ ယိူဝ်ဒေငိူပ်အ်ုန် အရာပ်ဒီန်၊ ခိူည်ငဲပ်ုန်ဂြည်အူန်အ်ုန်တပဲ။’” ");
INSERT INTO pll_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ဘံန်ညာခိူည်ဒီန် ပည်ဂဲဖိူမ်နာ့်နွံရ်ႈ ယောယ်ုရ်ယ်ုရ် ဒူလေႈဒိုည်ႇပွံတ်ဒေ ဒိုရ်ဘီုင်ဆာင်ခဲင်။ ကောပ်မိူဝ်ႈဂဲ ယောလူတ်လာည် တအဆေမိူဝ်ႈ ဂဲကာယာႇဂြည်။  ");
INSERT INTO pll_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ဟွည်ႇဒီန် ယေဆု ႎီရ်ယိူဝ်ႇအီမ်ဒိုရ်ယံမ် န်ုပူရ်ဆငီ ဆငီဇူႈအူ ရႎါရ်ႈဇံဝ်ဇံဝ်၊ အ်ုန်ပျလိူရ်ႈတိုဒေ တမာရိ ကွံန်ကုင်မာဂဒလ ရအာတ်၊ မာရိဒီန်မိူဝ်ႈ ယေဆု တိူမ်ရူပ်လေႈဒဲႈပဲတ် ကီုရ်နံမ်ချှိုပူရ်တို ဒိုရ်အ်ုန်။ ");
INSERT INTO pll_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ယာမ်ဘူဂေါဘူဆေအ်ုန်ဂဲ နာ့်နွံရ်ႈဖိူမ်ကာပျော ဒါ့်ယာမ် အ်ုန်လာ်ႈဇူ ဂြည်ပျပွံတ်တဂဲ အကျံင်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ဟွည်ႇဒီန် ဘံန်ဂဲယိူဝ်ဒေဆတီုင် ပ်ုန်ဂြည်မာရိ အကျံင်ယေဆုႎီရ်အီမ်ဒေဂါရ် အကျံင်ယိူဝ်ဒေငိူပ်ဒေဒိူည်အ်ုန်ဒီန်၊ ဂဲကာညှိုမ်ပဲတ်။ ");
INSERT INTO pll_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ယာမ်တဘဲႇအ်ုန်အာရ်ကူ လာ်ႈဒေင်တရူ ယေဆု ပျလိူရ်ႈတိုဒေ ပည်ပုင်ရံင်က်ုရ်လှာႇ တဂါရ်အာရ်ကူ။ ");
INSERT INTO pll_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ဂါရ်ဒီန်အာရ်ကူမိူဝ်ႈ ႎီရ်ရောတ်ဒေ ဂြည်ပျတတဘဲႇဟံရ်၊ ကောည်လိုည် ဂဲကာညှိုမ်ပဲတ် အကျံင်ဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ယာမ်တဘဲႇကိူရ်အူကူဂဲ ဒါ့်မာ့်ဟောမ်ပ်ုန်ဟောမ် ယေဆုပျတိုဒေတဂဲ။ ဟွည်ႇဒီန် အ်ုန်ႎှိုင်ပွံတ်တဂဲ၊ ကောပ်မိူဝ်ႈဂဲကာယိူဝ်ဖိူမ်ညှိုမ်၊ နွံရ်ႈဖိူမ်ခေါ ကာညှိုမ်ငဲပ်ုန်ဂြည် အီအ်ုန်ယိူဝ်ဒေငိူပ် အကျံင်အ်ုန်ႎီရ်ယိူဝ်ႇအီမ်ဒေဒီန်။ ");
INSERT INTO pll_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","အ်ုန်ဒါႈတဂဲ၊ “ဒဲႈပဲလာ်ႈဟောဂြည်ဒိုည်ႇ ဆဒါင်ကျအီုဝ် တန်ုကံမ်ဖာ အရာပ်တွံန်တီတွံန်ဒဲန်အေ့။ ");
INSERT INTO pll_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","အဆေမိူဝ်ႈဟွည်ႇ အီအ်ုန်ယိူဝ်ဖိူမ်ညှိုမ် ခါမ်ဗတ္တိဇံဒီန် ဒီဘိူန်ဒေပ်ုန်လောတ်။ အီအ်ုန်ကာယိူဝ်ဖိူမ်ညှိုမ်ဒီန် ဒီဘ်ုပ်ဒေခါမ်ဂ်ုမ်တရာ တာမ်အပေတ်။ ");
INSERT INTO pll_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","အီအ်ုန်ယိူဝ်ဖိူမ်ညှိုမ်ဒီန် ဒီဘိူန်ဒေဒါအဖုင်တီုင်ဂို အတွရ်ုရ်နမိလက္ခဏာ၊ ဂဲဒီဒါဇီုဝ်အော ရူပ်လေႈဒိုည်ႇ ကီုရ်နံမ်ချှိုဂဲ၊ ဂဲဒီဒါႈဒိုည်ႇငဲက်ုရ်လှာႇ။ ");
INSERT INTO pll_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ဂဲက်ုန်ဒါတီဒေ တိုည်ကံင်ဟိင် က်ုန်ကာမိူဝ်ႈ ဂဲဘိူည်က်ုရ်လူတ်ဂံတ်ဒေ တျံင်ခံင်ပဲန်က်ုရ်ဘူရ်ဆမာယံမ် ကာပဲန်စိဖေတဂဲ။ ဂဲဒီဂံမ်တီဒေ တပါင်ဘီဆူဖိူဝ်နာ ဒီချံမ်ဆာဒိုည်ႇဒေ။” ");
INSERT INTO pll_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","အခိင်ဒီန် ကီုရ်ညာယေဆု ဒါႈငဲပ်ုန်ဟွည်ႇ တဂဲ၊ အ်ုန်ဟွည်ႇဘ်ုပ်ခါမ် တိူဝ်ႈဟာ့်ပွံတ် တပ္လေင် အ်ုန်မာ့်ပွံတ်ဒေ လ်ုပ်တီ ခေါန်ညှိုႈဖြာ။ ");
INSERT INTO pll_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","အခိင်ဒီန် တဘဲႇအ်ုန်ဂဲ လာ်ႈဟောဂြည်ဒိုည်ႇတရာ အရာပ်တွံန်တီတွံန်ဒဲန်၊ ကီုရ်ညာဖြာမိူဝ်ႈ ရ်ုရ်ရူမ်ဇောမ်ဂဲ၊ ဟွည်ႇဒီန် အ်ုန်ဒါနမိလက္ခဏာ ခံင်မှိူမ်အာမ် ပျဆာ့်ဆေ တအကျံင်တရာ ပ်ုန်ဟောဂြည်ဂဲမှာန်။  ");
INSERT INTO pll_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","အီပ်ုန်ဂဲဒီန် လာ်ႈဇူပေတရုဂါရ် ဘူဂေါအ်ုန်ဂဲ ပ်ုန်အဲမ်ဒေတာင်ပျ ဘ်ုရ်ယိူဝ်အကျံင် ပ်ုန်က်ုရ်တူႈဒေဂဲ။ ");
INSERT INTO pll_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","ဟွည်ႇဒီန် ယေဆုတိူဝ်ႈတိုဒေ ပ္လေါည်လာ်ႈတဘဲႇဒေ ဒဲႈဂဲဂြည်လေႈ ငဲတရာဖြာ က်ုရ်ဆဲင်ဒေ တအကျံင်ထာဝရ ပ်ုန်လောတ်အီုဝ် ယိူဝ်ႇဒိုရ်အရာပ်လ်ုပ်လေႈဆငီ မောတအရာပ်လ်ုပ်လီပ်ဆငီ။");
ALTER TABLE pll_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
