﻿USE sofia;
DROP TABLE IF EXISTS sofia.srp1868_vpl;
CREATE TABLE srp1868_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES srp1868_vpl WRITE;
INSERT INTO srp1868_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","У почетку створи Бог небо и земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","А земља беше без обличја и пуста, и беше тама над безданом; и дух Божји дизаше се над водом. ");
INSERT INTO srp1868_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","И рече Бог: Нека буде светлост. И би светлост. ");
INSERT INTO srp1868_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","И виде Бог светлост да је добра; и растави Бог светлост од таме. ");
INSERT INTO srp1868_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","И светлост назва Бог дан, а таму назва ноћ. И би вече и би јутро, дан први. ");
INSERT INTO srp1868_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Потом рече Бог: Нека буде свод посред воде, да раставља воду од воде. ");
INSERT INTO srp1868_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","И створи Бог свод, и растави воду под сводом од воде над сводом; и би тако. ");
INSERT INTO srp1868_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","А свод назва Бог небо. И би вече и би јутро, дан други. ");
INSERT INTO srp1868_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Потом рече Бог: Нека се сабере вода што је под небом на једно место, и нека се покаже суво. И би тако. ");
INSERT INTO srp1868_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","И суво назва Бог земља, а зборишта водена назва мора; и виде Бог да је добро. ");
INSERT INTO srp1868_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Опет рече Бог: Нека пусти земља из себе траву, биље, што носи семе, и дрво родно, које рађа род по својим врстама, у коме ће бити семе његово на земљи. И би тако. ");
INSERT INTO srp1868_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","И пусти земља из себе траву, биље, што носи семе по својим врстама, и дрво, које рађа род, у коме је семе његово по његовим врстама. И виде Бог да је добро. ");
INSERT INTO srp1868_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","И би вече и би јутро, дан трећи. ");
INSERT INTO srp1868_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Потом рече Бог: Нека буду видела на своду небеском, да деле дан и ноћ, да буду знаци временима и данима и годинама; ");
INSERT INTO srp1868_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","и нека светле на своду небеском, да обасјавају земљу. И би тако. ");
INSERT INTO srp1868_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","И створи Бог два видела велика: видело веће да управља даном, и видело мање да управља ноћу, и звезде. ");
INSERT INTO srp1868_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","И постави их Бог на своду небеском да обасјавају земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","И да управљају даном и ноћу, и да деле светлост од таме. И виде Бог да је добро. ");
INSERT INTO srp1868_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","И би вече и би јутро, дан четврти. ");
INSERT INTO srp1868_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Потом рече Бог: Нека врве по води живе душе, и птице нека лете изнад земље под свод небески. ");
INSERT INTO srp1868_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","И створи Бог китове велике и све живе душе што се мичу, што проврвеше по води по врстама својим, и све птице крилате по врстама њиховим. И виде Бог да је добро; ");
INSERT INTO srp1868_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","и благослови их Бог говорећи: Рађајте се и множите се, и напуните воду по морима, и птице нека се множе на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","И би вече и би јутро, дан пети. ");
INSERT INTO srp1868_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Потом рече Бог: Нека земља пусти из себе душе живе по врстама њиховим, стоку и ситне животиње и звери земаљске по врстама њиховим. И би тако. ");
INSERT INTO srp1868_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","И створи Бог звери земаљске по врстама њиховим, и стоку по врстама њеним, и све ситне животиње на земљи по врстама њиховим. И виде Бог да је добро. ");
INSERT INTO srp1868_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Потом рече Бог: Да начинимо човека по свом обличју, као што смо ми, који ће бити господар од риба морских и од птица небеских и од стоке и од целе земље и од свих животиња што се мичу по земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","И створи Бог човека по обличју свом, по обличју Божјем створи га; мушко и женско створи их. ");
INSERT INTO srp1868_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","И благослови их Бог, и рече им Бог: Рађајте се и множите се, и напуните земљу, и владајте њом, и будите господари од риба морских и од птица небеских и од свих звери што се миче по земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","И још рече Бог: Ево, дао сам вам све биље што носи семе по свој земљи, и сва дрвета родна која носе семе; то ће вам бити за храну. ");
INSERT INTO srp1868_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","А свим зверима земаљским и свим птицама небеским и свему што се миче на земљи и у чему има душа жива, дао сам сву траву да једу. И би тако. ");
INSERT INTO srp1868_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Тада погледа Бог све што је створио, и гле, добро беше веома. И би вече и би јутро, дан шести. ");
INSERT INTO srp1868_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Тако се доврши небо и земља и сва војска њихова. ");
INSERT INTO srp1868_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","И сврши Бог до седмог дана дела своја, која учини; и почину у седми дан од свих дела својих, која учини; ");
INSERT INTO srp1868_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","и благослови Бог седми дан, и посвети га, јер у тај дан почину од свих дела својих, која учини. ");
INSERT INTO srp1868_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","То је постање неба и земље, кад посташе, кад Господ Бог створи земљу и небо, ");
INSERT INTO srp1868_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","И сваку биљку пољску, докле је још не беше на земљи, и сваку травку пољску, докле још не ницаше; јер Господ Бог још не пусти дажда на земљу, нити беше човека да ради земљу, ");
INSERT INTO srp1868_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","али се подизаше пара са земље да натапа сву земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","А створи Господ Бог човека од праха земаљског, и дуну му у нос дух животни; и поста човек душа жива. ");
INSERT INTO srp1868_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","И насади Господ Бог врт у Едему на истоку; и онде намести човека, ког створи. ");
INSERT INTO srp1868_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","И учини Господ Бог, те никоше из земље свакаква дрвећа лепа за гледање и добра за јело, и дрво од живота усред врта и дрво од знања добра и зла. ");
INSERT INTO srp1868_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","А вода течаше из Едема натапајући врт, и оданде се делише у четири реке. ");
INSERT INTO srp1868_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Једној је име Фисон, она тече око целе земље евилске, а онде има злата, ");
INSERT INTO srp1868_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","и злато је оне земље врло добро; онде има и бдела и драгог камена ониха. ");
INSERT INTO srp1868_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","А другој је реци име Геон, она тече око целе земље хуске. ");
INSERT INTO srp1868_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","А трећој је реци име Хидекел, она тече к асирској. А четврта је река Ефрат. ");
INSERT INTO srp1868_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","И узевши Господ Бог човека намести га у врту едемском, да га ради и да га чува. ");
INSERT INTO srp1868_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","И запрети Господ Бог човеку говорећи: Једи слободно са сваког дрвета у врту; ");
INSERT INTO srp1868_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","али с дрвета од знања добра и зла, с њега не једи; јер у који дан окусиш с њега, умрећеш. ");
INSERT INTO srp1868_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","И рече Господ Бог: Није добро да је човек сам; да му начиним друга према њему. ");
INSERT INTO srp1868_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Јер Господ Бог створи од земље све звери пољске и све птице небеске, и доведе к Адаму да види како ће коју назвати, па како Адам назове коју животињу онако да јој буде име; ");
INSERT INTO srp1868_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","и Адам надеде име сваком живинчету и свакој птици небеској и свакој звери пољској; али се не нађе Адаму друг према њему. ");
INSERT INTO srp1868_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","И Господ Бог пусти тврд сан на Адама, те заспа; па му узе једно ребро, и место попуни месом; ");
INSERT INTO srp1868_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","и Господ Бог створи жену од ребра, које узе Адаму, и доведе је к Адаму. ");
INSERT INTO srp1868_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","А Адам рече: Сада ето кост од мојих кости, и тело од мог тела. Нека јој буде име човечица, јер је узета од човека. ");
INSERT INTO srp1868_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Зато ће оставити човек оца свог и матер своју, и прилепиће се к жени својој, и биће двоје једно тело. ");
INSERT INTO srp1868_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","А беху обоје голи. Адам и жена му, и не беше их срамота. ");
INSERT INTO srp1868_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Али змија беше лукава мимо све звери пољске, које створи Господ Бог; па рече жени: Је ли истина да је Бог казао да не једете са сваког дрвета у врту? ");
INSERT INTO srp1868_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","А жена рече змији: Ми једемо род са сваког дрвета у врту; ");
INSERT INTO srp1868_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","само род с оног дрвета усред врта, казао је Бог, не једите и не дирајте у њ, да не умрете. ");
INSERT INTO srp1868_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","А змија рече жени: Нећете ви умрети; ");
INSERT INTO srp1868_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","него зна Бог да ће вам се у онај дан кад окусите с њега отворити очи, па ћете постати као богови и знати шта је добро шта ли зло. ");
INSERT INTO srp1868_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","И жена видећи да је род на дрвету добар за јело и да га је милина гледати и да је дрво врло драго ради знања, узабра род с њега и окуси, па даде и мужу свом, те и он окуси. ");
INSERT INTO srp1868_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Тада им се отворише очи, и видеше да су голи; па сплетоше лишћа смоковог и начинише себи прегаче. ");
INSERT INTO srp1868_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","И зачуше глас Господа Бога, који иђаше по врту кад захлади; и сакри се Адам и жена му испред Господа Бога међу дрвета у врту. ");
INSERT INTO srp1868_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","А Господ Бог викну Адама и рече му: Где си? ");
INSERT INTO srp1868_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","А он рече: Чух глас Твој у врту, па се поплаших, јер сам го, те се сакрих. ");
INSERT INTO srp1868_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","А Бог рече: Ко ти каза да си го? Да ниси јео с оног дрвета што сам ти забранио да не једеш с њега? ");
INSERT INTO srp1868_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","А Адам рече: Жена коју си удружио са мном, она ми даде с дрвета, те једох. ");
INSERT INTO srp1868_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","А Господ Бог рече жени: Зашто си то учинила? А жена одговори: Змија ме превари, те једох. ");
INSERT INTO srp1868_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Тада рече Господ Бог змији: Кад си то учинила, да си проклета мимо свако живинче и мимо све звери пољске; на трбуху да се вучеш и прах да једеш до свог века. ");
INSERT INTO srp1868_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","И још мећем непријатељство између тебе и жене и између семена твог и семена њеног; оно ће ти на главу стајати а ти ћеш га у пету уједати. ");
INSERT INTO srp1868_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","А жени рече: Теби ћу многе муке задати кад затрудниш, с мукама ћеш децу рађати, и воља ће твоја стајати под влашћу мужа твог, и он ће ти бити господар. ");
INSERT INTO srp1868_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Па онда рече Адаму: Што си послушао жену и окусио с дрвета с ког сам ти забранио рекавши да не једеш с њега, земља да је проклета с тебе, с муком ћеш се од ње хранити до свог века; ");
INSERT INTO srp1868_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Трње и коров ће ти рађати, а ти ћеш јести зеље пољско; ");
INSERT INTO srp1868_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Са знојем лица свог јешћеш хлеб, докле се не вратиш у земљу од које си узет; јер си прах, и у прах ћеш се вратити. ");
INSERT INTO srp1868_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","И Адам надеде жени својој име Јева, зато што је она мати свима живима. ");
INSERT INTO srp1868_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","И начини Господ Бог Адаму и жени његовој хаљине од коже, и обуче их у њих. ");
INSERT INTO srp1868_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","И рече Господ Бог: Ето, човек поста као један од нас знајући шта је добро шта ли зло; али сада да не пружи руку своју и узбере и с дрвета од живота, и окуси, те до века живи. ");
INSERT INTO srp1868_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","И Господ Бог изагна га из врта едемског да ради земљу, од које би узет; ");
INSERT INTO srp1868_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","и изагнав човека постави пред вртом едемским херувима с пламеним мачем, који се вијаше и тамо и амо, да чува пут ка дрвету од живота. ");
INSERT INTO srp1868_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Иза тога Адам позна Јеву жену своју, а она затрудне и роди Кајина, и рече: Добих човека од Господа. ");
INSERT INTO srp1868_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","И роди опет брата његовог Авеља. И Авељ поста пастир а Кајин ратар. ");
INSERT INTO srp1868_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","А после неког времена догоди се, те Кајин принесе Господу принос од рода земаљског; ");
INSERT INTO srp1868_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","а и Авељ принесе од првина стада свог и од њихове претилине. И Господ погледа на Авеља и на његов принос, ");
INSERT INTO srp1868_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","а на Кајина и на његов принос не погледа. Зато се Кајин расрди веома, и лице му се промени. ");
INSERT INTO srp1868_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Тада рече Господ Кајину: Што се срдиш? Што ли ти се лице промени? ");
INSERT INTO srp1868_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Нећеш ли бити мио, кад добро чиниш? А кад не чиниш добро, грех је на вратима. А воља је његова под твојом влашћу, и ти си му старији. ");
INSERT INTO srp1868_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","После говораше Кајин с Авељем братом својим. Али кад беху у пољу, скочи Кајин на Авеља брата свог, и уби га. ");
INSERT INTO srp1868_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Тада рече Господ Кајину: Где ти је брат Авељ? А он одговори: Не знам; зар сам ја чувар брата свог? ");
INSERT INTO srp1868_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","А Бог рече: Шта учини! Глас крви брата твог виче са земље к мени. ");
INSERT INTO srp1868_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","И сада, да си проклет на земљи, која је отворила уста своја да прими крв брата твог из руке твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Кад земљу узрадиш, неће ти више давати блага свог. Бићеш потукач и бегунац на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","А Кајин рече Господу: Кривица је моја велика да ми се не може опростити. ");
INSERT INTO srp1868_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ево ме тераш данас из ове земље да се кријем испред Тебе, и да се скитам и потуцам по земљи, па ће ме убити ко ме удеси. ");
INSERT INTO srp1868_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","А Господ му рече: Зато ко убије Кајина, седам ће се пута то покајати. И начини Господ знак на Кајину да га не убије ко га удеси. ");
INSERT INTO srp1868_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","И отиде Кајин испред Господа, и насели се у земљи наидској на истоку према Едему. ");
INSERT INTO srp1868_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","И позна Кајин жену своју, а она затрудне и роди Еноха. И сазида град и прозва га по имену сина свог Енох. ");
INSERT INTO srp1868_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","А Еноху роди се Гаидад; а Гаидад роди Малелеила; а Малелеило роди Матусала; а Матусал роди Ламеха. ");
INSERT INTO srp1868_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","И узе Ламех две жене: једној беше име Ада а другој Села. ");
INSERT INTO srp1868_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","И Ада роди Јовила; од њега се народише који живе под шаторима и стоку пасу. ");
INSERT INTO srp1868_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","А брату његовом беше име Јувал; од њега се народише гудачи и свирачи. ");
INSERT INTO srp1868_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","А и Села роди Товела, који беше вешт ковати свашта од бронзе и од гвожђа; а сестра Товелу беше Ноема. ");
INSERT INTO srp1868_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","И рече Ламех својим женама, Ади и Сели: Чујте глас мој, жене Ламехове, послушајте речи моје: убићу човека за рану своју и младића за масницу своју. ");
INSERT INTO srp1868_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Кад ће се Кајин осветити седам пута, Ламех ће седамдесет и седам пута. ");
INSERT INTO srp1868_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","А Адам опет позна жену своју, и она роди сина, и наде му име Сит, јер ми, рече, Бог даде другог сина за Авеља, ког уби Кајин. ");
INSERT INTO srp1868_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","И Ситу се роди син, коме надеде име Енос. Тада се поче призивати име Господње. ");
INSERT INTO srp1868_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ово је племе Адамово. Кад Бог створи човека по обличју свом створи га. ");
INSERT INTO srp1868_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Мушко и женско створи их, и благослови их, и назва их човек, кад бише створени. ");
INSERT INTO srp1868_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","И поживе Адам сто тридесет година, и роди сина по обличју свом, као што је он, и надеде му име Сит. ");
INSERT INTO srp1868_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","А родив Сита поживе Адам осам стотина година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","тако поживе Адам свега девет стотина тридесет година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","А Сит поживе сто пет година, и роди Еноса; ");
INSERT INTO srp1868_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","а родив Еноса поживе Сит осам стотина седам година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","тако поживе Сит свега девет стотина дванаест година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","А Енос поживе деведесет година, и роди Кајинана; ");
INSERT INTO srp1868_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","а родив Кајинана поживе Енос осам стотина петнаест година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","тако поживе Енос свега девет стотина пет година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","А Кајинан поживе седамдесет година, и роди Малелеила; ");
INSERT INTO srp1868_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","а родив Малелеила поживе Кајинан осам стотина и четрдесет година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","тако поживе Кајинан свега девет стотина десет година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","А Малелеило поживе шездесет пет година, и роди Јареда; ");
INSERT INTO srp1868_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","а родив Јареда поживе Малелеило осам стотина тридесет година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","тако поживе Малелеило свега осам стотина деведесет пет година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","А Јаред поживе сто и шездесет и две године, и роди Еноха; ");
INSERT INTO srp1868_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","а родив Еноха поживе Јаред осам стотина година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","тако поживе Јаред свега девет стотина шездесет две године, и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","А Енох поживе шездесет пет година, и роди Матусала; ");
INSERT INTO srp1868_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","а родив Матусала поживе Енох једнако по вољи Божјој триста година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","тако поживе Енох свега триста шездесет пет година; ");
INSERT INTO srp1868_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","и живећи Енох једнако по вољи Божјој, нестаде га јер га узе Бог. ");
INSERT INTO srp1868_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","А Матусал поживе сто осамдесет седам година, и роди Ламеха; ");
INSERT INTO srp1868_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","а родив Ламеха поживе Матусал седам стотина осамдесет две године, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","тако поживе Матусал свега девет стотина и шездесет и девет година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","А Ламех поживе сто осамдесет и две године, и роди сина, ");
INSERT INTO srp1868_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","и надеде му име Ноје говорећи: Овај ће нас одморити од послова наших и од труда руку наших на земљи, коју прокле Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","А родив Ноја поживе Ламех пет стотина деведесет пет година, рађајући синове и кћери; ");
INSERT INTO srp1868_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","тако поживе Ламех свега седам стотина седамдесет седам година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","А Ноју кад би пет стотина година, роди Ноје Сима, Хама и Јафета. ");
INSERT INTO srp1868_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","А кад се људи почеше множити на земљи, и кћери им се народише. ");
INSERT INTO srp1868_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Видећи синови Божји кћери човечије како су лепе узимаше их за жене које хтеше. ");
INSERT INTO srp1868_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","А Господ рече: Неће се дух мој до века прети с људима, јер су тело; нека им још сто двадесет година. ");
INSERT INTO srp1868_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","А беше тада дивова на земљи; а и после, кад се синови Божји састајаху са кћерима човечијим, па им оне рађаху синове; то беху силни људи, од старине на гласу. ");
INSERT INTO srp1868_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","И Господ видећи да је неваљалство људско велико на земљи, и да су све мисли срца њиховог свагда само зле, ");
INSERT INTO srp1868_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","покаја се Господ што је створио човека на земљи, и би му жао у срцу. ");
INSERT INTO srp1868_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","И рече Господ: Хоћу да истребим са земље људе, које сам створио, од човека до стоке и до ситне животиње и до птица небеских; јер се кајем што сам их створио. ");
INSERT INTO srp1868_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Али Ноје нађе милост пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ово су догађаји Нојеви: Ноје беше човек праведан и безазлен свог века; по вољи Божјој свагда живљаше Ноје. ");
INSERT INTO srp1868_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","И роди Ноје три сина: Сима, Хама и Јафета. ");
INSERT INTO srp1868_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","А земља се поквари пред Богом, и напуни се земља безакоња. ");
INSERT INTO srp1868_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","И погледа Бог на земљу, а она беше покварена; јер свако тело поквари пут свој на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","И рече Бог Ноју: Крај сваком телу дође преда ме, јер напунише земљу безакоња; и ево хоћу да их затрем са земљом. ");
INSERT INTO srp1868_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Начини себи ковчег од дрвета гофера, и начини прегратке у ковчегу; и затопи га смолом изнутра и споља. ");
INSERT INTO srp1868_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","И начини га овако; у дужину нека буде триста лаката, у ширину педесет лаката, и у висину тридесет лаката; ");
INSERT INTO srp1868_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","пусти доста светлости у ковчег; и кров му сведи озго од лакта; и удари врата ковчегу са стране; и начини га на три боја: доњи, други и трећи. ");
INSERT INTO srp1868_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Јер ево пустићу потоп на земљу да истребим свако тело у коме има жива душа под небом; шта је год на земљи све ће изгинути. ");
INSERT INTO srp1868_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Али ћу с тобом учинити завет свој: и ући ћеш у ковчег ти и синови твоји и жена твоја и жене синова твојих с тобом. ");
INSERT INTO srp1868_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","И од свега живог, од сваког тела, узећеш у ковчег по двоје, да сачуваш у животу са собом, а мушко и женско нека буде. ");
INSERT INTO srp1868_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Од птица по врстама њиховим, од стоке по врстама њеним, и од свега што се миче на земљи по врстама његовим, од свега по двоје нека уђе с тобом, да их сачуваш у животу. ");
INSERT INTO srp1868_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","И узми са собом свега што се једе, и чувај код себе, да буде хране теби и њима. ");
INSERT INTO srp1868_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","И Ноје учини, како му заповеди Бог, све онако учини. ");
INSERT INTO srp1868_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","И рече Господ Ноју: Уђи у ковчег ти и сав дом твој; јер те нађох праведна пред собом овог века. ");
INSERT INTO srp1868_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Узми са собом од свих животиња чистих по седморо, све мужјака и женку његову; а од животиња нечистих по двоје, мужјака и женку његову, ");
INSERT INTO srp1868_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","такође и од птица небеских по седам, мужјака и женку његову, да им се сачува семе на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Јер ћу до седам дана пустити дажд на земљу за четрдесет дана и четрдесет ноћи, и истребићу са земље свако тело живо, које сам створио. ");
INSERT INTO srp1868_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","И Ноје учини све што му заповеди Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","А беше Ноју шест стотина година кад дође потоп на земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","И уђе Ноје у ковчег и синови његови и жена његова и жене синова његових с њим ради потопа. ");
INSERT INTO srp1868_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Од животиња чистих и од животиња нечистих и од птица и од свега што се миче по земљи, ");
INSERT INTO srp1868_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","уђе к Ноју у ковчег по двоје, мушко и женско, као што беше Бог заповедио Ноју. ");
INSERT INTO srp1868_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","А у седми дан дође потоп на земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Кад је било Ноју шест стотина година, те године другог месеца, седамнаести дан тога месеца, тај дан развалише се сви извори великог бездана, и отворише се уставе небеске; ");
INSERT INTO srp1868_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","и удари дажд на земљу за четрдесет дана и четрдесет ноћи. ");
INSERT INTO srp1868_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Тај дан уђе у ковчег Ноје и Сим и Хам и Јафет, синови Нојеви, и жена Нојева и три жене синова његових с њима; ");
INSERT INTO srp1868_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","они, и свакојаке звери по врстама својим, и свакојака стока по врстама својим, и шта се год миче по земљи по врстама својим, и птице све по врстама својим, и шта год лети и има крила, ");
INSERT INTO srp1868_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","дође к Ноју у ковчег по двоје од сваког тела, у коме има жива душа, ");
INSERT INTO srp1868_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","мушко и женско од сваког тела уђоше, као што беше Бог заповедио Ноју; па Господ затвори за њим. ");
INSERT INTO srp1868_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","И би потоп на земљи за четрдесет дана; и вода дође и узе ковчег, и подиже га од земље. ");
INSERT INTO srp1868_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","И навали вода, и уста јако по земљи, и ковчег стаде пловити водом. ");
INSERT INTO srp1868_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","И наваљиваше вода све већма по земљи, и покри сва највиша брда што су под целим небом. ");
INSERT INTO srp1868_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Петнаест лаката дође вода изнад брда, пошто их покри. ");
INSERT INTO srp1868_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Тада изгибе свако тело што се мицаше на земљи, птице и стока, и звери и све што гамиже по земљи, и сви људи. ");
INSERT INTO srp1868_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Све што имаше душу живу у носу, све што беше на сувом, помре. ");
INSERT INTO srp1868_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","И истреби се свако тело живо на земљи, и људи и стока и шта год гамиже и птице небеске, све, велим, истреби се са земље; само Ноје оста и шта с њим беше у ковчегу. ");
INSERT INTO srp1868_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","И стајаше вода поврх земље сто педесет дана. ");
INSERT INTO srp1868_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","А Бог се опомену Ноја и свих звери и све стоке што беху с њим у ковчегу; и посла Бог ветар на земљу да узбије воду. ");
INSERT INTO srp1868_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","И затворише се извори бездану и уставе небеске, и дажд с неба престаде. ");
INSERT INTO srp1868_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","И стаде вода опадати на земљи, и једнако опадаше после сто педесет дана; ");
INSERT INTO srp1868_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","те се устави ковчег седмог месеца дана седамнаестог на планини Арарату. ");
INSERT INTO srp1868_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","И вода опадаше све већма до десетог месеца; и првог дана десетог месеца показаше се врхови од брда. ");
INSERT INTO srp1868_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","А после четрдесет дана отвори Ноје прозор на ковчегу, који беше начинио; ");
INSERT INTO srp1868_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","и испусти гаврана, који једнако одлеташе и долеташе докле не пресахну вода на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Па пусти и голубицу да би видео је ли опала вода са земље. ");
INSERT INTO srp1868_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","А голубица не нашавши где би стала ногом својом врати се к њему у ковчег, јер још беше вода по свој земљи; и Ноје пруживши руку ухвати је и узе к себи у ковчег. ");
INSERT INTO srp1868_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","И почека још седам дана, по опет испусти голубицу из ковчега. ");
INSERT INTO srp1868_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","И пред вече врати се к њему голубица, и гле, у кљуну јој лист маслинов, који беше откинула; тако позна Ноје да је опала вода са земље. ");
INSERT INTO srp1868_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Али почека још седам дана, па опет испусти голубицу, а она му се више не врати. ");
INSERT INTO srp1868_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Шест стотина прве године века Нојевог први дан првог месеца усахну вода на земљи; и Ноје откри кров на ковчегу, и угледа земљу суву. ");
INSERT INTO srp1868_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","А другог месеца двадесет седмог дана беше сва земља сува. ");
INSERT INTO srp1868_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Тада рече Бог Ноју говорећи: ");
INSERT INTO srp1868_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Изађи из ковчега ти и жена твоја и синови твоји и жене синова твојих с тобом; ");
INSERT INTO srp1868_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","све звери што су са тобом од сваког тела, птице и стоку и шта год гамиже по земљи, изведи са собом, нека се разиђу по земљи, и нека се плоде и множе на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","И изиђе Ноје и синови његови и жена његова и жене синова његових с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Све звери, све ситне животиње, све птице и све што се миче по земљи по својим врстама изиђоше из ковчега. ");
INSERT INTO srp1868_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","И начини Ноје жртвеник Господу, и узе од сваке чисте стоке и од свих птица чистих, и принесе на жртвенику жртве паљенице. ");
INSERT INTO srp1868_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","И Господ омириса мирис угодни, и рече у срцу свом: Нећу више клети земље с људи, што је мисао срца човечијег зла од малена; нити ћу више убијати све што живи, као што учиних. ");
INSERT INTO srp1868_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Од сада докле буде земље, неће нестајати сетве ни жетве, студени ни врућине, лета ни зиме, дана ни ноћи. ");
INSERT INTO srp1868_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","И Бог благослови Ноја и синове његове, и рече им: Рађајте се и множите се и напуните земљу; ");
INSERT INTO srp1868_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","и све звери земаљске и све птице небеске и све што иде по земљи и све рибе морске нека вас се боје и страше; све је предано у ваше руке. ");
INSERT INTO srp1868_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Шта се год миче и живи, нека вам буде за јело, све вам то дадох као зелену траву. ");
INSERT INTO srp1868_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Али не једите меса с душом његовом, а то му је крв. ");
INSERT INTO srp1868_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Јер ћу и вашу крв, душе ваше, искати; од сваке ћу је звери искати; из руке самог човека, из руке сваког брата његовог искаћу душу човечију. ");
INSERT INTO srp1868_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ко пролије крв човечију, његову ће крв пролити човек; јер је Бог по свом обличју створио човека. ");
INSERT INTO srp1868_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Рађајте се дакле и множите се; народите се веома на земљи и намножите се на њој. ");
INSERT INTO srp1868_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","И рече Бог Ноју и синовима његовим с њим, говорећи: ");
INSERT INTO srp1868_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","А ја ево постављам завет свој с вама и с вашим семеном након вас, ");
INSERT INTO srp1868_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","и са свим животињама, што су с вама од птица, од стоке и од свих звери земаљских што су с вама, са свачим што је изашло из ковчега, и са свим зверима земаљским. ");
INSERT INTO srp1868_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Постављам завет свој с вама, те одселе неће ниједно тело погинути од потопа, нити ће више бити потопа да затре земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","И рече Бог: Ево знак завета који постављам између себе и вас и сваке живе твари, која је с вама до века: ");
INSERT INTO srp1868_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Метнуо сам дугу своју у облаке, да буде знак завета између мене и земље. ");
INSERT INTO srp1868_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Па кад облаке навучем на земљу, видеће се дуга у облацима, ");
INSERT INTO srp1868_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","и опоменућу се завета свог који је између мене и вас и сваке душе живе у сваком телу, и неће више бити од воде потопа да затре свако тело. ");
INSERT INTO srp1868_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Дуга ће бити у облацима, па ћу је погледати, и опоменућу се вечног завета између Бога и сваке душе живе у сваком телу које је на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","И рече Бог Ноју: То је знак завета који сам учинио између себе и сваког тела на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","А беху синови Нојеви који изађоше из ковчега: Сим и Хам и Јафет; а Хам је отац Хананцима. ");
INSERT INTO srp1868_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","То су три сина Нојева, и од њих се насели сва земља. ");
INSERT INTO srp1868_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","А Ноје поче радити земљу, и посади виноград. ");
INSERT INTO srp1868_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","И напив се вина опи се, и откри се насред шатора свог. ");
INSERT INTO srp1868_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","А Хам, отац Хананцима, виде голотињу оца свог, и каза обојици браће своје на пољу. ");
INSERT INTO srp1868_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","А Сим и Јафет узеше хаљину, и огрнуше је обојица на рамена своја, и идући натрашке покрише њом голотињу оца свог, лицем натраг окренувши се да не виде голотиње оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","А кад се Ноје пробуди од вина, дозна шта му је учинио млађи син, ");
INSERT INTO srp1868_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","и рече: Проклет да је Ханан, и да буде слуга слугама браће своје! ");
INSERT INTO srp1868_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","И још рече: Благословен да је Господ Бог Симов, и Ханан да му буде слуга! ");
INSERT INTO srp1868_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Бог да рашири Јафета да живи у шаторима Симовим, а Ханан да им буде слуга! ");
INSERT INTO srp1868_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","И поживе Ноје после потопа триста педесет година. ");
INSERT INTO srp1868_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","А свега поживе Ноје девет стотина педесет година; и умре. ");
INSERT INTO srp1868_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","А ово су племена синова Нојевих, Сима, Хама и Јафета, којима се родише синови после потопа. ");
INSERT INTO srp1868_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Синови Јафетови: Гомер и Магог и Мадај и Јаван и Товел и Месех и Тирас. ");
INSERT INTO srp1868_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","А синови Гомерови: Асхенас и Рифат и Тогарма. ");
INSERT INTO srp1868_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","А синови Јаванови: Елиса и Тарсис, Китим и Доданим. ");
INSERT INTO srp1868_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Од њих се разделише острва народна на земљама својим, свако по језику свом и по породицама својим, у народима својим. ");
INSERT INTO srp1868_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","А синови Хамови: Хус и Месраин, Фуд и Ханан. ");
INSERT INTO srp1868_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","А синови Хусови: Сава и Авила и Савата и Регма и Саватака. А синови Регмини: Сава и Дедан. ");
INSERT INTO srp1868_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Хус роди и Неврода; а он први би силан на земљи; ");
INSERT INTO srp1868_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","беше добар ловац пред Господом; зато се каже: Добар ловац пред Господом као Неврод. ");
INSERT INTO srp1868_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","А почетак царству његовом беше Вавилон и Орех и Архад и Халани у земљи Сенару. ");
INSERT INTO srp1868_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Из те земље изађе Асур, и сазида Ниневију и Ровот град и Халах, ");
INSERT INTO srp1868_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","и Дасем између Ниневије и Халаха; то је град велик. ");
INSERT INTO srp1868_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","А Месраин роди Лудеје и Енемеје и Лавеје и Нефталеје, ");
INSERT INTO srp1868_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","и Патросеје и Хасмеје, одакле изађоше Филистеји и Гафтореји. ");
INSERT INTO srp1868_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","А Ханан роди Сидона, првенца свог, и Хета, ");
INSERT INTO srp1868_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","и Јевусеја и Амореја и Гергесеја, ");
INSERT INTO srp1868_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","и Евеја и Арукеја и Асенеја, ");
INSERT INTO srp1868_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","и Арвадеја и Самареја и Аматеја. А после се расејаше племена хананејска. ");
INSERT INTO srp1868_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","И беху међе хананејске од Сидона идући на Герар па до Газе, и идући на Содом и Гомор и Адаму и Севојим па до Даса. ");
INSERT INTO srp1868_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","То су синови Хамови по породицама својим и по језицима својим, у земљама својим и у народима својим. ");
INSERT INTO srp1868_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","И Симу родише се синови, најстаријем брату Јафетовом, оцу свих синова Еверових. ");
INSERT INTO srp1868_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Синови Симови беху: Елам и Асур и Арфаксад и Луд и Арам. ");
INSERT INTO srp1868_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","А синови Арамови: Уз и Ул и Гатер и Мас. ");
INSERT INTO srp1868_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","А Арфаксад роди Салу, а Сала роди Евера. ");
INSERT INTO srp1868_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","А Еверу се родише два сина: једном беше име Фалек, јер се у његово време раздели земља, а брату његовом име Јектан. ");
INSERT INTO srp1868_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","А Јектан роди Елмодада и Салета и Сармота и Јараха, ");
INSERT INTO srp1868_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","и Одора и Евила и Деклу, ");
INSERT INTO srp1868_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","и Евала и Авимаила и Саву, ");
INSERT INTO srp1868_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","и Уфира и Евилу и Јовава; ти сви беху синови Јектанови. ");
INSERT INTO srp1868_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","И живљаху од Масе, како се иде на Сафир до гора источних. ");
INSERT INTO srp1868_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","То су синови Симови по породицама својим и по језицима својим, у земљама својим и у народима својим. ");
INSERT INTO srp1868_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","То су породице синова Нојевих по племенима својим, у народима својим; и од њих се разделише народи по земљи после потопа. ");
INSERT INTO srp1868_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","А беше на целој земљи један језик и једнаке речи. ");
INSERT INTO srp1868_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","А кад отидоше од истока, нађоше равницу у земљи сенарској, и населише се онде. ");
INSERT INTO srp1868_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Па рекоше међу собом: Хајде да правимо плоче и да их у ватри печемо. И беху им опеке место камена и смола земљана место креча. ");
INSERT INTO srp1868_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","После рекоше: Хајде да сазидамо град и кулу, којој ће врх бити до неба, да стечемо себи име, да се не бисмо расејали по земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","А Господ сиђе да види град и кулу, што зидаху синови човечији. ");
INSERT INTO srp1868_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","И рече Господ: Гле, народ један, и један језик у свих, и то почеше радити, и неће им сметати ништа да не ураде шта су наумили. ");
INSERT INTO srp1868_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Хајде да сиђемо, и да им пометемо језик, да не разумеју један другог шта говоре. ");
INSERT INTO srp1868_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Тако их Господ расу оданде по свој земљи, те не сазидаше града. ");
INSERT INTO srp1868_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Зато се прозва Вавилон, јер онде помете Господ језик целе земље, и оданде их расу Господ по свој земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ово је племе Симово: беше Симу сто година, кад роди Арфаксада, друге године после потопа. ");
INSERT INTO srp1868_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","А родив Арфаксада поживе Сим пет стотина година, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","А Арфаксад поживе тридесет и пет година, и роди Салу; ");
INSERT INTO srp1868_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","а родив Салу поживе Арфаксад четири стотине и три године, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","А Сала поживе тридесет година, и роди Евера; ");
INSERT INTO srp1868_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","а родив Евера поживе Сала четири стотине и три године, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","А Евер поживе тридесет и четири године, и роди Фалека; ");
INSERT INTO srp1868_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","а родив Фалека поживе Евер четири стотине и тридесет година, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","А Фалек поживе тридесет година, и роди Рагава; ");
INSERT INTO srp1868_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","а родив Рагава поживе Фалек двеста и девет година, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","А Рагав поживе тридесет и две године, и роди Серуха; ");
INSERT INTO srp1868_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","а родив Серуха поживе Рагав двеста и седам година, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","А Серух поживе тридесет година, и роди Нахора; ");
INSERT INTO srp1868_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","а родив Нахора поживе Серух двеста година, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","А Нахор поживе двадесет и девет година, и роди Тару; ");
INSERT INTO srp1868_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","а родив Тару поживе Нахор сто и деветнаест година, рађајући синове и кћери. ");
INSERT INTO srp1868_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","А Тара поживе седамдесет година, и роди Аврама, Нахора и Арана. ");
INSERT INTO srp1868_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","А ово је племе Тарино: Тара роди Аврама, Нахора и Арана; а Аран роди Лота. ");
INSERT INTO srp1868_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","И умре Аран пре Таре оца свог на постојбини својој, у Уру халдејском. ");
INSERT INTO srp1868_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","И ожени се Аврам и Нахор, и жени Аврамовој беше име Сара а жени Нахоровој име Мелха, кћи Арама оца Мелхе и Јесхе. ");
INSERT INTO srp1868_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","А Сара беше нероткиња, и не имаше порода. ");
INSERT INTO srp1868_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","И узе Тара сина свог Аврама и Лота сина Ароновог, унука свог, и Сару снаху своју, жену Аврама сина свог; и пођоше заједно из Ура халдејског да иду у земљу хананску, и дођоше до Харана, и онде се настанише. ");
INSERT INTO srp1868_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","И поживе Тара свега двеста и пет година; и умре Тара у Харану. ");
INSERT INTO srp1868_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","И рече Господ Авраму: Иди из земље своје и од рода свог и из дома оца свог у земљу коју ћу ти ја показати. ");
INSERT INTO srp1868_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","И учинићу од тебе велик народ, и благословићу те, и име твоје прославићу, и ти ћеш бити благослов. ");
INSERT INTO srp1868_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Благословићу оне који тебе узблагосиљају, и проклећу оне који тебе успроклињу; и у теби ће бити благословена сва племена на земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Тада пође Аврам, као што му каза Господ, и с њим пође Лот. А беше Авраму седамдесет и пет година кад пође из Харана. ");
INSERT INTO srp1868_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","И узе Аврам Сару жену своју и Лота сина брата свог са свим благом које беху стекли и с душама које беху добили у Харану; и пођоше у земљу хананску, и дођоше у њу. ");
INSERT INTO srp1868_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","И пође Аврам ту земљу до места Сихема и до равнице морешке; а беху тада Хананеји у тој земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","И јави се Господ Авраму и рече: Твом семену даћу земљу ову. И Аврам начини онде жртвеник Господу, који му се јавио. ");
INSERT INTO srp1868_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","После отиде оданде на брдо, које је према истоку од Ветиља, и онде разапе шатор свој, те му Ветиљ беше са запада а Гај с истока; и онде начини Господу жртвеник, и призва име Господње. ");
INSERT INTO srp1868_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Оданде отиде Аврам даље идући на југ. ");
INSERT INTO srp1868_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Али наста глад у оној земљи, те Аврам сиђе у Мисир да се онде склони; јер глад беше велика у оној земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","А кад се приближи да већ уђе у Мисир, рече Сари жени својој: Гле, знам да си жена лепа у лицу. ");
INSERT INTO srp1868_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Зато кад те виде Мисирци рећи ће: Ово му је жена. Па ће ме убити, а тебе ће оставити у животу. ");
INSERT INTO srp1868_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Него хајде кажи да си ми сестра, те ће мени бити добро тебе ради и остаћу у животу уз тебе. ");
INSERT INTO srp1868_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","И кад дође Аврам у Мисир, видеше Мисирци жену да је врло лепа. ");
INSERT INTO srp1868_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","И видеше је кнезови Фараонови, и хвалише је пред Фараоном. И узеше је у двор Фараонов. ");
INSERT INTO srp1868_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","И он чињаше добро Авраму ње ради, те имаше оваца и говеда и магараца и слуга и слушкиња и магарица и камила. ");
INSERT INTO srp1868_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Али Господ пусти велика зла на Фараона и на дом његов ради Саре жене Аврамове. ");
INSERT INTO srp1868_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Тада дозва Фараон Аврама и рече му: Шта ми то учини? Зашто ми ниси казао да ти је жена? ");
INSERT INTO srp1868_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Зашто си казао: Сестра ми је? Те је узех за жену. Сад ето ти жене, узми је, па иди. ");
INSERT INTO srp1868_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","И Фараон заповеди људима за њ, те га испратише и жену његову и шта год имаше. ");
INSERT INTO srp1868_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Тако отиде Аврам из Мисира горе на југ, он и жена му и све што имаше, такође и Лот с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","А беше Аврам врло богат стоком, сребром и златом. ");
INSERT INTO srp1868_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","И иђаше својим путевима од југа све до Ветиља, до места где му прво беше шатор, између Ветиља и Гаја, ");
INSERT INTO srp1868_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","до места, где пре беше начинио жртвеник; и онде призва Аврам име Господње. ");
INSERT INTO srp1868_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","А и Лот који иђаше с Аврамом имаше оваца и говеда и шатора. ");
INSERT INTO srp1868_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","И земља не могаше их носити заједно, јер благо њихово беше велико да не могоше живети заједно, ");
INSERT INTO srp1868_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","и беше свађа међу пастирима Аврамове стоке и пастирима Лотове стоке. А у то време живеху Хананеји и Ферезеји у оној земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Па Аврам рече Лоту: Немој да се свађамо ја и ти, ни моји пастири и твоји пастири; јер смо браћа. ");
INSERT INTO srp1868_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Није ли ти отворена цела земља? Одели се од мене. Ако ћеш ти на лево, ја ћу на десно; ако ли ћеш ти на десно ја ћу на лево. ");
INSERT INTO srp1868_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Тада Лот подиже очи своје и сагледа сву равницу јорданску, како целу натапаше река, беше као врт Господњи, као земља мисирска, све до Загора, пре него Господ затре Содом и Гомор. ");
INSERT INTO srp1868_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","И Лот изабра себи сву равницу јорданску, и отиде Лот на исток; и разделише се један од другог: ");
INSERT INTO srp1868_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврам живљаше у земљи хананској, а Лот живљаше по градовима у оној равници премештајући своје шаторе до Содома. ");
INSERT INTO srp1868_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","А људи у Содому беху неваљали, и грешаху Господу веома. ");
INSERT INTO srp1868_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","А Господ рече Авраму, пошто се Лот одели од њега: Подигни сада очи своје, па погледај с места где си на север и на југ и на исток и на запад. ");
INSERT INTO srp1868_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Јер сву земљу што видиш теби ћу дати и семену твом до века. ");
INSERT INTO srp1868_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","И учинићу да семена твог буде као праха на земљи; ако ко узможе избројати прах на земљи, моћи ће избројати и семе твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Устани, и пролази ту земљу у дужину и у ширину; јер ћу је теби дати. ");
INSERT INTO srp1868_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","И Аврам диже шаторе, и дође и насели се у равници мамријској, која је код Хеврона, и онде начини жртвеник Господу. ");
INSERT INTO srp1868_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","А кад беше Амарфал цар сенарски, Арион цар еласарски, Ходологомор цар еламски и Таргал цар гојимски, ");
INSERT INTO srp1868_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","завојеваше на Валу цара содомског, и на Варсу цара гоморског, и на Сенара цара адамског, и на Симовора цара севојимског и на цара од Валаке, која је сада Сигор. ");
INSERT INTO srp1868_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Сви се ови скупише у долини сидимској која је сада слано море. ");
INSERT INTO srp1868_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Дванаест година беху служили Ходологомору, па тринаесте године одметнуше се. ");
INSERT INTO srp1868_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","А четрнаесте године дође Ходологомор и цареви који беху с њим, и побише Рафаје у Астароту карнајимском и Зузеје у Аму и Омеје у пољу киријатајском, ");
INSERT INTO srp1868_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","и Хореје у планини њиховој Сиру до равнице фаранске покрај пустиње. ");
INSERT INTO srp1868_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Од туда вративши се дођоше у Ен-Миспат, који је сада Кадис, и исекоше све који живеху у земљи амаличкој, и Амореје који живеху у Асасон-Тамару. ");
INSERT INTO srp1868_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Тада изиђе цар содомски и цар гоморски и цар адамски и цар севојимски и цар од Валаке, које је сада Сигор, изађоше на њих у долину сидимску, ");
INSERT INTO srp1868_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","на Ходологомора цара еламског, и на Таргала цара гојимског, и на Амарфала цара сенарског, и на Ариоха цара еласарског, четири цара на пет. ");
INSERT INTO srp1868_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","А у долини сидимској беше много рупа из којих се вадила смола; и побеже цар содомски и цар гоморски, и онде падоше, а шта оста побеже у планину. ");
INSERT INTO srp1868_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","И узеше све благо у Содому и Гомору и сву храну њихову, и отидоше. ");
INSERT INTO srp1868_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Узеше и Лота, синовца Аврамовог, и благо његово, и отидоше, јер живеше у Содому. ");
INSERT INTO srp1868_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","А дође један који беше утекао, те јави Авраму Јеврејину, који живеше у равни Мамрија Аморејина, брата Есхолу и брата Авнану, који беху у вери с Аврамом. ");
INSERT INTO srp1868_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","А кад Аврам чу да му се заробио синовац, наоружа слуге своје, триста осамнаест, који се родише у његовој кући, и пође у потеру до Дана. ");
INSERT INTO srp1868_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Онде разделивши своје удари на њих ноћу са слугама својим, и разби их, и отера их до Ховала, који је на лево од Дамаска, ");
INSERT INTO srp1868_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","и поврати све благо; поврати и Лота синовца свог с благом његовим, и жене и људе. ");
INSERT INTO srp1868_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","А цар содомски изиђе му на сусрет кад се врати разбивши Ходологомора и цареве што беху с њим, у долину Савину, које је сада долина царева. ");
INSERT INTO srp1868_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","А Мелхиседек цар салимски изнесе хлеб и вино; а он беше свештеник Бога Вишњег. ");
INSERT INTO srp1868_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","И благослови га говорећи: Благословен да је Аврам Богу Вишњем, чије је небо и земља! ");
INSERT INTO srp1868_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","И благословен да је Бог Вишњи, који предаде непријатеље твоје у руке твоје! И даде му Аврам десетак од свега. ");
INSERT INTO srp1868_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","А цар содомски рече Авраму: Дај мени људе, а благо узми себи. ");
INSERT INTO srp1868_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","А Аврам рече цару содомском: Дижем руку своју ка Господу Богу Вишњем, чије је небо и земља, заклињући се: ");
INSERT INTO srp1868_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ни конца ни ремена од обуће нећу узети од свега што је твоје, да не кажеш: Ја сам обогатио Аврама; ");
INSERT INTO srp1868_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","осим што су појели момци, и осим дела људима који су ишли са мном, Есхолу, Авнану и Мамрију, они нека узму свој део. ");
INSERT INTO srp1868_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","После ових ствари дође Авраму реч Господња у утвари говорећи: Не бој се, Авраме, ја сам ти штит, и плата је твоја врло велика. ");
INSERT INTO srp1868_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","А Аврам рече Господе, Господе, шта ћеш ми дати кад живим без деце, а па коме ће остати моја кућа то је Елијезер овај Дамаштанин? ");
INSERT INTO srp1868_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Још рече Аврам: Ето мени ниси дао порода, па ће слуга рођен у кући мојој бити мој наследник. ");
INSERT INTO srp1868_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","А гле, Господ му проговори: Неће тај бити наследник твој, него који ће изаћи од тебе тај ће ти бити наследник. ");
INSERT INTO srp1868_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Па га изведе напоље и рече му: Погледај на небо и преброј звезде, ако их можеш пребројати. И рече му: Тако ће ти бити семе твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","И поверова Аврам Богу, а Он му прими то у правду. ");
INSERT INTO srp1868_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","И рече му: Ја сам Господ, који те изведох из Ура халдејског да ти дам земљу ову да буде твоја. ");
INSERT INTO srp1868_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","А он рече: Господе, Господе, по чему ћу познати да ће бити моја? ");
INSERT INTO srp1868_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","И рече му: Принеси ми јуницу од три године и козу од три године и овна од три године и грлицу и голупче. ");
INSERT INTO srp1868_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","И он узе све то, и расече на поле, и метну све поле једну према другој; али не расече птице. ");
INSERT INTO srp1868_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","А птице слетаху на те мртве животиње; а Аврам их одгонише. ");
INSERT INTO srp1868_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","А кад сунце беше на заласку, ухвати Аврама тврд сан, и гле, страх и мрак велик обузе га. ");
INSERT INTO srp1868_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","И Господ рече Авраму: Знај зацело да ће семе твоје бити дошљаци у земљи туђој, па ће јој служити, и она ће их мучити четири стотине година. ");
INSERT INTO srp1868_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Али ћу судити и народу коме ће служити; а после ће они изаћи с великим благом. ");
INSERT INTO srp1868_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","А ти ћеш отићи к оцима својим у миру, и бићеш погребен у доброј старости. ");
INSERT INTO srp1868_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","А они ће се у четвртом колену вратити овамо; јер гресима аморејским још није крај. ");
INSERT INTO srp1868_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","А кад се сунце смири и кад се смрче, гле, пећ се димљаше, и пламен огњени пролажаше између оних делова. ");
INSERT INTO srp1868_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Тај дан учини Господ завет с Аврамом говорећи: Семену твом дадох земљу ову од воде мисирске до велике воде, воде Ефрата, ");
INSERT INTO srp1868_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","кенејску, кенезејску и кедмонејску, ");
INSERT INTO srp1868_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","и хетејску и ферезејску и рафајску, ");
INSERT INTO srp1868_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","и аморејску и хананејску и гергесејску и јевусејску. ");
INSERT INTO srp1868_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Али Сара жена Аврамова не рађаше му деце. А имаше робињу Мисирку, по имену Агара. ");
INSERT INTO srp1868_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Па рече Сара Авраму: Господ ме је затворио да не родим; него иди к робињи мојој, не бих ли добила деце од ње. И Аврам приста на реч Сарину. ");
INSERT INTO srp1868_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","И Сара жена Аврамова узе Агару Мисирку робињу своју, и даде је за жену Авраму мужу свом после десет година откако се настани Аврам у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","И он отиде к Агари, и она затрудне; а кад виде да је трудна, понесе се од госпође своје. ");
INSERT INTO srp1868_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","А Сара рече Авраму: Увреда моја паде на тебе; ја ти метнух на крило робињу своју, а она видевши да је трудна понесе се од мене. Господ ће судити мени и теби. ");
INSERT INTO srp1868_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","А Аврам рече Сари: Ето, робиња је твоја у твојим рукама, учини с њом шта ти је воља. И Сара је стаде злостављати, те она побеже од ње. ");
INSERT INTO srp1868_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Али анђео Господњи нађе је код студенца у пустињи, код студенца на путу у Сур. ");
INSERT INTO srp1868_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","И рече јој: Агаро, робињо Сарина, откуд идеш, куда ли идеш? А она рече: Бежим од Саре госпође своје. ");
INSERT INTO srp1868_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","А анђео јој Господњи рече: Врати се госпођи својој, и покори јој се. ");
INSERT INTO srp1868_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Опет јој рече анђео Господњи: Умножићу веома семе твоје, да се неће моћи пребројати од множине. ");
INSERT INTO srp1868_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Још јој рече анђео Господњи: Ето си трудна, и родићеш сина, и надени му име Исмаило; јер је Господ видео муку твоју. ");
INSERT INTO srp1868_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","А биће човек убица; рука ће се његова дизати на сваког а свачија на њега, и наставаће на погледу свој браћи својој. ");
INSERT INTO srp1868_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Тада Агара призва име Господа који говори с њом: Ти си Бог, који види. Јер говораше: Зар још гледам иза Оног који ме виде? ");
INSERT INTO srp1868_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Тога ради зове се студенац онај студенац Живога који ме види; а он је између Кадиса и Варада. ");
INSERT INTO srp1868_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","И роди Агара Авраму сина; и надеде Аврам сину свом, ког му роди Агара, име Исмаило. ");
INSERT INTO srp1868_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","А беше Авраму осамдесет и шест година кад му Агара роди Исмаила. ");
INSERT INTO srp1868_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","А кад Авраму би деведесет и девет година, јави му се Господ и рече му: Ја сам Бог Свемогући, по мојој вољи живи, и буди поштен. ");
INSERT INTO srp1868_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","И учинићу завет између себе и тебе, и врло ћу те умножити. ");
INSERT INTO srp1868_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","А Аврам паде ничице. И Господ му још говори и рече: ");
INSERT INTO srp1868_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Од мене ево завет мој с тобом да ћеш бити отац многим народима. ");
INSERT INTO srp1868_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Зато се више нећеш звати Аврам него ће ти име бити Авраам, јер сам те учинио оцем многих народа; ");
INSERT INTO srp1868_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","даћу ти породицу врло велику, и начинићу од тебе народе многе, и цареви ће изаћи од тебе. ");
INSERT INTO srp1868_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","А постављам завет свој између себе и тебе и семена твог након тебе од колена до колена, да је завет вечан, да сам Бог теби и семену твом након тебе; ");
INSERT INTO srp1868_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","и даћу теби и семену твом након тебе земљу у којој си дошљак, сву земљу хананску у државу вечну, и бићу им Бог. ");
INSERT INTO srp1868_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","И рече Бог Авраму: Ти пак држи завет мој, ти и семе твоје након тебе од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","А ово је завет мој између мене и вас и семена твог након тебе који ћете држати: да се обрезују између вас све мушкиње. ");
INSERT INTO srp1868_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","А обрезиваћете окрајак тела свог, да буде знак завета између мене и вас. ");
INSERT INTO srp1868_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Свако мушко дете кад му буде осам дана да се обрезује од колена до колена, родило се у кући или било купљено за новце од којих год странаца, које не буде од семена твог. ");
INSERT INTO srp1868_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Да се обрезује које се роди у кући твојој и које се купи за новце твоје; тако ће бити завет мој на телу вашем завет вечан. ");
INSERT INTO srp1868_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","А необрезано мушко, коме се не обреже окрајак тела његовог, да се истреби из народа свог, јер поквари завет мој. ");
INSERT INTO srp1868_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","И још рече Бог Авраму: А Сару жену своју не зови је више Сара него нека јој буде име Саара. ");
INSERT INTO srp1868_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","И ја ћу је благословити, и даћу ти сина од ње; благословићу је, и биће мати многим народима, и цареви народима изаћи ће од ње. ");
INSERT INTO srp1868_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Тада паде Аврам ничице и насмеја се говорећи у срцу свом: Еда ће се човеку од сто година родити син? И Сари? Еда ће жена од деведесет година родити? ");
INSERT INTO srp1868_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","И Аврам рече Богу: Нека жив буде Исмаило пред Тобом! ");
INSERT INTO srp1868_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","И рече Бог: Заиста Сара жена твоја родиће ти сина, и надећеш му име Исак; и поставићу завет свој с њим да буде завет вечан семену његовом након њега. ");
INSERT INTO srp1868_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","А и за Исмаила услишио сам те; ево благословио сам га, и даћу му породицу велику, и умножићу га веома; и родиће дванаест кнезова, и начинићу од њега велик народ. ");
INSERT INTO srp1868_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","А завет свој учинићу с Исаком кад ти га роди Сара, до године у ово доба. ");
INSERT INTO srp1868_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","И Бог изговоривши отиде од Аврама горе. ");
INSERT INTO srp1868_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","И Аврам узе Исмаила сина свог и све који се родише у дому његовом и које год беше купио за своје новце, све мушкиње од домаћих својих; и обреза окрајак тела њиховог у исти дан, као што му каза Бог. ");
INSERT INTO srp1868_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","А беше Авраму деведесет и девет година кад обреза окрајак тела свог. ");
INSERT INTO srp1868_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","А Исмаилу сину његовом беше тринаест година кад му се обреза окрајак тела његовог. ");
INSERT INTO srp1868_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","У један дан обреза се Аврам и син му Исмаило, ");
INSERT INTO srp1868_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","и сви домашњи његови, рођени у кући и купљени за новце од странаца, бише обрезани с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","После му се јави Господ у равници мамријској кад сеђаше на вратима пред шатором својим у подне. ");
INSERT INTO srp1868_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Подигавши очи своје погледа, и гле, три човека стајаше према њему. И угледавши их потрча им у сусрет испред врата шатора свог, и поклони се до земље; ");
INSERT INTO srp1868_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","и рече: Господе, ако сам нашао милост пред Тобом, немој проћи слуге свог. ");
INSERT INTO srp1868_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Да вам донесем мало воде и оперите ноге, те се наслоните мало под овим дрветом. ");
INSERT INTO srp1868_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","И изнећу мало хлеба, те поткрепите срце своје, па онда пођите, кад идете поред слуге свог. И рекоше: Учини шта си казао. ");
INSERT INTO srp1868_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","И Аврам отрча у шатор к Сари, и рече: Брже замеси три копање белог брашна и испеци погаче. ");
INSERT INTO srp1868_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Па отрча ка говедима и ухвати теле младо и добро, и даде га момку да га брже зготови. ");
INSERT INTO srp1868_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Па онда изнесе масла и млека и теле које беше зготовио, и постави им, а сам стајаше пред њима под дрветом докле јеђаху. ");
INSERT INTO srp1868_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","И они му рекоше: Где је Сара жена твоја? А он рече: Ено је под шатором. ");
INSERT INTO srp1868_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","А један између њих рече: Догодине у ово доба опет ћу доћи к теби, а Сара ће жена твоја имати сина. А Сара слушаше на вратима од шатора иза њега. ");
INSERT INTO srp1868_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","А Аврам и Сара беху стари и временити, и у Саре беше престало шта бива у жена. ");
INSERT INTO srp1868_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Зато се насмеја Сара у себи говорећи: Пошто сам остарела, сад ли ће ми доћи радост? А и господар ми је стар. ");
INSERT INTO srp1868_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Тада рече Господ Авраму: Што се смеје Сара говорећи: Истина ли је да ћу родити кад сам остарела? ");
INSERT INTO srp1868_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Има ли шта тешко Господу? Догодине у ово доба опет ћу доћи к теби, а Сара ће имати сина. ");
INSERT INTO srp1868_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","А Сара удари у бах говорећи: Нисам се смејала. Јер се уплаши. Али Он рече: Није истина, него си се смејала. ");
INSERT INTO srp1868_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Потом усташе људи оданде, и пођоше пут Содома; а Аврам пође с њима да их испрати. ");
INSERT INTO srp1868_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","А Господ рече: Како бих тајио од Аврама шта ћу учинити, ");
INSERT INTO srp1868_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","кад ће од Аврама постати велик и силан народ, и у њему ће се благословити сви народи на земљи? ");
INSERT INTO srp1868_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Јер знам да ће заповедити синовима својим и дому свом након себе да се држе путева Господњих и да чине што је право и добро, да би Господ навршио на Авраму шта му је обећао. ");
INSERT INTO srp1868_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","И рече Господ: Вика је у Содому и Гомору велика, и грех је њихов грдан. ");
INSERT INTO srp1868_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Зато ћу сићи да видим еда ли све чине као што вика дође преда ме; ако ли није тако, да знам. ");
INSERT INTO srp1868_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","И људи окренувши се пођоше пут Содома; али Аврам још стајаше пред Господом, ");
INSERT INTO srp1868_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","и приступив Аврам рече: Хоћеш ли погубити и праведног с неправедним? ");
INSERT INTO srp1868_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Може бити да има педесет праведника у граду; хоћеш ли и њих погубити, и нећеш опростити месту за оних педесет праведника што су у њему? ");
INSERT INTO srp1868_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Немој то чинити, ни губити праведника с неправедником, да буде праведнику као и неправеднику; немој; еда ли судија целе земље неће судити право? ");
INSERT INTO srp1868_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","И рече Господ: Ако нађем у Содому педесет праведника у граду, опростићу целом месту њих ради. ");
INSERT INTO srp1868_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","А Аврам одговори и рече: Гле, сада бих проговорио Господу, ако и јесам прах и пепео. ");
INSERT INTO srp1868_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Може бити праведника педесет мање пет, хоћеш ли за оних пет потрти сав град? Одговори: Нећу, ако нађем четрдесет и пет. ");
INSERT INTO srp1868_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","И стаде даље говорити, и рече: Може бити да ће се наћи четрдесет. Рече: Нећу ради оних четрдесет. ");
INSERT INTO srp1868_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Потом рече: Немој се гневити, Господе, што ћу рећи; може бити да ће се наћи тридесет. И рече: Нећу, ако нађем тридесет. ");
INSERT INTO srp1868_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Опет рече: Гле сада бих проговорио Господу; може бити да ће се наћи двадесет. Рече: Нећу их погубити за оних двадесет. ");
INSERT INTO srp1868_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Најпосле рече: Немој се гневити, Господе, што ћу још једном проговорити; може бити да ће се наћи десет. Рече: Нећу их погубити ради оних десет. ");
INSERT INTO srp1868_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","И Господ отиде свршивши разговор са Аврамом; а Аврам се врати на своје место. ");
INSERT INTO srp1868_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","А увече дођоше два анђела у Содом; а Лот сеђаше на вратима содомским; и кад их угледа, устаде те их срете, и поклони се лицем до земље, ");
INSERT INTO srp1868_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","и рече: Ходите, господо, у кућу слуге свог, и преноћите и оперите ноге своје; па сутра рано кад устанете пођите својим путем. А они рекоше: Не, него ћемо преноћити на улици. ");
INSERT INTO srp1868_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Али он навали на њих, те се увратише к њему и уђоше у кућу његову, и он их угости, и испече хлебова пресних, и једоше. ");
INSERT INTO srp1868_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","И још не беху легли, а грађани Содомљани слегоше се око куће, старо и младо, сав народ са свих крајева, ");
INSERT INTO srp1868_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","и викаху Лота и говораху му: Где су људи што дођоше синоћ к теби? Изведи их к нама да их познамо. ");
INSERT INTO srp1868_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","А Лот изиђе к њима пред врата затворивши врата за собом, ");
INSERT INTO srp1868_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","и рече им: Немојте, браћо, чинити зла. ");
INSERT INTO srp1868_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ево имам две кћери, које још не познаше човека; њих ћу вам извести, па чините с њима шта вам је воља; само не дирајте у ове људе, јер су зато ушли под мој кров. ");
INSERT INTO srp1868_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","А они рекоше: Ходи амо. Па онда рекоше: Овај је сам дошао амо да живи као дошљак, па још хоће да нам суди; сад ћемо теби учинити горе него њима. Па навалише јако на човека, на Лота, и стадоше истављати врата. ");
INSERT INTO srp1868_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","А она два човека дигоше руке, и увукоше Лота себи у кућу, и затворише врата. ");
INSERT INTO srp1868_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","А људе што беху пред вратима кућним уједанпут ослепише од најмањег до највећег, те не могаху наћи врата. ");
INSERT INTO srp1868_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Тада она два човека рекоше Лоту: Ако имаш овде још кога свог, или зета или сина или кћер, или кога год свог у овом граду, гледај нек иду одавде; ");
INSERT INTO srp1868_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","јер хоћемо да затремо место ово, јер је вика њихова велика пред Господом, па нас посла Господ да га затремо. ");
INSERT INTO srp1868_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","И изиђе Лот, и каза зетовима својим, за које хтеде дати кћери своје, и рече им: Устајте, идите из места овог, јер ће сада затрти Господ град овај. Али се зетовима његовим учини да се шали. ");
INSERT INTO srp1868_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","А кад зора забеле, навалише анђели на Лота говорећи: Устани, узми жену своју, и две кћери своје које су ту, да не погинеш у безакоњу града тог. ");
INSERT INTO srp1868_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","А он се стаде шчињати, те људи узеше за руку њега и жену његову и две кћери његове, јер га беше жао Господу и изведоше га и пустише га иза града. ");
INSERT INTO srp1868_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","И кад их изведоше напоље, рече један: Избави душу своју и не обзири се натраг и у целој овој равни да ниси стао; бежи на оно брдо да не погинеш. ");
INSERT INTO srp1868_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","А Лот им рече: Немој, Господе! ");
INSERT INTO srp1868_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Гле, слуга твој нађе милост пред Тобом, и милост је Твоја превелика коју ми учини сачувавши ми живот; али не могу утећи на брдо да ме не стигне зло и не погинем. ");
INSERT INTO srp1868_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ено град близу; онамо се може утећи, а мали је; да бежимо онамо; та мали је, те ћу остати жив. ");
INSERT INTO srp1868_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","А он му рече: Ето послушаћу те и зато, и нећу затрти града, за који рече. ");
INSERT INTO srp1868_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Брже бежи онамо; јер не могу чинити ништа док не стигнеш онамо. Зато се прозва онај град Сигор. ");
INSERT INTO srp1868_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","И кад сунце ограну по земљи, Лот дође у Сигор. ");
INSERT INTO srp1868_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Тада пусти Господ на Содом и на Гомор од Господа с неба дажд од сумпора и огња, ");
INSERT INTO srp1868_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","и затре оне градове и сву ону раван, и све људе у градовима и род земаљски. ");
INSERT INTO srp1868_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Али жена Лотова беше се обазрела идући за њим, и поста слан камен. ");
INSERT INTO srp1868_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","А сутрадан рано уставши Аврам, отиде на место где је стајао пред Господом; ");
INSERT INTO srp1868_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","и погледа на Содом и Гомор и сву околину по оној равни, и угледа, а то се дизаше дим од земље као дим из пећи. ");
INSERT INTO srp1868_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Али кад Бог затираше градове у оној равни, опомену се Бог Аврама, и изведе Лота из пропасти кад затре градове где живеше Лот. ");
INSERT INTO srp1868_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","А Лот отиде из Сигора и стани се на оном брду с две кћери своје, јер се бојаше остати у Сигору; и живеше у пећини с две кћери своје. ");
INSERT INTO srp1868_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","А старија рече млађој: Наш је отац стар, а нема никога на земљи да дође к нама, као што је обичај по свој земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Хајде да дамо оцу вина нека се опије, па да легнемо с њим, еда бисмо сачувале семе оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","И дадоше оцу вина ону ноћ; и дошавши старија леже с оцем својим, и он не осети ни кад она леже ни кад устаде. ");
INSERT INTO srp1868_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","А сутрадан рече старија млађој: Гле, ноћас спавах с оцем својим. Да му дамо вина и довече, па иди ти и лези с њим, еда бисмо сачувале семе оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Па и то вече дадоше оцу вина, и уставши млађа леже с њим, и он не осети ни кад она леже ни кад устаде. ");
INSERT INTO srp1868_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","И обе кћери Лотове затруднеше од оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","И старија роди сина, и надеде му име Моав; од њега су Моавци до данашњег дана. ");
INSERT INTO srp1868_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Па и млађа роди сина, и надеде му име Вен-Амије; од њега су Амонци до данашњег дана. ");
INSERT INTO srp1868_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","А Аврам отиде оданде на југ, и стани се између Кадиса и Сура; и живеше као дошљак у Герару. ");
INSERT INTO srp1868_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","И говораше за жену своју Сару: Сестра ми је. А цар герарски Авимелех посла те узе Сару. ");
INSERT INTO srp1868_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Али дође Бог Авимелеху ноћу у сну, и рече му: Гле, погинућеш са жене коју си узео, јер има мужа. ");
INSERT INTO srp1868_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","А Авимелех не беше се ње дотакао, и зато рече: Господе, еда ли ћеш и праведан народ погубити? ");
INSERT INTO srp1868_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Није ли ми сам казао: Сестра ми је? А и она сама каза: Брат ми је. Учинио сам у чистоти срца свог и у правди руку својих. ");
INSERT INTO srp1868_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Тада му рече Бог у сну: Знам да си учинио у чистоти срца свог, зато те сачувах да ми не сагрешиш, и не дадох да је се дотакнеш. ");
INSERT INTO srp1868_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","А сада врати човеку жену његову, јер је пророк, и молиће се за те, те ћеш остати жив. Ако ли не вратиш, знај да ћеш умрети ти и сви твоји. ");
INSERT INTO srp1868_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","И ујутру рано уста Авимелех, и сазва све слуге своје, и каза им све ово да чују. И уплашише се људи веома. ");
INSERT INTO srp1868_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Тада Авимелех дозва Аврама и рече му: Шта си нам учинио? Шта ли сам ти згрешио, те навуче на ме и на царство моје толико зло? Учинио си ми шта не ваља чинити. ");
INSERT INTO srp1868_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","И још рече Авимелех Авраму: Шта ти је било, те си то учинио? ");
INSERT INTO srp1868_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","А Аврам одговори: Говорих: јамачно нема страха Божјег у овом месту, па ће ме убити ради жене моје. ");
INSERT INTO srp1868_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","А управо и јесте ми сестра, кћи оца мог; али није кћи моје матере, па пође за ме. ");
INSERT INTO srp1868_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","А кад ме Бог изведе из дома оца мог, ја јој рекох: Учини добро, и кажи за ме где год дођемо: Брат ми је. ");
INSERT INTO srp1868_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Тада Авимелех узе оваца и говеда и слуга и слушкиња, те даде Авраму, и врати му Сару жену његову. ");
INSERT INTO srp1868_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","И рече Авимелех Авраму: Ево, земља ти је моја отворена, живи слободно где ти је воља. ");
INSERT INTO srp1868_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","А Сари рече: Ево дао сам твом брату хиљаду сребрника; гле, он ти је очима покривало пред свима који буду с тобом; и то све да ти је за науку. ");
INSERT INTO srp1868_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","И Аврам се помоли Богу, и исцели Бог Авимелеха и жену његову и слушкиње његове, те рађаху. ");
INSERT INTO srp1868_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Јер Господ беше сасвим затворио сваку материцу у дому Авимелеховом ради Саре жене Аврамове. ");
INSERT INTO srp1868_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","И Господ походи Сару, као што беше рекао и учини Господ Сари као што беше казао. ");
INSERT INTO srp1868_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Јер затрудне и роди Сара Авраму сина у старости његовој у исто време кад каза Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","И Аврам надеде име сину који му се роди, ког му роди Сара, Исак. ");
INSERT INTO srp1868_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","И обреза Аврам сина свог Исака кад би од осам дана, као што му заповеди Бог. ");
INSERT INTO srp1868_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","А Авраму беше сто година кад му се роди син Исак. ");
INSERT INTO srp1868_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","А Сара рече: Бог ми учини смех; ко год чује, смејаће ми се. ");
INSERT INTO srp1868_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","И рече: Ко би рекао Авраму да ће Сара дојити децу? Ипак му родих сина у старости његовој. ");
INSERT INTO srp1868_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","А кад дете дорасте да се одбије од сисе, учини Аврам велику гозбу онај дан кад одбише Исака од сисе. ");
INSERT INTO srp1868_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","И Сара виде сина Агаре Мисирке, која га роди Авраму, где се подсмева; ");
INSERT INTO srp1868_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","па рече Авраму: Отерај ову робињу са сином њеним, јер син ове робиње неће бити наследник с мојим сином, с Исаком. ");
INSERT INTO srp1868_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","А то Авраму би врло криво ради сина његовог. ");
INSERT INTO srp1868_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Али Бог рече Авраму: Немој да ти је криво ради детета и ради робиње твоје. Шта ти је год казала Сара, послушај; јер ће ти се у Исаку семе прозвати. ");
INSERT INTO srp1868_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Али ћу и од сина робињиног учинити народ, јер је твоје семе. ");
INSERT INTO srp1868_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","И Аврам устав ујутру рано, узе хлеба и мешину воде, и даде Агари метнувши јој на леђа, и дете, и отпусти је. А она отишавши луташе по пустињи вирсавској. ");
INSERT INTO srp1868_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","А кад неста воде у мешини, она баци дете под једно дрво, ");
INSERT INTO srp1868_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","па отиде колико се може стрелом добацити, и седе према њему; јер говораше: Да не гледам како ће умрети дете. И седећи према њему стаде гласно плакати. ");
INSERT INTO srp1868_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","А Бог чу глас детињи, и анђео Божји викну с неба Агару, и рече јој: Шта ти је Агаро? Не бој се, јер Бог чу глас детињи оданде где је. ");
INSERT INTO srp1868_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Устани, дигни дете и узми га у наручје; јер ћу од њега учинити велик народ. ");
INSERT INTO srp1868_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","И Бог јој отвори очи, те угледа студенац; и отишавши напуни мешину воде, и напоји дете. ");
INSERT INTO srp1868_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","И Бог беше с дететом, те одрасте, и живеше у пустињи и поста стрелац. ");
INSERT INTO srp1868_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","А живеше у пустињи Фарану. И мати га ожени из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","У то време рече Авимелех и Фихол војвода његов Авраму говорећи: Бог је с тобом у свему што радиш. ");
INSERT INTO srp1868_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Закуни ми се сада Богом да нећеш преварити мене ни сина мог ни унука мог него да ћеш добро онако како сам ја теби чинио и ти чинити мени и земљи у којој си дошљак. ");
INSERT INTO srp1868_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","А Аврам рече: Хоћу се заклети. ");
INSERT INTO srp1868_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Али Аврам прекори Авимелеха за студенац, који узеше на силу слуге Авимелехове. ");
INSERT INTO srp1868_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","А Авимелех рече: Не знам ко је то учинио; нити ми ти каза, нити чух до данас. ");
INSERT INTO srp1868_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Тада Аврам узе оваца и говеда, и даде Авимелеху, и ухвати веру међу собом. ");
INSERT INTO srp1868_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","А Аврам одлучи седам јагањаца из стада. ");
INSERT INTO srp1868_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","А Авимелех рече Авраму: Шта ће оно седам јагањаца што си одлучио? ");
INSERT INTO srp1868_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","А он одговори: Да примиш из моје руке оно седам јагањаца, да ми буде сведочанство да сам ја ископао овај студенац. ");
INSERT INTO srp1868_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Отуда се прозва оно место Вирсавеја, јер се онде заклеше обојица. ");
INSERT INTO srp1868_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Тако ухватише веру на Вирсавеји. Тада се диже Авимелех и Фихол војвода његов, и вратише се у земљу филистејску. ");
INSERT INTO srp1868_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","А Аврам посади луг на Вирсавеји, и онде призва име Господа Бога Вечног. ");
INSERT INTO srp1868_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","И Аврам живеше као дошљак у земљи филистејској много времена. ");
INSERT INTO srp1868_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","После тога хтеде Бог окушати Аврама, па му рече: Авраме! А он одговори: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","И рече му Бог: Узми сада сина свог, јединца свог милог, Исака, па иди у земљу Морију, и спали га на жртву тамо на брду где ћу ти казати. ");
INSERT INTO srp1868_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","И сутрадан рано уставши Аврам осамари магарца свог, и узе са собом два момка и Исака сина свог; и нацепавши дрва за жртву подиже се и пође на место које му каза Бог. ");
INSERT INTO srp1868_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Трећи дан подигавши очи своје Аврам угледа место из далека. ");
INSERT INTO srp1868_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","И рече Аврам момцима својим: Останите ви овде с магарцем, а ја и дете идемо онамо, па кад се помолимо Богу, вратићемо се к вама. ");
INSERT INTO srp1868_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","И узевши Аврам дрва за жртву напрти Исаку сину свом, а сам узе у своје руке огња и нож; па отидоше обојица заједно. ");
INSERT INTO srp1868_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Тада рече Исак Авраму оцу свом: Оче! А он рече: Шта је, сине! И рече Исак: Ето огња и дрва, а где је јагње за жртву? ");
INSERT INTO srp1868_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","А Аврам одговори: Бог ће се, синко, постарати за јагње себи на жртву. И иђаху обојица заједно. ");
INSERT INTO srp1868_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","А кад дођоше на место које му Бог каза, Аврам начини онде жртвеник, и метну дрва на њ, и свезавши Исака сина свог метну га на жртвеник врх дрва; ");
INSERT INTO srp1868_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","и измахну Аврам руком својом и узе нож да закоље сина свог. ");
INSERT INTO srp1868_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Али анђео Господњи викну га с неба, и рече: Авраме! Авраме! А он рече: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","А анђео рече: Не дижи руку своју на дете, и не чини му ништа; јер сада познах да се бојиш Бога, кад ниси пожалио сина свог, јединца свог, мене ради. ");
INSERT INTO srp1868_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","И Аврам подигавши очи своје погледа; и гле, ован иза њега заплео се у чести роговима; и отишавши Аврам узе овна и спали га на жртву место сина свог. ");
INSERT INTO srp1868_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","И назва Аврам оно место Господ ће се постарати. Зато се и данас каже: На брду, где ће се Господ постарати. ");
INSERT INTO srp1868_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","И анђео Господњи опет викну с неба Аврама. ");
INSERT INTO srp1868_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","И рече: Собом се заклех, вели Господ: кад си тако учинио, и ниси пожалио сина свог, јединца свог, ");
INSERT INTO srp1868_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","заиста ћу те благословити и семе твоје веома умножити, да га буде као звезда на небу и као песка на брегу морском; и наследиће семе твоје врата непријатеља својих; ");
INSERT INTO srp1868_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","и благословиће се у семену твом сви народи на земљи, кад си послушао глас мој. ");
INSERT INTO srp1868_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Тада се Аврам врати к момцима својим, те се дигоше, и отидоше заједно у Вирсавеју, јер Аврам живеше у Вирсавеји. ");
INSERT INTO srp1868_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","После тога јавише Авраму говорећи: Гле, и Мелха роди синове брату твом Нахору: ");
INSERT INTO srp1868_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Уза првенца и Вуза брата му, и Камуила, оца Арамовог, ");
INSERT INTO srp1868_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","и Хазада и Азава и Фалдеса и Јелдафа и Ватуила. ");
INSERT INTO srp1868_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","А Ватуило роди Ревеку. Осам их роди Мелха Нахору брату Аврамовом. ");
INSERT INTO srp1868_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","И иноча његова, по имену Ревма, роди и она Тавека и Гама и Тохоса и Моха. ");
INSERT INTO srp1868_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","А поживе Сара сто и двадесет и седам година; то су године века Сариног; ");
INSERT INTO srp1868_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","и умре Сара у Киријат-Арви, а то је Хеврон, у земљи хананској. И дође Аврам да ожали Сару и оплаче. ");
INSERT INTO srp1868_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","А кад уста Аврам од мртваца свог, рече синовима Хетовим говорећи: ");
INSERT INTO srp1868_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Странац сам и дошљак код вас; дајте ми да имам гроб код вас да погребем мртваца свог испред очију својих. ");
INSERT INTO srp1868_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","А синови Хетови одговорише Авраму говорећи му: ");
INSERT INTO srp1868_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Чуј нас, господару; ти си кнез од Бога међу нама; у најбољем гробу нашем погреби мртваца свог; нико између нас неће ти затворити гроб свој да не погребеш мртваца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Тада уста Аврам и поклони се народу земље оне, синовима Хетовим; ");
INSERT INTO srp1868_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","и рече им говорећи: Ако хоћете да погребем мртваца свог испред очију својих, послушајте ме, и говорите за мене Ефрону сину Саровом, ");
INSERT INTO srp1868_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","нека ми да пећину у Макпели, која је накрај њиве његове; за новце нека ми је да међу вама колико вреди, да имам гроб. ");
INSERT INTO srp1868_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","А Ефрон сеђаше усред синова Хетових. Па рече Ефрон Хетејин Авраму пред синовима Хетовим, који слушаху, пред свим који улажаху на врата града његовог, говорећи: ");
INSERT INTO srp1868_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Не, господару; чуј ме: поклањам ти њиву, и пећину код ње поклањам ти: пред синовима народа свог поклањам ти је, погреби мртваца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","А Аврам се поклони народу земље оне, ");
INSERT INTO srp1868_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","и рече Ефрону пред народом земље оне говорећи: Ако си вољан чуј ме; да ти дам шта вреди њива, узми од мене, па ћу онда погрепсти мртваца свог онде. ");
INSERT INTO srp1868_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","А Ефрон одговори Авраму говорећи му: ");
INSERT INTO srp1868_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Господару, чуј ме; земља вреди четири стотине сикала сребра између мене и тебе; шта је то? Само ти погреби мртваца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","А Аврам чувши Ефрона измери му сребро, које рече пред синовима Хетовим, четири стотине сикала сребра, како су ишли међу трговцима. ");
INSERT INTO srp1868_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","И њива Ефронова у Макпели према Мамрији, њива с пећином која је на њој, и сва дрвета на њиви и по међи њеној унаоколо, ");
INSERT INTO srp1868_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","поста Аврамова пред синовима Хетовим, пред свима који улазе на врата града оног. ");
INSERT INTO srp1868_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Потом погребе Аврам Сару жену своју у пећини на њиви Макпели према Мамрији, а то је Хеврон, у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","И потврдише синови Хетови њиву и пећину на њој Авраму да има гроб. ");
INSERT INTO srp1868_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","А Аврам беше стар и временит, и Господ беше благословио Аврама у свему; ");
INSERT INTO srp1868_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","и рече Аврам слузи свом најстаријем у кући својој, који беше над свим добром његовим: Метни руку своју под стегно моје, ");
INSERT INTO srp1868_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","да те закунем Господом Богом небеским и Богом земаљским да нећеш довести жене сину мом између кћери ових Хананеја, међу којима живим; ");
INSERT INTO srp1868_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","него да ћеш отићи у земљу моју и у род мој и довести жену сину мом Исаку. ");
INSERT INTO srp1868_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","А слуга му рече: и ако девојка не хтедбуде поћи са мном у ову земљу; хоћу ли одвести сина твог у земљу из које си се иселио? ");
INSERT INTO srp1868_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","А Аврам му рече: Пази да не одведеш сина мог онамо. ");
INSERT INTO srp1868_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Господ Бог небески, који ме је узео из дома оца мог и из земље рода мог, и који ми је рекао и заклео ми се говорећи: Семену ћу твом дати земљу ову, Он ће послати анђела свог пред тобом да доведеш жену сину мом оданде. ");
INSERT INTO srp1868_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ако ли девојка не хтедбуде поћи с тобом, онда да ти је проста заклетва моја; само сина мог немој одвести онамо. ");
INSERT INTO srp1868_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","И метну слуга руку своју под стегно Авраму господару свом, и закле му се за ово. ");
INSERT INTO srp1868_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Тада слуга узе десет камила између камила господара свог да иде, јер све благо господара његовог беше под његовом руком; и отишавши дође у Месопотамију до града Нахоровог. ");
INSERT INTO srp1868_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","И пусти камиле да полежу иза града код студенца пред вече кад излазе грађанке да захватају воде; ");
INSERT INTO srp1868_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","и рече: Господе Боже господара мог Аврама, дај ми срећу данас и учини милост господару мом Авраму. ");
INSERT INTO srp1868_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ево, ја ћу стајати код овог студенца, а грађанке ће доћи да захватају воде. ");
INSERT INTO srp1868_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Којој девојци кажем: Нагни крчаг свој да се напијем, а она рече: На пиј, и камиле ћу ти напојити; дај то да буде она коју си наменио слузи свом Исаку; и по томе да познам да си учинио милост господару мом. ");
INSERT INTO srp1868_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","И он још не изговори, а то Ревека, кћи Ватуила сина Мелхе жене Нахора брата Аврамовог, дође с крчагом на рамену. ");
INSERT INTO srp1868_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","И беше врло лепа, још девојка, још је човек не беше познао. Она сиђе на извор, и наточи крчаг, и пође; ");
INSERT INTO srp1868_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","а слуга искочи пред њу, и рече; дај ми да се напијем мало воде из крчага твог. ");
INSERT INTO srp1868_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","А она рече: На пиј, господару. И брже спусти крчаг на руку своју, и напоји га. ");
INSERT INTO srp1868_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","И кад га напоји, рече: и камилама ћу твојим налити нека се напију. ");
INSERT INTO srp1868_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","И брже изручи крчаг свој у појило, па опет отрча на студенац да налије, и нали свим камилама његовим. ");
INSERT INTO srp1868_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","А човек јој се дивљаше, и ћуташе, неће ли познати је ли Господ дао срећу путу његовом или није. ");
INSERT INTO srp1868_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","А кад се камиле напише, извади човек златну гривну од по сикала и метну јој око чела, и две наруквице метну јој на руке од десет сикала злата. ");
INSERT INTO srp1868_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","И рече: Чија си кћи? Кажи ми. Има ли у кући оца твог места за нас да преноћимо? ");
INSERT INTO srp1868_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","А она му рече: Ја сам кћи Ватуила сина Мелшиног, кога роди Нахору. ");
INSERT INTO srp1868_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Још рече: Има у нас много сламе и пиће и места за ноћиште. ");
INSERT INTO srp1868_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Тада човек савивши се поклони се Господу, ");
INSERT INTO srp1868_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","и рече: Благословен да је Господ Бог господара мог Аврама, што не остави милост своју и веру своју према господару мом, и путем доведе ме Господ у дом родбине господара мог. ");
INSERT INTO srp1868_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","А девојка отрча и све ово каза у дому матере своје. ");
INSERT INTO srp1868_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","А Ревека имаше брата, коме име беше Лаван; и истрча Лаван к човеку на студенац, ");
INSERT INTO srp1868_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","како виде гривну и наруквице на рукама сестре своје и чу где Ревека сестра му рече: Тако ми каза човек; дође к човеку; а он стајаше код камила на студенцу. ");
INSERT INTO srp1868_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","И рече: Ходи, који си благословен од Господа; што би стајао напољу? Спремио сам кућу, има места и за камиле. ");
INSERT INTO srp1868_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","И доведе човека у кућу, и растовари камиле; и додаше сламе и пиће камилама, и донесоше воде за ноге њему и људима што беху с њим; ");
INSERT INTO srp1868_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","и поставише му да једе; али он рече: Нећу јести докле не кажем ствар своју. А Лаван му рече: Говори. ");
INSERT INTO srp1868_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Тада рече: Ја сам слуга Аврамов. ");
INSERT INTO srp1868_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","А Господ је благословио господара мог веома, те је постао велик, и дао му је оваца и говеда, и сребра и злата, и слуга и слушкиња, и камила и магараца. ");
INSERT INTO srp1868_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","И још Сара жена господара мог роди сина господару мом у старости његовој, и он му даде све што има. ");
INSERT INTO srp1868_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","А мене закле господар мој говорећи: Немој довести сину мом жене између кћери ових Хананеја, међу којима живим; ");
INSERT INTO srp1868_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","него иди у дом оца мог и у род мој, да доведеш жену сину мом. ");
INSERT INTO srp1868_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","А ја рекох господару свом: Може бити да девојка неће хтети поћи са мном. ");
INSERT INTO srp1868_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","А он ми рече: Господ, по чијој вољи свагда живех, послаће анђела свог с тобом, и даће срећу твом путу да доведеш жену сину мом од рода мог, из дома оца мог. ");
INSERT INTO srp1868_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Онда ће ти бити проста заклетва моја, кад отидеш у род мој; ако ти је и не даду, опет ће ти бити проста заклетва моја. ");
INSERT INTO srp1868_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","И кад дођох данас на студенац, рекох: Господе Боже господара мог Аврама, ако си дао срећу путу мом, којим идем, ");
INSERT INTO srp1868_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ево, ја ћу стајати код студенца: која девојка дође да захвати воде, и ја јој кажем: Дај ми да се напијем мало воде из крчага твог, ");
INSERT INTO srp1868_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","а она ми одговори: и ти пиј и камилама ћу твојим налити; то нека буде жена коју је наменио Господ сину господара мог. ");
INSERT INTO srp1868_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ја још не изговорих у срцу свом, а дође Ревека с крчагом на рамену, и сишавши на извор захвати; и ја јој рекох: Дај ми да се напијем. ");
INSERT INTO srp1868_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","А она брже спустивши са себе крчаг рече: На пиј, и камиле ћу ти напојити. И кад се напих, напоји и камиле моје. ");
INSERT INTO srp1868_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","И запитах је говорећи: Чија си кћи? А она одговори: Ја сам кћи Ватуила сина Нахоровог, ког му роди Мелха. Тада јој метнух гривну око чела и наруквице на руке; ");
INSERT INTO srp1868_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","и падох и поклоних се Господу, и захвалих Господу Богу господара мог Аврама, што ме доведе правим путем да нађем кћер брата господара свог за сина његовог. ");
INSERT INTO srp1868_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ако ћете дакле учинити љубав и веру господару мом, кажите ми; ако ли нећете, кажите ми, да идем на десно или на лево. ");
INSERT INTO srp1868_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","А Лаван и Ватуило одговарајући рекоше: Од Господа је ово дошло; ми ти не можемо казати ни зло ни добро. ");
INSERT INTO srp1868_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ето, Ревека је у твојој власти, узми је па иди, и нека буде жена сину твог господара, као што каза Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","А кад чу слуга Аврамов речи њихове, поклони се Господу до земље; ");
INSERT INTO srp1868_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","и извади закладе сребрне и златне и хаљине, и даде Ревеци; такође и брату њеном и матери њеној даде дарове. ");
INSERT INTO srp1868_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Потом једоше и пише он и људи који беху с њим, и преноћише. А кад ујутру усташе, рече слуга: Пустите ме господару мом. ");
INSERT INTO srp1868_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","А брат и мати њена рекоше: Нека остане девојка код нас који дан, барем десет дана, па онда нека иде. ");
INSERT INTO srp1868_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","А он им рече: Немојте ме задржавати, кад је Господ дао срећу мом путу; пустите ме да идем господару свом. ");
INSERT INTO srp1868_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Тада рекоше: Да зовемо девојку, и упитамо шта она вели. ");
INSERT INTO srp1868_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","И дозваше Ревеку и рекоше јој: Хоћеш ићи с овим човеком? А она одговори: Хоћу. ");
INSERT INTO srp1868_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","И пустише Ревеку сестру своју и дојкињу њену са слугом Аврамовим и људима његовим. ");
INSERT INTO srp1868_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","И благословише Ревеку и рекоше јој: Сестро наша, да се намножиш на хиљаде хиљада, и семе твоје да наследи врата својих непријатеља! ");
INSERT INTO srp1868_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","И подиже се Ревека с девојкама својим, и поседаше на камиле, и пођоше с човеком; и слуга узевши Ревеку отиде. ");
INSERT INTO srp1868_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","А Исак иђаше враћајући се од студенца Живога који ме виде јер живљаше у јужном крају; ");
INSERT INTO srp1868_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","а беше изашао Исак у поље пред вече да се помоли Богу; и подигавши очи своје угледа камиле где иду. ");
INSERT INTO srp1868_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","И Ревека подигавши очи своје угледа Исака, те скочи с камиле, ");
INSERT INTO srp1868_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","и рече слузи: Ко је онај човек што иде преко поља пред нас? А слуга рече: Оно је господар мој. И она узе покривало и покри лице. ");
INSERT INTO srp1868_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","И приповеди слуга Исаку све што је свршио. ");
INSERT INTO srp1868_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","И одведе је Исак у шатор Саре матере своје; и узе Ревеку, и она му поста жена, и омиле му. И Исак се утеши за матером својом. ");
INSERT INTO srp1868_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","А Аврам узе другу жену, по имену Хетуру. ");
INSERT INTO srp1868_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","И она му роди Зомрана и Јоксана и Мадана и Мадијана и Јесвока и Соијена. ");
INSERT INTO srp1868_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","А Јоксан роди Савана и Дедана. А Деданови синови бише Асурим и Латусим и Лаомим. ");
INSERT INTO srp1868_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","А синови Мадијанови: Ефар и Афир и Енох и Авида и Елдага. Сви беху деца Хетурина. ");
INSERT INTO srp1868_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","А Аврам даде све што имаше Исаку; ");
INSERT INTO srp1868_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","а синовима својих иноча даде Аврам даре, и оправи их од Исака сина свог још за живота свог на исток, у источни крај. ");
INSERT INTO srp1868_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","И века Аврамовог што поживе беше сто и седамдесет и пет година. ");
INSERT INTO srp1868_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","И онемоћав умре Аврам у доброј старости, сит живота, и би прибран к роду свом. ");
INSERT INTO srp1868_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","И погребоше га Исак и Исмаило у пећини макпелској на њиви Ефрона сина Сара Хетејина, која је према Мамрији; ");
INSERT INTO srp1868_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","на њиви коју купи Аврам од синова Хетових, онде је погребен Аврам са Саром женом својом. ");
INSERT INTO srp1868_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","И по смрти Аврамовој благослови Бог Исака сина његовог; а Исак живеше код студенца Живога који ме види. ");
INSERT INTO srp1868_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","А ово је племе Исмаила сина Аврамовог, ког роди Авраму Агара Мисирка робиња Сарина, ");
INSERT INTO srp1868_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","и ово су имена синова Исмаилових, како се зваху у племенима својим; првенац Исмаилов Навајот, па Кидар и Навдеило и Масам, ");
INSERT INTO srp1868_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","и Масма и Дума и Маса, ");
INSERT INTO srp1868_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","и Хадар и Теман и Јетур и Нафис и Кедма. ");
INSERT INTO srp1868_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","То су синови Исмаилови, и то су им имена по селима и градовима њиховим, дванаест кнезова над својим народима. ");
INSERT INTO srp1868_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","А године су века Исмаиловог сто и тридесет и седам година. После онемоћав умре, и би прибран к роду свом. ");
INSERT INTO srp1868_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","И живеху од Евилата до Сура према Мисиру, како се иде у Асирију; и допаде му према свој браћи својој да живи. ");
INSERT INTO srp1868_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","А ово је племе Исака сина Аврамовог: Аврам роди Исака; ");
INSERT INTO srp1868_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","а Исаку беше четрдесет година кад се ожени Ревеком, кћерју Ватуила Сирина из Месопотамије, сестром Лавана Сирина. ");
INSERT INTO srp1868_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","И Исак се мољаше Господу за жену своју, јер беше нероткиња; и умоли Господа, те затрудне Ревека жена његова. ");
INSERT INTO srp1868_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Али удараху једно о друго деца у утроби њеној, те рече: Ако је тако, на шта сам? И отиде да пита Господа. ");
INSERT INTO srp1868_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","А Господ јој рече: Два су племена у утроби твојој, и два ће народа, изаћи из тебе; и један ће народ бити јачи од другог народа, и већи ће служити мањем. ");
INSERT INTO srp1868_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","И кад дође време да роди, а то близанци у утроби њеној. ");
INSERT INTO srp1868_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","И први изађе црвен, сав као руно рутав, и надеше му име Исав. ");
INSERT INTO srp1868_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","А после изађе брат му, држећи руком за пету Исава; и надеше му име Јаков. А беше Исаку шездесет година, кад их роди Ревека. ");
INSERT INTO srp1868_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","И деца одрастоше, и Исав поста ловац и ратар, а Јаков беше човек кротак и бављаше се у шаторима. ");
INSERT INTO srp1868_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","И Исак миловаше Исава, јер радо јеђаше лов његов; а Ревека миловаше Јакова. ");
INSERT INTO srp1868_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Једном Јаков скува јело, а Исав дође из поља уморан. ");
INSERT INTO srp1868_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","И рече Исав Јакову: Дај ми да једем то јело црвено, јер сам уморан. Отуда се прозва Едом. ");
INSERT INTO srp1868_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","А Јаков му рече: Продај ми данас првенаштво своје. ");
INSERT INTO srp1868_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","А Исав одговори: Ево, хоћу да умрем, па шта ће ми првенаштво? ");
INSERT INTO srp1868_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","А Јаков рече: Закуни ми се данас. И он му се закле; тако продаде своје првенаштво Јакову. ");
INSERT INTO srp1868_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","И Јаков даде Исаву хлеба и скуваног лећа, и он се наједе и напи, па уста и отиде. Тако Исав није марио за првенаштво своје. ");
INSERT INTO srp1868_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Али наста глад у земљи сврх прве глади која беше за времена Аврамовог; и Исак отиде к Авимелеху цару филистејском у Герар. ");
INSERT INTO srp1868_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","И јави му се Господ и рече: Немој ићи у Мисир, него седи у земљи коју ћу ти казати. ");
INSERT INTO srp1868_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Седи у тој земљи, и ја ћу бити с тобом, и благословићу те; јер ћу теби и семену твом дати све ове земље, и потврдићу заклетву, којом сам се заклео Авраму оцу твом. ");
INSERT INTO srp1868_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","И умножићу семе твоје да га буде као звезда на небу, и даћу семену твом све ове земље; и у семену твом благословиће се сви народи на земљи, ");
INSERT INTO srp1868_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","зато што је Аврам слушао глас мој и чувао наредбу моју, заповести моје и правила моја и законе моје. ");
INSERT INTO srp1868_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","И оста Исак у Герару. ");
INSERT INTO srp1868_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","А људи у месту оном питаху за жену његову, а он говораше: Сестра ми је. Јер се бојаше казати: Жена ми је; да ме, вели, не убију ови људи ради Ревеке, јер је лепа. ");
INSERT INTO srp1868_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","И кад проведе много времена онде, догоди се, те погледа Авимелех цар филистејски с прозора, и виде Исака где се шали с Ревеком женом својом. ");
INSERT INTO srp1868_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","И дозва Авимелех Исака и рече: Та то ти је жена; како си казао: Сестра ми је? А Исак му одговори: Рекох: да не погинем с ње. ");
INSERT INTO srp1868_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","А Авимелех рече: Шта си нам учинио? Лако је могао ко од народа овог лећи с твојом женом, те би нас ти увалио у грех. ");
INSERT INTO srp1868_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","И заповеди Авимелех свему народу свом говорећи: Ко се дотакне овог човека или жене његове, погинуће. ");
INSERT INTO srp1868_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","И Исак стаде сејати у оној земљи, и доби оне године по сто, тако га благослови Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","И обогати се човек, и напредоваше све већма, те поста силан. ");
INSERT INTO srp1868_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","И имаше оваца и говеда и много слуга; а Филистеји му завиђаху, ");
INSERT INTO srp1868_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","па све студенце које беху ископале слуге оца његовог за времена Аврама оца његовог заронише Филистеји, и засуше их земљом. ");
INSERT INTO srp1868_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","И Авимелех рече Исаку: Иди од нас, јер си постао силнији од нас. ");
INSERT INTO srp1868_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","И Исак отиде, оданде, и разапе шаторе у долини герарској, и настани се онде. ");
INSERT INTO srp1868_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","И стаде Исак откопавати студенце, који беху ископани за времена Аврама оца његовог, и које заронише Филистеји по смрти Аврамовој; и прозва их именима која им беше надео отац његов. ");
INSERT INTO srp1868_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","И копајући слуге Исакове у оном долу нађоше студенац живе воде. ");
INSERT INTO srp1868_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Али се свађаше пастири герарски с пастирима Исаковим говорећи: Наша је вода. И надеде име оном студенцу Есек, јер се свадише с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","После ископаше други студенац, па се и око њега свађаше, зато га назва Ситна. ");
INSERT INTO srp1868_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Тада се подиже оданде, и ископа други студенац, и око њега не би свађе; зато га назва Реховот, говорећи: Сад нам даде Господ простора да растемо у овој земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","И отиде оданде горе у Вирсавеју. ");
INSERT INTO srp1868_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","И исту ноћ јави му се Господ, и рече: Ја сам Бог Аврама оца твог. Не бој се, јер сам ја с тобом, и благословићу те и умножићу семе твоје Аврама ради слуге свог. ");
INSERT INTO srp1868_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","И начини онде жртвеник, и призва име Господње; и онде разапе шатор свој; и слуге Исакове ископаше онде студенац. ");
INSERT INTO srp1868_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","И дође к њему Авимелех из Герара с Охозатом пријатељем својим и с Фихолом војводом својим. ");
INSERT INTO srp1868_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","А Исак им рече: Што сте дошли к мени, кад мрзите на ме и отерасте ме од себе? ");
INSERT INTO srp1868_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","А они рекоше: Видесмо заиста да је Господ с тобом, па рекосмо: Нека буде заклетва између нас, између нас и тебе; хајде да ухватимо веру с тобом; ");
INSERT INTO srp1868_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","да нам не чиниш зла, као што се ми тебе не дотакосмо и као што ми теби само добро чинисмо, и пустисмо те да идеш на миру, и ето си благословен од Господа. ");
INSERT INTO srp1868_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Тада их он угости; те једоше и пише. ");
INSERT INTO srp1868_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","А сутрадан уставши рано, заклеше се један другом, и отпусти их Исак и отидоше од њега с миром. ");
INSERT INTO srp1868_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Исти дан дошавши слуге Исакове казаше му за студенац који ископаше, и рекоше му: Нађосмо воду. ");
INSERT INTO srp1868_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","И назва га Савеја; отуда се зове град онај Вирсавеја до данашњег дана. ");
INSERT INTO srp1868_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","А кад би Исаву четрдесет година, узе за жену Јудиту, кћер Веоха Хетејина, и Васемату кћер Елона Хетејина. ");
INSERT INTO srp1868_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","И оне задаваху много јада Исаку и Ревеци. ");
INSERT INTO srp1868_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Кад Исак остаре и очи му потамнеше, те не видеше, дозва Исава старијег сина свог, и рече му: Сине! А он одговори: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Тада рече: Ево остарео сам, не знам кад ћу умрети; ");
INSERT INTO srp1868_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","узми оружје своје, тул и лук, и изађи у планину, те ми улови лов; ");
INSERT INTO srp1868_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","и зготови ми јело по мојој вољи, и донеси ми да једем, па да те благослови душа моја док нисам умро. ");
INSERT INTO srp1868_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","А Ревека чу шта Исак рече сину свом Исаву. И Исав отиде у планину да улови лов и донесе. ");
INSERT INTO srp1868_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","А Ревека рече Јакову, сину свом говорећи: Гле, чух оца твог где говори с Исавом, братом твојим и рече: ");
INSERT INTO srp1868_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Донеси ми лов, и зготови јело да једем, па да те благословим пред Господом док нисам умро. ");
INSERT INTO srp1868_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Него сада, сине, послушај ме шта ћу ти казати. ");
INSERT INTO srp1868_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Иди сада к стаду и донеси два добра јарета, да зготовим оцу твом јело од њих, како радо једе. ");
INSERT INTO srp1868_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Па ћеш унети оцу да једе и да те благослови док није умро. ");
INSERT INTO srp1868_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","А Јаков рече Ревеци матери својој: Али је Исав брат мој рутав, а ја сам гладак; ");
INSERT INTO srp1868_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","може ме опипати отац, па ће се осетити да сам га хтео преварити, те ћу навући на се проклетство место благослова. ");
INSERT INTO srp1868_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","А мати му рече: Нека проклетство твоје, сине падне на мене; само ме послушај, и иди и донеси ми. ");
INSERT INTO srp1868_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Тада отишавши узе и донесе матери својој; а мати његова зготови јело како јеђаше радо отац његов. ");
INSERT INTO srp1868_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Па онда узе Ревека најлепше хаљине старијег сина свог, које беху у ње код куће, и обуче Јакова млађег сина свог. ");
INSERT INTO srp1868_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","И јарећим кожицама обложи му руке и врат где беше гладак. ");
INSERT INTO srp1868_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","И даде Јакову сину свом у руке јело и хлеб што зготови. ");
INSERT INTO srp1868_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","А он уђе к оцу свом и рече: Оче. А он одговори: Ево ме; који си ти, сине? ");
INSERT INTO srp1868_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","И Јаков рече оцу свом: Ја, Исав твој првенац; учинио сам како си ми рекао; дигни се, посади се да једеш лов мој, па да ме благослови душа твоја. ");
INSERT INTO srp1868_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","А Исак рече сину свом: Кад брже нађе, сине? А он рече: Господ Бог твој даде, те изађе преда ме. ");
INSERT INTO srp1868_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Тада рече Исак Јакову: Ходи ближе, сине да те опипам јеси ли син мој Исав или не. ");
INSERT INTO srp1868_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","И приступи Јаков к Исаку оцу свом, а он га опипа, па рече: Глас је Јаковљев, али руке су Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","И не позна га, јер му руке беху као у Исава брата његовог рутаве: Зато га благослови; ");
INSERT INTO srp1868_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","и рече му: Јеси ли ти син мој Исав? А он одговори: Ја сам. ");
INSERT INTO srp1868_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Тада рече: А ти дај, сине, да једем лов твој, па да те благослови душа моја. И даде му, те једе; па му донесе и вино те пи. ");
INSERT INTO srp1868_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Потом Исак, отац његов рече му: Ходи сине, целивај ме. ");
INSERT INTO srp1868_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","И он приступи и целива га; а Исак осети мирис од хаљина његових, и благослови га говорећи: Гле, мирис сина мог као мирис од поља које благослови Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Бог ти дао росе небеске, и добре земље и пшенице и вина изобила! ");
INSERT INTO srp1868_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Народи ти служили и племена ти се клањала! Био господар браћи својој и клањали ти се синови матере твоје! Проклет био који тебе успроклиње, а благословен који тебе узблагосиља! ");
INSERT INTO srp1868_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","А кад Исак благослови Јакова, и Јаков отиде испред Исака оца свог, у тај час дође Исав брат његов из лова. ");
INSERT INTO srp1868_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Па зготови и он јело и унесе оцу свом, и рече му: Устани, оче, да једеш шта ти је син уловио, па да ме благослови душа твоја. ");
INSERT INTO srp1868_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","А Исак отац његов рече му: Ко си ти? А он рече: Ја, син твој, првенац твој Исав. ");
INSERT INTO srp1868_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Тада се препаде Исак, и рече: Ко? Да где је онај који улови и донесе ми лова, и од свега једох пре него ти дође, и благослових га? Он ће и остати благословен. ");
INSERT INTO srp1868_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","А кад чу Исав речи оца свог, врисну гласно и ожалости се веома, и рече оцу свом: Благослови и мене, оче. ");
INSERT INTO srp1868_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","А он му рече: Дође брат твој с преваром, и однесе твој благослов. ");
INSERT INTO srp1868_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","А Исав рече: Право је што му је име Јаков, јер ме већ другом превари. Првенаштво ми узе, па ето сада ми узе и благослов. Потом рече: Ниси ли и мени оставио благослов? ");
INSERT INTO srp1868_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","А Исак одговори, и рече Исаву: Ето сам га поставио теби за господара; и сву браћу његову дадох му да му буду слуге; пшеницом и вином укрепих га; па шта бих сада теби учинио, сине? ");
INSERT INTO srp1868_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","И Исав рече оцу свом: Еда ли је само један благослов у тебе, оче? Благослови и мене, оче. И стаде гласно плакати Исав. ");
INSERT INTO srp1868_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","А Исак отац његов одговарајући рече му: Ево, стан ће ти бити на родној земљи и роси небеској озго. ");
INSERT INTO srp1868_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Али ћеш живети од мача свог, и брату ћеш свом служити; али ће доћи време, те ћеш пошто се наплачеш скршити јарам његов с врата свог. ");
INSERT INTO srp1868_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","И Исав омрзе љуто на Јакова ради благослова, којим га благослови отац, и говораше у срцу свом: Близу су жалосни дани оца мог, тада ћу убити Јакова брата свог. ");
INSERT INTO srp1868_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","И казаше Ревеци речи Исава сина њеног старијег, а она пославши дозва Јакова млађег сина свог, и рече му: Гле, Исав брат твој теши се тиме што хоће да те убије. ");
INSERT INTO srp1868_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Него, сине, послушај шта ћу ти казати; устани и бежи к Лавану брату мом у Харан. ");
INSERT INTO srp1868_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","И остани код њега неко време докле прође срдња брата твог, ");
INSERT INTO srp1868_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","докле се гнев брата твог одврати од тебе, те заборави шта си му учинио; а онда ћу ја послати да те доведу оданде. Зашто бих остала без обојице вас у један дан? ");
INSERT INTO srp1868_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","А Исаку рече Ревека: Омрзао ми је живот ради ових Хетејака. Ако се Јаков ожени Хетејком, каквом између кћери ове земље, на шта ми живот? ");
INSERT INTO srp1868_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Тада Исак дозва Јакова, и благослови га, и заповеди му и рече: Немој да се ожениш којом између кћери хананејских. ");
INSERT INTO srp1868_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Устани, иди у Падан-Арам у дом Ватуила оца матере своје, и оданде се ожени између кћери Лавана ујака свог. ");
INSERT INTO srp1868_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","А Бог Свемогући да те благослови, и да ти да велику породицу и умножи те, да од тебе постане мноштво народа, ");
INSERT INTO srp1868_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","и да ти да благослов Аврамов, теби и семену твом с тобом, да наследиш земљу у којој си дошљак, коју Бог даде Авраму. ");
INSERT INTO srp1868_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Тако оправи Исак Јакова, и он пође у Падан-Арам к Лавану сину Ватуила Сирина, брату Ревеке матере Јаковљеве и Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","А Исав виде где Исак благослови Јакова и оправи га у Падан-Арам да се оданде ожени, и где благосиљајући га заповеди му и рече: Немој да се ожениш којом између кћери хананејских, ");
INSERT INTO srp1868_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","и где Јаков послуша оца свог и матер своју, и отиде у Падан-Арам; ");
INSERT INTO srp1868_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","и виде Исав да кћери хананејске нису по вољи Исаку оцу његовом. ");
INSERT INTO srp1868_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Па отиде Исав к Исмаилу, и узе за жену преко жена својих Маелету, кћер Исмаила сина Аврамовог, сестру Навеотову. ");
INSERT INTO srp1868_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","А Јаков отиде од Вирсавеје идући у Харан. ");
INSERT INTO srp1868_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","И дође на једно место, и онде заноћи, јер сунце беше зашло; и узе камен на оном месту, и метну га себи под главу, и заспа на оном месту. ");
INSERT INTO srp1868_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","И усни, а то лестве стајаху на земљи а врхом тицаху у небо, и гле, анђели Божји по њима се пењаху и силажаху; ");
INSERT INTO srp1868_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","и гле, на врху стајаше Господ, и рече: Ја сам Господ Бог Аврама оца твог и Бог Исаков; ту земљу на којој спаваш теби ћу дати и семену твом; ");
INSERT INTO srp1868_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","и семена ће твог бити као праха на земљи, те ћеш се раширити на запад и на исток и на север и на југ, и сви народи на земљи благословиће се у теби и у семену твом. ");
INSERT INTO srp1868_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","И ево, ја сам с тобом, и чуваћу те куда год пођеш, и довешћу те натраг у ову земљу, јер те нећу оставити докле год не учиним шта ти рекох. ");
INSERT INTO srp1868_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","А кад се Јаков пробуди од сна, рече: Зацело је Господ на овом месту; а ја не знах. ");
INSERT INTO srp1868_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","И уплаши се, и рече: Како је страшно место ово! Овде је доиста кућа Божја, и ово су врата небеска. ");
INSERT INTO srp1868_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","И уста Јаков ујутру рано, и узе камен што беше метнуо себи под главу, и утврди га за спомен и прели га уљем. ");
INSERT INTO srp1868_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","И прозва оно место Ветиљ, а пре беше име оном граду Луз. ");
INSERT INTO srp1868_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","И учини Јаков завет, говорећи: Ако Бог буде са мном и сачува ме на путу којим идем и да ми хлеба да једем и одела да се облачим, ");
INSERT INTO srp1868_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","и ако се вратим на миру у дом оца свог, Господ ће ми бити Бог; ");
INSERT INTO srp1868_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","а камен овај који утврдих за спомен биће дом Божји; и шта ми год даш, од свега ћу десето дати Теби. ");
INSERT INTO srp1868_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Тада се подиже Јаков и отиде у земљу источну. ");
INSERT INTO srp1868_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","И обзирући се угледа студенац у пољу; и гле, три стада оваца лежаху код њега, јер се на оном студенцу појаху стада, а велики камен беше студенцу на вратима. ");
INSERT INTO srp1868_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Онде се скупљаху сва стада, те пастири одваљиваху камен с врата студенцу и појаху стада, и после опет приваљиваху камен на врата студенцу на његово место. ");
INSERT INTO srp1868_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","И Јаков им рече: Браћо, одакле сте? Рекоше: Из Харана смо. ");
INSERT INTO srp1868_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","А он им рече: Познајете ли Лавана сина Нахоровог? Они рекоше: Познајемо. ");
INSERT INTO srp1868_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Он им рече: Је ли здрав? Рекоше: Јесте, и ево Рахиље кћери његове, где иде са стадом. ");
INSERT INTO srp1868_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","И он рече: Ето још је рано, нити је време враћати стоку; напојте стоку па идите и пасите је. ");
INSERT INTO srp1868_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","А они рекоше: Не можемо, докле се не скупе сва стада, да одвалимо камен с врата студенцу, онда ћемо напојити стоку. ");
INSERT INTO srp1868_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Док он још говораше с њима, дође Рахиља са стадом оца свог, јер она пасаше овце. ");
INSERT INTO srp1868_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","А кад Јаков виде Рахиљу кћер Лавана ујака свог, и стадо Лавана ујака свог, приступи Јаков и одвали камен студенцу с врата, и напоји стадо Лавана ујака свог. ");
INSERT INTO srp1868_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","И пољуби Јаков Рахиљу, и повикавши заплака се. ");
INSERT INTO srp1868_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","И каза се Јаков Рахиљи да је род оцу њеном и да је син Ревечин; а она отрча те јави оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","А кад Лаван чу за Јакова сина сестре своје, истрча му на сусрет, и загрли га и пољуби, и уведе у своју кућу. И он приповеди Лавану све ово. ");
INSERT INTO srp1868_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","А Лаван му рече: Та ти си кост моја и тело моје. И оста код њега цео месец дана. ");
INSERT INTO srp1868_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Тада рече Лаван Јакову: Зар бадава да ми служиш, што си ми род? Кажи ми шта ће ти бити плата? ");
INSERT INTO srp1868_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","А Лаван имаше две кћери: старијој беше име Лија, а млађој Рахиља. ");
INSERT INTO srp1868_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","И у Лије беху кварне очи, а Рахиља беше лепог стаса и лепог лица. ");
INSERT INTO srp1868_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","И Јакову омиле Рахиља, те рече: Служићу ти седам година за Рахиљу, млађу кћер твоју. ");
INSERT INTO srp1868_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","А Лаван му рече: Боље теби да је дам него другом; остани код мене. ");
INSERT INTO srp1868_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","И одслужи Јаков за Рахиљу седам година, и учинише му се као неколико дана, јер је љубљаше. ");
INSERT INTO srp1868_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","И рече Јаков Лавану: Дај ми жену, јер ми се наврши време, да легнем с њом. ");
INSERT INTO srp1868_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","И сазва Лаван све људе из оног места и учини гозбу. ");
INSERT INTO srp1868_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","А увече узе Лију кћер своју и уведе је к Јакову, и он леже с њом. ");
INSERT INTO srp1868_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","И Лаван даде Зелфу робињу своју Лији кћери својој да јој буде робиња. ");
INSERT INTO srp1868_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","А кад би ујутру, гле, оно беше Лија; те рече Јаков Лавану: Шта си ми то учинио? Не служим ли за Рахиљу код тебе? Зашто си ме преварио? ");
INSERT INTO srp1868_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","А Лаван му рече: Не бива у нашем месту да се уда млађа пре старије. ");
INSERT INTO srp1868_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Наврши недељу дана с том, па ћемо ти дати и другу за службу што ћеш служити код мене још седам година других. ");
INSERT INTO srp1868_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Јаков учини тако, и наврши с њом недељу дана, па му даде Лаван Рахиљу кћер своју за жену. ");
INSERT INTO srp1868_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","И даде Лаван Рахиљи кћери својој робињу своју Валу да јој буде робиња. ");
INSERT INTO srp1868_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","И тако леже Јаков с Рахиљом; и вољаше Рахиљу него Лију, и стаде служити код Лавана још седам других година. ");
INSERT INTO srp1868_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","А Господ видећи да Јаков не мари за Лију, отвори њој материцу, а Рахиља оста нероткиња. ");
INSERT INTO srp1868_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","И Лија затрудне, и роди сина, и надеде му име Рувим, говорећи: Господ погледа на јаде моје, сада ће ме љубити муж мој. ");
INSERT INTO srp1868_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","И опет затрудне, и роди сина и рече: Господ чу да сам презрена, па ми даде и овог. И надеде му име Симеун. ");
INSERT INTO srp1868_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","И опет затрудне, и роди сина, и рече: Да ако се сада већ приљуби к мени муж мој, кад му родих три сина. Зато му надеше име Левије. ");
INSERT INTO srp1868_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","И затрудне опет, и роди сина, и рече: Сада ћу хвалити Господа. Зато му надеде име Јуда; и преста рађати. ");
INSERT INTO srp1868_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","А Рахиља видевши где не рађа деце Јакову, позавиде сестри својој; и рече Јакову: Дај ми деце, или ћу умрети. ");
INSERT INTO srp1868_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","А Јаков се расрди на Рахиљу, и рече: Зар сам ја а не Бог који ти не да порода? ");
INSERT INTO srp1868_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","А она рече: Ето робиње моје Вале, лези с њом, нека роди на мојим коленима, па ћу и ја имати деце од ње. ");
INSERT INTO srp1868_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","И даде му Валу робињу своју за жену, и Јаков леже с њом. ");
INSERT INTO srp1868_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","И затрудне Вала, и роди Јакову сина. ");
INSERT INTO srp1868_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","А Рахиља рече: Господ ми је судио и чуо глас мој, те ми даде сина. Зато му надеде име Дан. ");
INSERT INTO srp1868_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","И Вала робиња Рахиљина затрудне опет, и роди другог сина Јакову; ");
INSERT INTO srp1868_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","а Рахиља рече: Борах се жестоко са сестром својом, али одолех. И надеде му име Нефталим. ");
INSERT INTO srp1868_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","А Лија видевши где преста рађати узе Зелфу робињу своју и даде је Јакову за жену. ");
INSERT INTO srp1868_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","И роди Зелфа робиња Лијина Јакову сина; ");
INSERT INTO srp1868_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","и Лија рече: Дође чета. И надеде му име Гад. ");
INSERT INTO srp1868_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Опет роди Зелфа робиња Лијина другог сина Јакову; ");
INSERT INTO srp1868_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","и рече Лија: Благо мени, јер ће ме блаженом звати жене. Зато му надеде име Асир. ");
INSERT INTO srp1868_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","А Рувим изиђе у време жетве пшеничне и нађе мандрагору у пољу, и донесе је Лији матери својој. А Рахиља рече Лији: Дај ми мандрагору сина свог. ");
INSERT INTO srp1868_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","А она јој рече: Мало ли ти је што си ми узела мужа? Хоћеш да ми узмеш и мандрагору сина мог? А Рахиља јој рече: Нека ноћас спава с тобом за мандрагору сина твог. ");
INSERT INTO srp1868_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","И увече кад се Јаков враћаше из поља, изиђе му Лија на сусрет и рече: Спаваћеш код мене, јер те купих за мандрагору сина свог. И спава код ње ону ноћ. ");
INSERT INTO srp1868_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","А Бог услиши Лију, те она затрудне, и роди Јакову петог сина. ");
INSERT INTO srp1868_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","И рече Лија: Господ ми даде плату моју што дадох робињу своју мужу свом. И надеде му име Исахар. ");
INSERT INTO srp1868_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","И затрудне Лија опет, и роди Јакову шестог сина; ");
INSERT INTO srp1868_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","и рече Лија: Дарива ме Господ даром добрим; да ако се сада већ приљуби к мени муж мој, јер му родих шест синова. Зато му надеде име Завулон. ");
INSERT INTO srp1868_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Најпосле роди кћер, и надеде јој има Дина. ");
INSERT INTO srp1868_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Али се Господ опомену Рахиље; и услишивши је отвори јој материцу. ");
INSERT INTO srp1868_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","И затрудне, и роди сина, и рече: Узе Бог срамоту моју. ");
INSERT INTO srp1868_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","И надеде му име Јосиф, говорећи: Нека ми дода Господ још једног сина. ");
INSERT INTO srp1868_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","А кад Рахиља роди Јосифа, рече Јаков Лавану: Пусти ме да идем у своје место и у своју земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дај ми жене моје, за које сам ти служио, и децу моју, да идем, јер знаш како сам ти служио. ");
INSERT INTO srp1868_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","А Лаван му рече: Немој, ако сам нашао милост пред тобом; видим да ме је благословио Господ тебе ради. ");
INSERT INTO srp1868_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","И још рече: Ишти колико хоћеш плате, и ја ћу ти дати. ");
INSERT INTO srp1868_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","А Јаков му одговори: Ти знаш како сам ти служио и каква ти је стока постала код мене. ");
INSERT INTO srp1868_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Јер је мало било што си имао докле ја не дођох; али се умножи веома, јер те Господ благослови кад ја дођох. Па кад ћу и ја тако себи кућу кућити? ");
INSERT INTO srp1868_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","И рече му Лаван: Шта хоћеш да ти дам? А Јаков одговори: Не треба ништа да ми даш; него ћу ти опет пасти стоку и чувати, ако ћеш ми учити ово: ");
INSERT INTO srp1868_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Да зађем данас по свој стоци твојој, и одлучим све што је шарено и с белегом, и све што је црно између оваца, и шта је с белегом и шарено између коза, па шта после буде тако, оно да ми је плата. ");
INSERT INTO srp1868_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Тако ће ми се после посведочити правда моја пред тобом кад дођеш да видиш заслугу моју: Шта год не буде шарено ни с белегом ни црно између оваца и коза у мене, биће крадено. ");
INSERT INTO srp1868_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","А Лаван рече: Ето, нека буде како си казао. ");
INSERT INTO srp1868_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","И одлучи Лаван исти дан јарце с белегом и шарене и све козе с белегом и шарене, и све на чем беше шта бело, и све црно између оваца, и предаде синовима својим. ");
INSERT INTO srp1868_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","И остави даљине три дана хода између себе и Јакова. И Јаков пасаше осталу стоку Лаванову. ");
INSERT INTO srp1868_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","И узе Јаков зелених прутова тополових и лескових и кестенових, и нагули их до белине која беше на прутовима. ");
INSERT INTO srp1868_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","И меташе нагуљене прутове пред стоку у жлебове и корита кад долажаше стока да пије, да би се упаљивала кад дође да пије. ");
INSERT INTO srp1868_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","И упаљиваше се стока гледајући у прутове, и шта се млађаше беше с белегом, прутасто и шарено. ");
INSERT INTO srp1868_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","И Јаков одлучиваше млад, и обраћаше стадо Лаваново да гледа у шарене и у све црне; а своје стадо одвајаше и не обраћаше га према стаду Лавановом. ");
INSERT INTO srp1868_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","И кад се год упаљиваше стока рана, меташе Јаков прутове у корита пред очи стоци да би се упаљивала гледајући у прутове; ");
INSERT INTO srp1868_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","а кад се упаљиваше позна стока, не меташе; тако позне биваху Лаванове а ране Јаковљеве. ");
INSERT INTO srp1868_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","И тако се тај човек обогати врло, те имаше много стоке и слуга и слушкиња и камила и магараца. ");
INSERT INTO srp1868_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","А Јаков чу где синови Лаванови говоре: Јаков узе све што беше нашег оца, и од оног што беше нашег оца стече све ово благо. ");
INSERT INTO srp1868_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","И виде Јаков где лице Лаваново није према њему као пре. ");
INSERT INTO srp1868_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","И Господ рече Јакову: Врати се у земљу отаца својих и у род свој, и ја ћу бити с тобом. ");
INSERT INTO srp1868_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","И пославши Јаков дозва Рахиљу и Лију у поље к стаду свом. ");
INSERT INTO srp1868_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","И рече им: Видим где лице оца вашег није према мени као пре; али је Бог оца мог био са мном. ");
INSERT INTO srp1868_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","И ви знате да сам служио оцу вашем како сам год могао; ");
INSERT INTO srp1868_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","а отац ме је ваш варао и мењао ми плату десет пута; али му Бог не даде да ме оштети; ");
INSERT INTO srp1868_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","кад он рече: Шта буде шарено нека ти је плата, онда се младило све шарено; а кад рече: С белегом шта буде нека ти је плата, онда се младило све с белегом. ");
INSERT INTO srp1868_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Тако Бог узе стоку оцу вашем и даде је мени; ");
INSERT INTO srp1868_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","јер кад се упаљиваше стока, подигох очи своје и видех у сну, а то овнови и јарци што скачу на овце и козе беху шарени, с белегама прутастим и коластим. ");
INSERT INTO srp1868_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","А анђео Господњи рече ми у сну: Јакове! А ја одговорих: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","А он рече: Подигни сад очи своје и гледај, овнови и јарци што скачу на овце и козе, шарени су, с белегама прутастим и коластим; јер видех све што ти чини Лаван. ");
INSERT INTO srp1868_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ја сам Бог од Ветиља, где си прелио камен и учинио ми завет; устани сада и иди из ове земље, и врати се на постојбину своју. ");
INSERT INTO srp1868_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Тада одговори Рахиља и Лија, и рекоше му: Еда ли још имамо какав део и наследство у дому оца свог? ");
INSERT INTO srp1868_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Није ли нас држао као туђинке кад нас је продао? Па је још и наше новце једнако јео. ");
INSERT INTO srp1868_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Јер све ово благо што узе Господ оцу нашем, наше је и наше деце. Зато чини све што ти је Господ казао. ");
INSERT INTO srp1868_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","И подиже се Јаков, и метну децу своју и жене своје на камиле; ");
INSERT INTO srp1868_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","и одведе сву стоку своју и све благо што беше стекао, стоку коју беше стекао у Падан-Араму, и пође к Исаку оцу свом у земљу хананску. ");
INSERT INTO srp1868_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","А Лаван беше отишао да стриже овце своје; и Рахиља украде идоле оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","И Јаков отиде крадом од Лавана Сирина не јавивши му да хоће да иде. ");
INSERT INTO srp1868_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","И побеже са свим благом својим, и подиже се те пређе преко воде, и упути се ка гори Галаду. ");
INSERT INTO srp1868_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","А трећи дан јавише Лавану да је побегао Јаков. ");
INSERT INTO srp1868_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","И узе са собом браћу своју, и пође за њим у потеру, и за седам дана стиже га на гори Галаду. ");
INSERT INTO srp1868_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Али Бог дође Лавану Сирину ноћу у сну, и рече му: Чувај се да не говориш с Јаковом ни лепо ни ружно. ");
INSERT INTO srp1868_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","И стиже Лаван Јакова; а Јаков беше разапео шатор свој на гори, па и Лаван такође разапе свој с браћом својом на гори Галаду. ");
INSERT INTO srp1868_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","И Лаван рече Јакову: Шта учини те крадом побеже од мене и одведе кћери моје као на мач отете? ");
INSERT INTO srp1868_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Зашто тајно побеже и крадом отиде од мене? Нити ми рече да те испратим с весељем и с песмама, с бубњевима и гуслама? ");
INSERT INTO srp1868_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Нити ми даде да изљубим синове своје и кћери своје? Лудо си радио. ");
INSERT INTO srp1868_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Могао бих вам досадити; али Бог оца вашег ноћас ми рече говорећи: Чувај се да не говориш с Јаковом ни лепо ни ружно. ");
INSERT INTO srp1868_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Иди дакле кад си се тако ужелео куће оца свог; али зашто украде богове моје? ");
INSERT INTO srp1868_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","А Јаков одговори и рече: Бојах се и мишљах хоћеш силом отети кћери своје од мене. ");
INSERT INTO srp1868_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","А богове своје у кога нађеш, онај нека не живи више; пред нашом браћом тражи шта је твоје у мене, па узми. Јер Јаков није знао да их је украла Рахиља. ");
INSERT INTO srp1868_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","И уђе Лаван у шатор Јаковљев и у шатор Лијин и у шатор двеју робиња, и не нађе их; и изашав из шатора Лијина уђе у шатор Рахиљин. ");
INSERT INTO srp1868_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","А Рахиља узе идоле и сакри их под самар камиле своје и седе озго; и Лаван пипаше по целом шатору, и не нађе. ");
INSERT INTO srp1868_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","А она рече оцу свом: Немој се срдити, господару, што ти не могу устати, јер ми је шта у жена бива. Траживши дакле не нађе идоле своје. ");
INSERT INTO srp1868_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","И Јаков се расрди, и стаде корити Лавана, и говорећи рече му: Шта сам учинио, шта сам скривио, те си ме тако жестоко терао? ");
INSERT INTO srp1868_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Пипао си сав пртљаг мој, па шта си нашао из своје куће? Дај овамо пред моју и своју браћу, нека расуде између нас двојице. ");
INSERT INTO srp1868_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ево двадесет година бих код тебе: овце твоје и козе твоје не јаловише се, а овнова из стада твог не једох. ");
INSERT INTO srp1868_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Шта би зверје заклало нисам ти доносио, сам сам подмиривао; од мене си искао што би ми било украдено дању или ноћу. ");
INSERT INTO srp1868_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Дању ме убијаше врућина а ноћу мраз; и сан ми не падаше на очи. ");
INSERT INTO srp1868_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Тако ми је био двадесет година у твојој кући; служио сам ти четрнаест година за два кћери твоје и шест година за стоку твоју, и плату си ми мењао десет пута. ");
INSERT INTO srp1868_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Да није Бог оца мог, Бог Аврамов, и страх Исаков био са мном, би ме зацело отпустио празна. Али је Бог видео невољу моју и труд руку мојих, па те укори ноћас. ");
INSERT INTO srp1868_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","А Лаван одговори Јакову и рече: Ове су кћери моје кћери, и ови су синови моји синови, и ова стока моја стока, и шта год видиш све је моје; па шта бих учинио данас кћерима својим или синовима њиховим које родише? ");
INSERT INTO srp1868_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Него хајде да ухватимо веру, ја и ти, да буде сведочанство између мене и тебе. ");
INSERT INTO srp1868_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","И Јаков узе камен и утврди га за спомен. ");
INSERT INTO srp1868_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","И рече Јаков браћи својој; накупите камења. И накупише камења и сложише на гомилу, и једоше на гомили. ");
INSERT INTO srp1868_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","И Лаван га назва Јегар-Сахадут, а Јаков га назва Галед. ");
INSERT INTO srp1868_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","И рече Лаван: Ова гомила нека буде сведок између мене и тебе данас. Зато се прозва Галед. ");
INSERT INTO srp1868_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","А прозва се и Миспа, јер рече Лаван: Нека Господ гледа између мене и тебе, кад не узможемо видети један другог. ");
INSERT INTO srp1868_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ако уцвелиш кћери моје и ако узмеш жене преко мојих кћери, неће човек бити између нас него гле Бог сведок између мене и тебе. ");
INSERT INTO srp1868_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","И још рече Лаван Јакову: Гледај ову гомилу и гледај овај споменик, који подигох између себе и тебе. ");
INSERT INTO srp1868_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Сведок је ова гомила и сведок је овај споменик, да ни ја нећу прећи преко ове гомиле к теби ни ти к мени да нећеш прећи преко ове гомиле и споменика овог на зло. ");
INSERT INTO srp1868_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Бог Аврамов и богови Нахорови, богови оца њиховог, нека суде међу нама. А Јаков се закле страхом оца свог Исака. ");
INSERT INTO srp1868_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","И Јаков принесе жртву на гори, и сазва браћу своју на вечеру; и једоше па ноћише на гори. ");
INSERT INTO srp1868_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","А ујутру рано уста Лаван, и изљуби своју унучад и кћери своје, и благослови их, па отиде, и врати се у своје место. ");
INSERT INTO srp1868_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","А Јаков отиде својим путем; и сретоше га анђели Божији; ");
INSERT INTO srp1868_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","а кад их угледа Јаков, рече: Ово је логор Божји. И прозва оно место Маханаим. ");
INSERT INTO srp1868_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","И Јаков посла пред собом гласнике к Исаву брату свом у земљу Сир, крајину едомску. ");
INSERT INTO srp1868_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","И заповеди им говорећи: Овако кажите господару мом Исаву: Слуга твој Јаков овако каже: Био сам дошљак код Лавана и бавио се до сад. ");
INSERT INTO srp1868_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","А имам волова и магараца, оваца и слуга, и слушкиња, и послах да јавим теби господару свом, еда бих нашао милост пред тобом. ");
INSERT INTO srp1868_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","И вратише се гласници к Јакову и рекоше му: Идосмо до брата твог Исава, и ето он ти иде на сусрет с четири стотине момака. ");
INSERT INTO srp1868_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","А Јаков се уплаши јако и забрину се; па раздели своје људе и овце и говеда и камиле у две чете. ");
INSERT INTO srp1868_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","И рече: Ако Исав удари на једну чету и разбије је, да ако друга утече. ");
INSERT INTO srp1868_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","И рече Јаков: Боже оца мог Аврама и Боже оца мог Исака, Господе, који си ми казао: Врати се у земљу своју и у род свој, и ја ћу ти бити добротвор! ");
INSERT INTO srp1868_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Нисам вредан толике милости и толике вере што си учинио слузи свом; јер само са штапом својим пређох преко Јордана, а сада сам господар од две чете. ");
INSERT INTO srp1868_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Избави ме из руке брата мог, из руке Исавове, јер се бојим да не дође и убије мене и матер с децом. ");
INSERT INTO srp1868_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","А Ти си казао: Заиста ја ћу ти бити добротвор, и учинићу семе твоје да буде као песка морског, који се не може избројати од множине. ");
INSERT INTO srp1868_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","И заноћи онде ону ноћ, и узе шта му дође до руке, да пошаље на дар Исаву брату свом, ");
INSERT INTO srp1868_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","двеста коза с двадесет јараца, двеста оваца с двадесет овнова, ");
INSERT INTO srp1868_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","тридесет камила дојилица с камиладима, четрдесет крава с десеторо телади, двадесет магарица с десеторо магаради. ");
INSERT INTO srp1868_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","И предаде их слугама својим, свако стадо напосе, и рече слугама: Идите напред преда мном, остављајући доста места између једног стада и другог. ");
INSERT INTO srp1868_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","И заповеди првом говорећи: Кад сретнеш Исава, брата мог, па те запита: Чији си? И куда идеш? И чије је то што гониш пред собом? ");
INSERT INTO srp1868_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","А ти реци: Слуге твог Јакова, а ово шаље на дар господару свом Исаву, а ето и сам иде за нама. ");
INSERT INTO srp1868_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Тако заповеди и другом и трећем и свима који иђаху за стадом, и рече: Тако кажите Исаву кад наиђете на њ. ");
INSERT INTO srp1868_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","И још кажите: Ето, Јаков слуга твој иде за нама. Јер говораше: Ублажићу га даром који иде преда мном, па ћу му онда видети лице, да ако ме лепо прими. ");
INSERT INTO srp1868_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Тако отиде дар напред, а он преноћи ону ноћ код чете своје. ");
INSERT INTO srp1868_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","И по ноћи уста, и узе обе жене и две робиње и једанаесторо деце своје; и преброди брод Јавок. ");
INSERT INTO srp1868_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","А пошто њих узе и преведе преко потока, претури и остало што имаше. ");
INSERT INTO srp1868_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","А кад оста Јаков сам, тада се један човек рваше с њим до зоре. ");
INSERT INTO srp1868_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","И кад виде да га не може свладати, удари га по зглавку у стегну, те се Јакову ишчаши стегно из зглавка, кад се човек рваше с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Па онда рече: Пусти ме, зора је. А Јаков му рече: Нећу те пустити докле ме не благословиш. ");
INSERT INTO srp1868_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","А човек му рече: Како ти је име. А он одговори: Јаков. ");
INSERT INTO srp1868_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Тада му рече: Одселе се нећеш звати Јаков, него Израиљ; јер си се јуначки борио и с Богом и с људима, и одолео си. ");
INSERT INTO srp1868_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","А Јаков запита и рече: Кажи ми како је теби име. А Он рече: Што питаш како ми је име? И благослови га онде. ");
INSERT INTO srp1868_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","И Јаков надеде име оном месту Фануил; јер, вели, Бога видех лицем к лицу, и душа се моја избави. ");
INSERT INTO srp1868_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","И сунце му се роди кад прође Фануил, и храмаше на стегно своје. ");
INSERT INTO srp1868_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Зато синови Израиљеви не једу крајеве од мишића на зглавку у стегну до данашњег дана, што се Јакову повредише крајеви од мишића на зглавку у стегну. ");
INSERT INTO srp1868_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","А Јаков подигавши очи своје погледа, а то Исав иде, и четири стотине људи с њим. И раздели децу уз Лију и уз Рахиљу и уз две робиње. ");
INSERT INTO srp1868_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","И намести напред робиње и њихову децу, па Лију и њену децу за њима, а најпосле Рахиљу и Јосифа. ");
INSERT INTO srp1868_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","А сам прође напред, и поклони се до земље седам пута докле дође до брата свог. ");
INSERT INTO srp1868_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","А Исав притрча преда њ и загрли га и паде му око врата и целива га, и обојица се заплакаше, ");
INSERT INTO srp1868_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","и Исав подигавши очи угледа жене и децу, па рече: Ко су ти оно? А Јаков рече: Деца, коју Бог милостиво дарова слузи твом. ");
INSERT INTO srp1868_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","И приступише робиње с децом својом, и поклонише се. ");
INSERT INTO srp1868_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Потом приступи и Лија и деца њена, и поклонише се; а најпосле приступи Јосиф и Рахиља, и поклонише се. ");
INSERT INTO srp1868_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","А Исав рече: Шта ће ти читава војска она коју сретох? А он рече: Да нађем милост пред господарем својим. ");
INSERT INTO srp1868_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","А Исав рече: Има, брате, у мене доста; нека теби шта је твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","А Јаков рече: Не; ако сам сада нашао милост пред тобом, прими дар из моје руке, јер видех лице твоје као да видех лице Божје, тако си ме лепо дочекао. ");
INSERT INTO srp1868_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Прими дар мој, који ти је доведен; јер ме је обилато обдарио Бог, и имам свега. И навали на њ, те прими. ");
INSERT INTO srp1868_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","После рече Исав: Хајде да идемо, ићи ћу и ја с тобом. ");
INSERT INTO srp1868_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","А Јаков му рече: Зна господар мој да су ова деца нејака, и имам оваца и крава дојилица, па ако их устерам један дан, погинуће ми све стадо. ");
INSERT INTO srp1868_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Него господар мој нека иде пред слугом својим, а ја ћу полако ићи, колико могу деца и стока, докле дођем ка господару свом у Сир. ");
INSERT INTO srp1868_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","А Исав рече: А оно да ти оставим неколико људи што су са мном. А он рече: На шта? Дај да нађем милост пред господарем својим. ");
INSERT INTO srp1868_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","И тако Исав врати се исти дан својим путем у Сир. ");
INSERT INTO srp1868_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","А Јаков отиде у Сокот, и онде начини себи кућу а стоци својој начини стаје; зато назва оно место Сокот. ");
INSERT INTO srp1868_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","После дође Јаков здраво у град Сихем у земљи хананској, вративши се из Падан-Арама, и намести се према граду. ");
INSERT INTO srp1868_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","И купи комад земље, где разапе шатор свој, од синова Емора оца Сихемовог за сто новаца. ");
INSERT INTO srp1868_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","И начини онде жртвеник, и назва га: Силни Бог Израиљев. ");
INSERT INTO srp1868_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","А Дина кћи Лијина, коју роди Јакову, изађе да гледа девојке у оном крају. ");
INSERT INTO srp1868_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","А угледа је Сихем, син Емора Ефејина, кнеза од оне земље, и узе је и леже с њом и осрамоти је. ");
INSERT INTO srp1868_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","И приону срце његово за Дину кћер Јаковљеву, и девојка му омиле, и он јој се умиљаваше. ");
INSERT INTO srp1868_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","И рече Сихем Емору оцу свом говорећи: Ожени ме овом девојком. ");
INSERT INTO srp1868_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","А Јаков чу да је осрамотио Дину кћер његову; а синови његови беху у пољу са стоком његовом, и Јаков оћуте докле они не дођу. ");
INSERT INTO srp1868_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","А Емор отац Сихемов изиђе к Јакову да се разговори с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","А кад дођоше синови Јаковљеви из поља и чуше шта је било, жао би људима врло и разгневише се веома, што учини срамоту Израиљу облежав кћер Јаковљеву, како не би ваљало чинити. ");
INSERT INTO srp1868_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Тада им рече Емор говорећи: Син мој Сихем срцем приону за вашу кћер; подајте му је за жену. ");
INSERT INTO srp1868_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","И опријатељите се с нама; кћери своје удајите за нас и кћерима нашим жените се. ");
INSERT INTO srp1868_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Па живите с нама, и земља ће вам бити отворена; настаните се и тргујте и држите баштине у њој. ");
INSERT INTO srp1868_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","И рече Сихем оцу девојчином и браћи јој: Да нађем милост пред вама, и даћу шта ми год кажете. ");
INSERT INTO srp1868_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Иштите ми колико год хоћете уздарја и дара, ја ћу дати шта год кажете; само ми дајте девојку за жену. ");
INSERT INTO srp1868_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","А синови Јаковљеви одговорише Сихему и Емору оцу његовом преварно, јер осрамоти Дину сестру њихову. ");
INSERT INTO srp1868_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","И рекоше им: Не можемо то учинити ни дати сестре своје за човека необрезаног, јер је то срамота нама. ");
INSERT INTO srp1868_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Него ћемо вам учинити по вољи, ако ћете се изједначити с нама и обрезати све мушкиње између себе. ");
INSERT INTO srp1868_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Онда ћемо удавати своје кћери за вас и женићемо се вашим кћерима, и постаћемо један народ. ");
INSERT INTO srp1868_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ако ли не пристанете да се обрежете, ми ћемо узети своју девојку и отићи ћемо. ");
INSERT INTO srp1868_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","И по вољи бише речи њихове Емору и Сихему сину Еморовом. ");
INSERT INTO srp1868_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","И момак не оклеваше учинити то; јер му кћи Јаковљева омиле веома; и он беше највише поштован између свих у кући оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","И отиде Емор и син му Сихем на врата града свог, и рекоше грађанима говорећи: ");
INSERT INTO srp1868_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ови људи хоће мирно да живе с нама, да се настане у овој земљи и да тргују по њој; а ево земља је широка и за њих; па ћемо се кћерима њиховим женити и своје ћемо кћери удавати за њих. ");
INSERT INTO srp1868_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Али ће тако пристати да живе с нама и да постанемо један народ, ако се све мушкиње међу нама обрежу, као што су они обрезани. ");
INSERT INTO srp1868_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Њихова стока и њихово благо и сва говеда њихова неће ли бити наша? Сложимо се само с њима, па ће остати код нас. ");
INSERT INTO srp1868_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","И који излажаху на врата града његовог, сви послушаше Емора и Сихема сина његовог; и обреза се све мушкиње, сви који излажаху на врата града његовог. ");
INSERT INTO srp1868_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","А трећи дан кад они беху у боловима, узеше два сина Јаковљева Симеун и Левије, браћа Динина, сваки свој мач и уђоше слободно у град и побише све мушкиње. ");
INSERT INTO srp1868_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Убише и Емора и сина му Сихема оштрим мачем, и узевши Дину из куће Сихемове отидоше. ");
INSERT INTO srp1868_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Тада дођоше синови Јаковљеви на побијене, и опленише град, јер у њему би осрамоћена сестра њихова. ");
INSERT INTO srp1868_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","И узеше овце њихове и говеда њихова и магарце њихове, шта год беше у граду и шта бод беше у пољу. ");
INSERT INTO srp1868_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","И све благо њихово, и сву децу и жене њихове похваташе и одведоше, и шта год беше у којој кући. ");
INSERT INTO srp1868_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","А Јаков рече Симеуну и Левију; сметосте ме, и омразисте ме народу ове земље, Хананејима и Ферезејима; у мене има мало људи, па ако се скупе на ме, хоће ме убити те ћу се истребити ја и дом мој. ");
INSERT INTO srp1868_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","А они рекоше: Зар са сестром нашом да раде као с курвом? ");
INSERT INTO srp1868_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","А Бог рече Јакову: Устани, иди горе у Ветиљ и онде стани; и начини онде жртвеник Богу, који ти се јавио кад си бежао од Исава брата свог. ");
INSERT INTO srp1868_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","И Јаков рече породици својој и свима који беху с њим: Баците туђе богове што су у вас, и очистите се и преобуците се; ");
INSERT INTO srp1868_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","па да се дигнемо и идемо горе у Ветиљ, да начиним онде жртвеник Богу, који ме чуо у дан невоље моје и био са мном на путу којим сам ишао. ");
INSERT INTO srp1868_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","И дадоше Јакову све богове туђе који беху у њиховим рукама, и обоце, које имаху у ушима; и Јаков их закопа под храстом код Сихема. ");
INSERT INTO srp1868_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Потом отидоше. А страх Божји дође на градове који беху око њих, те се не дигоше у потеру за синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","И Јаков и сва чељад што беше с њим дођоше у Луз у земљи хананској, а то је Ветиљ. ");
INSERT INTO srp1868_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","И онде начини жртвеник, и назва оно место: Бог ветиљски, јер му се онде јави Бог, кад је бежао од брата свог. ");
INSERT INTO srp1868_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Тада умре Девора дојкиња Ревечина, и погребоше је испод Ветиља под храстом, који назва Јаков Алон-Вакут. ");
INSERT INTO srp1868_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","И јави се Бог Јакову опет, пошто изиђе из Падан-Арама, и благослови га, ");
INSERT INTO srp1868_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","и рече му Бог: Име ти је Јаков; али се одселе нећеш звати Јаков, него ће ти име бити Израиљ. И надеде му име Израиљ. ");
INSERT INTO srp1868_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","И још му рече Бог: Ја сам Бог Свемогући; расти и множи се; народ и многи ће народи постати од тебе, и цареви ће изаћи из бедара твојих. ");
INSERT INTO srp1868_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","И даћу ти земљу коју сам дао Авраму и Исаку, и након тебе семену твом даћу земљу ову. ");
INSERT INTO srp1868_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Потом отиде од њега Бог с места где му говори. ");
INSERT INTO srp1868_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","А Јаков метну споменик на истом месту где му Бог говори, споменик од камена, и покропи га кропљењем, и прели га уљем. ");
INSERT INTO srp1868_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","И Јаков прозва место где му говори Бог Ветиљ. ");
INSERT INTO srp1868_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","И отидоше од Ветиља. А кад им оста још мало пута до Ефрате, породи се Рахиља, и беше јој тежак порођај. ");
INSERT INTO srp1868_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","И кад се веома мучаше, рече јој бабица: Не бој се, имаћеш још једног сина. ");
INSERT INTO srp1868_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","А кад се растављаше с душом те умираше, назва га Венонија; али му отац надеде име Венијамин. ");
INSERT INTO srp1868_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","И умре Рахиља, и погребоше је на путу који иде у Ефрату, а то је Витлејем. ");
INSERT INTO srp1868_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","И метну Јаков споменик на гроб њен. То је споменик на гробу Рахиљином до данашњег дана. ");
INSERT INTO srp1868_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Одатле отишавши Израиљ разапе шатор свој иза куле мигдол-едерске. ");
INSERT INTO srp1868_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","И кад Израиљ живеше у оној земљи, отиде Рувим и леже с Валом иночом оца свог. И то дочу Израиљ. А имаше Јаков дванаест синова. ");
INSERT INTO srp1868_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Синови Лијини беху: Рувим првенац Јаковљев, и Симеун и Левије и Јуда и Исахар и Завулон; ");
INSERT INTO srp1868_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","а синови Рахиљини: Јосиф и Венијамин; ");
INSERT INTO srp1868_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","а синови Вале робиње Рахиљине: Дан и Нефталим; ");
INSERT INTO srp1868_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","а синови Зелфе робиње Лијине: Гад и Асир. То су синови Јаковљеви, који му се родише у Падан-Араму. ");
INSERT INTO srp1868_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","И Јаков дође к Исаку оцу свом у Мамрију у Киријат-Арву, које је Хеврон, где Аврам и Исак беху дошљаци. ");
INSERT INTO srp1868_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","А Исаку беше сто и осамдесет година; ");
INSERT INTO srp1868_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","и онемоћав умре Исак, и би прибран к роду свом стар и сит живота; и погребоше га Исав и Јаков синови његови. ");
INSERT INTO srp1868_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","А ово је племе Исавово, а он је Едом. ");
INSERT INTO srp1868_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Исав се ожени између кћери хананејских Адом кћерју Елома Хетејина, и Оливемом кћерју Ане сина Севегона Евејина, ");
INSERT INTO srp1868_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","и Васематом кћерју Исмаиловом, сестром Навеотовом. ");
INSERT INTO srp1868_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","И роди Ада Исаву Елифаса, а Васемата роди Рагуила. ");
INSERT INTO srp1868_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","А Оливема роди Јеуса и Јеглома и Кореја. То су синови Исавови, који му се родише у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","И Исав узе жене своје и синове своје и кћери своје и све домашње своје, и стада своја и сву стоку своју и све благо своје што беше стекао у земљи хананској; па отиде у другу земљу далеко од Јакова брата свог. ");
INSERT INTO srp1868_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Јер им благо беше врло велико, те не могаху живети заједно; нити их земља где беху дошљаци могаше носити од множине стоке њихове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","И Исав живеше на планини Сиру Исав је Едом. ");
INSERT INTO srp1868_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","А ово је племе Исава оца Едомцима на планини Сиру. ");
INSERT INTO srp1868_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ово су имена синова Исавових: Елифас син Аде жене Исавове, и Ратуило син Васемате жене Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","А Елифасови синови беху: Теман, Омар, Софар, Готом и Кенез. ");
INSERT INTO srp1868_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","А Тамна беше иноча Елифасу сину Исавовом, и роди Елифасу Амалика. То су синови Аде жене Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","А ово су синови Рагуилови: Нахот, Заре, Соме и Мозе. То беху синови Васемате, жене Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","А ово су синови Оливеме кћери Ане сина Севегоновог, жене Исавове. Она роди Исаву Јеуса и Јеглома и Кореја. ");
INSERT INTO srp1868_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ово су старешине синова Исавових: синови Елифаса првенца Исавовог: старешина Теман, старешина Омар, старешина Софар, старешина Кенез, ");
INSERT INTO srp1868_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","старешина Кореј, старешина Готим, старешина Амалик. То су старешине од Елифаса у земљи едомској. То су синови Адини. ");
INSERT INTO srp1868_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","А синови Рагуила сина Исавовог: старешина Нахот, старешина Заре, старешина Соме, старешина Мозе. То су старешине од Рагуила у земљи едомској. То су синови Васемате жене Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","А синови Оливеме жене Исавове: старешина Јеус, старешина Јеглом, старешина Кореј: то су старешине од Оливеме кћери Анине, жене Исавове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","То су синови Исавови, и то су старешине њихове; а он је Едом. ");
INSERT INTO srp1868_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","А ово су синови Сира Хорејина, који живеху у оној земљи: Лотан и Совал и Севегон и Ана, ");
INSERT INTO srp1868_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","и Дисон и Асар и Рисон. То су старешине Хорејима, синови Сирови у земљи едомској. ");
INSERT INTO srp1868_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","А синови Лотанови беху Хорије и Емам, а сестра Лотанова беше Тамна. ");
INSERT INTO srp1868_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","А ово су синови Совалови: Голам и Манахат и Гевил и Софар и Омар. ");
INSERT INTO srp1868_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","А ово су синови Севегонови: Аије и Ана. А тај је Ана који пронађе топле изворе у пустињи пасући магарице Севегона оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","А ово су деца Анина: Дисон и Оливема кћи Анина. ");
INSERT INTO srp1868_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","А ово су синови Дисонови: Амада и Асван и Итран и Харан. ");
INSERT INTO srp1868_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","А ово су синови Асарови: Валам и Заван и Акан. ");
INSERT INTO srp1868_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","А ово су синови Рисонови: Уз и Аран. ");
INSERT INTO srp1868_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","И ово су старешине Хорејима: старешина Лотан, старешина Совал, старешина Севегон, старешина Ана, ");
INSERT INTO srp1868_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","старешина Дисон, старешина Асар, старешина Рисон. То су старешине Хорејима, како им старешоваху у земљи Сиру. ");
INSERT INTO srp1868_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","А ово су цареви који цароваше у земљи едомској пре него се зацари цар над синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Царова у едомској Валак син Веоров, а граду му беше име Денава. ");
INSERT INTO srp1868_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","А кад умре Валак, зацари се на његово место Јовав син Зарин од Восоре. ");
INSERT INTO srp1868_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","А кад умре Јовав, зацари се на његово место Асом од земље темановске. ");
INSERT INTO srp1868_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","А кад умре Асом, зацари се на његово место Адад син Варадов, који исече Мадијане у пољу моавском, а граду му беше име Гетен. ");
INSERT INTO srp1868_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","А кад умре Адад, зацари се на његово место Самада, из Масекаса. ");
INSERT INTO srp1868_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","А кад умре Самада, зацари се на његово место Саул из Ровота на реци. ");
INSERT INTO srp1868_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","А кад умре Саул, зацари се на његово место Валенон син Аховоров. ");
INSERT INTO srp1868_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","А кад умре Валенон син Аховоров, зацари се на његово место Адар, а град му се зваше Фогор, а жени му беше име Метевеила, која беше кћи Матраиде кћери Мезевове. ");
INSERT INTO srp1868_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","И ово су племена старешинама од Исава по породицама њиховим, по местима њиховим, по именима њиховим: старешина Тамна, старешина Гола, старешина Јетер, ");
INSERT INTO srp1868_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","старешина Оливема, старешина Ила, старешина Финон, ");
INSERT INTO srp1868_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","старешина Кенез, старешина Теман, старешина Мазар, ");
INSERT INTO srp1868_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","старешина Магедило, старешина Зафој: то су старешине едомске како наставаху у својој земљи. Овај Исав би отац Едомцима. ");
INSERT INTO srp1868_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","А Јаков живеше у земљи где му је отац био дошљак, у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ово су догађаји Јаковљеви. Јосиф кад беше момак од седамнаест година, пасаше стоку с браћом својом, коју родише Вала и Зелфа жене оца његовог; и доношаше Јосиф зле гласове о њима оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","А Израиљ љубљаше Јосифа највећма измећу свих синова својих, јер му се родио под старост; и начини му шарену хаљину. ");
INSERT INTO srp1868_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","А браћа видећи где га отац љуби највећма између све браће његове, стадоше мрзети на њ тако да му не могаху лепу реч проговорити. ");
INSERT INTO srp1868_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Уз то усни Јосиф сан и приповеди браћи својој, те они још већма омрзну на њ. ");
INSERT INTO srp1868_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Јер им рече: Да чујете сан што сам снио: ");
INSERT INTO srp1868_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Везасмо снопље у пољу, па мој сноп уста и исправи се, а ваши снопови иђаху унаоколо и клањаху се снопу мом. ");
INSERT INTO srp1868_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Тада му браћа рекоше: Да нећеш још бити цар над нама и заповедати нам? Стога још већма стадоше мрзети на њ ради снова његових и ради речи његових. ");
INSERT INTO srp1868_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","После опет усни други сан, и приповеди браћи својој говорећи: Усних опет сан, а то се сунце и месец и једанаест звезда клањаху мени. ");
INSERT INTO srp1868_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","А приповеди и оцу свом и браћи својој; али га отац прекори и рече му: Какав је то сан што си снио? Еда ли ћемо доћи ја и мати твоја и браћа твоја да се клањамо теби до земље? ");
INSERT INTO srp1868_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","И завиђаху му браћа; али отац његов чуваше ове речи. ");
INSERT INTO srp1868_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","А кад браћа његова отидоше да пасу стоку оца свог код Сихема, ");
INSERT INTO srp1868_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","рече Израиљ Јосифу: Не пасу ли браћа твоја стоку код Сихема? Хајде да те пошаљем к њима. А он рече: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","А он му рече: Иди, види како су браћа твоја и како је стока, па дођи да ми јавиш. И оправи га из долине хевронске, и он отиде пут Сихема. ");
INSERT INTO srp1868_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","И човек један нађе га а он лута по пољу; те га запита говорећи: Шта тражиш? ");
INSERT INTO srp1868_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","А он рече: Тражим браћу своју; кажи ми, молим те, где су са стоком? ");
INSERT INTO srp1868_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","А човек рече: Отишли су одавде, јер чух где рекоше: Хајдемо у Дотаим. И отиде Јосиф за браћом својом, и нађе их у Дотаиму. ");
INSERT INTO srp1868_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","А они га угледаше из далека; и док још не дође близу њих, стадоше се договарати да га убију, ");
INSERT INTO srp1868_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","и рекоше међу собом: Гле, ево оног што сне сања. ");
INSERT INTO srp1868_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Хајде сада да га убијемо и да га бацимо у коју од ових јама, па ћемо казати: Љута га је зверка изјела. Онда ћемо видети шта ће бити од његових снова. ");
INSERT INTO srp1868_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Али Рувим кад чу то, избави га из руку њихових рекавши: Немојте да га убијемо. ");
INSERT INTO srp1868_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","И још им рече Рувим: Немојте крв проливати; баците га у ову јаму у пустињи, а не дижите руке на њ. А он га хтеде избавити из руку њихових и одвести к оцу. ");
INSERT INTO srp1868_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","И кад Јосиф дође к браћи својој, свукоше с њега хаљину његову, хаљину шарену, коју имаше на себи. ");
INSERT INTO srp1868_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","И ухвативши га бацише га у јаму; а јама беше празна, не беше воде у њој. ");
INSERT INTO srp1868_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","После седоше да једу. И подигавши очи угледаше, а то гомила Исмаиљаца иђаше од Галада с камилама натовареним мирисавог корења и тамјана и смирне, те ношаху у Мисир. ");
INSERT INTO srp1868_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","И рече Јуда браћи својој: Каква ће бити корист што ћемо убити брата свог и затајити крв његову? ");
INSERT INTO srp1868_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Хајде да га продамо овим Исмаиљцима па да не дижемо руке своје на њ, јер нам је брат, наше је тело. И послушаше га браћа његова. ");
INSERT INTO srp1868_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Па кад трговци мадијански беху поред њих, они извукоше и извадише Јосифа из јаме, и продадоше Јосифа Исмаиљцима за двадесет сребрника; и они одведоше Јосифа у Мисир. ");
INSERT INTO srp1868_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","А кад се Рувим врати к јами, а то нема Јосифа у јами; тада раздре хаљине своје, ");
INSERT INTO srp1868_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","па се врати к браћи својој, и рече: Нема детета; а ја куда ћу? ");
INSERT INTO srp1868_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Тада узеше хаљину Јосифову, и заклавши јаре замочише хаљину у крв, ");
INSERT INTO srp1868_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","па онда послаше шарену хаљину оцу његовом поручивши: Нађосмо ову хаљину, види је ли хаљина сина твог или није. ");
INSERT INTO srp1868_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","А он је позна и рече: Сина је мог хаљина; љута га је зверка изјела; Јосиф је доиста раскинут. ");
INSERT INTO srp1868_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","И раздре Јаков хаљине своје, и веза кострет око себе, и тужаше за сином својим дуго времена. ");
INSERT INTO srp1868_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","И сви синови његови и све кћери његове устадоше око њега тешећи га, али се он не даде утешити, него говораше: С тугом ћу у гроб лећи за сином својим. Па и његов отац плакаше за њим. ");
INSERT INTO srp1868_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","А Мадијани продадоше га у Мисир Петефрију, дворанину Фараоновом, заповеднику стражарском. ");
INSERT INTO srp1868_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","А у то време догоди се, те Јуда отиде од браће своје и уврати се код неког Одоламејца, коме име беше Ирас. ");
INSERT INTO srp1868_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","И онде виде Јуда кћер неког Хананејца, коме име беше Сава, и узе је и леже с њом; ");
INSERT INTO srp1868_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","и она затрудне и роди сина, коме надеде име Ир. ");
INSERT INTO srp1868_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","И опет затрудневши роди сина, коме надеде име Авнан. ");
INSERT INTO srp1868_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","И опет роди сина, и надеде му име Силом; а Јуда беше у Хасви кад она тога роди. ");
INSERT INTO srp1868_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","И Јуда ожени првенца свог Ира девојком по имену Тамара. ");
INSERT INTO srp1868_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Али Ир првенац Јудин беше неваљао пред Господом, и уби га Господ. ");
INSERT INTO srp1868_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","А Јуда рече Авнану: Уђи к жени брата свог и ожени се њом на име братово, да подигнеш семе брату свом. ");
INSERT INTO srp1868_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","А Авнан, знајући да неће бити његов пород, кад леже са женом брата свог просипаше на земљу, да не роди деце брату свом. ");
INSERT INTO srp1868_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Али Господу не би мило што чињаше, те уби и њега. ");
INSERT INTO srp1868_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","И Јуда рече Тамари снаси својој: Остани удовицом у кући оца свог докле одрасте Силом син мој. Јер говораше: Да не умре и он као браћа му. И отиде Тамара, и живеше у кући оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","А кад прође много времена, умре кћи Савина, жена Јудина. И кад се Јуда утеши, пође у Тамну к људима што му стрижаху овце, сам с Ирасом пријатељем својим Одоламејцем. ");
INSERT INTO srp1868_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","И јавише Тамари говорећи: Ето свекар твој иде у Тамну да стриже овце своје. ");
INSERT INTO srp1868_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","А она скиде са себе удовичко рухо своје, и узе покривало и покри лице, и седе на раскршће на путу који иде у Тамну. Јер виде да је Силом одрастао, а њу још не удаше за њ. ");
INSERT INTO srp1868_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","А Јуда када виде, помисли да је курва, јер беше покрила лице своје. ");
INSERT INTO srp1868_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Па сврну с пута к њој и рече јој: Пусти да легнем с тобом. Јер није познао да му је снаха. А она рече: Шта ћеш ми дати да легнеш са мном? ");
INSERT INTO srp1868_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","А он рече: Послаћу ти јаре из стада. А она рече: Али да ми даш залог докле га не пошаљеш. ");
INSERT INTO srp1868_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","А он рече: Какав залог да ти дам? А она рече: Ето, прстен и рубац, и штап што ти је у руци. И он јој даде, те леже с њом, и она затрудне од њега. ");
INSERT INTO srp1868_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","После уставши Тамара отиде и скиде покривало са себе и обуче удовичко рухо. ");
INSERT INTO srp1868_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","А Јуда посла јаре по пријатељу свом Одоламејцу да му донесе натраг од жене залог. Али је он не нађе. ");
INSERT INTO srp1868_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Па питаше људе по оном месту где је она била говорећи: Где је она курва што је била на раскршћу на овом путу? А они рекоше: Није овде било курве. ");
INSERT INTO srp1868_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","И врати се к Јуди и рече: Не нађох је, него још рекоше мештани: Није овде било курве. ");
INSERT INTO srp1868_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","А Јуда рече: Нека јој, да се не срамотимо; ја сам слао јаре, али је ти не нађе. ");
INSERT INTO srp1868_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","А кад прође до три месеца дана, јавише Јуди говорећи: Тамара снаха твоја учини прељубу, и ево затрудне од прељубе. А Јуда рече: Изведите је да се спали. ");
INSERT INTO srp1868_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","А кад је поведоше, посла к свекру свом и поручи: С човеком чије је ово затруднела сам. И рече: Тражи чији је овај прстен и рубац и штап. ");
INSERT INTO srp1868_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","А Јуда позна и рече: Правија је од мене, јер је не дадох сину свом Силому. И више не леже с њом. ");
INSERT INTO srp1868_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","А кад дође време да роди, а то близанци у утроби њеној. ");
INSERT INTO srp1868_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","И кад се порађаше, једно дете помоли руку, а бабица узе и веза му црвен конац око руке говорећи: Овај је први. ");
INSERT INTO srp1868_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Али он увуче руку, и гле изађе брат његов, а она рече: Како продре? Продирање нека ти буде. И надеше му име Фарес. ");
INSERT INTO srp1868_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","А после изађе брат му, коме око руке беше црвени конац, и надеше му име Зара. ");
INSERT INTO srp1868_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","А Јосифа одведоше у Мисир; и Петефрије дворанин Фараонов, заповедник стражарски, човек Мисирац, купи га од Исмаиљаца, који га одведоше онамо. ");
INSERT INTO srp1868_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","И Господ беше с Јосифом, те би срећан, и живеше у кући господара свог Мисирца. ");
INSERT INTO srp1868_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","И господар његов виде да је Господ с њим и да све што ради Господ води у напредак у руци његовој. ");
INSERT INTO srp1868_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","И Јосиф стече милост у њега, и двораше га; а најпосле постави га над целим домом својим, и шта год имаше њему даде у руке. ");
INSERT INTO srp1868_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","А кад га постави над домом својим и над свим што имаше, од тада Господ благослови дом тога Мисирца ради Јосифа; и благослов Господњи беше на свему што имаше у кући и у пољу. ");
INSERT INTO srp1868_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","И остави у Јосифовим рукама све што имаше, и не разбираше низашта осим јела које јеђаше. А Јосиф беше лепог стаса и лепог лица. ");
INSERT INTO srp1868_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","И догоди се после, те се жена господара његовог загледа у Јосифа, и рече: Лези са мном. ");
INSERT INTO srp1868_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","А он не хте, него рече жени господара свог: Ето господар мој не разбира низашта шта је у кући, него шта год има даде мени у руке. ");
INSERT INTO srp1868_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ни сам није већи од мене у овој кући, и ништа не крије од мене осим тебе, јер си му жена; па како бих учинио тако грдно зло и Богу згрешио? ");
INSERT INTO srp1868_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","И она говораше такве речи Јосифу сваки дан, али је не послуша да легне с њом ни да се бави код ње. ");
INSERT INTO srp1868_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","А један дан кад дође Јосиф у кућу да ради свој посао, а не беше никога од домашњих у кући, ");
INSERT INTO srp1868_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","она га ухвати за хаљину говорећи: Лези са мном. Али он оставивши јој у рукама хаљину своју побеже и отиде. ");
INSERT INTO srp1868_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","А кад она виде где јој остави у рукама хаљину своју и побеже, ");
INSERT INTO srp1868_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","викну чељад своју, и рече им говорећи: Гледајте, довео нам је човека Јеврејина да нас срамоти; дође к мени да легне са мном, а ја повиках гласно; ");
INSERT INTO srp1868_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","а он кад чу где вичем, остави хаљину своју код мене и побеже и отиде. ");
INSERT INTO srp1868_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","И она остави хаљину његову код себе док му господар дође кући. ");
INSERT INTO srp1868_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","А тада му рече овако говорећи: Слуга Јеврејин, кога си нам довео, дође к мени да ме осрамоти; ");
INSERT INTO srp1868_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","а ја повиках гласно, те он остави хаљину своју код мене и побеже. ");
INSERT INTO srp1868_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","А кад господар његов чу речи жене своје где му рече: То ми је учинио слуга твој, разгневи се врло. ");
INSERT INTO srp1868_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","И господар Јосифов ухвати га, и баци га у тамницу, где лежаху сужњи царски: и би онде у тамници. ");
INSERT INTO srp1868_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Али Господ беше с Јосифом и рашири милост своју над њим и учини те омиле тамничару. ");
INSERT INTO srp1868_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","И повери тамничар Јосифу све сужње у тамници, и шта је год требало онде чинити он уређиваше. ");
INSERT INTO srp1868_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","И тамничар не надгледаше ништа што беше у Јосифовој руци, јер Господ беше с њим; и шта год чињаше, Господ вођаше у напредак. ");
INSERT INTO srp1868_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","После тога догоди се, те пехарник цара мисирског и хлебар скривише господару свом, цару мисирском. ");
INSERT INTO srp1868_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","И Фараон се разгневи на та два дворанина, на старешину над пехарницима и на старешину над хлебарима; ");
INSERT INTO srp1868_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","и баци их у тамницу у кући заповедника стражарског, где Јосиф беше сужањ. ");
INSERT INTO srp1868_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","А заповедник стражарски одреди им Јосифа да их служи; и беху дуго у тамници. ");
INSERT INTO srp1868_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","И уснише сан обојица у једну ноћ, сваки по значењу свог сна за себе, и пехарник и хлебар цара мисирског, који беху сужњи у тамници. ");
INSERT INTO srp1868_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","И сутрадан кад дође Јосиф к њима, погледа их, а они беху врло невесели. ");
INSERT INTO srp1868_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Па запита дворане Фараонове, који беху сужњи с њим у кући господара његовог, и рече: Што сте данас лица невеселог? ");
INSERT INTO srp1868_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","А они му рекоше: Сан уснисмо обојица, а нема ко да нам каже шта значе. А Јосиф им рече: Шта значе, није ли у Бога? Али приповедите ми. ");
INSERT INTO srp1868_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","И старешина над пехарницима приповеди сан свој Јосифу говорећи: Сних, а преда мном чокот; ");
INSERT INTO srp1868_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","и на чокоту беху три лозе, и напупи и процвате, и грожђе на њему узре; ");
INSERT INTO srp1868_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","а у руци ми беше чаша Фараонова, те побрах зрело грожђе и исцедих га у чашу Фараонову, и додадох чашу Фараону. ");
INSERT INTO srp1868_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","А Јосиф му рече: Ово значи: три су лозе три дана. ");
INSERT INTO srp1868_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Још три дана, и Фараон бројећи своје дворане узеће и тебе, и опет те поставити у пређашњу службу, и опет ћеш му додавати чашу као и пре док си му био пехарник. ");
INSERT INTO srp1868_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Али немој заборавити мене кад будеш у добру, учини милост и помени за ме Фараону, и изведи ме из ове куће. ");
INSERT INTO srp1868_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Јер су ме украли из земље јеврејске, а овде нисам ништа учинио да ме баце у ову јаму. ");
INSERT INTO srp1868_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","А кад виде старешина над хлебарима како лепо каза сан, рече Јосифу: и ја сних, а мени на глави три котарице беле; ");
INSERT INTO srp1868_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","и у најгорњој котарици беше свакојаких колача за Фараона, и птице јеђаху из котарице на мојој глави. ");
INSERT INTO srp1868_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","А Јосиф одговори и рече: Ово значи: три котарице три су дана. ");
INSERT INTO srp1868_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Још три дана, и Фараон бројећи дворане своје избациће те и обесиће те на вешала, и птице ће јести с тебе месо. ");
INSERT INTO srp1868_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","И кад дође трећи дан, то беше дан у који се родио Фараон, и учини Фараон гозбу свим слугама својим, и наиђе међу слугама својим на старешину над пехарницима и на старешину над хлебарима; ");
INSERT INTO srp1868_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","и поврати старешину над пехарницима у службу да додаје чашу Фараону; ");
INSERT INTO srp1868_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","а старешину над хлебарима обеси, као што каза Јосиф. ");
INSERT INTO srp1868_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","И старешина над пехарницима не опомену се Јосифа, него га заборави. ");
INSERT INTO srp1868_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","А после две године дана усни Фараон, а он стоји на једној реци. ");
INSERT INTO srp1868_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","И гле, из реке изађе седам крава лепих и дебелих, и стадоше пасти по обали. ");
INSERT INTO srp1868_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","И гле, иза њих изађе из реке седам других крава, ружних и мршавих, и стадоше поред оних крава на обали. ");
INSERT INTO srp1868_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","И ове краве ружне и мршаве поједоше оних седам крава лепих и дебелих. У том се пробуди Фараон. ");
INSERT INTO srp1868_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Па опет заспав усни другом, а то седам класова израсте из једног стабла једрих и лепих; ");
INSERT INTO srp1868_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","а иза њих исклија седам класова малих и штурих; ");
INSERT INTO srp1868_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","па ови класови мали поједоше оних седам великих и једрих. У том се пробуди Фараон и виде да је сан. ");
INSERT INTO srp1868_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","И кад би ујутру, он се забрину у духу, и пославши сазва све гатаре мисирске и све мудраце, и приповеди им шта је снио; али нико не може казати Фараону шта значи. ");
INSERT INTO srp1868_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Тада проговори старешина над пехарницима Фараону и рече: Данас се опоменух греха свог. ");
INSERT INTO srp1868_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Кад се Фараон расрди на слуге своје и баци у тамницу у кући заповедника стражарског мене и старешину над хлебарима, ");
INSERT INTO srp1868_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","уснисмо једну ноћ ја и он, сваки за себе по значењу сна свог уснисмо. ");
INSERT INTO srp1868_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","А онде беше с нама момче Јеврејче, слуга заповедника стражарског, и ми му приповедисмо сне, а он нам каза шта чији сан значи. ");
INSERT INTO srp1868_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","И зби се како нам каза: мене поврати Фараон у службу, а оног обеси. ");
INSERT INTO srp1868_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Тада Фараон посла по Јосифа, и брже га изведоше из тамнице, а он се обрија и преобуче се, те изађе пред Фараона. ");
INSERT INTO srp1868_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","А Фараон рече Јосифу: Усних сан, па ми нико не уме да каже шта значи; а за тебе чујем да умеш казивати сне. ");
INSERT INTO srp1868_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","А Јосиф одговори Фараону и рече: То није у мојој власти, Бог ће јавити добро Фараону. ");
INSERT INTO srp1868_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","И рече Фараон Јосифу: Усних, а ја стојим крај реке на обали. ");
INSERT INTO srp1868_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","И гле, из реке изађе седам крава дебелих и лепих, те стадоше пасти по обали. ");
INSERT INTO srp1868_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","И гле, иза њих изађе седам других крава рђавих, и врло ружних и мршавих, каквих нисам видео у целој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","И ове краве мршаве и ружне поједоше оних седам дебелих, ");
INSERT INTO srp1868_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","и кад им бише у трбуху, не познаваше се да су им у трбуху, него опет беху онако ружне као пре. У том се пробудих. ");
INSERT INTO srp1868_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Па опет усних, а то седам класова израсте из једног стабла једрих и лепих; ");
INSERT INTO srp1868_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","а иза њих исклија седам малих, танких и штурих. ");
INSERT INTO srp1868_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","И ови танки класови прождреше оних седам лепих. И ово приповедих гатарима, али ми ни један не зна казати шта значи. ");
INSERT INTO srp1868_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","А Јосиф рече Фараону: Оба су сна Фараонова једнака; Бог јавља Фараону шта је наумио. ");
INSERT INTO srp1868_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Седам лепих крава јесу седам година, и седам лепих класова јесу седам година; оба су сна једнака. ");
INSERT INTO srp1868_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","А седам крава мршавих и ружних, што изађоше иза оних, јесу седам година; и седам класова ситних и штурих биће седам година гладних. ");
INSERT INTO srp1868_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","То је што рекох Фараону: Бог каже Фараону шта је наумио. ");
INSERT INTO srp1868_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ево доћи ће седам година врло родних свој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","А иза њих настаће седам гладних година, где ће се заборавити све обиље у земљи мисирској, јер ће глад сатрти земљу, ");
INSERT INTO srp1868_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","те се неће знати то обиље у земљи од глади потоње, јер ће бити врло велика. ");
INSERT INTO srp1868_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","А што је два пута узастопце Фараон снио, то је зато што је зацело Бог тако наумио, и на скоро ће то учинити Бог. ");
INSERT INTO srp1868_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Него сада нека потражи Фараон човека мудрог и разумног, па нека га постави над земљом мисирском. ");
INSERT INTO srp1868_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","И нека гледа Фараон да постави старешине по земљи, и покупи петину по земљи мисирској за седам родних година; ");
INSERT INTO srp1868_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","нека скупљају од сваког жита за родних година које иду, и нека снесу под руку Фараонову сваког жита у све градове, и нека чувају, ");
INSERT INTO srp1868_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","да се нађе хране земљи за седам година гладних, кад настану, да не пропадне земља од глади. ");
INSERT INTO srp1868_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","И ово се учини добро Фараону и свим слугама његовим. ");
INSERT INTO srp1868_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","И рече Фараон слугама својим: Можемо ли наћи човека какав је овај, у коме би дух био Божји? ");
INSERT INTO srp1868_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Па рече Фараон Јосифу: Кад је теби јавио Бог све ово, нема никога тако мудрог и разумног као што си ти. ");
INSERT INTO srp1868_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ти ћеш бити над домом мојим, и сав ће ти народ мој уста љубити; само ћу овим престолом бити већи од тебе. ");
INSERT INTO srp1868_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","И још рече Фараон Јосифу: Ево, постављам те над свом земљом мисирском. ");
INSERT INTO srp1868_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","И скиде Фараон прстен с руке своје и метну га Јосифу на руку, и обуче га у хаљине од танког платна, и обеси му златну верижицу о врату, ");
INSERT INTO srp1868_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","и посади га на кола која беху друга за његовим, и заповеди да пред њим вичу: Клањајте се! И да га је поставио над свом земљом мисирском. ");
INSERT INTO srp1868_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","И још рече Фараон Јосифу: Ја сам Фараон, али без тебе неће нико маћи руке своје ни ноге своје у свој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","И даде Фараон Јосифу име Псонтомфаних, и ожени га Асенетом кћерју Потифере свештеника онског. И пође Јосиф по земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","А беше Јосифу тридесет година кад изађе пред Фараона цара мисирског. И отишавши од Фараона обиђе сву земљу мисирску. ");
INSERT INTO srp1868_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","И за седам родних година роди земља свашта изобила. ");
INSERT INTO srp1868_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","И стаде Јосиф купити за тих седам година сваког жита што беше по земљи мисирској, и сносити жито у градове; у сваки град сношаше жито с њива које беху око њега. ");
INSERT INTO srp1868_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Тако накупи Јосиф жита врло много колико је песка морског, тако да га преста мерити, јер му не беше броја. ");
INSERT INTO srp1868_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","И докле још не наста гладна година, родише се Јосифу два сина, које му роди Асенета кћи Потифере свештеника онског. ");
INSERT INTO srp1868_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","И првенцу надеде Јосиф име Манасија, говорећи: Јер ми Бог даде да заборавим сву муку своју и сав дом оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","А другом надеде име Јефрем, говорећи: Јер ми Бог даде да растем у земљи невоље своје. ");
INSERT INTO srp1868_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Али прође седам година родних у земљи мисирској; ");
INSERT INTO srp1868_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","и наста седам година гладних, као што је Јосиф напред казао. И беше глад по свим земљама, а по свој земљи мисирској беше хлеба. ");
INSERT INTO srp1868_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Али најпосле наста глад и по свој земљи мисирској, и народ повика к Фараону за хлеб; а Фараон рече свима Мисирцима: Идите к Јосифу, па шта вам он каже оно чините. ");
INSERT INTO srp1868_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","И кад глад беше по свој земљи, отвори Јосиф све житнице, и продаваше Мисирцима. И глад поста врло велика у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","И из свих земаља долажаху у Мисир к Јосифу да купују; јер поста глад у свакој земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","А Јаков видећи да има жита у Мисиру, рече синовима својим: Шта гледате један на другог? ");
INSERT INTO srp1868_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","И рече: Ето чујем да у Мисиру има жита; идите онамо те нам купите отуда, да останемо живи и не помремо. ");
INSERT INTO srp1868_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","И десеторица браће Јосифове отидоше да купе жита у Мисиру. ");
INSERT INTO srp1868_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","А Венијамина брата Јосифовог не пусти отац с браћом говорећи: Да га не би задесило како зло. ");
INSERT INTO srp1868_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","И дођоше синови Израиљеви да купе жита с осталима који долажаху; јер беше глад у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","А Јосиф управљаше земљом, и продаваше жито свему народу по земљи. И браћа Јосифова дошавши поклонише му се лицем до земље. ");
INSERT INTO srp1868_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","А Јосиф угледавши браћу позна их; али се учини да их не познаје, и оштро им проговори и рече: Одакле сте дошли? А они рекоше: Из земље хананске, да купимо хране. ");
INSERT INTO srp1868_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Јосиф дакле позна браћу своју; али они њега не познаше. ");
INSERT INTO srp1868_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","И опомену се Јосиф снова које је снио за њих; и рече им: Ви сте уходе; дошли сте да видите где је земља слаба. ");
INSERT INTO srp1868_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","А они му рекоше: Нисмо, господару; него слуге твоје дођоше да купе хране. ");
INSERT INTO srp1868_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Сви смо синови једног човека, поштени људи, никада нису слуге твоје биле уходе. ");
INSERT INTO srp1868_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","А он им рече: Није истина, него сте дошли да видите где је земља слаба. ");
INSERT INTO srp1868_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","А они рекоше: Нас је било дванаест браће, слуга твојих, синова једног човека у земљи хананској; и ено, најмлађи је данас код оца нашег, а једног нема више. ");
INSERT INTO srp1868_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","А Јосиф им рече: Кажем ја да сте ви уходе. ");
INSERT INTO srp1868_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Него хоћу да се уверим овако: тако жив био Фараон, нећете изаћи одавде докле не дође овамо најмлађи брат ваш. ");
INSERT INTO srp1868_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Пошљите једног између себе нека доведе брата вашег, а ви ћете остати овде у тамници, па ћу видети је ли истина шта говорите; иначе сте уходе, тако жив био Фараон. ");
INSERT INTO srp1868_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","И затвори их у тамницу на три дана. ");
INSERT INTO srp1868_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","А трећи дан рече им Јосиф: Ако сте ради животу, ово учините, јер се ја Бога бојим: ");
INSERT INTO srp1868_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ако сте поштени људи, један брат између вас нека остане у тамници, а ви идите и однесите жита колико треба породицама вашим. ");
INSERT INTO srp1868_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Па онда доведите к мени најмлађег брата свог да се посведоче речи ваше и да не изгинете. И они учинише тако. ");
INSERT INTO srp1868_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","И рекоше један другом: Доиста се огрешисмо о брата свог, јер видесмо муку душе његове кад нам се мољаше, па га се оглушисмо; зато дође на нас ова мука. ");
INSERT INTO srp1868_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","А Рувим одговори им говорећи: Нисам ли вам говорио: Немојте се грешити о дете? Али ме не послушасте; и зато се ево тражи од нас крв његова. ");
INSERT INTO srp1868_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","А они не знаху да их Јосиф разуме, јер се с њим разговараху преко тумача. ");
INSERT INTO srp1868_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","А Јосиф окрете се од њих, и заплака се. Потом се опет окрете к њима, и проговори с њима, и узевши између њих Симеуна веза га пред њима. ");
INSERT INTO srp1868_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","И заповеди Јосиф да им наспу вреће жита, па и новце шта је који дао да метну свакоме у врећу, и да им даду брашњенице на пут. И тако би учињено. ");
INSERT INTO srp1868_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","И натоваривши жито своје на магарце своје отидоше. ");
INSERT INTO srp1868_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","А један од њих отворив своју врећу да нахрани магарца свог у једној гостионици, виде новце своје озго у врећи. ");
INSERT INTO srp1868_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","И рече браћи својој: Ја добих натраг новце своје, ево их у мојој врећи. И задрхта срце у њима и уплашише се говорећи један другом: Шта нам то учини Бог? ");
INSERT INTO srp1868_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","И дошавши к Јакову оцу свом у земљу хананску, приповедише му све што им се догоди, говорећи: ");
INSERT INTO srp1868_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Оштро говораше с нама човек, који заповеда у оној земљи, и дочека нас као уходе. ");
INSERT INTO srp1868_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","А кад му рекосмо: Ми смо поштени људи, никад нисмо били уходе; ");
INSERT INTO srp1868_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","било нас је дванаест браће, синова оца нашег; једног већ нема, а најмлађи је данас код оца нашег у земљи хананској; ");
INSERT INTO srp1868_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","рече нам човек, који заповеда у оној земљи: Овако ћу дознати јесте ли поштени људи: брата једног између себе оставите код мене, а шта вам треба за породице ваше глади ради, узмите и идите. ");
INSERT INTO srp1868_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","После доведите к мени брата свог најмлађег, да се уверим да нисте уходе него поштени људи; брата ћу вам вратити, и моћи ћете трговати по овој земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","А кад изручиваху вреће своје, гле, свакоме у врећи беху у завежљају новци његови; и видевши завежљаје новаца својих уплашише се и они и отац им. ");
INSERT INTO srp1868_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","И рече им Јаков отац њихов: Потрсте ми децу; Јосифа нема, Симеуна нема, па хоћете и Венијамина да узмете; све се скупило на ме. ");
INSERT INTO srp1868_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","А Рувим проговори и рече оцу свом: Два сина моја убиј, ако ти га не доведем натраг; дај га у моје руке, и ја ћу ти га опет довести. ");
INSERT INTO srp1868_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","А он рече: Неће ићи син мој с вама, јер је брат његов умро и он оста сам, па ако би га задесило како зло на путу на који ћете ићи, свалили би сте ме стара с тугом у гроб. ");
INSERT INTO srp1868_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Али глад беше врло велика у оној земљи. ");
INSERT INTO srp1868_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Па кад поједоше жито које беху донели из Мисира, рече им отац: Идите опет, и купите нам мало хране. ");
INSERT INTO srp1868_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","А Јуда му проговори и рече: Тврдо нам се зарекао онај човек говорећи: Нећете видети лице моје, ако не буде с вама брат ваш. ");
INSERT INTO srp1868_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ако ћеш пустити с нама брата нашег, ићи ћемо и купићемо ти хране. ");
INSERT INTO srp1868_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ако ли нећеш пустити, нећемо ићи, јер нам је рекао онај човек: Нећете видети лице моје, ако не буде с вама брат ваш. ");
INSERT INTO srp1868_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","А Израиљ рече: Што ми то зло учинисте и казасте човеку да имате још једног брата? ");
INSERT INTO srp1868_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","А они рекоше: Човек је потанко распитивао за нас и за род наш говорећи: Је ли вам јоште жив отац? Имате ли још браће? А ми му одговорисмо како нас питаше. Јесмо ли могли како знати да ће казати: Доведите брата свог? ");
INSERT INTO srp1868_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","И рече Јуда Израиљу оцу свом: Пусти дете са мном, па ћемо се подигнути и отићи, да останемо живи и не помремо и ми и ти и наша деца. ");
INSERT INTO srp1868_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ја ти се јамчим за њ, из моје га руке ишти; ако ти га не доведем натраг и преда те не ставим, да сам ти крив до века. ");
INSERT INTO srp1868_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Да нисмо толико оклевали, до сада бисмо се два пута вратили. ");
INSERT INTO srp1868_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Онда рече Израиљ отац њихов: Кад је тако, учините ово: узмите шта најлепше има у овој земљи у своје вреће, и понесите човеку оном дар: мало тамјана и мало меда, мирисавог корења и смирне, урме и бадема. ");
INSERT INTO srp1868_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","А новаца понесите двојином, и узмите новце што беху озго у врећама вашим и однесите натраг, може бити да је погрешка. ");
INSERT INTO srp1868_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","И узмите брата свог, па устаните и идите опет к оном човеку. ");
INSERT INTO srp1868_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","А Бог Свемогући да вам да да нађете милост у оног човека, да вам пусти брата вашег другог и Венијамина; ако ли останем без деце, нек останем без деце. ");
INSERT INTO srp1868_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Тада узевши даре и новаца двојином, узевши и Венијамина, подигоше се и отидоше у Мисир, и изађоше пред Јосифа. ");
INSERT INTO srp1868_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","А Јосиф кад виде с њима Венијамина, рече човеку који управљаше кућом његовом: Одведи ове људе у кућу, па накољи меса и зготови, јер ће у подне са мном јести ови људи. ");
INSERT INTO srp1868_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","И учини човек како Јосиф рече, и уведе људе у кућу Јосифову. ");
INSERT INTO srp1868_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","А они се бојаху кад их човек вођаше у кућу Јосифову, и рекоше: За новце који пре беху метнути у вреће наше води нас, докле смисли како ће нас окривити, да нас зароби и узме наше магарце. ");
INSERT INTO srp1868_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Па приступивши к човеку који управљаше кућом Јосифовом, проговорише му на вратима кућним, ");
INSERT INTO srp1868_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","и рекоше: Чуј, господару; дошли смо били и пре, и куписмо хране; ");
INSERT INTO srp1868_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","па кад дођосмо у једну гостионицу и отворисмо вреће, а то новци сваког нас беху озго у врећи његовој, новци наши на меру; и ево смо их донели натраг; ");
INSERT INTO srp1868_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","а друге смо новце донели да купимо хране; не знамо ко нам метну новце наше у вреће. ");
INSERT INTO srp1868_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","А он им рече: Будите мирни, не бојте се; Бог ваш и Бог оца вашег метнуо је благо у вреће ваше; новци су ваши били у мене. И изведе им Симеуна. ");
INSERT INTO srp1868_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","И уведе их човек у кућу Јосифову, и донесе им воде те опраше ноге, и магарцима њиховим положи. ");
INSERT INTO srp1868_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","И приправише дар чекајући докле дође Јосиф у подне, јер чуше да ће они онде јести. ");
INSERT INTO srp1868_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","И кад Јосиф дође кући, изнесоше му дар који имаху код себе, и поклонише му се до земље. ");
INSERT INTO srp1868_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","А он их запита како су, и рече: Како је отац ваш стари, за кога ми говористе? Је ли јоште жив? ");
INSERT INTO srp1868_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","А они рекоше: Добро је слуга твој, отац наш; још је жив. И поклонише му се. ");
INSERT INTO srp1868_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","А он погледавши виде Венијамина брата свог, сина матере своје, и рече: Је ли вам то најмлађи брат ваш за ког ми говористе? И рече: Бог да ти буде милостив, синко! ");
INSERT INTO srp1868_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","А Јосифу гораше срце од љубави према брату свом, те брже потражи где ће плакати, и ушавши у једну собу плака онде. ");
INSERT INTO srp1868_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","После умив се изађе, и устежући се рече: Дајте јело. ");
INSERT INTO srp1868_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","И донесоше њему најпосле и Мисирцима који обедоваху у њега, јер не могаху Мисирци јести с Јеврејима, јер је то нечисто Мисирцима. ");
INSERT INTO srp1868_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","А сеђаху пред њим старији по старештву свом а млађи по младости својој. И згледаху се од чуда. ");
INSERT INTO srp1868_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","И узимајући јела испред себе слаше њима, и Венијамину допаде пет пута више него другима. И пише и напише се с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","И заповеди Јосиф човеку што управљаше кућом његовом говорећи: Наспи овим људима у вреће жита колико могу понети, и свакоме у врећу метни озго новце његове. ");
INSERT INTO srp1868_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","И чашу моју, чашу сребрну, метни најмлађем у врећу одозго и новце за његово жито. И учини како му Јосиф рече. ");
INSERT INTO srp1868_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","А ујутру кад свану, отпустише људе с магарцима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","А кад изађоше из места и још не беху далеко, рече Јосиф човеку што управљаше кућом његовом: Устани, иди брже за оним људима, и кад их стигнеш реци им: Зашто враћате зло за добро? ");
INSERT INTO srp1868_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Није ли то чаша из које пије мој господар? И неће ли по њој зацело познати какви сте? Зло сте радили што сте то учинили. ");
INSERT INTO srp1868_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","И он их стиже, и рече им тако. ");
INSERT INTO srp1868_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","А они му рекоше: Зашто говориш, господару, такве речи? Сачувај Боже да слуге твоје учине такво шта! ");
INSERT INTO srp1868_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ено смо ти донели натраг из земље хананске новце које нађосмо озго у врећама својим, па како бисмо украли из куће господара твог сребро или злато? ");
INSERT INTO srp1868_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","У ког се између слуга твојих нађе, онај нека погине, и сврх тога ми ћемо бити робови господару мом. ");
INSERT INTO srp1868_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","А он рече: Нека буде како рекосте; али у кога се нађе, онај да ми буде роб, а ви остали нећете бити криви. ");
INSERT INTO srp1868_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","И брже поскидаше сви на земљу вреће своје, и разрешише сваки своју врећу. ");
INSERT INTO srp1868_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","А он стаде тражити почевши од најстаријег, и кад дође на најмлађег, нађе се чаша у врећи Венијаминовој. ");
INSERT INTO srp1868_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Тада раздреше хаљине своје, и натоваривши сваки свој товар на свог магарца вратише се у град. ");
INSERT INTO srp1868_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","И дође Јуда с браћом својом Јосифу у кућу, док он још беше код куће, и падоше пред њим на земљу. ");
INSERT INTO srp1868_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","А Јосиф им рече: Шта сте то учинили? Зар нисте знали да човек као што сам ја може зацело дознати? ");
INSERT INTO srp1868_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Тада рече Јуда: Шта да ти кажемо, господару? Шта да говоримо? Како ли да се правдамо? Бог је открио злочинство твојих слуга. Ево, ми смо сви робови твоји, господару, и ми и овај у кога се нашла чаша. ");
INSERT INTO srp1868_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","А Јосиф рече: Боже сачувај! Нећу ја то; у кога се нашла чаша он нека ми буде роб, а ви идите с миром оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Али Јуда приступив к њему рече: Чуј ме, господару; допусти да проговори слуга твој господару свом, и нека се гнев твој не распали на слугу твог, јер си ти као сам Фараон. ");
INSERT INTO srp1868_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Господар мој запита слуге своје говорећи: Имате ли оца или брата? ");
INSERT INTO srp1868_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","А ми рекосмо господару свом: Имамо старог оца и брата најмлађег, који му се роди у старости; а његов је брат умро, и он оста сам од матере своје, и отац га пази. ");
INSERT INTO srp1868_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","А ти рече слугама својим: Доведите ми га да видим својим очима. ");
INSERT INTO srp1868_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","И рекосмо господару свом: Неће моћи дете оставити оца свог; да остави оца свог, одмах ће отац умрети. ");
INSERT INTO srp1868_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","А ти рече слугама својим: Ако не дође брат ваш најмлађи, нећете видети лице моје. ");
INSERT INTO srp1868_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","А кад се вратисмо к слузи твом а оцу мом, казасмо му речи господара мог. ");
INSERT INTO srp1868_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","После рече нам отац: Идите опет, купите нам хране. ");
INSERT INTO srp1868_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","А ми рекосмо: Не можемо ићи, осим ако буде брат наш најмлађи с нама, онда ћемо ићи, јер не можемо видети лица оног човека, ако не буде с нама брат наш најмлађи. ");
INSERT INTO srp1868_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","А слуга твој, отац мој, рече нам: Знате да ми је жена родила два сина. ");
INSERT INTO srp1868_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","И један од њих отиде од мене, и рекох: Зацело га је раскинула зверка; и до сада га не видех. ");
INSERT INTO srp1868_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ако и овог одведете од мене и задеси га како зло, свалићете ме старог у гроб с тугом. ");
INSERT INTO srp1868_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Па сада да отидем к слузи твом, оцу свом, а ово дете да не буде с нама, како је душа оног везана за душу овог, ");
INSERT INTO srp1868_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","умреће кад види да нема детета, те ће слуге твоје свалити старог слугу твог, а оца свог, с тугом у гроб. ");
INSERT INTO srp1868_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","А твој се слуга подјемчио за дете оцу свом рекавши: Ако ти га не доведем натраг, да сам крив оцу свом до века. ");
INSERT INTO srp1868_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Зато нека слуга твој остане место детета, да буде роб господару мом, а дете нека иде с браћом својом. ");
INSERT INTO srp1868_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Јер како бих се вратио к оцу свом без детета, да гледам јаде који би ми оца задесили? ");
INSERT INTO srp1868_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Тада Јосиф не могући се уздржати пред осталима који стајаху око њега, повика: Изађите сви напоље. Тако не оста нико код њега кад се Јосиф показа браћи својој. ");
INSERT INTO srp1868_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Па бризну плакати тако да чуше Мисирци, чу и дом Фараонов. ");
INSERT INTO srp1868_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","И рече Јосиф браћи својој: Ја сам Јосиф; је ли ми отац још у животу? Али му браћа не могаху одговорити, јер се препадоше од њега. ");
INSERT INTO srp1868_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","А Јосиф рече браћи својој: Приступите ближе к мени. И приступише; а он рече ја сам Јосиф брат ваш, ког продадосте у Мисир. ");
INSERT INTO srp1868_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","А сада немојте жалити нити се кајати што ме продадосте овамо, јер Бог мене посла пред вама ради живота вашег. ");
INSERT INTO srp1868_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Јер је већ две године дана глад у земљи, а биће још пет година, где неће бити ни орања ни жетве. ");
INSERT INTO srp1868_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","А Бог ме посла пред вама, да вас сачува на земљи и да вам избави живот избављењем превеликим. ");
INSERT INTO srp1868_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","И тако нисте ме ви оправили овамо него сам Бог, који ме постави оцем Фараону и господарем од свега дома његовог и старешином над свом земљом мисирском. ");
INSERT INTO srp1868_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Вратите се брже к оцу мом и кажите му: Овако вели син твој Јосиф: Бог ме је поставио господарем свему Мисиру, ходи к мени, немој оклевати. ");
INSERT INTO srp1868_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Седећеш у земљи гесемској и бићеш близу мене, ти и синови твоји и синови синова твојих, и овце твоје и говеда твоја и шта је год твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","И ја ћу те хранити онде, јер ће још пет година бити глад, да не погинеш од глади ти и дом твој и шта је год твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","А ето видите очима својим, и брат мој Венијамин својим очима, да вам ја из уста говорим. ");
INSERT INTO srp1868_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Кажите оцу мом сву славу моју у Мисиру и шта сте год видели; похитајте и доведите овамо оца мог. ");
INSERT INTO srp1868_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Тада паде око врата Венијамину брату свом и плака. И Венијамин плака о врату његовом. ");
INSERT INTO srp1868_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","И изљуби сву браћу своју и исплака се над њима. Потом се браћа његова разговараху с њим. ");
INSERT INTO srp1868_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","И чу се глас у кући Фараоновој, и рекоше: Дођоше браћа Јосифу. И мило би Фараону и слугама његовим; ");
INSERT INTO srp1868_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","и рече Фараон Јосифу: Кажи браћи својој: Овако учините: натоварите магарце своје, па идите и вратите се у земљу хананску, ");
INSERT INTO srp1868_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","па узмите оца свог и чељад своју, и дођите к мени, и даћу вам најбоље што има у земљи мисирској, и јешћете најбоље обиље ове земље. ");
INSERT INTO srp1868_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","А ти им заповеди: Овако учините: узмите са собом из земље мисирске кола за децу своју и за жене своје, и поведите оца свог и дођите овамо; ");
INSERT INTO srp1868_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","а на покућство своје не гледајте, јер шта има најбоље у свој земљи мисирској ваше је. ");
INSERT INTO srp1868_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","И синови Израиљеви учинише тако; и Јосиф им даде кола по заповести Фараоновој; даде им и брашњенице на пут. ");
INSERT INTO srp1868_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","И свакоме даде по две хаљине, а Венијамину даде триста сребрника и петоре хаљине. ");
INSERT INTO srp1868_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","А оцу свом посла још десет магараца натоварених најлепших ствари што има у Мисиру, и десет магарица натоварених жита и хлеба и јестива оцу на пут. ");
INSERT INTO srp1868_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Тако оправи браћу своју, и пођоше; и рече им: Немојте се корити путем. ");
INSERT INTO srp1868_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Тако се вратише из Мисира, и дођоше у земљу хананску к Јакову оцу свом. ");
INSERT INTO srp1868_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","И јавише му и рекоше: Још је жив Јосиф, и заповеда над свом земљом мисирском. А у њему срце пренеможе, јер им не вероваше. ");
INSERT INTO srp1868_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Али кад му казаше све речи Јосифове, које им је Јосиф рекао, и виде кола, која посла Јосиф по оца, тада оживе дух Јакова оца њиховог; ");
INSERT INTO srp1868_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","и рече Израиљ: Доста ми је кад је још жив син мој Јосиф; идем да га видим докле нисам умро. ");
INSERT INTO srp1868_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Тада пође Израиљ са свим шта имаше, и дошав у Вирсавеју принесе жртву Богу оца свог Исака. ");
INSERT INTO srp1868_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","И Бог рече Израиљу ноћу у утвари: Јакове! Јакове! А он одговори: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","И Бог му рече: Ја сам Бог, Бог оца твог; не бој се отићи у Мисир; јер ћу онде начинити од тебе народ велик. ");
INSERT INTO srp1868_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ја ћу ићи с тобом у Мисир, и ја ћу те одвести онамо, и Јосиф ће метнути руку своју на очи твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","И пође Јаков од Вирсавеје; и синови Израиљеви посадише Јакова, оца свог и децу своју и жене своје на кола која посла Фараон по њ. ");
INSERT INTO srp1868_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","И узеше стоку своју и благо своје што беху стекли у земљи хананској; и дођоше у Мисир Јаков и сва породица његова. ");
INSERT INTO srp1868_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Синове своје и синове синова својих, кћери своје и кћери синова својих, и сву породицу своју доведе са собом у Мисир. ");
INSERT INTO srp1868_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","А ово су имена деце Израиљеве што дођоше у Мисир: Јаков и синови његови. Првенац Јаковљев Рувим; ");
INSERT INTO srp1868_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","и синови Рувимови: Енох, Фалуј, Есрон и Хармија. ");
INSERT INTO srp1868_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","А синови Симеунови: Јемуило, Јамин, Аод, Јахин, Соар и Саул, син једне Хананејке. ");
INSERT INTO srp1868_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Синови Левијеви: Гирсон, Кат и Мерарије. ");
INSERT INTO srp1868_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Синови Јудини: Ир, Авнан, Силом, Фарес и Зара; а умрли беху Ир и Авнан у земљи хананској, али беху синови Фаресови Есром и Јемуило. ");
INSERT INTO srp1868_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Синови Исахарови: Тола, Фува, Јов, и Симрон. ");
INSERT INTO srp1868_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Синови Завулонови: Серед, Алон, и Ахојило. ");
INSERT INTO srp1868_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","То су синови Лијини, које роди Јакову у Падан-Араму, и јоште Дина кћи његова. Свега душа, синова његових и кћери његових беше тридесет и три. ");
INSERT INTO srp1868_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Синови Гадови: Сифон, Агије, Суније, Есвон, Ирије, Ародије и Арилије. ");
INSERT INTO srp1868_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Синови Асирови: Јемна, Јесва, Јесвија и Верија, и сестра њихова Сара. А синови Веријини Ховор и Мелхило. ");
INSERT INTO srp1868_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","То су синови Зелфе, коју даде Лаван Лији кћери својој, и она их роди Јакову, шеснаест душа. ");
INSERT INTO srp1868_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","А синови Рахиље жене Јаковљеве: Јосиф и Венијамин. ");
INSERT INTO srp1868_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","А Јосифу се родише у Мисиру од Асенете, кћери Потифере свештеника онског: Манасија и Јефрем. ");
INSERT INTO srp1868_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","А синови Венијаминови: Вела, Вехер, Асвил, Гира, Наман, Ихије, Рос, Мупим, Упим и Арад. ");
INSERT INTO srp1868_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","То су синови Рахиљини што се родише Јакову, свега четрнаест душа. ");
INSERT INTO srp1868_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","И син Данов: Асом. ");
INSERT INTO srp1868_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","А синови Нефталимови: Асило, Гуније, Јесер и Силим. ");
INSERT INTO srp1868_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","То су синови Вале, коју даде Лаван Рахиљи кћери својој и она их роди Јакову; свега седам душа. ");
INSERT INTO srp1868_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","А свега душа што дођоше с Јаковом у Мисир, а изађоше од бедара његових, осим жена синова Јаковљевих, свега душа беше шездесет и шест. ");
INSERT INTO srp1868_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","И два сина Јосифова који му се родише у Мисиру; свега дакле душа дома Јаковљевог, што дођоше у Мисир, беше седамдесет. ");
INSERT INTO srp1868_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","А Јуду посла Јаков напред к Јосифу, да му јави да изађе преда њ у Гесем. И дођоше у земљу гесемску. ");
INSERT INTO srp1868_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","А Јосиф упреже у кола своја, и изађе на сусрет Израиљу оцу свом у Гесем; и кад га виде Јаков, паде му око врата, и плака дуго о врату његовом. ");
INSERT INTO srp1868_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","И рече Израиљ Јосифу: Сада не марим умрети кад сам те видео да си јоште жив. ");
INSERT INTO srp1868_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","А Јосиф рече браћи својој и дому оца свог: Идем да јавим Фараону; али ћу му казати: Браћа моја и дом оца мог из земље хананске дођоше к мени; ");
INSERT INTO srp1868_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","а ти су људи пастири и свагда су се бавили око стоке, и доведоше овце своје и говеда своја и шта год имају. ");
INSERT INTO srp1868_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","А кад вас Фараон дозове, рећи ће вам: Какву радњу радите? ");
INSERT INTO srp1868_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","А ви кажите: Пастири су биле слуге твоје од младости, и ми и стари наши; да бисте остали у земљи гесемској; јер су Мисирцима сви пастири нечисти. ");
INSERT INTO srp1868_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","И отишавши Јосиф јави Фараону и рече: Отац мој и браћа моја с овцама својим и с говедима својим и са свим што имају дођоше из земље хананске, и ево их у земљи гесемској. ");
INSERT INTO srp1868_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","И узевши неколицину браће своје, пет људи, изведе их пред Фараона. ");
INSERT INTO srp1868_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","А Фараон рече браћи његовој: Какву радњу радите? А они рекоше Фараону: Пастири су слуге твоје, и ми и наши стари. ");
INSERT INTO srp1868_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Још рекоше Фараону: Дођосмо да живимо као дошљаци у овој земљи, јер нема паше за стоку твојих слуга, јер је велика глад у земљи хананској; а сада допусти да живе у земљи гесемској слуге твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","А Фараон рече Јосифу: Отац твој и браћа твоја дођоше к теби; ");
INSERT INTO srp1868_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","у твојој је власти земља мисирска; на најбољем месту у овој земљи насели оца свог и браћу своју, нека живе у земљи гесемској; и ако које знаш између њих да су вредни људи, постави их над мојом стоком. ");
INSERT INTO srp1868_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","После доведе Јосиф и Јакова оца свог и изведе га пред Фараона, и благослови Јаков Фараона. ");
INSERT INTO srp1868_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","А Фараон рече Јакову: Колико ти има година? ");
INSERT INTO srp1868_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Одговори Јаков Фараону: Мени има сто и тридесет година, како сам дошљак. Мало је дана живота мог и зли су били, нити стижу век отаца мојих, колико су они живели. ");
INSERT INTO srp1868_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","И благословив Јаков Фараона отиде од Фараона. ");
INSERT INTO srp1868_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","А Јосиф насели оца свог и браћу своју, и даде им добро у земљи мисирској на најбољем месту те земље, у земљи рамеској, као што заповеди Фараон. ");
INSERT INTO srp1868_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","И храњаше Јосиф хлебом оца свог и браћу своју и сав дом оца свог до најмањег. ");
INSERT INTO srp1868_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Али неста хлеба у свој земљи, јер глад беше врло велика, и узмучи се земља мисирска и земља хананска од глади. ");
INSERT INTO srp1868_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","И покупи Јосиф све новце што се налажаху по земљи мисирској и по земљи хананској за жито, које куповаху, и слагаше новце у кућу Фараонову. ");
INSERT INTO srp1868_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","А кад неста новца у земљи мисирској и у земљи хананској, стадоше сви Мисирци долазити к Јосифу говорећи: Дај нам хлеба; зашто да мремо код тебе, што новаца нема? ");
INSERT INTO srp1868_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","А Јосиф им говораше: Дајте стоку своју, па ћу вам дати хлеба за стоку, кад је нестало новца. ");
INSERT INTO srp1868_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","И довођаху стоку своју к Јосифу, и Јосиф им даваше хлеба за коње и за овце и за говеда и за магарце. Тако их прехрани ону годину хлебом за сву стоку њихову. ");
INSERT INTO srp1868_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","А кад прође она година, стадоше опет долазити к њему друге године говорећи: Не можемо тајити од господара свог, али је новаца нестало, и стока коју имасмо у нашег је господара; и није остало ништа да донесемо господару свом осим телеса наших и њива наших. ");
INSERT INTO srp1868_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Зашто да мремо на твоје очи? Ево и нас и наших њива; купи нас и њиве наше за хлеб, да с њивама својим будемо робови Фараону, и дај жита да останемо живи и не помремо и да земља не опусти. ");
INSERT INTO srp1868_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Тако покупова Јосиф Фараону све њиве у Мисиру, јер Мисирци продаваху сваки своју њиву, кад глад узе јако маха међу њима. И земља поста Фараонова. ");
INSERT INTO srp1868_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","А народ пресели у градове од једног краја Мисира до другог. ");
INSERT INTO srp1868_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Само не купи свештеничке њиве; јер Фараон одреди део свештеницима, и храњаху се од свог дела, који им даде Фараон, те не продаше својих њива. ");
INSERT INTO srp1868_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","А Јосиф рече народу: Ево купих данас вас и њиве ваше Фараону; ево вам семе, па засејте њиве. ");
INSERT INTO srp1868_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","А шта буде рода, даћете пето Фараону, а четири дела нека буду вама за семе по њивама и за храну вама и онима који су по кућама вашим и за храну деци вашој. ");
INSERT INTO srp1868_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","А они рекоше: Ти си нам живот сачувао; нека нађемо милост пред господарем својим да будемо робови Фараону. ");
INSERT INTO srp1868_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","И постави Јосиф закон до данашњег дана за њиве мисирске да се даје пето Фараону; само њиве свештеничке не посташе Фараонове. ");
INSERT INTO srp1868_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","А деца Израиљева живљаху у земљи мисирској у крају гесемском, и држаху га, и народише се и намножише се веома. ");
INSERT INTO srp1868_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","И Јаков поживе у земљи мисирској седамнаест година; а свега би Јакову сто и четрдесет и седам година. ");
INSERT INTO srp1868_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","А кад се приближи време Израиљу да умре, дозва сина свог Јосифа, и рече му: Ако сам нашао милост пред тобом, метни руку своју под стегно моје, и учини ми милост и веру, немој ме погрепсти у Мисиру; ");
INSERT INTO srp1868_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","него нека лежим код отаца својих; и ти ме однеси из Мисира и погреби ме у гробу њиховом. А он рече: Учинићу како си казао. ");
INSERT INTO srp1868_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","И рече му Јаков: Закуни ми се. И он му се закле. И поклони се Израиљ преко узглавља од одра свог. ");
INSERT INTO srp1868_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","После јавише Јосифу: Ено, отац ти је болестан. А он поведе са собом два сина своја, Манасију и Јефрема. ");
INSERT INTO srp1868_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","И јавише Јакову и рекоше: Ево син твој Јосиф иде к теби. А Израиљ се окрепи, те седе на постељи својој. ");
INSERT INTO srp1868_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","И рече Јаков Јосифу: Бог Свемогући јави се мени у Лузу у земљи хананској, и благослови ме; ");
INSERT INTO srp1868_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","и рече ми: Учинићу те да нарастеш и намножиш се; и учинићу од тебе мноштво народа, и даћу земљу ову семену твом након тебе да је њихова до века. ");
INSERT INTO srp1868_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Сада дакле два сина твоја, што ти се родише у земљи мисирској пре него дођох к теби у Мисир, моји су, Јефрем и Манасија као Рувим и Симеун нека буду моји. ");
INSERT INTO srp1868_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","А деца коју родиш после њих, нека буду твоја и нека се по имену браће своје зову у наследству свом. ");
INSERT INTO srp1868_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Јер кад се вратих из Падана, умре ми Рахиља у земљи хананској на путу, кад беше још мало до Ефрате; и погребох је на путу у Ефрату, а то је Витлејем. ");
INSERT INTO srp1868_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","А виде Израиљ синове Јосифове, рече: Ко су ови? ");
INSERT INTO srp1868_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","А Јосиф рече оцу свом: Моји синови, које ми Бог даде овде. А он рече: Доведи их к мени, да их благословим. ");
INSERT INTO srp1868_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","А очи беху Израиљу отежале од старости, те не могаше добро видети. А кад му их приведе, целива их и загрли. ");
INSERT INTO srp1868_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","И рече Израиљ Јосифу: Нисам мислио да ћу видети лице твоје; а гле, Бог ми даде да видим и пород твој. ");
INSERT INTO srp1868_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","А Јосиф одмаче их од колена његових и поклони се лицем до земље. ");
INSERT INTO srp1868_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Па их узе Јосиф обојицу, Јефрема себи с десне стране а Израиљу с леве, Манасију пак себи с леве стране а Израиљу с десне; и тако их примаче к њему. ");
INSERT INTO srp1868_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","А Израиљ пруживши десну руку своју метну је на главу Јефрему млађем, а леву на главу Манасији, тако наместивши руке навлаш, ако и јесте Манасија био првенац. ");
INSERT INTO srp1868_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","И благослови Јосифа говорећи: Бог, коме су свагда угађали оци моји Аврам и Исак, Бог, који ме је хранио од како сам постао до данашњег дана, ");
INSERT INTO srp1868_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Анђео, који ме је избављао од сваког зла, да благослови децу ову, и да се по мом имену и по имену отаца мојих Аврама и Исака прозову, и да се као рибе намноже на земљи! ");
INSERT INTO srp1868_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","А Јосиф кад виде где отац метну десну руку своју на главу Јефрему, не би му мило, па ухвати за руку оца свог да је премести с главе Јефремове на главу Манасијину. ");
INSERT INTO srp1868_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","И рече Јосиф оцу свом: Не тако, оче; ово је првенац, метни десницу њему на главу. ");
INSERT INTO srp1868_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Али отац његов не хте, него рече: Знам, сине, знам; и од њега ће постати народ, и он ће бити велик; али ће млађи брат његов бити већи од њега, и семе ће његово бити велико мноштво народа. ");
INSERT INTO srp1868_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","И благослови их у онај дан и рече: Тобом ће Израиљ благосиљати говорећи: Бог да те учини као Јефрема и као Манасију. Тако постави Јефрема пред Манасију. ");
INSERT INTO srp1868_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","После рече Израиљ Јосифу: Ево ја ћу скоро умрети; али ће Бог бити с вама и одвешће вас опет у земљу отаца ваших. ");
INSERT INTO srp1868_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","И ја ти дајем један део више него браћи твојој, који узех из руку аморејских мачем својим и луком својим. ");
INSERT INTO srp1868_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","После сазва Јаков синове своје и рече: Скупите се да вам јавим шта ће вам бити до послетка. ");
INSERT INTO srp1868_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Скупите се и послушајте, синови Јаковљеви, послушајте Израиља оца свог. ");
INSERT INTO srp1868_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рувиме, ти си првенац мој, крепост моја и почетак силе моје; први господством и први снагом. ");
INSERT INTO srp1868_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Навро си као вода; нећеш бити први; јер си стао на постељу оца свог и оскврнио је легав на њу. ");
INSERT INTO srp1868_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеун и Левије, браћа, мачеви су им оружје неправди. ");
INSERT INTO srp1868_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","У тајне њихове да не улази душа моја, са збором њиховим да се не саставља слава моја; јер у гневу свом побише људе, и за своје весеље покидаше волове. ");
INSERT INTO srp1868_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Проклет да је гнев њихов, што беше нагао, и љутина њихова, што беше жестока; разделићу их по Јакову, и расућу их по Израиљу. ");
INSERT INTO srp1868_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Јуда, тебе ће хвалити браћа твоја, а рука ће ти бити за вратом непријатељима твојим, и клањаће ти се синови оца твог. ");
INSERT INTO srp1868_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Лавићу Јуда! С плена си се вратио, сине мој; спусти се и леже као лав и као љути лав; ко ће га пробудити? ");
INSERT INTO srp1868_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Палица владалачка неће се одвојити од Јуде нити од ногу његових онај који поставља закон, докле не дође Онај коме припада, и Њему ће се покоравати народи. ");
INSERT INTO srp1868_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Веже за чокот магаре своје, и за племениту лозу младе од магарице своје; у вину пере хаљину своју и огртач свој у соку од грожђа. ");
INSERT INTO srp1868_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Очи му се црвене од вина и зуби беле од млека. ");
INSERT INTO srp1868_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Завулон ће живети покрај мора и где пристају лађе, а међа ће му бити до Сидона. ");
INSERT INTO srp1868_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Исахар је магарац јак у костима, који лежи у тору, ");
INSERT INTO srp1868_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","И виде да је почивање добро и да је земља мила, сагнуће рамена своја да носи, и плаћаће данак. ");
INSERT INTO srp1868_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан ће судити свом народу, као једно између племена Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дан ће бити змија на путу и гуја на стази, која уједа коња за кичицу, те пада коњ на узнако. ");
INSERT INTO srp1868_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Господе, Тебе чекам да ме избавиш. ");
INSERT INTO srp1868_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","А Гад, њега ће војска савладати; али ће најпосле он надвладати. ");
INSERT INTO srp1868_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","У Асира ће бити обилата храна, и он ће давати сласти царске. ");
INSERT INTO srp1868_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Нефталим је кошута пуштена, и говориће лепе речи. ");
INSERT INTO srp1868_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Јосиф је родна грана, родна грана крај извора, којој се огранци раширише сврх зида. ");
INSERT INTO srp1868_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ако га и уцвелише љуто и стрељаше на њ, и бише му непријатељи стрелци, ");
INSERT INTO srp1868_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Опет оста јак лук његов и ојачаше мишице руку његових од руку јаког Бога Јаковљевог, одакле поста пастир, камен Израиљу, ");
INSERT INTO srp1868_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Од силног Бога оца твог, који ће ти помагати, и од Свемогућег, који ће те благословити благословима озго с неба, благословима оздо из бездана, благословима од дојака и од материце. ");
INSERT INTO srp1868_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Благослови оца твог надвисише благослове мојих старих сврх брда вечних, нека буду над главом Јосифовом и над теменом одвојеног између браће. ");
INSERT INTO srp1868_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Венијамин је вук грабљиви, јутром једе лов, а вечером дели плен. ");
INSERT INTO srp1868_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ово су дванаест племена Израиљевих, и ово им отац изговори кад их благослови, свако благословом његовим благослови их. ");
INSERT INTO srp1868_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Потом им заповеди и рече им: Кад се приберем к роду свом, погребите ме код отаца мојих у пећини која је на њиви Ефрона Хетејина, ");
INSERT INTO srp1868_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","у пећини која је на њиви макпелској према Мамрији у земљи хананској, коју купи Аврам с њивом у Ефрона Хетејина да има свој гроб. ");
INSERT INTO srp1868_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Онде погребе Аврама и Сару жену његову, онде погребоше Исака и Ревеку жену његову, и онде погребох Лију. ");
INSERT INTO srp1868_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","А купљена је њива и пећина на њој у синова Хетових. ");
INSERT INTO srp1868_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","А кад изговори Јаков заповести синовима својим, диже ноге своје на постељу, и умре, и прибран би к роду свом. ");
INSERT INTO srp1868_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Тада Јосиф паде на лице оцу свом, и плака над њим целујући га. ");
INSERT INTO srp1868_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","И заповеди Јосиф слугама својим лекарима да мирисима помажу оца његовог; и лекари помазаше мирисима Израиља. ");
INSERT INTO srp1868_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","И наврши му се четрдесет дана, јер толико дана треба оним које помажу мирисима; и плакаше за њим Мисирци седамдесет дана. ");
INSERT INTO srp1868_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","А кад прођоше жалосни дани, рече Јосиф домашњима Фараоновим говорећи: Ако сам нашао милост пред вама, говорите Фараону и реците: ");
INSERT INTO srp1868_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Отац ме је мој заклео говорећи: Ево, ја ћу скоро умрети; у гробу мом, који ископах у земљи хананској, онде ме погреби. Па сада да идем да погребем оца свог, а после ћу опет доћи. ");
INSERT INTO srp1868_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","А Фараон му рече: Иди, погреби оца свог како те је заклео. ");
INSERT INTO srp1868_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","И отиде Јосиф да погребе оца свог; и с њим пођоше све слуге Фараонове, старешине од дома његовог и све старешине од земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","И сав дом Јосифов и браћа његова и дом оца његовог; само децу своју и овце своје и говеда своја оставише у земљи гесемској. ");
INSERT INTO srp1868_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","А пође с њим кола и коњаника толико да беше војска врло велика. ");
INSERT INTO srp1868_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","А кад дођоше на гумно Атадово, које је с оне стране Јордана, плакаше онде много и врло тужно; и Јосиф учини жалост за оцем својим за седам дана. ");
INSERT INTO srp1868_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","А људи из оне земље, Хананејци, кад видеше плач на гумну Атадовом, рекоше: У великој су жалости Мисирци. Зато прозваше оно место с оне стране Јордана Жалост мисирска. ");
INSERT INTO srp1868_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","И учинише му синови његови како им беше заповедио. ");
INSERT INTO srp1868_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Однесоше га синови његови у земљу хананску, и погребоше га у пећини на њиви макпелској, коју купи Аврам да има свој гроб у Ефрона Хетејина према Мамрији. ");
INSERT INTO srp1868_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","И погребавши оца свог врати се Јосиф у Мисир и браћа његова и сви који беху изашли с њим да погребу оца његовог. ");
INSERT INTO srp1868_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","А браћа Јосифова видећи где им отац умре, рекоше: Може бити да се Јосиф срди на нас, па ће нам се осветити за све зло што му учинисмо. ");
INSERT INTO srp1868_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Зато поручише Јосифу: Отац твој заповеди на самрти и рече: ");
INSERT INTO srp1868_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Овако кажите Јосифу: Молим те, опрости браћи својој безакоње и грех, што ти пакостише; сада опрости безакоње слугама Бога оца твог. А Јосиф заплака се кад му то рекоше. ");
INSERT INTO srp1868_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","После дођоше и браћа његова и падоше пред њим и рекоше: Ево смо слуге твоје. ");
INSERT INTO srp1868_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","А Јосиф им рече: Не бојте се, зар сам ја место Бога? ");
INSERT INTO srp1868_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ви сте мислили зло по ме, али је Бог мислио добро, да учини шта се данас збива, да се сачува у животу многи народ. ");
INSERT INTO srp1868_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Не бојте се дакле; ја ћу хранити вас и вашу децу. Тако их утеши и ослободи. ");
INSERT INTO srp1868_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Тако живљаше Јосиф у Мисиру с домом оца свог, и поживе сто и десет година. ");
INSERT INTO srp1868_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","И виде Јосиф синове Јефремове до трећег колена; и синови Махира сина Манасијиног родише се и одрастоше на коленима Јосифовим. ");
INSERT INTO srp1868_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","И рече Јосиф браћи својој: Ја ћу скоро умрети; али ће вас зацело Бог походити, и извешће вас из ове земље у земљу за коју се заклео Авраму, Исаку и Јакову. ");
INSERT INTO srp1868_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","И закле Јосиф синове Израиљеве и рече: Заиста ће вас походити Бог; а ви онда однесите кости моје одавде. ");
INSERT INTO srp1868_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Потом умре Јосиф, а беше му сто и десет година; и помазавши га мирисима метнуше га у ковчег у Мисиру. ");
INSERT INTO srp1868_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ово су имена синова Израиљевих који дођоше у Мисир, дођоше с Јаковом, сваки са својом породицом: ");
INSERT INTO srp1868_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Рувим, Симеун, Левије и Јуда, ");
INSERT INTO srp1868_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Исахар, Завулон и Венијамин, ");
INSERT INTO srp1868_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Дан и Нефталим, Гад и Асир. ");
INSERT INTO srp1868_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","А свега беше их од бедара Јаковљевих седамдесет душа с Јосифом, који беше у Мисиру. ");
INSERT INTO srp1868_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","А Јосиф умре и сва браћа његова и сав онај нараштај. ");
INSERT INTO srp1868_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","И синови Израиљеви народише се и умножише се, и напредоваше и осилише веома, да их се земља напуни. ");
INSERT INTO srp1868_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Тада наста нов цар у Мисиру, који не знаше за Јосифа; ");
INSERT INTO srp1868_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","и рече народу свом: Гле, народ синова Израиљевих већи је и силнији од нас. ");
INSERT INTO srp1868_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Него хајде мудро да поступамо с њима, да се не множе, и кад настане рат да не пристану с непријатељима нашим и не ударе на нас и не оду из земље. ");
INSERT INTO srp1868_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","И поставише над њима настојнике да их муче тешким пословима; и грађаше народ Израиљев Фараону градове Питом и Рамесу. ");
INSERT INTO srp1868_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Али што га више мучаху то се више множаше и напредоваше, да се грожаху од синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","И жестоко нагоњаху Мисирци синове Израиљеве на послове, ");
INSERT INTO srp1868_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","и загорчаваху им живот тешким пословима, блатом и опекама и сваким радом у пољу, и сваким другим послом, на који их жестоко нагоњаху. ");
INSERT INTO srp1868_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","И још заповеди цар мисирски бабицама јеврејским, од којих једној беше име Сефора, а другој Фува, ");
INSERT INTO srp1868_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","и рече: Кад бабичите Јеврејке, и у порођају видите да је мушко, убијте га, а кад буде женско, нек остане живо. ");
INSERT INTO srp1868_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Али се бабице бојаху Бога, и не чињаху како им рече цар мисирски, него остављаху децу у животу. ");
INSERT INTO srp1868_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","А цар мисирски дозва бабице, и рече им: Зашто то чините, те остављате у животу мушку децу? ");
INSERT INTO srp1868_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","А бабице рекоше Фараону: Јеврејке нису као жене Мисирке; јаче су; док им дође бабица, оне већ роде. ");
INSERT INTO srp1868_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","И Бог учини добро бабицама; и народ се умножи и осили веома; ");
INSERT INTO srp1868_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","и што се бабице бојаху Бога, начини им куће. ");
INSERT INTO srp1868_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Тада заповеди Фараон свему народу свом говорећи: Сваког сина који се роди баците у воду, а кћери све остављајте у животу. ");
INSERT INTO srp1868_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","А неко од племена Левијевог отиде и ожени се кћерју Левијевом. ");
INSERT INTO srp1868_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","И она затрудне и роди сина; и видећи га лепог кријаше га три месеца. ");
INSERT INTO srp1868_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","А кад га не може више крити, уже ковчежић од сите, и обли га смолом и паклином, и метну дете у њ, и однесе га у трску крај реке. ");
INSERT INTO srp1868_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","А сестра његова стаде подаље да види шта ће бити од њега. ");
INSERT INTO srp1868_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","А кћи Фараонова дође да се купа у реци, и девојке њене ходаху крај реке; и она угледа ковчежић у трсци, и посла дворкињу своју те га извади. ");
INSERT INTO srp1868_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","А кад отвори, виде дете, и гле, дете плакаше; и сажали јој се, и рече: То је јеврејско дете. ");
INSERT INTO srp1868_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Тада рече сестра његова кћери Фараоновој: Хоћеш ли да идем да ти дозовем дојкињу Јеврејку, да ти доји дете? ");
INSERT INTO srp1868_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","А кћи Фараонова рече јој: Иди. И отиде девојчица, и дозва матер детињу. ");
INSERT INTO srp1868_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","И кћи Фараонова рече јој: Узми ово дете, и одој ми га, а ја ћу ти платити. И узе жена дете и одоји га. ");
INSERT INTO srp1868_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","А кад дете одрасте, одведе га ка кћери Фараоновој, а она га посини; и надеде му име Мојсије говорећи: Јер га из воде извадих. ");
INSERT INTO srp1868_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","И кад Мојсије беше велик, изађе к браћи својој, и гледаше невољу њихову. И виде где некакав Мисирац бије човека Јеврејина између браће његове. ");
INSERT INTO srp1868_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","И обазрев се и тамо и амо, кад виде да нема никога, уби Мисирца, и закопа га у песак. ");
INSERT INTO srp1868_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","И сутрадан изађе опет, а то се два Јеврејина свађаху, и рече оном који чињаше криво: Зашто бијеш ближњег свог? ");
INSERT INTO srp1868_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","А он рече: Ко је тебе поставио кнезом и судијом над нама? Хоћеш ли да ме убијеш као што си убио Мисирца? Тада се Мојсије уплаши и рече: Заиста се дознало. ");
INSERT INTO srp1868_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","И Фараон чувши за то тражаше да погуби Мојсија. Али Мојсије побеже од Фараона и дође у земљу мадијанску, и седе код једног студенца. ");
INSERT INTO srp1868_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","А свештеник мадијански имаше седам кћери, и оне дођоше и стадоше захватати воду и наливати у појила да напоје стадо оца свог. ");
INSERT INTO srp1868_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","А дођоше пастири, и отераше их; а Мојсије уста и одбрани их, и напоји им стадо. ");
INSERT INTO srp1868_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","И оне се вратише к оцу свом Рагуилу; а он рече: Што се данас тако брзо вратисте? ");
INSERT INTO srp1868_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","А оне рекоше: Један Мисирац одбрани нас од пастира, и нали нам и напоји стадо. ");
INSERT INTO srp1868_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","А он рече кћерима својим: Па где је? Зашто остависте тог човека? Зовите га да једе. ");
INSERT INTO srp1868_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","И Мојсије се склони да живи код оног човека, и он даде Мојсију кћер своју Сефору. ");
INSERT INTO srp1868_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","И она роди сина, и он му надеде име Гирсам, јер сам, рече, дошљак у земљи туђој. ");
INSERT INTO srp1868_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","А после много времена умре цар мисирски; и уздисаху од невоље синови Израиљеви и викаху; и вика њихова ради невоље дође до Бога. ");
INSERT INTO srp1868_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","И Бог чу уздисање њихово, и опомену се Бог завета свог с Аврамом, с Исаком и с Јаковом. ");
INSERT INTO srp1868_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","И погледа Бог на синове Израиљеве, и виде их. ");
INSERT INTO srp1868_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","А Мојсије пасаше стадо Јотору тасту свом, свештенику мадијанском, и одведе стадо преко пустиње, и дође на гору Божију Хорив. ");
INSERT INTO srp1868_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","И јави му се анђео Господњи у пламену огњеном из купине. И погледа, а то купина огњем гори а не сагорева. ");
INSERT INTO srp1868_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","И Мојсије рече: Идем да видим ту утвару велику, зашто не сагорева купина. ");
INSERT INTO srp1868_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","А Господ кад га виде где иде да види, викну га Бог из купине, и рече: Мојсије! Мојсије! А он одговори: Ево ме. ");
INSERT INTO srp1868_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","А Бог рече: Не иди овамо. Изуј обућу своју с ногу својих, јер је место где стојиш света земља. ");
INSERT INTO srp1868_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Још рече: Ја сам Бог оца твог, Бог Аврамов, Бог Исаков и Бог Јаковљев. А Мојсије заклони лице своје, јер га страх беше гледати у Бога. ");
INSERT INTO srp1868_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","И рече Господ: Добро видех невољу народа свог у Мисиру, и чух вику његову од зла које му чине настојници, јер познах муку његову. ");
INSERT INTO srp1868_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","И сиђох да га избавим из руку мисирских, и да га изведем из оне земље у земљу добру и пространу, у земљу где млеко и мед тече, на место где су Хананеји и Хетеји и Амореји и Ферезеји и Јевеји и Јевусеји. ");
INSERT INTO srp1868_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","И сада ево вика синова Израиљевих дође преда ме, и видех муку, којом их муче Мисирци. ");
INSERT INTO srp1868_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Сада хајде да те пошаљем к Фараону, да изведеш народ мој, синове Израиљеве, из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","А Мојсије рече Богу: Ко сам ја да идем к Фараону и да изведем синове Израиљеве из Мисира? ");
INSERT INTO srp1868_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","А Бог му рече: Ја ћу бити с тобом, и ово нека ти буде знак да сам те ја послао: кад изведеш народ из Мисира, служићете Богу на овој гори. ");
INSERT INTO srp1868_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","А Мојсије рече Богу: Ево, кад отидем к синовима Израиљевим, па им кажем: Бог отаца ваших посла ме к вама, ако ми кажу: Како Му је име? Шта ћу им казати? ");
INSERT INTO srp1868_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","А Господ рече Мојсију: Ја сам Онај што јесте. И рече: Тако ћеш казати синовима Израиљевим: Који јесте, Он ме посла к вама. ");
INSERT INTO srp1868_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","И опет рече Бог Мојсију: Овако кажи синовима Израиљевим: Господ Бог отаца ваших, Бог Аврамов, Бог Исаков и Бог Јаковљев, посла ме к вама; то је име моје довека, и то је спомен мој од колена на колено. ");
INSERT INTO srp1868_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Иди, и скупи старешине израиљске, па им реци: Господ Бог отаца ваших јави ми се, Бог Аврамов, Исаков и Јаковљев, говорећи: Доиста обиђох вас, и видех како вам је у Мисиру. ");
INSERT INTO srp1868_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Па рекох: Извешћу вас из невоље мисирске у земљу хананејску и хетејску и аморејску и ферезејску и јевејску и јевусејску, у земљу где тече млеко и мед. ");
INSERT INTO srp1868_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","И они ће послушати глас твој; па ћеш ти и старешине израиљске отићи к цару мисирском, и рећи ћете му: Господ Бог јеврејски срете нас, па ти се молимо да изађемо три дана хода у пустињу да принесемо жртву Господу Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","А ја знам да вам неће допустити цар мисирски да изађете без руке крепке. ");
INSERT INTO srp1868_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Али ћу пружити руку своју, и ударићу Мисир свим чудесима својим, која ћу учинити у њему: и после ће вас пустити. ");
INSERT INTO srp1868_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","И учинићу да народ нађе љубав у Мисираца, па кад пођете, нећете поћи празни; ");
INSERT INTO srp1868_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","него ће свака жена заискати у суседе своје и у домаћице своје накита сребрног и накита златног и хаљина; и метнућете на синове своје и на кћери своје, и опленићете Мисир. ");
INSERT INTO srp1868_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","А Мојсије одговори и рече: Али неће ми веровати ни послушати глас мој; јер ће рећи: Није ти се Господ јавио. ");
INSERT INTO srp1868_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","А Господ му рече: Шта ти је то у руци? А он одговори: Штап. ");
INSERT INTO srp1868_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","А Бог му рече: Баци га на земљу. И баци га на земљу, а он поста змија. И Мојсије побеже од ње. ");
INSERT INTO srp1868_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","А Господ рече Мојсију: Пружи руку своју, па је ухвати за реп. И пружи руку своју, и ухвати је, и опет поста штап у руци његовој. ");
INSERT INTO srp1868_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","То учини, рече Господ, да верују да ти се јавио Господ Бог отаца њихових, Бог Аврамов, Бог Исаков и Бог Јаковљев. ");
INSERT INTO srp1868_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","И опет му рече Господ: Тури сада руку своју у недра своја. И он тури руку своју у недра своја; а кад је извади из недара, а то рука му губава, бела као снег. ");
INSERT INTO srp1868_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","А Бог му рече: Тури опет руку своју у недра своја. И опет тури руку своју у недра своја; а кад је извади из недара, а то опет постала као и остало тело његово. ");
INSERT INTO srp1868_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Тако, рече Бог, ако ти не узверују и не послушају глас твој за први знак, послушаће за други знак. ");
INSERT INTO srp1868_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ако ли не узверују ни за та два знака и не послушају глас твој, а ти захвати воде из реке, и пролиј на земљу, и претвориће се вода коју захватиш из реке, и проврћи ће се у крв на земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","А Мојсије рече Господу: Молим Ти се, Господе, нисам речит човек, нити сам пре био нити сам откако си проговорио са слугом својим, него сам спорих уста и спорог језика. ");
INSERT INTO srp1868_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","А Господ му рече: Ко је дао уста човеку? Или ко може створити немог или глувог или окатог или слепог? Зар не ја, Господ? ");
INSERT INTO srp1868_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Иди дакле, ја ћу бити с устима твојим, и учићу те шта ћеш говорити. ");
INSERT INTO srp1868_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","А Мојсије рече: Молим Те, Господе, пошљи оног кога треба да пошаљеш. ");
INSERT INTO srp1868_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","И разгневи се Господ на Мојсија, и рече му: Није ли ти брат Арон Левит? Знам да је он речит; и ево он ће те срести, и кад те види обрадоваће се у срцу свом. ");
INSERT INTO srp1868_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Њему ћеш казати и метнућеш ове речи у уста његова, и ја ћу бити с твојим устима и с његовим устима, и учићу вас шта ћете чинити. ");
INSERT INTO srp1868_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","И он ће место тебе говорити народу, и он ће бити теби место уста, а ти ћеш бити њему место Бога. ");
INSERT INTO srp1868_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","А тај штап узми у руку своју, њим ћеш чинити чудеса. ");
INSERT INTO srp1868_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","И отиде Мојсије, и врати се к Јотору тасту свом, и рече му: Пусти ме да идем, да се вратим к браћи својој у Мисиру, да видим јесу ли још у животу. И рече Јотор Мојсију: Иди с миром. ");
INSERT INTO srp1868_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","И рече Господ Мојсију у земљи мадијанској: Иди, врати се у Мисир, јер су помрли сви који су тражили душу твоју. ");
INSERT INTO srp1868_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","И узе Мојсије жену своју и синове своје, и посади их на магарца, и пође натраг у земљу мисирску. И узе Мојсије штап Божји у руку своју. ");
INSERT INTO srp1868_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","И рече Господ Мојсију: Кад отидеш и вратиш се у Мисир, гледај да учиниш пред Фараоном сва чудеса која ти метнух у руку: а ја ћу учинити да му отврдне срце и не пусти народ. ");
INSERT INTO srp1868_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","А ти ћеш рећи Фараону: Овако каже Господ: Израиљ је син мој, првенац мој. ");
INSERT INTO srp1868_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","И казах ти: Пусти сина мог да ми послужи. А ти га не хте пустити; ево ја ћу убити сина твог, првенца твог. ");
INSERT INTO srp1868_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","И кад беше на путу у гостионици, дође к њему Господ и хтеде да га убије. ");
INSERT INTO srp1868_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","А Сефора узе оштар нож, и обреза сина свог, и окрајак баци к ногама његовим говорећи: Ти си ми крвав заручник. ");
INSERT INTO srp1868_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Тада га остави Господ; а она ради обрезања рече: Крвав заручник. ");
INSERT INTO srp1868_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","А Господ рече Арону: Изиђи у пустињу на сусрет Мојсију. И отиде и срете га на гори Божијој, и пољуби га. ");
INSERT INTO srp1868_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","И Мојсије каза Арону све речи Господње, за које га посла, и све знаке које му заповеди. ");
INSERT INTO srp1868_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","И отидоше Мојсије и Арон, и скупише све старешине синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","И Арон каза све речи, које беше рекао Господ Мојсију, а Мојсије учини знаке пред народом. ");
INSERT INTO srp1868_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","И народ верова; и разумеше да је Господ походио синове Израиљеве и видео невољу њихову; и савивши се поклонише се. ");
INSERT INTO srp1868_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","А после изађоше Мојсије и Арон пред Фараона, и рекоше му: Овако вели Господ Бог Израиљев: Пусти народ мој да ми празнују празник у пустињи. ");
INSERT INTO srp1868_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Али Фараон рече: Ко је Господ да послушам глас његов и пустим Израиља? Не знам Господа, нити ћу пустити Израиља. ");
INSERT INTO srp1868_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","А они рекоше: Бог јеврејски срете нас; молимо ти се да отидемо три дана хода у пустињу да принесемо жртву Господу Богу свом, да не пошаље на нас помор или мач. ");
INSERT INTO srp1868_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","А цар мисирски рече им: Мојсије и Ароне, зашто одвлачите народ од рада његовог? Идите на свој посао. ");
INSERT INTO srp1868_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Још рече Фараон: Ето, народа је много у земљи; а ви још хоћете да оставља своје послове. ");
INSERT INTO srp1868_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","И у исти дан заповеди Фараон настојницима над народом и управитељима његовим, и рече: ");
INSERT INTO srp1868_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Од сад немојте давати народу плеву за опеке као до сада, нека иду сами и купе себи плеву. ");
INSERT INTO srp1868_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","А колико су опека до сад начињали толико изгоните и од сад, нити шта смањите; јер беспосличе, и зато вичу говорећи: Да идемо да принесемо жртву Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ваља навалити послове на те људе, па ће радити и неће слушати лажљиве речи. ");
INSERT INTO srp1868_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","И изашавши настојници народни и управитељи рекоше народу говорећи: Тако вели Фараон: Ја вам нећу давати плеву. ");
INSERT INTO srp1868_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Идите сами и купите себи плеву где нађете, а од посла вам се неће попустити ништа. ");
INSERT INTO srp1868_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","И разиђе се народ по свој земљи мисирској да чупа стрњику место плеве. ");
INSERT INTO srp1868_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","А настојници наваљиваху говорећи: Свршујте послове своје колико долази на дан, као кад је било плеве. ");
INSERT INTO srp1868_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","И управитељи синова Израиљевих, које поставише над њима настојници Фараонови, допадаху боја, и говораше им се: Зашто ни јуче ни данас не начинисте онолико опека колико вам је одређено, као пре? ");
INSERT INTO srp1868_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","И отидоше управитељи синова Израиљевих, и повикаше к Фараону говорећи: Зашто чиниш тако слугама својим? ");
INSERT INTO srp1868_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Плева се не даје слугама твојим, па опет кажу нам: Градите опеке. И ево бију слуге твоје, а крив је твој народ. ");
INSERT INTO srp1868_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","А он рече: Беспосличите, беспосличите, и зато говорите: Да идемо да принесемо жртву Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Него идите, радите; плева вам се неће давати, а опеке да дајете на број. ");
INSERT INTO srp1868_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","И управитељи синова Израиљевих видеше да је зло по њих што им се каза: Да не буде опека мање на дан. ");
INSERT INTO srp1868_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","И отишавши од Фараона сретоше Мојсија и Арона, који изиђоше пред њих. ");
INSERT INTO srp1868_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Па им рекоше: Господ нека вас види и суди, што нас омразисте Фараону и слугама његовим, и дадосте им мач у руку да нас побију. ");
INSERT INTO srp1868_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","И Мојсије се врати ка Господу и рече: Господе, зашто си навукао то зло на народ? Зашто си ме послао? ");
INSERT INTO srp1868_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Јер откако изиђох пред Фараона и проговорих у твоје име, још горе поступа с народом овим, а Ти не избави народ свој. ");
INSERT INTO srp1868_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","А Господ рече Мојсију: Сад ћеш видети шта ћу учинити Фараону; јер под руком крепком пустиће их, и истераће их из земље своје под руком крепком. ");
INSERT INTO srp1868_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Још говори Бог Мојсију и рече му: Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","И јавио сам се Авраму, Исаку и Јакову именом Бог Свемогући, а именом својим, Господ, не бих им познат. ");
INSERT INTO srp1868_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","И учиних завет свој с њима да ћу им дати земљу хананску, земљу у којој беху дошљаци, у којој живљаху као странци. ");
INSERT INTO srp1868_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","И чух уздисање синова Израиљевих, које Мисирци држе у ропству, и опоменух се завета свог. ");
INSERT INTO srp1868_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Зато кажи синовима Израиљевим: Ја сам Господ, и извешћу вас испод бремена мисирских, и опростићу вас ропства њиховог, и избавићу вас мишицом подигнутом и судовима великим. ");
INSERT INTO srp1868_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","И узећу вас да ми будете народ, и ја ћу вам бити Бог, те ћете познати да сам ја Господ Бог ваш, који вас изводим испод бремена мисирских. ");
INSERT INTO srp1868_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Пак ћу вас одвести у своју земљу, за коју подигох руку своју заклињући се да ћу је дати Авраму, Исаку и Јакову; и даћу вам је у наследство, ја Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","И Мојсије каза тако синовима Израиљевим; али не послушаше Мојсија од слабости духа свог и од љутог ропства. ");
INSERT INTO srp1868_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","И Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Иди, кажи Фараону, цару мисирском, нека пусти синове Израиљеве из земље своје. ");
INSERT INTO srp1868_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","А Мојсије проговори пред Господом и рече: Ето, синови Израиљеви не послушаше ме, а како ће ме послушати Фараон, кад сам необрезаних усана? ");
INSERT INTO srp1868_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Али Господ говори Мојсију и Арону, и заповеди им да иду к синовима Израиљевим и к Фараону, да изведу синове Израиљеве из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ово су поглавице у домовима отаца својих: синови Рувима, првенца Израиљевог: Енох и Фалуј, Асрон и Хармија; то су породице Рувимове. ");
INSERT INTO srp1868_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","А синови Симеунови: Јемуило и Јамин и Аод и Ахин и Сар и Саул, син неке Хананејке; то су породице Симеунове. ");
INSERT INTO srp1868_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","А ово су имена синова Левијевих по породицама њиховим: Гирсон и Кат и Мерарије; а Левије поживе сто и тридесет и седам година. ");
INSERT INTO srp1868_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","А ово су синови Гирсонови: Ловеније и Семеј по породицама својим. ");
INSERT INTO srp1868_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","А синови Катови: Амрам и Исар и Хеврон и Озило; а Кат поживе сто и тридесет и три године. ");
INSERT INTO srp1868_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","А синови Мераријеви: Молија и Мусија. То су породице Левијеве по лозама својим. ");
INSERT INTO srp1868_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","А Амрам се ожени Јохаведом братучедом својом, и она му роди Арона и Мојсија. А поживе Амрам сто и тридесет и седам година. ");
INSERT INTO srp1868_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","А синови Исарови беху: Кореј и Нафек и Зехрија. ");
INSERT INTO srp1868_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","А синови Озилови: Мисаило и Елисафан и Сегрија. ");
INSERT INTO srp1868_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","А Арон се ожени Јелисаветом кћерју Аминадавовом, сестром Насоновом; и она му роди Надава и Авијуда и Елеазара и Итамара. ");
INSERT INTO srp1868_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","А синови Корејеви беху: Асир и Елкана и Авијасар. То су породице Корејеве. ");
INSERT INTO srp1868_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","И Елеазар, син Аронов, ожени се једном од кћери Футилових, и она му роди Финеса. То су поглавице између отаца левитских по својим породицама. ");
INSERT INTO srp1868_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","То је Арон и Мојсије, којима рече Господ: Изведите синове Израиљеве из земље мисирске у четама њиховим. ");
INSERT INTO srp1868_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","То су који говорише Фараону, цару мисирском, да изведу синове Израиљеве из Мисира; то је Мојсије и то је Арон. ");
INSERT INTO srp1868_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","И кад Господ говораше Мојсију у земљи мисирској, ");
INSERT INTO srp1868_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","рече Господ Мојсију говорећи: Ја сам Господ; кажи Фараону цару мисирском све што сам ти казао. ");
INSERT INTO srp1868_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","И Мојсије рече пред Господом: Ево сам необрезаних усана, па како ће ме послушати Фараон? ");
INSERT INTO srp1868_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","И Господ рече Мојсију: Ево, поставио сам те да си Бог Фараону; а Арон брат твој биће пророк твој. ");
INSERT INTO srp1868_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Говорићеш све што ти заповедим; Арон, пак, брат твој говориће Фараону да пусти синове Израиљеве из земље своје. ");
INSERT INTO srp1868_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","А ја ћу учинити да отврдне срце Фараону, те ћу умножити знаке своје и чудеса своја у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","И неће вас ипак послушати Фараон; а ја ћу метнути руку своју на Мисир, и извешћу војску своју, народ свој, синове Израиљеве из земље мисирске судовима великим. ");
INSERT INTO srp1868_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","И познаће Мисирци да сам ја Господ, кад дигнем руку своју на Мисир, и изведем синове Израиљеве између њих. ");
INSERT INTO srp1868_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","И учини Мојсије и Арон, како им заповеди Господ, тако учинише. ");
INSERT INTO srp1868_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","А Мојсију беше осамдесет година, а Арону осамдесет и три године, кад говораху с Фараоном. ");
INSERT INTO srp1868_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","И рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Кад вам каже Фараон и рече: Учините како чудо, онда реци Арону: Узми штап свој, и баци га пред Фараона; те ће се преметнути у змију. ");
INSERT INTO srp1868_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","И изађоше Мојсије и Арон пред Фараона, и учинише како заповеди Господ; и баци Арон штап свој пред Фараона и пред слуге његове, и преметну се у змију. ");
INSERT INTO srp1868_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","А Фараон дозва мудраце и врачаре; те и врачари мисирски учинише тако својим врачањем. ");
INSERT INTO srp1868_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","И бацише сваки свој штап, и преметнуше се штапови у змије; али штап Аронов прождре њихове штапове. ");
INSERT INTO srp1868_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","И отврдну срце Фараоново, и не послуша их, као што беше казао Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","И рече Господ Мојсију: Отежа срце Фараоново; неће да пусти народ. ");
INSERT INTO srp1868_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Иди ујутру к Фараону. Гле, он ће изаћи на воду, па стани према њему на обали, а штап који се био преметнуо у змију узми у руку. ");
INSERT INTO srp1868_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","И реци му: Господ Бог јеврејски посла ме к теби да ти кажем: Пусти народ мој да ми послужи у пустињи. Али ти ето још не послуша. ");
INSERT INTO srp1868_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Зато Господ овако вели: Овако ћеш познати да сам ја Господ: ево, ударићу штапом што ми је у руци по води што је у реци, и преметнуће се у крв. ");
INSERT INTO srp1868_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","И рибе у реци помреће, и река ће се усмрдети, и Мисирци ће се узмучити тражећи воде да пију из реке. ");
INSERT INTO srp1868_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","И Господ рече Мојсију: Реци Арону: Узми штап свој, и пружи руку своју на воде мисирске, на потоке, на реке и на језера њихова и на сва зборишта вода њихових; и преметнуће се у крв, и биће крв по свој земљи мисирској, и по судима дрвеним и каменим. ");
INSERT INTO srp1868_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","И учинише Мојсије и Арон како им заповеди Господ; и подигавши Арон штап свој удари по води која беше у реци пред Фараоном и слугама његовим. И сва вода што беше у реци преметну се у крв. ");
INSERT INTO srp1868_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","И помреше рибе што беху у реци, и усмрде се река тако да не могаху Мисирци пити воде из реке, и беше крв по свој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Али и врачари мисирски учинише тако својим врачањем; и срце Фараону отврдну, те их не послуша, као што беше казао Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","И окренувши се Фараон отиде кући својој, и не мари ни за то. ");
INSERT INTO srp1868_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","А Мисирци сви копаше око реке тражећи воде да пију; јер не могаху пити воде из реке. ");
INSERT INTO srp1868_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","И наврши се седам дана како реку удари Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","И рече Господ Мојсију: Иди к Фараону, и реци му: Овако вели Господ: Пусти народ мој, да ми послужи. ");
INSERT INTO srp1868_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ако ли нећеш пустити, ево ћу морити сву земљу жабама. ");
INSERT INTO srp1868_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","И река ће се напунити жаба, и оне ће изаћи и скакати теби по кући и по клети где спаваш и по постељи твојој и по кућама слуга твојих и народа твог и по пећима твојим и по наћвама твојим; ");
INSERT INTO srp1868_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","и на тебе и на народ твој и на све слуге твоје скакаће жабе. ");
INSERT INTO srp1868_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","И рече Господ Мојсију: Кажи Арону: Пружи руку своју са штапом својим на реке и на потоке и на језера, и учини нек изађу жабе на земљу мисирску. ");
INSERT INTO srp1868_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","И пружи Арон руку своју на воде мисирске, и изађоше жабе и покрише земљу мисирску. ");
INSERT INTO srp1868_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Али и врачари мисирски учинише тако својим врачањем, учинише те изађоше жабе на земљу мисирску. ");
INSERT INTO srp1868_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","А Фараон дозва Мојсија и Арона и рече: Молите Господа да уклони жабе од мене и од народа мог, пак ћу пустити народ да принесу жртву Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","А Мојсије рече Фараону: Част да ти је нада мном! Докле да му се молим за те и за слуге твоје и за народ твој да одбије жабе од тебе и из кућа твојих, и само у реци да остану? ");
INSERT INTO srp1868_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","А он рече: До сутра. А Мојсије рече: Биће како си казао, да познаш да нико није као Господ Бог наш. ");
INSERT INTO srp1868_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Отићи ће жабе од тебе и из кућа твојих и од слуга твојих и од народа твог; само ће у реци остати. ");
INSERT INTO srp1868_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","И отиде Мојсије и Арон од Фараона; и завапи Мојсије ка Господу за жабе које беше пустио на Фараона. ");
INSERT INTO srp1868_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","А Господ учини по речи Мојсијевој; и поцркаше жабе, и опростише их се куће и села и поља. ");
INSERT INTO srp1868_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","И на гомиле их гртаху, да је смрдела земља. ");
INSERT INTO srp1868_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","А кад Фараон виде где одахну, отврдну му срце, и не послуша их, као што беше казао Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","А Господ рече Мојсију: Кажи Арону: Пружи штап свој, и удари по праху на земљи, нек се претвори у уши по свој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","И учинише тако: Арон пружи руку своју са штапом својим, и удари по праху на земљи, и посташе уши по људима и по стоци, сав прах на земљи претвори се у уши по целој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","А гледаше и врачари мисирски врачањем својим да учине да постану уши, али не могоше. И беху уши по људима и по стоци. ");
INSERT INTO srp1868_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","И рекоше врачари Фараону: Ово је прст Божји. Али опет отврдну срце Фараону, те их не послуша као што беше казао Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","А Господ рече Мојсију: Устани рано и изађи пред Фараона, ево, он ће изаћи к води, па му реци: Овако вели Господ: Пусти народ мој да ми послужи. ");
INSERT INTO srp1868_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ако ли не пустиш народ мој, ево, пустићу на тебе и на слуге твоје и на народ твој и на куће твоје свакојаке бубине, и напуниће се бубина куће мисирске и земља на којој су. ");
INSERT INTO srp1868_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Али ћу у тај дан одвојити земљу гесемску, где живи мој народ, и онде неће бити бубина, да познаш да сам ја Господ на земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","И поставићу разлику између народа свог и народа твог. Сутра ће бити знак тај. ");
INSERT INTO srp1868_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","И учини Господ тако, и дођоше силне бубине у кућу Фараонову и у куће слуга његових и у сву земљу мисирску, да се све у земљи поквари од бубина. ");
INSERT INTO srp1868_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","И Фараон дозва Мојсија и Арона, и рече им: Идите, принесите жртву Богу свом овде у земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","А Мојсије рече: Не ваља тако; јер бисмо принели на жртву Господу Богу свом што је нечисто Мисирцима; а кад бисмо принели на жртву што је нечисто Мисирцима на очи њихове, не би ли нас побили камењем? ");
INSERT INTO srp1868_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Три дана хода треба да идемо у пустињу да принесемо жртву Господу Богу свом, као што нам је казао. ");
INSERT INTO srp1868_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","А Фараон рече: Пустићу вас да принесете жртву Господу Богу свом у пустињи; али да не идете даље; па се молите за ме. ");
INSERT INTO srp1868_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","А Мојсије рече: Ево ја идем од тебе, и молићу се Господу да отиду бубине од Фараона и од слуга његових и од народа његовог сутра; али немој опет да превариш, и да не пустиш народ да принесе жртву Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","И отиде Мојсије од Фараона, и помоли се Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","И учини Господ по речи Мојсијевој, те отидоше бубине од Фараона и од слуга његових и од народа његовог; не оста ни једна. ");
INSERT INTO srp1868_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Али опет отврдну срце Фараоново, и не пусти народ. ");
INSERT INTO srp1868_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Тада рече Господ Мојсију: Иди к Фараону, и реци му: Овако вели Господ Бог јеврејски: Пусти народ мој да ми послужи; ");
INSERT INTO srp1868_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ако ли их не пустиш него их још станеш задржавати, ");
INSERT INTO srp1868_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ево, рука Господња доћи ће на стоку твоју у пољу, на коње, на магарце, на камиле, на волове и на овце, с помором врло великим. ");
INSERT INTO srp1868_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","А одвојиће Господ стоку израиљску од стоке мисирске; те од свега што је синова Израиљевих неће погинути ништа. ");
INSERT INTO srp1868_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","И поставио је Господ рок рекавши: Сутра ће то учинити на земљи Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","И Господ учини то сутрадан, и сва стока мисирска угину; а од стоке синова Израиљевих не угину ниједно. ");
INSERT INTO srp1868_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","И посла Фараон да виде, и гле, од стоке израиљске не угину ниједно; ипак отврдну срце Фараону, и не пусти народ. ");
INSERT INTO srp1868_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Тада рече Господ Мојсију и Арону: Узмите пепела из пећи пуне прегршти, и Мојсије нека га баци у небо пред Фараоном; ");
INSERT INTO srp1868_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","и постаће прах по свој земљи мисирској, а од њега ће постати красте пуне гноја и на људима и на стоци по свој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","И узеше пепела из пећи, и стадоше пред Фараона, и баци га Мојсије у небо, и посташе красте пуне гноја по људима и по стоци. ");
INSERT INTO srp1868_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","И врачари не могоше стајати пред Мојсијем од краста; јер беху красте и на врачарима и на свим Мисирцима. ");
INSERT INTO srp1868_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","И Господ учини те отврдну срце Фараоново, и не послуша их, као што беше казао Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","После рече Господ Мојсију: Устани рано и изађи пред Фараона, и реци му: Овако вели Господ Бог јеврејски: Пусти народ мој да ми послужи. ");
INSERT INTO srp1868_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Јер ћу сада пустити сва зла своја на срце твоје и на слуге твоје и на народ твој, да знаш да нико није као ја на целој земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Јер сада кад пружих руку своју, могах и тебе и народ твој ударити помором, па те не би више било на земљи; ");
INSERT INTO srp1868_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","али те оставих да покажем на теби силу своју, и да се приповеда име моје по свој земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","И ти се још подижеш на мој народ, и нећеш да га пустиш? ");
INSERT INTO srp1868_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ево, сутра ћу у ово доба пустити град врло велик, каквог није било у Мисиру откако је постао па досада. ");
INSERT INTO srp1868_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Зато сада пошљи, те скупи стоку своју и шта год имаш у пољу, јер ће пасти град на све људе и на стоку што се затече у пољу и не буде скупљено у кућу, и изгинуће. ");
INSERT INTO srp1868_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Који се год између слуга Фараонових побоја речи Господње, он брже скупи слуге своје и стоку своју у кућу; ");
INSERT INTO srp1868_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","а који не мараше за реч Господњу, он остави слуге своје и стоку своју у пољу. ");
INSERT INTO srp1868_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","И Господ рече Мојсију: Пружи руку своју к небу, нека удари град по свој земљи мисирској, на људе и на стоку и на све биље по пољу у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","И Мојсије пружи штап свој к небу, и Господ пусти громове и град, да огањ скакаше на земљу. И тако Господ учини, те паде град на земљу мисирску. ");
INSERT INTO srp1868_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","А беше град и огањ смешан с градом силан веома, каквог не беше у свој земљи мисирској откако је људи у њој. ");
INSERT INTO srp1868_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","И поби град по свој земљи мисирској шта год беше у пољу од човека до живинчета; и све биље у пољу потре град, и сва дрвета у пољу поломи. ");
INSERT INTO srp1868_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Само у земљи гесемској, где беху синови Израиљеви, не беше града. ");
INSERT INTO srp1868_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Тада посла Фараон, те дозва Мојсија и Арона, и рече им: Сада згреших; Господ је праведан, а ја и мој народ јесмо безбожници. ");
INSERT INTO srp1868_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Молите се Господу, јер је доста, нека престану громови Божји и град, па ћу вас пустити, и више вас неће нико устављати. ");
INSERT INTO srp1868_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","А Мојсије му рече: Кад изађем иза града, раширићу руке своје ка Господу, а громови ће престати и града неће више бити, да знаш да је Господња земља. ");
INSERT INTO srp1868_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","А ти и слуге твоје знам да се још нећете бојати Господа Бога. ");
INSERT INTO srp1868_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","И пропаде лан и јечам, јер јечам беше класао, а лан се главичио. ");
INSERT INTO srp1868_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","А пшеница и крупник не пропаде, јер беше позно жито. ");
INSERT INTO srp1868_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","И Мојсије отишавши од Фараона иза града рашири руке своје ка Господу, и престаше громови и град, и дажд не падаше на земљу. ");
INSERT INTO srp1868_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Али Фараон видевши где преста дажд и град и громови, стаде опет грешити, и срце му отврдну и њему и слугама његовим. ");
INSERT INTO srp1868_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Отврдну срце Фараону, те не пусти синове Израиљеве, као што беше казао Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","А Господ рече Мојсију: Иди к Фараону, јер сам ја учинио да отврдне срце његово и срце слуга његових, да учиним ове знаке своје међу њима, ");
INSERT INTO srp1868_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","и да приповедаш синовима својим и унуцима својим шта учиних у Мисиру и какве знаке своје показах на њима, да бисте знали да сам ја Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","И отиде Мојсије и Арон к Фараону, и рекоше му: Овако вели Господ Бог јеврејски: Докле ћеш се противити да се не понизиш преда мном? Пусти народ мој да ми послужи. ");
INSERT INTO srp1868_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Јер ако нећеш пустити народ мој, ево сутра ћу нанети скакавце на земљу твоју; ");
INSERT INTO srp1868_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","и покриће сву земљу да се неће видети земља, и појешће остатак што се сачувао, који вам је остао иза града, и појешће сва дрвета што вам расту у пољу. ");
INSERT INTO srp1868_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","И напуниће их се куће твоје и куће свих слуга твојих и куће свих Мисираца, шта нису видели оци твоји ни оци отаца твојих, откако су постали на земљи до данас. И окренувши се отиде од Фараона. ");
INSERT INTO srp1868_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","А слуге рекоше Фараону: Докле ће нас тај мучити? Пусти их нека послуже Господу Богу свом. Зар још не видиш где пропаде Мисир? ");
INSERT INTO srp1868_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","И дозваше опет Мојсија и Арона пред Фараона, и рече им: Идите, послужите Господу Богу свом. А који су што ће ићи? ");
INSERT INTO srp1868_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","А Мојсије рече: С децом својом и са старцима својим ићи ћемо, са синовима својим и са кћерима својим, са стоком својом ситном и крупном ићи ћемо, јер имамо празник Господњи. ");
INSERT INTO srp1868_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","А он им рече: Тако био Господ с вама, како ћу вас ја пустити с децом вашом! Видите да зло мислите. ");
INSERT INTO srp1868_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Неће бити тако; него ви људи идите и послужите Господу, јер то иштете. И отера их од себе Фараон. ");
INSERT INTO srp1868_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Тада рече Господ Мојсију: Пружи руку своју на земљу мисирску, да дођу скакавци на земљу мисирску и поједу све биље по земљи, шта год оста иза града. ");
INSERT INTO srp1868_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","И пружи Мојсије штап свој на земљу мисирску, и Господ наведе устоку на земљу, те дува цели дан и целу ноћ; а кад свану, донесе устока скакавце. ");
INSERT INTO srp1868_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","И дођоше скакавци на сву земљу мисирску, и попадаше по свим крајевима мисирским силни веома, каквих пре никада није било нити ће кад бити онаквих. ");
INSERT INTO srp1868_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","И покрише сву земљу, да се земља не виђаше, и поједоше сву траву на земљи и сав род на дрветима, што оста иза града, и не оста ништа зелено од дрвета и од биља пољског у свој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Тада Фараон брже дозва Мојсија и Арона, и рече: Згреших Господу Богу вашем и вама. ");
INSERT INTO srp1868_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Али ми још сада само опрости грех мој, и молите се Господу Богу свом да уклони од мене само ову смрт. ");
INSERT INTO srp1868_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","И отиде Мојсије од Фараона, и помоли се Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","И окрену Господ ветар од запада врло јак, који узе скакавце и баци их у Црвено море, и не оста ниједан скакавац у целој земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Али Господ учини те отврдну срце Фараону, и не пусти синове Израиљеве. ");
INSERT INTO srp1868_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","И рече Господ Мојсију: Пружи руку своју к небу, и биће тама по земљи мисирској таква да ће је пипати. ");
INSERT INTO srp1868_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","И Мојсије пружи руку своју к небу, и поста густа тама по свој земљи мисирској за три дана. ");
INSERT INTO srp1868_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Не виђаху један другог, и нико се не маче с места где беше за три дана; али се код свих синова Израиљевих видело по становима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Тада Фараон дозва Мојсија, и рече: Идите, послужите Господу; само стока ваша ситна и крупна нека остане, а деца ваша нека иду с вама. ");
INSERT INTO srp1868_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","А Мојсије рече: Треба да нам даш и шта ћемо принети и сажећи на жртву Господу Богу свом; ");
INSERT INTO srp1868_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","зато и стока наша нек иде с нама, да не остане ни папка, јер између ње треба да узмемо чим ћемо послужити Господу Богу свом, а не знамо којим ћемо послужити Господу докле не дођемо онамо. ");
INSERT INTO srp1868_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Али Господ учини те отврдну срце Фараону, и не хте их пустити. ");
INSERT INTO srp1868_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","И рече му Фараон: Иди од мене, и чувај се да ми више не дођеш на очи, јер ако ми дођеш на очи, погинућеш. ");
INSERT INTO srp1868_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","А Мојсије рече: Право си казао; нећу ти више доћи на очи. ");
INSERT INTO srp1868_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","А Господ рече Мојсију: Још ћу једно зло пустити на Фараона и на Мисир, па ће вас онда пустити; пустиће сасвим, и још ће вас терати. ");
INSERT INTO srp1868_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","А сада кажи народу нека сваки човек иште у суседа свог и свака жена у суседе своје накита сребрних и накита златних. ");
INSERT INTO srp1868_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","И Господ учини те народ нађе љубав у Мисираца; и сам Мојсије беше врло велик човек у земљи мисирској код слуга Фараонових и код народа. ");
INSERT INTO srp1868_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","И рече Мојсије: Овако вели Господ: Око поноћи проћи ћу кроз Мисир, ");
INSERT INTO srp1868_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","и помреће сви првенци у земљи мисирској, од првенца Фараоновог, који хтеде седети на престолу његовом, до првенца слушкиње за жрвњем, и од стоке шта је год првенац. ");
INSERT INTO srp1868_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","И биће вика велика по свој земљи мисирској, какве још није било нити ће је кад бити. ");
INSERT INTO srp1868_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","А код синова Израиљевих нигде неће ни пас језиком својим маћи ни међу људима ни међу стоком, да знате да је Господ учинио разлику између Израиљаца и Мисираца. ");
INSERT INTO srp1868_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","И доћи ће све те слуге твоје к мени, и поклониће ми се говорећи: Иди, и ти и сав народ који је пристао за тобом. И онда ћу изаћи. И отиде Мојсије од Фараона с великим гневом. ");
INSERT INTO srp1868_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","А Господ рече Мојсију: Неће вас послушати Фараон, да бих умножио чудеса своја у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","И Мојсије и Арон учинише сва ова чудеса пред Фараоном, а Господ учини те отврдну срце Фараону, и не пусти синове Израиљеве из земље своје. ");
INSERT INTO srp1868_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","И рече Господ Мојсију и Арону у земљи мисирској говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Овај месец да вам је почетак месецима, да вам је први месец у години. ");
INSERT INTO srp1868_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Кажите свему збору Израиљевом и реците: Десетог дана овог месеца сваки нека узме јагње или јаре, по породицама, по једно на дом; ");
INSERT INTO srp1868_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ако ли је дом мали за јагње или јаре, нека узме к себи суседа, који му је најближи, с онолико душа колико треба да могу појести јагње или јаре. ");
INSERT INTO srp1868_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","А јагње или јаре да вам буде здраво, мушко, од године; између оваца или између коза узмите. ");
INSERT INTO srp1868_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","И чувајте га до четрнаестог дана овог месеца, а тада савколики збор Израиљев нека га закоље увече. ");
INSERT INTO srp1868_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","И нека узму крви од њега и покропе оба довратка и горњи праг на кућама у којима ће га јести. ");
INSERT INTO srp1868_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","И нека једу месо исте ноћи, на ватри печено, с хлебом пресним и са зељем горким нека једу. ");
INSERT INTO srp1868_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Немојте јести сирово ни у води кувано, него на ватри печено, с главом и с ногама и с дробом. ");
INSERT INTO srp1868_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","И ништа немојте оставити до јутра; ако ли би шта остало до јутра, спалите на ватри. ");
INSERT INTO srp1868_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","А овако једите: опасани, обућа да вам је на ногу и штап у руци, и једите хитно, јер је пролазак Господњи. ");
INSERT INTO srp1868_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Јер ћу проћи по земљи мисирској ту ноћ, и побићу све првенце у земљи мисирској од човека до живинчета, и судићу свим боговима мисирским, ја Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","А крв она биће вам знак на кућама, у којима ћете бити; и кад видим крв, проћи ћу вас, те неће бити међу вама помора, кад станем убијати по земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","И тај ће вам дан бити за спомен, и празноваћете га Господу од колена до колена; празнујте га законом вечним. ");
INSERT INTO srp1868_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Седам дана једите хлебове пресне, и првог дана уклоните квасац из кућа својих; јер ко би год јео шта с квасцем од првог дана до седмог, истребиће се она душа из Израиља. ");
INSERT INTO srp1868_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Први дан биће свети сабор; тако и седми дан имаћете свети сабор; никакав посао да се не ради у те дане, осим шта треба за јело свакој души, то ћете само готовити. ");
INSERT INTO srp1868_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","И држите дан пресних хлебова, јер у тај дан изведох војске ваше из земље мисирске; држите тај дан од колена до колена законом вечним. ");
INSERT INTO srp1868_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Првог месеца четрнаести дан увече почните јести пресне хлебове па до двадесет првог дана истог месеца увече. ");
INSERT INTO srp1868_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","За седам дана да се не нађе квасца у кућама вашим; јер ко би год јео шта с квасцем, истребиће се она душа из збора Израиљевог, био дошљак или рођен у земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ништа с квасцем немојте јести, него једите хлеб пресан по свим становима својим. ");
INSERT INTO srp1868_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","И сазва Мојсије све старешине израиљске, и рече им: Изберите и узмите себи јагње или јаре по породицама својим, и закољите пасху. ");
INSERT INTO srp1868_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","И узмите киту исопа и замочите је у крв, која ће бити у здели, и покропите горњи праг и оба довратка крвљу, која ће бити у здели, и ниједан од вас да не излази на врата кућна до јутра. ");
INSERT INTO srp1868_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Јер ће изаћи Господ да бије Мисир, па кад види крв на горњем прагу и на оба довратка, проћи ће Господ мимо она врата, и неће дати крвнику да уђе у куће ваше да убија. ");
INSERT INTO srp1868_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","И држите ово као закон теби и синовима твојим довека. ");
INSERT INTO srp1868_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","И кад дођете у земљу коју ће вам дати Господ, као што је казао, држите ову службу. ");
INSERT INTO srp1868_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","И кад вам кажу синови ваши: Каква вам је то служба? ");
INSERT INTO srp1868_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Реците: Ово је жртва за пролазак Господњи, кад прође куће синова Израиљевих у Мисиру убијајући Мисирце, а домове наше сачува. Тада народ сави главу и поклони се. ");
INSERT INTO srp1868_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","И отидоше и учинише синови Израиљеви, како заповеди Господ преко Мојсија и Арона, тако учинише. ");
INSERT INTO srp1868_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","А око поноћи поби Господ све првенце у земљи мисирској од првенца Фараоновог који хтеде седети на престолу његовом до првенца сужња у тамници, и шта год беше првенац од стоке. ");
INSERT INTO srp1868_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Тада уста Фараон оне ноћи, он и све слуге његове и сви Мисирци, и би вика велика у Мисиру, јер не беше куће у којој не би мртваца. ");
INSERT INTO srp1868_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","И дозва Мојсија и Арона по ноћи и рече: Устајте, идите из народа мог и ви и синови Израиљеви, и отидите, послужите Господу, као што говористе. ");
INSERT INTO srp1868_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Узмите и овце своје и говеда своја, као што говористе, и идите, па и мене благословите. ");
INSERT INTO srp1868_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","И Мисирци наваљиваху на народ да брже иду из земље, јер говораху: Изгибосмо сви. ");
INSERT INTO srp1868_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","И народ узе тесто своје још неускисло, умотавши га у хаљине своје, на рамена своја. ");
INSERT INTO srp1868_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","И учинише синови Израиљеви по заповести Мојсијевој, и заискаше у Мисираца накита сребрних и накита златних и хаљина. ");
INSERT INTO srp1868_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","И Господ учини, те народ нађе љубав у Мисираца, те им дадоше; тако опленише Мисирце. ");
INSERT INTO srp1868_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","И отидоше синови Израиљеви из Рамесе у Сохот, око шест стотина хиљада пешака, самих људи осим деце. ");
INSERT INTO srp1868_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","И других људи много отиде с њима, и стоке ситне и крупне врло много. ");
INSERT INTO srp1868_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","И од теста које изнесоше из Мисира испекоше погаче пресне, јер не беше ускисло кад их потераше Мисирци, те не могаше оклевати, нити спремише себи брашњенице. ");
INSERT INTO srp1868_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","А бавише се синови Израиљеви у Мисиру четири стотине и тридесет година. ");
INSERT INTO srp1868_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","И кад се наврши четири стотине и тридесет година, у исти дан изађоше све војске Господње из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Та се ноћ светкује Господу, у коју их изведе из Мисира; то је ноћ Господња, коју треба да светкују синови Израиљеви од колена на колено. ");
INSERT INTO srp1868_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","И рече Господ Мојсију и Арону: Ово нека буде закон за пасху: ниједан туђин да је не једе; ");
INSERT INTO srp1868_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","а сваки слуга ваш купљен за новце, кад га обрежете, онда нека је једе. ");
INSERT INTO srp1868_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Дошљак или најамник да је не једе. ");
INSERT INTO srp1868_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","У истој кући да се једе, да не изнесете меса од ње из куће, и кости да јој не преломите. ");
INSERT INTO srp1868_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Сав збор Израиљев нека чини тако. ");
INSERT INTO srp1868_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ако би код тебе седео туђин и хтео би светковати пасху Господњу, нека му се обрежу све мушкиње, па онда нека приступи да је светкује, и нека буде као рођен у земљи; а нико необрезан да је не једе. ");
INSERT INTO srp1868_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Закон један да је и рођеном у земљи и дошљаку који седи међу вама. ");
INSERT INTO srp1868_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","И учинише сви синови Израиљеви како заповеди Господ Мојсију и Арону, тако учинише. ");
INSERT INTO srp1868_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","И тај дан изведе Господ синове Израиљеве из земље мисирске у четама њиховим. ");
INSERT INTO srp1868_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Посвети ми сваког првенца, шта год отвара материцу у синова Израиљевих, и од људи и од стоке; јер је моје. ");
INSERT INTO srp1868_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","И Мојсије рече народу: Памтите овај дан, у који изиђосте из Мисира, из дома ропског, јер вас руком крепком изведе Господ оданде; нека се дакле не једе ништа с квасцем. ");
INSERT INTO srp1868_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Данас излазите, месеца Авива; ");
INSERT INTO srp1868_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","па кад те Господ уведе у земљу хананејску и хетејску и аморејску и јевејску и јевусејску, за коју се заклео оцима твојим да ће ти је дати, земљу у којој тече млеко и мед, тада да служиш службу ову овог месеца; ");
INSERT INTO srp1868_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","седам дана једи хлебове пресне, а седми дан нека је празник Господњи. ");
INSERT INTO srp1868_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Хлебови пресни да се једу седам дана, и да се не види у тебе ништа с квасцем, нити да се види у тебе квасац у целом крају твом. ");
INSERT INTO srp1868_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","И казаћеш сину свом у тај дан говорећи: Ово је за оно што ми је учинио Господ кад сам излазио из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","И нека ти буде као знак на руци твојој и као спомен пред очима твојим, да ти закон Господњи буде у устима; јер те је руком крепком извео Господ из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Зато врши закон овај на време, од године до године. ");
INSERT INTO srp1868_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","И кад те уведе Господ у земљу хананејску, као што се заклео теби и твојим оцима, и да ти је, ");
INSERT INTO srp1868_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","одвајаћеш Господу шта год отвара материцу, и од стоке твоје шта год отвара материцу, шта је мушко, да буде Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","А свако магаре првенче откупи јагњетом или јаретом; ако ли га не би откупио, сломи му врат. Али сваког првенца човечјег између синова својих откупи. ");
INSERT INTO srp1868_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","А кад те запита син твој унапред говорећи: Шта је то? Реци му: Руком крепком изведе нас Господ из Мисира, из дома ропског. ");
INSERT INTO srp1868_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Јер кад отврдну Фараон, те нас не хте пустити, поби Господ све првенце у земљи мисирској од првенца човечјег до првенца од стоке; зато приносим Господу све мушко што отвара материцу, а сваког првенца синова својих откупљујем. ");
INSERT INTO srp1868_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","И то нека ти је као знак на руци и као почеоник међу очима твојим, да нас је руком крепком извео Господ из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","А кад Фараон пусти народ, не одведе их Бог путем к земљи филистејској, ако и беше краћи, јер Бог рече: Да се не покаје народ кад види рат, и не врати се у Мисир. ");
INSERT INTO srp1868_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Него Бог заведе народ путем преко пустиње на Црвеном Мору. А војничким редом изиђоше синови Израиљеви из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","И Мојсије узе кости Јосифове са собом; јер беше заклео синове Израиљеве рекавши: Заиста ће вас походити Бог, а тада изнесите кости моје одавде са собом. ");
INSERT INTO srp1868_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Тако отишавши из Сохота стадоше у логор у Етаму, накрај пустиње. ");
INSERT INTO srp1868_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","А Господ иђаше пред њима дању у ступу од облака водећи их путем, а ноћу у ступу од огња светлећи им, да би путовали дању и ноћу. ");
INSERT INTO srp1868_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","И не уклањаше испред народа ступ од облака дању ни ступ од огња ноћу. ");
INSERT INTO srp1868_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Кажи синовима Израиљевим нека савију и стану у логор пред Пи-Аирот између Мигдола и мора према Вел-Сефону; према њему нека стану у логор покрај мора. ");
INSERT INTO srp1868_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Јер ће Фараон рећи за синове Израиљеве: Зашли су у земљу, затворила их је пустиња. ");
INSERT INTO srp1868_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","И учинићу да отврдне срце Фараону, те ће поћи у потеру за вама, и ја ћу се прославити на њему и на свој војсци његовој, и Мисирци ће познати да сам ја Господ. И учинише тако. ");
INSERT INTO srp1868_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","А кад би јављено цару мисирском да је побегао народ, промени се срце Фараоново и слуга његових према народу, те рекоше: Шта учинисмо, те пустисмо Израиља да нам не служи? ");
INSERT INTO srp1868_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","И упреже у кола своја, и узе народ свој са собом. ");
INSERT INTO srp1868_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","И узе шест стотина кола изабраних и шта још беше кола мисирских, и над свима војводе. ");
INSERT INTO srp1868_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","И Господ учини те отврдну срце Фараону цару мисирском, и пође у потеру за синовима Израиљевим, кад синови Израиљеви отидоше под руком високом. ");
INSERT INTO srp1868_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","И теравши их Мисирци стигоше их, сва кола Фараонова, коњици његови и војска његова, кад беху у логору на мору код Пи-Аирота према Вел-Сефону. ");
INSERT INTO srp1868_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","И кад се приближи Фараон, подигоше синови Израиљеви очи своје а то Мисирци иду за њима, и уплашише се врло, и повикаше синови Израиљеви ка Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","И рекоше Мојсију: Зар не беше гробова у Мисиру, него нас доведе да изгинемо у пустињи? Шта учини, те нас изведе из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Нисмо ли ти говорили у Мисиру и рекли: Прођи нас се, нека служимо Мисирцима? Јер би нам боље било служити Мисирцима него изгинути у пустињи. ");
INSERT INTO srp1868_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","А Мојсије рече народу: Не бојте се, станите па гледајте како ће вас Господ избавити данас; јер Мисирце које сте видели данас, нећете их никада више видети до века. ");
INSERT INTO srp1868_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Господ ће се бити за вас, а ви ћете ћутати. ");
INSERT INTO srp1868_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","А Господ рече Мојсију: Што вичеш к мени? Кажи синовима Израиљевим нека иду. ");
INSERT INTO srp1868_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","А ти дигни штап свој и пружи руку своју на море, и расцепи га, па нека иду синови Израиљеви посред мора сувим. ");
INSERT INTO srp1868_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","И гле, ја ћу учинити да отврдне срце Мисирцима, те ће поћи за њима; и прославићу се на Фараону и на свој војсци његовој, на колима његовим и на коњицима његовим. ");
INSERT INTO srp1868_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","И Мисирци ће познати да сам ја Господ, кад се прославим на Фараону, на колима његовим и на коњицима његовим. ");
INSERT INTO srp1868_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","И подиже се анђео Господњи, који иђаше пред војском израиљском, и отиде им за леђа; и подиже се ступ од облака испред њих, и стаде им за леђа. ");
INSERT INTO srp1868_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","И дошав међу војску мисирску и војску израиљску беше оним облак мрачан а овим светљаше по ноћи, те не приступише једни другима целу ноћ. ");
INSERT INTO srp1868_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","И пружи Мојсије руку своју на море, а Господ узби море ветром источним, који јако дуваше целу ноћ, и осуши море, и вода се раступи. ");
INSERT INTO srp1868_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","И пођоше синови Израиљеви посред мора сувим, и вода им стајаше као зид с десне стране и с леве стране. ");
INSERT INTO srp1868_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","И Мисирци терајући их пођоше за њима посред мора, сви коњи Фараонови, кола и коњици његови. ");
INSERT INTO srp1868_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","А у стражу јутарњу погледа Господ на војску мисирску из ступа од огња и облака, и смете војску мисирску. ");
INSERT INTO srp1868_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","И побаца точкове колима њиховим, те их једва вуцијаху. Тада рекоше Мисирци: Бежимо од Израиља, јер се Господ бије за њих с Мисирцима. ");
INSERT INTO srp1868_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","А Господ рече Мојсију: Пружи руку своју на море, нека се врати вода на Мисирце, на кола њихова и на коњике њихове. ");
INSERT INTO srp1868_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","И Мојсије пружи руку своју на море, и дође опет море на силу своју пред зору, а Мисирци нагоше бежати према мору; и Господ баци Мисирце усред мора. ");
INSERT INTO srp1868_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","А вративши се вода потопи кола и коњике са свом војском Фараоновом, што их год беше пошло за њима у море, и не оста од њих ниједан. ");
INSERT INTO srp1868_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","И синови Израиљеви иђаху посред мора сувим; и стајаше им вода као зид с десне стране и с леве стране. ");
INSERT INTO srp1868_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","И избави Господ Израиља у онај дан из руку мисирских; и виде Израиљ мртве Мисирце на брегу морском. ");
INSERT INTO srp1868_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","И виде Израиљ силу велику, коју показа Господ на Мисирцима, и народ се побоја Господа, и верова Господу и Мојсију слузи Његовом. ");
INSERT INTO srp1868_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Тада запева Мојсије и синови Израиљеви ову песму Господу, и рекоше овако: Певаћу Господу, јер се славно прослави; коња и коњика врже у море. ");
INSERT INTO srp1868_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Сила је моја и песма моја Господ, који ме избави; Он је Бог мој, и славићу Га; Бога оца мог, и узвишаваћу Га. ");
INSERT INTO srp1868_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Господ је велик ратник; име му је Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Кола Фараонова и војску његову врже у море; избране војводе његове утопише се у црвеном мору. ");
INSERT INTO srp1868_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Бездани их покрише; падоше у дубину као камен. ");
INSERT INTO srp1868_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Десница Твоја, Господе, прослави се у сили; десница Твоја, Господе, сатре непријатеља. ");
INSERT INTO srp1868_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","И мноштвом величанства свог оборио си оне који усташе на те; пустио си гнев свој, и прождре их као сламу. ");
INSERT INTO srp1868_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Од даха ноздрва Твојих сабра се вода; стаде у гомилу вода која тече; стинуше се вали усред мора. ");
INSERT INTO srp1868_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Непријатељ рече: Тераћу, стигнућу, делићу плен; наситиће их се душа моја, извући ћу мач свој, истребиће их рука моја. ");
INSERT INTO srp1868_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ти дуну ветром својим, и море их покри, и утонуше као олово у дубокој води. ");
INSERT INTO srp1868_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ко је као Ти међу силнима. Господе? Ко је као Ти славан у светости, страшан у хвали, и да чини чудеса? ");
INSERT INTO srp1868_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ти пружи десницу своју, и прождре их земља. ");
INSERT INTO srp1868_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Водиш милошћу својом народ, који си искупио, водиш крепошћу својом у стан светости своје. ");
INSERT INTO srp1868_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Чуће народи, и задрхтаће; мука ће спопасти оне који живе у земљи филистејској. ");
INSERT INTO srp1868_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Тада ће се препасти старешине едомске, јунаке моавске спопашће дрхат, уплашиће се сви који живе у хананској. ");
INSERT INTO srp1868_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Спопашће их страх и трепет; од величине руке Твоје замукнуће као камен, докле не прође народ Твој, Господе, докле не прође народ који си задобио. ");
INSERT INTO srp1868_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Одвешћеш их и посадићеш их на гори наследства свог, на месту које си себи за стан спремио, Господе, у светињи, Господе, коју су Твоје руке утврдиле. ");
INSERT INTO srp1868_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Господ ће царовати довека. ");
INSERT INTO srp1868_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Јер уђоше коњи Фараонови с колима његовим и с коњицима његовим у море, и Господ поврати на њих воду морску; а синови Израиљеви пређоше сувим посред мора. ");
INSERT INTO srp1868_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","И Марија пророчица, сестра Аронова, узе бубањ у руку своју; а за њом изиђоше све жене с бубњевима и свиралама. ");
INSERT INTO srp1868_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","И отпеваше им Марија: Певајте Господу, јер се славно прослави; коња и коњика врже у море. ");
INSERT INTO srp1868_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Потом крену Мојсије синове Израиљеве од Мора Црвеног, и пођоше у пустињу Сур; и три дана ишавши по пустињи не нађоше воду. ");
INSERT INTO srp1868_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Оданде дођоше у Меру, али не могоше пити воду у Мери, јер беше горка; отуда се прозва место Мера. ");
INSERT INTO srp1868_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Тада стаде народ викати на Мојсија говорећи: Шта ћемо пити? ");
INSERT INTO srp1868_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","И Мојсије завапи ка Господу, а Господ му показа дрво, те га метну у воду, и вода поста слатка. Онде му даде уредбу и закон, и онде га окуша. ");
INSERT INTO srp1868_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","И рече: Ако добро узаслушаш глас Господа Бога свог, и учиниш што је право у очима Његовим, и ако пригнеш ухо к заповестима Његовим и сачуваш све уредбе Његове, ниједну болест коју сам пустио на Мисир нећу пустити на тебе; јер сам ја Господ, лекар твој. ");
INSERT INTO srp1868_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","И дођоше у Елим, где беше дванаест извора и седамдесет палми; и онде стадоше у логор код воде. ");
INSERT INTO srp1868_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Од Елима се подигоше, и сав збор синова Израиљевих дође у пустињу Син, која је између Елима и Синаја, петнаестог дана другог месеца пошто изиђоше из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","И стаде викати сав збор синова Израиљевих на Мојсија и на Арона у пустињи, ");
INSERT INTO srp1868_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","и рекоше им синови Израиљеви: Камо да смо помрли од руке Господње у земљи мисирској, кад седасмо код лонаца с месом и јеђасмо хлеба изобила! Јер нас изведосте у ову пустињу да поморите сав овај збор глађу. ");
INSERT INTO srp1868_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","А Господ рече Мојсију: Ево учинићу да вам дажди из неба хлеб, а народ нека излази и купи сваки дан колико треба на дан, да га окушам хоће ли ходити по мом закону или неће. ");
INSERT INTO srp1868_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","А шестог дана нека зготове шта донесу, а нека буде двојином онолико колико накупе сваки дан. ");
INSERT INTO srp1868_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","И рече Мојсије и Арон свим синовима Израиљевим: Довече ћете познати да вас је Господ извео из земље мисирске; ");
INSERT INTO srp1868_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","а сутра ћете видети славу Господњу; јер је чуо вику вашу на Господа. Јер шта смо ми да вичете на нас? ");
INSERT INTO srp1868_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","И рече Мојсије: Довече ће вам дати Господ меса да једете а ујутру хлеба да се наситите; јер је чуо Господ вику вашу, којом вичете на Њ. Јер шта смо ми? Није на нас ваша вика него на Господа. ");
INSERT INTO srp1868_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","И рече Мојсије Арону: Кажи свему збору синова Израиљевих: Приступите пред Господа, јер је чуо вику вашу. ");
INSERT INTO srp1868_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","И кад рече Арон свему збору синова Израиљевих, погледаше у пустињу, и гле, слава Господња показа се у облаку. ");
INSERT INTO srp1868_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","И Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Чуо сам вику синова Израиљевих. Кажи им и реци: Довече ћете јести меса, а сутра ћете се наситити хлеба, и познаћете да сам ја Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","И увече долетеше препелице и прекрилише логор, а ујутру паде роса око логора; ");
INSERT INTO srp1868_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","а кад се диже роса, а то по пустињи нешто ситно округло, ситно као слана по земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","И кад виде синови Израиљеви, говораху један другом: Шта је ово? Јер не знаху шта беше. А Мојсије им рече: То је хлеб што вам даде Господ да једете. ");
INSERT INTO srp1868_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","То је за шта заповеди Господ: купите га сваки дан колико коме треба за јело, по гомор на главу, по броју душа ваших, сваки нека узме за оне који су му у шатору. ");
INSERT INTO srp1868_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","И учинише тако синови Израиљеви; и накупише који више који мање. ");
INSERT INTO srp1868_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Па мерише на гомор, и не дође више оном који накупи много, нити мање оном који накупи мало, него сваки накупи колико му је требало да једе. ");
INSERT INTO srp1868_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","И рече им Мојсије: Нико да не оставља од тога за сутра. ");
INSERT INTO srp1868_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Али не послушаше Мојсија, него неки оставише од тога за сутра, те се уцрва и усмрде. И расрди се Мојсије на њих. ");
INSERT INTO srp1868_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Тако га купљаху свако јутро, сваки колико му требаше за јело; а кад сунце огреваше, тада се растапаше. ");
INSERT INTO srp1868_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","А у шести дан накупише хлеба двојином, по два гомора на сваког; и дођоше све старешине од збора, и јавише Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","А он им рече: Ово каза Господ: Сутра је субота, одмор свет Господу; шта ћете пећи, пеците, и шта ћете кувати, кувајте данас; а шта претече, оставите и чувајте за сутра. ");
INSERT INTO srp1868_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","И оставише за сутра, као што заповеди Мојсије, и не усмрде се нити беше црва у њему. ");
INSERT INTO srp1868_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","И рече Мојсије: Једите то данас, јер је данас субота Господња, данас нећете наћи у пољу. ");
INSERT INTO srp1868_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Шест ћете дана купити, а седми је дан субота, тада га неће бити. ");
INSERT INTO srp1868_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","И у седми дан изиђоше неки од народа да купе, али не нађоше. ");
INSERT INTO srp1868_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","А Господ рече Мојсију: Докле ћете се противити заповестима мојим и законима мојим? ");
INSERT INTO srp1868_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Видите, Господ вам је дао суботу, зато вам даје шестог дана хлеба на два дана. Стојте сваки на свом месту, и нека не одлази нико са свог места у седми дан. ");
INSERT INTO srp1868_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","И почину народ у седми дан. ");
INSERT INTO srp1868_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","И дом Израиљев прозва тај хлеб мана; а беше као семе коријандрово, бео, и на језику као медени колачи. ");
INSERT INTO srp1868_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","И рече Мојсије: Ово је заповедио Господ: напуни гомор тога, нека се чува од колена до колена вашег, да виде хлеб, којим сам вас хранио у пустињи кад вас изведох из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","И рече Мојсије Арону: Узми крчаг и наспи пун гомор мане, и метни пред Господа да се чува од колена до колена вашег. ");
INSERT INTO srp1868_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","И остави га Арон пред сведочанством да се чува, као што заповеди Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","А синови Израиљеви једоше ману четрдесет година док не дођоше у земљу у којој ће живети; једоше ману док не дођоше на међу земље хананске. ");
INSERT INTO srp1868_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","А гомор је десетина ефе. ");
INSERT INTO srp1868_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","И подиже се из пустиње Сина сав збор синова Израиљевих путем својим по заповести Господњој, и стадоше у логор у Рафидину; а онде не беше воде да народ пије. ");
INSERT INTO srp1868_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","И народ се свађаше с Мојсијем говорећи: Дај нам воде да пијемо. А он им рече: Што се свађате са мном? Што кушате Господа? ");
INSERT INTO srp1868_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Али народ беше онде жедан воде, те викаше народ на Мојсија, и говораше: Зашто си нас извео из Мисира да нас и синове наше и стоку нашу помориш жеђу? ");
INSERT INTO srp1868_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","А Мојсије завапи ка Господу говорећи: Шта ћу чинити с овим народом? Још мало па ће ме засути камењем. ");
INSERT INTO srp1868_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","А Господ рече Мојсију: Прођи пред народ, и узми са собом старешине израиљске, и штап свој којим си ударио воду узми у руку своју, и иди. ");
INSERT INTO srp1868_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","А ја ћу стајати пред тобом онде на стени на Хориву; а ти удари у стену, и потећи ће из ње вода да пије народ. И учини Мојсије тако пред старешинама израиљским. ");
INSERT INTO srp1868_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","А место оно прозва Маса и Мерива зато што се свађаше синови Израиљеви и што кушаше Господа говорећи: Је ли Господ међу нама или није? ");
INSERT INTO srp1868_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Али дође Амалик да се бије с Израиљем у Рафидину. ");
INSERT INTO srp1868_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","А Мојсије рече Исусу: Избери нам људе, те изађи и биј се с Амаликом; а ја ћу сутра стати на врх брда са штапом Божјим у руци. ");
INSERT INTO srp1868_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","И учини Исус како му рече Мојсије, и поби се с Амаликом; а Мојсије и Арон и Ор изађоше на врх брда. ");
INSERT INTO srp1868_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","И докле Мојсије држаше у вис руке своје, побеђиваху Израиљци, а како би спустио руке, одмах надвлађиваху Амаличани. ");
INSERT INTO srp1868_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Али руке Мојсију отежаше, зато узеше камен и подметнуше пода њ, те седе; а Арон и Ор држаху му руке један с једне стране а други с друге, и не клонуше му руке до захода сунчаног. ");
INSERT INTO srp1868_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","И разби Исус Амалика и народ његов оштрим мачем. ");
INSERT INTO srp1868_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Потом рече Господ Мојсију: Запиши то за спомен у књигу, и кажи Исусу нека памти да ћу сасвим истребити спомен Амаликов испод неба. ");
INSERT INTO srp1868_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Тада начини Мојсије олтар, и назва га: Господ, застава моја. ");
INSERT INTO srp1868_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","И рече: Што се рука беше подигла на престо Господњи, Господ ће ратовати на Амалика од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","А Јотор свештеник мадијански, таст Мојсијев, чу све што учини Господ Мојсију и Израиљу народу свом, како изведе Господ Израиља из Мисира; ");
INSERT INTO srp1868_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","и узе, Јотор таст Мојсијев, Сефору жену Мојсијеву, коју беше послао натраг, ");
INSERT INTO srp1868_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","и два сина њена, од којих једном беше име Гирсам, јер рече: Туђин сам у земљи туђој, ");
INSERT INTO srp1868_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","а другом беше име Елијезер, јер, рече, Бог оца мог би ми у помоћи и оте ме од мача Фараоновог. ");
INSERT INTO srp1868_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","И пође Јотор, таст Мојсијев, са синовима његовим и са женом његовом к Мојсију у пустињу, где беше у логору под гором Божијом. ");
INSERT INTO srp1868_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","И поручи Мојсију: Ја таст твој Јотор идем к теби и жена твоја и оба сина њена с њом. ");
INSERT INTO srp1868_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","И Мојсије изађе на сусрет тасту свом и поклони му се и целива га; и упиташе се за здравље, па уђоше под шатор његов. ");
INSERT INTO srp1868_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","И приповеди Мојсије тасту свом све што учини Господ Фараону и Мисирцима ради Израиља, и све невоље, које их налазише путем, и како их избави Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","И радоваше се Јотор свему добру што учини Господ Израиљу избавивши га из руке мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","И рече Јотор: Благословен да је Господ, који вас избави из руке мисирске, и из руке Фараонове, који избави народ из ропства мисирског. ");
INSERT INTO srp1868_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Сад видим да је Господ већи од свих богова, јер чим се поношаху оним их самим надвиси. ");
INSERT INTO srp1868_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","И узе Јотор, таст Мојсијев и принесе Богу жртву паљеницу и принос; и дође Арон и све старешине израиљске, и једоше с тастом Мојсијевим пред Богом. ");
INSERT INTO srp1868_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","А сутрадан седе Мојсије да суди народу; и стајаше народ пред Мојсијем од јутра до вечера. ");
INSERT INTO srp1868_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","А таст Мојсијев гледајући све шта ради с народом, рече: Шта то радиш с народом? Зашто седиш сам, а сав народ стоји пред тобом од јутра до вечера. ");
INSERT INTO srp1868_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","А Мојсије рече тасту свом: Јер долази народ к мени да пита Бога. ");
INSERT INTO srp1868_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Кад имају шта међу собом, долазе к мени, те им судим и казујем наредбе Божје и законе Његове. ");
INSERT INTO srp1868_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","А таст Мојсијев рече му: Није добро шта радиш. ");
INSERT INTO srp1868_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Уморићеш се и ти и народ који је с тобом; јер је то тешко за тебе, нећеш моћи сам вршити. ");
INSERT INTO srp1868_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Него послушај мене; ја ћу те световати, и Бог ће бити с тобом; ти буди пред Богом за народ, и ствари њихове јављај Богу; ");
INSERT INTO srp1868_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","и учи их наредбама и законима Његовим, и показуј им пут којим ће ићи и шта ће радити. ");
INSERT INTO srp1868_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","А из свега народа изабери људе поштене, који се боје Бога, људе праведне, који мрзе на мито, па их постави над њима за поглаваре, хиљаднике, стотинике, педесетнике и десетнике; ");
INSERT INTO srp1868_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","они нека суде народу у свако доба; па сваку ствар велику нека јављају теби, а сваку ствар малу нека расправљају сами; тако ће ти бити лакше, кад и они стану носити терет с тобом. ");
INSERT INTO srp1868_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ако то учиниш, и Бог ти заповеди, можеш се одржати, и сав ће народ доћи мирно на своје место. ");
INSERT INTO srp1868_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","И Мојсије послуша таста свог, и учини све што рече. ");
INSERT INTO srp1868_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","И изабра Мојсије из свега Израиља људе поштене, и постави их за поглаваре над народом, хиљаднике, стотнике, педесетнике и десетнике. ");
INSERT INTO srp1868_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Који суђаху народу у свако доба, а ствари тешке јављаху Мојсију, а мале ствари расправљаху сами. ");
INSERT INTO srp1868_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","После отпусти Мојсије таста свог, који се врати у своју земљу. ");
INSERT INTO srp1868_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Првог дана трећег месеца, пошто изађоше синови Израиљеви из Мисира, тог дана дођоше у пустињу синајску. ");
INSERT INTO srp1868_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Кренувши се из Рафидина дођоше у пустињу синајску, и стадоше у логор у пустињи, а логор начинише Израиљци онде под гором. ");
INSERT INTO srp1868_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","И Мојсије изађе на гору к Богу; и повика му Господ с горе говорећи: Овако кажи дому Јаковљевом, и реци синовима Израиљевим: ");
INSERT INTO srp1868_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Видели сте шта сам учинио Мисирцима и како сам вас као на крилима орловим носио и довео вас к себи. ");
INSERT INTO srp1868_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","А сада ако добро узаслушате глас мој и ушчувате завет мој, бићете моје благо мимо све народе, премда је моја сва земља. ");
INSERT INTO srp1868_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","И бићете ми царство свештеничко и народ свет. То су речи које ћеш казати синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","А Мојсије дође и сазва старешине народне; и каза им све ове речи које му Господ заповеди. ");
INSERT INTO srp1868_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","А сав народ одговори сложно и рече: Шта је год казао Господ чинићемо. И Мојсије јави Господу речи народне. ");
INSERT INTO srp1868_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","А Господ рече Мојсију: Ево, ја ћу доћи к теби у густом облаку, да народ чује кад ти станем говорити и да ти верује до века. Јер Мојсије беше јавио Господу речи народне. ");
INSERT INTO srp1868_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","И рече Господ Мојсију: Иди к народу, и освештај их данас и сутра, и нека оперу хаљине своје; ");
INSERT INTO srp1868_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","и нека буду готови за трећи дан, јер ће у трећи дан сићи Господ на гору синајску пред свим народом. ");
INSERT INTO srp1868_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","А поставићеш народу међу унаоколо, и рећи ћеш: Чувајте се да не ступите на гору и да се не дотакнете краја њеног; шта се год дотакне горе, погинуће; ");
INSERT INTO srp1868_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","тога да се нико не дотакне руком, него камењем да се заспе или да се устрели, било живинче или човек, да не остане у животу. Кад рог затруби отежући онда нека пођу на гору. ");
INSERT INTO srp1868_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","И Мојсије сиђе с горе к народу; и освешта народ, и опраше хаљине своје. ");
INSERT INTO srp1868_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","И рече народу: Будите готови за трећи дан, и не лежите са женама. ");
INSERT INTO srp1868_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","А трећи дан кад би ујутру, громови загрмеше и муње засеваше, и поста густ облак на гори, и затруби труба веома јако, да задрхта сав народ који беше у логору. ");
INSERT INTO srp1868_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Тада Мојсије изведе народ из логора пред Бога, и стадоше испод горе. ");
INSERT INTO srp1868_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","А гора се синајска сва димише, јер сиђе на њу Господ у огњу; и дим се из ње подизаше као дим из пећи, и сва се гора тресла веома. ");
INSERT INTO srp1868_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","И труба све јаче трубљаше, и Мојсије говораше а Бог му одговараше гласом. ");
INSERT INTO srp1868_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","И Господ сишавши на гору синајску, на врх горе, позва Мојсија на врх горе; и изађе Мојсије. ");
INSERT INTO srp1868_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","А Господ рече Мојсију: Сиђи, опомени народ да не преступе међе да виде Господа, да не би изгинули од мене. ");
INSERT INTO srp1868_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","И сами свештеници, који приступају ка Господу, нека се освештају, да их не би побио Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","А Мојсије рече Господу: Неће моћи народ изаћи на гору синајску, јер си нас Ти опоменуо рекавши: Начини међу гори и освештај је. ");
INSERT INTO srp1868_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","А Господ му рече: Иди, сиђи, па онда дођи ти и Арон с тобом; а свештеници и народ нека не преступе међе да се попну ка Господу, да их не би побио. ");
INSERT INTO srp1868_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","И сиђе Мојсије к народу, и каза им. ");
INSERT INTO srp1868_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Тада рече Бог све ове речи говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Ја сам Господ Бог твој, који сам те извео из земље мисирске, из дома ропског. ");
INSERT INTO srp1868_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Немој имати других богова уза ме. ");
INSERT INTO srp1868_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Не гради себи лик резани нити какву слику од оног што је горе на небу, или доле на земљи, или у води, испод земље. ");
INSERT INTO srp1868_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Немој им се клањати нити им служити, јер сам ја Господ Бог твој, Бог ревнитељ, који походим грехе отачке на синовима до трећег и до четвртог колена, оних који мрзе на мене; ");
INSERT INTO srp1868_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","а чиним милост на хиљадама оних који ме љубе и чувају заповести моје. ");
INSERT INTO srp1868_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Не узимај узалуд име Господа Бога свог; јер неће пред Господом бити прав ко узме име Његово узалуд. ");
INSERT INTO srp1868_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Сећај се дана од одмора да га светкујеш. ");
INSERT INTO srp1868_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Шест дана ради, и свршуј све послове своје. ");
INSERT INTO srp1868_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","А седми је дан одмор Господу Богу твом; тада немој радити ниједан посао, ни ти, ни син твој, ни кћи твоја, ни слуга твој, ни слушкиња твоја, ни живинче твоје, ни странац који је међу вратима твојим. ");
INSERT INTO srp1868_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Јер је за шест дана створио Господ небо и земљу, море и шта је год у њима; а у седми дан почину; зато је благословио Господ дан од одмора и посветио га. ");
INSERT INTO srp1868_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Поштуј оца свог и матер своју, да ти се продуже дани на земљи, коју ти да Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Не убиј. ");
INSERT INTO srp1868_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Не чини прељубе. ");
INSERT INTO srp1868_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Не кради. ");
INSERT INTO srp1868_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Не сведочи лажно на ближњег свог. ");
INSERT INTO srp1868_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Не пожели кућу ближњег свог, не пожели жену ближњег свог, ни слугу његовог, ни слушкињу његову, ни вола његовог, ни магарца његовог, нити ишта што је ближњег твог. ");
INSERT INTO srp1868_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","И сав народ виде гром и муњу и трубу где труби и гору где се дими; и народ видевши то узмаче се и стаде издалека, ");
INSERT INTO srp1868_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","и рекоше Мојсију: Говори нам ти, и слушаћемо; а нека нам не говори Бог, да не помремо. ");
INSERT INTO srp1868_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","А Мојсије рече народу: Не бојте се, јер Бог дође да вас искуша и да вам пред очима буде страх Његов да не бисте грешили. ");
INSERT INTO srp1868_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","И народ стајаше издалека, а Мојсије приступи к мраку у коме беше Бог. ");
INSERT INTO srp1868_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","И Господ рече Мојсију: Овако кажи синовима Израиљевим: видели сте где вам с неба говорих. ");
INSERT INTO srp1868_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Не градите уза ме богове сребрне, ни богове златне не градите себи. ");
INSERT INTO srp1868_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Олтар од земље начини ми, на коме ћеш ми приносити жртве своје паљенице и жртве своје захвалне, ситну и крупну стоку своју. На коме год месту заповедим да се спомиње име моје, доћи ћу к теби и благословићу те. ");
INSERT INTO srp1868_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ако ли ми начиниш олтар од камена, немој начинити од тесаног камена; јер ако повучеш по њему гвожђем, оскврнићеш га. ");
INSERT INTO srp1868_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Немој уз басамаке ићи к олтару мом, да се не би открила голотиња твоја код њега. ");
INSERT INTO srp1868_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","А ово су закони које ћеш им поставити: ");
INSERT INTO srp1868_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ако купиш роба Јеврејина, шест година нека ти служи, а седме нек отиде слободан без откупа. ");
INSERT INTO srp1868_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ако буде дошао инокосан, нека и отиде инокосан; ако ли буде имао жену, нека иде и жена с њим. ");
INSERT INTO srp1868_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ако га господар његов ожени, и жена му роди синове или кћери, жена с децом својом нека буде господару његовом, а он нека отиде сам. ");
INSERT INTO srp1868_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ако ли роб рече тврдо: Љубим господара свог, жену своју и децу своју, нећу да идем да будем слободан, ");
INSERT INTO srp1868_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","онда нека га доведе господар његов пред судије и постави на вратима или код довратка, и онде нека му господар пробуши ухо шилом, па нека му робује довека. ");
INSERT INTO srp1868_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ако ко прода кћер своју да буде робиња, да не одлази као робови што одлазе. ");
INSERT INTO srp1868_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ако не буде по вољи господару свом, и он је не узме за жену, нека је пусти на откупе; али да нема власти продати је у туђ народ учинивши јој неверу. ");
INSERT INTO srp1868_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ако ли је заручи сину свом, да јој учини по праву које имају кћери. ");
INSERT INTO srp1868_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ако ли узме другу, да јој не умали хране ни одела ни заједнице. ");
INSERT INTO srp1868_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ако јој ово троје не учини, онда нек отиде без откупа. ");
INSERT INTO srp1868_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Ко удари човека, те умре, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ако ли не буде хтео, него му га Бог даде у руке, одредићу ти место куда може побећи. ");
INSERT INTO srp1868_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ако би ко намерно устао на ближњег свог да га убије из преваре, одвуци га и од олтара мог да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ко удари оца свог или матер своју, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ко украде човека и прода или се нађе у његовим рукама, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ко опсује оца свог или матер своју, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Кад се сваде људи, па један удари другог каменом или песницом, али онај не умре него падне у постељу, ");
INSERT INTO srp1868_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ако се придигне и изађе о штапу, да не буде крив онај који је ударио, само дангубу да му накнади и сву видарину да плати. ");
INSERT INTO srp1868_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ко удари роба свог или робињу штапом тако да му умре под руком, да је крив; ");
INSERT INTO srp1868_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","али ако преживи дан или два, да није крив, јер је његов новац. ");
INSERT INTO srp1868_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Кад се сваде људи, па који од њих удари трудну жену тако да изађе из ње дете, али се не догоди смрт, да плати глобу колико муж женин рече, а да плати преко судија; ");
INSERT INTO srp1868_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ако ли се догоди смрт, тада ћеш узети живот за живот, ");
INSERT INTO srp1868_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","око за око, зуб за зуб, руку за руку, ногу за ногу, ");
INSERT INTO srp1868_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ужег за ужег, рану за рану, модрицу за модрицу. ");
INSERT INTO srp1868_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ако ко удари по оку роба свог или робињу своју, те му поквари око, да га отпусти слободног за око његово. ");
INSERT INTO srp1868_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","И ако избије зуб робу свом или робињи својој, да га пусти слободног за зуб његов. ");
INSERT INTO srp1868_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ако во убоде човека или жену, те умре, да се во заспе камењем и да се не једе месо од њега, а господар од вола да није крив. ");
INSERT INTO srp1868_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Али ако је во пре био бодач и господар његов знао за то па га није чувао, те убије човека или жену, во да се заспе камењем, и господар његов да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ако му се одреди да се откупи, нека да откуп за живот свој, колико му се одреди. ");
INSERT INTO srp1868_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ако убоде сина или кћер, да му буде по истом закону. ");
INSERT INTO srp1868_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ако ли роба убоде во или робињу, да да господару њиховом тридесет сикала сребра и во да се заспе камењем. ");
INSERT INTO srp1868_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ако ко открије јаму или ископа јаму а не покрије, па упадне во или магарац, ");
INSERT INTO srp1868_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","да накнади господар од јаме и плати новцем господару њиховом, а што је угинуло да је његово. ");
INSERT INTO srp1868_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ако во једног убоде вола другом, те погине, онда да продаду вола живог и новце да поделе, тако и убијеног вола да поделе. ");
INSERT INTO srp1868_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ако ли се знало да је во пре био бодач па га није чувао господар његов, да да вола за вола, а убијени нека буде њему. ");
INSERT INTO srp1868_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ко украде вола или овцу или козу, и закоље или прода, да врати пет волова за једног вола, а четири овце или козе за једну овцу или козу. ");
INSERT INTO srp1868_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ако се лупеж ухвати где поткопава, те буде рањен тако да умре, да не буде крив за крв онај који га буде убио; ");
INSERT INTO srp1868_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","али ако се буде сунце родило, да је крив за крв. А лупеж све да накнади; ако ли не би имао, онда да се он прода за своју крађу. ");
INSERT INTO srp1868_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ако се нађе шта је покрао у његовој руци живо, био во или магарац или овца или коза, да врати двоструко. ");
INSERT INTO srp1868_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ко потре њиву или виноград пустивши стоку своју да пасе по туђој њиви, да накнади најбољим са своје њиве и најбољим из свог винограда. ");
INSERT INTO srp1868_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ако изађе ватра и наиђе на трње, па изгори стог или жито које још стоји или њива, да накнади онај који је запалио. ");
INSERT INTO srp1868_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ако ко да ближњему свом новце или посуђе на оставу, па се украде из куће његове, ако се нађе лупеж, да плати двојином; ");
INSERT INTO srp1868_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ако ли се не нађе лупеж, онда господар од оне куће да стане пред судије да се закуне да није посегао руком својом на ствар ближњег свог. ");
INSERT INTO srp1868_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","За сваку ствар за коју би била распра, или за вола или за магарца или за овцу или за козу, или за хаљину, за сваку ствар изгубљену, кад ко каже да је његова, пред судије да дође распра обојице, па кога осуде судије, онај да врати ближњему свом двојином. ");
INSERT INTO srp1868_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Ако ко да ближњему свом да чува магарца или вола или овцу или козу или како год живинче, па угине или охроне, или га ко отера а да нико не види, ");
INSERT INTO srp1868_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","заклетва Господња нека буде између њих, да није посегао руком својом на ствар ближњег свог, и господар од ствари нека пристане, а онај да не плати. ");
INSERT INTO srp1868_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ако ли му буде украдено, нека плати господару његовом. ");
INSERT INTO srp1868_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ако ли га буде растргла зверка да донесе од њега сведоџбу, и да не плати шта је растргнуто. ");
INSERT INTO srp1868_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ако ко узме од ближњег свог живинче на послугу, па охроне или угине, а господар му не буде код њега, да плати. ");
INSERT INTO srp1868_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ако ли господар буде код њега, да не плати. Ако ли буде најмљено, да плати само најам. ");
INSERT INTO srp1868_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ко би преварио девојку, која није заручена, те би спавао с њом, да јој да мираз и узме је за жену. ");
INSERT INTO srp1868_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","А ако му је отац њен не би хтео дати, да да новаца колико иде у мираз девојци. ");
INSERT INTO srp1868_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Вештици не дај да живи. ");
INSERT INTO srp1868_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ко би облежао живинче, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ко жртву приноси боговима другим осим јединог Господа, да се истреби као проклетник. ");
INSERT INTO srp1868_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Дошљаку немој чинити криво нити га уцвелити, јер сте били дошљаци у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Немојте уцвелити удовице и сироте. ");
INSERT INTO srp1868_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ако ли коју уцвелиш у чем год, и повиче к мени, чућу вику њену, ");
INSERT INTO srp1868_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","и запалиће се гнев мој, и побићу вас мачем, па ће ваше жене бити удовице и ваша деца сироте. ");
INSERT INTO srp1868_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Кад даш у зајам новаца народу мом, сиромаху који је код тебе, немој му бити као каматник, не ударајте на њ камате. ");
INSERT INTO srp1868_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ако узмеш у залогу хаљину ближњему свом, врати му је пре него сунце зађе; ");
INSERT INTO srp1868_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","јер му је то све одело чим заклања тело своје; у чем ће спавати? Па кад повиче к мени, ја ћу га чути, јер сам милостив. ");
INSERT INTO srp1868_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Немој псовати судије, и старешини народа свог не говори ружно. ");
INSERT INTO srp1868_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Од летине своје и од житких ствари својих немој се затезати да принесеш првине; првенца између синова својих мени да даш. ");
INSERT INTO srp1868_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Тако чини с волом својим и с овцом и с козом; седам дана нека буде с мајком својом, а осмог дана да га даш мени. ");
INSERT INTO srp1868_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Бићете ми свети људи; меса у пољу растргнута не једите, баците га псима. ");
INSERT INTO srp1868_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Не износи лажних гласова; не пристај с безбожником да сведочиш криво. ");
INSERT INTO srp1868_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Не иди за множином на зло, и не говори на суду поводећи се за већим бројем да се изврне правда. ");
INSERT INTO srp1868_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Сиромаху у парници његовој не гледај што је сиромах. ");
INSERT INTO srp1868_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ако наиђеш на вола непријатеља свог или на магарца његовог, где је залутао, одведи га к њему. ");
INSERT INTO srp1868_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ако видиш где је ненавиднику твом пао магарац под теретом својим, немој да га оставиш, него му помози. ");
INSERT INTO srp1868_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Немој изврнути правде сиромаху свом у парници његовој. ");
INSERT INTO srp1868_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Речи лажне клони се, и безазленог и правог немој убити, јер нећу оправдати безбожника. ");
INSERT INTO srp1868_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Не узимај поклона, јер поклон заслепљује окате и изврће речи правима. ");
INSERT INTO srp1868_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Дошљаке не цвели, јер ви знате каква је душа дошљаку, јер сте били дошљаци у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Шест година засејавај земљу своју и сабирај род њен; ");
INSERT INTO srp1868_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","а седме године остави је нека почине, да једу сиромаси народа твог, а шта иза њих остане нека једу звери пољске; тако ради и с виноградом својим и с маслиником својим. ");
INSERT INTO srp1868_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Шест дана ради послове своје, а у седми дан почини, да се одмори во твој и магарац твој, и да одахне син робиње твоје и дошљак. ");
INSERT INTO srp1868_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Држите се свега што сам вам казао. Не помињите имена богова туђих, и да се не чује из уста ваших. ");
INSERT INTO srp1868_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Три пута преко године светкуј ми: ");
INSERT INTO srp1868_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Празник пресних хлебова држи; седам дана једи хлебове пресне, као што сам ти заповедио, на време, месеца Авива, јер си тада изашао из Мисира; и нико да не изађе преда ме празан; ");
INSERT INTO srp1868_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","и празник жетве првина од труда твог што посејеш у пољу свом; и празник бербе на свршетку сваке године, кад сабереш труд свој с њиве. ");
INSERT INTO srp1868_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Три пута преко године све мушкиње твоје да излази пред Господа Бога. ");
INSERT INTO srp1868_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Крв од жртве моје не приноси уз хлебове киселе, и претилина празника мог да не преноћи до јутра. ");
INSERT INTO srp1868_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Првине од првог рода земље своје донеси у кућу Господа Бога свог. Немој кувати јагњета у млеку мајке његове. ");
INSERT INTO srp1868_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ево, ја шаљем анђела свог пред тобом да те чува на путу, и да те одведе на место које сам ти приправио. ");
INSERT INTO srp1868_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Чувај га се, и слушај га, немој да га расрдиш, јер вам неће опростити грех, јер је моје име у њему. ");
INSERT INTO srp1868_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Него ако га добро узаслушаш и уствориш све што кажем, ја ћу бити непријатељ твојим непријатељима и противник твојим противницима. ");
INSERT INTO srp1868_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Јер ће анђео мој ићи пред тобом и одвешће те у земљу аморејску и хетејску и ферезејску и хананејску и јевејску и јевусејску, и ја ћу их истребити. ");
INSERT INTO srp1868_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Немој се клањати боговима њиховим нити им служити, ни чинити шта они чине, него их сасвим обори и ликове њихове сасвим изломи. ");
INSERT INTO srp1868_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","И служите Господу Богу свом, и Он ће благословити хлеб твој и воду твоју; и уклонићу болест између вас. ");
INSERT INTO srp1868_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Неће бити пометкиње ни нероткиње у земљи твојој; и број дана твојих напунићу. ");
INSERT INTO srp1868_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Пустићу страх свој пред тобом, и уплашићу сваки народ на који дођеш, и обратићу к теби плећи свих непријатеља твојих. ");
INSERT INTO srp1868_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Послаћу и стршљене пред тобом, да терају Јевеје, Хананеје и Хетеје испред тебе. ");
INSERT INTO srp1868_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Нећу их отерати испред тебе за једну годину, да не опусти земља и да се зверје пољско не намножи на тебе. ");
INSERT INTO srp1868_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Помало ћу их одгонити испред тебе докле се не намножиш и заузмеш земљу. ");
INSERT INTO srp1868_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","И поставићу међе твоје од мора црвеног до мора филистејског и од пустиње до реке; јер ћу вама у руке дати оне који живе у оној земљи да их отераш испред себе. ");
INSERT INTO srp1868_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Немој хватати вере с њима ни с боговима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Нека не седе у земљи твојој, да те не наврате да се огрешиш о мене, јер би служио боговима њиховим, и то би ти била замка. ");
INSERT INTO srp1868_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","И рече Мојсију: Изађи горе ка Господу ти и Арон и Надав и Авијуд и седамдесет старешина Израиљевих, и поклоните се издалека. ");
INSERT INTO srp1868_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","И Мојсије сам нека приступи ка Господу, а они нека не приступе; и народ нека не иде на горе с њим. ");
INSERT INTO srp1868_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","И дође Мојсије, и каза народу све речи Господње и све законе. И одговори народ једним гласом и рекоше: Чинићемо све што је рекао Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","И написа Мојсије све речи Господње, и уставши рано начини олтар под гором и дванаест ступова за дванаест племена Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","И посла младиће између синова Израиљевих, који принесоше жртве паљенице и принесоше теоце на жртве захвалне Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","И узевши Мојсије половину крви, метну у зделе, а половину крви изли на олтар. ");
INSERT INTO srp1868_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","И узе књигу заветну и прочита народу. А они рекоше: Шта је год рекао Господ чинићемо и слушаћемо. ");
INSERT INTO srp1868_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","А Мојсије узе крв, и покропи њом народ, и рече: Ево крв завета, који учини Господ с вама за све речи ове. ");
INSERT INTO srp1868_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Потом отиде горе Мојсије и Арон, Надав и Авијуд, и седамдесет старешина Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","И видеше Бога Израиљевог, и под ногама Његовим као дело од камена сафира и као небо кад је ведро. ");
INSERT INTO srp1868_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","И не пружи руке своје на изабране између синова Израиљевих, него видеше Бога, па једоше и пише. ");
INSERT INTO srp1868_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","И рече Господ Мојсију: Попни се к мени на гору, и остани овде, и даћу ти плоче од камена, закон и заповести, које сам написао да их учиш. ");
INSERT INTO srp1868_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Тада уста Мојсије с Исусом, који га служаше, и изађе Мојсије на гору Божију. ");
INSERT INTO srp1868_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","А старешинама рече: Седите ту док се вратимо к вама; а ето Арон и Ор с вама; ко би имао шта, нека иде к њима. ");
INSERT INTO srp1868_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","И отиде Мојсије на гору, а облак покри гору. ");
INSERT INTO srp1868_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","И беше слава Господња на гори синајској, и облак је покриваше шест дана; а у седми дан викну Мојсија испред облака. ");
INSERT INTO srp1868_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","И слава Господња беше по виђењу као огањ који сажиже на врх горе пред синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","И Мојсије уђе усред облака, и попе се на гору; и оста Мојсије на гори четрдесет дана и четрдесет ноћи. ");
INSERT INTO srp1868_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","И Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Реци синовима Израиљевим да ми скупе прилог: од сваког који драге воље да, узмите прилог мени. ");
INSERT INTO srp1868_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","А ово је прилог што ћете узимати од њих, злато и сребро и бронзу, ");
INSERT INTO srp1868_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","и порфиру и скерлет и црвац и танко платно и кострет, ");
INSERT INTO srp1868_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","и коже овнујске црвене обојене, и коже јазавичије, и дрво ситим, ");
INSERT INTO srp1868_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","уље за видело, мирисе за уље помазања и за мирисави кад, ");
INSERT INTO srp1868_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","камење онихово и камење за укивање на оплећак и напрсник. ");
INSERT INTO srp1868_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","И нека ми начине светињу, да међу њима наставам; ");
INSERT INTO srp1868_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","као што ћу ти показати слику од шатора и слику од свих ствари његових, тако да начините. ");
INSERT INTO srp1868_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Нека начине ковчег од дрвета ситима, у дужину од два лакта и по, а у ширину од подруг лакта, и у висину од подруг лакта. ");
INSERT INTO srp1868_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","И покуј га чистим златом, изнутра и споља покуј га; и озго му начини златан венац унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","И салиј му четири биочуга од злата, и метни му их на четири угла, да му с једне стране буду два биочуга и с друге стране два биочуга. ");
INSERT INTO srp1868_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","И начини полуге од дрвета ситима, и окуј их у злато. ");
INSERT INTO srp1868_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","И провуци полуге кроз биочуге с обе стране ковчегу, да се о њима носи ковчег; ");
INSERT INTO srp1868_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","у биочузима на ковчегу нека стоје полуге, да се не ваде из њих. ");
INSERT INTO srp1868_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Па у ковчег метни сведочанство, које ћу ти дати. ");
INSERT INTO srp1868_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","И начини заклопац од чистог злата, у дужину од два лакта и по, а у ширину од подруг лакта. ");
INSERT INTO srp1868_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","И начини два херувима златна, једноставне их начини, на два краја заклопцу. ");
INSERT INTO srp1868_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","И начини херувима једног на једном крају а другог херувима на другом крају; на заклопцу начините два херувима на оба краја. ");
INSERT INTO srp1868_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","И нека херувими рашире крила у вис да заклањају крилима заклопац, и нека буду лицем окренути један другом, према заклопцу нека су окренута лица херувимима. ");
INSERT INTO srp1868_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","И метнућеш заклопац озго на ковчег, а у ковчег ћеш метнути сведочанство које ћу ти дати. ");
INSERT INTO srp1868_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","И ту ћу се састајати с тобом и говорићу ти озго са заклопца између два херувима, који ће бити на ковчегу од сведочанства, све што ћу ти заповедати за синове Израиљеве. ");
INSERT INTO srp1868_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Начини и сто од дрвета ситима, у дужину од два лакта, а у ширину од једног лакта, а у висину од подруг лакта. ");
INSERT INTO srp1868_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","И покуј га чистим златом, и начини му венац златан унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","И начини му оплату унаоколо с подланице, и начини златан венац око оплате. ");
INSERT INTO srp1868_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","И начини му четири биочуга од злата, и метни му те биочуге на четири угла који ће му бити код четири ноге. ");
INSERT INTO srp1868_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Под оплатом нека буду биочузи, да у њима стоје полуге да се носи сто. ");
INSERT INTO srp1868_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","А полуге начини од дрвета ситима, и окуј их златом да се о њима носи сто. ");
INSERT INTO srp1868_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","И начини му зделе и чаше и ведра и котлиће, којима ће се преливати, а начинићеш их од чистог злата. ");
INSERT INTO srp1868_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","И метаћеш на сто хлебове, да су постављени свагда преда мном. ");
INSERT INTO srp1868_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","И начини свећњак од чистог злата, једноставан нека буде свећњак; ступ и гране и чашице, јабуке, и цветови нека буду у њега. ");
INSERT INTO srp1868_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","А шест грана нека му излази са страна, три гране с једне стране свећњака а три гране с друге стране свећњака. ");
INSERT INTO srp1868_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Три чашице као бадем нека буду на једној грани и јабука и цвет, и три чашице као бадем и јабука и цвет на другој грани; тако нека буде на шест грана што излазе из свећњака. ");
INSERT INTO srp1868_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","И на самом свећњаку нека буду четири чашице као бадем и јабуке и цветови. ");
INSERT INTO srp1868_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Једна јабука под две гране што излазе из њега, и једна јабука под друге две гране што излазе из њега, и једна јабука под друге две гране што излазе из њега; тако ће бити под шест грана што ће излазити из свећњака; ");
INSERT INTO srp1868_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","јабуке и гране њихове из њега нека излазе; све једноставно од чистог злата. ");
INSERT INTO srp1868_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","И начинићеш му седам жижака, и палићеш их да светле са сваке стране; ");
INSERT INTO srp1868_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","и усекачи и спремице за гар нека буду од чистог злата. ");
INSERT INTO srp1868_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Од таланта чистог злата нека буде начињен са свим тим справама. ");
INSERT INTO srp1868_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","И гледај, те начини све ово по слици која ти је показана на гори. ");
INSERT INTO srp1868_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","А шатор ћеш начинити од десет завеса од танког платна узведеног и од порфире и од скерлета и од црвца; и по њима да буду везени херувими. ");
INSERT INTO srp1868_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Један завес нека буде двадесет и осам лаката дуг и четири лакта широк; сви завеси да буду једне мере. ");
INSERT INTO srp1868_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Пет завеса нека се састављају један с другим, и пет других завеса нека се састављају један с другим. ");
INSERT INTO srp1868_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","И начини петље од порфире по крају једног завеса, где ће се крајеви састављати, и тако начини по крају другог завеса, где ће се крајеви састављати. ");
INSERT INTO srp1868_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Педесет петаља начини на једном завесу, а педесет петаља начини на крају другог завеса, где ће се састављати с другим, а петље да буду једна према другој. ");
INSERT INTO srp1868_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","И начини педесет кука од злата, да запнеш завесе један за други кукама, и тако ће бити шатор један. ");
INSERT INTO srp1868_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","И начини завесе од кострети за наслон над шатором; једанаест таквих завеса начини. ");
INSERT INTO srp1868_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Завес један нека буде тридесет лаката дуг, а широк четири лакта; тих једанаест завеса да су једне мере. ");
INSERT INTO srp1868_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","И састави пет завеса заједно, а шест осталих заједно, на двоје ћеш превити шести завес с предње стране наслону. ");
INSERT INTO srp1868_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","И начини педесет петаља на стражњем крају првог завеса, где ће се састављати, а педесет петаља на крају другог завеса, где ће се састављати. ");
INSERT INTO srp1868_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","И начини кука бронзаних педесет, и запни куке на петље, и састави наслон, да буде једно. ");
INSERT INTO srp1868_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","А што је више у завеса на наслону, половина завеса што претиче, нека виси на стражњој страни шатору. ");
INSERT INTO srp1868_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","И лакат с једне стране а лакат с друге стране што има више у дужину у завеса на наслону, нека виси шатору са стране и тамо и амо, да га заклања. ");
INSERT INTO srp1868_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","И начини покривач наслону од кожа овнујских црвених обојених, и сврх њега покривач од кожа јазавичијих. ");
INSERT INTO srp1868_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","И начини за шатор даске од дрвета ситима, које ће стајати право. ");
INSERT INTO srp1868_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Десет лаката нека буде свака даска дуга а подруг лакта широка. ");
INSERT INTO srp1868_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Два чепа нека буду на дасци, један према другом наједнако; тако начини на свакој дасци за шатор. ");
INSERT INTO srp1868_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Тако начини даске за шатор, двадесет дасака на јужној страни. ");
INSERT INTO srp1868_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","А под двадесет дасака начини четрдесет стопица од сребра: две стопице под једну даску за два чепа њена, и две стопице под другу даску за два чепа њена. ");
INSERT INTO srp1868_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","А на другој страни шатора према северу двадесет дасака. ");
INSERT INTO srp1868_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Са четрдесет стопица сребрних, две стопице под једну даску и две стопице под другу даску. ");
INSERT INTO srp1868_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","А на западној страни шатора начини шест дасака, ");
INSERT INTO srp1868_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","и две даске на два угла од шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","И оне нека се састављају оздо и нека се састављају озго биочугом; тако нека буде у обе које ће бити на оба угла. ");
INSERT INTO srp1868_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Тако ће бити осам дасака са стопицама сребрним, са шеснаест стопица, две стопице под једну даску, а две стопице под другу даску. ");
INSERT INTO srp1868_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","И начини преворнице од дрвета ситима, пет за даске на једној страни шатора, ");
INSERT INTO srp1868_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","и пет преворница за даске на другој страни шатора, и пет преворница за даске на западној страни шатора до оба угла. ");
INSERT INTO srp1868_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","А средња преворница да иде преко среде дасака од једног краја до другог. ");
INSERT INTO srp1868_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","А даске окуј златом, и биочуге им начини од злата, да се кроз њих провуку преворнице, а и преворнице окуј златом. ");
INSERT INTO srp1868_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Тако ћеш подигнути шатор по слици која ти је показана на гори. ");
INSERT INTO srp1868_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","И начини завес од порфире и од скерлета и од црвца и од танког платна узведеног, и по њему нека буду везени херувими. ");
INSERT INTO srp1868_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","И обеси га о четири ступа од дрвета ситима, окована златом, са кукама златним, на четири стопице сребрне. ");
INSERT INTO srp1868_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","И обеси завес о куке, и унеси за завес ковчег од сведочанства, да вам завес раставља светињу од светиње над светињама. ");
INSERT INTO srp1868_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","И метни заклопац на ковчег од сведочанства у светињи над светињама. ");
INSERT INTO srp1868_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","И намести сто пред завес а свећњак према столу на јужној страни шатора, да сто стоји на северној страни. ");
INSERT INTO srp1868_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","И на врата наслону начинићеш завес од порфире и од скерлета и од црвца и од танког платна узведеног, везен; ");
INSERT INTO srp1868_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","и за тај завес начинићеш пет ступова од дрвета ситима, које ћеш оковати златом, са кукама златним, и салићеш за њих пет стопица од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","И начини олтар од дрвета ситима, пет лаката у дужину и пет лаката у ширину, четвороугласт да буде олтар, три лакта висок. ");
INSERT INTO srp1868_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","И на четири угла начини му рогове, из њега да излазе рогови, и оковаћеш га у бронзу. ");
INSERT INTO srp1868_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","И начинићеш му лонце за пепео и лопатице и котлиће и виљушке и машице; све му посуђе начини од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","И начини му решетку од бронзе као мрежу, и начини у решетке четири биочуга од бронзе на четири угла њена. ");
INSERT INTO srp1868_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","И метни је испод олтара унаоколо, да буде решетка до средине олтара. ");
INSERT INTO srp1868_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Начини и полуге олтару, полуге од дрвета ситима, и окуј их у бронзу. ");
INSERT INTO srp1868_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","И полуге да се провуку кроз биочуге, да буду полуге с две стране олтару, кад се носи. ");
INSERT INTO srp1868_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Начинићеш га од дасака да буде изнутра шупаљ; као што ти је показано на гори тако нека начине. ");
INSERT INTO srp1868_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","И начинићеш трем шатору на јужној страни; завеси трему да буду од танког платна узведеног, сто лаката у дужину на једној страни. ");
INSERT INTO srp1868_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","И двадесет ступова и под њих двадесет стопица од бронзе, а куке на ступовима и пасови њихови од сребра. ");
INSERT INTO srp1868_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Тако и са западне стране да буду завеси сто лаката дуги, и двадесет ступова и двадесет стопица од бронзе, на ступовима куке и њихови пасови од сребра. ");
INSERT INTO srp1868_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","А ширина ће трему имати са западне стране завесе од педесет лаката, десет ступова за њих и десет стопица под њих. ");
INSERT INTO srp1868_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","А на предњој страни према истоку биће трем широк педесет лаката. ");
INSERT INTO srp1868_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Од петнаест лаката нека буду завеси на једној страни, и за њих три ступа и три стопице под њих; ");
INSERT INTO srp1868_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","на другој страни завеси од петнаест лаката, и три ступа за њих и три стопице под њих. ");
INSERT INTO srp1868_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","А над вратима од трема завес од двадесет лаката од порфире и од скерлета и од црвца и од танког платна узведеног, везен, и четири ступа за њ, и под њих четири стопице. ");
INSERT INTO srp1868_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Сви ступови у трему унаоколо да буду опасани сребром, и куке да су им сребрне а стопице од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","У дужину ће трем имати сто лаката, у ширину педесет свуда, а у висину пет лаката, да буде од танког платна узведеног, а стопице од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Све посуђе у шатору за сваку службу, и све коље у њему и све коље у трему да буде од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","И ти заповеди синовима Израиљевим да ти донесу уља маслиновог чистог цеђеног за видело, да би жишци горели свагда. ");
INSERT INTO srp1868_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","У шатору од састанка пред завесом, који ће заклањати сведочанство, нека их Арон и синови његови спремају да горе од вечера до јутра пред Господом. То нека је уредба вечна коленима њиховим међу синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","А ти узми к себи Арона, брата свог са синовима његовим између синова Израиљевих да ми буду свештеници, Арон и Надав и Авијуд и Елеазар и Итамар, синови Аронови. ");
INSERT INTO srp1868_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","И начини свете хаљине Арону, брату свом, за част и дику. ");
INSERT INTO srp1868_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","И кажи свим људима вештим, које сам напунио духа мудрости, нека начине хаљине Арону, да се посвети да ми буде свештеник. ");
INSERT INTO srp1868_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","А ово су хаљине што ће начинити: напрсник и оплећак и плашт, кошуља везена, капа и појас. Те хаљине свете нека направе Арону, брату твом и синовима његовим, да ми буду свештеници, ");
INSERT INTO srp1868_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","и нека узму злата и порфире и скерлета и црвца и танког платна. ");
INSERT INTO srp1868_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","И нека начине оплећак од злата и од порфире и од скерлета и од црвца и од танког платна узведеног, везен. ");
INSERT INTO srp1868_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Две пораменице нека буду на њему, које ће се састављати на два краја, да се држи заједно. ");
INSERT INTO srp1868_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","А појас на њему нека буде направе исте као и он, од злата, од порфире, од скерлета, од црвца и од танког платна узведеног. ");
INSERT INTO srp1868_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","И узми два камена ониха, и на њима изрежи имена синова Израиљевих, ");
INSERT INTO srp1868_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","шест имена њихових на једном камену, а шест имена осталих на другом камену по реду како се који родио. ");
INSERT INTO srp1868_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Вештином каменарском, којом се режу печати, изрезаћеш на та два камена имена синова Израиљевих, и опточи их златом унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","И метни та два камена на пораменице оплећку, да буду камени за спомен синовима Израиљевим, и Арон да носи имена њихова пред Господом на оба рамена своја за спомен. ");
INSERT INTO srp1868_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","И начини копче од злата. ");
INSERT INTO srp1868_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","И два ланца од чистог злата начини једнака плетена, и обеси ланце плетене о копче. ");
INSERT INTO srp1868_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","И напрсник судски начини направе везене онакве као оплећак, од злата, од порфире, од скерлета, од црвца и од танког платна узведеног начини га. ");
INSERT INTO srp1868_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Нека буде четвороугласт и двострук, у дужину с педи и у ширину с педи. ");
INSERT INTO srp1868_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","И удари по њему драго камење, у четири реда нека буде камење. У првом реду: сардоникс, топаз и смарагд; ");
INSERT INTO srp1868_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","а у другом реду: карбункул, сафир и дијамант; ");
INSERT INTO srp1868_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","а у трећем реду; лигур и ахат и аметист; ");
INSERT INTO srp1868_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","а у четвртом реду: хрисолит, оних и јаспис; нека буду уковани у злато у свом реду. ");
INSERT INTO srp1868_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","И тих камена с именима синова Израиљевих биће дванаест по именима њиховим, да буду резани као печат, сваки са својим именом, за дванаест племена. ");
INSERT INTO srp1868_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","И на напрсник метни ланце једнаке, плетене, од чистог злата. ");
INSERT INTO srp1868_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","И две гривне златне начини на напрсник, и метни две гривне на два краја напрснику. ");
INSERT INTO srp1868_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Па провуци два ланца златна кроз две гривне на крајевима напрснику. ");
INSERT INTO srp1868_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","А друга два краја од два ланца запни за две копче, и метни на пораменице од оплећка спред. ");
INSERT INTO srp1868_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","И начини друге две гривне златне, и метни их на друга два краја напрснику изнутра на страни која је од оплећка. ");
INSERT INTO srp1868_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","И начини још две златне гривне, и метни их на пораменице од оплећка оздо према саставцима његовим, више појаса на оплећку. ");
INSERT INTO srp1868_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Тако нека вежу напрсник гривне његове за гривне на оплећку врпцом од порфире, да стоји над појасом од оплећка, и да се не одваја напрсник од оплећка. ");
INSERT INTO srp1868_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","И нека носи Арон имена синова Израиљевих на напрснику судском на срцу свом кад улази у светињу за спомен пред Господом вазда. ");
INSERT INTO srp1868_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","И метни на напрсник судски Урим и Тумим, да буде на срцу Арону кад улази пред Господа, и Арон ће носити суд синова Израиљевих на срцу свом пред Господом вазда. ");
INSERT INTO srp1868_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","И начини плашт под оплећак сав од порфире. ");
INSERT INTO srp1868_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","И озго нека буде прорез у среди, и нека буде опточен прорез свуда унаоколо траком ткан, као прорез у оклопа, да се не раздре. ");
INSERT INTO srp1868_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","А по скуту му начини шипке од порфире и од скерлета и од црвца свуда унаоколо, и међу њима златна звонца свуда унаоколо: ");
INSERT INTO srp1868_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Звонце златно па шипак, звонце златно па шипак по скуту од плашта свуда унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","И то ће бити на Арону кад служи, да се чује глас кад улази у светињу пред Господа и кад излази, да не погине. ");
INSERT INTO srp1868_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","И начини плочу од чистог злата, и на њој изрежи као на печату: Светиња Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","И вежи је врпцом од порфире за капу, спред на капи да стоји. ");
INSERT INTO srp1868_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","И биће на челу Ароновом, да носи Арон грехе светих приноса које принесу синови Израиљеви у свим даровима својих светих приноса; биће на челу његовом вазда, да би били мили Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","И начини кошуљу од танког платна изметаног, и начини капу од танког платна, а појас начини везен. ");
INSERT INTO srp1868_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","И синовима Ароновим начини кошуље, и начини им појасе, и капице им начини за част и дику. ");
INSERT INTO srp1868_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Па то обуци Арону брату свом и синовима његовим, и помажи их и напуни им руке и посвети их да ми буду свештеници. ");
INSERT INTO srp1868_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","И начини им гаће ланене, да се покрије голо тело; од бедара до дна стегна да буду. ");
INSERT INTO srp1868_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","И то нека је на Арону и на синовима његовим кад улазе у шатор од састанка или кад приступају к олтару да служе у светињи, да не би носећи грехе погинули. Ово ће бити уредба вечна њему и семену његовом након њега. ");
INSERT INTO srp1868_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Учинићеш им ово кад их станеш освештавати да ми врше службу свештеничку: узми теле и два овна здрава, ");
INSERT INTO srp1868_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","и хлебове пресне и колаче пресне замешене с уљем, и погаче пресне намазане уљем, од брашна пшеничног умеси их. ");
INSERT INTO srp1868_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","И метни их у једну котарицу, и принеси их у котарици с телетом и с два овна. ");
INSERT INTO srp1868_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","И доведи Арона и синове његове пред врата шатора од састанка, и умиј их водом. ");
INSERT INTO srp1868_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","И узевши хаљине обуци Арону кошуљу и плашт испод оплећка и оплећак и напрсник, и опаши га појасом од оплећка. ");
INSERT INTO srp1868_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","И метни му капу на главу и свету плочу на капу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","И узми уље за помазање, и излиј му на главу, и помазаћеш га. ");
INSERT INTO srp1868_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","И синове његове доведи и обуци им кошуље; ");
INSERT INTO srp1868_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","и опаши их појасима, Арона и синове његове, и метни им капе на главе, да имају свештенство уредбом вечном. Тако ћеш посветити руке Арону и синовима његовим. ");
INSERT INTO srp1868_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","И доведи теле пред шатор од састанка, а Арон и синови његови нека метну руке телету на главу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","И закољи теле пред Господом на вратима шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","И узевши крви од телета помажи рогове олтару прстом својим, а осталу крв сву пролиј на подножје олтару. ");
INSERT INTO srp1868_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","И узми све сало по цревима, и мрежицу на јетри, и оба бубрега и сало око њих, и запали на олтару. ");
INSERT INTO srp1868_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","А месо од телета и кожу и балегу спали огњем изван логора; то је жртва за грех. ");
INSERT INTO srp1868_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Потом узми овна једног, и на главу овну нека метну руке своје Арон и синови његови. ");
INSERT INTO srp1868_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","И закољи овна и узми крви од њега и покропи олтар унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","А овна изуди, и опери дроб и ноге, и метни их на удове његове и на главу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","И свега овна запали на олтару; то је жртва паљеница Господу, мирис угодан, жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Па узми и другог овна, и нека му метне Арон и синови његови руке своје на главу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","И закољи тог овна, и узми крви од њега и помажи њом крај од десног уха Арону и крај од десног уха синовима његовим, и палац у десне руке њихове и палац у десне ноге њихове, а осталом крвљу покропи олтар унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","И узми крви која буде на олтару и уља за помазање, и покропи Арона и хаљине његове, и синове његове и хаљине њихове, и биће свет он и хаљине његове и синови његови и хаљине њихове. ");
INSERT INTO srp1868_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Потом узми сало од овна и реп и сало што је по цревима и мрежицу на јетри и оба бубрега и сало око њих, и десно плеће; јер је ован посветни; ");
INSERT INTO srp1868_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","и један хлеб и један колач с уљем и једну погачу из котарице у којој буду пресни хлебови пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","И то све метни у руке Арону и у руке синовима његовим, и обрћи тамо и амо, да буде жртва обртана пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","По том узми им то из руку, и запали на олтару сврх жртве паљенице, да буде мирис угодан пред Господом; то је жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","И узми груди од овна посветног, који буде за Арона, и обртаћеш их тамо и амо, да буде жртва обртана пред Господом; и то ће бити твој део. ");
INSERT INTO srp1868_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Тако ћеш осветити груди од жртве обртане и плеће од жртве подизане, шта је обртано и шта је подизано од овна посветног за Арона и за синове његове. ");
INSERT INTO srp1868_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","И то ће бити Арону и синовима његовим уредбом вечном од синова Израиљевих, јер је жртва подизана. Кад је жртва подизана синова Израиљевих од њихових жртава захвалних, жртва подизана биће Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","А свете хаљине Аронове нека буду синовима његовим након њега да се помазују у њима и да им се у њима посвећују руке. ");
INSERT INTO srp1868_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Седам дана нека их облачи који на његово место буде свештеник између синова његових, који ће улазити у шатор од састанка да служи у светињи. ");
INSERT INTO srp1868_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","А овна посветног узми и скувај месо од њега на месту светом. ");
INSERT INTO srp1868_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","И Арон и синови његови нека на вратима шатора од састанка једу месо од тог овна и хлеб што је у котарици. ");
INSERT INTO srp1868_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Нека га једу они за које је било очишћење да би им се посветиле руке да би били посвећени; а други да не једе, јер је ствар света. ");
INSERT INTO srp1868_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ако ли би остало шта меса посветног или хлеба до јутра, онда што остане сажежи огњем, а да се не једе, јер је ствар света. ");
INSERT INTO srp1868_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","И тако учини Арону и синовима његовим по свему што ти заповедих; седам дана светићеш им руке. ");
INSERT INTO srp1868_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","И сваки ћеш дан приносити на жртву теле за грех ради очишћења; и очистићеш олтар чинећи очишћење на њему, и помазаћеш га да се освети. ");
INSERT INTO srp1868_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Седам дана чинићеш очишћење на олтару и осветићеш га, те ће олтар бити светиња над светињама; шта се год дотакне олтара, биће свето. ");
INSERT INTO srp1868_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","И ово ћеш приносити на олтару: два јагњета од године сваки дан без прекида. ");
INSERT INTO srp1868_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Једно јагње приноси јутром а друго приноси вечером, ");
INSERT INTO srp1868_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","и још десетину ефе пшеничног брашна смешана с уљем цеђеним, ког да буде четврт ина, и налив вина, четврт ина на једно јагње. ");
INSERT INTO srp1868_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","А друго јагње принеси увече; као са жртвом јутарњом и с наливом њеним тако и с овом чини да буде мирис угодан, жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","То нека буде жртва паљеница свагда од колена до колена вашег на вратима шатора од састанка пред Господом, где ћу се састајати с вама да говорим с тобом. ");
INSERT INTO srp1868_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","И онде ћу се састајати са синовима Израиљевим, да се освећује славом мојом. ");
INSERT INTO srp1868_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","И осветићу шатор од састанка и олтар; и Арона и синове његове осветићу да су ми свештеници. ");
INSERT INTO srp1868_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","И наставаћу међу синовима Израиљевим, и бићу им Бог. ");
INSERT INTO srp1868_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","И познаће да сам ја Господ Бог њихов, који сам их извео из земље мисирске да наставам међу њима, ја Господ Бог њихов. ");
INSERT INTO srp1868_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Још начини олтар кадиони, од дрвета ситима начини га. ");
INSERT INTO srp1868_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Дужина нека му буде лакат, и ширина лакат, четвороугласт да буде, и два лакта висок; из њега нека му излазе рогови. ");
INSERT INTO srp1868_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","И покуј га чистим златом, озго са страна унаоколо, и рогове његове; и начини му венац златан унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","И начини му по два биочуга златна испод венца на два угла његова с обе стране, и кроз њих ћеш провући полуге да се може носити. ");
INSERT INTO srp1868_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","А полуге начини од дрвета ситима, и окуј их у злато. ");
INSERT INTO srp1868_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","И метни га пред завес који виси пред ковчегом од сведочанства према заклопцу који је над сведочанством, где ћу се с тобом састајати. ");
INSERT INTO srp1868_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","И нека кади на њему Арон кадом мирисним; свако јутро нека кади кад спреми жишке. ");
INSERT INTO srp1868_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","И кад запали Арон жишке увече, нека кади; нека буде кад свагдашњи пред Господом од колена до колена вашег. ");
INSERT INTO srp1868_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Не приносите на њему кад туђи нити жртву паљеницу нити принос; ни налив не лијте на њему. ");
INSERT INTO srp1868_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Само очишћење нека чини над роговима његовим Арон једном у години; крвљу од жртве за грех у дан очишћења једном у години чиниће очишћења на њему од колена до колена вашег; јер је то светиња над светињама Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Кад станеш бројати синове Израиљеве, између оних који иду у број сваки нека даде откуп за живот свој Господу, кад их станеш бројати, да не би дошло на њих какво зло кад их станеш бројати. ");
INSERT INTO srp1868_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","А нека да сваки који иде у број пола сикла, по сиклу светом (а тај је сикал двадесет новчића); пола сикла биће прилог Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ко год иде у бој, од двадесет година и више, нека да прилог Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Богати да не да више а сиромах да не да мање од по сикла, кад дају прилог Господу на очишћење душа ваших. ");
INSERT INTO srp1868_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","И узевши новце за очишћење од синова Израиљевих остави их за потребу у шатору од састанка, и биће синовима Израиљевим спомен пред Господом за очишћење душа ваших. ");
INSERT INTO srp1868_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Начини и умиваоницу од бронзе и подножје јој од бронзе за умивање; и метни је између шатора од састанка и олтара, и налиј у њу воде. ");
INSERT INTO srp1868_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Да из ње пере Арон и синови његови руке своје и ноге своје. ");
INSERT INTO srp1868_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Кад иду у шатор од састанка, нека се умивају водом, да не изгину, или кад приступају к олтару да служе и да пале жртву огњену Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Тада нека перу руке своје и ноге своје да не изгину. То нека им буде уредба вечна Арону и семену његовом од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Узми мириса најбољих: смирне најчистије пет стотина сикала и цимета мирисавог пола толико, двеста педесет, и иђирота такође двеста педесет, ");
INSERT INTO srp1868_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","и касије пет стотина мером светом, и уља маслиновог један ин. ");
INSERT INTO srp1868_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","И од тога начини уље за свето помазање, уље најбоље вештином апотекарском; то да буде уље светог помазања. ");
INSERT INTO srp1868_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","И њим помажи шатор од састанка и ковчег од сведочанства, ");
INSERT INTO srp1868_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","и сто и све справе његове, и свећњак и справе његове, и олтар кадиони, ");
INSERT INTO srp1868_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","и олтар на коме се приноси жртва паљеница, и све справе његове, и умиваоницу и подножје њено. ");
INSERT INTO srp1868_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Тако ћеш их осветити, те ће бити светиња над светињом, и шта их се год дотакне биће свето. ");
INSERT INTO srp1868_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Помажи и Арона и синове његове, и осветићеш их да ми буду свештеници. ");
INSERT INTO srp1868_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","А синовима Израиљевим кажи и реци: Ово нека ми буде уље светог помазања од колена до колена вашег. ");
INSERT INTO srp1868_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Тело човечје нека се не маже њим, нити правите такво уље какво је оно; свето је, нека вам буде свето. ");
INSERT INTO srp1868_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ако ли би ко начинио тако уље или намазао њим другог, истребиће се из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","И рече Господ Мојсију: Узми мириса, стакте, ониха и халвана мирисавог, и тамјана чистог, колико једног толико другог. ");
INSERT INTO srp1868_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","И од тога начини кад, састављен вештином апотекарском, чист и свет. ");
INSERT INTO srp1868_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","И истуцавши га наситно, метаћеш га пред сведочанством у шатору од састанка, где ћу се састајати с тобом; то нека вам буде светиња над светињама. ");
INSERT INTO srp1868_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","А такав кад какав начиниш немојте себи правити; то нека ти је светиња за Господа. ");
INSERT INTO srp1868_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ако ли би ко начинио такав да га мирише, истребиће се из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Гле, позвах по имену Веселеила сина Урије сина Оровог од племена Јудиног. ");
INSERT INTO srp1868_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","И напуних га Духа Светог, мудрости и разума и знања и сваке вештине, ");
INSERT INTO srp1868_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","да вешто измишља како се шта може начинити од злата и од сребра и од бронзе, ");
INSERT INTO srp1868_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","да уме резати камење и укивати, да уме тесати дрво, и сваки посао радити. ");
INSERT INTO srp1868_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","И ево удружих с њим Елијава, сина Ахисамаховог од племена Дановог, и сваком вештом човеку у срце дадох вештину да израде све што сам ти заповедио. ");
INSERT INTO srp1868_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Шатор од састанка, и ковчег за сведочанство и заклопац на њ, и све справе у шатору, ");
INSERT INTO srp1868_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","и сто и справе његове, и свећњак чисти са свим справама његовим, и олтар кадиони, ");
INSERT INTO srp1868_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","и олтар за жртву паљеницу са свим справама његовим, и умиваоницу и подножје њено, ");
INSERT INTO srp1868_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","и хаљине службене и свете хаљине Арону свештенику и хаљине синовима његовим, да врше службу свештеничку, ");
INSERT INTO srp1868_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","и уље помазања, и кад мирисни за светињу. Све нека начине онако како сам ти заповедио. ");
INSERT INTO srp1868_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","А ти кажи синовима Израиљевим и реци: Али суботе моје чувајте, јер је знак између мене и вас од колена до колена, да знате да сам ја Господ који вас посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Чувајте дакле суботу, јер вам је света; ко би је оскврнио, да се погуби; јер ко би год радио какав посао у њу, истребиће се она душа из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Шест дана нека се ради; а седми је дан субота, одмор, свет Господу; ко би год радио посао у дан суботни, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Зато ће чувати синови Израиљеви суботу празнујући суботу од колена до колена заветом вечним. ");
INSERT INTO srp1868_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","То је знак између мене и синова Израиљевих довека; јер је за шест дана створио Господ небо и земљу, а у седми дан почину и одмори се. ");
INSERT INTO srp1868_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","И изговоривши ово Мојсију на гори синајској, даде му две плоче сведочанства, плоче камене писане прстом Божијим. ");
INSERT INTO srp1868_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","А народ видевши где Мојсије за дуго не силази с горе, скупи се народ пред Арона, и рекоше му: Хајде, начини нам богове, који ће ићи пред нама, јер том Мојсију који нас изведе из земље мисирске не знамо шта би. ");
INSERT INTO srp1868_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","А Арон им рече: Поскидајте златне обоце што су у ушима жена ваших, синова ваших и кћери ваших, и донесите ми. ");
INSERT INTO srp1868_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","И поскида сав народ златне обоце што им беху у ушима, и донесоше Арону. ");
INSERT INTO srp1868_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","А он узевши из руку њихових, сали у калуп, и начини теле саливено. И рекоше: Ово су богови твоји, Израиљу, који те изведоше из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","А кад то виде Арон, начини олтар пред њим; и повика Арон, и рече: Сутра је празник Господњи. ");
INSERT INTO srp1868_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","И сутрадан уставши рано принесоше жртве паљенице и жртве захвалне; и поседа народ, те једоше и пише, а после усташе да играју. ");
INSERT INTO srp1868_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","А Господ рече Мојсију: Иди, сиђи, јер се поквари твој народ, који си извео из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Брзо зађоше с пута, који сам им заповедио; начинише себи теле ливено, и поклонише му се, и принесоше му жртву, и рекоше: Ово су богови твоји, Израиљу, који те изведоше из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Још рече Господ Мојсију: Погледах народ овај, и ето је народ тврдог врата. ");
INSERT INTO srp1868_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","И сада пусти ме, да се распали гнев мој на њих и да их истребим; али од тебе ћу учинити народ велик. ");
INSERT INTO srp1868_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","А Мојсије се замоли Господу Богу свом, и рече: Зашто се, Господе, распаљује гнев Твој на народ Твој, који си извео из земље мисирске силом великом и руком крепком? ");
INSERT INTO srp1868_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Зашто да говоре Мисирци и кажу: На зло их изведе, да их побије по планинама и да их истреби са земље? Поврати се од гнева свог, и пожали народ свој ода зла. ");
INSERT INTO srp1868_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Опомени се Аврама, Исака и Израиља, слуга својих, којима си се собом заклео и обрекао им: Умножићу семе ваше као звезде на небу, и земљу ову, за коју говорих, сву ћу дати семену вашем да је њихова довека. ");
INSERT INTO srp1868_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","И ражали се Господу учинити зло народу свом, које рече. ");
INSERT INTO srp1868_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Тада се врати Мојсије, и сиђе с горе са две плоче сведочанства у рукама својим; и плоче беху писане с обе стране, отуд и одовуд писане. ");
INSERT INTO srp1868_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","И беху плоче дело Божје, и писмо беше писмо Божје, урезано на плочама. ");
INSERT INTO srp1868_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","А Исус чувши вику у народу, кад викаху, рече Мојсију; вика убојна у логору. ");
INSERT INTO srp1868_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","А он рече: Није то вика како вичу који су јачи, нити је вика како вичу који су слабији, него чујем вику оних који певају. ");
INSERT INTO srp1868_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","И кад дође близу логора, угледа теле и игре, те се разгневи Мојсије, и баци из руку својих плоче, и разби их под гором. ");
INSERT INTO srp1868_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Па узе теле које беху начинили и спали га огњем, и сатре га у прах, и просу га по води, и запоји синове Израиљеве. ");
INSERT INTO srp1868_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","И рече Мојсије Арону: Шта ти је учинио овај народ, те га ували у толики грех? ");
INSERT INTO srp1868_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","А Арон му рече: Немој се гневити, господару; ти знаш овај народ да је брз на зло. ");
INSERT INTO srp1868_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Јер рекоше ми: Начини нам богове, који ће ићи пред нама, јер том Мојсију који нас изведе из земље мисирске не знамо шта би. ");
INSERT INTO srp1868_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","А ја им рекох: Ко има злата, нека га скида са себе. И дадоше ми, а ја га бацих у ватру, и изађе то теле. ");
INSERT INTO srp1868_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","А Мојсије видећи народ го, јер га оголи Арон на срамоту пред противницима његовим, ");
INSERT INTO srp1868_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","стаде Мојсије на врата од логора, и рече: К мени ко је Господњи. И скупише се пред њега сви синови Левијеви. ");
INSERT INTO srp1868_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","И рече им: Овако каже Господ Бог Израиљев: Припашите сваки свој мач уз бедро своје, па прођите тамо и амо по логору од врата до врата, и побијте сваки брата свог и пријатеља свог и ближњег свог. ");
INSERT INTO srp1868_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","И учинише синови Левијеви по заповести Мојсијевој, и погибе народа у онај дан до три хиљаде људи. ");
INSERT INTO srp1868_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Јер Мојсије рече: Посветите данас руке своје Господу, свак на сину свом и на брату свом, да би вам дао данас благослов. ");
INSERT INTO srp1868_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","А сутрадан рече Мојсије народу: Ви љуто сагрешисте; зато сада идем горе ка Господу, еда бих га умолио да вам опрости грех. ");
INSERT INTO srp1868_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","И врати се Мојсије ка Господу, и рече: Молим Ти се; народ овај љуто сагреши начинивши себи богове од злата. ");
INSERT INTO srp1868_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Али опрости им грех: Ако ли нећеш, избриши ме из књиге своје, коју си написао. ");
INSERT INTO srp1868_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","А Господ рече Мојсију: Ко ми је згрешио, оног ћу избрисати из књиге своје. ");
INSERT INTO srp1868_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","А сада иди, води тај народ куда сам ти казао. Ево, мој ће анђео ићи пред тобом, а кад их походим, походићу на њима грех њихов. ");
INSERT INTO srp1868_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","И Господ би народ зато што начинише теле, које сали Арон. ");
INSERT INTO srp1868_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","И рече Господ Мојсију: Иди, дигни се одатле ти и народ, који си извео из земље мисирске, пут земље за коју се заклех Авраму, Исаку и Јакову говорећи: Семену твом даћу је. ");
INSERT INTO srp1868_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","И послаћу пред тобом анђела, и изагнаћу Хананеје, Амореје и Хетеје и Ферезеје и Јевеје и Јевусеје. ");
INSERT INTO srp1868_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","И одвешће вас у земљу где тече млеко и мед; јер нећу сам ићи с тобом зато што си народ тврдоврат, па бих те могао сатрти путем. ");
INSERT INTO srp1868_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","А народ чувши ову злу реч ожалости се, и нико не метну на се свог накита. ");
INSERT INTO srp1868_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Јер Господ рече Мојсију: Кажи синовима Израиљевим: Ви сте народ тврдоврат; доћи ћу часом усред тебе, и истребићу те; а сада скини накит свој са себе, и знаћу шта ћу чинити с тобом. ");
INSERT INTO srp1868_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","И поскидаше са себе синови Израиљеви наките своје код горе Хорива. ");
INSERT INTO srp1868_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","А Мојсије узе шатор и разапе га себи иза логора далеко, и назва га шатор од састанка, и ко год тражаше Господа, долажаше к шатору од састанка иза логора. ");
INSERT INTO srp1868_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","И кад Мојсије иђаше у шатор, сав народ устајаше, и свак стајаше на вратима свог шатора, и гледаху за Мојсијем док не уђе у шатор. ");
INSERT INTO srp1868_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","А кад Мојсије улажаше у шатор, спушташе се ступ од облака и устављаше се на вратима од шатора, и Господ говораше с Мојсијем. ");
INSERT INTO srp1868_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","И сав народ видећи ступ од облака где стоји на вратима од шатора, устајаше сав народ, и свак се клањаше на вратима од свог шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","И Господ говораше с Мојсијем лицем к лицу као што говори човек с пријатељем својим. Потом се враћаше Мојсије у логор, а слуга његов Исус син Навин, момак, не излажаше из шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","И рече Мојсије Господу: Гледај, Ти ми кажеш: Води тај народ. А ниси ми казао кога ћеш послати са мном, а рекао си: Знам те по имену и нашао си милост преда мном. ");
INSERT INTO srp1868_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ако сам дакле нашао милост пред Тобом, покажи ми пут свој, да Те познам и нађем милост пред Тобом; и види да је овај народ Твој народ. ");
INSERT INTO srp1868_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","И рече Господ: Моје ће лице ићи напред, и даћу ти одмор. ");
INSERT INTO srp1868_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","А Мојсије му рече: Ако неће ићи напред лице Твоје, немој нас кретати одавде. ");
INSERT INTO srp1868_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Јер по чему ће се познати да смо нашли милост пред Тобом, ја и народ Твој? Зар не по томе што Ти идеш с нама? Тако ћемо се разликовати ја и народ Твој од сваког народа на земљи. ");
INSERT INTO srp1868_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","А Господ рече Мојсију: Учинићу и то што си казао, јер си нашао милост преда мном и знам те по имену. ");
INSERT INTO srp1868_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Опет рече Мојсије: Молим Те, покажи ми славу своју. ");
INSERT INTO srp1868_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","А Господ му рече: Учинићу да прође све добро моје испред тебе, и повикаћу по имену: Господ пред тобом. Смиловаћу се коме се смилујем, и пожалићу кога пожалим. ");
INSERT INTO srp1868_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","И рече: Али нећеш моћи видети лице моје, јер не може човек мене видети и остати жив. ");
INSERT INTO srp1868_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","И рече Господ: Ево место код мене, па стани на стену. ");
INSERT INTO srp1868_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","И кад стане пролазити слава моја, метнућу те у раселину камену, и заклонићу те руком својом док не прођем. ");
INSERT INTO srp1868_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Потом ћу дигнути руку своју, и видећеш ме с леђа, а лице се моје не може видети. ");
INSERT INTO srp1868_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","И рече Господ Мојсију: Истеши себи две плоче од камена као што су биле прве, да напишем на тим плочама речи које су биле на првим плочама, које си разбио. ");
INSERT INTO srp1868_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","И буди готов за сутра да рано изађеш на гору синајску, и станеш преда ме на врх горе. ");
INSERT INTO srp1868_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Али нека нико не иде с тобом, и нико нека се не покаже на свој гори, ни овце ни говеда да не пасу близу горе. ");
INSERT INTO srp1868_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","И истеса Мојсије две плоче од камена као што су биле прве, и уставши рано изађе на гору синајску, као што му заповеди Господ, и узе у руку своју две плоче камене. ");
INSERT INTO srp1868_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","А Господ сиђе у облаку, и стаде онде с њим, и повика по имену: Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Јер пролазећи Господ испред њега викаше: Господ, Господ, Бог милостив, жалостив, спор на гнев и обилан милосрђем и истином. ");
INSERT INTO srp1868_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Који чува милост хиљадама, прашта безакоња и неправде и грехе, који не правда кривога, и походи грехе отачке на синовима и на унуцима до трећег и четвртог колена. ");
INSERT INTO srp1868_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","А Мојсије брже сави главу до земље и поклони се, ");
INSERT INTO srp1868_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","и рече: Ако сам нашао милост пред Тобом, Господе, нека иде Господ посред нас, јер је народ тврдоврат: и опрости нам безакоње наше и грех наш, и узми нас за наследство. ");
INSERT INTO srp1868_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","А Он рече: Ево постављам завет; пред целим народом твојим учинићу чудеса, која нису учињена нигде на земљи ни у коме народу, и видећете дело Господње сав народ, међу којим си, јер ће бити страшно шта ћу ја учинити с тобом. ");
INSERT INTO srp1868_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Држи шта ти данас заповедам; ево, ја ћу изагнати испред тебе Амореје и Хананеје и Хетеје и Ферезеје и Јевеје и Јевусеје. ");
INSERT INTO srp1868_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Чувај се да не хваташ вере с онима који живе у земљи у коју ћеш доћи, да ти не буду замка усред тебе. ");
INSERT INTO srp1868_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Него олтаре њихове оборите, и ликове њихове изломите, и гајеве њихове исеците. ");
INSERT INTO srp1868_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Јер не ваља да се клањаш другом Богу: јер се Господ зове ревнитељ, Бог је ревнитељ. ");
INSERT INTO srp1868_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Немој хватати вере с онима који живе у оној земљи, да не би чинећи прељубу за боговима својим и приносећи жртву боговима својим позвали те, и ти јео жртве њихове. ");
INSERT INTO srp1868_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","И да не би кћерима њиховим женио синове своје, и да не би кћери њихове чинећи прељубу за боговима својим учиниле да синови твоји чине прељубу за боговима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ливене богове не гради себи. ");
INSERT INTO srp1868_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Празник пресних хлебова држи; седам дана једи пресне хлебове, као што сам ти заповедио, на време, месеца Авива, јер си тог месеца изашао из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Све што отвара материцу моје је, и свако мушко у стоци твојој што отвара материцу, говече или ситна стока. ");
INSERT INTO srp1868_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Али магаре које отвори материцу откупи јагњетом или јаретом; ако ли га не би откупио, сломи му врат; и сваког првенца између синова својих откупи; и да се нико не покаже празан преда мном. ");
INSERT INTO srp1868_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Шест дана ради, а у седми дан почини, и од орања и од жетве почини. ");
INSERT INTO srp1868_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Празнуј празник седмица, првина жетве пшеничне, и празник бербе на свршетку године. ");
INSERT INTO srp1868_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Три пута у години да се свако мушко између вас покаже пред Господом Богом Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Јер ћу изагнати народе испред тебе, и међе твоје раширићу, и нико неће пожелети земље твоје, кад станеш долазити да се покажеш пред Господом Богом својим три пута у години. ");
INSERT INTO srp1868_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Немој приносити крв од жртве моје уз хлебове киселе, и да не преноћи до јутра жртва празника пасхе. ");
INSERT INTO srp1868_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Првине од првог рода земље своје донеси у кућу Господа Бога свог; немој кувати јаре у млеку мајке његове. ");
INSERT INTO srp1868_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","И рече Господ Мојсију: Напиши себи те речи; јер по тим речима учиних завет с тобом и с Израиљем. ");
INSERT INTO srp1868_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","И Мојсије оста онде код Господа четрдесет дана и четрдесет ноћи, хлеба не једући ни воде пијући; и написа Господ на плоче речи завета, десет речи. ");
INSERT INTO srp1868_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","И кад Мојсије силажаше с горе синајске, и држаше у руци две плоче сведочанства силазећи с горе, не знаше да му кожа на лицу поста светла докле говораше с њим. ");
INSERT INTO srp1868_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","И виде Арон и сви синови Израиљеви Мојсија, а то му се светли кожа на лицу, и не смеше приступити к њему. ");
INSERT INTO srp1868_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Али их зовну Мојсије, и вратише се к њему Арон и сви главари у збору, и говори с њима Мојсије. ");
INSERT INTO srp1868_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Потом приступише сви синови Израиљеви, и заповеди им све што му каза Господ на гори синајској. ");
INSERT INTO srp1868_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","А кад им Мојсије изговори, застре лице своје покривалом. ");
INSERT INTO srp1868_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Али кад Мојсије долажаше пред Господа да с Њим говори, скидаше покривало докле не би изашао; а изашавши казиваше синовима Израиљевим шта му се заповедаше. ");
INSERT INTO srp1868_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Тада виђаху синови Израиљеви лице Мојсијево, где се светли кожа на лицу његовом, те Мојсије опет застираше покривалом лице своје докле не би опет ушао да говори с Њим. ");
INSERT INTO srp1868_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Потом сабра Мојсије сав збор синова Израиљевих, и рече им: Ово је заповедио Господ да чините: ");
INSERT INTO srp1868_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Шест дана да се ради, а седми да вам је свет, субота почивања Господњег; ко би радио у тај дан, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ватре не ложите по становима својим у дан суботни. ");
INSERT INTO srp1868_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Још рече Мојсије свему збору синова Израиљевих говорећи: Ово је заповедио Господ и рекао: ");
INSERT INTO srp1868_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Скупите између себе прилог Господу; ко год хоће драге воље, нека донесе прилог Господу: злато и сребро и бронзу, ");
INSERT INTO srp1868_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","и порфиру и скерлет и црвац и танко платно и кострет, ");
INSERT INTO srp1868_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","и коже овнујске црвене обојене и коже јазавичије и дрво ситим, ");
INSERT INTO srp1868_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","и уље за видело, и мирисе за уље помазања и за кад мирисни, ");
INSERT INTO srp1868_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","и камење онихово, и камење за укивање по оплећку и по напрснику. ");
INSERT INTO srp1868_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","И који су год вешти међу вама нека дођу да раде шта је заповедио Господ: ");
INSERT INTO srp1868_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Шатор, и наслон његов, и покривач његов, и куке његове, и даске његове, преворнице његове, ступове његове и стопице његове, ");
INSERT INTO srp1868_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ковчег, и полуге његове, и заклопац, и завес, ");
INSERT INTO srp1868_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","сто, и полуге његове и све справе његове, и хлеб за постављање, ");
INSERT INTO srp1868_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","и свећњак за видело са справама његовим, и жишке његове, и уље за видело, ");
INSERT INTO srp1868_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","и олтар кадиони, и полуге његове, и уље помазања, и кад мирисни, и завес на врата од шатора, ");
INSERT INTO srp1868_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","олтар за жртву паљеницу, и решетку његову од бронзе, полуге његове и све справе његове, умиваоницу и подножје њено, ");
INSERT INTO srp1868_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","завесе за трем, ступове његове и стопице његове, и завес на врата од трема, ");
INSERT INTO srp1868_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","коље за шатор, и коље за трем с ужима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Хаљине службене за службу у светињи, и хаљине свете Арону свештенику, и хаљине синовима његовим за службу свештеничку. ");
INSERT INTO srp1868_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Тада отиде сав збор синова Израиљевих од Мојсија; ");
INSERT INTO srp1868_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","и вратише се, сваки ког подиже срце његово и кога год дух покрете драговољно, и донесоше прилог Господу за грађење шатора од састанка и за сву службу у њему и за хаљине свете. ");
INSERT INTO srp1868_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Долазише људи и жене, ко год беше драговољног срца, и доносише споне и обоце и прстење и наруквице и свакојаке наките златне; и сваки донесе прилог злата Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ко год имаше порфире, скерлета, црвца, танког платна, кострети, кожа овнујских црвених обојених и кожа јазавичијих, сваки доношаше. ");
INSERT INTO srp1868_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","И ко год прилагаше сребро или бронзу, доношаше у прилог Господу; и у кога год беше дрвета ситима, за сваку употребу у служби доношаше. ");
INSERT INTO srp1868_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","И све жене веште предоше својим рукама, и доносише шта напредоше за порфиру, скерлет, црвац и танко платно. ");
INSERT INTO srp1868_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","И све жене које подиже срце њихово и беху веште, предоше кострет. ");
INSERT INTO srp1868_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","А главари доносише камење онихово и камење за укивање по оплећку и по напрснику, ");
INSERT INTO srp1868_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","и мирисе и уље за видело и уље за помазање и за кад мирисни. ");
INSERT INTO srp1868_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Сви људи и жене, које подиже драговољно срце да доносе шта треба за све дело које Господ заповеди преко Мојсија да се начини, донесоше синови Израиљеви драговољни прилог Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Тада рече Мојсије синовима Израиљевим: Видите, Господ позва по имену Веселеила сина Урије сина Оровог од племена Јудиног, ");
INSERT INTO srp1868_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","и напуни га духа Божијег, мудрости, разума и знања и вештине за сваки посао, ");
INSERT INTO srp1868_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","да вешто измишља како се шта ради од злата и сребра и од бронзе, ");
INSERT INTO srp1868_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","да уме резати камење и укивати, да уме тесати дрво и радити сваки посао врло вешто. ");
INSERT INTO srp1868_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","И даде му у срце, њему и Елијаву сину Ахисамаховом од племена Дановог, да могу учити друге. ");
INSERT INTO srp1868_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Напуни их вештине да раде сваки посао, да кују, тешу, везу, и ткају порфиру, скерлет, црвац и танко платно, и да раде свакојаке послове вешто измишљајући. ");
INSERT INTO srp1868_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","И стаде радити Веселеило и Елијав и сви људи вешти, којима беше Господ дао мудрост и разум да умеју радити сваки посао за службу у светињи, и све што је заповедио Господ. ");
INSERT INTO srp1868_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","И позва Мојсије Веселеила и Елијава и све људе веште, којима Господ даде мудрост у срце, које год подиже срце њихово да дођу да раде тај посао. ");
INSERT INTO srp1868_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","И узеше од Мојсија све прилоге, које донесоше синови Израиљеви да се уради дело за службу у светињи. Али још доношаху к њему драговољне прилоге свако јутро. ");
INSERT INTO srp1868_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Тада дођоше сви вешти људи, који рађаху дело за светињу, сваки од свог посла, који рађаху, ");
INSERT INTO srp1868_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","и рекоше Мојсију говорећи: Више доноси народ него што треба да се уради дело, које је Господ заповедио да се уради. ");
INSERT INTO srp1868_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","И заповеди Мојсије да се огласи по логору говорећи: Ни човек ни жена да не доноси више прилоге за светињу. И забрани се народу да не доноси. ");
INSERT INTO srp1868_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Јер беше свега доста да се уради све дело, и још претецаше. ");
INSERT INTO srp1868_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","И људи вешти између оних, који радише ово дело, начинише шатор од десет завеса од танког платна узведеног и од порфире и од скерлета и од црвца, с херувимима, вешто везеним начинише. ");
INSERT INTO srp1868_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","У дужину беше један завес од двадесет и осам лаката а у ширину од четири лакта; сви завеси беху једне мере. ");
INSERT INTO srp1868_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","И саставише пет завеса један с другим, и пет других завеса саставише један с другим. ");
INSERT INTO srp1868_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","И начинише петље од порфире по крају првог завеса на оној страни где ће се саставити с другим; и тако начинише на сваком завесу по крају где ће се саставити с другим. ");
INSERT INTO srp1868_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Педесет петаља начинише на првом завесу, и педесет петаља начинише на крају сваког завеса где се саставља с другим; петље беху једна према другој. ");
INSERT INTO srp1868_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","И начинише педесет златних кука, и саставише кукама завесе један с другим; тако се шатор састави. ");
INSERT INTO srp1868_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","И начинише завесе од кострети за наслон над шатором; једанаест таквих завеса начинише. ");
INSERT INTO srp1868_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","У дужину беше један завес од тридесет лаката а у ширину од четири лакта; једне мере беше свих једанаест завеса. ");
INSERT INTO srp1868_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","И саставише пет завеса заједно, а других шест завеса заједно. ");
INSERT INTO srp1868_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","И начинише педесет петаља по крају једног завеса где се саставља са другим, и педесет петаља начинише по крају другог завеса да се састави. ");
INSERT INTO srp1868_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","И начинише педесет кука од бронзе да се састави наслон. ");
INSERT INTO srp1868_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","И начинише покривач на наслон од кожа овнујских црвених обојених, и покривач од кожа јазавичијих озго. ");
INSERT INTO srp1868_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","И начинише даске шатору од дрвета ситима, које ће стајати право. ");
INSERT INTO srp1868_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Даска беше дуга десет лаката а подруг лакта широка свака даска. ");
INSERT INTO srp1868_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","По два чепа беху на дасци, један према другом; тако начинише на свим даскама за шатор. ");
INSERT INTO srp1868_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","А ових дасака за шатор начинише двадесет дасака за јужну страну; ");
INSERT INTO srp1868_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","и четрдесет стопица сребрних начинише под двадесет дасака, две стопице под једну даску за два чепа њена, а две стопице под другу даску за два чепа њена. ");
INSERT INTO srp1868_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Тако и на другој страни шатора, према северу, начинише двадесет дасака, ");
INSERT INTO srp1868_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","и четрдесет стопица сребрних под њих, две стопице под једну даску а две стопице под другу даску. ");
INSERT INTO srp1868_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","А на западној страни шатора начинише шест дасака; ");
INSERT INTO srp1868_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","и још две даске начинише на углове шатору с обе стране; ");
INSERT INTO srp1868_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","оне беху састављене оздо, и беху састављене озго биочугом; тако начинише с обе стране на два угла. ");
INSERT INTO srp1868_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","И тако беше осам дасака и шеснаест стопица њихових сребрних, по две стопице под сваку даску. ");
INSERT INTO srp1868_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","И начинише преворнице од дрвета ситима: пет за даске на једној страни шатора, ");
INSERT INTO srp1868_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","и пет преворница за даске на другој страни шатора, и пет преворница за даске на западној страни шатора до оба угла. ");
INSERT INTO srp1868_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","И начинише преворницу средњу да иде преко среде дасака од једног краја до другог. ");
INSERT INTO srp1868_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","А даске оковаше златом, и биочуге на њих начинише од злата, да у њима стоје преворнице, и оковаше златом преворнице. ");
INSERT INTO srp1868_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","И начинише завес од порфире и од скерлета и од црвца и од танког платна узведеног, с херувимима вешто везеним начинише га. ");
INSERT INTO srp1868_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","И начинише за њ четири ступа од дрвета ситима, и оковаше их златом, а куке на њима беху од злата, и салише им четири стопице од сребра. ");
INSERT INTO srp1868_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","И начинише завес на врата наслону од порфире и од скерлета и од црвца и од танког платна узведеног везен, ");
INSERT INTO srp1868_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","и пет ступова за њ с кукама њиховим, и врхове им и појасе оковаше златом, и пет стопица под њих од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","И начини Веселеило ковчег од дрвета ситима, два и по лакта дуг и подруг лакта широк и подруг лакта висок. ");
INSERT INTO srp1868_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","И покова га чистим златом изнутра и споља; и начини му златан венац унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","И сали му четири биочуга од злата на четири угла његова: два биочуга с једне стране а два с друге. ");
INSERT INTO srp1868_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","И начини полуге од дрвета ситима, и окова их златом. ");
INSERT INTO srp1868_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","И провуче полуге кроз биочуге с обе стране ковчегу, да се може носити ковчег. ");
INSERT INTO srp1868_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","И начини заклопац од чистог злата, у дужину од два и по лакта, а у ширину од подруг лакта. ");
INSERT INTO srp1868_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","И начини два херувима од злата, једноставне начини их, на два краја заклопцу, ");
INSERT INTO srp1868_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","једног херувима на крају одовуд, а другог херувима на крају одонуд; заклопцу на оба краја начини херувиме. ");
INSERT INTO srp1868_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","И у херувима беху крила раширена у вис, и заклањаху крилима својим заклопац, и лицем беху окренути један другом, и гледаху према заклопцу херувими. ");
INSERT INTO srp1868_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","И начини сто од дрвета ситима, у дужину од два лакта а у ширину од лакта, и од подруг лакта у висину. ");
INSERT INTO srp1868_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","И покова га чистим златом, и начини му венац златан унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","И начини му оплату с подланице унаоколо, и начини венац златан уз оплату унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","И сали му четири биочуга од злата, и метну биочуге на четири угла, који му беху на четири ноге. ");
INSERT INTO srp1868_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Према оплати беху биочузи, а у њима полуге, да се може носити сто. ");
INSERT INTO srp1868_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","А полуге начини од дрвета ситима, и окова их златом, да се може носити сто. ");
INSERT INTO srp1868_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","И начини од чистог злата посуђе што се меће на сто: зделе и чаше и котлиће и ведра, којим ће се преливати. ");
INSERT INTO srp1868_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","И начини свећњак од чистог злата, једноставан начини свећњак; ступ му и гране, чашице и јабуке и цветови излажаху из њега. ");
INSERT INTO srp1868_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Шест грана излажаху му са страна; три гране свећњака с једне стране а три гране свећњака с друге стране; ");
INSERT INTO srp1868_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","три чашице као бадем на једној грани и јабука и цвет, а три чашице као бадем на другој грани и јабука и цвет; тако на свих шест грана које излажаху из свећњака. ");
INSERT INTO srp1868_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","А на самом свећњаку беху четири чашице као бадем са својим јабукама и цветовима, ");
INSERT INTO srp1868_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","једна јабука беше под две гране из њега, и једна јабука под друге две гране из њега, и једна јабука под друге две гране из њега; тако под шест грана које излажаху из њега. ");
INSERT INTO srp1868_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Јабуке њихове и гране им излажаху из њега, све беше од чистог злата једноставно. ");
INSERT INTO srp1868_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","И начини му седам жижака и усекаче и спремице за гар од чистог злата. ");
INSERT INTO srp1868_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Од таланта чистог злата начини га са свим справама његовим. ");
INSERT INTO srp1868_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","И начини олтар кадиони од дрвета ситима у дужину од једног лакта, и у ширину од једног лакта, четвороугласт, и од два лакта у висину; из њега излажаху му рогови. ");
INSERT INTO srp1868_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","И покова га чистим златом озго и са стране унаоколо, и рогове; и начини му венац од злата унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","И два биочуга од злата начини му испод венца на два угла његова с обе стране, да у њима стоје полуге да се може носити о њима. ");
INSERT INTO srp1868_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","А полуге начини од дрвета ситима, и окова их златом. ");
INSERT INTO srp1868_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","И начини уље за свето помазање и чисти кад мирисни вештином апотекарском. ");
INSERT INTO srp1868_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","И начини од дрвета ситима олтар за жртве паљенице у дужину од пет лаката, и у ширину од пет лаката, четвороугласт, висок три лакта. ");
INSERT INTO srp1868_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","И начини му на четири угла његова рогове; из њега излажаху рогови, и окова га у бронзу. ");
INSERT INTO srp1868_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","И начини све посуђе за олтар, лонце и лопатице и котлиће и виљушке и клешта; све му посуђе начини од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","И начини олтару решетку као мрежу од бронзе испод олтара унаоколо ода дна до средине. ");
INSERT INTO srp1868_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","И сали четири биочуга за четири угла решетке бронзане, да се кроз њих провуку полуге. ");
INSERT INTO srp1868_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","А полуге начини од дрвета ситима, и окова их у бронзу. ");
INSERT INTO srp1868_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","И провуче полуге кроз биочуге с обе стране олтара, да се може носити, од дасака начини га шупљег. ");
INSERT INTO srp1868_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","И начини умиваоницу бронзану и подножје јој бронзано од огледала која доношаху гомилама жене долазећи на врата шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","И начини трем на јужној страни, и завесе трему од танког платна узведеног од сто лаката, ");
INSERT INTO srp1868_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","и двадесет ступова за њих и двадесет стопица под њих од бронзе, а куке на ступове и преворнице од сребра. ");
INSERT INTO srp1868_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Тако и на северној страни завесе од сто лаката, двадесет ступова за њих и двадесет стопица под њих од бронзе; а куке на ступове и преворнице њихове од сребра; ");
INSERT INTO srp1868_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","а на западној страни завесе од педесет лаката, десет ступова за њих и десет стопица њихових од бронзе, куке на ступовима и појасеве њихове од сребра; ");
INSERT INTO srp1868_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","а на предњој страни према истоку завесе од педесет лаката; ");
INSERT INTO srp1868_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","с једне стране завесе од петнаест лаката, три ступа за њих и три стопице под њих; ");
INSERT INTO srp1868_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","а с друге стране, до врата од трема и отуда и одовуда, завесе од петнаест лаката, три ступа за њих и три стопице под њих. ");
INSERT INTO srp1868_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Сви завеси на трему унаоколо беху од танког платна узведеног; ");
INSERT INTO srp1868_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","а стопице под ступовима од бронзе, куке на ступовима и појасеви на њима од сребра; и врхови им беху сребрни; сви ступови у трему беху опасани сребром. ");
INSERT INTO srp1868_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","А завес на вратима од трема беше од порфире и од скерлета и од црвца и од танког платна узведеног, везен, у дужину од двадесет лаката а у висину по ширини пет лаката, као и други завеси у трему. ");
INSERT INTO srp1868_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","И четири ступа за њ, и четири стопице под њих од бронзе, чепови на њима од сребра и врхови им и појасеви од сребра. ");
INSERT INTO srp1868_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","А све коље шатору и трему унаоколо беше од бронзе. ");
INSERT INTO srp1868_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Те су ствари пребројане за шатор, шатор од сведочанства, које је пребројао по заповести Мојсијевој Итамар, син Арона свештеника за службу левитску. ");
INSERT INTO srp1868_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","А Веселеило, син Урије сина Оровог од племена Јудиног, начини све то што заповеди Господ Мојсију, ");
INSERT INTO srp1868_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","и с њим Елијав, син Ахисамахов од племена Дановог, дрводеља и вешт ткати и вести по порфири, по скерлету, по црвцу и по танком платну. ");
INSERT INTO srp1868_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","А свега злата што отиде на ово дело, на све дело за светињу, које злато беше приложено, свега га беше двадесет и девет таланата, седам стотина и тридесет сикала, по светом сиклу; ");
INSERT INTO srp1868_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","а сребра што дође од збора, сто таланата, и хиљада седам стотина и седамдесет и пет сикала, по светом сиклу; ");
INSERT INTO srp1868_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","пола сикла од главе, по сиклу светом, од сваког који уђе у број, од двадесет година и више, од шест стотина и три хиљаде и пет стотина и педесет. ");
INSERT INTO srp1868_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Од сто таланата сребра салише се стопице за светињу и стопице за завес; сто стопица од сто таланата, таланат на стопицу. ");
INSERT INTO srp1868_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","А од хиљаду и седам стотина и седамдесет и пет сикала начини куке на ступове, и окова им врхове и опаса их. ");
INSERT INTO srp1868_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","А бронзе приложене беше седамдесет таланата, и две хиљаде и четири стотине сикала. ");
INSERT INTO srp1868_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","И од тога начини стопице на вратима шатора од састанка, и бронзани олтар и решетку бронзану за њ, и све справе за олтар, ");
INSERT INTO srp1868_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","и стопице у трему унаоколо, и стопице на вратима од трема, и све коље за шатор и све коље за трем унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","А од порфире и скерлета и црвца начинише хаљине за службу, да се служи у светињи; и начинише свете хаљине Арону, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Начинише оплећак од злата, и од порфире и од скерлета и од црвца и од танког платна узведеног. ");
INSERT INTO srp1868_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Истеглише листове од злата, и исекоше жице, те извезоше порфиру и скерлет и црвац и танко платно врло вешто. ");
INSERT INTO srp1868_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Пораменице му начинише да се састављају, да се саставља на два краја своја. ");
INSERT INTO srp1868_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","И појас на оплећку излажаше од њега и беше исте направе, од злата и од порфире и од скерлета и од црвца и од танког платна узведеног; као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","И уковаше два камена ониха у злато, и изрезаше на њима имена синова Израиљевих, као што се режу печати. ");
INSERT INTO srp1868_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","И ударише их на пораменице од оплећка, да буду камени за спомен синовима Израиљевим, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","И начинише напрсник врло веште направе као што је направа у оплећка, од злата и од порфире и од скерлета и од црвца и од танког платна узведеног; ");
INSERT INTO srp1868_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","четвороугласт и двострук начинише напрсник, у дужину с педи и у ширину с педи, двострук. ");
INSERT INTO srp1868_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","И ударише по њему четири реда камења; у првом реду: сардоникс, топаз и смарагд; ");
INSERT INTO srp1868_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","а у другом реду: карбункул, сафир и дијамант; ");
INSERT INTO srp1868_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","а у трећем реду: лигур, ахат и аметист; ");
INSERT INTO srp1868_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","а у четвртом реду: хрисолит, оних и јаспис, све опточено златом у својим редовима. ");
INSERT INTO srp1868_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Тих камена с именима синова Израиљевих беше дванаест према њиховим именима, резани као печати, за дванаест племена, свако по свом имену. ");
INSERT INTO srp1868_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","И начинише на напрсник ланце једнаке, плетене, од чистог злата. ");
INSERT INTO srp1868_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","И начинише две копче златне и две гривне златне, и метнуше те две гривне на два краја напрснику, ");
INSERT INTO srp1868_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","и провукоше два златна ланца кроз две гривне на крајевима напрснику, ");
INSERT INTO srp1868_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","а друга два краја од два ланца запеше за две копче, и притврдише их за пораменице на оплећку спред. ");
INSERT INTO srp1868_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","И начинише још две златне гривне, и метнуше их на два краја напрснику, на страни према оплећку изнутра. ");
INSERT INTO srp1868_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","И начинише још две гривне златне, које метнуше на две пораменице на оплећку оздо напред где се саставља, више појаса на оплећку. ");
INSERT INTO srp1868_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Тако привезаше напрсник кроз гривне на њему и гривне на оплећку врпцом од порфире, да стоји сврх појаса од оплећка и да се не раздваја напрсник од оплећка, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","И начинише плашт под оплећак, ткан, сав од порфире. ");
INSERT INTO srp1868_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","И прорез на плашту у среди као прорез на оклопу, и око прореза оплату да се не раздре. ");
INSERT INTO srp1868_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","И начинише по скуту од плашта шипке од порфире и од скерлета и од црвца и од танког платна узведеног. ");
INSERT INTO srp1868_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","И начинише звонца од чистог злата, и метнуше звонца међу шипке, по скуту од плашта унаоколо између шипака. ");
INSERT INTO srp1868_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Звонце па шипак, звонце па шипак по скуту од плашта унаоколо, за службу, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","И начинише кошуље од танког платна изметаног Арону и синовима његовим; ");
INSERT INTO srp1868_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","и капу од танког платна, и капице кићене од танког платна, и гаће платнене од танког платна узведеног; ");
INSERT INTO srp1868_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","и појас од танког платна узведеног и од порфире и од скерлета и од црвца, везен, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","И начинише плочицу за свето оглавље од чистог злата, и написаше на њој писмом како се реже на печатима: Светиња Господу. ");
INSERT INTO srp1868_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","И притврдише за њу врпцу од порфире да се веже за капу озго, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","И тако се сврши сав посао око шатора и наслона од састанка. И начинише синови Израиљеви све; како беше заповедио Господ Мојсију, тако начинише. ");
INSERT INTO srp1868_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","И донесоше к Мојсију шатор, наслон и све справе његове, куке, даске, преворнице, ступове и стопице, ");
INSERT INTO srp1868_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","и покривач од кожа овнујских црвених обојених и покривач од кожа јазавичијих, и завес, ");
INSERT INTO srp1868_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","и ковчег од сведочанства и полуге за њ, и заклопац, ");
INSERT INTO srp1868_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","сто са свим справама, и хлеб за постављање, ");
INSERT INTO srp1868_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","свећњак чисти, жишке његове, жишке наређане, и све справе његове, и уље за видело. ");
INSERT INTO srp1868_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","И олтар златни, и уље помазања, и кад мирисни, и завес на врата од шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Олтар бронзани и решетку бронзану за њ, полуге његове и све справе његове, умиваоницу и подножје њено, ");
INSERT INTO srp1868_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","завесе за трем, ступове за њих и стопице њихове, и завес на врата од трема, ужа његова и коље његово, и све справе за службу у шатору, за шатор од састанка. ");
INSERT INTO srp1868_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Хаљине за службу, да се служи у светињи, хаљине свете Арону свештенику и хаљине синовима његовим, да врше службу свештеничку. ");
INSERT INTO srp1868_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Све како беше заповедио Господ Мојсију, онако урадише синови Израиљеви све ово дело. ");
INSERT INTO srp1868_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","И погледа Мојсије све то дело, и гле, начинише га, као што беше заповедио Господ, тако га начинише; и благослови их Мојсије. ");
INSERT INTO srp1868_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","И Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Први дан првог месеца подигни шатор, шатор од састанка, ");
INSERT INTO srp1868_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","и метни онде ковчег од сведочанства, и заклони га завесом. ");
INSERT INTO srp1868_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","И унеси сто, и уреди шта треба уредити на њему; унеси и свећњак, и запали жишке на њему. ");
INSERT INTO srp1868_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","И намести златни олтар кадиони пред ковчегом од сведочанства; и обеси завес на вратима од шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","И метни олтар за жртву паљеницу пред врата шатору, шатору од састанка, ");
INSERT INTO srp1868_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","и метни умиваоницу између шатора од састанка и олтара, и у њу налиј воде. ");
INSERT INTO srp1868_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","И подигни трем унаоколо, и метни завес на врата од трема. ");
INSERT INTO srp1868_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","И узми уље помазања, и помажи шатор и све што је у њему, и освети га и све справе његове, и биће свет. ");
INSERT INTO srp1868_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Помажи и олтар за жртву паљеницу и све справе његове, те ћеш осветити олтар, и олтар ће бити светиња над светињом. ");
INSERT INTO srp1868_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Помажи и умиваоницу и подножје њено, и освети је. ");
INSERT INTO srp1868_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","И кажи Арону и синовима његовим да приступе на врата шатора од састанка, и умиј их водом; ");
INSERT INTO srp1868_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","и обуци Арона у свете хаљине и помажи га и освештај га, да ми врши службу свештеничку. ");
INSERT INTO srp1868_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","И синовима његовим заповеди нека ми приступе, и обуци им кошуље. ");
INSERT INTO srp1868_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","И помажи их, као што помажеш оца њиховог, да ми врше службу свештеничку; и помазање њихово биће им, за вечно свештенство од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","И учини Мојсије све, како му заповеди Господ тако учини. ");
INSERT INTO srp1868_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","И подиже се шатор друге године првог месеца први дан. ");
INSERT INTO srp1868_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","И Мојсије подиже шатор, и подметну му стопице, и намести даске, и повуче преворнице, и исправи ступове. ");
INSERT INTO srp1868_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Па разапе наслон над шатор, и метну покривач на наслон озго, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","И узевши сведочанство метну га у ковчег, и провуче полуге на ковчегу, и метну заклопац озго на ковчег. ");
INSERT INTO srp1868_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","И унесе ковчег у шатор, и обеси завес, те заклони ковчег са сведочанством, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","И намести сто у шатору од састанка на северну страну шатора пред завесом, ");
INSERT INTO srp1868_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","и постави на њему хлеб пред Господом као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","И намести свећњак у шатору од састанка, према столу на јужну страну шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","И запали жишке на њему пред Господом, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","И намести олтар златни у шатору од сведочанства пред завесом. ");
INSERT INTO srp1868_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","И покади на њему кадом мирисним, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","И обеси завес на врата од шатора. ");
INSERT INTO srp1868_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","И олтар за жртву паљеницу намести на врата од шатора, шатора од састанка, и принесе на њему жртву паљеницу, и дар, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","И метну умиваоницу између шатора од састанка и олтара, и нали у њу воде за умивање. ");
INSERT INTO srp1868_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","И праше из ње руке и ноге своје Мојсије и Арон и синови његови. ");
INSERT INTO srp1868_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Кад улажаху у шатор од сведочанства и кад приступаху к олтару, умиваху се најпре, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","И подиже трем око шатора и олтара, и метну завес на врата трему. Тако сврши Мојсије посао тај. ");
INSERT INTO srp1868_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Тада облак покри шатор од састанка, и напуни се шатор славе Господње. ");
INSERT INTO srp1868_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","И не могаше Мојсије ући у шатор од састанка, јер беше на њему облак, и славе Господње беше пун шатор. ");
INSERT INTO srp1868_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","А кад се подизаше облак са шатора, тада полажаху синови Израиљеви, докле год путоваху. ");
INSERT INTO srp1868_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","А кад се не подизаше облак, онда ни они не полажаху до дана кад се подиже. ");
INSERT INTO srp1868_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Јер облак Господњи беше на шатору дању, а ноћу огањ беше на њему пред очима свега дома Израиљевог, докле год путоваху. ");
INSERT INTO srp1868_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","И викну Господ Мојсија, и рече му из шатора од састанка говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Кажи синовима Израиљевим, и реци им: Кад ко између вас хоће да принесе Господу жртву од стоке, принесите жртву своју од говеда или од оваца или од коза. ");
INSERT INTO srp1868_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ако му је жртва паљеница од говеда, нека принесе мушко, здраво; на вратима шатора од састанка нека је принесе драге воље пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","И нека метне руку своју на главу жртви паљеници, и примиће му се, и очистиће га од греха. ");
INSERT INTO srp1868_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","И нека закоље теле пред Господом, и нека синови Аронови свештеници принесу крв, и покропе олтар крвљу одозго унаоколо, који је пред вратима шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Потом нека се одре жртва паљеница и нека се расече на делове. ");
INSERT INTO srp1868_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","И синови Аронови, свештеници нека наложе огањ на олтару, и метну дрва на огањ. ");
INSERT INTO srp1868_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Па онда синови Аронови свештеници нека наместе делове, главу и сало на дрва на огњу, који је на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","А црева и ноге нека се оперу водом; и свештеник нека запали све то на олтару; то је жртва паљеница, жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ако ли би хтео принети жртву паљеницу од ситне стоке, од оваца или од коза, нека принесе мушко, здраво. ");
INSERT INTO srp1868_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","И нека се закоље на северној страни олтара пред Господом, и синови Аронови свештеници нека покропе крвљу олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","И нека се расече на делове с главом и са салом, и свештеник нека то намести на дрва на огњу, који је на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","А црева и ноге нека се оперу водом; и свештеник нека принесе све то и нека запали на олтару; то је жртва паљеница, жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ако ли хоће да принесе птицу Господу на жртву паљеницу, нека принесе жртву од грлица или од голубића. ");
INSERT INTO srp1868_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","И свештеник нека је метне на олтар, и главу нека јој засече ноктом, и запали на олтару исцедивши јој крв низ олтар са стране. ");
INSERT INTO srp1868_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","И нека јој извади вољу с нечистотом и баци крај олтара према истоку где је пепео. ");
INSERT INTO srp1868_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","И нека је задре за крила, али да не раскине; тако нека је свештеник запали на олтару на дрвима која су на огњу; то је жртва паљеница, жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","А кад ко хоће да принесе на жртву Господу дар, бело брашно нека буде жртва његова, и нека је полије уљем и метне на њу кад. ");
INSERT INTO srp1868_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","И нека је донесе синовима Ароновим свештеницима, и нека свештеник узме тог брашна пуну шаку и уља и сав кад, и нека то запали свештеник на олтару за спомен њен; то је жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","А шта остане од тог дара, нека буде Арону и синовима његовим; то је светиња над светињама између жртава које се пале Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ако ли хоћеш да принесеш дар печен у пећи, нека буду погаче пресне од белог брашна, замешене с уљем, или колачи пресни, намазани уљем. ");
INSERT INTO srp1868_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ако ли ти је дар печено шта у тави, нека је од белог брашна без квасца замешено с уљем. ");
INSERT INTO srp1868_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Разломи га на делове, и полиј уљем; то је дар. ");
INSERT INTO srp1868_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ако ли ти је дар готовљен у котлићу, нека је од белог брашна с уљем. ");
INSERT INTO srp1868_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","И донеси дар који начиниш од тога Господу, и подај га свештенику, и он ће га однети на олтар; ");
INSERT INTO srp1868_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","и узеће свештеник од дара спомен његов, и запалиће га на олтару; то је жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","А шта остане од дара, нека буде Арону и синовима његовим; то је светиња над светињама између жртава које се пале Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ниједан дар који приносите Господу да не буде с квасцем; јер ни квасац ни мед не треба да палите на жртву огњену Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Само у жртви од првина можете принети то Господу; али на олтар не мећите за угодни мирис. ");
INSERT INTO srp1868_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","А сваки дар који приносиш осоли сољу, и немој оставити дар свој без соли завета Бога свог; са сваким даром својим принеси соли. ");
INSERT INTO srp1868_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","А кад приносиш дар од првина Господу, класове нове осуши на огњу, а шта истреш из класова нових принеси на дар од првина својих. ");
INSERT INTO srp1868_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","И полиј га уљем и кад метни на њ; то је дар. ");
INSERT INTO srp1868_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","И свештеник узевши истрвеног жита и уља са свим кадом нека запали спомен. То је жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Кад ко приноси жртву захвалну, ако од говеда приноси, мушко или женско нека принесе здраво пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","И нека метне руку своју на главу жртви својој, и нека је свештеник закоље на вратима шатора од састанка, и крвљу њеном нека синови Аронови, свештеници покропе олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Потом нека свештеник принесе од жртве захвалне оно што се пали Господу, сало што покрива црева и све сало што је на њима; ");
INSERT INTO srp1868_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","и оба бубрега и сало што је на њима и на слабинама, и мрежицу што је на јетри, нека је извади с бубрезима. ");
INSERT INTO srp1868_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","И нека то запале синови Аронови на олтару заједно са жртвом паљеницом, која буде на дрвима на огњу. То је жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ако ли од ситне стоке приноси на жртву захвалну Господу, мушко или женско нека принесе здраво. ");
INSERT INTO srp1868_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ако приноси јагње на жртву, нека га принесе пред Господом; ");
INSERT INTO srp1868_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","и нека метне руку своју на главу жртви својој, и нека је закоље пред шатором од састанка; и нека покропе синови Аронови крвљу њеном олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Потом нека свештеник принесе од жртве захвалне оно што се пали Господу, сало, цео реп до леђа, сало што покрива црева и све сало што је на цревима; ");
INSERT INTO srp1868_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","и оба бубрега и сало што је на њима и на слабинама, и мрежицу на јетри, с бубрезима нека је извади; ");
INSERT INTO srp1868_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","и нека запали свештеник на олтару; то је јело од жртве огњене Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ако ли приноси козу, нека је принесе пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","И нека јој метне руку своју на главу, и нека је закоље пред шатором од састанка, и нека синови Аронови покропе крвљу њеном олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Потом нека свештеник принесе од ње на жртву што се пали Господу, сало што покрива црева и све сало што је на цревима, ");
INSERT INTO srp1868_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","и оба бубрега, и сало што је на њима и на слабинама, и мрежицу на јетри, с бубрезима нека је извади; ");
INSERT INTO srp1868_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","и нека запали свештеник на олтару; то је јело од жртве огњене за угодни мирис. Све је сало Господње. ");
INSERT INTO srp1868_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Вечан закон нека вам буде од колена до колена у свим становима вашим: да не једете сало ни крв. ");
INSERT INTO srp1868_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Кажи синовима Израиљевим, и реци: Ако ко згреши нехотице и учини штагод што је Господ забранио да се не чини, ");
INSERT INTO srp1868_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ако свештеник помазани згреши, те буде на грех народу, нека за грех свој који је учинио принесе теле здраво Господу на жртву за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","И доведавши теле на врата шатору од сведочанства пред Господа, нека метне руку своју телету на главу, и закоље теле пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","И нека узме свештеник помазани крви од телета, и унесе је у шатор од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","И нека замочи свештеник прст свој у крв, и крвљу седам пута покропи пред Господом пред завесом од светиње. ");
INSERT INTO srp1868_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","И нека помаже свештеник том крвљу рогове олтару, на коме се кади мирисима пред Господом у шатору од састанка, а осталу крв од телета сву нека излије на подножје олтару, на коме се пале жртве на вратима шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","И нека извади све сало из телета за грех, сало што покрива црева и све сало што је на цревима; ");
INSERT INTO srp1868_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","и оба бубрега, и сало што је на њима и на слабинама, и мрежицу на јетри с бубрезима нека извади, ");
INSERT INTO srp1868_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","онако како се вади из говечета за жртву захвалну; и нека запали свештеник на олтару, на коме се жртва пали. ");
INSERT INTO srp1868_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","А кожу од телета и све месо с главом и с ногама и црева и балегу, ");
INSERT INTO srp1868_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","и цело теле нека изнесе напоље из логора на чисто место, где се просипа пепео, и нека га спали огњем на дрвима; на месту где се просипа пепео нека се спали. ");
INSERT INTO srp1868_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ако ли би сав збор синова Израиљевих згрешио нехотице и не би збор знао за то, и учинили би штагод што је Господ забранио да се не чини, те би скривили, ");
INSERT INTO srp1868_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","кад се дозна за грех који су учинили, онда нека збор принесе теле, жртву за грех, и нека га доведу пред шатор од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","И старешине од збора нека метну телету на главу руке своје пред Господом, и свештеник нека закоље теле пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","И свештеник помазани нека унесе крви од телета у шатор од састанка, ");
INSERT INTO srp1868_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","и нека свештеник замочи прст свој у крв, и седам пута покропи пред Господом пред завесом. ");
INSERT INTO srp1868_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","И том крвљу нека помаже рогове олтару који је пред Господом у шатору од састанка, а осталу крв сву нека излије на подножје олтару на коме се пали жртва, на вратима шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","А све сало извадивши из њега нека запали на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","И с тим телетом нека чини онако како чини с телетом за свој грех, тако нека учини с њим; тако ће их свештеник очистити од греха, и опростиће им се. ");
INSERT INTO srp1868_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","А теле нека изнесе напоље из логора, и спали га као и прво теле; то је жртва за грех свега збора. ");
INSERT INTO srp1868_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ако ли поглавар згреши, и учини нехотице штагод што је Господ Бог његов забранио да се не чини, те скриви, ");
INSERT INTO srp1868_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","кад дозна за грех свој, који је учинио, тада нека доведе на жртву јаре мушко, здраво. ");
INSERT INTO srp1868_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","И нека метне руку своју јарету на главу, и свештеник нека га закоље где се коље жртва паљеница пред Господом; то је жртва за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","И нека узме свештеник крви од жртве за грех на прст свој, и помаже рогове олтару на коме се жртва пали; а осталу крв нека излије на подножје олтару на коме се жртва пали. ");
INSERT INTO srp1868_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","А све сало нека запали на олтару као сало од жртве захвалне; и тако ће га очистити свештеник од греха његовог, и опростиће му се. ");
INSERT INTO srp1868_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ако ли ко из простог народа згреши нехотице, и учини штагод што је Господ забранио да се не чини, те скриви, ");
INSERT INTO srp1868_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","кад дозна за грех свој, који је учинио, тада нека доведе на жртву јаре женско здраво за грех, који је учинио. ");
INSERT INTO srp1868_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","И нека метне руку своју на главу жртви за грех, и нека је свештеник закоље на месту где се коље жртва паљеница. ");
INSERT INTO srp1868_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","И нека узме свештеник крви од ње на прст свој, И помаже рогове олтару на коме се пали жртва; а осталу крв сву нека излије на подножје олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","И све сало из ње нека извади као што се вади сало из жртве захвалне, и нека га запали свештеник на олтару за угодни мирис Господу; а тако ће га очистити од греха свештеник, И опростиће му се. ");
INSERT INTO srp1868_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ако ли би довео између оваца на жртву за грех, нека доведе женско здраво. ");
INSERT INTO srp1868_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","И нека метне руку своју на главу жртви за грех, и нека је свештеник закоље на месту где се коље жртва паљеница. ");
INSERT INTO srp1868_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","И нека узме свештеник крви од жртве за грех на прст свој, и нека помаже рогове олтару на коме се пали жртва; а осталу крв сву нека излије на подножје олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","И све сало нека извади као што се вади сало из јагњета за жртву захвалну; и нека га свештеник запали на олтару за жртву огњену Господу; и тако ће га очистити свештеник од греха његовог, који је учинио, и опростиће му се. ");
INSERT INTO srp1868_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","И кад ко згреши што чује клетву и буде јој сведок видевши или чувши, па не каже, носиће своје безакоње. ");
INSERT INTO srp1868_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Или кад се ко дотакне нечисте ствари, стрва од нечисте зверке или стрва од нечистог живинчета или стрва од нечисте животиње која гамиже, ако и у незнању учини, ипак ће се оскврнити, и биће крив. ");
INSERT INTO srp1868_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Или кад се дотакне нечистоте човечије, била нечистота његова каква му драго, којом се оскврни, знајући или не знајући, крив је. ");
INSERT INTO srp1868_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Или кад се ко закуне говорећи својим устима да ће учинити шта зло или добро, а за коју год ствар за коју човек говори заклињући се, знао или не знао, крив је за једну од тих ствари. ");
INSERT INTO srp1868_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Кад буде крив за коју од тих ствари, нека призна грех свој. ");
INSERT INTO srp1868_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","И нека доведе на жртву Господу за грех, што је згрешио, женско од ситне стоке, јагње или јаре, за грех; и свештеник ће га очистити од греха његовог. ");
INSERT INTO srp1868_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ако ли не би могао принети јагњета или јарета, онда нека донесе на жртву Господу за преступ, којим је згрешио, две грлице или два голубиће, једно на жртву за грех а друго на жртву паљеницу. ");
INSERT INTO srp1868_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Нека донесе свештенику, а он нека принесе прво оно што је за грех, и ноктом нека му засече главу к шији, али да не раздвоји. ");
INSERT INTO srp1868_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","И крвљу жртве за грех нека покропи стране олтару; а шта остане крви нека се исцеди на подножје олтару. То је жртва за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","А од другог нека начини жртву паљеницу по обичају; тако ће га очистити свештеник од греха његовог, који је учинио, и опростиће му се. ");
INSERT INTO srp1868_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ако ли не би могао принети ни две грлице или два голубиће, онда нека за жртву за то што је згрешио донесе десетину ефе белог брашна да буде жртва за грех, а нека не додаје уља и не меће када, јер је жртва за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","И кад донесе к свештенику, нека узме свештеник пуну шаку за спомен њен, и нека запали на олтару поред жртве огњене Господу. То је жртва за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","И очистиће га свештеник од греха, којим се огрешио у чем год од овог, и опростиће му се; а остатак ће бити свештенику као од дара. ");
INSERT INTO srp1868_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Ко се превари, те се огреши нехотице о ствари посвећене Господу, нека принесе на жртву Господу за преступ свој овна здравог с ценом, којом ти процениш свету ствар на сикле сребрне, по сиклима светим, према преступу. ");
INSERT INTO srp1868_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","И тако колико се огрешио о свету ствар нека накнади, и на то још нека дометне пети део, и нека да свештенику; а свештеник ће га очистити овном принесеним на жртву за преступ, и опростиће му се. ");
INSERT INTO srp1868_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Ко згреши и учини штагод што је Господ забранио да се не чини, ако и није знао, ипак је крив, и носиће своје безакоње. ");
INSERT INTO srp1868_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Нека доведе к свештенику овна здравог с ценом којом процениш преступ; и очистиће га свештеник од греха његовог, који је учинио не знајући, и опростиће му се. ");
INSERT INTO srp1868_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Преступ је; згрешио је Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Кад ко згреши и учини зло дело Господу ударивши у бах ближњему свом за оставу или за ствар предану у руке или отевши шта или занесавши ближњег свог, ");
INSERT INTO srp1868_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","или нађе изгубљено шта, па удари у бах, или се криво закуне за коју год ствар коју може човек учинити и огрешити се њом, ");
INSERT INTO srp1868_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","кад тако згреши и скриви, нека врати шта је отео или присвојио преваром или шта му је било дано на оставу или шта је изгубљено нашао, ");
INSERT INTO srp1868_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","или за шта се заклео криво, нека плати цело и још дометне пети део ономе чије је; нека му да онај дан кад принесе жртву за свој грех. ");
INSERT INTO srp1868_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","А на жртву за грех свој нека принесе Господу овна здравог, са ценом којом процениш кривицу нека га доведе свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","И очистиће га свештеник пред Господом, и опростиће му се свака ствар коју је учинио, те скривио. ");
INSERT INTO srp1868_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Заповеди Арону и синовима његовим, и реци им: Ово је закон за жртву паљеницу: жртва паљеница нека стоји на огњу на олтару целу ноћ до јутра, и огањ на олтару нека гори једнако. ");
INSERT INTO srp1868_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Свештеник нека обуче своју хаљину ланену, и гаће ланене нека обуче на тело своје, и нека згрне пепео кад огањ спали на олтару жртву паљеницу, и нека га изручи код олтара. ");
INSERT INTO srp1868_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Потом нека свуче хаљине своје и обуче друге хаљине, и нека изнесе пепео напоље из логора на чисто место. ");
INSERT INTO srp1868_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","А огањ што је на олтару нека гори на њему, нека се не гаси, него нека свештеник ложи на огањ дрва свако јутро, и нека намешта на њ жртву паљеницу, и нека пали на њему сало од жртава захвалних. ");
INSERT INTO srp1868_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Огањ нека једнако гори на олтару, нека се не гаси. ");
INSERT INTO srp1868_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","А ово је закон за дар: синови Аронови нека га приносе Господу пред олтаром. ");
INSERT INTO srp1868_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Узевши шаку белог брашна и уља од дара и сав кад који буде на дару, нека запали на олтару спомен његов на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","А шта претече, нека једе Арон и синови његови; нека се једе без квасца на светом месту; у трему шатора од састанка нека једу. ");
INSERT INTO srp1868_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Нека се не меси са квасцем; то им дадох да им буде део од жртава мојих огњених; то је светиња над светињама као жртва за грех и као жртва за преступ. ");
INSERT INTO srp1868_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Свако мушко између синова Аронових нека то једе законом вечним од колена до колена од жртава које се пале Господу; шта се год дотакне тога, биће свето. ");
INSERT INTO srp1868_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ово је жртва Аронова и синова његових, коју ће приносити Господу онај дан кад се који помаже: десетину ефе белог брашна за дар свагдашњи, половину ујутру а половину увече. ");
INSERT INTO srp1868_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","У тави с уљем нека се готови; пржено нека се донесе; и пржене комаде дара нека принесе на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","И свештеник између синова његових, који буде помазан након њега, нека чини тако исто законом вечним; нека се пали Господу све то; ");
INSERT INTO srp1868_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","и сваки дар свештеников нека се сав спали, а нека се не једе. ");
INSERT INTO srp1868_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Кажи Арону и синовима његовим, и реци: Ово је закон за жртву ради греха: на месту где се коље жртва паљеница, нека се коље и жртва за грех пред Господом; светиња је над светињама. ");
INSERT INTO srp1868_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Свештеник који принесе жртву за грех нека је једе; на светом месту нека се једе, у трему од шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Шта се год дотакне меса њеног, биће свето; и ако ко покапа крвљу њеном хаљину, оно што покапа нека опере на светом месту. ");
INSERT INTO srp1868_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","И суд земљани у коме буде кувано нека се разбије; ако ли је кувано у суду бронзаном, нека се истре и водом опере. ");
INSERT INTO srp1868_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Свако мушко између свештеника нека то једе; светиња је над светињама. ");
INSERT INTO srp1868_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Али ниједна жртва за грех, од које се унесе крв у шатор од састанка да се учини очишћење од греха у светињи, нека се не једе, него нека се огњем сажеже. ");
INSERT INTO srp1868_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","А ово је закон за жртву ради преступа; светиња је над светињама. ");
INSERT INTO srp1868_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","На коме се месту коље жртва паљеница, на оном нека се коље и жртва за преступ; и крвљу њеном нека се покропи олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","А све сало њено нека се принесе, и реп и сало што покрива црева, ");
INSERT INTO srp1868_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","и оба бубрега, и сало што је на њима и на слабинама, и мрежицу на јетри нека извади с бубрезима, ");
INSERT INTO srp1868_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","и нека запали то свештеник на олтару на жртву огњену Господу; то је жртва за преступ. ");
INSERT INTO srp1868_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Свако мушко између свештеника нека је једе; на светом месту нека се једе; светиња је над светињама. ");
INSERT INTO srp1868_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Жртва је за преступ као жртва за грех, један је закон за обе; који свештеник учини њом очишћење, његова је. ");
INSERT INTO srp1868_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","А кад свештеник принесе чију жртву паљеницу, кожа од жртве коју принесе његова је. ");
INSERT INTO srp1868_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","И сваки дар печен у пећи или зготовљен у котлићу или у тави, оног је свештеника који га принесе. ");
INSERT INTO srp1868_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","И сваки дар замешен с уљем или сув, свих је синова Аронових, како једног тако другог. ");
INSERT INTO srp1868_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","А ово је закон за жртву захвалну, која се принесе Господу: ");
INSERT INTO srp1868_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ако би је ко приносио да захвали, нека принесе на жртву захвалну колаче без квасца замешене с уљем и погаче без квасца намазане уљем, и белог брашна попрженог с тим колачима замешеним с уљем. ");
INSERT INTO srp1868_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Осим колача хлеб кисели нека принесе за принос свој са жртвом захвалном, којом захваљује. ");
INSERT INTO srp1868_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","И од свега што приноси нека принесе по једно за жртву подигнуту Господу; и то ће бити оног свештеника који покропи крвљу од жртве захвалне. ");
INSERT INTO srp1868_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","А месо од жртве захвалне, којом се захваљује, нека се поједе онај дан кад се принесе; и нека не остаје ништа до јутра. ");
INSERT INTO srp1868_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ако ли принесе жртву ради завета или од воље, нека се једе онај дан кад се принесе; ако шта остане, нека се поједе сутрадан. ");
INSERT INTO srp1868_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ако ли шта меса од те жртве остане до трећег дана, нека се сажеже огњем. ");
INSERT INTO srp1868_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ако ли би ко трећи дан јео меса од жртве захвалне, неће бити угодан онај који је принео, нити ће му се она примити, него ће бити мрска, и ко би је год јео, носиће грех свој. ");
INSERT INTO srp1868_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","И месо које би се дотакло чега нечистог, да се не једе, него нека се сажеже огњем; а друго месо може јести ко је год чист. ");
INSERT INTO srp1868_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","А ко би јео меса од жртве захвалне принесене Господу, а не би био чист, тај да се истреби из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","И ко се дотакне чега нечистог, или нечистог човека или нечистог живинчета, или ког му драго гада нечистог, па једе меса од жртве захвалне принесене Господу, тај да се истреби из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Кажи синовима Израиљевим, и реци: Не једите сало од вола ни од овце ни од козе. ");
INSERT INTO srp1868_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Може се узети за сваку потребу сало од живинчета које цркне или га зверка раздре; али га не једите; ");
INSERT INTO srp1868_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ко ли би јео сало од стоке коју приноси човек на жртву огњену Господу, нека се истреби из народа свог онај који једе. ");
INSERT INTO srp1868_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ни крв не једите у становима својим ни од птице нити од ког живинчета. ");
INSERT INTO srp1868_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Сваки који би јео какву крв, нека се истреби из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Кажи синовима Израиљевим, и реци: Ко приноси жртву своју захвалну Господу, нека донесе Господу принос свој од жртве захвалне. ");
INSERT INTO srp1868_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Својим рукама нека донесе шта се сажиже Господу, сало с грудима нека донесе, и груди нека се обрну тамо и амо на жртву пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","А свештеник нека запали сало на олтару, груди пак нека буду Арону и синовима његовим. ");
INSERT INTO srp1868_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","И десно плеће од својих жртава захвалних подајте свештенику да буде жртва подигнута. ");
INSERT INTO srp1868_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","А који између синова Аронових принесе крв и сало од жртве захвалне, њему нека буде десно плеће. ");
INSERT INTO srp1868_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Јер груди што се обрћу и плеће што се подиже узех од синова Израиљевих од свих њихових жртава захвалних, и дадох Арону свештенику и синовима његовим законом вечним да се узимају од синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","То је помазаног Арона и помазаних синова његових од огњених жртава Господњих од дана кад их доведе да врше службу свештеничку Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","То заповеди Господ да им од дана кад их помаза дају синови Израиљеви законом вечним од колена на колено. ");
INSERT INTO srp1868_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","То је закон за жртву паљеницу, за дар, за жртву ради греха и за жртву ради преступа, и за освештање и за жртву захвалну, ");
INSERT INTO srp1868_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","што је Господ заповедио Мојсију на гори синајској кад заповеди синовима Израиљевим у пустињи синајској да приносе жртве своје Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Узми Арона и синове његове с њим и одело и уље помазања и теле за жртву ради греха и два овна и котарицу пресних хлебова. ");
INSERT INTO srp1868_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","И сабери сав збор пред врата шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","И учини Мојсије како му заповеди Господ, и сабра се збор пред врата шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","И рече Мојсије збору: Ово је заповедио Господ да се учини. ");
INSERT INTO srp1868_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","И доведе Мојсије Арона и синове његове, и опра их водом. ");
INSERT INTO srp1868_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","И обуче му кошуљу, и опаса га појасом, и огрну га плаштом, и метну му сврх њега оплећак, и стеже око њега појас од оплећка, и опаса га њим. ");
INSERT INTO srp1868_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","И метну на њ напрсник, а на напрсник метну Урим и Тумим. ");
INSERT INTO srp1868_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Још му метну капу на главу, и на капу метну спред плочу златну, круну свету, као што заповеди Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","И узе Мојсије уље помазања, и помаза шатор и све ствари у њему, и освети их. ");
INSERT INTO srp1868_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","И покропи њим олтар седам пута, и помаза олтар и све справе његове, и умиваоницу и подножје њено, да се освети. ");
INSERT INTO srp1868_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","И изли уље помазања на главу Арону, и помаза га да се освети. ");
INSERT INTO srp1868_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","И доведе Мојсије синове Аронове, и обуче им кошуље, и опаса их појасом, и веза им капице на главе, као што му беше заповедио Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","И доведе теле за грех, и Арон и синови његови метнуше руке своје на главу телету за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","И закла га Мојсије, и узевши крви његове помаза рогове олтару унаоколо прстом својим, и очисти олтар, а осталу крв изли на подножје олтару, и освети га да се на њему чини очишћење од греха. ");
INSERT INTO srp1868_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","И узе све сало што је на цревима, и мрежицу с јетре, и оба бубрега, и сало око њих, и запали Мојсије на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","А теле с кожом и с месом и балегом спали огњем иза логора, као што беше Господ заповедио Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","И доведе овна за жртву паљеницу, и Арон и синови његови метнуше руке своје на главу овну; ");
INSERT INTO srp1868_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","и закла га Мојсије, и покропи крвљу његовом олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","И исекавши овна на делове запали Мојсије главу и делове и сало. ");
INSERT INTO srp1868_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","А црева и ноге опра водом, и тако спали Мојсије свега овна на олтару; и би жртва паљеница за угодни мирис, жртва огњена Господу, као што беше Господ заповедио Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","И доведе другог овна, овна за посвећење; и Арон и синови његови метнуше руке своје на главу овну. ");
INSERT INTO srp1868_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","И заклавши га Мојсије узе крви његове, и помаза њом крај десног уха Арону и палац десне руке његове и палац десне ноге његове. ");
INSERT INTO srp1868_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","И доведе Мојсије синове Аронове, па и њима помаза истом крвљу крај десног уха и палац десне руке и палац десне ноге; а осталу крв изли Мојсије по олтару унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Потом узе сало и реп и све сало што је на цревима, и мрежицу с јетре, и оба бубрега, и сало око њих, и плеће десно, ");
INSERT INTO srp1868_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","а из котарице у којој стајаху пресни хлебови пред Господом узе један колач пресан и један колач хлеба с уљем и једну погачу, и метну на сало и на плеће десно. ");
INSERT INTO srp1868_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","И метну то све Арону у руке, и синовима његовим у руке, и обрну тамо и амо за жртву обртану пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","После узевши то из руку њихових Мојсије запали на олтару сврх жртве паљенице; то је посвећење на угодни мирис, жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","И узе Мојсије груди, и обрну их тамо и амо за жртву обртану пред Господом; и од овна посветног допаде Мојсију део, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","И узе Мојсије уља за помазање и крви која беше на олтару, и покропи Арона и хаљине његове, и синове његове и хаљине њихове с њим; и тако посвети Арона и хаљине његове, и синове његове и хаљине њихове с њим. ");
INSERT INTO srp1868_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Потом рече Мојсије Арону и синовима његовим: Кувајте то месо на вратима шатора од састанка, и онде га једите и хлеб посветни што је у котарици, као што сам заповедио рекавши: Арон и синови његови нека једу то. ");
INSERT INTO srp1868_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","А шта остане меса или хлеба, огњем сажезите. ");
INSERT INTO srp1868_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","И не излазите с врата шатора од састанка седам дана, докле се не наврше дани посвећења вашег, јер ћете се седам дана посвећивати. ");
INSERT INTO srp1868_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Како је било данас, тако је Господ заповедио да се чини, да бисте се очистили од греха. ");
INSERT INTO srp1868_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Зато на вратима шатора од састанка останите дању и ноћу за седам дана, и извршите шта је Господ заповедио да извршите, да не помрете, јер ми је тако заповеђено. ");
INSERT INTO srp1868_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","И Арон и синови његови учинише све што беше Господ заповедио преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","А у осми дан сазва Мојсије Арона и синове његове и старешине израиљске. ");
INSERT INTO srp1868_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","И рече Арону: Узми теле за жртву ради греха и овна за жртву паљеницу, оба здрава; и принеси их пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","А синовима Израиљевим кажи и реци: Узмите јаре за жртву ради греха, и теле и јагње, обоје од године дана, и здраво, за жртву паљеницу. ");
INSERT INTO srp1868_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","И вола и овна за жртву захвалну, да принесете пред Господом, и дар с уљем замешен, јер ће вам се данас јавити Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","И узеше шта заповеди Мојсије, и донесоше пред шатор од састанка, и приступивши сав збор стадоше пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","И рече Мојсије: Учините шта је заповедио Господ, и показаће вам се слава Господња. ");
INSERT INTO srp1868_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","И рече Мојсије Арону: Приступи к олтару, и принеси жртву за грех свој и жртву своју паљеницу, и очисти од греха себе и народ; и принеси жртву народну и очисти их од греха, као што је заповедио Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Тада Арон приступи к олтару и закла теле за се. ");
INSERT INTO srp1868_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","И синови Аронови додаше му крв, а он замочи прст свој у крв, и помаза рогове олтару; а осталу крв изли на подножје олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","А сало и бубреге и мрежицу од јетре од жртве за грех запали на олтару, као што беше заповедио Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","А месо и кожу сажеже огњем иза логора. ");
INSERT INTO srp1868_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Потом закла жртву своју паљеницу, и синови Аронови додаше му крв од ње, и покропи њом олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","И додаше му жртву паљеницу исечену на делове заједно с главом, и запали је на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","И оправши црева и ноге од ње, запали их на олтару сврх жртве паљенице. ");
INSERT INTO srp1868_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Потом принесе жртву народну: узе јаре за грех које беше за народ, и закла га, и принесе за грех као и прво. ");
INSERT INTO srp1868_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Иза тога принесе и жртву паљеницу, и сврши по закону. ");
INSERT INTO srp1868_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Принесе и дар, и узевши од њега пуну шаку запали на олтару сврх јутарње жртве паљенице. ");
INSERT INTO srp1868_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Потом закла вола и овна на жртву захвалну за народ; и дадоше му синови Аронови крв, и покропи њом олтар одозго унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Па му додаше и сало од вола, и од овна реп, и сало што покрива црева, и бубреге и мрежицу с јетре, ");
INSERT INTO srp1868_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","и метнувши све сало на груди, и запали сало на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","А груди и десно плеће обрну Арон тамо и амо на жртву обртану пред Господом, као што беше Господ заповедио Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Тада подиже Арон руке своје према народу, и благослови их; и сиђе свршивши жртву за грех и жртву паљеницу и жртву захвалну. ");
INSERT INTO srp1868_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Потом уђе Мојсије с Ароном у шатор од састанка, а кад опет изађоше благословише народ; и слава се Господња показа свему народу. ");
INSERT INTO srp1868_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Јер дође огањ од Господа, и спали на олтару жртву паљеницу и сало. И видевши то сав народ повика и паде ничице. ");
INSERT INTO srp1868_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","А синови Аронови, Надав и Авијуд, узевши сваки своју кадионицу метнуше огањ у њих и на огањ метнуше кад, и принесоше пред Господом огањ туђ, а то им не беше заповедио. ");
INSERT INTO srp1868_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Тада дође огањ од Господа и удари их, те погибоше пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Тада рече Мојсије Арону: То је што је казао Господ говорећи: У онима који приступају к мени бићу свет и пред целим народом прославићу се. А Арон оћуте. ");
INSERT INTO srp1868_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","А Мојсије позва Мисаила и Елисафана синове Озила стрица Ароновог, и рече им: Ходите и изнесите браћу своју испред светиње напоље из логора. ");
INSERT INTO srp1868_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","И приступише и изнесоше их у кошуљама њиховим напоље из логора, као што рече Мојсије. ");
INSERT INTO srp1868_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Тада рече Мојсије Арону и Елеазару и Итамару, синовима његовим: Немојте откривати глава својих, ни хаљина својих раздирати, да не изгинете и да се Господ не разгневи на сав збор; него браћа ваша, сав род Израиљев, нека плаче ради пожара који учини Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","И с врата шатора од састанка немојте излазити, да не изгинете, јер је на вама уље помазања Господњег. И учинише по речи Мојсијевој. ");
INSERT INTO srp1868_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","И Господ рече Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Вино и силовито пиће немој пити ти ни синови твоји с тобом, кад улазите у шатор од састанка да не изгинете. То нека вам је уредба вечна од колена на колено. ");
INSERT INTO srp1868_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Да бисте могли распознавати шта је свето шта ли није, и шта је чисто шта ли нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","И да бисте учили синове Израиљеве свим уредбама које им је казао Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","А Мојсије рече Арону и Елеазару и Итамару синовима његовим који осташе: Узимајте дар што остане од огњених жртава Господњих, и једите с хлебом пресним код олтара, јер је светиња над светињама. ");
INSERT INTO srp1868_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Зато ћете га јести на светом месту, јер је део твој и део синова твојих од огњених жртава Господњих; јер ми је тако заповеђено. ");
INSERT INTO srp1868_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","А груди од жртве обртане и плеће од жртве подизане једите на чистом месту, ти и синови твоји и кћери твоје с тобом; јер је тај део дан теби и синовима твојим од захвалних жртава синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Плеће од жртве подизане и груди од жртве обртане доносиће се са салом што се сажиже, да се обрне тамо и амо пред Господом, и биће твоје и синова твојих с тобом законом вечним, као што је заповедио Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","И Мојсије потражи јаре за грех; али гле, беше изгорело; зато се разгневи на Елеазара и на Итамара синове Аронове који осташе, и рече: ");
INSERT INTO srp1868_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Зашто не једосте жртве за грех на светом месту? Светиња је над светињама, и даде вам је Господ да носите грех свега збора, да би се очистили од греха пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","А ето крв њена није унесена у светињу; ваљаше вам је јести на светом месту, као што сам заповедио. ");
INSERT INTO srp1868_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Тада рече Арон Мојсију: Ето, данас принесоше жртву своју за грех и жртву своју паљеницу пред Господом, и то ми се догоди. А да сам данас јео жртве за грех, би ли било по вољи Господу? ");
INSERT INTO srp1868_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Кад чу то Мојсије, приста на то. ");
INSERT INTO srp1868_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","И рече Господ Мојсију и Арону говорећи им: ");
INSERT INTO srp1868_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Кажите синовима Израиљевим и реците: Ово су животиње које ћете јести између свих животиња на земљи: ");
INSERT INTO srp1868_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Шта год има папке и папци су му раздвојени и прежива између животиња, то једите. ");
INSERT INTO srp1868_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Али оних што само преживају или што само имају папке раздвојене, не једите, као што је камила, јер прежива али нема папке раздвојене; да вам је нечиста; ");
INSERT INTO srp1868_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","и питоми зец, јер прежива али нема папке раздвојене; нечист да вам је. ");
INSERT INTO srp1868_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","И зец дивљи, јер прежива али нема папке раздвојене; нечист да вам је. ");
INSERT INTO srp1868_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","И свиња, јер има папке раздвојене али не прежива; нечиста да вам је; ");
INSERT INTO srp1868_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","меса од њих не једите нити се стрва њиховог додевајте; јер вам је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","А између свега што је у води ово једите: Шта год има пера и љуску у води, по мору и по рекама, једите. ");
INSERT INTO srp1868_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","А шта нема пера и љуску у мору и у рекама између свега што се миче по води и живи у води, да вам је гадно. ");
INSERT INTO srp1868_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Гадно да вам је, меса да им не једете, и на стрв њихов да се гадите. ");
INSERT INTO srp1868_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Шта год нема пера и љуске у води, то да вам је гадно. ");
INSERT INTO srp1868_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","А између птица ове да су вам гадне и да их не једете: орао и јастреб и морски орао, ");
INSERT INTO srp1868_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","еја и крагуј по својим врстама, ");
INSERT INTO srp1868_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","и сваки гавран по својим врстама, ");
INSERT INTO srp1868_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","и совуљага и ћук и лиска и кобац по својим врстама, ");
INSERT INTO srp1868_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","и буљина и гњурац и ушара, ");
INSERT INTO srp1868_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","и лабуд и гем и сврака, ");
INSERT INTO srp1868_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","и рода и чапља по свим врстама, и пупавац и љиљак. ");
INSERT INTO srp1868_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Шта год гамиже, а има крила и иде на четири ноге, да вам је гадно. ");
INSERT INTO srp1868_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Али између свега што гамиже а има крила и иде на четири ноге једите шта има стегна на ногама својим, којима скаче по земљи. ");
INSERT INTO srp1868_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Између њих једите ове: арба по врстама његовим, салема по врстама његовим, аргола по врстама његовим и агава по врстама његовим. ");
INSERT INTO srp1868_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","А што гамиже, а има крила и четири ноге, да вам је гадно. ");
INSERT INTO srp1868_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","И о њих ћете се оскврнити; ко се год дотакне мртвог тела њиховог, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","И ко би год носио мртво тело њихово, нека опере хаљине своје, и да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Свака животиња која има папке али нераздвојене и не прежива, да вам је нечиста; ко их се год дотакне, да је нечист. ");
INSERT INTO srp1868_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","И шта год иде на шапама између свих животиња четвороножних, да вам је нечисто; ко би се дотакао стрва њиховог, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","И ко би носио стрв њихов, нека опере хаљине своје, и да је нечист до вечера; то да вам је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","И између животиња које пужу по земљи да су вам нечисте: ласица и миш и корњача по врстама својим, ");
INSERT INTO srp1868_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","и јеж и гуштер и твор и пуж и кртица. ");
INSERT INTO srp1868_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","То вам је нечисто између животиња које пужу; ко их се дотакне мртвих, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","И свака ствар на коју падне које од њих мртво биће нечиста, била справа дрвена или хаљина или кожа или торба, и свака ствар која треба за какав посао, нека се метне у воду, и да је нечиста до вечера, после да је чиста. ");
INSERT INTO srp1868_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","А сваки суд земљани, у који падне шта од тога, и шта год у њему буде, биће нечист, и разбијте га. ");
INSERT INTO srp1868_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","И свако јело што се једе, ако на њега дође онаква вода, да је нечисто, и свако пиће што се пије у сваком таквом суду, да је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","И на шта би пало шта од тела њиховог мртвог све да је нечисто, и пећ и огњиште да се развали, јер је нечисто и нека вам је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","А студенац и убао, где се вода скупља, биће чист; али шта се дотакне стрва њиховог, биће нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ако ли шта од стрва њиховог падне на семе, које се сеје, оно ће бити чисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Али ако буде полито семе водом, па онда падне шта од стрва њиховог на семе, да вам је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","И кад угине животиња од оних које једете, ко се дотакне стрва њеног, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","А ко би јео од стрва њеног, нека опере хаљине своје и да је нечист до вечера; и ко би однео стрв њен, нека опере хаљине своје, и да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","И све што пуже по земљи, да вам је гадно, да се не једе. ");
INSERT INTO srp1868_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Шта год иде на трбуху и шта год иде на четири ноге или има више ногу између свега што пуже по земљи, то не једите, јер је гад. ");
INSERT INTO srp1868_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Немојте се поганити ничим што гамиже и немојте се скврнити њима, да не будете нечисти с њих. ");
INSERT INTO srp1868_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Јер ја сам Господ Бог ваш; зато се освећујте и будите свети, јер сам ја свет; и немојте се скврнити ничим што пуже по земљи. ");
INSERT INTO srp1868_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Јер ја сам Господ, који сам вас извео из земље мисирске да вам будем Бог; будите, дакле, свети, јер сам ја свет. ");
INSERT INTO srp1868_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ово је закон за звери и за птице, и за све животиње што се мичу по води, и за сваку душу живу, која пуже по земљи. ");
INSERT INTO srp1868_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Да се распознаје нечисто од чистог и животиња која се једе од животиње која се не једе. ");
INSERT INTO srp1868_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Кажи синовима Израиљевим, и реци: Кад жена затрудни и роди мушко, нечиста да је седам дана; као у дане кад се одваја ради немоћи своје, биће нечиста. ");
INSERT INTO srp1868_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","А у осми дан нека се обреже дете. ");
INSERT INTO srp1868_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","А она још тридесет и три дана нека остане чистећи се од крви; ни једне свете ствари да се не додева и у светињу да не иде док се не наврше дани чишћења њеног. ");
INSERT INTO srp1868_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","А кад роди женско, онда да је нечиста две недеље дана, као кад се одваја ради немоћи своје, и шездесет и шест дана нека остане чистећи се од крви. ");
INSERT INTO srp1868_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","А кад се наврше дани чишћења њеног ради сина или ради кћери, нека донесе свештенику на врата шатора од састанка јагње од године за жртву паљеницу, и голупче или грлицу за жртву ради греха. ");
INSERT INTO srp1868_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","И свештеник ће принети жртву пред Господом, и очистиће је од греха њеног; и тако ће се очистити од течења крви своје. То је закон за жену кад роди мушко или женско. ");
INSERT INTO srp1868_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ако ли не може дати јагњета, онда нека узме две грлице или два голубића, једно за жртву паљеницу а друго за жртву ради греха; и очистиће је свештеник од греха њеног, и биће чиста. ");
INSERT INTO srp1868_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Још рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Човек у кога би на кожи тела његовог био оток или краста или бубуљица, и било би на кожи тела његовог налик на губу, нека се доведе к Арону свештенику или ка коме сину његовом свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","И нека свештеник види бољетицу на кожи тела његовог; ако длака на бољетици буде побелела и бољетица буде на очи нижа од остале коже тела његовог, онда је губа; па кад га види свештеник прогласиће га да је нечист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ако ли буде бела бубуљица на кожи тела његовог и не буде на очи нижа од остале коже нити длака на њој побелела, онда нека затвори свештеник за седам дана човека са таквом бољетицом. ");
INSERT INTO srp1868_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","А седмог дана нека види свештеник; ако опази да је бољетица остала како је била и није се даље разишла по кожи, нека га затвори свештеник опет за седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","И нека га свештеник опет види седмог дана, па ако опази да се бољетица смањила и није се даље разишла по кожи; краста је; и он нека опере хаљине своје и биће чист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ако ли се даље рашири краста по кожи његовој, пошто га свештеник види и прогласи да је чист, наново нека се покаже свештенику; ");
INSERT INTO srp1868_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ако види свештеник да се краста раширила по кожи његовој, прогласиће свештеник да је нечист; губа је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Кад је губа на човеку, нека га доведу к свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","И свештеник нека га види; ако буде бео оток на кожи и длака буде побелела, ако би и здраво месо било на отоку, ");
INSERT INTO srp1868_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","губа је застарела на кожи тела његовог; зато ће га свештеник прогласити да је нечист, и неће га затворити, јер је нечист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ако ли се губа изаспе по кожи и покрије сву кожу човеку од главе до пете, где би год свештеник очима погледао, ");
INSERT INTO srp1868_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","кад свештеник види да је губа покрила сву кожу на њему, прогласиће да је човек чист, јер је све побелело, па је чист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Али ако се покаже на њему дивље месо, биће нечист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Па кад свештеник види дивље месо, прогласиће га да је нечист; оно је дивље месо нечисто, губа је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","А кад би се дивље месо променило и побелело, нека дође к свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","И кад види свештеник да је бољетица побелела, свештеник ће прогласити да је чист, чист је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Кад у кога на кожи буде чир, па прође, ");
INSERT INTO srp1868_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","а после на месту где је био чир изађе оток бео или бубуљица бела и црвенкаста, нека се покаже свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ако свештеник види да је на очи нижа од остале коже и длака на њој побелела, прогласиће га свештеник да је нечист, губа је, изашла је из чира. ");
INSERT INTO srp1868_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ако ли свештеник гледајући види да није длака на њој побелела нити је нижа од коже, него се смањила, онда ће га затворити свештеник за седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ако се рашири по кожи, онда ће га свештеник прогласити да је нечист; болест је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ако ли остане на свом месту бубуљица и не рашири се, ожиљак је од чира; зато ће га свештеник прогласити да је чист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ако се ко по кожи ожеже огњем, па пошто се залечи остане бубуљица бела и црвенкаста или само бела, ");
INSERT INTO srp1868_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","нека га види свештеник; ако длака на бубуљици буде побелела и ако на очи буде нижа него кожа, губа је, изашла је из ожеглине; зато ће га свештеник прогласити да је нечист; губа је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ако ли свештеник види да на бубуљици нема беле длаке нити је нижа од коже, него се смањила, затвориће га за седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Па ће је седмог дана погледати свештеник; ако се буде раширила по кожи, тада ће га свештеник прогласити да је нечист; губа је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ако ли бубуљица буде остала на свом месту, и не буде се раширила по кожи, него се смањила, онда је рана од тога што се ожегао; зато ће га свештеник прогласити да је чист, јер је ожиљак од ожеглине. ");
INSERT INTO srp1868_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ако у човека или у жене буде бољетица на глави или на бради, ");
INSERT INTO srp1868_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","свештеник нека види бољетицу; ако на очи буде нижа од остале коже и на њој длака жућкаста и танка, свештеник ће прогласити да је нечист; оспа је, губа на глави или на бради; ");
INSERT INTO srp1868_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","а кад свештеник види бољетицу, и опази да на очи није нижа од остале коже и да нема на њој црне длаке, тада ће затворити свештеник за седам дана оног на коме је оспа. ");
INSERT INTO srp1868_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Па кад свештеник седми дан види, а оспа се није даље разишла нити длака на њој пожутела, нити је на очи оспа нижа од коже, ");
INSERT INTO srp1868_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","тада нека се обрије, али оспу да не обрије, и свештеник нека затвори још за седам дана оног на коме је оспа. ");
INSERT INTO srp1868_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","И седмог дана нека свештеник опет види оспу; ако опази да се оспа није даље разишла по кожи нити је на очи нижа од остале коже, тада ће га прогласити свештеник да је чист, па нека опере хаљине своје, и биће чист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ако ли се рашири оспа по кожи, пошто буде проглашен да је чист, ");
INSERT INTO srp1868_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","тада нека га види свештеник; ако се буде раширила оспа по кожи, нека више не гледа свештеник има ли жутих длака; нечист је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ако ли опази да је оспа остала где је била и да је црна длака израсла по њој, залечила се оспа, чист је, и свештеник ће прогласити да је чист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Кад у човека или у жене буду бубуљице по кожи тела њиховог, бубуљице беле, ");
INSERT INTO srp1868_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","свештеник нека види; ако на кожи тела његовог буду беле бубуљице мале, бела је оспа, изашла по кожи, чист је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Коме опадне коса с главе, ћелав је, чист је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ако му спреда опадне коса с главе, пола је ћелав, и чист је. ");
INSERT INTO srp1868_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Кад на глави сасвим ћелавој или пола ћелавој буде бела и црвенкаста бољетица, губа је, изашла на глави свој ћелавој или пола ћелавој. ");
INSERT INTO srp1868_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","И нека га види свештеник; ако опази да је бео и црвенкаст оток на глави свој ћелавој или пола ћелавој налик на губу по кожи осталог тела, ");
INSERT INTO srp1868_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","човек је губав, нечист је, и свештеник ће га прогласити да је нечист; губа му је на глави. ");
INSERT INTO srp1868_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","А губавац на коме је та болест, нека иде у хаљинама раздртим и гологлав, и уста нека застре, и нека виче: Нечист, нечист. ");
INSERT INTO srp1868_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Докле је год болест на њему, нека буде нечист; нечист је, нека живи сам, иза логора нека му буде стан. ");
INSERT INTO srp1868_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","И ако на хаљини буде губа, на хаљини вуненој или ланеној, ");
INSERT INTO srp1868_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","или на основи или на поучици од лана или од вуне, или на кожи, или на чем год од коже, ");
INSERT INTO srp1868_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","и ако бољетица буде зеленкаста или црвенкаста на хаљини или на кожи или на основи или на поучици или на чем год од коже, губа је, и нека се покаже свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","И кад види свештеник болест, нека затвори за седам дана ствар на којој је губа. ");
INSERT INTO srp1868_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","И седмог дана ако види да се даље разишла болест по хаљини или по основи или по поучици или по кожи или по чему год од коже, љута је губа болест, она ствар је нечиста. ");
INSERT INTO srp1868_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Зато нека спали ону хаљину или основу или поучицу од вуне или од лана, или шта год буде од коже, на чем буде болест; јер је љута губа, огњем нека се спали. ");
INSERT INTO srp1868_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ако ли опази свештеник да се болест није разишла по хаљини или по основи или по поучици, или по чему год од коже, ");
INSERT INTO srp1868_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","тада нека заповеди свештеник да се опере оно на чем је болест, па онда нека затвори опет за седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Па нека види свештеник пошто се опере ствар на којој је болест, и ако опази да болест није променила боје своје, ако се и не буде даље разишла, ствар је нечиста, спали је огњем; јер је љута губа на горњој или на доњој страни. ");
INSERT INTO srp1868_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ако ли види свештеник да се место смањило пошто је опрано, онда нека откине од хаљине или од коже или од основе или од поучице. ");
INSERT INTO srp1868_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ако ли се опет покаже на хаљини или на основи или на поучици или на чем год од коже, губа је која се шири, огњем спали оно на чем буде. ");
INSERT INTO srp1868_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","А хаљину или основу или поучицу или шта му драго од коже, кад опереш па отиде с њега та болест, опери још једном, и биће чисто. ");
INSERT INTO srp1868_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ово је закон за губу на хаљини вуненој или ланеној, или на основи или на поучици, или на чем год од коже, како се може знати је ли шта чисто или нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Ово је закон за губавца када се чисти: нека се доведе к свештенику, ");
INSERT INTO srp1868_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","а свештеник нека изађе иза логора; и ако види да је излечена губа на губавцу, ");
INSERT INTO srp1868_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","онда ће заповедити свештеник ономе који се чисти да узме две птице живе чисте, и дрво кедрово и црвца и исопа. ");
INSERT INTO srp1868_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","И нека заповеди свештеник да се једна птица закоље над судом земљаним над водом живом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Па нека узме живу птицу и дрво кедрово и црвац и исоп, и све то заједно са живом птицом нека замочи у крв од птице заклане над водом живом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","И нека покропи седам пута оног који се чисти од губе, и нека га прогласи да је чист, и нека пусти живу птицу у поље. ");
INSERT INTO srp1868_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Тада који се чисти нека опере хаљине своје и обрије све длаке своје, и нека се окупа у води, и биће чист; потом нека уђе у логор, али да стоји напољу не улазећи у свој шатор седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","А у седми дан нека обрије све длаке своје, главу и браду и обрве над очима, и све длаке своје нека обрије, и нека опере хаљине своје, па нека се окупа у води и биће чист. ");
INSERT INTO srp1868_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","А у осми дан нека узме два јагњета здрава и једну овцу од године здраву и три десетине ефе белог брашна замешеног с уљем за дар, и један лог уља. ");
INSERT INTO srp1868_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","А свештеник који га чисти нека постави оног који се чисти заједно с тим стварима пред Господом на вратима шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","И узевши свештеник једно јагње нека га принесе на жртву за преступ заједно с логом уља, и нека обрне тамо и амо пред Господом на жртву обртану. ");
INSERT INTO srp1868_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","А после нека закоље јагње на месту где се коље жртва за грех и жртва паљеница на светом месту, јер жртва за преступ припада свештенику као и жртва за грех; светиња је над светињама. ");
INSERT INTO srp1868_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Тада нека свештеник узме крви од жртве за преступ и помаже крај десног уха ономе који се чисти и палац десне руке његове и палац десне ноге његове. ");
INSERT INTO srp1868_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Потом нека узме свештеник од лога уља и налије на длан свој леви. ");
INSERT INTO srp1868_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Па нека замочи свештеник прст од десне руке своје у уље што му је на левом длану, и нека покропи уљем с прста свог седам пута пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","А осталим уљем што му је на длану нека помаже свештеник крај десног уха ономе који се чисти, и палац десне руке његове и палац десне ноге његове по крви од жртве за преступ. ");
INSERT INTO srp1868_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","А шта још остане од уља на длану свештенику, оним нека намаже главу ономе који се чисти, и тако ће га очистити свештеник пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Потом нека принесе свештеник жртву за грех, и очистиће оног који се чисти од своје нечистоте; а после нека закоље жртву паљеницу. ");
INSERT INTO srp1868_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","И нека принесе свештеник жртву паљеницу заједно с даром на олтару; и тако ће га очистити, и биће чист. ");
INSERT INTO srp1868_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Али ако је сиромах, те не може донети толико, онда нека узме једно јагње за жртву ради преступа да се принесе жртва обртана за очишћење његово, и једну десетину ефе белог брашна замешеног с уљем за дар, и лог уља. ");
INSERT INTO srp1868_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","И две грлице или два голубића, које може прискрбити, да буде једно жртва за грех а друго жртва паљеница. ");
INSERT INTO srp1868_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","И то нека донесе у осми дан свог чишћења свештенику на врата шатора од састанка пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Тада свештеник нека узме јагње за преступ и лог уља, и то нека свештеник обрне пред Господом за жртву обртану. ");
INSERT INTO srp1868_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","И нека закоље јагње за жртву ради преступа, и узевши свештеник крви од жртве за преступ нека помаже крај десног уха ономе који се чисти и палац десне руке његове и палац десне ноге његове. ");
INSERT INTO srp1868_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","И уља нека налије свештеник на длан свој леви, ");
INSERT INTO srp1868_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","па нека замочи прст од десне руке своје у уље што му је на левом длану, и нека покропи уљем с прста свог седам пута пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","И уљем што му је на длану нека помаже свештеник крај десног уха ономе који се чисти, и палац десне руке његове и палац десне ноге његове по месту где је крв од жртве за преступ. ");
INSERT INTO srp1868_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","А шта још остане од уља на длану свештенику, оним нека намаже главу ономе који се чисти, и тако ће га очистити пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Тако нека учини и с једном грлицом или голупчетом од оних које прискрби. ");
INSERT INTO srp1868_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Шта је прискрбио, једно ће бити жртва за грех а друго жртва паљеница с даром; и тако ће свештеник очистити пред Господом оног који се чисти. ");
INSERT INTO srp1868_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","То је закон за губавца који не може прискрбити све што треба за очишћење. ");
INSERT INTO srp1868_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","И рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Кад дођете у земљу хананску, коју ћу вам ја дати да је ваша, па кад пустим губу на коју кућу у земљи коју ћете држати, ");
INSERT INTO srp1868_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","онда онај чија је кућа нека дође и јави свештенику говорећи: Чини ми се као да је губа на кући. ");
INSERT INTO srp1868_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","А свештеник нека заповеди да се испразни кућа пре него он дође да види губу, да се не би оскврнило шта је у кући; потом нека дође свештеник да види кућу. ");
INSERT INTO srp1868_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Па кад види болест, ако буде болест на зидовима кућним као рупице зеленкасте или црвенкасте и на очи ниже од зида, ");
INSERT INTO srp1868_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","нека изађе свештеник из куће оне на врата кућна, и затвори кућу за седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","После опет нека дође свештеник у седми дан, па ако види да се болест даље разишла по зидовима кућним, ");
INSERT INTO srp1868_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","заповедиће свештеник да поваде камење на коме је болест и да га баце иза града на место нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","А кућу заповедиће да остружу изнутра свуда унаоколо, и прах што састружу да проспу иза града на место нечисто, ");
INSERT INTO srp1868_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","и да узму друго камење и углаве на место где је било пређашње камење; тако и блато друго узевши да облепе кућу. ");
INSERT INTO srp1868_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ако се поврати болест и опет израсте по кући, пошто се повади камење и оструже кућа и наново облепи, ");
INSERT INTO srp1868_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","тада дошав свештеник ако види да се болест разишла по кући, љута је губа на кући, нечиста је. ");
INSERT INTO srp1868_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Нека се разруши она кућа, камење и дрва и сав леп од оне куће, и нека се изнесе иза града на место нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","А ко би ушао у кућу ону док је затворена, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","И ко би спавао у оној кући, нека опере хаљине своје; тако и ко би јео у оној кући, нека опере хаљине своје. ");
INSERT INTO srp1868_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ако ли свештеник дошав види да се није болест разишла по кући пошто је кућа наново облепљена, нека прогласи свештеник да је чиста, јер се излечила болест. ");
INSERT INTO srp1868_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","И нека узме да би се кућа очистила две птице и дрво кедрово и црвца и исопа, ");
INSERT INTO srp1868_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","и нека закоље једну птицу над судом земљаним над водом живом. ");
INSERT INTO srp1868_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Па нека узме дрво кедрово и исоп и црвац и другу птицу живу, и нека замочи у крв од заклане птице и у воду живу, и покропи кућу седам пута. ");
INSERT INTO srp1868_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","И тако ће очистити кућу ону крвљу птичијом и водом живом и птицом живом и дрветом кедровим и исопом и црвцем. ");
INSERT INTO srp1868_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Па онда нека пусти птицу живу иза града у поље; и очистиће кућу, и биће чиста. ");
INSERT INTO srp1868_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ово је закон за сваку губу и за оспу, ");
INSERT INTO srp1868_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","за губу на хаљини и на кући, ");
INSERT INTO srp1868_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","и за оток и за красту и за бубуљицу, ");
INSERT INTO srp1868_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","да се зна кад је ко нечист и кад је ко чист. То је закон за губу. ");
INSERT INTO srp1868_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Још рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Кажите синовима Израиљевим и реците им: Коме човеку тече семе од тела његовог, нечист је. ");
INSERT INTO srp1868_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","А оваква је нечистота његова од тог течења: ако испусти тело његово течење своје, или се устави течење у телу његовом, нечистота је на њему. ");
INSERT INTO srp1868_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Свака постеља на коју легне онај коме тече семе, да је нечиста; и све на шта седне, да је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","И ко се год дотакне постеље његове, нека опере хаљине своје и нека се окупа у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","И ко седне на оно на чему је седео онај коме тече семе, нека опере хаљине своје и нека се окупа у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","И ко се дотакне тела оног коме тече семе, нека опере хаљине своје и нека се окупа у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","И ако онај коме тече семе пљуне на чистог, он нека опере хаљине своје и нека се окупа у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","И свако седло на коме би седео онај коме тече семе, да је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","И ко би се дотакао чега год што је било под њим, да је нечист до вечера; и ко би шта такво носио, нека опере хаљине своје и окупа се у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","И кога би се дотакао онај коме тече семе не оправши руку својих водом, нека опере хаљине своје и окупа се у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","И суд земљани ког би се дотакао онај коме тече семе, нека се разбије, а дрвени суд нека се опере водом. ");
INSERT INTO srp1868_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","А кад се онај коме тече семе очисти од течења свог, нека броји седам дана пошто се очисти, и нека опере хаљине своје и нека тело своје опере водом живом, и биће чист. ");
INSERT INTO srp1868_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","А у осми дан нека узме две грлице или два голубића, и нека дође пред Господа на врата шатора од састанка, и нека их да свештенику. ");
INSERT INTO srp1868_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","И свештеник нека принесе једно од њих на жртву за грех а друго на жртву паљеницу; тако ће га очистити свештеник пред Господом од течења његовог. ");
INSERT INTO srp1868_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","И човек коме изађе семе кад спава са женом нека опере водом цело тело своје, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","И свака хаљина и свака кожа на којој буде такво семе, нека се опере водом и биће нечисто до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","И жена код које буде спавао такав човек, и она и он нека се окупају у води и биће нечисти до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","А жена кад има време, кад иде крв од тела њеног, нека се одваја седам дана, и ко је се год дотакне, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","И на шта год легне док се одваја, да је нечисто, и на шта год седне, да је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","И ко се дотакне постеље њене, нека опере хаљине своје и нека се окупа у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","И ко се дотакне чега на чему је она седела, нека опере хаљине своје и нека се окупа у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","И шта би год било на постељи њеној или на чем је она седела, па се ко дотакне тога, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","А ко би спавао с њом те би нечистота њена дошла на њ, да је нечист седам дана, и постеља на којој лежи да је нечиста. ");
INSERT INTO srp1868_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","А жена, од које би ишла крв дуго времена или осим обичног времена или у обично време, али дуже, докле год тече нечистота њена биће нечиста као у време када се одваја. ");
INSERT INTO srp1868_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Постеља на којој лежи докле јој год крв иде, да јој је као постеља кад се одваја; и на чем би год седела да је нечисто као што је нечисто кад се одваја. ");
INSERT INTO srp1868_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","И ко се год дотакне тих ствари, нечист је; зато нека опере хаљине своје и окупа се у води, и биће нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","А кад се очисти од течења крви своје, нека броји седам дана, па онда да је чиста. ");
INSERT INTO srp1868_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","И у осми дан нека узме две грлице или два голубића, и нека их однесе свештенику на врата шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","И нека свештеник принесе једно на жртву за грех а друго на жртву паљеницу, и очистиће је свештеник пред Господом од течења нечистоте њене. ");
INSERT INTO srp1868_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Тако ћете одлучивати синове Израиљеве од нечистота њихових, да не гину с нечистота својих скврнећи шатор мој што је усред њих. ");
INSERT INTO srp1868_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","То је закон за оног коме тече семе и коме изађе семе кад спава са женом те буде нечист, ");
INSERT INTO srp1868_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","и за жену кад болује од течења крви своје, и за сваког који болује од течења свог, било мушко или женско, и за човека који би лежао са нечистом. ");
INSERT INTO srp1868_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","И рече Господ Мојсију пошто погибоше два сина Аронова, а погибоше кад приступише пред Господа, ");
INSERT INTO srp1868_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","и каза Господ Мојсију: Реци Арону, брату свом, да не улази у свако доба у светињу за завес пред заклопац који је на ковчегу, да не погине, јер ћу се у облаку над заклопцем јављати. ");
INSERT INTO srp1868_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","С овим нека улази Арон у светињу: с јунцем за жртву ради греха и с овном за жртву паљеницу. ");
INSERT INTO srp1868_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Свету кошуљу ланену нека обуче, и гаће ланене нека су на телу његовом, и нека се опаше појасом ланеним и капу ланену нека метне на главу; то су хаљине свете, и нека опере тело своје водом, па онда нека их обуче. ");
INSERT INTO srp1868_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","А од збора синова Израиљевих нека узме два јарца за жртву ради греха, и једног овна за жртву паљеницу. ");
INSERT INTO srp1868_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","И нека принесе Арон јунца свог на жртву за грех и очисти себе и дом свој. ");
INSERT INTO srp1868_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Потом нека узме два јарца, и нека их метне пред Господа на врата шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","И нека Арон баци жреб за та два јарца, један жреб Господу а други жреб Азазелу. ");
INSERT INTO srp1868_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","И нека Арон принесе на жртву јарца на ког падне жреб Господњи, нека га принесе на жртву за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","А јарца на ког падне жреб Азазелов нека метне жива пред Господа, да учини очишћење на њему, па нека га пусти у пустињу Азазелу. ");
INSERT INTO srp1868_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","И нека Арон принесе јунца свог на жртву за грех и очисти себе и дом свој, и нека закоље јунца свог на жртву за грех. ");
INSERT INTO srp1868_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","И нека узме кадионицу пуну жеравице с олтара, који је пред Господом, и пуне прегршти када мирисног истуцаног, и нека унесе за завес. ");
INSERT INTO srp1868_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","И нека метне кад на огањ пред Господом, да дим од када заклони заклопац који је на сведочанству; тако неће погинути. ");
INSERT INTO srp1868_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","После нека узме крви од јунца и покропи с прста свог по заклопцу према истоку, а пред заклопцем нека седам пута покропи том крвљу с прста свог. ");
INSERT INTO srp1868_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","И нека закоље јарца на жртву за грех народни, и нека учини с крвљу његовом као што је учинио с крвљу јунчијом, и покропи њом по заклопцу и пред заклопцем. ");
INSERT INTO srp1868_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","И тако ће очистити светињу од нечистота синова Израиљевих и од преступа њихових у свим гресима њиховим; тако ће учинити и у шатору од састанка, који је међу њима усред нечистота њихових. ");
INSERT INTO srp1868_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","А нико да не буде у шатору од састанка кад он уђе да чини очишћење у светињи, докле не изађе и сврши очишћење за се и за дом свој и за сав збор израиљски. ");
INSERT INTO srp1868_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","А нека изађе к олтару који је пред Господом, и очисти га; и узевши крви од јунца и крви од јарца нека помаже рогове олтару унаоколо; ");
INSERT INTO srp1868_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","и нека га покропи одозго истом крвљу с прста свог седам пута; тако ће га очистити и посветити га од нечистота синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","А кад очисти светињу и шатор од састанка и олтар, тада нека доведе јарца живог. ");
INSERT INTO srp1868_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","И метнувши Арон обе руке своје на главу јарцу живом, нека исповеди над њим сва безакоња синова Израиљевих и све преступе њихове у свим гресима њиховим, и метнувши их на главу јарцу нека га да човеку спремном да га истера у пустињу. ");
INSERT INTO srp1868_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","И јарац ће однети на себи сва безакоња њихова у пустињу; и пустиће оног јарца у пустињу. ");
INSERT INTO srp1868_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Потом нека опет уђе Арон у шатор од састанка и свуче хаљине ланене које је обукао када је ишао у светињу, и онде нека их остави. ");
INSERT INTO srp1868_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Па нека опере тело своје на светом месту и обуче своје хаљине; и изашав нека принесе своју жртву паљеницу, и очисти себе и народ. ");
INSERT INTO srp1868_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","А сало од жртве за грех нека запали на олтару. ");
INSERT INTO srp1868_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","А ко одведе јарца за Азазела, нека опере хаљине своје и окупа тело своје у води, па онда нека уђе у логор. ");
INSERT INTO srp1868_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","А јунца за грех и јарца за грех, од којих је крв унесена да се учини очишћење у светињи, нека изнесу напоље из логора, и нека спале огњем коже њихове и месо њихово и балегу њихову. ");
INSERT INTO srp1868_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","А ко их спали, нека опере хаљине своје и окупа тело своје у води, па онда нека дође у логор. ");
INSERT INTO srp1868_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","И ово нека вам буде вечна уредба: десети дан седмог месеца мучите душе своје, и не радите никакав посао, ни домородац ни дошљак који се бави међу вама. ");
INSERT INTO srp1868_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Јер у тај дан бива очишћење за вас, да се очистите; бићете очишћени од свих греха својих пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","То нека вам је почивање суботно, и мучите душе своје по уредби вечној. ");
INSERT INTO srp1868_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","А свештеник који буде помазан и који буде освећен да врши службу свештеничку на место оца свог, он нека очишћа обукавши се у хаљине ланене, хаљине свете. ");
INSERT INTO srp1868_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","И нека очисти светињу свету и шатор од састанка; и олтар нека очисти; и свештенике и сав народ сабрани нека очисти. ");
INSERT INTO srp1868_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","И ово нека вам је вечна уредба да очишћате синове Израиљеве од свих греха њихових један пут у години. И учини Мојсије како му заповеди Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Кажи Арону и синовима његовим и свим синовима Израиљевим, и реци им: Ово је заповедио Господ говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ко год од дома Израиљевог закоље вола или јагње или козу у логору, или ко год закоље изван логора, ");
INSERT INTO srp1868_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","а не доведе на врата шатора од састанка, да принесе принос Господу пред шатором Господњим, крив је за крв; зато да се истреби онај човек из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Зато синови Израиљеви нека доведу жртве своје, које би клали у пољу, нека их доведу Господу на врата шатора од састанка к свештенику, и нека принесу жртве захвалне Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","И свештеник нека покропи крвљу по олтару Господњем на вратима шатора од састанка, и сало нека запали на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","И нека више не приносе жртве своје ђаволима, за којима они чине прељубу. Ово нека им буде закон вечан од колена на колено. ");
INSERT INTO srp1868_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Зато им реци: Ко би год од дома Израиљевог или између странаца који се баве међу њима принео жртву паљеницу или другу жртву, ");
INSERT INTO srp1868_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","а не би је довео на врата шатора од састанка да је принесе Господу, тај човек да се истреби из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","А ко би год од дома Израиљевог или између странаца који се баве међу њима јео какву год крв, окренућу лице своје насупрот оном човеку који буде јео крв, и истребићу га из народа његовог. ");
INSERT INTO srp1868_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Јер је душа телу у крви; а ја сам вам је одредио за олтар да се чисте душе ваше; јер је крв што душу очишћа. ");
INSERT INTO srp1868_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Зато рекох синовима Израиљевим: Нико између вас да не једе крв; ни дошљак који се бави међу вама да не једе крв. ");
INSERT INTO srp1868_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","И ко би год између синова Израиљевих или између дошљака који се баве код њих уловио зверку или птицу, која се једе, нека исцеди крв из ње, и заспе је земљом. ");
INSERT INTO srp1868_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Јер је душа сваког тела крв његова, то му је душа. Зато рекох синовима Израиљевим: Крв ни једног тела не једите, јер је душа сваког тела крв његова. Ко би је год јео, да се истреби. ");
INSERT INTO srp1868_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","А ко би јео месо од животиње која цркне или коју раскине зверка, био домородац или дошљак, нека опере хаљине своје и окупа се у води, и биће нечист до вечера, а после ће бити чист. ");
INSERT INTO srp1868_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ако ли их не опере, и тела свог не окупа, носиће безакоње своје. ");
INSERT INTO srp1868_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Још рече Господ говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Кажи синовима Израиљевим, и реци им: Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Немојте чинити шта се чини у земљи мисирској, у којој сте живели, нити чините шта се чини у земљи хананској, у коју вас водим, и по уредбама њиховим немојте живети. ");
INSERT INTO srp1868_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Него моје законе вршите и моје уредбе држите живећи по њима. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Држите уредбе моје и законе моје; ко их врши, жив ће бити кроз њих. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Нико да не приступа к родици својој по крви, да не открије голотињу њену. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Голотиње оца свог ни голотиње матере своје не откриј; мати ти је; не откриј голотиње њене. ");
INSERT INTO srp1868_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Голотиње жене оца свог не откриј; голотиња је оца твог. ");
INSERT INTO srp1868_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Голотиње сестре своје, кћери оца свог или кћери матере своје, која је рођена у кући или изван куће, не откриј голотиње њихове. ");
INSERT INTO srp1868_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Голотиње кћери сина свог, или кћери кћери своје не откриј; јер је твоја голотиња. ");
INSERT INTO srp1868_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Голотиње кћери жене оца свог, коју је родио отац твој, не откриј; сестра ти је. ");
INSERT INTO srp1868_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Голотиње сестре оца свог не откриј; једна је крв са оцем твојим. ");
INSERT INTO srp1868_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Голотиње сестре матере своје не откриј; јер је једна крв с матером твојом. ");
INSERT INTO srp1868_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Голотиње брата оца свог не откриј приступајући к жени његовој; стрина ти је. ");
INSERT INTO srp1868_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Голотиње жене сина свог не откриј; снаха ти је, не откриј голотиње њене. ");
INSERT INTO srp1868_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Голотиње жене брата свог не откриј; голотиња је брата твог. ");
INSERT INTO srp1868_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Голотиње жене и кћери њене не откриј; кћери сина њеног ни кћери кћери њене немој узети да откријеш голотињу њихову; једна су крв; зло је. ");
INSERT INTO srp1868_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Немој узети жене преко једне жене, да је уцвелиш откривајући голотињу другој за живота њеног. ");
INSERT INTO srp1868_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","К жени докле се одваја ради нечистоте своје не иди да откријеш голотињу њену. ");
INSERT INTO srp1868_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Са женом ближњег свог не лези скврнећи се с њом. ");
INSERT INTO srp1868_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Од семена свог не дај да се однесе Молоху, да не оскврниш имена Бога свог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","С мушкарцем не лези као са женом; гадно је. ");
INSERT INTO srp1868_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Живинче никакво немој облежати скврнећи се с њим; и жена да не легне под живинче; грдило је. ");
INSERT INTO srp1868_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Немојте се скврнити ни једном овом стварју; јер су се свим тим стварима оскврнили народи које ћу одагнати испред вас. ");
INSERT INTO srp1868_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Јер се оскврнила земља, и неваљалство ћу њено походити на њој, и изметнуће земља становнике своје. ");
INSERT INTO srp1868_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Него ви држите законе моје и уредбе моје, и не чините ни једног овог гада, ни домородац ни дошљак који се бави међу вама; ");
INSERT INTO srp1868_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","јер све ове гадове чинише људи у овој земљи који су били пре вас, и земља је од тога оскврњена; ");
INSERT INTO srp1868_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","да не изметне земља вас, ако је оскврните, као што је изметнула народ који је био пре вас. ");
INSERT INTO srp1868_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Јер ко учини шта год од ових гадова, истребиће се из народа свог душе које учине. ");
INSERT INTO srp1868_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Зато држите шта сам наредио да се држи, да не чините шта од гадних обичаја који су били пре вас, и да се не скврните о њих. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Кажи свему збору синова Израиљевих, и реци им: Будите свети, јер сам ја свет, Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Сваки да се боји матере своје и оца свог; и држите суботе моје; ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Не обраћајте се к идолима, и богове ливене не градите себи; ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","А кад приносите жртву захвалну Господу, приносите је драге воље. ");
INSERT INTO srp1868_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","У који је дан принесете, нека се једе, и сутрадан; а шта остане до трећег дана, нека се огњем сажеже. ");
INSERT INTO srp1868_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","А ако би се шта јело трећи дан, гад је, неће бити угодна. ");
INSERT INTO srp1868_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ко би год јео, носиће своје безакоње, јер оскврни светињу Господњу; зато ће се истребити она душа из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","А кад жањете род земље своје, немој пожети сасвим њиву своју, нити пабирчи по жетви. ");
INSERT INTO srp1868_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ни виноград свог немој пабирчити, и немој купити зрна која падну по винограду твом; него остави сиромаху и дошљаку. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Не крадите; не лажите и не варајте ближњег свог. ");
INSERT INTO srp1868_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Не куните се именом мојим криво; јер ћеш оскврнити име Бога свог. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Не закидај ближњег свог и не отимај му; плата надничарова да не преноћи код тебе до јутра. ");
INSERT INTO srp1868_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Немој псовати глувог, ни пред слепца метати шта да се спотакне; него се бој Бога свог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Не чините неправду на суду, не гледајте што је ко сиромах, нити се поводи за богатим; право суди ближњему свом. ");
INSERT INTO srp1868_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Не иди као опадач по народу свом, и не устај на крв ближњег свог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Немој мрзети на брата свог у срцу свом; слободно искарај ближњег свог, и немој трпети греха на њему. ");
INSERT INTO srp1868_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Не буди осветљив, и не носи срдњу на синове народа свог; него љуби ближњег свог као себе самог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Уредбе моје држите; живинчета свог не пуштај на живинче друге врсте; не засевај њиве своје двојаким семеном, и не облачи на се хаљине од двојаких ствари. ");
INSERT INTO srp1868_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ако би ко облежао робињу, која је испрошена али није откупљена ни ослобођена, обоје да се шибају, али да се не погубе; јер није била ослобођена. ");
INSERT INTO srp1868_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","И нека он принесе Господу жртву за преступ свој на врата шатора од састанка, овна за преступ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","И нека га очисти пред Господом свештеник овном принесеним за преступ од греха који је учинио; и опростиће му се грех његов. ");
INSERT INTO srp1868_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","А кад дођете у земљу и насадите свакојаког воћа, обрежите му окрајак, род његов; три године нека вам је необрезано, и не једите га. ");
INSERT INTO srp1868_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","А четврте године нека буде сав род његов посвећен у хвалу Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Па тек пете године једите воће с њега, да би вам се умножио род његов. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Ништа не једите с крвљу. Немојте врачати, ни гатати по времену. ");
INSERT INTO srp1868_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Не стрижите косу своју укруг, ни грдите браду своју. ");
INSERT INTO srp1868_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","За мртвацем не режите тело своје, ни ударајте на се какве белеге. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Немој скврнити кћер своју пуштајући је да се курва, да се не би земља прокурвала и напунила се безакоња. ");
INSERT INTO srp1868_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Држите суботе моје, и светињу моју поштујте. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Не обраћајте се к врачарима и гатарима, нити их питајте, да се не скврните о њих. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Пред седом главом устани, и поштуј лице старчево, и бој се Бога свог. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Ако је у тебе дошљак у земљи вашој, не чини му криво. ");
INSERT INTO srp1868_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ко је дошљак међу вама, нека вам буде као онај који се родио међу вама, и љубите га као себе самог; јер сте и ви били дошљаци у земљи мисирској. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Не чините неправде у суду, ни мером за дужину, ни мером за тежину, ни мером за ствари које се сипају. ");
INSERT INTO srp1868_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Мерила нека су вам права, камење право, ефа права, ин прав. Ја сам Господ Бог ваш, који сам вас извео из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Држите, дакле, све уредбе моје и све законе моје, и вршите их. Ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Још реци синовима Израиљевим: Ко год између синова Израиљевих или између дошљака који се баве у Израиљу, да од семена свог Молоху, нека се погуби, народ у земљи нека га заспе камењем. ");
INSERT INTO srp1868_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","И ја ћу окренути лице своје насупрот таквом човеку, и истребићу га из народа његовог, што од семена свог даде Молоху, и запрзни светињу моју и оскврни свето име моје. ");
INSERT INTO srp1868_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ако ли народ како год затвори очи да не види тог човека кад да од семена свог Молоху, и не убију га, ");
INSERT INTO srp1868_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ја ћу окренути лице своје насупрот оном човеку и насупрот дому његовом, и истребићу га, и све који за њим чине прељубу чинећи прељубу за Молохом, из народа њиховог. ");
INSERT INTO srp1868_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","А ко се обрати к врачарима и к гатарима да чини прељубу за њима, окренућу лице своје на супрот њему, и истребићу га из народа његовог. ");
INSERT INTO srp1868_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Зато посвећујте се, и будите свети, јер сам ја Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","И чувајте уредбе моје и вршите их. Ја сам Господ који вас посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ко опсује оца свог или матер своју, да се погуби; опсовао је оца свог или матер своју; крв његова на њ. ");
INSERT INTO srp1868_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","А човек који учини прељубу с туђом женом, што је учинио прељубу са женом ближњег свог, да се погуби и прељубочинац и прељубочиница. ");
INSERT INTO srp1868_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ко би спавао са женом оца свог, открио је голотињу оца свог; обоје да се погубе; крв њихова на њих. ");
INSERT INTO srp1868_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ко би спавао са женом сина свог, обоје да се погубе; учинише срамоту; крв њихова на њих. ");
INSERT INTO srp1868_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Ко би мушкарца облежао као жену, учинише гадну ствар обојица; да се погубе; крв њихова на њих. ");
INSERT INTO srp1868_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","И ко би узео жену и матер њену, зло је, огњем да се спали и он и она, да не буде зла међу вама. ");
INSERT INTO srp1868_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ко би облежао живинче, да се погуби; убијте и живинче. ");
INSERT INTO srp1868_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","И ако би жена легла под живинче, убиј и жену и живинче, нека погину, крв њихова на њих. ");
INSERT INTO srp1868_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Ко би узео сестру своју, кћер оца свог или кћер матере своје, видео би голотињу њену и она би видела голотињу његову, срамота је; зато да се истребе испред синова народа свог; открио је голотињу сестре своје, нека носи безакоње своје. ");
INSERT INTO srp1868_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","И ко би спавао са женом кад има време и открио голотињу њену откривши течење њено, и она би открила течење крви своје, да се истребе обоје из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Голотиње сестре матере своје и сестре оца свог не откриј, јер би открио своју крв; нека носе безакоње своје. ");
INSERT INTO srp1868_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","А ко би спавао са женом стрица свог, открио би голотињу стрица свог, нека носе обоје грех свој, нека помру без деце. ");
INSERT INTO srp1868_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Ко би узео жену брата свог, ружно је, открио је голотињу брата свог; без деце да буду. ");
INSERT INTO srp1868_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Чувајте све уредбе моје и све законе моје, и вршите их, да вас земља не изметне, у коју вас водим да живите у њој. ");
INSERT INTO srp1868_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Немојте живети по уредбама народа које ћу отерати испред вас, јер су чинили све то, зато ми омрзоше. ");
INSERT INTO srp1868_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","И рекох вам: Ви ћете наследити земљу њихову и ја ћу вам је дати у државу, земљу у којој тече млеко и мед. Ја сам Господ Бог ваш који вас одвојих од других народа. ");
INSERT INTO srp1868_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Зато разликујте стоку чисту од нечисте, и птицу чисту од нечисте, и немојте скврнити душа својих стоком или птицом или чим год што пуже по земљи, што сам вам одвојио да је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","И бићете ми свети, јер сам свет ја, Господ, и одвојих вас од других народа да будете моји. ");
INSERT INTO srp1868_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","А човек или жена, у којима би био дух врачарски или гатарски, да се погубе, камењем да се заспу, крв њихова на њих. ");
INSERT INTO srp1868_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Још рече Господ Мојсију: Кажи свештеницима синовима Ароновим, и реци им: За мртвацем да се не скврни ни један у народу свом, ");
INSERT INTO srp1868_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","осим за родом својим по крви, за матером својом или за оцем својим или за сином својим или за кћерју својом или за братом својим, ");
INSERT INTO srp1868_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","или за рођеном сестром својом, девојком, која није имала мужа; за њом се може оскврнити. ");
INSERT INTO srp1868_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ако је ожењен, да се не оскврни за женом својом у народу свом учинивши се нечист. ");
INSERT INTO srp1868_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Да се не начине ћелави чупајући косу с главе своје и да не брију браде своје, нити се режу по телу свом. ");
INSERT INTO srp1868_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Нека буду свети Богу свом, и нека не скврне име Бога свог, јер приносе жртве огњене Господње, хлеб Бога свог, зато нека су свети. ");
INSERT INTO srp1868_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Нека се не жене женом курвом или силованом; ни пуштеницом нека се не жене; јер су свети Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","И теби нека је сваки свет, јер приноси хлеб Бога твог; свет нека ти је, јер сам ја свет, Господ, који вас посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","А кћи свештеничка која се оскврни курвајући се, скврни оца свог, огњем нека се спали. ");
INSERT INTO srp1868_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","А свештеник највиши између браће своје, коме се на главу излије уље помазања и који је посвећен да се облачи у свете хаљине, нека не открива главе своје, и хаљине своје нека не раздире. ");
INSERT INTO srp1868_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","И к мртвацу ни једном нека не иде, ни за оцем својим ни за матером својом да се не оскврни. ");
INSERT INTO srp1868_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","И из светиње нека не излази, да не би оскврнио светињу Бога свог, јер је на њену венац, уље помазања Бога његовог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Он нека се жени девицом. ");
INSERT INTO srp1868_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Удовицом или пуштеницом или силованом или курвом да се не жени; него девојком из народа свог нека се ожени. ");
INSERT INTO srp1868_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","И нека не скврни семе народа свог у народу свом, јер сам ја Господ, који га посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Кажи Арону и реци: У кога би из семена твог од колена до колена била мана на телу, онај нека не приступа да приноси хлеб Бога свог. ");
INSERT INTO srp1868_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Јер нико на коме би била мана не ваља да приступа, ни слеп, ни хром, ни у кога би био који уд превећ мали или превећ велики, ");
INSERT INTO srp1868_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ни у кога је сломљена нога или рука, ");
INSERT INTO srp1868_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ни грбав, ни дрљав, ни ко има биону на оку, ни шугав, ни лишајив, ни просут. ");
INSERT INTO srp1868_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","У кога би год из семена Арона свештеника била каква мана на телу, нека не приступа да приноси жртве огњене Господу; мана је на њему; да не приступа да приноси хлеб Бога свог. ");
INSERT INTO srp1868_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Али хлеб Бога свог од ствари пресветих и од ствари светих нека једе; ");
INSERT INTO srp1868_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","али за завес нека не улази; к олтару нека се не приближује, јер је мана на њему, па нека не скврни светиње моје, јер сам ја Господ који их посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","И Мојсије каза то Арону и синовима његовим и свим синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Кажи Арону и синовима његовим да се чувају од светих ствари синова Израиљевих, да не би оскврнили свето име моје у оном што ми они посвећују; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Реци им: Ко би год из семена вашег од колена на колено приступио к светим стварима, које би посветили синови Израиљеви Господу, кад је нечистота његова на њему, тај нека се истреби испред лица мог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ко би год из семена Ароновог био губав или би ишло семе од њега, нека не једе свете ствари докле не буде чист; тако и који би се дотакао кога нечистог од мртвог тела или оног од кога је изашло семе, ");
INSERT INTO srp1868_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","или ко би се дотакао чега што гамиже по земљи, од чега би се оскврнио, или човека од ког би се оскврнио какве му драго нечистоте његове, ");
INSERT INTO srp1868_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ко би се дотакао таквог чега, биће нечист до вечера; зато нека не једе свете ствари ако не окупа тело своје у води. ");
INSERT INTO srp1868_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","А кад зађе сунце, биће чист, и онда може јести од светих ствари; јер му је храна. ");
INSERT INTO srp1868_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Мрцино или шта раскине зверка нека не једе, да се њим не скврни; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Тако нека држе шта сам уредио да се држи, да не навуку на се греха и не умру од њега оскврнивши се. Ја сам Господ који их посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Нико други да не једе свете ствари, ни укућанин свештеников ни надничар да не једе свете ствари. ");
INSERT INTO srp1868_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","А кад свештеник купи кога за новце, тај нека их једе, и који се роди у кући његовој; они нека једу јело његово. ");
INSERT INTO srp1868_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Али кћи свештеничка кад се уда за човека другог племена, она да не једе од жртава подигнутих светих ствари. ");
INSERT INTO srp1868_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","А кћи свештеничка ако обудови, или је пусти муж, ако нема порода, нека се врати кући оца свог као што је била у детињству свом, хлеб оца свог нека једе; али нико другог племена да га не једе. ");
INSERT INTO srp1868_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","А ко би нехотице јео свету ствар, нека дометне пети део и накнади свештенику свету ствар. ");
INSERT INTO srp1868_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Да не би оскврнили свете ствари синова Израиљевих, које приносе Господу, ");
INSERT INTO srp1868_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","и да не би навлачили на њих кар за преступ једући свете ствари њихове, јер сам ја Господ, који их посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Кажи Арону и синовима његовим и свим синовима Израиљевим и реци им: Ко год од дома Израиљевог или од странаца који су у Израиљу хоће да принесе жртву своју по каквом год завету свом, или од добре воље своје дар, што се приноси Господу на жртву паљеницу, ");
INSERT INTO srp1868_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","нека принесе драге воље мушко здраво од говеда или од оваца или од коза. ");
INSERT INTO srp1868_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","На чем би била мана, оно не приносите, јер вам се не би примило. ");
INSERT INTO srp1868_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","И кад ко хоће да принесе жртву захвалну Господу, извршавајући завет или од своје воље дајући дар, од говеда или од ситне стоке, нека буде здраво, да би било примљено; никакве мане да нема на њему. ");
INSERT INTO srp1868_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Слепо, или коме је шта сломљено или одбијено, ни гутаво, ни краставо ни лишајиво, шта је такво не приносите Господу, и не мећите их на олтар Господњи на жртву огњену. ");
INSERT INTO srp1868_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","А вола или овцу или козу са удом којим превеликим или премалим можеш принети за добровољни дар; али за завет неће се примити. ");
INSERT INTO srp1868_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Ујаловљено увртањем, тучењем, кидањем или резањем, не приносите Господу; и не чините то у земљи својој. ");
INSERT INTO srp1868_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","И из руке туђинске немојте узимати ни једне ствари да принесете хлеб Богу свом; јер је квар њихов у њима; имају ману, неће вам се примити. ");
INSERT INTO srp1868_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Теле и јагње и јаре кад се омлади, нека буде седам дана код мајке своје, па од осмог дана и после биће угодно за жртву огњену Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","А краву ни овцу ни козу не кољите у један дан с младетом њеним. ");
INSERT INTO srp1868_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","И кад приносите Господу жртву ради хвале, принесите је драговољно. ");
INSERT INTO srp1868_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Нека се једе истог дана, и не остављајте ништа до јутра; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Зато држите заповести моје, и вршите их; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","И немојте скврнити свето име моје, и ја ћу се светити међу синовима Израиљевим; ја сам Господ, који вас посвећујем. ");
INSERT INTO srp1868_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Који сам вас извео из земље мисирске да вам будем Бог; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Кажи синовима Израиљевим, и реци им: Празници Господњи, које ћете звати свети сабори, ово су празници моји: ");
INSERT INTO srp1868_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Шест дана ради, а седми дан, који је субота за почивање, нека буде свети сабор, не радите ни један посао; субота је Господња по свим становима вашим. ");
INSERT INTO srp1868_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ово су празници Господњи, сабори свети, на које ћете се сабирати у време њихово: ");
INSERT INTO srp1868_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Четрнаестог дана првог месеца увече, пасха је Господња. ");
INSERT INTO srp1868_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","А петнаестог дана истог месеца празник је пресних хлебова Господу; седам дана једите хлебове пресне. ");
INSERT INTO srp1868_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Први дан нека вам буде сабор свети, никакав посао ропски не радите. ");
INSERT INTO srp1868_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Него за седам дана приносите Господу жртве огњене; а седми дан нека је сабор свети; не радите ниједан посао ропски. ");
INSERT INTO srp1868_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Кажи синовима Израиљевим, и реци им: Кад дођете у земљу коју ћу вам дати, и станете жети у њој, тада донесите сноп првина од жетве своје к свештенику; ");
INSERT INTO srp1868_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","а он нека обрће сноп пред Господом, да би вам се примио; сутрадан по суботи нека га обрће свештеник. ");
INSERT INTO srp1868_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","А исти дан кад будете обртали сноп, принесите јагње од године дана здраво на жртву паљеницу Господу; ");
INSERT INTO srp1868_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","и дар уза њ, две десетине ефе белог брашна замешеног с уљем, да буде жртва огњена Господу на угодни мирис; и налив уза њ, вина четврт ина. ");
INSERT INTO srp1868_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","А хлеба, ни зрна прженог ни зрна у класу немојте јести до оног дана кад принесете жртву Богу свом; то да вам је вечна уредба од колена до колена по свим становима вашим. ");
INSERT INTO srp1868_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Потом од првог дана по суботи, од дана кад принесете сноп за жртву обртану, бројте седам недеља пуних; ");
INSERT INTO srp1868_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","до првог дана по седмој недељи набројте педесет дана; онда принесите нов дар Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Из станова својих донесите два хлеба за жртву обртану; од две десетине ефе белог брашна да буду, с квасцем нека буду печени; то су првине Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","А с тим хлебом принесите седам јагањаца од године здравих, и једно теле и два овна, да буде жртва паљеница Господу с даровима својим и наливима својим, да буде жртва огњена на угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Закољите и јарца једног за грех и два јагњета од године за жртву захвалну. ");
INSERT INTO srp1868_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","И свештеник нека то обрне тамо и амо с хлебом од првина и са два јагњета на жртву обртану пред Господом; и биће свете ствари Господу за свештеника. ");
INSERT INTO srp1868_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","И саберите се у онај дан, сабор свети да вам је; ниједан посао ропски не радите законом вечним по свим становима својим од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","А кад станете жети у земљи својој, немој сасвим пожњети њиве своје, ни пабирчи по жетви; остави сиромаху и дошљаку; ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Кажи синовима Израиљевим, и реци им: Први дан седмог месеца нека вам је одмор, спомен трубни, сабор свети. ");
INSERT INTO srp1868_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ниједан посао ропски немојте радити, него принесите жртву огњену Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","А десети је дан тог месеца седмог дан очишћења; сабор свети нека вам је, и мучите душе своје, и принесите Господу жртву огњену. ");
INSERT INTO srp1868_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","У тај дан немојте радити ниједан посао, јер је дан очишћења, да се очистите пред Господом Богом својим. ");
INSERT INTO srp1868_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","А свака душа која се не би мучила у тај дан, да се истреби из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","И сваку душу која би радила какав посао у тај дан, ја ћу затрти душу ону у народу њеном. ");
INSERT INTO srp1868_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ни један посао немојте радити; то да је вечна уредба од колена до колена у свим становима вашим. ");
INSERT INTO srp1868_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Субота почивања нека вам буде, и мучите душе своје; деветог дана истог месеца кад буде вече, од вечера до вечера празнујте починак свој. ");
INSERT INTO srp1868_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Кажи синовима Израиљевим, и реци: Петнаестог дана седмог месеца празник је сеница за седам дана Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Први дан нека буде сабор свети, ниједан посао ропски немојте радити. ");
INSERT INTO srp1868_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","За седам дана приносите жртве огњене Господу; осми дан нека вам буде сабор свети, и принесите жртве огњене Господу; празник је, ниједан посао ропски немојте радити. ");
INSERT INTO srp1868_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","То су празници Господњи, које ћете празновати на саборима светим да принесете жртве огњене Господу: жртву паљеницу и дар и жртву захвалну и налив, све кад је чему дан, ");
INSERT INTO srp1868_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","осим субота Господњих и осим дарова ваших и осим свих завета ваших и осим свих добровољних приноса ваших, које ћете давати Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Али петнаести дан тог месеца седмог, кад саберете род земаљски, празнујте празник Господу седам дана; у први је дан одмор и у осми је дан одмор. ");
INSERT INTO srp1868_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","У први дан узмите воћа с лепих дрвета, и грана палмових и грана с густих дрвета и врбе с потока, и веселите се пред Господом Богом својим седам дана. ");
INSERT INTO srp1868_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","И празнујте тај празник Господу седам дана сваке године законом вечним од колена до колена, седмог месеца празнујте га. ");
INSERT INTO srp1868_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","И под сеницама будите седам дана, ко је год рођен у Израиљу нека буде под сеницама, ");
INSERT INTO srp1868_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","да би знало натражје ваше да сам ја учинио да живе под сеницама синови Израиљеви кад сам их извео из земље мисирске. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","И Мојсије каза празнике Господње синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Заповеди синовима Израиљевим нека ти донесу уље маслиново чисто, цеђено, за видело, да жишци горе вазда. ");
INSERT INTO srp1868_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Пред завесом сведочанства у шатору од састанка Арон ће их намештати да горе од вечера до јутра пред Господом вазда законом вечним од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","На свећњак чисти намештаће жишке пред Господом вазда. ");
INSERT INTO srp1868_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","И узми белог брашна, и испеци дванаест колача, сваки колач да буде од две десетине ефе. ");
INSERT INTO srp1868_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","И постави их у два реда, по шест у један ред, на чистом столу пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","И на сваки ред метни када чистог, да буде за сваки хлеб спомен, жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Сваке суботе нека их поставља свештеник пред Господом вазда узимајући од синова Израиљевих законом вечним. ");
INSERT INTO srp1868_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","И биће Аронови и синова његових, који ће јести на месту светом, јер им је светиња над светињама од огњених жртава Господњих законом вечним. ");
INSERT INTO srp1868_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","А изађе син једне Израиљке, коме је отац био Мисирац, међу синове Израиљеве, и свади се у логору син жене Израиљке с неким Израиљцем. ");
INSERT INTO srp1868_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","И псујући син жене Израиљке похули на име Божије, те га доведоше к Мојсију; а мати му беше по имену Саломита, кћи Давријина, од племена Дановог. ");
INSERT INTO srp1868_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","И метнуше га у затвор докле им се каже шта ће чинити с њим по речи Господњој. ");
INSERT INTO srp1868_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","А Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Изведи тог псовача напоље из логора, и нека сви који су чули метну руке своје на главу његову, и нека га сав народ заспе камењем. ");
INSERT INTO srp1868_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","А синовима Израиљевим кажи и реци: Ко би год похулио Бога свог, носиће грех свој. ");
INSERT INTO srp1868_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ко би ружио име Господње, да се погуби, сав народ да га заспе камењем; и дошљак и домородац који би ружио име Господње, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","И ко убије човека, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","А ко убије живинче, нека врати друго, живинче за живинче. ");
INSERT INTO srp1868_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","И ко рани ближњег свог, како учини тако да му буде: ");
INSERT INTO srp1868_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Улом за улом, око за око, зуб за зуб; како оштети тело човеку, онако да му се учини. ");
INSERT INTO srp1868_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ко убије живинче, да врати друго; али ко убије човека, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Закон да вам је један, дошљаку да буде као и рођеном у земљи. Јер сам ја Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","И Мојсије каза синовима Израиљевим, а они изведоше псовача напоље из логора, и засуше га камењем; и учинише синови Израиљеви како Господ заповеди Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Још рече Господ Мојсију на гори синајској говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Кажи синовима Израиљевим, и реци им: Кад дођете у земљу коју вам ја дајем, нека празнује земља суботу Господњу. ");
INSERT INTO srp1868_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Шест година засевај њиву своју, и шест година режи виноград свој и сабирај род. ");
INSERT INTO srp1868_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","А седма година нека буде субота за одмор земљи, субота Господња; немој сејати у пољу свом ни резати виноград свој. ");
INSERT INTO srp1868_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Шта само од себе роди иза жетве твоје немој жети, и грожђа у винограду свом нерезаном немој брати; нека буде година одмора земљи. ");
INSERT INTO srp1868_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Али шта роди земља за почивања свог, оно нека вам буде храна, теби и слузи твом и слушкињи твојој и најамнику твом и укућанину твом који је код тебе. ");
INSERT INTO srp1868_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","И стоци твојој и свим животињама што су у твојој земљи, сав род њен нека буде храна. ");
INSERT INTO srp1868_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","И наброј седам седмина година, седам пута по седам година, тако да ти седам седмина година буде четрдесет и девет година. ");
INSERT INTO srp1868_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Тада заповеди нека затруби труба десети дан седмог месеца, на дан очишћења нека труби труба по свој земљи вашој. ");
INSERT INTO srp1868_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","И посветите годину педесету, и прогласите слободу у земљи свима који живе у њој; то нека вам је опросна година, и тада се вратите сваки на своју баштину, и сваки у род свој вратите се. ");
INSERT INTO srp1868_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Опросна година да вам је та педесета година; немојте сејати, нити жањите шта само роди те године, нити берите грожђа у виноградима нерезаним. ");
INSERT INTO srp1868_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Јер је опросна година; нека вам је света; са сваког поља једите род његов. ");
INSERT INTO srp1868_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Те године опросне вратите се сваки на своју баштину. ");
INSERT INTO srp1868_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","И ако продаш шта ближњему свом или купиш шта од ближњег свог, не варајте један другог. ");
INSERT INTO srp1868_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Према броју година по опросној години купуј од ближњег свог, и према броју година у које ћеш брати род нека ти продаје. ");
INSERT INTO srp1868_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Што више буде година то ће цена бити већа ономе што купујеш, а што мање буде година то ће мања бити цена, јер ти се продаје број летина. ");
INSERT INTO srp1868_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Зато не варајте један другог, него се бојте Бога свог; јер сам ја Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Држите уредбе моје и чувајте законе моје и вршите их, па ћете живети у земљи без страха. ");
INSERT INTO srp1868_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","И земља ће рађати род свој, и јешћете га, и бићете сити, и живећете у њој без страха. ");
INSERT INTO srp1868_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","И ако бисте рекли: Шта ћемо јести седме године, ето нећемо сејати нити ћемо брати летину? ");
INSERT INTO srp1868_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Пустићу благослов свој на вас шесте године, те ће родити за три године. ");
INSERT INTO srp1868_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","И сејаћете осме године, а јешћете летину стару до девете године, докле не приспе род њен, јешћете стари. ");
INSERT INTO srp1868_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Али да се земља не продаје за свагда, јер је моја земља, а ви сте дошљаци и укућани код мене. ");
INSERT INTO srp1868_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Зато по свој земљи државе ваше нека се откупљују земље. ");
INSERT INTO srp1868_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ако осиромаши брат твој и прода нешто од баштине своје, а после дође ко од рода његовог најближи њему да откупи, нека откупи шта брат његов продаде. ");
INSERT INTO srp1868_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ако ли не би имао никога да откупи, него би се помогао и зглавио колико треба за откуп, ");
INSERT INTO srp1868_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","онда нека одбије године откако је продао, па шта остане нека исплати оном коме је продао, и тако нека опет дође до своје баштине. ");
INSERT INTO srp1868_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ако ли нема колико би требало вратити, онда остаје ствар продана у оног који је купио до године опросне, а опросне године оставиће се, и он ће се вратити на своју баштину. ");
INSERT INTO srp1868_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Ко прода кућу у којој се седи у месту ограђеном зидом, властан је откупити је докле се не наврши година дана од како је прода; целу годину дана има власт откупити је. ");
INSERT INTO srp1868_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","А ако не откупи за годину дана, онда остаје кућа у месту ограђеном зидом оном који је купио сасвим од колена на колено, и неће је оставити опросне године. ");
INSERT INTO srp1868_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","А куће по селима, које нису ограђене зидом, нека се узимају као њиве, могу се откупити, и године опросне враћају се. ");
INSERT INTO srp1868_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","А места левитска и куће у местима њиховим, свагда могу откупити Левити. ");
INSERT INTO srp1868_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Али ко купи од Левита, нека опросне године остави купљену кућу и шта је имао у месту; јер куће по местима левитским јесу њихове међу синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Али поље под местима њиховим да се не продаје; јер је њихово достојање довека. ");
INSERT INTO srp1868_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ако осиромаши брат твој и изнемогне рука његова поред тебе, прихвати га, и као странац и дошљак нека поживи уз тебе. ");
INSERT INTO srp1868_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Немој узимати од њега камате ни добити; него се бој Бога, да би поживео брат твој уз тебе. ");
INSERT INTO srp1868_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Новаца немој му давати на камату, нити му хране своје позаимај ради добити. ");
INSERT INTO srp1868_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ја сам Господ Бог ваш, који сам вас извео из земље мисирске да вам дам земљу хананску и да вам будем Бог. ");
INSERT INTO srp1868_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","И ако осиромаши брат твој код тебе тако да ти се прода, немој га држати као роба; ");
INSERT INTO srp1868_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","као најамник и као дошљак нека буде код тебе; до опросне године нека служи код тебе. ");
INSERT INTO srp1868_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","А онда нека иде од тебе са синовима својим, нека се врати у род свој, и на баштину отаца својих нека се врати. ");
INSERT INTO srp1868_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Јер су моје слуге, које сам извео из земље мисирске, нека се не продају као робови. ");
INSERT INTO srp1868_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Немој господарити над њим жестоко, него се бој Бога свог. ");
INSERT INTO srp1868_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","А роб твој и робиња твоја што ћеш имати нека буду од оних народа који ће бити око вас, од њих купујте роба и робињу. ");
INSERT INTO srp1868_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","И између странаца који буду код вас, између њих купујте и из породица оних који буду код вас, који се роде у земљи вашој, и ти нека вам буду имање. ");
INSERT INTO srp1868_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Они ће постати ваши и синова ваших након вас, и биће вам достојање, да вам сваку службу врше до века; али над браћом својом, синовима Израиљевим, нико над братом својим да не господари жестоко. ");
INSERT INTO srp1868_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ако ли се обогати дошљак или гост који живи с тобом, а брат твој осиромаши код њега тако да се прода дошљаку, који живи с тобом, или коме год од туђег рода, ");
INSERT INTO srp1868_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","кад се прода, може се откупити; ко год од браће његове нека га откупи; ");
INSERT INTO srp1868_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","или стриц његов, или син стрица његовог нека га откупи, или ко други од крви његове у роду његовом нека га откупи; или ако се помогне, нека се сам откупи. ");
INSERT INTO srp1868_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Нека се прорачуна с купцем својим од године кад се продао године опросне, да цена за коју се продао дође према броју година; као надничару нека му се рачуна време које је одслужио. ");
INSERT INTO srp1868_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ако остаје још много година, према њима нека плати откуп од цене за коју је купљен. ");
INSERT INTO srp1868_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ако ли остаје мало година до опросне године, нека се прорачуна с њим, и нека плати откуп према тим годинама. ");
INSERT INTO srp1868_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Као најамник годишњи нека буде у њега, и нека не господари над њим жестоко на твоје очи. ");
INSERT INTO srp1868_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ако ли се овако не откупи, нека отиде године опросне и он и синови његови с њим. ");
INSERT INTO srp1868_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Јер су синови Израиљеви моје слуге, моје су слуге, које сам извео из земље мисирске; ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Немојте градити себи идола ни ликова резаних, нити ступова подижите, ни камена са сликама мећите у својој земљи да му се клањате; јер сам ја Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Држите суботе моје, и светињу моју поштујте; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ако узживите по мојим уредбама, и заповести моје уздржите и ушчините, ");
INSERT INTO srp1868_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","даваћу вам дажд на време, и земља ће рађати род свој, и дрвета ће у пољу рађати род свој; ");
INSERT INTO srp1868_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","и вршидба ће вам стизати бербу виноградску, а берба ће виноградска стизати сејање, и јешћете хлеб свој до ситости, и живећете без страха у земљи својој. ");
INSERT INTO srp1868_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Јер ћу дати мир земљи, те ћете спавати а неће бити никога да вас плаши; учинићу, те ће нестати зле звери из земље, и мач неће пролазити преко ваше земље. ");
INSERT INTO srp1868_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Него ћете терати непријатеље своје, и падаће пред вама од мача. ");
INSERT INTO srp1868_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Вас ће петорица терати стотину, а вас стотина тераће десет хиљада, и падаће непријатељи ваши пред вама од мача. ");
INSERT INTO srp1868_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","И обратићу се к вама, и учинићу вам да растете, и умножићу вас, и утврдићу завет свој с вама. ");
INSERT INTO srp1868_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","И јешћете жито старо, од много година, и изасипаћете старо кад дође ново. ");
INSERT INTO srp1868_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","И наместићу стан свој међу вама, и душа моја неће мрзети на вас. ");
INSERT INTO srp1868_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","И ходићу међу вама, и бићу вам Бог, и ви ћете бити мој народ. ");
INSERT INTO srp1868_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ја сам Господ Бог ваш, који вас изведох из земље мисирске да им не робујете, и поломих палице јарма вашег, и исправих вас да ходите право. ");
INSERT INTO srp1868_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ако ли ме не узаслушате, и не учините све ове заповести, ");
INSERT INTO srp1868_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ако повргнете уредбе моје и души вашој омрзну закони моји да не творите све заповести моје, и раскинете завет мој, ");
INSERT INTO srp1868_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","и ја ћу вама учинити ово: Пустићу на вас страх, суву болест и врућицу, које ће вам очи искварити и душу уцвелити; и залуду ћете сејати семе своје, јер ће га јести непријатељи ваши. ");
INSERT INTO srp1868_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","И окренућу лице своје насупрот вама, и сећи ће вас непријатељи ваши, и који мрзе на вас биће вам господари, и бежаћете кад вас нико не тера. ");
INSERT INTO srp1868_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ако ме ни тада не станете слушати, караћу вас још седам пута више за грехе ваше. ");
INSERT INTO srp1868_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Потрћу понос силе ваше, и учинићу да небо над вама буде као гвожђе, а земља ваша као бронза. ");
INSERT INTO srp1868_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Снага ће се ваша трошити узалуд, јер земља ваша неће рађати рода свог, и дрвета по земљи неће рађати рода свог. ");
INSERT INTO srp1868_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ако ми узидете насупрот и не будете хтели слушати ме, додаћу вам седам пута више мука према гресима вашим. ");
INSERT INTO srp1868_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Пустићу на вас звери пољске, које ће вам децу изјести, и стоку потрти и вас умалити, и опустеће путеви ваши. ");
INSERT INTO srp1868_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Ако се ни од тога не поправите, него ми још узидете насупрот, ");
INSERT INTO srp1868_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","и ја ћу вама ићи насупрот, и бићу вас још седам пута више за грехе ваше. ");
INSERT INTO srp1868_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Пустићу на вас мач, који ће осветити мој завет; а кад се слежете у градове своје, тада ћу пустити помор међу вас, и бићете предани у руке непријатељу. ");
INSERT INTO srp1868_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","И кад вам сломим потпору у хлебу, десет ће жена пећи хлеб ваш у једној пећи, и даваће вам хлеб ваш на меру, и јешћете а нећете се наситити. ");
INSERT INTO srp1868_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ако ме ни тако не станете слушати, него ми узидете насупрот, ");
INSERT INTO srp1868_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","и ја ћу вама с гневом ићи насупрот, и седам пута већма караћу вас за грехе ваше. ");
INSERT INTO srp1868_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","И јешћете месо од синова својих, и месо од кћери својих јешћете. ");
INSERT INTO srp1868_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Развалићу висине ваше, и оборићу идоле ваше, и метнућу трупове ваше на трупове гадних богова ваших, и мрзиће душа моја на вас. ");
INSERT INTO srp1868_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","И обратићу градове ваше у пустош, и разорићу светиње ваше, и нећу више мирисати мириса вашег. ");
INSERT INTO srp1868_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","И опустећу земљу да ће јој се чудити непријатељи ваши, који ће живети у њој. ");
INSERT INTO srp1868_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","А вас ћу расејати по народима, и учинићу да вас гоне с голим мачем; и земља ће ваша бити пуста и градови ваши раскопани. ");
INSERT INTO srp1868_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Тада ће земљи бити миле суботе њене за све време докле буде пуста; и кад будете у земљи својих непријатеља, земља ће почивати, и биће јој миле суботе њене. ");
INSERT INTO srp1868_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","За све време докле буде пуста почиваће, јер није почивала у ваше суботе, кад сте у њој живели. ");
INSERT INTO srp1868_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","А који вас остану, метнућу страх у срца њихова у земљама непријатеља њихових, те ће их гонити лист кад шушне заљуљавши се, и они ће бежати као испред мача, и падаће а нико их неће терати. ");
INSERT INTO srp1868_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","И падаће један преко другог као од мача, а нико их неће терати; и нећете се моћи држати пред непријатељима својим. ");
INSERT INTO srp1868_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Него ћете изгинути међу народима, и прождреће вас земља непријатеља ваших. ");
INSERT INTO srp1868_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","А који вас остану, чилеће за безакоње своје у земљи непријатеља својих, и за безакоње отаца својих чилеће. ");
INSERT INTO srp1868_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Али ако признаду безакоње своје и безакоње отаца својих по гресима, којима ми грешише и којима ми идоше насупрот, ");
INSERT INTO srp1868_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","те и ја њима идох насупрот и одведох их у земљу непријатеља њихових; ако се тада понизи срце њихово необрезано, и буде им право што су покарани за безакоње своје, ");
INSERT INTO srp1868_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","тада ћу се опоменути завета свог с Јаковом, и завета свог са Исаком, и завета свог са Аврамом опоменућу се, и земље ћу се опоменути. ");
INSERT INTO srp1868_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Када се земља опрости њих и буду јој миле суботе њене кад опусти с њих, и њима буде право што су покарани за безакоње своје, јер судове моје повргоше и души њиховој омрзоше уредбе моје. ");
INSERT INTO srp1868_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","А зато ни онда кад буду у земљи непријатеља својих нећу их поврћи нити ћу тако омрзнути на њих да их потрем и раскинем завет свој са њима; јер сам ја Господ Бог њихов. ");
INSERT INTO srp1868_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Него ћу се њих ради опоменути завета са старима њиховим, које изведох из земље мисирске народима на видику да им будем Бог, ја Господ. ");
INSERT INTO srp1868_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ово су уредбе и судови и закони, које постави Господ између себе и синова Израиљевих на гори синајској преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Кажи синовима Израиљевим, и реци им: Кад ко заветује душу своју Господу, ти га уцени: ");
INSERT INTO srp1868_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","А овако ћеш ценити: мушко од двадесет година до шездесет ценићеш педесет сикала сребра, по сиклу светом. ");
INSERT INTO srp1868_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ако буде женско, ценићеш тридесет сикала. ");
INSERT INTO srp1868_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ако је од пет до двадесет година, ценићеш мушко двадесет сикала а женско десет сикала. ");
INSERT INTO srp1868_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ако је од једног месеца до пет година, ценићеш мушко пет сикала сребра, а женско ћеш ценити три сикла сребра. ");
INSERT INTO srp1868_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ако ли буде од шездесет година и више, ако је мушко, ценићеш петнаест сикала, а женско десет сикала. ");
INSERT INTO srp1868_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ако је сиромах да не може платити цену, онда нека дође к свештенику да га уцени свештеник, и према ономе што може дати који се заветовао, нека га свештеник уцени. ");
INSERT INTO srp1868_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Ако би заветовао живинче од оних што се приносе Господу, шта год да Господу, свето је. ");
INSERT INTO srp1868_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Да га не промени ни даде друго за оно, ни добро за рђаво, ни рђаво за добро; ако ли би како променио живинче, онда ће бити свето и оно и друго које је дао за оно. ");
INSERT INTO srp1868_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ако ли би заветовао живинче нечисто од оних што се не приносе Господу, нека се доведе живинче пред свештеника; ");
INSERT INTO srp1868_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","и нека га процени свештеник, било добро или рђаво; и како га процени свештеник, тако да буде. ");
INSERT INTO srp1868_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ако би га хтео откупити, нека на цену твоју дометне још пети део. ");
INSERT INTO srp1868_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Кад би ко заветовао кућу своју, да је света Господу, нека је процени свештеник, била добра или рђава; како је процени свештеник, тако да буде. ");
INSERT INTO srp1868_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ако би онај који заветује хтео откупити кућу своју, нека на цену твоју дометне још пети део, па нека је његова. ");
INSERT INTO srp1868_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Ако би ко заветовао Господу део њиве своје, ценићеш је према усеву: гомер јечма где се посеје, ценићеш педесет сикала сребра. ");
INSERT INTO srp1868_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ако би од опросне године заветовао њиву своју, нека остане по твојој цени. ");
INSERT INTO srp1868_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ако ли после опросне године заветује њиву своју, тада нека му свештеник прорачуна новце према броју година које остају до опросне године, и нека се одбије до твоје цене. ");
INSERT INTO srp1868_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","И ако би хтео откупити њиву своју онај који је заветује, нека дометне на цену твоју још пети део, и нека буде његова. ");
INSERT INTO srp1868_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Али ако не откупи њиве, и њива се прода другом, не може се више откупити; ");
INSERT INTO srp1868_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","него ће она њива, кад се опрости опросне године, бити света Господу, као њива заветована, свештеникова нека буде. ");
INSERT INTO srp1868_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Ако ли би ко заветовао Господу њиву купљену, која није достојање његово, ");
INSERT INTO srp1868_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","свештеник нека му прорачуна цену до године опросне, и нека у онај дан да ту цену да буде ствар света Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","А године опросне да се врати њива ономе од кога је купљена, чије је достојање она њива. ");
INSERT INTO srp1868_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","А свака цена твоја нека буде на сикле свете, а у сиклу има двадесет новаца. ");
INSERT INTO srp1868_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Али првина од стоке, које су Господње, нико да не заветује, било говече или ситна стока, јер је Господње. ");
INSERT INTO srp1868_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ако ли би било од животиња нечистих, онда нека откупи по твојој цени дометнув пети део одозго; ако ли се не откупи, нека се прода по твојој цени. ");
INSERT INTO srp1868_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Али ни једна ствар заветована, шта ко заветује Господу од чега му драго што има, од људи или од стоке или од њиве своје, да се не продаје ни откупљује; свака ствар заветована светиња је над светињама Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Живинче заветовано, које човек заветује, да се не откупљује, него да се убије. ");
INSERT INTO srp1868_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","И сваки десетак земаљски од усева земаљског и од воћа, Господњи је, светиња је Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Али, ко би хтео откупити шта десетка свог, нека на цену дометне још пети део. ");
INSERT INTO srp1868_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","И десетак од говеда и од ситне стоке, које дође под штап пастирски десето, да је свето Господу. ");
INSERT INTO srp1868_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Да се не бира добро ни рђаво, да се не мења; ако ли би се како год променило, онда нека буде и оно и друго промењено света ствар, и да се не откупи. ");
INSERT INTO srp1868_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ово су заповести које заповеди Господ Мојсију за синове Израиљеве на гори синајској. ");
INSERT INTO srp1868_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Још рече Господ Мојсију у пустињи синајској у шатору од састанка први дан другог месеца друге године по изласку њиховом из земље мисирске, говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Избројте сав збор синова Израиљевих по породицама њиховим и по домовима отаца њихових и по именима њиховим, све мушкиње, главу по главу, ");
INSERT INTO srp1868_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","од двадесет година и више, све који могу ићи на војску у Израиљу, избројте их по четама њиховим ти и Арон; ");
INSERT INTO srp1868_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","а с вама нека буде по један човек од сваког племена, који је поглавар у дому отаца својих. ");
INSERT INTO srp1868_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","А ово су имена људи који ће бити с вама: од племена Рувимовог Елисур син Седијуров; ");
INSERT INTO srp1868_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","од Симеуновог Саламило син Сурисадајев; ");
INSERT INTO srp1868_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","од Јудиног Насон син Аминадавов; ");
INSERT INTO srp1868_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","од Исахаровог Натанаило син Согаров; ");
INSERT INTO srp1868_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","од Завулоновог Елијав Син Хелонов; ");
INSERT INTO srp1868_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","од синова Јосифових: од племена Јефремовог Елисама син Емијудов; од Манасијиног Гамалило син Фадасуров; ");
INSERT INTO srp1868_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","од Венијаминовог Авидан син Гадеонијев; ");
INSERT INTO srp1868_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","од Дановог Ахијезер син Амисадајев; ");
INSERT INTO srp1868_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","од Асировог Фагаило син Ехранов; ");
INSERT INTO srp1868_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","од Гадовог Елисаф син Рагуилов; ");
INSERT INTO srp1868_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","од Нефталимовог Ахиреј син Енанов. ");
INSERT INTO srp1868_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","То су који се сазиваху на збор, кнезови у племенима отаца својих, хиљадници Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","И узе Мојсије и Арон те људе, који бише именовани. ");
INSERT INTO srp1868_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","И сабраше сав збор први дан другог месеца, и преписаше их по породицама њиховим и по домовима отаца њихових и по именима њиховим од двадесет година и више, главу по главу. ");
INSERT INTO srp1868_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Како беше Господ заповедио Мојсију, тако их изброја у пустињи синајској. ");
INSERT INTO srp1868_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","И беше синова првенца Израиљевог Рувима, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се изброја по именима с главе на главу све мушкиње од двадесет година и више, што могаше ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","беше их избројаних од племена Рувимовог четрдесет и шест хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Синова Симеунових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се изброја по именима с главе на главу све мушкиње од двадесет година и више, што могаше ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","беше их избројаних од племена Симеуновог педесет и девет хиљада и три стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Синова Гадових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","беше их избројаних од племена Гадовог четрдесет и пет хиљада, шест стотина и педесет. ");
INSERT INTO srp1868_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Синова Јудиних, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","беше их избројаних од племена Јудиног седамдесет и четири хиљаде и шест стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Синова Исахарових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","беше их избројаних од племена Исахаровог педесет и четири хиљаде и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Синова Завулонових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","беше их избројаних од племена Завулоновог педесет и седам хиљада и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Од синова Јосифових: синова Јефремових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","беше их избројаних од племена Јефремовог четрдесет хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Синова Манасијиних, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","беше их избројаних од племена Манасијиног тридесет и две хиљаде и двеста. ");
INSERT INTO srp1868_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Синова Венијаминових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","беше их избројаних од племена Венијаминовог тридесет и пет хиљада и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Синова Данових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","беше их избројаних од племена Дановог шездесет две хиљаде и седам стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Синова Асирових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","беше их избројаних од племена Асировог четрдесет и једна хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Синова Нефталимових, рода њиховог по породицама њиховим и по домовима отаца њихових, кад се избројаше по именима од двадесет година и више сви што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","беше их избројаних од племена Нефталимовог педесет и три хиљаде и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ово су они које Мојсије и Арон избројаше с кнезовима израиљским, с дванаест људи, који беху по један за сваки дом отаца својих. ");
INSERT INTO srp1868_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","И свега беше синова Израиљевих избројаних по домовима отаца својих од двадесет година и више, свих што могаху ићи на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","беше их избројаних шест стотина и три хиљаде и пет стотина и педесет. ");
INSERT INTO srp1868_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Али Левити по племену отаца својих не бише бројани међу њих. ");
INSERT INTO srp1868_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Јер Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Племена Левијевог немој бројати, нити број њихов саставити са синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Него постави Левите над шатором од сведочанства и над свим посуђем у њему и над свим што припада њему; они нека носе шатор и све посуђе његово, нека служе у њему, и стају око шатора. ");
INSERT INTO srp1868_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","И кад се шатор крене, нека га сложе Левити; и кад шатор стане, онда нека га разапну Левити. А ко би други приступио да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","И синови Израиљеви нека стају сваки у свом логору и сваки код своје заставе по четама својим. ");
INSERT INTO srp1868_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","А Левити нека стају око шатора од сведочанства, да не дође гнев на збор синова Израиљевих; и нека Левити раде шта треба око шатора од сведочанства. ");
INSERT INTO srp1868_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","И учинише синови Израиљеви како Господ заповеди, све тако учинише. ");
INSERT INTO srp1868_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Потом рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Синови Израиљеви нека стају у око сваки код своје заставе са знаком дома отаца својих, према шатору од састанка унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","С истока нека стаје у око застава војске Јудине по четама својим с војводом синова Јудиних Насоном сином Аминадавовим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","а у војсци његовој седамдесет и четири хиљаде и шест стотина избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","А до њега нека стаје у логор племе Исахарово с војводом синова Исахарових Натанаилом, сином Согаровим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","а у војсци његовој педесет и четири хиљаде и четири стотине избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Па онда племе Завулоново с војводом синова Завулонових Елијавом, сином Хелоновим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","а у војсци његовој педесет и седам хиљада и четири стотине избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Свега избројаних у војсци Јудиној сто и осамдесет и шест хиљада и четири стотине по четама њиховим. Они нека иду напред. ");
INSERT INTO srp1868_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","А застава војске Рувимове по четама својим нека буде с југа, с војводом синова Рувимових Елисуром сином Седијуровим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","а у војсци његовој четрдесет и шест хиљада и пет стотина избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","А до њега нека стаје у логор племе Симеуново с војводом синова Симеунових Саламилом сином Сурисадајевим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","а у војсци његовој педесет и девет хиљада и три стотине избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Па онда племе Гадово с војводом синова Гадових Елисафом, сином Рагуиловим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","а у војсци његовој четрдесет и пет хиљада и шест стотина и педесет избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","А свега избројаних у војсци Рувимовој сто и педесет и једна хиљада и четири стотине и педесет по четама њиховим. И они нека иду други. ");
INSERT INTO srp1868_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Потом нека иде шатор од састанка с војском синова Левијевих усред остале војске; како у логор стају тако нека и иду, сваки својим редом под својом заставом. ");
INSERT INTO srp1868_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Застава војске Јефремове по четама својим нека буде са запада, с војводом синова Јефремових Елисамом сином Емијудовим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","а у војсци његовој четрдесет хиљада и пет стотина избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","А до њега племе Манасијино с војводом синова Манасијиних, Гамалилом, сином Фадасуровим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","а у његовој војсци тридесет и две хиљаде и двеста избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Па онда племе Венијаминово с војводом синова Венијаминових, Авиданом сином Гадеонијевим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","а у војсци његовој тридесет и пет хиљада и четири стотине избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","А свега избројаних у војсци Јефремовој сто и осам хиљада и сто по четама њиховим. И они нека иду трећи. ");
INSERT INTO srp1868_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Застава војске Данове по четама својим нека буде са севера с војводом синова Данових Ахијезером, сином Амисадајевим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","а у војсци његовој шездесет и две хиљаде и седам стотина избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","А до њега нека стаје у логор племе Асирово с војводом синова Асирових Фагаилом, сином Ехрановим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","а у војсци његовој четрдесет и једна хиљада и пет стотина избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","За њима племе Нефталимово с војводом синова Нефталимових Ахирејем, сином Енановим; ");
INSERT INTO srp1868_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","а у његовој војсци педесет и три хиљаде и четири стотине избројаних. ");
INSERT INTO srp1868_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","А свега избројаних у војсци Дановој сто и педесет и седам хиљада и шест стотина. И они нека иду најпосле уза заставе своје. ");
INSERT INTO srp1868_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","То су синови Израиљеви који бише избројани по домовима отаца својих. Свега избројаних у целој војсци по четама њиховим шест стотина и три хиљаде и пет стотина и педесет. ");
INSERT INTO srp1868_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Али Левити не бише бројани међу синове Израиљеве, као што Господ беше заповедио Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","И учинише синови Израиљеви све; како заповеди Господ Мојсију, тако стајаху у логор, и тако иђаху сваки по породици својој и по дому отаца својих. ");
INSERT INTO srp1868_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","А ово је племе Ароново и Мојсијево, кад Господ говори с Мојсијем на гори синајској. ");
INSERT INTO srp1868_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","И ово су имена синова Аронових: првенац Надав, па Авијуд и Елеазар и Итамар. ");
INSERT INTO srp1868_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","То су имена синова Аронових, свештеника, који бише помазани и посвећени да врше службу свештеничку. ");
INSERT INTO srp1868_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Али погибе Надав и Авијуд пред Господом, кад принесоше огањ туђ пред Господом у пустињи синајској; и не имаше деце; зато Елеазар и Итамар отправљаху службу свештеничку за живота Арона, оца свог. ");
INSERT INTO srp1868_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","А Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Кажи нека приступи племе Левијево, и постави га пред Ароном свештеником да му служе, ");
INSERT INTO srp1868_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","и да раде за њ и за сав збор пред шатором од састанка служећи шатору, ");
INSERT INTO srp1868_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","и да чувају све посуђе у шатору од састанка, и да страже за синове Израиљеве служећи шатору. ");
INSERT INTO srp1868_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Па ћеш дати Левите Арону и синовима његовим; они су даровани њему између синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","А Арона и синове његове постави да врше свештеничку службу своју; ако ли би ко други приступио, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Ево узех Левите између синова Израиљевих за све првенце што отварају материцу међу синовима Израиљевим; зато ће моји бити Левити. ");
INSERT INTO srp1868_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Јер је мој сваки првенац; од оног дана када побих све првенце у земљи мисирској, посветих себи сваког првенца у Израиљу од човека до живинчета; моји ће бити; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Још рече Господ Мојсију у пустињи синајској говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Изброј синове Левијеве по домовима отаца њихових, по породицама њиховим, све мушкиње од месеца дана и више изброј. ");
INSERT INTO srp1868_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","И Мојсије их изброја по заповести Господњој, како му би заповеђено. ");
INSERT INTO srp1868_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","И беху синови Левијеви по имену ови: Гирсон и Кат и Мерарије. ");
INSERT INTO srp1868_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","А ово су имена синова Гирсонових по породицама њиховим: Ловеније и Семеј. ");
INSERT INTO srp1868_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","А синови Катови по породицама својим: Амрам и Исар, Хеврон и Озило. ");
INSERT INTO srp1868_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","А синови Мераријеви по породицама својим: Малије и Мусије. То су породице левитске по домовима отаца својих. ");
INSERT INTO srp1868_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Од Гирсона породица Ловенијева и породица Семејева. То су породице Гирсонове. ");
INSERT INTO srp1868_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","А избројаних међу њима, кад се изброја све мушкиње од месеца дана и више, беше их избројаних свега седам хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Породице Гирсонове стајаху у логор иза шатора са запада. ");
INSERT INTO srp1868_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","А старешина од дома отачког у породицама Гирсоновим беше Елисаф, син Даилов. ");
INSERT INTO srp1868_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","А синови Гирсонови чуваху у шатору од састанка шатор и наслон, покривач његов и завес на вратима шатора од састанка, ");
INSERT INTO srp1868_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","и завесе од трема и завес на вратима од трема што је око шатора и око олтара, и ужа његова за сваку потребу његову. ");
INSERT INTO srp1868_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","А од Ката беше породица Амрамова и породица Исарова и породица Хевронова и породица Озилова. То су породице Катове. ");
INSERT INTO srp1868_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Свега мушкиња од месеца дана и више беше на број осам хиљада и шест стотина, који служаху око светиње. ");
INSERT INTO srp1868_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Породице синова Катових стајаху у логор поред шатора с југа. ");
INSERT INTO srp1868_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","А старешина од дома отачког у породицама Катовим беше Елисафан, син Озилов. ");
INSERT INTO srp1868_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","А они чуваху ковчег и сто и свећњак и олтар и посуђе у светињи којим служе, и завес, и све што припада к њему. ");
INSERT INTO srp1868_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","А старешина над старешинама левитским беше Елеазар, син Арона свештеника, постављен над онима који чувају светињу. ");
INSERT INTO srp1868_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","А од Мерарија беше породица Малијева и породица Мусијева. То су породице Мераријеве. ");
INSERT INTO srp1868_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","И беше их избројаних, кад се изброја све мушкиње од месеца дана и више, шест хиљада и двеста. ");
INSERT INTO srp1868_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","А старешина од дома отачког у породицама Мераријевим беше Сурило син Авихејев; они стајаху у логор поред шатора са севера. ");
INSERT INTO srp1868_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","И синови Мераријеви чуваху даске од шатора и преворнице његове и ступце његове и стопице његове и све справе његове и све што к њему припада, ");
INSERT INTO srp1868_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","и ступце од трема унаоколо и стопице њихове и коље и ужа њихова. ");
INSERT INTO srp1868_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","А пред шатором од састанка с истока стајаху у логор Мојсије и Арон и синови његови чувајући светињу за синове Израиљеве; а да ко други приступи, погинуо би. ");
INSERT INTO srp1868_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","А свега Левита кад их изброја Мојсије и Арон по заповести Господњој по породицама њиховим, свега мушкиња од месец дана и више, беше двадесет и две хиљаде. ");
INSERT INTO srp1868_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","И Господ рече Мојсију: Изброј све првенце мушке међу синовима Израиљевим од месеца дана и више, и сабери број имена њихових. ");
INSERT INTO srp1868_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","И узми Левите за мене (ја сам Господ) место свих првенаца међу синовима Израиљевим, и стоку левитску место свих првенаца од стоке синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","И изброја Мојсије како му заповеди Господ, све првенце међу синовима Израиљевим; ");
INSERT INTO srp1868_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","и свега првенаца мушких, кад се избројаше по именима од једног месеца и више, беше избројаних двадесет и две хиљаде и двеста и седамдесет и три. ");
INSERT INTO srp1868_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","И Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Узми Левите место свих првенаца међу синовима Израиљевим и стоку левитску место стоке њихове, да буду моји Левити; ја сам Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","А да се откупе они двеста и седамдесет и три, што има првенаца међу синовима Израиљевим више него Левита, ");
INSERT INTO srp1868_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","узми по пет сикала од главе; узми по светом сиклу (а у тај сикал иде двадесет гера). ");
INSERT INTO srp1868_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","И подај те новце Арону и синовима његовим, откуп за оне који прелазе број њихов. ");
INSERT INTO srp1868_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","И узе Мојсије откуп од оних који осташе преко оних који бише промењени за Левите. ");
INSERT INTO srp1868_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","И узе новце од првенаца синова Израиљевих, хиљаду и триста и шездесет и пет сикала, по светом сиклу. ");
INSERT INTO srp1868_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","И даде Мојсије тај откуп Арону и синовима његовим по заповести Господњој, као што заповеди Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Још рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Изброј синове Катове између синова Левијевих по породицама њиховим и по домовима отаца њихових. ");
INSERT INTO srp1868_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Од тридесет година и више до педесете све који су за посао да могу радити послове у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","А ово ће бити посао синовима Катовим у шатору од састанка у светињи над светињама: ");
INSERT INTO srp1868_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Кад полази војска, доћи ће Арон са синовима својим, и скинуће завес с врата, и покриће њим ковчег од сведочанства. ");
INSERT INTO srp1868_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Па ће по њему прострети покривач од кожа јазавичијих, и одозго ће прострети простирач од саме порфире, и провући ће му полуге. ");
INSERT INTO srp1868_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","И по столу за хлебове постављене нека простру простирач од порфире, и нека метну на њ зделе и чаше и ведра и котлиће, и хлеб свагда нека је на њему. ");
INSERT INTO srp1868_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Па врх тога нека простру простирач од црвца, и нека покрију покривачем од кожа јазавичијих, и нека му провуку полуге. ");
INSERT INTO srp1868_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","И нека узму простирач од порфире и покрију свећњак и жишке његове и усекаче његове лопатице његове и све судове за уље, којима служе око њега. ");
INSERT INTO srp1868_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","И нека га са свим справама његовим завију у покривач од кожа јазавичијих, и метну га на полуге. ");
INSERT INTO srp1868_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","И по златном олтару нека простру простирач од порфире и покрију га покривачем од кожа јазавичијих, и провуку му полуге. ");
INSERT INTO srp1868_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","И нек узму све справе за службу, којима служе у светињи, и нека их метну у простирач од порфире и завију у покривач од кожа јазавичијих, и метну на полуге. ");
INSERT INTO srp1868_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","И нека омету пепео с олтара и по олтару простру простирач од скерлета, ");
INSERT INTO srp1868_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","и нека метну на њ све справе његове, којима служе на њему, машице, виљушке, лопатице и котлиће и све справе за олтар, и нека га покрију покривачем од кожа јазавичијих, па му провуку полуге. ");
INSERT INTO srp1868_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","И кад то сврши Арон и синови његови и завију светињу и све справе за светињу, да пође војска, онда нека дођу синови Катови да носе, али нека се не дотакну ниједне ствари свете, да не погину. То је посао синова Катових у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","А Елеазар, син Арона свештеника, нека се стара за уље за видело, и за кад мирисни, и за жртву свагдашњу, и за уље помазања, нека пази на сав шатор и на све што је у њему, на светињу и на посуђе њено. ");
INSERT INTO srp1868_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","И рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Немојте да се истреби колено породица Катових између Левита; ");
INSERT INTO srp1868_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","него им учините ово да би остали живи и не би помрли кад приступају к светињи над светињама: Арон и синови његови нека дођу и одреде свакоме шта ће који радити и шта ће носити. ");
INSERT INTO srp1868_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","А они нека не долазе да гледају кад се завијају свете ствари, да не помру. ");
INSERT INTO srp1868_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Изброј и синове Гирсонове по домовима отаца њихових и по породицама њиховим. ");
INSERT INTO srp1868_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Од тридесет година и више до педесет година изброј их све који су за службу да могу служити у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ово је посао породицама Гирсоновим шта ће радити и носити: ");
INSERT INTO srp1868_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Нека носе завесе од наслона и шатор од састанка, покривач његов и покривач од кожа јазавичијих што је одозго на њему, и завес на уласку у шатор од састанка, ");
INSERT INTO srp1868_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","и завесе од трема и завес на вратима од трема што је око шатора и око олтара, и ужа њихова и све посуђе за службу њихову и шта год треба око тога радити нека раде. ");
INSERT INTO srp1868_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","По наредби Ароновој и синова његових нека бива сва служба синова Гирсонових за све што ће носити и што ће радити, и оставите им нека чувају све што су дужни носити. ");
INSERT INTO srp1868_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","То је служба породица синова Гирсонових у шатору од састанка; а Итамар син Арона свештеника нека управља њима. ");
INSERT INTO srp1868_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Изброј и синове Мераријеве по породицама њиховим и по домовима отаца њихових, ");
INSERT INTO srp1868_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","од тридесет година и више до педесет година изброј их све који су за службу да могу служити у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","А ово им је дужност носити осим све службе њихове у шатору од састанка: даске од шатора и преворнице његове и ступце његове и стопице његове, ");
INSERT INTO srp1868_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","и ступце од трема унаоколо, и стопице њихове и коље њихово, и ужа њихова, и све справе њихове, и шта год треба за те ствари; а поименце избројте све справе што ће они носити. ");
INSERT INTO srp1868_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","То је служба породица синова Мераријевих што су дужни радити у шатору од састанка под руком Итамара, сина Арона свештеника. ");
INSERT INTO srp1868_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","И изброја Мојсије и Арон с кнезовима народним синове Катове по породицама њиховим и по домовима отаца њихових, ");
INSERT INTO srp1868_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","од тридесет година и више до педесет година све који су за службу да могу служити у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","И беше их избројаних по породицама њиховим две хиљаде и седам стотина и педесет. ");
INSERT INTO srp1868_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","То су избројани из породица Катових што беху за службу у шатору од састанка, које изброја Мојсије и Арон, као што заповеди Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","А синова Гирсонових по породицама њиховим и по домовима отаца њиховим и по домовима отаца њихових беше избројаних, ");
INSERT INTO srp1868_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","од тридесет година и више до педесет година, свих што беху за службу да служе у шатору од састанка, ");
INSERT INTO srp1868_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","беше их избројаних по породицама њиховим и по домовима отаца њихових две хиљаде и шест стотина и тридесет. ");
INSERT INTO srp1868_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","То су избројани из породица синова Гирсонових, што беху за службу у шатору од састанка, које изброја Мојсије и Арон по заповести Господњој. ");
INSERT INTO srp1868_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","А из породица синова Мераријевих по породицама њиховим и по домовима отаца њихових беше избројаних, ");
INSERT INTO srp1868_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","од тридесет година и више до педесет година, свих што беху за службу да служе у шатору од састанка, ");
INSERT INTO srp1868_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","беше их избројаних по породицама њиховим три хиљаде и двеста. ");
INSERT INTO srp1868_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","То су избројани из породица синова Мераријевих, које изброја Мојсије и Арон као што заповеди Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","А свега беше избројаних Левита, које изброја Мојсије и Арон с кнезовима Израиљевим по породицама њиховим и по домовима отаца њихових, ");
INSERT INTO srp1868_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","од тридесет година и више до педесет година, што беху за службу да служе и да носе у шатору од састанка, ");
INSERT INTO srp1868_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","свега их беше избројаних осам хиљада и пет стотина и осамдесет. ");
INSERT INTO srp1868_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Како Господ заповеди преко Мојсија, бише избројани, сваки за оно што треба да ради и да носи; и избројани бише они које је Господ заповедио Мојсију да се изброје. ");
INSERT INTO srp1868_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Заповеди синовима Израиљевим нека истерају из логора све губаве и све којима тече семе и све који су се оскврнили о мртваца, ");
INSERT INTO srp1868_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","био човек или жена, истерајте, иза логора истерајте их, да не скврне логора онима међу којима наставам. ");
INSERT INTO srp1868_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","И учинише тако синови Израиљеви, и истераше их из логора, како Господ каза Мојсију, тако учинише синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Реци синовима Израиљевим: Човек или жена кад учини какав грех људски, те згреши Господу, и буде она душа крива, ");
INSERT INTO srp1868_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","тада нека признаду грех који су учинили, и ко је крив нека врати цело чим је крив и нек дометне одозго пети део и да ономе коме је скривио. ");
INSERT INTO srp1868_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","И ако онај нема никога коме би припала накнада за штету, нека се да Господу и нека буде свештенику осим овна за очишћење којим ће га очистити. ");
INSERT INTO srp1868_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Тако и сваки принос између свих ствари које посвећују синови Израиљеви и доносе свештенику, његов нека буде; ");
INSERT INTO srp1868_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","и шта год ко посвети, нека је његово, и шта год ко да свештенику, нека је његово. ");
INSERT INTO srp1868_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Кажи синовима Израиљевим и реци им: Чија би жена застранила те би му згрешила, ");
INSERT INTO srp1868_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","и други би је облежао, а муж њен не би знао, него би она затајила да се оскврнила, и не би било сведока на њу, нити би се затекла, ");
INSERT INTO srp1868_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","а њему би дошла сумња љубавна, те би из љубави сумњао на своју жену, а она би била оскврњена; или би му дошла сумња љубавна те би из љубави сумњао на своју жену, а она не би била оскврњена, ");
INSERT INTO srp1868_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","онда нека муж доведе жену своју к свештенику, и нека донесе за њу принос њен, десети део ефе брашна јечменог, али нека га не полије уљем и нека не метне на њ када, јер је принос за сумњу љубавну, дар за спомен да се спомене грех. ");
INSERT INTO srp1868_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","И нека је свештеник приведе и постави пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","И нека узме свештеник свете воде у суд земљани; и праха с пода у шатору нека узме и успе у воду. ");
INSERT INTO srp1868_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","И поставивши свештеник жену пред Господом нека јој открије главу и метне јој на руке дар за спомен који је дар за сумњу љубавну; а свештеник нека држи у руци својој горку воду, која носи проклетство. ");
INSERT INTO srp1868_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","И нека свештеник закуне жену, и рече јој: Ако није нико спавао с тобом, и ако ниси застранила од мужа свог на нечистоту, нека ти не буде ништа од ове воде горке, која носи проклетство. ");
INSERT INTO srp1868_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ако ли си застранила од мужа свог и оскврнила се, и когод други осим мужа твог спавао с тобом, ");
INSERT INTO srp1868_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","тада свештеник заклињући жену нека је прокуне и рече жени: Да те Господ постави за уклин и за клетву у народу твом учинивши да ти бедро спадне а трбух отече. ");
INSERT INTO srp1868_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","И нека ти ова вода проклета уђе у црева да ти отече трбух и да ти бедро спадне. А жена нека рече: Амин, амин. ");
INSERT INTO srp1868_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Тада нека напише свештеник те клетве у књигу, и нека их спере водом горком. ");
INSERT INTO srp1868_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","И нека да жени да се напије горке воде проклете да уђе у њу вода проклета и буде горка. ");
INSERT INTO srp1868_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","И нека узме свештеник из руку жени дар за сумњу љубавну, и обрне дар пред Господом и принесе га на олтару. ");
INSERT INTO srp1868_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","И нека узме свештеник у шаку од дара њеног спомен, и запали на олтару, па онда нека да жени воду да попије. ");
INSERT INTO srp1868_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","А кад јој да воду да пије, ако се буде оскврнила и учинила неверу мужу свом, онда ће ући вода проклета у њу и постаће горка, и трбух ће јој отећи и спасти бедро, и она ће жена постати уклин у народу свом. ");
INSERT INTO srp1868_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ако ли се не буде оскврнила жена, него буде чиста, неће јој бити ништа и имаће деце. ");
INSERT INTO srp1868_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ово је закон за сумњу љубавну, кад жена застрани од мужа свог и оскврни се; ");
INSERT INTO srp1868_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","или кад коме дође сумња љубавна те посумња из љубави на жену своју и постави је пред Господом и сврши јој свештеник све по овом закону. ");
INSERT INTO srp1868_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","И муж да је прост од греха, али жена да носи своје безакоње. ");
INSERT INTO srp1868_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Реци синовима Израиљевим, и кажи им: Кад човек или жена учини завет назирејски, да буде назиреј Господу, ");
INSERT INTO srp1868_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","нека се уздржава од вина и силовитог пића, и нека не пије оцта винског ни оцта од силовитог пића нити каквог пића од грожђа и нека не једе грожђа ни новог ни сувог. ");
INSERT INTO srp1868_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Докле год траје његово назирејство нека не једе ништа од винове лозе, ни зрна ни љуске. ");
INSERT INTO srp1868_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Докле траје његово назирејство, нека му бритва не пређе преко главе; докле се не наврше дани за које се учинио назиреј Господу, нека буде свет и нека оставља косу на глави својој. ");
INSERT INTO srp1868_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Докле трају дани за које се учинио назиреј Господу, нека не приступа к мртвацу. ");
INSERT INTO srp1868_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ни за оцем својим ни за матером својом ни за братом својим ни за сестром својом, нека се за њима не скврни кад умру; јер је назирејство Бога његовог на глави његовој. ");
INSERT INTO srp1868_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Докле год траје назирејство његово, свет је Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ако ли би ко умро до њега на пречац, те би оскврнио назирејство главе његове, нека обрије главу своју у дан чишћења свог, седми дан нека је обрије. ");
INSERT INTO srp1868_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","А осми дан нека донесе две грлице или два голубића свештенику на врата шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","И свештеник нека зготови од једног жртву за грех а од другог жртву паљеницу, и нека га очисти од оног што је згрешио код мртваца; тако ће посветити главу његову у тај дан. ");
INSERT INTO srp1868_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","И нека одели Господу дане назирејства свог, и донесе јагње од године за кривицу; а пређашњи дани пропадају, јер му се оскврнило назирејство. ");
INSERT INTO srp1868_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","А ово је закон за назиреје: кад се наврше дани назирејства његовог, нека дође на врата шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","И нека донесе за жртву Господу јагње мушко од године здраво за жртву паљеницу, и јагње женско од године здраво за грех, и овна здравог за жртву захвалну. ");
INSERT INTO srp1868_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","И котарицу хлебова пресних, колача од белог брашна замешаних с уљем, и погача пресних намазаних уљем, с даром њиховим и с наливом њиховим. ");
INSERT INTO srp1868_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","А то ће свештеник принети пред Господом и учинити жртву за грех његов и жртву његову паљеницу. ");
INSERT INTO srp1868_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","А овна ће принети на жртву захвалну Господу с котарицом пресних хлебова; принеће свештеник и дар његов и налив његов. ");
INSERT INTO srp1868_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Тада назиреј нека обрије главу свог назирејства на вратима шатора од састанка; и узевши косу назирејства свог нека је метне у огањ који је под жртвом захвалном. ");
INSERT INTO srp1868_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","И свештеник нека узме плеће кувано од овна и један колач пресан из котарице и једну погачу пресну, и нека метне на руке назиреју, пошто обрије назирејство своје. ");
INSERT INTO srp1868_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","И свештеник нека обрће те ствари на жртву обртану пред Господом; то је светиња, која припада свештенику осим груди обртаних и плећа подигнутог; а после тога назиреј може пити вино. ");
INSERT INTO srp1868_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","То је закон за назиреја који се заветује, и то је принос његов Господу за назирејство његово, осим оног што би више могао учинити; какав му буде завет којим се заветује, тако нека учини осим закона свог назирејства. ");
INSERT INTO srp1868_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Реци Арону и синовима његовим и кажи: Овако благосиљајте синове Израиљеве говорећи им: ");
INSERT INTO srp1868_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Да те благослови Господ и да те чува! ");
INSERT INTO srp1868_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Да те обасја Господ лицем својим и буде ти милостив! ");
INSERT INTO srp1868_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Да Господ обрати лице своје к теби и даде ти мир! ");
INSERT INTO srp1868_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","И нека призивају име моје на синове Израиљеве, и ја ћу их благословити. ");
INSERT INTO srp1868_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","И онај дан кад Мојсије сврши и подиже шатор, и кад га помаза и освети са свим посуђем његовим и олтар са свим посуђем његовим, кад помаза и освети, ");
INSERT INTO srp1868_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","донесоше кнезови Израиљеви, старешине у домовима отаца својих, кнезови над племенима и поглавари од оних који бише избројани, ");
INSERT INTO srp1868_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","донесоше прилог свој пред Господа, шест кола покривених и дванаест волова, једна кола два кнеза и по једног вола сваки, и донесоше пред шатор. ");
INSERT INTO srp1868_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","А Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Узми то од њих да буде за службу у шатору од састанка, и подај Левитима, свакоме према служби његовој. ");
INSERT INTO srp1868_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","И узе Мојсије кола и волове, и даде их Левитима. ");
INSERT INTO srp1868_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Двоја кола и четири вола даде синовима Гирсоновим према служби њиховој. ");
INSERT INTO srp1868_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","А остала четири кола и осам волова даде синовима Мераријевим према служби њиховој под управом Итамара, сина Арона свештеника. ");
INSERT INTO srp1868_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","А синовима Катовим не даде ништа јер им посао беше служити светињи, и ношаху на раменима. ");
INSERT INTO srp1868_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","И донесоше кнезови да се посвети олтар кад би помазан, донесоше кнезови прилоге своје пред олтар. ");
INSERT INTO srp1868_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","А Господ рече Мојсију: Један кнез у један дан а други кнез у други дан нека доносе своје прилоге да се посвети олтар. ");
INSERT INTO srp1868_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","И први дан донесе прилог свој Насон, син Аминадавов од племена Јудиног; ");
INSERT INTO srp1868_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","а прилог његов беше једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала, по сиклу светом; а обоје пуно брашна белог помешаног с уљем за дар. ");
INSERT INTO srp1868_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Насона сина Аминадавовог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Други дан донесе Натанило, син Согаров, кнез племена Исахаровог, ");
INSERT INTO srp1868_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","донесе прилог свој: једну зделу сребрну од сто и тридесет сикала, једну чашу сребрну од седамдесет сикала по сиклу светом, обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Натанаила сина Согаровог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Трећи дан донесе кнез синова Завулонових, Елијав син Хелонов; ");
INSERT INTO srp1868_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","његов прилог беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Елијава, сина Хелоновог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Четврти дан донесе кнез синова Рувимових Елисур син Седијуров; ");
INSERT INTO srp1868_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Елисура, сина Седијуровог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Пети дан донесе кнез синова Симеунових, Саламило, син Сурисадајев; ");
INSERT INTO srp1868_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Саламила сина Сурисадајевог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Шести дан донесе кнез синова Гадових, Елисаф син Рагуилов; ");
INSERT INTO srp1868_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Елисафа, сина Рагуиловог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Седми дан донесе кнез синова Јефремових Елисама, син Емијудов; ");
INSERT INTO srp1868_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Елисаме, сина Емијудовог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Осми дан донесе кнез синова Манасијиних Гамалило, син Фадасуров; ");
INSERT INTO srp1868_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Гамалила, сина Фадасуровог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Девети дан донесе кнез синова Венијаминових Авидан син Гадеонијев; ");
INSERT INTO srp1868_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Авидана, сина Гадеонијевог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Десети дан донесе кнез синова Данових Ахијезер, син Амисадајев; ");
INSERT INTO srp1868_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Ахијезера сина Амисадајевог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Једанаести дан донесе кнез синова Асирових Фагаило син Ехранов; ");
INSERT INTO srp1868_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Фагаила, сина Ехрановог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Дванаести дан донесе кнез синова Нефталимових Ахиреј син Енанов; ");
INSERT INTO srp1868_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","прилог његов беше: једна здела сребрна од сто и тридесет сикала, једна чаша сребрна од седамдесет сикала по сиклу светом, а обоје пуно белог брашна помешаног с уљем за дар; ");
INSERT INTO srp1868_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","једна кадионица златна од десет сикала, пуна када; ");
INSERT INTO srp1868_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","једно теле, један ован, једно јагње од године за жртву паљеницу; ");
INSERT INTO srp1868_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","један јарац за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","а за жртву захвалну два вола, пет овнова, пет јараца, пет јагањаца од године. То би прилог Ахиреја, сина Енановог. ");
INSERT INTO srp1868_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","То је прилог од кнезова Израиљевих да се посвети олтар пошто би помазан: дванаест здела сребрних, дванаест чаша сребрних, дванаест кадионица златних; ");
INSERT INTO srp1868_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","свака здела сребрна од сто и тридесет сикала, и свака чаша од седамдесет сикала; свега сребра у тим судовима две хиљаде и четири стотине сикала, по сиклу светом; ");
INSERT INTO srp1868_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","дванаест кадионица златних пуних када, свака кадионица од десет сикала, по сиклу светом; свега злата у кадионицама сто и двадесет сикала; ");
INSERT INTO srp1868_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","свега стоке за жртву паљеницу дванаест телаца, дванаест овнова, дванаест јагањаца од године с даром својим, и јараца дванаест за грех; ");
INSERT INTO srp1868_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","а свега стоке за жртву захвалну двадесет и четири вола, шездесет овнова, шездесет јараца, шездесет јагањаца од године. То је прилог да се посвети олтар, пошто би помазан. ");
INSERT INTO srp1868_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","И кад Мојсије улажаше у шатор од састанка да говори пред Богом, тада чујаше глас где му говори са заклопца што беше на ковчегу од сведочанства између два херувима; и говораше му. ");
INSERT INTO srp1868_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Кажи Арону и реци му: Кад запалиш жишке, седам жижака нека светли напред, на свећњаку. ");
INSERT INTO srp1868_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","И учини Арон тако, и запали жишке да светле спреда, на свећњаку, као што Господ заповеди Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","А свећњак беше скован од злата, и ступац му и цвеће сковано; по прилици коју показа Господ Мојсију тако беше начинио свећњак. ");
INSERT INTO srp1868_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Узми Левите између синова Израиљевих, и очисти их. ");
INSERT INTO srp1868_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","А учини им ово да их очистиш: покропи их водом очишћења, а они нека обрију све тело своје и оперу хаљине своје, и очистиће се. ");
INSERT INTO srp1868_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Потом нека узму теле с даром уз њега, белим брашном помешаним с уљем; и друго теле узми за грех. ");
INSERT INTO srp1868_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Па доведи Левите пред шатор од састанка, и сазови сав збор синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","И доведи Левите пред Господа, и нека метну синови Израиљеви руке своје на Левите. ");
INSERT INTO srp1868_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","И Арон нека принесе Левите Господу за принос од синова Израиљевих да врше службу Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","А Левити нека метну руке своје на главе теоцима, па принеси једно теле за грех а друго на жртву паљеницу Господу да се очисте Левити. ");
INSERT INTO srp1868_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","И постави Левите пред Ароном и синовима његовим, и принеси их за принос Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","И одвој Левите између синова Израиљевих да буду моји Левити. ");
INSERT INTO srp1868_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","А после нека дођу Левити да служе у шатору од састанка, кад их очистиш и принесеш за принос. ");
INSERT INTO srp1868_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Јер су мени дани између синова Израиљевих; за све што отвара материцу, за све првенце између синова Израиљевих узех њих. ");
INSERT INTO srp1868_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Јер је мој сваки првенац између синова Израиљевих и од људи и од стоке; онај дан кад побих све првенце у земљи мисирској, посветио сам их себи. ");
INSERT INTO srp1868_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","А Левите узех за све првенце синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","И дадох Левите на дар Арону и синовима његовим између синова Израиљевих, да служе место синова Израиљевих у шатору од састанка, и да буду откуп за синове Израиљеве, да не би долазио помор на синове Израиљеве, кад би приступали к светињи синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","И учини Мојсије и Арон и сав збор синова Израиљевих Левитима све што заповеди Господ Мојсију за Левите, тако им учинише синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","И очистише се Левити, и опраше хаљине своје, и принесе их Арон за принос пред Господом, и очисти их Арон да би били чисти. ");
INSERT INTO srp1868_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","А онда тек приступише Левити да врше службу своју у шатору од састанка пред Ароном и пред синовима његовим; као што заповеди Господ Мојсију за Левите, тако им учинише. ");
INSERT INTO srp1868_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","И опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","И ово је за Левите: од двадесет и пет година и више нека ступају у службу да служе у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","А кад коме буде педесет година, нека излази из те службе и више нека не служи. ");
INSERT INTO srp1868_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Али нека служи браћи својој у шатору од састанка радећи шта треба радити, а сам нека не врши службу. Тако учини Левитима за послове њихове. ");
INSERT INTO srp1868_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Још рече Господ Мојсију у пустињи синајској друге године по изласку њиховом из земље мисирске првог месеца, говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Нека славе синови Израиљеви пасху у одређено време. ");
INSERT INTO srp1868_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Четрнаестог дана овог месеца увече славите је у одређено време, по свим законима и по свим уредбама њеним славите је. ");
INSERT INTO srp1868_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","И рече Мојсије синовима Израиљевим да славе пасху. ");
INSERT INTO srp1868_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","И славите пасху првог месеца четрнаестог дана увече у пустињи синајској; како беше Господ заповедио Мојсију, све онако учинише синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","А беху неки који се оскврнише о мртваца те не могаху славити пасхе онај дан; и дођоше исти дан пред Мојсија и пред Арона; ");
INSERT INTO srp1868_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","и рекоше му људи они: Ми смо нечисти од мртваца; зашто да нам није слободно принети жртву Господу у време заједно са синовима Израиљевим? ");
INSERT INTO srp1868_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","А Мојсије им рече: Станите да чујем шта ће заповедити Господ за вас. ");
INSERT INTO srp1868_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","А Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Кажи синовима Израиљевим и реци: Ко би био нечист од мртваца или би био на далеком путу између вас или између вашег натражја, нека слави пасху Господу, ");
INSERT INTO srp1868_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","другог месеца четрнаестог дана увече нека је славе с пресним хлебом и с горким зељем нека је једу. ");
INSERT INTO srp1868_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Нека не остављају од ње ништа до јутра и кости да јој не преломе, по свему закону за пасху нека је славе. ");
INSERT INTO srp1868_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","А ко је чист и није на путу, па би пропустио славити пасху, да се истреби душа она из народа свог, јер не принесе Господу жртве на време, грех свој нека носи онај човек. ");
INSERT INTO srp1868_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","И ако би међу вама живео странац и славио би пасху Господу, по закону и уредби за пасху нека је слави; а закон да вам је једнак и странцу и ономе ко се родио у земљи. ");
INSERT INTO srp1868_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","А у који дан би подигнут шатор, покри облак шатор над наслоном од сведочанства; а увече беше над шатором као огањ до јутра. ");
INSERT INTO srp1868_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Тако беше једнако: облак га заклањаше, али ноћу беше као огањ. ");
INSERT INTO srp1868_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","И кад би се облак подигао изнад шатора, тада полажаху синови Израиљеви, а где би стао облак, онде се заустављаху синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","По заповести Господњој полажаху синови Израиљеви, и по заповести Господњој устављаху се; докле год стајаше облак над шатором, они стајаху у логору, ");
INSERT INTO srp1868_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","и кад облак дуго стајаше над шатором, тада свршиваху синови Израиљеви шта треба свршивати Господу и не полажаху. ");
INSERT INTO srp1868_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","И кад облак беше над шатором мало дана, по заповести Господњој стајаху у логору и по заповести Господњој полажаху. ");
INSERT INTO srp1868_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Кад би, пак, облак стајао од вечера до јутра, а ујутро би се подигао облак, тада полажаху; било дању или ноћу, кад би се облак подигао, они полажаху. ");
INSERT INTO srp1868_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ако ли би два дана или месец дана или годину облак стајао над шатором, стајаху у логору синови Израиљеви и не полажаху, а како би се подигао, они полажаху. ");
INSERT INTO srp1868_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","По заповести Господњој стајаху у логор, и по заповести Господњој полажаху; и свршиваху шта треба свршивати Господу, као што беше заповедио Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Начини себи две трубе од сребра, коване да буду; њима ћеш сазивати збор и заповедати да полази војска. ");
INSERT INTO srp1868_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Кад обе затрубе, тада нека се скупља к теби сав збор на врата шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","А кад једна затруби, тада нека се скупљају к теби кнезови, главари од хиљада Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","А кад затрубе потресајући, тада нека се креће логор који лежи према истоку. ");
INSERT INTO srp1868_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","А кад затрубите други пут потресајући, онда нека се креће логор који је на југу; потресајући нека се труби кад треба да пођу. ");
INSERT INTO srp1868_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","А кад сазивате збор, трубите, али не потресајући. ");
INSERT INTO srp1868_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","А нека трубе у трубе синови Аронови свештеници; то да вам је уредба вечна од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","И кад пођете на војску у земљи својој на непријатеља који удари на вас, трубите у трубе потресајући; и Господ Бог ваш опоменуће вас се, и сачуваћете се од непријатеља својих. ");
INSERT INTO srp1868_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Тако и у дан весеља свог и на празнике своје и почетке месеца својих трубите у трубе приносећи жртве своје паљенице и жртве своје захвалне, и биће вам спомен пред Богом вашим. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","И у двадесети дан другог месеца друге године подиже се облак изнад шатора од сведочанства. ");
INSERT INTO srp1868_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","И пођоше синови Израиљеви својим редом из пустиње синајске, и устави се облак у пустињи фаранској. ");
INSERT INTO srp1868_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Тако пођоше први пут, као што Господ заповеди преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","И пође напред застава војске синова Јудиних у четама својим; и над војском њиховом беше Насон, син Аминадавов; ");
INSERT INTO srp1868_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","а над војском племена синова Исахарових Натанаило, син Согаров; ");
INSERT INTO srp1868_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","а над војском племена синова Завулонових Елијав, син Хелонов. ");
INSERT INTO srp1868_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","И сложише шатор, па пођоше синови Гирсонови и синови Мераријеви носећи шатор. ");
INSERT INTO srp1868_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Потом пође застава војске синова Рувимових, а над њиховом војском беше Елисур, син Седијуров, ");
INSERT INTO srp1868_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","а над војском племена синова Симеунових Саламило, син Сурисадајев, ");
INSERT INTO srp1868_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","а над војском племена синова Гадових Елисаф син Рагуилов. ");
INSERT INTO srp1868_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","И пођоше синови Катови носећи светињу, да би они подигли шатор докле ови дођу. ");
INSERT INTO srp1868_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Потом пође застава војске синова Јефремових у четама својим, а над војском њиховом беше Елисама, син Емијудов, ");
INSERT INTO srp1868_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","а над војском племена синова Манасијиних Гамалило син Фадасуров, ");
INSERT INTO srp1868_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","а над војском племена синова Венијаминових Авидан син Гадеонијев. ");
INSERT INTO srp1868_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Најпосле пође застава војске синова Данових у четама својим, задња војска, и над војском њиховом беше Ахијезер, син Амисадајев, ");
INSERT INTO srp1868_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","а над војском племена синова Асирових Фагаило, син Ехранов, ");
INSERT INTO srp1868_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","а над војском племена синова Нефталимових Ахиреј, син Енанов. ");
INSERT INTO srp1868_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Тим редом пођоше синови Израиљеви у четама својим, и тако иђаху. ");
INSERT INTO srp1868_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","А Мојсије рече Јоваву, сину Рагуиловом Мадијанину тасту свом: Идемо на место за које рече Господ: Вама ћу га дати. Хајде с нама, и добро ћемо ти учинити, јер је Господ обећао Израиљу много добра. ");
INSERT INTO srp1868_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","А он му рече: Нећу ићи, него идем у своју земљу и у род свој. ");
INSERT INTO srp1868_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","А Мојсије рече: Немој нас оставити, јер знаш места у пустињи где бисмо могли стајати, па нам буди вођ. ");
INSERT INTO srp1868_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","И ако пођеш с нама кад дође добро које ће нам учинити Господ, учинићемо ти добро. ");
INSERT INTO srp1868_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","И тако пођоше од горе Господње, и иђаху три дана, и ковчег завета Господњег иђаше пред њима три дана тражећи место где би починули. ");
INSERT INTO srp1868_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","И облак Господњи беше над њима сваки дан кад полажаху с места, где беху у логору. ");
INSERT INTO srp1868_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","И кад полажаше ковчег, говораше Мојсије: Устани Господе, и нека се разаспу непријатељи Твоји, и нека беже испред Тебе који мрзе на Те. ");
INSERT INTO srp1868_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","А кад се устављаше, говораше: Уврати се, Господе, к мноштву хиљада Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","После стаде се тужити народ да му је тешко; а то не би по вољи Господу; и кад Господ чу, разгневи се; и распали се на њих огањ Господњи, и сажеже крајње у логору. ");
INSERT INTO srp1868_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Тада завапи народ к Мојсију, а Мојсије се помоли Господу, и угаси се огањ. ");
INSERT INTO srp1868_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","И прозва се оно место Тавера, јер се распали на њих огањ Господњи. ");
INSERT INTO srp1868_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","А светина што беше међу њима, беше врло лакома, те и синови Израиљеви стадоше плакати говорећи: Ко ће нас нахранити меса? ");
INSERT INTO srp1868_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Опоменусмо се риба што јеђасмо у Мисиру забадава, и краставаца и диња и лука црног и белог. ");
INSERT INTO srp1868_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","А сада посахну душа наша, нема ништа осим мане пред очима нашим. ");
INSERT INTO srp1868_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","А мана беше као семе коријандрово, а боја му беше као боја у бдела. ");
INSERT INTO srp1868_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","И излажаше народ, те купљаху, и мељаху на жрвњима или туцаху у ступама, и куваху у котлу, или мешаху погаче; а укус јој беше као укус од новог уља. ");
INSERT INTO srp1868_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","И кад падаше роса по логору ноћу, падаше с њом и мана. ");
INSERT INTO srp1868_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","И чу Мојсије где народ плаче у породицама својим, сваки на вратима од шатора свог; и Господ се разгневи врло, и Мојсију би тешко. ");
INSERT INTO srp1868_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Па рече Мојсије Господу: Зашто учини такво зло слузи свом? И зашто не нађох милости пред Тобом, него метну на ме терет свега народа овог? ");
INSERT INTO srp1868_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Еда ли ја зачех сав овај народ? Еда ли га ја родих, кад ми кажеш: Изнеси га у наручју свом, као што носи дојиља дете, у ону земљу за коју си се заклео оцима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Откуда мени меса да дам свему овом народу? Јер плачу преда мном говорећи: Дај нам меса да једемо. ");
INSERT INTO srp1868_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Не могу ја сам носити сав народ овај, јер је тешко за мене. ");
INSERT INTO srp1868_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ако ћеш тако чинити са мном, убиј ме боље, ако сам нашао милост пред Тобом, да не гледам зло своје. ");
INSERT INTO srp1868_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","А Господ рече Мојсију: Сабери ми седамдесет људи између старешина Израиљевих, које знаш да су старешине народу и управитељи његови, и доведи их к шатору од састанка, нека онде стану с тобом. ");
INSERT INTO srp1868_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Тада ћу сићи и говорити онде с тобом, и узећу од духа који је на теби и метнућу на њих, да носе с тобом терет народни и да не носиш ти сам. ");
INSERT INTO srp1868_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","А народу реци: Приправите се за сутра да једете меса, јер плакасте да Господ чу, и рекосте: Ко ће нас нахранити меса? Јер нам добро беше у Мисиру. Даће вам, дакле, Господ меса и јешћете. ");
INSERT INTO srp1868_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Нећете јести један дан, ни два дана, ни пет дана, ни десет дана, ни двадесет дана; ");
INSERT INTO srp1868_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","него цео месец дана, докле вам на нос не удари и не огади вам се, зато што одбацисте Господа који је међу вама и плакасте пред Њим говорећи: Зашто изиђосмо из Мисира? ");
INSERT INTO srp1868_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","А Мојсије рече: Шест стотина хиљада пешака има народа, у коме сам, па Ти кажеш: Даћу им меса да једу цео месец дана. ");
INSERT INTO srp1868_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Еда ли ће им се поклати овце и говеда да им достане? Или ће им се покупити све рибе морске да им буде доста? ");
INSERT INTO srp1868_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","А Господ рече Мојсију: Зар рука Господња неће бити довољна? Видећеш хоће ли бити шта ти рекох или неће. ");
INSERT INTO srp1868_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","И Мојсије изиђе и рече народу речи Господње; и сабра седамдесет људи између старешина народних, и постави их око шатора. ");
INSERT INTO srp1868_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","И Господ сиђе у облаку и говори к њему, и узевши од духа који беше на њему метну на оних седамдесет људи старешина; и кад дух дође на њих, пророковаху, али више никад. ");
INSERT INTO srp1868_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","А два човека осташе у логору, једном беше име Елдад, а другом Модад, на које дође дух, јер и они беху записани, али не дођоше к шатору, и стадоше пророковати у логору. ");
INSERT INTO srp1868_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","И дотрча момак, те јави Мојсију говорећи: Елдад и Модад пророкују у логору. ");
INSERT INTO srp1868_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","А Исус, син Навин, слуга Мојсијев, један од момака његових, рече говорећи: Мојсије, господару мој, забрани им. ");
INSERT INTO srp1868_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","А Мојсије му одговори: Зар завидиш мене ради? Камо да сав народ Господњи постану пророци и да Господ пусти дух свој на њих! ");
INSERT INTO srp1868_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Потом се врати Мојсије у логор са старешинама Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Тада се подиже ветар од Господа, и потера од мора препелице, и разасу их по логору на дан хода одовуда и на дан хода одонуда око логора, на два лакта од земље. ");
INSERT INTO srp1868_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","И уставши народ цео онај дан и сву ноћ и цео други дан купљаше препелице: и ко накупи најмање накупи десет гомора; и повешаше их себи редом око логора. ");
INSERT INTO srp1868_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Али месо још им беше у зубима, јоште га не поједоше, а Господ се разгневи на народ и удари Господ народ помором врло великим. ");
INSERT INTO srp1868_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","И прозва се оно место Киврот-Атава јер онде укопаше народ који се беше полакомио. ");
INSERT INTO srp1868_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","И пође народ од Киврот-Атаве у Асирот, и стадоше у Асироту. ");
INSERT INTO srp1868_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","И стадоше викати Марија и Арон на Мојсија ради жене Мадијанке, којом се ожени, јер се ожени Мадијанком. ");
INSERT INTO srp1868_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","И рекоше: Зар је само преко Мојсија говорио Господ? Није ли говорио и преко нас? И то чу Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","А Мојсије беше човек врло кротак мимо све људе на земљи. ");
INSERT INTO srp1868_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","И одмах рече Господ Мојсију и Арону и Марији: Дођите вас троје у шатор од састанка. И отидоше њих троје. ");
INSERT INTO srp1868_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Тада сиђе Господ у ступу од облака, стаде на вратима од шатора. И викну Арона и Марију, и дођоше обоје. ");
INSERT INTO srp1868_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","И рече им: Чујте сада речи моје: пророк кад је међу вама, ја ћу му се Господ јављати у утвари и говорићу с њим у сну. ");
INSERT INTO srp1868_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Али није такав мој слуга Мојсије, који је веран у свем дому мом. ");
INSERT INTO srp1868_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Њему говорим из уста к устима, и он ме гледа доиста, а не у тами нити у каквој прилици Господњој. Како се дакле не побојасте викати на слугу мог, на Мојсија? ");
INSERT INTO srp1868_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","И гнев се Господњи распали на њих, и Он отиде. ");
INSERT INTO srp1868_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","И облак се подиже са шатора; и гле, Марија беше губава, бела као снег. И Арон погледа Марију, а она губава. ");
INSERT INTO srp1868_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Тада рече Арон Мојсију: Господару, молим те, не мећи на нас греха овог, јер лудо учинисмо и згрешисмо. ");
INSERT INTO srp1868_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Немој да ова буде као мртво дете, коме је месо пола труло кад излази из утробе мајке своје. ");
INSERT INTO srp1868_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","И вапи Мојсије ка Господу говорећи: Боже, молим Ти се, исцели је. ");
INSERT INTO srp1868_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","А Господ одговори Мојсију: Да јој је отац њен пљунуо у лице, не би ли се стидела седам дана? Нека буде одлучена седам дана изван логора, а после нека буде опет примљена. ");
INSERT INTO srp1868_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Тако би Марија одлучена изван логора седам дана; и народ не пође оданде докле Марија не би опет примљена. ");
INSERT INTO srp1868_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","А потом пође народ од Асирота, и стадоше у пустињи фаранској. ");
INSERT INTO srp1868_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","И Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Пошљи људе да уходе земљу хананску, коју ћу дати синовима Израиљевим; по једног човека од сваког племена отаца њихових пошљите, све главаре између њих. ");
INSERT INTO srp1868_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","И посла их Мојсије из пустиње фаранске по заповести Господњој; и сви људи беху главари синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","А ово су им имена: од племена Рувимовог Самуило син Захуров; ");
INSERT INTO srp1868_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","од племена Симеуновог Сафат син Сурин; ");
INSERT INTO srp1868_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","од племена Јудиног Халев син Јефонијин; ");
INSERT INTO srp1868_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","од племена Исахаровог Игал син Јосифов; ");
INSERT INTO srp1868_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","од племена Јефремовог Авсије син Навин; ");
INSERT INTO srp1868_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","од племена Венијаминовог Фалтије син Рафујев; ");
INSERT INTO srp1868_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","од племена Завулоновог Гудило син Судин; ");
INSERT INTO srp1868_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","од племена Јосифовог, од племена Манасијиног Гадије син Сусин; ");
INSERT INTO srp1868_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","од племена Дановог Амило син Гамалин. ");
INSERT INTO srp1868_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Од племена Асировог Сатур син Михаилов; ");
INSERT INTO srp1868_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","од племена Нефталимовог Навија син Савин; ");
INSERT INTO srp1868_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","од племена Гадовог Гудило син Махилов. ");
INSERT INTO srp1868_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","То су имена људима које посла Мојсије да уходе земљу. И назва Мојсије Авсија сина Навиног Исус. ");
INSERT INTO srp1868_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","И шаљући их Мојсије да уходе земљу хананску рече им: идите овуда на југ, па изиђите на гору; ");
INSERT INTO srp1868_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","и видите земљу каква је и какав народ живи у њој, је ли јак или слаб, је ли мали или велик; ");
INSERT INTO srp1868_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","и каква је земља у којој живи, је ли добра или рђава; и каква су места у којима живи, еда ли под шаторима или у тврдим градовима; ");
INSERT INTO srp1868_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","и каква је сама земља, је ли родна или неродна, има ли у њој дрвета или нема; будите слободни, и узмите рода оне земље. А тада беше време првом грожђу. ");
INSERT INTO srp1868_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","И отишавши уходише земљу од пустиње синске до Реова како се иде у Емат. ");
INSERT INTO srp1868_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","И отидоше на југ, и дођоше до Хеврона, где беху Ахиман и Сесије и Телиман, синови Енакови. А Хеврон беше сазидан на седам година пре Соана мисирског. ");
INSERT INTO srp1868_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Потом дођоше до потока Есхола, и онде одсекоше лозу с гроздом једним, и понесоше га двојица на моци; тако и шипака и смокава. ");
INSERT INTO srp1868_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","И прозва се оно место поток Есхол од грозда, који онде одсекоше синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","И после четрдесет дана вратише се из земље коју уходише. ");
INSERT INTO srp1868_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","И вративши се дођоше к Мојсију и Арону и ка свему збору синова Израиљевих у пустињу фаранску, у Кадис; и приповедише њима и свему збору ствар, и показаше им род оне земље. ");
INSERT INTO srp1868_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","И приповедајући им рекоше: Идосмо у земљу у коју си нас послао; доиста тече у њој млеко и мед, и ево рода њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Али је јак народ који живи у оној земљи, и градови су им тврди и врло велики; а видесмо онде и синове Енакове. ");
INSERT INTO srp1868_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Амалик живи на јужној страни; а Хетеји и Јевусеји и Амореји живе у планини, а Хананеји живе на мору и на Јордану. ");
INSERT INTO srp1868_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","А Халев утишаваше народ пред Мојсијем; и говораше: хајде да идемо да је узмемо, јер је можемо покорити. ");
INSERT INTO srp1868_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Али други људи који идоше с њим говораху: Не можемо ићи на онај народ, јер је јачи од нас. ");
INSERT INTO srp1868_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","И просуше зао глас о земљи коју уходише међу синовима Израиљевим говорећи: Земља коју прођосмо и уходисмо земља је која прождире своје становнике, и сав народ који видесмо у њој јесу људи врло велики. ");
INSERT INTO srp1868_vpl VALUES ("NU13_34","005_13_34","NUM","13","34","34","Видесмо онде и дивове, синове Енакове, рода дивовског, и чињаше нам се да смо према њима као скакавци, такви се и њима чињасмо. ");
INSERT INTO srp1868_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Тада се подиже сав збор и стаде викати, и народ плакаше ону ноћ. ");
INSERT INTO srp1868_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","И викаху на Мојсија и на Арона сви синови Израиљеви; и сав збор рече им: Камо да смо помрли у земљи мисирској или да помремо у овој пустињи! ");
INSERT INTO srp1868_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Зашто нас води Господ у ту земљу да изгинемо од мача, жене наше и деца наша да постану робље? Није ли боље да се вратимо у Мисир? ");
INSERT INTO srp1868_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","И рекоше међу собом: Да поставимо старешину, па да се вратимо у Мисир. ");
INSERT INTO srp1868_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Тада Мојсије и Арон падоше ничице пред свим збором синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","А Исус син Навин и Халев син Јефонијин између оних што уходише земљу раздреше хаљине своје, ");
INSERT INTO srp1868_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","и рекоше свему збору синова Израиљевих говорећи: Земља коју прођосмо и уходисмо, врло је добра земља. ");
INSERT INTO srp1868_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ако смо мили Господу, Он ће нас одвести у ту земљу, и даће нам је; а то је земља у којој тече млеко и мед. ");
INSERT INTO srp1868_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Само се не одмећите Господа, и не бојте се народа оне земље; јер их можемо појести; одступио је од њих заклон њихов, а с нама је Господ, не бојте их се. ");
INSERT INTO srp1868_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Тада рече сав збор да их побију камењем; али се показа слава Господња свим синовима Израиљевим у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","И рече Господ Мојсију: Докле ће ме вређати тај народ? Кад ли ће ми веровати после толиких знака што сам учинио међу њима? ");
INSERT INTO srp1868_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ударићу га помором, и расућу га; а од тебе ћу учинити народ велик и јачи од овог. ");
INSERT INTO srp1868_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","А Мојсије рече Господу: Али ће чути Мисирци, између којих си извео овај народ силом својом, ");
INSERT INTO srp1868_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","и рећи ће с људима ове земље, који су чули да си Ти, Господе, био усред народа и да си се очима виђао, Господе, и облак твој да је стајао над њима, и у ступу од облака да си ишао пред њима дану и у ступу огњеном ноћу; ");
INSERT INTO srp1868_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","па кад побијеш овај народ, све до једног, говориће народи, који су чули приповест о Теби, говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Није могао Господ довести народ овај у земљу коју им је са заклетвом обећао, зато их поби у пустињи. ");
INSERT INTO srp1868_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Нека се, дакле, прослави сила Господња, као што си рекао говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Господ дуго чека и обилан је милошћу, прашта безакоње и грех, али не правда кривога, него походи безакоње отачко на синовима до трећег и четвртог колена. ");
INSERT INTO srp1868_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Опрости безакоње овом народу ради велике милости своје, као што си праштао народу овом од Мисира довде. ");
INSERT INTO srp1868_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","А Господ рече: Праштам по речи твојој. ");
INSERT INTO srp1868_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Али тако ја жив био, и тако сва земља била пуна славе Господње, ");
INSERT INTO srp1868_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ти људи који видеше славу моју и знаке моје што сам учинио у Мисиру и у овој пустињи, и кушаше ме већ десет пута, и не послушаше речи моје, ");
INSERT INTO srp1868_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","неће видети земље коју са заклетвом обећах оцима њиховим, неће видети ни један од оних који ме увредише. ");
INSERT INTO srp1868_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","А слугу свог Халева, у коме беше други дух и који се сасвим мене држао, њега ћу одвести у земљу у коју је ишао, и семе ће је његово наследити. ");
INSERT INTO srp1868_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Али Амалик и Хананеј седе у долини, зато се сутра вратите натраг, и идите у пустињу к црвеном мору. ");
INSERT INTO srp1868_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Још рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Докле ће тај зли збор викати на ме, чуо сам вику синова Израиљевих, који вичу на ме. ");
INSERT INTO srp1868_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Кажи им: Тако ја жив био, каже Господ, учинићу вам онако како сте говорили и ја чух. ");
INSERT INTO srp1868_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","У овој ће пустињи попадати мртва телеса ваша, и сви између вас који су избројани у свем броју вашем од двадесет година и више, који викасте на ме, ");
INSERT INTO srp1868_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","нећете ући у земљу, за коју подигавши руку своју заклех се да ћу вас населити у њој, осим Халева, сина Јефонијиног и Исуса, сина Навиног. ");
INSERT INTO srp1868_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","А децу вашу, за коју рекосте да ће постати робље, њих ћу одвести, и они ће познати земљу за коју ви не марите. ");
INSERT INTO srp1868_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","А ваша телеса мртва ће попадати у овој пустињи. ");
INSERT INTO srp1868_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","А деца ваша биће пастири по пустињи четрдесет година, и носиће кар за прељубе ваше, докле не испропадају телеса ваша у пустињи. ");
INSERT INTO srp1868_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","По броју дана, за које уходисте земљу, четрдесет дана, за сваки дан по годину, носићете грехе своје, четрдесет година, и познаћете да сам прекинуо с вама. ");
INSERT INTO srp1868_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ја Господ рекох, и тако ћу учинити свему том збору злом, који се сабрао на ме: у пустињи ће пропасти и ту помрети. ");
INSERT INTO srp1868_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","А људи које беше послао Мојсије да уходе земљу, и који вративши се побунише сав збор да виче на њ, просувши зао глас о земљи, ");
INSERT INTO srp1868_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ти људи, који просуше зао глас о земљи, помреше од помора пред Господом; ");
INSERT INTO srp1868_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","а Исус, син Навин и Халев, син Јефонијин осташе живи између људи који су ишли да уходе земљу. ");
INSERT INTO srp1868_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","И Мојсије каза све ове речи свим синовима Израиљевим, и народ плака веома. ");
INSERT INTO srp1868_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","А сутрадан уставши пођоше наврх горе, и рекоше: Ево нас, идемо на место за које је говорио Господ, јер згрешисмо. ");
INSERT INTO srp1868_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Али Мојсије рече: Зашто преступате заповест Господњу? Од тога неће бити ништа. ");
INSERT INTO srp1868_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Не идите горе, јер Господ није међу вама; немојте да вас побију непријатељи ваши. ");
INSERT INTO srp1868_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Јер је Амалик и Хананеј тамо пред вама, и изгинућете од мача, јер одустависте Господа, па неће ни Господ бити с вама. ");
INSERT INTO srp1868_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Али они, ипак, навалише да иду наврх горе; али ковчег завета Господњег и Мојсије не изађоше из логора. ");
INSERT INTO srp1868_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Тада сиђе Амалик и Хананеј, који живљаху у оној гори, и разбише их и бацише дори до Орме. ");
INSERT INTO srp1868_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Реци синовима Израиљевим и кажи им: Кад дођете у земљу где ћете наставати, коју ћу вам ја дати, ");
INSERT INTO srp1868_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","и станете приносити жртву огњену Господу, жртву паљеницу или жртву завета ради или од драге воље, или о празницима својим, готовећи мирис угодни Господу од крупне или од ситне стоке, ");
INSERT INTO srp1868_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","тада ко принесе принос свој Господу, нека донесе уза њ дар, десетину ефе белог брашна помешаног с четвртином ина уља. ");
INSERT INTO srp1868_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","И вина четврт ина за налив донеси уз жртву паљеницу или уз другу жртву, на свако јагње. ");
INSERT INTO srp1868_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","А уз овна донеси дар, две десетине белог брашна помешаног са трећином ина уља, ");
INSERT INTO srp1868_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","и вина за налив трећину ина принећеш за мирис угодни Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","А кад приносиш теле на жртву паљеницу или на жртву ради завета или на жртву захвалну Господу, ");
INSERT INTO srp1868_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","онда нека се донесе уз теле дар, три десетине ефе белог брашна помешаног с по ина уља, ");
INSERT INTO srp1868_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","и вина донеси за налив по ина; то је жртва огњена за мирис угодни Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Тако нека буде уза сваког вола и уза сваког овна и уза свако живинче између оваца или коза. ");
INSERT INTO srp1868_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Према броју колико принесете, учините тако уза свако, колико их буде. ");
INSERT INTO srp1868_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Сваки домородац тако нека чини приносећи жртву паљеницу за мирис угодни Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Тако ако буде међу вама и дошљак или ко би се бавио међу вама, па би принео жртву огњену за мирис угодни Господу, нека чини онако како ви чините. ");
INSERT INTO srp1868_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Зборе! Вама и дошљаку који је међу вама један да је закон, закон вечан од колена на колено; дошљак ће бити као и ви пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Један закон и једна уредба да буде вама и дошљаку, који је међу вама. ");
INSERT INTO srp1868_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Кажи синовима Израиљевим и реци им: Кад дођете у земљу, у коју ћу вас ја одвести, ");
INSERT INTO srp1868_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","па станете јести хлеб оне земље, тада принесите принос Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Од првина теста свог приносите у принос колач, као принос од гумна тако га приносите. ");
INSERT INTO srp1868_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Од првина теста свог дајте Господу принос од колена до колена. ");
INSERT INTO srp1868_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","А кад бисте погрешили, те не бисте учинили свих ових заповести, које каза Господ Мојсију, ");
INSERT INTO srp1868_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","све што вам је заповедио Господ преко Мојсија, од дана кад заповеди Господ и после од колена до колена, ");
INSERT INTO srp1868_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ако се буде учинило погрешком, да збор не зна, онда сав збор нека принесе на жртву паљеницу за мирис угодни Господу теле с даром његовим и с наливом његовим по уредби, и једно јаре на жртву за грех. ");
INSERT INTO srp1868_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","И свештеник нека очисти сав збор синова Израиљевих, и опростиће им се, јер је погрешка и они донесоше пред Господа свој принос за жртву огњену Господу и принос за грех свој ради погрешке своје. ");
INSERT INTO srp1868_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Опростиће се свему збору синова Израиљевих и дошљаку који се бави међу њима, јер је погрешка свега народа. ");
INSERT INTO srp1868_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ако ли једна душа згреши не знајући, нека принесе козу од године на жртву за грех. ");
INSERT INTO srp1868_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","И свештеник нека очисти душу која буде згрешила не знајући пред Господом, и кад је очисти опростиће јој се. ");
INSERT INTO srp1868_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","И за рођеног у земљи синова Израиљевих и за дошљака, који се бави међу вама, један закон нека буде кад ко згреши не знајући. ");
INSERT INTO srp1868_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Али ко од силе згреши између рођених у земљи или између дошљака, он ружи Господа; нека се истреби душа она из народа свог. ");
INSERT INTO srp1868_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Јер презре реч Господњу, и заповест Његову погази; нека се истреби она душа; безакоње је њено на њој. ");
INSERT INTO srp1868_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","А кад беху синови Израиљеви у пустињи, нађоше једног где купи дрва у суботу. ");
INSERT INTO srp1868_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","И који га нађоше где купи дрва, доведоше га к Мојсију и к Арону и ка свему збору. ");
INSERT INTO srp1868_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","И метнуше га под стражу, јер не беше казано шта ће се чинити с њим. ");
INSERT INTO srp1868_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","А Господ рече Мојсију: Нека се погуби тај човек; нека га заспе камењем сав збор иза логора. ");
INSERT INTO srp1868_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","И сав збор изведе га иза логора и засуше га камењем, и умре, као што заповеди Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Реци синовима Израиљевим и кажи им, нека ударају ресе по скутовима од хаљина својих од колена до колена, и над ресе нека мећу врпцу плаву. ");
INSERT INTO srp1868_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","И имаћете ресе зато да се гледајући их опомињете свих заповести Господњих и творите их, и да се не заносите за срцем својим и за очима својим, за којима чините прељубу; ");
INSERT INTO srp1868_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","него да памтите и творите све заповести моје, и будете свети Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ја сам Господ Бог ваш, који сам вас извео из земље мисирске, да вам будем Бог. Ја сам Господ Бог ваш. ");
INSERT INTO srp1868_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","А Кореј, син Исара сина Ката сина Левијевог, и Датан и Авирон синови Елијавови, и Авнан син Фалета сина Рувимовог побунише се, ");
INSERT INTO srp1868_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","и усташе на Мојсија, и с њима двеста и педесет људи између синова Израиљевих, главара народних, који се сазиваху на збор и беху људи знатни. ");
INSERT INTO srp1868_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","И скупише се на Мојсија и на Арона и рекоше им: Доста нек вам је; сав овај народ, сви су свети, и међу њима је Господ; зашто се ви подижете над збором Господњим? ");
INSERT INTO srp1868_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Кад то чу Мојсије, паде ничице. ");
INSERT INTO srp1868_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Потом рече Кореју и свој дружини његовој говорећи: Сутра ће показати Господ ко је Његов, и ко је свет, и кога је пустио к себи, јер кога је изабрао оног ће пустити к себи. ");
INSERT INTO srp1868_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ово учините: Узмите кадионице, Кореј са свом дружином својом. ");
INSERT INTO srp1868_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","И метните сутра у њих огња и метните у њих када пред Господом, и кога избере Господ онај ће бити свет. Доста нек вам је, синови Левијеви! ");
INSERT INTO srp1868_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","И рече Мојсије Кореју: Чујте синови Левијеви! ");
INSERT INTO srp1868_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Мало ли вам је што вас је Бог Израиљев одвојио од збора Израиљевог пустивши вас к себи да вршите службу у шатору Господњем и да стојите пред збором и служите за њ? ");
INSERT INTO srp1868_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Пустио је к себи тебе и сву браћу твоју, синове Левијеве, с тобом, а ви тражите још и свештенство? ");
INSERT INTO srp1868_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Зато ти и сва дружина твоја скупите се на Господа. Јер Арон шта је да вичете на њ? ");
INSERT INTO srp1868_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","И посла Мојсије да дозову Датана и Авирона, синове Елијавове. А они одговорише: Нећемо да идемо. ");
INSERT INTO srp1868_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Мало ли је што си нас извео из земље у којој тече млеко и мед да нас побијеш у овој пустињи, него још хоћеш да владаш над нама? ");
INSERT INTO srp1868_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Јеси ли нас одвео у земљу где тече млеко и мед? И јеси ли нам дао да имамо њиве и винограде? Хоћеш ли очи овим људима да ископаш? Нећемо да идемо. ");
INSERT INTO srp1868_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Тада се расрди Мојсије врло, и рече Господу: Немој погледати на дар њихов; ниједног магарца нисам узео од њих, нити сам коме од њих учинио какво зло. ");
INSERT INTO srp1868_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Потом рече Мојсије Кореју: Ти и сви твоји станите сутра пред Господом, ти и они и Арон. ");
INSERT INTO srp1868_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","И узмите сваки своју кадионицу, и метните у њих када, и станите пред Господом сваки са својом кадионицом, двеста и педесет кадионица, и ти и Арон, сваки са својом кадионицом. ");
INSERT INTO srp1868_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","И узеше сваки своју кадионицу, и метнувши у њих огња метнуше у њих када, и стадоше на врата шатора од састанка с Мојсијем и Ароном. ");
INSERT INTO srp1868_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","А Кореј сабра на њих сав збор на врата шатора од састанка; тада се показа слава Господња свему збору. ");
INSERT INTO srp1868_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","И рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Одвојте се из тог збора, да их одмах сатрем. ");
INSERT INTO srp1868_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","А они падоше ничице и рекоше: Боже, Боже духовима и сваком телу! Овај један згрешио, и на сав ли ћеш се збор гневити? ");
INSERT INTO srp1868_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Реци збору и кажи: Одступите од шатора Корејевог и Датановог и Авироновог. ");
INSERT INTO srp1868_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","И уставши Мојсије отиде к Датану и Авирону, а за њим отидоше старешине Израиљеве. ");
INSERT INTO srp1868_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","И рече збору говорећи: Одступите од шатора тих безбожника, и не додевајте се ничег што је њихово, да не изгинете са свих греха њихових. ");
INSERT INTO srp1868_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","И одступише са свих страна од шатора Корејевог и Датановог И Авироновог; а Датан и Авирон изашавши стадоше сваки на врата од шатора свог са женама својим и са синовима својим и с децом својом. ");
INSERT INTO srp1868_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Тада рече Мојсије: Овако ћете познати да ме је Господ послао да чиним сва ова дела, и да ништа не чиним од себе: ");
INSERT INTO srp1868_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ако ови помру као што мру сви људи, и ако буду покарани као што бивају покарани сви људи, није ме послао Господ; ");
INSERT INTO srp1868_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ако ли шта ново учини Господ, и земља отвори уста своја и прождре их са свим што је њихово, и сиђу живи у гроб, тада знајте да су ови људи увредили Господа. ");
INSERT INTO srp1868_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","А кад изговори речи ове, раседе се земља под њима, ");
INSERT INTO srp1868_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","и отворивши земља уста своја прождре их, и домове њихове и све људе Корејеве и све благо њихово. ");
INSERT INTO srp1868_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","И тако сиђоше са свим што имаху живи у гроб, и покри их земља и неста их из збора. ");
INSERT INTO srp1868_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","А сви Израиљци који беху око њих побегоше од вике њихове, јер говораху: Да нас не прождре земља. ");
INSERT INTO srp1868_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","И изађе огањ од Господа, и сажеже оних двеста и педесет људи који принесоше кад. ");
INSERT INTO srp1868_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Тада рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Кажи Елеазару, сину Арона свештеника нека покупи кадионице из тог гаришта, и угљевље из њих нека разбаци, јер су свете; ");
INSERT INTO srp1868_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","кадионице оних који огрешише душе своје нека раскују на плоче да се окује олтар, јер кадише њима пред Господом, зато су свете, и нека буду синовима Израиљевим знак. ");
INSERT INTO srp1868_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","И покупи Елеазар свештеник кадионице бронзане, којима беху кадили они што изгореше, и расковаше их на оков олтару ");
INSERT INTO srp1868_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","за спомен синовима Израиљевим, да не приступа нико други који није рода Ароновог да кади пред Господом, да му не буде као Кореју и дружини његовој, као што му беше казао Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","А сутрадан викаше сав збор синова Израиљевих на Мојсија и на Арона говорећи: Побисте народ Господњи. ");
INSERT INTO srp1868_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","А кад се стецаше народ на Мојсија и на Арона, погледаше на шатор од састанка, а то облак на њему, и показа се слава Господња. ");
INSERT INTO srp1868_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","И дође Мојсије и Арон пред шатор од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Уклоните се из тог збора да их одмах потрем. А они падоше ничице. ");
INSERT INTO srp1868_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","И рече Мојсије Арону: Узми кадионицу, и метни у њу огња с олтара, и метни када, и иди брже ка збору, и очисти их; јер гнев жесток изађе од Господа, и помор поче. ");
INSERT INTO srp1868_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","И узевши Арон кадионицу, као што му рече Мојсије, отрча усред збора, и гле, помор већ беше почео у народу; и окадив очисти народ. ");
INSERT INTO srp1868_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","И стајаше међу мртвима и живима, и устави се помор. ");
INSERT INTO srp1868_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","А оних који помреше од тог помора беше четрнаест хиљада и седам стотина, осим оних што изгибоше с Кореја. ");
INSERT INTO srp1868_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","И врати се Арон к Мојсију на врата шатора од састанка, кад се устави помор. ");
INSERT INTO srp1868_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Потом рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Реци синовима Израиљевим, и узми од њих по једну палицу од сваког дома отаца њихових, од свих кнезова њихових, по домовима отаца њихових, дванаест палица, и име сваког напиши на палици његовој. ");
INSERT INTO srp1868_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","А на палици Левијевој напиши име Ароново, јер је свака палица за једног поглавара од дома отаца њихових. ");
INSERT INTO srp1868_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","И остави их у шатору од састанка пред сведочанством, где се састајем с вама. ");
INSERT INTO srp1868_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","И кога изаберем, његова ће палица процветати; тако ћу утишати пред собом вику синова Израиљевих што вичу на вас. ");
INSERT INTO srp1868_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Кад то рече Мојсије синовима Израиљевим, дадоше му сви кнезови њихови палице, сваки кнез по палицу од дома оца свог, дванаест палица, и палица Аронова беше међу палицама њиховим. ");
INSERT INTO srp1868_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","И остави Мојсије палице пред Господом у шатору од сведочанства. ");
INSERT INTO srp1868_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","А сутрадан дође Мојсије у шатор од сведочанства, и гле, процветала палица Аронова од дома Левијевог; беше напупила и цветала, и бадеми зрели на њој. ");
INSERT INTO srp1868_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","И изнесе Мојсије све оне палице испред Господа к свим синовима Израиљевим, и разгледавши их узеше сваки своју палицу. ");
INSERT INTO srp1868_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","А Господ рече Мојсију: Донеси опет палицу Аронову пред сведочанство да се чува за знак непокорнима, да престане вика њихова на ме, да не изгину. ");
INSERT INTO srp1868_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","И учини Мојсије, како му заповеди Господ тако учини. ");
INSERT INTO srp1868_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Тада рекоше синови Израиљеви Мојсију говорећи: Помресмо, пропадосмо, сви пропадосмо. ");
INSERT INTO srp1868_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ко се год приближи к шатору Господњем гине; хоћемо ли сви изгинути? ");
INSERT INTO srp1868_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","А Господ рече Арону: Ти и синови твоји и дом оца твог с тобом носите грехе у светињу; ти и синови твоји с тобом носите грехе свештенства свог. ");
INSERT INTO srp1868_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","И браћу своју, племе Левијево, племе оца свог узми к себи да буду уза те и служе ти; а ти ћеш и синови твоји с тобом служити пред шатором од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Нека добро слушају заповести твоје и раде шта треба у свем шатору; али к судовима од светиње к олтару нека не приступају, да не изгину и они и ви. ");
INSERT INTO srp1868_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Нека буду, дакле, уза те и нека раде све што треба у шатору од састанка у свакој служби у њему; али нико други да не приступи с вама. ");
INSERT INTO srp1868_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","А ви радите шта треба у светињи и шта треба на олтару, да више не дође гнев на синове Израиљеве. ");
INSERT INTO srp1868_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Јер ево, ја узех браћу вашу Левите између синова Израиљевих, и вама су дани на дар за Господа, да врше службу у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","А ти и синови твоји с тобом вршите свештеничку службу своју у свему што припада к олтару и шта бива иза завеса, и служите; свештенство даровах вам, зато ко би други приступио, да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Још рече Господ Арону: Ево, дајем ти и приносе своје што се увис подижу, између свих ствари које посвећују синови Израиљеви дајем их теби ради помазања и синовима твојим законом вечним. ");
INSERT INTO srp1868_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","То нека је твоје од ствари посвећених, које се не сажижу; сваки принос њихов између свих дарова њихових и између свих приноса за грех и свих приноса за кривицу, које ми донесу, светиња над светињама да је твоја и синова твојих. ");
INSERT INTO srp1868_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","У светињи га једи, све мушкиње нека га једе, света ствар да ти је. ");
INSERT INTO srp1868_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Твоје су, дакле, жртве дарова њихових које се у вис подижу; и сваку жртву синова Израиљевих која се обрће теби дајем и синовима твојим и кћерима твојим с тобом законом вечним; ко је год чист у дому твом, нека једе. ");
INSERT INTO srp1868_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Најбоље од уља и најбоље од вина и жита, првине које дају Господу, теби дајем. ");
INSERT INTO srp1868_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Првине од свега што роди у земљи њиховој, које донесу Господу, твоје нека буду; ко је год чист у дому твом нека једе. ");
INSERT INTO srp1868_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Све заветовано Богу и Израиљу, твоје нека је. ");
INSERT INTO srp1868_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Шта год отвара материцу између сваког тела које приносе Господу, и између људи и између стоке, твоје да буде; али првенац човечји нека се откупљује; и првенац нечисте стоке нека се откупљује. ");
INSERT INTO srp1868_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","А откуп нека му буде кад буде од месеца дана по твојој цени пет сикала сребра, по сиклу светом; у њему је двадесет гера. ");
INSERT INTO srp1868_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","А првенца од краве или првенца од овце или првенца од козе не дај да се откупи; свете су ствари; крвљу њиховом покропи олтар, и сало њихово запали, да буде жртва огњена за мирис угодни Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","А месо од њих да је твоје, као груди што се обрћу и као плеће десно, да је твоје. ");
INSERT INTO srp1868_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Све приносе што се подижу од посвећених ствари, што приносе синови Израиљеви Господу, дајем теби и синовима твојим и кћерима твојим с тобом законом вечним; то ће бити завет осољен, вечан пред Господом теби и семену твом с тобом. ");
INSERT INTO srp1868_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Још рече Господ Арону: У земљи њиховој да немаш наследство, ни дела међу њима да немаш; ја сам део твој и твоје наследство међу синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","А синовима Левијевим ево дајем у наследство све десетке од Израиља за службу њихову што служе у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","А синови Израиљеви нека више не приступају к шатору од састанка, да се не огреше и не изгину. ");
INSERT INTO srp1868_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Него сами Левити нека служе службу у шатору од састанка, и они нека носе грех свој законом вечним од колена до колена, па да немају наследство међу синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Јер десетке синова Израиљевих, што ће доносити Господу на жртву што се подиже, дајем Левитима у наследство; тога ради рекох за њих; међу синовима Израиљевим да немају наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Реци Левитима и кажи им: Кад узмете од синова Израиљевих десетак који вам дадох од њих за наследство ваше, онда принесите од њега принос што се подиже Господу, десето од десетог. ");
INSERT INTO srp1868_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","И примиће вам се принос ваш као жито с гумна и као вино из каце. ");
INSERT INTO srp1868_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Тако и ви приносите принос што се подиже Господу од свих десетака својих, које ћете узимати од синова Израиљевих, и дајите од њих принос Господњи Арону свештенику. ");
INSERT INTO srp1868_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Од свега што вам се да приносите сваки принос што се подиже Господу, од свега што буде најбоље свети део. ");
INSERT INTO srp1868_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","И реци им: Кад принесете најбоље од тога, тада ће се примити Левитима као доходак од гумна и као доходак од каце. ");
INSERT INTO srp1868_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","А јести можете то на сваком месту и ви и породице ваше, јер вам је плата за службу вашу у шатору од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","И нећете зато навући на се греха, кад станете приносити шта је најбоље, и нећете оскврнити свете ствари синова Израиљевих, и нећете изгинути. ");
INSERT INTO srp1868_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Још рече Господ Мојсију и Арону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ово је уредба и закон што заповеди Господ говорећи: Реци синовима Израиљевим нека ти доведу јуницу црвену здраву, на којој нема мане, и која још није била у јарму; ");
INSERT INTO srp1868_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","и подајте је Елеазару свештенику, а он нека је изведе напоље из логора да је закољу пред њим. ");
INSERT INTO srp1868_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","И узевши Елеазар крви њене на прст свој нека покропи крвљу према шатору од састанка седам пута. ");
INSERT INTO srp1868_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Потом нека заповеди да се спали јуница пред његовим очима; кожу њену и месо њено и крв њену с балегом нека спале. ");
INSERT INTO srp1868_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","И свештеник узевши дрвета кедровог, исопа и црвца, нека баци у огањ где гори јуница. ");
INSERT INTO srp1868_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Потом нека опере хаљине своје и опере тело своје водом, па онда нека уђе у логор, и нека буде свештеник нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Тако и ко је спали, нека опере хаљине своје водом, и тело своје нека опере водом, и нека буде нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","А чист човек нека покупи пепео од јунице и изручи га иза логора на чисто место, да се чува збору синова Израиљевих за воду очишћења; то је жртва за грех. ");
INSERT INTO srp1868_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","И онај који покупи пепео од јунице нека опере хаљине своје, и нека буде нечист до вечера. То нека је синовима Израиљевим и дошљаку који се бави међу њима вечан закон. ");
INSERT INTO srp1868_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ко се дотакне мртвог тела човечијег, да је нечист седам дана. ");
INSERT INTO srp1868_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Он нека се очисти оном водом трећи дан и седми дан, и биће чист; ако ли се не очисти трећи дан и седми, неће бити чист. ");
INSERT INTO srp1868_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ко се дотакне мртвог тела човечијег па се не очисти, онај је оскрвнио шатор Господњи; зато да се истреби она душа из Израиља; јер није покропљен водом очишћења, зато је нечист, и нечистота је његова на њему. ");
INSERT INTO srp1868_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ово је закон кад човек умре у шатору: Ко год уђе у онај шатор и ко год буде у шатору, нечист да је седам дана; ");
INSERT INTO srp1868_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","и сваки суд откривен, који не буде добро заклопљен, нечист је. ");
INSERT INTO srp1868_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","И ко се год дотакне у пољу посеченог мачем или умрлог или кости човечије или гроба, нечист да је седам дана. ");
INSERT INTO srp1868_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","И нека за нечистог узму пепела од јунице спаљене за грех, и нека налију на њ воде живе у суд. ");
INSERT INTO srp1868_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Потом нека узме чист човек исопа и замочи у ону воду, и покропи њом шатор и све суде и људе који су у њему били; тако и оног који би се дотакао кости или човека посеченог или умрла или гроба. ");
INSERT INTO srp1868_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Чисти нечистог нека покропи трећи и седми дан; и кад га очисти седми дан, нека опере хаљине своје и себе нека опере водом, и биће чист увече. ");
INSERT INTO srp1868_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","А ко буде нечист па се не очисти, да се истреби она душа из збора; јер је светињу Господњу оскврнио, а није покропљен водом очишћења; нечист је. ");
INSERT INTO srp1868_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","И ово нека им је закон вечан: и који покропи водом очишћења, нека опере хаљине своје; и ко се год дотакне воде очишћења, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","И чега се год дотакне ко је нечист, да је нечисто; и ко се њега дотакне, да је нечист до вечера. ");
INSERT INTO srp1868_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","И синови Израиљеви, сав збор њихов, дођоше у пустињу синску првог месеца, и стаде народ у Кадису; и онде умре Марија, и би погребена онде. ");
INSERT INTO srp1868_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","А онде немаше збор воде, те се скупише на Мојсија и на Арона. ");
INSERT INTO srp1868_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","И свађаше се народ с Мојсијем, и говораху: Камо да смо помрли кад помреше браћа наша пред Господом! ");
INSERT INTO srp1868_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Зашто доведосте збор Господњи у ову пустињу да изгинемо овде и ми и стока наша? ");
INSERT INTO srp1868_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","И зашто нас изведосте из Мисира да нас доведете на ово зло место, где не роди ни жито ни смоква ни грожђе ни шипак, а ни воде нема за пиће? ");
INSERT INTO srp1868_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","И дође Мојсије и Арон испред збора на врата шатора од састанка, и падоше ничице; и показа им се слава Господња. ");
INSERT INTO srp1868_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Узми штап, и сазовите збор ти и Арон брат твој, и проговорите стени пред њима; те ће дати воду своју; тако ћеш им извести воду из стене, и напојићеш збор и стоку њихову. ");
INSERT INTO srp1868_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","И Мојсије узе штап испред Господа, како му заповеди Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","И сазваше Мојсије и Арон збор пред стену, и он им рече: Слушајте одметници! Хоћемо ли вам из ове стене извести воду? ");
INSERT INTO srp1868_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","И диже Мојсије руку своју и удари у стену штапом својим два пута, и изиђе вода многа, те се напоји народ и стока њихова. ");
INSERT INTO srp1868_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","А Господ рече Мојсију и Арону: Што ми не веровасте и не прослависте ме пред синовима Израиљевим, зато нећете одвести збора тог у земљу коју сам им дао. ");
INSERT INTO srp1868_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","То је вода од свађе, где се свађаше синови Израиљеви с Господом, и Он се прослави међу њима. ");
INSERT INTO srp1868_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Иза тога посла Мојсије посланике из Кадиса к цару едомском да му кажу: Овако каже брат твој Израиљ: Ти знаш све невоље које нас снађоше: ");
INSERT INTO srp1868_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Како наши оци сиђоше у Мисир, и бејасмо у Мисиру дуго времена, и како Мисирци зло чинише нама и оцима нашим; ");
INSERT INTO srp1868_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","и викасмо ка Господу, и Господ чу глас наш, и посла анђела, који нас изведе из Мисира; и ево смо у Кадису, граду на твојој међи. ");
INSERT INTO srp1868_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Пусти нас да прођемо кроз твоју земљу; нећемо ићи преко поља ни преко винограда, нити ћемо пити воде из ког студенца; ићи ћемо царским путем, нећемо свратити ни на десно ни налево док не пређемо међу твоју. ");
INSERT INTO srp1868_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","А Едом му одговори: Не иди преко моје земље, да не изиђем с мачем преда те. ");
INSERT INTO srp1868_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","А синови Израиљеви рекоше му: Ићи ћемо утреником, и ако се напијемо воде твоје, ми или стока наша, платићемо је; ништа више, само да пешице прођемо. ");
INSERT INTO srp1868_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","А он им одговори: Нећете проћи. И изиђе Едом пред њих с много народа и с великом силом. ");
INSERT INTO srp1868_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","И кад не хте Едом допустити Израиљу да приђе преко међе његове, Израиљ отиде од њега. ");
INSERT INTO srp1868_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","И кренувши се од Кадиса дођоше синови Израиљеви, сав збор њихов, ка гори Ору. ");
INSERT INTO srp1868_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","И Господ рече Мојсију и Арону на гори Ору код међе едомске говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Арон ваља да се прибере к роду свом, јер неће ући у земљу коју сам дао синовима Израиљевим, јер не послушасте заповести моје на води од свађе. ");
INSERT INTO srp1868_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Узми Арона и Елеазара сина његовог, и изведи их на гору Ор. ");
INSERT INTO srp1868_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","И свуци Арону хаљине његове и обуци их Елеазару сину његовом, па ће се Арон прибрати и умрети онде. ");
INSERT INTO srp1868_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","И учини Мојсије како заповеди Господ; и изиђоше на гору Ор пред свим збором. ");
INSERT INTO srp1868_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","И свуче Мојсије с Арона хаљине његове и обуче их Елеазару, сину његовом, и умре онде Арон наврх горе, а Мојсије и Елеазар сиђоше с горе. ");
INSERT INTO srp1868_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","А кад виде сав збор да умре Арон, плака сав дом Израиљев за Ароном тридесет дана. ");
INSERT INTO srp1868_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","А кад чу Хананеј, цар арадски, који живљаше на југу, да иде Израиљ путем којим идоше уходе, он се поби с њима и зароби их неколико. ");
INSERT INTO srp1868_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Тада се Израиљ заветова Господу и рече: Ако даш овај народ мени у руке, до темеља ћу раскопати градове њихове. ");
INSERT INTO srp1868_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","И услиши Господ глас Израиљев и даде му Хананеје, а он затре њих и градове њихове, и прозва оно место Орма. ");
INSERT INTO srp1868_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Потом пођоше од горе Ора к Црвеном мору обилазећи земљу едомску, и ослаби дух народу од пута. ");
INSERT INTO srp1868_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","И викаше народ на Бога и на Мојсија: Зашто нас изведосте из Мисира да изгинемо у овој пустињи? Јер нема ни хлеба ни воде, а овај се никакви хлеб већ огадио души нашој. ");
INSERT INTO srp1868_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","А Господ пусти на народ змије ватрене, које их уједаху, те помре много народа у Израиљу. ");
INSERT INTO srp1868_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Тада дође народ к Мојсију и рекоше: Згрешисмо што викасмо на Господа и на тебе; моли Бога нека уклони змије од нас. И Мојсије се помоли за народ. ");
INSERT INTO srp1868_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","И Господ рече Мојсију: Начини змију ватрену, и метни је на мотку, и кога уједе змија, нека погледа у њу, па ће оздравити. ");
INSERT INTO srp1868_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","И начини Мојсије змију од бронзе, и метну је на мотку, и кога год уједе змија он погледа у змију од бронзе, и оздрави. ");
INSERT INTO srp1868_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Потом пођоше синови Израиљеви, и стадоше у логор у Овоту. ");
INSERT INTO srp1868_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","И из Овота отишавши стадоше у логор на брдима аваримским у пустињи која је према моавској с истока. ");
INSERT INTO srp1868_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Оданде отишавши стадоше у логор у долини Зареду. ");
INSERT INTO srp1868_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","И одатле отишавши стадоше у логор на брду на Арнону, који је у пустињи и излази од међе аморејске. Јер је Арнон међа моавска између Моаваца и Аморејаца. ");
INSERT INTO srp1868_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Зато се каже у књизи о ратовима Господњим: На Вајева у Суфи и на потоке арнонске. ");
INSERT INTO srp1868_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Јер ти потоци, који допиру до места Ара, теку покрај међе моавске. ");
INSERT INTO srp1868_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","А отуда дођоше к Виру; то је студенац за који беше рекао Господ Мојсију: Скупи народ, и даћу им воде. ");
INSERT INTO srp1868_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Тада пева Израиљ песму ову: Дижи се, студенче; припевајте га; ");
INSERT INTO srp1868_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Студенче, који копаше кнезови, који ископаше поглавари народни с оним који постави закон, палицама својим. А из пустиње отидоше у Мантанаил, ");
INSERT INTO srp1868_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","а из Мантанаила, у Надил, а из Надила у Вамот, ");
INSERT INTO srp1868_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","а из Вамота у долину која је у пољу моавском код горе Фазге и гледа у пустињу. ");
INSERT INTO srp1868_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Тада посла Израиљ посланике к Сиону, цару аморејском говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Пусти да прођемо кроз твоју земљу, нећемо свртати ни у поље ни у виноград, нити ћемо пити воде из студенаца; ићи ћемо царским путем докле не пређемо међу твоју. ");
INSERT INTO srp1868_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Али не даде Сион Израиљу да прође кроз земљу његову, него сабра Сион сав народ свој, и изађе на Израиља у пустињу, и дође у Јасу, и поби се с Израиљем. ");
INSERT INTO srp1868_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Али га исече Израиљ оштрим мачем, и освоји земљу његову од Арона па до Јавока, до синова Амонових, јер тврда беше међа синова Амонових. ");
INSERT INTO srp1868_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","И узе Израиљ сва она места и насели се у свим градовима аморејским, у Есевону и у свим селима његовим. ");
INSERT INTO srp1868_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Јер Есевон беше град Сиона, цара аморејског, који беше први завојштио на цара моавског и беше му узео сву земљу његову до Арнона. ");
INSERT INTO srp1868_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Зато говоре у причи: Ходите у Есевон, да се сагради и подигне град Сионов. ");
INSERT INTO srp1868_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Јер огањ изађе из Есевона, пламен из града Сионовог, и спали Ар моавски и становнике на висини арнонској. ");
INSERT INTO srp1868_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Тешко теби, Моаве; пропао си, народе Хемосов; дао је синове своје који утекоше и кћери своје у ропство Сиону, цару аморејском. ");
INSERT INTO srp1868_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Али их пострељасмо, пропаде Есевон до Девона, и потрсмо их до Нофе, која допире до Медеве. ");
INSERT INTO srp1868_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","И тако живи Израиљ у земљи аморејској. ");
INSERT INTO srp1868_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Потом посла Мојсије да уходе Јазир, и узеше села око њега, и изагнаше Аморејце који беху онде. ");
INSERT INTO srp1868_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Потом обративши се пођоше у Васан; и изиђе Ог, цар васански пред њих, он и сав народ његов на бој у Едрајин. ");
INSERT INTO srp1868_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","А Господ рече Мојсију: Не бој га се; јер сам га дао у твоје руке и сав народ његов и земљу његову; и учини му како си учинио Сиону, цару Аморејском који живљаше у Есевону. ");
INSERT INTO srp1868_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","И побише га и синове његове и сав народ његов, да не оста ниједан, и освојише земљу његову. ");
INSERT INTO srp1868_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Одатле се подигоше синови Израиљеви, и стадоше у логор у пољу моавском с оне стране Јордана према Јерихону. ");
INSERT INTO srp1868_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","И виде Валак, син Сефоров све што учини Израиљ Амореју. ");
INSERT INTO srp1868_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","И уплаши се Моав од народа веома; јер га беше много, и притужи Моаву од синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Па рече Моав старешинама мадијанским: Сада ће ова множина појести све што је око нас као во траву у пољу. А Валак, син Сефоров беше у оно време цар моавски. ");
INSERT INTO srp1868_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","И посла посланике к Валаму, сину Веоровом у Фатуру, која је на реци у земљи народа његовог, говорећи: Ево народ изиђе из Мисира, ево прекрило је земљу, и стоји према мени. ");
INSERT INTO srp1868_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Него ходи, прокуни ми овај народ, јер је јачи од мене, е да бих му одолео и побио га или истерао из земље ове; јер знам, кога благословиш биће благословен, а кога прокунеш биће проклет. ");
INSERT INTO srp1868_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","И отидоше старешине моавске и старешине мадијанске носећи дарове за врачање; и дођоше к Валаму, и казаше му речи Валакове. ");
INSERT INTO srp1868_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","А он им рече: Останите овде ову ноћ, и одговорићу вам како ми Господ каже. И осташе кнезови моавски код Валама. ");
INSERT INTO srp1868_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","А Бог дође к Валаму и рече му: Какви су то људи код тебе? ");
INSERT INTO srp1868_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","И рече Валам Богу: Валак син Сефоров, цар моавски, посла их к мени говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Ево народ изиђе из Мисира и прекрили земљу; него ходи, прокуни ми га, е да бих га надбио и отерао га. ");
INSERT INTO srp1868_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","А Бог рече Валаму: Не иди с њима, нити куни тај народ, јер је благословен. ");
INSERT INTO srp1868_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","И ујутру уставши Валам рече кнезовима Валаковим; вратите се у своју земљу јер ми не да Бог да идем с вама. ");
INSERT INTO srp1868_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","И уставши кнезови моавски дођоше к Валаку, и рекоше: Не хте Валам поћи с нама. ");
INSERT INTO srp1868_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Тада опет посла Валак више кнезова и веће од првих. ");
INSERT INTO srp1868_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","И они дошавши к Валаму рекоше му: Овако вели Валак, син Сефоров: Немој се затезати, молим те, него дођи к мени. ");
INSERT INTO srp1868_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Јер ћу те добро даривати, и шта ми год кажеш чинићу; зато дођи, молим те, прокуни ми овај народ. ");
INSERT INTO srp1868_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","А Валам одговори и рече слугама Валаковим: Да ми да Валак кућу своју пуну сребра и злата, не бих могао преступити речи Господа Бога свог да учиним шта мало или велико. ");
INSERT INTO srp1868_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Али опет останите овде и ви ову ноћ да видим шта ће ми сада казати Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","И дође Бог ноћу к Валаму и рече му: Кад су дошли ти људи да те зову, устани, иди с њима, али шта ти кажем оно да чиниш. ");
INSERT INTO srp1868_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","А ујутру уставши Валам осамари магарицу своју, и пође с кнезовима моавским. ");
INSERT INTO srp1868_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Али се разгневи Бог што он пође; и стаде анђео Господњи на пут да му не да; а он сеђаше на магарици својој и имаше са собом два момка своја. ");
INSERT INTO srp1868_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","А кад магарица виде анђела Господњег где стоји на путу с голим мачем у руци, сврну магарица с пута и пође преко поља. А Валам је стаде бити да је врати на пут. ");
INSERT INTO srp1868_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","А анђео Господњи стаде на стазу међу виноградима, а беше зид и одовуд и одонуд. ");
INSERT INTO srp1868_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","И магарица видећи анђела Господњег приби се уз други зид, и притиште ногу Валамову о зид; а он је стаде опет бити. ");
INSERT INTO srp1868_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Потом анђео Господњи отиде даље, и стаде у теснацу, где не беше места да се сврне ни надесно ни налево. ");
INSERT INTO srp1868_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","И магарица видећи анђела Господњег паде под Валамом, а Валам се врло разљути, и стаде бити магарицу својим штапом. ");
INSERT INTO srp1868_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Тада Господ отвори уста магарици, те она рече Валаму: Шта сам ти учинила, те ме бијеш већ трећи пут? ");
INSERT INTO srp1868_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","А Валам рече магарици: Што ми пркосиш? Да имам мач у руци, сад бих те убио. ");
INSERT INTO srp1868_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","А магарица рече Валаму: Нисам ли твоја магарица? Јашеш ме од како сам постала твоја до данас; јесам ли ти кад тако учинила? А он рече: Ниси. ");
INSERT INTO srp1868_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Тада Господ отвори очи Валаму, који угледа анђела Господњег где стоји на путу с голим мачем у руци. И он сави главу и поклони се лицем својим. ");
INSERT INTO srp1868_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","И рече му анђео Господњи: Зашто си био магарицу своју већ три пута? Ево ја изиђох да ти не дам, јер твој пут није мени по вољи. ");
INSERT INTO srp1868_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Кад ме угледа магарица, она се уклони испред мене већ три пута; а да се није уклонила испред мене, тебе бих већ убио, а њу бих оставио у животу. ");
INSERT INTO srp1868_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","А Валам рече анђелу Господњем: Згрешио сам, јер нисам знао да ти стојиш преда мном на путу; ако теби није по вољи, ја ћу се вратити. ");
INSERT INTO srp1868_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","А анђео Господњи рече Валаму: Иди с тим људима, али само оно говори што ти ја кажем. Тада Валам отиде с кнезовима Валаковим. ");
INSERT INTO srp1868_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","А кад чу Валак да иде Валам, изиђе му на сусрет у град моавски на међи арнонској накрај међе. ");
INSERT INTO srp1868_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","И рече Валак Валаму: Нисам ли слао к теби и звао те? Зашто ми не дође? Еда ли те не могу даривати? ");
INSERT INTO srp1868_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","А Валам рече Валаку: Ево сам дошао к теби; али хоћу ли моћи шта говорити? Шта ми Бог метне у уста, оно ћу говорити. ");
INSERT INTO srp1868_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","И отиде Валам с Валаком, и дођоше у град Узот. ");
INSERT INTO srp1868_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","И накла Валак волова и оваца, и посла Валаму и кнезовима, који беху с њим. ");
INSERT INTO srp1868_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","А ујутру узе Валак Валама и одведе га на висину Валову, и оданде му показа један крај народа. ");
INSERT INTO srp1868_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","И рече Валам Валаку: Начини ми овде седам олтара, и приправи ми овде седам телаца и седам овнова. ");
INSERT INTO srp1868_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","И учини Валак како му рече Валам; и принесе Валак с Валамом на сваком олтару по једно теле и овна. ");
INSERT INTO srp1868_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Па рече Валам Валаку: Стој код своје жртве паљенице; а ја идем еда бих се срео с Господом, па шта ми јави казаћу ти. И он отиде сам. ");
INSERT INTO srp1868_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","И срете Бог Валама, а он му рече: Седам олтара спремних, и принесох по теле и овна на сваком олтару. ");
INSERT INTO srp1868_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","А Господ метну речи у уста Валаму, и рече врати се к Валаку и тако му реци. ");
INSERT INTO srp1868_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","И врати се к њему, а он стајаше код жртве своје паљенице и сви кнезови моавски. ");
INSERT INTO srp1868_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","А он отвори причу своју, и рече: Из Арама доведе ме Валак, цар моавски с планине источне, говорећи: Ходи, прокуни ми Јакова, ходи, наружи Израиља. ");
INSERT INTO srp1868_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Како бих клео оног кога не куне Бог? Или како бих ружио оног кога Господ не ружи? ");
INSERT INTO srp1868_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Јер сврх стена видим га, и с хумова гледам га. Гле, овај ће народ наставати сам, и с другим народима неће се помешати. ");
INSERT INTO srp1868_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ко ће избројати прах Јаковљев и број од четврти Израиља? Да бих ја умро смрћу праведничком, и крај мој да би био као њихов! ");
INSERT INTO srp1868_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Тада рече Валак Валаму: Шта то радиш од мене? Ја те дозвах да прокунеш непријатеље моје, а гле, ти благосиљаш једнако. ");
INSERT INTO srp1868_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","А он одговори и рече: Зар нећу пазити и говорити оно што ми је Господ метнуо у уста? ");
INSERT INTO srp1868_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Тада му рече Валак: Ходи са мном на друго место, одакле ћеш га видети; само му крај видиш, а свега га не видиш; прокуни ми га оданде. ");
INSERT INTO srp1868_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","И доведе га у поље Зофим, наврх Фазге, и начини седам олтара, и принесе на сваком олтару по једно теле и овна. ");
INSERT INTO srp1868_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Тада Валам рече Валаку: Стој ту код жртве своје паљенице, а ја идем онамо на сусрет Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","И срете Господ Валама, и метну му реч у уста, и рече: Врати се к Валаку, и тако говори. ");
INSERT INTO srp1868_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","И дође к њему, а он стајаше код жртве своје паљенице и с њим кнезови моавски; и рече Валак: Шта вели Господ? ");
INSERT INTO srp1868_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","А он отвори причу своју, и рече: Устани Валаче, и послушај, чуј ме сине Сефоров! ");
INSERT INTO srp1868_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Бог није човек да лаже, ни син човечји да се покаје. Шта каже неће ли учинити, и шта рече неће ли извршити? ");
INSERT INTO srp1868_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Гле, примих да благословим; јер је Он благословио, а ја нећу порећи. ");
INSERT INTO srp1868_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Не гледа на безакоње у Јакову ни на неваљалство у Израиљу; Господ је његов с њим, и граја у њему као цар кад надвлада. ");
INSERT INTO srp1868_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Бог га је извео из Мисира, Он му је као снага једнорогова. ");
INSERT INTO srp1868_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Јер нема чини на Јакова ни врачања на Израиља; у ово доба говориће се о Јакову и о Израиљу, што је учинио Бог. ");
INSERT INTO srp1868_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ево, народ ће устати као силан лав, и као лавић скочиће; неће лећи докле не поједе лов и попије крв побијених. ");
INSERT INTO srp1868_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Тада рече Валак Валаму: Немој га ни клети ни благосиљати. ");
INSERT INTO srp1868_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","А Валам одговори Валаку: Нисам ли ти казао да ћу чинити шта ми год Господ каже? ");
INSERT INTO srp1868_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","А Валак рече Валаму: Ходи, одвешћу те на друго место; да ако Богу буде воља да ми га оданде прокунеш. ");
INSERT INTO srp1868_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","И одведе Валак Валама наврх Фегора, који гледа у пустињу. ");
INSERT INTO srp1868_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","И рече Валам Валаку: Начини ми овде седам олтара, и приправи ми овде седам телаца и седам овнова. ");
INSERT INTO srp1868_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","И учини Валак како рече Валам и принесе жртву по теле и овна на сваком олтару. ");
INSERT INTO srp1868_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","И видевши Валам да је Божја воља да благосиља Израиља, не хте више ни ићи као пре по врачање, него се окрете лицем к пустињи, ");
INSERT INTO srp1868_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","и подигавши очи своје угледа Израиља где стоји по племенима својим; и дух Божји дође на њ. ");
INSERT INTO srp1868_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","И отвори причу своју, и рече: Каже Валам, син Веоров; каже човек коме су отворене очи. ");
INSERT INTO srp1868_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Каже онај који чује речи Божје, који види утвару Свемогућег, који кад падне отворене су му очи: ");
INSERT INTO srp1868_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Како су лепи шатори твоји, Јакове, и колибе твоје, Израиљу! ");
INSERT INTO srp1868_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Пружили су се као потоци, као вртови крај реке, као мирисава дрвета која је посадио Господ, као кедри на води. ");
INSERT INTO srp1868_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Потећи ће вода из ведра његовог, и семе ће његово бити међу великим водама, и цар ће се његов подигнути сврх Агага, и царство ће се његово узвисити. ");
INSERT INTO srp1868_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Бог га је извео из Мисира, и Он му је као снага једнорогова; појешће народе који су му непријатељи, и кости ће његове потрти, и стрелама својим пострељати их. ");
INSERT INTO srp1868_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Спустио се, лежи као лавић и као љути лав; ко ће га пробудити? Ко тебе благосиља, биће благословен; а ко тебе куне, биће проклет. ");
INSERT INTO srp1868_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Тада се разгневи Валак на Валама, и пљесну се рукама, и рече Валак Валаму: Дозвах те да прокунеш непријатеље моје, а ти си их благословио ето већ три пута. ");
INSERT INTO srp1868_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Одлази у своје место; рекох да ћу те даривати, а ето Господ не да ти дара, ");
INSERT INTO srp1868_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","а Валам рече Валаку: Нисам ли и посланицима твојим које си послао к мени рекао говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Да ми да Валак кућу своју пуну сребра и злата, не бих могао преступити речи Господње да учиним шта добро или зло од себе; шта каже Господ оно ћу казати. ");
INSERT INTO srp1868_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ја сада ево идем к народу свом, али да ти кажем шта ће тај народ учинити народу твом најпосле. ");
INSERT INTO srp1868_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Потом отвори причу своју, и рече: Каже Валам син Веоров, каже човек коме су отворене очи, ");
INSERT INTO srp1868_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Каже који чује речи Божје, и зна знање о Вишњем, и који види утвару Свемогућег и кад падне отворене су му очи. ");
INSERT INTO srp1868_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Видим Га, али не сад; гледам Га, али не изблиза; изаћи ће звезда из Јакова и устаће палица из Израиља, која ће разбити кнезове моавске и разорити све синове Ситове. ");
INSERT INTO srp1868_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","И Едома ће освојити и Сира ће освојити непријатељи његови; јер ће Израиљ радити јуначки. ");
INSERT INTO srp1868_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","И владаће који је од Јакова, и затрће остатак од града. ");
INSERT INTO srp1868_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","А угледа Амалика, отвори причу своју, и рече: Амалик је почетак народима, али ће најпосле пропасти. ");
INSERT INTO srp1868_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","А угледавши Кенеја, отвори причу своју, и рече: Тврд ти је стан, и на стени си савио гнездо своје; ");
INSERT INTO srp1868_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Али ће бити изагнан Кенеј; Асур ће га заробити. ");
INSERT INTO srp1868_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","И опет отвори причу своју, и рече: Јаох! Ко ће бити жив кад то учини Бог! ");
INSERT INTO srp1868_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","И лађе из земље Китимске допловиће и досадиће Асирцима и досадиће Јеврејима; али ће и сами пропасти. ");
INSERT INTO srp1868_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Потом уставши Валам отиде, и врати се у своје место; и Валак отиде својим путем. ");
INSERT INTO srp1868_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","И живљаше Израиљ у Ситиму, и народ стаде чинити прељубу са кћерима моавским. ");
INSERT INTO srp1868_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Оне позиваху народ на жртве својих богова, и народ јеђаше, и клањаше се боговима њиховим. ");
INSERT INTO srp1868_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","И Израиљ приону уз Велфегора; и разгневи се Господ на Израиља. ");
INSERT INTO srp1868_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","И рече Господ Мојсију: Узми све кнезове народне, и обеси их Господу према сунцу, да се одврати гнев Господњи од Израиља. ");
INSERT INTO srp1868_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","И рече Мојсије судијама Израиљевим: Побијте сваки своје који су прионули уз Велфегора. ");
INSERT INTO srp1868_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","И гле, један између синова Израиљевих дође и доведе к браћи својој једну Мадијанку на очи Мојсију и на очи свему збору синова Израиљевих; а они заплакаше на вратима шатора од састанка. ");
INSERT INTO srp1868_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","А кад то виде Финес, син Елеазара сина Арона свештеника, уста исред збора и узе копље у руку; ");
INSERT INTO srp1868_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","и уђе за човеком Израиљцем у шатор, и прободе их обоје, човека Израиљца и ону жену, кроз трбух, и преста погибија међу синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","И изгибе их од те погибије двадесет и четири хиљаде. ");
INSERT INTO srp1868_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Тада рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Финес, син Елеазара сина Арона свештеника одврати гнев мој од синова Израиљевих отворивши ревност за ме међу њима, да не бих истребио синове Израиљеве у ревности својој. ");
INSERT INTO srp1868_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Зато му кажи: Ево дајем му свој завет мирни. ");
INSERT INTO srp1868_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","И имаће он и семе његово након њега завет свештенства вечног, јер ревнова за Бога свог и очисти синове Израиљеве. ");
INSERT INTO srp1868_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","А човеку Израиљцу убијеном, који би убијен с Мадијанком, беше име Замрије, син Салманов, кнез од дома оца свог од племена Симеуновог. ");
INSERT INTO srp1868_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","А убијеној жени Мадијани беше име Хазвија, кћи Сура кнеза народног у дому оца свог међу Мадијанима. ");
INSERT INTO srp1868_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","И рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Завојштите на Мадијане, и бијте их; ");
INSERT INTO srp1868_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","јер они завојштише на вас преварама својим, и претворише вас Велфегором и Хазвијом кћерју кнеза мадијанског, сестром својом, која би убијена у дан погибије која дође с Фегора. ");
INSERT INTO srp1868_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","А после те погибије рече Господ Мојсију и Елеазару, сину Ароновом свештенику говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Избројте сав збор синова Израиљевих од двадесет година и више по домовима отаца њихових, све који могу ићи на војску у Израиљу. ");
INSERT INTO srp1868_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","И рече им Мојсије и Елеазар свештеник у пољу моавском на Јордану према Јерихону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Да се изброје од двадесет година и више, како заповеди Господ Мојсију и синовима Израиљевим, који изађоше из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Рувим беше првенац Израиљев; а синови Рувимови: од Еноха породица Енохова; од Фалуја породица Фалујева; ");
INSERT INTO srp1868_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","од Асрона породица Асронова, од Хармије породица Хармијина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","То су породице Рувимове; а избројаних беше међу њима четрдесет и три хиљаде и седам стотина и тридесет. ");
INSERT INTO srp1868_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Син Фалујев беше Елијав. ");
INSERT INTO srp1868_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","А синови Елијавови: Намуило и Датан и Авирон. Овај Датан и овај Авирон који беху од оних што се сазиваху на збор, усташе на Мојсија и Арона у буни Корејевој, кад беше буна на Господа; ");
INSERT INTO srp1868_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","и земља отворивши уста своја прождре њих и Кореја, и изгибе та гомила, и спали их огањ двеста и педесет људи, који посташе углед. ");
INSERT INTO srp1868_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","А синови Корејеви не погибоше. ");
INSERT INTO srp1868_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Синови Симеунови по породицама својим: од Намуила породица Намуилова; од Јамина породица Јаминова; од Јахина породица Јахинова; ");
INSERT INTO srp1868_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","од Заре породица Зарина, од Саула породица Саулова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","То су породице Симеунове; од њих беше двадесет и две хиљаде и две стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","А синови Гадови по породицама својим: од Сифона породица Сифонова; од Агија породица Агијева; од Сунија и породица Сунијева; ");
INSERT INTO srp1868_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","од Азена породица Азенова; од Ирија породица Иријева; ");
INSERT INTO srp1868_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","од Арода породица Ародова; од Арилија породица Арилијева. ");
INSERT INTO srp1868_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","То су породице синова Гадових, а међу њима беше избројаних четрдесет хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Синови Јудини: Ир и Авнан; али умреше Ир и Авнан у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Беху, пак, синови Јудини по породицама својим: од Силома породица Силомова; од Фареса породица Фаресова; од Заре породица Зарина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","А синови Фаресови беху: од Асрона породица Асронова; од Јамуила породица Јамуилова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","То су породице Јудине, а међу њима беше избројаних седамдесет и шест хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","А синови Исахарови по породицама својим: од Толе породица Толина; од Фуве породица Фувина; ");
INSERT INTO srp1868_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","од Јасува породица Јасувова; од Амрама породица Амрамова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","То су породице Исахарове; а међу њима беше избројаних шездесет и четири хиљаде и три стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Синови Завулонови по породицама својим: од Сареда породица Саредова, од Алона породица Алонова, од Алила породица Алилова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","То су породице Завулонове, а међу њима беше избројаних шездесет хиљада и пет стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Синови Јосифови по породицама својим: Манасија и Јефрем; ");
INSERT INTO srp1868_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","синови Манасијини: од Махира породица Махирова, а Махир роди Галада, од ког је породица Галадова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ово су синови Галадови; од Ахијезера породица Ахијезерова; од Хелека породица Хелекова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Од Есрила породица Есрилова, од Сихема породица Сихемова; ");
INSERT INTO srp1868_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","од Симаера породица Симаерова; од Офера породица Оферова; ");
INSERT INTO srp1868_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","а Салпад син Оферов немаше синове него кћери, којима су имена Мала и Нуја и Егла и Мелха и Терса. ");
INSERT INTO srp1868_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","То су породице Манасијине, а од њих беше избројаних педесет и две хиљаде и седам стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Синови, пак, Јефремови по породицама својим: од Сутала породица Суталова; од Вехера породица Вехерова; од Тахана породица Таханова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","А ово су синови Суталови: од Ерана породица Еранова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","То су породице синова Јефремових; а међу њима беше избројаних тридесет и две хиљаде и пет стотина. То су синови Јосифови по породицама својим. ");
INSERT INTO srp1868_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","А синови Венијаминови по породицама својим: од Веле породица Велина; од Асвила породица Асвилова; од Ахирама породица Ахирамова; ");
INSERT INTO srp1868_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","од Суфама породица Суфамова; од Уфама породица Уфамова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","А Велини синови беху: Адер и Наман; од Адера породица Адерова; од Намана породица Наманова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","То су синови Венијаминови по породицама својим, а међу њима беше избројаних четрдесет и пет хиљада и шест стотина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","А ово су синови Данови по породицама својим: од Самеја породица Самејева; то је род Данов по породицама својим. ");
INSERT INTO srp1868_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","У свим породицама Самејевим беше избројаних шездесет и четири хиљаде и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Синови Асирови по породицама својим: од Јамина породица Јаминова; од Јесуја породица Јесујева: од Верија породица Веријина. ");
INSERT INTO srp1868_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Синови Веријини: од Ховера породица Ховерова; од Мелхила породица Мелхилова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","А кћери Асировој беше име Сара. ");
INSERT INTO srp1868_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","То су породице синова Асирових; а међу њима беше избројаних педесет и три хиљаде и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Синови Нефталимови по породицама својим: од Асила породица Асилова; од Гунија породица Гунијева. ");
INSERT INTO srp1868_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Од Јесера породица Јесерова; од Селима породица Селимова. ");
INSERT INTO srp1868_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","То је род Нефталимов по породицама својим, а међу њима беше избројаних четрдесет и пет хиљада и четири стотине. ");
INSERT INTO srp1868_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","То су избројани међу синовима Израиљевим, шест стотина и једна хиљада и седам стотина и тридесет. ");
INSERT INTO srp1868_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","А Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Тим нека се подели земља у наследство према броју имена; ");
INSERT INTO srp1868_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","којих има више, подај им веће наследство, а којих има мање, њима мање; сви према броју избројаних својих нека имају наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Али жребом нека се подели земља: по именима племена отаца својих нека добију наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ждребом нека се подели свакоме племену, било велико или мало. ");
INSERT INTO srp1868_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","А ово су избројани између Левита по породицама својим: од Гирсона породица Гирсонова; од Ката породица Катова; од Мерарија породица Мераријева. ");
INSERT INTO srp1868_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ово су породице Левијеве: породица Ловенијева, породица Хевронова, породица Мелијева, породица Мусијева, породица Корејева. А Кат је родео Амрама. ");
INSERT INTO srp1868_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","А име је жени Амрамовој Јохаведа, кћи Левијева, која му се родила у Мисиру; а она роди Амраму Арона и Мојсија, и Марију сестру њихову. ");
INSERT INTO srp1868_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","А Арону се роди Надав и Авијуд и Елеазар и Итамар. ");
INSERT INTO srp1868_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Али Надав и Авијуд погибоше кад принесоше туђ огањ пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","И беше их избројаних двадесет и три хиљаде, свега мушкиња од једног месеца и више; и не бише бројани међу синове Израиљеве, јер им није дано наследство међу синовима Израиљевим ");
INSERT INTO srp1868_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","То су избројани, кад Мојсије и Елеазар свештеник избројаше синове Израиљеве у пољу моавском на Јордану према Јерихону. ");
INSERT INTO srp1868_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","А међу њима не беше ниједан од оних које избројаше Мојсије и Арон, свештеник, кад бројаше синове Израиљеве у пустињи синајској. ");
INSERT INTO srp1868_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Јер Господ беше рекао за њих: Помреће у пустињи. И не оста их ни један осим Халева, сина Јефонијиног и Исуса сина Навиног. ");
INSERT INTO srp1868_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Тада дођоше кћери Салпада, сина Офера сина Галада сина Махира сина Манасијиног, од племена Манасије сина Јосифовог, а имена им беху Мала, Нуја, Егла, Мелха и Терса. ");
INSERT INTO srp1868_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","И стадоше пред Мојсија и пред Елеазара свештеника и пед кнезове и сав збор на вратима шатора од састанка, и рекоше: ");
INSERT INTO srp1868_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Отац наш умре у пустињи, али не беше у друштву с онима који се побунише на Господа у буни Корејевој, него умре од греха свог, а не остави синове. ");
INSERT INTO srp1868_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Зашто да се истреби име оца нашег из породице његове зато што није имао сина? Дај нам наследство међу браћом оца нашег. ");
INSERT INTO srp1868_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","И изнесе Мојсије ствар њихову пред Господа. ");
INSERT INTO srp1868_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","А Господ рече Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Право говоре, кћери Салпадове; подај им право да имају наследство међу браћом оца свог, и принеси наследство оца њиховог на њих. ");
INSERT INTO srp1868_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","А синовима Израиљевим кажи и реци: Кад ко умре, а нема сина, онда пренесите наследство његово на кћер његову; ");
INSERT INTO srp1868_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ако ли ни кћери нема, онда подајте наследство његово браћи његовој; ");
INSERT INTO srp1868_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ако ли ни браће нема, онда подајте наследство његово браћи оца његовог; ");
INSERT INTO srp1868_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ако ли нема ни браћу очеву, онда подајте наследство његово ономе ко му је најближи у роду његовом, и нека је његово. И то нека буде синовима Израиљевим закон за суђење, како заповеди Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Још рече Господ Мојсију: Изиђи на гору ову аваримску, и види земљу коју сам дао синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","И кад је видиш, прибраћеш се к роду свом и ти, као што се прибрао Арон, брат твој. ");
INSERT INTO srp1868_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Јер не послушасте речи моје у пустињи Сину у свађи народној, кад је требало да ме прославите на води пред очима њиховим. То је вода од свађе у Кадису у пустињи Сину. ");
INSERT INTO srp1868_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","И рече Мојсије Господу говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Господе Боже духовима и сваком телу, постави човека над овим збором, ");
INSERT INTO srp1868_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","који ће излазити пред њима и који ће долазити пред њима, који ће их изводити и опет доводити, да не би био збор Господњи као овце које немају пастира. ");
INSERT INTO srp1868_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","А Господ рече Мојсију: Узми к себи Исуса сина Навиног, човека у коме је дух мој, и метни руку своју на њ, ");
INSERT INTO srp1868_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","и изведи га пред Елеазара свештеника и пред сав збор, и подај му заповести пред њима. ");
INSERT INTO srp1868_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","И подај му од славе своје, да га слуша сав збор синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","И нека стаје пред Елеазара свештеника да га пита за суд Урим пред Господом; по заповести Његовој нека полазе и по заповести Његовој нека долазе он и сви синови Израиљеви с њим и сав збор. ");
INSERT INTO srp1868_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","И учини Мојсије како му заповеди Господ; и узевши Исуса постави га пред Елеазара свештеника и пред сав збор. ");
INSERT INTO srp1868_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","И метну руке своје на њ, и даде му заповести, како беше заповедио Господ преко Мојсија. ");
INSERT INTO srp1868_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Заповеди синовима Израиљевим, и реци им: Приносе моје, хлеб мој, жртве што ми се сажижу за угодни мирис, пазите да ми приносите на време. ");
INSERT INTO srp1868_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Реци им дакле: Ово је жртва огњена што ћете приносити Господу: два јагњета од године здрава, сваки дан на жртву паљеницу без престанка. ");
INSERT INTO srp1868_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Једно јагње принеси ујутру, а друго јагње принеси увече. ");
INSERT INTO srp1868_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","И десетину ефе белог брашна за дар смешаног с четвртином ина чистог уља. ");
INSERT INTO srp1868_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","То је жртва паљеница свагдашња, која би принесена на гори синајској за мирис угодни, жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","И налив њен да буде четврт ина на свако јагње; у светињи приноси налив доброг пића Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","А друго јагње принеси увече; дар као ујутру и налив његов принеси за жртву огњену, за угодни мирис Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","А у суботу два јагњета од године здрава, и две десетине белог брашна смешаног с уљем за дар с наливом његовим. ");
INSERT INTO srp1868_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","То је суботна жртва паљеница сваке суботе, осим свагдашње жртве паљенице и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","И у почетак месеца својих приносите Господу жртву паљеницу, по два телета и једног овна и седам јагањаца од године здравих; ");
INSERT INTO srp1868_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","и три десетине белог брашна помешаног с уљем за дар на свако теле, и две десетине белог брашна помешаног с уљем за дар на овна; ");
INSERT INTO srp1868_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","и по једну десетину белог брашна помешаног с уљем за дар на свако јагње; то је жртва паљеница на угодни мирис, жртва огњена Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","А налив њихов да буде вина по ина на теле, трећина ина на овна, и четврт ина на јагње. То је жртва паљеница у почетак месеца, сваког месеца у години. ");
INSERT INTO srp1868_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","И јарца једног за грех, осим свагдашње жртве паљенице, приносите Господу с наливом његовим. ");
INSERT INTO srp1868_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","А првог месеца четрнаести дан да је пасха Господу; ");
INSERT INTO srp1868_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","а петнаести дан тог месеца празник: седам дана једите пресне хлебове. ");
INSERT INTO srp1868_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Први дан нека је сабор свети; никакав посао ропски не радите. ");
INSERT INTO srp1868_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Него принесите Господу жртву паљеницу, два телета и једног овна и седам јагањаца од године, све да вам је здраво; ");
INSERT INTO srp1868_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","а дар уз њих белог брашна помешаног с уљем три десетине уза свако теле и две десетине уз овна принесите. ");
INSERT INTO srp1868_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","По једну десетину принесите уза свако јагње од оних седам јагањаца; ");
INSERT INTO srp1868_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","и једног јарца за грех, ради очишћења вашег. ");
INSERT INTO srp1868_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","То принесите осим јутарње жртве паљенице, која је жртва свагдашња. ");
INSERT INTO srp1868_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Тако приносите сваки дан за оних седам дана, да буде јело, жртва огњена на угодни мирис Господу, осим свагдашње жртве паљенице и њен налив приносите. ");
INSERT INTO srp1868_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","И седми дан да имате свети сабор; посао ропски ниједан не радите. ");
INSERT INTO srp1868_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","И на дан првина, кад приносите нов дар Господу после својих недеља, да имате сабор свети, ниједан посао ропски не радите; ");
INSERT INTO srp1868_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","него принесите жртву паљеницу за угодни мирис Господу, два телета, једног овна седам јагањаца од године; ");
INSERT INTO srp1868_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","и дар уз њих: белог брашна помешаног с уљем по три десетине уз теле, две десетине уз овна, ");
INSERT INTO srp1868_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","по једну десетину уза свако јагње од оних седам јагањаца; ");
INSERT INTO srp1868_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","једног јарца, ради очишћења вашег. ");
INSERT INTO srp1868_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Принесите то, осим свагдашње жртве паљенице и дара њеног; а све нека вам је здраво с наливом својим. ");
INSERT INTO srp1868_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","А седмог месеца први дан да имате свети сабор; посао ропски ниједан не радите; то да вам је трубни дан. ");
INSERT INTO srp1868_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","И принесите жртву паљеницу за мирис угодни Господу, једно теле, једног овна, седам јагањаца од године здравих; ");
INSERT INTO srp1868_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","а дар уз њих белог брашна смешаног с уљем три десетине уз теле и две десетине уз овна, ");
INSERT INTO srp1868_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","и по једну десетину уз свако јагње од седам јагањаца; ");
INSERT INTO srp1868_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","и једног јарца за грех, ради очишћења вашег; ");
INSERT INTO srp1868_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","осим жртве паљенице у почетку месеца и дара њеног, и осим свагдашње жртве паљенице и дара њеног и налива њихових по уредби њиховој, за мирис угодни, за жртву огњену Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","И десети дан тог месеца седмог да имате свети сабор; и мучите душе своје; не радите никакав посао; ");
INSERT INTO srp1868_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","него принесите Господу за мирис угодни жртву паљеницу, једно теле, једног овна, седам јагањаца од године, а нека вам је здраво; ");
INSERT INTO srp1868_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","и дар уз њих белог брашна помешаног с уљем три десетине уз теле, две десетине уз овна, ");
INSERT INTO srp1868_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","по једну десетину уза свако јагње од оних седам јагањаца; ");
INSERT INTO srp1868_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","јарца једног за грех, осим жртве за грех ради очишћења, и осим свагдашње жртве паљенице и дара њеног и налива њихових. ");
INSERT INTO srp1868_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","И петнаести дан тог месеца седмог да имате свети сабор; ниједан посао ропски не радите; него празнујте празник Господу седам дана. ");
INSERT INTO srp1868_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","И принесите жртву паљеницу, огњену жртву за угодни мирис Господу, тринаест телаца, два овна, четрнаест јагањаца од године, а нека су здрави; ");
INSERT INTO srp1868_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","и дар уз њих брашна белог смешана с уљем по три десетине уза свако теле од тринаест телаца, по две десетине уза сваког овна од она два овна, ");
INSERT INTO srp1868_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","и по једну десетину уза свако јагње од оних четрнаест јагањаца; ");
INSERT INTO srp1868_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","и једног јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","А други део дванаест телаца, два овна, четрнаест јагањаца од године здравих, ");
INSERT INTO srp1868_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","и дар њихов и налив њихов, уз теоце, уз овнове и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","и јарца једног за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","А трећи дан једанаест телаца, два овна и четрнаест јагањаца од године здравих; ");
INSERT INTO srp1868_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","и дарове њихове и наливе њихове, уз теоце, уз овнове и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","и једног јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","А четврти дан десет телаца, два овна, четрнаест јагањаца од године здравих; ");
INSERT INTO srp1868_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","и дар њихов и наливе њихове, уз теоце, уз овнове и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","и једног јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","А пети дан девет телаца, два овна, четрнаест јагањаца од године здравих; ");
INSERT INTO srp1868_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","и дар њихов и наливе њихове, уз теоце, уз овнове и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","и једног јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","А шести дан осам телаца, два овна, четрнаест јагањаца од године здравих, ");
INSERT INTO srp1868_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","и дар њихов и наливе њихове, уз теоце, уз овнове и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","и једног јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","А седми дан седам телаца, два овна, четрнаест јагањаца од године здравих, ");
INSERT INTO srp1868_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","и дар њихов и наливе њихове, уз теоце, уз овнове и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","и јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","А осми дан да вам је празник; ниједан посао ропски не радите. ");
INSERT INTO srp1868_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Него принесите жртву паљеницу, жртву огњену за угодни мирис Господу, једно теле, једног овна, седам јагањаца од године здравих. ");
INSERT INTO srp1868_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","И дар њихов и наливе њихове, уз теле, уз овна и уз јагањце, по броју њиховом, како је уређено; ");
INSERT INTO srp1868_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","и једног јарца за грех, осим свагдашње жртве паљенице и дара њеног и налива њеног. ");
INSERT INTO srp1868_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","То приносите Господу на празнике своје, осим оног што бисте по завету или од своје воље принели за жртве паљенице или дарове или наливе или жртве захвалне. ");
INSERT INTO srp1868_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","И каза Мојсије синовима Израиљевим све што заповеди Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","И рече Мојсије кнезовима од племена синова Израиљевих говорећи: Ово је заповедио Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Кад који човек учини завет Господу, или се закуне везавши се душом својом, нека не погази речи своје, него нека учини све што изађе из уста његових. ");
INSERT INTO srp1868_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","А кад жена учини завет Господу или се веже у младости својој, докле је у кући оца свог, ");
INSERT INTO srp1868_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","и чује отац њен за завет њен или како се везала душом својом, па јој отац не рече ништа, онда да су тврди сви завети њени, и све чим је везала душу своју да је тврдо. ");
INSERT INTO srp1868_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Ако ли отац њен порече то онај дан кад чује, завети њени и чим је год везала душу своју, ништа да није тврдо; и Господ ће јој опростити, јер отац њен порече. ");
INSERT INTO srp1868_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Ако ли се уда па има на себи завет или изрече шта на уста своја чим би се везала, ");
INSERT INTO srp1868_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","а муж њен чувши не рече јој ништа онај дан кад чује, онда да су тврди завети њени, и тврдо да је све чим је везала душу своју. ");
INSERT INTO srp1868_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Ако ли муж њен кад чује онај дан порече, укида се завет који је био на њој или што је изрекла на уста своја те се везала; и Господ ће јој опростити. ");
INSERT INTO srp1868_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","А завет који учини удовица или пуштеница, и све чим веже душу своју, да јој је тврдо. ");
INSERT INTO srp1868_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Али ако буде у кући мужа свог учинила завет и за шта везала душу своју заклетвом, ");
INSERT INTO srp1868_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","и муж њен чувши оћути и не порече, тада да су тврди сви завети њени, и да је тврдо све за шта је везала душу своју. ");
INSERT INTO srp1868_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ако ли то порече муж њен онај дан кад чује, сваки завет који би изашао из уста њених и све чим би везала душу своју да није тврдо; муж је њен порекао, и Господ ће јој опростити. ");
INSERT INTO srp1868_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Сваки завет и све за шта би се везала заклетвом да мучи душу своју, муж њен потврђује и укида. ");
INSERT INTO srp1868_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ако би муж њен од дана до дана ћутао, онда потврђује све завете њене и све за шта би се везала; потврђује, јер јој не порече у онај дан кад чу. ");
INSERT INTO srp1868_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ако ли порече пошто чује, сам ће носити грех њен. ");
INSERT INTO srp1868_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ово су наредбе, које заповеди Господ Мојсију за мужа и жену, за оца и кћер у младости њеној, докле је у кући оца свог. ");
INSERT INTO srp1868_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Освети синове Израиљеве на Мадијанима, па ћеш се онда прибрати к роду свом. ");
INSERT INTO srp1868_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","И Мојсије рече народу говорећи: Опремите између себе људе на војску да иду на Мадијане да учине освету Господњу на Мадијанима, ");
INSERT INTO srp1868_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","по хиљаду од племена, од сваког племена Израиљевог опремите на војску. ");
INSERT INTO srp1868_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","И дадоше од хиљада Израиљевих по хиљаду од сваког племена, дванаест хиљада опремише на војску. ");
INSERT INTO srp1868_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","И посла Мојсије по хиљаду од сваког племена на војску, и с њима Финеса, сина Елеазара свештеника, и у њега беху судови свети и трубе. ");
INSERT INTO srp1868_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","И завојштише на Мадијане, како заповеди Господ Мојсију, и побише све мушкиње. ");
INSERT INTO srp1868_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Побише и цареве мадијанске, с другима које им побише, Евина и Рокома и Сура и Ура и Ровока, пет царева мадијанских, и Валама сина Веоровог убише мачем. ");
INSERT INTO srp1868_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","И заробише синови Израиљеви жене Мадијанке и децу њихову, и запленише сву стоку њихову, крупну и ситну, и све благо њихово. ");
INSERT INTO srp1868_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","А места њихова у којима живљаху и градове њихове све попалише огњем. ");
INSERT INTO srp1868_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","И све робље и сав плен, људе и стоку, узеше; ");
INSERT INTO srp1868_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","и поведоше к Мојсију и Елеазару свештенику и ка збору синова Израиљевих, и робље и остали плен и добит у логор на пољу моавском, које је на Јордану према Јерихону. ");
INSERT INTO srp1868_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","А Мојсије и Елеазар свештеник и сви кнезови од збора изиђоше им на сусрет из логора. ");
INSERT INTO srp1868_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","И Мојсије се разгневи на војводе, на хиљаднике и стотинаре, који се враћаху с војске; ");
INSERT INTO srp1868_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","и рече им Мојсије: А што остависте у животу све жене? ");
INSERT INTO srp1868_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Та оне по речи Валамовој навратише синове Израиљеве да згреше Господу с Фегора, те дође она погибија на народ Господњи. ");
INSERT INTO srp1868_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Зато сада побијте сву децу мушку, и све жене побијте, које су познале човека. ");
INSERT INTO srp1868_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","А девојке, које не познаше човека, оставите у животу. ");
INSERT INTO srp1868_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","А ви останите изван логора седам дана; сваки који је убио кога и који се дотакао убијенога очистите се трећи дан и седми дан, себе и робље своје. ");
INSERT INTO srp1868_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","И све хаљине и све ствари кожне и све што је од кострети и све судове дрвене очистите. ");
INSERT INTO srp1868_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","И рече Елеазар свештеник војницима, који беху ишли на војску: Ово је наредба и закон што је Господ заповедио Мојсију: ");
INSERT INTO srp1868_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Злато, сребро, бронзу, гвожђе, коситер и олово, ");
INSERT INTO srp1868_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","шта год подноси ватру, пропустите кроз ватру, и очистиће се, али пошто се очисти водом очишћења; а шта год не подноси ватру, пропустите кроз воду. ");
INSERT INTO srp1868_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","И оперите хаљине своје седми дан, и бићете чисти; и онда ћете ући у логор. ");
INSERT INTO srp1868_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Изброј све што је заплењено, људе и стоку, ти и Елеазар свештеник и поглавари од племена народних. ");
INSERT INTO srp1868_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","И раздели све заплењено на двоје: на војнике који су ишли на војску и на сав збор. ");
INSERT INTO srp1868_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","И узми део за Господа од војника који су ишли на војску, по једну душу од педесет, и од људи и од говеда и од магараца и од оваца. ");
INSERT INTO srp1868_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Од њихове половине то узмите, и подајте Елеазару свештенику за принос Господу. ");
INSERT INTO srp1868_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","И од половине која допаде синовима Израиљевим узми по једно од педесет, и од људи и од говеда и од магараца и од оваца и од сваке стоке, и то подај Левитима који раде шта треба за шатор Господњи. ");
INSERT INTO srp1868_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","И учини Мојсије и Елеазар свештеник како заповеди Господ Мојсију. ");
INSERT INTO srp1868_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","И беше плена, што оста од плена који заплени војска: шест стотина и седамдесет и пет хиљада оваца, ");
INSERT INTO srp1868_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","и седамдесет и две хиљаде говеда, ");
INSERT INTO srp1868_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","и шездесет и једна хиљада магараца, ");
INSERT INTO srp1868_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","и женскиња што не беше познало човека, свега тридесет и две хиљаде душа. ");
INSERT INTO srp1868_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","А у половини, у делу оних који беху ишли на војску, беше на број три стотине и тридесет и седам хиљада и пет стотина оваца, ");
INSERT INTO srp1868_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","а од тога део Господу беше шест стотина и седамдесет и пет оваца: ");
INSERT INTO srp1868_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","И тридесет и шест хиљада говеда, а од тога део Господу седамдесет и два; ");
INSERT INTO srp1868_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","и тридесет хиљада и пет стотина магараца, а од тога део Господу шездесет и један; ");
INSERT INTO srp1868_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","и шеснаест хиљада душа људских, а од тога део Господу тридесет и две душе. ");
INSERT INTO srp1868_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","И даде Мојсије Елеазару свештенику део за принос Господу, као што му заповеди Господ. ");
INSERT INTO srp1868_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","А од друге половине, која допаде синовима Израиљевим, коју узе Мојсије од људи који беху ишли на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","а и у тој половини, која допаде збору, беше три стотине и тридесет и седам хиљада и пет стотина оваца, ");
INSERT INTO srp1868_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","тридесет и шест хиљада говеда, ");
INSERT INTO srp1868_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","тридесет хиљада и пет стотина магараца, ");
INSERT INTO srp1868_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","и шеснаест хиљада душа људских. ");
INSERT INTO srp1868_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Од те половине, која допаде синовима Израиљевим, узе Мојсије по једно од педесет, и од људи и од стоке, и даде Левитима који раде шта треба за шатор Господњи, као што му Господ заповеди. ");
INSERT INTO srp1868_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","И приступише к Мојсију војводе, хиљадници и стотинари, ");
INSERT INTO srp1868_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","и рекоше му: Слуге твоје пребројаше војнике који беху под нашом руком, и ниједног није мање. ");
INSERT INTO srp1868_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Зато приносимо Господу принос, сваки што је ко задобио, златних заклада, копача, наруквица, прстена, ободаца и ланчића, да би се очистиле душе наше пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","И узе Мојсије и Елеазар свештеник од њих злато, свакојаке закладе. ");
INSERT INTO srp1868_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","А беше свега злата принесеног, што принесоше Мојсију хиљадници и стотинари, шеснаест хиљада и седам стотина и педесет сикала. ");
INSERT INTO srp1868_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","А војници задржаше себи шта који беше запленио. ");
INSERT INTO srp1868_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","И узевши Мојсије и Елеазар злато од хиљадника и стотинара, унесоше га у шатор од састанка за спомен синовима Израиљевим пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","А синови Рувимови и синови Гадови имаху врло много стоке, и видеше земљу јазирску и земљу галадску да је добра за стоку. ");
INSERT INTO srp1868_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","И дошавши синови Гадови и синови Рувимови рекоше Мојсију и Елеазару свештенику и кнезовима од збора говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Атарот и Девон и Јазир и Намра и Есевон и Елеалија и Севама и Навав и Веан, ");
INSERT INTO srp1868_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","та је земља, коју Господ покори збору израиљском, добра за стоку, а слуге твоје имају стоке. ");
INSERT INTO srp1868_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ако смо, рекоше, нашли милост пред тобом, нека се та земља даде слугама твојим у наследство, немој нас водити преко Јордана. ");
INSERT INTO srp1868_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","А Мојсије рече синовима Гадовим и синовима Рувимовим: Браћа ће ваша ићи на војску, а ви хоћете овде да останете? ");
INSERT INTO srp1868_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Зашто обарате срце синовима Израиљевим да не пређу у земљу коју им је дао Господ? ");
INSERT INTO srp1868_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Тако су учинили оци ваши, кад их послах из Кадис-Варније да уходе земљу; ");
INSERT INTO srp1868_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","и отидоше до потока Есхола, и уходише земљу; и оборише срце синовима Израиљевим да не иду у земљу коју им даде Господ; ");
INSERT INTO srp1868_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","и разгневи се онда Господ, и закле се говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Неће ти људи који изађоше из Мисира, од двадесет година и више, видети земље за коју се заклех Авраму, Исаку и Јакову, јер се не држаше мене сасвим, ");
INSERT INTO srp1868_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","осим Халева, сина Јефонијиног Кенезеја и Исуса сина Навиног, јер се сасвим држаше Господа. ");
INSERT INTO srp1868_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","И разгневи се Господ на Израиља, и учини те се потуцаше по пустињи четрдесет година, докле не помре сав онај нараштај који чињаше зло пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","А ви сада изађосте на место отаца својих, род грешних људи, да умножавате жестину гнева Господњег на Израиља. ");
INSERT INTO srp1868_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ако се одвратите од њега, Он ће га још оставити у пустињи, и тако ћете упропастити сав онај народ. ");
INSERT INTO srp1868_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","А они приступише опет к њему, и рекоше му: Ми смо ради само торове начинити овде за стада своја и градове за децу своју. ");
INSERT INTO srp1868_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","А сами ћемо наоружани јуначки поћи пред синовима Израиљевим, докле их не одведемо на њихово место; а наша деца нека стоје у градовима тврдим ради становника те земље. ");
INSERT INTO srp1868_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Нећемо се вратити кућама својим докле синови Израиљеви не приме сваки своје наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Нити ћемо узети наследство с њима с оне стране Јордана ни даље, ако нам допадне наследство с ове стране Јордана према истоку. ");
INSERT INTO srp1868_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Тада им рече Мојсије; ако ћете учинити тако и ићи под оружјем пред Господом на војску, ");
INSERT INTO srp1868_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ако сваки од вас под оружјем пређе преко Јордана пред Господом, докле не отера испред себе непријатеља својих, ");
INSERT INTO srp1868_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","и докле се не покори земља пред Господом, па се онда вратите и не згрешите Господу ни Израиљу, онда ће ова земља припасти вама у наследство пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Ако ли не учините тако, гле, згрешићете Господу, и знајте да ће вас грех ваш стићи. ");
INSERT INTO srp1868_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Градите себи градове за децу своју и торове за стоку своју; и шта је изашло из уста ваших, учините. ");
INSERT INTO srp1868_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","И рекоше Мојсију синови Гадови и синови Рувимови говорећи: Слуге ће твоје учинити како господар наш заповеда. ");
INSERT INTO srp1868_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Деца наша и жене наше, стада наша и сва стока наша овде ће остати у градовима галадским; ");
INSERT INTO srp1868_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","а слуге ће твоје прећи сваки наоружан, да се бије пред Господом, као што говори господар наш. ");
INSERT INTO srp1868_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Тада Мојсије заповеди за њих Елеазару свештенику и Исусу сину Навином и главарима од домова отачких међу синовима Израиљевим, ");
INSERT INTO srp1868_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","и рече им: Ако пређу синови Гадови и синови Рувимови с вама преко Јордана, сви оружани, да се бију пред Господом, и кад вам буде земља покорена, онда подајте њима земљу галадску у наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ако ли не пређу с вама под оружјем, онда нека им буде наследство међу вама у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","И одговорише синови Гадови и синови Рувимови говорећи: Како је Господ казао слугама твојим тако ћемо учинити. ");
INSERT INTO srp1868_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Прећи ћемо под оружјем пред Господом у земљу хананску, а наше наследство да буде с ове стране Јордана. ");
INSERT INTO srp1868_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","И даде Мојсије синовима Гадовим и синовима Рувимовим и половини племена Манасије сина Јосифовог царство Сиона, цара аморејског и царство Ога, цара васанског, земљу и градове по међама њеним, градове оне земље унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","И саградише синови Гадови Девон и Атарот и Ароир. ");
INSERT INTO srp1868_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","И Атрот-Софан и Јазир и Јогвеју, ");
INSERT INTO srp1868_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","и Вет-Нимру и Вет-Аран, градове тврде, и торове за стоку. ");
INSERT INTO srp1868_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","А синови Рувимови саградише Есевон и Елеалију и Киријатајим, ");
INSERT INTO srp1868_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","и Навон и Валмеон преденувши им имена, и Сивму; и надеше друга имена градовима које саградише. ");
INSERT INTO srp1868_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","А синови Махира, сина Манасијиног отидоше у Галад, и узеше га, и изагнаше Амореје који беху онде. ");
INSERT INTO srp1868_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","И Мојсије даде Галад Махиру сину Манасијином, који се онде насели. ");
INSERT INTO srp1868_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","И Јаир, син Манасијин отиде и узе села њихова и прозва их села Јаирова. ");
INSERT INTO srp1868_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","И Навав отиде и узе Кенат са селима његовим, и прозва га Навав по имену свом. ");
INSERT INTO srp1868_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ово су путеви синова Израиљевих кад изађоше из земље мисирске у четама својим под управом Мојсијевом и Ароновом. ");
INSERT INTO srp1868_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","И Мојсије пописа како изиђоше и где стајаше по заповести Господњој; и ово су путеви њихови како путоваше. ");
INSERT INTO srp1868_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Пођоше из Рамесе првог месеца петнаести дан, сутрадан после пасхе, и изиђоше синови Израиљеви руком подигнутом пред очима свих Мисираца. ");
INSERT INTO srp1868_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","А Мисирци погребаваху првенце које поби Господ међу њима, кад и на боговима њиховим изврши Господ судове. ");
INSERT INTO srp1868_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","И отишавши синови Израиљеви из Рамесе стадоше у логор у Сохоту. ");
INSERT INTO srp1868_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","А из Сохота отишавши стадоше у логор у Етаму, који је на крај пустиње. ");
INSERT INTO srp1868_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","А из Етаме отишавши савише к Ироту, који је према Велсефону и стадоше у логор пред Магдалом. ");
INSERT INTO srp1868_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","А од Ирота отишавши пређоше преко мора у пустињу, и ишавши три дана преко пустиње Етама стадоше у логор у Мери. ");
INSERT INTO srp1868_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","А из Мере отишавши дођоше у Елим, где беше дванаест студенаца и седамдесет палмових дрвета, и онде стадоше у логор. ");
INSERT INTO srp1868_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","А из Елима отишавши стадоше у логор код Црвеног Мора. ");
INSERT INTO srp1868_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","И отишавши од Црвеног Мора стадоше у логор у пустињи Сину. ");
INSERT INTO srp1868_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","А из пустиње Сина отишавши стадоше у логор у Рафаку. ");
INSERT INTO srp1868_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","А из Рафака отишавши стадоше у логор у Елусу. ");
INSERT INTO srp1868_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","А из Елуса отишавши стадоше у логор у Рафидину, где немаше народ воде да пије. ");
INSERT INTO srp1868_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","А из Рафидина отишавши стадоше у логор у пустињи синајској. ");
INSERT INTO srp1868_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","А из пустиње синајске отишавши стадоше у логор у Киврот-Атави. ");
INSERT INTO srp1868_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","А из Киврот-Атаве отишавши стадоше у логор у Асироту. ");
INSERT INTO srp1868_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","А из Асирота отишавши стадоше у логор у Ратаму. ");
INSERT INTO srp1868_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","А из Ратама отишавши стадоше у логор у Ремнон-Фаресу. ");
INSERT INTO srp1868_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","А из Ремнон-Фареса отишавши стадоше у логор у Лемвону. ");
INSERT INTO srp1868_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","А из Лемвона отишавши стадоше у логор у Ресану. ");
INSERT INTO srp1868_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","А из Ресана отишавши стадоше у логор у Макелату. ");
INSERT INTO srp1868_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","А из Макелата отишавши стадоше у логор код горе Сафера. ");
INSERT INTO srp1868_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","А од горе Сафера отишавши стадоше у логор у Хараду. ");
INSERT INTO srp1868_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","А из Харада отишавши стадоше у логор у Макидоту. ");
INSERT INTO srp1868_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","А из Макидота отишавши стадоше у логор у Катату. ");
INSERT INTO srp1868_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","А из Катата отишавши стадоше у логор у Тарату. ");
INSERT INTO srp1868_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","А из Тарата отишавши стадоше у логор у Метеку. ");
INSERT INTO srp1868_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","А из Метека отишавши стадоше у логор у Аселмону. ");
INSERT INTO srp1868_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","А из Аселмона отишавши стадоше у логор у Мосироту. ");
INSERT INTO srp1868_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","А из Мосирота отишавши стадоше у логор у Ванакану. ");
INSERT INTO srp1868_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","А из Ванакана отишавши стадоше у логор на планини Гададу. ");
INSERT INTO srp1868_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","А са планине Гадада отишавши стадоше у логор у Етавати. ");
INSERT INTO srp1868_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","А из Етавате отишавши стадоше у логор и Еврону. ");
INSERT INTO srp1868_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","А из Еврона отишавши стадоше у логор у Гесион-Гаверу. ");
INSERT INTO srp1868_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","А из Гесион-Гавера отишавши стадоше у логор у пустињи Сину, а то је Кадис. ");
INSERT INTO srp1868_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","А из Кадиса отишавши стадоше у логор код горе Ора не међи земље едомске. ");
INSERT INTO srp1868_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","И изиђе Арон свештеник на гору Ор по заповести Господњој, и умре онде четрдесете године по изласку синова Израиљевих из земље мисирске, први дан петог месеца. ");
INSERT INTO srp1868_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","А Арону беше сто и двадесет и три године кад умре на гори Ору. ");
INSERT INTO srp1868_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Тада чу Хананеј, цар арадски, који живљаше на југу у земљи хананској, да иду синови Израиљеви. ");
INSERT INTO srp1868_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Потом отишавши од горе Ора стадоше у логор у Селмону. ");
INSERT INTO srp1868_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","А из Селмона отишавши стадоше у логор у Финону. ");
INSERT INTO srp1868_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","А из Финона отишавши стадоше у логор у Овоту. ");
INSERT INTO srp1868_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","А из Овота отишавши стадоше у логор на хумовима аваримским на међи моавској. ");
INSERT INTO srp1868_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","А од тих хумова отишавши стадоше у логор у Девон-Гаду. ");
INSERT INTO srp1868_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","А из Девон-Гада отишавши стадоше у логор у Гелмон-Девлатаиму. ");
INSERT INTO srp1868_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","А из Гелмон-Девлатаима отишавши стадоше у логор у планинама аваримским према Нававу. ");
INSERT INTO srp1868_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","А из планина аваримских отишавши стадоше у логор у пољу моавском на Јордану према Јерихону. ");
INSERT INTO srp1868_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","И стајаху у логору крај Јордана од Есимота до Вел-Сатима у пољу моавском. ");
INSERT INTO srp1868_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","И рече Господ Мојсију у пољу моавском на Јордану према Јерихону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Кажи синовима Израиљевим и реци им: Кад пређете преко Јордана у земљу хананску, ");
INSERT INTO srp1868_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","отерајте од себе све који живе у оној земљи, и потрите све слике њихове резане, и све слике њихове ливене потрите, и све висине њихове оборите. ");
INSERT INTO srp1868_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","А кад их истерате из земље, населите се у њој; јер сам вама дао ону земљу да је ваша. ");
INSERT INTO srp1868_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","И разделите је у наследство жребом на породице своје; којих има више, њима веће наследство подајте; а којих има мање, њима подајте мање наследство; које место коме жребом допадне, оно нека му буде; на племена отаца својих разделите наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Ако ли не отерате од себе оних који живе у оној земљи, онда ће они које оставите бити трње очима вашим и остани вашим боковима, и пакостиће вам у земљи у којој ћете живети. ");
INSERT INTO srp1868_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","И шта сам мислио учинити њима, учинићу вама. ");
INSERT INTO srp1868_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Заповеди синовима Израиљевим и реци им: Кад дођете у земљу хананску, та ће вам земља припасти у наследство, земља хананска с међама својим. ");
INSERT INTO srp1868_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Јужни крај да вам је од пустиње Сина, уз међу едомску, и да вам је јужна међа од брега сланог мора на исток; ");
INSERT INTO srp1868_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","и та међа нека се савије од југа к Акравиму и иде до Сина, и нека се пружи од југа преко Кадис-Варније, а отуда нека изиђе на село Адар и иде до Аселмона; ");
INSERT INTO srp1868_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","потом нека се савије та међа од Аселмона до потока мисирског и иде до мора. ");
INSERT INTO srp1868_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","А западна међа да вам буде велико море; то да вам је западна међа. ");
INSERT INTO srp1868_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","А северна међа ово да вам буде: од великог мора повуците себи међу до горе Ора; ");
INSERT INTO srp1868_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","а од горе Ора повуците себи међу како се иде у Емат, и та међа нека иде на Седад; ");
INSERT INTO srp1868_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","и нека иде та међа до Зефрона, и крај нека јој буде код села Енана, то да вам буде северна међа. ");
INSERT INTO srp1868_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","А с истока повуците себи међу од села Енана до Сефама; ");
INSERT INTO srp1868_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","а од Сефама нека иде та међа к Ривли, с истока Аину, и нека иде даље та међа докле дође до мора Хинерота к истоку; ");
INSERT INTO srp1868_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","и нека се спусти та међа ка Јордану, и нека изађе на слано море. Та ће земља бити ваша с међама својим унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","И каза Мојсије синовима Израиљевим говорећи: То је земља коју ћете добити у наследство жребом, за коју је заповедио Господ да је добије девет племена и по. ");
INSERT INTO srp1868_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Јер племе синова Рувимових по породицама отаца својих, и племе синова Гадових по породицама отаца својих, и половина племена Манасијиног примише своје наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ова два племена и по примише наследство своје с ову страну Јордана према Јерихону с источне стране. ");
INSERT INTO srp1868_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Опет рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Ово су имена људи који ће вам разделити у наследство земљу: Елеазар свештеник и Исус син Навин. ");
INSERT INTO srp1868_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","И по једног кнеза из сваког племена узмите да дели земљу. ");
INSERT INTO srp1868_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","А ово су имена тих људи: од племена Јудиног Халев син Јефонијин, ");
INSERT INTO srp1868_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","од племена синова Симеунових Самуило син Емијудов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","од племена Венијаминовог Елдад син Хаслонов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","од племена синова Данових кнез Вокор син Јеклинов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","од синова Јосифових: од племена синова Манасијиних кнез Анило син Суфидов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","од племена синова Јефремових, кнез Камуило син Сафтанов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","од племена синова Завулонових кнез Елисафан син Харнахов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","од племена синова Исахарових кнез Фалтило син Озаинов, ");
INSERT INTO srp1868_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","од племена синова Асирових кнез Ахиор син Селемијин, ");
INSERT INTO srp1868_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","и од племена Нефталимовог кнез Фадаило син Амијудов. ");
INSERT INTO srp1868_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Овима заповеди Господ да разделе наследство синовима Израиљевим у земљи хананској. ");
INSERT INTO srp1868_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Још рече Господ Мојсију у пољу моавском на Јордану према Јерихону говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Заповеди синовима Израиљевим нека даду од наследства свог Левитима градове, где ће живети; и подграђа око градова подајте им, ");
INSERT INTO srp1868_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","да у градовима живе, а у подграђима њиховим да им стоји стока и имање њихово и све животиње њихове. ");
INSERT INTO srp1868_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","А подграђа која дате Левитима нека буду на хиљаду лаката далеко од зидова градских унаоколо. ");
INSERT INTO srp1868_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Зато измерите иза сваког града на исток две хиљаде лаката, и на југ две хиљаде лаката, и на запад две хиљаде лаката, и на север две хиљаде лаката, тако да град буде у среди. Толика нека буду подграђа њихова. ");
INSERT INTO srp1868_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","А од градова које дате Левитима одвојте шест градова за уточиште, да онамо утече ко би кога убио; и осим њих подајте им четрдесет и два града. ");
INSERT INTO srp1868_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Свега градова, које ћете дати Левитима да буде четрдесет и осам градова, сваки са својим подграђем. ");
INSERT INTO srp1868_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","А тих градова што ћете дати од наследства синова Израиљевих, од оних који имају више подајте више, а од оних који имају мање подајте мање; сваки према наследству које ће имати нека да од својих градова Левитима. ");
INSERT INTO srp1868_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Још рече Господ Мојсију говорећи: ");
INSERT INTO srp1868_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Реци синовима Израиљевим и кажи им: Кад пређете преко Јордана у земљу хананску, ");
INSERT INTO srp1868_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","од градова који вам допадну одвојте градове за уточиште да у њих утече крвник који убије кога нехотице. ");
INSERT INTO srp1868_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","И ти ће вам градови бити уточишта од осветника, да не погине крвник докле не стане на суд пред збор. ");
INSERT INTO srp1868_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","И тако од тих градова које дате шест градова биће вам уточишта. ");
INSERT INTO srp1868_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Три таква града подајте с ове стране Јордана, а три града подајте у земљи хананској, ти градови нека буду уточишта. ");
INSERT INTO srp1868_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Синовима Израиљевим и дошљаку и странцу, који се бави међу њима, нека тих шест градова буду уточишта, да утече у њих ко год убије кога нехотице. ");
INSERT INTO srp1868_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Али ако гвожђем удари кога, те онај умре, крвник је, нека се погуби такав крвник. ");
INSERT INTO srp1868_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","И ако каменом из руке, од ког може човек погинути, удари кога, те онај умре, крвник је, нека се погуби такав крвник. ");
INSERT INTO srp1868_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Или ако дрветом из руке, од ког може човек погинути, удари кога, те онај умре, крвник је, нека се погуби такав крвник. ");
INSERT INTO srp1868_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Осветник нека погуби крвника; кад га удеси, нека га погуби. ");
INSERT INTO srp1868_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ако га из мржње тури, или се баци чим на њ навалице, те онај умре, ");
INSERT INTO srp1868_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","или ако га из непријатељства удари руком, те онај умре, нека се погуби такав убица, крвник је; осветник нека погуби тог крвника кад га удеси. ");
INSERT INTO srp1868_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Ако ли га нехотице тури без непријатељства, или се баци на њ чим нехотице, ");
INSERT INTO srp1868_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","или каменом од ког може човек погинути, ако се баци на њ нехотице, те онај умре, а није му непријатељ, нити му тражи зла, ");
INSERT INTO srp1868_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","тада да суди збор између убице и осветника по овом закону. ");
INSERT INTO srp1868_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","И збор нека избави крвника из руке осветникове и врати га у уточиште његово, куда је утекао, и онде нека остане докле не умре поглавар свештенички, који је помазан светим уљем. ");
INSERT INTO srp1868_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Ако крвник како год изиђе преко међе свог уточишта у које је утекао, ");
INSERT INTO srp1868_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","и нађе га осветник преко међе уточишта његовог, ако крвника убије осветник, неће бити крив за крв. ");
INSERT INTO srp1868_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Јер у уточишту свом ваља да стоји докле не умре поглавар свештенички; па кад умре поглавар свештенички, онда треба да се врати крвник у земљу наследства свог. ");
INSERT INTO srp1868_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Ово да вам је уредба за суђење од колена до колена по свим становима вашим. ");
INSERT INTO srp1868_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ко би хтео погубити човека, по сведоцима нека погуби крвника; али један сведок не може сведочити да се ко погуби. ");
INSERT INTO srp1868_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Не узимајте откуп за крвника, који заслужи смрт, него нека се погуби. ");
INSERT INTO srp1868_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Ни од оног не узимајте откуп који утече у уточиште, да би се вратио да живи у својој земљи пре него умре свештеник; ");
INSERT INTO srp1868_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","да не бисте скврнили земљу у којој сте, јер крв она скврни земљу, а земља се не може очистити од крви која се пролије на њој другачије него крвљу оног који је пролије. ");
INSERT INTO srp1868_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Зато не скврните земље у којој наставате и у којој ја наставам, јер ја Господ наставам усред синова Израиљевих. ");
INSERT INTO srp1868_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Тада приступише старешине из породице синова Галада сина Махира сина Манасијиног од племена синова Јосифових, и рекоше пред Мојсијем и пред кнезовима, главарима од домова отачких међу синовима Израиљевим, ");
INSERT INTO srp1868_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","и говорише: Господару нашем заповеди Господ да подели жребом земљу у наследство синовима Израиљевим; и господар наш има заповест од Господа да да наследство Салпада, брата нашег кћерима његовим. ");
INSERT INTO srp1868_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ако се оне удаду за кога из другог племена синова Израиљевих, онда ће се наследство њихово откупити од наследства отаца наших и додаће се наследству оног племена у које се удаду, и тако ће се део наш окрњити. ");
INSERT INTO srp1868_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","И кад буде опросна година синовима Израиљевим, опет ће остати наследство њихово с наследством оног племена у које се буду удале, и тако ће од наследства племена отаца наших остати откинуто наследство њихово. ");
INSERT INTO srp1868_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Тада заповеди Мојсије синовима Израиљевим по заповести Господњој говорећи: Право говори племе синова Јосифових. ");
INSERT INTO srp1868_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ово заповеди Господ за кћери Салпадове и рече: Нека се удаду за кога им буде воља, али у породици племена свог нека се удаду. ");
INSERT INTO srp1868_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Да се не би преносило наследство синова Израиљевих од једног племена на друго; јер ће синови Израиљеви држати сваки наследство племена отаца својих. ");
INSERT INTO srp1868_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","И свака кћи у племенима синова Израиљевих којој допадне наследство, нека се удаје за кога из породице племена оца свог, да би синови Израиљеви држали сваки наследство отаца својих, ");
INSERT INTO srp1868_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","да се не би преносило наследство од једног племена синова Израиљевих да држи своје наследство. ");
INSERT INTO srp1868_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Како заповеди Господ Мојсију, тако учинише кћери Салпадове. ");
INSERT INTO srp1868_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Јер Мала и Терса и Егла и Мелха и Нуја, кћери Салпадове, удадоше се за синове стричева својих, ");
INSERT INTO srp1868_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","у породице синова Манасије сина Јосифовог удадоше се, и оста наследство њихово у племену породице оца њиховог. ");
INSERT INTO srp1868_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","То су заповести и закони, које заповеди Господ преко Мојсија синовима Израиљевим у пољу моавском на Јордану према Јерихону. ");
INSERT INTO srp1868_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ово су речи које говори Мојсије свему Израиљу с ону страну Јордана, у пустињи, у пољу према Црвеном мору, између Фарана и Тофола и Ловона и Асирота и Дизава, ");
INSERT INTO srp1868_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","једанаест дана хода од Хорива преко горе Сира до Кадис-Варније. ");
INSERT INTO srp1868_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","А беше четрдесете године први дан једанаестог месеца, кад Мојсије каза синовима Израиљевим све што му беше заповедио Господ да им каже, ");
INSERT INTO srp1868_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","пошто уби Сиона, цара аморејског који живљаше у Есевону, и Ога цара васанског који живљаше у Астароту и у Едрајину. ");
INSERT INTO srp1868_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","С оне стране Јордана у земљи моавској поче Мојсије казивати овај закон говорећи: ");
INSERT INTO srp1868_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Господ Бог наш рече нам на Хориву говорећи: Доста сте били на овој гори. ");
INSERT INTO srp1868_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Обрните се и подигните се и идите ка гори аморејској и у сву околину њену, у равнице и у брда и у долине, и на југ и на брегове морске, у земљу хананску и на Ливан и до реке велике, реке Ефрата. ");
INSERT INTO srp1868_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ето, дао сам вам земљу, уђите у њу, и узмите земљу, за коју се заклео Господ оцима вашим, Авраму, Исаку и Јакову, да ће им је дати и семену њиховом након њих. ");
INSERT INTO srp1868_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","И рекох вам онда говорећи: Не могу вас носити сам. ");
INSERT INTO srp1868_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Господ Бог ваш умножио вас је, и ето вас данас има много као звезда небеских. ");
INSERT INTO srp1868_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Господ Бог отаца ваших да вас умножи још хиљаду пута више, и да вас благослови као што вам је казао. ");
INSERT INTO srp1868_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Како бих ја сам носио муке ваше, бремена ваша и распре ваше? ");
INSERT INTO srp1868_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Дајте из племена својих људе мудре и веште и познате да вам их поставим за старешине. ");
INSERT INTO srp1868_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Тада ми одговористе и рекосте: Добро је да се учини шта си казао. ");
INSERT INTO srp1868_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Тада узевши старешине од племена ваших, људе мудре и познате, поставих вам их за старешине, за хиљаднике и стотинаре и педесетаре и десетаре и управитеље по племенима вашим. ");
INSERT INTO srp1868_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","И заповедих онда судијама вашим говорећи: Саслушавајте распре међу браћом својом и судите право између човека и брата његовог и између дошљака који је с њим. ");
INSERT INTO srp1868_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Не гледајте ко је ко на суду, саслушајте и малог и великог, не бојте се никога, јер је суд Божији, а ствар која би вам била тешка изнесите преда ме да је чујем. ");
INSERT INTO srp1868_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","И заповедих вам онда све што ћете чинити. ");
INSERT INTO srp1868_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Потом отишавши од Хорива пређосмо сву ону пустињу велику и страшну, коју видесте, идући ка гори аморејској, као што нам заповеди Господ Бог наш, и дођосмо до Кадис-Варније. ");
INSERT INTO srp1868_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Тада вам рекох: Дођосте до горе аморејске, коју нам даје Господ Бог наш. ");
INSERT INTO srp1868_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Гле, дао ти је Господ Бог твој ту земљу, иди и узми је, као што ти је рекао Господ Бог отаца твојих; не бој се и не плаши се. ");
INSERT INTO srp1868_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","А ви сви дођосте к мени и рекосте: Да пошаљемо људе пред собом да нам уходе земљу, и да нам јаве за пут којим ћемо ићи и за градове у које ћемо доћи, ");
INSERT INTO srp1868_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","и то ми би по вољи, и узех између вас дванаест људи, из сваког племена по једног; ");
INSERT INTO srp1868_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","и они се подигоше и изишавши на гору дођоше до потока Есхола, и уходише земљу; ");
INSERT INTO srp1868_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","и набраше рода оне земље и донесоше нам, и јавише нам говорећи: Добра је земља, коју нам даје Господ Бог наш. ");
INSERT INTO srp1868_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Али не хтесте ићи него се супротисте заповести Господа Бога свог. ");
INSERT INTO srp1868_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","И викасте у шаторима својим говорећи: Мрзи на нас Господ, зато нас изведе из земље мисирске, да нас да у руке Аморејцима и да нас потре. ");
INSERT INTO srp1868_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Куда да идемо? Браћа наша уплашише срце наше говорећи: Народ је већи и виши од нас, градови су велики и ограђени до неба, па и синове Енакове видесмо овде. ");
INSERT INTO srp1868_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","А ја вам рекох: Не плашите се и не бојте их се. ");
INSERT INTO srp1868_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Господ Бог ваш, који иде пред вама, Он ће се бити за вас онако како вам је учинио у Мисиру на ваше очи, ");
INSERT INTO srp1868_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","и у пустињи, где си видео како те је носио Господ Бог твој, као што човек носи сина свог, целим путем којим сте ишли докле дођосте до овог места. ");
INSERT INTO srp1868_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Али зато опет не веровасте Господу Богу свом, ");
INSERT INTO srp1868_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","који иђаше пред вама путем тражећи вам место где бисте стали, иђаше ноћу у огњу да вам светли путем којим бисте ишли, а дању у облаку. ");
INSERT INTO srp1868_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","И чу Господ глас речи ваших, и разгневи се и закле се говорећи: ");
INSERT INTO srp1868_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Ниједан од овог рода злог неће видети ове добре земље, за коју се заклех да ћу дати вашим оцима, ");
INSERT INTO srp1868_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","осим Халева, сина Јефонијиног; он ће је видети, и њему ћу дати земљу по којој је ишао, и синовима његовим, јер се сасвим држао Господа. ");
INSERT INTO srp1868_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Па и на мене се разгневи Господ с вас; и рече: Ни ти нећеш ући онамо. ");
INSERT INTO srp1868_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Исус, син Навин, који те служи, он ће ући онамо, њега утврди; јер ће је он разделити синовима Израиљевим у наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","А деца ваша, за коју рекосте да ће постати робље, синови ваши, који данас не знају ни шта је добро ни шта је зло, они ће ући онамо, и њима ћу је дати и они ће је наследити. ");
INSERT INTO srp1868_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ви, пак, вратите се и идите у пустињу к Црвеном Мору. ");
INSERT INTO srp1868_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","А ви одговористе и рекосте ми: Сагрешисмо Господу; ићи ћемо и бићемо се сасвим како нам је заповедио Господ Бог наш. И узевши сваки своје оружје хтесте изаћи на гору. ");
INSERT INTO srp1868_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","А Господ ми рече: Кажи им: Не идите и не бијте се, јер нисам међу вама, да не изгинете пред непријатељима својим. ");
INSERT INTO srp1868_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","И ја вам рекох, али не послушасте, него се опресте заповести Господњој, и навалисте на гору. ");
INSERT INTO srp1868_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Тада изиђоше пред вас Амореји, који сеђаху у оној планини, и погнаше вас као што чине пчеле, и побише вас на Сиру па до Орме. ");
INSERT INTO srp1868_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","И вративши се плакасте пред Господом, али Господ не послуша глас ваш нити окрете ухо своје к вама. ");
INSERT INTO srp1868_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","И остадосте у Кадису дуго времена докле онде стајасте. ");
INSERT INTO srp1868_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Потом се вратисмо, и идосмо у пустињу к Црвеном Мору, као што ми заповеди Господ, и обилазисмо гору Сир дуго времена. ");
INSERT INTO srp1868_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","И рече ми Господ: ");
INSERT INTO srp1868_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Доста сте обилазили ту гору, обрните се на север. ");
INSERT INTO srp1868_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","И заповеди народу и реци: Сада ћете прећи преко међе браће своје, синова Исавових, који живе у Сиру; и они ће вас се бојати, али се и ви добро чувајте. ");
INSERT INTO srp1868_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Немојте заметати боја са њима, јер вам нећу дати земље њихове ни стопе, јер сам дао Исаву гору Сир у наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Јела купујте од њих за новце, и једите; и воду купујте од њих за новце, и пијте. ");
INSERT INTO srp1868_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Јер те је Господ Бог твој благословио у сваком послу руку твојих; и зна пут твој по овој великој пустињи, и ево четрдесет година беше с тобом Господ Бог твој, и ништа ти није недостајало. ");
INSERT INTO srp1868_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","И прођосмо браћу своју, синове Исавове, који живе у Сиру, пољем од Елата и од Гесион-Гавера. И оданде савивши ударисмо преко пустиње моавске. ");
INSERT INTO srp1868_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","И Господ ми рече: Немој пакостити Моавцима ни заметати боја са њима, јер ти нећу дати земље њихове у наследство; јер дадох синовима Лотовим у наследство Ар. ");
INSERT INTO srp1868_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Пре живљаху онде Емеји, народ велик и јак и висок као Енакими; ");
INSERT INTO srp1868_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","о њима се мислило да су дивови као и Енакими; али их Моавци зваху Емеји. ");
INSERT INTO srp1868_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","И Хореји живљаху пре у Сиру, али их синови Исавови истераше и истребише испред себе и населише се на њихово место, као што учини Израиљ у земљи свог наследства које му даде Господ.) ");
INSERT INTO srp1868_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","А сада устаните и пређите преко потока Зареда. И пређосмо преко потока Зареда. ");
INSERT INTO srp1868_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","А времена за које идосмо од Кадис-Варније па докле пређосмо преко потока Зареда, беше тридесет и осам година, докле не изумре у логору сав онај нараштај, људи за војску, као што им се беше заклео Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Јер и рука Господња беше против њих потирући их из логора докле не помреше. ");
INSERT INTO srp1868_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","И кад сви ти људи за војску помреше у народу, ");
INSERT INTO srp1868_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","рече ми Господ говорећи: ");
INSERT INTO srp1868_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Ти ћеш данас прећи преко међе моавске код Ара; ");
INSERT INTO srp1868_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","и доћи ћеш близу синова Амонових; немој им пакостити ни заметати боја са њима, јер ти нећу дати земље амонске у наследство, јер је дадох синовима Лотовим у наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(И за њу се мислило да је земља дивовска; у њој пре живљаху дивови, које Амонци зваху Замзуми. ");
INSERT INTO srp1868_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Беху народ велик и јак и висок као Енакими; али их истреби Господ испред њих, те они преузеше земљу њихову и населише се на њихово место; ");
INSERT INTO srp1868_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","као што учини синовима Исавовим, који живљаху у Сиру, јер истреби Хореје испред њих, и преузеше земљу њихову и осташе на њиховом месту до данас. ");
INSERT INTO srp1868_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","И Авеје, који живљаху у Асироту па до Газе, истребише Кафтореји, који изађоше од Кафтора, и населише се на њихово место.) ");
INSERT INTO srp1868_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Устаните, идите и пређите преко потока Арнона; гле, дао сам ти у руке Сиона Аморејина, цара есевонског и земљу његову; почни узимати наследство и завојшти на њ. ");
INSERT INTO srp1868_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Данас почињем задавати страх и трепет од тебе народима под целим небом; који год чују за те, дрхтаће и препадаће се од тебе. ");
INSERT INTO srp1868_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","И послах посленике из пустиње Кедамота к Сиону, цару есевонском с мирним речима говорећи: ");
INSERT INTO srp1868_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Да пређем преко твоје земље; управо ћу путем ићи, нећу свртати ни надесно ни налево. ");
INSERT INTO srp1868_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Храну да ми дајеш за новце да једем, и воду за новце да ми дајеш да пијем, само да прођем пешице, ");
INSERT INTO srp1868_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","као што ми учинише синови Исавови који живе у Сиру, и Моавци, који живе у Ару, докле не пређем преко Јордана у земљу коју нам даје Господ Бог наш. ");
INSERT INTO srp1868_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Али не хте Сион, цар есевонски пустити да прођемо кроз његову земљу, јер Господ Бог твој учини те отврдну дух његов и срце његово поста упорно, да би га предао у твоје руке, као што се види данас. ");
INSERT INTO srp1868_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","И рече ми Господ: Гледај, почех предавати теби Сиона и земљу његову; почни узимати земљу његову да је наследиш. ");
INSERT INTO srp1868_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","И изиђе пред нас Сион и сав народ његов на бој у Јасу. ");
INSERT INTO srp1868_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","И даде нам га Господ Бог наш, и убисмо га са синовима његовим и свим народом његовим. ");
INSERT INTO srp1868_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","И узесмо тада све градове његове, и побисмо људе по свим тим градовима, и жене и децу, не остависмо живог ниједног. ");
INSERT INTO srp1868_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Само стоку запленисмо за се и плен што беше по градовима које узесмо. ");
INSERT INTO srp1868_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Од Ароира који је на потоку Арнону, и од града који је у долини, па до Галада не беше града који би нам одолео: све то даде нам Господ Бог наш. ");
INSERT INTO srp1868_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Само к земљи синова Амонових ниси приступио нити ка коме крају на потоку Јавоку, ни ка градовима у гори нити коме месту што је забранио Господ Бог наш. ");
INSERT INTO srp1868_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Потом обративши се идосмо к Васану. И изиђе пред нас Ог, цар васански и сав народ његов на бој у Едрајин. ");
INSERT INTO srp1868_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","И Господ ми рече: Не бој га се, јер га дадох у твоје руке са свим народом његовим и са земљом његовом, да учиниш с њим онако како си учинио са Сионом царем аморејским, који сеђаше у Есевону. ");
INSERT INTO srp1868_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Тако нам даде Господ Бог наш у руке и Ога, цара васанског са свим народом његовим, и разбисмо га и не остависмо му ниједног живог. ");
INSERT INTO srp1868_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","И узесмо тада све градове његове; не би ниједног града ког не узесмо, шездесет градова, сав крај арговски, царство Ога у Васану. ");
INSERT INTO srp1868_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Сви ти градови беху утврђени зидом високим, вратима и преворницама, осим других места без зидова врло много. ");
INSERT INTO srp1868_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","И раскопасмо их као што учинисмо Сиону, цару есевонском, побивши по свим местима и људе и жене и децу. ");
INSERT INTO srp1868_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","А сву стоку и плен по градовима запленисмо за се. ");
INSERT INTO srp1868_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Тако узесмо онда земљу из руку двојице царева аморејских, која је с ове стране Јордана од потока Арнона до горе Ермона, ");
INSERT INTO srp1868_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Сидонци зову Ермон Сирион, а Амореји га зову Сенир,) ");
INSERT INTO srp1868_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Сва места у равни и сав Галад и сав Васан до Салхе и Едрајина, градове царства Ога у Васану. ");
INSERT INTO srp1868_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Јер само Ог цар васански беше остао од дивова. Гле, одар његов, одар гвозден, није ли у Рави синова Амонових? Девет је лаката дуг, а широк четири лакта, лакта човечија. ");
INSERT INTO srp1868_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Тако наследисмо ту земљу онда; од Ароира, који је на потоку Арнону, и половину горе Галада с градовима њеним дадох синовима Рувимовим и Гадовим. ");
INSERT INTO srp1868_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","И остатак Галада и сав Васан, царство Огово, дадох половини племена Манасијиног; сав крај арговски по свему Васану зваше се земља дивовска. ");
INSERT INTO srp1868_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Јаир син Манасијин узе сав крај арговски до међе гесурске и махатске; и прозва Васанску својим именом: села Јаирова до данашњег дана. ");
INSERT INTO srp1868_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","А Махиру дадох Галад. ");
INSERT INTO srp1868_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","А Рувимовом племену и Гадовом племену дадох од Галада до потока Арнона, како захвата поток с међама, па до потока Јавока, где је међа синова Амонових. ");
INSERT INTO srp1868_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","И поље и Јордан с међама од Хинерота до мора уз поље, до мора сланог, испод Фазге према истоку. ");
INSERT INTO srp1868_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","И заповедих вам онда и рекох: Господ Бог ваш дао вам је ову земљу у наследство; наоружани хајдете пред браћом својом, синовима Израиљевим, ко је год за војску. ");
INSERT INTO srp1868_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","А жене ваше и деца ваша и стока ваша (знам да имате много стоке) нека остану у градовима вашим, које вам дадох, ");
INSERT INTO srp1868_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","докле не смири Господ и браћу вашу као вас, да и они наследе земљу, коју ће им Господ Бог ваш дати с оне стране Јордана; онда се вратите сваки на своје наследство, које вам дадох. ");
INSERT INTO srp1868_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","А Исусу онда заповедих говорећи: Очи твоје виде све што је учинио Господ Бог ваш са она два цара; онако ће Господ учинити са свим царствима у која дођеш. ");
INSERT INTO srp1868_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Немојте их се бојати, јер ће се Господ Бог ваш бити за вас. ");
INSERT INTO srp1868_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","И молих се Господу онда говорећи: ");
INSERT INTO srp1868_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Господе Боже! Ти си почео показивати слузи свом величину своју и крепку руку своју, јер који је Бог на небу или на земљи који би творио дела каква су Твоја и у кога би била сила каква је Твоја? ");
INSERT INTO srp1868_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Дај ми да пређем и видим земљу добру која је преко Јордана и гору добру, Ливан. ");
INSERT INTO srp1868_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Али Господ беше гневан на ме с вас, и не услиши ме, него ми рече: Доста; не говори ми више за то. ");
INSERT INTO srp1868_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Попни се на врх ове горе, и подигавши очи своје на запад и на север и на југ и на исток, види очима својим, јер нећеш прећи преко Јордана. ");
INSERT INTO srp1868_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Него подај заповести Исусу, и утврди га и укрепи га; јер ће он прећи пред народом тим, и он ће им разделити у наследство земљу коју видиш. ");
INSERT INTO srp1868_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","И остасмо у овој долини према Вет-Фегору. ");
INSERT INTO srp1868_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","А сада, Израиљу, чуј уредбе моје и законе, које вас учим да творите, да бисте поживели и ушли у земљу коју вам даје Господ Бог отаца ваших и да бисте је наследили. ");
INSERT INTO srp1868_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ништа не додајте к речи коју вам ја заповедам, нити одузмите од ње, да бисте сачували заповести Господа Бога свог које вам ја заповедам. ");
INSERT INTO srp1868_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Очи су ваше виделе шта учини Господ с Велфегора; јер сваког човека који пође за Велфегором истреби Господ Бог твој између тебе. ");
INSERT INTO srp1868_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","А ви који се држасте Господа Бога свог, ви сте сви живи данас. ");
INSERT INTO srp1868_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Гле, учио сам вас уредбама и законима, као што ми заповеди Господ Бог мој, да бисте тако творили у земљи коју идете да је наследите. ");
INSERT INTO srp1868_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Држите дакле и извршујте их, јер је то мудрост ваша и разум ваш пред народима, који ће кад чују све ове уредбе рећи: Само је овај велики народ мудар и разуман. ");
INSERT INTO srp1868_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Јер који је велики народ коме је Господ близу као што је Господ Бог наш кад Га год зазовемо? ");
INSERT INTO srp1868_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","И који је народ велики који има уредбе и законе праведне као што је сав овај закон који износим данас пред вас? ");
INSERT INTO srp1868_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Само пази на се и добро чувај душу своју, да не заборавиш оне ствари које су виделе очи твоје, и да не изиђу из срца твог докле си год жив; него да их обзнаниш синовима својим и синовима синова својих. ");
INSERT INTO srp1868_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Онај дан кад стајасте пред Господом Богом својим код Хорива, кад ми Господ рече: Сабери ми народ да им кажем речи своје, којима ће се научити да ме се боје док су живи на земљи, и да уче томе и синове своје; ");
INSERT INTO srp1868_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","кад приступисте и стајасте под гором, а гора огњем гораше до самог неба и беше на њој тама и облак и мрак; ");
INSERT INTO srp1868_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","и проговори Господ к вама исред огња; глас од речи чусте, али осим гласа лик не видесте; ");
INSERT INTO srp1868_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","и објави вам завет свој, који вам заповеди да држите, десет речи, које написа на две плоче камене. ");
INSERT INTO srp1868_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","И мени заповеди онда Господ да вас учим уредбама и законима да их творите у земљи у коју идете да је наследите. ");
INSERT INTO srp1868_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Зато чувајте добро душе своје; јер не видесте никакав лик у онај дан кад вам говори Господ на Хориву исред огња, ");
INSERT INTO srp1868_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","да се не бисте покварили и начинили себи лик резан или какву год слику од човека или од жене, ");
INSERT INTO srp1868_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","слику од каквог живинчета које је на земљи, или слику од какве птице крилате која лети испод неба; ");
INSERT INTO srp1868_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","слику од чега што пуже по земљи, или слику од какве рибе која је у води под земљом; ");
INSERT INTO srp1868_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","и да не би подигавши очи своје к небу и видевши сунце и месец и звезде, сву војску небеску, преварио се и клањао им се и служио им; јер их Господ Бог твој даде свим народима под целим небом; ");
INSERT INTO srp1868_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","а вас узе Господ и изведе вас из пећи гвоздене, из Мисира, да му будете народ наследни, као што се види данас. ");
INSERT INTO srp1868_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Али се Господ разгневи на ме за ваше речи, и закле се да нећу прећи преко Јордана ни ући у добру земљу, коју ти Господ Бог твој даје у наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","И ја ћу умрети у овој земљи и нећу прећи преко Јордана; а ви ћете прећи и наследити ону добру земљу. ");
INSERT INTO srp1868_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Пазите да не заборавите завет Господа Бога свог, који учини с вама, и да не градите себи лик резани, слику од које год твари, као што ти је забранио Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Јер је Господ Бог твој огањ који спаљује и Бог који ревнује. ");
INSERT INTO srp1868_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Кад изродиш синове и унуке, и остарите у оној земљи, ако се покварите и начините слику резану од какве твари и учините шта није угодно Господу Богу вашем, дражећи Га, ");
INSERT INTO srp1868_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","сведочим вам данас небом и земљом да ће вас брзо нестати са земље у коју идете преко Јордана да је наследите, нећете бити дуго у њој, него ћете се истребити. ");
INSERT INTO srp1868_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Или ће вас расејати Господ међу народе, и мало ће вас остати међу народима у које вас одведе Господ; ");
INSERT INTO srp1868_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","и служићете онде боговима које су начиниле руке човечије, од дрвета и од камена, који не виде ни чују, нити једу ни миришу. ");
INSERT INTO srp1868_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Али ако и онде потражиш Господа Бога свог, наћи ћеш Га, ако Га потражиш свим срцем својим и свом душом својом. ");
INSERT INTO srp1868_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Кад будеш у невољи и све те то снађе, ако се у последње време обратиш ка Господу Богу свом, и послушаш глас Његов, ");
INSERT INTO srp1868_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Господ је Бог твој милостив Бог, неће те оставити ни истребити, јер неће заборавити завет с оцима твојим, за који им се заклео. ");
INSERT INTO srp1868_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Јер запитај сада за стара времена, која су била пре тебе, од оног дана кад створи Бог човека на земљи, и од једног краја неба до другог, је ли кад била оваква ствар велика, и је ли се кад чуло шта такво? ");
INSERT INTO srp1868_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Је ли кад чуо који народ глас Божји где говори исред огња, као што си ти чуо и остао жив? ");
INSERT INTO srp1868_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Или, је ли Бог покушао да дође те узме себи народ из другог народа кушањем, знацима и чудесима и ратом и руком крепком и мишицом подигнутом и страхотама великим, као што је учинио све то за вас Господ Бог наш у Мисиру на ваше очи? ");
INSERT INTO srp1868_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Теби је то показано да познаш да је Господ Бог, и да нема другог осим Њега. ");
INSERT INTO srp1868_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Дао ти је да чујеш глас Његов с неба да би те научио, и показао ти је на земљи огањ свој велики, и речи Његове чуо си исред огња. ");
INSERT INTO srp1868_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","И што му мили беху оци твоји, зато изабра семе њихово након њих, и изведе те сам великом силом својом из Мисира, ");
INSERT INTO srp1868_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","да отера испред тебе народе веће и јаче од тебе, и да тебе уведе у њихову земљу и даде ти је у наследство, као што се види данас. ");
INSERT INTO srp1868_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Знај дакле и памти у срцу свом да је Господ Бог, горе на небу и доле на земљи, нема другог. ");
INSERT INTO srp1868_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","И држи уредбе Његове и заповести Његове, које ти ја данас заповедам, да би добро било теби и синовима твојим након тебе, да би ти се продужили дани на земљи коју ти Господ Бог твој даје засвагда. ");
INSERT INTO srp1868_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Тада одели Мојсије три града с ове стране Јордана према истоку, ");
INSERT INTO srp1868_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","да би бежао у њих крвник који убије ближњег свог нехотице не мрзевши пре на њ, и кад побегне у који од тих градова, да би остао жив: ");
INSERT INTO srp1868_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Восор у пустињи, на равници у земљи племена Рувимовог, и Рамот у Галаду у племену Гадовом, Голан у васанској у племену Манасијином. ");
INSERT INTO srp1868_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ово је закон који постави Мојсије синовима Израиљевим. ");
INSERT INTO srp1868_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Ово су сведочанства и уредбе и закони, које каза Мојсије синовима Израиљевим кад изиђоше из Мисира, ");
INSERT INTO srp1868_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","с ове стране Јордана у долини према Вет-Фегору у земљи Сиона цара аморејског, који живљаше у Есевону, ког уби Мојсије и синови Израиљеви кад изиђоше из Мисира, ");
INSERT INTO srp1868_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","и освојише земљу његову и земљу Ога, цара васанског, два цара аморејска, која је с оне стране Јордана према истоку, ");
INSERT INTO srp1868_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","од Ароира, који је на потоку Арнону, до горе Сиона, а то је Ермон, ");
INSERT INTO srp1868_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","и све поље с ове стране Јордана према истоку до мора уз равницу под Аздот-Фазгом. ");
INSERT INTO srp1868_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","И Мојсије сазва сав народ Израиљев, и рече им: Чуј Израиљу уредбе и законе, које ћу данас казати да чујете, да их научите и држите их и творите. ");
INSERT INTO srp1868_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Господ Бог наш учини с нама завет на Хориву. ");
INSERT INTO srp1868_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Није с оцима нашим учинио тај завет, него с нама, који смо данас ту сви живи. ");
INSERT INTO srp1868_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Лицем к лицу говорио вам је Господ на овој гори исред огња; ");
INSERT INTO srp1868_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ја тада стајах између Господа и вас, да вам јавим речи Господње, јер вас беше страх од огња и не изиђосте на гору; и рече: ");
INSERT INTO srp1868_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Ја сам Господ Бог твој који сам те извео из земље мисирске, из дома ропског. ");
INSERT INTO srp1868_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Немој имати богове друге до мене. ");
INSERT INTO srp1868_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Не гради себи лик резани, нити какву слику од твари које су горе на небу или које су доле на земљи или које су у води испод земље. ");
INSERT INTO srp1868_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Немој им се клањати нити им служити, јер сам ја Господ Бог твој, Бог ревнитељ, који на синовима походим безакоња отаца њихових до трећег и до четвртог колена, оних који мрзе на ме, ");
INSERT INTO srp1868_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","а чиним милост на хиљадама оних који ме љубе и чувају заповести моје. ");
INSERT INTO srp1868_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Не узимај узалуд име Господа Бога свог, јер неће пред Господом бити прав ко узме име Његово узалуд. ");
INSERT INTO srp1868_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Држи дан од одмора и светкуј га, као што ти је заповедио Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Шест дана ради и свршуј све послове своје. ");
INSERT INTO srp1868_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","А седми је дан одмор Господу Богу твом; немој радити никакав посао ни ти, ни син твој ни кћи твоја, ни слуга твој ни слушкиња твоја, ни во твој ни магарац твој, нити које живинче твоје, ни дошљак који је код тебе, да би се одморио слуга твој и слушкиња твоја као и ти. ");
INSERT INTO srp1868_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","И памти да си био роб у земљи мисирској, и Господ Бог твој изведе те оданде руком крепком и мишицом подигнутом. Зато ти је Господ Бог твој заповедио да светкујеш дан од одмора. ");
INSERT INTO srp1868_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Поштуј оца свог и матер своју, као што ти је заповедио Господ Бог твој, да би се продужили дани твоји и да би ти добро било на земљи, коју ти даде Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Не убиј. ");
INSERT INTO srp1868_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Не чини прељубе. ");
INSERT INTO srp1868_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Не кради. ");
INSERT INTO srp1868_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Не сведочи лажно на ближњег свог. ");
INSERT INTO srp1868_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Не пожели жену ближњег свог, не пожели кућу ближњег свог, ни њиву његову, ни слугу његовог, ни слушкињу његову, ни вола његовог, ни магарца његовог, нити ишта шта је ближњег твог. ");
INSERT INTO srp1868_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Те речи изговори Господ свему збору вашем на гори исред огња, облака и мрака, гласом великим, и ништа више, него их написа на две плоче камене које ми даде. ");
INSERT INTO srp1868_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","А ви кад чусте глас исред таме, јер гора огњем гораше, приступисте к мени, сви главари од племена ваших и старешине ваше, ");
INSERT INTO srp1868_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","и рекосте: Гле, показа нам Господ Бог наш славу и величину своју, и чусмо глас Његов исред огња; данас видесмо где Бог говори с човеком, и човек оста жив. ");
INSERT INTO srp1868_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Па сада зашто да помремо? Јер ће нас спалити онај огањ велики; ако још чујемо глас Господа Бога свог, помрећемо. ");
INSERT INTO srp1868_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Јер које је тело чуло глас Бога Живога где говори исред огња, као ми, и остало живо? ");
INSERT INTO srp1868_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Иди ти, и саслушај све што ће ти казати Господ Бог наш, па онда ти кажи нама шта ти год каже Господ Бог наш, а ми ћемо слушати и творити. ");
INSERT INTO srp1868_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","И Господ чу глас од речи ваших кад ви говорасте, и рече ми Господ: Чух глас од речи тог народа, које рекоше теби; шта рекоше добро рекоше. ");
INSERT INTO srp1868_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","О, кад би им било срце свагда тако да ме се боје и држе све заповести моје свагда, да би било добро њима и синовима њиховим довека. ");
INSERT INTO srp1868_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Иди, реци им: Вратите се у шаторе своје. ");
INSERT INTO srp1868_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","А ти стани овде код мене, и казаћу ти све заповести и уредбе и законе, које ћеш их научити да творе у земљи коју им дајем у наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Гледајте, дакле да чините онако како вам је заповедио Господ Бог ваш, не сврћите ни надесно ни налево. ");
INSERT INTO srp1868_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Целим путем, који вам је заповедио Господ Бог ваш, идите, да бисте живи били и да би вам добро било, и да би вам се продужили дани у земљи коју ћете наследити. ");
INSERT INTO srp1868_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","А ово су заповести и уредбе и закони, које Господ Бог ваш заповеди да вас учим да их творите у земљи у коју идете да је наследите, ");
INSERT INTO srp1868_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","да би се бојао Господа Бога свог држећи све уредбе Његове и заповести Његове, које ти ја заповедам, ти син твој и унук твој свега века свог, да би ти се продужили дани твоји. ");
INSERT INTO srp1868_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Чуј дакле, Израиљу, и гледај да тако чиниш, да би ти добро било и да бисте се умножили веома у земљи у којој тече млеко и мед, као што ти је рекао Господ Бог отаца твојих. ");
INSERT INTO srp1868_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Чуј, Израиљу: Господ је Бог наш једини Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Зато љуби Господа Бога свог из свега срца свог и из све душе своје и из све снаге своје. ");
INSERT INTO srp1868_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","И нека ове речи које ти је заповедам данас буду у срцу твом. ");
INSERT INTO srp1868_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","И често их напомињи синовима својим, и говори о њима кад седиш у кући својој и кад идеш путем, кад лежеш и кад устајеш. ");
INSERT INTO srp1868_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","И вежи их себи на руку за знак, и нека ти буду као почеоник међу очима. ");
INSERT INTO srp1868_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","И напиши их на довратницима од куће своје и на вратима својим. ");
INSERT INTO srp1868_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","А кад те уведе Господ Бог твој у земљу за коју се заклео оцима твојим Авраму, Исаку и Јакову, да ће ти је дати, у градове велике и добре, којих ниси зидао. ");
INSERT INTO srp1868_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","И куће пуне сваког добра, којих ниси пунио, и на студенце ископане, којих ниси копао, у винограде и у маслинике, којих ниси садио, и станеш јести и наситиш се, ");
INSERT INTO srp1868_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","чувај се да не заборавиш Господа, који те је извео из земље мисирске, из куће ропске. ");
INSERT INTO srp1868_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Господа Бога свог бој се, и Њему служи, и Његовим се именом куни. ");
INSERT INTO srp1868_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Не идите за другим боговима између богова других народа, који су око вас. ");
INSERT INTO srp1868_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Јер је Бог ревнитељ, Господ Бог твој усред тебе, па да се не би разгневио Господ Бог твој на те и истребио те из земље. ");
INSERT INTO srp1868_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Немојте кушати Господа Бога свог као што Га кушасте у Маси. ");
INSERT INTO srp1868_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Држите добро заповести Господа Бога свог и сведочанства Његова и уредбе Његове, које ти је заповедио, ");
INSERT INTO srp1868_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","и чини што је право и добро пред Господом, да би ти било добро и да би ушао у добру земљу, за коју се заклео Господ оцима твојим, и да би је наследио, ");
INSERT INTO srp1868_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","да би отерао све непријатеље твоје испред тебе, као што ти је рекао Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Па кад те запита после син твој говорећи: Каква су то сведочанства и уредбе и закони, што вам је заповедио Господ Бог наш? ");
INSERT INTO srp1868_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Онда кажи сину свом: Бејасмо робови Фараонови у Мисиру, и изведе нас Господ из Мисира руком крепком, ");
INSERT INTO srp1868_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","и учини Господ знаке и чудеса велика и зла у Мисиру на Фараону и на свему дому његовом пред нама, ");
INSERT INTO srp1868_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","а нас изведе оданде да нас уведе у земљу за коју се заклео оцима нашим да ће нам је дати. ");
INSERT INTO srp1868_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","И заповеди нам Господ да вршимо све ове уредбе бојећи се Господа Бога свог, да би нам било добро свагда и да би нас сачувао у животу, као што се види данас. ");
INSERT INTO srp1868_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","И биће нам правда, ако уздржимо и устворимо све заповести ове пред Господом Богом својим како нам је заповедио. ");
INSERT INTO srp1868_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Кад те Господ Бог твој уведе у земљу у коју идеш да је наследиш, и отера испред тебе народе многе, Хетеје и Гергесеје и Амореје и Хананеје и Ферезеје и Јевеје и Јевусеје, седам народа већих и јачих од тебе, ");
INSERT INTO srp1868_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","и преда их Господ Бог твој теби, и ти их разбијеш, потри их, не хватај с њима вере, нити се смилуј на њих; ");
INSERT INTO srp1868_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","нити се пријатељи с њима; кћери своје не дај за сина њиховог, нити кћери њихове узимај за сина свог. ");
INSERT INTO srp1868_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Јер би отпадила сина твог од мене, и служио би боговима другим, те би се разгневио Господ на вас и потро вас брзо. ");
INSERT INTO srp1868_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Него им ово учините: олтаре њихове раскопајте, и ликове њихове поломите, лугове њихове исеците, и резане богове њихове огњем спалите. ");
INSERT INTO srp1868_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Јер си ти народ свет Господу Богу свом, тебе је изабрао Господ Бог твој да му будеш народ особит мимо све народе на земљи. ");
INSERT INTO srp1868_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Не зато што би вас било више него других народа прихвати вас Господ и изабра вас; јер вас беше мање него иког другог народа; ");
INSERT INTO srp1868_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","него што вас Господ милује и што држи заклетву којом се заклео оцима вашим, зато вас је Господ извео руком крепком и избавио вас из куће ропске, из руке Фараона, цара мисирског. ");
INSERT INTO srp1868_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","И тако знај да је Господ Бог твој Бог, Бог веран, који држи завет свој и милост своју до хиљаду колена онима који Га љубе и држе заповести Његове, ");
INSERT INTO srp1868_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","и плаћа онима који мрзе на њ, свакоме истребљујући га, и не одгађа ономе који мрзи на њ, плаћа свакоме. ");
INSERT INTO srp1868_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Зато држи заповести и уредбе и законе, које ти данас ја заповедам, да их твориш. ");
INSERT INTO srp1868_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","И ако ове законе узаслушате и уздржите и устворите и Господ ће Бог држати теби завет и милост, за коју се заклео оцима твојим; ");
INSERT INTO srp1868_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","и миловаће те и благословиће те и умножиће те; благословиће плод утробе твоје и плод земље твоје, жито твоје и вино твоје и уље твоје, плод говеда твојих и стада оваца твојих у земљи за коју се заклео оцима твојим да ће ти је дати. ");
INSERT INTO srp1868_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Бићеш благословен мимо све народе: неће бити у теби ни мушког ни женског неплодног, ни међу стоком твојом. ");
INSERT INTO srp1868_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","И уклониће од тебе Господ сваку болест, од љутих зала мисирских која знаш неће ниједно пустити на тебе, него ће пустити на оне који мрзе на те. ");
INSERT INTO srp1868_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","И истреби све народе које ти Господ Бог твој преда, нека их не пожали око твоје, и немој служити боговима њиховим, јер би ти то била замка. ");
INSERT INTO srp1868_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ако би рекао у срцу свом: Већи су ови народи од мене, како их могу изгнати? ");
INSERT INTO srp1868_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Не бој их се; памти добро шта је учинио Господ Бог твој с Фараоном и са свим Мисирцима, ");
INSERT INTO srp1868_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","велика кушања, која видеше очи твоје, и знаке и чудеса и руку крепку и мишицу подигнуту, којом те изведе Господ Бог твој; онако ће учинити Господ Бог твој са свим народима од којих би се уплашио. ");
INSERT INTO srp1868_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","И стршљене ће послати Господ Бог твој на њих докле не изгину који би остали и сакрили се од тебе. ");
INSERT INTO srp1868_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Не плаши се од њих, јер је Господ Бог твој усред тебе, Бог велики и страшни. ");
INSERT INTO srp1868_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Господ ће Бог твој мало по мало потрти те народе испред тебе; нећеш их моћи одједанпут истребити, да се не би умножило на тебе зверје пољско. ");
INSERT INTO srp1868_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Али ће их предати Господ Бог твој теби, и затираће их затирањем великим докле се не затру. ");
INSERT INTO srp1868_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","И предаће цареве њихове у твоје руке да затреш име њихово под небом, неће се ниједан одржати пред тобом, докле их не потреш. ");
INSERT INTO srp1868_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Резане богове њихове спали огњем, немој да се полакомиш на сребро или злато што је на њима и да га узмеш, да ти не буде замка, јер је гадно пред Господом Богом твојим. ");
INSERT INTO srp1868_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","И немој да унесеш гада у дом свој, да не будеш проклет као и он, него се гади на њ и грози се од њега, јер је проклето. ");
INSERT INTO srp1868_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Држите и творите све заповести које вам ја заповедам данас, да бисте живи били и умножили се, и да бисте ушли у земљу за коју се Господ заклео оцима вашим, и да бисте је наследили. ");
INSERT INTO srp1868_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","И опомињи се свега пута којим те је водио Господ Бог твој четрдесет година по пустињи, да би те намучио и искушао, да се зна шта ти је у срцу, хоћеш ли држати заповести Његове или нећеш. ");
INSERT INTO srp1868_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","И мучио те је, глађу те морио; али те је опет хранио маном за коју ти ниси знао ни оци твоји, да би ти показао да човек не живи о самом хлебу него о свему што излази из уста Господњих. ");
INSERT INTO srp1868_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Одело твоје не оветша на теби нити нога твоја отече за ових четрдесет година; ");
INSERT INTO srp1868_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","зато познај у срцу свом да те Господ Бог твој гаји као што човек гаји своје дете. ");
INSERT INTO srp1868_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","И држи заповести Господа Бога свог ходећи путевима Његовим и бојећи се Њега. ");
INSERT INTO srp1868_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Јер Господ Бог твој увешће те сада у добру земљу, у земљу у којој има доста потока и извора и језера, што извиру по долинама и по брдима; ");
INSERT INTO srp1868_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","у земљу изобилну пшеницом и јечмом и виновом лозом и смоквама и шипцима, земљу изобилну маслином, од које бива уље, и медом; ");
INSERT INTO srp1868_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","у земљу где нећеш сиротињски јести хлеба, где ти неће ништа недостајати; у земљу где је камење гвожђе и где ћеш из брда њених сећи бронзу. ");
INSERT INTO srp1868_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Јешћеш и бићеш сит, па благосиљај Господа Бога свог за добру земљу коју ти да. ");
INSERT INTO srp1868_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","И чувај се да не заборавиш Господа Бога свог бацивши у немар заповести Његове и законе Његове и уредбе Његове, које ти ја заповедам данас. ");
INSERT INTO srp1868_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","И кад узједеш и наситиш се, и добре куће начиниш и у њима станеш живети, и кад се говеда твоја и овце твоје наплоде, ");
INSERT INTO srp1868_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","и кад ти се намножи сребро и злато, и шта год имаш кад ти се намножи, ");
INSERT INTO srp1868_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","немој да се понесе срце твоје и заборавиш Господа Бога свог, који те је извео из земље мисирске, из куће ропске; ");
INSERT INTO srp1868_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","који те је водио преко оне пустиње велике и страшне где живе змије ватрене и скорпије, где је суша, а нема воде; који ти је извео воду из тврдог камена; ");
INSERT INTO srp1868_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","који те је хранио у пустињи маном, за коју не знаше оци твоји, да би те намучио и искушао те, и најпосле да би ти добро учинио. ");
INSERT INTO srp1868_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Нити говори у срцу свом; моја снага, и сила моје руке добавила ми је ово благо. ");
INSERT INTO srp1868_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Него се опомињи Господа Бога свог; јер ти Он даје снагу да добављаш благо, да би потврдио завет свој, за који се заклео оцима твојим, као што се види данас. ");
INSERT INTO srp1868_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ако ли заборавиш Господа Бога свог, и пођеш за другим боговима и њима станеш служити и клањати се, сведочим вам данас да ћете зацело пропасти. ");
INSERT INTO srp1868_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Пропашћете као народи које Господ потире испред вас, јер не послушасте глас Господа Бога свог. ");
INSERT INTO srp1868_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Чуј, Израиљу! Ти данас прелазиш преко Јордана да уђеш и наследиш народе веће и јаче од себе, градове велике и ограђене до неба. ");
INSERT INTO srp1868_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Велик и висок народ, синове Енакове, које знаш и за које си слушао: ");
INSERT INTO srp1868_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Знај дакле данас да је Господ Бог твој, који иде пред тобом, огањ који спаљује; Он ће их истребити и Он ће их оборити пред тобом, и изгнаћеш их и истребити брзо, као што ти је казао Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Кад их Господ Бог твој отера испред тебе, немој да кажеш у срцу свом: За правду моју уведе ме Господ у ову земљу да је наследим; јер Господ тера оне народе испред тебе за неваљалство њихово! ");
INSERT INTO srp1868_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Не идеш за правду своју ни за чистоту срца свог да наследиш ту земљу; него за неваљалство тих народа Господ Бог твој отера их испред тебе, и да одржи реч за коју се заклео оцима твојим, Авраму, Исаку и Јакову. ");
INSERT INTO srp1868_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Знај, дакле, да ти Господ Бог твој не даје те добре земље за правду твоју да је наследиш, јер си тврдоврат народ. ");
INSERT INTO srp1868_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Памти и не заборави како си гневио Господа Бога свог у пустињи; од оног дана кад изиђосте из земље мисирске па докле дођосте на ово место, непокорни бејасте Господу. ");
INSERT INTO srp1868_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","И код Хорива разгневисте Господа, и од гнева хтеде вас Господ да истреби. ");
INSERT INTO srp1868_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Кад изиђох на гору да примим плоче камене, плоче завета, који с вама учини Господ, тада стајах на гори четрдесет дана и четрдесет ноћи хлеба не једући ни воде пијући. ");
INSERT INTO srp1868_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","И даде ми Господ две плоче камене, исписане прстом Господњим, на којима беху речи све које вам изговори Господ на гори исред огња на дан збора вашег. ");
INSERT INTO srp1868_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","После четрдесет дана и четрдесет ноћи даде ми Господ две плоче камене, плоче заветне. ");
INSERT INTO srp1868_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","И рече ми Господ: Устани, сиђи брже одавде; јер се поквари народ твој који си извео из Мисира, сиђоше брзо с пута који им заповедих, и начинише себи ливен лик. ");
INSERT INTO srp1868_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Још ми рече Господ говорећи: Погледах овај народ, и ето је народ тврдог врата. ");
INSERT INTO srp1868_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Пусти ме да их истребим и име њихово затрем под небом; а од тебе ћу учинити народ јачи и већи него што је овај. ");
INSERT INTO srp1868_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","И ја се вратих и сиђох с горе, а гора огњем гораше, и две плоче заветне беху ми у рукама. ");
INSERT INTO srp1868_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","И погледах, а то згрешисте Господу Богу свом саливши себи теле, и брзо сиђосте с пута који вам беше заповедио Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Тада узех оне две плоче и бацих их из руку својих, и разбих их пред вама. ");
INSERT INTO srp1868_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Потом падох и лежах пред Господом као пре, четрдесет дана и четрдесет ноћи, хлеба не једући ни воде пијући, ради свих греха ваших, којима се огрешисте учинивши што је зло пред Господом и разгневивши Га. ");
INSERT INTO srp1868_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Јер се бојах гнева и јарости, којом се беше Господ разљутио на вас да вас истреби; и услиши ме Господ и тада. ");
INSERT INTO srp1868_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Беше се Господ и на Арона разгневио веома да га хтеде убити; али се молих тада и за Арона. ");
INSERT INTO srp1868_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","И узех грех ваш који учинисте, теле, и сажегох га огњем, и разбих га и сатрх га у прах, и просух прах његов у поток, који тече с оне горе. ");
INSERT INTO srp1868_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","И у Тавери и у Маси и у Киврот-Атави гневисте Господа. ");
INSERT INTO srp1868_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","И кад вас посла Господ у Кадис-Варнију говорећи: Идите и узмите ту земљу коју сам вам дао, опет се супротисте речи Господа Бога свог, и не веровасте Му и не послушасте глас Његов. ");
INSERT INTO srp1868_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Непокорни бејасте Господу од кад вас познах. ");
INSERT INTO srp1868_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Зато падох и лежах пред Господом четрдесет дана и четрдесет ноћи, јер беше рекао Господ да ће вас потрти. ");
INSERT INTO srp1868_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","И молих се Господу и рекох: Господе, Господе! Немој потрти народ свој и наследство своје, које си избавио величанством својим, које си извео из Мисира крепком руком. ");
INSERT INTO srp1868_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Опомени се слуга својих Аврама, Исака и Јакова, не гледај на тврђу народа овог, на неваљалство његово и на грехе његове; ");
INSERT INTO srp1868_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","да не кажу који живе у земљи одакле си нас извео: Није их могао Господ увести у земљу коју им обећа, или мрзео је на њих, зато их изведе да их побије у пустињи. ");
INSERT INTO srp1868_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Јер су Твој народ и Твоје наследство, које си извео силом својом великом и мишицом својом подигнутом. ");
INSERT INTO srp1868_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","У то време рече ми Господ: Истеши две поче од камена као што беху прве, и изиђи к мени на гору, и начини ковчег од дрвета. ");
INSERT INTO srp1868_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","И написаћу на тим плочама речи које су биле на првим плочама што си их разбио, па ћеш их метнути у ковчег. ");
INSERT INTO srp1868_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Тако начиних ковчег од дрвета ситима, и истесах две плоче од камена, као што беху прве, и изиђох на гору с двема плочама у рукама. ");
INSERT INTO srp1868_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","И написа на тим плочама шта беше прво написао, десет речи, које вам изговори Господ на гори исред огња на дан збора вашег; и даде ми их Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","И вративши се сиђох с горе, и метнух плоче у ковчег који начиних, и осташе онде, као што ми заповеди Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","А синови Израиљеви пођоше од Вирота, синова Јаканових у Мосеру. Онде умре Арон и онде би погребен; а Елеазар, син његов поста свештеник на његово место. ");
INSERT INTO srp1868_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Оданде отидоше у Гадгад, а од Гадгада у Јотвату, земљу где има много потока. ");
INSERT INTO srp1868_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","У то време одвоји Господ племе Левијево да носе ковчег завета Господњег, да стоје пред Господом и служе му и да благосиљају у име Његово до данашњег дана. ");
INSERT INTO srp1868_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Зато нема племе Левијево део ни наследство с браћом својом; Господ је наследство његово, као што му Господ Бог твој каза. ");
INSERT INTO srp1868_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","А ја стајах на гори као пре, четрдесет дана и четрдесет ноћи; и услиши ме Господ и тада, и не хте те Господ затрти, ");
INSERT INTO srp1868_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","него ми рече Господ: Устани и иди пред народом овим да уђу у земљу за коју сам се заклео оцима њиховим да ћу им је дати да је наследе. ");
INSERT INTO srp1868_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Сада, дакле, Израиљу, шта иште од тебе Господ Бог твој, осим да се бојиш Господа Бога свог, да ходиш по свим путевима Његовим и да Га љубиш и служиш Господу Богу свом из свег срца свог и из све душе своје, ");
INSERT INTO srp1868_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","држећи заповести Господње и уредбе Његове, које ти ја данас заповедам, да би ти било добро? ");
INSERT INTO srp1868_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Гле, Господа је Бога твог небо, и небо над небесима, земља, и све што је на њој. ");
INSERT INTO srp1868_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Али само твоји оци омилеше Господу, и изабра семе њихово након њих, вас између свих народа, као што се види данас. ");
INSERT INTO srp1868_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Зато обрежите срце своје, и немојте више бити тврдоврати. ");
INSERT INTO srp1868_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Јер је Господ Бог ваш Бог над боговима и Господар над господарима, Бог велики, силни и страшни, који не гледа ко је ко нити прима поклона; ");
INSERT INTO srp1868_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","даје правицу сироти и удовици; и љуби дошљака дајући му хлеб и одело. ");
INSERT INTO srp1868_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Љубите дакле дошљака, јер сте били дошљаци у земљи мисирској. ");
INSERT INTO srp1868_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Бој се Господа Бога свог, Њему служи и Њега се држи, и Његовим се именом куни. ");
INSERT INTO srp1868_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Он је хвала твоја и Он је Бог твој, који тебе ради учини велике и страшне ствари, које видеше очи твоје. ");
INSERT INTO srp1868_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Седамдесет душа беше отаца твојих кад сиђоше у Мисир; а сада учини ти Господ Бог твој те вас има много као звезда небеских. ");
INSERT INTO srp1868_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Љуби, дакле, Господа Бога свог, и извршуј једнако шта је заповедио да извршујеш, и уредбе Његове, и законе Његове и заповести Његове. ");
INSERT INTO srp1868_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","И познајте данас шта ваши синови не знају нити видеше, карање Господа Бога свог, величанство Његово, крепку руку Његову и мишицу Његову подигнуту, ");
INSERT INTO srp1868_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","и знаке Његове и дела Његова, шта учини усред Мисира на Фараону, цару мисирском и на свој земљи његовој, ");
INSERT INTO srp1868_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","и шта учини војсци мисирској, коњима и колима њиховим, како учини, те их вода црвеног мора потопи кад вас тераху, и затре их Господ до данашњег дана, ");
INSERT INTO srp1868_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","и шта вама учини у пустињи докле не дођосте до овог места, ");
INSERT INTO srp1868_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","и шта учини Датану и Авирону, синовима Елијава сина Рувимовог, како земља отвори уста своја и прождре њих и породице њихове и шаторе њихове и све благо њихово што имаху, усред Израиља. ");
INSERT INTO srp1868_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Јер ваше очи видеше сва дела Господња велика, која учини. ");
INSERT INTO srp1868_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Зато држите све заповести, које вам ја данас заповедам, да бисте се укрепили и наследили земљу, у коју идете да је наследите; ");
INSERT INTO srp1868_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","и да би вам се продужили дани у земљи, за коју се закле оцима вашим да ће је дати њима и семену њиховом, земљу, у којој тече млеко и мед. ");
INSERT INTO srp1868_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Јер земља у коју идеш да је наследиш није као земља мисирска из које сте изишли, где си сејао своје семе и заливао на својим ногама као врт од зеља; ");
INSERT INTO srp1868_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","него је земља у коју идете да је наследите земља у којој су брда и долине, и натапа је дажд небески; ");
INSERT INTO srp1868_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","земља којом се стара Господ Бог твој и на коју су једнако обраћене очи Господа Бога твог од почетка године до краја. ");
INSERT INTO srp1868_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Зато ако добро узаслушате заповести, које вам ја заповедам данас, љубећи Господа Бога свог и служећи му свим срцем својим и свом душом својом, ");
INSERT INTO srp1868_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","тада ћу давати дажд земљи вашој на време, и рани и позни и сабираћеш жито своје и вино своје и уље своје; ");
INSERT INTO srp1868_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","и за стоку ћу твоју дати траву у пољу твом; и јешћеш и бићеш сит. ");
INSERT INTO srp1868_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Чувајте се да се не превари срце ваше да се одметне и служите туђим боговима и поклањате им се; ");
INSERT INTO srp1868_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","да се не би разгневио Господ на вас и затворио небо да не буде дажда, и земља да не да рода свог, те бисте брзо изгинули у доброј земљи коју вам Господ даје. ");
INSERT INTO srp1868_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Него сложите ове речи моје у срце своје и душу своју, и вежите их за знак себи на руку, и нека вам буду као почеоник међу очима вашим. ");
INSERT INTO srp1868_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","И учите синове своје говорећи о њима кад седиш у кући својој и кад идеш путем, и кад лежеш и кад устајеш. ");
INSERT INTO srp1868_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","И напиши их на довратницима дома свог и на вратима својим, ");
INSERT INTO srp1868_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","да би се умножили дани ваши и дани синова ваших по земљи, за коју се заклео Господ оцима вашим да ће им је дати, као дани небу над земљом. ");
INSERT INTO srp1868_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Јер ако добро уздржите све ове заповести које вам ја заповедам да творите љубећи Господа Бога свог, и ходећи свим путевима Његовим и Њега се држећи, ");
INSERT INTO srp1868_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","тада ће отерати Господ све ове народе испред вас, и наследићете народе веће и јаче него што сте сами. ");
INSERT INTO srp1868_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Свако место на које ступи стопало ноге ваше, ваше ће бити; од пустиње до Ливана, и од реке, реке Ефрата, до мора западног биће међа ваша. ");
INSERT INTO srp1868_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Неће се нико одржати пред вама; страх и трепет ваш пустиће Господ Бог ваш на сву земљу на коју ступите, као што вам каза. ");
INSERT INTO srp1868_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Гле, износим данас пред вас благослов и проклетство: ");
INSERT INTO srp1868_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Благослов, ако узаслушате заповести Господа Бога свог, које вам ја данас заповедам; ");
INSERT INTO srp1868_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","а проклетство, ако не узаслушате заповести Господа Бога свог него сиђете с пута, који вам ја данас заповедам, те пођете за другим боговима, којих не познајете. ");
INSERT INTO srp1868_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","И кад те уведе Господ Бог твој у земљу у коју идеш да је наследиш, тада изреци благослов онај на гори Гаризину, а проклетство на гори Евалу. ");
INSERT INTO srp1868_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Оне су с оне стране Јордана, идући к западу, у земљи Хананеја који живе у равни према Галгалу код равнице морешке. ");
INSERT INTO srp1868_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Јер ћете прећи преко Јордана да уђете у земљу коју вам даје Господ Бог ваш да је наследите, и наследићете је и наставаћете у њој. ");
INSERT INTO srp1868_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Гледајте, дакле, да творите све ове уредбе и законе које ја данас износим пред вас. ");
INSERT INTO srp1868_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ово су уредбе и закони које ћете држати и творити у земљи коју ти је Господ Бог отаца твојих дао да је наследиш, докле сте год живи на земљи. ");
INSERT INTO srp1868_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Раскопајте сасвим сва места у којима су служили боговима својим народи које ћете наследити, по високим брдима и по хумовима и под сваким зеленим дрветом. ");
INSERT INTO srp1868_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Оборите олтаре њихове и разбијте ликове њихове, и лугове њихове попалите огњем, и резане богове њихове изломите, и истребите име њихово са оног места. ");
INSERT INTO srp1868_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Не чините тако Господу Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Него Га тражите у месту које изабере Господ Бог ваш између свих племена ваших себи за стан да онде намести име своје, и онамо идите. ");
INSERT INTO srp1868_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Онамо носите жртве своје паљенице и друге жртве своје и десетке своје и приносе руку својих и завете своје и драговољне приносе своје и првине стоке своје крупне и ситне. ");
INSERT INTO srp1868_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","И једите онде пред Господом Богом својим, и веселите се ви и породице ваше свачим, за шта се прихватите руком својом, чим те благослови Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Не чините како ми сада овде чинимо, шта је коме драго. ");
INSERT INTO srp1868_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Јер још нисте дошли до одмора и наследства, које ти даје Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Него кад пређете преко Јордана, и станете живети у земљи коју вам даје Господ Бог ваш да је наследите, и смири вас од свих непријатеља ваших унаоколо, те станете живети без страха, ");
INSERT INTO srp1868_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","онда у место које изабере Господ Бог ваш да у њему настани име своје, донесите све што вам ја заповедам, жртве своје паљенице и друге жртве своје, десетке своје и приносе руку својих и све што буде најбоље у ономе што заветујете Господу. ");
INSERT INTO srp1868_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","И веселите се пред Господом Богом својим ви и синови ваши и кћери ваше и слуге ваше и слушкиње ваше, и Левит који је у месту вашем, јер он нема део ни наследство с вама. ");
INSERT INTO srp1868_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Чувај се да не приносиш жртава својих паљеница на коме год месту, које угледаш; ");
INSERT INTO srp1868_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","него на оном месту које изабере Господ Бог у једном од твојих племена, онде приноси жртве своје паљенице, и онде чини све што ти заповедам. ");
INSERT INTO srp1868_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Али ћеш моћи клати и јести месо како ти душа зажели у сваком месту свом по благослову Господа Бога свог, који ти да; чист и нечист може јести као срну и јелена. ");
INSERT INTO srp1868_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Само крв не једите; пролијте је на земљу као воду. ");
INSERT INTO srp1868_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Нећеш моћи јести у месту свом десетка од жита свог ни од вина свог ни од уља свог, ни првина од стоке своје крупне и ситне, ни оног што заветујеш; ни приноса драговољних, ни приноса руку својих. ");
INSERT INTO srp1868_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Него то једи пред Господом Богом својим на месту које изабере Господ Бог твој, ти, син твој и кћи твоја и слуга твој и слушкиња твоја, и Левит који је у месту твом; и весели се пред Господом Богом својим свачим за шта се прихватиш руком. ");
INSERT INTO srp1868_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Чувај се да не оставиш Левита док си год жив на земљи. ");
INSERT INTO srp1868_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Кад рашири Господ Бог твој међе твоје, као што ти је казао, ако кажеш: Да једем меса, кад душа твоја жели да једе меса, једи меса по свој жељи душе своје. ");
INSERT INTO srp1868_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Ако би било далеко од тебе место које Господ Бог твој изабере да онде намести име своје, закољи од стоке своје крупне или ситне, коју ти да Господ, као што сам ти заповедио, и једи у свом месту по жељи душе своје. ");
INSERT INTO srp1868_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Како се једе срна и јелен, онако једи; и чист и нечист нека једе. ");
INSERT INTO srp1868_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Само пази да не једеш крв; јер је крв душа, па не једи душу с месом. ");
INSERT INTO srp1868_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Не једи је; него пролиј на земљу као воду. ");
INSERT INTO srp1868_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Не једи је, да би добро било теби и синовима твојим након тебе, кад чиниш оно што је угодно Господу. ");
INSERT INTO srp1868_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Али ствари своје свете, које имаш, и што заветујеш, узми и дођи на место које изабере Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","И принеси жртве своје паљенице, месо и крв, на олтару Господа Бога свог; крв пак од других жртава твојих нека се пролије на олтар Господа Бога твог, а месо једи. ");
INSERT INTO srp1868_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Чувај и слушај све ове речи које ти ја заповедам, да би добро било теби и синовима твојим након тебе довека кад чиниш шта је добро и право пред Господом Богом твојим. ");
INSERT INTO srp1868_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Кад истреби Господ Бог твој испред тебе народе ка којима идеш да наследиш земљу њихову, и наследивши је кад се настаниш у земљи њиховој, ");
INSERT INTO srp1868_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","чувај се да се не ухватиш у замку пошавши за њима пошто се потру испред тебе, и да не потражиш богове њихове, и кажеш: Како су ови народи служили својим боговима, тако ћу и ја чинити. ");
INSERT INTO srp1868_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Не чини тако Господу Богу свом; јер они чинише својим боговима све што је гадно пред Господом и на шта Он мрзи; јер су и синове своје и кћери своје сажизали боговима својим. ");
INSERT INTO srp1868_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Шта вам год ја заповедам све држите и творите, нити шта додајте к томе ни одузмите од тога. ");
INSERT INTO srp1868_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Ако устане међу вама пророк или који сне сања, и каже ти знак или чудо, ");
INSERT INTO srp1868_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","па се збуде тај знак или чудо које ти рече, и он ти каже: Хајде да идемо за другим боговима којих не знаш, и њима да служимо, ");
INSERT INTO srp1868_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","немој послушати шта ти каже тај пророк или сањач, јер вас куша Господ Бог ваш да би се знало љубите ли Господа Бога свог из свег срца свог и све душе своје. ");
INSERT INTO srp1868_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","За Господом Богом својим идите, и Њега се бојте; Његове заповести чувајте, и глас Његов слушајте, и Њему служите и Њега се држите. ");
INSERT INTO srp1868_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","А онај пророк или сањач да се погуби, јер вас је наговарао да се одметнете Господа Бога свог, који вас изведе из земље мисирске и искупи вас из куће ропске, и одвраћао од пута који ти је заповедио Господ Бог твој да идеш њим; тако истреби зло из себе. ");
INSERT INTO srp1868_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Ако би те подбадао брат твој, син матере твоје, или син твој или кћи твоја, или жена твоја мила, или пријатељ твој који ти је као душа твоја, говорећи ти тајно: Хајде да служимо другим боговима, које ниси знао ни ти ни оци твоји, ");
INSERT INTO srp1868_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","између богова других народа који су око вас, близу или далеко од тебе, од једног краја земље до другог, ");
INSERT INTO srp1868_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","не пристај с њим нити га послушај; нека га не жали око твоје, и немој му се смиловати нити га таји, ");
INSERT INTO srp1868_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","него га убиј: твоја рука нек се прва дигне на њ да га убијеш, па онда рука свега народа. ");
INSERT INTO srp1868_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Заспи га камењем да погине; јер те хтеде одвратити од Господа Бога твог, који те је извео из земље мисирске, из куће ропске; ");
INSERT INTO srp1868_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","да сав Израиљ чује и боји се, и да се више не учини тако зло међу вама. ");
INSERT INTO srp1868_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Ако за какав град свој, који ти Господ Бог твој да да у њему живиш, чујеш где говоре: ");
INSERT INTO srp1868_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","Изиђоше људи неваљали између тебе и отпадише све који живе у граду њиховом, говорећи: Хајде да служимо другим боговима, којих не познајете, ");
INSERT INTO srp1868_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","тада тражи и распитај, извиди добро, па ако буде истина и доиста се учинила она гадна ствар међу вама, ");
INSERT INTO srp1868_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","побиј мачем све који живе у граду оном, и затри и њега и све што би у њему било, и стоку мачем побиј. ");
INSERT INTO srp1868_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","И сав плен из њега скупи насред улице његове, спали огњем и онај град и сав плен из њега Господу Богу свом, да буде гомила довека и да се више не сазида. ");
INSERT INTO srp1868_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","И нека ти од проклетих ствари не прионе ништа за руку, еда би се Господ повратио од жестине гнева свог, учинио ти милост и смиловао се на те, и умножио те, као што се заклео оцима твојим, ");
INSERT INTO srp1868_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","кад слушаш глас Господа Бога свог држећи све заповести Његове, које ти ја данас заповедам, да би чинио шта је право пред Господом Богом твојим. ");
INSERT INTO srp1868_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Ви сте синови Господа Бога свог; немојте се резати нити бријати међу очима за мртвацем. ");
INSERT INTO srp1868_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Јер си народ свет Господу Богу свом, и тебе изабра Господ да си му народ особит између свих народа на земљи. ");
INSERT INTO srp1868_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Не једи ништа гадно. ");
INSERT INTO srp1868_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ово су животиње које ћете јести: говече, овцу, козу, ");
INSERT INTO srp1868_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","јелена, срну, бивола, дивокозу, једнорога и козу камењачу; ");
INSERT INTO srp1868_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","и све животиње које имају папке расцепљене на двоје, и које преживају између животиња, њих једите. ");
INSERT INTO srp1868_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Али не једите оне које само преживају или које само имају папке расцепљене на двоје, као: камилу, зеца, питомог зеца, јер преживају, а немају папке раздвојене; да вам је нечисто; ");
INSERT INTO srp1868_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ни свињче, јер има раздвојене папке, али не прежива; да вам је нечисто; месо од њега не једите, и стрва се његовог не дохватајте. ");
INSERT INTO srp1868_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","А између оних што су у води, једите ове: шта год има пера и љуске, једите; ");
INSERT INTO srp1868_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","а што нема пера и љуске, не једите; да вам је нечисто. ");
INSERT INTO srp1868_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Све птице чисте једите; ");
INSERT INTO srp1868_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","а ове не једите: орла, ни јастреба, ни морског орла, ");
INSERT INTO srp1868_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ни сокола, ни еју, ни крагуја по врстама њиховим, ");
INSERT INTO srp1868_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ни гаврана по врстама његовим, ");
INSERT INTO srp1868_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ни ћука, ни совуљагу, ни лиску, ни копца по врстама његовим, ");
INSERT INTO srp1868_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ни буљину, ни ражња, ни лабуда, ");
INSERT INTO srp1868_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ни гема, ни свраку, ни гњурца, ");
INSERT INTO srp1868_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ни роду, ни чапљу по врстама њеним, ни пупавца, ни љиљка. ");
INSERT INTO srp1868_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","И све бубине крилате да су вам нечисте; не једите их. ");
INSERT INTO srp1868_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","И све птице чисте једите. ");
INSERT INTO srp1868_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Ништа мрцино не једите; дошљаку који је код тебе подај нека једе, или продај туђину; јер си народ свет Господу Богу свом. Не кувај јаре у млеку матере његове. ");
INSERT INTO srp1868_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Десетак дај од свега рода усева свог, што дође с њиве твоје сваке године. ");
INSERT INTO srp1868_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","И једи пред Господом Богом својим на месту које изабере да онде настани име своје, десетак од жита свог, од вина свог и уља свог, и првине стоке своје крупне и ситне, да се учиш бојати се Господа Бога свог свагда. ");
INSERT INTO srp1868_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Ако би ти пут био далек, те не би могао однети зато што је далеко од тебе место, које изабере Господ Бог твој да онде намести име своје, кад те Господ Бог твој благослови, ");
INSERT INTO srp1868_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","онда учини у новац, и узевши у руку своју отиди у место које изабере Господ Бог твој, ");
INSERT INTO srp1868_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","и за те новце узми шта зажели душа твоја, говеда, оваца, вина или другог јаког пића, и шта год би зажелела душа твоја, па једи онде пред Господом Богом својим, и весели се ти и дом твој. ");
INSERT INTO srp1868_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Али Левита који би био у месту твом, немој оставити јер нема део ни наследство с тобом. ");
INSERT INTO srp1868_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Сваке треће године одвој сав десетак од доходака својих оне године, и остави га у свом месту. ");
INSERT INTO srp1868_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Па нека дођу Левити (јер немају део ни наследство с тобом) и дошљаци и сироте и удовице што су у месту твом, и нека једу и насите се, да би те благословио Господ Бог твој у сваком послу руку твојих, који би радио. ");
INSERT INTO srp1868_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Сваке седме године опраштај. ");
INSERT INTO srp1868_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","А опраштање да бива овако: коме је ко дужан шта, нека опрости шта би могао тражити од ближњег свог; нека не тражи од ближњег свог и од брата свог, јер је опраштање Господње оглашено. ");
INSERT INTO srp1868_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Од туђина тражи, али шта би имао у брата свог, оно нека му опрости рука твоја, ");
INSERT INTO srp1868_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","да не би било сиромаха међу вама, јер ће те обилно благословити Господ у земљи коју ти Господ Бог твој да у наследство да је твоја. ");
INSERT INTO srp1868_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Само ако добро узаслушаш глас Господа Бога свог гледајући да чиниш све ове заповести, које ти ја заповедам данас, ");
INSERT INTO srp1868_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","благословиће те Господ Бог твој, као што ти је казао, те ћеш давати у зајам многим народима, а ни од кога нећеш узимати у зајам, и владаћеш многим народима, а они тобом неће владати. ");
INSERT INTO srp1868_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Ако буде у тебе који сиромах између браће твоје у коме месту твом, у земљи твојој, коју ти даје Господ Бог твој, немој да ти се стврдне срце твоје и да стиснеш руку своју брату свом сиромаху. ");
INSERT INTO srp1868_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Него отвори руку своју и позајми му радо колико му год треба у потреби његовој. ");
INSERT INTO srp1868_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Чувај се да не буде какво неваљалство у срцу твом, па да кажеш: Близу је седма година, година опросна; и да око твоје не буде зло према брату твом сиромаху, па да му не даш, а он зато да вапије ка Господу на те, и буде ти грех. ");
INSERT INTO srp1868_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Подај му, и нека не жали срце твоје кад му даш; јер ће за ту ствар благословити тебе Господ Бог твој у сваком послу твом и у свему за шта се прихватиш руком својом. ");
INSERT INTO srp1868_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Јер неће бити без сиромаха у земљи; зато ти заповедам и кажем: отварај руку своју брату свом, невољнику и сиромаху свом у земљи својој. ");
INSERT INTO srp1868_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Ако ти се прода брат твој Јеврејин или Јеврејка, нека ти служи шест година, а седме године отпусти га од себе слободног. ");
INSERT INTO srp1868_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","А кад га отпустиш од себе слободног, немој га отпустити празног. ");
INSERT INTO srp1868_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Даруј га чим између стоке своје и с гумна свог и из каце своје; подај му чим те је благословио Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","И опомињи се да си био роб у земљи мисирској и да те је избавио Господ Бог твој; зато ти ја заповедам ово данас. ");
INSERT INTO srp1868_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Ако ли ти каже: Нећу да идем од тебе, зато што те љуби и дом твој, јер му је добро код тебе, ");
INSERT INTO srp1868_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","тада узми шило и пробуши му ухо на вратима, и биће ти слуга довека; и слушкињи својој учини тако. ");
INSERT INTO srp1868_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Немој да ти буде тешко кад га отпушташ од себе слободна, јер је двојином онолико колико најамник заслужио у тебе за шест година, да би те благословио Господ Бог твој у свему што радиш. ");
INSERT INTO srp1868_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Све првенце у стоци својој крупној и ситној што буде мушко, посвети Господу Богу свом; не ради на првенцу од краве своје, и не стрижи првенца од оваца својих. ");
INSERT INTO srp1868_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Пред Господом Богом својим једи их ти и породица твоја сваке године на месту које изабере Господ. ");
INSERT INTO srp1868_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Ако ли на њему буде мана, ако буде хромо или слепо, или која год зла мана буде на њему, не кољи га Господу Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","У свом месту поједи га; и чист и нечист нека једе као срну и јелена. ");
INSERT INTO srp1868_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Само крв од њега не једи; пролиј је на земљу као воду. ");
INSERT INTO srp1868_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Држи месец Авив, те слави пасху Господу Богу свом, јер месеца Авива извео те је Господ Бог твој из Мисира ноћу. ");
INSERT INTO srp1868_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","И закољи пасху Господу Богу свом, од крупне и ситне стоке, на месту које изабере Господ да онде настани име своје. ");
INSERT INTO srp1868_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Не једи с њом хлеб кисели; седам дана једи с њом пресан хлеб, хлеб невољнички, јер си хитећи изашао из земље мисирске, па да се опомињеш дана кад си изашао из Мисира, док си год жив. ");
INSERT INTO srp1868_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","И да се не види у тебе квасац за седам дана нигде међу границама твојим, и да не остане преко ноћ ништа до јутра од меса које закољеш први дан увече. ");
INSERT INTO srp1868_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Не можеш клати пасхе на сваком месту свом које ти да Господ Бог твој; ");
INSERT INTO srp1868_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","него на месту које изабере Господ Бог твој да онде настани име своје, онде кољи пасху увече о сунчаном заходу у исто време кад си пошао из Мисира. ");
INSERT INTO srp1868_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","А пеци је и једи на месту које изабере Господ Бог твој; и сутрадан вративши се иди у своје шаторе. ");
INSERT INTO srp1868_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Шест дана једи пресне хлебове, а седми дан да је празник Господњи, тада не ради ништа. ");
INSERT INTO srp1868_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Седам недеља наброј; кад стане срп радити по летини, онда почни бројати седам недеља. ");
INSERT INTO srp1868_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Тада празнуј празник недеља Господу Богу свом; шта можеш приносити драговољно како те буде благословио Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","И весели се пред Господом Богом својим ти и син твој и кћи твоја и слуга твој и слушкиња твоја, и Левит који буде у месту твом, и дошљак и сирота и удовица, што буду код тебе, на месту које изабере Господ Бог твој да онде настани име своје. ");
INSERT INTO srp1868_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","И опомињи се да си био роб у Мисиру, те чувај и твори уредбе ове. ");
INSERT INTO srp1868_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Празник сеница празнуј седам дана, кад збереш с гумна свог и из каце своје. ");
INSERT INTO srp1868_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","И весели се на празник свој ти и син твој и слуга твој и слушкиња твоја, и Левит и дошљак и сирота и удовица, што буду у месту твом. ");
INSERT INTO srp1868_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Седам дана празнуј празник Господу Богу свом на месту које изабере Господ, кад те благослови Господ Бог твој у свакој летини твојој и у сваком послу руку твојих; и буди весео. ");
INSERT INTO srp1868_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Три пута у години нека дође свако мушко пред Господа Бога твог на место које изабере: на празник пресних хлебова, на празник недеља и на празник сеница, али нико да не дође празан пред Господа; ");
INSERT INTO srp1868_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","него сваки с даром од оног што има, према благослову Господа Бога твог којим те је даривао. ");
INSERT INTO srp1868_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Судије и управитеље постави себи по свим местима која ти да Господ Бог твој по племенима твојим, и нека суде народу право. ");
INSERT INTO srp1868_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Не изврћи правде и не гледај ко је ко; не примај поклона, јер поклон заслепљује очи мудрима и изврће речи праведнима. ");
INSERT INTO srp1868_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Сасвим иди за правдом, да би био жив и наследио земљу коју ти даје Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Не сади луга ни од каквих дрвета код олтара Господа Бога свог, који начиниш; ");
INSERT INTO srp1868_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","и не подижи никакав лик; на то мрзи Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Не приноси Господу Богу свом ни вола ни јагњета ни јарета на коме има мана или како год зло; јер је гадно пред Господом Богом твојим. ");
INSERT INTO srp1868_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Ако се нађе код тебе у коме од места твојих, која ти да Господ Бог твој, човек или жена да учини зло пред Господом Богом твојим преступајући завет Његов, ");
INSERT INTO srp1868_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","и отиде те служи другим боговима и клања им се, или сунцу или месецу или чему год из војске небеске, што нисам заповедио, ");
INSERT INTO srp1868_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","и теби се то јави и ти чујеш, онда распитај добро; па ако буде истина и доиста се учинила она гадна ствар у Израиљу, ");
INSERT INTO srp1868_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","изведи оног човека или ону жену, који учинише оно зло, на врата своја, човека оног или жену, и заспи их камењем да погину. ");
INSERT INTO srp1868_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","На сведочанство два или три човека да се погуби онај кога ваља погубити; али на сведочанство једног човека да се не погуби. ");
INSERT INTO srp1868_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Сведоци нека први дигну руке на њ да га убију; а потом сав народ; тако извади зло из себе. ");
INSERT INTO srp1868_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Кад ти буде тешко расудити између крви и крви, између распре и распре, или између ране и ране, око којих буде парница у твом месту, тада устани и иди у место које изабере Господ Бог твој; ");
INSERT INTO srp1868_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","и отиди к свештеницима Левитима или к судији који онда буде, па их упитај, и они ће ти казати како ваља пресудити. ");
INSERT INTO srp1868_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","И учини онако како ти кажу у месту које изабере Господ, и гледај да учиниш сасвим онако како те науче. ");
INSERT INTO srp1868_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","По закону коме те науче, и по пресуди, коју ти кажу, учини; не одступи од оног што ти кажу ни надесно ни налево. ");
INSERT INTO srp1868_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Ако ли би се ко упро те не би хтео послушати свештеника који онде стоји те служи Господу Богу твом, или судије, такав човек да се погуби; и извади зло из Израиља, ");
INSERT INTO srp1868_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","да сав народ чује и боји се, и унапред, да не ради упорно. ");
INSERT INTO srp1868_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Кад уђеш у земљу коју ти даје Господ Бог твој да је наследиш, и населиш се у њој, ако кажеш: Да поставим себи цара, као што имају сви народи око мене, ");
INSERT INTO srp1868_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","само оног постави себи за цара, ког изабере Господ Бог твој; између браће своје постави цара себи; а немој поставити над собом човека туђина, који није брат твој. ");
INSERT INTO srp1868_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Али да не држи много коња, и да не враћа народ у Мисир да би имао много коња, јер вам је Господ казао: Не враћајте се више овим путем. ");
INSERT INTO srp1868_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","И да нема много жена, да се не би отпадило срце његово, ни сребра ни злата да нема врло много. ");
INSERT INTO srp1868_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","А кад седе на престо царства свог, нека препише себи у књигу овај закон од свештеника Левита; ");
INSERT INTO srp1868_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","и нека га држи код себе и нека га чита док је жив, да се учи бојати се Господа Бога свог, држати све речи овог закона и ове уредбе, и творити их; ");
INSERT INTO srp1868_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","да се не би подигло срце његово изнад браће његове, и да не би одступило од ове заповести ни надесно ни налево, да би дуго царовао он и синови његови у Израиљу. ");
INSERT INTO srp1868_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Свештеници, Левити и све племе Левијево да немају део ни наследство с осталим синовима Израиљевим; нека једу огњене жртве Господње и његово наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Наследство, дакле, да немају међу браћом својом: Господ је наследство њихово, као што им је казао. ");
INSERT INTO srp1868_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Али ово припада свештеницима од народа, од оних који принесу жртву, било вола или јагње: да се даје свештенику плеће и обе вилице и желудац. ");
INSERT INTO srp1868_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Првине од жита свог, од вина свог и од уља свог, и првине од вуне с оваца својих подај му. ");
INSERT INTO srp1868_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Јер њега изабра Господ Бог твој између свих племена твојих да стоји и служи у име Господње он и синови његови довека. ");
INSERT INTO srp1868_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","И кад дође који Левит из ког год места твог из свега Израиља, где настава, кад дође по жељи душе своје у место које изабере Господ, ");
INSERT INTO srp1868_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","нека служи у име Господа Бога свог као и друга браћа, његова Левити, који онде стоје пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Нека једу једнак део, осим оног што би које продао у породици отаца својих. ");
INSERT INTO srp1868_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Кад уђеш у земљу коју ти Господ Бог твој даје, не учи се чинити гадна дела оних народа. ");
INSERT INTO srp1868_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Нека се не нађе у тебе који би водио сина свог или кћер своју кроз огањ, ни врачар, ни који гата по звездама, ни који гата по птицама, ни урочник, ");
INSERT INTO srp1868_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ни бајач, ни који се договара са злим духовима, ни опсенар ни који пита мртве. ");
INSERT INTO srp1868_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Јер је гад пред Господом ко год тако чини, и за такве гадове тера те народе Господ Бог твој испред тебе. ");
INSERT INTO srp1868_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Држи се сасвим Господа Бога свог. ");
INSERT INTO srp1868_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Јер ти народи које ћеш наследити, слушају гатаре и врачаре; а теби то не допушта Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Пророка исред тебе, између браће твоје, као што сам ја, подигнуће ти Господ Бог твој; њега слушајте, ");
INSERT INTO srp1868_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","по свему што си искао од Господа Бога свог на Хориву на дан сабора свог говорећи: Да више не чујем глас Господа Бога свог и да више не гледам огањ тај велики, да не погинем. ");
INSERT INTO srp1868_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Зато ми рече Господ: Добро рекоше шта рекоше. ");
INSERT INTO srp1868_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Пророка ћу им подигнути између браће њихове, као што си ти, и метнућу речи своје у уста његова, и казиваће им све што му заповедим. ");
INSERT INTO srp1868_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","А ко год не би послушао речи моје, које ће говорити у моје име, од тога ћу ја тражити. ");
INSERT INTO srp1868_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Али пророк који би се усудио говорити шта у моје име што му ја не заповедим да говори, или који би говорио у име других богова, такав пророк да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","Ако ли кажеш у срцу свом: Како ћемо познати реч које није Господ рекао? ");
INSERT INTO srp1868_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Шта би пророк рекао у име Господње, па се не збуде и не наврши се, то је реч које није рекао Господ; него је из охолости рекао онај пророк, не бој га се. ");
INSERT INTO srp1868_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Кад Господ Бог твој потре народе којих земљу даје теби Господ Бог твој, и кад их наследиш и настаниш се по градовима њиховим и по кућама њиховим, ");
INSERT INTO srp1868_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","одвој три града усред земље своје коју ти даје Господ Бог твој да је наследиш, ");
INSERT INTO srp1868_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","начини пут, и раздели на троје крајеве земље своје коју ти да Господ Бог твој у наследство, па нека бежи онамо сваки крвник. ");
INSERT INTO srp1868_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","А овако нека буде с крвником који утече онамо, да би остао жив: ко убије ближњег свог нехотице, не мрзевши пре на њ, ");
INSERT INTO srp1868_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","као кад би ко отишао с ближњим својим у шуму да сече дрва, па би замахнуо секиром у руци својој да посече дрво, а она би спала с држалице и погодила би ближњег његова тако да умре он нека утече у који од тих градова да остане жив, ");
INSERT INTO srp1868_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","да не би осветник потерао крвника док му је срце распаљено и да га не би стигао на далеком путу и убио га, премда није заслужио смрт, јер није пре мрзео на њ. ");
INSERT INTO srp1868_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Зато ти заповедам и велим: три града одвој. ");
INSERT INTO srp1868_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","А кад рашири Господ Бог твој међе твоје као што се заклео оцима твојим, и да ти сву земљу коју је рекао дати оцима твојим, ");
INSERT INTO srp1868_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ако уздржиш и уствориш све ове заповести, које ти ја данас заповедам, да љубиш Господа Бога свог и ходиш путевима Његовим свагда, онда додај још три града осим она три, ");
INSERT INTO srp1868_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","да се не пролива крв права у земљи твојој, коју ти Господ Бог твој даје у наследство, и да не буде на теби крв. ");
INSERT INTO srp1868_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","Али ако ко мрзи на ближњег свог и вреба га, и скочи на њ, и удари га тако да умре, а он утече у који од тих градова, ");
INSERT INTO srp1868_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","онда старешине места његова нека пошаљу и узму га оданде, и предаду га у руке осветнику да се погуби. ");
INSERT INTO srp1868_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Нека га не жали око твоје него скини крв праву с Израиља, да би ти добро било. ");
INSERT INTO srp1868_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","Не помичи међе ближњег свог коју поставе стари у наследству твом које добијеш у земљи коју ти Господ Бог твој даје да је наследиш. ");
INSERT INTO srp1868_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","Нека не устаје један сведок на човека ни за како зло и ни за какав грех између свих греха који се чине, него на речима два или три сведока да остаје ствар. ");
INSERT INTO srp1868_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Ако би устао лажан сведок на кога да сведочи на њега да се одмеће Бога, ");
INSERT INTO srp1868_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","онда нека стану та два човека, који имају ту распру, пред Господа, пред свештенике и пред судије које буду у то време; ");
INSERT INTO srp1868_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","и нека добро испитају судије, ако сведок онај буде лажан сведок и лажно сведочи на брата свог, ");
INSERT INTO srp1868_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","учините му онако како је он мислио учинити брату свом и извади зло из себе, ");
INSERT INTO srp1868_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","да се остали чувши то боје, и унапред више не чине тако зло усред тебе. ");
INSERT INTO srp1868_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Нека не жали око твоје: живот за живот, око за око, зуб за зуб, руку за руку, ногу за ногу. ");
INSERT INTO srp1868_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","Кад одеш на војску на непријатеља свог и видиш коње и кола и народ већи од себе, немој се уплашити од њих, јер је с тобом Господ Бог твој, који те је извео из земље мисирске. ");
INSERT INTO srp1868_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","И кад пођете да се побијете, нека приступи свештеник и проговори народу, ");
INSERT INTO srp1868_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","и нека им каже: Слушај Израиљу! Ви полазите данас у бој на непријатеље своје, нека не трне срце ваше, не бојте се и не плашите се, нити се препадајте од њих. ");
INSERT INTO srp1868_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","Јер Господ Бог ваш иде с вама и биће се за вас с непријатељима вашим да вас сачува. ");
INSERT INTO srp1868_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","Потом и војводе нека проговоре народу, и кажу: Ко је саградио нову кућу а није почео седети у њој? Нека иде нек се врати кући својој, да не би погинуо у боју, и други почео седети у њој. ");
INSERT INTO srp1868_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","И ко је посадио виноград а још га није брао? Нека иде, нек се врати кући својој, да не би погинуо у боју, и други га брао. ");
INSERT INTO srp1868_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","И ко је испросио девојку а још је није одвео? Нека иде, нек се врати кући својој, да не би погинуо у боју, и други је одвео. ");
INSERT INTO srp1868_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","Још и ово нека кажу војводе народу: Ко је страшљив и трне му срце? Нека иде, нек се врати кући својој, да не би трнуло срце браћи његовој као њему. ");
INSERT INTO srp1868_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","И кад војводе изговоре народу, онда нека наместе главаре од чета пред народ. ");
INSERT INTO srp1868_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","Кад дођеш под који град да га бијеш, прво га понуди миром. ");
INSERT INTO srp1868_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Ако ти одговори миром и отвори ти врата, сав народ који се нађе у њему нека ти плаћа данак и буде ти покоран. ");
INSERT INTO srp1868_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","Ако ли не учини мира с тобом него се стане бити с тобом тада га биј. ");
INSERT INTO srp1868_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","И кад га Господ Бог твој преда у руке твоје, побиј све мушкиње у њему мачем. ");
INSERT INTO srp1868_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","А жене и децу и стоку и шта год буде у граду, сав плен у њему, отми, и једи плен од непријатеља својих, који ти да Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","Тако чини са свим градовима, који су далеко од тебе и нису од градова ових народа. ");
INSERT INTO srp1868_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","А у градовима ових народа, које ти Господ Бог твој даје у наследство, не остави у животу ниједну душу живу. ");
INSERT INTO srp1868_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","Него их затри сасвим, Хетеје и Амореје и Хананеје и Ферезеје и Јевеје и Јевусеје, као што ти је заповедио Господ Бог твој. ");
INSERT INTO srp1868_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","Да вас не науче чинити гадна дела која чинише боговима својим, и да не згрешите Господу Богу свом. ");
INSERT INTO srp1868_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","Кад опколиш какав град и будеш дуго под њим бијући га да би га узео, не квари дрвета његова секиром; јер можеш с њих јести, зато их не сеци; јер дрво пољско је ли човек да уђе у град испред тебе? ");
INSERT INTO srp1868_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","Него дрвета која знаш да им се род не једе, њих обаљуј и сеци и гради заклон од града који се бије с тобом, докле не падне. ");
INSERT INTO srp1868_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","Кад се нађе убијен човек у земљи коју ти даје Господ Бог твој да је наследиш, где лежи у пољу, а не зна се ко га је убио, ");
INSERT INTO srp1868_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","тада нека изиђу старешине твоје и судије твоје, и нека измере од убијеног до градова који су око њега. ");
INSERT INTO srp1868_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","Па који град буде најближе убијеноме, старешине оног града нека узму јуницу из говеда, на којој се још није радило, која није вукла у јарму, ");
INSERT INTO srp1868_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","и нека одведу старешине оног града ту јуницу у пусту долину где се не копа ни сеје, и нека закољу јуницу онде у долини. ");
INSERT INTO srp1868_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","Потом нека приступе свештеници, синови Левијеви; јер њих изабра Господ Бог твој да му служе и да благосиљају у име Господње, и на њиховим речима да остаје свака распра и свака штета; ");
INSERT INTO srp1868_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","и све старешине оног града који буду најближе убијеноме нека оперу руке своје над закланом јуницом у оној долини, ");
INSERT INTO srp1868_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","и тврдећи нека кажу: Руке наше нису пролиле ову крв нити су очи наше виделе; ");
INSERT INTO srp1868_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","милостив буди народу свом Израиљу, који си искупио, Господе, и не мећи праву крв на народ свој Израиља. Тако ће се очистити од оне крви. ");
INSERT INTO srp1868_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","И ти ћеш скинути праву крв са себе кад учиниш шта је право пред Господом. ");
INSERT INTO srp1868_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","Кад отидеш на војску на непријатеље своје, и преда их Господ Бог твој у руке твоје и заробиш их много. ");
INSERT INTO srp1868_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","И угледаш у робљу лепу жену, и омили ти да би је хтео узети за жену, ");
INSERT INTO srp1868_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","одведи је кући својој; и нека обрије главу своју и среже нокте своје; ");
INSERT INTO srp1868_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","и нека скине са себе хаљине своје у којима је заробљена и нека седи у кући твојој, и жали за оцем својим и за матером својом цео месец дана; потом лези с њом, и буди јој муж и она нек ти буде жена. ");
INSERT INTO srp1868_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","Ако ти после не би била по вољи, пусти је нека иде куда јој драго, али никако да је не продаш за новце ни да њом тргујеш, јер си је осрамотио. ");
INSERT INTO srp1868_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","Ко би имао две жене, једну милу, а другу немилу, па би родила синове, и мила и немила, и првенац би био од немиле, ");
INSERT INTO srp1868_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","онда кад дође време да подели синовима својим шта има не може првенцем учинити сина од миле преко сина од немиле који је првенац; ");
INSERT INTO srp1868_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","него за првенца нека призна сина од немиле и даде му два дела од свега што има, је је он почетак силе његове, његово је право првеначко. ");
INSERT INTO srp1868_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","Ко би имао сина самовољног и непокорног, који не слуша оца свог ни матере своје, и ког они и караше па опет не слуша, ");
INSERT INTO srp1868_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","нека га узму отац и мати, и нека га доведу к старешинама града свог на врата места свог, ");
INSERT INTO srp1868_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","и нека кажу старешинама града свог: Овај син наш самовољан је и непокоран, на слуша нас, изјелица је и пијаница. ");
INSERT INTO srp1868_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","Тада сви људи оног места нека га заспу камењем да погине; и тако извади зло из себе, да сав Израиљ чује и боји се. ");
INSERT INTO srp1868_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","Ко згреши тако да заслужи смрт, те буде осуђен на смрт и обесиш га на дрво, ");
INSERT INTO srp1868_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","нека не преноћи тело његово на дрвету, него га исти дан погреби, јер је проклет пред Богом ко је обешен; зато не скврни земље коју ти Господ Бог твој даје у наследство. ");
INSERT INTO srp1868_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","Кад видиш вола или овцу брата свог где лута, немој проћи мимо њих, него их одведи брату свом. ");
INSERT INTO srp1868_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","Ако ли ти брат твој није близу или га не знаш, одведи их својој кући нека буду код тебе докле их не потражи брат твој, и тада му их врати. ");
INSERT INTO srp1868_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","Тако учини и с магарцем његовим и с хаљином његовом; и тако учини са сваком стварју брата свог изгубљеном, кад је изгуби, а ти је нађеш, немој пр