﻿USE sofia;
DROP TABLE IF EXISTS sofia.urdgvb_vpl;
CREATE TABLE urdgvb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES urdgvb_vpl WRITE;
INSERT INTO urdgvb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ইব্তিদা মেং অল্লাহ নে আসমান ঔর জ়মীন কো বনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","অভী তক জ়মীন ৱীরান ঔর খ়ালী থী। ৱহ গহরে পানী সে ঢকী হুঈ থী জিসকে ঊপর অংধেরা হী অংধেরা থা। অল্লাহ কা রূহ পানী কে ঊপর মঁডলা রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ফির অল্লাহ নে কহা, “রৌশনী হো জাএ” তো রৌশনী পৈদা হো গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","অল্লাহ নে দেখা কি রৌশনী অচ্ছী হৈ, ঔর উসনে রৌশনী কো তারীকী সে অলগ কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","অল্লাহ নে রৌশনী কো দিন কা নাম দিযা ঔর তারীকী কো রাত কা। শাম হুঈ, ফির সুবহ। যোং পহলা দিন গুজ়র গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","অল্লাহ নে কহা, “পানী কে দরমিযান এক ঐসা গুংবদ পৈদা হো জাএ জিসসে নিচলা পানী ঊপর কে পানী সে অলগ হো জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ঐসা হী হুআ। অল্লাহ নে এক ঐসা গুংবদ বনাযা জিসসে নিচলা পানী ঊপর কে পানী সে অলগ হো গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","অল্লাহ নে গুংবদ কো আসমান কা নাম দিযা। শাম হুঈ, ফির সুবহ। যোং দূসরা দিন গুজ়র গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","অল্লাহ নে কহা, “জো পানী আসমান কে নীচে হৈ ৱহ এক জগহ জমা হো জাএ তাকি দূসরী তরফ় খ়ুশ্ক জগহ নজ়র আএ।” ঐসা হী হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","অল্লাহ নে খ়ুশ্ক জগহ কো জ়মীন কা নাম দিযা ঔর জমাশুদা পানী কো সমুংদর কা। ঔর অল্লাহ নে দেখা কি যহ অচ্ছা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ফির উসনে কহা, “জ়মীন হরিযাৱল পৈদা করে, ঐসে পৌদে জো বীজ রখতে হোং ঔর ঐসে দরখ়্ত জিনকে ফল অপনী অপনী ক়িস্ম কে বীজ রখতে হোং।” ঐসা হী হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","জ়মীন নে হরিযাৱল পৈদা কী, ঐসে পৌদে জো অপনী অপনী ক়িস্ম কে বীজ রখতে ঔর ঐসে দরখ়্ত জিনকে ফল অপনী অপনী ক়িস্ম কে বীজ রখতে থে। অল্লাহ নে দেখা কি যহ অচ্ছা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","শাম হুঈ, ফির সুবহ। যোং তীসরা দিন গুজ়র গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","অল্লাহ নে কহা, “আসমান পর রৌশনিযাঁ পৈদা হো জাএঁ তাকি দিন ঔর রাত মেং ইম্তিযাজ় হো ঔর ইসী তরহ মুখ়্তলিফ় মৌসমোং, দিনোং ঔর সালোং মেং ভী। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","আসমান কী যহ রৌশনিযাঁ দুনিযা কো রৌশন করেং।” ঐসা হী হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","অল্লাহ নে দো বড়ী রৌশনিযাঁ বনাঈং, সূরজ জো বড়া থা দিন পর হুকূমত করনে কো ঔর চাঁদ জো ছোটা থা রাত পর। ইনকে অলাৱা উসনে সিতারোং কো ভী বনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","উসনে উন্হেং আসমান পর রখা তাকি ৱহ দুনিযা কো রৌশন করেং, ");
INSERT INTO urdgvb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","দিন ঔর রাত পর হুকূমত করেং ঔর রৌশনী ঔর তারীকী মেং ইম্তিযাজ় পৈদা করেং। অল্লাহ নে দেখা কি যহ অচ্ছা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","শাম হুঈ, ফির সুবহ। যোং চৌথা দিন গুজ়র গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","অল্লাহ নে কহা, “পানী আবী জানদারোং সে ভর জাএ ঔর ফ়িজ়া মেং পরিংদে উড়তে ফিরেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","অল্লাহ নে বড়ে বড়ে সমুংদরী জানৱর বনাএ, পানী কী তমাম দীগর মখ়লূক়াত ঔর হর ক়িস্ম কে পর রখনেৱালে জানদার ভী বনাএ। অল্লাহ নে দেখা কি যহ অচ্ছা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","উসনে উন্হেং বরকত দী ঔর কহা, “ফলো-ফূলো ঔর তাদাদ মেং বঢ়তে জাও। সমুংদর তুমসে ভর জাএ। ইসী তরহ পরিংদে জ়মীন পর তাদাদ মেং বঢ় জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","শাম হুঈ, ফির সুবহ। যোং পাঁচৱাঁ দিন গুজ়র গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","অল্লাহ নে কহা, “জ়মীন হর ক়িস্ম কে জানদার পৈদা করে : মৱেশী, রেংগনেৱালে ঔর জংগলী জানৱর।” ঐসা হী হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","অল্লাহ নে হর ক়িস্ম কে মৱেশী, রেংগনেৱালে ঔর জংগলী জানৱর বনাএ। উসনে দেখা কি যহ অচ্ছা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","অল্লাহ নে কহা, “আও অব হম ইনসান কো অপনী সূরত পর বনাএঁ, ৱহ হমসে মুশাবহত রখে। ৱহ তমাম জানৱরোং পর হুকূমত করে, সমুংদর কী মছলিযোং পর, হৱা কে পরিংদোং পর, মৱেশিযোং পর, জংগলী জানৱরোং পর ঔর জ়মীন পর কে তমাম রেংগনেৱালে জানদারোং পর।” ");
INSERT INTO urdgvb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","যোং অল্লাহ নে ইনসান কো অপনী সূরত পর বনাযা, অল্লাহ কী সূরত পর। উসনে উন্হেং মর্দ ঔর ঔরত বনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","অল্লাহ নে উন্হেং বরকত দী ঔর কহা, “ফলো-ফূলো ঔর তাদাদ মেং বঢ়তে জাও। দুনিযা তুমসে ভর জাএ ঔর তুম উস পর ইখ়্তিযার রখো। সমুংদর কী মছলিযোং, হৱা কে পরিংদোং ঔর জ়মীন পর কে তমাম রেংগনেৱালে জানদারোং পর হুকূমত করো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","অল্লাহ নে উনসে মজ়ীদ কহা, “তমাম বীজদার পৌদে ঔর ফলদার দরখ়্ত তুম্হারে হী হৈং। মৈং উন্হেং তুমকো খানে কে লিএ দেতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ইস তরহ মৈং তমাম জানৱরোং কো খানে কে লিএ হরিযালী দেতা হূঁ। জিসমেং ভী জান হৈ ৱহ যহ খা সকতা হৈ, খ়াহ ৱহ জ়মীন পর চলনে-ফিরনেৱালা জানৱর, হৱা কা পরিংদা যা জ়মীন পর রেংগনেৱালা ক্যোং ন হো।” ঐসা হী হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","অল্লাহ নে সব পর নজ়র কী তো দেখা কি ৱহ বহুত অচ্ছা বন গযা হৈ। শাম হুঈ, ফির সুবহ। ছটা দিন গুজ়র গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","যোং আসমানো-জ়মীন ঔর উনকী তমাম চীজ়োং কী তখ়লীক় মুকম্মল হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","সাতৱেং দিন অল্লাহ কা সারা কাম তকমীল কো পহুঁচা। ইসসে ফ়ারিগ় হোকর উসনে আরাম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","অল্লাহ নে সাতৱেং দিন কো বরকত দী ঔর উসে মখ়সূসো-মুক়দ্দস কিযা। ক্যোংকি উস দিন উসনে অপনে তমাম তখ়লীক়ী কাম সে ফ়ারিগ় হোকর আরাম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","যহ আসমানো-জ়মীন কী তখ়লীক় কা বযান হৈ। জব রব খ়ুদা নে আসমানো-জ়মীন কো বনাযা ");
INSERT INTO urdgvb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","তো শুরূ মেং ঝাড়িযাঁ ঔর পৌদে নহীং উগতে থে। ৱজহ যহ থী কি অল্লাহ নে বারিশ কা ইংতজ়াম নহীং কিযা থা। ঔর অভী ইনসান ভী পৈদা নহীং হুআ থা কি জ়মীন কী খেতীবাড়ী করতা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ইসকী বজাএ জ়মীন মেং সে ধুংধ উঠকর উস কী পূরী সতহ কো তর করতী থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ফির রব খ়ুদা নে জ়মীন সে মিট্টী লেকর ইনসান কো তশ্কীল দিযা ঔর উসকে নথনোং মেং জ়িংদগী কা দম ফূঁকা তো ৱহ জীতী জান হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","রব খ়ুদা নে মশরিক় মেং মুল্কে-অদন মেং এক বাগ় লগাযা। উসমেং উসনে উস আদমী কো রখা জিসে উসনে বনাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","রব খ়ুদা কে হুক্ম পর জ়মীন মেং সে তরহ তরহ কে দরখ়্ত ফূট নিকলে, ঐসে দরখ়্ত জো দেখনে মেং দিলকশ ঔর খানে কে লিএ অচ্ছে থে। বাগ় কে বীচ মেং দো দরখ়্ত থে। এক কা ফল জ়িংদগী বখ়্শতা থা জবকি দূসরে কা ফল অচ্ছে ঔর বুরে কী পহচান দিলাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","অদন মেং সে এক দরিযা নিকলকর বাগ় কী আবপাশী করতা থা। ৱহাঁ সে বহকর ৱহ চার শাখ়োং মেং তক়সীম হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_11‏","002_2_11‏","GEN","2","11‏","12","পহলী শাখ় কা নাম ফ়ীসূন হৈ। ৱহ মুল্কে-হৱীলা কো ঘেরে হুএ বহতী হৈ জহাঁ খ়ালিস সোনা, গূগল কা গূঁদ ঔর অক়ীক়ে-অহমর পাএ জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","দূসরী কা নাম জৈহূন হৈ জো কূশ কো ঘেরে হুএ বহতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","তীসরী কা নাম দিজলা হৈ জো অসূর কে মশরিক় কো জাতী হৈ ঔর চৌথী কা নাম ফ়ুরাত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","রব খ়ুদা নে পহলে আদমী কো বাগ়ে-অদন মেং রখা তাকি ৱহ উস কী বাগ়বানী ঔর হিফ়াজ়ত করে। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","লেকিন রব খ়ুদা নে উসে আগাহ কিযা, “তুঝে হর দরখ়্ত কা ফল খানে কী ইজাজ়ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","লেকিন জিস দরখ়্ত কা ফল অচ্ছে ঔর বুরে কী পহচান দিলাতা হৈ উসকা ফল খানা মনা হৈ। অগর উসে খাএ তো যক়ীনন মরেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","রব খ়ুদা নে কহা, “অচ্ছা নহীং কি আদমী অকেলা রহে। মৈং উসকে লিএ এক মুনাসিব মদদগার বনাতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","রব খ়ুদা নে মিট্টী সে জ়মীন পর চলনে-ফিরনেৱালে জানৱর ঔর হৱা কে পরিংদে বনাএ থে। অব ৱহ উন্হেং আদমী কে পাস লে আযা তাকি মালূম হো জাএ কি ৱহ উনকে ক্যা ক্যা নাম রখেগা। যোং হর জানৱর কো আদম কী তরফ় সে নাম মিল গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","আদমী নে তমাম মৱেশিযোং, পরিংদোং ঔর জ়মীন পর ফিরনেৱালে জানদারোং কে নাম রখে। লেকিন উসে অপনে লিএ কোঈ মুনাসিব মদদগার ন মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","তব রব খ়ুদা নে উসে সুলা দিযা। জব ৱহ গহরী নীংদ সো রহা থা তো উসনে উস কী পসলিযোং মেং সে এক নিকালকর উস কী জগহ গোশ্ত ভর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","পসলী সে উসনে ঔরত বনাঈ ঔর উসে আদমী কে পাস লে আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","উসে দেখকর ৱহ পুকার উঠা, “ৱাহ! যহ তো মুঝ জৈসী হী হৈ, মেরী হড্ডিযোং মেং সে হড্ডী ঔর মেরে গোশ্ত মেং সে গোশ্ত হৈ। ইসকা নাম নারী রখা জাএ ক্যোংকি ৱহ নর সে নিকালী গঈ হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ইসলিএ মর্দ অপনে মাঁ-বাপ কো ছোড়কর অপনী বীৱী কে সাথ পৈৱস্ত হো জাতা হৈ, ঔর ৱহ দোনোং এক হো জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","দোনোং, আদমী ঔর ঔরত নংগে থে, লেকিন যহ উনকে লিএ শর্ম কা বাইস নহীং থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","সাঁপ জ়মীন পর চলনে-ফিরনেৱালে উন তমাম জানৱরোং সে জ়্যাদা চালাক থা জিনকো রব খ়ুদা নে বনাযা থা। উসনে ঔরত সে পূছা, “ক্যা অল্লাহ নে ৱাক়ঈ কহা কি বাগ় কে কিসী ভী দরখ়্ত কা ফল ন খানা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ঔরত নে জৱাব দিযা, “হরগিজ় নহীং। হম বাগ় কা হর ফল খা সকতে হৈং, ");
INSERT INTO urdgvb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","সির্ফ় উস দরখ়্ত কে ফল সে গুরেজ় করনা হৈ জো বাগ় কে বীচ মেং হৈ। অল্লাহ নে কহা কি উসকা ফল ন খাও বল্কি উসে ছূনা ভী নহীং, ৱরনা তুম যক়ীনন মর জাওগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","সাঁপ নে ঔরত সে কহা, “তুম হরগিজ় ন মরোগে, ");
INSERT INTO urdgvb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","বল্কি অল্লাহ জানতা হৈ কি জব তুম উসকা ফল খাওগে তো তুম্হারী আঁখেং খুল জাএঁগী ঔর তুম অল্লাহ কী মানিংদ হো জাওগে, তুম জো ভী অচ্ছা ঔর বুরা হৈ উসে জান লোগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ঔরত নে দরখ়্ত পর গ়ৌর কিযা কি খানে কে লিএ অচ্ছা ঔর দেখনে মেং ভী দিলকশ হৈ। সবসে দিলফ়রেব বাত যহ কি উসসে সমঝ হাসিল হো সকতী হৈ! যহ সোচকর উসনে উসকা ফল লেকর উসে খাযা। ফির উসনে অপনে শৌহর কো ভী দে দিযা, ক্যোংকি ৱহ উসকে সাথ থা। উসনে ভী খা লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","লেকিন খাতে হী উনকী আঁখেং খুল গঈং ঔর উনকো মালূম হুআ কি হম নংগে হৈং। চুনাঁচে উন্হোংনে অংজীর কে পত্তে সীকর লুংগিযাঁ বনা লীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","শাম কে ৱক়্ত জব ঠংডী হৱা চলনে লগী তো উন্হোংনে রব খ়ুদা কো বাগ় মেং চলতে-ফিরতে সুনা। ৱহ ডর কে মারে দরখ়্তোং কে পীছে ছুপ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","রব খ়ুদা নে পুকারকর কহা, “আদম, তূ কহাঁ হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","আদম নে জৱাব দিযা, “মৈংনে তুঝে বাগ় মেং চলতে হুএ সুনা তো ডর গযা, ক্যোংকি মৈং নংগা হূঁ। ইসলিএ মৈং ছুপ গযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","উসনে পূছা, “কিসনে তুঝে বতাযা কি তূ নংগা হৈ? ক্যা তূনে উস দরখ়্ত কা ফল খাযা হৈ জিসে খানে সে মৈংনে মনা কিযা থা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","আদম নে কহা, “জো ঔরত তূনে মেরে সাথ রহনে কে লিএ দী হৈ উসনে মুঝে ফল দিযা। ইসলিএ মৈংনে খা লিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","অব রব খ়ুদা ঔরত সে মুখ়াতিব হুআ, “তূনে যহ ক্যোং কিযা?” ঔরত নে জৱাব দিযা, “সাঁপ নে মুঝে বহকাযা তো মৈংনে খাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","রব খ়ুদা নে সাঁপ সে কহা, “চূঁকি তূনে যহ কিযা, ইসলিএ তূ তমাম মৱেশিযোং ঔর জংগলী জানৱরোং মেং লানতী হৈ। তূ উম্র-ভর পেট কে বল রেংগেগা ঔর খ়াক চাটেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","মৈং তেরে ঔর ঔরত কে দরমিযান দুশ্মনী পৈদা করূঁগা। উস কী ঔলাদ তেরী ঔলাদ কী দুশ্মন হোগী। ৱহ তেরে সর কো কুচল ডালেগী জবকি তূ উস কী এড়ী পর কাটেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ফির রব খ়ুদা ঔরত সে মুখ়াতিব হুআ ঔর কহা, “জব তূ উম্মীদ সে হোগী তো মৈং তেরী তকলীফ় কো বহুত বঢ়াঊঁগা। জব তেরে বচ্চে হোংগে তো তূ শদীদ দর্দ কা শিকার হোগী। তূ অপনে শৌহর কী তমন্না করেগী লেকিন ৱহ তুঝ পর হুকূমত করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","আদম সে উসনে কহা, “তূনে অপনী বীৱী কী বাত মানী ঔর উস দরখ়্ত কা ফল খাযা জিসে খানে সে মৈংনে মনা কিযা থা। ইসলিএ তেরে সবব সে জ়মীন পর লানত হৈ। উসসে খ়ুরাক হাসিল করনে কে লিএ তুঝে উম্র-ভর মেহনত-মশক়্ক়ত করনী পড়েগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","তেরে লিএ ৱহ খ়ারদার পৌদে ঔর ঊঁটকটারে পৈদা করেগী, হালাঁকি তূ উসসে অপনী খ়ুরাক ভী হাসিল করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","পসীনা বহা বহাকর তুঝে রোটী কমানে কে লিএ ভাগ-দৌড় করনী পড়েগী। ঔর যহ সিলসিলা মৌত তক জারী রহেগা। তূ মেহনত করতে করতে দুবারা জ়মীন মেং লৌট জাএগা, ক্যোংকি তূ উসী সে লিযা গযা হৈ। তূ খ়াক হৈ ঔর দুবারা খ়াক মেং মিল জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","আদম নে অপনী বীৱী কা নাম হৱ্ৱা যানী জ়িংদগী রখা, ক্যোংকি বাদ মেং ৱহ তমাম জ়িংদোং কী মাঁ বন গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","রব খ়ুদা নে আদম ঔর উস কী বীৱী কে লিএ খালোং সে লিবাস বনাকর উন্হেং পহনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","উসনে কহা, “ইনসান হমারী মানিংদ হো গযা হৈ, ৱহ অচ্ছে ঔর বুরে কা ইল্ম রখতা হৈ। অব ঐসা ন হো কি ৱহ হাথ বঢ়াকর জ়িংদগী বখ়্শনেৱালে দরখ়্ত কে ফল সে লে ঔর উসসে খাকর হমেশা তক জ়িংদা রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ইসলিএ রব খ়ুদা নে উসে বাগ়ে-অদন সে নিকালকর উস জ়মীন কী খেতীবাড়ী করনে কী জ়িম্মাদারী দী জিসমেং সে উসে লিযা গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ইনসান কো খ়ারিজ করনে কে বাদ উসনে বাগ়ে-অদন কে মশরিক় মেং করূবী ফ়রিশ্তে খড়ে কিএ ঔর সাথ সাথ এক আতিশী তলৱার রখী জো ইধর-উধর ঘূমতী থী তাকি উস রাস্তে কী হিফ়াজ়ত করে জো জ়িংদগী বখ়্শনেৱালে দরখ়্ত তক পহুঁচাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","আদম হৱ্ৱা সে হমবিসতর হুআ তো উনকা পহলা বেটা ক়াবীল পৈদা হুআ। হৱ্ৱা নে কহা, “রব কী মদদ সে মৈংনে এক মর্দ হাসিল কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","বাদ মেং ক়াবীল কা ভাঈ হাবীল পৈদা হুআ। হাবীল ভেড়-বকরিযোং কা চরৱাহা বন গযা জবকি ক়াবীল খেতীবাড়ী করনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","কুছ দের কে বাদ ক়াবীল নে রব কো অপনী ফ়সলোং মেং সে কুছ পেশ কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","হাবীল নে ভী নজ়রানা পেশ কিযা, লেকিন উসনে অপনী ভেড়-বকরিযোং কে কুছ পহলৌঠে উনকী চরবী সমেত চঢ়াএ। হাবীল কা নজ়রানা রব কো পসংদ আযা, ");
INSERT INTO urdgvb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","মগর ক়াবীল কা নজ়রানা মংজ়ূর ন হুআ। যহ দেখকর ক়াবীল বড়ে গ়ুস্সে মেং আ গযা, ঔর উসকা মুঁহ বিগড় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","রব নে পূছা, “তূ গ়ুস্সে মেং ক্যোং আ গযা হৈ? তেরা মুঁহ ক্যোং লটকা হুআ হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ক্যা অগর তূ অচ্ছী নীযত রখতা হৈ তো অপনী নজ়র উঠাকর মেরী তরফ় নহীং দেখ সকেগা? লেকিন অগর অচ্ছী নীযত নহীং রখতা তো খ়বরদার! গুনাহ দরৱাজ়ে পর দবকা বৈঠা হৈ ঔর তুঝে চাহতা হৈ। লেকিন তেরা ফ়র্জ় হৈ কি উস পর গ়ালিব আএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","এক দিন ক়াবীল নে অপনে ভাঈ সে কহা, “আও, হম বাহর খুলে মৈদান মেং চলেং।” ঔর জব ৱহ খুলে মৈদান মেং থে তো ক়াবীল নে অপনে ভাঈ হাবীল পর হমলা করকে উসে মার ডালা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","তব রব নে ক়াবীল সে পূছা, “তেরা ভাঈ হাবীল কহাঁ হৈ?” ক়াবীল নে জৱাব দিযা, “মুঝে ক্যা পতা! ক্যা অপনে ভাঈ কী দেখ-ভাল করনা মেরী জ়িম্মাদারী হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","রব নে কহা, “তূনে ক্যা কিযা হৈ? তেরে ভাঈ কা খ়ূন জ়মীন মেং সে পুকারকর মুঝসে ফ়রিযাদ কর রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ইসলিএ তুঝ পর লানত হৈ ঔর জ়মীন নে তুঝে রদ্দ কিযা হৈ, ক্যোংকি জ়মীন কো মুঁহ খোলকর তেরে হাথ সে ক়ত্ল কিএ হুএ ভাঈ কা খ়ূন পীনা পড়া। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","অব সে জব তূ খেতীবাড়ী করেগা তো জ়মীন অপনী পৈদাৱার দেনে সে ইনকার করেগী। তূ মফ়রূর হোকর মারা মারা ফিরেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ক়াবীল নে কহা, “মেরী সজ়া নিহাযত সখ়্ত হৈ। মৈং ইসে বরদাশ্ত নহীং কর পাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","আজ তূ মুঝে জ়মীন কী সতহ সে ভগা রহা হৈ ঔর মুঝে তেরে হুজ়ূর সে ভী ছুপ জানা হৈ। মৈং মফ়রূর কী হৈসিযত সে মারা মারা ফিরতা রহূঁগা, ইসলিএ জিসকো ভী পতা চলেগা কি মৈং কহাঁ হূঁ ৱহ মুঝে ক়ত্ল কর ডালেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","লেকিন রব নে উসসে কহা, “হরগিজ় নহীং। জো ক়াবীল কো ক়ত্ল করে উসসে সাত গুনা বদলা লিযা জাএগা।” ফির রব নে উস পর এক নিশান লগাযা তাকি জো ভী ক়াবীল কো দেখে ৱহ উসে ক়ত্ল ন কর দে। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ইসকে বাদ ক়াবীল রব কে হুজ়ূর সে চলা গযা ঔর অদন কে মশরিক় কী তরফ় নোদ কে ইলাক়ে মেং জা বসা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ক়াবীল কী বীৱী হামিলা হুঈ। বেটা পৈদা হুআ জিসকা নাম হনূক রখা গযা। ক়াবীল নে এক শহর তামীর কিযা ঔর অপনে বেটে কী খ়ুশী মেং উসকা নাম হনূক রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","হনূক কা বেটা ঈরাদ থা, ঈরাদ কা বেটা মহূযাএল, মহূযাএল কা বেটা মতূসাএল ঔর মতূসাএল কা বেটা লমক থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","লমক কী দো বীৱিযাঁ থীং, অদা ঔর জ়িল্লা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","অদা কা বেটা যাবল থা। উস কী নসল কে লোগ খ়ৈমোং মেং রহতে ঔর মৱেশী পালতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","যাবল কা ভাঈ যূবল থা। উস কী নসল কে লোগ সরোদ ঔর বাঁসরী বজাতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","জ়িল্লা কে ভী বেটা পৈদা হুআ জিসকা নাম তূবল-ক়াবীল থা। ৱহ লোহার থা। উস কী নসল কে লোগ পীতল ঔর লোহে কী চীজ়েং বনাতে থে। তূবল-ক়াবীল কী বহন কা নাম নামা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","এক দিন লমক নে অপনী বীৱিযোং সে কহা, “অদা ঔর জ়িল্লা, মেরী বাত সুনো! লমক কী বীৱিযো, মেরে অলফ়াজ় পর গ়ৌর করো! ");
INSERT INTO urdgvb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","এক আদমী নে মুঝে জ়খ়মী কিযা তো মৈংনে উসে মার ডালা। এক লড়কে নে মেরে চোট লগাঈ তো মৈংনে উসে ক়ত্ল কর দিযা। জো ক়াবীল কো ক়ত্ল করে উসসে সাত গুনা বদলা লিযা জাএগা, লেকিন জো লমক কো ক়ত্ল করে উসসে সতত্তর গুনা বদলা লিযা জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","আদম ঔর হৱ্ৱা কা এক ঔর বেটা পৈদা হুআ। হৱ্ৱা নে উসকা নাম সেত রখকর কহা, “অল্লাহ নে মুঝে হাবীল কী জগহ জিসে ক়াবীল নে ক়ত্ল কিযা এক ঔর বেটা বখ়্শা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","সেত কে হাঁ ভী বেটা পৈদা হুআ। উসনে উসকা নাম অনূস রখা। উন দিনোং মেং লোগ রব কা নাম লেকর ইবাদত করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","জ়ৈল মেং আদম কা নসবনামা দর্জ হৈ। জব অল্লাহ নে ইনসান কো খ়লক় কিযা তো উসনে উসে অপনী সূরত পর বনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","উসনে উন্হেং মর্দ ঔর ঔরত পৈদা কিযা। ঔর জিস দিন উসনে উন্হেং খ়লক় কিযা উসনে উন্হেং বরকত দেকর উনকা নাম আদম যানী ইনসান রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","আদম কী উম্র 130 সাল থী জব উসকা বেটা সেত পৈদা হুআ। সেত সূরত কে লিহাজ় সে অপনে বাপ কী মানিংদ থা, ৱহ উসসে মুশাবহত রখতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","সেত কী পৈদাইশ কে বাদ আদম মজ়ীদ 800 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ৱহ 930 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","সেত 105 সাল কা থা জব উসকা বেটা অনূস পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ইসকে বাদ ৱহ মজ়ীদ 807 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ৱহ 912 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","অনূস 90 বরস কা থা জব উসকা বেটা ক়ীনান পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ইসকে বাদ ৱহ মজ়ীদ 815 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ৱহ 905 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ক়ীনান 70 সাল কা থা জব উসকা বেটা মহললেল পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ইসকে বাদ ৱহ মজ়ীদ 840 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ৱহ 910 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","মহললেল 65 সাল কা থা জব উসকা বেটা যারিদ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ইসকে বাদ ৱহ মজ়ীদ 830 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ৱহ 895 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","যারিদ 162 সাল কা থা জব উসকা বেটা হনূক পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ইসকে বাদ ৱহ মজ়ীদ 800 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ৱহ 962 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","হনূক 65 সাল কা থা জব উসকা বেটা মতূসিলহ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ইসকে বাদ ৱহ মজ়ীদ 300 সাল অল্লাহ কে সাথ চলতা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ৱহ কুল 365 সাল দুনিযা মেং রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","হনূক অল্লাহ কে সাথ সাথ চলতা থা। 365 সাল কী উম্র মেং ৱহ গ়াযব হুআ, ক্যোংকি অল্লাহ নে উসে উঠা লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","মতূসিলহ 187 সাল কা থা জব উসকা বেটা লমক পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ৱহ মজ়ীদ 782 সাল জ়িংদা রহা। উসকে ঔর বেটে ঔর বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ৱহ 969 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","লমক 182 সাল কা থা জব উসকা বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","উসনে উসকা নাম নূহ যানী তসল্লী রখা, ক্যোংকি উসনে উসকে বারে মেং কহা, “হমারা খেতীবাড়ী কা কাম নিহাযত তকলীফ়দেহ হৈ, ইসলিএ কি অল্লাহ নে জ়মীন পর লানত ভেজী হৈ। লেকিন অব হম বেটে কী মারিফ়ত তসল্লী পাএঁগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ইসকে বাদ ৱহ মজ়ীদ 595 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ৱহ 777 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","নূহ 500 সাল কা থা জব উসকে বেটে সিম, হাম ঔর যাফ়ত পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","দুনিযা মেং লোগোং কী তাদাদ বঢ়নে লগী। উনকে হাঁ বেটিযাঁ পৈদা হুঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","তব আসমানী হস্তিযোং নে দেখা কি বনী নৌ ইনসান কী বেটিযাঁ খ়ূবসূরত হৈং, ঔর উন্হোংনে উনমেং সে কুছ চুনকর উনসে শাদী কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ফির রব নে কহা, “মেরী রূহ হমেশা কে লিএ ইনসান মেং ন রহে ক্যোংকি ৱহ ফ়ানী মখ়লূক় হৈ। অব সে ৱহ 120 সাল সে জ়্যাদা জ়িংদা নহীং রহেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","উন দিনোং মেং ঔর বাদ মেং ভী দুনিযা মেং দেৱক়ামত অফ়রাদ থে জো ইনসানী ঔরতোং ঔর উন আসমানী হস্তিযোং কী শাদিযোং সে পৈদা হুএ থে। যহ দেৱক়ামত অফ়রাদ ক়দীম জ়মানে কে মশহূর সূরমা থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","রব নে দেখা কি ইনসান নিহাযত বিগড় গযা হৈ, কি উসকে তমাম খ়যালাত লগাতার বুরাঈ কী তরফ় মাযল রহতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ৱহ পছতাযা কি মৈংনে ইনসান কো বনাকর দুনিযা মেং রখ দিযা হৈ, ঔর উসে সখ়্ত দুখ হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","উসনে কহা, “গো মৈং হী নে ইনসান কো খ়লক় কিযা মৈং উসে রূএ-জ়মীন পর সে মিটা ডালূঁগা। মৈং ন সির্ফ় লোগোং কো বল্কি জ়মীন পর চলনে-ফিরনে ঔর রেংগনেৱালে জানৱরোং ঔর হৱা কে পরিংদোং কো ভী হলাক কর দূঁগা, ক্যোংকি মৈং পছতাতা হূঁ কি মৈংনে উনকো বনাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","সির্ফ় নূহ পর রব কী নজ়রে-করম থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","যহ উস কী জ়িংদগী কা বযান হৈ। নূহ রাস্তবাজ় থা। উস জ়মানে কে লোগোং মেং সির্ফ় ৱহী বেক়ুসূর থা। ৱহ অল্লাহ কে সাথ সাথ চলতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","নূহ কে তীন বেটে থে, সিম, হাম ঔর যাফ়ত। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","লেকিন দুনিযা অল্লাহ কী নজ়র মেং বিগড়ী হুঈ ঔর জ়ুল্মো-তশদ্দুদ সে ভরী হুঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","জহাঁ ভী অল্লাহ দেখতা দুনিযা খ়রাব থী, ক্যোংকি তমাম জানদারোং নে জ়মীন পর অপনী রৱিশ কো বিগাড় দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","তব অল্লাহ নে নূহ সে কহা, “মৈংনে তমাম জানদারোং কো খ়ত্ম করনে কা ফ়ৈসলা কিযা হৈ, ক্যোংকি উনকে সবব সে পূরী দুনিযা জ়ুল্মো-তশদ্দুদ সে ভর গঈ হৈ। চুনাঁচে মৈং উনকো জ়মীন সমেত তবাহ কর দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","অব অপনে লিএ সরো কী লকড়ী কী কশ্তী বনা লে। উসমেং কমরে হোং ঔর উসে অংদর ঔর বাহর তারকোল লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","উস কী লংবাঈ 450 ফ়ুট, চৌড়াঈ 75 ফ়ুট ঔর ঊঁচাঈ 45 ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","কশ্তী কী ছত কো যোং বনানা কি উসকে নীচে 18 ইংচ খুলা রহে। এক তরফ় দরৱাজ়া হো, ঔর উস কী তীন মনজ়িলেং হোং। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","মৈং পানী কা ইতনা বড়া সৈলাব লাঊঁগা কি ৱহ জ়মীন কে তমাম জানদারোং কো হলাক কর ডালেগা। জ়মীন পর সব কুছ ফ়না হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","লেকিন তেরে সাথ মৈং অহদ বাঁধূঁগা জিসকে তহত তূ অপনে বেটোং, অপনী বীৱী ঔর বহুওং কে সাথ কশ্তী মেং জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","হর ক়িস্ম কে জানৱর কা এক নর ঔর এক মাদা ভী অপনে সাথ কশ্তী মেং লে জানা তাকি ৱহ তেরে সাথ জীতে বচেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","হর ক়িস্ম কে পর রখনেৱালে জানৱর ঔর হর ক়িস্ম কে জ়মীন পর ফিরনে যা রেংগনেৱালে জানৱর দো দো হোকর তেরে পাস আএঁগে তাকি জীতে বচ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","জো ভী খ়ুরাক দরকার হৈ উসে অপনে ঔর উনকে লিএ জমা করকে কশ্তী মেং মহফ়ূজ় কর লেনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","নূহ নে সব কুছ ৱৈসা হী কিযা জৈসা অল্লাহ নে উসে বতাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ফির রব নে নূহ সে কহা, “অপনে ঘরানে সমেত কশ্তী মেং দাখ়িল হো জা, ক্যোংকি ইস দৌর কে লোগোং মেং সে মৈংনে সির্ফ় তুঝে রাস্তবাজ় পাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","হর ক়িস্ম কে পাক জানৱরোং মেং সে সাত সাত নরো-মাদা কে জোড়ে জবকি নাপাক জানৱরোং মেং সে নরো-মাদা কা সির্ফ় এক এক জোড়া সাথ লে জানা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ইসী তরহ হর ক়িস্ম কে পর রখনেৱালোং মেং সে সাত সাত নরো-মাদা কে জোড়ে ভী সাথ লে জানা তাকি উনকী নসলেং বচী রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","এক হফ়তে কে বাদ মৈং চালীস দিন ঔর চালীস রাত মুতৱাতির বারিশ বরসাঊঁগা। ইসসে মৈং তমাম জানদারোং কো রূএ-জ়মীন পর সে মিটা ডালূঁগা, অগরচে মৈং হী নে উন্হেং বনাযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","নূহ নে ৱৈসা হী কিযা জৈসা রব নে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ৱহ 600 সাল কা থা জব যহ তূফ়ানী সৈলাব জ়মীন পর আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","তূফ়ানী সৈলাব সে বচনে কে লিএ নূহ অপনে বেটোং, অপনী বীৱী ঔর বহুওং কে সাথ কশ্তী মেং সৱার হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","জ়মীন পর ফিরনেৱালে পাক ঔর নাপাক জানৱর, পর রখনেৱালে ঔর তমাম রেংগনেৱালে জানৱর ভী আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","নরো-মাদা কী সূরত মেং দো দো হোকর ৱহ নূহ কে পাস আকর কশ্তী মেং সৱার হুএ। সব কুছ ৱৈসা হী হুআ জৈসা অল্লাহ নে নূহ কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","এক হফ়তে কে বাদ তূফ়ানী সৈলাব জ়মীন পর আ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","যহ সব কুছ উস ৱক়্ত হুআ জব নূহ 600 সাল কা থা। দূসরে মহীনে কে 17ৱেং দিন জ়মীন কী গহরাইযোং মেং সে তমাম চশ্মে ফূট নিকলে ঔর আসমান পর পানী কে দরীচে খুল গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","চালীস দিন ঔর চালীস রাত তক মূসলাধার বারিশ হোতী রহী। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","জব বারিশ শুরূ হুঈ তো নূহ, উসকে বেটে সিম, হাম ঔর যাফ়ত, উস কী বীৱী ঔর বহুএঁ কশ্তী মেং সৱার হো চুকে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","উনকে সাথ হর ক়িস্ম কে জংগলী জানৱর, মৱেশী, রেংগনে ঔর পর রখনেৱালে জানৱর থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","হর ক়িস্ম কে জানদার দো দো হোকর নূহ কে পাস আকর কশ্তী মেং সৱার হো চুকে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","নরো-মাদা আএ থে। সব কুছ ৱৈসা হী হুআ থা জৈসা অল্লাহ নে নূহ কো হুক্ম দিযা থা। ফির রব নে দরৱাজ়ে কো বংদ কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","চালীস দিন তক তূফ়ানী সৈলাব জারী রহা। পানী চঢ়া তো উসনে কশ্তী কো জ়মীন পর সে উঠা লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","পানী জ়োর পকড়কর বহুত বঢ় গযা, ঔর কশ্তী উস পর তৈরনে লগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","আখ়িরকার পানী ইতনা জ়্যাদা হো গযা কি তমাম ঊঁচে পহাড় ভী উসমেং ছুপ গএ, ");
INSERT INTO urdgvb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","বল্কি সবসে ঊঁচী চোটী পর পানী কী গহরাঈ 20 ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","জ়মীন পর রহনেৱালী হর মখ়লূক় হলাক হুঈ। পরিংদে, মৱেশী, জংগলী জানৱর, তমাম জানদার জিনসে জ়মীন ভরী হুঈ থী ঔর ইনসান, সব কুছ মর গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","জ়মীন পর হর জানদার মখ়লূক় হলাক হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","যোং হর মখ়লূক় কো রূএ-জ়মীন পর সে মিটা দিযা গযা। ইনসান, জ়মীন পর ফিরনে ঔর রেংগনেৱালে জানৱর ঔর পরিংদে, সব কুছ খ়ত্ম কর দিযা গযা। সির্ফ় নূহ ঔর কশ্তী মেং সৱার উসকে সাথী বচ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","সৈলাব ডেঢ় সৌ দিন তক জ়মীন পর গ়ালিব রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","লেকিন অল্লাহ কো নূহ ঔর তমাম জানৱর যাদ রহে জো কশ্তী মেং থে। উসনে হৱা চলা দী জিসসে পানী কম হোনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","জ়মীন কে চশ্মে ঔর আসমান পর কে পানী কে দরীচে বংদ হো গএ, ঔর বারিশ রুক গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","পানী ঘটতা গযা। 150 দিন কে বাদ ৱহ কাফ়ী কম হো গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","সাতৱেং মহীনে কে 17ৱেং দিন কশ্তী অরারাত কে এক পহাড় পর টিক গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","দসৱেং মহীনে কে পহলে দিন পানী ইতনা কম হো গযা থা কি পহাড়োং কী চোটিযাঁ নজ়র আনে লগী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_6‏","002_8_6‏","GEN","8","6‏","7","চালীস দিন কে বাদ নূহ নে কশ্তী কী খিড়কী খোলকর এক কৌৱা ছোড় দিযা, ঔর ৱহ উড়কর চলা গযা। লেকিন জব তক জ়মীন পর পানী থা ৱহ আতা জাতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ফির নূহ নে এক কবূতর ছোড় দিযা তাকি পতা চলে কি জ়মীন পানী সে নিকল আঈ হৈ যা নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","লেকিন কবূতর কো কহীং ভী বৈঠনে কী জগহ ন মিলী, ক্যোংকি অব তক পূরী জ়মীন পর পানী হী পানী থা। ৱহ কশ্তী ঔর নূহ কে পাস ৱাপস আ গযা, ঔর নূহ নে অপনা হাথ বঢ়াযা ঔর কবূতর কো পকড়কর অপনে পাস কশ্তী মেং রখ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","উসনে এক হফ়তা ঔর ইংতজ়ার করকে কবূতর কো দুবারা ছোড় দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","শাম কে ৱক়্ত ৱহ লৌট আযা। ইস দফ়া উস কী চোংচ মেং জ়ৈতূন কা তাজ়া পত্তা থা। তব নূহ কো মালূম হুআ কি জ়মীন পানী সে নিকল আঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","উসনে মজ়ীদ এক হফ়তে কে বাদ কবূতর কো ছোড় দিযা। ইস দফ়া ৱহ ৱাপস ন আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","জব নূহ 601 সাল কা থা তো পহলে মহীনে কে পহলে দিন জ়মীন কী সতহ পর পানী খ়ত্ম হো গযা। তব নূহ নে কশ্তী কী ছত খোল দী ঔর দেখা কি জ়মীন কী সতহ পর পানী নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","দূসরে মহীনে কে 27ৱেং দিন জ়মীন বিলকুল খ়ুশ্ক হো গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ফির অল্লাহ নে নূহ সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“অপনী বীৱী, বেটোং ঔর বহুওং কে সাথ কশ্তী সে নিকল আ। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","জিতনে ভী জানৱর সাথ হৈং উন্হেং নিকাল দে, খ়াহ পরিংদে হোং, খ়াহ জ়মীন পর ফিরনে যা রেংগনেৱালে জানৱর। ৱহ দুনিযা মেং ফৈল জাএঁ, নসল বঢ়াএঁ ঔর তাদাদ মেং বঢ়তে জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","চুনাঁচে নূহ অপনে বেটোং, অপনী বীৱী ঔর বহুওং সমেত নিকল আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","তমাম জানৱর ঔর পরিংদে ভী অপনী অপনী ক়িস্ম কে গুরোহোং মেং কশ্তী সে নিকলে। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","উস ৱক়্ত নূহ নে রব কে লিএ ক়ুরবানগাহ বনাঈ। উসনে তমাম ফিরনে ঔর উড়নেৱালে পাক জানৱরোং মেং সে কুছ চুনকর উন্হেং জ়বহ কিযা ঔর ক়ুরবানগাহ পর পূরী তরহ জলা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","যহ ক়ুরবানিযাঁ দেখকর রব খ়ুশ হুআ ঔর অপনে দিল মেং কহা, “অব সে মৈং কভী জ়মীন পর ইনসান কী ৱজহ সে লানত নহীং ভেজূঁগা, ক্যোংকি উসকা দিল বচপন হী সে বুরাঈ কী তরফ় মাযল হৈ। অব সে মৈং কভী ইস তরহ তমাম জান রখনেৱালী মখ়লূক়াত কো রূএ-জ়মীন পর সে নহীং মিটাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","দুনিযা কে মুক়র্ররা ঔক়াত জারী রহেংগে। বীজ বোনে ঔর ফ়সল কাটনে কা ৱক়্ত, ঠংড ঔর তপিশ, গরমিযোং ঔর সর্দিযোং কা মৌসম, দিন ঔর রাত, যহ সব কুছ দুনিযা কে অখ়ীর তক ক়াযম রহেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ফির অল্লাহ নে নূহ ঔর উসকে বেটোং কো বরকত দেকর কহা, “ফলো-ফূলো ঔর তাদাদ মেং বঢ়তে জাও। দুনিযা তুমসে ভর জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","জ়মীন পর ফিরনে ঔর রেংগনেৱালে জানৱর, পরিংদে ঔর মছলিযাঁ সব তুমসে ডরেংগে। উন্হেং তুম্হারে ইখ়্তিযার মেং কর দিযা গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","জিস তরহ মৈংনে তুম্হারে খানে কে লিএ পৌদোং কী পৈদাৱার মুক়র্রর কী হৈ উসী তরহ অব সে তুম্হেং হর ক়িস্ম কে জানৱর খানে কী ইজাজ়ত ভী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","লেকিন খ়বরদার! ঐসা গোশ্ত ন খানা জিসমেং খ়ূন হৈ, ক্যোংকি খ়ূন মেং উস কী জান হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","কিসী কী জান লেনা মনা হৈ। জো ঐসা করেগা উসে অপনী জান দেনী পড়েগী, খ়াহ ৱহ ইনসান হো যা হৈৱান। মৈং খ়ুদ ইসকা মুতালবা করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","জো ভী কিসী কা খ়ূন বহাএ উসকা খ়ূন ভী বহাযা জাএগা। ক্যোংকি অল্লাহ নে ইনসান কো অপনী সূরত পর বনাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","অব ফলো-ফূলো ঔর তাদাদ মেং বঢ়তে জাও। দুনিযা মেং ফৈল জাও।” ");
INSERT INTO urdgvb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","তব অল্লাহ নে নূহ ঔর উসকে বেটোং সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“অব মৈং তুম্হারে ঔর তুম্হারী ঔলাদ কে সাথ অহদ ক়াযম করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","যহ অহদ উন তমাম জানৱরোং কে সাথ ভী হোগা জো কশ্তী মেং সে নিকলে হৈং যানী পরিংদোং, মৱেশিযোং ঔর জ়মীন পর কে তমাম জানৱরোং কে সাথ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","মৈং তুম্হারে সাথ অহদ বাঁধকর ৱাদা করতা হূঁ কি অব সে ঐসা কভী নহীং হোগা কি জ়মীন কী তমাম জ়িংদগী সৈলাব সে খ়ত্ম কর দী জাএগী। অব সে ঐসা সৈলাব কভী নহীং আএগা জো পূরী জ়মীন কো তবাহ কর দে। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ইস অবদী অহদ কা নিশান জো মৈং তুম্হারে ঔর তমাম জানদারোং কে সাথ ক়াযম কর রহা হূঁ যহ হৈ কি ");
INSERT INTO urdgvb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","মৈং অপনী কমান বাদলোং মেং রখতা হূঁ। ৱহ মেরে দুনিযা কে সাথ অহদ কা নিশান হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","জব কভী মেরে কহনে পর আসমান পর বাদল ছা জাএংগে ঔর ক়ৌসে-ক়ুজ়হ উনমেং সে নজ়র আএগী ");
INSERT INTO urdgvb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","তো মৈং যহ অহদ যাদ করূঁগা জো তুম্হারে ঔর তমাম জানদারোং কে সাথ কিযা গযা হৈ। অব কভী ভী ঐসা সৈলাব নহীং আএগা জো তমাম জ়িংদগী কো হলাক কর দে। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ক়ৌসে-ক়ুজ়হ নজ়র আএগী তো মৈং উসে দেখকর উস দাযমী অহদ কো যাদ করূঁগা জো মেরে ঔর দুনিযা কী তমাম জানদার মখ়লূক়াত কে দরমিযান হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","যহ উস অহদ কা নিশান হৈ জো মৈংনে দুনিযা কে তমাম জানদারোং কে সাথ কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","নূহ কে জো বেটে উসকে সাথ কশ্তী সে নিকলে সিম, হাম ঔর যাফ়ত থে। হাম কনান কা বাপ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","দুনিযা-ভর কে তমাম লোগ ইন তীনোং কী ঔলাদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","নূহ কিসান থা। শুরূ মেং উসনে অংগূর কা বাগ় লগাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","অংগূর সে মৈ বনাকর উসনে ইতনী পী লী কি ৱহ নশে মেং ধুত অপনে ডেরে মেং নংগা পড়া রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","কনান কে বাপ হাম নে উসে যোং পড়া হুআ দেখা তো বাহর জাকর অপনে দোনোং ভাইযোং কো উসকে বারে মেং বতাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","যহ সুনকর সিম ঔর যাফ়ত নে অপনে কংধোং পর কপড়া রখা। ফির ৱহ উলটে চলতে হুএ ডেরে মেং দাখ়িল হুএ ঔর কপড়া অপনে বাপ পর ডাল দিযা। উনকে মুঁহ দূসরী তরফ় মুড়ে রহে তাকি বাপ কী বরহনগী নজ়র ন আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","জব নূহ হোশ মেং আযা তো উসকো পতা চলা কি সবসে ছোটে বেটে নে ক্যা কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","উসনে কহা, “কনান পর লানত! ৱহ অপনে ভাইযোং কা জ়লীলতরীন গ়ুলাম হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","মুবারক হো রব জো সিম কা খ়ুদা হৈ। কনান সিম কা গ়ুলাম হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","অল্লাহ করে কি যাফ়ত কী হুদূদ বঢ় জাএঁ। যাফ়ত সিম কে ডেরোং মেং রহে ঔর কনান উসকা গ়ুলাম হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","সৈলাব কে বাদ নূহ মজ়ীদ 350 সাল জ়িংদা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ৱহ 950 সাল কী উম্র মেং ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","যহ নূহ কে বেটোং সিম, হাম ঔর যাফ়ত কা নসবনামা হৈ। উনকে বেটে সৈলাব কে বাদ পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","যাফ়ত কে বেটে জুমর, মাজূজ, মাদী, যাৱান, তূবল, মসক ঔর তীরাস থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","জুমর কে বেটে অশ্কনাজ়, রীফ়ত ঔর তুজরমা থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","যাৱান কে বেটে ইলীসা ঔর তরসীস থে। কিত্তী ঔর দোদানী ভী উস কী ঔলাদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ৱহ উন ক়ৌমোং কে আবা-ও-অজদাদ হৈং জো সাহিলী ইলাক়োং ঔর জজ়ীরোং মেং ফৈল গঈং। যহ যাফ়ত কী ঔলাদ হৈং জো অপনে অপনে ক়বীলে ঔর মুল্ক মেং রহতে হুএ অপনী অপনী জ়বান বোলতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","হাম কে বেটে কূশ, মিসর, ফ়ূত ঔর কনান থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","কূশ কে বেটে সিবা, হৱীলা, সবতা, রামা ঔর সব্তকা থে। রামা কে বেটে সবা ঔর দদান থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","কূশ কা এক ঔর বেটা বনাম নমরূদ থা। ৱহ দুনিযা মেং পহলা জ়বরদস্ত হাকিম থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","রব কে নজ়দীক ৱহ জ়বরদস্ত শিকারী থা। ইসলিএ আজ ভী কিসী অচ্ছে শিকারী কে বারে মেং কহা জাতা হৈ, “ৱহ নমরূদ কী মানিংদ হৈ জো রব কে নজ়দীক জ়বরদস্ত শিকারী থা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","উস কী সলতনত কে পহলে মরকজ় মুল্কে-সিনার মেং বাবল, অরক, অক্কাদ ঔর কলনা কে শহর থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","উস মুল্ক সে নিকলকর ৱহ অসূর চলা গযা জহাঁ উসনে নীনৱা, রহোবোত-ঈর, কলহ ");
INSERT INTO urdgvb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ঔর রসন কে শহর তামীর কিএ। বড়া শহর রসন নীনৱা ঔর কলহ কে দরমিযান ৱাক়ে হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","মিসর ইন ক়ৌমোং কা বাপ থা : লূদী, অনামী, লিহাবী, নফ়তূহী, ");
INSERT INTO urdgvb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ফ়তরূসী, কসলূহী (জিনসে ফ়িলিস্তী নিকলে) ঔর কফ়তূরী। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","কনান কা পহলৌঠা সৈদা থা। কনান জ়ৈল কী ক়ৌমোং কা বাপ ভী থা : হিত্তী ");
INSERT INTO urdgvb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","যবূসী, অমোরী, জিরজাসী, ");
INSERT INTO urdgvb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","হিৱ্ৱী, অরক়ী, সীনী, ");
INSERT INTO urdgvb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","অরৱাদী, সমারী ঔর হমাতী। বাদ মেং কনানী ক়বীলে ইতনে ফৈল গএ ");
INSERT INTO urdgvb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","কি উনকী হুদূদ শিমাল মেং সৈদা সে জুনূব কী তরফ় জিরার সে হোকর গ়জ়্জ়া তক ঔর ৱহাঁ সে মশরিক় কী তরফ় সদূম, অমূরা, অদমা ঔর জ়বোঈম সে হোকর লসা তক থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","যহ সব হাম কী ঔলাদ হৈং, জো উনকে অপনে অপনে ক়বীলে, অপনী অপনী জ়বান, অপনে অপনে মুল্ক ঔর অপনী অপনী ক়ৌম কে মুতাবিক় দর্জ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","সিম যাফ়ত কা বড়া ভাঈ থা। উসকে ভী বেটে পৈদা হুএ। সিম তমাম বনী ইবর কা বাপ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","সিম কে বেটে ঐলাম, অসূর, অরফ়ক্সদ, লূদ ঔর অরাম থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","অরাম কে বেটে ঊজ়, হূল, জতর ঔর মস থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","অরফ়ক্সদ কা বেটা সিলহ ঔর সিলহ কা বেটা ইবর থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ইবর কে হাঁ দো বেটে পৈদা হুএ। এক কা নাম ফ়লজ যানী তক়সীম থা, ক্যোংকি উন ঐযাম মেং দুনিযা তক়সীম হুঈ। ফ়লজ কে ভাঈ কা নাম যুক়তান থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","যুক়তান কে বেটে অলমূদাদ, সলফ়, হসরমাৱত, ইরাখ়, ");
INSERT INTO urdgvb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","হদূরাম, ঊজ়াল, দিক়লা, ");
INSERT INTO urdgvb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ঊবাল, অবীমাএল, সবা, ");
INSERT INTO urdgvb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ওফ়ীর, হৱীলা ঔর যূবাব থে। যহ সব যুক়তান কে বেটে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ৱহ মেসা সে লেকর সফ়ার ঔর মশরিক়ী পহাড়ী ইলাক়ে তক আবাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","যহ সব সিম কী ঔলাদ হৈং, জো অপনে অপনে ক়বীলে, অপনী অপনী জ়বান, অপনে অপনে মুল্ক ঔর অপনী অপনী ক়ৌম কে মুতাবিক় দর্জ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","যহ সব নূহ কে বেটোং কে ক়বীলে হৈং, জো অপনী নসলোং ঔর ক়ৌমোং কে মুতাবিক় দর্জ কিএ গএ হৈং। সৈলাব কে বাদ তমাম ক়ৌমেং ইন্হীং সে নিকলকর রূএ-জ়মীন পর ফৈল গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","উস ৱক়্ত তক পূরী দুনিযা কে লোগ এক হী জ়বান বোলতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","মশরিক় কী তরফ় বঢ়তে বঢ়তে ৱহ সিনার কে এক মৈদান মেং পহুঁচকর ৱহাঁ আবাদ হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","তব ৱহ এক দূসরে সে কহনে লগে, “আও, হম মিট্টী সে ঈংটেং বনাকর উন্হেং আগ মেং খ়ূব পকাএঁ।” উন্হোংনে তামীরী কাম কে লিএ পত্থর কী জগহ ঈংটেং ঔর মসালে কী জগহ তারকোল ইস্তেমাল কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ফির ৱহ কহনে লগে, “আও, হম অপনে লিএ শহর বনা লেং জিসমেং ঐসা বুর্জ হো জো আসমান তক পহুঁচ জাএ ফির হমারা নাম ক়াযম রহেগা ঔর হম রূএ-জ়মীন পর বিখর জানে সে বচ জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","লেকিন রব উস শহর ঔর বুর্জ কো দেখনে কে লিএ উতর আযা জিসে লোগ বনা রহে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","রব নে কহা, “যহ লোগ এক হী ক়ৌম হৈং ঔর এক হী জ়বান বোলতে হৈং। ঔর যহ সির্ফ় উসকা আগ়াজ় হৈ জো ৱহ করনা চাহতে হৈং। অব সে জো ভী ৱহ মিলকর করনা চাহেংগে উসসে উন্হেং রোকা নহীং জা সকেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ইসলিএ আও, হম দুনিযা মেং উতরকর উনকী জ়বান কো দরহম-বরহম কর দেং তাকি ৱহ এক দূসরে কী বাত সমঝ ন পাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ইস তরীক়ে সে রব নে উন্হেং তমাম রূএ-জ়মীন পর মুংতশির কর দিযা, ঔর শহর কী তামীর রুক গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ইসলিএ শহর কা নাম বাবল যানী অবতরী ঠহরা, ক্যোংকি রব নে ৱহাঁ তমাম লোগোং কী জ়বান কো দরহম-বরহম করকে উন্হেং তমাম রূএ-জ়মীন পর মুংতশির কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","যহ সিম কা নসবনামা হৈ : সিম 100 সাল কা থা জব উসকা বেটা অরফ়ক্সদ পৈদা হুআ। যহ সৈলাব কে দো সাল বাদ হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ইসকে বাদ ৱহ মজ়ীদ 500 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","অরফ়ক্সদ 35 সাল কা থা জব সিলহ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ইসকে বাদ ৱহ মজ়ীদ 403 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","সিলহ 30 সাল কা থা জব ইবর পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ইসকে বাদ ৱহ মজ়ীদ 403 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ইবর 34 সাল কা থা জব ফ়লজ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ইসকে বাদ ৱহ মজ়ীদ 430 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ফ়লজ 30 সাল কা থা জব রঊ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ইসকে বাদ ৱহ মজ়ীদ 209 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","রঊ 32 সাল কা থা জব সরূজ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ইসকে বাদ ৱহ মজ়ীদ 207 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","সরূজ 30 সাল কা থা জব নহূর পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ইসকে বাদ ৱহ মজ়ীদ 200 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","নহূর 29 সাল কা থা জব তারহ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ইসকে বাদ ৱহ মজ়ীদ 119 সাল জ়িংদা রহা। উসকে ঔর বেটে-বেটিযাঁ ভী পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","তারহ 70 সাল কা থা জব উসকে বেটে অব্রাম, নহূর ঔর হারান পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","যহ তারহ কা নসবনামা হৈ : অব্রাম, নহূর ঔর হারান তারহ কে বেটে থে। লূত হারান কা বেটা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","অপনে বাপ তারহ কী জ়িংদগী মেং হী হারান কসদিযোং কে ঊর মেং ইংতক়াল কর গযা জহাঁ ৱহ পৈদা ভী হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","বাক়ী দোনোং বেটোং কী শাদী হুঈ। অব্রাম কী বীৱী কা নাম সারয থা ঔর নহূর কী বীৱী কা নাম মিলকাহ। মিলকাহ হারান কী বেটী থী, ঔর উস কী এক বহন বনাম ইস্কা থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","সারয বাঁঝ থী, ইসলিএ উসকে বচ্চে নহীং থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","তারহ কসদিযোং কে ঊর সে রৱানা হোকর মুল্কে-কনান কী তরফ় সফ়র করনে লগা। উসকে সাথ উসকা বেটা অব্রাম, উসকা পোতা লূত যানী হারান কা বেটা ঔর উস কী বহূ সারয থে। জব ৱহ হারান পহুঁচে তো ৱহাঁ আবাদ হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","তারহ 205 সাল কা থা জব উসনে হারান মেং ৱফ়াত পাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","রব নে অব্রাম সে কহা, “অপনে ৱতন, অপনে রিশ্তেদারোং ঔর অপনে বাপ কে ঘর কো ছোড়কর উস মুল্ক মেং চলা জা জো মৈং তুঝে দিখাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","মৈং তুঝসে এক বড়ী ক়ৌম বনাঊঁগা, তুঝে বরকত দূঁগা ঔর তেরে নাম কো বহুত বঢ়াঊঁগা। তূ দূসরোং কে লিএ বরকত কা বাইস হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","জো তুঝে বরকত দেংগে উন্হেং মৈং ভী বরকত দূঁগা। জো তুঝ পর লানত করেগা উস পর মৈং ভী লানত করূঁগা। দুনিযা কী তমাম ক়ৌমেং তুঝসে বরকত পাএঁগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","অব্রাম নে রব কী সুনী ঔর হারান সে রৱানা হুআ। লূত উসকে সাথ থা। উস ৱক়্ত অব্রাম 75 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","উসকে সাথ উস কী বীৱী সারয ঔর উসকা ভতীজা লূত থে। ৱহ অপনে নৌকর-চাকরোং সমেত অপনী পূরী মিলকিযত ভী সাথ লে গযা জো উসনে হারান মেং হাসিল কী থী। চলতে চলতে ৱহ কনান পহুঁচে। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","অব্রাম উস মুল্ক মেং সে গুজ়রকর সিকম কে মক়াম পর ঠহর গযা জহাঁ মোরিহ কে বলূত কা দরখ়্ত থা। উস জ়মানে মেং মুল্ক মেং কনানী ক়ৌমেং আবাদ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ৱহাঁ রব অব্রাম পর জ়াহির হুআ ঔর উসসে কহা, “মৈং তেরী ঔলাদ কো যহ মুল্ক দূঁগা।” ইসলিএ উসনে ৱহাঁ রব কী তাজ়ীম মেং ক়ুরবানগাহ বনাঈ জহাঁ ৱহ উস পর জ়াহির হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ৱহাঁ সে ৱহ উস পহাড়ী ইলাক়ে কী তরফ় গযা জো বৈতেল কে মশরিক় মেং হৈ। ৱহাঁ উসনে অপনা খ়ৈমা লগাযা। মগ়রিব মেং বৈতেল থা ঔর মশরিক় মেং অঈ। ইস জগহ পর ভী উসনে রব কী তাজ়ীম মেং ক়ুরবানগাহ বনাঈ ঔর রব কা নাম লেকর ইবাদত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ফির অব্রাম দুবারা রৱানা হোকর জুনূব কে দশ্তে-নজব কী তরফ় চল পড়া। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","উন দিনোং মেং মুল্কে-কনান মেং কাল পড়া। কাল ইতনা সখ়্ত থা কি অব্রাম উসসে বচনে কী খ়াতির কুছ দের কে লিএ মিসর মেং জা বসা, লেকিন পরদেসী কী হৈসিযত সে। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","জব ৱহ মিসর কী সরহদ কে ক়রীব আএ তো উসনে অপনী বীৱী সারয সে কহা, “মৈং জানতা হূঁ কি তূ কিতনী খ়ূবসূরত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","মিসরী তুঝে দেখেংগে, ফির কহেংগে, ‘যহ ইসকা শৌহর হৈ।’ নতীজে মেং ৱহ মুঝে মার ডালেংগে ঔর তুঝে জ়িংদা ছোড়েংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ইসলিএ লোগোং সে যহ কহতে রহনা কি মৈং অব্রাম কী বহন হূঁ। ফির মেরে সাথ অচ্ছা সুলূক কিযা জাএগা ঔর মেরী জান তেরে সবব সে বচ জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","জব অব্রাম মিসর পহুঁচা তো ৱাক়ঈ মিসরিযোং নে দেখা কি সারয নিহাযত হী খ়ূবসূরত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ঔর জব ফ়িরৌন কে অফ়সরান নে উসে দেখা তো উন্হোংনে ফ়িরৌন কে সামনে সারয কী তারীফ় কী। আখ়িরকার উসে মহল মেং পহুঁচাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ফ়িরৌন নে সারয কী খ়াতির অব্রাম পর এহসান করকে উসে ভেড়-বকরিযাঁ, গায-বৈল, গধে-গধিযাঁ, নৌকর-চাকর ঔর ঊঁট দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","লেকিন রব নে সারয কে সবব সে ফ়িরৌন ঔর উসকে ঘরানে মেং সখ়্ত ক়িস্ম কে অমরাজ় ফৈলাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","আখ়িরকার ফ়িরৌন নে অব্রাম কো বুলাকর কহা, “তূনে মেরে সাথ ক্যা কিযা? তূনে মুঝে ক্যোং নহীং বতাযা কি সারয তেরী বীৱী হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","তূনে ক্যোং কহা কি ৱহ মেরী বহন হৈ? ইস ধোকে কী বিনা পর মৈংনে উসে ঘর মেং রখ লিযা তাকি উসসে শাদী করূঁ। দেখ, তেরী বীৱী হাজ়ির হৈ। ইসে লেকর যহাঁ সে নিকল জা!” ");
INSERT INTO urdgvb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ফির ফ়িরৌন নে অপনে সিপাহিযোং কো হুক্ম দিযা, ঔর উন্হোংনে অব্রাম, উস কী বীৱী ঔর পূরী মিলকিযত কো রুখ়সত করকে মুল্ক সে রৱানা কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","অব্রাম অপনী বীৱী, লূত ঔর তমাম জাযদাদ কো সাথ লেকর মিসর সে নিকলা ঔর কনান কে জুনূবী ইলাক়ে দশ্তে-নজব মেং ৱাপস আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","অব্রাম নিহাযত দৌলতমংদ হো গযা থা। উসকে পাস বহুত-সে মৱেশী ঔর সোনা-চাঁদী থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ৱহাঁ সে জগহ বজগহ চলতে হুএ ৱহ আখ়িরকার বৈতেল সে হোকর উস মক়াম তক পহুঁচ গযা জহাঁ উসনে শুরূ মেং অপনা ডেরা লগাযা থা ঔর জো বৈতেল ঔর অঈ কে দরমিযান থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ৱহাঁ জহাঁ উসনে ক়ুরবানগাহ বনাঈ থী উসনে রব কা নাম লেকর উস কী ইবাদত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","লূত কে পাস ভী বহুত-সী ভেড়-বকরিযাঁ, গায-বৈল ঔর খ়ৈমে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","নতীজা যহ নিকলা কি আখ়িরকার ৱহ মিলকর ন রহ সকে, ক্যোংকি ইতনী জগহ নহীং থী কি দোনোং কে রেৱড় এক হী জগহ পর চর সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","অব্রাম ঔর লূত কে চরৱাহে আপস মেং ঝগড়নে লগে। (উস জ়মানে মেং কনানী ঔর ফ়রিজ়্জ়ী ভী মুল্ক মেং আবাদ থে।) ");
INSERT INTO urdgvb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","তব অব্রাম নে লূত সে বাত কী, “ঐসা নহীং হোনা চাহিএ কি তেরে ঔর মেরে দরমিযান ঝগড়া হো যা তেরে চরৱাহোং ঔর মেরে চরৱাহোং কে দরমিযান। হম তো ভাঈ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ক্যা জ়রূরত হৈ কি হম মিলকর রহেং জবকি তূ আসানী সে ইস মুল্ক কী কিসী ঔর জগহ রহ সকতা হৈ। বেহতর হৈ কি তূ মুঝসে অলগ হোকর কহীং ঔর রহে। অগর তূ বাএঁ হাথ জাএ তো মৈং দাএঁ হাথ জাঊঁগা, ঔর অগর তূ দাএঁ হাথ জাএ তো মৈং বাএঁ হাথ জাঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","লূত নে অপনী নজ়র উঠাকর দেখা কি দরিযাএ-যরদন কে পূরে ইলাক়ে মেং জ়ুগ়র তক পানী কী কসরত হৈ। ৱহ রব কে বাগ় যা মুল্কে-মিসর কী মানিংদ থা, ক্যোংকি উস ৱক়্ত রব নে সদূম ঔর অমূরা কো তবাহ নহীং কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","চুনাঁচে লূত নে দরিযাএ-যরদন কে পূরে ইলাক়ে কো চুন লিযা ঔর মশরিক় কী তরফ় জা বসা। যোং দোনোং রিশ্তেদার এক দূসরে সে জুদা হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","অব্রাম মুল্কে-কনান মেং রহা জবকি লূত যরদন কে ইলাক়ে কে শহরোং কে দরমিযান আবাদ হো গযা। ৱহাঁ উসনে অপনে খ়ৈমে সদূম কে ক়রীব লগা দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","লেকিন সদূম কে বাশিংদে নিহাযত শরীর থে, ঔর উনকে রব কে খ়িলাফ় গুনাহ নিহাযত মকরূহ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","লূত অব্রাম সে জুদা হুআ তো রব নে অব্রাম সে কহা, “অপনী নজ়র উঠাকর চারোং তরফ় যানী শিমাল, জুনূব, মশরিক় ঔর মগ়রিব কী তরফ় দেখ। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","জো ভী জ়মীন তুঝে নজ়র আএ উসে মৈং তুঝে ঔর তেরী ঔলাদ কো হমেশা কে লিএ দেতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","মৈং তেরী ঔলাদ কো খ়াক কী তরহ বেশুমার হোনে দূঁগা। জিস তরহ খ়াক কে জ়র্রে গিনে নহীং জা সকতে উসী তরহ তেরী ঔলাদ ভী গিনী নহীং জা সকেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","চুনাঁচে উঠকর ইস মুল্ক কী হর জগহ চল-ফির, ক্যোংকি মৈং ইসে তুঝে দেতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","অব্রাম রৱানা হুআ। চলতে চলতে উসনে অপনে ডেরে হবরূন কে ক়রীব মমরে কে দরখ়্তোং কে পাস লগাএ। ৱহাঁ উসনে রব কী তাজ়ীম মেং ক়ুরবানগাহ বনাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","কনান মেং জংগ হুঈ। বৈরূনে-মুল্ক কে চার বাদশাহোং নে কনান কে পাঁচ বাদশাহোং সে জংগ কী। বৈরূনে-মুল্ক কে বাদশাহ যহ থে : সিনার সে অমরাফ়িল, ইল্লাসর সে অরযূক, ঐলাম সে কিদরলাউমর ঔর জোযম সে তিদাল। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","কনান কে বাদশাহ যহ থে : সদূম সে বিরা, অমূরা সে বিরশা, অদমা সে সিনিযাব, জ়বোঈম সে শিমেবর ঔর বালা যানী জ়ুগ়র কা বাদশাহ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","কনান কে ইন পাঁচ বাদশাহোং কা ইত্তহাদ হুআ থা ঔর ৱহ ৱাদীএ-সিদ্দীম মেং জমা হুএ থে। (অব সিদ্দীম নহীং হৈ, ক্যোংকি উস কী জগহ বহীরাএ-মুরদার আ গযা হৈ)। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","কিদরলাউমর নে বারহ সাল তক উন পর হুকূমত কী থী, লেকিন তেরহৱেং সাল ৱহ বাগ়ী হো গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","অব এক সাল কে বাদ কিদরলাউমর ঔর উসকে ইত্তহাদী অপনী ফ়ৌজোং কে সাথ আএ। পহলে উন্হোংনে অস্তারাত-ক়রনৈম মেং রফ়াইযোং কো, হাম মেং জ়ূজ়িযোং কো, সৱী-ক়িরিযতাযম মেং ঐমিযোং কো ");
INSERT INTO urdgvb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ঔর হোরিযোং কো উনকে পহাড়ী ইলাক়ে সঈর মেং শিকস্ত দী। যোং ৱহ এল-ফ়ারান তক পহুঁচ গএ জো রেগিস্তান কে কিনারে পর হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ফির ৱহ ৱাপস আএ ঔর ঐন-মিসফ়াত যানী ক়াদিস পহুঁচে। উন্হোংনে অমালীক়িযোং কে পূরে ইলাক়ে কো তবাহ কর দিযা ঔর হসসূন-তমর মেং আবাদ অমোরিযোং কো ভী শিকস্ত দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","উস ৱক়্ত সদূম, অমূরা, অদমা, জ়বোঈম ঔর বালা যানী জ়ুগ়র কে বাদশাহ উনসে লড়নে কে লিএ সিদ্দীম কী ৱাদী মেং জমা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ইন পাঁচ বাদশাহোং নে ঐলাম কে বাদশাহ কিদরলাউমর, জোযম কে বাদশাহ তিদাল, সিনার কে বাদশাহ অমরাফ়িল ঔর ইল্লাসর কে বাদশাহ অরযূক কা মুক়াবলা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ইস ৱাদী মেং তারকোল কে মুতঅদ্দিদ গঢ়ে থে। জব বাগ়ী বাদশাহ শিকস্ত খাকর ভাগনে লগে তো সদূম ঔর অমূরা কে বাদশাহ ইন গঢ়োং মেং গির গএ জবকি বাক়ী তীন বাদশাহ বচকর পহাড়ী ইলাক়ে মেং ফ়রার হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ফ়তহমংদ বাদশাহ সদূম ঔর অমূরা কা তমাম মাল তমাম খানেৱালী চীজ়োং সমেত লূটকর ৱাপস চল দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","অব্রাম কা ভতীজা লূত সদূম মেং রহতা থা, ইসলিএ ৱহ উসে ভী উস কী মিলকিযত সমেত ছীনকর সাথ লে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","লেকিন এক আদমী নে জো বচ নিকলা থা ইবরানী মর্দ অব্রাম কে পাস আকর উসে সব কুছ বতা দিযা। উস ৱক়্ত ৱহ মমরে কে দরখ়্তোং কে পাস আবাদ থা। মমরে অমোরী থা। ৱহ ঔর উসকে ভাঈ ইসকাল ঔর আনের অব্রাম কে ইত্তহাদী থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","জব অব্রাম কো পতা চলা কি ভতীজে কো গিরিফ়্তার কর লিযা গযা হৈ তো উসনে অপনে ঘর মেং পৈদা হুএ তমাম জংগআজ়মূদা গ়ুলামোং কো জমা করকে দান তক দুশ্মন কা তাক়্ক়ুব কিযা। উসকে সাথ 318 অফ়রাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ৱহাঁ উসনে অপনে বংদোং কো গুরোহোং মেং তক়সীম করকে রাত কে ৱক়্ত দুশ্মন পর হমলা কিযা। দুশ্মন শিকস্ত খাকর ভাগ গযা ঔর অব্রাম নে দমিশ্ক় কে শিমাল মেং ৱাক়ে খ়ূবা তক উসকা তাক়্ক়ুব কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ৱহ উনসে লূটা হুআ তমাম মাল ৱাপস লে আযা। লূত, উস কী জাযদাদ, ঔরতেং ঔর বাক়ী ক়ৈদী ভী দুশ্মন কে ক়ব্জ়ে সে বচ নিকলে। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","জব অব্রাম কিদরলাউমর ঔর উসকে ইত্তহাদিযোং পর ফ়তহ পানে কে বাদ ৱাপস পহুঁচা তো সদূম কা বাদশাহ উসসে মিলনে কে লিএ ৱাদীএ-সৱী মেং আযা। (ইসে আজকল বাদশাহ কী ৱাদী কহা জাতা হৈ।) ");
INSERT INTO urdgvb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","সালিম কা বাদশাহ মলিকে-সিদ্ক় ভী ৱহাঁ পহুঁচা। ৱহ অপনে সাথ রোটী ঔর মৈ লে আযা। মলিকে-সিদ্ক় অল্লাহ তআলা কা ইমাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","উসনে অব্রাম কো বরকত দেকর কহা, “অব্রাম পর অল্লাহ তআলা কী বরকত হো, জো আসমানো-জ়মীন কা খ়ালিক় হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","অল্লাহ তআলা মুবারক হো জিসনে তেরে দুশ্মনোং কো তেরে হাথ মেং কর দিযা হৈ।” অব্রাম নে উসে তমাম মাল কা দসৱাঁ হিস্সা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","সদূম কে বাদশাহ নে অব্রাম সে কহা, “মুঝে মেরে লোগ ৱাপস কর দেং ঔর বাক়ী চীজ়েং অপনে পাস রখ লেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","লেকিন অব্রাম নে উসসে কহা, “মৈংনে রব সে ক়সম খাঈ হৈ, অল্লাহ তআলা সে জো আসমানো-জ়মীন কা খ়ালিক় হৈ ");
INSERT INTO urdgvb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","কি মৈং উসমেং সে কুছ নহীং লূঁগা জো আপকা হৈ, চাহে ৱহ ধাগা যা জূতী কা তসমা হী ক্যোং ন হো। ঐসা ন হো কি আপ কহেং, ‘মৈংনে অব্রাম কো দৌলতমংদ বনা দিযা হৈ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","সিৱাএ উস খানে কে জো মেরে আদমিযোং নে রাস্তে মেং খাযা হৈ মৈং কুছ ক়বূল নহীং করূঁগা। লেকিন মেরে ইত্তহাদী আনের, ইসকাল ঔর মমরে জ়রূর অপনা অপনা হিস্সা লেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ইসকে বাদ রব রোযা মেং অব্রাম সে হমকলাম হুআ, “অব্রাম, মত ডর। মৈং হী তেরী সিপর হূঁ, মৈং হী তেরা বহুত বড়া অজ্র হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","লেকিন অব্রাম নে এতরাজ় কিযা, “ঐ রব ক়াদিরে-মুতলক়, তূ মুঝে ক্যা দেগা জবকি অভী তক মেরে হাঁ কোঈ বচ্চা নহীং হৈ ঔর ইলিযজ়র দমিশ্ক়ী মেরী মীরাস পাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","তূনে মুঝে ঔলাদ নহীং বখ়্শী, ইসলিএ মেরে ঘরানে কা নৌকর মেরা ৱারিস হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","তব অব্রাম কো অল্লাহ সে এক ঔর কলাম মিলা। “যহ আদমী ইলিযজ়র তেরা ৱারিস নহীং হোগা বল্কি তেরা অপনা হী বেটা তেরা ৱারিস হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","রব নে উসে বাহর লে জাকর কহা, “আসমান কী তরফ় দেখ ঔর সিতারোং কো গিননে কী কোশিশ কর। তেরী ঔলাদ ইতনী হী বেশুমার হোগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","অব্রাম নে রব পর ভরোসা রখা। ইস বিনা পর অল্লাহ নে উসে রাস্তবাজ় ক়রার দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ফির রব নে উসসে কহা, “মৈং রব হূঁ জো তুঝে কসদিযোং কে ঊর সে যহাঁ লে আযা তাকি তুঝে যহ মুল্ক মীরাস মেং দে দূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","অব্রাম নে পূছা, “ঐ রব ক়াদিরে-মুতলক়, মৈং কিস তরহ জানূঁ কি ইস মুল্ক পর ক়ব্জ়া করূঁগা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","জৱাব মেং রব নে কহা, “মেরে হুজ়ূর এক তীন-সালা গায, এক তীন-সালা বকরী ঔর এক তীন-সালা মেংঢা লে আ। এক ক়ুম্রী ঔর এক কবূতর কা বচ্চা ভী লে আনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","অব্রাম নে ঐসা হী কিযা ঔর ফির হর এক জানৱর কো দো হিস্সোং মেং কাটকর উনকো এক দূসরে কে আমনে-সামনে রখ দিযা। লেকিন পরিংদোং কো উসনে সালিম রহনে দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","শিকারী পরিংদে উন পর উতরনে লগে, লেকিন অব্রাম উন্হেং ভগাতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","জব সূরজ ডূবনে লগা তো অব্রাম পর গহরী নীংদ তারী হুঈ। উস পর দহশত ঔর অংধেরা হী অংধেরা ছা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ফির রব নে উসসে কহা, “জান লে কি তেরী ঔলাদ ঐসে মুল্ক মেং রহেগী জো উসকা নহীং হোগা। ৱহাঁ ৱহ অজনবী ঔর গ়ুলাম হোগী, ঔর উস পর 400 সাল তক বহুত জ়ুল্ম কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","লেকিন মৈং উস ক়ৌম কী অদালত করূঁগা জিসনে উসে গ়ুলাম বনাযা হোগা। ইসকে বাদ ৱহ বড়ী দৌলত পাকর উস মুল্ক সে নিকলেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","তূ খ়ুদ উম্ররসীদা হোকর সলামতী কে সাথ ইংতক়াল করকে অপনে বাপদাদা সে জা মিলেগা ঔর দফ়নাযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","তেরী ঔলাদ কী চৌথী পুশ্ত গ়ৈরৱতন সে ৱাপস আএগী, ক্যোংকি উস ৱক়্ত তক মৈং অমোরিযোং কো বরদাশ্ত করূঁগা। লেকিন আখ়িরকার উনকে গুনাহ ইতনে সংগীন হো জাএংগে কি মৈং উন্হেং মুল্কে-কনান সে নিকাল দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","সূরজ গ়ুরূব হুআ। অংধেরা ছা গযা। অচানক এক ধুআঁদার তনূর ঔর এক ভড়কতী হুঈ মশাল নজ়র আঈ ঔর জানৱরোং কে দো দো টুকড়োং কে বীচ মেং সে গুজ়রে। ");
INSERT INTO urdgvb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","উস ৱক়্ত রব নে অব্রাম কে সাথ অহদ কিযা। উসনে কহা, “মৈং যহ মুল্ক মিসর কী সরহদ সে ফ়ুরাত তক তেরী ঔলাদ কো দূঁগা, ");
INSERT INTO urdgvb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","অগরচে অভী তক ইসমেং ক়ীনী, ক়নিজ়্জ়ী, কদমূনী, ");
INSERT INTO urdgvb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","হিত্তী, ফ়রিজ়্জ়ী, রফ়াঈ, ");
INSERT INTO urdgvb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","অমোরী, কনানী, জিরজাসী ঔর যবূসী আবাদ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","অব তক অব্রাম কী বীৱী সারয কে কোঈ বচ্চা নহীং হুআ থা। লেকিন উন্হোংনে এক মিসরী লৌংডী রখী থী জিসকা নাম হাজিরা থা, ");
INSERT INTO urdgvb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ঔর এক দিন সারয নে অব্রাম সে কহা, “রব নে মুঝে বচ্চে পৈদা করনে সে মহরূম রখা হৈ, ইসলিএ মেরী লৌংডী কে সাথ হমবিসতর হোং। শাযদ মুঝে উস কী মারিফ়ত বচ্চা মিল জাএ।” অব্রাম নে সারয কী বাত মান লী। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","চুনাঁচে সারয নে অপনী মিসরী লৌংডী হাজিরা কো অপনে শৌহর অব্রাম কো দে দিযা তাকি ৱহ উস কী বীৱী বন জাএ উস ৱক়্ত অব্রাম কো কনান মেং বসতে হুএ দস সাল হো গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","অব্রাম হাজিরা সে হমবিসতর হুআ তো ৱহ উম্মীদ সে হো গঈ। জব হাজিরা কো যহ মালূম হুআ তো ৱহ অপনী মালিকন কো হক়ীর জাননে লগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","তব সারয নে অব্রাম সে কহা, “জো জ়ুল্ম মুঝ পর কিযা জা রহা হৈ ৱহ আপ হী পর আএ। মৈংনে খ়ুদ ইসে আপকে বাজ়ুওং মেং দে দিযা থা। অব জব ইসে মালূম হুআ হৈ কি উম্মীদ সে হৈ তো মুঝে হক়ীর জাননে লগী হৈ। রব মেরে ঔর আপকে দরমিযান ফ়ৈসলা করে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","অব্রাম নে জৱাব দিযা, “দেখো, যহ তুম্হারী লৌংডী হৈ ঔর তুম্হারে ইখ়্তিযার মেং হৈ। জো তুম্হারা জী চাহে উসকে সাথ করো।” ইস পর সারয উসসে ইতনা বুরা সুলূক করনে লগী কি হাজিরা ফ়রার হো গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","রব কে ফ়রিশ্তে কো হাজিরা রেগিস্তান কে উস চশ্মে কে ক়রীব মিলী জো শূর কে রাস্তে পর হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","উসনে কহা, “সারয কী লৌংডী হাজিরা, তূ কহাঁ সে আ রহী হৈ ঔর কহাঁ জা রহী হৈ?” হাজিরা নে জৱাব দিযা, “মৈং অপনী মালিকন সারয সে ফ়রার হো রহী হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","রব কে ফ়রিশ্তে নে উসসে কহা, “অপনী মালিকন কে পাস ৱাপস চলী জা ঔর উসকে তাবে রহ। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","মৈং তেরী ঔলাদ ইতনী বঢ়াঊঁগা কি উসে গিনা নহীং জা সকেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","রব কে ফ়রিশ্তে নে মজ়ীদ কহা, “তূ উম্মীদ সে হৈ। এক বেটা পৈদা হোগা। উসকা নাম ইসমাঈল যানী ‘অল্লাহ সুনতা হৈ’ রখ, ক্যোংকি রব নে মুসীবত মেং তেরী আৱাজ় সুনী। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ৱহ জংগলী গধে কী মানিংদ হোগা। উসকা হাথ হর এক কে খ়িলাফ় ঔর হর এক কা হাথ উসকে খ়িলাফ় হোগা। তো ভী ৱহ অপনে তমাম ভাইযোং কে সামনে আবাদ রহেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","রব কে উসকে সাথ বাত করনে কে বাদ হাজিরা নে উসকা নাম অত্তাএল-রোঈ যানী ‘তূ এক মাবূদ হৈ জো মুঝে দেখতা হৈ’ রখা। উসনে কহা, “ক্যা মৈংনে ৱাক়ঈ উসকে পীছে দেখা হৈ জিসনে মুঝে দেখা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ইসলিএ উস জগহ কে কুএঁ কা নাম ‘বৈর-লহী-রোঈ’ যানী ‘উস জ়িংদা হস্তী কা কুআঁ জো মুঝে দেখতা হৈ’ পড় গযা। ৱহ ক়াদিস ঔর বরদ কে দরমিযান ৱাক়ে হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","হাজিরা ৱাপস গঈ, ঔর উসকে বেটা পৈদা হুআ। অব্রাম নে উসকা নাম ইসমাঈল রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","উস ৱক়্ত অব্রাম 86 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","জব অব্রাম 99 সাল কা থা তো রব উস পর জ়াহির হুআ। উসনে কহা, “মৈং অল্লাহ ক়াদিরে-মুতলক় হূঁ। মেরে হুজ়ূর চলতা রহ ঔর বেইলজ়াম হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","মৈং তেরে সাথ অপনা অহদ বাঁধূঁগা ঔর তেরী ঔলাদ কো বহুত হী জ়্যাদা বঢ়া দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","অব্রাম মুঁহ কে বল গির গযা, ঔর অল্লাহ নে উসসে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“মেরা তেরে সাথ অহদ হৈ কি তূ বহুত ক়ৌমোং কা বাপ হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","অব সে তূ অব্রাম যানী ‘অজ়ীম বাপ’ নহীং কহলাএগা বল্কি তেরা নাম ইব্রাহীম যানী ‘বহুত ক়ৌমোং কা বাপ’ হোগা। ক্যোংকি মৈংনে তুঝে বহুত ক়ৌমোং কা বাপ বনা দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","মৈং তুঝে বহুত হী জ়্যাদা ঔলাদ বখ়্শ দূঁগা, ইতনী কি ক়ৌমেং বনেংগী। তুঝসে বাদশাহ ভী নিকলেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","মৈং অপনা অহদ তেরে ঔর তেরী ঔলাদ কে সাথ নসল-দর-নসল ক়াযম করূঁগা, এক অবদী অহদ জিসকে মুতাবিক় মৈং তেরা ঔর তেরী ঔলাদ কা খ়ুদা হূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","তূ ইস ৱক়্ত মুল্কে-কনান মেং পরদেসী হৈ, লেকিন মৈং ইস পূরে মুল্ক কো তুঝে ঔর তেরী ঔলাদ কো দেতা হূঁ। যহ হমেশা তক উনকা হী রহেগা, ঔর মৈং উনকা খ়ুদা হূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","অল্লাহ নে ইব্রাহীম সে যহ ভী কহা, “তুঝে ঔর তেরী ঔলাদ কো নসল-দর-নসল মেরে অহদ কী শরাযত পূরী করনী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ইসকী এক শর্ত যহ হৈ কি হর এক মর্দ কা খ়তনা কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","অপনা খ়তনা করাও। যহ হমারে আপস কে অহদ কা জ়াহিরী নিশান হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","লাজ়িম হৈ কি তূ ঔর তেরী ঔলাদ নসল-দর-নসল অপনে হর এক বেটে কা আঠৱেং দিন খ়তনা করৱাএঁ। যহ উসূল উস পর ভী লাগূ হৈ জো তেরে ঘর মেং রহতা হৈ লেকিন তুঝসে রিশ্তা নহীং রখতা, চাহে ৱহ ঘর মেং পৈদা হুআ হো যা কিসী অজনবী সে খ়রীদা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ঘর কে হর এক মর্দ কা খ়তনা করনা লাজ়িম হৈ, খ়াহ ৱহ ঘর মেং পৈদা হুআ হো যা কিসী অজনবী সে খ়রীদা গযা হো। যহ ইস বাত কা নিশান হোগা কি মেরা তেরে সাথ অহদ হমেশা তক ক়াযম রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","জিস মর্দ কা খ়তনা ন কিযা গযা উসে উস কী ক়ৌম মেং সে মিটাযা জাএগা, ক্যোংকি উসনে মেরে অহদ কী শরাযত পূরী ন কীং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","অল্লাহ নে ইব্রাহীম সে যহ ভী কহা, “অপনী বীৱী সারয কা নাম ভী বদল দেনা। অব সে উসকা নাম সারয নহীং বল্কি সারা যানী শহজ়াদী হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","মৈং উসে বরকত বখ়্শূঁগা ঔর তুঝে উস কী মারিফ়ত বেটা দূঁগা। মৈং উসে যহাঁ তক বরকত দূঁগা কি উসসে ক়ৌমেং বল্কি ক়ৌমোং কে বাদশাহ নিকলেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ইব্রাহীম মুঁহ কে বল গির গযা। লেকিন দিল হী দিল মেং ৱহ হঁস পড়া ঔর সোচা, “যহ কিস তরহ হো সকতা হৈ? মৈং তো 100 সাল কা হূঁ। ঐসে আদমী কে হাঁ বচ্চা কিস তরহ পৈদা হো সকতা হৈ? ঔর সারা জৈসী উম্ররসীদা ঔরত কে বচ্চা কিস তরহ পৈদা হো সকতা হৈ? উস কী উম্র তো 90 সাল হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","উসনে অল্লাহ সে কহা, “হাঁ, ইসমাঈল হী তেরে সামনে জীতা রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","অল্লাহ নে কহা, “নহীং, তেরী বীৱী সারা কে হাঁ বেটা পৈদা হোগা। তূ উসকা নাম ইসহাক় যানী ‘ৱহ হঁসতা হৈ’ রখনা। মৈং উসকে ঔর উস কী ঔলাদ কে সাথ অবদী অহদ বাঁধূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","মৈং ইসমাঈল কে সিলসিলে মেং ভী তেরী দরখ়াস্ত পূরী করূঁগা। মৈং উসে ভী বরকত দেকর ফলনে ফূলনে দূঁগা ঔর উস কী ঔলাদ বহুত হী জ়্যাদা বঢ়া দূঁগা। ৱহ বারহ রঈসোং কা বাপ হোগা, ঔর মৈং উস কী মারিফ়ত এক বড়ী ক়ৌম বনাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","লেকিন মেরা অহদ ইসহাক় কে সাথ হোগা, জো ঐন এক সাল কে বাদ সারা কে হাঁ পৈদা হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","অল্লাহ কী ইব্রাহীম কে সাথ বাত খ়ত্ম হুঈ, ঔর ৱহ উসকে পাস সে আসমান পর চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","উসী দিন ইব্রাহীম নে অল্লাহ কা হুক্ম পূরা কিযা। উসনে ঘর কে হর এক মর্দ কা খ়তনা করৱাযা, অপনে বেটে ইসমাঈল কা ভী ঔর উনকা ভী জো উসকে ঘর মেং রহতে লেকিন উসসে রিশ্তা নহীং রখতে থে, চাহে ৱহ উসকে ঘর মেং পৈদা হুএ থে যা খ়রীদে গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ইব্রাহীম 99 সাল কা থা জব উসকা খ়তনা হুআ, ");
INSERT INTO urdgvb_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","জবকি উসকা বেটা ইসমাঈল 13 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","দোনোং কা খ়তনা উসী দিন হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","সাথ সাথ ঘরানে কে তমাম বাক়ী মর্দোং কা খ়তনা ভী হুআ, বশমূল উনকে জিনকা ইব্রাহীম কে সাথ রিশ্তা নহীং থা, চাহে ৱহ ঘর মেং পৈদা হুএ যা কিসী অজনবী সে খ়রীদে গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","এক দিন রব মমরে কে দরখ়্তোং কে পাস ইব্রাহীম পর জ়াহির হুআ। ইব্রাহীম অপনে খ়ৈমে কে দরৱাজ়ে পর বৈঠা থা। দিন কী গরমী উরূজ পর থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","অচানক উসনে দেখা কি তীন মর্দ মেরে সামনে খড়ে হৈং। উন্হেং দেখতে হী ৱহ খ়ৈমে সে উনসে মিলনে কে লিএ দৌড়া ঔর মুঁহ কে বল গিরকর সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","উসনে কহা, “মেরে আক়া, অগর মুঝ পর আপকে করম কী নজ়র হৈ তো আগে ন বঢ়েং বল্কি কুছ দের অপনে বংদে কে ঘর ঠহরেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","অগর ইজাজ়ত হো তো মৈং কুছ পানী লে আঊঁ তাকি আপ অপনে পাঁৱ ধোকর দরখ়্ত কে সাযে মেং আরাম কর সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","সাথ সাথ মৈং আপকে লিএ থোড়া-বহুত খানা ভী লে আঊঁ তাকি আপ তক়ৱিযত পাকর আগে বঢ় সকেং। মুঝে যহ করনে দেং, ক্যোংকি আপ অপনে খ়াদিম কে ঘর আ গএ হৈং।” উন্হোংনে কহা, “ঠীক হৈ। জো কুছ তূনে কহা হৈ ৱহ কর।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ইব্রাহীম খ়ৈমে কী তরফ় দৌড়কর সারা কে পাস আযা ঔর কহা, “জল্দী করো! 16 কিলোগ্রাম বেহতরীন মৈদা লে ঔর উসে গূঁধকর রোটিযাঁ বনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ফির ৱহ ভাগকর বৈলোং কে পাস পহুঁচা। উনমেং সে উসনে এক মোটা-তাজ়া বছড়া চুন লিযা জিসকা গোশ্ত নরম থা ঔর উসে অপনে নৌকর কো দিযা জিসনে জল্দী সে উসে তৈযার কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","জব খানা তৈযার থা তো ইব্রাহীম নে উসে লেকর লস্সী ঔর দূধ কে সাথ অপনে মেহমানোং কে আগে রখ দিযা। ৱহ খানে লগে ঔর ইব্রাহীম উনকে সামনে দরখ়্ত কে সাযে মেং খড়া রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","উন্হোংনে পূছা, “তেরী বীৱী সারা কহাঁ হৈ?” উসনে জৱাব দিযা, “খ়ৈমে মেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","রব নে কহা, “ঐন এক সাল কে বাদ মৈং ৱাপস আঊঁগা তো তেরী বীৱী সারা কে বেটা হোগা।” সারা যহ বাতেং সুন রহী থী, ক্যোংকি ৱহ উসকে পীছে খ়ৈমে কে দরৱাজ়ে কে পাস থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","দোনোং মিযাঁ-বীৱী বূঢ়ে হো চুকে থে ঔর সারা উস উম্র সে গুজ়র চুকী থী জিসমেং ঔরতোং কে বচ্চে পৈদা হোতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ইসলিএ সারা অংদর হী অংদর হঁস পড়ী ঔর সোচা, “যহ কৈসে হো সকতা হৈ? ক্যা জব মৈং বুঢ়াপে কে বাইস ঘিসে-ফটে লিবাস কী মানিংদ হূঁ তো জৱানী কে জোবন কা লুত্ফ় উঠাঊঁ? ঔর মেরা শৌহর ভী বূঢ়া হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","রব নে ইব্রাহীম সে পূছা, “সারা ক্যোং হঁস রহী হৈ? ৱহ ক্যোং কহ রহী হৈ, ‘ক্যা ৱাক়ঈ মেরে হাঁ বচ্চা পৈদা হোগা জবকি মৈং ইতনী উম্ররসীদা হূঁ?’ ");
INSERT INTO urdgvb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ক্যা রব কে লিএ কোঈ কাম নামুমকিন হৈ? এক সাল কে বাদ মুক়র্ররা ৱক়্ত পর মৈং ৱাপস আঊঁগা তো সারা কে বেটা হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","সারা ডর গঈ। উসনে ঝূট বোলকর ইনকার কিযা, “মৈং নহীং হঁস রহী থী।” রব নে কহা, “নহীং, তূ জ়রূর হঁস রহী থী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ফির মেহমান উঠকর রৱানা হুএ ঔর নীচে ৱাদী মেং সদূম কী তরফ় দেখনে লগে। ইব্রাহীম উন্হেং রুখ়সত করনে কে লিএ সাথ সাথ চল রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","রব নে দিল মেং কহা, “মৈং ইব্রাহীম সে ৱহ কাম ক্যোং ছুপাএ রখূঁ জো মৈং করনে কে লিএ জা রহা হূঁ? ");
INSERT INTO urdgvb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ইসী সে তো এক বড়ী ঔর তাক়তৱর ক়ৌম নিকলেগী ঔর ইসী সে মৈং দুনিযা কী তমাম ক়ৌমোং কো বরকত দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","উসী কো মৈংনে চুন লিযা হৈ তাকি ৱহ অপনী ঔলাদ ঔর অপনে বাদ কে ঘরানে কো হুক্ম দে কি ৱহ রব কী রাহ পর চলকর রাস্ত ঔর মুংসিফ়ানা কাম করেং। ক্যোংকি অগর ৱহ ঐসা করেং তো রব ইব্রাহীম কে সাথ অপনা ৱাদা পূরা করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ফির রব নে কহা, “সদূম ঔর অমূরা কী বদী কে বাইস লোগোং কী আহেং বুলংদ হো রহী হৈং, ক্যোংকি উনসে বহুত সংগীন গুনাহ সরজ়দ হো রহে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","মৈং উতরকর উনকে পাস জা রহা হূঁ তাকি দেখূঁ কি যহ ইলজ়াম ৱাক়ঈ সচ হৈং জো মুঝ তক পহুঁচে হৈং। অগর ঐসা নহীং হৈ তো মৈং যহ জাননা চাহতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","দূসরে দো আদমী সদূম কী তরফ় আগে নিকলে জবকি রব কুছ দের কে লিএ ৱহাঁ ঠহরা রহা ঔর ইব্রাহীম উসকে সামনে খড়া রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ফির উসনে ক়রীব আকর উসসে বাত কী, “ক্যা তূ রাস্তবাজ়োং কো ভী শরীরোং কে সাথ তবাহ কর দেগা? ");
INSERT INTO urdgvb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","হো সকতা হৈ কি শহর মেং 50 রাস্তবাজ় হোং। ক্যা তূ ফির ভী শহর কো বরবাদ কর দেগা ঔর উসে উন 50 কে সবব সে মুআফ় নহীং করেগা? ");
INSERT INTO urdgvb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","যহ কৈসে হো সকতা হৈ কি তূ বেক়ুসূরোং কো শরীরোং কে সাথ হলাক কর দে? যহ তো নামুমকিন হৈ কি তূ নেক ঔর শরীর লোগোং সে এক জৈসা সুলূক করে। ক্যা লাজ়িম নহীং কি পূরী দুনিযা কা মুংসিফ় ইনসাফ় করে?” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","রব নে জৱাব দিযা, “অগর মুঝে শহর মেং 50 রাস্তবাজ় মিল জাএঁ তো উনকে সবব সে তমাম কো মুআফ় কর দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ইব্রাহীম নে কহা, “মৈং মুআফ়ী চাহতা হূঁ কি মৈংনে রব সে বাত করনে কী জুর্রত কী হৈ অগরচে মৈং খ়াক ঔর রাখ হী হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","লেকিন হো সকতা হৈ কি সির্ফ় 45 রাস্তবাজ় উসমেং হোং। ক্যা তূ ফির ভী উন পাঁচ লোগোং কী কমী কে সবব সে পূরে শহর কো তবাহ করেগা?” উসনে কহা, “অগর মুঝে 45 ভী মিল জাএঁ তো উসে বরবাদ নহীং করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ইব্রাহীম নে অপনী বাত জারী রখী, “ঔর অগর সির্ফ় 40 নেক লোগ হোং তো?” রব নে কহা, “মৈং উন 40 কে সবব সে উন্হেং ছোড় দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ইব্রাহীম নে কহা, “রব গ়ুস্সা ন করে কি মৈং এক দফ়া ঔর বাত করূঁ। শাযদ ৱহাঁ সির্ফ় 30 হোং।” উসনে জৱাব দিযা, “ফির ভী উন্হেং ছোড় দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ইব্রাহীম নে কহা, “মৈং মুআফ়ী চাহতা হূঁ কি মৈংনে রব সে বাত করনে কী জুর্রত কী হৈ। অগর সির্ফ় 20 পাএ জাএঁ?” রব নে কহা, “মৈং 20 কে সবব সে শহর কো বরবাদ করনে সে বাজ় রহূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ইব্রাহীম নে এক আখ়িরী দফ়া বাত কী, “রব গ়ুস্সা ন করে অগর মৈং এক ঔর বার বাত করূঁ। শাযদ উসমেং সির্ফ় 10 পাএ জাএঁ।” রব নে কহা, “মৈং উসে উন 10 লোগোং কে সবব সে ভী বরবাদ নহীং করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ইন বাতোং কে বাদ রব চলা গযা ঔর ইব্রাহীম অপনে ঘর কো লৌট আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","শাম কে ৱক়্ত যহ দো ফ়রিশ্তে সদূম পহুঁচে। লূত শহর কে দরৱাজ়ে পর বৈঠা থা। জব উসনে উন্হেং দেখা তো খড়ে হোকর উনসে মিলনে গযা ঔর মুঁহ কে বল গিরকর সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","উসনে কহা, “সাহবো, অপনে বংদে কে ঘর তশরীফ় লাএঁ তাকি অপনে পাঁৱ ধোকর রাত কো ঠহরেং ঔর ফির কল সুবহ-সৱেরে উঠকর অপনা সফ়র জারী রখেং।” উন্হোংনে কহা, “কোঈ বাত নহীং, হম চৌক মেং রাত গুজ়ারেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","লেকিন লূত নে উন্হেং বহুত মজবূর কিযা, ঔর আখ়িরকার ৱহ উসকে সাথ উসকে ঘর আএ। উসনে উনকে লিএ খানা পকাযা ঔর বেখ়মীরী রোটী বনাঈ। ফির উন্হোংনে খানা খাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ৱহ অভী সোনে কে লিএ লেটে নহীং থে কি শহর কে জৱানোং সে লেকর বূঢ়োং তক তমাম মর্দোং নে লূত কে ঘর কো ঘের লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","উন্হোংনে আৱাজ় দেকর লূত সে কহা, “ৱহ আদমী কহাঁ হৈং জো রাত কে ৱক়্ত তেরে পাস আএ? উনকো বাহর লে আ তাকি হম উনকে সাথ হরামকারী করেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","লূত উনসে মিলনে বাহর গযা। উসনে অপনে পীছে দরৱাজ়া বংদ কর লিযা ");
INSERT INTO urdgvb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ঔর কহা, “মেরে ভাইযো, ঐসা মত করো, ঐসী বদকারী ন করো। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","দেখো, মেরী দো কুঁৱারী বেটিযাঁ হৈং। উন্হেং মৈং তুম্হারে পাস বাহর লে আতা হূঁ। ফির জো জী চাহে উনকে সাথ করো। লেকিন ইন আদমিযোং কো ছোড় দো, ক্যোংকি ৱহ মেরে মেহমান হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","উন্হোংনে কহা, “রাস্তে সে হট জা! দেখো, যহ শখ়্স জব হমারে পাস আযা থা তো অজনবী থা, ঔর অব যহ হম পর হাকিম বননা চাহতা হৈ। অব তেরে সাথ উনসে জ়্যাদা বুরা সুলূক করেংগে।” ৱহ উসে মজবূর করতে করতে দরৱাজ়ে কো তোড়নে কে লিএ আগে বঢ়ে। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","লেকিন ঐন ৱক়্ত পর অংদর কে আদমী লূত কো পকড়কর অংদর লে আএ, ফির দরৱাজ়া দুবারা বংদ কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","উন্হোংনে ছোটোং সে লেকর বড়োং তক বাহর কে তমাম আদমিযোং কো অংধা কর দিযা, ঔর ৱহ দরৱাজ়ে কো ঢূঁডতে ঢূঁডতে থক গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","দোনোং আদমিযোং নে লূত সে কহা, “ক্যা তেরা কোঈ ঔর রিশ্তেদার ইস শহর মেং রহতা হৈ, মসলন কোঈ দামাদ যা বেটা-বেটী? সবকো সাথ লেকর যহাঁ সে চলা জা, ");
INSERT INTO urdgvb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ক্যোংকি হম যহ মক়াম তবাহ করনে কো হৈং। ইসকে বাশিংদোং কী বদী কে বাইস লোগোং কী আহেং বুলংদ হোকর রব কে হুজ়ূর পহুঁচ গঈ হৈং, ইসলিএ উসনে হমেং ইসকো তবাহ করনে কে লিএ ভেজা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","লূত ঘর সে নিকলা ঔর অপনে দামাদোং সে বাত কী জিনকা উস কী বেটিযোং কে সাথ রিশ্তা হো চুকা থা। উসনে কহা, “জল্দী করো, ইস জগহ সে নিকলো, ক্যোংকি রব ইস শহর কো তবাহ করনে কো হৈ।” লেকিন উসকে দামাদোং নে ইসে মজ়াক় হী সমঝা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","জব পৌ ফটনে লগী তো দোনোং আদমিযোং নে লূত কো বহুত সমঝাযা ঔর কহা, “জল্দী কর! অপনী বীৱী ঔর দোনোং বেটিযোং কো সাথ লেকর চলা জা, ৱরনা জব শহর কো সজ়া দী জাএগী তো তূ ভী হলাক হো জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","তো ভী ৱহ ঝিজকতা রহা। আখ়িরকার দোনোং নে লূত, উস কী বীৱী ঔর বেটিযোং কে হাথ পকড়কর উন্হেং শহর কে বাহর তক পহুঁচা দিযা, ক্যোংকি রব কো লূত পর তরস আতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","জ্যোংহী ৱহ উন্হেং বাহর লে আএ উনমেং সে এক নে কহা, “অপনী জান বচাকর চলা জা। পীছে মুড়কর ন দেখনা। মৈদান মেং কহীং ন ঠহরনা বল্কি পহাড়োং মেং পনাহ লেনা, ৱরনা তূ হলাক হো জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","লেকিন লূত নে উনসে কহা, “নহীং মেরে আক়া, ঐসা ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","তেরে বংদে কো তেরী নজ়রে-করম হাসিল হুঈ হৈ ঔর তূনে মেরী জান বচানে মেং বহুত মেহরবানী কর দিখাঈ হৈ। লেকিন মৈং পহাড়োং মেং পনাহ নহীং লে সকতা। ৱহাঁ পহুঁচনে সে পহলে যহ মুসীবত মুঝ পর আন পড়েগী ঔর মৈং হলাক হো জাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","দেখ, ক়রীব হী এক ছোটা ক়সবা হৈ। ৱহ ইতনা নজ়দীক হৈ কি মৈং উস তরফ় হিজরত কর সকতা হূঁ। মুঝে ৱহাঁ পনাহ লেনে দে। ৱহ ছোটা হী হৈ, না? ফির মেরী জান বচেগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","উসনে কহা, “চলো, ঠীক হৈ। তেরী যহ দরখ়াস্ত ভী মংজ়ূর হৈ। মৈং যহ ক়সবা তবাহ নহীং করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","লেকিন ভাগকর ৱহাঁ পনাহ লে, ক্যোংকি জব তক তূ ৱহাঁ পহুঁচ ন জাএ মৈং কুছ নহীং কর সকতা।” ইসলিএ ক়সবে কা নাম জ়ুগ়র যানী ছোটা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","জব লূত জ়ুগ়র পহুঁচা তো সূরজ নিকলা হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","তব রব নে আসমান সে সদূম ঔর অমূরা পর গংধক ঔর আগ বরসাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","যোং উসনে উস পূরে মৈদান কো উসকে শহরোং, বাশিংদোং ঔর তমাম হরিযালী সমেত তবাহ কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","লেকিন ফ়রার হোতে ৱক়্ত লূত কী বীৱী নে পীছে মুড়কর দেখা তো ৱহ ফ়ৌরন নমক কা সতূন বন গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ইব্রাহীম সুবহ-সৱেরে উঠকর উস জগহ ৱাপস আযা জহাঁ ৱহ কল রব কে সামনে খড়া হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","জব উসনে নীচে সদূম, অমূরা ঔর পূরী ৱাদী কী তরফ় নজ়র কী তো ৱহাঁ সে ভট্টে কা-সা ধুআঁ উঠ রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","যোং অল্লাহ নে ইব্রাহীম কো যাদ কিযা জব উসনে উস মৈদান কে শহর তবাহ কিএ। ক্যোংকি ৱহ উন্হেং তবাহ করনে সে পহলে লূত কো জো উনমেং আবাদ থা ৱহাঁ সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","লূত ঔর উস কী বেটিযাঁ জ়্যাদা দের তক জ়ুগ়র মেং ন ঠহরে। ৱহ রৱানা হোকর পহাড়োং মেং আবাদ হুএ, ক্যোংকি লূত জ়ুগ়র মেং রহনে সে ডরতা থা। ৱহাঁ উন্হোংনে এক গ়ার কো অপনা ঘর বনা লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","এক দিন বড়ী বেটী নে ছোটী সে কহা, “অব্বূ বূঢ়া হৈ ঔর যহাঁ কোঈ মর্দ হৈ নহীং জিসকে জ়রীএ হমারে বচ্চে পৈদা হো সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","আও, হম অব্বূ কো মৈ পিলাএঁ। জব ৱহ নশে মেং ধুত হো তো হম উসকে সাথ হমবিসতর হোকর অপনে লিএ ঔলাদ পৈদা করেং তাকি হমারী নসল ক়াযম রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","উস রাত উন্হোংনে অপনে বাপ কো মৈ পিলাঈ। জব ৱহ নশে মেং থা তো বড়ী বেটী অংদর জাকর উসকে সাথ হমবিসতর হুঈ। চূঁকি লূত হোশ মেং নহীং থা ইসলিএ উসে কুছ ভী মালূম ন হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","অগলে দিন বড়ী বহন নে ছোটী বহন সে কহা, “পিছলী রাত মৈং অব্বূ সে হমবিসতর হুঈ। আও, আজ রাত কো হম উসে দুবারা মৈ পিলাএঁ। জব ৱহ নশে মেং ধুত হো তো তুম উসকে সাথ হমবিসতর হোকর অপনে লিএ ঔলাদ পৈদা করনা তাকি হমারী নসল ক়াযম রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","চুনাঁচে উন্হোংনে উস রাত ভী অপনে বাপ কো মৈ পিলাঈ। জব ৱহ নশে মেং থা তো ছোটী বেটী উঠকর উসকে সাথ হমবিসতর হুঈ। ইস বার ভী ৱহ হোশ মেং নহীং থা, ইসলিএ উসে কুছ ভী মালূম ন হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","যোং লূত কী বেটিযাঁ অপনে বাপ সে উম্মীদ সে হুঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","বড়ী বেটী কে হাঁ বেটা পৈদা হুআ। উসনে উসকা নাম মোআব রখা। উসসে মোআবী নিকলে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ছোটী বেটী কে হাঁ ভী বেটা পৈদা হুআ। উসনে উসকা নাম বিন-অম্মী রখা। উসসে অম্মোনী নিকলে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ইব্রাহীম ৱহাঁ সে জুনূব কী তরফ় দশ্তে-নজব মেং চলা গযা ঔর ক়াদিস ঔর শূর কে দরমিযান জা বসা। কুছ দের কে লিএ ৱহ জিরার মেং ঠহরা, লেকিন অজনবী কী হৈসিযত সে। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ৱহাঁ উসনে লোগোং কো বতাযা, “সারা মেরী বহন হৈ।” ইসলিএ জিরার কে বাদশাহ অবীমলিক নে কিসী কো ভিজৱা দিযা কি উসে মহল মেং লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","লেকিন রাত কে ৱক়্ত অল্লাহ খ়াব মেং অবীমলিক পর জ়াহির হুআ ঔর কহা, “মৌত তেরে সর পর খড়ী হৈ, ক্যোংকি জো ঔরত তূ অপনে ঘর লে আযা হৈ ৱহ শাদীশুদা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","অসল মেং অবীমলিক অভী তক সারা কে ক়রীব নহীং গযা থা। উসনে কহা, “মেরে আক়া, ক্যা তূ এক বেক়ুসূর ক়ৌম কো ভী হলাক করেগা? ");
INSERT INTO urdgvb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ক্যা ইব্রাহীম নে মুঝসে নহীং কহা থা কি সারা মেরী বহন হৈ? ঔর সারা নে উস কী হাঁ মেং হাঁ মিলাঈ। মেরী নীযত অচ্ছী থী ঔর মৈংনে গ়লত কাম নহীং কিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","অল্লাহ নে কহা, “হাঁ, মৈং জানতা হূঁ কি ইসমেং তেরী নীযত অচ্ছী থী। ইসলিএ মৈংনে তুঝে মেরা গুনাহ করনে ঔর উসে ছূনে সে রোক দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","অব উস ঔরত কো উসকে শৌহর কো ৱাপস কর দে, ক্যোংকি ৱহ নবী হৈ ঔর তেরে লিএ দুআ করেগা। ফির তূ নহীং মরেগা। লেকিন অগর তূ উসে ৱাপস নহীং করেগা তো জান লে কি তেরী ঔর তেরে লোগোং কী মৌত যক়ীনী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","অবীমলিক নে সুবহ-সৱেরে উঠকর অপনে তমাম কারিংদোং কো যহ সব কুছ বতাযা। যহ সুনকর উন পর দহশত ছা গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ফির অবীমলিক নে ইব্রাহীম কো বুলাকর কহা, “আপনে হমারে সাথ ক্যা কিযা হৈ? মৈংনে আপকে সাথ ক্যা গ়লত কাম কিযা কি আপনে মুঝে ঔর মেরী সলতনত কো ইতনে সংগীন জুর্ম মেং ফঁসা দিযা হৈ? জো সুলূক আপনে হমারে সাথ কর দিখাযা হৈ ৱহ কিসী ভী শখ়্স কে সাথ নহীং করনা চাহিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","আপনে যহ ক্যোং কিযা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ইব্রাহীম নে জৱাব দিযা, “মৈংনে অপনে দিল মেং কহা কি যহাঁ কে লোগ অল্লাহ কা খ়ৌফ় নহীং রখতে হোংগে, ইসলিএ ৱহ মেরী বীৱী কো হাসিল করনে কে লিএ মুঝে ক়ত্ল কর দেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","হক়ীক়ত মেং ৱহ মেরী বহন ভী হৈ। ৱহ মেরে বাপ কী বেটী হৈ অগরচে উস কী ঔর মেরী মাঁ ফ়রক় হৈং। যোং মৈং উসসে শাদী কর সকা। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ফির জব অল্লাহ নে হোনে দিযা কি মৈং অপনে বাপ কে ঘরানে সে নিকলকর ইধর-উধর ফিরূঁ তো মৈংনে অপনী বীৱী সে কহা, ‘মুঝ পর যহ মেহরবানী কর কি জহাঁ ভী হম জাএঁ মেরে বারে মেং কহ দেনা কি ৱহ মেরা ভাঈ হৈ’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ফির অবীমলিক নে ইব্রাহীম কো ভেড়-বকরিযাঁ, গায-বৈল, গ়ুলাম ঔর লৌংডিযাঁ দেকর উস কী বীৱী সারা কো উসে ৱাপস কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","উসনে কহা, “মেরা মুল্ক আপকে লিএ খুলা হৈ। জহাঁ জী চাহে উসমেং জা বসেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","সারা সে উসনে কহা, “মৈং আপকে ভাঈ কো চাঁদী কে হজ়ার সিক্কে দেতা হূঁ। ইসসে আপ ঔর আপকে লোগোং কে সামনে আপকে সাথ কিএ গএ নারৱা সুলূক কা ইজ়ালা হো ঔর আপকো বেক়ুসূর ক়রার দিযা জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN20_17‏","002_20_17‏","GEN","20","17‏","18","তব ইব্রাহীম নে অল্লাহ সে দুআ কী ঔর অল্লাহ নে অবীমলিক, উস কী বীৱী ঔর উস কী লৌংডিযোং কো শফ়া দী, ক্যোংকি রব নে অবীমলিক কে ঘরানে কী তমাম ঔরতোং কো সারা কে সবব সে বাঁঝ বনা দিযা থা। লেকিন অব উনকে হাঁ দুবারা বচ্চে পৈদা হোনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","তব রব নে সারা কে সাথ ৱৈসা হী কিযা জৈসা উসনে ফ়রমাযা থা। জো ৱাদা উসনে সারা কে বারে মেং কিযা থা উসে উসনে পূরা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ৱহ হামিলা হুঈ ঔর বেটা পৈদা হুআ। ঐন উস ৱক়্ত বূঢ়ে ইব্রাহীম কে হাঁ বেটা পৈদা হুআ জো অল্লাহ নে মুক়র্রর করকে উসে বতাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ইব্রাহীম নে অপনে ইস বেটে কা নাম ইসহাক় যানী ‘ৱহ হঁসতা হৈ’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","জব ইসহাক় আঠ দিন কা থা তো ইব্রাহীম নে উসকা খ়তনা করাযা, জিস তরহ অল্লাহ নে উসে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","জব ইসহাক় পৈদা হুআ উস ৱক়্ত ইব্রাহীম 100 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","সারা নে কহা, “অল্লাহ নে মুঝে হঁসাযা, ঔর হর কোঈ জো মেরে বারে মেং যহ সুনেগা হঁসেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ইসসে পহলে কৌন ইব্রাহীম সে যহ কহনে কী জুর্রত কর সকতা থা কি সারা অপনে বচ্চোং কো দূধ পিলাএগী? ঔর অব মেরে হাঁ বেটা পৈদা হুআ হৈ, অগরচে ইব্রাহীম বূঢ়া হো গযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ইসহাক় বড়া হোতা গযা। জব উসকা দূধ ছুড়াযা গযা তো ইব্রাহীম নে উসকে লিএ বড়ী জ়িযাফ়ত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","এক দিন সারা নে দেখা কি মিসরী লৌংডী হাজিরা কা বেটা ইসমাঈল ইসহাক় কা মজ়াক় উড়া রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","উসনে ইব্রাহীম সে কহা, “ইস লৌংডী ঔর উসকে বেটে কো ঘর সে নিকাল দেং, ক্যোংকি ৱহ মেরে বেটে ইসহাক় কে সাথ মীরাস নহীং পাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ইব্রাহীম কো যহ বাত বহুত বুরী লগী। আখ়ির ইসমাঈল ভী উসকা বেটা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","লেকিন অল্লাহ নে উসসে কহা, “জো বাত সারা নে অপনী লৌংডী ঔর উসকে বেটে কে বারে মেং কহী হৈ ৱহ তুঝে বুরী ন লগে। সারা কী বাত মান লে, ক্যোংকি তেরী নসল ইসহাক় হী সে ক়াযম রহেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","লেকিন মৈং ইসমাঈল সে ভী এক ক়ৌম বনাঊঁগা, ক্যোংকি ৱহ তেরা বেটা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ইব্রাহীম সুবহ-সৱেরে উঠা। উসনে রোটী ঔর পানী কী মশক হাজিরা কে কংধোং পর রখকর উসে লড়কে কে সাথ ঘর সে নিকাল দিযা। হাজিরা চলতে চলতে বৈর-সবা কে রেগিস্তান মেং ইধর-উধর ফিরনে লগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ফির পানী খ়ত্ম হো গযা। হাজিরা লড়কে কো কিসী ঝাড়ী কে নীচে ছোড়কর ");
INSERT INTO urdgvb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","কোঈ 300 ফ়ুট দূর বৈঠ গঈ। ক্যোংকি উসনে দিল মেং কহা, “মৈং উসে মরতে নহীং দেখ সকতী।” ৱহ ৱহাঁ বৈঠকর রোনে লগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","লেকিন অল্লাহ নে বেটে কী রোতী হুঈ আৱাজ় সুন লী। অল্লাহ কে ফ়রিশ্তে নে আসমান পর সে পুকারকর হাজিরা সে বাত কী, “হাজিরা, ক্যা বাত হৈ? মত ডর, ক্যোংকি অল্লাহ নে লড়কে কা জো ৱহাঁ পড়া হৈ রোনা সুন লিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","উঠ, লড়কে কো উঠাকর উসকা হাথ থাম লে, ক্যোংকি মৈং উসসে এক বড়ী ক়ৌম বনাঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ফির অল্লাহ নে হাজিরা কী আঁখেং খোল দীং, ঔর উস কী নজ়র এক কুএঁ পর পড়ী। ৱহ ৱহাঁ গঈ ঔর মশক কো পানী সে ভরকর লড়কে কো পিলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","অল্লাহ লড়কে কে সাথ থা। ৱহ জৱান হুআ ঔর তীরঅংদাজ় বনকর বযাবান মেং রহনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","জব ৱহ ফ়ারান কে রেগিস্তান মেং রহতা থা তো উস কী মাঁ নে উসে এক মিসরী ঔরত সে ব্যাহ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","উন দিনোং মেং অবীমলিক ঔর উসকে সিপাহসালার ফ়ীকুল নে ইব্রাহীম সে কহা, “জো কুছ ভী আপ করতে হৈং অল্লাহ আপকে সাথ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","অব মুঝসে অল্লাহ কী ক়সম খাএঁ কি আপ মুঝে ঔর মেরী আলো-ঔলাদ কো ধোকা নহীং দেংগে। মুঝ পর ঔর ইস মুল্ক পর জিসমেং আপ পরদেসী হৈং ৱহী মেহরবানী করেং জো মৈংনে আপ পর কী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ইব্রাহীম নে জৱাব দিযা, “মৈং ক়সম খাতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ফির উসনে অবীমলিক সে শিকাযত করতে হুএ কহা, “আপকে বংদোং নে হমারে এক কুএঁ পর ক়ব্জ়া কর লিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","অবীমলিক নে কহা, “মুঝে নহীং মালূম কি কিসনে ঐসা কিযা হৈ। আপনে ভী মুঝে নহীং বতাযা। আজ মৈং পহলী দফ়া যহ বাত সুন রহা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","তব ইব্রাহীম নে অবীমলিক কো ভেড়-বকরিযাঁ ঔর গায-বৈল দিএ, ঔর দোনোং নে এক দূসরে কে সাথ অহদ বাঁধা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ফির ইব্রাহীম নে ভেড় কে সাত মাদা বচ্চোং কো অলগ কর লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","অবীমলিক নে পূছা, “আপনে যহ ক্যোং কিযা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ইব্রাহীম নে জৱাব দিযা, “ভেড় কে ইন সাত বচ্চোং কো মুঝসে লে লেং। যহ ইসকে গৱাহ হোং কি মৈংনে ইস কুএঁ কো খোদা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ইসলিএ উস জগহ কা নাম বৈর-সবা যানী ‘ক়সম কা কুআঁ’ রখা গযা, ক্যোংকি ৱহাঁ উন দোনোং মর্দোং নে ক়সম খাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","যোং উন্হোংনে বৈর-সবা মেং এক দূসরে সে অহদ বাঁধা। ফির অবীমলিক ঔর ফ়ীকুল ফ়িলিস্তিযোং কে মুল্ক ৱাপস চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ইসকে বাদ ইব্রাহীম নে বৈর-সবা মেং ঝাঊ কা দরখ়্ত লগাযা। ৱহাঁ উসনে রব কা নাম লেকর উস কী ইবাদত কী জো অবদী খ়ুদা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ইব্রাহীম বহুত অরসে তক ফ়িলিস্তিযোং কে মুল্ক মেং আবাদ রহা, লেকিন অজনবী কী হৈসিযত সে। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","কুছ অরসে কে বাদ অল্লাহ নে ইব্রাহীম কো আজ়মাযা। উসনে উসসে কহা, “ইব্রাহীম!” উসনে জৱাব দিযা, “জী, মৈং হাজ়ির হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","অল্লাহ নে কহা, “অপনে ইকলৌতে বেটে ইসহাক় কো জিসে তূ প্যার করতা হৈ সাথ লেকর মোরিযাহ কে ইলাক়ে মেং চলা জা। ৱহাঁ মৈং তুঝে এক পহাড় দিখাঊঁগা। উস পর অপনে বেটে কো ক়ুরবান কর দে। উসে জ়বহ করকে ক়ুরবানগাহ পর জলা দেনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","সুবহ-সৱেরে ইব্রাহীম উঠা ঔর অপনে গধে পর জ়ীন কসা। উসনে অপনে সাথ দো নৌকরোং ঔর অপনে বেটে ইসহাক় কো লিযা। ফির ৱহ ক়ুরবানী কো জলানে কে লিএ লকড়ী কাটকর উস জগহ কী তরফ় রৱানা হুআ জো অল্লাহ নে উসে বতাঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","সফ়র করতে করতে তীসরে দিন ক়ুরবানী কী জগহ ইব্রাহীম কো দূর সে নজ়র আঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","উসনে নৌকরোং সে কহা, “যহাঁ গধে কে পাস ঠহরো। মৈং লড়কে কে সাথ ৱহাঁ জাকর পরস্তিশ করূঁগা। ফির হম তুম্হারে পাস ৱাপস আ জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ইব্রাহীম নে ক়ুরবানী কো জলানে কে লিএ লকড়িযাঁ ইসহাক় কে কংধোং পর রখ দীং ঔর খ়ুদ ছুরী ঔর আগ জলানে কে লিএ অংগারোং কা বরতন উঠাযা। দোনোং চল দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ইসহাক় বোলা, “অব্বূ!” ইব্রাহীম নে কহা, “জী বেটা।” “অব্বূ, আগ ঔর লকড়িযাঁ তো হমারে পাস হৈং, লেকিন ক়ুরবানী কে লিএ ভেড় যা বকরী কহাঁ হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ইব্রাহীম নে জৱাব দিযা, “অল্লাহ খ়ুদ ক়ুরবানী কে লিএ জানৱর মুহৈযা করেগা, বেটা।” ৱহ আগে বঢ় গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","চলতে চলতে ৱহ উস মক়াম পর পহুঁচে জো অল্লাহ নে উস পর জ়াহির কিযা থা। ইব্রাহীম নে ৱহাঁ ক়ুরবানগাহ বনাঈ ঔর উস পর লকড়িযাঁ তরতীব সে রখ দীং। ফির উসনে ইসহাক় কো বাঁধকর লকড়িযোং পর রখ দিযা ");
INSERT INTO urdgvb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ঔর ছুরী পকড় লী তাকি অপনে বেটে কো জ়বহ করে। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ঐন উসী ৱক়্ত রব কে ফ়রিশ্তে নে আসমান পর সে উসে আৱাজ় দী, “ইব্রাহীম, ইব্রাহীম!” ইব্রাহীম নে কহা, “জী, মৈং হাজ়ির হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ফ়রিশ্তে নে কহা, “অপনে বেটে পর হাথ ন চলা, ন উসকে সাথ কুছ কর। অব মৈংনে জান লিযা হৈ কি তূ অল্লাহ কা খ়ৌফ় রখতা হৈ, ক্যোংকি তূ অপনে ইকলৌতে বেটে কো ভী মুঝে দেনে কে লিএ তৈযার হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","অচানক ইব্রাহীম কো এক মেংঢা নজ়র আযা জিসকে সীংগ গুংজান ঝাড়িযোং মেং ফঁসে হুএ থে। ইব্রাহীম নে উসে জ়বহ করকে অপনে বেটে কী জগহ ক়ুরবানী কে তৌর পর জলা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","উসনে উস মক়াম কা নাম “রব মুহৈযা করতা হৈ” রখা। ইসলিএ আজ তক কহা জাতা হৈ, “রব কে পহাড় পর মুহৈযা কিযা জাতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","রব কে ফ়রিশ্তে নে এক বার ফির আসমান পর সে পুকারকর উসসে বাত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“রব কা ফ়রমান হৈ, মেরী জ়াত কী ক়সম, চূঁকি তূনে যহ কিযা ঔর অপনে ইকলৌতে বেটে কো মুঝে পেশ করনে কে লিএ তৈযার থা ");
INSERT INTO urdgvb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ইসলিএ মৈং তুঝে বরকত দূঁগা ঔর তেরী ঔলাদ কো আসমান কে সিতারোং ঔর সাহিল কী রেত কী তরহ বেশুমার হোনে দূঁগা। তেরী ঔলাদ অপনে দুশ্মনোং কে শহরোং কে দরৱাজ়োং পর ক়ব্জ়া করেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","চূঁকি তূনে মেরী সুনী ইসলিএ তেরী ঔলাদ সে দুনিযা কী তমাম ক়ৌমেং বরকত পাএঁগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ইসকে বাদ ইব্রাহীম অপনে নৌকরোং কে পাস ৱাপস আযা, ঔর ৱহ মিলকর বৈর-সবা লৌটে। ৱহাঁ ইব্রাহীম আবাদ রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ইন ৱাক়িযাত কে বাদ ইব্রাহীম কো ইত্তলা মিলী, “আপকে ভাঈ নহূর কী বীৱী মিলকাহ কে হাঁ ভী বেটে পৈদা হুএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","উসকে পহলৌঠে ঊজ় কে বাদ বূজ়, ক়মুএল (অরাম কা বাপ), ");
INSERT INTO urdgvb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","কসদ, হজ়ূ, ফ়িলদাস, ইদলাফ় ঔর বতুএল পৈদা হুএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","মিলকাহ ঔর নহূর কে হাঁ যহ আঠ বেটে পৈদা হুএ। (বতুএল রিবক়া কা বাপ থা)। ");
INSERT INTO urdgvb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","নহূর কী হরম কা নাম রূমা থা। উসকে হাঁ ভী বেটে পৈদা হুএ জিনকে নাম তিবখ়, জাহম, তখ়স ঔর মাকা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","সারা 127 সাল কী উম্র মেং হবরূন মেং ইংতক়াল কর গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","উস জ়মানে মেং হবরূন কা নাম ক়িরিযত-অরবা থা, ঔর ৱহ মুল্কে-কনান মেং থা। ইব্রাহীম নে উসকে পাস আকর মাতম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ফির ৱহ জনাজ়ে কে পাস সে উঠা ঔর হিত্তিযোং সে বাত কী। উসনে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“মৈং আপকে দরমিযান পরদেসী ঔর গ়ৈরশহরী কী হৈসিযত সে রহতা হূঁ। মুঝে ক়ব্র কে লিএ জ়মীন বেচেং তাকি অপনী বীৱী কো অপনে ঘর সে লে জাকর দফ়ন কর সকূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN23_5‏","002_23_5‏","GEN","23","5‏","6","হিত্তিযোং নে জৱাব দিযা, “হমারে আক়া, হমারী বাত সুনেং! আপ হমারে দরমিযান অল্লাহ কে রঈস হৈং। অপনী বীৱী কো হমারী বেহতরীন ক়ব্র মেং দফ়ন করেং। হমমেং সে কোঈ নহীং জো আপসে অপনী ক়ব্র কা ইনকার করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ইব্রাহীম উঠা ঔর মুল্ক কে বাশিংদোং যানী হিত্তিযোং কে সামনে তাজ়ীমন ঝুক গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","উসনে কহা, “অগর আপ ইসকে লিএ তৈযার হৈং কি মৈং অপনী বীৱী কো অপনে ঘর সে লে জাকর দফ়ন করূঁতো সুহর কে বেটে ইফ়রোন সে মেরী সিফ়ারিশ করেং ");
INSERT INTO urdgvb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","কি ৱহ মুঝে মকফ়ীলা কা গ়ার বেচ দে। ৱহ উসকা হৈ ঔর উসকে খেত কে কিনারে পর হৈ। মৈং উস কী পূরী ক়ীমত দেনে কে লিএ তৈযার হূঁ তাকি আপকে দরমিযান রহতে হুএ মেরে পাস ক়ব্র ভী হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ইফ়রোন হিত্তিযোং কী জমাত মেং মৌজূদ থা। ইব্রাহীম কী দরখ়াস্ত পর উসনে উন তমাম হিত্তিযোং কে সামনে জো শহর কে দরৱাজ়ে পর জমা থে জৱাব দিযা, ");
INSERT INTO urdgvb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“নহীং, মেরে আক়া! মেরী বাত সুনেং। মৈং আপকো যহ খেত ঔর উসমেং মৌজূদ গ়ার দে দেতা হূঁ। সব জো হাজ়ির হৈং মেরে গৱাহ হৈং, মৈং যহ আপকো দেতা হূঁ। অপনী বীৱী কো ৱহাঁ দফ়ন কর দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ইব্রাহীম দুবারা মুল্ক কে বাশিংদোং কে সামনে অদবন ঝুক গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","উসনে সবকে সামনে ইফ়রোন সে কহা, “মেহরবানী করকে মেরী বাত পর গ়ৌর করেং। মৈং খেত কী পূরী ক়ীমত অদা করূঁগা। উসে ক়বূল করেং তাকি ৱহাঁ অপনী বীৱী কো দফ়ন কর সকূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN23_14‏","002_23_14‏","GEN","23","14‏","15","ইফ়রোন নে জৱাব দিযা, “মেরে আক়া, সুনেং। ইস জ়মীন কী ক়ীমত সির্ফ় 400 চাঁদী কে সিক্কে হৈ। আপকে ঔর মেরে দরমিযান যহ ক্যা হৈ? অপনী বীৱী কো দফ়ন কর দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ইব্রাহীম নে ইফ়রোন কী মতলূবা ক়ীমত মান লী ঔর সবকে সামনে চাঁদী কে 400 সিক্কে তোলকর ইফ়রোন কো দে দিএ। ইসকে লিএ উসনে উস ৱক়্ত কে রাযজ বাট ইস্তেমাল কিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","চুনাঁচে মকফ়ীলা মেং ইফ়রোন কী জ়মীন ইব্রাহীম কী মিলকিযত হো গঈ। যহ জ়মীন মমরে কে মশরিক় মেং থী। উসমেং খেত, খেত কা গ়ার ঔর খেত কী হুদূদ মেং মৌজূদ তমাম দরখ়্ত শামিল থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","হিত্তিযোং কী পূরী জমাত নে জো শহর কে দরৱাজ়ে পর জমা থী জ়মীন কে ইংতক়াল কী তসদীক় কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ফির ইব্রাহীম নে অপনী বীৱী সারা কো মুল্কে-কনান কে উস গ়ার মেং দফ়ন কিযা জো মমরে যানী হবরূন কে মশরিক় মেং ৱাক়ে মকফ়ীলা কে খেত মেং থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ইস তরীক়ে সে যহ খেত ঔর উসকা গ়ার হিত্তিযোং সে ইব্রাহীম কে নাম পর মুংতক়িল কর দিযা গযা তাকি উসকে পাস ক়ব্র হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ইব্রাহীম অব বহুত বূঢ়া হো গযা থা। রব নে উসে হর লিহাজ় সে বরকত দী থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","এক দিন উসনে অপনে ঘর কে সবসে বুজ়ুর্গ নৌকর সে জো উস কী জাযদাদ কা পূরা ইংতজ়াম চলাতা থা বাত কী। “ক়সম কে লিএ অপনা হাথ মেরী রান কে নীচে রখো। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","রব কী ক়সম খাও জো আসমানো-জ়মীন কা খ়ুদা হৈ কি তুম ইন কনানিযোং মেং সে জিনকে দরমিযান মৈং রহতা হূঁ মেরে বেটে কে লিএ বীৱী নহীং লাওগে ");
INSERT INTO urdgvb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","বল্কি মেরে ৱতন মেং মেরে রিশ্তেদারোং কে পাস জাওগে ঔর উন্হীং মেং সে মেরে বেটে কে লিএ বীৱী লাওগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","উসকে নৌকর নে কহা, “শাযদ ৱহ ঔরত মেরে সাথ যহাঁ আনা ন চাহে। ক্যা মৈং ইস সূরত মেং আপকে বেটে কো উস ৱতন মেং ৱাপস লে জাঊঁ জিসসে আপ নিকলে হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ইব্রাহীম নে কহা, “খ়বরদার! উসে হরগিজ় ৱাপস ন লে জানা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","রব জো আসমান কা খ়ুদা হৈ অপনা ফ়রিশ্তা তুম্হারে আগে ভেজেগা, ইসলিএ তুম ৱহাঁ মেরে বেটে কে লিএ বীৱী চুননে মেং জ়রূর কামযাব হোগে। ক্যোংকি ৱহী মুঝে মেরে বাপ কে ঘর ঔর মেরে ৱতন সে যহাঁ লে আযা হৈ, ঔর উসী নে ক়সম খাকর মুঝসে ৱাদা কিযা হৈ কি মৈং কনান কা যহ মুল্ক তেরী ঔলাদ কো দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","অগর ৱহাঁ কী ঔরত যহাঁ আনা ন চাহে তো ফির তুম অপনী ক়সম সে আজ়াদ হোগে। লেকিন কিসী সূরত মেং ভী মেরে বেটে কো ৱহাঁ ৱাপস ন লে জানা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ইব্রাহীম কে নৌকর নে অপনা হাথ উস কী রান কে নীচে রখকর ক়সম খাঈ কি মৈং সব কুছ ঐসা হী করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ফির ৱহ অপনে আক়া কে দস ঊঁটোং পর ক়ীমতী তোহ্ফ়ে লাদকর মসোপুতামিযা কী তরফ় রৱানা হুআ। চলতে চলতে ৱহ নহূর কে শহর পহুঁচ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","উসনে ঊঁটোং কো শহর কে বাহর কুএঁ কে পাস বিঠাযা। শাম কা ৱক়্ত থা জব ঔরতেং কুএঁ কে পাস আকর পানী ভরতী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ফির উসনে দুআ কী, “ঐ রব মেরে আক়া ইব্রাহীম কে খ়ুদা, মুঝে আজ কামযাবী বখ়্শ ঔর মেরে আক়া ইব্রাহীম পর মেহরবানী কর। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","অব মৈং ইস চশ্মে পর খড়া হূঁ, ঔর শহর কী বেটিযাঁ পানী ভরনে কে লিএ আ রহী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","মৈং উনমেং সে কিসী সে কহূঁগা, ‘জ়রা অপনা ঘড়া নীচে করকে মুঝে পানী পিলাএঁ।’ অগর ৱহ জৱাব দে, ‘পী লেং, মৈং আপকে ঊঁটোং কো ভী পানী পিলা দেতী হূঁ,’ তো ৱহ ৱহী হোগী জিসে তূনে অপনে খ়াদিম ইসহাক় কে লিএ চুন রখা হৈ। অগর ঐসা হুআ তো মৈং জান লূঁগা কি তূনে মেরে আক়া পর মেহরবানী কী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ৱহ অভী দুআ কর হী রহা থা কি রিবক়া শহর সে নিকল আঈ। উসকে কংধে পর ঘড়া থা। ৱহ বতুএল কী বেটী থী (বতুএল ইব্রাহীম কে ভাঈ নহূর কী বীৱী মিলকাহ কা বেটা থা)। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","রিবক়া নিহাযত খ়ূবসূরত জৱান লড়কী থী, ঔর ৱহ কুঁৱারী ভী থী। ৱহ চশ্মে তক উতরী, অপনা ঘড়া ভরা ঔর ফির ৱাপস ঊপর আঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ইব্রাহীম কা নৌকর দৌড়কর উসসে মিলা। উসনে কহা, “জ়রা মুঝে অপনে ঘড়ে সে থোড়া-সা পানী পিলাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","রিবক়া নে কহা, “জনাব, পী লেং।” জল্দী সে উসনে অপনে ঘড়ে কো কংধে পর সে উতারকর হাথ মেং পকড়া তাকি ৱহ পী সকে। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","জব ৱহ পীনে সে ফ়ারিগ় হুআ তো রিবক়া নে কহা, “মৈং আপকে ঊঁটোং কে লিএ ভী পানী লে আতী হূঁ। ৱহ ভী পূরে তৌর পর অপনী প্যাস বুঝাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","জল্দী সে উসনে অপনে ঘড়ে কা পানী হৌজ় মেং উংডেল দিযা ঔর ফির ভাগকর কুএঁ সে ইতনা পানী লাতী রহী কি তমাম ঊঁটোং কী প্যাস বুঝ গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ইতনে মেং ইব্রাহীম কা আদমী খ়ামোশী সে উসে দেখতা রহা, ক্যোংকি ৱহ জাননা চাহতা থা কি ক্যা রব মুঝে সফ়র কী কামযাবী বখ়্শেগা যা নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ঊঁট পানী পীনে সে ফ়ারিগ় হুএ তো উসনে রিবক়া কো সোনে কী এক নথ ঔর দো কংগন দিএ। নথ কা ৱজ়ন তক়রীবন 6 গ্রাম থা ঔর কংগনোং কা 120 গ্রাম। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","উসনে পূছা, “আপ কিসকী বেটী হৈং? ক্যা উসকে হাঁ ইতনী জগহ হৈ কি হম ৱহাঁ রাত গুজ়ার সকেং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","রিবক়া নে জৱাব দিযা, “মেরা বাপ বতুএল হৈ। ৱহ নহূর ঔর মিলকাহ কা বেটা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","হমারে পাস ভূসা ঔর চারা হৈ। রাত গুজ়ারনে কে লিএ ভী কাফ়ী জগহ হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","যহ সুনকর ইব্রাহীম কে নৌকর নে রব কো সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","উসনে কহা, “মেরে আক়া ইব্রাহীম কে খ়ুদা কী তমজীদ হো জিসকে করম ঔর ৱফ়াদারী নে মেরে আক়া কো নহীং ছোড়া। রব নে মুঝে সীধা মেরে মালিক কে রিশ্তেদারোং তক পহুঁচাযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","লড়কী ভাগকর অপনী মাঁ কে ঘর চলী গঈ। ৱহাঁ উসনে সব কুছ বতা দিযা জো হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_29‏","002_24_29‏","GEN","24","29‏","30","জব রিবক়া কে ভাঈ লাবন নে নথ ঔর বহন কী কলাইযোং মেং কংগনোং কো দেখা ঔর ৱহ সব কুছ সুনা জো ইব্রাহীম কে নৌকর নে রিবক়া কো বতাযা থা তো ৱহ ফ়ৌরন কুএঁ কী তরফ় দৌড়া। ইব্রাহীম কা নৌকর অব তক ঊঁটোং সমেত ৱহাঁ খড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","লাবন নে কহা, “রব কে মুবারক বংদে, মেরে সাথ আএঁ। আপ যহাঁ শহর কে বাহর ক্যোং খড়ে হৈং? মৈংনে অপনে ঘর মেং আপকে লিএ সব কুছ তৈযার কিযা হৈ। আপকে ঊঁটোং কে লিএ ভী কাফ়ী জগহ হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ৱহ নৌকর কো লেকর ঘর পহুঁচা। ঊঁটোং সে সামান উতারা গযা, ঔর উনকো ভূসা ঔর চারা দিযা গযা। পানী ভী লাযা গযা তাকি ইব্রাহীম কা নৌকর ঔর উসকে আদমী অপনে পাঁৱ ধোএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","লেকিন জব খানা আ গযা তো ইব্রাহীম কে নৌকর নে কহা, “ইসসে পহলে কি মৈং খানা খাঊঁ লাজ়িম হৈ কি অপনা মামলা পেশ করূঁ।” লাবন নে কহা, “বতাএঁ অপনী বাত।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","উসনে কহা, “মৈং ইব্রাহীম কা নৌকর হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","রব নে মেরে আক়া কো বহুত বরকত দী হৈ। ৱহ বহুত অমীর বন গযা হৈ। রব নে উসে কসরত সে ভেড়-বকরিযাঁ, গায-বৈল, সোনা-চাঁদী, গ়ুলাম ঔর লৌংডিযাঁ, ঊঁট ঔর গধে দিএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","জব মেরে মালিক কী বীৱী বূঢ়ী হো গঈ থী তো উসকে বেটা পৈদা হুআ থা। ইব্রাহীম নে উসে অপনী পূরী মিলকিযত দে দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","লেকিন মেরে আক়া নে মুঝসে কহা, ‘ক়সম খাও কি তুম ইন কনানিযোং মেং সে জিনকে দরমিযান মৈং রহতা হূঁ মেরে বেটে কে লিএ বীৱী নহীং লাওগে ");
INSERT INTO urdgvb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","বল্কি মেরে বাপ কে ঘরানে ঔর মেরে রিশ্তেদারোং কে পাস জাকর উসকে লিএ বীৱী লাওগে।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","মৈংনে অপনে মালিক সে কহা, ‘শাযদ ৱহ ঔরত মেরে সাথ আনা ন চাহে।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","উসনে কহা, ‘রব জিসকে সামনে মৈং চলতা রহা হূঁ অপনে ফ়রিশ্তে কো তুম্হারে সাথ ভেজেগা ঔর তুম্হেং কামযাবী বখ়্শেগা। তুম্হেং জ়রূর মেরে রিশ্তেদারোং ঔর মেরে বাপ কে ঘরানে সে মেরে বেটে কে লিএ বীৱী মিলেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","লেকিন অগর তুম মেরে রিশ্তেদারোং কে পাস জাও ঔর ৱহ ইনকার করেং তো ফির তুম অপনী ক়সম সে আজ়াদ হোগে।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","আজ জব মৈং কুএঁ কে পাস আযা তো মৈংনে দুআ কী, ‘ঐ রব, মেরে আক়া কে খ়ুদা, অগর তেরী মরজ়ী হো তো মুঝে ইস মিশন মেং কামযাবী বখ়্শ জিসকে লিএ মৈং যহাঁ আযা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","অব মৈং ইস কুএঁ কে পাস খড়া হূঁ। জব কোঈ জৱান ঔরত শহর সে নিকলকর যহাঁ আএ তো মৈং উসসে কহূঁগা, “জ়রা মুঝে অপনে ঘড়ে সে থোড়া-সা পানী পিলাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","অগর ৱহ কহে, “পী লেং, মৈং আপকে ঊঁটোং কে লিএ ভী পানী লে আঊঁগী” তো ইসকা মতলব যহ হো কি তূনে উসে মেরে আক়া কে বেটে কে লিএ চুন লিযা হৈ কি উস কী বীৱী বন জাএ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","মৈং অভী দিল মেং যহ দুআ কর রহা থা কি রিবক়া শহর সে নিকল আঈ। উসকে কংধে পর ঘড়া থা। ৱহ চশ্মে তক উতরী ঔর অপনা ঘড়া ভর লিযা। মৈংনে উসসে কহা, ‘জ়রা মুঝে পানী পিলাএঁ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","জৱাব মেং উসনে জল্দী সে অপনে ঘড়ে কো কংধে পর সে উতারকর কহা, ‘পী লেং, মৈং আপকে ঊঁটোং কো ভী পানী পিলাতী হূঁ।’ মৈংনে পানী পিযা, ঔর উসনে ঊঁটোং কো ভী পানী পিলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ফির মৈংনে উসসে পূছা, ‘আপ কিসকী বেটী হৈং?’ উসনে জৱাব দিযা, ‘মেরা বাপ বতুএল হৈ। ৱহ নহূর ঔর মিলকাহ কা বেটা হৈ।’ ফির মৈংনে উস কী নাক মেং নথ ঔর উস কী কলাইযোং মেং কংগন পহনা দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","তব মৈংনে রব কো সিজদা করকে অপনে আক়া ইব্রাহীম কে খ়ুদা কী তমজীদ কী জিসনে মুঝে সীধা মেরে মালিক কী ভতীজী তক পহুঁচাযা তাকি ৱহ ইসহাক় কী বীৱী বন জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","অব মুঝে বতাএঁ, ক্যা আপ মেরে আক়া পর অপনী মেহরবানী ঔর ৱফ়াদারী কা ইজ়হার করনা চাহতে হৈং? অগর ঐসা হৈ তো রিবক়া কী ইসহাক় কে সাথ শাদী ক়বূল করেং। অগর আপ মুত্তফ়িক় নহীং হৈং তো মুঝে বতাএঁ তাকি মৈং কোঈ ঔর ক়দম উঠা সকূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","লাবন ঔর বতুএল নে জৱাব দিযা, “যহ বাত রব কী তরফ় সে হৈ, ইসলিএ হম কিসী তরহ ভী ইনকার নহীং কর সকতে। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","রিবক়া আপকে সামনে হৈ। উসে লে জাএঁ। ৱহ আপকে মালিক কে বেটে কী বীৱী বন জাএ জিস তরহ রব নে ফ়রমাযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","যহ সুনকর ইব্রাহীম কে নৌকর নে রব কো সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ফির উসনে সোনে ঔর চাঁদী কে জ়েৱরাত ঔর মহঁগে মলবূসাত অপনে সামান মেং সে নিকালকর রিবক়া কো দিএ। রিবক়া কে ভাঈ ঔর মাঁ কো ভী ক়ীমতী তোহ্ফ়ে মিলে। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ইসকে বাদ উসনে অপনে হমসফ়রোং কে সাথ শাম কা খানা খাযা। ৱহ রাত কো ৱহীং ঠহরে। অগলে দিন জব উঠে তো নৌকর নে কহা, “অব হমেং ইজাজ়ত দেং তাকি অপনে আক়া কে পাস লৌট জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","রিবক়া কে ভাঈ ঔর মাঁ নে কহা, “রিবক়া কুছ দিন ঔর হমারে হাঁ ঠহরে। ফির আপ জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","লেকিন উসনে উনসে কহা, “অব দের ন করেং, ক্যোংকি রব নে মুঝে মেরে মিশন মেং কামযাবী বখ়্শী হৈ। মুঝে ইজাজ়ত দেং তাকি অপনে মালিক কে পাস ৱাপস জাঊঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","উন্হোংনে কহা, “চলেং, হম লড়কী কো বুলাকর উসী সে পূছ লেতে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","উন্হোংনে রিবক়া কো বুলাকর উসসে পূছা, “ক্যা তূ অভী ইস আদমী কে সাথ জানা চাহতী হৈ?” উসনে কহা, “জী, মৈং জানা চাহতী হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","চুনাঁচে উন্হোংনে অপনী বহন রিবক়া, উস কী দাযা, ইব্রাহীম কে নৌকর ঔর উসকে হমসফ়রোং কো রুখ়সত কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","পহলে উন্হোংনে রিবক়া কো বরকত দেকর কহা, “হমারী বহন, অল্লাহ করে কি তূ করোড়োং কী মাঁ বনে। তেরী ঔলাদ অপনে দুশ্মনোং কে শহরোং কে দরৱাজ়োং পর ক়ব্জ়া করে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ফির রিবক়া ঔর উস কী নৌকরানিযাঁ উঠকর ঊঁটোং পর সৱার হুঈং ঔর ইব্রাহীম কে নৌকর কে পীছে হো লীং। চুনাঁচে নৌকর উন্হেং সাথ লেকর রৱানা হো গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","উস ৱক়্ত ইসহাক় মুল্ক কে জুনূবী হিস্সে, দশ্তে-নজব মেং রহতা থা। ৱহ বৈর-লহী-রোঈ সে আযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","এক শাম ৱহ নিকলকর খুলে মৈদান মেং অপনী সোচোং মেং মগন টহল রহা থা কি অচানক ঊঁট উস কী তরফ় আতে হুএ নজ়র আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","জব রিবক়া নে অপনী নজ়র উঠাকর ইসহাক় কো দেখা তো উসনে ঊঁট সে উতরকর ");
INSERT INTO urdgvb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","নৌকর সে পূছা, “ৱহ আদমী কৌন হৈ জো মৈদান মেং হমসে মিলনে আ রহা হৈ?” নৌকর নে কহা, “মেরা মালিক হৈ।” যহ সুনকর রিবক়া নে চাদর লেকর অপনে চেহরে কো ঢাঁপ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","নৌকর নে ইসহাক় কো সব কুছ বতা দিযা জো উসনে কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ফির ইসহাক় রিবক়া কো অপনী মাঁ সারা কে ডেরে মেং লে গযা। উসনে উসসে শাদী কী, ঔর ৱহ উস কী বীৱী বন গঈ। ইসহাক় কে দিল মেং উসকে লিএ বহুত মুহব্বত পৈদা হুঈ। যোং উসে অপনী মাঁ কী মৌত কে বাদ সুকূন মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ইব্রাহীম নে এক ঔর শাদী কী। নঈ বীৱী কা নাম ক়তূরা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ক়তূরা কে ছঃ বেটে পৈদা হুএ, জ়িমরান, যুক়সান, মিদান, মিদিযান, ইসবাক় ঔর সূখ়। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","যুক়সান কে দো বেটে থে, সবা ঔর দদান। অসূরী, লতূসী ঔর লূমী দদান কী ঔলাদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","মিদিযান কে বেটে ঐফ়া, ইফ়র, হনূক, অবীদা ঔর ইল্দআ থে। যহ সব ক়তূরা কী ঔলাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ইব্রাহীম নে অপনী সারী মিলকিযত ইসহাক় কো দে দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","অপনী মৌত সে পহলে উসনে অপনী দূসরী বীৱিযোং কে বেটোং কো তোহ্ফ়ে দেকর অপনে বেটে সে দূর মশরিক় কী তরফ় ভেজ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_7‏","002_25_7‏","GEN","25","7‏","8","ইব্রাহীম 175 সাল কী উম্র মেং ফ়ৌত হুআ। গ়রজ় ৱহ বহুত উম্ররসীদা ঔর জ়িংদগী সে আসূদা হোকর ইংতক়াল করকে অপনে বাপদাদা সে জা মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_9‏","002_25_9‏","GEN","25","9‏","10","উসকে বেটোং ইসহাক় ঔর ইসমাঈল নে উসে মকফ়ীলা কে গ়ার মেং দফ়ন কিযা জো মমরে কে মশরিক় মেং হৈ। যহ ৱহী গ়ার থা জিসে খেত সমেত হিত্তী আদমী ইফ়রোন বিন সুহর সে খ়রীদা গযা থা। ইব্রাহীম ঔর উস কী বীৱী সারা দোনোং কো উসমেং দফ়ন কিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ইব্রাহীম কী ৱফ়াত কে বাদ অল্লাহ নে ইসহাক় কো বরকত দী। উস ৱক়্ত ইসহাক় বৈর-লহী-রোঈ কে ক়রীব আবাদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ইব্রাহীম কা বেটা ইসমাঈল জো সারা কী মিসরী লৌংডী হাজিরা কে হাঁ পৈদা হুআ উসকা নসবনামা যহ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ইসমাঈল কে বেটে বড়ে সে লেকর ছোটে তক যহ হৈং : নবাযোত, ক়ীদার, অদবিযেল, মিবসাম, ");
INSERT INTO urdgvb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","মিশমা, দূমা, মস্সা, ");
INSERT INTO urdgvb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","হদদ, তৈমা, যতূর, নফ়ীস ঔর ক়িদমা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","যহ বেটে বারহ ক়বীলোং কে বানী বন গএ, ঔর জহাঁ জহাঁ ৱহ আবাদ হুএ উন জগহোং কা ৱহী নাম পড় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ইসমাঈল 137 সাল কা থা জব ৱহ কূচ করকে অপনে বাপদাদা সে জা মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","উস কী ঔলাদ উস ইলাক়ে মেং আবাদ থী জো হৱীলা ঔর শূর কে দরমিযান হৈ ঔর জো মিসর কে মশরিক় মেং অসূর কী তরফ় হৈ। যোং ইসমাঈল অপনে তমাম ভাইযোং কে সামনে হী আবাদ হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","যহ ইব্রাহীম কে বেটে ইসহাক় কা বযান হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ইসহাক় 40 সাল কা থা জব উস কী রিবক়া সে শাদী হুঈ। রিবক়া লাবন কী বহন ঔর অরামী মর্দ বতুএল কী বেটী থী (বতুএল মসোপুতামিযা কা থা)। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","রিবক়া কে বচ্চে পৈদা ন হুএ। লেকিন ইসহাক় নে অপনী বীৱী কে লিএ দুআ কী তো রব নে উস কী সুনী, ঔর রিবক়া উম্মীদ সে হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","উসকে পেট মেং বচ্চে এক দূসরে সে জ়োর-আজ়মাঈ করনে লগে তো ৱহ রব সে পূছনে গঈ, “অগর যহ মেরী হালত রহেগী তো ফির মৈং যহাঁ তক ক্যোং পহুঁচ গঈ হূঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","রব নে উসসে কহা, “তেরে অংদর দো ক়ৌমেং হৈং। ৱহ তুঝসে নিকলকর এক দূসরী সে অলগ অলগ হো জাএঁগী। উনমেং সে এক জ়্যাদা তাক়তৱর হোগী, ঔর বড়া ছোটে কী খ়িদমত করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","পৈদাইশ কা ৱক়্ত আ গযা তো জুড়ৱাঁ বেটে পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","পহলা বচ্চা নিকলা তো সুর্খ়-সা থা, ঔর ঐসা লগ রহা থা কি ৱহ ঘনে বালোং কা কোট হী পহনে হুএ হৈ। ইসলিএ উসকা নাম এসৌ যানী ‘বালোংৱালা’ রখা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ইসকে বাদ দূসরা বচ্চা পৈদা হুআ। ৱহ এসৌ কী এড়ী পকড়ে হুএ নিকলা, ইসলিএ উসকা নাম যাক়ূব যানী ‘এড়ী পকড়নেৱালা’ রখা গযা। উস ৱক়্ত ইসহাক় 60 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","লড়কে জৱান হুএ। এসৌ মাহির শিকারী বন গযা ঔর খুলে মৈদান মেং খ়ুশ রহতা থা। উসকে মুক়াবলে মেং যাক়ূব শাযস্তা থা ঔর ডেরে মেং রহনা পসংদ করতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ইসহাক় এসৌ কো প্যার করতা থা, ক্যোংকি ৱহ শিকার কা গোশ্ত পসংদ করতা থা। লেকিন রিবক়া যাক়ূব কো প্যার করতী থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","এক দিন যাক়ূব সালন পকা রহা থা কি এসৌ থকাহারা জংগল সে আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","উসনে কহা, “মুঝে জল্দী সে লাল সালন, হাঁ ইসী লাল সালন সে কুছ খানে কো দো। মৈং তো বেদম হো রহা হূঁ।” (ইসী লিএ বাদ মেং উসকা নাম অদোম যানী সুর্খ় পড় গযা।) ");
INSERT INTO urdgvb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","যাক়ূব নে কহা, “পহলে মুঝে পহলৌঠে কা হক় বেচ দো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","এসৌ নে কহা, “মৈং তো ভূক সে মর রহা হূঁ, পহলৌঠে কা হক় মেরে কিস কাম কা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","যাক়ূব নে কহা, “পহলে ক়সম খাকর মুঝে যহ হক় বেচ দো।” এসৌ নে ক়সম খাকর উসে পহলৌঠে কা হক় মুংতক়িল কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","তব যাক়ূব নে উসে কুছ রোটী ঔর দাল দে দী, ঔর এসৌ নে খাযা ঔর পিযা। ফির ৱহ উঠকর চলা গযা। যোং উসনে পহলৌঠে কে হক় কো হক়ীর জানা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","উস মুল্ক মেং দুবারা কাল পড়া, জিস তরহ ইব্রাহীম কে দিনোং মেং ভী পড় গযা থা। ইসহাক় জিরার শহর গযা জিস পর ফ়িলিস্তিযোং কে বাদশাহ অবীমলিক কী হুকূমত থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","রব নে ইসহাক় পর জ়াহির হোকর কহা, “মিসর ন জা বল্কি উস মুল্ক মেং বস জো মৈং তুঝে দিখাতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","উস মুল্ক মেং অজনবী রহ তো মৈং তেরে সাথ হূঁগা ঔর তুঝে বরকত দূঁগা। ক্যোংকি মৈং তুঝে ঔর তেরী ঔলাদ কো যহ তমাম ইলাক়া দূঁগা ঔর ৱহ ৱাদা পূরা করূঁগা জো মৈংনে ক়সম খাকর তেরে বাপ ইব্রাহীম সে কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","মৈং তুঝে ইতনী ঔলাদ দূঁগা জিতনে আসমান পর সিতারে হৈং। ঔর মৈং যহ তমাম মুল্ক উন্হেং দে দূঁগা। তেরী ঔলাদ সে দুনিযা কী তমাম ক়ৌমেং বরকত পাএঁগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","মৈং তুঝে ইসলিএ বরকত দূঁগা কি ইব্রাহীম মেরে তাবে রহা ঔর মেরী হিদাযাত ঔর অহকাম পর চলতা রহা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","চুনাঁচে ইসহাক় জিরার মেং আবাদ হো গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","জব ৱহাঁ কে মর্দোং নে রিবক়া কে বারে মেং পূছা তো ইসহাক় নে কহা, “যহ মেরী বহন হৈ।” ৱহ উন্হেং যহ বতানে সে ডরতা থা কি যহ মেরী বীৱী হৈ, ক্যোংকি উসনে সোচা, “রিবক়া নিহাযত খ়ূবসূরত হৈ। অগর উন্হেং মালূম হো জাএ কি রিবক়া মেরী বীৱী হৈ তো ৱহ উসে হাসিল করনে কী খ়াতির মুঝে ক়ত্ল কর দেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","কাফ়ী ৱক়্ত গুজ়র গযা। এক দিন ফ়িলিস্তিযোং কে বাদশাহ নে অপনী খিড়কী মেং সে ঝাঁককর দেখা কি ইসহাক় অপনী বীৱী কো প্যার কর রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","উসনে ইসহাক় কো বুলাকর কহা, “ৱহ তো আপকী বীৱী হৈ! আপনে ক্যোং কহা কি মেরী বহন হৈ?” ইসহাক় নে জৱাব দিযা, “মৈংনে সোচা কি অগর মৈং বতাঊঁ কি যহ মেরী বীৱী হৈ তো লোগ মুঝে ক়ত্ল কর দেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","অবীমলিক নে কহা, “আপনে হমারে সাথ কৈসা সুলূক কর দিখাযা! কিতনী আসানী সে মেরে আদমিযোং মেং সে কোঈ আপকী বীৱী সে হমবিসতর হো জাতা। ইস তরহ হম আপকে সবব সে এক বড়ে জুর্ম কে ক়ুসূরৱার ঠহরতে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ফির অবীমলিক নে তমাম লোগোং কো হুক্ম দিযা, “জো ভী ইস মর্দ যা উস কী বীৱী কো ছেড়ে উসে সজ়াএ-মৌত দী জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ইসহাক় নে উস ইলাক়ে মেং কাশ্তকারী কী, ঔর উসী সাল উসে সৌ গুনা ফল মিলা। যোং রব নে উসে বরকত দী, ");
INSERT INTO urdgvb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ঔর ৱহ অমীর হো গযা। উস কী দৌলত বঢ়তী গঈ, ঔর ৱহ নিহাযত দৌলতমংদ হো গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","উসকে পাস ইতনী ভেড়-বকরিযাঁ, গায-বৈল ঔর গ়ুলাম থে কি ফ়িলিস্তী উসসে হসদ করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","অব ঐসা হুআ কি উন্হোংনে উন তমাম কুওং কো মিট্টী সে ভরকর বংদ কর দিযা জো উসকে বাপ কে নৌকরোং নে খোদে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","আখ়িরকার অবীমলিক নে ইসহাক় সে কহা, “কহীং ঔর জাকর রহেং, ক্যোংকি আপ হমসে জ়্যাদা জ়োরাৱর হো গএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","চুনাঁচে ইসহাক় নে ৱহাঁ সে জাকর জিরার কী ৱাদী মেং অপনে ডেরে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ৱহাঁ ফ়িলিস্তিযোং নে ইব্রাহীম কী মৌত কে বাদ তমাম কুওং কো মিট্টী সে ভর দিযা থা। ইসহাক় নে উনকো দুবারা খুদৱাযা। উসনে উনকে ৱহী নাম রখে জো উসকে বাপ নে রখে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ইসহাক় কে নৌকরোং কো ৱাদী মেং খোদতে খোদতে তাজ়া পানী মিল গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","লেকিন জিরার কে চরৱাহে আকর ইসহাক় কে চরৱাহোং সে ঝগড়নে লগে। উন্হোংনে কহা, “যহ হমারা কুআঁ হৈ!” ইসলিএ উসনে উস কুএঁ কা নাম ইসক যানী ঝগড়া রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ইসহাক় কে নৌকরোং নে এক ঔর কুআঁ খোদ লিযা। লেকিন উস পর ভী ঝগড়া হুআ, ইসলিএ উসনে উসকা নাম সিতনা যানী মুখ়ালফ়ত রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ৱহাঁ সে জাকর উসনে এক তীসরা কুআঁ খুদৱাযা। ইস দফ়া কোঈ ঝগড়া ন হুআ, ইসলিএ উসনে উসকা নাম রহোবোত যানী ‘খুলী জগহ’ রখা। ক্যোংকি উসনে কহা, “রব নে হমেং খুলী জগহ দী হৈ, ঔর অব হম মুল্ক মেং ফলেং-ফূলেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ৱহাঁ সে ৱহ বৈর-সবা চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","উসী রাত রব উস পর জ়াহির হুআ ঔর কহা, “মৈং তেরে বাপ ইব্রাহীম কা খ়ুদা হূঁ। মত ডর, ক্যোংকি মৈং তেরে সাথ হূঁ। মৈং তুঝে বরকত দূঁগা ঔর তুঝে অপনে খ়াদিম ইব্রাহীম কী খ়াতির বহুত ঔলাদ দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ৱহাঁ ইসহাক় নে ক়ুরবানগাহ বনাঈ ঔর রব কা নাম লেকর ইবাদত কী। ৱহাঁ উসনে অপনে খ়ৈমে লগাএ ঔর উসকে নৌকরোং নে কুআঁ খোদ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","এক দিন অবীমলিক, উসকা সাথী অখ়ূজ়ত ঔর উসকা সিপহসালার ফ়ীকুল জিরার সে উসকে পাস আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ইসহাক় নে পূছা, “আপ ক্যোং মেরে পাস আএ হৈং? আপ তো মুঝসে নফ়রত রখতে হৈং। ক্যা আপনে মুঝে অপনে দরমিযান সে খ়ারিজ নহীং কিযা থা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","উন্হোংনে জৱাব দিযা, “হমনে জান লিযা হৈ কি রব আপকে সাথ হৈ। ইসলিএ হমনে কহা কি হমারা আপকে সাথ অহদ হোনা চাহিএ। আইএ হম ক়সম খাকর এক দূসরে সে অহদ বাঁধেং ");
INSERT INTO urdgvb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","কি আপ হমেং নুক়সান নহীং পহুঁচাএঁগে, ক্যোংকি হমনে ভী আপকো নহীং ছেড়া বল্কি আপসে সির্ফ় অচ্ছা সুলূক কিযা ঔর আপকো সলামতী কে সাথ রুখ়সত কিযা হৈ। ঔর অব জ়াহির হৈ কি রব নে আপকো বরকত দী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ইসহাক় নে উনকী জ়িযাফ়ত কী, ঔর উন্হোংনে খাযা ঔর পিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ফির সুবহ-সৱেরে উঠকর উন্হোংনে এক দূসরে কে সামনে ক়সম খাঈ। ইসকে বাদ ইসহাক় নে উন্হেং রুখ়সত কিযা ঔর ৱহ সলামতী সে রৱানা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","উসী দিন ইসহাক় কে নৌকর আএ ঔর উসে উস কুএঁ কে বারে মেং ইত্তলা দী জো উন্হোংনে খোদা থা। উন্হোংনে কহা, “হমেং পানী মিল গযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","উসনে কুএঁ কা নাম সবা যানী ‘ক়সম’ রখা। আজ তক সাথৱালে শহর কা নাম বৈর-সবা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","জব এসৌ 40 সাল কা থা তো উসনে দো হিত্তী ঔরতোং সে শাদী কী, বৈরী কী বেটী যহূদিত সে ঔর ঐলোন কী বেটী বাসমত সে। ");
INSERT INTO urdgvb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","যহ ঔরতেং ইসহাক় ঔর রিবক়া কে লিএ বড়ে দুখ কা বাইস বনীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ইসহাক় বূঢ়া হো গযা তো উস কী নজ়র ধুঁধলা গঈ। উসনে অপনে বড়ে বেটে কো বুলাকর কহা, “বেটা।” এসৌ নে জৱাব দিযা, “জী, মৈং হাজ়ির হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ইসহাক় নে কহা, “মৈং বূঢ়া হো গযা হূঁ ঔর খ়ুদা জানে কব মর জাঊঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ইসলিএ অপনা তীর কমান লেকর জংগল মেং নিকল জা ঔর মেরে লিএ কিসী জানৱর কা শিকার কর। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","উসে তৈযার করকে ঐসা লজ়ীজ় খানা পকা জো মুঝে পসংদ হৈ। ফির উসে মেরে পাস লে আ। মরনে সে পহলে মৈং ৱহ খানা খাকর তুঝে বরকত দেনা চাহতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","রিবক়া নে ইসহাক় কী এসৌ কে সাথ বাতচীত সুন লী থী। জব এসৌ শিকার করনে কে লিএ চলা গযা তো উসনে যাক়ূব সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","“অভী অভী মৈংনে তুম্হারে অব্বূ কো এসৌ সে যহ বাত করতে হুএ সুনা কি ");
INSERT INTO urdgvb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘মেরে লিএ কিসী জানৱর কা শিকার করকে লে আ। উসে তৈযার করকে মেরে লিএ লজ়ীজ় খানা পকা। মরনে সে পহলে মৈং যহ খানা খাকর তুঝে রব কে সামনে বরকত দেনা চাহতা হূঁ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","অব সুনো, মেরে বেটে! জো কুছ মৈং বতাতী হূঁ ৱহ করো। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","জাকর রেৱড় মেং সে বকরিযোং কে দো অচ্ছে অচ্ছে বচ্চে চুন লো। ফির মৈং ৱহী লজ়ীজ় খানা পকাঊঁগী জো তুম্হারে অব্বূ কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","তুম যহ খানা উসকে পাস লে জাওগে তো ৱহ উসে খাকর মরনে সে পহলে তুম্হেং বরকত দেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","লেকিন যাক়ূব নে এতরাজ় কিযা, “আপ জানতী হৈং কি এসৌ কে জিস্ম পর ঘনে বাল হৈং জবকি মেরে বাল কম হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","কহীং মুঝে ছূনে সে মেরে বাপ কো পতা ন চল জাএ কি মৈং উসে ফ়রেব দে রহা হূঁ। ফির মুঝ পর বরকত নহীং বল্কি লানত আএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","উস কী মাঁ নে কহা, “তুম পর আনেৱালী লানত মুঝ পর আএ, বেটা। বস মেরী বাত মান লো। জাও ঔর বকরিযোং কে ৱহ বচ্চে লে আও।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","চুনাঁচে ৱহ গযা ঔর উন্হেং অপনী মাঁ কে পাস লে আযা। রিবক়া নে ঐসা লজ়ীজ় খানা পকাযা জো যাক়ূব কে বাপ কো পসংদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","এসৌ কে খ়াস মৌক়োং কে লিএ অচ্ছে লিবাস রিবক়া কে পাস ঘর মেং থে। উসনে উনমেং সে বেহতরীন লিবাস চুনকর অপনে ছোটে বেটে কো পহনা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","সাথ সাথ উসনে বকরিযোং কী খালেং উসকে হাথোং ঔর গরদন পর জহাঁ বাল ন থে লপেট দীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ফির উসনে অপনে বেটে যাক়ূব কো রোটী ঔর ৱহ লজ়ীজ় খানা দিযা জো উসনে পকাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","যাক়ূব নে অপনে বাপ কে পাস জাকর কহা, “অব্বূ জী।” ইসহাক় নে কহা, “জী, বেটা। তূ কৌন হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","উসনে কহা, “মৈং আপকা পহলৌঠা এসৌ হূঁ। মৈংনে ৱহ কিযা হৈ জো আপনে মুঝে কহা থা। অব জ়রা উঠেং ঔর বৈঠকর মেরে শিকার কা খানা খাএঁ তাকি আপ বাদ মেং মুঝে বরকত দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ইসহাক় নে পূছা, “বেটা, তুঝে যহ শিকার ইতনী জল্দী কিস তরহ মিল গযা?” উসনে জৱাব দিযা, “রব আপকে খ়ুদা নে উসে মেরে সামনে সে গুজ়রনে দিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ইসহাক় নে কহা, “বেটা, মেরে ক়রীব আ তাকি মৈং তুঝে ছূ লূঁ কি তূ ৱাক়ঈ মেরা বেটা এসৌ হৈ কি নহীং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","যাক়ূব অপনে বাপ কে নজ়দীক আযা। ইসহাক় নে উসে ছূকর কহা, “তেরী আৱাজ় তো যাক়ূব কী হৈ লেকিন তেরে হাথ এসৌ কে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","যোং উসনে ফ়রেব খাযা। চূঁকি যাক়ূব কে হাথ এসৌ কে হাথ কী মানিংদ থে ইসলিএ উসনে উসে বরকত দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","তো ভী উসনে দুবারা পূছা, “ক্যা তূ ৱাক়ঈ মেরা বেটা এসৌ হৈ?” যাক়ূব নে জৱাব দিযা, “জী, মৈং ৱহী হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","আখ়িরকার ইসহাক় নে কহা, “শিকার কা খানা মেরে পাস লে আ, বেটা। উসে খানে কে বাদ মৈং তুঝে বরকত দূঁগা।” যাক়ূব খানা ঔর মৈ লে আযা। ইসহাক় নে খাযা ঔর পিযা, ");
INSERT INTO urdgvb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ফির কহা, “বেটা, মেরে পাস আ ঔর মুঝে বোসা দে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","যাক়ূব নে পাস আকর উসে বোসা দিযা। ইসহাক় নে উসকে লিবাস কো সূঁঘকর উসে বরকত দী। উসনে কহা, “মেরে বেটে কী খ়ুশবূ উস খুলে মৈদান কী খ়ুশবূ কী মানিংদ হৈ জিসে রব নে বরকত দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","অল্লাহ তুঝে আসমান কী ওস ঔর জ়মীন কী জ়রখ়েজ়ী দে। ৱহ তুঝে কসরত কা অনাজ ঔর অংগূর কা রস দে। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ক়ৌমেং তেরী খ়িদমত করেং, ঔর উম্মতেং তেরে সামনে ঝুক জাএঁ। অপনে ভাইযোং কা হুক্মরান বন, ঔর তেরী মাঁ কী ঔলাদ তেরে সামনে ঘুটনে টেকে। জো তুঝ পর লানত করে ৱহ খ়ুদ লানতী হো ঔর জো তুঝে বরকত দে ৱহ খ়ুদ বরকত পাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ইসহাক় কী বরকত কে বাদ যাক়ূব অভী রুখ়সত হী হুআ থা কি উসকা ভাঈ এসৌ শিকার করকে ৱাপস আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ৱহ ভী লজ়ীজ় খানা পকাকর উসে অপনে বাপ কে পাস লে আযা। উসনে কহা, “অব্বূ জী, উঠেং ঔর মেরে শিকার কা খানা খাএঁ তাকি আপ মুঝে বরকত দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ইসহাক় নে পূছা, “তূ কৌন হৈ?” উসনে জৱাব দিযা, “মৈং আপকা বড়া বেটা এসৌ হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ইসহাক় ঘবরাকর শিদ্দত সে কাঁপনে লগা। উসনে পূছা, “ফির ৱহ কৌন থা জো কিসী জানৱর কা শিকার করকে মেরে পাস লে আযা? তেরে আনে সে জ়রা পহলে মৈংনে উস শিকার কা খানা খাকর উস শখ়্স কো বরকত দী। অব ৱহ বরকত উসী পর রহেগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","যহ সুনকর এসৌ জ়োরদার ঔর তলখ় চীখ়েং মারনে লগা। “অব্বূ, মুঝে ভী বরকত দেং,” উসনে কহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","লেকিন ইসহাক় নে জৱাব দিযা, “তেরে ভাঈ নে আকর মুঝে ফ়রেব দিযা। উসনে তেরী বরকত তুঝসে ছীন লী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","এসৌ নে কহা, “উসকা নাম যাক়ূব ঠীক হী রখা গযা হৈ, ক্যোংকি অব উসনে মুঝে দূসরী বার ধোকা দিযা হৈ। পহলে উসনে পহলৌঠে কা হক় মুঝসে ছীন লিযা ঔর অব মেরী বরকত ভী জ়বরদস্তী লে লী। ক্যা আপনে মেরে লিএ কোঈ বরকত মহফ়ূজ় নহীং রখী?” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","লেকিন ইসহাক় নে কহা, “মৈংনে উসে তেরা হুক্মরান ঔর উসকে তমাম ভাইযোং কো উসকে খ়াদিম বনা দিযা হৈ। মৈংনে উসে অনাজ ঔর অংগূর কা রস মুহৈযা কিযা হৈ। অব মুঝে বতা বেটা, ক্যা কুছ রহ গযা হৈ জো মৈং তুঝে দূঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","লেকিন এসৌ খ়ামোশ ন হুআ বল্কি কহা, “অব্বূ, ক্যা আপকে পাস ৱাক়ঈ সির্ফ় যহী বরকত থী? অব্বূ, মুঝে ভী বরকত দেং।” ৱহ জ়ারো-ক়তার রোনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ফির ইসহাক় নে কহা, “তূ জ়মীন কী জ়রখ়েজ়ী ঔর আসমান কী ওস সে মহরূম রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","তূ সির্ফ় অপনী তলৱার কে সহারে জ়িংদা রহেগা ঔর অপনে ভাঈ কী খ়িদমত করেগা। লেকিন এক দিন তূ বেচৈন হোকর উসকা জুআ অপনী গরদন পর সে উতার ফেংকেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","বাপ কী বরকত কে সবব সে এসৌ যাক়ূব কা দুশ্মন বন গযা। উসনে দিল মেং কহা, “ৱহ দিন ক়রীব আ গএ হৈং কি অব্বূ ইংতক়াল কর জাএংগে ঔর হম উনকা মাতম করেংগে। ফির মৈং অপনে ভাঈ কো মার ডালূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","রিবক়া কো অপনে বড়ে বেটে এসৌ কা যহ ইরাদা মালূম হুআ। উসনে যাক়ূব কো বুলাকর কহা, “তুম্হারা ভাঈ বদলা লেনা চাহতা হৈ। ৱহ তুম্হেং ক়ত্ল করনে কা ইরাদা রখতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","বেটা, অব মেরী সুনো, যহাঁ সে হিজরত কর জাও। হারান শহর মেং মেরে ভাঈ লাবন কে পাস চলে জাও। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ৱহাঁ কুছ দিন ঠহরে রহনা জব তক তুম্হারে ভাঈ কা গ়ুস্সা ঠংডা ন হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","জব উসকা গ়ুস্সা ঠংডা হো জাএগা ঔর ৱহ তুম্হারে উসকে সাথ কিএ গএ সুলূক কো ভূল জাএগা, তব মৈং ইত্তলা দূঁগী কি তুম ৱহাঁ সে ৱাপস আ সকতে হো। মৈং ক্যোং এক হী দিন মেং তুম দোনোং সে মহরূম হো জাঊঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ফির রিবক়া নে ইসহাক় সে বাত কী, “মৈং এসৌ কী বীৱিযোং কে সবব সে অপনী জ়িংদগী সে তংগ হূঁ। অগর যাক়ূব ভী ইস মুল্ক কী ঔরতোং মেং সে কিসী সে শাদী করে তো বেহতর হৈ কি মৈং পহলে হী মর জাঊঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ইসহাক় নে যাক়ূব কো বুলাকর উসে বরকত দী ঔর কহা, “লাজ়িম হৈ কি তূ কিসী কনানী ঔরত সে শাদী ন করে। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","অব সীধে মসোপুতামিযা মেং অপনে নানা বতুএল কে ঘর জা ঔর ৱহাঁ অপনে মামূঁ লাবন কী লড়কিযোং মেং সে কিসী এক সে শাদী কর। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","অল্লাহ ক়াদিরে-মুতলক় তুঝে বরকত দেকর ফলনে ফূলনে দে ঔর তুঝে ইতনী ঔলাদ দে কি তূ বহুত সারী ক়ৌমোং কা বাপ বনে। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ৱহ তুঝে ঔর তেরী ঔলাদ কো ইব্রাহীম কী বরকত দে জিসে উসনে যহ মুল্ক দিযা জিসমেং তূ মেহমান কে তৌর পর রহতা হৈ। যহ মুল্ক তুম্হারে ক়ব্জ়ে মেং আএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","যোং ইসহাক় নে যাক়ূব কো মসোপুতামিযা মেং লাবন কে ঘর ভেজা। লাবন অরামী মর্দ বতুএল কা বেটা ঔর রিবক়া কা ভাঈ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","এসৌ কো পতা চলা কি ইসহাক় নে যাক়ূব কো বরকত দেকর মসোপুতামিযা ভেজ দিযা হৈ তাকি ৱহাঁ শাদী করে। উসে যহ ভী মালূম হুআ কি ইসহাক় নে উসে কনানী ঔরত সে শাদী করনে সে মনা কিযা হৈ ");
INSERT INTO urdgvb_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ঔর কি যাক়ূব অপনে মাঁ-বাপ কী সুনকর মসোপুতামিযা চলা গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","এসৌ সমঝ গযা কি কনানী ঔরতেং মেরে বাপ কো মংজ়ূর নহীং হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ইসলিএ ৱহ ইব্রাহীম কে বেটে ইসমাঈল কে পাস গযা ঔর উস কী বেটী মহলত সে শাদী কী। ৱহ নবাযোত কী বহন থী। যোং উস কী বীৱিযোং মেং ইজ়াফ়া হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","যাক়ূব বৈর-সবা সে হারান কী তরফ় রৱানা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","জব সূরজ গ়ুরূব হুআ তো ৱহ রাত গুজ়ারনে কে লিএ রুক গযা ঔর ৱহাঁ কে পত্থরোং মেং সে এক কো লেকর উসে অপনে সিরহানে রখা ঔর সো গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","জব ৱহ সো রহা থা তো খ়াব মেং এক সীঢ়ী দেখী জো জ়মীন সে আসমান তক পহুঁচতী থী। ফ়রিশ্তে উস পর চঢ়তে ঔর উতরতে নজ়র আতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","রব উসকে ঊপর খড়া থা। উসনে কহা, “মৈং রব ইব্রাহীম ঔর ইসহাক় কা খ়ুদা হূঁ। মৈং তুঝে ঔর তেরী ঔলাদ কো যহ জ়মীন দূঁগা জিস পর তূ লেটা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","তেরী ঔলাদ জ়মীন পর খ়াক কী তরহ বেশুমার হোগী, ঔর তূ চারোং তরফ় ফৈল জাএগা। দুনিযা কী তমাম ক়ৌমেং তেরে ঔর তেরী ঔলাদ কে ৱসীলে সে বরকত পাএঁগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","মৈং তেরে সাথ হূঁগা, তুঝে মহফ়ূজ় রখূঁগা ঔর আখ়িরকার তুঝে ইস মুল্ক মেং ৱাপস লাঊঁগা। মুমকিন হী নহীং কি মৈং তেরে সাথ অপনা ৱাদা পূরা করনে সে পহলে তুঝে ছোড় দূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","তব যাক়ূব জাগ উঠা। উসনে কহা, “যক়ীনন রব যহাঁ হাজ়ির হৈ, ঔর মুঝে মালূম নহীং থা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ৱহ ডর গযা ঔর কহা, “যহ কিতনা খ়ৌফ়নাক মক়াম হৈ। যহ তো অল্লাহ হী কা ঘর ঔর আসমান কা দরৱাজ়া হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","যাক়ূব সুবহ-সৱেরে উঠা। উসনে ৱহ পত্থর লিযা জো উসনে অপনে সিরহানে রখা থা ঔর উসে সতূন কী তরহ খড়া কিযা। ফির উসনে উস পর জ়ৈতূন কা তেল উংডেল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","উসনে মক়াম কা নাম বৈতেল যানী ‘অল্লাহ কা ঘর’ রখা (পহলে সাথৱালে শহর কা নাম লূজ় থা)। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","উসনে ক়সম খাকর কহা, “অগর রব মেরে সাথ হো, সফ়র পর মেরী হিফ়াজ়ত করে, মুঝে খানা ঔর কপড়া মুহৈযা করে ");
INSERT INTO urdgvb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ঔর মৈং সলামতী সে অপনে বাপ কে ঘর ৱাপস পহুঁচূঁ তো ফির ৱহ মেরা খ়ুদা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","জহাঁ যহ পত্থর সতূন কে তৌর পর খড়া হৈ ৱহাঁ অল্লাহ কা ঘর হোগা, ঔর জো ভী তূ মুঝে দেগা উসকা দসৱাঁ হিস্সা তুঝে দিযা করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","যাক়ূব নে অপনা সফ়র জারী রখা ঔর চলতে চলতে মশরিক়ী ক়ৌমোং কে মুল্ক মেং পহুঁচ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ৱহাঁ উসনে খেত মেং কুআঁ দেখা জিসকে ইর্দগির্দ ভেড়-বকরিযোং কে তীন রেৱড় জমা থে। রেৱড়োং কো কুএঁ কা পানী পিলাযা জানা থা, লেকিন উসকে মুঁহ পর বড়া পত্থর পড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ৱহাঁ পানী পিলানে কা যহ তরীক়া থা কি পহলে চরৱাহে তমাম রেৱড়োং কা ইংতজ়ার করতে ঔর ফির পত্থর কো লুঢ়কাকর মুঁহ সে হটা দেতে থে। পানী পিলানে কে বাদ ৱহ পত্থর কো দুবারা মুঁহ পর রখ দেতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","যাক়ূব নে চরৱাহোং সে পূছা, “মেরে ভাইযো, আপ কহাঁ কে হৈং?” উন্হোংনে জৱাব দিযা, “হারান কে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","উসনে পূছা, “ক্যা আপ নহূর কে পোতে লাবন কো জানতে হৈং?” উন্হোংনে কহা, “জী হাঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","উসনে পূছা, “ক্যা ৱহ খ়ৈরিযত সে হৈ?” উন্হোংনে কহা, “জী, ৱহ খ়ৈরিযত সে হৈ। দেখো, উধর উস কী বেটী রাখ়িল রেৱড় লেকর আ রহী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","যাক়ূব নে কহা, “অভী তো শাম তক বহুত ৱক়্ত বাক়ী হৈ। রেৱড়োং কো জমা করনে কা ৱক়্ত তো নহীং হৈ। আপ ক্যোং উন্হেং পানী পিলাকর দুবারা চরনে নহীং দেতে?” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","উন্হোংনে জৱাব দিযা, “পহলে জ়রূরী হৈ কি তমাম রেৱড় যহাঁ পহুঁচেং। তব হী পত্থর কো লুঢ়কাকর এক তরফ় হটাযা জাএগা ঔর হম রেৱড়োং কো পানী পিলাএঁগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","যাক়ূব অভী উনসে বাত কর হী রহা থা কি রাখ়িল অপনে বাপ কা রেৱড় লেকর আ পহুঁচী, ক্যোংকি ভেড়-বকরিযোং কো চরানা উসকা কাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","জব যাক়ূব নে রাখ়িল কো মামূঁ লাবন কে রেৱড় কে সাথ আতে দেখা তো উসনে কুএঁ কে পাস জাকর পত্থর কো লুঢ়কাকর মুঁহ সে হটা দিযা ঔর ভেড়-বকরিযোং কো পানী পিলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ফির উসনে উসে বোসা দিযা ঔর খ়ূব রোনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","উসনে কহা, “মৈং আপকে অব্বূ কী বহন রিবক়া কা বেটা হূঁ।” যহ সুনকর রাখ়িল নে ভাগকর অপনে অব্বূ কো ইত্তলা দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","জব লাবন নে সুনা কি মেরা ভানজা যাক়ূব আযা হৈ তো ৱহ দৌড়কর উসসে মিলনে গযা ঔর উসে গলে লগাকর অপনে ঘর লে আযা। যাক়ূব নে উসে সব কুছ বতা দিযা জো হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","লাবন নে কহা, “আপ ৱাক়ঈ মেরে রিশ্তেদার হৈং।” যাক়ূব নে ৱহাঁ এক পূরা মহীনা গুজ়ারা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ফির লাবন যাক়ূব সে কহনে লগা, “বেশক আপ মেরে রিশ্তেদার হৈং, লেকিন আপকো মেরে লিএ কাম করনে কে বদলে মেং কুছ মিলনা চাহিএ। মৈং আপকো কিতনে পৈসে দূঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","লাবন কী দো বেটিযাঁ থীং। বড়ী কা নাম লিযাহ থা ঔর ছোটী কা রাখ়িল। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","লিযাহ কী আঁখেং চুংধী থীং জবকি রাখ়িল হর তরহ সে খ়ূবসূরত থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","যাক়ূব কো রাখ়িল সে মুহব্বত থী, ইসলিএ উসনে কহা, “অগর মুঝে আপকী ছোটী বেটী রাখ়িল মিল জাএ তো আপকে লিএ সাত সাল কাম করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","লাবন নে কহা, “কিসী ঔর আদমী কী নিসবত মুঝে যহ জ়্যাদা পসংদ হৈ কি আপ হী সে উস কী শাদী করাঊঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","পস যাক়ূব নে রাখ়িল কো পানে কে লিএ সাত সাল তক কাম কিযা। লেকিন উসে ঐসা লগা জৈসা দো এক দিন হী গুজ়রে হোং ক্যোংকি ৱহ রাখ়িল কো শিদ্দত সে প্যার করতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ইসকে বাদ উসনে লাবন সে কহা, “মুদ্দত পূরী হো গঈ হৈ। অব মুঝে অপনী বেটী সে শাদী করনে দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","লাবন নে উস মক়াম কে তমাম লোগোং কো দাৱত দেকর শাদী কী জ়িযাফ়ত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","লেকিন উস রাত ৱহ রাখ়িল কী বজাএ লিযাহ কো যাক়ূব কে পাস লে আযা, ঔর যাক়ূব উসী সে হমবিসতর হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(লাবন নে লিযাহ কো অপনী লৌংডী জ়িলফ়া দে দী থী তাকি ৱহ উস কী খ়িদমত করে।) ");
INSERT INTO urdgvb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","জব সুবহ হুঈ তো যাক়ূব নে দেখা কি লিযাহ হী মেরে পাস হৈ। উসনে লাবন কে পাস জাকর কহা, “যহ আপনে মেরে সাথ ক্যা কিযা হৈ? ক্যা মৈংনে রাখ়িল কে লিএ কাম নহীং কিযা? আপনে মুঝে ধোকা ক্যোং দিযা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","লাবন নে জৱাব দিযা, “যহাঁ দস্তূর নহীং হৈ কি ছোটী বেটী কী শাদী বড়ী সে পহলে কর দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","এক হফ়তে কে বাদ শাদী কী রুসূমাত পূরী হো জাএঁগী। উস ৱক়্ত তক সব্র করেং। ফির মৈং আপকো রাখ়িল ভী দে দূঁগা। শর্ত যহ হৈ কি আপ মজ়ীদ সাত সাল মেরে লিএ কাম করেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","যাক়ূব মান গযা। চুনাঁচে জব এক হফ়তে কে বাদ শাদী কী রুসূমাত পূরী হুঈং তো লাবন নে অপনী বেটী রাখ়িল কী শাদী ভী উসকে সাথ কর দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(লাবন নে রাখ়িল কো অপনী লৌংডী বিলহাহ দে দী তাকি ৱহ উস কী খ়িদমত করে।) ");
INSERT INTO urdgvb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","যাক়ূব রাখ়িল সে ভী হমবিসতর হুআ। ৱহ লিযাহ কী নিসবত উসে জ়্যাদা প্যার করতা থা। ফির উসনে রাখ়িল কে এৱজ় সাত সাল ঔর লাবন কী খ়িদমত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","জব রব নে দেখা কি লিযাহ সে নফ়রত কী জাতী হৈ তো উসনে উসে ঔলাদ দী জবকি রাখ়িল কে হাঁ বচ্চে পৈদা ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","লিযাহ হামিলা হুঈ ঔর উসকে বেটা পৈদা হুআ। উসনে কহা, “রব নে মেরী মুসীবত দেখী হৈ ঔর অব মেরা শৌহর মুঝে প্যার করেগা।” উসনে উসকা নাম রূবিন যানী ‘দেখো এক বেটা’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ৱহ দুবারা হামিলা হুঈ। এক ঔর বেটা পৈদা হুআ। উসনে কহা, “রব নে সুনা কি মুঝসে নফ়রত কী জাতী হৈ, ইসলিএ উসনে মুঝে যহ ভী দিযা হৈ।” উসনে উসকা নাম শমৌন যানী ‘রব নে সুনা হৈ’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ৱহ এক ঔর দফ়া হামিলা হুঈ। তীসরা বেটা পৈদা হুআ। উসনে কহা, “অব আখ়িরকার শৌহর কে সাথ মেরা বংধন মজ়বূত হো জাএগা, ক্যোংকি মৈংনে উসকে লিএ তীন বেটোং কো জন্ম দিযা হৈ।” উসনে উসকা নাম লাৱী যানী বংধন রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ৱহ এক বার ফির হামিলা হুঈ। চৌথা বেটা পৈদা হুআ। উসনে কহা, “ইস দফ়া মৈং রব কী তমজীদ করূঁগী।” উসনে উসকা নাম যহূদাহ যানী তমজীদ রখা। ইসকে বাদ উসসে ঔর বচ্চে পৈদা ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","লেকিন রাখ়িল বেঔলাদ হী রহী, ইসলিএ ৱহ অপনী বহন সে হসদ করনে লগী। উসনে যাক়ূব সে কহা, “মুঝে ভী ঔলাদ দেং ৱরনা মৈং মর জাঊঁগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","যাক়ূব কো গ়ুস্সা আযা। উসনে কহা, “ক্যা মৈং অল্লাহ হূঁ জিসনে তুঝে ঔলাদ সে মহরূম রখা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","রাখ়িল নে কহা, “যহাঁ মেরী লৌংডী বিলহাহ হৈ। উসকে সাথ হমবিসতর হোং তাকি ৱহ মেরে লিএ বচ্চে কো জন্ম দে ঔর মৈং উস কী মারিফ়ত মাঁ বন জাঊঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","যোং উসনে অপনে শৌহর কো বিলহাহ দী, ঔর ৱহ উসসে হমবিসতর হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","বিলহাহ হামিলা হুঈ ঔর বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","রাখ়িল নে কহা, “অল্লাহ নে মেরে হক় মেং ফ়ৈসলা দিযা হৈ। উসনে মেরী দুআ সুনকর মুঝে বেটা দে দিযা হৈ।” উসনে উসকা নাম দান যানী ‘কিসী কে হক় মেং ফ়ৈসলা করনেৱালা’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","বিলহাহ দুবারা হামিলা হুঈ ঔর এক ঔর বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","রাখ়িল নে কহা, “মৈংনে অপনী বহন সে সখ়্ত কুশ্তী লড়ী হৈ, লেকিন জীত গঈ হূঁ।” উসনে উসকা নাম নফ়তালী যানী ‘কুশ্তী মেং মুঝসে জীতা গযা’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","জব লিযাহ নে দেখা কি মেরে ঔর বচ্চে পৈদা নহীং হো রহে তো উসনে যাক়ূব কো অপনী লৌংডী জ়িলফ়া দে দী তাকি ৱহ ভী উস কী বীৱী হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","জ়িলফ়া কে ভী এক বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","লিযাহ নে কহা, “মৈং কিতনী খ়ুশক়িসমত হূঁ!” চুনাঁচে উসনে উসকা নাম জদ যানী খ়ুশক়িসমতী রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ফির জ়িলফ়া কে দূসরা বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","লিযাহ নে কহা, “মৈং কিতনী মুবারক হূঁ। অব খ়ৱাতীন মুঝে মুবারক কহেংগী।” উসনে উসকা নাম আশর যানী মুবারক রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","এক দিন অনাজ কী ফ়সল কী কটাঈ হো রহী থী কি রূবিন বাহর নিকলকর খেতোং মেং চলা গযা। ৱহাঁ উসে মর্দুমগযাহ মিল গএ। ৱহ উন্হেং অপনী মাঁ লিযাহ কে পাস লে আযা। যহ দেখকর রাখ়িল নে লিযাহ সে কহা, “মুঝে জ়রা অপনে বেটে কে মর্দুমগযাহ মেং সে কুছ দে দো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","লিযাহ নে জৱাব দিযা, “ক্যা যহী কাফ়ী নহীং কি তুমনে মেরে শৌহর কো মুঝসে ছীন লিযা হৈ? অব মেরে বেটে কে মর্দুমগযাহ কো ভী ছীননা চাহতী হো।” রাখ়িল নে কহা, “অগর তুম মুঝে অপনে বেটে কে মর্দুমগযাহ মেং সে দো তো আজ রাত যাক়ূব কে সাথ সো সকতী হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","শাম কো যাক়ূব খেতোং সে ৱাপস আ রহা থা কি লিযাহ আগে সে উসসে মিলনে কো গঈ ঔর কহা, “আজ রাত আপকো মেরে সাথ সোনা হৈ, ক্যোংকি মৈংনে অপনে বেটে কে মর্দুমগযাহ কে এৱজ় আপকো উজরত পর লিযা হৈ।” চুনাঁচে যাক়ূব নে লিযাহ কে পাস রাত গুজ়ারী। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","উস ৱক়্ত অল্লাহ নে লিযাহ কী দুআ সুনী ঔর ৱহ হামিলা হুঈ। উসকে পাঁচৱাঁ বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","লিযাহ নে কহা, “অল্লাহ নে মুঝে ইসকা অজ্র দিযা হৈ কি মৈংনে অপনে শৌহর কো অপনী লৌংডী দী।” উসনে উসকা নাম ইশকার যানী অজ্র রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ইসকে বাদ ৱহ এক ঔর দফ়া হামিলা হুঈ। উসকে ছটা বেটা পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","উসনে কহা, “অল্লাহ নে মুঝে এক অচ্ছা-খ়াসা তোহ্ফ়া দিযা হৈ। অব মেরা খ়াৱিংদ মেরে সাথ রহেগা, ক্যোংকি মুঝসে উসকে ছঃ বেটে পৈদা হুএ হৈং।” উসনে উসকা নাম জ়বূলূন যানী রিহাইশ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ইসকে বাদ বেটী পৈদা হুঈ। উসনে উসকা নাম দীনা রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ফির অল্লাহ নে রাখ়িল কো ভী যাদ কিযা। উসনে উস কী দুআ সুনকর উসে ঔলাদ বখ়্শী। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ৱহ হামিলা হুঈ ঔর এক বেটা পৈদা হুআ। উসনে কহা, “মুঝে বেটা অতা করনে সে অল্লাহ নে মেরী ইজ়্জ়ত বহাল কর দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","রব মুঝে এক ঔর বেটা দে।” উসনে উসকা নাম যূসুফ় যানী ‘ৱহ ঔর দে’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","যূসুফ় কী পৈদাইশ কে বাদ যাক়ূব নে লাবন সে কহা, “অব মুঝে ইজাজ়ত দেং কি মৈং অপনে ৱতন ঔর ঘর কো ৱাপস জাঊঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","মুঝে মেরে বাল-বচ্চে দেং জিনকে এৱজ় মৈংনে আপকী খ়িদমত কী হৈ। ফির মৈং চলা জাঊঁগা। আপ তো খ়ুদ জানতে হৈং কি মৈংনে কিতনী মেহনত কে সাথ আপকে লিএ কাম কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","লেকিন লাবন নে কহা, “মুঝ পর মেহরবানী করেং ঔর যহীং রহেং। মুঝে গ়ৈবদানী সে পতা চলা হৈ কি রব নে মুঝে আপকে সবব সে বরকত দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","অপনী উজরত খ়ুদ মুক়র্রর করেং তো মৈং ৱহী দিযা করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","যাক়ূব নে কহা, “আপ জানতে হৈং কি মৈংনে কিস তরহ আপকে লিএ কাম কিযা, কি মেরে ৱসীলে সে আপকে মৱেশী কিতনে বঢ় গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","জো থোড়া-বহুত মেরে আনে সে পহলে আপকে পাস থা ৱহ অব বহুত জ়্যাদা বঢ় গযা হৈ। রব নে মেরে কাম সে আপকো বহুত বরকত দী হৈ। অব ৱহ ৱক়্ত আ গযা হৈ কি মৈং অপনে ঘর কে লিএ কুছ করূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","লাবন নে কহা, “মৈং আপকো ক্যা দূঁ?” যাক়ূব নে কহা, “মুঝে কুছ ন দেং। মৈং ইস শর্ত পর আপকী ভেড়-বকরিযোং কী দেখ-ভাল জারী রখূঁগা কি ");
INSERT INTO urdgvb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","আজ মৈং আপকে রেৱড় মেং সে গুজ়রকর উন তমাম ভেড়োং কো অলগ কর লূঁগা জিনকে জিস্ম পর ছোটে যা বড়ে ধব্বে হোং যা জো সফ়েদ ন হোং। ইসী তরহ মৈং উন তমাম বকরিযোং কো ভী অলগ কর লূঁগা জিনকে জিস্ম পর ছোটে যা বড়ে ধব্বে হোং। যহী মেরী উজরত হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","আইংদা জিন বকরিযোং কে জিস্ম পর ছোটে যা বড়ে ধব্বে হোংগে যা জিন ভেড়োং কা রংগ সফ়েদ নহীং হোগা ৱহ মেরা অজ্র হোংগী। জব কভী আপ উনকা মুআযনা করেংগে তো আপ মালূম কর সকেংগে কি মৈং দিযানতদার রহা হূঁ। ক্যোংকি মেরে জানৱরোং কে রংগ সে হী জ়াহির হোগা কি মৈংনে আপকা কুছ চুরাযা নহীং হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","লাবন নে কহা, “ঠীক হৈ। ঐসা হী হো জৈসা আপনে কহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","উসী দিন লাবন নে উন বকরোং কো অলগ কর লিযা জিনকে জিস্ম পর ধারিযাঁ যা ধব্বে থে ঔর উন তমাম বকরিযোং কো জিনকে জিস্ম পর ছোটে যা বড়ে ধব্বে থে। জিসকে ভী জিস্ম পর সফ়েদ নিশান থা উসে উসনে অলগ কর লিযা। ইসী তরহ উসনে উন তমাম ভেড়োং কো ভী অলগ কর লিযা জো পূরে তৌর পর সফ়েদ ন থে। ফির লাবন নে উন্হেং অপনে বেটোং কে সুপুর্দ কর দিযা ");
INSERT INTO urdgvb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","জো উনকে সাথ যাক়ূব সে ইতনা দূর চলে গএ কি উনকে দরমিযান তীন দিন কা ফ়াসলা থা। তব যাক়ূব লাবন কী বাক়ী ভেড়-বকরিযোং কী দেখ-ভাল করতা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","যাক়ূব নে সফ়েদা, বাদাম ঔর চনার কী হরী হরী শাখ়েং লেকর উনসে কুছ ছিলকা যোং উতার দিযা কি উস পর সফ়েদ ধারিযাঁ নজ়র আঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","উসনে উন্হেং ভেড়-বকরিযোং কে সামনে উন হৌজ়োং মেং গাড় দিযা জহাঁ ৱহ পানী পীতে থে, ক্যোংকি ৱহাঁ যহ জানৱর মস্ত হোকর মিলাপ করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","জব ৱহ ইন শাখ়োং কে সামনে মিলাপ করতে তো জো বচ্চে পৈদা হোতে উনকে জিস্ম পর ছোটে ঔর বড়ে ধব্বে ঔর ধারিযাঁ হোতী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ফির যাক়ূব নে ভেড় কে বচ্চোং কো অলগ করকে অপনে রেৱড়োং কো লাবন কে উন জানৱরোং কে সামনে চরনে দিযা জিনকে জিস্ম পর ধারিযাঁ থীং ঔর জো সফ়েদ ন থে। যোং উসনে অপনে জ়াতী রেৱড়োং কো অলগ কর লিযা ঔর উন্হেং লাবন কে রেৱড় কে সাথ চরনে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","লেকিন উসনে যহ শাখ়েং সির্ফ় উস ৱক়্ত হৌজ়োং মেং খড়ী কীং জব তাক়তৱর জানৱর মস্ত হোকর মিলাপ করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","কমজ়োর জানৱরোং কে সাথ উসনে ঐসা ন কিযা। ইসী তরহ লাবন কো কমজ়োর জানৱর ঔর যাক়ূব কো তাক়তৱর জানৱর মিল গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","যোং যাক়ূব বহুত অমীর বন গযা। উসকে পাস বহুত-সে রেৱড়, গ়ুলাম ঔর লৌংডিযাঁ, ঊঁট ঔর গধে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","এক দিন যাক়ূব কো পতা চলা কি লাবন কে বেটে মেরে বারে মেং কহ রহে হৈং, “যাক়ূব নে হমারে অব্বূ সে সব কুছ ছীন লিযা হৈ। উসনে যহ তমাম দৌলত হমারে বাপ কী মিলকিযত সে হাসিল কী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","যাক়ূব নে যহ ভী দেখা কি লাবন কা মেরে সাথ রৱৈযা পহলে কী নিসবত বিগড় গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ফির রব নে উসসে কহা, “অপনে বাপ কে মুল্ক ঔর অপনে রিশ্তেদারোং কে পাস ৱাপস চলা জা। মৈং তেরে সাথ হূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","উস ৱক়্ত যাক়ূব খুলে মৈদান মেং অপনে রেৱড়োং কে পাস থা। উসনে ৱহাঁ সে রাখ়িল ঔর লিযাহ কো বুলাকর ");
INSERT INTO urdgvb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","উনসে কহা, “মৈংনে দেখ লিযা হৈ কি আপকে বাপ কা মেরে সাথ রৱৈযা পহলে কী নিসবত বিগড় গযা হৈ। লেকিন মেরে বাপ কা খ়ুদা মেরে সাথ রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","আপ দোনোং জানতী হৈং কি মৈংনে আপকে অব্বূ কে লিএ কিতনী জাঁফ়িশানী সে কাম কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","লেকিন ৱহ মুঝে ফ়রেব দেতা রহা ঔর মেরী উজরত দস বার বদলী। তাহম অল্লাহ নে উসে মুঝে নুক়সান পহুঁচানে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","জব মামূঁ লাবন কহতে থে, ‘জিন জানৱরোং কে জিস্ম পর ধব্বে হোং ৱহী আপকো উজরত কে তৌর পর মিলেংগে’ তো তমাম ভেড়-বকরিযোং কে ঐসে বচ্চে পৈদা হুএ জিনকে জিস্মোং পর ধব্বে হী থে। জব উন্হোংনে কহা, ‘জিন জানৱরোং কে জিস্ম পর ধারিযাঁ হোংগী ৱহী আপকো উজরত কে তৌর পর মিলেংগে’ তো তমাম ভেড়-বকরিযোং কে ঐসে বচ্চে পৈদা হুএ জিনকে জিস্মোং পর ধারিযাঁ হী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","যোং অল্লাহ নে আপকে অব্বূ কে মৱেশী ছীনকর মুঝে দে দিএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","অব ঐসা হুআ কি হৈৱানোং কী মস্তী কে মৌসম মেং মৈংনে এক খ়াব দেখা। উসমেং জো মেংঢে ঔর বকরে ভেড়-বকরিযোং সে মিলাপ কর রহে থে উনকে জিস্ম পর বড়ে ঔর ছোটে ধব্বে ঔর ধারিযাঁ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","উস খ়াব মেং অল্লাহ কে ফ়রিশ্তে নে মুঝসে বাত কী, ‘যাক়ূব!’ মৈংনে কহা, ‘জী, মৈং হাজ়ির হূঁ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ফ়রিশ্তে নে কহা, ‘অপনী নজ়র উঠাকর উস পর গ়ৌর কর জো হো রহা হৈ। ৱহ তমাম মেংঢে ঔর বকরে জো ভেড়-বকরিযোং সে মিলাপ কর রহে হৈং উনকে জিস্ম পর বড়ে ঔর ছোটে ধব্বে ঔর ধারিযাঁ হৈং। মৈং যহ খ়ুদ করৱা রহা হূঁ, ক্যোংকি মৈংনে ৱহ সব কুছ দেখ লিযা হৈ জো লাবন নে তেরে সাথ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","মৈং ৱহ খ়ুদা হূঁ জো বৈতেল মেং তুঝ পর জ়াহির হুআ থা, উস জগহ জহাঁ তূনে সতূন পর তেল উংডেলকর উসে মেরে লিএ মখ়সূস কিযা ঔর মেরে হুজ়ূর ক়সম খাঈ থী। অব উঠ ঔর রৱানা হোকর অপনে ৱতন ৱাপস চলা জা’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","রাখ়িল ঔর লিযাহ নে জৱাব মেং যাক়ূব সে কহা, “অব হমেং অপনে বাপ কী মীরাস সে কুছ মিলনে কী উম্মীদ নহীং রহী। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","উসকা হমারে সাথ অজনবী কা-সা সুলূক হৈ। পহলে উসনে হমেং বেচ দিযা, ঔর অব উসনে ৱহ সারে পৈসে খা ভী লিএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","চুনাঁচে জো ভী দৌলত অল্লাহ নে হমারে বাপ সে ছীন লী হৈ ৱহ হমারী ঔর হমারে বচ্চোং কী হী হৈ। অব জো কুছ ভী অল্লাহ নে আপকো বতাযা হৈ ৱহ করেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","তব যাক়ূব নে উঠকর অপনে বাল-বচ্চোং কো ঊঁটোং পর বিঠাযা ");
INSERT INTO urdgvb_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ঔর অপনে তমাম মৱেশী ঔর মসোপুতামিযা সে হাসিল কিযা হুআ তমাম সামান লেকর মুল্কে-কনান মেং অপনে বাপ কে হাঁ জানে কে লিএ রৱানা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","উস ৱক়্ত লাবন অপনী ভেড়-বকরিযোং কী পশম কতরনে কো গযা হুআ থা। উস কী গ়ৈরমৌজূদগী মেং রাখ়িল নে অপনে বাপ কে বুত চুরা লিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","যাক়ূব নে লাবন কো ফ়রেব দেকর উসে ইত্তলা ন দী কি মৈং জা রহা হূঁ ");
INSERT INTO urdgvb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","বল্কি অপনী সারী মিলকিযত সমেটকর ফ়রার হুআ। দরিযাএ-ফ়ুরাত কো পার করকে ৱহ জিলিযাদ কে পহাড়ী ইলাক়ে কী তরফ় সফ়র করনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","তীন দিন গুজ়র গএ। ফির লাবন কো বতাযা গযা কি যাক়ূব ভাগ গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","অপনে রিশ্তেদারোং কো সাথ লেকর উসনে উসকা তাক়্ক়ুব কিযা। সাত দিন চলতে চলতে উসনে যাক়ূব কো আ লিযা জব ৱহ জিলিযাদ কে পহাড়ী ইলাক়ে মেং পহুঁচ গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","লেকিন উস রাত অল্লাহ নে খ়াব মেং লাবন কে পাস আকর উসসে কহা, “খ়বরদার! যাক়ূব কো বুরা-ভলা ন কহনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","জব লাবন উসকে পাস পহুঁচা তো যাক়ূব নে জিলিযাদ কে পহাড়ী ইলাক়ে মেং অপনে খ়ৈমে লগাএ হুএ থে। লাবন নে ভী অপনে রিশ্তেদারোং কে সাথ ৱহীং অপনে খ়ৈমে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","উসনে যাক়ূব সে কহা, “যহ আপনে ক্যা কিযা হৈ? আপ মুঝে ধোকা দেকর মেরী বেটিযোং কো ক্যোং জংগী ক়ৈদিযোং কী তরহ হাঁক লাএ হৈং? ");
INSERT INTO urdgvb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","আপ ক্যোং মুঝে ফ়রেব দেকর খ়ামোশী সে ভাগ আএ হৈং? অগর আপ মুঝে ইত্তলা দেতে তো মৈং আপকো খ়ুশী খ়ুশী দফ় ঔর সরোদ কে সাথ গাতে বজাতে রুখ়সত করতা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","আপনে মুঝে অপনে নৱাসে-নৱাসিযোং ঔর বেটিযোং কো বোসা দেনে কা মৌক়া ভী ন দিযা। আপকী যহ হরকত বড়ী অহমক়ানা থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","মৈং আপকো বহুত নুক়সান পহুঁচা সকতা হূঁ। লেকিন পিছলী রাত আপকে অব্বূ কে খ়ুদা নে মুঝসে কহা, ‘খ়বরদার! যাক়ূব কো বুরা-ভলা ন কহনা।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ঠীক হৈ, আপ ইসলিএ চলে গএ কি অপনে বাপ কে ঘর ৱাপস জানে কে বড়ে আরজ়ূমংদ থে। লেকিন যহ আপনে ক্যা কিযা হৈ কি মেরে বুত চুরা লাএ হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","যাক়ূব নে জৱাব দিযা, “মুঝে ডর থা কি আপ অপনী বেটিযোং কো মুঝসে ছীন লেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","লেকিন অগর আপকো যহাঁ কিসী কে পাস অপনে বুত মিল জাএঁ তো উসে সজ়াএ-মৌত দী জাএ হমারে রিশ্তেদারোং কী মৌজূদগী মেং মালূম করেং কি মেরে পাস আপকী কোঈ চীজ় হৈ কি নহীং। অগর হৈ তো উসে লে লেং।” যাক়ূব কো মালূম নহীং থা কি রাখ়িল নে বুতোং কো চুরাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","লাবন যাক়ূব কে খ়ৈমে মেং দাখ়িল হুআ ঔর ঢূঁডনে লগা। ৱহাঁ সে নিকলকর ৱহ লিযাহ কে খ়ৈমে মেং ঔর দোনোং লৌংডিযোং কে খ়ৈমে মেং গযা। লেকিন উসকে বুত কহীং নজ়র ন আএ। আখ়ির মেং ৱহ রাখ়িল কে খ়ৈমে মেং দাখ়িল হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","রাখ়িল বুতোং কো ঊঁটোং কী এক কাঠী কে নীচে ছুপাকর উস পর বৈঠ গঈ থী। লাবন টটোল টটোলকর পূরে খ়ৈমে মেং সে গুজ়রা লেকিন বুত ন মিলে। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","রাখ়িল নে অপনে বাপ সে কহা, “অব্বূ, মুঝসে নারাজ় ন হোনা কি মৈং আপকে সামনে খড়ী নহীং হো সকতী। মৈং ঐযামে-মাহৱারী কে সবব সে উঠ নহীং সকতী।” লাবন উসে ছোড়কর ঢূঁডতা রহা, লেকিন কুছ ন মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ফির যাক়ূব কো গ়ুস্সা আযা ঔর ৱহ লাবন সে ঝগড়নে লগা। উসনে পূছা, “মুঝসে ক্যা জুর্ম সরজ়দ হুআ হৈ? মৈংনে ক্যা গুনাহ কিযা হৈ কি আপ ইতনী তুংদী সে মেরে তাক়্ক়ুব কে লিএ নিকলে হৈং? ");
INSERT INTO urdgvb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","আপনে টটোল টটোলকর মেরে সারে সামান কী তলাশী লী হৈ। তো আপকা ক্যা নিকলা হৈ? উসে যহাঁ অপনে ঔর মেরে রিশ্তেদারোং কে সামনে রখেং। ফির ৱহ ফ়ৈসলা করেং কি হমমেং সে কৌন হক় পর হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","মৈং বীস সাল তক আপকে সাথ রহা হূঁ। উস দৌরান আপকী ভেড়-বকরিযাঁ বচ্চোং সে মহরূম নহীং রহীং বল্কি মৈংনে আপকা এক মেংঢা ভী নহীং খাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","জব ভী কোঈ ভেড় যা বকরী কিসী জংগলী জানৱর নে ফাড় ডালী তো মৈং উসে আপকে পাস ন লাযা বল্কি মুঝে খ়ুদ উসকা নুক়সান ভরনা পড়া। আপকা তক়াজ়া থা কি মৈং খ়ুদ চোরী হুএ মাল কা এৱজ়ানা দূঁ, খ়াহ ৱহ দিন কে ৱক়্ত চোরী হুআ যা রাত কো। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","মৈং দিন কী শদীদ গরমী কে বাইস পিঘল গযা ঔর রাত কী শদীদ সর্দী কে বাইস জম গযা। কাম ইতনা সখ়্ত থা কি মৈং নীংদ সে মহরূম রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","পূরে বীস সাল ইসী হালত মেং গুজ়র গএ। চৌদহ সাল মৈংনে আপকী বেটিযোং কে এৱজ় কাম কিযা ঔর ছঃ সাল আপকী ভেড়-বকরিযোং কে লিএ। উস দৌরান আপনে দস বার মেরী তনখ়াহ বদল দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","অগর মেরে বাপ ইসহাক় কা খ়ুদা ঔর মেরে দাদা ইব্রাহীম কা মাবূদ মেরে সাথ ন হোতা তো আপ মুঝে জ়রূর খ়ালী হাথ রুখ়সত করতে। লেকিন অল্লাহ নে মেরী মুসীবত ঔর মেরী সখ়্ত মেহনত-মশক়্ক়ত দেখী হৈ, ইসলিএ উসনে কল রাত কো মেরে হক় মেং ফ়ৈসলা দিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","তব লাবন নে যাক়ূব সে কহা, “যহ বেটিযাঁ তো মেরী বেটিযাঁ হৈং, ঔর ইনকে বচ্চে মেরে বচ্চে হৈং। যহ ভেড়-বকরিযাঁ ভী মেরী হী হৈং। লেকিন অব মৈং অপনী বেটিযোং ঔর উনকে বচ্চোং কে লিএ কুছ নহীং কর সকতা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ইসলিএ আও, হম এক দূসরে কে সাথ অহদ বাঁধেং। ইসকে লিএ হম যহাঁ পত্থরোং কা ঢের লগাএঁ জো অহদ কী গৱাহী দেতা রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","চুনাঁচে যাক়ূব নে এক পত্থর লেকর উসে সতূন কে তৌর পর খড়া কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","উসনে অপনে রিশ্তেদারোং সে কহা, “কুছ পত্থর জমা করেং।” উন্হোংনে পত্থর জমা করকে ঢের লগা দিযা। ফির উন্হোংনে উস ঢের কে পাস বৈঠকর খানা খাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","লাবন নে উসকা নাম যজর-শাহদূথা রখা জবকি যাক়ূব নে জল-এদ রখা। দোনোং নামোং কা মতলব ‘গৱাহী কা ঢের’ হৈ যানী ৱহ ঢের জো গৱাহী দেতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","লাবন নে কহা, “আজ হম দোনোং কে দরমিযান যহ ঢের অহদ কী গৱাহী দেতা হৈ।” ইসলিএ উসকা নাম জল-এদ রখা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","উসকা এক ঔর নাম মিসফ়াহ যানী ‘পহরেদারোং কা মীনার’ ভী রখা গযা। ক্যোংকি লাবন নে কহা, “রব হম পর পহরা দে জব হম এক দূসরে সে অলগ হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","মেরী বেটিযোং সে বুরা সুলূক ন করনা, ন উনকে অলাৱা কিসী ঔর সে শাদী করনা। অগর মুঝে পতা ভী ন চলে লেকিন জ়রূর যাদ রখেং কি অল্লাহ মেরে ঔর আপকে সামনে গৱাহ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","যহাঁ যহ ঢের হৈ জো মৈংনে লগা দিযা হৈ ঔর যহাঁ যহ সতূন ভী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","যহ ঢের ঔর সতূন দোনোং ইসকে গৱাহ হৈং কি ন মৈং যহাঁ সে গুজ়রকর আপকো নুক়সান পহুঁচাঊঁগা ঔর ন আপ যহাঁ সে গুজ়রকর মুঝে নুক়সান পহুঁচাএঁগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ইব্রাহীম, নহূর ঔর উনকে বাপ কা খ়ুদা হম দোনোং কে দরমিযান ফ়ৈসলা করে অগর ঐসা কোঈ মামলা হো।” জৱাব মেং যাক়ূব নে ইসহাক় কে মাবূদ কী ক়সম খাঈ কি মৈং যহ অহদ কভী নহীং তোড়ূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","উসনে পহাড় পর এক জানৱর ক়ুরবানী কে তৌর পর চঢ়াযা ঔর অপনে রিশ্তেদারোং কো খানা খানে কী দাৱত দী। উন্হোংনে খানা খাকর ৱহীং পহাড় পর রাত গুজ়ারী। ");
INSERT INTO urdgvb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","অগলে দিন সুবহ-সৱেরে লাবন নে অপনে নৱাসে-নৱাসিযোং ঔর বেটিযোং কো বোসা দেকর উন্হেং বরকত দী। ফির ৱহ অপনে ঘর ৱাপস চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","যাক়ূব নে ভী অপনা সফ়র জারী রখা। রাস্তে মেং অল্লাহ কে ফ়রিশ্তে উসসে মিলে। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","উন্হেং দেখকর উসনে কহা, “যহ অল্লাহ কী লশকরগাহ হৈ।” উসনে উস মক়াম কা নাম মহনাযম যানী ‘দো লশকরগাহেং’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","যাক়ূব নে অপনে ভাঈ এসৌ কে পাস অপনে আগে আগে ক়াসিদ ভেজে। এসৌ সঈর যানী অদোম কে মুল্ক মেং আবাদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","উন্হেং এসৌ কো বতানা থা, “আপকা খ়াদিম যাক়ূব আপকো ইত্তলা দেতা হৈ কি মৈং পরদেস মেং জাকর অব তক লাবন কা মেহমান রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ৱহাঁ মুঝে বৈল, গধে, ভেড়-বকরিযাঁ, গ়ুলাম ঔর লৌংডিযাঁ হাসিল হুএ হৈং। অব মৈং অপনে মালিক কো ইত্তলা দে রহা হূঁ কি ৱাপস আ গযা হূঁ ঔর আপকী নজ়রে-করম কা খ়াহিশমংদ হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","জব ক়াসিদ ৱাপস আএ তো উন্হোংনে কহা, “হম আপকে ভাঈ এসৌ কে পাস গএ, ঔর ৱহ 400 আদমী সাথ লেকর আপসে মিলনে আ রহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","যাক়ূব ঘবরাকর বহুত পরেশান হুআ। উসনে অপনে সাথ কে তমাম লোগোং, ভেড়-বকরিযোং, গায-বৈলোং ঔর ঊঁটোং কো দো গুরোহোং মেং তক়সীম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","খ়যাল যহ থা কি অগর এসৌ আকর এক গুরোহ পর হমলা করে তো বাক়ী গুরোহ শাযদ বচ জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ফির যাক়ূব নে দুআ কী, “ঐ মেরে দাদা ইব্রাহীম ঔর মেরে বাপ ইসহাক় কে খ়ুদা, মেরী দুআ সুন! ঐ রব, তূনে খ়ুদ মুঝে বতাযা, ‘অপনে মুল্ক ঔর রিশ্তেদারোং কে পাস ৱাপস জা, ঔর মৈং তুঝে কামযাবী দূঁগা।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","মৈং উস তমাম মেহরবানী ঔর ৱফ়াদারী কে লাযক় নহীং জো তূনে অপনে খ়াদিম কো দিখাঈ হৈ। জব মৈংনে লাবন কে পাস জাতে ৱক়্ত দরিযাএ-যরদন কো পার কিযা তো মেরে পাস সির্ফ় যহ লাঠী থী, ঔর অব মেরে পাস যহ দো গুরোহ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","মুঝে অপনে ভাঈ এসৌ সে বচা, ক্যোংকি মুঝে ডর হৈ কি ৱহ মুঝ পর হমলা করকে বাল-বচ্চোং সমেত সব কুছ তবাহ কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","তূনে খ়ুদ কহা থা, ‘মৈং তুঝে কামযাবী দূঁগা ঔর তেরী ঔলাদ ইতনী বঢ়াঊঁগা কি ৱহ সমুংদর কী রেত কী মানিংদ বেশুমার হোগী’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","যাক়ূব নে ৱহাঁ রাত গুজ়ারী। ফির উসনে অপনে মাল মেং সে এসৌ কে লিএ তোহ্ফ়ে চুন লিএ : ");
INSERT INTO urdgvb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 বকরিযাঁ, 20 বকরে, 200 ভেড়েং, 20 মেংঢে, ");
INSERT INTO urdgvb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 দূধ দেনেৱালী ঊঁটনিযাঁ বচ্চোং সমেত, 40 গাএঁ, 10 বৈল, 20 গধিযাঁ ঔর 10 গধে। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","উসনে উন্হেং মুখ়্তলিফ় রেৱড়োং মেং তক়সীম করকে অপনে মুখ়্তলিফ় নৌকরোং কে সুপুর্দ কিযা ঔর উনসে কহা, “মেরে আগে আগে চলো লেকিন হর রেৱড় কে দরমিযান ফ়াসলা রখো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","জো নৌকর পহলে রেৱড় লেকর আগে নিকলা উসসে যাক়ূব নে কহা, “মেরা ভাঈ এসৌ তুমসে মিলেগা ঔর পূছেগা, ‘তুম্হারা মালিক কৌন হৈ? তুম কহাঁ জা রহে হো? তুম্হারে সামনে কে জানৱর কিসকে হৈং?’ ");
INSERT INTO urdgvb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","জৱাব মেং তুম্হেং কহনা হৈ, ‘যহ আপকে খ়াদিম যাক়ূব কে হৈং। যহ তোহ্ফ়া হৈং জো ৱহ অপনে মালিক এসৌ কো ভেজ রহে হৈং। যাক়ূব হমারে পীছে পীছে আ রহে হৈং’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","যাক়ূব নে যহী হুক্ম হর এক নৌকর কো দিযা জিসে রেৱড় লেকর উসকে আগে আগে জানা থা। উসনে কহা, “জব তুম এসৌ সে মিলোগে তো উসসে যহী কহনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","তুম্হেং যহ ভী জ়রূর কহনা হৈ, আপকে খ়াদিম যাক়ূব হমারে পীছে আ রহে হৈং।” ক্যোংকি যাক়ূব নে সোচা, ‘মৈং ইন তোহ্ফ়োং সে উসকে সাথ সুলহ করূঁগা। ফির জব উসসে মুলাক়াত হোগী তো শাযদ ৱহ মুঝে ক়বূল কর লে।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","যোং উসনে যহ তোহ্ফ়ে অপনে আগে আগে ভেজ দিএ। লেকিন উসনে খ়ুদ খ়ৈমাগাহ মেং রাত গুজ়ারী। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","উস রাত ৱহ উঠা ঔর অপনী দো বীৱিযোং, দো লৌংডিযোং ঔর গ্যারহ বেটোং কো লেকর দরিযাএ-যব্বোক় কো ৱহাঁ সে পার কিযা জহাঁ কম গহরাঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ফির উসনে অপনা সারা সামান ভী ৱহাঁ ভেজ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","লেকিন ৱহ খ়ুদ অকেলা হী পীছে রহ গযা। উস ৱক়্ত এক আদমী আযা ঔর পৌ ফটনে তক উসসে কুশ্তী লড়তা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","জব উসনে দেখা কি মৈং যাক়ূব পর গ়ালিব নহীং আ রহা তো উসনে উসকে কূল্হে কো ছুআ, ঔর উসকা জোড় নিকল গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","আদমী নে কহা, “মুঝে জানে দে, ক্যোংকি পৌ ফটনেৱালী হৈ।” যাক়ূব নে কহা, “পহলে মুঝে বরকত দেং, ফির হী আপকো জানে দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","আদমী নে পূছা, “তেরা ক্যা নাম হৈ?” উসনে জৱাব দিযা, “যাক়ূব।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","আদমী নে কহা, “অব সে তেরা নাম যাক়ূব নহীং বল্কি ইসরাঈল যানী ‘ৱহ অল্লাহ সে লড়তা হৈ’ হোগা। ক্যোংকি তূ অল্লাহ ঔর আদমিযোং কে সাথ লড়কর গ়ালিব আযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","যাক়ূব নে কহা, “মুঝে অপনা নাম বতাএঁ।” উসনে কহা, “তূ ক্যোং মেরা নাম জাননা চাহতা হৈ?” ফির উসনে যাক়ূব কো বরকত দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","যাক়ূব নে কহা, “মৈংনে অল্লাহ কো রূবরূ দেখা তো ভী বচ গযা হূঁ।” ইসলিএ উসনে উস মক়াম কা নাম ফ়নিযেল রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","যাক়ূব ৱহাঁ সে চলা তো সূরজ তুলূ হো রহা থা। ৱহ কূল্হে কে সবব সে লঁগড়াতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","যহী ৱজহ হৈ কি আজ ভী ইসরাঈল কী ঔলাদ কূল্হে কে জোড় পর কী নস কো নহীং খাতে, ক্যোংকি যাক়ূব কী ইসী নস কো ছুআ গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ফির এসৌ উনকী তরফ় আতা হুআ নজ়র আযা। উসকে সাথ 400 আদমী থে। উন্হেং দেখকর যাক়ূব নে বচ্চোং কো বাঁটকর লিযাহ, রাখ়িল ঔর দোনোং লৌংডিযোং কে হৱালে কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","উসনে দোনোং লৌংডিযোং কো উনকে বচ্চোং সমেত আগে চলনে দিযা। ফির লিযাহ উসকে বচ্চোং সমেত ঔর আখ়ির মেং রাখ়িল ঔর যূসুফ় আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","যাক়ূব খ়ুদ সবসে আগে এসৌ সে মিলনে গযা। চলতে চলতে ৱহ সাত দফ়া জ়মীন তক ঝুকা। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","লেকিন এসৌ দৌড়কর উসসে মিলনে আযা ঔর উসে গলে লগাকর বোসা দিযা। দোনোং রো পড়ে। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ফির এসৌ নে ঔরতোং ঔর বচ্চোং কো দেখা। উসনে পূছা, “তুম্হারে সাথ যহ লোগ কৌন হৈং?” যাক়ূব নে কহা, “যহ আপকে খ়াদিম কে বচ্চে হৈং জো অল্লাহ নে অপনে করম সে নৱাজ়ে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","দোনোং লৌংডিযাঁ অপনে বচ্চোং সমেত আকর উসকে সামনে ঝুক গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ফির লিযাহ অপনে বচ্চোং কে সাথ আঈ ঔর আখ়ির মেং যূসুফ় ঔর রাখ়িল আকর ঝুক গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","এসৌ নে পূছা, “জিস জানৱরোং কে বড়ে গ়োল সে মেরী মুলাক়াত হুঈ উসসে ক্যা মুরাদ হৈ?” যাক়ূব নে জৱাব দিযা, “যহ তোহ্ফ়া হৈ তাকি আপকা খ়াদিম আপকী নজ়র মেং মক়বূল হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","লেকিন এসৌ নে কহা, “মেরে ভাঈ, মেরে পাস বহুত কুছ হৈ। যহ অপনে পাস হী রখো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","যাক়ূব নে কহা, “নহীং জী, অগর মুঝ পর আপকে করম কী নজ়র হৈ তো মেরে ইস তোহ্ফ়ে কো জ়রূর ক়বূল ফ়রমাএঁ। ক্যোংকি জব মৈংনে আপকা চেহরা দেখা তো ৱহ মেরে লিএ অল্লাহ কে চেহরে কী মানিংদ থা, আপনে মেরে সাথ ইস ক়দর অচ্ছা সুলূক কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","মেহরবানী করকে যহ তোহ্ফ়া ক়বূল করেং জো মৈং আপকে লিএ লাযা হূঁ। ক্যোংকি অল্লাহ নে মুঝ পর অপনে করম কা ইজ়হার কিযা হৈ, ঔর মেরে পাস বহুত কুছ হৈ।” যাক়ূব ইসরার করতা রহা তো আখ়িরকার এসৌ নে উসে ক়বূল কর লিযা। ফির এসৌ কহনে লগা, ");
INSERT INTO urdgvb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“আও, হম রৱানা হো জাএঁ। মৈং তুম্হারে আগে আগে চলূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","যাক়ূব নে জৱাব দিযা, “মেরে মালিক, আপ জানতে হৈং কি মেরে বচ্চে নাজ়ুক হৈং। মেরে পাস ভেড়-বকরিযাঁ, গায-বৈল ঔর উনকে দূধ পীনেৱালে বচ্চে ভী হৈং। অগর মৈং উন্হেং এক দিন কে লিএ ভী হদ সে জ়্যাদা হাঁকূঁ তো ৱহ মর জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","মেরে মালিক, মেহরবানী করকে মেরে আগে আগে জাএঁ। মৈং আরাম সে উসী রফ়্তার সে আপকে পীছে পীছে চলতা রহূঁগা জিস রফ়্তার সে মেরে মৱেশী ঔর মেরে বচ্চে চল সকেংগে। যোং হম আহিস্তা চলতে হুএ আপকে পাস সঈর পহুঁচেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","এসৌ নে কহা, “ক্যা মৈং অপনে আদমিযোং মেং সে কুছ আপকে পাস ছোড় দূঁ?” লেকিন যাক়ূব নে কহা, “ক্যা জ়রূরত হৈ? সবসে অহম বাত যহ হৈ কি আপনে মুঝে ক়বূল কর লিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","উস দিন এসৌ সঈর কে লিএ ঔর ");
INSERT INTO urdgvb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","যাক়ূব সুক্কাত কে লিএ রৱানা হুআ। ৱহাঁ উসনে অপনে লিএ মকান বনা লিযা ঔর অপনে মৱেশিযোং কে লিএ ঝোংপড়িযাঁ। ইসলিএ উস মক়াম কা নাম সুক্কাত যানী ঝোংপড়িযাঁ পড় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ফির যাক়ূব চলতে চলতে সলামতী সে সিকম শহর পহুঁচা। যোং উসকা মসোপুতামিযা সে মুল্কে-কনান তক কা সফ়র ইখ়্তিতাম তক পহুঁচ গযা। উসনে অপনে খ়ৈমে শহর কে সামনে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","উসকে খ়ৈমে হমোর কী ঔলাদ কী জ়মীন পর লগে থে। উসনে যহ জ়মীন চাঁদী কে 100 সিক্কোং কে বদলে খ়রীদ লী। ");
INSERT INTO urdgvb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ৱহাঁ উসনে ক়ুরবানগাহ বনাঈ জিসকা নাম উসনে ‘এল খ়ুদাএ-ইসরাঈল’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","এক দিন যাক়ূব ঔর লিযাহ কী বেটী দীনা কনানী ঔরতোং সে মিলনে কে লিএ ঘর সে নিকলী। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","শহর মেং এক আদমী বনাম সিকম রহতা থা। উসকা ৱালিদ হমোর উস ইলাক়ে কা হুক্মরান থা ঔর হিৱ্ৱী ক়ৌম সে তাল্লুক় রখতা থা। জব সিকম নে দীনা কো দেখা তো উসনে উসে পকড়কর উস কী ইসমতদরী কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","লেকিন উসকা দিল দীনা সে লগ গযা। ৱহ উসসে মুহব্বত করনে লগা ঔর প্যার সে উসসে বাতেং করতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","উসনে অপনে বাপ সে কহা, “ইস লড়কী কে সাথ মেরী শাদী করা দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","জব যাক়ূব নে অপনী বেটী কী ইসমতদরী কী খ়বর সুনী তো উসকে বেটে মৱেশিযোং কে সাথ খুলে মৈদান মেং থে। ইসলিএ ৱহ উনকে ৱাপস আনে তক খ়ামোশ রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","সিকম কা বাপ হমোর শহর সে নিকলকর যাক়ূব সে বাত করনে কে লিএ আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","জব যাক়ূব কে বেটোং কো দীনা কী ইসমতদরী কী খ়বর মিলী তো উনকে দিল রংজিশ ঔর গ়ুস্সে সে ভর গএ কি সিকম নে যাক়ূব কী বেটী কী ইসমতদরী সে ইসরাঈল কী ইতনী বেইজ়্জ়তী কী হৈ। ৱহ সীধে খুলে মৈদান সে ৱাপস আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","হমোর নে যাক়ূব সে কহা, “মেরে বেটে কা দিল আপকী বেটী সে লগ গযা হৈ। মেহরবানী করকে উস কী শাদী মেরে বেটে কে সাথ কর দেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","হমারে সাথ রিশ্তা বাঁধেং, হমারে বেটে-বেটিযোং কে সাথ শাদিযাঁ করাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ফির আপ হমারে সাথ ইস মুল্ক মেং রহ সকেংগে ঔর পূরা মুল্ক আপকে লিএ খুলা হোগা। আপ জহাঁ ভী চাহেং আবাদ হো সকেংগে, তিজারত কর সকেংগে ঔর জ়মীন খ়রীদ সকেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","সিকম নে খ়ুদ ভী দীনা কে বাপ ঔর ভাইযোং সে মিন্নত কী, “অগর মেরী যহ দরখ়াস্ত মংজ়ূর হো তো মৈং জো কুছ আপ কহেংগে অদা কর দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","জিতনা ভী মহর ঔর তোহ্ফ়ে আপ মুক়র্রর করেং মৈং দে দূঁগা। সির্ফ় মেরী যহ খ়াহিশ পূরী করেং কি যহ লড়কী মেরে অক়দ মেং আ জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","লেকিন দীনা কী ইসমতদরী কে সবব সে যাক়ূব কে বেটোং নে সিকম ঔর উসকে বাপ হমোর সে চালাকী করকে ");
INSERT INTO urdgvb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","কহা, “হম ঐসা নহীং কর সকতে। হম অপনী বহন কী শাদী কিসী ঐসে আদমী সে নহীং করা সকতে জিসকা খ়তনা নহীং হুআ। ইসসে হমারী বেইজ়্জ়তী হোতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","হম সির্ফ় ইস শর্ত পর রাজ়ী হোংগে কি আপ অপনে তমাম লড়কোং ঔর মর্দোং কা খ়তনা করৱানে সে হমারী মানিংদ হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ফির আপকে বেটে-বেটিযোং কে সাথ হমারী শাদিযাঁ হো সকেংগী ঔর হম আপকে সাথ এক ক়ৌম বন জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","লেকিন অগর আপ খ়তনা করানে কে লিএ তৈযার নহীং হৈং তো হম অপনী বহন কো লেকর চলে জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","যহ বাতেং হমোর ঔর উসকে বেটে সিকম কো অচ্ছী লগীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","নৌজৱান সিকম নে ফ়ৌরন উন পর অমল কিযা, ক্যোংকি ৱহ দীনা কো বহুত পসংদ করতা থা। সিকম অপনে খ়ানদান মেং সবসে মুঅজ়্জ়জ় থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","হমোর অপনে বেটে সিকম কে সাথ শহর কে দরৱাজ়ে পর গযা জহাঁ শহর কে ফ়ৈসলে কিএ জাতে থে। ৱহাঁ উন্হোংনে বাক়ী শহরিযোং সে বাত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“যহ আদমী হমসে ঝগড়নেৱালে নহীং হৈং, ইসলিএ ক্যোং ন ৱহ ইস মুল্ক মেং হমারে সাথ রহেং ঔর হমারে দরমিযান তিজারত করেং? হমারে মুল্ক মেং উনকে লিএ ভী কাফ়ী জগহ হৈ। আও, হম উনকী বেটিযোং ঔর বেটোং সে শাদিযাঁ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","লেকিন যহ আদমী সির্ফ় ইস শর্ত পর হমারে দরমিযান রহনে ঔর এক হী ক়ৌম বননে কে লিএ তৈযার হৈং কি হম উনকী তরহ অপনে তমাম লড়কোং ঔর মর্দোং কা খ়তনা করাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","অগর হম ঐসা করেং তো উনকে তমাম মৱেশী ঔর সারা মাল হমারা হী হোগা। চুনাঁচে আও, হম মুত্তফ়িক় হোকর ফ়ৈসলা কর লেং তাকি ৱহ হমারে দরমিযান রহেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","সিকম কে শহরী হমোর ঔর সিকম কে মশৱরে পর রাজ়ী হুএ। তমাম লড়কোং ঔর মর্দোং কা খ়তনা করাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","তীন দিন কে বাদ জব খ়তনে কে সবব সে লোগোং কী হালত বুরী থী তো দীনা কে দো ভাঈ শমৌন ঔর লাৱী অপনী তলৱারেং লেকর শহর মেং দাখ়িল হুএ। কিসী কো শক তক নহীং থা কি ক্যা কুছ হোগা। অংদর জাকর উন্হোংনে বচ্চোং সে লেকর বূঢ়োং তক তমাম মর্দোং কো ক়ত্ল কর দিযা ");
INSERT INTO urdgvb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","জিনমেং হমোর ঔর উসকা বেটা সিকম ভী শামিল থে। ফির ৱহ দীনা কো সিকম কে ঘর সে লেকর চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ইস ক়ত্লে-আম কে বাদ যাক়ূব কে বাক়ী বেটে শহর পর টূট পড়ে ঔর উসে লূট লিযা। যোং উন্হোংনে অপনী বহন কী ইসমতদরী কা বদলা লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ৱহ ভেড়-বকরিযাঁ, গায-বৈল, গধে ঔর শহর কে অংদর ঔর বাহর কা সব কুছ লেকর চলতে বনে। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","উন্হোংনে সারে মাল পর ক়ব্জ়া কিযা, ঔরতোং ঔর বচ্চোং কো ক়ৈদী বনা লিযা ঔর তমাম ঘরোং কা সামান ভী লে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ফির যাক়ূব নে শমৌন ঔর লাৱী সে কহা, “তুমনে মুঝে মুসীবত মেং ডাল দিযা হৈ। অব কনানী, ফ়রিজ়্জ়ী ঔর মুল্ক কে বাক়ী বাশিংদোং মেং মেরী বদনামী হুঈ হৈ। মেরে সাথ কম আদমী হৈং। অগর দূসরে মিলকর হম পর হমলা করেং তো হমারে পূরে খ়ানদান কা সত্যানাস হো জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","লেকিন উন্হোংনে কহা, “ক্যা যহ ঠীক থা কি উসনে হমারী বহন কে সাথ কসবী কা-সা সুলূক কিযা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","অল্লাহ নে যাক়ূব সে কহা, “উঠ, বৈতেল জাকর ৱহাঁ আবাদ হো। ৱহীং অল্লাহ কে লিএ জো তুঝ পর জ়াহির হুআ জব তূ অপনে ভাঈ এসৌ সে ভাগ রহা থা ক়ুরবানগাহ বনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","চুনাঁচে যাক়ূব নে অপনে ঘরৱালোং ঔর বাক়ী সারে সাথিযোং সে কহা, “জো ভী অজনবী বুত আপকে পাস হৈং উন্হেং ফেংক দেং। অপনে আপকো পাক-সাফ় করকে অপনে কপড়ে বদলেং, ");
INSERT INTO urdgvb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ক্যোংকি হমেং যহ জগহ ছোড়কর বৈতেল জানা হৈ। ৱহাঁ মৈং উস খ়ুদা কে লিএ ক়ুরবানগাহ বনাঊঁগা জিসনে মুসীবত কে ৱক়্ত মেরী দুআ সুনী। জহাঁ ভী মৈং গযা ৱহাঁ ৱহ মেরে সাথ রহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","যহ সুনকর উন্হোংনে যাক়ূব কো তমাম বুত দে দিএ জো উনকে পাস থে ঔর তমাম বালিযাঁ জো উন্হোংনে তাৱীজ় কে তৌর পর কানোং মেং পহন রখী থীং। উসনে সব কুছ সিকম কে ক়রীব বলূত কে দরখ়্ত কে নীচে জ়মীন মেং দবা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ফির ৱহ রৱানা হুএ। ইর্দগির্দ কে শহরোং পর অল্লাহ কী তরফ় সে ইতনা শদীদ খ়ৌফ় ছা গযা কি উন্হোংনে যাক়ূব ঔর উসকে বেটোং কা তাক়্ক়ুব ন কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","চলতে চলতে যাক়ূব অপনে লোগোং সমেত লূজ় পহুঁচ গযা জো মুল্কে-কনান মেং থা। আজ লূজ় কা নাম বৈতেল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","যাক়ূব নে ৱহাঁ ক়ুরবানগাহ বনাকর মক়াম কা নাম বৈতেল যানী ‘অল্লাহ কা ঘর’ রখা। ক্যোংকি ৱহাঁ অল্লাহ নে অপনে আপকো উস পর জ়াহির কিযা থা জব ৱহ অপনে ভাঈ সে ফ়রার হো রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ৱহাঁ রিবক়া কী দাযা দবোরা মর গঈ। ৱহ বৈতেল কে জুনূব মেং বলূত কে দরখ়্ত কে নীচে দফ়ন হুঈ, ইসলিএ উসকা নাম অল্লোন-বকূত যানী ‘রোনে কা বলূত কা দরখ়্ত’ রখা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","অল্লাহ যাক়ূব পর এক দফ়া ঔর জ়াহির হুআ ঔর উসে বরকত দী। যহ মসোপুতামিযা সে ৱাপস আনে পর দূসরী বার হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","অল্লাহ নে উসসে কহা, “অব সে তেরা নাম যাক়ূব নহীং বল্কি ইসরাঈল হোগা।” যোং উসনে উসকা নযা নাম ইসরাঈল রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","অল্লাহ নে যহ ভী উসসে কহা, “মৈং অল্লাহ ক়াদিরে-মুতলক় হূঁ। ফল-ফূল ঔর তাদাদ মেং বঢ়তা জা। এক ক়ৌম নহীং বল্কি বহুত-সী ক়ৌমেং তুঝসে নিকলেংগী। তেরী ঔলাদ মেং বাদশাহ ভী শামিল হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","মৈং তুঝে ৱহী মুল্ক দূঁগা জো ইব্রাহীম ঔর ইসহাক় কো দিযা হৈ। ঔর তেরে বাদ উসে তেরী ঔলাদ কো দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ফির অল্লাহ ৱহাঁ সে আসমান পর চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","জহাঁ অল্লাহ যাক়ূব সে হমকলাম হুআ থা ৱহাঁ উসনে পত্থর কা সতূন খড়া কিযা ঔর উস পর মৈ ঔর তেল উংডেলকর উসে মখ়সূস কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","উসনে জগহ কা নাম বৈতেল রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ফির যাক়ূব অপনে ঘরৱালোং কে সাথ বৈতেল কো ছোড়কর ইফ়রাতা কী তরফ় চল পড়া। রাখ়িল উম্মীদ সে থী, ঔর রাস্তে মেং বচ্চে কী পৈদাইশ কা ৱক়্ত আ গযা। বচ্চা বড়ী মুশ্কিল সে পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","জব দর্দে-জ়হ উরূজ কো পহুঁচ গযা তো দাঈ নে উসসে কহা, “মত ডরো, ক্যোংকি এক ঔর বেটা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","লেকিন ৱহ দম তোড়নেৱালী থী, ঔর মরতে মরতে উসনে উসকা নাম বিন-ঊনী যানী ‘মেরী মুসীবত কা বেটা’ রখা। লেকিন উসকে বাপ নে উসকা নাম বিনযমীন যানী ‘দহনে হাথ যা খ়ুশক়িসমতী কা বেটা’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","রাখ়িল ফ়ৌত হুঈ, ঔর ৱহ ইফ়রাতা কে রাস্তে মেং দফ়ন হুঈ। আজকল ইফ়রাতা কো বৈত-লহম কহা জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","যাক়ূব নে উস কী ক়ব্র পর পত্থর কা সতূন খড়া কিযা। ৱহ আজ তক রাখ়িল কী ক়ব্র কী নিশানদেহী করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ৱহাঁ সে যাক়ূব নে অপনা সফ়র জারী রখা ঔর মিজদল-ইদর কী পরলী তরফ় অপনে খ়ৈমে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","জব ৱহ ৱহাঁ ঠহরে থে তো রূবিন যাক়ূব কী হরম বিলহাহ সে হমবিসতর হুআ। যাক়ূব কো মালূম হো গযা। যাক়ূব কে বারহ বেটে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","লিযাহ কে বেটে যহ থে : উসকা সবসে বড়া বেটা রূবিন, ফির শমৌন, লাৱী, যহূদাহ, ইশকার ঔর জ়বূলূন। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","রাখ়িল কে দো বেটে থে, যূসুফ় ঔর বিনযমীন। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","রাখ়িল কী লৌংডী বিলহাহ কে দো বেটে থে, দান ঔর নফ়তালী। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","লিযাহ কী লৌংডী জ়িলফ়া কে দো বেটে থে, জদ ঔর আশর। যাক়ূব কে যহ বেটে মসোপুতামিযা মেং পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ফির যাক়ূব অপনে বাপ ইসহাক় কে পাস পহুঁচ গযা জো হবরূন কে ক়রীব মমরে মেং অজনবী কী হৈসিযত সে রহতা থা (উস ৱক়্ত হবরূন কা নাম ক়িরিযত-অরবা থা)। ৱহাঁ ইসহাক় ঔর উসসে পহলে ইব্রাহীম রহা করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN35_28‏","002_35_28‏","GEN","35","28‏","29","ইসহাক় 180 সাল কা থা জব ৱহ উম্ররসীদা ঔর জ়িংদগী সে আসূদা হোকর অপনে বাপদাদা সে জা মিলা। উসকে বেটে এসৌ ঔর যাক়ূব নে উসে দফ়ন কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","যহ এসৌ কী ঔলাদ কা নসবনামা হৈ (এসৌ কো অদোম ভী কহা জাতা হৈ) : ");
INSERT INTO urdgvb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","এসৌ নে তীন কনানী ঔরতোং সে শাদী কী : হিত্তী আদমী ঐলোন কী বেটী অদা সে, অনা কী বেটী উহলীবামা সে জো হিৱ্ৱী আদমী সিবোন কী নৱাসী থী ");
INSERT INTO urdgvb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ঔর ইসমাঈল কী বেটী বাসমত সে জো নবাযোত কী বহন থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","অদা কা এক বেটা ইলীফ়জ় ঔর বাসমত কা এক বেটা রঊএল পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","উহলীবামা কে তীন বেটে পৈদা হুএ, যঊস, যালাম ঔর ক়োরহ। এসৌ কে যহ তমাম বেটে মুল্কে-কনান মেং পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","বাদ মেং এসৌ দূসরে মুল্ক মেং চলা গযা। উসনে অপনী বীৱিযোং, বেটে-বেটিযোং ঔর ঘর কে রহনেৱালোং কো অপনে তমাম মৱেশিযোং ঔর মুল্কে-কনান মেং হাসিল কিএ হুএ মাল সমেত অপনে সাথ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ৱহ ইস ৱজহ সে চলা গযা কি দোনোং ভাইযোং কে পাস ইতনে রেৱড় থে কি চরানে কী জগহ কম পড় গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","চুনাঁচে এসৌ পহাড়ী ইলাক়ে সঈর মেং আবাদ হুআ। এসৌ কা দূসরা নাম অদোম হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","যহ এসৌ যানী সঈর কে পহাড়ী ইলাক়ে মেং আবাদ অদোমিযোং কা নসবনামা হৈ : ");
INSERT INTO urdgvb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","এসৌ কী বীৱী অদা কা এক বেটা ইলীফ়জ় থা জবকি উস কী বীৱী বাসমত কা এক বেটা রঊএল থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ইলীফ়জ় কে বেটে তেমান, ওমর, সফ়ো, জাতাম, ক়নজ় ");
INSERT INTO urdgvb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ঔর অমালীক় থে। অমালীক় ইলীফ়জ় কী হরম তিমনা কা বেটা থা। যহ সব এসৌ কী বীৱী অদা কী ঔলাদ মেং শামিল থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","রঊএল কে বেটে নহত, জ়ারহ, সম্মা ঔর মিজ়্জ়া থে। যহ সব এসৌ কী বীৱী বাসমত কী ঔলাদ মেং শামিল থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","এসৌ কী বীৱী উহলীবামা জো অনা কী বেটী ঔর সিবোন কী নৱাসী থী কে তীন বেটে যঊস, যালাম ঔর ক়োরহ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","এসৌ সে মুখ়্তলিফ় ক়বীলোং কে সরদার নিকলে। উসকে পহলৌঠে ইলীফ়জ় সে যহ ক়বাযলী সরদার নিকলে : তেমান, ওমর, সফ়ো, ক়নজ়, ");
INSERT INTO urdgvb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ক়োরহ, জাতাম ঔর অমালীক়। যহ সব এসৌ কী বীৱী অদা কী ঔলাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","এসৌ কে বেটে রঊএল সে যহ ক়বাযলী সরদার নিকলে : নহত, জ়ারহ, সম্মা ঔর মিজ়্জ়া। যহ সব এসৌ কী বীৱী বাসমত কী ঔলাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","এসৌ কী বীৱী উহলীবামা যানী অনা কী বেটী সে যহ ক়বাযলী সরদার নিকলে : যঊস, যালাম ঔর ক়োরহ। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","যহ তমাম সরদার এসৌ কী ঔলাদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","মুল্কে-অদোম কে কুছ বাশিংদে হোরী আদমী সঈর কী ঔলাদ থে। উনকে নাম লোতান, সোবল, সিবোন, অনা, ");
INSERT INTO urdgvb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","দীসোন, এসর ঔর দীসান থে। সঈর কে যহ বেটে মুল্কে-অদোম মেং হোরী ক়বীলোং কে সরদার থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","লোতান হোরী ঔর হেমাম কা বাপ থা। (তিমনা লোতান কী বহন থী।) ");
INSERT INTO urdgvb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","সোবল কে বেটে অলৱান, মানহত, ঐবাল, সফ়ো ঔর ওনাম থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","সিবোন কে বেটে ঐযাহ ঔর অনা থে। ইসী অনা কো গরম চশ্মে মিলে জব ৱহ বযাবান মেং অপনে বাপ কে গধে চরা রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","অনা কা এক বেটা দীসোন ঔর এক বেটী উহলীবামা থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","দীসোন কে চার বেটে হমদান, ইশবান, যিতরান ঔর কিরান থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","এসর কে তীন বেটে বিলহান, জ়াৱান ঔর অক়ান থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","দীসান কে দো বেটে ঊজ় ঔর অরান থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_29‏","002_36_29‏","GEN","36","29‏","30","যহী যানী লোতান, সোবল, সিবোন, অনা, দীসোন, এসর ঔর দীসান সঈর কে মুল্ক মেং হোরী ক়বাযল কে সরদার থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ইসসে পহলে কি ইসরাঈলিযোং কা কোঈ বাদশাহ থা জ়ৈল কে বাদশাহ যকে বাদ দীগরে মুল্কে-অদোম মেং হুকূমত করতে থে : ");
INSERT INTO urdgvb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","বালা বিন বওর জো দিনহাবা শহর কা থা মুল্কে-অদোম কা পহলা বাদশাহ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","উস কী মৌত পর যূবাব বিন জ়ারহ জো বুসরা শহর কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","উস কী মৌত পর হুশাম জো তেমানিযোং কে মুল্ক কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","উস কী মৌত পর হদদ বিন বিদদ জিসনে মুল্কে-মোআব মেং মিদিযানিযোং কো শিকস্ত দী। ৱহ অৱীত কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","উস কী মৌত পর সমলা জো মসরিক়া কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","উস কী মৌত পর সাঊল জো দরিযাএ-ফ়ুরাত পর রহোবোত শহর কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","উস কী মৌত পর বাল-হনান বিন অকবোর। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","উস কী মৌত পর হদদ জো ফ়াঊ শহর কা থা (বীৱী কা নাম মহেতবেল বিংত মতরিদ বিংত মেজ়াহাব থা)। ");
INSERT INTO urdgvb_vpl VALUES ("GN36_40‏","002_36_40‏","GEN","36","40‏","43","এসৌ সে অদোমী ক়বীলোং কে যহ সরদার নিকলে : তিমনা, অলৱহ, যতেত, উহলীবামা, ঐলা, ফ়ীনোন, ক়নজ়, তেমান, মিবসার, মজদিযেল ঔর ইরাম। অদোম কে সরদারোং কী যহ ফ়হরিস্ত উনকী মৌরূসী জ়মীন কী আবাদিযোং ঔর ক়বীলোং কে মুতাবিক় হী বযান কী গঈ হৈ। এসৌ উনকা বাপ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","যাক়ূব মুল্কে-কনান মেং রহতা থা জহাঁ পহলে উসকা বাপ ভী পরদেসী থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","যহ যাক়ূব কে খ়ানদান কা বযান হৈ। উস ৱক়্ত যাক়ূব কা বেটা যূসুফ় 17 সাল কা থা। ৱহ অপনে ভাইযোং যানী বিলহাহ ঔর জ়িলফ়া কে বেটোং কে সাথ ভেড়-বকরিযোং কী দেখ-ভাল করতা থা। যূসুফ় অপনে বাপ কো অপনে ভাইযোং কী বুরী হরকতোং কী ইত্তলা দিযা করতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","যাক়ূব যূসুফ় কো অপনে তমাম বেটোং কী নিসবত জ়্যাদা প্যার করতা থা। ৱজহ যহ থী কি ৱহ তব পৈদা হুআ জব বাপ বূঢ়া থা। ইসলিএ যাক়ূব নে উসকে লিএ এক খ়াস রংগদার লিবাস বনৱাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","জব উসকে ভাইযোং নে দেখা কি হমারা বাপ যূসুফ় কো হমসে জ়্যাদা প্যার করতা হৈ তো ৱহ উসসে নফ়রত করনে লগে ঔর অদব সে উসসে বাত নহীং করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","এক রাত যূসুফ় নে খ়াব দেখা। জব উসনে অপনে ভাইযোং কো খ়াব সুনাযা তো ৱহ উসসে ঔর ভী নফ়রত করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","উসনে কহা, “সুনো, মৈংনে খ়াব দেখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","হম সব খেত মেং পূলে বাঁধ রহে থে কি মেরা পূলা খড়া হো গযা। আপকে পূলে মেরে পূলে কে ইর্দগির্দ জমা হোকর উসকে সামনে ঝুক গএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","উসকে ভাইযোং নে কহা, “অচ্ছা, তূ বাদশাহ বনকর হম পর হুকূমত করেগা?” উসকে খ়াবোং ঔর উস কী বাতোং কে সবব সে উনকী উসসে নফ়রত মজ়ীদ বঢ় গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","কুছ দের কে বাদ যূসুফ় নে এক ঔর খ়াব দেখা। উসনে অপনে ভাইযোং সে কহা, “মৈংনে এক ঔর খ়াব দেখা হৈ। উসমেং সূরজ, চাঁদ ঔর গ্যারহ সিতারে মেরে সামনে ঝুক গএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","উসনে যহ খ়াব অপনে বাপ কো ভী সুনাযা তো উসনে উসে ডাঁটা। উসনে কহা, “যহ কৈসা খ়াব হৈ জো তূনে দেখা! যহ কৈসী বাত হৈ কি মৈং, তেরী মাঁ ঔর তেরে ভাঈ আকর তেরে সামনে জ়মীন তক ঝুক জাএঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","নতীজে মেং উসকে ভাঈ উসসে বহুত হসদ করনে লগে। লেকিন উসকে বাপ নে দিল মেং যহ বাত মহফ়ূজ় রখী। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","এক দিন জব যূসুফ় কে ভাঈ অপনে বাপ কে রেৱড় চরানে কে লিএ সিকম তক পহুঁচ গএ থে ");
INSERT INTO urdgvb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","তো যাক়ূব নে যূসুফ় সে কহা, “তেরে ভাঈ সিকম মেং রেৱড়োং কো চরা রহে হৈং। আ, মৈং তুঝে উনকে পাস ভেজ দেতা হূঁ।” যূসুফ় নে জৱাব দিযা, “ঠীক হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","যাক়ূব নে কহা, “জাকর মালূম কর কি তেরে ভাঈ ঔর উনকে সাথ কে রেৱড় খ়ৈরিযত সে হৈং কি নহীং। ফির ৱাপস আকর মুঝে বতা দেনা।” চুনাঁচে উসকে বাপ নে উসে ৱাদীএ-হবরূন সে ভেজ দিযা, ঔর যূসুফ় সিকম পহুঁচ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ৱহাঁ ৱহ ইধর-উধর ফিরতা রহা। আখ়িরকার এক আদমী উসসে মিলা ঔর পূছা, “আপ ক্যা ঢূঁড রহে হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","যূসুফ় নে জৱাব দিযা, “মৈং অপনে ভাইযোং কো তলাশ কর রহা হূঁ। মুঝে বতাএঁ কি ৱহ অপনে জানৱরোং কো কহাঁ চরা রহে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","আদমী নে কহা, “ৱহ যহাঁ সে চলে গএ হৈং। মৈংনে উন্হেং যহ কহতে সুনা কি আও, হম দূতৈন জাএঁ।” যহ সুনকর যূসুফ় অপনে ভাইযোং কে পীছে দূতৈন চলা গযা। ৱহাঁ উসে ৱহ মিল গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","জব যূসুফ় অভী দূর সে নজ়র আযা তো উসকে ভাইযোং নে উসকে পহুঁচনে সে পহলে উসে ক়ত্ল করনে কা মনসূবা বনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","উন্হোংনে কহা, “দেখো, খ়াব দেখনেৱালা আ রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","আও, হম উসে মার ডালেং ঔর উস কী লাশ কিসী গঢ়ে মেং ফেংক দেং। হম কহেংগে কি কিসী ৱহশী জানৱর নে উসে ফাড় খাযা হৈ। ফির পতা চলেগা কি উসকে খ়াবোং কী ক্যা হক়ীক়ত হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","জব রূবিন নে উনকী বাতেং সুনীং তো উসনে যূসুফ় কো বচানে কী কোশিশ কী। উসনে কহা, “নহীং, হম উসে ক়ত্ল ন করেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","উসকা খ়ূন ন করনা। বেশক উসে ইস গঢ়ে মেং ফেংক দেং জো রেগিস্তান মেং হৈ, লেকিন উসে হাথ ন লগাএঁ।” উসনে যহ ইসলিএ কহা কি ৱহ উসে বচাকর বাপ কে পাস ৱাপস পহুঁচানা চাহতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","জ্যোংহী যূসুফ় অপনে ভাইযোং কে পাস পহুঁচা উন্হোংনে উসকা রংগদার লিবাস উতারকর ");
INSERT INTO urdgvb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","যূসুফ় কো গঢ়ে মেং ফেংক দিযা। গঢ়া খ়ালী থা, উসমেং পানী নহীং থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ফির ৱহ রোটী খানে কে লিএ বৈঠ গএ। অচানক ইসমাঈলিযোং কা এক ক়াফ়িলা নজ়র আযা। ৱহ জিলিযাদ সে মিসর জা রহে থে, ঔর উনকে ঊঁট ক়ীমতী মসালোং যানী লাদন, বলসান ঔর মুর সে লদে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","তব যহূদাহ নে অপনে ভাইযোং সে কহা, “হমেং ক্যা ফ়াযদা হৈ অগর অপনে ভাঈ কো ক়ত্ল করকে উসকে খ়ূন কো ছুপা দেং? ");
INSERT INTO urdgvb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","আও, হম উসে ইন ইসমাঈলিযোং কে হাথ ফ়রোখ়্ত কর দেং। ফির কোঈ জ়রূরত নহীং হোগী কি হম উসে হাথ লগাএঁ। আখ়ির ৱহ হমারা ভাঈ হৈ।” উসকে ভাঈ রাজ়ী হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","চুনাঁচে জব মিদিযানী তাজির ৱহাঁ সে গুজ়রে তো ভাইযোং নে যূসুফ় কো খীংচকর গঢ়ে সে নিকালা ঔর চাঁদী কে 20 সিক্কোং কে এৱজ় বেচ ডালা। ইসমাঈলী উসে লেকর মিসর চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","উস ৱক়্ত রূবিন মৌজূদ নহীং থা। জব ৱহ গঢ়ে কে পাস ৱাপস আযা তো যূসুফ় উসমেং নহীং থা। যহ দেখকর উসনে পরেশানী মেং অপনে কপড়ে ফাড় ডালে। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ৱহ অপনে ভাইযোং কে পাস ৱাপস গযা ঔর কহা, “লড়কা নহীং হৈ। অব মৈং কিস তরহ অব্বূ কে পাস জাঊঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","তব উন্হোংনে বকরা জ়বহ করকে যূসুফ় কা লিবাস উসকে খ়ূন মেং ডুবোযা, ");
INSERT INTO urdgvb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ফির রংগদার লিবাস ইস খ়বর কে সাথ অপনে বাপ কো ভিজৱা দিযা কি “হমেং যহ মিলা হৈ। ইসে গ়ৌর সে দেখেং। যহ আপকে বেটে কা লিবাস তো নহীং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","যাক়ূব নে উসে পহচান লিযা ঔর কহা, “বেশক উসী কা হৈ। কিসী ৱহশী জানৱর নে উসে ফাড় খাযা হৈ। যক়ীনন যূসুফ় কো ফাড় দিযা গযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","যাক়ূব নে গ়ম কে মারে অপনে কপড়ে ফাড়ে ঔর অপনী কমর সে টাট ওঢ়কর বড়ী দের তক অপনে বেটে কে লিএ মাতম করতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","উসকে তমাম বেটে-বেটিযাঁ উসে তসল্লী দেনে আএ, লেকিন উসনে তসল্লী পানে সে ইনকার কিযা ঔর কহা, “মৈং পাতাল মেং উতরতে হুএ ভী অপনে বেটে কে লিএ মাতম করূঁগা।” ইস হালত মেং ৱহ অপনে বেটে কে লিএ রোতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ইতনে মেং মিদিযানী মিসর পহুঁচকর যূসুফ় কো বেচ চুকে থে। মিসর কে বাদশাহ ফ়িরৌন কে এক আলা অফ়সর ফ়ূতীফ়ার নে উসে খ়রীদ লিযা। ফ়ূতীফ়ার বাদশাহ কে মুহাফ়িজ়োং পর মুক়র্রর থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","উন দিনোং মেং যহূদাহ অপনে ভাইযোং কো ছোড়কর এক আদমী কে পাস রহনে লগা জিসকা নাম হীরা থা ঔর জো অদুল্লাম শহর সে থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ৱহাঁ যহূদাহ কী মুলাক়াত এক কনানী ঔরত সে হুঈ জিসকে বাপ কা নাম সুঅ থা। উসনে উসসে শাদী কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","বেটা পৈদা হুআ জিসকা নাম যহূদাহ নে এর রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","এক ঔর বেটা পৈদা হুআ জিসকা নাম বীৱী নে ওনান রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","উসকে তীসরা বেটা ভী পৈদা হুআ। উসনে উসকা নাম সেলা রখা। যহূদাহ ক়জ়ীব মেং থা জব ৱহ পৈদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","যহূদাহ নে অপনে বড়ে বেটে এর কী শাদী এক লড়কী সে করাঈ জিসকা নাম তমর থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","রব কে নজ়দীক এর শরীর থা, ইসলিএ উসনে উসে হলাক কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ইস পর যহূদাহ নে এর কে ছোটে ভাঈ ওনান সে কহা, “অপনে বড়ে ভাঈ কী বেৱা কে পাস জাও ঔর উসসে শাদী করো তাকি তুম্হারে ভাঈ কী নসল ক়াযম রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ওনান নে ঐসা কিযা, লেকিন ৱহ জানতা থা কি জো ভী বচ্চে পৈদা হোংগে ৱহ ক়ানূন কে মুতাবিক় মেরে বড়ে ভাঈ কে হোংগে। ইসলিএ জব ভী ৱহ তমর সে হমবিসতর হোতা তো নুতফ়া কো জ়মীন পর গিরা দেতা, ক্যোংকি ৱহ নহীং চাহতা থা কি মেরী মারিফ়ত মেরে ভাঈ কে বচ্চে পৈদা হোং। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","যহ বাত রব কো বুরী লগী, ঔর উসনে উসে ভী সজ়াএ-মৌত দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","তব যহূদাহ নে অপনী বহূ তমর সে কহা, “অপনে বাপ কে ঘর ৱাপস চলী জাও ঔর উস ৱক়্ত তক বেৱা রহো জব তক মেরা বেটা সেলা বড়া ন হো জাএ।” উসনে যহ ইসলিএ কহা কি উসে ডর থা কি কহীং সেলা ভী অপনে ভাইযোং কী তরহ মর ন জাএ চুনাঁচে তমর অপনে মৈকে চলী গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","কাফ়ী দিনোং কে বাদ যহূদাহ কী বীৱী জো সুঅ কী বেটী থী মর গঈ। মাতম কা ৱক়্ত গুজ়র গযা তো যহূদাহ অপনে অদুল্লামী দোস্ত হীরা কে সাথ তিমনত গযা জহাঁ যহূদাহ কী ভেড়োং কী পশম কতরী জা রহী থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","তমর কো বতাযা গযা, “আপকা সুসর অপনী ভেড়োং কী পশম কতরনে কে লিএ তিমনত জা রহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","যহ সুনকর তমর নে বেৱা কে কপড়ে উতারকর আম কপড়ে পহন লিএ। ফির ৱহ অপনা মুঁহ চাদর সে লপেটকর ঐনীম শহর কে দরৱাজ়ে পর বৈঠ গঈ জো তিমনত কে রাস্তে মেং থা। তমর নে যহ হরকত ইসলিএ কী কি যহূদাহ কা বেটা সেলা অব বালিগ় হো চুকা থা তো ভী উস কী উসকে সাথ শাদী নহীং কী গঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","জব যহূদাহ ৱহাঁ সে গুজ়রা তো উসনে উসে দেখকর সোচা কি যহ কসবী হৈ, ক্যোংকি উসনে অপনা মুঁহ ছুপাযা হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ৱহ রাস্তে সে হটকর উসকে পাস গযা ঔর কহা, “জ়রা মুঝে অপনে হাঁ আনে দেং।” (উসনে নহীং পহচানা কি যহ মেরী বহূ হৈ)। তমর নে কহা, “আপ মুঝে ক্যা দেংগে?” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","উসনে জৱাব দিযা, “মৈং আপকো বকরী কা বচ্চা ভেজ দূঁগা।” তমর নে কহা, “ঠীক হৈ, লেকিন উসে ভেজনে তক মুঝে জ়মানত দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","উসনে পূছা, “মৈং আপকো ক্যা দূঁ?” তমর নে কহা, “অপনী মুহর ঔর উসে গলে মেং লটকানে কী ডোরী। ৱহ লাঠী ভী দেং জো আপ পকড়ে হুএ হৈং।” চুনাঁচে যহূদাহ উসে যহ চীজ়েং দেকর উসকে সাথ হমবিসতর হুআ। নতীজে মেং তমর উম্মীদ সে হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ফির তমর উঠকর অপনে ঘর ৱাপস চলী গঈ। উসনে অপনী চাদর উতারকর দুবারা বেৱা কে কপড়ে পহন লিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","যহূদাহ নে অপনে দোস্ত হীরা অদুল্লামী কে হাথ বকরী কা বচ্চা ভেজ দিযা তাকি ৱহ চীজ়েং ৱাপস মিল জাএঁ জো উসনে জ়মানত কে তৌর পর দী থীং। লেকিন হীরা কো পতা ন চলা কি ঔরত কহাঁ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","উসনে ঐনীম কে বাশিংদোং সে পূছা, “ৱহ কসবী কহাঁ হৈ জো যহাঁ সড়ক পর বৈঠী থী?” উন্হোংনে জৱাব দিযা, “যহাঁ ঐসী কোঈ কসবী নহীং থী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","উসনে যহূদাহ কে পাস ৱাপস জাকর কহা, “ৱহ মুঝে নহীং মিলী বল্কি ৱহাঁ কে রহনেৱালোং নে কহা কি যহাঁ কোঈ ঐসী কসবী থী নহীং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","যহূদাহ নে কহা, “ফির ৱহ জ়মানত কী চীজ়েং অপনে পাস হী রখে। উসে ছোড় দো ৱরনা লোগ হমারা মজ়াক় উড়াএঁগে। হমনে তো পূরী কোশিশ কী কি উসে বকরী কা বচ্চা মিল জাএ, লেকিন খোজ লগানে কে বাৱুজূদ আপকো পতা ন চলা কি ৱহ কহাঁ হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","তীন মাহ কে বাদ যহূদাহ কো ইত্তলা দী গঈ, “আপকী বহূ তমর নে জ়িনা কিযা হৈ, ঔর অব ৱহ হামিলা হৈ।” যহূদাহ নে হুক্ম দিযা, “উসে বাহর লাকর জলা দো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","তমর কো জলানে কে লিএ বাহর লাযা গযা তো উসনে অপনে সুসর কো খ়বর ভেজ দী, “যহ চীজ়েং দেখেং। যহ উস আদমী কী হৈং জিসকী মারিফ়ত মৈং উম্মীদ সে হূঁ। পতা করেং কি যহ মুহর, উস কী ডোরী ঔর যহ লাঠী কিসকী হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","যহূদাহ নে উন্হেং পহচান লিযা। উসনে কহা, “মৈং নহীং বল্কি যহ ঔরত হক় পর হৈ, ক্যোংকি মৈংনে উস কী অপনে বেটে সেলা সে শাদী নহীং করাঈ।” লেকিন বাদ মেং যহূদাহ কভী ভী তমর সে হমবিসতর ন হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","জব জন্ম দেনে কা ৱক়্ত আযা তো মালূম হুআ কি জুড়ৱাঁ বচ্চে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","এক বচ্চে কা হাথ নিকলা তো দাঈ নে উসে পকড়কর উসমেং সুর্খ় ধাগা বাঁধ দিযা ঔর কহা, “যহ পহলে পৈদা হুআ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","লেকিন উসনে অপনা হাথ ৱাপস খীংচ লিযা, ঔর উসকা ভাঈ পহলে পৈদা হুআ। যহ দেখকর দাঈ বোল উঠী, “তূ কিস তরহ ফূট নিকলা হৈ!” উসনে উসকা নাম ফ়ারস যানী ফূট রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ফির উসকা ভাঈ পৈদা হুআ জিসকে হাথ মেং সুর্খ় ধাগা বঁধা হুআ থা। উসকা নাম জ়ারহ যানী চমক রখা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ইসমাঈলিযোং নে যূসুফ় কো মিসর লে জাকর বেচ দিযা থা। মিসর কে বাদশাহ কে এক আলা অফ়সর বনাম ফ়ূতীফ়ার নে উসে খ়রীদ লিযা। ৱহ শাহী মুহাফ়িজ়োং কা কপ্তান থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","রব যূসুফ় কে সাথ থা। জো ভী কাম ৱহ করতা উসমেং কামযাব রহতা। ৱহ অপনে মিসরী মালিক কে ঘর মেং রহতা থা ");
INSERT INTO urdgvb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","জিসনে দেখা কি রব যূসুফ় কে সাথ হৈ ঔর উসে হর কাম মেং কামযাবী দেতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","চুনাঁচে যূসুফ় কো মালিক কী খ়াস মেহরবানী হাসিল হুঈ, ঔর ফ়ূতীফ়ার নে উসে অপনা জ়াতী নৌকর বনা লিযা। উসনে উসে অপনে ঘরানে কে ইংতজ়াম পর মুক়র্রর কিযা ঔর অপনী পূরী মিলকিযত উসকে সুপুর্দ কর দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","জিস ৱক়্ত সে ফ়ূতীফ়ার নে অপনে ঘরানে কা ইংতজ়াম ঔর পূরী মিলকিযত যূসুফ় কে সুপুর্দ কী উস ৱক়্ত সে রব নে ফ়ূতীফ়ার কো যূসুফ় কে সবব সে বরকত দী। উস কী বরকত ফ়ূতীফ়ার কী হর চীজ় পর থী, খ়াহ ঘর মেং থী যা খেত মেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ফ়ূতীফ়ার নে অপনী হর চীজ় যূসুফ় কে হাথ মেং ছোড় দী। ঔর চূঁকি যূসুফ় সব কুছ অচ্ছী তরহ চলাতা থা ইসলিএ ফ়ূতীফ়ার কো খানা খানে কে সিৱা কিসী ভী মামলে কী ফ়িকর নহীং থী। যূসুফ় নিহাযত খ়ূবসূরত আদমী থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","কুছ দের কে বাদ উসকে মালিক কী বীৱী কী আঁখ উস পর লগী। উসনে উসসে কহা, “মেরে সাথ হমবিসতর হো!” ");
INSERT INTO urdgvb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","যূসুফ় ইনকার করকে কহনে লগা, “মেরে মালিক কো মেরে সবব সে কিসী মামলে কী ফ়িকর নহীং হৈ। উন্হোংনে সব কুছ মেরে সুপুর্দ কর দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ঘর কে ইংতজ়াম পর উনকা ইখ়্তিযার মেরে ইখ়্তিযার সে জ়্যাদা নহীং হৈ। আপকে সিৱা উন্হোংনে কোঈ ভী চীজ় মুঝসে বাজ় নহীং রখী। তো ফির মৈং কিস তরহ ইতনা গ়লত কাম করূঁ? মৈং কিস তরহ অল্লাহ কা গুনাহ করূঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","মালিক কী বীৱী রোজ় বরোজ় যূসুফ় কে পীছে পড়ী রহী কি মেরে সাথ হমবিসতর হো। লেকিন ৱহ হমেশা ইনকার করতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","এক দিন ৱহ কাম করনে কে লিএ ঘর মেং গযা। ঘর মেং ঔর কোঈ নৌকর নহীং থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ফ়ূতীফ়ার কী বীৱী নে যূসুফ় কা লিবাস পকড়কর কহা, “মেরে সাথ হমবিসতর হো!” যূসুফ় ভাগকর বাহর চলা গযা লেকিন উসকা লিবাস পীছে ঔরত কে হাথ মেং হী রহ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","জব মালিক কী বীৱী নে দেখা কি ৱহ অপনা লিবাস ছোড়কর ভাগ গযা হৈ ");
INSERT INTO urdgvb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","তো উসনে ঘর কে নৌকরোং কো বুলাকর কহা, “যহ দেখো! মেরে মালিক ইস ইবরানী কো হমারে পাস লে আএ হৈং তাকি ৱহ হমেং জ়লীল করে। ৱহ মেরী ইসমতদরী করনে কে লিএ মেরে কমরে মেং আ গযা, লেকিন মৈং ঊঁচী আৱাজ় সে চীখ়নে লগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","জব মৈং মদদ কে লিএ ঊঁচী আৱাজ় সে চীখ়নে লগী তো ৱহ অপনা লিবাস ছোড়কর ভাগ গযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","উসনে মালিক কে আনে তক যূসুফ় কা লিবাস অপনে পাস রখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","জব ৱহ ঘর ৱাপস আযা তো উসনে উসে যহী কহানী সুনাঈ, “যহ ইবরানী গ়ুলাম জো আপ লে আএ হৈং মেরী তজ়লীল কে লিএ মেরে পাস আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","লেকিন জব মৈং মদদ কে লিএ চীখ়নে লগী তো ৱহ অপনা লিবাস ছোড়কর ভাগ গযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","যহ সুনকর ফ়ূতীফ়ার বড়ে গ়ুস্সে মেং আ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","উসনে যূসুফ় কো গিরিফ়্তার করকে উস জেল মেং ডাল দিযা জহাঁ বাদশাহ কে ক়ৈদী রখে জাতে থে। ৱহীং ৱহ রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","লেকিন রব যূসুফ় কে সাথ থা। উসনে উস পর মেহরবানী কী ঔর উসে ক়ৈদখ়ানে কে দারোগ়ে কী নজ়র মেং মক়বূল কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","যূসুফ় যহাঁ তক মক়বূল হুআ কি দারোগ়ে নে তমাম ক়ৈদিযোং কো উসকে সুপুর্দ করকে উসে পূরা ইংতজ়াম চলানে কী জ়িম্মাদারী দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","দারোগ়ে কো কিসী ভী মামলে কী জিসে উসনে যূসুফ় কে সুপুর্দ কিযা থা ফ়িকর ন রহী, ক্যোংকি রব যূসুফ় কে সাথ থা ঔর উসে হর কাম মেং কামযাবী বখ়্শী। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","কুছ দের কে বাদ যোং হুআ কি মিসর কে বাদশাহ কে সরদার সাক়ী ঔর বেকরী কে ইংচার্জ নে অপনে মালিক কা গুনাহ কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ফ়িরৌন কো দোনোং অফ়সরোং পর গ়ুস্সা আ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","উসনে উন্হেং উস ক়ৈদখ়ানে মেং ডাল দিযা জো শাহী মুহাফ়িজ়োং কে কপ্তান কে সুপুর্দ থা ঔর জিসমেং যূসুফ় থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","মুহাফ়িজ়োং কে কপ্তান নে উন্হেং যূসুফ় কে হৱালে কিযা তাকি ৱহ উনকী খ়িদমত করে। ৱহাঁ ৱহ কাফ়ী দের তক রহে। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","এক রাত বাদশাহ কে সরদার সাক়ী ঔর বেকরী কে ইংচার্জ নে খ়াব দেখা। দোনোং কা খ়াব ফ়রক় ফ়রক় থা, ঔর উনকা মতলব ভী ফ়রক় ফ়রক় থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","জব যূসুফ় সুবহ কে ৱক়্ত উনকে পাস আযা তো ৱহ দবে হুএ নজ়র আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","উসনে উনসে পূছা, “আজ আপ ক্যোং ইতনে পরেশান হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","উন্হোংনে জৱাব দিযা, “হম দোনোং নে খ়াব দেখা হৈ, ঔর কোঈ নহীং জো হমেং উনকা মতলব বতাএ।” যূসুফ় নে কহা, “খ়াবোং কী তাবীর তো অল্লাহ কা কাম হৈ। জ়রা মুঝে অপনে খ়াব তো সুনাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","সরদার সাক়ী নে শুরূ কিযা, “মৈংনে খ়াব মেং অপনে সামনে অংগূর কী বেল দেখী। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","উস কী তীন শাখ়েং থীং। উসকে পত্তে লগে, কোংপলেং ফূট নিকলীং ঔর অংগূর পক গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","মেরে হাথ মেং বাদশাহ কা প্যালা থা, ঔর মৈংনে অংগূরোং কো তোড়কর যোং ভীংচ দিযা কি উনকা রস বাদশাহ কে প্যালে মেং আ গযা। ফির মৈংনে প্যালা বাদশাহ কো পেশ কিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","যূসুফ় নে কহা, “তীন শাখ়োং সে মুরাদ তীন দিন হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","তীন দিন কে বাদ ফ়িরৌন আপকো বহাল কর লেগা। আপকো পহলী জ়িম্মাদারী ৱাপস মিল জাএগী। আপ পহলে কী তরহ সরদার সাক়ী কী হৈসিযত সে বাদশাহ কা প্যালা সঁভালেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","লেকিন জব আপ বহাল হো জাএঁ তো মেরা খ়যাল করেং। মেহরবানী করকে বাদশাহ কে সামনে মেরা জ়িক্র করেং তাকি মৈং যহাঁ সে রিহা হো জাঊঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ক্যোংকি মুঝে ইবরানিযোং কে মুল্ক সে ইগ়ৱা করকে যহাঁ লাযা গযা হৈ, ঔর যহাঁ ভী মুঝসে কোঈ ঐসী গ়লতী নহীং হুঈ কি মুঝে ইস গঢ়ে মেং ফেংকা জাতা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","জব শাহী বেকরী কে ইংচার্জ নে দেখা কি সরদার সাক়ী কে খ়াব কা অচ্ছা মতলব নিকলা তো উসনে যূসুফ় সে কহা, “মেরা খ়াব ভী সুনেং। মৈংনে সর পর তীন টোকরিযাঁ উঠা রখী থীং জো বেকরী কী চীজ়োং সে ভরী হুঈ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","সবসে ঊপরৱালী টোকরী মেং ৱহ তমাম চীজ়েং থীং জো বাদশাহ কী মেজ় কে লিএ বনাঈ জাতী হৈং। লেকিন পরিংদে আকর উন্হেং খা রহে থে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","যূসুফ় নে কহা, “তীন টোকরিযোং সে মুরাদ তীন দিন হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","তীন দিন কে বাদ হী ফ়িরৌন আপকো ক়ৈদখ়ানে সে নিকালকর দরখ়্ত সে লটকা দেগা। পরিংদে আপকী লাশ কো খা জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","তীন দিন কে বাদ বাদশাহ কী সালগিরহ থী। উসনে অপনে তমাম অফ়সরোং কী জ়িযাফ়ত কী। ইস মৌক়ে পর উসনে সরদার সাক়ী ঔর বেকরী কে ইংচার্জ কো জেল সে নিকালকর অপনে হুজ়ূর লানে কা হুক্ম দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","সরদার সাক়ী কো পহলেৱালী জ়িম্মাদারী সৌংপ দী গঈ, ");
INSERT INTO urdgvb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","লেকিন বেকরী কে ইংচার্জ কো সজ়াএ-মৌত দেকর দরখ়্ত সে লটকা দিযা গযা। সব কুছ ৱৈসা হী হুআ জৈসা যূসুফ় নে কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","লেকিন সরদার সাক়ী নে যূসুফ় কা খ়যাল ন কিযা বল্কি উসে ভূল হী গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","দো সাল গুজ়র গএ কি এক রাত বাদশাহ নে খ়াব দেখা। ৱহ দরিযাএ-নীল কে কিনারে খড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","অচানক দরিযা মেং সে সাত খ়ূবসূরত ঔর মোটী গাএঁ নিকলকর সরকংডোং মেং চরনে লগীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","উনকে বাদ সাত ঔর গাএঁ নিকল আঈং। লেকিন ৱহ বদসূরত ঔর দুবলী-পতলী থীং। ৱহ দরিযা কে কিনারে দূসরী গাযোং কে পাস খড়ী হোকর ");
INSERT INTO urdgvb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","পহলী সাত খ়ূবসূরত ঔর মোটী মোটী গাযোং কো খা গঈং। ইসকে বাদ মিসর কা বাদশাহ জাগ উঠা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ফির ৱহ দুবারা সো গযা। ইস দফ়া উসনে এক ঔর খ়াব দেখা। অনাজ কে এক পৌদে পর সাত মোটী মোটী ঔর অচ্ছী অচ্ছী বালেং লগী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ফির সাত ঔর বালেং ফূট নিকলীং জো দুবলী-পতলী ঔর মশরিক়ী হৱা সে ঝুলসী হুঈ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","অনাজ কী সাত দুবলী-পতলী বালোং নে সাত মোটী ঔর খ়ূবসূরত বালোং কো নিগল লিযা। ফির ফ়িরৌন জাগ উঠা তো মালূম হুআ কি মৈংনে খ়াব হী দেখা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","সুবহ হুঈ তো ৱহ পরেশান থা, ইসলিএ উসনে মিসর কে তমাম জাদূগরোং ঔর আলিমোং কো বুলাযা। উসনে উন্হেং অপনে খ়াব সুনাএ, লেকিন কোঈ ভী উনকী তাবীর ন কর সকা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ফির সরদার সাক়ী নে ফ়িরৌন সে কহা, “আজ মুঝে অপনী খ়তাএঁ যাদ আতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","এক দিন ফ়িরৌন অপনে খ়াদিমোং সে নারাজ় হুএ। হুজ়ূর নে মুঝে ঔর বেকরী কে ইংচার্জ কো ক়ৈদখ়ানে মেং ডলৱা দিযা জিস পর শাহী মুহাফ়িজ়োং কা কপ্তান মুক়র্রর থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","এক হী রাত মেং হম দোনোং নে মুখ়্তলিফ় খ়াব দেখে জিনকা মতলব ফ়রক় ফ়রক় থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ৱহাঁ জেল মেং এক ইবরানী নৌজৱান থা। ৱহ মুহাফ়িজ়োং কে কপ্তান কা গ়ুলাম থা। হমনে উসে অপনে খ়াব সুনাএ তো উসনে হমেং উনকা মতলব বতা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ঔর জো কুছ ভী উসনে বতাযা সব কুছ ৱৈসা হী হুআ। মুঝে অপনী জ়িম্মাদারী ৱাপস মিল গঈ জবকি বেকরী কে ইংচার্জ কো সজ়াএ-মৌত দেকর দরখ়্ত সে লটকা দিযা গযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","যহ সুনকর ফ়িরৌন নে যূসুফ় কো বুলাযা, ঔর উসে জল্দী সে ক়ৈদখ়ানে সে লাযা গযা। উসনে শেৱ করৱাকর অপনে কপড়ে বদলে ঔর সীধে বাদশাহ কে হুজ়ূর পহুঁচা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","বাদশাহ নে কহা, “মৈংনে খ়াব দেখা হৈ, ঔর যহাঁ কোঈ নহীং জো উস কী তাবীর কর সকে। লেকিন সুনা হৈ কি তূ খ়াব কো সুনকর উসকা মতলব বতা সকতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","যূসুফ় নে জৱাব দিযা, “যহ মেরে ইখ়্তিযার মেং নহীং হৈ। লেকিন অল্লাহ হী বাদশাহ কো সলামতী কা পৈগ়াম দেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ফ়িরৌন নে যূসুফ় কো অপনে খ়াব সুনাএ, “মৈং খ়াব মেং দরিযাএ-নীল কে কিনারে খড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","অচানক দরিযা মেং সে সাত মোটী মোটী ঔর খ়ূবসূরত গাএঁ নিকলকর সরকংডোং মেং চরনে লগীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ইসকে বাদ সাত ঔর গাএঁ নিকলীং। ৱহ নিহাযত বদসূরত ঔর দুবলী-পতলী থীং। মৈংনে ইতনী বদসূরত গাএঁ মিসর মেং কহীং ভী নহীং দেখীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","দুবলী ঔর বদসূরত গাএঁ পহলী মোটী গাযোং কো খা গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ঔর নিগলনে কে বাদ ভী মালূম নহীং হোতা থা কি উন্হোংনে মোটী গাযোং কো খাযা হৈ। ৱহ পহলে কী তরহ বদসূরত হী থীং। ইসকে বাদ মৈং জাগ উঠা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ফির মৈংনে এক ঔর খ়াব দেখা। সাত মোটী ঔর অচ্ছী বালেং এক হী পৌদে পর লগী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ইসকে বাদ সাত ঔর বালেং নিকলীং জো খ়রাব, দুবলী-পতলী ঔর মশরিক়ী হৱা সে ঝুলসী হুঈ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","সাত দুবলী-পতলী বালেং সাত অচ্ছী বালোং কো নিগল গঈং। মৈংনে যহ সব কুছ অপনে জাদূগরোং কো বতাযা, লেকিন ৱহ ইসকী তাবীর ন কর সকে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","যূসুফ় নে বাদশাহ সে কহা, “দোনোং খ়াবোং কা এক হী মতলব হৈ। ইনসে অল্লাহ নে হুজ়ূর পর জ়াহির কিযা হৈ কি ৱহ ক্যা কুছ করনে কো হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","সাত অচ্ছী গাযোং সে মুরাদ সাত সাল হৈং। ইসী তরহ সাত অচ্ছী বালোং সে মুরাদ ভী সাত সাল হৈং। দোনোং খ়াব এক হী বাত বযান করতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","জো সাত দুবলী ঔর বদসূরত গাএঁ বাদ মেং নিকলেং উনসে মুরাদ সাত ঔর সাল হৈং। যহী সাত দুবলী-পতলী ঔর মশরিক়ী হৱা সে ঝুলসী হুঈ বালোং কা মতলব ভী হৈ। ৱহ এক হী বাত বযান করতী হৈং কি সাত সাল তক কাল পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","যহ ৱহী বাত হৈ জো মৈংনে হুজ়ূর সে কহী কি অল্লাহ নে হুজ়ূর পর জ়াহির কিযা হৈ কি ৱহ ক্যা করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","সাত সাল আএঁগে জিনকে দৌরান মিসর কে পূরে মুল্ক মেং কসরত সে পৈদাৱার হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","উসকে বাদ সাত সাল কাল পড়েগা। কাল ইতনা শদীদ হোগা কি লোগ ভূল জাএংগে কি পহলে ইতনী কসরত থী। ক্যোংকি কাল মুল্ক কো তবাহ কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","কাল কী শিদ্দত কে বাইস অচ্ছে সালোং কী কসরত যাদ হী নহীং রহেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","হুজ়ূর কো ইসলিএ এক হী পৈগ়াম দো মুখ়্তলিফ় খ়াবোং কী সূরত মেং মিলা কি অল্লাহ ইসকা পক্কা ইরাদা রখতা হৈ, ঔর ৱহ জল্দ হী ইস পর অমল করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","অব বাদশাহ কিসী সমঝদার ঔর দানিশমংদ আদমী কো মুল্কে-মিসর কা ইংতজ়াম সৌংপেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ইসকে অলাৱা ৱহ ঐসে আদমী মুক়র্রর করেং জো সাত অচ্ছে সালোং কে দৌরান হর ফ়সল কা পাঁচৱাঁ হিস্সা লেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ৱহ উন অচ্ছে সালোং কে দৌরান খ়ুরাক জমা করেং। বাদশাহ উন্হেং ইখ়্তিযার দেং কি ৱহ শহরোং মেং গোদাম বনাকর অনাজ কো মহফ়ূজ় কর লেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","যহ খ়ুরাক কাল কে উন সাত সালোং কে লিএ মখ়সূস কী জাএ জো মিসর মেং আনেৱালে হৈং। যোং মুল্ক তবাহ নহীং হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","যহ মনসূবা বাদশাহ ঔর উসকে অফ়সরান কো অচ্ছা লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","উসনে উনসে কহা, “হমেং ইস কাম কে লিএ যূসুফ় সে জ়্যাদা লাযক় আদমী নহীং মিলেগা। উসমেং অল্লাহ কী রূহ হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","বাদশাহ নে যূসুফ় সে কহা, “অল্লাহ নে যহ সব কুছ তুঝ পর জ়াহির কিযা হৈ, ইসলিএ কোঈ ভী তুঝসে জ়্যাদা সমঝদার ঔর দানিশমংদ নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","মৈং তুঝে অপনে মহল পর মুক়র্রর করতা হূঁ। মেরী তমাম রিআযা তেরে তাবে রহেগী। তেরা ইখ়্তিযার সির্ফ় মেরে ইখ়্তিযার সে কম হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","অব মৈং তুঝে পূরে মুল্কে-মিসর পর হাকিম মুক়র্রর করতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","বাদশাহ নে অপনী উঁগলী সে ৱহ অংগূঠী উতারী জিসসে মুহর লগাতা থা ঔর উসে যূসুফ় কী উঁগলী মেং পহনা দিযা। উসনে উসে কতান কা বারীক লিবাস পহনাযা ঔর উসকে গলে মেং সোনে কা গুলূবংদ পহনা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ফির উসনে উসে অপনে দূসরে রথ মেং সৱার কিযা ঔর লোগ উসকে আগে আগে পুকারতে রহে, “ঘুটনে টেকো! ঘুটনে টেকো!” যোং যূসুফ় পূরে মিসর কা হাকিম বনা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ফ়িরৌন নে উসসে কহা, “মৈং তো বাদশাহ হূঁ, লেকিন তেরী ইজাজ়ত কে বগ়ৈর পূরে মুল্ক মেং কোঈ ভী অপনা হাথ যা পাঁৱ নহীং হিলাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_45‏","002_41_45‏","GEN","41","45‏","46","উসনে যূসুফ় কা মিসরী নাম সাফ়নত-ফ়ানেহ রখা ঔর ওন কে পুজারী ফ়োতীফ়িরা কী বেটী আসনত কে সাথ উস কী শাদী করাঈ। যূসুফ় 30 সাল কা থা জব ৱহ মিসর কে বাদশাহ ফ়িরৌন কী খ়িদমত করনে লগা। উসনে ফ়িরৌন কে হুজ়ূর সে নিকলকর মিসর কা দৌরা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","সাত অচ্ছে সালোং কে দৌরান মুল্ক মেং নিহাযত অচ্ছী ফ়সলেং উগীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","যূসুফ় নে তমাম খ়ুরাক জমা করকে শহরোং মেং মহফ়ূজ় কর লী। হর শহর মেং উসনে ইর্দগির্দ কে খেতোং কী পৈদাৱার মহফ়ূজ় রখী। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","জমাশুদা অনাজ সমুংদর কী রেত কী মানিংদ বকসরত থা। ইতনা অনাজ থা কি যূসুফ় নে আখ়িরকার উস কী পৈমাইশ করনা ছোড় দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","কাল সে পহলে যূসুফ় ঔর আসনত কে দো বেটে পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","উসনে পহলে কা নাম মনস্সী যানী ‘জো ভুলা দেতা হৈ’ রখা। ক্যোংকি উসনে কহা, “অল্লাহ নে মেরী মুসীবত ঔর মেরে বাপ কা ঘরানা মেরী যাদদাশ্ত সে নিকাল দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","দূসরে কা নাম উসনে ইফ়রাঈম যানী ‘দুগনা ফলদার’ রখা। ক্যোংকি উসনে কহা, “অল্লাহ নে মুঝে মেরী মুসীবত কে মুল্ক মেং ফলনে ফূলনে দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","সাত অচ্ছে সাল জিনমেং কসরত কী ফ়সলেং উগীং গুজ়র গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ফির কাল কে সাত সাল শুরূ হুএ জিস তরহ যূসুফ় নে কহা থা। তমাম দীগর মমালিক মেং ভী কাল পড় গযা, লেকিন মিসর মেং ৱাফ়ির খ়ুরাক পাঈ জাতী থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","জব কাল নে তমাম মিসর মেং জ়োর পকড়া তো লোগ চীখ়কর খানে কে লিএ বাদশাহ সে মিন্নত করনে লগে। তব ফ়িরৌন নে উনসে কহা, “যূসুফ় কে পাস জাও। জো কুছ ৱহ তুম্হেং বতাএগা ৱহী করো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","জব কাল পূরী দুনিযা মেং ফৈল গযা তো যূসুফ় নে অনাজ কে গোদাম খোলকর মিসরিযোং কো অনাজ বেচ দিযা। ক্যোংকি কাল কে বাইস মুল্ক কে হালাত বহুত খ়রাব হো গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","তমাম মমালিক সে ভী লোগ অনাজ খ়রীদনে কে লিএ যূসুফ় কে পাস আএ, ক্যোংকি পূরী দুনিযা সখ়্ত কাল কী গিরিফ়্ত মেং থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","জব যাক়ূব কো মালূম হুআ কি মিসর মেং অনাজ হৈ তো উসনে অপনে বেটোং সে কহা, “তুম ক্যোং এক দূসরে কা মুঁহ তকতে হো? ");
INSERT INTO urdgvb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","সুনা হৈ কি মিসর মেং অনাজ হৈ। ৱহাঁ জাকর হমারে লিএ কুছ খ়রীদ লাও তাকি হম ভূকে ন মরেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","তব যূসুফ় কে দস ভাঈ অনাজ খ়রীদনে কে লিএ মিসর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","লেকিন যাক়ূব নে যূসুফ় কে সগে ভাঈ বিনযমীন কো সাথ ন ভেজা, ক্যোংকি উসনে কহা, “ঐসা ন হো কি উসে জানী নুক়সান পহুঁচে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","যোং যাক়ূব কে বেটে বহুত সারে ঔর লোগোং কে সাথ মিসর গএ, ক্যোংকি মুল্কে-কনান ভী কাল কী গিরিফ়্ত মেং থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","যূসুফ় মিসর কে হাকিম কী হৈসিযত সে লোগোং কো অনাজ বেচতা থা, ইসলিএ উসকে ভাঈ আকর উসকে সামনে মুঁহ কে বল ঝুক গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","জব যূসুফ় নে অপনে ভাইযোং কো দেখা তো উসনে উন্হেং পহচান লিযা লেকিন ঐসা কিযা জৈসা উনসে নাৱাক়িফ় হো ঔর সখ়্তী সে উনসে বাত কী, “তুম কহাঁ সে আএ হো?” উন্হোংনে জৱাব দিযা, “হম মুল্কে-কনান সে অনাজ খ়রীদনে কে লিএ আএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","গো যূসুফ় নে অপনে ভাইযোং কো পহচান লিযা, লেকিন উন্হোংনে উসে ন পহচানা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","উসে ৱহ খ়াব যাদ আএ জো উসনে উনকে বারে মেং দেখে থে। উসনে কহা, “তুম জাসূস হো। তুম যহ দেখনে আএ হো কি হমারা মুল্ক কিন কিন জগহোং পর গ়ৈরমহফ়ূজ় হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","উন্হোংনে কহা, “জনাব, হরগিজ় নহীং। আপকে গ়ুলাম গ়ল্লা খ়রীদনে আএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","হম সব এক হী মর্দ কে বেটে হৈং। আপকে খ়াদিম শরীফ় লোগ হৈং, জাসূস নহীং হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","লেকিন যূসুফ় নে ইসরার কিযা, “নহীং, তুম দেখনে আএ হো কি হমারা মুল্ক কিন কিন জগহোং পর গ়ৈরমহফ়ূজ় হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","উন্হোংনে অর্জ় কী, “আপকে খ়াদিম কুল বারহ ভাঈ হৈং। হম এক হী আদমী কে বেটে হৈং জো কনান মেং রহতা হৈ। সবসে ছোটা ভাঈ ইস ৱক়্ত হমারে বাপ কে পাস হৈ জবকি এক মর গযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","লেকিন যূসুফ় নে অপনা ইলজ়াম দোহরাযা, “ঐসা হী হৈ জৈসা মৈংনে কহা হৈ কি তুম জাসূস হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","মৈং তুম্হারী বাতেং জাঁচ লূঁগা। ফ়িরৌন কী হযাত কী ক়সম, পহলে তুম্হারা সবসে ছোটা ভাঈ আএ, ৱরনা তুম ইস জগহ সে কভী নহীং জা সকোগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","এক ভাঈ কো উসে লানে কে লিএ ভেজ দো। বাক়ী সব যহাঁ গিরিফ়্তার রহেংগে। ফির পতা চলেগা কি তুম্হারী বাতেং সচ হৈং কি নহীং। অগর নহীং তো ফ়িরৌন কী হযাত কী ক়সম, ইসকা মতলব যহ হোগা কি তুম জাসূস হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","যহ কহকর যূসুফ় নে উন্হেং তীন দিন কে লিএ ক়ৈদখ়ানে মেং ডাল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","তীসরে দিন উসনে উনসে কহা, “মৈং অল্লাহ কা খ়ৌফ় মানতা হূঁ, ইসলিএ তুমকো এক শর্ত পর জীতা ছোড়ূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","অগর তুম ৱাক়ঈ শরীফ় লোগ হো তো ঐসা করো কি তুমমেং সে এক যহাঁ ক়ৈদখ়ানে মেং রহে জবকি বাক়ী সব অনাজ লেকর অপনে ভূকে ঘরৱালোং কে পাস ৱাপস জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","লেকিন লাজ়িম হৈ কি তুম অপনে সবসে ছোটে ভাঈ কো মেরে পাস লে আও। সির্ফ় ইসসে তুম্হারী বাতেং সচ সাবিত হোংগী ঔর তুম মৌত সে বচ জাওগে।” যূসুফ় কে ভাঈ রাজ়ী হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ৱহ আপস মেং কহনে লগে, “বেশক যহ হমারে অপনে ভাঈ পর জ়ুল্ম কী সজ়া হৈ। জব ৱহ ইল্তিজা কর রহা থা কি মুঝ পর রহম করেং তো হমনে উস কী বড়ী মুসীবত দেখকর ভী উস কী ন সুনী। ইসলিএ যহ মুসীবত হম পর আ গঈ হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ঔর রূবিন নে কহা, “ক্যা মৈংনে নহীং কহা থা কি লড়কে পর জ়ুল্ম মত করো, লেকিন তুমনে মেরী এক ন মানী। অব উস কী মৌত কা হিসাব-কিতাব কিযা জা রহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","উন্হেং মালূম নহীং থা কি যূসুফ় হমারী বাতেং সমঝ সকতা হৈ, ক্যোংকি ৱহ মুতরজিম কী মারিফ়ত উনসে বাত করতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","যহ বাতেং সুনকর ৱহ উন্হেং ছোড়কর রোনে লগা। ফির ৱহ সঁভলকর ৱাপস আযা। উসনে শমৌন কো চুনকর উসে উনকে সামনে হী বাঁধ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","যূসুফ় নে হুক্ম দিযা কি মুলাজ়িম উনকী বোরিযাঁ অনাজ সে ভরকর হর এক ভাঈ কে পৈসে উস কী বোরী মেং ৱাপস রখ দেং ঔর উন্হেং সফ়র কে লিএ খানা ভী দেং। উন্হোংনে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ফির যূসুফ় কে ভাঈ অপনে গধোং পর অনাজ লাদকর রৱানা হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","জব ৱহ রাত কে লিএ কিসী জগহ পর ঠহরে তো এক ভাঈ নে অপনে গধে কে লিএ চারা নিকালনে কী গ়রজ় সে অপনী বোরী খোলী তো দেখা কি বোরী কে মুঁহ মেং উসকে পৈসে পড়ে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","উসনে অপনে ভাইযোং সে কহা, “মেরে পৈসে ৱাপস কর দিএ গএ হৈং! ৱহ মেরী বোরী মেং হৈং।” যহ দেখকর উনকে হোশ উড় গএ। কাঁপতে হুএ ৱহ এক দূসরে কো দেখনে ঔর কহনে লগে, “যহ ক্যা হৈ জো অল্লাহ নে হমারে সাথ কিযা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","মুল্কে-কনান মেং অপনে বাপ কে পাস পহুঁচকর উন্হোংনে উসে সব কুছ সুনাযা জো উনকে সাথ হুআ থা। উন্হোংনে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“উস মুল্ক কে মালিক নে বড়ী সখ়্তী সে হমারে সাথ বাত কী। উসনে হমেং জাসূস ক়রার দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","লেকিন হমনে উসসে কহা, ‘হম জাসূস নহীং বল্কি শরীফ় লোগ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","হম বারহ ভাঈ হৈং, এক হী বাপ কে বেটে। এক তো মর গযা জবকি সবসে ছোটা ভাঈ ইস ৱক়্ত কনান মেং বাপ কে পাস হৈ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ফির উস মুল্ক কে মালিক নে হমসে কহা, ‘ইসসে মুঝে পতা চলেগা কি তুম শরীফ় লোগ হো কি এক ভাঈ কো মেরে পাস ছোড় দো ঔর অপনে ভূকে ঘরৱালোং কে লিএ খ়ুরাক লেকর চলে জাও। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","লেকিন অপনে সবসে ছোটে ভাঈ কো মেরে পাস লে আও তাকি মুঝে মালূম হো জাএ কি তুম জাসূস নহীং বল্কি শরীফ় লোগ হো। ফির মৈং তুমকো তুম্হারা ভাঈ ৱাপস কর দূঁগা ঔর তুম ইস মুল্ক মেং আজ়াদী সে তিজারত কর সকোগে’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","উন্হোংনে অপনী বোরিযোং সে অনাজ নিকাল দিযা তো দেখা কি হর এক কী বোরী মেং উসকে পৈসোং কী থৈলী রখী হুঈ হৈ। যহ পৈসে দেখকর ৱহ খ়ুদ ঔর উনকা বাপ ডর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","উনকে বাপ নে উনসে কহা, “তুমনে মুঝে মেরে বচ্চোং সে মহরূম কর দিযা হৈ। যূসুফ় নহীং রহা, শমৌন ভী নহীং রহা ঔর অব তুম বিনযমীন কো ভী মুঝসে ছীননা চাহতে হো। সব কুছ মেরে খ়িলাফ় হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ফির রূবিন বোল উঠা, “অগর মৈং উসে সলামতী সে আপকে পাস ৱাপস ন পহুঁচাঊঁ তো আপ মেরে দো বেটোং কো সজ়াএ-মৌত দে সকতে হৈং। উসে মেরে সুপুর্দ করেং তো মৈং উসে ৱাপস লে আঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","লেকিন যাক়ূব নে কহা, “মেরা বেটা তুম্হারে সাথ জানে কা নহীং। ক্যোংকি উসকা ভাঈ মর গযা হৈ ঔর ৱহ অকেলা হী রহ গযা হৈ। অগর উসকো রাস্তে মেং জানী নুক়সান পহুঁচে তো তুম মুঝ বূঢ়ে কো গ়ম কে মারে পাতাল মেং পহুঁচাওগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","কাল নে জ়োর পকড়া। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","জব মিসর সে লাযা গযা অনাজ খ়ত্ম হো গযা তো যাক়ূব নে কহা, “অব ৱাপস জাকর হমারে লিএ কুছ ঔর গ়ল্লা খ়রীদ লাও।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","লেকিন যহূদাহ নে কহা, “উস মর্দ নে সখ়্তী সে কহা থা, ‘তুম সির্ফ় ইস সূরত মেং মেরে পাস আ সকতে হো কি তুম্হারা ভাঈ সাথ হো।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","অগর আপ হমারে ভাঈ কো সাথ ভেজেং তো ফির হম জাকর আপকে লিএ গ়ল্লা খ়রীদেংগে ");
INSERT INTO urdgvb_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ৱরনা নহীং। ক্যোংকি উস আদমী নে কহা থা কি হম সির্ফ় ইস সূরত মেং উসকে পাস আ সকতে হৈং কি হমারা ভাঈ সাথ হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","যাক়ূব নে কহা, “তুমনে উসে ক্যোং বতাযা কি হমারা এক ঔর ভাঈ ভী হৈ? ইসসে তুমনে মুঝে বড়ী মুসীবত মেং ডাল দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","উন্হোংনে জৱাব দিযা, “ৱহ আদমী হমারে ঔর হমারে খ়ানদান কে বারে মেং পূছতা রহা, ‘ক্যা তুম্হারা বাপ অব তক জ়িংদা হৈ? ক্যা তুম্হারা কোঈ ঔর ভাঈ হৈ?’ ফির হমেং জৱাব দেনা পড়া। হমেং ক্যা পতা থা কি ৱহ হমেং অপনে ভাঈ কো সাথ লানে কো কহেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ফির যহূদাহ নে বাপ সে কহা, “লড়কে কো মেরে সাথ ভেজ দেং তো হম অভী রৱানা হো জাএংগে। ৱরনা আপ, হমারে বচ্চে বল্কি হম সব ভূকোং মর জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","মৈং খ়ুদ উসকা জ়ামিন হূঁগা। আপ মুঝে উস কী জান কা জ়িম্মাদার ঠহরা সকতে হৈং। অগর মৈং উসে সলামতী সে ৱাপস ন পহুঁচাঊঁ তো ফির মৈং জ়িংদগী কে আখ়ির তক ক়ুসূরৱার ঠহরূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","জিতনী দের তক হম ঝিজকতে রহে হৈং উতনী দের মেং তো হম দো দফ়া মিসর জাকর ৱাপস আ সকতে থে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","তব উনকে বাপ ইসরাঈল নে কহা, “অগর ঔর কোঈ সূরত নহীং তো ইস মুল্ক কী বেহতরীন পৈদাৱার মেং সে কুছ তোহ্ফ়ে কে তৌর পর লেকর উস আদমী কো দে দো যানী কুছ বলসান, শহদ, লাদন, মুর, পিস্তা ঔর বাদাম। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","অপনে সাথ দুগনী রক়ম লেকর জাও, ক্যোংকি তুম্হেং ৱহ পৈসে ৱাপস করনে হৈং জো তুম্হারী বোরিযোং মেং রখে গএ থে। শাযদ কিসী সে গ়লতী হুঈ হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","অপনে ভাঈ কো লেকর সীধে ৱাপস পহুঁচনা। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","অল্লাহ ক়াদিরে-মুতলক় করে কি যহ আদমী তুম পর রহম করকে বিনযমীন ঔর তুম্হারে দূসরে ভাঈ কো ৱাপস ভেজে। জহাঁ তক মেরা তাল্লুক় হৈ, অগর মুঝে অপনে বচ্চোং সে মহরূম হোনা হৈ তো ঐসা হী হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","চুনাঁচে ৱহ তোহ্ফ়ে, দুগনী রক়ম ঔর বিনযমীন কো সাথ লেকর চল পড়ে। মিসর পহুঁচকর ৱহ যূসুফ় কে সামনে হাজ়ির হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","জব যূসুফ় নে বিনযমীন কো উনকে সাথ দেখা তো উসনে অপনে ঘর পর মুক়র্রর মুলাজ়িম সে কহা, “ইন আদমিযোং কো মেরে ঘর লে জাও তাকি ৱহ দোপহর কা খানা মেরে সাথ খাএঁ। জানৱর কো জ়বহ করকে খানা তৈযার করো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","মুলাজ়িম নে ঐসা হী কিযা ঔর ভাইযোং কো যূসুফ় কে ঘর লে গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","জব উন্হেং উসকে ঘর পহুঁচাযা জা রহা থা তো ৱহ ডরকর সোচনে লগে, “হমেং উন পৈসোং কে সবব সে যহাঁ লাযা জা রহা হৈ জো পহলী দফ়া হমারী বোরিযোং মেং ৱাপস কিএ গএ থে। ৱহ হম পর অচানক হমলা করকে হমারে গধে ছীন লেংগে ঔর হমেং গ়ুলাম বনা লেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ইসলিএ ঘর কে দরৱাজ়ে পর পহুঁচকর উন্হোংনে ঘর পর মুক়র্রর মুলাজ়িম সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“জনাবে-আলী, হমারী বাত সুন লীজিএ। ইসসে পহলে হম অনাজ খ়রীদনে কে লিএ যহাঁ আএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","লেকিন জব হম যহাঁ সে রৱানা হোকর রাস্তে মেং রাত কে লিএ ঠহরে তো হমনে অপনী বোরিযাঁ খোলকর দেখা কি হর বোরী কে মুঁহ মেং হমারে পৈসোং কী পূরী রক়ম পড়ী হৈ। হম যহ পৈসে ৱাপস লে আএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","নীজ়, হম মজ়ীদ খ়ুরাক খ়রীদনে কে লিএ ঔর পৈসে লে আএ হৈং। খ়ুদা জানে কিসনে হমারে যহ পৈসে হমারী বোরিযোং মেং রখ দিএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","মুলাজ়িম নে কহা, “ফ়িকর ন করেং। মত ডরেং। আপকে ঔর আপকে বাপ কে খ়ুদা নে আপকে লিএ আপকী বোরিযোং মেং যহ খ়জ়ানা রখা হোগা। বহরহাল মুঝে আপকে পৈসে মিল গএ হৈং।” মুলাজ়িম শমৌন কো উনকে পাস বাহর লে আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ফির উসনে ভাইযোং কো যূসুফ় কে ঘর মেং লে জাকর উন্হেং পাঁৱ ধোনে কে লিএ পানী ঔর গধোং কো চারা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","উন্হোংনে অপনে তোহ্ফ়ে তৈযার রখে, ক্যোংকি উন্হেং বতাযা গযা, “যূসুফ় দোপহর কা খানা আপকে সাথ হী খাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","জব যূসুফ় ঘর পহুঁচা তো ৱহ অপনে তোহ্ফ়ে লেকর উসকে সামনে আএ ঔর মুঁহ কে বল ঝুক গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","উসনে উনসে খ়ৈরিযত দরিযাফ়্ত কী ঔর ফির কহা, “তুমনে অপনে বূঢ়ে বাপ কা জ়িক্র কিযা। ক্যা ৱহ ঠীক হৈং? ক্যা ৱহ অব তক জ়িংদা হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","উন্হোংনে জৱাব দিযা, “জী, আপকে খ়াদিম হমারে বাপ অব তক জ়িংদা হৈং।” ৱহ দুবারা মুঁহ কে বল ঝুক গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","জব যূসুফ় নে অপনে সগে ভাঈ বিনযমীন কো দেখা তো উসনে কহা, “ক্যা যহ তুম্হারা সবসে ছোটা ভাঈ হৈ জিসকা তুমনে জ়িক্র কিযা থা? বেটা, অল্লাহ কী নজ়রে-করম তুম পর হো।” ");
INSERT INTO urdgvb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","যূসুফ় অপনে ভাঈ কো দেখকর ইতনা মুতঅস্সির হুআ কি ৱহ রোনে কো থা, ইসলিএ ৱহ জল্দী সে ৱহাঁ সে নিকলকর অপনে সোনে কে কমরে মেং গযা ঔর রো পড়া। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ফির ৱহ অপনা মুঁহ ধোকর ৱাপস আযা। অপনে আপ পর ক়াবূ পাকর উসনে হুক্ম দিযা কি নৌকর খানা লে আএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","নৌকরোং নে যূসুফ় কে লিএ খানে কা অলগ ইংতজ়াম কিযা ঔর ভাইযোং কে লিএ অলগ। মিসরিযোং কে লিএ ভী খানে কা অলগ ইংতজ়াম থা, ক্যোংকি ইবরানিযোং কে সাথ খানা খানা উনকী নজ়র মেং ক়াবিলে-নফ়রত থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ভাইযোং কো উনকী উম্র কী তরতীব কে মুতাবিক় যূসুফ় কে সামনে বিঠাযা গযা। যহ দেখকর ভাঈ নিহাযত হৈরান হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","নৌকরোং নে উন্হেং যূসুফ় কী মেজ় পর সে খানা লেকর খিলাযা। লেকিন বিনযমীন কো দূসরোং কী নিসবত পাঁচ গুনা জ়্যাদা মিলা। যোং উন্হোংনে যূসুফ় কে সাথ জী ভরকর খাযা ঔর পিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","যূসুফ় নে ঘর পর মুক়র্রর মুলাজ়িম কো হুক্ম দিযা, “উন মর্দোং কী বোরিযাঁ খ়ুরাক সে ইতনী ভর দেনা জিতনী ৱহ উঠাকর লে জা সকেং। হর এক কে পৈসে উস কী অপনী বোরী কে মুঁহ মেং রখ দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","সবসে ছোটে ভাঈ কী বোরী মেং ন সির্ফ় পৈসে বল্কি মেরে চাঁদী কে প্যালে কো ভী রখ দেনা।” মুলাজ়িম নে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","অগলী সুবহ জব পৌ ফটনে লগী তো ভাইযোং কো উনকে গধোং সমেত রুখ়সত কর দিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ৱহ অভী শহর সে নিকলকর দূর নহীং গএ থে কি যূসুফ় নে অপনে ঘর পর মুক়র্রর মুলাজ়িম সে কহা, “জল্দী করো। উন আদমিযোং কা তাক়্ক়ুব করো। উনকে পাস পহুঁচকর যহ পূছনা, ‘আপনে হমারী ভলাঈ কে জৱাব মেং গ়লত কাম ক্যোং কিযা হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","আপনে মেরে মালিক কা চাঁদী কা প্যালা ক্যোং চুরাযা হৈ? উসসে ৱহ ন সির্ফ় পীতে হৈং বল্কি উসে গ়ৈবদানী কে লিএ ভী ইস্তেমাল করতে হৈং। আপ এক নিহাযত সংগীন জুর্ম কে মুরতকিব হুএ হৈং’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","জব মুলাজ়িম ভাইযোং কে পাস পহুঁচা তো উসনে উনসে যহী বাতেং কীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","জৱাব মেং উন্হোংনে কহা, “হমারে মালিক ঐসী বাতেং ক্যোং করতে হৈং? কভী নহীং হো সকতা কি আপকে খ়াদিম ঐসা করেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","আপ তো জানতে হৈং কি হম মুল্কে-কনান সে ৱহ পৈসে ৱাপস লে আএ জো হমারী বোরিযোং মেং থে। তো ফির হম ক্যোং আপকে মালিক কে ঘর সে চাঁদী যা সোনা চুরাএঁগে? ");
INSERT INTO urdgvb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","অগর ৱহ আপকে খ়াদিমোং মেং সে কিসী কে পাস মিল জাএ তো উসে মার ডালা জাএ ঔর বাক়ী সব আপকে গ়ুলাম বনেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","মুলাজ়িম নে কহা, “ঠীক হৈ ঐসা হী হোগা। লেকিন সির্ফ় ৱহী মেরা গ়ুলাম বনেগা জিসনে প্যালা চুরাযা হৈ। বাক়ী সব আজ়াদ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","উন্হোংনে জল্দী সে অপনী বোরিযাঁ উতারকর জ়মীন পর রখ দীং। হর এক নে অপনী বোরী খোল দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","মুলাজ়িম বোরিযোং কী তলাশী লেনে লগা। ৱহ বড়ে ভাঈ সে শুরূ করকে আখ়িরকার সবসে ছোটে ভাঈ তক পহুঁচ গযা। ঔর ৱহাঁ বিনযমীন কী বোরী মেং সে প্যালা নিকলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ভাইযোং নে যহ দেখকর পরেশানী মেং অপনে লিবাস ফাড় লিএ। ৱহ অপনে গধোং কো দুবারা লাদকর শহর ৱাপস আ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","জব যহূদাহ ঔর উসকে ভাঈ যূসুফ় কে ঘর পহুঁচে তো ৱহ অভী ৱহীং থা। ৱহ উসকে সামনে মুঁহ কে বল গির গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","যূসুফ় নে কহা, “যহ তুমনে ক্যা কিযা হৈ? ক্যা তুম নহীং জানতে কি মুঝ জৈসা আদমী গ়ৈব কা ইল্ম রখতা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","যহূদাহ নে কহা, “জনাবে-আলী, হম ক্যা কহেং? অব হম অপনে দিফ়া মেং ক্যা কহেং? অল্লাহ হী নে হমেং ক়ুসূরৱার ঠহরাযা হৈ। অব হম সব আপকে গ়ুলাম হৈং, ন সির্ফ় ৱহ জিসকে পাস সে প্যালা মিল গযা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","যূসুফ় নে কহা, “অল্লাহ ন করে কি মৈং ঐসা করূঁ, বল্কি সির্ফ় ৱহী মেরা গ়ুলাম হোগা জিসকে পাস প্যালা থা। বাক়ী সব সলামতী সে অপনে বাপ কে পাস ৱাপস চলে জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","লেকিন যহূদাহ নে যূসুফ় কে ক়রীব আকর কহা, “মেরে মালিক, মেহরবানী করকে অপনে বংদে কো এক বাত করনে কী ইজাজ়ত দেং। মুঝ পর গ়ুস্সা ন করেং অগরচে আপ মিসর কে বাদশাহ জৈসে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","জনাবে-আলী, আপনে হমসে পূছা, ‘ক্যা তুম্হারা বাপ যা কোঈ ঔর ভাঈ হৈ?’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","হমনে জৱাব দিযা, ‘হমারা বাপ হৈ। ৱহ বূঢ়া হৈ। হমারা এক ছোটা ভাঈ ভী হৈ জো উস ৱক়্ত পৈদা হুআ জব হমারা বাপ উম্ররসীদা থা। উস লড়কে কা ভাঈ মর চুকা হৈ। উস কী মাঁ কে সির্ফ় যহ দো বেটে পৈদা হুএ। অব ৱহ অকেলা হী রহ গযা হৈ। উসকা বাপ উসে শিদ্দত সে প্যার করতা হৈ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","জনাবে-আলী, আপনে হমেং বতাযা, ‘উসে যহাঁ লে আও তাকি মৈং খ়ুদ উসে দেখ সকূঁ।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","হমনে জৱাব দিযা, ‘যহ লড়কা অপনে বাপ কো ছোড় নহীং সকতা, ৱরনা উসকা বাপ মর জাএগা।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ফির আপনে কহা, ‘তুম সির্ফ় ইস সূরত মেং মেরে পাস আ সকোগে কি তুম্হারা সবসে ছোটা ভাঈ তুম্হারে সাথ হো।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","জব হম অপনে বাপ কে পাস ৱাপস পহুঁচে তো হমনে উন্হেং সব কুছ বতাযা জো আপনে কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ফির উন্হোংনে হমসে কহা, ‘মিসর লৌটকর কুছ গ়ল্লা খ়রীদ লাও।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","হমনে জৱাব দিযা, ‘হম জা নহীং সকতে। হম সির্ফ় ইস সূরত মেং উস মর্দ কে পাস জা সকতে হৈং কি হমারা সবসে ছোটা ভাঈ সাথ হো। হম তব হী জা সকতে হৈং জব ৱহ ভী হমারে সাথ চলে।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","হমারে বাপ নে হমসে কহা, ‘তুম জানতে হো কি মেরী বীৱী রাখ়িল সে মেরে দো বেটে পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","পহলা মুঝে ছোড় চুকা হৈ। কিসী জংগলী জানৱর নে উসে ফাড় খাযা হোগা, ক্যোংকি উসী ৱক়্ত সে মৈংনে উসে নহীং দেখা। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","অগর ইসকো ভী মুঝসে লে জানে কী ৱজহ সে জানী নুক়সান পহুঁচে তো তুম মুঝ বূঢ়ে কো গ়ম কে মারে পাতাল মেং পহুঁচাওগে’।” ");
INSERT INTO urdgvb_vpl VALUES ("GN44_30‏","002_44_30‏","GEN","44","30‏","31","যহূদাহ নে অপনী বাত জারী রখী, “জনাবে-আলী, অব অগর মৈং অপনে বাপ কে পাস জাঊঁ ঔর ৱহ দেখেং কি লড়কা মেরে সাথ নহীং হৈ তো ৱহ দম তোড় দেংগে। উনকী জ়িংদগী ইস ক়দর লড়কে কী জ়িংদগী পর মুনহসির হৈ ঔর ৱহ ইতনে বূঢ়ে হৈং কি হম ঐসী হরকত সে উন্হেং ক়ব্র তক পহুঁচা দেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ন সির্ফ় যহ বল্কি মৈংনে বাপ সে কহা, ‘মৈং খ়ুদ ইসকা জ়ামিন হূঁগা। অগর মৈং ইসে সলামতী সে ৱাপস ন পহুঁচাঊঁ তো ফির মৈং জ়িংদগী কে আখ়ির তক ক়ুসূরৱার ঠহরূঁগা।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","অব অপনে খ়াদিম কী গুজ়ারিশ সুনেং। মৈং যহাঁ রহকর ইস লড়কে কী জগহ গ়ুলাম বন জাতা হূঁ, ঔর ৱহ দূসরে ভাইযোং কে সাথ ৱাপস চলা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","অগর লড়কা মেরে সাথ ন হুআ তো মৈং কিস তরহ অপনে বাপ কো মুঁহ দিখা সকতা হূঁ? মৈং বরদাশ্ত নহীং কর সকূঁগা কি ৱহ ইস মুসীবত মেং মুব্তলা হো জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","যহ সুনকর যূসুফ় অপনে আপ পর ক়াবূ ন রখ সকা। উসনে ঊঁচী আৱাজ় সে হুক্ম দিযা কি তমাম মুলাজ়িম কমরে সে নিকল জাএঁ। কোঈ ঔর শখ়্স কমরে মেং নহীং থা জব যূসুফ় নে অপনে ভাইযোং কো বতাযা কি ৱহ কৌন হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ৱহ ইতনে জ়োর সে রো পড়া কি মিসরিযোং নে উস কী আৱাজ় সুনী ঔর ফ়িরৌন কে ঘরানে কো পতা চল গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","যূসুফ় নে অপনে ভাইযোং সে কহা, “মৈং যূসুফ় হূঁ। ক্যা মেরা বাপ অব তক জ়িংদা হৈ?” লেকিন উসকে ভাঈ যহ সুনকর ইতনে ঘবরা গএ কি ৱহ জৱাব ন দে সকে। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ফির যূসুফ় নে কহা, “মেরে ক়রীব আও।” ৱহ ক়রীব আএ তো উসনে কহা, “মৈং তুম্হারা ভাঈ যূসুফ় হূঁ জিসে তুমনে বোলকর মিসর ভিজৱাযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","অব মেরী বাত সুনো। ন ঘবরাও ঔর ন অপনে আপকো ইলজ়াম দো কি হমনে যূসুফ় কো বেচ দিযা। অসল মেং অল্লাহ নে খ়ুদ মুঝে তুম্হারে আগে যহাঁ ভেজ দিযা তাকি হম সব বচে রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","যহ কাল কা দূসরা সাল হৈ। পাঁচ ঔর সাল কে দৌরান ন হল চলেগা, ন ফ়সল কটেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","অল্লাহ নে মুঝে তুম্হারে আগে ভেজা তাকি দুনিযা মেং তুম্হারা এক বচা-খুচা হিস্সা মহফ়ূজ় রহে ঔর তুম্হারী জান এক বড়ী মখ়লসী কী মারিফ়ত ছূট জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","চুনাঁচে তুমনে মুঝে যহাঁ নহীং ভেজা বল্কি অল্লাহ নে। উসনে মুঝে ফ়িরৌন কা বাপ, উসকে পূরে ঘরানে কা মালিক ঔর মিসর কা হাকিম বনা দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","অব জল্দী সে মেরে বাপ কে পাস ৱাপস জাকর উনসে কহো, ‘আপকা বেটা যূসুফ় আপকো ইত্তলা দেতা হৈ কি অল্লাহ নে মুঝে মিসর কা মালিক বনা দিযা হৈ। মেরে পাস আ জাএঁ, দের ন করেং। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","আপ জুশন কে ইলাক়ে মেং রহ সকতে হৈং। ৱহাঁ আপ মেরে ক়রীব হোংগে, আপ, আপকী আলো-ঔলাদ, গায-বৈল, ভেড়-বকরিযাঁ ঔর জো কুছ ভী আপকা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ৱহাঁ মৈং আপকী জ়রূরিযাত পূরী করূঁগা, ক্যোংকি কাল কো অভী পাঁচ সাল ঔর লগেংগে। ৱরনা আপ, আপকে ঘরৱালে ঔর জো ভী আপকে হৈং বদহাল হো জাএংগে।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","তুম খ়ুদ ঔর মেরা ভাঈ বিনযমীন দেখ সকতে হো কি মৈং যূসুফ় হী হূঁ জো তুম্হারে সাথ বাত কর রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","মেরে বাপ কো মিসর মেং মেরে অসরো-রসূখ় কে বারে মেং ইত্তলা দো। উন্হেং সব কুছ বতাও জো তুমনে দেখা হৈ। ফির জল্দ হী মেরে বাপ কো যহাঁ লে আও।” ");
INSERT INTO urdgvb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","যহ কহকর ৱহ অপনে ভাঈ বিনযমীন কো গলে লগাকর রো পড়া। বিনযমীন ভী উসকে গলে লগকর রোনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ফির যূসুফ় নে রোতে হুএ অপনে হর এক ভাঈ কো বোসা দিযা। ইসকে বাদ উসকে ভাঈ উসকে সাথ বাতেং করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","জব যহ খ়বর বাদশাহ কে মহল তক পহুঁচী কি যূসুফ় কে ভাঈ আএ হৈং তো ফ়িরৌন ঔর উসকে তমাম অফ়সরান খ়ুশ হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","উসনে যূসুফ় সে কহা, “অপনে ভাইযোং কো বতা কি অপনে জানৱরোং পর গ়ল্লা লাদকর মুল্কে-কনান ৱাপস চলে জাও। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ৱহাঁ অপনে বাপ ঔর খ়ানদানোং কো লেকর মেরে পাস আ জাও। মৈং তুমকো মিসর কী সবসে অচ্ছী জ়মীন দে দূঁগা, ঔর তুম ইস মুল্ক কী বেহতরীন পৈদাৱার খা সকোগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","উন্হেং যহ হিদাযত ভী দে কি অপনে বাল-বচ্চোং কে লিএ মিসর সে গাড়িযাঁ লে জাও ঔর অপনে বাপ কো ভী বিঠাকর যহাঁ লে আও। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","অপনে মাল কী জ়্যাদা ফ়িকর ন করো, ক্যোংকি তুম্হেং মুল্কে-মিসর কা বেহতরীন মাল মিলেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","যূসুফ় কে ভাইযোং নে ঐসা হী কিযা। যূসুফ় নে উন্হেং বাদশাহ কে হুক্ম কে মুতাবিক় গাড়িযাঁ ঔর সফ়র কে লিএ খ়ুরাক দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","উসনে হর এক ভাঈ কো কপড়োং কা এক জোড়া ভী দিযা। লেকিন বিনযমীন কো উসনে চাঁদী কে 300 সিক্কে ঔর পাঁচ জোড়ে দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","উসনে অপনে বাপ কো দস গধে ভিজৱা দিএ জো মিসর কে বেহতরীন মাল সে লদে হুএ থে ঔর দস গধিযাঁ জো অনাজ, রোটী ঔর বাপ কে সফ়র কে লিএ খানে সে লদী হুঈ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","যোং উসনে অপনে ভাইযোং কো রুখ়সত করকে কহা, “রাস্তে মেং ঝগড়া ন করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ৱহ মিসর সে রৱানা হোকর মুল্কে-কনান মেং অপনে বাপ কে পাস পহুঁচে। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","উন্হোংনে উসসে কহা, “যূসুফ় জ়িংদা হৈ! ৱহ পূরে মিসর কা হাকিম হৈ।” লেকিন যাক়ূব হক্কা-বক্কা রহ গযা, ক্যোংকি উসে যক়ীন ন আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","তাহম উন্হোংনে উসে সব কুছ বতাযা জো যূসুফ় নে উনসে কহা থা, ঔর উসনে খ়ুদ ৱহ গাড়িযাঁ দেখীং জো যূসুফ় নে উসে মিসর লে জানে কে লিএ ভিজৱা দী থীং। ফির যাক়ূব কী জান মেং জান আ গঈ, ");
INSERT INTO urdgvb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ঔর উসনে কহা, “মেরা বেটা যূসুফ় জ়িংদা হৈ! যহী কাফ়ী হৈ। মরনে সে পহলে মৈং জাকর উসসে মিলূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","যাক়ূব সব কুছ লেকর রৱানা হুআ ঔর বৈর-সবা পহুঁচা। ৱহাঁ উসনে অপনে বাপ ইসহাক় কে খ়ুদা কে হুজ়ূর ক়ুরবানিযাঁ চঢ়াঈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","রাত কো অল্লাহ রোযা মেং উসসে হমকলাম হুআ। উসনে কহা, “যাক়ূব, যাক়ূব!” যাক়ূব নে জৱাব দিযা, “জী, মৈং হাজ়ির হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","অল্লাহ নে কহা, “মৈং অল্লাহ হূঁ, তেরে বাপ ইসহাক় কা খ়ুদা। মিসর জানে সে মত ডর, ক্যোংকি ৱহাঁ মৈং তুঝসে এক বড়ী ক়ৌম বনাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","মৈং তেরে সাথ মিসর জাঊঁগা ঔর তুঝে ইস মুল্ক মেং ৱাপস ভী লে আঊঁগা। জব তূ মরেগা তো যূসুফ় খ়ুদ তেরী আঁখেং বংদ করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ইসকে বাদ যাক়ূব বৈর-সবা সে রৱানা হুআ। উসকে বেটোং নে উসে ঔর অপনে বাল-বচ্চোং কো উন গাড়িযোং মেং বিঠা দিযা জো মিসর কে বাদশাহ নে ভিজৱাঈ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","যোং যাক়ূব ঔর উস কী তমাম ঔলাদ অপনে মৱেশী ঔর কনান মেং হাসিল কিযা হুআ মাল লেকর মিসর চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","যাক়ূব কে বেটে-বেটিযাঁ, পোতে-পোতিযাঁ ঔর বাক়ী ঔলাদ সব সাথ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ইসরাঈল কী ঔলাদ কে নাম জো মিসর চলী গঈ যহ হৈং : যাক়ূব কে পহলৌঠে রূবিন ");
INSERT INTO urdgvb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","কে বেটে হনূক, ফ়ল্লূ, হসরোন ঔর করমী থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","শমৌন কে বেটে যমুএল, যমীন, উহদ, যকীন, সুহর ঔর সাঊল থে (সাঊল কনানী ঔরত কা বচ্চা থা)। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","লাৱী কে বেটে জৈরসোন, ক়িহাত ঔর মিরারী থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","যহূদাহ কে বেটে এর, ওনান, সেলা, ফ়ারস ঔর জ়ারহ থে (এর ঔর ওনান কনান মেং মর চুকে থে)। ফ়ারস কে দো বেটে হসরোন ঔর হমূল থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ইশকার কে বেটে তোলা, ফ়ুৱ্ৱা, যোব ঔর সিমরোন থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","জ়বূলূন কে বেটে সরদ, ঐলোন ঔর যহলিযেল থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ইন বেটোং কী মাঁ লিযাহ থী, ঔর ৱহ মসোপুতামিযা মেং পৈদা হুএ। ইনকে অলাৱা দীনা উস কী বেটী থী। কুল 33 মর্দ লিযাহ কী ঔলাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","জদ কে বেটে সিফ়িযান, হজ্জী, সূনী, ইসবূন, এরী, অরূদী ঔর অরেলী থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","আশর কে বেটে যিমনা, ইসৱাহ, ইসৱী ঔর বরিযা থে। আশর কী বেটী সিরহ থী, ঔর বরিযা কে দো বেটে থে, হিবর ঔর মলকিযেল। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","কুল 16 অফ়রাদ জ়িলফ়া কী ঔলাদ থে জিসে লাবন নে অপনী বেটী লিযাহ কো দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","রাখ়িল কে বেটে যূসুফ় ঔর বিনযমীন থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","যূসুফ় কে দো বেটে মনস্সী ঔর ইফ়রাঈম মিসর মেং পৈদা হুএ। উনকী মাঁ ওন কে পুজারী ফ়োতীফ়িরা কী বেটী আসনত থী। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","বিনযমীন কে বেটে বালা, বকর, অশবেল, জীরা, নামান, ইখ়ী, রোস, মুফ়্ফ়ীম, হুফ়্ফ়ীম ঔর অর্দ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","কুল 14 মর্দ রাখ়িল কী ঔলাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","দান কা বেটা হুশীম থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","নফ়তালী কে বেটে যহসিযেল, জূনী, যিসর ঔর সিল্লীম থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","কুল 7 মর্দ বিলহাহ কী ঔলাদ থে জিসে লাবন নে অপনী বেটী রাখ়িল কো দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","যাক়ূব কী ঔলাদ কে 66 অফ়রাদ উসকে সাথ মিসর চলে গএ। ইস তাদাদ মেং বেটোং কী বীৱিযাঁ শামিল নহীং থীং। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","জব হম যাক়ূব, যূসুফ় ঔর উসকে দো বেটে ইনমেং শামিল করতে হৈং তো যাক়ূব কে ঘরানে কে 70 অফ়রাদ মিসর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","যাক়ূব নে যহূদাহ কো অপনে আগে যূসুফ় কে পাস ভেজা তাকি ৱহ জুশন মেং উনসে মিলে। জব ৱহ ৱহাঁ পহুঁচে ");
INSERT INTO urdgvb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","তো যূসুফ় অপনে রথ পর সৱার হোকর অপনে বাপ সে মিলনে কে লিএ জুশন গযা। উসে দেখকর ৱহ উসকে গলে লগকর কাফ়ী দের রোতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","যাক়ূব নে যূসুফ় সে কহা, “অব মৈং মরনে কে লিএ তৈযার হূঁ, ক্যোংকি মৈংনে খ়ুদ দেখা হৈ কি তূ জ়িংদা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ফির যূসুফ় নে অপনে ভাইযোং ঔর অপনে বাপ কে খ়ানদান কে বাক়ী অফ়রাদ সে কহা, “জ়রূরী হৈ কি মৈং জাকর বাদশাহ কো ইত্তলা দূঁ কি মেরে ভাঈ ঔর মেরে বাপ কা পূরা খ়ানদান জো কনান কে রহনেৱালে হৈং মেরে পাস আ গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","মৈং উসসে কহূঁগা, ‘যহ আদমী ভেড়-বকরিযোং কে চরৱাহে হৈং। ৱহ মৱেশী পালতে হৈং, ইসলিএ অপনী ভেড়-বকরিযাঁ, গায-বৈল ঔর বাক়ী সারা মাল অপনে সাথ লে আএ হৈং।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","বাদশাহ তুম্হেং বুলাকর পূছেগা কি তুম ক্যা কাম করতে হো? ");
INSERT INTO urdgvb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ফির তুমকো জৱাব দেনা হৈ, ‘আপকে খ়াদিম বচপন সে মৱেশী পালতে আএ হৈং। যহ হমারে বাপদাদা কা পেশা থা ঔর হমারা ভী হৈ।’ অগর তুম যহ কহো তো তুম্হেং জুশন মেং রহনে কী ইজাজ়ত মিলেগী। ক্যোংকি ভেড়-বকরিযোং কে চরৱাহে মিসরিযোং কী নজ়র মেং ক়াবিলে-নফ়রত হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","যূসুফ় ফ়িরৌন কে পাস গযা ঔর উসে ইত্তলা দেকর কহা, “মেরা বাপ ঔর ভাঈ অপনী ভেড়-বকরিযোং, গায-বৈলোং ঔর সারে মাল সমেত মুল্কে-কনান সে আকর জুশন মেং ঠহরে হুএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","উসনে অপনে ভাইযোং মেং সে পাঁচ কো চুনকর ফ়িরৌন কে সামনে পেশ কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ফ়িরৌন নে ভাইযোং সে পূছা, “তুম ক্যা কাম করতে হো?” উন্হোংনে জৱাব দিযা, “আপকে খ়াদিম ভেড়-বকরিযোং কে চরৱাহে হৈং। যহ হমারে বাপদাদা কা পেশা থা ঔর হমারা ভী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","হম যহাঁ আএ হৈং তাকি কুছ দের অজনবী কী হৈসিযত সে আপকে পাস ঠহরেং, ক্যোংকি কাল নে কনান মেং বহুত জ়োর পকড়া হৈ। ৱহাঁ আপকে খ়াদিমোং কে জানৱরোং কে লিএ চরাগাহেং খ়ত্ম হো গঈ হৈং। ইসলিএ হমেং জুশন মেং রহনে কী ইজাজ়ত দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","বাদশাহ নে যূসুফ় সে কহা, “তেরা বাপ ঔর ভাঈ তেরে পাস আ গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","মুল্কে-মিসর তেরে সামনে খুলা হৈ। উন্হেং বেহতরীন জগহ পর আবাদ কর। ৱহ জুশন মেং রহেং। ঔর অগর উনমেং সে কুছ হৈং জো খ়াস ক়াবিলিযত রখতে হৈং তো উন্হেং মেরে মৱেশিযোং কী নিগহদাশত পর রখ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ফির যূসুফ় অপনে বাপ যাক়ূব কো লে আযা ঔর ফ়িরৌন কে সামনে পেশ কিযা। যাক়ূব নে বাদশাহ কো বরকত দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","বাদশাহ নে উসসে পূছা, “তুম্হারী উম্র ক্যা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","যাক়ূব নে জৱাব দিযা, “মৈং 130 সাল সে ইস দুনিযা কা মেহমান হূঁ। মেরী জ়িংদগী মুখ়তসর ঔর তকলীফ়দেহ থী, ঔর মেরে বাপদাদা মুঝসে জ়্যাদা উম্ররসীদা হুএ থে জব ৱহ ইস দুনিযা কে মেহমান থে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","যহ কহকর যাক়ূব ফ়িরৌন কো দুবারা বরকত দেকর চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ফির যূসুফ় নে অপনে বাপ ঔর ভাইযোং কো মিসর মেং আবাদ কিযা। উসনে উন্হেং রামসীস কে ইলাক়ে মেং বেহতরীন জ়মীন দী জিস তরহ বাদশাহ নে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","যূসুফ় অপনে বাপ কে পূরে ঘরানে কো খ়ুরাক মুহৈযা করতা রহা। হর খ়ানদান কো উসকে বচ্চোং কী তাদাদ কে মুতাবিক় খ়ুরাক মিলতী রহী। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","কাল ইতনা সখ়্ত থা কি কহীং ভী রোটী নহীং মিলতী থী। মিসর ঔর কনান মেং লোগ নিঢাল হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","মিসর ঔর কনান কে তমাম পৈসে অনাজ খ়রীদনে কে লিএ সর্ফ় হো গএ। যূসুফ় উন্হেং জমা করকে ফ়িরৌন কে মহল মেং লে আযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","জব মিসর ঔর কনান কে পৈসে খ়ত্ম হো গএ তো মিসরিযোং নে যূসুফ় কে পাস আকর কহা, “হমেং রোটী দেং! হম আপকে সামনে ক্যোং মরেং? হমারে পৈসে খ়ত্ম হো গএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","যূসুফ় নে জৱাব দিযা, “অগর আপকে পৈসে খ়ত্ম হৈং তো মুঝে অপনে মৱেশী দেং। মৈং উনকে এৱজ় রোটী দেতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","চুনাঁচে ৱহ অপনে ঘোড়ে, ভেড়-বকরিযাঁ, গায-বৈল ঔর গধে যূসুফ় কে পাস লে আএ। ইনকে এৱজ় উসনে উন্হেং খ়ুরাক দী। উস সাল উসনে উন্হেং উনকে তমাম মৱেশিযোং কে এৱজ় খ়ুরাক মুহৈযা কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","অগলে সাল ৱহ দুবারা উসকে পাস আএ। উন্হোংনে কহা, “জনাবে-আলী, হম যহ বাত আপসে নহীং ছুপা সকতে কি অব হম সির্ফ় অপনে আপ ঔর অপনী জ়মীন কো আপকো দে সকতে হৈং। হমারে পৈসে তো খ়ত্ম হৈং ঔর আপ হমারে মৱেশী ভী লে চুকে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","হম ক্যোং আপকী আঁখোং কে সামনে মর জাএঁ? হমারী জ়মীন ক্যোং তবাহ হো জাএ? হমেং রোটী দেং তো হম ঔর হমারী জ়মীন বাদশাহ কী হোগী। হম ফ়িরৌন কে গ়ুলাম হোংগে। হমেং বীজ দেং তাকি হম জীতে বচেং ঔর জ়মীন তবাহ ন হো জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","চুনাঁচে যূসুফ় নে ফ়িরৌন কে লিএ মিসর কী পূরী জ়মীন খ়রীদ লী। কাল কী সখ়্তী কে সবব সে তমাম মিসরিযোং নে অপনে খেত বেচ দিএ। ইস তরীক়ে সে পূরা মুল্ক ফ়িরৌন কী মিলকিযত মেং আ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","যূসুফ় নে মিসর কে এক সিরে সে দূসরে সিরে তক কে লোগোং কো শহরোং মেং মুংতক়িল কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","সির্ফ় পুজারিযোং কী জ়মীন আজ়াদ রহী। উন্হেং অপনী জ়মীন বেচনে কী জ়রূরত হী নহীং থী, ক্যোংকি উন্হেং ফ়িরৌন সে ইতনা ৱজ়ীফ়া মিলতা থা কি গুজ়ারা হো জাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","যূসুফ় নে লোগোং সে কহা, “গ়ৌর সে সুনেং। আজ মৈংনে আপকো ঔর আপকী জ়মীন কো বাদশাহ কে লিএ খ়রীদ লিযা হৈ। অব যহ বীজ লেকর অপনে খেতোং মেং বোনা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","আপকো ফ়িরৌন কো ফ়সল কা পাঁচৱাঁ হিস্সা দেনা হৈ। বাক়ী পৈদাৱার আপকী হোগী। আপ ইসসে বীজ বো সকতে হৈং, ঔর যহ আপকে ঔর আপকে ঘরানোং ঔর বচ্চোং কে খানে কে লিএ হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","উন্হোংনে জৱাব দিযা, “আপনে হমেং বচাযা হৈ। হমারে মালিক হম পর মেহরবানী করেং তো হম ফ়িরৌন কে গ়ুলাম বনেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ইস তরহ যূসুফ় নে মিসর মেং যহ ক়ানূন নাফ়িজ় কিযা কি হর ফ়সল কা পাঁচৱাঁ হিস্সা বাদশাহ কা হৈ। যহ ক়ানূন আজ তক জারী হৈ। সির্ফ় পুজারিযোং কী জ়মীন বাদশাহ কী মিলকিযত মেং ন আঈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ইসরাঈলী মিসর মেং জুশন কে ইলাক়ে মেং আবাদ হুএ। ৱহাঁ উন্হেং জ়মীন মিলী, ঔর ৱহ ফলে-ফূলে ঔর তাদাদ মেং বহুত বঢ় গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","যাক়ূব 17 সাল মিসর মেং রহা। ৱহ 147 সাল কা থা জব ফ়ৌত হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","জব মরনে কা ৱক়্ত ক়রীব আযা তো উসনে যূসুফ় কো বুলাকর কহা, “মেহরবানী করকে অপনা হাথ মেরী রান কে নীচে রখকর ক়সম খা কি তূ মুঝ পর শফ়ক়ত ঔর ৱফ়াদারী কা ইস তরহ ইজ়হার করেগা কি মুঝে মিসর মেং দফ়ন নহীং করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","জব মৈং মরকর অপনে বাপদাদা সে জা মিলূঁগা তো মুঝে মিসর সে লে জাকর মেরে বাপদাদা কী ক়ব্র মেং দফ়নানা।” যূসুফ় নে জৱাব দিযা, “ঠীক হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","যাক়ূব নে কহা, “ক়সম খা কি তূ ঐসা হী করেগা।” যূসুফ় নে ক়সম খাঈ। তব ইসরাঈল নে অপনে বিস্তর কে সিরহানে পর অল্লাহ কো সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","কুছ দের কে বাদ যূসুফ় কো ইত্তলা দী গঈ কি আপকা বাপ বীমার হৈ। ৱহ অপনে দো বেটোং মনস্সী ঔর ইফ়রাঈম কো সাথ লেকর যাক়ূব সে মিলনে গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","যাক়ূব কো বতাযা গযা, “আপকা বেটা আ গযা হৈ” তো ৱহ অপনে আপকো সঁভালকর অপনে বিস্তর পর বৈঠ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","উসনে যূসুফ় সে কহা, “জব মৈং কনানী শহর লূজ় মেং থা তো অল্লাহ ক়াদিরে-মুতলক় মুঝ পর জ়াহির হুআ। উসনে মুঝে বরকত দেকর ");
INSERT INTO urdgvb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","কহা, ‘মৈং তুঝে ফলনে ফূলনে দূঁগা ঔর তেরী ঔলাদ বঢ়া দূঁগা বল্কি তুঝসে বহুত-সী ক়ৌমেং নিকলনে দূঁগা। ঔর মৈং তেরী ঔলাদ কো যহ মুল্ক হমেশা কে লিএ দে দূঁগা।’ ");
INSERT INTO urdgvb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","অব মেরী বাত সুন। মৈং চাহতা হূঁ কি তেরে বেটে জো মেরে আনে সে পহলে মিসর মেং পৈদা হুএ মেরে বেটে হোং। ইফ়রাঈম ঔর মনস্সী রূবিন ঔর শমৌন কে বরাবর হী মেরে বেটে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","অগর ইনকে বাদ তেরে হাঁ ঔর বেটে পৈদা হো জাএঁ তো ৱহ মেরে বেটে নহীং বল্কি তেরে ঠহরেংগে। জো মীরাস ৱহ পাএঁগে ৱহ উন্হেং ইফ়রাঈম ঔর মনস্সী কী মীরাস মেং সে মিলেগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","মৈং যহ তেরী মাঁ রাখ়িল কে সবব সে কর রহা হূঁ জো মসোপুতামিযা সে ৱাপসী কে ৱক়্ত কনান মেং ইফ়রাতা কে ক়রীব মর গঈ। মৈংনে উসে ৱহীং রাস্তে মেং দফ়ন কিযা” (আজ ইফ়রাতা কো বৈত-লহম কহা জাতা হৈ)। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ফির যাক়ূব নে যূসুফ় কে বেটোং পর নজ়র ডালকর পূছা, “যহ কৌন হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","যূসুফ় নে জৱাব দিযা, “যহ মেরে বেটে হৈং জো অল্লাহ নে মুঝে যহাঁ মিসর মেং দিএ।” যাক়ূব নে কহা, “উন্হেং মেরে ক়রীব লে আ তাকি মৈং উন্হেং বরকত দূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","বূঢ়া হোনে কে সবব সে যাক়ূব কী আঁখেং কমজ়োর থীং। ৱহ অচ্ছী তরহ দেখ নহীং সকতা থা। যূসুফ় অপনে বেটোং কো যাক়ূব কে পাস লে আযা তো উসনে উন্হেং বোসা দেকর গলে লগাযা ");
INSERT INTO urdgvb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ঔর যূসুফ় সে কহা, “মুঝে তৱক়্ক়ো হী নহীং থী কি মৈং কভী তেরা চেহরা দেখূঁগা, ঔর অব অল্লাহ নে মুঝে তেরে বেটোং কো দেখনে কা মৌক়া ভী দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ফির যূসুফ় উন্হেং যাক়ূব কী গোদ মেং সে লেকর খ়ুদ উসকে সামনে মুঁহ কে বল ঝুক গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","যূসুফ় নে ইফ়রাঈম কো যাক়ূব কে বাএঁ হাথ রখা ঔর মনস্সী কো উসকে দাএঁ হাথ। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","লেকিন যাক়ূব নে অপনা দহনা হাথ বাঈং তরফ় বঢ়াকর ইফ়রাঈম কে সর পর রখা অগরচে ৱহ ছোটা থা। ইস তরহ উসনে অপনা বাযাঁ হাথ দাঈং তরফ় বঢ়াকর মনস্সী কে সর পর রখা জো বড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ফির উসনে যূসুফ় কো উসকে বেটোং কী মারিফ়ত বরকত দী, “অল্লাহ জিসকে হুজ়ূর মেরে বাপদাদা ইব্রাহীম ঔর ইসহাক় চলতে রহে ঔর জো শুরূ সে আজ তক মেরা চরৱাহা রহা হৈ ইন্হেং বরকত দে। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","জিস ফ়রিশ্তে নে এৱজ়ানা দেকর মুঝে হর নুক়সান সে বচাযা হৈ ৱহ ইন্হেং বরকত দে। অল্লাহ করে কি ইনমেং মেরা নাম ঔর মেরে বাপদাদা ইব্রাহীম ঔর ইসহাক় কে নাম জীতে রহেং। দুনিযা মেং ইনকী ঔলাদ কী তাদাদ বহুত বঢ় জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","জব যূসুফ় নে দেখা কি বাপ নে অপনা দহনা হাথ ছোটে বেটে ইফ়রাঈম কে সর পর রখা হৈ তো যহ উসে বুরা লগা, ইসলিএ উসনে বাপ কা হাথ পকড়া তাকি উসে ইফ়রাঈম কে সর পর সে উঠাকর মনস্সী কে সর পর রখে। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","উসনে কহা, “অব্বূ, ঐসে নহীং। দূসরা লড়কা বড়া হৈ। উসী পর অপনা দহনা হাথ রখেং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","লেকিন বাপ নে ইনকার করকে কহা, “মুঝে পতা হৈ বেটা, মুঝে পতা হৈ। ৱহ ভী এক বড়ী ক়ৌম বনেগা। ফির ভী উসকা ছোটা ভাঈ উসসে বড়া হোগা ঔর উসসে ক়ৌমোং কী বড়ী তাদাদ নিকলেগী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","উস দিন উসনে দোনোং বেটোং কো বরকত দেকর কহা, “ইসরাঈলী তুম্হারা নাম লেকর বরকত দিযা করেংগে। জব ৱহ বরকত দেংগে তো কহেংগে, ‘অল্লাহ আপকে সাথ ৱৈসা করে জৈসা উসনে ইফ়রাঈম ঔর মনস্সী কে সাথ কিযা হৈ’।” ইস তরহ যাক়ূব নে ইফ়রাঈম কো মনস্সী সে বড়া বনা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","যূসুফ় সে উসনে কহা, “মৈং তো মরনেৱালা হূঁ, লেকিন অল্লাহ তুম্হারে সাথ হোগা ঔর তুম্হেং তুম্হারে বাপদাদা কে মুল্ক মেং ৱাপস লে জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","এক বাত মেং মৈং তুঝে তেরে ভাইযোং পর তরজীহ দেতা হূঁ, মৈং তুঝে কনান মেং ৱহ ক়িতআ দেতা হূঁ জো মৈংনে অপনী তলৱার ঔর কমান সে অমোরিযোং সে ছীনা থা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","যাক়ূব নে অপনে বেটোং কো বুলাকর কহা, “মেরে পাস জমা হো জাও তাকি মৈং তুম্হেং বতাঊঁ কি মুস্তক়বিল মেং তুম্হারে সাথ ক্যা ক্যা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ঐ যাক়ূব কে বেটো, ইকট্ঠে হোকর সুনো, অপনে বাপ ইসরাঈল কী বাতোং পর গ়ৌর করো। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","রূবিন, তুম মেরে পহলৌঠে হো, মেরে জ়োর ঔর মেরী তাক়ত কা পহলা ফল। তুম ইজ়্জ়ত ঔর ক়ুৱ্ৱত কে লিহাজ় সে বরতর হো। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","লেকিন চূঁকি তুম বেকাবূ সৈলাব কী মানিংদ হো ইসলিএ তুম্হারী অৱ্ৱল হৈসিযত জাতী রহে। ক্যোংকি তুমনে মেরী হরম সে হমবিসতর হোকর অপনে বাপ কী বেহুরমতী কী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","শমৌন ঔর লাৱী দোনোং ভাইযোং কী তলৱারেং জ়ুল্মো-তশদ্দুদ কে হথিযার রহে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","মেরী জান ন উনকী মজলিস মেং শামিল ঔর ন উনকী জমাত মেং দাখ়িল হো, ক্যোংকি উন্হোংনে গ়ুস্সে মেং আকর দূসরোং কো ক়ত্ল কিযা হৈ, উন্হোংনে অপনী মরজ়ী সে বৈলোং কী কোংচেং কাটী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","উনকে গ়ুস্সে পর লানত হো জো ইতনা জ়বরদস্ত হৈ ঔর উনকে তৈশ পর জো ইতনা সখ়্ত হৈ। মৈং উন্হেং যাক়ূব কে মুল্ক মেং তিত্তর-বিত্তর করূঁগা, উন্হেং ইসরাঈল মেং মুংতশির কর দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","যহূদাহ, তুম্হারে ভাঈ তুম্হারী তারীফ় করেংগে। তুম অপনে দুশ্মনোং কী গরদন পকড়ে রহোগে, ঔর তুম্হারে বাপ কে বেটে তুম্হারে সামনে ঝুক জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","যহূদাহ শেরববর কা বচ্চা হৈ। মেরে বেটে, তুম অভী অভী শিকার মারকর ৱাপস আএ হো। যহূদাহ শেরববর বল্কি শেরনী কী তরহ দবককর বৈঠ জাতা হৈ। কৌন উসে ছেড়নে কী জুর্রত করেগা? ");
INSERT INTO urdgvb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","শাহী অসা যহূদাহ সে দূর নহীং হোগা বল্কি শাহী ইখ়্তিযার উস ৱক়্ত তক উস কী ঔলাদ কে পাস রহেগা জব তক ৱহ হাকিম ন আএ জিসকে তাবে ক়ৌমেং রহেংগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ৱহ অপনা জৱান গধা অংগূর কী বেল সে ঔর অপনী গধী কা বচ্চা বেহতরীন অংগূর কী বেল সে বাঁধেগা। ৱহ অপনা লিবাস মৈ মেং ঔর অপনা কপড়া অংগূর কে খ়ূন মেং ধোএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","উস কী আঁখেং মৈ সে জ়্যাদা গদলী ঔর উসকে দাঁত দূধ সে জ়্যাদা সফ়েদ হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","জ়বূলূন সাহিল পর আবাদ হোগা জহাঁ বহরী জহাজ় হোংগে। উস কী হদ সৈদা তক হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ইশকার তাক়তৱর গধা হৈ জো অপনে জ়ীন কে দো বোরোং কে দরমিযান বৈঠা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","জব ৱহ দেখেগা কি উস কী আরামগাহ অচ্ছী ঔর উসকা মুল্ক খ়ুশনুমা হৈ তো ৱহ বোঝ উঠানে কে লিএ তৈযার হো জাএগা ঔর উজরত কে বগ়ৈর কাম করনে কে লিএ মজবূর কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","দান অপনী ক়ৌম কা ইনসাফ় করেগা অগরচে ৱহ ইসরাঈল কে ক়বীলোং মেং সে এক হী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","দান সড়ক কে সাঁপ ঔর রাস্তে কে অফ়ঈ কী মানিংদ হোগা। ৱহ ঘোড়ে কী এড়িযোং কো কাটেগা তো উসকা সৱার পীছে গির জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ঐ রব, মৈং তেরী হী নজাত কে ইংতজ়ার মেং হূঁ! ");
INSERT INTO urdgvb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","জদ পর ডাকুওং কা জত্থা হমলা করেগা, লেকিন ৱহ পলটকর উসী পর হমলা কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","আশর কো গ়িজ়াইযতৱালী খ়ুরাক হাসিল হোগী। ৱহ লজ়ীজ় শাহী খানা মুহৈযা করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","নফ়তালী আজ়াদ ছোড়ী হুঈ হিরনী হৈ। ৱহ খ়ূবসূরত বাতেং করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","যূসুফ় ফলদার বেল হৈ। ৱহ চশ্মে পর লগী হুঈ ফলদার বেল হৈ জিসকী শাখ়েং দীৱার পর চঢ় গঈ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","তীরঅংদাজ়োং নে উস পর তীর চলাকর উসে তংগ কিযা ঔর উসকে পীছে পড় গএ, ");
INSERT INTO urdgvb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","লেকিন উস কী কমান মজ়বূত রহী, ঔর উসকে বাজ়ূ যাক়ূব কে জ়োরাৱর খ়ুদা কে সবব সে তাক়তৱর রহে, উস চরৱাহে কে সবব সে জো ইসরাঈল কা জ়বরদস্ত সূরমা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ক্যোংকি তেরে বাপ কা খ়ুদা তেরী মদদ করতা হৈ, অল্লাহ ক়াদিরে-মুতলক় তুঝে আসমান কী বরকত, জ়মীন কী গহরাইযোং কী বরকত ঔর ঔলাদ কী বরকত দেতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","তেরে বাপ কী বরকত ক়দীম পহাড়োং ঔর অবদী পহাড়িযোং কী মরগ়ূব চীজ়োং সে জ়্যাদা অজ়ীম হৈ। যহ তমাম বরকত যূসুফ় কে সর পর হো, উস শখ়্স কে চাঁদ পর জো অপনে ভাইযোং পর শহজ়াদা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","বিনযমীন ফাড়নেৱালা ভেড়িযা হৈ। সুবহ ৱহ অপনা শিকার খা জাতা ঔর রাত কো অপনা লূটা হুআ মাল তক়সীম কর দেতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","যহ ইসরাঈল কে কুল বারহ ক়বীলে হৈং। ঔর যহ ৱহ কুছ হৈ জো উনকে বাপ নে উনসে বরকত দেতে ৱক়্ত কহা। উসনে হর এক কো উস কী অপনী বরকত দী। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ফির যাক়ূব নে অপনে বেটোং কো হুক্ম দিযা, “অব মৈং কূচ করকে অপনে বাপদাদা সে জা মিলূঁগা। মুঝে মেরে বাপদাদা কে সাথ উস গ়ার মেং দফ়নানা জো হিত্তী আদমী ইফ়রোন কে খেত মেং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","যানী উস গ়ার মেং জো মুল্কে-কনান মেং মমরে কে মশরিক় মেং মকফ়ীলা কে খেত মেং হৈ। ইব্রাহীম নে উসে খেত সমেত অপনে লোগোং কো দফ়নানে কে লিএ ইফ়রোন হিত্তী সে খ়রীদ লিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ৱহাঁ ইব্রাহীম ঔর উস কী বীৱী সারা দফ়নাএ গএ, ৱহাঁ ইসহাক় ঔর উস কী বীৱী রিবক়া দফ়নাএ গএ ঔর ৱহাঁ মৈংনে লিযাহ কো দফ়ন কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ৱহ খেত ঔর উসকা গ়ার হিত্তিযোং সে খ়রীদা গযা থা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ইন হিদাযাত কে বাদ যাক়ূব নে অপনে পাঁৱ বিস্তর পর সমেট লিএ ঔর দম ছোড়কর অপনে বাপদাদা সে জা মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","যূসুফ় অপনে বাপ কে চেহরে সে লিপট গযা। উসনে রোতে হুএ উসে বোসা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","উসকে মুলাজ়িমোং মেং সে কুছ ডাক্টর থে। উসনে উন্হেং হিদাযত দী কি মেরে বাপ ইসরাঈল কী লাশ কো হনূত করেং তাকি ৱহ গল ন জাএ। উন্হোংনে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ইসমেং 40 দিন লগ গএ। আম তৌর পর হনূত করনে কে লিএ ইতনে হী দিন লগতে হৈং। মিসরিযোং নে 70 দিন তক যাক়ূব কা মাতম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","জব মাতম কা ৱক়্ত খ়ত্ম হুআ তো যূসুফ় নে বাদশাহ কে দরবারিযোং সে কহা, “মেহরবানী করকে যহ খ়বর বাদশাহ তক পহুঁচা দেং ");
INSERT INTO urdgvb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","কি মেরে বাপ নে মুঝে ক়সম দিলাকর কহা থা, ‘মৈং মরনেৱালা হূঁ। মুঝে উস ক়ব্র মেং দফ়ন করনা জো মৈংনে মুল্কে-কনান মেং অপনে লিএ বনৱাঈ।’ অব মুঝে ইজাজ়ত দেং কি মৈং ৱহাঁ জাঊঁ ঔর অপনে বাপ কো দফ়ন করকে ৱাপস আঊঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ফ়িরৌন নে জৱাব দিযা, “জা, অপনে বাপ কো দফ়ন কর জিস তরহ উসনে তুঝে ক়সম দিলাঈ থী।” ");
INSERT INTO urdgvb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","চুনাঁচে যূসুফ় অপনে বাপ কো দফ়নানে কে লিএ কনান রৱানা হুআ। বাদশাহ কে তমাম মুলাজ়িম, মহল কে বুজ়ুর্গ ঔর পূরে মিসর কে বুজ়ুর্গ উসকে সাথ থে। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","যূসুফ় কে ঘরানে কে অফ়রাদ, উসকে ভাঈ ঔর উসকে বাপ কে ঘরানে কে লোগ ভী সাথ গএ। সির্ফ় উনকে বচ্চে, উনকী ভেড়-বকরিযাঁ ঔর গায-বৈল জুশন মেং রহে। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","রথ ঔর ঘুড়সৱার ভী সাথ গএ। সব মিলকর বড়া লশকর বন গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","জব ৱহ যরদন কে ক়রীব অতদ কে খলিযান পর পহুঁচে তো উন্হোংনে নিহাযত দিলসোজ় নোহা কিযা। ৱহাঁ যূসুফ় নে সাত দিন তক অপনে বাপ কা মাতম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","জব মক়ামী কনানিযোং নে অতদ কে খলিযান পর মাতম কা যহ নজ়ারা দেখা তো উন্হোংনে কহা, “যহ তো মাতম কা বহুত বড়া ইংতজ়াম হৈ জো মিসরী করৱা রহে হৈং।” ইসলিএ উস জগহ কা নাম অবীল-মিসরীম যানী ‘মিসরিযোং কা মাতম’ পড় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","যোং যাক়ূব কে বেটোং নে অপনে বাপ কা হুক্ম পূরা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","উন্হোংনে উসে মুল্কে-কনান মেং লে জাকর মকফ়ীলা কে খেত কে গ়ার মেং দফ়ন কিযা জো মমরে কে মশরিক় মেং হৈ। যহ ৱহী খেত হৈ জো ইব্রাহীম নে ইফ়রোন হিত্তী সে অপনে লোগোং কো দফ়নানে কে লিএ খ়রীদা থা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ইসকে বাদ যূসুফ়, উসকে ভাঈ ঔর বাক়ী তমাম লোগ জো জনাজ়ে কে লিএ সাথ গএ থে মিসর কো লৌট আএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","জব যাক়ূব ইংতক়াল কর গযা তো যূসুফ় কে ভাঈ ডর গএ। উন্হোংনে কহা, “খ়তরা হৈ কি অব যূসুফ় হমারা তাক়্ক়ুব করকে উস গ়লত কাম কা বদলা লে জো হমনে উসকে সাথ কিযা থা। ফির ক্যা হোগা?” ");
INSERT INTO urdgvb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","যহ সোচকর উন্হোংনে যূসুফ় কো খ়বর ভেজী, “আপকে বাপ নে মরনে সে পেশতর হিদাযত দী ");
INSERT INTO urdgvb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","কি যূসুফ় কো বতানা, ‘অপনে ভাইযোং কে উস গ়লত কাম কো মুআফ় কর দেনা জো উন্হোংনে তুম্হারে সাথ কিযা।’ অব হমেং জো আপকে বাপ কে খ়ুদা কে পৈরোকার হৈং মুআফ় কর দেং।” যহ খ়বর সুনকর যূসুফ় রো পড়া। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ফির উসকে ভাঈ খ়ুদ আএ ঔর উসকে সামনে গির গএ। উন্হোংনে কহা, “হম আপকে খ়াদিম হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","লেকিন যূসুফ় নে কহা, “মত ডরো। ক্যা মৈং অল্লাহ কী জগহ হূঁ? হরগিজ় নহীং! ");
INSERT INTO urdgvb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","তুমনে মুঝে নুক়সান পহুঁচানে কা ইরাদা কিযা থা, লেকিন অল্লাহ নে উসসে ভলাঈ পৈদা কী। ঔর অব ইসকা মক়সদ পূরা হো রহা হৈ। বহুত-সে লোগ মৌত সে বচ রহে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","চুনাঁচে অব ডরনে কী জ়রূরত নহীং হৈ। মৈং তুম্হেং ঔর তুম্হারে বচ্চোং কো খ়ুরাক মুহৈযা করতা রহূঁগা।” যোং যূসুফ় নে উন্হেং তসল্লী দী ঔর উনসে নরমী সে বাত কী। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","যূসুফ় অপনে বাপ কে খ়ানদান সমেত মিসর মেং রহা। ৱহ 110 সাল জ়িংদা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","মৌত সে পহলে উসনে ন সির্ফ় ইফ়রাঈম কে বচ্চোং কো বল্কি উসকে পোতোং কো ভী দেখা। মনস্সী কে বেটে মকীর কে বচ্চে ভী উস কী মৌজূদগী মেং পৈদা হোকর উস কী গোদ মেং রখে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ফির এক ৱক়্ত আযা কি যূসুফ় নে অপনে ভাইযোং সে কহা, “মৈং মরনেৱালা হূঁ। লেকিন অল্লাহ জ়রূর আপকী দেখ-ভাল করকে আপকো ইস মুল্ক সে উস মুল্ক মেং লে জাএগা জিসকা উসনে ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে ক়সম খাকর ৱাদা কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ফির যূসুফ় নে ইসরাঈলিযোং কো ক়সম দিলাকর কহা, “অল্লাহ যক়ীনন তুম্হারী দেখ-ভাল করকে ৱহাঁ লে জাএগা। উস ৱক়্ত মেরী হড্ডিযোং কো ভী উঠাকর সাথ লে জানা।” ");
INSERT INTO urdgvb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ফির যূসুফ় ফ়ৌত হো গযা। ৱহ 110 সাল কা থা। উসে হনূত করকে মিসর মেং এক তাবূত মেং রখা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","জ়ৈল মেং উন বেটোং কে নাম হৈং জো অপনে বাপ যাক়ূব ঔর অপনে খ়ানদানোং সমেত মিসর মেং আএ থে : ");
INSERT INTO urdgvb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","রূবিন, শমৌন, লাৱী, যহূদাহ, ");
INSERT INTO urdgvb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ইশকার, জ়বূলূন, বিনযমীন, ");
INSERT INTO urdgvb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","দান, নফ়তালী, জদ ঔর আশর। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","উস ৱক়্ত যাক়ূব কী ঔলাদ কী তাদাদ 70 থী। যূসুফ় তো পহলে হী মিসর আ চুকা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","মিসর মেং রহতে হুএ বহুত দিন গুজ়র গএ। ইতনে মেং যূসুফ়, উসকে তমাম ভাঈ ঔর উস নসল কে তমাম লোগ মর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ইসরাঈলী ফলে-ফূলে ঔর তাদাদ মেং বহুত বঢ় গএ। নতীজে মেং ৱহ নিহাযত হী তাক়তৱর হো গএ। পূরা মুল্ক উনসে ভর গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","হোতে হোতে এক নযা বাদশাহ তখ়্তনশীন হুআ জো যূসুফ় সে নাৱাক়িফ় থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","উসনে অপনে লোগোং সে কহা, “ইসরাঈলিযোং কো দেখো। ৱহ তাদাদ ঔর তাক়ত মেং হমসে বঢ় গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","আও, হম হিকমত সে কাম লেং, ৱরনা ৱহ মজ়ীদ বঢ় জাএংগে। ঐসা ন হো কি ৱহ কিসী জংগ কে মৌক়ে পর দুশ্মন কা সাথ দেকর হমসে লড়েং ঔর মুল্ক কো ছোড় জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","চুনাঁচে মিসরিযোং নে ইসরাঈলিযোং পর নিগরান মুক়র্রর কিএ তাকি বেগার মেং উনসে কাম করৱাকর উন্হেং দবাতে রহেং। উস ৱক়্ত উন্হোংনে পিতোম ঔর রামসীস কে শহর তামীর কিএ। ইন শহরোং মেং ফ়িরৌন বাদশাহ কে বড়ে বড়ে গোদাম থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","লেকিন জিতনা ইসরাঈলিযোং কো দবাযা গযা উতনা হী ৱহ তাদাদ মেং বঢ়তে ঔর ফৈলতে গএ। আখ়িরকার মিসরী উনসে দহশত খানে লগে, ");
INSERT INTO urdgvb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ঔর ৱহ বড়ী বেরহমী সে উনসে কাম করৱাতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ইসরাঈলিযোং কা গুজ়ারা নিহাযত মুশ্কিল হো গযা। উন্হেং গারা তৈযার করকে ঈংটেং বনানা ঔর খেতোং মেং মুখ়্তলিফ় ক়িস্ম কে কাম করনা পড়ে। ইসমেং মিসরী উনসে বড়ী বেরহমী সে পেশ আতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ইসরাঈলিযোং কী দো দাইযাঁ থীং জিনকে নাম সিফ়রা ঔর ফ়ুআ থে। মিসর কে বাদশাহ নে উনসে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“জব ইবরানী ঔরতেং তুম্হেং মদদ কে লিএ বুলাএঁ তো খ়বরদার রহো। অগর লড়কা পৈদা হো তো উসে জান সে মার দো, অগর লড়কী হো তো উসে জীতা ছোড় দো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","লেকিন দাইযাঁ অল্লাহ কা খ়ৌফ় মানতী থীং। উন্হোংনে মিসর কে বাদশাহ কা হুক্ম ন মানা বল্কি লড়কোং কো ভী জীনে দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","তব মিসর কে বাদশাহ নে উন্হেং দুবারা বুলাকর পূছা, “তুমনে যহ ক্যোং কিযা? তুম লড়কোং কো ক্যোং জীতা ছোড় দেতী হো?” ");
INSERT INTO urdgvb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","উন্হোংনে জৱাব দিযা, “ইবরানী ঔরতেং মিসরী ঔরতোং সে জ়্যাদা মজ়বূত হৈং। বচ্চে হমারে পহুঁচনে সে পহলে হী পৈদা হো জাতে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","চুনাঁচে অল্লাহ নে দাইযোং কো বরকত দী, ঔর ইসরাঈলী ক়ৌম তাদাদ মেং বঢ়কর বহুত তাক়তৱর হো গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ঔর চূঁকি দাইযাঁ অল্লাহ কা খ়ৌফ় মানতী থীং ইসলিএ উসনে উন্হেং ঔলাদ দেকর উনকে খ়ানদানোং কো ক়াযম রখা। ");
INSERT INTO urdgvb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","আখ়িরকার বাদশাহ নে অপনে তমাম হমৱতনোং সে বাত কী, “জব ভী ইবরানিযোং কে লড়কে পৈদা হোং তো উন্হেং দরিযাএ-নীল মেং ফেংক দেনা। সির্ফ় লড়কিযোং কো জ়িংদা রহনে দো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","উন দিনোং মেং লাৱী কে এক আদমী নে অপনে হী ক়বীলে কী এক ঔরত সে শাদী কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ঔরত হামিলা হুঈ ঔর বচ্চা পৈদা হুআ। মাঁ নে দেখা কি লড়কা খ়ূবসূরত হৈ, ইসলিএ উসনে উসে তীন মাহ তক ছুপাএ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","জব ৱহ উসে ঔর জ়্যাদা ন ছুপা সকী তো উসনে আবী নরসল সে টোকরী বনাকর উস পর তারকোল চঢ়াযা। ফির উসনে বচ্চে কো টোকরী মেং রখকর টোকরী কো দরিযাএ-নীল কে কিনারে পর উগে হুএ সরকংডোং মেং রখ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","বচ্চে কী বহন কুছ ফ়াসলে পর খড়ী দেখতী রহী কি উসকা ক্যা বনেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","উস ৱক়্ত ফ়িরৌন কী বেটী নহানে কে লিএ দরিযা পর আঈ। উস কী নৌকরানিযাঁ দরিযা কে কিনারে টহলনে লগীং। তব উসনে সরকংডোং মেং টোকরী দেখী ঔর অপনী লৌংডী কো উসে লানে ভেজা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","উসে খোলা তো ছোটা লড়কা দিখাঈ দিযা জো রো রহা থা। ফ়িরৌন কী বেটী কো উস পর তরস আযা। উসনে কহা, “যহ কোঈ ইবরানী বচ্চা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","অব বচ্চে কী বহন ফ়িরৌন কী বেটী কে পাস গঈ ঔর পূছা, “ক্যা মৈং বচ্চে কো দূধ পিলানে কে লিএ কোঈ ইবরানী ঔরত ঢূঁড লাঊঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ফ়িরৌন কী বেটী নে কহা, “হাঁ, জাও।” লড়কী চলী গঈ ঔর বচ্চে কী সগী মাঁ কো লেকর ৱাপস আঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ফ়িরৌন কী বেটী নে মাঁ সে কহা, “বচ্চে কো লে জাও ঔর উসে মেরে লিএ দূধ পিলাযা করো। মৈং তুম্হেং ইসকা মুআৱজ়া দূঁগী।” চুনাঁচে বচ্চে কী মাঁ নে উসে দূধ পিলানে কে লিএ লে লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","জব বচ্চা বড়া হুআ তো উস কী মাঁ উসে ফ়িরৌন কী বেটী কে পাস লে গঈ, ঔর ৱহ উসকা বেটা বন গযা। ফ়িরৌন কী বেটী নে উসকা নাম মূসা যানী ‘নিকালা গযা’ রখকর কহা, “মৈং উসে পানী সে নিকাল লাঈ হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","জব মূসা জৱান হুআ তো এক দিন ৱহ ঘর সে নিকলকর অপনে লোগোং কে পাস গযা জো জবরী কাম মেং মসরূফ় থে। মূসা নে দেখা কি এক মিসরী মেরে এক ইবরানী ভাঈ কো মার রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","মূসা নে চারোং তরফ় নজ়র দৌড়াঈ। জব মালূম হুআ কি কোঈ নহীং দেখ রহা তো উসনে মিসরী কো জান সে মার দিযা ঔর উসে রেত মেং ছুপা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","অগলে দিন ভী মূসা ঘর সে নিকলা। ইস দফ়া দো ইবরানী মর্দ আপস মেং লড় রহে থে। জো গ়লতী পর থা উসসে মূসা নে পূছা, “তুম অপনে ভাঈ কো ক্যোং মার রহে হো?” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","আদমী নে জৱাব দিযা, “কিসনে আপকো হম পর হুক্মরান ঔর ক়াজ়ী মুক়র্রর কিযা হৈ? ক্যা আপ মুঝে ভী ক়ত্ল করনা চাহতে হৈং জিস তরহ মিসরী কো মার ডালা থা?” তব মূসা ডর গযা। উসনে সোচা, “হায, মেরা ভেদ খুল গযা হৈ!” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","বাদশাহ কো ভী পতা লগা তো উসনে মূসা কো মরৱানে কী কোশিশ কী। লেকিন মূসা মিদিযান কে মুল্ক কো ভাগ গযা। ৱহাঁ ৱহ এক কুএঁ কে পাস বৈঠ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","মিদিযান মেং এক ইমাম থা জিসকী সাত বেটিযাঁ থীং। যহ লড়কিযাঁ অপনী ভেড়-বকরিযোং কো পানী পিলানে কে লিএ কুএঁ পর আঈং ঔর পানী নিকালকর হৌজ় ভরনে লগীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","লেকিন কুছ চরৱাহোং নে আকর উন্হেং ভগা দিযা। যহ দেখকর মূসা উঠা ঔর লড়কিযোং কো চরৱাহোং সে বচাকর উনকে রেৱড় কো পানী পিলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","জব লড়কিযাঁ অপনে বাপ রঊএল কে পাস ৱাপস আঈং তো বাপ নে পূছা, “আজ তুম ইতনী জল্দী সে ক্যোং ৱাপস আ গঈ হো?” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","লড়কিযোং নে জৱাব দিযা, “এক মিসরী আদমী নে হমেং চরৱাহোং সে বচাযা। ন সির্ফ় যহ বল্কি উসনে হমারে লিএ পানী ভী নিকালকর রেৱড় কো পিলা দিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","রঊএল নে কহা, “ৱহ আদমী কহাঁ হৈ? তুম উসে ক্যোং ছোড়কর আঈ হো? উসে বুলাও তাকি ৱহ হমারে সাথ খানা খাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","মূসা রঊএল কে ঘর মেং ঠহরনে কে লিএ রাজ়ী হো গযা। বাদ মেং উস কী শাদী রঊএল কী বেটী সফ়্ফ়ূরা সে হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","সফ়্ফ়ূরা কে বেটা পৈদা হুআ তো মূসা নে কহা, “ইসকা নাম জৈরসোম যানী ‘অজনবী মুল্ক মেং পরদেসী’ হো, ক্যোংকি মৈং অজনবী মুল্ক মেং পরদেসী হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","কাফ়ী অরসা গুজ়র গযা। ইতনে মেং মিসর কা বাদশাহ ইংতক়াল কর গযা। ইসরাঈলী অপনী গ়ুলামী তলে করাহতে ঔর মদদ কে লিএ পুকারতে রহে, ঔর উনকী চীখ়েং অল্লাহ তক পহুঁচ গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","অল্লাহ নে উনকী আহেং সুনীং ঔর উস অহদ কো যাদ কিযা জো উসনে ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে বাঁধা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","অল্লাহ ইসরাঈলিযোং কী হালত দেখকর উনকা খ়যাল করনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","মূসা অপনে সুসর যিতরো কী ভেড়-বকরিযোং কী নিগহবানী করতা থা (মিদিযান কা ইমাম রঊএল যিতরো ভী কহলাতা থা)। এক দিন মূসা রেৱড় কো রেগিস্তান কী পরলী জানিব লে গযা ঔর চলতে চলতে অল্লাহ কে পহাড় হোরিব যানী সীনা তক পহুঁচ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ৱহাঁ রব কা ফ়রিশ্তা আগ কে শোলে মেং উস পর জ়াহির হুআ। যহ শোলা এক ঝাড়ী মেং ভড়ক রহা থা। মূসা নে দেখা কি ঝাড়ী জল রহী হৈ লেকিন ভস্ম নহীং হো রহী। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","মূসা নে সোচা, “যহ তো অজীব বাত হৈ। ক্যা ৱজহ হৈ কি জলতী হুঈ ঝাড়ী ভস্ম নহীং হো রহী? মৈং জ়রা ৱহাঁ জাকর যহ হৈরতঅংগেজ় মংজ়র দেখূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","জব রব নে দেখা কি মূসা ঝাড়ী কো দেখনে আ রহা হৈ তো উসনে উসে ঝাড়ী মেং সে পুকারা, “মূসা, মূসা!” মূসা নে কহা, “জী, মৈং হাজ়ির হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","রব নে কহা, “ইসসে জ়্যাদা ক়রীব ন আনা। অপনী জূতিযাঁ উতার, ক্যোংকি তূ মুক়দ্দস জ়মীন পর খড়া হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","মৈং তেরে বাপ কা খ়ুদা, ইব্রাহীম কা খ়ুদা, ইসহাক় কা খ়ুদা ঔর যাক়ূব কা খ়ুদা হূঁ।” যহ সুনকর মূসা নে অপনা মুঁহ ঢাঁক লিযা, ক্যোংকি ৱহ অল্লাহ কো দেখনে সে ডরা। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","রব নে কহা, “মৈংনে মিসর মেং অপনী ক়ৌম কী বুরী হালত দেখী ঔর গ়ুলামী মেং উনকী চীখ়েং সুনী হৈং, ঔর মৈং উনকে দুখোং কো খ়ূব জানতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","অব মৈং উন্হেং মিসরিযোং কে ক়াবূ সে বচানে কে লিএ উতর আযা হূঁ। মৈং উন্হেং মিসর সে নিকালকর এক অচ্ছে ৱসী মুল্ক মেং লে জাঊঁগা, এক ঐসে মুল্ক মেং জহাঁ দূধ ঔর শহদ কী কসরত হৈ, গো ইস ৱক়্ত কনানী, হিত্তী, অমোরী, ফ়রিজ়্জ়ী, হিৱ্ৱী ঔর যবূসী উসমেং রহতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ইসরাঈলিযোং কী চীখ়েং মুঝ তক পহুঁচী হৈং। মৈংনে দেখা হৈ কি মিসরী উন পর কিস তরহ কা জ়ুল্ম ঢা রহে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","চুনাঁচে অব জা। মৈং তুঝে ফ়িরৌন কে পাস ভেজতা হূঁ, ক্যোংকি তুঝে মেরী ক়ৌম ইসরাঈল কো মিসর সে নিকালকর লানা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","লেকিন মূসা নে অল্লাহ সে কহা, “মৈং কৌন হূঁ কি ফ়িরৌন কে পাস জাকর ইসরাঈলিযোং কো মিসর সে নিকাল লাঊঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","অল্লাহ নে কহা, “মৈং তো তেরে সাথ হূঁগা। ঔর ইসকা সবূত কি মৈং তুঝে ভেজ রহা হূঁ যহ হোগা কি লোগোং কে মিসর সে নিকলনে কে বাদ তুম যহাঁ আকর ইস পহাড় পর মেরী ইবাদত করোগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","লেকিন মূসা নে এতরাজ় কিযা, “অগর মৈং ইসরাঈলিযোং কে পাস জাকর উন্হেং বতাঊঁ কি তুম্হারে বাপদাদা কে খ়ুদা নে মুঝে তুম্হারে পাস ভেজা হৈ তো ৱহ পূছেংগে, ‘উসকা নাম ক্যা হৈ?’ ফির মৈং উনকো ক্যা জৱাব দূঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","অল্লাহ নে কহা, “মৈং জো হূঁ সো মৈং হূঁ। উনসে কহনা, ‘মৈং হূঁ নে মুঝে তুম্হারে পাস ভেজা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","রব জো তুম্হারে বাপদাদা কা খ়ুদা, ইব্রাহীম কা খ়ুদা, ইসহাক় কা খ়ুদা ঔর যাক়ূব কা খ়ুদা হৈ উসী নে মুঝে তুম্হারে পাস ভেজা হৈ।’ যহ অবদ তক মেরা নাম রহেগা। লোগ যহী নাম লেকর মুঝে নসল-দর-নসল যাদ করেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","অব জা ঔর ইসরাঈল কে বুজ়ুর্গোং কো জমা করকে উনকো বতা দে কি রব তুম্হারে বাপদাদা ইব্রাহীম, ইসহাক় ঔর যাক়ূব কা খ়ুদা মুঝ পর জ়াহির হুআ হৈ। ৱহ ফ়রমাতা হৈ, ‘মৈংনে খ়ূব দেখ লিযা হৈ কি মিসর মেং তুম্হারে সাথ ক্যা সুলূক হো রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ইসলিএ মৈংনে ফ়ৈসলা কিযা হৈ কি তুম্হেং মিসর কী মুসীবত সে নিকালকর কনানিযোং, হিত্তিযোং, অমোরিযোং, ফ়রিজ়্জ়িযোং, হিৱ্ৱিযোং ঔর যবূসিযোং কে মুল্ক মেং লে জাঊঁ, ঐসে মুল্ক মেং জহাঁ দূধ ঔর শহদ কী কসরত হৈ।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","বুজ়ুর্গ তেরী সুনেংগে। ফির উনকে সাথ মিসর কে বাদশাহ কে পাস জাকর উসসে কহনা, ‘রব ইবরানিযোং কা খ়ুদা হম পর জ়াহির হুআ হৈ। ইসলিএ হমেং ইজাজ়ত দেং কি হম তীন দিন কা সফ়র করকে রেগিস্তান মেং রব অপনে খ়ুদা কে লিএ ক়ুরবানিযাঁ চঢ়াএঁ।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","লেকিন মুঝে মালূম হৈ কি মিসর কা বাদশাহ সির্ফ় ইস সূরত মেং তুম্হেং জানে দেগা কি কোঈ জ়বরদস্তী তুম্হেং লে জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ইসলিএ মৈং অপনী ক়ুদরত জ়াহির করকে অপনে মোজিজ়োং কী মারিফ়ত মিসরিযোং কো মারূঁগা। ফির ৱহ তুম্হেং জানে দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","উস ৱক়্ত মৈং মিসরিযোং কে দিলোং কো তুম্হারে লিএ নরম কর দূঁগা। তুম্হেং খ়ালী হাথ নহীং জানা পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","তমাম ইবরানী ঔরতেং অপনী মিসরী পড়োসনোং ঔর অপনে ঘর মেং রহনেৱালী মিসরী ঔরতোং সে চাঁদী ঔর সোনে কে জ়েৱরাত ঔর নফ়ীস কপড়ে মাঁগকর অপনে বচ্চোং কো পহনাএঁগী। যোং মিসরিযোং কো লূট লিযা জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","মূসা নে এতরাজ় কিযা, “লেকিন ইসরাঈলী ন মেরী বাত কা যক়ীন করেংগে, ন মেরী সুনেংগে। ৱহ তো কহেংগে, ‘রব তুম পর জ়াহির নহীং হুআ’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","জৱাব মেং রব নে মূসা সে কহা, “তূনে হাথ মেং ক্যা পকড়া হুআ হৈ?” মূসা নে কহা, “লাঠী।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","রব নে কহা, “উসে জ়মীন পর ডাল দে।” মূসা নে ঐসা কিযা তো লাঠী সাঁপ বন গঈ, ঔর মূসা ডরকর ভাগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","রব নে কহা, “অব সাঁপ কী দুম কো পকড় লে।” মূসা নে ঐসা কিযা তো সাঁপ ফির লাঠী বন গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","রব নে কহা, “যহ দেখকর লোগোং কো যক়ীন আএগা কি রব জো উনকে বাপদাদা কা খ়ুদা, ইব্রাহীম কা খ়ুদা, ইসহাক় কা খ়ুদা ঔর যাক়ূব কা খ়ুদা হৈ তুঝ পর জ়াহির হুআ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","অব অপনা হাথ অপনে লিবাস মেং ডাল দে।” মূসা নে ঐসা কিযা। জব উসনে অপনা হাথ নিকালা তো ৱহ বর্ফ় কী মানিংদ সফ়েদ হো গযা থা। কোঢ় জৈসী বীমারী লগ গঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","তব রব নে কহা, “অব অপনা হাথ দুবারা অপনে লিবাস মেং ডাল।” মূসা নে ঐসা কিযা। জব উসনে অপনা হাথ দুবারা নিকালা তো ৱহ ফির সেহতমংদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","রব নে কহা, “অগর লোগোং কো পহলা মোজিজ়া দেখকর যক়ীন ন আএ ঔর ৱহ তেরী ন সুনেং তো শাযদ উন্হেং দূসরা মোজিজ়া দেখকর যক়ীন আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","অগর উন্হেং ফির ভী যক়ীন ন আএ ঔর ৱহ তেরী ন সুনেং তো দরিযাএ-নীল সে কুছ পানী নিকালকর উসে খ়ুশ্ক জ়মীন পর উংডেল দে। যহ পানী জ়মীন পর গিরতে হী খ়ূন বন জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","লেকিন মূসা নে কহা, “মেরে আক়া, মৈং মাজ়রত চাহতা হূঁ, মৈং অচ্ছী তরহ বাত নহীং কর সকতা বল্কি মৈং কভী ভী যহ লিযাক়ত নহীং রখতা থা। ইস ৱক়্ত ভী জব মৈং তুঝসে বাত কর রহা হূঁ মেরী যহী হালত হৈ। মৈং রুক রুককর বোলতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","রব নে কহা, “কিসনে ইনসান কা মুঁহ বনাযা? কৌন এক কো গূঁগা ঔর দূসরে কো বহরা বনা দেতা হৈ? কৌন এক কো দেখনে কী ক়াবিলিযত দেতা হৈ ঔর দূসরে কো ইসসে মহরূম রখতা হৈ? ক্যা মৈং জো রব হূঁ যহ সব কুছ নহীং করতা? ");
INSERT INTO urdgvb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","অব জা! তেরে বোলতে ৱক়্ত মৈং খ়ুদ তেরে সাথ হূঁগা ঔর তুঝে ৱহ কুছ সিখাঊঁগা জো তুঝে কহনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","লেকিন মূসা নে ইল্তিজা কী, “মেরে আক়া, মেহরবানী করকে কিসী ঔর কো ভেজ দে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","তব রব মূসা সে সখ়্ত খ়ফ়া হুআ। উসনে কহা, “ক্যা তেরা লাৱী ভাঈ হারূন ঐসে কাম কে লিএ হাজ়ির নহীং হৈ? মৈং জানতা হূঁ কি ৱহ অচ্ছী তরহ বোল সকতা হৈ। দেখ, ৱহ তুঝসে মিলনে কে লিএ নিকল চুকা হৈ। তুঝে দেখকর ৱহ নিহাযত খ়ুশ হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","উসে ৱহ কুছ বতা জো উসে কহনা হৈ। তুম্হারে বোলতে ৱক়্ত মৈং তেরে ঔর উসকে সাথ হূঁগা ঔর তুম্হেং ৱহ কুছ সিখাঊঁগা জো তুম্হেং করনা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","হারূন তেরী জগহ ক়ৌম সে বাত করেগা জবকি তূ মেরী তরহ উসে ৱহ কুছ বতাএগা জো উসে কহনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","লেকিন যহ লাঠী ভী সাথ লে জানা, ক্যোংকি ইসী কে জ়রীএ তূ যহ মোজিজ়ে করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ফির মূসা অপনে সুসর যিতরো কে ঘর ৱাপস চলা গযা। উসনে কহা, “মুঝে জ়রা অপনে অজ়ীজ়োং কে পাস ৱাপস জানে দেং জো মিসর মেং হৈং। মৈং মালূম করনা চাহতা হূঁ কি ৱহ অভী তক জ়িংদা হৈং কি নহীং।” যিতরো নে জৱাব দিযা, “ঠীক হৈ, সলামতী সে জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","মূসা অভী মিদিযান মেং থা কি রব নে উসসে কহা, “মিসর কো ৱাপস চলা জা, ক্যোংকি জো আদমী তুঝে ক়ত্ল করনা চাহতে থে ৱহ মর গএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","চুনাঁচে মূসা অপনী বীৱী ঔর বেটোং কো গধে পর সৱার করকে মিসর কো লৌটনে লগা। অল্লাহ কী লাঠী উসকে হাথ মেং থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","রব নে উসসে যহ ভী কহা, “মিসর জাকর ফ়িরৌন কে সামনে ৱহ তমাম মোজিজ়ে দিখা জিনকা মৈংনে তুঝে ইখ়্তিযার দিযা হৈ। লেকিন মেরে কহনে পর ৱহ অড়া রহেগা। ৱহ ইসরাঈলিযোং কো জানে কী ইজাজ়ত নহীং দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","উস ৱক়্ত ফ়িরৌন কো বতা দেনা, ‘রব ফ়রমাতা হৈ কি ইসরাঈল মেরা পহলৌঠা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","মৈং তুঝে বতা চুকা হূঁ কি মেরে বেটে কো জানে দে তাকি ৱহ মেরী ইবাদত করে। অগর তূ মেরে বেটে কো জানে সে মনা করে তো মৈং তেরে পহলৌঠে কো জান সে মার দূঁগা’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","এক দিন জব মূসা অপনে খ়ানদান কে সাথ রাস্তে মেং কিসী সরায মেং ঠহরা হুআ থা তো রব নে উস পর হমলা করকে উসে মার দেনে কী কোশিশ কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","যহ দেখকর সফ়্ফ়ূরা নে এক তেজ় পত্থর সে অপনে বেটে কা খ়তনা কিযা ঔর কাটে হুএ হিস্সে সে মূসা কে পৈর ছুএ। উসনে কহা, “যক়ীনন তুম মেরে খ়ূনী দূল্হা হো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","তব অল্লাহ নে মূসা কো ছোড় দিযা। সফ়্ফ়ূরা নে উসে খ়তনে কে বাইস হী ‘খ়ূনী দূল্হা’ কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","রব নে হারূন সে ভী বাত কী, “রেগিস্তান মেং মূসা সে মিলনে জা।” হারূন চল পড়া ঔর অল্লাহ কে পহাড় কে পাস মূসা সে মিলা। উসনে উসে বোসা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","মূসা নে হারূন কো সব কুছ সুনা দিযা জো রব নে উসে কহনে কে লিএ ভেজা থা। উসনে উসে উন মোজিজ়োং কে বারে মেং ভী বতাযা জো উসে দিখানে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ফির দোনোং মিলকর মিসর গএ। ৱহাঁ পহুঁচকর উন্হোংনে ইসরাঈল কে তমাম বুজ়ুর্গোং কো জমা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","হারূন নে উন্হেং ৱহ তমাম বাতেং সুনাঈং জো রব নে মূসা কো বতাঈ থীং। উসনে মজ়কূরা মোজিজ়ে ভী লোগোং কে সামনে দিখাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ফির উন্হেং যক়ীন আযা। ঔর জব উন্হোংনে সুনা কি রব কো তুম্হারা খ়যাল হৈ ঔর ৱহ তুম্হারী মুসীবত সে আগাহ হৈ তো উন্হোংনে রব কো সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ফির মূসা ঔর হারূন ফ়িরৌন কে পাস গএ। উন্হোংনে কহা, “রব ইসরাঈল কা খ়ুদা ফ়রমাতা হৈ, ‘মেরী ক়ৌম কো রেগিস্তান মেং জানে দে তাকি ৱহ মেরে লিএ ঈদ মনাএঁ’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ফ়িরৌন নে জৱাব দিযা, “যহ রব কৌন হৈ? মৈং ক্যোং উসকা হুক্ম মানকর ইসরাঈলিযোং কো জানে দূঁ? ন মৈং রব কো জানতা হূঁ, ন ইসরাঈলিযোং কো জানে দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","হারূন ঔর মূসা নে কহা, “ইবরানিযোং কা খ়ুদা হম পর জ়াহির হুআ হৈ। ইসলিএ মেহরবানী করকে হমেং ইজাজ়ত দেং কি রেগিস্তান মেং তীন দিন কা সফ়র করকে রব অপনে খ়ুদা কে হুজ়ূর ক়ুরবানিযাঁ পেশ করেং। কহীং ৱহ হমেং কিসী বীমারী যা তলৱার সে ন মারে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","লেকিন মিসর কে বাদশাহ নে ইনকার কিযা, “মূসা ঔর হারূন, তুম লোগোং কো কাম সে ক্যোং রোক রহে হো? জাও, জো কাম হমনে তুমকো দিযা হৈ উস পর লগ জাও! ");
INSERT INTO urdgvb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ইসরাঈলী ৱৈসে ভী তাদাদ মেং বহুত বঢ় গএ হৈং, ঔর তুম উন্হেং কাম করনে সে রোক রহে হো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","উসী দিন ফ়িরৌন নে মিসরী নিগরানোং ঔর উনকে তহত কে ইসরাঈলী নিগরানোং কো হুক্ম দিযা, ");
INSERT INTO urdgvb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“অব সে ইসরাঈলিযোং কো ঈংটেং বনানে কে লিএ ভূসা মত দেনা, বল্কি ৱহ খ়ুদ জাকর ভূসা জমা করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","তো ভী ৱহ উতনী হী ঈংটেং বনাএঁ জিতনী পহলে বনাতে থে। ৱহ সুস্ত হো গএ হৈং ঔর ইসী লিএ চীখ় রহে হৈং কি হমেং জানে দেং তাকি অপনে খ়ুদা কো ক়ুরবানিযাঁ পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","উনসে ঔর জ়্যাদা সখ়্ত কাম করাও, উন্হেং কাম মেং লগাএ রখো। উনকে পাস ইতনা ৱক়্ত হী ন হো কি ৱহ ঝূটী বাতোং পর ধ্যান দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","মিসরী নিগরান ঔর উনকে তহত কে ইসরাঈলী নিগরানোং নে লোগোং কে পাস জাকর উনসে কহা, “ফ়িরৌন কা হুক্ম হৈ কি তুম্হেং ভূসা ন দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ইসলিএ খ়ুদ জাও ঔর ভূসা ঢূঁডকর জমা করো। লেকিন খ়বরদার! উতনী হী ঈংটেং বনাও জিতনী পহলে বনাতে থে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","যহ সুনকর ইসরাঈলী ভূসা জমা করনে কে লিএ পূরে মুল্ক মেং ফৈল গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","মিসরী নিগরান যহ কহকর উন পর দবাৱ ডালতে রহে কি উতনী ঈংটেং বনাও জিতনী পহলে বনাতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","জো ইসরাঈলী নিগরান উন্হোংনে মুক়র্রর কিএ থে উন্হেং ৱহ পীটতে ঔর কহতে রহে, “তুমনে কল ঔর আজ উতনী ঈংটেং ক্যোং নহীং বনৱাঈং জিতনী পহলে বনৱাতে থে?” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ফির ইসরাঈলী নিগরান ফ়িরৌন কে পাস গএ। উন্হোংনে শিকাযত করকে কহা, “আপ অপনে খ়াদিমোং কে সাথ ঐসা সুলূক ক্যোং কর রহে হৈং? ");
INSERT INTO urdgvb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","হমেং ভূসা নহীং দিযা জা রহা ঔর সাথ সাথ যহ কহা গযা হৈ কি উতনী ঈংটেং বনাও জিতনী পহলে বনাতে থে। নতীজে মেং হমেং মারা পীটা ভী জা রহা হৈ হালাঁকি ঐসা করনে মেং আপকে অপনে লোগ গ়লতী পর হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ফ়িরৌন নে জৱাব দিযা, “তুম লোগ সুস্ত হো, তুম কাম করনা নহীং চাহতে। ইসলিএ তুম যহ জগহ ছোড়না ঔর রব কো ক়ুরবানিযাঁ পেশ করনা চাহতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","অব জাও, কাম করো। তুম্হেং ভূসা নহীং দিযা জাএগা, লেকিন খ়বরদার! উতনী হী ঈংটেং বনাও জিতনী পহলে বনাতে থে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","জব ইসরাঈলী নিগরানোং কো বতাযা গযা কি ঈংটোং কী মতলূবা তাদাদ কম ন করো তো ৱহ সমঝ গএ কি হম ফঁস গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ফ়িরৌন কে মহল সে নিকলকর উনকী মুলাক়াত মূসা ঔর হারূন সে হুঈ জো উনকে ইংতজ়ার মেং থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","উন্হোংনে মূসা ঔর হারূন সে কহা, “রব খ়ুদ আপকী অদালত করে। ক্যোংকি আপকে সবব সে ফ়িরৌন ঔর উসকে মুলাজ়িমোং কো হমসে ঘিন আতী হৈ। আপনে উন্হেং হমেং মার দেনে কা মৌক়া দে দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","যহ সুনকর মূসা রব কে পাস ৱাপস আযা ঔর কহা, “ঐ আক়া, তূনে ইস ক়ৌম সে ঐসা বুরা সুলূক ক্যোং কিযা? ক্যা তূনে ইসী মক়সদ সে মুঝে যহাঁ ভেজা হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","জব সে মৈংনে ফ়িরৌন কে পাস জাকর উসে তেরী মরজ়ী বতাঈ হৈ ৱহ ইসরাঈলী ক়ৌম সে বুরা সুলূক কর রহা হৈ। ঔর তূনে অব তক উন্হেং বচানে কা কোঈ ক়দম নহীং উঠাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","রব নে জৱাব দিযা, “অব তূ দেখেগা কি মৈং ফ়িরৌন কে সাথ ক্যা কুছ করতা হূঁ। মেরী অজ়ীম ক়ুদরত কা তজরবা করকে ৱহ মেরে লোগোং কো জানে দেগা বল্কি উন্হেং জানে পর মজবূর করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","অল্লাহ নে মূসা সে যহ ভী কহা, “মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","মৈং ইব্রাহীম, ইসহাক় ঔর যাক়ূব পর জ়াহির হুআ। ৱহ মেরে নাম অল্লাহ ক়াদিরে-মুতলক় সে ৱাক়িফ় হুএ, লেকিন মৈংনে উন পর অপনে নাম রব কা ইনকিশাফ় নহীং কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","মৈংনে উনসে অহদ করকে ৱাদা কিযা কি উন্হেং মুল্কে-কনান দূঁগা জিসমেং ৱহ অজনবী কে তৌর পর রহতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","অব মৈংনে সুনা হৈ কি ইসরাঈলী কিস তরহ মিসরিযোং কী গ়ুলামী মেং করাহ রহে হৈং, ঔর মৈংনে অপনা অহদ যাদ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","চুনাঁচে ইসরাঈলিযোং কো বতানা, ‘মৈং রব হূঁ। মৈং তুম্হেং মিসরিযোং কে জুএ সে আজ়াদ করূঁগা ঔর উনকী গ়ুলামী সে বচাঊঁগা। মৈং বড়ী ক়ুদরত কে সাথ তুম্হেং ছুড়াঊঁগা ঔর উনকী অদালত করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","মৈং তুম্হেং অপনী ক়ৌম বনাঊঁগা ঔর তুম্হারা খ়ুদা হূঁগা। তব তুম জান লোগে কি মৈং রব তুম্হারা খ়ুদা হূঁ জিসনে তুম্হেং মিসরিযোং কে জুএ সে আজ়াদ কর দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","মৈং তুম্হেং উস মুল্ক মেং লে জাঊঁগা জিসকা ৱাদা মৈংনে ক়সম খাকর ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে কিযা হৈ। ৱহ মুল্ক তুম্হারী অপনী মিলকিযত হোগা। মৈং রব হূঁ’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","মূসা নে যহ সব কুছ ইসরাঈলিযোং কো বতা দিযা, লেকিন উন্হোংনে উস কী বাত ন মানী, ক্যোংকি ৱহ সখ়্ত কাম কে বাইস হিম্মত হার গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","তব রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“জা, মিসর কে বাদশাহ ফ়িরৌন কো বতা দেনা কি ইসরাঈলিযোং কো অপনে মুল্ক সে জানে দে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","লেকিন মূসা নে এতরাজ় কিযা, “ইসরাঈলী মেরী বাত সুননা নহীং চাহতে তো ফ়িরৌন ক্যোং মেরী বাত মানে জবকি মৈং রুক রুককর বোলতা হূঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","লেকিন রব নে মূসা ঔর হারূন কো হুক্ম দিযা, “ইসরাঈলিযোং ঔর মিসর কে বাদশাহ ফ়িরৌন সে বাত করকে ইসরাঈলিযোং কো মিসর সে নিকালো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ইসরাঈল কে আবাঈ ঘরানোং কে সরবরাহ যহ থে : ইসরাঈল কে পহলৌঠে রূবিন কে চার বেটে হনূক, ফ়ল্লূ, হসরোন ঔর করমী থে। ইনসে রূবিন কী চার শাখ়েং নিকলীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","শমৌন কে পাঁচ বেটে যমুএল, যমীন, উহদ, যকীন, সুহর ঔর সাঊল থে। (সাঊল কনানী ঔরত কা বচ্চা থা)। ইনসে শমৌন কী পাঁচ শাখ়েং নিকলীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","লাৱী কে তীন বেটে জৈরসোন, ক়িহাত ঔর মিরারী থে। (লাৱী 137 সাল কী উম্র মেং ফ়ৌত হুআ)। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","জৈরসোন কে দো বেটে লিবনী ঔর সিমঈ থে। ইনসে জৈরসোন কী দো শাখ়েং নিকলীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ক়িহাত কে চার বেটে অমরাম, ইজ়হার, হবরূন ঔর উজ়্জ়িযেল থে। (ক়িহাত 133 সাল কী উম্র মেং ফ়ৌত হুআ)। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","মিরারী কে দো বেটে মহলী ঔর মূশী থে। ইন সবসে লাৱী কী মুখ়্তলিফ় শাখ়েং নিকলীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","অমরাম নে অপনী ফূফী যূকবিদ সে শাদী কী। উনকে দো বেটে হারূন ঔর মূসা পৈদা হুএ। (অমরাম 137 সাল কী উম্র মেং ফ়ৌত হুআ)। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ইজ়হার কে তীন বেটে ক়োরহ, নফ়জ ঔর জ়িকরী থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","উজ়্জ়িযেল কে তীন বেটে মীসাএল, ইল্সফ়ন ঔর সিতরী থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","হারূন নে ইলীসিবা সে শাদী কী। (ইলীসিবা অম্মীনদাব কী বেটী ঔর নহসোন কী বহন থী)। উনকে চার বেটে নদব, অবীহূ, ইলিযজ়র ঔর ইতমর থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ক়োরহ কে তীন বেটে অস্সীর, ইলক়ানা ঔর অবিযাসফ় থে। উনসে ক়োরহিযোং কী তীন শাখ়েং নিকলীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","হারূন কে বেটে ইলিযজ়র নে ফ়ূতিযেল কী এক বেটী সে শাদী কী। উনকা এক বেটা ফ়ীনহাস থা। যহ সব লাৱী কে আবাঈ ঘরানোং কে সরবরাহ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","রব নে অমরাম কে দো বেটোং হারূন ঔর মূসা কো হুক্ম দিযা কি মেরী ক়ৌম কো উসকে খ়ানদানোং কী তরতীব কে মুতাবিক় মিসর সে নিকালো। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ইন্হীং দো আদমিযোং নে মিসর কে বাদশাহ ফ়িরৌন সে বাত কী কি ইসরাঈলিযোং কো মিসর সে জানে দে। ");
INSERT INTO urdgvb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","মিসর মেং রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“মৈং রব হূঁ। মিসর কে বাদশাহ কো ৱহ সব কুছ বতা দেনা জো মৈং তুঝে বতাতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","মূসা নে এতরাজ় কিযা, “মৈং তো রুক রুককর বোলতা হূঁ। ফ়িরৌন কিস তরহ মেরী বাত মানেগা?” ");
INSERT INTO urdgvb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","লেকিন রব নে কহা, “দেখ, মেরে কহনে পর তূ ফ়িরৌন কে লিএ অল্লাহ কী হৈসিযত রখেগা ঔর তেরা ভাঈ হারূন তেরা পৈগ়ংবর হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","জো ভী হুক্ম মৈং তুঝে দূঁগা উসে তূ হারূন কো বতা দে। ফির ৱহ সব কুছ ফ়িরৌন কো বতাএ তাকি ৱহ ইসরাঈলিযোং কো অপনে মুল্ক সে জানে দে। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","লেকিন মৈং ফ়িরৌন কো অড় জানে দূঁগা। অগরচে মৈং মিসর মেং বহুত-সে নিশানোং ঔর মোজিজ়োং সে অপনী ক়ুদরত কা মুজ়াহরা করূঁগা ");
INSERT INTO urdgvb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","তো ভী ফ়িরৌন তুম্হারী নহীং সুনেগা। তব মিসরিযোং পর মেরা হাথ ভারী হো জাএগা, ঔর মৈং উনকো সখ়্ত সজ়া দেকর অপনী ক়ৌম ইসরাঈল কো খ়ানদানোং কী তরতীব কে মুতাবিক় মিসর সে নিকাল লাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","জব মৈং মিসর কে খ়িলাফ় অপনী ক়ুদরত কা ইজ়হার করকে ইসরাঈলিযোং কো ৱহাঁ সে নিকালূঁগা তো মিসরী জান লেংগে কি মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","মূসা ঔর হারূন নে সব কুছ ৱৈসা হী কিযা জৈসা রব নে উন্হেং হুক্ম দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ফ়িরৌন সে বাত করতে ৱক়্ত মূসা 80 সাল কা ঔর হারূন 83 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“জব ফ়িরৌন তুম্হেং মোজিজ়া দিখানে কো কহেগা তো মূসা হারূন সে কহে কি অপনী লাঠী জ়মীন পর ডাল দে। ইস পর ৱহ সাঁপ বন জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","মূসা ঔর হারূন নে ফ়িরৌন কে পাস জাকর ঐসা হী কিযা। হারূন নে অপনী লাঠী ফ়িরৌন ঔর উসকে ওহদেদারোং কে সামনে ডাল দী তো ৱহ সাঁপ বন গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","যহ দেখকর ফ়িরৌন নে অপনে আলিমোং ঔর জাদূগরোং কো বুলাযা। জাদূগরোং নে ভী অপনে জাদূ সে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","হর এক নে অপনী লাঠী জ়মীন পর ফেংকী তো ৱহ সাঁপ বন গঈ। লেকিন হারূন কী লাঠী নে উনকী লাঠিযোং কো নিগল লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","তাহম ফ়িরৌন ইসসে মুতঅস্সির ন হুআ। উসনে মূসা ঔর হারূন কী বাত সুননে সে ইনকার কিযা। ৱৈসা হী হুআ জৈসা রব নে কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ফির রব নে মূসা সে কহা, “ফ়িরৌন অড় গযা হৈ। ৱহ মেরী ক়ৌম কো মিসর ছোড়নে সে রোকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","কল সুবহ-সৱেরে জব ৱহ দরিযাএ-নীল পর আএগা তো উসসে মিলনে কে লিএ দরিযা কে কিনারে পর খড়ে হো জানা। উস লাঠী কো থামে রখনা জো সাঁপ বন গঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","জব ৱহ ৱহাঁ পহুঁচে তো উসসে কহনা, ‘রব ইবরানিযোং কে খ়ুদা নে মুঝে আপকো যহ বতানে কে লিএ ভেজা হৈ কি মেরী ক়ৌম কো মেরী ইবাদত করনে কে লিএ রেগিস্তান মেং জানে দে। লেকিন আপনে অভী তক উস কী নহীং সুনী। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","চুনাঁচে অব আপ জান লেংগে কি ৱহ রব হৈ। মৈং ইস লাঠী কো জো মেরে হাথ মেং হৈ লেকর দরিযাএ-নীল কে পানী কো মারূঁগা। ফির ৱহ খ়ূন মেং বদল জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","দরিযাএ-নীল কী মছলিযাঁ মর জাএঁগী, দরিযা সে বদবূ উঠেগী ঔর মিসরী দরিযা কা পানী নহীং পী সকেংগে’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","রব নে মূসা সে কহা, “হারূন কো বতা দেনা কি ৱহ অপনী লাঠী লেকর অপনা হাথ উন তমাম জগহোং কী তরফ় বঢ়াএ জহাঁ পানী জমা হোতা হৈ। তব মিসর কী তমাম নদিযোং, নহরোং, জোহড়োং ঔর তালাবোং কা পানী খ়ূন মেং বদল জাএগা। পূরে মুল্ক মেং খ়ূন হী খ়ূন হোগা, যহাঁ তক কি লকড়ী ঔর পত্থর কে বরতনোং কা পানী ভী খ়ূন মেং বদল জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","চুনাঁচে মূসা ঔর হারূন নে ফ়িরৌন ঔর উসকে ওহদেদারোং কে সামনে অপনী লাঠী উঠাকর দরিযাএ-নীল কে পানী পর মারী। ইস পর দরিযা কা সারা পানী খ়ূন মেং বদল গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","দরিযা কী মছলিযাঁ মর গঈং, ঔর উসসে ইতনী বদবূ উঠনে লগী কি মিসরী উসকা পানী ন পী সকে। মিসর মেং চারোং তরফ় খ়ূন হী খ়ূন থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","লেকিন জাদূগরোং নে ভী অপনে জাদূ কে জ়রীএ ঐসা হী কিযা। ইসলিএ ফ়িরৌন অড় গযা ঔর মূসা ঔর হারূন কী বাত ন মানী। ৱৈসা হী হুআ জৈসা রব নে কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ফ়িরৌন পলটকর অপনে ঘর ৱাপস চলা গযা। উসে উস কী পরৱা নহীং থী জো মূসা ঔর হারূন নে কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","লেকিন মিসরী দরিযা সে পানী ন পী সকে, ঔর উন্হোংনে পীনে কা পানী হাসিল করনে কে লিএ দরিযা কে কিনারে কিনারে গঢ়ে খোদে। ");
INSERT INTO urdgvb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","পানী কে বদল জানে কে বাদ সাত দিন গুজ়র গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ফির রব নে মূসা সে কহা, “ফ়িরৌন কে পাস জাকর উসে বতা দেনা কি রব ফ়রমাতা হৈ, ‘মেরী ক়ৌম কো মেরী ইবাদত করনে কে লিএ জানে দে, ");
INSERT INTO urdgvb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ৱরনা মৈং পূরে মিসর কো মেংঢকোং সে সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","দরিযাএ-নীল মেংঢকোং সে ইতনা ভর জাএগা কি ৱহ দরিযা সে নিকলকর তেরে মহল, তেরে সোনে কে কমরে ঔর তেরে বিস্তর মেং জা ঘুসেংগে। ৱহ তেরে ওহদেদারোং ঔর তেরী রিআযা কে ঘরোং মেং আএঁগে বল্কি তেরে তনূরোং ঔর আটা গূঁধনে কে বরতনোং মেং ভী ফুদকতে ফিরেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","মেংঢক তুঝ পর, তেরী ক়ৌম পর ঔর তেরে ওহদেদারোং পর চঢ় জাএংগে’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","রব নে মূসা সে কহা, “হারূন কো বতা দেনা কি ৱহ অপনী লাঠী কো হাথ মেং লেকর উসে দরিযাওং, নহরোং ঔর জোহড়োং কে ঊপর উঠাএ তাকি মেংঢক বাহর নিকলকর মিসর কে মুল্ক মেং ফৈল জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","হারূন নে মুল্কে-মিসর কে পানী কে ঊপর অপনী লাঠী উঠাঈ তো মেংঢকোং কে গ়োল পানী সে নিকলকর পূরে মুল্ক পর ছা গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","লেকিন জাদূগরোং নে ভী অপনে জাদূ সে ঐসা হী কিযা। ৱহ ভী দরিযা সে মেংঢক নিকাল লাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ফ়িরৌন নে মূসা ঔর হারূন কো বুলাকর কহা, “রব সে দুআ করো কি ৱহ মুঝসে ঔর মেরী ক়ৌম সে মেংঢকোং কো দূর করে। ফির মৈং তুম্হারী ক়ৌম কো জানে দূঁগা তাকি ৱহ রব কো ক়ুরবানিযাঁ পেশ করেং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","মূসা নে জৱাব দিযা, “ৱহ ৱক়্ত মুক়র্রর করেং জব মৈং আপকে ওহদেদারোং ঔর আপকী ক়ৌম কে লিএ দুআ করূঁ। ফির জো মেংঢক আপকে পাস ঔর আপকে ঘরোং মেং হৈং উসী ৱক়্ত খ়ত্ম হো জাএংগে। মেংঢক সির্ফ় দরিযা মেং পাএ জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ফ়িরৌন নে কহা, “ঠীক হৈ, কল উন্হেং খ়ত্ম করো।” মূসা নে কহা, “জৈসা আপ কহতে হৈং ৱৈসা হী হোগা। ইস তরহ আপকো মালূম হোগা কি হমারে খ়ুদা কী মানিংদ কোঈ নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","মেংঢক আপ, আপকে ঘরোং, আপকে ওহদেদারোং ঔর আপকী ক়ৌম কো ছোড়কর সির্ফ় দরিযা মেং রহ জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","মূসা ঔর হারূন ফ়িরৌন কে পাস সে চলে গএ, ঔর মূসা নে রব সে মিন্নত কী কি ৱহ মেংঢকোং কে ৱহ গ়োল দূর করে জো উসনে ফ়িরৌন কে খ়িলাফ় ভেজে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","রব নে উস কী দুআ সুনী। ঘরোং, সহনোং ঔর খেতোং মেং মেংঢক মর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","লোগোং নে উন্হেং জমা করকে উনকে ঢের লগা দিএ। উনকী বদবূ পূরে মুল্ক মেং ফৈল গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","লেকিন জব ফ়িরৌন নে দেখা কি মসলা হল হো গযা হৈ তো ৱহ ফির অকড় গযা ঔর উনকী ন সুনী। যোং রব কী বাত দুরুস্ত নিকলী। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ফির রব নে মূসা সে কহা, “হারূন সে কহনা কি ৱহ অপনী লাঠী সে জ়মীন কী গর্দ কো মারে। জব ৱহ ঐসা করেগা তো পূরে মিসর কী গর্দ জুওং মেং বদল জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","উন্হোংনে ঐসা হী কিযা। হারূন নে অপনী লাঠী সে জ়মীন কী গর্দ কো মারা তো পূরে মুল্ক কী গর্দ জুওং মেং বদল গঈ। উনকে গ়োল জানৱরোং ঔর আদমিযোং পর ছা গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","জাদূগরোং নে ভী অপনে জাদূ সে ঐসা করনে কী কোশিশ কী, লেকিন ৱহ গর্দ সে জুএঁ ন বনা সকে। জুএঁ আদমিযোং ঔর জানৱরোং পর ছা গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","জাদূগরোং নে ফ়িরৌন সে কহা, “অল্লাহ কী ক়ুদরত নে যহ কিযা হৈ।” লেকিন ফ়িরৌন নে উনকী ন সুনী। যোং রব কী বাত দুরুস্ত নিকলী। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ফির রব নে মূসা সে কহা, “জব ফ়িরৌন সুবহ-সৱেরে দরিযা পর জাএ তো তূ উসকে রাস্তে মেং খড়া হো জানা। উসে কহনা কি রব ফ়রমাতা হৈ, ‘মেরী ক়ৌম কো জানে দে তাকি ৱহ মেরী ইবাদত কর সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ৱরনা মৈং তেরে ঔর তেরে ওহদেদারোং কে পাস, তেরী ক়ৌম কে পাস ঔর তেরে ঘরোং মেং কাটনেৱালী মক্খিযাঁ ভেজ দূঁগা। মিসরিযোং কে ঘর মক্খিযোং সে ভর জাএংগে বল্কি জিস জ়মীন পর ৱহ খড়ে হৈং ৱহ ভী মক্খিযোং সে ঢাঁকী জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","লেকিন উস ৱক়্ত মৈং অপনী ক়ৌম কে সাথ জো জুশন মেং রহতী হৈ ফ়রক় সুলূক করূঁগা। ৱহাঁ এক ভী কাটনেৱালী মক্খী নহীং হোগী। ইস তরহ তুঝে পতা লগেগা কি ইস মুল্ক মেং মৈং হী রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","মৈং অপনী ক়ৌম ঔর তেরী ক়ৌম মেং ইম্তিযাজ় করূঁগা। কল হী মেরী ক়ুদরত কা ইজ়হার হোগা’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","রব নে ঐসা হী কিযা। কাটনেৱালী মক্খিযোং কে গ়োল ফ়িরৌন কে মহল, উসকে ওহদেদারোং কে ঘরোং ঔর পূরে মিসর মেং ফৈল গএ। মুল্ক কা সত্যানাস হো গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ফির ফ়িরৌন নে মূসা ঔর হারূন কো বুলাকর কহা, “চলো, ইসী মুল্ক মেং অপনে খ়ুদা কো ক়ুরবানিযাঁ পেশ করো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","লেকিন মূসা নে কহা, “যহ মুনাসিব নহীং হৈ। জো ক়ুরবানিযাঁ হম রব অপনে খ়ুদা কো পেশ করেংগে ৱহ মিসরিযোং কী নজ়র মেং ঘিনৌনী হৈং। অগর হম যহাঁ ঐসা করেং তো ক্যা ৱহ হমেং সংগসার নহীং করেংগে? ");
INSERT INTO urdgvb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ইসলিএ লাজ়িম হৈ কি হম তীন দিন কা সফ়র করকে রেগিস্তান মেং হী রব অপনে খ়ুদা কো ক়ুরবানিযাঁ পেশ করেং জিস তরহ উসনে হমেং হুক্ম ভী দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ফ়িরৌন নে জৱাব দিযা, “ঠীক হৈ, মৈং তুম্হেং জানে দূঁগা তাকি তুম রেগিস্তান মেং রব অপনে খ়ুদা কো ক়ুরবানিযাঁ পেশ করো। লেকিন তুম্হেং জ়্যাদা দূর নহীং জানা হৈ। ঔর মেরে লিএ ভী দুআ করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","মূসা নে কহা, “ঠীক, মৈং জাতে হী রব সে দুআ করূঁগা। কল হী মক্খিযাঁ ফ়িরৌন, উসকে ওহদেদারোং ঔর উস কী ক়ৌম সে দূর হো জাএঁগী। লেকিন হমেং দুবারা ফ়রেব ন দেনা বল্কি হমেং জানে দেনা তাকি হম রব কো ক়ুরবানিযাঁ পেশ কর সকেং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ফির মূসা ফ়িরৌন কে পাস সে চলা গযা ঔর রব সে দুআ কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","রব নে মূসা কী দুআ সুনী। কাটনেৱালী মক্খিযাঁ ফ়িরৌন, উসকে ওহদেদারোং ঔর উস কী ক়ৌম সে দূর হো গঈং। এক ভী মক্খী ন রহী। ");
INSERT INTO urdgvb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","লেকিন ফ়িরৌন ফির অকড় গযা। উসনে ইসরাঈলিযোং কো জানে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ফির রব নে মূসা সে কহা, “ফ়িরৌন কে পাস জাকর উসে বতা কি রব ইবরানিযোং কা খ়ুদা ফ়রমাতা হৈ, ‘মেরী ক়ৌম কো জানে দে তাকি ৱহ মেরী ইবাদত কর সকেং।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","অগর আপ ইনকার করেং ঔর উন্হেং রোকতে রহেং ");
INSERT INTO urdgvb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","তো রব অপনী ক়ুদরত কা ইজ়হার করকে আপকে মৱেশিযোং মেং ভযানক ৱবা ফৈলা দেগা জো আপকে ঘোড়োং, গধোং, ঊঁটোং, গায-বৈলোং, ভেড়-বকরিযোং ঔর মেংঢোং মেং ফৈল জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","লেকিন রব ইসরাঈল ঔর মিসর কে মৱেশিযোং মেং ইম্তিযাজ় করেগা। ইসরাঈলিযোং কা এক ভী জানৱর নহীং মরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","রব নে ফ়ৈসলা কর লিযা হৈ কি ৱহ কল হী ঐসা করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","অগলে দিন রব নে ঐসা হী কিযা। মিসর কে তমাম মৱেশী মর গএ, লেকিন ইসরাঈলিযোং কা এক ভী জানৱর ন মরা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ফ়িরৌন নে কুছ লোগোং কো উনকে পাস ভেজ দিযা তো পতা চলা কি এক ভী জানৱর নহীং মরা। তাহম ফ়িরৌন অড়া রহা। উসনে ইসরাঈলিযোং কো জানে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ফির রব নে মূসা ঔর হারূন সে কহা, “অপনী মুট্ঠিযাঁ কিসী ভট্টী কী রাখ সে ভরকর ফ়িরৌন কে পাস জাও। ফির মূসা ফ়িরৌন কে সামনে যহ রাখ হৱা মেং উড়া দে। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","যহ রাখ বারীক ধূল কা বাদল বন জাএগী জো পূরে মুল্ক পর ছা জাএগা। উসকে অসর সে লোগোং ঔর জানৱরোং কে জিস্মোং পর ফোড়ে-ফুংসিযাঁ ফূট নিকলেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","মূসা ঔর হারূন নে ঐসা হী কিযা। ৱহ কিসী ভট্টী সে রাখ লেকর ফ়িরৌন কে সামনে খড়ে হো গএ। মূসা নে রাখ কো হৱা মেং উড়া দিযা তো ইনসানোং ঔর জানৱরোং কে জিস্মোং পর ফোড়ে-ফুংসিযাঁ নিকল আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ইস মরতবা জাদূগর মূসা কে সামনে খড়ে ভী ন হো সকে ক্যোংকি উনকে জিস্মোং পর ভী ফোড়ে নিকল আএ থে। তমাম মিসরিযোং কা যহী হাল থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","লেকিন রব নে ফ়িরৌন কো জ়িদ্দী বনাএ রখা, ইসলিএ উসনে মূসা ঔর হারূন কী ন সুনী। যোং ৱৈসা হী হুআ জৈসা রব নে মূসা কো বতাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ইসকে বাদ রব নে মূসা সে কহা, “সুবহ-সৱেরে উঠ ঔর ফ়িরৌন কে সামনে খড়ে হোকর উসে বতা কি রব ইবরানিযোং কা খ়ুদা ফ়রমাতা হৈ, ‘মেরী ক়ৌম কো জানে দে তাকি ৱহ মেরী ইবাদত কর সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ৱরনা মৈং অপনী তমাম আফ়তেং তুঝ পর, তেরে ওহদেদারোং পর ঔর তেরী ক়ৌম পর আনে দূঁগা। ফির তূ জান লেগা কি তমাম দুনিযা মেং মুঝ জৈসা কোঈ নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","অগর মৈং চাহতা তো অপনী ক়ুদরত সে ঐসী ৱবা ফৈলা সকতা কি তুঝে ঔর তেরী ক়ৌম কো দুনিযা সে মিটা দিযা জাতা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","লেকিন মৈংনে তুঝে ইসলিএ বরপা কিযা হৈ কি তুঝ পর অপনী ক়ুদরত কা ইজ়হার করূঁ ঔর যোং তমাম দুনিযা মেং মেরে নাম কা প্রচার কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","তূ অভী তক অপনে আপকো সরফ়রাজ় করকে মেরী ক়ৌম কে খ়িলাফ় হৈ ঔর উন্হেং জানে নহীং দেতা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ইসলিএ কল মৈং ইসী ৱক়্ত ভযানক ক়িস্ম কে ওলোং কা তূফ়ান ভেজ দূঁগা। মিসরী ক়ৌম কী ইব্তিদা সে লেকর আজ তক মিসর মেং ওলোং কা ঐসা তূফ়ান কভী নহীং আযা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","অপনে বংদোং কো অভী ভেজনা তাকি ৱহ তেরে মৱেশিযোং কো ঔর খেতোং মেং পড়ে তেরে মাল কো লাকর মহফ়ূজ় কর লেং। ক্যোংকি জো ভী খুলে মৈদান মেং রহেগা ৱহ ওলোং সে মর জাএগা, খ়াহ ইনসান হো যা হৈৱান’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ফ়িরৌন কে কুছ ওহদেদার রব কা পৈগ়াম সুনকর ডর গএ ঔর ভাগকর অপনে জানৱরোং ঔর গ়ুলামোং কো ঘরোং মেং লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","লেকিন দূসরোং নে রব কে পৈগ়াম কী পরৱা ন কী। উনকে জানৱর ঔর গ়ুলাম বাহর খুলে মৈদান মেং রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","রব নে মূসা সে কহা, “অপনা হাথ আসমান কী তরফ় বঢ়া দে। ফির মিসর কে তমাম ইনসানোং, জানৱরোং ঔর খেতোং কে পৌদোং পর ওলে পড়েংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","মূসা নে অপনী লাঠী আসমান কী তরফ় উঠাঈ তো রব নে এক জ়বরদস্ত তূফ়ান ভেজ দিযা। ওলে পড়ে, বিজলী গিরী ঔর বাদল গরজতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ওলে পড়তে রহে ঔর বিজলী চমকতী রহী। মিসরী ক়ৌম কী ইব্তিদা সে লেকর অব তক ঐসে খ়তরনাক ওলে কভী নহীং পড়ে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ইনসানোং সে লেকর হৈৱানোং তক খেতোং মেং সব কুছ বরবাদ হো গযা। ওলোং নে খেতোং মেং তমাম পৌদে ঔর দরখ়্ত ভী তোড় দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ৱহ সির্ফ় জুশন কে ইলাক়ে মেং ন পড়ে জহাঁ ইসরাঈলী আবাদ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","তব ফ়িরৌন নে মূসা ঔর হারূন কো বুলাযা। উসনে কহা, “ইস মরতবা মৈংনে গুনাহ কিযা হৈ। রব হক় পর হৈ। মুঝসে ঔর মেরী ক়ৌম সে গ়লতী হুঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ওলে ঔর অল্লাহ কী গরজতী আৱাজ়েং হদ সে জ়্যাদা হৈং। রব সে দুআ করো তাকি ওলে রুক জাএঁ। অব মৈং তুম্হেং জানে দূঁগা। অব সে তুম্হেং যহাঁ রহনা নহীং পড়েগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","মূসা নে ফ়িরৌন সে কহা, “মৈং শহর সে নিকলকর দোনোং হাথ রব কী তরফ় উঠাকর দুআ করূঁগা। ফির গরজ ঔর ওলে রুক জাএংগে ঔর আপ জান লেংগে কি পূরী দুনিযা রব কী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","লেকিন মৈং জানতা হূঁ কি আপ ঔর আপকে ওহদেদার অভী তক রব খ়ুদা কা খ়ৌফ় নহীং মানতে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","উস ৱক়্ত সন কে ফূল নিকল চুকে থে ঔর জৌ কী বালেং লগ গঈ থীং। ইসলিএ যহ ফ়সলেং তবাহ হো গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","লেকিন গেহূঁ ঔর এক ঔর ক়িস্ম কী গংদুম জো বাদ মেং পকতী হৈ বরবাদ ন হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","মূসা ফ়িরৌন কো ছোড়কর শহর সে নিকলা। উসনে রব কী তরফ় অপনে হাথ উঠাএ তো গরজ, ওলে ঔর বারিশ কা তূফ়ান রুক গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","জব ফ়িরৌন নে দেখা কি তূফ়ান খ়ত্ম হো গযা হৈ তো ৱহ ঔর উসকে ওহদেদার দুবারা গুনাহ করকে অকড় গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ফ়িরৌন অড়া রহা ঔর ইসরাঈলিযোং কো জানে ন দিযা। ৱৈসা হী হুআ জৈসা রব নে মূসা সে কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ফির রব নে মূসা সে কহা, “ফ়িরৌন কে পাস জা, ক্যোংকি মৈংনে উসকা ঔর উসকে দরবারিযোং কা দিল সখ়্ত কর দিযা হৈ তাকি উনকে দরমিযান অপনে মোজিজ়োং ঔর অপনী ক়ুদরত কা ইজ়হার কর সকূঁ ");
INSERT INTO urdgvb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ঔর তুম অপনে বেটে-বেটিযোং ঔর পোতে-পোতিযোং কো সুনা সকো কি মৈংনে মিসরিযোং কে সাথ ক্যা সুলূক কিযা হৈ ঔর উনকে দরমিযান কিস তরহ কে মোজিজ়ে করকে অপনী ক়ুদরত কা ইজ়হার কিযা হৈ। যোং তুম জান লোগে কি মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","মূসা ঔর হারূন ফ়িরৌন কে পাস গএ। উন্হোংনে উসসে কহা, “রব ইবরানিযোং কে খ়ুদা কা ফ়রমান হৈ, ‘তূ কব তক মেরে সামনে হথিযার ডালনে সে ইনকার করেগা? মেরী ক়ৌম কো মেরী ইবাদত করনে কে লিএ জানে দে, ");
INSERT INTO urdgvb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ৱরনা মৈং কল তেরে মুল্ক মেং টিড্ডিযাঁ লাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","উনকে গ়োল জ়মীন পর যোং ছা জাএংগে কি জ়মীন নজ়র হী নহীং আএগী। জো কুছ ওলোং নে তবাহ নহীং কিযা উসে ৱহ চট কর জাএঁগী। বচে হুএ দরখ়্তোং কে পত্তে ভী খ়ত্ম হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","তেরে মহল, তেরে ওহদেদারোং ঔর বাক়ী লোগোং কে ঘর উনসে ভর জাএংগে। জব সে মিসরী ইস মুল্ক মেং আবাদ হুএ হৈং তুমনে কভী টিড্ডিযোং কা ঐসা সখ়্ত হমলা নহীং দেখা হোগা’।” যহ কহকর মূসা পলটকর ৱহাঁ সে চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ইস পর দরবারিযোং নে ফ়িরৌন সে বাত কী, “হম কব তক ইস মর্দ কে জাল মেং ফঁসে রহেং? ইসরাঈলিযোং কো রব অপনে খ়ুদা কী ইবাদত করনে কে লিএ জানে দেং। ক্যা আপকো অভী তক মালূম নহীং কি মিসর বরবাদ হো গযা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","তব মূসা ঔর হারূন কো ফ়িরৌন কে পাস বুলাযা গযা। উসনে উনসে কহা, “জাও, অপনে খ়ুদা কী ইবাদত করো। লেকিন যহ বতাও কি কৌন কৌন সাথ জাএগা?” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","মূসা নে জৱাব দিযা, “হমারে জৱান ঔর বূঢ়ে সাথ জাএংগে। হম অপনে বেটে-বেটিযোং, ভেড়-বকরিযোং ঔর গায-বৈলোং কো ভী সাথ লেকর জাএংগে। হম সবকে সব জাএংগে, ক্যোংকি হমেং রব কী ঈদ মনানী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ফ়িরৌন নে তংজ়ন কহা, “ঠীক হৈ, জাও ঔর রব তুম্হারে সাথ হো। নহীং, মৈং কিস তরহ তুম সবকো বাল-বচ্চোং সমেত জানে দে সকতা হূঁ? তুমনে কোঈ বুরা মনসূবা বনাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","নহীং, সির্ফ় মর্দ জাকর রব কী ইবাদত কর সকতে হৈং। তুমনে তো যহী দরখ়াস্ত কী থী।” তব মূসা ঔর হারূন কো ফ়িরৌন কে সামনে সে নিকাল দিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ফির রব নে মূসা সে কহা, “মিসর পর অপনা হাথ উঠা তাকি টিড্ডিযাঁ আকর মিসর কী সরজ়মীন পর ফৈল জাএঁ। জো কুছ ভী খেতোং মেং ওলোং সে বচ গযা হৈ উসে ৱহ খা জাএঁগী।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","মূসা নে অপনী লাঠী মিসর পর উঠাঈ তো রব নে মশরিক় সে আঁধী চলাঈ জো সারা দিন ঔর সারী রাত চলতী রহী ঔর অগলী সুবহ তক মিসর মেং টিড্ডিযাঁ পহুঁচাঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","বেশুমার টিড্ডিযাঁ পূরে মুল্ক পর হমলা করকে হর জগহ বৈঠ গঈং। ইসসে পহলে যা বাদ মেং কভী ভী টিড্ডিযোং কা ইতনা সখ়্ত হমলা ন হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","উন্হোংনে জ়মীন কো যোং ঢাঁক লিযা কি ৱহ কালী নজ়র আনে লগী। জো কুছ ভী ওলোং সে বচ গযা থা চাহে খেতোং কে পৌদে যা দরখ়্তোং কে ফল থে উন্হোংনে খা লিযা। মিসর মেং এক ভী দরখ়্ত যা পৌদা ন রহা জিসকে পত্তে বচ গএ হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","তব ফ়িরৌন নে মূসা ঔর হারূন কো জল্দী সে বুলৱাযা। উসনে কহা, “মৈংনে তুম্হারে খ়ুদা কা ঔর তুম্হারা গুনাহ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","অব এক ঔর মরতবা মেরা গুনাহ মুআফ় করো ঔর রব অপনে খ়ুদা সে দুআ করো তাকি মৌত কী যহ হালত মুঝসে দূর হো জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","মূসা নে মহল সে নিকলকর রব সে দুআ কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","জৱাব মেং রব নে হৱা কা রুখ় বদল দিযা। উসনে মগ়রিব সে তেজ় আঁধী চলাঈ জিসনে টিড্ডিযোং কো উড়াকর বহরে-ক়ুলজ়ুম মেং ডাল দিযা। মিসর মেং এক ভী টিড্ডী ন রহী। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","লেকিন রব নে হোনে দিযা কি ফ়িরৌন ফির অড় গযা। উসনে ইসরাঈলিযোং কো জানে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ইসকে বাদ রব নে মূসা সে কহা, “অপনা হাথ আসমান কী তরফ় উঠা তো মিসর পর অংধেরা ছা জাএগা। ইতনা অংধেরা হোগা কি বংদা উসে ছূ সকেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","মূসা নে অপনা হাথ আসমান কী তরফ় উঠাযা তো তীন দিন তক মিসর পর গহরা অংধেরা ছাযা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","তীন দিন তক লোগ ন এক দূসরে কো দেখ সকে, ন কহীং জা সকে। লেকিন জহাঁ ইসরাঈলী রহতে থে ৱহাঁ রৌশনী থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","তব ফ়িরৌন নে মূসা কো ফির বুলৱাযা ঔর কহা, “জাও, রব কী ইবাদত করো! তুম অপনে সাথ বাল-বচ্চোং কো ভী লে জা সকতে হো। সির্ফ় অপনী ভেড়-বকরিযাঁ ঔর গায-বৈল পীছে ছোড় দেনা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","মূসা নে জৱাব দিযা, “ক্যা আপ হী হমেং ক়ুরবানিযোং কে লিএ জানৱর দেংগে তাকি উন্হেং রব অপনে খ়ুদা কো পেশ করেং? ");
INSERT INTO urdgvb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","যক়ীনন নহীং। ইসলিএ লাজ়িম হৈ কি হম অপনে জানৱরোং কো সাথ লেকর জাএঁ। এক খুর ভী পীছে নহীং ছোড়া জাএগা, ক্যোংকি অভী তক হমেং মালূম নহীং কি রব কী ইবাদত কে লিএ কিন কিন জানৱরোং কী জ়রূরত হোগী। যহ উস ৱক়্ত হী পতা চলেগা জব হম মনজ়িলে-মক়সূদ পর পহুঁচেংগে। ইসলিএ জ়রূরী হৈ কি হম সবকো অপনে সাথ লেকর জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","লেকিন রব কী মরজ়ী কে মুতাবিক় ফ়িরৌন অড় গযা। উসনে উন্হেং জানে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","উসনে মূসা সে কহা, “দফ়া হো জা। খ়বরদার! ফির কভী অপনী শক্ল ন দিখানা, ৱরনা তুঝে মৌত কে হৱালে কর দিযা জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","মূসা নে কহা, “ঠীক হৈ, আপকী মরজ়ী। মৈং ফির কভী আপকে সামনে নহীং আঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","তব রব নে মূসা সে কহা, “অব মৈং ফ়িরৌন ঔর মিসর পর আখ়িরী আফ়ত লানে কো হূঁ। ইসকে বাদ ৱহ তুম্হেং জানে দেগা বল্কি তুম্হেং জ়বরদস্তী নিকাল দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ইসরাঈলিযোং কো বতা দেনা কি হর মর্দ অপনে পড়োসী ঔর হর ঔরত অপনী পড়োসন সে সোনে-চাঁদী কী চীজ়েং মাঁগ লে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(রব নে মিসরিযোং কে দিল ইসরাঈলিযোং কী তরফ় মাযল কর দিএ থে। ৱহ ফ়িরৌন কে ওহদেদারোং সমেত খ়াসকর মূসা কী বড়ী ইজ়্জ়ত করতে থে)। ");
INSERT INTO urdgvb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","মূসা নে কহা, “রব ফ়রমাতা হৈ, ‘আজ আধী রাত কে ৱক়্ত মৈং মিসর মেং সে গুজ়রূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","তব বাদশাহ কে পহলৌঠে সে লেকর চক্কী পীসনেৱালী নৌকরানী কে পহলৌঠে তক মিসরিযোং কা হর পহলৌঠা মর জাএগা। চৌপাইযোং কে পহলৌঠে ভী মর জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","মিসর কী সরজ়মীন পর ঐসা রোনা পীটনা হোগা কি ন মাজ়ী মেং কভী হুআ, ন মুস্তক়বিল মেং কভী হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","লেকিন ইসরাঈলী ঔর উনকে জানৱর বচে রহেংগে। কুত্তা ভী উন পর নহীং ভৌংকেগা। ইস তরহ তুম জান লোগে কি রব ইসরাঈলিযোং কী নিসবত মিসরিযোং সে ফ়রক় সুলূক করতা হৈ’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","মূসা নে যহ কুছ ফ়িরৌন কো বতাযা ফির কহা, “উস ৱক়্ত আপকে তমাম ওহদেদার আকর মেরে সামনে ঝুক জাএংগে ঔর মিন্নত করেংগে, ‘অপনে পৈরোকারোং কে সাথ চলে জাএঁ।’ তব মৈং চলা হী জাঊঁগা।” যহ কহকর মূসা ফ়িরৌন কে পাস সে চলা গযা। ৱহ বড়ে গ়ুস্সে মেং থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","রব নে মূসা সে কহা থা, “ফ়িরৌন তুম্হারী নহীং সুনেগা। ক্যোংকি লাজ়িম হৈ কি মৈং মিসর মেং অপনী ক়ুদরত কা মজ়ীদ ইজ়হার করূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","গো মূসা ঔর হারূন নে ফ়িরৌন কে সামনে যহ তমাম মোজিজ়ে দিখাএ, লেকিন রব নে ফ়িরৌন কো জ়িদ্দী বনাএ রখা, ইসলিএ উসনে ইসরাঈলিযোং কো মুল্ক ছোড়নে ন দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ফির রব নে মিসর মেং মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“অব সে যহ মহীনা তুম্হারে লিএ সাল কা পহলা মহীনা হো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ইসরাঈল কী পূরী জমাত কো বতানা কি ইস মহীনে কে দসৱেং দিন হর খ়ানদান কা সরপরস্ত অপনে ঘরানে কে লিএ লেলা যানী ভেড় যা বকরী কা বচ্চা হাসিল করে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","অগর ঘরানে কে অফ়রাদ পূরা জানৱর খানে কে লিএ কম হোং তো ৱহ অপনে সবসে ক়রীবী পড়োসী কে সাথ মিলকর লেলা হাসিল করেং। ইতনে লোগ উসমেং সে খাএঁ কি সবকে লিএ কাফ়ী হো ঔর পূরা জানৱর খাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ইসকে লিএ এক সাল কা নর বচ্চা চুন লেনা জিসমেং নুক়্স ন হো। ৱহ ভেড় যা বকরী কা বচ্চা হো সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","মহীনে কে 14ৱেং দিন তক উস কী দেখ-ভাল করো। উস দিন তমাম ইসরাঈলী সূরজ কে গ়ুরূব হোতে ৱক়্ত অপনে লেলে জ়বহ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","হর খ়ানদান অপনে জানৱর কা কুছ খ়ূন জমা করকে উসে উস ঘর কে দরৱাজ়ে কী চৌখট পর লগাএ জহাঁ লেলা খাযা জাএগা। যহ খ়ূন চৌখট কে ঊপরৱালে হিস্সে ঔর দাএঁ বাএঁ কে বাজ়ুওং পর লগাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","লাজ়িম হৈ কি লোগ জানৱর কো ভূনকর উসী রাত খাএঁ। সাথ হী ৱহ কড়ৱা সাগ-পাত ঔর বেখ়মীরী রোটিযাঁ ভী খাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","লেলে কা গোশ্ত কচ্চা ন খানা, ন উসে পানী মেং উবালনা বল্কি পূরে জানৱর কো সর, পৈরোং ঔর অংদরূনী হিস্সোং সমেত আগ পর ভূননা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","লাজ়িম হৈ কি পূরা গোশ্ত উসী রাত খাযা জাএ। অগর কুছ সুবহ তক বচ জাএ তো উসে জলানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","খানা খাতে ৱক়্ত ঐসা লিবাস পহননা জৈসে তুম সফ়র পর জা রহে হো। অপনে জূতে পহনে রখনা ঔর হাথ মেং সফ়র কে লিএ লাঠী লিএ হুএ তুম উসে জল্দী জল্দী খানা। রব কে ফ়সহ কী ঈদ যোং মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","মৈং আজ রাত মিসর মেং সে গুজ়রূঁগা ঔর হর পহলৌঠে কো জান সে মার দূঁগা, খ়াহ ইনসান কা হো যা হৈৱান কা। যোং মৈং জো রব হূঁ মিসর কে তমাম দেৱতাওং কী অদালত করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","লেকিন তুম্হারে ঘরোং পর লগা হুআ খ়ূন তুম্হারা খ়াস নিশান হোগা। জিস জিস ঘর কে দরৱাজ়ে পর মৈং ৱহ খ়ূন দেখূঁগা উসে ছোড়তা জাঊঁগা। জব মৈং মিসর পর হমলা করূঁগা তো মোহলক ৱবা তুম তক নহীং পহুঁচেগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","আজ কী রাত কো হমেশা যাদ রখনা। ইসে নসল-দর-নসল ঔর হর সাল রব কী খ়াস ঈদ কে তৌর পর মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","সাত দিন তক বেখ়মীরী রোটী খানা হৈ। পহলে দিন অপনে ঘরোং সে তমাম খ়মীর নিকাল দেনা। অগর কোঈ ইন সাত দিনোং কে দৌরান খ়মীর খাএ তো উসে ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ইস ঈদ কে পহলে ঔর আখ়িরী দিন মুক়দ্দস ইজতিমা মুনঅক়িদ করনা। ইন তমাম দিনোং কে দৌরান কাম ন করনা। সির্ফ় এক কাম কী ইজাজ়ত হৈ ঔর ৱহ হৈ অপনা খানা তৈযার করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","বেখ়মীরী রোটী কী ঈদ মনানা লাজ়িম হৈ, ক্যোংকি উস দিন মৈং তুম্হারে মুতঅদ্দিদ খ়ানদানোং কো মিসর সে নিকাল লাযা। ইসলিএ যহ দিন নসল-দর-নসল হর সাল যাদ রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","পহলে মহীনে কে 14ৱেং দিন কী শাম সে লেকর 21ৱেং দিন কী শাম তক সির্ফ় বেখ়মীরী রোটী খানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","সাত দিন তক তুম্হারে ঘরোং মেং খ়মীর ন পাযা জাএ। জো ভী ইস দৌরান খ়মীর খাএ উসে ইসরাঈল কী জমাত মেং সে মিটাযা জাএ, খ়াহ ৱহ ইসরাঈলী শহরী হো যা অজনবী। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","গ়রজ়, ইস ঈদ কে দৌরান খ়মীর ন খানা। জহাঁ ভী তুম রহতে হো ৱহাঁ বেখ়মীরী রোটী হী খানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ফির মূসা নে তমাম ইসরাঈলী বুজ়ুর্গোং কো বুলাকর উনসে কহা, “জাও, অপনে খ়ানদানোং কে লিএ ভেড় যা বকরী কে বচ্চে চুনকর উন্হেং ফ়সহ কী ঈদ কে লিএ জ়বহ করো। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","জ়ূফ়ে কা গুচ্ছা লেকর উসে খ়ূন সে ভরে হুএ বাসন মেং ডুবো দেনা। ফির উসে লেকর খ়ূন কো চৌখট কে ঊপরৱালে হিস্সে ঔর দাএঁ বাএঁ কে বাজ়ুওং পর লগা দেনা। সুবহ তক কোঈ অপনে ঘর সে ন নিকলে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","জব রব মিসরিযোং কো মার ডালনে কে লিএ মুল্ক মেং সে গুজ়রেগা তো ৱহ চৌখট কে ঊপরৱালে হিস্সে ঔর দাএঁ বাএঁ কে বাজ়ুওং পর লগা হুআ খ়ূন দেখকর উন ঘরোং কো ছোড় দেগা। ৱহ হলাক করনেৱালে ফ়রিশ্তে কো ইজাজ়ত নহীং দেগা কি ৱহ তুম্হারে ঘরোং মেং জাকর তুম্হেং হলাক করে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","তুম অপনী ঔলাদ সমেত হমেশা ইন হিদাযাত পর অমল করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","যহ রস্ম উস ৱক়্ত ভী অদা করনা জব তুম উস মুল্ক মেং পহুঁচোগে জো রব তুম্হেং দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ঔর জব তুম্হারে বচ্চে তুমসে পূছেং কি হম যহ ঈদ ক্যোং মনাতে হৈং ");
INSERT INTO urdgvb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","তো উনসে কহো, ‘যহ ফ়সহ কী ক়ুরবানী হৈ জো হম রব কো পেশ করতে হৈং। ক্যোংকি জব রব মিসরিযোং কো হলাক কর রহা থা তো উসনে হমারে ঘরোং কো ছোড় দিযা থা’।” যহ সুনকর ইসরাঈলিযোং নে অল্লাহ কো সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ফির উন্হোংনে সব কুছ ৱৈসা হী কিযা জৈসা রব নে মূসা ঔর হারূন কো বতাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","আধী রাত কো রব নে বাদশাহ কে পহলৌঠে সে লেকর জেল কে ক়ৈদী কে পহলৌঠে তক মিসরিযোং কে তমাম পহলৌঠোং কো জান সে মার দিযা। চৌপাইযোং কে পহলৌঠে ভী মর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","উস রাত মিসর কে হর ঘর মেং কোঈ ন কোঈ মর গযা। ফ়িরৌন, উসকে ওহদেদার ঔর মিসর কে তমাম লোগ জাগ উঠে ঔর জ়োর জ়োর সে রোনে ঔর চীখ়নে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","অভী রাত থী কি ফ়িরৌন নে মূসা ঔর হারূন কো বুলাকর কহা, “অব তুম ঔর বাক়ী ইসরাঈলী মেরী ক়ৌম মেং সে নিকল জাও। অপনী দরখ়াস্ত কে মুতাবিক় রব কী ইবাদত করো। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","জিস তরহ তুম চাহতে হো অপনী ভেড়-বকরিযোং কো ভী অপনে সাথ লে জাও। ঔর মুঝে ভী বরকত দেনা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","বাক়ী মিসরিযোং নে ভী ইসরাঈলিযোং পর জ়োর দেকর কহা, “জল্দী জল্দী মুল্ক সে নিকল জাও, ৱরনা হম সব মর জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ইসরাঈলিযোং কে গূঁধে হুএ আটে মেং খ়মীর নহীং থা। উন্হোংনে উসে গূঁধনে কে বরতনোং মেং রখকর অপনে কপড়োং মেং লপেট লিযা ঔর সফ়র করতে ৱক়্ত অপনে কংধোং পর রখ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ইসরাঈলী মূসা কী হিদাযত পর অমল করকে অপনে মিসরী পড়োসিযোং কে পাস গএ ঔর উনসে কপড়ে ঔর সোনে-চাঁদী কী চীজ়েং মাঁগীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","রব নে মিসরিযোং কে দিলোং কো ইসরাঈলিযোং কী তরফ় মাযল কর দিযা থা, ইসলিএ উন্হোংনে উনকী হর দরখ়াস্ত পূরী কী। যোং ইসরাঈলিযোং নে মিসরিযোং কো লূট লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ইসরাঈলী রামসীস সে রৱানা হোকর সুক্কাত পহুঁচ গএ। ঔরতোং ঔর বচ্চোং কো ছোড়কর উনকে 6 লাখ মর্দ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ৱহ অপনে ভেড়-বকরিযোং ঔর গায-বৈলোং কে বড়ে বড়ে রেৱড় ভী সাথ লে গএ। বহুত-সে ঐসে লোগ ভী উনকে সাথ নিকলে জো ইসরাঈলী নহীং থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","রাস্তে মেং উন্হোংনে উস বেখ়মীরী আটে সে রোটিযাঁ বনাঈং জো ৱহ সাথ লেকর নিকলে থে। আটে মেং ইসলিএ খ়মীর নহীং থা কি উন্হেং ইতনী জল্দী সে মিসর সে নিকাল দিযা গযা থা কি খানা তৈযার করনে কা ৱক়্ত হী ন মিলা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ইসরাঈলী 430 সাল তক মিসর মেং রহে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 সাল কে ঐন বাদ, উসী দিন রব কে যহ তমাম খ়ানদান মিসর সে নিকলে। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","উস খ়াস রাত রব নে খ়ুদ পহরা দিযা তাকি ইসরাঈলী মিসর সে নিকল সকেং। ইসলিএ তমাম ইসরাঈলিযোং কে লিএ লাজ়িম হৈ কি ৱহ নসল-দর-নসল ইস রাত রব কী তাজ়ীম মেং জাগতে রহেং, ৱহ ভী ঔর উনকে বাদ কী ঔলাদ ভী। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","রব নে মূসা ঔর হারূন সে কহা, “ফ়সহ কী ঈদ কে যহ উসূল হৈং : কিসী ভী পরদেসী কো ফ়সহ কী ঈদ কা খানা খানে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","অগর তুমনে কিসী গ়ুলাম কো খ়রীদকর উসকা খ়তনা কিযা হৈ তো ৱহ ফ়সহ কা খানা খা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","লেকিন গ়ৈরশহরী যা মজ়দূর কো ফ়সহ কা খানা খানে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","যহ খানা এক হী ঘর কে অংদর খানা হৈ। ন গোশ্ত ঘর সে বাহর লে জানা, ন লেলে কী কিসী হড্ডী কো তোড়না। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","লাজ়িম হৈ কি ইসরাঈল কী পূরী জমাত যহ ঈদ মনাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","অগর কোঈ পরদেসী তুম্হারে সাথ রহতা হৈ জো ফ়সহ কী ঈদ মেং শিরকত করনা চাহে তো লাজ়িম হৈ কি পহলে উসকে ঘরানে কে হর মর্দ কা খ়তনা কিযা জাএ। তব ৱহ ইসরাঈলী কী তরহ খানে মেং শরীক হো সকতা হৈ। লেকিন জিসকা খ়তনা ন হুআ উসে ফ়সহ কা খানা খানে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","যহী উসূল হর এক পর লাগূ হোগা, খ়াহ ৱহ ইসরাঈলী হো যা পরদেসী।” ");
INSERT INTO urdgvb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","তমাম ইসরাঈলিযোং নে ৱৈসা হী কিযা জৈসা রব নে মূসা ঔর হারূন সে কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","উসী দিন রব তমাম ইসরাঈলিযোং কো খ়ানদানোং কী তরতীব কে মুতাবিক় মিসর সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ইসরাঈলিযোং কে হর পহলৌঠে কো মেরে লিএ মখ়সূসো-মুক়দ্দস করনা হৈ। হর পহলা নর বচ্চা মেরা হী হৈ, খ়াহ ইনসান কা হো যা হৈৱান কা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ফির মূসা নে লোগোং সে কহা, “ইস দিন কো যাদ রখো জব তুম রব কী অজ়ীম ক়ুদরত কে বাইস মিসর কী গ়ুলামী সে নিকলে। ইস দিন কোঈ চীজ় ন খানা জিসমেং খ়মীর হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","আজ হী অবীব কে মহীনে মেং তুম মিসর সে রৱানা হো রহে হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","রব নে তুম্হারে বাপদাদা সে ক়সম খাকর ৱাদা কিযা হৈ কি ৱহ তুমকো কনানী, হিত্তী, অমোরী, হিৱ্ৱী ঔর যবূসী ক়ৌমোং কা মুল্ক দেগা, এক ঐসা মুল্ক জিসমেং দূধ ঔর শহদ কী কসরত হৈ। জব রব তুম্হেং উস মুল্ক মেং পহুঁচা দেগা তো লাজ়িম হৈ কি তুম ইসী মহীনে মেং যহ রস্ম মনাও। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","সাত দিন বেখ়মীরী রোটী খাও। সাতৱেং দিন রব কী তাজ়ীম মেং ঈদ মনাও। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","সাত দিন খ়মীরী রোটী ন খানা। কহীং ভী খ়মীর ন পাযা জাএ। পূরে মুল্ক মেং খ়মীর কা নামো-নিশান তক ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","উস দিন অপনে বেটে সে যহ কহো, ‘মৈং যহ ঈদ উস কাম কী খ়ুশী মেং মনাতা হূঁ জো রব নে মেরে লিএ কিযা জব মৈং মিসর সে নিকলা।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","যহ ঈদ তুম্হারে হাথ যা পেশানী পর নিশান কী মানিংদ হো জো তুম্হেং যাদ দিলাএ কি রব কী শরীঅত কো তুম্হারে হোংটোং পর রহনা হৈ। ক্যোংকি রব তুম্হেং অপনী অজ়ীম ক়ুদরত সে মিসর সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ইস দিন কী যাদ হর সাল ঠীক ৱক়্ত পর মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","রব তুম্হেং কনানিযোং কে উস মুল্ক মেং লে জাএগা জিসকা ৱাদা উসনে ক়সম খাকর তুম ঔর তুম্হারে বাপদাদা সে কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","লাজ়িম হৈ কি ৱহাঁ পহুঁচকর তুম অপনে তমাম পহলৌঠোং কো রব কে লিএ মখ়সূস করো। তুম্হারে মৱেশিযোং কে তমাম পহলৌঠে ভী রব কী মিলকিযত হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","অগর তুম অপনা পহলৌঠা গধা খ়ুদ রখনা চাহো তো রব কো উসকে বদলে ভেড় যা বকরী কা বচ্চা পেশ করো। লেকিন অগর তুম উসে রখনা নহীং চাহতে তো উস কী গরদন তোড় ডালো। লেকিন ইনসান কে পহলৌঠোং কে লিএ হর সূরত মেং এৱজ়ী দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","আনেৱালে দিনোং মেং জব তুম্হারা বেটা পূছে কি ইসকা ক্যা মতলব হৈ তো উসে জৱাব দেনা, ‘রব অপনী অজ়ীম ক়ুদরত সে হমেং মিসর কী গ়ুলামী সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","জব ফ়িরৌন নে অকড়কর হমেং জানে ন দিযা তো রব নে মিসর কে তমাম ইনসানোং ঔর হৈৱানোং কে পহলৌঠোং কো মার ডালা। ইস ৱজহ সে মৈং অপনে জানৱরোং কা হর পহলা বচ্চা রব কো ক়ুরবান করতা ঔর অপনে হর পহলৌঠে কে লিএ এৱজ়ী দেতা হূঁ’। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","যহ দস্তূর তুম্হারে হাথ ঔর পেশানী পর নিশান কী মানিংদ হো জো তুম্হেং যাদ দিলাএ কি রব হমেং অপনী ক়ুদরত সে মিসর সে নিকাল লাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","জব ফ়িরৌন নে ইসরাঈলী ক়ৌম কো জানে দিযা তো অল্লাহ উন্হেং ফ়িলিস্তিযোং কে ইলাক়ে মেং সে গুজ়রনেৱালে রাস্তে সে লেকর ন গযা, অগরচে উস পর চলতে হুএ ৱহ জল্দ হী মুল্কে-কনান পহুঁচ জাতে। বল্কি রব নে কহা, “অগর উস রাস্তে পর চলেংগে তো উন্হেং দূসরোং সে লড়না পড়েগা। ঐসা ন হো কি ৱহ ইস ৱজহ সে অপনা ইরাদা বদলকর মিসর লৌট জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ইসলিএ অল্লাহ উন্হেং দূসরে রাস্তে সে লেকর গযা, ঔর ৱহ রেগিস্তান কে রাস্তে সে বহরে-ক়ুলজ়ুম কী তরফ় বঢ়ে। মিসর সে নিকলতে ৱক়্ত মর্দ মুসল্লহ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","মূসা যূসুফ় কা তাবূত ভী অপনে সাথ লে গযা, ক্যোংকি যূসুফ় নে ইসরাঈলিযোং কো ক়সম দিলাকর কহা থা, “অল্লাহ যক়ীনন তুম্হারী দেখ-ভাল করকে ৱহাঁ লে জাএগা। উস ৱক়্ত মেরী হড্ডিযোং কো ভী উঠাকর সাথ লে জানা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ইসরাঈলিযোং নে সুক্কাত কো ছোড়কর এতাম মেং অপনে খ়ৈমে লগাএ। এতাম রেগিস্তান কে কিনারে পর থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","রব উনকে আগে আগে চলতা গযা, দিন কে ৱক়্ত বাদল কে সতূন মেং তাকি উন্হেং রাস্তে কা পতা লগে ঔর রাত কে ৱক়্ত আগ কে সতূন মেং তাকি উন্হেং রৌশনী মিলে। যোং ৱহ দিন ঔর রাত সফ়র কর সকতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","দিন কে ৱক়্ত বাদল কা সতূন ঔর রাত কে ৱক়্ত আগ কা সতূন উনকে সামনে রহা। ৱহ কভী ভী অপনী জগহ সে ন হটা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","তব রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ইসরাঈলিযোং কো কহ দেনা কি ৱহ পীছে মুড়কর মিজদাল ঔর সমুংদর কে বীচ যানী ফ়ী-হখ়ীরোত কে নজ়দীক রুক জাএঁ। ৱহ বাল-সফ়োন কে মুক়াবিল সাহিল পর অপনে খ়ৈমে লগাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","যহ দেখকর ফ়িরৌন সমঝেগা কি ইসরাঈলী রাস্তা ভূলকর আৱারা ফির রহে হৈং ঔর কি রেগিস্তান নে চারোং তরফ় উন্হেং ঘের রখা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ফির মৈং ফ়িরৌন কো দুবারা অড় জানে দূঁগা, ঔর ৱহ ইসরাঈলিযোং কা পীছা করেগা। লেকিন মৈং ফ়িরৌন ঔর উস কী পূরী ফ়ৌজ পর অপনা জলাল জ়াহির করূঁগা। মিসরী জান লেংগে কি মৈং হী রব হূঁ।” ইসরাঈলিযোং নে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","জব মিসর কে বাদশাহ কো ইত্তলা দী গঈ কি ইসরাঈলী হিজরত কর গএ হৈং তো উসনে ঔর উসকে দরবারিযোং নে অপনা খ়যাল বদলকর কহা, “হমনে ক্যা কিযা হৈ? হমনে উন্হেং জানে দিযা হৈ, ঔর অব হম উনকী খ়িদমত সে মহরূম হো গএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","চুনাঁচে বাদশাহ নে অপনা জংগী রথ তৈযার করৱাযা ঔর অপনী ফ়ৌজ কো লেকর নিকলা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ৱহ 600 বেহতরীন ক়িস্ম কে রথ ঔর মিসর কে বাক়ী তমাম রথোং কো সাথ লে গযা। তমাম রথোং পর অফ়সরান মুক়র্রর থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","রব নে মিসর কে বাদশাহ ফ়িরৌন কো দুবারা অড় জানে দিযা থা, ইসলিএ জব ইসরাঈলী বড়ে ইখ়্তিযার কে সাথ নিকল রহে থে তো ৱহ উনকা তাক়্ক়ুব করনে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ইসরাঈলিযোং কা পীছা করতে করতে ফ়িরৌন কে তমাম ঘোড়ে, রথ, সৱার ঔর ফ়ৌজী উনকে ক়রীব পহুঁচে। ইসরাঈলী বহরে-ক়ুলজ়ুম কে সাহিল পর বাল-সফ়োন কে মুক়াবিল ফ়ী-হখ়ীরোত কে নজ়দীক খ়ৈমে লগা চুকে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","জব ইসরাঈলিযোং নে ফ়িরৌন ঔর উস কী ফ়ৌজ কো অপনী তরফ় বঢ়তে দেখা তো ৱহ সখ়্ত ঘবরা গএ ঔর মদদ কে লিএ রব কে সামনে চীখ়নে-চিল্লানে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","উন্হোংনে মূসা সে কহা, “ক্যা মিসর মেং ক়ব্রোং কী কমী থী কি আপ হমেং রেগিস্তান মেং লে আএ হৈং? হমেং মিসর সে নিকালকর আপনে হমারে সাথ ক্যা কিযা হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ক্যা হমনে মিসর মেং আপসে দরখ়াস্ত নহীং কী থী কি মেহরবানী করকে হমেং ছোড় দেং, হমেং মিসরিযোং কী খ়িদমত করনে দেং? যহাঁ আকর রেগিস্তান মেং মর জানে কী নিসবত বেহতর হোতা কি হম মিসরিযোং কে গ়ুলাম রহতে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","লেকিন মূসা নে জৱাব দিযা, “মত ঘবরাও। আরাম সে খড়ে রহো ঔর দেখো কি রব তুম্হেং আজ কিস তরহ বচাএগা। আজ কে বাদ তুম ইন মিসরিযোং কো ফির কভী নহীং দেখোগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","রব তুম্হারে লিএ লড়েগা। তুম্হেং বস, চুপ রহনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ফির রব নে মূসা সে কহা, “তূ মেরে সামনে ক্যোং চীখ় রহা হৈ? ইসরাঈলিযোং কো আগে বঢ়নে কা হুক্ম দে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","অপনী লাঠী কো পকড়কর উসে সমুংদর কে ঊপর উঠা তো ৱহ দো হিস্সোং মেং বট জাএগা। ইসরাঈলী খ়ুশ্ক জ়মীন পর সমুংদর মেং সে গুজ়রেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","মৈং মিসরিযোং কো অড়ে রহনে দূঁগা তাকি ৱহ ইসরাঈলিযোং কা পীছা করেং। ফির মৈং ফ়িরৌন, উস কী সারী ফ়ৌজ, উসকে রথোং ঔর উসকে সৱারোং পর অপনা জলাল জ়াহির করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","জব মৈং ফ়িরৌন, উসকে রথোং ঔর উসকে সৱারোং পর অপনা জলাল জ়াহির করূঁগা তো মিসরী জান লেংগে কি মৈং হী রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","অল্লাহ কা ফ়রিশ্তা ইসরাঈলী লশকর কে আগে আগে চল রহা থা। অব ৱহ ৱহাঁ সে হটকর উনকে পীছে খড়া হো গযা। বাদল কা সতূন ভী লোগোং কে আগে সে হটকর উনকে পীছে জা খড়া হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ইস তরহ বাদল মিসরিযোং ঔর ইসরাঈলিযোং কে লশকরোং কে দরমিযান আ গযা। পূরী রাত মিসরিযোং কী তরফ় অংধেরা হী অংধেরা থা জবকি ইসরাঈলিযোং কী তরফ় রৌশনী থী। ইসলিএ মিসরী পূরী রাত কে দৌরান ইসরাঈলিযোং কে ক়রীব ন আ সকে। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","মূসা নে অপনা হাথ সমুংদর কে ঊপর উঠাযা তো রব নে মশরিক় সে তেজ় আঁধী চলাঈ। আঁধী তমাম রাত চলতী রহী। উসনে সমুংদর কো পীছে হটাকর উস কী তহ খ়ুশ্ক কর দী। সমুংদর দো হিস্সোং মেং বট গযা ");
INSERT INTO urdgvb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","তো ইসরাঈলী সমুংদর মেং সে খ়ুশ্ক জ়মীন পর চলতে হুএ গুজ়র গএ। উনকে দাঈং ঔর বাঈং তরফ় পানী দীৱার কী তরহ খড়া রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","জব মিসরিযোং কো পতা চলা তো ফ়িরৌন কে তমাম ঘোড়ে, রথ ঔর ঘুড়সৱার ভী উনকে পীছে পীছে সমুংদর মেং চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","সুবহ-সৱেরে হী রব নে বাদল ঔর আগ কে সতূন সে মিসর কী ফ়ৌজ পর নিগাহ কী ঔর উসমেং অবতরী পৈদা কর দী। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","উনকে রথোং কে পহিযে নিকল গএ তো উন পর ক়াবূ পানা মুশ্কিল হো গযা। মিসরিযোং নে কহা, “আও, হম ইসরাঈলিযোং সে ভাগ জাএঁ, ক্যোংকি রব উনকে সাথ হৈ। ৱহী মিসর কা মুক়াবলা কর রহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","তব রব নে মূসা সে কহা, “অপনা হাথ সমুংদর কে ঊপর উঠা। ফির পানী ৱাপস আকর মিসরিযোং, উনকে রথোং ঔর ঘুড়সৱারোং কো ডুবো দেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","মূসা নে অপনা হাথ সমুংদর কে ঊপর উঠাযা তো দিন নিকলতে ৱক়্ত পানী মামূল কে মুতাবিক় বহনে লগা, ঔর জিস তরফ় মিসরী ভাগ রহে থে ৱহাঁ পানী হী পানী থা। যোং রব নে উন্হেং সমুংদর মেং বহাকর গ়রক় কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","পানী ৱাপস আ গযা। উসনে রথোং ঔর ঘুড়সৱারোং কো ঢাঁক লিযা। ফ়িরৌন কী পূরী ফ়ৌজ জো ইসরাঈলিযোং কা তাক়্ক়ুব কর রহী থী ডূবকর তবাহ হো গঈ। উনমেং সে এক ভী ন বচা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","লেকিন ইসরাঈলী খ়ুশ্ক জ়মীন পর সমুংদর মেং সে গুজ়রে। উনকে দাঈং ঔর বাঈং তরফ় পানী দীৱার কী তরহ খড়া রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","উস দিন রব নে ইসরাঈলিযোং কো মিসরিযোং সে বচাযা। মিসরিযোং কী লাশেং উন্হেং সাহিল পর নজ়র আঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","জব ইসরাঈলিযোং নে রব কী যহ অজ়ীম ক়ুদরত দেখী জো উসনে মিসরিযোং পর জ়াহির কী থী তো রব কা খ়ৌফ় উন পর ছা গযা। ৱহ উস পর ঔর উসকে খ়াদিম মূসা পর এতমাদ করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","তব মূসা ঔর ইসরাঈলিযোং নে রব কে লিএ যহ গীত গাযা, “মৈং রব কী তমজীদ মেং গীত গাঊঁগা, ক্যোংকি ৱহ নিহাযত অজ়ীম হৈ। ঘোড়ে ঔর উসকে সৱার কো উসনে সমুংদর মেং পটখ় দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","রব মেরী ক়ুৱ্ৱত ঔর মেরা গীত হৈ, ৱহ মেরী নজাত বন গযা হৈ। ৱহী মেরা খ়ুদা হৈ, ঔর মৈং উস কী তারীফ় করূঁগা। ৱহী মেরে বাপ কা খ়ুদা হৈ, ঔর মৈং উস কী তাজ়ীম করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","রব সূরমা হৈ, রব উসকা নাম হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ফ়িরৌন কে রথোং ঔর ফ়ৌজ কো উসনে সমুংদর মেং পটখ় দিযা তো বাদশাহ কে বেহতরীন অফ়সরান বহরে-ক়ুলজ়ুম মেং ডূব গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","গহরে পানী নে উন্হেং ঢাঁক লিযা, ঔর ৱহ পত্থর কী তরহ সমুংদর কী তহ তক উতর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ঐ রব, তেরে দহনে হাথ কা জলাল বড়ী ক়ুদরত সে জ়াহির হোতা হৈ। ঐ রব, তেরা দহনা হাথ দুশ্মন কো চকনাচূর কর দেতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","জো তেরে খ়িলাফ় উঠ খড়ে হোতে হৈং উন্হেং তূ অপনী অজ়মত কা ইজ়হার করকে জ়মীন পর পটখ় দেতা হৈ। তেরা গ়জ়ব উন পর আন পড়তা হৈ তো ৱহ আগ মেং ভূসে কী তরহ জল জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","তূনে গ়ুস্সে মেং আকর ফূঁক মারী তো পানী ঢের কী সূরত মেং জমা হো গযা। বহতা পানী ঠোস দীৱার বন গযা, সমুংদর গহরাঈ তক জম গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","দুশ্মন নে ডীংগ মারকর কহা, ‘মৈং উনকা পীছা করকে উন্হেং পকড় লূঁগা, মৈং উনকা লূটা হুআ মাল তক়সীম করূঁগা। মেরী লালচী জান উনসে সের হো জাএগী, মৈং অপনী তলৱার খীংচকর উন্হেং হলাক করূঁগা।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","লেকিন তূনে উন পর ফূঁক মারী তো সমুংদর নে উন্হেং ঢাঁক লিযা, ঔর ৱহ সীসে কী তরহ জ়োরদার মৌজোং মেং ডূব গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ঐ রব, কৌন-সা মাবূদ তেরী মানিংদ হৈ? কৌন তেরী তরহ জলালী ঔর ক়ুদ্দূস হৈ? কৌন তেরী তরহ হৈরতঅংগেজ় কাম করতা ঔর অজ়ীম মোজিজ়ে দিখাতা হৈ? কোঈ ভী নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","তূনে অপনা দহনা হাথ উঠাযা তো জ়মীন হমারে দুশ্মনোং কো নিগল গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","অপনী শফ়ক়ত সে তূনে এৱজ়ানা দেকর অপনী ক়ৌম কো ছুটকারা দিযা ঔর উস কী রাহনুমাঈ কী হৈ, অপনী ক়ুদরত সে তূনে উসে অপনী মুক়দ্দস সুকূনতগাহ তক পহুঁচাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","যহ সুনকর দীগর ক়ৌমেং কাঁপ উঠীং, ফ়িলিস্তী ডর কে মারে পেচো-তাব খানে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","অদোম কে রঈস সহম গএ, মোআব কে রাহনুমাওং পর কপকপী তারী হো গঈ, ঔর কনান কে তমাম বাশিংদে হিম্মত হার গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","দহশত ঔর খ়ৌফ় উন পর ছা গযা। তেরী অজ়ীম ক়ুদরত কে বাইস ৱহ পত্থর কী তরহ জম গএ। ঐ রব, ৱহ ন হিলে জব তক তেরী ক়ৌম গুজ়র ন গঈ। ৱহ বেহিসো-হরকত রহে জব তক তেরী খ়রীদী হুঈ ক়ৌম গুজ়র ন গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ঐ রব, তূ অপনে লোগোং কো লেকর পৌদোং কী তরহ অপনে মৌরূসী পহাড় পর লগাএগা, উস জগহ পর জো তূনে অপনী সুকূনত কে লিএ চুন লী হৈ, জহাঁ তূনে অপনে হাথোং সে অপনা মক়দিস তৈযার কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","রব অবদ তক বাদশাহ হৈ!” ");
INSERT INTO urdgvb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","জব ফ়িরৌন কে ঘোড়ে, রথ ঔর ঘুড়সৱার সমুংদর মেং চলে গএ তো রব নে উন্হেং সমুংদর কে পানী সে ঢাঁক লিযা। লেকিন ইসরাঈলী খ়ুশ্ক জ়মীন পর সমুংদর মেং সে গুজ়র গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","তব হারূন কী বহন মরিযম জো নবিযা থী নে দফ় লিযা, ঔর বাক়ী তমাম ঔরতেং ভী দফ় লেকর উসকে পীছে হো লীং। সব গানে ঔর নাচনে লগীং। মরিযম নে যহ গাকর উনকী রাহনুমাঈ কী, ");
INSERT INTO urdgvb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“রব কী তমজীদ মেং গীত গাও, ক্যোংকি ৱহ নিহাযত অজ়ীম হৈ। ঘোড়ে ঔর উসকে সৱার কো উসনে সমুংদর মেং পটখ় দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","মূসা কে কহনে পর ইসরাঈলী বহরে-ক়ুলজ়ুম সে রৱানা হোকর দশ্তে-শূর মেং চলে গএ। ৱহাঁ ৱহ তীন দিন তক সফ়র করতে রহে। ইস দৌরান উন্হেং পানী ন মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","আখ়িরকার ৱহ মারা পহুঁচে জহাঁ পানী দস্তযাব থা। লেকিন ৱহ কড়ৱা থা, ইসলিএ মক়াম কা নাম মারা যানী কড়ৱাহট পড় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","যহ দেখকর লোগ মূসা কে খ়িলাফ় বুড়বুড়াকর কহনে লগে, “হম ক্যা পিএঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","মূসা নে মদদ কে লিএ রব সে ইল্তিজা কী তো উসনে উসে লকড়ী কা এক টুকড়া দিখাযা। জব মূসা নে যহ লকড়ী পানী মেং ডালী তো পানী কী কড়ৱাহট খ়ত্ম হো গঈ। মারা মেং রব নে অপনী ক়ৌম কো ক়ৱানীন দিএ। ৱহাঁ উসনে উন্হেং আজ়মাযা ভী। ");
INSERT INTO urdgvb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","উসনে কহা, “গ়ৌর সে রব অপনে খ়ুদা কী আৱাজ় সুনো! জো কুছ উস কী নজ়র মেং দুরুস্ত হৈ ৱহী করো। উসকে অহকাম পর ধ্যান দো ঔর উস কী তমাম হিদাযাত পর অমল করো। ফির মৈং তুম পর ৱহ বীমারিযাঁ নহীং লাঊঁগা জো মিসরিযোং পর লাযা থা, ক্যোংকি মৈং রব হূঁ জো তুঝে শফ়া দেতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ফির ইসরাঈলী রৱানা হোকর এলীম পহুঁচে জহাঁ 12 চশ্মে ঔর খজূর কে 70 দরখ়্ত থে। ৱহাঁ উন্হোংনে পানী কে ক়রীব অপনে খ়ৈমে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ইসকে বাদ ইসরাঈল কী পূরী জমাত এলীম সে সফ়র করকে সীন কে রেগিস্তান মেং পহুঁচী জো এলীম ঔর সীনা কে দরমিযান হৈ। ৱহ মিসর সে নিকলনে কে বাদ দূসরে মহীনে কে 15ৱেং দিন পহুঁচে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","রেগিস্তান মেং তমাম লোগ ফির মূসা ঔর হারূন কে খ়িলাফ় বুড়বুড়ানে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","উন্হোংনে কহা, “কাশ রব হমেং মিসর মেং হী মার ডালতা! ৱহাঁ হম কম অজ় কম জী ভরকর গোশ্ত ঔর রোটী তো খা সকতে থে। আপ হমেং সির্ফ় ইসলিএ রেগিস্তান মেং লে আএ হৈং কি হম সব ভূকে মর জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","তব রব নে মূসা সে কহা, “মৈং আসমান সে তুম্হারে লিএ রোটী বরসাঊঁগা। হর রোজ় লোগ বাহর জাকর উসী দিন কী জ়রূরত কে মুতাবিক় খানা জমা করেং। ইসসে মৈং উন্হেং আজ়মাকর দেখূঁগা কি আযা ৱহ মেরী সুনতে হৈং কি নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","হর রোজ় ৱহ সির্ফ় উতনা খানা জমা করেং জিতনা কি এক দিন কে লিএ কাফ়ী হো। লেকিন ছটে দিন জব ৱহ খানা তৈযার করেংগে তো ৱহ অগলে দিন কে লিএ ভী কাফ়ী হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","মূসা ঔর হারূন নে ইসরাঈলিযোং সে কহা, “আজ শাম কো তুম জান লোগে কি রব হী তুম্হেং মিসর সে নিকাল লাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ঔর কল সুবহ তুম রব কা জলাল দেখোগে। উসনে তুম্হারী শিকাযতেং সুন লী হৈং, ক্যোংকি অসল মেং তুম হমারে খ়িলাফ় নহীং বল্কি রব কে খ়িলাফ় বুড়বুড়া রহে হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ফির ভী রব তুমকো শাম কে ৱক়্ত গোশ্ত ঔর সুবহ কে ৱক়্ত ৱাফ়ির রোটী দেগা, ক্যোংকি উসনে তুম্হারী শিকাযতেং সুন লী হৈং। তুম্হারী শিকাযতেং হমারে খ়িলাফ় নহীং বল্কি রব কে খ়িলাফ় হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","মূসা নে হারূন সে কহা, “ইসরাঈলিযোং কো বতানা, ‘রব কে সামনে হাজ়ির হো জাও, ক্যোংকি উসনে তুম্হারী শিকাযতেং সুন লী হৈং’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","জব হারূন পূরী জমাত কে সামনে বাত করনে লগা তো লোগোং নে পলটকর রেগিস্তান কী তরফ় দেখা। ৱহাঁ রব কা জলাল বাদল মেং জ়াহির হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“মৈংনে ইসরাঈলিযোং কী শিকাযত সুন লী হৈ। উন্হেং বতা, ‘আজ জব সূরজ গ়ুরূব হোনে লগেগা তো তুম গোশ্ত খাওগে ঔর কল সুবহ পেট ভরকর রোটী। ফির তুম জান লোগে কি মৈং রব তুম্হারা খ়ুদা হূঁ’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","উসী শাম বটেরোং কে গ়োল আএ জো পূরী খ়ৈমাগাহ পর ছা গএ। ঔর অগলী সুবহ খ়ৈমে কে চারোং তরফ় ওস পড়ী থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","জব ওস সূখ গঈ তো বর্ফ় কে গালোং জৈসে পতলে দানে পালে কী তরহ জ়মীন পর পড়ে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","জব ইসরাঈলিযোং নে উসে দেখা তো এক দূসরে সে পূছনে লগে, “মন হূ?” যানী “যহ ক্যা হৈ?” ক্যোংকি ৱহ নহীং জানতে থে কি যহ ক্যা চীজ় হৈ। মূসা নে উনকো সমঝাযা, “যহ ৱহ রোটী হৈ জো রব নে তুম্হেং খানে কে লিএ দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","রব কা হুক্ম হৈ কি হর এক উতনা জমা করে জিতনা উসকে খ়ানদান কো জ়রূরত হো। অপনে খ়ানদান কে হর ফ়রদ কে লিএ দো লিটর জমা করো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ইসরাঈলিযোং নে ঐসা হী কিযা। বাজ় নে জ়্যাদা ঔর বাজ় নে কম জমা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","লেকিন জব উসে নাপা গযা তো হর এক আদমী কে লিএ কাফ়ী থা। জিসনে জ়্যাদা জমা কিযা থা উসকে পাস কুছ ন বচা। লেকিন জিসনে কম জমা কিযা থা উসকে পাস ভী কাফ়ী থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","মূসা নে হুক্ম দিযা, “অগলে দিন কে লিএ খানা ন বচানা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","লেকিন লোগোং নে মূসা কী বাত ন মানী বল্কি বাজ় নে খানা বচা লিযা। লেকিন অগলী সুবহ মালূম হুআ কি বচে হুএ খানে মেং কীড়ে পড় গএ হৈং ঔর উসসে বহুত বদবূ আ রহী হৈ। যহ সুনকর মূসা উনসে নারাজ় হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","হর সুবহ হর কোঈ উতনা জমা কর লেতা জিতনী উসে জ়রূরত হোতী থী। জব ধূপ তেজ় হোতী তো জো কুছ জ়মীন পর রহ জাতা ৱহ পিঘলকর খ়ত্ম হো জাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ছটে দিন জব লোগ যহ খ়ুরাক জমা করতে তো ৱহ মিক়দার মেং দুগনী হোতী থী যানী হর ফ়রদ কে লিএ চার লিটর। জব জমাত কে বুজ়ুর্গোং নে মূসা কে পাস আকর উসে ইত্তলা দী ");
INSERT INTO urdgvb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","তো উসনে উনসে কহা, “রব কা ফ়রমান হৈ কি কল আরাম কা দিন হৈ, মুক়দ্দস সবত কা দিন জো অল্লাহ কী তাজ়ীম মেং মনানা হৈ। আজ তুম জো তনূর মেং পকানা চাহতে হো পকা লো ঔর জো উবালনা চাহতে হো উবাল লো। জো বচ জাএ উসে কল কে লিএ মহফ়ূজ় রখো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","লোগোং নে মূসা কে হুক্ম কে মুতাবিক় অগলে দিন কে লিএ খানা মহফ়ূজ় কর লিযা তো ন খানে সে বদবূ আঈ, ন উসমেং কীড়ে পড়ে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","মূসা নে কহা, “আজ যহী বচা হুআ খানা খাও, ক্যোংকি আজ সবত কা দিন হৈ, রব কী তাজ়ীম মেং আরাম কা দিন। আজ তুম্হেং রেগিস্তান মেং কুছ নহীং মিলেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ছঃ দিন কে দৌরান যহ খ়ুরাক জমা করনা হৈ, লেকিন সাতৱাঁ দিন আরাম কা দিন হৈ। উস দিন জ়মীন পর খানে কে লিএ কুছ নহীং হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","তো ভী কুছ লোগ হফ়তে কো খানা জমা করনে কে লিএ নিকলে, লেকিন উন্হেং কুছ ন মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","তব রব নে মূসা সে কহা, “তুম লোগ কব তক মেরে অহকাম ঔর হিদাযাত পর অমল করনে সে ইনকার করোগে? ");
INSERT INTO urdgvb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","দেখো, রব নে তুম্হারে লিএ মুক়র্রর কিযা হৈ কি সবত কা দিন আরাম কা দিন হৈ। ইসলিএ ৱহ তুম্হেং জুমে কো দো দিন কে লিএ খ়ুরাক দেতা হৈ। হফ়তে কো সবকো অপনে খ়ৈমোং মেং রহনা হৈ। কোঈ ভী অপনে ঘর সে বাহর ন নিকলে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","চুনাঁচে লোগ সবত কে দিন আরাম করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ইসরাঈলিযোং নে ইস খ়ুরাক কা নাম ‘মন’ রখা। উসকে দানে ধনিযে কী মানিংদ সফ়েদ থে, ঔর উসকা জ়াযক়া শহদ সে বনে কেক কী মানিংদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","মূসা নে কহা, “রব ফ়রমাতা হৈ, ‘দো লিটর মন এক মরতবান মেং রখকর উসে আনেৱালী নসলোং কে লিএ মহফ়ূজ় রখনা। ফির ৱহ দেখ সকেংগে কি মৈং তুম্হেং ক্যা খানা খিলাতা রহা জব তুম্হেং মিসর সে নিকাল লাযা’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","মূসা নে হারূন সে কহা, “এক মরতবান লো ঔর উসে দো লিটর মন সে ভরকর রব কে সামনে রখো তাকি ৱহ আনেৱালী নসলোং কে লিএ মহফ়ূজ় রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","হারূন নে ঐসা হী কিযা। উসনে মন কে ইস মরতবান কো অহদ কে সংদূক় কে সামনে রখা তাকি ৱহ মহফ়ূজ় রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ইসরাঈলিযোং কো 40 সাল তক মন মিলতা রহা। ৱহ উস ৱক়্ত তক মন খাতে রহে জব তক রেগিস্তান সে নিকলকর কনান কী সরহদ পর ন পহুঁচে। ");
INSERT INTO urdgvb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(জো পৈমানা ইসরাঈলী মন কে লিএ ইস্তেমাল করতে থে ৱহ দো লিটর কা এক বরতন থা জিসকা নাম ওমর থা।) ");
INSERT INTO urdgvb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ফির ইসরাঈল কী পূরী জমাত সীন কে রেগিস্তান সে নিকলী। রব জিস তরহ হুক্ম দেতা রহা ৱহ এক জগহ সে দূসরী জগহ সফ়র করতে রহে। রফ়ীদীম মেং উন্হোংনে খ়ৈমে লগাএ। ৱহাঁ পীনে কে লিএ পানী ন মিলা। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ইসলিএ ৱহ মূসা কে সাথ যহ কহকর ঝগড়নে লগে, “হমেং পীনে কে লিএ পানী দো।” মূসা নে জৱাব দিযা, “তুম মুঝসে ক্যোং ঝগড় রহে হো? রব কো ক্যোং আজ়মা রহে হো?” ");
INSERT INTO urdgvb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","লেকিন লোগ বহুত প্যাসে থে। ৱহ মূসা কে খ়িলাফ় বুড়বুড়ানে সে বাজ় ন আএ বল্কি কহা, “আপ হমেং মিসর সে ক্যোং লাএ হৈং? ক্যা ইসলিএ কি হম অপনে বচ্চোং ঔর রেৱড়োং সমেত প্যাসে মর জাএঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","তব মূসা নে রব কে হুজ়ূর ফ়রিযাদ কী, “মৈং ইন লোগোং কে সাথ ক্যা করূঁ? হালাত জ়রা ভী ঔর বিগড় জাএঁ তো ৱহ মুঝে সংগসার কর দেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","রব নে মূসা সে কহা, “কুছ বুজ়ুর্গ সাথ লেকর লোগোং কে আগে আগে চল। ৱহ লাঠী ভী সাথ লে জা জিসসে তূনে দরিযাএ-নীল কো মারা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","মৈং হোরিব যানী সীনা পহাড় কী এক চট্টান পর তেরে সামনে খড়া হূঁগা। লাঠী সে চট্টান কো মারনা তো উসসে পানী নিকলেগা ঔর লোগ পী সকেংগে।” মূসা নে ইসরাঈল কে বুজ়ুর্গোং কে সামনে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","উসনে উস জগহ কা নাম মস্সা ঔর মরীবা যানী ‘আজ়মানা ঔর ঝগড়না’ রখা, ক্যোংকি ৱহাঁ ইসরাঈলী বুড়বুড়াএ ঔর যহ পূছকর রব কো আজ়মাযা কি ক্যা রব হমারে দরমিযান হৈ কি নহীং? ");
INSERT INTO urdgvb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","রফ়ীদীম ৱহ জগহ ভী থী জহাঁ অমালীক়ী ইসরাঈলিযোং সে লড়নে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","মূসা নে যশুঅ সে কহা, “লড়নে কে ক়াবিল আদমিযোং কো চুন লো ঔর নিকলকর অমালীক়িযোং কা মুক়াবলা করো। কল মৈং অল্লাহ কী লাঠী পকড়ে হুএ পহাড় কী চোটী পর খড়া হো জাঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","যশুঅ মূসা কী হিদাযত কে মুতাবিক় অমালীক়িযোং সে লড়নে গযা জবকি মূসা, হারূন ঔর হূর পহাড় কী চোটী পর চঢ় গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ঔর যোং হুআ কি জব মূসা কে হাথ উঠাএ হুএ থে তো ইসরাঈলী জীততে রহে, ঔর জব ৱহ নীচে থে তো অমালীক়ী জীততে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","কুছ দের কে বাদ মূসা কে বাজ়ূ থক গএ। ইসলিএ হারূন ঔর হূর এক চট্টান লে আএ তাকি ৱহ উস পর বৈঠ জাএ। ফির উন্হোংনে উসকে দাঈং ঔর বাঈং তরফ় খড়ে হোকর উসকে বাজ়ুওং কো ঊপর উঠাএ রখা। সূরজ কে গ়ুরূব হোনে তক উন্হোংনে যোং মূসা কী মদদ কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ইস তরহ যশুঅ নে অমালীক়িযোং সে লড়তে লড়তে উন্হেং শিকস্ত দী। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","তব রব নে মূসা সে কহা, “যহ ৱাক়িযা যাদগারী কে লিএ কিতাব মেং লিখ লে। লাজ়িম হৈ কি যহ সব কুছ যশুঅ কী যাদ মেং রহে, ক্যোংকি মৈং দুনিযা সে অমালীক়িযোং কা নামো-নিশান মিটা দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","উস ৱক়্ত মূসা নে ক়ুরবানগাহ বনাকর উসকা নাম ‘রব মেরা ঝংডা হৈ’ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","উসনে কহা, “রব কে তখ়্ত কে খ়িলাফ় হাথ উঠাযা গযা হৈ, ইসলিএ রব কী অমালীক়িযোং সে হমেশা তক জংগ রহেগী।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","মূসা কা সুসর যিতরো অব তক মিদিযান মেং ইমাম থা। জব উসনে সব কুছ সুনা জো অল্লাহ নে মূসা ঔর অপনী ক়ৌম কে লিএ কিযা হৈ, কি ৱহ উন্হেং মিসর সে নিকাল লাযা হৈ ");
INSERT INTO urdgvb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","তো ৱহ মূসা কে পাস আযা। ৱহ উস কী বীৱী সফ়্ফ়ূরা কো অপনে সাথ লাযা, ক্যোংকি মূসা নে উসে অপনে বেটোং সমেত মৈকে ভেজ দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","যিতরো মূসা কে দোনোং বেটোং কো ভী সাথ লাযা। পহলে বেটে কা নাম জৈরসোম যানী ‘অজনবী মুল্ক মেং পরদেসী’ থা, ক্যোংকি জব ৱহ পৈদা হুআ তো মূসা নে কহা থা, “মৈং অজনবী মুল্ক মেং পরদেসী হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","দূসরে বেটে কা নাম ইলিযজ়র যানী ‘মেরা খ়ুদা মদদগার হৈ’ থা, ক্যোংকি জব ৱহ পৈদা হুআ তো মূসা নে কহা থা, “মেরে বাপ কে খ়ুদা নে মেরী মদদ করকে মুঝে ফ়িরৌন কী তলৱার সে বচাযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","যিতরো মূসা কী বীৱী ঔর বেটে সাথ লেকর উস ৱক়্ত মূসা কে পাস পহুঁচা জব উসনে রেগিস্তান মেং অল্লাহ কে পহাড় যানী সীনা কে ক়রীব খ়ৈমা লগাযা হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","উসনে মূসা কো পৈগ়াম ভেজা থা, “মৈং, আপকা সুসর যিতরো আপকী বীৱী ঔর দো বেটোং কো সাথ লেকর আপকে পাস আ রহা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","মূসা অপনে সুসর কে ইস্তক়বাল কে লিএ বাহর নিকলা, উসকে সামনে ঝুকা ঔর উসে বোসা দিযা। দোনোং নে এক দূসরে কা হাল পূছা, ফির খ়ৈমে মেং চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","মূসা নে যিতরো কো তফ়সীল সে বতাযা কি রব নে ইসরাঈলিযোং কী খ়াতির ফ়িরৌন ঔর মিসরিযোং কে সাথ ক্যা কুছ কিযা হৈ। উসনে রাস্তে মেং পেশ আঈ তমাম মুশ্কিলাত কা জ়িক্র ভী কিযা কি রব নে হমেং কিস তরহ উনসে বচাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","যিতরো উন সারে অচ্ছে কামোং কে বারে মেং সুনকর খ়ুশ হুআ জো রব নে ইসরাঈলিযোং কে লিএ কিএ থে জব উসনে উন্হেং মিসরিযোং কে হাথ সে বচাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","উসনে কহা, “রব কী তমজীদ হো জিসনে আপকো মিসরিযোং ঔর ফ়িরৌন কে ক়ব্জ়ে সে নজাত দিলাঈ হৈ। উসী নে ক়ৌম কো গ়ুলামী সে ছুড়াযা হৈ! ");
INSERT INTO urdgvb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","অব মৈংনে জান লিযা হৈ কি রব তমাম মাবূদোং সে অজ়ীম হৈ, ক্যোংকি উসনে যহ সব কুছ উন লোগোং কে সাথ কিযা জিন্হোংনে অপনে গ়ুরূর মেং ইসরাঈলিযোং কে সাথ বুরা সুলূক কিযা থা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ফির যিতরো নে অল্লাহ কো ভস্ম হোনেৱালী ক়ুরবানী ঔর দীগর কঈ ক়ুরবানিযাঁ পেশ কীং। তব হারূন ঔর তমাম বুজ়ুর্গ মূসা কে সুসর যিতরো কে সাথ অল্লাহ কে হুজ়ূর খানা খানে বৈঠে। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","অগলে দিন মূসা লোগোং কা ইনসাফ় করনে কে লিএ বৈঠ গযা। উনকী তাদাদ ইতনী জ়্যাদা থী কি ৱহ সুবহ সে লেকর শাম তক মূসা কে সামনে খড়ে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","জব যিতরো নে যহ সব কুছ দেখা তো উসনে পূছা, “যহ ক্যা হৈ জো আপ লোগোং কে সাথ কর রহে হৈং? সারা দিন ৱহ আপকো ঘেরে রহতে ঔর আপ উনকী অদালত করতে রহতে হৈং। আপ যহ সব কুছ অকেলে হী ক্যোং কর রহে হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","মূসা নে জৱাব দিযা, “লোগ মেরে পাস আকর অল্লাহ কী মরজ়ী মালূম করতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","জব কভী কোঈ তনাজ়া যা ঝগড়া হোতা হৈ তো দোনোং পার্টিযাঁ মেরে পাস আতী হৈং। মৈং ফ়ৈসলা করকে উন্হেং অল্লাহ কে অহকাম ঔর হিদাযাত বতাতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","মূসা কে সুসর নে উসসে কহা, “আপকা তরীক়া অচ্ছা নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","কাম ইতনা ৱসী হৈ কি আপ উসে অকেলে নহীং সঁভাল সকতে। ইসসে আপ ঔর ৱহ লোগ জো আপকে পাস আতে হৈং বুরী তরহ থক জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","মেরী বাত সুনেং! মৈং আপকো এক মশৱরা দেতা হূঁ। অল্লাহ উসমেং আপকী মদদ করে। লাজ়িম হৈ কি আপ অল্লাহ কে সামনে ক়ৌম কে নুমাইংদে রহেং ঔর উনকে মামলাত উসকে সামনে পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","যহ ভী জ়রূরী হৈ কি আপ উন্হেং অল্লাহ কে অহকাম ঔর হিদাযাত সিখাএঁ, কি ৱহ কিস তরহ জ়িংদগী গুজ়ারেং ঔর ক্যা ক্যা করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","লেকিন সাথ সাথ ক়ৌম মেং সে ক়াবিলে-এতমাদ আদমী চুনেং। ৱহ ঐসে লোগ হোং জো অল্লাহ কা খ়ৌফ় মানতে হোং, রাস্তদিল হোং ঔর রিশ্ৱত সে নফ়রত করতে হোং। উন্হেং হজ়ার হজ়ার, সৌ সৌ, পচাস পচাস ঔর দস দস আদমিযোং পর মুক়র্রর করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","উন আদমিযোং কী জ়িম্মাদারী যহ হোগী কি ৱহ হর ৱক়্ত লোগোং কা ইনসাফ় করেং। অগর কোঈ বহুত হী পেচীদা মামলা হো তো ৱহ ফ়ৈসলে কে লিএ আপকে পাস আএঁ, লেকিন দীগর মামলোং কা ফ়ৈসলা ৱহ খ়ুদ করেং। যোং ৱহ কাম মেং আপকা হাথ বটাএঁগে ঔর আপকা বোঝ হলকা হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","অগর মেরা যহ মশৱরা অল্লাহ কী মরজ়ী কে মুতাবিক় হো ঔর আপ ঐসা করেং তো আপ অপনী জ়িম্মাদারী নিভা সকেংগে ঔর যহ তমাম লোগ ইনসাফ় কে মিলনে পর সলামতী কে সাথ অপনে অপনে ঘর জা সকেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","মূসা নে অপনে সুসর কা মশৱরা মান লিযা ঔর ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","উসনে ইসরাঈলিযোং মেং সে ক়াবিলে-এতমাদ আদমী চুনে ঔর উন্হেং হজ়ার হজ়ার, সৌ সৌ, পচাস পচাস ঔর দস দস আদমিযোং পর মুক়র্রর কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","যহ মর্দ ক়াজ়ী বনকর মুস্তক়িল তৌর পর লোগোং কা ইনসাফ় করনে লগে। আসান মসলোং কা ফ়ৈসলা ৱহ খ়ুদ করতে ঔর মুশ্কিল মামলোং কো মূসা কে পাস লে আতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","কুছ অরসে বাদ মূসা নে অপনে সুসর কো রুখ়সত কিযা তো যিতরো অপনে ৱতন ৱাপস চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ইসরাঈলিযোং কো মিসর সে সফ়র করতে হুএ দো মহীনে হো গএ থে। তীসরে মহীনে কে পহলে হী দিন ৱহ সীনা কে রেগিস্তান মেং পহুঁচে। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","উস দিন ৱহ রফ়ীদীম কো ছোড়কর দশ্তে-সীনা মেং আ পহুঁচে। ৱহাঁ উন্হোংনে রেগিস্তান মেং পহাড় কে ক়রীব ডেরে ডালে। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","তব মূসা পহাড় পর চঢ়কর অল্লাহ কে পাস গযা। অল্লাহ নে পহাড় পর সে মূসা কো পুকারকর কহা, “যাক়ূব কে ঘরানে বনী ইসরাঈল কো বতা, ");
INSERT INTO urdgvb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘তুমনে দেখা হৈ কি মৈংনে মিসরিযোং কে সাথ ক্যা কুছ কিযা, ঔর কি মৈং তুমকো উক়াব কে পরোং পর উঠাকর যহাঁ অপনে পাস লাযা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","চুনাঁচে অগর তুম মেরী সুনো ঔর মেরে অহদ কে মুতাবিক় চলো তো ফির তমাম ক়ৌমোং মেং সে মেরী খ়াস মিলকিযত হোগে। গো পূরী দুনিযা মেরী হী হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","লেকিন তুম মেরে লিএ মখ়সূস ইমামোং কী বাদশাহী ঔর মুক়দ্দস ক়ৌম হোগে।’ অব জাকর যহ সারী বাতেং ইসরাঈলিযোং কো বতা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","মূসা নে পহাড় সে উতরকর ঔর ক়ৌম কে বুজ়ুর্গোং কো বুলাকর উন্হেং ৱহ তমাম বাতেং বতাঈং জো কহনে কে লিএ রব নে উসে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","জৱাব মেং পূরী ক়ৌম নে মিলকর কহা, “হম রব কী হর বাত পূরী করেংগে জো উসনে ফ়রমাঈ হৈ।” মূসা নে পহাড় পর লৌটকর রব কো ক়ৌম কা জৱাব বতাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","জব ৱহ পহুঁচা তো রব নে মূসা সে কহা, “মৈং ঘনে বাদল মেং তেরে পাস আঊঁগা তাকি লোগ মুঝে তুঝসে হমকলাম হোতে হুএ সুনেং। ফির ৱহ হমেশা তুঝ পর ভরোসা রখেংগে।” তব মূসা নে রব কো ৱহ তমাম বাতেং বতাঈং জো লোগোং নে কী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","রব নে মূসা সে কহা, “অব লোগোং কে পাস লৌটকর আজ ঔর কল উন্হেং মেরে লিএ মখ়সূসো-মুক়দ্দস কর। ৱহ অপনে লিবাস ধোকর ");
INSERT INTO urdgvb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","তীসরে দিন কে লিএ তৈযার হো জাএঁ, ক্যোংকি উস দিন রব লোগোং কে দেখতে দেখতে কোহে-সীনা পর উতরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","লোগোং কী হিফ়াজ়ত কে লিএ চারোং তরফ় পহাড় কী হদ্দেং মুক়র্রর কর। উন্হেং খ়বরদার কর কি হুদূদ কো পার ন করো। ন পহাড় পর চঢ়ো, ন উসকে দামন কো ছুও। জো ভী উসে ছুএ ৱহ জ়রূর মারা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ঔর উসে হাথ সে ছূকর নহীং মারনা হৈ বল্কি পত্থরোং যা তীরোং সে। খ়াহ ইনসান হো যা হৈৱান, ৱহ জ়িংদা নহীং রহ সকতা। জব তক নরসিংগা দের তক ফূঁকা ন জাএ উস ৱক়্ত তক লোগোং কো পহাড় পর চঢ়নে কী ইজাজ়ত নহীং হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","মূসা নে পহাড় সে উতরকর লোগোং কো অল্লাহ কে লিএ মখ়সূসো-মুক়দ্দস কিযা। উন্হোংনে অপনে লিবাস ভী ধোএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","উসনে উনসে কহা, “তীসরে দিন কে লিএ তৈযার হো জাও। মর্দ ঔরতোং সে হমবিসতর ন হোং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","তীসরে দিন সুবহ পহাড় পর ঘনা বাদল ছা গযা। বিজলী চমকনে লগী, বাদল গরজনে লগা ঔর নরসিংগে কী নিহাযত জ়োরদার আৱাজ় সুনাঈ দী। খ়ৈমাগাহ মেং লোগ লরজ় উঠে। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","তব মূসা লোগোং কো অল্লাহ সে মিলনে কে লিএ খ়ৈমাগাহ সে বাহর পহাড় কী তরফ় লে গযা, ঔর ৱহ পহাড় কে দামন মেং খড়ে হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","সীনা পহাড় ধুএঁ সে ঢকা হুআ থা, ক্যোংকি রব আগ মেং উস পর উতর আযা। পহাড় সে ধুআঁ ইস তরহ উঠ রহা থা জৈসে কিসী ভট্টে সে উঠতা হৈ। পূরা পহাড় শিদ্দত সে লরজ়নে লগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","নরসিংগে কী আৱাজ় তেজ় সে তেজ়তর হোতী গঈ। মূসা বোলনে লগা ঔর অল্লাহ উসে ঊঁচী আৱাজ় মেং জৱাব দেতা রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","রব সীনা পহাড় কী চোটী পর উতরা ঔর মূসা কো ঊপর আনে কে লিএ কহা। মূসা ঊপর চঢ়া। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","রব নে মূসা সে কহা, “ফ়ৌরন নীচে উতরকর লোগোং কো খ়বরদার কর কি ৱহ মুঝে দেখনে কে লিএ পহাড় কী হুদূদ মেং জ়বরদস্তী দাখ়িল ন হোং। অগর ৱহ ঐসা করেং তো বহুত-সে হলাক হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ইমাম ভী জো রব কে হুজ়ূর আতে হৈং অপনে আপকো মখ়সূসো-মুক়দ্দস করেং, ৱরনা মেরা গ়জ়ব উন পর টূট পড়েগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","লেকিন মূসা নে রব সে কহা, “লোগ পহাড় পর নহীং আ সকতে, ক্যোংকি তূনে খ়ুদ হী হমেং খ়বরদার কিযা কি হম পহাড় কী হদ্দেং মুক়র্রর করকে উসে মখ়সূসো-মুক়দ্দস করেং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","রব নে জৱাব দিযা, “তো ভী উতর জা ঔর হারূন কো সাথ লেকর ৱাপস আ। লেকিন ইমামোং ঔর লোগোং কো মত আনে দে। অগর ৱহ জ়বরদস্তী মেরে পাস আএঁ তো মেরা গ়জ়ব উন পর টূট পড়েগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","মূসা নে লোগোং কে পাস উতরকর উন্হেং যহ বাতেং বতা দীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","তব অল্লাহ নে যহ তমাম বাতেং ফ়রমাঈং, ");
INSERT INTO urdgvb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“মৈং রব তেরা খ়ুদা হূঁ জো তুঝে মুল্কে-মিসর কী গ়ুলামী সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","মেরে সিৱা কিসী ঔর মাবূদ কী পরস্তিশ ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","অপনে লিএ বুত ন বনানা। কিসী ভী চীজ় কী মূরত ন বনানা, চাহে ৱহ আসমান মেং, জ়মীন পর যা সমুংদর মেং হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ন বুতোং কী পরস্তিশ, ন উনকী খ়িদমত করনা, ক্যোংকি মৈং তেরা রব গ়যূর খ়ুদা হূঁ। জো মুঝসে নফ়রত করতে হৈং উন্হেং মৈং তীসরী ঔর চৌথী পুশ্ত তক সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","লেকিন জো মুঝসে মুহব্বত রখতে ঔর মেরে অহকাম পূরে করতে হৈং উন পর মৈং হজ়ার পুশ্তোং তক মেহরবানী করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","রব অপনে খ়ুদা কা নাম বেমক়সদ যা গ়লত মক়সদ কে লিএ ইস্তেমাল ন করনা। জো ভী ঐসা করতা হৈ উসে রব সজ়া দিএ বগ়ৈর নহীং ছোড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","সবত কে দিন কা খ়যাল রখনা। উসে ইস তরহ মনানা কি ৱহ মখ়সূসো-মুক়দ্দস হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","হফ়তে কে পহলে ছঃ দিন অপনা কাম-কাজ কর, ");
INSERT INTO urdgvb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","লেকিন সাতৱাঁ দিন রব তেরে খ়ুদা কা আরাম কা দিন হৈ। উস দিন কিসী তরহ কা কাম ন করনা। ন তূ, ন তেরা বেটা, ন তেরী বেটী, ন তেরা নৌকর, ন তেরী নৌকরানী ঔর ন তেরে মৱেশী। জো পরদেসী তেরে দরমিযান রহতা হৈ ৱহ ভী কাম ন করে। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ক্যোংকি রব নে পহলে ছঃ দিন মেং আসমানো-জ়মীন, সমুংদর ঔর জো কুছ উনমেং হৈ বনাযা লেকিন সাতৱেং দিন আরাম কিযা। ইসলিএ রব নে সবত কে দিন কো বরকত দেকর মুক়র্রর কিযা কি ৱহ মখ়সূস ঔর মুক়দ্দস হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","অপনে বাপ ঔর অপনী মাঁ কী ইজ়্জ়ত করনা। ফির তূ উস মুল্ক মেং জো রব তেরা খ়ুদা তুঝে দেনেৱালা হৈ দের তক জীতা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ক়ত্ল ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","জ়িনা ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","চোরী ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","অপনে পড়োসী কে বারে মেং ঝূটী গৱাহী ন দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","অপনে পড়োসী কে ঘর কা লালচ ন করনা। ন উস কী বীৱী কা, ন উসকে নৌকর কা, ন উস কী নৌকরানী কা, ন উসকে বৈল ঔর ন উসকে গধে কা বল্কি উস কী কিসী ভী চীজ় কা লালচ ন করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","জব বাক়ী তমাম লোগোং নে বাদল কী গরজ ঔর নরসিংগে কী আৱাজ় সুনী ঔর বিজলী কী চমক ঔর পহাড় সে উঠতে হুএ ধুএঁ কো দেখা তো ৱহ খ়ৌফ় কে মারে কাঁপনে লগে ঔর পহাড় সে দূর খড়ে হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","উন্হোংনে মূসা সে কহা, “আপ হী হমসে বাত করেং তো হম সুনেংগে। লেকিন অল্লাহ কো হমসে বাত ন করনে দেং ৱরনা হম মর জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","লেকিন মূসা নে উনসে কহা, “মত ডরো, ক্যোংকি রব তুম্হেং জাঁচনে কে লিএ আযা হৈ, তাকি উসকা খ়ৌফ় তুম্হারী আঁখোং কে সামনে রহে ঔর তুম গুনাহ ন করো।” ");
INSERT INTO urdgvb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","লোগ দূর হী রহে জবকি মূসা উস গহরী তারীকী কে ক়রীব গযা জহাঁ অল্লাহ থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","তব রব নে মূসা সে কহা, “ইসরাঈলিযোং কো বতা, ‘তুমনে খ়ুদ দেখা কি মৈংনে আসমান পর সে তুম্হারে সাথ বাতেং কী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","চুনাঁচে মেরী পরস্তিশ কে সাথ সাথ অপনে লিএ সোনে যা চাঁদী কে বুত ন বনাও। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","মেরে লিএ মিট্টী কী ক়ুরবানগাহ বনাকর উস পর অপনী ভেড়-বকরিযোং ঔর গায-বৈলোং কী ভস্ম হোনেৱালী ঔর সলামতী কী ক়ুরবানিযাঁ চঢ়ানা। মৈং তুঝে ৱহ জগহেং দিখাঊঁগা জহাঁ মেরে নাম কী তাজ়ীম মেং ক়ুরবানিযাঁ পেশ করনী হৈং। ঐসী তমাম জগহোং পর মৈং তেরে পাস আকর তুঝে বরকত দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","অগর তূ মেরে লিএ ক়ুরবানগাহ বনানে কী খ়াতির পত্থর ইস্তেমাল করনা চাহে তো তরাশে হুএ পত্থর ইস্তেমাল ন করনা। ক্যোংকি তূ তরাশনে কে লিএ ইস্তেমাল হোনেৱালে ঔজ়ার সে উস কী বেহুরমতী করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ক়ুরবানগাহ কো সীঢ়িযোং কে বগ়ৈর বনানা হৈ তাকি উস পর চঢ়নে সে তেরে লিবাস কে নীচে সে তেরা নংগাপন নজ়র ন আএ।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ইসরাঈলিযোং কো যহ অহকাম বতা, ");
INSERT INTO urdgvb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘অগর তূ ইবরানী গ়ুলাম খ়রীদে তো ৱহ ছঃ সাল তেরা গ়ুলাম রহে। ইসকে বাদ লাজ়িম হৈ কি উসে আজ়াদ কর দিযা জাএ। আজ়াদ হোনে কে লিএ উসে পৈসে দেনে কী জ়রূরত নহীং হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","অগর গ়ুলাম গ়ৈরশাদীশুদা হালত মেং মালিক কে ঘর আযা হো তো ৱহ আজ়াদ হোকর অকেলা হী চলা জাএ। অগর ৱহ শাদীশুদা হালত মেং আযা হো তো লাজ়িম হৈ কি ৱহ অপনী বীৱী সমেত আজ়াদ হোকর জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","অগর মালিক নে গ়ুলাম কী শাদী করাঈ ঔর বচ্চে পৈদা হুএ হৈং তো উস কী বীৱী ঔর বচ্চে মালিক কী মিলকিযত হোংগে। ছঃ সাল কে বাদ জব গ়ুলাম আজ়াদ হোকর জাএ তো উস কী বীৱী ঔর বচ্চে মালিক হী কে পাস রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","অগর গ়ুলাম কহে, “মৈং অপনে মালিক ঔর অপনে বীৱী বচ্চোং সে মুহব্বত রখতা হূঁ, মৈং আজ়াদ নহীং হোনা চাহতা” ");
INSERT INTO urdgvb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","তো গ়ুলাম কা মালিক উসে অল্লাহ কে সামনে লাএ। ৱহ উসে দরৱাজ়ে যা উস কী চৌখট কে পাস লে জাএ ঔর সুতালী যানী তেজ় ঔজ়ার সে উসকে কান কী লৌ ছেদ দে। তব ৱহ জ়িংদগী-ভর উসকা গ়ুলাম বনা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","অগর কোঈ অপনী বেটী কো গ়ুলামী মেং বেচ ডালে তো উসকে লিএ আজ়াদী মিলনে কী শরাযত মর্দ সে ফ়রক় হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","অগর উসকে মালিক নে উসে মুংতখ়ব কিযা কি ৱহ উস কী বীৱী বন জাএ, লেকিন বাদ মেং ৱহ উসে পসংদ ন আএ তো লাজ়িম হৈ কি ৱহ মুনাসিব মুআৱজ়া লেকর উসে উসকে রিশ্তেদারোং কো ৱাপস কর দে। উসে ঔরত কো গ়ৈরমুল্কিযোং কে হাথ বেচনে কা ইখ়্তিযার নহীং হৈ, ক্যোংকি উসনে উসকে সাথ বেৱফ়া সুলূক কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","অগর লৌংডী কা মালিক উস কী অপনে বেটে কে সাথ শাদী করাএ তো ঔরত কো বেটী কে হুক়ূক় হাসিল হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","অগর মালিক নে উসসে শাদী করকে বাদ মেং দূসরী ঔরত সে ভী শাদী কী তো লাজ়িম হৈ কি ৱহ পহলী কো ভী খানা ঔর কপড়ে দেতা রহে। ইসকে অলাৱা উসকে সাথ হমবিসতর হোনে কা ফ়র্জ় ভী অদা করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","অগর ৱহ যহ তীন ফ়রাযজ় অদা ন করে তো উসে ঔরত কো আজ়াদ করনা পড়েগা। ইস সূরত মেং উসে মুফ়্ত আজ়াদ করনা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","জো কিসী কো জান-বূঝকর ইতনা সখ়্ত মারতা হো কি ৱহ মর জাএ তো উসে জ়রূর সজ়াএ-মৌত দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","লেকিন অগর উসনে উসে জান-বূঝকর ন মারা বল্কি যহ ইত্তফ়াক় সে হুআ ঔর অল্লাহ নে যহ হোনে দিযা, তো মারনেৱালা এক ঐসী জগহ পনাহ লে সকতা হৈ জো মৈং মুক়র্রর করূঁগা। ৱহাঁ উসে ক়ত্ল কিএ জানে কী ইজাজ়ত নহীং হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","লেকিন জো দীদা-দানিস্তা ঔর চালাকী সে কিসী কো মার ডালতা হৈ উসে মেরী ক়ুরবানগাহ সে ভী ছীনকর সজ়াএ-মৌত দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","জো অপনে বাপ যা অপনী মাঁ কো মারতা পীটতা হৈ উসে সজ়াএ-মৌত দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","জিসনে কিসী কো ইগ়ৱা কর লিযা হৈ উসে সজ়াএ-মৌত দী জাএ, চাহে ৱহ উসে গ়ুলাম বনাকর বেচ চুকা হো যা উসে অব তক অপনে পাস রখা হুআ হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","জো অপনে বাপ যা মাঁ পর লানত করে উসে সজ়াএ-মৌত দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","হো সকতা হৈ কি আদমী ঝগড়েং ঔর এক শখ়্স দূসরে কো পত্থর যা মুক্কে সে ইতনা জ়খ়মী কর দে কি গো ৱহ বচ জাএ ৱহ বিস্তর সে উঠ ন সকতা হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","অগর বাদ মেং মরীজ় যহাঁ তক শফ়া পাএ কি দুবারা উঠকর লাঠী কে সহারে চল-ফির সকে তো চোট পহুঁচানেৱালে কো সজ়া নহীং মিলেগী। উসে সির্ফ় উস ৱক়্ত কে লিএ মুআৱজ়া দেনা পড়েগা জব তক মরীজ় পৈসে ন কমা সকে। সাথ হী উসে উসকা পূরা ইলাজ করৱানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","জো অপনে গ়ুলাম যা লৌংডী কো লাঠী সে যোং মারে কি ৱহ মর জাএ উসে সজ়া দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","লেকিন অগর গ়ুলাম যা লৌংডী পিটাঈ কে বাদ এক যা দো দিন জ়িংদা রহে তো মালিক কো সজ়া ন দী জাএ। ক্যোংকি জো রক়ম উসনে উসকে লিএ দী থী উসকা নুক়সান উসে খ়ুদ উঠানা পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","হো সকতা হৈ কি লোগ আপস মেং লড় রহে হোং ঔর লড়তে লড়তে কিসী হামিলা ঔরত সে যোং টকরা জাএঁ কি উসকা বচ্চা জ়াযা হো জাএ। অগর কোঈ ঔর নুক়সান ন হুআ হো তো জ়রব পহুঁচানেৱালে কো জুরমানা দেনা পড়েগা। ঔরত কা শৌহর যহ জুরমানা মুক়র্রর করে, ঔর অদালত মেং ইসকী তসদীক় হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","লেকিন অগর উস ঔরত কো ঔর নুক়সান ভী পহুঁচা হো তো ফির জ়রব পহুঁচানেৱালে কো ইস উসূল কে মুতাবিক় সজ়া দী জাএ কি জান কে বদলে জান, ");
INSERT INTO urdgvb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","আঁখ কে বদলে আঁখ, দাঁত কে বদলে দাঁত, হাথ কে বদলে হাথ, পাঁৱ কে বদলে পাঁৱ, ");
INSERT INTO urdgvb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","জলনে কে জ়খ়ম কে বদলে জলনে কা জ়খ়ম, মার কে বদলে মার, কাট কে বদলে কাট। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","অগর কোঈ মালিক অপনে গ়ুলাম কী আঁখ পর যোং মারে কি ৱহ জ়াযা হো জাএ তো উসে গ়ুলাম কো আঁখ কে বদলে আজ়াদ করনা পড়েগা, চাহে গ়ুলাম মর্দ হো যা ঔরত। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","অগর মালিক কে পীটনে সে গ়ুলাম কা দাঁত টূট জাএ তো উসে গ়ুলাম কো দাঁত কে বদলে আজ়াদ করনা পড়েগা, চাহে গ়ুলাম মর্দ হো যা ঔরত। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","অগর কোঈ বৈল কিসী মর্দ যা ঔরত কো ঐসা মারে কি ৱহ মর জাএ তো উস বৈল কো সংগসার কিযা জাএ। উসকা গোশ্ত খানে কী ইজাজ়ত নহীং হৈ। ইস সূরত মেং বৈল কে মালিক কো সজ়া ন দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","লেকিন হো সকতা হৈ কি মালিক কো পহলে আগাহ কিযা গযা থা কি বৈল লোগোং কো মারতা হৈ, তো ভী উসনে বৈল কো খুলা ছোড়া থা জিসকে নতীজে মেং উসনে কিসী কো মার ডালা। ঐসী সূরত মেং ন সির্ফ় বৈল কো বল্কি উসকে মালিক কো ভী সংগসার করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","লেকিন অগর ফ়ৈসলা কিযা জাএ কি ৱহ অপনী জান কা ফ়িদ্যা দে তো জিতনা মুআৱজ়া ভী মুক়র্রর কিযা জাএ উসে দেনা পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","সজ়া মেং কোঈ ফ়রক় নহীং হৈ, চাহে বেটে কো মারা জাএ যা বেটী কো। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","লেকিন অগর বৈল কিসী গ়ুলাম যা লৌংডী কো মার দে তো উসকা মালিক গ়ুলাম কে মালিক কো চাঁদী কে 30 সিক্কে দে ঔর বৈল কো সংগসার কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","হো সকতা হৈ কি কিসী নে অপনে হৌজ় কো খুলা রহনে দিযা যা হৌজ় বনানে কে লিএ গঢ়া খোদকর উসে খুলা রহনে দিযা ঔর কোঈ বৈল যা গধা উসমেং গিরকর মর গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ঐসী সূরত মেং হৌজ় কা মালিক মুরদা জানৱর কে লিএ পৈসে দে। ৱহ জানৱর কে মালিক কো উস কী পূরী ক়ীমত অদা করে ঔর মুরদা জানৱর খ়ুদ লে লে। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","অগর কিসী কা বৈল কিসী দূসরে কে বৈল কো ঐসে মারে কি ৱহ মর জাএ তো দোনোং মালিক জ়িংদা বৈল কো বেচকর উসকে পৈসে আপস মেং বরাবর বাঁট লেং। ইসী তরহ ৱহ মুরদা বৈল কো ভী বরাবর তক়সীম করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","লেকিন হো সকতা হৈ কি মালিক কো মালূম থা কি মেরা বৈল দূসরে জানৱরোং পর হমলা করতা হৈ, ইসকে বাৱুজূদ উসনে উসে আজ়াদ ছোড় দিযা থা। ঐসী সূরত মেং উসে মুরদা বৈল কে এৱজ় উসকে মালিক কো নযা বৈল দেনা পড়েগা, ঔর ৱহ মুরদা বৈল খ়ুদ লে লে। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","জিসনে কোঈ বৈল যা ভেড় চোরী করকে উসে জ়বহ কিযা যা বেচ ডালা হৈ উসে হর চোরী কে বৈল কে এৱজ় পাঁচ বৈল ঔর হর চোরী কী ভেড় কে এৱজ় চার ভেড়েং ৱাপস করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","হো সকতা হৈ কি কোঈ চোর নক়ব লগা রহা হো ঔর লোগ উসে পকড়কর যহাঁ তক মারতে পীটতে রহেং কি ৱহ মর জাএ। অগর রাত কে ৱক়্ত ঐসা হুআ হো তো ৱহ উসকে খ়ূন কে জ়িম্মাদার নহীং ঠহর সকতে। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","লেকিন অগর সূরজ কে তুলূ হোনে কে বাদ ঐসা হুআ হো তো জিসনে উসে মারা ৱহ ক়াতিল ঠহরেগা। চোর কো হর চুরাঈ হুঈ চীজ় কা এৱজ়ানা দেনা হৈ। অগর উসকে পাস দেনে কে লিএ কুছ ন হো তো উসে গ়ুলাম বনাকর বেচনা হৈ। জো পৈসে উসে বেচনে কে এৱজ় মিলেং ৱহ চুরাঈ হুঈ চীজ়োং কে বদলে মেং দিএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","অগর চোরী কা জানৱর চোর কে পাস জ়িংদা পাযা জাএ তো উসে হর জানৱর কে এৱজ় দো দেনে পড়েংগে, চাহে ৱহ বৈল, ভেড়, বকরী যা গধা হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","হো সকতা হৈ কি কোঈ অপনে মৱেশী কো অপনে খেত যা অংগূর কে বাগ় মেং ছোড়কর চরনে দে ঔর হোতে হোতে ৱহ কিসী দূসরে কে খেত যা অংগূর কে বাগ় মেং জাকর চরনে লগে। ঐসী সূরত মেং লাজ়িম হৈ কি মৱেশী কা মালিক নুক়সান কে এৱজ় অপনে অংগূর কে বাগ় ঔর খেত কী বেহতরীন পৈদাৱার মেং সে দে। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","হো সকতা হৈ কি কিসী নে আগ জলাঈ হো ঔর ৱহ কাঁটেদার ঝাড়িযোং কে জ়রীএ পড়োসী কে খেত তক ফৈলকর উসকে অনাজ কে পূলোং কো, উস কী পকী হুঈ ফ়সল কো যা খেত কী কিসী ঔর পৈদাৱার কো বরবাদ কর দে। ঐসী সূরত মেং জিসনে আগ জলাঈ হো উসে উস কী পূরী ক়ীমত অদা করনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","হো সকতা হৈ কি কিসী নে কুছ পৈসে যা কোঈ ঔর মাল অপনে কিসী ৱাক়িফ়কার কে সুপুর্দ কর দিযা হো তাকি ৱহ উসে মহফ়ূজ় রখে। অগর যহ চীজ়েং উসকে ঘর সে চোরী হো জাএঁ ঔর বাদ মেং চোর কো পকড়া জাএ তো চোর কো উস কী দুগনী ক়ীমত অদা করনী পড়েগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","লেকিন অগর চোর পকড়া ন জাএ তো লাজ়িম হৈ কি উস ঘর কা মালিক জিসকে সুপুর্দ যহ চীজ়েং কী গঈ থীং অল্লাহ কে হুজ়ূর খড়া হো তাকি মালূম কিযা জাএ কি উসনে খ়ুদ যহ মাল চোরী কিযা হৈ যা নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","হো সকতা হৈ কি দো লোগোং কা আপস মেং ঝগড়া হো, ঔর দোনোং কিসী চীজ় কে বারে মেং দাৱা করতে হোং কি যহ মেরী হৈ। অগর কোঈ ক়ীমতী চীজ় হো মসলন বৈল, গধা, ভেড়, বকরী, কপড়ে যা কোঈ খোঈ হুঈ চীজ় তো মামলা অল্লাহ কে হুজ়ূর লাযা জাএ। জিসে অল্লাহ ক়ুসূরৱার ক়রার দে উসে দূসরে কো জ়েরে-বহস চীজ় কী দুগনী ক়ীমত অদা করনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","হো সকতা হৈ কি কিসী নে অপনা কোঈ গধা, বৈল, ভেড়, বকরী যা কোঈ ঔর জানৱর কিসী ৱাক়িফ়কার কে সুপুর্দ কর দিযা তাকি ৱহ উসে মহফ়ূজ় রখে। ৱহাঁ জানৱর মর জাএ যা জ়খ়মী হো জাএ, যা কোঈ উস পর ক়ব্জ়া করকে উসে উস ৱক়্ত লে জাএ জব কোঈ ন দেখ রহা হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","যহ মামলা যোং হল কিযা জাএ কি জিসকে সুপুর্দ জানৱর কিযা গযা থা ৱহ রব কে হুজ়ূর ক়সম খাকর কহে কি মৈংনে অপনে ৱাক়িফ়কার কে জানৱর কে লালচ মেং যহ কাম নহীং কিযা। জানৱর কে মালিক কো যহ ক়বূল করনা পড়েগা, ঔর দূসরে কো ইসকে বদলে কুছ নহীং দেনা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","লেকিন অগর ৱাক়ঈ জানৱর কো চোরী কিযা গযা হৈ তো জিসকে সুপুর্দ জানৱর কিযা গযা থা উসে উস কী ক়ীমত অদা করনী পড়েগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","অগর কিসী জংগলী জানৱর নে উসে ফাড় ডালা হো তো ৱহ সবূত কে তৌর পর ফাড়ী হুঈ লাশ কো লে আএ। ফির উসে উস কী ক়ীমত অদা নহীং করনী পড়েগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","হো সকতা হৈ কি কোঈ অপনে ৱাক়িফ়কার সে ইজাজ়ত লেকর উসকা জানৱর ইস্তেমাল করে। অগর জানৱর কো মালিক কী গ়ৈরমৌজূদগী মেং চোট লগে যা ৱহ মর জাএ তো উস শখ়্স কো জিসকে পাস জানৱর উস ৱক়্ত থা উসকা মুআৱজ়া দেনা পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","লেকিন অগর জানৱর কা মালিক উস ৱক়্ত সাথ থা তো দূসরে কো মুআৱজ়া দেনে কী জ়রূরত নহীং হোগী। অগর উসনে জানৱর কো কিরাএ পর লিযা হো তো উসকা নুক়সান কিরাএ সে পূরা হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","অগর কিসী কুঁৱারী কী মঁগনী নহীং হুঈ ঔর কোঈ মর্দ উসে ৱরগ়লাকর উসসে হমবিসতর হো জাএ তো ৱহ মহর দেকর উসসে শাদী করে। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","লেকিন অগর লড়কী কা বাপ উস কী উস মর্দ কে সাথ শাদী করনে সে ইনকার করে, ইস সূরত মেং ভী মর্দ কো কুঁৱারী কে লিএ মুক়র্ররা রক়ম দেনী পড়েগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","জাদূগরনী কো জীনে ন দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","জো শখ়্স কিসী জানৱর কে সাথ জিংসী তাল্লুক়াত রখতা হো উসে সজ়াএ-মৌত দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","জো ন সির্ফ় রব কো ক়ুরবানিযাঁ পেশ করে বল্কি দীগর মাবূদোং কো ভী উসে ক়ৌম সে নিকালকর হলাক কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","জো পরদেসী তেরে মুল্ক মেং মেহমান হৈ উসে ন দবানা ঔর ন উসসে বুরা সুলূক করনা, ক্যোংকি তুম ভী মিসর মেং পরদেসী থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","কিসী বেৱা যা যতীম সে বুরা সুলূক ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","অগর তূ ঐসা করে ঔর ৱহ চিল্লাকর মুঝসে ফ়রিযাদ করেং তো মৈং জ়রূর উনকী সুনূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","মৈং বড়ে গ়ুস্সে মেং আকর তুম্হেং তলৱার সে মার ডালূঁগা। ফির তুম্হারী বীৱিযাঁ খ়ুদ বেৱাএঁ ঔর তুম্হারে বচ্চে খ়ুদ যতীম বন জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","অগর তূনে মেরী ক়ৌম কে কিসী গ়রীব কো ক়র্জ় দিযা হৈ তো উসসে সূদ ন লেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","অগর তুঝে কিসী সে উস কী চাদর গিরৱী কে তৌর পর মিলী হো তো উসে সূরজ ডূবনে সে পহলে হী ৱাপস কর দেনা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ক্যোংকি ইসী কো ৱহ সোনে কে লিএ ইস্তেমাল করতা হৈ। ৱরনা ৱহ ক্যা চীজ় ওঢ়কর সোএগা? অগর তূ চাদর ৱাপস ন করে ঔর ৱহ শখ়্স চিল্লাকর মুঝসে ফ়রিযাদ করে তো মৈং উস কী সুনূঁগা, ক্যোংকি মৈং মেহরবান হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","অল্লাহ কো ন কোসনা, ন অপনী ক়ৌম কে কিসী সরদার পর লানত করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","মুঝে ৱক়্ত পর অপনে খেত ঔর কোল্হুওং কী পৈদাৱার মেং সে নজ়রানে পেশ করনা। অপনে পহলৌঠে মুঝে দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","অপনে বৈলোং, ভেড়োং ঔর বকরিযোং কে পহলৌঠোং কো ভী মুঝে দেনা। জানৱর কা পহলৌঠা পহলে সাত দিন অপনী মাঁ কে সাথ রহে। আঠৱেং দিন ৱহ মুঝে দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","অপনে আপকো মেরে লিএ মখ়সূসো-মুক়দ্দস রখনা। ইসলিএ ঐসে জানৱর কা গোশ্ত মত খানা জিসে কিসী জংগলী জানৱর নে ফাড় ডালা হৈ। ঐসে গোশ্ত কো কুত্তোং কো খানে দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","গ়লত অফ়ৱাহেং ন ফৈলানা। কিসী শরীর আদমী কা সাথ দেকর ঝূটী গৱাহী দেনা মনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","অগর অকসরিযত গ়লত কাম কর রহী হো তো উসকে পীছে ন হো লেনা। অদালত মেং গৱাহী দেতে ৱক়্ত অকসরিযত কে সাথ মিলকর ঐসী বাত ন করনা জিসসে গ়লত ফ়ৈসলা কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","লেকিন অদালত মেং কিসী গ়রীব কী তরফ়দারী ভী ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","অগর তুঝে তেরে দুশ্মন কা বৈল যা গধা আৱারা ফিরতা হুআ নজ়র আএ তো উসে হর সূরত মেং ৱাপস কর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","অগর তুঝসে নফ়রত করনেৱালে কা গধা বোঝ তলে গির গযা হো ঔর তুঝে পতা লগে তো উসে ন ছোড়না বল্কি জ়রূর উস কী মদদ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","অদালত মেং গ়রীব কে হুক়ূক় ন মারনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ঐসে মামলে সে দূর রহনা জিসমেং লোগ ঝূট বোলতে হৈং। জো বেগুনাহ ঔর হক় পর হৈ উসে সজ়াএ-মৌত ন দেনা, ক্যোংকি মৈং ক়ুসূরৱার কো হক়-বজানিব নহীং ঠহরাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","রিশ্ৱত ন লেনা, ক্যোংকি রিশ্ৱত দেখনেৱালে কো অংধা কর দেতী হৈ ঔর উস কী বাত বননে নহীং দেতী জো হক় পর হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","জো পরদেসী তেরে মুল্ক মেং মেহমান হৈ উস পর দবাৱ ন ডালনা। তুম ঐসে লোগোং কী হালত সে খ়ূব ৱাক়িফ় হো, ক্যোংকি তুম খ়ুদ মিসর মেং পরদেসী রহে হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ছঃ সাল তক অপনী জ়মীন মেং বীজ বোকর উস কী পৈদাৱার জমা করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","লেকিন সাতৱেং সাল জ়মীন কো ইস্তেমাল ন করনা বল্কি উসে পড়ে রহনে দেনা। জো কুছ ভী উগে ৱহ ক়ৌম কে গ়রীব লোগ খাএঁ। জো উনসে বচ জাএ উসে জংগলী জানৱর খাএঁ। অপনে অংগূর ঔর জ়ৈতূন কে বাগ়োং কে সাথ ভী ঐসা হী করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ছঃ দিন অপনা কাম-কাজ করনা, লেকিন সাতৱেং দিন আরাম করনা। ফির তেরা বৈল ঔর তেরা গধা ভী আরাম কর সকেংগে, তেরী লৌংডী কা বেটা ঔর তেরে সাথ রহনেৱালা পরদেসী ভী তাজ়াদম হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","জো ভী হিদাযত মৈংনে দী হৈ উস পর অমল কর। দীগর মাবূদোং কী পরস্তিশ ন করনা। মৈং তেরে মুঁহ সে উনকে নামোং তক কা জ়িক্র ন সুনূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","সাল মেং তীন দফ়া মেরী তাজ়ীম মেং ঈদ মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","পহলে, বেখ়মীরী রোটী কী ঈদ মনানা। অবীব কে মহীনে মেং সাত দিন তক তেরী রোটী মেং খ়মীর ন হো জিস তরহ মৈংনে হুক্ম দিযা হৈ, ক্যোংকি ইস মহীনে মেং তূ মিসর সে নিকলা। ইন দিনোং মেং কোঈ মেরে হুজ়ূর খ়ালী হাথ ন আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","দূসরে, ফ়সলকটাঈ কী ঈদ উস ৱক়্ত মনানা জব তূ অপনে খেত মেং বোঈ হুঈ পহলী ফ়সল কাটেগা। তীসরে, জমা করনে কী ঈদ ফ়সল কী কটাঈ কে ইখ়্তিতাম পর মনানা হৈ জব তূনে অংগূর ঔর বাক়ী বাগ়োং কে ফল জমা কিএ হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","যোং তেরে তমাম মর্দ তীন মরতবা রব ক়াদিরে-মুতলক় কে হুজ়ূর হাজ়ির হুআ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","জব তূ কিসী জানৱর কো জ়বহ করকে ক়ুরবানী কে তৌর পর পেশ করে তো উসকে খ়ূন কে সাথ ঐসী রোটী পেশ ন করনা জিসমেং খ়মীর হো। ঔর জো জানৱর তূ মেরী ঈদোং পর চঢ়াএ উনকী চরবী অগলী সুবহ তক বাক়ী ন রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","অপনী জ়মীন কী পহলী পৈদাৱার কা বেহতরীন হিস্সা রব অপনে খ়ুদা কে ঘর মেং লানা। ভেড় যা বকরী কে বচ্চে কো উস কী মাঁ কে দূধ মেং ন পকানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","মৈং তেরে আগে আগে ফ়রিশ্তা ভেজতা হূঁ জো রাস্তে মেং তেরী হিফ়াজ়ত করেগা ঔর তুঝে উস জগহ তক লে জাএগা জো মৈংনে তেরে লিএ তৈযার কী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","উস কী মৌজূদগী মেং এহতিযাত বরতনা। উস কী সুননা, ঔর উস কী খ়িলাফ়ৱরজ়ী ন করনা। অগর তূ সরকশ হো জাএ তো ৱহ তুঝে মুআফ় নহীং করেগা, ক্যোংকি মেরা নাম উসমেং হাজ়ির হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","লেকিন অগর তূ উস কী সুনে ঔর সব কুছ করে জো মৈং তুঝে বতাতা হূঁ তো মৈং তেরে দুশ্মনোং কা দুশ্মন ঔর তেরে মুখ়ালিফ়োং কা মুখ়ালিফ় হূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ক্যোংকি মেরা ফ়রিশ্তা তেরে আগে আগে চলেগা ঔর তুঝে মুল্কে-কনান তক পহুঁচা দেগা জহাঁ অমোরী, হিত্তী, ফ়রিজ়্জ়ী, কনানী, হিৱ্ৱী ঔর যবূসী আবাদ হৈং। তব মৈং উন্হেং রূএ-জ়মীন পর সে মিটা দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","উনকে মাবূদোং কো সিজদা ন করনা, ন উনকী খ়িদমত করনা। উনকে রস্মো-রিৱাজ ভী ন অপনানা বল্কি উনকে বুতোং কো তবাহ কর দেনা। জিন সতূনোং কে সামনে ৱহ ইবাদত করতে হৈং উনকো ভী টুকড়ে টুকড়ে কর ডালনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","রব অপনে খ়ুদা কী খ়িদমত করনা। ফির মৈং তেরী খ়ুরাক ঔর পানী কো বরকত দেকর তমাম বীমারিযাঁ তুঝসে দূর করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ফির তেরে মুল্ক মেং ন কিসী কা বচ্চা জ়াযা হোগা, ন কোঈ বাঁঝ হোগী। সাথ হী মৈং তুঝে তৱীল জ়িংদগী অতা করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","মৈং তেরে আগে আগে দহশত ফৈলাঊঁগা। জহাঁ ভী তূ জাএগা ৱহাঁ মৈং তমাম ক়ৌমোং মেং অবতরী পৈদা করূঁগা। মেরে সবব সে তেরে সারে দুশ্মন পলটকর ভাগ জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","মৈং তেরে আগে জ়ংবূর ভেজ দূঁগা জো হিৱ্ৱী, কনানী ঔর হিত্তী কো মুল্ক ছোড়নে পর মজবূর করেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","লেকিন জব তূ ৱহাঁ পহুঁচেগা তো মৈং উন্হেং এক হী সাল মেং মুল্ক সে নহীং নিকালূঁগা। ৱরনা পূরা মুল্ক ৱীরান হো জাএগা ঔর জংগলী জানৱর ফৈলকর তেরে লিএ নুক়সান কা বাইস বন জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ইসলিএ মৈং তেরে পহুঁচনে পর মুল্ক কে বাশিংদোং কো থোড়া থোড়া করকে নিকালতা জাঊঁগা। ইতনে মেং তেরী তাদাদ বঢ়েগী ঔর তূ রফ়্তা রফ়্তা মুল্ক পর ক়ব্জ়া কর সকেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","মৈং তেরী সরহদ্দেং মুক়র্রর করূঁগা। বহরে-ক়ুলজ়ুম এক হদ হোগী ঔর ফ়িলিস্তিযোং কা সমুংদর দূসরী, জুনূব কা রেগিস্তান এক হোগী ঔর দরিযাএ-ফ়ুরাত দূসরী। মৈং মুল্ক কে বাশিংদোং কো তেরে ক়ব্জ়ে মেং কর দূঁগা, ঔর তূ উন্হেং অপনে আগে আগে মুল্ক সে দূর করতা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","লাজ়িম হৈ কি তূ উনকে সাথ যা উনকে মাবূদোং কে সাথ অহদ ন বাঁধে। ");
INSERT INTO urdgvb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","উনকা তেরে মুল্ক মেং রহনা মনা হৈ, ৱরনা তূ উনকে সবব সে মেরা গুনাহ করেগা। অগর তূ উনকে মাবূদোং কী ইবাদত করেগা তো যহ তেরে লিএ ফংদা বন জাএগা’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","রব নে মূসা সে কহা, “তূ, হারূন, নদব, অবীহূ ঔর ইসরাঈল কে 70 বুজ়ুর্গ মেরে পাস ঊপর আএঁ। কুছ ফ়াসলে পর খড়ে হোকর মুঝে সিজদা করো। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","সির্ফ় তূ অকেলা হী মেরে ক়রীব আ, দূসরে দূর রহেং। ঔর ক়ৌম কে বাক়ী লোগ তেরে সাথ পহাড় পর ন চঢ়েং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","তব মূসা নে ক়ৌম কে পাস জাকর রব কী তমাম বাতেং ঔর অহকাম পেশ কিএ। জৱাব মেং সবনে মিলকর কহা, “হম রব কী ইন তমাম বাতোং পর অমল করেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","তব মূসা নে রব কী তমাম বাতেং লিখ লীং। অগলে দিন ৱহ সুবহ-সৱেরে উঠা ঔর পহাড় কে পাস গযা। উসকে দামন মেং উসনে ক়ুরবানগাহ বনাঈ। সাথ হী উসনে ইসরাঈল কে হর এক ক়বীলে কে লিএ এক এক পত্থর কা সতূন খড়া কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ফির উসনে কুছ ইসরাঈলী নৌজৱানোং কো ক়ুরবানী পেশ করনে কে লিএ বুলাযা তাকি ৱহ রব কী তাজ়ীম মেং ভস্ম হোনেৱালী ক়ুরবানিযাঁ চঢ়াএঁ ঔর জৱান বৈলোং কো সলামতী কী ক়ুরবানী কে তৌর পর পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","মূসা নে ক়ুরবানিযোং কা খ়ূন জমা কিযা। উসকা আধা হিস্সা উসনে বাসনোং মেং ডাল দিযা ঔর আধা হিস্সা ক়ুরবানগাহ পর ছিড়ক দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ফির উসনে ৱহ কিতাব লী জিসমেং রব কে সাথ অহদ কী তমাম শরাযত দর্জ থীং ঔর উসে ক়ৌম কো পঢ়কর সুনাযা। জৱাব মেং উন্হোংনে কহা, “হম রব কী ইন তমাম বাতোং পর অমল করেংগে। হম উস কী সুনেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ইস পর মূসা নে বাসনোং মেং সে খ়ূন লেকর উসে লোগোং পর ছিড়কা ঔর কহা, “যহ খ়ূন উস অহদ কী তসদীক় করতা হৈ জো রব নে তুম্হারে সাথ কিযা হৈ ঔর জো উস কী তমাম বাতোং পর মবনী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ইসকে বাদ মূসা, হারূন, নদব, অবীহূ ঔর ইসরাঈল কে 70 বুজ়ুর্গ সীনা পহাড় পর চঢ়ে। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ৱহাঁ উন্হোংনে ইসরাঈল কে খ়ুদা কো দেখা। লগতা থা কি উসকে পাঁৱোং কে নীচে সংগে-লাজৱর্দ কা-সা তখ়্তা থা। ৱহ আসমান কী মানিংদ সাফ়ো-শফ়্ফ়াফ় থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","অগরচে ইসরাঈল কে রাহনুমাওং নে যহ সব কুছ দেখা তো ভী রব নে উন্হেং হলাক ন কিযা, বল্কি ৱহ অল্লাহ কো দেখতে রহে ঔর উসকে হুজ়ূর অহদ কা খানা খাতে ঔর পীতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","পহাড় সে উতরনে কে বাদ রব নে মূসা সে কহা, “মেরে পাস পহাড় পর আকর কুছ দের কে লিএ ঠহরে রহনা। মৈং তুঝে পত্থর কী তখ়্তিযাঁ দূঁগা জিন পর মৈংনে অপনী শরীঅত ঔর অহকাম লিখে হৈং ঔর জো ইসরাঈল কী তালীমো-তরবিযত কে লিএ জ়রূরী হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","মূসা অপনে মদদগার যশুঅ কে সাথ চল পড়া ঔর অল্লাহ কে পহাড় পর চঢ় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","পহলে উসনে বুজ়ুর্গোং সে কহা, “হমারী ৱাপসী কে ইংতজ়ার মেং যহাঁ ঠহরে রহো। হারূন ঔর হূর তুম্হারে পাস রহেংগে। কোঈ ভী মামলা হো তো লোগ উন্হীং কে পাস জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","জব মূসা চঢ়নে লগা তো পহাড় পর বাদল ছা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","রব কা জলাল কোহে-সীনা পর উতর আযা। ছঃ দিন তক বাদল উস পর ছাযা রহা। সাতৱেং দিন রব নে বাদল মেং সে মূসা কো বুলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","রব কা জলাল ইসরাঈলিযোং কো ভী নজ়র আতা থা। উন্হেং যোং লগা জৈসা কি পহাড় কী চোটী পর তেজ় আগ ভড়ক রহী হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","চঢ়তে চঢ়তে মূসা বাদল মেং দাখ়িল হুআ। ৱহাঁ ৱহ চালীস দিন ঔর চালীস রাত রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ইসরাঈলিযোং কো বতা কি ৱহ হদিযে লাকর মুঝে উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ করেং। লেকিন সির্ফ় উনসে হদিযে ক়বূল করো জো দিলী খ়ুশী সে দেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","উনসে যহ চীজ়েং হদিযে কে তৌর পর ক়বূল করো : সোনা, চাঁদী, পীতল; ");
INSERT INTO urdgvb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা, বারীক কতান, বকরী কে বাল, ");
INSERT INTO urdgvb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","মেংঢোং কী সুর্খ় রঁগী হুঈ খালেং, তখ়স কী খালেং, কীকর কী লকড়ী, ");
INSERT INTO urdgvb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","শমাদান কে লিএ জ়ৈতূন কা তেল, মসহ করনে কে লিএ তেল ঔর খ়ুশবূদার বখ়ূর কে লিএ মসালে, ");
INSERT INTO urdgvb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","অক়ীক়ে-অহমর ঔর দীগর জৱাহর জো ইমামে-আজ়ম কে বালাপোশ ঔর সীনে কে কীসে মেং জড়ে জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ইন চীজ়োং সে লোগ মেরে লিএ মক়দিস বনাএঁ তাকি মৈং উনকে দরমিযান রহূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","মৈং তুঝে মক়দিস ঔর উসকে তমাম সামান কা নমূনা দিখাঊঁগা, ক্যোংকি তুম্হেং সব কুছ ঐন উসী কে মুতাবিক় বনানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_10‏","003_25_10‏","EXO","25","10‏","12","লোগ কীকর কী লকড়ী কা সংদূক় বনাএঁ। উস কী লংবাঈ পৌনে চার ফ়ুট হো জবকি উস কী চৌড়াঈ ঔর ঊঁচাঈ সৱা দো দো ফ়ুট হো। পূরে সংদূক় পর অংদর ঔর বাহর সে খ়ালিস সোনা চঢ়ানা। ঊপর কী সতহ কে ইর্দগির্দ সোনে কী ঝালর লগানা। সংদূক় কো উঠানে কে লিএ সোনে কে চার কড়ে ঢালকর উন্হেং সংদূক় কে চারপাইযোং পর লগানা। দোনোং তরফ় দো দো কড়ে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ফির কীকর কী দো লকড়িযাঁ সংদূক় কো উঠানে কে লিএ তৈযার করনা। উন পর সোনা চঢ়াকর ");
INSERT INTO urdgvb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","উনকো দোনোং তরফ় কে কড়োং মেং ডালনা তাকি উনসে সংদূক় কো উঠাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","যহ লকড়িযাঁ সংদূক় কে ইন কড়োং মেং পড়ী রহেং। উন্হেং কভী ভী দূর ন কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","সংদূক় মেং শরীঅত কী ৱহ দো তখ়্তিযাঁ রখনা জো মৈং তুঝে দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","সংদূক় কা ঢকনা খ়ালিস সোনে কা বনানা। উস কী লংবাঈ পৌনে চার ফ়ুট ঔর চৌড়াঈ সৱা দো ফ়ুট হো। উসকা নাম কফ়্ফ়ারে কা ঢকনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_18‏","003_25_18‏","EXO","25","18‏","19","সোনে সে ঘড়কর দো করূবী ফ়রিশ্তে বনাএ জাএঁ জো ঢকনে কে দোনোং সিরোং পর খড়ে হোং। যহ দো ফ়রিশ্তে ঔর ঢকনা এক হী টুকড়ে সে বনানে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ফ়রিশ্তোং কে পর যোং ঊপর কী তরফ় ফৈলে হুএ হোং কি ৱহ ঢকনে কো পনাহ দেং। উনকে মুঁহ এক দূসরে কী তরফ় কিএ হুএ হোং, ঔর ৱহ ঢকনে কী তরফ় দেখেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ঢকনে কো সংদূক় পর লগা, ঔর সংদূক় মেং শরীঅত কী ৱহ দো তখ়্তিযাঁ রখ জো মৈং তুঝে দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ৱহাঁ ঢকনে কে ঊপর দোনোং ফ়রিশ্তোং কে দরমিযান সে মৈং অপনে আপকো তুঝ পর জ়াহির করকে তুঝসে হমকলাম হূঁগা ঔর তুঝে ইসরাঈলিযোং কে লিএ তমাম অহকাম দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","কীকর কী লকড়ী কী মেজ় বনানা। উস কী লংবাঈ তীন ফ়ুট, চৌড়াঈ ডেঢ় ফ়ুট ঔর ঊঁচাঈ সৱা দো ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","উস পর খ়ালিস সোনা চঢ়ানা, ঔর উসকে ইর্দগির্দ সোনে কী ঝালর লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","মেজ় কী ঊপর কী সতহ পর চৌখটা লগানা জিসকী ঊঁচাঈ তীন ইংচ হো ঔর জিস পর সোনে কী ঝালর লগী হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","সোনে কে চার কড়ে ঢালকর উন্হেং চারোং কোনোং পর লগানা জহাঁ মেজ় কে পাএ লগে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","যহ কড়ে মেজ় কী সতহ পর লগে চৌখটে কে নীচে লগাএ জাএঁ। উনমেং ৱহ লকড়িযাঁ ডালনী হৈং জিনসে মেজ় কো উঠাযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","যহ লকড়িযাঁ ভী কীকর কী হোং ঔর উন পর সোনা চঢ়াযা জাএ। উনসে মেজ় কো উঠানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","উসকে থাল, প্যালে, মরতবান ঔর মৈ কী নজ়রেং পেশ করনে কে বরতন খ়ালিস সোনে সে বনানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","মেজ় পর ৱহ রোটিযাঁ হর ৱক়্ত মেরে হুজ়ূর পড়ী রহেং জো মেরে লিএ মখ়সূস হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","খ়ালিস সোনে কা শমাদান ভী বনানা। উসকা পাযা ঔর ডংডী ঘড়কর বনানা হৈ। উস কী প্যালিযাঁ জো ফূলোং ঔর কলিযোং কী শক্ল কী হোংগী পাএ ঔর ডংডী কে সাথ এক হী টুকড়া হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ডংডী সে দাঈং ঔর বাঈং তরফ় তীন তীন শাখ়েং নিকলেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","হর শাখ় পর তীন প্যালিযাঁ লগী হোং জো বাদাম কী কলিযোং ঔর ফূলোং কী শক্ল কী হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","শমাদান কী ডংডী পর ভী ইস ক়িস্ম কী প্যালিযাঁ লগী হোং, লেকিন তাদাদ মেং চার। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ইনমেং সে তীন প্যালিযাঁ দাএঁ বাএঁ কী ছঃ শাখ়োং কে নীচে লগী হোং। ৱহ যোং লগী হোং কি হর প্যালী সে দো শাখ়েং নিকলেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","শাখ়েং ঔর প্যালিযাঁ বল্কি পূরা শমাদান খ়ালিস সোনে কে এক হী টুকড়ে সে ঘড়কর বনানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","শমাদান কে লিএ সাত চরাগ় বনাকর উন্হেং যোং শাখ়োং পর রখনা কি ৱহ সামনে কী জগহ রৌশন করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","বত্তী কতরনে কী ক়ৈংচিযাঁ ঔর জলতে কোযলে কে লিএ ছোটে বরতন ভী খ়ালিস সোনে সে বনাএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","শমাদান ঔর উস সারে সামান কে লিএ পূরে 34 কিলোগ্রাম খ়ালিস সোনা ইস্তেমাল কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","গ়ৌর কর কি সব কুছ ঐন উস নমূনে কে মুতাবিক় বনাযা জাএ জো মৈং তুঝে যহাঁ পহাড় পর দিখাতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","মুক়দ্দস খ়ৈমে কে লিএ দস পরদে বনানা। উনকে লিএ বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ইস্তেমাল করনা। পরদোং মেং কিসী মাহির কারীগর কে কঢ়াঈ কে কাম সে করূবী ফ়রিশ্তোং কা ডিজ়াযন বনৱানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","হর পরদে কী লংবাঈ 42 ফ়ুট ঔর চৌড়াঈ 6 ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","পাঁচ পরদোং কে লংবে হাশিযে এক দূসরে কে সাথ জোড়ে জাএঁ ঔর ইসী তরহ বাক়ী পাঁচ ভী। যোং দো বড়ে টুকড়ে বন জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","দোনোং টুকড়োং কো এক দূসরে কে সাথ মিলানে কে লিএ নীলে ধাগে কে হলক়ে বনানা। যহ হলক়ে হর টুকড়ে কে 42 ফ়ুটৱালে এক কিনারে পর লগাএ জাএঁ, ");
INSERT INTO urdgvb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","এক টুকড়ে কে হাশিযে পর 50 হলক়ে ঔর দূসরে পর ভী উতনে হী হলক়ে। ইন দো হাশিযোং কে হলক়ে এক দূসরে কে আমনে-সামনে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ফির সোনে কী 50 হুকেং বনাকর উনসে আমনে-সামনে কে হলক়ে এক দূসরে কে সাথ মিলানা। যোং দোনোং টুকড়ে জুড়কর খ়ৈমে কা কাম দেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","বকরী কে বালোং সে ভী 11 পরদে বনানা জিন্হেং কপড়েৱালে খ়ৈমে কে ঊপর রখা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","হর পরদে কী লংবাঈ 45 ফ়ুট ঔর চৌড়াঈ 6 ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","পাঁচ পরদোং কে লংবে হাশিযে এক দূসরে কে সাথ জোড়ে জাএঁ ঔর ইসী তরহ বাক়ী ছঃ ভী। ইন ছঃ পরদোং কে ছটে পরদে কো এক দফ়া তহ করনা। যহ সামনেৱালে হিস্সে সে লটকে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","বকরী কে বাল কে ইন দোনোং টুকড়োং কো ভী মিলানা হৈ। ইসকে লিএ হর টুকড়ে কে 45 ফ়ুটৱালে এক কিনারে পর পচাস পচাস হলক়ে লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ফির পীতল কী 50 হুকেং বনাকর উনসে দোনোং হিস্সে মিলানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","জব বকরিযোং কে বালোং কা যহ খ়ৈমা কপড়ে কে খ়ৈমে কে ঊপর লগাযা জাএগা তো আধা পরদা বাক়ী রহেগা। ৱহ খ়ৈমে কী পিছলী তরফ় লটকা রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","খ়ৈমে কে দাঈং ঔর বাঈং তরফ় বকরী কে বালোং কা খ়ৈমা কপড়ে কে খ়ৈমে কী নিসবত ডেঢ় ডেঢ় ফ়ুট লংবা হোগা। যোং ৱহ দোনোং তরফ় লটকে হুএ কপড়ে কে খ়ৈমে কো মহফ়ূজ় রখেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","এক দূসরে কে ঊপর কে ইন দোনোং খ়ৈমোং কী হিফ়াজ়ত কে লিএ দো গ়িলাফ় বনানে হৈং। বকরী কে বালোং কে খ়ৈমে পর মেংঢোং কী সুর্খ় রঁগী হুঈ খালেং জোড়কর রখী জাএঁ ঔর উন পর তখ়স কী খালেং মিলাকর রখী জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","কীকর কী লকড়ী কে তখ়্তে বনানা জো খড়ে কিএ জাএঁ তাকি খ়ৈমে কী দীৱারোং কা কাম দেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","হর তখ়্তে কী ঊঁচাঈ 15 ফ়ুট হো ঔর চৌড়াঈ সৱা দো ফ়ুট। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","হর তখ়্তে কে নীচে দো দো চূলেং হোং। যহ চূলেং হর তখ়্তে কো উসকে পাইযোং কে সাথ জোড়েংগী তাকি তখ়্তা খড়া রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","খ়ৈমে কী জুনূবী দীৱার কে লিএ 20 তখ়্তোং কী জ়রূরত হৈ ");
INSERT INTO urdgvb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ঔর সাথ হী চাঁদী কে 40 পাইযোং কী। উন পর তখ়্তে খড়ে কিএ জাএংগে। হর তখ়্তে কে নীচে দো পাএ হোংগে, ঔর হর পাএ মেং এক চূল লগেগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ইসী তরহ খ়ৈমে কী শিমালী দীৱার কে লিএ ভী 20 তখ়্তোং কী জ়রূরত হৈ ");
INSERT INTO urdgvb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ঔর সাথ হী চাঁদী কে 40 পাইযোং কী। ৱহ ভী তখ়্তোং কো খড়া করনে কে লিএ হৈং। হর তখ়্তে কে নীচে দো পাএ হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","খ়ৈমে কী পিছলী যানী মগ়রিবী দীৱার কে লিএ ছঃ তখ়্তে বনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ইস দীৱার কো শিমালী ঔর জুনূবী দীৱারোং কে সাথ জোড়নে কে লিএ কোনেৱালে দো তখ়্তে বনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ইন দো তখ়্তোং মেং নীচে সে লেকর ঊপর তক কোনা হো তাকি এক সে শিমালী দীৱার মগ়রিবী দীৱার কে সাথ জুড় জাএ ঔর দূসরে সে জুনূবী দীৱার মগ়রিবী দীৱার কে সাথ। ইনকে ঊপর কে সিরে কড়োং সে মজ়বূত কিএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","যোং পিছলে যানী মগ়রিবী তখ়্তোং কী পূরী তাদাদ 8 হোগী ঔর ইনকে লিএ চাঁদী কে পাইযোং কী তাদাদ 16, হর তখ়্তে কে নীচে দো দো পাএ হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_26‏","003_26_26‏","EXO","26","26‏","27","ইসকে অলাৱা কীকর কী লকড়ী কে শহতীর বনানা, তীনোং দীৱারোং কে লিএ পাঁচ পাঁচ শহতীর। ৱহ হর দীৱার কে তখ়্তোং পর যোং লগাএ জাএঁ কি ৱহ উন্হেং এক দূসরে কে সাথ মিলাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","দরমিযানী শহতীর দীৱার কী আধী ঊঁচাঈ পর দীৱার কে এক সিরে সে দূসরে সিরে তক লগাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","শহতীরোং কো তখ়্তোং কে সাথ লগানে কে লিএ সোনে কে কড়ে বনাকর তখ়্তোং মেং লগানা। তমাম তখ়্তোং ঔর শহতীরোং পর সোনা চঢ়ানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","পূরে মুক়দ্দস খ়ৈমে কো উসী নমূনে কে মুতাবিক় বনানা জো মৈং তুঝে পহাড় পর দিখাতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","অব এক ঔর পরদা বনানা। ইসকে লিএ ভী বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ইস্তেমাল করনা। উস পর ভী কিসী মাহির কারীগর কে কঢ়াঈ কে কাম সে করূবী ফ়রিশ্তোং কা ডিজ়াযন বনৱানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ইসে সোনে কী হুকোং সে কীকর কী লকড়ী কে চার সতূনোং সে লটকানা। ইন সতূনোং পর সোনা চঢ়াযা জাএ ঔর ৱহ চাঁদী কে পাইযোং পর খড়ে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","যহ পরদা মুক়দ্দস কমরে কো মুক়দ্দসতরীন কমরে সে অলগ করেগা জিসমেং অহদ কা সংদূক় পড়া রহেগা। পরদে কো লটকানে কে বাদ উসকে পীছে মুক়দ্দসতরীন কমরে মেং অহদ কা সংদূক় রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ফির অহদ কে সংদূক় পর কফ়্ফ়ারে কা ঢকনা রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","জিস মেজ় পর মেরে লিএ মখ়সূস কী গঈ রোটিযাঁ পড়ী রহতী হৈং ৱহ পরদে কে বাহর মুক়দ্দস কমরে মেং শিমাল কী তরফ় রখী জাএ। উসকে মুক়াবিল জুনূব কী তরফ় শমাদান রখা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ফির খ়ৈমে কে দরৱাজ়ে কে লিএ ভী পরদা বনাযা জাএ। ইসকে লিএ ভী বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ইস্তেমাল কিযা জাএ। ইস পর কঢ়াঈ কা কাম কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ইস পরদে কো সোনে কী হুকোং সে কীকর কী লকড়ী কে পাঁচ সতূনোং সে লটকানা। ইন সতূনোং পর ভী সোনা চঢ়াযা জাএ, ঔর ৱহ পীতল কে পাইযোং পর খড়ে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","কীকর কী লকড়ী কী ক়ুরবানগাহ বনানা। উস কী ঊঁচাঈ সাঢ়ে চার ফ়ুট হো জবকি উস কী লংবাঈ ঔর চৌড়াঈ সাঢ়ে সাত সাত ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","উসকে ঊপর চারোং কোনোং মেং সে এক এক সীংগ নিকলে। সীংগ ঔর ক়ুরবানগাহ এক হী টুকড়ে কে হোং। সব পর পীতল চঢ়ানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","উসকা তমাম সাজ়ো-সামান ঔর বরতন ভী পীতল কে হোং যানী রাখ কো উঠাকর লে জানে কী বালটিযাঁ, বেলচে, কাঁটে, জলতে হুএ কোযলে কে লিএ বরতন ঔর ছিড়কাৱ কে কটোরে। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ক়ুরবানগাহ কো উঠানে কে লিএ পীতল কা জংগলা বনানা জো ঊপর সে খুলা হো। জংগলে কে চারোং কোনোং পর কড়ে লগাএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ক়ুরবানগাহ কী আধী ঊঁচাঈ পর কিনারা লগানা, ঔর ক়ুরবানগাহ কো জংগলে মেং ইস কিনারে তক রখা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","উসে উঠানে কে লিএ কীকর কী দো লকড়িযাঁ বনানা জিন পর পীতল চঢ়ানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","উনকো ক়ুরবানগাহ কে দোনোং তরফ় কে কড়োং মেং ডাল দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","পূরী ক়ুরবানগাহ লকড়ী কী হো, লেকিন অংদর সে খোখলী হো। উসে ঐন উস নমূনে কে মুতাবিক় বনানা জো মৈং তুঝে পহাড় পর দিখাতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","মুক়দ্দস খ়ৈমে কে লিএ সহন বনানা। উস কী চারদীৱারী বারীক কতান কে কপড়ে সে বনাঈ জাএ। চারদীৱারী কী লংবাঈ জুনূব কী তরফ় 150 ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","কপড়ে কো চাঁদী কী হুকোং ঔর পট্টিযোং সে লকড়ী কে 20 খংবোং কে সাথ লগাযা জাএ। হর খংবা পীতল কে পাএ পর খড়া হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","চারদীৱারী শিমাল কী তরফ় ভী ইসী কী মানিংদ হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","খ়ৈমে কে পীছে মগ়রিব কী তরফ় চারদীৱারী কী চৌড়াঈ 75 ফ়ুট হো ঔর কপড়া লকড়ী কে 10 খংবোং কে সাথ লগাযা জাএ। যহ খংবে ভী পীতল কে পাইযোং পর খড়ে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","সামনে, মশরিক় কী তরফ় জহাঁ সে সূরজ তুলূ হোতা হৈ চারদীৱারী কী চৌড়াঈ ভী 75 ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_14‏","003_27_14‏","EXO","27","14‏","15","যহাঁ চারদীৱারী কা দরৱাজ়া হো। কপড়া দরৱাজ়ে কে দাঈং তরফ় সাঢ়ে 22 ফ়ুট চৌড়া হো ঔর উসকে বাঈং তরফ় ভী উতনা হী চৌড়া। উসে দোনোং তরফ় তীন তীন লকড়ী কে খংবোং কে সাথ লগাযা জাএ জো পীতল কে পাইযোং পর খড়ে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","দরৱাজ়ে কা পরদা 30 ফ়ুট চৌড়া বনানা। ৱহ নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে বনাযা জাএ, ঔর উস পর কঢ়াঈ কা কাম হো। যহ কপড়া লকড়ী কে চার খংবোং কে সাথ লগাযা জাএ। ৱহ ভী পীতল কে পাইযোং পর খড়ে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","তমাম খংবে পীতল কে পাইযোং পর খড়ে হোং ঔর কপড়া চাঁদী কী হুকোং ঔর পট্টিযোং সে হর খংবে কে সাথ লগাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","চারদীৱারী কী লংবাঈ 150 ফ়ুট, চৌড়াঈ 75 ফ়ুট ঔর ঊঁচাঈ সাঢ়ে 7 ফ়ুট হো। খংবোং কে তমাম পাএ পীতল কে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","জো ভী সাজ়ো-সামান মুক়দ্দস খ়ৈমে মেং ইস্তেমাল কিযা জাতা হৈ ৱহ সব পীতল কা হো। খ়ৈমে ঔর চারদীৱারী কী মেখ়েং ভী পীতল কী হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ইসরাঈলিযোং কো হুক্ম দেনা কি ৱহ তেরে পাস কূটে হুএ জ়ৈতূনোং কা খ়ালিস তেল লাএঁ তাকি মুক়দ্দস কমরে কে শমাদান কে চরাগ় মুতৱাতির জলতে রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","হারূন ঔর উসকে বেটে শমাদান কো মুলাক়াত কে খ়ৈমে কে মুক়দ্দস কমরে মেং রখেং, উস পরদে কে সামনে জিসকে পীছে অহদ কা সংদূক় হৈ। উসমেং ৱহ তেল ডালতে রহেং তাকি ৱহ রব কে সামনে শাম সে লেকর সুবহ তক জলতা রহে। ইসরাঈলিযোং কা যহ উসূল অবদ তক ক়াযম রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","অপনে ভাঈ হারূন ঔর উসকে বেটোং নদব, অবীহূ, ইলিযজ়র ঔর ইতমর কো বুলা। মৈংনে উন্হেং ইসরাঈলিযোং মেং সে চুন লিযা হৈ তাকি ৱহ ইমামোং কী হৈসিযত সে মেরী খ়িদমত করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","অপনে ভাঈ হারূন কে লিএ মুক়দ্দস লিবাস বনৱানা জো পুরৱক়ার ঔর শানদার হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","লিবাস বনানে কী জ়িম্মাদারী উন তমাম লোগোং কো দেনা জো ঐসে কামোং মেং মাহির হৈং ঔর জিনকো মৈংনে হিকমত কী রূহ সে ভর দিযা হৈ। ক্যোংকি জব হারূন কো মখ়সূস কিযা জাএগা ঔর ৱহ মুক়দ্দস খ়ৈমে কী খ়িদমত সরংজাম দেগা তো উসে ইন কপড়োং কী জ়রূরত হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","উসকে লিএ যহ লিবাস বনানে হৈং : সীনে কা কীসা, বালাপোশ, চোগ়া, বুনা হুআ জ়েরজামা, পগড়ী ঔর কমরবংদ। যহ কপড়ে অপনে ভাঈ হারূন ঔর উসকে বেটোং কে লিএ বনৱানে হৈং তাকি ৱহ ইমাম কে তৌর পর খ়িদমত কর সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ইন কপড়োং কে লিএ সোনা ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ঔর বারীক কতান ইস্তেমাল কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","বালাপোশ কো ভী সোনে ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে বনানা হৈ। উস পর কিসী মাহির কারীগর সে কঢ়াঈ কা কাম করৱাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","উস কী দো পট্টিযাঁ হোং জো কংধোং পর রখকর সামনে ঔর পীছে সে বালাপোশ কে সাথ লগী হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ইসকে অলাৱা এক পটকা বুননা হৈ জিসসে বালাপোশ কো বাঁধা জাএ ঔর জো বালাপোশ কে সাথ এক টুকড়া হো। উসকে লিএ ভী সোনা, নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ঔর বারীক কতান ইস্তেমাল কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ফির অক়ীক়ে-অহমর কে দো পত্থর চুনকর উন পর ইসরাঈল কে বারহ বেটোং কে নাম কংদা করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","হর জৌহর পর ছঃ ছঃ নাম উনকী পৈদাইশ কী তরতীব কে মুতাবিক় কংদা কিএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","যহ নাম উস তরহ জৌহরোং পর কংদা কিএ জাএঁ জিস তরহ মুহর কংদা কী জাতী হৈ। ফির দোনোং জৌহর সোনে কে খ়ানোং মেং জড়কর ");
INSERT INTO urdgvb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","বালাপোশ কী দো পট্টিযোং পর ঐসে লগানা কি কংধোং পর আ জাএঁ। জব হারূন মেরে হুজ়ূর আএগা তো জৌহরোং পর কে যহ নাম উসকে কংধোং পর হোংগে ঔর মুঝে ইসরাঈলিযোং কী যাদ দিলাএঁগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","সোনে কে খ়ানে বনানা ");
INSERT INTO urdgvb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ঔর খ়ালিস সোনে কী দো জ়ংজীরেং জো ডোরী কী তরহ গুংধী হুঈ হোং। ফির ইন দো জ়ংজীরোং কো সোনে কে খ়ানোং কে সাথ লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","সীনে কে লিএ কীসা বনানা। উসমেং ৱহ ক়ুরে পড়ে রহেং জিনকী মারিফ়ত মেরী মরজ়ী মালূম কী জাএগী। মাহির কারীগর উসে উন্হীং চীজ়োং সে বনাএ জিনসে হারূন কা বালাপোশ বনাযা গযা হৈ যানী সোনে ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","জব কপড়ে কো এক দফ়া তহ কিযা গযা হো তো কীসে কী লংবাঈ ঔর চৌড়াঈ নৌ নৌ ইংচ হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","উস পর চার ক়তারোং মেং জৱাহর জড়না। হর ক়তার মেং তীন তীন জৌহর হোং। পহলী ক়তার মেং লাল, জ়বরজদ ঔর জ়ুমুর্রদ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","দূসরী মেং ফ়ীরোজ়া, সংগে-লাজৱর্দ ঔর হজরুল-ক়মর। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","তীসরী মেং জ়রক়োন, অক়ীক় ঔর যাক়ূতে-অরগ়ৱানী। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","চৌথী মেং পুখরাজ, অক়ীক়ে-অহমর ঔর যশব। হর জৌহর সোনে কে খ়ানে মেং জড়া হুআ হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","যহ বারহ জৱাহর ইসরাঈল কে বারহ ক়বীলোং কী নুমাইংদগী করতে হৈং। এক এক জৌহর পর এক ক়বীলে কা নাম কংদা কিযা জাএ। যহ নাম উস তরহ কংদা কিএ জাএঁ জিস তরহ মুহর কংদা কী জাতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","সীনে কে কীসে পর খ়ালিস সোনে কী দো জ়ংজীরেং লগানা জো ডোরী কী তরহ গুংধী হুঈ হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","উন্হেং লগানে কে লিএ দো কড়ে বনাকর কীসে কে ঊপর কে দো কোনোং পর লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","অব দোনোং জ়ংজীরেং উন দো কড়োং সে লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","উনকে দূসরে সিরে বালাপোশ কী কংধোংৱালী পট্টিযোং কে দো খ়ানোং কে সাথ জোড় দেনা, ফির সামনে কী তরফ় লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","কীসে কে নিচলে দো কোনোং পর ভী সোনে কে দো কড়ে লগানা। ৱহ অংদর, বালাপোশ কী তরফ় লগে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","অব দো ঔর কড়ে বনাকর বালাপোশ কী কংধোংৱালী পট্টিযোং পর লগানা। যহ ভী সামনে কী তরফ় লগে হোং লেকিন নীচে, বালাপোশ কে পটকে কে ঊপর হী। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","সীনে কে কীসে কে নিচলে কড়ে নীলী ডোরী সে বালাপোশ কে ইন নিচলে কড়োং কে সাথ বাঁধে জাএঁ। যোং কীসা পটকে কে ঊপর অচ্ছী তরহ সীনে কে সাথ লগা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","জব ভী হারূন মক়দিস মেং দাখ়িল হোকর রব কে হুজ়ূর আএগা ৱহ ইসরাঈলী ক়বীলোং কে নাম অপনে দিল পর সীনে কে কীসে কী সূরত মেং সাথ লে জাএগা। যোং ৱহ ক়ৌম কী যাদ দিলাতা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","সীনে কে কীসে মেং দোনোং ক়ুরে বনাম ঊরীম ঔর তুম্মীম রখে জাএঁ। ৱহ ভী মক়দিস মেং রব কে সামনে আতে ৱক়্ত হারূন কে দিল পর হোং। যোং জব হারূন রব কে হুজ়ূর হোগা তো রব কী মরজ়ী পূছনে কা ৱসীলা হমেশা উসকে দিল পর হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","চোগ়া ভী বুননা। ৱহ পূরী তরহ নীলে ধাগে সে বনাযা জাএ। চোগ়ে কো বালাপোশ সে পহলে পহনা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","উসকে গরেবান কো বুনে হুএ কালর সে মজ়বূত কিযা জাএ তাকি ৱহ ন ফটে। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে সে অনার বনাকর উন্হেং চোগ়ে কে দামন মেং লগা দেনা। উনকে দরমিযান সোনে কী ঘংটিযাঁ লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","দামন মেং অনার ঔর ঘংটিযাঁ বারী বারী লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","হারূন খ়িদমত করতে ৱক়্ত হমেশা চোগ়া পহনে। জব ৱহ মক়দিস মেং রব কে হুজ়ূর আএগা ঔর ৱহাঁ সে নিকলেগা তো ঘংটিযাঁ সুনাঈ দেংগী। ফির ৱহ নহীং মরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","খ়ালিস সোনে কী তখ়্তী বনাকর উস পর যহ অলফ়াজ় কংদা করনা, ‘রব কে লিএ মখ়সূসো-মুক়দ্দস।’ যহ অলফ়াজ় যোং কংদা কিএ জাএঁ জিস তরহ মুহর কংদা কী জাতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","উসে নীলী ডোরী সে পগড়ী কে সামনেৱালে হিস্সে সে লগাযা জাএ ");
INSERT INTO urdgvb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","তাকি ৱহ হারূন কে মাথে পর পড়ী রহে। জব ভী ৱহ মক়দিস মেং জাএ তো যহ তখ়্তী সাথ হো। জব ইসরাঈলী অপনে নজ়রানে লাকর রব কে লিএ মখ়সূস করেং লেকিন কিসী গ়লতী কে বাইস ক়ুসূরৱার হোং তো উনকা যহ ক়ুসূর হারূন পর মুংতক়িল হোগা। ইসলিএ যহ তখ়্তী হর ৱক়্ত উসকে মাথে পর হো তাকি রব ইসরাঈলিযোং কো ক়বূল কর লে। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","জ়েরজামে কো বারীক কতান সে বুননা ঔর ইস তরহ পগড়ী ভী। ফির কমরবংদ বনানা। উস পর কঢ়াঈ কা কাম কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","হারূন কে বেটোং কে লিএ ভী জ়েরজামে, কমরবংদ ঔর পগড়িযাঁ বনানা তাকি ৱহ পুরৱক়ার ঔর শানদার নজ়র আএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","যহ সব অপনে ভাঈ হারূন ঔর উসকে বেটোং কো পহনানা। উনকে সরোং পর তেল উংডেলকর উন্হেং মসহ করনা। যোং উন্হেং উনকে ওহদে পর মুক়র্রর করকে মেরী খ়িদমত কে লিএ মখ়সূস করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","উনকে লিএ কতান কে পাজামে ভী বনানা তাকি ৱহ জ়েরজামে কে নীচে নংগে ন হোং। উনকী লংবাঈ কমর সে রান তক হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","জব ভী হারূন ঔর উসকে বেটে মুলাক়াত কে খ়ৈমে মেং দাখ়িল হোং তো উন্হেং যহ পাজামে পহননে হৈং। ইসী তরহ জব উন্হেং মুক়দ্দস কমরে মেং খ়িদমত করনে কে লিএ ক়ুরবানগাহ কে পাস আনা হোতা হৈ তো ৱহ যহ পহনেং, ৱরনা ৱহ ক়ুসূরৱার ঠহরকর মর জাএংগে। যহ হারূন ঔর উস কী ঔলাদ কে লিএ এক অবদী উসূল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ইমামোং কো মক়দিস মেং মেরী খ়িদমত কে লিএ মখ়সূস করনে কা যহ তরীক়া হৈ : এক জৱান বৈল ঔর দো বেঐব মেংঢে চুন লেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","বেহতরীন মৈদে সে তীন ক়িস্ম কী চীজ়েং পকানা জিনমেং খ়মীর ন হো। পহলে, সাদা রোটী। দূসরে, রোটী জিসমেং তেল ডালা গযা হো। তীসরে, রোটী জিস পর তেল লগাযা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","যহ চীজ়েং টোকরী মেং রখকর জৱান বৈল ঔর দো মেংঢোং কে সাথ রব কো পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ফির হারূন ঔর উসকে বেটোং কো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর লাকর গ়ুস্ল করানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ইসকে বাদ জ়েরজামা, চোগ়া, বালাপোশ ঔর সীনে কা কীসা লেকর হারূন কো পহনানা। বালাপোশ কো উসকে মহারত সে বুনে হুএ পটকে কে জ়রীএ বাঁধনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","উসকে সর পর পগড়ী বাঁধকর উস পর সোনে কী মুক়দ্দস তখ়্তী লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","হারূন কে সর পর মসহ কা তেল উংডেলকর উসে মসহ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ফির উসকে বেটোং কো আগে লাকর জ়েরজামা পহনানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","উনকে পগড়িযাঁ ঔর কমরবংদ বাঁধনা। যোং তূ হারূন ঔর উসকে বেটোং কো উনকে মংসব পর মুক়র্রর করনা। সির্ফ় ৱহ ঔর উনকী ঔলাদ হমেশা তক মক়দিস মেং মেরী খ়িদমত করতে রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","বৈল কো মুলাক়াত কে খ়ৈমে কে সামনে লানা। হারূন ঔর উসকে বেটে উসকে সর পর অপনে হাথ রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","উসে খ়ৈমে কে দরৱাজ়ে কে সামনে রব কে হুজ়ূর জ়বহ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","বৈল কে খ়ূন মেং সে কুছ লেকর অপনী উঁগলী সে ক়ুরবানগাহ কে সীংগোং পর লগানা ঔর বাক়ী খ়ূন ক়ুরবানগাহ কে পাএ পর উংডেল দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","অংতড়িযোং পর কী তমাম চরবী, জোড়কলেজী ঔর দোনোং গুরদে উনকী চরবী সমেত লেকর ক়ুরবানগাহ পর জলা দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","লেকিন বৈল কে গোশ্ত, খাল ঔর অংতড়িযোং কে গোবর কো খ়ৈমাগাহ কে বাহর জলা দেনা। যহ গুনাহ কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ইসকে বাদ পহলে মেংঢে কো লে আনা। হারূন ঔর উসকে বেটে অপনে হাথ মেংঢে কে সর পর রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","উসে জ়বহ করকে উসকা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","মেংঢে কো টুকড়ে টুকড়ে করকে উস কী অংতড়িযোং ঔর পিংডলিযোং কো ধোনা। ফির উন্হেং সর ঔর বাক়ী টুকড়োং কে সাথ মিলাকর ");
INSERT INTO urdgvb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","পূরে মেংঢে কো ক়ুরবানগাহ পর জলা দেনা। জলনেৱালী যহ ক়ুরবানী রব কে লিএ ভস্ম হোনেৱালী ক়ুরবানী হৈ, ঔর উস কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","অব দূসরে মেংঢে কো লে আনা। হারূন ঔর উসকে বেটে অপনে হাথ মেংঢে কে সর পর রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","উসকো জ়বহ করনা। উসকে খ়ূন মেং সে কুছ লেকর হারূন ঔর উসকে বেটোং কে দহনে কান কী লৌ পর লগানা। ইসী তরহ খ়ূন কো উনকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর ভী লগানা। বাক়ী খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","জো খ়ূন ক়ুরবানগাহ পর পড়া হৈ উসমেং সে কুছ লেকর ঔর মসহ কে তেল কে সাথ মিলাকর হারূন ঔর উসকে কপড়োং পর ছিড়কনা। ইসী তরহ উসকে বেটোং ঔর উনকে কপড়োং পর ভী ছিড়কনা। যোং ৱহ ঔর উসকে বেটে খ়িদমত কে লিএ মখ়সূসো-মুক়দ্দস হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ইস মেংঢে কা খ়াস মক়সদ যহ হৈ কি হারূন ঔর উসকে বেটোং কো মক়দিস মেং খ়িদমত করনে কা ইখ়্তিযার ঔর ওহদা দিযা জাএ। মেংঢে কী চরবী, দুম, অংতড়িযোং পর কী সারী চরবী, জোড়কলেজী, দোনোং গুরদে উনকী চরবী সমেত ঔর দহনী রান অলগ করনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","উস টোকরী মেং সে জো রব কে হুজ়ূর যানী খ়ৈমে কে দরৱাজ়ে পর পড়ী হৈ এক সাদা রোটী, এক রোটী জিসমেং তেল ডালা গযা হো ঔর এক রোটী জিস পর তেল লগাযা গযা হো নিকালনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","মেংঢে সে অলগ কী গঈ চীজ়েং ঔর বেখ়মীরী রোটী কী টোকরী কী যহ চীজ়েং লেকর হারূন ঔর উসকে বেটোং কে হাথোং মেং দেনা, ঔর ৱহ উন্হেং হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ফির যহ চীজ়েং উনসে ৱাপস লেকর ভস্ম হোনেৱালী ক়ুরবানী কে সাথ ক়ুরবানগাহ পর জলা দেনা। যহ রব কে লিএ জলনেৱালী ক়ুরবানী হৈ, ঔর উস কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","অব উস মেংঢে কা সীনা লেনা জিসকী মারিফ়ত হারূন কো ইমামে-আজ়ম কা ইখ়্তিযার দিযা জাতা হৈ। সীনে কো ভী হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলানা। যহ সীনা ক়ুরবানী কা তেরা হিস্সা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","যোং তুঝে হারূন ঔর উসকে বেটোং কী মখ়সূসিযত কে লিএ মুস্তামল মেংঢে কে টুকড়ে মখ়সূসো-মুক়দ্দস করনে হৈং। উসকে সীনে কো রব কে সামনে হিলানেৱালী ক়ুরবানী কে তৌর পর হিলাযা জাএ ঔর উস কী রান কো উঠানেৱালী ক়ুরবানী কে তৌর পর উঠাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","হারূন ঔর উস কী ঔলাদ কো ইসরাঈলিযোং কী তরফ় সে হমেশা তক যহ মিলনে কা হক় হৈ। জব ভী ইসরাঈলী রব কো অপনী সলামতী কী ক়ুরবানিযাঁ পেশ করেং তো ইমামোং কো যহ দো টুকড়ে মিলেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","জব হারূন ফ়ৌত হো জাএগা তো উসকে মুক়দ্দস লিবাস উস কী ঔলাদ মেং সে উস মর্দ কো দেনে হৈং জিসে মসহ করকে হারূন কী জগহ মুক়র্রর কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","জো বেটা উস কী জগহ মুক়র্রর কিযা জাএগা ঔর মক়দিস মেং খ়িদমত করনে কে লিএ মুলাক়াত কে খ়ৈমে মেং আএগা ৱহ যহ লিবাস সাত দিন তক পহনে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","জো মেংঢা হারূন ঔর উসকে বেটোং কী মখ়সূসিযত কে লিএ জ়বহ কিযা গযা হৈ উসে মুক়দ্দস জগহ পর উবালনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ফির হারূন ঔর উসকে বেটে মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর মেংঢে কা গোশ্ত ঔর টোকরী কী বেখ়মীরী রোটিযাঁ খাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ৱহ যহ চীজ়েং খাএঁ জিনসে উন্হেং গুনাহোং কা কফ়্ফ়ারা ঔর ইমাম কা ওহদা মিলা হৈ। লেকিন কোঈ ঔর যহ ন খাএ, ক্যোংকি যহ মখ়সূসো-মুক়দ্দস হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ঔর অগর অগলী সুবহ তক ইস গোশ্ত যা রোটী মেং সে কুছ বচ জাএ তো উসে জলাযা জাএ। উসে খানা মনা হৈ, ক্যোংকি ৱহ মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","জব তূ হারূন ঔর উসকে বেটোং কো ইমাম মুক়র্রর করেগা তো ঐন মেরী হিদাযত পর অমল করনা। যহ তক়রীব সাত দিন তক মনাঈ জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ইসকে দৌরান গুনাহ কী ক়ুরবানী কে তৌর পর রোজ়ানা এক জৱান বৈল জ়বহ করনা। ইসসে তূ ক়ুরবানগাহ কা কফ়্ফ়ারা দেকর উসে হর তরহ কী নাপাকী সে পাক করেগা। ইসকে অলাৱা উস পর মসহ কা তেল উংডেলনা। ইসসে ৱহ মেরে লিএ মখ়সূসো-মুক়দ্দস হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","সাত দিন তক ক়ুরবানগাহ কা কফ়্ফ়ারা দেকর উসে পাক-সাফ় করনা ঔর উসে তেল সে মখ়সূসো-মুক়দ্দস করনা। ফির ক়ুরবানগাহ নিহাযত মুক়দ্দস হোগী। জো ভী উসে ছুএগা ৱহ ভী মখ়সূসো-মুক়দ্দস হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","রোজ়ানা এক এক সাল কে দো ভেড় কে নর বচ্চে ক়ুরবানগাহ পর জলা দেনা, ");
INSERT INTO urdgvb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","এক কো সুবহ কে ৱক়্ত, দূসরে কো সূরজ কে গ়ুরূব হোনে কে ঐন বাদ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","পহলে জানৱর কে সাথ ডেঢ় কিলোগ্রাম বেহতরীন মৈদা পেশ কিযা জাএ জো কূটে হুএ জ়ৈতূনোং কে এক লিটর তেল কে সাথ মিলাযা গযা হো। মৈ কী নজ়র কে তৌর পর এক লিটর মৈ ভী ক়ুরবানগাহ পর উংডেলনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","দূসরে জানৱর কে সাথ ভী গ়ল্লা ঔর মৈ কী যহ দো নজ়রেং পেশ কী জাএঁ। ঐসী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","লাজ়িম হৈ কি আনেৱালী তমাম নসলেং ভস্ম হোনেৱালী যহ ক়ুরবানী বাক়াযদগী সে মুক়দ্দস খ়ৈমে কে দরৱাজ়ে পর রব কে হুজ়ূর চঢ়াএঁ। ৱহাঁ মৈং তুমসে মিলা করূঁগা ঔর তুমসে হমকলাম হূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ৱহাঁ মৈং ইসরাঈলিযোং সে ভী মিলা করূঁগা, ঔর ৱহ জগহ মেরে জলাল সে মখ়সূসো-মুক়দ্দস হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","যোং মৈং মুলাক়াত কে খ়ৈমে ঔর ক়ুরবানগাহ কো মখ়সূস করূঁগা ঔর হারূন ঔর উসকে বেটোং কো মখ়সূস করূঁগা তাকি ৱহ ইমামোং কী হৈসিযত সে মেরী খ়িদমত করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","তব মৈং ইসরাঈলিযোং কে দরমিযান রহূঁগা ঔর উনকা খ়ুদা হূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ৱহ জান লেংগে কি মৈং রব উনকা খ়ুদা হূঁ, কি মৈং উন্হেং মিসর সে নিকাল লাযা তাকি উনকে দরমিযান সুকূনত করূঁ। মৈং রব উনকা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","কীকর কী লকড়ী কী ক়ুরবানগাহ বনানা জিস পর বখ়ূর জলাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ৱহ ডেঢ় ফ়ুট লংবী, ইতনী হী চৌড়ী ঔর তীন ফ়ুট ঊঁচী হো। উসকে চারোং কোনোং মেং সে সীংগ নিকলেং জো ক়ুরবানগাহ কে সাথ এক হী টুকড়ে সে বনাএ গএ হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","উস কী ঊপর কী সতহ, উসকে চার পহলুওং ঔর উসকে সীংগোং পর খ়ালিস সোনা চঢ়ানা। ঊপর কী সতহ কে ইর্দগির্দ সোনে কী ঝালর হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","সোনে কে দো কড়ে বনাকর ইন্হেং উস ঝালর কে নীচে এক দূসরে কে মুক়াবিল পহলুওং পর লগানা। ইন কড়োং মেং ক়ুরবানগাহ কো উঠানে কী লকড়িযাঁ ডালী জাএঁগী। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","যহ লকড়িযাঁ কীকর কী হোং, ঔর উন পর ভী সোনা চঢ়ানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ইস ক়ুরবানগাহ কো খ়ৈমে কে মুক়দ্দস কমরে মেং উস পরদে কে সামনে রখনা জিসকে পীছে অহদ কা সংদূক় ঔর উসকা ঢকনা হোংগে, ৱহ ঢকনা জহাঁ মৈং তুঝসে মিলা করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","জব হারূন হর সুবহ শমাদান কে চরাগ় তৈযার করে উস ৱক়্ত ৱহ উস পর খ়ুশবূদার বখ়ূর জলাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","সূরজ কে গ়ুরূব হোনে কে বাদ ভী জব ৱহ দুবারা চরাগ়োং কী দেখ-ভাল করেগা তো ৱহ সাথ সাথ বখ়ূর জলাএ। যোং রব কে সামনে বখ়ূর মুতৱাতির জলতা রহে। লাজ়িম হৈ কি বাদ কী নসলেং ভী ইস উসূল পর ক়াযম রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ইস ক়ুরবানগাহ পর সির্ফ় জাযজ় বখ়ূর ইস্তেমাল কিযা জাএ। ইস পর ন তো জানৱরোং কী ক়ুরবানিযাঁ চঢ়াঈ জাএঁ, ন গ়ল্লা যা মৈ কী নজ়রেং পেশ কী জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","হারূন সাল মেং এক দফ়া উসকা কফ়্ফ়ারা দেকর উসে পাক করে। ইসকে লিএ ৱহ কফ়্ফ়ারে কে দিন উস ক়ুরবানী কা কুছ খ়ূন সীংগোং পর লগাএ। যহ উসূল ভী অবদ তক ক়াযম রহে। যহ ক়ুরবানগাহ রব কে লিএ নিহাযত মুক়দ্দস হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“জব ভী তূ ইসরাঈলিযোং কী মর্দুমশুমারী করে তো লাজ়িম হৈ কি জিনকা শুমার কিযা গযা হো ৱহ রব কো অপনী জান কা ফ়িদ্যা দেং তাকি উনমেং ৱবা ন ফৈলে। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","জিস জিসকা শুমার কিযা গযা হো ৱহ চাঁদী কে আধে সিক্কে কে বরাবর রক়ম উঠানেৱালী ক়ুরবানী কে তৌর পর দে। সিক্কে কা ৱজ়ন মক়দিস কে সিক্কোং কে বরাবর হো। যানী চাঁদী কে সিক্কে কা ৱজ়ন 11 গ্রাম হো, ইসলিএ ছঃ গ্রাম চাঁদী দেনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","জিসকী ভী উম্র 20 সাল যা ইসসে জ়াযদ হো ৱহ রব কো যহ রক়ম উঠানেৱালী ক়ুরবানী কে তৌর পর দে। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","অমীর ঔর গ়রীব দোনোং ইতনা হী দেং, ক্যোংকি যহী নজ়রানা রব কো পেশ করনে সে তুম্হারী জান কা কফ়্ফ়ারা দিযা জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","কফ়্ফ়ারে কী যহ রক়ম মুলাক়াত কে খ়ৈমে কী খ়িদমত কে লিএ ইস্তেমাল করনা। ফির যহ নজ়রানা রব কো যাদ দিলাতা রহেগা কি তুম্হারী জানোং কা কফ়্ফ়ারা দিযা গযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“পীতল কা ঢাঁচা বনানা জিস পর পীতল কা হৌজ় বনাকর রখনা হৈ। যহ হৌজ় ধোনে কে লিএ হৈ। উসে সহন মেং মুলাক়াত কে খ়ৈমে ঔর জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ কে দরমিযান রখকর পানী সে ভর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","হারূন ঔর উসকে বেটে অপনে হাথ-পাঁৱ ধোনে কে লিএ উসকা পানী ইস্তেমাল করেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","মুলাক়াত কে খ়ৈমে মেং দাখ়িল হোনে সে পহলে হী ৱহ অপনে আপকো ধোএঁ ৱরনা ৱহ মর জাএংগে। ইসী তরহ জব ভী ৱহ খ়ৈমে কে বাহর কী ক়ুরবানগাহ পর জানৱরোং কী ক়ুরবানিযাঁ চঢ়াএঁ ");
INSERT INTO urdgvb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","তো লাজ়িম হৈ কি পহলে হাথ-পাঁৱ ধো লেং, ৱরনা ৱহ মর জাএংগে। যহ উসূল হারূন ঔর উস কী ঔলাদ কে লিএ হমেশা তক ক়াযম রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“মসহ কে তেল কে লিএ উম্দা ক়িস্ম কে মসালে ইস্তেমাল করনা। 6 কিলোগ্রাম আবে-মুর, 3 কিলোগ্রাম খ়ুশবূদার দারচীনী, 3 কিলোগ্রাম খ়ুশবূদার বেদ ");
INSERT INTO urdgvb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ঔর 6 কিলোগ্রাম তেজপাত। যহ চীজ়েং মক়দিস কে বাটোং কে হিসাব সে তোলকর চার লিটর জ়ৈতূন কে তেল মেং ডালনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","সব কুছ মিলাকর খ়ুশবূদার তেল তৈযার করনা। ৱহ মুক়দ্দস হৈ ঔর সির্ফ় উস ৱক়্ত ইস্তেমাল কিযা জাএ জব কোঈ চীজ় যা শখ়্স মেরে লিএ মখ়সূসো-মুক়দ্দস কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","যহী তেল লেকর মুলাক়াত কা খ়ৈমা ঔর উসকা সারা সামান মসহ করনা যানী খ়ৈমা, অহদ কা সংদূক়, ");
INSERT INTO urdgvb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","মেজ় ঔর উসকা সামান, শমাদান ঔর উসকা সামান, বখ়ূর জলানে কী ক়ুরবানগাহ, ");
INSERT INTO urdgvb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ ঔর উসকা সামান, ধোনে কা হৌজ় ঔর উসকা ঢাঁচা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","যোং তূ যহ তমাম চীজ়েং মখ়সূসো-মুক়দ্দস করেগা। ইসসে ৱহ নিহাযত মুক়দ্দস হো জাএঁগী। জো ভী উন্হেং ছুএগা ৱহ মুক়দ্দস হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","হারূন ঔর উসকে বেটোং কো ভী ইস তেল সে মসহ করনা তাকি ৱহ মুক়দ্দস হোকর মেরে লিএ ইমাম কা কাম সরংজাম দে সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ইসরাঈলিযোং কো কহ দে কি যহ তেল হমেশা তক মেরে লিএ মখ়সূসো-মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ইসলিএ ইসে অপনে লিএ ইস্তেমাল ন করনা ঔর ন ইস তরকীব সে অপনে লিএ তেল বনানা। যহ তেল মখ়সূসো-মুক়দ্দস হৈ ঔর তুম্হেং ভী ইসে যোং ঠহরানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","জো ইস তরকীব সে আম ইস্তেমাল কে লিএ তেল বনাতা হৈ যা কিসী আম শখ়্স পর লগাতা হৈ উসে উস কী ক়ৌম মেং সে মিটা ডালনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","রব নে মূসা সে কহা, “বখ়ূর ইস তরকীব সে বনানা হৈ : মস্তকী, ওনিকা, বিরীজা ঔর খ়ালিস লুবান বরাবর কে হিস্সোং মেং ");
INSERT INTO urdgvb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","মিলাকর খ়ুশবূদার বখ়ূর বনানা। ইত্রসাজ় কা যহ কাম নমকীন, খ়ালিস ঔর মুক়দ্দস হো। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ইসমেং সে কুছ পীসকর পৌডর বনানা ঔর মুলাক়াত কে খ়ৈমে মেং অহদ কে সংদূক় কে সামনে ডালনা জহাঁ মৈং তুঝসে মিলা করূঁগা। ইস বখ়ূর কো মুক়দ্দসতরীন ঠহরানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ইসী তরকীব কে মুতাবিক় অপনে লিএ বখ়ূর ন বনানা। ইসে রব কে লিএ মখ়সূসো-মুক়দ্দস ঠহরানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","জো ভী অপনে জ়াতী ইস্তেমাল কে লিএ ইস ক়িস্ম কা বখ়ূর বনাএ উসে উস কী ক়ৌম মেং সে মিটা ডালনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ফির রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“মৈংনে যহূদাহ কে ক়বীলে কে বজ়লিযেল বিন ঊরী বিন হূর কো চুন লিযা হৈ তাকি ৱহ মুক়দ্দস খ়ৈমে কী তামীর মেং রাহনুমাঈ করে। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","মৈংনে উসে ইলাহী রূহ সে মামূর করকে হিকমত, সমঝ ঔর তামীর কে হর কাম কে লিএ দরকার ইল্ম দে দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ৱহ নক়্শে বনাকর উনকে মুতাবিক় সোনে, চাঁদী ঔর পীতল কী চীজ়েং বনা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ৱহ জৱাহর কো কাটকর জড়নে কী ক়াবিলিযত রখতা হৈ। ৱহ লকড়ী কো তরাশকর উসসে মুখ়্তলিফ় চীজ়েং বনা সকতা হৈ। ৱহ বহুত সারে ঔর কামোং মেং ভী মহারত রখতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","সাথ হী মৈংনে দান কে ক়বীলে কে উহলিযাব বিন অখ়ী-সমক কো মুক়র্রর কিযা হৈ তাকি ৱহ হর কাম মেং উস কী মদদ করে। ইসকে অলাৱা মৈংনে তমাম সমঝদার কারীগরোং কো মহারত দী হৈ তাকি ৱহ সব কুছ উন হিদাযাত কে মুতাবিক় বনা সকেং জো মৈংনে তুঝে দী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","যানী মুলাক়াত কা খ়ৈমা, কফ়্ফ়ারে কে ঢকনে সমেত অহদ কা সংদূক় ঔর খ়ৈমে কা সারা দূসরা সামান, ");
INSERT INTO urdgvb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","মেজ় ঔর উসকা সামান, খ়ালিস সোনে কা শমাদান ঔর উসকা সামান, বখ়ূর জলানে কী ক়ুরবানগাহ, ");
INSERT INTO urdgvb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ ঔর উসকা সামান, ধোনে কা হৌজ় উস ঢাঁচে সমেত জিস পর ৱহ রখা জাতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ৱহ লিবাস জো হারূন ঔর উসকে বেটে মক়দিস মেং খ়িদমত করনে কে লিএ পহনতে হৈং, ");
INSERT INTO urdgvb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","মসহ কা তেল ঔর মক়দিস কে লিএ খ়ুশবূদার বখ়ূর। যহ সব কুছ ৱহ ৱৈসে হী বনাএঁ জৈসে মৈংনে তুঝে হুক্ম দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ইসরাঈলিযোং কো বতা কি হর সবত কা দিন জ়রূর মনাও। ক্যোংকি সবত কা দিন এক নুমাযাঁ নিশান হৈ জিসসে জান লিযা জাএগা কি মৈং রব হূঁ জো তুম্হেং মখ়সূসো-মুক়দ্দস করতা হূঁ। ঔর যহ নিশান মেরে ঔর তুম্হারে দরমিযান নসল-দর-নসল ক়াযম রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","সবত কা দিন জ়রূর মনানা, ক্যোংকি ৱহ তুম্হারে লিএ মখ়সূসো-মুক়দ্দস হৈ। জো ভী উস কী বেহুরমতী করে ৱহ জ়রূর জান সে মারা জাএ। জো ভী ইস দিন কাম করে উসে উস কী ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ছঃ দিন কাম করনা, লেকিন সাতৱাঁ দিন আরাম কা দিন হৈ। ৱহ রব কে লিএ মখ়সূসো-মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ইসরাঈলিযোং কো হাল মেং ঔর মুস্তক়বিল মেং সবত কা দিন অবদী অহদ সমঝকর মনানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ৱহ মেরে ঔর ইসরাঈলিযোং কে দরমিযান অবদী নিশান হোগা। ক্যোংকি রব নে ছঃ দিন কে দৌরান আসমানো-জ়মীন কো বনাযা জবকি সাতৱেং দিন উসনে আরাম কিযা ঔর তাজ়াদম হো গযা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","যহ সব কুছ মূসা কো বতানে কে বাদ রব নে উসে সীনা পহাড় পর শরীঅত কী দো তখ়্তিযাঁ দীং। অল্লাহ নে খ়ুদ পত্থর কী ইন তখ়্তিযোং পর তমাম বাতেং লিখী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","পহাড় কে দামন মেং লোগ মূসা কে ইংতজ়ার মেং রহে, লেকিন বহুত দের হো গঈ। এক দিন ৱহ হারূন কে গির্দ জমা হোকর কহনে লগে, “আএঁ, হমারে লিএ দেৱতা বনা দেং জো হমারে আগে আগে চলতে হুএ হমারী রাহনুমাঈ করেং। ক্যোংকি ক্যা মালূম কি উস বংদে মূসা কো ক্যা হুআ হৈ জো হমেং মিসর সে নিকাল লাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","জৱাব মেং হারূন নে কহা, “আপকী বীৱিযাঁ, বেটে ঔর বেটিযাঁ অপনী সোনে কী বালিযাঁ উতারকর মেরে পাস লে আএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","সব লোগ অপনী বালিযাঁ উতার উতারকর হারূন কে পাস লে আএ ");
INSERT INTO urdgvb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","তো উসনে যহ জ়েৱরাত লেকর বছড়া ঢাল দিযা। বছড়ে কো দেখকর লোগ বোল উঠে, “ঐ ইসরাঈল, যহ তেরে দেৱতা হৈং জো তুঝে মিসর সে নিকাল লাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","জব হারূন নে যহ দেখা তো উসনে বছড়ে কে সামনে ক়ুরবানগাহ বনাকর এলান কিযা, “কল হম রব কী তাজ়ীম মেং ঈদ মনাএঁগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","অগলে দিন লোগ সুবহ-সৱেরে উঠে ঔর ভস্ম হোনেৱালী ক়ুরবানিযাঁ ঔর সলামতী কী ক়ুরবানিযাঁ চঢ়াঈং। ৱহ খানে-পীনে কে লিএ বৈঠ গএ ঔর ফির উঠকর রংগরলিযোং মেং অপনে দিল বহলানে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","উস ৱক়্ত রব নে মূসা সে কহা, “পহাড় সে উতর জা। তেরে লোগ জিন্হেং তূ মিসর সে নিকাল লাযা বড়ী শরারতেং কর রহে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ৱহ কিতনী জল্দী সে উস রাস্তে সে হট গএ হৈং জিস পর চলনে কে লিএ মৈংনে উন্হেং হুক্ম দিযা থা। উন্হোংনে অপনে লিএ ঢালা হুআ বছড়া বনাকর উসে সিজদা কিযা হৈ। উন্হোংনে উসে ক়ুরবানিযাঁ পেশ করকে কহা হৈ, ‘ঐ ইসরাঈল, যহ তেরে দেৱতা হৈং। যহী তুঝে মিসর সে নিকাল লাএ হৈং’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","অল্লাহ নে মূসা সে কহা, “মৈংনে দেখা হৈ কি যহ ক়ৌম বড়ী হটধর্ম হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","অব মুঝে রোকনে কী কোশিশ ন কর। মৈং উন পর অপনা গ়জ়ব উংডেলকর উনকো রূএ-জ়মীন পর সে মিটা দূঁগা। উনকী জগহ মৈং তুঝসে এক বড়ী ক়ৌম বনা দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","লেকিন মূসা নে কহা, “ঐ রব, তূ অপনী ক়ৌম পর অপনা গ়ুস্সা ক্যোং উতারনা চাহতা হৈ? তূ খ়ুদ অপনী অজ়ীম ক়ুদরত সে উসে মিসর সে নিকাল লাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","মিসরী ক্যোং কহেং, ‘রব ইসরাঈলিযোং কো সির্ফ় ইস বুরে মক়সদ সে হমারে মুল্ক সে নিকাল লে গযা হৈ কি উন্হেং পহাড়ী ইলাক়ে মেং মার ডালে ঔর যোং উন্হেং রূএ-জ়মীন পর সে মিটাএ’? অপনা গ়ুস্সা ঠংডা হোনে দে ঔর অপনী ক়ৌম কে সাথ বুরা সুলূক করনে সে বাজ় রহ। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","যাদ রখ কি তূনে অপনে খ়াদিমোং ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে অপনী হী ক়সম খাকর কহা থা, ‘মৈং তুম্হারী ঔলাদ কী তাদাদ যোং বঢ়াঊঁগা কি ৱহ আসমান কে সিতারোং কে বরাবর হো জাএগী। মৈং উন্হেং ৱহ মুল্ক দূঁগা জিসকা ৱাদা মৈংনে কিযা হৈ, ঔর ৱহ উসে হমেশা কে লিএ মীরাস মেং পাএঁগে’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","মূসা কে কহনে পর রব নে ৱহ নহীং কিযা জিসকা এলান উসনে কর দিযা থা বল্কি ৱহ অপনী ক়ৌম সে বুরা সুলূক করনে সে বাজ় রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","মূসা মুড়কর পহাড় সে উতরা। উসকে হাথোং মেং শরীঅত কী দোনোং তখ়্তিযাঁ থীং। উন পর আগে পীছে লিখা গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","অল্লাহ নে খ়ুদ তখ়্তিযোং কো বনাকর উন পর অপনে অহকাম কংদা কিএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","উতরতে উতরতে যশুঅ নে লোগোং কা শোর সুনা ঔর মূসা সে কহা, “খ়ৈমাগাহ মেং জংগ কা শোর মচ রহা হৈ!” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","মূসা নে জৱাব দিযা, “ন তো যহ ফ়তহমংদোং কে নারে হৈং, ন শিকস্ত খাএ হুওং কী চীখ়-পুকার। মুঝে গানেৱালোং কী আৱাজ় সুনাঈ দে রহী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","জব ৱহ খ়ৈমাগাহ কে নজ়দীক পহুঁচা তো উসনে লোগোং কো সোনে কে বছড়ে কে সামনে নাচতে হুএ দেখা। বড়ে গ়ুস্সে মেং আকর উসনে তখ়্তিযোং কো জ়মীন পর পটখ় দিযা, ঔর ৱহ টুকড়ে টুকড়ে হোকর পহাড় কে দামন মেং গির গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","মূসা নে ইসরাঈলিযোং কে বনাএ হুএ বছড়ে কো জলা দিযা। জো কুছ বচ গযা উসে উসনে পীস পীসকর পৌডর বনা ডালা ঔর পৌডর পানী পর ছিড়ককর ইসরাঈলিযোং কো পিলা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","উসনে হারূন সে পূছা, “ইন লোগোং নে তুম্হারে সাথ ক্যা কিযা কি তুমনে উন্হেং ঐসে বড়ে গুনাহ মেং ফঁসা দিযা?” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","হারূন নে কহা, “মেরে আক়া। গ়ুস্সে ন হোং। আপ খ়ুদ জানতে হৈং কি যহ লোগ বদী পর তুলে রহতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","উন্হোংনে মুঝসে কহা, ‘হমারে লিএ দেৱতা বনা দেং জো হমারে আগে আগে চলতে হুএ হমারী রাহনুমাঈ করেং। ক্যোংকি ক্যা মালূম কি উস বংদে মূসা কো ক্যা হুআ হৈ জো হমেং মিসর সে নিকাল লাযা।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ইসলিএ মৈংনে উনকো বতাযা, ‘জিসকে পাস সোনে কে জ়েৱরাত হৈং ৱহ উন্হেং উতার লাএ।’ জো কুছ উন্হোংনে মুঝে দিযা উসে মৈংনে আগ মেং ফেংক দিযা তো হোতে হোতে সোনে কা যহ বছড়া নিকল আযা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","মূসা নে দেখা কি লোগ বেকাবূ হো গএ হৈং। ক্যোংকি হারূন নে উন্হেং বেলগাম ছোড় দিযা থা, ঔর যোং ৱহ ইসরাঈল কে দুশ্মনোং কে লিএ মজ়াক় কা নিশানা বন গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","মূসা খ়ৈমাগাহ কে দরৱাজ়ে পর খড়ে হোকর বোলা, “জো ভী রব কা বংদা হৈ ৱহ মেরে পাস আএ।” জৱাব মেং লাৱী কে ক়বীলে কে তমাম লোগ উসকে পাস জমা হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ফির মূসা নে উনসে কহা, “রব ইসরাঈল কা খ়ুদা ফ়রমাতা হৈ, ‘হর এক অপনী তলৱার লেকর খ়ৈমাগাহ মেং সে গুজ়রে। এক সিরে কে দরৱাজ়ে সে শুরূ করকে দূসরে সিরে কে দরৱাজ়ে তক চলতে চলতে হর মিলনেৱালে কো জান সে মার দো, চাহে ৱহ তুম্হারা ভাঈ, দোস্ত যা রিশ্তেদার হী ক্যোং ন হো। ফির মুড়কর মারতে মারতে পহলে দরৱাজ়ে পর ৱাপস আ জাও’।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","লাৱিযোং নে মূসা কী হিদাযত পর অমল কিযা তো উস দিন তক়রীবন 3,000 মর্দ হলাক হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","যহ দেখকর মূসা নে লাৱিযোং সে কহা, “আজ অপনে আপকো মক়দিস মেং রব কী খ়িদমত করনে কে লিএ মখ়সূসো-মুক়দ্দস করো, ক্যোংকি তুম অপনে বেটোং ঔর ভাইযোং কে খ়িলাফ় লড়নে কে লিএ তৈযার থে। ইসলিএ রব তুমকো আজ বরকত দেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","অগলে দিন মূসা নে ইসরাঈলিযোং সে বাত কী, “তুমনে নিহাযত সংগীন গুনাহ কিযা হৈ। তো ভী মৈং অব রব কে পাস পহাড় পর জা রহা হূঁ। শাযদ মৈং তুম্হারে গুনাহ কা কফ়্ফ়ারা দে সকূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","চুনাঁচে মূসা নে রব কে পাস ৱাপস জাকর কহা, “হায, ইস ক়ৌম নে নিহাযত সংগীন গুনাহ কিযা হৈ। উন্হোংনে অপনে লিএ সোনে কা দেৱতা বনা লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","মেহরবানী করকে উন্হেং মুআফ় কর। লেকিন অগর তূ উন্হেং মুআফ় ন করে তো ফির মুঝে ভী অপনী উস কিতাব মেং সে মিটা দে জিসমেং তূনে অপনে লোগোং কে নাম দর্জ কিএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","রব নে জৱাব দিযা, “মৈং সির্ফ় উসকো অপনী কিতাব মেং সে মিটাতা হূঁ জো মেরা গুনাহ করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","অব জা, লোগোং কো উস জগহ লে চল জিসকা জ়িক্র মৈংনে কিযা হৈ। মেরা ফ়রিশ্তা তেরে আগে আগে চলেগা। লেকিন জব সজ়া কা মুক়র্ররা দিন আএগা তব মৈং উন্হেং সজ়া দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ফির রব নে ইসরাঈলিযোং কে দরমিযান ৱবা ফৈলনে দী, ইসলিএ কি উন্হোংনে উস বছড়ে কী পূজা কী থী জো হারূন নে বনাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","রব নে মূসা সে কহা, “ইস জগহ সে রৱানা হো জা। উন লোগোং কো লেকর জিনকো তূ মিসর সে নিকাল লাযা হৈ উস মুল্ক কো জা জিসকা ৱাদা মৈংনে ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে কিযা হৈ। উন্হীং সে মৈংনে ক়সম খাকর কহা থা, ‘মৈং যহ মুল্ক তুম্হারী ঔলাদ কো দূঁগা।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","মৈং তেরে আগে আগে ফ়রিশ্তা ভেজকর কনানী, অমোরী, হিত্তী, ফ়রিজ়্জ়ী, হিৱ্ৱী ঔর যবূসী অক়ৱাম কো উস মুল্ক সে নিকাল দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","উঠ, উস মুল্ক কো জা জহাঁ দূধ ঔর শহদ কী কসরত হৈ। লেকিন মৈং সাথ নহীং জাঊঁগা। তুম ইতনে হটধর্ম হো কি অগর মৈং সাথ জাঊঁ তো খ়তরা হৈ কি তুম্হেং ৱহাঁ পহুঁচনে সে পহলে হী বরবাদ কর দূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","জব ইসরাঈলিযোং নে যহ সখ়্ত অলফ়াজ় সুনে তো ৱহ মাতম করনে লগে। কিসী নে ভী অপনে জ়েৱর ন পহনে, ");
INSERT INTO urdgvb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ক্যোংকি রব নে মূসা সে কহা থা, “ইসরাঈলিযোং কো বতা কি তুম হটধর্ম হো। অগর মৈং এক লমহা ভী তুম্হারে সাথ চলূঁ তো খ়তরা হৈ কি মৈং তুম্হেং তবাহ কর দূঁ। অব অপনে জ়েৱরাত উতার ডালো। ফির মৈং ফ়ৈসলা করূঁগা কি তুম্হারে সাথ ক্যা কিযা জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ইন অলফ়াজ় পর ইসরাঈলিযোং নে হোরিব যানী সীনা পহাড় পর অপনে জ়েৱর উতার দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","উস ৱক়্ত মূসা নে খ়ৈমা লেকর উসে কুছ ফ়াসলে পর খ়ৈমাগাহ কে বাহর লগা দিযা। উসনে উসকা নাম ‘মুলাক়াত কা খ়ৈমা’ রখা। জো ভী রব কী মরজ়ী দরিযাফ়্ত করনা চাহতা ৱহ খ়ৈমাগাহ সে নিকলকর ৱহাঁ জাতা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","জব ভী মূসা খ়ৈমাগাহ সে নিকলকর ৱহাঁ জাতা তো তমাম লোগ অপনে খ়ৈমোং কে দরৱাজ়োং পর খড়ে হোকর মূসা কে পীছে দেখনে লগতে। উসকে মুলাক়াত কে খ়ৈমে মেং ওঝল হোনে তক ৱহ উসে দেখতে রহতে। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","মূসা কে খ়ৈমে মেং দাখ়িল হোনে পর বাদল কা সতূন উতরকর খ়ৈমে কে দরৱাজ়ে পর ঠহর জাতা। জিতনী দের তক রব মূসা সে বাতেং করতা উতনী দের তক ৱহ ৱহাঁ ঠহরা রহতা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","জব ইসরাঈলী মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর বাদল কা সতূন দেখতে তো ৱহ অপনে অপনে খ়ৈমে কে দরৱাজ়ে পর খড়ে হোকর সিজদা করতে। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","রব মূসা সে রূবরূ বাতেং করতা থা, ঐসে শখ়্স কী তরহ জো অপনে দোস্ত সে বাতেং করতা হৈ। ইসকে বাদ মূসা নিকলকর খ়ৈমাগাহ কো ৱাপস চলা জাতা। লেকিন উসকা জৱান মদদগার যশুঅ বিন নূন খ়ৈমে কো নহীং ছোড়তা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","মূসা নে রব সে কহা, “দেখ, তূ মুঝসে কহতা আযা হৈ কি ইস ক়ৌম কো কনান লে চল। লেকিন তূ মেরে সাথ কিস কো ভেজেগা? তূনে অব তক যহ বাত মুঝে নহীং বতাঈ হালাঁকি তূনে কহা হৈ, ‘মৈং তুঝে বনাম জানতা হূঁ, তুঝে মেরা করম হাসিল হুআ হৈ।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","অগর মুঝে ৱাক়ঈ তেরা করম হাসিল হৈ তো মুঝে অপনে রাস্তে দিখা তাকি মৈং তুঝে জান লূঁ ঔর তেরা করম মুঝে হাসিল হোতা রহে। ইস বাত কা খ়যাল রখ কি যহ ক়ৌম তেরী হী উম্মত হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","রব নে জৱাব দিযা, “মৈং খ়ুদ তেরে সাথ চলূঁগা ঔর তুঝে আরাম দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","মূসা নে কহা, “অগর তূ খ়ুদ সাথ নহীং চলেগা তো ফির হমেং যহাঁ সে রৱানা ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","অগর তূ হমারে সাথ ন জাএ তো কিস তরহ পতা চলেগা কি মুঝে ঔর তেরী ক়ৌম কো তেরা করম হাসিল হুআ হৈ? হম সির্ফ় ইসী ৱজহ সে দুনিযা কী দীগর ক়ৌমোং সে অলগ ঔর মুমতাজ় হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","রব নে মূসা সে কহা, “মৈং তেরী যহ দরখ়াস্ত ভী পূরী করূঁগা, ক্যোংকি তুঝে মেরা করম হাসিল হুআ হৈ ঔর মৈং তুঝে বনাম জানতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ফির মূসা বোলা, “বরাহে-করম মুঝে অপনা জলাল দিখা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","রব নে জৱাব দিযা, “মৈং অপনী পূরী ভলাঈ তেরে সামনে সে গুজ়রনে দূঁগা ঔর তেরে সামনে হী অপনে নাম রব কা এলান করূঁগা। মৈং জিস পর মেহরবান হোনা চাহূঁ উস পর মেহরবান হোতা হূঁ, ঔর জিস পর রহম করনা চাহূঁ উস পর রহম করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","লেকিন তূ মেরা চেহরা নহীং দেখ সকতা, ক্যোংকি জো ভী মেরা চেহরা দেখে ৱহ জ়িংদা নহীং রহ সকতা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ফির রব নে ফ়রমাযা, “দেখ, মেরে পাস এক জগহ হৈ। ৱহাঁ কী চট্টান পর খড়া হো জা। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","জব মেরা জলাল ৱহাঁ সে গুজ়রেগা তো মৈং তুঝে চট্টান কে এক শিগাফ় মেং রখূঁগা ঔর অপনা হাথ তেরে ঊপর ফৈলাঊঁগা তাকি তূ মেরে গুজ়রনে কে দৌরান মহফ়ূজ় রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ইসকে বাদ মৈং অপনা হাথ হটাঊঁগা ঔর তূ মেরে পীছে দেখ সকেগা। লেকিন মেরা চেহরা দেখা নহীং জা সকতা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","রব নে মূসা সে কহা, “অপনে লিএ পত্থর কী দো তখ়্তিযাঁ তরাশ লে জো পহলী দো কী মানিংদ হোং। ফির মৈং উন পর ৱহ অলফ়াজ় লিখূঁগা জো পহলী তখ়্তিযোং পর লিখে থে জিন্হেং তূনে পটখ় দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","সুবহ তক তৈযার হোকর সীনা পহাড় পর চঢ়না। চোটী পর মেরে সামনে খড়া হো জা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","তেরে সাথ কোঈ ভী ন আএ বল্কি পূরে পহাড় পর কোঈ ঔর শখ়্স নজ়র ন আএ, যহাঁ তক কি ভেড়-বকরিযাঁ ঔর গায-বৈল ভী পহাড় কে দামন মেং ন চরেং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","চুনাঁচে মূসা নে দো তখ়্তিযাঁ তরাশ লীং জো পহলী কী মানিংদ থীং। ফির ৱহ সুবহ-সৱেরে উঠকর সীনা পহাড় পর চঢ় গযা জিস তরহ রব নে উসে হুক্ম দিযা থা। উসকে হাথোং মেং পত্থর কী দোনোং তখ়্তিযাঁ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","জব ৱহ চোটী পর পহুঁচা তো রব বাদল মেং উতর আযা ঔর উসকে পাস খড়ে হোকর অপনে নাম রব কা এলান কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","মূসা কে সামনে সে গুজ়রতে হুএ উসনে পুকারা, “রব, রব, রহীম ঔর মেহরবান খ়ুদা। তহম্মুল, শফ়ক়ত ঔর ৱফ়া সে ভরপূর। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ৱহ হজ়ারোং পর অপনী শফ়ক়ত ক়াযম রখতা ঔর লোগোং কা ক়ুসূর, নাফ়রমানী ঔর গুনাহ মুআফ় করতা হৈ। লেকিন ৱহ হর এক কো উস কী মুনাসিব সজ়া ভী দেতা হৈ। জব ৱালিদৈন গুনাহ করেং তো উনকী ঔলাদ কো ভী তীসরী ঔর চৌথী পুশ্ত তক সজ়া কে নতাযজ ভুগতনে পড়েংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","মূসা নে জল্দী সে ঝুককর সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","উসনে কহা, “ঐ রব, অগর মুঝ পর তেরা করম হো তো হমারে সাথ চল। বেশক যহ ক়ৌম হটধর্ম হৈ, তো ভী হমারা ক়ুসূর ঔর গুনাহ মুআফ় কর ঔর বখ়্শ দে কি হম দুবারা তেরে হী বন জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","তব রব নে কহা, “মৈং তুম্হারে সাথ অহদ বাঁধূঁগা। তেরী ক়ৌম কে সামনে হী মৈং ঐসে মোজিজ়ে করূঁগা জো অব তক দুনিযা-ভর কী কিসী ভী ক়ৌম মেং নহীং কিএ গএ। পূরী ক়ৌম জিসকে দরমিযান তূ রহতা হৈ রব কা কাম দেখেগী ঔর উসসে ডর জাএগী জো মৈং তেরে সাথ করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","জো অহকাম মৈং আজ দেতা হূঁ উন পর অমল করতা রহ। মৈং অমোরী, কনানী, হিত্তী, ফ়রিজ়্জ়ী, হিৱ্ৱী ঔর যবূসী অক়ৱাম কো তেরে আগে আগে মুল্ক সে নিকাল দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","খ়বরদার, জো উস মুল্ক মেং রহতে হৈং জহাঁ তূ জা রহা হৈ উনসে অহদ ন বাঁধনা। ৱরনা ৱহ তেরে দরমিযান রহতে হুএ তুঝে গুনাহোং মেং ফঁসাতে রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","উনকী ক়ুরবানগাহেং ঢা দেনা, উনকে বুতোং কে সতূন টুকড়ে টুকড়ে কর দেনা ঔর উনকী দেৱী যসীরত কে খংবে কাট ডালনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","কিসী ঔর মাবূদ কী পরস্তিশ ন করনা, ক্যোংকি রব কা নাম গ়যূর হৈ, অল্লাহ গ়ৈরতমংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","খ়বরদার, উস মুল্ক কে বাশিংদোং সে অহদ ন করনা, ক্যোংকি তেরে দরমিযান রহতে হুএ ভী ৱহ অপনে মাবূদোং কী পৈরৱী করকে জ়িনা করেংগে ঔর উন্হেং ক়ুরবানিযাঁ চঢ়াএঁগে। আখ়িরকার ৱহ তুঝে ভী অপনী ক়ুরবানিযোং মেং শিরকত কী দাৱত দেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","খ়তরা হৈ কি তূ উনকী বেটিযোং কা অপনে বেটোং কে সাথ রিশ্তা বাঁধে। ফির জব যহ অপনে মাবূদোং কী পৈরৱী করকে জ়িনা করেংগী তো উনকে সবব সে তেরে বেটে ভী উনকী পৈরৱী করনে লগেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","অপনে লিএ দেৱতা ন ঢালনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","বেখ়মীরী রোটী কী ঈদ মনানা। অবীব কে মহীনে মেং সাত দিন তক তেরী রোটী মেং খ়মীর ন হো জিস তরহ মৈংনে হুক্ম দিযা হৈ। ক্যোংকি ইস মহীনে মেং তূ মিসর সে নিকলা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","হর পহলৌঠা মেরা হৈ। তেরে মাল মৱেশিযোং কা হর পহলৌঠা মেরা হৈ, চাহে বছড়া হো যা লেলা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","লেকিন পহলৌঠে গধে কে এৱজ় ভেড় দেনা। অগর যহ মুমকিন ন হো তো উস কী গরদন তোড় ডালনা। অপনে পহলৌঠে বেটোং কে লিএ ভী এৱজ়ী দেনা। কোঈ মেরে পাস খ়ালী হাথ ন আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ছঃ দিন কাম-কাজ করনা, লেকিন সাতৱেং দিন আরাম করনা। খ়াহ হল চলানা হো যা ফ়সল কাটনী হো তো ভী সাতৱেং দিন আরাম করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","গংদুম কী ফ়সল কী কটাঈ কী ঈদ উস ৱক়্ত মনানা জব তূ গেহূঁ কী পহলী ফ়সল কাটেগা। অংগূর ঔর ফল জমা করনে কী ঈদ ইসরাঈলী সাল কে ইখ়্তিতাম পর মনানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","লাজ়িম হৈ কি তেরে তমাম মর্দ সাল মেং তীন মরতবা রব ক়াদিরে-মুতলক় কে সামনে জো ইসরাঈল কা খ়ুদা হৈ হাজ়ির হোং। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","মৈং তেরে আগে আগে ক়ৌমোং কো মুল্ক সে নিকাল দূঁগা ঔর তেরী সরহদ্দেং বঢ়াতা জাঊঁগা। ফির জব তূ সাল মেং তীন মরতবা রব অপনে খ়ুদা কে হুজ়ূর আএগা তো কোঈ ভী তেরে মুল্ক কা লালচ নহীং করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","জব তূ কিসী জানৱর কো জ়বহ করকে ক়ুরবানী কে তৌর পর পেশ করতা হৈ তো উসকে খ়ূন কে সাথ ঐসী রোটী পেশ ন করনা জিসমেং খ়মীর হো। ঈদে-ফ়সহ কী ক়ুরবানী সে অগলী সুবহ তক কুছ বাক়ী ন রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","অপনী জ়মীন কী পহলী পৈদাৱার মেং সে বেহতরীন হিস্সা রব অপনে খ়ুদা কে ঘর মেং লে আনা। বকরী যা ভেড় কে বচ্চে কো উস কী মাঁ কে দূধ মেং ন পকানা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","রব নে মূসা সে কহা, “যহ তমাম বাতেং লিখ লে, ক্যোংকি যহ উস অহদ কী বুনিযাদ হৈং জো মৈংনে তেরে ঔর ইসরাঈল কে সাথ বাঁধা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","মূসা চালীস দিন ঔর চালীস রাত ৱহীং রব কে হুজ়ূর রহা। ইস দৌরান ন উসনে কুছ খাযা ন পিযা। উসনে পত্থর কী তখ়্তিযোং পর অহদ কে দস অহকাম লিখে। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ইসকে বাদ মূসা শরীঅত কী দোনোং তখ়্তিযোং কো হাথ মেং লিএ হুএ সীনা পহাড় সে উতরা। উসকে চেহরে কী জিল্দ চমক রহী থী, ক্যোংকি উসনে রব সে বাত কী থী। লেকিন উসে খ়ুদ ইসকা ইল্ম নহীং থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","জব হারূন ঔর তমাম ইসরাঈলিযোং নে দেখা কি মূসা কা চেহরা চমক রহা হৈ তো ৱহ উসকে পাস আনে সে ডর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","লেকিন উসনে উন্হেং বুলাযা তো হারূন ঔর জমাত কে তমাম সরদার উসকে পাস আএ, ঔর উসনে উনসে বাত কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","বাদ মেং বাক়ী ইসরাঈলী ভী আএ, ঔর মূসা নে উন্হেং তমাম অহকাম সুনাএ জো রব নে উসে কোহে-সীনা পর দিএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","যহ সব কুছ কহনে কে বাদ মূসা নে অপনে চেহরে পর নিক়াব ডাল লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","জব ভী ৱহ রব সে বাত করনে কে লিএ মুলাক়াত কে খ়ৈমে মেং জাতা তো নিক়াব কো খ়ৈমে সে নিকলতে ৱক়্ত তক উতার লেতা। ঔর জব ৱহ নিকলকর ইসরাঈলিযোং কো রব সে মিলে হুএ অহকাম সুনাতা ");
INSERT INTO urdgvb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","তো ৱহ দেখতে কি উসকে চেহরে কী জিল্দ চমক রহী হৈ। ইসকে বাদ মূসা দুবারা নিক়াব কো অপনে চেহরে পর ডাল লেতা, ঔর ৱহ উস ৱক়্ত তক চেহরে পর রহতা জব তক মূসা রব সে বাত করনে কে লিএ মুলাক়াত কে খ়ৈমে মেং ন জাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","মূসা নে ইসরাঈল কী পূরী জমাত কো ইকট্ঠা করকে কহা, “রব নে তুমকো যহ হুক্ম দিএ হৈং : ");
INSERT INTO urdgvb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ছঃ দিন কাম-কাজ কিযা জাএ, লেকিন সাতৱাঁ দিন মখ়সূসো-মুক়দ্দস হো। ৱহ রব কে লিএ আরাম কা সবত হৈ। জো ভী ইস দিন কাম করে উসে সজ়াএ-মৌত দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","হফ়তে কে দিন অপনে তমাম ঘরোং মেং আগ তক ন জলানা।” ");
INSERT INTO urdgvb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","মূসা নে ইসরাঈল কী পূরী জমাত সে কহা, “রব নে হিদাযত দী হৈ ");
INSERT INTO urdgvb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","কি জো কুছ তুম্হারে পাস হৈ উসমেং সে হদিযে লাকর রব কো উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ করো। জো ভী দিলী খ়ুশী সে দেনা চাহে ৱহ ইন চীজ়োং মেং সে কুছ দে : সোনা, চাঁদী, পীতল; ");
INSERT INTO urdgvb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা, বারীক কতান, বকরী কে বাল, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","মেংঢোং কী সুর্খ় রঁগী হুঈ খালেং, তখ়স কী খালেং, কীকর কী লকড়ী, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","শমাদান কে লিএ জ়ৈতূন কা তেল, মসহ করনে কে লিএ তেল ঔর খ়ুশবূদার বখ়ূর কে লিএ মসালে, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","অক়ীক়ে-অহমর ঔর দীগর জৱাহর জো ইমামে-আজ়ম কে বালাপোশ ঔর সীনে কে কীসে মেং জড়ে জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","তুমমেং সে জিতনে মাহির কারীগর হৈং ৱহ আকর ৱহ কুছ বনাএঁ জো রব নে ফ়রমাযা ");
INSERT INTO urdgvb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","যানী খ়ৈমা ঔর ৱহ গ়িলাফ় জো উসকে ঊপর লগাএ জাএংগে, হুকেং, দীৱারোং কে তখ়্তে, শহতীর, সতূন ঔর পাএ, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","অহদ কা সংদূক়, উসে উঠানে কী লকড়িযাঁ, উসকে কফ়্ফ়ারে কা ঢকনা, মুক়দ্দসতরীন কমরে কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","মখ়সূস রোটিযোং কী মেজ়, উসে উঠানে কী লকড়িযাঁ, উসকা সারা সামান ঔর রোটিযাঁ, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","শমাদান ঔর উস পর রখনে কে চরাগ় উসকে সামান সমেত, শমাদান কে লিএ তেল, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","বখ়ূর জলানে কী ক়ুরবানগাহ, উসে উঠানে কী লকড়িযাঁ, মসহ কা তেল, খ়ুশবূদার বখ়ূর, মুক়দ্দস খ়ৈমে কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ, উসকা পীতল কা জংগলা, উসে উঠানে কী লকড়িযাঁ ঔর বাক়ী সারা সামান, ধোনে কা হৌজ় ঔর ৱহ ঢাঁচা জিস পর হৌজ় রখা জাতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","চারদীৱারী কে পরদে উনকে খংবোং ঔর পাইযোং সমেত, সহন কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","খ়ৈমে ঔর চারদীৱারী কী মেখ়েং ঔর রস্সে, ");
INSERT INTO urdgvb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ঔর ৱহ মুক়দ্দস লিবাস জো হারূন ঔর উসকে বেটে মক়দিস মেং খ়িদমত করনে কে লিএ পহনতে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","যহ সুনকর ইসরাঈল কী পূরী জমাত মূসা কে পাস সে চলী গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ঔর জো জো দিলী খ়ুশী সে দেনা চাহতা থা ৱহ মুলাক়াত কে খ়ৈমে, উসকে সামান যা ইমামোং কে কপড়োং কে লিএ কোঈ হদিযা লেকর ৱাপস আযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","রব কে হদিযে কে লিএ মর্দ ঔর খ়ৱাতীন দিলী খ়ুশী সে অপনে সোনে কে জ়েৱরাত মসলন জড়াঊ পিনেং, বালিযাঁ ঔর ছল্লে লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","জিস জিসকে পাস দরকার চীজ়োং মেং সে কুছ থা ৱহ উসে মূসা কে পাস লে আযা যানী নীলে, ক়িরমিজ়ী ঔর অরগ়ৱানী রংগ কা ধাগা, বারীক কতান, বকরী কে বাল, মেংঢোং কী সুর্খ় রঁগী হুঈ খালেং ঔর তখ়স কী খালেং। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","চাঁদী, পীতল ঔর কীকর কী লকড়ী ভী হদিযে কে তৌর পর লাঈ গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ঔর জিতনী ঔরতেং কাতনে মেং মাহির থীং ৱহ অপনী কাতী হুঈ চীজ়েং লে আঈং যানী নীলে, ক়িরমিজ়ী ঔর অরগ়ৱানী রংগ কা ধাগা ঔর বারীক কতান। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ইসী তরহ জো জো ঔরত বকরী কে বাল কাতনে মেং মাহির থী ঔর দিলী খ়ুশী সে মক়দিস কে লিএ কাম করনা চাহতী থী ৱহ যহ কাতকর লে আঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","সরদার অক়ীক়ে-অহমর ঔর দীগর জৱাহর লে আএ জো ইমামে-আজ়ম কে বালাপোশ ঔর সীনে কে কীসে কে লিএ দরকার থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ৱহ শমাদান, মসহ কে তেল ঔর খ়ুশবূদার বখ়ূর কে লিএ মসালে ঔর জ়ৈতূন কা তেল ভী লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","যোং ইসরাঈল কে তমাম মর্দ ঔর খ়ৱাতীন জো দিলী খ়ুশী সে রব কো কুছ দেনা চাহতে থে উস সারে কাম কে লিএ হদিযে লে আএ জো রব নে মূসা কী মারিফ়ত করনে কো কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ফির মূসা নে ইসরাঈলিযোং সে কহা, “রব নে যহূদাহ কে ক়বীলে কে বজ়লিযেল বিন ঊরী বিন হূর কো চুন লিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","উসনে উসে ইলাহী রূহ সে মামূর করকে হিকমত, সমঝ ঔর তামীর কে হর কাম কে লিএ দরকার ইল্ম দে দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ৱহ নক়্শে বনাকর উনকে মুতাবিক় সোনে, চাঁদী ঔর পীতল কী চীজ়েং বনা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ৱহ জৱাহর কো কাটকর জড়নে কী ক়াবিলিযত রখতা হৈ। ৱহ লকড়ী কো তরাশকর উসসে মুখ়্তলিফ় চীজ়েং বনা সকতা হৈ। ৱহ বহুত সারে ঔর কামোং মেং ভী মহারত রখতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","সাথ হী রব নে উসে ঔর দান কে ক়বীলে কে উহলিযাব বিন অখ়ী-সমক কো দূসরোং কো সিখানে কী ক়াবিলিযত ভী দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","উসনে উন্হেং ৱহ মহারত ঔর হিকমত দী হৈ জো হর কাম কে লিএ দরকার হৈ যানী কারীগরী কে হর কাম কে লিএ, কঢ়াঈ কে কাম কে লিএ, নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে কপড়া বনানে কে লিএ ঔর বুনাঈ কে কাম কে লিএ। ৱহ মাহির কারীগর হৈং ঔর নক়্শে ভী বনা সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","লাজ়িম হৈ কি বজ়লিযেল, উহলিযাব ঔর বাক়ী কারীগর জিনকো রব নে মক়দিস কী তামীর কে লিএ হিকমত ঔর সমঝ দী হৈ সব কুছ ঐন উন হিদাযাত কে মুতাবিক় বনাএঁ জো রব নে দী হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","মূসা নে বজ়লিযেল ঔর উহলিযাব কো বুলাযা। সাথ হী উসনে হর উস কারীগর কো ভী বুলাযা জিসে রব নে মক়দিস কী তামীর কে লিএ হিকমত ঔর মহারত দী থী ঔর জো খ়ুশী সে আনা ঔর যহ কাম করনা চাহতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","উন্হেং মূসা সে তমাম হদিযে মিলে জো ইসরাঈলী মক়দিস কী তামীর কে লিএ লাএ থে। ইসকে বাদ ভী লোগ রোজ় বরোজ় সুবহ কে ৱক়্ত হদিযে লাতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","আখ়িরকার তমাম কারীগর জো মক়দিস বনানে কে কাম মেং লগে থে অপনা কাম ছোড়কর মূসা কে পাস আএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","উন্হোংনে কহা, “লোগ হদ সে জ়্যাদা লা রহে হৈং। জিস কাম কা হুক্ম রব নে দিযা হৈ উসকে লিএ ইতনে সামান কী জ়রূরত নহীং হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","তব মূসা নে পূরী খ়ৈমাগাহ মেং এলান করৱা দিযা কি কোঈ মর্দ যা ঔরত মক়দিস কী তামীর কে লিএ অব কুছ ন লাএ। যোং উন্হেং মজ়ীদ চীজ়েং লানে সে রোকা গযা, ");
INSERT INTO urdgvb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ক্যোংকি কাম কে লিএ সামান জ়রূরত সে জ়্যাদা হো গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","জো কারীগর মহারত রখতে থে উন্হোংনে খ়ৈমে কো বনাযা। উন্হোংনে বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী ধাগে সে দস পরদে বনাএ। পরদোং পর কিসী মাহির কারীগর কে কঢ়াঈ কে কাম সে করূবী ফ়রিশ্তোং কা ডিজ়াযন বনাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","হর পরদে কী লংবাঈ 42 ফ়ুট ঔর চৌড়াঈ 6 ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","পাঁচ পরদোং কে লংবে হাশিযে এক দূসরে কে সাথ জোড়ে গএ ঔর ইসী তরহ বাক়ী পাঁচ ভী। যোং দো বড়ে টুকড়ে বন গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","দোনোং টুকড়োং কো এক দূসরে কে সাথ মিলানে কে লিএ উন্হোংনে নীলে ধাগে কে হলক়ে বনাএ। যহ হলক়ে হর টুকড়ে কে 42 ফ়ুটৱালে এক কিনারে পর লগাএ গএ, ");
INSERT INTO urdgvb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","এক টুকড়ে কে হাশিযে পর 50 হলক়ে ঔর দূসরে পর ভী উতনে হী হলক়ে। ইন দো হাশিযোং কে হলক়ে এক দূসরে কে আমনে-সামনে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ফির বজ়লিযেল নে সোনে কী 50 হুকেং বনাকর উনসে আমনে-সামনে কে হলক়োং কো এক দূসরে কে সাথ মিলাযা। যোং দোনোং টুকড়োং কে জোড়নে সে খ়ৈমা বন গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","উসনে বকরী কে বালোং সে ভী 11 পরদে বনাএ জিন্হেং কপড়েৱালে খ়ৈমে কে ঊপর রখনা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","হর পরদে কী লংবাঈ 45 ফ়ুট ঔর চৌড়াঈ 6 ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","পাঁচ পরদোং কে লংবে হাশিযে এক দূসরে কে সাথ জোড়ে গএ ঔর ইস তরহ বাক়ী ছঃ ভী। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ইন দোনোং টুকড়োং কো মিলানে কে লিএ উসনে হর টুকড়ে কে 45 ফ়ুটৱালে এক কিনারে পর পচাস পচাস হলক়ে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ফির পীতল কী 50 হুকেং বনাকর উসনে দোনোং হিস্সে মিলাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","এক দূসরে কে ঊপর কে দোনোং খ়ৈমোং কী হিফ়াজ়ত কে লিএ বজ়লিযেল নে দো ঔর গ়িলাফ় বনাএ। বকরী কে বালোং কে খ়ৈমে পর রখনে কে লিএ উসনে মেংঢোং কী সুর্খ় রঁগী হুঈ খালেং জোড় দীং ঔর উসকে ঊপর রখনে কে লিএ তখ়স কী খালেং মিলাঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ইসকে বাদ উসনে কীকর কী লকড়ী কে তখ়্তে বনাএ জো খ়ৈমে কী দীৱারোং কা কাম দেতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","হর তখ়্তে কী ঊঁচাঈ 15 ফ়ুট থী ঔর চৌড়াঈ সৱা দো ফ়ুট। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","হর তখ়্তে কে নীচে দো দো চূলেং থীং। ইন চূলোং সে হর তখ়্তে কো উসকে পাইযোং কে সাথ জোড়া জাতা থা তাকি তখ়্তা খড়া রহে। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","খ়ৈমে কী জুনূবী দীৱার কে লিএ 20 তখ়্তে বনাএ গএ ");
INSERT INTO urdgvb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ঔর সাথ হী চাঁদী কে 40 পাএ ভী জিন পর তখ়্তে খড়ে কিএ জাতে থে। হর তখ়্তে কে নীচে দো পাএ থে, ঔর হর পাএ মেং এক চূল লগতী থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ইসী তরহ খ়ৈমে কী শিমালী দীৱার কে লিএ ভী 20 তখ়্তে বনাএ গএ ");
INSERT INTO urdgvb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ঔর সাথ হী চাঁদী কে 40 পাএ জো তখ়্তোং কো খড়া করনে কে লিএ থে। হর তখ়্তে কে নীচে দো পাএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","খ়ৈমে কী পিছলী যানী মগ়রিবী দীৱার কে লিএ ছঃ তখ়্তে বনাএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ইস দীৱার কো শিমালী ঔর জুনূবী দীৱারোং কে সাথ জোড়নে কে লিএ কোনেৱালে দো তখ়্তে বনাএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ইন দো তখ়্তোং মেং নীচে সে লেকর ঊপর তক কোনা থা তাকি এক সে শিমালী দীৱার মগ়রিবী দীৱার কে সাথ জুড় জাএ ঔর দূসরে সে জুনূবী দীৱার মগ়রিবী দীৱার কে সাথ। ইনকে ঊপর কে সিরে কড়োং সে মজ়বূত কিএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","যোং পিছলে যানী মগ়রিবী তখ়্তোং কী পূরী তাদাদ 8 থী ঔর ইনকে লিএ চাঁদী কে পাইযোং কী তাদাদ 16, হর তখ়্তে কে নীচে দো পাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_31‏","003_36_31‏","EXO","36","31‏","32","ফির বজ়লিযেল নে কীকর কী লকড়ী কে শহতীর বনাএ, তীনোং দীৱারোং কে লিএ পাঁচ পাঁচ শহতীর। ৱহ হর দীৱার কে তখ়্তোং পর যোং লগানে কে লিএ থে কি উনসে তখ়্তে এক দূসরে কে সাথ মিলাএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","দরমিযানী শহতীর যোং বনাযা গযা কি ৱহ দীৱার কী আধী ঊঁচাঈ পর দীৱার কে এক সিরে সে দূসরে সিরে তক লগ সকতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","উসনে তমাম তখ়্তোং ঔর শহতীরোং পর সোনা চঢ়াযা। শহতীরোং কো তখ়্তোং কে সাথ লগানে কে লিএ উসনে সোনে কে কড়ে বনাএ জো তখ়্তোং মেং লগানে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","অব বজ়লিযেল নে এক ঔর পরদা বনাযা। উসকে লিএ ভী বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ইস্তেমাল হুআ। উস পর ভী কিসী মাহির কারীগর কে কঢ়াঈ কে কাম সে করূবী ফ়রিশ্তোং কা ডিজ়াযন বনাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ফির উসনে পরদে কো লটকানে কে লিএ কীকর কী লকড়ী কে চার সতূন, সোনে কী হুকেং ঔর চাঁদী কে চার পাএ বনাএ। সতূনোং পর সোনা চঢ়াযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","বজ়লিযেল নে খ়ৈমে কে দরৱাজ়ে কে লিএ ভী পরদা বনাযা। ৱহ ভী বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে সে বনাযা গযা, ঔর উস পর কঢ়াঈ কা কাম কিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ইস পরদে কো লটকানে কে লিএ উসনে সোনে কী হুকেং ঔর কীকর কী লকড়ী কে পাঁচ সতূন বনাএ। সতূনোং কে ঊপর কে সিরোং ঔর পট্টিযোং পর সোনা চঢ়াযা গযা জবকি উনকে পাএ পীতল কে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","বজ়লিযেল নে কীকর কী লকড়ী কা সংদূক় বনাযা। উস কী লংবাঈ পৌনে চার ফ়ুট থী জবকি উস কী চৌড়াঈ ঔর ঊঁচাঈ সৱা দো দো ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","উসনে পূরে সংদূক় পর অংদর ঔর বাহর সে খ়ালিস সোনা চঢ়াযা। ঊপর কী সতহ কে ইর্দগির্দ উসনে সোনে কী ঝালর লগাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","সংদূক় কো উঠানে কে লিএ উসনে সোনে কে চার কড়ে ঢালকর উন্হেং সংদূক় কে চারপাইযোং পর লগাযা। দোনোং তরফ় দো দো কড়ে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ফির উসনে কীকর কী দো লকড়িযাঁ সংদূক় কো উঠানে কে লিএ তৈযার কীং ঔর উন পর সোনা চঢ়াযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","উসনে ইন লকড়িযোং কো দোনোং তরফ় কে কড়োং মেং ডাল দিযা তাকি উনসে সংদূক় কো উঠাযা জা সকে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","বজ়লিযেল নে সংদূক় কা ঢকনা খ়ালিস সোনে কা বনাযা। উস কী লংবাঈ পৌনে চার ফ়ুট ঔর চৌড়াঈ সৱা দো ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_7‏","003_37_7‏","EXO","37","7‏","8","ফির উসনে দো করূবী ফ়রিশ্তে সোনে সে ঘড়কর বনাএ জো ঢকনে কে দোনোং সিরোং পর খড়ে থে। যহ দো ফ়রিশ্তে ঔর ঢকনা এক হী টুকড়ে সে বনাএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ফ়রিশ্তোং কে পর যোং ঊপর কী তরফ় ফৈলে হুএ থে কি ৱহ ঢকনে কো পনাহ দেতে থে। উনকে মুঁহ এক দূসরে কী তরফ় কিএ হুএ থে, ঔর ৱহ ঢকনে কী তরফ় দেখতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ইসকে বাদ বজ়লিযেল নে কীকর কী লকড়ী কী মেজ় বনাঈ। উস কী লংবাঈ তীন ফ়ুট, চৌড়াঈ ডেঢ় ফ়ুট ঔর ঊঁচাঈ সৱা দো ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","উসনে উস পর খ়ালিস সোনা চঢ়াকর উসকে ইর্দগির্দ সোনে কী ঝালর লগাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","মেজ় কী ঊপর কী সতহ পর উসনে চৌখটা ভী লগাযা জিসকী ঊঁচাঈ তীন ইংচ থী ঔর জিস পর সোনে কী ঝালর লগী থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","অব উসনে সোনে কে চার কড়ে ঢালকর উন্হেং চারোং কোনোং পর লগাযা জহাঁ মেজ় কে পাএ লগে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","যহ কড়ে মেজ় কী সতহ পর লগে চৌখটে কে নীচে লগাএ গএ। উনমেং ৱহ লকড়িযাঁ ডালনী থীং জিনসে মেজ় কো উঠানা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","বজ়লিযেল নে যহ লকড়িযাঁ ভী কীকর সে বনাঈং ঔর উন পর সোনা চঢ়াযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","আখ়িরকার উসনে খ়ালিস সোনে কে ৱহ থাল, প্যালে, মৈ কী নজ়রেং পেশ করনে কে বরতন ঔর মরতবান বনাএ জো উস পর রখে জাতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ফির বজ়লিযেল নে খ়ালিস সোনে কা শমাদান বনাযা। উসকা পাযা ঔর ডংডী ঘড়কর বনাএ গএ। উস কী প্যালিযাঁ জো ফূলোং ঔর কলিযোং কী শক্ল কী থীং পাএ ঔর ডংডী কে সাথ এক হী টুকড়া থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ডংডী সে দাঈং ঔর বাঈং তরফ় তীন তীন শাখ়েং নিকলতী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","হর শাখ় পর তীন প্যালিযাঁ লগী থীং জো বাদাম কী কলিযোং ঔর ফূলোং কী শক্ল কী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","শমাদান কী ডংডী পর ভী ইস ক়িস্ম কী প্যালিযাঁ লগী থীং, লেকিন তাদাদ মেং চার। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ইনমেং সে তীন প্যালিযাঁ দাএঁ বাএঁ কী ছঃ শাখ়োং কে নীচে লগী থীং। ৱহ যোং লগী থীং কি হর প্যালী সে দো শাখ়েং নিকলতী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","শাখ়েং ঔর প্যালিযাঁ বল্কি পূরা শমাদান খ়ালিস সোনে কে এক হী টুকড়ে সে ঘড়কর বনাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","বজ়লিযেল নে শমাদান কে লিএ খ়ালিস সোনে কে সাত চরাগ় বনাএ। উসনে বত্তী কতরনে কী ক়ৈংচিযাঁ ঔর জলতে কোযলে কে লিএ ছোটে বরতন ভী খ়ালিস সোনে সে বনাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","শমাদান ঔর উসকে তমাম সামান কে লিএ পূরে 34 কিলোগ্রাম খ়ালিস সোনা ইস্তেমাল হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","বজ়লিযেল নে কীকর কী লকড়ী কী ক়ুরবানগাহ বনাঈ জো বখ়ূর জলানে কে লিএ থী। ৱহ ডেঢ় ফ়ুট লংবী, ইতনী হী চৌড়ী ঔর তীন ফ়ুট ঊঁচী থী। উসকে চার কোনোং মেং সে সীংগ নিকলতে থে জো ক়ুরবানগাহ কে সাথ এক হী টুকড়ে সে বনাএ গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","উস কী ঊপর কী সতহ, উসকে চার পহলুওং ঔর উসকে সীংগোং পর খ়ালিস সোনা চঢ়াযা গযা। ঊপর কী সতহ কে ইর্দগির্দ বজ়লিযেল নে সোনে কী ঝালর বনাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","সোনে কে দো কড়ে বনাকর উসনে উন্হেং ইস ঝালর কে নীচে এক দূসরে কে মুক়াবিল পহলুওং পর লগাযা। ইন কড়োং মেং ক়ুরবানগাহ কো উঠানে কী লকড়িযাঁ ডালী গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","যহ লকড়িযাঁ কীকর কী থীং, ঔর উন পর ভী সোনা চঢ়াযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","বজ়লিযেল নে মসহ করনে কা মুক়দ্দস তেল ঔর খ়ুশবূদার খ়ালিস বখ়ূর ভী বনাযা। যহ ইত্রসাজ় কা কাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","বজ়লিযেল নে কীকর কী লকড়ী কী এক ঔর ক়ুরবানগাহ বনাঈ জো ভস্ম হোনেৱালী ক়ুরবানিযোং কে লিএ থী। উস কী ঊঁচাঈ সাঢ়ে চার ফ়ুট, উস কী লংবাঈ ঔর চৌড়াঈ সাঢ়ে সাত সাত ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","উসকে ঊপর চারোং কোনোং মেং সে সীংগ নিকলতে থে। সীংগ ঔর ক়ুরবানগাহ এক হী টুকড়ে কে থে, ঔর উস পর পীতল চঢ়াযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","উসকা তমাম সাজ়ো-সামান ঔর বরতন ভী পীতল কে থে যানী রাখ কো উঠাকর লে জানে কী বালটিযাঁ, বেলচে, কাঁটে, জলতে হুএ কোযলে কে লিএ বরতন ঔর ছিড়কাৱ কে কটোরে। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ক়ুরবানগাহ কো উঠানে কে লিএ উসনে পীতল কা জংগলা বনাযা। ৱহ ঊপর সে খুলা থা ঔর যোং বনাযা গযা কি জব ক়ুরবানগাহ উসমেং রখী জাএ তো ৱহ উস কিনারে তক পহুঁচে জো ক়ুরবানগাহ কী আধী ঊঁচাঈ পর লগী থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","উসনে ক়ুরবানগাহ কো উঠানে কে লিএ চার কড়ে বনাকর উন্হেং জংগলে কে চার কোনোং পর লগাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ফির উসনে কীকর কী দো লকড়িযাঁ বনাকর উন পর পীতল চঢ়াযা ");
INSERT INTO urdgvb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ঔর ক়ুরবানগাহ কে দোনোং তরফ় লগে ইন কড়োং মেং ডাল দীং। যোং উসে উঠাযা জা সকতা থা। ক়ুরবানগাহ লকড়ী কী থী লেকিন খোখলী থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","বজ়লিযেল নে ধোনে কা হৌজ় ঔর উসকা ঢাঁচা ভী পীতল সে বনাযা। উসকা পীতল উন ঔরতোং কে আঈনোং সে মিলা থা জো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর খ়িদমত করতী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ফির বজ়লিযেল নে সহন বনাযা। উস কী চারদীৱারী বারীক কতান কে কপড়ে সে বনাঈ গঈ। চারদীৱারী কী লংবাঈ জুনূব কী তরফ় 150 ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","কপড়ে কো লগানে কে লিএ চাঁদী কী হুকেং, পট্টিযাঁ, লকড়ী কে খংবে ঔর উনকে পাএ বনাএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","চারদীৱারী শিমাল কী তরফ় ভী ইসী তরহ বনাঈ গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","খ়ৈমে কে পীছে মগ়রিব কী তরফ় চারদীৱারী কী চৌড়াঈ 75 ফ়ুট থী। কপড়ে কে অলাৱা উসকে লিএ 10 খংবে, 10 পাএ ঔর কপড়া লগানে কে লিএ চাঁদী কী হুকেং ঔর পট্টিযাঁ বনাঈ গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","সামনে, মশরিক় কী তরফ় জহাঁ সে সূরজ তুলূ হোতা হৈ চারদীৱারী কী চৌড়াঈ ভী 75 ফ়ুট থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_14‏","003_38_14‏","EXO","38","14‏","15","কপড়া দরৱাজ়ে কে দাঈং তরফ় সাঢ়ে 22 ফ়ুট চৌড়া থা ঔর উসকে বাঈং তরফ় ভী উতনা হী চৌড়া। উসে দোনোং তরফ় তীন তীন খংবোং কে সাথ লগাযা গযা জো পীতল কে পাইযোং পর খড়ে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","চারদীৱারী কে তমাম পরদোং কে লিএ বারীক কতান ইস্তেমাল হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","খংবে পীতল কে পাইযোং পর খড়ে থে, ঔর পরদে চাঁদী কী হুকোং ঔর পট্টিযোং সে খংবোং কে সাথ লগে থে। খংবোং কে ঊপর কে সিরোং পর চাঁদী চঢ়াঈ গঈ থী। সহন কে তমাম খংবোং পর চাঁদী কী পট্টিযাঁ লগী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","চারদীৱারী কে দরৱাজ়ে কা পরদা নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে বনাযা গযা, ঔর উস পর কঢ়াঈ কা কাম কিযা গযা। ৱহ 30 ফ়ুট চৌড়া ঔর চারদীৱারী কে দূসরে পরদোং কী তরহ সাঢ়ে সাত ফ়ুট ঊঁচা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","উসকে চার খংবে ঔর পীতল কে চার পাএ থে। উস কী হুকেং ঔর পট্টিযাঁ চাঁদী কী থীং, ঔর খংবোং কে ঊপর কে সিরোং পর চাঁদী চঢ়াঈ গঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","খ়ৈমে ঔর চারদীৱারী কী তমাম মেখ়েং পীতল কী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","জ়ৈল মেং উস সামান কী ফ়হরিস্ত হৈ জো মক়দিস কী তামীর কে লিএ ইস্তেমাল হুআ। মূসা কে হুক্ম পর ইমামে-আজ়ম হারূন কে বেটে ইতমর নে লাৱিযোং কী মারিফ়ত যহ ফ়হরিস্ত তৈযার কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(যহূদাহ কে ক়বীলে কে বজ়লিযেল বিন ঊরী বিন হূর নে ৱহ সব কুছ বনাযা জো রব নে মূসা কো বতাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","উসকে সাথ দান কে ক়বীলে কা উহলিযাব বিন অখ়ী-সমক থা জো কারীগরী কে হর কাম ঔর কঢ়াঈ কে কাম মেং মাহির থা। ৱহ নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে কপড়া বনানে মেং ভী মাহির থা।) ");
INSERT INTO urdgvb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","উস সোনে কা ৱজ়ন জো লোগোং কে হদিযোং সে জমা হুআ ঔর মক়দিস কী তামীর কে লিএ ইস্তেমাল হুআ তক়রীবন 1,000 কিলোগ্রাম থা (উসে মক়দিস কে বাটোং কে হিসাব সে তোলা গযা)। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","তামীর কে লিএ চাঁদী জো মর্দুমশুমারী কে হিসাব সে ৱসূল হুঈ, উসকা ৱজ়ন তক়রীবন 3,430 কিলোগ্রাম থা (উসে ভী মক়দিস কে বাটোং কে হিসাব সে তোলা গযা)। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","জিন মর্দোং কী উম্র 20 সাল যা ইসসে জ়াযদ থী উন্হেং চাঁদী কা আধা আধা সিক্কা দেনা পড়া। মর্দোং কী কুল তাদাদ 6,03,550 থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","চূঁকি দীৱারোং কে তখ়্তোং কে পাএ ঔর মুক়দ্দসতরীন কমরে কে দরৱাজ়ে কে সতূনোং কে পাএ চাঁদী কে থে ইসলিএ তক়রীবন পূরী চাঁদী ইন 100 পাইযোং কে লিএ সর্ফ় হুঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","তক়রীবন 30 কিলোগ্রাম চাঁদী বচ গঈ। ইসসে চারদীৱারী কে খংবোং কী হুকেং ঔর পট্টিযাঁ বনাঈ গঈং, ঔর যহ খংবোং কে ঊপর কে সিরোং পর ভী চঢ়াঈ গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","জো পীতল হদিযোং সে জমা হুআ উসকা ৱজ়ন তক়রীবন 2,425 কিলোগ্রাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","খ়ৈমে কে দরৱাজ়ে কে পাএ, জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ, উসকা জংগলা, বরতন ঔর সাজ়ো-সামান, ");
INSERT INTO urdgvb_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","চারদীৱারী কে পাএ, সহন কে দরৱাজ়ে কে পাএ ঔর খ়ৈমে ঔর চারদীৱারী কী তমাম মেখ়েং ইসী সে বনাঈ গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","বজ়লিযেল কী হিদাযত পর কারীগরোং নে নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা লেকর মক়দিস মেং খ়িদমত কে লিএ লিবাস বনাএ। উন্হোংনে হারূন কে মুক়দ্দস কপড়ে উন হিদাযাত কে ঐন মুতাবিক় বনাএ জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","উন্হোংনে ইমামে-আজ়ম কা বালাপোশ বনানে কে লিএ সোনা, নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ঔর বারীক কতান ইস্তেমাল কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","উন্হোংনে সোনে কো কূট কূটকর ৱর্ক় বনাযা ঔর ফির উসে কাটকর ধাগে বনাএ। জব নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে কপড়া বনাযা গযা তো সোনে কা যহ ধাগা মহারত সে কঢ়াঈ কে কাম মেং ইস্তেমাল হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","উন্হোংনে বালাপোশ কে লিএ দো পট্টিযাঁ বনাঈং ঔর উন্হেং বালাপোশ কে কংধোং পর রখকর সামনে ঔর পীছে সে বালাপোশ কে সাথ লগাইং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","পটকা ভী বনাযা গযা জিসসে বালাপোশ কো বাঁধা জাতা থা। ইসকে লিএ ভী সোনা, নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কা ধাগা ঔর বারীক কতান ইস্তেমাল হুআ। যহ উন হিদাযাত কে ঐন মুতাবিক় হুআ জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ফির উন্হোংনে অক়ীক়ে-অহমর কে দো পত্থর চুন লিএ ঔর উন্হেং সোনে কে খ়ানোং মেং জড়কর উন পর ইসরাঈল কে বারহ বেটোং কে নাম কংদা কিএ। যহ নাম জৌহরোং পর উস তরহ কংদা কিএ গএ জিস তরহ মুহর কংদা কী জাতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","উন্হোংনে পত্থরোং কো বালাপোশ কী দো পট্টিযোং পর যোং লগাযা কি ৱহ হারূন কে কংধোং পর রব কো ইসরাঈলিযোং কী যাদ দিলাতে রহেং। যহ সব কুছ রব কী দী গঈ হিদাযাত কে ঐন মুতাবিক় হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ইসকে বাদ উন্হোংনে সীনে কা কীসা বনাযা। যহ মাহির কারীগর কা কাম থা ঔর উন্হীং চীজ়োং সে বনা জিনসে হারূন কা বালাপোশ ভী বনা থা যানী সোনে ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে ঔর বারীক কতান সে। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","জব কপড়ে কো এক দফ়া তহ কিযা গযা তো কীসে কী লংবাঈ ঔর চৌড়াঈ নৌ নৌ ইংচ থী। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","উন্হোংনে উস পর চার ক়তারোং মেং জৱাহর জড়ে। হর ক়তার মেং তীন তীন জৌহর থে। পহলী ক়তার মেং লাল, জ়বরজদ ঔর জ়ুমুর্রদ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","দূসরী মেং ফ়ীরোজ়া, সংগে-লাজৱর্দ ঔর হজরুল-ক়মর। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","তীসরী মেং জ়রক়োন, অক়ীক় ঔর যাক়ূতে-অরগ়ৱানী। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","চৌথী মেং পুখরাজ, অক়ীক়ে-অহমর ঔর যশব। হর জৌহর সোনে কে খ়ানে মেং জড়া হুআ থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","যহ বারহ জৱাহর ইসরাঈল কে বারহ ক়বীলোং কী নুমাইংদগী করতে থে। এক এক জৌহর পর এক ক়বীলে কা নাম কংদা কিযা গযা, ঔর যহ নাম উস তরহ কংদা কিএ গএ জিস তরহ মুহর কংদা কী জাতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","অব উন্হোংনে সীনে কে কীসে কে লিএ খ়ালিস সোনে কী দো জ়ংজীরেং বনাঈং জো ডোরী কী তরহ গুংধী হুঈ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","সাথ সাথ উন্হোংনে সোনে কে দো খ়ানে ঔর দো কড়ে ভী বনাএ। উন্হোংনে যহ কড়ে কীসে কে ঊপর কে দো কোনোং পর লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ফির দোনোং জ়ংজীরেং উন দো কড়োং কে সাথ লগাঈ গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","উনকে দূসরে সিরে বালাপোশ কী কংধোংৱালী পট্টিযোং কে দো খ়ানোং কে সাথ জোড় দিএ গএ, ফির সামনে কী তরফ় লগাএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","উন্হোংনে কীসে কে নিচলে দো কোনোং পর ভী সোনে কে দো কড়ে লগাএ। ৱহ অংদর, বালাপোশ কী তরফ় লগে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","অব উন্হোংনে দো ঔর কড়ে বনাকর বালাপোশ কী কংধোংৱালী পট্টিযোং পর লগাএ। যহ ভী সামনে কী তরফ় লগে থে লেকিন নীচে, বালাপোশ কে পটকে কে ঊপর হী। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","উন্হোংনে সীনে কে কীসে কে নিচলে কড়ে নীলী ডোরী সে বালাপোশ কে ইন নিচলে কড়োং কে সাথ বাঁধে। যোং কীসা পটকে কে ঊপর অচ্ছী তরহ সীনে কে সাথ লগা রহা। যহ উন হিদাযাত কে ঐন মুতাবিক় হুআ জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ফির কারীগরোং নে চোগ়া বুনা। ৱহ পূরী তরহ নীলে ধাগে সে বনাযা গযা। চোগ়ে কো বালাপোশ সে পহলে পহননা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","উসকে গরেবান কো বুনে হুএ কালর সে মজ়বূত কিযা গযা তাকি ৱহ ন ফটে। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","উন্হোংনে নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে সে অনার বনাকর উন্হেং চোগ়ে কে দামন মেং লগা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","উনকে দরমিযান খ়ালিস সোনে কী ঘংটিযাঁ লগাঈ গঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","দামন মেং অনার ঔর ঘংটিযাঁ বারী বারী লগাঈ গঈং। লাজ়িম থা কি হারূন খ়িদমত করনে কে লিএ হমেশা যহ চোগ়া পহনে। রব নে মূসা কো যহী হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","কারীগরোং নে হারূন ঔর উসকে বেটোং কে লিএ বারীক কতান কে জ়েরজামে বনাএ। যহ বুননেৱালে কা কাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","সাথ সাথ উন্হোংনে বারীক কতান কী পগড়িযাঁ ঔর বারীক কতান কে পাজামে বনাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","কমরবংদ কো বারীক কতান ঔর নীলে, অরগ়ৱানী ঔর ক়িরমিজ়ী রংগ কে ধাগে সে বনাযা গযা। কঢ়াঈ করনেৱালোং নে ইস পর কাম কিযা। সব কুছ উন হিদাযাত কে মুতাবিক় বনাযা গযা জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","উন্হোংনে মুক়দ্দস তাজ যানী খ়ালিস সোনে কী তখ়্তী বনাঈ ঔর উস পর যহ অলফ়াজ় কংদা কিএ, ‘রব কে লিএ মখ়সূসো-মুক়দ্দস।’ ");
INSERT INTO urdgvb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ফির উন্হোংনে ইসে নীলী ডোরী সে পগড়ী কে সামনেৱালে হিস্সে সে লগা দিযা। যহ ভী উন হিদাযাত কে মুতাবিক় বনাযা গযা জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","আখ়িরকার মক়দিস কা কাম মুকম্মল হুআ। ইসরাঈলিযোং নে সব কুছ উন হিদাযাত কে মুতাবিক় বনাযা থা জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ৱহ মক়দিস কী তমাম চীজ়েং মূসা কে পাস লে আএ যানী মুক়দ্দস খ়ৈমা ঔর উসকা সারা সামান, উস কী হুকেং, দীৱারোং কে তখ়্তে, শহতীর, সতূন ঔর পাএ, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","খ়ৈমে পর মেংঢোং কী সুর্খ় রঁগী হুঈ খালোং কা গ়িলাফ় ঔর তখ়স কী খালোং কা গ়িলাফ়, মুক়দ্দসতরীন কমরে কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","অহদ কা সংদূক় জিসমেং শরীঅত কী তখ়্তিযাঁ রখনী থীং, উসে উঠানে কী লকড়িযাঁ ঔর উসকা ঢকনা, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","মখ়সূস রোটিযোং কী মেজ়, উসকা সারা সামান ঔর রোটিযাঁ, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","খ়ালিস সোনে কা শমাদান ঔর উস পর রখনে কে চরাগ় উসকে সারে সামান সমেত, শমাদান কে লিএ তেল, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","বখ়ূর জলানে কী সোনে কী ক়ুরবানগাহ, মসহ কা তেল, খ়ুশবূদার বখ়ূর, মুক়দ্দস খ়ৈমে কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","জানৱরোং কো চঢ়ানে কী পীতল কী ক়ুরবানগাহ, উসকা পীতল কা জংগলা, উসে উঠানে কী লকড়িযাঁ ঔর বাক়ী সারা সামান, ধোনে কা হৌজ় ঔর ৱহ ঢাঁচা জিস পর হৌজ় রখনা থা, ");
INSERT INTO urdgvb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","চারদীৱারী কে পরদে উনকে খংবোং ঔর পাইযোং সমেত, সহন কে দরৱাজ়ে কা পরদা, চারদীৱারী কে রস্সে ঔর মেখ়েং, মুলাক়াত কে খ়ৈমে মেং খ়িদমত করনে কা বাক়ী সারা সামান ");
INSERT INTO urdgvb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ঔর মক়দিস মেং খ়িদমত করনে কে ৱহ মুক়দ্দস লিবাস জো হারূন ঔর উসকে বেটোং কো পহননে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","সব কুছ উন হিদাযাত কে মুতাবিক় বনাযা গযা থা জো রব নে মূসা কো দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","মূসা নে তমাম চীজ়োং কা মুআযনা কিযা ঔর মালূম কিযা কি উন্হোংনে সব কুছ রব কী হিদাযাত কে মুতাবিক় বনাযা থা। তব উসনে উন্হেং বরকত দী। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ফির রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“পহলে মহীনে কী পহলী তারীখ় কো মুলাক়াত কা খ়ৈমা খড়া করনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","অহদ কা সংদূক় জিসমেং শরীঅত কী তখ়্তিযাঁ হৈং মুক়দ্দসতরীন কমরে মেং রখকর উসকে দরৱাজ়ে কা পরদা লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ইসকে বাদ মখ়সূস রোটিযোং কী মেজ় মুক়দ্দস কমরে মেং লাকর উস পর তমাম জ়রূরী সামান রখনা। উস কমরে মেং শমাদান ভী লে আনা ঔর উস পর উসকে চরাগ় রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","বখ়ূর কী সোনে কী ক়ুরবানগাহ উস পরদে কে সামনে রখনা জিসকে পীছে অহদ কা সংদূক় হৈ। ফির খ়ৈমে মেং দাখ়িল হোনে কে দরৱাজ়ে পর পরদা লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ সহন মেং খ়ৈমে কে দরৱাজ়ে কে সামনে রখী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","খ়ৈমে ঔর ইস ক়ুরবানগাহ কে দরমিযান ধোনে কা হৌজ় রখকর উসমেং পানী ডালনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","সহন কী চারদীৱারী খড়ী করকে উসকে দরৱাজ়ে কা পরদা লগানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","ফির মসহ কা তেল লেকর উসে খ়ৈমে ঔর উসকে সারে সামান পর ছিড়ক দেনা। যোং তূ উসে মেরে লিএ মখ়সূস করেগা ঔর ৱহ মুক়দ্দস হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ফির জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ ঔর উসকে সামান পর মসহ কা তেল ছিড়কনা। যোং তূ উসে মেরে লিএ মখ়সূস করেগা ঔর ৱহ নিহাযত মুক়দ্দস হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ইসী তরহ হৌজ় ঔর উস ঢাঁচে কো ভী মখ়সূস করনা জিস পর হৌজ় রখা গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","হারূন ঔর উসকে বেটোং কো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর লাকর গ়ুস্ল করানা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ফির হারূন কো মুক়দ্দস লিবাস পহনানা ঔর উসে মসহ করকে মেরে লিএ মখ়সূসো-মুক়দ্দস করনা তাকি ইমাম কে তৌর পর মেরী খ়িদমত করে। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","উসকে বেটোং কো লাকর উন্হেং জ়েরজামে পহনা দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","উন্হেং উনকে ৱালিদ কী তরহ মসহ করনা তাকি ৱহ ভী ইমামোং কে তৌর পর মেরী খ়িদমত করেং। জব উন্হেং মসহ কিযা জাএগা তো ৱহ ঔর বাদ মেং উনকী ঔলাদ হমেশা তক মক়দিস মেং ইস খ়িদমত কে লিএ মখ়সূস হোংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","মূসা নে সব কুছ রব কী হিদাযাত কে মুতাবিক় কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","পহলে মহীনে কী পহলী তারীখ় কো মুক়দ্দস খ়ৈমা খড়া কিযা গযা। উন্হেং মিসর সে নিকলে পূরা এক সাল হো গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","মূসা নে দীৱার কে তখ়্তোং কো উনকে পাইযোং পর খড়া করকে উনকে সাথ শহতীর লগাএ। ইসী তরহ উসনে সতূনোং কো ভী খড়া কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","উসনে রব কী হিদাযাত কে ঐন মুতাবিক় দীৱারোং পর কপড়ে কা খ়ৈমা লগাযা ঔর উস পর দূসরে গ়িলাফ় রখে। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","উসনে শরীঅত কী দোনোং তখ়্তিযাঁ লেকর অহদ কে সংদূক় মেং রখ দীং, উঠানে কে লিএ লকড়িযাঁ সংদূক় কে কড়োং মেং ডাল দীং ঔর কফ়্ফ়ারে কা ঢকনা উস পর লগা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ফির উসনে রব কী হিদাযাত কে ঐন মুতাবিক় সংদূক় কো মুক়দ্দসতরীন কমরে মেং রখকর উসকে দরৱাজ়ে কা পরদা লগা দিযা। যোং অহদ কে সংদূক় পর পরদা পড়া রহা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","মূসা নে মখ়সূস রোটিযোং কী মেজ় মুক়দ্দস কমরে কে শিমালী হিস্সে মেং উস পরদে কে সামনে রখ দী জিসকে পীছে অহদ কা সংদূক় থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","উসনে রব কী হিদাযত কে ঐন মুতাবিক় রব কে লিএ মখ়সূস কী হুঈ রোটিযাঁ মেজ় পর রখীং। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","উসী কমরে কে জুনূবী হিস্সে মেং উসনে শমাদান কো মেজ় কে মুক়াবিল রখ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","উস পর উসনে রব কী হিদাযত কে ঐন মুতাবিক় রব কে সামনে চরাগ় রখ দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","উসনে বখ়ূর কী সোনে কী ক়ুরবানগাহ ভী উসী কমরে মেং রখী, উস পরদে কে বিলকুল সামনে জিসকে পীছে অহদ কা সংদূক় থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","উসনে উস পর রব কী হিদাযত কে ঐন মুতাবিক় খ়ুশবূদার বখ়ূর জলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ফির উসনে খ়ৈমে কা দরৱাজ়া লগা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","বাহর জাকর উসনে জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ খ়ৈমে কে দরৱাজ়ে কে সামনে রখ দী। উস পর উসনে রব কী হিদাযত কে ঐন মুতাবিক় ভস্ম হোনেৱালী ক়ুরবানিযাঁ ঔর গ়ল্লা কী নজ়রেং চঢ়াঈং। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","উসনে ধোনে কে হৌজ় কো খ়ৈমে ঔর উস ক়ুরবানগাহ কে দরমিযান রখকর উসমেং পানী ডাল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","মূসা, হারূন ঔর উসকে বেটে উসে অপনে হাথ-পাঁৱ ধোনে কে লিএ ইস্তেমাল করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","জব ভী ৱহ মুলাক়াত কে খ়ৈমে মেং দাখ়িল হোতে যা জানৱরোং কো চঢ়ানে কী ক়ুরবানগাহ কে পাস আতে তো রব কী হিদাযত কে ঐন মুতাবিক় পহলে গ়ুস্ল করতে। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","আখ়ির মেং মূসা নে খ়ৈমা, ক়ুরবানগাহ ঔর চারদীৱারী খড়ী করকে সহন কে দরৱাজ়ে কা পরদা লগা দিযা। যোং মূসা নে মক়দিস কী তামীর মুকম্মল কী। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ফির মুলাক়াত কে খ়ৈমে পর বাদল ছা গযা ঔর মক়দিস রব কে জলাল সে ভর গযা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","মূসা খ়ৈমে মেং দাখ়িল ন হো সকা, ক্যোংকি বাদল উস পর ঠহরা হুআ থা ঔর মক়দিস রব কে জলাল সে ভর গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","তমাম সফ়র কে দৌরান জব ভী মক়দিস কে ঊপর সে বাদল উঠতা তো ইসরাঈলী সফ়র কে লিএ তৈযার হো জাতে। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","অগর ৱহ ন উঠতা তো ৱহ উস ৱক়্ত তক ঠহরে রহতে জব তক বাদল উঠ ন জাতা। ");
INSERT INTO urdgvb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","দিন কে ৱক়্ত বাদল মক়দিস কে ঊপর ঠহরা রহতা ঔর রাত কে ৱক়্ত ৱহ তমাম ইসরাঈলিযোং কো আগ কী সূরত মেং নজ়র আতা থা। যহ সিলসিলা পূরে সফ়র কে দৌরান জারী রহা। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","রব নে মুলাক়াত কে খ়ৈমে মেং সে মূসা কো বুলাকর কহা ");
INSERT INTO urdgvb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","কি ইসরাঈলিযোং কো ইত্তলা দে, “অগর তুমমেং সে কোঈ রব কো ক়ুরবানী পেশ করনা চাহে তো ৱহ অপনে গায-বৈলোং যা ভেড়-বকরিযোং মেং সে জানৱর চুন লে। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","অগর ৱহ অপনে গায-বৈলোং মেং সে ভস্ম হোনেৱালী ক়ুরবানী চঢ়ানা চাহে তো ৱহ বেঐব বৈল চুনকর উসে মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর পেশ করে তাকি রব উসে ক়বূল করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ক়ুরবানী পেশ করনেৱালা অপনা হাথ জানৱর কে সর পর রখে তো যহ ক়ুরবানী মক়বূল হোকর উসকা কফ়্ফ়ারা দেগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ক়ুরবানী পেশ করনেৱালা বৈল কো ৱহাঁ রব কে সামনে জ়বহ করে। ফির হারূন কে বেটে জো ইমাম হৈং উসকা খ়ূন রব কো পেশ করকে উসে দরৱাজ়ে পর কী ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ইসকে বাদ ক়ুরবানী পেশ করনেৱালা খাল উতারকর জানৱর কে টুকড়ে টুকড়ে করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ইমাম ক়ুরবানগাহ পর আগ লগাকর উস পর তরতীব সে লকড়িযাঁ চুনেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","উস পর ৱহ জানৱর কে টুকড়ে সর ঔর চরবী সমেত রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","লাজ়িম হৈ কি ক়ুরবানী পেশ করনেৱালা পহলে জানৱর কী অংতড়িযাঁ ঔর পিংডলিযাঁ ধোএ, ফির ইমাম পূরে জানৱর কো ক়ুরবানগাহ পর জলা দে। ইস জলনেৱালী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","অগর ভস্ম হোনেৱালী ক়ুরবানী ভেড়-বকরিযোং মেং সে চুনী জাএ তো ৱহ বেঐব নর হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","পেশ করনেৱালা উসে রব কে সামনে ক়ুরবানগাহ কী শিমালী সিম্ত মেং জ়বহ করে। ফির হারূন কে বেটে জো ইমাম হৈং উসকা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ইসকে বাদ পেশ করনেৱালা জানৱর কে টুকড়ে টুকড়ে করে ঔর ইমাম যহ টুকড়ে সর ঔর চরবী সমেত ক়ুরবানগাহ কী জলতী হুঈ লকড়িযোং পর তরতীব সে রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","লাজ়িম হৈ কি ক়ুরবানী পেশ করনেৱালা পহলে জানৱর কী অংতড়িযাঁ ঔর পিংডলিযাঁ ধোএ, ফির ইমাম পূরে জানৱর কো রব কো পেশ করকে ক়ুরবানগাহ পর জলা দে। ইস জলনেৱালী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","অগর ভস্ম হোনেৱালী ক়ুরবানী পরিংদা হো তো ৱহ ক়ুম্রী যা জৱান কবূতর হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ইমাম উসে ক়ুরবানগাহ কে পাস লে আএ ঔর উসকা সর মরোড়কর ক়ুরবানগাহ পর জলা দে। ৱহ উসকা খ়ূন যোং নিকলনে দে কি ৱহ ক়ুরবানগাহ কী এক তরফ় সে নীচে টপকে। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ৱহ উসকা পোটা ঔর জো উসমেং হৈ দূর করকে ক়ুরবানগাহ কী মশরিক়ী সিম্ত মেং ফেংক দে, ৱহাঁ জহাঁ রাখ ফেংকী জাতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","উসে পেশ করতে ৱক়্ত ইমাম উসকে পর পকড়কর পরিংদে কো ফাড় ডালে, লেকিন যোং কি ৱহ বিলকুল টুকড়ে টুকড়ে ন হো জাএ। ফির ইমাম উসে ক়ুরবানগাহ পর জলতী হুঈ লকড়িযোং পর জলা দে। ইস জলনেৱালী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","অগর কোঈ রব কো গ়ল্লা কী নজ়র পেশ করনা চাহে তো ৱহ ইসকে লিএ বেহতরীন মৈদা ইস্তেমাল করে। উস পর ৱহ জ়ৈতূন কা তেল উংডেলে ঔর লুবান রখকর ");
INSERT INTO urdgvb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","উসে হারূন কে বেটোং কে পাস লে আএ জো ইমাম হৈং। ইমাম তেল সে মিলাযা গযা মুট্ঠী-ভর মৈদা ঔর তমাম লুবান লেকর ক়ুরবানগাহ পর জলা দে। যহ যাদগার কা হিস্সা হৈ, ঔর উস কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","বাক়ী মৈদা ঔর তেল হারূন ঔর উসকে বেটোং কা হিস্সা হৈ। ৱহ রব কী জলনেৱালী ক়ুরবানিযোং মেং সে এক নিহাযত মুক়দ্দস হিস্সা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","অগর যহ ক়ুরবানী তনূর মেং পকাঈ হুঈ রোটী হো তো উসমেং খ়মীর ন হো। ইসকী দো ক়িস্মেং হো সকতী হৈং, রোটিযাঁ জো বেহতরীন মৈদে ঔর তেল সে বনী হুঈ হোং ঔর রোটিযাঁ জিন পর তেল লগাযা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","অগর যহ ক়ুরবানী তৱে পর পকাঈ হুঈ রোটী হো তো ৱহ বেহতরীন মৈদে ঔর তেল কী হো। উসমেং খ়মীর ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","চূঁকি ৱহ গ়ল্লা কী নজ়র হৈ ইসলিএ রোটী কো টুকড়ে টুকড়ে করনা ঔর উস পর তেল ডালনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","অগর যহ ক়ুরবানী কড়াহী মেং পকাঈ হুঈ রোটী হো তো ৱহ বেহতরীন মৈদে ঔর তেল কী হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","অগর তূ ইন চীজ়োং কী বনী হুঈ গ়ল্লা কী নজ়র রব কে হুজ়ূর লানা চাহে তো উসে ইমাম কো পেশ করনা। ৱহী উসে ক়ুরবানগাহ কে পাস লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ফির ইমাম যাদগার কা হিস্সা অলগ করকে উসে ক়ুরবানগাহ পর জলা দে। ঐসী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ক়ুরবানী কা বাক়ী হিস্সা হারূন ঔর উসকে বেটোং কে লিএ হৈ। ৱহ রব কী জলনেৱালী ক়ুরবানিযোং মেং সে এক নিহাযত মুক়দ্দস হিস্সা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","গ়ল্লা কী জিতনী নজ়রেং তুম রব কো পেশ করতে হো উনমেং খ়মীর ন হো, ক্যোংকি লাজ়িম হৈ কি তুম রব কো জলনেৱালী ক়ুরবানী পেশ করতে ৱক়্ত ন খ়মীর, ন শহদ জলাও। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","যহ চীজ়েং ফ়সল কে পহলে ফলোং কে সাথ রব কো পেশ কী জা সকতী হৈং, লেকিন উন্হেং ক়ুরবানগাহ পর ন জলাযা জাএ, ক্যোংকি ৱহাঁ রব কো উনকী খ়ুশবূ পসংদ নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","গ়ল্লা কী হর নজ়র মেং নমক হো, ক্যোংকি নমক উস অহদ কী নুমাইংদগী করতা হৈ জো তেরে খ়ুদা নে তেরে সাথ বাঁধা হৈ। তুঝে হর ক়ুরবানী মেং নমক ডালনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","অগর তূ গ়ল্লা কী নজ়র কে লিএ ফ়সল কে পহলে ফল পেশ করনা চাহে তো কুচলী হুঈ কচ্চী বালিযাঁ ভূনকর পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","চূঁকি ৱহ গ়ল্লা কী নজ়র হৈ ইসলিএ উস পর তেল উংডেলনা ঔর লুবান রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","কুচলে হুএ দানোং ঔর তেল কা জো হিস্সা রব কা হৈ যানী যাদগার কা হিস্সা উসে ইমাম তমাম লুবান কে সাথ জলা দে। যহ নজ়র রব কে লিএ জলনেৱালী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","অগর কোঈ রব কো সলামতী কী ক়ুরবানী পেশ করনে কে লিএ গায যা বৈল চঢ়ানা চাহে তো ৱহ জানৱর বেঐব হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ৱহ অপনা হাথ জানৱর কে সর পর রখকর উসে মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর জ়বহ করে। হারূন কে বেটে জো ইমাম হৈং উসকা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_3‏","004_3_3‏","LEV","3","3‏","4","পেশ করনেৱালা অংতড়িযোং পর কী সারী চরবী, গুরদে উস চরবী সমেত জো উন পর ঔর কমর কে ক়রীব হোতী হৈ ঔর জোড়কলেজী জলনেৱালী ক়ুরবানী কে তৌর পর রব কো পেশ করে। ইন চীজ়োং কো গুরদোং কে সাথ হী অলগ করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ফির হারূন কে বেটে যহ সব কুছ ভস্ম হোনেৱালী ক়ুরবানী কে সাথ ক়ুরবানগাহ কী লকড়িযোং পর জলা দেং। যহ জলনেৱালী ক়ুরবানী হৈ, ঔর ইসকী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","অগর সলামতী কী ক়ুরবানী কে লিএ ভেড়-বকরিযোং মেং সে জানৱর চুনা জাএ তো ৱহ বেঐব নর যা মাদা হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","অগর ৱহ ভেড় কা বচ্চা চঢ়ানা চাহে তো ৱহ উসে রব কে সামনে লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ৱহ অপনা হাথ উসকে সর পর রখকর উসে মুলাক়াত কে খ়ৈমে কে সামনে জ়বহ করে। হারূন কে বেটে উসকা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_9‏","004_3_9‏","LEV","3","9‏","10","পেশ করনেৱালা চরবী, পূরী দুম, অংতড়িযোং পর কী সারী চরবী, গুরদে উস চরবী সমেত জো উন পর ঔর কমর কে ক়রীব হোতী হৈ ঔর জোড়কলেজী জলনেৱালী ক়ুরবানী কে তৌর পর রব কো পেশ করে। ইন চীজ়োং কো গুরদোং কে সাথ হী অলগ করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ইমাম যহ সব কুছ রব কো পেশ করকে ক়ুরবানগাহ পর জলা দে। যহ খ়ুরাক জলনেৱালী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","অগর সলামতী কী ক়ুরবানী বকরী কী হো ");
INSERT INTO urdgvb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","তো পেশ করনেৱালা উস পর হাথ রখকর উসে মুলাক়াত কে খ়ৈমে কে সামনে জ়বহ করে। হারূন কে বেটে জানৱর কা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_14‏","004_3_14‏","LEV","3","14‏","15","পেশ করনেৱালা অংতড়িযোং পর কী সারী চরবী, গুরদে উস চরবী সমেত জো উন পর ঔর কমর কে ক়রীব হোতী হৈ ঔর জোড়কলেজী জলনেৱালী ক়ুরবানী কে তৌর পর রব কো পেশ করে। ইন চীজ়োং কো গুরদোং কে সাথ হী অলগ করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ইমাম যহ সব কুছ রব কো পেশ করকে ক়ুরবানগাহ পর জলা দে। যহ খ়ুরাক জলনেৱালী ক়ুরবানী হৈ, ঔর ইসকী খ়ুশবূ রব কো পসংদ হৈ। সারী চরবী রব কী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","তুম্হারে লিএ খ়ূন যা চরবী খানা মনা হৈ। যহ ন সির্ফ় তুম্হারে লিএ মনা হৈ বল্কি তুম্হারী ঔলাদ কে লিএ ভী, ন সির্ফ় যহাঁ বল্কি হর জগহ জহাঁ তুম রহতে হো।” ");
INSERT INTO urdgvb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ইসরাঈলিযোং কো বতানা কি জো ভী গ়ৈরইরাদী তৌর পর গুনাহ করকে রব কে কিসী হুক্ম কো তোড়ে ৱহ যহ করে : ");
INSERT INTO urdgvb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","অগর ইমামে-আজ়ম গুনাহ করে ঔর নতীজে মেং পূরী ক়ৌম ক়ুসূরৱার ঠহরে তো ফির ৱহ রব কো এক বেঐব জৱান বৈল লেকর গুনাহ কী ক়ুরবানী কে তৌর পর পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ৱহ জৱান বৈল কো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে কে পাস লে আএ ঔর অপনা হাথ উসকে সর পর রখকর উসে রব কে সামনে জ়বহ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ফির ৱহ জানৱর কে খ়ূন মেং সে কুছ লেকর খ়ৈমে মেং জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ৱহাঁ ৱহ অপনী উঁগলী উসমেং ডালকর উসে সাত বার রব কে সামনে যানী মুক়দ্দসতরীন কমরে কে পরদে পর ছিড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ফির ৱহ খ়ৈমে কে অংদর কী উস ক়ুরবানগাহ কে চারোং সীংগোং পর খ়ূন লগাএ জিস পর বখ়ূর জলাযা জাতা হৈ। বাক়ী খ়ূন ৱহ বাহর খ়ৈমে কে দরৱাজ়ে পর কী উস ক়ুরবানগাহ কে পাএ পর উংডেলে জিস পর জানৱর জলাএ জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","জৱান বৈল কী সারী চরবী, অংতড়িযোং পর কী সারী চরবী, ");
INSERT INTO urdgvb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","গুরদে উস চরবী সমেত জো উন পর ঔর কমর কে ক়রীব হোতী হৈ ঔর জোড়কলেজী কো গুরদোং কে সাথ হী অলগ করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","যহ বিলকুল উসী তরহ কিযা জাএ জিস তরহ উস বৈল কে সাথ কিযা গযা জো সলামতী কী ক়ুরবানী কে লিএ পেশ কিযা জাতা হৈ। ইমাম যহ সব কুছ উস ক়ুরবানগাহ পর জলা দে জিস পর জানৱর জলাএ জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","লেকিন ৱহ উস কী খাল, উসকা সারা গোশ্ত, সর ঔর পিংডলিযাঁ, অংতড়িযাঁ ঔর উনকা গোবর ");
INSERT INTO urdgvb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","খ়ৈমাগাহ কে বাহর লে জাএ। যহ চীজ়েং উস পাক জগহ পর জহাঁ ক়ুরবানিযোং কী রাখ ফেংকী জাতী হৈ লকড়িযোং পর রখকর জলা দেনী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","অগর ইসরাঈল কী পূরী জমাত নে গ়ৈরইরাদী তৌর পর গুনাহ করকে রব কে কিসী হুক্ম সে তজাৱুজ় কিযা হৈ ঔর জমাত কো মালূম নহীং থা তো ভী ৱহ ক়ুসূরৱার হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","জব লোগোং কো পতা লগে কি হমনে গুনাহ কিযা হৈ তো জমাত মুলাক়াত কে খ়ৈমে কে পাস এক জৱান বৈল লে আএ ঔর উসে গুনাহ কী ক়ুরবানী কে তৌর পর পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","জমাত কে বুজ়ুর্গ রব কে সামনে অপনে হাথ উসকে সর পর রখেং, ঔর ৱহ ৱহীং জ়বহ কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ফির ইমামে-আজ়ম জানৱর কে খ়ূন মেং সে কুছ লেকর মুলাক়াত কে খ়ৈমে মেং জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ৱহাঁ ৱহ অপনী উঁগলী উসমেং ডালকর উসে সাত বার রব কে সামনে যানী মুক়দ্দসতরীন কমরে কে পরদে পর ছিড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ফির ৱহ খ়ৈমে কে অংদর কী উস ক়ুরবানগাহ কে চারোং সীংগোং পর খ়ূন লগাএ জিস পর বখ়ূর জলাযা জাতা হৈ। বাক়ী খ়ূন ৱহ বাহর খ়ৈমে কে দরৱাজ়ে কী উস ক়ুরবানগাহ কে পাএ পর উংডেলে জিস পর জানৱর জলাএ জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ইসকে বাদ ৱহ উস কী তমাম চরবী নিকালকর ক়ুরবানগাহ পর জলা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","উস বৈল কে সাথ ৱহ সব কুছ করে জো উসে অপনে জ়াতী গ়ৈরইরাদী গুনাহ কে লিএ করনা হোতা হৈ। যোং ৱহ লোগোং কা কফ়্ফ়ারা দেগা ঔর উন্হেং মুআফ়ী মিল জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","আখ়ির মেং ৱহ বৈল কো খ়ৈমাগাহ কে বাহর লে জাকর উস তরহ জলা দে জিস তরহ উসে অপনে লিএ বৈল কো জলা দেনা হোতা হৈ। যহ জমাত কা গুনাহ দূর করনে কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","অগর কোঈ সরদার গ়ৈরইরাদী তৌর পর গুনাহ করকে রব কে কিসী হুক্ম সে তজাৱুজ় করে ঔর যোং ক়ুসূরৱার ঠহরে তো ");
INSERT INTO urdgvb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","জব ভী উসে পতা লগে কি মুঝসে গুনাহ হুআ হৈ তো ৱহ ক়ুরবানী কে লিএ এক বেঐব বকরা লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ৱহ অপনা হাথ বকরে কে সর পর রখকর উসে ৱহাঁ জ়বহ করে জহাঁ ভস্ম হোনেৱালী ক়ুরবানিযাঁ জ়বহ কী জাতী হৈং। যহ গুনাহ কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ইমাম অপনী উঁগলী খ়ূন মেং ডালকর উসে উস ক়ুরবানগাহ কে চারোং সীংগোং পর লগাএ জিস পর জানৱর জলাএ জাতে হৈং। বাক়ী খ়ূন ৱহ ক়ুরবানগাহ কে পাএ পর উংডেলে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ফির ৱহ উস কী সারী চরবী ক়ুরবানগাহ পর উস তরহ জলা দে জিস তরহ ৱহ সলামতী কী ক়ুরবানিযোং কী চরবী জলা দেতা হৈ। যোং ইমাম উস আদমী কা কফ়্ফ়ারা দেগা ঔর উসে মুআফ়ী হাসিল হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","অগর কোঈ আম শখ়্স গ়ৈরইরাদী তৌর পর গুনাহ করকে রব কে কিসী হুক্ম সে তজাৱুজ় করে ঔর যোং ক়ুসূরৱার ঠহরে তো ");
INSERT INTO urdgvb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","জব ভী উসে পতা লগে কি মুঝসে গুনাহ হুআ হৈ তো ৱহ ক়ুরবানী কে লিএ এক বেঐব বকরী লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ৱহ অপনা হাথ বকরী কে সর পর রখকর উসে ৱহাঁ জ়বহ করে জহাঁ ভস্ম হোনেৱালী ক়ুরবানিযাঁ জ়বহ কী জাতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ইমাম অপনী উঁগলী খ়ূন মেং ডালকর উসে উস ক়ুরবানগাহ কে চারোং সীংগোং পর লগাএ জিস পর জানৱর জলাএ জাতে হৈং। বাক়ী খ়ূন ৱহ ক়ুরবানগাহ কে পাএ পর উংডেলে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ফির ৱহ উস কী সারী চরবী উস তরহ নিকালে জিস তরহ ৱহ সলামতী কী ক়ুরবানিযোং কী চরবী নিকালতা হৈ। ইসকে বাদ ৱহ উসে ক়ুরবানগাহ পর জলা দে। ঐসী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। যোং ইমাম উস আদমী কা কফ়্ফ়ারা দেগা ঔর উসে মুআফ়ী হাসিল হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","অগর ৱহ গুনাহ কী ক়ুরবানী কে লিএ ভেড় কা বচ্চা লানা চাহে তো ৱহ বেঐব মাদা হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ৱহ অপনা হাথ উসকে সর পর রখকর উসে ৱহাঁ জ়বহ করে জহাঁ ভস্ম হোনেৱালী ক়ুরবানিযাঁ জ়বহ কী জাতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ইমাম অপনী উঁগলী খ়ূন মেং ডালকর উসে উস ক়ুরবানগাহ কে চারোং সীংগোং পর লগাএ জিস পর জানৱর জলাএ জাতে হৈং। বাক়ী খ়ূন ৱহ ক়ুরবানগাহ কে পাএ পর উংডেলে। ");
INSERT INTO urdgvb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ফির ৱহ উস কী তমাম চরবী উস তরহ নিকালে জিস তরহ সলামতী কী ক়ুরবানী কে লিএ জ়বহ কিএ গএ জৱান মেংঢে কী চরবী নিকালী জাতী হৈ। ইসকে বাদ ইমাম চরবী কো ক়ুরবানগাহ পর উন ক়ুরবানিযোং সমেত জলা দে জো রব কে লিএ জলাঈ জাতী হৈং। যোং ইমাম উস আদমী কা কফ়্ফ়ারা দেগা ঔর উসে মুআফ়ী মিল জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","হো সকতা হৈ কি কিসী নে যোং গুনাহ কিযা কি উসনে কোঈ জুর্ম দেখা যা ৱহ উসকে বারে মেং কুছ জানতা হৈ। তো ভী জব গৱাহোং কো ক়সম কে লিএ বুলাযা জাতা হৈ তো ৱহ গৱাহী দেনে কে লিএ সামনে নহীং আতা। ইস সূরত মেং ৱহ ক়ুসূরৱার ঠহরতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","হো সকতা হৈ কি কিসী নে গ়ৈরইরাদী তৌর পর কিসী নাপাক চীজ় কো ছূ লিযা হৈ, খ়াহ ৱহ কিসী জংগলী জানৱর, মৱেশী যা রেংগনেৱালে জানৱর কী লাশ ক্যোং ন হো। ইস সূরত মেং ৱহ নাপাক হৈ ঔর ক়ুসূরৱার ঠহরতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","হো সকতা হৈ কি কিসী নে গ়ৈরইরাদী তৌর পর কিসী শখ়্স কী নাপাকী কো ছূ লিযা হৈ যানী উস কী কোঈ ঐসী চীজ় জিসসে ৱহ নাপাক হো গযা হৈ। জব উসে মালূম হো জাতা হৈ তো ৱহ ক়ুসূরৱার ঠহরতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","হো সকতা হৈ কি কিসী নে বেপরৱাঈ সে কুছ করনে কী ক়সম খাঈ হৈ, চাহে ৱহ অচ্ছা কাম থা যা গ়লত। জব ৱহ জান লেতা হৈ কি উসনে ক্যা কিযা হৈ তো ৱহ ক়ুসূরৱার ঠহরতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","জো ইস তরহ কে কিসী গুনাহ কী বিনা পর ক়ুসূরৱার হো, লাজ়িম হৈ কি ৱহ অপনা গুনাহ তসলীম করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ফির ৱহ গুনাহ কী ক়ুরবানী কে তৌর পর এক ভেড় যা বকরী পেশ করে। যোং ইমাম উসকা কফ়্ফ়ারা দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","অগর ক়ুসূরৱার শখ়্স গ়ুরবত কে বাইস ভেড় যা বকরী ন দে সকে তো ৱহ রব কো দো ক়ুম্রিযাঁ যা দো জৱান কবূতর পেশ করে, এক গুনাহ কী ক়ুরবানী কে লিএ ঔর এক ভস্ম হোনেৱালী ক়ুরবানী কে লিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ৱহ উন্হেং ইমাম কে পাস লে আএ। ইমাম পহলে গুনাহ কী ক়ুরবানী কে লিএ পরিংদা পেশ করে। ৱহ উস কী গরদন মরোড় ডালে লেকিন ঐসে কি সর জুদা ন হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ফির ৱহ উসকে খ়ূন মেং সে কুছ ক়ুরবানগাহ কে এক পহলূ পর ছিড়কে। বাক়ী খ়ূন ৱহ যোং নিকলনে দে কি ৱহ ক়ুরবানগাহ কে পাএ পর টপকে। যহ গুনাহ কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ফির ইমাম দূসরে পরিংদে কো ক়ৱাযদ কে মুতাবিক় ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর পেশ করে। যোং ইমাম উস আদমী কা কফ়্ফ়ারা দেগা ঔর উসে মুআফ়ী মিল জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","অগর ৱহ শখ়্স গ়ুরবত কে বাইস দো ক়ুম্রিযাঁ যা দো জৱান কবূতর ভী ন দে সকে তো ফির ৱহ গুনাহ কী ক়ুরবানী কে লিএ ডেঢ় কিলোগ্রাম বেহতরীন মৈদা পেশ করে। ৱহ উস পর ন তেল উংডেলে, ন লুবান রখে, ক্যোংকি যহ গ়ল্লা কী নজ়র নহীং বল্কি গুনাহ কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ৱহ উসে ইমাম কে পাস লে আএ জো যাদগার কা হিস্সা যানী মুট্ঠী-ভর উন ক়ুরবানিযোং কে সাথ জলা দে জো রব কে লিএ জলাঈ জাতী হৈং। যহ গুনাহ কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","যোং ইমাম উস আদমী কা কফ়্ফ়ারা দেগা ঔর উসে মুআফ়ী মিল জাএগী। গ়ল্লা কী নজ়র কী তরহ বাক়ী মৈদা ইমাম কা হিস্সা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“অগর কিসী নে বেঈমানী করকে গ়ৈরইরাদী তৌর পর রব কী মখ়সূস ঔর মুক়দ্দস চীজ়োং কে সিলসিলে মেং গুনাহ কিযা হো, ঐসা শখ়্স ক়ুসূর কী ক়ুরবানী কে তৌর পর রব কো বেঐব ঔর ক়ীমত কে লিহাজ় সে মুনাসিব মেংঢা যা বকরা পেশ করে। উস কী ক়ীমত মক়দিস কী শরহ কে মুতাবিক় মুক়র্রর কী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","জিতনা নুক়সান মক়দিস কো হুআ হৈ উতনা হী ৱহ দে। ইসকে অলাৱা ৱহ মজ়ীদ 20 ফ়ীসদ অদা করে। ৱহ উসে ইমাম কো দে দে ঔর ইমাম জানৱর কো ক়ুসূর কী ক়ুরবানী কে তৌর পর পেশ করকে উসকা কফ়্ফ়ারা দে। যোং উসে মুআফ়ী মিল জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","অগর কোঈ গ়ৈরইরাদী তৌর পর গুনাহ করকে রব কে কিসী হুক্ম সে তজাৱুজ় করে তো ৱহ ক়ুসূরৱার হৈ, ঔর ৱহ উসকা জ়িম্মাদার ঠহরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ৱহ ক়ুসূর কী ক়ুরবানী কে তৌর পর ইমাম কে পাস এক বেঐব ঔর ক়ীমত কে লিহাজ় সে মুনাসিব মেংঢা লে আএ। উস কী ক়ীমত মক়দিস কী শরহ কে মুতাবিক় মুক়র্রর কী জাএ। ফির ইমাম যহ ক়ুরবানী উস গুনাহ কে লিএ চঢ়াএ জো ক়ুসূরৱার শখ়্স নে গ়ৈরইরাদী তৌর পর কিযা হৈ। যোং উসে মুআফ়ী মিল জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","যহ ক়ুসূর কী ক়ুরবানী হৈ, ক্যোংকি ৱহ রব কা গুনাহ করকে ক়ুসূরৱার ঠহরা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“হো সকতা হৈ কিসী নে গুনাহ করকে বেঈমানী কী হৈ, মসলন উসনে অপনে পড়োসী কী কোঈ চীজ় ৱাপস নহীং কী জো উসকে সুপুর্দ কী গঈ থী যা জো উসে গিরৱী কে তৌর পর মিলী থী, যা উসনে উস কী কোঈ চীজ় চোরী কী, যা উসনে কিসী সে কোঈ চীজ় ছীন লী, ");
INSERT INTO urdgvb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","যা উসনে কিসী কী গুমশুদা চীজ় কে বারে মেং ঝূট বোলা জব উসে মিল গঈ, যা উসনে ক়সম খাকর ঝূট বোলা হৈ, যা ইস তরহ কা কোঈ ঔর গুনাহ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","অগর ৱহ ইস তরহ কা গুনাহ করকে ক়ুসূরৱার ঠহরে তো লাজ়িম হৈ কি ৱহ ৱহী চীজ় ৱাপস করে জো উসনে চোরী কী যা ছীন লী যা জো উসকে সুপুর্দ কী গঈ যা জো গুমশুদা হোকর উসকে পাস আ গঈ হৈ ");
INSERT INTO urdgvb_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","যা জিসকে বারে মেং উসনে ক়সম খাকর ঝূট বোলা হৈ। ৱহ উসকা উতনা হী ৱাপস করকে 20 ফ়ীসদ জ়্যাদা দে। ঔর ৱহ যহ সব কুছ উস দিন ৱাপস করে জব ৱহ অপনী ক়ুসূর কী ক়ুরবানী পেশ করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ক়ুসূর কী ক়ুরবানী কে তৌর পর ৱহ এক বেঐব ঔর ক়ীমত কে লিহাজ় সে মুনাসিব মেংঢা ইমাম কে পাস লে আএ ঔর রব কো পেশ করে। উস কী ক়ীমত মক়দিস কী শরহ কে মুতাবিক় মুক়র্রর কী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ফির ইমাম রব কে সামনে উসকা কফ়্ফ়ারা দেগা তো উসে মুআফ়ী মিল জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“হারূন ঔর উসকে বেটোং কো ভস্ম হোনেৱালী ক়ুরবানিযোং কে বারে মেং জ়ৈল কী হিদাযাত দেনা : ভস্ম হোনেৱালী ক়ুরবানী পূরী রাত সুবহ তক ক়ুরবানগাহ কী উস জগহ পর রহে জহাঁ আগ জলতী হৈ। আগ কো বুঝনে ন দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","সুবহ কো ইমাম কতান কা লিবাস ঔর কতান কা পাজামা পহনকর ক়ুরবানী সে বচী হুঈ রাখ ক়ুরবানগাহ কে পাস জ়মীন পর ডালে। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ফির ৱহ অপনে কপড়ে বদলকর রাখ কো খ়ৈমাগাহ কে বাহর কিসী পাক জগহ পর ছোড় আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ক়ুরবানগাহ পর আগ জলতী রহে। ৱহ কভী ভী ন বুঝে। হর সুবহ ইমাম লকড়িযাঁ চুনকর উস পর ভস্ম হোনেৱালী ক়ুরবানী তরতীব সে রখে ঔর উস পর সলামতী কী ক়ুরবানী কী চরবী জলা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","আগ হমেশা জলতী রহে। ৱহ কভী ন বুঝনে পাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","গ়ল্লা কী নজ়র কে বারে মেং হিদাযাত যহ হৈং : হারূন কে বেটে উসে ক়ুরবানগাহ কে সামনে রব কো পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ফির ইমাম যাদগার কা হিস্সা যানী তেল সে মিলাযা গযা মুট্ঠী-ভর বেহতরীন মৈদা ঔর ক়ুরবানী কা তমাম লুবান লেকর ক়ুরবানগাহ পর জলা দে। ইসকী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","হারূন ঔর উসকে বেটে ক়ুরবানী কা বাক়ী হিস্সা খা লেং। লেকিন ৱহ উসে মুক়দ্দস জগহ পর যানী মুলাক়াত কে খ়ৈমে কী চারদীৱারী কে অংদর খাএঁ, ঔর উসমেং খ়মীর ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","উসে পকানে কে লিএ উসমেং খ়মীর ন ডালা জাএ। মৈংনে জলনেৱালী ক়ুরবানিযোং মেং সে যহ হিস্সা উনকে লিএ মুক়র্রর কিযা হৈ। যহ গুনাহ কী ক়ুরবানী ঔর ক়ুসূর কী ক়ুরবানী কী তরহ নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","হারূন কী ঔলাদ কে তমাম মর্দ উসে খাএঁ। যহ উসূল অবদ তক ক়াযম রহে। জো ভী উসে ছুএগা ৱহ মখ়সূসো-মুক়দ্দস হো জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“জব হারূন ঔর উসকে বেটোং কো ইমাম কী জ়িম্মাদারী উঠানে কে লিএ মখ়সূস করকে তেল সে মসহ কিযা জাএগা তো ৱহ ডেঢ় কিলোগ্রাম বেহতরীন মৈদা পেশ করেং। উসকা আধা হিস্সা সুবহ কো ঔর আধা হিস্সা শাম কে ৱক়্ত পেশ কিযা জাএ। ৱহ গ়ল্লা কী যহ নজ়র রোজ়ানা পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","উসে তেল কে সাথ মিলাকর তৱে পর পকানা হৈ। ফির উসে টুকড়ে টুকড়ে করকে গ়ল্লা কী নজ়র কে তৌর পর পেশ করনা। উস কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","যহ ক়ুরবানী হমেশা হারূন কী নসল কা ৱহ আদমী পেশ করে জিসে মসহ করকে ইমামে-আজ়ম কা ওহদা দিযা গযা হৈ, ঔর ৱহ উসে পূরে তৌর পর রব কে লিএ জলা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ইমাম কী গ়ল্লা কী নজ়র হমেশা পূরে তৌর পর জলানা। উসে ন খানা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“হারূন ঔর উসকে বেটোং কো গুনাহ কী ক়ুরবানী কে বারে মেং জ়ৈল কী হিদাযাত দেনা : গুনাহ কী ক়ুরবানী কো রব কে সামনে ৱহীং জ়বহ করনা হৈ জহাঁ ভস্ম হোনেৱালী ক়ুরবানী জ়বহ কী জাতী হৈ। ৱহ নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","উসে পেশ করনেৱালা ইমাম উসে মুক়দ্দস জগহ পর যানী মুলাক়াত কে খ়ৈমে কী চারদীৱারী কে অংদর খাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","জো ভী ইস ক়ুরবানী কে গোশ্ত কো ছূ লেতা হৈ ৱহ মখ়সূসো-মুক়দ্দস হো জাতা হৈ। অগর ক়ুরবানী কে খ়ূন কে ছীংটে কিসী লিবাস পর পড় জাএঁ তো উসে মুক়দ্দস জগহ পর ধোনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","অগর গোশ্ত কো হংডিযা মেং পকাযা গযা হো তো উস বরতন কো বাদ মেং তোড় দেনা হৈ। অগর উসকে লিএ পীতল কা বরতন ইস্তেমাল কিযা গযা হো তো উসে খ়ূব মাঁঝকর পানী সে সাফ় করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ইমামোং কে খ়ানদানোং মেং সে তমাম মর্দ উসে খা সকতে হৈং। যহ খানা নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","লেকিন গুনাহ কী হর ৱহ ক়ুরবানী খাঈ ন জাএ জিসকা খ়ূন মুলাক়াত কে খ়ৈমে মেং ইসলিএ লাযা গযা হৈ কি মক়দিস মেং কিসী কা কফ়্ফ়ারা দিযা জাএ। উসে জলানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ক়ুসূর কী ক়ুরবানী জো নিহাযত মুক়দ্দস হৈ উসকে বারে মেং হিদাযাত যহ হৈং : ");
INSERT INTO urdgvb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ক়ুসূর কী ক়ুরবানী ৱহীং জ়বহ করনী হৈ জহাঁ ভস্ম হোনেৱালী ক়ুরবানী জ়বহ কী জাতী হৈ। উসকা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়কা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","উস কী তমাম চরবী নিকালকর ক়ুরবানগাহ পর চঢ়ানী হৈ যানী উস কী দুম, অংতড়িযোং পর কী চরবী, ");
INSERT INTO urdgvb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","গুরদে উস চরবী সমেত জো উন পর ঔর কমর কে ক়রীব হোতী হৈ ঔর জোড়কলেজী। ইন চীজ়োং কো গুরদোং কে সাথ হী অলগ করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ইমাম যহ সব কুছ রব কো ক়ুরবানগাহ পর জলনেৱালী ক়ুরবানী কে তৌর পর পেশ করে। যহ ক়ুসূর কী ক়ুরবানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ইমামোং কে খ়ানদানোং মেং সে তমাম মর্দ উসে খা সকতে হৈং। লেকিন উসে মুক়দ্দস জগহ পর খাযা জাএ। যহ নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","গুনাহ ঔর ক়ুসূর কী ক়ুরবানী কে লিএ এক হী উসূল হৈ, জো ইমাম ক়ুরবানী কো পেশ করকে কফ়্ফ়ারা দেতা হৈ উসকো উসকা গোশ্ত মিলতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ইস তরহ জো ইমাম কিসী জানৱর কো ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর চঢ়াতা হৈ উসী কো জানৱর কী খাল মিলতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ঔর ইসী তরহ তনূর মেং, কড়াহী মেং যা তৱে পর পকাঈ গঈ গ়ল্লা কী হর নজ়র উস ইমাম কো মিলতী হৈ জিসনে উসে পেশ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","লেকিন হারূন কে তমাম বেটোং কো গ়ল্লা কী বাক়ী নজ়রেং বরাবর বরাবর মিলতী রহেং, খ়াহ উনমেং তেল মিলাযা গযা হো যা ৱহ খ়ুশ্ক হোং। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","সলামতী কী ক়ুরবানী জো রব কো পেশ কী জাতী হৈ উসকে বারে মেং জ়ৈল কী হিদাযাত হৈং : ");
INSERT INTO urdgvb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","অগর কোঈ ইস ক়ুরবানী সে অপনী শুক্রগুজ়ারী কা ইজ়হার করনা চাহে তো ৱহ জানৱর কে সাথ বেখ়মীরী রোটী জিসমেং তেল ডালা গযা হো, বেখ়মীরী রোটী জিস পর তেল লগাযা গযা হো ঔর রোটী জিসমেং বেহতরীন মৈদা ঔর তেল মিলাযা গযা হো পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ইসকে অলাৱা ৱহ খ়মীরী রোটী ভী পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","পেশ করনেৱালা ক়ুরবানী কী হর চীজ় কা এক হিস্সা উঠাকর রব কে লিএ মখ়সূস করে। যহ উস ইমাম কা হিস্সা হৈ জো জানৱর কা খ়ূন ক়ুরবানগাহ পর ছিড়কতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","গোশ্ত উসী দিন খাযা জাএ জব জানৱর কো জ়বহ কিযা গযা হো। অগলী সুবহ তক কুছ নহীং বচনা চাহিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ইস ক়ুরবানী কা গোশ্ত সির্ফ় ইস সূরত মেং অগলে দিন খাযা জা সকতা হৈ জব কিসী নে মন্নত মানকর যা অপনী খ়ুশী সে উসে পেশ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","অগর কুছ গোশ্ত তীসরে দিন তক বচ জাএ তো উসে জলানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","অগর উসে তীসরে দিন ভী খাযা জাএ তো রব যহ ক়ুরবানী ক়বূল নহীং করেগা। উসকা কোঈ ফ়াযদা নহীং হোগা বল্কি উসে নাপাক ক়রার দিযা জাএগা। জো ভী উসসে খাএগা ৱহ ক়ুসূরৱার ঠহরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","অগর যহ গোশ্ত কিসী নাপাক চীজ় সে লগ জাএ তো উসে নহীং খানা হৈ বল্কি উসে জলাযা জাএ। অগর গোশ্ত পাক হৈ তো হর শখ়্স জো খ়ুদ পাক হৈ উসে খা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","লেকিন অগর নাপাক শখ়্স রব কো পেশ কী গঈ সলামতী কী ক়ুরবানী কা যহ গোশ্ত খাএ তো উসে উস কী ক়ৌম মেং সে মিটা ডালনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","হো সকতা হৈ কি কিসী নে কিসী নাপাক চীজ় কো ছূ লিযা হৈ চাহে ৱহ নাপাক শখ়্স, জানৱর যা কোঈ ঔর ঘিনৌনী ঔর নাপাক চীজ় হো। অগর ঐসা শখ়্স রব কো পেশ কী গঈ সলামতী কী ক়ুরবানী কা গোশ্ত খাএ তো উসে উস কী ক়ৌম মেং সে মিটা ডালনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ইসরাঈলিযোং কো বতা দেনা কি গায-বৈল ঔর ভেড়-বকরিযোং কী চরবী খানা তুম্হারে লিএ মনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","তুম ফ়িতরী তৌর পর মরে হুএ জানৱরোং ঔর ফাড়ে হুএ জানৱরোং কী চরবী দীগর কামোং কে লিএ ইস্তেমাল কর সকতে হো, লেকিন উসে খানা মনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","জো ভী উস চরবী মেং সে খাএ জো জলাকর রব কো পেশ কী জাতী হৈ উসে উস কী ক়ৌম মেং সে মিটা ডালনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","জহাঁ ভী তুম রহতে হো ৱহাঁ পরিংদোং যা দীগর জানৱরোং কা খ়ূন খানা মনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","জো ভী খ়ূন খাএ উসে উস কী ক়ৌম মেং সে মিটাযা জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ইসরাঈলিযোং কো বতানা কি জো রব কো সলামতী কী ক়ুরবানী পেশ করে ৱহ রব কে লিএ এক হিস্সা মখ়সূস করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ৱহ জলনেৱালী যহ ক়ুরবানী অপনে হাথোং সে রব কো পেশ করে। ইসকে লিএ ৱহ জানৱর কী চরবী ঔর সীনা রব কে সামনে পেশ করে। সীনা হিলানেৱালী ক়ুরবানী হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ইমাম চরবী কো ক়ুরবানগাহ পর জলা দে জবকি সীনা হারূন ঔর উসকে বেটোং কা হিস্সা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ক়ুরবানী কী দহনী রান ইমাম কো উঠানেৱালী ক়ুরবানী কে তৌর পর দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ৱহ উস ইমাম কা হিস্সা হৈ জো সলামতী কী ক়ুরবানী কা খ়ূন ঔর চরবী চঢ়াতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ইসরাঈলিযোং কী সলামতী কী ক়ুরবানিযোং মেং সে মৈংনে হিলানেৱালা সীনা ঔর উঠানেৱালী রান ইমামোং কো দী হৈ। যহ চীজ়েং হমেশা কে লিএ ইসরাঈলিযোং কী তরফ় সে ইমামোং কা হক় হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","যহ উস দিন জলনেৱালী ক়ুরবানিযোং মেং সে হারূন ঔর উসকে বেটোং কা হিস্সা বন গঈং জব উন্হেং মক়দিস মেং রব কী খ়িদমত মেং পেশ কিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","রব নে উস দিন জব উন্হেং তেল সে মসহ কিযা গযা হুক্ম দিযা থা কি ইসরাঈলী যহ হিস্সা হমেশা ইমামোং কো দিযা করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","গ়রজ় যহ হিদাযাত তমাম ক়ুরবানিযোং কে বারে মেং হৈং যানী ভস্ম হোনেৱালী ক়ুরবানী, গ়ল্লা কী নজ়র, গুনাহ কী ক়ুরবানী, ক়ুসূর কী ক়ুরবানী, ইমাম কো মক়দিস মেং খ়িদমত কে লিএ মখ়সূস করনে কী ক়ুরবানী ঔর সলামতী কী ক়ুরবানী কে বারে মেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","রব নে মূসা কো যহ হিদাযাত সীনা পহাড় পর দীং, উস দিন জব উসনে ইসরাঈলিযোং কো হুক্ম দিযা কি ৱহ দশ্তে-সীনা মেং রব কো অপনী ক়ুরবানিযাঁ পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“হারূন ঔর উসকে বেটোং কো মেরে হুজ়ূর লে আনা। নীজ় ইমামোং কে লিবাস, মসহ কা তেল, গুনাহ কী ক়ুরবানী কে লিএ জৱান বৈল, দো মেংঢে ঔর বেখ়মীরী রোটিযোং কী টোকরী লে আনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ফির পূরী জমাত কো খ়ৈমে কে দরৱাজ়ে পর জমা করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","মূসা নে ঐসা হী কিযা। জব পূরী জমাত ইকট্ঠী হো গঈ তো ");
INSERT INTO urdgvb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","উসনে উনসে কহা, “অব মৈং ৱহ কুছ করতা হূঁ জিসকা হুক্ম রব নে দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","মূসা নে হারূন ঔর উসকে বেটোং কো সামনে লাকর গ়ুস্ল করাযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","উসনে হারূন কো কতান কা জ়েরজামা পহনাকর কমরবংদ লপেটা। ফির উসনে চোগ়া পহনাযা জিস পর উসনে বালাপোশ কো মহারত সে বুনে হুএ পটকে সে বাঁধা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ইসকে বাদ উসনে সীনে কা কীসা লগাকর উসমেং দোনোং ক়ুরে বনাম ঊরীম ঔর তুম্মীম রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ফির উসনে হারূন কে সর পর পগড়ী রখী জিসকে সামনেৱালে হিস্সে পর উসনে মুক়দ্দস তাজ যানী সোনে কী তখ়্তী লগা দী। সব কুছ উস হুক্ম কে ঐন মুতাবিক় হুআ জো রব নে মূসা কো দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ইসকে বাদ মূসা নে মসহ কে তেল সে মক়দিস কো ঔর জো কুছ উসমেং থা মসহ করকে উসে মখ়সূসো-মুক়দ্দস কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","উসনে যহ তেল সাত বার জানৱর চঢ়ানে কী ক়ুরবানগাহ ঔর উসকে সামান পর ছিড়ক দিযা। ইসী তরহ উসনে সাত বার ধোনে কে হৌজ় ঔর উস ঢাঁচে পর তেল ছিড়ক দিযা জিস পর হৌজ় রখা হুআ থা। যোং যহ চীজ়েং মখ়সূসো-মুক়দ্দস হুঈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","উসনে হারূন কে সর পর মসহ কা তেল উংডেলকর উসে মসহ কিযা। যোং ৱহ মখ়সূসো-মুক়দ্দস হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ফির মূসা নে হারূন কে বেটোং কো সামনে লাকর উন্হেং জ়েরজামে পহনাএ, কমরবংদ লপেটে ঔর উনকে সরোং পর পগড়িযাঁ বাঁধীং। সব কুছ উস হুক্ম কে ঐন মুতাবিক় হুআ জো রব নে মূসা কো দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","অব মূসা নে গুনাহ কী ক়ুরবানী কে লিএ জৱান বৈল কো পেশ কিযা। হারূন ঔর উসকে বেটোং নে অপনে হাথ উসকে সর পর রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","মূসা নে উসে জ়বহ করকে উসকে খ়ূন মেং সে কুছ লেকর অপনী উঁগলী সে ক়ুরবানগাহ কে সীংগোং পর লগা দিযা তাকি ৱহ গুনাহোং সে পাক হো জাএ। বাক়ী খ়ূন উসনে ক়ুরবানগাহ কে পাএ পর উংডেল দিযা। যোং উসনে উসে মখ়সূসো-মুক়দ্দস করকে উসকা কফ়্ফ়ারা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","মূসা নে অংতড়িযোং পর কী তমাম চরবী, জোড়কলেজী ঔর দোনোং গুরদে উনকী চরবী সমেত লেকর ক়ুরবানগাহ পর জলা দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","লেকিন বৈল কী খাল, গোশ্ত ঔর অংতড়িযোং কে গোবর কো উসনে খ়ৈমাগাহ কে বাহর লে জাকর জলা দিযা। সব কুছ উস হুক্ম কে মুতাবিক় হুআ জো রব নে মূসা কো দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ইসকে বাদ উসনে ভস্ম হোনেৱালী ক়ুরবানী কে লিএ পহলা মেংঢা পেশ কিযা। হারূন ঔর উসকে বেটোং নে অপনে হাথ উসকে সর পর রখ দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","মূসা নে উসে জ়বহ করকে উসকা খ়ূন ক়ুরবানগাহ কে চার পহলুওং পর ছিড়ক দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","উসনে মেংঢে কো টুকড়ে টুকড়ে করকে সর, টুকড়ে ঔর চরবী জলা দী। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","উসনে অংতড়িযাঁ ঔর পিংডলিযাঁ পানী সে সাফ় করকে পূরে মেংঢে কো ক়ুরবানগাহ পর জলা দিযা। সব কুছ উস হুক্ম কে ঐন মুতাবিক় হুআ জো রব নে মূসা কো দিযা থা। রব কে লিএ জলনেৱালী যহ ক়ুরবানী ভস্ম হোনেৱালী ক়ুরবানী থী, ঔর উস কী খ়ুশবূ রব কো পসংদ থী। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ইসকে বাদ মূসা নে দূসরে মেংঢে কো পেশ কিযা। ইস ক়ুরবানী কা মক়সদ ইমামোং কো মক়দিস মেং খ়িদমত কে লিএ মখ়সূস করনা থা। হারূন ঔর উসকে বেটোং নে অপনে হাথ মেংঢে কে সর পর রখ দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","মূসা নে উসে জ়বহ করকে উসকে খ়ূন মেং সে কুছ লেকর হারূন কে দহনে কান কী লৌ পর ঔর উসকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর লগাযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","যহী উসনে হারূন কে বেটোং কে সাথ ভী কিযা। উসনে উন্হেং সামনে লাকর উনকে দহনে কান কী লৌ পর ঔর উনকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর খ়ূন লগাযা। বাক়ী খ়ূন উসনে ক়ুরবানগাহ কে চার পহলুওং পর ছিড়ক দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","উসনে মেংঢে কী চরবী, দুম, অংতড়িযোং পর কী সারী চরবী, জোড়কলেজী, দোনোং গুরদে উনকী চরবী সমেত ঔর দহনী রান অলগ কী। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ফির ৱহ রব কে সামনে পড়ী বেখ়মীরী রোটিযোং কী টোকরী মেং সে এক সাদা রোটী, এক রোটী জিসমেং তেল ডালা গযা থা ঔর এক রোটী জিস পর তেল লগাযা গযা থা লেকর চরবী ঔর রান পর রখ দী। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","উসনে যহ সব কুছ হারূন ঔর উসকে বেটোং কে হাথোং পর রখকর উসে হিলানেৱালী ক়ুরবানী কে তৌর পর রব কো পেশ কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ফির উসনে যহ চীজ়েং উনসে ৱাপস লেকর ক়ুরবানগাহ পর জলা দীং জিস পর পহলে ভস্ম হোনেৱালী ক়ুরবানী রখী গঈ থী। রব কে লিএ জলনেৱালী যহ ক়ুরবানী ইমামোং কো মখ়সূস করনে কে লিএ চঢ়াঈ গঈ, ঔর উস কী খ়ুশবূ রব কো পসংদ থী। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","মূসা নে সীনা ভী লিযা ঔর উসে হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাযা। যহ মখ়সূসিযত কে মেংঢে মেং সে মূসা কা হিস্সা থা। মূসা নে ইসমেং ভী সব কুছ রব কে হুক্ম কে ঐন মুতাবিক় কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ফির উসনে মসহ কে তেল ঔর ক়ুরবানগাহ পর কে খ়ূন মেং সে কুছ লেকর হারূন, উসকে বেটোং ঔর উনকে কপড়োং পর ছিড়ক দিযা। যোং উসনে উন্হেং ঔর উনকে কপড়োং কো মখ়সূসো-মুক়দ্দস কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","মূসা নে উনসে কহা, “গোশ্ত কো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর উবালকর উসে উন রোটিযোং কে সাথ খানা জো মখ়সূসিযত কী ক়ুরবানিযোং কী টোকরী মেং পড়ী হৈং। ক্যোংকি রব নে মুঝে যহী হুক্ম দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","গোশ্ত ঔর রোটিযোং কা বক়াযা জলা দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","সাত দিন তক মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে মেং সে ন নিকলনা, ক্যোংকি মক়দিস মেং খ়িদমত কে লিএ তুম্হারী মখ়সূসিযত কে ইতনে হী দিন হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","জো কুছ আজ হুআ হৈ ৱহ রব কে হুক্ম কে মুতাবিক় হুআ তাকি তুম্হারা কফ়্ফ়ারা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","তুম্হেং সাত রাত ঔর দিন তক খ়ৈমে কে দরৱাজ়ে কে অংদর রহনা হৈ। রব কী ইস হিদাযত কো মানো ৱরনা তুম মর জাওগে, ক্যোংকি যহ হুক্ম মুঝে রব কী তরফ় সে দিযা গযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","হারূন ঔর উসকে বেটোং নে উন তমাম হিদাযাত পর অমল কিযা জো রব নে মূসা কী মারিফ়ত উন্হেং দী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","মখ়সূসিযত কে সাত দিন কে বাদ মূসা নে আঠৱেং দিন হারূন, উসকে বেটোং ঔর ইসরাঈল কে বুজ়ুর্গোং কো বুলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","উসনে হারূন সে কহা, “এক বেঐব বছড়া ঔর এক বেঐব মেংঢা চুনকর রব কো পেশ কর। বছড়া গুনাহ কী ক়ুরবানী কে লিএ ঔর মেংঢা ভস্ম হোনেৱালী ক়ুরবানী কে লিএ হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ফির ইসরাঈলিযোং কো কহ দেনা কি গুনাহ কী ক়ুরবানী কে লিএ এক বকরা জবকি ভস্ম হোনেৱালী ক়ুরবানী কে লিএ এক বেঐব যকসালা বছড়া ঔর এক বেঐব যকসালা ভেড় কা বচ্চা পেশ করো। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","সাথ হী সলামতী কী ক়ুরবানী কে লিএ এক বৈল ঔর এক মেংঢা চুনো। তেল কে সাথ মিলাঈ হুঈ গ়ল্লা কী নজ়র ভী লেকর সব কুছ রব কো পেশ করো। ক্যোংকি আজ হী রব তুম পর জ়াহির হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ইসরাঈলী মূসা কী মতলূবা তমাম চীজ়েং মুলাক়াত কে খ়ৈমে কে সামনে লে আএ। পূরী জমাত ক়রীব আকর রব কে সামনে খড়ী হো গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","মূসা নে উনসে কহা, “তুম্হেং ৱহী করনা হৈ জিসকা হুক্ম রব নে তুম্হেং দিযা হৈ। ক্যোংকি আজ হী রব কা জলাল তুম পর জ়াহির হোগা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ফির উসনে হারূন সে কহা, “ক়ুরবানগাহ কে পাস জাকর গুনাহ কী ক়ুরবানী ঔর ভস্ম হোনেৱালী ক়ুরবানী চঢ়াকর অপনা ঔর অপনী ক়ৌম কা কফ়্ফ়ারা দেনা। রব কে হুক্ম কে মুতাবিক় ক়ৌম কে লিএ ভী ক়ুরবানী পেশ করনা তাকি উসকা কফ়্ফ়ারা দিযা জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","হারূন ক়ুরবানগাহ কে পাস আযা। উসনে বছড়ে কো জ়বহ কিযা। যহ উসকে লিএ গুনাহ কী ক়ুরবানী থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","উসকে বেটে বছড়ে কা খ়ূন উসকে পাস লে আএ। উসনে অপনী উঁগলী খ়ূন মেং ডুবোকর উসে ক়ুরবানগাহ কে সীংগোং পর লগাযা। বাক়ী খ়ূন কো উসনে ক়ুরবানগাহ কে পাএ পর উংডেল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ফির উসনে উস কী চরবী, গুরদোং ঔর জোড়কলেজী কো ক়ুরবানগাহ পর জলা দিযা। জৈসে রব নে মূসা কো হুক্ম দিযা থা ৱৈসে হী হারূন নে কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","বছড়ে কা গোশ্ত ঔর খাল উসনে খ়ৈমাগাহ কে বাহর লে জাকর জলা দী। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ইসকে বাদ হারূন নে ভস্ম হোনেৱালী ক়ুরবানী কো জ়বহ কিযা। উসকে বেটোং নে উসে উসকা খ়ূন দিযা, ঔর উসনে উসে ক়ুরবানগাহ কে চার পহলুওং পর ছিড়ক দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","উন্হোংনে উসে ক়ুরবানী কে মুখ়্তলিফ় টুকড়ে সর সমেত দিএ, ঔর উসনে উন্হেং ক়ুরবানগাহ পর জলা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ফির উসনে উস কী অংতড়িযাঁ ঔর পিংডলিযাঁ ধোকর ভস্ম হোনেৱালী ক়ুরবানী কী বাক়ী চীজ়োং পর রখকর জলা দীং। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","অব হারূন নে ক়ৌম কে লিএ ক়ুরবানী চঢ়াঈ। উসনে গুনাহ কী ক়ুরবানী কে লিএ বকরা জ়বহ করকে উসে পহলী ক়ুরবানী কী তরহ চঢ়াযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","উসনে ভস্ম হোনেৱালী ক়ুরবানী ভী ক়ৱাযদ কে মুতাবিক় চঢ়াঈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","উসনে গ়ল্লা কী নজ়র পেশ কী ঔর উসমেং সে মুট্ঠী-ভর ক়ুরবানগাহ পর জলা দিযা। যহ গ়ল্লা কী উস নজ়র কে অলাৱা থী জো সুবহ কো ভস্ম হোনেৱালী ক়ুরবানী কে সাথ চঢ়াঈ গঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ফির উসনে সলামতী কী ক়ুরবানী কে লিএ বৈল ঔর মেংঢে কো জ়বহ কিযা। যহ ভী ক়ৌম কে লিএ থী। উসকে বেটোং নে উসে জানৱরোং কা খ়ূন দিযা, ঔর উসনে উসে ক়ুরবানগাহ কে চার পহলুওং পর ছিড়ক দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","লেকিন উন্হোংনে বৈল ঔর মেংঢে কো চরবী, দুম, অংতড়িযোং পর কী চরবী ঔর জোড়কলেজী নিকালকর ");
INSERT INTO urdgvb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","সীনে কে টুকড়োং পর রখ দিযা। হারূন নে চরবী কা হিস্সা ক়ুরবানগাহ পর জলা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","সীনে কে টুকড়ে ঔর দহনী রানেং উসনে হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাঈং। উসনে সব কুছ মূসা কে হুক্ম কে মুতাবিক় হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","তমাম ক়ুরবানিযাঁ পেশ করনে কে বাদ হারূন নে অপনে হাথ উঠাকর ক়ৌম কো বরকত দী। ফির ৱহ ক়ুরবানগাহ সে উতরকর ");
INSERT INTO urdgvb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","মূসা কে সাথ মুলাক়াত কে খ়ৈমে মেং দাখ়িল হুআ। জব দোনোং বাহর আএ তো উন্হোংনে ক়ৌম কো বরকত দী। তব রব কা জলাল পূরী ক়ৌম পর জ়াহির হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","রব কে হুজ়ূর সে আগ নিকলকর ক়ুরবানগাহ পর উতরী ঔর ভস্ম হোনেৱালী ক়ুরবানী ঔর চরবী কে টুকড়ে ভস্ম কর দিএ। যহ দেখকর লোগ খ়ুশী কে নারে মারনে লগে ঔর মুঁহ কে বল গির গএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","হারূন কে বেটে নদব ঔর অবীহূ নে অপনে অপনে বখ়ূরদান লেকর উনমেং জলতে হুএ কোযলে ডালে। উন পর বখ়ূর ডালকর ৱহ রব কে সামনে আএ তাকি উসে পেশ করেং। লেকিন যহ আগ নাজাযজ় থী। রব নে যহ পেশ করনে কা হুক্ম নহীং দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","অচানক রব কে হুজ়ূর সে আগ নিকলী জিসনে উন্হেং ভস্ম কর দিযা। ৱহীং রব কে সামনে ৱহ মর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","মূসা নে হারূন সে কহা, “অব ৱহী হুআ হৈ জো রব নে ফ়রমাযা থা কি জো মেরে ক়রীব হৈং উনসে মৈং অপনী ক়ুদ্দূসিযত জ়াহির করূঁগা, মৈং তমাম ক়ৌম কে সামনে হী অপনে জলাল কা ইজ়হার করূঁগা।” হারূন খ়ামোশ রহা। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","মূসা নে হারূন কে চচা উজ়্জ়িযেল কে বেটোং মীসাএল ঔর ইল্সফ়ন কো বুলাকর কহা, “ইধর আও ঔর অপনে রিশ্তেদারোং কো মক়দিস কে সামনে সে উঠাকর খ়ৈমাগাহ কে বাহর লে জাও।” ");
INSERT INTO urdgvb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ৱহ আএ ঔর মূসা কে হুক্ম কে ঐন মুতাবিক় উন্হেং উনকে জ়েরজামোং সমেত উঠাকর খ়ৈমাগাহ কে বাহর লে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","মূসা নে হারূন ঔর উসকে দীগর বেটোং ইলিযজ়র ঔর ইতমর সে কহা, “মাতম কা ইজ়হার ন করো। ন অপনে বাল বিখরনে দো, ন অপনে কপড়ে ফাড়ো। ৱরনা তুম মর জাওগে ঔর রব পূরী জমাত সে নারাজ় হো জাএগা। লেকিন তুম্হারে রিশ্তেদার ঔর বাক়ী তমাম ইসরাঈলী জ়রূর ইনকা মাতম করেং জিনকো রব নে আগ সে হলাক কর দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে কে বাহর ন নিকলো ৱরনা তুম মর জাওগে, ক্যোংকি তুম্হেং রব কে তেল সে মসহ কিযা গযা হৈ।” চুনাঁচে উন্হোংনে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","রব নে হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“জব ভী তুঝে যা তেরে বেটোং কো মুলাক়াত কে খ়ৈমে মেং দাখ়িল হোনা হৈ তো মৈ যা কোঈ ঔর নশা-আৱর চীজ় পীনা মনা হৈ, ৱরনা তুম মর জাওগে। যহ উসূল আনেৱালী নসলোং কে লিএ ভী অবদ তক অনমিট হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","যহ ভী লাজ়িম হৈ কি তুম মুক়দ্দস ঔর গ়ৈরমুক়দ্দস চীজ়োং মেং, পাক ঔর নাপাক চীজ়োং মেং ইম্তিযাজ় করো। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","তুম্হেং ইসরাঈলিযোং কো তমাম পাবংদিযাঁ সিখানী হৈং জো মৈংনে তুম্হেং মূসা কী মারিফ়ত বতাঈ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","মূসা নে হারূন ঔর উসকে বচে হুএ বেটোং ইলিযজ়র ঔর ইতমর সে কহা, “গ়ল্লা কী নজ়র কা জো হিস্সা রব কে সামনে জলাযা নহীং জাতা উসে অপনে লিএ লেকর বেখ়মীরী রোটী পকানা ঔর ক়ুরবানগাহ কে পাস হী খানা। ক্যোংকি ৱহ নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","উসে মুক়দ্দস জগহ পর খানা, ক্যোংকি ৱহ রব কী জলনেৱালী ক়ুরবানিযোং মেং সে তুম্হারে ঔর তুম্হারে বেটোং কা হিস্সা হৈ। ক্যোংকি মুঝে ইসকা হুক্ম দিযা গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","জো সীনা হিলানেৱালী ক়ুরবানী ঔর দহনী রান উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ কী গঈ হৈ, ৱহ তুম ঔর তুম্হারে বেটে-বেটিযাঁ খা সকতে হৈং। উন্হেং মুক়দ্দস জগহ পর খানা হৈ। ইসরাঈলিযোং কী সলামতী কী ক়ুরবানিযোং মেং সে যহ টুকড়ে তুম্হারা হিস্সা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","লেকিন পহলে ইমাম রান ঔর সীনে কো জলনেৱালী ক়ুরবানিযোং কী চরবী কে সাথ পেশ করেং। ৱহ উন্হেং হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাএঁ। রব ফ়রমাতা হৈ কি যহ টুকড়ে অবদ তক তুম্হারে ঔর তুম্হারে বেটোং কা হিস্সা হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","মূসা নে দরিযাফ়্ত কিযা কি উস বকরে কে গোশ্ত কা ক্যা হুআ জো গুনাহ কী ক়ুরবানী কে তৌর পর চঢ়াযা গযা থা। উসে পতা চলা কি ৱহ ভী জল গযা থা। যহ সুনকর উসে হারূন কে বেটোং ইলিযজ়র ঔর ইতমর পর গ়ুস্সা আযা। উসনে পূছা, ");
INSERT INTO urdgvb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“তুমনে গুনাহ কী ক়ুরবানী কা গোশ্ত ক্যোং নহীং খাযা? তুম্হেং উসে মুক়দ্দস জগহ পর খানা থা। যহ এক নিহাযত মুক়দ্দস হিস্সা হৈ জো রব নে তুম্হেং দিযা তাকি তুম জমাত কা ক়ুসূর দূর করকে রব কে সামনে লোগোং কা কফ়্ফ়ারা দো। ");
INSERT INTO urdgvb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","চূঁকি ইস বকরে কা খ়ূন মক়দিস মেং ন লাযা গযা ইসলিএ তুম্হেং উসকা গোশ্ত মক়দিস মেং খানা থা জিস তরহ মৈংনে তুম্হেং হুক্ম দিযা থা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","হারূন নে মূসা কো জৱাব দেকর কহা, “দেখেং, আজ লোগোং নে অপনে লিএ গুনাহ কী ক়ুরবানী ঔর ভস্ম হোনেৱালী ক়ুরবানী রব কো পেশ কী হৈ জবকি মুঝ পর যহ আফ়ত গুজ়রী হৈ। অগর মৈং আজ গুনাহ কী ক়ুরবানী সে খাতা তো ক্যা যহ রব কো অচ্ছা লগতা?” ");
INSERT INTO urdgvb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","যহ বাত মূসা কো অচ্ছী লগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ইসরাঈলিযোং কো বতানা কি তুম্হেং জ়মীন পর রহনেৱালে জানৱরোং মেং সে জ়ৈল কে জানৱরোং কো খানে কী ইজাজ়ত হৈ : ");
INSERT INTO urdgvb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","জিনকে খুর যা পাঁৱ বিলকুল চিরে হুএ হৈং ঔর জো জুগালী করতে হৈং উন্হেং খানে কী ইজাজ়ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_4‏","004_11_4‏","LEV","11","4‏","6","ঊঁট, বিজ্জূ যা খ়রগোশ খানা মনা হৈ। ৱহ তুম্হারে লিএ নাপাক হৈং, ক্যোংকি ৱহ জুগালী তো করতে হৈং লেকিন উনকে খুর যা পাঁৱ চিরে হুএ নহীং হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","সুঅর ন খানা। ৱহ তুম্হারে লিএ নাপাক হৈ, ক্যোংকি উসকে খুর তো চিরে হুএ হৈং লেকিন ৱহ জুগালী নহীং করতা। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ন উনকা গোশ্ত খানা, ন উনকী লাশোং কো ছূনা। ৱহ তুম্হারে লিএ নাপাক হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","সমুংদরী ঔর দরিযাঈ জানৱর খানে কে লিএ জাযজ় হৈং অগর উনকে পর ঔর ছিলকে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","লেকিন জিনকে পর যা ছিলকে নহীং হৈং ৱহ সব তুম্হারে লিএ মকরূহ হৈং, খ়াহ ৱহ বড়ী তাদাদ মেং মিলকর রহতে হৈং যা নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ইসলিএ উনকা গোশ্ত খানা মনা হৈ, ঔর উনকী লাশোং সে ভী ঘিন খানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","পানী মেং রহনেৱালে তমাম জানৱর জিনকে পর যা ছিলকে ন হোং তুম্হারে লিএ মকরূহ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","জ়ৈল কে পরিংদে তুম্হারে লিএ ক়াবিলে-ঘিন হোং। ইন্হেং খানা মনা হৈ, ক্যোংকি ৱহ মকরূহ হৈং : উক়াব, দঢ়িযল গিদ্ধ, কালা গিদ্ধ, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","লাল চীল, হর ক়িস্ম কী কালী চীল, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","হর ক়িস্ম কা কৌৱা, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","উক়াবী উল্লূ, ছোটে কানৱালা উল্লূ, বড়ে কানৱালা উল্লূ, হর ক়িস্ম কা বাজ়, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ছোটা উল্লূ, ক়ূক়, চিংঘাড়নেৱালা উল্লূ, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","সফ়েদ উল্লূ, দশ্তী উল্লূ, মিসরী গিদ্ধ, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","লক়লক়, হর ক়িস্ম কা বূতীমার, হুদহুদ ঔর চমগাদড়। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","তমাম পর রখনেৱালে কীড়ে জো চার পাঁৱোং পর চলতে হৈং তুম্হারে লিএ মকরূহ হৈং, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","সিৱাএ উনকে জিনকী টাঁগোং কে দো হিস্সে হৈং ঔর জো ফুদকতে হৈং। উনকো তুম খা সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ইস নাতে সে তুম মুখ়্তলিফ় ক়িস্ম কে টিড্ডে খা সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","বাক়ী সব পর রখনেৱালে কীড়ে জো চার পাঁৱোং পর চলতে হৈং তুম্হারে লিএ মকরূহ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_24‏","004_11_24‏","LEV","11","24‏","28","জো ভী জ়ৈল কে জানৱরোং কী লাশেং ছুএ ৱহ শাম তক নাপাক রহেগা : (অলিফ়) খুর রখনেৱালে তমাম জানৱর সিৱাএ উনকে জিনকে খুর যা পাঁৱ পূরে তৌর পর চিরে হুএ হৈং ঔর জো জুগালী করতে হৈং, (বে) তমাম জানৱর জো অপনে চার পংজোং পর চলতে হৈং। যহ জানৱর তুম্হারে লিএ নাপাক হৈং, ঔর জো ভী উনকী লাশেং উঠাএ যা ছুএ লাজ়িম হৈ কি ৱহ অপনে কপড়ে ধো লে। ইসকে বাৱুজূদ ভী ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_29‏","004_11_29‏","LEV","11","29‏","30","জ়মীন পর রেংগনেৱালে জানৱরোং মেং সে ছছূঁদর, মুখ়্তলিফ় ক়িস্ম কে চূহে ঔর মুখ়্তলিফ় ক়িস্ম কী ছিপকলিযাঁ তুম্হারে লিএ নাপাক হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","জো ভী উন্হেং ঔর উনকী লাশেং ছূ লেতা হৈ ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","অগর উনমেং সে কিসী কী লাশ কিসী চীজ় পর গির পড়ে তো ৱহ ভী নাপাক হো জাএগী। ইসসে কোঈ ফ়রক় নহীং পড়তা কি ৱহ লকড়ী, কপড়ে, চমড়ে যা টাট কী বনী হো, ন ইসসে কোঈ ফ়রক় পড়তা হৈ কি ৱহ কিস কাম কে লিএ ইস্তেমাল কী জাতী হৈ। উসে হর সূরত মেং পানী মেং ডুবোনা হৈ। তো ভী ৱহ শাম তক নাপাক রহেগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","অগর ঐসী লাশ মিট্টী কে বরতন মেং গির জাএ তো জো কুছ ভী উসমেং হৈ নাপাক হো জাএগা ঔর তুম্হেং উস বরতন কো তোড়না হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","হর খানেৱালী চীজ় জিস পর ঐসে বরতন কা পানী ডালা গযা হৈ নাপাক হৈ। ইসী তরহ উস বরতন সে নিকলী হুঈ হর পীনেৱালী চীজ় নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","জিস পর ভী ঐসী লাশ গির পড়ে ৱহ নাপাক হো জাতা হৈ। অগর ৱহ তনূর যা চূল্হে পর গির পড়ে তো উনকো তোড় দেনা হৈ। ৱহ নাপাক হৈং ঔর তুম্হারে লিএ নাপাক রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","লেকিন জিস চশ্মে যা হৌজ় মেং ঐসী লাশ গিরে ৱহ পাক রহতা হৈ। সির্ফ় ৱহ জো লাশ কো ছূ লেতা হৈ নাপাক হো জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","অগর ঐসী লাশ বীজোং পর গির পড়ে জিনকো অভী বোনা হৈ তো ৱহ পাক রহতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","লেকিন অগর বীজোং পর পানী ডালা গযা হো ঔর ফির লাশ উন পর গির পড়ে তো ৱহ নাপাক হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","অগর ঐসা জানৱর জিসে খানে কী ইজাজ়ত হৈ মর জাএ তো জো ভী উস কী লাশ ছুএ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","জো উসমেং সে কুছ খাএ যা উসে উঠাকর লে জাএ উসে অপনে কপড়োং কো ধোনা হৈ। তো ভী ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","হর জানৱর জো জ়মীন পর রেংগতা হৈ ক়াবিলে-ঘিন হৈ। উসে খানা মনা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","চাহে ৱহ অপনে পেট পর চাহে চার যা ইসসে জ়াযদ পাঁৱোং পর চলতা হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ইন তমাম রেংগনেৱালোং সে অপনে আপকো ঘিন কা বাইস ঔর নাপাক ন বনানা, ");
INSERT INTO urdgvb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ক্যোংকি মৈং রব তুম্হারা খ়ুদা হূঁ। লাজ়িম হৈ কি তুম অপনে আপকো মখ়সূসো-মুক়দ্দস রখো, ক্যোংকি মৈং ক়ুদ্দূস হূঁ। অপনে আপকো জ়মীন পর রেংগনেৱালে তমাম জানৱরোং সে নাপাক ন বনানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","মৈং রব হূঁ। মৈং তুম্হেং মিসর সে নিকাল লাযা হূঁ তাকি তুম্হারা খ়ুদা বনূঁ। লিহাজ়া মুক়দ্দস রহো, ক্যোংকি মৈং ক়ুদ্দূস হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","জ়মীন পর চলনেৱালে জানৱরোং, পরিংদোং, আবী জানৱরোং ঔর জ়মীন পর রেংগনেৱালে জানৱরোং কে বারে মেং শরঅ যহী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","লাজ়িম হৈ কি তুম নাপাক ঔর পাক মেং ইম্তিযাজ় করো, ঐসে জানৱরোং মেং জো খানে কে লিএ জাযজ় হৈং ঔর ঐসোং মেং জো নাজাযজ় হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ইসরাঈলিযোং কো বতা কি জব কিসী ঔরত কে লড়কা পৈদা হো তো ৱহ মাহৱারী কে ঐযাম কী তরহ সাত দিন তক নাপাক রহেগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","আঠৱেং দিন লড়কে কা খ়তনা করৱানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ফির মাঁ মজ়ীদ 33 দিন ইংতজ়ার করে। ইসকে বাদ উস কী ৱহ নাপাকী দূর হো জাএগী জো খ়ূন বহনে সে পৈদা হুঈ হৈ। ইস দৌরান ৱহ কোঈ মখ়সূস ঔর মুক়দ্দস চীজ় ন ছুএ, ন মক়দিস কে পাস জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","অগর উসকে লড়কী পৈদা হো জাএ তো ৱহ মাহৱারী কে ঐযাম কী তরহ নাপাক হৈ। যহ নাপাকী 14 দিন তক রহেগী। ফির ৱহ মজ়ীদ 66 দিন ইংতজ়ার করে। ইসকে বাদ উস কী ৱহ নাপাকী দূর হো জাএগী জো খ়ূন বহনে সে পৈদা হুঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","জব লড়কে যা লড়কী কে সিলসিলে মেং যহ দিন গুজ়র জাএঁ তো ৱহ মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর ইমাম কো জ়ৈল কী চীজ়েং দে : ভস্ম হোনেৱালী ক়ুরবানী কে লিএ এক যকসালা ভেড় কা বচ্চা ঔর গুনাহ কী ক়ুরবানী কে লিএ এক জৱান কবূতর যা ক়ুম্রী। ");
INSERT INTO urdgvb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ইমাম যহ জানৱর রব কো পেশ করকে উসকা কফ়্ফ়ারা দে। ফির খ়ূন বহনে কে বাইস পৈদা হোনেৱালী নাপাকী দূর হো জাএগী। উসূল এক হী হৈ, চাহে লড়কা হো যা লড়কী। ");
INSERT INTO urdgvb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","অগর ৱহ গ়ুরবত কে বাইস ভেড় কা বচ্চা ন দে সকে তো ফির ৱহ দো ক়ুম্রিযাঁ যা দো জৱান কবূতর লে আএ, এক ভস্ম হোনেৱালী ক়ুরবানী কে লিএ ঔর দূসরা গুনাহ কী ক়ুরবানী কে লিএ। যোং ইমাম উসকা কফ়্ফ়ারা দে ঔর ৱহ পাক হো জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“অগর কিসী কী জিল্দ মেং সূজন যা পপড়ী যা সফ়েদ দাগ় হো ঔর খ়তরা হৈ কি ৱবাঈ জিল্দী বীমারী হো তো উসে ইমামোং যানী হারূন যা উসকে বেটোং কে পাস লে আনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ইমাম উস জগহ কা মুআযনা করে। অগর উসকে বাল সফ়েদ হো গএ হোং ঔর ৱহ জিল্দ মেং ধঁসী হুঈ হো তো ৱবাঈ বীমারী হৈ। জব ইমাম কো যহ মালূম হো তো ৱহ উসে নাপাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","লেকিন হো সকতা হৈ কি জিল্দ কী জগহ সফ়েদ তো হৈ লেকিন জিল্দ মেং ধঁসী হুঈ নহীং হৈ, ন উসকে বাল সফ়েদ হুএ হৈং। ইস সূরত মেং ইমাম উস শখ়্স কো সাত দিন কে লিএ অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","সাতৱেং দিন ইমাম দুবারা উসকা মুআযনা করে। অগর ৱহ দেখে কি মুতঅস্সিরা জগহ ৱৈসী হী হৈ ঔর ফৈলী নহীং তো ৱহ উসে মজ়ীদ সাত দিন অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","সাতৱেং দিন ৱহ এক ঔর মরতবা উসকা মুআযনা করে। অগর উস জগহ কা রংগ দুবারা সেহতমংদ জিল্দ কে রংগ কী মানিংদ হো রহা হো ঔর ফৈলী ন হো তো ৱহ উসে পাক ক়রার দে। ইসকা মতলব হৈ কি যহ মরজ় আম পপড়ী সে জ়্যাদা নহীং হৈ। মরীজ় অপনে কপড়ে ধো লে তো ৱহ পাক হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","লেকিন অগর ইসকে বাদ মুতঅস্সিরা জগহ ফৈলনে লগে তো ৱহ দুবারা অপনে আপকো ইমাম কো দিখাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ইমাম উসকা মুআযনা করে। অগর জগহ ৱাক়ঈ ফৈল গঈ হো তো ইমাম উসে নাপাক ক়রার দে, ক্যোংকি যহ ৱবাঈ জিল্দী মরজ় হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","অগর কিসী কে জিস্ম পর ৱবাঈ জিল্দী মরজ় নজ়র আএ তো উসে ইমাম কে পাস লাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ইমাম উসকা মুআযনা করে। অগর মুতঅস্সিরা জিল্দ মেং সফ়েদ সূজন হো, উসকে বাল ভী সফ়েদ হো গএ হোং, ঔর উসমেং কচ্চা গোশ্ত মৌজূদ হো ");
INSERT INTO urdgvb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","তো ইসকা মতলব হৈ কি ৱবাঈ জিল্দী বীমারী পুরানী হৈ। ইমাম উস শখ়্স কো সাত দিন কে লিএ অলহদগী মেং রখকর ইংতজ়ার ন করে বল্কি উসে ফ়ৌরন নাপাক ক়রার দে, ক্যোংকি যহ উস কী নাপাকী কা সবূত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","লেকিন অগর বীমারী জল্দী সে ফৈল গঈ হো, যহাঁ তক কি সর সে লেকর পাঁৱ তক পূরী জিল্দ মুতঅস্সির হুঈ হো ");
INSERT INTO urdgvb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","তো ইমাম যহ দেখকর মরীজ় কো পাক ক়রার দে। চূঁকি পূরী জিল্দ সফ়েদ হো গঈ হৈ ইসলিএ ৱহ পাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","লেকিন জব ভী কহীং কচ্চা গোশ্ত নজ়র আএ উস ৱক়্ত ৱহ নাপাক হো জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ইমাম যহ দেখকর মরীজ় কো নাপাক ক়রার দে। কচ্চা গোশ্ত হর সূরত মেং নাপাক হৈ, ক্যোংকি ইসকা মতলব হৈ কি ৱবাঈ জিল্দী বীমারী লগ গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","অগর কচ্চে গোশ্ত কা যহ জ়খ়ম ভর জাএ ঔর মুতঅস্সিরা জগহ কী জিল্দ সফ়েদ হো জাএ তো মরীজ় ইমাম কে পাস জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","অগর ইমাম দেখে কি ৱাক়ঈ ঐসা হী হুআ হৈ ঔর মুতঅস্সিরা জিল্দ সফ়েদ হো গঈ হৈ তো ৱহ উসে পাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","অগর কিসী কী জিল্দ পর ফোড়া হো লেকিন ৱহ ঠীক হো জাএ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ঔর উস কী জগহ সফ়েদ সূজন যা সুরখ়ী-মাযল সফ়েদ দাগ় নজ়র আএ তো মরীজ় অপনে আপকো ইমাম কো দিখাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","অগর ৱহ উসকা মুআযনা করকে দেখে কি মুতঅস্সিরা জগহ জিল্দ কে অংদর ধঁসী হুঈ হৈ ঔর উসকে বাল সফ়েদ হো গএ হৈং তো ৱহ মরীজ় কো নাপাক ক়রার দে। ক্যোংকি ইসকা মতলব হৈ কি জহাঁ পহলে ফোড়া থা ৱহাঁ ৱবাঈ জিল্দী বীমারী পৈদা হো গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","লেকিন অগর ইমাম দেখে কি মুতঅস্সিরা জগহ কে বাল সফ়েদ নহীং হৈং, ৱহ জিল্দ মেং ধঁসী হুঈ নজ়র নহীং আতী ঔর উসকা রংগ দুবারা সেহতমংদ জিল্দ কী মানিংদ হো রহা হৈ তো ৱহ উসে সাত দিন কে লিএ অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","অগর ইস দৌরান বীমারী মজ়ীদ ফৈল জাএ তো ইমাম মরীজ় কো নাপাক ক়রার দে, ক্যোংকি ইসকা মতলব হৈ কি ৱবাঈ জিল্দী বীমারী লগ গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","লেকিন অগর দাগ় ন ফৈলে তো ইসকা মতলব হৈ কি যহ সির্ফ় উস ভরে হুএ জ়খ়ম কা নিশান হৈ জো ফোড়ে সে পৈদা হুআ থা। ইমাম মরীজ় কো পাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","অগর কিসী কী জিল্দ পর জলনে কা জ়খ়ম লগ জাএ ঔর মুতঅস্সিরা জগহ পর সুরখ়ী-মাযল সফ়েদ দাগ় যা সফ়েদ দাগ় পৈদা হো জাএ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","তো ইমাম মুতঅস্সিরা জগহ কা মুআযনা করে। অগর মালূম হো জাএ কি মুতঅস্সিরা জগহ কে বাল সফ়েদ হো গএ হৈং ঔর ৱহ জিল্দ মেং ধঁসী হুঈ হৈ তো ইসকা মতলব হৈ কি চোট কী জগহ পর ৱবাঈ জিল্দী মরজ় লগ গযা হৈ। ইমাম উসে নাপাক ক়রার দে, ক্যোংকি ৱবাঈ জিল্দী বীমারী লগ গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","লেকিন অগর ইমাম নে মালূম কিযা হৈ কি দাগ় মেং বাল সফ়েদ নহীং হৈং, ৱহ জিল্দ মেং ধঁসা হুআ নজ়র নহীং আতা ঔর উসকা রংগ সেহতমংদ জিল্দ কী মানিংদ হো রহা হৈ তো ৱহ মরীজ় কো সাত দিন তক অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","অগর ৱহ সাতৱেং দিন মালূম করে কি মুতঅস্সিরা জগহ ফৈল গঈ হৈ তো ৱহ উসে নাপাক ক়রার দে। ক্যোংকি ইসকা মতলব হৈ কি ৱবাঈ জিল্দী বীমারী লগ গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","লেকিন অগর দাগ় ফৈলা হুআ নজ়র নহীং আতা ঔর মুতঅস্সিরা জিল্দ কা রংগ সেহতমংদ জিল্দ কে রংগ কী মানিংদ হো গযা হৈ তো ইসকা মতলব হৈ কি যহ সির্ফ় উস ভরে হুএ জ়খ়ম কা নিশান হৈ জো জলনে সে পৈদা হুআ থা। ইমাম মরীজ় কো পাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","অগর কিসী কে সর যা দাঢ়ী কী জিল্দ মেং নিশান নজ়র আএ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","তো ইমাম মুতঅস্সিরা জগহ কা মুআযনা করে। অগর ৱহ ধঁসী হুঈ নজ়র আএ ঔর উসকে বাল রংগ কে লিহাজ় সে চমকতে হুএ সোনে কী মানিংদ ঔর বারীক হোং তো ইমাম মরীজ় কো নাপাক ক়রার দে। ইসকা মতলব হৈ কি ঐসী ৱবাঈ জিল্দী বীমারী সর যা দাঢ়ী কী জিল্দ পর লগ গঈ হৈ জো খ়ারিশ পৈদা করতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","লেকিন অগর ইমাম নে মালূম কিযা কি মুতঅস্সিরা জগহ জিল্দ মেং ধঁসী হুঈ নজ়র নহীং আতী অগরচে উসকে বালোং কা রংগ বদল গযা হৈ তো ৱহ উসে সাত দিন কে লিএ অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","সাতৱেং দিন ইমাম জিল্দ কী মুতঅস্সিরা জগহ কা মুআযনা করে। অগর ৱহ ফৈলী হুঈ নজ়র নহীং আতী ঔর উসকে বালোং কা রংগ চমকদার সোনে কী মানিংদ নহীং হৈ, সাথ হী ৱহ জগহ জিল্দ মেং ধঁসী হুঈ ভী দিখাঈ নহীং দেতী, ");
INSERT INTO urdgvb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","তো মরীজ় অপনে বাল মুঁডৱাএ। সির্ফ় ৱহ বাল রহ জাএঁ জো মুতঅস্সিরা জগহ সে নিকলতে হৈং। ইমাম মরীজ় কো মজ়ীদ সাত দিন অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","সাতৱেং দিন ৱহ উসকা মুআযনা করে। অগর মুতঅস্সিরা জগহ নহীং ফৈলী ঔর ৱহ জিল্দ মেং ধঁসী হুঈ নজ়র নহীং আতী তো ইমাম উসে পাক ক়রার দে। ৱহ অপনে কপড়ে ধো লে তো ৱহ পাক হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","লেকিন অগর ইসকে বাদ জিল্দ কী মুতঅস্সিরা জগহ ফৈলনা শুরূ হো জাএ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","তো ইমাম দুবারা উসকা মুআযনা করে। অগর ৱহ জগহ ৱাক়ঈ ফৈলী হুঈ নজ়র আএ তো মরীজ় নাপাক হৈ, চাহে মুতঅস্সিরা জগহ কে বালোং কা রংগ চমকতে সোনে কী মানিংদ হো যা ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","লেকিন অগর উসকে খ়যাল মেং মুতঅস্সিরা জগহ ফৈলী হুঈ নজ়র নহীং আতী বল্কি উসমেং সে কালে রংগ কে বাল নিকল রহে হৈং তো ইসকা মতলব হৈ কি মরীজ় কী সেহত বহাল হো গঈ হৈ। ইমাম উসে পাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","অগর কিসী মর্দ যা ঔরত কী জিল্দ পর সফ়েদ দাগ় পৈদা হো জাএঁ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","তো ইমাম উনকা মুআযনা করে। অগর উনকা সফ়েদ রংগ হলকা-সা হো তো যহ সির্ফ় বেজ়রর পপড়ী হৈ। মরীজ় পাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_40‏","004_13_40‏","LEV","13","40‏","41","অগর কিসী মর্দ কা সর মাথে কী তরফ় যা পীছে কী তরফ় গংজা হৈ তো ৱহ পাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","লেকিন অগর উস জগহ জহাঁ ৱহ গংজা হৈ সুরখ়ী-মাযল সফ়েদ দাগ় হো তো ইসকা মতলব হৈ কি ৱহাঁ ৱবাঈ জিল্দী বীমারী লগ গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ইমাম উসকা মুআযনা করে। অগর গংজী জগহ পর সুরখ়ী-মাযল সফ়েদ সূজন হো জো ৱবাঈ জিল্দী বীমারী কী মানিংদ নজ়র আএ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","তো মরীজ় কো ৱবাঈ জিল্দী বীমারী লগ গঈ হৈ। ইমাম উসে নাপাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ৱবাঈ জিল্দী বীমারী কা মরীজ় ফটে কপড়ে পহনে। উসকে বাল বিখরে রহেং। ৱহ অপনী মূঁছোং কো কিসী কপড়ে সে ছুপাএ ঔর পুকারতা রহে, ‘নাপাক, নাপাক।’ ");
INSERT INTO urdgvb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","জিস ৱক়্ত তক ৱবাঈ জিল্দী বীমারী লগী রহে ৱহ নাপাক হৈ। ৱহ ইস দৌরান খ়ৈমাগাহ কে বাহর জাকর তনহাঈ মেং রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","হো সকতা হৈ কি ঊন যা কতান কে কিসী লিবাস পর ফফূঁদী লগ গঈ হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","যা কি ফফূঁদী ঊন যা কতান কে কিসী কপড়ে কে টুকড়ে যা কিসী চমড়ে যা চমড়ে কী কিসী চীজ় পর লগ গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","অগর ফফূঁদী কা রংগ হরা যা লাল-সা হো তো ৱহ ফৈলনেৱালী ফফূঁদী হৈ, ঔর লাজ়িম হৈ কি উসে ইমাম কো দিখাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ইমাম উসকা মুআযনা করকে উসে সাত দিন কে লিএ অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","সাতৱেং দিন ৱহ দুবারা উসকা মুআযনা করে। অগর ফফূঁদী ফৈল গঈ হো তো ইসকা মতলব হৈ কি ৱহ নুক়সানদেহ হৈ। মুতঅস্সিরা চীজ় নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ইমাম উসে জলা দে, ক্যোংকি যহ ফফূঁদী নুক়সানদেহ হৈ। লাজ়িম হৈ কি উসে জলা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","লেকিন অগর ইন সাত দিনোং কে বাদ ফফূঁদী ফৈলী হুঈ নজ়র নহীং আতী ");
INSERT INTO urdgvb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","তো ইমাম হুক্ম দে কি মুতঅস্সিরা চীজ় কো ধুলৱাযা জাএ। ফির ৱহ উসে মজ়ীদ সাত দিন কে লিএ অলহদগী মেং রখে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ইসকে বাদ ৱহ দুবারা উসকা মুআযনা করে। অগর ৱহ মালূম করে কি ফফূঁদী তো ফৈলী হুঈ নজ়র নহীং আতী লেকিন উসকা রংগ ৱৈসে কা ৱৈসা হৈ তো ৱহ নাপাক হৈ। উসে জলা দেনা, চাহে ফফূঁদী মুতঅস্সিরা চীজ় কে সামনেৱালে হিস্সে যা পিছলে হিস্সে মেং লগী হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","লেকিন অগর মালূম হো জাএ কি ফফূঁদী কা রংগ মাঁদ পড় গযা হৈ তো ইমাম কপড়ে যা চমড়ে মেং সে মুতঅস্সিরা জগহ ফাড়কর নিকাল দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","তো ভী হো সকতা হৈ কি ফফূঁদী দুবারা উসী কপড়ে যা চমড়ে পর নজ়র আএ। ইসকা মতলব হৈ কি ৱহ ফৈল রহী হৈ ঔর উসে জলা দেনা লাজ়িম হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","লেকিন অগর ফফূঁদী ধোনে কে বাদ গ়াযব হো জাএ তো উসে এক ঔর দফ়া ধোনা হৈ। ফির মুতঅস্সিরা চীজ় পাক হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ইসী তরহ ফফূঁদী সে নিপটনা হৈ, চাহে ৱহ ঊন যা কতান কে কিসী লিবাস কো লগ গঈ হো, চাহে ঊন যা কতান কে কিসী টুকড়ে যা চমড়ে কী কিসী চীজ় কো লগ গঈ হো। ইন্হীং উসূলোং কে তহত ফ়ৈসলা করনা হৈ কি মুতঅস্সিরা চীজ় পাক হৈ যা নাপাক।” ");
INSERT INTO urdgvb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“অগর কোঈ শখ়্স জিল্দী বীমারী সে শফ়া পাএ ঔর উসে পাক-সাফ় করানা হৈ তো উসে ইমাম কে পাস লাযা জাএ ");
INSERT INTO urdgvb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","জো খ়ৈমাগাহ কে বাহর জাকর উসকা মুআযনা করে। অগর ৱহ দেখে কি মরীজ় কী সেহত ৱাক়ঈ বহাল হো গঈ হৈ ");
INSERT INTO urdgvb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","তো ইমাম উসকে লিএ দো জ়িংদা ঔর পাক পরিংদে, দেৱদার কী লকড়ী, ক়িরমিজ়ী রংগ কা ধাগা ঔর জ়ূফ়া মঁগৱাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ইমাম কে হুক্ম পর পরিংদোং মেং সে এক কো তাজ়া পানী সে ভরে হুএ মিট্টী কে বরতন কে ঊপর জ়বহ কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ইমাম জ়িংদা পরিংদে কো দেৱদার কী লকড়ী, ক়িরমিজ়ী রংগ কে ধাগে ঔর জ়ূফ়া কে সাথ জ়বহ কিএ গএ পরিংদে কে উস খ়ূন মেং ডুবো দে জো মিট্টী কে বরতন কে পানী মেং আ গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ৱহ পানী সে মিলাযা হুআ খ়ূন সাত বার পাক হোনেৱালে শখ়্স পর ছিড়ককর উসে পাক ক়রার দে, ফির জ়িংদা পরিংদে কো খুলে মৈদান মেং ছোড় দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","জো অপনে আপকো পাক-সাফ় করা রহা হৈ ৱহ অপনে কপড়ে ধোএ, অপনে তমাম বাল মুঁডৱাএ ঔর নহা লে। ইসকে বাদ ৱহ পাক হৈ। অব ৱহ খ়ৈমাগাহ মেং দাখ়িল হো সকতা হৈ অগরচে ৱহ মজ়ীদ সাত দিন অপনে ডেরে মেং নহীং জা সকতা। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","সাতৱেং দিন ৱহ দুবারা অপনে সর কে বাল, অপনী দাঢ়ী, অপনে অবরূ ঔর বাক়ী তমাম বাল মুঁডৱাএ। ৱহ অপনে কপড়ে ধোএ ঔর নহা লে। তব ৱহ পাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","আঠৱেং দিন ৱহ দো ভেড় কে নর বচ্চে ঔর এক যকসালা ভেড় চুন লে জো বেঐব হোং। সাথ হী ৱহ গ়ল্লা কী নজ়র কে লিএ তেল কে সাথ মিলাযা গযা সাঢ়ে 4 কিলোগ্রাম বেহতরীন মৈদা ঔর 300 মিলীলিটর তেল লে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ফির জিস ইমাম নে উসে পাক ক়রার দিযা ৱহ উসে ইন ক়ুরবানিযোং সমেত মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর রব কো পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ভেড় কা এক নর বচ্চা ঔর 300 মিলীলিটর তেল ক়ুসূর কী ক়ুরবানী কে লিএ হৈ। ইমাম উন্হেং হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ফির ৱহ ভেড় কে ইস বচ্চে কো খ়ৈমে কে দরৱাজ়ে পর জ়বহ করে জহাঁ গুনাহ কী ক়ুরবানিযাঁ ঔর ভস্ম হোনেৱালী ক়ুরবানিযাঁ জ়বহ কী জাতী হৈং। গুনাহ কী ক়ুরবানিযোং কী তরহ ক়ুসূর কী যহ ক়ুরবানী ইমাম কা হিস্সা হৈ ঔর নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ইমাম খ়ূন মেং সে কুছ লেকর পাক হোনেৱালে কে দহনে কান কী লৌ পর ঔর উসকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","অব ৱহ 300 মিলীলিটর তেল মেং সে কুছ লেকর অপনে বাএঁ হাথ কী হথেলী পর ডালে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","অপনে দহনে হাথ কে অংগূঠে কে সাথৱালী উঁগলী ইস তেল মেং ডুবোকর ৱহ উসে সাত বার রব কে সামনে ছিড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ৱহ অপনী হথেলী পর কে তেল মেং সে কুছ ঔর লেকর পাক হোনেৱালে কে দহনে কান কী লৌ পর ঔর উসকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর লগা দে যানী উন জগহোং পর জহাঁ ৱহ ক়ুসূর কী ক়ুরবানী কা খ়ূন লগা চুকা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ইমাম অপনী হথেলী পর কা বাক়ী তেল পাক হোনেৱালে কে সর পর ডালকর রব কে সামনে উসকা কফ়্ফ়ারা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ইসকে বাদ ইমাম গুনাহ কী ক়ুরবানী চঢ়াকর পাক হোনেৱালে কা কফ়্ফ়ারা দে। আখ়ির মেং ৱহ ভস্ম হোনেৱালী ক়ুরবানী কা জানৱর জ়বহ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ৱহ উসে গ়ল্লা কী নজ়র কে সাথ ক়ুরবানগাহ পর চঢ়াকর উসকা কফ়্ফ়ারা দে। তব ৱহ পাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","অগর শফ়াযাব শখ়্স গ়ুরবত কে বাইস যহ ক়ুরবানিযাঁ নহীং চঢ়া সকতা তো ফির ৱহ ক়ুসূর কী ক়ুরবানী কে লিএ ভেড় কা সির্ফ় এক নর বচ্চা লে আএ। কাফ়ী হৈ কি কফ়্ফ়ারা দেনে কে লিএ যহী রব কে সামনে হিলাযা জাএ। সাথ সাথ গ়ল্লা কী নজ়র কে লিএ ডেঢ় কিলোগ্রাম বেহতরীন মৈদা তেল কে সাথ মিলাকর পেশ কিযা জাএ ঔর 300 মিলীলিটর তেল। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ইসকে অলাৱা ৱহ দো ক়ুম্রিযাঁ যা দো জৱান কবূতর পেশ করে, এক কো গুনাহ কী ক়ুরবানী কে লিএ ঔর দূসরে কো ভস্ম হোনেৱালী ক়ুরবানী কে লিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","আঠৱেং দিন ৱহ উন্হেং মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর ইমাম কে পাস ঔর রব কে সামনে লে আএ তাকি ৱহ পাক-সাফ় হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ইমাম ভেড় কে বচ্চে কো 300 মিলীলিটর তেল সমেত লেকর হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ৱহ ক়ুসূর কী ক়ুরবানী কে লিএ ভেড় কে বচ্চে কো জ়বহ করে ঔর উসকে খ়ূন মেং সে কুছ লেকর পাক হোনেৱালে কে দহনে কান কী লৌ পর ঔর উসকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","অব ৱহ 300 মিলীলিটর তেল মেং সে কুছ অপনে বাএঁ হাথ কী হথেলী পর ডালে ");
INSERT INTO urdgvb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ঔর অপনে দহনে হাথ কে অংগূঠে কে সাথৱালী উঁগলী ইস তেল মেং ডুবোকর উসে সাত বার রব কে সামনে ছিড়ক দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ৱহ অপনী হথেলী পর কে তেল মেং সে কুছ ঔর লেকর পাক হোনেৱালে কে দহনে কান কী লৌ পর ঔর উসকে দহনে হাথ ঔর দহনে পাঁৱ কে অংগূঠোং পর লগা দে যানী উন জগহোং পর জহাঁ ৱহ ক়ুসূর কী ক়ুরবানী কা খ়ূন লগা চুকা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","অপনী হথেলী পর কা বাক়ী তেল ৱহ পাক হোনেৱালে কে সর পর ডাল দে তাকি রব কে সামনে উসকা কফ়্ফ়ারা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ইসকে বাদ ৱহ শফ়াযাব শখ়্স কী গুংজাইশ কে মুতাবিক় দো ক়ুম্রিযাঁ যা দো জৱান কবূতর চঢ়াএ, ");
INSERT INTO urdgvb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","এক কো গুনাহ কী ক়ুরবানী কে লিএ ঔর দূসরে কো ভস্ম হোনেৱালী ক়ুরবানী কে লিএ। সাথ হী ৱহ গ়ল্লা কী নজ়র পেশ করে। যোং ইমাম রব কে সামনে উসকা কফ়্ফ়ারা দেতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","যহ উসূল ঐসে শখ়্স কে লিএ হৈ জো ৱবাঈ জিল্দী বীমারী সে শফ়া পা গযা হৈ লেকিন অপনী গ়ুরবত কে বাইস পাক হো জানে কে লিএ পূরী ক়ুরবানী পেশ নহীং কর সকতা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“জব তুম মুল্কে-কনান মেং দাখ়িল হোগে জো মৈং তুম্হেং দূঁগা তো ৱহাঁ ঐসে মকান হোংগে জিনমেং মৈংনে ফফূঁদী ফৈলনে দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ঐসে ঘর কা মালিক জাকর ইমাম কো বতাএ কি মৈংনে অপনে ঘর মেং ফফূঁদী জৈসী কোঈ চীজ় দেখী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","তব ইমাম হুক্ম দে কি ঘর কা মুআযনা করনে সে পহলে ঘর কা পূরা সামান নিকালা জাএ। ৱরনা অগর ঘর কো নাপাক ক়রার দিযা জাএ তো সামান কো ভী নাপাক ক়রার দিযা জাএগা। ইসকে বাদ ইমাম অংদর জাকর মকান কা মুআযনা করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ৱহ দীৱারোং কে সাথ লগী হুঈ ফফূঁদী কা মুআযনা করে। অগর মুতঅস্সিরা জগহেং হরী যা লাল-সী হোং ঔর দীৱার কে অংদর ধঁসী হুঈ নজ়র আএঁ ");
INSERT INTO urdgvb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","তো ফির ইমাম ঘর সে নিকলকর সাত দিন কে লিএ তালা লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","সাতৱেং দিন ৱহ ৱাপস আকর মকান কা মুআযনা করে। অগর ফফূঁদী ফৈলী হুঈ নজ়র আএ ");
INSERT INTO urdgvb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","তো ৱহ হুক্ম দে কি মুতঅস্সিরা পত্থরোং কো নিকালকর আবাদী কে বাহর কিসী নাপাক জগহ পর ফেংকা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","নীজ় ৱহ হুক্ম দে কি অংদর কী দীৱারোং কো কুরেদা জাএ ঔর কুরেদী হুঈ মিট্টী কো আবাদী কে বাহর কিসী নাপাক জগহ পর ফেংকা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ফির লোগ নএ পত্থর লগাকর ঘর কো নএ গারে সে পলস্তর করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","লেকিন অগর ইসকে বাৱুজূদ ফফূঁদী দুবারা পৈদা হো জাএ ");
INSERT INTO urdgvb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","তো ইমাম আকর দুবারা উসকা মুআযনা করে। অগর ৱহ দেখে কি ফফূঁদী ঘর মেং ফৈল গঈ হৈ তো ইসকা মতলব হৈ কি ফফূঁদী নুক়সানদেহ হৈ, ইসলিএ ঘর নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","লাজ়িম হৈ কি উসে পূরে তৌর পর ঢা দিযা জাএ ঔর সব কুছ যানী উসকে পত্থর, লকড়ী ঔর পলস্তর কো আবাদী কে বাহর কিসী নাপাক জগহ পর ফেংকা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","অগর ইমাম নে কিসী ঘর কা মুআযনা করকে তালা লগা দিযা হৈ ঔর ফির ভী কোঈ উস ঘর মেং দাখ়িল হো জাএ তো ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","জো ঐসে ঘর মেং সোএ যা খানা খাএ লাজ়িম হৈ কি ৱহ অপনে কপড়ে ধো লে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","লেকিন অগর ঘর কো নএ সিরে সে পলস্তর করনে কে বাদ ইমাম আকর উসকা দুবারা মুআযনা করে ঔর দেখে কি ফফূঁদী দুবারা নহীং নিকলী তো ইসকা মতলব হৈ কি ফফূঁদী খ়ত্ম হো গঈ হৈ। ৱহ উসে পাক ক়রার দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","উসে গুনাহ সে পাক-সাফ় করানে কে লিএ ৱহ দো পরিংদে, দেৱদার কী লকড়ী, ক়িরমিজ়ী রংগ কা ধাগা ঔর জ়ূফ়া লে লে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ৱহ পরিংদোং মেং সে এক কো তাজ়া পানী সে ভরে হুএ মিট্টী কে বরতন কে ঊপর জ়বহ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ইসকে বাদ ৱহ দেৱদার কী লকড়ী, জ়ূফ়া, ক়িরমিজ়ী রংগ কা ধাগা ঔর জ়িংদা পরিংদা লেকর উস তাজ়া পানী মেং ডুবো দে জিসকে সাথ জ়বহ কিএ হুএ পরিংদে কা খ়ূন মিলাযা গযা হৈ ঔর ইস পানী কো সাত বার ঘর পর ছিড়ক দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ইন চীজ়োং সে ৱহ ঘর কো গুনাহ সে পাক-সাফ় করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","আখ়ির মেং ৱহ জ়িংদা পরিংদে কো আবাদী কে বাহর খুলে মৈদান মেং ছোড় দে। যোং ৱহ ঘর কা কফ়্ফ়ারা দেগা, ঔর ৱহ পাক-সাফ় হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_54‏","004_14_54‏","LEV","14","54‏","56","লাজ়িম হৈ কি হর ক়িস্ম কী ৱবাঈ বীমারী সে ঐসে নিপটো জৈসে বযান কিযা গযা হৈ, চাহে ৱহ ৱবাঈ জিল্দী বীমারিযাঁ হোং (মসলন খ়ারিশ, সূজন, পপড়ী যা সফ়েদ দাগ়), চাহে কপড়োং যা ঘরোং মেং ফফূঁদী হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ইন উসূলোং কে তহত ফ়ৈসলা করনা হৈ কি কোঈ শখ়্স যা চীজ় পাক হৈ যা নাপাক।” ");
INSERT INTO urdgvb_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ইসরাঈলিযোং কো বতানা কি অগর কিসী মর্দ কো জরযান কা মরজ় হো তো ৱহ খ়ারিজ হোনেৱালে মাএ কে সবব সে নাপাক হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","চাহে মাএ বহতা রহতা হো যা রুক গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","জিস চীজ় পর ভী মরীজ় লেটতা যা বৈঠতা হৈ ৱহ নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_5‏","004_15_5‏","LEV","15","5‏","6","জো ভী উসকে লেটনে কী জগহ কো ছুএ যা উসকে বৈঠনে কী জগহ পর বৈঠ জাএ ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ইসী তরহ জো ভী ঐসে মরীজ় কো ছুএ ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","অগর মরীজ় কিসী পাক শখ়্স পর থূকে তো যহী কুছ করনা হৈ ঔর ৱহ শখ়্স শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","জব ঐসা মরীজ় কিসী জানৱর পর সৱার হোতা হৈ তো হর চীজ় জিস পর ৱহ বৈঠ জাতা হৈ নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","জো ভী ঐসী চীজ় ছুএ যা উসে উঠাকর লে জাএ ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","জিস কিসী কো ভী মরীজ় অপনে হাথ ধোএ বগ়ৈর ছুএ ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","মিট্টী কা জো বরতন ঐসা মরীজ় ছুএ উসে তোড় দিযা জাএ। লকড়ী কা জো বরতন ৱহ ছুএ উসে খ়ূব ধোযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","জিসে ইস মরজ় সে শফ়া মিলী হৈ ৱহ সাত দিন ইংতজ়ার করে। ইসকে বাদ ৱহ তাজ়া পানী সে অপনে কপড়ে ধোকর নহা লে। ফির ৱহ পাক হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","আঠৱেং দিন ৱহ দো ক়ুম্রিযাঁ যা দো জৱান কবূতর লেকর মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর রব কে সামনে ইমাম কো দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ইমাম উনমেং সে এক কো গুনাহ কী ক়ুরবানী কে তৌর পর ঔর দূসরে কো ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর চঢ়াএ। যোং ৱহ রব কে সামনে উসকা কফ়্ফ়ারা দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","অগর কিসী মর্দ কা নুতফ়া খ়ারিজ হো জাএ তো ৱহ অপনে পূরে জিস্ম কো ধো লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","হর কপড়া যা চমড়া জিসসে নুতফ়া লগ গযা হো উসে ধোনা হৈ। ৱহ ভী শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","অগর মর্দ ঔর ঔরত কে হমবিসতর হোনে পর নুতফ়া খ়ারিজ হো জাএ তো লাজ়িম হৈ কি দোনোং নহা লেং। ৱহ শাম তক নাপাক রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","মাহৱারী কে ৱক়্ত ঔরত সাত দিন তক নাপাক হৈ। জো ভী উসে ছুএ ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ইস দৌরান জিস চীজ় পর ভী ৱহ লেটতী যা বৈঠতী হৈ ৱহ নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_21‏","004_15_21‏","LEV","15","21‏","23","জো ভী উসকে লেটনে কী জগহ কো ছুএ যা উসকে বৈঠনে কী জগহ পর বৈঠ জাএ ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","অগর মর্দ ঔরত সে হমবিসতর হো ঔর উসী ৱক়্ত মাহৱারী কে দিন শুরূ হো জাএঁ তো মর্দ খ়ূন লগনে কে বাইস সাত দিন তক নাপাক রহেগা। জিস চীজ় পর ভী ৱহ লেটতা হৈ ৱহ নাপাক হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","অগর কিসী ঔরত কো মাহৱারী কে দিন ছোড়কর কিসী ঔর ৱক়্ত কঈ দিনোং তক খ়ূন আএ যা খ়ূন মাহৱারী কে দিনোং কে বাদ ভী জারী রহে তো ৱহ মাহৱারী কে দিনোং কী তরহ উস ৱক়্ত তক নাপাক রহেগী জব তক খ়ূন রুক ন জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","জিস চীজ় পর ভী ৱহ লেটতী যা বৈঠতী হৈ ৱহ নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","জো ভী ঐসী চীজ় কো ছুএ ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","খ়ূন কে রুক জানে পর ঔরত মজ়ীদ সাত দিন ইংতজ়ার করে। ফির ৱহ পাক হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","আঠৱেং দিন ৱহ দো ক়ুম্রিযাঁ যা দো জৱান কবূতর লেকর মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর ইমাম কে পাস আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ইমাম উনমেং সে এক কো গুনাহ কী ক়ুরবানী কে লিএ ঔর দূসরে কো ভস্ম হোনেৱালী ক়ুরবানী কে লিএ চঢ়াএ। যোং ৱহ রব কে সামনে উস কী নাপাকী কা কফ়্ফ়ারা দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","লাজ়িম হৈ কি ইসরাঈলিযোং কো ঐসী চীজ়োং সে দূর রখা জাএ জিনসে ৱহ নাপাক হো জাএঁ। ৱরনা মেরা ৱহ মক়দিস জো উনকে দরমিযান হৈ উনসে নাপাক হো জাএগা ঔর ৱহ হলাক হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","লাজ়িম হৈ কি ইস ক়িস্ম কে মামলোং সে ঐসে নিপটো জৈসে বযান কিযা গযা হৈ। ইসমেং ৱহ মর্দ শামিল হৈ জো জরযান কা মরীজ় হৈ ঔর ৱহ জো নুতফ়া খ়ারিজ হোনে কে বাইস নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ইসমেং ৱহ ঔরত ভী শামিল হৈ জিসকে মাহৱারী কে ঐযাম হৈং ঔর ৱহ মর্দ জো নাপাক ঔরত সে হমবিসতর হো জাতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","জব হারূন কে দো বেটে রব কে ক়রীব আকর হলাক হুএ তো ইসকে বাদ রব মূসা সে হমকলাম হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","উসনে কহা, “অপনে ভাঈ হারূন কো বতানা কি ৱহ সির্ফ় মুক়র্ররা ৱক়্ত পর পরদে কে পীছে মুক়দ্দসতরীন কমরে মেং দাখ়িল হোকর অহদ কে সংদূক় কে ঢকনে কে সামনে খড়া হো জাএ, ৱরনা ৱহ মর জাএগা। ক্যোংকি মৈং খ়ুদ উস ঢকনে কে ঊপর বাদল কী সূরত মেং জ়াহির হোতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ঔর জব ভী ৱহ দাখ়িল হো তো গুনাহ কী ক়ুরবানী কে লিএ এক জৱান বৈল ঔর ভস্ম হোনেৱালী ক়ুরবানী কে লিএ এক মেংঢা পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","পহলে ৱহ নহাকর ইমাম কে কতান কে মুক়দ্দস কপড়ে পহন লে যানী জ়েরজামা, উসকে নীচে পাজামা, ফির কমরবংদ ঔর পগড়ী। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ইসরাঈল কী জমাত হারূন কো গুনাহ কী ক়ুরবানী কে লিএ দো বকরে ঔর ভস্ম হোনেৱালী ক়ুরবানী কে লিএ এক মেংঢা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","পহলে হারূন অপনে ঔর অপনে ঘরানে কে লিএ জৱান বৈল কো গুনাহ কী ক়ুরবানী কে তৌর পর চঢ়াএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ফির ৱহ দোনোং বকরোং কো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর রব কে সামনে লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ৱহাঁ ৱহ ক়ুরা ডালকর এক কো রব কে লিএ চুনে ঔর দূসরে কো অজ়াজ়েল কে লিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","জো বকরা রব কে লিএ হৈ উসে ৱহ গুনাহ কী ক়ুরবানী কে তৌর পর পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","দূসরা বকরা জো ক়ুরে কে জ়রীএ অজ়াজ়েল কে লিএ চুনা গযা উসে জ়িংদা হালত মেং রব কে সামনে খড়া কিযা জাএ তাকি ৱহ জমাত কা কফ়্ফ়ারা দে। ৱহাঁ সে উসে রেগিস্তান মেং অজ়াজ়েল কে পাস ভেজা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","লেকিন পহলে হারূন জৱান বৈল কো গুনাহ কী ক়ুরবানী কে তৌর পর চঢ়াকর অপনা ঔর অপনে ঘরানে কা কফ়্ফ়ারা দে। উসে জ়বহ করনে কে বাদ ");
INSERT INTO urdgvb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ৱহ বখ়ূর কী ক়ুরবানগাহ সে জলতে হুএ কোযলোং সে ভরা হুআ বরতন লেকর অপনী দোনোং মুট্ঠিযাঁ বারীক খ়ুশবূদার বখ়ূর সে ভর লে ঔর মুক়দ্দসতরীন কমরে মেং দাখ়িল হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ৱহাঁ ৱহ রব কে হুজ়ূর বখ়ূর কো জলতে হুএ কোযলোং পর ডাল দে। ইসসে পৈদা হোনেৱালা ধুআঁ অহদ কে সংদূক় কা ঢকনা ছুপা দেগা তাকি হারূন মর ন জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","অব ৱহ জৱান বৈল কে খ়ূন মেং সে কুছ লেকর অপনী উঁগলী সে ঢকনে কে সামনেৱালে হিস্সে পর ছিড়কে, ফির কুছ অপনী উঁগলী সে সাত বার উসকে সামনে জ়মীন পর ছিড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ইসকে বাদ ৱহ উস বকরে কো জ়বহ করে জো ক়ৌম কে লিএ গুনাহ কী ক়ুরবানী হৈ। ৱহ উসকা খ়ূন মুক়দ্দসতরীন কমরে মেং লে আএ ঔর উসে বৈল কে খ়ূন কী তরহ অহদ কে সংদূক় কে ঢকনে পর ঔর সাত বার উসকে সামনে জ়মীন পর ছিড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","যোং ৱহ মুক়দ্দসতরীন কমরে কা কফ়্ফ়ারা দেগা জো ইসরাঈলিযোং কী নাপাকিযোং ঔর তমাম গুনাহোং সে মুতঅস্সির হোতা রহতা হৈ। ইসসে ৱহ মুলাক়াত কে পূরে খ়ৈমে কা ভী কফ়্ফ়ারা দেগা জো খ়ৈমাগাহ কে দরমিযান হোনে কে বাইস ইসরাঈলিযোং কী নাপাকিযোং সে মুতঅস্সির হোতা রহতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","জিতনা ৱক়্ত হারূন অপনা, অপনে ঘরানে কা ঔর ইসরাঈল কী পূরী জমাত কা কফ়্ফ়ারা দেনে কে লিএ মুক়দ্দসতরীন কমরে মেং রহেগা ইস দৌরান কিসী দূসরে কো মুলাক়াত কে খ়ৈমে মেং ঠহরনে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ফির ৱহ মুক়দ্দসতরীন কমরে সে নিকলকর খ়ৈমে মেং রব কে সামনে পড়ী ক়ুরবানগাহ কা কফ়্ফ়ারা দে। ৱহ বৈল ঔর বকরে কে খ়ূন মেং সে কুছ লেকর উসে ক়ুরবানগাহ কে চারোং সীংগোং পর লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","কুছ খ়ূন ৱহ অপনী উঁগলী সে সাত বার উস পর ছিড়ক দে। যোং ৱহ উসে ইসরাঈলিযোং কী নাপাকিযোং সে পাক করকে মখ়সূসো-মুক়দ্দস করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","মুক়দ্দসতরীন কমরে, মুলাক়াত কে খ়ৈমে ঔর ক়ুরবানগাহ কা কফ়্ফ়ারা দেনে কে বাদ হারূন জ়িংদা বকরে কো সামনে লাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ৱহ অপনে দোনোং হাথ উসকে সর পর রখে ঔর ইসরাঈলিযোং কে তমাম ক়ুসূর যানী উনকে তমাম জরাযম ঔর গুনাহোং কা ইক়রার করকে উন্হেং বকরে কে সর পর ডাল দে। ফির ৱহ উসে রেগিস্তান মেং ভেজ দে। ইসকে লিএ ৱহ বকরে কো এক আদমী কে সুপুর্দ করে জিসে যহ জ়িম্মাদারী দী গঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","বকরা অপনে আপ পর উনকা তমাম ক়ুসূর উঠাকর কিসী ৱীরান জগহ মেং লে জাএগা। ৱহাঁ সাথৱালা আদমী উসে ছোড় আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ইসকে বাদ হারূন মুলাক়াত কে খ়ৈমে মেং জাএ ঔর কতান কে ৱহ কপড়ে জো উসনে মুক়দ্দসতরীন কমরে মেং দাখ়িল হোনে সে পেশতর পহন লিএ থে উতারকর ৱহীং ছোড় দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ৱহ মুক়দ্দস জগহ পর নহাকর অপনী খ়িদমত কে আম কপড়ে পহন লে। ফির ৱহ বাহর আকর অপনে ঔর অপনী ক়ৌম কে লিএ ভস্ম হোনেৱালী ক়ুরবানী পেশ করে তাকি অপনা ঔর অপনী ক়ৌম কা কফ়্ফ়ারা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ইসকে অলাৱা ৱহ গুনাহ কী ক়ুরবানী কী চরবী ক়ুরবানগাহ পর জলা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","জো আদমী অজ়াজ়েল কে লিএ বকরে কো রেগিস্তান মেং ছোড় আযা হৈ ৱহ অপনে কপড়ে ধোকর নহা লে। ইসকে বাদ ৱহ খ়ৈমাগাহ মেং আ সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","জিস বৈল ঔর বকরে কো গুনাহ কী ক়ুরবানী কে লিএ পেশ কিযা গযা ঔর জিনকা খ়ূন কফ়্ফ়ারা দেনে কে লিএ মুক়দ্দসতরীন কমরে মেং লাযা গযা, লাজ়িম হৈ কি উনকী খালেং, গোশ্ত ঔর গোবর খ়ৈমাগাহ কে বাহর জলা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","যহ চীজ়েং জলানেৱালা বাদ মেং অপনে কপড়ে ধোকর নহা লে। ফির ৱহ খ়ৈমাগাহ মেং আ সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","লাজ়িম হৈ কি সাতৱেং মহীনে কে দসৱেং দিন ইসরাঈলী ঔর উনকে দরমিযান রহনেৱালে পরদেসী অপনী জান কো দুখ দেং ঔর কাম ন করেং। যহ উসূল তুম্হারে লিএ অবদ তক ক়াযম রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ইস দিন তুম্হারা কফ়্ফ়ারা দিযা জাএগা তাকি তুম্হেং পাক কিযা জাএ। তব তুম রব কে সামনে অপনে তমাম গুনাহোং সে পাক ঠহরোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","পূরা দিন আরাম করো ঔর অপনী জান কো দুখ দো। যহ উসূল অবদ তক ক়াযম রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ইস দিন ইমামে-আজ়ম তুম্হারা কফ়্ফ়ারা দে, ৱহ ইমাম জিসে উসকে বাপ কী জগহ মসহ কিযা গযা ঔর ইখ়্তিযার দিযা গযা হৈ। ৱহ কতান কে মুক়দ্দস কপড়ে পহনকর ");
INSERT INTO urdgvb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","মুক়দ্দসতরীন কমরে, মুলাক়াত কে খ়ৈমে, ক়ুরবানগাহ, ইমামোং ঔর জমাত কে তমাম লোগোং কা কফ়্ফ়ারা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","লাজ়িম হৈ কি সাল মেং এক দফ়া ইসরাঈলিযোং কে তমাম গুনাহোং কা কফ়্ফ়ারা দিযা জাএ। যহ উসূল তুম্হারে লিএ অবদ তক ক়াযম রহে।” সব কুছ ৱৈসে হী কিযা গযা জৈসা রব নে মূসা কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“হারূন, উসকে বেটোং ঔর তমাম ইসরাঈলিযোং কো হিদাযত দেনা ");
INSERT INTO urdgvb_vpl VALUES ("LV17_3‏","004_17_3‏","LEV","17","3‏","4","কি জো ভী ইসরাঈলী অপনী গায যা ভেড়-বকরী মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর রব কো ক়ুরবানী কে তৌর পর পেশ ন করে বল্কি খ়ৈমাগাহ কে অংদর যা বাহর কিসী ঔর জগহ পর জ়বহ করে ৱহ খ়ূন বহানে কা ক়ুসূরৱার ঠহরেগা। উসনে খ়ূন বহাযা হৈ, ঔর লাজ়িম হৈ কি উসে উস কী ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ইস হিদাযত কা মক়সদ যহ হৈ কি ইসরাঈলী অব সে অপনী ক়ুরবানিযাঁ খুলে মৈদান মেং জ়বহ ন করেং বল্কি রব কো পেশ করেং। ৱহ অপনে জানৱরোং কো মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর ইমাম কে পাস লাকর উন্হেং রব কো সলামতী কী ক়ুরবানী কে তৌর পর পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ইমাম উনকা খ়ূন মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর কী ক়ুরবানগাহ পর ছিড়কে ঔর উনকী চরবী উস পর জলা দে। ঐসী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","অব সে ইসরাঈলী অপনী ক়ুরবানিযাঁ উন বকরোং কে দেৱতাওং কো পেশ ন করেং জিনকী পৈরৱী করকে উন্হোংনে জ়িনা কিযা হৈ। যহ উনকে লিএ ঔর উনকে বাদ আনেৱালী নসলোং কে লিএ এক দাযমী উসূল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","লাজ়িম হৈ কি হর ইসরাঈলী ঔর তুম্হারে দরমিযান রহনেৱালা পরদেসী অপনী ভস্ম হোনেৱালী ক়ুরবানী যা কোঈ ঔর ক়ুরবানী ");
INSERT INTO urdgvb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর লাকর রব কো পেশ করে। ৱরনা উসে উস কী ক়ৌম মেং সে মিটাযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","খ়ূন খানা বিলকুল মনা হৈ। জো ভী ইসরাঈলী যা তুম্হারে দরমিযান রহনেৱালা পরদেসী খ়ূন খাএ মৈং উসকে খ়িলাফ় হো জাঊঁগা ঔর উসে উস কী ক়ৌম মেং সে মিটা ডালূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ক্যোংকি হর মখ়লূক় কে খ়ূন মেং উস কী জান হৈ। মৈংনে উসে তুম্হেং দে দিযা হৈ তাকি ৱহ ক়ুরবানগাহ পর তুম্হারা কফ়্ফ়ারা দে। ক্যোংকি খ়ূন হী উস জান কে জ়রীএ জো উসমেং হৈ তুম্হারা কফ়্ফ়ারা দেতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ইসলিএ মৈং কহতা হূঁ কি ন কোঈ ইসরাঈলী ন কোঈ পরদেসী খ়ূন খাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","অগর কোঈ ভী ইসরাঈলী যা পরদেসী কিসী জানৱর যা পরিংদে কা শিকার করকে পকড়ে জিসে খানে কী ইজাজ়ত হৈ তো ৱহ উসে জ়বহ করনে কে বাদ উসকা পূরা খ়ূন জ়মীন পর বহনে দে ঔর খ়ূন পর মিট্টী ডালে। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ক্যোংকি হর মখ়লূক় কা খ়ূন উস কী জান হৈ। ইসলিএ মৈংনে ইসরাঈলিযোং কো কহা হৈ কি কিসী ভী মখ়লূক় কা খ়ূন ন খাও। হর মখ়লূক় কা খ়ূন উস কী জান হৈ, ঔর জো ভী উসে খাএ উসে ক়ৌম মেং সে মিটা দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","অগর কোঈ ভী ইসরাঈলী যা পরদেসী ঐসে জানৱর কা গোশ্ত খাএ জো ফ়িতরী তৌর পর মর গযা যা জিসে জংগলী জানৱরোং নে ফাড় ডালা হো তো ৱহ অপনে কপড়ে ধোকর নহা লে। ৱহ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","জো ঐসা নহীং করতা উসে অপনে ক়ুসূর কী সজ়া ভুগতনী পড়েগী।” ");
INSERT INTO urdgvb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ইসরাঈলিযোং কো বতানা কি মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","মিসরিযোং কী তরহ জ়িংদগী ন গুজ়ারনা জিনমেং তুম রহতে থে। মুল্কে-কনান কে লোগোং কী তরহ ভী জ়িংদগী ন গুজ়ারনা জিনকে পাস মৈং তুম্হেং লে জা রহা হূঁ। উনকে রস্মো-রিৱাজ ন অপনানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","মেরে হী অহকাম পর অমল করো ঔর মেরী হিদাযাত কে মুতাবিক় চলো। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","মেরী হিদাযাত ঔর অহকাম কে মুতাবিক় চলনা, ক্যোংকি জো যোং করেগা ৱহ জীতা রহেগা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","তুমমেং সে কোঈ ভী অপনী ক়রীবী রিশ্তেদার সে হমবিসতর ন হো। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","অপনী মাঁ সে হমবিসতর ন হোনা, ৱরনা তেরে বাপ কী বেহুরমতী হো জাএগী। ৱহ তেরী মাঁ হৈ, ইসলিএ উসসে হমবিসতর ন হোনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","অপনে বাপ কী কিসী ভী বীৱী সে হমবিসতর ন হোনা, ৱরনা তেরে বাপ কী বেহুরমতী হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","অপনী বহন সে হমবিসতর ন হোনা, চাহে ৱহ তেরে বাপ যা তেরী মাঁ কী বেটী হো, চাহে ৱহ তেরে হী ঘর মেং যা কহীং ঔর পৈদা হুঈ হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","অপনী পোতী যা নৱাসী সে হমবিসতর ন হোনা, ৱরনা তেরী অপনী বেহুরমতী হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","অপনে বাপ কী বীৱী কী বেটী সে হমবিসতর ন হোনা। ৱহ তেরী বহন হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","অপনী ফূফী সে হমবিসতর ন হোনা। ৱহ তেরে বাপ কী ক়রীবী রিশ্তেদার হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","অপনী খ়ালা সে হমবিসতর ন হোনা। ৱহ তেরী মাঁ কী ক়রীবী রিশ্তেদার হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","অপনে বাপ কে ভাঈ কী বীৱী সে হমবিসতর ন হোনা, ৱরনা তেরে বাপ কে ভাঈ কী বেহুরমতী হো জাএগী। উস কী বীৱী তেরী চচী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","অপনী বহূ সে হমবিসতর ন হোনা। ৱহ তেরে বেটে কী বীৱী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","অপনী ভাবী সে হমবিসতর ন হোনা, ৱরনা তেরে ভাঈ কী বেহুরমতী হো জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","অগর তেরা জিংসী তাল্লুক় কিসী ঔরত সে হো তো উস কী বেটী, পোতী যা নৱাসী সে হমবিসতর হোনা মনা হৈ, ক্যোংকি ৱহ উস কী ক়রীবী রিশ্তেদার হৈং। ঐসা করনা বড়ী শর্মনাক হরকত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","অপনী বীৱী কে জীতে-জী উস কী বহন সে শাদী ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","কিসী ঔরত সে উস কী মাহৱারী কে দিনোং মেং হমবিসতর ন হোনা। ইস দৌরান ৱহ নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","কিসী দূসরে মর্দ কী বীৱী সে হমবিসতর ন হোনা, ৱরনা তূ অপনে আপকো নাপাক করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","অপনে কিসী ভী বচ্চে কো মলিক দেৱতা কো ক়ুরবানী কে তৌর পর পেশ করকে জলা দেনা মনা হৈ। ঐসী হরকত সে তূ অপনে খ়ুদা কে নাম কো দাগ় লগাএগা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","মর্দ দূসরে মর্দ কে সাথ জিংসী তাল্লুক়াত ন রখে। ঐসী হরকত ক়াবিলে-ঘিন হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","কিসী জানৱর সে জিংসী তাল্লুক়াত ন রখনা, ৱরনা তূ নাপাক হো জাএগা। ঔরতোং কে লিএ ভী ঐসা করনা মনা হৈ। যহ বড়ী শর্মনাক হরকত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ঐসী হরকতোং সে অপনে আপকো নাপাক ন করনা। ক্যোংকি জো ক়ৌমেং মৈং তুম্হারে আগে মুল্ক সে নিকালূঁগা ৱহ ইসী তরহ নাপাক হোতী রহীং। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","মুল্ক খ়ুদ ভী নাপাক হুআ। ইসলিএ মৈংনে উসে উসকে ক়ুসূর কে সবব সে সজ়া দী, ঔর নতীজে মেং উসনে অপনে বাশিংদোং কো উগল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","লেকিন তুম মেরী হিদাযাত ঔর অহকাম কে মুতাবিক় চলো। ন দেসী ঔর ন পরদেসী ঐসী কোঈ ঘিনৌনী হরকত করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ক্যোংকি যহ তমাম ক়াবিলে-ঘিন বাতেং উনসে হুঈং জো তুমসে পহলে ইস মুল্ক মেং রহতে থে। যোং মুল্ক নাপাক হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","লিহাজ়া অগর তুম ভী মুল্ক কো নাপাক করোগে তো ৱহ তুম্হেং ইসী তরহ উগল দেগা জিস তরহ উসনে তুমসে পহলে মৌজূদ ক়ৌমোং কো উগল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","জো ভী মজ়কূরা ঘিনৌনী হরকতোং মেং সে এক করে উসে উস কী ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","মেরে অহকাম কে মুতাবিক় চলতে রহো ঔর ঐসে ক়াবিলে-ঘিন রস্মো-রিৱাজ ন অপনানা জো তুম্হারে আনে সে পহলে রাযজ থে। ইনসে অপনে আপকো নাপাক ন করনা। মৈং রব তুম্হারা খ়ুদা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ইসরাঈলিযোং কী পূরী জমাত কো বতানা কি মুক়দ্দস রহো, ক্যোংকি মৈং রব তুম্হারা খ়ুদা ক়ুদ্দূস হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","তুমমেং সে হর এক অপনে মাঁ-বাপ কী ইজ়্জ়ত করে। হফ়তে কে দিন কাম ন করনা। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ন বুতোং কী তরফ় রুজূ করনা, ন অপনে লিএ দেৱতা ঢালনা। মৈং হী রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","জব তুম রব কো সলামতী কী ক়ুরবানী পেশ করতে হো তো উসে যোং চঢ়াও কি তুম মংজ়ূর হো জাও। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","উসকা গোশ্ত উসী দিন যা অগলে দিন খাযা জাএ। জো ভী তীসরে দিন তক বচ জাতা হৈ উসে জলানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","অগর কোঈ উসে তীসরে দিন খাএ তো উসে ইল্ম হোনা চাহিএ কি যহ ক়ুরবানী নাপাক হৈ ঔর রব কো পসংদ নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ঐসে শখ়্স কো অপনে ক়ুসূর কী সজ়া উঠানী পড়েগী, ক্যোংকি উসনে উস চীজ় কী মুক়দ্দস হালত খ়ত্ম কী হৈ জো রব কে লিএ মখ়সূস কী গঈ থী। উসে উস কী ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","কটাঈ কে ৱক়্ত অপনী ফ়সল পূরে তৌর পর ন কাটনা বল্কি খেত কে কিনারোং পর কুছ ছোড় দেনা। ইস তরহ জো কুছ কটাঈ করতে ৱক়্ত খেত মেং বচ জাএ উসে ছোড়না। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","অংগূর কে বাগ়োং মেং ভী জো কুছ অংগূর তোড়তে ৱক়্ত বচ জাএ উসে ছোড় দেনা। জো অংগূর জ়মীন পর গির জাএঁ উন্হেং উঠাকর ন লে জানা। উন্হেং গ়রীবোং ঔর পরদেসিযোং কে লিএ ছোড় দেনা। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","চোরী ন করনা, ঝূট ন বোলনা, এক দূসরে কো ধোকা ন দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","মেরে নাম কী ক়সম খাকর ধোকা ন দেনা, ৱরনা তুম মেরে নাম কো দাগ় লগাওগে। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","এক দূসরে কো ন দবানা ঔর ন লূটনা। কিসী কী মজ়দূরী উসী দিন কী শাম তক দে দেনা ঔর উসে অগলী সুবহ তক রোকে ন রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","বহরে কো ন কোসনা, ন অংধে কে রাস্তে মেং কোঈ চীজ় রখনা জিসসে ৱহ ঠোকর খাএ। ইসমেং ভী অপনে খ়ুদা কা খ়ৌফ় মাননা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","অদালত মেং কিসী কী হক়তলফ়ী ন করনা। ফ়ৈসলা করতে ৱক়্ত কিসী কী ভী জানিবদারী ন করনা, চাহে ৱহ গ়রীব যা অসরো-রসূখ়ৱালা হো। ইনসাফ় সে অপনে পড়োসী কী অদালত কর। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","অপনী ক়ৌম মেং ইধর-উধর ফিরতে হুএ কিসী পর বুহতান ন লগানা। কোঈ ভী ঐসা কাম ন করনা জিসসে কিসী কী জান খ়তরে মেং পড় জাএ। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","দিল মেং অপনে ভাঈ সে নফ়রত ন করনা। অগর কিসী কী সরজ়নিশ করনী হৈ তো রূবরূ করনা, ৱরনা তূ উসকে সবব সে ক়ুসূরৱার ঠহরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ইংতক়াম ন লেনা। অপনী ক়ৌম কে কিসী শখ়্স পর দের তক তেরা গ়ুস্সা ন রহে বল্কি অপনে পড়োসী সে ৱৈসী মুহব্বত রখনা জৈসী তূ অপনে আপসে রখতা হৈ। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","মেরী হিদাযাত পর অমল করো। দো মুখ়্তলিফ় ক়িস্ম কে জানৱরোং কো মিলাপ ন করনে দেনা। অপনে খেত মেং দো ক়িস্ম কে বীজ ন বোনা। ঐসা কপড়া ন পহননা জো দো মুখ়্তলিফ় ক়িস্ম কে ধাগোং কা বুনা হুআ হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","অগর কোঈ আদমী কিসী লৌংডী সে জিসকী মঁগনী কিসী ঔর সে হো চুকী হো হমবিসতর হো জাএ ঔর লৌংডী কো অব তক ন পৈসোং সে ন ৱৈসে হী আজ়াদ কিযা গযা হো তো মুনাসিব সজ়া দী জাএ। লেকিন উন্হেং সজ়াএ-মৌত ন দী জাএ, ক্যোংকি উসে অব তক আজ়াদ নহীং কিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ক়ুসূরৱার আদমী মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর এক মেংঢা লে আএ তাকি ৱহ রব কো ক়ুসূর কী ক়ুরবানী কে তৌর পর পেশ কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ইমাম ইস ক়ুরবানী সে রব কে সামনে উসকে গুনাহ কা কফ়্ফ়ারা দে। যোং উসকা গুনাহ মুআফ় কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","জব মুল্কে-কনান মেং দাখ়িল হোনে কে বাদ তুম ফলদার দরখ়্ত লগাওগে তো পহলে তীন সাল উনকা ফল ন খানা বল্কি উসে মমনূ সমঝনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","চৌথে সাল উনকা তমাম ফল খ়ুশী কে মুক়দ্দস নজ়রানে কে তৌর পর রব কে লিএ মখ়সূস কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","পাঁচৱেং সাল তুম উনকা ফল খা সকতে হো। যোং তুম্হারী ফ়সল বঢ়াঈ জাএগী। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ঐসা গোশ্ত ন খানা জিসমেং খ়ূন হো। ফ়াল যা শুগূন ন নিকালনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","অপনে সর কে বাল গোল শক্ল মেং ন কটৱানা, ন অপনী দাঢ়ী কো তরাশনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","অপনে আপকো মুরদোং কে সবব সে কাটকর জ়খ়মী ন করনা, ন অপনী জিল্দ পর নুক়ূশ গুদৱানা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","অপনী বেটী কো কসবী ন বনানা, ৱরনা উস কী মুক়দ্দস হালত জাতী রহেগী ঔর মুল্ক জ়িনাকারী কে বাইস হরামকারী সে ভর জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","হফ়তে কে দিন আরাম করনা ঔর মেরে মক়দিস কা এহতরাম করনা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ঐসে লোগোং কে পাস ন জানা জো মুরদোং সে রাবিতা করতে হৈং, ন গ়ৈবদানোং কী তরফ় রুজূ করনা, ৱরনা তুম উনসে নাপাক হো জাওগে। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","বূঢ়ে লোগোং কে সামনে উঠকর খড়া হো জানা, বুজ়ুর্গোং কী ইজ়্জ়ত করনা ঔর অপনে খ়ুদা কা এহতরাম করনা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","জো পরদেসী তুম্হারে মুল্ক মেং তুম্হারে দরমিযান রহতা হৈ উসে ন দবানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","উসকে সাথ ঐসা সুলূক কর জৈসা অপনে হমৱতনোং কে সাথ করতা হৈ। জিস তরহ তূ অপনে আপসে মুহব্বত রখতা হৈ উসী তরহ উসসে ভী মুহব্বত রখনা। যাদ রহে কি তুম খ়ুদ মিসর মেং পরদেসী থে। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","নাইনসাফ়ী ন করনা। ন অদালত মেং, ন লংবাঈ নাপতে ৱক়্ত, ন তোলতে ৱক়্ত ঔর ন কিসী চীজ় কী মিক়দার নাপতে ৱক়্ত। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","সহীহ তরাজ়ূ, সহীহ বাট ঔর সহীহ পৈমানা ইস্তেমাল করনা। মৈং রব তুম্হারা খ়ুদা হূঁ জো তুম্হেং মিসর সে নিকাল লাযা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","মেরী তমাম হিদাযাত ঔর তমাম অহকাম মানো ঔর উন পর অমল করো। মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ইসরাঈলিযোং কো বতানা কি তুমমেং সে জো ভী অপনে বচ্চে কো মলিক দেৱতা কো ক়ুরবানী কে তৌর পর পেশ করে উসে সজ়াএ-মৌত দেনী হৈ। ইসমেং কোঈ ফ়রক় নহীং কি ৱহ ইসরাঈলী হৈ যা পরদেসী। জমাত কে লোগ উসে সংগসার করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","মৈং খ়ুদ ঐসে শখ়্স কে খ়িলাফ় হো জাঊঁগা ঔর উসে উস কী ক়ৌম মেং সে মিটা ডালূঁগা। ক্যোংকি অপনে বচ্চোং কো মলিক কো পেশ করনে সে উসনে মেরে মক়দিস কো নাপাক কিযা ঔর মেরে নাম কো দাগ় লগাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","অগর জমাত কে লোগ অপনী আঁখেং বংদ করকে ঐসে শখ়্স কী হরকতেং নজ়রংদাজ় করেং ঔর উসে সজ়াএ-মৌত ন দেং ");
INSERT INTO urdgvb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","তো ফির মৈং খ়ুদ ঐসে শখ়্স ঔর উসকে ঘরানে কে খ়িলাফ় খড়া হো জাঊঁগা। মৈং উসে ঔর উন তমাম লোগোং কো ক়ৌম মেং সে মিটা ডালূঁগা জিন্হোংনে উসকে পীছে লগকর মলিক দেৱতা কো সিজদা করনে সে জ়িনা কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","জো শখ়্স মুরদোং সে রাবিতা করনে ঔর গ়ৈবদানী করনেৱালোং কী তরফ় রুজূ করতা হৈ মৈং উসকে খ়িলাফ় হো জাঊঁগা। উনকী পৈরৱী করনে সে ৱহ জ়িনা করতা হৈ। মৈং উসে উস কী ক়ৌম মেং সে মিটা ডালূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","অপনে আপকো মেরে লিএ মখ়সূসো-মুক়দ্দস রখো, ক্যোংকি মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","মেরী হিদাযাত মানো ঔর উন পর অমল করো। মৈং রব হূঁ জো তুম্হেং মখ়সূসো-মুক়দ্দস করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","জিসনে ভী অপনে বাপ যা মাঁ পর লানত ভেজী হৈ উসে সজ়াএ-মৌত দী জাএ। ইস হরকত সে ৱহ অপনী মৌত কা খ়ুদ জ়িম্মাদার হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","অগর কিসী মর্দ নে কিসী কী বীৱী কে সাথ জ়িনা কিযা হৈ তো দোনোং কো সজ়াএ-মৌত দেনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","জো মর্দ অপনে বাপ কী বীৱী সে হমবিসতর হুআ হৈ উসনে অপনে বাপ কী বেহুরমতী কী হৈ। দোনোং কো সজ়াএ-মৌত দেনী হৈ। ৱহ অপনী মৌত কে খ়ুদ জ়িম্মাদার হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","অগর কোঈ মর্দ অপনী বহূ সে হমবিসতর হুআ হৈ তো দোনোং কো সজ়াএ-মৌত দেনী হৈ। জো কুছ উন্হোংনে কিযা হৈ ৱহ নিহাযত শর্মনাক হৈ। ৱহ অপনী মৌত কে খ়ুদ জ়িম্মাদার হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","অগর কোঈ মর্দ কিসী দূসরে মর্দ সে জিংসী তাল্লুক়াত রখে তো দোনোং কো ইস ঘিনৌনী হরকত কে বাইস সজ়াএ-মৌত দেনী হৈ। ৱহ অপনী মৌত কে খ়ুদ জ়িম্মাদার হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","অগর কোঈ আদমী অপনী বীৱী কে অলাৱা উস কী মাঁ সে ভী শাদী করে তো যহ এক নিহাযত শর্মনাক বাত হৈ। দোনোং কো জলা দেনা হৈ তাকি তুম্হারে দরমিযান কোঈ ঐসী খ়বীস বাত ন রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","জো মর্দ কিসী জানৱর সে জিংসী তাল্লুক়াত রখে উসে সজ়াএ-মৌত দেনা হৈ। উস জানৱর কো ভী মার দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","জো ঔরত কিসী জানৱর সে জিংসী তাল্লুক়াত রখে উসে সজ়াএ-মৌত দেনী হৈ। উস জানৱর কো ভী মার দিযা জাএ। ৱহ অপনী মৌত কে খ়ুদ জ়িম্মাদার হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","জিস মর্দ নে অপনী বহন সে শাদী কী হৈ উসনে শর্মনাক হরকত কী হৈ, চাহে ৱহ বাপ কী বেটী হো যা মাঁ কী। উন্হেং ইসরাঈলী ক়ৌম কী নজ়রোং সে মিটাযা জাএ। ঐসে শখ়্স নে অপনী বহন কী বেহুরমতী কী হৈ। ইসলিএ উসে খ়ুদ অপনে ক়ুসূর কে নতীজে বরদাশ্ত করনে পড়েংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","অগর কোঈ মর্দ মাহৱারী কে ঐযাম মেং কিসী ঔরত সে হমবিসতর হুআ হৈ তো দোনোং কো উনকী ক়ৌম মেং সে মিটানা হৈ। ক্যোংকি দোনোং নে ঔরত কে খ়ূন কে মংবা সে পরদা উঠাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","অপনী খ়ালা যা ফূফী সে হমবিসতর ন হোনা। ক্যোংকি জো ঐসা করতা হৈ ৱহ অপনী ক়রীবী রিশ্তেদার কী বেহুরমতী করতা হৈ। দোনোং কো অপনে ক়ুসূর কে নতীজে বরদাশ্ত করনে পড়েংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","জো অপনী চচী যা তাঈ সে হমবিসতর হুআ হৈ উসনে অপনে চচা যা তাযা কী বেহুরমতী কী হৈ। দোনোং কো অপনে ক়ুসূর কে নতীজে বরদাশ্ত করনে পড়েংগে। ৱহ বেঔলাদ মরেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","জিসনে অপনী ভাবী সে শাদী কী হৈ উসনে এক নজিস হরকত কী হৈ। উসনে অপনে ভাঈ কী বেহুরমতী কী হৈ। ৱহ বেঔলাদ রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","মেরী তমাম হিদাযাত ঔর অহকাম কো মানো ঔর উন পর অমল করো। ৱরনা জিস মুল্ক মেং মৈং তুম্হেং লে জা রহা হূঁ ৱহ তুম্হেং উগল দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","উন ক়ৌমোং কে রস্মো-রিৱাজ কে মুতাবিক় জ়িংদগী ন গুজ়ারনা জিন্হেং মৈং তুম্হারে আগে সে নিকাল দূঁগা। মুঝে ইস সবব সে উনসে ঘিন আনে লগী কি ৱহ যহ সব কুছ করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","লেকিন তুমসে মৈংনে কহা, ‘তুম হী উনকী জ়মীন পর ক়ব্জ়া করোগে। মৈং হী উসে তুম্হেং দে দূঁগা, ঐসা মুল্ক জিসমেং কসরত কা দূধ ঔর শহদ হৈ।’ মৈং রব তুম্হারা খ়ুদা হূঁ, জিসনে তুমকো দীগর ক়ৌমোং মেং সে চুনকর অলগ কর দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ইসলিএ লাজ়িম হৈ কি তুম জ়মীন পর চলনেৱালে জানৱরোং ঔর পরিংদোং মেং পাক ঔর নাপাক কা ইম্তিযাজ় করো। অপনে আপকো নাপাক জানৱর খানে সে ক়াবিলে-ঘিন ন বনানা, চাহে ৱহ জ়মীন পর চলতে যা রেংগতে হৈং, চাহে হৱা মেং উড়তে হৈং। মৈং হী নে উন্হেং তুম্হারে লিএ নাপাক ক়রার দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","তুম্হেং মেরে লিএ মখ়সূসো-মুক়দ্দস হোনা হৈ, ক্যোংকি মৈং ক়ুদ্দূস হূঁ, ঔর মৈংনে তুম্হেং দীগর ক়ৌমোং মেং সে চুনকর অপনে লিএ অলগ কর লিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","তুমমেং সে জো মুরদোং সে রাবিতা যা গ়ৈবদানী করতা হৈ উসে সজ়াএ-মৌত দেনী হৈ, খ়াহ ঔরত হো যা মর্দ। উন্হেং সংগসার করনা। ৱহ অপনী মৌত কে খ়ুদ জ়িম্মাদার হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","রব নে মূসা সে কহা, “হারূন কে বেটোং কো জো ইমাম হৈং বতা দেনা কি ইমাম অপনে আপকো কিসী ইসরাঈলী কী লাশ কে ক়রীব জানে সে নাপাক ন করে ");
INSERT INTO urdgvb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","সিৱাএ অপনে ক়রীবী রিশ্তেদারোং কে যানী মাঁ, বাপ, বেটা, বেটী, ভাঈ ");
INSERT INTO urdgvb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ঔর জো গ়ৈরশাদীশুদা বহন উসকে ঘর মেং রহতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ৱহ অপনী ক়ৌম মেং কিসী ঔর কে বাইস অপনে আপকো নাপাক ন করে, ৱরনা উস কী মুক়দ্দস হালত জাতী রহেগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ইমাম অপনে সর কো ন মুঁডৱাএঁ। ৱহ ন অপনী দাঢ়ী কো তরাশেং ঔর ন কাটনে সে অপনে আপকো জ়খ়মী করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ৱহ অপনে খ়ুদা কে লিএ মখ়সূসো-মুক়দ্দস রহেং ঔর অপনে খ়ুদা কে নাম কো দাগ় ন লগাএঁ। চূঁকি ৱহ রব কো জলনেৱালী ক়ুরবানিযাঁ যানী অপনে খ়ুদা কী রোটী পেশ করতে হৈং ইসলিএ লাজ়িম হৈ কি ৱহ মুক়দ্দস রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ইমাম জ়িনাকার ঔরত, মংদির কী কসবী যা তলাক়যাফ়্তা ঔরত সে শাদী ন করেং, ক্যোংকি ৱহ অপনে রব কে লিএ মখ়সূসো-মুক়দ্দস হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ইমাম কো মুক়দ্দস সমঝনা, ক্যোংকি ৱহ তেরে খ়ুদা কী রোটী কো ক়ুরবানগাহ পর চঢ়াতা হৈ। ৱহ তেরে লিএ মুক়দ্দস ঠহরে ক্যোংকি মৈং রব ক়ুদ্দূস হূঁ। মৈং হী তুম্হেং মুক়দ্দস করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","কিসী ইমাম কী জো বেটী জ়িনাকারী সে অপনী মুক়দ্দস হালত কো খ়ত্ম কর দেতী হৈ ৱহ অপনে বাপ কী মুক়দ্দস হালত কো ভী খ়ত্ম কর দেতী হৈ। উসে জলা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","ইমামে-আজ়ম কে সর পর মসহ কা তেল উংডেলা গযা হৈ ঔর উসে ইমামে-আজ়ম কে মুক়দ্দস কপড়ে পহননে কা ইখ়্তিযার দিযা গযা হৈ। ইসলিএ ৱহ রংজ কে আলম মেং অপনে বালোং কো বিখরনে ন দে, ন কভী অপনে কপড়োং কো ফাড়ে। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ৱহ কিসী লাশ কে ক়রীব ন জাএ, চাহে ৱহ উসকে বাপ যা মাঁ কী লাশ ক্যোং ন হো, ৱরনা ৱহ নাপাক হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","জব তক কোঈ লাশ উসকে ঘর মেং পড়ী রহে ৱহ মক়দিস কো ছোড়কর অপনে ঘর ন জাএ, ৱরনা ৱহ মক়দিস কো নাপাক করেগা। ক্যোংকি উসে উসকে খ়ুদা কে তেল সে মখ়সূস কিযা গযা হৈ। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ইমামে-আজ়ম কো সির্ফ় কুঁৱারী সে শাদী কী ইজাজ়ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ৱহ বেৱা, তলাক়যাফ়্তা ঔরত, মংদির কী কসবী যা জ়িনাকার ঔরত সে শাদী ন করে বল্কি সির্ফ় অপনে ক়বীলে কী কুঁৱারী সে, ");
INSERT INTO urdgvb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ৱরনা উস কী ঔলাদ মখ়সূসো-মুক়দ্দস নহীং হোগী। ক্যোংকি মৈং রব হূঁ জো উসে অপনে লিএ মখ়সূসো-মুক়দ্দস করতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","রব নে মূসা সে যহ ভী কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“হারূন কো বতানা কি তেরী ঔলাদ মেং সে কোঈ ভী জিসকে জিস্ম মেং নুক়্স হো মেরে হুজ়ূর আকর অপনে খ়ুদা কী রোটী ন চঢ়াএ। যহ উসূল আনেৱালী নসলোং কে লিএ ভী অটল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ক্যোংকি কোঈ ভী মাজ়ূর মেরে হুজ়ূর ন আএ, ন অংধা, ন লঁগড়া, ন ৱহ জিসকী নাক চিরী হুঈ হো যা জিসকে কিসী অজ়ু মেং কমী বেশী হো, ");
INSERT INTO urdgvb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ন ৱহ জিসকা পাঁৱ যা হাথ টূটা হুআ হো, ");
INSERT INTO urdgvb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ন কুবড়া, ন বৌনা, ন ৱহ জিসকী আঁখ মেং নুক়্স হো যা জিসে ৱবাঈ জিল্দী বীমারী হো যা জিসকে খ়ুসিযে কুচলে হুএ হোং। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","হারূন ইমাম কী কোঈ ভী ঔলাদ জিসকে জিস্ম মেং নুক়্স হো মেরে হুজ়ূর আকর রব কো জলনেৱালী ক়ুরবানিযাঁ পেশ ন করে। চূঁকি উসমেং নুক়্স হৈ ইসলিএ ৱহ মেরে হুজ়ূর আকর অপনে খ়ুদা কী রোটী ন চঢ়াএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","উসে অল্লাহ কী মুক়দ্দস বল্কি মুক়দ্দসতরীন ক়ুরবানিযোং মেং সে ভী ইমামোং কা হিস্সা খানে কী ইজাজ়ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","লেকিন চূঁকি উসমেং নুক়্স হৈ ইসলিএ ৱহ মুক়দ্দসতরীন কমরে কে দরৱাজ়ে কে পরদে কে ক়রীব ন জাএ, ন ক়ুরবানগাহ কে পাস আএ। ৱরনা ৱহ মেরী মুক়দ্দস চীজ়োং কো নাপাক করেগা। ক্যোংকি মৈং রব হূঁ জো উন্হেং অপনে লিএ মখ়সূসো-মুক়দ্দস করতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","মূসা নে যহ হিদাযাত হারূন, উসকে বেটোং ঔর তমাম ইসরাঈলিযোং কো দীং। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“হারূন ঔর উসকে বেটোং কো বতানা কি ইসরাঈলিযোং কী উন ক়ুরবানিযোং কা এহতরাম করো জো তুমনে মেরে লিএ মখ়সূসো-মুক়দ্দস কী হৈং, ৱরনা তুম মেরে নাম কো দাগ় লগাওগে। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","জো ইমাম নাপাক হোনে কে বাৱুজূদ উন ক়ুরবানিযোং কে পাস আ জাএ জো ইসরাঈলিযোং নে মেরে লিএ মখ়সূসো-মুক়দ্দস কী হৈং উসে মেরে সামনে সে মিটানা হৈ। যহ উসূল আনেৱালী নসলোং কে লিএ ভী অটল হৈ। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","হারূন কী ঔলাদ মেং সে জো ভী ৱবাঈ জিল্দী বীমারী যা জরযান কা মরীজ় হো উসে মুক়দ্দস ক়ুরবানিযোং মেং সে অপনা হিস্সা খানে কী ইজাজ়ত নহীং হৈ। পহলে ৱহ পাক হো জাএ। জো ঐসী কোঈ ভী চীজ় ছুএ জো লাশ সে নাপাক হো গঈ হো যা ঐসে আদমী কো ছুএ জিসকা নুতফ়া নিকলা হো ৱহ নাপাক হো জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ৱহ নাপাক রেংগনেৱালে জানৱর যা নাপাক শখ়্স কো ছূনে সে ভী নাপাক হো জাতা হৈ, খ়াহ ৱহ কিসী ভী সবব সে নাপাক ক্যোং ন হুআ হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","জো ঐসী কোঈ ভী চীজ় ছুএ ৱহ শাম তক নাপাক রহেগা। ইসকে অলাৱা লাজ়িম হৈ কি ৱহ মুক়দ্দস ক়ুরবানিযোং মেং সে অপনা হিস্সা খানে সে পহলে নহা লে। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","সূরজ কে গ়ুরূব হোনে পর ৱহ পাক হোগা ঔর মুক়দ্দস ক়ুরবানিযোং মেং সে অপনা হিস্সা খা সকেগা। ক্যোংকি ৱহ উস কী রোজ়ী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ইমাম ঐসে জানৱরোং কা গোশ্ত ন খাএ জো ফ়িতরী তৌর পর মর গএ যা জিন্হেং জংগলী জানৱরোং নে ফাড় ডালা হো, ৱরনা ৱহ নাপাক হো জাএগা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ইমাম মেরী হিদাযাত কে মুতাবিক় চলেং, ৱরনা ৱহ ক়ুসূরৱার বন জাএংগে ঔর মুক়দ্দস চীজ়োং কী বেহুরমতী করনে কে সবব সে মর জাএংগে। মৈং রব হূঁ জো উন্হেং অপনে লিএ মখ়সূসো-মুক়দ্দস করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","সির্ফ় ইমাম কে খ়ানদান কে অফ়রাদ মুক়দ্দস ক়ুরবানিযোং মেং সে খা সকতে হৈং। গ়ৈরশহরী যা মজ়দূর কো ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","লেকিন ইমাম কা গ়ুলাম যা লৌংডী উসমেং সে খা সকতে হৈং, চাহে উন্হেং খ়রীদা গযা হো যা ৱহ উসকে ঘর মেং পৈদা হুএ হোং। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","অগর ইমাম কী বেটী নে কিসী ঐসে শখ়্স সে শাদী কী হৈ জো ইমাম নহীং হৈ তো উসে মুক়দ্দস ক়ুরবানিযোং মেং সে খানে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","লেকিন হো সকতা হৈ কি ৱহ বেৱা যা তলাক়যাফ়্তা হো ঔর উসকে বচ্চে ন হোং। জব ৱহ অপনে বাপ কে ঘর লৌটকর ৱহাঁ ঐসে রহেগী জৈসে অপনী জৱানী মেং তো ৱহ অপনে বাপ কে উস খানে মেং সে খা সকতী হৈ জো ক়ুরবানিযোং মেং সে বাপ কা হিস্সা হৈ। লেকিন জো ইমাম কে খ়ানদান কা ফ়রদ নহীং হৈ উসে খানে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","জিস শখ়্স নে নাদানিস্তা তৌর পর মুক়দ্দস ক়ুরবানিযোং মেং সে ইমাম কে হিস্সে সে কুছ খাযা হৈ ৱহ ইমাম কো সব কুছ ৱাপস করনে কে অলাৱা 20 ফ়ীসদ জ়্যাদা দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ইমাম রব কো পেশ কী হুঈ ক়ুরবানিযোং কী মুক়দ্দস হালত যোং খ়ত্ম ন করেং ");
INSERT INTO urdgvb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","কি ৱহ দূসরে ইসরাঈলিযোং কো যহ মুক়দ্দস চীজ়েং খানে দেং। ঐসী হরকত সে ৱহ উনকো বড়া ক়ুসূরৱার বনা দেংগে। মৈং রব হূঁ জো উন্হেং অপনে লিএ মখ়সূসো-মুক়দ্দস করতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“হারূন, উসকে বেটোং ঔর ইসরাঈলিযোং কো বতানা কি অগর তুমমেং সে কোঈ ইসরাঈলী যা পরদেসী রব কো ভস্ম হোনেৱালী ক়ুরবানী পেশ করনা চাহে তো তরীক়ে-কার মেং কোঈ ফ়রক় নহীং হৈ, চাহে ৱহ যহ মন্নত মানকর যা ৱৈসে হী দিলী খ়ুশী সে কর রহা হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ইসকে লিএ লাজ়িম হৈ কি তুম এক বেঐব বৈল, মেংঢা যা বকরা পেশ করো। ফির হী উসে ক়বূল কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ক়ুরবানী কে লিএ কভী ভী ঐসা জানৱর পেশ ন করনা জিসমেং নুক়্স হো, ৱরনা তুম উসকে বাইস মংজ়ূর নহীং হোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","অগর কোঈ রব কো সলামতী কী ক়ুরবানী পেশ করনা চাহে তো তরীক়ে-কার মেং কোঈ ফ়রক় নহীং হৈ, চাহে ৱহ যহ মন্নত মানকর যা ৱৈসে হী দিলী খ়ুশী সে কর রহা হো। ইসকে লিএ লাজ়িম হৈ কি ৱহ গায-বৈলোং যা ভেড়-বকরিযোং মেং সে বেঐব জানৱর চুনে। ফির উসে ক়বূল কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","রব কো ঐসে জানৱর পেশ ন করনা জো অংধে হোং, জিনকে আজ়া টূটে যা কটে হুএ হোং, জিনকো রসৌলী হো যা জিন্হেং ৱবাঈ জিল্দী বীমারী লগ গঈ হো। রব কো উন্হেং জলনেৱালী ক়ুরবানী কে তৌর পর ক়ুরবানগাহ পর পেশ ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","লেকিন জিস গায-বৈল যা ভেড়-বকরী কে কিসী অজ়ু মেং কমী বেশী হো উসে পেশ কিযা জা সকতা হৈ। শর্ত যহ হৈ কি পেশ করনেৱালা উসে ৱৈসে হী দিলী খ়ুশী সে চঢ়াএ। অগর ৱহ উসে অপনী মন্নত মানকর পেশ করে তো ৱহ ক়বূল নহীং কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","রব কো ঐসা জানৱর পেশ ন করনা জিসকে খ়ুসিযে কুচলে, তোড়ে যা কটে হুএ হোং। অপনে মুল্ক মেং জানৱরোং কো ইস তরহ খ়সী ন বনানা, ");
INSERT INTO urdgvb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ন ঐসে জানৱর কিসী গ়ৈরমুল্কী সে খ়রীদকর অপনে খ়ুদা কী রোটী কে তৌর পর পেশ করনা। তুম ঐসে জানৱরোং কে বাইস মংজ়ূর নহীং হোগে, ক্যোংকি উনমেং খ়রাবী ঔর নুক়্স হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","রব নে মূসা সে যহ ভী কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“জব কিসী গায, ভেড় যা বকরী কা বচ্চা পৈদা হোতা হৈ তো লাজ়িম হৈ কি ৱহ পহলে সাত দিন অপনী মাঁ কে পাস রহে। আঠৱেং দিন সে পহলে রব উসে জলনেৱালী ক়ুরবানী কে তৌর পর ক়বূল নহীং করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","কিসী গায, ভেড় যা বকরী কে বচ্চে কো উস কী মাঁ সমেত এক হী দিন জ়বহ ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","জব তুম রব কো সলামতী কী কোঈ ক়ুরবানী চঢ়ানা চাহতে হো তো উসে যোং পেশ করনা কি তুম মংজ়ূর হো জাও। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","অগলী সুবহ তক কুছ বচা ন রহে বল্কি উসে উসী দিন খানা হৈ। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","মেরে অহকাম মানো ঔর উন পর অমল করো। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","মেরে নাম কো দাগ় ন লগানা। লাজ়িম হৈ কি মুঝে ইসরাঈলিযোং কে দরমিযান ক়ুদ্দূস মানা জাএ। মৈং রব হূঁ জো তুম্হেং অপনে লিএ মখ়সূসো-মুক়দ্দস করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","মৈং তুম্হেং মিসর সে নিকাল লাযা হূঁ তাকি তুম্হারা খ়ুদা হূঁ। মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ইসরাঈলিযোং কো বতানা কি যহ মেরী, রব কী ঈদেং হৈং জিন পর তুম্হেং লোগোং কো মুক়দ্দস ইজতিমা কে লিএ জমা করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","হফ়তে মেং ছঃ দিন কাম করনা, লেকিন সাতৱাঁ দিন হর তরহ সে আরাম কা দিন হৈ। উস দিন মুক়দ্দস ইজতিমা হো। জহাঁ ভী তুম রহতে হো ৱহাঁ কাম ন করনা। যহ দিন রব কে লিএ মখ়সূস সবত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","যহ রব কী ঈদেং হৈং জিন পর তুম্হেং লোগোং কো মুক়দ্দস ইজতিমা কে লিএ জমা করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ফ়সহ কী ঈদ পহলে মহীনে কে চৌধৱেং দিন শুরূ হোতী হৈ। উস দিন সূরজ কে গ়ুরূব হোনে পর রব কী খ়ুশী মনাঈ জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","অগলে দিন রব কী যাদ মেং বেখ়মীরী রোটী কী ঈদ শুরূ হোতী হৈ। সাত দিন তক তুম্হারী রোটী মেং খ়মীর ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ইন সাত দিনোং কে পহলে দিন মুক়দ্দস ইজতিমা হো ঔর লোগ অপনা হর কাম ছোড়েং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ইন সাত দিনোং মেং রোজ়ানা রব কো জলনেৱালী ক়ুরবানী পেশ করো। সাতৱেং দিন ভী মুক়দ্দস ইজতিমা হো ঔর লোগ অপনা হর কাম ছোড়েং।” ");
INSERT INTO urdgvb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ইসরাঈলিযোং কো বতানা কি জব তুম উস মুল্ক মেং দাখ়িল হোগে জো মৈং তুম্হেং দূঁগা ঔর ৱহাঁ অনাজ কী ফ়সল কাটোগে তো তুম্হেং ইমাম কো পহলা পূলা দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ইতৱার কো ইমাম যহ পূলা রব কে সামনে হিলাএ তাকি তুম মংজ়ূর হো জাও। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","উস দিন ভেড় কা এক যকসালা বেঐব বচ্চা ভী রব কো পেশ করনা। উসে ক়ুরবানগাহ পর ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর চঢ়ানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","সাথ হী গ়ল্লা কী নজ়র কে লিএ তেল সে মিলাযা গযা 3 কিলোগ্রাম বেহতরীন মৈদা ভী পেশ করনা। জলনেৱালী যহ ক়ুরবানী রব কো পসংদ হৈ। ইসকে অলাৱা মৈ কী নজ়র কে লিএ এক লিটর মৈ ভী পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","পহলে যহ সব কুছ করো, ফির হী তুম্হেং নঈ ফ়সল কে অনাজ সে খানে কী ইজাজ়ত হোগী, খ়াহ ৱহ ভুনা হুআ হো, খ়াহ কচ্চা যা রোটী কী সূরত মেং পকাযা গযা হো। জহাঁ ভী তুম রহতে হো ৱহাঁ ঐসা হী করনা হৈ। যহ উসূল অবদ তক ক়াযম রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","জিস দিন তুমনে অনাজ কা পূলা পেশ কিযা উস দিন সে পূরে সাত হফ়তে গিনো। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","পচাসৱেং দিন যানী সাতৱেং ইতৱার কো রব কো নএ অনাজ কী ক়ুরবানী চঢ়ানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","হর ঘরানে কী তরফ় সে রব কো হিলানেৱালী ক়ুরবানী কে তৌর পর দো রোটিযাঁ পেশ কী জাএঁ। হর রোটী কে লিএ 3 কিলোগ্রাম বেহতরীন মৈদা ইস্তেমাল কিযা জাএ। উনমেং খ়মীর ডালকর পকানা হৈ। যহ ফ়সল কী পহলী পৈদাৱার কী ক়ুরবানী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ইন রোটিযোং কে সাথ এক জৱান বৈল, দো মেংঢে ঔর ভেড় কে সাত বেঐব ঔর যকসালা বচ্চে পেশ করো। উন্হেং রব কে হুজ়ূর ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর চঢ়ানা। ইসকে অলাৱা গ়ল্লা কী নজ়র ঔর মৈ কী নজ়র ভী পেশ করনী হৈ। জলনেৱালী ইস ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ফির গুনাহ কী ক়ুরবানী কে লিএ এক বকরা ঔর সলামতী কী ক়ুরবানী কে লিএ দো যকসালা ভেড় কে বচ্চে চঢ়াও। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ইমাম ভেড় কে যহ দো বচ্চে মজ়কূরা রোটিযোং সমেত হিলানেৱালী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাএ। যহ রব কে লিএ মখ়সূসো-মুক়দ্দস হৈং ঔর ক়ুরবানিযোং মেং সে ইমাম কা হিস্সা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","উসী দিন লোগোং কো মুক়দ্দস ইজতিমা কে লিএ জমা করো। কোঈ ভী কাম ন করনা। যহ উসূল অবদ তক ক়াযম রহে, ঔর ইসে হর জগহ মাননা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","কটাঈ কে ৱক়্ত অপনী ফ়সল পূরে তৌর পর ন কাটনা বল্কি খেত কে কিনারোং পর কুছ ছোড় দেনা। ইস তরহ জো কুছ কটাঈ করতে ৱক়্ত খেত মেং বচ জাএ উসে ছোড়না। বচা হুআ অনাজ গ়রীবোং ঔর পরদেসিযোং কে লিএ ছোড় দেনা। মৈং রব তুম্হারা খ়ুদা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ইসরাঈলিযোং কো বতানা কি সাতৱেং মহীনে কা পহলা দিন আরাম কা দিন হৈ। উস দিন মুক়দ্দস ইজতিমা হো জিস পর যাদ দিলানে কে লিএ নরসিংগা ফূঁকা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","কোঈ ভী কাম ন করনা। রব কো জলনেৱালী ক়ুরবানী পেশ করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“সাতৱেং মহীনে কা দসৱাঁ দিন কফ়্ফ়ারা কা দিন হৈ। উস দিন মুক়দ্দস ইজতিমা হো। অপনী জান কো দুখ দেনা ঔর রব কো জলনেৱালী ক়ুরবানী পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","উস দিন কাম ন করনা, ক্যোংকি যহ কফ়্ফ়ারা কা দিন হৈ, জব রব তুম্হারে খ়ুদা কে সামনে তুম্হারা কফ়্ফ়ারা দিযা জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","জো উস দিন অপনী জান কো দুখ নহীং দেতা উসে উস কী ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","জো উস দিন কাম করতা হৈ উসে মৈং উস কী ক়ৌম মেং সে নিকালকর হলাক করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","কোঈ ভী কাম ন করনা। যহ উসূল অবদ তক ক়াযম রহে, ঔর ইসে হর জগহ মাননা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","যহ দিন আরাম কা খ়াস দিন হৈ জিসমেং তুম্হেং অপনী জান কো দুখ দেনা হৈ। ইসে মহীনে কে নৱেং দিন কী শাম সে লেকর অগলী শাম তক মনানা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ইসরাঈলিযোং কো বতানা কি সাতৱেং মহীনে কে পংদ্রহৱেং দিন ঝোংপড়িযোং কী ঈদ শুরূ হোতী হৈ। ইসকা দৌরানিযা সাত দিন হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","পহলে দিন মুক়দ্দস ইজতিমা হো। ইস দিন কোঈ কাম ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ইন সাত দিনোং কে দৌরান রব কো জলনেৱালী ক়ুরবানিযাঁ পেশ করনা। আঠৱেং দিন মুক়দ্দস ইজতিমা হো। রব কো জলনেৱালী ক়ুরবানী পেশ করো। ইস খ়াস ইজতিমা কে দিন ভী কাম নহীং করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","যহ রব কী ঈদেং হৈং জিন পর তুম্হেং মুক়দ্দস ইজতিমা করনা হৈ তাকি রব কো রোজ়মর্রা কী মতলূবা জলনেৱালী ক়ুরবানিযাঁ ঔর মৈ কী নজ়রেং পেশ কী জাএঁ যানী ভস্ম হোনেৱালী ক়ুরবানিযাঁ, গ়ল্লা কী নজ়রেং, জ়বহ কী ক়ুরবানিযাঁ ঔর মৈ কী নজ়রেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","যহ ক়ুরবানিযাঁ উন ক়ুরবানিযোং কে অলাৱা হৈং জো সবত কে দিন চঢ়াঈ জাতী হৈং ঔর জো তুমনে হদিযে কে তৌর পর যা মন্নত মানকর যা অপনী দিলী খ়ুশী সে পেশ কী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","চুনাঁচে সাতৱেং মহীনে কে পংদ্রহৱেং দিন ফ়সল কী কটাঈ কে ইখ়্তিতাম পর রব কী যহ ঈদ যানী ঝোংপড়িযোং কী ঈদ মনাও। ইসে সাত দিন মনানা। পহলা ঔর আখ়িরী দিন আরাম কে দিন হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","পহলে দিন অপনে লিএ দরখ়্তোং কে বেহতরীন ফল, খজূর কী ডালিযাঁ ঔর ঘনে দরখ়্তোং ঔর সফ়েদা কী শাখ়েং তোড়না। সাত দিন তক রব অপনে খ়ুদা কে সামনে খ়ুশী মনাও। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","হর সাল সাতৱেং মহীনে মেং রব কী খ়ুশী মেং যহ ঈদ মনানা। যহ উসূল অবদ তক ক়াযম রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ঈদ কে হফ়তে কে দৌরান ঝোংপড়িযোং মেং রহনা। তমাম মুল্ক মেং আবাদ ইসরাঈলী ঐসা করেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ফির তুম্হারী ঔলাদ জানেগী কি ইসরাঈলিযোং কো মিসর সে নিকালতে ৱক়্ত মৈংনে উন্হেং ঝোংপড়িযোং মেং বসাযা। মৈং রব তুম্হারা খ়ুদা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","মূসা নে ইসরাঈলিযোং কো রব কী ঈদোং কে বারে মেং যহ বাতেং বতাঈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ইসরাঈলিযোং কো হুক্ম দে কি ৱহ তেরে পাস কূটে হুএ জ়ৈতূনোং কা খ়ালিস তেল লে আএঁ তাকি মুক়দ্দস কমরে কে শমাদান কে চরাগ় মুতৱাতির জলতে রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","হারূন উন্হেং মুসলসল, শাম সে লেকর সুবহ তক রব কে হুজ়ূর সঁভালে যানী ৱহাঁ জহাঁ ৱহ মুক়দ্দসতরীন কমরে কে পরদে কে সামনে পড়ে হৈং, উস পরদে কে সামনে জিসকে পীছে অহদ কা সংদূক় হৈ। যহ উসূল অবদ তক ক়াযম রহে। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ৱহ খ়ালিস সোনে কে শমাদান পর লগে চরাগ়োং কী দেখ-ভাল যোং করে কি যহ হমেশা রব কে সামনে জলতে রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","বারহ রোটিযাঁ পকানা। হর রোটী কে লিএ 3 কিলোগ্রাম বেহতরীন মৈদা ইস্তেমাল কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","উন্হেং দো ক়তারোং মেং রব কে সামনে খ়ালিস সোনে কী মেজ় পর রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","হর ক়তার পর খ়ালিস লুবান ডালনা। যহ লুবান রোটী কে লিএ যাদগারী কী ক়ুরবানী হৈ জিসে বাদ মেং রব কে লিএ জলানা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","হর হফ়তে কো রব কে সামনে তাজ়া রোটিযাঁ ইসী তরতীব সে মেজ় পর রখনী হৈং। যহ ইসরাঈলিযোং কে লিএ অবদী অহদ কী লাজ়িমী শর্ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","মেজ় কী রোটিযাঁ হারূন ঔর উসকে বেটোং কা হিস্সা হৈং, ঔর ৱহ উন্হেং মুক়দ্দস জগহ পর খাএঁ, ক্যোংকি ৱহ জলনেৱালী ক়ুরবানিযোং কা মুক়দ্দসতরীন হিস্সা হৈং। যহ অবদ তক উনকা হক় রহেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV24_10‏","004_24_10‏","LEV","24","10‏","11","খ়ৈমাগাহ মেং এক আদমী থা জিসকা বাপ মিসরী ঔর মাঁ ইসরাঈলী থী। মাঁ কা নাম সলূমীত থা। ৱহ দিবরী কী বেটী ঔর দান কে ক়বীলে কী থী। এক দিন যহ আদমী খ়ৈমাগাহ মেং কিসী ইসরাঈলী সে ঝগড়নে লগা। লড়তে লড়তে উসনে রব কে নাম পর কুফ়র বককর উস পর লানত ভেজী। যহ সুনকর লোগ উসে মূসা কে পাস লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ৱহাঁ উন্হোংনে উসে পহরে মেং বিঠাকর রব কী হিদাযত কা ইংতজ়ার কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","তব রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“লানত করনেৱালে কো খ়ৈমাগাহ কে বাহর লে জাও। জিন্হোংনে উস কী যহ বাতেং সুনী হৈং ৱহ সব অপনে হাথ উসকে সর পর রখেং। ফির পূরী জমাত উসে সংগসার করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ইসরাঈলিযোং সে কহনা কি জো ভী অপনে খ়ুদা পর লানত ভেজে উসে অপনে ক়ুসূর কে নতীজে বরদাশ্ত করনে পড়েংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","জো ভী রব কে নাম পর কুফ়র বকে উসে সজ়াএ-মৌত দী জাএ। পূরী জমাত উসে সংগসার করে। জিসনে রব কে নাম পর কুফ়র বকা হো উসে জ়রূর সজ়াএ-মৌত দেনী হৈ, খ়াহ দেসী হো যা পরদেসী। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","জিসনে কিসী কো মার ডালা হৈ উসে সজ়াএ-মৌত দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","জিসনে কিসী কে জানৱর কো মার ডালা হৈ ৱহ উসকা মুআৱজ়া দে। জান কে বদলে জান দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","অগর কিসী নে কিসী কো জ়খ়মী কর দিযা হৈ তো ৱহী কুছ উসকে সাথ কিযা জাএ জো উসনে দূসরে কে সাথ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","অগর দূসরে কী কোঈ হড্ডী টূট জাএ তো উস কী ৱহী হড্ডী তোড়ী জাএ। অগর দূসরে কী আঁখ জ়াযা হো জাএ তো উস কী আঁখ জ়াযা কর দী জাএ। অগর দূসরে কা দাঁত টূট জাএ তো উসকা ৱহী দাঁত তোড়া জাএ। জো ভী জ়খ়ম উসনে দূসরে কো পহুঁচাযা ৱহী জ়খ়ম উসে পহুঁচাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","জিসনে কিসী জানৱর কো মার ডালা হৈ ৱহ উসকা মুআৱজ়া দে, লেকিন জিসনে কিসী ইনসান কো মার দিযা হৈ উসে সজ়াএ-মৌত দেনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","দেসী ঔর পরদেসী কে লিএ তুম্হারা এক হী ক়ানূন হো। মৈং রব তুম্হারা খ়ুদা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ফির মূসা নে ইসরাঈলিযোং সে বাত কী, ঔর উন্হোংনে রব পর লানত ভেজনেৱালে কো খ়ৈমাগাহ সে বাহর লে জাকর উসে সংগসার কিযা। উন্হোংনে ৱৈসা হী কিযা জৈসা রব নে মূসা কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","রব নে সীনা পহাড় পর মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ইসরাঈলিযোং কো বতানা কি জব তুম উস মুল্ক মেং দাখ়িল হোগে জো মৈং তুম্হেং দূঁগা তো লাজ়িম হৈ কি রব কী তাজ়ীম মেং জ়মীন এক সাল আরাম করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ছঃ সাল কে দৌরান অপনে খেতোং মেং বীজ বোনা, অপনে অংগূর কে বাগ়োং কী কাঁট-ছাঁট করনা ঔর উনকী ফ়সলেং জমা করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","লেকিন সাতৱাঁ সাল জ়মীন কে লিএ আরাম কা সাল হৈ, রব কী তাজ়ীম মেং সবত কা সাল। উস সাল ন অপনে খেতোং মেং বীজ বোনা, ন অপনে অংগূর কে বাগ়োং কী কাঁট-ছাঁট করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","জো অনাজ খ়ুদ বখ়ুদ উগতা হৈ উস কী কটাঈ ন করনা ঔর জো অংগূর উস সাল লগতে হৈং উনকো তোড়কর জমা ন করনা, ক্যোংকি জ়মীন কো এক সাল কে লিএ আরাম করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","অলবত্তা জো ভী যহ জ়মীন আরাম কে সাল মেং পৈদা করেগী উসসে তুম অপনী রোজ়ানা কী জ়রূরিযাত পূরী কর সকতে হো যানী তূ, তেরে গ়ুলাম ঔর লৌংডিযাঁ, তেরে মজ়দূর, তেরে গ়ৈরশহরী, তেরে সাথ রহনেৱালে পরদেসী, ");
INSERT INTO urdgvb_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","তেরে মৱেশী ঔর তেরী জ়মীন পর রহনেৱালে জংগলী জানৱর। জো কুছ ভী যহ জ়মীন পৈদা করতী হৈ ৱহ খাযা জা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","সাত সবত কে সাল যানী 49 সাল কে বাদ এক ঔর কাম করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","পচাসৱেং সাল কে সাতৱেং মহীনে কে দসৱেং দিন যানী কফ়্ফ়ারা কে দিন অপনে মুল্ক কী হর জগহ নরসিংগা বজানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","পচাসৱাঁ সাল মখ়সূসো-মুক়দ্দস করো ঔর পূরে মুল্ক মেং এলান করো কি তমাম বাশিংদোং কো আজ়াদ কর দিযা জাএ। যহ বহালী কা সাল হো জিসমেং হর শখ়্স কো উস কী মিলকিযত ৱাপস কী জাএ ঔর হর গ়ুলাম কো আজ়াদ কিযা জাএ তাকি ৱহ অপনে রিশ্তেদারোং কে পাস ৱাপস জা সকে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","যহ পচাসৱাঁ সাল বহালী কা সাল হো, ইসলিএ ন অপনে খেতোং মেং বীজ বোনা, ন খ়ুদ বখ়ুদ উগনেৱালে অনাজ কী কটাঈ করনা, ঔর ন অংগূর তোড়কর জমা করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ক্যোংকি যহ বহালী কা সাল হৈ জো তুম্হারে লিএ মখ়সূসো-মুক়দ্দস হৈ। রোজ়ানা উতনী হী পৈদাৱার লেনা কি এক দিন কী জ়রূরিযাত পূরী হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","বহালী কে সাল মেং হর শখ়্স কো উস কী মিলকিযত ৱাপস কী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","চুনাঁচে জব কভী তুম অপনে কিসী হমৱতন ভাঈ কো জ়মীন বেচতে যা উসসে খ়রীদতে হো তো উসসে নাজাযজ় ফ়াযদা ন উঠানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","জ়মীন কী ক়ীমত ইস হিসাব সে মুক়র্রর কী জাএ কি ৱহ অগলে বহালী কে সাল তক কিতনে সাল ফ়সলেং পৈদা করেগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","অগর বহুত সাল রহ গএ হোং তো উস কী ক়ীমত জ়্যাদা হোগী, ঔর অগর কম সাল রহ গএ হোং তো উস কী ক়ীমত কম হোগী। ক্যোংকি উন ফ়সলোং কী তাদাদ বিক রহী হৈ জো জ়মীন অগলে বহালী কে সাল তক পৈদা কর সকতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","অপনে হমৱতন সে নাজাযজ় ফ়াযদা ন উঠানা বল্কি রব অপনে খ়ুদা কা খ়ৌফ় মাননা, ক্যোংকি মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","মেরী হিদাযাত পর অমল করনা ঔর মেরে অহকাম কো মানকর উনকে মুতাবিক় চলনা। তব তুম অপনে মুল্ক মেং মহফ়ূজ় রহোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","জ়মীন অপনী পূরী পৈদাৱার দেগী, তুম সের হো জাওগে ঔর মহফ়ূজ় রহোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","হো সকতা হৈ কোঈ পূছে, ‘হম সাতৱেং সাল মেং ক্যা খাএঁগে জবকি হম বীজ নহীং বোএঁগে ঔর ফ়সল নহীং কাটেংগে?’ ");
INSERT INTO urdgvb_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","জৱাব যহ হৈ কি মৈং ছটে সাল মেং জ়মীন কো ইতনী বরকত দূঁগা কি উস সাল কী পৈদাৱার তীন সাল কে লিএ কাফ়ী হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","জব তুম আঠৱেং সাল বীজ বোওগে তো তুম্হারে পাস ছটে সাল কী ইতনী পৈদাৱার বাক়ী হোগী কি তুম ফ়সল কী কটাঈ তক গুজ়ারা কর সকোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","কোঈ জ়মীন ভী হমেশা কে লিএ ন বেচী জাএ, ক্যোংকি মুল্ক কী তমাম জ়মীন মেরী হী হৈ। তুম মেরে হুজ়ূর সির্ফ় পরদেসী ঔর গ়ৈরশহরী হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","মুল্ক মেং জহাঁ ভী জ়মীন বিক জাএ ৱহাঁ মৌরূসী মালিক কা যহ হক় মানা জাএ কি ৱহ অপনী জ়মীন ৱাপস খ়রীদ সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","অগর তেরা কোঈ হমৱতন ভাঈ গ়রীব হোকর অপনী কুছ জ়মীন বেচনে পর মজবূর হো জাএ তো লাজ়িম হৈ কি উসকা সবসে ক়রীবী রিশ্তেদার উসে ৱাপস খ়রীদ লে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","হো সকতা হৈ কি ঐসে শখ়্স কা কোঈ ক়রীবী রিশ্তেদার ন হো জো উস কী জ়মীন ৱাপস খ়রীদ সকে, লেকিন ৱহ খ়ুদ কুছ দের কে বাদ ইতনে পৈসে জমা করতা হৈ কি ৱহ অপনী জ়মীন ৱাপস খ়রীদ সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ইস সূরত মেং ৱহ হিসাব করে কি খ়রীদনেৱালে কে লিএ অগলে বহালী কে সাল তক কিতনে সাল রহ গএ হৈং। জিতনা নুক়সান খ়রীদনেৱালে কো জ়মীন কো বহালী কে সাল সে পহলে ৱাপস দেনে সে পহুঁচেগা উতনে হী পৈসে উসে দেনে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","লেকিন অগর উসকে পাস ইতনে পৈসে ন হোং তো জ়মীন অগলে বহালী কে সাল তক খ়রীদনেৱালে কে হাথ মেং রহেগী। ফির উসে মৌরূসী মালিক কো ৱাপস দিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","অগর কিসী কা ঘর ফ়সীলদার শহর মেং হৈ তো জব ৱহ উসে বেচেগা তো অপনা ঘর ৱাপস খ়রীদনে কা হক় সির্ফ় এক সাল তক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","অগর পহলা মালিক উসে পহলে সাল কে অংদর অংদর ন খ়রীদে তো ৱহ হমেশা কে লিএ খ়রীদনেৱালে কী মৌরূসী মিলকিযত বন জাএগা। ৱহ বহালী কে সাল মেং ভী ৱাপস নহীং কিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","লেকিন জো ঘর ঐসী আবাদী মেং হৈ জিসকী ফ়সীল ন হো ৱহ দেহাত মেং শুমার কিযা জাতা হৈ। উসকে মৌরূসী মালিক কো হক় হাসিল হৈ কি হর ৱক়্ত অপনা ঘর ৱাপস খ়রীদ সকে। বহালী কে সাল মেং ইস ঘর কো লাজ়িমন ৱাপস কর দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","লেকিন লাৱিযোং কো যহ হক় হাসিল হৈ কি ৱহ অপনে ৱহ ঘর হর ৱক়্ত খ়রীদ সকতে হৈং জো উনকে লিএ মুক়র্রর কিএ হুএ শহরোং মেং হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","অগর ঐসা ঘর কিসী লাৱী কে হাথ ফ়রোখ়্ত কিযা জাএ ঔর ৱাপস ন খ়রীদা জাএ তো উসে লাজ়িমন বহালী কে সাল মেং ৱাপস করনা হৈ। ক্যোংকি লাৱী কে জো ঘর উনকে মুক়র্ররা শহরোং মেং হোতে হৈং ৱহ ইসরাঈলিযোং মেং উনকী মৌরূসী মিলকিযত হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","লেকিন জো জ়মীনেং শহরোং কে ইর্দগির্দ মৱেশী চরানে কে লিএ মুক়র্রর হৈং উন্হেং বেচনে কী ইজাজ়ত নহীং হৈ। ৱহ উনকী দাযমী মিলকিযত হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","অগর তেরা কোঈ হমৱতন ভাঈ গ়রীব হো জাএ ঔর গুজ়ারা ন কর সকে তো উস কী মদদ কর। উস তরহ উস কী মদদ করনা জিস তরহ পরদেসী যা গ়ৈরশহরী কী মদদ করনী হোতী হৈ তাকি ৱহ তেরে সাথ রহতে হুএ জ়িংদগী গুজ়ার সকে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","উসসে কিসী তরহ কা সূদ ন লেনা বল্কি অপনে খ়ুদা কা খ়ৌফ় মাননা তাকি তেরা ভাঈ তেরে সাথ জ়িংদগী গুজ়ার সকে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","অগর ৱহ তেরা ক়র্জ়দার হো তো উসসে সূদ ন লেনা। ইসী তরহ খ়ুরাক বেচতে ৱক়্ত উসসে নফ়া ন লেনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","মৈং রব তুম্হারা খ়ুদা হূঁ। মৈং তুম্হেং ইসলিএ মিসর সে নিকাল লাযা কি তুম্হেং মুল্কে-কনান দূঁ ঔর তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","অগর তেরা কোঈ ইসরাঈলী ভাঈ গ়রীব হোকর অপনে আপকো তেরে হাথ বেচ ডালে তো উসসে গ়ুলাম কা-সা কাম ন করানা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","উসকে সাথ মজ়দূর যা গ়ৈরশহরী কা-সা সুলূক করনা। ৱহ তেরে লিএ বহালী কে সাল তক কাম করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ফির ৱহ ঔর উসকে বাল-বচ্চে আজ়াদ হোকর অপনে রিশ্তেদারোং ঔর মৌরূসী জ়মীন কে পাস ৱাপস জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","চূঁকি ইসরাঈলী মেরে খ়াদিম হৈং জিন্হেং মৈং মিসর সে নিকাল লাযা ইসলিএ উন্হেং গ়ুলামী মেং ন বেচা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ঐসে লোগোং পর সখ়্তী সে হুক্মরানী ন করনা বল্কি অপনে খ়ুদা কা খ়ৌফ় মাননা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","তুম পড়োসী মমালিক সে অপনে লিএ গ়ুলাম ঔর লৌংডিযাঁ হাসিল কর সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","জো পরদেসী গ়ৈরশহরী কে তৌর পর তুম্হারে মুল্ক মেং আবাদ হৈং উন্হেং ভী তুম খ়রীদ সকতে হো। উনমেং ৱহ ভী শামিল হৈং জো তুম্হারে মুল্ক মেং পৈদা হুএ হৈং। ৱহী তুম্হারী মিলকিযত বনকর ");
INSERT INTO urdgvb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","তুম্হারে বেটোং কী মীরাস মেং আ জাএঁ ঔর ৱহী হমেশা তুম্হারে গ়ুলাম রহেং। লেকিন অপনে হমৱতন ভাইযোং পর সখ়্ত হুক্মরানী ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","অগর তেরে মুল্ক মেং রহনেৱালা কোঈ পরদেসী যা গ়ৈরশহরী অমীর হো জাএ জবকি তেরা কোঈ হমৱতন ভাঈ গ়রীব হোকর অপনে আপকো উস পরদেসী যা গ়ৈরশহরী যা উসকে খ়ানদান কে কিসী ফ়রদ কো বেচ ডালে ");
INSERT INTO urdgvb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","তো বিক জানে কে বাদ উসে আজ়াদী খ়রীদনে কা হক় হাসিল হৈ। কোঈ ভাঈ, ");
INSERT INTO urdgvb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","চচা, তাযা, চচা যা তাযা কা বেটা যা কোঈ ঔর ক়রীবী রিশ্তেদার উসে ৱাপস খ়রীদ সকতা হৈ। ৱহ খ়ুদ ভী অপনী আজ়াদী খ়রীদ সকতা হৈ অগর উসকে পাস পৈসে কাফ়ী হোং। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ইস সূরত মেং ৱহ অপনে মালিক সে মিলকর ৱহ সাল গিনে জো উসকে খ়রীদনে সে লেকর অগলে বহালী কে সাল তক বাক়ী হৈং। উস কী আজ়াদী কে পৈসে উস ক়ীমত পর মবনী হোং জো মজ়দূর কো ইতনে সালোং কে লিএ দিএ জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_51‏","004_25_51‏","LEV","25","51‏","52","জিতনে সাল বাক়ী রহ গএ হৈং উনকে মুতাবিক় উস কী বিক জানে কী ক়ীমত মেং সে পৈসে ৱাপস কর দিএ জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","উসকে সাথ সাল বসাল মজ়দূর কা-সা সুলূক কিযা জাএ। উসকা মালিক উস পর সখ়্ত হুক্মরানী ন করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","অগর ৱহ ইস তরহ কে কিসী তরীক়ে সে আজ়াদ ন হো জাএ তো উসে ঔর উসকে বচ্চোং কো হর হালত মেং অগলে বহালী কে সাল মেং আজ়াদ কর দেনা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ক্যোংকি ইসরাঈলী মেরে হী খ়াদিম হৈং। ৱহ মেরে হী খ়াদিম হৈং জিন্হেং মৈং মিসর সে নিকাল লাযা। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","অপনে লিএ বুত ন বনানা। ন অপনে লিএ দেৱতা কে মুজস্সমে যা পত্থর কে মখ়সূস কিএ হুএ সতূন খড়ে করনা, ন সিজদা করনে কে লিএ অপনে মুল্ক মেং ঐসে পত্থর রখনা জিনমেং দেৱতা কী তস্ৱীর কংদা কী গঈ হো। মৈং রব তুম্হারা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","সবত কা দিন মনানা ঔর মেরে মক়দিস কী তাজ়ীম করনা। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","অগর তুম মেরী হিদাযাত পর চলো ঔর মেরে অহকাম মানকর উন পর অমল করো ");
INSERT INTO urdgvb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","তো মৈং ৱক়্ত পর বারিশ ভেজূঁগা, জ়মীন অপনী পৈদাৱার দেগী ঔর দরখ়্ত অপনে অপনে ফল লাএঁগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","কসরত কে বাইস অনাজ কী ফ়সল কী কটাঈ অংগূর তোড়তে ৱক়্ত তক জারী রহেগী ঔর অংগূর কী ফ়সল উস ৱক়্ত তক তোড়ী জাএগী জব তক বীজ বোনে কা মৌসম আএগা। ইতনী খ়ুরাক মিলেগী কি তুম কভী ভূকে নহীং হোগে। ঔর তুম অপনে মুল্ক মেং মহফ়ূজ় রহোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","মৈং মুল্ক কো অমনো-অমান বখ়্শূঁগা। তুম আরাম সে লেট জাওগে, ক্যোংকি কিসী খ়তরে সে ডরনে কী জ়রূরত নহীং হোগী। মৈং ৱহশী জানৱর মুল্ক সে দূর কর দূঁগা, ঔর ৱহ তলৱার কী ক়ত্লো-গ়ারত সে বচা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","তুম অপনে দুশ্মনোং পর গ়ালিব আকর উনকা তাক়্ক়ুব করোগে, ঔর ৱহ তুম্হারী তলৱার সে মারে জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","তুম্হারে পাঁচ আদমী সৌ দুশ্মনোং কা পীছা করেংগে, ঔর তুম্হারে সৌ আদমী উনকে দস হজ়ার আদমিযোং কো ভগা দেংগে। তুম্হারে দুশ্মন তুম্হারী তলৱার সে মারে জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","মেরী নজ়রে-করম তুম পর হোগী। মৈং তুম্হারী ঔলাদ কী তাদাদ বঢ়াঊঁগা ঔর তুম্হারে সাথ অপনা অহদ ক়াযম রখূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","এক সাল ইতনী ফ়সল হোগী কি জব অগলী ফ়সল কী কটাঈ হোগী তো নএ অনাজ কে লিএ জগহ বনানে কী খ়াতির পুরানে অনাজ কো ফেংক দেনা পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","মৈং তুম্হারে দরমিযান অপনা মসকন ক়াযম করূঁগা ঔর তুমসে ঘিন নহীং খাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","মৈং তুমমেং ফিরূঁগা, ঔর তুম মেরী ক়ৌম হোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","মৈং রব তুম্হারা খ়ুদা হূঁ জো তুম্হেং মিসর সে নিকাল লাযা তাকি তুম্হারী গ়ুলামী কী হালত খ়ত্ম হো জাএ। মৈংনে তুম্হারে জুএ কো তোড় ডালা, ঔর অব তুম আজ়াদ ঔর সীধে হোকর চল সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","লেকিন অগর তুম মেরী নহীং সুনোগে ঔর ইন তমাম অহকাম পর নহীং চলোগে, ");
INSERT INTO urdgvb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","অগর তুম মেরী হিদাযাত কো রদ্দ করকে মেরে অহকাম সে ঘিন খাওগে ঔর উন পর অমল ন করকে মেরা অহদ তোড়োগে ");
INSERT INTO urdgvb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","তো মৈং জৱাব মেং তুম পর অচানক দহশত তারী কর দূঁগা। জিস্ম কো খ়ত্ম করনেৱালী বীমারিযোং ঔর বুখ়ার সে তুম্হারী আঁখেং জ়াযা হো জাএঁগী ঔর তুম্হারী জান ছিন জাএগী। জব তুম বীজ বোওগে তো বেফ়াযদা, ক্যোংকি দুশ্মন উস কী ফ়সল খা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","মৈং তুম্হারে খ়িলাফ় হো জাঊঁগা, ইসলিএ তুম অপনে দুশ্মনোং কে হাথ সে শিকস্ত খাওগে। তুমসে নফ়রত রখনেৱালে তুম পর হুকূমত করেংগে। উস ৱক়্ত ভী জব কোঈ তুম্হারা তাক়্ক়ুব নহীং করেগা তুম ভাগ জাওগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","অগর তুম ইসকে বাদ ভী মেরী ন সুনো তো মৈং তুম্হারে গুনাহোং কে সবব সে তুম্হেং সাত গুনা জ়্যাদা সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","মৈং তুম্হারা সখ়্ত গ়ুরূর খ়াক মেং মিলা দূঁগা। তুম্হারে ঊপর আসমান লোহে জৈসা ঔর তুম্হারে নীচে জ়মীন পীতল জৈসী হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","জিতনী ভী মেহনত করোগে ৱহ বেফ়াযদা হোগী, ক্যোংকি তুম্হারে খেতোং মেং ফ়সলেং নহীং পকেংগী ঔর তুম্হারে দরখ়্ত ফল নহীং লাএঁগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","অগর তুম ফির ভী মেরী মুখ়ালফ়ত করোগে ঔর মেরী নহীং সুনোগে তো মৈং ইন গুনাহোং কে জৱাব মেং তুম্হেং ইসসে ভী সাত গুনা জ়্যাদা সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","মৈং তুম্হারে খ়িলাফ় জংগলী জানৱর ভেজ দূঁগা জো তুম্হারে বচ্চোং কো ফাড় খাএঁগে ঔর তুম্হারে মৱেশী বরবাদ কর দেংগে। আখ়ির মেং তুম্হারী তাদাদ ইতনী কম হো জাএগী কি তুম্হারী সড়কেং ৱীরান হো জাএঁগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","অগর তুম ফির ভী মেরী তরবিযত ক়বূল ন করো বল্কি মেরে মুখ়ালিফ় রহো ");
INSERT INTO urdgvb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","তো মৈং খ়ুদ তুম্হারে খ়িলাফ় হো জাঊঁগা। ইন গুনাহোং কে জৱাব মেং মৈং তুম্হেং সাত গুনা জ়্যাদা সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","মৈং তুম পর তলৱার চলাকর ইসকা বদলা লূঁগা কি তুমনে মেরে অহদ কো তোড়া হৈ। জব তুম অপনী হিফ়াজ়ত কে লিএ শহরোং মেং ভাগকর জমা হোগে তো মৈং তুম্হারে দরমিযান ৱবাঈ বীমারিযাঁ ফৈলাঊঁগা ঔর তুম্হেং দুশ্মনোং কে হাথ মেং দে দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","অনাজ কী ইতনী কমী হোগী কি দস ঔরতেং তুম্হারী পূরী রোটী এক হী তনূর মেং পকা সকেংগী, ঔর ৱহ উসে বড়ী এহতিযাত সে তোল তোলকর তক়সীম করেংগী। তুম খাকর ভী ভূকে রহোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","অগর তুম ফির ভী মেরী নহীং সুনোগে বল্কি মেরে মুখ়ালিফ় রহোগে ");
INSERT INTO urdgvb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","তো মেরা গ়ুস্সা ভড়কেগা ঔর মৈং তুম্হারে খ়িলাফ় হোকর তুম্হারে গুনাহোং কে জৱাব মেং তুম্হেং সাত গুনা জ়্যাদা সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","তুম মুসীবত কে বাইস অপনে বেটে-বেটিযোং কা গোশ্ত খাওগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","মৈং তুম্হারী ঊঁচী জগহোং কী ক়ুরবানগাহেং ঔর তুম্হারী বখ়ূর কী ক়ুরবানগাহেং বরবাদ কর দূঁগা। মৈং তুম্হারী লাশোং কে ঢের তুম্হারে বেজান বুতোং পর লগাঊঁগা ঔর তুমসে ঘিন খাঊঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","মৈং তুম্হারে শহরোং কো খংডরাত মেং বদলকর তুম্হারে মংদিরোং কো বরবাদ করূঁগা। তুম্হারী ক়ুরবানিযোং কী খ়ুশবূ মুঝে পসংদ নহীং আএগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","মৈং তুম্হারে মুল্ক কা সত্যানাস যোং করূঁগা কি জো দুশ্মন উসমেং আবাদ হো জাএংগে উনকে রোংগটে খড়ে হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","মৈং তুম্হেং মুখ়্তলিফ় মমালিক মেং মুংতশির কর দূঁগা, লেকিন ৱহাঁ ভী অপনী তলৱার কো হাথ মেং লিএ তুম্হারা পীছা করূঁগা। তুম্হারী জ়মীন ৱীরান হোগী ঔর তুম্হারে শহর খংডরাত বন জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","উস ৱক়্ত জব তুম অপনে দুশ্মনোং কে মুল্ক মেং রহোগে তুম্হারী জ়মীন ৱীরান হালত মেং আরাম কে ৱহ সাল মনা সকেগী জিনসে ৱহ মহরূম রহী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","উন তমাম দিনোং মেং জব ৱহ বরবাদ রহেগী উসে ৱহ আরাম মিলেগা জো উসে ন মিলা জব তুম মুল্ক মেং রহতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","তুমমেং সে জো বচকর অপনে দুশ্মনোং কে মমালিক মেং রহেংগে উনকে দিলোং পর মৈং দহশত তারী করূঁগা। ৱহ হৱা কে ঝোংকোং সে গিরনেৱালে পত্তে কী আৱাজ় সে চৌংককর ভাগ জাএংগে। ৱহ ফ়রার হোংগে গোযা কোঈ হাথ মেং তলৱার লিএ উনকা তাক়্ক়ুব কর রহা হো। ঔর ৱহ গিরকর মর জাএংগে হালাঁকি কোঈ উনকা পীছা নহীং কর রহা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ৱহ এক দূসরে সে টকরাকর লড়খড়াএঁগে গোযা কোঈ তলৱার লেকর উনকে পীছে চল রহা হো হালাঁকি কোঈ নহীং হৈ। চুনাঁচে তুম অপনে দুশ্মনোং কা সামনা নহীং কর সকোগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","তুম দীগর ক়ৌমোং মেং মুংতশির হোকর হলাক হো জাওগে, ঔর তুম্হারে দুশ্মনোং কী জ়মীন তুম্হেং হড়প কর লেগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","তুমমেং সে বাক়ী লোগ অপনে ঔর অপনে বাপদাদা কে ক়ুসূর কে বাইস অপনে দুশ্মনোং কে মমালিক মেং গল-সড় জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","লেকিন এক ৱক়্ত আএগা কি ৱহ অপনে ঔর অপনে বাপদাদা কা ক়ুসূর মান লেংগে। ৱহ মেরে সাথ অপনী বেৱফ়াঈ ঔর ৱহ মুখ়ালফ়ত তসলীম করেংগে ");
INSERT INTO urdgvb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","জিসকে সবব সে মৈং উনকে খ়িলাফ় হুআ ঔর উন্হেং উনকে দুশ্মনোং কে মুল্ক মেং ধকেল দিযা থা। পহলে উনকা খ়তনা সির্ফ় জ়াহিরী তৌর পর হুআ থা, লেকিন অব উনকা দিল আজিজ় হো জাএগা ঔর ৱহ অপনে ক়ুসূর কী ক়ীমত অদা করেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ফির মৈং ইব্রাহীম কে সাথ অপনা অহদ, ইসহাক় কে সাথ অপনা অহদ ঔর যাক়ূব কে সাথ অপনা অহদ যাদ করূঁগা। মৈং মুল্কে-কনান ভী যাদ করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","লেকিন পহলে ৱহ জ়মীন কো ছোড়েংগে তাকি ৱহ উনকী গ়ৈরমৌজূদগী মেং ৱীরান হোকর আরাম কে সাল মনাএ। যোং ইসরাঈলী অপনে ক়ুসূর কে নতীজে ভুগতেংগে, ইস সবব সে কি উন্হোংনে মেরে অহকাম রদ্দ কিএ ঔর মেরী হিদাযাত সে ঘিন খাঈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ইসকে বাৱুজূদ ভী মৈং উন্হেং দুশ্মনোং কে মুল্ক মেং ছোড়কর রদ্দ নহীং করূঁগা, ন যহাঁ তক উনসে ঘিন খাঊঁগা কি ৱহ বিলকুল তবাহ হো জাএঁ। ক্যোংকি মৈং উনকে সাথ অপনা অহদ নহীং তোড়নে কা। মৈং রব উনকা খ়ুদা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","মৈং উনকী খ়াতির উনকে বাপদাদা কে সাথ বঁধা হুআ অহদ যাদ করূঁগা, উন লোগোং কে সাথ অহদ জিন্হেং মৈং দূসরী ক়ৌমোং কে দেখতে দেখতে মিসর সে নিকাল লাযা তাকি উনকা খ়ুদা হূঁ। মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","রব নে মূসা কো ইসরাঈলিযোং কে লিএ যহ তমাম হিদাযাত ঔর অহকাম সীনা পহাড় পর দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ইসরাঈলিযোং কো বতানা কি অগর কিসী নে মন্নত মানকর কিসী কো রব কে লিএ মখ়সূস কিযা হো তো ৱহ উসে জ়ৈল কী রক়ম দেকর আজ়াদ কর সকতা হৈ (মুস্তামল সিক্কে মক়দিস কে সিক্কোং কে বরাবর হোং) : ");
INSERT INTO urdgvb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","উস আদমী কে লিএ জিসকী উম্র 20 ঔর 60 সাল কে দরমিযান হৈ চাঁদী কে 50 সিক্কে, ");
INSERT INTO urdgvb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ইসী উম্র কী ঔরত কে লিএ চাঁদী কে 30 সিক্কে, ");
INSERT INTO urdgvb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","উস লড়কে কে লিএ জিসকী উম্র 5 ঔর 20 সাল কে দরমিযান হো চাঁদী কে 20 সিক্কে, ইসী উম্র কী লড়কী কে লিএ চাঁদী কে 10 সিক্কে, ");
INSERT INTO urdgvb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","এক মাহ সে লেকর 5 সাল তক কে লড়কে কে লিএ চাঁদী কে 5 সিক্কে, ইসী উম্র কী লড়কী কে লিএ চাঁদী কে 3 সিক্কে, ");
INSERT INTO urdgvb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","সাঠ সাল সে বড়ে আদমী কে লিএ চাঁদী কে 15 সিক্কে ঔর ইসী উম্র কী ঔরত কে লিএ চাঁদী কে 10 সিক্কে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","অগর মন্নত মাননেৱালা মুক়র্ররা রক়ম অদা ন কর সকে তো ৱহ মখ়সূস কিএ হুএ শখ়্স কো ইমাম কে পাস লে আএ। ফির ইমাম ঐসী রক়ম মুক়র্রর করে জো মন্নত মাননেৱালা অদা কর সকে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","অগর কিসী নে মন্নত মানকর ঐসা জানৱর মখ়সূস কিযা জো রব কী ক়ুরবানিযোং কে লিএ ইস্তেমাল হো সকতা হৈ তো ঐসা জানৱর মখ়সূসো-মুক়দ্দস হো জাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ৱহ উসে বদল নহীং সকতা। ন ৱহ অচ্ছে জানৱর কী জগহ নাক়িস, ন নাক়িস জানৱর কী জগহ অচ্ছা জানৱর দে। অগর ৱহ এক জানৱর দূসরে কী জগহ দে তো দোনোং মখ়সূসো-মুক়দ্দস হো জাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","অগর কিসী নে মন্নত মানকর কোঈ নাপাক জানৱর মখ়সূস কিযা জো রব কী ক়ুরবানিযোং কে লিএ ইস্তেমাল নহীং হো সকতা তো ৱহ উসকো ইমাম কে পাস লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ইমাম উস কী রক়ম উস কী অচ্ছী ঔর বুরী সিফ়্তোং কা লিহাজ় করকে মুক়র্রর করে। ইস মুক়র্ররা ক়ীমত মেং কমী বেশী নহীং হো সকতী। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","অগর মন্নত মাননেৱালা উসে ৱাপস খ়রীদনা চাহে তো ৱহ মুক়র্ররা ক়ীমত জমা 20 ফ়ীসদ অদা করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","অগর কোঈ অপনা ঘর রব কে লিএ মখ়সূসো-মুক়দ্দস করে তো ইমাম উস কী অচ্ছী ঔর বুরী সিফ়্তোং কা লিহাজ় করকে উস কী রক়ম মুক়র্রর করে। ইস মুক়র্ররা ক়ীমত মেং কমী বেশী নহীং হো সকতী। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","অগর ঘর কো মখ়সূস করনেৱালা উসে ৱাপস খ়রীদনা চাহে তো ৱহ মুক়র্ররা রক়ম জমা 20 ফ়ীসদ অদা করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","অগর কোঈ অপনী মৌরূসী জ়মীন মেং সে কুছ রব কে লিএ মখ়সূসো-মুক়দ্দস করে তো উস কী ক়ীমত উস বীজ কী মিক়দার কে মুতাবিক় মুক়র্রর কী জাএ জো উসমেং বোনা হোতা হৈ। জিস খেত মেং 135 কিলোগ্রাম জৌ কা বীজ বোযা জাএ উস কী ক়ীমত চাঁদী কে 50 সিক্কে হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","শর্ত যহ হৈ কি ৱহ অপনী জ়মীন বহালী কে সাল কে ঐন বাদ মখ়সূস করে। ফির উস কী যহী ক়ীমত মুক়র্রর কী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","অগর জ়মীন কা মালিক উসে বহালী কে সাল কে কুছ দের বাদ মখ়সূস করে তো ইমাম অগলে বহালী কে সাল তক রহনেৱালে সালোং কে মুতাবিক় জ়মীন কী ক়ীমত মুক়র্রর করে। জিতনে কম সাল বাক়ী হৈং উতনী কম উস কী ক়ীমত হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","অগর মখ়সূস করনেৱালা অপনী জ়মীন ৱাপস খ়রীদনা চাহে তো ৱহ মুক়র্ররা ক়ীমত জমা 20 ফ়ীসদ অদা করে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","অগর মখ়সূস করনেৱালা অপনী জ়মীন কো রব সে ৱাপস খ়রীদে বগ়ৈর উসে কিসী ঔর কো বেচে তো উসে ৱাপস খ়রীদনে কা হক় খ়ত্ম হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","অগলে বহালী কে সাল যহ জ়মীন মখ়সূসো-মুক়দ্দস রহেগী ঔর রব কী দাযমী মিলকিযত হো জাএগী। চুনাঁচে ৱহ ইমাম কী মিলকিযত হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","অগর কোঈ অপনা মৌরূসী খেত নহীং বল্কি অপনা খ়রীদা হুআ খেত রব কে লিএ মখ়সূস করে ");
INSERT INTO urdgvb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","তো ইমাম অগলে বহালী কে সাল তক রহনেৱালে সালোং কা লিহাজ় করকে উস কী ক়ীমত মুক়র্রর করে। খেত কা মালিক উসী দিন উসকে পৈসে অদা করে। যহ পৈসে রব কে লিএ মখ়সূসো-মুক়দ্দস হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","বহালী কে সাল মেং যহ খেত উস শখ়্স কে পাস ৱাপস আএগা জিসনে উসে বেচা থা। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ৱাপস খ়রীদনে কে লিএ মুস্তামল সিক্কে মক়দিস কে সিক্কোং কে বরাবর হোং। উসকে চাঁদী কে সিক্কোং কা ৱজ়ন 11 গ্রাম হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","লেকিন কোঈ ভী কিসী মৱেশী কা পহলৌঠা রব কে লিএ মখ়সূস নহীং কর সকতা। ৱহ তো পহলে সে রব কে লিএ মখ়সূস হৈ। ইসমেং কোঈ ফ়রক় নহীং কি ৱহ গায, বৈল যা ভেড় হো। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","অগর উসনে কোঈ নাপাক জানৱর মখ়সূস কিযা হো তো ৱহ উসে মুক়র্ররা ক়ীমত জমা 20 ফ়ীসদ কে লিএ ৱাপস খ়রীদ সকতা হৈ। অগর ৱহ উসে ৱাপস ন খ়রীদে তো ৱহ মুক়র্ররা ক়ীমত কে লিএ বেচা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","লেকিন অগর কিসী নে অপনী মিলকিযত মেং সে কুছ গ়ৈরমশরূত তৌর পর রব কে লিএ মখ়সূস কিযা হৈ তো উসে বেচা যা ৱাপস নহীং খ়রীদা জা সকতা, খ়াহ ৱহ ইনসান, জানৱর যা জ়মীন হো। জো ইস তরহ মখ়সূস কিযা গযা হো ৱহ রব কে লিএ নিহাযত মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ইসী তরহ জিস শখ়্স কো তবাহী কে লিএ মখ়সূস কিযা গযা হৈ উসকা ফ়িদ্যা নহীং দিযা জা সকতা। লাজ়িম হৈ কি উসে সজ়াএ-মৌত দী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","হর ফ়সল কা দসৱাঁ হিস্সা রব কা হৈ, চাহে ৱহ অনাজ হো যা ফল। ৱহ রব কে লিএ মখ়সূসো-মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","অগর কোঈ অপনী ফ়সল কা দসৱাঁ হিস্সা ছুড়ানা চাহতা হৈ তো ৱহ ইসকে লিএ উস কী মুক়র্ররা ক়ীমত জমা 20 ফ়ীসদ দে। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ইসী তরহ গায-বৈলোং ঔর ভেড়-বকরিযোং কা দসৱাঁ হিস্সা ভী রব কে লিএ মখ়সূসো-মুক়দ্দস হৈ, হর দসৱাঁ জানৱর জো গল্লাবান কে ডংডে কে নীচে সে গুজ়রেগা। ");
INSERT INTO urdgvb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","যহ জানৱর চুননে সে পহলে উনকা মুআযনা ন কিযা জাএ কি কৌন-সে জানৱর অচ্ছে যা কমজ়োর হৈং। যহ ভী ন করনা কি দসৱেং হিস্সে কে কিসী জানৱর কে বদলে কোঈ ঔর জানৱর দিযা জাএ। অগর ফির ভী উসে বদলা জাএ তো দোনোং জানৱর রব কে লিএ মখ়সূসো-মুক়দ্দস হোংগে। ঔর উন্হেং ৱাপস খ়রীদা নহীং জা সকতা।” ");
INSERT INTO urdgvb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","যহ ৱহ অহকাম হৈং জো রব নে সীনা পহাড় পর মূসা কো ইসরাঈলিযোং কে লিএ দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ইসরাঈলিযোং কো মিসর সে নিকলে হুএ এক সাল সে জ়্যাদা অরসা গুজ়র গযা থা। অব তক ৱহ দশ্তে-সীনা মেং থে। দূসরে সাল কে দূসরে মহীনে কে পহলে দিন রব মুলাক়াত কে খ়ৈমে মেং মূসা সে হমকলাম হুআ। উসনে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“তূ ঔর হারূন তমাম ইসরাঈলিযোং কী মর্দুমশুমারী কুংবোং ঔর আবাঈ ঘরানোং কে মুতাবিক় করনা। উন তমাম মর্দোং কী ফ়হরিস্ত বনানা ");
INSERT INTO urdgvb_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","জো কম অজ় কম বীস সাল কে ঔর জংগ লড়নে কে ক়াবিল হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ইসমেং হর ক়বীলে কে এক খ়ানদান কা সরপরস্ত তুম্হারী মদদ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","যহ উনকে নাম হৈং : রূবিন কে ক়বীলে সে ইলীসূর বিন শদিযূর, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","শমৌন কে ক়বীলে সে সলূমিযেল বিন সূরীশদ্দী, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","যহূদাহ কে ক়বীলে সে নহসোন বিন অম্মীনদাব, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ইশকার কে ক়বীলে সে নতনিযেল বিন জ়ুগ়র, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","জ়বূলূন কে ক়বীলে সে ইলিযাব বিন হেলোন, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","যূসুফ় কে বেটে ইফ়রাঈম কে ক়বীলে সে ইলীসমা বিন অম্মীহূদ, যূসুফ় কে বেটে মনস্সী কে ক়বীলে সে জমলিযেল বিন ফ়দাহসূর, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","বিনযমীন কে ক়বীলে সে অবিদান বিন জিদৌনী, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","দান কে ক়বীলে সে অখ়িযজ়র বিন অম্মীশদ্দী, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","আশর কে ক়বীলে সে ফ়জিযেল বিন অকরান, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","জদ কে ক়বীলে সে ইলিযাসফ় বিন দঊএল, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","নফ়তালী কে ক়বীলে সে অখ়ীরা বিন এনান।” ");
INSERT INTO urdgvb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","যহী মর্দ জমাত সে ইস কাম কে লিএ বুলাএ গএ। ৱহ অপনে ক়বীলোং কে রাহনুমা ঔর কুংবোং কে সরপরস্ত থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ইনকী মদদ সে মূসা ঔর হারূন নে ");
INSERT INTO urdgvb_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","উসী দিন পূরী জমাত কো ইকট্ঠা কিযা। হর ইসরাঈলী মর্দ জো কম অজ় কম 20 সাল কা থা রজিস্টর মেং দর্জ কিযা গযা। রজিস্টর কী তরতীব উনকে কুংবোং ঔর আবাঈ ঘরানোং কে মুতাবিক় থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","সব কুছ ৱৈসা হী কিযা গযা জৈসা রব নে হুক্ম দিযা থা। মূসা নে সীনা কে রেগিস্তান মেং লোগোং কী মর্দুমশুমারী কী। নতীজা যহ নিকলা : ");
INSERT INTO urdgvb_vpl VALUES ("NU1_20‏","005_1_20‏","NUM","1","20‏","21","রূবিন কে ক়বীলে কে 46,500 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_22‏","005_1_22‏","NUM","1","22‏","23","শমৌন কে ক়বীলে কে 59,300 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_24‏","005_1_24‏","NUM","1","24‏","25","জদ কে ক়বীলে কে 45,650 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_26‏","005_1_26‏","NUM","1","26‏","27","যহূদাহ কে ক়বীলে কে 74,600 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_28‏","005_1_28‏","NUM","1","28‏","29","ইশকার কে ক়বীলে কে 54,400 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_30‏","005_1_30‏","NUM","1","30‏","31","জ়বূলূন কে ক়বীলে কে 57,400 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_32‏","005_1_32‏","NUM","1","32‏","33","যূসুফ় কে বেটে ইফ়রাঈম কে ক়বীলে কে 40,500 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_34‏","005_1_34‏","NUM","1","34‏","35","যূসুফ় কে বেটে মনস্সী কে ক়বীলে কে 32,200 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_36‏","005_1_36‏","NUM","1","36‏","37","বিনযমীন কে ক়বীলে কে 35,400 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_38‏","005_1_38‏","NUM","1","38‏","39","দান কে ক়বীলে কে 62,700 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_40‏","005_1_40‏","NUM","1","40‏","41","আশর কে ক়বীলে কে 41,500 মর্দ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_42‏","005_1_42‏","NUM","1","42‏","43","নফ়তালী কে ক়বীলে কে 53,400 মর্দ। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","মূসা, হারূন ঔর ক়বীলোং কে বারহ রাহনুমাওং নে ইন তমাম আদমিযোং কো গিনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_45‏","005_1_45‏","NUM","1","45‏","46","উনকী পূরী তাদাদ 6,03,550 থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","লেকিন লাৱিযোং কী মর্দুমশুমারী ন হুঈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ক্যোংকি রব নে মূসা সে কহা থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ইসরাঈলিযোং কী মর্দুমশুমারী মেং লাৱিযোং কো শামিল ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ইসকে বজাএ উন্হেং শরীঅত কী সুকূনতগাহ ঔর উসকা সারা সামান সঁভালনে কী জ়িম্মাদারী দেনা। ৱহ সফ়র করতে ৱক়্ত যহ খ়ৈমা ঔর উসকা সারা সামান উঠাকর লে জাএঁ, উস কী খ়িদমত কে লিএ হাজ়ির রহেং ঔর রুকতে ৱক়্ত উসে অপনে খ়ৈমোং সে ঘেরে রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","রৱানা হোতে ৱক়্ত ৱহী খ়ৈমে কো সমেটেং ঔর রুকতে ৱক়্ত ৱহী উসে লগাএঁ। অগর কোঈ ঔর উসকে ক়রীব আএ তো উসে সজ়াএ-মৌত দী জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","বাক়ী ইসরাঈলী খ়ৈমাগাহ মেং অপনে অপনে দস্তে কে মুতাবিক় ঔর অপনে অপনে অলম কে ইর্দগির্দ অপনে খ়ৈমে লগাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","লেকিন লাৱী অপনে খ়ৈমোং সে শরীঅত কী সুকূনতগাহ কো ঘের লেং তাকি মেরা গ়জ়ব কিসী গ়লত শখ়্স কে নজ়দীক আনে সে ইসরাঈলিযোং কী জমাত পর নাজ়িল ন হো জাএ। যোং লাৱিযোং কো শরীঅত কী সুকূনতগাহ কো সঁভালনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ইসরাঈলিযোং নে ৱৈসা হী কিযা জৈসা রব নে মূসা কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","রব নে মূসা ঔর হারূন সে কহা ");
INSERT INTO urdgvb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","কি ইসরাঈলী অপনে খ়ৈমে কুছ ফ়াসলে পর মুলাক়াত কে খ়ৈমে কে ইর্দগির্দ লগাএঁ। হর এক অপনে অপনে অলম ঔর অপনে অপনে আবাঈ ঘরানে কে নিশান কে সাথ খ়ৈমাজ়ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ইন হিদাযাত কে মুতাবিক় মক়দিস কে মশরিক় মেং যহূদাহ কা অলম থা জিসকে ইর্দগির্দ তীন দস্তে খ়ৈমাজ়ন থে। পহলে, যহূদাহ কা ক়বীলা জিসকা কমাঁডর নহসোন বিন অম্মীনদাব থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ঔর জিসকে লশকর কে 74,600 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","দূসরে, ইশকার কা ক়বীলা জিসকা কমাঁডর নতনিযেল বিন জ়ুগ়র থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ঔর জিসকে লশকর কে 54,400 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","তীসরে, জ়বূলূন কা ক়বীলা জিসকা কমাঁডর ইলিযাব বিন হেলোন থা ");
INSERT INTO urdgvb_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ঔর জিসকে লশকর কে 57,400 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","তীনোং ক়বীলোং কে ফ়ৌজিযোং কী কুল তাদাদ 1,86,400 থী। রৱানা হোতে ৱক়্ত যহ আগে চলতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","মক়দিস কে জুনূব মেং রূবিন কা অলম থা জিসকে ইর্দগির্দ তীন দস্তে খ়ৈমাজ়ন থে। পহলে, রূবিন কা ক়বীলা জিসকা কমাঁডর ইলীসূর বিন শদিযূর থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ঔর জিসকে 46,500 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","দূসরে, শমৌন কা ক়বীলা জিসকা কমাঁডর সলূমিযেল বিন সূরীশদ্দী থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ঔর জিসকে 59,300 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","তীসরে, জদ কা ক়বীলা জিসকা কমাঁডর ইলিযাসফ় বিন দঊএল থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ঔর জিসকে 45,650 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","তীনোং ক়বীলোং কে ফ়ৌজিযোং কী কুল তাদাদ 1,51,450 থী। রৱানা হোতে ৱক়্ত যহ মশরিক়ী ক়বীলোং কে পীছে চলতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ইন জুনূবী ক়বীলোং কে বাদ লাৱী মুলাক়াত কা খ়ৈমা উঠাকর ক়বীলোং কে ঐন বীচ মেং চলতে থে। ক়বীলে উস তরতীব সে রৱানা হোতে থে জিস তরতীব সে ৱহ অপনে খ়ৈমে লগাতে থে। হর ক়বীলা অপনে অলম কে পীছে চলতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","মক়দিস কে মগ়রিব মেং ইফ়রাঈম কা অলম থা জিসকে ইর্দগির্দ তীন দস্তে খ়ৈমাজ়ন থে। পহলে, ইফ়রাঈম কা ক়বীলা জিসকা কমাঁডর ইলীসমা বিন অম্মীহূদ থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ঔর জিসকে 40,500 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","দূসরে, মনস্সী কা ক়বীলা জিসকা কমাঁডর জমলিযেল বিন ফ়দাহসূর থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ঔর জিসকে 32,200 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","তীসরে, বিনযমীন কা ক়বীলা জিসকা কমাঁডর অবিদান বিন জিদৌনী থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ঔর জিসকে 35,400 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","তীনোং ক়বীলোং কে ফ়ৌজিযোং কী কুল তাদাদ 1,08,100 থী। রৱানা হোতে ৱক়্ত যহ জুনূবী ক়বীলোং কে পীছে চলতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","মক়দিস কে শিমাল মেং দান কা অলম থা জিসকে ইর্দগির্দ তীন দস্তে খ়ৈমাজ়ন থে। পহলে, দান কা ক়বীলা জিসকা কমাঁডর অখ়িযজ়র বিন অম্মীশদ্দী থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ঔর জিসকে 62,700 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","দূসরে, আশর কা ক়বীলা জিসকা কমাঁডর ফ়জিযেল বিন অকরান থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ঔর জিসকে 41,500 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","তীসরে, নফ়তালী কা ক়বীলা জিসকা কমাঁডর অখ়ীরা বিন এনান থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ঔর জিসকে 53,400 ফ়ৌজী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","তীনোং ক়বীলোং কী কুল তাদাদ 1,57,600 থী। ৱহ আখ়ির মেং অপনা অলম উঠাকর রৱানা হোতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","পূরী খ়ৈমাগাহ কে ফ়ৌজিযোং কী কুল তাদাদ 6,03,550 থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","সির্ফ় লাৱী ইস তাদাদ মেং শামিল নহীং থে, ক্যোংকি রব নে মূসা কো হুক্ম দিযা থা কি উনকী ভরতী ন কী জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","যোং ইসরাঈলিযোং নে সব কুছ উন হিদাযাত কে মুতাবিক় কিযা জো রব নে মূসা কো দী থীং। উনকে মুতাবিক় হী ৱহ অপনে ঝংডোং কে ইর্দগির্দ অপনে খ়ৈমে লগাতে থে ঔর উনকে মুতাবিক় হী অপনে কুংবোং ঔর আবাঈ ঘরানোং কে সাথ রৱানা হোতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","যহ হারূন ঔর মূসা কে খ়ানদান কা বযান হৈ। উস ৱক়্ত কা জ়িক্র হৈ জব রব নে সীনা পহাড় পর মূসা সে বাত কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","হারূন কে চার বেটে থে। বড়া বেটা নদব থা, ফির অবীহূ, ইলিযজ়র ঔর ইতমর। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","যহ ইমাম থে জিনকো মসহ করকে ইস খ়িদমত কা ইখ়্তিযার দিযা গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","লেকিন নদব ঔর অবীহূ উস ৱক়্ত মর গএ জব উন্হোংনে দশ্তে-সীনা মেং রব কে হুজ়ূর নাজাযজ় আগ পেশ কী। চূঁকি ৱহ বেঔলাদ থে ইসলিএ হারূন কে জীতে-জী সির্ফ় ইলিযজ়র ঔর ইতমর ইমাম কী খ়িদমত সরংজাম দেতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“লাৱী কে ক়বীলে কো লাকর হারূন কী খ়িদমত করনে কী জ়িম্মাদারী দে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","উন্হেং উসকে লিএ ঔর পূরী জমাত কে লিএ মুলাক়াত কে খ়ৈমে কী খ়িদমাত সঁভালনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ৱহ মুলাক়াত কে খ়ৈমে কা সামান সঁভালেং ঔর তমাম ইসরাঈলিযোং কে লিএ মক়দিস কে ফ়রাযজ় অদা করেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","তমাম ইসরাঈলিযোং মেং সে সির্ফ় লাৱিযোং কো হারূন ঔর উসকে বেটোং কী খ়িদমত কে লিএ মুক়র্রর কর। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","লেকিন সির্ফ় হারূন ঔর উসকে বেটোং কো ইমাম কী হৈসিযত হাসিল হৈ। জো ভী বাক়িযোং মেং সে উনকী জ়িম্মাদারিযাঁ উঠানে কী কোশিশ করেগা উসে সজ়াএ-মৌত দী জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","রব নে মূসা সে যহ ভী কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“মৈংনে ইসরাঈলিযোং মেং সে লাৱিযোং কো চুন লিযা হৈ। ৱহ তমাম ইসরাঈলী পহলৌঠোং কে এৱজ় মেরে লিএ মখ়সূস হৈং, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ক্যোংকি তমাম পহলৌঠে মেরে হী হৈং। জিস দিন মৈংনে মিসর মেং তমাম পহলৌঠোং কো মার দিযা উস দিন মৈংনে ইসরাঈল কে পহলৌঠোং কো অপনে লিএ মখ়সূস কিযা, খ়াহ ৱহ ইনসান কে থে যা হৈৱান কে। ৱহ মেরে হী হৈং। মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","রব নে সীনা কে রেগিস্তান মেং মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“লাৱিযোং কো গিনকর উনকে আবাঈ ঘরানোং ঔর কুংবোং কে মুতাবিক় রজিস্টর মেং দর্জ করনা। হর বেটে কো গিননা হৈ জো এক মাহ যা ইসসে জ়াযদ কা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","মূসা নে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","লাৱী কে তীন বেটে জৈরসোন, ক়িহাত ঔর মিরারী থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","জৈরসোন কে দো কুংবে উসকে বেটোং লিবনী ঔর সিমঈ কে নাম রখতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ক়িহাত কে চার কুংবে উসকে বেটোং অমরাম, ইজ়হার, হবরূন ঔর উজ়্জ়িযেল কে নাম রখতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","মিরারী কে দো কুংবে উসকে বেটোং মহলী ঔর মূশী কে নাম রখতে থে। গ়রজ় লাৱী কে ক়বীলে কে কুংবে উসকে পোতোং কে নাম রখতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","জৈরসোন কে দো কুংবোং বনাম লিবনী ঔর সিমঈ ");
INSERT INTO urdgvb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","কে 7,500 মর্দ থে জো এক মাহ যা ইসসে জ়াযদ কে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","উন্হেং অপনে খ়ৈমে মগ়রিব মেং মক়দিস কে পীছে লগানে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","উনকা রাহনুমা ইলিযাসফ় বিন লাএল থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ঔর ৱহ খ়ৈমে কো সঁভালতে থে যানী উস কী পোশিশেং, খ়ৈমে কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","খ়ৈমে ঔর ক়ুরবানগাহ কী চারদীৱারী কে পরদে, চারদীৱারী কে দরৱাজ়ে কা পরদা ঔর তমাম রস্সে। ইন চীজ়োং সে মুতাল্লিক় সারী খ়িদমত উনকী জ়িম্মাদারী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ক়িহাত কে চার কুংবোং বনাম অমরাম, ইজ়হার, হবরূন ঔর উজ়্জ়িযেল ");
INSERT INTO urdgvb_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","কে 8,600 মর্দ থে জো এক মাহ যা ইসসে জ়াযদ কে থে ঔর জিনকো মক়দিস কী খ়িদমত করনী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","উন্হেং অপনে ডেরে মক়দিস কে জুনূব মেং ডালনে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","উনকা রাহনুমা ইলীসফ়ন বিন উজ়্জ়িযেল থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ঔর ৱহ যহ চীজ়েং সঁভালতে থে : অহদ কা সংদূক়, মেজ়, শমাদান, ক়ুরবানগাহেং, ৱহ বরতন ঔর সাজ়ো-সামান জো মক়দিস মেং ইস্তেমাল হোতা থা ঔর মুক়দ্দসতরীন কমরে কা পরদা। ইন চীজ়োং সে মুতাল্লিক় সারী খ়িদমত উনকী জ়িম্মাদারী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","হারূন ইমাম কা বেটা ইলিযজ়র লাৱিযোং কে তমাম রাহনুমাওং পর মুক়র্রর থা। ৱহ উন তমাম লোগোং কা ইংচার্জ থা জো মক়দিস কী দেখ-ভাল করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","মিরারী কে দো কুংবোং বনাম মহলী ঔর মূশী ");
INSERT INTO urdgvb_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","কে 6,200 মর্দ থে জো এক মাহ যা ইসসে জ়াযদ কে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","উনকা রাহনুমা সূরিযেল বিন অবীখ়ৈল থা। উন্হেং অপনে ডেরে মক়দিস কে শিমাল মেং ডালনে থে, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ঔর ৱহ যহ চীজ়েং সঁভালতে থে : খ়ৈমে কে তখ়্তে, উসকে শহতীর, খংবে, পাএ ঔর ইস তরহ কা সারা সামান। ইন চীজ়োং সে মুতাল্লিক় সারী খ়িদমত উনকী জ়িম্মাদারী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ৱহ চারদীৱারী কে খংবে, পাএ, মেখ়েং ঔর রস্সে ভী সঁভালতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","মূসা, হারূন ঔর উনকে বেটোং কো অপনে ডেরে মশরিক় মেং মক়দিস কে সামনে ডালনে থে। উনকী জ়িম্মাদারী মক়দিস মেং বনী ইসরাঈল কে লিএ খ়িদমত করনা থী। উনকে অলাৱা জো ভী মক়দিস মেং দাখ়িল হোনে কী কোশিশ করতা উসে সজ়াএ-মৌত দেনী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","উন লাৱী মর্দোং কী কুল তাদাদ জো এক মাহ যা ইসসে জ়াযদ কে থে 22,000 থী। রব কে কহনে পর মূসা ঔর হারূন নে উন্হেং কুংবোং কে মুতাবিক় গিনকর রজিস্টর মেং দর্জ কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","রব নে মূসা সে কহা, “তমাম ইসরাঈলী পহলৌঠোং কো গিননা জো এক মাহ যা ইসসে জ়াযদ কে হৈং ঔর উনকে নাম রজিস্টর মেং দর্জ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","উন তমাম পহলৌঠোং কী জগহ লাৱিযোং কো মেরে লিএ মখ়সূস করনা। ইসী তরহ ইসরাঈলিযোং কে মৱেশিযোং কে পহলৌঠোং কী জগহ লাৱিযোং কে মৱেশী মেরে লিএ মখ়সূস করনা। মৈং রব হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","মূসা নে ঐসা হী কিযা জৈসা রব নে উসে হুক্ম দিযা। উসনে তমাম ইসরাঈলী পহলৌঠে ");
INSERT INTO urdgvb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","জো এক মাহ যা ইসসে জ়াযদ কে থে গিন লিএ। উনকী কুল তাদাদ 22,273 থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“মুঝে তমাম ইসরাঈলী পহলৌঠোং কী জগহ লাৱিযোং কো পেশ করনা। ইসী তরহ মুঝে ইসরাঈলিযোং কে মৱেশিযোং কী জগহ লাৱিযোং কে মৱেশী পেশ করনা। লাৱী মেরে হী হৈং। মৈং রব হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","লাৱিযোং কী নিসবত বাক়ী ইসরাঈলিযোং কে 273 পহলৌঠে জ়্যাদা হৈং। উনমেং সে ");
INSERT INTO urdgvb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","হর এক কে এৱজ় চাঁদী কে পাঁচ সিক্কে লে জো মক়দিস কে ৱজ়ন কে মুতাবিক় হোং (ফ়ী সিক্কা তক়রীবন 11 গ্রাম)। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","যহ পৈসে হারূন ঔর উসকে বেটোং কো দেনা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","মূসা নে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","যোং উসনে চাঁদী কে 1,365 সিক্কে (তক়রীবন 16 কিলোগ্রাম) জমা করকে ");
INSERT INTO urdgvb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","হারূন ঔর উসকে বেটোং কো দিএ, জিস তরহ রব নে উসে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“লাৱী কে ক়বীলে মেং সে ক়িহাতিযোং কী মর্দুমশুমারী উনকে কুংবোং ঔর আবাঈ ঘরানোং কে মুতাবিক় করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","উন তমাম মর্দোং কো রজিস্টর মেং দর্জ করনা জো 30 সে লেকর 50 সাল কে হৈং ঔর মুলাক়াত কে খ়ৈমে মেং খ়িদমত করনে কে লিএ আ সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ক়িহাতিযোং কী খ়িদমত মুক়দ্দসতরীন কমরে কী দেখ-ভাল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","জব খ়ৈমে কো সফ়র কে লিএ সমেটনা হৈ তো হারূন ঔর উসকে বেটে দাখ়িল হোকর মুক়দ্দসতরীন কমরে কা পরদা উতারেং ঔর উসে শরীঅত কে সংদূক় পর ডাল দেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ইস পর ৱহ তখ়স কী খালোং কা গ়িলাফ় ঔর আখ়ির মেং পূরী তরহ নীলে রংগ কা কপড়া বিছাএঁ। ইসকে বাদ ৱহ সংদূক় কো উঠানে কী লকড়িযাঁ লগাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ৱহ উস মেজ় পর ভী নীলে রংগ কা কপড়া বিছাএঁ জিস পর রব কো রোটী পেশ কী জাতী হৈ। উস পর থাল, প্যালে, মৈ কী নজ়রেং পেশ করনে কে বরতন ঔর মরতবান রখে জাএঁ। জো রোটী হমেশা মেজ় পর হোতী হৈ ৱহ ভী উস পর রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","হারূন ঔর উসকে বেটে ইন তমাম চীজ়োং পর ক়িরমিজ়ী রংগ কা কপড়া বিছাকর আখ়ির মেং উনকে ঊপর তখ়স কী খালোং কা গ়িলাফ় ডালেং। ইসকে বাদ ৱহ মেজ় কো উঠানে কী লকড়িযাঁ লগাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ৱহ শমাদান ঔর উসকে সামান পর যানী উসকে চরাগ়, বত্তী কতরনে কী ক়ৈংচিযোং, জলতে কোযলে কে ছোটে বরতনোং ঔর তেল কে বরতনোং পর নীলে রংগ কা কপড়া রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","যহ সব কুছ ৱহ তখ়স কী খালোং কে গ়িলাফ় মেং লপেটেং ঔর উসে উঠাকর লে জানে কে লিএ এক চৌখটে পর রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ৱহ বখ়ূর জলানে কী সোনে কী ক়ুরবানগাহ পর ভী নীলে রংগ কা কপড়া বিছাকর উস পর তখ়স কী খালোং কা গ়িলাফ় ডালেং ঔর ফির উসে উঠানে কী লকড়িযাঁ লগাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ৱহ সারা সামান জো মুক়দ্দস কমরে মেং ইস্তেমাল হোতা হৈ লেকর নীলে রংগ কে কপড়ে মেং লপেটেং, উস পর তখ়স কী খালোং কা গ়িলাফ় ডালেং ঔর উসে উঠাকর লে জানে কে লিএ এক চৌখটে পর রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ফির ৱহ জানৱরোং কো জলানে কী ক়ুরবানগাহ কো রাখ সে সাফ় করকে উস পর অরগ়ৱানী রংগ কা কপড়া বিছাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","উস পর ৱহ ক়ুরবানগাহ কী খ়িদমত কে লিএ সারা জ়রূরী সামান রখেং যানী ছিড়কাৱ কে কটোরে, জলতে হুএ কোযলে কে বরতন, বেলচে ঔর কাঁটে। ইস সামান পর ৱহ তখ়স কী খালোং কা গ়িলাফ় ডালকর ক়ুরবানগাহ কো উঠানে কী লকড়িযাঁ লগাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","সফ়র কে লিএ রৱানা হোতে ৱক়্ত যহ সব কুছ উঠাকর লে জানা ক়িহাতিযোং কী জ়িম্মাদারী হৈ। লেকিন লাজ়িম হৈ কি পহলে হারূন ঔর উসকে বেটে যহ তমাম মুক়দ্দস চীজ়েং ঢাঁপেং। ক়িহাতী ইনমেং সে কোঈ ভী চীজ় ন ছুএঁ ৱরনা মর জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","হারূন ইমাম কা বেটা ইলিযজ়র পূরে মুক়দ্দস খ়ৈমে ঔর উসকে সামান কা ইংচার্জ হো। ইসমেং চরাগ়োং কা তেল, বখ়ূর, গ়ল্লা কী রোজ়ানা নজ়র ঔর মসহ কা তেল ভী শামিল হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“খ়বরদার রহো কি ক়িহাত কে কুংবে লাৱী কে ক়বীলে মেং সে মিটনে ন পাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","চুনাঁচে জব ৱহ মুক়দ্দসতরীন চীজ়োং কে পাস আএঁ তো হারূন ঔর উসকে বেটে হর এক কো উস সামান কে পাস লে জাএঁ জো উসে উঠাকর লে জানা হৈ তাকি ৱহ ন মরেং বল্কি জীতে রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ক়িহাতী এক লমহে কে লিএ ভী মুক়দ্দস চীজ়েং দেখনে কে লিএ অংদর ন জাএঁ, ৱরনা ৱহ মর জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ফির রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“জৈরসোন কী ঔলাদ কী মর্দুমশুমারী ভী উনকে আবাঈ ঘরানোং ঔর কুংবোং কে মুতাবিক় করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","উন তমাম মর্দোং কো রজিস্টর মেং দর্জ করনা জো 30 সে লেকর 50 সাল কে হৈং ঔর মুলাক়াত কে খ়ৈমে মেং খ়িদমত কে লিএ আ সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ৱহ যহ চীজ়েং উঠাকর লে জানে কে জ়িম্মাদার হৈং : ");
INSERT INTO urdgvb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","মুলাক়াত কা খ়ৈমা, উস কী ছত, ছত পর রখী হুঈ তখ়স কী খাল কী পোশিশ, খ়ৈমে কে দরৱাজ়ে কা পরদা, ");
INSERT INTO urdgvb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","খ়ৈমে ঔর ক়ুরবানগাহ কী চারদীৱারী কে পরদে, চারদীৱারী কে দরৱাজ়ে কা পরদা, উসকে রস্সে ঔর উসে লগানে কা বাক়ী সামান। ৱহ উন তমাম কামোং কে জ়িম্মাদার হৈং জো ইন চীজ়োং সে মুংসলিক হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","জৈরসোনিযোং কী পূরী খ়িদমত হারূন ঔর উসকে বেটোং কী হিদাযাত কে মুতাবিক় হো। খ়বরদার রহো কি ৱহ সব কুছ ঐন হিদাযাত কে মুতাবিক় উঠাকর লে জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","যহ সব মুলাক়াত কে খ়ৈমে মেং জৈরসোনিযোং কী জ়িম্মাদারিযাঁ হৈং। ইস কাম মেং হারূন ইমাম কা বেটা ইতমর উন পর মুক়র্রর হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","রব নে কহা, “মিরারী কী ঔলাদ কী মর্দুমশুমারী ভী উনকে আবাঈ ঘরানোং ঔর কুংবোং কে মুতাবিক় করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","উন তমাম মর্দোং কো রজিস্টর মেং দর্জ করনা জো 30 সে লেকর 50 সাল কে হৈং ঔর মুলাক়াত কে খ়ৈমে মেং খ়িদমত কে লিএ আ সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ৱহ মুলাক়াত কে খ়ৈমে কী যহ চীজ়েং উঠাকর লে জানে কে জ়িম্মাদার হৈং : দীৱার কে তখ়্তে, শহতীর, খংবে ঔর পাএ, ");
INSERT INTO urdgvb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ফির খ়ৈমে কী চারদীৱারী কে খংবে, পাএ, মেখ়েং, রস্সে ঔর যহ চীজ়েং লগানে কা সামান। হর এক কো তফ়সীল সে বতানা কি ৱহ ক্যা ক্যা উঠাকর লে জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","যহ সব কুছ মিরারিযোং কী মুলাক়াত কে খ়ৈমে মেং জ়িম্মাদারিযোং মেং শামিল হৈ। ইস কাম মেং হারূন ইমাম কা বেটা ইতমর উন পর মুক়র্রর হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","মূসা, হারূন ঔর জমাত কে রাহনুমাওং নে ক়িহাতিযোং কী মর্দুমশুমারী উনকে কুংবোং ঔর আবাঈ ঘরানোং কে মুতাবিক় কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_35‏","005_4_35‏","NUM","4","35‏","37","উন্হোংনে উন তমাম মর্দোং কো রজিস্টর মেং দর্জ কিযা জো 30 সে লেকর 50 সাল কে থে ঔর জো মুলাক়াত কে খ়ৈমে মেং খ়িদমত কর সকতে থে। উনকী কুল তাদাদ 2,750 থী। মূসা ঔর হারূন নে সব কুছ ৱৈসা হী কিযা জৈসা রব নে মূসা কী মারিফ়ত ফ়রমাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_38‏","005_4_38‏","NUM","4","38‏","41","ফির জৈরসোনিযোং কী মর্দুমশুমারী উনকে কুংবোং ঔর আবাঈ ঘরানোং কে মুতাবিক় হুঈ। খ়িদমত কে লাযক় মর্দোং কী কুল তাদাদ 2,630 থী। মূসা ঔর হারূন নে সব কুছ ৱৈসা হী কিযা জৈসা রব নে মূসা কে জ়রীএ ফ়রমাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_42‏","005_4_42‏","NUM","4","42‏","45","ফির মিরারিযোং কী মর্দুমশুমারী উনকে কুংবোং ঔর আবাঈ ঘরানোং কে মুতাবিক় হুঈ। খ়িদমত কে লাযক় মর্দোং কী কুল তাদাদ 3,200 থী। মূসা ঔর হারূন নে সব কুছ ৱৈসা হী কিযা জৈসা রব নে মূসা কে জ়রীএ ফ়রমাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_46‏","005_4_46‏","NUM","4","46‏","48","লাৱিযোং কে উন মর্দোং কী কুল তাদাদ 8,580 থী জিন্হেং মুলাক়াত কে খ়ৈমে মেং খ়িদমত করনা ঔর সফ়র করতে ৱক়্ত উসে উঠাকর লে জানা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","মূসা নে রব কে হুক্ম কে মুতাবিক় হর এক কো উস কী অপনী অপনী জ়িম্মাদারী সৌংপী ঔর উসে বতাযা কি উসে ক্যা ক্যা উঠাকর লে জানা হৈ। যোং উনকী মর্দুমশুমারী রব কে উস হুক্ম কে ঐন মুতাবিক় কী গঈ জো উসনে মূসা কী মারিফ়ত দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ইসরাঈলিযোং কো হুক্ম দে কি হর উস শখ়্স কো খ়ৈমাগাহ সে বাহর কর দো জিসকো ৱবাঈ জিল্দী বীমারী হৈ, জিসকে জ়খ়মোং সে মাএ নিকলতা রহতা হৈ যা জো কিসী লাশ কো ছূনে সে নাপাক হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","খ়াহ মর্দ হো যা ঔরত, সবকো খ়ৈমাগাহ কে বাহর ভেজ দেনা তাকি ৱহ খ়ৈমাগাহ কো নাপাক ন করেং জহাঁ মৈং তুম্হারে দরমিযান সুকূনত করতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ইসরাঈলিযোং নে ৱৈসা হী কিযা জৈসা রব নে মূসা কো কহা থা। উন্হোংনে রব কে হুক্ম কে ঐন মুতাবিক় ইস তরহ কে তমাম লোগোং কো খ়ৈমাগাহ সে বাহর কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ইসরাঈলিযোং কো হিদাযত দেনা কি জো ভী কিসী সে গ়লত সুলূক করে ৱহ মেরে সাথ বেৱফ়াঈ করতা হৈ ঔর ক়ুসূরৱার হৈ, খ়াহ মর্দ হো যা ঔরত। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","লাজ়িম হৈ কি ৱহ অপনা গুনাহ তসলীম করে ঔর উসকা পূরা মুআৱজ়া দে বল্কি মুতঅস্সিরা শখ়্স কা নুক়সান পূরা করনে কে অলাৱা 20 ফ়ীসদ জ়্যাদা দে। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","লেকিন অগর ৱহ শখ়্স জিসকা ক়ুসূর কিযা গযা থা মর চুকা হো ঔর উসকা কোঈ ৱারিস ন হো জো যহ মুআৱজ়া ৱসূল কর সকে তো ফির উসে রব কো দেনা হৈ। ইমাম কো যহ মুআৱজ়া উস মেংঢে কে অলাৱা মিলেগা জো ক়ুসূরৱার অপনে কফ়্ফ়ারা কে লিএ দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_9‏","005_5_9‏","NUM","5","9‏","10","নীজ় ইমাম কো ইসরাঈলিযোং কী ক়ুরবানিযোং মেং সে ৱহ কুছ মিলনা হৈ জো উঠানেৱালী ক়ুরবানী কে তৌর পর উসে দিযা জাতা হৈ। যহ হিস্সা সির্ফ় ইমামোং কো হী মিলনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ইসরাঈলিযোং কো বতানা, হো সকতা হৈ কি কোঈ শাদীশুদা ঔরত ভটককর অপনে শৌহর সে বেৱফ়া হো জাএ ঔর ");
INSERT INTO urdgvb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","কিসী ঔর সে হমবিসতর হোকর নাপাক হো জাএ। উসকে শৌহর নে উসে নহীং দেখা, ক্যোংকি যহ পোশীদগী মেং হুআ হৈ ঔর ন কিসী নে উসে পকড়া, ন ইসকা কোঈ গৱাহ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","অগর শৌহর কো অপনী বীৱী কী ৱফ়াদারী পর শক হো ঔর ৱহ গ়ৈরত খানে লগে, লেকিন যক়ীন সে নহীং কহ সকতা কি মেরী বীৱী ক়ুসূরৱার হৈ কি নহীং ");
INSERT INTO urdgvb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","তো ৱহ অপনী বীৱী কো ইমাম কে পাস লে আএ। সাথ সাথ ৱহ অপনী বীৱী কে লিএ ক়ুরবানী কে তৌর পর জৌ কা ডেঢ় কিলোগ্রাম বেহতরীন মৈদা লে আএ। ইস পর ন তেল উংডেলা জাএ, ন বখ়ূর ডালা জাএ, ক্যোংকি গ়ল্লা কী যহ নজ়র গ়ৈরত কী নজ়র হৈ জিসকা মক়সদ হৈ কি পোশীদা ক়ুসূর জ়াহির হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","ইমাম ঔরত কো ক়রীব আনে দে ঔর রব কে সামনে খড়া করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ৱহ মিট্টী কা বরতন মুক়দ্দস পানী সে ভরকর উসমেং মক়দিস কে ফ়র্শ কী কুছ খ়াক ডালে। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ফির ৱহ ঔরত কো রব কো পেশ করকে উসকে বাল খুলৱাএ ঔর উসকে হাথোং পর মৈদে কী নজ়র রখে। ইমাম কে অপনে হাথ মেং কড়ৱে পানী কা ৱহ বরতন হো জো লানত কা বাইস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ফির ৱহ ঔরত কো ক়সম খিলাকর কহে, ‘অগর কোঈ ঔর আদমী আপসে হমবিসতর নহীং হুআ হৈ ঔর আপ নাপাক নহীং হুঈ হৈং তো ইস কড়ৱে পানী কী লানত কা আপ পর কোঈ অসর ন হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","লেকিন অগর আপ ভটককর অপনে শৌহর সে বেৱফ়া হো গঈ হৈং ঔর কিসী ঔর সে হমবিসতর হোকর নাপাক হো গঈ হৈং ");
INSERT INTO urdgvb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","তো রব আপকো আপকী ক়ৌম কে সামনে লানতী বনাএ। আপ বাঁঝ হো জাএঁ ঔর আপকা পেট ফূল জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","জব লানত কা যহ পানী আপকে পেট মেং উতরে তো আপ বাঁঝ হো জাএঁ ঔর আপকা পেট ফূল জাএ।’ ইস পর ঔরত কহে, ‘আমীন, ঐসা হী হো।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","ফির ইমাম যহ লানত লিখকর কাগ়জ় কো বরতন কে পানী মেং যোং ধো দে কি উস পর লিখী হুঈ বাতেং পানী মেং ঘুল জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","বাদ মেং ৱহ ঔরত কো যহ পানী পিলাএ তাকি ৱহ উসকে জিস্ম মেং জাকর উসে লানত পহুঁচাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","লেকিন পহলে ইমাম উসকে হাথোং মেং সে গ়ৈরত কী ক়ুরবানী লেকর উসে গ়ল্লা কী নজ়র কে তৌর পর রব কে সামনে হিলাএ ঔর ফির ক়ুরবানগাহ কে পাস লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","উস পর ৱহ মুট্ঠী-ভর যাদগারী কী ক়ুরবানী কে তৌর পর জলাএ। ইসকে বাদ ৱহ ঔরত কো পানী পিলাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","অগর ৱহ অপনে শৌহর সে বেৱফ়া থী ঔর নাপাক হো গঈ হৈ তো ৱহ বাঁঝ হো জাএগী, উসকা পেট ফূল জাএগা ঔর ৱহ অপনী ক়ৌম কে সামনে লানতী ঠহরেগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","লেকিন অগর ৱহ পাক-সাফ় হৈ তো উসে সজ়া নহীং দী জাএগী ঔর ৱহ বচ্চে জন্ম দেনে কে ক়াবিল রহেগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_29‏","005_5_29‏","NUM","5","29‏","30","চুনাঁচে ঐসা হী করনা হৈ জব শৌহর গ়ৈরত খাএ ঔর উসে অপনী বীৱী পর জ়িনা কা শক হো। বীৱী কো ক়ুরবানগাহ কে সামনে খড়া কিযা জাএ ঔর ইমাম যহ সব কুছ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ইস সূরত মেং শৌহর বেক়ুসূর ঠহরেগা, লেকিন অগর উস কী বীৱী নে ৱাক়ঈ জ়িনা কিযা হো তো উসে অপনে গুনাহ কে নতীজে বরদাশ্ত করনে পড়েংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ইসরাঈলিযোং কো হিদাযত দেনা কি অগর কোঈ আদমী যা ঔরত মন্নত মানকর অপনে আপকো এক মুক়র্ররা ৱক়্ত কে লিএ রব কে লিএ মখ়সূস করে ");
INSERT INTO urdgvb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","তো ৱহ মৈ যা কোঈ ঔর নশা-আৱর চীজ় ন পিএ। ন ৱহ অংগূর যা কিসী ঔর চীজ় কা সিরকা পিএ, ন অংগূর কা রস। ৱহ অংগূর যা কিশমিশ ন খাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","জব তক ৱহ মখ়সূস হৈ ৱহ অংগূর কী কোঈ ভী পৈদাৱার ন খাএ, যহাঁ তক কি অংগূর কে বীজ যা ছিলকে ভী ন খাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","জব তক ৱহ অপনী মন্নত কে মুতাবিক় মখ়সূস হৈ ৱহ অপনে বাল ন কটৱাএ। জিতনী দের কে লিএ উসনে অপনে আপকো রব কে লিএ মখ়সূস কিযা হৈ উতনী দের তক ৱহ মুক়দ্দস হৈ। ইসলিএ ৱহ অপনে বাল বঢ়নে দে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","জব তক ৱহ মখ়সূস হৈ ৱহ কিসী লাশ কে ক়রীব ন জাএ, ");
INSERT INTO urdgvb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","চাহে ৱহ উসকে বাপ, মাঁ, ভাঈ যা বহন কী লাশ ক্যোং ন হো। ক্যোংকি ইসসে ৱহ নাপাক হো জাএগা জবকি অভী তক উস কী মখ়সূসিযত লংবে বালোং কী সূরত মেং নজ়র আতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ৱহ অপনী মখ়সূসিযত কে দৌরান রব কে লিএ মখ়সূসো-মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","অগর কোঈ অচানক মর জাএ জব মখ়সূস শখ়্স উসকে ক়রীব হো তো উসকে মখ়সূস বাল নাপাক হো জাএংগে। ঐসী সূরত মেং লাজ়িম হৈ কি ৱহ অপনে আপকো পাক-সাফ় করকে সাতৱেং দিন অপনে সর কো মুঁডৱাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","আঠৱেং দিন ৱহ দো ক়ুম্রিযাঁ যা দো জৱান কবূতর লেকর মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর আএ ঔর ইমাম কো দে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ইমাম ইনমেং সে এক কো গুনাহ কী ক়ুরবানী কে তৌর পর চঢ়াএ ঔর দূসরে কো ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর। যোং ৱহ উসকে লিএ কফ়্ফ়ারা দেগা জো লাশ কে ক়রীব হোনে সে নাপাক হো গযা হৈ। উসী দিন ৱহ অপনে সর কো দুবারা মখ়সূস করে ");
INSERT INTO urdgvb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ঔর অপনে আপকো মুক়র্ররা ৱক়্ত কে লিএ দুবারা রব কে লিএ মখ়সূস করে। ৱহ ক়ুসূর কী ক়ুরবানী কে তৌর পর এক সাল কা ভেড় কা বচ্চা পেশ করে। জিতনে দিন উসনে পহলে মখ়সূসিযত কী হালত মেং গুজ়ারে হৈং ৱহ শুমার নহীং কিএ জা সকতে ক্যোংকি ৱহ মখ়সূসিযত কী হালত মেং নাপাক হো গযা থা। ৱহ দুবারা পহলে দিন সে শুরূ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","শরীঅত কে মুতাবিক় জব মখ়সূস শখ়্স কা মুক়র্ররা ৱক়্ত গুজ়র গযা হো তো পহলে উসে মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর লাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ৱহাঁ ৱহ রব কো ভস্ম হোনেৱালী ক়ুরবানী কে লিএ ভেড় কা এক বেঐব যকসালা নর বচ্চা, গুনাহ কী ক়ুরবানী কে লিএ এক বেঐব যকসালা ভেড় ঔর সলামতী কী ক়ুরবানী কে লিএ এক বেঐব মেংঢা পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ইসকে অলাৱা ৱহ এক টোকরী মেং বেখ়মীরী রোটিযাঁ জিনমেং বেহতরীন মৈদা ঔর তেল মিলাযা গযা হো ঔর বেখ়মীরী রোটিযাঁ জিন পর তেল লগাযা গযা হো মুতাল্লিক়া গ়ল্লা কী নজ়র ঔর মৈ কী নজ়র কে সাথ ");
INSERT INTO urdgvb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","রব কো পেশ করে। পহলে ইমাম গুনাহ কী ক়ুরবানী ঔর ভস্ম হোনেৱালী ক়ুরবানী রব কে হুজ়ূর চঢ়াএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ফির ৱহ মেংঢে কো বেখ়মীরী রোটিযোং কে সাথ সলামতী কী ক়ুরবানী কে তৌর পর পেশ করে। ইমাম গ়ল্লা কী নজ়র ঔর মৈ কী নজ়র ভী চঢ়াএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ইস দৌরান মখ়সূস শখ়্স মুলাক়াত কে খ়ৈমে পর অপনে মখ়সূস কিএ গএ সর কো মুঁডৱাকর তমাম বাল সলামতী কী ক়ুরবানী কী আগ মেং ফেংকে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ফির ইমাম মেংঢে কা এক পকা হুআ শানা ঔর টোকরী মেং সে দোনোং ক়িস্মোং কী এক এক রোটী লেকর মখ়সূস শখ়্স কে হাথোং পর রখে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ইসকে বাদ ৱহ যহ চীজ়েং ৱাপস লেকর উন্হেং হিলানে কী ক়ুরবানী কে তৌর পর রব কে সামনে হিলাএ। যহ এক মুক়দ্দস ক়ুরবানী হৈ জো ইমাম কা হিস্সা হৈ। সলামতী কী ক়ুরবানী কা হিলাযা হুআ সীনা ঔর উঠাঈ হুঈ রান ভী ইমাম কা হিস্সা হৈং। ক়ুরবানী কে ইখ়্তিতাম পর মখ়সূস কিএ হুএ শখ়্স কো মৈ পীনে কী ইজাজ়ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","জো অপনে আপকো রব কে লিএ মখ়সূস করতা হৈ ৱহ ঐসা হী করে। লাজ়িম হৈ কি ৱহ ইন হিদাযাত কে মুতাবিক় তমাম ক়ুরবানিযাঁ পেশ করে। অগর গুংজাইশ হো তো ৱহ ঔর ভী পেশ কর সকতা হৈ। বহরহাল লাজ়িম হৈ কি ৱহ অপনী মন্নত ঔর যহ হিদাযাত পূরী করে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“হারূন ঔর উসকে বেটোং কো বতা দেনা কি ৱহ ইসরাঈলিযোং কো যোং বরকত দেং, ");
INSERT INTO urdgvb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘রব তুঝে বরকত দে ঔর তেরী হিফ়াজ়ত করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","রব অপনে চেহরে কা মেহরবান নূর তুঝ পর চমকাএ ঔর তুঝ পর রহম করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","রব কী নজ়রে-করম তুঝ পর হো, ঔর ৱহ তুঝে সলামতী বখ়্শে।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","যোং ৱহ মেরা নাম লেকর ইসরাঈলিযোং কো বরকত দেং। ফির মৈং উন্হেং বরকত দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","জিস দিন মক়দিস মুকম্মল হুআ উসী দিন মূসা নে উসে মখ়সূসো-মুক়দ্দস কিযা। ইসকে লিএ উসনে খ়ৈমে, উসকে তমাম সামান, ক়ুরবানগাহ ঔর উসকে তমাম সামান পর তেল ছিড়কা। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_2‏","005_7_2‏","NUM","7","2‏","3","ফির ক়বীলোং কে বারহ সরদার মক়দিস কে লিএ হদিযে লেকর আএ। যহ ৱহী রাহনুমা থে জিন্হোংনে মর্দুমশুমারী কে ৱক়্ত মূসা কী মদদ কী থী। উন্হোংনে ছতৱালী ছ: বৈলগাড়িযাঁ ঔর বারহ বৈল খ়ৈমে কে সামনে রব কো পেশ কিএ, দো দো সরদারোং কী তরফ় সে এক বৈলগাড়ী ঔর হর এক সরদার কী তরফ় সে এক বৈল। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“যহ তোহ্ফ়ে ক়বূল করকে মুলাক়াত কে খ়ৈমে কে কাম কে লিএ ইস্তেমাল কর। উন্হেং লাৱিযোং মেং উনকী খ়িদমত কী জ়রূরত কে মুতাবিক় তক়সীম করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","চুনাঁচে মূসা নে বৈলগাড়িযাঁ ঔর বৈল লাৱিযোং কো দে দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","উসনে দো বৈলগাড়িযাঁ চার বৈলোং সমেত জৈরসোনিযোং কো ");
INSERT INTO urdgvb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ঔর চার বৈলগাড়িযাঁ আঠ বৈলোং সমেত মিরারিযোং কো দীং। মিরারী হারূন ইমাম কে বেটে ইতমর কে তহত খ়িদমত করতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","লেকিন মূসা নে ক়িহাতিযোং কো ন বৈলগাড়িযাঁ ঔর ন বৈল দিএ। ৱজহ যহ থী কি জো মুক়দ্দস চীজ়েং উনকে সুপুর্দ থীং ৱহ উনকো কংধোং পর উঠাকর লে জানী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","বারহ সরদার ক়ুরবানগাহ কী মখ়সূসিযত কে মৌক়ে পর ভী হদিযে লে আএ। উন্হোংনে অপনে হদিযে ক়ুরবানগাহ কে সামনে পেশ কিএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","রব নে মূসা সে কহা, “সরদার বারহ দিন কে দৌরান বারী বারী অপনে হদিযে পেশ করেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","পহলে দিন যহূদাহ কে সরদার নহসোন বিন অম্মীনদাব কী বারী থী। উসকে হদিযে যহ থে : ");
INSERT INTO urdgvb_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","চাঁদী কা থাল জিসকা ৱজ়ন ডেঢ় কিলোগ্রাম থা ঔর ছিড়কাৱ কা চাঁদী কা কটোরা জিসকা ৱজ়ন 800 গ্রাম থা। দোনোং গ়ল্লা কী নজ়র কে লিএ তেল কে সাথ মিলাএ গএ বেহতরীন মৈদে সে ভরে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ইনকে অলাৱা নহসোন নে যহ চীজ়েং পেশ কীং : সোনে কা প্যালা জিসকা ৱজ়ন 110 গ্রাম থা ঔর জো বখ়ূর সে ভরা হুআ থা, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","এক জৱান বৈল, এক মেংঢা, ভস্ম হোনেৱালী ক়ুরবানী কে লিএ ভেড় কা এক যকসালা বচ্চা, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","গুনাহ কী ক়ুরবানী কে লিএ এক বকরা ");
INSERT INTO urdgvb_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ঔর সলামতী কী ক়ুরবানী কে লিএ দো বৈল, পাঁচ মেংঢে, পাঁচ বকরে ঔর ভেড় কে পাঁচ যকসালা বচ্চে। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_18‏","005_7_18‏","NUM","7","18‏","23","অগলে গ্যারহ দিন বাক়ী সরদার ভী যহী হদিযে মক়দিস কে পাস লে আএ। দূসরে দিন ইশকার কে সরদার নতনিযেল বিন জ়ুগ়র কী বারী থী, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_24‏","005_7_24‏","NUM","7","24‏","29","তীসরে দিন জ়বূলূন কে সরদার ইলিযাব বিন হেলোন কী, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_30‏","005_7_30‏","NUM","7","30‏","47","চৌথে দিন রূবিন কে সরদার ইলীসূর বিন শদিযূর কী, পাঁচৱেং দিন শমৌন কে সরদার সলূমিযেল বিন সূরীশদ্দী কী, ছটে দিন জদ কে সরদার ইলিযাসফ় বিন দঊএল কী, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_48‏","005_7_48‏","NUM","7","48‏","53","সাতৱেং দিন ইফ়রাঈম কে সরদার ইলীসমা বিন অম্মীহূদ কী, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_54‏","005_7_54‏","NUM","7","54‏","71","আঠৱেং দিন মনস্সী কে সরদার জমলিযেল বিন ফ়দাহসূর কী, নৱেং দিন বিনযমীন কে সরদার অবিদান বিন জিদৌনী কী, দসৱেং দিন দান কে সরদার অখ়িযজ়র বিন অম্মীশদ্দী কী, ");
INSERT INTO urdgvb_vpl VALUES ("NU7_72‏","005_7_72‏","NUM","7","72‏","83","গ্যারহৱেং দিন আশর কে সরদার ফ়জিযেল বিন অকরান কী ঔর বারহৱেং দিন নফ়তালী কে সরদার অখ়ীরা বিন এনান কী বারী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ইসরাঈল কে ইন সরদারোং নে মিলকর ক়ুরবানগাহ কী মখ়সূসিযত কে লিএ চাঁদী কে 12 থাল, ছিড়কাৱ কে চাঁদী কে 12 কটোরে ঔর সোনে কে 12 প্যালে পেশ কিএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","হর থাল কা ৱজ়ন ডেঢ় কিলোগ্রাম ঔর ছিড়কাৱ কে হর কটোরে কা ৱজ়ন 800 গ্রাম থা। ইন চীজ়োং কা কুল ৱজ়ন তক়রীবন 28 কিলোগ্রাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","বখ়ূর সে ভরে হুএ সোনে কে প্যালোং কা কুল ৱজ়ন তক়রীবন ডেঢ় কিলোগ্রাম থা (ফ়ী প্যালা 110 গ্রাম)। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","সরদারোং নে মিলকর ভস্ম হোনেৱালী ক়ুরবানী কে লিএ 12 জৱান বৈল, 12 মেংঢে ঔর ভেড় কে 12 যকসালা বচ্চে উনকী গ়ল্লা কী নজ়রোং সমেত পেশ কিএ। গুনাহ কী ক়ুরবানী কে লিএ উন্হোংনে 12 বকরে পেশ কিএ ");
INSERT INTO urdgvb_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ঔর সলামতী কী ক়ুরবানী কে লিএ 24 বৈল, 60 মেংঢে, 60 বকরে ঔর ভেড় কে 60 যকসালা বচ্চে। ইন তমাম জানৱরোং কো ক়ুরবানগাহ কী মখ়সূসিযত কে মৌক়ে পর চঢ়াযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","জব মূসা মুলাক়াত কে খ়ৈমে মেং রব কে সাথ বাত করনে কে লিএ দাখ়িল হোতা থা তো ৱহ রব কী আৱাজ় অহদ কে সংদূক় কে ঢকনে পর সে যানী দো করূবী ফ়রিশ্তোং কে দরমিযান সে সুনতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“হারূন কো বতানা, ‘তুঝে সাত চরাগ়োং কো শমাদান পর যোং রখনা হৈ কি ৱহ শমাদান কা সামনেৱালা হিস্সা রৌশন করেং’।” ");
INSERT INTO urdgvb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","হারূন নে ঐসা হী কিযা। জিস তরহ রব নে মূসা কো হুক্ম দিযা থা উসী তরহ উসনে চরাগ়োং কো রখ দিযা তাকি ৱহ সামনেৱালা হিস্সা রৌশন করেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","শমাদান পাএ সে লেকর ঊপর কী কলিযোং তক সোনে কে এক ঘড়ে হুএ টুকড়ে কা বনা হুআ থা। মূসা নে উসে উস নমূনে কে ঐন মুতাবিক় বনৱাযা জো রব নে উসে দিখাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“লাৱিযোং কো দীগর ইসরাঈলিযোং সে অলগ করকে পাক-সাফ় করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ইসকে লিএ গুনাহ সে পাক করনেৱালা পানী উন পর ছিড়ককর উন্হেং হুক্ম দেনা কি অপনে জিস্ম কে পূরে বাল মুঁডৱাও ঔর অপনে কপড়ে ধোও। যোং ৱহ পাক-সাফ় হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ফির ৱহ এক জৱান বৈল চুনেং ঔর সাথ কী গ়ল্লা কী নজ়র কে লিএ তেল কে সাথ মিলাযা গযা বেহতরীন মৈদা লেং। তূ খ়ুদ ভী এক জৱান বৈল চুন। ৱহ গুনাহ কী ক়ুরবানী কে লিএ হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ইসকে বাদ লাৱিযোং কো মুলাক়াত কে খ়ৈমে কে সামনে খড়া করকে ইসরাঈল কী পূরী জমাত কো ৱহাঁ জমা করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","জব লাৱী রব কে সামনে খড়ে হোং তো বাক়ী ইসরাঈলী উনকে সরোং পর অপনে হাথ রখেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ফির হারূন লাৱিযোং কো রব কে সামনে পেশ করে। উন্হেং ইসরাঈলিযোং কী তরফ় সে হিলাঈ হুঈ ক়ুরবানী কী হৈসিযত সে পেশ কিযা জাএ তাকি ৱহ রব কী খ়িদমত কর সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ফির লাৱী অপনে হাথ দোনোং বৈলোং কে সরোং পর রখেং। এক বৈল কো গুনাহ কী ক়ুরবানী কে তৌর পর ঔর দূসরে কো ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর চঢ়াও তাকি লাৱিযোং কা কফ়্ফ়ারা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","লাৱিযোং কো ইস তরীক়ে সে হারূন ঔর উসকে বেটোং কে সামনে খড়া করকে রব কো হিলাঈ হুঈ ক়ুরবানী কে তৌর পর পেশ করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","উন্হেং বাক়ী ইসরাঈলিযোং সে অলগ করনে সে ৱহ মেরা হিস্সা বনেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ইসকে বাদ হী ৱহ মুলাক়াত কে খ়ৈমে মেং আকর খ়িদমত করেং, ক্যোংকি অব ৱহ খ়িদমত করনে কে লাযক় হৈং। উন্হেং পাক-সাফ় করকে হিলাঈ হুঈ ক়ুরবানী কে তৌর পর পেশ করনে কা সবব যহ হৈ ");
INSERT INTO urdgvb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","কি লাৱী ইসরাঈলিযোং মেং সে ৱহ হৈং জো মুঝে পূরে তৌর পর দিএ গএ হৈং। মৈংনে উন্হেং ইসরাঈলিযোং কে তমাম পহলৌঠোং কী জগহ লে লিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ক্যোংকি ইসরাঈল মেং হর পহলৌঠা মেরা হৈ, খ়াহ ৱহ ইনসান কা হো যা হৈৱান কা। উস দিন জব মৈংনে মিসরিযোং কে পহলৌঠোং কো মার দিযা মৈংনে ইসরাঈল কে পহলৌঠোং কো অপনে লিএ মখ়সূসো-মুক়দ্দস কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ইস সিলসিলে মেং মৈংনে লাৱিযোং কো ইসরাঈলিযোং কে তমাম পহলৌঠোং কী জগহ লেকর ");
INSERT INTO urdgvb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","উন্হেং হারূন ঔর উসকে বেটোং কো দিযা হৈ। ৱহ মুলাক়াত কে খ়ৈমে মেং ইসরাঈলিযোং কী খ়িদমত করেং ঔর উনকে লিএ কফ়্ফ়ারা কা ইংতজ়াম ক়াযম রখেং তাকি জব ইসরাঈলী মক়দিস কে ক়রীব আএঁ তো উনকো ৱবা সে মারা ন জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","মূসা, হারূন ঔর ইসরাঈলিযোং কী পূরী জমাত নে এহতিযাত সে রব কী লাৱিযোং কে বারে মেং হিদাযাত পর অমল কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","লাৱিযোং নে অপনে আপকো গুনাহোং সে পাক-সাফ় করকে অপনে কপড়োং কো ধোযা। ফির হারূন নে উন্হেং রব কে সামনে হিলাঈ হুঈ ক়ুরবানী কে তৌর পর পেশ কিযা ঔর উনকা কফ়্ফ়ারা দিযা তাকি ৱহ পাক হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ইসকে বাদ লাৱী মুলাক়াত কে খ়ৈমে মেং আএ তাকি হারূন ঔর উসকে বেটোং কে তহত খ়িদমত করেং। যোং সব কুছ ৱৈসা হী কিযা গযা জৈসা রব নে মূসা কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","রব নে মূসা সে যহ ভী কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“লাৱী 25 সাল কী উম্র মেং মুলাক়াত কে খ়ৈমে মেং অপনী খ়িদমত শুরূ করেং ");
INSERT INTO urdgvb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ঔর 50 সাল কী উম্র মেং রিটাযর হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ইসকে বাদ ৱহ মুলাক়াত কে খ়ৈমে মেং অপনে ভাইযোং কী মদদ কর সকতে হৈং, লেকিন খ়ুদ খ়িদমত নহীং কর সকতে। তুঝে লাৱিযোং কো ইন হিদাযাত কে মুতাবিক় উনকী অপনী অপনী জ়িম্মাদারিযাঁ দেনী হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ইসরাঈলিযোং কো মিসর সে নিকলে এক সাল হো গযা থা। দূসরে সাল কে পহলে মহীনে মেং রব নে দশ্তে-সীনা মেং মূসা সে বাত কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“লাজ়িম হৈ কি ইসরাঈলী ঈদে-ফ়সহ কো মুক়র্ররা ৱক়্ত পর মনাএঁ, ");
INSERT INTO urdgvb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","যানী ইস মহীনে কে চৌধৱেং দিন, সূরজ কে গ়ুরূব হোনে কে ঐন বাদ। উসে তমাম ক়ৱাযদ কে মুতাবিক় মনানা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","চুনাঁচে মূসা নে ইসরাঈলিযোং সে কহা কি ৱহ ঈদে-ফ়সহ মনাএঁ, ");
INSERT INTO urdgvb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ঔর উন্হোংনে ঐসা হী কিযা। উন্হোংনে ঈদে-ফ়সহ কো পহলে মহীনে কে চৌধৱেং দিন সূরজ কে গ়ুরূব হোনে কে ঐন বাদ মনাযা। উন্হোংনে সব কুছ ৱৈসা হী কিযা জৈসা রব নে মূসা কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","লেকিন কুছ আদমী নাপাক থে, ক্যোংকি উন্হোংনে লাশ ছূ লী থী। ইস ৱজহ সে ৱহ উস দিন ঈদে-ফ়সহ ন মনা সকে। ৱহ মূসা ঔর হারূন কে পাস আকর ");
INSERT INTO urdgvb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","কহনে লগে, “হমনে লাশ ছূ লী হৈ, ইসলিএ নাপাক হৈং। লেকিন হমেং ইস সবব সে ঈদে-ফ়সহ কো মনানে সে ক্যোং রোকা জাএ? হম ভী মুক়র্ররা ৱক়্ত পর বাক়ী ইসরাঈলিযোং কে সাথ রব কী ক়ুরবানী পেশ করনা চাহতে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","মূসা নে জৱাব দিযা, “যহাঁ মেরে ইংতজ়ার মেং খড়ে রহো। মৈং মালূম করতা হূঁ কি রব তুম্হারে বারে মেং ক্যা হুক্ম দেতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ইসরাঈলিযোং কো বতা দেনা কি অগর তুম যা তুম্হারী ঔলাদ মেং সে কোঈ ঈদে-ফ়সহ কে দৌরান লাশ ছূনে সে নাপাক হো যা কিসী দূর-দরাজ় ইলাক়ে মেং সফ়র কর রহা হো, তো ভী ৱহ ঈদ মনা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ঐসা শখ়্স উসে ঐন এক মাহ কে বাদ মনাকর লেলে কে সাথ বেখ়মীরী রোটী ঔর কড়ৱা সাগ-পাত খাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","খানে মেং সে কুছ ভী অগলী সুবহ তক বাক়ী ন রহে। জানৱর কী কোঈ ভী হড্ডী ন তোড়না। মনানেৱালা ঈদে-ফ়সহ কে পূরে ফ়রাযজ় অদা করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","লেকিন জো পাক হোনে ঔর সফ়র ন করনে কে বাৱুজূদ ভী ঈদে-ফ়সহ কো ন মনাএ উসে উস কী ক়ৌম মেং সে মিটাযা জাএ, ক্যোংকি উসনে মুক়র্ররা ৱক়্ত পর রব কো ক়ুরবানী পেশ নহীং কী। উস শখ়্স কো অপনে গুনাহ কা নতীজা ভুগতনা পড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","অগর কোঈ পরদেসী তুম্হারে দরমিযান রহতে হুএ রব কে সামনে ঈদে-ফ়সহ মনানা চাহে তো উসে ইজাজ়ত হৈ। শর্ত যহ হৈ কি ৱহ পূরে ফ়রাযজ় অদা করে। পরদেসী ঔর দেসী কে লিএ ঈদে-ফ়সহ মনানে কে ফ়রাযজ় এক জৈসে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","জিস দিন শরীঅত কে মুক়দ্দস খ়ৈমে কো খড়া কিযা গযা উস দিন বাদল আকর উস পর ছা গযা। রাত কে ৱক়্ত বাদল আগ কী সূরত মেং নজ়র আযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ইসকে বাদ যহী সূরতে-হাল রহী কি বাদল উস পর ছাযা রহতা ঔর রাত কে দৌরান আগ কী সূরত মেং নজ়র আতা। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","জব ভী বাদল খ়ৈমে পর সে উঠতা ইসরাঈলী রৱানা হো জাতে। জহাঁ ভী বাদল উতর জাতা ৱহাঁ ইসরাঈলী অপনে ডেরে ডালতে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ইসরাঈলী রব কে হুক্ম পর রৱানা হোতে ঔর উসকে হুক্ম পর ডেরে ডালতে। জব তক বাদল মক়দিস পর ছাযা রহতা উস ৱক়্ত তক ৱহ ৱহীং ঠহরতে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","কভী কভী বাদল বড়ী দের তক খ়ৈমে পর ঠহরা রহতা। তব ইসরাঈলী রব কা হুক্ম মানকর রৱানা ন হোতে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","কভী কভী বাদল সির্ফ় দো-চার দিন কে লিএ খ়ৈমে পর ঠহরতা। ফির ৱহ রব কে হুক্ম কে মুতাবিক় হী ঠহরতে ঔর রৱানা হোতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","কভী কভী বাদল সির্ফ় শাম সে লেকর সুবহ তক খ়ৈমে পর ঠহরতা। জব ৱহ সুবহ কে ৱক়্ত উঠতা তো ইসরাঈলী ভী রৱানা হোতে থে। জব ভী বাদল উঠতা ৱহ ভী রৱানা হো জাতে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","জব তক বাদল মুক়দ্দস খ়ৈমে পর ছাযা রহতা উস ৱক়্ত তক ইসরাঈলী রৱানা ন হোতে, চাহে ৱহ দো দিন, এক মাহ, এক সাল যা ইসসে জ়্যাদা অরসা মক়দিস পর ছাযা রহতা। লেকিন জব ৱহ উঠতা তো ইসরাঈলী ভী রৱানা হো জাতে। ");
INSERT INTO urdgvb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ৱহ রব কে হুক্ম পর খ়ৈমে লগাতে ঔর উসকে হুক্ম পর রৱানা হোতে থে। ৱহ ৱৈসা হী করতে থে জৈসা রব মূসা কী মারিফ়ত ফ়রমাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“চাঁদী কে দো বিগুল ঘড়কর বনৱা লে। উন্হেং জমাত কো জমা করনে ঔর ক়বীলোং কো রৱানা করনে কে লিএ ইস্তেমাল কর। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","জব দোনোং কো দের তক বজাযা জাএ তো পূরী জমাত মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর আকর তেরে সামনে জমা হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","লেকিন অগর এক হী বজাযা জাএ তো সির্ফ় কুংবোং কে বুজ়ুর্গ তেরে সামনে জমা হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","অগর উনকী আৱাজ় সির্ফ় থোড়ী দের কে লিএ সুনাঈ দে তো মক়দিস কে মশরিক় মেং মৌজূদ ক়বীলে রৱানা হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ফির জব উনকী আৱাজ় দূসরী বার থোড়ী দের কে লিএ সুনাঈ দে তো মক়দিস কে জুনূব মেং মৌজূদ ক়বীলে রৱানা হো জাএঁ। জব উনকী আৱাজ় থোড়ী দের কে লিএ সুনাঈ দে তো যহ রৱানা হোনে কা এলান হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ইসকে মুক়াবলে মেং জব উনকী আৱাজ় দের তক সুনাঈ দে তো যহ ইস বাত কা এলান হোগা কি জমাত জমা হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","বিগুল বজানে কী জ়িম্মাদারী হারূন কে বেটোং যানী ইমামোং কো দী জাএ। যহ তুম্হারে ঔর আনেৱালী নসলোং কে লিএ দাযমী উসূল হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","উনকী আৱাজ় উস ৱক়্ত ভী থোড়ী দের কে লিএ সুনা দো জব তুম অপনে মুল্ক মেং কিসী জ়ালিম দুশ্মন সে জংগ লড়নে কে লিএ নিকলোগে। তব রব তুম্হারা খ়ুদা তুম্হেং যাদ করকে দুশ্মন সে বচাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ইসী তরহ উনকী আৱাজ় মক়দিস মেং খ়ুশী কে মৌক়োং পর সুনাঈ দে যানী মুক়র্ররা ঈদোং ঔর নএ চাঁদ কী ঈদোং পর। ইন মৌক়োং পর ৱহ ভস্ম হোনেৱালী ক়ুরবানিযাঁ ঔর সলামতী কী ক়ুরবানিযাঁ চঢ়াতে ৱক়্ত বজাএ জাএঁ। ফির তুম্হারা খ়ুদা তুম্হেং যাদ করেগা। মৈং রব তুম্হারা খ়ুদা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ইসরাঈলিযোং কো মিসর সে নিকলে এক সাল সে জ়াযদ অরসা হো চুকা থা। দূসরে মহীনে কে বীসৱেং দিন বাদল মুলাক়াত কে খ়ৈমে পর সে উঠা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ফির ইসরাঈলী মুক়র্ররা তরতীব কে মুতাবিক় দশ্তে-সীনা সে রৱানা হুএ। চলতে চলতে বাদল ফ়ারান কে রেগিস্তান মেং উতর আযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","উস ৱক়্ত ৱহ পহলী দফ়া উস তরতীব সে রৱানা হুএ জো রব নে মূসা কী মারিফ়ত মুক়র্রর কী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","পহলে যহূদাহ কে ক়বীলে কে তীন দস্তে অপনে অলম কে তহত চল পড়ে। তীনোং কা কমাঁডর নহসোন বিন অম্মীনদাব থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","সাথ চলনেৱালে ক়বীলে ইশকার কা কমাঁডর নতনিযেল বিন জ়ুগ়র থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","জ়বূলূন কা ক়বীলা ভী সাথ চলা জিসকা কমাঁডর ইলিযাব বিন হেলোন থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ইসকে বাদ মুলাক়াত কা খ়ৈমা উতারা গযা। জৈরসোনী ঔর মিরারী উসে উঠাকর চল দিএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ইন লাৱিযোং কে বাদ রূবিন কে ক়বীলে কে তীন দস্তে অপনে অলম কে তহত চলনে লগে। তীনোং কা কমাঁডর ইলীসূর বিন শদিযূর থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","সাথ চলনেৱালে ক়বীলে শমৌন কা কমাঁডর সলূমিযেল বিন সূরীশদ্দী থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","জদ কা ক়বীলা ভী সাথ চলা জিসকা কমাঁডর ইলিযাসফ় বিন দঊএল থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ফির লাৱিযোং মেং সে ক়িহাতী মক়দিস কা সামান উঠাকর রৱানা হুএ। লাজ়িম থা কি উনকে অগলী মনজ়িল পর পহুঁচনে তক মুলাক়াত কা খ়ৈমা লগা দিযা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ইসকে বাদ ইফ়রাঈম কে ক়বীলে কে তীন দস্তে অপনে অলম কে তহত চল দিএ। উনকা কমাঁডর ইলীসমা বিন অম্মীহূদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ইফ়রাঈম কে সাথ চলনেৱালে ক়বীলে মনস্সী কা কমাঁডর জমলিযেল বিন ফ়দাহসূর থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","বিনযমীন কা ক়বীলা ভী সাথ চলা জিসকা কমাঁডর অবিদান বিন জিদৌনী থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","আখ়ির মেং দান কে তীন দস্তে অক়বী মুহাফ়িজ় কে তৌর পর অপনে অলম কে তহত রৱানা হুএ। উনকা কমাঁডর অখ়িযজ়র বিন অম্মীশদ্দী থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","দান কে সাথ চলনেৱালে ক়বীলে আশর কা কমাঁডর ফ়জিযেল বিন অকরান থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","নফ়তালী কা ক়বীলা ভী সাথ চলা জিসকা কমাঁডর অখ়ীরা বিন এনান থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ইসরাঈলী ইসী তরতীব সে রৱানা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","মূসা নে অপনে মিদিযানী সুসর রঊএল যানী যিতরো কে বেটে হোবাব সে কহা, “হম উস জগহ কে লিএ রৱানা হো রহে হৈং জিসকা ৱাদা রব নে হমসে কিযা হৈ। হমারে সাথ চলেং! হম আপ পর এহসান করেংগে, ক্যোংকি রব নে ইসরাঈল পর এহসান করনে কা ৱাদা কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","লেকিন হোবাব নে জৱাব দিযা, “মৈং সাথ নহীং জাঊঁগা বল্কি অপনে মুল্ক ঔর রিশ্তেদারোং কে পাস ৱাপস চলা জাঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","মূসা নে কহা, “মেহরবানী করকে হমেং ন ছোড়েং। ক্যোংকি আপ হী জানতে হৈং কি হম রেগিস্তান মেং কহাঁ কহাঁ অপনে ডেরে ডাল সকতে হৈং। আপ রেগিস্তান মেং হমেং রাস্তা দিখা সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","অগর আপ হমারে সাথ জাএঁ তো হম আপকো উস এহসান মেং শরীক করেংগে জো রব হম পর করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","চুনাঁচে উন্হোংনে রব কে পহাড় সে রৱানা হোকর তীন দিন সফ়র কিযা। ইস দৌরান রব কা অহদ কা সংদূক় উনকে আগে আগে চলা তাকি উনকে লিএ আরাম করনে কী জগহ মালূম করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","জব কভী ৱহ রৱানা হোতে তো রব কা বাদল দিন কে ৱক়্ত উনকে ঊপর রহতা। ");
INSERT INTO urdgvb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","সংদূক় কে রৱানা হোতে ৱক়্ত মূসা কহতা, “ঐ রব, উঠ। তেরে দুশ্মন তিত্তর-বিত্তর হো জাএঁ। তুঝসে নফ়রত করনেৱালে তেরে সামনে সে ফ়রার হো জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ঔর জব ভী ৱহ রুক জাতা তো মূসা কহতা, “ঐ রব, ইসরাঈল কে হজ়ারোং খ়ানদানোং কে পাস ৱাপস আ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","এক দিন লোগ খ়ূব শিকাযত করনে লগে। জব যহ শিকাযতেং রব তক পহুঁচীং তো উসে গ়ুস্সা আযা ঔর উস কী আগ উনকে দরমিযান ভড়ক উঠী। জলতে জলতে উসনে খ়ৈমাগাহ কা এক কিনারা ভস্ম কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","লোগ মদদ কে লিএ মূসা কে পাস আকর চিল্লানে লগে তো উসনে রব সে দুআ কী, ঔর আগ বুঝ গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","উস মক়াম কা নাম তবএরা যানী জলনা পড় গযা, ক্যোংকি রব কী আগ উনকে দরমিযান জল উঠী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ইসরাঈলিযোং কে সাথ জো অজনবী সফ়র কর রহে থে ৱহ গোশ্ত খানে কী শদীদ আরজ়ূ করনে লগে। তব ইসরাঈলী ভী রো পড়ে ঔর কহনে লগে, “কৌন হমেং গোশ্ত খিলাএগা? ");
INSERT INTO urdgvb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","মিসর মেং হম মছলী মুফ়্ত খা সকতে থে। হায, ৱহাঁ কে খীরে, তরবূজ়, গংদনে, প্যাজ় ঔর লহসন কিতনে অচ্ছে থে! ");
INSERT INTO urdgvb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","লেকিন অব তো হমারী জান সূখ গঈ হৈ। যহাঁ বস মন হী মন নজ়র আতা রহতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","মন ধনিযে কে দানোং কী মানিংদ থা, ঔর উসকা রংগ গূগল কে গূঁদ কী মানিংদ থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_8‏","005_11_8‏","NUM","11","8‏","9","রাত কে ৱক়্ত ৱহ খ়ৈমাগাহ মেং ওস কে সাথ জ়মীন পর গিরতা থা। সুবহ কে ৱক়্ত লোগ ইধর-উধর ঘুমতে-ফিরতে হুএ উসে জমা করতে থে। ফির ৱহ উসে চক্কী মেং পীসকর যা উখলী মেং কূটকর উবালতে যা রোটী বনাতে থে। উসকা জ়াযক়া ঐসী রোটী কা-সা থা জিসমেং জ়ৈতূন কা তেল ডালা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","তমাম খ়ানদান অপনে অপনে খ়ৈমে কে দরৱাজ়ে পর রোনে লগে তো রব কো শদীদ গ়ুস্সা আযা। উনকা শোর মূসা কো ভী বহুত বুরা লগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","উসনে রব সে পূছা, “তূনে অপনে খ়াদিম কে সাথ ইতনা বুরা সুলূক ক্যোং কিযা? মৈংনে কিস কাম সে তুঝে ইতনা নারাজ় কিযা কি তূনে ইন তমাম লোগোং কা বোঝ মুঝ পর ডাল দিযা? ");
INSERT INTO urdgvb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ক্যা মৈংনে হামিলা হোকর ইস পূরী ক়ৌম কো জন্ম দিযা কি তূ মুঝসে কহতা হৈ, ‘ইসে উস তরহ উঠাকর লে চলনা জিস তরহ আযা শীরখ়ার বচ্চে কো উঠাকর হর জগহ সাথ লিএ ফিরতী হৈ। ইসী তরহ ইসে উস মুল্ক মেং লে জানা জিসকা ৱাদা মৈংনে ক়সম খাকর ইনকে বাপদাদা সে কিযা হৈ।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ঐ অল্লাহ, মৈং ইন তমাম লোগোং কো কহাঁ সে গোশ্ত মুহৈযা করূঁ? ৱহ মেরে সামনে রোতে রহতে হৈং কি হমেং খানে কে লিএ গোশ্ত দো। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","মৈং অকেলা ইন তমাম লোগোং কী জ়িম্মাদারী নহীং উঠা সকতা। যহ বোঝ মেরে লিএ হদ সে জ়্যাদা ভারী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","অগর তূ ইস পর ইসরার করে তো ফির বেহতর হৈ কি অভী মুঝে মার দে তাকি মৈং অপনী তবাহী ন দেখূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","জৱাব মেং রব নে মূসা সে কহা, “মেরে পাস ইসরাঈল কে 70 বুজ়ুর্গ জমা কর। সির্ফ় ঐসে লোগ চুন জিনকে বারে মেং তুঝে মালূম হৈ কি ৱহ লোগোং কে বুজ়ুর্গ ঔর নিগহবান হৈং। উন্হেং মুলাক়াত কে খ়ৈমে কে পাস লে আ। ৱহাঁ ৱহ তেরে সাথ খড়ে হো জাএঁ, ");
INSERT INTO urdgvb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","তো মৈং উতরকর তেরে সাথ হমকলাম হূঁগা। উস ৱক়্ত মৈং উস রূহ মেং সে কুছ লূঁগা জো মৈংনে তুঝ পর নাজ়িল কিযা থা ঔর উসে উন পর নাজ়িল করূঁগা। তব ৱহ ক়ৌম কা বোঝ উঠানে মেং তেরী মদদ করেংগে ঔর তূ ইসমেং অকেলা নহীং রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","লোগোং কো বতানা, ‘অপনে আপকো মখ়সূসো-মুক়দ্দস করো, ক্যোংকি কল তুম গোশ্ত খাওগে। রব নে তুম্হারী সুনী জব তুম রো পড়ে কি কৌন হমেং গোশ্ত খিলাএগা, মিসর মেং হমারী হালত বেহতর থী। অব রব তুম্হেং গোশ্ত মুহৈযা করেগা ঔর তুম উসে খাওগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","তুম উসে ন সির্ফ় এক, দো যা পাঁচ দিন খাওগে বল্কি 10 যা 20 দিন সে ভী জ়্যাদা অরসে তক। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","তুম এক পূরা মহীনা খ়ূব গোশ্ত খাওগে, যহাঁ তক কি ৱহ তুম্হারী নাক সে নিকলেগা ঔর তুম্হেং উসসে ঘিন আএগী। ঔর যহ ইস সবব সে হোগা কি তুমনে রব কো জো তুম্হারে দরমিযান হৈ রদ্দ কিযা ঔর রোতে রোতে উসকে সামনে কহা কি হম ক্যোং মিসর সে নিকলে’।” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","লেকিন মূসা নে এতরাজ় কিযা, “অগর ক়ৌম কে পৈদল চলনেৱালে গিনে জাএঁ তো ছঃ লাখ হৈং। তূ কিস তরহ হমেং এক মাহ তক গোশ্ত মুহৈযা করেগা? ");
INSERT INTO urdgvb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ক্যা গায-বৈলোং যা ভেড়-বকরিযোং কো ইতনী মিক়দার মেং জ়বহ কিযা জা সকতা হৈ কি কাফ়ী হো? অগর সমুংদর কী তমাম মছলিযাঁ উনকে লিএ পকড়ী জাএঁ তো ক্যা কাফ়ী হোংগী?” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","রব নে কহা, “ক্যা রব কা ইখ়্তিযার কম হৈ? অব তূ খ়ুদ দেখ লেগা কি মেরী বাতেং দুরুস্ত হৈং কি নহীং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","চুনাঁচে মূসা নে ৱহাঁ সে নিকলকর লোগোং কো রব কী যহ বাতেং বতাঈং। উসনে উনকে বুজ়ুর্গোং মেং সে 70 কো চুনকর উন্হেং মুলাক়াত কে খ়ৈমে কে ইর্দগির্দ খড়া কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","তব রব বাদল মেং উতরকর মূসা সে হমকলাম হুআ। জো রূহ উসনে মূসা পর নাজ়িল কিযা থা উসমেং সে উসনে কুছ লেকর উন 70 বুজ়ুর্গোং পর নাজ়িল কিযা। জব রূহ উন পর আযা তো ৱহ নবুৱ্ৱত করনে লগে। লেকিন ঐসা ফির কভী ন হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","অব ঐসা হুআ কি ইন সত্তর বুজ়ুর্গোং মেং সে দো খ়ৈমাগাহ মেং রহ গএ থে। উনকে নাম ইলদাদ ঔর মেদাদ থে। উন্হেং চুনা তো গযা থা লেকিন ৱহ মুলাক়াত কে খ়ৈমে কে পাস নহীং আএ থে। ইসকে বাৱুজূদ রূহ উন পর ভী নাজ়িল হুআ ঔর ৱহ খ়ৈমাগাহ মেং নবুৱ্ৱত করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","এক নৌজৱান ভাগকর মূসা কে পাস আযা ঔর কহা, “ইলদাদ ঔর মেদাদ খ়ৈমাগাহ মেং হী নবুৱ্ৱত কর রহে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","যশুঅ বিন নূন জো জৱানী সে মূসা কা মদদগার থা বোল উঠা, “মূসা মেরে আক়া, উন্হেং রোক দেং!” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","লেকিন মূসা নে জৱাব দিযা, “ক্যা তূ মেরী খ়াতির গ়ৈরত খা রহা হৈ? কাশ রব কে তমাম লোগ নবী হোতে ঔর ৱহ উন সব পর অপনা রূহ নাজ়িল করতা!” ");
INSERT INTO urdgvb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ফির মূসা ঔর ইসরাঈল কে বুজ়ুর্গ খ়ৈমাগাহ মেং ৱাপস আএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","তব রব কী তরফ় সে জ়োরদার হৱা চলনে লগী জিসনে সমুংদর কো পার করনেৱালে বটেরোং কে গ়োল ধকেলকর খ়ৈমাগাহ কে ইর্দগির্দ জ়মীন পর ফেংক দিএ। উনকে গ়োল তীন ফ়ুট ঊঁচে ঔর খ়ৈমাগাহ কে চারোং তরফ় 30 কিলোমীটর তক পড়ে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","উস পূরে দিন ঔর রাত ঔর অগলে পূরে দিন লোগ নিকলকর বটেরেং জমা করতে রহে। হর এক নে কম অজ় কম দস বড়ী টোকরিযাঁ ভর লীং। ফির উন্হোংনে উনকা গোশ্ত খ়ৈমে কে ইর্দগির্দ জ়মীন পর ফৈলা দিযা তাকি ৱহ খ়ুশ্ক হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","লেকিন গোশ্ত কে পহলে টুকড়ে অভী মুঁহ মেং থে কি রব কা গ়জ়ব উন পর আন পড়া, ঔর উসনে উনমেং সখ়্ত ৱবা ফৈলনে দী। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","চুনাঁচে মক়াম কা নাম ক়ব্রোত-হত্তাৱা যানী ‘লালচ কী ক়ব্রেং’ রখা গযা, ক্যোংকি ৱহাঁ উন্হোংনে উন লোগোং কো দফ়ন কিযা জো গোশ্ত কে লালচ মেং আ গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ইসকে বাদ ইসরাঈলী ক়ব্রোত-হত্তাৱা সে রৱানা হোকর হসীরাত পহুঁচ গএ। ৱহাঁ ৱহ খ়ৈমাজ়ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","এক দিন মরিযম ঔর হারূন মূসা কে খ়িলাফ় বাতেং করনে লগে। ৱজহ যহ থী কি উসনে কূশ কী এক ঔরত সে শাদী কী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","উন্হোংনে পূছা, “ক্যা রব সির্ফ় মূসা কী মারিফ়ত বাত করতা হৈ? ক্যা উসনে হমসে ভী বাত নহীং কী?” রব নে উনকী যহ বাতেং সুনীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","লেকিন মূসা নিহাযত হলীম থা। দুনিযা মেং উস জৈসা হলীম কোঈ নহীং থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","অচানক রব মূসা, হারূন ঔর মরিযম সে মুখ়াতিব হুআ, “তুম তীনোং বাহর নিকলকর মুলাক়াত কে খ়ৈমে কে পাস আও।” তীনোং ৱহাঁ পহুঁচে। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","তব রব বাদল কে সতূন মেং উতরকর মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর খড়া হুআ। উসনে হারূন ঔর মরিযম কো বুলাযা তো দোনোং আএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","উসনে কহা, “মেরী বাত সুনো। জব তুম্হারে দরমিযান নবী হোতা হৈ তো মৈং অপনে আপকো রোযা মেং উস পর জ়াহির করতা হূঁ যা খ়াব মেং উসসে মুখ়াতিব হোতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","লেকিন মেরে খ়াদিম মূসা কী ঔর বাত হৈ। উসে মৈংনে অপনে পূরে ঘরানে পর মুক়র্রর কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","উসসে মৈং রূবরূ হমকলাম হোতা হূঁ। উসসে মৈং মুঅম্মোং কে জ়রীএ নহীং বল্কি সাফ় সাফ় বাত করতা হূঁ। ৱহ রব কী সূরত দেখতা হৈ। তো ফির তুম মেরে খ়াদিম কে খ়িলাফ় বাতেং করনে সে ক্যোং ন ডরে?” ");
INSERT INTO urdgvb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","রব কা গ়জ়ব উন পর আন পড়া, ঔর ৱহ চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","জব বাদল কা সতূন খ়ৈমে সে দূর হুআ তো মরিযম কী জিল্দ বর্ফ় কী মানিংদ সফ়েদ থী। ৱহ কোঢ় কা শিকার হো গঈ থী। হারূন উস কী তরফ় মুড়া তো উস কী হালত দেখী ");
INSERT INTO urdgvb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ঔর মূসা সে কহা, “মেরে আক়া, মেহরবানী করকে হমেং ইস গুনাহ কী সজ়া ন দেং জো হমারী হমাক়ত কে বাইস সরজ়দ হুআ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","মরিযম কো ইস হালত মেং ন ছোড়েং। ৱহ তো ঐসে বচ্চে কী মানিংদ হৈ জো মুরদা পৈদা হুআ হো, জিসকে জিস্ম কা আধা হিস্সা গল চুকা হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","তব মূসা নে পুকারকর রব সে কহা, “ঐ অল্লাহ, মেহরবানী করকে উসে শফ়া দে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","রব নে জৱাব মেং মূসা সে কহা, “অগর মরিযম কা বাপ উসকে মুঁহ পর থূকতা তো ক্যা ৱহ পূরে হফ়তে তক শর্ম মহসূস ন করতী? উসে এক হফ়তে কে লিএ খ়ৈমাগাহ কে বাহর বংদ রখ। ইসকে বাদ উসে ৱাপস লাযা জা সকতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","চুনাঁচে মরিযম কো এক হফ়তে কে লিএ খ়ৈমাগাহ কে বাহর বংদ রখা গযা। লোগ উস ৱক়্ত তক সফ়র কে লিএ রৱানা ন হুএ জব তক উসে ৱাপস ন লাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","জব ৱহ ৱাপস আঈ তো ইসরাঈলী হসীরাত সে রৱানা হোকর ফ়ারান কে রেগিস্তান মেং খ়ৈমাজ়ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ফির রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“কুছ আদমী মুল্কে-কনান কা জাযজ়া লেনে কে লিএ ভেজ দে, ক্যোংকি মৈং উসে ইসরাঈলিযোং কো দেনে কো হূঁ। হর ক়বীলে মেং সে এক রাহনুমা কো চুনকর ভেজ দে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","মূসা নে রব কে কহনে পর উন্হেং দশ্তে-ফ়ারান সে ভেজা। সব ইসরাঈলী রাহনুমা থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","উনকে নাম যহ হৈং : রূবিন কে ক়বীলে সে সম্মুঅ বিন জ়ক্কূর, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","শমৌন কে ক়বীলে সে সাফ়ত বিন হোরী, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","যহূদাহ কে ক়বীলে সে কালিব বিন যফ়ুন্না, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ইশকার কে ক়বীলে সে ইজাল বিন যূসুফ়, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ইফ়রাঈম কে ক়বীলে সে হোসেঅ বিন নূন, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","বিনযমীন কে ক়বীলে সে ফ়লতী বিন রফ়ূ, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","জ়বূলূন কে ক়বীলে সে জদ্দিযেল বিন সোদী, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","যূসুফ় কে বেটে মনস্সী কে ক়বীলে সে জিদ্দী বিন সূসী, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","দান কে ক়বীলে সে অম্মিযেল বিন জমল্লী, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","আশর কে ক়বীলে সে সতূর বিন মীকাএল, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","নফ়তালী কে ক়বীলে সে নখ়বী বিন ৱুফ়সী, ");
INSERT INTO urdgvb_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","জদ কে ক়বীলে সে জিযুএল বিন মাকী। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","মূসা নে ইন্হীং বারহ আদমিযোং কো মুল্ক কা জাযজ়া লেনে কে লিএ ভেজা। উসনে হোসেঅ কা নাম যশুঅ যানী ‘রব নজাত হৈ’ মেং বদল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","উন্হেং রুখ়সত করনে সে পহলে উসনে কহা, “দশ্তে-নজব সে গুজ়রকর পহাড়ী ইলাক়ে তক পহুঁচো। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","মালূম করো কি যহ কিস তরহ কা মুল্ক হৈ ঔর উসকে বাশিংদে কৈসে হৈং। ক্যা ৱহ তাক়তৱর হৈং যা কমজ়োর, তাদাদ মেং কম হৈং যা জ়্যাদা? ");
INSERT INTO urdgvb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","জিস মুল্ক মেং ৱহ বসতে হৈং ক্যা ৱহ অচ্ছা হৈ কি নহীং? ৱহ কিস ক়িস্ম কে শহরোং মেং রহতে হৈং? ক্যা উনকী চারদীৱারিযাঁ হৈং কি নহীং? ");
INSERT INTO urdgvb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","মুল্ক কী জ়মীন জ়রখ়েজ় হৈ যা বংজর? উসমেং দরখ়্ত হৈং কি নহীং? ঔর জুর্রত করকে মুল্ক কা কুছ ফল চুনকর লে আও।” উস ৱক়্ত পহলে অংগূর পক গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","চুনাঁচে ইন আদমিযোং নে সফ়র করকে দশ্তে-সীন সে রহোব তক মুল্ক কা জাযজ়া লিযা। রহোব লবো-হমাত কে ক়রীব হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ৱহ দশ্তে-নজব সে গুজ়রকর হবরূন পহুঁচে জহাঁ অনাক় কে বেটে অখ়ীমান, সীসী ঔর তলমী রহতে থে। (হবরূন কো মিসর কে শহর জ়ুঅন সে সাত সাল পহলে তামীর কিযা গযা থা)। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","জব ৱহ ৱাদীএ-ইসকাল তক পহুঁচে তো উন্হোংনে এক ডালী কাট লী জিস পর অংগূর কা গুচ্ছা লগা হুআ থা। দো আদমিযোং নে যহ অংগূর, কুছ অনার ঔর কুছ অংজীর লাঠী পর লটকাএ ঔর উসে উঠাকর চল পড়ে। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","উস জগহ কা নাম উস গুচ্ছে কে সবব সে জো ইসরাঈলিযোং নে ৱহাঁ সে কাট লিযা ইসকাল যানী গুচ্ছা রখা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","চালীস দিন তক মুল্ক কা খোজ লগাতে লগাতে ৱহ লৌট আএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ৱহ মূসা, হারূন ঔর ইসরাঈল কী পূরী জমাত কে পাস আএ জো দশ্তে-ফ়ারান মেং ক়াদিস কী জগহ পর ইংতজ়ার কর রহে থে। ৱহাঁ উন্হোংনে সব কুছ বতাযা জো উন্হোংনে মালূম কিযা থা ঔর উন্হেং ৱহ ফল দিখাএ জো লেকর আএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","উন্হোংনে মূসা কো রিপোর্ট দী, “হম উস মুল্ক মেং গএ জহাঁ আপনে হমেং ভেজা থা। ৱাক়ঈ উস মুল্ক মেং দূধ ঔর শহদ কী কসরত হৈ। যহাঁ হমারে পাস উসকে কুছ ফল ভী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","লেকিন উসকে বাশিংদে তাক়তৱর হৈং। উনকে শহরোং কী ফ়সীলেং হৈং, ঔর ৱহ নিহাযত বড়ে হৈং। হমনে ৱহাঁ অনাক় কী ঔলাদ ভী দেখী। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","অমালীক়ী দশ্তে-নজব মেং রহতে হৈং জবকি হিত্তী, যবূসী ঔর অমোরী পহাড়ী ইলাক়ে মেং আবাদ হৈং। কনানী সাহিলী ইলাক়ে ঔর দরিযাএ-যরদন কে কিনারে কিনারে বসতে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","কালিব নে মূসা কে সামনে জমাশুদা লোগোং কো ইশারা কিযা কি ৱহ খ়ামোশ হো জাএঁ। ফির উসনে কহা, “আএঁ, হম মুল্ক মেং দাখ়িল হো জাএঁ ঔর উস পর ক়ব্জ়া কর লেং, ক্যোংকি হম যক়ীনন যহ করনে কে ক়াবিল হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","লেকিন দূসরে আদমিযোং নে জো উসকে সাথ মুল্ক কো দেখনে গএ থে কহা, “হম উন লোগোং পর হমলা নহীং কর সকতে, ক্যোংকি ৱহ হমসে তাক়তৱর হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","উন্হোংনে ইসরাঈলিযোং কে দরমিযান উস মুল্ক কে বারে মেং গ়লত অফ়ৱাহেং ফৈলাঈং জিসকী তফ়তীশ উন্হোংনে কী থী। উন্হোংনে কহা, “জিস মুল্ক মেং সে হম গুজ়রে তাকি উসকা জাযজ়া লেং ৱহ অপনে বাশিংদোং কো হড়প কর লেতা হৈ। জো ভী উসমেং রহতা হৈ নিহাযত দরাজ়ক়দ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","হমনে ৱহাঁ দেৱক়ামত অফ়রাদ ভী দেখে। (অনাক় কে বেটে দেৱক়ামত কে অফ়রাদ কী ঔলাদ থে)। উনকে সামনে হম অপনে আপকো টিড্ডী জৈসা মহসূস কর রহে থে, ঔর হম উনকী নজ়র মেং ঐসে থে ভী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","উস রাত তমাম লোগ চীখ়েং মার মারকর রোতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","সব মূসা ঔর হারূন কে খ়িলাফ় বুড়বুড়ানে লগে। পূরী জমাত নে উনসে কহা, “কাশ হম মিসর যা ইস রেগিস্তান মেং মর গএ হোতে! ");
INSERT INTO urdgvb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","রব হমেং ক্যোং উস মুল্ক মেং লে জা রহা হৈ? ক্যা ইসলিএ কি দুশ্মন হমেং তলৱার সে ক়ত্ল করে ঔর হমারে বাল-বচ্চোং কো লূট লে? ক্যা বেহতর নহীং হোগা কি হম মিসর ৱাপস জাএঁ?” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","উন্হোংনে এক দূসরে সে কহা, “আও, হম রাহনুমা চুনকর মিসর ৱাপস চলে জাএঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","তব মূসা ঔর হারূন পূরী জমাত কে সামনে মুঁহ কে বল গিরে। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","লেকিন যশুঅ বিন নূন ঔর কালিব বিন যফ়ুন্না বাক়ী দস জাসূসোং সে ফ়রক় থে। পরেশানী কে আলম মেং উন্হোংনে অপনে কপড়ে ফাড়কর ");
INSERT INTO urdgvb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","পূরী জমাত সে কহা, “জিস মুল্ক মেং সে হম গুজ়রে ঔর জিসকী তফ়তীশ হমনে কী ৱহ নিহাযত হী অচ্ছা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","অগর রব হমসে খ়ুশ হৈ তো ৱহ জ়রূর হমেং উস মুল্ক মেং লে জাএগা জিসমেং দূধ ঔর শহদ কী কসরত হৈ। ৱহ হমেং জ়রূর যহ মুল্ক দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","রব সে বগ়াৱত মত করনা। উস মুল্ক কে রহনেৱালোং সে ন ডরেং। হম উন্হেং হড়প কর জাএংগে। উনকী পনাহ উনসে জাতী রহী হৈ জবকি রব হমারে সাথ হৈ। চুনাঁচে উনসে মত ডরেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","যহ সুনকর পূরী জমাত উন্হেং সংগসার করনে কে লিএ তৈযার হুঈ। লেকিন অচানক রব কা জলাল মুলাক়াত কে খ়ৈমে পর জ়াহির হুআ, ঔর তমাম ইসরাঈলিযোং নে উসে দেখা। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","রব নে মূসা সে কহা, “যহ লোগ মুঝে কব তক হক়ীর জানেংগে? ৱহ কব তক মুঝ পর ঈমান রখনে সে ইনকার করেংগে অগরচে মৈংনে উনকে দরমিযান ইতনে মোজিজ়ে কিএ হৈং? ");
INSERT INTO urdgvb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","মৈং উন্হেং ৱবা সে মার ডালূঁগা ঔর উন্হেং রূএ-জ়মীন পর সে মিটা দূঁগা। উনকী জগহ মৈং তুঝসে এক ক়ৌম বনাঊঁগা জো উনসে বড়ী ঔর তাক়তৱর হোগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","লেকিন মূসা নে রব সে কহা, “ফির মিসরী যহ সুন লেংগে! ক্যোংকি তূনে অপনী ক়ুদরত সে ইন লোগোং কো মিসর সে নিকালকর যহাঁ তক পহুঁচাযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","মিসরী যহ বাত কনান কে বাশিংদোং কো বতাএঁগে। যহ লোগ পহলে সে সুন চুকে হৈং কি রব ইস ক়ৌম কে সাথ হৈ, কি তুঝে রূবরূ দেখা জাতা হৈ, কি তেরা বাদল উনকে ঊপর ঠহরা রহতা হৈ, ঔর কি তূ দিন কে ৱক়্ত বাদল কে সতূন মেং ঔর রাত কো আগ কে সতূন মেং ইনকে আগে আগে চলতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","অগর তূ একদম ইস পূরী ক়ৌম কো তবাহ কর ডালে তো বাক়ী ক়ৌমেং যহ সুনকর কহেংগী, ");
INSERT INTO urdgvb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘রব ইন লোগোং কো উস মুল্ক মেং লে জানে কে ক়াবিল নহীং থা জিসকা ৱাদা উসনে উনসে ক়সম খাকর কিযা থা। ইসী লিএ উসনে উন্হেং রেগিস্তান মেং হলাক কর দিযা।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ঐ রব, অব অপনী ক়ুদরত যোং জ়াহির কর জিস তরহ তূনে ফ়রমাযা হৈ। ক্যোংকি তূনে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘রব তহম্মুল ঔর শফ়ক়ত সে ভরপূর হৈ। ৱহ গুনাহ ঔর নাফ়রমানী মুআফ় করতা হৈ, লেকিন হর এক কো উস কী মুনাসিব সজ়া ভী দেতা হৈ। জব ৱালিদৈন গুনাহ করেং তো উনকী ঔলাদ কো ভী তীসরী ঔর চৌথী পুশ্ত তক সজ়া কে নতাযজ ভুগতনে পড়েংগে।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ইন লোগোং কা ক়ুসূর অপনী অজ়ীম শফ়ক়ত কে মুতাবিক় মুআফ় কর। উন্হেং উস তরহ মুআফ় কর জিস তরহ তূ উন্হেং মিসর সে নিকলতে ৱক়্ত অব তক মুআফ় করতা রহা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","রব নে জৱাব দিযা, “তেরে কহনে পর মৈংনে উন্হেং মুআফ় কর দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ইসকে বাৱুজূদ মেরী হযাত কী ক়সম ঔর মেরে জলাল কী ক়সম জো পূরী দুনিযা কো মামূর করতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ইন লোগোং মেং সে কোঈ ভী উস মুল্ক মেং দাখ়িল নহীং হোগা। উন্হোংনে মেরা জলাল ঔর মেরে মোজিজ়ে দেখে হৈং জো মৈংনে মিসর ঔর রেগিস্তান মেং কর দিখাএ হৈং। তো ভী উন্হোংনে দস দফ়া মুঝে আজ়মাযা ঔর মেরী ন সুনী। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","উনমেং সে এক ভী উস মুল্ক কো নহীং দেখেগা জিসকা ৱাদা মৈংনে ক়সম খাকর উনকে বাপদাদা সে কিযা থা। জিসনে ভী মুঝে হক়ীর জানা হৈ ৱহ কভী উসে নহীং দেখেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","সির্ফ় মেরা খ়াদিম কালিব মুখ়্তলিফ় হৈ। উস কী রূহ ফ়রক় হৈ। ৱহ পূরে দিল সে মেরী পৈরৱী করতা হৈ, ইসলিএ মৈং উসে উস মুল্ক মেং লে জাঊঁগা জিসমেং উসনে সফ়র কিযা হৈ। উস কী ঔলাদ মুল্ক মীরাস মেং পাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","লেকিন ফ়িলহাল অমালীক়ী ঔর কনানী উস কী ৱাদিযোং মেং আবাদ রহেংগে। চুনাঁচে কল মুড়কর ৱাপস চলো। রেগিস্তান মেং বহরে-ক়ুলজ়ুম কী তরফ় রৱানা হো জাও।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“যহ শরীর জমাত কব তক মেরে খ়িলাফ় বুড়বুড়াতী রহেগী? উনকে গিলে-শিকৱে মুঝ তক পহুঁচ গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ইসলিএ উন্হেং বতাও, ‘রব ফ়রমাতা হৈ কি মেরী হযাত কী ক়সম, মৈং তুম্হারে সাথ ৱহী কুছ করূঁগা জো তুমনে মেরে সামনে কহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","তুম ইস রেগিস্তান মেং মরকর যহীং পড়ে রহোগে, হর এক জো 20 সাল যা ইসসে জ়াযদ কা হৈ, জো মর্দুমশুমারী মেং গিনা গযা ঔর জো মেরে খ়িলাফ় বুড়বুড়াযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","গো মৈংনে হাথ উঠাকর ক়সম খাঈ থী কি মৈং তুঝে উসমেং বসাঊঁগা তুমমেং সে কোঈ ভী উস মুল্ক মেং দাখ়িল নহীং হোগা। সির্ফ় কালিব বিন যফ়ুন্না ঔর যশুঅ বিন নূন দাখ়িল হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","তুমনে কহা থা কি দুশ্মন হমারে বচ্চোং কো লূট লেংগে। লেকিন উন্হীং কো মৈং উস মুল্ক মেং লে জাঊঁগা জিসে তুমনে রদ্দ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","লেকিন তুম খ়ুদ দাখ়িল নহীং হোগে। তুম্হারী লাশেং ইস রেগিস্তান মেং পড়ী রহেংগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","তুম্হারে বচ্চে 40 সাল তক যহাঁ রেগিস্তান মেং গল্লাবান হোংগে। উন্হেং তুম্হারী বেৱফ়াঈ কে সবব সে উস ৱক়্ত তক তকলীফ় উঠানী পড়েগী জব তক তুমমেং সে আখ়িরী শখ়্স মর ন গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","তুমনে চালীস দিন কে দৌরান উস মুল্ক কা জাযজ়া লিযা। অব তুম্হেং চালীস সাল তক অপনে গুনাহোং কা নতীজা ভুগতনা পড়েগা। তব তুম্হেং পতা চলেগা কি ইসকা ক্যা মতলব হৈ কি মৈং তুম্হারী মুখ়ালফ়ত করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","মৈং, রব নে যহ বাত ফ়রমাঈ হৈ। মৈং যক়ীনন যহ সব কুছ উস সারী শরীর জমাত কে সাথ করূঁগা জিসনে মিলকর মেরী মুখ়ালফ়ত কী হৈ। ইসী রেগিস্তান মেং ৱহ খ়ত্ম হো জাএংগে, যহীং মর জাএংগে’।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_36‏","005_14_36‏","NUM","14","36‏","37","জিন আদমিযোং কো মূসা নে মুল্ক কা জাযজ়া লেনে কে লিএ ভেজা থা, রব নে উন্হেং ফ়ৌরন মোহলক ৱবা সে মার ডালা, ক্যোংকি উনকে গ়লত অফ়ৱাহেং ফৈলানে সে পূরী জমাত বুড়বুড়ানে লগী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","সির্ফ় যশুঅ বিন নূন ঔর কালিব বিন যফ়ুন্না জ়িংদা রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","জব মূসা নে রব কী যহ বাতেং ইসরাঈলিযোং কো বতাঈং তো ৱহ খ়ূব মাতম করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","অগলী সুবহ-সৱেরে ৱহ উঠে ঔর যহ কহতে হুএ ঊঁচে পহাড়ী ইলাক়ে কে লিএ রৱানা হুএ কি হমসে গ়লতী হুঈ হৈ, লেকিন অব হম হাজ়ির হৈং ঔর উস জগহ কী তরফ় জা রহে হৈং জিসকা জ়িক্র রব নে কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","লেকিন মূসা নে কহা, “তুম ক্যোং রব কী খ়িলাফ়ৱরজ়ী কর রহে হো? তুম কামযাব নহীং হোগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ৱহাঁ ন জাও, ক্যোংকি রব তুম্হারে সাথ নহীং হৈ। তুম দুশ্মনোং কে হাথোং শিকস্ত খাওগে, ");
INSERT INTO urdgvb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ক্যোংকি ৱহাঁ অমালীক়ী ঔর কনানী তুম্হারা সামনা করেংগে। চূঁকি তুমনে অপনা মুঁহ রব সে ফের লিযা হৈ ইসলিএ ৱহ তুম্হারে সাথ নহীং হোগা, ঔর দুশ্মন তুম্হেং তলৱার সে মার ডালেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","তো ভী ৱহ অপনে গ়ুরূর মেং জুর্রত করকে ঊঁচে পহাড়ী ইলাক়ে কী তরফ় বঢ়ে, হালাঁকি ন মূসা ঔর ন অহদ কে সংদূক় হী নে খ়ৈমাগাহ কো ছোড়া। ");
INSERT INTO urdgvb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ফির উস পহাড়ী ইলাক়ে মেং রহনেৱালে অমালীক়ী ঔর কনানী উন পর আন পড়ে ঔর উন্হেং মারতে মারতে হুরমা তক তিত্তর-বিত্তর কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ইসরাঈলিযোং কো বতানা কি জব তুম উস মুল্ক মেং দাখ়িল হোগে জো মৈং তুম্হেং দূঁগা ");
INSERT INTO urdgvb_vpl VALUES ("NU15_3‏","005_15_3‏","NUM","15","3‏","4","তো জলনেৱালী ক়ুরবানিযাঁ যোং পেশ করনা : অগর তুম অপনে গায-বৈলোং যা ভেড়-বকরিযোং মেং সে ঐসী ক়ুরবানী পেশ করনা চাহো জিসকী খ়ুশবূ রব কো পসংদ হো তো সাথ সাথ ডেঢ় কিলোগ্রাম বেহতরীন মৈদা ভী পেশ করো জো এক লিটর জ়ৈতূন কে তেল কে সাথ মিলাযা গযা হো। ইসমেং কোঈ ফ়রক় নহীং কি যহ ভস্ম হোনেৱালী ক়ুরবানী, মন্নত কী ক়ুরবানী, দিলী খ়ুশী কী ক়ুরবানী যা কিসী ঈদ কী ক়ুরবানী হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","হর ভেড় কো পেশ করতে ৱক়্ত এক লিটর মৈ ভী মৈ কী নজ়র কে তৌর পর পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","জব মেংঢা ক়ুরবান কিযা জাএ তো 3 কিলোগ্রাম বেহতরীন মৈদা ভী সাথ পেশ করনা জো সৱা লিটর তেল কে সাথ মিলাযা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","সৱা লিটর মৈ ভী মৈ কী নজ়র কে তৌর পর পেশ কী জাএ। ঐসী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ আএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","অগর তূ রব কো ভস্ম হোনেৱালী ক়ুরবানী, মন্নত কী ক়ুরবানী যা সলামতী কী ক়ুরবানী কে তৌর পর জৱান বৈল পেশ করনা চাহে ");
INSERT INTO urdgvb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","তো উসকে সাথ সাঢ়ে 4 কিলোগ্রাম বেহতরীন মৈদা ভী পেশ করনা জো দো লিটর তেল কে সাথ মিলাযা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","দো লিটর মৈ ভী মৈ কী নজ়র কে তৌর পর পেশ কী জাএ। ঐসী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","লাজ়িম হৈ কি জব ভী কিসী গায, বৈল, ভেড়, মেংঢে, বকরী যা বকরে কো চঢ়াযা জাএ তো ঐসা হী কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","অগর এক সে জ়াযদ জানৱরোং কো ক়ুরবান করনা হৈ তো হর এক কে লিএ মুক়র্ররা গ়ল্লা ঔর মৈ কী নজ়রেং ভী সাথ হী পেশ কী জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","লাজ়িম হৈ কি হর দেসী ইসরাঈলী জলনেৱালী ক়ুরবানিযাঁ পেশ করতে ৱক়্ত ঐসা হী করে। ফির উনকী খ়ুশবূ রব কো পসংদ আএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","যহ ভী লাজ়িম হৈ কি ইসরাঈল মেং আরিজ়ী যা মুস্তক়িল তৌর পর রহনেৱালে পরদেসী ইন উসূলোং কে মুতাবিক় অপনী ক়ুরবানিযাঁ চঢ়াএঁ। ফির উনকী খ়ুশবূ রব কো পসংদ আএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","মুল্কে-কনান মেং রহনেৱালে তমাম লোগোং কে লিএ পাবংদিযাঁ এক জৈসী হৈং, খ়াহ ৱহ দেসী হোং যা পরদেসী, ক্যোংকি রব কী নজ়র মেং পরদেসী তুম্হারে বরাবর হৈ। যহ তুম্হারে ঔর তুম্হারী ঔলাদ কে লিএ দাযমী উসূল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","তুম্হারে ঔর তুম্হারে সাথ রহনেৱালে পরদেসী কে লিএ এক হী শরীঅত হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ইসরাঈলিযোং কো বতানা কি জব তুম উস মুল্ক মেং দাখ়িল হোগে জিসমেং মৈং তুম্হেং লে জা রহা হূঁ ");
INSERT INTO urdgvb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ঔর ৱহাঁ কী পৈদাৱার খাওগে তো পহলে উসকা এক হিস্সা উঠানেৱালী ক়ুরবানী কে তৌর পর রব কো পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ফ়সল কে পহলে খ়ালিস আটে মেং সে মেরে লিএ এক রোটী বনাকর উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ করো। ৱহ গাহনে কী জগহ কী তরফ় সে রব কে লিএ উঠানেৱালী ক়ুরবানী হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","অপনী ফ়সল কে পহলে খ়ালিস আটে মেং সে যহ ক়ুরবানী পেশ কিযা করো। যহ উসূল হমেশা তক লাগূ রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","হো সকতা হৈ কি গ়ৈরইরাদী তৌর পর তুমসে গ়লতী হুঈ হৈ ঔর তুমনে উন অহকাম পর পূরে তৌর পর অমল নহীং কিযা জো রব মূসা কো দে চুকা হৈ ");
INSERT INTO urdgvb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","যা জো ৱহ আনেৱালী নসলোং কো দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","অগর জমাত ইস বাত সে নাৱাক়িফ় থী ঔর গ়ৈরইরাদী তৌর পর উসসে গ়লতী হুঈ তো ফির পূরী জমাত এক জৱান বৈল ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর পেশ করে। সাথ হী ৱহ মুক়র্ররা গ়ল্লা ঔর মৈ কী নজ়রেং ভী পেশ করে। ইসকী খ়ুশবূ রব কো পসংদ হোগী। ইসকে অলাৱা জমাত গুনাহ কী ক়ুরবানী কে লিএ এক বকরা পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ইমাম ইসরাঈল কী পূরী জমাত কা কফ়্ফ়ারা দে তো উন্হেং মুআফ়ী মিলেগী, ক্যোংকি উনকা গুনাহ গ়ৈরইরাদী থা ঔর উন্হোংনে রব কো ভস্ম হোনেৱালী ক়ুরবানী ঔর গুনাহ কী ক়ুরবানী পেশ কী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ইসরাঈলিযোং কী পূরী জমাত কো পরদেসিযোং সমেত মুআফ়ী মিলেগী, ক্যোংকি গুনাহ গ়ৈরইরাদী থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","অগর সির্ফ় এক শখ়্স সে গ়ৈরইরাদী তৌর পর গুনাহ হুআ হো তো গুনাহ কী ক়ুরবানী কে লিএ ৱহ এক যকসালা বকরী পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ইমাম রব কে সামনে উস শখ়্স কা কফ়্ফ়ারা দে। জব কফ়্ফ়ারা দে দিযা গযা তো উসে মুআফ়ী হাসিল হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","যহী উসূল পরদেসী পর ভী লাগূ হৈ। অগর উসসে গ়ৈরইরাদী তৌর পর গুনাহ হুআ হো তো ৱহ মুআফ়ী হাসিল করনে কে লিএ ৱহী কুছ করে জো ইসরাঈলী কো করনা হোতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","লেকিন অগর কোঈ দেসী যা পরদেসী জান-বূঝকর গুনাহ করতা হৈ তো ঐসা শখ়্স রব কী ইহানত করতা হৈ, ইসলিএ লাজ়িম হৈ কি উসে উস কী ক়ৌম মেং সে মিটাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","উসনে রব কা কলাম হক়ীর জানকর উসকে অহকাম তোড় ডালে হৈং, ইসলিএ উসে জ়রূর ক়ৌম মেং সে মিটাযা জাএ। ৱহ অপনে গুনাহ কা জ়িম্মাদার হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","জব ইসরাঈলী রেগিস্তান মেং সে গুজ়র রহে থে তো এক আদমী কো পকড়া গযা জো হফ়তে কে দিন লকড়িযাঁ জমা কর রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","জিন্হোংনে উসে পকড়া থা ৱহ উসে মূসা, হারূন ঔর পূরী জমাত কে পাস লে আএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","চূঁকি সাফ় মালূম নহীং থা কি উসকে সাথ ক্যা কিযা জাএ ইসলিএ উন্হোংনে উসে গিরিফ়্তার কর লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ফির রব নে মূসা সে কহা, “ইস আদমী কো জ়রূর সজ়াএ-মৌত দী জাএ। পূরী জমাত উসে খ়ৈমাগাহ কে বাহর লে জাকর সংগসার করে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","চুনাঁচে জমাত নে উসে খ়ৈমাগাহ কে বাহর লে জাকর সংগসার কিযা, জিস তরহ রব নে মূসা কো হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ইসরাঈলিযোং কো বতানা কি তুম ঔর তুম্হারে বাদ কী নসলেং অপনে লিবাস কে কিনারোং পর ফুঁদনে লগাএঁ। হর ফুঁদনা এক ক়িরমিজ়ী ডোরী সে লিবাস কে সাথ লগা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ইন ফুঁদনোং কো দেখকর তুম্হেং রব কে তমাম অহকাম যাদ রহেংগে ঔর তুম উন পর অমল করোগে। ফির তুম অপনে দিলোং ঔর আঁখোং কী গ়লত খ়াহিশোং কে পীছে নহীং পড়োগে বল্কি জ়িনাকারী সে দূর রহোগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ফির তুম মেরে অহকাম কো যাদ করকে উন পর অমল করোগে ঔর অপনে খ়ুদা কে সামনে মখ়সূসো-মুক়দ্দস রহোগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","মৈং রব তুম্হারা খ়ুদা হূঁ জো তুম্হেং মিসর সে নিকাল লাযা তাকি তুম্হারা খ়ুদা হূঁ। মৈং রব তুম্হারা খ়ুদা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_1‏","005_16_1‏","NUM","16","1‏","2","এক দিন ক়োরহ বিন ইজ়হার মূসা কে খ়িলাফ় উঠা। ৱহ লাৱী কে ক়বীলে কা ক়িহাতী থা। উসকে সাথ রূবিন কে ক়বীলে কে তীন আদমী থে, ইলিযাব কে বেটে দাতন ঔর অবীরাম ঔর ওন বিন পলত। উনকে সাথ 250 ঔর আদমী ভী থে জো জমাত কে সরদার ঔর অসরো-রসূখ়ৱালে থে, ঔর জো কৌংসল কে লিএ চুনে গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ৱহ মিলকর মূসা ঔর হারূন কে পাস আকর কহনে লগে, “আপ হমসে জ়্যাদতী কর রহে হৈং। পূরী জমাত মখ়সূসো-মুক়দ্দস হৈ, ঔর রব উসকে দরমিযান হৈ। তো ফির আপ অপনে আপকো ক্যোং রব কী জমাত সে বঢ়কর সমঝতে হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","যহ সুনকর মূসা মুঁহ কে বল গিরা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ফির উসনে ক়োরহ ঔর উসকে তমাম সাথিযোং সে কহা, “কল সুবহ রব জ়াহির করেগা কি কৌন উসকা বংদা ঔর কৌন মখ়সূসো-মুক়দ্দস হৈ। উসী কো ৱহ অপনে পাস আনে দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ঐ ক়োরহ, কল অপনে তমাম সাথিযোং কে সাথ বখ়ূরদান লেকর ");
INSERT INTO urdgvb_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","রব কে সামনে উনমেং অংগারে ঔর বখ়ূর ডালো। জিস আদমী কো রব চুনেগা ৱহ মখ়সূসো-মুক়দ্দস হোগা। অব তুম লাৱী খ়ুদ জ়্যাদতী কর রহে হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","মূসা নে ক়োরহ সে বাত জারী রখী, “ঐ লাৱী কী ঔলাদ, সুনো! ");
INSERT INTO urdgvb_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ক্যা তুম্হারী নজ়র মেং যহ কোঈ ছোটী বাত হৈ কি রব তুম্হেং ইসরাঈলী জমাত কে বাক়ী লোগোং সে অলগ করকে অপনে ক়রীব লে আযা তাকি তুম রব কে মক়দিস মেং ঔর জমাত কে সামনে খড়ে হোকর উনকী খ়িদমত করো? ");
INSERT INTO urdgvb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ৱহ তুঝে ঔর তেরে সাথী লাৱিযোং কো অপনে ক়রীব লাযা হৈ। লেকিন অব তুম ইমাম কা ওহদা ভী অপনানা চাহতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","অপনে সাথিযোং সে মিলকর তূনে হারূন কী নহীং বল্কি রব কী মুখ়ালফ়ত কী হৈ। ক্যোংকি হারূন কৌন হৈ কি তুম উসকে খ়িলাফ় বুড়বুড়াও?” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ফির মূসা নে ইলিযাব কে বেটোং দাতন ঔর অবীরাম কো বুলাযা। লেকিন উন্হোংনে কহা, “হম নহীং আএঁগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","আপ হমেং এক ঐসে মুল্ক সে নিকাল লাএ হৈং জহাঁ দূধ ঔর শহদ কী কসরত হৈ তাকি হম রেগিস্তান মেং হলাক হো জাএঁ। ক্যা যহ কাফ়ী নহীং হৈ? ক্যা অব আপ হম পর হুকূমত ভী করনা চাহতে হৈং? ");
INSERT INTO urdgvb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ন আপনে হমেং ঐসে মুল্ক মেং পহুঁচাযা জিসমেং দূধ ঔর শহদ কী কসরত হৈ, ন হমেং খেতোং ঔর অংগূর কে বাগ়োং কে ৱারিস বনাযা হৈ। ক্যা আপ ইন আদমিযোং কী আঁখেং নিকাল ডালেংগে? নহীং, হম হরগিজ় নহীং আএঁগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","তব মূসা নিহাযত গ়ুস্সে হুআ। উসনে রব সে কহা, “উনকী ক়ুরবানী কো ক়বূল ন কর। মৈংনে এক গধা তক উনসে নহীং লিযা, ন মৈংনে উনমেং সে কিসী সে বুরা সুলূক কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ক়োরহ সে উসনে কহা, “কল তুম ঔর তুম্হারে সাথী রব কে সামনে হাজ়ির হো জাও। হারূন ভী আএগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","হর এক অপনা বখ়ূরদান লেকর উসে রব কো পেশ করে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","চুনাঁচে হর আদমী নে অপনা বখ়ূরদান লেকর উসমেং অংগারে ঔর বখ়ূর ডাল দিযা। ফির সব মূসা ঔর হারূন কে সাথ মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর খড়ে হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ক়োরহ নে পূরী জমাত কো দরৱাজ়ে পর মূসা ঔর হারূন কে মুক়াবলে মেং জমা কিযা থা। অচানক পূরী জমাত পর রব কা জলাল জ়াহির হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ইস জমাত সে অলগ হো জাও তাকি মৈং ইসে ফ়ৌরন হলাক কর দূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","মূসা ঔর হারূন মুঁহ কে বল গিরে ঔর বোল উঠে, “ঐ অল্লাহ, তূ তমাম জানোং কা খ়ুদা হৈ। ক্যা তেরা গ়জ়ব এক হী আদমী কে গুনাহ কে সবব সে পূরী জমাত পর আন পড়েগা?” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","তব রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“জমাত কো বতা দে কি ক়োরহ, দাতন ঔর অবীরাম কে ডেরোং সে দূর হো জাও।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","মূসা উঠকর দাতন ঔর অবীরাম কে পাস গযা, ঔর ইসরাঈল কে বুজ়ুর্গ উসকে পীছে চলে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","উসনে জমাত কো আগাহ কিযা, “ইন শরীরোং কে খ়ৈমোং সে দূর হো জাও! জো কুছ ভী উনকে পাস হৈ উসে ন ছুও, ৱরনা তুম ভী উনকে সাথ তবাহ হো জাওগে জব ৱহ অপনে গুনাহোং কে বাইস হলাক হোংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","তব বাক়ী লোগ ক়োরহ, দাতন ঔর অবীরাম কে ডেরোং সে দূর হো গএ। দাতন ঔর অবীরাম অপনে বাল-বচ্চোং সমেত অপনে খ়ৈমোং সে নিকলকর বাহর খড়ে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","মূসা নে কহা, “অব তুম্হেং পতা চলেগা কি রব নে মুঝে যহ সব কুছ করনে কে লিএ ভেজা হৈ। মৈং অপনী নহীং বল্কি উস কী মরজ়ী পূরী কর রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","অগর যহ লোগ দূসরোং কী তরহ তবঈ মৌত মরেং তো ফির রব নে মুঝে নহীং ভেজা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","লেকিন অগর রব ঐসা কাম করে জো পহলে কভী নহীং হুআ ঔর জ়মীন অপনা মুঁহ খোলকর উন্হেং ঔর উনকা পূরা মাল হড়প কর লে ঔর উন্হেং জীতে-জী দফ়না দে তো ইসকা মতলব হোগা কি ইন আদমিযোং নে রব কো হক়ীর জানা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","যহ বাত কহতে হী উনকে নীচে কী জ়মীন ফট গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","উসনে অপনা মুঁহ খোলকর উন্হেং, উনকে খ়ানদানোং কো, ক়োরহ কে তমাম লোগোং কো ঔর উনকা সারা সামান হড়প কর লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ৱহ অপনী পূরী মিলকিযত সমেত জীতে-জী দফ়ন হো গএ। জ়মীন উনকে ঊপর ৱাপস আ গঈ। যোং উন্হেং জমাত সে নিকালা গযা ঔর ৱহ হলাক হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","উনকী চীখ়েং সুনকর উনকে ইর্দগির্দ খড়ে তমাম ইসরাঈলী ভাগ উঠে, ক্যোংকি উন্হোংনে সোচা, “ঐসা ন হো কি জ়মীন হমেং ভী নিগল লে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","উসী লমহে রব কী তরফ় সে আগ উতর আঈ ঔর উন 250 আদমিযোং কো ভস্ম কর দিযা জো বখ়ূর পেশ কর রহে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“হারূন ইমাম কে বেটে ইলিযজ়র কো ইত্তলা দে কি ৱহ বখ়ূরদানোং কো রাখ মেং সে নিকালকর রখে। উনকে অংগারে ৱহ দূর ফেংকে। বখ়ূরদানোং কো রখনে কা সবব যহ হৈ কি অব ৱহ মখ়সূসো-মুক়দ্দস হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","লোগ উন আদমিযোং কে যহ বখ়ূরদান লে লেং জো অপনে গুনাহ কে বাইস জান-বহক় হো গএ। ৱহ উন্হেং কূটকর উনসে চাদরেং বনাএঁ ঔর উন্হেং জলনেৱালী ক়ুরবানিযোং কী ক়ুরবানগাহ পর চঢ়াএঁ। ক্যোংকি ৱহ রব কো পেশ কিএ গএ হৈং, ইসলিএ ৱহ মখ়সূসো-মুক়দ্দস হৈং। যোং ৱহ ইসরাঈলিযোং কে লিএ এক নিশান রহেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","চুনাঁচে ইলিযজ়র ইমাম নে পীতল কে যহ বখ়ূরদান জমা কিএ জো ভস্ম কিএ হুএ আদমিযোং নে রব কো পেশ কিএ থে। ফির লোগোং নে উন্হেং কূটকর উনসে চাদরেং বনাঈং ঔর উন্হেং ক়ুরবানগাহ পর চঢ়া দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","হারূন নে সব কুছ ৱৈসা হী কিযা জৈসা রব নে মূসা কী মারিফ়ত বতাযা থা। মক়সদ যহ থা কি বখ়ূরদান ইসরাঈলিযোং কো যাদ দিলাতে রহেং কি সির্ফ় হারূন কী ঔলাদ হী কো রব কে সামনে আকর বখ়ূর জলানে কী ইজাজ়ত হৈ। অগর কোঈ ঔর ঐসা করে তো উসকা হাল ক়োরহ ঔর উসকে সাথিযোং কা-সা হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","অগলে দিন ইসরাঈল কী পূরী জমাত মূসা ঔর হারূন কে খ়িলাফ় বুড়বুড়ানে লগী। উন্হোংনে কহা, “আপনে রব কী ক়ৌম কো মার ডালা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","লেকিন জব ৱহ মূসা ঔর হারূন কে মুক়াবলে মেং জমা হুএ ঔর মুলাক়াত কে খ়ৈমে কা রুখ় কিযা তো অচানক উস পর বাদল ছা গযা ঔর রব কা জলাল জ়াহির হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ফির মূসা ঔর হারূন মুলাক়াত কে খ়ৈমে কে সামনে আএ, ");
INSERT INTO urdgvb_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ঔর রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ইস জমাত সে নিকল জাও তাকি মৈং ইসে ফ়ৌরন হলাক কর দূঁ।” যহ সুনকর দোনোং মুঁহ কে বল গিরে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","মূসা নে হারূন সে কহা, “অপনা বখ়ূরদান লেকর উসমেং ক়ুরবানগাহ কে অংগারে ঔর বখ়ূর ডালেং। ফির ভাগকর জমাত কে পাস চলে জাএঁ তাকি উনকা কফ়্ফ়ারা দেং। জল্দী করেং, ক্যোংকি রব কা গ়জ়ব উন পর টূট পড়া হৈ। ৱবা ফৈলনে লগী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","হারূন নে ঐসা হী কিযা। ৱহ দৌড়কর জমাত কে বীচ মেং গযা। লোগোং মেং ৱবা শুরূ হো চুকী থী, লেকিন হারূন নে রব কো বখ়ূর পেশ করকে উনকা কফ়্ফ়ারা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ৱহ জ়িংদোং ঔর মুরদোং কে বীচ মেং খড়া হুআ তো ৱবা রুক গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","তো ভী 14,700 অফ়রাদ ৱবা সে মর গএ। ইসমেং ৱহ শামিল নহীং হৈং জো ক়োরহ কে সবব সে মর গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","জব ৱবা রুক গঈ তো হারূন মূসা কে পাস ৱাপস আযা জো অব তক মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর খড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ইসরাঈলিযোং সে বাত করকে উনসে 12 লাঠিযাঁ মঁগৱা লে, হর ক়বীলে কে সরদার সে এক লাঠী। হর লাঠী পর উসকে মালিক কা নাম লিখনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","লাৱী কী লাঠী পর হারূন কা নাম লিখনা, ক্যোংকি হর ক়বীলে কে সরদার কে লিএ এক লাঠী হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ফির উনকো মুলাক়াত কে খ়ৈমে মেং অহদ কে সংদূক় কে সামনে রখ জহাঁ মেরী তুমসে মুলাক়াত হোতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","জিস আদমী কো মৈংনে চুন লিযা হৈ উস কী লাঠী সে কোংপলেং ফূট নিকলেংগী। ইস তরহ মৈং তুম্হারে খ়িলাফ় ইসরাঈলিযোং কী বুড়বুড়াহট খ়ত্ম কর দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","চুনাঁচে মূসা নে ইসরাঈলিযোং সে বাত কী, ঔর ক়বীলোং কে হর সরদার নে উসে অপনী লাঠী দী। ইন 12 লাঠিযোং মেং হারূন কী লাঠী ভী শামিল থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","মূসা নে উন্হেং মুলাক়াত কে খ়ৈমে মেং অহদ কে সংদূক় কে সামনে রখা। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","অগলে দিন জব ৱহ মুলাক়াত কে খ়ৈমে মেং দাখ়িল হুআ তো উসনে দেখা কি লাৱী কে ক়বীলে কে সরদার হারূন কী লাঠী সে ন সির্ফ় কোংপলেং ফূট নিকলী হৈং বল্কি ফূল ঔর পকে হুএ বাদাম ভী লগে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","মূসা তমাম লাঠিযাঁ রব কে সামনে সে বাহর লাকর ইসরাঈলিযোং কে পাস লে আযা, ঔর উন্হোংনে উনকা মুআযনা কিযা। ফির হর এক নে অপনী অপনী লাঠী ৱাপস লে লী। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","রব নে মূসা সে কহা, “হারূন কী লাঠী অহদ কে সংদূক় কে সামনে রখ দে। যহ বাগ়ী ইসরাঈলিযোং কো যাদ দিলাএগী কি ৱহ অপনা বুড়বুড়ানা বংদ করেং, ৱরনা হলাক হো জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","মূসা নে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","লেকিন ইসরাঈলিযোং নে মূসা সে কহা, “হায, হম মর জাএংগে। হায, হম হলাক হো জাএংগে, হম সব হলাক হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","জো ভী রব কে মক়দিস কে ক়রীব আএ ৱহ মর জাএগা। ক্যা হম সব হী হলাক হো জাএংগে?” ");
INSERT INTO urdgvb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","রব নে হারূন সে কহা, “মক়দিস তেরী, তেরে বেটোং ঔর লাৱী কে ক়বীলে কী জ়িম্মাদারী হৈ। অগর ইসমেং কোঈ গ়লতী হো জাএ তো তুম ক়ুসূরৱার ঠহরোগে। ইসী তরহ ইমামোং কী খ়িদমত সির্ফ় তেরী ঔর তেরে বেটোং কী জ়িম্মাদারী হৈ। অগর ইসমেং কোঈ গ়লতী হো জাএ তো তূ ঔর তেরে বেটে ক়ুসূরৱার ঠহরেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","অপনে ক়বীলে লাৱী কে বাক়ী আদমিযোং কো ভী মেরে ক়রীব আনে দে। ৱহ তেরে সাথ মিলকর যোং হিস্সা লেং কি ৱহ তেরী ঔর তেরে বেটোং কী খ়িদমত করেং জব তুম খ়ৈমে কে সামনে অপনী জ়িম্মাদারিযাঁ নিভাওগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","তেরী খ়িদমত ঔর খ়ৈমে মেং খ়িদমত উনকী জ়িম্মাদারী হৈ। লেকিন ৱহ খ়ৈমে কে মখ়সূসো-মুক়দ্দস সামান ঔর ক়ুরবানগাহ কে ক়রীব ন জাএঁ, ৱরনা ন সির্ফ় ৱহ বল্কি তূ ভী হলাক হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","যোং ৱহ তেরে সাথ মিলকর মুলাক়াত কে খ়ৈমে কে পূরে কাম মেং হিস্সা লেং। লেকিন কিসী ঔর কো ঐসা করনে কী ইজাজ়ত নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","সির্ফ় তূ ঔর তেরে বেটে মক়দিস ঔর ক়ুরবানগাহ কী দেখ-ভাল করেং তাকি মেরা গ়জ়ব দুবারা ইসরাঈলিযোং পর ন ভড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","মৈং হী নে ইসরাঈলিযোং মেং সে তেরে ভাইযোং যানী লাৱিযোং কো চুনকর তুঝে তোহ্ফ়ে কে তৌর পর দিযা হৈ। ৱহ রব কে লিএ মখ়সূস হৈং তাকি খ়ৈমে মেং খ়িদমত করেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","লেকিন সির্ফ় তূ ঔর তেরে বেটে ইমাম কী খ়িদমত সরংজাম দেং। মৈং তুম্হেং ইমাম কা ওহদা তোহ্ফ়ে কে তৌর পর দেতা হূঁ। কোঈ ঔর ক়ুরবানগাহ ঔর মুক়দ্দস চীজ়োং কে নজ়দীক ন আএ, ৱরনা উসে সজ়াএ-মৌত দী জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","রব নে হারূন সে কহা, “মৈংনে খ়ুদ মুক়র্রর কিযা হৈ কি তমাম উঠানেৱালী ক়ুরবানিযাঁ তেরা হিস্সা হোং। যহ হমেশা তক ক়ুরবানিযোং মেং সে তেরা ঔর তেরী ঔলাদ কা হিস্সা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","তুম্হেং মুক়দ্দসতরীন ক়ুরবানিযোং কা ৱহ হিস্সা মিলনা হৈ জো জলাযা নহীং জাতা। হাঁ, তুঝে ঔর তেরে বেটোং কো ৱহী হিস্সা মিলনা হৈ, খ়াহ ৱহ মুঝে গ়ল্লা কী নজ়রেং, গুনাহ কী ক়ুরবানিযাঁ যা ক়ুসূর কী ক়ুরবানিযাঁ পেশ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","উসে মুক়দ্দস জগহ পর খানা। হর মর্দ উসে খা সকতা হৈ। খ়যাল রখ কি ৱহ মখ়সূসো-মুক়দ্দস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","মৈংনে মুক়র্রর কিযা হৈ কি তমাম হিলানেৱালী ক়ুরবানিযোং কা উঠাযা হুআ হিস্সা তেরা হৈ। যহ হমেশা কে লিএ তেরে ঔর তেরে বেটে-বেটিযোং কা হিস্সা হৈ। তেরে ঘরানে কা হর ফ়রদ উসে খা সকতা হৈ। শর্ত যহ হৈ কি ৱহ পাক হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","জব লোগ রব কো অপনী ফ়সলোং কা পহলা ফল পেশ করেংগে তো ৱহ তেরা হী হিস্সা হোগা। মৈং তুঝে জ়ৈতূন কে তেল, নঈ মৈ ঔর অনাজ কা বেহতরীন হিস্সা দেতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ফ়সলোং কা জো ভী পহলা ফল ৱহ রব কো পেশ করেংগে ৱহ তেরা হী হোগা। তেরে ঘরানে কা হর পাক ফ়রদ উসে খা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ইসরাঈল মেং জো ভী চীজ় রব কে লিএ মখ়সূসো-মুক়দ্দস কী গঈ হৈ ৱহ তেরী হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","হর ইনসান ঔর হর হৈৱান কা জো পহলৌঠা রব কো পেশ কিযা জাতা হৈ ৱহ তেরা হী হৈ। লেকিন লাজ়িম হৈ কি তূ হর ইনসান ঔর হর নাপাক জানৱর কে পহলৌঠে কা ফ়িদ্যা দেকর উসে ছুড়াএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","জব ৱহ এক মাহ কে হৈং তো উনকে এৱজ় চাঁদী কে পাঁচ সিক্কে দেনা। (হর সিক্কে কা ৱজ়ন মক়দিস কে বাটোং কে মুতাবিক় 11 গ্রাম হো)। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","লেকিন গায-বৈলোং ঔর ভেড়-বকরিযোং কে পহলে বচ্চোং কা ফ়িদ্যা যানী মুআৱজ়া ন দেনা। ৱহ মখ়সূসো-মুক়দ্দস হৈং। উনকা খ়ূন ক়ুরবানগাহ পর ছিড়ক দেনা ঔর উনকী চরবী জলা দেনা। ঐসী ক়ুরবানী রব কো পসংদ হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","উনকা গোশ্ত ৱৈসে হী তুম্হারে লিএ হো, জৈসে হিলানেৱালী ক়ুরবানী কা সীনা ঔর দহনী রান ভী তুম্হারে লিএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","মুক়দ্দস ক়ুরবানিযোং মেং সে তমাম উঠানেৱালী ক়ুরবানিযাঁ তেরা ঔর তেরে বেটে-বেটিযোং কা হিস্সা হৈং। মৈংনে উসে হমেশা কে লিএ তুঝে দিযা হৈ। যহ নমক কা দাযমী অহদ হৈ জো মৈংনে তেরে ঔর তেরী ঔলাদ কে সাথ ক়াযম কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","রব নে হারূন সে কহা, “তূ মীরাস মেং জ়মীন নহীং পাএগা। ইসরাঈল মেং তুঝে কোঈ হিস্সা নহীং দিযা জাএগা, ক্যোংকি ইসরাঈলিযোং কে দরমিযান মৈং হী তেরা হিস্সা ঔর তেরী মীরাস হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","অপনী পৈদাৱার কা জো দসৱাঁ হিস্সা ইসরাঈলী মুঝে দেতে হৈং ৱহ মৈং লাৱিযোং কো দেতা হূঁ। যহ উনকী ৱিরাসত হৈ, জো উন্হেং মুলাক়াত কে খ়ৈমে মেং খ়িদমত করনে কে বদলে মেং মিলতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","অব সে ইসরাঈলী মুলাক়াত কে খ়ৈমে কে ক়রীব ন আএঁ, ৱরনা উন্হেং অপনী খ়তা কা নতীজা বরদাশ্ত করনা পড়েগা ঔর ৱহ হলাক হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","সির্ফ় লাৱী মুলাক়াত কে খ়ৈমে মেং খ়িদমত করেং। অগর ইসমেং কোঈ গ়লতী হো জাএ তো ৱহী ক়ুসূরৱার ঠহরেংগে। যহ এক দাযমী উসূল হৈ। উন্হেং ইসরাঈল মেং মীরাস মেং জ়মীন নহীং মিলেগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ক্যোংকি মৈংনে উন্হেং ৱহী দসৱাঁ হিস্সা মীরাস কে তৌর পর দিযা হৈ জো ইসরাঈলী মুঝে উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ করতে হৈং। ইস ৱজহ সে মৈংনে উনকে বারে মেং কহা কি উন্হেং বাক়ী ইসরাঈলিযোং কে সাথ মীরাস মেং জ়মীন নহীং মিলেগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“লাৱিযোং কো বতানা কি তুম্হেং ইসরাঈলিযোং কী পৈদাৱার কা দসৱাঁ হিস্সা মিলেগা। যহ রব কী তরফ় সে তুম্হারী ৱিরাসত হোগী। লাজ়িম হৈ কি তুম ইসকা দসৱাঁ হিস্সা রব কো উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ করো। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","তুম্হারী যহ ক়ুরবানী নএ অনাজ যা নএ অংগূর কে রস কী ক়ুরবানী কে বরাবর ক়রার দী জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ইস তরহ তুম ভী রব কো ইসরাঈলিযোং কী পৈদাৱার কে দসৱেং হিস্সে মেং সে উঠানেৱালী ক়ুরবানী পেশ করোগে। রব কে লিএ যহ ক়ুরবানী হারূন ইমাম কো দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","জো ভী তুম্হেং মিলা হৈ উসমেং সে সবসে অচ্ছা ঔর মুক়দ্দস হিস্সা রব কো দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","জব তুম ইসকা সবসে অচ্ছা হিস্সা পেশ করোগে তো উসে নএ অনাজ যা নএ অংগূর কে রস কী ক়ুরবানী কে বরাবর ক়রার দিযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","তুম অপনে ঘরানোং সমেত ইসকা বাক়ী হিস্সা কহীং ভী খা সকতে হো, ক্যোংকি যহ মুলাক়াত কে খ়ৈমে মেং তুম্হারী খ়িদমত কা অজ্র হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","অগর তুমনে পহলে ইসকা বেহতরীন হিস্সা পেশ কিযা হো তো ফির ইসে খানে মেং তুম্হারা কোঈ ক়ুসূর নহীং হোগা। ফির ইসরাঈলিযোং কী মখ়সূসো-মুক়দ্দস ক়ুরবানিযাঁ তুমসে নাপাক নহীং হো জাএঁগী ঔর তুম নহীং মরোগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ইসরাঈলিযোং কো বতানা কি ৱহ তুম্হারে পাস সুর্খ় রংগ কী জৱান গায লেকর আএঁ। উসমেং নুক়্স ন হো ঔর উস পর কভী জুআ ন রখা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","তুম উসে ইলিযজ়র ইমাম কো দেনা জো উসে খ়ৈমে কে বাহর লে জাএ। ৱহাঁ উসে উস কী মৌজূদগী মেং জ়বহ কিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ফির ইলিযজ়র ইমাম অপনী উঁগলী সে উসকে খ়ূন সে কুছ লেকর মুলাক়াত কে খ়ৈমে কে সামনেৱালে হিস্সে কী তরফ় ছিড়কে। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","উস কী মৌজূদগী মেং পূরী কী পূরী গায কো জলাযা জাএ। উস কী খাল, গোশ্ত, খ়ূন ঔর অংতড়িযোং কা গোবর ভী জলাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ফির ৱহ দেৱদার কী লকড়ী, জ়ূফ়া ঔর ক়িরমিজ়ী রংগ কা ধাগা লেকর উসে জলতী হুঈ গায পর ফেংকে। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ইসকে বাদ ৱহ অপনে কপড়োং কো ধোকর নহা লে। ফির ৱহ খ়ৈমাগাহ মেং আ সকতা হৈ লেকিন শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","জিস আদমী নে গায কো জলাযা ৱহ ভী অপনে কপড়োং কো ধোকর নহা লে। ৱহ ভী শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","এক দূসরা আদমী জো পাক হৈ গায কী রাখ ইকট্ঠী করকে খ়ৈমাগাহ কে বাহর কিসী পাক জগহ পর ডাল দে। ৱহাঁ ইসরাঈল কী জমাত উসে নাপাকী দূর করনে কা পানী তৈযার করনে কে লিএ মহফ়ূজ় রখে। যহ গুনাহ সে পাক করনে কে লিএ ইস্তেমাল হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","জিস আদমী নে রাখ ইকট্ঠী কী হৈ ৱহ ভী অপনে কপড়োং কো ধো লে। ৱহ ভী শাম তক নাপাক রহেগা। যহ ইসরাঈলিযোং ঔর উনকে দরমিযান রহনেৱালে পরদেসিযোং কে লিএ দাযমী উসূল হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","জো ভী লাশ ছুএ ৱহ সাত দিন তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","তীসরে ঔর সাতৱেং দিন ৱহ অপনে আপ পর নাপাকী দূর করনে কা পানী ছিড়ককর পাক-সাফ় হো জাএ। ইসকে বাদ হী ৱহ পাক হোগা। লেকিন অগর ৱহ ইন দোনোং দিনোং মেং অপনে আপকো যোং পাক ন করে তো নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","জো ভী লাশ ছূকর অপনে আপকো যোং পাক নহীং করতা ৱহ রব কে মক়দিস কো নাপাক করতা হৈ। লাজ়িম হৈ কি উসে ইসরাঈল মেং সে মিটাযা জাএ। চূঁকি নাপাকী দূর করনে কা পানী উস পর ছিড়কা নহীং গযা ইসলিএ ৱহ নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","অগর কোঈ ডেরে মেং মর জাএ তো জো ভী উস ৱক়্ত উসমেং মৌজূদ হো যা দাখ়িল হো জাএ ৱহ সাত দিন তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","হর খুলা বরতন জো ঢকনে সে বংদ ন কিযা গযা হো ৱহ ভী নাপাক হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ইসী তরহ জো খুলে মৈদান মেং লাশ ছুএ ৱহ ভী সাত দিন তক নাপাক রহেগা, খ়াহ ৱহ তলৱার সে যা তবঈ মৌত মরা হো। জো ইনসান কী কোঈ হড্ডী যা ক়ব্র ছুএ ৱহ ভী সাত দিন তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","নাপাকী দূর করনে কে লিএ উস সুর্খ় রংগ কী গায কী রাখ মেং সে কুছ লেনা জো গুনাহ দূর করনে কে লিএ জলাঈ গঈ থী। উসে বরতন মেং ডালকর তাজ়া পানী মেং মিলানা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ফির কোঈ পাক আদমী কুছ জ়ূফ়া লে ঔর উসে উস পানী মেং ডুবোকর মরে হুএ শখ়্স কে খ়ৈমে, উসকে সামান ঔর উন লোগোং পর ছিড়কে জো উসকে মরতে ৱক়্ত ৱহাঁ থে। ইসী তরহ ৱহ পানী উস শখ়্স পর ভী ছিড়কে জিসনে তবঈ যা গ়ৈরতবঈ মৌত মরে হুএ শখ়্স কো, কিসী ইনসান কী হড্ডী কো যা কোঈ ক়ব্র ছূঈ হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","পাক আদমী যহ পানী তীসরে ঔর সাতৱেং দিন নাপাক শখ়্স পর ছিড়কে। সাতৱেং দিন ৱহ উসে পাক করে। জিসে পাক কিযা জা রহা হৈ ৱহ অপনে কপড়ে ধোকর নহা লে তো ৱহ উসী শাম পাক হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","লেকিন জো নাপাক শখ়্স অপনে আপকো পাক নহীং করতা উসে জমাত মেং সে মিটানা হৈ, ক্যোংকি উসনে রব কা মক়দিস নাপাক কর দিযা হৈ। নাপাকী দূর করনে কা পানী উস পর নহীং ছিড়কা গযা, ইসলিএ ৱহ নাপাক রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","যহ উনকে লিএ দাযমী উসূল হৈ। জিস আদমী নে নাপাকী দূর করনে কা পানী ছিড়কা হৈ ৱহ ভী অপনে কপড়ে ধোএ। বল্কি জিসনে ভী যহ পানী ছুআ হৈ শাম তক নাপাক রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ঔর নাপাক শখ়্স জো ভী চীজ় ছুএ ৱহ নাপাক হো জাতী হৈ। ন সির্ফ় যহ বল্কি জো বাদ মেং যহ নাপাক চীজ় ছুএ ৱহ ভী শাম তক নাপাক রহেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","পহলে মহীনে মেং ইসরাঈল কী পূরী জমাত দশ্তে-সীন মেং পহুঁচকর ক়াদিস মেং রহনে লগী। ৱহাঁ মরিযম নে ৱফ়াত পাঈ ঔর ৱহীং উসে দফ়নাযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ক়াদিস মেং পানী দস্তযাব নহীং থা, ইসলিএ লোগ মূসা ঔর হারূন কে মুক়াবলে মেং জমা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ৱহ মূসা সে যহ কহকর ঝগড়নে লগে, “কাশ হম অপনে ভাইযোং কে সাথ রব কে সামনে মর গএ হোতে! ");
INSERT INTO urdgvb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","আপ রব কী জমাত কো ক্যোং ইস রেগিস্তান মেং লে আএ? ক্যা ইসলিএ কি হম যহাঁ অপনে মৱেশিযোং সমেত মর জাএঁ? ");
INSERT INTO urdgvb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","আপ হমেং মিসর সে নিকালকর উস নাখ়ুশগৱার জগহ পর ক্যোং লে আএ হৈং? যহাঁ ন তো অনাজ, ন অংজীর, অংগূর যা অনার দস্তযাব হৈং। পানী ভী নহীং হৈ!” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","মূসা ঔর হারূন লোগোং কো ছোড়কর মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর গএ ঔর মুঁহ কে বল গিরে। তব রব কা জলাল উন পর জ়াহির হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“অহদ কে সংদূক় কে সামনে পড়ী লাঠী পকড়কর হারূন কে সাথ জমাত কো ইকট্ঠা কর। উনকে সামনে চট্টান সে বাত করো তো ৱহ অপনা পানী দেগী। যোং তূ চট্টান মেং সে জমাত কে লিএ পানী নিকালকর উন্হেং উনকে মৱেশিযোং সমেত পানী পিলাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","মূসা নে ঐসা হী কিযা। উসনে অহদ কে সংদূক় কে সামনে পড়ী লাঠী উঠাঈ ");
INSERT INTO urdgvb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ঔর হারূন কে সাথ জমাত কো চট্টান কে সামনে ইকট্ঠা কিযা। মূসা নে উনসে কহা, “ঐ বগ়াৱত করনেৱালো, সুনো! ক্যা হম ইস চট্টান মেং সে তুম্হারে লিএ পানী নিকালেং?” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","উসনে লাঠী কো উঠাকর চট্টান কো দো মরতবা মারা তো বহুত-সা পানী ফূট নিকলা। জমাত ঔর উনকে মৱেশিযোং নে খ়ূব পানী পিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","লেকিন রব নে মূসা ঔর হারূন সে কহা, “তুম্হারা মুঝ পর ইতনা ঈমান নহীং থা কি মেরী ক়ুদ্দূসিযত কো ইসরাঈলিযোং কে সামনে ক়াযম রখতে। ইসলিএ তুম উস জমাত কো উস মুল্ক মেং নহীং লে জাওগে জো মৈং উন্হেং দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","যহ ৱাক়িযা মরীবা যানী ‘ঝগড়না’ কে পানী পর হুআ। ৱহাঁ ইসরাঈলিযোং নে রব সে ঝগড়া কিযা, ঔর ৱহাঁ উসনে উন পর জ়াহির কিযা কি ৱহ ক়ুদ্দূস হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ক়াদিস সে মূসা নে অদোম কে বাদশাহ কো ইত্তলা ভেজী, “আপকে ভাঈ ইসরাঈল কী তরফ় সে এক গুজ়ারিশ হৈ। আপকো উন তমাম মুসীবতোং কে বারে মেং ইল্ম হৈ জো হম পর আন পড়ী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","হমারে বাপদাদা মিসর গএ থে ঔর ৱহাঁ হম বহুত অরসে তক রহে। মিসরিযোং নে হমারে বাপদাদা ঔর হমসে বুরা সুলূক কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","লেকিন জব হমনে চিল্লাকর রব সে মিন্নত কী তো উসনে হমারী সুনী ঔর ফ়রিশ্তা ভেজকর হমেং মিসর সে নিকাল লাযা। অব হম যহাঁ ক়াদিস শহর মেং হৈং জো আপকী সরহদ পর হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","মেহরবানী করকে হমেং অপনে মুল্ক মেং সে গুজ়রনে দেং। হম কিসী খেত যা অংগূর কে বাগ় মেং নহীং জাএংগে, ন কিসী কুএঁ কা পানী পিএঁগে। হম শাহরাহ পর হী রহেংগে। আপকে মুল্ক মেং সে গুজ়রতে হুএ হম উসসে ন দাঈং ঔর ন বাঈং তরফ় হটেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","লেকিন অদোমিযোং নে জৱাব দিযা, “যহাঁ সে ন গুজ়রনা, ৱরনা হম নিকলকর আপসে লড়েংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ইসরাঈল নে দুবারা খ়বর ভেজী, “হম শাহরাহ পর রহতে হুএ গুজ়রেংগে। অগর হমেং যা হমারে জানৱরোং কো পানী কী জ়রূরত হুঈ তো পৈসে দেকর খ়রীদ লেংগে। হম পৈদল হী গুজ়রনা চাহতে হৈং, ঔর কুছ নহীং চাহতে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","লেকিন অদোমিযোং নে দুবারা ইনকার কিযা। সাথ হী উন্হোংনে উনকে সাথ লড়নে কে লিএ এক বড়ী ঔর তাক়তৱর ফ়ৌজ ভেজী। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","চূঁকি অদোম নে উন্হেং গুজ়রনে কী ইজাজ়ত ন দী ইসলিএ ইসরাঈলী মুড়কর দূসরে রাস্তে সে চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ইসরাঈল কী পূরী জমাত ক়াদিস সে রৱানা হোকর হোর পহাড় কে পাস পহুঁচী। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","যহ পহাড় অদোম কী সরহদ পর ৱাক়ে থা। ৱহাঁ রব নে মূসা ঔর হারূন সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“হারূন অব কূচ করকে অপনে বাপদাদা সে জা মিলেগা। ৱহ উস মুল্ক মেং দাখ়িল নহীং হোগা জো মৈং ইসরাঈলিযোং কো দূঁগা, ক্যোংকি তুম দোনোং নে মরীবা কে পানী পর মেরে হুক্ম কী খ়িলাফ়ৱরজ়ী কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","হারূন ঔর উসকে বেটে ইলিযজ়র কো লেকর হোর পহাড় পর চঢ় জা। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","হারূন কে কপড়ে উতারকর উসকে বেটে ইলিযজ়র কো পহনা দেনা। ফির হারূন কূচ করকে অপনে বাপদাদা সে জা মিলেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","মূসা নে ঐসা হী কিযা জৈসা রব নে কহা। তীনোং পূরী জমাত কে দেখতে দেখতে হোর পহাড় পর চঢ় গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","মূসা নে হারূন কে কপড়ে উতরৱাকর উসকে বেটে ইলিযজ়র কো পহনা দিএ। ফির হারূন ৱহাঁ পহাড় কী চোটী পর ফ়ৌত হুআ, ঔর মূসা ঔর ইলিযজ়র নীচে উতর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","জব পূরী জমাত কো মালূম হুআ কি হারূন ইংতক়াল কর গযা হৈ তো সবনে 30 দিন তক উসকে লিএ মাতম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","দশ্তে-নজব কে কনানী মুল্ক অরাদ কে বাদশাহ কো খ়বর মিলী কি ইসরাঈলী অথারিম কী তরফ় বঢ় রহে হৈং। উসনে উন পর হমলা কিযা ঔর কঈ এক কো পকড়কর ক়ৈদ কর লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","তব ইসরাঈলিযোং নে রব কে সামনে মন্নত মানকর কহা, “অগর তূ হমেং উন পর ফ়তহ দেগা তো হম উন্হেং উনকে শহরোং সমেত তবাহ কর দেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","রব নে উনকী সুনী ঔর কনানিযোং পর ফ়তহ বখ়্শী। ইসরাঈলিযোং নে উন্হেং উনকে শহরোং সমেত পূরী তরহ তবাহ কর দিযা। ইসলিএ উস জগহ কা নাম হুরমা যানী তবাহী পড় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","হোর পহাড় সে রৱানা হোকর ৱহ বহরে-ক়ুলজ়ুম কী তরফ় চল দিএ তাকি অদোম কে মুল্ক মেং সে গুজ়রনা ন পড়ে। লেকিন চলতে চলতে লোগ বেসবর হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ৱহ রব ঔর মূসা কে খ়িলাফ় বাতেং করনে লগে, “আপ হমেং মিসর সে নিকালকর রেগিস্তান মেং মরনে কে লিএ ক্যোং লে আএ হৈং? যহাঁ ন রোটী দস্তযাব হৈ ন পানী। হমেং ইস ঘটিযা ক়িস্ম কী খ়ুরাক সে ঘিন আতী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","তব রব নে উনকে দরমিযান জ়হরীলে সাঁপ ভেজ দিএ জিনকে কাটনে সে বহুত-সে লোগ মর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ফির লোগ মূসা কে পাস আএ। উন্হোংনে কহা, “হমনে রব ঔর আপকে খ়িলাফ় বাতেং করতে হুএ গুনাহ কিযা। হমারী সিফ়ারিশ করেং কি রব হমসে সাঁপ দূর কর দে।” মূসা নে উনকে লিএ দুআ কী ");
INSERT INTO urdgvb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","তো রব নে মূসা সে কহা, “এক সাঁপ বনাকর উসে খংবে সে লটকা দে। জো ভী ডসা গযা হো ৱহ উসে দেখকর বচ জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","চুনাঁচে মূসা নে পীতল কা এক সাঁপ বনাযা ঔর খংবা খড়া করকে সাঁপ কো উসসে লটকা দিযা। ঔর ঐসা হুআ কি জিসে ভী ডসা গযা থা ৱহ পীতল কে সাঁপ পর নজ়র করকে বচ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ইসরাঈলী রৱানা হুএ ঔর ওবোত মেং অপনে খ়ৈমে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ফির ৱহাঁ সে কূচ করকে ঐযে-অবারীম মেং ডেরে ডালে, উস রেগিস্তান মেং জো মশরিক় কী তরফ় মোআব কে সামনে হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ৱহাঁ সে রৱানা হোকর ৱহ ৱাদীএ-জ়িরদ মেং খ়ৈমাজ়ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","জব ৱাদীএ-জ়িরদ সে রৱানা হুএ তো দরিযাএ-অরনোন কে পরলে যানী জুনূবী কিনারে পর খ়ৈমাজ়ন হুএ। যহ দরিযা রেগিস্তান মেং হৈ ঔর অমোরিযোং কে ইলাক়ে সে নিকলতা হৈ। যহ অমোরিযোং ঔর মোআবিযোং কে দরমিযান কী সরহদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ইসকা জ়িক্র কিতাব ‘রব কী জংগেং’ মেং ভী হৈ, “ৱাহেব জো সূফ়া মেং হৈ, দরিযাএ-অরনোন কী ৱাদিযাঁ ");
INSERT INTO urdgvb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ঔর ৱাদিযোং কা ৱহ ঢলান জো আর শহর তক জাতা হৈ ঔর মোআব কী সরহদ পর ৱাক়ে হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ৱহাঁ সে ৱহ বৈর যানী ‘কুআঁ’ পহুঁচে। যহ ৱহী বৈর হৈ জহাঁ রব নে মূসা সে কহা, “লোগোং কো ইকট্ঠা কর তো মৈং উন্হেং পানী দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","উস ৱক়্ত ইসরাঈলিযোং নে যহ গীত গাযা, “ঐ কুএঁ, ফূট নিকল! উসকে বারে মেং গীত গাও, ");
INSERT INTO urdgvb_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","উস কুএঁ কে বারে মেং জিসে সরদারোং নে খোদা, জিসে ক়ৌম কে রাহনুমাওং নে অসাএ-শাহী ঔর অপনী লাঠিযোং সে খোদা।” ফির ৱহ রেগিস্তান সে মত্তনা কো গএ, ");
INSERT INTO urdgvb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","মত্তনা সে নহলিযেল কো ঔর নহলিযেল সে বামাত কো। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","বামাত সে ৱহ মোআবিযোং কে ইলাক়ে কী উস ৱাদী মেং পহুঁচে জো পিসগা পহাড় কে দামন মেং হৈ। ইস পহাড় কী চোটী সে ৱাদীএ-যরদন কা জুনূবী হিস্সা যশীমোন খ়ূব নজ়র আতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ইসরাঈল নে অমোরিযোং কে বাদশাহ সীহোন কো ইত্তলা ভেজী, ");
INSERT INTO urdgvb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“হমেং অপনে মুল্ক মেং সে গুজ়রনে দেং। হম সীধে সীধে গুজ়র জাএংগে। ন হম কোঈ খেত যা অংগূর কা বাগ় ছেড়েংগে, ন কিসী কুএঁ কা পানী পিএঁগে। হম আপকে মুল্ক মেং সে সীধে গুজ়রতে হুএ শাহরাহ পর হী রহেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","লেকিন সীহোন নে উন্হেং গুজ়রনে ন দিযা বল্কি অপনী ফ়ৌজ জমা করকে ইসরাঈল সে লড়নে কে লিএ রেগিস্তান মেং চল পড়া। যহজ় পহুঁচকর উসনে ইসরাঈলিযোং সে জংগ কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","লেকিন ইসরাঈলিযোং নে উসে ক়ত্ল কিযা ঔর দরিযাএ-অরনোন সে লেকর দরিযাএ-যব্বোক় তক যানী অম্মোনিযোং কী সরহদ তক উসকে মুল্ক পর ক়ব্জ়া কর লিযা। ৱহ ইসসে আগে ন জা সকে ক্যোংকি অম্মোনিযোং নে অপনী সরহদ কী হিসারবংদী কর রখী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ইসরাঈলী তমাম অমোরী শহরোং পর ক়ব্জ়া করকে উনমেং রহনে লগে। উনমেং হসবোন ঔর উসকে ইর্দগির্দ কী আবাদিযাঁ শামিল থীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","হসবোন অমোরী বাদশাহ সীহোন কা দারুল-হুকূমত থা। উসনে মোআব কে পিছলে বাদশাহ সে লড়কর উসসে যহ ইলাক়া দরিযাএ-অরনোন তক ছীন লিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","উস ৱাক়িযে কা জ়িক্র শাযরী মেং যোং কিযা গযা হৈ, “হসবোন কে পাস আকর উসে অজ় সরে-নৌ তামীর করো, সীহোন কে শহর কো অজ় সরে-নৌ ক়াযম করো। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","হসবোন সে আগ নিকলী, সীহোন কে শহর সে শোলা ভড়কা। উসনে মোআব কে শহর আর কো জলা দিযা, অরনোন কী বুলংদিযোং কে মালিকোং কো ভস্ম কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ঐ মোআব, তুঝ পর অফ়সোস! ঐ কমোস দেৱতা কী ক়ৌম, তূ হলাক হুঈ হৈ। কমোস নে অপনে বেটোং কো মফ়রূর ঔর অপনী বেটিযোং কো অমোরী বাদশাহ সীহোন কী ক়ৈদী বনা দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","লেকিন জব হমনে অমোরিযোং পর তীর চলাএ তো হসবোন কা ইলাক়া দীবোন তক বরবাদ হুআ। হমনে নুফ়হ তক সব কুছ তবাহ কিযা, ৱহ নুফ়হ জিসকা ইলাক়া মীদবা তক হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","যোং ইসরাঈল অমোরিযোং কে মুল্ক মেং আবাদ হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ৱহাঁ সে মূসা নে অপনে জাসূস যাজ়ের শহর ভেজে। ৱহাঁ ভী অমোরী রহতে থে। ইসরাঈলিযোং নে যাজ়ের ঔর উসকে ইর্দগির্দ কে শহরোং পর ভী ক়ব্জ়া কিযা ঔর ৱহাঁ কে অমোরিযোং কো নিকাল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ইসকে বাদ ৱহ মুড়কর বসন কী তরফ় বঢ়ে। তব বসন কা বাদশাহ ওজ অপনী তমাম ফ়ৌজ লেকর উনসে লড়নে কে লিএ শহর ইদরঈ আযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","উস ৱক়্ত রব নে মূসা সে কহা, “ওজ সে ন ডরনা। মৈং উসে, উস কী তমাম ফ়ৌজ ঔর উসকা মুল্ক তেরে হৱালে কর চুকা হূঁ। উসকে সাথ ৱহী সুলূক কর জো তূনে অমোরিযোং কে বাদশাহ সীহোন কে সাথ কিযা, জিসকা দারুল-হুকূমত হসবোন থা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ইসরাঈলিযোং নে ওজ, উসকে বেটোং ঔর তমাম ফ়ৌজ কো হলাক কর দিযা। কোঈ ভী ন বচা। ফির উন্হোংনে বসন কে মুল্ক পর ক়ব্জ়া কর লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ইসকে বাদ ইসরাঈলী মোআব কে মৈদানোং মেং পহুঁচকর দরিযাএ-যরদন কে মশরিক়ী কিনারে পর যরীহূ কে আমনে-সামনে খ়ৈমাজ়ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","মোআব কে বাদশাহ বলক় বিন সফ়োর কো মালূম হুআ কি ইসরাঈলিযোং নে অমোরিযোং কে সাথ ক্যা কুছ কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","মোআবিযোং নে যহ ভী দেখা কি ইসরাঈলী বহুত জ়্যাদা হৈং, ইসলিএ উন পর দহশত ছা গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","উন্হোংনে মিদিযানিযোং কে বুজ়ুর্গোং সে বাত কী, “অব যহ হুজূম উস তরহ হমারে ইর্দগির্দ কা ইলাক়া চট কর জাএগা জিস তরহ বৈল মৈদান কী ঘাস চট কর জাতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","তব বলক় নে অপনে ক়াসিদ ফ়তোর শহর কো ভেজে জো দরিযাএ-ফ়ুরাত পর ৱাক়ে থা ঔর জহাঁ বিলাম বিন বওর অপনে ৱতন মেং রহতা থা। ক়াসিদ উসে বুলানে কে লিএ উসকে পাস পহুঁচে ঔর উসে বলক় কা পৈগ়াম সুনাযা, “এক ক়ৌম মিসর সে নিকল আঈ হৈ জো রূএ-জ়মীন পর ছাকর মেরে ক়রীব হী আবাদ হুঈ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ইসলিএ আএঁ ঔর ইন লোগোং পর লানত ভেজেং, ক্যোংকি ৱহ মুঝসে জ়্যাদা তাক়তৱর হৈং। ফির শাযদ মৈং উন্হেং শিকস্ত দেকর মুল্ক সে ভগা সকূঁ। ক্যোংকি মৈং জানতা হূঁ কি জিন্হেং আপ বরকত দেতে হৈং উন্হেং বরকত মিলতী হৈ ঔর জিন পর আপ লানত ভেজতে হৈং উন পর লানত আতী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","যহ পৈগ়াম লেকর মোআব ঔর মিদিযান কে বুজ়ুর্গ রৱানা হুএ। উনকে পাস ইনাম কে পৈসে থে। বিলাম কে পাস পহুঁচকর উন্হোংনে উসে বলক় কা পৈগ়াম সুনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","বিলাম নে কহা, “রাত যহাঁ গুজ়ারেং। কল মৈং আপকো বতা দূঁগা কি রব ইসকে বারে মেং ক্যা ফ়রমাতা হৈ।” চুনাঁচে মোআবী সরদার উসকে পাস ঠহর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","রাত কে ৱক়্ত অল্লাহ বিলাম পর জ়াহির হুআ। উসনে পূছা, “যহ আদমী কৌন হৈং জো তেরে পাস আএ হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","বিলাম নে জৱাব দিযা, “মোআব কে বাদশাহ বলক় বিন সফ়োর নে মুঝে পৈগ়াম ভেজা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘জো ক়ৌম মিসর সে নিকল আঈ হৈ ৱহ রূএ-জ়মীন পর ছা গঈ হৈ। ইসলিএ আএঁ ঔর মেরে লিএ উন পর লানত ভেজেং। ফির শাযদ মৈং উনসে লড়কর উন্হেং ভগা দেনে মেং কামযাব হো জাঊঁ’।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","রব নে বিলাম সে কহা, “উনকে সাথ ন জানা। তুঝে উন পর লানত ভেজনে কী ইজাজ়ত নহীং হৈ, ক্যোংকি উন পর মেরী বরকত হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","অগলী সুবহ বিলাম জাগ উঠা তো উসনে বলক় কে সরদারোং সে কহা, “অপনে ৱতন ৱাপস চলে জাএঁ, ক্যোংকি রব নে মুঝে আপকে সাথ জানে কী ইজাজ়ত নহীং দী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","চুনাঁচে মোআবী সরদার খ়ালী হাথ বলক় কে পাস ৱাপস আএ। উন্হোংনে কহা, “বিলাম হমারে সাথ আনে সে ইনকার করতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","তব বলক় নে ঔর সরদার ভেজে জো পহলেৱালোং কী নিসবত তাদাদ ঔর ওহদে কে লিহাজ় সে জ়্যাদা থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ৱহ বিলাম কে পাস জাকর কহনে লগে, “বলক় বিন সফ়োর কহতে হৈং কি কোঈ ভী বাত আপকো মেরে পাস আনে সে ন রোকে, ");
INSERT INTO urdgvb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ক্যোংকি মৈং আপকো বড়া ইনাম দূঁগা। আপ জো ভী কহেংগে মৈং করনে কে লিএ তৈযার হূঁ। আএঁ তো সহী ঔর মেরে লিএ উন লোগোং পর লানত ভেজেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","লেকিন বিলাম নে জৱাব দিযা, “অগর বলক় অপনে মহল কো চাঁদী ঔর সোনে সে ভরকর ভী মুঝে দে তো ভী মৈং রব অপনে খ়ুদা কে ফ়রমান কী খ়িলাফ়ৱরজ়ী নহীং কর সকতা, খ়াহ বাত ছোটী হো যা বড়ী। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","আপ দূসরে সরদারোং কী তরহ রাত যহাঁ গুজ়ারেং। ইতনে মেং মৈং মালূম করূঁগা কি রব মুঝে মজ়ীদ ক্যা কুছ বতাতা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","উস রাত অল্লাহ বিলাম পর জ়াহির হুআ ঔর কহা, “চূঁকি যহ আদমী তুঝে বুলানে আএ হৈং ইসলিএ উনকে সাথ চলা জা। লেকিন সির্ফ় ৱহী কুছ করনা জো মৈং তুঝে বতাঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","সুবহ কো বিলাম নে উঠকর অপনী গধী পর জ়ীন কসা ঔর মোআবী সরদারোং কে সাথ চল পড়া। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","লেকিন অল্লাহ নিহাযত গ়ুস্সে হুআ কি ৱহ জা রহা হৈ, ইসলিএ উসকা ফ়রিশ্তা উসকা মুক়াবলা করনে কে লিএ রাস্তে মেং খড়া হো গযা। বিলাম অপনী গধী পর সৱার থা ঔর উসকে দো নৌকর উসকে সাথ চল রহে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","জব গধী নে দেখা কি রব কা ফ়রিশ্তা অপনে হাথ মেং তলৱার থামে হুএ রাস্তে মেং খড়া হৈ তো ৱহ রাস্তে সে হটকর খেত মেং চলনে লগী। বিলাম উসে মারতে মারতে রাস্তে পর ৱাপস লে আযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ফির ৱহ অংগূর কে দো বাগ়োং কে দরমিযান সে গুজ়রনে লগে। রাস্তা তংগ থা, ক্যোংকি ৱহ দোনোং তরফ় বাগ়োং কী চারদীৱারী সে বংদ থা। অব রব কা ফ়রিশ্তা ৱহাঁ খড়া হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","গধী যহ দেখকর চারদীৱারী কে সাথ সাথ চলনে লগী, ঔর বিলাম কা পাঁৱ কুচলা গযা। উসনে উসে দুবারা মারা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","রব কা ফ়রিশ্তা আগে নিকলা ঔর তীসরী মরতবা রাস্তে মেং খড়া হো গযা। অব রাস্তে সে হট জানে কী কোঈ গুংজাইশ নহীং থী, ন দাঈং তরফ় ঔর ন বাঈং তরফ়। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","জব গধী নে রব কা ফ়রিশ্তা দেখা তো ৱহ লেট গঈ। বিলাম কো গ়ুস্সা আ গযা, ঔর উসনে উসে অপনী লাঠী সে খ়ূব মারা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","তব রব নে গধী কো বোলনে দিযা, ঔর উসনে বিলাম সে কহা, “মৈংনে আপসে ক্যা গ়লত সুলূক কিযা হৈ কি আপ মুঝে অব তীসরী দফ়া পীট রহে হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","বিলাম নে জৱাব দিযা, “তূনে মুঝে বেৱুক়ূফ় বনাযা হৈ! কাশ মেরে হাথ মেং তলৱার হোতী তো মৈং অভী তুঝে জ়বহ কর দেতা!” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","গধী নে বিলাম সে কহা, “ক্যা মৈং আপকী গধী নহীং হূঁ জিস পর আপ আজ তক সৱার হোতে রহে হৈং? ক্যা মুঝে কভী ঐসা করনে কী আদত থী?” উসনে কহা, “নহীং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ফির রব নে বিলাম কী আঁখেং খোলীং ঔর উসনে রব কে ফ়রিশ্তে কো দেখা জো অব তক হাথ মেং তলৱার থামে হুএ রাস্তে মেং খড়া থা। বিলাম নে মুঁহ কে বল গিরকর সিজদা কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","রব কে ফ়রিশ্তে নে পূছা, “তূনে তীন বার অপনী গধী কো ক্যোং পীটা? মৈং তেরে মুক়াবলে মেং আযা হূঁ, ক্যোংকি জিস তরফ় তূ বঢ় রহা হৈ উসকা অংজাম বুরা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","গধী তীন মরতবা মুঝে দেখকর মেরী তরফ় সে হট গঈ। অগর ৱহ ন হটতী তো তূ উস ৱক়্ত হলাক হো গযা হোতা অগরচে মৈং গধী কো ছোড় দেতা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","বিলাম নে রব কে ফ়রিশ্তে সে কহা, “মৈংনে গুনাহ কিযা হৈ। মুঝে মালূম নহীং থা কি তূ মেরে মুক়াবলে মেং রাস্তে মেং খড়া হৈ। লেকিন অগর মেরা সফ়র তুঝে বুরা লগে তো মৈং অব ৱাপস চলা জাঊঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","রব কে ফ়রিশ্তে নে কহা, “ইন আদমিযোং কে সাথ অপনা সফ়র জারী রখ। লেকিন সির্ফ় ৱহী কুছ কহনা জো মৈং তুঝে বতাঊঁগা।” চুনাঁচে বিলাম নে বলক় কে সরদারোং কে সাথ অপনা সফ়র জারী রখা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","জব বলক় কো খ়বর মিলী কি বিলাম আ রহা হৈ তো ৱহ উসসে মিলনে কে লিএ মোআব কে উস শহর তক গযা জো মোআব কী সরহদ দরিযাএ-অরনোন পর ৱাক়ে হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","উসনে বিলাম সে কহা, “ক্যা মৈংনে আপকো ইত্তলা নহীং ভেজী থী কি আপ জ়রূর আএঁ? আপ ক্যোং নহীং আএ? ক্যা আপনে সোচা কি মৈং আপকো মুনাসিব ইনাম নহীং দে পাঊঁগা?” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","বিলাম নে জৱাব দিযা, “বহরহাল অব মৈং পহুঁচ গযা হূঁ। লেকিন মৈং সির্ফ় ৱহী কুছ কহ সকতা হূঁ জো অল্লাহ নে পহলে হী মেরে মুঁহ মেং ডাল দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ফির বিলাম বলক় কে সাথ ক়িরিযত-হুসাত গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ৱহাঁ বলক় নে গায-বৈল ঔর ভেড়-বকরিযাঁ ক়ুরবান করকে উনকে গোশ্ত মেং সে বিলাম ঔর উসকে সাথৱালে সরদারোং কো দে দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","অগলী সুবহ বলক় বিলাম কো সাথ লেকর এক ঊঁচী জগহ পর চঢ় গযা জিসকা নাম বামোত-বাল থা। ৱহাঁ সে ইসরাঈলী খ়ৈমাগাহ কা কিনারা নজ়র আতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","বিলাম নে কহা, “যহাঁ মেরে লিএ সাত ক়ুরবানগাহেং বনাএঁ। সাথ সাথ মেরে লিএ সাত বৈল ঔর সাত মেংঢে তৈযার কর রখেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","বলক় নে ঐসা হী কিযা, ঔর দোনোং নে মিলকর হর ক়ুরবানগাহ পর এক বৈল ঔর এক মেংঢা চঢ়াযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ফির বিলাম নে বলক় সে কহা, “যহাঁ অপনী ক়ুরবানী কে পাস খড়ে রহেং। মৈং কুছ ফ়াসলে পর জাতা হূঁ, শাযদ রব মুঝসে মিলনে আএ। জো কুছ ৱহ মুঝ পর জ়াহির করে মৈং আপকো বতা দূঁগা।” যহ কহকর ৱহ এক ঊঁচে মক়াম পর চলা গযা জো হরিযালী সে বিলকুল মহরূম থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ৱহাঁ অল্লাহ বিলাম সে মিলা। বিলাম নে কহা, “মৈংনে সাত ক়ুরবানগাহেং তৈযার করকে হর ক়ুরবানগাহ পর এক বৈল ঔর এক মেংঢা ক়ুরবান কিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","তব রব নে উসে বলক় কে লিএ পৈগ়াম দিযা ঔর কহা, “বলক় কে পাস ৱাপস জা ঔর উসে যহ পৈগ়াম সুনা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","বিলাম বলক় কে পাস ৱাপস আযা জো অব তক মোআবী সরদারোং কে সাথ অপনী ক়ুরবানী কে পাস খড়া থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","বিলাম বোল উঠা, “বলক় মুঝে অরাম সে যহাঁ লাযা হৈ, মোআবী বাদশাহ নে মুঝে মশরিক়ী পহাড়োং সে বুলাকর কহা, ‘আও, যাক়ূব পর মেরে লিএ লানত ভেজো। আও, ইসরাঈল কো বদদুআ দো।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","মৈং কিস তরহ উন পর লানত ভেজূঁ জিন পর অল্লাহ নে লানত নহীং ভেজী? মৈং কিস তরহ উন্হেং বদদুআ দূঁ জিন্হেং রব নে বদদুআ নহীং দী? ");
INSERT INTO urdgvb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","মৈং উন্হেং চট্টানোং কী চোটী সে দেখতা হূঁ, পহাড়িযোং সে উনকা মুশাহদা করতা হূঁ। ৱাক়ঈ যহ এক ঐসী ক়ৌম হৈ জো দূসরোং সে অলগ রহতী হৈ। যহ অপনে আপকো দূসরী ক়ৌমোং সে মুমতাজ় সমঝতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","কৌন যাক়ূব কী ঔলাদ কো গিন সকতা হৈ জো গর্দ কী মানিংদ বেশুমার হৈ। কৌন ইসরাঈলিযোং কা চৌথা হিস্সা ভী গিন সকতা হৈ? রব করে কি মৈং রাস্তবাজ়োং কী মৌত মরূঁ, কি মেরা অংজাম উনকে অংজাম জৈসা অচ্ছা হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","বলক় নে বিলাম সে কহা, “আপনে মেরে সাথ ক্যা কিযা হৈ? মৈং আপকো অপনে দুশ্মনোং পর লানত ভেজনে কে লিএ লাযা ঔর আপনে উন্হেং অচ্ছী-খ়াসী বরকত দী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","বিলাম নে জৱাব দিযা, “ক্যা লাজ়িম নহীং কি মৈং ৱহী কুছ বোলূঁ জো রব নে বতানে কো কহা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ফির বলক় নে উসসে কহা, “আএঁ, হম এক ঔর জগহ জাএঁ জহাঁ সে আপ ইসরাঈলী ক়ৌম কো দেখ সকেংগে, গো উনকী খ়ৈমাগাহ কা সির্ফ় কিনারা হী নজ়র আএগা। আপ সবকো নহীং দেখ সকেংগে। ৱহীং সে উন পর মেরে লিএ লানত ভেজেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","যহ কহকর ৱহ উসকে সাথ পিসগা কী চোটী পর চঢ়কর পহরেদারোং কে মৈদান তক পহুঁচ গযা। ৱহাঁ ভী উসনে সাত ক়ুরবানগাহেং বনাকর হর এক পর এক বৈল ঔর এক মেংঢা ক়ুরবান কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","বিলাম নে বলক় সে কহা, “যহাঁ অপনী ক়ুরবানগাহ কে পাস খড়ে রহেং। মৈং কুছ ফ়াসলে পর জাকর রব সে মিলূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","রব বিলাম সে মিলা। উসনে উসে বলক় কে লিএ পৈগ়াম দিযা ঔর কহা, “বলক় কে পাস ৱাপস জা ঔর উসে যহ পৈগ়াম সুনা দে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ৱহ ৱাপস চলা গযা। বলক় অব তক অপনে সরদারোং কে সাথ অপনী ক়ুরবানী কে পাস খড়া থা। উসনে উসসে পূছা, “রব নে ক্যা কহা?” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","বিলাম নে কহা, “ঐ বলক়, উঠো ঔর সুনো। ঐ সফ়োর কে বেটে, মেরী বাত পর গ়ৌর করো। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","অল্লাহ আদমী নহীং জো ঝূট বোলতা হৈ। ৱহ ইনসান নহীং জো কোঈ ফ়ৈসলা করকে বাদ মেং পছতাএ। ক্যা ৱহ কভী অপনী বাত পর অমল নহীং করতা? ক্যা ৱহ কভী অপনী বাত পূরী নহীং করতা? ");
INSERT INTO urdgvb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","মুঝে বরকত দেনে কো কহা গযা হৈ। উসনে বরকত দী হৈ ঔর মৈং যহ বরকত রোক নহীং সকতা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","যাক়ূব কে ঘরানে মেং খ়রাবী নজ়র নহীং আতী, ইসরাঈল মেং দুখ দিখাঈ নহীং দেতা। রব উসকা খ়ুদা উসকে সাথ হৈ, ঔর ক়ৌম বাদশাহ কী খ়ুশী মেং নারে লগাতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","অল্লাহ উন্হেং মিসর সে নিকাল লাযা, ঔর উন্হেং জংগলী বৈল কী তাক়ত হাসিল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","যাক়ূব কে ঘরানে কে খ়িলাফ় জাদূগরী নাকাম হৈ, ইসরাঈল কে খ়িলাফ় গ়ৈবদানী বেফ়াযদা হৈ। অব যাক়ূব কে ঘরানে সে কহা জাএগা, ‘অল্লাহ নে কৈসা কাম কিযা হৈ!’ ");
INSERT INTO urdgvb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ইসরাঈলী ক়ৌম শেরনী কী তরহ উঠতী ঔর শেরববর কী তরহ খড়ী হো জাতী হৈ। জব তক ৱহ অপনা শিকার ন খা লে ৱহ আরাম নহীং করতা, জব তক ৱহ মারে হুএ লোগোং কা খ়ূন ন পী লে ৱহ নহীং লেটতা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","যহ সুনকর বলক় নে কহা, “অগর আপ উন পর লানত ভেজনে সে ইনকার করেং, কম অজ় কম উন্হেং বরকত তো ন দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","বিলাম নে জৱাব দিযা, “ক্যা মৈংনে আপকো নহীং বতাযা থা কি জো কুছ ভী রব কহেগা মৈং ৱহী করূঁগা?” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","তব বলক় নে বিলাম সে কহা, “আএঁ, মৈং আপকো এক ঔর জগহ লে জাঊঁ। শাযদ অল্লাহ রাজ়ী হো জাএ কি আপ মেরে লিএ ৱহাঁ সে উন পর লানত ভেজেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ৱহ উসকে সাথ ফ়গ়ূর পহাড় পর চঢ় গযা। উস কী চোটী সে যরদন কী ৱাদী কা জুনূবী হিস্সা যশীমোন দিখাঈ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","বিলাম নে উসসে কহা, “মেরে লিএ যহাঁ সাত ক়ুরবানগাহেং বনাকর সাত বৈল ঔর সাত মেংঢে তৈযার কর রখেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","বলক় নে ঐসা হী কিযা। উসনে হর এক ক়ুরবানগাহ পর এক বৈল ঔর এক মেংঢা ক়ুরবান কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","অব বিলাম কো উস বাত কা পূরা যক়ীন হো গযা কি রব কো পসংদ হৈ কি মৈং ইসরাঈলিযোং কো বরকত দূঁ। ইসলিএ উসনে ইস মরতবা পহলে কী তরহ জাদূগরী কা তরীক়া ইস্তেমাল ন কিযা বল্কি সীধা রেগিস্তান কী তরফ় রুখ় কিযা ");
INSERT INTO urdgvb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","জহাঁ ইসরাঈল অপনে অপনে ক়বীলোং কী তরতীব সে খ়ৈমাজ়ন থা। যহ দেখকর অল্লাহ কা রূহ উস পর নাজ়িল হুআ, ");
INSERT INTO urdgvb_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ঔর ৱহ বোল উঠা, “বিলাম বিন বওর কা পৈগ়াম সুনো, উসকে পৈগ়াম পর গ়ৌর করো জো সাফ় সাফ় দেখতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","উসকা পৈগ়াম জো অল্লাহ কী বাতেং সুন লেতা হৈ, ক়াদিরে-মুতলক় কী রোযা কো দেখ লেতা হৈ ঔর জ়মীন পর গিরকর পোশীদা বাতেং দেখতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ঐ যাক়ূব, তেরে খ়ৈমে কিতনে শানদার হৈং! ঐ ইসরাঈল, তেরে ঘর কিতনে অচ্ছে হৈং! ");
INSERT INTO urdgvb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ৱহ দূর তক ফৈলী হুঈ ৱাদিযোং কী মানিংদ, নহর কে কিনারে লগে বাগ়োং কী মানিংদ, রব কে লগাএ হুএ ঊদ কে দরখ়্তোং কী মানিংদ, পানী কে কিনারে লগে দেৱদার কে দরখ়্তোং কী মানিংদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","উনকী বালটিযোং সে পানী ছলকতা রহেগা, উনকে বীজ কো কসরত কা পানী মিলেগা। উনকা বাদশাহ অজাজ সে জ়্যাদা তাক়তৱর হোগা, ঔর উনকী সলতনত সরফ়রাজ় হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","অল্লাহ উন্হেং মিসর সে নিকাল লাযা, ঔর উন্হেং জংগলী বৈল কী-সী তাক়ত হাসিল হৈ। ৱহ মুখ়ালিফ় ক়ৌমোং কো হড়প করকে উনকী হড্ডিযাঁ চূর চূর কর দেতে হৈং, ৱহ অপনে তীর চলাকর উন্হেং মার ডালতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ইসরাঈল শেরববর যা শেরনী কী মানিংদ হৈ। জব ৱহ দবককর বৈঠ জাএ তো কোঈ ভী উসে ছেড়নে কী জুর্রত নহীং করতা। জো তুঝে বরকত দে উসে বরকত মিলে, ঔর জো তুঝ পর লানত ভেজে উস পর লানত আএ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","যহ সুনকর বলক় আপে সে বাহর হুআ। উসনে তালী বজাকর অপনী হিক়ারত কা ইজ়হার কিযা ঔর কহা, “মৈংনে তুঝে ইসলিএ বুলাযা থা কি তূ মেরে দুশ্মনোং পর লানত ভেজে। অব তূনে উন্হেং তীনোং বার বরকত হী দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","অব দফ়া হো জা! অপনে ঘর ৱাপস ভাগ জা! মৈংনে কহা থা কি বড়া ইনাম দূঁগা। লেকিন রব নে তুঝে ইনাম পানে সে রোক দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","বিলাম নে জৱাব দিযা, “ক্যা মৈংনে উন লোগোং কো জিন্হেং আপনে মুঝে বুলানে কে লিএ ভেজা থা নহীং বতাযা থা ");
INSERT INTO urdgvb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","কি অগর বলক় অপনে মহল কো চাঁদী ঔর সোনে সে ভরকর ভী মুঝে দে দে তো ভী মৈং রব কী কিসী বাত কী খ়িলাফ়ৱরজ়ী নহীং কর সকতা, খ়াহ মেরী নীযত অচ্ছী হো যা বুরী। মৈং সির্ফ় ৱহ কুছ কর সকতা হূঁ জো অল্লাহ ফ়রমাতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","অব মৈং অপনে ৱতন ৱাপস চলা জাতা হূঁ। লেকিন পহলে মৈং আপকো বতা দেতা হূঁ কি আখ়িরকার যহ ক়ৌম আপকী ক়ৌম কে সাথ ক্যা কুছ করেগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ৱহ বোল উঠা, “বিলাম বিন বওর কা পৈগ়াম সুনো, উসকা পৈগ়াম জো সাফ় সাফ় দেখতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","উসকা পৈগ়াম জো অল্লাহ কী বাতেং সুন লেতা ঔর অল্লাহ তআলা কী মরজ়ী কো জানতা হৈ, জো ক়াদিরে-মুতলক় কী রোযা কো দেখ লেতা ঔর জ়মীন পর গিরকর পোশীদা বাতেং দেখতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","জিসে মৈং দেখ রহা হূঁ ৱহ ইস ৱক়্ত নহীং হৈ। জো মুঝে নজ়র আ রহা হৈ ৱহ ক়রীব নহীং হৈ। যাক়ূব কে ঘরানে সে সিতারা নিকলেগা, ঔর ইসরাঈল সে অসাএ-শাহী উঠেগা জো মোআব কে মাথোং ঔর সেত কে তমাম বেটোং কী খোপড়িযোং কো পাশ পাশ করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","অদোম উসকে ক়ব্জ়ে মেং আএগা, উসকা দুশ্মন সঈর উস কী মিলকিযত বনেগা জবকি ইসরাঈল কী তাক়ত বঢ়তী জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","যাক়ূব কে ঘরানে সে এক হুক্মরান নিকলেগা জো শহর কে বচে হুওং কো হলাক কর দেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ফির বিলাম নে অমালীক় কো দেখা ঔর কহা, “অমালীক় ক়ৌমোং মেং অৱ্ৱল থা, লেকিন আখ়িরকার ৱহ খ়ত্ম হো জাএগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ফির উসনে ক়ীনিযোং কো দেখা ঔর কহা, “তেরী সুকূনতগাহ মুস্তহকম হৈ, তেরা চট্টান মেং বনা ঘোংসলা মজ়বূত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","লেকিন তূ তবাহ হো জাএগা জব অসূর তুঝে গিরিফ়্তার করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","এক ঔর দফ়া উসনে বাত কী, “হায, কৌন জ়িংদা রহ সকতা হৈ জব অল্লাহ যোং করেগা? ");
INSERT INTO urdgvb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","কিত্তীম কে সাহিল সে বহরী জহাজ় আএঁগে জো অসূর ঔর ইবর কো জ়লীল করেংগে, লেকিন ৱহ খ়ুদ ভী হলাক হো জাএংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ফির বিলাম উঠকর অপনে ঘর ৱাপস চলা গযা। বলক় ভী ৱহাঁ সে চলা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","জব ইসরাঈলী শিত্তীম মেং রহ রহে থে তো ইসরাঈলী মর্দ মোআবী ঔরতোং সে জ়িনাকারী করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","যহ ঐসা হুআ কি মোআবী ঔরতেং অপনে দেৱতাওং কো ক়ুরবানিযাঁ পেশ করতে ৱক়্ত ইসরাঈলিযোং কো শরীক হোনে কী দাৱত দেনে লগীং। ইসরাঈলী দাৱত ক়বূল করকে ক়ুরবানিযোং সে খানে ঔর দেৱতাওং কো সিজদা করনে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ইস তরীক়ে সে ইসরাঈলী মোআবী দেৱতা বনাম বাল-ফ়গ়ূর কী পূজা করনে লগে, ঔর রব কা গ়জ়ব উন পর আন পড়া। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","উসনে মূসা সে কহা, “ইস ক়ৌম কে তমাম রাহনুমাওং কো সজ়াএ-মৌত দেকর সূরজ কী রৌশনী মেং রব কে সামনে লটকা, ৱরনা রব কা ইসরাঈলিযোং পর সে গ়জ়ব নহীং টলেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","চুনাঁচে মূসা নে ইসরাঈল কে ক়াজ়িযোং সে কহা, “লাজ়িম হৈ কি তুমমেং সে হর এক অপনে উন আদমিযোং কো জান সে মার দে জো বাল-ফ়গ়ূর দেৱতা কী পূজা মেং শরীক হুএ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","মূসা ঔর ইসরাঈল কী পূরী জমাত মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর জমা হোকর রোনে লগে। ইত্তফ়াক় সে উসী ৱক়্ত এক আদমী ৱহাঁ সে গুজ়রা জো এক মিদিযানী ঔরত কো অপনে ঘর লে জা রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","যহ দেখকর হারূন কা পোতা ফ়ীনহাস বিন ইলিযজ়র জমাত সে নিকলা ঔর নেজ়া পকড়কর ");
INSERT INTO urdgvb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","উস ইসরাঈলী কে পীছে চল পড়া। ৱহ ঔরত সমেত অপনে খ়ৈমে মেং দাখ়িল হুআ তো ফ়ীনহাস নে উনকে পীছে পীছে জাকর নেজ়া ইতনে জ়োর সে মারা কি ৱহ দোনোং মেং সে গুজ়র গযা। উস ৱক়্ত ৱবা ফৈলনে লগী থী, লেকিন ফ়ীনহাস কে ইস অমল সে ৱহ রুক গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","তো ভী 24,000 অফ়রাদ মর চুকে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“হারূন কে পোতে ফ়ীনহাস বিন ইলিযজ়র নে ইসরাঈলিযোং পর মেরা গ়ুস্সা ঠংডা কর দিযা হৈ। মেরী গ়ৈরত অপনাকর ৱহ ইসরাঈল মেং দীগর মাবূদোং কী পূজা কো বরদাশ্ত ন কর সকা। ইসলিএ মেরী গ়ৈরত নে ইসরাঈলিযোং কো নেস্তো-নাবূদ নহীং কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","লিহাজ়া উসে বতা দেনা কি মৈং উসকে সাথ সলামতী কা অহদ ক়াযম করতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ইস অহদ কে তহত উসে ঔর উস কী ঔলাদ কো অবদ তক ইমাম কা ওহদা হাসিল রহেগা, ক্যোংকি অপনে খ়ুদা কী খ়াতির গ়ৈরত খাকর উসনে ইসরাঈলিযোং কা কফ়্ফ়ারা দিযা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","জিস আদমী কো মিদিযানী ঔরত কে সাথ মার দিযা গযা উসকা নাম জ়িমরী বিন সলূ থা, ঔর ৱহ শমৌন কে ক়বীলে কে এক আবাঈ ঘরানে কা সরপরস্ত থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","মিদিযানী ঔরত কা নাম কজ়বী থা, ঔর ৱহ সূর কী বেটী থী জো মিদিযানিযোং কে এক আবাঈ ঘরানে কা সরপরস্ত থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“মিদিযানিযোং কো দুশ্মন ক়রার দেকর উন্হেং মার ডালনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ক্যোংকি উন্হোংনে অপনী চালাকিযোং সে তুম্হারে সাথ দুশ্মন কা-সা সুলূক কিযা, উন্হোংনে তুম্হেং বাল-ফ়গ়ূর কী পূজা করনে পর উকসাযা ঔর তুম্হেং অপনী বহন মিদিযানী সরদার কী বেটী কজ়বী কে জ়রীএ জিসে ৱবা ফৈলতে ৱক়্ত মার দিযা গযা বহকাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ৱবা কে বাদ রব নে মূসা ঔর হারূন কে বেটে ইলিযজ়র সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“পূরী ইসরাঈলী জমাত কী মর্দুমশুমারী উনকে আবাঈ ঘরানোং কে মুতাবিক় করনা। উন তমাম মর্দোং কো গিননা জো 20 সাল যা ইসসে জ়াযদ কে হৈং ঔর জো জংগ লড়নে কে ক়াবিল হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU26_3‏","005_26_3‏","NUM","26","3‏","4","মূসা ঔর ইলিযজ়র নে ইসরাঈলিযোং কো বতাযা কি রব নে উন্হেং ক্যা হুক্ম দিযা হৈ। চুনাঁচে উন্হোংনে মোআব কে মৈদানী ইলাক়ে মেং যরীহূ কে সামনে, লেকিন দরিযাএ-যরদন কে মশরিক়ী কিনারে পর মর্দুমশুমারী কী। যহ ৱহ ইসরাঈলী আদমী থে জো মিসর সে নিকলে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_5‏","005_26_5‏","NUM","26","5‏","7","ইসরাঈল কে পহলৌঠে রূবিন কে ক়বীলে কে 43,730 মর্দ থে। ক়বীলে কে চার কুংবে হনূকী, ফ়ল্লুৱী, হসরোনী ঔর করমী রূবিন কে বেটোং হনূক, ফ়ল্লূ, হসরোন ঔর করমী সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","রূবিন কা বেটা ফ়ল্লূ ইলিযাব কা বাপ থা ");
INSERT INTO urdgvb_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","জিসকে বেটে নমুএল, দাতন ঔর অবীরাম থে। দাতন ঔর অবীরাম ৱহী লোগ থে জিন্হেং জমাত নে চুনা থা ঔর জিন্হোংনে ক়োরহ কে গুরোহ সমেত মূসা ঔর হারূন সে ঝগড়তে হুএ খ়ুদ রব সে ঝগড়া কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","উস ৱক়্ত জ়মীন নে অপনা মুঁহ খোলকর উন্হেং ক়োরহ সমেত হড়প কর লিযা থা। উসকে 250 সাথী ভী মর গএ থে জব আগ নে উন্হেং ভস্ম কর দিযা। যোং ৱহ সব ইসরাঈল কে লিএ ইবরতঅংগেজ় মিসাল বন গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","লেকিন ক়োরহ কী পূরী নসল মিটাঈ নহীং গঈ থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_12‏","005_26_12‏","NUM","26","12‏","14","শমৌন কে ক়বীলে কে 22,200 মর্দ থে। ক়বীলে কে পাঁচ কুংবে নমুএলী, যমীনী, যকীনী, জ়ারহী ঔর সাঊলী শমৌন কে বেটোং নমুএল, যমীন, যকীন, জ়ারহ ঔর সাঊল সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_15‏","005_26_15‏","NUM","26","15‏","18","জদ কে ক়বীলে কে 40,500 মর্দ থে। ক়বীলে কে সাত কুংবে সফ়োনী, হজ্জী, সূনী, উজ়নী, এরী, অরূদী ঔর অরেলী জদ কে বেটোং সফ়োন, হজ্জী, সূনী, উজ়নী, এরী, অরূদ ঔর অরেলী সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_19‏","005_26_19‏","NUM","26","19‏","22","যহূদাহ কে ক়বীলে কে 76,500 মর্দ থে। যহূদাহ কে দো বেটে এর ঔর ওনান মিসর আনে সে পহলে কনান মেং মর গএ থে। ক়বীলে কে তীন কুংবে সেলানী, ফ়ারসী ঔর জ়ারহী যহূদাহ কে বেটোং সেলা, ফ়ারস ঔর জ়ারহ সে নিকলে হুএ থে। ফ়ারস কে দো বেটোং হসরোন ঔর হমূল সে দো কুংবে হসরোনী ঔর হমূলী নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_23‏","005_26_23‏","NUM","26","23‏","25","ইশকার কে ক়বীলে কে 64,300 মর্দ থে। ক়বীলে কে চার কুংবে তোলঈ, ফ়ুৱ্ৱী, যসূবী ঔর সিমরোনী ইশকার কে বেটোং তোলা, ফ়ুৱ্ৱা, যসূব ঔর সিমরোন সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_26‏","005_26_26‏","NUM","26","26‏","27","জ়বূলূন কে ক়বীলে কে 60,500 মর্দ থে। ক়বীলে কে তীন কুংবে সরদী, ঐলোনী ঔর যহলিযেলী জ়বূলূন কে বেটোং সরদ, ঐলোন ঔর যহলিযেল সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","যূসুফ় কে দো বেটোং মনস্সী ঔর ইফ়রাঈম কে অলগ অলগ ক়বীলে বনে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_29‏","005_26_29‏","NUM","26","29‏","34","মনস্সী কে ক়বীলে কে 52,700 মর্দ থে। ক়বীলে কে আঠ কুংবে মকীরী, জিলিযাদী, ইযজ়রী, খ়লক়ী, অসরিযেলী, সিকমী, সমীদাঈ ঔর হিফ়রী থে। মকীরী মনস্সী কে বেটে মকীর সে জবকি জিলিযাদী মকীর কে বেটে জিলিযাদ সে নিকলে হুএ থে। বাক়ী কুংবে জিলিযাদ কে ছঃ বেটোং ইযজ়র, খ়লক়, অসরিযেল, সিকম, সমীদা ঔর হিফ়র সে নিকলে হুএ থে। হিফ়র সিলাফ়িহাদ কা বাপ থা। সিলাফ়িহাদ কা কোঈ বেটা নহীং বল্কি পাঁচ বেটিযাঁ মহলাহ, নুআহ, হুজলাহ, মিলকাহ ঔর তিরজ়া থীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_35‏","005_26_35‏","NUM","26","35‏","37","ইফ়রাঈম কে ক়বীলে কে 32,500 মর্দ থে। ক়বীলে কে চার কুংবে সূতলহী, বকরী, তহনী ঔর ঈরানী থে। পহলে তীন কুংবে ইফ়রাঈম কে বেটোং সূতলহ, বকর ঔর তহন সে জবকি ঈরানী সূতলহ কে বেটে ঈরান সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_38‏","005_26_38‏","NUM","26","38‏","41","বিনযমীন কে ক়বীলে কে 45,600 মর্দ থে। ক়বীলে কে সাত কুংবে বালাঈ, অশবেলী, অখ়ীরামী, সূফ়ামী, হূফ়ামী, অরদী ঔর নামানী থে। পহলে পাঁচ কুংবে বিনযমীন কে বেটোং বালা, অশবেল, অখ়ীরাম, সূফ়াম ঔর হূফ়াম সে জবকি অরদী ঔর নামানী বালা কে বেটোং সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_42‏","005_26_42‏","NUM","26","42‏","43","দান কে ক়বীলে কে 64,400 মর্দ থে। সব দান কে বেটে সূহাম সে নিকলে হুএ থে, ইসলিএ সূহামী কহলাতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_44‏","005_26_44‏","NUM","26","44‏","47","আশর কে ক়বীলে কে 53,400 মর্দ থে। ক়বীলে কে পাঁচ কুংবে যিমনী, ইসৱী, বরীঈ, হিবরী ঔর মলকিযেলী থে। পহলে তীন কুংবে আশর কে বেটোং যিমনা, ইসৱী ঔর বরিযা সে জবকি বাক়ী বরিযা কে বেটোং হিবর ঔর মলকিযেল সে নিকলে হুএ থে। আশর কী এক বেটী বনাম সিরহ ভী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_48‏","005_26_48‏","NUM","26","48‏","50","নফ়তালী কে ক়বীলে কে 45,400 মর্দ থে। ক়বীলে কে চার কুংবে যহসিযেলী, জূনী, যিসরী ঔর সিল্লীমী নফ়তালী কে বেটোং যহসিযেল, জূনী, যিসর ঔর সিল্লীম সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ইসরাঈলী মর্দোং কী কুল তাদাদ 6,01,730 থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“জব মুল্কে-কনান কো তক়সীম কিযা জাএগা তো জ়মীন ইনকী তাদাদ কে মুতাবিক় দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","বড়ে ক়বীলোং কো ছোটে কী নিসবত জ়্যাদা জ়মীন দী জাএ। হর ক়বীলে কা ইলাক়া উস কী তাদাদ সে মুতাবিক়ত রখে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_55‏","005_26_55‏","NUM","26","55‏","56","ক়ুরা ডালনে সে ফ়ৈসলা কিযা জাএ কি হর ক়বীলে কো কহাঁ জ়মীন মিলেগী। লেকিন হর ক়বীলে কে ইলাক়ে কা রক়বা ইস পর মবনী হো কি ক়বীলে কে কিতনে অফ়রাদ হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","লাৱী কে ক়বীলে কে তীন কুংবে জৈরসোনী, ক়িহাতী ঔর মিরারী লাৱী কে বেটোং জৈরসোন, ক়িহাত ঔর মিরারী সে নিকলে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ইসকে অলাৱা লিবনী, হিব্রূনী, মহলী, মূশী ঔর কোরহী ভী লাৱী কে কুংবে থে। ক়িহাত অমরাম কা বাপ থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","অমরাম নে লাৱী ঔরত যূকবিদ সে শাদী কী জো মিসর মেং পৈদা হুঈ থী। উনকে দো বেটে হারূন ঔর মূসা ঔর এক বেটী মরিযম পৈদা হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","হারূন কে বেটে নদব, অবীহূ, ইলিযজ়র ঔর ইতমর থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","লেকিন নদব ঔর অবীহূ রব কো বখ়ূর কী নাজাযজ় ক়ুরবানী পেশ করনে কে বাইস মর গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","লাৱিযোং কে মর্দোং কী কুল তাদাদ 23,000 থী। ইনমেং ৱহ সব শামিল থে জো এক মাহ যা ইসসে জ়াযদ কে থে। উন্হেং দূসরে ইসরাঈলিযোং সে অলগ গিনা গযা, ক্যোংকি উন্হেং ইসরাঈল মেং মীরাস মেং জ়মীন নহীং মিলনী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","যোং মূসা ঔর ইলিযজ়র নে মোআব কে মৈদানী ইলাক়ে মেং যরীহূ কে সামনে লেকিন দরিযাএ-যরদন কে মশরিক়ী কিনারে পর ইসরাঈলিযোং কী মর্দুমশুমারী কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","লোগোং কো গিনতে গিনতে উন্হেং মালূম হুআ কি জো লোগ দশ্তে-সীন মেং মূসা ঔর হারূন কী পহলী মর্দুমশুমারী মেং গিনে গএ থে ৱহ সব মর চুকে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","রব নে কহা থা কি ৱহ সবকে সব রেগিস্তান মেং মর জাএংগে, ঔর ঐসা হী হুআ থা। সির্ফ় কালিব বিন যফ়ুন্না ঔর যশুঅ বিন নূন জ়িংদা রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","সিলাফ়িহাদ কী পাঁচ বেটিযাঁ মহলাহ, নুআহ, হুজলাহ, মিলকাহ ঔর তিরজ়া থীং। সিলাফ়িহাদ যূসুফ় কে বেটে মনস্সী কে কুংবে কা থা। উসকা পূরা নাম সিলাফ়িহাদ বিন হিফ়র বিন জিলিযাদ বিন মকীর বিন মনস্সী বিন যূসুফ় থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","সিলাফ়িহাদ কী বেটিযাঁ মুলাক়াত কে খ়ৈমে কে দরৱাজ়ে পর আকর মূসা, ইলিযজ়র ইমাম ঔর পূরী জমাত কে সামনে খড়ী হুঈং। উন্হোংনে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“হমারা বাপ রেগিস্তান মেং ফ়ৌত হুআ। লেকিন ৱহ ক়োরহ কে উন সাথিযোং মেং সে নহীং থা জো রব কে খ়িলাফ় মুত্তহিদ হুএ থে। ৱহ ইস সবব সে ন মরা বল্কি অপনে জ়াতী গুনাহ কে বাইস। জব ৱহ মর গযা তো উসকা কোঈ বেটা নহীং থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ক্যা যহ ঠীক হৈ কি হমারে খ়ানদান মেং বেটা ন হোনে কে বাইস হমেং জ়মীন ন মিলে ঔর হমারে বাপ কা নামো-নিশান মিট জাএ? হমেং ভী হমারে বাপ কে দীগর রিশ্তেদারোং কে সাথ জ়মীন দেং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","মূসা নে উনকা মামলা রব কে সামনে পেশ কিযা ");
INSERT INTO urdgvb_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","তো রব নে উসসে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“জো বাত সিলাফ়িহাদ কী বেটিযাঁ কর রহী হৈং ৱহ দুরুস্ত হৈ। উন্হেং জ়রূর উনকে বাপ কে রিশ্তেদারোং কে সাথ জ়মীন মিলনী চাহিএ। উন্হেং বাপ কা ৱিরসা মিল জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ইসরাঈলিযোং কো ভী বতানা কি জব ভী কোঈ আদমী মর জাএ জিসকা বেটা ন হো তো উস কী বেটী কো উস কী মীরাস মিল জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","অগর উস কী বেটী ভী ন হো তো উসকে ভাইযোং কো উস কী মীরাস মিল জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","অগর উসকে ভাঈ ভী ন হোং তো উসকে বাপ কে ভাইযোং কো উস কী মীরাস মিল জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","অগর যহ ভী ন হোং তো উসকে সবসে ক়রীবী রিশ্তেদার কো উস কী মীরাস মিল জাএ। ৱহ উস কী জ়াতী মিলকিযত হোগী। যহ উসূল ইসরাঈলিযোং কে লিএ ক়ানূনী হৈসিযত রখতা হৈ। ৱহ ইসে ৱৈসা মানেং জৈসা রব নে মূসা কো হুক্ম দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ফির রব নে মূসা সে কহা, “অবারীম কে পহাড়ী সিলসিলে কে ইস পহাড় পর চঢ়কর উস মুল্ক পর নিগাহ ডাল জো মৈং ইসরাঈলিযোং কো দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","উসে দেখনে কে বাদ তূ ভী অপনে ভাঈ হারূন কী তরহ কূচ করকে অপনে বাপদাদা সে জা মিলেগা, ");
INSERT INTO urdgvb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ক্যোংকি তুম দোনোং নে দশ্তে-সীন মেং মেরে হুক্ম কী খ়িলাফ়ৱরজ়ী কী। উস ৱক়্ত জব পূরী জমাত নে মরীবা মেং মেরে খ়িলাফ় গিলা-শিকৱা কিযা তো তূনে চট্টান সে পানী নিকালতে ৱক়্ত লোগোং কে সামনে মেরী ক়ুদ্দূসিযত ক়াযম ন রখী।” (মরীবা দশ্তে-সীন কে ক়াদিস মেং চশ্মা হৈ।) ");
INSERT INTO urdgvb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","মূসা নে রব সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ঐ রব, তমাম জানোং কে খ়ুদা, জমাত পর কিসী আদমী কো মুক়র্রর কর ");
INSERT INTO urdgvb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","জো উনকে আগে আগে জংগ কে লিএ নিকলে ঔর উনকে আগে আগে ৱাপস আ জাএ, জো উন্হেং বাহর লে জাএ ঔর ৱাপস লে আএ। ৱরনা রব কী জমাত উন ভেড়োং কী মানিংদ হোগী জিনকা কোঈ চরৱাহা ন হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","জৱাব মেং রব নে মূসা সে কহা, “যশুঅ বিন নূন কো চুন লে জিসমেং মেরা রূহ হৈ, ঔর অপনা হাথ উস পর রখ। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","উসে ইলিযজ়র ইমাম ঔর পূরী জমাত কে সামনে খড়া করকে উনকে রূবরূ হী উসে রাহনুমাঈ কী জ়িম্মাদারী দে। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","অপনে ইখ়্তিযার মেং সে কুছ উসে দে তাকি ইসরাঈল কী পূরী জমাত উস কী ইতাঅত করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","রব কী মরজ়ী জাননে কে লিএ ৱহ ইলিযজ়র ইমাম কে সামনে খড়া হোগা তো ইলিযজ়র রব কে সামনে ঊরীম ঔর তুম্মীম ইস্তেমাল করকে উস কী মরজ়ী দরিযাফ়্ত করেগা। উসী কে হুক্ম পর যশুঅ ঔর ইসরাঈল কী পূরী জমাত খ়ৈমাগাহ সে নিকলেংগে ঔর ৱাপস আএঁগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","মূসা নে ঐসা হী কিযা। উসনে যশুঅ কো চুনকর ইলিযজ়র ঔর পূরী জমাত কে সামনে খড়া কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ফির উসনে উস পর অপনে হাথ রখকর উসে রাহনুমাঈ কী জ়িম্মাদারী সৌংপী জিস তরহ রব নে উসে বতাযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ইসরাঈলিযোং কো বতানা, খ়যাল রখো কি তুম মুক়র্ররা ঔক়াত পর মুঝে জলনেৱালী ক়ুরবানিযাঁ পেশ করো। যহ মেরী রোটী হৈং ঔর ইনকী খ়ুশবূ মুঝে পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","রব কো জলনেৱালী যহ ক়ুরবানী পেশ করনা : রোজ়ানা ভেড় কে দো যকসালা বচ্চে জো বেঐব হোং পূরে তৌর পর জলা দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","এক কো সুবহ কে ৱক়্ত পেশ করনা ঔর দূসরে কো সূরজ কে ডূবনে কে ঐন বাদ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ভেড় কে বচ্চে কে সাথ গ়ল্লা কী নজ়র ভী পেশ কী জাএ যানী ডেঢ় কিলোগ্রাম বেহতরীন মৈদা জো এক লিটর জ়ৈতূন কে কূটকর নিকালে হুএ তেল কে সাথ মিলাযা গযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","যহ রোজ়মর্রা কী ক়ুরবানী হৈ জো পূরে তৌর পর জলাঈ জাতী হৈ ঔর পহলী দফ়া সীনা পহাড় পর চঢ়াঈ গঈ। ইস জলনেৱালী ক়ুরবানী কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_7‏","005_28_7‏","NUM","28","7‏","8","সাথ হী এক লিটর শরাব ভী নজ়র কে তৌর পর ক়ুরবানগাহ পর ডালী জাএ। সুবহ ঔর শাম কী যহ ক়ুরবানিযাঁ দোনোং হী ইস তরীক়ে সে পেশ কী জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","সবত কে দিন ভেড় কে দো ঔর বচ্চে চঢ়ানা। ৱহ ভী বেঐব ঔর এক সাল কে হোং। সাথ হী মৈ ঔর গ়ল্লা কী নজ়রেং ভী পেশ কী জাএঁ। গ়ল্লা কী নজ়র কে লিএ 3 কিলোগ্রাম বেহতরীন মৈদা তেল কে সাথ মিলাযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ভস্ম হোনেৱালী যহ ক়ুরবানী হর হফ়তে কে দিন পেশ করনী হৈ। যহ রোজ়মর্রা কী ক়ুরবানিযোং কে অলাৱা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","হর মাহ কে শুরূ মেং রব কো ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর দো জৱান বৈল, এক মেংঢা ঔর ভেড় কে সাত যকসালা বচ্চে পেশ করনা। সব বগ়ৈর নুক়্স কে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","হর জানৱর কে সাথ গ়ল্লা কী নজ়র পেশ করনা জিসকে লিএ তেল মেং মিলাযা গযা বেহতরীন মৈদা ইস্তেমাল কিযা জাএ। হর বৈল কে সাথ সাঢ়ে 4 কিলোগ্রাম, হর মেংঢে কে সাথ 3 কিলোগ্রাম ");
INSERT INTO urdgvb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ঔর ভেড় কে হর বচ্চে কে সাথ ডেঢ় কিলোগ্রাম মৈদা পেশ করনা। ভস্ম হোনেৱালী যহ ক়ুরবানিযাঁ রব কো পসংদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ইন ক়ুরবানিযোং কে সাথ মৈ কী নজ়র ভী ক়ুরবানগাহ পর ডালনা যানী হর বৈল কে সাথ দো লিটর, হর মেংঢে কে সাথ সৱা লিটর ঔর ভেড় কে হর বচ্চে কে সাথ এক লিটর মৈ পেশ করনা। যহ ক়ুরবানী সাল মেং হর মহীনে কে পহলে দিন কে মৌক়ে পর পেশ করনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ইস ক়ুরবানী ঔর রোজ়মর্রা কী ক়ুরবানিযোং কে অলাৱা রব কো এক বকরা গুনাহ কী ক়ুরবানী কে তৌর পর পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","পহলে মহীনে কে চৌধৱেং দিন ফ়সহ কী ঈদ মনাঈ জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","অগলে দিন পূরে হফ়তে কী ৱহ ঈদ শুরূ হোতী হৈ জিসকে দৌরান তুম্হেং সির্ফ় বেখ়মীরী রোটী খানী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","পহলে দিন কাম ন করনা বল্কি মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","রব কে হুজ়ূর ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর দো জৱান বৈল, এক মেংঢা ঔর ভেড় কে সাত যকসালা বচ্চে পেশ করনা। সব বগ়ৈর নুক়্স কে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","হর জানৱর কে সাথ গ়ল্লা কী নজ়র ভী পেশ করনা জিসকে লিএ তেল কে সাথ মিলাযা গযা বেহতরীন মৈদা ইস্তেমাল কিযা জাএ। হর বৈল কে সাথ সাঢ়ে 4 কিলোগ্রাম, হর মেংঢে কে সাথ 3 কিলোগ্রাম ");
INSERT INTO urdgvb_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ঔর ভেড় কে হর বচ্চে কে সাথ ডেঢ় কিলোগ্রাম মৈদা পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","গুনাহ কী ক়ুরবানী কে তৌর পর এক বকরা ভী পেশ করনা তাকি তুম্হারা কফ়্ফ়ারা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_23‏","005_28_23‏","NUM","28","23‏","24","ইন তমাম ক়ুরবানিযোং কো ঈদ কে দৌরান হর রোজ় পেশ করনা। যহ রোজ়মর্রা কী ভস্ম হোনেৱালী ক়ুরবানিযোং কে অলাৱা হৈং। ইস খ়ুরাক কী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","সাতৱেং দিন কাম ন করনা বল্কি মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ফ়সল কী কটাঈ কে পহলে দিন কী ঈদ পর জব তুম রব কো অপনী ফ়সল কী পহলী পৈদাৱার পেশ করতে হো তো কাম ন করনা বল্কি মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_27‏","005_28_27‏","NUM","28","27‏","29","উস দিন দো জৱান বৈল, এক মেংঢা ঔর ভেড় কে সাত যকসালা বচ্চে ক়ুরবানগাহ পর পূরে তৌর পর জলা দেনা। ইসকে সাথ গ়ল্লা ঔর মৈ কী ৱহী নজ়রেং পেশ করনা জো ফ়সহ কী ঈদ পর ভী পেশ কী জাতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ইসকে অলাৱা রব কো এক বকরা গুনাহ কী ক়ুরবানী কে তৌর পর চঢ়ানা। ");
INSERT INTO urdgvb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","যহ তমাম ক়ুরবানিযাঁ রোজ়মর্রা কী ভস্ম হোনেৱালী ক়ুরবানিযোং ঔর উনকে সাথৱালী গ়ল্লা ঔর মৈ কী নজ়রোং কে অলাৱা হৈং। ৱহ বেঐব হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","সাতৱেং মাহ কে পংদ্রহৱেং দিন ভী কাম ন করনা বল্কি মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। উস দিন নরসিংগে ফূঁকে জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","রব কো ভস্ম হোনেৱালী ক়ুরবানী পেশ কী জাএ জিসকী খ়ুশবূ উসে পসংদ হো যানী এক জৱান বৈল, এক মেংঢা ঔর ভেড় কে সাত যকসালা বচ্চে। সব নুক়্স কে বগ়ৈর হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","হর জানৱর কে সাথ গ়ল্লা কী নজ়র ভী পেশ করনা জিসকে লিএ তেল কে সাথ মিলাযা গযা বেহতরীন মৈদা ইস্তেমাল কিযা জাএ। বৈল কে সাথ সাঢ়ে 4 কিলোগ্রাম, মেংঢে কে সাথ 3 কিলোগ্রাম ");
INSERT INTO urdgvb_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ঔর ভেড় কে হর বচ্চে কে সাথ ডেঢ় কিলোগ্রাম মৈদা পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","এক বকরা ভী গুনাহ কী ক়ুরবানী কে তৌর পর পেশ করনা তাকি তুম্হারা কফ়্ফ়ারা দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","যহ ক়ুরবানিযাঁ রোজ়ানা ঔর হর মাহ কে পহলে দিন কী ক়ুরবানিযোং ঔর উনকে সাথ কী গ়ল্লা ঔর মৈ কী নজ়রোং কে অলাৱা হৈং। ইনকী খ়ুশবূ রব কো পসংদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","সাতৱেং মহীনে কে দসৱেং দিন মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। উস দিন কাম ন করনা ঔর অপনী জান কো দুখ দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_8‏","005_29_8‏","NUM","29","8‏","11","রব কো ৱহী ক়ুরবানিযাঁ পেশ করনা জো ইসী মহীনে কে পহলে দিন পেশ কী জাতী হৈং। সির্ফ় এক ফ়রক় হৈ, উস দিন এক নহীং বল্কি দো বকরে গুনাহ কী ক়ুরবানী কে তৌর পর পেশ কিএ জাএঁ তাকি তুম্হারা কফ়্ফ়ারা দিযা জাএ। ঐসী ক়ুরবানিযাঁ রব কো পসংদ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","সাতৱেং মহীনে কে পংদ্রহৱেং দিন ভী কাম ন করনা বল্কি মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। সাত দিন তক রব কী তাজ়ীম মেং ঈদ মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ঈদ কে পহলে দিন রব কো 13 জৱান বৈল, 2 মেংঢে ঔর 14 ভেড় কে যকসালা বচ্চে ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর পেশ করনা। ইনকী খ়ুশবূ উসে পসংদ হৈ। সব নুক়্স কে বগ়ৈর হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","হর জানৱর কে সাথ গ়ল্লা কী নজ়র ভী পেশ করনা জিসকে লিএ তেল সে মিলাযা গযা বেহতরীন মৈদা ইস্তেমাল কিযা জাএ। হর বৈল কে সাথ সাঢ়ে 4 কিলোগ্রাম, হর মেংঢে কে সাথ 3 কিলোগ্রাম ");
INSERT INTO urdgvb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ঔর ভেড় কে হর বচ্চে কে সাথ ডেঢ় কিলোগ্রাম মৈদা পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ইসকে অলাৱা এক বকরা ভী গুনাহ কী ক়ুরবানী কে তৌর পর পেশ করনা। যহ ক়ুরবানিযাঁ রোজ়ানা কী ভস্ম হোনেৱালী ক়ুরবানিযোং ঔর উনকে সাথৱালী গ়ল্লা ঔর মৈ কী নজ়রোং কে অলাৱা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_17‏","005_29_17‏","NUM","29","17‏","34","ঈদ কে বাক়ী ছঃ দিন যহী ক়ুরবানিযাঁ পেশ করনী হৈং। লেকিন হর দিন এক বৈল কম হো যানী দূসরে দিন 12, তীসরে দিন 11, চৌথে দিন 10, পাঁচৱেং দিন 9, ছটে দিন 8 ঔর সাতৱেং দিন 7 বৈল। হর দিন গুনাহ কী ক়ুরবানী কে লিএ বকরা ঔর মামূল কী রোজ়ানা কী ক়ুরবানিযাঁ ভী পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ঈদ কে আঠৱেং দিন কাম ন করনা বল্কি মুক়দ্দস ইজতিমা কে লিএ ইকট্ঠে হোনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","রব কো এক জৱান বৈল, এক মেংঢা ঔর ভেড় কে সাত যকসালা বচ্চে ভস্ম হোনেৱালী ক়ুরবানী কে তৌর পর পেশ করনা। ইনকী খ়ুশবূ রব কো পসংদ হৈ। সব নুক়্স কে বগ়ৈর হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_37‏","005_29_37‏","NUM","29","37‏","38","সাথ হী ৱহ তমাম ক়ুরবানিযাঁ ভী পেশ করনা জো পহলে দিন পেশ কী জাতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","যহ সব ৱহী ক়ুরবানিযাঁ হৈং জো তুম্হেং রব কো অপনী ঈদোং পর পেশ করনী হৈং। যহ উন তমাম ক়ুরবানিযোং কে অলাৱা হৈং জো তুম দিলী খ়ুশী সে যা মন্নত মানকর দেতে হো, চাহে ৱহ ভস্ম হোনেৱালী, গ়ল্লা কী, মৈ কী যা সলামতী কী ক়ুরবানিযাঁ ক্যোং ন হোং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","মূসা নে রব কী যহ তমাম হিদাযাত ইসরাঈলিযোং কো বতা দীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ফির মূসা নে ক়বীলোং কে সরদারোং সে কহা, “রব ফ়রমাতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","অগর কোঈ আদমী রব কো কুছ দেনে কী মন্নত মানে যা কিসী চীজ় সে পরহেজ় করনে কী ক়সম খাএ তো ৱহ অপনী বাত পর ক়াযম রহকর উসে পূরা করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","অগর কোঈ জৱান ঔরত জো অব তক অপনে বাপ কে ঘর মেং রহতী হৈ রব কো কুছ দেনে কী মন্নত মানে যা কিসী চীজ় সে পরহেজ় করনে কী ক়সম খাএ ");
INSERT INTO urdgvb_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","তো লাজ়িম হৈ কি ৱহ অপনী মন্নত যা ক়সম কী হর বাত পূরী করে। শর্ত যহ হৈ কি উসকা বাপ উসকে বারে মেং সুনকর এতরাজ় ন করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","লেকিন অগর উসকা বাপ যহ সুনকর উসে ঐসা করনে সে মনা করে তো উস কী মন্নত যা ক়সম মনসূখ় হৈ, ঔর ৱহ উসে পূরা করনে সে বরী হৈ। রব উসে মুআফ় করেগা, ক্যোংকি উসকে বাপ নে উসে মনা কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","হো সকতা হৈ কি কিসী গ়ৈরশাদীশুদা ঔরত নে মন্নত মানী যা কিসী চীজ় সে পরহেজ় করনে কী ক়সম খাঈ, চাহে উসনে দানিস্তা তৌর পর যা বেসোচে-সমঝে ঐসা কিযা। ইসকে বাদ উস ঔরত নে শাদী কর লী। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","শাদীশুদা হালত মেং ভী লাজ়িম হৈ কি ৱহ অপনী মন্নত যা ক়সম কী হর বাত পূরী করে। শর্ত যহ হৈ কি উসকা শৌহর ইসকে বারে মেং সুনকর এতরাজ় ন করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","লেকিন অগর উসকা শৌহর যহ সুনকর উসে ঐসা করনে সে মনা করে তো উস কী মন্নত যা ক়সম মনসূখ় হৈ, ঔর ৱহ উসে পূরা করনে সে বরী হৈ। রব উসে মুআফ় করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","অগর কিসী বেৱা যা তলাক়শুদা ঔরত নে মন্নত মানী যা কিসী চীজ় সে পরহেজ় করনে কী ক়সম খাঈ তো লাজ়িম হৈ কি ৱহ অপনী হর বাত পূরী করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","অগর কিসী শাদীশুদা ঔরত নে মন্নত মানী যা কিসী চীজ় সে পরহেজ় করনে কী ক়সম খাঈ ");
INSERT INTO urdgvb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","তো লাজ়িম হৈ কি ৱহ অপনী হর বাত পূরী করে। শর্ত যহ হৈ কি উসকা শৌহর উসকে বারে মেং সুনকর এতরাজ় ন করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","লেকিন অগর উসকা শৌহর উসে ঐসা করনে সে মনা করে তো উস কী মন্নত যা ক়সম মনসূখ় হৈ। ৱহ উসে পূরা করনে সে বরী হৈ। রব উসে মুআফ় করেগা, ক্যোংকি উসকে শৌহর নে উসে মনা কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","চাহে বীৱী নে কুছ দেনে কী মন্নত মানী হো যা কিসী চীজ় সে পরহেজ় করনে কী ক়সম খাঈ হো, উসকে শৌহর কো উস কী তসদীক় যা উসে মনসূখ় করনে কা ইখ়্তিযার হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","অগর উসনে অপনী বীৱী কী মন্নত যা ক়সম কে বারে মেং সুন লিযা ঔর অগলে দিন তক এতরাজ় ন কিযা তো লাজ়িম হৈ কি উস কী বীৱী অপনী হর বাত পূরী করে। শৌহর নে অগলে দিন তক এতরাজ় ন করনে সে অপনী বীৱী কী বাত কী তসদীক় কী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","অগর ৱহ ইসকে বাদ যহ মন্নত যা ক়সম মনসূখ় করে তো উসে ইস ক়ুসূর কে নতাযজ ভুগতনে পড়েংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","রব নে মূসা কো যহ হিদাযাত দীং। যহ ঐসী ঔরতোং কী মন্নতোং যা ক়সমোং কে উসূল হৈং জো গ়ৈরশাদীশুদা হালত মেং অপনে বাপ কে ঘর মেং রহতী হৈং যা জো শাদীশুদা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“মিদিযানিযোং সে ইসরাঈলিযোং কা বদলা লে। ইসকে বাদ তূ কূচ করকে অপনে বাপদাদা সে জা মিলেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","চুনাঁচে মূসা নে ইসরাঈলিযোং সে কহা, “হথিযারোং সে অপনে কুছ আদমিযোং কো লৈস করো তাকি ৱহ মিদিযান সে জংগ করকে রব কা বদলা লেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","হর ক়বীলে কে 1,000 মর্দ জংগ লড়নে কে লিএ ভেজো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","চুনাঁচে হর ক়বীলে কে 1,000 মুসল্লহ মর্দ যানী কুল 12,000 আদমী চুনে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","তব মূসা নে উন্হেং জংগ লড়নে কে লিএ ভেজ দিযা। উসনে ইলিযজ়র ইমাম কে বেটে ফ়ীনহাস কো ভী উনকে সাথ ভেজা জিসকে পাস মক়দিস কী কুছ চীজ়েং ঔর এলান করনে কে বিগুল থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","উন্হোংনে রব কে হুক্ম কে মুতাবিক় মিদিযানিযোং সে জংগ কী ঔর তমাম আদমিযোং কো মৌত কে ঘাট উতার দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ইনমেং মিদিযানিযোং কে পাঁচ বাদশাহ ইৱী, রক়ম, সূর, হূর ঔর রবা থে। বিলাম বিন বওর কো ভী জান সে মার দিযা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ইসরাঈলিযোং নে মিদিযানী ঔরতোং ঔর বচ্চোং কো গিরিফ়্তার করকে উনকে তমাম গায-বৈল, ভেড়-বকরিযাঁ ঔর মাল লূট লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","উন্হোংনে উনকী তমাম আবাদিযোং কো খ়ৈমাগাহোং সমেত জলাকর রাখ কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_11‏","005_31_11‏","NUM","31","11‏","12","ফির ৱহ তমাম লূটা হুআ মাল ক়ৈদিযোং ঔর জানৱরোং সমেত মূসা, ইলিযজ়র ইমাম ঔর ইসরাঈল কী পূরী জমাত কে পাস লে আএ জো খ়ৈমাগাহ মেং ইংতজ়ার কর রহে থে। অভী তক ৱহ মোআব কে মৈদানী ইলাক়ে মেং দরিযাএ-যরদন কে মশরিক়ী কিনারে পর যরীহূ কে সামনে ঠহরে হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","মূসা, ইলিযজ়র ঔর জমাত কে তমাম সরদার উনকা ইস্তক়বাল করনে কে লিএ খ়ৈমাগাহ সে নিকলে। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","উন্হেং দেখকর মূসা কো হজ়ার হজ়ার ঔর সৌ সৌ অফ়রাদ পর মুক়র্রর অফ়সরান পর গ়ুস্সা আযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","উসনে কহা, “আপনে তমাম ঔরতোং কো ক্যোং বচাএ রখা? ");
INSERT INTO urdgvb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","উন্হীং নে বিলাম কে মশৱরে পর ফ়গ়ূর মেং ইসরাঈলিযোং কো রব সে দূর কর দিযা থা। উন্হীং কে সবব সে রব কী ৱবা উসকে লোগোং মেং ফৈল গঈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","চুনাঁচে অব তমাম লড়কোং কো জান সে মার দো। উন তমাম ঔরতোং কো ভী মৌত কে ঘাট উতারনা জো কুঁৱারিযাঁ নহীং হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","লেকিন তমাম কুঁৱারিযোং কো বচাএ রখনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","জিসনে ভী কিসী কো মার দিযা যা কিসী লাশ কো ছুআ হৈ ৱহ সাত দিন তক খ়ৈমাগাহ কে বাহর রহে। তীসরে ঔর সাতৱেং দিন অপনে আপকো অপনে ক়ৈদিযোং সমেত গুনাহ সে পাক-সাফ় করনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","হর লিবাস ঔর হর চীজ় কো পাক-সাফ় করনা জো চমড়ে, বকরিযোং কে বালোং যা লকড়ী কী হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ফির ইলিযজ়র ইমাম নে জংগ সে ৱাপস আনেৱালে মর্দোং সে কহা, “জো শরীঅত রব নে মূসা কো দী উসকে মুতাবিক় ");
INSERT INTO urdgvb_vpl VALUES ("NU31_22‏","005_31_22‏","NUM","31","22‏","23","জো ভী চীজ় জল নহীং জাতী উসে আগ মেং সে গুজ়ার দেনা তাকি পাক-সাফ় হো জাএ। উসমেং সোনা, চাঁদী, পীতল, লোহা, টীন ঔর সীসা শামিল হৈ। ফির উস পর নাপাকী দূর করনে কা পানী ছিড়কনা। বাক়ী তমাম চীজ়েং পানী মেং সে গুজ়ার দেনা তাকি ৱহ পাক-সাফ় হো জাএঁ। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","সাতৱেং দিন অপনে লিবাস কো ধোনা তো তুম পাক-সাফ় হোকর খ়ৈমাগাহ মেং দাখ়িল হো সকতে হো।” ");
INSERT INTO urdgvb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“তমাম ক়ৈদিযোং ঔর লূটে হুএ জানৱরোং কো গিন। ইসমেং ইলিযজ়র ইমাম ঔর ক়বাযলী কুংবোং কে সরপরস্ত তেরী মদদ করেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","সারা মাল দো বরাবর কে হিস্সোং মেং তক়সীম করনা, এক হিস্সা ফ়ৌজিযোং কে লিএ ঔর দূসরা বাক়ী জমাত কে লিএ হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ফ়ৌজিযোং কে হিস্সে কে পাঁচ পাঁচ সৌ ক়ৈদিযোং মেং সে এক এক নিকালকর রব কো দেনা। ইসী তরহ পাঁচ পাঁচ সৌ বৈলোং, গধোং, ভেড়োং ঔর বকরিযোং মেং সে এক এক নিকালকর রব কো দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","উন্হেং ইলিযজ়র ইমাম কো দেনা তাকি ৱহ উন্হেং রব কো উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","বাক়ী জমাত কে হিস্সে কে পচাস পচাস ক়ৈদিযোং মেং সে এক এক নিকালকর রব কো দেনা, ইসী তরহ পচাস পচাস বৈলোং, গধোং, ভেড়োং ঔর বকরিযোং যা দূসরে জানৱরোং মেং সে ভী এক এক নিকালকর রব কো দেনা। উন্হেং উন লাৱিযোং কো দেনা জো রব কে মক়দিস কো সঁভালতে হৈং।” ");
INSERT INTO urdgvb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","মূসা ঔর ইলিযজ়র নে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_32‏","005_31_32‏","NUM","31","32‏","34","উন্হোংনে 6,75,000 ভেড়-বকরিযাঁ, 72,000 গায-বৈল ঔর 61,000 গধে গিনে। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ইনকে অলাৱা 32,000 ক়ৈদী কুঁৱারিযাঁ ভী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_36‏","005_31_36‏","NUM","31","36‏","40","ফ়ৌজিযোং কো তমাম চীজ়োং কা আধা হিস্সা মিল গযা যানী 3,37,500 ভেড়-বকরিযাঁ, 36,000 গায-বৈল, 30,500 গধে ঔর 16,000 ক়ৈদী কুঁৱারিযাঁ। ইনমেং সে উন্হোংনে 675 ভেড়-বকরিযাঁ, 72 গায-বৈল, 61 গধে ঔর 32 লড়কিযাঁ রব কো দীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","মূসা নে রব কা যহ হিস্সা ইলিযজ়র ইমাম কো উঠানেৱালী ক়ুরবানী কে তৌর পর দে দিযা, জিস তরহ রব নে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_42‏","005_31_42‏","NUM","31","42‏","47","বাক়ী জমাত কো ভী লূটে হুএ মাল কা আধা হিস্সা মিল গযা। মূসা নে পচাস পচাস ক়ৈদিযোং ঔর জানৱরোং মেং সে এক এক নিকালকর উন লাৱিযোং কো দে দিযা জো রব কা মক়দিস সঁভালতে থে। উসনে ৱৈসা হী কিযা জৈসা রব নে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ফির ৱহ অফ়সর মূসা কে পাস আএ জো লশকর কে হজ়ার হজ়ার ঔর সৌ সৌ আদমিযোং পর মুক়র্রর থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","উন্হোংনে উসসে কহা, “আপকে খ়াদিমোং নে উন ফ়ৌজিযোং কো গিন লিযা হৈ জিন পর ৱহ মুক়র্রর হৈং, ঔর হমেং পতা চল গযা কি এক ভী কম নহীং হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ইসলিএ হম রব কো সোনে কা তমাম জ়েৱর ক়ুরবান করনা চাহতে হৈং জো হমেং ফ়তহ পানে পর মিলা থা মসলন সোনে কে বাজ়ূবংদ, কংগন, মুহর লগানে কী অংগূঠিযাঁ, বালিযাঁ ঔর হার। যহ সব কুছ হম রব কো পেশ করনা চাহতে হৈং তাকি রব কে সামনে হমারা কফ়্ফ়ারা হো জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","মূসা ঔর ইলিযজ়র ইমাম নে সোনে কী তমাম চীজ়েং উনসে লে লীং। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","জো চীজ়েং উন্হোংনে অফ়সরান কে লূটে হুএ মাল মেং সে রব কো উঠানেৱালী ক়ুরবানী কে তৌর পর পেশ কীং উনকা পূরা ৱজ়ন তক়রীবন 190 কিলোগ্রাম থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","সির্ফ় অফ়সরান নে ঐসা কিযা। বাক়ী ফ়ৌজিযোং নে অপনা লূট কা মাল অপনে লিএ রখ লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","মূসা ঔর ইলিযজ়র অফ়সরান কা যহ সোনা মুলাক়াত কে খ়ৈমে মেং লে আএ তাকি ৱহ রব কো উস কী ক়ৌম কী যাদ দিলাতা রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","রূবিন ঔর জদ কে ক়বীলোং কে পাস বহুত-সে মৱেশী থে। জব উন্হোংনে দেখা কি যাজ়ের ঔর জিলিযাদ কা ইলাক়া মৱেশী পালনে কে লিএ অচ্ছা হৈ ");
INSERT INTO urdgvb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","তো উন্হোংনে মূসা, ইলিযজ়র ইমাম ঔর জমাত কে রাহনুমাওং কে পাস আকর কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU32_3‏","005_32_3‏","NUM","32","3‏","4","“জিস ইলাক়ে কো রব নে ইসরাঈল কী জমাত কে আগে আগে শিকস্ত দী হৈ ৱহ মৱেশী পালনে কে লিএ অচ্ছা হৈ। অতারাত, দীবোন, যাজ়ের, নিমরা, হসবোন, ইলিযালী, সবাম, নবূ ঔর বঊন জো ইসমেং শামিল হৈং হমারে কাম আএঁগে, ক্যোংকি আপকে খ়াদিমোং কে পাস মৱেশী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","অগর আপকী নজ়রে-করম হম পর হো তো হমেং যহ ইলাক়া দিযা জাএ। যহ হমারী মিলকিযত বন জাএ ঔর হমেং দরিযাএ-যরদন কো পার করনে পর মজবূর ন কিযা জাএ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","মূসা নে জদ ঔর রূবিন কে অফ়রাদ সে কহা, “ক্যা তুম যহাঁ পীছে রহকর অপনে ভাইযোং কো ছোড়না চাহতে হো জব ৱহ জংগ লড়নে কে লিএ আগে নিকলেংগে? ");
INSERT INTO urdgvb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ইস ৱক়্ত জব ইসরাঈলী দরিযাএ-যরদন কো পার করকে উস মুল্ক মেং দাখ়িল হোনেৱালে হৈং জো রব নে উন্হেং দিযা হৈ তো তুম ক্যোং উনকী হৌসলাশিকনী কর রহে হো? ");
INSERT INTO urdgvb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","তুম্হারে বাপদাদা নে ভী যহী কুছ কিযা জব মৈংনে উন্হেং ক়াদিস-বরনীঅ সে মুল্ক কে বারে মেং মালূমাত হাসিল করনে কে লিএ ভেজা। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ইসকাল কী ৱাদী মেং পহুঁচকর মুল্ক কী তফ়তীশ করনে কে বাদ উন্হোংনে ইসরাঈলিযোং কী হৌসলাশিকনী কী তাকি ৱহ উস মুল্ক মেং দাখ়িল ন হোং জো রব নে উন্হেং দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","উস দিন রব নে গ়ুস্সে মেং আকর ক়সম খাঈ, ");
INSERT INTO urdgvb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘উন আদমিযোং মেং সে জো মিসর সে নিকল আএ হৈং কোঈ উস মুল্ক কো নহীং দেখেগা জিসকা ৱাদা মৈংনে ক়সম খাকর ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে কিযা থা। ক্যোংকি উন্হোংনে পূরী ৱফ়াদারী সে মেরী পৈরৱী ন কী। সির্ফ় ৱহ জিনকী উম্র উস ৱক়্ত 20 সাল সে কম হৈ দাখ়িল হোংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","বুজ়ুর্গোং মেং সে সির্ফ় কালিব বিন যফ়ুন্না ক়নিজ়্জ়ী ঔর যশুঅ বিন নূন মুল্ক মেং দাখ়িল হোংগে, ইসলিএ কি উন্হোংনে পূরী ৱফ়াদারী সে মেরী পৈরৱী কী।’ ");
INSERT INTO urdgvb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","উস ৱক়্ত রব কা গ়জ়ব উন পর আন পড়া, ঔর উন্হেং 40 সাল তক রেগিস্তান মেং মারে মারে ফিরনা পড়া, জব তক কি ৱহ তমাম নসল খ়ত্ম ন হো গঈ জিসনে উসকে নজ়দীক গ়লত কাম কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","অব তুম গুনাহগারোং কী ঔলাদ অপনে বাপদাদা কী জগহ খড়ে হোকর রব কা ইসরাঈল পর গ়ুস্সা মজ়ীদ বঢ়া রহে হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","অগর তুম উস কী পৈরৱী সে হটোগে তো ৱহ দুবারা ইন লোগোং কো রেগিস্তান মেং রহনে দেগা, ঔর তুম ইনকী হলাকত কা বাইস বনোগে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ইসকে বাদ রূবিন ঔর জদ কে অফ়রাদ দুবারা মূসা কে পাস আএ ঔর কহা, “হম যহাঁ ফ়িলহাল অপনে মৱেশী কে লিএ বাড়ে ঔর অপনে বাল-বচ্চোং কে লিএ শহর বনানা চাহতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ইসকে বাদ হম মুসল্লহ হোকর ইসরাঈলিযোং কে আগে আগে চলেংগে ঔর হর এক কো উস কী অপনী জগহ তক পহুঁচাএঁগে। ইতনে মেং হমারে বাল-বচ্চে হমারে শহরোং কী ফ়সীলোং কে অংদর মুল্ক কে মুখ়ালিফ় বাশিংদোং সে মহফ়ূজ় রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","হম উস ৱক়্ত তক অপনে ঘরোং কো নহীং লৌটেংগে জব তক হর ইসরাঈলী কো উস কী মৌরূসী জ়মীন ন মিল জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","দূসরে, হম খ়ুদ উনকে সাথ দরিযাএ-যরদন কে মগ়রিব মেং মীরাস মেং কুছ নহীং পাএঁগে, ক্যোংকি হমেং অপনী মৌরূসী জ়মীন দরিযাএ-যরদন কে মশরিক়ী কিনারে পর মিল চুকী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","যহ সুনকর মূসা নে কহা, “অগর তুম ঐসা হী করোগে তো ঠীক হৈ। ফির রব কে সামনে জংগ কে লিএ তৈযার হো জাও ");
INSERT INTO urdgvb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ঔর সব হথিযার বাঁধকর রব কে সামনে দরিযাএ-যরদন কো পার করো। উস ৱক়্ত তক ন লৌটো জব তক রব নে অপনে তমাম দুশ্মনোং কো অপনে আগে সে নিকাল ন দিযা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ফির জব মুল্ক পর রব কা ক়ব্জ়া হো গযা হোগা তো তুম লৌট সকোগে। তব তুমনে রব ঔর অপনে হমৱতন ভাইযোং কে লিএ অপনে ফ়রাযজ় অদা কর দিএ হোংগে, ঔর যহ ইলাক়া রব কে সামনে তুম্হারা মৌরূসী হক় হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","লেকিন অগর তুম ঐসা ন করো তো ফির তুম রব হী কা গুনাহ করোগে। যক়ীন জানো তুম্হেং অপনে গুনাহ কী সজ়া মিলেগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","অব অপনে বাল-বচ্চোং কে লিএ শহর ঔর অপনে মৱেশিযোং কে লিএ বাড়ে বনা লো। লেকিন অপনে ৱাদে কো জ়রূর পূরা করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","জদ ঔর রূবিন কে অফ়রাদ নে মূসা সে কহা, “হম আপকে খ়াদিম হৈং, হম অপনে আক়া কে হুক্ম কে মুতাবিক় হী করেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","হমারে বাল-বচ্চে ঔর মৱেশী যহীং জিলিযাদ কে শহরোং মেং রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","লেকিন আপকে খ়াদিম মুসল্লহ হোকর দরিযা কো পার করেংগে ঔর রব কে সামনে জংগ করেংগে। হম সব কুছ ৱৈসা হী করেংগে জৈসা হমারে আক়া নে হমেং হুক্ম দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","তব মূসা নে ইলিযজ়র ইমাম, যশুঅ বিন নূন ঔর ক়বাযলী কুংবোং কে সরপরস্তোং কো হিদাযত দী, ");
INSERT INTO urdgvb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“লাজ়িম হৈ কি জদ ঔর রূবিন কে মর্দ মুসল্লহ হোকর তুম্হারে সাথ হী রব কে সামনে দরিযাএ-যরদন কো পার করেং ঔর মুল্ক পর ক়ব্জ়া করেং। অগর ৱহ ঐসা করেং তো উন্হেং মীরাস মেং জিলিযাদ কা ইলাক়া দো। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","লেকিন অগর ৱহ ঐসা ন করেং তো ফির উন্হেং মুল্কে-কনান হী মেং তুম্হারে সাথ মৌরূসী জ়মীন মিলে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","জদ ঔর রূবিন কে অফ়রাদ নে ইসরার কিযা, “আপকে খ়াদিম সব কুছ করেংগে জো রব নে কহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","হম মুসল্লহ হোকর রব কে সামনে দরিযাএ-যরদন কো পার করেংগে ঔর কনান কে মুল্ক মেং দাখ়িল হোংগে, অগরচে হমারী মৌরূসী জ়মীন যরদন কে মশরিক়ী কিনারে পর হোগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","তব মূসা নে জদ, রূবিন ঔর মনস্সী কে আধে ক়বীলে কো যহ ইলাক়া দিযা। উসমেং ৱহ পূরা মুল্ক শামিল থা জিস পর পহলে অমোরিযোং কা বাদশাহ সীহোন ঔর বসন কা বাদশাহ ওজ হুকূমত করতে থে। ইন শিকস্তখ়ুরদা মমালিক কে দেহাতোং সমেত তমাম শহর উনকে হৱালে কিএ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","জদ কে ক়বীলে নে দীবোন, অতারাত, অরোঈর, ");
INSERT INTO urdgvb_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","অতরাত-শোফ়ান, যাজ়ের, যুগবহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","বৈত-নিমরা ঔর বৈত-হারান কে শহরোং কো দুবারা তামীর কিযা। উন্হোংনে উনকী ফ়সীলেং বনাঈং ঔর অপনে মৱেশিযোং কে লিএ বাড়ে ভী। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","রূবিন কে ক়বীলে নে হসবোন, ইলিযালী, ক়িরিযতাযম, ");
INSERT INTO urdgvb_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","নবূ, বাল-মঊন ঔর সিবমাহ দুবারা তামীর কিএ। নবূ ঔর বাল-মঊন কে নাম বদল গএ, ক্যোংকি উন্হোংনে উন শহরোং কো নএ নাম দিএ জো উন্হোংনে দুবারা তামীর কিএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","মনস্সী কে বেটে মকীর কী ঔলাদ নে জিলিযাদ জাকর উস পর ক়ব্জ়া কর লিযা ঔর উসকে তমাম অমোরী বাশিংদোং কো নিকাল দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","চুনাঁচে মূসা নে মকীরিযোং কো জিলিযাদ কী সরজ়মীন দে দী, ঔর ৱহ ৱহাঁ আবাদ হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","মনস্সী কে এক আদমী বনাম যাঈর নে উস ইলাক়ে মেং কুছ বস্তিযোং পর ক়ব্জ়া করকে উন্হেং হৱ্ৱোত-যাঈর যানী ‘যাঈর কী বস্তিযাঁ’ কা নাম দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ইসী তরহ উস ক়বীলে কে এক ঔর আদমী বনাম নূবহ নে জাকর ক়নাত ঔর উসকে দেহাতোং পর ক়ব্জ়া কর লিযা। উসনে শহর কা নাম নূবহ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","জ়ৈল মেং উন জগহোং কে নাম হৈং জহাঁ জহাঁ ইসরাঈলী ক়বীলে অপনে দস্তোং কে মুতাবিক় মূসা ঔর হারূন কী রাহনুমাঈ মেং মিসর সে নিকলকর খ়ৈমাজ়ন হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","রব কে হুক্ম পর মূসা নে হর জগহ কা নাম ক়লমবংদ কিযা জহাঁ উন্হোংনে অপনে খ়ৈমে লগাএ থে। উন জগহোং কে নাম যহ হৈং : ");
INSERT INTO urdgvb_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","পহলে মহীনে কে পংদ্রহৱেং দিন ইসরাঈলী রামসীস সে রৱানা হুএ। যানী ফ়সহ কে দিন কে বাদ কে দিন ৱহ বড়ে ইখ়্তিযার কে সাথ তমাম মিসরিযোং কে দেখতে দেখতে চলে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","মিসরী উস ৱক়্ত অপনে পহলৌঠোং কো দফ়ন কর রহে থে, ক্যোংকি রব নে পহলৌঠোং কো মারকর উনকে দেৱতাওং কী অদালত কী থী। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","রামসীস সে ইসরাঈলী সুক্কাত পহুঁচ গএ জহাঁ উন্হোংনে পহলী মরতবা অপনে ডেরে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ৱহাঁ সে ৱহ এতাম পহুঁচে জো রেগিস্তান কে কিনারে পর ৱাক়ে হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","এতাম সে ৱহ ৱাপস মুড়কর ফ়ী-হখ়ীরোত কী তরফ় বঢ়ে জো বাল-সফ়োন কে মশরিক় মেং হৈ। ৱহ মিজদাল কে ক়রীব খ়ৈমাজ়ন হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ফির ৱহ ফ়ী-হখ়ীরোত সে কূচ করকে সমুংদর মেং সে গুজ়র গএ। ইসকে বাদ ৱহ তীন দিন এতাম কে রেগিস্তান মেং সফ়র করতে করতে মারা পহুঁচ গএ ঔর ৱহাঁ অপনে খ়ৈমে লগাএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","মারা সে ৱহ এলীম চলে গএ জহাঁ 12 চশ্মে ঔর খজূর কে 70 দরখ়্ত থে। ৱহাঁ ঠহরনে কে বাদ ");
INSERT INTO urdgvb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ৱহ বহরে-ক়ুলজ়ুম কে সাহিল পর খ়ৈমাজ়ন হুএ, ");
INSERT INTO urdgvb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ফির দশ্তে-সীন মেং পহুঁচ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","উনকে অগলে মরহলে যহ থে : দুফ়ক়া, ");
INSERT INTO urdgvb_vpl VALUES ("NU33_13‏","005_33_13‏","NUM","33","13‏","37","অলূস, রফ়ীদীম জহাঁ পীনে কা পানী দস্তযাব ন থা, দশ্তে-সীনা, ক়ব্রোত-হত্তাৱা, হসীরাত, রিতমা, রিম্মোন-ফ়ারস, লিবনা, রিস্সা, ক়হীলাতা, সাফ়র পহাড়, হরাদা, মক়হীলোত, তহত, তারহ, মিতক়া, হশমূনা, মৌসীরোত, বনী-যাক়ান, হোর-হজ্জিদজাদ, যুতবাতা, অবরূনা, অস্যূন-জাবর, দশ্তে-সীন মেং ৱাক়ে ক়াদিস ঔর হোর পহাড় জো অদোম কী সরহদ পর ৱাক়ে হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ৱহাঁ রব নে হারূন ইমাম কো হুক্ম দিযা কি ৱহ হোর পহাড় পর চঢ় জাএ। ৱহীং ৱহ পাঁচৱেং মাহ কে পহলে দিন ফ়ৌত হুআ। ইসরাঈলিযোং কো মিসর সে নিকলে 40 সাল গুজ়র চুকে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","উস ৱক়্ত হারূন 123 সাল কা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","উন দিনোং মেং অরাদ কে কনানী বাদশাহ নে সুনা কি ইসরাঈলী মেরে মুল্ক কী তরফ় বঢ় রহে হৈং। ৱহ কনান কে জুনূব মেং হুকূমত করতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_41‏","005_33_41‏","NUM","33","41‏","47","হোর পহাড় সে রৱানা হোকর ইসরাঈলী জ়ৈল কী জগহোং পর ঠহরে : জ়লমূনা, ফ়ূনোন, ওবোত, ঐযে-অবারীম জো মোআব কে ইলাক়ে মেং থা, দীবোন-জদ, অলমূন-দিবলাতাযম ঔর নবূ কে ক়রীব ৱাক়ে অবারীম কা পহাড়ী ইলাক়া। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ৱহাঁ সে উন্হোংনে যরদন কী ৱাদী মেং উতরকর মোআব কে মৈদানী ইলাক়ে মেং অপনে ডেরে লগাএ। অব ৱহ দরিযাএ-যরদন কে মশরিক়ী কিনারে পর যরীহূ শহর কে সামনে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","উনকে খ়ৈমে বৈত-যসীমোত সে লেকর অবীল-শিত্তীম তক লগে থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ৱহাঁ রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“ইসরাঈলিযোং কো বতানা কি জব তুম দরিযাএ-যরদন কো পার করকে মুল্কে-কনান মেং দাখ়িল হোগে ");
INSERT INTO urdgvb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","তো লাজ়িম হৈ কি তুম তমাম বাশিংদোং কো নিকাল দো। উনকে তরাশে ঔর ঢালে হুএ বুতোং কো তোড় ডালো ঔর উনকী ঊঁচী জগহোং কে মংদিরোং কো তবাহ করো। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","মুল্ক পর ক়ব্জ়া করকে উসমেং আবাদ হো জাও, ক্যোংকি মৈংনে যহ মুল্ক তুম্হেং দে দিযা হৈ। যহ মেরী তরফ় সে তুম্হারী মৌরূসী মিলকিযত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","মুল্ক কো মুখ়্তলিফ় ক়বীলোং ঔর খ়ানদানোং মেং ক়ুরা ডালকর তক়সীম করনা। হর খ়ানদান কে অফ়রাদ কী তাদাদ কা লিহাজ় রখনা। বড়ে খ়ানদান কো নিসবতন জ়্যাদা জ়মীন দেনা ঔর ছোটে খ়ানদান কো নিসবতন কম জ়মীন। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","লেকিন অগর তুম মুল্ক কে বাশিংদোং কো নহীং নিকালোগে তো বচে হুএ তুম্হারী আঁখোং মেং খ়ার ঔর তুম্হারে পহলুওং মেং কাঁটে বনকর তুম্হেং উস মুল্ক মেং তংগ করেংগে জিসমেং তুম আবাদ হোগে। ");
INSERT INTO urdgvb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ফির মৈং তুম্হারে সাথ ৱহ কুছ করূঁগা জো উনকে সাথ করনা চাহতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ইসরাঈলিযোং কো বতানা কি জব তুম উস মুল্ক মেং দাখ়িল হোগে জো মৈং তুম্হেং মীরাস মেং দূঁগা তো উস কী সরহদ্দেং যহ হোংগী : ");
INSERT INTO urdgvb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","উস কী জুনূবী সরহদ দশ্তে-সীন মেং অদোম কী সরহদ কে সাথ সাথ চলেগী। মশরিক় মেং ৱহ বহীরাএ-মুরদার কে জুনূবী সাহিল সে শুরূ হোগী, ফির ইন জগহোং সে হোকর মগ়রিব কী তরফ় গুজ়রেগী : ");
INSERT INTO urdgvb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","দর্রাএ-অক়্রব্বীম কে জুনূব মেং সে, দশ্তে-সীন মেং সে, ক়াদিস-বরনীঅ কে জুনূব মেং সে হসর-অদ্দার ঔর অজ়মূন মেং সে। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ৱহাঁ সে ৱহ মুড়কর মিসর কী সরহদ পর ৱাক়ে ৱাদীএ-মিসর কে সাথ সাথ বহীরাএ-রূম তক পহুঁচেগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","উস কী মগ়রিবী সরহদ বহীরাএ-রূম কা সাহিল হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","উস কী শিমালী সরহদ বহীরাএ-রূম সে লেকর ইন জগহোং সে হোকর মশরিক় কী তরফ় গুজ়রেগী : হোর পহাড়, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","লবো-হমাত, সিদাদ, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","জ়িফ়রূন ঔর হসর-এনান। হসর-এনান শিমালী সরহদ কা সবসে মশরিক়ী মক়াম হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","উস কী মশরিক়ী সরহদ শিমাল মেং হসর-এনান সে শুরূ হোগী। ফির ৱহ ইন জগহোং সে হোকর জুনূব কী তরফ় গুজ়রেগী : সিফ়াম, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","রিবলা জো ঐন কে মশরিক় মেং হৈ ঔর কিন্নরত যানী গলীল কী ঝীল কে মশরিক় মেং ৱাক়ে পহাড়ী ইলাক়া। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ইসকে বাদ ৱহ দরিযাএ-যরদন কে কিনারে কিনারে গুজ়রতী হুঈ বহীরাএ-মুরদার তক পহুঁচেগী। যহ তুম্হারে মুল্ক কী সরহদ্দেং হোংগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","মূসা নে ইসরাঈলিযোং সে কহা, “যহ ৱহী মুল্ক হৈ জিসে তুম্হেং ক়ুরা ডালকর তক়সীম করনা হৈ। রব নে হুক্ম দিযা হৈ কি উসে বাক়ী সাঢ়ে নৌ ক়বীলোং কো দেনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ক্যোংকি অঢ়াঈ ক়বীলোং কে খ়ানদানোং কো উনকী মীরাস মিল চুকী হৈ যানী রূবিন ঔর জদ কে পূরে ক়বীলে ঔর মনস্সী কে আধে ক়বীলে কো। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","উন্হেং যহাঁ, দরিযাএ-যরদন কে মশরিক় মেং যরীহূ কে সামনে জ়মীন মিল চুকী হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ইলিযজ়র ইমাম ঔর যশুঅ বিন নূন লোগোং কে লিএ মুল্ক তক়সীম করেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","হর ক়বীলে কে এক এক রাহনুমা কো ভী চুননা তাকি ৱহ তক়সীম করনে মেং মদদ করে। জিনকো তুম্হেং চুননা হৈ উনকে নাম যহ হৈং : ");
INSERT INTO urdgvb_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","যহূদাহ কে ক়বীলে কা কালিব বিন যফ়ুন্না, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","শমৌন কে ক়বীলে কা সমুএল বিন অম্মীহূদ, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","বিনযমীন কে ক়বীলে কা ইলীদাদ বিন কিস্লোন, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","দান কে ক়বীলে কা বুক়্ক়ী বিন যুগলী, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","মনস্সী কে ক়বীলে কা হন্নিযেল বিন অফ়ূদ, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ইফ়রাঈম কে ক়বীলে কা ক়মুএল বিন সিফ়তান, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","জ়বূলূন কে ক়বীলে কা ইলীসফ়ন বিন ফ়রনাক, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ইশকার কে ক়বীলে কা ফ়লতিযেল বিন অজ়্জ়ান, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","আশর কে ক়বীলে কা অখ়ীহূদ বিন শলূমী, ");
INSERT INTO urdgvb_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","নফ়তালী কে ক়বীলে কা ফ়িদাহেল বিন অম্মীহূদ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","রব নে ইন্হীং আদমিযোং কো মুল্ক কো ইসরাঈলিযোং মেং তক়সীম করনে কী জ়িম্মাদারী দী। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ইসরাঈলী অব তক মোআব কে মৈদানী ইলাক়ে মেং দরিযাএ-যরদন কে মশরিক়ী কিনারে পর যরীহূ কে সামনে থে। ৱহাঁ রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ইসরাঈলিযোং কো বতা দে কি ৱহ লাৱিযোং কো অপনী মিলী হুঈ জ়মীনোং মেং সে রহনে কে লিএ শহর দেং। উন্হেং শহরোং কে ইর্দগির্দ মৱেশী চরানে কী জ়মীন ভী মিলে। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ফির লাৱিযোং কে পাস রহনে কে লিএ শহর ঔর অপনে জানৱর চরানে কে লিএ জ়মীন হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","চরানে কে লিএ জ়মীন শহর কে ইর্দগির্দ হোগী, ঔর চারোং তরফ় কা ফ়াসলা ফ়সীলোং সে 1,500 ফ়ুট হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","চরানে কী যহ জ়মীন মুরব্বা শক্ল কী হোগী জিসকে হর পহলূ কা ফ়াসলা 3,000 ফ়ুট হো। শহর ইস মুরব্বা শক্ল কে বীচ মেং হো। যহ রক়বা শহর কে বাশিংদোং কে লিএ হো তাকি ৱহ অপনে মৱেশী চরা সকেং। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_6‏","005_35_6‏","NUM","35","6‏","7","লাৱিযোং কো কুল 48 শহর দেনা। ইনমেং সে ছঃ পনাহ কে শহর মুক়র্রর করনা। উনমেং ঐসে লোগ পনাহ লে সকেংগে জিনকে হাথোং গ়ৈরইরাদী তৌর পর কোঈ হলাক হুআ হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","হর ক়বীলা লাৱিযোং কো অপনে ইলাক়ে কে রক়বে কে মুতাবিক় শহর দে। জিস ক়বীলে কা ইলাক়া বড়া হৈ উসে লাৱিযোং কো জ়্যাদা শহর দেনে হৈং জবকি জিস ক়বীলে কা ইলাক়া ছোটা হৈ ৱহ লাৱিযোং কো কম শহর দে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ফির রব নে মূসা সে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ইসরাঈলিযোং কো বতানা কি দরিযাএ-যরদন কো পার করনে কে বাদ ");
INSERT INTO urdgvb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","কুছ পনাহ কে শহর মুক়র্রর করনা। উনমেং ৱহ শখ়্স পনাহ লে সকেগা জিসকে হাথোং গ়ৈরইরাদী তৌর পর কোঈ হলাক হুআ হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ৱহাঁ ৱহ ইংতক়াম লেনেৱালে সে পনাহ লে সকেগা ঔর জমাত কী অদালত কে সামনে খড়ে হোনে সে পহলে মারা নহীং জা সকেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ইসকে লিএ ছঃ শহর চুন লো। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","তীন দরিযাএ-যরদন কে মশরিক় মেং ঔর তীন মুল্কে-কনান মেং হোং। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","যহ ছঃ শহর হর কিসী কো পনাহ দেংগে, চাহে ৱহ ইসরাঈলী, পরদেসী যা উনকে দরমিযান রহনেৱালা গ়ৈরশহরী হো। জিসসে ভী গ়ৈরইরাদী তৌর পর কোঈ হলাক হুআ হো ৱহ ৱহাঁ পনাহ লে সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_16‏","005_35_16‏","NUM","35","16‏","18","অগর কিসী নে কিসী কো জান-বূঝকর লোহে, পত্থর যা লকড়ী কী কিসী চীজ় সে মার ডালা হো ৱহ ক়াতিল হৈ ঔর উসে সজ়াএ-মৌত দেনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","মক়তূল কা সবসে ক়রীবী রিশ্তেদার উসে তলাশ করকে মার দে। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_20‏","005_35_20‏","NUM","35","20‏","21","ক্যোংকি জো নফ়রত যা দুশ্মনী কে বাইস জান-বূঝকর কিসী কো যোং ধক্কা দে, উস পর কোঈ চীজ় ফেংক দে যা উসে মুক্কা মারে কি ৱহ মর জাএ ৱহ ক়াতিল হৈ ঔর উসে সজ়াএ-মৌত দেনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","লেকিন ৱহ ক়াতিল নহীং হৈ জিসসে দুশ্মনী কে বাইস নহীং বল্কি ইত্তফ়াক় সে ঔর গ়ৈরইরাদী তৌর পর কোঈ হলাক হুআ হো, চাহে উসনে উসে ধক্কা দিযা, কোঈ চীজ় উস পর ফেংক দী ");
INSERT INTO urdgvb_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","যা কোঈ পত্থর উস পর গিরনে দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","অগর ঐসা হুআ তো লাজ়িম হৈ কি জমাত ইন হিদাযাত কে মুতাবিক় উসকে ঔর ইংতক়াম লেনেৱালে কে দরমিযান ফ়ৈসলা করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","অগর মুলজ়িম বেক়ুসূর হৈ তো জমাত উস কী হিফ়াজ়ত করকে উসে পনাহ কে উস শহর মেং ৱাপস লে জাএ জিসমেং উসনে পনাহ লী হৈ। ৱহাঁ ৱহ মুক়দ্দস তেল সে মসহ কিএ গএ ইমামে-আজ়ম কী মৌত তক রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","লেকিন অগর যহ শখ়্স ইসসে পহলে পনাহ কে শহর সে নিকলে তো ৱহ মহফ়ূজ় নহীং হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","অগর উসকা ইংতক়াম লেনেৱালে সে সামনা হো জাএ তো ইংতক়াম লেনেৱালে কো উসে মার ডালনে কী ইজাজ়ত হোগী। অগর ৱহ ঐসা করে তো বেক়ুসূর রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","পনাহ লেনেৱালা ইমামে-আজ়ম কী ৱফ়াত তক পনাহ কে শহর মেং রহে। ইসকে বাদ হী ৱহ অপনে ঘর ৱাপস জা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","যহ উসূল দাযমী হৈং। জহাঁ ভী তুম রহতে হো তুম্হেং হমেশা ইন পর অমল করনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","জিস পর ক়ত্ল কা ইলজ়াম লগাযা গযা হো উসে সির্ফ় ইস সূরত মেং সজ়াএ-মৌত দী জা সকতী হৈ কি কম অজ় কম দো গৱাহ হোং। এক গৱাহ কাফ়ী নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ক়াতিল কো জ়রূর সজ়াএ-মৌত দেনা। খ়াহ ৱহ ইসসে বচনে কে লিএ কোঈ ভী মুআৱজ়া দে উসে আজ়াদ ন ছোড়না বল্কি সজ়াএ-মৌত দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","উস শখ়্স সে ভী পৈসে ক়বূল ন করনা জিসসে গ়ৈরইরাদী তৌর পর কোঈ হলাক হুআ হো ঔর জো ইস সবব সে পনাহ কে শহর মেং রহ রহা হৈ। উসে ইজাজ়ত নহীং কি ৱহ পৈসে দেকর পনাহ কা শহর ছোড়ে ঔর অপনে ঘর ৱাপস চলা জাএ। লাজ়িম হৈ কি ৱহ ইসকে লিএ ইমামে-আজ়ম কী ৱফ়াত কা ইংতজ়ার করে। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","জিস মুল্ক মেং তুম রহতে হো উস কী মুক়দ্দস হালত কো নাপাক ন করনা। জব কিসী কো উসমেং ক়ত্ল কিযা জাএ তো ৱহ নাপাক হো জাতা হৈ। জব ইস তরহ খ়ূন বহতা হৈ তো মুল্ক কী মুক়দ্দস হালত সির্ফ় উস শখ়্স কে খ়ূন বহনে সে বহাল হো জাতী হৈ জিসনে যহ খ়ূন বহাযা হৈ। যানী মুল্ক কা সির্ফ় ক়াতিল কী মৌত সে হী কফ়্ফ়ারা দিযা জা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","উস মুল্ক কো নাপাক ন করনা জিসমেং তুম আবাদ হো ঔর জিসমেং মৈং সুকূনত করতা হূঁ। ক্যোংকি মৈং রব হূঁ জো ইসরাঈলিযোং কে দরমিযান সুকূনত করতা হূঁ।” ");
INSERT INTO urdgvb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","এক দিন জিলিযাদ বিন মকীর বিন মনস্সী বিন যূসুফ় কে কুংবে সে নিকলে হুএ আবাঈ ঘরানোং কে সরপরস্ত মূসা ঔর উন সরদারোং কে পাস আএ জো দীগর আবাঈ ঘরানোং কে সরপরস্ত থে। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","উন্হোংনে কহা, “রব নে আপকো হুক্ম দিযা থা কি আপ ক়ুরা ডালকর মুল্ক কো ইসরাঈলিযোং মেং তক়সীম করেং। উস ৱক়্ত উসনে যহ ভী কহা থা কি হমারে ভাঈ সিলাফ়িহাদ কী বেটিযোং কো উস কী মৌরূসী জ়মীন মিলনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","অগর ৱহ ইসরাঈল কে কিসী ঔর ক়বীলে কে মর্দোং সে শাদী করেং তো ফির যহ জ়মীন জো হমারে ক়বীলে কা মৌরূসী হিস্সা হৈ উস ক়বীলে কা মৌরূসী হিস্সা বনেগী ঔর হম উসসে মহরূম হো জাএংগে। ফির হমারা ক়বাযলী ইলাক়া ছোটা হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ঔর অগর হম যহ জ়মীন ৱাপস ভী খ়রীদেং তো ভী ৱহ অগলে বহালী কে সাল মেং দূসরে ক়বীলে কো ৱাপস চলী জাএগী জিসমেং ইন ঔরতোং নে শাদী কী হৈ। ইস তরহ ৱহ হমেশা কে লিএ হমারে হাথ সে নিকল জাএগী।” ");
INSERT INTO urdgvb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","মূসা নে রব কে হুক্ম পর ইসরাঈলিযোং কো বতাযা, “জিলিযাদ কে মর্দ হক়-বজানিব হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ইসলিএ রব কী হিদাযত যহ হৈ কি সিলাফ়িহাদ কী বেটিযোং কো হর আদমী সে শাদী করনে কী ইজাজ়ত হৈ, লেকিন সির্ফ় ইস সূরত মেং কি ৱহ উনকে অপনে ক়বীলে কা হো। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ইস তরহ এক ক়বীলে কী মৌরূসী জ়মীন কিসী দূসরে ক়বীলে মেং মুংতক়িল নহীং হোগী। লাজ়িম হৈ কি হর ক়বীলে কা পূরা ইলাক়া উসী কে পাস রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","জো ভী বেটী মীরাস মেং জ়মীন পাতী হৈ উসকে লিএ লাজ়িম হৈ কি ৱহ অপনে হী ক়বীলে কে কিসী মর্দ সে শাদী করে তাকি উস কী জ়মীন ক়বীলে কে পাস হী রহে। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","এক ক়বীলে কী মৌরূসী জ়মীন কিসী দূসরে ক়বীলে কো মুংতক়িল করনে কী ইজাজ়ত নহীং হৈ। লাজ়িম হৈ কি হর ক়বীলে কা পূরা মৌরূসী ইলাক়া উসী কে পাস রহে।” ");
INSERT INTO urdgvb_vpl VALUES ("NU36_10‏","005_36_10‏","NUM","36","10‏","11","সিলাফ়িহাদ কী বেটিযোং মহলাহ, তিরজ়া, হুজলাহ, মিলকাহ ঔর নুআহ নে ৱৈসা হী কিযা জৈসা রব নে মূসা কো বতাযা থা। উন্হোংনে অপনে চচাজ়াদ ভাইযোং সে শাদী কী। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","চূঁকি ৱহ ভী মনস্সী কে ক়বীলে কে থে ইসলিএ যহ মৌরূসী জ়মীন সিলাফ়িহাদ কে ক়বীলে কে পাস রহী। ");
INSERT INTO urdgvb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","রব নে যহ অহকাম ঔর হিদাযাত ইসরাঈলিযোং কো মূসা কী মারিফ়ত দীং জব ৱহ মোআব কে মৈদানী ইলাক়ে মেং দরিযাএ-যরদন কে মশরিক়ী কিনারে পর যরীহূ কে সামনে খ়ৈমাজ়ন থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ইস কিতাব মেং ৱহ বাতেং দর্জ হৈং জো মূসা নে তমাম ইসরাঈলিযোং সে কহীং জব ৱহ দরিযাএ-যরদন কে মশরিক়ী কিনারে পর বযাবান মেং থে। ৱহ যরদন কী ৱাদী মেং সূফ় কে ক়রীব থে। এক তরফ় ফ়ারান শহর থা ঔর দূসরী তরফ় তোফ়ল, লাবন, হসীরাত ঔর দীজ়হব কে শহর থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","অগর অদোম কে পহাড়ী ইলাক়ে সে হোকর জাএঁ তো হোরিব যানী সীনা পহাড় সে ক়াদিস-বরনীঅ তক কা সফ়র 11 দিন মেং তয কিযা জা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ইসরাঈলিযোং কো মিসর সে নিকলে 40 সাল হো গএ থে। ইস সাল কে গ্যারহৱেং মাহ কে পহলে দিন মূসা নে উন্হেং সব কুছ বতাযা জো রব নে উসে উন্হেং বতানে কো কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","উস ৱক়্ত ৱহ অমোরিযোং কে বাদশাহ সীহোন কো শিকস্ত দে চুকা থা জিসকা দারুল-হুকূমত হসবোন থা। বসন কে বাদশাহ ওজ পর ভী ফ়তহ হাসিল হো চুকী থী জিসকী হুকূমত কে মরকজ় অস্তারাত ঔর ইদরঈ থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ৱহাঁ, দরিযাএ-যরদন কে মশরিক়ী কিনারে পর জো মোআব কে ইলাক়ে মেং থা মূসা অল্লাহ কী শরীঅত কী তশরীহ করনে লগা। উসনে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","জব তুম হোরিব যানী সীনা পহাড় কে পাস থে তো রব হমারে খ়ুদা নে হমসে কহা, “তুম কাফ়ী দের সে যহাঁ ঠহরে হুএ হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","অব ইস জগহ কো ছোড়কর আগে মুল্কে-কনান কী তরফ় বঢ়ো। অমোরিযোং কে পহাড়ী ইলাক়ে ঔর উনকে পড়োস কী ক়ৌমোং কে পাস জাও জো যরদন কে মৈদানী ইলাক়ে মেং আবাদ হৈং। পহাড়ী ইলাক়ে মেং, মগ়রিব কে নশেবী পহাড়ী ইলাক়ে মেং, জুনূব কে দশ্তে-নজব মেং, সাহিলী ইলাক়ে মেং, মুল্কে-কনান মেং ঔর লুবনান মেং দরিযাএ-ফ়ুরাত তক চলে জাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","মৈংনে তুম্হেং যহ মুল্ক দে দিযা হৈ। অব জাকর উস পর ক়ব্জ়া কর লো। ক্যোংকি রব নে ক়সম খাকর তুম্হারে বাপদাদা ইব্রাহীম, ইসহাক় ঔর যাক়ূব সে ৱাদা কিযা থা কি মৈং যহ মুল্ক তুম্হেং ঔর তুম্হারী ঔলাদ কো দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","উস ৱক়্ত মৈংনে তুমসে কহা, “মৈং অকেলা তুম্হারী রাহনুমাঈ করনে কী জ়িম্মাদারী নহীং উঠা সকতা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","রব তুম্হারে খ়ুদা নে তুম্হারী তাদাদ ইতনী বঢ়া দী হৈ কি আজ তুম আসমান কে সিতারোং কী মানিংদ বেশুমার হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ঔর রব তুম্হারে বাপদাদা কা খ়ুদা করে কি তুম্হারী তাদাদ মজ়ীদ হজ়ার গুনা বঢ় জাএ। ৱহ তুম্হেং ৱহ বরকত দে জিসকা ৱাদা উসনে কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","লেকিন মৈং অকেলা হী তুম্হারা বোঝ উঠানে ঔর ঝগড়োং কো নিপটানে কী জ়িম্মাদারী নহীং উঠা সকতা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ইসলিএ অপনে হর ক়বীলে মেং সে কুছ ঐসে দানিশমংদ ঔর সমঝদার আদমী চুন লো জিনকী লিযাক়ত কো লোগ মানতে হৈং। ফির মৈং উন্হেং তুম পর মুক়র্রর করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","যহ বাত তুম্হেং পসংদ আঈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","তুমনে অপনে মেং সে ঐসে রাহনুমা চুন লিএ জো দানিশমংদ থে ঔর জিনকী লিযাক়ত কো লোগ মানতে থে। ফির মৈংনে উন্হেং হজ়ার হজ়ার, সৌ সৌ ঔর পচাস পচাস মর্দোং পর মুক়র্রর কিযা। যোং ৱহ ক়বীলোং কে নিগহবান বন গএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","উস ৱক়্ত মৈংনে উন ক়াজ়িযোং সে কহা, “অদালত করতে ৱক়্ত হর এক কী বাত গ়ৌর সে সুনকর গ়ৈরজানিবদার ফ়ৈসলে করনা, চাহে দো ইসরাঈলী ফ়রীক় এক দূসরে সে ঝগড়া কর রহে হোং যা মামলা কিসী ইসরাঈলী ঔর পরদেসী কে দরমিযান হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","অদালত করতে ৱক়্ত জানিবদারী ন করনা। ছোটে ঔর বড়ে কী বাত সুনকর দোনোং কে সাথ এক জৈসা সুলূক করনা। কিসী সে মত ডরনা, ক্যোংকি অল্লাহ হী নে তুম্হেং অদালত করনে কী জ়িম্মাদারী দী হৈ। অগর কিসী মামলে মেং ফ়ৈসলা করনা তুম্হারে লিএ মুশ্কিল হো তো উসে মুঝে পেশ করো। ফির মৈং হী উসকা ফ়ৈসলা করূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","উস ৱক়্ত মৈংনে তুম্হেং সব কুছ বতাযা জো তুম্হেং করনা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","হমনে ৱৈসা হী কিযা জৈসা রব নে হমেং কহা থা। হম হোরিব সে রৱানা হোকর অমোরিযোং কে পহাড়ী ইলাক়ে কী তরফ় বঢ়ে। সফ়র করতে করতে হম উস ৱসী ঔর হৌলনাক রেগিস্তান মেং সে গুজ়র গএ জিসে তুমনে দেখ লিযা হৈ। আখ়িরকার হম ক়াদিস-বরনীঅ পহুঁচ গএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ৱহাঁ মৈংনে তুমসে কহা, “তুম অমোরিযোং কে পহাড়ী ইলাক়ে তক পহুঁচ গএ হো জো রব হমারা খ়ুদা হমেং দেনেৱালা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","দেখ, রব তেরে খ়ুদা নে তুঝে যহ মুল্ক দে দিযা হৈ। অব জাকর উস পর ক়ব্জ়া কর লে জিস তরহ রব তেরে বাপদাদা কে খ়ুদা নে তুঝে বতাযা হৈ। মত ডরনা ঔর বেদিল ন হো জানা!” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","লেকিন তুম সব মেরে পাস আএ ঔর কহা, “ক্যোং ন হম জানে সে পহলে কুছ আদমী ভেজেং জো মুল্ক কে হালাত দরিযাফ়্ত করেং ঔর ৱাপস আকর হমেং উস রাস্তে কে বারে মেং বতাএঁ জিস পর হমেং জানা হৈ ঔর উন শহরোং কে বারে মেং ইত্তলা দেং জিনকে পাস হম পহুঁচেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","যহ বাত মুঝে পসংদ আঈ। মৈংনে ইস কাম কে লিএ হর ক়বীলে কে এক আদমী কো চুনকর ভেজ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","জব যহ বারহ আদমী পহাড়ী ইলাক়ে মেং জাকর ৱাদীএ-ইসকাল মেং পহুঁচে তো উস কী তফ়তীশ কী। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ফির ৱহ মুল্ক কা কুছ ফল লেকর লৌট আএ ঔর হমেং মুল্ক কে বারে মেং ইত্তলা দেকর কহা, “জো মুল্ক রব হমারা খ়ুদা হমেং দেনেৱালা হৈ ৱহ অচ্ছা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","লেকিন তুম জানা নহীং চাহতে থে বল্কি সরকশী করকে রব অপনে খ়ুদা কা হুক্ম ন মানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","তুমনে অপনে খ়ৈমোং মেং বুড়বুড়াতে হুএ কহা, “রব হমসে নফ়রত রখতা হৈ। ৱহ হমেং মিসর সে নিকাল লাযা হৈ তাকি হমেং অমোরিযোং কে হাথোং হলাক করৱাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","হম কহাঁ জাএঁ? হমারে ভাইযোং নে হমেং বেদিল কর দিযা হৈ। ৱহ কহতে হৈং, ‘ৱহাঁ কে লোগ হমসে তাক়তৱর ঔর দরাজ়ক়দ হৈং। উনকে বড়ে বড়ে শহরোং কী ফ়সীলেং আসমান সে বাতেং করতী হৈং। ৱহাঁ হমনে অনাক় কী ঔলাদ ভী দেখী জো দেৱক়ামত হৈং’।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","মৈংনে কহা, “ন ঘবরাও ঔর ন উনসে খ়ৌফ় খাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","রব তুম্হারা খ়ুদা তুম্হারে আগে আগে চলতা হুআ তুম্হারে লিএ লড়েগা। তুম খ়ুদ দেখ চুকে হো কি ৱহ কিস তরহ মিসর ");
INSERT INTO urdgvb_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ঔর রেগিস্তান মেং তুম্হারে লিএ লড়া। যহাঁ ভী ৱহ ঐসা হী করেগা। তূ খ়ুদ গৱাহ হৈ কি বযাবান মেং পূরে সফ়র কে দৌরান রব তুঝে যোং উঠাএ ফিরা জিস তরহ বাপ অপনে বেটে কো উঠাএ ফিরতা হৈ। ইস তরহ চলতে চলতে তুম যহাঁ তক পহুঁচ গএ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ইসকে বাৱুজূদ তুমনে রব অপনে খ়ুদা পর ভরোসা ন রখা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","তুমনে যহ বাত নজ়রংদাজ় কী কি ৱহ সফ়র কে দৌরান রাত কে ৱক়্ত আগ ঔর দিন কে ৱক়্ত বাদল কী সূরত মেং তুম্হারে আগে আগে চলতা রহা তাকি তুম্হারে লিএ খ়ৈমে লগানে কী জগহেং মালূম করে ঔর তুম্হেং রাস্তা দিখাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","জব রব নে তুম্হারী যহ বাতেং সুনীং তো উসে গ়ুস্সা আযা ঔর উসনে ক়সম খাকর কহা, ");
INSERT INTO urdgvb_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“ইস শরীর নসল কা এক মর্দ ভী উস অচ্ছে মুল্ক কো নহীং দেখেগা অগরচে মৈংনে ক়সম খাকর তুম্হারে বাপদাদা সে ৱাদা কিযা থা কি মৈং উসে উন্হেং দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","সির্ফ় কালিব বিন যফ়ুন্না উসে দেখেগা। মৈং উসে ঔর উস কী ঔলাদ কো ৱহ মুল্ক দূঁগা জিসমেং উসনে সফ়র কিযা হৈ, ক্যোংকি উসনে পূরে তৌর পর রব কী পৈরৱী কী।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","তুম্হারী ৱজহ সে রব মুঝসে ভী নারাজ় হুআ ঔর কহা, “তূ ভী উসমেং দাখ়িল নহীং হোগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","লেকিন তেরা মদদগার যশুঅ বিন নূন দাখ়িল হোগা। উস কী হৌসলাঅফ়্জ়াঈ কর, ক্যোংকি ৱহ মুল্ক পর ক়ব্জ়া করনে মেং ইসরাঈল কী রাহনুমাঈ করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","তুমসে রব নে কহা, “তুম্হারে বচ্চে জো অভী অচ্ছে ঔর বুরে মেং ইম্তিযাজ় নহীং কর সকতে, ৱহী মুল্ক মেং দাখ়িল হোংগে, ৱহী বচ্চে জিনকে বারে মেং তুমনে কহা কি দুশ্মন উন্হেং মুল্কে-কনান মেং ছীন লেংগে। উন্হেং মৈং মুল্ক দূঁগা, ঔর ৱহ উস পর ক়ব্জ়া করেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","লেকিন তুম খ়ুদ আগে ন বঢ়ো। পীছে মুড়কর দুবারা রেগিস্তান মেং বহরে-ক়ুলজ়ুম কী তরফ় সফ়র করো।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","তব তুমনে কহা, “হমনে রব কা গুনাহ কিযা হৈ। অব হম মুল্ক মেং জাকর লড়েংগে, জিস তরহ রব হমারে খ়ুদা নে হমেং হুক্ম দিযা হৈ।” চুনাঁচে যহ সোচতে হুএ কি উস পহাড়ী ইলাক়ে পর হমলা করনা আসান হোগা, হর এক মুসল্লহ হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","লেকিন রব নে মুঝসে কহা, “উন্হেং বতানা কি ৱহাঁ জংগ করনে কে লিএ ন জাও, ক্যোংকি মৈং তুম্হারে সাথ নহীং হূঁগা। তুম অপনে দুশ্মনোং কে হাথোং শিকস্ত খাওগে।” ");
INSERT INTO urdgvb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","মৈংনে তুম্হেং যহ বতাযা, লেকিন তুমনে মেরী ন সুনী। তুমনে সরকশী করকে রব কা হুক্ম ন মানা বল্কি মগ়রূর হোকর পহাড়ী ইলাক়ে মেং দাখ়িল হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ৱহাঁ কে অমোরী বাশিংদে তুম্হারা সামনা করনে নিকলে। ৱহ শহদ কী মক্খিযোং কে গ়োল কী তরহ তুম পর টূট পড়ে ঔর তুম্হারা তাক়্ক়ুব করকে তুম্হেং সঈর সে হুরমা তক মারতে গএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","তব তুম ৱাপস আকর রব কে সামনে জ়ারো-ক়তার রোনে লগে। লেকিন উসনে তৱজ্জুহ ন দী বল্কি তুম্হেং নজ়রংদাজ় কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ইসকে বাদ তুম বহুত দিনোং তক ক়াদিস-বরনীঅ মেং রহে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ফির জিস তরহ রব নে মুঝে হুক্ম দিযা থা হম পীছে মুড়কর রেগিস্তান মেং বহরে-ক়ুলজ়ুম কী তরফ় সফ়র করনে লগে। কাফ়ী দের তক হম সঈর যানী অদোম কে পহাড়ী ইলাক়ে কে কিনারে কিনারে ফিরতে রহে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","এক দিন রব নে মুঝসে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“তুম বহুত দের সে ইস পহাড়ী ইলাক়ে কে কিনারে কিনারে ফির রহে হো। অব শিমাল কী তরফ় সফ়র করো। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ক়ৌম কো বতানা, অগলে দিনোং মেং তুম সঈর কে মুল্ক মেং সে গুজ়রোগে জহাঁ তুম্হারে ভাঈ এসৌ কী ঔলাদ আবাদ হৈ। ৱহ তুমসে ডরেংগে। তো ভী বড়ী এহতিযাত সে গুজ়রনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","উনকে সাথ জংগ ন ছেড়না, ক্যোংকি মৈং তুম্হেং উনকে মুল্ক কা এক মুরব্বা ফ়ুট ভী নহীং দূঁগা। মৈংনে সঈর কা পহাড়ী ইলাক়া এসৌ ঔর উস কী ঔলাদ কো দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","লাজ়িম হৈ কি তুম খানে ঔর পীনে কী তমাম জ়রূরিযাত পৈসে দেকর খ়রীদো।” ");
INSERT INTO urdgvb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","জো ভী কাম তূনে কিযা হৈ রব নে উস পর বরকত দী হৈ। ইস ৱসী রেগিস্তান মেং পূরে সফ়র কে দৌরান উসনে তেরী নিগহবানী কী। ইন 40 সালোং কে দৌরান রব তেরা খ়ুদা তেরে সাথ থা, ঔর তেরী তমাম জ়রূরিযাত পূরী হোতী রহীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","চুনাঁচে হম সঈর কো ছোড়কর জহাঁ হমারে ভাঈ এসৌ কী ঔলাদ আবাদ থী দূসরে রাস্তে সে আগে নিকলে। হমনে ৱহ রাস্তা ছোড় দিযা জো ঐলাত ঔর অস্যূন-জাবর কে শহরোং সে বহীরাএ-মুরদার তক পহুঁচাতা হৈ ঔর মোআব কে বযাবান কী তরফ় বঢ়নে লগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ৱহাঁ রব নে মুঝসে কহা, “মোআব কে বাশিংদোং কী মুখ়ালফ়ত ন করনা ঔর ন উনকে সাথ জংগ ছেড়না, ক্যোংকি মৈং উনকে মুল্ক কা কোঈ ভী হিস্সা তুঝে নহীং দূঁগা। মৈংনে আর শহর কো লূত কী ঔলাদ কো দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","পহলে ঐমী ৱহাঁ রহতে থে জো অনাক় কী ঔলাদ কী তরহ তাক়তৱর, দরাজ়ক়দ ঔর তাদাদ মেং জ়্যাদা থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","অনাক় কী ঔলাদ কী তরহ ৱহ রফ়াইযোং মেং শুমার কিএ জাতে থে, লেকিন মোআবী উন্হেং ঐমী কহতে থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ইসী তরহ ক়দীম জ়মানে মেং হোরী সঈর মেং আবাদ থে, লেকিন এসৌ কী ঔলাদ নে উন্হেং ৱহাঁ সে নিকাল দিযা থা। জিস তরহ ইসরাঈলিযোং নে বাদ মেং উস মুল্ক মেং কিযা জো রব নে উন্হেং দিযা থা উসী তরহ এসৌ কী ঔলাদ বঢ়তে বঢ়তে হোরিযোং কো তবাহ করকে উনকী জগহ আবাদ হুএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","রব নে কহা, “অব জাকর ৱাদীএ-জ়িরদ কো উবূর করো।” হমনে ঐসা হী কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","হমেং ক়াদিস-বরনীঅ সে রৱানা হুএ 38 সাল হো গএ থে। অব ৱহ তমাম আদমী মর চুকে থে জো উস ৱক়্ত জংগ করনে কে ক়াবিল থে। ৱৈসা হী হুআ থা জৈসা রব নে ক়সম খাকর কহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","রব কী মুখ়ালফ়ত কে বাইস আখ়িরকার খ়ৈমাগাহ মেং উস নসল কা এক মর্দ ভী ন রহা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","জব ৱহ সব মর গএ থে ");
INSERT INTO urdgvb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","তব রব নে মুঝসে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“আজ তুম্হেং আর শহর সে হোকর মোআব কে ইলাক়ে মেং সে গুজ়রনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ফির তুম অম্মোনিযোং কে ইলাক়ে তক পহুঁচোগে। উনকী ভী মুখ়ালফ়ত ন করনা, ঔর ন উনকে সাথ জংগ ছেড়না, ক্যোংকি মৈং উনকে মুল্ক কা কোঈ ভী হিস্সা তুম্হেং নহীং দূঁগা। মৈংনে যহ মুল্ক লূত কী ঔলাদ কো দিযা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","হক়ীক়ত মেং অম্মোনিযোং কা মুল্ক ভী রফ়াইযোং কা মুল্ক সমঝা জাতা থা জো ক়দীম জ়মানে মেং ৱহাঁ আবাদ থে। অম্মোনী উন্হেং জ়মজ়ুমী কহতে থে, ");
INSERT INTO urdgvb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ঔর ৱহ দেৱক়ামত থে, তাক়তৱর ঔর তাদাদ মেং জ়্যাদা। ৱহ অনাক় কী ঔলাদ জৈসে দরাজ়ক়দ থে। জব অম্মোনী মুল্ক মেং আএ তো রব নে রফ়াইযোং কো উনকে আগে আগে তবাহ কর দিযা। চুনাঁচে অম্মোনী বঢ়তে বঢ়তে উন্হেং নিকালতে গএ ঔর উনকী জগহ আবাদ হুএ, ");
INSERT INTO urdgvb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","বিলকুল উসী তরহ জিস তরহ রব নে এসৌ কী ঔলাদ কে আগে আগে হোরিযোং কো তবাহ কর দিযা থা জব ৱহ সঈর কে মুল্ক মেং আএ থে। ৱহাঁ ভী ৱহ বঢ়তে বঢ়তে হোরিযোং কো নিকালতে গএ ঔর উনকী জগহ আবাদ হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ইসী তরহ এক ঔর ক়দীম ক়ৌম বনাম অৱ্ৱী কো ভী উসকে মুল্ক সে নিকালা গযা। অৱ্ৱী গ়জ়্জ়া তক আবাদ থে, লেকিন জব কফ়তূরী কফ়তূর যানী ক্রেতে সে আএ তো উন্হোংনে উন্হেং তবাহ কর দিযা ঔর উনকী জগহ আবাদ হো গএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","রব নে মূসা সে কহা, “অব জাকর ৱাদীএ-অরনোন কো উবূর করো। যোং সমঝো কি মৈং হসবোন কে অমোরী বাদশাহ সীহোন কো উসকে মুল্ক সমেত তুম্হারে হৱালে কর চুকা হূঁ। উস পর ক়ব্জ়া করনা শুরূ করো ঔর উসকে সাথ জংগ করনে কা মৌক়া ঢূঁডো। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ইসী দিন সে মৈং তমাম ক়ৌমোং মেং তুম্হারে বারে মেং দহশত ঔর খ়ৌফ় পৈদা করূঁগা। ৱহ তুম্হারী খ়বর সুনকর খ়ৌফ় কে মারে থরথরাএঁগী ঔর কাঁপেংগী।” ");
INSERT INTO urdgvb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","মৈংনে দশ্তে-ক়দীমাত সে হসবোন কে বাদশাহ সীহোন কে পাস ক়াসিদ ভেজে। মেরা পৈগ়াম নফ়রত ঔর মুখ়ালফ়ত সে খ়ালী থা। ৱহ যহ থা, ");
INSERT INTO urdgvb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“হমেং অপনে মুল্ক মেং সে গুজ়রনে দেং। হম শাহরাহ পর হী রহেংগে ঔর উসসে ন বাঈং, ন দাঈং তরফ় হটেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","হম খানে ঔর পীনে কী তমাম জ়রূরিযাত কে লিএ মুনাসিব পৈসে দেংগে। হমেং পৈদল অপনে মুল্ক মেং সে গুজ়রনে দেং, ");
INSERT INTO urdgvb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","জিস তরহ সঈর কে বাশিংদোং এসৌ কী ঔলাদ ঔর আর কে রহনেৱালে মোআবিযোং নে হমেং গুজ়রনে দিযা। ক্যোংকি হমারী মনজ়িল দরিযাএ-যরদন কে মগ়রিব মেং হৈ, ৱহ মুল্ক জো রব হমারা খ়ুদা হমেং দেনেৱালা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","লেকিন হসবোন কে বাদশাহ সীহোন নে হমেং গুজ়রনে ন দিযা, ক্যোংকি রব তুম্হারে খ়ুদা নে উসে বে-লচক ঔর হমারী বাত সে ইনকার করনে পর আমাদা কর দিযা থা তাকি সীহোন হমারে ক়াবূ মেং আ জাএ। ঔর বাদ মেং ঐসা হী হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","রব নে মুঝসে কহা, “যোং সমঝ লে কি মৈং সীহোন ঔর উসকে মুল্ক কো তেরে হৱালে করনে লগা হূঁ। অব নিকলকর উস পর ক়ব্জ়া করনা শুরূ করো।” ");
INSERT INTO urdgvb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","জব সীহোন অপনী সারী ফ়ৌজ লেকর হমারা মুক়াবলা করনে কে লিএ যহজ় আযা ");
INSERT INTO urdgvb_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","তো রব হমারে খ়ুদা নে হমেং পূরী ফ়তহ বখ়্শী। হমনে সীহোন, উসকে বেটোং ঔর পূরী ক়ৌম কো শিকস্ত দী। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","উস ৱক়্ত হমনে উসকে তমাম শহরোং পর ক়ব্জ়া কর লিযা ঔর উনকে তমাম মর্দোং, ঔরতোং ঔর বচ্চোং কো মার ডালা। কোঈ ভী ন বচা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","হমনে সির্ফ় মৱেশী ঔর শহরোং কা লূটা হুআ মাল অপনে লিএ বচাএ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ৱাদীএ-অরনোন কে কিনারে পর ৱাক়ে অরোঈর সে লেকর জিলিযাদ তক হর শহর কো শিকস্ত মাননী পড়ী। ইসমেং ৱহ শহর ভী শামিল থা জো ৱাদীএ-অরনোন মেং থা। রব হমারে খ়ুদা নে উন সবকো হমারে হৱালে কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","লেকিন তুমনে অম্মোনিযোং কা মুল্ক ছোড় দিযা ঔর ন দরিযাএ-যব্বোক় কে ইর্দগির্দ কে ইলাক়ে, ন উসকে পহাড়ী ইলাক়ে কে শহরোং কো ছেড়া, ক্যোংকি রব হমারে খ়ুদা নে ঐসা করনে সে তুম্হেং মনা কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ইসকে বাদ হম শিমাল মেং বসন কী তরফ় বঢ় গএ। বসন কা বাদশাহ ওজ অপনী তমাম ফ়ৌজ কে সাথ নিকলকর হমারা মুক়াবলা করনে কে লিএ ইদরঈ আযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","রব নে মুঝসে কহা, “উসসে মত ডর। মৈং উসে, উস কী পূরী ফ়ৌজ ঔর উসকা মুল্ক তেরে হৱালে কর চুকা হূঁ। উসকে সাথ ৱহ কুছ কর জো তূনে অমোরী বাদশাহ সীহোন কে সাথ কিযা জো হসবোন মেং হুকূমত করতা থা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ঐসা হী হুআ। রব হমারে খ়ুদা কী মদদ সে হমনে বসন কে বাদশাহ ওজ ঔর উস কী তমাম ক়ৌম কো শিকস্ত দী। হমনে সবকো হলাক কর দিযা। কোঈ ভী ন বচা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","উসী ৱক়্ত হমনে উসকে তমাম শহরোং পর ক়ব্জ়া কর লিযা। হমনে কুল 60 শহরোং পর যানী অরজূব কে সারে ইলাক়ে পর ক়ব্জ়া কিযা জিস পর ওজ কী হুকূমত থী। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ইন তমাম শহরোং কী হিফ়াজ়ত ঊঁচী ঊঁচী ফ়সীলোং ঔর কুংডেৱালে দরৱাজ়োং সে কী গঈ থী। দেহাত মেং বহুত-সী ঐসী আবাদিযাঁ ভী মিল গঈং জিনকী ফ়সীলেং নহীং থীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","হমনে উনকে সাথ ৱহ কুছ কিযা জো হমনে হসবোন কে বাদশাহ সীহোন কে ইলাক়ে কে সাথ কিযা থা। হমনে সব কুছ রব কে হৱালে করকে হর শহর কো ঔর তমাম মর্দোং, ঔরতোং ঔর বচ্চোং কো হলাক কর ডালা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","হমনে সির্ফ় তমাম মৱেশী ঔর শহরোং কা লূটা হুআ মাল অপনে লিএ বচাএ রখা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","যোং হমনে উস ৱক়্ত অমোরিযোং কে ইন দো বাদশাহোং সে দরিযাএ-যরদন কা মশরিক়ী ইলাক়া ৱাদীএ-অরনোন সে লেকর হরমূন পহাড় তক ছীন লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(সৈদা কে বাশিংদে হরমূন কো সিরযূন কহতে হৈং জবকি অমোরিযোং নে উসকা নাম সনীর রখা)। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","হমনে ওজ বাদশাহ কে পূরে ইলাক়ে পর ক়ব্জ়া কর লিযা। ইসমেং মৈদানে-মুরতফ়া কে তমাম শহর শামিল থে, নীজ় সলকা ঔর ইদরঈ তক জিলিযাদ ঔর বসন কে পূরে ইলাক়ে। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","বাদশাহ ওজ দেৱক়ামত ক়বীলে রফ়াঈ কা আখ়িরী মর্দ থা। উসকা লোহে কা তাবূত 13 সে জ়াযদ ফ়ুট লংবা ঔর ছঃ ফ়ুট চৌড়া থা ঔর আজ তক অম্মোনিযোং কে শহর রব্বা মেং দেখা জা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","জব হমনে দরিযাএ-যরদন কে মশরিক়ী ইলাক়ে পর ক়ব্জ়া কিযা তো মৈংনে রূবিন ঔর জদ কে ক়বীলোং কো উসকা জুনূবী হিস্সা শহরোং সমেত দিযা। ইস ইলাক়ে কী জুনূবী সরহদ দরিযাএ-অরনোন পর ৱাক়ে শহর অরোঈর হৈ জবকি শিমাল মেং ইসমেং জিলিযাদ কে পহাড়ী ইলাক়ে কা আধা হিস্সা ভী শামিল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","জিলিযাদ কা শিমালী হিস্সা ঔর বসন কা মুল্ক মৈংনে মনস্সী কে আধে ক়বীলে কো দিযা। (বসন মেং অরজূব কা ইলাক়া হৈ জহাঁ পহলে ওজ বাদশাহ কী হুকূমত থী ঔর জো রফ়াইযোং যানী দেৱক়ামত অফ়রাদ কা মুল্ক কহলাতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","মনস্সী কে ক়বীলে কে এক আদমী বনাম যাঈর নে অরজূব পর জসূরিযোং ঔর মাকাতিযোং কী সরহদ তক ক়ব্জ়া কর লিযা থা। উসনে ইস ইলাক়ে কী বস্তিযোং কো অপনা নাম দিযা। আজ তক যহী নাম হৱ্ৱোত-যাঈর যানী যাঈর কী বস্তিযাঁ চলতা হৈ।) ");
INSERT INTO urdgvb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","মৈংনে জিলিযাদ কা শিমালী হিস্সা মনস্সী কে কুংবে মকীর কো দিযা ");
INSERT INTO urdgvb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","লেকিন জিলিযাদ কা জুনূবী হিস্সা রূবিন ঔর জদ কে ক়বীলোং কো দিযা। ইস হিস্সে কী এক সরহদ জুনূব মেং ৱাদীএ-অরনোন কে বীচ মেং সে গুজ়রতী হৈ জবকি দূসরী সরহদ দরিযাএ-যব্বোক় হৈ জিসকে পার অম্মোনিযোং কী হুকূমত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","উস কী মগ়রিবী সরহদ দরিযাএ-যরদন হৈ যানী কিন্নরত (গলীল) কী ঝীল সে লেকর বহীরাএ-মুরদার তক জো পিসগা কে পহাড়ী সিলসিলে কে দামন মেং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","উস ৱক়্ত মৈংনে রূবিন, জদ ঔর মনস্সী কে ক়বীলোং সে কহা, “রব তুম্হারে খ়ুদা নে তুম্হেং মীরাস মেং যহ মুল্ক দে দিযা হৈ। লেকিন শর্ত যহ হৈ কি তুম্হারে তমাম জংগ করনে কে ক়াবিল মর্দ মুসল্লহ হোকর তুম্হারে ইসরাঈলী ভাইযোং কে আগে আগে দরিযাএ-যরদন কো পার করেং। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","সির্ফ় তুম্হারী ঔরতেং ঔর বচ্চে পীছে রহকর উন শহরোং মেং ইংতজ়ার কর সকতে হৈং জো মৈংনে তুম্হারে লিএ মুক়র্রর কিএ হৈং। তুম অপনে মৱেশিযোং কো ভী পীছে ছোড় সকতে হো, ক্যোংকি মুঝে পতা হৈ কি তুম্হারে বহুত জ়্যাদা জানৱর হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","অপনে ভাইযোং কে সাথ চলতে হুএ উনকী মদদ করতে রহো। জব রব তুম্হারা খ়ুদা উন্হেং দরিযাএ-যরদন কে মগ়রিব মেং ৱাক়ে মুল্ক দেগা ঔর ৱহ তুম্হারী তরহ আরাম ঔর সুকূন সে ৱহাঁ আবাদ হো জাএংগে তব তুম অপনে মুল্ক মেং ৱাপস জা সকতে হো।” ");
INSERT INTO urdgvb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","সাথ সাথ মৈংনে যশুঅ সে কহা, “তূনে অপনী আঁখোং সে সব কুছ দেখ লিযা হৈ জো রব তুম্হারে খ়ুদা নে ইন দোনোং বাদশাহোং সীহোন ঔর ওজ সে কিযা। ৱহ যহী কুছ হর উস বাদশাহ কে সাথ করেগা জিসকে মুল্ক পর তূ দরিযা কো পার করকে হমলা করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","উনসে ন ডরো। তুম্হারা খ়ুদা খ়ুদ তুম্হারে লিএ জংগ করেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","উস ৱক়্ত মৈংনে রব সে ইল্তিজা করকে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ঐ রব ক়াদিরে-মুতলক়, তূ অপনে খ়াদিম কো অপনী অজ়মত ঔর ক়ুদরত দিখানে লগা হৈ। ক্যা আসমান যা জ়মীন পর কোঈ ঔর খ়ুদা হৈ জো তেরী তরহ কে অজ়ীম কাম কর সকতা হৈ? হরগিজ় নহীং! ");
INSERT INTO urdgvb_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","মেহরবানী করকে মুঝে ভী দরিযাএ-যরদন কো পার করকে উস অচ্ছে মুল্ক যানী উস বেহতরীন পহাড়ী ইলাক়ে কো লুবনান তক দেখনে কী ইজাজ়ত দে।” ");
INSERT INTO urdgvb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","লেকিন তুম্হারে সবব সে রব মুঝসে নারাজ় থা। উসনে মেরী ন সুনী বল্কি কহা, “বস কর! আইংদা মেরে সাথ ইসকা জ়িক্র ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","পিসগা কী চোটী পর চঢ়কর চারোং তরফ় নজ়র দৌড়া। ৱহাঁ সে গ়ৌর সে দেখ, ক্যোংকি তূ খ়ুদ দরিযাএ-যরদন কো উবূর নহীং করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","অপনী জগহ যশুঅ কো মুক়র্রর কর। উস কী হৌসলাঅফ়্জ়াঈ কর ঔর উসে মজ়বূত কর, ক্যোংকি ৱহী ইস ক়ৌম কো দরিযাএ-যরদন কে মগ়রিব মেং লে জাএগা ঔর ক়বীলোং মেং উস মুল্ক কো তক়সীম করেগা জিসে তূ পহাড় সে দেখেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","চুনাঁচে হম বৈত-ফ়গ়ূর কে ক়রীব ৱাদী মেং ঠহরে। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ঐ ইসরাঈল, অব ৱহ তমাম অহকাম ধ্যান সে সুন লে জো মৈং তুম্হেং সিখাতা হূঁ। উন পর অমল করো তাকি তুম জ়িংদা রহো ঔর জাকর উস মুল্ক পর ক়ব্জ়া করো জো রব তুম্হারে বাপদাদা কা খ়ুদা তুম্হেং দেনেৱালা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","জো অহকাম মৈং তুম্হেং সিখাতা হূঁ উনমেং ন কিসী বাত কা ইজ়াফ়া করো ঔর ন উনসে কোঈ বাত নিকালো। রব অপনে খ়ুদা কে তমাম অহকাম পর অমল করো জো মৈংনে তুম্হেং দিএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","তুমনে খ়ুদ দেখা হৈ কি রব নে বাল-ফ়গ়ূর সে ক্যা কুছ কিযা। ৱহাঁ রব তেরে খ়ুদা নে হর এক কো হলাক কর ডালা জিসনে ফ়গ়ূর কে বাল দেৱতা কী পূজা কী। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","লেকিন তুমমেং সে জিতনে রব অপনে খ়ুদা কে সাথ লিপটে রহে ৱহ সব আজ তক জ়িংদা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","মৈংনে তুম্হেং তমাম অহকাম যোং সিখা দিএ হৈং জিস তরহ রব মেরে খ়ুদা নে মুঝে বতাযা। ক্যোংকি লাজ়িম হৈ কি তুম উস মুল্ক মেং ইনকে তাবে রহো জিস পর তুম ক়ব্জ়া করনেৱালে হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ইন্হেং মানো ঔর ইন পর অমল করো তো দূসরী ক়ৌমোং কো তুম্হারী দানিশমংদী ঔর সমঝ নজ়র আএগী। ফির ৱহ ইন তমাম অহকাম কে বারে মেং সুনকর কহেংগী, “ৱাহ, যহ অজ়ীম ক়ৌম কৈসী দানিশমংদ ঔর সমঝদার হৈ!” ");
INSERT INTO urdgvb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","কৌন-সী অজ়ীম ক়ৌম কে মাবূদ ইতনে ক়রীব হৈং জিতনা হমারা খ়ুদা হমারে ক়রীব হৈ? জব ভী হম মদদ কে লিএ পুকারতে হৈং তো রব হমারা খ়ুদা মৌজূদ হোতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","কৌন-সী অজ়ীম ক়ৌম কে পাস ঐসে মুংসিফ়ানা অহকাম ঔর হিদাযাত হৈং জৈসে মৈং আজ তুম্হেং পূরী শরীঅত সুনাকর পেশ কর রহা হূঁ? ");
INSERT INTO urdgvb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","লেকিন খ়বরদার, এহতিযাত করনা ঔর ৱহ তমাম বাতেং ন ভূলনা জো তেরী আঁখোং নে দেখী হৈং। ৱহ উম্র-ভর তেরে দিল মেং সে মিট ন জাএঁ বল্কি উন্হেং অপনে বচ্চোং ঔর পোতে-পোতিযোং কো ভী বতাতে রহনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ৱহ দিন যাদ কর জব তূ হোরিব যানী সীনা পহাড় পর রব অপনে খ়ুদা কে সামনে হাজ়ির থা ঔর উসনে মুঝে বতাযা, “ক়ৌম কো যহাঁ মেরে পাস জমা কর তাকি মৈং উনসে বাত করূঁ ঔর ৱহ উম্র-ভর মেরা খ়ৌফ় মানেং ঔর অপনে বচ্চোং কো মেরী বাতেং সিখাতে রহেং।” ");
INSERT INTO urdgvb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","উস ৱক়্ত তুম ক়রীব আকর পহাড় কে দামন মেং খড়ে হুএ। ৱহ জল রহা থা, ঔর উস কী আগ আসমান তক ভড়ক রহী থী জবকি কালে বাদলোং ঔর গহরে অংধেরে নে উসে নজ়রোং সে ছুপা দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ফির রব আগ মেং সে তুমসে হমকলাম হুআ। তুমনে উস কী বাতেং সুনীং লেকিন উস কী কোঈ শক্ল ন দেখী। সির্ফ় উস কী আৱাজ় সুনাঈ দী। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","উসনে তুম্হারে লিএ অপনে অহদ যানী উন 10 অহকাম কা এলান কিযা ঔর হুক্ম দিযা কি ইন পর অমল করো। ফির উসনে উন্হেং পত্থর কী দো তখ়্তিযোং পর লিখ দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","রব নে মুঝে হিদাযত কী, “উন্হেং ৱহ তমাম অহকাম সিখা জিনকে মুতাবিক় উন্হেং চলনা হোগা জব ৱহ দরিযাএ-যরদন কো পার করকে কনান পর ক়ব্জ়া করেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","জব রব হোরিব যানী সীনা পহাড় পর তুমসে হমকলাম হুআ তো তুমনে উস কী কোঈ শক্ল ন দেখী। চুনাঁচে খ়বরদার রহো ");
INSERT INTO urdgvb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","কি তুম গ়লত কাম করকে অপনে লিএ কিসী ভী শক্ল কা বুত ন বনাও। ন মর্দ, ঔরত, ");
INSERT INTO urdgvb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","জ়মীন পর চলনেৱালে জানৱর, পরিংদে, ");
INSERT INTO urdgvb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","রেংগনেৱালে জানৱর যা মছলী কা বুত বনাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","জব তূ আসমান কী তরফ় নজ়র উঠাকর আসমান কা পূরা লশকর দেখে তো সূরজ, চাঁদ ঔর সিতারোং কী পরস্তিশ ঔর খ়িদমত করনে কী আজ়মাইশ মেং ন পড়না। রব তেরে খ়ুদা নে ইন চীজ়োং কো বাক়ী তমাম ক়ৌমোং কো অতা কিযা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","লেকিন তুম্হেং উসনে মিসর কে ভড়কতে ভট্টে সে নিকালা হৈ তাকি তুম উস কী অপনী ক়ৌম ঔর উস কী মীরাস বন জাও। ঔর আজ ঐসা হী হুআ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","তুম্হারে সবব সে রব নে মুঝসে নারাজ় হোকর ক়সম খাঈ কি তূ দরিযাএ-যরদন কো পার করকে উস অচ্ছে মুল্ক মেং দাখ়িল নহীং হোগা জো রব তেরা খ়ুদা তুঝে মীরাস মেং দেনেৱালা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","মৈং যহীং ইসী মুল্ক মেং মর জাঊঁগা ঔর দরিযাএ-যরদন কো পার নহীং করূঁগা। লেকিন তুম দরিযা কো পার করকে উস বেহতরীন মুল্ক পর ক়ব্জ়া করোগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","হর সূরত মেং ৱহ অহদ যাদ রখনা জো রব তুম্হারে খ়ুদা নে তুম্হারে সাথ বাঁধা হৈ। অপনে লিএ কিসী ভী চীজ় কী মূরত ন বনানা। যহ রব কা হুক্ম হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ক্যোংকি রব তেরা খ়ুদা ভস্ম কর দেনেৱালী আগ হৈ, ৱহ গ়যূর খ়ুদা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","তুম মুল্ক মেং জাকর ৱহাঁ রহোগে। তুম্হারে বচ্চে ঔর পোতে-নৱাসে উসমেং পৈদা হো জাএংগে। জব ইস তরহ বহুত ৱক়্ত গুজ়র জাএগা তো খ়তরা হৈ কি তুম গ়লত কাম করকে কিসী চীজ় কী মূরত বনাও। ঐসা কভী ন করনা। যহ রব তুম্হারে খ়ুদা কী নজ়র মেং বুরা হৈ ঔর উসে গ়ুস্সা দিলাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","আজ আসমান ঔর জ়মীন মেরে গৱাহ হৈং কি অগর তুম ঐসা করো তো জল্দী সে উস মুল্ক মেং সে মিট জাওগে জিস পর তুম দরিযাএ-যরদন কো পার করকে ক়ব্জ়া করোগে। তুম দের তক ৱহাঁ জীতে নহীং রহোগে বল্কি পূরে তৌর পর হলাক হো জাওগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","রব তুম্হেং মুল্ক সে নিকালকর মুখ়্তলিফ় ক়ৌমোং মেং মুংতশির কর দেগা, ঔর ৱহাঁ সির্ফ় থোড়ে হী অফ়রাদ বচে রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ৱহাঁ তুম ইনসান কে হাথোং সে বনে হুএ লকড়ী ঔর পত্থর কে বুতোং কী খ়িদমত করোগে, জো ন দেখ সকতে, ন সুন সকতে, ন খা সকতে ঔর ন সূঁঘ সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ৱহীং তূ রব অপনে খ়ুদা কো তলাশ করেগা, ঔর অগর উসে পূরে দিলো-জান সে ঢূঁডে তো ৱহ তুঝে মিল ভী জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","জব তূ ইস তকলীফ় মেং মুব্তলা হোগা ঔর যহ সারা কুছ তুঝ পর সে গুজ়রেগা ফির আখ়িরকার রব অপনে খ়ুদা কী তরফ় রুজূ করকে উস কী সুনেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ক্যোংকি রব তেরা খ়ুদা রহীম খ়ুদা হৈ। ৱহ তুঝে ন তর্ক করেগা ঔর ন বরবাদ করেগা। ৱহ উস অহদ কো নহীং ভূলেগা জো উসনে ক়সম খাকর তেরে বাপদাদা সে বাঁধা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","দুনিযা মেং ইনসান কী তখ়লীক় সে লেকর আজ তক মাজ়ী কী তফ়তীশ কর। আসমান কে এক সিরে সে দূসরে সিরে তক খোজ লগা। ক্যা ইসসে পহলে কভী ইস তরহ কা মোজিজ়ানা কাম হুআ হৈ? ক্যা কিসী নে ইসসে পহলে ইস ক়িস্ম কে অজ়ীম কাম কী খ়বর সুনী হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","তূনে আগ মেং সে বোলতী হুঈ অল্লাহ কী আৱাজ় সুনী তো ভী জীতা বচা! ক্যা কিসী ঔর ক়ৌম কে সাথ ঐসা হুআ হৈ? ");
INSERT INTO urdgvb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ক্যা কিসী ঔর মাবূদ নে কভী জুর্রত কী হৈ কি রব কী তরহ পূরী ক়ৌম কো এক মুল্ক সে নিকালকর অপনী মিলকিযত বনাযা হো? উসনে ঐসা হী তুম্হারে সাথ কিযা। উসনে তুম্হারে দেখতে দেখতে মিসরিযোং কো আজ়মাযা, উন্হেং বড়ে মোজিজ়ে দিখাএ, উনকে সাথ জংগ কী, অপনী বড়ী ক়ুদরত ঔর ইখ়্তিযার কা ইজ়হার কিযা ঔর হৌলনাক কামোং সে উন পর গ়ালিব আ গযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","তুঝে যহ সব কুছ দিখাযা গযা তাকি তূ জান লে কি রব খ়ুদা হৈ। উসকে সিৱা কোঈ ঔর নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","উসনে তুঝে নসীহত দেনে কে লিএ আসমান সে অপনী আৱাজ় সুনাঈ। জ়মীন পর উসনে তুঝে অপনী অজ়ীম আগ দিখাঈ জিসমেং সে তূনে উস কী বাতেং সুনীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","উসে তেরে বাপদাদা সে প্যার থা, ঔর উসনে তুঝে জো উনকী ঔলাদ হৈং চুন লিযা। ইসলিএ ৱহ খ়ুদ হাজ়ির হোকর অপনী অজ়ীম ক়ুদরত সে তুঝে মিসর সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","উসনে তেরে আগে সে তুঝসে জ়্যাদা বড়ী ঔর তাক়তৱর ক়ৌমেং নিকাল দীং তাকি তুঝে উনকা মুল্ক মীরাস মেং মিল জাএ। আজ ঐসা হী হো রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","চুনাঁচে আজ জান লে ঔর জ়হন মেং রখ কি রব আসমান ঔর জ়মীন কা খ়ুদা হৈ। কোঈ ঔর মাবূদ নহীং হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","উসকে অহকাম পর অমল কর জো মৈং তুঝে আজ সুনা রহা হূঁ। ফির তূ ঔর তেরী ঔলাদ কামযাব হোংগে, ঔর তূ দের তক উস মুল্ক মেং জীতা রহেগা জো রব তুঝে হমেশা কে লিএ দে রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","যহ কহকর মূসা নে দরিযাএ-যরদন কে মশরিক় মেং পনাহ কে তীন শহর চুন লিএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","উনমেং ৱহ শখ়্স পনাহ লে সকতা থা জিসনে দুশ্মনী কী বিনা পর নহীং বল্কি গ়ৈরইরাদী তৌর পর কিসী কো জান সে মার দিযা থা। ঐসে শহর মেং পনাহ লেনে কে সবব সে উসে বদলে মেং ক়ত্ল নহীং কিযা জা সকতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ইসকে লিএ রূবিন কে ক়বীলে কে লিএ মৈদানে-মুরতফ়া কা শহর বসর, জদ কে ক়বীলে কে লিএ জিলিযাদ কা শহর রামাত ঔর মনস্সী কে ক়বীলে কে লিএ বসন কা শহর জৌলান চুনা গযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","দর্জে-জ়ৈল ৱহ শরীঅত হৈ জো মূসা নে ইসরাঈলিযোং কো পেশ কী। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","মূসা নে যহ অহকাম ঔর হিদাযাত উস ৱক়্ত পেশ কীং জব ৱহ মিসর সে নিকল কর ");
INSERT INTO urdgvb_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","দরিযাএ-যরদন কে মশরিক়ী কিনারে পর থে। বৈত-ফ়গ়ূর উনকে মুক়াবিল থা, ঔর ৱহ অমোরী বাদশাহ সীহোন কে মুল্ক মেং খ়ৈমাজ়ন থে। সীহোন কী রিহাইশ হসবোন মেং থী ঔর উসে ইসরাঈলিযোং সে শিকস্ত হুঈ থী জব ৱহ মূসা কী রাহনুমাঈ মেং মিসর সে নিকল আএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","উসকে মুল্ক পর ক়ব্জ়া করকে উন্হোংনে বসন কে মুল্ক পর ভী ফ়তহ পাঈ থী জিসকা বাদশাহ ওজ থা। ইন দোনোং অমোরী বাদশাহোং কা যহ পূরা ইলাক়া উনকে হাথ মেং আ গযা থা। যহ ইলাক়া দরিযাএ-যরদন কে মশরিক় মেং থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","উস কী জুনূবী সরহদ দরিযাএ-অরনোন কে কিনারে পর ৱাক়ে শহর অরোঈর থী জবকি উস কী শিমালী সরহদ সিরযূন যানী হরমূন পহাড় থী। ");
INSERT INTO urdgvb_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","দরিযাএ-যরদন কা পূরা মশরিক়ী কিনারা পিসগা কে পহাড়ী সিলসিলে কে দামন মেং ৱাক়ে বহীরাএ-মুরদার তক উসমেং শামিল থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","মূসা নে তমাম ইসরাঈলিযোং কো জমা করকে কহা, ঐ ইসরাঈল, ধ্যান সে ৱহ হিদাযাত ঔর অহকাম সুন জো মৈং তুম্হেং আজ পেশ কর রহা হূঁ। উন্হেং সীখো ঔর বড়ী এহতিযাত সে উন পর অমল করো। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","রব হমারে খ়ুদা নে হোরিব যানী সীনা পহাড় পর হমারে সাথ অহদ বাঁধা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","উসনে যহ অহদ হমারে বাপদাদা কে সাথ নহীং বল্কি হমারে হী সাথ বাঁধা হৈ, জো আজ ইস জগহ পর জ়িংদা হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","রব পহাড় পর আগ মেং সে রূবরূ হোকর তুমসে হমকলাম হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","উস ৱক়্ত মৈং তুম্হারে ঔর রব কে দরমিযান খড়া হুআ তাকি তুম্হেং রব কী বাতেং সুনাঊঁ। ক্যোংকি তুম আগ সে ডরতে থে ঔর ইসলিএ পহাড় পর ন চঢ়ে। উস ৱক়্ত রব নে কহা, ");
INSERT INTO urdgvb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“মৈং রব তেরা খ়ুদা হূঁ জো তুঝে মুল্কে-মিসর কী গ়ুলামী সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","মেরে সিৱা কিসী ঔর মাবূদ কী পরস্তিশ ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","অপনে লিএ বুত ন বনানা। কিসী ভী চীজ় কী মূরত ন বনানা, চাহে ৱহ আসমান মেং, জ়মীন পর যা সমুংদর মেং হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ন বুতোং কী পরস্তিশ, ন উনকী খ়িদমত করনা, ক্যোংকি মৈং তেরা রব গ়যূর খ়ুদা হূঁ। জো মুঝসে নফ়রত করতে হৈং উন্হেং মৈং তীসরী ঔর চৌথী পুশ্ত তক সজ়া দূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","লেকিন জো মুঝসে মুহব্বত রখতে ঔর মেরে অহকাম পূরে করতে হৈং উন পর মৈং হজ়ার পুশ্তোং তক মেহরবানী করূঁগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","রব অপনে খ়ুদা কা নাম বেমক়সদ যা গ়লত মক়সদ কে লিএ ইস্তেমাল ন করনা। জো ভী ঐসা করতা হৈ উসে রব সজ়া দিএ বগ়ৈর নহীং ছোড়েগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","সবত কে দিন কা খ়যাল রখনা। উসে ইস তরহ মনানা কি ৱহ মখ়সূসো-মুক়দ্দস হো, উসী তরহ জিস তরহ রব তেরে খ়ুদা নে তুঝে হুক্ম দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","হফ়তে কে পহলে ছঃ দিন অপনা কাম-কাজ কর, ");
INSERT INTO urdgvb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","লেকিন সাতৱাঁ দিন রব তেরে খ়ুদা কা আরাম কা দিন হৈ। উস দিন কিসী তরহ কা কাম ন করনা। ন তূ, ন তেরা বেটা, ন তেরী বেটী, ন তেরা নৌকর, ন তেরী নৌকরানী, ন তেরা বৈল, ন তেরা গধা, ন তেরা কোঈ ঔর মৱেশী। জো পরদেসী তেরে দরমিযান রহতা হৈ ৱহ ভী কাম ন করে। তেরে নৌকর ঔর তেরী নৌকরানী কো তেরী তরহ আরাম কা মৌক়া মিলনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","যাদ রখনা কি তূ মিসর মেং গ়ুলাম থা ঔর কি রব তেরা খ়ুদা হী তুঝে বড়ী ক়ুদরত ঔর ইখ়্তিযার সে ৱহাঁ সে নিকাল লাযা। ইসলিএ উসনে তুঝে হুক্ম দিযা হৈ কি সবত কা দিন মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","অপনে বাপ ঔর অপনী মাঁ কী ইজ়্জ়ত করনা জিস তরহ রব তেরে খ়ুদা নে তুঝে হুক্ম দিযা হৈ। ফির তূ উস মুল্ক মেং জো রব তেরা খ়ুদা তুঝে দেনেৱালা হৈ খ়ুশহাল হোগা ঔর দের তক জীতা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","ক়ত্ল ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","জ়িনা ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","চোরী ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","অপনে পড়োসী কে বারে মেং ঝূটী গৱাহী ন দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","অপনে পড়োসী কী বীৱী কা লালচ ন করনা। ন উসকে ঘর কা, ন উস কী জ়মীন কা, ন উসকে নৌকর কা, ন উস কী নৌকরানী কা, ন উসকে বৈল ঔর ন উসকে গধে কা বল্কি উস কী কিসী ভী চীজ় কা লালচ ন করনা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","রব নে তুম সবকো যহ অহকাম দিএ জব তুম সীনা পহাড় কে দামন মেং জমা থে। ৱহাঁ তুমনে আগ, বাদল ঔর গহরে অংধেরে মেং সে উস কী জ়োরদার আৱাজ় সুনী। যহী কুছ উসনে কহা ঔর বস। ফির উসনে উন্হেং পত্থর কী দো তখ়্তিযোং পর লিখকর মুঝে দে দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","জব তুমনে তারীকী সে যহ আৱাজ় সুনী ঔর পহাড় কী জলতী হুঈ হালত দেখী তো তুম্হারে ক়বীলোং কে রাহনুমা ঔর বুজ়ুর্গ মেরে পাস আএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","উন্হোংনে কহা, “রব হমারে খ়ুদা নে হম পর অপনা জলাল ঔর অজ়মত জ়াহির কী হৈ। আজ হমনে আগ মেং সে উস কী আৱাজ় সুনী হৈ। হমনে দেখ লিযা হৈ কি জব অল্লাহ ইনসান সে হমকলাম হোতা হৈ তো জ়রূরী নহীং কি ৱহ মর জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","লেকিন অব হম ক্যোং অপনী জান খ়তরে মেং ডালেং? অগর হম মজ়ীদ রব অপনে খ়ুদা কী আৱাজ় সুনেং তো যহ বড়ী আগ হমেং ভস্ম কর দেগী ঔর হম অপনী জান সে হাথ ধো বৈঠেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ক্যোংকি ফ়ানী ইনসানোং মেং সে কৌন হমারী তরহ জ়িংদা খ়ুদা কো আগ মেং সে বাতেং করতে হুএ সুনকর জ়িংদা রহা হৈ? কোঈ ভী নহীং! ");
INSERT INTO urdgvb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","আপ হী ক়রীব জাকর উন তমাম বাতোং কো সুনেং জো রব হমারা খ়ুদা হমেং বতানা চাহতা হৈ। ফির লৌটকর হমেং ৱহ বাতেং সুনাএঁ। হম উন্হেং সুনেংগে ঔর উন পর অমল করেংগে।” ");
INSERT INTO urdgvb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","জব রব নে যহ সুনা তো উসনে মুঝসে কহা, “মৈংনে ইন লোগোং কী যহ বাতেং সুন লী হৈং। ৱহ ঠীক কহতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","কাশ উনকী সোচ হমেশা ঐসী হী হো! কাশ ৱহ হমেশা ইসী তরহ মেরা খ়ৌফ় মানেং ঔর মেরে অহকাম পর অমল করেং! অগর ৱহ ঐসা করেংগে তো ৱহ ঔর উনকী ঔলাদ হমেশা কামযাব রহেংগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","জা, উন্হেং বতা দে কি অপনে খ়ৈমোং মেং লৌট জাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","লেকিন তূ যহাঁ মেরে পাস রহ তাকি মৈং তুঝে তমাম ক়ৱানীন ঔর অহকাম দে দূঁ। উনকো লোগোং কো সিখানা তাকি ৱহ উস মুল্ক মেং উনকে মুতাবিক় চলেং জো মৈং উন্হেং দূঁগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","চুনাঁচে এহতিযাত সে উন অহকাম পর অমল করো জো রব তুম্হারে খ়ুদা নে তুম্হেং দিএ হৈং। উনসে ন দাঈং তরফ় হটো ন বাঈং তরফ়। ");
INSERT INTO urdgvb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","হমেশা উস রাহ পর চলতে রহো জো রব তুম্হারে খ়ুদা নে তুম্হেং বতাঈ হৈ। ফির তুম কামযাব হোগে ঔর উস মুল্ক মেং দের তক জীতে রহোগে জিস পর তুম ক়ব্জ়া করোগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","যহ ৱহ তমাম অহকাম হৈং জো রব তুম্হারে খ়ুদা নে মুঝে তুম্হেং সিখানে কে লিএ কহা। উস মুল্ক মেং ইন পর অমল করনা জিসমেং তুম জানেৱালে হো তাকি উস পর ক়ব্জ়া করো। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","উম্র-ভর তূ, তেরে বচ্চে ঔর পোতে-নৱাসে রব অপনে খ়ুদা কা খ়ৌফ় মানেং ঔর উসকে উন তমাম অহকাম পর চলেং জো মৈং তুঝে দে রহা হূঁ। তব তূ দের তক জীতা রহেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ঐ ইসরাঈল, যহ মেরী বাতেং সুন ঔর বড়ী এহতিযাত সে ইন পর অমল কর! ফির রব তেরে খ়ুদা কা ৱাদা পূরা হো জাএগা কি তূ কামযাব রহেগা ঔর তেরী তাদাদ উস মুল্ক মেং খ়ূব বঢ়তী জাএগী জিসমেং দূধ ঔর শহদ কী কসরত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","সুন ঐ ইসরাঈল! রব হমারা খ়ুদা এক হী রব হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","রব অপনে খ়ুদা সে অপনে পূরে দিল, অপনী পূরী জান ঔর অপনী পূরী তাক়ত সে প্যার করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","জো অহকাম মৈং তুঝে আজ বতা রহা হূঁ উন্হেং অপনে দিল পর নক়্শ কর। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","উন্হেং অপনে বচ্চোং কে জ়হননশীন করা। যহী বাতেং হর ৱক়্ত ঔর হর জগহ তেরে লবোং পর হোং খ়াহ তূ ঘর মেং বৈঠা যা রাস্তে পর চলতা হো, লেটা হো যা খড়া হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","উন্হেং নিশান কে তৌর পর ঔর যাদদিহানী কে লিএ অপনে বাজ়ুওং ঔর মাথে পর লগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","উন্হেং অপনে ঘরোং কী চৌখটোং ঔর অপনে শহরোং কে দরৱাজ়োং পর লিখ। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","রব তেরে খ়ুদা কা ৱাদা পূরা হোগা জো উসনে ক়সম খাকর তেরে বাপদাদা ইব্রাহীম, ইসহাক় ঔর যাক়ূব কে সাথ কিযা কি মৈং তুঝে কনান মেং লে জাঊঁগা। জো বড়ে ঔর শানদার শহর উসমেং হৈং ৱহ তূনে খ়ুদ নহীং বনাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","জো মকান উসমেং হৈং ৱহ ঐসী অচ্ছী চীজ়োং সে ভরে হুএ হৈং জো তূনে উনমেং নহীং রখীং। জো কুএঁ উসমেং হৈং উনকো তূনে নহীং খোদা। জো অংগূর ঔর জ়ৈতূন কে বাগ় উসমেং হৈং উন্হেং তূনে নহীং লগাযা। যহ হক়ীক়ত যাদ রখ। জব তূ উস মুল্ক মেং কসরত কা খানা খাকর সের হো জাএগা ");
INSERT INTO urdgvb_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","তো খ়বরদার! রব কো ন ভূলনা জো তুঝে মিসর কী গ়ুলামী সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","রব অপনে খ়ুদা কা খ়ৌফ় মাননা। সির্ফ় উসী কী ইবাদত করনা ঔর উসী কা নাম লেকর ক়সম খানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","দীগর মাবূদোং কী পৈরৱী ন করনা। ইসমেং তমাম পড়োসী অক়ৱাম কে দেৱতা ভী শামিল হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ৱরনা রব তেরে খ়ুদা কা গ়জ়ব তুঝ পর নাজ়িল হোকর তুঝে মুল্ক মেং সে মিটা ডালেগা। ক্যোংকি ৱহ গ়যূর খ়ুদা হৈ ঔর তেরে দরমিযান হী রহতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","রব অপনে খ়ুদা কো উস তরহ ন আজ়মানা জিস তরহ তুমনে মস্সা মেং কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ধ্যান সে রব অপনে খ়ুদা কে অহকাম কে মুতাবিক় চলো, উন তমাম হিদাযাত ঔর ক়ৱানীন পর জো উসনে তুঝে দিএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","জো কুছ রব কী নজ়র মেং দুরুস্ত ঔর অচ্ছা হৈ ৱহ কর। ফির তূ কামযাব রহেগা, তূ জাকর উস অচ্ছে মুল্ক পর ক়ব্জ়া করেগা জিসকা ৱাদা রব নে তেরে বাপদাদা সে ক়সম খাকর কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","তব রব কী বাত পূরী হো জাএগী কি তূ অপনে দুশ্মনোং কো অপনে আগে আগে নিকাল দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","আনেৱালে দিনোং মেং তেরে বচ্চে পূছেংগে, “রব হমারে খ়ুদা নে আপকো ইন তমাম অহকাম পর অমল করনে কো ক্যোং কহা?” ");
INSERT INTO urdgvb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ফির উন্হেং জৱাব দেনা, “হম মিসর কে বাদশাহ ফ়িরৌন কে গ়ুলাম থে, লেকিন রব হমেং বড়ী ক়ুদরত কা ইজ়হার করকে মিসর সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","হমারে দেখতে দেখতে উসনে বড়ে বড়ে নিশান ঔর মোজিজ়ে কিএ ঔর মিসর, ফ়িরৌন ঔর উসকে পূরে ঘরানে পর হৌলনাক মুসীবতেং ভেজীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","উস ৱক়্ত ৱহ হমেং ৱহাঁ সে নিকাল লাযা তাকি হমেং লেকর ৱহ মুল্ক দে জিসকা ৱাদা উসনে ক়সম খাকর হমারে বাপদাদা কে সাথ কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","রব হমারে খ়ুদা হী নে হমেং কহা কি ইন তমাম অহকাম কে মুতাবিক় চলো ঔর রব অপনে খ়ুদা কা খ়ৌফ় মানো। ক্যোংকি অগর হম ঐসা করেং তো ফির হম হমেশা কামযাব ঔর জ়িংদা রহেংগে। ঔর আজ তক ঐসা হী রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","অগর হম রব অপনে খ়ুদা কে হুজ়ূর রহকর এহতিযাত সে উন তমাম বাতোং পর অমল করেংগে জো উসনে হমেং করনে কো কহী হৈং তো ৱহ হমেং রাস্তবাজ় ক়রার দেগা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","রব তেরা খ়ুদা তুঝে উস মুল্ক মেং লে জাএগা জিস পর তূ জাকর ক়ব্জ়া করেগা। ৱহ তেরে সামনে সে বহুত-সী ক়ৌমেং ভগা দেগা। গো যহ সাত ক়ৌমেং যানী হিত্তী, জিরজাসী, অমোরী, কনানী, ফ়রিজ়্জ়ী, হিৱ্ৱী ঔর যবূসী তাদাদ ঔর তাক়ত কে লিহাজ় সে তুঝসে বড়ী হোংগী ");
INSERT INTO urdgvb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","তো ভী রব তেরা খ়ুদা উন্হেং তেরে হৱালে করেগা। জব তূ উন্হেং শিকস্ত দেগা তো উন সবকো উসকে লিএ মখ়সূস করকে হলাক কর দেনা হৈ। ন উনকে সাথ অহদ বাঁধনা ঔর ন উন পর রহম করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","উনমেং সে কিসী সে শাদী ন করনা। ন অপনী বেটিযোং কা রিশ্তা উনকে বেটোং কো দেনা, ন অপনে বেটোং কা রিশ্তা উনকী বেটিযোং সে করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ৱরনা ৱহ তুম্হারে বচ্চোং কো মেরী পৈরৱী সে দূর করেংগে ঔর ৱহ মেরী নহীং বল্কি উনকে দেৱতাওং কী খ়িদমত করেংগে। তব রব কা গ়জ়ব তুম পর নাজ়িল হোকর জল্দী সে তুম্হেং হলাক কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ইসলিএ উনকী ক়ুরবানগাহেং ঢা দেনা। জিন পত্থরোং কী ৱহ পূজা করতে হৈং উন্হেং চকনাচূর কর দেনা, উনকে যসীরত দেৱী কে খংবে কাট ডালনা ঔর উনকে বুত জলা দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ক্যোংকি তূ রব অপনে খ়ুদা কে লিএ মখ়সূসো-মুক়দ্দস হৈ। উসনে দুনিযা কী তমাম ক়ৌমোং মেং সে তুঝে চুনকর অপনী ক়ৌম ঔর খ়াস মিলকিযত বনাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","রব নে ক্যোং তুম্হারে সাথ তাল্লুক় ক়াযম কিযা ঔর তুম্হেং চুন লিযা? ক্যা ইস ৱজহ সে কি তুম তাদাদ মেং দীগর ক়ৌমোং কী নিসবত জ়্যাদা থে? হরগিজ় নহীং! তুম তো বহুত কম থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","বল্কি ৱজহ যহ থী কি রব নে তুম্হেং প্যার কিযা ঔর ৱহ ৱাদা পূরা কিযা জো উসনে ক়সম খাকর তুম্হারে বাপদাদা কে সাথ কিযা থা। ইসী লিএ ৱহ ফ়িদ্যা দেকর তুম্হেং বড়ী ক়ুদরত সে মিসর কী গ়ুলামী ঔর উস মুল্ক কে বাদশাহ কে হাথ সে বচা লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","চুনাঁচে জান লে কি সির্ফ় রব তেরা খ়ুদা হী খ়ুদা হৈ। ৱহ ৱফ়াদার খ়ুদা হৈ। জো উসসে মুহব্বত রখতে ঔর উসকে অহকাম পর অমল করতে হৈং উনকে সাথ ৱহ অপনা অহদ ক়াযম রখেগা ঔর উন পর হজ়ার পুশ্তোং তক মেহরবানী করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","লেকিন উসসে নফ়রত করনেৱালোং কো ৱহ উনকে রূবরূ মুনাসিব সজ়া দেকর বরবাদ করেগা। হাঁ, জো উসসে নফ়রত করতে হৈং, উনকে রূবরূ ৱহ মুনাসিব সজ়া দেগা ঔর ঝিজকেগা নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","চুনাঁচে ধ্যান সে উন তমাম অহকাম পর অমল কর জো মৈং আজ তুঝে দে রহা হূঁ তাকি তূ উনকে মুতাবিক় জ়িংদগী গুজ়ারে। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","অগর তূ উন পর তৱজ্জুহ দে ঔর এহতিযাত সে উন পর চলে তো ফির রব তেরা খ়ুদা তেরে সাথ অপনা অহদ ক়াযম রখেগা ঔর তুঝ পর মেহরবানী করেগা, বিলকুল উস ৱাদে কে মুতাবিক় জো উসনে ক়সম খাকর তেরে বাপদাদা সে কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ৱহ তুঝে প্যার করেগা ঔর তুঝে উস মুল্ক মেং বরকত দেগা জো তুঝে দেনে কা ৱাদা উসনে ক়সম খাকর তেরে বাপদাদা সে কিযা থা। তুঝে বহুত ঔলাদ বখ়্শনে কে অলাৱা ৱহ তেরে খেতোং কো বরকত দেগা, ঔর তুঝে কসরত কা অনাজ, অংগূর ঔর জ়ৈতূন হাসিল হোগা। ৱহ তেরে রেৱড়োং কো ভী বরকত দেগা, ঔর তেরে গায-বৈলোং ঔর ভেড়-বকরিযোং কী তাদাদ বঢ়তী জাএগী। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","তুঝে দীগর তমাম ক়ৌমোং কী নিসবত কহীং জ়্যাদা বরকত মিলেগী। ন তুঝমেং ঔর ন তেরে মৱেশিযোং মেং বাঁঝপন পাযা জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","রব হর বীমারী কো তুঝসে দূর রখেগা। ৱহ তুঝমেং ৱহ খ়তরনাক ৱবাএঁ ফৈলনে নহীং দেগা জিনসে তূ মিসর মেং ৱাক়িফ় হুআ বল্কি উন্হেং উনমেং ফৈলাএগা জো তুঝসে নফ়রত রখতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","জো ভী ক়ৌমেং রব তেরা খ়ুদা তেরে হাথ মেং কর দেগা উন্হেং তবাহ করনা লাজ়িম হৈ। উন পর রহম কী নিগাহ সে ন দেখনা, ন উনকে দেৱতাওং কী খ়িদমত করনা, ৱরনা তূ ফঁস জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","গো তেরা দিল কহে, “যহ ক়ৌমেং হমসে তাক়তৱর হৈং। হম কিস তরহ ইন্হেং নিকাল সকতে হৈং?” ");
INSERT INTO urdgvb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","তো ভী উনসে ন ডর। ৱহী কুছ জ়হন মেং রখ জো রব তেরে খ়ুদা নে ফ়িরৌন ঔর পূরে মিসর কে সাথ কিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ক্যোংকি তূনে অপনী আঁখোং সে রব অপনে খ়ুদা কী ৱহ বড়ী আজ়মানেৱালী মুসীবতেং ঔর মোজিজ়ে, উসকা ৱহ অজ়ীম ইখ়্তিযার ঔর ক়ুদরত দেখী জিসসে ৱহ তুঝে ৱহাঁ সে নিকাল লাযা। ৱহী কুছ রব তেরা খ়ুদা উন ক়ৌমোং কে সাথ ভী করেগা জিনসে তূ ইস ৱক়্ত ডরতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ন সির্ফ় যহ বল্কি রব তেরা খ়ুদা উনকে দরমিযান জ়ংবূর ভী ভেজেগা তাকি ৱহ ভী তবাহ হো জাএঁ জো পহলে হমলোং সে বচকর ছুপ গএ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","উনসে দহশত ন খা, ক্যোংকি রব তেরা খ়ুদা তেরে দরমিযান হৈ। ৱহ অজ়ীম খ়ুদা হৈ জিসসে সব খ়ৌফ় খাতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ৱহ রফ়্তা রফ়্তা উন ক়ৌমোং কো তেরে আগে সে ভগা দেগা। তূ উন্হেং একদম খ়ত্ম নহীং কর সকেগা, ৱরনা জংগলী জানৱর তেজ়ী সে বঢ়কর তুঝে নুক়সান পহুচাএঁগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","রব তেরা খ়ুদা উন্হেং তেরে হৱালে কর দেগা। ৱহ উনমেং ইতনী সখ়্ত অফ়রা-তফ়রী পৈদা করেগা কি ৱহ বরবাদ হো জাএংগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ৱহ উনকে বাদশাহোং কো ভী তেরে ক়াবূ মেং কর দেগা, ঔর তূ উনকা নামো-নিশান মিটা দেগা। কোঈ ভী তেরা সামনা নহীং কর সকেগা বল্কি তূ উন সবকো বরবাদ কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","উনকে দেৱতাওং কে মুজস্সমে জলা দেনা। জো চাঁদী ঔর সোনা উন পর চঢ়াযা হুআ হৈ উসকা লালচ ন করনা। উসে ন লেনা ৱরনা তূ ফঁস জাএগা। ক্যোংকি ইন চীজ়োং সে রব তেরে খ়ুদা কো ঘিন আতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ইস তরহ কী মকরূহ চীজ় অপনে ঘর মেং ন লানা, ৱরনা তুঝে ভী উসকে সাথ অলগ করকে বরবাদ কিযা জাএগা। তেরে দিল মেং উসসে শদীদ নফ়রত ঔর ঘিন হো, ক্যোংকি উসে পূরে তৌর পর বরবাদ করনে কে লিএ মখ়সূস কিযা গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","এহতিযাত সে উন তমাম অহকাম পর অমল করো জো মৈং আজ তুঝে দে রহা হূঁ। ক্যোংকি ঐসা করনে সে তুম জীতে রহোগে, তাদাদ মেং বঢ়োগে ঔর জাকর উস মুল্ক পর ক়ব্জ়া করোগে জিসকা ৱাদা রব নে তুম্হারে বাপদাদা সে ক়সম খাকর কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","ৱহ পূরা ৱক়্ত যাদ রখ জব রব তেরা খ়ুদা রেগিস্তান মেং 40 সাল তক তেরী রাহনুমাঈ করতা রহা তাকি তুঝে আজিজ় করকে আজ়মাএ ঔর মালূম করে কি ক্যা তূ উসকে অহকাম পর চলেগা কি নহীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","উসনে তুঝে আজিজ় করকে ভূকে হোনে দিযা, ফির তুঝে মন খিলাযা জিসসে ন তূ ঔর ন তেরে বাপদাদা ৱাক়িফ় থে। ক্যোংকি ৱহ তুঝে সিখানা চাহতা থা কি ইনসান কী জ়িংদগী সির্ফ় রোটী পর মুনহসির নহীং হোতী বল্কি হর উস বাত পর জো রব কে মুঁহ সে নিকলতী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ইন 40 সালোং কে দৌরান তেরে কপড়ে ন ঘিসে ন ফটে, ন তেরে পাঁৱ সূজে। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","চুনাঁচে দিল মেং জান লে কি জিস তরহ বাপ অপনে বেটে কী তরবিযত করতা হৈ উসী তরহ রব হমারা খ়ুদা হমারী তরবিযত করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","রব অপনে খ়ুদা কে অহকাম পর অমল করকে উস কী রাহোং পর চল ঔর উসকা খ়ৌফ় মান। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","ক্যোংকি ৱহ তুঝে এক বেহতরীন মুল্ক মেং লে জা রহা হৈ জিসমেং নহরেং ঔর ঐসে চশ্মে হৈং জো পহাড়িযোং ঔর ৱাদিযোং কী জ়মীন সে ফূট নিকলতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","উস কী পৈদাৱার অনাজ, জৌ, অংগূর, অংজীর, অনার, জ়ৈতূন ঔর শহদ হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","উসমেং রোটী কী কমী নহীং হোগী, ঔর তূ কিসী চীজ় সে মহরূম নহীং রহেগা। উসকে পত্থরোং মেং লোহা পাযা জাতা হৈ, ঔর খুদাঈ সে তূ উস কী পহাড়িযোং সে তাঁবা হাসিল কর সকেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","জব তূ কসরত কা খানা খাকর সের হো জাএগা তো ফির রব অপনে খ়ুদা কী তমজীদ করনা জিসনে তুঝে যহ শানদার মুল্ক দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","খ়বরদার, রব অপনে খ়ুদা কো ন ভূল ঔর উসকে উন অহকাম পর অমল করনে সে গুরেজ় ন কর জো মৈং আজ তুঝে দে রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ক্যোংকি জব তূ কসরত কা খানা খাকর সের হো জাএগা, তূ শানদার ঘর বনাকর উনমেং রহেগা ");
INSERT INTO urdgvb_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ঔর তেরে রেৱড়, সোনে-চাঁদী ঔর বাক়ী তমাম মাল মেং ইজ়াফ়া হোগা ");
INSERT INTO urdgvb_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","তো কহীং তূ মগ়রূর হোকর রব অপনে খ়ুদা কো ভূল ন জাএ জো তুঝে মিসর কী গ়ুলামী সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","জব তূ উস ৱসী ঔর হৌলনাক রেগিস্তান মেং সফ়র কর রহা থা জিসমেং জ়হরীলে সাঁপ ঔর বিচ্ছূ থে তো ৱহী তেরী রাহনুমাঈ করতা রহা। পানী সে মহরূম উস ইলাক়ে মেং ৱহী সখ়্ত পত্থর মেং সে পানী নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","রেগিস্তান মেং ৱহী তুঝে মন খিলাতা রহা, জিসসে তেরে বাপদাদা ৱাক়িফ় ন থে। ইন মুশ্কিলাত সে ৱহ তুঝে আজিজ় করকে আজ়মাতা রহা তাকি আখ়িরকার তূ কামযাব হো জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","জব তুঝে কামযাবী হাসিল হোগী তো যহ ন কহনা কি মৈংনে অপনী হী ক়ুৱ্ৱত ঔর তাক়ত সে যহ সব কুছ হাসিল কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","বল্কি রব অপনে খ়ুদা কো যাদ করনা জিসনে তুঝে দৌলত হাসিল করনে কী ক়াবিলিযত দী হৈ। ক্যোংকি ৱহ আজ ভী উসী অহদ পর ক়াযম হৈ জো উসনে তেরে বাপদাদা সে কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","রব অপনে খ়ুদা কো ন ভূলনা, ঔর ন দীগর মাবূদোং কে পীছে পড়কর উন্হেং সিজদা ঔর উনকী খ়িদমত করনা। ৱরনা মৈং খ়ুদ গৱাহ হূঁ কি তুম যক়ীনন হলাক হো জাওগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","অগর তুম রব অপনে খ়ুদা কী ইতাঅত নহীং করোগে তো ফির ৱহ তুম্হেং উন ক়ৌমোং কী তরহ তবাহ কর দেগা জো তুমসে পহলে ইস মুল্ক মেং রহতী থীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","সুন ঐ ইসরাঈল! আজ তূ দরিযাএ-যরদন কো পার করনেৱালা হৈ। দূসরী তরফ় তূ ঐসী ক়ৌমোং কো ভগা দেগা জো তুঝসে বড়ী ঔর তাক়তৱর হৈং ঔর জিনকে শানদার শহরোং কী ফ়সীলেং আসমান সে বাতেং করতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ৱহাঁ অনাক়ী বসতে হৈং জো তাক়তৱর ঔর দরাজ়ক়দ হৈং। তূ খ়ুদ জানতা হৈ কি উনকে বারে মেং কহা জাতা হৈ, “কৌন অনাক়িযোং কা সামনা কর সকতা হৈ?” ");
INSERT INTO urdgvb_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","লেকিন আজ জান লে কি রব তেরা খ়ুদা তেরে আগে আগে চলতে হুএ উন্হেং ভস্ম কর দেনেৱালী আগ কী তরহ হলাক করেগা। ৱহ তেরে আগে আগে উন পর ক়াবূ পাএগা, ঔর তূ উন্হেং নিকালকর জল্দী মিটা দেগা, জিস তরহ রব নে ৱাদা কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","জব রব তেরা খ়ুদা উন্হেং তেরে সামনে সে নিকাল দেগা তো তূ যহ ন কহনা, “মৈং রাস্তবাজ় হূঁ, ইসী লিএ রব মুঝে লাযক় সমঝকর যহাঁ লাযা ঔর যহ মুল্ক মীরাস মেং দে দিযা হৈ।” যহ বাত হরগিজ় দুরুস্ত নহীং হৈ। রব উন ক়ৌমোং কো উনকী গ়লত হরকতোং কী ৱজহ সে তেরে সামনে সে নিকাল দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","তূ অপনী রাস্তবাজ়ী ঔর দিযানতদারী কী বিনা পর উস মুল্ক পর ক়ব্জ়া নহীং করেগা বল্কি রব উন্হেং উনকী শরীর হরকতোং কে বাইস তেরে সামনে সে নিকাল দেগা। দূসরে, জো ৱাদা উসনে তেরে বাপদাদা ইব্রাহীম, ইসহাক় ঔর যাক়ূব কে সাথ ক়সম খাকর কিযা থা উসে পূরা হোনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","চুনাঁচে জান লে কি রব তেরা খ়ুদা তুঝে তেরী রাস্তী কে বাইস যহ অচ্ছা মুল্ক নহীং দে রহা। হক়ীক়ত তো যহ হৈ কি তূ হটধর্ম ক়ৌম হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","যাদ রখ ঔর কভী ন ভূল কি তূনে রেগিস্তান মেং রব অপনে খ়ুদা কো কিস তরহ নারাজ় কিযা। মিসর সে নিকলতে ৱক়্ত সে লেকর যহাঁ পহুঁচনে তক তুম রব সে সরকশ রহে হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","খ়াসকর হোরিব যানী সীনা কে দামন মেং তুমনে রব কো ইতনা গ়ুস্সা দিলাযা কি ৱহ তুম্হেং হলাক করনে কো থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","উস ৱক়্ত মৈং পহাড় পর চঢ় গযা থা তাকি পত্থর কী তখ়্তিযাঁ যানী উস অহদ কী তখ়্তিযাঁ মিল জাএঁ জো রব নে তুম্হারে সাথ বাঁধা থা। কুছ খাএ পিএ বগ়ৈর মৈং 40 দিন ঔর রাত ৱহাঁ রহা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_10‏","006_9_10‏","DEU","9","10‏","11","জো কুছ রব নে আগ মেং সে কহা থা জব তুম পহাড় কে দামন মেং জমা থে ৱহী কুছ উসনে অপনী উঁগলী সে দোনোং তখ়্তিযোং পর লিখকর মুঝে দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","উসনে মুঝসে কহা, “ফ়ৌরন যহাঁ সে উতর জা। তেরী ক়ৌম জিসে তূ মিসর সে নিকাল লাযা বিগড় গঈ হৈ। ৱহ কিতনী জল্দী সে মেরে অহকাম সে হট গএ হৈং। উন্হোংনে অপনে লিএ বুত ঢাল লিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","মৈংনে জান লিযা হৈ কি যহ ক়ৌম কিতনী জ়িদ্দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","অব মুঝে ছোড় দে তাকি মৈং উন্হেং তবাহ করকে উনকা নামো-নিশান দুনিযা মেং সে মিটা ডালূঁ। উনকী জগহ মৈং তুঝসে এক ক়ৌম বনা লূঁগা জো উনসে বড়ী ঔর তাক়তৱর হোগী।” ");
INSERT INTO urdgvb_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","মৈং মুড়কর পহাড় সে উতরা জো অব তক ভড়ক রহা থা। মেরে হাথোং মেং অহদ কী দোনোং তখ়্তিযাঁ থীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","তুম্হেং দেখতে হী মুঝে মালূম হুআ কি তুমনে রব অপনে খ়ুদা কা গুনাহ কিযা হৈ। তুমনে অপনে লিএ বছড়ে কা বুত ঢাল লিযা থা। তুম কিতনী জল্দী সে রব কী মুক়র্ররা রাহ সে হট গএ থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","তব মৈংনে তুম্হারে দেখতে দেখতে দোনোং তখ়্তিযোং কো জ়মীন পর পটখ়কর টুকড়ে টুকড়ে কর দিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","এক ঔর বার মৈং রব কে সামনে মুঁহ কে বল গিরা। মৈংনে ন কুছ খাযা, ন কুছ পিযা। 40 দিন ঔর রাত মৈং তুম্হারে তমাম গুনাহোং কে বাইস ইসী হালত মেং রহা। ক্যোংকি জো কুছ তুমনে কিযা থা ৱহ রব কো নিহাযত বুরা লগা, ইসলিএ ৱহ গ়জ়বনাক হো গযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ৱহ তুমসে ইতনা নারাজ় থা কি মৈং বহুত ডর গযা। যোং লগ রহা থা কি ৱহ তুম্হেং হলাক কর দেগা। লেকিন ইস বার ভী উসনে মেরী সুন লী। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","মৈংনে হারূন কে লিএ ভী দুআ কী, ক্যোংকি রব উসসে ভী নিহাযত নারাজ় থা ঔর উসে হলাক কর দেনা চাহতা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","জো বছড়া তুমনে গুনাহ করকে বনাযা থা উসে মৈংনে জলা দিযা, ফির জো কুছ বাক়ী রহ গযা উসে কুচল দিযা ঔর পীস পীসকর পৌডর বনা দিযা। যহ পৌডর মৈংনে উস চশ্মে মেং ফেংক দিযা জো পহাড় পর সে বহ রহা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","তুমনে রব কো তবএরা, মস্সা ঔর ক়ব্রোত-হত্তাৱা মেং ভী গ়ুস্সা দিলাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ক়াদিস-বরনীঅ মেং ভী ঐসা হী হুআ। ৱহাঁ সে রব নে তুম্হেং ভেজকর কহা থা, “জাও, উস মুল্ক পর ক়ব্জ়া করো জো মৈংনে তুম্হেং দে দিযা হৈ।” লেকিন তুমনে সরকশ হোকর রব অপনে খ়ুদা কে হুক্ম কী খ়িলাফ়ৱরজ়ী কী। তুমনে উস পর এতমাদ ন কিযা, ন উস কী সুনী। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","জব সে মৈং তুম্হেং জানতা হূঁ তুম্হারা রব কে সাথ রৱৈযা বাগ়িযানা হী রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","মৈং 40 দিন ঔর রাত রব কে সামনে জ়মীন পর মুঁহ কে বল রহা, ক্যোংকি রব নে কহা থা কি ৱহ তুম্হেং হলাক কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","মৈংনে উসসে মিন্নত করকে কহা, “ঐ রব ক়াদিরে-মুতলক়, অপনী ক়ৌম কো তবাহ ন কর। ৱহ তো তেরী হী মিলকিযত হৈ জিসে তূনে ফ়িদ্যা দেকর অপনী অজ়ীম ক়ুদরত সে বচাযা ঔর বড়ে ইখ়্তিযার কে সাথ মিসর সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","অপনে খ়াদিমোং ইব্রাহীম, ইসহাক় ঔর যাক়ূব কো যাদ কর, ঔর ইস ক়ৌম কী জ়িদ, শরীর হরকতোং ঔর গুনাহ পর তৱজ্জুহ ন দে। ");
INSERT INTO urdgvb_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ৱরনা মিসরী কহেংগে, ‘রব উন্হেং উস মুল্ক মেং লানে কে ক়াবিল নহীং থা জিসকা ৱাদা উসনে কিযা থা, বল্কি ৱহ উনসে নফ়রত করতা থা। হাঁ, ৱহ উন্হেং হলাক করনে কে লিএ রেগিস্তান মেং লে আযা।’ ");
INSERT INTO urdgvb_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","ৱহ তো তেরী ক়ৌম হৈং, তেরী মিলকিযত জিসে তূ অপনী অজ়ীম ক়ুদরত ঔর ইখ়্তিযার সে মিসর সে নিকাল লাযা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","উস ৱক়্ত রব নে মুঝসে কহা, “পত্থর কী দো ঔর তখ়্তিযাঁ তরাশনা জো পহলী তখ়্তিযোং কী মানিংদ হোং। উন্হেং লেকর মেরে পাস পহাড় পর চঢ় আ। লকড়ী কা সংদূক় ভী বনানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ফির মৈং ইন তখ়্তিযোং পর দুবারা ৱহী বাতেং লিখূঁগা জো মৈং উন তখ়্তিযোং পর লিখ চুকা থা জো তূনে তোড় ডালীং। তুম্হেং উন্হেং সংদূক় মেং মহফ়ূজ় রখনা হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","মৈংনে কীকর কী লকড়ী কা সংদূক় বনৱাযা ঔর দো তখ়্তিযাঁ তরাশীং জো পহলী তখ়্তিযোং কী মানিংদ থীং। ফির মৈং দোনোং তখ়্তিযাঁ লেকর পহাড় পর চঢ় গযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","রব নে উন তখ়্তিযোং পর দুবারা ৱহ দস অহকাম লিখ দিএ জো ৱহ পহলী তখ়্তিযোং পর লিখ চুকা থা। (উন্হীং অহকাম কা এলান উসনে পহাড় পর আগ মেং সে কিযা থা জব তুম উসকে দামন মেং জমা থে।) ফির উসনে যহ তখ়্তিযাঁ মেরে সুপুর্দ কীং। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","মৈং লৌটকর উতরা ঔর তখ়্তিযোং কো উস সংদূক় মেং রখা জো মৈংনে বনাযা থা। ৱহাঁ ৱহ অব তক হৈং। সব কুছ ৱৈসা হী হুআ জৈসা রব নে হুক্ম দিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(ইসকে বাদ ইসরাঈলী বনী-যাক়ান কে কুওং সে রৱানা হোকর মৌসীরা পহুঁচে। ৱহাঁ হারূন ফ়ৌত হুআ। উসে দফ়ন করনে কে বাদ উসকা বেটা ইলিযজ়র উস কী জগহ ইমাম বনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","ফির ৱহ আগে সফ়র করতে করতে জুদজূদা, ফির যুতবাতা পহুঁচে জহাঁ নহরেং হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","উন দিনোং মেং রব নে লাৱী কে ক়বীলে কো অলগ করকে উসে রব কে অহদ কে সংদূক় কো উঠাকর লে জানে, রব কে হুজ়ূর খ়িদমত করনে ঔর উসকে নাম সে বরকত দেনে কী জ়িম্মাদারী দী। আজ তক যহ উনকী জ়িম্মাদারী রহী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ইস ৱজহ সে লাৱিযোং কো দীগর ক়বীলোং কী তরহ ন হিস্সা ন মীরাস মিলী। রব তেরা খ়ুদা খ়ুদ উনকী মীরাস হৈ। উসনে খ়ুদ উন্হেং যহ ফ়রমাযা হৈ।) ");
INSERT INTO urdgvb_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","জব মৈংনে দূসরী মরতবা 40 দিন ঔর রাত পহাড় পর গুজ়ারে তো রব নে ইস দফ়া ভী মেরী সুনী ঔর তুঝে হলাক ন করনে পর আমাদা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","উসনে কহা, “জা, ক়ৌম কী রাহনুমাঈ কর তাকি ৱহ জাকর উস মুল্ক পর ক়ব্জ়া করেং জিসকা ৱাদা মৈংনে ক়সম খাকর উনকে বাপদাদা সে কিযা থা।” ");
INSERT INTO urdgvb_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ঐ ইসরাঈল, অব মেরী বাত সুন! রব তেরা খ়ুদা তুঝসে ক্যা তক়াজ়া করতা হৈ? সির্ফ় যহ কি তূ উসকা খ়ৌফ় মানে, উস কী তমাম রাহোং পর চলে, উসে প্যার করে, অপনে পূরে দিলো-জান সে উস কী খ়িদমত করে ");
INSERT INTO urdgvb_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ঔর উসকে তমাম অহকাম পর অমল করে। আজ মৈং উন্হেং তুঝে তেরী বেহতরী কে লিএ দে রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","পূরা আসমান, জ়মীন ঔর জো কুছ উস পর হৈ, সবকা মালিক রব তেরা খ়ুদা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","তো ভী উসনে তেরে বাপদাদা পর হী অপনী খ়াস শফ়ক়ত কা ইজ়হার করকে উনসে মুহব্বত কী। ঔর উসনে তুম্হেং চুনকর দূসরী তমাম ক়ৌমোং পর তরজীহ দী জৈসা কি আজ জ়াহির হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","খ়তনা উস কী ক়ৌম কা নিশান হৈ, লেকিন ধ্যান রখো কি ৱহ ন সির্ফ় জ়াহিরী বল্কি বাতিনী ভী হো। আইংদা অড় ন জাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ক্যোংকি রব তুম্হারা খ়ুদা খ়ুদাওং কা খ়ুদা ঔর রব্বোং কা রব হৈ। ৱহ অজ়ীম ঔর জ়োরাৱর খ়ুদা হৈ জিসসে সব খ়ৌফ় খাতে হৈং। ৱহ জানিবদারী নহীং করতা ঔর রিশ্ৱত নহীং লেতা। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","ৱহ যতীমোং ঔর বেৱাওং কা ইনসাফ় করতা হৈ। ৱহ পরদেসী সে প্যার করতা ঔর উসে খ়ুরাক ঔর পোশাক মুহৈযা করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","তুম ভী উনকে সাথ মুহব্বত সে পেশ আও, ক্যোংকি তুম ভী মিসর মেং পরদেসী থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","রব অপনে খ়ুদা কা খ়ৌফ় মান ঔর উস কী খ়িদমত কর। উসসে লিপটা রহ ঔর উসী কে নাম কী ক়সম খা। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ৱহী তেরা ফ়খ়র হৈ। ৱহ তেরা খ়ুদা হৈ জিসনে ৱহ তমাম অজ়ীম ঔর ডরাৱনে কাম কিএ জো তূনে খ়ুদ দেখে। ");
INSERT INTO urdgvb_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","জব তেরে বাপদাদা মিসর গএ থে তো 70 অফ়রাদ থে। ঔর অব রব তেরে খ়ুদা নে তুঝে সিতারোং কী মানিংদ বেশুমার বনা দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","রব অপনে খ়ুদা সে প্যার কর ঔর হমেশা উসকে অহকাম কে মুতাবিক় জ়িংদগী গুজ়ার। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","আজ জান লো কি তুম্হারে বচ্চোং নে নহীং বল্কি তুম্হীং নে রব অপনে খ়ুদা সে তরবিযত পাঈ। তুমনে উস কী অজ়মত, বড়ে ইখ়্তিযার ঔর ক়ুদরত কো দেখা, ");
INSERT INTO urdgvb_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ঔর তুম উন মোজিজ়োং কে গৱাহ হো জো উসনে মিসর কে বাদশাহ ফ়িরৌন ঔর উসকে পূরে মুল্ক কে সামনে কিএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","তুমনে দেখা কি রব নে কিস তরহ মিসরী ফ়ৌজ কো উসকে ঘোড়োং ঔর রথোং সমেত বহরে-ক়ুলজ়ুম মেং গ়রক় কর দিযা জব ৱহ তুম্হারা তাক়্ক়ুব কর রহে থে। উসনে উন্হেং যোং তবাহ কিযা কি ৱহ আজ তক বহাল নহীং হুএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","তুম্হারে বচ্চে নহীং বল্কি তুম হী গৱাহ হো কি যহাঁ পহুঁচনে সে পহলে রব নে রেগিস্তান মেং তুম্হারী কিস তরহ দেখ-ভাল কী। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","তুমনে উসকা ইলিযাব কে বেটোং দাতন ঔর অবীরাম কে সাথ সুলূক দেখা জো রূবিন কে ক়বীলে কে থে। উস দিন জ়মীন নে খ়ৈমাগাহ কে অংদর মুঁহ খোলকর উন্হেং উনকে ঘরানোং, ডেরোং ঔর তমাম জানদারোং সমেত হড়প কর লিযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","তুমনে অপনী হী আঁখোং সে রব কে যহ তমাম অজ়ীম কাম দেখে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","চুনাঁচে উন তমাম অহকাম পর অমল করতে রহো জো মৈং আজ তুম্হেং দে রহা হূঁ তাকি তুম্হেং ৱহ তাক়ত হাসিল হো জো দরকার হোগী জব তুম দরিযাএ-যরদন কো পার করকে মুল্ক পর ক়ব্জ়া করোগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","অগর তুম ফ়রমাঁবরদার রহো তো দের তক উস মুল্ক মেং জীতে রহোগে জিসকা ৱাদা রব নে ক়সম খাকর তুম্হারে বাপদাদা সে কিযা থা ঔর জিসমেং দূধ ঔর শহদ কী কসরত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ক্যোংকি যহ মুল্ক মিসর কী মানিংদ নহীং হৈ জহাঁ সে তুম নিকল আএ হো। ৱহাঁ কে খেতোং মেং তুঝে বীজ বোকর বড়ী মেহনত সে উস কী আবপাশী করনী পড়তী থী ");
INSERT INTO urdgvb_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","জবকি জিস মুল্ক পর তুম ক়ব্জ়া করোগে উসমেং পহাড় ঔর ৱাদিযাঁ হৈং জিন্হেং সির্ফ় বারিশ কা পানী সেরাব করতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","রব তেরা খ়ুদা খ়ুদ উস মুল্ক কা খ়যাল রখতা হৈ। রব তেরে খ়ুদা কী আঁখেং সাল কে পহলে দিন সে লেকর আখ়ির তক মুতৱাতির উস পর লগী রহতী হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","চুনাঁচে উন অহকাম কে তাবে রহো জো মৈং আজ তুম্হেং দে রহা হূঁ। রব অপনে খ়ুদা সে প্যার করো ঔর অপনে পূরে দিলো-জান সে উস কী খ়িদমত করো। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ফির ৱহ খ়রীফ় ঔর বহার কী সালানা বারিশ ৱক়্ত পর ভেজেগা। অনাজ, অংগূর ঔর জ়ৈতূন কী ফ়সলেং পকেংগী, ঔর তূ উন্হেং জমা কর লেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","নীজ়, অল্লাহ তেরী চরাগাহোং মেং তেরে রেৱড়োং কে লিএ ঘাস মুহৈযা করেগা, ঔর তূ খাকর সের হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","লেকিন খ়বরদার, কহীং তুম্হেং ৱরগ়লাযা ন জাএ। ঐসা ন হো কি তুম রব কী রাহ সে হট জাও ঔর দীগর মাবূদোং কো সিজদা করকে উনকী খ়িদমত করো। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ৱরনা রব কা গ়জ়ব তুম পর আন পড়েগা, ঔর ৱহ মুল্ক মেং বারিশ হোনে নহীং দেগা। তুম্হারী ফ়সলেং নহীং পকেংগী, ঔর তুম্হেং জল্দ হী উস অচ্ছে মুল্ক মেং সে মিটা দিযা জাএগা জো রব তুম্হেং দে রহা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","চুনাঁচে মেরী যহ বাতেং অপনে দিলোং পর নক়্শ কর লো। উন্হেং নিশান কে তৌর পর ঔর যাদদিহানী কে লিএ অপনে হাথোং ঔর মাথোং পর লগাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","উন্হেং অপনে বচ্চোং কো সিখাও। হর জগহ ঔর হমেশা উনকে বারে মেং বাত করো, খ়াহ তূ ঘর মেং বৈঠা যা রাস্তে পর চলতা হো, লেটা হো যা খড়া হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","উন্হেং অপনে ঘরোং কী চৌখটোং ঔর অপনে শহরোং কে দরৱাজ়োং পর লিখ ");
INSERT INTO urdgvb_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","তাকি জব তক জ়মীন পর আসমান ক়াযম হৈ তুম ঔর তুম্হারী ঔলাদ উস মুল্ক মেং জীতে রহেং জিসকা ৱাদা রব নে ক়সম খাকর তুম্হারে বাপদাদা সে কিযা থা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","এহতিযাত সে উন অহকাম কী পৈরৱী করো জো মৈং তুম্হেং দে রহা হূঁ। রব অপনে খ়ুদা সে প্যার করো, উসকে তমাম অহকাম পর অমল করো ঔর উসকে সাথ লিপটে রহো। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ফির ৱহ তুম্হারে আগে আগে যহ তমাম ক়ৌমেং নিকাল দেগা ঔর তুম ঐসী ক়ৌমোং কী জ়মীনোং পর ক়ব্জ়া করোগে জো তুমসে বড়ী ঔর তাক়তৱর হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","তুম জহাঁ ভী ক়দম রখোগে ৱহ তুম্হারা হী হোগা, জুনূবী রেগিস্তান সে লেকর লুবনান তক, দরিযাএ-ফ়ুরাত সে বহীরাএ-রূম তক। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","কোঈ ভী তুম্হারা সামনা নহীং কর সকেগা। তুম উস মুল্ক মেং জহাঁ ভী জাওগে ৱহাঁ রব তুম্হারা খ়ুদা অপনে ৱাদে কে মুতাবিক় তুম্হারী দহশত ঔর খ়ৌফ় পৈদা কর দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","আজ তুম খ়ুদ ফ়ৈসলা করো। ক্যা তুম রব কী বরকত যা উস কী লানত পানা চাহতে হো? ");
INSERT INTO urdgvb_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","অগর তুম রব অপনে খ়ুদা কে উন অহকাম পর অমল করো জো মৈং আজ তুম্হেং দে রহা হূঁ তো ৱহ তুম্হেং বরকত দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","লেকিন অগর তুম উনকে তাবে ন রহো বল্কি মেরী পেশকরদা রাহ সে হটকর দীগর মাবূদোং কী পৈরৱী করো তো ৱহ তুম পর লানত ভেজেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","জব রব তেরা খ়ুদা তুঝে উস মুল্ক মেং লে জাএগা জিস পর তূ ক়ব্জ়া করেগা তো লাজ়িম হৈ কি গরিজ়ীম পহাড় পর চঢ়কর বরকত কা এলান করে ঔর ঐবাল পহাড় পর লানত কা। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","যহ দো পহাড় দরিযাএ-যরদন কে মগ়রিব মেং উন কনানিযোং কে ইলাক়ে মেং ৱাক়ে হৈং জো ৱাদীএ-যরদন মেং আবাদ হৈং। ৱহ মগ়রিব কী তরফ় জিলজাল শহর কে সামনে মোরিহ কে বলূত কে দরখ়্তোং কে নজ়দীক হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","অব তুম দরিযাএ-যরদন কো পার করকে উস মুল্ক পর ক়ব্জ়া করনেৱালে হো জো রব তুম্হারা খ়ুদা তুম্হেং দে রহা হৈ। জব তুম উসে অপনাকর উসমেং আবাদ হো জাওগে ");
INSERT INTO urdgvb_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","তো এহতিযাত সে উন তমাম অহকাম পর অমল করতে রহো জো মৈং আজ তুম্হেং দে রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","জ়ৈল মেং ৱহ অহকাম ঔর ক়ৱানীন হৈং জিন পর তুম্হেং ধ্যান সে অমল করনা হোগা জব তুম উস মুল্ক মেং আবাদ হোগে জো রব তেরে বাপদাদা কা খ়ুদা তুঝে দে রহা হৈ তাকি তূ উস পর ক়ব্জ়া করে। মুল্ক মেং রহতে হুএ উম্র-ভর উনকে তাবে রহো। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","উন তমাম জগহোং কো বরবাদ করো জহাঁ ৱহ ক়ৌমেং জিন্হেং তুম্হেং নিকালনা হৈ অপনে দেৱতাওং কী পূজা করতী হৈং, খ়াহ ৱহ ঊঁচে পহাড়োং, পহাড়িযোং যা ঘনে দরখ়্তোং কে সাযে মেং ক্যোং ন হোং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","উনকী ক়ুরবানগাহোং কো ঢা দেনা। জিন পত্থরোং কী পূজা ৱহ করতে হৈং উন্হেং চকনাচূর কর দেনা। যসীরত দেৱী কে খংবে জলা দেনা। উনকে দেৱতাওং কে মুজস্সমে কাট ডালনা। গ়রজ় ইন জগহোং সে উনকা নামো-নিশান মিট জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","রব অপনে খ়ুদা কী পরস্তিশ করনে কে লিএ উনকে তরীক়ে ন অপনানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","রব তুম্হারা খ়ুদা ক়বীলোং মেং সে অপনে নাম কী সুকূনত কে লিএ এক জগহ চুন লেগা। ইবাদত কে লিএ ৱহাঁ জাযা করো, ");
INSERT INTO urdgvb_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ঔর ৱহাঁ অপনী তমাম ক়ুরবানিযাঁ লাকর পেশ করো, খ়াহ ৱহ ভস্ম হোনেৱালী ক়ুরবানিযাঁ, জ়বহ কী ক়ুরবানিযাঁ, পৈদাৱার কা দসৱাঁ হিস্সা, উঠানেৱালী ক়ুরবানিযাঁ, মন্নত কে হদিযে, খ়ুশী সে পেশ কী গঈ ক়ুরবানিযাঁ যা মৱেশিযোং কে পহলৌঠে ক্যোং ন হোং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ৱহাঁ রব অপনে খ়ুদা কে হুজ়ূর অপনে ঘরানোং সমেত খানা খাকর উন কামযাবিযোং কী খ়ুশী মনাও জো তুঝে রব তেরে খ়ুদা কী বরকত কে বাইস হাসিল হুঈ হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","উস ৱক়্ত তুম্হেং ৱহ নহীং করনা জো হম করতে আএ হৈং। আজ তক হর কোঈ অপনী মরজ়ী কে মুতাবিক় ইবাদত করতা হৈ, ");
INSERT INTO urdgvb_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","ক্যোংকি অব তক তুম আরাম কী উস জগহ নহীং পহুঁচে জো তুঝে রব তেরে খ়ুদা সে মীরাস মেং মিলনী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","লেকিন জল্দ হী তুম দরিযাএ-যরদন কো পার করকে উস মুল্ক মেং আবাদ হো জাওগে জো রব তুম্হারা খ়ুদা তুম্হেং মীরাস মেং দে রহা হৈ। উস ৱক়্ত ৱহ তুম্হেং ইর্দগির্দ কে দুশ্মনোং সে বচাএ রখেগা, ঔর তুম আরাম ঔর সুকূন সে জ়িংদগী গুজ়ার সকোগে। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","তব রব তুম্হারা খ়ুদা অপনে নাম কী সুকূনত কে লিএ এক জগহ চুন লেগা, ঔর তুম্হেং সব কুছ জো মৈং বতাঊঁগা ৱহাঁ লাকর পেশ করনা হৈ, খ়াহ ৱহ ভস্ম হোনেৱালী ক়ুরবানিযাঁ, জ়বহ কী ক়ুরবানিযাঁ, পৈদাৱার কা দসৱাঁ হিস্সা, উঠানেৱালী ক়ুরবানিযাঁ যা মন্নত কে খ়াস হদিযে ক্যোং ন হোং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ৱহাঁ রব কে সামনে তুম, তুম্হারে বেটে-বেটিযাঁ, তুম্হারে গ়ুলাম ঔর লৌংডিযাঁ খ়ুশী মনাএঁ। অপনে শহরোং মেং আবাদ লাৱিযোং কো ভী অপনী খ়ুশী মেং শরীক করো, ক্যোংকি উনকে পাস মৌরূসী জ়মীন নহীং হোগী। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","খ়বরদার, অপনী ভস্ম হোনেৱালী ক়ুরবানিযাঁ হর জগহ পর পেশ ন করনা ");
INSERT INTO urdgvb_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","বল্কি সির্ফ় উস জগহ পর জো রব ক়বীলোং মেং সে চুনেগা। ৱহীং সব কুছ যোং মনা জিস তরহ মৈং তুঝে বতাতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","লেকিন ৱহ জানৱর ইসমেং শামিল নহীং হৈং জো তূ ক়ুরবানী কে তৌর পর পেশ নহীং করনা চাহতা বল্কি সির্ফ় খানা চাহতা হৈ। ঐসে জানৱর তূ আজ়াদী সে অপনে তমাম শহরোং মেং জ়বহ করকে উস বরকত কে মুতাবিক় খা সকতা হৈ জো রব তেরে খ়ুদা নে তুঝে দী হৈ। ঐসা গোশ্ত হিরন ঔর গ়জ়াল কে গোশ্ত কী মানিংদ হৈ যানী পাক ঔর নাপাক দোনোং হী উসে খা সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","লেকিন খ়ূন ন খানা। উসে পানী কী তরহ জ়মীন পর উংডেলকর জ়াযা কর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","জো ভী চীজ়েং রব কে লিএ মখ়সূস কী গঈ হৈং উন্হেং অপনে শহরোং মেং ন খানা মসলন অনাজ, অংগূর কে রস ঔর জ়ৈতূন কে তেল কা দসৱাঁ হিস্সা, মৱেশিযোং কে পহলৌঠে, মন্নত কে হদিযে, খ়ুশী সে পেশ কী গঈ ক়ুরবানিযাঁ ঔর উঠানেৱালী ক়ুরবানিযাঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","যহ চীজ়েং সির্ফ় রব কে হুজ়ূর খানা যানী উস জগহ পর জিসে ৱহ মক়দিস কে লিএ চুনেগা। ৱহীং তূ অপনে বেটে-বেটিযোং, গ়ুলামোং, লৌংডিযোং ঔর অপনে ক়বাযলী ইলাক়ে কে লাৱিযোং কে সাথ জমা হোকর খ়ুশী মনা কি রব নে হমারী মেহনত কো বরকত দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","অপনে মুল্ক মেং লাৱিযোং কী জ়রূরিযাত উম্র-ভর পূরী করনে কী ফ়িকর রখ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","জব রব তেরা খ়ুদা অপনে ৱাদে কে মুতাবিক় তেরী সরহদ্দেং বঢ়া দেগা ঔর তূ গোশ্ত খানে কী খ়াহিশ রখেগা তো জিস তরহ জী চাহে গোশ্ত খা সকেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","অগর তেরা ঘর উস মক়দিস সে দূর হো জিসে রব তেরা খ়ুদা অপনে নাম কী সুকূনত কে লিএ চুনেগা তো তূ জিস তরহ জী চাহে অপনে শহরোং মেং রব সে মিলে হুএ মৱেশিযোং কো জ়বহ করকে খা সকতা হৈ। লেকিন ঐসা হী করনা জৈসা মৈংনে হুক্ম দিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ঐসা গোশ্ত হিরন ঔর গ়জ়াল কে গোশ্ত কী মানিংদ হৈ যানী পাক ঔর নাপাক দোনোং হী উসে খা সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","অলবত্তা গোশ্ত কে সাথ খ়ূন ন খানা, ক্যোংকি খ়ূন জানদার কী জান হৈ। উস কী জান গোশ্ত কে সাথ ন খানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","খ়ূন ন খানা বল্কি উসে জ়মীন পর উংডেলকর জ়াযা কর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","উসে ন খানা তাকি তুঝে ঔর তেরী ঔলাদ কো কামযাবী হাসিল হো, ক্যোংকি ঐসা করনে সে তূ রব কী নজ়র মেং সহীহ কাম করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","লেকিন জো চীজ়েং রব কে লিএ মখ়সূসো-মুক়দ্দস হৈং যা জো তূনে মন্নত মানকর উসকে লিএ মখ়সূস কী হৈং লাজ়িম হৈ কি তূ উন্হেং উস জগহ লে জাএ জিসে রব মক়দিস কে লিএ চুনেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ৱহীং, রব অপনে খ়ুদা কী ক়ুরবানগাহ পর অপনী ভস্ম হোনেৱালী ক়ুরবানিযাঁ গোশ্ত ঔর খ়ূন সমেত চঢ়া। জ়বহ কী ক়ুরবানিযোং কা খ়ূন ক়ুরবানগাহ পর উংডেল দেনা, লেকিন উনকা গোশ্ত তূ খা সকতা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","জো ভী হিদাযাত মৈং তুঝে দে রহা হূঁ উন্হেং এহতিযাত সে পূরা কর। ফির তূ ঔর তেরী ঔলাদ খ়ুশহাল রহেংগে, ক্যোংকি তূ ৱহ কুছ করেগা জো রব তেরে খ়ুদা কী নজ়র মেং অচ্ছা ঔর দুরুস্ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","রব তেরা খ়ুদা উন ক়ৌমোং কো মিটা দেগা জিনকী তরফ় তূ বঢ় রহা হৈ। তূ উন্হেং উনকে মুল্ক সে নিকালতা জাএগা ঔর খ়ুদ উসমেং আবাদ হো জাএগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","লেকিন খ়বরদার, উনকে খ়ত্ম হোনে কে বাদ ভী উনকে দেৱতাওং কে বারে মেং মালূমাত হাসিল ন কর, ৱরনা তূ ফঁস জাএগা। মত কহনা কি যহ ক়ৌমেং কিস তরীক়ে সে অপনে দেৱতাওং কী পূজা করতী হৈং? হম ভী ঐসা হী করেং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ঐসা মত কর! যহ ক়ৌমেং ঐসে ঘিনৌনে তরীক়ে সে পূজা করতী হৈং জিনসে রব নফ়রত করতা হৈ। ৱহ অপনে বচ্চোং কো ভী জলাকর অপনে দেৱতাওং কো পেশ করতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","কলাম কী জো ভী বাত মৈং তুম্হেং পেশ করতা হূঁ উসকে তাবে রহকর উস পর অমল করো। ন কিসী বাত কা ইজ়াফ়া করনা, ন কোঈ বাত নিকালনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","তেরে দরমিযান ঐসে লোগ উঠ খড়ে হোংগে জো অপনে আপকো নবী যা খ়াব দেখনেৱালে কহেংগে। হো সকতা হৈ কি ৱহ কিসী ইলাহী নিশান যা মোজিজ়ে কা এলান করেং ");
INSERT INTO urdgvb_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","জো ৱাক়ঈ ৱুজূদ মেং আএ। সাথ সাথ ৱহ কহেং, “আ, হম দীগর মাবূদোং কী পূজা করেং, হম উনকী খ়িদমত করেং জিনসে তূ অব তক ৱাক়িফ় নহীং হৈ।” ");
INSERT INTO urdgvb_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ঐসে লোগোং কী ন সুন। ইসসে রব তুম্হারা খ়ুদা তুম্হেং আজ়মাকর মালূম কর রহা হৈ কি ক্যা তুম ৱাক়ঈ অপনে পূরে দিলো-জান সে উসসে প্যার করতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","তুম্হেং রব অপনে খ়ুদা কী পৈরৱী করনা ঔর উসী কা খ়ৌফ় মাননা হৈ। উসকে অহকাম কে মুতাবিক় জ়িংদগী গুজ়ারো, উস কী সুনো, উস কী খ়িদমত করো, উসকে সাথ লিপটে রহো। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ঐসে নবিযোং যা খ়াব দেখনেৱালোং কো সজ়াএ-মৌত দেনা, ক্যোংকি ৱহ তুঝে রব তুম্হারে খ়ুদা সে বগ়াৱত করনে পর উকসানা চাহতে হৈং, উসী সে জিসনে ফ়িদ্যা দেকর তুম্হেং মিসর কী গ়ুলামী সে বচাযা ঔর ৱহাঁ সে নিকাল লাযা। চূঁকি ৱহ তুঝে উস রাহ সে হটানা চাহতে হৈং জিসে রব তেরে খ়ুদা নে তেরে লিএ মুক়র্রর কিযা হৈ ইসলিএ লাজ়িম হৈ কি উন্হেং সজ়াএ-মৌত দী জাএ। ঐসী বুরাঈ অপনে দরমিযান সে মিটা দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","হো সকতা হৈ কি তেরা সগা ভাঈ, তেরা বেটা যা বেটী, তেরী বীৱী যা তেরা ক়রীবী দোস্ত তুঝে চুপকে সে ৱরগ়লানে কী কোশিশ করে কি আ, হম জাকর দীগর মাবূদোং কী পূজা করেং, ঐসে দেৱতাওং কী জিনসে ন তূ ঔর ন তেরে বাপদাদা ৱাক়িফ় থে। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","খ়াহ ইর্দগির্দ কী যা দূর-দরাজ় কী ক়ৌমোং কে দেৱতা হোং, খ়াহ দুনিযা কে এক সিরে কে যা দূসরে সিরে কে মাবূদ হোং, ");
INSERT INTO urdgvb_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","কিসী সূরত মেং অপনী রজ়ামংদী কা ইজ়হার ন কর, ন উস কী সুন। উস পর রহম ন কর। ন উসে বচাএ রখ, ন উসে পনাহ দে ");
INSERT INTO urdgvb_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","বল্কি উসে সজ়াএ-মৌত দে। ঔর উসে সংগসার করতে ৱক়্ত পহলে তেরা হাথ উস পর পত্থর ফেংকে, ফির হী বাক়ী তমাম লোগ হিস্সা লেং। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","উসে জ়রূর পত্থরোং সে সজ়াএ-মৌত দেনা, ক্যোংকি উসনে তুঝে রব তেরে খ়ুদা সে দূর করনে কী কোশিশ কী, উসী সে জো তুঝে মিসর কী গ়ুলামী সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ফির তমাম ইসরাঈল যহ সুনকর ডর জাএগা ঔর আইংদা তেরে দরমিযান ঐসী শরীর হরকত করনে কী জুর্রত নহীং করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","জব তূ উন শহরোং মেং রহনে লগেগা জো রব তেরা খ়ুদা তুঝে দে রহা হৈ তো শাযদ তুঝে খ়বর মিল জাএ ");
INSERT INTO urdgvb_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","কি শরীর লোগ তেরে দরমিযান সে উভর আএ হৈং জো অপনে শহর কে বাশিংদোং কো যহ কহকর গ়লত রাহ পর লাএ হৈং কি আও, হম দীগর মাবূদোং কী পূজা করেং, ঐসে মাবূদোং কী জিনসে তুম ৱাক়িফ় নহীং হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","লাজ়িম হৈ কি তূ দরিযাফ়্ত করকে ইসকী তফ়তীশ করে ঔর খ়ূব মালূম করে কি ক্যা হুআ হৈ। অগর সাবিত হো জাএ কি যহ ঘিনৌনী বাত ৱাক়ঈ হুঈ হৈ ");
INSERT INTO urdgvb_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","তো ফির লাজ়িম হৈ কি তূ শহর কে তমাম বাশিংদোং কো হলাক করে। উসে রব কে সুপুর্দ করকে সরাসর তবাহ করনা, ন সির্ফ় উসকে লোগ বল্কি উসকে মৱেশী ভী। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","শহর কা পূরা মালে-গ়নীমত চৌক মেং ইকট্ঠা কর। ফির পূরে শহর কো উসকে মাল সমেত রব কে লিএ মখ়সূস করকে জলা দেনা। উসে দুবারা কভী ন তামীর কিযা জাএ বল্কি উসকে খংডরাত হমেশা তক রহেং। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","পূরা শহর রব কে লিএ মখ়সূস কিযা গযা হৈ, ইসলিএ উস কী কোঈ ভী চীজ় তেরে পাস ন পাঈ জাএ। সির্ফ় ইস সূরত মেং রব কা গ়জ়ব ঠংডা হো জাএগা, ঔর ৱহ তুঝ পর রহম করকে অপনী মেহরবানী কা ইজ়হার করেগা ঔর তেরী তাদাদ বঢ়াএগা, জিস তরহ উসনে ক়সম খাকর তেরে বাপদাদা সে ৱাদা কিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","লেকিন যহ সব কুছ ইস পর মবনী হৈ কি তূ রব অপনে খ়ুদা কী সুনে ঔর উসকে উন তমাম অহকাম পর অমল করে জো মৈং তুঝে আজ দে রহা হূঁ। ৱহী কুছ কর জো উস কী নজ়র মেং দুরুস্ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","তুম রব অপনে খ়ুদা কে ফ়রজ়ংদ হো। অপনে আপকো মুরদোং কে সবব সে ন জ়খ়মী করো, ন অপনে সর কে সামনেৱালে বাল মুঁডৱাও। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","ক্যোংকি তূ রব অপনে খ়ুদা কে লিএ মখ়সূসো-মুক়দ্দস ক়ৌম হৈ। দুনিযা কী তমাম ক়ৌমোং মেং সে রব নে তুঝে হী চুনকর অপনী মিলকিযত বনা লিযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","কোঈ ভী মকরূহ চীজ় ন খানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","তুম বৈল, ভেড়-বকরী, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","হিরন, গ়জ়াল, মৃগ, পহাড়ী বকরী, মহাত, গ়জ়ালে-অফ়্রীক়া ঔর পহাড়ী বকরী খা সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","জিনকে খুর যা পাঁৱ বিলকুল চিরে হুএ হৈং ঔর জো জুগালী করতে হৈং উন্হেং খানে কী ইজাজ়ত হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ঊঁট, বিজ্জূ যা খ়রগোশ খানা মনা হৈ। ৱহ তুম্হারে লিএ নাপাক হৈং, ক্যোংকি ৱহ জুগালী তো করতে হৈং লেকিন উনকে খুর যা পাঁৱ চিরে হুএ নহীং হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","সুঅর ন খানা। ৱহ তুম্হারে লিএ নাপাক হৈ, ক্যোংকি উসকে খুর তো চিরে হুএ হৈং লেকিন ৱহ জুগালী নহীং করতা। ন উনকা গোশ্ত খানা, ন উনকী লাশোং কো ছূনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","পানী মেং রহনেৱালে জানৱর খানে কে লিএ জাযজ় হৈং অগর উনকে পর ঔর ছিলকে হোং। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","লেকিন জিনকে পর যা ছিলকে নহীং হৈং ৱহ তুম্হারে লিএ নাপাক হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","তুম হর পাক পরিংদা খা সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","লেকিন জ়ৈল কে পরিংদে খানা মনা হৈ : উক়াব, দঢ়িযল গিদ্ধ, কালা গিদ্ধ, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","লাল চীল, কালী চীল, হর ক়িস্ম কা গিদ্ধ, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","হর ক়িস্ম কা কৌৱা, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","উক়াবী উল্লূ, ছোটে কানৱালা উল্লূ, বড়ে কানৱালা উল্লূ, হর ক়িস্ম কা বাজ়, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ছোটা উল্লূ, চিংঘাড়নেৱালা উল্লূ, সফ়েদ উল্লূ, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","দশ্তী উল্লূ, মিসরী গিদ্ধ, ক়ূক়, ");
INSERT INTO urdgvb_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","লক়লক়, হর ক়িস্ম কা বূতীমার, হুদহুদ ঔর চমগাদড়। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","তমাম পর রখনেৱালে কীড়ে তুম্হারে লিএ নাপাক হৈং। উন্হেং খানা মনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","লেকিন তুম হর পাক পরিংদা খা সকতে হো। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","জো জানৱর খ়ুদ বখ়ুদ মর জাএ উসে ন খানা। তূ উসে অপনী আবাদী মেং রহনেৱালে কিসী পরদেসী কো দে যা কিসী অজনবী কো বেচ সকতা হৈ ঔর ৱহ উসে খা সকতা হৈ। লেকিন তূ উসে মত খানা, ক্যোংকি তূ রব অপনে খ়ুদা কে লিএ মখ়সূসো-মুক়দ্দস ক়ৌম হৈ। বকরী কে বচ্চে কো উস কী মাঁ কে দূধ মেং পকানা মনা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","লাজ়িম হৈ কি তূ হর সাল অপনে খেতোং কী পৈদাৱার কা দসৱাঁ হিস্সা রব কে লিএ অলগ করে। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ইসকে লিএ অপনা অনাজ, অংগূর কা রস, জ়ৈতূন কা তেল ঔর মৱেশী কে পহলৌঠে রব অপনে খ়ুদা কে হুজ়ূর লে আনা যানী উস জগহ জো ৱহ অপনে নাম কী সুকূনত কে লিএ চুনেগা। ৱহাঁ যহ চীজ়েং ক়ুরবান করকে খা তাকি তূ উম্র-ভর রব অপনে খ়ুদা কা খ়ৌফ় মাননা সীখে। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","লেকিন হো সকতা হৈ কি জো জগহ রব তেরা খ়ুদা অপনে নাম কী সুকূনত কে লিএ চুনেগা ৱহ তেরে ঘর সে হদ সে জ়্যাদা দূর হো ঔর রব তেরে খ়ুদা কী বরকত কে বাইস মজ়কূরা দসৱাঁ হিস্সা ইতনা জ়্যাদা হো কি তূ উসে মক়দিস তক নহীং পহুঁচা সকতা। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ইস সূরত মেং উসে বেচকর উসকে পৈসে উস জগহ লে জা জো রব তেরা খ়ুদা অপনে নাম কী সুকূনত কে লিএ চুনেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ৱহাঁ পহুঁচকর উন পৈসোং সে জো জী চাহে খ়রীদনা, খ়াহ গায-বৈল, ভেড়-বকরী, মৈ যা মৈ জৈসী কোঈ ঔর চীজ় ক্যোং ন হো। ফির অপনে ঘরানে কে সাথ মিলকর রব অপনে খ়ুদা কে হুজ়ূর যহ চীজ়েং খানা ঔর খ়ুশী মনানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ঐসে মৌক়োং পর উন লাৱিযোং কা খ়যাল রখনা জো তেরে ক়বাযলী ইলাক়ে মেং রহতে হৈং, ক্যোংকি উন্হেং মীরাস মেং জ়মীন নহীং মিলেগী। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","হর তীসরে সাল অপনী পৈদাৱার কা দসৱাঁ হিস্সা অপনে শহরোং মেং জমা করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","উসে লাৱিযোং কো দেনা জিনকে পাস মৌরূসী জ়মীন নহীং হৈ, নীজ় অপনে শহরোং মেং আবাদ পরদেসিযোং, যতীমোং ঔর বেৱাওং কো দেনা। ৱহ আএঁ ঔর খানা খাকর সের হো জাএঁ তাকি রব তেরা খ়ুদা তেরে হর কাম মেং বরকত দে। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","হর সাত সাল কে বাদ এক দূসরে কে কর্জ়ে মুআফ় কর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","উস ৱক়্ত জিসনে ভী কিসী ইসরাঈলী ভাঈ কো ক়র্জ় দিযা হৈ ৱহ উসে মনসূখ় করে। ৱহ অপনে পড়োসী যা ভাঈ কো পৈসে ৱাপস করনে পর মজবূর ন করে, ক্যোংকি রব কী তাজ়ীম মেং ক়র্জ় মুআফ় করনে কে সাল কা এলান কিযা গযা হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","ইস সাল মেং তূ সির্ফ় গ়ৈরমুল্কী ক়র্জ়দারোং কো পৈসে ৱাপস করনে পর মজবূর কর সকতা হৈ। অপনে ইসরাঈলী ভাঈ কে তমাম ক়র্জ় মুআফ় কর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","তেরে দরমিযান কোঈ ভী গ়রীব নহীং হোনা চাহিএ, ক্যোংকি জব তূ উস মুল্ক মেং রহেগা জো রব তেরা খ়ুদা তুঝে মীরাস মেং দেনেৱালা হৈ তো ৱহ তুঝে বহুত বরকত দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","লেকিন শর্ত যহ হৈ কি তূ পূরে তৌর পর উস কী সুনে ঔর এহতিযাত সে উসকে উন তমাম অহকাম পর অমল করে জো মৈং তুঝে আজ দে রহা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","ফির রব তুম্হারা খ়ুদা তুঝে অপনে ৱাদে কে মুতাবিক় বরকত দেগা। তূ কিসী ভী ক়ৌম সে উধার নহীং লেগা বল্কি বহুত-সী ক়ৌমোং কো উধার দেগা। কোঈ ভী ক়ৌম তুঝ পর হুকূমত নহীং করেগী বল্কি তূ বহুত-সী ক়ৌমোং পর হুকূমত করেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","জব তূ উস মুল্ক মেং আবাদ হোগা জো রব তেরা খ়ুদা তুঝে দেনেৱালা হৈ তো অপনে দরমিযান রহনেৱালে গ়রীব ভাঈ সে সখ়্ত সুলূক ন করনা, ন কংজূস হোনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","খুলে দিল সে উস কী মদদ কর। জিতনী উসে জ়রূরত হৈ উসে উধার কে তৌর পর দে। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","খ়বরদার, ঐসা মত সোচ কি ক়র্জ় মুআফ় করনে কা সাল ক়রীব হৈ, ইসলিএ মৈং উসে কুছ নহীং দূঁগা। অগর তূ ঐসী শরীর বাত অপনে দিল মেং সোচতে হুএ জ়রূরতমংদ ভাঈ কো ক়র্জ় দেনে সে ইনকার করে ঔর ৱহ রব কে সামনে তেরী শিকাযত করে তো তূ ক়ুসূরৱার ঠহরেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","উসে জ়রূর কুছ দে বল্কি খ়ুশী সে দে। ফির রব তেরা খ়ুদা তেরে হর কাম মেং বরকত দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","মুল্ক মেং হমেশা গ়রীব ঔর জ়রূরতমংদ লোগ পাএ জাএংগে, ইসলিএ মৈং তুঝে হুক্ম দেতা হূঁ কি খুলে দিল সে অপনে গ়রীব ঔর জ়রূরতমংদ ভাইযোং কী মদদ কর। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","অগর কোঈ ইসরাঈলী ভাঈ যা বহন অপনে আপকো বেচকর তেরা গ়ুলাম বন জাএ তো ৱহ ছঃ সাল তেরী খ়িদমত করে। লেকিন লাজ়িম হৈ কি সাতৱেং সাল উসে আজ়াদ কর দিযা জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","আজ়াদ করতে ৱক়্ত উসে খ়ালী হাথ ফ়ারিগ় ন করনা ");
INSERT INTO urdgvb_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","বল্কি অপনী ভেড়-বকরিযোং, অনাজ, তেল ঔর মৈ সে উসে ফ়ৈযাজ়ী সে কুছ দে, যানী উন চীজ়োং মেং সে জিনসে রব তেরে খ়ুদা নে তুঝে বরকত দী হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","যাদ রখ কি তূ ভী মিসর মেং গ়ুলাম থা ঔর কি রব তেরে খ়ুদা নে ফ়িদ্যা দেকর তুঝে ছুড়াযা। ইসী লিএ মৈং আজ তুঝে যহ হুক্ম দেতা হূঁ। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","লেকিন মুমকিন হৈ কি তেরা গ়ুলাম তুঝে ছোড়না ন চাহে, ক্যোংকি ৱহ তুঝসে ঔর তেরে খ়ানদান সে মুহব্বত রখতা হৈ, ঔর ৱহ তেরে পাস রহকর খ়ুশহাল হৈ। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ইস সূরত মেং উসে দরৱাজ়ে কে পাস লে জা ঔর উসকে কান কী লৌ চৌখট কে সাথ লগাকর উসে সুতালী যানী তেজ় ঔজ়ার সে ছেদ দে। তব ৱহ জ়িংদগী-ভর তেরা গ়ুলাম বনা রহেগা। অপনী লৌংডী কে সাথ ভী ঐসা হী করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","অগর গ়ুলাম তুঝে ছঃ সাল কে বাদ ছোড়না চাহে তো বুরা ন মাননা। আখ়ির অগর উস কী জগহ কোঈ ঔর ৱহী কাম তনখ়াহ কে লিএ করতা তো তেরে অখ়রাজাত দুগনে হোতে। উসে আজ়াদ করনা তো রব তেরা খ়ুদা তেরে হর কাম মেং বরকত দেগা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","অপনী গাযোং ঔর ভেড়-বকরিযোং কে নর পহলৌঠে রব অপনে খ়ুদা কে লিএ মখ়সূস করনা। ন গায কে পহলৌঠে কো কাম কে লিএ ইস্তেমাল করনা, ন ভেড় কে পহলৌঠে কে বাল কতরনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","হর সাল ঐসে বচ্চে উস জগহ লে জা জো রব অপনে মক়দিস কে লিএ চুনেগা। ৱহাঁ উন্হেং রব অপনে খ়ুদা কে হুজ়ূর অপনে পূরে খ়ানদান সমেত খানা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","অগর ঐসে জানৱর মেং কোঈ খ়রাবী হো, ৱহ অংধা যা লঁগড়া হো যা উসমেং কোঈ ঔর নুক়্স হো তো উসে রব অপনে খ়ুদা কে লিএ ক়ুরবান ন করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ঐসে জানৱর তূ ঘর মেং জ়বহ করকে খা সকতা হৈ। ৱহ হিরন ঔর গ়জ়াল কী মানিংদ হৈং জিন্হেং তূ খা তো সকতা হৈ লেকিন ক়ুরবানী কে তৌর পর পেশ নহীং কর সকতা। পাক ঔর নাপাক শখ়্স দোনোং উসে খা সকতে হৈং। ");
INSERT INTO urdgvb_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","লেকিন খ়ূন ন খানা। উসে পানী কী তরহ জ়মীন পর উংডেলকর জ়াযা কর দেনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","অবীব কে মহীনে মেং রব অপনে খ়ুদা কী তাজ়ীম মেং ফ়সহ কী ঈদ মনানা, ক্যোংকি ইস মহীনে মেং ৱহ তুঝে রাত কে ৱক়্ত মিসর সে নিকাল লাযা। ");
INSERT INTO urdgvb_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","উস জগহ জমা হো জা জো রব অপনে নাম কী সুকূনত কে লিএ চুনেগা। উসে ক়ুরবানী কে লিএ ভেড়-বকরিযাঁ যা গায-বৈল পেশ করনা। ");
INSERT INTO urdgvb_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","গোশ্ত কে সাথ বেখ়মীরী রোটী খানা। সাত দিন তক যহী রোটী খা, বিলকুল উসী তরহ জিস তরহ তূনে কিযা জব জল্দী জল্দী মিসর সে নিকলা। মুসীবত কী যহ রোটী ইসলিএ খা তাকি ৱহ দিন তেরে জীতে-জী যাদ রহে জব তূ মিসর সে রৱানা হুআ। ");
INSERT INTO urdgvb_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","লাজ়িম হৈ কি ঈদ কে হফ়তে কে দৌরান তেরে পূরে মুল্ক মেং খ়মীর ন পাযা জাএ। জো ক়ুরবানী তূ ঈদ কে পহলে দিন কী শাম কো পেশ করে উসকা গোশ্ত উসী ৱক়্ত খা লে। অগলী সুবহ তক কুছ বাক়ী ন রহ জাএ। ");
INSERT INTO urdgvb_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","ফ়সহ কী ক়ুরবানী কিসী ভী শহর মেং জো রব তেরা খ়ুদা তুঝে দেগা ন চঢ়ানা ");
INSERT INTO urdgvb_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","বল্কি সির্ফ় উস জগহ জো ৱহ অপনে নাম কী স