﻿USE sofia;
DROP TABLE IF EXISTS sofia.zak_vpl;
CREATE TABLE zak_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES zak_vpl WRITE;
INSERT INTO zak_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Gano nigo amariina ge ekisyooko kya Yeesu Krisito. Yeesu Krisito akarweera mukisyooko kyo omutemi Daudi na Aburahamu. ");
INSERT INTO zak_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aburahamu akamwiibhura Isaaka, Isaaka akamwiibhura Yaakobo, Yaakobo akamwiibhura Yuuda na bhawamwaabhu. ");
INSERT INTO zak_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuuda akamwiibhura Pereesi na Zeera ku Tamaari, Pereesi akamwiibhura Hezirooni, Hezirooni akamwiibhura Araamu, ");
INSERT INTO zak_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araamu akamwiibhura Aminadabu, Aminadabu akamwiibhura Nasoni, Nasoni akamwiibhura Sarimooni, ");
INSERT INTO zak_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarimooni akamwiibhura Boazi ku Rahaabu, Boazi akamwiibhura Obeedi ku Ruutu, Obeedi akamwiibhura Yeese, ");
INSERT INTO zak_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Yeese akamwiibhura omutemi Daudi. Daudi akamwiibhura Soromooni kumukari wuno yaari omukari wa Uria, ");
INSERT INTO zak_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromooni akamwiibhura Rehoboamu, Rehoboamu akamwiibhura Abiya, Abiya akamwiibhura Asa, ");
INSERT INTO zak_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa akamwiibhura Yehoshafati, Yehoshafati akamwiibhura Yoraamu, Yoraamu akamwiibhura Uzia, ");
INSERT INTO zak_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia akamwiibhura Yotamu, Yotamu akamwiibhura Ahaazi, Ahaazi akamwiibhura Hezekia, ");
INSERT INTO zak_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekia akamwiibhura Manase, Manase akamwiibhura Amoni, Amoni akamwiibhura Yosia, ");
INSERT INTO zak_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na Yosia akamwiibhura Yekonia na bhawamwaabhu, eriibhaga riyo niryo Abhiiziraeri bhaagegirwe bhabhe abhagya mukyaaro kya Babeeri. ");
INSERT INTO zak_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hano Abhiiziraeri bhaagegirwe kugya Babeeri, Yekonia akamwiibhura Shearitieri, Shearitieri akamwiibhura Zerubabeeri, ");
INSERT INTO zak_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeeri akamwiibhura Abihuudi, Abihuudi akamwiibhura Eriakimu, Eriakimu akamwiibhura Azori, ");
INSERT INTO zak_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azori akamwiibhura Zadoki, Zadoki akamwiibhura Akimu, Akimu akamwiibhura Eriudi, ");
INSERT INTO zak_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriudi akamwiibhura Ereazaari, Ereazaari akamwiibhura Matani, Matani akamwiibhura Yaakobo, ");
INSERT INTO zak_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakobo akamwiibhura Yusufu, musubhe wa Mariamu, na Mariamu akamwiibhura Yeesu wuno akubhirikirwa Masiya. ");
INSERT INTO zak_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ambe, okurwa ku Aburahamu okuhikira okwiibhurwa kwo omutemi Daudi zyaari eziinyiibhuro ikumi ni inye. Kweeki, okurwa ku Daudi okuhikira kwiibhaga rino Abhiiziraeri bhaari bhamariri kugegwa kugya Babeeri, zyaari nyiibhuro eziindi ikumi ni inye. Kweeki, okurwa kwiibhaga rino bhaagegirwe bhabhe abhagya, okuhikira okwiibhurwa kwa Masiya, zyaari nyiibhuro eziindi ikumi ni inye. ");
INSERT INTO zak_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Engʼana yo okwiibhurwa kwa Yeesu Krisito niyo yino. Mariamu nina waabhu Yeesu, yaari ayuungiibhwe na Yusufu. Nawe yaari akyaari kuhiindira nawe, Mariamu akarorekana ariinda, enda yino yabhweeni kwo obhunagya bhwe Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusufu omusubhe waaye, yaari omuutu we eheene embere wa Taatabhugya. Ateendiri amusuukye Mariamu, kweego akaamura kumutiga bhwiibhisi. ");
INSERT INTO zak_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nawe hano Yusufu yaari yamwiiri gayo, kituukiro maraika wo Omukuru, Taatabhugya akamutuukira mukirooto, akamubhuurira, “Yusufu, omwaana wo omutemi Daudi, otoobhoha kumukweera Mariamu, kwo okubha enda yiyo ayibhweeni kwo obhunagya bhwe Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ariibhura omwaana we ekisubhe, no omutoge Yeesu, kwo okubha wuyo niwe araatuurye abhaatu okurwa mubhibhi bhyaabhu.” ");
INSERT INTO zak_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gayo goosi gaakorirwe ego, okubha rikuunaane eriingʼana rino Omukuru, Taatabhugya yabhugiri kwe enzira yo omurooti waaye kubha, ");
INSERT INTO zak_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Murore, omukari wuno akyaari kuhiindira no omusubhe aragega enda, neewe ariibhura omwaana we ekisubhe. Niho bharaamubhirikire eriina ryaaye Imanueri.” Obhugazuro bhwe eriina rino ni kubha, Taatabhugya ari hamwe neetwe. ");
INSERT INTO zak_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Hano Yusufu yaabhuukiri, akakora kyeego maraika wo Omukuru, Taatabhugya yamubhuuriiri. Yusufu akamukweera Mariamu, ");
INSERT INTO zak_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","nawe ataahiindiiri neewe tee hano Mariamu yiibhwiiri omwaana we ekisubhe. Yusufu akamutoga omwaana wuyo, Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Okwiibhurwa kwa Yeesu kwatuukiiri mumugye gwa Beterehemu mukyaaro kya Yudea, eriibhaga rino omutemi Herode yaari arakaangata. Ambe, kwe eriibhaga riyo, abharori bhe eziinzota bhano bhaarweereeri ruguru, bhakahika mumugye gwa Yerusaremu. Bhakabhuurya, ");
INSERT INTO zak_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ari hayi wuno yiibhwiirwe abhe omutemi wa Abhayahudi? Tumenyiri kubha yiibhwiirwe, kwo okubha enzota yaaye ya ruguru erorekeeni kweetwe. Kweego, twiiziri kumuseengera.” ");
INSERT INTO zak_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hano omutemi Herode yiigwiiri amangʼana gaabhu, akagwaatwa ne ehaho bhukongʼu. Na abhaatu bhoosi bha Yerusaremu bhakoobhoha, kwo okubha bhakamenya Herode areenda kumwiita. ");
INSERT INTO zak_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Niho Herode akakumania abhakuru bhoosi bha abhaseengeri na abheegya bhe emigiro gya Musa, akabhabhuurya, “Masiya ariibhurirwa hayi?” ");
INSERT INTO zak_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nabho bhakamukyoora, “Ariibhurwa mumugye gwa Beterehemu mukyaaro kya Yudea. Taatabhugya akabhuga kwo okuhitira amakaamo go omurooti waaye kubha, ");
INSERT INTO zak_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Emwe abhaatu bha Beterehemu mukyaaro kya Yuuda, omugye gweenyu gutari musuuhu mubhukaangati bhwe ekyaaro kya Yuuda. Kurwa owaazo ararwamu omukaangati wuno araakaangate abhaatu bhaane bha Iziraeri, kyeego omuriisya akuriisya eziingʼoondu zyaaye.’ ” ");
INSERT INTO zak_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Niho Herode akabhirikira abharori bhe eziinzota bharya kwa bhwiibhisi okubha bhiize bhamubhuurire bhuzomu eriibhaga rino bhaataangiri kurora enzota yirya. ");
INSERT INTO zak_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kyaamwe, akabhatumania Beterehemu, akabhabhuurira, “Mugye mumubhuurye bhuzomu, tee mumenye hano omwaana wuyo ari. Ambe, murimubhona, munireetere amangʼana bhwaangu okubha na neenye nigeende kumuseengera.” ");
INSERT INTO zak_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hano abharori bhe eziinzota bhayo bhiigwiiri amangʼana go omutemi, bhakatanura hayo. Ne enzota yino bhaaruuzi ruguru, yaari erabhakaangata embere waabhu, ekagya ekiimeerera iguru wa ahagiro hano omwaana yaari. ");
INSERT INTO zak_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hano bhaaruuzi hano enzota yirya yeerekirye, bhakazomererwa bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ambe, bhakasikira munyuumba, bhakamurora omwaana ari hamwe na Mariamu nina waabhu, bhakamuhigamira kwo okumuseengera omwaana. Bhakatazura emirigo gyaabhu, bhakamuruusirya omwaana esaambo ye ezahaabu, omuruumbaaso na manemane. ");
INSERT INTO zak_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ambe, Taatabhugya akabharekya mukirooto kubha bhatakyoora ku Herode. Kweego, bhakagya owaabhu kwo okuhitira enzira eyiindi. ");
INSERT INTO zak_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hano abharori bhe eziinzota bhayo bhaari bhatanwiiri, kituukiro, maraika wo Omukuru, Taatabhugya akamutuukira Yusufu mukirooto. Akamubhuurira, “Bhuuka! Ogege omwaana na nina waabhu, mungʼosere Misiri. Mutame eyo tee, hano ndaaze kubhabhuurira mukyoore, kwo okubha Herode areenda kumumoohya omwaana wuyo okubha amwiite.” ");
INSERT INTO zak_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ambe, obhutiku bhuyobhuyo, Yusufu akabhuuka, akamugega omwaana na nina waabhu, akaryaara nabho mukyaaro kya Misiri, ");
INSERT INTO zak_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","bhakasaaga eyo, tee hano Herode yakuuri. Amangʼana gayo gaakorekiri ego, kubha rikuunaane eriingʼana rino Omukuru, Taatabhugya yabhugiri kwe enzira yo omurooti waaye, “Nikamubhirikira omwaana waane kurwa Misiri.” ");
INSERT INTO zak_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hano Herode yaamenyeekereerye kubha abharori bhe eziinzota bharya bhamungʼeeniri, akatiinda bhukongʼu. Niho akatumania abhasirikare bhiite abhaana bhoosi bhe ekisubhe, bhano bhahikirye emyaaka ebhiri no okwiika iyaasi, mumugye gwa Beterehemu hamwe ne emigye gyamu gyoosi. Akakora ego kuriingʼaana ne eriibhaga rirya yabhuuriirwe na abharori bhe eziinzota. ");
INSERT INTO zak_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Niho eriingʼana rikakuunaana rino omurooti Yeremia yabhugiri, ");
INSERT INTO zak_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ekiriro kikarweera mumugye gwa Rama, ekiriro no okwaaramira kwaaru. Raheeri araririra abhaana bhaaye, neewe atakweenda kugosoreribhwa, kwo okubha abhaana bhaaye bhatariho kweeki.” ");
INSERT INTO zak_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hano Herode yakuuri, maraika wo Omukuru, Taatabhugya akamutuukira Yusufu mukirooto Misiri eyo, ");
INSERT INTO zak_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","akamubhuurira, “Bhuuka! Ogege omwaana na nina waabhu, mukyoore mukyaaro kya Iziraeri, bharya bhaari bhakweenda kumwiita omwaana wuyo, bhakuuri.” ");
INSERT INTO zak_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ambe, Yusufu akabhuuka, akamugega omwaana na nina waabhu, akakyoora nabho Iziraeri. ");
INSERT INTO zak_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nawe, hano akiigwa kubha Arikerao omwaana wa Herode yaari arakaangata Yudea, akoobhoha kugya eyo. Taatabhugya akamubhuurira mukirooto kubha atagya eyo kweeki. Kweego, bhakagya mukyaaro kya Gariraaya, ");
INSERT INTO zak_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","bhakahikira mumugye gwa Nazareeti, bhakiikara eyo, okubha rikuunaane eriingʼana rino ryaagaambirwe iguru wa Yeesu kwe enzira ya abharooti kubha, “Arabhirikirwa Omunazareeti.” ");
INSERT INTO zak_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Muziisiku zirya yaariho omuutu wumwe wuno yakubhirikirwa Yohana Omubatiizi. Yohana wuyo yaari ararwaaza mwiitirigo rya Yudea kubha, ");
INSERT INTO zak_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mute ebhibhi bhyeenyu mumwiikyoorere Taatabhugya, kwo okubha obhutemi bhwa mwiisaaro bhubhahikiiri.” ");
INSERT INTO zak_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana niwe wuno yagaambirwe no omurooti Isaya, “Omuutu wuno akubhirikira kwe eriiraka ikuru okurwa mwiitirigo: ‘Mumukorere Omukuru enzira, mugororokye eziinzira zino araahite.’ ” ");
INSERT INTO zak_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Emyeenda gya Yohana gyakorirwe na amabhuri ge engamia na yaari yiibhohiri omukena gwe eriisaakwa mubhukeeneende. Ebhyaakurya bhyaaye bhyaari eziingigi no obhuuki bhwa mwiitirigo. ");
INSERT INTO zak_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abhaatu bhakabha bharamuuzaku okurwa omugye gwa Yerusaremu, ekyaaro kyoosi kya Yudea, na mbaara zyoosi zye Ekitaaro kya Yorodaani. ");
INSERT INTO zak_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Abhaatu bhayo bhakata ebhibhi bhyaabhu, neewe akabha arabhabatiiza mu Kitaaro kya Yorodaani. ");
INSERT INTO zak_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nawe, hano Yohana yaruuzi Abhafarisayo na Abhasadukayo bharamuuzaku kwo obhwaaru okubha abhabatiize, akabhabhuurira, “Emwe orwiibhuro rwe enzoka! Weewi abhabhuuriiri kubha muranagya kuryaara obhutemwa bhwa Taatabhugya bhuno bhukuuza kwo okubatiizwa ego? ");
INSERT INTO zak_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ambe, mukore amahokya gano gakweerekya kubha mumariri kuta ebhibhi bhyeenyu na mumwiikyooreeri Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mutiiseega kubha Taatabhugya arabhiikirirya kyeego mukwiizuungya, ‘Zaazi weetu ni Aburahamu!’ Ndabhabhuurira kubha, Taatabhugya aranagya kukyoosya amagina gano kubha abhaana bha Aburahamu! ");
INSERT INTO zak_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bhoono obhutini bhwe ekiina kya Taatabhugya bhuri iguru weenyu kyeego ehaazi eri iguru ya amatina ge emiti. Na bhano bhatakukora amahokya amazomu bharatinirwa ekiina, kyeego emiti gyoosi gino gitakwiibhura emisumo emizomu gikutinwa no okurekerwa mumuriro. ");
INSERT INTO zak_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ritari ibhaga itaambi, enye ndabhabatiiza kwa amaanzi okweerekya kubha mumariri okuta ebhibhi na mumwiikyooreeri Taatabhugya. Nawe araaza omuutu owuundi inyuma waane wuno akunikira amanaga: Enye nitakungʼarira kubha omuhokya waaye naabhe okutazura eziikobha zye ebhikweera bhyaaye. Ewe niwe arabhabatiiza kwe Ekoro Muhoreeru na kwo omuriro. ");
INSERT INTO zak_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ewe ni kyo omurimi wuno akugwaata oruhuungo mumabhoko gaaye okubha aseese omukuunyu kurwa mungano. Engano yiyo arayikumanirya mukitara kyaaye, nawe omukuunyu, aragwookya mumuriro guno gutakurima.” ");
INSERT INTO zak_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ambe, eriibhaga riyo Yeesu akarwa Gariraaya, akagya ku Yohana mu Kitaaro kya Yorodaani, okubha Yohana amubatiize. ");
INSERT INTO zak_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nawe Yohana akasakya okumurekya, akumubhuurira, “Otakweenderwa wuuze kweenye nikubatiize, nawe neenye nikweenderwa nibatiizwe na naawe?” ");
INSERT INTO zak_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yeesu akamukyoora, “Awe ikirirya onibatiize bhoono, kwo okubha tureenderwa tukore goosi gano Taatabhugya akweenda.” Niho, Yohana akiikirirya, akamubatiiza. ");
INSERT INTO zak_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hano Yeesu yaabatiizirwe no okurwa mumaanzi, kituukiro eriisaaro rikiiguka, akarora Ekoro wa Taatabhugya ariika kye ekiguuti no okwiituura iguru waaye. ");
INSERT INTO zak_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Niho, eriiraka rikarwa mwiisaaro rikabhuga, “Wuno niwe Omwaana waane omuseegwa, nizomereerwe neewe.” ");
INSERT INTO zak_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kyaamwe, Yeesu akakaangatwa ne Ekoro Muhoreeru kugya mwiitirigo, okubha asakibhwe na Seetaani. ");
INSERT INTO zak_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akamara eyo eziisiku miroongo ene (40), obhutiku no omwiisi akiisiitya okurya ebhyaakurya. Kubhuteero, akiigwa enzara bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Niho Seetaani akaaza kumusakya, akamubhuurira, “Aribha awe naawe Omwaana wa Taatabhugya, swaagya amagina gano giikyoore gabhe emikaate.” ");
INSERT INTO zak_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nawe Yeesu akamubhuurira, “Ekaamirwe mu Makaamo Amahoreeru, ‘Omuutu atakunagya kwiikara kwe ebhyaakurya ebhyeene, nawe ariikara kumangʼana goosi gano gakurwa mumunwa gwa Taatabhugya.’” ");
INSERT INTO zak_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Niho Seetaani akamuhira Yeesu mumugye omuhoreeru gwa Yerusaremu, akamwiimeererya kukisoonge kye eriiseengerero rya Taatabhugya, ");
INSERT INTO zak_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akamubhuurira, “Aribha awe naawe Omwaana wa Taatabhugya, irekera haasi. Otakunagya kunyahaarika, ekaamirwe mu Makaamo Amahoreeru, ‘Taatabhugya araswaagya bhamaraika bhaaye kwiiguru waazo, okubha bhakuriihe, nabho bharakugega mumabhoko gaabhu, amaguru gaazo gataaza kwiitema kwiigina ryoryoosi.’ ” ");
INSERT INTO zak_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nawe Yeesu akamubhuurira, “Kweeki ekaamirwe, ‘Otamusakya Omukuru, Taatabhugya waazo.’ ” ");
INSERT INTO zak_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mubhuteero, Seetaani akamuhira Yeesu kukinazo kye ekiguru ekitaambi. Hayo, akamweerekya ebhyaaro bhyoosi bhya mukyaaro hamwe no obhuniibhi bhwamu, ");
INSERT INTO zak_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","akamubhuurira, “Aribha oraanihigamire no okuniseengera, ndakuha bhyoosi bhino.” ");
INSERT INTO zak_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nawe Yeesu akamubhuurira, “Noorwe hano, Seetaani! Ekaamirwe mu Makaamo Amahoreeru, ‘Omuseengere Omukuru, Taatabhugya waazo, omuhokeerye ewe omweene ego.’ ” ");
INSERT INTO zak_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Niho Seetaani akamutiga Yeesu hayo. Hayohayo, bhamaraika bha Taatabhugya bhakaaza okumuhokeerya Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ambe, eriibhaga rirya Yohana yaari abhohirwe munyuumba ya abhabhohwa. Hano Yeesu akiigwa amangʼana gano, akatanura harya, akagya mukyaaro kya Gariraaya, akahika mumugye gwa Nazareeti. ");
INSERT INTO zak_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Niho, Yeesu akasaama okurwa Nazareeti, akagya kwiikara mumugye gwa Kaperinaumu. Omugye guyo gwaari embarika ye Enyaanza ya Gariraaya, orubhaara rwe ekisyooko kya Zaburooni na Nafutaari. ");
INSERT INTO zak_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ekabha ego, okubha rikuunaane eriingʼana rino Taatabhugya yabhugiri kwe enzira yo omurooti Isaya, ");
INSERT INTO zak_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mwiitegeerere, abhaatu bhe ebhyaaro bhya Zaburooni na Nafutaari, ahagiro hano hari munzira yo okweerekera munyaanza, no omwaambuko gwe Ekitaaro kya Yorodaani. Gariraaya eyo niho bhakwaanga abhaatu bhe ebhyaaro ebhiindi. ");
INSERT INTO zak_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Abhaatu bhano bhano mukiikara mukiirima, bharuuzi obhweero bhukuru, na bhano bhiikeeri mukiirima kyo oruku, bhabhariirwe no obhweero bhwe etabhoori.” ");
INSERT INTO zak_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kwe eriibhaga riyo, Yeesu akataanga kurwaazira abhaatu, “Mute ebhibhi bhyeenyu mumwiikyoorere Taatabhugya, kwo okubha obhutemi bhwa mwiisaaro bhubhahikiiri!” ");
INSERT INTO zak_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hano Yeesu yaari akugeenda embarika we Enyaanza ya Gariraaya, akarora abhategi bhabhiri bhe eziiswe, Simooni wuno yakubhirikirwa Petero na wamwaabhu Andurea. Abhabhiri bhayo bhaari bhararekera eziinzero munyaanza, okubha bhagwaatye eziiswe. ");
INSERT INTO zak_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeesu akabhabhuurira, “Muuze, munituniirire! Enye ndabhakora mubhe abhategi bha abhaatu.” ");
INSERT INTO zak_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hayohayo, bhakatiga eziinzero zyaabhu, bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hano Yeesu yageendiri embere hasuuhu, akarora abhaatu abhaandi bhabhiri, Yaakobo na wamwaabhu Yohana, abhaana bha Zebedaayo. Abhabhiri bhayo bhaari mubhwaato hamwe na wiise waabhu, bhaari bharazomya eziinzero zyaabhu. Yeesu akabhabhirikira bhamutuniirire. ");
INSERT INTO zak_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Eriibhaga riyoriyo, bhakatiga obhwaato na wiise waabhu, bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yeesu yaari ariiruguura mukyaaro kyoosi kya Gariraaya. Yaari arasikira muziinyuumba zye eziisaango no okweegya abhaatu muyo. Yaari arabharwaazira Amangʼana Amazomu iguru yo obhutemi bhwa mwiisaaro no okuhorya amarweeri gaabhu goosi. ");
INSERT INTO zak_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Amangʼana iguru wa Yeesu gaari garanyaragana bhukongʼu tee mukyaaro kyoosi kya Siria. Abhaatu bhakamuhirira abharweeri bhaabhu bhoosi bhano bhana amarweeri ge etuubho maanga maaru. Gati waabhu, bhaari bharimu bhano bhakunyaakibhwa bhukongʼu, bhano bhaatiirirwe na amasaambwa amabhi, bhano bhaari ne eriirimu na bhano ebhiimo bhikuuri. Yeesu akabhahorya bhoosi. ");
INSERT INTO zak_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ambe, abhaatu bhaaru bhukongʼu bhakabha bharamutuniirira okurwa Gariraaya, Dekapoori, Yerusaremu, Yudea na mumwaambuko gwe Ekitaaro kya Yorodaani. ");
INSERT INTO zak_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ambe, hano Yeesu yaruuzi esaango ya abhaatu, akatiira kukiguru. Niho akiikara, abhaanabheega bhaaye bhakagya kweewe. ");
INSERT INTO zak_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Neewe akataanga okubheegya, ");
INSERT INTO zak_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Hakiriku bhano bhakwiimenya kubha ni bhataka bhe eziikoro, kwo okubha obhutemi bhwa mwiisaaro ni bhwaabhu. ");
INSERT INTO zak_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Hakiriku bhano bhane ebhigoongi bhoono, kwo okubha Taatabhugya arabhagosorerya. ");
INSERT INTO zak_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hakiriku bhano bhano obhunyoohu, kwo okubha Taatabhugya arabhaha ekyaaro kyoosi. ");
INSERT INTO zak_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hakiriku bhano bhane enzara ne enyoota yo okukora kyeego Taatabhugya akweenda, kwo okubha Taatabhugya arabhiigutya. ");
INSERT INTO zak_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hakiriku bhano bhakurorera ebhigoongi abhaandi, kwo okubha Taatabhugya woosi arabharorera ebhigoongi. ");
INSERT INTO zak_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hakiriku bhano bhane ekoro nzomu, kwo okubha bharamurora Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hakiriku bhano bhakubhiigwaania abhaatu, kwo okubha bharabhirikirwa abhaana bha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Hakiriku bhano bhakunyaakibhwa kwo okukora kyeego Taatabhugya akweenda, kwo okubha obhutemi bhwa mwiisaaro ni bhwaabhu. ");
INSERT INTO zak_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Hakiriku emwe hano abhaatu bhakubhatuka, bhakubhanyaakya no okubhagaambira amabhi kwo orurimi rwa tuubho zyoosi kwo okubha emwe muranituniirira. ");
INSERT INTO zak_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Muhiite kubha ego niigo abhaatu bhaari kubhanyaakya abharooti bhano bhaari bhariho ekare. Kweego, mubhe murazomeererwa no okuriiryaata bhukongʼu, Taatabhugya abhatuuriiri esaambo ekuru mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Emwe ni kyo omuunyu kubhaatu bhoosi. Omuunyu guno gurazoma, nawe eraabhe gusarikiri, guranagyabhwi kuzoma kweeki? Gutakunagya kuhokeeribhwa kweeki kwa kyokyoosi, kweego guriitirwa igutu no okutazwa na abhaatu. ");
INSERT INTO zak_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Emwe ni kyo obhweero kukyaaro. Omugye guno gwoombokirwe iguru ye ekiguru, gutakunagya okwiibhisa. ");
INSERT INTO zak_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kweeki, abhaatu bhatakwaakya etara okumara bhayikuundikirye. Nawe bhahaayituura mukikuumbo okubha yaakire bhoosi bhano bhari munyuumba. ");
INSERT INTO zak_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Egoego na neemwe, obhweero bhweenyu bhureenderwa bhubhare kubhaatu, kubha bhamuguungye Taata weetu wa mwiisaaro hano bhakurora amahokya geenyu amazomu. ");
INSERT INTO zak_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mutiisiga kubha niiziri okubha niruusyeho emigiro gya Musa, kasi gano gaagaambirwe na abharooti. Nitiiziri kugiruusyaho, nawe okubha nierekye obhukuunaanio bhwe eheene bhwagyo. ");
INSERT INTO zak_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ndabhabhuurira obhuheene, tee eriibhaga rino eriisaaro ne ekyaaro bhirarwaho, katariho akangʼana kasi kanukuta ke emigiro kano karaarweho. Emigiro giyo gitakuruusibhwaho tee goosi gakuunaane. ");
INSERT INTO zak_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Omuutu wowoosi wuno akwaanga naabhe omugiro gumwe omusuuhu no okweegya abhaandi bhoosi bhakore ego, wuyo atakubha no obhweera bhwobhwoosi mubhutemi bhwa mwiisaaro. Nawe wowoosi wuno akugigwaata no okweegya abhaandi okubha nabho bhakore ego, wuyo arabha mukuru mubhutemi bhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ambe, ndabhabhuurira kubha, eraabhe mutakukora eheene kukira Abhafarisayo na abheegya bhe emigiro, mutakusikira kimwe mubhutemi bhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwiigwiiri obhuswaagyo bhuno abhaatu bhe ekare bhaabhuuriirwe, ‘Otiita! Omuutu wowoosi wuno akwiita owuundi areenderwa atinirwe ekiina.’ ");
INSERT INTO zak_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nawe enye ndabhabhuurira, omuutu wowoosi wuno akumubhiihirira omurikyaaye, areenderwa atinirwe ekiina ekikuru. Kweeki, wowoosi wuno akumutuka omurikyaaye, areenderwa atinirwe ekiina, mukiina ekikuru. Kweeki, wowoosi wuno akumutuka omurikyaaye, ‘Awe mugeege,’ areenderwa okurekerwa mumuriro gwa nyaari! ");
INSERT INTO zak_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ambe, eraabhe oraruusya ekimweeso ahagiro ho okuruusirya ekimweeso, okumara orahiita kubha otiindireeni no omurikyaazo, ");
INSERT INTO zak_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tiga ekimweeso kyaazo embere wa ahagiro ho okuruusirya ekimweeso, noogye hiinga wiigwaane nawe. Niho okyoore oruusye ekimweeso kyaazo. ");
INSERT INTO zak_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Eraabhe omuutu arakuhira kumutini we ekiina, ereenderwa wiigwaane nawe bhwaangu hano mukubha munzira. Oraatame okukora ego, arakuhikya kumutini we ekiina, omutini we ekiina neewe arakugwaatya kumusirikare okubha obhohwe munyuumba ya abhabhohwa. ");
INSERT INTO zak_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ndakubhuurira obhuheene, otakurwamu tee hano oraamare okuriha esiiri yoosi! ");
INSERT INTO zak_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwiigwiiri obhuswaagyo bhuno bhukubhuga, ‘Otaseebheeta!’ ");
INSERT INTO zak_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nawe enye ndabhabhuurira, omusubhe wowoosi wuno akumurora omukari kwo okwiigoomba, amariri kuseebheeta nawe mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ambe, eraabhe eriiso ryaazo ryo obhuryo rigirirye okore ebhibhi, oriihe no okurirekera kure. Ni kisi okubhurya ekiimo kimwe bhoono, kukira omubhiri gwaazo gwoosi gurekerwe mumuriro gwa nyaari. ");
INSERT INTO zak_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Eraabhe okubhoko kwaazo kwo obhuryo kuragirya okore ebhibhi, okutine no okukurekera kure. Ni kisi kubhurya ekiimo kimwe bhoono, kukira omubhiri gwaazo gwoosi kusikibhwa mumuriro gwa nyaari. ");
INSERT INTO zak_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kweeki, mwiigwiiri obhuswaagyo bhuno bhukubhuga, ‘Omuutu wowoosi wuno akutaana na mukaaye, amuhe enyaarubha yo okutaana.’ ");
INSERT INTO zak_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nawe enye ndabhabhuurira kubha, omuutu wowoosi wuno akutaana na mukaaye, etari kwe ekigirirye kyo obhutuungiri, aramukora omukaaye kubha museebheeti hano araakweerwe kweeki. Na wowoosi wuno araakweere omukari wuyo, aseebheetiri. ");
INSERT INTO zak_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mwiigwiiri obhuswaagyo bhuno abhaatu bhe ekare bhaabhuuriirwe, ‘Mutasarya obhwiirahiri bhuno mwiirahiiri embere wo Omukuru, Taatabhugya, nawe mukore goosi gano mwiirahiiri.’ ");
INSERT INTO zak_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nawe enye ndabhabhuurira, mutiirahira ku kyokyoosi! Mutiirahira eriisaaro, kwo okubha niryo ekituumbi kyo obhutemi bhwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Naabhe mutiirahira kwe ekyaaro kino, kwo okubha niho Taatabhugya akutuura amaguru gaaye. Naabhe mutiirahira Yerusaremu, kwo okubha nigwo omugye gwo Omutemi omukuru, Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Naabhe mutiirahira kwe emitwe gyeenyu, kwo okubha mutakunagya kukirania naabhe oruzweeri rumwe rubhe rurabhu kasi rumwaamu. ");
INSERT INTO zak_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eraabhe muriikirirya engʼana, mubhuge ‘Hee’ ne eraabhe muraanga, mubhuge ‘Zeyi.’ Amangʼana goosi gano gakukira gayo, gararwa ku Seetaani, omubhi wurya. ");
INSERT INTO zak_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwiigwiiri obhuswaagyo bhuno bhukubhuga, ‘Eriiso kwe eriiso, ne eriino kwe eriino.’ ");
INSERT INTO zak_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nawe enye ndabhabhuurira, mutarihya obhubhi omuutu wuno abhakoreeri obhubhi. Nawe eraabhe omuutu akutemiri etama yo obhuryo, mukyooserye na yo obhumosi yoosi. ");
INSERT INTO zak_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kweeki, eraabhe omuutu akusemiri areenda ahaanwe eriigooti ryaazo, mutigire agege ne ekabhuuti yoosi. ");
INSERT INTO zak_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kweeki, eraabhe omuutu arakuhatika kugega omurigo gwaaye tee kugeenda amataambuka kikwe kimwe (1,000), awe noogye nawe amataambuka bhikwe bhibhiri (2,000). ");
INSERT INTO zak_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Eraabhe omuutu arakusabha ekigiro, muhe. Ne eraabhe omuutu arasabha obhura muunda, otamwiima. ");
INSERT INTO zak_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwiigwiiri kyeego obhuswaagyo bhukubhuga, ‘Omuseege omurikyaazo,’ na abhaatu bharabhuga, ‘Omubhiihirirye omubhisa.’ ");
INSERT INTO zak_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nawe enye ndabhabhuurira, mubhe muraseega abhabhisa bheenyu, na mubhe murabhasabhira bhano bhakubhanyaakya. ");
INSERT INTO zak_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ambe, murikora ego, hayo niho mukutuubhana na Wuuso weenyu wa mwiisaaro. Ewe niwe akubhabharira omubhaso abhaatu abhazomu na abhabhi. Kweeki, arabhatweekerya embura abhaatu bhe eheene hamwe na abhaatu bhe ebhibhi. ");
INSERT INTO zak_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eraabhe muraseega bhano bhakubhaseega emwe, murabhona saamboki? Naabhe abhatobhya bhe eriigooti nabho bharaseega bhano bhakubhaseega. ");
INSERT INTO zak_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kweeki, eraabhe murabhakeerya abharikyeenyu abheene, murabha mukoririki kukira abhaandi? Naabhe abhaatu bhano bhatamumenyiri Taatabhugya, neebho bharabhakeerya abharikyaabhu. ");
INSERT INTO zak_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ambe, mubhe abhaheene, kyeego Wuuso weenyu wa mwiisaaro ari muheene.” ");
INSERT INTO zak_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Murore! Mutakora amahokya amazomu embere ya abhaatu bhabharore. Eraabhe murakora ego, mutakusuungʼaana esaambo yoyoosi okurwa ku Wuuso weenyu wa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ambe, hano okusakirya abhataka, otaraarika kino okukora. Abhabheehi bharakora ego muziinyuumba zye eziisaango na kunzira okubha abhaatu bhabhakumye. ");
INSERT INTO zak_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ndabhabhuurira obhuheene, bhamariri okusuungʼaana esaambo yaabhu yoosi. Nawe hano okusakirya abhataka, okubhoko kwaazo kwo obhumosi kutamenya gano okubhoko kwo obhuryo kukuruusya, ");
INSERT INTO zak_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","okubha obhusakirya bhwaazo bhubhe bhwa bhwiibhisi. Orikora ego, Wuuso weenyu wuno akurora goosi, arakuha esaambo. ");
INSERT INTO zak_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kweeki, hano mukumusabha Taatabhugya, mutabha kya abhabheehi. Bhayo bharaseega okusabha bhiimeereeri muziinyuumba zye eziisaango na mumaahukano ge enzira okubha abhaatu bhabharore. Ndabhabhuurira obhuheene, bhamariri okusuungʼaana esaambo yaabhu yoosi. ");
INSERT INTO zak_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nawe awe hano okusabha, osikire mukyuumba na wiigare ekiseku. Niho osabhe ku Wuuso, wuno ari hamwe naawe mumbiso. Na Wuuso wuno akurora mumbiso arakuha esaambo. ");
INSERT INTO zak_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hano mukusabha, mutabha muramwaayamwaaya kya abhaatu bhano bhatamumenyiri Taatabhugya. Ebho bhariiseega kubha bhariigweerwa kwa amangʼana gaabhu maaru. ");
INSERT INTO zak_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mutabha murasabha kye ebho, kwo okubha Wuuso weenyu amenyiri gano mukweenda, naabhe hano mukyaari kumusabha. ");
INSERT INTO zak_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kweego, emwe musabhe Taatabhugya kyeego ego, ‘Taata weetu wa mwiisaaro, eriina ryaazo riguungibhwe. Obhutemi bhwaazo bhuuze. ");
INSERT INTO zak_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Obhuseegi bhwaazo bhukorwe mukyaaro hano, na kyeego bhukukorwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Otuhe eziisiku zyoosi ebhyaakurya bhyeetu. ");
INSERT INTO zak_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Otwaabhire ebhibhi bhyeetu, kyeego etwe twoosi tukubhaabhira bhano bhakutusariirya. ");
INSERT INTO zak_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Oturiihe mubhitiika, nawe otutuurye no omubhi wurya, kwo okubha obhutemi ni bhwaazo, na amanaga, no obhuguungo, kirakeego! Gabhe ego!’ ” ");
INSERT INTO zak_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Yeesu akageenderera kubhuga, “Eraabhe murabhaabhira abhaandi ebhibhi bhyaabhu, Wuuso weenyu wa mwiisaaro arabhaabhira emwe kweeki ebhibhi bhyeenyu. ");
INSERT INTO zak_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nawe eraabhe mutakwaabhira abhaandi, Wuuso weenyu wuno ari mwiisaaro neewe atakubhaabhira emwe ebhibhi bhyeenyu. ");
INSERT INTO zak_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Hano mukwiisiitya ebhyaakurya, obhusyo bhweenyu bhuteerekya ebhigoongi kya abhabheehi. Bhayo bharakikinyara okubha abhaatu bharore kubha bhiisiitirye ebhyaakurya. Ndabhabhuurira obhuheene, bhamariri okusuungʼaana esaambo yaabhu yoosi. ");
INSERT INTO zak_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nawe awe hano wiisiitirye ebhyaakurya, wiisaabhe obhusyo bhwaazo no ohake amaguta mumutwe gwaazo, ");
INSERT INTO zak_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","okubha abhaatu bhatamenya kubha wiisiitirye ebhyaakurya, nawe amenye Wuuso weenyu wuno ari hamwe naawe mumbiso. Niho ewe wuno akurora goosi, arakuha esaambo. ");
INSERT INTO zak_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mutiibhiikira ekibhuumbiko mukyaaro kino, hano eziisere no omweenyi bhirasarya, na abhiibhi bharabhuna enyuumba okubha bhiibhe. ");
INSERT INTO zak_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nawe mubhiike eziihata mwiisaaro, hano eziisere no omweenyi bhitakusarya na hano abhiibhi bhatakubhuna okubha bhiibhe. ");
INSERT INTO zak_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ahagiro hano mukubhiika eziihata zyeenyu, hayo niho ne eziikoro zyeenyu zikubha. ");
INSERT INTO zak_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ameeso nigo etara yo omubhiri. Eraabhe ameeso gaazo gararora bhuzomu, omubhiri gwaazo gwoosi gurabha no obhweero. ");
INSERT INTO zak_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nawe eraabhe ameeso gaazo ni masariku, omubhiri gwaazo gwoosi gurabha ne ekiirima. Ambe, eraabhe obhweero muusi waazo bhutari bhweero, ambe ekiirima nikyo ekikuru bhukongʼu! ");
INSERT INTO zak_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Atariho omuutu wuno akunagya kuhokeerya abhakuru bhabhiri kwe eriibhaga rimwe. Yaangakoriri ego, aranagya okumubhiihirirya omukuru owumwe no okuseega owuundi, kasi kugwaatana no owumwe no okuzeera owuundi. Kweego na neemwe, mutakunagya okumuhokeerya Taatabhugya ne eziimbirya kwe eriibhaga rimwe! ");
INSERT INTO zak_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ambe, ndabhabhuurira kubha, mutabha no obhwiitiimaati iguru yo obhwiikari bhweenyu, etari iguru yo okuryaki kasi munyweki kasi mwiibhoheki. Mbe, mweebhiri kubha obhwiikari bhurakira ebhyaakurya, no omubhiri gurakira emyeenda? ");
INSERT INTO zak_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Murore ebhinyonyi. Bhitakweemya, bhitakugesa naabhe okubhiika ebhyaakurya mukitara. Nawe, Wuuso weenyu wa mwiisaaro, arabhariisya. Ambe emwe, ni bho obhweera bhukongʼu kukira ebhinyonyi bhiyo! ");
INSERT INTO zak_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni weewi gatigati weenyu wuno akunagya kwiiyoongerya naabhe esa yimwe mubhwiikari bhwaaye kwo obhwiitiimaati? ");
INSERT INTO zak_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kwaki muriitiimaata iguru ye emyeenda? Murore kyeego ebhibharyo mumuguundu bhikunyenyeeta. Bhitakukora emirimo naabhe bhitakwoogosa. ");
INSERT INTO zak_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nawe ndabhabhuurira kubha, naabhe omutemi Soromooni mubhwaame bhwaaye bhwoosi, atiibhohiri bhuzomu kye ebhibharyo bhiyo! ");
INSERT INTO zak_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ambe, eraabhe Taatabhugya arabhiibhohya kisi kye ebhibharyo bhya mwiitirigo, bhino bhiriho reero nawe tabhoori bhirarekerwa mumuriro, mbe, Taatabhugya atakukira okubhiibhohya emwe, emwe bho obhwiikirirya bhusuuhu? ");
INSERT INTO zak_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kweego, mutabha no obhwiitiimaati mukwiibhuurya kubha, ‘Turaryaki?’ kasi ‘Turanywaki?’ kasi ‘Turiibhohaki?’ ");
INSERT INTO zak_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Amangʼana gayo goosi, abhaatu bhano bhatamumenyiri Taatabhugya bhariinyaakya nago. Wuuso weenyu wa mwiisaaro amenyiri kisi kubha mureenda gayo goosi. ");
INSERT INTO zak_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bhoono emwe, mukore amangʼana go obhutemi bhwa Taatabhugya gabhe go okutaanga mubhwiikari bhweenyu, na mukore kyeego akweenda ewe. Hayo niho agaandi goosi arabhoongereererya. ");
INSERT INTO zak_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ambe, mutabha no obhwiitiimaati iguru ya tabhoori, kwo okubha tabhoori eriinyaakira eyeene. Enyaako ya reero eriisa kwa reero.” ");
INSERT INTO zak_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mutabha muratinira ekiina abhaandi, okubha Taatabhugya ataaza abhatinire ekiina emwe. ");
INSERT INTO zak_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kyeego mukutinira ekiina abhaandi, niigo kyeego Taatabhugya araabhatinire emwe. Ne ekireengo kino mukureengera abhaandi, nikyo kino Taatabhugya araabhareengere emwe. ");
INSERT INTO zak_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ndora orarora ekibhorooryo kino kiri muriiso ryo omurikyaazo, nawe otakurora ekiti kino kiri muriiso ryaazo? ");
INSERT INTO zak_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nibhwi oranagya kumubhuurira omurikyaazo, ‘Tiga nikuruusye ekibhorooryo muriiso ryaazo,’ eriibhaga awe omweene one ekiti muriiso ryaazo? ");
INSERT INTO zak_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Awe ni mubheehi! Ruusya ekiti kino kiri muriiso ryaazo. Niho okunagya kurora bhuzomu no okuruusya ekibhorooryo kino kiri muriiso ryo omurikyaazo. ");
INSERT INTO zak_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mutaziha eziimbwa ebhigiro ebhihoreeru, kwo okubha ziriikyoora zibhangʼaarure. Kweeki, mutazitaasira eziimbiizi ebhigiro bhyo obhuguri bhukuru, kwo okubha zirabhitazataza. ");
INSERT INTO zak_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mumusabhe Taatabhugya, neewe arabhaha kino mukusabha. Mukomye okurwa ku Taatabhugya, neewe arabhaha kino mukukomya. Mubhuge hanoo, niho Taatabhugya arabhiigurira ekiseku. ");
INSERT INTO zak_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Omuutu wowoosi wuno akusabha, arahaabhwa wuno akukomya, arabhona, na wuno akubhuga hanoo, ariigurirwa. ");
INSERT INTO zak_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Mbe, ariho omuutu gati weenyu, eraabhe omwaana waaye araamusabhe omukaate, aramuha eriigina? ");
INSERT INTO zak_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kasi araamusabhe eswe, aramuha enzoka? ");
INSERT INTO zak_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bhoono, yiingabha emwe mbabhi, nawe mumenyiri okubhaha abhaana bheenyu ebhigiro ebhizomu. Ambe, Wuuso weenyu wa mwiisaaro atakutura okubhaha amazomu bhano bhakumusabha? ");
INSERT INTO zak_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ambe, emwe mubhe murabhakorera abhaatu abhaandi kyeego mukweenda bhabhakorere emwe. Bhuyo nibhwo obhugazuro bhwe emigiro gya Musa na ameegyo ga abharooti. ");
INSERT INTO zak_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Musikire kwo okuhitira ekiseku ekiguti, kwo okubha ekiseku kigari kireerekera mubhusikya, ne enzira yo okweerekera eyo ni ngari, na abhaatu bhano bhakuyigyaku ni bhaaru. ");
INSERT INTO zak_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nawe ekiseku kyo okugya mubhuhoru ni kiseku ekinyerere, ne enzira yo okweerekera eyo ni kongʼu. Abhaatu bhano bhakuyigyaku ni bhasuuhu. ");
INSERT INTO zak_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwiiriihe na abharooti bho orurimi. Hano bharaabhiizeku, bhariikora bhanyoohu kye engʼoondu, nawe obhuheene ni kubha, mbahaari kye esuuzi. ");
INSERT INTO zak_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Murabhamenya kwe emisumo gyaabhu. Abhaatu bhatakugesa eziizabibu kumiti gya amahwa, naabhe bhatakugesa etiini kumiti gye emichongoma. ");
INSERT INTO zak_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Omuti omuzomu guhiibhura emisumo emizomu, nawe omuti omubhiihu guhiibhura emisumo emibhi. ");
INSERT INTO zak_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Omuti omuzomu gutakunagya kwiibhura emisumo emibhi, no omuti omubhi gutakunagya okwiibhura emisumo emizomu. ");
INSERT INTO zak_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Emiti gyoosi gino gitakwiibhura emisumo emizomu, giratinwa no okurekerwa mumuriro. ");
INSERT INTO zak_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kweego, abharooti bho orurimi, murabhamenya kwe emisumo gyaabhu. ");
INSERT INTO zak_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Atariho omuutu wuyo woosi wuno akunibhirikira, ‘Ee Omukuru, ee Omukuru,’ araaza kusikira mubhutemi bhwa mwiisaaro. Nawe omuutu wuno akukora obhuseegi bhwa Taata waane wa mwiisaaro, wuyo niwe araasikire muyo. ");
INSERT INTO zak_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kurusiku rwo okutina ekiina runo rukuuza, abhaaru bharanibhuurira, ‘Ee Omukuru, ee Omukuru! Orahiita kubha, tukaruusya obhurooti kwe eriina ryaazo? Na tukaheebha amasaambwa amabhi kwe eriina ryaazo na tukakora ebhitiika bhyaaru kwe eriina ryaazo?’ ");
INSERT INTO zak_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Niho, ndaabhabhuurire kubhweero kubha, ‘Nitabhamenyiri emwe naabhe hasuuhu! Murwe hano, emwe abhatemya bho obhubhi!’ ");
INSERT INTO zak_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ambe, omuutu wowoosi wuno akwiigwa amangʼana gaane no okugakora, ni kyo omuutu wa amangʼeeni wuno akoomboka enyuumba yaaye kwiitare. ");
INSERT INTO zak_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Orusiku rumwe, embura ekatweeka, ebhitaaro bhikiizura amaanzi zabhi, no omukama omuhaari gukahuumbuuta no okuhuna enyuumba yaaye. Nawe enyuumba yiyo etaagwiiri haasi, kwo okubha obhurusa bhwaaye bhwaari bhwoombokirwe kwiitare. ");
INSERT INTO zak_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nawe omuutu wowoosi wuno akwiigwa amangʼana gaane na atakukora, wuyo ni kyo omuutu omugeege wuno akoomboka enyuumba yaaye kumarobha. ");
INSERT INTO zak_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hano embura yatweekiri, ebhitaaro bhikiizura amaanzi zabhi, no omukama muhaari gukahuumbuuta no okuhuna enyuumba yaaye, hayohayo enyuumba yiyo ekagwa haasi ekasarika bhukongʼu.” ");
INSERT INTO zak_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hano Yeesu yamariri okugaamba amangʼana gayo goosi, esaango ya abhaatu ekabha eraruguura bhukongʼu iguru ya ameegyo gaaye. ");
INSERT INTO zak_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Abhaatu bhaari bharuguuriri, kwo okubha ameegyo gaaye gatabheeri kya garya ga abheegya bhaabhu bhe emigiro, nawe akeegya kyo omuutu wuno ano obhuturo. ");
INSERT INTO zak_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Hano Yeesu yiikiiri mukiguru hayo, esaango ya abhaatu ekamutuniirira. ");
INSERT INTO zak_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Rora! Omuutu wumwe we ebhigeenge akaaza, akahigama embere wa Yeesu, akamubhuurira, “Ee Omukuru, nimenyiri oranagya okunihorya okubha nieribhwe. Eraabhe oryeende, ndasabha onihorye!” ");
INSERT INTO zak_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yeesu akagororokya okubhoko kwaaye, akamubhataku, akamubhuurira, “Ndeenda ohore, weeribhwe!” Hayohayo, akahora obhurweeri bhwaaye. ");
INSERT INTO zak_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kyaamwe, Yeesu akamubhuurira, “Itegeerera, otamubhuurira muutu wowoosi iguru ya rino! Nawe wiiyeerekye kumuseengeri, oruusye ekimweeso kyeego emigiro gya Musa gikuswaagya, okubha weerekye abhaatu kubha weeriibhwe.” ");
INSERT INTO zak_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hano Yeesu yasikiiri mumugye gwa Kaperinaumu, omukuru owumwe wa abhasirikare bhe Ekirooma akaaza kweewe kusabha obhusakirya. ");
INSERT INTO zak_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Akamubhuurira, “Ee Omukuru, nino omuhokya munyuumba aremeeri, ariigwa obhururu bhukongʼu.” ");
INSERT INTO zak_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu akamubhuurira, “Ndaaza kumuhorya.” ");
INSERT INTO zak_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kyaamwe omukuru wa abhasirikare wuyo akamubhuurira, “Ee Omukuru, nitakungʼarira osikire owaane. Nawe gaamba engʼana yimwe ego, omuhokya waane arahora. ");
INSERT INTO zak_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nimenyiri arahora, kwo okubha enye noosi niri iyaasi wa abhakuru bhaane, na ninabho abhasirikare iyaasi waane. Ndaamubhuurire owumwe, ‘Noogye,’ aragya. Ndaamubhuurire owuundi, ‘Nawuuze,’ woosi araaza. No omugya waane, ndaamubhuurire, ‘Kora ego,’ niigo araakore.” ");
INSERT INTO zak_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hano Yeesu yiigwiiri amangʼana gayo, akaruguura bhukongʼu. Akabhabhuurira bhano bhaari bharamutuniirira, “Ndabhabhuurira obhuheene, naabhe gati wa Abhiiziraeri bhoosi, nikyaari kurora omuutu wowoosi wo obhwiikirirya bhukuru kya bhuno! ");
INSERT INTO zak_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndabhabhuurira kubha, abhaatu bhaaru bhararwa mumbaara zyoosi zye ekyaaro kusikira mubhutemi bhwa mwiisaaro. Bharaaza kurya munyaangi yirya hamwe na bhazaazi bheetu Aburahamu, Isaaka na Yaakobo. ");
INSERT INTO zak_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nawe Abhayahudi abhaandi bhano bheendirwe kubha mubhutemi bhuyo, bhararekerwa igutu mukiirima, eyo bharabha bhararira no okusaanania ameeno.” ");
INSERT INTO zak_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ambe, Yeesu akamubhuurira omukuru wuyo, “Noogye yiika. Erabha kyeego wiikiriirye.” Omubhagati waaye akahora kwiibhaga riyoriyo. ");
INSERT INTO zak_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kyaamwe, Yeesu akahika munyuumba ya Petero. Hano yasikiiri muyo, akamubhona inyibhyaara Petero ahiindiiri kubhuriri, yaari arwaariri ehooma haari. ");
INSERT INTO zak_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yeesu akamubhataku mukubhoko, rugeendo rumwe akahora ehooma yirya. Niho akabhuuka, akataanga okumuhokeerya Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hano yahikiri engoroobha, Yeesu akareeterwa abhaatu bhaaru bhano bhaari bhaatiirirwe amasaambwa amabhi. Neewe akaheebha amasaambwa gayo kwe engʼana yaaye. Kweeki, akahorya abhaatu bhoosi bhano bhaari bharwaariri. ");
INSERT INTO zak_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yeesu akakora gayo goosi, okubha rikuunaane eriingʼana rino ryaagaambirwe iguru waaye no omurooti Isaya, “Ewe omweene akagega obhunyookobhu bhweetu, akaruusyaho amarweeri geetu.” ");
INSERT INTO zak_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hano Yeesu yaruuzi kubha abhaatu bhaaru bhamwiiruguuriri, akaswaagya abhaanabheega bhaaye kubha, bhaambuke enyaanza. ");
INSERT INTO zak_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ambe, omweegya owumwe we emigiro akamwiisukira Yeesu, akamubhuurira, “Ee Omweegya, hohoosi hano oraagye, enye ndakutuniirira.” ");
INSERT INTO zak_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu akamukyoora, “Bhanyamubhwe bhana amabhigi ne ebhinyonyi bhine ebhinyuumba, nawe enye Omwaana wo Omuutu, nitana naabhe ho okuhiindirya omutwe gwaane.” ");
INSERT INTO zak_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ambe, omwaanamweega owuundi wa Yeesu akamubhuurira, “Ee Omukuru, oniikirirye nigye hiinga okumubhiika taata waane.” ");
INSERT INTO zak_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu akamukyoora, “Awe onituniirire. Tiga bhano bhakuuri mumitima gyaabhu bhabhabhiike abhaku bhaabhu.” ");
INSERT INTO zak_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ambe, Yeesu akasikira mubhwaato, na abhaanabheega bhaaye bhakamutuniirira muyo. ");
INSERT INTO zak_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hano bhaahikiri gatigati ye enyaanza, kituukiro hakabha no omukama muhaari bhukongʼu na amabhooka gakataanga okusikira mubhwaato. Nawe Yeesu yaari ahiindiiri eziitiro. ");
INSERT INTO zak_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abhaanabheega bhaaye bhakamugyaku, bhakamubhuukya bhakubhuga, “Ee Omukuru, otutuurye! Turasika!” ");
INSERT INTO zak_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yeesu akabhabhuurira, “Emwe bho obhwiikirirya bhusuuhu, kwaki muroobhoha?” Niho akiimeerera, akarekya omukama na amabhooka. Rugeendo rumwe, enyaanza ekahoreera bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abhaanabheega bhaaye bhakaruguura, bhakabhuga, “Omuutu wuno ni wa tuubhoki? Naabhe omukama na amabhooka bhiramwiigwa!” ");
INSERT INTO zak_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hano Yeesu yaambukiri enyaanza, akahika mukyaaro kya Abhagadara. Akasikana na abhaatu bhabhiri bha amasaambwa amabhi. Abhaatu bhayo bhakarweera mumabhigi ge eziimbiihira muno bhahiikara muyo. Bhoosi bhaari bhahaari bhukongʼu na ataariho omuutu wuno yasakirye kuhita enzira yiyo. ");
INSERT INTO zak_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ambe, hano abhaatu bhabhiri bhayo bhaasikeeni neewe, amasaambwa gakatema ekituri garabhuga, “Ee Omwaana wa Taatabhugya, otatunyaakya twoosi! Otwiiziiri otumare? Mbe, wiiziri kutusikya naabhe eriibhaga rino Taatabhugya yatuuriri hayo rikyaari kuhika?” ");
INSERT INTO zak_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Haguhi hayo, bhaari bhariho abhariisya bhe eziimbiizi bhaari bharariisya eriihizo ikuru rye eziimbiizi. ");
INSERT INTO zak_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Niho amasaambwa gayo gakamwiisasaama Yeesu, “Eraabhe oratuheebha, otwiikirirye tusikire mwiihizo rirya rye eziimbiizi.” ");
INSERT INTO zak_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Neewe akagabhuurira, “Mugeende!” Ambe, amasaambwa gakarwa kubhaatu bhayo, gakagya kusikira kwa nguru muziimbiizi zirya. Hayohayo, eriihizo ryoosi rikahiriingita kwa bhwaangu kumuhiriingito muhaari, rikatubhira ryoosi mumaanzi, rikasika. ");
INSERT INTO zak_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hano abhariisya bhe eziimbiizi bhaaruuzi gayo, bhakaryaarira mwiiboma. Mwiiboma muyo, bhakaraarikira abhaatu goosi gano gaatuukiri na kino kyatuukiiri bha amasaambwa. ");
INSERT INTO zak_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Abhaatu bhoosi bha mwiiboma muyo, bhakaryaara kugya kumurora Yeesu. Hano bhaamuruuzi, bhakamwiisasaama bhukongʼu kubha ageende mukyaaro kyaabhu. ");
INSERT INTO zak_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ambe, Yeesu akatiira mubhwaato, akaambuka Enyaanza ya Gariraaya, akakyoora Kaperinaumu, omugye guno akiikara muyo. ");
INSERT INTO zak_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hano yahikiri eyo, abhaatu abhaandi bhamugegiri omuutu wuno yaari akuuri ebhiimo, ahiindiiri kukiigi. Hano Yeesu yaruuzi obhwiikirirya bhwaabhu, akamubhuurira omurweeri wuyo, “Ee omwaana waane, tema ekubhi! Nikwaabhiiri ebhibhi bhyaazo.” ");
INSERT INTO zak_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Niho abheegya abhaandi bhe emigiro bhano bhaari bhariho hayo bhakiigaambira muziikoro zyaabhu, “Omuutu wuno akumutuka Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nawe Yeesu akamenya goosi gano bhaari bhakwiiseega, akabhabhuurya, “Ndora, muriiseega amabhiihu muziikoro zyeenyu? ");
INSERT INTO zak_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni riihe eriihuhu bhukongʼu, okumubhuurira, ‘Nikwaabhiiri ebhibhi bhyaazo,’ kasi okumubhuurira, ‘Imeerera, ogeende’? ");
INSERT INTO zak_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nawe, ndeenda mumenye bhuzomu kubha, enye Omwaana wo Omuutu, nino obhuturo bhwo okwaabhira ebhibhi mukyaaro kino.” Niho Yeesu akamubhuurira omuutu wuyo yaari akuuri ebhiimo, “Imeerera! Gega obhuriri bhwaazo, noogye yiika.” ");
INSERT INTO zak_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hayohayo, akiimeerera, akagya yiika. ");
INSERT INTO zak_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hano abhaatu bhaaruuzi gayo, bhakaruguura no okwoobhoha bhukongʼu. Bhakamukumya Taatabhugya wuno yabhaheeri abhaatu obhuturo kya bhuyo. ");
INSERT INTO zak_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hano Yeesu yatanwiiri hayo, akasikana no omutobhya we eriigooti wuno yakubhirikirwa Mataayo, yiikeeri mwiitobhero ryaaye ryo okutinira eriigooti haguhi ne enzira. Yeesu akamubhuurira, “Nituniirira.” Rugeendo rumwe, Mataayo akiimeerera, akamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ambe, Yeesu akagya kurya ebhyaakurya wa Mataayo hamwe na abhaanabheega bhaaye. Hano bhaari muyo, bhakasikira abhatobhya bhe eriigooti na abhaatu bhe ebhibhi bhaaru, bhaari bhararya hamwe na Yeesu na abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hano Abhafarisayo bhaaruuzi gayo, bhakabhuurya abhaanabheega bha Yeesu, “Ndora, omweegya weenyu ararya hamwe na abhatobhya bhe eriigooti na abhaandi bhe ebhibhi?” ");
INSERT INTO zak_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hano Yeesu yiigwiiri amangʼana gaabhu, akabhabhuurira, “Abhaatu abhahoru bhatakweenda mugabhu, nawe abharweeri nibho bhakumweenda! ");
INSERT INTO zak_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ambe, mweege obhugazuro bhwa amangʼana ga Taatabhugya mu Makaamo Amahoreeru akubhuga, ‘Ndeenda mweerekye ebhigoongi kukira okuruusya ekimweeso kyeenyu.’ Ambe, enye nitiiziri kubhirikira abhaatu bhe eheene bhamwiikyoorere Taatabhugya, nawe abhaatu bhe ebhibhi.” ");
INSERT INTO zak_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Niho abhaanabheega bha Yohana Omubatiizi bhakaaza ku Yeesu, bhakamubhuurya, “Etwe na Abhafarisayo obhona turiisiitya ebhyaakurya. Mbe, ni kwaki abhaanabheega bhaazo bhatakwiisiitya ebhyaakurya?” ");
INSERT INTO zak_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeesu akabhakyoora, “Abhasaani bho omukweeri bhano bharaarikirwe munyaangi yo obhweenga, bharanagyabhwi kubha ne ebhigoongi eriibhaga bhari hamwe no omukweeri? Nawe orusiku ruraaza runo omukweeri araaruusibhweho gati wa abhasaani bhaaye. Hayo niho abhasaani bhaaye bhakubha ne ebhigoongi no okwiisiitya ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Okusaangya ameegyo gaane amahya ne eziinyaangi zyeenyu kutuubheeni no okutuma ekiraka kyo omweenda omuhya kumweenda omukuungu. Ekiraka ekihya kiraraandura omweenda guyo no okwoongerya hano haraandukiri. ");
INSERT INTO zak_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kweeki, atariho omuutu wuno akwiituruurira amaanzi amahya go omuzabibu mukiribha ekikuungu. Eraabhe arakora ego, ekiribha kiraatika, amaanzi go omuzabibu gariitika goosi. Nawe, abhaatu obhona bharatuura amaanzi amahya go omuzabibu mukiribha ekihya. Kweego, ekiribha ekihya na amaanzi amahya go omuzabibu bhyoosi bhibhiri bhirabha bhwaheene.” ");
INSERT INTO zak_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hano Yeesu akyaakeerenia gayo, rugeendo rumwe akaaza omukaangati owumwe wa munyuumba ye esaango, akahigama embere waaye, akamubhuurira, “Omuukya waane akuuri bhoono ego! Nawe, tugye otuure okubhoko kwaazo iguru waaye, neewe arabha muhoru kweeki.” ");
INSERT INTO zak_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Niho, Yeesu akatanura hamwe na abhaanabheega bhaaye, bhakamutuniirira omukaangati wurya. ");
INSERT INTO zak_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ambe, eriibhaga riyoriyo omukari owumwe wuno yaari anyaakiibhwe no obhurweeri bhwo obhureegu kwe emyaaka ikumi ne ebhiri, akaaza inyuma wa Yeesu, akakuniaku omuriingo gwo omweenda gwaaye. ");
INSERT INTO zak_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwo okubha yaari ariigaambira mukoro yaaye, “Eraabhe ndakuniaku omweenda gwaaye ego, ndahora.” ");
INSERT INTO zak_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hano akakuniaku, hayohayo Yeesu akiikibhuka. Hano yamuruuzi omukari wuyo, akamubhuurira, “Muukya waane, tema ekubhi! Obhwiikirirya bhwaazo bhukuhonirye!” Hayohayo, omukari wuyo akahora. ");
INSERT INTO zak_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hano Yeesu yahikiri munyuumba yo omukaangati we esaango wuyo, akabhona abhaatu bhaaru bhiikumeenie muruku hayo, eno bhararira bhukongʼu na abhaandi bharatema ekireere. ");
INSERT INTO zak_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yeesu akabhabhuurira, “Murwe hano! Omuukya wuno akyaari kukwa, nawe ahiindiiri.” Hano abhaatu bhayo bhiigwiiri ego, bhakamuseka Yeesu kwe enzeero. ");
INSERT INTO zak_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kyaamwe, Yeesu akabharuusya bhoosi igutu, akasikira mukyuumba, akamugwaata okubhoko omuukya wuyo, neewe akiimeerera! ");
INSERT INTO zak_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Amangʼana gayo gakanyaragana mukyaaro kirya kyoosi. ");
INSERT INTO zak_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hano Yeesu yamariri kubhuuka hayo, abhahoku bhabhiri bhakamutuniirira, bhakamubhirikira kwiiraka ikuru, “Ee Omwaana wo omutemi Daudi, ndakusabha oturorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ambe, Yeesu akasikira munyuumba, abhahoku bharya bhakamugyaku. Akabhabhuurya, “Mbe, muriikirirya kubha ndanagya okubhahorya?” Bhakamukyoora, “Niigo, Omukuru!” ");
INSERT INTO zak_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Niho Yeesu akabhabhata ameeso gaabhu, akabhabhuurira, “Ekoreke kweemwe kyeego obhwiikirirya bhweenyu bhuri.” ");
INSERT INTO zak_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hayohayo, ameeso gaabhu gakaramukya, bhakanagya okurora. Yeesu akabhakumiirirya kwa nguru, “Mutamubhuurira muutu wowoosi amangʼana gano!” ");
INSERT INTO zak_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nawe bhakagya, bhakaraarika amangʼana iguru waaye mukyaaro kirya kyoosi. ");
INSERT INTO zak_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hano abhahoku bhayo bhaatanwiiri hayo, niho abhaatu abhaandi bhakamureetera Yeesu omuutu wuno yaari atiirirwe ne eriisaambwa eriibhi rino rimugirirye abhe imuumu. ");
INSERT INTO zak_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yeesu akaheebha eriisaambwa riyo, na hayohayo omuutu wuyo akataanga okugaamba kweeki. Abhaatu bhaaru bhe esaango bhano bhaari bhariho bhakaruguura bhukongʼu, bhakabhuga, “Gataakatuukiri na rumwe amangʼana kya gano mukyaaro kyoosi kya Iziraeri!” ");
INSERT INTO zak_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nawe Abhafarisayo bhakabhuga, “Araheebha amasaambwa amabhi kwo obhuturo bhwa Beerizeburi, omukaangati wa amasaambwa!” ");
INSERT INTO zak_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ambe, Yeesu akabha ariiruguura mumigye gyoosi gya haguhi. Hohoosi hano yaari akuhita, akasikira muziinyuumba zye eziisaango okweegya abhaatu. Yaari ararwaaza Amangʼana Amazomu iguru yo obhutemi bhwa mwiisaaro na yaari arahorya amarweeri goosi. ");
INSERT INTO zak_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hano Yeesu yaruuzi eziisaango zya abhaatu, akabharorera ebhigoongi, kwo okubha bhaari bharanyaaka na bhataari no omuutu wo okubhasakirya. Bhaari kye eziingʼoondu zino zitana omuriisya. ");
INSERT INTO zak_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Niho akabhabhuurira abhaanabheega bhaaye, “Amagesa ni maaru, nawe abhagesi ni bhasuuhu. ");
INSERT INTO zak_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kweego, musabhe Omukuru, Taatabhugya, ewe niwe mweene muguundu, okubha araganie abhagesi abhaandi bhagese mumuguundu gwaaye.” ");
INSERT INTO zak_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yeesu akabhabhirikira abhaanabheega bhaaye ikumi na bhabhiri, akabhaha obhunagya bhwo okuheebha amasaambwa amabhi okurwa kubhaatu no okuhorya amarweeri. ");
INSERT INTO zak_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Amariina ga abheega ikumi na bhabhiri bhayo nigo gano: Wo okutaanga ni Simooni wuno Yeesu akamutoga Petero, na Andurea wamwaabhu, Yaakobo omwaana wa Zebedaayo na Yohana wamwaabhu, ");
INSERT INTO zak_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Firipo, Baritoromaayo, Tomaso, Mataayo wuno yaari omutobhya we eriigooti, Yaakobo omwaana wa Arifayo, Tadayo, ");
INSERT INTO zak_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simooni Omuzeroote na Yuuda Isikariyoti, wuno yamuriiri omukoonyo Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ambe, Yeesu akaragania abhaanabheega ikumi na bhabhiri bhayo, akabhuga, “Mutagya kubhaatu bhano bhatari Abhiiziraeri, na mutasikira mumugye gwogwoosi gwa Samaria. ");
INSERT INTO zak_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nawe mugeende ku Bhiiziraeri, bhayo ni kye eziingʼoondu zino zibhuriri. ");
INSERT INTO zak_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hano mukugya owaabhu, mubhe murarwaaza kubha, ‘Obhutemi bhwa mwiisaaro bhuri haguhi!’ ");
INSERT INTO zak_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muhorye abharweeri, muryoore abhaku, muhorye bhe ebhigeenge na muheebhe amasaambwa amabhi. Mubhweeni obhunagya bhuyo bhusa, na neemwe bhoono muruusye obhusakirya bhweenyu bhusa. ");
INSERT INTO zak_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mutagega mubhiguzi bhyeenyu eziizahaabu, naabhe eziimbirya, naabhe eziishaba. ");
INSERT INTO zak_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Naabhe mutagega esakwa, naabhe emyeenda ebhiri, kasi ebhikweera, kasi ehiimbo. Omuhokya wuyo woosi areenderwa ahaabhwe amariho gaaye. ");
INSERT INTO zak_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Omugye gwogwoosi guno muraasikire, mukomye omuutu wuno araabhaginihye mumugye gwaaye. Mwiikare owaaye tee eriibhaga rino muraatanure hayo. ");
INSERT INTO zak_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hano muraasikire munyuumba muyo, mubhakeerye abhaatu bhaaye, ‘Omureembe gubhe neemwe.’ ");
INSERT INTO zak_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ambe, eraabhe bhariho abhaatu bhano bhano omureembe, okukeerya kweenyu kurabhaha omureembe, nawe eraabhe bhatana omureembe guyo, omureembe gubhakyoorere emwe. ");
INSERT INTO zak_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hano muraahike munyuumba yoyoosi kasi omugye gwogwoosi, na abhaatu bhaamu bhatakubhaginihya kasi bhatakubhiitegeerera, mutanure hagiro hayo mwiikungʼuute oruteeri kumaguru geenyu. ");
INSERT INTO zak_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ndabhabhuurira obhuheene, kurusiku rwo okutina ekiina, Taatabhugya arabhatema emwe bhukongʼu kukira abhaatu abhabhi bha Sodoma na Gomora. ");
INSERT INTO zak_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mwiitegeerere, ndabhatumania kye eziingʼoondu gatigati ye eziisuuzi. Kweego, mubhe na amangʼeeni kye enzoka, kweeki mubhe bhanyoohu kye ebhiguuti. ");
INSERT INTO zak_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwiiriihe na abhaatu, kwo okubha bharabhahira mwiibaraza bhabhaseme, kweeki bharabhatema emijariti muziinyuumba zyaabhu zye eziisaango. ");
INSERT INTO zak_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bharabhahira embere wa abhaanaangwa na abhatemi kwe ekigirirye muniikiriirye. Mureenderwa kubha abhamenyeekererya bhaane bha Amangʼana Amazomu, embere yaabhu ne embere ya abhaatu bhano bhatari Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hano bharaabhagwaate, mutabha no obhwiitiimaati kubha muragaambaki kasi muragaambabhwi, kwo okubha kwe eriibhaga riyo, Taatabhugya arabhaha amangʼana go okugaamba. ");
INSERT INTO zak_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Etari kubha emwe muragaamba, nawe ni Koro wa Taatabhugya Wuuso weenyu wuno akugaamba kuhitira kweemwe. ");
INSERT INTO zak_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kwe eriibhaga riyo, omuhiiri aramutuura omuhiiri waaye mumabhoko ga abhabhisa okubha yiitwe. Kweeki, taata aramutuura omwaana mumabhoko ga abhabhisa okubha yiitwe. Abhaana nabho bharabharwaania abhiibhuri bhaabhu no okugirya bhiitwe. ");
INSERT INTO zak_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Abhaatu bhoosi bharabhabhiihirirya kwe ekigirye kyo okubha emwe ni bhaanabheega bhaane. Nawe, wowoosi wuno araagumire tee obhuteero, niwe araatuuribhwe. ");
INSERT INTO zak_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Eraabhe murakorerwa obhubhi mumugye omurebhe, muryaarire mumugye oguundi. Ndabhabhuurira obhuheene, mutakumara emirimo gyeenyu mumigye gyoosi gya Iziraeri, enye Omwaana wo Omuutu nikyaari kuuza. ");
INSERT INTO zak_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Omwaanamweega atakunagya kumukira omweegya waaye, no omugya atakumukira omukuru waaye. ");
INSERT INTO zak_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Omwaanamweega areenderwa abhe kyo omweegya waaye, no omugya neewe abhe kyo omukuru waaye. Enye ni mukuru weenyu na bharanibhirikira Beerizeburi. Eraabhe bhanibhirikiiri ego, mbe, emwe bhatakubhabhirikira amariina mabhiihu kukiraho? ");
INSERT INTO zak_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ambe, mutoobhoha abhaatu bhayo. Kyokyoosi kino kikuundikiirwe, kirakuundukurwa neemwe, kweeki kyokyoosi kino kibhisirwe, kirarorekana. ");
INSERT INTO zak_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Goosi gano nikubhabhuurira mukiirima, mugagaambe mubhweero. Kweeki, goosi gano mukwiigwa kwe embiso, mugarwaaze kubhweero. ");
INSERT INTO zak_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mutoobhoha bhano bhakwiita omubhiri, nawe bhatakunagya okwiita eziikoro. Emwe mumwoobhohe Taatabhugya omweene ego, ewe niwe akunagya kusikya omubhiri hamwe ne ekoro mumuriro gwa nyaari. ");
INSERT INTO zak_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Angu, ebhitorookobhwe bhibhiri bhitakuguribhwa kwo obhuguri bhusuuhu? Naabhe, kitariho ekinyonyi kimwe kino kikukwa eraabhe Wuuso weenyu wa mwiisaaro atiikiriirye. ");
INSERT INTO zak_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na neemwe, Taatabhugya amenyiri obhubhari bhwe eziinzweeri zyoosi zye emitwe gyeenyu. ");
INSERT INTO zak_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kweego, mutoobhoha, kwo okubha emwe muno obhuguri bhukuru kukira ebhitorookobhwe bhyaaru. ");
INSERT INTO zak_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Omuutu wowoosi wuno akugaamba embere ya abhaatu kubha aniikiriirye enye, enye Omwaana wo Omuutu woosi ndamwiikirirya embere wa Taata waane wa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nawe, wowoosi wuno akunianga embere ya abhaatu, na neenye ndamwaanga embere ya Taata waane wa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mutiiseega kubha niiziri mukyaaro kino kwiiguru yo okureeta omureembe. Nitiiziri kwiiguru yo omureembe, nawe kwiiguru yo okureeta obhutwaanikani. ");
INSERT INTO zak_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Niiziri okureeta obhutwaanikani gati yo omumura na wiise waabhu, omuukya na nina, na gati yo omukamwaana ni inyibhyaara. ");
INSERT INTO zak_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Abhabhisa bho omuutu bharabha abhaatu bha munyuumba yaaye. ");
INSERT INTO zak_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Omuutu wowoosi wuno akuseega wiise waabhu kasi nina waabhu kukira enye, wuyo atakuningʼarira kubha omwaanamweega waane. Kweeki, wowoosi wuno akuseega omumura waaye kasi omuukya waaye kukira enye, wuyo woosi atakuningʼarira kubha omwaanamweega waane. ");
INSERT INTO zak_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Omuutu wuno atakweenda okugega omusaraba gwaaye no okunituniirira, wuyo atakuningʼarira kubha omwaanamweega waane. ");
INSERT INTO zak_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Omuutu wowoosi wuno akweenda kuriibha obhwiikari bhwaaye omweene, arabhubhurya. Nawe omuutu wowoosi wuno araabhurye obhwiikari bhwaaye kwiiguru waane, wuyo niwe araabhubhone. ");
INSERT INTO zak_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Omuutu wowoosi wuno akubhaginihya emwe, aniginihirye enye. Kweeki, wowoosi wuno aniginihirye enye, amuginihirye na Taatabhugya wuno anitumiri enye. ");
INSERT INTO zak_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wowoosi wuno akumuginihya omurooti kwo okubha ni murooti, Taatabhugya aramuha esaambo kya yo omurooti. Kweeki, wowoosi wuno akumuginihya omuutu waane we eheene kwo okubha ni muheene, Taatabhugya aramuha neewe esaambo kya we eheene. ");
INSERT INTO zak_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wowoosi wuno akumuha naabhe ekikoombe kya amaanzi amameezu owumwe wa abhaatu bhano kwo okubha ni mwaanamweega waane, eheene Taatabhugya atakweebha okumuha esaambo yaaye.” ");
INSERT INTO zak_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hano Yeesu yamariri kubhaswaagya abhaanabheega bhaaye ikumi na bhabhiri, akatanura hayo, akagya mumigye egiindi gya Gariraaya okweegya no okurwaazira abhaatu. ");
INSERT INTO zak_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Eriibhaga riyo, Yohana Omubatiizi yaari abhohirwe munyuumba ya abhabhohwa. Hano yaari muyo, akiigwa gano Masiya yaari akukora. Kyaamwe akaragania abhamwe bha abhaanabheega bhaaye ku Yeesu, bhamubhuurye, ");
INSERT INTO zak_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Mbe, awe naawe Masiya wuno araaze, kasi tumuganye owuundi?” ");
INSERT INTO zak_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeesu akabhakyoora, “Mugye mumubhuurire Yohana gano mukurora no okwiigwa. ");
INSERT INTO zak_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abhahoku bhararora, amagata bharageenda, abhageenge bharahora, abharibhi bha amatwi bhariigwa, abhaku bhararyoorwa na abhataka bhararwaazirwa Amangʼana Amazomu ga Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hakiriku omuutu wuno akugeenderera kuniikirirya kutama kubha no obhwiitiimaati iguru waane.” ");
INSERT INTO zak_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hano abhaanabheega bhayo bha Yohana hano bhaari bharagya zyaabhu, Yeesu akataanga okubhuurira esaango ya abhaatu iguru wa Yohana. Akabhabhuurya, “Hano mwaagiiri mwiitirigo kurora Yohana, mbe, mukagya kuroraki? Mbe, mukagya kurora omuutu wuno akwiikirirya amangʼana goosi kyeego maara yino ekusiingiswa kwo obhukama? Zeyi. ");
INSERT INTO zak_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ambe, mukagya kuroraki? Mbe, mukagya kumurora omuutu wuno ahiibhoha emyeenda emizomu? Zeyi. Abhaatu bhano bhahiibhoha eziingibho eziinzomu, bhahiikara muziinyuumba zye ekitemi. ");
INSERT INTO zak_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nawe, mukagya kuroraki? Mbe, mukagya kumurora omurooti omurebhe? Eheene ni murooti, kweeki ndabhabhuurira, Yohana ni mukuru kukira omurooti. ");
INSERT INTO zak_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wuyo niwe wuno Amakaamo Amahoreeru gakubhuga iguru waaye, ‘Rora, ndamuragania omuhokya waane embere waazo, okubha akweeyeerye enzira.’ ");
INSERT INTO zak_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ndabhabhuurira obhuheene, mubhaatu bhoosi bhano bhiibhwiirwe mukyaaro, akyaari kutuuka omukuru kukira Yohana Omubatiizi. Nawe, omuutu omusuuhu kukira bhoosi mubhutemi bhwa mwiisaaro, niwe omukuru kukira Yohana Omubatiizi. ");
INSERT INTO zak_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Okweema eriibhaga rya Yohana Omubatiizi yaari ararwaaza tee reero, abhaatu bharabhwiisaangirira obhutemi bhwa mwiisaaro bhukongʼu, bha amanaga bharasakya kubhusikya. ");
INSERT INTO zak_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Abharooti bhoosi na Musa mumigiro gyaaye bhakaruusya obhurooti iguru yo obhutemi bhuyo, tee eriibhaga rino Yohana yarorekeeni. ");
INSERT INTO zak_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ambe, eraabhe muriikirirya obhurooti bhwaabhu, Yohana niwe Eriya wuno yagaambirwe kubha araaza. ");
INSERT INTO zak_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wa amatwi, yiitegeerere kisi! ");
INSERT INTO zak_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Mbe, abhaatu bho orwiibhuro runo nibhatuubhanie naki? Bhatuubheeni na abhaana bhano bhakwiikara kumuteera bharabhirikira abharikyaabhu, ");
INSERT INTO zak_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tukabhatemera ekireere, nawe mutaabhiniri! Tukabheembera ameembo go okwaaramira, nawe mutaaririri!’ ");
INSERT INTO zak_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Niigo ego, hano Yohana yiiziri, yaari atakurya ebhyaakurya bhye eziisiku zyoosi, atakunywa amaanzi go omuzabibu, bhakabhuga, ‘Wuno agwaatirwe ne eriisaambwa eriibhi!’ ");
INSERT INTO zak_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Enye Omwaana wo Omuutu hano niiziri, nihaabha ndarya ebhyaakurya bhye eziisiku zyoosi na nihaanywa amaanzi go omuzabibu, bhakabhuga, ‘Murore! Wuno ni musoohu no omunywi, kweeki ni musaani wa abhatobhya bhe eriigooti na abhaatu bhe ebhibhi!’ Nawe, amangʼeeni ga Taatabhugya gararorekana kubha ge eheene kwe enzira ya amahokya ga abhaatu bhaaye.” ");
INSERT INTO zak_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mumigye gino Yeesu yaari akoriri ebhitiika bhyaaru, abhaatu bhataatigiri ebhibhi bhyaabhu. Kweego Yeesu akabharekya, ");
INSERT INTO zak_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Muraaza kurora, emwe abhaatu bha Korazini! Muraaza kurora, emwe abhaatu bha Betisaida! Eraabhe ebhitiika bhino niakoriri mumigye gyeenyu hano, niingakoriri mumigye emibhi girya gya Tiro na Sidooni, eheene abhaatu bhe emigye giyo bhiingamariri okuta ebhibhi bhyaabhu. Bhaangeerekirye obhwiisasaami kwo okwiibhoha emyeenda gya amagonera no okwiihaka ekibhu. ");
INSERT INTO zak_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ndabhabhuurira obhuheene, kurusiku rwo okutina ekiina, Taatabhugya arabhatema emwe bhukongʼu kukira abhaatu abhabhi bha Tiro na Sidooni. ");
INSERT INTO zak_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na neemwe, abhaatu bha Kaperinaumu, muriiseega kubha Taatabhugya arabhatiirya tee mwiisaaro? Zeyi! Taatabhugya arabhiituumya tee mumuriro gwa nyaari. Eraabhe ebhitiika bhino nikakora kweemwe bhiingarikorekiri mumugye gwa Sodoma, ambe omugye guyo guungabheeriho tee reero. ");
INSERT INTO zak_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nawe, ndabhabhuurira kubha, kurusiku rwo okutina ekiina, Taatabhugya arabhatema emwe bhukongʼu kukira abhaatu bho omugye gwa Sodoma.” ");
INSERT INTO zak_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eriibhaga rirya, Yeesu akabhuga, “Ee Taata waane, Omukuru wa mwiisaaro ne ekyaaro, ozomirye kwo okubha amangʼana gano obhabhisiri abhaatu bha amangʼeeni na abhasomi, okagakuundukurira abhaatu bhano bhakwiikiriirye kya abhaana. ");
INSERT INTO zak_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Niigo okaseega Taata waane, ego niigo okaseega.” ");
INSERT INTO zak_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kyaamwe Yeesu akabhabhuurira abhaatu, “Taata waane aniheeri obhunagya bhwoosi. Atariho omuutu wuno animenyiri Omwaana wa Taatabhugya kyeego niri, nawe Taata omweene. Kweeki, atariho omuutu wuno amumenyiri Taata kyeego ari, nawe enye Omwaana waaye omweene ego, no omuutu wowoosi wuno nikweenda kumukuundukurira. ");
INSERT INTO zak_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Muuze kweenye bhoosi bhano mukunyaaka no okutamiirirwa ne emirigo emirito, na neenye ndabhamuunya. ");
INSERT INTO zak_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Enye ni munyoohu, kweeki omwiitegeereru. Kweego, mwiibhohe ejooki yaane, mweege okurwa kweenye, niho ndaabhahe omureembe muziikoro zyeenyu. ");
INSERT INTO zak_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ejooki yaane ni nyoohu kugega no omurigo gwaane ni muhuhu.” ");
INSERT INTO zak_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Orusiku rumwe rwo okumuunya, Yeesu yaari arahita mumiguundu gye engano, hamwe na abhaanabheega bhaaye. Hano abhaanabheega bhaaye bhiigwiiri enzara, bhakataanga okubhuna ebhigara bhye engano, bhakarya. ");
INSERT INTO zak_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hano Abhafarisayo bhaaruuzi gayo, bhakamubhuurira Yeesu, “Rora, abhaanabheega bhaazo bharakora gano emigiro gitakwiikirirya okukorwa kurusiku rwo okumuunya!” ");
INSERT INTO zak_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yeesu akabhakyoora, “Mbe, mukyaari okusoma mu Makaamo Amahoreeru kyeego Daudi yaakoriri eriibhaga rino ewe na abharikyaaye bhaari ne enzara? ");
INSERT INTO zak_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Daudi akasikira mwiibhuru ryo okumuseengera Taatabhugya, kyaamwe ewe na abharikyaaye bhakarya emikaate gino gyaatuurirwe embere wa Taatabhugya. Bhakarya emikaate gino emigiro gya Musa gitabhiikiriirye bharye, nawe abhaseengeri abheene ego. ");
INSERT INTO zak_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kweeki, mukyaari kusoma mumigiro gya Musa gino gikubhuga, iguru ya abhaseengeri bhano bhakuhokya mwiiseengerero rya Taatabhugya kurusiku rwo okumuunya? Bhatakugwaata emigiro gyo orusiku rwo okumuunya, nawe Taatabhugya atakubhabharira kubha bharasarya. ");
INSERT INTO zak_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ndabhabhuurira kubhweero kubha, ariho omukuru hano wuno akukira eriiseengerero rya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Taatabhugya arabhuga mu Makaamo Amahoreeru, ‘Ndeenda mweerekye ebhigoongi kukira okuruusya ekimweeso.’ Kyeego muungamenyiri obhugazuro bhwa amangʼana gayo, mutaari kutinira ekiina abhaatu bhano bhatana eriibhi ryoryoosi. ");
INSERT INTO zak_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Enye Omwaana wo Omuutu, niwe Omukuru wo orusiku rwo okumuunya.” ");
INSERT INTO zak_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeesu akatanura hayo, akagya munyuumba ye esaango yaabhu. ");
INSERT INTO zak_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Munyuumba ye esaango muyo, yaari arimu omuutu wumwe wuno yaari no okubhoko kuno kukuuri. Bhaari bharimu na Abhafarisayo bhano bhaari bhareenda kumusakya Yeesu okubha bhamuseme. Ambe bhakamubhuurya, “Mbe, emigiro gya Musa giriikirirya okuhorya omuutu orusiku rwo okumuunya?” ");
INSERT INTO zak_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeesu akabhakyoora, “Ni weewi gati weenyu wuno eraabhe engʼoondu yaaye egweereeri mwiiruuma orusiku rwo okumuunya, atakunagya kuyiigwaata no okuyiruusya muyo? ");
INSERT INTO zak_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Rora, omuutu ano obhuguri bhukuru kukira engʼoondu! Kweego, emigiro giriikirirya okukora amazomu orusiku rwo okumuunya.” ");
INSERT INTO zak_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kyaamwe, Yeesu akamubhuurira omuutu wo okubhoko kuno kukuuri, “Gororokya okubhoko kwaazo.” Neewe akakugororokya, na hayohayo kukahora, kukabha kuhoru bhukongʼu kyeego okuundi kurya. ");
INSERT INTO zak_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ambe, Abhafarisayo bhakahuruka igutu, bhakiibhuurya kyeego bharaamwiite Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yeesu akamenya amiiseego ga Abhafarisayo bhayo, kweego akatanura hayo. Abhaatu bhaaru bhakamutuniirira, neewe akahorya bhoosi bhano bhaari bharweeri. ");
INSERT INTO zak_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nawe akabharekya bhatabha bhararaarika kubhaatu abhaandi kubha ewe ni weewi. ");
INSERT INTO zak_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yeesu akabhuga ego, okubha gakuunaane amangʼana gano Taatabhugya yabhugiri kwe enzira yo omurooti Isaya, ");
INSERT INTO zak_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Murore, wuno niwe omuhokya waane wuno nimusoriri, omuseegwa waane wuno akunizomeerya ekoro yaane. Ndamuhaana Ekoro yaane, okubha araarike obhutuurya kubhaatu bhe ebhyaaro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Atakuhakana naabhe kukora ekituri nabho, kweeki atakumwaaya eriiraka ryaaye embere ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Atakubhuna wowoosi wuno anyookobhiri kyeego maara yino yiikiikiri, naabhe atakusikya wowoosi wuno ari kyo orutaambi runo ruri haguhi kurima na ruraruusya omwooki, tee eriibhaga rino akureeta obhutuurya okuhiza ebhibhi bhyoosi. ");
INSERT INTO zak_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kweeki, abhaatu bhe ebhyaaro bhyoosi bhariisiga eriina ryaaye.” ");
INSERT INTO zak_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ambe, abhaatu bhakamureetera Yeesu omuutu owumwe wuno yaari atiirirwe ne eriisaambwa eriibhi no okumuhukurya no okumukora abhe imuumu. Yeesu akamuhorya, neewe akataanga kugaamba no okurora kweeki. ");
INSERT INTO zak_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Esaango ya abhaatu bhoosi bhakaruguura bhukongʼu, bhakabhuga, “Mbe, wuno aranagya akabha Omwaana wo omutemi Daudi?” ");
INSERT INTO zak_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nawe hano Abhafarisayo bhiigwiiri gayo, bhakabhuga, “Omuutu wuno araheebha amasaambwa amabhi kwo obhuturo bhwa Beerizeburi, omukaangati wa amasaambwa!” ");
INSERT INTO zak_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yeesu akamenya gano bhaari kwiiseega, kweego akabhabhuurira, “Eraabhe abhaatu bho obhutemi bhumwe bhariitana, kweego obhutemi bhuyo bhuragwa. Kweeki, eraabhe abhaatu bho omugye gumwe kasi enyuumba yimwe bhariitana, abhaatu bhayo bharatwaanikana na bhatakubha na amanaga naabhe hasuuhu. ");
INSERT INTO zak_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kweego eraabhe Seetaani araheebha Seetaani, obhutemi bhwaaye bhurabha bhuratwaanikana. Mbe, obhutemi bhuyo bhuranagya kwiimeererabhwi? ");
INSERT INTO zak_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eraabhe enye ndaheebha amasaambwa amabhi kwo obhunagya bhwa Beerizeburi, ambe abhaanabheega bheenyu bharaheebha amasaambwa kwo obhunagya bhwa weewi? Kwe ekigirirye kiyo, abhaanabheega bheenyu bhareerekya kubha mutari bhwaheene. ");
INSERT INTO zak_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nawe eraabhe enye ndaheebha amasaambwa amabhi kwo obhuturo bhwe Ekoro wa Taatabhugya, ambe, obhutemi bhwa Taatabhugya bhuhikiri kweemwe. ");
INSERT INTO zak_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Awe! Atariho omuutu wuno akunagya kusikira munyuumba yo omuutu wa amanaga okubha ateesye ebhigiro, eno akyaari okumubhoha. Hano akumara kumubhoha bhuzomu, hayo niho aranagya okuteesya ebhigiro bhino bhiri munyuumba yaaye. ");
INSERT INTO zak_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Omuutu wowoosi wuno atari hamwe neenye, ewe niwe omubhisa waane. Kweeki, wowoosi wuno atakukumania abhaatu hamwe neenye, kwe eheene arabhanyaragania. ");
INSERT INTO zak_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kweego ndabhabhuurira kubha, Taatabhugya aranagya okwaabhira abhaatu ebhibhi bhyaabhu bhyoosi, naabhe amangʼana amabhi go okwiituka. Nawe Taatabhugya atakunagya okwaabhira abhaatu bhano bhakumutuka Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kweeki Taatabhugya aranagya okwaabhira abhaatu bhano bhakugaamba bhubhi iguru waane enye Omwaana wo Omuutu. Nawe atakunagya okwaabhira abhaatu bhano bharabhuga bhubhi iguru ye Ekoro Muhoreeru, kukyaaro kino, kasi kino kikuuza. ");
INSERT INTO zak_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Omuti guramenyekana kyeego guri okuriingʼaana ne emisumo gyaku. Omuti omuzomu guriibhura emisumo emizomu, no omuti omubhiihu guriibhura emisumo emibhiihu. ");
INSERT INTO zak_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Emwe orwiibhuro rwe enzoka! Muranagyabhwi okugaamba amangʼana mazomu eno emwe ni bhabhi? Omuutu arakeerenia gano giizwiiri mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omuutu omuzomu aragaamba amazomu kutuukana na amazomu gano giizwiiri mukoro yaaye, nawe omuutu omubhi aragaamba amabhi kutuukana na amabhi gano giizwiiri mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ambe, ndabhabhuurira kubha, kurusiku rwo okutina ekiina, abhaatu bhareenderwa okugaamba amangʼana goosi amabhi gano bhaagaambiri. ");
INSERT INTO zak_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Taatabhugya arabhabhara kubha abhaatu bhe eheene kasi abhaatu bhe ebhibhi, kutuukana na amangʼana gano mugaambiri.” ");
INSERT INTO zak_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Niho, abhamwe bha Abhafarisayo na abheegya bhe emigiro bhakamubhuurira Yeesu, “Ee Omweegya, tureenda okore ekyeerekenio okweerekya kubha orwiiri ku Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yeesu akabhakyoora, “Emwe ni rwiibhuro rwa abhaatu abhabhi na mutari abhaheene embere wa Taatabhugya, nikyo kikugirya mureenda ekyeerekenio. Nitakubheerekya ekyeerekenio kyokyoosi. Nawe ekyeerekenio kimwe kino muraarore ni kya kirya Taatabhugya yakoriri kumurooti Yoona. ");
INSERT INTO zak_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kyeego Yoona akiikara muunda ye eswe ekuru eziisiku isatu obhutiku no omwiisi, egoego na neenye Omwaana wo Omuutu, ndiikara mumbiihira eziisiku isatu obhutiku no omwiisi. ");
INSERT INTO zak_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Kurusiku rwo okutina ekiina, abhaatu bha mumugye gwa Ninaawi bhariimeerera embere wa Taatabhugya hamwe no orwiibhuro runo no okubhatinira ekiina kubha emwe ni bhaatu bhe ebhibhi. Abhaatu bhayo bha Ninaawi bhakata ebhibhi bhyaabhu, hano bhakiigwa Yoona ararwaaza amangʼana okurwa ku Taatabhugya. Bhoono ariho owumwe hano, wuno niwe omukuru kukira Yoona, nawe mutakumwiitegeerera. ");
INSERT INTO zak_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kweeki, kurusiku rwo okutina ekiina rurya, nyakisaho we ekyaaro kya Sheeba ariimeerera embere wa Taatabhugya no okubhatinira ekiina abhaatu bho orwiibhuro runo, kwo okubha muratemya ebhibhi. Ewe akarwa mukyaaro kya kure okubha yiize yiitegeerere amangʼana ga amangʼeeni go omutemi Soromooni. Bhoono ariho owumwe hano wuno niwe omukuru kukira Soromooni, nawe mutakumwiitegeerera.” ");
INSERT INTO zak_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yeesu akageenderera okugaamba, “Hano eriisaambwa eriibhi rikurwa kumuutu, rirageendageenda mwiitirigo okukomya ahagiro ho okumuunya, na rirabhurwa. Nawe hano ribhurirwe okuhabhona, ");
INSERT INTO zak_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","eriisaambwa riyo rirabhuga, ‘Ndakyoora kumuutu waane wuno nimurwiiriku.’ Hano ryamukyooririku, rikabhona ari geeki kye enyuumba yino eri mwaasi, etarikiibhwe ne ebhanwiirwe bhuzomu. ");
INSERT INTO zak_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kyaamwe riragya kuraarika amasaambwa agaandi muhuungati amabhiihu kukira eryo eryeene. Goosi garasikira kumuutu wuyo, no okumwiikaramu. Niho obhwiikari bhwo omuutu wuyo bhukubhiiha kukira kubhweemero harya. Ego niigo kyeego eraabhe kweemwe, emwe abhaatu bho orwiibhuro rubhiihu runo!” ");
INSERT INTO zak_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeesu hano yaakyaari arakeerenia ne esaango ya abhaatu bhayo, nina waabhu na bhawamwaabhu bhakaaza no okwiimeerera igutu, bhakeenda okugaamba neewe. ");
INSERT INTO zak_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ambe, omuutu owumwe akamubhuurira Yeesu, “Nina weenyu na bhawamweenyu bhiimeereeri igutu, bhareenda okukeerenia na naawe.” ");
INSERT INTO zak_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yeesu akamukyoora, “Maayi ni weewi? Na bhawamweetu ni bhaweewi?” ");
INSERT INTO zak_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kyaamwe akabhasomoserya ekyaara abhaanabheega bhaaye, akabhuga, “Murore, bhano nibho maayi na bhawamweetu! ");
INSERT INTO zak_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Omuutu wowoosi wuno akukora obhuseegi bhwa Taata waane wa mwiisaaro, wuyo niwe maayi, mura weetu na musubhaati.” ");
INSERT INTO zak_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Orusiku ruyoruyo, Yeesu akahuruka munyuumba yiyo, akagya kwiikara embarika we enyaanza. ");
INSERT INTO zak_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Esaango ekuru ya abhaatu ekaaza, ekiikumania hano Yeesu yaari. Kweego, akatiira mubhwaato, akiikaramu, bhakabha bhiimeereeri embarika we enyaanza. ");
INSERT INTO zak_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ambe, Yeesu akabhabhuurira amangʼana maaru kwe ebhireengyo. Akabhuga, “Yaariho omubhusuri wumwe wuno yagiiri mumuguundu gwaaye okubhusura eziimbibho zyaaye. ");
INSERT INTO zak_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hano yaari akubhusura, eziimbibho eziindi zikagwa kunzira, ebhinyonyi bhikaaza, bhikazirya. ");
INSERT INTO zak_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eziimbibho eziindi zikagwa kurukerege hano hataari na amarobha maaru. Eziimbibho ziyo zikamera bhwaangu, kwo okubha amarobha gaari masuuhwiigo. ");
INSERT INTO zak_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nawe hano omubhaso gwabhariri, eziimbibho ziyo zikanyaara no okwooma, kwo okubha emiri gitaari mitaambi. ");
INSERT INTO zak_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eziimbibho eziindi zikagwa mumahwa. Hano amahwa gayo gaakiiniri, zikahigwa no okukwa. ");
INSERT INTO zak_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eziimbibho eziindi zikagwa mumarobha amazomu. Hano zyakiiniri no okukongʼa, eziindi zikiibhura eziimbibho igana rimwe (100), eziindi zikiibhura miroongo esaasabha (60) ne eziindi zikiibhura miroongo etatu (30). ");
INSERT INTO zak_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wa amatwi, yiitegeerere kisi!” ");
INSERT INTO zak_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abhaanabheega bha Yeesu bhakaaza kweewe no okumubhuurya, “Ni kwaki oragaamba nabho kwe ebhireengyo?” ");
INSERT INTO zak_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Akabhakyoora, “Taatabhugya abhakuundukuriiri emwe okumenya eziimbiso zyo obhutemi bhwa mwiisaaro, nawe ebho bhakyaari kukuundukurirwa okugamenya. ");
INSERT INTO zak_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wowoosi wuno akwiikirirya amangʼana gayo, Taatabhugya aramuha naabhe kukiraho. Nawe wowoosi wuno atakwiikirirya gayo, Taatabhugya aramuteesya naabhe ekisuuhu kino anakyo. ");
INSERT INTO zak_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndagaamba nabho kwe ebhireengyo, kwo okubha bhararora gano nikukora, nawe bhatakumenyeekererya obhugazuro bhwaku. Kweeki, bhariigwa gano nikugaamba, nawe bhatakumenyeekererya obhugazuro bhwaku. ");
INSERT INTO zak_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gayo garakoreka okubha gakuunaane gano omurooti Isaya akakaama iguru waabhu, ‘Okwiigwa muriigwa, nawe mutakumenyeekererya. Okurora murarora, nawe mutakumenyeekererya. ");
INSERT INTO zak_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Erabha ego, kwo okubha eziikoro zya abhaatu bhano ni kongʼu, amatwi gaabhu marito okwiigwa, ameeso gaabhu bhahiindiriirye. Bhataaza kurora kwa ameeso gaabhu, naabhe bhatiigwa kwa amatwi gaabhu, naabhe eziikoro zyaabhu zitamenya, bhataaza bhakaanikyoorera na neenye nibhatuurye.’ ” ");
INSERT INTO zak_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Niho Yeesu akabhabhuurira abhaanabheega bhaaye, “Nawe Taatabhugya abhatweereeri ebhite emwe, kwo okubha ameeso geenyu gararora na amatwi geenyu gariigwa. ");
INSERT INTO zak_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ndabhabhuurira obhuheene, ekare abharooti na bhe eheene bhaaru bhakiigoomba okurora gano mukurora emwe, nawe bhataagaruuzi. Bhaari bhariigoomba okwiigwa gano mukwiigwa emwe, nawe bhataagiigwiiri. ");
INSERT INTO zak_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ambe emwe, mwiitegeerere obhugazuro bhwe ekireengyo kiyo kyo omubhusuri we eziimbibho. ");
INSERT INTO zak_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Abhaatu bhobhoosi bhano bhakwiigwa amangʼana go obhutemi bhwa mwiisaaro nawe bhatakugamenyeekererya, Seetaani, omubhi wurya, araaza no okusaakura amangʼana gano geemiibhwe muziikoro zyaabhu. Abhaatu bhayo, bhatuubheeni na kyeego eziimbibho zino zyagwiiri munzira no okuriibhwa ne ebhinyonyi. ");
INSERT INTO zak_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eziimbibho zino zyagwiiri kurukerege hano hatana amarobha maaru, ziratuubhanibhwa na abhaatu bhano bhakiigwa amangʼana go obhutemi bhwa mwiisaaro, na hayohayo bharariikirirya kwo obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nawe bharagwaata amangʼana gayo kwiibhaga iguhi ego, gataari muusi waabhu bhukongʼu kyeego ebhituutu bhino bhitana emiri. Hano eziinyaako kasi amakongʼu garaabhabhone kwiiguru wa amangʼana gayo, rugeendo rumwe bharatiga obhwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eziimbibho zino zyagwiiri mumahwa, ziratuubhanibhwa na abhaatu bhano bhakwiigwa amangʼana go obhutemi bhwa mwiisaaro, nawe bharangʼeenwa na amiiseego iguru yo obhwiikari bhuno ne enaamba yo obhuniibhi. Kweego, amangʼana gayo garahigwa no okutama kwiibhura emisumo. ");
INSERT INTO zak_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nawe, eziimbibho zino zyagwiiri mumarobha amazomu, ziratuubhanibhwa na abhaatu bhano bhakwiigwa amangʼana go obhutemi bhwa mwiisaaro no okumenyeekererya. Abhaatu bhayo, nibho bhakubha ne emisumo mubhwiikari bhwaabhu, owuundi igana rimwe (100), owuundi miroongo esaasabha (60) no owuundi miroongo etatu (30), kweego, embibho yoyoosi, eriibhura bhukongʼu kukira yino ekeemibhwa.” ");
INSERT INTO zak_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeesu akabhabhuurira ekireengyo ekiindi, akabhuga, “Obhutemi bhwa mwiisaaro bhutuubheeni no omuutu wuno yabhuswiiri eziimbibho nzomu mumuguundu gwaaye. ");
INSERT INTO zak_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nawe eriibhaga rino abhaatu bhaari bhahiindiiri, omubhisa waaye akaaza, akeemya ekitoki mungano, kyaamwe akatanura. ");
INSERT INTO zak_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hano engano yiyo yameriri no okutaanga okwiibhura emisumo, ekitoki nakyo kikamera. ");
INSERT INTO zak_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Abhagya bha mweene muguundu bhakaaza, bhakamubhuurya, ‘Ee omukuru, tumenyiri kubha okabhusura eziimbibho nzomu mumuguundu gwaazo. Bhoono, ekitoki kino kituukiri hayi?’ ");
INSERT INTO zak_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Akabhakyoora, ‘Omubhisa niwe akoriri ego.’ “Abhagya bhaaye bhakamubhuurya, ‘Mbe oreenda tugye twiihe ekitoki kiyo?’ ");
INSERT INTO zak_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Neewe akabhuga kubha, ‘Zeyi, mutakiiha, eraabhe murakiiha ekitoki, muranagya mukiiha hamwe ne engano. ");
INSERT INTO zak_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mutige bhyoosi bhikure hamwe, tee okugesa. Eriibhaga riyo, ndabhabhuurira abhagesi kubha bhakumanie hiinga ekitoki no okukibhoha mubhibha okumara bhabhyookye. Niho bhanagye okugesa engano no okuyibhiika mukitara kyaane.’ ” ");
INSERT INTO zak_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu akabhabhuurira ekireengyo ekiindi, akabhuga, “Obhutemi bhwa mwiisaaro bhutuubheeni kye etetere ye eharadaari yino omuutu yagegiri no okuyeemya mumuguundu gwaaye. ");
INSERT INTO zak_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Akatetere kayo ni kasuuhu bhukongʼu kukira eziitetere eziindi zyoosi, nawe hano kakumera karakura karabha kakuru kukira ebhituutu bhyoosi bhino bhiri mumuguundu. Akatetere kayo karabha omuti omukuru guno ebhinyonyi bhikaaza no okwiikara mumasagya gaaku.” ");
INSERT INTO zak_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeesu akabhabhuurira ekireengyo ekiindi, akabhuga, “Obhutemi bhwa mwiisaaro bhutuubheeni ne ekibhwiisya kino omukari yagegiri no okusaangya mubhisehi bhitatu bhyo obhutu bhwe engano, tee obhutu bhwoosi bhukasita.” ");
INSERT INTO zak_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeesu yaari arabhuurira esaango ya abhaatu ameegyo gayo kwe ebhireengyo. Ataabheegirye kyokyoosi kutama okubhabhuurira kwe ebhireengyo. ");
INSERT INTO zak_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gayo gakakorerwa ego, okubha rikuunaane eriingʼana rino Taatabhugya yabhugiri kwe enzira yo omurooti waaye, “Ndakeerenia na abhaatu bhayo kwe enzira ye ebhireengyo. Ndabhabhuurira amangʼana gano gabhisirwe kweema okuteemwa kwe ekyaaro.” ");
INSERT INTO zak_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kyaamwe, Yeesu akaraga esaango ya abhaatu, akasikira munyuumba. Abhaanabheega bhaaye bhakamugyaku, bhakamubhuurira, “Tubhuurire obhugazuro bhwe ekireengyo kirya kye ekitoki kya mumuguundu.” ");
INSERT INTO zak_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeesu akabhakyoora, “Omuutu wuno yabhuswiiri eziimbibho eziinzomu, ne enye Omwaana wo Omuutu. ");
INSERT INTO zak_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Omuguundu ni kyaaro, eziimbibho eziinzomu ni bhaatu bho obhutemi bhwa Taatabhugya, ne ekitoki ni bhaatu bha Seetaani, omubhi wurya. ");
INSERT INTO zak_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Omubhisa wuno yiiziri okweemya ekitoki ni Seetaani. Eriigesa ni bhuteero bhwe ekyaaro kino, na abhagesi ni bhamaraika bha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Kya bhurya abhabhagati bha mumuguundu bhariiha no okwookya ekitoki mumuriro, niigo garaabhe kurusiku rwo obhuteero bhwe ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Enye Omwaana wo Omuutu, ndaragania bhamaraika bhaane, okubha bhakumanie kurwa mubhutemi bhwaane abhatemya bho obhubhi bhoosi hamwe na bhoosi bhano bhagirirye abharikyaabhu bhakore obhubhi. ");
INSERT INTO zak_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bhamaraika bhayo bhararekera bho obhubhi bhayo bhoosi mwiibheri ryo omuriro. Muyo nimwe bharabha bhararira no okusaanania ameeno. ");
INSERT INTO zak_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Niho bhe eheene embere wa Taatabhugya, bharabha bharamesya kyeego omubhaso mubhutemi bhwa Wiise waabhu. Wa amatwi, yiitegeerere kisi!” ");
INSERT INTO zak_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kyaamwe Yeesu akabhabhuurira ebhireengyo ebhiindi, akabhuga, “Obhutemi bhwa mwiisaaro bhutuubheeni ne ehata yino yaari ebhisirwe mumuguundu. Orusiku rumwe, omuutu akayibhona, akayibhisa kweeki. Ambe, kwo obhuzomererwa bhwaaye, akagya akagurya ebhigiro bhyoosi bhino yaari nabhyo, akagura omuguundu guyo. ");
INSERT INTO zak_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kweeki, obhutemi bhwa mwiisaaro bhutuubheeni no omusuruzya owumwe wuno yagiiri kumoohya eziiruuru eziinzomu bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hano yabhweeni eruuru yimwe yo obhuguri bhukuru, akagya akagurya ebhigiro bhyoosi bhino yaari nabhyo, akagura eruuru yiyo. ");
INSERT INTO zak_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kweeki, obhutemi bhwa mwiisaaro bhutuubheeni no orweero runo abhategi bhaategiri munyaanza. Orweero ruyo rukatiimbya eziiswe zya tuubho nzaru. ");
INSERT INTO zak_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hano orweero ruyo ruzwiiri, abhategi bhakarutira embarika we enyaanza. Kyaamwe, bhakiikara haasi, bhakakumania eziiswe eziinzomu, bhakatuura mubhisehi. Nawe eziiswe zino zitakweenderwa, bhakazirekera. ");
INSERT INTO zak_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ego niigo ekubha kurusiku rwo obhuteero bhwe ekyaaro kino. Bhamaraika bharaaza no okutwaanikania abhatemya bho obhubhi na bhano bhaari bheene heene embere wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kyaamwe bharabharekera abhatemya bho obhubhi mwiibheri ryo omuriro. Muyo nimwe bharabha bhararira no okusaanania ameeno.” ");
INSERT INTO zak_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yeesu akabhuurya abhaanabheega bhaaye, “Mbe, mugamenyiri goosi gano nibhabhuuriiri?” Nabho bhakamukyoora, “Niigo, tumenyiri.” ");
INSERT INTO zak_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Neewe akabhabhuurira, “Omweegya wowoosi we emigiro gya Musa wuno yeegiibhwe bhuzomu mumangʼana go obhutemi bhwa mwiisaaro, atuubheeni na mweene nyuumba wuno akuruusya muhata ebhigiro bhyaaye ebhihya ne ebhikuungu.” ");
INSERT INTO zak_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hano Yeesu yamariri okuruusya ebhireengyo bhiyo, akatanura hayo, ");
INSERT INTO zak_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","akagya mukyaaro kyo owaabhu. Hano yaari mumugye gwa Nazareeti eyo, akataanga kweegya munyuumba ye esaango yo owaabhu. Abhaatu bhakaruguura bhukongʼu, bhakiibhuurya, “Omuutu wuno abhweeni hayi amangʼeeni gano? Na hayi abhweeni obhuturo bhwo okukora ebhitiika bhino? ");
INSERT INTO zak_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wuno tiwe omwaana wo omubhaazi wurya? Nina waabhu ti wuno akubhirikirwa Mariamu? Na bhawamwaabhu ti nibho Yaakobo, Yusufu, Simooni na Yuuda? ");
INSERT INTO zak_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na abhasubhaati bhaaye bhatari nibho bhano twiikeeri nabho eno? Ambe, abhweeni hayi amangʼana goosi gano?” ");
INSERT INTO zak_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Abhaatu bhayo bhakabhiihirirwa, bhakaanga kumwiikirirya. Niho Yeesu akabhabhuurira, “Abhaatu bharasuuka omurooti hohoosi harya, nawe muroobho yaaye kasi enyuumba yaaye, bhatakumusuuka.” ");
INSERT INTO zak_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ambe, Yeesu ataakoriri ebhitiika bhyaaru eyo, kwo okubha abhaatu bhayo bhataamwiikiriirye. ");
INSERT INTO zak_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Eriibhaga riyo, omutemi Herode Antipasi yaari omukaangati we ekyaaro kya Gariraaya. Hano yiigwiiri iguru ya amahokya gano Yeesu yaari akoriri, ");
INSERT INTO zak_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","akabhabhuurira abhabhagati bhaaye, “Omuutu wuyo ni Yohana Omubatiizi! Hamwe aryookiri okurwa kubhaku! Nikyo ekigirye ano obhunagya bhwo okukora ebhitiika.” ");
INSERT INTO zak_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herode akagaamba ego, kwo okubha ewe omweene yaari amugwaatiri Yohana, akamubhoha no okumutuura munyuumba ya abhabhohwa. Herode yaari amubhohiri, kwa amangʼana ga Yohana iguru yo obhukweererani bhwa Herode na Herodia. Herodia wuyo, kubhutaangiro yaari omukari wa Firipo, wamwaabhu omusuuhu Herode. ");
INSERT INTO zak_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kwe ekigirirye kiyo, Yohana yaari aramubhuurira Herode, “Emigiro gya Taatabhugya gitakwiikirirya okumukweera omukari wa wamweenyu.” ");
INSERT INTO zak_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ambe, Herode yaari aramoohya enzira yo okumwiita Yohana, nawe yaari aroobhoha abhaatu kwo okubha bhakamwiikirirya Yohana kubha omurooti wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Eriibhaga rye enyaangi yo okwiibhurwa kwa Herode, omuukya wa Herodia akaaza akabhina embere wa abhagini. Herode akazomererwa bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Niho akamuragira kwo obhwiirahiri okumuha kyokyoosi kino araamusabhe. ");
INSERT INTO zak_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Omuukya wuyo akasiigiriribhwa na nina, akamubhuurira Herode, “Niha hano omutwe gwa Yohana Omubatiizi kuruhuungo.” ");
INSERT INTO zak_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Omutemi Herode akabha ne ebhigoongi bhukongʼu, nawe kwe ekigirirye yaari yiirahiiri embere ya abhagini bhaaye, akaswaagya kubha omuukya ahaabhwe. ");
INSERT INTO zak_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ambe, Herode akaragania omuutu agye munyuumba ya abhabhohwa, amutine Yohana omutwe. ");
INSERT INTO zak_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kyaamwe akakyoora no omutwe gwa Yohana kuruhuungo, akamuha omuukya wuyo, neewe akamuhirira nina waabhu. ");
INSERT INTO zak_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Hano abhaanabheega bha Yohana bhiigwiiri amangʼana gayo, bhakaaza kugega ekituundu, bhakagya kukibhiika. Kyaamwe, bhakagya kumubhuurira Yeesu goosi gano gaatuukiri. ");
INSERT INTO zak_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hano Yeesu yiigwiiri gayo goosi, akatanura hayo no obhwaato, akagya kibhezo. Nawe eriibhaga abhaatu bhakiigwa hagiro hano agiiri, bhakahuruka mumigye gyaabhu, bhakagya kwa amaguru okumutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ambe, hano yiikiri mubhwaato, akarora esaango ekuru ya abhaatu. Akabharorera ebhigoongi no okuhorya abharweeri bhaabhu. ");
INSERT INTO zak_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hano kwabheeri engoroobha, abhaanabheega bhaaye bhakaaza kumubhuurira Yeesu, “Hano turi mwiitirigo no obhutiku bhuhikiri. Obharage abhaatu bhano, bhagye mumigye bhiigurire ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yeesu akabhakyoora, “Bhatakweenderwa kugya. Emwe, mubhahe ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Neebho bhakamukyoora, “Tutana kigiro! Tunagyo emikaate etaano ne eziiswe ibhiri ego.” ");
INSERT INTO zak_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yeesu akabhabhuurira, “Munireetere hano.” ");
INSERT INTO zak_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ambe, akabhaswaagya abhaatu bharya kubha bhiikare haasi mubhunyaaki. Akagega emikaate etaano girya ne eziiswe ibhiri zirya, akaroreerera mwiisaaro, akabhuga, “Ozomirye, Taatabhugya.” Kyaamwe akagibhega emikaate, akabhaha abhaanabheega bhaaye hamwe ne eziiswe, neebho bhakatwaanira abhaatu. ");
INSERT INTO zak_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Abhaatu bhoosi bhakarya, bhakiiguta. Kyaamwe, abhaanabheega bhaaye bhakakumania amasaagyo, bhakiizurya ebhikapu ikumi na bhibhiri. ");
INSERT INTO zak_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Abhaatu bhano bhaariiri ebhyaakurya bhirya, bhaari abhasubhe kye ebhikwe bhitaano (5,000), kutama okubhara abhakari na abhaana. ");
INSERT INTO zak_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Hayohayo, Yeesu akaswaagya abhaanabheega bhaaye kubha, bhasikire mubhwaato, bhakaangate bhagye omwaambuko gwe enyaanza, eriibhaga ewe yaari akyabharaga esaango ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hano Yeesu yamariri okubharaga esaango yirya ya abhaatu, akatiira mukiguru omweene ego kugya kusabha. Kweego, hano obhutiku bhwasikiiri, yaari akyaari eyo mukiguru omweene. ");
INSERT INTO zak_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Eriibhaga riyo, obhwaato bhurya bhwaari bhuhikiri kure gatigati ye enyaanza, nawe amabhooka gaari garabhutema, kwo okubha obhukama bhwaari bhurabhuhuna. ");
INSERT INTO zak_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Etabhoori zuri, ekorokoome eri haguhi kugaamba, Yeesu akahika hano abhaanabheega bhaaye bhaari, eno arageenda iguru wa amaanzi. ");
INSERT INTO zak_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hano abhaanabheega bhaaye bhaamuruuzi Yeesu arageenda iguru wa amaanzi, bhakahaha bhukongʼu, no okutema ekituri bharabhuga, “Guno ni musaambwa!” ");
INSERT INTO zak_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hayohayo, Yeesu akabhabhuurira, “Muteme ekubhi, mutoobhoha! Neenye.” ");
INSERT INTO zak_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petero akamukyoora, “Ee Omukuru, eraabhe ni naawe eheene, onibhuurire kubha niize owaazo, eno ndageenda iguru wa amaanzi.” ");
INSERT INTO zak_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeesu akamukyoora, “Nawuuze!” Ambe, Petero akiituuma mubhwaato, akataanga kugeenda iguru wa amaanzi kugya ku Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nawe eriibhaga obhukama bhuhaari bhwamuhuniri, Petero akoobhoha bhukongʼu, akeema okutubhira mumaanzi. Akarira kwe eriiraka, “Ee Omukuru, onituurye!” ");
INSERT INTO zak_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hayohayo, Yeesu akagororokya okubhoko, akamugwaata, akamubhuurira, “Awe wo obhwiikirirya bhusuuhu, kwaki okahaha?” ");
INSERT INTO zak_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hano Yeesu na Petero bhaatiiriri mubhwaato, obhukama bhukahoreera. ");
INSERT INTO zak_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ambe, abhaanabheega bhano bhaari mubhwaato, bhakamuseengera Yeesu. Bhakabhuga, “Eheene, awe ni Mwaana wa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hano Yeesu na abhaanabheega bhaaye bhaambukiri enyaanza, bhakahika ekyaaro kya Genesareeti. ");
INSERT INTO zak_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hano abhaatu bha ahagiro hayo bhaamumenyiri kubha ni Yeesu, bhakaraarika amangʼana gaaye ahagiro hoosi. Ambe, abhaatu bhakaaza na bhakamureetera Yeesu abharweeri bhaabhu bhoosi. ");
INSERT INTO zak_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Neebho bhakamusabha Yeesu abhiikirirye abharweeri bhakunieku naabhe omuriingo gwo omweenda gwaaye. Niho abharweeri bhoosi bhano bhaakuniryeku, bhakahora. ");
INSERT INTO zak_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ambe, Abhafarisayo abharebhe na abheegya bhe emigiro gya Musa bhakarweera Yerusaremu bhakaaza ku Yeesu, bhakamubhuurya, ");
INSERT INTO zak_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kwaki abhaanabheega bhaazo bharasarya eziisiira zino bhazaazi bheetu bhakatutigira? Bhayo bhararya ebhyaakurya, nawe bhatakwiisaabha amabhoko gaabhu kyeego ekweenderwa!” ");
INSERT INTO zak_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeesu akabhakyoora, “Kwaki na neemwe murasarya obhuswaagyo bhwa Taatabhugya kwo okutuniirira eziisiira zyeenyu? ");
INSERT INTO zak_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Taatabhugya abhugiri, ‘Obhasuuke wuuso na nyoko weenyu.’ Kweeki abhugiri, ‘Wowoosi wuno akumutuka wiise kasi nyoko waabhu, areenderwa yiitwe.’ ");
INSERT INTO zak_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nawe emwe murabhuga kubha, omuutu ariikiriribhwa kumubhuurira wiise kasi nina waabhu, ‘Ebhigiro bhino niari ndanagya okukusakirya, nimariri okubhiruusya ku Taatabhugya.’ ");
INSERT INTO zak_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kweego mureegya kubha, omuutu atakweenderwa kumusuuka wiise kasi nina waabhu. Nawe kuyo nikwe okuzeera engʼana ya Taatabhugya kwo okutuniirira eziisiira zyeenyu. ");
INSERT INTO zak_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Emwe abhabheehi! Taatabhugya akagaamba obhuheene iguru weenyu okuhitira omurooti waaye Isaya, ");
INSERT INTO zak_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Abhaatu bhano bharanisuuka kwa amangʼana ego, nawe eziikoro zyaabhu ziri kure neenye. ");
INSERT INTO zak_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bharaniseengera bhusa, kwo okubha bhareegya obhuswaagyo bhwa abhaatu kyamuna ni bhwa Taatabhugya.’ ” ");
INSERT INTO zak_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ambe, Yeesu akabhirikira esaango ya abhaatu, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Muniitegeerere bhuzomu, na mumenye amangʼana gano nikubhabhuurira! Bhitari bhigiro bhino bhikusikira mumunwa nibhyo bhikumukira omuutu. Nawe, amangʼana gano gakurwa mumunwa, nigo gakumukira omuutu.” ");
INSERT INTO zak_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Niho abhaanabheega bha Yeesu bhakagya kweewe, bhakamubhuurya, “Omenyiri kubha Abhafarisayo hano bhakiigwa amangʼana gaazo, bhakabhiihirirwa bhukongʼu?” ");
INSERT INTO zak_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yeesu akabhakyoora, “Ebhituutu bhyobhyoosi bhino Taata waane wa mwiisaaro ataabhyeemirye, arabhiiha. ");
INSERT INTO zak_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mubhatige bhayo! Ebho ni kya abhakaangati abhahoku bhano bhakukaangata abhahoku. Eraabhe omuhoku arakaangata omuhoku omurikyaaye, bhoosi bhabhiri bharatubhira mwiiruuma.” ");
INSERT INTO zak_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ambe, Petero akamubhuurira Yeesu, “Tugarurire ekireengyo kiyo.” ");
INSERT INTO zak_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yeesu akamukyoora, “Naabhe emwe mutana amangʼeeni go okumenya ekireengyo kirya? ");
INSERT INTO zak_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mutamenyiri kubha kyokyoosi kino kikusikira mumunwa, kihaasikira muunda yo omuutu, kyaamwe kihaareka mumubhiri gwaaye? ");
INSERT INTO zak_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nawe kyokyoosi kino kikureka mumunwa gwo omuutu, kirarwa mukoro yaaye. Kiyo nikyo kikugirya omuutu kubha makire. ");
INSERT INTO zak_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mukoro yo omuutu, nimwe muyo gakurwa amiiseego mabhiihu, obhwiiti, obhuseebheeti, obhutuungiri, obhwiibhi, obhumenyeekererya bhwo orurimi na amatuki. ");
INSERT INTO zak_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Goosi gayo, nigo gano gakumukora omuutu kubha makire. Nawe omuutu atakunagya kubha makire kwe ekigirirye kyo okurya ebhyaakurya akyaari okwiisaabha amabhoko kyeego ekweenderwa.” ");
INSERT INTO zak_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ambe, Yeesu akatanura hayo, akagya haguhi ne emigye gya Tiro na Sidooni. ");
INSERT INTO zak_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Niho akasikana no omukari wumwe, yaari ni Mukanaani we eyo. Akaaza ku Yeesu, akabhirikira kwe eriiraka, “Ee Omukuru, Omwaana wo omutemi Daudi, onirorere ebhigoongi! Muukya waane atiirirwe bhukongʼu ne eriisaambwa eriibhi.” ");
INSERT INTO zak_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nawe Yeesu ataamukyooriri engʼana yoyoosi. Kyaamwe, abhaanabheega bhaaye bhakaaza no okumusabha, “Omubhuurire omukari wuno agye, kwo okubha aratema ekituri eno aratutuniirira inyuma.” ");
INSERT INTO zak_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Akabhakyoora, “Taatabhugya yaanitumiri kwiiguru ya Abhiiziraeri ego, bhari kye eziingʼoondu zino zibhuriri.” ");
INSERT INTO zak_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Omukari wuyo akamwiisukira Yeesu, akiihigama embere waaye, akamusabha, “Ee Omukuru, onisakirye!” ");
INSERT INTO zak_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Akamukyoora, “Etari bhuzomu kugega ebhyaakurya bhya abhaana no okuzirekerera eziimbwa.” ");
INSERT INTO zak_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Omukari wuyo akabhuga, “Niigo eri Omukuru, nawe naabhe eziimbwa nazyo zirarya amasaagyo gano gakutoondobhoka haasi okurwa kwiigari rya abhakuru bhaabhu.” ");
INSERT INTO zak_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeesu akamukyoora, “Ee omukari, obhwiikirirya bhwaazo ni bhukuru! Taatabhugya akukorere kyeego okweenda.” Hayohayo, omuukya waaye akahora. ");
INSERT INTO zak_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yeesu akatanura hayo, akagya kuhitira embarika ye Enyaanza ya Gariraaya. Akatiira mukiguru no okwiikara eyo. ");
INSERT INTO zak_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Abhaatu bhaaru bhukongʼu bhakagya ku Yeesu, bhakamureetera amagata, abhahoku, abharema, amamuumu na abharweeri abhaandi bhaaru. Abhaatu bhayo bhakatuura abharweeri bhayo haguhi na amaguru ga Yeesu, neewe akabhahorya. ");
INSERT INTO zak_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Abhaatu bhakaruguura bhukongʼu hano bhaaruuzi amamuumu garakeerenia, abharema bhahoriri, amagata garageenda na abhahoku bhararora. Bhakataanga okumukumya Taatabhugya wa Abhiiziraeri. ");
INSERT INTO zak_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Niho Yeesu akabhabhirikira abhaanabheega bhaaye, akabhabhuurira, “Ndabharorera ebhigoongi abhaatu bhano, twiikeeri nabho eziisiku isatu na bhoono bhatana ebhyaakurya bhyobhyoosi. Nitakweenda nibharage bhagye bhane enzara, kwo okubha abhaandi bharatura kuseezeka munzira.” ");
INSERT INTO zak_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abhaanabheega bhaaye bhakamubhuurya, “Mbe, turi mwiitirigo hano, na abhaatu ni bhaaru. Turatura kubhona hayi ebhyaakurya bhyo okwiisa okubhiigutya abhaatu bhano bhoosi?” ");
INSERT INTO zak_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeesu akabhabhuurya, “Mune emikaate eriinge?” Bhakamukyoora, “Tune emikaate muhuungati ne eziiswe suuhwiigo.” ");
INSERT INTO zak_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ambe, Yeesu akaswaagya abhaatu bhoosi bhiikare haasi. ");
INSERT INTO zak_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Akagega emikaate muhuungati girya ne eziiswe zirya, akamubhuurira Taatabhugya, “Ozomirye.” Kyaamwe, akabhega, akabhaha abhaanabheega bhaaye, nabho abhaanabheega bhakabhatwaanira abhaatu. ");
INSERT INTO zak_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Abhaatu bhoosi bhakarya, bhakiiguta. Kyaamwe, abhaanabheega bhakakumania amasaagyo, bhakiizurya ebhisehi muhuungati. ");
INSERT INTO zak_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abhaatu bhano bhaariiri ebhyaakurya bhirya bhaari bhasubhe bhikwe bhine (4,000), abhakari na abhaana bhataabharirwe. ");
INSERT INTO zak_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ambe, Yeesu akabharaga abhaatu bharya, akatiira mubhwaato, akagya orubhaara rwa Magadaani. ");
INSERT INTO zak_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Abhafarisayo na Abhasadukayo bhakagya kumusakya Yeesu. Bhakamusabha akore ekyeerekenio okurwa mwiisaaro kino kikweerekya kubha arwiiri ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yeesu akabhakyoora, “Eriibhaga rye engoroobha, emwe muranagya okugaamba, ‘Izo eriibhaga ryo obhukama rirabha izomu, kwo okubha eriisaaro ni kaangaaru.’ ");
INSERT INTO zak_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nawe orusiku oruundi rwe etabhoori muranagya okugaamba kubha, ‘Reero embura yo obhukama eratweeka, kwo okubha eriisaaro ni mwaamu na amasaaro giizwiiri eyo.’ Kweego eheene, emwe muranagya okumenya ebhyeerekenio bhye eriisaaro, nawe mutakunagya okumenya ebhyeerekenio bhye eriibhaga rino! ");
INSERT INTO zak_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Emwe ni rwiibhuro rwa abhaatu abhabhi na mutari abhaheene embere wa Taatabhugya, nikyo kikugirya mureenda ekyeerekenio! Nitakubheerekya ekyeerekenio kyokyoosi. Nawe ekyeerekenio kimwe kino muraarore ni kya kirya Taatabhugya yakoriri kumurooti Yoona.” Niho Yeesu akabhatiga, akatanura okurwa hayo. ");
INSERT INTO zak_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ambe, abhaanabheega bha Yeesu bhakaambuka enyaanza, nawe bhaari bheebhiri kugega emikaate. ");
INSERT INTO zak_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeesu akabhabhuurira, “Mwiiriihe ne ekibhwiisya kya Abhafarisayo na Abhasadukayo.” ");
INSERT INTO zak_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Abhaanabheega bhaaye bhakataanga okukeerenia abheene kwa abheene, bhakubhuga, “Arabhuga ego, kwo okubha tutaagegiri emikaate.” ");
INSERT INTO zak_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yeesu akamenya gano bhaari bhakukeerenia, akabhuga, “Emwe bho obhwiikirirya bhusuuhu! Kwaki murakeerenia abheene kwa abheene kubha mutana emikaate? ");
INSERT INTO zak_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tee bhoono, mutamenyiri? Mutakuhiita kyeego abhaatu bhikwe bhitaano (5,000) bhakiiguta kwe emikaate etaano girya? Mukiizurya ebhisehi bhiriinge bhya amasaagyo? ");
INSERT INTO zak_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kasi mutakuhiita emikaate muhuungati girya kwa abhaatu bhikwe bhine (4,000)? Mukiizurya ebhisehi bhiriinge bhya amasaagyo? ");
INSERT INTO zak_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndora mutamenyiri kubha gano nibhugiri gatari iguru we emikaate? Ambe, kino nikugaamba ni kubha, mwiiriihe ne ekibhwiisya kya Abhafarisayo na Abhasadukayo.” ");
INSERT INTO zak_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Niho, abhaanabheega bhaaye bhakamenyeekererya kubha ataari arakeerenia iguru ye ekibhwiisya kye emikaate, nawe bhiiriihe na ameegyo go orurimi ga Abhafarisayo na Abhasadukayo. ");
INSERT INTO zak_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hano Yeesu yahikiri ahagiro hano haari hakubhirikirwa Kaisaria-Firipi, akabhabhuurya abhaanabheega bhaaye, “Abhaatu bharabhuga kubha, enye Omwaana wo Omuutu, ni weewi?” ");
INSERT INTO zak_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakamukyoora, “Abhaandi bharabhuga awe naawe Yohana Omubatiizi, na abhaandi bharabhuga awe naawe Eriya kasi Yeremia, kasi owumwe gati wa abharooti bha Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeesu akabhabhuurya, “Na neemwe murabhuga enye ni weewi?” ");
INSERT INTO zak_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simooni Petero akamukyoora, “Awe naawe Masiya, Omwaana wa Taatabhugya wuno ari muhoru.” ");
INSERT INTO zak_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeesu akamubhuurira Petero, “Ee Simooni omwaana wa Yoona, otweereerwe ebhite, kwo okubha atariho omuutu wuno akukuundukuriiri obhuheene bhuyo, nawe ni Taata waane wa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Enye ndakubhuurira Petero kubha, awe naawe eriitare, ni iguru we eriitare rino, niho nikwoomboka ekanisa yaane, na amanaga go oruku gatakurihiza na rumwe. ");
INSERT INTO zak_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Enye ndakuha emisiimo gyo obhutemi bhwa mwiisaaro. Kweego, amangʼana gogoosi gano okugarekya mukyaaro kino, Taatabhugya wuno ari mwiisaaro arabha agarekirye. Kweeki, gogoosi gano okugiikirirya mukyaaro kino, Taatabhugya wuno ari mwiisaaro arabha agiikiriirye.” ");
INSERT INTO zak_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Niho Yeesu akarekya abhaanabheega bhaaye kubha, bhataaza bhakamubhuurira muutu wowoosi kubha ewe niwe Masiya. ");
INSERT INTO zak_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kweemera eriibhaga riyo, Yeesu akataanga okubhabhuurira abhaanabheega bhaaye kubhweero kubha, kwo obhuseegi bhwa Taatabhugya areenderwa agye Yerusaremu, no okubhona enyaako nzaru. Kweeki areenderwa anyaakibhwe na abhakaruka bha Abhayahudi na abhakuru bha abhaseengeri na abheegya bhe emigiro, tee yiitwe. Nawe orusiku rwa katatu, araryookibhwa. ");
INSERT INTO zak_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Niho, Petero akamugega Yeesu kibhezo, akataanga okumurekya, “Ee Omukuru, Taatabhugya agateere kure gayo! Gataaza gakubhone gayo!” ");
INSERT INTO zak_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nawe Yeesu akamwiikibhukira Petero, akamubhuurira, “Seetaani, noogye inyuma waane! Orasakya kunirekya kukora obhuseegi bhwa Taatabhugya! Awe otakugania ga Taatabhugya, nawe oragania ga abhaatu.” ");
INSERT INTO zak_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ambe, Yeesu akabhabhuurira abhaanabheega bhaaye, “Omuutu wowoosi wuno akweenda kunituniirira, areenderwa yiiyaange omweene, agege omusaraba gwaaye, anituniirire. ");
INSERT INTO zak_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Omuutu wowoosi wuno akweenda kutuurya obhwiikari bhwaaye omweene, arabhubhurya. Nawe omuutu wowoosi wuno araabhurye obhwiikari bhwaaye kwiiguru waane, wuyo niwe araabhubhone. ");
INSERT INTO zak_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Angu, omuutu arabhona bhweeraki eraabhe abhweeni ebhigiro bhyoosi bhye ekyaaro kino, nawe abhurirye obhuhoru bhwaaye bhwa kirakeego? Kitariho ekigiro kino kikunagya okumukyoorerya obhuhoru bhuyo. ");
INSERT INTO zak_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Enye Omwaana wo Omuutu, ndaaza hamwe na maraika bhaane mubhuguungo bhwa Taata waane. Niho ndaabharihe abhaatu bhoosi kuriingʼaana na amahokya gaabhu. ");
INSERT INTO zak_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ndabhabhuurira obhuheene, bhariho abhamwe gati weenyu bhano bhatakukwa bhakyaari kunirora enye Omwaana wo Omuutu, nikuuza kubhutemi bhwaane.” ");
INSERT INTO zak_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Hano zyahitiri eziisiku isaasabha, Yeesu akagega Petero, Yaakobo na Yohana, akatiira nabho mukiguru ekitaambi, kibhezo. ");
INSERT INTO zak_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hano bhaari hayo, Yeesu akakyoorwa embere waabhu. Obhusyo bhwaaye bhukabhara kyeego eryoobha ne eziingibho zyaaye zikabha ndabhu bhukongʼu kyo obhweero. ");
INSERT INTO zak_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hayohayo, bhakatuukira Musa na Eriya bhakabha bharakeerenia neewe. ");
INSERT INTO zak_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Niho Petero akamubhuurira Yeesu, “Ee Omukuru, ni kisi etwe kubha hano. Eraabhe oriikirirya, ndoomboka hano ebhihuuna bhitatu. Ekimwe kibhe ekyaazo, ekiindi kibhe kya Musa, ne ekiindi kibhe kya Eriya.” ");
INSERT INTO zak_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hano Petero yaakyagaamba, kituukiro, eriisaaro rikiituuma riramesya no okubhakuundikirya. Kyaamwe bhakiigwa eriiraka okurwa mwiisaaro riyo rirabhuga, “Wuno niwe Omwaana waane omuseegwa, nizomereerwe neewe. Mubhe muramwiitegeerera!” ");
INSERT INTO zak_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hano abhaanabheega bhaaye bhiigwiiri gayo, bhakoobhoha bhukongʼu, bhakahigama haasi bhubhuumari. ");
INSERT INTO zak_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yeesu akiisuka haguhi nabho, akabhakuniaku, akabhabhuurira, “Mwiimeerere, mutoobhoha!” ");
INSERT INTO zak_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hano bhaaramukirye ameeso gaabhu, bhakamurora Yeesu asaagiri omweene ego. ");
INSERT INTO zak_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hano bhaari kwiituuma mukiguru hayo, Yeesu akabhaswaagya, “Mutaaza kubhuurira muutu wowoosi gano muruuzi, tee eriibhaga rino enye Omwaana wo Omuutu, ndaaryookibhwe okurwa mubhaku.” ");
INSERT INTO zak_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abhaanabheega bhayo bhakamubhuurya, “Kwaki abheegya bhe emigiro gya Musa bharabhuga kubha, ereenderwa Eriya yiize hiinga niho Masiya yiize?” ");
INSERT INTO zak_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeesu akabhakyoora, “Niigo eri, Eriya areenderwa yiize hiinga okubha atuure kisi amangʼana goosi. ");
INSERT INTO zak_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nawe ndabhabhuurira Eriya amariri kuuza, nawe abhaatu bhataamumenyiri, bhakamukorera amabhi goosi gano bhakeenda. Egoego ne enye Omwaana wo Omuutu, ndanyaakibhwa mumabhoko gaabhu.” ");
INSERT INTO zak_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Niho abhaanabheega bhaaye bhakamenyeekererya kubha Yeesu yaari arakeerenia iguru ya Yohana Omubatiizi. ");
INSERT INTO zak_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hano Yeesu na abhaanabheega bhaaye bhaakyooriri hano haari ne esaango ya abhaatu, omuutu wumwe akaaza ku Yeesu, akahigama embere waaye. ");
INSERT INTO zak_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Akamubhuurira Yeesu, “Ee Omukuru, ndasabha omurorere ebhigoongi omwaana waane! Ano obhurweeri bhwe eriirimu, no obhurweeri bhuyo bhuramunyaakya bhukongʼu. Maanga maaru aragwa mumuriro kasi mumaanzi. ");
INSERT INTO zak_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nikamuhira kubhaanabheega bhaazo okubha bhamuhorye, nawe bhakatamwa.” ");
INSERT INTO zak_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yeesu akabhuga, “Emwe abhaatu bho orwiibhuro runo, mutana obhwiikirirya, ndiikara neemwe tee ryoori? Ndabhiigumiirirya tee ryoori? Mumureete hano omwaana wuyo.” ");
INSERT INTO zak_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hano bhaamureetiri, Yeesu akaheebha eriisaambwa eriibhi rino ryaari muusi waaye, neeryo rikarwamu. Hayohayo, omwaana akahora. ");
INSERT INTO zak_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kyaamwe abhaanabheega bha Yeesu bhakamugyaku kibhezo, bhakamubhuurya, “Kwaki tukatamwa okuriheebha eriisaambwa rirya?” ");
INSERT INTO zak_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Neewe akabhakyoora, “Ni kwe ekigirirye kyo obhwiikirirya bhweenyu bhutakwiisa. Ndabhabhuurira obhuheene, eraabhe muungabheeri no obhwiikirirya bhusuuhu bhukongʼu kye etetere esuuhu bhukongʼu, muungabhuuriiri ekiguru kino, ‘Noorwe hano, ogye harya,’ nakyo kiingagiiri. Kweego kitariho kigiro kino kitaari kuturikana kweemwe.  ");
INSERT INTO zak_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hamwe na gayo, eriisaambwa kya riyo mutakunagya kuriheebha, nawe kwe enzira yo okusabha Taatabhugya no okwiisiitya ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hano Yeesu yaari hamwe na abhaanabheega bhaaye mukyaaro kya Gariraaya, akabhabhuurira, “Enye Omwaana wo Omuutu, ndatuurwa mumabhoko ga abhaatu na bharaniita. Nawe kurusiku rwa katatu, Taatabhugya araniryoora.” ");
INSERT INTO zak_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hano abhaanabheega bhaaye bhiigwiiri gayo, bhakabha ne ebhigoongi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hano Yeesu na abhaanabheega bhaaye bhaahikiri mumugye gwa Kaperinaumu, abhaatu abharebhe bhano bhaari bharatobhya eriigooti kwiiguru we eriiseengerero rya Taatabhugya, bhakaaza ku Petero. Bhakamubhuurya, “Awe, omweegya weenyu neewe araruusya eriigooti rye eriiseengerero rya Taatabhugya?” ");
INSERT INTO zak_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petero akabhakyoora, “Niigo eri, araruusya.” Niho akasikira munyuumba. Nawe Petero yaakyaari kugaamba engʼana yoyoosi, Yeesu akeema okumubhuurya, “Ee Simooni, awe orarorabhwi? Abhatemi bha mukyaaro kino bharatobhya eriigooti kubhaatu bhaabhu kasi kubhaatu bhaandi?” ");
INSERT INTO zak_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero akamukyoora, “Bharatobhya kubhaandi.” Yeesu akamubhuurira, “Eraabhe niigo eri, ambe abhaana bhaabhu bhaabhiirwe kuriha eriigooti. ");
INSERT INTO zak_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nawe tutaaza tukabhabhiihirirya abhaatu bhano, awe noogye munyaanza, orekere endobho mumaanzi. Niho eswe yo okutaanga yino oraagwaate, oyitaanurye omunwa, orabhonamu orubhirya. Ogege orubhirya ruyo, ogye orihe eriigooti ryaane ne eryaazo.” ");
INSERT INTO zak_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Eriibhaga riyo, abhaanabheega bha Yeesu bhakamuuzaku, bhakamubhuurya, ");
INSERT INTO zak_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","“Ni weewi omukuru kukira abhaandi bhoosi mubhutemi bhwa mwiisaaro?” Yeesu akamubhirikira omwaana omusuuhu, akamwiimeererya gatigati waabhu. ");
INSERT INTO zak_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Akabhabhuurira, “Ndabhabhuurira obhuheene, eraabhe mutakwiikyoora no okubha kya abhaana abhasuuhu, mutakusikira kimwe mubhutemi bhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kweego, omuutu wowoosi wuno akwiiyiikya no okubha kyeego omwaana omusuuhu wuno, wuyo niwe araabhe omukuru mubhutemi bhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kweeki, omuutu wowoosi wuno akumuginihya omwaana omusuuhu kya wuno kwe eriina ryaane, aniginihirye enye. ");
INSERT INTO zak_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nawe eraabhe ariho omuutu wuno araamubhurye owumwe wa abhasuuhu bhano, bhano bhakuniikirirya enye, akagirya akore ebhibhi, yiingabheeri kisi abhoherwe orubhwe mwiigoti no okurekerwa mukiryoonge kye enyaanza. ");
INSERT INTO zak_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Muraaza kurora emwe abhaatu bhe ekyaaro kino, kwo okukora amangʼana gano gakugirya abhaatu bhakore ebhibhi! Obhusakya bhutakuturikana okutama kubhaho, nawe araaza kurora omuutu wuno akureeta obhusakya bhuyo! ");
INSERT INTO zak_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Eraabhe ni kubhoko kwaazo kasi ni kuguru kwaazo nikwo kukugirya okore ebhibhi, okutine no okukurekera kure. Yiingabheeri kisi kusikira mubhuhoru bhwa kirakeego oribha murema, kukira kubha na amabhoko goosi abhiri kasi amaguru goosi abhiri, nawe okarekerwa mumuriro gwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kweeki, eraabhe ni riiso ryaazo niryo rikukugirya okore ebhibhi, oriihe no okurirekera kure! Yiingabheeri kisi kusikira mubhuhoru bhwa kirakeego one kitongʼo, kukira kubha na ameeso goosi abhiri, nawe okarekerwa mumuriro gwa nyaari.” ");
INSERT INTO zak_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yeesu akageenderera kubhabhuurira, “Mwiiriihe, mutarega owumwe wa abhasuuhu bhano! Ndabhabhuurira ego, kwo okubha bhamaraika bhaabhu bha mwiisaaro, eriibhaga ryoosi bharabhurora obhusyo bhwa Taata waane wa mwiisaaro.  ");
INSERT INTO zak_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Enye Omwaana wo Omuutu, niiziri mukyaaro okubha nibhatuurye abhaatu bhano bhabhuriri. ");
INSERT INTO zak_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Muriiseegabhwi? Eraabhe omuutu ane eziingʼoondu igana rimwe (100), ne eyimwe gati waabhu ebhuriri, arakorabhwi? Arazitiga mubhiguru eziingʼoondu miroongo keenda na keenda (99), na aragya kuyikomya yirya ebhuriri? Eheene arakora! ");
INSERT INTO zak_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndabhabhuurira obhuheene, eraabhe ayibhweeni, arazomererwa bhukongʼu kwe engʼoondu yino eyimwe, kukira eziingʼoondu zirya miroongo keenda na keenda (99) zino zitaabhuriri. ");
INSERT INTO zak_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Kweego ego, Wuuso weenyu wa mwiisaaro, atakweenda kubha naabhe owumwe wa abhasuuhu bhano abhure. ");
INSERT INTO zak_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Eraabhe omwiikirirya omurikyaazo akusariirye, noogye omurekye mukubha bhabhiri ego. Araakwiigwe, ambe orabha omubhweeni kweeki omwiikirirya omurikyaazo. ");
INSERT INTO zak_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nawe kyeego akyaari kukwiigwa, noogye omugege omuutu owuundi kasi abhaatu bhabhiri okubha ‘bhabheho abhamenyeekererya bhabhiri kasi bhatatu bho okumenyeekererya,’ kyeego Amakaamo Amahoreeru gakubhuga. ");
INSERT INTO zak_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne eraabhe atakubhiigwa bhayo, obhuurire abhaatu bhe ekanisa. Eraabhe atakwiigwa ekanisa, omwaahure kyo omuutu wuno atamumenyiri Taatabhugya kasi omutobhya we eriigooti. ");
INSERT INTO zak_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ndabhabhuurira obhuheene, gogoosi gano mukugarekya mukyaaro kino, Taatabhugya wuno ari mwiisaaro arabha agarekirye. Kweeki, gogoosi gano mukugiikirirya mukyaaro kino, Taatabhugya wuno ari mwiisaaro arabha agiikiriirye. ");
INSERT INTO zak_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kweeki, ndabhabhuurira obhuheene, eraabhe abhabhiri gati weenyu bhariikirirania mukyaaro kino okusabha eriingʼana ryoryoosi, Taata waane wa mwiisaaro arabhakorera eriingʼana riyo. ");
INSERT INTO zak_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwo okubha, hohoosi hano bhakubhaho naabhe abhaatu bhabhiri kasi bhatatu bhano bhiikumaniirye kwe eriina ryaane, na neenye ndabhaho hayo hamwe nabho.” ");
INSERT INTO zak_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Niho Petero akaaza ku Yeesu, akamubhuurya, “Ee Omukuru, eraabhe omwiikirirya omurikyaane anisariirye, nireenderwa nimwaabhire kariinge? Nimwaabhire muhuungati koosi?” ");
INSERT INTO zak_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu akamukyoora, “Nikubhuurire, etari muhuungati ego, nawe omwaabhire omurikyaazo muhuungati maanga miroongo muhuungati (70). ");
INSERT INTO zak_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ndabhabhuurira ego, kwo okubha obhutemi bhwa mwiisaaro bhutuubheeni ne ekireengyo kino. Yaari ariho omutemi wumwe wuno yeendiri okumenya obhubhari bhwe eziimbirya na abhagya bhaaye. ");
INSERT INTO zak_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hano omutemi yataangiri okubhara, akareeterwa omugya wumwe wuno yaari akutunibhwa eziimbirya nzaru bhukongʼu, eziitaraanta ebhikwe ikumi (10,000). ");
INSERT INTO zak_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Omugya wuyo, ataanagirye kuriha esiiri yiyo. Niho omutemi akaswaagya kubha omuutu wuno aguribhwe hamwe na mukaaye, abhaana bhaaye ne ebhigiro bhyoosi bhino yaari nabhyo, okubha arihe esiiri yaaye. ");
INSERT INTO zak_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ambe, omugya wuyo akamuhigamira omutemi, akamukumiirirya, ‘Ndasabha oniigumiirire, ndakuriha esiiri yaazo yoosi!’ ");
INSERT INTO zak_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Niho, omutemi akamurorera ebhigoongi omugya waaye, akamwaabhira esiiri yaaye yoosi, akamuhaatira agye owaaye. ");
INSERT INTO zak_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Hano omugya wuyo yarwiiri igutu, akamubhona omugya omurikyaaye wuno yaari aramutunia eziimbirya suuhu bhukongʼu, ekireengo kye eziidinaari igana rimwe ego (100). Hayohayo, akamumamira mwiimiro, akamubhuurira, ‘Nirihe esiiri yaane!’ ");
INSERT INTO zak_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Omugya omurikyaaye akamuhigamira, akamukumiirirya, ‘Ndasabha oniigumiirire, ndakuriha esiiri yaazo!’ ");
INSERT INTO zak_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nawe akaanga, akagya okumubhoha omurikyaaye munyuumba ya abhabhohwa, tee eriibhaga rino araarihe esiiri yaaye. ");
INSERT INTO zak_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Hano abhagya abharikyaaye bhaaruuzi engʼana yiyo, bhakarumirirwa bhukongʼu muziikoro zyaabhu. Niho bhakagya kumutemi waabhu no kumubhuurira goosi gano gaakorekiri. ");
INSERT INTO zak_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Niho omutemi akamubhirikira omugya wuno yamwaabhiiri esiiri yaaye, akamubhuurira, ‘Awe ni mugya omubhiihu bhukongʼu! Rora, hano wanisabhiri kubha nikwaabhire esiiri yaazo, nakwaabhiiri yoosi! ");
INSERT INTO zak_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mbe, na woosi otakweenderwa kumurorera ebhigoongi omugya omurikyaazo, kyeego enye nakuroreeri awe ebhigoongi?’ ");
INSERT INTO zak_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ambe, omutemi akabhiihirirwa bhukongʼu, akaragania abhasirikare bhaaye, bhamugwaate no okumutuura munyuumba ya abhabhohwa bhabhe bharamunyaakya, tee hano araarihe esiiri yoosi.” ");
INSERT INTO zak_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kyaamwe, Yeesu akamariirya kwo okugaamba, “Mumenye kubha naabhe Taata waane wa mwiisaaro, arabhakorera na neemwe egoego, eraabhe muraanga kumwaabhira omwiikirirya omurikyeenyu kwe eziikoro zyeenyu zyoosi.” ");
INSERT INTO zak_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hano Yeesu yamariri okugaamba amangʼana gayo, akatanura Gariraaya eyo, akahita kumwaambuko gwe Ekitaaro kya Yorodaani kugya mukyaaro kya Yudea. ");
INSERT INTO zak_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Abhaatu bhaaru bhakabha bharamutuniirira eyo, neewe akahorya abharweeri bhano bhaari gati waabhu. ");
INSERT INTO zak_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Niho Abhafarisayo abharebhe bhakaaza ku Yeesu okubha bhamusakye. Bhakabhuga, “Mbe, emigiro gya Musa giriikirirya omusubhe okutaana na mukaaye kwe ekigirirye kyokyoosi kirya?” ");
INSERT INTO zak_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yeesu akabhakyoora, “Emwe mukyaari kusoma mu Makaamo Amahoreeru kubha, kweema obhweemero bhwo okuteemwa ekyaaro, ‘Taatabhugya akabhabhuumba omusubhe no omukari’? ");
INSERT INTO zak_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Niho Taatabhugya akabhuga, ‘Kwe ekigirirye kiyo, omusubhe aratiga wiise na nina waabhu, aragwaatana na mukaaye, na abhabhiri bhano bharabha mubhiri gumwe.’ ");
INSERT INTO zak_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ambe ndabhabhuurira, bhatakubha bhabhiri kweeki, nawe ni wumwe. Kweego abhaatu bhano Taatabhugya abhagwaateenie, omuutu ataaza kubhatwaanikania.” ");
INSERT INTO zak_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kweeki, Abhafarisayo bhayo bhakamubhuurya, “Eraabhe gano ni ge eheene, ambe ni kwaki Musa akaragania kubha omusubhe amuhe mukaaye enyaarubha yo okutaana no okumuheebha?” ");
INSERT INTO zak_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu akabhakyoora, “Musa yabhiikiriirye kubha mutaane na abhakari bheenyu kwo okubha eziikoro zyeenyu ni kongʼu, nawe okweemera obhweemero, rino ritaari eriiseego rya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Enye ndabhabhuurira kubha, omuutu wowoosi wuno akutaana na mukaaye, nawe kwo obhutuungiri, no okukweera omukari owuundi, wuyo aseebheetiri, na wuno akumukweera wurya yatigirwe, aseebheetiri.” ");
INSERT INTO zak_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Niho abhaanabheega bhaaye bhakamubhuurira, “Eraabhe niigo gari kumusubhe no omukari, ambe ni bhuzomu omuutu atakweera!” ");
INSERT INTO zak_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yeesu akabhakyoora, “Bhatari abhaatu bhoosi bharanagya okurisuungʼaana rino mukugaamba, nawe bharya bhano Taatabhugya abhaheeri obhuturo. ");
INSERT INTO zak_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndagaamba ego, kwo okubha bhariho abhasubhe abhaandi bhano bhatakukweera bhakiibhurwa ni bhazigaru. Abhaandi bhatakukweera kwo okubha abhaatu bhabhakoriri abhazigaru. Kweeki bhariho na abhaandi bhano bhatakukweera kwo obhutemi bhwa mwiisaaro. Omuutu wowoosi wuno akunagya okurisuungʼaana eriingʼana riyo, na arisuungʼaane.” ");
INSERT INTO zak_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ambe, abhaatu abharebhe bhakabhareeta abhaana bhaabhu abhasuuhu ku Yeesu okubha abhatweere ebhite kwo okutuurira amabhoko no okubhasabhira. Kyaamwe abhaanabheega bhaaye bhakabharekya abhaatu bhayo. ");
INSERT INTO zak_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nawe Yeesu akabhuga, “Mubhatige abhaana abhasuuhu bhiize kweenye! Mutabharekya, kwo okubha obhutemi bhwa mwiisaaro ni bhwa abhaatu kya abhaana bhano.” ");
INSERT INTO zak_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yeesu akabhatweera ebhite abhaana bhayo, kyaamwe akatanura ahagiro hayo. ");
INSERT INTO zak_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Orusiku rumwe omumura owumwe akaaza ku Yeesu, akamubhuurya, “Ee Omweegya, nikore ngʼanaki enzomu okubha nibhone obhuhoru bhwa kirakeego?” ");
INSERT INTO zak_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yeesu akamukyoora, “Otakweenderwa kumbuurya enye kwiiguru ye engʼana enzomu. Bhuurya Taatabhugya, ewe omweene ego niwe omuzomu! Nawe kyeego okweenda kusikira mubhuhoru bhwa kirakeego, ogwaate obhuswaagyo bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Omumura wuyo akamubhuurya, “Bhuswaagyoki?” Yeesu akamukyoora, “Otiita, otaseebheeta, otiibha, otamenyeekererya orurimi, ");
INSERT INTO zak_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","obhasuuke wuuso na nyoko weenyu, no omuseege omurikyaazo kyeego wiiseegiri omweene.” ");
INSERT INTO zak_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Omumura wuyo akabhuga, “Obhuswaagyo bhwoosi bhuyo nibhugwaatiri. Nisuuhiirweki kweeki?” ");
INSERT INTO zak_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu akamubhuurira, “Eraabhe oreenda kubha otana eriisoro, noogye ogurye ebhigiro bhyoosi bhino onabhyo, ne eziimbirya zino oraabhone, obhatwaanire abhataka. Oribha okoriri ego, orabha wiituuriiri ehata mwiisaaro. Okumara, wuuze onituniirire.” ");
INSERT INTO zak_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hano omumura wuyo yiigwiiri gayo, akatanura kwe ebhigoongi, kwo okubha yaari ne ebhigiro bhyaaru bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Niho Yeesu akabhabhuurira abhaanabheega bhaaye, “Ndabhabhuurira obhuheene, erabha kukongʼu kumuniibhi kusikira mubhutemi bhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ndabhabhuurira kweeki, ni kunyoohu engamia okuhita mukibhaanga kyo orugera, kukira omuniibhi kusikira mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hano abhaanabheega bhaaye bhiigwiiri ego, bhakaruguura bhukongʼu, bhakamubhuurya, “Ambe, eraabhe niigo gari, weewi wuno akunagya kutuuribhwa?” ");
INSERT INTO zak_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yeesu akabhamogorera, akabhabhuurira, “Kubhaatu riyo ritakuturikana, nawe ku Taatabhugya goosi garaturikana.” ");
INSERT INTO zak_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petero akamubhuurira, “Rora, etwe tukatiga ebhigiro bhyoosi, tukakutuniirira, neetwe turabhonaki?” ");
INSERT INTO zak_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yeesu akabhakyoora, “Ndabhabhuurira obhuheene, eriibhaga enye Omwaana wo Omuutu, ndabha niikeeri kukituumbi kyaane kyo obhuguungo mukyaaro kino kikuuza. Ambe, eriibhaga riyo na neemwe bhano munituniiriiri, muriikara kubhituumbi bhyo obhutemi ikumi na bhibhiri, eno murabhaaha ebhisyooko ikumi na bhibhiri bhya Iziraeri. ");
INSERT INTO zak_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ambe, omuutu wowoosi wuno atigiri enyuumba, kasi abhamura bhaabhu, kasi abhasubhaati bhaaye, kasi wiise na nina waabhu, kasi abhaana bhaaye kasi emiguundu gyaaye kwiiguru waane, arasuungʼaana gayo goosi kwo obhwaaru kukiraho. Hamwe na gayo, arabhona obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nawe abhaaru bhano bhakurorekana ni bhakuru bhoono, bhatakubha no obhweera bhwobhwoosi mukyaaro kino kikuuza. Kweeki abhaaru bhano bhakurorekana bhatari bhakuru bhoono, bharabha bhakuru mukyaaro kino kikuuza.” ");
INSERT INTO zak_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yeesu akageenderera okugaamba, “Obhutemi bhwa mwiisaaro bhutuubheeni na mweene muguundu wuno yarwiiri igutu etabhoori zuri okumoohya abhaatu bhamuhokeerye emirimo mumuguundu gwaaye gwe emizabibu. ");
INSERT INTO zak_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hano yabhabhweeni, akiikirirania nabho kubha omuutu wuyo woosi arihe edinaari yimwe, yino yaari omuheero gwo orusiku rumwe. Kyaamwe, akabharagania mumuguundu gwaaye. ");
INSERT INTO zak_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Hano ryahikiri eriibhaga rya katatu etabhoori, akagya kumuteera, akarora abhaatu abhaandi bhano bhatana mirimo. ");
INSERT INTO zak_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Akabhabhuurira, ‘Na neemwe mugye mukore emirimo mumuguundu gwaane gwe emizabibu. Ndabhariha kyeego ekweenderwa.’ ");
INSERT INTO zak_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nabho bhakagya. “Ambe, hano ryahikiri eriibhaga rya kasaasabha, akagya kweeki okubhaha emirimo abhaatu abhaandi mumuguundu gwaaye. Na hano eziisa isatu zyahitiri, akakora ego kweeki. ");
INSERT INTO zak_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hano ryahikiri eriibhaga ryi ikumi na yimwe engoroobha, akahuruka igutu kweeki okugya kumuteera, akabhona abhaatu abhaandi bhatana mirimo. Akabhabhuurya, ‘Kwaki mwiimeereeri hano orusiku orugima mutana mirimo gyogyoosi?’ ");
INSERT INTO zak_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Nabho bhakamukyoora, ‘Atariho omuutu wuno akutuha emirimo.’ “Ewe akabhabhuurira, ‘Na neemwe mugye mukore emirimo mumuguundu gwaane gwe emizabibu.’ ");
INSERT INTO zak_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Hano ekiirima kyaataangiri kusikira, mweene muguundu akamubhuurira omwiimeerereri we emirimo gyaaye, akabhuga, ‘Obhabhirikire abhahokya bhoosi, obhahe omuheero gwaabhu. Hano okubhariha, otaange na abhahokya bhano bhiiziri mubhuteero no omariirye na bhano bhiiziri kubhutaangiro.’ ");
INSERT INTO zak_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Niho abhahokya bhano bhaataangiri emirimo engoroobha, bhakaaza bhakahaanwa edinaari yimwe yino yaari omuheero gwo orusiku rumwe. ");
INSERT INTO zak_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kweego abhabhagati bhano bhaataangiri emirimo etabhoori hano bhiiziri kugega emiheero gyaabhu, bhakiisiga okusuungʼaana kukira abharikyaabhu bhano bhaataangiri mubhuteero. Nawe bhoosi bhakarihwa orubhirya ruryarurya rwo omuheero gwo orusiku rumwe. ");
INSERT INTO zak_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kweego, eriibhaga bhaasuungʼaaniri omuheero gwaabhu, bhakataanga kuririirira kumweene muguundu, ");
INSERT INTO zak_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","bharabhuga, ‘Abhaatu bharya bhakoriri emirimo kwe eriibhaga rimwe ego! Bhoono ebheeribhwi otuheeri kuriingʼaana nabho, eriibhaga etwe tukoriri emirimo mikongʼu orusiku orugima no omubhaso gutuhweereeriku?’ ");
INSERT INTO zak_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mweene muguundu akamukyoora owumwe wa abhahokya bhayo, ‘Ee musaani, nikyaari kukungʼeena kyokyoosi. Mbe, tutiikirireenie kubha orakora emirimo kwo omuheero gwo orusiku rumwe? ");
INSERT INTO zak_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Gega eziimbirya zyaazo, ogye owaazo. Enye niseegiri okumuriha omuutu wo obhuteero omuheero guno gukuriingʼaana no ogwaazo. ");
INSERT INTO zak_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mbe, nitakwiikiriribhwa kuhokeerya eziimbirya zyaane kyeego nikweenda? Kasi orarora omugono kwo okubha enye ni muhaani bhukongʼu kubhaatu abhaandi?’ ” ");
INSERT INTO zak_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeesu akamariirya kwo okugaamba, “Kweego, abhaatu bhano ni bho obhuteero, bharabha bho okutaanga, na bhano bho okutaanga, bharabha bho obhuteero.” ");
INSERT INTO zak_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hano Yeesu yaari munzira kugya Yerusaremu, akagya kibhezo na abhaanabheega bhaaye ikumi na bhabhiri, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Murore, bhoono tureerekera Yerusaremu. Niho, enye Omwaana wo Omuutu, ndatuurwa mumabhoko ga abhakuru bha abhaseengeri na mumabhoko ga abheegya bhe emigiro. Nabho bharanitinira ekiina kubha niitwe. ");
INSERT INTO zak_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mubhuteero, bharanituura mumabhoko ga abhaatu bhano bhatari Abhayahudi okubha bhanizabhure, bhaniteme emijariti no okunibhaamba kumusaraba. Nawe orusiku rwa katatu, Taatabhugya araniryoora.” ");
INSERT INTO zak_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Niho, nina waabhu Yaakobo na Yohana, omukari wa Zebedaayo akaaza ku Yeesu hamwe na abhaana bhaaye bhabhiri, akahigama embere waaye, akamusabha amukorere kigiro kimwe. ");
INSERT INTO zak_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yeesu akamubhuurya, “Oreenda nikukorereki?” Neewe akamukyoora, “Ndasabha obhiikirirye abhaana bhaane bhano bhabhiri kubha, bhiikare kubhituumbi hamwe naawe mubhutemi bhwaazo, owumwe orubhaara rwo obhuryo no owuundi orubhaara rwo obhumosi.” ");
INSERT INTO zak_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu akamukyoora, “Mutamenyiri gano mukusabha. Mbe, muranagya okukinyweera ekikoombe kye enyaako kino nikugya kukinyweera?” Bhakamukyoora, “Turanagya.” ");
INSERT INTO zak_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeesu akabhabhuurira, “Eheene muranywa ekikoombe kye enyaako yaane, nawe okwiikara orubhaara rwaane rwo obhuryo kasi rwo obhumosi gutari murimo gwaane okubhiikirirya. Nawe Taatabhugya arabhaha bhano amariri kubhabhanura.” ");
INSERT INTO zak_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hano abhaanabheega abhaandi ikumi bhiigwiiri iguru ya riyo, bhakabhatiindira abharikyaabhu bhabhiri bhayo. ");
INSERT INTO zak_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Niho Yeesu akabhabhirikira bhoosi hamwe, akabhabhuurira, “Mumenyiri kubha abhakaangati bhe ebhyaaro bharabhaaha abhaatu bhaabhu kwa amanaga, na bharabhakorya emirimo. ");
INSERT INTO zak_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nawe etaaza ekabha kweemwe ego. Omuutu wowoosi wuno akweenda kubha omukuru gati weenyu, areenderwa kubha omubhagati weenyu. ");
INSERT INTO zak_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kweeki, omuutu wuno akweenda kubha wo okutaanga gati weenyu, areenderwa abhe omugya weenyu. ");
INSERT INTO zak_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ni kye enye Omwaana wo Omuutu, nitiiziri kuhokeeribhwa, nawe nikaaza kubhahokeerya abhaatu no okuruusya obhuhoru bhwaane, bhubhe endihi ya abhaatu bhaaru.” ");
INSERT INTO zak_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hano Yeesu na abhaanabheega bhaaye bhaari bharareka mumugye gwa Yeriko, esaango ekuru ya abhaatu ekamutuniirira. ");
INSERT INTO zak_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Embarika we enzira yino Yeesu yaari akuhita, bhaari bhariho abhahoku bhabhiri. Ambe, hano bhakiigwa kubha Yeesu yaari arahita hayo, bhakabhirikira kwiiraka ikuru, “Ee Omukuru, Omwaana wo omutemi Daudi, turakusabha oturorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Esaango ya abhaatu ekabharekya kubha bhakire, nawe ebho bhakageenderera okubhirikira kwe eriiraka ikuru, “Ee Omukuru, Omwaana wo omutemi Daudi, turasabha oturorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ambe, Yeesu akiimeerera, akabhabhirikira, akabhabhuurya, “Mureenda nibhakorereki?” ");
INSERT INTO zak_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Abhahoku bhayo bhakamukyoora, “Ee Omukuru, tureenda ameeso geetu gahore!” ");
INSERT INTO zak_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Niho Yeesu akabharorera ebhigoongi, akabhabhata ameeso gaabhu. Hayohayo, ameeso gaabhu gakahora, nabho bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Hano Yeesu na abhaanabheega bhaaye bhiisukiiri Yerusaremu, haguhi mumugye gwa Betifage, mu Kiguru kye Emizeituni. Niho Yeesu akabharagania bhabhiri gati wa abhaanabheega bhaaye, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Mugeende mumugye guno guri embere weenyu. Hano muraasikire muyo, murarora etikiri ebhohirwe, hamwe ne ekimoori kyaku. Niho muzisibhure, munireetere hano. ");
INSERT INTO zak_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eraabhe omuutu wowoosi arabhabhuurya eriibhuuryo ryoryoosi, mumukyoore, ‘Omukuru arazyeenda,’ neewe arabhiikirirya muuze nazyo.” ");
INSERT INTO zak_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gayo gaakorekiri ego, okubha rikuunaane eriingʼana rino Taatabhugya yabhugiri kwe enzira yo omurooti waaye, ");
INSERT INTO zak_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Obhabhuurire abhaatu bha Sayuni, ‘Murore, omutemi weenyu araaza kweemwe, ni munyoohu, araaza yiikeeri kutikiri, yino ene ekimoori.’ ” ");
INSERT INTO zak_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ambe, abhaanabheega bhaaye bhakagya, bhakakora kyeego Yeesu akabharagania. ");
INSERT INTO zak_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hano bhaakyooriri ku Yeesu ne etikiri yirya ne ekimoori kyaku, bhakabha bhaarirye emyeenda iguru we eziitikiri ziyo, na Yeesu akatiira, akiikara. ");
INSERT INTO zak_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Haari ne esaango ekuru ya abhaatu, na abhaaru gati waabhu bhakaarya emyeenda gyaabhu kunzira. Abhaandi bhakatina amasagya ge emiti no okwaarya kunzira kwo okumusuuka Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abhaatu bhakamukaangatira Yeesu, na abhaandi bhakamutuniirira inyuma, bhakabhirikira kwa kwiinuurya kwiiraka ikuru, “Akumibhwe Omwaana wo omutemi Daudi! Atweerwe ebhite wuno akuuza kuriina ryo Omukuru! Akumibhwe Taatabhugya wuno ari mwiisaaro!” ");
INSERT INTO zak_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hano Yeesu yasikiiri mumugye gwa Yerusaremu, abhaatu bho omugye gwoosi bhakaruguura bhukongʼu, bhariibhuuryabhuurya, “Ni weewi wuyo?” ");
INSERT INTO zak_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Abhaatu bhe esaango yiyo bhakabhakyoora, “Wuno ni Yeesu! Ni murooti wurya wa Nazareeti mumugye gwa Gariraaya!” ");
INSERT INTO zak_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Niho Yeesu akasikira mwiigoobhe rye eriiseengerero rya Taatabhugya. Hano yasikiiri muyo, akabhabhona abhaaru bhano bhaari kugura no okugurya ebhigiro muyo, akabhaheebha bhoosi. Akazigwiisya eziimeeza zya bhano bhaari bhakukirania eziimbirya, no okubhihuungura ebhituumbi bhya bhano bhaari bhakugurya ebhiguuti. ");
INSERT INTO zak_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yeesu akabhabhuurira, “Taatabhugya abhugiri mu Makaamo Amahoreeru, ‘Enyuumba yaane erabha enyuumba ya amasabhi.’ Nawe emwe murayikora kubha eriibhigi rya abhateesya!” ");
INSERT INTO zak_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ambe, eriibhaga Yeesu yaari akyaari mwiigoobhe rye eriiseengerero, abhahoku na amagata bhakaaza kweewe, neewe akabhahorya. ");
INSERT INTO zak_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nawe abhakuru bha abhaseengeri na abheegya bhe emigiro hano bhaaruuzi ebhitiika bhya Yeesu no okwiigwa abhaana bharagaamba kwiiraka ikuru mwiiseengerero, “Akumibhwe Omwaana wo omutemi Daudi,” bhakatiinda bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakamubhuurya Yeesu, “Mbe, oriigwa gano abhaana bhano bhakagaamba?” Yeesu akabhakyoora, “Ndiigwa. Awee mukyaari kusoma amangʼana gano gakaamirwe mu Makaamo Amahoreeru, ‘Obhanwiiri obhukumyo kwaawe, okuhitira eminwa gya abhaana abhasuuhu na abharere’?” ");
INSERT INTO zak_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yeesu akabhatiga hayo, akarwa mumugye gwa Yerusaremu, akagya okuhiindira omugye gwa Betania. ");
INSERT INTO zak_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Etabhoori yaho, Yeesu hano yaari kukyoora Yerusaremu, akiigwa enzara. ");
INSERT INTO zak_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Niho akarora embarika we enzira omuti gumwe guno gukubhirikirwa omutiini. Akiisuka haguhi, akabhona gutana misumo gyogyoosi, nawe guna amatu ageene ego. Kweego akagubhuurira omuti gurya, “Otakwiibhura emisumo kweeki!” Hayohayo, omuti gukooma. ");
INSERT INTO zak_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hano abhaanabheega bha Yeesu bhaagaruuzi gayo, bhakaruguura bhukongʼu. Bhakamubhuurya, “Igabhwi omuti guno gwoomiri kituukiro ego?” ");
INSERT INTO zak_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeesu akabhakyoora, “Ndabhabhuurira obhuheene, eraabhe muno obhwiikirirya bhuno bhutana bhwiitiimaati, na neemwe muranagya kugatemya kya gano gakorirwe kumutiini guno. Kweeki mutakukora gayo ego, nawe eraabhe muraabhuurire ekiguru kino, ‘Ihika no okwiirekera munyaanza,’ nakyo kirarwaho. ");
INSERT INTO zak_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na ryoryoosi rino mukusabha ku Taatabhugya, ne eraabhe muraariikirirye, murasuungʼaana.” ");
INSERT INTO zak_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yeesu akasikira kweeki mwiiseengerero rya Taatabhugya. Hano yaari kweegya, niho abhakuru bha abhaseengeri na abhakaruka bha Abhayahudi bhakaaza okumubhuurya, “Okakora garya kwo obhuturoki? Ni weewi wuno akuheeri obhuturo bhuyo?” ");
INSERT INTO zak_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu akabhakyoora, “Na neenye ndabhabhuurya eriingʼana rimwe. Eraabhe muranikyoora riyo, na neenye ndabhabhuurira ni kwo obhuturoki nikukora gano. ");
INSERT INTO zak_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mbe, obhuturo bhwa Yohana bhwo okubatiiza abhaatu, bhukarwa hayi? Bhukarwa ku Taatabhugya wuno ari mwiisaaro kasi kubhaatu?” Niho bhakataanga okwiibhuurya, “Turaabhuge, ‘Bhukarwa mwiisaaro,’ aratubhuurya, ‘Ambe, ndora mutaamwiikiriirye?’ ");
INSERT INTO zak_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kweeki, eraabhe turamukyoora kubha bhukarwa kubhaatu, turoobhoha esaango ya abhaatu bhano, kwo okubha bhoosi bhariikirirya kubha Yohana yaari omurooti.” ");
INSERT INTO zak_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kweego bhakamukyoora, “Tutamenyiri.” Ambe, Yeesu neewe akabhakyoora, “Na neenye nitakubhabhuurira ni kwo obhuturoki ndakora gano.” ");
INSERT INTO zak_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yeesu akageenderera okubhabhuurira abhakaangati na abhaseengeri, “Bhoono, murarorabhwi iguru ye ekireengyo kino? Yaariho omuutu owumwe wuno ahaabha na abhaana bhabhiri. Akagya kumwaana wo okutaanga, akamubhuurira, ‘Omwaana waane, reero noogye okore emirimo mumuguundu gwe emizabibu.’ ");
INSERT INTO zak_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Omwaana waaye wuyo, akamukyoora, ‘Nitakugya!’ Nawe ibhaga riindi, akiikyoora amiiseego gaaye, akagya kukora. ");
INSERT INTO zak_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Niho wiise akagya kumwaana waaye wa kabhiri no okumubhuurira kyeego yabhuuriiri owuundi wurya. Neewe akamukyoora, ‘Ndagya taata!’ Nawe ataagiiri. ");
INSERT INTO zak_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Mbe, mubhabhiri bhayo, ni weewi wuno yakoriri obhweendi bhwa wiise?” Bhakamukyoora, “Ni wurya wo okutaanga.” Niho Yeesu akabhabhuurira, “Ndabhabhuurira obhuheene, abhatobhya bhe eriigooti na abhasiimbe bharabhakaangata kusikira mubhutemi bhwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohana akaaza kweemwe okubha abheerekye enzira ye eheene, neemwe mutamwiikiriirye. Nawe abhatobhya bhe eriigooti na abhasiimbe nibho bhakamwiikirirya. Naabhe emwe hano mwaaruuzi goosi gayo, mukaanga okwiikyoora amiiseego geenyu no okumwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Mwiitegeerere ekireengyo ekiindi. Ahaabha ariho muutu wumwe wuno yaari no omuguundu. Mumuguundu gwaaye muyo, akeemya emizabibu, akagiiruguurirya orubhago, akatuka eriitobheeryo ryo okuzitobheerya eziizabibu, kweeki akoomboka obhutiingo bhutaambi bhwo okuriibhira mumuguundu. Mubhuteero, akabhasagarya omuguundu abharimi abharebhe, akagya orugeendo. ");
INSERT INTO zak_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Hano eriibhaga ryo okugesa ryahikiri, mweene muguundu wuyo akabharagania abhagya bhaaye kubharimi bhayo, okubha bhabhahe amagesa gaaye. ");
INSERT INTO zak_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nawe hano abhagya bhaaye bhaahikiri, abharimi bhayo bhakabhagwaata, owumwe bhakamutema, owuundi bhakiita no owuundi bhakamutema na amagina tee akakwa. ");
INSERT INTO zak_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kyaamwe, mweene muguundu akaragania kweeki abhagya abhaandi, abhaaru kukira bhano yarageenie kubhutaangiro. Abharimi bhayo bhakabhakorera obhubhi abhagya bhayo kyeego bhabhakoreeri bho okutaanga. ");
INSERT INTO zak_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Mubhuteero, akamutuma omwaana waaye. Akiigaambira, ‘Wuno ni mwaana waane, ewe bharamusuuka.’ ");
INSERT INTO zak_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nawe hano abharimi bharya bhaamuruuzi omwaana waaye, bhakiibhuurira, ‘Wuno niwe omugabhi we ebhigiro bhya wiise. Muuze, tumwiite okubha tuyigege engabho yaaye.’ ");
INSERT INTO zak_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ambe, bhakamugwaata, bhakamuhira igutu wo omuguundu, bhakamwiita.” ");
INSERT INTO zak_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yeesu akabhabhuurya, “Mbe, hano mweene muguundu araakyoore okurwa orugeendo rwaaye, arakorabhwi abharimi bharya?” ");
INSERT INTO zak_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhakamukyoora, “Arabhiita bhubhi abhabhi bharya, no omuguundu gwaaye arabhasagarya abharimi abhaandi bhano bharaamuhe amagesa kwe eriibhaga ryaaye.” ");
INSERT INTO zak_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Niho Yeesu akabhabhuurira, “Mbe, mukyaari okusoma gano gakaamirwe mu Makaamo Amahoreeru? Gakaamirwe, ‘Eriigina rino abhoomboki bhaaryaangiri, niryo ribheeri eriigina eriikuru ryo obhurusa. Omukuru niwe arikoriri riyo, naryo ni ingʼana ryo okuruguurya kweetwe.’ ” ");
INSERT INTO zak_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yeesu akoongerya, “Ndabhabhuurira kubha, kwe ekigirirye kiyo Taatabhugya araruusya obhutemi bhwaaye kweemwe no okubhaha abhaatu bhe ebhyaaro ebhiindi bhano bhakunagya kwiibhura emisumo kwiiguru waaye. ");
INSERT INTO zak_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ambe, omuutu wowoosi wuno akubha agweereeri eriigina riyo, arabhunika. Kweeki, omuutu wowoosi wuno eriigina riyo riraamugweere, riramubhoondora bhukongʼu.” ");
INSERT INTO zak_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hano abhakuru bha abhaseengeri na Abhafarisayo bhiigwiiri ebhireengyo bhya Yeesu, bhakamenya kubha nibho akubhakeerenerya. ");
INSERT INTO zak_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kweego, bhakabha bharamoohya enzira yo okumugwaata. Nawe bhakoobhoha esaango ya abhaatu, kwo okubha ebho bhaamumenyiri Yeesu kubha ni murooti. ");
INSERT INTO zak_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu akageenderera okweegya Abhafarisayo na abhakuru bha abhaseengeri kwe ekireengyo ekiindi akubhuga, ");
INSERT INTO zak_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Obhutemi bhwa mwiisaaro bhutuubheeni ne ekireengyo kino. Yaari ariho omutemi wumwe wuno yabhanwiiri enyaangi yo obhweenga bhwo omwaana waaye. ");
INSERT INTO zak_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Omutemi wuyo, akaragania abhagya bhaaye bhagye kubhirikira bhano bharaarikirwe bhiize kubhweenga, nawe bhoosi bhakaanga kuuza. ");
INSERT INTO zak_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Niho akaragania abhagya abhaandi, akabhabhuurira bhagye bhabhabhuurire bhano yamariri kubharaarika, ‘Nibhanwiiri ebhigiro bhyoosi bhyo obhweenga. Nigwaagiri eziingʼoombe zyaane eziinuru hamwe ne emitugo egiindi eminuru. Kweego, muuze kubhweenga!’ ");
INSERT INTO zak_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nawe abhaatu bhano bhaaraarikirwe, bhataamurirye, bhakagya zyaabhu. Abhamwe bhaabhu bhakagya mumiguundu gyaabhu, na bhaandi bhakagya okusuruzya. ");
INSERT INTO zak_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abhaandi bhakabhagwaata abhagya bho omutemi, bhakabhasuukya kwo okubhatema no okubhiita. ");
INSERT INTO zak_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ambe, hano omutemi yiigwiiri gano gakorirwe kubhagya bhaaye, akatiinda bhukongʼu. Akaragania abhasirikare bhaaye bhagye okwiita abhiiti bharya no okwookya omugye gwaabhu. ");
INSERT INTO zak_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Niho omutemi wuyo akabhabhuurira abhagya bhaaye kubha, ‘Ebhigiro bhyoosi bhye enyaangi yo obhweenga bhimariri okubhanurwa, nawe bhano bhaaraarikirwe, bhaari bhatakuningʼarira okuuza. ");
INSERT INTO zak_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ambe bhoono, mugye kuziinzira zya amaahukano, mubhabhuurire bhoosi bhano muraasikane nabho kubha, bhiize kubhweenga.’ ");
INSERT INTO zak_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Abhagya bhayo bhakagya muziinzira zya amaahukano, bhakakumania bhoosi bhano bhaari kusikana nabho, bhabhe bhe ebhibhi kasi abhazomu. Niho abhagini bhakasikira mwiibhuru ryo obhweenga tee rikiizura. ");
INSERT INTO zak_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nawe, hano omutemi omweene yasikiiri mwiibhuru arore abhagini, akamurora muyo omuutu wumwe wuno atiibhohiri emyeenda gyo obhweenga. ");
INSERT INTO zak_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Akamubhuurya, ‘Awe musaani, okasikirabhwi muno eno otiibhohiri eziingibho zyo obhweenga?’ Nawe omuutu wuyo akabhurwa ryo okugaamba. ");
INSERT INTO zak_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ambe, omutemi akabhabhuurira abhabhagati bhaaye, ‘Mumubhohe omuutu wuno amaguru na amabhoko na mumurekere igutu mukiirima. Eyo niyo bhakubha bhararira no okusaanania ameeno.’ ” ");
INSERT INTO zak_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeesu akamariirya kwo okubhuga, “Abhaatu bhano bharabhirikirwa okusikira mubhutemi bhwa mwiisaaro ni bhaaru, nawe bhano bharaasorwe kusikira ni bhasuuhwiigo.” ");
INSERT INTO zak_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ambe, Abhafarisayo bhakiikumania okwaamura kyeego bharaamutiimbye Yeesu kumangʼana gaaye. ");
INSERT INTO zak_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kyaamwe bhakaragania abhaanabheega bhaabhu ku Yeesu hamwe na bhano bhaagwaateeni na abhasakirya bho omutemi Herode. Bhayo bhakamubhuurya Yeesu, “Ee Omweegya, tumenyiri kubha awe ni muutu we eheene no oreegya obhuheene iguru wa amangʼana ga Taatabhugya. Tumenyiri kubha awe otakwoobhoha muutu wuyo woosi, naabhe araabhe mukaangati mukuru. ");
INSERT INTO zak_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ambe, otubhuurire amiiseego gaazo. Emigiro gya Musa giratwiikirirya kuriha eriigooti ku Kaisari, kasi zeyi?” ");
INSERT INTO zak_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nawe Yeesu akamenya amiiseego gaabhu amabhiihu, akabhakyoora, “Emwe abhabheehi, kwaki mureenda kunitiimbya? ");
INSERT INTO zak_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munierekye orubhirya runo mukurihira eriigooti.” Nabho bhakamuhaana edinaari yimwe. ");
INSERT INTO zak_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Niho Yeesu akabhabhuurya, “Epicha yino ne eriina rino, ni bhya weewi?” ");
INSERT INTO zak_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ebho bhakamukyoora, “Ni bhya Kaisari.” Yeesu akabhabhuurira, “Ambe, bhya Kaisari muhaane Kaisari, na bhya Taatabhugya muhaane Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hano bhiigwiiri eriikyooro rya Yeesu, bhakaruguura bhukongʼu. Ambe, bhakamutiga, bhakatanura hayo. ");
INSERT INTO zak_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Orusiku rurya, Abhasadukayo abharebhe bhakaaza ku Yeesu. Abhasadukayo bhaheegya kubha Taatabhugya atakubharyoora abhaatu okurwa muruku. Niho bhakamubhuurya Yeesu, ");
INSERT INTO zak_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Omweegya, Musa akaturagania, ‘Eraabhe omuutu akuuri, na atigiri mukaaye akyaari kwiibhura, wamwaabhu amugabhe omutuumba wuyo, okubha amwiibhurire wamwaabhu omwaana.’ ");
INSERT INTO zak_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ambe, bhaari bhariho abhahiiri muhuungati gati weetu. Wo okutaanga akakweera omukari, akakwa akyaari kwiibhura omwaana. Ambe wamwaabhu wa kabhiri akamugabha omutuumba wuyo. ");
INSERT INTO zak_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Omusuuhu waaye wuyo wa kabhiri, neewe akakwa akyaari kwiibhura omwaana no omutuumba wuyo. Ekabha egoego ku wa katatu woosi na kubhaandi bhayo bhoosi, bhakakwa bhakyaari kwiibhura omwaana. ");
INSERT INTO zak_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mubhuteero, omutuumba wuyo woosi akakwa. ");
INSERT INTO zak_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ambe otubhuurire, eraabhe obhuryoori bhurabhaho, omutuumba wuyo arabha omukari wawi? Bhoosi muhuungati bharya bhakamukweera no okumugabha!” ");
INSERT INTO zak_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeesu akabhakyoora, “Emwe muhabhiri bhukongʼu, kwo okubha mutamenyiri gano gakaamirwe mu Makaamo Amahoreeru, kweeki mutamenyiri obhunagya bhwa Taatabhugya kyeego bhuri. ");
INSERT INTO zak_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kurusiku rwo okuryooka, abhaatu bhatakukweera naabhe kukweerwa. Kweego bharabha kya bhamaraika mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nawe eheene abhaku bhararyooka. Mukyaari kusoma mu Makaamo Amahoreeru kyeego Taatabhugya akabhabhuurira emwe? Akabhuga, ");
INSERT INTO zak_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Enye ni Taatabhugya wa Aburahamu, Isaaka na Yaakobo.’ ” Ambe, Yeesu akageenderera kubhuga, “Taatabhugya atari Taatabhugya wa abhaku, nawe ni Taatabhugya wa abhahoru.” ");
INSERT INTO zak_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hano esaango ya abhaatu bhiigwiiri gayo, bhakaruguura bhukongʼu kwa ameegyo gaaye. ");
INSERT INTO zak_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Hano Abhafarisayo bhiigwiiri kubha Yeesu yaari ahiziri Abhasadukayo kwo obhugaambi bhwaaye, bhakiikumania hamwe. ");
INSERT INTO zak_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kyaamwe, bhakagya ku Yeesu, no owumwe waabhu wuno yaari omweegya we emigiro, akasakya okumutega. Akamubhuurya, ");
INSERT INTO zak_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ee Omweegya, ni bhuswaagyoki obhukuru bhuno bhukukira emigiro egiindi gyoosi gya Taatabhugya?” ");
INSERT INTO zak_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu akamukyoora, “‘Omuseege Omukuru, Taatabhugya waazo, kwo omutima gwaazo gwoosi, kwe ekoro yaazo yoosi na kwa amangʼeeni gaazo goosi.’ ");
INSERT INTO zak_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Obhuswaagyo bhuno nibhwo obhukuru kukira obhuswaagyo obhuundi bhwoosi, kweeki nibhwo bhukweenderwa kukira bhwoosi. ");
INSERT INTO zak_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Obhuswaagyo obhuundi bhuno bhukweenderwa bhutuubheeni bhuzomu na bhuyo, nabhwo bhurabhuga, ‘Omuseege omurikyaazo kyeego wiiseegiri omweene.’ ");
INSERT INTO zak_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Emigiro gyoosi gya Musa na ameegyo ga abharooti nibhyo bhikwiisigira obhuswaagyo obhubhiri bhuno.” ");
INSERT INTO zak_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hano Abhafarisayo bhayo bhakyaari bhiikumaniirye hamwe hayo, Yeesu akabhabhuurya, ");
INSERT INTO zak_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Muriiseegabhwi iguru wa Masiya, ni mwaana wawi?” Bhakamukyoora, “Ni mwaana wo omutemi Daudi.” ");
INSERT INTO zak_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yeesu akabhabhuurya, “Eraabhe gayo ni ge eheene, ni kwaki Daudi, hano akukaangatwa ne Ekoro wa Taatabhugya, aramubhirikira Masiya, ‘Omukuru’? Akabhuga, ");
INSERT INTO zak_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Omukuru, Taatabhugya akamubhuurira Omukuru waane, “Wiikare orubhaara rwaane rwo obhuryo, tee hano nikutuura abhabhisa bhaazo iyaasi wa amaguru gaazo.” ’ ");
INSERT INTO zak_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eraabhe Daudi aramubhirikira Masiya, ‘Omukuru,’ bhoono erabhabhwi Masiya abhe kweeki omwaana waaye?” ");
INSERT INTO zak_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ataariho omuutu wuyo woosi wuno yanagirye kumukyoora riyo ryoosi. Kweeki okweemera hayo, ataariho omuutu wuno yasakirye kumubhuurya Yeesu amabhuuryo agaandi. ");
INSERT INTO zak_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ambe, Yeesu akabhuurira esaango ya abhaatu na abhaanabheega bhaaye, ");
INSERT INTO zak_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abheegya bhe emigiro gya Musa na Abhafarisayo, bhano obhuturo bhwo okweegya abhaatu emigiro. ");
INSERT INTO zak_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kweego, mugwaate na mugakore kisi goosi gano bhakweegya. Nawe mutabha muratuniirira amahokya gaabhu, kwe ekigirirye ebho bhatakukora goosi gano bhakweegya. ");
INSERT INTO zak_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ebho obhona bharabhoha emigiro gyoosi kye emirigo emirito no okubhagegya abhaatu kumabhega, nawe abheene bhatakweenda okugororokya naabhe ekyaara kimwe okubha kisakirye okugega. ");
INSERT INTO zak_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Goosi gano bhakukora, bharakora okubha bhiiyeerekye kubhaatu. Obhona bhariibhoha mubhisyo bhyaabhu na mumabhoko gaabhu ebhitinika ebhikuru bhya amasaakwa bhino bhina amangʼana ge emigiro, no okwoongerya emiriingo gye emyeenda gyaabhu gyo obhwiisasaami gibhe mitaambi kukira gya abhaandi. ");
INSERT INTO zak_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Muziisiku zye eziinyaangi, obhona bharaseega kwiikara kubhituumbi bhya abhagini bho obhusuuku. Naabhe munyuumba ye esaango yaabhu, obhona bharaseega kwiikara kubhituumbi bhye embere bhyo obhusuuku. ");
INSERT INTO zak_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kweeki, bharaseega kukeeribhwa kwo obhusuuku mumiteera, na bhabhe bharabhirikirwa ‘Omweegya.’ ");
INSERT INTO zak_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Nawe emwe, mutabha muriikirirya okubhirikirwa ‘omweegya,’ kwo okubha muno Omweegya wumwe ego, neemwe mwoosi ni bhamwe. ");
INSERT INTO zak_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kweeki, mutabha muramubhirikira muutu wuyo woosi ‘taata’ mukyaaro kino, kwo okubha munawe Taata owumwe ego wuno ari mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kweeki, mutabha muriikirirya okubhirikirwa ‘omukaangati,’ kwo okubha munawe Omukaangati wumwe ego, niwe Masiya. ");
INSERT INTO zak_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Omukuru wowoosi gati weenyu, areenderwa kubha omuhokya weenyu. ");
INSERT INTO zak_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Omuutu wuyo woosi wuno akwiigega omweene kubha omukuru, Taatabhugya aramwiikya iyaasi. Nawe omuutu wuyo woosi wuno akwiiyiikya, Taatabhugya aramutiirya kubha omukuru. ");
INSERT INTO zak_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Muraaza kurora, emwe abheegya bhe emigiro na neemwe Abhafarisayo! Emwe ni bhabheehi, murabharekya abhaatu kusikira mubhutemi bhwa mwiisaaro kwa okunianga enye. Emwe abheene mutakusikira muyo, kweeki mutakubhiikirirya abhaatu abhaandi bhano bhareenda okusikira.  ");
INSERT INTO zak_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Muraaza kurora, emwe abheegya bhe emigiro na neemwe Abhafarisayo! Emwe ni bhabheehi, murasabha Taatabhugya kwa amasabhi mataambi bhukongʼu okubha mwiiyeerekye kubhaatu, nawe murateesya abhatuumba ebhigiro bhyaabhu. Ambe, mumenye kubha kurusiku rwo okutina ekiina, eheene murabhona obhutemwa bhukuru okurwa ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Muraaza kurora, emwe abheegya bhe emigiro na neemwe Abhafarisayo! Emwe ni bhabheehi, muriinogoora mukyaaro kyoosi no okwaambuka enyaanza, okubha mumukorokoombe omuutu wuno atari Omuyahudi kubha omwaanamweega we enyaangi yeenyu. Na akwiikirirya kubha omwaanamweega, muramukora kubha omuutu wuno akweenderwa omuriro gwa nyaari maanga abhiri kubhakira emwe! ");
INSERT INTO zak_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Muraaza kurora, emwe abhakaangati abhahoku! Mureegya abhaatu, ‘Eraabhe omuutu ariirahira eriiseengerero, obhwiirahiri bhwaaye bhutari kigiro. Nawe eraabhe ariirahira ezahaabu yino eri mwiiseengerero, omuutu wuyo areenderwa okukora kyeego akiirahira.’ ");
INSERT INTO zak_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bhoono, emwe ni bhageege, kweeki abhahoku! Kiihe kino obhuguri bhukuru kukira ekiindi, ni zahaabu yino eri mwiiseengerero, kasi ni iseengerero eryeene? Ni iseengerero, kwo okubha niryo rikuyikora ezahaabu kubha horeeru. ");
INSERT INTO zak_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kweeki mureegya abhaatu, ‘Kyo omuutu ariirahire ahagiro ho okuruusirya ekimweeso mwiiseengerero, obhwiirahiri bhwaaye bhutari kigiro. Nawe eraabhe ariirahira ekimweeso kino kiri iguru ya ahagiro ho okuruusirya ekimweeso, omuutu wuyo areenderwa akore kyeego akiirahira.’ ");
INSERT INTO zak_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bhoono, emwe ni bhahoku! Kiihe kino obhuguri bhukuru kukira ekiindi, ni kimweeso kasi ni hagiro ho okuruusirya ekimweeso hano hakukora ekimweeso kubha ekihoreeru? ");
INSERT INTO zak_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ambe, eraabhe omuutu ariirahira iguru ya ahagiro ho okuruusirya ekimweeso, ariirahira ne ebhimweeso bhino bhiri iguru waku. ");
INSERT INTO zak_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kweeki, eraabhe omuutu ariirahira eriiseengerero, ariirahira eriiseengerero hamwe na Taatabhugya wuno akwiikara muyo. ");
INSERT INTO zak_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kweeki, eraabhe omuutu ariirahira eriisaaro, ariirahira kukituumbi kyo omuriinga kya Taatabhugya na Taatabhugya omweene wuno akwiikara iguru waku. ");
INSERT INTO zak_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Muraaza kurora, emwe abheegya bhe emigiro na neemwe Abhafarisayo! Emwe ni bhabheehi, muragwaata emigiro gyo okuruusya eyimwe yi ikumi ye ebhigiro bhyo obhuguri bhusuuhu bhukongʼu, kyeego eziimbibho zye emiingu, ebinzaari na jira. Nawe, muraanga amangʼana amazomu mumigiro gya Musa. Muraanga kukora eheene, ebhigoongi no obhwiikirirya kubhaatu abhaandi. Nawe mureenderwa okugakora goosi, amakuru na amasuuhu hamwe. ");
INSERT INTO zak_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Emwe ni bhakaangati abhahoku, murasuuza nyamuunyu mumaanzi, nawe muramira engamia engima! ");
INSERT INTO zak_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Muraaza kurora, emwe abheegya bhe emigiro na Abhafarisayo! Emwe ni bhabheehi, kwo okubha muriikora kubhaatu kubha abhahoreeru embere wa Taatabhugya, kwo okwoogya ekikoombe ne ekitubha kwiigutu kaniire, nawe muratiga okwoogya kino kiri muusi weenyu. Muyo bhwiizwiiri obhuteesya no okutama kubha na kusuuhu. ");
INSERT INTO zak_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Emwe Abhafarisayo abhahoku! Mute ebhibhi bhino bhiri muusi weenyu, kyeego mukwoogya obhunyaka bhuno bhuri mukikoombe. Kweego, amahokya geenyu nago garabha amazomu, okubha ekikoombe kyeere igutu na muusi wakyo. ");
INSERT INTO zak_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Muraaza kurora, emwe abheegya bhe emigiro na neemwe Abhafarisayo! Emwe ni bhabheehi, mutuubheeni kye eziimbiihira zino zihakirwe echokaa. Kwiigutu zirazomera, nawe muusi wamu ziizwiiri amaguha ga abhaku na amakire ga tuubho nzaru. ");
INSERT INTO zak_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kweego neemwe, kwiigutu murarorekana kubhaatu kubha bhe eheene embere wa Taatabhugya, nawe obhuheene ni kubha muziikoro zyeenyu mwiizwiiri orurimi no obhwaangi ego. ");
INSERT INTO zak_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Muraaza kurora, emwe abheegya bhe emigiro na neemwe Abhafarisayo! Emwe ni bhabheehi, muroomboka eziimbiihira zya abharooti no okuzinatya bhuzomu eziimbiihira zya abhaatu bhe eheene embere wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Niho mukugaamba, ‘Kye etwe tuungabheeriho kwe eriibhaga rino bhazaazi bheetu bhaari bhahoru, tutiinganagirye okugwaatana nabho okwiita abharooti.’ ");
INSERT INTO zak_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bhoono, kwo okugaamba ego, mureerekya kubha neemwe ni bhaana bha bhazaazi bheenyu bhano bhiitiri abharooti bha Taatabhugya! ");
INSERT INTO zak_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ambe, mugeende okukuunaania obhubhi bhurya bhuno bhazaazi bheenyu bhaataangiri! ");
INSERT INTO zak_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Emwe ni nzoka, orwiibhuro rwe enzoka! Mutakunagya okwiibheza obhutemwa bhwo okutinirwa ekiina kya Taatabhugya no okurekerwa mumuriro gwa nyaari! ");
INSERT INTO zak_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Kwe ekigirirye kiyo, murore emwe Abhayahudi, ndatumania kweemwe abharooti bha Taatabhugya, abhaatu bha amangʼeeni bha Amakaamo Amahoreeru, na abheegya abhaandi. Abhamwe bhaabhu, murabhiita no okubhatemerera kumusaraba. Abhaandi murabhatema emijariti muziinyuumba zye eziisaango zyeenyu, na abhaandi murabhatuniirira omugye kwo omugye no okubhanyaakya. ");
INSERT INTO zak_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kweego, Taatabhugya arabhatinira ekiina emwe kwo okwiitwa bhe eheene bhoosi. Gayo gaakorirwe ego, kweemera eriibhaga rino Kaini yamwiitiri Abeeri wuno ataari no obhubhi bhwobhwoosi, tee okwiitwa kwa Zakaria, omwaana wa Barakia. Ewe yiitiirwe mwiiseengerero gatigati wa Ahahoreeru na ahagiro ho okuruusirya ekimweeso. ");
INSERT INTO zak_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ndabhabhuurira obhuheene, Taatabhugya araabhatinire abhaatu bho orwiibhuro runo kumabhi gayo goosi.” ");
INSERT INTO zak_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Niho Yeesu akabhuga, “Emwe abhaatu bha Yerusaremu! Abhaatu bha Yerusaremu! Muriita abharooti no okubhatema amagina abhaatu bhano Taatabhugya abharageenie kweemwe. Maanga maaru niendiri okubhakumania emwe kyeego ekoko ekukumania ebhizuuzuru bhyaaye mumabhabha gaaye, nawe muteendiri! ");
INSERT INTO zak_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Rora, Taatabhugya aragutiga omugye gweenyu, gurabha eriitoongo. ");
INSERT INTO zak_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Enye ndabhabhuurira, mutakuundora kweeki tee eriibhaga rino muraabhuge, ‘Atweerwe ebhite wuno akuuza kuriina ryo Omukuru!’ ” ");
INSERT INTO zak_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeesu akatanura mwiiseengerero rya Taatabhugya. Hano yaakurwa muyo, abhaanabheega bhaaye bhakamutuniirira okubha bhamweerekye kyeego amakiindaasi ge eriiseengerero rya Taatabhugya gari. ");
INSERT INTO zak_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nawe Yeesu akabhabhuurira, “Muruuzi bhuzomu amakiindaasi goosi gano? Ndabhabhuurira obhuheene, ritariho eriigina rino riraatame iguru we eriindi, goosi garagwiisibhwa!” ");
INSERT INTO zak_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ambe, Yeesu akagya mu Kiguru kye Emizeituni, akiikara hayo. Abhaanabheega bhaaye bhakamutuniirira hayo abheene ego, bhakamubhuurya, “Otubhuurire, amangʼana gayo garatuuka ryoori? Kweeki, niki kino kiraatweerekye okukyoora kwaazo no okuhika kwo obhuteero bhwe ekyaaro?” ");
INSERT INTO zak_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yeesu akabhakyoora, “Mwiiriihe, omuutu wowoosi ataaza kubhangʼeena! ");
INSERT INTO zak_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Abhaatu bhaaru bharaaza bhakuhokeerya eriina ryaane, bharabhuga, ‘Enye neenye Masiya!’ Abhaatu bhayo bharangʼeena abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Kwiibhaga riyo, murabha muriigwa amangʼana ge eriihi no obhuzuuzumi bhwe eriihi. Mutaaza kuhahibhwa, gayo gareenderwa gatuuke, nawe obhuteero bhwe ekyaaro bhurabha bhukyaari kuhika. ");
INSERT INTO zak_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ekyaaro kimwe kirarwaana ne ekyaaro ekiindi, no obhutemi obhumwe bhurarwaana no obhutemi obhuundi. Enzara ne ebhirigito bhye esi bhirabha bhiratuuka ahagiro hoosi. ");
INSERT INTO zak_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gayo goosi garabha kyo obhweemero bhwo obhusuungu bhwo omukari wuno akweenda okwiituurania. ");
INSERT INTO zak_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Kwiibhaga riyo, abhaatu bharabha bharabhakorera emikoonyo, muranyaakibhwa no okwiitwa, na abhaatu bhe ebhyaaro bhyoosi bharabhabhiihirirwa kwe ekigirye kyo okubha emwe ni bhaanabheega bhaane. ");
INSERT INTO zak_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Niho abhaatu bhaaru bharaaza kutiga okunituniirira. Bharabha bharakorerana emikoonyo no okubhiihirania abheene kwa abheene. ");
INSERT INTO zak_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Kwiibhaga riyo, bharabha bharatuuka abharooti bhaaru bho orurimi, bharangʼeena abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kweeki, obhuseegi bhwa abhaatu bhaaru bhurasuuha, kwo okubha ebhibhi bhirabha bhyaaruhiri. ");
INSERT INTO zak_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nawe omuutu wowoosi wuno araagumire tee obhuteero, niwe araatuuribhwe. ");
INSERT INTO zak_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Amangʼana Amazomu iguru yo obhutemi bhwa mwiisaaro garabha gararwaazwa mukyaaro kyoosi. Kwiibhaga rino abhaatu bhe ebhyaaro bhyoosi bharabha bhabhweeni omweeya gwo okwiigwa obhwiimeerereri bhuyo, niho obhuteero bhwe ekyaaro bhuraahike. ");
INSERT INTO zak_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kurabha ne eriibhaga hano muraarore kino omurooti Danieri yagaambiri, eriibhiihiriryo rirya rino rikureeta amakire, riimeereeri ahagiro ahahoreeru he eriiseengerero rya Taatabhugya. Omuutu wowoosi wuno akusoma amangʼana gano, amenye bhuzomu obhugazuro bhwago. ");
INSERT INTO zak_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Hayo, abhaatu bhoosi bhano bhakwiikara mukyaaro kya Yudea, bhangʼosere mubhiguru! ");
INSERT INTO zak_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Omuutu wuno ari iguru kukisara, yiike angʼose, atasikira munyuumba okubha agege ebhigiro bhyaaye. ");
INSERT INTO zak_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Egoego, omuutu wuyo woosi wuno akubha mumuguundu, angʼose, atakyoora owaaye okugega ekabhuuti yaaye. ");
INSERT INTO zak_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Turabharorera ebhigoongi, abhakari bhano bharitohiri na bhano bhakukookya abhaana muziisiku ziyo! ");
INSERT INTO zak_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kweego, mumusabhe Taatabhugya kubha okuryaara kweenyu kutaaza kubha mwiibhaga rya nyamabheho naabhe kurusiku rwo okumuunya. ");
INSERT INTO zak_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Eheene, muziisiku ziyo, abhaatu bharabhona eziinyaako kuru bhukongʼu. Eziinyaako kya ziyo, zikyaari kutuuka kweema obhweemero bhwe ekyaaro tee reero yino, na zitakuuza kutuuka kweeki. ");
INSERT INTO zak_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Eraabhe Taatabhugya atiingazisuuhirye eziisiku ziyo munyaako yiyo, atariho omuutu wuno yiingatuuriibhwe. Nawe Taatabhugya ararisuuhya eriibhaga riyo, kwiiguru ya abhasorwa bhaaye. ");
INSERT INTO zak_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kwe eriibhaga riyo, kyo omuutu arabhabhuurira, ‘Rora, Masiya ari hano!’ kasi ‘Ari harya!’ mutaaza kwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bharabhaho abharooti bho orurimi na abhaatu bhano bhakwiibhirikira kubha ni Masiya. Bhareerekya ebhyeerekenio ne ebhiruguuro, okubha bhasakye okubhangʼeena abhaatu, eraabhe eraturikana naabhe bhano bhasorirwe na Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mwiiriihe! Nibhabhuuriiri gakyaari kutuuka. ");
INSERT INTO zak_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Eraabhe abhaatu bharabhabhuurira, ‘Rora, Krisito ari mwiitirigo erya!’ mutaaza kugya eyo. Kasi bharaabhuge, ‘Rora, yiibhisiri munyuumba muyo!’ mutaaza kwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mumenye kubha okuuza kweenye Omwaana wo Omuutu, kurabha kyeego orumesyo rukumesya ruguru tee nyaanza. ");
INSERT INTO zak_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Amangʼana gararorekana kubhweero, eraabhe hano mukurora amatoonyi giikumaniirye, niho ekituundu kiri. ");
INSERT INTO zak_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ambe, hano eziisiku ziyo zye enyaako zihitiri, eryoobha riratuurirwa ekiirima, omweeri gutakuruusya obhweero bhwaku, ne eziinzota ziragwa haasi okurwa kwiisaaro. Taatabhugya arabhisiingisya ebhigiro bhyoosi bhya mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Niho, ekyeerekenio kyeenye Omwaana wo Omuutu kiraaza kurarorekana mwiisaaro, na abhaatu bhe eziingaanda zyoosi mukyaaro bharataanga kurira kwe ehaho. Hano ndaaze, abhaatu bhoosi bharanirora, nikuuza mumasaaro kwo obhuturo bhwaaru no obhuguungo. ");
INSERT INTO zak_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Niho ndaragania bhamaraika bhaane, bhateme ekoombyo bhukongʼu, okubha bhakumanie abhasorwa bhaane okurwa mbaara zyoosi zye ekyaaro.” ");
INSERT INTO zak_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yeesu akageenderera kugaamba, “Mweege amangʼana ge ekireengyo okurwa kumuti gwo omutiini. Hano mukurora amatu garasibhuka na amasagya garabharya amatu, nikyo ekigirirye kyo okumenya kubha eriibhaga rya amaahu rihikiri. ");
INSERT INTO zak_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Egoego na neemwe, hano muraarore gayo goosi gataangiri kukorwa, mumenye kubha niri haguhi kuuza. ");
INSERT INTO zak_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ndabhabhuurira obhuheene, orwiibhuro runo rutakuhita, tee gano goosi garaamarwe kukorwa. ");
INSERT INTO zak_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Eriisaaro ne ekyaaro bhirahweerera, nawe amangʼana gaane gatakuhweerera na rumwe. ");
INSERT INTO zak_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nawe iguru wa amangʼana go orusiku ne eriibhaga runo Omwaana wo Omuutu araaze, atariho omuutu wuno amenyiri. Naabhe bhamaraika bha mwiisaaro, naabhe Omwaana, bhoosi bhatamenyiri, nawe Taata waane omweene niwe amenyiri. ");
INSERT INTO zak_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kweego, okuuza kwaane enye Omwaana wo Omuutu, kurabha kyeego yaari kuziisiku zya Nuhu. ");
INSERT INTO zak_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Muziisiku ziyo hano embura yo omusabhuko yaari ekyaari kuuza, abhaatu bhaari bhararya no okunywa, bhaari bharakweera no okukweerwa, tee kurusiku runo Nuhu yasikiiri musafina. ");
INSERT INTO zak_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Abhaatu bhayo, bhataamenyiri niki kiraatuuke, tee hano omusabhuko gwiiziri no okubhiita bhoosi. Ego niigo eraabhe eriibhaga enye Omwaana wo Omuutu ndaaze. ");
INSERT INTO zak_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kwe eriibhaga riyo, abhaatu bhabhiri bharabha mumuguundu, owumwe aragegwa no owuundi aratama. ");
INSERT INTO zak_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kweeki abhakari bhabhiri bharabha bharasya hamwe kurubhwe, owumwe aragegwa no owuundi aratama. ");
INSERT INTO zak_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ambe muteengeeze, kwo okubha mutamenyiri ni rusikuki runo enye Omukuru weenyu nikuuza. ");
INSERT INTO zak_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Nawe mumenye kisi kubha, kyeego mweene nyuumba yiingamenyiri eriibhaga rino omwiibhi akuuza, ambe ataari kuhiindira okubha omwiibhi ataaza akasarya enyuumba yaaye. ");
INSERT INTO zak_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kweego ambe, na neemwe mwiibhanure eriibhaga ryoosi, kwo okubha enye Omwaana wo Omuutu ndaaza kwiibhaga rino mutakwiisiga.” ");
INSERT INTO zak_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yeesu akabhabhuurya abhaanabheega bhaaye, “Ambe, ni weewi omugya omwiikirirya na wa amangʼeeni? Ni mugya wuno omukuru waaye amutuuriri abhe omwiimeerereri wa abhagya abhaandi munyuumba yaaye, okubha abhe arabhaha ebhyaakurya kwe eriibhaga rino rikweenderwa. ");
INSERT INTO zak_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Omukuru waabhu araakyoore kurwa orugeendo, no okumubhona omugya wuyo arakora ego, niho araabhone orubhaango. ");
INSERT INTO zak_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ndabhabhuurira obhuheene, omukuru waaye aramukora abhe omwiimeerereri we ebhigiro bhyaaye bhyoosi. ");
INSERT INTO zak_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Nawe eraabhe omugya wurya ni mubhiihu, akwiiseega mukoro yaaye, ‘Omukuru waane akezeeri bhukongʼu kukyoora.’ ");
INSERT INTO zak_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Niho akutaanga kutema abhagya abharikyaaye, arazomererwa okurya no okunywa amaanzi go omuzabibu hamwe na abhanywi abharaara. ");
INSERT INTO zak_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ambe, omukuru waaye araakyoore kurwa orugeendo, araaza orusiku runo omugya atakumwiiseegera eriibhaga rino atamenyiri. ");
INSERT INTO zak_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Niho omukuru waaye aramutema bhukongʼu no okumurekera hano abhabheehi bhari. Eyo niyo bhakubha bhararira no okusaanania ameeno.” ");
INSERT INTO zak_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Niho Yeesu akabhabhuurira abhaanabheega bhaaye ekireengyo ekiindi, akabhuga, “Kwe eriibhaga riyo, obhutemi bhwa mwiisaaro bhuratuubhana ne ekireengyo kino. Haari na abhaakya ikumi bhano bhaagegiri eziitara zyaabhu no okugya kumusuungʼaana omukweeri. ");
INSERT INTO zak_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Abhataano bhayo bhaari abhageege, nawe abhaandi bhataano bhaari bha amangʼeeni. ");
INSERT INTO zak_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abhataano bhageege bhayo, bhakagega eziitara zyaabhu, nawe bhataagegiri amaguta agaandi go okwoongerya. ");
INSERT INTO zak_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nawe, abhataano bha amangʼeeni bhakagega eziitara zyaabhu, hamwe na amaguta go okwoongerya mubhigiro bhyaabhu. ");
INSERT INTO zak_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Hano omukweeri yakeezeeri okuuza, abhaakya bhayo bhoosi bhakasuundagira, kyaamwe bhakahiindira eziitiro ndito. ");
INSERT INTO zak_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nawe obhutiku bhwa gati, abhaatu bhakabhirikira, ‘Rora, omukweeri araaza! Muuze, tugeende kumusuungʼaana!’ ");
INSERT INTO zak_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Rugeendo rumwe, abhaakya bharya bhoosi bhakabhuuka, bhakabhanura eziitara zyaabhu. ");
INSERT INTO zak_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Abhaakya abhataano abhageege bharya, bhakabhuurira bha amangʼeeni, ‘Turasabha mutusakirye amaguta masuuhu, eziitara zyeetu zirarima.’ ");
INSERT INTO zak_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Nawe bhakabhakyoora, ‘Tutakunagya okubhasakirya, amaguta gano tunago, gatakutwiisa etwe hamwe na neemwe. Yiingabheeri kisi mugye eno bhakugurya amaguta, mwiigurire.’ ");
INSERT INTO zak_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ambe, abhaakya abhageege bhayo bhakagya kugura amaguta. Hano bhaagiiri, omukweeri akahika. Abhaakya bha amangʼeeni bhano bhaari bhiibhanwiiri, bhakasikira hamwe neewe munyuumba muno enyaangi yaari ekukorerwa. Kyaamwe, ekiseku kikiigarwa. ");
INSERT INTO zak_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Okuhita ibhaga iguhi, abhaakya abhageege bharya nabho bhakaaza, bhakabhona ekiseku kigeeri. Niho bhakabhirikira, ‘Ee omukuru, ee omukuru! Otwiigurire ekiseku!’ ");
INSERT INTO zak_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Nawe omukweeri akabhakyoora, ‘Ndabhabhuurira obhuheene, nitabhamenyiri emwe!’ ” ");
INSERT INTO zak_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hayo Yeesu akamara okugaamba, “Ambe, mwiiriihe, kwo okubha mutamenyiri orusiku naabhe eriibhaga rino enye ndaakyoore.” ");
INSERT INTO zak_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yeesu akageenderera kubhabhuurira ekireengyo ekiindi kweeki, akabhuga, “Obhutemi bhwa mwiisaaro bhuratuubhana kyeego ekireengyo kino. Kwaari no omuutu wumwe wuno akeenda kugya orugeendo. Hano yaari akyaari kutaanga orugeendo rwaaye, akabhabhirikira abhagya bhaaye, akabhaha ebhigiro bhyaaye bhyoosi okubha bhabhikorere emirimo. ");
INSERT INTO zak_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akabhaha kuriingʼaana no obhunagya bhwaabhu. Akamuha wo okutaanga eziitaraanta isaano, wa kabhiri eziitaraanta ibhiri na wa katatu etaraanta yimwe. Kyaamwe akatanura orugeendo. ");
INSERT INTO zak_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Hayohayo, omugya wuno yaheerwe eziitaraanta isaano, akagya kusuruzya no okubhona eziitaraanta eziindi isaano. ");
INSERT INTO zak_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Egoego, omugya wuno yaheerwe eziitaraanta ibhiri, akagya kusuruzya no okubhona eziitaraanta eziindi ibhiri. ");
INSERT INTO zak_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nawe omugya wuno yaheerwe etaraanta yimwe, ewe akagya okutuka omwoobho no okuyibhiika etaraanta yo omukuru waaye. ");
INSERT INTO zak_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Hano eriibhaga itaambi ryahitiri, omukuru waabhu akakyoora. Kyaamwe akabhabhirikira abhagya bhaaye, okubha bhamubhuurire kyeego bhakahokeerya eziitaraanta zyaaye. ");
INSERT INTO zak_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Omugya wuno yaheerwe eziitaraanta isaano, akaaza ne eziitaraanta eziindi isaano, akamubhuurira omukuru waaye, ‘Ee omukuru, okaaniha eziitaraanta isaano okubha nizikorere emirimo. Rora, nibhweeni obhweera bhwe eziitaraanta isaano eziindi.’ ");
INSERT INTO zak_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Omukuru waaye akamubhuurira, ‘Okoriri kisi. Awe ni mugya muzomu no omuheene! Waari omuheene kubhisuuhu bhino niakuheeri, kweego ambe, ndakutuura kubha omwiimeerereri we ebhigiro bhyaaru. Nawuuze tuzomererwe hamwe.’ ");
INSERT INTO zak_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Omugya wuno yaheerwe eziitaraanta ibhiri, neewe akaaza ne eziitaraanta ibhiri eziindi, akamubhuurira omukuru waaye, ‘Ee omukuru, okaaniha eziitaraanta ibhiri okubha nizikorere emirimo. Rora, nibhweeni obhweera bhwe eziitaraanta ibhiri eziindi.’ ");
INSERT INTO zak_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Omukuru waaye akamubhuurira, ‘Okoriri kisi. Awe ni mugya muzomu no omuheene! Waari omuheene kubhisuuhu bhino niakuheeri, kweego ambe, ndakutuura kubha omwiimeerereri we ebhigiro bhyaaru. Nawuuze tuzomererwe hamwe.’ ");
INSERT INTO zak_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nawe omugya wuno yaheerwe etaraanta yimwe, akaaza no okumubhuurira omukuru waaye, ‘Ee omukuru, nikamenya kubha awe ni muutu mukongʼu bhukongʼu. Awe oragesa amagesa gano oteemirye, no okukumania gano otanyarageenie. ");
INSERT INTO zak_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nikoobhoha okubhurya etaraanta yaazo, kweego nikagya okuyitukira haasi. Bhoono, ndasabha ogege etaraanta yaazo.’ ");
INSERT INTO zak_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Omukuru waaye akamukyoora, ‘Awe ni mugya mubhiihu no omutobhu! Eraabhe okamenya kubha enye ndagesa amagesa gano niteemirye, no okukumania gano nitanyarageenie, ");
INSERT INTO zak_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ambe, kwaki otaanituuriiri etaraanta yaane kubhasuruzya? Hano niingakyooriri, niari ndagega etaraanta yaane hamwe no obhweera bhwaku.’ ");
INSERT INTO zak_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Niho omukuru waaye akaswaagya abhaandi, ‘Kweego mugege etaraanta yiyo, mumuhe omugya wuno ane eziitaraanta ikumi. ");
INSERT INTO zak_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Omuutu wowoosi wuno akukorera emirimo ebhigiro bhino nimuheeri, ndamwoongerya no okutuumaho. Nawe omuutu wowoosi wuno atakukorera bhuzomu ebhigiro bhino nimuheeri, naabhe ebhisuuhu bhino anabhyo, ndamuteesya. ");
INSERT INTO zak_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Omugya wuno atana bhweera bhwobhwoosi, mumurekere igutu mukiirima, eyo niyo akubha ararira no okusaanania ameeno.’ ” ");
INSERT INTO zak_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yeesu akageenderera okugaamba na abhaanabheega bhaaye, akabhabhuurira, “Hano enye Omwaana wo Omuutu nikuuza mubhuguungo bhwaane, hamwe na bhamaraika bhoosi, niho ndiikare kukituumbi kyaane kyo obhuguungo. ");
INSERT INTO zak_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Abhaatu bhe ebhyaaro bhyoosi bhariikumania embere waane. Neenye ndabhatwaanikania kyo omuriisya akutwaanikania eziingʼoondu okurwa muziimburi. ");
INSERT INTO zak_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kyeego omuriisya akuzituura eziingʼoondu orubhaara rwaaye rwo obhuryo ne eziimburi orubhaara rwaaye rwo obhumosi, egoego, neenye ndabhatuura abhaatu abhaandi orubhaara rwaane rwo obhuryo na abhaandi orubhaara rwaane rwo obhumosi. ");
INSERT INTO zak_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Niho enye Omutemi, ndabhabhuurira abhaatu bhano bhari orubhaara rwaane rwo obhuryo, ‘Muuze, emwe bhano Taata waane abhatweereeri ebhite. Musikire mubhutemi bhuno Taatabhugya yabhabhanuriiri kweema hano yateemiri ekyaaro. ");
INSERT INTO zak_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Musikire, kwo okubha hano niari ne enzara, mukaaniha ebhyaakurya. Hano niari ne enyoota, mukaaniha amaanzi go okunywa. Hano niari mugini, mukaambuurira haguhi muziinyuumba zyeenyu. ");
INSERT INTO zak_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hano niendiri emyeenda, mukaaniibhohya. Hano niari murweeri, mukaaza okunirwaarya. Na hano niari munyuumba ya abhabhohwa, mukaaza okunirora.’ ");
INSERT INTO zak_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kweego, abhaatu bhayo bhe eheene embere wa Taatabhugya bharanikyoora, ‘Ee Omukuru, ni ibhagaki rino twaakuruuzi waari ne enzara tukakuha ebhyaakurya? Kasi waari ne enyoota tukakuha amaanzi go okunywa? ");
INSERT INTO zak_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kweeki, ni ryoori twaakuruuzi mugini tukakuginihya munyuumba yeetu? Kasi ryoori okeenda emyeenda tukakwiibhohya eziingibho? ");
INSERT INTO zak_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kweeki, ni ryoori waari murweeri tukakurwaarya? Kasi waari munyuumba ya abhabhohwa tukaaza kukurora?’ ");
INSERT INTO zak_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Niho enye Omutemi, ndabhakyoora, ‘Ndabhabhuurira obhuheene, riyo ryoosi rino mwaamukoreeri wowoosi gati wa abhaanabheega bhano bhatana bhweera, ambe mwaanikoreeri enye.’ ");
INSERT INTO zak_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kyaamwe, ndabhabhuurira bhano bhari orubhaara rwaane rwo obhumosi, ‘Murwe hano, emwe bhano mwiihiimirwe na Taatabhugya! Mugeende mumuriro gwa kirakeego guno Taatabhugya abhanwiiri kwiiguru ya Seetaani na bhamaraika bhaaye. ");
INSERT INTO zak_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mutanure, kwo okubha hano niari ne enzara, mutaaniheeri ebhyaakurya. Hano niari ne enyoota, mutaaniheeri amaanzi go okunywa. ");
INSERT INTO zak_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Hano niari mugini, mutaaniginihirye muziinyuumba zyeenyu. Hano niendiri emyeenda, mutaanibhohirye emyeenda. Hano niari murweeri, mutiiziri okunirwaarya. Na hano niari munyuumba ya abhabhohwa, mutiiziri okunirora.’ ");
INSERT INTO zak_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Niho, abhaatu bhano bhari mukubhoko kwaane kwo obhumosi bharanikyoora, ‘Ee Omukuru, ni ibhagaki rino twaakuruuzi waari ne enzara, kasi waari ne enyoota, kasi waari mugini, kasi wageendiri kingʼaabhi, kasi waari murweeri, kasi waari munyuumba ya abhabhohwa, etwe tutakusakiirye?’ ");
INSERT INTO zak_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Niho enye ndabhakyoora, ‘Ndabhabhuurira obhuheene, riyo ryoosi rino mutakumukorera wowoosi gati wa abhasuuhu bhano bhatana bhweera, ambe mutaanikoreeri enye.’ ");
INSERT INTO zak_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kweego, abhaatu bhe ebhibhi bhayo, bharagya okubhona obhutemwa bhwa kirakeego. Nawe bhe eheene embere wa Taatabhugya bhayo, bharasikira mubhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hano Yeesu yamariri okugaamba amangʼana gayo goosi, akabhabhuurira abhaanabheega bhaaye, ");
INSERT INTO zak_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kyeego mumenyiri, hano zikuhita eziisiku ibhiri, turabha ne Enyaangi yo Okuhiita. Kurusiku ruyo, enye Omwaana wo Omuutu, ndatuurwa mumabhoko ga abhabhisa, okubha niitwe kumusaraba.” ");
INSERT INTO zak_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ambe, eriibhaga riyo, abhakuru bha abhaseengeri na abhakaruka bha Abhayahudi bhakiikumania mwiibhaanza rye enyuumba yo omuseengeri omukuru, wuno akubhirikirwa Kayafa. ");
INSERT INTO zak_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Muyo, bhakiibhuurya kyeego bharaamugwaate Yeesu kwe embiso, okubha bhamwiite. ");
INSERT INTO zak_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bhakiikirirania, “Nawe tutaaza tukore gano mu Nyaangi yo Okuhiita, abhaatu bhataaza kukora orwaambi.” ");
INSERT INTO zak_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Niho Yeesu akagya mumugye gwa Betania, akiikara munyuumba ya Simooni wuno ekare yaari ne ebhigeenge. ");
INSERT INTO zak_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Hano Yeesu yaari kwiigari kurya, akaaza omukari wumwe yaari ne enzubha yino yakorirwe kwe eriigina rya arabasita ryo obhuguri bhukuru. Muusi we enzubha yiyo, kwaari na amaguta go omuruumbaaso gano gano obhuguri bhukuru bhukongʼu. Omukari wuyo akamwiituruurira Yeesu kumutwe kwo okumusuuka. ");
INSERT INTO zak_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hano abhaanabheega bhaaye bhaaruuzi gayo, bhakatiinda. Bhakabhuga, “Bhamure! Kwaki omukari wuno arasarya amaguta go obhuguri bhukuru ego? ");
INSERT INTO zak_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yiingabheeri bhuzomu amaguta gano gaguribhwe kwe eziimbirya nzaru, na ziingasakiirye abhataka!” ");
INSERT INTO zak_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Hano Yeesu akamenyeekererya amangʼana gayo, akabhabhuurira, “Kwaki muramunyaakya omukari wuno? Ewe anikoreeri eriingʼana izomu bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abhataka bhari hamwe neemwe eziisiku zyoosi, nawe enye nitakubha hamwe neemwe eziisiku zyoosi. ");
INSERT INTO zak_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hano omukari wuno anituruuriiri amaguta, akakora ego okubha abhanure omubhiri gwaane kwo okubhiikwa kwaane. ");
INSERT INTO zak_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ndabhabhuurira obhuheene, hayo hoosi hano gararwaazwa Amangʼana Amazomu iguru waane mukyaaro kyoosi, riragaambwa izomu rino omukari wuno anikoreeri, na abhaatu bharamuhiita.” ");
INSERT INTO zak_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ambe, owumwe wa abhaanabheega bha Yeesu ikumi na bhabhiri, wuno akubhirikirwa Yuuda Isikariyoti, akagya kubhakuru bha abhaseengeri, ");
INSERT INTO zak_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","akabhabhuurya, “Muranihaki hano ndaabhagwaatye Yeesu mumabhoko geenyu?” Kyaamwe bhakamuha eziimbirya miroongo etatu (30). ");
INSERT INTO zak_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kweemera eriibhaga riyo, Yuuda akataanga okumoohya eriibhaga izomu ryo okumurya omukoonyo. ");
INSERT INTO zak_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kurusiku rwo okutaanga rwe Enyaangi ye Emikaate Gino Gitana Ekibhwiisya, abhaanabheega bha Yeesu bhakaaza kweewe, bhakamubhuurya, “Oreenda tugye hayi tukubhanurire ebhyaakurya bhye Enyaangi yo Okuhiita?” ");
INSERT INTO zak_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yeesu akabhaha eriina ryo omuutu omurebhe akabhabhuurira, “Mugye mumugye gwa Yerusaremu kumuutu wuyo, mumubhuurire, ‘Omweegya atutumeenie, arabhuga: Eriibhaga ryaane riisukiri. Enye na abhaanabheega bhaane turarya ebhyaakurya bhye Enyaangi yo Okuhiita munyuumba yaazo.’” ");
INSERT INTO zak_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Abhaanabheega bhaaye bhakagya bhakakora goosi kyeego Yeesu yabharageenie, bhakabhanura ebhyaakurya bhye Enyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hano yahikiri engoroobha, Yeesu na abhaanabheega bhaaye ikumi na bhabhiri bhaari kwiigari bhararya. ");
INSERT INTO zak_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hano bhaari kurya, Yeesu akabhuga, “Ndabhabhuurira obhuheene, owumwe weenyu aranirya omukoonyo.” ");
INSERT INTO zak_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abhaanabheega bhaaye bhakabha ne ebhigoongi bhukongʼu, bhakataanga okumubhuurya owumwe kwo owumwe, “Ee Omukuru, enye neenye ndaakurye omukoonyo?” ");
INSERT INTO zak_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yeesu akabhakyoora, “Ni wuno akukorya mukitubha kimwe na neenye, niwe araanirye omukoonyo. ");
INSERT INTO zak_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Enye Omwaana wo Omuutu, ndiitwa kyeego yakaamirwe mu Makaamo Amahoreeru. Nawe, araaza kurora omuutu wuno araanirye omukoonyo enye Omwaana wo Omuutu. Yiingabheeri hakiriku kweewe omuutu wuyo atiingibhwiirwe!” ");
INSERT INTO zak_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ambe, Yuuda omuri wo omukoonyo, neewe akamubhuurya Yeesu, “Ee Omweegya, enye neenye ndaakurye omukoonyo?” Yeesu akamukyoora, “Naawe ogaambiri.” ");
INSERT INTO zak_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ambe, hano bhaari kurya, Yeesu akagega omukaate, akabhuga, “Ozomirye, Taatabhugya,” akagubhega, akabhaha abhaanabheega bhaaye, akabhabhuurira, “Mugege murye, omukaate guno nigwo omubhiri gwaane.” ");
INSERT INTO zak_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Akagega ekikoombe kya amaanzi amahya go omuzabibu, akabhuga, “Ozomirye, Taatabhugya,” akabhaha, akabhabhuurira, “Mugege amaanzi go omuzabibu gano, munywe emwe mwoosi. ");
INSERT INTO zak_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Amaanzi go omuzabibu gayo, nigo amanyiinga gaane ge eriiragano. Amanyiinga gaane gariitika kwiiguru ya abhaatu bhaaru, okubha Taatabhugya abhaabhire ebhibhi bhyaabhu. ");
INSERT INTO zak_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndabhabhuurira, nitakunywa kweeki amaanzi go omuzabibu tee orusiku runo ndaanywe kwe enzira ehya hamwe neemwe mubhutemi bhwa Taata waane.” ");
INSERT INTO zak_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Niho bhakeemba omweembo gwo okumukumya Taatabhugya. Bhakatanura hayo, bhakagya mu Kiguru kye Emizeituni. ");
INSERT INTO zak_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ambe, Yeesu akabhabhuurira abhaanabheega bhaaye, “Obhutiku bhwa reero, emwe mwoosi muraaningʼosa no okunitiga. Erabha ego, kwo okubha Amakaamo Amahoreeru gakubhuga, ‘Ndamwiita omuriisya we eziingʼoondu, ne eziingʼoondu zyaaye ziranyaragana.’ ");
INSERT INTO zak_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Nawe enye hano ndaaryookibhwe, ndabhakaangatira kugya Gariraaya.” ");
INSERT INTO zak_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kyaamwe, Petero akamubhuurira Yeesu, “Naabhe bhoosi bharaakutige, enye nitakukutiga kimwe!” ");
INSERT INTO zak_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yeesu akamukyoora, “Ndakubhuurira obhuheene, obhutiku bhuno hano ekorokoome ekyaari kugaamba, orabha omariri kunianga katatu koosi.” ");
INSERT INTO zak_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petero akamukyoora, “Eraabhe ereenderwa nikwe hamwe naawe, enye nitakukwaanga eheene!” Abhaanabheega abhaandi bhoosi nabho, bhakabhuga egoego. ");
INSERT INTO zak_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ambe, Yeesu akagya na abhaanabheega bhaaye kumusabha Taatabhugya mumuguundu guno gukubhirikirwa Getisemane. Hano bhaahikiri, akabhabhuurira, “Mwiikare hano, enye ndagya erya okumusabha Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Akamugega Petero hamwe na abhamura bhabhiri bha Zebedaayo. Yeesu akataanga kubha ne ebhigoongi no okuyaangayaanga mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Hano bhaahikiri akabhabhuurira, “Ekoro yaane ene ebhigoongi bhyaaru. Mwiikare hano, muteengeeze hamwe neenye.” ");
INSERT INTO zak_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Akiisuka embere hasuuhu, akahigama haasi bhubhuumari, akasabha Taatabhugya, “Ee Taata waane, eraaturikane, ndakusabha onduusiryeho eziinyaako zino. Otaaza kukora kyeego enye nikweenda, nawe okore kyeego awe okweenda.” ");
INSERT INTO zak_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ambe, Yeesu akakyoora hano yaari atigiri abhaanabheega bhaaye, akabhona bhahiindiiri eziitiro. Akamubhuurya Petero, “Mbe, mutamirwe kuteengeeza hamwe neenye naabhe kwe esa yimwe? ");
INSERT INTO zak_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Muteengeeze no okumusabha Taatabhugya, okubha mutaaza kusakibhwa. Ekoro ereenda nawe omubhiri ni munyookobhu.” ");
INSERT INTO zak_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yeesu akabhatiga hayo kweeki, akagya eyo orugeendo rwa kabhiri, akamusabha Taatabhugya, “Ee Taata waane, eraabhe eziinyaako zino zitakunagya okurwa kweenye, ambe gakorwe kyeego okweenda.” ");
INSERT INTO zak_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ambe, hano yakyooriri kubhaanabheega bhaaye, akabhabhona bhahiindiiri eziitiro kweeki, kwo okubha bhataanagirye kuramukya ameeso gaabhu. ");
INSERT INTO zak_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeesu akabhatiga kweeki, akagya kumusabha Taatabhugya orugeendo rwa katatu, akakyoorera okugaamba amangʼana garyagarya. ");
INSERT INTO zak_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ambe, hano yakyooriri kweeki kubhaanabheega bhaaye, akabhabhuurira, “Mukyaari muhiindiiri no okumuunya? Murore! Eriibhaga ryo okunyaakibhwa kwaane riisukiri, enye Omwaana wo Omuutu ndagwaatwa no okuhirwa kubhakori bhe ebhibhi. ");
INSERT INTO zak_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mwiimuke, tugye. Murore! Omuri waane wo omukoonyo ari haguhi!” ");
INSERT INTO zak_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hano Yeesu yaari akyaakeerenia amangʼana gayo, Yuuda, owumwe wa abhaanabheega bhaaye ikumi na bhabhiri, akaaza hamwe ne esaango ekuru ya abhaatu bhe eziinyaambato ne eziinduguzo. Esaango yiyo ekatumanibhwa na abhakuru bha abhaseengeri na abhakaruka bha Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Omuri wo omukoonyo wuyo, yaari akaangatiri okubhabhuurira abhaatu bhayo ekyeerekenio. Akabhabhuurira, “Omuutu wuno ndaamukeerye kwo okumuhuumbata, niwe wuyo, mumugwaate!” ");
INSERT INTO zak_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hano bhaahikiri, Yuuda akagya ku Yeesu, akamukeerya, “Omweegya, wareeri!” Kyaamwe akamuhuumbata. ");
INSERT INTO zak_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu akamukyoora, “Musaani waane, okore kino wiiziri kukora.” Ambe abhaatu bhayo bhakiisuka, bhakamugwaata Yeesu no okumubhoha. ");
INSERT INTO zak_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Niho owumwe wa abhaanabheega bha Yeesu, akasohora nyaambato, akamutema no okumutina okutwi omugya wo omuseengeri omukuru. ");
INSERT INTO zak_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nawe Yeesu akamubhuurira, “Kyoorya nyaambato mukyoobho, kwo okubha abhaatu bhoosi bhano bhakugwaata nyaambato okubha bhiite, nabho bhariitwa kwa nyaambato! ");
INSERT INTO zak_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mbe, otamenyiri kubha ndanagya okusabha Taata waane obhusakirya, neewe aratura okunitumanirya bhamaraika kukira amahizo amakuru ikumi na abhiri? ");
INSERT INTO zak_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nawe, eraabhe ndikora ego, igabhwi garanagya kukuunaana gano gakaamirwe mu Makaamo Amahoreeru kubha, niigo gakweenderwa kubha?” ");
INSERT INTO zak_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Niho Yeesu akabhabhuurira abhaatu bhe esaango yiyo, “Mbe, mwiiziri ne eziinyaambato ne eziinduguzo okunigwaata kyo omuteesya? Ndora eziisiku zyoosi niari ndeegya mwiiseengerero, nawe mutaanigwaatiri! ");
INSERT INTO zak_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nawe gano goosi gaatuukiri, okubha gakorwe gano abharooti bhaakaamiri mu Makaamo Amahoreeru.” Ambe, abhaanabheega bha Yeesu bhoosi bhakangʼosa, bhakamutiga. ");
INSERT INTO zak_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ambe, abhaatu bhano bhaamugwaatiri Yeesu, bhakagya nawe, bhakamuhira munyuumba ya Kayafa omuseengeri omukuru, muno bhaari bhiikumeenie abheegya bhe emigiro gya Musa na abhakaruka bha Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Eriibhaga riyo, Petero yaari aramutuniirira Yeesu kwa kure, tee mwiibhaanza rye enyuumba yo omuseengeri omukuru. Kyaamwe akasikira muusi, akiikara hamwe na abhariibhi okubha arore kyeego amasemo ga Yeesu garaabhe. ");
INSERT INTO zak_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abhakuru bha abhaseengeri ne ekiina ekikuru kyoosi kya Abhayahudi, bhaari bhareenda abhamenyeekererya bho orurimi okubha bhayibhone enzira yo okumwiita Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bhakaaza abhamenyeekererya bho orurimi bhaaru, nawe bhataabhweeni obhumenyeekererya bhwobhwoosi bhuno bhwaabhangʼariiri. ");
INSERT INTO zak_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Mubhuteero, abhamenyeekererya bhabhiri bhakaaza, bhakabhuga, “Omuutu wuno yabhugiri, ‘Ndanagya okusarya eriiseengerero rya Taatabhugya no okwoomboka kweeki kwe eziisiku isatu.’ ” ");
INSERT INTO zak_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kyaamwe omuseengeri omukuru akiimeerera, akamubhuurya Yeesu, “Ndora, otakukyoora ryoryoosi? Amangʼana gano abhaatu bhano bhakukuzoongera, orabhugabhwi?” ");
INSERT INTO zak_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nawe Yeesu ataakyooriri kiyo kyoosi. Ambe, omuseengeri omukuru wuyo akamubhuurira, “Ndakwiirahirya kwe eriina rya Taatabhugya wuno ari muhoru, otubhuurire eraabhe awe naawe Masiya, Omwaana wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu akamukyoora, “Naawe ogaambiri. Nawe ndabhabhuurira bhoosi, kweemera bhoono muraandora enye Omwaana wo Omuutu, ndabha niikeeri orubhaara rwo obhuryo rwa Taatabhugya wo obhunagya bhwoosi. Kweeki muranirora eriibhaga nikuuza kureka mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ambe, hano omuseengeri omukuru yiigwiiri amangʼana gayo, akangʼaarura eziingibho zyaaye, akabhuga, “Aa! Yiiriingʼeenie na Taatabhugya! Ambe, ni bhamenyeekereryaki kweeki bhano tukweenda? Mwiigwiiri emwe abheene kyeego akumutuka Taatabhugya! ");
INSERT INTO zak_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kweego emwe murabhuga igabhwi?” Bhakamukyoora, “Areenderwa yiitwe!” ");
INSERT INTO zak_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kyaamwe, bhakataanga okumutweera Yeesu amate mubhusyo, bhakamutema ebhikuundi. Abhaandi bhakamutema oruhi, ");
INSERT INTO zak_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","no okumubhuurira, “Ee Masiya, turootere, ni weewi wuno akutemiri?” ");
INSERT INTO zak_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ambe, kwe eriibhaga riyoriyo, Petero yaari yiikeeri mwiibhaanza igutu hayo. Niho omuhokya owumwe omuukya akamwiisukira Petero, akamubhuurira, “Awe woosi waari hamwe na Yeesu Omugariraaya.” ");
INSERT INTO zak_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nawe Petero akaanga embere ya abhaatu bhoosi, akubhuga, “Nitamenyiri gano okubhuga!” ");
INSERT INTO zak_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Niho akatanura hano yaari, akagya mukiseku. Omuukya owuundi omugya akamurora, akabhabhuurira abhaatu bhano bhaari hayo, “Omuutu wuno yaari hamwe na Yeesu Omunazareeti.” ");
INSERT INTO zak_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petero akaanga kweeki, akiirahira, akabhuga, “Nitamumenyiri omuutu wuyo!” ");
INSERT INTO zak_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Eriibhaga iguhi rikahita, abhaatu bhano bhaari abhamenyeekererya hayo, bhakamwiisukira Petero, bhakamubhuurira, “Eheene, awe ni wumwe mubhaatu bhano bhari hamwe na Yeesu. Naabhe obhugaambi bhwaazo bhureerekya mwaasi orarwa Gariraaya!” ");
INSERT INTO zak_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petero akataanga okwiihiimirirya bhukongʼu, akiirahira, akabhuga, “Nitamumenyiri omuutu wuyo!” Hayohayo, ekorokoome ekagaamba. ");
INSERT INTO zak_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Niho Petero akahiita amangʼana gano Yeesu yaari amubhuuriiri, “Hano ekorokoome ekyaari kugaamba, orabha omariri kunianga katatu koosi.” Kyaamwe, akahuruka igutu, akabha ararira kwo obhururu bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hano kwakiiri, abhakuru bhoosi bha abhaseengeri hamwe na abhakaruka bha Abhayahudi, bhakiitoongera kyaabhurya bharaakore bhamwiite Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kyaamwe bhakamubhoha, bhakagya nawe kumwaanaangwa we Ekirooma wuno yaari kubhirikirwa Pirato, bhakamugwaatya kweewe. ");
INSERT INTO zak_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kyaamwe, Yuuda wurya omuri wo omukoonyo, hano yaruuzi kubha Yeesu atiniirwe ekiina kubha yiitwe, akiiyiigwa bhubhi bhukongʼu. Akagega eziimbirya zirya miroongo etatu (30) no okuzikyoorya kubhakuru bha abhaseengeri na abhakaruka bha Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Akabhabhuurira, “Nikoriri ebhibhi okumugwaatya mumabhoko geenyu omuutu wuno atasarirye kiyo kyoosi.” Nawe ebho bhakabhuga, “Gayo gatakututunia etwe kweeki, ni nyaako yaazo omweene.” ");
INSERT INTO zak_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Niho Yuuda akarekera eziimbirya ziyo mwiiseengerero, akatanura, akagya, akiingʼeeta. ");
INSERT INTO zak_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abhakuru bha abhaseengeri bhakatoora eziimbirya ziyo, bhakabhuga, “Emigiro gyeetu gitakwiikirirya okusaangya eziimbirya zino ne eziimbirya zye eriiseengerero, kwo okubha zirihirwe okubha omuutu yiitwe.” ");
INSERT INTO zak_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ambe, bhakakeerenia no okwaamura kugega eziimbirya ziyo no okugura mumuguundu gwe ekiribho kwiiguru yo okubhiikiramu abhagini. ");
INSERT INTO zak_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kweego, omuguundu guyo gurabhirikirwa Omuguundu gwa Amanyiinga tee reero. ");
INSERT INTO zak_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Niho eriingʼana rikakuunaana rino omurooti Yeremia yakaamiri, “Bhakagega eziimbirya miroongo etatu (30), obhuguri bhuno abhamwe bha Abhiiziraeri bhiikirireenie iguru waaye. ");
INSERT INTO zak_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bhakagura omuguundu gwe ekiribho, kyeego Omukuru yaari aniswaagirye.” ");
INSERT INTO zak_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Niho Yeesu akiimeerera embere wo omwaanaangwa we Ekirooma. Omwaanaangwa wuyo akamubhuurya, “Awe naawe omutemi wa Abhayahudi?” Yeesu akamukyoora, “Naawe ogaambiri.” ");
INSERT INTO zak_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ambe, abhakuru bha abhaseengeri na abhakaruka bha Abhayahudi bhakataanga kumuzoongera Yeesu, nawe ataabhakyooriri ryoryoosi. ");
INSERT INTO zak_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Niho Pirato akamubhuurya, “Mbe, otakwiigwa gayo goosi gano bhakukuzoongera?” ");
INSERT INTO zak_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nawe Yeesu ataakyooriri, naabhe kwe eriisemo rimwe. Niho omwaanaangwa wuyo akaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Eriibhaga rye Enyaangi yo Okuhiita, omwaanaangwa we Ekirooma yaari aramwiigurira omubhohwa wumwe wuno abhaatu bhaamweendiri. ");
INSERT INTO zak_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ambe, kwe eriibhaga riyo, yaariho omubhohwa wumwe wuno yaari akubhirikirwa Baraaba. Omubhohwa wuyo, akamenyekana bhukongʼu iguru ya amabhi gano yaari akukora. ");
INSERT INTO zak_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kweego, hano abhaatu bhakiikumanirya hayo, Pirato akabhabhuurya, “Ni weewi wuno mukweenda nibhiigurire gati wa abhabhohwa bhano abhabhiri? Mureenda nibhiigurire Baraaba, kasi Yeesu wuno akubhirikirwa Masiya?” ");
INSERT INTO zak_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pirato akabhabhuurya ego, kwo okubha yamenyiri abhakuru bha Abhayahudi bhaamugwaatirye Yeesu kweewe, kwiiguru yo omugono. ");
INSERT INTO zak_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ambe, Pirato hano yaari yiikeeri kukituumbi kyaaye kyo okutinira ekiina, omukari waaye akamutumira amangʼana gano gaabhugiri, “Otaaza okamukorera eriibhiihu ryoryoosi omuutu wuyo wuno atana bhubhi, kwo okubha nanyaakiri bhukongʼu obhutiku mukirooto iguru waaye.” ");
INSERT INTO zak_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eriibhaga riyo abhakuru bha abhaseengeri na abhakaruka abhaandi bha Abhayahudi bhaari bharabhakorokoomba abhaatu kubha, bhamusabhe Pirato abhiigurire Baraaba no okumutinira ekiina Yeesu okubha yiitwe. ");
INSERT INTO zak_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pirato akabhabhuurya kweeki, “Ni weewi wuno mukweenda nibhiigurire gati wa abhabhohwa bhano bhabhiri?” Bhakamukyoora, “Baraaba!” ");
INSERT INTO zak_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pirato akabhabhuurya kweeki, “Ambe, nimukorebhwi Yeesu wuno akubhirikirwa Masiya?” Abhaatu bhoosi bhakakora ekituri bharabhuga, “Mumubhaambe kumusaraba!” ");
INSERT INTO zak_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pirato akabhabhuurya, “Akoriri isaryaki rino rigirirye abhaambwe kumusaraba?” Nawe, ebho bhakageenderera okutema ekituri bhakubhuga, “Mumubhaambe kumusaraba!” ");
INSERT INTO zak_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hano Pirato yamenyeekereerye kubha atakunagya kukyoosya amiiseego ga abhaatu bharya, no orwaambi rutaangiri, akagega amaanzi, akiisaabha amabhoko gaaye embere waabhu. Niho akabhuga, “Enye nitana isarya ryoryoosi kumanyiinga go omuutu wuno. Eriingʼana rino ni iguru weenyu abheene!” ");
INSERT INTO zak_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Abhaatu bhoosi bhakamukyoora, “Amanyiinga ga Yeesu gabhe iguru weetu na abhaana bheetu!” ");
INSERT INTO zak_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kyaamwe, Pirato akabhiigurira Baraaba. Akaswaagya bhamuteme Yeesu emijariti. Kimwe akaragania agegwe, atemererwe kumusaraba. ");
INSERT INTO zak_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Niho abhasirikare bho omwaanaangwa we Ekirooma bhakamugega Yeesu, bhakagya nawe mukiina ekikuru munyuumba yo omwaanaangwa. Bhakiikumania muyo abhasirikare abhaandi bhoosi, bhakamwiiruguura Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakamuruusya Yeesu eziingibho zyaaye, bhakamwiibhohya engibho ekaangaaru. ");
INSERT INTO zak_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bhakoogosa orusuurya rwa amahwa, bhakamwiibhohya kumutwe no okutuura maara mukubhoko kwaaye kwo obhuryo, okubha atuubhane kyo omutemi. Bhakamuhigamira embere waaye bhariikora bharamusuuka, kyaamwe bhakataanga okumuzibhura bharabhuga, “Kasiinga rugabho, omutemi wa Abhayahudi!” ");
INSERT INTO zak_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niho bhakamutweera amate, bhakagega maara mukubhoko kwaaye no okumutema kwo okwiinuurya naryo kumutwe. ");
INSERT INTO zak_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hano abhasirikare bhayo bhaamariri okumuzibhura ego, bhakamuruusya engibho yirya ye ekitemi no okumwiibhohya eziingibho zyaaye kweeki. Kyaamwe, bhakagya neewe okumubhaamba kumusaraba. ");
INSERT INTO zak_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hano abhasirikare hamwe na Yeesu bhaari bhakurwa mumugye gwa Yerusaremu, bhakamubhona munzira omuutu owumwe wuno yaari akubhirikirwa Simooni. Simooni wuyo akarwa mumugye gwa Kirene. Abhasirikare bhayo bhakamusingʼirirya okugega omusaraba gwa Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mubhuteero, bhakahika hagiro hano haabhirikiirwe Gorigota. Eriina rino obhugazuro bhwaku ni Kihaanga kyo Omutwe. ");
INSERT INTO zak_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kyaamwe, bhakamuha Yeesu amaanzi go omuzabibu gano bhaari bhasaangiinie ne endurwe. Nawe hano yaasamiri, akaanga okunywa. ");
INSERT INTO zak_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hano bhaamubhaambiri Yeesu kumusaraba, bhakatwaana eziingibho zyaaye, bhakazitemera obhwiitoori, okubha ekuunaane engʼana yino egaambirwe no omurooti iguru wa Yeesu, “Bhakatwaana eziingibho zyaane gati waabhu, no okukora obhwiitoori.” ");
INSERT INTO zak_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kyaamwe bhakiikara hayo okubha bhamuriibhe. ");
INSERT INTO zak_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iguru yo omutwe gwaaye, bhakatuura orubaawa runo runa amangʼana go okumuzoongera. Gakaamirwe, “Wuno ni Yeesu, Omutemi wa Abhayahudi.” ");
INSERT INTO zak_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Niho, abhasirikare bhakabhaamba abhateesya bhabhiri kumisaraba, owumwe orubhaara rwo obhuryo no owuundi orubhaara rwo obhumosi. ");
INSERT INTO zak_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Abhaatu bhano bhaari bhakuhita hayo, bhakamuzeera Yeesu kwo okusiingisya emitwe gyaabhu, no okubhuga, ");
INSERT INTO zak_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Awe, okabhuga oragwiisya eriiseengerero no okwoomboka kwa siku isatu, bhoono wiituurye! Eraabhe heene awe niwe Omwaana wa Taatabhugya, wiike kumusaraba!” ");
INSERT INTO zak_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kweego ego, abhakuru bha abhaseengeri na abheegya bhe emigiro gya Musa hamwe na abhakaruka bha Abhayahudi bhakamuzibhura Yeesu, “Yaari aratuurya abhaandi, nawe atakunagya kwiituurya omweene! ");
INSERT INTO zak_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Eraabhe heene ni mutemi wa Abhiiziraeri, bhoono yiike kumusaraba, niho neetwe turaamwiikirirye. ");
INSERT INTO zak_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ewe aramwiisiga Taatabhugya, na abhugiri, ‘Enye ni Mwaana wa Taatabhugya.’ Ambe, Taatabhugya amutuurye bhoono eraabhe amuseegiri heene.” ");
INSERT INTO zak_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abhateesya bhano bhaabhaambirwe haguhi no omusaraba gwa Yeesu, nabho bhakamutuka kya abhaandi bhano bhaari kumutuka. ");
INSERT INTO zak_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ambe, kweemera eriibhaga rya kasaasabha mumwiisi, ekiirima kikasikira mukyaaro kyoosi tee eriibhaga rya keenda. ");
INSERT INTO zak_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kwe eriibhaga rya keenda, Yeesu akarira kwe eriiraka ikuru, “Eri, Eri! Rama sabakitani?” Obhugazuro bhwaku ni, “Ee Taatabhugya waane, ee Taatabhugya waane, ndora onitigiri?” ");
INSERT INTO zak_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hano abhaatu bhano bhakiimeerera hayo bhakiigwa amangʼana gayo, abhaandi bhakabhuga, “Wuno aramubhirikira omurooti Eriya.” ");
INSERT INTO zak_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hayohayo, owumwe waabhu akaryaara bhwaangu, akaaza ne epaamba, akayiitobhya mumaanzi amaruru go omuzabibu gari musuka, akayituura epaamba kumaara, okubha amuhe Yeesu anywe. ");
INSERT INTO zak_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nawe eriibhaga riyoriyo abhaandi bhakabhuga, “Tiga otamuha! Turore eraabhe Eriya araaza kumutuurya!” ");
INSERT INTO zak_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hayo, Yeesu akarira kweeki kwe eriiraka ikuru, kyaamwe akatina ekoro. ");
INSERT INTO zak_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hayohayo, omweenda guno gwaari mu Hahoreeru he eriiseengerero gukaraanduka mbaara ibhiri okurwa iguru tee haasi. Kwaari ne eriirigito eriikuru rye esi rino ryaagirirye amatare okwaatika. ");
INSERT INTO zak_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Eziimbiihira zya mumabhigi zikiiguka ne emibhiri gya abhahoreeru bhaaru gikaryooka. ");
INSERT INTO zak_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hano Yeesu yaryookiri, bhakahuruka muziimbiihira zyaabhu, bhakagya Yerusaremu, bhakabhahwaarukira abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hano omukuru wa abhasirikare hamwe na bhano bhaamuriibhiri Yeesu bhaaruuzi eriirigito rye esi na agaandi goosi gano gaatuukiri, bhakoobhoha bhukongʼu, bhakabhuga, “Eheene, omuutu wuno yaari Omwaana wa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hayo bhaari bhariho abhakari bhaaru bhano bhaari bhamutuniiriiri Yeesu kweema Gariraaya no okumuhokeerya. Abhakari bhayo bhakiimeerera kwa kure bhakarora goosi gano gaari gakukorwa. ");
INSERT INTO zak_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mubhakari bhayo, bhaari bharimu Mariamu wa mumugye gwa Magidara, Mariamu nina wa Yaakobo na Yusufu, no omukari wa Zebedaayo wuno yaari nina wa Yaakobo na Yohana. ");
INSERT INTO zak_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hano yahikiri engoroobha, akaaza omwaanamweega wumwe wa Yeesu wuno yaari kubhirikirwa Yusufu. Neewe yaari muniibhi akarwa mumugye gwa Arimataya. ");
INSERT INTO zak_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yusufu wuyo, akagya ku Pirato, akamusabha ekituundu kya Yeesu. Ambe, Pirato akaswaagya abhasirikare bhaaye kubha bhamuhe ekituundu kirya. ");
INSERT INTO zak_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu akagya, akagega ekituundu kya Yeesu, akakiriizirira mumweenda gwo obhuguri bhukuru. ");
INSERT INTO zak_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Akakituura mumbiihira yino bhatakamubhiikiri muutu wowoosi, yaari ebhaazirwe kwiitare kwiiguru waaye. Kyaamwe akarihiriingitya eriigina eriikuru akaribha ekiseku kye embiihira, akatanura. ");
INSERT INTO zak_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kwe eriibhaga riyo ryoosi, Mariamu wa mumugye gwa Magidara na Mariamu wurya owuundi, bhaari bhiikeeri hayo bhararoreerera embiihira. ");
INSERT INTO zak_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Orusiku rwa kabhiri, runo rwaari orusiku rwo okumuunya, abhakuru bha abhaseengeri na Abhafarisayo bhakiikumania ku Pirato. ");
INSERT INTO zak_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bhakamubhuurira Pirato, “Ee omukuru, turahiita kubha hano omubheehi wurya yaari akyaari muhoru, akabhuga, ‘Murusiku rwa katatu, ndaryooka okurwa mubhaku.’ ");
INSERT INTO zak_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kweego, turasabha obharaganie abhasirikare bhaazo bhariibhe embiihira tee orusiku rwa katatu. Eraabhe otakunagya obhuriibhi, abhaanabheega bhaaye bharanagya kuuza okwiibha ekituundu kyaaye no okungʼeenererya abhaatu kubha aryookiri okurwa mubhaku. Hano bharaakore ego, orurimi ruyo rurabha rubhiihu bhukongʼu kukira rurya rwataangiri.” ");
INSERT INTO zak_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pirato akabhakyoora, “Mugege abhasirikare, mugye muriibhe embiihira kwa amanaga geenyu goosi.” ");
INSERT INTO zak_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Niho bhakagya kumbiihira, bhakatuura orubhaaso kwiigina rirya, okubha bhamenyeekererye kubha eraabhe omuutu ariihiriingitirye. Mubhuteero, bhakatiga hayo abhasirikare okubha bhariibhe embiihira. ");
INSERT INTO zak_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hano orusiku rwo okumuunya rwahitiri, etabhoori zuri orusiku rwo okutaanga rwo obhutuuro, Mariamu wa mumugye gwa Magidara hamwe na Mariamu owuundi wurya, bhakagya okurora embiihira. ");
INSERT INTO zak_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kituukiro, rikatuuka eriirigito ikuru rye esi, kwo okubha maraika wo Omukuru, Taatabhugya akiika okurwa mwiisaaro. Maraika wuyo akiisuka kumbiihira, akarihuungura eriigina rirya embarika, akiikara iguru waku. ");
INSERT INTO zak_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yaari aramesya kyo obhweero bhwo orukubha, ne emyeenda gyaaye gyaari mirabhu pee kyo omusoke. ");
INSERT INTO zak_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hano abhasirikare bharya bhaaruuzi gayo, bhakoobhoha bhukongʼu, bhakarigita no okugaandaara. ");
INSERT INTO zak_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hayo, maraika wuyo akabhabhuurira abhakari bharya, “Mutoobhoha! Nimenyiri kubha mwiiziri kumumoohya Yeesu, wuno bhaamubhaambiri kumusaraba. ");
INSERT INTO zak_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Atariho hano! Aryoorirwe, kyeego yabhugiri. Muuze murore hano bhaari bhamuhiindiirye. ");
INSERT INTO zak_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ambe, mugye bhwaangu, mubhabhuurire abhaanabheega bhaaye, ‘Aryookiibhwe, na arabhakaangatira kugya mukyaaro kya Gariraaya. Eyo niyo muraamubhone!’ Ambe, gano nibhabhuuriiri mugahiite!” ");
INSERT INTO zak_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Niho abhakari bhayo bhakatanura bhwaangu okurwa mumbiihira hayo, bhaari ne ehaho no obhuzomererwa bhukuru. Bhakaryaara kugya kubhabhuurira abhaanabheega bhaaye kyeego maraika yaari abhabhuuriiri. ");
INSERT INTO zak_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ambe, hano bhaari kugya kubhuurira abhaanabheega bhaaye amangʼana, hayohayo Yeesu akasikana nabho, akabhakeerya, “Mwaareeri!” Bhakamwiisukira Yeesu, bhakagwaata amaguru gaaye no okumuseengera. ");
INSERT INTO zak_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Niho Yeesu akabhabhuurira, “Mutoobhoha. Mugye mubhabhuurire abhahiiri bhaane bhagye Gariraaya, eyo niyo bharaanibhone.” ");
INSERT INTO zak_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ambe, hano abhakari bhayo bhaari kugya munzira, abhamwe bha abhasirikare bhano bhaari kuriibha embiihira ya Yeesu bhakatanura hayo no okugya mumugye gwa Yerusaremu. Hano bhaahikiri, bhakabhuurira abhakuru bha abhaseengeri goosi gano gaatuukiri. ");
INSERT INTO zak_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kyaamwe abhakuru bha abhaseengeri bhayo bhakasikana hamwe na abhakaruka bha Abhayahudi, bhakiitoongera no okwaamura kyeego bharaakore. Niho bhakabhaha abhasirikare bharya ehoongo ye eziimbirya nzaru. ");
INSERT INTO zak_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bhakabhabhuurira, “Eraabhe omuutu wowoosi arabhabhuurya iguru ya gano gaatuukiri, mubhuge, ‘Obhutiku hano etwe twaari tuhiindiiri eziitiro, abhaanabheega bha Yeesu bhakaaza bhakiibha ekituundu kyaaye.’ ");
INSERT INTO zak_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Eraabhe omwaanaangwa ariigwe gayo, etwe turagaamba neewe okubha mutaaza kusikira munyaako.” ");
INSERT INTO zak_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niho abhasirikare bhakagega eziimbirya, bhakakora kyeego bhaabhuuriirwe. Amangʼana gaabhu go orurimi gakanyaragana bhukongʼu gati wa Abhayahudi, na gakyaari garanyaraganibhwa tee reero. ");
INSERT INTO zak_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abhaanabheega bha Yeesu ikumi na wumwe bhakagya Gariraaya mukiguru kino Yeesu yabhaswaagirye. ");
INSERT INTO zak_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hano bhaamuruuzi, bhakamuseengera, nawe abhamwe bhaabhu bhakiitiimaata kubha ni Yeesu. ");
INSERT INTO zak_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ambe Yeesu akabhiisukira, akabhabhuurira, “Niheerwe obhuturo bhwoosi bhwa mwiisaaro na mukyaaro. ");
INSERT INTO zak_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kweego, mugeende kubhaatu bhe ebhyaaro bhyoosi no okubhakora bhabhe abhaanabheega bhaane. Mubhe murabhabatiiza kwe eriina rya Taata, na ryo Omwaana na rye Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na mubheegye okugwaata goosi gano nibhaswaagirye emwe. Muhiite, enye ndabha hamwe neemwe eziisiku zyoosi, tee obhuteero bhwe ekyaaro.”");
INSERT INTO zak_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Bhuno nibhwo obhweemero bhwa Amangʼana Amazomu iguru wa Yeesu Krisito, Omwaana wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kyeego gaari gakaamirwe no omurooti Isaya mukitabhu kyaaye kubha, Taatabhugya akabhuga, “Rora, ndamuragania omuhokya waane embere waazo, okubha akweeyeerye enzira. ");
INSERT INTO zak_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Omutumwa waane wuyo, araaza arabhuga: Omuutu wuno akubhirikira kwe eriiraka ikuru okurwa mwiitirigo: ‘Mumukorere Omukuru enzira, mugororokye eziinzira zino araahite!’ ” ");
INSERT INTO zak_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Omutumwa wuyo yaari arabhirikirwa Yohana Omubatiizi. Yaari mwiitirigo ararwaazira abhaatu, “Mute ebhibhi bhyeenyu mukyoorere Taatabhugya no okubatiizwa, okubha abhaabhire ebhibhi bhyeenyu!” ");
INSERT INTO zak_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Abhaatu bhaaru bhakabha bharamuuzaku okurwa omugye gwa Yerusaremu, ne ekyaaro kyoosi kya Yudea. Abhaatu bhayo bhakata ebhibhi bhyaabhu, neewe akabha arabhabatiiza mu Kitaaro kya Yorodaani. ");
INSERT INTO zak_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana yaari yiibhohiri emyeenda gya amabhuri ge engamia, no omukena gwe eriisaakwa mubhukeeneende. Ebhyaakurya bhyaaye bhyaari eziingigi no obhuuki bhwa mwiitirigo. ");
INSERT INTO zak_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Neewe yarwaaziri akubhuga, “Okuhita enye araaza wa amanaga bhukongʼu kukira enye, wuno enye nitakungʼarira naabhe kwiihiinya kutazura eziikobha zye ebhikweera bhyaaye. ");
INSERT INTO zak_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Enye ndabhabatiiza kwa amaanzi, nawe ewe arabhabatiiza kwe Ekoro Muhoreeru.” ");
INSERT INTO zak_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eriibhaga riyo, Yeesu akaaza okurwa mumugye gwa Nazareeti, mukyaaro kya Gariraaya. Yohana akamubatiiza Yeesu mu Kitaaro kya Yorodaani. ");
INSERT INTO zak_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hano Yeesu yaari akurwa mumaanzi, kituukiro eriisaaro rikiiguka, ne Ekoro Muhoreeru akiika kweewe kye ekiguuti. ");
INSERT INTO zak_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne eriiraka rikarwa mwiisaaro rikabhuga, “Awe naawe Omwaana waane omuseegwa, nizomereerwe naawe.” ");
INSERT INTO zak_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hayohayo Ekoro Muhoreeru akamukaangata Yeesu kugya mwiitirigo. ");
INSERT INTO zak_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akiikara eyo eziisiku miroongo ene (40), arasakibhwa na Seetaani. Yaari hamwe ne ebhityeenyi bhya mwiitirigo, nabho bhamaraika bha Taatabhugya bhakaaza okumuhokeerya. ");
INSERT INTO zak_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Eziisiku zikahita, Yohana akabhohwa mukibhoho. Hano yaari mukibhoho, Yeesu akagya mukyaaro kya Gariraaya, akabha ararwaaza Amangʼana Amazomu ga Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hano yaari akyarwaaza, akabhuga, “Eriibhaga rino ryarageenwe, rihikiri, no obhutemi bhwa Taatabhugya bhuri haguhi. Ambe, mute ebhibhi bhyeenyu mumwiikyoorere Taatabhugya, no okwiikirirya Amangʼana Amazomu gayo.” ");
INSERT INTO zak_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Orusiku rumwe, hano Yeesu yaari akuhita embarika we Enyaanza ya Gariraaya, akabharora Simooni na wamwaabhu Andurea. Bhaari bharataasa eziinzero munyaanza, okubha bhagwaatye eziiswe. ");
INSERT INTO zak_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeesu akabhabhuurira, “Muuze, munituniirire! Enye ndabhakora mubhe abhategi bha abhaatu.” ");
INSERT INTO zak_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hayohayo, bhakatiga eziinzero zyaabhu, bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hano Yeesu yaari agiiri embere hasuuhu hamwe na abhaanabheega bhaaye bhabhiri, akabharora Yaakobo na wamwaabhu Yohana, abhaana bha Zebedaayo, bhari mubhwaato, bharazomya eziinzero zyaabhu. ");
INSERT INTO zak_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Eriibhaga riyoriyo, akabhabhirikira bhamutuniirire. Bhakamutiga wiise waabhu hamwe na abhakori bhaaye bhe emirimo mubhwaato, bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Niho Yeesu na abhaanabheega bhaaye bhane bhayo, bhakagya mumugye gwa Kaperinaumu. Hano orusiku rwo okumuunya rwaahikiri, bhakasikira munyuumba ye esaango na Yeesu akataanga okweegya. ");
INSERT INTO zak_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Abhaatu bhaari bharuguuriri, kwo okubha ameegyo gaaye gatabheeri kya garya ga abheegya bhaabhu bhe emigiro. Nawe akeegya kyo omuutu wuno ano obhuturo. ");
INSERT INTO zak_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na munyuumba ye esaango, yaarimu omuutu wuno yatiirirwe ne eriisaambwa eriibhi. Akatiirya eriiraka, ");
INSERT INTO zak_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","akabhuga, “Awe Yeesu wa Nazareeti, otatunyaakya! Mbe, wiiziri kutusikya? Nikumenyiri awe ni weewi, awe ni Muhoreeru wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yeesu akarirekya eriisaambwa riyo arabhuga, “Kira! Noorwe kumuutu wuno!” ");
INSERT INTO zak_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eriisaambwa eriibhi rikamusiingisya bhukongʼu omuutu wuyo, rikarira kwe eriiraka no okumurwaku. ");
INSERT INTO zak_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Abhaatu bhoosi bhakaruguura bhukongʼu, bhakiibhuurya, “Niki kino? Gano ni meegyo mahya, gano obhuturo! Kweeki, murore, ana amanaga go okuswaagya amasaambwa, nago garamwiigwa.” ");
INSERT INTO zak_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ritari ibhaga itaambi, abhaatu okurwa mukyaaro kyoosi kya Gariraaya, bhakabha bhiigwiiri amangʼana iguru wa Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yeesu na abhaanabheega bhaaye abhamwe, Yaakobo na Yohana bhakatanura munyuumba ye esaango, bhakagya wa Simooni na Andurea. ");
INSERT INTO zak_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hano bhaahikiri, Yeesu akabhuurirwa kubha, inyibhyaara Simooni arwaariri ehooma haari, ari munyuumba ahiindiiri kubhuriri. ");
INSERT INTO zak_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Niho Yeesu akiisuka hano yaari ahiindiiri, akamugwaata okubhoko, akamwiimukya. Rugeendo rumwe inyibhyaara Simooni akahora ehooma, akataanga okubhahokeerya ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Orusiku ruyo engoroobha, hano orusiku rwo okumuunya rwaahwiiri, abhaatu bha mumugye guyo bhaari bharamureetera Yeesu abharweeri bhaaru, na bhano bhaari bhatiirirwe na amasaambwa. ");
INSERT INTO zak_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Abhaatu bhaaru okurwa mumugye guyo, bhakasikana mukiseku murukuungu rwe enyuumba ya Simooni na Andurea. ");
INSERT INTO zak_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yeesu akahorya abhaatu bhano bhaari na amarweeri maanga maaru. Kweeki, akaheebha amasaambwa amabhi maaru, nawe ataatigiri amasaambwa gagaambe, kwo okubha akamenya kubha ewe ni Mwaana wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Etabhoori yaho zuri, Yeesu akabhuuka, akagya kibhezo, akataanga okusabha. ");
INSERT INTO zak_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Hano Simooni na abharikyaaye bhakabhona atarimu munyuumba, bhakagya kumumoohya. ");
INSERT INTO zak_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hano bhaamubhweeni, bhakamubhuurira, “Abhaatu bhaaru bhukongʼu bharakukomya!” ");
INSERT INTO zak_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yeesu akabhabhuurira, “Tugye mumigye egiindi gya haguhi, okubha nirwaaze eyo, kwo okubha niiziri kukora emirimo giyo.” ");
INSERT INTO zak_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Niho akiiruguura mukyaaro kyoosi kya Gariraaya no okurwaaza muziinyuumba zye eziisaango, no okubharuusya abhaatu amasaambwa amabhi. ");
INSERT INTO zak_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Orusiku rumwe, omuutu wumwe we ebhigeenge akaaza ku Yeesu. Akahigama no okumwiisasaama, “Nimenyiri oranagya okunihorya okubha nieribhwe. Eraabhe oryeende, ndasabha onihorye!” ");
INSERT INTO zak_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yeesu akamurorera ebhigoongi, akagororokya okubhoko kwaaye, akamugwaataku omurweeri, akamubhuurira, “Ndeenda ohore, weeribhwe!” ");
INSERT INTO zak_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Rugeendo rumwe, ebhigeenge bhikamurwaku, akeeribhwa. ");
INSERT INTO zak_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Niho Yeesu akamuruusyaho bhwaangu, ");
INSERT INTO zak_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","akamubhuurira, “Itegeerera, otamubhuurira muutu wowoosi iguru ya rino! Nawe wiiyeerekye kumuseengeri, oruusye ekimweeso kyeego emigiro gya Musa gikuswaagya, okubha weerekye abhaatu kubha weeriibhwe.” ");
INSERT INTO zak_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nawe, omuutu wurya akatanura harya, akataanga kurwaaza amangʼana go okuhoribhwa kwaaye. Okutuukana na gayo, Yeesu akatamwa kusikira mumigye gyogyoosi girya kwa mwaasi. Akiikara omweene igutu we emigye kibhezo, nawe abhaatu bhakabha bharamuuzaku okurwa mbaara zyoosi. ");
INSERT INTO zak_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Hano eziisiku suuhu zyahitiri, Yeesu akagya kweeki Kaperinaumu. Eriibhaga isuuhu, abhaatu bhakiigwa kubha ari yiika. ");
INSERT INTO zak_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Abhaatu bhaaru bhakiikumania munyuumba murya, naabhe omweeya gwo okuhita mukiseku gukabhura. Yeesu yaari ararwaazira abhaatu eriingʼana rya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hano yaari akurwaaza, bhakaaza abhaatu bhane, bhagegiri omuutu kukiigi wuno ebhiimo bhikuuri. ");
INSERT INTO zak_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bhataanagirye kumusikirya hano Yeesu yaari, kwe ekigirirye kye esaango ekuru. Bhakatiira kukisara kye enyuumba, bhakahobhora ekisara iguru hano Yeesu yaari, bhakamwiituumya wuno yaari akuuri ebhiimo ari kukiigi. ");
INSERT INTO zak_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hano Yeesu yaruuzi obhwiikirirya bhwaabhu, akamubhuurira wurya yaari akuuri ebhiimo, “Ee omwaana waane, nikwaabhiiri ebhibhi bhyaazo.” ");
INSERT INTO zak_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na hayo, bhaari bhiikeeri abheegya bharebhe bhe emigiro gya Musa. Bhariiseega muziikoro zyaabhu, ");
INSERT INTO zak_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ndora omuutu wuno arabhuga ego? Aramutuka Taatabhugya! Atariho omuutu wuno akunagya okwaabhira ebhibhi, nawe Taatabhugya omweene!” ");
INSERT INTO zak_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Rugeendo rumwe, Yeesu akamenya amiiseego gaabhu muziikoro zyaabhu, akabhabhuurira, “Kwaki muriiseega ego muziikoro zyeenyu? ");
INSERT INTO zak_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mbe, ni riihe eriihuhu bhukongʼu, okumubhuurira wuno akuuri ebhiimo, ‘Nikwaabhiiri ebhibhi bhyaazo,’ kasi okumubhuurira, ‘Imeerera, gega ekiigi kyaazo, ogeende’? ");
INSERT INTO zak_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nawe, ndeenda mumenye bhuzomu kubha, enye Omwaana wo Omuutu nino obhuturo bhwo okwaabhira ebhibhi mukyaaro kino.” Niho Yeesu akamubhuurira omuutu wuyo yaari akuuri ebhiimo, ");
INSERT INTO zak_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ndakubhuurira, imeerera, gega ekiigi kyaazo, noogye yiika!” ");
INSERT INTO zak_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hayohayo, omuutu wurya akiimeerera, akiitweeka ekiigi kyaaye, akareka embere wa abhaatu bhayo bhoosi, nabho bhakaruguura no okumuguungya Taatabhugya, bhakabhuga, “Tukyaari kurora ekisigo kya kino kikorirwe reero!” ");
INSERT INTO zak_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yeesu akareka harya, akagya kweeki embarika we Enyaanza ya Gariraaya. Abhaatu bhaaru bhakamutuniirira, akabheegya. ");
INSERT INTO zak_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hano yaari akugeenda, akamurora Raawi omwaana wa Arifayo. Yaari ariikara mwiitobhero ryaaye ryo okutinira eriigooti. Yeesu akamubhuurira, “Nituniirira, obhe omwaanamweega waane.” Rugeendo rumwe, Raawi akiimeerera, akamutuniirira. ");
INSERT INTO zak_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yeesu na abhaanabheega bhaaye bhakagya kurya ebhyaakurya munyuumba ya Raawi. Abhatobhya bhe eriigooti na abhaatu bhe ebhibhi bhaaru bhaari bhararya ebhyaakurya hamwe nabho, kwo okubha abhaaru bhe eteemwa yino bhaari bharamutuniirira. ");
INSERT INTO zak_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ambe, abheegya bhe emigiro bhano bhaari Abhafarisayo, hano bhaamuruuzi Yeesu ararya hamwe na abhatobhya bhe eriigooti na bhe ebhibhi abhaandi, bhakabhuurya abhaanabheega bhaaye, “Ndora ararya hamwe na abhatobhya bhe eriigooti na abhaandi bhe ebhibhi?” ");
INSERT INTO zak_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hano Yeesu yiigwiiri ego, akabhabhuurira, “Abhaatu abhahoru bhatakweenda mugabhu, nawe abharweeri nibho bhakumweenda! Ambe, enye nitiiziri kubhirikira abhaatu bhe eheene bhamwiikyoorere Taatabhugya, nawe abhaatu bhe ebhibhi.” ");
INSERT INTO zak_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Eriibhaga eriirebhe, abhaanabheega bha Yohana Omubatiizi hamwe na Abhafarisayo bhaari bhariisiitya ebhyaakurya. Orusiku rumwe, abhaatu abharebhe bhakagya ku Yeesu, bhakamubhuurya, “Ndora abhaanabheega bha Yohana na abhaanabheega bha Abhafarisayo bhariisiitya ebhyaakurya, nawe abhaanabheega bhaazo bhatakwiisiitya ebhyaakurya?” ");
INSERT INTO zak_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeesu akabhakyoora, “Abhasaani bho omukweeri bhano bharaarikirwe munyaangi yo obhweenga, bharanagyabhwi kubha ne ebhigoongi eriibhaga bhari hamwe no omukweeri? Eriibhaga ryoosi bhari hamwe no omukweeri, bhatakunagya okwiisiitya kurya! ");
INSERT INTO zak_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nawe, orusiku ruraaza runo omukweeri araaruusibhweho gati wa abhagini bhaaye. Hayo niho abhasaani bhaaye bhakubha ne ebhigoongi no okwiisiitya ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Okusaangya ameegyo gaane amahya ne eziinyaangi zyeenyu kutuubheeni no okutuma ekiraka kyo omweenda omuhya kumweenda omukuungu. Ekiraka kirya kiraraandura omweenda guyo no okwoongerya hano haraandukiri. ");
INSERT INTO zak_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kweeki, atariho omuutu wuno akwiituruurira amaanzi amahya go omuzabibu mukiribha ekikuungu. Hano gakutuunduura no okubhiimba, ekiribha kiratamwa kyaamwe kiraatika. Amaanzi amahya go omuzabibu gareenderwa kutuurwa mukiribha ekihya.” ");
INSERT INTO zak_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Orusiku rumwe rwo okumuunya, Yeesu hamwe na abhaanabheega bhaaye bhaari bharahita kunzira yino yaari mumiguundu gye engano. Abhaanabheega bhaaye bhakataanga okubhuna ebhigara bhye engano, bhakarya. ");
INSERT INTO zak_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Niho, Abhafarisayo bhakamubhuurira Yeesu, “Rora, abhaanabheega bhaazo bharakora gano emigiro gitakwiikirirya okukorwa kurusiku rwo okumuunya!” ");
INSERT INTO zak_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yeesu akabhakyoora, “Mbe, mukyaari okusoma mu Makaamo Amahoreeru kyeego Daudi yaakoriri eriibhaga rino ewe na abharikyaaye bhaari ne enzara? ");
INSERT INTO zak_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Akasikira mwiibhuru ryo okumuseengera Taatabhugya, eriibhaga Abhiataari yaari omuseengeri omukuru wa Taatabhugya, akarya emikaate gino gyaatuurirwe embere wa Taatabhugya, gino emigiro gya Musa gitiikiriirye bharye, nawe abhaseengeri abheene ego. Nawe Daudi akarya giyogiyo, kweeki akabhaha na abharikyaaye, neebho bhakarya.” ");
INSERT INTO zak_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Niho Yeesu akabhabhuurira, “Orusiku rwo okumuunya rwatuurirwe iguru wa abhaatu, etari abhaatu iguru wo orusiku rwo okumuunya. ");
INSERT INTO zak_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kweego, mumenye kubha, enye Omwaana wo Omuutu, niwe Omukuru wo orusiku rwo okumuunya.” ");
INSERT INTO zak_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Orusiku oruundi rwo okumuunya, Yeesu akasikira munyuumba ye esaango ya Kaperinaumu, yaari ariho omuutu wuno okubhoko kwaari kukuuri. ");
INSERT INTO zak_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abhafarisayo bhaari bharamwiiteengera Yeesu, bharore eraabhe aramuhorya omuutu wuyo orusiku rwo okumuunya, okubha bhamuseme. ");
INSERT INTO zak_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeesu akamubhuurira omuutu wuno okubhoko kukuuri, “Nawuuze, wiimeerere gatigati hano.” ");
INSERT INTO zak_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Niho Yeesu akabhabhuurya, “Bhoono, emigiro gya Musa giriikirirya, ni riihe eriizomu kurusiku rwo okumuunya, okukora amazomu kasi okukora amabhiihu, okuhorya kasi okwiita?” Ebho bhakakira kiri. ");
INSERT INTO zak_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yeesu akabharoreerera bhoosi eno akubha atiindiri, akiigwa ebhigoongi mukoro yaaye iguru yo obhukongʼu bhwe eziikoro zyaabhu. Niho Yeesu akamubhuurira omuutu wurya, “Gororokya okubhoko kwaazo.” Omuutu wurya akagororokya okubhoko kwaaye, rugeendo rumwe kukahora! ");
INSERT INTO zak_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Hayohayo Abhafarisayo bharya bhakahuruka igutu, bhakasikana no okwiibhuurya na bhano bhaagwaateeni na abhasakirya bho omutemi Herode. Bhakiibhuurya kyeego bharaamwiite Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yeesu akatanura hayo, akagya ku Nyaanza ya Gariraaya hamwe na abhaanabheega bhaaye. Esaango ekuru ya abhaatu ekamutuniirira, kwo okubha bhaari bhiigwiiri iguru ye ebhitiika bhino yaari akoriri. Abhaatu bhayo bhaari bharwiiri mumugye gwa Yerusaremu, mubhyaaro bhya Gariraaya, Yudea na Idumaaya, kumwaambuko gwe Ekitaaro kya Yorodaani na haguhi ne emigye gya Tiro na Sidooni. ");
INSERT INTO zak_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yeesu akabhabhuurira abhaanabheega bhaaye kubha, bhabhanure obhwaato, kwo okubha esaango yirya yaari kuru bhukongʼu, hano bharaamwiiruumbirire asikire mubhwaato. ");
INSERT INTO zak_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Abharweeri bhaari bharahigana okubha bhamugwaateku, kwo okubha yaari ahorirye bhaaru. ");
INSERT INTO zak_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Abhaatu bhano bhaari na amasaambwa amabhi hano bhamuruuzi, bhaari bharagwa mumaguru gaaye no okurira bhukongʼu kwe eriiraka ikuru bhakubhuga, “Awe ni Mwaana wa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Niho akagarekya amasaambwa kwo obhuhaari, gatamuraarika kubhaatu kubha ewe ni weewi. ");
INSERT INTO zak_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yeesu akatiira mukiguru. Akabhirikira abhaatu bhano yaari kweenda, bhakamugyaku. ");
INSERT INTO zak_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Akasora abhaatu ikumi na bhabhiri, neewe akabhatoga abheega, okubha bhabhe hamwe neewe, okubha abhe arabhatumania okurwaaza, ");
INSERT INTO zak_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na akabhaha obhuturo bhwo okuruusya amasaambwa amabhi kubhaatu. ");
INSERT INTO zak_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gano nigo amariina ga abheega ikumi na bhabhiri bhano yasoriri: Simooni, wuno Yeesu akamutoga eriina eriindi, Petero, ");
INSERT INTO zak_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yaakobo na Yohana nibho bhaari abhaana bha Zebedaayo, bhano Yeesu akabhatoga eriina rya Boanerige, obhugazuro bhwaku abhaana bho omurumo, ");
INSERT INTO zak_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andurea, Firipo, Baritoromaayo, Mataayo, Tomaso, Yaakobo omwaana wa Arifayo, Tadayo, Simooni Omuzeroote, ");
INSERT INTO zak_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuuda Isikariyoti, wuno yamuriiri omukoonyo Yeesu. Kyaamwe, Yeesu akakyoora yiika, akasikira munyuumba. ");
INSERT INTO zak_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Esaango ya abhaatu ekamwiikumanirya harya kweeki, tee Yeesu na abhaanabheega bhaaye bhakabhurwa naabhe omweeya gwo okurya ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hano nina waabhu Yeesu na bhawamwaabhu bhakiigwa amangʼana gayo, bhakagya okumugega, bhaari bharabhuga ayaangahiri. ");
INSERT INTO zak_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abheegya bhe emigiro gya Musa bhano bhaarweereeri mumugye gwa Yerusaremu, bhakabhuga, “Atiirirwe na Beerizeburi!” Kweeki bhaari bharabhuga, “Omuutu wuno araheebha amasaambwa amabhi kwo obhuturo bhwa Beerizeburi, omukaangati wa amasaambwa!” ");
INSERT INTO zak_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kyaamwe Yeesu akabhabhirikira, akataanga kubhabhuurira kwe ebhireengyo, “Seetaani aranagyabhwi okwiiheebha omweene? ");
INSERT INTO zak_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eraabhe abhaatu bho obhutemi bhumwe bhariitana abheene kwa abheene, obhutemi bhuyo bhurasika. ");
INSERT INTO zak_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kweeki, abhaatu bho omugye gumwe kasi enyuumba yimwe bhariitana, abhaatu bhayo bharatwaanikana na bhatakubha na amanaga naabhe hasuuhu. ");
INSERT INTO zak_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kweego eraabhe Seetaani ariitana na amasaambwa amarikyaaye, no obhutemi bhwaaye bhutwaanikeeni, bhutakunagya kwiimeerera naabhe hasuuhu, bhuriisuka obhuteero bhwaaye. ");
INSERT INTO zak_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nawe, obhuheene ni bhuno, omuutu atakunagya kusikira munyuumba yo omuutu wa amanaga, no okumuteesya ebhigiro bhyaaye, eno akyaari okumubhoha. Hano akumara kumubhoha bhuzomu, hayo niho aranagya okumuteesya ebhigiro bhino bhiri munyuumba yaaye. ");
INSERT INTO zak_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ndabhabhuurira obhuheene, abhaatu bharaabhirwa ebhibhi bhyaabhu bhyoosi, naabhe amangʼana amabhi go okwiituka. ");
INSERT INTO zak_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nawe, eraabhe omuutu aramutuka Ekoro Muhoreeru, atakwaabhirwa naabhe hasuuhu. Wuyo arabha ne eriisoro rye ebhibhi bhya kirakeego.” ");
INSERT INTO zak_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeesu akabhabhuurira ego, kwo okubha ebho bhaari bharabhuga, “Ane eriisaambwa eriibhi.” ");
INSERT INTO zak_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Niho nina waabhu Yeesu na bhawamwaabhu bhakahika, bhakiimeerera igutu we enyuumba yino yaari arimu. Bhakamuragania omuutu wumwe amubhirikire Yeesu yiize, bhagaambe neewe. ");
INSERT INTO zak_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Esaango ekuru ya abhaatu yaari yiikeeri, emwiiruguuriri. Niho bhakamubhuurira Yeesu, “Nina weenyu na bhawamweenyu bhari igutu, bharakweenda.” ");
INSERT INTO zak_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yeesu akabhakyoora, “Maayi na bhawamweetu ni bhaweewi?” ");
INSERT INTO zak_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Akabharora abhaatu bhano bhiikeeri bhamwiiruguuriri, akabhuga, “Murore, bhano nibho maayi na bhawamweetu! ");
INSERT INTO zak_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Omuutu wowoosi wuno akukora obhuseegi bhwa Taatabhugya, wuyo niwe maayi, mura weetu na musubhaati.” ");
INSERT INTO zak_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yeesu akataanga okweegya kweeki abhaatu, embarika we enyaanza. Esaango ekuru ya abhaatu ekamwiikumanira. Kweego, akatiira mubhwaato, akiikaramu okubha bhatamwiiruumbirira. Abhaatu bhakasaaga embarika we enyaanza. ");
INSERT INTO zak_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yaari arabheegya ameegyo maaru kwe ebhireengyo. Mumeegyo gaaye yaari arabhuga, ");
INSERT INTO zak_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yaariho omubhusuri wumwe wuno yagiiri mumuguundu gwaaye, okubhusura eziimbibho zyaaye. ");
INSERT INTO zak_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hano yaari akubhusura, eziimbibho eziindi zikagwa kunzira, ebhinyonyi bhikaaza, bhikazirya. ");
INSERT INTO zak_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Eziimbibho eziindi zikagwa kurukerege hano hataari na amarobha maaru. Eziimbibho ziyo zikamera bhwaangu, kwo okubha amarobha gaari masuuhwiigo. ");
INSERT INTO zak_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hano omubhaso gwabhariri, gukoomya amarobha garya, eziimbibho zikanyaara no okwooma, kwo okubha emiri gitaari mitaambi. ");
INSERT INTO zak_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eziimbibho eziindi zikagwa mumahwa. Hano amahwa gayo gaakiiniri, gakazihiga, zikatamwa kukongʼa. ");
INSERT INTO zak_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nawe, eziimbibho eziindi zikagwa mumarobha amazomu, zikamera, zikakiina no okwiibhura. Eziindi zikiibhura miroongo etatu (30), eziindi zikiibhura miroongo esaasabha (60), ne eziindi zikiibhura igana rimwe (100)!” ");
INSERT INTO zak_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kyaamwe Yeesu akabhabhuurira, “Wa amatwi, yiitegeerere kisi!” ");
INSERT INTO zak_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Hano abhaatu bhe esaango bhaatanwiiri, Yeesu akasaaga na abheega bhaaye ikumi na bhabhiri, na abhaanabheega abhaandi. Niho bhakamubhuurya iguru yo obhugazuro bhwe ebhireengyo bhyaaye. ");
INSERT INTO zak_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Akabhakyoora, “Emwe niimwe nikubhakuundukurira eziimbiso zyo obhutemi bhwa Taatabhugya. Nawe abhaatu bhano bhatakunituniirira, ndabhabhuurira goosi kwe ebhireengyo, ");
INSERT INTO zak_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kyeego omurooti Isaya yakaamiri, ‘Okurora bharore, bhatamenya ryoryoosi. Okwiigwa bhiigwe amangʼana gaane, bhatamenyeekererya ryoryoosi. Eraabhe itiingabheeri ego, bhaangiikyooriri bhate ebhibhi bhyaabhu, nibhaabhire.’ ” ");
INSERT INTO zak_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Niho Yeesu akabhuga, “Bhoono, mutamirwe okumenyeekererya ekireengyo kino, erabhabhwi kubhiindi? ");
INSERT INTO zak_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Omubhusuri ni muutu wuno akubharaarikira abhaandi engʼana ya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abhaatu abhaandi bharatuubhana na amarobha ga kunzira. Hano bhakwiigwa ego engʼana ya Taatabhugya, Seetaani araaza, no okuruusyaho engʼana yirya muziikoro zyaabhu. ");
INSERT INTO zak_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abhaandi bharatuubhana na amarobha ga kurukerege hano hatana amarobha maaru. Hano bhakwiigwa engʼana ya Taatabhugya, hayohayo bharayiikirirya bhwaangu kwo obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nawe, bharagwaata amangʼana gayo kwiibhaga iguhi ego, gataari muusi waabhu bhukongʼu kyeego ebhituutu bhino bhitana emiri. Hano eziinyaako kasi amakongʼu garaabhabhone kwiiguru wa amangʼana, rugeendo rumwe bharatiga obhwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abhaandi bharatuubhana na amarobha ga mumahwa. Bhariigwa engʼana ya Taatabhugya, ");
INSERT INTO zak_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nawe bharangʼeenwa na amiiseego iguru yo obhwiikari bhuno ne enaamba yo obhuniibhi no okwiigoomba kukomya ebhigiro ebhizomu ebhiindi. Kweego, engʼana yiyo erahigwa no okutama kwiibhura emisumo. ");
INSERT INTO zak_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Na abhaandi bharatuubhana na amarobha amazomu. Bhano bhakwiigwa engʼana ya Taatabhugya no okuyiisuungʼaana no okwiibhura emisumo, owumwe miroongo etatu (30), owuundi miroongo esaasabha (60) no owuundi igana rimwe (100).” ");
INSERT INTO zak_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yeesu akabhabhuurira, “Mbe, ariho omuutu wuno akwaakya etara no okuyikuundikirya mwiiruungu, kasi arayikuundikirya museengo? Atakuyituura iguru mukikuumbo ebhe eramurika hoosi? ");
INSERT INTO zak_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ego niigo ryoryoosi rino ribhisirwe, rirarorekana no okubha kubhweero. Kweeki, ryoryoosi rino rikuundikiirwe, rirakuundukurwa. ");
INSERT INTO zak_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wa amatwi, yiitegeerere kisi!” ");
INSERT INTO zak_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Niho Yeesu akageenderera kubhabhuurira, “Mwiitegeerere bhuzomu! Ekireengo kino mukureengera abhaandi, nikyo kino Taatabhugya araabhareengere emwe no okwoongeribhwa. ");
INSERT INTO zak_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wowoosi wuno akwiikirirya amangʼana ga Taatabhugya no okugamenya, Taatabhugya aramusakirya no okumwoongerya okugamenya. Nawe wowoosi wuno atakwiikirirya gayo, Taatabhugya aramuteesya naabhe ekisuuhu kino anakyo.” ");
INSERT INTO zak_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kweeki Yeesu akoongera kubhuga, “Nibhabhuurire ekireengyo ekiindi, okubha nibheegye obhutemi bhwa Taatabhugya kyeego bhuri. Omuutu owumwe akeemya eziimbibho mumuguundu. ");
INSERT INTO zak_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Obhutiku arahiindira no omwiisi arabhuuka, eriibhaga riyo, eziimbibho zirya zirabha ziramera no okukura, neewe omurimi atamenyiri kyeego zikukiina. ");
INSERT INTO zak_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Amarobha garakiinia eziimbibho zirya no okwiibhura. Hiinga ziramera eriitu, zirataanga kusibhuka, mubhuteero ziraruusya ebhigara bhino bhine eziimbibho. ");
INSERT INTO zak_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Emisumo giyo hano gikukongʼa, hayo niho omurimi akugesa.” ");
INSERT INTO zak_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yeesu akoongerya kubhabhuurira, “Angu, tubhutuubhanie obhutemi bhwa Taatabhugya naki? Tubhutuubhanie ne ekireengyo kiihe? ");
INSERT INTO zak_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bhutuubheeni kya akatetere ke eharadaari, niyo etetere esuuhu kukira eziitetere zyoosi zino zikweemibhwa mumuguundu. ");
INSERT INTO zak_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hano ekumera, erabha omuti mukuru kukira ebhituutu bhyoosi bhye eziinyenyi mumuguundu. Gurabha na amasagya amakuru ne ebhinyonyi bhikuuza no okwiikara iyaasi we ekizuruuru kya mumasagya gaaku.” ");
INSERT INTO zak_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yeesu akarwaaza amangʼana ga Taatabhugya kwe ebhireengyo bhyaaru, akabhabhuurira kyeego bhakanagya okurimenyeekererya. ");
INSERT INTO zak_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yaari aragaamba nabho kwe ebhireengyo ego. Nawe, hano yaari omweene na abhaanabheega bhaaye, akabheerekeererya goosi. ");
INSERT INTO zak_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Orusiku ruyo engoroobha, Yeesu akabhabhuurira abhaanabheega bhaaye akabhaswaagya, “Twaambuke enyaanza.” ");
INSERT INTO zak_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bhakatiga esaango ya abhaatu, bhakasikira mubhwaato muno Yeesu yaari, bhakatanura hamwe. Haari na amaato agaandi gano bhakakaangatania nago. ");
INSERT INTO zak_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Niho obhukama bhuhaari bhukongʼu bhukataanga okuhuumbuuta munyaanza. Amabhooka gaari garatema obhwaato, amaanzi gakataanga kusikira mubhwaato bhukeenda kwiizura. ");
INSERT INTO zak_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eriibhaga riyo, Yeesu yaari ahiindiiri eziitiro inyuma mubhwaato, yiisagwiiri omusago. Abhaanabheega bhaaye bhakamubhuukya, bhakamubhuurira, “Omweegya, otakumura kubha turasika?” ");
INSERT INTO zak_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Niho, Yeesu akiimeerera no okurekya obhukama na amabhooka, akabhuurira enyaanza, “Okire kiri! Horeera!” Obhukama bhurya bhukatiga okuhuumbuuta, hakahoreera. ");
INSERT INTO zak_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kyaamwe, Yeesu akabhabhuurya abhaanabheega bhaaye, “Kwaki muroobhoha? Naabhe bhoono mukyaari kubha no obhwiikirirya?” ");
INSERT INTO zak_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ebho bhakoobhoha bhukongʼu, bhakataanga okwiibhuurya, “Ni weewi wuno, naabhe obhukama na amabhooka bhiramwiigwa?” ");
INSERT INTO zak_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeesu na abhaanabheega bhaaye, bhakahika kumwaambuko gwe Enyaanza ya Gariraaya, mukyaaro kya Abhagerasi. ");
INSERT INTO zak_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hano Yeesu yiikiri mubhwaato, omuutu wuno yaari atiirirwe amasaambwa amabhi yarwiiri mumabhigi ge eziimbiihira, akagya ku Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Omuutu wuyo ahiikara muziimbiihira. Yaari ne eziinguru, ataari ariho wowoosi wuno akanagya kumubhoha naabhe kwe eminyororo. ");
INSERT INTO zak_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bhaari bhamubhohiri kaaru ne eminyororo kumaguru ne ebhiraangʼani kumabhoko, nawe akatina bhyoosi. Ataari ariho omuutu wuno akunagya kumuhiza. ");
INSERT INTO zak_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Eriibhaga ryoosi obhutiku no omwiisi yaari kuziimbiihira na mubhiguru, aratema ekituri no okwiikebhakebha kwa amagina. ");
INSERT INTO zak_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hano omuutu wuyo yamuruuzi Yeesu kwa kure, akamuryaarira, akamuhigamira. ");
INSERT INTO zak_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Akatema ekituri kwiiraka ikuru akabhuga, “Awe Yeesu Omwaana wa Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi, ona ngʼanaki neenye? Ndakwiisasaama kwe eriina rya Taatabhugya kubha otaninyaakya!” ");
INSERT INTO zak_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yeesu akamurora omuutu wurya, akaribhuurira, “Awe eriisaambwa eriibhi, noorwe kumuutu wuno!” ");
INSERT INTO zak_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yeesu akaribhuurya, “Eriina ryaazo ni weewi?” Rikamukyoora, “Eriina ryaane ni Ihizo, kwo okubha etwe ni bhaaru kumuutu wuno.” ");
INSERT INTO zak_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eriisaambwa rirya rikamwiisasaama kaaru kubha, atagaheebha ahagiro hayo. ");
INSERT INTO zak_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kwaari ne eriihizo ikuru rye eziimbiizi, rino ryaari rikuriisya embarika we ekiguru. ");
INSERT INTO zak_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Niho amasaambwa gayo gakamwiisasaama Yeesu, “Otwiikirirye, tusikire muziimbiizi zirya.” ");
INSERT INTO zak_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yeesu akagiikirirya. Ambe, amasaambwa gayo gakamurwaku omuutu wurya, gakazisikira eziimbiizi. Hayohayo, eriihizo ryoosi rikahiriingita kwa bhwaangu kumuhiriingito muhaari, rikasikira munyaanza no okukwa. Eziimbiizi ziyo zyaari zirahika bhikwe bhibhiri (2,000). ");
INSERT INTO zak_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abhariisya bhe eziimbiizi zirya bhakaryaara, bhakaraarika amangʼana gayo mwiiboma na mumigye gya haguhi. Abhaatu bhakaaza, okubha bhiirorere abheene gano gaatuukiri. ");
INSERT INTO zak_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hano bhaahikiri ku Yeesu, bhakamurora omuutu wuno yaari atiirirwe ne eriihizo rya amasaambwa amabhi yiikeeri, yiibhohiri emyeenda, na ana amangʼeeni goosi, wuno akabhirikirwa Ihizo, kyaamwe bhakoobhoha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bhano bhaaruuzi gano gaamubhweeni wuno yaari atiirirwe na amasaambwa amabhi wurya ne eziimbiizi, bhakabha bharabhabhuurira abhaatu abhaandi amangʼana gayo. ");
INSERT INTO zak_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Niho abhaatu bhayo bhakataanga okumwiisasaama Yeesu arwe mukyaaro kyaabhu. ");
INSERT INTO zak_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Hano Yeesu yasikiiri mubhwaato, omuutu wuno yaari atiirirwe na amasaambwa akamwiisasaama Yeesu kubha, amwiikirirye agye hamwe neewe. ");
INSERT INTO zak_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nawe, Yeesu ataamwiikiriirye, akamubhuurira, “Noogye yiika weenyu, obhabhuurire amangʼana amakuru gano Omukuru akukoreeri na kyeego akuroreeri ebhigoongi.” ");
INSERT INTO zak_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kyaamwe, omuutu wurya akatanura, akataanga okunyaragania mu Dekapoori, amangʼana amakuru gano Yeesu amukoreeri. Abhaatu bhoosi bhakaruguura. ");
INSERT INTO zak_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yeesu na abhaanabheega bhaaye bhakaambuka enyaanza no obhwaato okukyoora kumwaambuko. Hano bhaahikiri, esaango ekuru ya abhaatu ekamwiikumanira embarika we enyaanza. ");
INSERT INTO zak_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Hayo akaaza omukaangati wumwe we enyuumba ye esaango, eriina ryaaye Yairo. Hano yamuruuzi Yeesu, akamugyaku, akamuhigamira embere waaye. ");
INSERT INTO zak_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Akamukumiirirya akubhuga, “Omuukya waane ni murweeri, ari haguhi kukwa. Ndasabha tugye, omutuurire amabhoko gaazo kumubhiri gwaaye, okubha ahore.” ");
INSERT INTO zak_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yeesu akagya nawe. Esaango yirya ekuru yaari ekumutuniirira, emwiiruguuriri bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Musaango yirya, yaarimu omukari wuno yaari no obhurweeri bhwo obhureegu kwe emyaaka ikumi ne ebhiri. ");
INSERT INTO zak_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Omukari wuyo, yaari anyaakiri bhukongʼu kugya kubhagabhu bhaaru. Akamara ebhigiro bhyaaye bhyoosi akabha arahira kubhagabhu, nawe obhurweeri bhwaaye bhutaasuuhiri, nawe bhukaaruha. ");
INSERT INTO zak_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Hano omukari wuyo yiigwiiri gano Yeesu akoriri, akiigaambira, “Ndaakunieku omweenda gwaaye ego, ndahora.” Niho akahita musaango ya abhaatu kwiinyuma, akakuniaku omweenda gwa Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hayohayo amanyiinga gakatinika, akiiyiigwa mumubhiri kubha ahoriri. ");
INSERT INTO zak_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Rugeendo rumwe, Yeesu akamenya kubha amanaga gaaye gakoriri emirimo. Akiikibhuka, akabhabhuurya abhaatu bhe esaango, “Ni weewi wuno akunirye omweenda gwaane?” ");
INSERT INTO zak_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abhaanabheega bhaaye bhakamubhuurira, “Orarora abhaatu bhaaru bhakwiisaanga owaazo! Ndora orabhuurya, ‘Ni weewi wuno anikuniryeku?’ ” ");
INSERT INTO zak_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nawe akarora eno ne eno, okubha amurore wuno akamukuniaku. ");
INSERT INTO zak_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Niho omukari wurya akoobhoha, akaaza no okamuhigamira embere waaye, eno ararigita, kwo okubha akamenya gano gakorirwe kweewe. Akamubhuurira obhuheene bhwoosi. ");
INSERT INTO zak_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yeesu akamubhuurira, “Muukya waane, obhwiikirirya bhwaazo bhukuhonirye! Ogye no omureembe, bhoono ohoniibhwe.” ");
INSERT INTO zak_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hano Yeesu yaari akyaakeerenia no omukari wuyo, abhaatu bhakaaza okurwa mumugye gwa Yairo, omukaangati we enyuumba ye esaango, bhakabhuga, “Yairo, omuukya waazo amariri kukwa. Kwaki orageenderera kumunyaakya omweegya?” ");
INSERT INTO zak_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nawe hano Yeesu yiigwiiri amangʼana gaabhu, akamubhuurira Yairo, “Otoobhoha, obhe no obhwiikirirya.” ");
INSERT INTO zak_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yeesu akabharekya abhaatu abhaandi bhoosi kubha bhatakaangatania neewe. Akagya na Petero, Yaakobo na Yohana wamwaabhu Yaakobo. ");
INSERT INTO zak_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hano bhaahikiri munyuumba ya Yairo, Yeesu akabhona abhaatu bhararira no okwaaramira. ");
INSERT INTO zak_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Akasikira munyuumba, akabhuga, “Ndora murarira no okutema ekituri? Omuukya wuno akyaari kukwa, nawe ahiindiiri.” ");
INSERT INTO zak_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Abhaatu bhakamuseka kwo okurega, niho Yeesu akabhahurukya bhoosi igutu. Nawe akamugega wiise no omuukya hamwe na nina waabhu na abhaanabheega bhaaye bhatatu bhano akaaza nabho, bhakasikira mukyuumba kino bhaari bhamuhiindiirye omuukya wuyo. ");
INSERT INTO zak_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akamugwaata omuukya wuyo kwo okubhoko, akamubhuurira, “Tarita, koomu!” obhugazuro bhwaku, “Muukya, bhuuka!” ");
INSERT INTO zak_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hayohayo, omuukya wuyo akiimeerera, akataanga kugeenda. Ewe yaari ne emyaaka ikumi ne ebhiri. Bhano bhaari hamwe na Yeesu bhakaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeesu akabharekya bhatabhuurira muutu wuyo woosi gano gaatuukiri. Kyaamwe, akabhabhuurira abhiibhuri bho omuukya wuyo bhamuhe ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Niho Yeesu akatanura eyo, akakyoora owaabhu mumugye gwa Nazareeti hamwe na abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hano orusiku rwo okumuunya rwaahikiri, akataanga okweegya munyuumba ye esaango. Abhaatu bhaaru bhano bhamwiigwiiri, bhakaruguura. Bhaari bhariibhuurya, “Omuutu wuno abhweeni hayi gano goosi? Abhweeni hayi amangʼeeni gano? Kweeki arakora ebhitiika bhino kwa amabhoko gaaye! ");
INSERT INTO zak_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wuno atari wurya omubhaazi, omwaana wa Mariamu, bhawamwaabhu Yaakobo, Yose, Yuuda na Simooni? Mbe, abhasubhaati bhaaye tunabho oweetu hano?” Bhakamuzeera no okwaanga okumwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeesu akabhabhuurira, “Abhaatu bharasuuka omurooti hohoosi harya, nawe bhatakumusuuka muroobho yaaye, kubhahiiri bhaaye na munyuumba yaaye.” ");
INSERT INTO zak_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kweego, Yeesu ataanagirye kukora ebhitiika bhyaaru eyo, nawe akabhatuurira amabhoko abharweeri bhasuuhu no okubhahorya. ");
INSERT INTO zak_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Akaruguura bhukongʼu kwo okubha abhaatu bhayo bhataamwiikiriirye. Kyaamwe Yeesu akiiruguura mumigye gya haguhi okubheegya abhaatu. ");
INSERT INTO zak_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akabhabhirikira hamwe abhaanabheega bhaaye ikumi na bhabhiri. Akabhaha obhunagya bhwo okuheebha amasaambwa amabhi okurwa kubhaatu, akabharagania bhabhiri bhabhiri. ");
INSERT INTO zak_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Akabhaswaagya, “Mutagega kigiro kyokyoosi kwiiguru yo orugeendo rweenyu nawe eziihiimbo mumabhoko. Mutagega esakwa, naabhe omukaate, naabhe eziimbirya, ");
INSERT INTO zak_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","naabhe emyeenda ebhiri. Mwiibhohe ebhikweera ebhyeene.” ");
INSERT INTO zak_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kweeki, akabhabhuurira, “Munyuumba yoyoosi yino bhakubhasuungʼaana, mwiikare muyomuyo, tee hano muraatanure mumugye guyo. ");
INSERT INTO zak_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kweeki, hohoosi hano bhatakubhasuungʼaana kasi okubhiitegeerera, hano muraatanure, mwiikungʼuute oruteeri kumaguru geenyu, okukora ego ebhe obhweerekeereryo bhwo obhubhi bhwaabhu.” ");
INSERT INTO zak_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Abhaanabheega bharya bhakatanura, bhakataanga okubharwaazira abhaatu kubha bhate ebhibhi bhyaabhu. ");
INSERT INTO zak_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhaari bhararuusya amasaambwa amabhi maaru no okuhorya abharweeri bhaaru kwo okubhahaka amaguta. ");
INSERT INTO zak_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Omutemi Herode we ekyaaro kiyo, akiigwa amangʼana ga Yeesu, kwo okubha yaari amenyekeeni hoosi. Abhaandi bhaari bharabhuga, “Ni Yohana Omubatiizi aryookiri mubhaku, nikyo ekigirye ano obhunagya bhwo okukora ebhitiika.” ");
INSERT INTO zak_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abhaandi bhaari bharabhuga, “Yeesu ni Eriya.” Abhaandi bhaari bharabhuga, “Ewe ni murooti wa Taatabhugya kyeego abharooti abhaandi bhe ekare.” ");
INSERT INTO zak_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Eriibhaga Herode akiigwa amangʼana gano, akabhuga, “Wuno ni Yohana, wuno niamutiniri omutwe. Aryookiri mubhaku!” ");
INSERT INTO zak_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herode yaari amusikiirye Herodia omukari wa Firipo. Na Firipo ewe yaari wamwaabhu omusuuhu Herode. Niho Yohana akamubhuurira, “Ni mugiro okukweera omukari wo omusuuhu waazo akyaari kukwa.” Amangʼana gayo gakagirya Herodia akamutiindira Yohana, no okumoohya enzira yo okumwiita, nawe akatamwa. Ambe kwo okumuzomeerya Herodia, Herode akaswaagya abhasirikare bhamugwaate Yohana no okumubhoha munyuumba ya abhabhohwa. Nawe yaari aramuriiha, okubha Herodia ataaza okumwiita, kwe ekigirirye akamwoobhoha Yohana no okumenya kubha, Yohana ni we eheene no omuhoreeru. Herode araseega okumwiitegeerera Yohana bhukongʼu, naabhe hano akamwiitegeerera, akiitiimaata bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Orusiku rumwe, Herodia akabhona enzira yo okumwiita Yohana. Orusiku rwe enyaangi yo okwiibhurwa kwaaye, Herode akabhaginihya abhakaangati abhakuru, abhakuru bha abhasirikare, na abhakaangati bho omugye gwa Gariraaya. ");
INSERT INTO zak_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hano abhagini bhiikeeri, omuukya wa Herodia akasikira, akabhina. Herode na abhagini bhaaye bhakazomererwa. Omutemi akamubhuurira omuukya wuyo, “Nisabhe kyokyoosi kino okweenda, nikuhe.” ");
INSERT INTO zak_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Akiirahira, “Ndakuha kyokyoosi kino okweenda, naabhe hagiro ho obhutemi bhwaane.” ");
INSERT INTO zak_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Niho omuukya wurya akahuruka igutu, akabhuurya nina waabhu, “Maayi, nisabheki?” Nina waabhu akamukyoora, “Musabhe akuhe omutwe gwa Yohana Omubatiizi.” ");
INSERT INTO zak_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ambe omuukya wurya akakyoora bhwaangu kumutemi, akamubhuurira, “Ndeenda onihe hano omutwe gwa Yohana Omubatiizi kuruhuungo.” ");
INSERT INTO zak_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Omutemi akiitiimaata bhukongʼu, nawe kwe ekigirirye yaari yiirahiiri embere ya abhagini bhaaye, ateendiri okumwaangira. ");
INSERT INTO zak_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Akamutuma omusirikare agye kumutina Yohana omutwe. Omusirikare akagya munyuumba ya abhabhohwa, akamutina Yohana omutwe. ");
INSERT INTO zak_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kyaamwe akakyoora no omutwe gwa Yohana kuruhuungo, akamuha omuukya wuyo, neewe akamuhirira nina waabhu. ");
INSERT INTO zak_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hano abhaanabheega bha Yohana bhiigwiiri gayo, bhakagya, bhakagega ekituundu kyaaye, bhakakibhiika mumbiihira. ");
INSERT INTO zak_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Hano abheega bha Yeesu bhaakyooriri, bhakiikumania, bhakamubhuurira goosi gano bhaakoriri no okweegya abhaatu. ");
INSERT INTO zak_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kwo okubha abhaatu bhaari bhaaru bhukongʼu, abhaandi bharaaza, na abhaandi bharatanura, Yeesu na abhaanabheega bhaaye bhataanagirye kurya. Akabhabhuurira abhaanabheega bhaaye, “Muuze, tugye kibhezo, tumuunye hasuuhu.” ");
INSERT INTO zak_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bhakatanura abheene kwo obhwaato, bhakagya kibhezo. ");
INSERT INTO zak_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nawe hano bhaatanwiiri abhaatu bhaaru bhakabharora, bhakamenyeekererya. Abhaatu bharya, hamwe na abhaandi okurwa emigye myaaru, bhakabharyaarira kwa amaguru, bhakabhakaangatira kuhika eno bhaari bhakugya. ");
INSERT INTO zak_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Hano Yeesu yiikiri mubhwaato, akarora esaango ekuru ya abhaatu. Akabharorera ebhigoongi, kwo okubha bhaari kye eziingʼoondu zino zitana omuriisya. Akataanga okubheegya amangʼana maaru. ");
INSERT INTO zak_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hano kwabheeri engoroobha, abhaanabheega bhaaye bhakamugyaku, bhakamubhuurira, “Hano turi mwiitirigo no obhutiku bhuhikiri. ");
INSERT INTO zak_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ambe obharage abhaatu bhano, bhatanure, bhagye mumigye gino giri haguhi, okubha bhiigurire ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nawe, Yeesu akabhakyoora, “Emwe mubhahe ebhyaakurya.” Bhakamubhuurya, “Tuungeendirwe okugura emikaate kwa abhaatu bhayo naabhe tuungabheeri ne eziidinaari amagana abhiri (200)! Mbe, etwe tugeende kukora ego?” ");
INSERT INTO zak_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeesu akabhabhuurya, “Mbe, mune emikaate eriinge? Mugeende murore.” Bhakagya kurora, bhakakyoora, bhakamubhuurira, “Tune emikaate etaano ne eziiswe ibhiri.” ");
INSERT INTO zak_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yeesu akabhabhuurira, bhabhiikarye abhaatu bhoosi amagari kumagari mubhunyaaki. ");
INSERT INTO zak_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bhakiikara amagari, abhaandi igana igana (100), abhaandi miroongo etaano (50). ");
INSERT INTO zak_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yeesu akagega emikaate etaano ne eziiswe ibhiri, akaroreerera mwiisaaro, akabhuga, “Ozomirye, Taatabhugya.” Akagibhega emikaate girya, akabhaha abhaanabheega bhaaye, bhabhatwaanire abhaatu. Akabhatwaania bhoosi eziiswe ibhiri zirya. ");
INSERT INTO zak_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhoosi bhakarya, bhakiiguta. ");
INSERT INTO zak_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abhaanabheega bhaaye bhakakumania amasaagyo ge emikaate ne eziiswe, bhakiizurya ebhikapu ikumi na bhibhiri. ");
INSERT INTO zak_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bhano bhaariiri ebhyaakurya bhirya bhaari bhaaru, abhasubhe abheene bhaari bhikwe bhitaano (5,000). ");
INSERT INTO zak_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Niho Yeesu akaswaagya abhaanabheega bhaaye bhasikire mubhwaato, bhakaangate bhagye omwaambuko gwe enyaanza, kugya mumugye gwa Betisaida, eriibhaga ewe yaari akyabharaga esaango ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hano yatigeeni nabho, akatiira mukiguru kugya kusabha. ");
INSERT INTO zak_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hano ekiirima kyasikiiri, abhaanabheega bhaari mubhwaato gatigati we enyaanza, na Yeesu yaari omweene ego hagiro ahoomu. ");
INSERT INTO zak_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Akabharora kyeego bhakunyaaka bhukongʼu okutema engahi, kwo okubha obhukama bhwaari bhurabhuhuna eno bhaari kweerekera. Ambe hano kwahikiri amakya, akagya arageenda iguru wa amaanzi, akeenda kubhahita. ");
INSERT INTO zak_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Nawe, hano bhamuruuzi arageenda iguru wa amaanzi, bhakiiseega ni musaambwa, bhakoobhoha bhukongʼu, bhakakora ekituri. Yeesu akagaamba nabho, “Muteme ekubhi, mutoobhoha! Neenye.” ");
INSERT INTO zak_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yeesu akatiira mubhwaato bhwaabhu, obhukama bhukahoreera. Bhakaruguura bhukongʼu, ");
INSERT INTO zak_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwo okubha bhataamenyiri naabhe ekitiika kye emikaate. Eziikoro zyaabhu zyaari kongʼu. ");
INSERT INTO zak_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hano Yeesu na abhaanabheega bhaaye bhaambukiri enyaanza, bhakahika ekyaaro kya Genesareeti. Bhakiimeererya obhwaato kumwaambuko. ");
INSERT INTO zak_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hano bhiikiri mubhwaato, abhaatu bha harya bhakamumenya Yeesu bhwaangu, ");
INSERT INTO zak_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bhakanyaragana mukyaaro kirya kyoosi, na bhakabha bharagega abharweeri kubhirago kugya hohoosi hano bhakwiigwa Yeesu ariho. ");
INSERT INTO zak_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hohoosi hano yagiiri, ebhe mumigye, mwiiboma kasi mukyaaro kyokyoosi, bhaari bharamureetera abharweeri kurukuungu. Bhakamusabha kubha bhamugwaateku naabhe omuriingo gwo omweenda gwaaye. Bhoosi bhano bhaakuniryeku naabhe omuriingo gwo omweenda gwaaye, bhakahora amarweeri gaabhu. ");
INSERT INTO zak_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Orusiku rumwe, Abhafarisayo bharebhe na abheegya bhe emigiro gya Musa bhakarweera Yerusaremu, bhakaaza bhakiikumania ku Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bhakabharora abhaanabheega abhamwe bha Yeesu bhaari bhararya ebhyaakurya bhakyaari kwiisaabha amabhoko kyeego yaari ekweenderwa muziinyaangi zyaabhu. ");
INSERT INTO zak_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Abhafarisayo na Abhayahudi bhoosi bhataari bhararya bhakyaari kwiisaabha tee kuzikokora, okuhiita eziisiira zya bhazaazi bhaabhu kyeego zyaari. ");
INSERT INTO zak_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hano bhaarweereeri mumuteera, bhariisaabha hiinga amabhoko kyeego ekweenderwa, niho bhakurya. Kweeki, bharahiita eziisiira zyaabhu eziindi nzaru, kyeego bhahoogya ebhikoombe, ebhihurira ne ebhigiro. ");
INSERT INTO zak_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Niho Abhafarisayo na abheegya bhe emigiro gya Musa bhakamubhuurya Yeesu, “Kwaki abhaanabheega bhaazo bhatakutuniirira eziisiira zya bhazaazi bheetu, nawe bhararya bhanyakahiri bhakyaari okwiisaabha amabhoko kyeego ekweenderwa?” ");
INSERT INTO zak_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yeesu akabhakyoora, “Emwe abhabheehi! Taatabhugya akagaamba obhuheene iguru weenyu okuhitira omurooti waaye Isaya, ‘Abhaatu bhano bharanisuuka kwa amangʼana ego, nawe eziikoro zyaabhu ziri kure neenye. ");
INSERT INTO zak_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bharaniseengera bhusa, kwo okubha bhareegya obhuswaagyo bhwa abhaatu kyamuna ni bhwa Taatabhugya.’  ” ");
INSERT INTO zak_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeesu akageenderera kubhabhuurira, “Emwe muratiga obhuswaagyo bhwa Taatabhugya, muratuniirira eziinyaangi zya abhaatu. ");
INSERT INTO zak_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Mune eziinzira nzomu zyo okwaanga obhuswaagyo bhwa Taatabhugya, okubha mubhone okutuna eziisiira zyeenyu! ");
INSERT INTO zak_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwe ekireengyo, Taatabhugya akaswaagya kuhitira ku Musa kubha, ‘Obhasuuke wuuso na nyoko weenyu.’ Kweeki, akabhuga, ‘Omuutu wowoosi wuno akumutuka wiise kasi nyoko waabhu, areenderwa yiitwe.’ ");
INSERT INTO zak_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nawe emwe mureegya, eraabhe omuutu arabhuurira abhiibhuri bhaaye, ‘Ebhigiro bhino niinganagirye okukusakirya, bhibheeri Koribani,’ obhugazuro bhwaku ni saambo yo okumuruusirya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Okweegya kweenyu kuyo, kuragirya atasakirya abhiibhuri bhaaye kigiro. ");
INSERT INTO zak_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kweego, muraazeere engʼana ya Taatabhugya, okubha munagye okuhiita eziisiira zyeenyu abheene. Na murakora maaru gano garatuubhana na gano.” ");
INSERT INTO zak_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yeesu akabhirikira esaango ya abhaatu, akabhabhuurira, “Emwe mwoosi muniitegeerere, na mumenye amangʼana gano nikubhabhuurira! ");
INSERT INTO zak_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kitariho kigiro kino kikumusikira omuutu no okugirya kimukwaarihye. Nawe, gano gakurwa mukoro yo omuutu nigo gakukora omuutu akwaarihwe.  ");
INSERT INTO zak_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wa amatwi, yiitegeerere kisi.” ");
INSERT INTO zak_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hano yatigiri esaango ya abhaatu no okusikira munyuumba, abhaanabheega bhaaye bhakamubhuurya iguru ye ekireengyo kiyo. ");
INSERT INTO zak_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Akabhabhuurira, “Naabhe emwe mutana amangʼeeni go okumenya ekireengyo kirya? Mutamenyiri kubha ekigiro kino kikumusikira omuutu kitakunagya okugirya kimukwaarihye? ");
INSERT INTO zak_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ebhyaakurya bhitakusikira mukoro, nawe bhirasikira muunda no okurwa mumubhiri.” Kwo okugaamba ego, Yeesu akeerekya kubha, ebhyaakurya bhyoosi bhiikiririibhwe okurya. ");
INSERT INTO zak_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Akageenderera okugaamba, “Gano gakurwa mukoro yo omuutu, nigo gakugirya omuutu kubha makire. ");
INSERT INTO zak_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mukoro yo omuutu, nimwe gakurwa amiiseego mabhiihu, obhutuungiri, ");
INSERT INTO zak_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","obhwiibhi, obhwiiti, obhuseebheeti, enaamba ye ebhigiro, obhubhi, obhungʼeenererya, amangʼana ge eziisoni, omugono, amatuki, ekisiraani no obhugeege. ");
INSERT INTO zak_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amabhi goosi gano gakurwa mukoro yo omuutu nigo gakugirya abhe makire.” ");
INSERT INTO zak_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yeesu na abhaanabheega bhaaye bhakatanura Gariraaya, bhakagya emigye gya Tiro na Sidooni. Akiikara munyuumba ngʼania, ateendiri omuutu wowoosi amenye ari hayo. Nawe abhaatu bhakamenyeekererya ari hayo. ");
INSERT INTO zak_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Eyo, yaari ariyo omukari wumwe wuno ataari Omuyahudi, nawe yaari Omufoinike. Yaarweereeri Foinike mukyaaro kya Siria. Omuukya waaye yaari ne eriisaambwa eriibhi. Hano omukari wuyo yiigwiiri kubha Yeesu ari haguhi, akaaza ku Yeesu, akahigama embere waaye. Akamusabha amuruusye omwaana waaye eriisaambwa. ");
INSERT INTO zak_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yeesu akamubhuurira, “Etari bhuzomu kugega ebhyaakurya bhya abhaana no okuzirekerera eziimbwa.” ");
INSERT INTO zak_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nawe omukari wurya akamukyoora, “Omukuru, amangʼana gaazo ni ge eheene. Nawe, abhaana hano bhakurya, naabhe eziimbwa nazyo zirarya amasaagyo gano gakutoondobhoka haasi okurwa kwiigari.” ");
INSERT INTO zak_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeesu akamukyoora, “Hayo ogaambiri bhuzomu. Ambe, noogye, eriisaambwa rimurwiiriku omuukya waazo.” ");
INSERT INTO zak_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Omukari wurya akakyoora yiika waaye, akabhona omwaana ahoriri, amuunyiri kubhuriri, ne eriisaambwa rimurwiiriku. ");
INSERT INTO zak_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Niho Yeesu akatanura na abhaanabheega bhaaye Tiro, akahita Sidooni, akakyoora ku Nyaanza ya Gariraaya, mukyaaro kya Dekapoori. ");
INSERT INTO zak_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eyo yaari ariyo omuutu wumwe, wuno yaari omuribhi wa amatwi ne eriimuumu. Abhaatu bharebhe bhakamureeta ku Yeesu, bhakamusabha Yeesu amutuurire amabhoko, amuhorye. ");
INSERT INTO zak_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeesu akamuruusya musaango ya abhaatu, akagya nawe omweene kibhezo. Akatuura ebhyaara bhyaaye mumatwi go omuutu wurya. Akakitweera ekyaara kyaaye amate, akamuhaka kururimi. ");
INSERT INTO zak_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Akarora kwiisaaro, akiikya omwiika, akamubhuurira, “Efata,” obhugazuro bhwaku, “Iguka.” ");
INSERT INTO zak_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hayohayo, omuutu wurya akaribhuka amatwi no orurimi, akataanga okwiigwa no okugaamba bhuzomu. ");
INSERT INTO zak_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeesu akakumiirirya esaango ya abhaatu, bhatamubhuurira muutu wowoosi gano akoriri. Nawe kyeego akageenderera kubharekya, niigo bhakaraarika amangʼana gayo bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bhakaruguura bhukongʼu, bhakabhuga, “Goosi gano akoriri ni mazomu. Arahorya abharibhi bha amatwi, bhiigwe, na amamuumu, gagaambe!” ");
INSERT INTO zak_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kwe eriibhaga riyo, esaango eyiindi ekuru ya abhaatu ekiikumania, kweeki etaari ne ebhyaakurya. Niho Yeesu akabhabhirikira abhaanabheega bhaaye, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndabharorera ebhigoongi abhaatu bhano, twiikeeri nabho eziisiku isatu na bhoono bhatana ebhyaakurya bhyobhyoosi. ");
INSERT INTO zak_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eraabhe niribhuga nibhatige bhagye owaabhu ne enzara, bharatura kuseezeka munzira, na abhaandi bharekiri kure.” ");
INSERT INTO zak_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abhaanabheega bhaaye bhakamukyoora, “Mwiitirigo hano, atariho omuutu wuno akunagya kubhona ebhyaakurya bhyo okwiisa abhaatu bhoosi bhano.” ");
INSERT INTO zak_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeesu akabhabhuurya, “Mune emikaate eriinge?” Bhakamukyoora, “Tunagyo muhuungati.” ");
INSERT INTO zak_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ambe, Yeesu akaswaagya abhaatu bhoosi bhiikare haasi. Akagega emikaate muhuungati girya, akamubhuurira Taatabhugya, “Ozomirye.” Kyaamwe akabhega. Akabhaha abhaanabheega bhaaye, bhabhatwaanire abhaatu. ");
INSERT INTO zak_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kweeki, bhaari ne ebhiswe bhisuuhu. Yeesu akabhuga, “Ozomirye, Taatabhugya,” kweeki, akaswaagya abhaanabheega bhaaye bhabhahe abhaatu. ");
INSERT INTO zak_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abhaatu bhakarya, bhakiiguta. Abhaanabheega bhakakumania amasaagyo ge ebhyaakurya, bhakiizurya ebhisehi muhuungati. ");
INSERT INTO zak_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Abhaatu bhano bhaariiri ebhyaakurya bhaari bhariisukira ebhikwe bhine (4,000). Yeesu akabharaga abhaatu bharya, bhagye owaabhu. ");
INSERT INTO zak_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Rugeendo rumwe, akatiira mubhwaato na abhaanabheega bhaaye, bhakagya mukyaaro kya Darimanuta. ");
INSERT INTO zak_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Hano Yeesu na abhaanabheega bhaaye bhaahikiri Darimanuta, Abhafarisayo bhakaaza ku Yeesu. Bhakataanga kuhakana neewe okubha bhamutiimbye. Kwo okumusakya, bhaari bharamusingʼirirya abheerekye ekyeerekenio okurwa mwiisaaro kino kikweerekya kubha arwiiri ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yeesu akabha ne ebhigoongi mukoro yaaye, akabhuga, “Kwaki emwe abhaatu bho orwiibhuro runo mureenda ekyeerekenio? Ndabhabhuurira obhuheene, enye nitakubheerekya ekyeerekenio kyokyoosi.” ");
INSERT INTO zak_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Akabhatiga, akatiira kweeki mubhwaato hamwe na abhaanabheega bhaaye. Bhakataanga orugeendo okwaambuka enyaanza. ");
INSERT INTO zak_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abhaanabheega bha Yeesu bhaari bheebhiri kugega emikaate. Bhaari no omukaate gumwe ogweene mubhwaato. ");
INSERT INTO zak_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeesu akabharekya, “Mwiiriihe bhukongʼu ne ekibhwiisya kya Abhafarisayo na kyo omutemi Herode.” ");
INSERT INTO zak_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Abhaanabheega bhaaye bhakataanga okukeerenia abheene kwa abheene, bhakubhuga, “Arabhuga ego, kwo okubha tutaagegiri emikaate.” ");
INSERT INTO zak_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yeesu akamenya goosi gano bhaari bhakukeerenia, akabhabhuurya, “Kwaki emwe muriihakania kubha, mutana emikaate? Mukyaari naabhe okumenya kigiro? Ndora eziikoro zyeenyu zibheeri kongʼu? ");
INSERT INTO zak_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Muna ameeso, nawe mutakurora? Muna amatwi, nawe mutakwiigwa? Bhoono, ndora mutakuhiita? ");
INSERT INTO zak_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eriibhaga rirya, hano niabhariisirye abhaatu bhikwe bhitaano (5,000) kwe emikaate etaano, mukakumania ebhisehi bhiriinge bhya amasaagyo?” Bhakamukyoora, “Tukakumania ebhisehi ikumi na bhibhiri.” ");
INSERT INTO zak_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na hano niabhegiri emikaate muhuungati no okubhaha abhaatu bhikwe bhine (4,000), mukakumania ebhisehi bhiriinge bhya amasaagyo?” Bhakamukyoora, “Ebhisehi muhuungati.” ");
INSERT INTO zak_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kyaamwe akabhabhuurya, “Naabhe bhoono mutamenyiri?” ");
INSERT INTO zak_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yeesu na abhaanabheega bhaaye bhakahika mumugye gwa Betisaida. Abhaatu bharebhe bhakamureeta omuhoku wumwe. Bhakamusabha Yeesu amukunie no okumuhorya. ");
INSERT INTO zak_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yeesu akamugwaata okubhoko omuhoku wurya, akagya nawe embarika wo omugye gurya. Akamutweera amate mumeeso, akamutuurira amabhoko kumeeso, akamubhuurya, “Bhoono, orarora kyokyoosi?” ");
INSERT INTO zak_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Omuutu wurya akarora, akabhuga, “Ndarora abhaatu, nawe bhararorekana kye emiti gino gikugeenda.” ");
INSERT INTO zak_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeesu akatuura amabhoko kweeki kumeeso, omuutu wurya akageenderera kurora. Akanagya okurora ebhigiro bhyoosi bhuzomu. ");
INSERT INTO zak_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yeesu akamubhuurira, “Noogye yiika, otagya osikire mumugye.” ");
INSERT INTO zak_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yeesu na abhaanabheega bhaaye bhakatanura Betisaida, bhakagya mumugye gwa haguhi na Kaisaria-Firipi, akabhabhuurya, “Abhaatu bharabhuga, enye ni weewi?” ");
INSERT INTO zak_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakamukyoora, “Abhaandi bharabhuga awe ni Yohana Omubatiizi, abhaandi bharabhuga awe ni murooti Eriya, abhaandi bharabhuga ni wumwe gati wa abharooti bha Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Akabhabhuurya, “Bhoono emwe, murabhuga enye ni weewi?” Petero akamukyoora, “Awe naawe Masiya.” ");
INSERT INTO zak_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeesu akabharekya bhatasakya kumubhuurira muutu wowoosi ewe ni weewi. ");
INSERT INTO zak_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kyaamwe Yeesu akataanga okubheegya abhaanabheega bhaaye kubha, kwo obhuseegi bhwa Taatabhugya areenderwa, ewe Omwaana wo Omuutu, abhone enyaako nzaru, yaangwe na abhakaruka bha Abhayahudi, na abhakuru bha abhaseengeri, na abheegya bhe emigiro gya Musa, na yiitwe. Nawe orusiku rwa katatu kweema okukwa kwaaye, araryoorwa. ");
INSERT INTO zak_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yeesu yaari arabhabhuurira abhaanabheega bhaaye eriingʼana kwa mwaasi. Nawe, Petero akamugega Yeesu kibhezo, akataanga okumurekya. ");
INSERT INTO zak_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yeesu akiikibhuka, akabharoreerera abhaanabheega bhaaye. Akamurekya Petero, “Seetaani, noogye inyuma waane! Otakugania ga Taatabhugya, nawe oragania ga abhaatu.” ");
INSERT INTO zak_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Akabhirikira esaango ya abhaatu hamwe na abhaanabheega bhaaye, akabhabhuurira, “Omuutu wowoosi wuno akweenda kunituniirira, areenderwa yiiyaange omweene, agege omusaraba gwaaye, anituniirire. ");
INSERT INTO zak_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","No omuutu wuno akweenda kutuurya obhwiikari bhwaaye omweene, arabhubhurya. Nawe omuutu wowoosi wuno araabhubhurye obhwiikari bhwaaye kwiiguru waane na kwiiguru wa Amangʼana Amazomu, niwe araabhutuurye. ");
INSERT INTO zak_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Omuutu arabhona bhweeraki araabhone obhuniibhi bhwoosi mukyaaro kino, nawe abhurye obhuhoru bhwaaye bhwa kirakeego? ");
INSERT INTO zak_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kitariho ekigiro kino kikunagya okumukyoorerya obhuhoru bhuyo. ");
INSERT INTO zak_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hano enye Omwaana wo Omuutu nikwiika na bhamaraika abhahoreeru mubhuguungo bhwa Taata waane, ndamurorera eziisoni omuutu wowoosi wuno akunirorera enye eziisoni na ameegyo gaane mwiibhaga rino rya abhaatu okukora ebhibhi no okutama okumura Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yeesu akageenderera kubhabhuurira, “Ndabhabhuurira obhuheene, bhariho abhamwe gati weenyu bhano bhatakukwa bhakyaari okurora obhutemi bhwa Taatabhugya bhuraaza kwa amanaga.” ");
INSERT INTO zak_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Hano zyahitiri eziisiku isaasabha, Yeesu akagega Petero, Yaakobo na Yohana, akatiira nabho mukiguru ekitaambi, kibhezo. Hano bhaari hayo, Yeesu akakyoorwa embere waabhu. ");
INSERT INTO zak_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eziingibho zyaaye zikataanga kumesyamesya bhukongʼu. Zikabha ndabhu pee, kukira omuhuri wowoosi mukyaaro kino yaanganagirye kuzihura. ");
INSERT INTO zak_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Hayohayo bhakatuukira Eriya na Musa, bhakabha bharakeerenia na Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petero akamubhuurira Yeesu, “Omweegya, ni kisi etwe kubha hano. Twoomboke hano ebhihuuna bhitatu, ekimwe kibhe ekyaazo, ekiindi kibhe kya Musa ne ekiindi kibhe kya Eriya.” ");
INSERT INTO zak_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ataamenyiri rino okugaamba, kwo okubha ewe na abharikyaaye bhakoobhoha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niho eriisaaro rikiituuma, rikabhakuundikirya. Eriiraka rya Taatabhugya rikiigweerwa okurwa mwiisaaro, rikabhuga, “Wuno niwe Omwaana waane omuseegwa. Mubhe muramwiitegeerera!” ");
INSERT INTO zak_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Rugeendo rumwe abhaanabheega bharya bhakaroreerera eno ne eno, bhataamuruuzi omuutu owuundi, nawe Yeesu omweene. ");
INSERT INTO zak_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hano bhaari kwiituuma mukiguru hayo, Yeesu akabhaswaagya bhatamubhuurira muutu wuyo woosi gano bharuuzi, tee hano Omwaana wo Omuutu akubha aryookiri okurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Abhaanabheega bharya bhakarigwaata eriingʼana riyo, nawe bhakabha bhariibhuurya ebho kwe ebho, “Okuryoorwa kwaaye okurwa mubhaku, obhugazuro bhwaku niki?” ");
INSERT INTO zak_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhakamubhuurya Yeesu, “Bhoono kwaki abheegya bhe emigiro gya Musa bharabhuga kubha, ereenderwa Eriya yiize hiinga niho Masiya yiize?” ");
INSERT INTO zak_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Neewe akabhakyoora, “Niigo eri, Eriya areenderwa yiize hiinga okubha atuure kisi amangʼana goosi. Naabhe ego, kwaki ekaamirwe mu Makaamo Amahoreeru kubha, Omwaana wo Omuutu aranyaakibhwa bhukongʼu no okuzeerwa? ");
INSERT INTO zak_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nawe ndabhabhuurira, Eriya yiiziri, nabho bhakamukorera amabhiihu goosi gano bhaari bhakweenda, kyeego ekaamirwe.” ");
INSERT INTO zak_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hano Yeesu, Petero, Yohana na Yaakobo bhaahikiri kubhaanabheega abhaandi, bhakarora esaango ekuru ya abhaatu ebhiiruguuriri. Abheegya bhe emigiro gya Musa bhaari bharahakana na abhaanabheega bhayo. ");
INSERT INTO zak_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hano esaango yirya yamuruuzi Yeesu, bhoosi bhakaruguura bhukongʼu. Rugeendo rumwe bhakamuryaarira, bhakamukeerya. ");
INSERT INTO zak_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeesu akabhabhuurya, “Murahakana nabho iguru waki?” ");
INSERT INTO zak_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Omuutu wumwe musaango yirya akamukyoora, “Ee Omweegya, nimureetiri omwaana waane kwaawe. Ane eriisaambwa rino riramukora abhe imuumu. ");
INSERT INTO zak_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maanga maaru riramutiira no okumugwiisya haasi, araruusya eriihuro mumunwa, no okusaanania ameeno no okuhaangarara omubhiri gwoosi. Nikabhasabha abhaanabheega bhaazo kubha, bhamuruusye eriisaambwa, nawe bhakatamwa.” ");
INSERT INTO zak_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yeesu akabhuga, “Emwe abhaatu bho orwiibhuro runo, mutana obhwiikirirya, ndiikara neemwe tee ryoori? Ndabhiigumiirirya tee ryoori? Mumureete omwaana kweenye.” ");
INSERT INTO zak_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhakareeta omumura wurya ku Yeesu. Nawe hano eriisaambwa ryaamuruuzi Yeesu, hayohayo rikamuha omwaana wurya eriirimu. Akagwa haasi, akasaambagana no okuruusya eriihuro mumunwa. ");
INSERT INTO zak_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yeesu akabhuurya wiise omwaana, “Eziinyaako zino zyataangiri kweemera ryoori?” Wiise omwaana akamukyoora, “Kweemera obhwaana bhwaaye. ");
INSERT INTO zak_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maanga maaru eriisaambwa riyo rimugwiisirye mumuriro ahaandi mumaanzi okubha rimwiite. Bhoono eraabhe oranagya kukora ryoryoosi, oturorere ebhigoongi, otusakirye.” ");
INSERT INTO zak_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yeesu akamukyoora, “Kwaki ogaambiri, ‘Eraabhe oranagya’? Goosi garaturikana kumuutu wuno akumwiikirirya Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rugeendo rumwe, wiise omwaana wurya akarira kwe eriiraka akabhuga, “Ndiikirirya! Nawe obhwiikirirya bhwaane ni bhusuuhu, nisakirya nibhe no obhwiikirirya bhukuru.” ");
INSERT INTO zak_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hano Yeesu yaruuzi esaango ya abhaatu eraaruha okumwiiruguura, akariheebha eriisaambwa rirya, akabhuga, “Awe eriisaambwa! Oramukora omwaana wuno kubha imuumu no omuribhi wa amatwi. Bhoono ndakuswaagya, noorwe kumwaana wuno, no otasakya okumusikira kweeki.” ");
INSERT INTO zak_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Niho eriisaambwa rirya rikatema ekituri, rikamugwiisya omwaana wurya ne eriirimu rikamutiira, okumara rikamurwaku. Omwaana wurya akabha kyeego akuuri, abhaatu bhaaru bhakabhuga, “Akuuri!” ");
INSERT INTO zak_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nawe, Yeesu akamugwaata okubhoko omwaana wurya, akamubhuukya, neewe akiimeerera. ");
INSERT INTO zak_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ambe, hano Yeesu yaari munyuumba, abhaanabheega bhaaye bhakamubhuurya kibhezo, “Kwaki tukatamwa okuriheebha eriisaambwa rirya?” ");
INSERT INTO zak_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeesu akabhabhuurira, “Eriisaambwa kya rino ritakuheebhwa kwa amangʼana ageene nawe kwa amasabhi.” ");
INSERT INTO zak_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yeesu na abhaanabheega bhaaye bhakarwa eyo, bhakahita gatigati we ekyaaro kya Gariraaya. Yeesu ateendiri abhaatu bhamenye kubha ari iyo, ");
INSERT INTO zak_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwo okubha yaari arabheegya abhaanabheega bhaaye. Akabhabhuurira, “Enye Omwaana wo Omuutu, ndatuurwa mumabhoko ga abhaatu nabho bharaaniita, nawe orusiku rwa katatu kweema okukwa kwaane, ndaryooka.” ");
INSERT INTO zak_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Abhaanabheega bhaaye bhataamenyiri rino yaari akugaamba, nawe bhaari ne ehaho kumubhuurya. ");
INSERT INTO zak_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yeesu na abhaanabheega bhaaye bhakahika mumugye gwa Kaperinaumu. Hano bhaasikiiri munyuumba, Yeesu akabhabhuurya, “Mwaari murahakaniraki munzira?” ");
INSERT INTO zak_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Niho abhaanabheega bhaaye bhakakira, kwo okubha bhaari bhahakeeni abheene kwa abheene munzira kubha, weewi gati waabhu yaari arabha omukuru kukira abharikyaaye bhoosi. ");
INSERT INTO zak_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yeesu akiikara haasi, akabhabhirikira abhaanabheega bhaaye ikumi na bhabhiri. Akabhabhuurira, “Omuutu wuno akweenda kubha omukuru kubhoosi areenderwa okwiiyiikya iyaasi, no okubha omuhokya wa bhoosi.” ");
INSERT INTO zak_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Akagega omwaana omusuuhu, akamwiimeererya gatigati waabhu. Akamuhuumbata, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Omuutu wowoosi wuno akumuginihya omwaana kya wuno kwe eriina ryaane, araniginihya enye. Kweeki, omuutu wuno araaniginihye enye, ataaniginihirye enye omweene. Eheene aramuginihya Taatabhugya wuno antumiri enye.” ");
INSERT INTO zak_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana akamubhuurira Yeesu, “Omweegya, tukamurora omuutu araruusya amasaambwa amabhi kwe eriina ryaazo. Etwe tukasakya kumurekya, kwe ekigirirye atari wo oweetu.” ");
INSERT INTO zak_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nawe Yeesu akabhuga, “Mutamurekya omuutu kya wuyo. Atariho omuutu wuno akukora ekitiika kwe eriina ryaane, okumara kweeki anigaambe bhubhi. ");
INSERT INTO zak_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Omuutu wuno atakutwaanga, ari hamwe neetwe. ");
INSERT INTO zak_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Omuutu wowoosi wuno araabhahe naabhe amaanzi masuuhu go okunywa kwe ekigirirye emwe ni bhaatu bha Masiya, ndabhabhuurira obhuheene, Taatabhugya atakweebha okumuha esaambo yaaye.” ");
INSERT INTO zak_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yeesu akageenderera kugaamba, “Nawe eraabhe ariho omuutu wuno araamubhurye owumwe wa abhasuuhu bhano, bhano bhakuniikirirya enye, akagirya akore ebhibhi. Yiingabheeri kisi abhoherwe orubhwe mwiigoti no okurekerwa munyaanza. ");
INSERT INTO zak_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kweeki, okubhoko kwaazo kuraagirye okore ebhibhi, okutine. Ni hakiriku osikire mubhuhoru bhwa kirakeego no obhurema bhwo okubhoko kumwe, okutama kubha na amabhoko abhiri no okugya nyaari mumuriro guno gutakurima.  ");
INSERT INTO zak_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Eyo niyo eziinyeende zitakukwa, no omuriro gwaaye gutakurima. ");
INSERT INTO zak_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Okuguru kwaazo kuraagirye okore ebhibhi, okutine. Ni hakiriku osikire mubhuhoru bhwa kirakeego ni igata kwo okuguru kumwe, okutama kubha na amaguru abhiri no okurekerwa mumuriro gwa nyaari.  ");
INSERT INTO zak_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Eyo niyo eziinyeende zitakukwa, no omuriro gwaaye gutakurima. ");
INSERT INTO zak_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Eriiso ryaazo riraagirye okore ebhibhi, oriihe. Ni hakiriku osikire mubhutemi bhwa Taatabhugya ne ekitongʼo, okutama kubha na ameeso abhiri no okurekerwa mumuriro gwa nyaari. ");
INSERT INTO zak_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Eyo niyo eziinyeende zitakukwa, no omuriro gwaaye gutakurima. ");
INSERT INTO zak_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Taatabhugya arabhahitya abhaatu bhoosi munyaako yino etuubheeni no okuturiirwa omuunyu no okuhitibhwa mumuriro. ");
INSERT INTO zak_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Omuunyu ni muzomu, nawe guraabhurye obhuzomu bhwago, muranagya okutaamu kigiroki okubha guzome kweeki? Na neemwe mubhe kyo omuunyu omuzomu, mubhe no obhwiigwaani abheene kwa abheene.” ");
INSERT INTO zak_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Niho Yeesu na abhaanabheega bhaaye bhakatanura Kaperinaumu, bhakagya ekyaaro kya Yudea. Bhakahita no okwaambuka Ekitaaro kya Yorodaani. Amahizo ga abhaatu bhaaru gakabha garamwiiruguura kweeki, na yaari arabheegya kyeego akanara okukora. ");
INSERT INTO zak_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ambe, Abhafarisayo bhakaaza okumusakya. Bhakamubhuurya, “Angu, emigiro gya Musa giriikirirya omusubhe okutaana na mukaaye?” ");
INSERT INTO zak_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yeesu akabhakyoora, “Musa akaswaagya migiroki?” ");
INSERT INTO zak_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bhakamukyoora bhakabhuga, “Musa akiikirirya, omusubhe okutaana na mukaaye amuhe enyaarubha yo okutaana.” ");
INSERT INTO zak_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yeesu akabhabhuurira, “Musa akabhakaamira eriiswaagyo riyo kwe ekigirirye kyo obhukongʼu bhwe eziikoro zyeenyu. ");
INSERT INTO zak_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nawe, kweema obhweemero bhwo okuteemwa ekyaaro, ‘Taatabhugya akabhabhuumba omusubhe no omukari.’ ");
INSERT INTO zak_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Kwe ekigirirye kiyo, omusubhe aratiga wiise na nina waabhu, aragwaatana na mukaaye. ");
INSERT INTO zak_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Abhabhiri bhano bharabha omubhiri gumwe.’ Na abhabhiri bhano, bhatakubha bhabhiri kweeki, nawe ni wumwe. ");
INSERT INTO zak_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kweego abhaatu bhano Taatabhugya abhagwaateenie, omuutu ataaza kubhatwaanikania.” ");
INSERT INTO zak_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hano bhaasikiiri kweeki munyuumba, abhaanabheega bhaaye bhakamubhuurya iguru wa amangʼana gayo. ");
INSERT INTO zak_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yeesu akabhabhuurira, “Omuutu wuno akutaana na mukaaye no okumukweera owuundi, aramukorera obhuseebheeti. ");
INSERT INTO zak_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","No omukari wuno akutaana no omusubhe waaye no okukweerwa no omusubhe owuundi, aramukorera obhuseebheeti.” ");
INSERT INTO zak_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Abhaatu bhaari bharamureetera Yeesu abhaana bhaabhu abhasuuhu abhakunieku kwo okubhatweera ebhite. Nawe abhaanabheega bhaaye bhakabharekya abhiibhuri bhayo. ");
INSERT INTO zak_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hano Yeesu yabharuuzi abhaanabheega bhaaye bharakora ego, akatiinda. Akabhabhuurira, “Mubhatige abhaana abhasuuhu bhiize kweenye! Mutabharekya, kwo okubha obhutemi bhwa Taatabhugya ni bhwa abhaatu kya abhaana abhasuuhu bhano. ");
INSERT INTO zak_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ndabhabhuurira obhuheene, wowoosi wuno atakwiikirirya obhutemi bhwa Taatabhugya kyo omwaana omusuuhu, atakunagya kubhusikira naabhe hasuuhu.” ");
INSERT INTO zak_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Niho akabhahuumbata abhaana bhayo, akabhatuurira amabhoko gaaye, akabhatweera ebhite. ");
INSERT INTO zak_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Hano Yeesu na abhaanabheega bhaaye bhaataangiri kubhuuka, omuutu wumwe akamuryaarira, akahigama embere waaye. Akamubhuurya Yeesu, “Omweegya omuzomu, nikoreki, okubha kurusiku rwo obhuteero nigabhe obhuhoru bhwa kirakeego?” ");
INSERT INTO zak_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yeesu akamukyoora, “Kwaki orabhuga enye ni muzomu? Atariho omuutu muzomu, nawe Taatabhugya omweene ego. ");
INSERT INTO zak_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bhoono, oragimenya bhuzomu emigiro gya Taatabhugya gino gikubhuga, ‘Otiita, otaseebheeta, otiibha, otamenyeekererya orurimi, otangʼeena, obhasuuke wuuso na nyoko weenyu.’ ” ");
INSERT INTO zak_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Omuutu wurya akabhuga, “Omweegya, nigigwaatiri emigiro gyoosi kweema obhwaana bhwaane.” ");
INSERT INTO zak_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yeesu akamuroreerera, akamuseega, akamubhuurira, “Osuuhiirwe kigiro kimwe. Noogye ogurye ebhigiro bhyoosi bhino onabhyo, ne eziimbirya zino oraabhone, obhatwaanire abhataka. Oribha okoriri ego, orabha wiituuriiri ehata mwiisaaro. Okumara, wuuze onituniirire.” ");
INSERT INTO zak_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nawe, omuutu wurya hano yiigwiiri gayo, akabha ne ebhigoongi mukoro. Akatanura ahoobhiri bhukongʼu, kwe ekigirye yaari ne ebhigiro bhyaaru bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yeesu akabharoreerera ameeso abhaatu eno ne eno, akabhabhuurira abhaanabheega bhaaye, “Erabha kukongʼu kumuniibhi kusikira mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abhaanabheega bhaaye bhakaruguura kwa amangʼana gaaye. Yeesu akabhabhuurira kweeki, “Abhaana bhaane, murore kyeego ni kukongʼu kusikira mubhutemi bhwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ni kunyoohu kwe engamia okuhita mukibhaanga kyo orugera, kukira omuniibhi kusikira mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abhaanabheega bhaaye bhakaruguura bhukongʼu kwe engʼana yiyo. Bhaari bhariibhuurya abheene kwa abheene, “Bhoono, eraabhe niigo gari, weewi wuno akunagya kutuuribhwa?” ");
INSERT INTO zak_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeesu akabharoreerera, akabhabhuurira, “Kubhaatu gatakuturikana, nawe ku Taatabhugya goosi garaturikana.” ");
INSERT INTO zak_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero akamubhuurira, “Rora, etwe tukatiga ebhigiro bhyoosi, tukakutuniirira.” ");
INSERT INTO zak_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Niho Yeesu akabhuga, “Ndabhabhuurira obhuheene, omuutu wuno atigiri enyuumba yaaye, abhamura na abhasubhaati bhaaye, wiise na nina waabhu, abhaana bhaaye, kasi emiguundu, kwiiguru waane na kwiiguru wa Amangʼana Amazomu, ");
INSERT INTO zak_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Taatabhugya aramuha bhyaaru bhukongʼu kukira bhirya. Bhoono kwiibhaga riyo, arasuungʼaana eziinyuumba zyaaye, abhamura bhaabhu, abhasubhaati bhaaye, bhanina waabhu, abhaana bhaaye ne emiguundu. Hamwe na garya goosi, arabha ne enyaako. Ne eriibhaga rino rikuuza, arasuungʼaana obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nawe abhaaru bhano bhakurorekana ni bhakuru bhoono, bhatakubha no obhweera bhwobhwoosi mukyaaro kino kikuuza. Kweeki abhaaru bhano bhakurorekana bhatari bhakuru bhoono, bharabha bhakuru mukyaaro kino kikuuza.” ");
INSERT INTO zak_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hano Yeesu na abhaanabheega bhaaye bhaari munzira kugya mumugye gwa Yerusaremu, Yeesu yaari arabhakaangatira embere waabhu. Abhaanabheega bha Yeesu bhakaruguura, na abhaatu abhaandi bhano bhaari bhakumutuniirira, bhaari ne ehaho. Yeesu akabhabhirikira kweeki kibhezo abhaanabheega bhaaye ikumi na bhabhiri, akataanga kubhabhuurira gano garaamubhone. ");
INSERT INTO zak_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Akabhuga, “Murore, bhoono tureerekera Yerusaremu. Niho, enye Omwaana wo Omuutu, ndatuurwa mumabhoko ga abhakuru bha abhaseengeri na mumabhoko ga abheegya bhe emigiro. Nabho bharanitinira ekiina kubha niitwe. Mubhuteero, bharanituura mumabhoko ga abhaatu bhano bhatari Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Abhaatu bhayo bharanizabhura no okunitweera amate. Bharanitema emijariti no okuniita. Nawe, orusiku rwa katatu, ndaryoorwa.” ");
INSERT INTO zak_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yaakobo na Yohana, abhaana bha Zebedaayo, bhakamwiisukira Yeesu, bhakamubhuurira, “Omweegya, turasabha otukorere ryoryoosi rino tukusabha.” ");
INSERT INTO zak_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yeesu akabhabhuurya, “Mureenda nibhakorereki?” ");
INSERT INTO zak_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhakamubhuurira, “Turakusabha otwiikirirye hano okukaangata mubhuguungo bhwaazo, twiikare hamwe naawe, owumwe orubhaara rwo obhuryo, owuundi orubhaara rwo obhumosi.” ");
INSERT INTO zak_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yeesu akabhabhuurira, “Mutamenyiri gano mukusabha. Mbe, muranagya okunyweera ekikoombe kye enyaako kino ndaanywe, kasi muranagya okubatiizwa obhubatiizo bhwo okukwa bhuno ndaabatiizwe?” ");
INSERT INTO zak_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakamukyoora, “Turanagya.” Yeesu akabhabhuurira, “Eheene, murakinyweera ekikoombe kye enyaako kino enye ndaanyweere, kasi muranagya okubatiizwa obhubatiizo bhwo okukwa bhuno ndaabatiizwe. ");
INSERT INTO zak_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nawe, okwiikara orubhaara rwaane rwo obhuryo kasi rwo obhumosi gutari murimo gwaane okubhiikirirya. Nawe Taatabhugya arabhaha bharya amariri kubhabhanurira.” ");
INSERT INTO zak_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hano abhaanabheega abharikyaabhu ikumi bhiigwiiri gayo, bhakataanga okutiindira Yaakobo na Yohana. ");
INSERT INTO zak_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Niho Yeesu akabhabhirikira abhaanabheega bhoosi, bhiisuke kweewe. Akabhabhuurira, “Mumenyiri kubha abhakaangati bhe ebhyaaro bharabhaaha abhaatu bhaabhu kwa amanaga, na bharabhakorya emirimo. ");
INSERT INTO zak_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nawe etakubha ego kweemwe, wuno akubha omukuru gati weenyu, abhe kyo omusuuhu. Na wuno akubha omukaangati, abhe kyo omubhagati wa abhaandi. ");
INSERT INTO zak_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kweeki, omuutu wuno akweenda kubha wo okutaanga gati weenyu, areenderwa abhe omugya weenyu. ");
INSERT INTO zak_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naabhe enye Omwaana wo Omuutu, nitiiziri kuhokeeribhwa, nawe nikaaza kubhahokeerya abhaatu no okuruusya obhuhoru bhwaane, bhubhe endihi ya abhaatu bhaaru.” ");
INSERT INTO zak_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ambe, bhakahika mumugye gwa Yeriko. Hano Yeesu na abhaanabheega bhaaye ne esaango ekuru ya abhaatu bhaatanwiiri Yeriko, bhakamubhona omuutu wumwe eriina ryaaye ni Baritoromaayo, omwaana wa Timayo. Omuutu wuyo yaari muhoku. Yaari yiikeeri embarika kunzira yaari arasabha eziimbirya. ");
INSERT INTO zak_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hano yiigwiiri kubha Yeesu wa Nazareeti yaari arahita harya, akataanga kurira kwe eriiraka ikuru, “Ee Yeesu, Omwaana wo omutemi Daudi, ndakusabha onirorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abhaatu bhaaru bhaari bharamurekya kubha akire. Nawe ewe akageenderera kurira kwe eriiraka ikuru bhukongʼu, “Omwaana wa omutemi Daudi, nirorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Niho Yeesu akiimeerera, akabhuga, “Mubhirikire yiize hano.” Bhakamubhirikira omuhoku wurya, bhakamubhuurira, “Tema ekubhi, imeerera! Arakubhirikira.” ");
INSERT INTO zak_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Neewe akarekera ekabhuuti yaaye haasi, akiimeerera bhwaangu, akagya ku Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yeesu akamubhuurya, “Oreenda nikukorereki?” Omuhoku wurya akamukyoora, “Omweegya, ndeenda okurora.” ");
INSERT INTO zak_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeesu akabhuga, “Noogye, obhwiikirirya bhwaazo bhukuhonirye.” Hayohayo, omuutu wuyo akataanga kurora, akamutuniirira Yeesu munzira. ");
INSERT INTO zak_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hano Yeesu na abhaanabheega bhaaye bhiisukiiri Yerusaremu, haguhi mumigye gya Betifage na Betania, mu Kiguru kye Emizeituni. Niho Yeesu akabharagania bhabhiri gati wa abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Akabhabhuurira, “Mugeende mumugye guno guri embere weenyu. Hano muraasikire muyo, murabhona etikiri, yino ekyaari kugega muutu, ebhohirwe. Muyisibhure muyireete hano. ");
INSERT INTO zak_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","No omuutu wowoosi akubhabhuurya, ‘Kwaki murakora ego?’ mumubhuurire, ‘Omukuru arayeenda, arayikyoorya kwiibhaga iguhi.’ ” ");
INSERT INTO zak_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ambe bhakagya, bhakayibhona etikiri ebhohirwe igutu we ekiseku kunzira ekuru, bhakayisibhura. ");
INSERT INTO zak_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abhaatu abharebhe gati wa bhano bhakiimeerera harya, bhakabhabhuurya, “Emwe! Kwaki murasibhura etikiri yiyo?” ");
INSERT INTO zak_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Abhaanabheega bharya bhakabhakyoora kyeego Yeesu yaari abhabhuuriiri bhagaambe. Ambe abhaatu bhayo bhakabhiikirirya. ");
INSERT INTO zak_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhakahira etikiri ku Yeesu, no okwaarya emyeenda gyaabhu iguru we etikiri yiyo. Yeesu akatiira, akiikara. ");
INSERT INTO zak_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Abhaatu bhaaru bhakaarya emyeenda gyaabhu kunzira, abhaandi bhakatina amatu mumiguundu no okwaarya kunzira kwo okumusuuka Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abhaatu abharebhe bhakamukaangatira Yeesu, na abhaandi bhakamutuniirira inyuma. Bhoosi bhaari bharatiirya eriiraka bharabhuga, “Taatabhugya akumibhwe! Atweerwe ebhite wuno akuuza kuriina ryo Omukuru! ");
INSERT INTO zak_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bhutweereerwe ebhite obhutemi bhwa zaazi weetu Daudi bhuno bhukuuza! Akumibhwe Taatabhugya wuno ari mwiisaaro!” ");
INSERT INTO zak_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeesu akasikira Yerusaremu, akagya kimwekimwe, akasikira mwiiseengerero rya Taatabhugya. Akabhiroreerera bhuzomu ebhigiro bhyoosi bhino bhyaari bhireho harya. Nawe kwo okubha yaari engoroobha, akatanura, akagya hamwe na abhaanabheega bhaaye ikumi na bhabhiri mumugye gwa Betania. ");
INSERT INTO zak_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Etabhoori yaho, hano Yeesu yaari na abhaanabheega bhaaye bhaari bharweereeri Betania kukyoora Yerusaremu, akiigwa enzara. ");
INSERT INTO zak_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akarora omuti gwo omutiini kwa kure, guno gwaari na amatu maaru. Akagwiisukira arore eraabhe gwaari ne emisumo gye ezitiini. Hano yahikiri harya, akabhona gutana emisumo, gwiizwiiri amatu ageene, kwo okubha eriibhaga ryo okwiibhura emisumo ryaari rikyaari kuhika. ");
INSERT INTO zak_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ambe akagubhuurira omuti gurya, “Kweemera reero yino tee kirakeego, otiibhura emisumo!” Abhaanabheega bhaaye bhakiigwa amangʼana gayo. ");
INSERT INTO zak_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hano bhaahikiri Yerusaremu, niho Yeesu yasikiiri mwiigoobhe rye eriiseengerero rya Taatabhugya, akabhabhona abhaaru bhano bhaari kugura no okugurya ebhigiro muyo, akataanga kubhaheebha igutu. Akazigwiisya eziimeeza zya bhano bhaari bhakukirania eziimbirya, no okuhuungura ebhituumbi bhya bhano bhaari bhakugurya ebhiguuti. ");
INSERT INTO zak_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kweeki, ataamwiikiriirye omuutu wuyo woosi okugega ekigiro kyokyoosi kyo okugurya kwo okuhitira mwiiseengerero. ");
INSERT INTO zak_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kyaamwe Yeesu akabheegya, “Mbe, etakaamirwe mu Makaamo Amahoreeru, Taatabhugya akabhuga, ‘Enyuumba yaane erabha enyuumba ya amasabhi kubhaatu bhe ebhyaaro bhyoosi?’ Nawe emwe, muyikyoosirye kubha kye eriibhigi rya abhateesya!” ");
INSERT INTO zak_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hano abhakuru bha abhaseengeri na abheegya bhe emigiro gya Musa bhiigwiiri gayo goosi, bhakataanga kukomya enzira yo okumwiita. Nawe bhakoobhoha, kwo okubha abhaatu bhoosi bhaari bhararuguura kwa ameegyo gaaye. ");
INSERT INTO zak_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hano engoroobha yahikiri, Yeesu na abhaanabheega bhaaye bhakatanura mumugye guyo. ");
INSERT INTO zak_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Etabhoori yaho, hano bhaari bhakukyoora mumugye gwa Yerusaremu, bhakabhona omuti gurya gwo omutiini gwoomiri gwoosi okweema kumiri gyaaye. ");
INSERT INTO zak_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero akahiita amangʼana gano Yeesu yabhugiri, akamubhuurira, “Omweegya, rora! Omuti gurya gwo omutiini guno okagwiihiima, gwoomiri!” ");
INSERT INTO zak_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeesu akabhabhuurira, “Mumwiikirirye Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ndabhabhuurira obhuheene, eraabhe omuutu ariikirirya na atana obhwiitiimaati mukoro yaaye, rino akubhuga rirakoreka. Aranagya okubhuurira ekiguru kino, ‘Ihika no okwiirekera munyaanza,’ na gayo garakoreka. ");
INSERT INTO zak_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kweego ndabhabhuurira, hano mukwiisasaama musabhe kyokyoosi, mubhe no obhwiikirirya kubha mukisuungʼaaniri, na neemwe murakisuungʼaana. ");
INSERT INTO zak_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nawe hano mukusabha, mumwaabhire omuutu wowoosi wuno abhasariirye. Niho Wuuso weenyu wa mwiisaaro arabhaabhira ebhibhi bhyeenyu.  ");
INSERT INTO zak_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nawe eraabhe emwe mutakwaabhira abhaandi, neewe Wuuso weenyu wa mwiisaaro atakubhaabhira ebhibhi bhyeenyu.” ");
INSERT INTO zak_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yeesu na abhaanabheega bhaaye bhakahika kweeki Yerusaremu. Hano bhaari bharageenda mwiiseengerero rya Taatabhugya, abhakuru bha abhaseengeri, abheegya bhe emigiro gya Musa na abhakaruka bha Abhayahudi bhakamugyaku. ");
INSERT INTO zak_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bhakamubhuurya, “Gano okukora, oragakora kwo obhuturoki? Ni weewi wuno akuheeri obhuturo bhuyo okukora gayo?” ");
INSERT INTO zak_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeesu akabhuga, “Na neenye ndabhabhuurya eriingʼana rimwe. Muraanikyoore, ndabhabhuurira ni kwo obhuturoki ndakora gano. ");
INSERT INTO zak_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mbe, obhuturo bhwa Yohana bhwo okubatiiza abhaatu, bhukarwa hayi? Bhukarwa ku Taatabhugya wuno ari mwiisaaro kasi kubhaatu?” ");
INSERT INTO zak_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Niho bhakataanga okwiibhuurya, “Turaabhuge, ‘Bhukarwa mwiisaaro,’ aratubhuurya, ‘Ambe, ndora mutaamwiikiriirye?’ ");
INSERT INTO zak_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nawe, turibhuga, ‘bhukarwa kubhaatu,’ abhaatu bharatutiindira.” Bhaari bharoobhoha abhaatu, kwo okubha abhaatu bhoosi bhakamwiikirirya Yohana yaari omurooti. ");
INSERT INTO zak_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Niho bhakamukyoora Yeesu, “Etwe tutamenyiri.” Neewe akabhabhuurira, “Na neenye nitakubhabhuurira ni kwo obhuturoki ndakora gano.” ");
INSERT INTO zak_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yeesu akataanga okugaamba na abhakaangati bha Abhayahudi bharya kwe ebhireengyo. Akabhuga, “Kwaari no omuutu wumwe wuno yarimiri omuguundu gwe emizabibu. Akagwiiruguurirya orubhago, akatuka eriitobheeryo ryo okutobheerya eziizabibu zirya. Akoomboka obhutiingo bhutaambi bhwo okuriibhira mumuguundu. Mubhuteero, akabhasagarya omuguundu abharimi abharebhe, akagya orugeendo. ");
INSERT INTO zak_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Eriibhaga ryo okugesa eziizabibu hano ryahikiri, akamutuma owumwe wa abhagya kubharimi bhaaye bharya, okubha bhamuhe esoondo yaaye ye eziizabibu okurwa mumuguundu gwaaye. ");
INSERT INTO zak_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nawe, abharimi bharya bhakamugwaata omugya wurya, bhakamutema no okumukyoorya mabhoko bhusa. ");
INSERT INTO zak_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mweene muguundu akamutuma omugya waaye owuundi kubharimi bharya. Woosi bhakamutema no okumunyahaara kumutwe, no okumukorera obhubhi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akamutuma omugya waaye owuundi, abharimi bharya bhakamwiita. Akabhatuma abhagya bhaaye abhaandi bhaaru. Abharimi bharya bhakabhatema, abhaandi bhakabhiita. ");
INSERT INTO zak_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mweene muguundu akasaaga no owumwe, omwaana waaye omuseegwa. Kubhuteero akamutuma kubharimi bharya, akiiseega, ‘Bharasuuka omwaana waane.’ ");
INSERT INTO zak_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Nawe, eriibhaga yahikiri, abharimi bharya bhakiibhuurira, ‘Wuno niwe omugabhi we ebhigiro bhya wiise waabhu. Bhoono, tumwiite. Engabho yaaye yino ebhe eyeetu.’ ");
INSERT INTO zak_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Niho bhakamugwaata, bhakamwiita, bhakamurekera igutu yo omuguundu gurya gwe emizabibu. ");
INSERT INTO zak_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Bhoono, mweene muguundu gwe emizabibu wuyo arakorabhwi? Araaza no okubhiita abharimi bharya, no omuguundu guyo, arabhasagarya abhaatu abhaandi. ");
INSERT INTO zak_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mbe, mukyaari kusoma Amakaamo Amahoreeru gano? ‘Eriigina rino abhoomboki bhaaryaangiri, niryo ribheeri eriigina eriikuru ryo obhurusa. ");
INSERT INTO zak_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Omukuru niwe arikoriri riyo, naryo ni ingʼana ryo okuruguurya kweetwe.’ ” ");
INSERT INTO zak_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Abhakuru bha abhaseengeri, abheegya bhe emigiro gya Musa na abhakaruka bhakamenyeekererya kubha ekireengyo kirya kirabhagaambira ebho. Niho bhakeenda kumugwaata, nawe kwo okubha bhakoobhoha esaango ya abhaatu, bhakamutiga, bhakatanura. ");
INSERT INTO zak_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Niho abhakuru bha Abhayahudi bhakabhatuma Abhafarisayo abharebhe bhano bhaagwaateeni na abhasakirya bho omutemi Herode, bhamutiimbye Yeesu kuriingʼaana na amangʼana gaaye omweene. ");
INSERT INTO zak_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhakamugyaku Yeesu, bhakamubhuurira, “Ee Omweegya, tumenyiri kubha awe ni muutu we eheene. Awe otakumura obhukuru bhwo omuutu. Oreegya enzira ya Taatabhugya kwo obhuheene. Bhoono, emigiro gya Musa giratwiikirirya kuriha eriigooti ku Kaisari? Turihe kasi zeyi?” ");
INSERT INTO zak_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nawe Yeesu akamenyeekererya orurimi rwaabhu, akabhabhuurira, “Ndora muranisakya kunitiimbya? Munireetere orubhirya rwe edinaari nirore.” ");
INSERT INTO zak_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Niho bhakamuhirira, akabhabhuurya, “Epicha yino ne eriina rino ni bhya weewi?” Bhakamukyoora bhakabhuga, “Ni bhya Kaisari.” ");
INSERT INTO zak_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yeesu akabhabhuurira, “Ebhigiro bhya Kaisari muhaane Kaisari, na bhya Taatabhugya muhaane Taatabhugya.” Bhoosi bhakaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kwaari ne ekigwaatani kimwe kya Abhayahudi kino kikubhirikirwa Abhasadukayo. Ebho bhahaabhuga, kutariho okuryooka kwa abhaku. Orusiku rumwe, abhamwe bhaabhu bhakagya ku Yeesu, bhakamubhuurya, ");
INSERT INTO zak_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Omweegya, Musa akaturagania, ‘Eraabhe omuutu akuuri, na atigiri mukaaye akyaari kwiibhura, wamwaabhu amugabhe omutuumba wuyo, okubha amwiibhurire wamwaabhu omwaana.’ ");
INSERT INTO zak_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bhoono, tubhuge bhaari bhariho abhahiiri muhuungati. Wo okutaanga akakweera omukari, nawe akakwa akabha akyaari kwiibhura mwaana. ");
INSERT INTO zak_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Omusuuhu waaye wuyo wa kabhiri akamugabha omukari wuyo, nawe neewe akakwa, ataatigiri mwaana. Ekabha egoego ku wa katatu. ");
INSERT INTO zak_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bhoosi bhasaasabha bhano bhakamugabha na wuno yamukweeriri omukari wuyo, bhakakwa, bhataatigiri mwaana. Mubhuteero, omutuumba wuyo woosi akakwa. ");
INSERT INTO zak_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ambe otubhuurire, eraabhe obhuryoori bhurabhaho, omutuumba wuyo arabha omukari wawi? Bhoosi muhuungati bharya bhakamukweera no okumugabha.” ");
INSERT INTO zak_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeesu akabhabhuurira, “Emwe muhabhiri bhukongʼu, kwo okubha mutamenyiri gano gakaamirwe mu Makaamo Amahoreeru, kweeki mutamenyiri obhunagya bhwa Taatabhugya kyeego bhuri. ");
INSERT INTO zak_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hano abhaku bharaaryooke, bhatakukweera naabhe okukweerwa. Nawe bharabha kya bhamaraika bha mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nawe, iguru yo okuryooka kwa abhaku, mukyaari kusoma mukitabhu kya Musa, kyeego Taatabhugya akagaamba harya mukisaka kino kikwaaka omuriro? Harya, Taatabhugya akamubhuurira Musa, ‘Enye ni Taatabhugya wa Aburahamu, Isaaka na Yaakobo.’ ” ");
INSERT INTO zak_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ambe, Yeesu akageenderera kubhuga, “Taatabhugya atari Taatabhugya wa abhaku, nawe ni Taatabhugya wa abhahoru. Emwe muhabhiri bhukongʼu.” ");
INSERT INTO zak_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hano Yeesu yaakuhakana na Abhasadukayo, omweegya wumwe we emigiro gya Musa akahika, akiigwa kino bhakuhakana. Hano yiigwiiri kubha Yeesu abhakyooriri bhuzomu, akamubhuurya, “Mubhuswaagyo bhwoosi, ni bhuuhe obhuswaagyo bhwo okutaanga?” ");
INSERT INTO zak_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yeesu akamukyoora, “Bhwo okutaanga nibhwo bhuno, ‘Mwiitegeerere emwe Abhiiziraeri! Omukuru, Taatabhugya weetu, niwe Omukuru omweene. ");
INSERT INTO zak_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Museege Omukuru, Taatabhugya waazo, kwo omutima gwaazo gwoosi, kwe ekoro yaazo yoosi, kwa amangʼeeni gaazo goosi na kwa amanaga gaazo goosi.’ ");
INSERT INTO zak_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","No obhuswaagyo bhwa kabhiri nibhwo bhuno, ‘Omuseege omurikyaazo, kyeego wiiseegiri omweene.’ Bhutariho obhuswaagyo obhuundi obhukuru kukira obhubhiri bhuno.” ");
INSERT INTO zak_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Omweegya we emigiro wuyo akamubhuurira Yeesu, “Omweegya, ogaambiri eheene kubha Taatabhugya ni wumwe ego, atariho wuundi, nawe ewe omweene. ");
INSERT INTO zak_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kweeki nimenyiri kubha ereenderwa okumuseega Taatabhugya kwo omutima gwoosi, kwa amangʼeeni goosi na kwa amanaga goosi, no okumuseega omurikyaazo kyeego wiiseegiri omweene. Bhuyo nibhwo obhuswaagyo obhukuru bhukongʼu. Amangʼana gano ni makuru kukora kukira okuruusya ekimweeso kyoosi kyo okusikya ne ebhimweeso ebhiindi bhyoosi.” ");
INSERT INTO zak_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hano Yeesu yaruuzi omuutu wuyo akyooriri kwa amangʼeeni, akamubhuurira, “Awe otari kure okusikira mubhutemi bhwa Taatabhugya.” Kweema eriibhaga riyo, ataari ariho omuutu naabhe wumwe wuno akasakya okumubhuurya Yeesu amabhuuryo. ");
INSERT INTO zak_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Hano Yeesu yaari akubheegya abhaatu mwiiseengerero, akabhabhuurira, “Kwaki abheegya bhe emigiro gya Musa bharabhuga Masiya ni mwaana wo omutemi Daudi? ");
INSERT INTO zak_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daudi omweene hano yakaangatiibhwe ne Ekoro Muhoreeru, akabhuga, ‘Omukuru, Taatabhugya akamubhuurira Omukuru waane, “Wiikare orubhaara rwaane rwo obhuryo, tee hano nikutuura abhabhisa bhaazo iyaasi wa amaguru gaazo.” ’ ");
INSERT INTO zak_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi omweene aramubhirikira Masiya, ‘Omukuru,’ bhoono erabhabhwi Masiya abhe omwaana waaye kweeki?” Esaango ekuru ya abhaatu bhaari bharamwiitegeerera Yeesu kwo obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mumeegyo gaaye, Yeesu akabhuga, “Mwiiriihe na abheegya bhe emigiro gya Musa. Bhano bhakuseega kugeenda kunzira bhiibhohiri emyeenda gyaabhu emitaambi, no okukeeribhwa kwo obhusuuku mumiteera. ");
INSERT INTO zak_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kweeki, muziinyuumba zye eziisaango, bharaseega kwiikara kubhituumbi bhye embere. Ne eraabhe bhabharaarikiri muziinyaangi, bharaseega kwiikara hano abhagini bho obhusuuku bhakwiikara. ");
INSERT INTO zak_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bharabhateesya abhatuumba eziinyuumba zyaabhu. Na bhariiyeerekya kubhaatu kwo okusabha amasabhi mataambi bhukongʼu embere wa abhaatu. Murusiku rwo okutina ekiina, abhaatu bhayo bharabhona obhutemwa bhukuru okurwa ku Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yeesu akiikara haguhi ne ehuunguro ye ekimweeso mwiiseengerero rya Taatabhugya. Yaari ararora abhaatu bharatuura ekimweeso muhuunguro ye ekimweeso. Abhaniibhi bhaaru bhaari bharatuura eziimbirya nzaru. ");
INSERT INTO zak_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Akaaza omutuumba wumwe omutaka, neewe yaruusirye amazeenzere abhiri ego. ");
INSERT INTO zak_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Hano Yeesu yaruuzi gayo, akabhabhirikira abhaanabheega bhaaye, akabhabhuurira, “Ndabhabhuurira obhuheene, omutuumba omutaka wuyo, atuuriri eziimbirya nzaru muhuunguro kukira bhoosi bhano bhatuuriri. ");
INSERT INTO zak_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bhoosi bhano bhatuuriri ebhimweeso bhisuuhu ego kubhyaaru bhye ebhigiro bhyaabhu. Nawe omutuumba wuno ni mutaka bhukongʼu neewe atuuriri bhyoosi bhino yaari kwiisigira mubhwiikari bhwaaye.” ");
INSERT INTO zak_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Hano Yeesu yarwiiri mwiiseengerero rya Taatabhugya hamwe na abhaanabheega bhaaye, omwaanamweega waaye owumwe akabhuga, “Omweegya, ogaroreerere amagina amakuru gano na amakiindaasi amakuru gano kyeego gakuruguurya!” ");
INSERT INTO zak_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeesu akamukyoora, “Oragarora amakiindaasi gano amakuru? Ritariho eriigina rino riraatame iguru we eriindi, goosi garagwiisibhwa!” ");
INSERT INTO zak_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Hano Yeesu yaari yiikeeri mu Kiguru kye Emizeituni, obhweema bhwe eriiseengerero rya Taatabhugya, Petero, Yaakobo, Yohana na Andurea bhakaaza kweewe. Bhakamubhuurya hano bhaari abheene ego, ");
INSERT INTO zak_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Turasabha otubhuurire, gano okubhuga garatuuka ryoori? Ni kyeerekenioki kino kireerekye kubha, gayo gari haguhi kutuukira?” ");
INSERT INTO zak_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Niho Yeesu akataanga kubhabhuurira, “Mwiiriihe, omuutu wowoosi ataaza kubhangʼeena! ");
INSERT INTO zak_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abhaatu bhaaru bharaaza bhakuhokeerya eriina ryaane, bharabhuga, ‘Enye neenye Masiya!’ Abhaatu bhayo bharangʼeena abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Hano emwe mukwiigwa amangʼana ge eriihi no obhuzuuzumi bhwe eriihi, mutoobhoha. Gayo gareenderwa kutuukira, nawe obhuteero bhwe ekyaaro bhurabha bhukyaari. ");
INSERT INTO zak_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ekyaaro kimwe kirarwaana ne ekyaaro ekiindi, obhutemi obhumwe bhurarwaana no obhutemi obhuundi. Kurabha ne ebhirigito bhye esi bhya hano na harya, na ahagiro ahaandi harabha ne enzara. Gayo garabha kyo obhweemero bhwo obhusuungu bhwo omukari wuno akweenda okwiituurania. ");
INSERT INTO zak_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nawe emwe, mwiiriihe bhukongʼu. Abhaatu bharabhahira mwiibaraza no okubhatema bhubhi muziinyuumba zye eziisaango. Bharabhahira kubhaanaangwa bhe ekyaaro na kubhatemi, kwe ekigirirye muniikiriirye enye. Eriibhaga riyo, rirabha ryo obhumenyeekererya bhwa Amangʼana Amazomu kweebho. ");
INSERT INTO zak_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amangʼana Amazomu gareenderwa garwaazirwe hiinga kubhaatu bhe ebhyaaro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hano abhaatu bhayo bharaabhagwaate no okubhahira mwiibaraza no okubhatinira ekiina, mutanyaaka okwiiseega kyeego muraagaambe. Mugaambe gano Taatabhugya akubhaha eriibhaga riyoriyo. Etari emwe abheene bhano mukugaamba, eheene ni Koro Muhoreeru wuno ari muusi weenyu wuno akugaamba kuhitira kweemwe. ");
INSERT INTO zak_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Kwe eriibhaga riyo, omuhiiri aramutuura omuhiiri waaye mumabhoko ga abhabhisa okubha yiitwe. Kweeki, taata aramutuura omwaana mumabhoko ga abhabhisa okubha yiitwe. Abhaana nabho bharabharwaania abhiibhuri bhaabhu no okugirya bhiitwe. ");
INSERT INTO zak_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Abhaatu bhoosi bharabhabhiihirirya kwe ekigirye kyo okubha emwe ni bhaanabheega bhaane. Nawe, wowoosi wuno araagumire tee obhuteero, niwe araatuuribhwe.” ");
INSERT INTO zak_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Omuutu wuno akusoma amakaamo gano, amenye obhugazuro bhwa amarekyo ga Yeesu gano, “Eriibhaga eriirebhe murarora eriibhiihiriryo rirya rino rikureeta amakire, riimeereeri muusi we enyuumba ehoreeru, hano ritakweenderwa kubhaho. Niho abhaatu bhano bhakwiikara mukyaaro kya Yudea, bhangʼosere mubhiguru! ");
INSERT INTO zak_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Omuutu wuno ari iguru kukisara, atasakya kwiika iyaasi no okusikira munyuumba kugega ekigiro kyokyoosi, yiike angʼose! ");
INSERT INTO zak_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Omuutu wuno akubha mumuguundu, ewe angʼose, atakyoora yiika okugega ekabhuuti yaaye! ");
INSERT INTO zak_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Turabharorera ebhigoongi, abhakari bhano bharitohiri na bhano bhakukookya muziisiku ziyo. ");
INSERT INTO zak_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Musabhe kubha, eziisiku ziyo zitabha mwiibhaga rya nyamabheho. ");
INSERT INTO zak_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eziisiku ziyo zirabha zye eziinyaako kya ziyo, zikyaari kutuuka kweema hano Taatabhugya yateemiri ekyaaro tee reero yino. Na zitakutuuka eziinyaako kya ziyo kweeki. ");
INSERT INTO zak_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ne eraabhe, Omukuru, Taatabhugya atiingasuuhirye eziisiku ziyo zibhe suuhu, atiingabheeriho omuutu wowoosi wuno yiingatuuriibhwe. Nawe Taatabhugya asuuhirye eziisiku ziyo, kwo okubha aramura abhaatu bhano abhasoriri. ");
INSERT INTO zak_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Eriibhaga riyo, omuutu wowoosi akubhabhuurira, ‘Rora, Masiya ari hano!’ kasi owuundi arabhuga, ‘Rora, ari harya!’ mutamwiikirirya. ");
INSERT INTO zak_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bharabhaho abharooti bho orurimi na abhaatu bhano bhakwiibhirikira kubha ni Masiya. Bhareerekya ebhyeerekenio ne ebhiruguuro, okubha bhasakye okubhangʼeena abhaatu, eraabhe eraturikana naabhe bhano bhasorirwe na Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ambe emwe, mwiiriihe! Enye nikaangatiri okutaanga okubharekya goosi gayo gakyaari kutuukira. ");
INSERT INTO zak_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nawe, muziisiku zirya, hano enyaako yiyo ekuhita, eryoobha riratuurirwa ekiirima no omweeri nagwo gutakuruusya obhweero bhwaku, ");
INSERT INTO zak_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ne eziinzota ziragwa haasi okurwa kwiisaaro. Taatabhugya arabhisiingisya ebhigiro bhyoosi bhya mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Niho, abhaatu bhoosi bharaandore enye Omwaana wo Omuutu, nikuuza mumasaaro kwo obhuturo bhwaaru no obhuguungo. ");
INSERT INTO zak_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ndabharagania bhamaraika bhaane bhakumanie abhasorwa bhaane okurwa mbaara zyoosi zye ekyaaro, okurwa obhweemero bhwe ekyaaro, tee obhuteero bhwa mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yeesu akageenderera kugaamba, “Mweege amangʼana ge ekireengyo okurwa kumuti gwo omutiini. Hano mukurora amatu garasibhuka na amasagya garabharya amatu, nikyo ekigirirye kyo okumenya kubha eriibhaga rya amaahu rihikiri. ");
INSERT INTO zak_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Egoego na neemwe, hano muraarore gayo gataangiri kukorwa, mumenye kubha niri haguhi kuuza. ");
INSERT INTO zak_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ndabhabhuurira obhuheene, orwiibhuro runo rutakuhita, tee gano goosi garaamarwe kukorwa. ");
INSERT INTO zak_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Eriisaaro ne ekyaaro bhirahweerera, nawe amangʼana gaane gatakuhweerera na rumwe. ");
INSERT INTO zak_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nawe, iguru wa amangʼana go orusiku ne eriibhaga runo Omwaana wo Omuutu araaze, atariho omuutu wuno amenyiri. Naabhe bhamaraika bha mwiisaaro, naabhe Omwaana, bhoosi bhatamenyiri, nawe Taata niwe amenyiri. ");
INSERT INTO zak_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kweego, mwiiriihe! Mwiibhanure, mubhe murasabha kwo okubha mutamenyiri eriibhaga riyo rirahika ryoori. ");
INSERT INTO zak_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Okuuza kwo Omwaana wo Omuutu, kuratuubhana no omuutu wuno akugya orugeendo okurwa owaaye. Akabhatigira abhagya bhaaye bhariibhe enyuumba. Akabhatwaanira bhoosi emirimo gyaabhu gyo okukora, akumuswaagya omuriibhi wa kukiseku kubha, ateengeeze.” ");
INSERT INTO zak_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yeesu akageenderera okugaamba, “Emwe, muteengeeze, kwo okubha mutamenyiri mweene nyuumba arakyoora ryoori. Mutamenyiri eraabhe arakyoora engoroobha, kasi obhutiku gati, kasi etabhoori zuri, kasi izo. ");
INSERT INTO zak_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Muteengeeze, okubha hano akuuza kituukiro, atabhabhona muhiindiiri tiro. ");
INSERT INTO zak_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Rino nikubhabhuurira emwe, ndabhabhuurira abhaatu bhoosi, bhateengeeze.” ");
INSERT INTO zak_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Zikasaaga eziisiku ibhiri ego, ebhe Enyaangi yo Okuhiita ne Enyaangi ye Emikaate Gino Gitana Ekibhwiisya. Abhakuru bha abhaseengeri na abheegya bhe emigiro gya Musa bhaari bharamoohya enzira yo okumugwaata Yeesu kwa mbiso, bhamutinire ekiina no okumwiita. ");
INSERT INTO zak_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nawe bhakabhuga, “Tutige hiinga enyaangi ehite, niho tumugwaate, abhaatu bhataaza kukora orwaambi.” ");
INSERT INTO zak_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Eriibhaga riyo Yeesu yaari mumugye gwa Betania, munyuumba ya Simooni wuno ekare yaari ne ebhigeenge. Hano yaari kwiigari kurya, akaaza omukari owumwe yaari ne enzubha yino yakorirwe kwe eriigina rya arabasita ryo obhuguri bhukuru. Muusi we enzubha yiyo kwaari na amaguta go omuruumbaaso gano gano obhuguri bhukuru bhukongʼu. Omukari wuyo akamwiituruurira Yeesu kumutwe kwo okumusuuka. ");
INSERT INTO zak_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abhamwe bhano bhaari munyuumba yirya, bhakatiinda. Bhakataanga okugaamba ebho kwe ebho, “Bhamure! Kwaki omukari wuno arasarya amaguta go obhuguri bhukuru ego? ");
INSERT INTO zak_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Amaguta gano gaanganagirye okuguribhwa kwe eziidinaari amagana atatu (300) na ziingasakiirye abhataka!” Bhaari bharamurekya bhukongʼu omukari wurya. ");
INSERT INTO zak_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nawe, Yeesu akabhuga, “Mumutige. Ndora muramunyaakya? Rino omukari wuno anikoreeri enye ni izomu bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abhataka bhari hamwe neemwe eziisiku zyoosi. Muranagya okubhakorera amazomu eriibhaga ryoryoosi rino mukuseega. Nawe enye nitakubha hamwe neemwe eziisiku zyoosi. ");
INSERT INTO zak_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Omukari wuno akoriri rino akunagya. Akaangatiri okunihaka omubhiri gwaane amaguta gano, kwo obhubhanuri bhwo okubhiikwa kwaane. ");
INSERT INTO zak_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndabhabhuurira obhuheene, mukyaaro kyoosi, hohoosi hano abhaatu bhakubha bhararwaaza Amangʼana Amazomu, bharabha bharabhuga eriingʼana rino omukari wuno yakoriri, okumuhiita.” ");
INSERT INTO zak_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Niho Yuuda Isikariyoti, owumwe wa abhaanabheega bharya ikumi na bhabhiri bha Yeesu, akagya okumurya omukoonyo kubhakuru bha abhaseengeri, abheerekye enzira yo okumugwaata Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hano bhiigwiiri amangʼana gayo, bhakazomererwa bhukongʼu. Bhakiikirirania neewe kubha bharamuha eziimbirya. Niho Yuuda akataanga okumoohya eriibhaga izomu ryo okumurya omukoonyo. ");
INSERT INTO zak_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Rwaari orusiku rwo okutaanga rwe Enyaangi ye Emikaate Gino Gitana Ekibhwiisya, orusiku runo abhaatu bhaari bharagwaaga engʼoondu ye Enyaangi yo Okuhiita. Abhaanabheega bha Yeesu bhakamubhuurya, “Bhoono oreenda tugye tukubhanurire hayi ahagiro ho okuriira ebhyaakurya bhye Enyaangi yo Okuhiita?” ");
INSERT INTO zak_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Niho Yeesu akabharagania abhaanabheega bhabhiri, akabhabhuurira, “Mugeende mumugye. Muraasikane no omusubhe wumwe wuno agegiri eseengo ya amaanzi, mumutuniirire eno akugya. ");
INSERT INTO zak_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Munyuumba yino araasikire, mugye mumubhuurire mweene nyuumba, ‘Omweegya arasabha otweerekye hano araariire ebhyaakurya bhye Enyaangi yo Okuhiita hamwe na abhaanabheega bhaaye.’ ");
INSERT INTO zak_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Niho mweene nyuumba araabheerekye ekyuumba ekikuru mukinazo, kimariri kubhanurwa. Mutubhanurire muyo, turiire ebhyaakurya bhye Enyaangi yo Okuhiita.” ");
INSERT INTO zak_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abhaanabheega bharya bhakatanura, bhakagya mumugye gwa Yerusaremu. Bhakabhona goosi kyeego Yeesu yabhabhuuriiri, bhakabhanura ebhyaakurya bhye Enyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hano yahikiri engoroobha, Yeesu akahika munyuumba yirya hamwe na abhaanabheega bhaaye ikumi na bhabhiri. ");
INSERT INTO zak_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hano bhaari kurya, Yeesu akabhuga, “Ndabhabhuurira obhuheene, owumwe weenyu wuno akurya hamwe neenye hano, aranirya omukoonyo.” ");
INSERT INTO zak_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Abhaanabheega bhaaye bhakabha ne ebhigoongi. Bhakamubhuurya Yeesu, owumwe kwo owumwe, “Neenye Omukuru?” ");
INSERT INTO zak_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yeesu akabhabhuurira, “Ni wumwe weenyu gati yi ikumi na bhabhiri, wuno akukorya hamwe neenye mukitubha. ");
INSERT INTO zak_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Enye Omwaana wo Omuutu, ndiitwa kyeego yakaamirwe mu Makaamo Amahoreeru. Nawe, araaza kurora omuutu wuno araanirye omukoonyo enye Omwaana wo Omuutu. Yiingabheeri hakiriku kweewe omuutu wuyo atiingibhwiirwe!” ");
INSERT INTO zak_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hano bhaari bhakurya, Yeesu akagega omukaate, akabhuga, “Ozomirye, Taatabhugya.” Akagubhega, akabhaha abhaanabheega bhaaye, akabhuga, “Mugege, murye, guno nigwo omubhiri gwaane.” ");
INSERT INTO zak_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kyaamwe akagega ekikoombe kya amaanzi go omuzabibu, akabhuga, “Ozomirye, Taatabhugya,” akabhaha abhaanabheega bhaaye, bhoosi bhakanywa mukikoombe kiyo. ");
INSERT INTO zak_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Akabhabhuurira, “Gano ni manyiinga gaane ge eriiragano, gano gakwiitika kwiiguru wa abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ndabhabhuurira obhuheene, okurwa reero, nitakunywa amaanzi go omuzabibu tee orusiku runo ndaanywe kwe enzira ehya mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kyaamwe bhakeemba omweembo gwo okukumya Taatabhugya. Hano bhaamariri okweemba, bhakatanura, bhakagya mu Kiguru kye Emizeituni. ");
INSERT INTO zak_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hano bhaari munzira, Yeesu akabhabhuurira abhaanabheega bhaaye, “Emwe mwoosi muraaningʼosa munitige kugano garaatuuke. Garabha kyeego Taatabhugya akabhuga mu Makaamo Amahoreeru, ‘Ndamwiita omuriisya we eziingʼoondu, ne eziingʼoondu zyaaye ziranyaragana.’ ");
INSERT INTO zak_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nawe hano ndaaryookibhwe, ndabhakaangatira kugya Gariraaya.” ");
INSERT INTO zak_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Niho Petero akamubhuurira, “Naabhe abharikyaane bhoosi bharaakutige, enye nitakukutiga!” ");
INSERT INTO zak_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yeesu akamubhuurira, “Ndakubhuurira obhuheene, obhutiku bhuno bhwa reero, ekorokoome ekyaari kugaamba kabhiri koosi, orabha omariri kunianga katatu koosi.” ");
INSERT INTO zak_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nawe Petero akageenderera kukumiirirya akabhuga, “Yiingabha okukwa, nikwe hamwe naawe, enye nitakukwaanga eheene!” Abhaanabheega abhaandi bhoosi nabho, bhakabhuga egoego. ");
INSERT INTO zak_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kyaamwe bhakahika mumuguundu guno gukubhirikirwa Getisemane. Yeesu akabhabhuurira abhaanabheega bhaaye, “Mwiikare hano, hano nikubha ndamusabha Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Akabhagega Petero, Yaakobo na Yohana, akagya nabho kure hasuuhu, akataanga kubha ne ebhigoongi bhukongʼu no okuyaangayaanga mukoro. ");
INSERT INTO zak_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Akabhabhuurira, “Ekoro yaane ene ebhigoongi bhyaaru haguhi no okukwa. Mwiikare hano, muteengeeze.” ");
INSERT INTO zak_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yeesu akageenderera embere hasuuhu, akagwa bhubhuumari. Akasabha, “Eraaturikane, oniruusiryeho nitahitira eziinyaako zino.” ");
INSERT INTO zak_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Akabhuga, “Ee Taata, kwaawe goosi garaturikana. Ndakusabha onduusiryeho eziinyaako zino. Etari kyeego enye nikweenda, nawe okore kyeego awe okweenda.” ");
INSERT INTO zak_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ambe, Yeesu akakyoora hano yaari atigiri abhaanabheega bhaaye, akabhona bhahiindiiri eziitiro. Akamubhuurya Petero, eriina ryaaye eriindi Simooni, “Simooni, ohiindiiri eziitiro? Otamirwe kuteengeeza naabhe kwe esa yimwe eyeene?” ");
INSERT INTO zak_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niho akabhabhuurira, “Muteengeeze no okumusabha Taatabhugya, okubha mutaaza kusakibhwa. Ekoro ereenda nawe omubhiri ni munyookobhu.” ");
INSERT INTO zak_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yeesu akatanura, akagya kusabha kibhezo, akiinuurya kusabha amangʼana garyagarya. ");
INSERT INTO zak_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ambe, hano yakyooriri kubhaanabheega bhaaye, akabhabhona bhahiindiiri eziitiro kweeki, kwo okubha bhataanagirye kuramukya ameeso gaabhu. Hano yabhabhuukirye, bhataari na ngʼana yo okugaamba. ");
INSERT INTO zak_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yeesu akagya kusabha kweeki. Hano yakyooriri kweebho rugeendo rwa katatu, akabhabhuurira, “Ndora mukyaari muhiindiiri no okumuunya? Ambe yiisiri. Eriibhaga rye enyaako ryaane rihikiri. Bhoono, enye Omwaana wo Omuutu ndagwaatwa no okuhirwa kubhakori bhe ebhibhi. ");
INSERT INTO zak_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mwiimuke, tugye. Murore! Omuri waane wo omukoonyo ari haguhi!” ");
INSERT INTO zak_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Hano Yeesu yaari akyagaamba gayo, hayohayo Yuuda, owumwe wa abhaanabheega ikumi na bhabhiri, akahika ne esaango ya abhaatu bhe eziinyaambato ne eziinduguzo. Abhaatu bhayo bhakarweera kubhakuru bha abhaseengeri, abheegya bhe emigiro gya Musa na abhakaruka bha Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuuda omuri wo omukoonyo, yaari abhaheeri ekyeerekenio, akabhuga, “Omuutu wuno ndaamukeerye kwo okumuhuumbata, niwe wuyo. Mumugwaate no okugya neewe, mumutuure abhe mubhuriibhi.” ");
INSERT INTO zak_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hano Yuuda yahikiri harya, akagya bhweema ku Yeesu, akabhuga, “Omweegya!” Kyaamwe akamuhuumbata. ");
INSERT INTO zak_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Abhaatu bharya bhakamugwaata Yeesu no okumubhoha. ");
INSERT INTO zak_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Niho, omuutu wumwe gati wa bharya bhaari bhiimeereeri hamwe na Yeesu, akasohora nyaambato, akamutema no okumutina okutwi omugya wo omuseengeri omukuru. ");
INSERT INTO zak_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yeesu akabhabhuurira abhaatu bharya, “Mbe, mwiiziri ne eziinyaambato ne eziinduguzo okunigwaata kyo omuteesya? ");
INSERT INTO zak_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Eziisiku zyoosi niari hamwe neemwe, ndeegya mwiiseengerero rya Taatabhugya, na mutaangwaatiri. Nawe gano goosi gaatuukiri okubha gano gaakaamirwe mu Makaamo Amahoreeru, gakorwe.” ");
INSERT INTO zak_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Niho abhaanabheega bhaaye bhoosi bhakangʼosa, bhakamutiga. ");
INSERT INTO zak_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwaari no omumura wumwe wuno yiibhohiri eshuuka eyeene, yaari aramutuna Yeesu. Bhakasakya kumugwaata, ");
INSERT INTO zak_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nawe, akasusubhuka mumabhoko, akatiga engibho yaaye, akaryaara ndyaari ari kingʼaabhi. ");
INSERT INTO zak_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Niho abhaatu bharya bhakamuhira Yeesu kumuseengeri omukuru. Bhakiikumania harya abhakuru bha abhaseengeri bhoosi, abhakaruka bha Abhayahudi na abheegya bhe emigiro gya Musa. ");
INSERT INTO zak_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petero akabha aramutuniirira Yeesu kwa kure. Akagya, akasikira mwiibhaanza rye enyuumba yo omuseengeri omukuru. Akiikara murya hamwe na abhariibhi bho omuseengeri omukuru, akabha aroota omuriro. ");
INSERT INTO zak_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abhakuru bha abhaseengeri ne ekiina ekikuru kyoosi bhakakomya abhamenyeekererya bho orurimi bhamuzoongere Yeesu, okubha bhamutinire ekiina no okumwiita. Nawe, bhatabhweeni obhumenyeekererya bhwobhwoosi. ");
INSERT INTO zak_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abhaatu bhaaru bhaari bhararuusya obhumenyeekererya bhwo orurimi okumuzoongera Yeesu, nawe obhumenyeekererya bhwaabhu bhutaari bhuriigwaana. ");
INSERT INTO zak_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kyaamwe, abhaatu abhaandi abharebhe bhakiimeerera, bhakaruusya obhumenyeekererya bhwo orurimi. Bhaari bharabhuga, ");
INSERT INTO zak_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Etwe abheene tukamwiigwa omuutu wuno arabhuga, ‘Enye ndasarya eriiseengerero rya Taatabhugya rino ryoombokirwe na abhaatu. Kweeki, ndoomboka eriindi kwe eziisiku isatu ego. Eriiseengerero riyo ritakwoombokwa na abhaatu.’ ” ");
INSERT INTO zak_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Naabhe ego, obhumenyeekererya bhwaabhu bhutaari bhuriigwaana. ");
INSERT INTO zak_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kyaamwe omuseengeri omukuru akiimeerera embere we ekiina. Akamubhuurya Yeesu, “Ndora, otakukyoora eriingʼana ryoryoosi? Angu, orabhugabhwi kumangʼana gano abhaatu bhakukuzoongera?” ");
INSERT INTO zak_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nawe Yeesu akakira kiri, ataagaambiri eriingʼana ryoryoosi. Omuseengeri omukuru akageenderera okumubhuurya, “Mbe, awe naawe Masiya, Omwaana wa Taatabhugya wuno akukumibhwa?” ");
INSERT INTO zak_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu akamukyoora, “Enye niwe. Na neemwe muraandora enye Omwaana wo Omuutu, ndabha niikeeri orubhaara rwo obhuryo rwa Taatabhugya wo obhunagya bhwoosi. Kweeki muranirora eriibhaga nikuuza kureka mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Niho omuseengeri omukuru akangʼaarura eziingibho zyaaye, akabhuga, “Ni bhamenyeekererya bhaahe kweeki bhano tukweenda? ");
INSERT INTO zak_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwiigwiiri emwe abheene kyeego akumutuka Taatabhugya! Bhoono emwe, murabhugabhwi?” Ekiina kyoosi kikabhuga areenderwa yiitwe. ");
INSERT INTO zak_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Niho abhaandi bhakataanga okumutweera amate, okumubhoha mubhusyo no okumutema ebhikuundi, eno bharamubhuurira, “Roota ni weewi wuno akutemiri!” Abhariibhi bhano bhaari harya, bhakamugega no okumutema eriigoohu. ");
INSERT INTO zak_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Eriibhaga riyo ryoosi, Petero yaari mwiibhaanza, iyaasi we ekyuumba hano Yeesu yaari akubhuuribhwa. Akaaza omuhokya owumwe omuukya okurwa mubhahokya bho omuseengeri omukuru. ");
INSERT INTO zak_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Akamurora Petero aroota omuriro, akamumogorera. Akamubhuurira, “Awe woosi waari hamwe na Yeesu Omunazareeti.” ");
INSERT INTO zak_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nawe Petero akaanga, akubhuga, “Nitagamenyiri gano okubhuga, naabhe hasuuhu!” Akagya mukiseku. Eriibhaga riryarirya, ekorokoome ekagaamba. ");
INSERT INTO zak_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Omukari omuhokya wurya, akamurora Petero kweeki, akataanga kubhabhuurira abhaatu bhano bhaari bhiimeereeri harya, “Omuutu wuno neewe ari hamwe nabho.” ");
INSERT INTO zak_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nawe, Petero akaanga kweeki. Rikahita eriibhaga isuuhu, abhaatu bhano bhaari bhiimeereeri harya bhakamubhuurira Petero, “Eheene awe waari owumwe waabhu, kwo okubha awe woosi ni Mugariraaya.” ");
INSERT INTO zak_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nawe, Petero akataanga okwiihiima na okwiirahira, “Omuutu wuno mukubhuga, enye nitamumenyiri!” ");
INSERT INTO zak_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hayohayo, ekorokoome ekagaamba rugeendo rwa kabhiri. Eriibhaga riyo, Petero akahiita engʼana ya Yeesu yino yamubhuuriiri, “Ekorokoome ekyaari kugaamba rugeendo rwa kabhiri, orabha omariri kunianga katatu koosi.” Petero hano yiiseegiri gayo, akarira, akaruusya eziingusuri nzaru. ");
INSERT INTO zak_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hano kwakiiri ego, ekiina kyoosi kya abhakuru bha abhaseengeri, abhakaruka bha Abhayahudi, na abheegya bhe emigiro gya Musa, bhakiikara hamwe, bhakakora obhuzaabhi. Bhakamubhoha Yeesu, bhakamuhira ku Pirato. ");
INSERT INTO zak_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pirato akamubhuurya Yeesu, “Awe naawe omutemi wa Abhayahudi?” Yeesu akamukyoora, “Naawe ogaambiri.” ");
INSERT INTO zak_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abhakuru bha abhaseengeri bhaari bharamuzoongera Yeesu kubha, akoriri amabhi maaru. ");
INSERT INTO zak_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pirato akamubhuurya kweeki, akabhuga, “Otakukyoora ryoryoosi? Rora kyeego bhakukuzoongera kumabhiihu maaru.” ");
INSERT INTO zak_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nawe Yeesu ataamukyooriri ryoryoosi. Niho Pirato akaruguura. ");
INSERT INTO zak_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Eriibhaga rye Enyaangi yo Okuhiita, Pirato yaari arabhiigurira omubhohwa wumwe, wuno abhaatu bhaamusabhiri ahaatirwe. ");
INSERT INTO zak_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eriibhaga riyo munyuumba ya abhabhohwa bhaari bhariho abhaatu bhano bhaakoriri obhwaangi no obhwiiti mubhwaangi bhwaabhu. Owumwe wa abhiiti bhayo yaari arabhirikirwa Baraaba. ");
INSERT INTO zak_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Esaango ekuru ya abhaatu bhakagya ku Pirato, bhakamusabha abhiigurire omubhohwa wumwe, kyeego akanara kukora. ");
INSERT INTO zak_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pirato akabhabhuurya, “Bhoono, mureenda nibhiigurire omutemi wa Abhayahudi?” ");
INSERT INTO zak_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Akabhuga ego kwo okubha akamenya kubha abhakuru bha abhaseengeri bhaamugwaatirye Yeesu kweewe, kwiiguru yo omugono gwaabhu ogweene ego. ");
INSERT INTO zak_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Niho abhakuru bha abhaseengeri bhakasiigirirya esaango ya abhaatu yirya, emusabhe Pirato abhiigurire Baraaba. ");
INSERT INTO zak_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pirato akabhabhuurya kweeki, “Bhoono ambe, mureenda nikoreki omuutu wuno mukugaamba ni mutemi wa Abhayahudi?” ");
INSERT INTO zak_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Abhaatu bhoosi bhakiitabha kwe ekituri kweeki, bhakabhuga, “Mumubhaambe kumusaraba!” ");
INSERT INTO zak_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pirato akabhabhuurya, “Akoriri isaryaki rino rigirirye abhaambwe kumusaraba?” Niho ebho bhakahaara bhukongʼu okutema ekituri, bhakabhuga, “Mumubhaambe kumusaraba!” ");
INSERT INTO zak_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pirato yaari areenda okuyizomeerya esaango ya abhaatu, kweego akabhiigurira Baraaba. Kyaamwe, akaswaagya bhamuteme Yeesu emijariti. Kimwe akaragania agegwe, atemererwe kumusaraba. ");
INSERT INTO zak_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abhasirikare bhakamugega Yeesu, bhakagya neewe mukiina ekikuru munyuumba yo omwaanaangwa Pirato. Bhakakumania abhasirikare abhaandi bhoosi. ");
INSERT INTO zak_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakamwiibhohya Yeesu omweenda gwe ezambaraau yo obhutemi. Bhakoogosa orusuurya rwa amahwa, bhakamwiibhohya kumutwe. ");
INSERT INTO zak_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakataanga okumukeerya kwe enzeero, “Kasiinga rugabho, omutemi wa Abhayahudi!” ");
INSERT INTO zak_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhaari bharamutema kumutwe na maara no okumutweera amate, bhaari bharamuhigamira kwo okumukumya. ");
INSERT INTO zak_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Hano abhasirikare bhayo bhaamariri okumuzibhura, bhakamuruusya omweenda gwe ezambaraau yirya, no okumwiibhohya kweeki eziingibho zyaaye. Kyaamwe, bhakagya neewe okumubhaamba kumusaraba. ");
INSERT INTO zak_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Munzira, bhakasikana no omuutu wuno yaari arahita mumugye okurwa mumuguundu, eriina ryaaye Simooni, yaari omwiikari wa Kirene. Omuutu wurya yaari wiise waabhu Arekizanda na Rufo. Abhasirikare bhakamusingʼirirya okugega omusaraba gwa Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bhakamuhira Yeesu hano haabhirikiirwe Gorigota, obhugazuro bhwaku ni Kihaanga kyo Omutwe. ");
INSERT INTO zak_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bhakamuha Yeesu amaanzi go omuzabibu gano bhasaangiinie na manemane, nawe ewe akaanga okunywa. ");
INSERT INTO zak_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Niho bhakamubhaamba kumusaraba, na bhakatwaana eziingibho zyaaye. Bhakatema obhwiitoori ni weewi araagege ngibhoki. ");
INSERT INTO zak_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eriibhaga rya katatu etabhoori, niho bhaamubhaambiri kumusaraba. ");
INSERT INTO zak_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kumusaraba bhakatuura amakaamo go obhuzoongeri bhwaaye, gaari garabhuga, “Omutemi wa Abhayahudi.” ");
INSERT INTO zak_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bhakamubhaamba hamwe na abhateesya abhabhiri kumisaraba, owumwe orubhaara rwaaye rwo obhuryo no owuundi orubhaara rwo obhumosi.  ");
INSERT INTO zak_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Niho gakakuunaana Amakaamo Amahoreeru gano gakubhuga, “Akabharwa hamwe na abhatemya bhe ebhibhi.” ");
INSERT INTO zak_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abhaatu bhano bhaari bhakuhita kunzira yiyo, bhaari bharamutuka kwo okusiingisya emitwe gyaabhu, bharabhuga, “Aa! Awe, okabhuga oragwiisya eriiseengerero no okwoomboka kwa siku isatu! ");
INSERT INTO zak_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bhoono, wiituurye omweene, wiike okurwa kumusaraba hayo!” ");
INSERT INTO zak_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na abhakuru bha abhaseengeri na abheegya bhe emigiro gya Musa bhoosi kwa hamwe, bhakamuzibhura bharabhuga, “Akatuurya abhaandi, nawe atakunagya kwiituurya omweene! ");
INSERT INTO zak_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Angu, ewe abhugiri kubha niwe Masiya, omutemi wa Abhiiziraeri. Bhoono turore yiike kumusaraba, okubha tumurore no okumwiikirirya!” Naabhe abhaatu bhano bhaabhaambirwe hamwe neewe kumisaraba, nabho bhaari bharamutuka. ");
INSERT INTO zak_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ambe, kweemera eriibhaga rya kasaasabha mumwiisi, ekiirima kikasikira mukyaaro kyoosi tee eriibhaga rya keenda. ");
INSERT INTO zak_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Niho eriibhaga rya keenda, Yeesu akarira kwe eriiraka ikuru akabhuga, “Eri, Eri! Rama sabakitani?” Obhugazuro bhwaku ni, “Ee Taatabhugya waane, ee Taatabhugya waane, ndora onitigiri?” ");
INSERT INTO zak_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abhaatu abharebhe gati wa bhano bhiimeereeri harya, hano bhakiigwa aragaamba, bhakabhuga, “Mwiigwe bhamure, aramubhirikira omurooti Eriya.” ");
INSERT INTO zak_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Omuutu owumwe akaryaara bhwaangu, akaaza ne epaamba, akayiitobhya mumaanzi amaruru go omuzabibu gari musuka, akayituura kumaara. Akagororokya iguru, okubha amuhe Yeesu anywe. Omuutu wuyo akabhuga, “Tiga otamuha! Turore eraabhe Eriya araaza okumwiikya kumusaraba hayo!” ");
INSERT INTO zak_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yeesu akarira kwe eriiraka ikuru, kyaamwe akakwa. ");
INSERT INTO zak_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Niho omweenda guno gwaari gusuungirwe mu Hahoreeru he eriiseengerero gukaraanduka mbaara ibhiri okurwa iguru tee haasi. ");
INSERT INTO zak_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Omukuru wa abhasirikare wuno yaari yiimeereeri embere wa Yeesu, hano yaruuzi kyeego Yeesu akukwa, akabhuga, “Eheene omuutu wuno yaari Omwaana wa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhaari bhariho abhakari bhano bhaari bharasuungurirya kwa kure. Gati waabhu bhaari bhariho Mariamu wa mumugye gwa Magidara, Sarome na Mariamu nina wa Yaakobo omusuuhu na Yose. ");
INSERT INTO zak_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Abhakari bhayo bhaari bhamutuniiriiri no okumuhokeerya Yeesu hano yaari mumugye gwa Gariraaya. Bhaari bhariho na abhakari abhaandi bhaaru bhano bhakagya hamwe neewe Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hano yahikiri engoroobha, kwo okubha orusiku ruyo rwaari orusiku rwo okwiibhanura kwiiguru yo orusiku rwo okumuunya, ");
INSERT INTO zak_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","akaaza omuutu wumwe okurwa omugye gwa Arimataya, arabhirikirwa Yusufu. Na yaari owumwe wa abhakuru mukiina ekikuru kya Abhayahudi. Yaari ariisigira obhutemi bhwa Taatabhugya. Niwe akagya ku Pirato kwo obhukararu no okumusabha amwiikiriirye agege ekituundu kya Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hano Pirato yiigwiiri kubha Yeesu akuuri bhwaangu ego, akaruguura. Akamubhirikira omukuru wa abhasirikare wurya, okubha amenyeekererye eraabhe eheene Yeesu amariri kukwa. ");
INSERT INTO zak_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Hano omukuru wa abhasirikare yamenyeekereerye kubha Yeesu akuuri, Pirato akamwiikirirya Yusufu agege ekituundu. ");
INSERT INTO zak_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Niho Yusufu neewe akagura omweenda gwo obhuguri bhukuru. Akagya kumusaraba harya, akiikya haasi ekituundu kya Yeesu, akakiriizirira mumweenda. Akabhiika ekituundu kirya mumbiihira yino ekatukwa kwiitare, akarihiriingitya eriigina eriikuru no okuriibha kukiseku kye embiihira. ");
INSERT INTO zak_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariamu wa mumugye gwa Magidara na Mariamu nina waabhu Yaakobo omusuuhu na Yose bhakarora hano yabhiikirwe. ");
INSERT INTO zak_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Hano orusiku rwo okumuunya rwahitiri, Mariamu wa mumugye gwa Magidara, Sarome na Mariamu nina waabhu Yaakobo omusuuhu na Yose, bhakagura amaguta go omuruumbaaso, bhagye bhahake ekituundu kya Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Orusiku rwo okutaanga rwo obhutuuro etabhoori, hano eryoobha rikusomoka, bhakagya kumbiihira ya Yeesu. ");
INSERT INTO zak_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hano bhaari munzira, bhakataanga kwiibhuurya, “Bhoono, ni weewi wuno araaturuusirye eriigina rirya kukiseku kye embiihira?” ");
INSERT INTO zak_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nawe hano bhaahikiri, bhakarora eriigina rirya rihuungwiirwe embarika, na ryaari ikuru bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Hano bhaasikiiri mumbiihira, bhakoobhoha kurora omumura wumwe wuno yiibhohiri omweenda murabhu. Yiikeeri orubhaara rwo obhuryo bhwe embiihira. ");
INSERT INTO zak_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Niho akabhabhuurira, “Mutoobhoha! Nimenyiri kubha mwiiziri kumumoohya Yeesu wa Nazareeti, wuno bhaamumbaambiri kumusaraba. Aryoorirwe, atariho hano! Murore hano niho bhaari bhamuhiindiirye. ");
INSERT INTO zak_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bhoono, mugeende mubhabhuurire abhaanabheega bhaaye, kiindi Petero kubha, Yeesu abhakaangatiiri kugya Gariraaya. Eyo niyo muraamurore kyeego yabhabhuuriiri.” ");
INSERT INTO zak_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Hano bhiigwiiri ego, bhakataanga okurigita kwe ehaho no okuruguura. Bhakahuruka igutu we embiihira. Bhataabhuuriiri omuutu wowoosi, kwo okubha bhakoobhoha bhukongʼu.  ");
INSERT INTO zak_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hano Yeesu yaryoorirwe etabhoori orusiku rwo okutaanga rwo obhutuuro, akamutuukira hiinga Mariamu wa mumugye gwa Magidara, wuno yaari amuruusirye amasaambwa muhuungati. ");
INSERT INTO zak_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariamu akagya, akabhabhuurira bhano bhaari bhakugeendania na Yeesu, ne eriibhaga riyo bhaari bhararira no okwaaramira. ");
INSERT INTO zak_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nawe hano bhakiigwa ku Mariamu kubha amuruuzi Yeesu ari muhoru, bhatiikiriirye. ");
INSERT INTO zak_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Orusiku ruyoruyo, Yeesu akabhahwaarukira abhaanabheega bhaaye bhabhiri gati wa abhaanabheega bhaaye, yaari ne ekisyo ekiindi. Abhaanabheega bharya bhaari munzira bharareka Yerusaremu bharagya owaabhu. ");
INSERT INTO zak_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hano bhaamumenyiri, bhakakyoora kubhabhuurira abharikyaabhu, nawe bhatiikiriirye. ");
INSERT INTO zak_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mubhuteero, Yeesu akabhahwaarukira abhaanabheega bhaaye ikumi na wumwe, hano bhaari hamwe, bhakurya ebhyaakurya. Akabharekya kwo obhukongʼu bhwe eziikoro zyaabhu, kwo okubha bhakaanga kwiikirirya amangʼana ga abharikyaabhu bhano bhakamurora Yeesu hano yaryoorirwe mubhaku. ");
INSERT INTO zak_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Niho akabhabhuurira, “Mugeende mukyaaro kyoosi, mubharwaazire abhaatu bhoosi Amangʼana Amazomu. ");
INSERT INTO zak_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Omuutu wowoosi wuno yiikiriirye no okubatiizwa, aratuuribhwa. Nawe, omuutu wowoosi wuno akwaanga kwiikirirya, aratinirwa ekiina. ");
INSERT INTO zak_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abhaatu bhano bhiikiriirye, bharakora ekyeerekenio, okuruusya amasaambwa amabhi kubhaatu kwe eriina ryaane no okugaamba kwe ekigaambo ekihya, ");
INSERT INTO zak_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Naabhe bhaangagwaata enzoka kwa amabhoko kasi bhakunywa ekigiro kyokyoosi kino kikwiita, kitakubhanyahaara. Bharabha bharatuura amabhoko gaabhu kubharweeri, nabho bharahora.” ");
INSERT INTO zak_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Hano Omukuru Yeesu yagaambiri nabho, Taatabhugya akamugega mwiisaaro. Yiikeeri orubhaara rwo obhuryo rwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abhaanabheega bhaaye bharya bhakatanura harya. Bhakagya okurwaaza Amangʼana Amazomu ahagiro hoosi. Omukuru Yeesu yaari arabhaha amanaga go okukora ekyeerekenio. Ego niigo yaari akweerekya amangʼana gayo kubha ni ge eheene.");
INSERT INTO zak_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Omuguungibhwa Teofiro, garya gaakorirwe gati weetu, abhaatu bhaaru bhakoriri omukya gwo okukaama iguru yaku. ");
INSERT INTO zak_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gakaamirwe bhwaheene amangʼana gano twabhuuriirwe na bhano bhaagaruuzi amangʼana gayo, kwa ameeso gaabhu, bhano bhakunyaragania engʼana ya Taatabhugya kurwa obhweemero. ");
INSERT INTO zak_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Noosi nigiisuunziri no okugamenyeekererya bhwaheene, kyeego goosi gakorirwe kisi kweemera kubhutaangiro, nikarora ni kisi nikukaamire gayo ngʼorangʼora, ");
INSERT INTO zak_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","okubha obhe no obhuheene kugarya wegiibhwe. ");
INSERT INTO zak_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Eriibhaga Herode yaari omutemi wa Yudea, ahaabha ariho omuseengeri wumwe wa Taatabhugya, eriina ryaaye Zakaria, yaari musaango yo obhuseengeri bhwa Abiya. Na mukaaye Erizabeti, ewe yaari wa mukisyooko kyo omuseengeri Haruuni. ");
INSERT INTO zak_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Abhabhiri bhayo, bhaari abhaheene embere wa Taatabhugya, ebho bhaari bhariigwa emigiro gyo Omukuru gyoosi, okutama kubha ni isoro. ");
INSERT INTO zak_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bhatahaabha no omwaana, kwo okubha Erizabeti yaari muguumba, neebho bhaari bhakuunguhiri bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Orusiku rumwe, esaango ya Zakaria yaari erakora ruunga rwaaye rwo obhuseengeri embere wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kunyaangi yo obhuseengeri bhwaabhu, Zakaria akasorwa kwo okwiitoorwa obhwiitoori kubha, niwe araasikire ahahoreeru he eriiseengerero ryo Omukuru, Taatabhugya, okubha amuguundirirye omuruumbaaso. ");
INSERT INTO zak_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kwiibhaga ryo okwookya omuruumbaaso, habhoori bhakiikumania abhaatu bhaaru kumusabha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Niho, Zakaria akahwaarukirwa na maraika wo Omukuru. Maraika wuyo, akiimeerera orubhaara rwo obhuryo rwa ahagiro he ezahaabu ho okuguundirirya omuruumbaaso. ");
INSERT INTO zak_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hano Zakaria yamuruuzi, akiitakya no okwoobhoha bhukongʼu! ");
INSERT INTO zak_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nawe, maraika akamubhuurira, “Awe Zakaria, otoobhoha! Taatabhugya yiigwiiri amasabhi gaazo. Mukaazo Erizabeti, arakwiibhurira omwaana we ekisubhe, oramutoga eriina Yohana. ");
INSERT INTO zak_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Omwaana wuyo, niwe araakore muzomererwe no okuriiryaata, na abhaatu bhaaru bharazomererwa kwo okwiibhurwa kwaaye. ");
INSERT INTO zak_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Arabha omukuru embere wa Omukuru. Ataanywe amaanzi go omuzabibu ne ebhiindi bhyoosi bhino bhikugwaata. Arabha yiizuriibhwe Ekoro Muhoreeru kurwa muunda ya nina. ");
INSERT INTO zak_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Arakyoorya Abhiiziraeri bhaaru kwo Omukuru, Taatabhugya waabhu. ");
INSERT INTO zak_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aramukaangatira Omukuru okubha amubhanurire abhaatu okumusuungʼaana obhuuzi bhwaaye no okukaangatibhwa ne ekoro no obhunagya kya bhwa Eriya. Arabhagwaatania bhataata na abhaana bhaabhu, no okubhakora bhano bhatakumwiigwa Omukuru bhabhe na amangʼeeni ge eheene.” ");
INSERT INTO zak_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaria akamubhuurya maraika, “Ndora enye na mukaane tukuunguhiri! Niki kiraanierekye obhuheene bhwo okubhona omwaana?” ");
INSERT INTO zak_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Maraika wuyo akabhuga, “Enye neenye Gaburieri, nikwiimeerera embere wa Taatabhugya. Ewe niwe anitumiri kubha, niize kukubhuurira amangʼana gano amazomu. ");
INSERT INTO zak_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kwo okubha otiikiriirye gano nakubhuuriiri, kweema bhoono orabha imuumu, na otakunagya kugaamba tee, kuhikira gayo garaakorwe kwiibhaga ryaaye.” ");
INSERT INTO zak_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Abhaatu bhaari bharaganya Zakaria ahuruke igutu, bhakaruguura kurora kyeego yakezeerimu. ");
INSERT INTO zak_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hano yaahurukirimu, ataanagirye kweeki kukeerenia nabho, akageenderera kubha imuumu. Yaari areerekya kwa amabhoko, bhakamenya kubha aruuzi obhurori. ");
INSERT INTO zak_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hano yamariri eziisiku zaaye zo okukora emirimo mwiiseengerero, akagya yiika. ");
INSERT INTO zak_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kyaamwe, mukaaye Erizabeti akagega enda, akamara emyeeri etaano yaari akiibhisa, ");
INSERT INTO zak_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","akabhuga, “Omukuru, niwe anikoreeri ego! Anduusiirye eziisoni embere wa abhaatu.” ");
INSERT INTO zak_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hano enda ya Erizabeti yahikirye emyeeri esaasabha, Taatabhugya akatuma maraika Gaburieri mumugye gwa Nazareeti, mukyaaro kya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Akatumwa kumuukya wumwe, eriina ryaaye Mariamu, yaari ayuungiibhwe no omusubhe wumwe, eriina ryaaye Yusufu, we ekisyooko kyo omutemi Daudi. ");
INSERT INTO zak_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hano maraika yagiiri ku Mariamu, akamubhuurira, “Ndakukeerya, awe omutweerwa we ebhite, Omukuru ari hamwe naawe.” ");
INSERT INTO zak_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hano akiigwa amangʼana gayo, akanyaaka mukoro, akiibhuurya, “Nkeeryaki yino?” ");
INSERT INTO zak_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Maraika akamubhuurira, “Weyaa Mariamu, otoobhoha! Omutweerwa we ebhite wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Rora! Oragega enda, na oriibhura omwaana we ekisubhe, oramutoga eriina ryaaye Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Arabha omukuru, arabhirikirwa Omwaana wa Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi. Omukuru, Taatabhugya arabhwiimeererya kweeki obhukaangati bhwo obhutemi bhwa Daudi isikuru waaye, no okumuha omwaana wuyo. ");
INSERT INTO zak_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Arabha omutemi wa abhaatu bhoosi bha Iziraeri kirakeego, no obhutemi bhwaaye, bhutakubha no obhuteero.” ");
INSERT INTO zak_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariamu akabhuurya, “Garabhabhwi, neenye nitakaruuzi omusubhe?” ");
INSERT INTO zak_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Akamukyoora, “Ekoro Muhoreeru arakwiikira, na amanaga ga Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi, garakukuundikiirya. Kweego, omwaana wuno akwiibhurwa, arabha omusorwa no okutogwa Omwaana wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Naabhe omuhiiri waazo Erizabeti, wuno abhaatu bhaari bhamumenyiri kubha ni muguumba, agegiri enda yo omwaana we ekisubhe mubhukikuru bhwaaye. Bhoono ariinda ya emyeeri esaasabha. ");
INSERT INTO zak_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gayo gaatuukiri kwo okubha ku Taatabhugya, bhyoosi bhiraturikana.” ");
INSERT INTO zak_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariamu akabhuga, “Neenye omugya wo Omukuru, ebhe kweenye kyeego ogaambiri.” Kyaamwe akagya. ");
INSERT INTO zak_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mariamu akakora bhwaangu orugeendo, rwo okugya ku Erizabeti eziisiku ziyoziyo, mumugye gumwe gwe ebhiguru bhya Yudea. ");
INSERT INTO zak_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hano yasikiiri wa Zakaria, akamukeerya Erizabeti. ");
INSERT INTO zak_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hano Erizabeti akiigwa akeeriibhwe na Mariamu, omwaana yaari muunda yaaye akatumatuma. Hayohayo Erizabeti akiizuribhwa ne Ekoro Muhoreeru, ");
INSERT INTO zak_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kyaamwe akagaamba kwiiraka ikuru, “Mubhakari bhoosi, awe naawe omutweerwa we ebhite! No oriibhura omwaana omutweerwa ebhite. ");
INSERT INTO zak_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Enye ni weewi, naabhe nina wo Omukuru waane yiize kunikeerya? ");
INSERT INTO zak_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hano niigwiiri oranikeerya, omwaana akatumatuma muunda yaane kwo obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Awe naawe omutweerwa ebhite, kwo okubha wiikiriirye gano Omukuru yakubhuuriiri gakorwe.” ");
INSERT INTO zak_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariamu akabhuga, “Ekoro yaane, eramukumya Omukuru, ");
INSERT INTO zak_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","erazomererwa niwe Taatabhugya Omutuurya waane, ");
INSERT INTO zak_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kwo okubha anihiitiri omugya waaye, yiingabha enye ni munyookobhu. Kurwa bhoono, abhaatu bhe eziinyiibhuro zyoosi na zino zikuuza, bharabha bharanibhirikira kubha neenye omutweerwa we ebhite, ");
INSERT INTO zak_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwo okubha Taatabhugya wa amanaga, anikoreeri amangʼana ge ekiruguuro, ne eriina ryaaye ni ihoreeru, rirakira amariina goosi. ");
INSERT INTO zak_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Taatabhugya arageenderera kubharorera ebhigoongi no okubhasakirya abhaatu bhe eziinyiibhuro zyoosi, bhano bhakumwiigwa. ");
INSERT INTO zak_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Akoriri amangʼana amakuru kwa amanaga go okubhoko kwaaye, anyarageenie abharegenu bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yiituumirye abhakaangati kurwa kubhituumbi bhyaabhu bhyo obhutemi, kimwe abhatiirirye abhanyookobhu. ");
INSERT INTO zak_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Bhe enzara, abhiigutirye bhwaheene, nawe abhaniibhi abhaheebhiri amabhoko bhusa. ");
INSERT INTO zak_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Abhahiitiri no okubhasakirya Abhiiziraeri, abhabhagati bhaaye, akabharorera ebhigoongi. ");
INSERT INTO zak_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Akakora kyeego yaragiri Aburahamu na bhazaazi bheetu, na abhaatu bhe ehamati yaaye kirakeego.” ");
INSERT INTO zak_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariamu akamara emyeeri etatu ari we Erizabeti, niho yagarukiri yiika waaye. ");
INSERT INTO zak_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Eziisiku zo okwiibhura kwe Erizabeti zikahika, akiibhura omwaana we ekisubhe. ");
INSERT INTO zak_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hano abhanyaroobho na abhahiiri bhaaye bhakiigwa kyeego Omukuru yamuroreeri ebhigoongi bhyaaru, bhakazomererwa hamwe neewe. ");
INSERT INTO zak_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Omwaana wuyo, hano yahikirye orusiku rwa kanaane, bhakaaza kumusaara. Bhakeenda kumutoga eriina rya wiise Zakaria. ");
INSERT INTO zak_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kyaamwe, nina akaanga, akabhuga, “Zeyi, atogwe Yohana.” ");
INSERT INTO zak_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhakamukyoora, “Ndora eriina riyo ritari mubhahiiri bheenyu!” ");
INSERT INTO zak_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Niho, bhakabhuurya wiise, kwo okumweerekya na amabhoko, abhazweenie kyeego akweenda atoge omwaana waaye. ");
INSERT INTO zak_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Akasabha ekigiro kyo okukaamira, akakaama, “Eriina ryaaye niwe Yohana.” Bhoosi ego bhakaruguura! ");
INSERT INTO zak_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kyaamwe, omunwa gwaaye gukiigurwa, kweeki akabha aragaamba, akumukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abhanyaroobho bhoosi, bhakahaha, engʼana yiyo ekanyaragana bhukongʼu mbaara zoosi ze ebhiguru bhya Yudea. ");
INSERT INTO zak_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kwo okubha bhoosi bhakiigwa obhunagya bhwo Omukuru bhwaari hamwe neewe, bhakabha bhakiibhuurya, “Omwaana wuyo arabha muutuki?” ");
INSERT INTO zak_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaria, wiise wo omwaana wuyo, akiizuribhwa ne Ekoro Muhoreeru, akagaamba obhurooti, ");
INSERT INTO zak_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Akumibhwe Omukuru, Taatabhugya wa Abhiiziraeri, kwo okubha yiiziri kututuurya etwe abhaatu bhaaye. ");
INSERT INTO zak_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Taatabhugya atureeteeri Omutuurya weetu wa amanaga, omwiibhurwa we ekisyooko kya Daudi, omuhokya waaye, ");
INSERT INTO zak_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kyeego yaragiri ekare hayo kubharooti bhaaye abhahoreeru. ");
INSERT INTO zak_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Akaraga kututuurya kubhabhisa bheetu, na mumabhoko ga bhoosi bhano bhakutubhiihirirya. ");
INSERT INTO zak_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Akabhuga kubha, arabharorera ebhigoongi bhazaazi bheetu no okuhiita eriiragano rirya eriihoreeru. ");
INSERT INTO zak_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Eriiragano riyo niryo akakora na zaazi weetu Aburahamu. ");
INSERT INTO zak_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tutuuriibhwe kurwa mumabhoko ga abhabhisa bheetu, okubha tumuseengere, kutama kubha ne ehaha, ");
INSERT INTO zak_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tubhe bhahoreeru na abhaheene embere waaye, kuziisiku zeetu zoosi. ");
INSERT INTO zak_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Awe omwaana waane, orabhirikirwa omurooti wa Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi. Orakaangata embere wo Omukuru, abhone omweererye abhaatu kuziinzira zino araahitire. ");
INSERT INTO zak_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Obhabhuurire abhaatu bhaaye kubha, bharatuuribhwa kwo okwaabhirwa kwe ebhibhi bhyaabhu, ");
INSERT INTO zak_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kwe ebhigoongi bhyaaru no obhunyoohu bhwa Taatabhugya weetu. No obhutuuribhwa bhuyo bhuratuhwaarukira kyo obhweero kurwa iguru. ");
INSERT INTO zak_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Na bhukabhabharira bhoosi bha mukiirima na bhano bhakwoobhoha enyaako yo oruku runo rwaari kuuza. Bhuratukaangata tee, tubhe turahita munzira yo omureembe.” ");
INSERT INTO zak_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yohana akakiina, akabha na amanaga mukoro yaaye, akagya kwiikara mwiitirigo tee, hano eriibhaga ryahikiri akarweera mu Bhiiziraeri. ");
INSERT INTO zak_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kuziisiku ziyo, Kaisari Agusito, omutemi omukuru wa Rooma, akabhaswaagya abhaatu bhoosi bha mubhyaaro bhyo obhukaangati bhwaaye, bhagye bhakaamwe. ");
INSERT INTO zak_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Okukaamwa kuyo kwaari kwo okutaanga, kwiibhaga rino Kurenio yaari omwaanaangwa wa Siria. ");
INSERT INTO zak_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kweego, abhaatu bhoosi bhakagya okukaamwa, mumugye gwe ekisyooko kyaaye. ");
INSERT INTO zak_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu woosi, akarwa mumugye gwa Nazareeti, mukyaaro kya Gariraaya, akatiira kugya Beterehemu, mukyaaro kya Yudea, kwo okubha Beterehemu nigwe gwaari omugye gwo omutemi Daudi, na yaari wa mukisyooko kya Daudi. ");
INSERT INTO zak_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yusufu akagya kukaamwa hamwe na Mariamu, omuyuungibhwa waaye. Kwiibhaga riyo Mariamu yaari ariinda. ");
INSERT INTO zak_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hano bhaari bhakyaari eyo, eriibhaga ryo okwiibhura kwa Mariamu rikahika, ");
INSERT INTO zak_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","akiibhura omwaana waaye omutaangi we ekisubhe munyuumba ye emitugo. Akamwiibhisya emyeenda gye ekibhataare, akamuhiindirya muryaato. Akamwiibhurira muyo kwo okubha bhataabhweeni ekyuumba muziinyuumba zya abhagini. ");
INSERT INTO zak_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mubhutiku bhuyo, abhariisya bhahaariibha emitugo gyaabhu mwiitirigo. ");
INSERT INTO zak_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kyaamwe, bhakahwaarukirwa na maraika wumwe wo Omukuru! No obhweero bhwo obhuguungo bhwo Omukuru bhukabhabharira mbaara zoosi, bhakagwaatwa ne ehaho nzaru. ");
INSERT INTO zak_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kyaamwe, maraika wuyo akabhabhuurira, “Mutoobhoha! Ndabharwaazira amangʼana amazomu, gano garaabhazomere abhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Reero yino, mumugye gwa Daudi, omutuurya yiibhwiirwe kwiiguru weenyu. No omutuurya wuyo niwe Omukuru, niwe Masiya weetu. ");
INSERT INTO zak_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne ekyeerekenio kyo okubheerekya gayo, nikyo kiyo, murabhona omwaana omurere ahiindiriibhwe muryaato, akuundikiirwe ne emyeenda gye ekibhataare.” ");
INSERT INTO zak_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kyaamwe, maraika wuyo, akabhahwaarukira ne ebhikwe kwe ebhikwe bhya bhamaraika abharikyaaye okurwa mwiisaaro, bhakabha bharamukumya Taatabhugya, ");
INSERT INTO zak_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Taatabhugya wa mwiisaaro aguungibhwe! Na mukyaaro, omureembe gubhe kubhaatu bhano abhaseegiri.” ");
INSERT INTO zak_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Bhamaraika bhayo, hano bhaamariri, bhakakyoora mwiisaaro. Abhariisya bhakabhuga, “Tugeende Beterehemu, turore gayo kyeego Omukuru atubhuuriiri.” ");
INSERT INTO zak_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bhakagya bhwaangu, bhakabhona Mariamu na Yusufu, na bhakamurora omwaana omurere ahiindiriibhwe muryaato. ");
INSERT INTO zak_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hano abhariisya bhayo bhaamuruuzi omwaana wuyo, bhakazweenia abhaatu amangʼana goosi gayo, maraika yabhabhuuriiri iguru waaye. ");
INSERT INTO zak_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na bhoosi bhano bhakiigwa gayo, bhakaruguura bhukongʼu iguru ya amangʼana gano bhaabhuuriirwe na abhariisya. ");
INSERT INTO zak_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nawe, Mariamu akabhiika gayo goosi mukoro yaaye akabha aragiiseega. ");
INSERT INTO zak_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Abhariisya bhayo bhakakyoora, bharamukumya Taatabhugya no okumuguungya kugoosi gano bhakiigwa no okurora. Kyeego bhaabhuuriirwe na maraika, na niigo gaakorirwe. ");
INSERT INTO zak_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Omwaana wuyo, hano yahikiri orusiku rwa kanaane, bhakamusaara, bhakamutoga Yeesu. Rino niryo eriina yaheerwe na maraika, eriibhaga rino nina waabhu yaari akyaari kugega enda. ");
INSERT INTO zak_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kyeego geendirwe kumigiro gya Musa, Yusufu na Mariamu bhakamara eziisiku zyaabhu zo okumweeswa. Bhakamuhira Yeesu Yerusaremu, abhe omusorwa embere wo Omukuru. ");
INSERT INTO zak_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bhakakora ego, kwo okubha ekaamirwe mumigiro gyo Omukuru, “Omwaana we embere we ekisubhe, abhe omusorwa embere wo Omukuru.” ");
INSERT INTO zak_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kweeki bhakeenda kuruusya ekimweeso, kirya kigaambirwe ne emigiro gyo Omukuru, “Muruusye ekimweeso kye ebhiguuti bhibhiri, hamwe amaana abhiri ge ebhiguuti.” ");
INSERT INTO zak_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yerusaremu eyo, ahaabhaho omuutu wumwe, eriina ryaaye ni Simioni. Simioni wuyo, yaari omuheene embere wa Taatabhugya, na yaari aramwiigwa no okuganya kurora okutuuribhwa kwa Abhiiziraeri. Ne Ekoro Muhoreeru yaari hamwe neewe. ");
INSERT INTO zak_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ne Ekoro Muhoreeru yaari amariri kumukuundukurira kubha, atakukwa tee amurore Masiya wo Omukuru. ");
INSERT INTO zak_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simioni woosi, Ekoro Muhoreeru akamukaangatya asikire mwiiseengerero rya Taatabhugya. Hano abhiibhuri bha Yeesu bhaamureetiri muyo, bhamukorere kyeego emigiro gyaragiriirye. ");
INSERT INTO zak_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kyaamwe, Simioni akamusuungʼaana Yeesu, no okumukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Akabhuga, “Weyaa Omukuru, Taatabhugya, okoriri kyeego waandagiri, bhoono waanganihaatiiri omugya waazo, nikwe kwo omureembe, ");
INSERT INTO zak_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kwo okubha nduuzi kwa meeso gaane obhutuurya bhuno otureeteeri. ");
INSERT INTO zak_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nibhwe otubhanuriiri no okurorekana embere ya abhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Obhutuurya bhuyo, bhurabha obhweero bhwo okweerekya enzira, kubhaatu bhano bhatari Abhayahudi, no obhuguungibhwa kubhaatu bhaazo Abhiiziraeri.” ");
INSERT INTO zak_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Amangʼana gano Simioni yagaambiri iguru yo omwaana wuyo, gakaruguurya wiise na nina. ");
INSERT INTO zak_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioni akabhatweera ebhite, akabhuurira Mariamu, “Rora! Omwaana wuno yiitoorirwe kubha, arabhasikya Abhiiziraeri bhaaru no okubhatuurya Abhiiziraeri abhaandi bhaaru. Na arabha ekyeerekenio kyo obhuhoru kino kiraangwe na abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kweego, amiiseego gano gabhisirwe muziikoro zya abhaatu, garakuundukurwa mwaasi. Naawe Mariamu, oriigwa obhururu bhukongʼu mukoro yaazo kyeego wuno osomirwe na nyaambato.” ");
INSERT INTO zak_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ahaabhaho omurooti wumwe, mukiikuru bhukongʼu, eriina ryaaye Ana, muukya wa Fanueri, we ekisyooko kya Asheeri. Ana wuyo, akiikara emyaaka muhuungati egyeene no omusubhe waaye, kyaamwe omusubhe waaye akakwa. ");
INSERT INTO zak_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Na akasaaga mutuumba tee akahikya emyaaka emiroongo enaane ne ene (84). Akabha arahooyera mwiiseengerero muyo muyo, akabha aramusabha obhutiku no omwiisi, na hano yaakusabha kwiibhaga eriindi ahiisiitya ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kwiibhaga riyoriyo hano bhaari bhamureetiri Yeesu mwiiseengerero, Ana woosi akahita embere, akataanga kumukumya Taatabhugya. Akagaamba engʼana iguru yo omwaana wuyo, kubhaatu bhoosi bhano bhaari bhariiseegera kubha, Taatabhugya aratuurya Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hano Yusufu na Mariamu bhaamariri kukora goosi ge emigiro gyo Omukuru, kyeego gyeendirwe, bhakakyoora mumugye gwaabhu gwa Nazareeti, mukyaaro kya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Omwaana akatweerwa ebhite na Taatabhugya, akakiina, akabha na amanaga mukoro yaaye no okwiizuribhwa amangʼeeni. ");
INSERT INTO zak_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kumyaaka gyoosi, abhiibhuri bha Yeesu bhahaatiira kugya Yerusaremu, ku Nyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hano Yeesu yahikirye emyaaka ikumi ne ebhiri, akahirana hamwe na abhiibhuri bhaaye kunyaangi kyeego yaari enyaangi yaabhu. ");
INSERT INTO zak_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hano enyaangi yahwiiri, abhiibhuri bha Yeesu bhakataanga orugeendo rwo okukyoora yiika, nawe Yeesu akasaaga Yerusaremu. Abhiibhuri bhaaye bhataari bhamenyiri abhe asaagiri eyo, ");
INSERT INTO zak_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","bhaari bhakiiseega kubha ari hamwe na abharikyaabhu murugeendo. Eryoobha rimwe hano bhahoyeeri kunzira, bhakataanga kumukomya mubhahiiri na abhasaani bhaabhu. ");
INSERT INTO zak_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hano yabhabhuririku, bhakakyoora kumumoohya Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Orusiku rwa katatu, bhakamubhona mwiiseengerero rya Taatabhugya, yiikeeri gatigati wa abheegya bhe emigiro, yaari arabhiitegeerera no okubhuurya amabhuuryo. ");
INSERT INTO zak_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Abhaatu bhoosi bhano bhakiigwa kyeego yaari kugaamba, bhakaruguura bhukongʼu iguru ya amangʼeeni gaaye, na iguru ya amakyooro gaaye. ");
INSERT INTO zak_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Abhiibhuri bhaaye bhayo, hano bhaamuruuzi, bhakaruguura bhukongʼu. Nina waabhu akamubhuurira, “Omwaana waane, kwaki otukoreeri ego? Enye na wuuso weenyu twaari twoobhohiri, turakumoohya bhukongʼu!” ");
INSERT INTO zak_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Akabhakyoora, “Kwaki mwaari muranimoohya? Mutaamenyiri kubha ndeenderwa nibhe munyuumba ya Taata waane?” ");
INSERT INTO zak_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nawe abhiibhuri bhaaye bhataamenyiri eriikyooro rya Yeesu riyo. ");
INSERT INTO zak_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kyaamwe, akahiriingita kugya hamwe nabho mumugye gwaabhu gwa Nazareeti, akabha arabhiigwa. Nina akagatuura amangʼana gayo goosi mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yeesu akabha arakiina no okwoongera amangʼeeni, aramuzomera Taatabhugya na abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Gwaari omwaaka gwi ikumi ne etaano gwa mubhukaangati bhwo omutemi omukuru Tiberio, no omwaanaangwa we ekyaaro kya Yudea yaari Pontio Pirato. No omukaangati we ekyaaro kya Gariraaya yaari Herode, no omukaangati we ebhyaaro bhya Iturea na Tarakoniti yaari Firipo, wamwaabhu Herode. No omukaangati we ekyaaro kya Abirene yaari Risania. ");
INSERT INTO zak_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na abhaseengeri abhakuru nibho bhaari Anasi hamwe na Kayafa. Kwe eriibhaga riyo, Yohana omwaana wa Zakaria wuyo, yaari mwiitirigo, na hano yaari eyo akahaabhwa engʼana na Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohana yaari aragya kuhitira ekyaaro kyoosi kino kyareeni ne Ekitaaro kya Yorodaani, eno ararwaazira engʼana yiyo. Yaari arabhabhuurira abhaatu, “Mute ebhibhi bhyeenyu mumukyoorere Taatabhugya no okubatiizwa, okubha abhaabhire ebhibhi bhyeenyu!” ");
INSERT INTO zak_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Niigo amangʼana gayo ga Yohana gabheeri kyeego gakaamirwe mukitabhu no omurooti Isaya: “Omuutu wuno akubhirikira kwe eriiraka ikuru okurwa mwiitirigo: ‘Mumukorere Omukuru enzira, mugororokye eziinzira zino araahite. ");
INSERT INTO zak_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Muribhe amaruuma goosi, na muroosye ebhiguru ne ebhiswa. Mugororokye eziinzira zino ziikiikiri, na muroosye ebhiruumwa bhisuuhu. ");
INSERT INTO zak_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Niho abhaatu bhoosi bharaarore obhutuurya bhuno bhukurwa ku Taatabhugya.’ ” ");
INSERT INTO zak_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Abhaatu bhaaru bhaari bharamuuzaku Yohana, kubha abhabatiize. Kyaamwe, akabha arabhabhuurira, “Emwe orwiibhuro rwe enzoka! Weewi abhabhuuriiri kubha muranagya kuryaara obhutemwa bhwa Taatabhugya bhuno bhukuuza kwo okubatiizwa ego? ");
INSERT INTO zak_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ambe, mukore amahokya gano, gakweerekya kubha mumariri kuta ebhibhi bhyeenyu na mumwiikyooreeri Taatabhugya. Mutataanga kugaamba kubha Taatabhugya arabhiikirirya kyeego mukwiizuungya, ‘Zaazi weetu ni Aburahamu!’ Ndabhabhuurira kubha, Taatabhugya aranagya kukyoosya amagina gano kubha abhaana bha Aburahamu! ");
INSERT INTO zak_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na bhoono obhutini bhwe ekiina kya Taatabhugya bhuri iguru weenyu kyeego ehaazi eri iguru ya amatina ge emiti. Na bhano bhatakukora amahokya amazomu bharatinirwa ekiina, kyeego emiti gyoosi gino gitakwiibhura emisumo emizomu gikutinwa no okurekerwa mumuriro.” ");
INSERT INTO zak_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Niho amahizo ga abhaatu bhano bhaari bharimu, bhakamubhuurya Yohana, “Bhoono, tukoreki?” ");
INSERT INTO zak_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Akabhakyoora, “Wowoosi wuno ane emyeenda ebhiri, aruusye ogumwe kuwuno ataanagwe. Na wowoosi wuno ane ebhyaakurya, ewe woosi asoondere wuno ataanabhyo.” ");
INSERT INTO zak_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kwiihizo riyo bhaari bhariho na abhatobhya bhe eriigooti, neebho bhakamuuzaku Yohana, okubha abhabatiize. Bhakamubhuurya, “Ee Omweegya, na neetwe tukoreki?” ");
INSERT INTO zak_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Akabhakyoora, “Muraatobhe eriigooti, mutatobha ikuru kukira ekireengero kino kiteerweho.” ");
INSERT INTO zak_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Neebho bhaari bhariho abhasirikare, bhakamubhuurya, “Neetwe tukoreki?” Akabhakyoora, “Mutaaza kuruusya omuutu ebhigiro bhyaaye, na mutaaza kumubheehera. Na kweeki mwiiswe na amariho gano mukuhaabhwa.” ");
INSERT INTO zak_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Abhaatu bhoosi, bhaari bhariibhuurya no okwiiseega muziikoro zyaabhu kubha, hamwe Yohana niwe Masiya. ");
INSERT INTO zak_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana akabhabhuurira bhoosiigo, “Enye, ndabhabatiiza kwa amaanzi. Nawe araaza omuutu owuundi inyuma waane wuno akunikira amanaga, enye nitakungʼarira kubha omuhokya waaye naabhe okutazura eziikobha zye ebhikweera bhyaaye! Ewe niwe arabhabatiiza kwe Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ewe ni kyo omurimi wuno akugwaata oruhuungo mumabhoko gaaye okubha aseese omukuunyu kurwa mungano. Engano yiyo, arayikumanirya mukitara kyaaye, nawe omukuunyu, aragwookya mumuriro guno gutakurima.” ");
INSERT INTO zak_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa amangʼana gayo goosi na agaandi, Yohana yaari arabhariihya no okukumiirirya abhaatu bhayo, kwo okubharwaazira Amangʼana Amazomu ga Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nawe Yohana akamwiiyogya Herode, kwo okubha Herode akamusikirya Herodia no okumukora mukaaye, nawe Herodia wuyo yaari akweerirwe no wamwaabhu omusuuhu. Yohana akamurekya kungʼana yiyo, na kwe ebhibhi ebhiindi bhyoosi bhino yaari arakora. ");
INSERT INTO zak_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Niho, Herode akaaruhya ebhibhi bhyaaye kweeki, kwo okumubhoha Yohana munyuumba ya abhabhohwa. ");
INSERT INTO zak_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hano Yohana ya akyaari kubhohwa, abhaatu bhaaru bhaari bharabatiizwa, Yeesu woosi akaaza kubatiizwa. Eriibhaga yaari kusabha, eriisaaro rikiiguka, ");
INSERT INTO zak_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ekoro Muhoreeru akamwiikira iguru yaaye kye ekiguuti. Niho, eriiraka rikarwa mwiisaaro rikabhuga, “Awe naawe Omwaana waane omuseegwa, nizomereerwe naawe.” ");
INSERT INTO zak_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Eriibhaga rya Yeesu okutaanga emirimo gyaaye, ahaabha ne emyaaka miroongo etatu (30). Abhaatu bhahiiseega kubha, ahaabha omwaana wa Yusufu. ");
INSERT INTO zak_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Na Yusufu wuyo, yaari omwaana wa Heri, na Heri, yaari omwaana wa Matati, na Matati, yaari omwaana wa Raawi, na Raawi, yaari omwaana wa Meriki, na Meriki, yaari omwaana wa Yanai, na Yanai, yaari omwaana wa Yusufu. ");
INSERT INTO zak_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Na Yusufu, yaari omwaana wa Matatia, na Matatia, yaari omwaana wa Amosi, na Amosi, yaari omwaana wa Nahumu, na Nahumu, yaari omwaana wa Esiri, na Esiri, yaari omwaana wa Nagai. ");
INSERT INTO zak_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Na Nagai, yaari omwaana wa Mati, na Mati, yaari omwaana wa Matatia, na Matatia, yaari omwaana wa Semei, na Semei, yaari omwaana wa Yoseki, na Yoseki, yaari omwaana wa Yoda. ");
INSERT INTO zak_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Na Yoda, yaari omwaana wa Yoanani, na Yoanani, yaari omwaana wa Resa, na Resa, yaari omwaana wa Zerubabeeri, na Zerubabeeri, yaari omwaana Shearitieri, na Shearitieri, yaari omwaana wa Neri. ");
INSERT INTO zak_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Na Neri, yaari omwaana wa Meriki, na Meriki, yaari omwaana wa Adi, na Adi, yaari omwaana Kosaamu, na Kosaamu, yaari omwaana wa Erimadamu, na Erimadamu, yaari omwaana wa Eri. ");
INSERT INTO zak_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Na Eri, yaari omwaana wa Yoshua, na Yoshua, yaari omwaana wa Eriezeri, na Eriezeri, yaari omwaana wa Yorimu, na Yorimu, yaari omwaana wa Matati, na Matati, yaari omwaana wa Raawi. ");
INSERT INTO zak_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Na Raawi, yaari omwaana wa Simioni, na Simioni, yaari omwaana wa Yuuda, na Yuuda, yaari omwaana wa Yusufu, na Yusufu, yaari omwaana wa Yonamu, na Yonamu, yaari omwaana wa Eriakimu. ");
INSERT INTO zak_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Na Eriakimu, yaari omwaana wa Merea, na Merea, yaari omwaana wa Mena, na Mena, yaari omwaana wa Matata, na Matata, yaari omwaana wa Natani, na Natani, yaari omwaana wa Daudi. ");
INSERT INTO zak_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Na Daudi, yaari omwaana wa Yeese, na Yeese, yaari omwaana wa Obeedi, na Obeedi, yaari omwaana wa Boazi, na Boazi, yaari omwaana wa Sarimooni, na Sarimooni, yaari omwaana wa Nasoni. ");
INSERT INTO zak_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na Nasoni, yaari omwaana wa Aminadabu, na Aminadabu, yaari omwaana wa Adimini, na Adimini, yaari omwaana wa Arini, na Arini, yaari omwaana wa Hezirooni, na Hezirooni, yaari omwaana wa Pereesi, na Pereesi, yaari omwaana wa Yuuda. ");
INSERT INTO zak_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Na Yuuda, yaari omwaana wa Yaakobo, na Yaakobo, yaari omwaana wa Isaaka, na Isaaka, yaari omwaana wa Aburahamu, na Aburahamu, yaari omwaana wa Teera, na Teera, yaari omwaana wa Nahoori. ");
INSERT INTO zak_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na Nahoori, yaari omwaana wa Serugi, na Serugi, yaari omwaana wa Reu, na Reu, yaari omwaana wa Peregi, na Peregi, yaari omwaana wa Ebeeri, na Ebeeri, yaari omwaana wa Sheera. ");
INSERT INTO zak_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Na Sheera, yaari omwaana wa Kenaani, na Kenaani, yaari omwaana wa Arufakisadi, na Arufakisadi, yaari omwaana wa Shemu, na Shemu, yaari omwaana wa Nuhu, na Nuhu, yaari omwaana wa Rameki. ");
INSERT INTO zak_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Na Rameki, yaari omwaana wa Metuseera, na Metuseera, yaari omwaana wa Enoki, na Enoki, yaari omwaana wa Yareedi, na Yareedi, yaari omwaana wa Maharareri, na Maharareri, yaari omwaana wa Kenaani. ");
INSERT INTO zak_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Na Kenaani, yaari omwaana wa Enoshi, na Enoshi, yaari omwaana wa Seeti, na Seeti, yaari omwaana wa Adaamu, na Adaamu, yaari omwaana wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yeesu akarwa orubhaara rwe Ekitaaro kya Yorodaani, akabha yiizuriibhwe ne Ekoro Muhoreeru, ne Ekoro akabha aramukaangata mwiitirigo. Akamara eyo eziisiku miroongo ene (40), ");
INSERT INTO zak_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","na kwe eriibhaga riyo, akiisiitya okurya ebhyaakurya, na Seetaani ahaaza kumusakya. Na kubhuteero, akiigwa enzara bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Niho Seetaani akamubhuurira, “Aribha awe naawe Omwaana wa Taatabhugya, swaagya eriigina rino, riikyoore ribhe omukaate.” ");
INSERT INTO zak_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yeesu akamukyoora, “Zeyi! Ekaamirwe mu Makaamo Amahoreeru, ‘Omuutu atakunagya kwiikara kwe ebhyaakurya ebhyeene.’ ” ");
INSERT INTO zak_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kyaamwe, Seetaani akamuhira Yeesu ahagiro hano haari iguru bhukongʼu, rugeendo rumwe, akamweerekya obhutemi bhwe ebhyaaro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Akamubhuurira, “Ndakuha obhukaangati bhwoosi bhuno, hamwe no obhuniibhi bhwamu, kwo okubha goosi gano, neenye nikahaabhwa, ndatura kuha omuutu wowoosi wuno nikweenda. ");
INSERT INTO zak_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kweego, oraanihigamire no okuniseengera, ndakuha bhyoosi bhiyo bhibhe ebhyaazo.” ");
INSERT INTO zak_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu akamukyoora, “Zeyi! Ekaamirwe mu Makaamo Amahoreeru, ‘Omuseengere Omukuru, Taatabhugya waazo, omuhokeerye ewe omweene ego.’ ” ");
INSERT INTO zak_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Niho, Seetaani akamuhira Yeesu Yerusaremu, akamwiimeererya kukisoonge kye eriiseengerero rya Taatabhugya, akamubhuurira, “Aribha awe naawe Omwaana wa Taatabhugya, irekera haasi okurwa hano. ");
INSERT INTO zak_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Otakunagya kunyahaarika, ekaamirwe mu Makaamo Amahoreeru, ‘Taatabhugya araswaagya bhamaraika bhaaye kwiiguru waazo, bhakuriibhe. ");
INSERT INTO zak_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nabho bharakugega mumabhoko gaabhu, amaguru gaazo gataaza kwiitema kwiigina ryoryoosi.’ ” ");
INSERT INTO zak_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nawe Yeesu akamukyoora, “Ekaamirwe, ‘Otamusakya Omukuru, Taatabhugya waazo.’ ” ");
INSERT INTO zak_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hano Seetaani yaari amariri kumusakya Yeesu, akamutiga, tee abhone omweeya oguundi gwo okumusakya. ");
INSERT INTO zak_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kyaamwe Yeesu akagya mukyaaro kya Gariraaya, akabha yiizuriibhwe no obhunagya bhwe Ekoro Muhoreeru. Engʼana iguru waaye, ekanyaragana bhukongʼu mukyaaro kiyo kyoosi. ");
INSERT INTO zak_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Akagya areegya abhaatu muziinyuumba zyaabhu zye eziisaango. Neebho bhoosi, bhakabha bharamukumya. ");
INSERT INTO zak_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Orusiku rumwe, akakyoora Nazareeti, omugye guno yarereerwe. No orusiku rwo okumuunya, akasikira munyuumba ye esaango, kyeego yaanariri, akiimeerera okusoma Engʼana ya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Akahaabhwa ekitabhu kino kikaamirwe no omurooti Isaya, akakikuundukura kumoohya ahagiro hano hakaamirwe, niigo yahabhweeni, akasoma, ");
INSERT INTO zak_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ekoro yo Omukuru, Taatabhugya, eri hamwe neenye. Anisoriri kubharwaazira abhataka Amangʼana Amazomu. Anitumiri nibhazweenie abhabhohwa, kubha bhariigurirwa, na abhahoku, kubha bhariigurirwa ameeso, na bhano bhakunyaakibhwa, kubha ndabhatuurya. ");
INSERT INTO zak_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kweeki anitumiri nibharaarike abhaatu, kubha bhoono Omukuru, Taatabhugya areerekya omureembe gwaaye.” ");
INSERT INTO zak_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Niigo Yeesu yamariri okusoma amangʼana gayo, akakuundikirya ekitabhu, akamuha omuhokya, akiikara ataange okweegya. Na abhaatu bhoosi bhano bhaari munyuumba ye esaango, bhakamutaangaarira mumeeso. ");
INSERT INTO zak_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Akataanga okubhabhuurira, “Amakaamo Amahoreeru gano mwiigwiiri kwa amatwi geenyu, gakuunaaniri embere weenyu reero.” ");
INSERT INTO zak_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Abhaatu bhoosi bhaari bharamugaamba kisi. Nawe bhaari bhararuguura amangʼana gaaye iguru yo omureembe gwa Taatabhugya, na bhakataanga okwiibhuurya, “Awe, wuno nawe! Atari omwaana wa Yusufu?” ");
INSERT INTO zak_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yeesu akabhabhuurira, “Nawe nitakubha ne ehaha, muraanikyoore ekireengyo kino, ‘Awe omugabhu, wiihorye omweene.’ Neemwe muragaamba, ‘Gano goosi twiigwiiri okoriri mumugye gwa Kaperinaumu, ogakore na mumugye gwaazo hano!’ ” ");
INSERT INTO zak_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Akeenderera okugaamba, “Ndabhabhuurira obhuheene, omurooti atakwiikiriribhwa muroobho yaaye. ");
INSERT INTO zak_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nawe, kwe eheene ndabhabhuurira, kwiibhaga rya Eriya, embura etaatweekiri emyaaka etatu ne emyeeri esaasabha, enzara ekasikira ekyaaro kyoosi kya Iziraeri, na kwiibhaga riyo ekyaaro kyaari na abhatuumba bhaaru. ");
INSERT INTO zak_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Naabhe, Eriya ataatumirwe kuwumwe waabhu, nawe akatumwa kumutuumba wumwe wa Sarepta, mukyaaro kya Sidooni. ");
INSERT INTO zak_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Na mukyaaro kya Iziraeri kwiibhaga ryo omurooti Erisha, bhaabharimu bhe ebhigeenge bhaaru. Naabhe, ataari arimu wowoosi wuno yahorirye, nawe wumwe omweene ego yahorirye neewe ni Naamani wo okurwa mukyaaro kya Siria.” ");
INSERT INTO zak_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Abhaatu bhoosi bhano bhaabhiikumeenie munyuumba ye esaango, hano bhakiigwa amangʼana gayo, bhakatiinda bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Niho bhakiimeerera bhwaangu, bhakagya kumuhuna, tee omuhiriingito omuhaari gwe ekiguru, kino omugye gwaari gwoombokirwe iguru waku, kubha bhamurekere haasi. ");
INSERT INTO zak_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nawe, akahita gatigati we eriihizo rya abhaatu, akagya zaaye. ");
INSERT INTO zak_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Orusiku rumwe, Yeesu akagya mumugye gwa Kaperinaumu, mukyaaro kya Gariraaya. Orusiku rwo okumuunya, akasikira munyuumba ye esaango, na akataanga kweegya. ");
INSERT INTO zak_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Abhaatu bhaari bharuguuriri, kwo okubha ameegyo gaaye gaari no obhuturo. ");
INSERT INTO zak_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na munyuumba ye esaango, yaarimu omuutu wuno yatiirirwe ne eriisaambwa eriibhi. Eriisaambwa riyo, rikarira no okumwaaya, rirabhuga, ");
INSERT INTO zak_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Awe Yeesu wa Nazareeti, otatunyaakya! Mbe, wiiziri kutusikya? Nikumenyiri awe ni weewi, awe ni Muhoreeru wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yeesu akarirekya eriisaambwa riyo akabhuga, “Kira! Noorwe kumuutu wuno!” Niho eriisaambwa eriibhi riyo, rikamugwiisya haasi omuutu wuyo, embere wa abhaatu bhoosi. Kyaamwe, rikarwamu, ritaamunyahaariri. ");
INSERT INTO zak_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Abhaatu bhoosi bhakaruguura bhukongʼu, bhakiibhuurya, “Mangʼanaki gayo? Ndora omuutu wuno, niigo akuswaagya amasaambwa amabhi kwo obhuturo bhwaaye, kubha, garwe mubhaatu, rugeendo rumwe, gararwamu!” ");
INSERT INTO zak_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kweego, amangʼana ge emirimo gya Yeesu, gakabha garanyaragana mukyaaro kyoosi. ");
INSERT INTO zak_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hano Yeesu yarwiiri munyuumba yiyo ye esaango, akasikira munyuumba ya Simooni. Na munyuumba muyo yaarimu inyibhyaara Simooni ni murweeri we ehooma haari. Neebho, bhakamusabha Yeesu amuhorye. ");
INSERT INTO zak_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Niho akiimeerera haguhi neewe, akaswaagya ehooma yiyo, rugeendo rumwe akahora. Omukari wurya akabhuuka, akataanga okubhahokeerya ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na hano eryoobha ryaari riratuubhira, orusiku rwo okumuunya rwaari rurasira, abhanyaroobho bhaaru bhakamureetera Yeesu abharweeri bhaabhu bha amarweeri hagarihagari. Yeesu akabhatuurira bhoosi amabhoko gaaye, akabhahorya. ");
INSERT INTO zak_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hamwe na gayo, Yeesu akaheebha amasaambwa amabhi mubhaatu bhaaru, neego gaari gararira, “Awe ni Mwaana wa Taatabhugya!” Na kwo okubha amasaambwa amabhi gayo, gaari gamenyiri kubha Yeesu niwe Masiya, akagarekya no okugaribhira, gatagaamba kweeki. ");
INSERT INTO zak_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hano kwakiiri, Yeesu akarwa hayo, akagya kibhezo. Abhaatu bhaari bharamumoohya ahagiro hoosi, na hano bhaamuruuzi, bhakeenda kumurekya kubha, atabhatiga. ");
INSERT INTO zak_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nawe, Yeesu akabhabhuurira, “Nireenderwa nigye mumigye egiindi gyoosi, okubha nibharwaazire Amangʼana Amazomu go obhutemi bhwa Taatabhugya. Kwiiguru ya gayo nikyo kikagirya nikatumwa.” ");
INSERT INTO zak_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Niho, Yeesu akahita ekyaaro kya Yudea, ararwaazira abhaatu muziinyuumba zyaabhu zye eziisaango. ");
INSERT INTO zak_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Orusiku rumwe, Yeesu ahaabha yiimeereeri embarika ye Enyaanza ya Genesareeti, yaari areegya abhaatu bhaaru engʼana ya Taatabhugya. Neebho, bhakabha bharamwiiruumbiririra kwo okumuhiga, okubha bhamwiitegeerere. ");
INSERT INTO zak_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ne embarika ye enyaanza hayo, Yeesu akarora amaato abhiri gaari embarika hayo, hano abhategi bhahoogya eziinzero zyaabhu. ");
INSERT INTO zak_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Akatiira mubhwaato obhumwe, bhuno bhwaari bhwa Simooni, akamusabha Simooni kubha, yiisukye obhwaato hasuuhu munyaanza. Niho, Yeesu akiikara muusi yeegye abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na hano akamara kubheegya, akabhuurira Simooni na abharikyaaye, “Mugeendye obhwaato tee mubhuzibhe, mwiikye eziinzero zyeenyu, mutege eziiswe.” ");
INSERT INTO zak_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simooni akamukyoora, “Ee Omukuru weetu, obhutiku kukya twaari turakora emirimo gyo okutega kwo omukya, ndora tutaabhweeni ekigiro! Nawe, kwo okubha naawe waambuuriiri ego, ndaziikya eziinzero bhoono.” ");
INSERT INTO zak_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Niho Simooni na abharikyaaye, bhakiikya eziinzero zyaabhu mumaanzi. Hano bhaakoriri ego, bhakagwaata eziiswe nzaru bhukongʼu, tee eziinzero zyaabhu zikataanga kuraanduka. ");
INSERT INTO zak_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bhakabhirikira abharikyaabhu, bhano bhaari mubhwaato obhuundi, kwo okubhasimya kwa mabhoko bhiize okubhasakirya. Neebho, hano bhakaaza bhakiizurya amaato abhiri eziiswe, tee zikagirya amaato gakabha haguhi okutubhira. ");
INSERT INTO zak_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simooni Petero, hano yaruuzi kyeego bhabhweeni eziiswe, akahigama embere ya Yeesu, akamubhuurira, “Ee Omukuru Yeesu, onitige enye, kwo okubha enye ni we ebhibhi!” ");
INSERT INTO zak_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simooni akabhuga amangʼana gayo, kwo okubha ewe hamwe na abharikyaaye bhoosi, bhakaruguura bhukongʼu obhwaaru bhwe eziiswe zino bhaategiri. ");
INSERT INTO zak_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Bhaari bhariho abhamura bhabhiri bha Zebedaayo, Yaakobo na Yohana, bhahaatega hamwe na Simooni, neebho bhoosi, gayo gakabharuguurya. Niho Yeesu akabhuga, “Awe Simooni, otoobhoha! Kweemera reero yino, orabha omutegi wa abhaatu.” ");
INSERT INTO zak_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kweego Simooni na abharikyaaye, bhakakyoorya amaato kumwaambuko, bhakatiga ebhigiro bhyaabhu bhyoosi, bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yeesu yaari mumugye gumwe, niho akaaza omuutu wumwe we ebhigeenge. Hano we ebhigeenge wuyo yamuruuzi Yeesu, akahigama haasi bhubhuumari embere waaye, akiihiinya tee akahikya obhusyo haasi, akamusabha, “Ee Omukuru, nimenyiri oranagya okunihorya okubha nieribhwe. Eraabhe oryeende, ndasabha onihorye!” ");
INSERT INTO zak_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yeesu akagororokya okubhoko kwaaye, akamubhataku, akamubhuurira, “Ndeenda ohore, weeribhwe!” Hayohayo, akahora obhurweeri bhwaaye. ");
INSERT INTO zak_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kyaamwe, Yeesu akamubhuurira, “Itegeerera, otamubhuurira muutu wowoosi iguru ya rino! Nawe wiiyeerekye kumuseengeri, oruusye ekimweeso kyeego emigiro gya Musa gikuswaagya, okubha weerekye abhaatu kubha weeriibhwe.” ");
INSERT INTO zak_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nawe, amangʼana ga Yeesu, gakoongera okumenywa bhukongʼu kubhaatu. Abhaatu bhaari bhahaamuuzaku amahizo kwa amahizo, korereki bhanagye kwiitegeerera ameegyo gaaye no okuhoribhwa amarweeri gaabhu. ");
INSERT INTO zak_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nawe, Yeesu yaari arabhatiga, aragya kusabha ahagiro hano hataari na abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Orusiku rumwe, Yeesu yaari areegya abhaatu. Na gati yaabhu, bhaari bhiikeeri Abhafarisayo, hamwe na abheegya bhe emigiro. Bhayo, bhakarweera emigye gyoosi gya Gariraaya na Yudea, na abhaandi bhakarweera Yerusaremu. Yeesu yaari na amanaga go okuhorya kurwa ku Mukuru, Taatabhugya, na yaari arahorya abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Niho, abhaatu bhakaaza, bhano bhaari bhagegiri omuutu wuno ebhiimo bhikuuri, eno ahiindiiri kukiigi kyaaye. Bhakeenda kumusikirya munyuumba, na bhamuhiindirye embere wa Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nawe etaaturikeeni, kwe ekigirirye kye esaango ekuru ya abhaatu. Niho bhakatiira kukisara kye enyuumba, eno bhagegiri omuutu wuyo. Hano bhaari kukisara, bhakahobhora omwoobho kwo okumamura eziindigi kuruusara, bhakamwiikya embere ya Yeesu, gati wa abhaatu bhoosi bhayo. ");
INSERT INTO zak_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Hano Yeesu yaruuzi obhwiikirirya bhwaabhu, akamubhuurira, “Omusaani waane, nikwaabhiiri ebhibhi bhyaazo.” ");
INSERT INTO zak_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abheegya bhe emigiro na Abhafarisayo bhayo, niigo bhakiigwa ego bhakataanga kuririirira muziikoro, bharabhuga, “Wuno ni weewi? Ndora aragaamba amangʼana go okumutuka Taatabhugya? Atariho wuno akunagya kwaabhira ebhibhi, ni Taatabhugya omweene ego!” ");
INSERT INTO zak_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yeesu akagamenya goosi gano bhaari bhakwiiseega, akabhabhuurya, “Kwaki muranianga muziikoro zyeenyu? ");
INSERT INTO zak_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni riihe eriihuhu bhukongʼu, okumubhuurira, ‘Nikwaabhiiri ebhibhi bhyaazo,’ kasi okumubhuurira, ‘Imeerera, ogeende?’ ");
INSERT INTO zak_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nawe, ndeenda mumenye bhuzomu kubha, enye Omwaana wo Omuutu nino obhuturo bhwo okwaabhira ebhibhi mukyaaro kino.” Niho Yeesu akamubhuurira omuutu wuyo yaari akuuri ebhiimo, “Ndakubhuurira, imeerera! Gega obhuriri bhwaazo, noogye yiika.” ");
INSERT INTO zak_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hayohayo, omuutu wuyo akiimeerera embere ya abhaatu bhayo, akagega ekiigi kyaaye kino yaari ahiindiriiri, akagya yiika, eno aramukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Abhaatu bhoosi, bhakaruguura bhukongʼu no okugwaatwa no obhwoobha. Bhakabha bharamukumya Taatabhugya, niho bhakabhuga, “Bhamure! Reero, turuuzi amangʼana ge ekiruguuro!” ");
INSERT INTO zak_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hano gayo gaahwiiri, Yeesu akarwa munyuumba, akarora omutobhya we eriigooti wumwe, eriina ryaaye niwe Raawi. Na Raawi wuyo ahaabha yiikeeri mwiitobhero ryaaye ryo okutinira eriigooti. Yeesu akamubhuurira, “Nituniirira!” ");
INSERT INTO zak_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rugeendo rumwe, Raawi akiimeerera, akatiga bhyoosi, akamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Niho, Raawi akamukorera Yeesu enyaangi ekuru yiika waaye. Munyuumba muyo, bhakiikumania abhatobhya bhe eriigooti bhaaru na abhaatu abhaandi, na bhahaabha bhararya hamwe mwiigari. ");
INSERT INTO zak_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ekagirya Abhafarisayo abhaandi, na abheegya bhaabhu bhe emigiro, bhakagya kwiiririirirya kubhaanabheega bha Yeesu, bharabhuga, “Ndora murarya no okunywa hamwe na abhatobhya bhe eriigooti, na abhaandi bhe ebhibhi?” ");
INSERT INTO zak_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yeesu akabhakyoora, “Abhaatu abhahoru bhatakweenda mugabhu, nawe abharweeri nibho bhakumweenda! ");
INSERT INTO zak_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kweego, enye neenye nitiiziri kubhabhirikira bhano bhakwiirora ni bhe eheene embere wa Taatabhugya bhanituniirire, nawe, niiziri kubhabhirikira bhe ebhibhi, okubha bhate ebhibhi bhyaabhu.” ");
INSERT INTO zak_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Abhafarisayo na abheegya bhe emigiro bhayo bhakamubhuurira Yeesu, “Eriibhaga ryaaru abhaanabheega bha Yohana Omubatiizi bhariisiitya ebhyaakurya, hano bhakumusabha Taatabhugya. Neebho abhaanabheega bha Abhafarisayo, nabho bhoosi bharakora egoego. Nawe ndora bho owaazo, bhatakwiiyiima ebhyaakurya, bhareenderera kurya no okunywa!” ");
INSERT INTO zak_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu akabhakyoora, “Hano omukweeri, akubha akyaari hamwe na abhasaani bhaaye enyaangi yo obhweenga, muranagyabhwi kubhakora abhagini bhayo, bhiisiitye ebhyaakurya no okunywa? ");
INSERT INTO zak_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nawe, eziisiku zino zikuuza, zino omukweeri araruusibhwaho gati wa abhasaani bhaaye. Muziisiku ziyo niho abhasaani bhaaye bhakubha ne ebhigoongi no okwiisiitya ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeesu akabhabhuurira ekireengyo ekiindi, akabhuga, “Okusaangya ameegyo gaane amahya ne eziinyaangi zyeenyu, kutuubheeni no omuutu wuno akutina ekiraka kurwa kumweenda omuhya no okukitumira kumweenda omukuungu. Araakore ego, arabha araandwiiri omweenda gwaaye omuhya. Hamwe na gayo, ekiraka kiyo kyo omweenda omuhya, kitakwiisirirana no omweenda omukuungu. ");
INSERT INTO zak_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Na atariho omuutu wuno akutuura amaanzi amahya go omuzabibu mukiribha ekikuungu. Kwo okubha, araakore ego, amaanzi amahya go omuzabibu garaatya ekiribha kiyo, na amaanzi go omuzabibu gariitika. Ekiribha kiyo na amaanzi go omuzabibu gaamu, bhirasarika. ");
INSERT INTO zak_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nawe, amaanzi amahya go omuzabibu, gareenderwa gatuurwe mukiribha ekihya! ");
INSERT INTO zak_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“No omuutu wuno anariri amaanzi go omuzabibu ge ekare, niwe atana enaamba na amaanzi go omuzabibu amahya. Arabhuga, ‘Ge ekare nigo amazomu.’ ” ");
INSERT INTO zak_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Orusiku rumwe rwo okumuunya, Yeesu ahaabha arahita mumiguundu gye engano na abhaanabheega bhaaye, abhaanabheega bhakiigwa enzara, bhakataanga okubhuna ebhigara bhye engano, bhakarya. ");
INSERT INTO zak_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Niho Abhafarisayo abhaandi bhakamubhuurira, “Ndora murakora gano emigiro gitakwiikirirya okukorwa kurusiku rwo okumuunya!” ");
INSERT INTO zak_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yeesu akabhakyoora, “Mbe, mukyaari okusoma mu Makaamo Amahoreeru kyeego Daudi yaakoriri eriibhaga rino ewe na abharikyaaye bhaari ne enzara? ");
INSERT INTO zak_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Akasikira mwiibhuru ryo okumuseengera Taatabhugya, akagega emikaate gino gyaatuurirwe embere wa Taatabhugya, akagirya! Na akabhaha na abharikyaaye. Nawe, emigiro gya Musa giriikirirya kubha, ni bhaseengeri abheene bhakiikiriribhwa okurya emikaate gye etuubho yino.” ");
INSERT INTO zak_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeesu akoongereerera kugaamba, “Ndeenda mumenye bhwaheene kubha enye Omwaana wo Omuutu, niwe Omukuru wo orusiku rwo okumuunya.” ");
INSERT INTO zak_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kurusiku oruundi rwo okumuunya, Yeesu akasikira munyuumba ye esaango, akataanga kweegya abhaatu. Muusi muyo, yaarimu omuutu wumwe, wuno okubhoko kwaaye kwo obhuryo kwaari kukuuri. ");
INSERT INTO zak_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abhafarisayo na abheegya bhe emigiro, bhaari bharamwiiteengera Yeesu, bharore kyeego araahorye omuutu wuyo kurusiku rwo okumuunya, kwo okubha bhaari bharamoohya eriingʼana ryo okumuzoongera. ");
INSERT INTO zak_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nawe, Yeesu akamenya amiiseego gaabhu. Kweego, akamubhuurira omuutu wuno okubhoko kukuuri, “Nawuuze, wiimeerere gatigati hano.” Niho, omuutu wuyo akaaza, akiimeerera gatigati waabhu. ");
INSERT INTO zak_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Niho, Yeesu akabhabhuurira Abhafarisayo na abheegya bhe emigiro, “Nawe, nibhabhuurye amabhuuryo, orusiku rwo okumuunya, emigiro giraturagirira kukoraki? Amazomu kasi amabhi? Orusiku ruyo, tuhorye kasi twiite?” ");
INSERT INTO zak_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yeesu akabharoreerera abhaatu bhayo bhoosi. Niho akamubhuurira omuutu wuyo, “Gororokya okubhoko kwaazo.” Woosi, hano yakugorweeri ego, kukahora. ");
INSERT INTO zak_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Abhafarisayo bhayo, bhakabha no obhururu bhuhaari bhukongʼu. Bhakataanga okwiibhuurya enzira yo okumukorera Yeesu amabhi. ");
INSERT INTO zak_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kuziisiku ziyo, Yeesu akagya kukiguru okumusabha Taatabhugya, akasabha obhutiku kukya. ");
INSERT INTO zak_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hano kwakiiri, akabhabhirikira abhaanabheega bhaaye. Gati waabhu akaahura ikumi na bhabhiri, akabhatoga eriina rya abheega. Na abheega bhayo, nibho bhano: ");
INSERT INTO zak_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simooni, wuno Yeesu akamutoga eriina rya Petero, Andurea mura waabhu Simooni, Yaakobo, Yohana, Firipo, Baritoromaayo, ");
INSERT INTO zak_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataayo, Tomaso, Yaakobo omwaana wa Arifayo, Simooni wuno akubhirikirwa Omuzeroote, ");
INSERT INTO zak_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuuda omwaana wa Yaakobo, na Yuuda Isikariyoti, wuno yamuriiri omukoonyo Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yeesu akiituuma kurwa kukiguru, hamwe na abheega bhaaye. Na hano akahika ahagiro ha mutaandaari, akiimeerera. Hayo, bhakiikumania abhaanabheega bhaaye bhaaru, ne esaango ekuru bhukongʼu ya abhaatu bhano bhaarwiiri mukyaaro kyoosi kya Yudea, kurwa mumugye gwa Yerusaremu, no okurwa ahagiro ho omwaambuko gwa Tiro na Sidooni. Abhaatu bhayo, bhakaaza kumwiitegeerera Yeesu no okuhoribhwa amarweeri gaabhu, ");
INSERT INTO zak_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","na bhano bhaari kunyaakibhwa na amasaambwa amabhi, bharahoribhwa. ");
INSERT INTO zak_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Abhaatu bhoosi, bhaari bharasakya okumugwaataku Yeesu, kwo okubha yaari ne eziinguru zo okuhorya, na akabhahorya bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yeesu akabhiisuunza abhaanabheega bhaaye bhayo, akabhabhuurira, “Hakiriku bhano bhakwiimenya kubha ni bhataka bhe eziikoro, kwo okubha obhutemi bhwa Taatabhugya ni bhweenyu. ");
INSERT INTO zak_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hakiriku bhano bhane enzara bhoono, kwo okubha muriigutibhwa. Hakiriku emwe bhano mukurira bhoono, kwo okubha muraaza kuseka. ");
INSERT INTO zak_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Hakiriku emwe, hano abhaatu bharabhabhiihirirye, kwo okubhaahura, okubhatuka no okubhagaambira amabhi, kwiiguru yo Omwaana wo Omuutu. ");
INSERT INTO zak_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Kuziisiku ziyo, muzomererwe no okubhinabhina. Mumenye kimwe kubha murabha murabhiikirwa esaambo ekuru mwiisaaro, kwo okubha bhazaazi bhaabhu, niigo bhaari bharanyaakya abharooti. ");
INSERT INTO zak_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nawe, muraaza kurora, emwe abhaniibhi, kwo okubha obhuniibhi bhweenyu, mumariri kubhubhona! ");
INSERT INTO zak_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nawe, muraaza kurora bhano mukwiiguta bhoono, kwo okubha eriibhaga rirahita muraaza kusiingira. Muraaza kurora, bhano mukuseka bhoono, kwo okubha muraaza kurira no okuririirira! ");
INSERT INTO zak_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Muraaza kurora, hano abhaatu bhakubhakumya, kwo okubha bhazaazi bhaabhu niigo ego bhaari kukorera abharooti bho orurimi. ");
INSERT INTO zak_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ndabhabhuurira emwe bhano mukuniitegeerera, mubhe muraseega abhabhisa bheenyu. Abhaatu bhano bhakubhabhiihirirya, emwe mubhasakirye. ");
INSERT INTO zak_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Na abhaatu bhano bhakubhiihiima, emwe mubhatweere ebhite. Na abhaatu bhano bhakubhanyaakya bhukongʼu, emwe mubhasabhire ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Omuutu araakuteme etama yimwe, omukyooserye ne eyiindi. No omuutu araakuruusye ekabhuuti yaazo, omutigire agege ne eriigooti. ");
INSERT INTO zak_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wowoosi wuno araakusabhe ekigiro, omuhe. Na omuutu wuno araagege ebhigiro bhyaazo, otamusabha akukyoorerye. ");
INSERT INTO zak_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mubhe murakorera abhaandi kyeego emwe mukweenda bhabhakorere. ");
INSERT INTO zak_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Muraabhaseege bhano bhakubhaseega emwe, ni heene mukoriri engʼana nzomu yo okubhaguungya? Naabhe bhe ebhibhi bhabhaseegiri abhaatu bhano bhakubhaseega! ");
INSERT INTO zak_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kweeki mukusakirya bharya abheene bhakubhasakirya emwe, ni heene mukoriri engʼana enzomu yo okubhaguungya? Naabhe bhe ebhibhi bhoosi, niigo ego bhakukora! ");
INSERT INTO zak_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na muraabhahe eziimbirya bharya abheene mukwiisiga kubha bharabhakyoorerya, ni heene mukoriri engʼana enzomu yo okubhaguungya? Zeyi tiigo! Yiingabha na bhe ebhibhi bhoosi bharabhaha abharikyaabhu, kwo okubha bhariisiga kukyooreribhwa bhyoosi! ");
INSERT INTO zak_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Nawe emwe, mubhaseege abhabhisa bheenyu, mubhasakirye. Mubhahe eziimbirya na mutaaza kuganya kubha murakyooreribhwa. Kweego niigo muraabhone eziisaambo eziikuru, no okubha abhaana bha Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi, kwo okubha Taatabhugya arabhasakirya bhano bhatakubhuga, ‘Ozomirye,’ na abhaatu bhe ebhibhi. ");
INSERT INTO zak_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Murorere ebhigoongi abhaandi, kyeego Wuuso weenyu akubharorera ebhigoongi. ");
INSERT INTO zak_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mutabha muratinira ekiina abhaandi, okubha Taatabhugya ataaza abhatinire ekiina emwe. Na mutagaamba kubha abhaandi bhatinirwe, niho ne emwe mutakutinirwa kibhi. Mubhaabhire abhaatu bhano bhabhahabhirye, niho na neemwe muraabhirwe. ");
INSERT INTO zak_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mubhahe abhaandi ebhigiro, niho na neemwe muraahaabhwe. Ne ebhigiro bhino muraahaabhwe, bhirabha kukireengero ekizomu bhukongʼu. Ekireengero kirasiingisibhwa no okukibhaanda, tee kiizure zabhi no okwiitika. Kwo okubha, ekireengero kino mukureengera abhaandi, nikyo na neemwe muraareengeerwe.” ");
INSERT INTO zak_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu akabhabhuurira ekireengyo kino, “Bhoono heene! Omuhoku aranagya kumukaangatya omuhoku omurikyaaye? Etariho haho, bhoosi bhabhiri bharatubhira mwiiruuma! ");
INSERT INTO zak_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Omwaanamweega atakunagya kumukira omweegya waaye. Nawe, omwaanamweega areenderwa yeegibhwe no okugagwaata goosi, niho araatuubhane no omweegya waaye. ");
INSERT INTO zak_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ndora orarora ekibhorooryo kino kiri muriiso ryo omurikyaazo, nawe otakurora ekiti kino kiri muriiso ryaazo? ");
INSERT INTO zak_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na oranagyabhwi kumubhuurira omurikyaazo wuyo, ‘Awe omuhiiri waane, tiga nikuruusye ekibhorooryo muriiso ryaazo,’ eriibhaga awe omweene one ekiti kino kiri muriiso ryaazo? Awe ni mubheehi! Ruusya ekiti kino kiri muriiso ryaazo. Niho okunagya kurora bhuzomu no okuruusya ekibhorooryo kino kiri muriiso ryo omurikyaazo. ");
INSERT INTO zak_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gutariho omuti omuzomu, guno gukuruusya emisumo emibhiihu. Na gutariho omuti omubhiihu, guno gukuruusya emisumo emizomu. ");
INSERT INTO zak_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Abhaatu bhatakugesa emisumo gye etiini naabhe emizabibu kumiti gya amahwa. No omuti guyo gwoosi gumenyekeeni kumisumo gyaaye. ");
INSERT INTO zak_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Niigo gaari, no omuutu omuzomu aragaamba amazomu kutuukana na amazomu gano giizwiiri mukoro yaaye, nawe omuutu omubhi aragaamba amabhi gano giizwiiri mukoro yaaye. Omuutu arakeerenia gano giizwiiri mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kwaki muraambirikira, ‘Ee Omukuru, ee Omukuru,’ nawe amangʼana gano nikubhabhuurira, mutakugakora? ");
INSERT INTO zak_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wowoosi wuno akuniizaku no okwiitegeerera amangʼana gaane no okugakora, ndabhakeerenerya kyeego araabhe kwe ekireengyo. ");
INSERT INTO zak_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Atuubheeni no omwoomboki we enyuumba wuno yatukiri haasi bhukongʼu, tee akahikira eriitare, akoomboka obhurusa iguru waku. Na kwiibhaga rye embura, ekitaaro kikiizura amaanzi, omusabhuko gukatema enyuumba yiyo. Nawe, etiisiingisirye kwo okubha yaari yoombokirwe bhwaheene. ");
INSERT INTO zak_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Nawe, wuyo woosi wuno akwiitegeerera amangʼana gaane no okutama okugakora, wuyo atuubheeni no omuutu wuno yoombokiri enyuumba yaaye kumarobha ageene, gano gatana obhurusa. Na hano amaanzi ge ekitaaro gakaaza, amaanzi gakiitema enyuumba yiyo, rumwe ego ekagwa haasi, muu! Ekanyamuka yoosi.” ");
INSERT INTO zak_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hano Yeesu yamariri okubhabhuurira esaango ya abhaatu amangʼana gayo goosi, akagya akasikira mumugye gwa Kaperinaumu. ");
INSERT INTO zak_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mumugye guyo yaari arimu omukuru owumwe wa abhasirikare bhe Ekirooma. Omusirikare wuyo, yaari no omuhokya wuno yaamuseegiri bhukongʼu, nawe omuhokya wuyo yaari omurweeri wo okukwa. ");
INSERT INTO zak_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kimwe, omusirikare wuyo, hano akiigwa engʼana iguru ya Yeesu, akatuma abhakaruka abhaandi bha Abhayahudi ku Yeesu, bhamusabhe yiize okumuhorya omuhokya waaye. ");
INSERT INTO zak_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Abhakaruka bhayo, hano bhaahikiri ku Yeesu, bhakamwiisasaama bhukongʼu, bhakamubhuurira, “Omuutu wuno, areenderwa omukorere engʼana yino, ");
INSERT INTO zak_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwo okubha aseegiri abhaatu bha mukyaaro kyeetu. Na niwe atwoombokeeri enyuumba yeetu ye esaango.” ");
INSERT INTO zak_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Niho Yeesu akagya hamwe na abhakaruka bhayo. Na hano bhaari bhagwiisukiiri omugye gwo omukuru wa abhasirikare, omukuru wuyo akatuma abhasaani bhaaye, bhakagya ne engʼana ku Yeesu, bhakamubhuurira, “Ee Omukuru, otiinyaakya bhukongʼu, kwo okubha nitakungʼarira osikire owaane. ");
INSERT INTO zak_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nikarora kubha nitakweenderwa kuuza owaazo. Nawe gaamba engʼana yimwe ego, omuhokya waane arahora. ");
INSERT INTO zak_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nimenyiri arahora, kwo okubha enye noosi niri iyaasi wa abhakuru bhaane, na ninabho abhasirikare iyaasi waane. Ndaamubhuurire owumwe, ‘Noogye,’ aragya. Ndaamubhuurire owuundi, ‘Nawuuze,’ woosi araaza. No omugya waane, ndaamubhuurire, ‘Kora ego,’ niigo araakore.” ");
INSERT INTO zak_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Hano Yeesu akiigwa gayo, akamuruguura bhukongʼu. Akiikibhukira esaango ya abhaatu bhano bhaari bharamutuniirira, akabhabhuurira, “Ndabhabhuurira, naabhe gati wa Abhiiziraeri bhoosi, nikyaari kurora omuutu wowoosi wo obhwiikirirya bhukuru kya bhuno!” ");
INSERT INTO zak_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na hano abhasaani bho omusirikare bhaakyooriri mumugye gwo omusirikare wuyo, bhakabhona omuhokya ahoriri. ");
INSERT INTO zak_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eriibhaga isuuhu, Yeesu akagya kumugye gwa Naini, hamwe na abhaanabheega bhaaye, na abhaatu abhaandi bhaaru bhaari bharamutuniirira. ");
INSERT INTO zak_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na hano yaari ariisukira ekisyooko kyo omugye, akasikana na abhaatu bhano bhaari bhakigegiri ekituundu kyo omumura bharakihira igutu yo omugye. Omumura wuyo, yaari omwaana omweene kunina, neewe yaari omutuumba. Omukari wuyo, yaari arageendania na abhaatu bhaaru bho omugye guyo. ");
INSERT INTO zak_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hano Omukuru yamuruuzi omutuumba wuyo, akamurorera ebhigoongi, akamubhuurira, “Otarira.” ");
INSERT INTO zak_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Akiisukira ekirago kino omuku yaari iguru waku, akakikuniaku. Na abhaatu bhano bhaari bhakigegiri, bhakiimeerera. Yeesu akabhuga, “Awe omumura, ndakubhuurira, bhuuka!” ");
INSERT INTO zak_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Omumura wurya yaari akuuri, hayohayo akabhuuka, akiikara, akataanga kukeerenia kweeki. Niho, Yeesu akamugwaatya nina waabhu. ");
INSERT INTO zak_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Abhaatu bhayo bhoosi, bhakaruguura no okugwaatwa no obhwoobha bhwaaru, bhakataanga kumukumya Taatabhugya, bharabhuga, “Omurooti omukuru arweereri gati yeetu!” Bhakagaamba kweeki, “Taatabhugya yiiziri kusakirya abhaatu bhaaye!” ");
INSERT INTO zak_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na amangʼana gayo iguru ya Yeesu, gakanyaragana bhukongʼu mu Yudea yoosi, na mubhyaaro ebhiindi bhya haguhi. ");
INSERT INTO zak_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Hano Yeesu ahaabha arakora gayo goosi, Yohana akiigwa amangʼana okurwa kubhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kweego Yohana neewe akabhabhirikira abhabhiri bhaabhu, akabhatuma bhagye kumubhuurya Yeesu, “Awe naawe Masiya wuno araaze, kasi tumuganye owuundi?” ");
INSERT INTO zak_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hano abhabhiri bhayo bhaamuhikiiri, bhakamubhuurira, “Yohana Omubatiizi atutumiri kwaawe, tukubhuurye, ‘Awe naawe Masiya wuno araaze, kasi tumuganye owuundi?’ ” ");
INSERT INTO zak_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kwiibhaga riyoriyo, Yeesu ahaabha arahorya abhaatu bhaaru amarweeri gaabhu, na bhano bhaari bhayaangahiri na amasaambwa amabhi. Na ahaabha arahorya abhahoku bhaaru, bharore. ");
INSERT INTO zak_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Niho, Yeesu akabhakyoora, “Mugye mumubhuurire Yohana gano muruuzi, na gano mwiigwiiri. Abhahoku bhararora, amagata bharageenda, abhageenge bharahora, abharibhi bha amatwi bhariigwa, abhaku bhararyoorwa na abhataka bhararwaazirwa Amangʼana Amazomu ga Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hakiriku omuutu wuno akugeenderera kuniikirirya kutama kubha no obhwiitiimaati iguru waane!” ");
INSERT INTO zak_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kumara abhabhiri bhayo bhakagya, Yeesu akataanga okubhuurira esaango ya abhaatu iguru wa Yohana. Akabhabhuurya, “Hano mwaagiiri mwiitirigo kurora Yohana, mbe, mukagya kuroraki? Mbe, mukagya kurora omuutu wuno akwiikirirya amangʼana goosi kyeego maara yino ekusiingiswa kwo obhukama? Zeyi. ");
INSERT INTO zak_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ambe, mukagya kuroraki? Mbe, mukagya kumurora omuutu wuno yiibhohiri emyeenda emizomu? Zeyi. Abhaatu bhano bhakwiibhoha emyeenda gyo obhuguri obhukuru no okwiizomya kwo obhwaaru bhwe ebhigiro, bhayo bharabha bhariikara muziinyuumba zye ekitemi. ");
INSERT INTO zak_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Nawe, mukagya kuroraki? Mbe, mukagya kumurora omurooti omurebhe? Eheene ni murooti, kweeki ndabhabhuurira, Yohana ni mukuru kukira omurooti. ");
INSERT INTO zak_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wuyo niwe wuno Amakaamo Amahoreeru gakubhuga iguru waaye, ‘Rora, ndamuragania omuhokya waane embere waazo, okubha akweeyeerye enzira.’” ");
INSERT INTO zak_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeesu akabhuga kweeki, “Ndabhabhuurira obhuheene, mubhaatu bhoosi bhano bhiibhwiirwe mukyaaro akyaari kutuuka omukuru kukira Yohana Omubatiizi. Nawe omuutu omusuuhu kukira bhoosi mubhutemi bhwa Taatabhugya, niwe omukuru kukira Yohana Omubatiizi.” ");
INSERT INTO zak_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Abhaatu bhayo bhoosi, hamwe na abhatobhya bhe eriigooti, hano bhakiigwa amangʼana ga Yeesu, bhakiikirirya kubha amiiseego ga Taatabhugya gaari mazomu, kwo okubha nibho bharya Yohana yabhabatiiziri. ");
INSERT INTO zak_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nawe Abhafarisayo na abheegya bhe emigiro, bhakaanga amiiseegi ga Taatabhugya kweebho, kwo okubha bhataabatiizirwe na Yohana. ");
INSERT INTO zak_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kweeki Yeesu akabhuga, “Abhaatu bho orwiibhuro runo, nibhatuubhanie naki? Ni bha tuubhoki? ");
INSERT INTO zak_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhatuubheeni na abhaana bhano bhakwiikara kumuteera, bharabhirikira abharikyaabhu, ‘Tukabhatemera ekireere, nawe mutaabhiniri! Tukabheembera ameembo go okwaaramira, nawe mutaaririri!’ ");
INSERT INTO zak_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Kweego, hano Yohana Omubatiizi yiiziri, yaari atakurya emikaate, naabhe okunywa amaanzi go omuzabibu. Emwe muragaamba kubha, agwaatirwe ne eriisaambwa eriibhi! ");
INSERT INTO zak_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Enye Omwaana wo Omuutu hano niiziri, nihaabha ndarya ebhyaakurya bhye eziisiku zyoosi na nihaanywa amaanzi go omuzabibu, bhakabhuga, ‘Murore! Wuno ni musoohu no omunywi, kweeki ni musaani wa abhatobhya bhe eriigooti, na abhaatu bhe ebhibhi!’ ");
INSERT INTO zak_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nawe, amangʼeeni ga Taatabhugya gararorekana kubha ge eheene kwe enzira ya abhaatu bhoosi bhano bhakumwiigwa.” ");
INSERT INTO zak_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yaari ariho Omufarisayo owumwe, akamuginihya Yeesu yiize kurya owaaye. Niho, Yeesu akasikira mumugye gwaaye, akabha mwiigari. ");
INSERT INTO zak_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na mumugye muyo, yaari arimu omukari owumwe, wuno amenyekeeni kubha ariikara obhwiikari obhubhi. Omukari wurya, hano akiigwa kubha Yeesu ararya wo Omufarisayo wuyo, akasikira muyo ne enzubha yino ekorirwe ne eriigina eryeero, na yaari etuurirwemu amaguta gano gakureetya. ");
INSERT INTO zak_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Akiimeerera haguhi na amaguru ga Yeesu, akataanga kurira. Eziingusuri zaaye zikatoonyera amaguru ga Yeesu, yaari arazitarikya ne eziinzweeri zyaaye, akahuumbatahuumbata amaguru gaaye, no okumuhaka amaguta go omuruumbaaso. ");
INSERT INTO zak_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Omufarisayo wuyo, hano yaruuzi gayo, akiiseega mukoro yaaye, “Omuutu wuno, yaangabheeri omurooti, yaangamenyiri kubha, omukari wuno akumukunia, ni muutu wa tuubhoki. Yaangamenyiri kubha, ewe ariikara obhwiikari obhubhi!” ");
INSERT INTO zak_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yeesu akamubhuurira, “Awe Simooni, nine engʼana yo okukubhuurira.” Woosi akamukyoora, “Ee Omweegya, mbuurira.” Niho, Yeesu akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Bhahaabhaho abhaatu bhabhiri, bhano bhoosi bhaari bharatunibhwa eziimbirya no omuhaani. Owumwe waabhu, ahaabha agegiri eziidinaari magana ataano (500). Omurikyaaye woosi, akagega eziidinaari miroongo etaano (50). ");
INSERT INTO zak_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhoosi bhabhiri, bhakabhurwa eziimbirya zyo okumuriha endihi yo omuhaani wuyo. Kyaamwe omuhaani akabhaabhira, bhatariha. Bhoono, gati wa abhabhiri bhayo, ni wuuhe araamuseege bhukongʼu?” ");
INSERT INTO zak_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simooni akamukyoora, “Ndiiseega kubha, arabha ni wurya yaabhiirwe endihi ekuru.” Yeesu akamubhuurira, “Eriikyooro ryaazo ni zomu.” ");
INSERT INTO zak_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Niho, Yeesu akamwiikibhukira omukari wuyo, akamubhuurira Simooni, “Oramurora omukari wuno? Kweema nisikiiri mumugye gwaazo, otaanisuungʼaaniri kwo okuuniha amaanzi go okwiisaabha amaguru gaane, nawe ewe, aniisaabhirye amaguru gaane ne eziingusuri zaaye, no okugatarikya ne eziinzweeri zaaye. ");
INSERT INTO zak_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na hano wanikeerirye, otaanihuumbatiri, nawe ewe, okurwa eriibhaga nisikiiri muno, akyaari kurosa kuhuumbata amaguru gaane. ");
INSERT INTO zak_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Otaanisuukiri kwo okunihaka amaguta omutwe gwaane, nawe ewe, ahakiri amaguru gaane, amaguta go okureetya! ");
INSERT INTO zak_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kweego ndakubhuurira, kwo okubha ebhibhi bhyaaye bhyaaru bhyaabhiirwe, akeerekya obhuseegi bhwaaru. Kyaamwe, wuyo woosi wuno yaabhiirwe ebhibhi bhisuuhu, areerekya obhuseegi bhusuuhu.” ");
INSERT INTO zak_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Niho, Yeesu akamubhuurira omukari wuyo, “Nikwaabhiiri ebhibhi bhyaazo.” ");
INSERT INTO zak_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abhagini abhaandi bhano bhaari mwiigari, bhakataanga kwiibhuurya, “Ni weewi wuno, aratura okwaabhira ebhibhi?” ");
INSERT INTO zak_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Niho, Yeesu akamubhuurira omukari wuyo, “Obhwiikirirya bhwaazo bhukuhonirye. Ogye no omureembe.” ");
INSERT INTO zak_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kyaamwe, Yeesu yaari aragya kuhita mumigye na muziiroobho. Yaari arabharwaazira abhaatu amangʼana amazomu go obhutemi bhwa Taatabhugya. Akagya hamwe na abheega bhaaye ikumi na bhabhiri, ");
INSERT INTO zak_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na abhakari abhaandi bhano yaari abhahorirye amarweeri gaabhu, no okubharuusya amasaambwa amabhi. Musaango ya abhakari bhayo, yaariho Mariamu wa mumugye gwa Magidara, wuno Yeesu yaari amuruusirye amasaambwa amabhi muhuungati. ");
INSERT INTO zak_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na yaariho Yoana, omukari wa Kuza. Kuza wuyo, niwe yaari yiimeerereeri ebhigiro bhyo omutemi Herode. Bhaari bhariho Suzana na abhakari abhaandi bhaaru. Abhakari bhayo, bhaari bhararuusya ebhigiro bhyaabhu, kwo okubhasakirya Yeesu na abheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Orusiku rumwe, abhaatu bha mumigye myaaru, bhaari bharamuuzaku Yeesu, bhakiikumania esaango ekuru. Niho, akabhabhuurira ekireengyo kino, akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yaariho omubhusuri wumwe wuno yagiiri mumuguundu gwaaye okubhusura eziimbibho zyaaye. Hano yaari akubhusura, eziimbibho eziindi zikagwa kunzira, zikatazwa, ne ebhinyonyi bhikaaza bhikazirya. ");
INSERT INTO zak_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eziimbibho eziindi zikagwa kurukerege, na hano zyameriri, zikabhurwa amaanzi, zikooma. ");
INSERT INTO zak_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eziindi zikagwa gati wa amahwa, na hano zyameriri, zikahigwa, zikakwa. ");
INSERT INTO zak_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ne eziindi zikagwa mumarobha amazomu, na hano zyakongʼiri, zaari zirageswa eziimbibho zyoosi igana igana (100)!” Eriibhaga Yeesu akamara kugaamba gayo, akatiirya eriiraka arabhuga, “Wa amatwi, yiitegeerere kisi!” ");
INSERT INTO zak_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abhaanabheega bha Yeesu bhakamubhuurya, “Ekireengyo kino, kireegyaki?” ");
INSERT INTO zak_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Akabhakyoora, “Taatabhugya abhakuundukuriiri emwe okumenya eziimbiso zyo obhutemi bhwaaye. Nawe, abhaandi ndabhabhuurira kwe ebhireengyo okubha ebhe kyeego omurooti Isaya akabhuga, ‘Yiingabha bhariisuunza, bhatakurora. Na yiingabha bhariigwa, bhatamenyeekererya.’ ");
INSERT INTO zak_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Obhugazuro bhwe ekireengyo kino, nibhwo bhuno: Embibho ni ngʼana ya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ne eziimbibho zino zyagwiiri kunzira, zireerekya abhaatu bhano bhariigwa engʼana ya Taatabhugya, nawe, hayohayo, Seetaani araaza arayiruusya muziikoro zyaabhu, bhataaza kuyiikirirya no okutuuribhwa. ");
INSERT INTO zak_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Ne eziimbibho zino zyagwiiri kurukerege, zireerekya abhaatu bhano bhariigwa engʼana ya Taatabhugya, bharayigega kwo obhuzomererwa, bharayiikirirya kwiibhaga. Nawe hano bhakusakibhwa, bharayitiga, kwo okubha bhatuubheeni ne ebhituutu bhino bhitana emiri. ");
INSERT INTO zak_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Ne eziimbibho zino zyagwiiri gati wa amahwa, zireerekya abhaatu bhano bhakwiigwa engʼana ya Taatabhugya, nawe hasuuhwiigo, bharabha ne ehaha, enaamba yo obhuniibhi, no okuzomererwa ebhigiro bhye ekyaaro. Amangʼana gayo gakubha mubhwiikari bhwaabhu, garabhakora abhaatu bhayo bhatuubhane ne ebhituutu bhino bhitakuruusya emisumo emizomu. ");
INSERT INTO zak_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ne eziimbibho zino zyagwiiri mumarobha amazomu, zireerekya abhaatu bhano bhakwiigwa engʼana ya Taatabhugya. Bharayigwaatirira kwe eziikoro nzomu, bharayiigwa no okuyibhiika kwo obhwiikongʼeererya, tee hano bharaatuubhane ne ebhituutu bhino bhikwiibhura emisumo. ");
INSERT INTO zak_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Atariho omuutu wuno akwaakya etara, okumara ayikuundikirye, kasi ayituure mwiiruungu. Nawe arayituura iguru mukikuumbo, okubha abhaatu hano bhakusikira, bharore obhweero. ");
INSERT INTO zak_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Niigo ego, goosi gano gabhisirwe bhoono, garaaza kukuundukurwa. Na bhyoosi bhino bhikuundikiirwe, bhirakuundukurwa. ");
INSERT INTO zak_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kweego, mugiitegeerere bhwaheene kyeego mukwiigwa! Wowoosi wuno akwiikirirya amangʼana ga Taatabhugya no okugamenya, Taatabhugya aramusakirya no okumwoongerya okugamenya. Nawe wowoosi wuno atakwiikirirya gayo, Taatabhugya aramuteesya naabhe ekisuuhu kino akwiiseega kubha anakyo.” ");
INSERT INTO zak_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Niho, nina na bhawamwaabhu Yeesu, bhakaaza kumurora. Nawe bhataanagirye kumwiisukira, kwo okubha abhaatu bhaaru bhaari bharahigana. ");
INSERT INTO zak_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Abhaatu abhaandi bhakamubhuurira Yeesu, “Nina weenyu na bhawamweenyu, bhiimeereeri igutu, bhareenda bhakurore.” ");
INSERT INTO zak_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yeesu akabhakyoora, “Maayi na bhawamweetu, ni bhoosi bhano bhakwiigwa engʼana ya Taatabhugya, no okuyigwaata.” ");
INSERT INTO zak_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Orusiku rumwe, Yeesu akatiira mubhwaato, hamwe na abhaanabheega bhaaye, akabhaswaagya, “Twaambuke enyaanza.” Kyaamwe, bhakagya. ");
INSERT INTO zak_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hano bhaari bhakugya, mubhwaato muyo Yeesu akasuundagira. Niho munyaanza muyo, bhukatuuka obhukama obhuhaari bhukongʼu. Obhwaato bhuyo, bhukataanga kwiizura amaanzi, na bhoosi bhakabha munyaako. ");
INSERT INTO zak_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Abhaanabheega bhayo, bhakamugyaku Yeesu, bhakamubhuukya, bhakamubhuurira, “Omukuru weetu, Omukuru weetu, turasika!” Yeesu akabhuuka. Niho, akarekya obhukama obhuhaari na amabhooka, bhikahoreera. Bhikakira, hakabha kiri. ");
INSERT INTO zak_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Niho, Yeesu akabhabhuurya abhaanabheega bhaaye, “Obhwiikirirya bhweenyu bhuri hayi?” Abhaanabheega bhayo bhakoobhoha no okuruguura bhukongʼu, eno bhakiibhuurya, “Ni weewi wuno, arahama obhukama obhuhaari na amabhooka, na bhyoosi bhiramwiigwa?” ");
INSERT INTO zak_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yeesu na abhaanabheega bhaaye, hano bhaambukiri Enyaanza ya Gariraaya, bhakahikira ekyaaro kya Abhagerasi, kurubhaara rwa kabhiri rwe ekyaaro kya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na hano Yeesu akiituuma kumwaambuko, akasikana no omuutu owumwe wa mumugye gurya, wuno yaari na amasaambwa amabhi. Kwiibhaga itaambi atahiikara yiika, ahiikara muziimbiihira zya mumabhigi, ne eriibhaga riyo ryoosi ahaageenda kingʼaabhi. ");
INSERT INTO zak_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Eriisaambwa eriibhi riyo, ryaari riramunyaakya kaaru. Abhaatu bhahaabha bharamuriibha kwo okumubhoha ne eminyororo ne ebhiraangʼani. Nawe, ahaabha arabhibhunabhuna, ne eriisaambwa eriibhi rihaamuhira ahagiro hano hataari na abhaatu. Hano omuutu wuyo yasikeeni na Yeesu, Yeesu akaswaagya eriisaambwa riyo eriibhi rimuhurukemu. Omuutu wuyo akiirirya kwiiraka ikuru, akiirekera bhubhuumari embere wa Yeesu, akamubhuurira, “Awe Yeesu Omwaana wa Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi, ona ngʼanaki neenye? Ndakwiisasaama kubha otaninyaakya!” ");
INSERT INTO zak_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yeesu akamubhuurya, “Eriina ryaazo ni weewi?” Akamukyoora, “Eriina ryaane ni Ihizo.” Akagaamba ego, kwo okubha amasaambwa maaru gaari gamusikiriiri. ");
INSERT INTO zak_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Amasaambwa gayo, gakataanga kumwiisasaama Yeesu, akagaswaagya gagye mumwoobho gwa nyaari. ");
INSERT INTO zak_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kwaari ne eriihizo ikuru rye eziimbiizi, rino ryaari rikuriisya embarika we ekiguru. Ekiguru kiyo kyaari ne ekihiriingito ekihaari. Ne eyo ryaari ririho eriihizo ikuru rye eziimbiizi, zino zaari kuriisya. Kyaamwe, amasaambwa gayo gakamwiisasaama Yeesu kubha, agahe orugusa gagye gasikire muziimbiizi. Akagabhuurira gagye, ");
INSERT INTO zak_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","gakahuruka kumuutu wuyo, gakagya gakiisikirya kuziimbiizi ziyo. Hayohayo, eriihizo ryoosi rikahiriingita kwa bhwaangu kumuhiriingito muhaari, rikasikira munyaanza no okukwa. ");
INSERT INTO zak_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bhaariho abhariisya bhe eziimbiizi ziyo. Hano bhaaruuzi gayo goosi gaatuukiri, bhakaryaara, bhakaraarika amangʼana gayo mwiiboma na mumigye gya haguhi. ");
INSERT INTO zak_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kweego, abhaatu bhakaaza kurora amangʼana gayo kyeego gaari gatuukiri, bhakamuhikira Yeesu. Hano bhakamuhikira, bhakamurora omuutu wuno, amasaambwa amabhi gaari gahurukirimu. Yaari yiikeeri haguhi na amaguru ga Yeesu, yiibhohiri emyeenda, na ana amangʼeeni goosi. Abhaatu bhayo, bhakagwaatwa no obhwoobha. ");
INSERT INTO zak_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abhaatu bharya bhano bhaaruuzi ebhitiika bhyoosi, bhakabhuurira abharikyaabhu kyeego wurya ahoriibhwe. ");
INSERT INTO zak_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Niho abhaatu bhoosi bhano bhaari bhiikumeenie kurwa mukyaaro kya Abhagerasi, bhakagwaatwa no obhwoobha bhukongʼu. Bhakamusabha Yeesu kubha arwe owaabhu. Kweego, akatiira mubhwaato, okubha atanure. ");
INSERT INTO zak_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omuutu wuno amasaambwa amabhi garwirimu, akamwiisasaama Yeesu kubha bhagye hamwe. Nawe Yeesu akamukyoorya, akamubhuurira, ");
INSERT INTO zak_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Okyoore yiika weenyu, obhabhuurire abhaatu gano Taatabhugya akukoreeri.” Niho, omuutu wuyo akabhuuka hayo, akagya arabharwaazira abhaatu bhoosi bha mumugye guyo, goosi gano Yeesu yamukoreeri. ");
INSERT INTO zak_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Hano Yeesu yakyooriri Gariraaya, akasuungʼaanwa ne esaango ya abhaatu, kwo okubha bhahaamuganya. ");
INSERT INTO zak_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Niho, akaaza omuutu owumwe, eriina ryaaye niwe Yairo, omukaangati we enyuumba ye esaango, akahigama embere wa Yeesu. Akamwiisasaama kubha yiize mumugye gwaaye, ");
INSERT INTO zak_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwo okubha omuukya waaye omweene ego we emyaaka ikumi ne ebhiri, yaari haguhi kukwa. Eriibhaga Yeesu yaari aragya harya, esaango yiyo ya abhaatu yaari eramutuniirira no okumuhiga bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na gati wa abhaatu bhayo, yaariho omukari, wuno ahaabha no obhurweeri bhwo obhureegu kwe emyaaka ikumi ne ebhiri. Yiingabha yaari amariri obhuniibhi bhwaaye bhwoosi, okuriha abhagabhu, ataari ariho wuno akanagya kumuhorya. ");
INSERT INTO zak_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kyaamwe, omukari wuyo akaaza inyuma wa Yeesu, akakuniaku omuriingo gwo omweenda gwaaye. Rugeendo rumwe, obhurweeri bhwaaye bhukahora. ");
INSERT INTO zak_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yeesu akabhuurya, “Wuno anikuniryeku ni weewi?” Bhoosi bhakabhuga, “Atariho wuno akukuniryeku.” Petero woosi akamubhuurira Yeesu, “Ee Omukuru, abhaatu mbaaru bhakukwiiruguura no okukuhiga!” ");
INSERT INTO zak_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kyaamwe, Yeesu akabhuga, “Nimenyiri ariho omuutu wuno anigwaatiriku, kwo okubha ndiigwa, obhunagya bhwo okuhorya bhunirwiiriku.” ");
INSERT INTO zak_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Omukari wuyo, hano yaruuzi atana enzira yo okwiibhisa kweeki, akaaza ku Yeesu, ararigita. Akatema ebhiru, akamubhuurira embere ya abhaatu bhayo bhoosi, ekigirye kyo okumugwaataku, ne enzira yino ahoriibhwe rugeendo rumwe ego. ");
INSERT INTO zak_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yeesu akamubhuurira, “Muukya waane, obhwiikirirya bhwaazo bhukuhonirye! Ogye no omureembe.” ");
INSERT INTO zak_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Hano Yeesu yaari akyaakeerenia no omukari wuyo, abhaatu bhakaaza okurwa mumugye gwa Yairo, omukaangati we enyuumba ye esaango, bhakabhuga, “Yairo, omuukya waazo amariri kukwa. Kwaki orageenderera kumunyaakya Omweegya?” ");
INSERT INTO zak_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hano Yeesu akiigwa amangʼana gayo, akabhuurira Yairo, “Otoobhoha! Obhe no obhwiikirirya, no omuukya waazo arahoribhwa.” ");
INSERT INTO zak_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hano Yeesu yahikiri mumugye gwa Yairo, akarekya abhaatu abhaandi okusikira munyuumba murya. Nawe akabhiikirirya Petero, Yohana, Yaakobo, na abhiibhuri bho omuukya wuyo bhasikire neewe. ");
INSERT INTO zak_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Abhaatu bhoosi mumugye guyo, bhaari bhararira no okwaaramira oruku rwo omuukya wuyo. Niho Yeesu akabhabhuurira, “Mutige kurira! Omuukya wuno akyaari kukwa, nawe ahiindiiri!” ");
INSERT INTO zak_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Abhaatu bhayo bhakamuseka, kwo okubha bhaari bhamenyiri akuuri. ");
INSERT INTO zak_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yeesu, akagwaata okubhoko kwo omuukya wuyo, akamubhuurira, “Awe omwaana waane, bhuuka!” ");
INSERT INTO zak_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Rugeendo rumwe, omuukya wuyo, ekoro yaaye ekamukyoorera, akiimeerera. Yeesu akabhabhuurira kubha, bhamuhe ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hano abhiibhuri bhaaye bhaaruuzi gayo, bhakaruguura bhukongʼu. Kyaamwe Yeesu akabharekya kubha, bhatamubhuurira omuutu wowoosi gano gatuukiri. ");
INSERT INTO zak_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Orusiku rumwe, Yeesu akabhabhirikira abhaanabheega bhaaye ikumi na bhabhiri, akabhaha obhunagya bhwo okuheebha amasaambwa amabhi okurwa kubhaatu, no okuhorya amarweeri. ");
INSERT INTO zak_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Akabharagania, bhagye kurwaazira abhaatu amangʼana go obhutemi bhwa Taatabhugya, na bhahorye abharweeri. ");
INSERT INTO zak_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Akabhabhuurira, “Kurugeendo rweenyu mutagega kigiro kyokyoosi, ebhe hiimbo, ibhe sakwa, bhibhe bhyaakurya, zibhe mbirya naabhe emyeenda ebhiri. ");
INSERT INTO zak_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Munyuumba yoyoosi yino bhakubhasuungʼaana, mwiikare muyomuyo, tee hano muraatanure mumugye guyo. ");
INSERT INTO zak_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne eraabhe abhaatu bho omugye gwogwoosi bhatakubhaginihya, murwemu, na mwiikungʼuute oruteeri kumaguru geenyu. Okukora ego, ebhe obhweerekeereryo bhwo obhubhi bhwaabhu.” ");
INSERT INTO zak_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Niho abheega bhayo, bhakagya bhakahita mumigye. Bhaari bhararwaazira abhaatu Amangʼana Amazomu no okuhorya abharweeri bha ahagiro hoosi. ");
INSERT INTO zak_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Omutemi Herode, yaari ariigwa goosi gano Yeesu yaari kukora, nigo gakamutitiikania, kwo okubha abhaatu abhaandi bhaari bharabhuga kubha, Yeesu niwe Yohana aryookiri mubhaku. ");
INSERT INTO zak_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Na abhaandi, bhaari bharagaamba kubha, omurooti Eriya yiiziri kweeki. Nawe abhaandi bhaari bharabhuga kubha, owumwe wa abharooti bhe ekare aryookiri. ");
INSERT INTO zak_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kyaamwe, Herode akabhuga, “Yohana, niamutiniri omutwe! Ni weewi wuyo, wa amangʼana ge eteemwa yiyo nikwiigwa?” Kweego, yaari aramoohya enzira arorane na Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Abheega bhayo bha Yeesu, bhakakyoora ku Yeesu, bhakamubhuurira goosi gano bhakoriri. Niho, akabhakaangata bhakagya abheene mumugye gwa Betisaida. ");
INSERT INTO zak_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nawe abhaatu bhakabhona amangʼana kubha agiiri harya, bhakamutuniirira. Akabhasuungʼaana bhuzomu, akataanga kubheegya amangʼana go obhutemi bhwa Taatabhugya, na yaari arahorya abharweeri gati yaabhu. ");
INSERT INTO zak_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na hano yahikiri engoroobha, abheega bhayo ikumi na bhabhiri, bhakagya bhakamubhuurira, “Hano turi, ni mwiitirigo. Obharage abhaatu bhano, bhagye mumigye ne eziinyuumba zya haguhi, kubha bhiibhonere obhuraari ne ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yeesu akabhakyoora, “Emwe, mubhahe ebhyaakurya.” Bhakamukyoora, “Twoosi tutana ebhyaakurya, tunagyo emikaate etaano ne eziiswe ibhiri ego. Oreenda heene, tugeende tubhagurire ebhyaakurya abhaatu bhoosi bhano?” ");
INSERT INTO zak_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na abhasubhe bhaari kye ebhikwe bhitaano (5,000). Yeesu akabhabhuurira abhaanabheega bhaaye, “Bhabhuurire abhaatu bhayo bhiikare amagari kumagari, eriigari riyo ryoosi ribhe na abhaatu miroongo etaano (50).” ");
INSERT INTO zak_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Niho, bhakakora kyeego abhaswaagirye, tee abhaatu bhoosi bhaari bhiikeeri. ");
INSERT INTO zak_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeesu akagega emikaate giyo etaano ne eziiswe ibhiri. Akaroreerera mwiisaaro, akabhuga, “Ozomirye, Taatabhugya.” Niho akagibhega, akabhaha abhaanabheega bhaaye, kubha bhabhahaane abhaatu bhayo. ");
INSERT INTO zak_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhoosi bhakarya, bhakiiguta. Bhakakumania amasaagyo ge ebhyaakurya, gakiizurya ebhikapu ikumi na bhibhiri. ");
INSERT INTO zak_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Orusiku rumwe, Yeesu na abhaanabheega bhaaye, bhaari hamwe kibhezo. Yeesu yaari aramusabha Taatabhugya. Hano yamariri, akabhabhuurya, “Abhaatu bharabhuga kubha enye ni weewi?” ");
INSERT INTO zak_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhakamukyoora, “Abhaandi bharabhuga kubha, awe ni Yohana Omubatiizi. Na abhaandi bharabhuga, awe ni murooti Eriya. Yiingabha abhaandi bharabhuga kubha, awe ni murooti we ekare aryookiri.” ");
INSERT INTO zak_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yeesu akabhabhuurya kweeki, “Na neemwe murabhuga enye ni weewi?” Petero akamukyoora, “Awe niwe Masiya okurwa ku Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yeesu akabharekya bhatabhuurira muutu engʼana yiyo. ");
INSERT INTO zak_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Akabhabhuurira, “Enye Omwaana wo Omuutu, nireenderwa nibhone enyaako nzaru, niangwe na abhakaruka bha Abhayahudi, na abhakuru bha abhaseengeri, na abheegya bhe emigiro, na niitwe. Nawe, orusiku rwa katatu, eheene ndaryoorwa.” ");
INSERT INTO zak_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yeesu akabhabhuurira bhoosi, “Omuutu wowoosi wuno akweenda kunituniirira, areenderwa yiiyaange omweene, agege omusaraba gwaaye eziisiku zyoosi, anituniirire. ");
INSERT INTO zak_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Omuutu wowoosi wuno akweenda kutuurya obhwiikari bhwaaye omweene, arabhubhurya. Nawe omuutu wowoosi wuno araabhurye obhwiikari bhwaaye kwiiguru waane, niwe araabhutuurye. ");
INSERT INTO zak_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kuna bhweeraki bhwo omuutu, okubhona obhuniibhi bhwoosi bhwe ekyaaro kyoosi, nawe yiibhurye omweene? ");
INSERT INTO zak_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Hano enye Omwaana wo Omuutu nikwiika na bhamaraika abhahoreeru mubhuguungo bhwa Taata waane, ndamurorera eziisoni omuutu wowoosi wuno akunirorera enye eziisoni na ameegyo gaane. ");
INSERT INTO zak_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ndabhabhuurira obhuheene, bhariho abhamwe gati weenyu bhano bhatakukwa bhakyaari okurora obhutemi bhwa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hano eziisiku inyaanye zyahitiri, Yeesu akagega Petero, Yohana na Yaakobo, akatiira nabho mukiguru, agye kusabha ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hano yahikiri mukiguru, akataanga kumusabha Taatabhugya. Niho, obhusyo bhwaaye bhukiikyoora, eziingibho zaaye, zikabha mirabhu pee, zikamesya bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Hayohayo, bhakarorekana kwo obhuguungo Musa na Eriya bharakeerenia na Yeesu, kyeego Taatabhugya yeendiri amare oruku rwaaye Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kwiibhaga riyo, Petero na abhaandi bhaari bhahiindiiri eziitiro ndito. Na hano bhaabhuukiri, bhakamurora Yeesu aramesya mubhuguungo bhwaaye, na abhasubhe bhabhiri, bhiimeereeri haguhi neewe. ");
INSERT INTO zak_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eriibhaga bhabhiri bhayo bhaari bhamutigiri Yeesu, Petero akamubhuurira, “Awe Omukuru weetu, ni kisi etwe kubha hano. Twoomboke hano ebhihuuna bhitatu, ekimwe ekyaazo, ekiindi kya Musa, ne ekiindi kya Eriya.” Gano Petero yagaambiri, ataagamenyiri. ");
INSERT INTO zak_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hano Petero yakugaamba gayo, iguru yaabhu rikatuuka eriisaaro, rikabhakuundikirya. Abhaanabheega bhayo, bhakoobhoha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Rikarweera mwiisaaro eriiraka ikuru, rirabhuga, “Wuno niwe Omwaana waane nimusoriri. Mubhe muramwiitegeerera!” ");
INSERT INTO zak_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na hano eriiraka riyo ryaahwiiri, abhaanabheega bhayo bhakamurora Yeesu yaari omweene. Neebho bhakakira na bhataabhuuriiri muutu wowoosi kuziisiku ziyo goosi gano bharuuzi. ");
INSERT INTO zak_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hano bhwakiiri, Yeesu na abhaanabheega bhayo bhatatu, bhakiituuma kurwa mukiguru, bhakasikana ne esaango ekuru ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na gati wa abhaatu bhayo, yaariho omuutu wumwe akatiirya eriiraka, “Ee Omweegya, ndakusabha, ondorere omumura waane wuno, kwo okubha ewe ni mwaana waane omweene. ");
INSERT INTO zak_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Obhona ahaatiirwa eriisaambwa eriibhi, riramukora ateme ekituri. Kweeki riramukora agwe eriirimu, tee eriihuro riramurwa mumunwa. Rirageenderera kumunyaakya bhukongʼu, na ritakumutiga bhwaangu. ");
INSERT INTO zak_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nibhiisasaamiri abhaanabheega bhaazo kubha bhamuruusye eriisaambwa, nawe bhakatamwa.” ");
INSERT INTO zak_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yeesu akabhuga, “Emwe abhaatu bho orwiibhuro runo, bhano mutana obhwiikirirya, ndiikara neemwe no okubhagumirya, tee ryoori? Nireetera omwaana waazo.” ");
INSERT INTO zak_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hano omwaana wuyo yakuuza, eriisaambwa riyo eriibhi rikamugwiisya haasi, rikamutuurira eriirimu. Kyaamwe, Yeesu akariheebha, akamuhorya omwaana wuyo, akamukyoorerya wiise. ");
INSERT INTO zak_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Abhaatu bhoosi, hano bhaaruuzi obhunagya obhukuru bhwa Taatabhugya, bhakataangaara no okuruguura bhukongʼu. Hano abhaatu bhayo bhaari bhakyaruguura ebhitiika bhya Yeesu, ewe akabhabhuurira abhaanabheega bhaaye, ");
INSERT INTO zak_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mwiitegeerere kisi, amangʼana gano nikubhabhuurira bhoono. Enye Omwaana wo Omuutu, ndatuurwa mumabhoko ga abhaatu.” ");
INSERT INTO zak_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nawe, gano Yeesu akabhabhuurira, abhaanabheega bhaaye, bhataamenyiri, kwo okubha gaari gabhisirwe kweebho, bhataamenyeekereerye obhugazuro bhwaaye. Na bhaari bharoobhoha okumubhuurya iguru ya amangʼana gaaye. ");
INSERT INTO zak_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Abhaanabheega bha Yeesu, bhakataanga kwiibhuurya kubha, ni weewi omukuru kukira abhaandi gati yaabhu. ");
INSERT INTO zak_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kwo okubha Yeesu akagamenya amiiseegi gaabhu, niho akagega omwaana omusuuhu, akamwiimeererya haguhi neewe. ");
INSERT INTO zak_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Akabhabhuurira, “Omuutu wowoosi wuno akumuginihya omwaana kya wuno kwe eriina ryaane, aniginihirye enye. No omuutu wuno ansuungʼaaniri, niwe wuno antumiri. Bhoono, omusuuhu gati weenyu, wuyo niwe omukuru kukira bhoosi.” ");
INSERT INTO zak_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana akamubhuurira, “Awe Omukuru weetu, tukamurora omuutu araruusya amasaambwa amabhi kwe eriina ryaazo. Etwe tukasakya kumurekya, kwe ekigirirye atari wo oweetu.” ");
INSERT INTO zak_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yeesu akabhuga, “Mutamurekya kweeki, kwo okubha omuutu wuno atakubhaanga emwe, ari hamwe neemwe.” ");
INSERT INTO zak_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Eriibhaga rya Yeesu okukyoora mwiisaaro ryaari haguhi, niho akiigoomba kubha agye Yerusaremu, akataanga orugeendo. ");
INSERT INTO zak_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Niho akabhatuma abhaatu bhamukaangatire, neebho bhakagya bhakasikira mumugye gumwe gwa Abhasamaria, okubha bhamubhanurire ahagiro ho okuhiindira ne ebhigiro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nawe, abhaatu bha mumugye guyo bhakaanga kumusuungʼaana, kwo okubha yaaragya Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abhaanabheega bhaaye, Yaakobo na Yohana hano bhaaruuzi gayo, bhakamubhuurya, “Awe Omukuru weetu Yeesu, oreenda tusabhe omuriro gwiike kurwa mwiisaaro gubhasikye, kyeego omurooti Eriya woosi akakora?” ");
INSERT INTO zak_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hano bhaagaambiri gayo, Yeesu akabhiikyoorera, akabharekya, akabhuga, “Mutamenyiri ni koroki yino munayo. ");
INSERT INTO zak_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Enye Omwaana wo Omuutu, nitiiziri okuzisikya eziikoro zya abhaatu, nawe okuzituurya.” Bhakagya mumugye oguundi. ");
INSERT INTO zak_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hano Yeesu na abhaanabheega bhaaye bhaari bharageenda munzira, omuutu owumwe akamubhuurira, “Hohoosi hano oraagye, enye ndakutuniirira.” ");
INSERT INTO zak_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu woosi akamukyoora, “Bhanyamubhwe bhana amabhigi ne ebhinyonyi bhine ebhinyuumba, nawe enye Omwaana wo Omuutu, nitana naabhe ho okuhiindirya omutwe gwaane.” ");
INSERT INTO zak_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yeesu akamubhuurira omuutu owuundi, “Onituniirire.” Omuutu wuyo akamukyoora, “Ee Omukuru, oniikirirye nigye hiinga okumubhiika taata waane.” ");
INSERT INTO zak_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kyaamwe Yeesu akamukyoora, “Tiga bhano bhakuuri mumitima gyaabhu bhabhabhiike abhaku bhaabhu. Nawe awe, noogye obhabhuurire abhaatu engʼana yo obhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yiingabha, omuutu owuundi akamubhuurira Yeesu, “Awe Omukuru Yeesu, ndakutuniirira, nawe, oniikirirye nigeende nibharage abhaatu bha yiika.” ");
INSERT INTO zak_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yeesu akamubhuurira, “Omuutu wowoosi wuno ataangiri okurima kwe eziingʼoombe, araabhe ariikyoora na arasoomya inyuma, wuyo, atakweenderwa kubhubhagati bhwo obhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Niho okumara, Omukuru Yeesu akiitoora abhaanabheega abhaandi miroongo muhuungati na bhabhiri (72). Akabhatuma bhabhiri bhabhiri, bhamukaangatire muziiroobho na mumigye gyoosi, hano yaakweenda ahike omweene. ");
INSERT INTO zak_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akabhabhuurira, “Amagesa ni maaru, nawe abhagesi ni bhasuuhu. Kweego, musabhe Omukuru, Taatabhugya, ewe niwe mweene muguundu, okubha araganie abhagesi abhaandi bhagese mumuguundu gwaaye. ");
INSERT INTO zak_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ambe, mugeende! Ndabhatumania kye eziingʼoondu gatigati ye eziisuuzi! ");
INSERT INTO zak_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mutagega ekiguzi kye eziimbirya, naabhe esakwa, kasi ebhikweera. Na hano muraabhe munzira, mutabhurya eriibhaga kwo okukeerenia na abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Na hano muraasikire munyuumba yoyoosi, mubhakeerye abhaatu bha muyo, mubhuge, ‘Mubhe no omureembe.’ ");
INSERT INTO zak_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na araabhe omuutu wo omureembe ari munyuumba muyo, omureembe guyo mumuheeri guratama munyuumba muyo. Nawe, eraabhe bhatana omuutu wo omureembe, omureembe gweenyu gubhakyoorere. ");
INSERT INTO zak_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mutabha murasaamasaama kwo okuhiindira muziinyuumba eziindi. Kweego, mwiikare munyuumba yiyoyiyo yino musikiirimu, murye no okunywa bhino bhakubhaha, kwo okubha, omuhokya wuyo woosi areenderwa ahaabhwe amariho gaaye. ");
INSERT INTO zak_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Hano muraasikire omugye omurebhe, na abhiikari bhaamu bharaabhasuungʼaane, murye ebhyaakurya bhino bharaabhahe. ");
INSERT INTO zak_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Na mubhahorye abharweeri bhano bhari mumugye guyo. Mubhabhuurire kubha, obhutemi bhwa Taatabhugya bhubhahikiiri. ");
INSERT INTO zak_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Na hano muraasikire mumugye omurebhe, na abhiikari bhataabhasuungʼaaniri, emwe muhite kuziinzira zya mumugye muyo, murabhuga, ");
INSERT INTO zak_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Naabhe oruteeri rwo omugye gweenyu, runo ruri kumaguru geetu, turarukungʼuuta, ebhe obhweerekeereryo kubhaatu bhoosi kubha Taatabhugya abhaangiri. Nawe, mumenye kubha, obhutemi bhwa Taatabhugya bhubhahikiiri!’ ");
INSERT INTO zak_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndabhabhuurira, orusiku rurya Taatabhugya araabhatinire ekiina abhaatu bhe ekyaaro, arabhatema abhaatu bho omugye guno, kukira abhaatu abhabhi bha mumugye gwa Sodoma! ");
INSERT INTO zak_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Muraaza kurora, emwe abhaatu bha Korazini! Muraaza kurora, emwe abhaatu bha Betisaida! Eraabhe ebhitiika bhino niakoriri mumigye gyeenyu hano, niingakoriri mumigye emibhi girya gya Tiro na Sidooni, eheene abhaatu bhe emigye giyo bhiingamariri okuta ebhibhi bhyaabhu. Bhaangeerekirye obhwiisasaami kwo okwiibhoha emyeenda gya amagonera, no okwiihaka ekibhu. ");
INSERT INTO zak_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ndabhabhuurira obhuheene, kurusiku rwo okutina ekiina, Taatabhugya arabhatema emwe bhukongʼu kukira abhaatu bha Tiro na Sidooni. ");
INSERT INTO zak_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Na neemwe, abhaatu bha Kaperinaumu, muriiseega kubha Taatabhugya arabhatiirya tee mwiisaaro? Zeyi! Taatabhugya arabhiituumya tee mumuriro gwa nyaari.” ");
INSERT INTO zak_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kweego, Yeesu akabhabhuurira abhaanabheega bhaaye, “Omuutu wuno arabhiitegeerere emwe, aniitegeereeri enye. No omuutu wuno arabhaange emwe, aniangiri enye. Na wuno akunianga, yaangiri wuno anitumiri.” ");
INSERT INTO zak_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Niho, abhaanabheega bhayo miroongo muhuungati na bhabhiri (72) bhakakyoora, bharazomererwa. Bhakamubhuurira, “Omukuru, naabhe amasaambwa amabhi hano twaari tukugaheebha kuriina ryaazo, gakatwiigwa!” ");
INSERT INTO zak_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yeesu akabhabhuurira, “Nikamurora Seetaani ariituuma kyo orukubha kurwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Emwe mumenye kubha, nibhaheeri obhunagya bhwo okukira eziinguru zyoosi zyo omubhisa weenyu. Muranagya okugeenda gati we enzoka ne ekitoromooni no okuzitaza, na kitariho ekigiro kyokyoosi kino kiraabhanyahaare. ");
INSERT INTO zak_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","“Kweego mutazomererwa, amasaambwa amabhi garabhiigwa. Nawe, muzomererwe kubha, amariina geenyu gakaamirwe mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eriibhaga riyo, Ekoro Muhoreeru akakora Yeesu akazomererwa bhukongʼu. Niho Yeesu akabhuga, “Ee Taata waane, Omukuru wa mwiisaaro ne ekyaaro, ozomirye kwo okubha amangʼana gano obhabhisiri abhaatu bha amangʼeeni na abhasomi, okagakuundukurira abhaatu bhano bhakwiikiriirye kya abhaana. Niigo okaseega Taata waane, ego niigo okaseega.” ");
INSERT INTO zak_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Niho akabhuga, “Taata waane aniheeri obhunagya bhwoosi. Atariho omuutu wuno animenyiri Omwaana wa Taatabhugya kyeego niri, nawe Taata omweene ego. Kweeki, atariho wuno amumenyiri Taata kyeego ari, nawe enye Omwaana waaye omweene ego, no omuutu wowoosi wuno nikweenda kumukuundukurira.” ");
INSERT INTO zak_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Niho Yeesu akabhiikibhukira abhaanabheega bhaaye, akabhabhuurira, “Taatabhugya abhatweereeri ebhite emwe, kwo okubha murarora amangʼana gayo kwa ameeso geenyu! ");
INSERT INTO zak_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndabhabhuurira, bhaari bhariho abharooti na abhatemi bhaaru, bhano bhakiigoomba okurora gano mukurora emwe, nawe bhataagaruuzi. Bhaari bhariigoomba okwiigwa gano mukwiigwa emwe, nawe bhataagiigwiiri.” ");
INSERT INTO zak_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Orusiku rumwe, omweegya we emigiro akiimeerera, akamubhuurya Yeesu eriibhuuryo ryo okumusakya, “Awe Omweegya, nikorebhwi, niize nibhone obhuhoru bhwa kirakeego?” ");
INSERT INTO zak_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yeesu akamubhuurya, “Awe kumigiro ekaamiirwebhwi? No ogimenyiribhwi?” ");
INSERT INTO zak_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akamukyoora, “Ekaamirwe, ‘Omuseege Omukuru, Taatabhugya waazo, kwo omutima gwaazo gwoosi, kwe ekoro yaazo yoosi, kwa amanaga gaazo goosi, na kwa amangʼeeni gaazo goosi.’ Na ‘Omuseege omurikyaazo, kyeego wiiseegiri omweene.’” ");
INSERT INTO zak_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yeesu akamubhuurira, “Eriikyooro ryaazo ni zomu! Kora ego, naawe orabhona obhuhoru.” ");
INSERT INTO zak_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nawe, omweegya we emigiro wuyo, akeenda okweerekya kubha ni we eheene embere wa Taatabhugya, nikyo kikagirya akamubhuurya Yeesu, “No omunyaroobho waane ni weewi?” ");
INSERT INTO zak_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yeesu akamukyoora, “Yaari ariho omuutu wumwe, wuno yaari akurwa Yerusaremu, arahiriingita kugya mumugye gwa Yeriko, na munzira hayo akarwaanibhwa na abhateesya. Bhakamuruusya emyeenda gino yaari yiibhohiri, bhakamutema bhukongʼu, bhakamutiga ari haguhi yo okukwa. ");
INSERT INTO zak_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Kwe eriiruguto, munzira hayo, akaaza omuseengeri owumwe. Nawe omuseengeri wuyo, hano yamuruuzi omuutu wuyo, akahita embarika orubhaara oruundi rwe enzira. ");
INSERT INTO zak_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Niho kweeki Omuraawi woosi akahika, niigo yamuruuzi omuutu wuyo, akahita embarika orubhaara oruundi rwe enzira. ");
INSERT INTO zak_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Kubhuteero, akahita Omusamaria wumwe, wuno ahaabha murugeendo rwaaye. Hano yamuruuzi omuutu wuyo, akamurorera ebhigoongi, ");
INSERT INTO zak_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","akamwiisukaku, akamuragura ebhigaati bhyaaye kwo okubhituuraku amaguta na amaanzi go omuzabibu, akabhibhoha bhwaheene. Hano yamariri akamutiirya kutikiri yaaye, akamuhira munyuumba ya abhagini, akabha aramusakirya muyo. ");
INSERT INTO zak_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Etabhoori yaho, akaruusya mukiguzi eziidinaari ibhiri, akamuha mweene enyuumba, akamubhuurira, ‘Omutuge omuutu wuno, na hano oraahokeerye eziimbirya eziindebhe kwo okumutuga, hano ndaahite, ndakuriha.’ ” ");
INSERT INTO zak_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Niho, Yeesu akamubhuurya omweegya we emigiro wuyo, “Kubhwiiseegi bhwaazo, hano omuutu wuyo yarwaaniibhwe na abhateesya, ni wuuhe gati wa abhaatu bhatatu bhayo, wuno yaari omurikyaazo kwo okumukorera amazomu?” ");
INSERT INTO zak_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Akamukyoora, “Ni wurya akamurorera ebhigoongi.” Yeesu akamubhuurira, “Noogye, obhe orakora egoego.” ");
INSERT INTO zak_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hano Yeesu na abhaanabheega bhaaye bhaari munzira, bhakasikira mumugye gumwe. Na mumugye muyo, yaarimu omukari owumwe, eriina ryaaye ni Marita, akabhaginihya mumugye gwaaye. ");
INSERT INTO zak_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marita wuyo, yaari na musubhaati waaye, wuno yakubhirikirwa Mariamu. Eriibhaga riyo, Mariamu akiikara haguhi na amaguru go Omukuru Yeesu, aramwiitegeerera. ");
INSERT INTO zak_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nawe Marita, akabha aranyaaka okubhahokeerya ebhyaakurya, niho akagya ku Yeesu, akamubhuurira, “Omukuru weetu, otakurora kubha musubhaati waane antigiiri emirimo gyoosi? Ambe, omubhuurire yiize anisakirye!” ");
INSERT INTO zak_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kyaamwe Omukuru Yeesu akamukyoora, “Marita, Marita. Ono obhwiitiimaati iguru ya amangʼana maaru. ");
INSERT INTO zak_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nawe, eriho engʼana yimwe yo obhweera, kweeki ni nzomu kukira goosi. Mariamu niwe yiitooriri, na atariho wuno araamuruusye.” ");
INSERT INTO zak_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Orusiku rumwe, Yeesu ahaabha ahagiro aharebhe aramusabha Taatabhugya. Na hano yamariri, owumwe wa abhaanabheega bhaaye akamubhuurira, “Ee Omukuru, otweegye okumusabha Taatabhugya, kyeego Yohana Omubatiizi akeegya abhaanabheega bhaaye.” ");
INSERT INTO zak_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yeesu akabhabhuurira, “Hano mukubha muramusabha Taatabhugya, mugaambe ego, ‘Taata weetu wa mwiisaaro, eriina ryaazo riguungibhwe. Obhutemi bhwaazo bhuuze, obhuseegi bhwaazo bhukorwe mukyaaro hano, na kyeego bhukukorwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Otuhe eziisiku zyoosi ebhyaakurya bhyeetu. ");
INSERT INTO zak_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","No otwaabhire ebhibhi bhyeetu, kwo okubha etwe twoosi turabhaabhira bhano bhakutusariirya. Oturiihe mubhitiika, nawe otutuurye no omubhi wurya.’ ” ");
INSERT INTO zak_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Niho Yeesu akabhabhuurira, “Tubhuge owumwe weenyu yaangagiiri kumusaani waaye, mubhutiku gati, akamubhuurira, ‘Musaani waane! Ndasabha emikaate etatu, ");
INSERT INTO zak_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwo okubha nitaariirwe no omusaani waane wuno yaari murugeendo, na neenye nitana ebhyaakurya bhyo okumuha.’ ");
INSERT INTO zak_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","No omusaani waaye akamukyoora, ‘Otaninyaakya! Ndora nimariri kwiigara ekiseku, enye na abhaana bhaane tuhiindiiri, na nitakunagya kubhuuka no okukuha ekigiro kyokyoosi.’ ");
INSERT INTO zak_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Ndabhabhuurira, naabhe omuutu wuyo atakweenda okumuha omurikyaaye emikaate kwo okubha ewe ni omusaani waaye, arabhuuka no okumuha ekigiro kino akweenda, kwo okubha omurikyaaye akeenderera kumusabha kwo okwiiririirirya. ");
INSERT INTO zak_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kweego, enye ndabhabhuurira, mumusabhe Taatabhugya, neewe arabhaha kino mukusabha. Mukomye okurwa ku Taatabhugya, neewe arabhaha kino mukukomya. Mubhuge hanoo, niho Taatabhugya arabhiigurira ekiseku. ");
INSERT INTO zak_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Omuutu wowoosi wuno akusabha, arahaabhwa wuno akukomya, arabhona, na wuno akubhuga hanoo, ariigurirwa. ");
INSERT INTO zak_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Awe! Ariho omwiibhuri wowoosi gati weenyu, wuno eraabhe omwaana waaye araamusabhe omukaate, aramuha eriigina, kasi omwaana waaye araamusabhe eswe, aramuha enzoka? ");
INSERT INTO zak_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kasi omwaana araamusabhe eriige, aramuha ekitoromooni? ");
INSERT INTO zak_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bhoono, yiingabha emwe mbabhi, nawe mumenyiri okubhaha abhaana bheenyu ebhigiro ebhizomu. Ambe! Wuuso weenyu wa mwiisaaro atakutura okubhaha Ekoro Muhoreeru bhano bhakumusabha? Niigo eraabhe, kumuutu wuno araasabhe Ekoro Muhoreeru, arahaabhwa!” ");
INSERT INTO zak_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Orusiku rumwe, Yeesu yaari araheebha eriisaambwa eriibhi, kumuutu wumwe rino ryamukoriri omuutu wuyo kubha imuumu. Hano eriisaambwa ryaamurwiiriku, akataanga okugaamba kweeki. Yaari eriho esaango ya abhaatu, neebho hano bharuuzi gayo, bhakaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nawe, abhaandi bhakabhuga, “Araheebha amasaambwa amabhi kwo obhuturo bhwa Beerizeburi, omukaangati wa amasaambwa!” ");
INSERT INTO zak_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abhaandi bhakeenda bhamusakye Yeesu, kwo okumusingʼirirya akore ekyeerekenio okurwa mwiisaaro kino kikweerekya kubha arwiiri ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nawe, kwo okubha Yeesu akamenya amiiseegi gaabhu, akabhabhuurira, “Eraabhe abhaatu bho obhutemi bhumwe bhariitana, obhutemi bhuyo bhuragwa. Kweeki abhaatu bhe enyuumba yimwe bhariitane, bhatakubha no obhumwe. ");
INSERT INTO zak_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kweego eraabhe Seetaani ariihakanie omweene, obhutemi bhwaaye bhuriimeererabhwi? Nibhabhuurirye eriibhuuryo riyo, kwo okubha murabhuga ndaheebha amasaambwa kwo obhunagya bhwa Beerizeburi. ");
INSERT INTO zak_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eraabhe enye ndaheebha amasaambwa amabhi kwo obhunagya bhwa Beerizeburi, ambe abhaanabheega bheenyu bharaheebha amasaambwa kwo obhunagya bhwa weewi? Kwe ekigirirye kiyo abhaanabheega bheenyu bhareerekya kubha mutari bhwaheene. ");
INSERT INTO zak_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nawe eraabhe enye ndaheebha amasaambwa amabhi kwo obhunagya bhwa Taatabhugya, ambe, obhutemi bhwa Taatabhugya bhuhikiri kweemwe. ");
INSERT INTO zak_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Omuutu wa amanaga kya ga Seetaani, araabhe ne ebhigwaato, hano akuriibha ebhigiro bhya mumugye gwaaye, ebhigiro bhiyo bhitakukunwaku. ");
INSERT INTO zak_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nawe, omuutu owuundi wa amanaga amaaru, araaza kumurwaania, na aramuhiza, aramuruusya ebhigwaato bhyaaye bhino yakwiisigira, na bhyoosi bhino bhiri mumugye, no okubhitwaania kubhaandi. ");
INSERT INTO zak_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Omuutu wowoosi wuno atari hamwe neenye, ewe niwe omubhisa waane. Kweeki wowoosi wuno atakukumania abhaatu hamwe neenye, kwe eheene arabhanyaragania. ");
INSERT INTO zak_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Emwe, mwiitegeerere ekireengyo kino. Hano eriisaambwa eriibhi rikurwa kumuutu, rirageendageenda mwiitirigo okukomya ahagiro ho okumuunya, na rirabhurwa. Nawe hano ribhurirwe okuhabhona, eriisaambwa riyo rirabhuga, ‘Ndakyoora kumuutu waane wuno nimurwiiriku.’ ");
INSERT INTO zak_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hano ryamukyooririku rikabhona ari geeki kye enyuumba yino etarikiibhwe ne ebhanwiirwe bhuzomu. ");
INSERT INTO zak_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kyaamwe riragya kuraarika, amasaambwa agaandi muhuungati amabhiihu kukira eryo eryeene. Goosi garasikira kumuutu wuyo, no okumwiikaramu. Niho obhwiikari bhwo omuutu wuyo bhukubhiiha kukira kubhweemero harya.” ");
INSERT INTO zak_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hano Yeesu yaari akugaamba gayo, musaango ya abhaatu murya yaari arimu omukari wumwe, akamwaaya kwiiraka ikuru arabhuga, “Hakiriku omukari wuno akwiibhwiiri no okukukookya!” ");
INSERT INTO zak_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nawe Yeesu akabhuga, “Tiigo! Ni hakiriku bharya bhakwiigwa engʼana ya Taatabhugya no okwiitegeerera.” ");
INSERT INTO zak_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hano abhaatu bhaaruhiri no okumwiikumanira, Yeesu akabha areenderera kweegya, arabhuga, “Ebho ni rwiibhuro rwa abhaatu abhabhi bhatari abhaheene embere wa Taatabhugya, na bhoono bhareenda ekyeerekenio? Nitakubheerekya ekyeerekenio kyokyoosi. Nawe ekyeerekenio kimwe kino bharaarore ni kya kirya Taatabhugya yakoriri kumurooti Yoona. ");
INSERT INTO zak_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kwo okubha, kyeego Yoona yaari ekyeerekenio kubhaatu bho omugye gwa Ninaawi, ego niigo enye Omwaana wo Omuutu, ndabha ekyeerekenio kubhaatu bho orwiibhuro runo. ");
INSERT INTO zak_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Kweeki kurusiku rwo okutina ekiina rurya, nyakisaho we ekyaaro kya Sheeba ariimeerera embere wa Taatabhugya no okubhatinira ekiina abhaatu bho orwiibhuro runo, kwo okubha muratemya ebhibhi. Ewe akarwa mukyaaro kya kure okubha yiize yiitegeerere amangʼana ga amangʼeeni go omutemi Soromooni. Bhoono ariho owumwe hano wuno niwe omukuru kukira Soromooni, nawe mutakumwiitegeerera. ");
INSERT INTO zak_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Kurusiku rwo okutina ekiina, abhaatu bha mumugye gwa Ninaawi bhariimeerera embere wa Taatabhugya hamwe no orwiibhuro runo no okubhatinira ekiina, kubha emwe ni bhaatu bhe ebhibhi. Abhaatu bhayo bha Ninaawi bhakata ebhibhi bhyaabhu, hano bhakiigwa Yoona ararwaaza amangʼana okurwa ku Taatabhugya. Bhoono ariho owumwe hano, wuno niwe omukuru kukira Yoona, nawe mutakumwiitegeerera. ");
INSERT INTO zak_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Atariho omuutu wuno araakye etara, okumara ayikuundikirye. Nawe arayituura iguru mukikuumbo, okubha abhaatu bharaasikire munyuumba, bharore obhweero. ");
INSERT INTO zak_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Ameeso nigo etara yo omubhiri. Eraabhe ameeso gaazo gararora, bhuzomu, omubhiri gwaazo gwoosi gurabha no obhweero. Nawe, ameeso gaazo garaabhe masariku, omubhiri gwaazo gurabha gwiizwiiri ekiirima. ");
INSERT INTO zak_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kweego, obhe meeso, okubha obhweero bhuno bhuri muusi waazo, bhutabha kiirima! ");
INSERT INTO zak_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eraabhe omubhiri gwaazo gwoosi guno obhweero, ambe otakubha ne ekiirima kyokyoosi, oramesya kye etara yino ekumurika.” ");
INSERT INTO zak_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Hano yamariri kugaamba gayo, Omufarisayo owumwe akamuginihya Yeesu kubhyaakurya mumugye gwaaye. Yeesu akasikira, akiikara kwiigari. ");
INSERT INTO zak_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Omufarisayo wuyo, akamurora Yeesu akyaari kwiisaabha kyeego emigiro gyaari kweenda, akataanga kurya, akaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Niho Omukuru Yeesu akabhabhuurira, “Emwe Abhafarisayo, muroogya ekikoombe ne ekitubha kwiigutu. Nawe muusi weenyu, eziikoro ziizwiiri obhuteesya no obhubhi. ");
INSERT INTO zak_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Emwe abhatuumbaahu! Wurya akateema kwiigutu, atari niwe akateema na muusi? ");
INSERT INTO zak_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mubhasakirye abhataka kwe ebhigiro ne eziikoro zyeenyu zyoosi, niho bhyoosi bhikubha bhyeeribhwe kweemwe. ");
INSERT INTO zak_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Muraaza kurora, emwe Abhafarisayo! Muramuruusirya Taatabhugya eyimwe yi ikumi ye ebhigiro bhyo obhuguri bhusuuhu bhukongʼu, kyeego eziimbibho zye emiingu, ebhituunguru, ne ebhiindi bhyaaru, ndora mutakwiisiga obhuheene kubhaatu, mutana obhuseegi ku Taatabhugya! Mureenderwa okumuruusirya ekimweeso kiyo, nawe muteebha okukora na agaandi gayo. ");
INSERT INTO zak_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Muraaza kurora, emwe Abhafarisayo! Museegiri okwiikara ebhituumbi bhya abhagini munyuumba ye esaango, museegiri kukeeribhwa kwo obhusuuku mumiteera. ");
INSERT INTO zak_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Muraaza kurora! Emwe ni kye eziimbiihira zino zitakurorekana, eno abhaatu bharazitaza kwo okutamenya.” ");
INSERT INTO zak_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hayohayo, omweegya owumwe we emigiro akabhuga, “Omweegya, kumangʼana gayo okugaamba na neetwe oratutuka.” ");
INSERT INTO zak_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yeesu akamukyoora, “Na neemwe abheegya bhe emigiro, muraaza kurora! Murabhagegya abhaatu amangʼana amarito ge emigiro. Na neemwe abheene, mutakubhasakirya naabhe hasuuhu okugagega! ");
INSERT INTO zak_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Muraaza kurora! Muroomboka eziimbiihira bhuzomu zya abharooti, nawe abhaatu bhano bhaabhiitiri abharooti bhayo, ni bhazaazi bheenyu! ");
INSERT INTO zak_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kweego, muramenyeekererya kubha mwiikiriirye gano bhazaazi bheenyu bhaakoriri, kwo okubha nibho bhakiita abharooti bhayo, neemwe mutakusuuka, muroomboka ego eziimbiihira zyaabhu. ");
INSERT INTO zak_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nikyo kyakoriri Taatabhugya akabhuga, kumangʼeeni gaaye, ‘Ndabhatumira abharooti na abheega. Nawe, bharabhiita abhamwe no okubhanyaakya abhaandi.’ ");
INSERT INTO zak_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kweego, abhaatu bho orwiibhuro runo bharabhuuribhwa kwiiguru ya amanyiinga ga abharooti bhoosi bhano bhakiitwa, kurwa obhweemero bhwe ekyaaro. ");
INSERT INTO zak_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Amanyiinga gakiitika kweemera ku Abeeri, tee amanyiinga ga Zakaria, wurya akiitirwa mwiiseengerero, gatigati wa Ahahoreeru na ahagiro ho okuruusirya ekimweeso. Eheene, ndabhabhuurira kubha abhaatu bho orwiibhuro runo bharabhuuribhwa iguru ya gayo goosi. ");
INSERT INTO zak_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Muraaza kurora, emwe abheegya bhe emigiro! Mwiigeeri ekiseku kyo okuhitira, kino abhaatu bhaari bhareenda okuhitiramu okubha bhamumenye Taatabhugya. Neemwe abheene, mutasikiiri, na bharya bhaari kweenda kusikira muusi, mubharibhiiri.” ");
INSERT INTO zak_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hano Yeesu yarwiiri hayo, Abhafarisayo na abheegya bhe emigiro bhakataanga kumuhakania kwo obhuhaari, no okumubhuurya amabhuuryo maaru, ");
INSERT INTO zak_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","okubha bhabhone enzira yo okumugwaata kwa amangʼana gaaye. ");
INSERT INTO zak_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Eriibhaga riyo, ebhikwe kwe ebhikwe bhya abhaatu bhaari bhariikumania, tee bhakiitaza. Yeesu akataanga kubhabhuurira abhaanabheega bhaaye, “Mwiiriihe ne ekibhwiisya kya Abhafarisayo, kwo okubha orurimi ruyo, ruranyaragana kye ekibhwiisya. ");
INSERT INTO zak_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kyokyoosi kino kikuundikirwe, kirakuundukurwa neemwe, kweeki kyokyoosi kino kibhisirwe, kirarorekana. ");
INSERT INTO zak_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Amangʼana gano mugaambiri mukiirima, gariigweerwa mubhweero. Na amangʼana gano mwiimoonyereerye mumatwi mubhyuumba bhya muusi, mugarwaaze kubhweero okubha bhoosi bhiigwe. ");
INSERT INTO zak_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Emwe abhasaani bhaane, ndabhabhuurira mutoobhoha abhaatu bhano bhakwiita omubhiri. Hano bharaamare kwiita, bhatakunagya kukora kyokyoosi. ");
INSERT INTO zak_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nawe, ndabhabhuurira wuno mukweenderwa kumwoobhoha, mumwoobhohe Taatabhugya! Hano akumara okumwiita omuutu, ano obhuturo bhwo okumutaasa mumuriro gwa nyaari. Wuyo mureenderwa mumwoobhohe, ewe omweene! ");
INSERT INTO zak_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Mumenyiri kubha ebhitorookobhwe bhitaano, bhiraguribhwa kwo obhuguri bhusuuhu bhukongʼu? Nawe, Taatabhugya atakukyeebha naabhe ekimwe kyaabhu. ");
INSERT INTO zak_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Taatabhugya amenyiri obhubhari bhwe eziinzweeri zyoosi zye emitwe gyeenyu. Kweego, mutoobhoha, kwo okubha emwe muno obhuguri bhukuru kukira ebhitorookobhwe bhyaaru. ");
INSERT INTO zak_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Enye ndabhabhuurira, omuutu wowoosi wuno akugaamba embere wa abhaatu kubha aniikiriirye enye, enye Omwaana wo Omuutu woosi ndamwiikirirya embere wa bhamaraika bha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nawe, akunianga embere ya abhaatu, na neenye ndamwaanga embere ya bhamaraika bha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Taatabhugya aranagya okwaabhira abhaatu bhano bhakugaamba bhubhi iguru waane enye Omwaana wo Omuutu. Nawe, atakunagya okumwaabhira omuutu wuno akumutuka Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Hano muraahirwe munyuumba ye esaango okutinirwa ekiina, ne embere ya abhakaangati, ne embere ya abhaanaangwa, mutiitiimaata. Mutabha ne ehaha iguru ya amangʼana gano muraagaambe kwo okwiibhagiirira, ");
INSERT INTO zak_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kwo okubha eriibhaga riyoriyo, Ekoro Muhoreeru araabheegye amangʼana gano mukweenderwa okugagaamba.” ");
INSERT INTO zak_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Musaango yiyo ya abhaatu, omuutu owumwe akamubhuurira Yeesu, “Omweegya, omubhuurire mura weetu, anitwaanire engabho yino taata akatutigira.” ");
INSERT INTO zak_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yeesu akamukyoora, “Weewi akaanituura nibhe omutaania gati weenyu?” ");
INSERT INTO zak_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kweego Yeesu akabhabhuurira abhaatu bhayo, “Mwiiriihe ne enaamba ye ebhigiro, kwo okubha, obhuhoru bhwo omuutu, bhutakurweera kubhwaaru bhwe ebhigiro bhyaaye.” ");
INSERT INTO zak_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kweeki Yeesu akabhabhuurira ekireengyo, akabhuga, “Yaari ariho omuniibhi wumwe, no omuguundu gwaaye gukiibhura amagesa maaru bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akiibhuurya mukoro yaaye, ‘Bhoono nikorebhwi? Amagesa gano goosi ni gaane, nitana ahagiro hano ndaagatuure!’ ");
INSERT INTO zak_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Kweego akabhuga, ‘Ndakora ego. Ndaasya ebhitara bhyaane no okuruka ebhikuru bhukongʼu. Muyo ndatuuramu amagesa gaane goosi, ne ebhigiro bhyaane ebhiindi. ");
INSERT INTO zak_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kweeki ndiigaambira mukoro yaane, “Bhoono wiituuriiri ekibhuumbiko kye ebhigiro bhyaaru bhuzomu. Bhirakwiisa kumyaaka myaaru! Kimwe, muunya, orye na onywe, ozomererwe!” ’ ");
INSERT INTO zak_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Nawe, Taatabhugya akamubhuurira, ‘Awe ni mugeege! Obhutiku bhwa reero, orakwa! Na ebhigiro bhyoosi bhino wiibhuumbiiri, bhirabha bhyawi?’ ” ");
INSERT INTO zak_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu akamara kwo okugaamba, “Niigo eraabhe, kumuutu wurya akwiibhuumbira ebhigiro bhye ebhibhi kwe ekigirirye kyaaye omweene, nawe kumahokya ge ebhigiro bhyaaye, atakumwiisiga Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ambe, Yeesu akabhabhuurira abhaanabheega bhaaye, “Mutabha no obhwiitiimaati iguru yo obhwiikari bhweenyu, etari iguru okuryaki kasi munyweki kasi mwiibhoheki. ");
INSERT INTO zak_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndora obhwiikari bhuna bhweera kukira ebhyaakurya, no omubhiri nagwe, guno obhweera bhukongʼu kukira emyeenda. ");
INSERT INTO zak_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Mwiiseege ekireengyo kya bhanyamuko, bhatakweemya naabhe bhatakugesa, bhatana ekibhuumbiko naabhe ebhitara, nawe Taatabhugya arabhariisya. Na neemwe muno obhweera bhukongʼu kukira ebhinyonyi! ");
INSERT INTO zak_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni weewi gatigati weenyu wuno akunagya kwiiyoongerya naabhe esa yimwe mubhwiikari bhwaaye kwo obhwiitiimaati? ");
INSERT INTO zak_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ambe! Mutakunagya kukora engʼana esuuhu kya yiyo, kwaki mutakwiitiimaata iguru wa agaandi? ");
INSERT INTO zak_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Murore ebhibharyo kyeego bhikubharya, bhitakukora emirimo na bhitakutuma emyeenda. Nawe ndabhabhuurira kubha, naabhe omutemi Soromooni mubhwaame bhwaaye bhwoosi, atiibhohiri bhuzomu kye ebhibharyo bhiyo! ");
INSERT INTO zak_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kweego, niigo Taatabhugya arabhiibhohya kisi kye ebhibharyo bhya mwiitirigo, bhino bhiriho reero nawe tabhoori bhirarekerwa mumuriro, ni heene arabhiibhohya emwe, abhaatu bho obhwiikirirya bhusuuhu! ");
INSERT INTO zak_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kweego, mutiinyaakya muraryaki, kasi muranywaki, mutabha ne ehaha. ");
INSERT INTO zak_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Amangʼana gayo goosi, abhaatu bhano bhatamumenyiri Taatabhugya bhariinyaakya nago. Wuuso weenyu wa mwiisaaro amenyiri kisi kubha mureenda gayo goosi. ");
INSERT INTO zak_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nawe, mukore go obhutemi bhwa Taatabhugya, na arabhoongereererya ebhigiro bhiyo. ");
INSERT INTO zak_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Emwe eriihizo isuuhu, mutoobhoha, kwo okubha wuuso weenyu aseegiri kubhaha obhutemi bhwaaye. ");
INSERT INTO zak_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mugurye ebhigiro bhyeenyu, na mubhahe abhataka eziimbirya. Kwo okukora ego murabha mwiituuriiri eziihata zyeenyu mwiisaaro, hano bhitakusarika. Eyo, atariyo mwiibhi, naabhe eziisere zyo okubhisarya. ");
INSERT INTO zak_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ahagiro hano mukubhiika eziihata zyeenyu, hayo niho ne eziikoro zyeenyu zikubha. ");
INSERT INTO zak_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Eriibhaga ryoosi, obhutiku no omwiisi, mubhe mwiibhanwiiri okumukorera Omukuru emirimo. ");
INSERT INTO zak_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mubhe kya abhahokya bhano bhakuganya omukuru waabhu akyoore kurwa mubhweenga. Hano araaze no okubhuga hanoo, na bhamwiigurire ekiseku rugeendo rumwe. ");
INSERT INTO zak_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Hakiriku ya abhagya bhano omukuru waabhu araabhabhone bharamuganya hano akuuza, bharabhona orubhaango. Ndabhabhuurira obhuheene, ariibhanura, arabhiikarya mwiigari, no okubhahokeerya! ");
INSERT INTO zak_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hano omukuru araakyoore mubhutiku gati, ebhe etabhoori zuri, na akubhabhona bhamariri kwiibhanura, abhahokya bhayo bharabhona orubhaango. ");
INSERT INTO zak_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nawe mumenye kisi kubha, kyeego mweene nyuumba yiingamenyiri eriibhaga rino omwiibhi akuuza, yaari ariibhanura, no omwiibhi atakusikira mumugye gwaaye yiibhe. ");
INSERT INTO zak_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Niigo ego, na neemwe mwiibhanure eriibhaga ryoosi, kwo okubha enye Omwaana wo Omuutu ndaaza kwiibhaga rino mutakwiisiga.” ");
INSERT INTO zak_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Niho, Petero akamubhuurya Yeesu, “Ee Omukuru, ekireengyo kino otubhuuriiri, ni kweetwe abheene, kasi ni kwa abhaatu bhoosi?” ");
INSERT INTO zak_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yeesu akamukyoora, “Ni weewi omuhokya omwiikirirya na wa amangʼeeni? Ni mubhagati wuno omukuru waaye amutuuriri abhe omwiimeerereri wa abhabhagati abhaandi munyuumba yaaye, okubha abhe arabhaha ebhyaakurya kwe eriibhaga rino rikweenderwa. ");
INSERT INTO zak_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Omukuru waabhu araakyoore kurwa orugeendo, no okumubhona omugya wuyo arakora ego, niho araabhone orubhaango. ");
INSERT INTO zak_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ndabhabhuurira obhuheene, omukuru waaye aramukora abhe omwiimeerereri we ebhigiro bhyaaye bhyoosi. ");
INSERT INTO zak_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Nawe eraabhe omugya wuyo ni mubhiihu, akwiiseega mukoro yaaye, ‘Omukuru waane akezeeri bhukongʼu kukyoora,’ niho yataangiri kubhatema abhabhagati abharikyaaye, abhasubhe na abhakari, akarya no okunywa, tee akagwaatwa. ");
INSERT INTO zak_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Niho, omukuru waaye araakyoore kurwa orugeendo, araaza orusiku runo omugya atakumwiiseegera eriibhaga rino atamenyiri. Niho omukuru waaye aramutema bhukongʼu, no okumutuura hamwe na bhano bhatari abhiikirirya. ");
INSERT INTO zak_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Omugya wuno amenyiri obhuseegi bhwo omukuru waaye, nawe atiibhanwiiri kwo okugakora kyeego akweenderwa, aratemwa bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nawe, omuhokya wuno atamenyiri obhuseegi bhwo omukuru, araakore eriingʼana rino rikweenderwa aratemwa, ewe aratemwa hasuuhu. Omuutu wuno aheerwe bhyaaru, aratunibhwa bhyaaru, no omuutu wuno aheerwe bhyaaru bhukongʼu, aratunibhwa bhyaaru bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Enye niiziri mukyaaro hano okuheemba omuriro. Na niingaseegiri nirore omuriro guyo gwaakiri! ");
INSERT INTO zak_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nawe enye omweene, nireenderwa nihitire engʼaanga yino tee oruku. Nine enyaako ekuru yino niisuungʼaaniri tee niikuunaanie. ");
INSERT INTO zak_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Awee, muriiseega kubha niiziri mukyaaro okureeta omureembe? Zeyi! Ndabhabhuurira, niiziri okwaahura abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Okutaanga bhoono, munyuumba ya abhaatu bhataano, bhatatu bhariiyaahura kubhabhiri. Bhabhiri nabho, bhariiyaahura kubhatatu. ");
INSERT INTO zak_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wiise arataamania no omwaana waaye, no omwaana woosi, arataamania na wiise waabhu. Nina arataamania no omuukya waaye, no omuukya woosi arataamania na nina waabhu. Inyibhyaara ariiyaahura no omukamwaana waaye, no omukamwaana woosi, arataamania ni inyibhyaara.” ");
INSERT INTO zak_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Okumara Yeesu akabhuurira eziisaango zya abhaatu, “Hano mukurora amasaaro gararweera nyaanza, niho muraabhuge, ‘Embura eri haguhi kutweeka,’ na heene niigo eraabhe. ");
INSERT INTO zak_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na hano mukurora obhukama bhurarweera maamu, murabhuga, ‘Harabha no orwooya,’ na niigo ekubha. ");
INSERT INTO zak_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Emwe bhabheehi! Ni kwaki mumenyiri bhuzomu eriibhaga ryo omwaaka, nawe mutakunagya okumenyeekererya obhugazuro bhwa amangʼana gano gakukorwa eziisiku zino? ");
INSERT INTO zak_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Na kwaki, emwe abheene mutakutina ebhiina okukora gano gakweenderwa? ");
INSERT INTO zak_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Hano omuzoongeri waazo akukuhira mukiina, kora omukya okwiigwaana neewe mukyaari munzira. Okore ego, ataaza kukuhikya embere yo omutini we ekiina, wuno araakuhire kumusirikare, okubha akusikirye munyuumba ya abhabhohwa kwa nguru. ");
INSERT INTO zak_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ndakubhuurira obhuheene, otakurwamu tee hano oraamare okuriha esiiri yoosi!” ");
INSERT INTO zak_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kwiibhaga riyo, abhaatu abhaandi bhakamubhuurira Yeesu kubha, Pirato akaswaagya abhasirikare bhiite Abhagariraaya abhaandi, hano bhaari bhararuusya emitugo gyaabhu gigwagwe kwiiguru yo okuruusibhwa ebhimweeso ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yeesu akabhabhuurira, “Awe! Muriiseega kubha Abhagariraaya bhayo, bhaari ne ebhibhi kukira Abhagariraaya abhaandi bhoosi, kwo okubha bhakakwa oruku ruyo? ");
INSERT INTO zak_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ndabhabhuurira kubha, tiigo! Muraatame kuta ebhibhi bhyeenyu, murasika mwoosi. ");
INSERT INTO zak_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kasi, bharya abhaatu ikumi na bhanaane, bhano bhaagweereerwe ne etimu ekuru ye eyo Siroamu, muriiseega kubha ebho nibho abhabhi kukira abhiikari abhaandi bhoosi bha Yerusaremu? ");
INSERT INTO zak_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ndabhabhuurira kubha, tiigo! Muraatame kuta ebhibhi bhyeenyu, murasika mwoosi.” ");
INSERT INTO zak_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kyaamwe, Yeesu akabhabhuurira abhaatu ekireengyo kino, akabhuga, “Yaari ariho omuutu wumwe, wuno akeemya omutiini mumuguundu gwaaye. Hano eriibhaga ryahitiri, akagya kukomyaku emisumo, nawe atabhweeniku kyokyoosi. ");
INSERT INTO zak_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kyaamwe, akamubhuurira omuhokya wa mumuguundu, ‘Rora! Kumyaaka etatu niari ndaaza kukomya emisumo kumuti guno, nawe ntaakabhweeniku ekigiro. Bhoono, awe gutine, gutige okusarya esi!’ ");
INSERT INTO zak_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Nawe, omuhokya wuyo akamubhuurira, ‘Omukuru, ogutige omwaaka gumwe ogweene, nigurimire no okugutuurira oruse. ");
INSERT INTO zak_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Neegwe guriibhura emisumo, ni bhwaheene! Nawe guraatame okwiibhura, ogutine.’ ” ");
INSERT INTO zak_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Orusiku rumwe rwo okumuunya, Yeesu ahaabha munyuumba yimwe ye esaango, areegya abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Gati ya abhaatu bhayo, yaarimu omukari wumwe, na yaari atiirirwe eriisaambwa kumyaaka ikumi ne enaane. Ne eriisaambwa riyo, rikamukuumba omugoongo, na ataanagirye kugororoka bhweema. ");
INSERT INTO zak_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hano Yeesu yamuruuzi, akamubhirikira, akamubhuurira, “Maayi, obhurweeri bhwaazo bhuhoriibhwe, na obheeri bhwaheene bhoono!” ");
INSERT INTO zak_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yeesu akamutuurira amabhoko, rugeendo rumwe, omukari wuyo akagororoka bhweema, akataanga okumukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kyaamwe omukaangati we enyuumba ye esaango akatiinda, kwo okubha Yeesu akahorya omuutu orusiku rwo okumuunya. Kweego, akabhabhuurira abhaatu, “Kubhutuuro, eziisiku zo okukora emirimo ni isaasabha. Kuziisiku ziyo muuze muhoribhwe, nawe mutaaza kuhoribhwa orusiku rwo okumuunya!” ");
INSERT INTO zak_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nawe Omukuru Yeesu akamukyoora, “Emwe ni bhabheehi! Ndora, emwe mwoosi murakora emirimo eziisiku zyo okumuunya! Emwe mwoosi, amutakusyookorera eziingʼoombe ne eziitikiri zaaye kurwa mwiibhaanza, no okuzihira kunyweesya orusiku rwo okumuunya? ");
INSERT INTO zak_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ndora omukari wuno we ekisyooko kya Aburahamu, amariri emyaaka ikumi ne enaane abhohirwe na Seetaani. Ewe neewe, etakweenderwa yiigurirwe orusiku rwo okumuunya?” ");
INSERT INTO zak_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hano Yeesu yagaambiri gayo, abhahakani bhaaye bhoosi, bhakarora eziisoni. Nawe abhaandi bhoosi, bhakazomererwa bhukongʼu iguru ya amahokya amazomu gano Yeesu ahaabha aragakora. ");
INSERT INTO zak_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kyaamwe Yeesu akabhuurya, “Obhutemi bhwa Taatabhugya bhuribhwi? Na nibhutuubhanie naki? ");
INSERT INTO zak_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hamwe nibhutuubhanie ne etetere ye eharadaari, yino omuutu akeemya mumuguundu gwaaye. Ekamera, ekakura gukabha omuti mukuru, ne ebhinyonyi bhikaaza no okwiikara mumasagya gaaku.” ");
INSERT INTO zak_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu akabhuurya kweeki, “Ndabhutuubhania obhutemi bhwa Taatabhugya naki? ");
INSERT INTO zak_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bhutuubheeni ne ekibhwiisya kino omukari yagegiri no okusaangya mubhisehi bhitatu bhyo obhutu bhwe engano, tee obhutu bhwoosi bhukasita.” ");
INSERT INTO zak_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yeesu no orugeendo rwaaye okugya Yerusaremu. Na hano yaari munzira, ahaahita mumigye emikuru ne emisuuhu areegya abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Orusiku rumwe, omuutu akamubhuurya, “Awe! Omukuru Yeesu, abhaatu bhano bharaatuuribhwe ni bhasuuhwiigo?” Yeesu akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ekiseku kya mwiisaaro ni kiguti. Ndabhabhuurira, mwiikongʼeererye okubha musikire, kwo okubha bhaaru bharasakya okusikira, nawe bhatakunagya. ");
INSERT INTO zak_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eriibhaga mweene enyuumba akwiigara ekiseku, emwe mwoosi muratamwa okusikira. Muriimeerera habhoori no okutaanga kutema ekiseku, eno murabhuga, ‘Hanoo!’ Na muramusabha, ‘Omukuru, otwiigurire!’ “Nawe arabhakyoora, ‘Nitabhamenyiri emwe naabhe eno murweereeri!’ ");
INSERT INTO zak_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Neemwe muramubhuurira, ‘Ndora tukarya no okunywa hamwe naawe, kweeki okatweegya muziiroobho zeetu!’ ");
INSERT INTO zak_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Kweeki arabhabhuurira, ‘Nitabhamenyiri emwe, ne eno murweereeri! Emwe mwoosi ni bhaatu bhe ebhibhi, murwe owaane hano.’ ");
INSERT INTO zak_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Niho muraarire no okusaanania ameeno, kwo okubha muramurora Aburahamu, Isaaka na Yaakobo, na abharooti bhoosi bhari mubhutemi bhwa Taatabhugya, nawe emwe murabha mutaasirwe habhoori! ");
INSERT INTO zak_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Abhaatu bhararwa mumbaara zyoosi zye ekyaaro, bharaaza kurya ebhyaakurya munyaangi, mubhutemi bhwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Mwiitegeerere! Abhaatu bhano bhoono ni bho obhuteero, bharabha bho okutaanga, na bhano ni bho okutaanga bhoono, bharabha bho obhuteero.” ");
INSERT INTO zak_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eriibhaga riyoriyo, Abhafarisayo abharebhe bhakamugyaku no okumubhuurira Yeesu, “Orwe hano, ogye ahagiro ahaandi, kwo okubha Herode areenda kukwiita.” ");
INSERT INTO zak_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yeesu akabhakyoora, “Herode ewe ni kya nyamubhwe! Mugeende mumubhuurire, ‘Rora! Reero na tabhoori, ndaruusya amasaambwa kurwa kubhaatu, no okubhahorya abharweeri, no orusiku rwa katatu ndamara emirimo kyeego niari niiziri kukora.’ ");
INSERT INTO zak_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hamwe na gayo, ereenderwa nigeenderere no orugeendo rwaane okugya Yerusaremu reero, tabhoori na bhasiirya, kwo okubha ereenderwa ku murooti okukwa Yerusaremu, hatari ahagiro ahaandi! ");
INSERT INTO zak_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Emwe abhaatu bha Yerusaremu! Abhaatu bha Yerusaremu! Muriita abharooti no okubhatema amagina abhaatu bhano Taatabhugya abharageenie kweemwe. Maanga maaru niendiri okubhakumania emwe kyeego ekoko ekukumania ebhizuuzuru bhyaaye mumabhabha gaaye, nawe muteendiri! ");
INSERT INTO zak_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Murore bhoono! Muratigirwa enyuumba yeenyu bhusa! Nawe, ndabhabhuurira, eheene mutakuundora kweeki, tee hano muraagaambe, ‘Atweerwe ebhite wuno akuuza kuriina ryo Omukuru.’ ” ");
INSERT INTO zak_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Orusiku rwo okumuunya, Yeesu akagya kurya ebhyaakurya mumugye gwo omukaangati owumwe wa Abhafarisayo. Na hano yaari mumugye muyo, Abhafarisayo na abhaatu abhaandi bhaari bharamwiisuunza bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ne embere waaye hayo, yaariho omuutu owumwe wuno yaari no obhurweeri bhwo okubhiimba omubhiri. ");
INSERT INTO zak_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yeesu akabhuurya Abhafarisayo na abheegya bhe emigiro, “Awe! Emigiro gya Musa giriikirirya kuhorya abhaatu orusiku rwo okumuunya, kasi tutakweenderwa kuhorya?” ");
INSERT INTO zak_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nawe, ebho bhakakira. Yeesu akamugwaataku omurweeri wuyo, akamuhorya, akamubhuurira agye yiika. ");
INSERT INTO zak_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Niho kweeki Yeesu akabhabhuurya, “Ni weewi gati weenyu, wuno etikiri yaaye hamwe engʼoombe yaaye yaangatubhiiri mukitaaro orusiku rwo okumuunya, yaange kuyiruusyamu kwo okubha ni rusiku rwo okumuunya?” ");
INSERT INTO zak_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Abhaatu bhayo, bhataari na ryo okugaamba. ");
INSERT INTO zak_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yeesu ahaarora kyeego abhagini bhe enyaangi yiyo, bhaari bhakwiitoora ebhituumbi bhye embere bhyo obhusuuku. Niho akabhabhuurira ekireengyo, akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Hano okuraarikwa mubhweenga, otiikara omweeya gwo omugini wo obhusuuku. Otakora ego, kwo okubha eratura ekabha araarikirwe omugini owuundi kukukira awe. ");
INSERT INTO zak_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Na wuno abharaarikiri awe no owuundi hano akuuza arakwiimeererya no okukubhuurira, ‘Omutigire wuno omweeya guyo yiikare.’ Hayo, oraaza kurora eziisoni bhukongʼu, kwo okubha oraswaagibhwa kugya kwiikara kumweeya gwo omuutu wi iyaasi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Kweego, hano oraaraarikwe munyaangi, noogye wiikare kumweeya gwo omuutu wi iyaasi, kwo okubha hano wurya akuraarikiri akuuza, akubhuurire, ‘Omusaani waane, nawuuze embere hano, niho ahazomu bhukongʼu.’ Kweego niigo bharaakusuuke no orabha embere ya abhagini bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Omuutu wuyo woosi wuno akwiigega omweene kubha omukuru, Taatabhugya aramwiikya iyaasi. Nawe omuutu wuyo woosi wuno akwiiyiikya, Taatabhugya aramutiirya kubha omukuru.” ");
INSERT INTO zak_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Niho, Yeesu akamubhuurira wurya yamuginihirye, “Hano oraabhakorere abhaatu ebhyaakurya bhya mumwiisi hamwe engoroobha, otabharaarika abhasaani, naabhe bhawamweenyu, naabhe abhahiiri bhaazo, naabhe abhanyaroobho bhaazo, naabhe abhaniibhi bha mumugye gwaazo. Oraakore ego, neebho bhoosi bharakuraarika, na kweego orabha okyooreriibhwe amariho kugarya obhakoreeri. ");
INSERT INTO zak_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Nawe, hano oraabhakorere enyaangi, oraarike abhataka, abharema, amagata na abhahoku. ");
INSERT INTO zak_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Niho oraabhone orubhaango, kwo okubha bhayo bhatana ekigiro kyo okukukyoorerya. Nawe, Taatabhugya niwe araakukyoorerye, kwiibhaga ryo okuryoora abhaatu bhe eheene.” ");
INSERT INTO zak_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Omugini owumwe wa bhano bhaari bhiikeeri neewe kwiigari, hano akiigwa amangʼana ga Yeesu, akamubhuurira, “Ano orubhaango, omuutu wowoosi wuno araarye enyaangi mubhutemi bhwa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nawe Yeesu akamukyoora, “Yaari ariho omuutu owumwe, wuno yakoriri enyaangi ekuru no okuraarika abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hano enyaangi yahikiri, akaragania omugya waaye kubharaarika bhoosi, abhabhuurire, ‘Muuze, ebhigiro bhyoosi bhibheeri!’ ");
INSERT INTO zak_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Nawe, abharaarikwa bhoosi bhakabha bharasabha okwaabhirwa. Wo obhutaangi akamubhuurira, ‘Niguriri omuguundu, ndeenderwa ngeende okugurora. Ndakusabha oniabhire.’ ");
INSERT INTO zak_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Owuundi akabhuga, ‘Niguriri eziingʼoombe ikumi zyo okurimira, na bhoono nkugya niri kuzisakya, ndakusabha oniabhire.’ ");
INSERT INTO zak_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“No owuundi akabhuga, ‘Niho nakweera omukari, kweego nitakunagya kuuza.’ ");
INSERT INTO zak_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Omugya wuyo akakyoora, akamubhuurira omukuru waaye gayo goosi. Niho omukuru wuyo akatiinda, akamubhuurira omuhokya waaye, ‘Noogye bhwaangu kunziinzira zya amaahukano na kuhizira hya mumugye guno, obhareete abhataka, abharema, amagata na abhahoku.’ ");
INSERT INTO zak_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kyaamwe, omugya wuyo akakyoora, akamubhuurira, ‘Omukuru, gano ondageenie nigakoriri, naabhe ego omweeya gukyaariho.’ ");
INSERT INTO zak_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Omukuru akamubhuurira, ‘Ambe! Noogye igutu yo omugye, kuziinzira zo okugya muziiroobho suuhu na mumiguundu, obhakumiirirye abhaatu bhiize bhasikire mumugye gwaane, tee gwiizure. ");
INSERT INTO zak_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nawe, bharya bhoosi bhano naraarikiri kubhutaangi, atariho naabhe owumwe, wuno araroote enyaangi yaane!’ ” ");
INSERT INTO zak_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yeesu ahaabha aratuniirirwa ne esaango ekuru ya abhaatu. Akiikibhuka, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Omuutu wowoosi wuno akuuza owaane atakunagya kubha omwaanamweega waane, eraabhe ataaniseegiri kukira wiise na nina, omukari na abhaana bhaaye, abhahiiri na abhasubhaati bhaaye, naabhe obhuhoru bhwaaye omweene. ");
INSERT INTO zak_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","No omuutu wowoosi wuno, akyaari kugega omusaraba gwaaye anituniirire, atakunagya kubha omwaanamweega waane. ");
INSERT INTO zak_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tubhuge owumwe weenyu areenda okwoomboka etimu etaambi bhukongʼu. Eheene, atakwoomboka akyaari okwiikara, no okwiiseega obhuguri bhwe ebhigiro bhino aroombokere etimu yiyo? Kwo okukora ego, niho araamenye kubha ane eziimbirya zo okwiisa okumara kwoomboka. ");
INSERT INTO zak_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Araatige okukora ego, aranagya akwoomboka obhurusa, nawe hasuuhwiigo atamwe okumariirya etimu. Niho abhahiti bharamuzibhura, ");
INSERT INTO zak_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bharabhuga, ‘Omuutu wuno yataangiri okwoomboka, nawe ataanagirye okurimara eriikiindaasi riyo!’ ");
INSERT INTO zak_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Niruusye ekireengyo ekiindi. Tubhuge abhatemi bhabhiri bhariibhanura okurwaana. Wo obhutaangi ana abhasirikare ebhikwe ikumi (10,000) ego, owuundi ebhikwe miroongo ebhiri (20,000). Wo obhutaangi atakunagya kugya mwiirwaana bhakyaari kwiikara no okwiiseega kyeego araanagye okurwaana na wuno ana abhasirikare ebhikwe miroongo ebhiri (20,000). ");
INSERT INTO zak_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Araarore kubha aratamwa eriihi, arabhatuma abhabhagati bhaaye, bhagye bhwaangu kumutemi owuundi araabhe kure, bhiigwaane. ");
INSERT INTO zak_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ambe, kweemwe atariho wuno araanagye kubha omwaanamweega waane, kweego akyaari kutiga ebhigiro bhyoosi bhino anabhyo. ");
INSERT INTO zak_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Omuunyu ni muzomu, nawe guraabhe gusarikiri, gutakubha no obhuzoma bhwo omuunyu kweeki. ");
INSERT INTO zak_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Omuunyu gwe etuubho yino, gutakweenderwa, naabhe kumarobha, naabhe kutuumo yo oruse, niho erataaswa kure. Wa amatwi, yiitegeerere kisi!” ");
INSERT INTO zak_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kwiibhaga riyo, abhatobhya bhe eriigooti na bhe ebhibhi, bhoosi bhahaaza ku Yeesu okubha bhamwiitegeerere. ");
INSERT INTO zak_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ekagirya Abhafarisayo na abheegya bhe emigiro bhakiiriririrya bhakubhuga, “Omuutu wuno, ndora arabhasuungʼaana bhe ebhibhi na kweeki ararya nabho!” ");
INSERT INTO zak_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kweego, Yeesu akagaamba ekireengyo, akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tubhuge owumwe weenyu ane eziingʼoondu igana rimwe (100). Araamenye kubha eyimwe ebhuriri, arakorabhwi? Arazitiga zirya miroongo keenda na keenda (99) mukiriisyo, no okugya kuikomya yirya ebhuriri, tee ayibhone. ");
INSERT INTO zak_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hano araayibhone, arayisesera kwiibhega kwo obhuzomererwa, ");
INSERT INTO zak_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","no okuyireeta mumugye. Hayo arabhabhirikira abhasaani na abhanyaroobho bhaaye no okubhabhuurira, ‘Tuzomererwe hamwe, kwo okubha engʼoondu yaane yino yabhuriri, niyibhweeni!’ ");
INSERT INTO zak_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Ndabhabhuurira, niigo ego bhuraabhe obhuzomererwa bhwaaru mwiisaaro, hano we ebhibhi owumwe araate ebhibhi bhyaaye. Obhuzomererwa bhuyo bhurabha bhukuru kukira bhurya bhwa abhaatu abhazomu emiroongo keenda na keenda (99) bhano bhatana obhweendi bhwo okuta ebhibhi.” ");
INSERT INTO zak_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Niho akabhabhuurira ekireengyo, akabhuga, “Tubhuge kubha, omukari owumwe ane eziidinaari ikumi, na araabhurye edinaari eyimwe. Atakwaakya etara no okutarikya enyuumba yoosi, ayikomye kwo omukya tee ayibhone? ");
INSERT INTO zak_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hano araayibhone, arabhirikira abhasaani na abhanyaroobho bhaaye no okubhabhuurira, ‘Tuzomererwe hamwe, kwo okubha orubhirya runo rwaabhuriri, nirubhweeni!’ ");
INSERT INTO zak_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ndabhabhuurira, niigo ego Taatabhugya akuzomererwa embere ya bhamaraika, hano we ebhibhi owumwe akuta ebhibhi bhyaaye.” ");
INSERT INTO zak_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yeesu akoongera okugaamba, “Yaariho omuutu owumwe, ahaabha na abhaana bhabhiri bhe ekisubhe. ");
INSERT INTO zak_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Omusuuhu, akagya kuwiise akamubhuurira, ‘Taata, nihaane engabho yaane.’ Kyaamwe, wiise akabhatwaania abhaana bhabhiri obhuniibhi bhwaaye. ");
INSERT INTO zak_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Hano zyahitiri eziisiku suuhu, omusuuhu wurya akakumania ebhigiro bhyaaye bhyoosi, akagya orugeendo rwe ekyaaro kya kure. Hano yahikiri eyo, akataanga kusarya ebhigiro bhyaaye kwo obhutuumbaahu. ");
INSERT INTO zak_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hano yamariri bhyoosi, ekatuuka enzara haari kukyaaro kirya, woosi akabha araraambuka. ");
INSERT INTO zak_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kweego, akagya kumuutu wumwe wa mukyaaro kiyo, akamusabha amwiikiririrye abhe omuhokya waaye. Omuutu wuyo, akamutuma agye mumuguundu gwaaye okuriisya eziimbiizi. ");
INSERT INTO zak_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na hano eziimbiizi zaari kurya amakaanda, akabha ne enaamba yo okugarya omweene, nawe atariho omuutu wuno yamuheeri kiyo kyoosi kyo okurya. ");
INSERT INTO zak_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Hano yamariri, akahiituka, akiiseega kubha, ‘Abhabhagati bha taata, ndora bhoosi bhararya, tee bhariiguta no okusaagya! Nawe enye hano, ndakwa kwe enzara. ");
INSERT INTO zak_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndakyoora kutaata no okumubhuurira, “Taata, nimukoreeri ebhibhi Taatabhugya na nikukoreeri naawe woosi. ");
INSERT INTO zak_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nitakweenderwa kweeki kubhirikirwa omwaana waazo. Kweego, onikore kyo owumwe wa abhabhagati bhaazo.” ’ ");
INSERT INTO zak_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Kyaamwe, omumura wuyo akabhuuka hayo, akakyoora kuwiise. Na hano yaari akyaari kure ne enyuumba, wiise akamurora, akamurorera ebhigoongi bhukongʼu. Niho, akamuryaarira omwaana waaye, akamuhuumbata kwo obhuseegi. ");
INSERT INTO zak_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Omwaana wuyo, akamubhuurira wiise, ‘Taata, nimukoreeri ebhibhi Taatabhugya na nikukoreeri naawe woosi. Nitakweenderwa kweeki kubhirikirwa omwaana waazo.’ ");
INSERT INTO zak_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Nawe, wiise akabhabhuurira abhagya bhaaye, ‘Mureete bhwaangu engibho enzomu mumwiibhohye! Mumwiibhohye eseeri kukyaara kyaaye ne ebhikweera kumaguru. ");
INSERT INTO zak_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mureete emoori enuru yirya, mugwaage. Turye enyaangi kwo obhuzomererwa, ");
INSERT INTO zak_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kwo okubha omwaana waane yaari abhuriri, nawe bhoono atuukiri! Ahaabha kya wuno akuuri, na bhoono ni muhoru kweeki!’ Niho bhayo bhoosi bhakataanga kukora enyaangi kwo obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Eriibhaga riyo, omwaana waaye omukuru yaari mumuguundu. Hano yaari kukyoora no okwiisuka yiika, akiigwa omubhari na abhaatu bharabhina. ");
INSERT INTO zak_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akabhirikira omugya wumwe, akamubhuurya, ‘Mangʼanaki gari hayo?’ ");
INSERT INTO zak_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Akamubhuurira, ‘Omusuuhu waazo yiiziri, na taata amugwaagiri emoori enuru yirya, kwo okubha amubhweeni omwaana waaye kweeki, ari muhoru.’ ");
INSERT INTO zak_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Omwaana omukuru wuyo akatiinda, akaanga okusikira munyuumba. Wiise akahuruka habhoori, akabha aramwiisasaama asikire yiika. ");
INSERT INTO zak_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Omwaana omukuru akamukyoora, ‘Itegeerera! Kumyaaka myaaru nikuhokeerye, na nikyaari kutiga okukwiitegeerera obhuswaagyo bhwaazo naabhe rumwe! Nawe enye, otaniheeri naabhe akabhuri, nigwaage nirye hamwe na abhasaani bhaane. ");
INSERT INTO zak_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nawe omwaana waazo wuno asarirye obhuniibhi bhwaazo kubhasiimbe, angu hano yiiziri, omugwaagiiri ewe emoori enuru!’ ");
INSERT INTO zak_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Wiise akamubhuurira, ‘Omwaana waane, turiikara hamwe eziisiku zyoosi, ne ebhigiro bhyoosi bhino ninabhyo ni bhyaazo. ");
INSERT INTO zak_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nawe omusuuhu waazo, tweendiri tumukorere enyaangi no okuzomererwa hamwe, kwo okubha ahaabha abhuriri, nawe bhoono atuukiri, ahaabha kya wuno akuuri, nawe bhoono ni muhoru.’ ” ");
INSERT INTO zak_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yeesu akabhabhuurira abhaanabheega bhaaye, “Hahaabhaho omuniibhi owumwe no omwiimeerereri waaye. Omwiimeerereri wuyo, arasemwa kubha ahaasarya obhuniibhi bhwo omukuru waaye. ");
INSERT INTO zak_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kweego, omuniibhi akamubhirikira omwiimeerereri waaye, akabhuga, ‘Awe! Amabhi gano niigwiiri iguru yaazo, ni amangʼanaki gayo? Onierekye ekireengo kye ebhigiro bhyaane, kwo okubha otakunagya kweenderera kubha omwiimeerereri waane!’ ");
INSERT INTO zak_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Omwiimeerereri wuyo akiibhuurya, ‘Nikorebhwi bhoono? Omukuru waane, anduusiirye mumirimo. Ntana amanaga go okurima, na ndarora eziisoni okusabhasabha. ");
INSERT INTO zak_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ambe! Nimenyiri ryo okukora, okubha hano ndaheebhwe emirimo, abhaatu bhanagye okuniginihya mumigye gyaabhu.’ ");
INSERT INTO zak_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kweego, omwiimeerereri akabhabhirikira abhaatu bhoosi bhano bhaari ne esiiri kumukuru waabhu, owumwe kwo owumwe. Akamubhuurya wo obhutaangi, ‘Esiiri yaazo kumukuru waane ni iriinge?’ ");
INSERT INTO zak_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Akamukyoora, ‘Esiiri yaane ni mapipa igana (100) ga amaguta ge emizeituni.’ “Omwiimeerereri akabhuga, ‘Gega enyaarubha yino, ekaamirwe endihi yaazo. Ikara hano, oyikyoorye, ikaame miroongo etaano (50).’ ");
INSERT INTO zak_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Niho akamubhuurya omusiiri wa kabhiri, ‘Awe, esiiri yaazo ni iriinge?’ “Akamukyoora, ‘Amagonera igana (100) ge engano.’ “Omwiimeerereri wurya akabhuga, ‘Gega enyaarubha yino ye esiiri yaazo, yikaame miroongo enaane (80).’ ");
INSERT INTO zak_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Niho wurya omuniibhi akamukumya omwiimeerereri wuyo kwo obhungʼeeni bhwaaye, kwo okubha, abhaatu bhe ekyaaro kino bhana amangʼeeni go okwiikorera amangʼana gaabhu na abharikyaabhu, kukira abhaatu bho obhweero. ");
INSERT INTO zak_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Enye ndabhabhuurira, mukorere obhuniibhi bhweenyu bhwa mukyaaro kino mwiibhonere abhasaani, kubha hano murahweerwe obhuniibhi, bhabhasuungʼaane mubhwiikari bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Omuutu wuno akubha omuheene kumangʼana amasuuhu, arabha omuheene kumakuru. Egoego, omuutu wuno atari omuheene kumangʼana amasuuhu, atari omuheene kumakuru. ");
INSERT INTO zak_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na eraabhe mutabheeri abhaheene kwo okuhokeerya obhuniibhi bhwe ekyaaro kino, ambe ni weewi wuno araabhiituruurire obhuniibhi bhwe eheene? ");
INSERT INTO zak_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na eraabhe mutabheeri abhaheene kwo okuhokeerya obhuniibhi bho owuundi, etakuturikana muhaabhwe ebhigiro bhyeenyu abheene! ");
INSERT INTO zak_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Atariho omuutu wuno akunagya kuhokeerya abhakuru bhabhiri kwe eriibhaga rimwe. Yaangakoriri ego, aranagya okumubhiihirirya omukuru owumwe no okuseega owuundi, kasi kugwaatana no owumwe no okuzeera owuundi. Kweego na neemwe, mutakunagya okumuhokeerya Taatabhugya ne eziimbirya kwe eriibhaga rimwe!” ");
INSERT INTO zak_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hano Abhafarisayo bhakiigwa amangʼana gayo ga Yeesu, bhakataanga okumuseka kwo okuzeera, kwo okubha bhakaseega eziimbirya bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yeesu akabhabhuurira, “Emwe muriikora bhe eheene embere ya abhaatu, nawe Taatabhugya amenyiri amangʼana gano gari muziikoro zyeenyu. Obhuheene, amangʼana gano abhaatu bhakwiisigira bhukongʼu, garamutindya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Emigiro gya Musa, na amakaamo ga abharooti, gaari gariitegeererwa na abhaatu tee ku Yohana. Okweema eriibhaga ryaaye, Amangʼana Amazomu go obhutemi bhwa Taatabhugya gaari gararwaazwa, na abhaatu bhoosi bhareenda bhiisikirye. ");
INSERT INTO zak_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nawe, ni kunyoohu bhukongʼu kwe eriisaaro ne ekyaaro okubhura, kukira orukaamo orusuuhu rwe emigiro okuruusibhwaho. ");
INSERT INTO zak_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Omuutu wuno akutaana na mukaaye no okumukweera owuundi, aramukorera obhuseebheeti. Neewe omukweeri wo omukari wuno ataaniri no omusubhe waaye, aseebheetiri.” ");
INSERT INTO zak_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ahaabhaho omuniibhi wumwe, akiikara obhwiikari bhuzomu eziisiku zyoosi, no okwiibhoha emyeenda emizomu gye ezambaraau gyo obhuguri obhukuru. ");
INSERT INTO zak_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na mukiseku kyo omuniibhi wuyo, hahaabha no omutaka wumwe, eriina ryaaye Razaro. Razaro wuyo, omubhiri gwaaye gwoosi gukiizura amagaati, ");
INSERT INTO zak_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","na eziimbwa zaari ziraaza kumeesa amagaati gaaye. Hano amasaagyo gakugwa kurwa mwiigari ryo omuniibhi wuyo, Razaro akabha ane enaamba ahaabhwe, kwo okubha ahiigwa enzara. ");
INSERT INTO zak_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kubhuteero, omutaka Razaro akakwa. Bhamaraika bhakamuhira mwiisaaro, haguhi na Aburahamu. Omuniibhi wurya woosi akakwa, akabhiikwa. ");
INSERT INTO zak_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na hano omuniibhi ahaabha aranyaaka bhukongʼu eyo nyaari, akagororokya ameeso, akarora Aburahamu kwa kure, na Razaro yaari haguhi neewe. ");
INSERT INTO zak_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Akamubhirikira kwiiraka, ‘Taata Aburahamu, ondorere ebhigoongi, ndanyaaka bhukongʼu mumuriro guno! Omutume Razaro yiize kweenye, atobhye esoonga ye ekyaara mumaanzi, agantonyerye kururimi rwaane runyohe.’ ");
INSERT INTO zak_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nawe, Aburahamu akamukyoora, ‘Omwaana waane, ohiite kubha okabhona amangʼana amazomu mubhwiikari bhwaazo, na Razaro akabhona amabhi. Nawe bhoono, ewe aratoongerwa ekoro, na naawe oranyaaka bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hamwe na gayo, gati yeetu na neemwe, guterweho omwoobho omukuru bhukongʼu. Obhugazuro bhwo omwoobho ni kubha, bharya bhakweenda kurwa eno okugya oweenyu, bhatanagya okwaambuka, na bhano bhakweenda kurwa eyo okuuza oweetu, bhatanagya.’ ");
INSERT INTO zak_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Omuniibhi wuyo akabhuga, ‘Ambe taata, ndakusabha omutume Razaro agye yiika kutaata, ");
INSERT INTO zak_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","abharekye abhahiiri bhaane bhataano, bhataaza kuuza eno kunyaako ehaari.’ ");
INSERT INTO zak_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nawe, Aburahamu akamukyoora, ‘Abhahiiri bhaazo bhana amangʼana gano gakaamirwe no omurooti Musa na abharooti abhaandi. Bhabhiitegeerere bhayo!’ ");
INSERT INTO zak_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Akamukyoora, ‘Zeyi, taata Aburahamu! Nawe eraabhe omuutu arweere mubhaku abhagyeku, niho bhariikyoore no okuta ebhibhi bhyaabhu.’ ");
INSERT INTO zak_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aburahamu akamubhuurira, ‘Abhahiiri bhaazo bhayo, eraabhe bhatiitegeereeri gano gakaamirwe na Musa na abharooti, bhatakwiikirirya naabhe omuutu yaangaryokiri kurwa mubhaku.’ ” ");
INSERT INTO zak_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yeesu akabhabhuurira abhaanabheega bhaaye, “Ebhisigo bhino bhiraakore abhaatu bhakore ebhibhi, bhirabhaho kyoomeera. Nawe, araaza kurora omuutu wurya araagakore! ");
INSERT INTO zak_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yiingabheeri hakiriku kumuutu wuyo abhoherwe orubhwe mwiigoti no okurekerwa munyaanza, kukira amugirye owumwe wa abhasuuhu bhano akore ebhibhi. ");
INSERT INTO zak_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kweego, mwiiriihe mutaaza kukora ego! “Eraabhe, omuhiiri waazo araakusariirye, omuhiinye. Eraabhe araate ebhibhi bhyaaye, omwaabhire. ");
INSERT INTO zak_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na eraabhe araakusariirye muhuungati koosi kurusiku orumwe, na niigo araakyoore owaazo muhuungati kweeki abhuge, ‘Niteeri ebhibhi,’ omwaabhire.” ");
INSERT INTO zak_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Niho abheega bhayo bhakamubhuurira Omukuru Yeesu, “Turasabha otwoongereerye obhwiikirirya bhweetu!” ");
INSERT INTO zak_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Akabhakyoora, “Nawe muungabheeri no obhwiikirirya bhusuuhu bhukongʼu kye etetere esuuhu bhukongʼu, muungabhuuriiri omuti gwo omuko guno, ‘Ihika weemibhwe munyaanza!’ nagwe guungabhitegeereeri. ");
INSERT INTO zak_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tubhuge owumwe weenyu ano omugya wuno akurima kasi arariisya eziingʼoondu. Omugya wuyo araakyoore mumugye, omukuru waaye we emirimo amubhuurire, ‘Awe okore bhwaangu, ikara hano orye ebhyaakurya’? ");
INSERT INTO zak_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Zeyi! Amubhuurire, ‘Onikorere ebhyaakurya, na wiibhanure okunihokeerya tee, nimare kurya no okunywa. Niho awe orye no okunywa.’ ");
INSERT INTO zak_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ambe, omugya araagakore gano omukuru waaye akamuragania, omukuru wuyo aramubhuurira ozomirye kwo okugakora? Zeyi! ");
INSERT INTO zak_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Niigo ego na neemwe, hano mwiigwiiri gano nibhabhuuriiri, mubhuge, ‘Twoosi ni bhagya ego. Tukoriri kyeego tukeenderwa kukora.’ ” ");
INSERT INTO zak_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hano Yeesu yaari kugya Yerusaremu, akahita kumiimbi gatigati ye ebhyaaro bhya Samaria na Gariraaya. ");
INSERT INTO zak_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hano yaari akusikira mumugye gumwe, akasikana na abhageenge ikumi. Abhageenge bhayo bhakiimeerera kure neewe, ");
INSERT INTO zak_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bhakatiirya eriiraka bharabhuga, “Omukuru Yeesu! Oturorere ebhigoongi, otuhorye!” ");
INSERT INTO zak_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yeesu akabharora, akabhabhuurira, “Mugeende mwiiyeerekye kubhaseengeri.” Bhakagya, na hano bhaari munzira, bhakahoribhwa. ");
INSERT INTO zak_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Owumwe waabhu, hano yaruuzi kubha amariri kuhoribhwa, rugeendo rumwe akakyoora ku Yeesu, aramukumya Taatabhugya kwiiraka ikuru. ");
INSERT INTO zak_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hano yahikiri, akiitaasa bhubhuumari embere wa amaguru ga Yeesu, akamubhuurira, “Ozomirye.” Na omuutu wuyo, yaari Musamaria. ");
INSERT INTO zak_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yeesu akabhuga, “Ndora nikahorya abhaatu ikumi! Keenda bharya bhaari hayi? ");
INSERT INTO zak_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bhatariho bhano bhakyooriri kumukumya Taatabhugya, nawe ni mugya wuno omweene?” ");
INSERT INTO zak_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kyaamwe, Yeesu akamubhuurira, “Imeerera noogye owaazo, obhwiikirirya bhwaazo bhukuhonirye.” ");
INSERT INTO zak_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Orusiku rumwe, Abhafarisayo bhakamubhuurya Yeesu, “Obhutemi bhwa Taatabhugya, bhuraaza ryoori?” Yeesu akabhakyoora, “Obhuuzi bhwo obhutemi bhwa Taatabhugya, bhutari ekireengyo kino kikurorekana kwa ameeso. ");
INSERT INTO zak_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Abhaatu bhatakunagya kubhuga, ‘Murore! Bhuri hano!’ kasi, ‘Murore! Bhuri harya!’ Mumenye kubha obhutemi bhwa Taatabhugya bhuri gati weenyu.” ");
INSERT INTO zak_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Niho Yeesu akabhuurira abhaanabheega bhaaye, “Kuziisiku zino zikuuza, mune enaamba okurora naabhe orusiku rumwe runo enye Omwaana wo Omuutu, nikubha ndakaangata ekyaaro, nawe mutakururora. ");
INSERT INTO zak_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abhaatu bharabhabhuurira, ‘Murore! Wurya harya!’ kasi ‘Murore! Wuno hano!’ Nawe abhaatu bhayo, mutabharyaarira. ");
INSERT INTO zak_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gayo nibhabhuuriiri kwo okubha, enye Omwaana wo Omuutu ndaakyoore, ndaaza kyo orumesyo runo rukumesya mbaara zoosi ze eriisaaro. ");
INSERT INTO zak_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nawe, hano gakubha gakyaari kutuuka, niho enye Omwaana wo Omuutu nireenderwa nibhone enyaako bhukongʼu no okwaangwa na abhaatu bho orwiibhuro runo. ");
INSERT INTO zak_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kyeego ehaabha kuziisiku zya Nuhu, niigo eraabhe kuziisiku zye enye Omwaana wo Omuutu. ");
INSERT INTO zak_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Abhaatu bhaari bhararya no okunywa, bharakweera no okukweerwa, kuziisiku zya Nuhu, tee orusiku rurya Nuhu akasikira musafina. Hayo, omusabhuko gwe embura gukaaza, gukabhasikya bhayo bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Kyeego yaari kuziisiku zya Roti, niigo ego amangʼana garaabhe kuziisiku zye enye Omwaana wo Omuutu. Abhaatu bhaari bhararya no okunywa, bharagura no okusuruzya, bhararima no okwoomboka. ");
INSERT INTO zak_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nawe orusiku rurya hano Roti yarwiiri Sodoma, omuriro omuhaari gwe ekibhiriiti gukiika kurwa mwiisaaro, gukabhasikya bhayo bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Kweego niigo eraabhe orusiku runo enye Omwaana wo Omuutu ndaakuundukurwe. ");
INSERT INTO zak_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Orusiku ruyo, omuutu wuyo woosi ari iguru kukisara, atasakya kwiika kugega ebhigiro bhyaaye munyuumba, aryaare. Na wuno akubha mumuguundu, ewe angʼose, atakyoora yiika kugega kyokyoosi. ");
INSERT INTO zak_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Muhiite gano gaamubhweeni omukari wa Roti! ");
INSERT INTO zak_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Omuutu wowoosi wuno akusakya okuriibha obhwiikari bhwaaye niwe araabhubhurye, no omuutu wuno araabhubhurye, niwe araabhutuurye. ");
INSERT INTO zak_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ndabhabhuurira kubha, obhutiku bhuyo, abhaatu bhabhiri bharabha bhahiindiiri kubhuriri bhumwe, owumwe aragegwa no owuundi aratama. ");
INSERT INTO zak_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Orusiku ruyo, abhakari bhabhiri bharabha bharasya hamwe, owumwe aragegwa no owuundi aratama.  ");
INSERT INTO zak_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kweeki abhasubhe bhabhiri, bharabha bharakora emirimo mumuguundu, owumwe aragegwa no owuundi aratama.” ");
INSERT INTO zak_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abheega bhakamubhuurya, “Omukuru Yeesu, gayo garakorwa hayi?” Akabhakyoora, “Hano mukurora amatoonyi gariikumania ahagiro, muramenya kubha ekituundu kiri hayo, na niigo mukurora ekitiika kiyo mumenye kubha orusiku ruyo ruhikiri.” ");
INSERT INTO zak_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yeesu akabhabhuurira abhaanabheega bhaaye ekireengyo kino, kubheerekya kubha ereenderwa kumusabha Taatabhugya bhataaza kuniha. ");
INSERT INTO zak_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akabhabhuurira, “Kumugye gumwe, hahaabha no omutini we ekiina owumwe, ewe ataari kumwiigwa Taatabhugya, naabhe ataabhasuukiri abhaandi, naabhe ataabhamurirye abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na kumugye guyo, yaariho omutuumba owumwe. Neewe ahaabha aramugyaku omutini we ekiina ibhaga ryaaru kumwiisasaama, akamubhuurira, ‘Ndasabha oniimeererere kwe eheene gati waane no omubhisa waane.’ ");
INSERT INTO zak_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Kwiibhaga itaambi, omutini we ekiina wuyo akaanga okumusakirya omutuumba. Nawe kubhuteero, akiigaambira mukoro yaaye, ‘Enye nitakumwiigwa Taatabhugya, naabhe nitakubhasuuka abhaandi, naabhe nitakumura omuutu wowoosi. ");
INSERT INTO zak_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nawe, kwo okubha omutuumba wuno araninyaakya bhukongʼu, bhoono ndamwiimeererera kwo obhuheene, okubha ateenderera okunirosya kwo okuniizaku!’ ” ");
INSERT INTO zak_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Niho, Omukuru Yeesu akabhuga, “Tweege bhwaheene ekireengyo kyo omutini we ekiina omuzabhuri wuyo, naabhe ewe kubhuteero akatina ekiina bhwaheene. ");
INSERT INTO zak_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eraabhe niigo, erabhabhwi ku Taatabhugya, atakubhasakirya abhasorwa bhaaye bharya asoriri, bhano bhakumuririra obhutiku no omwiisi? Tubhuge kubha arakeezera kubhasakirya? ");
INSERT INTO zak_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ndabhabhuurira, arabhatinira bhwaangu ekiina kwe eheene. Nawe heene, hano enye Omwaana wo Omuutu ndaakyoore mukyaaro, ndabhona abhaatu bhakyaari no obhwiikirirya?” ");
INSERT INTO zak_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kweeki Yeesu akaruusya ekireengyo kubhaatu abhaandi, bhano bhiiruuzi kubha nibho bhe eheene embere ya Taatabhugya, no okubhazeera abhaandi. Akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Abhaatu bhabhiri, bhakagya kusabha mwiiseengerero rya Taatabhugya. Owumwe yaari Omufarisayo, no owuundi yaari omutobhya we eriigooti. ");
INSERT INTO zak_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Omufarisayo wuyo akiimeerera, amusabhe Taatabhugya iguru wa amangʼana gaaye omweene, ‘Weyaa Taatabhugya, ndabhuga ozomirye, kwo okubha enye nitari omubhi kya abhaandi, abhasoohu, abhabheehi na abhaseebheeti, naabhe kyo omutobhya we eriigooti wuyo. ");
INSERT INTO zak_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ndiisiitya ebhyaakurya kabhiri kubhutuuro, na kuziimbirya zyaane zyoosi, ndakuruusirya yimwe yi ikumi ye ebhigiro bhyaane.’ ");
INSERT INTO zak_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nawe omutobhya we eriigooti wuyo, akiimeerera kure hasuuhu. Na ateendiri naabhe kugororokya ameeso gaaye mwiisaaro, niho akabha ariitematema mukikubha kyaaye kwe ebhigoongi, arabhuga, ‘Taatabhugya, ondorere ebhigoongi, enye ni we ebhibhi!’ ” ");
INSERT INTO zak_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Niho Yeesu akoongera amangʼana gayo, “Ndabhabhuurira kubha, omutobhya we eriigooti wuyo akakyoora mumugye, akubharwa kubha we eheene embere wa Taatabhugya. Nawe owuundi ewe zeyi! Omuutu wuyo woosi wuno akwiigega omweene kubha omukuru, Taatabhugya aramwiikya iyaasi. Nawe omuutu wuyo woosi wuno akwiiyiikya, Taatabhugya aramutiirya kubha omukuru.” ");
INSERT INTO zak_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eriibhaga eriindi, abhaatu bhakamureetera Yeesu naabhe abhaana bhaabhu abhasuuhu, okubha abhatuurire amabhoko gaaye na abhatweere ebhite. Hano abhaanabheega bhaaye bhaakoriri ego, bhakataanga kubharekya abhiibhuri. ");
INSERT INTO zak_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nawe, Yeesu akabhabhirikira abhaana bhayo kweewe, akabhuga, “Mubhatige abhaana abhasuuhu bhiize kweenye! Mutabharekya, kwo okubha obhutemi bhwa Taatabhugya ni bhwa abhaatu kya abhaana abhasuuhu bhano. ");
INSERT INTO zak_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ndabhabhuurira obhuheene, wowoosi wuno atakwiikirirya obhutemi bhwa Taatabhugya kyo omwaana omusuuhu, atakunagya kubhusikira naabhe hasuuhu.” ");
INSERT INTO zak_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Omukaangati owumwe wa Abhayahudi, akamubhuurya Yeesu, “Omweegya omuzomu, nikorebhwi, niize nibhone obhuhoru bhwa kirakeego?” ");
INSERT INTO zak_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yeesu akamukyoora, “Kwaki orabhuga enye ni muzomu? Atariho omuutu muzomu, nawe Taatabhugya omweene ego. ");
INSERT INTO zak_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awe, omenyiri bhuzomu emigiro gya Taatabhugya, ‘Otaseebheeta, otiita, otiibha, otamenyeekererya orurimi, obhasuuke wuuso na nyoko weenyu.’ ” ");
INSERT INTO zak_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Omukaangati akamukyoora, “Emigiro gino gyoosi, nigigwaatiri kweema obhwaana bhwaane.” ");
INSERT INTO zak_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hano Yeesu akiigwa gayo, akamubhuurira, “Oreenderwa okore engʼana yimwe ego. Noogye ogurye ebhigiro bhyoosi bhino onabhyo, ne eziimbirya zino oraabhone, obhatwaanire abhataka. Oribha okoriri ego, orabha wiituuriiri ehata mwiisaaro. Okumara, wuuze onituniirire.” ");
INSERT INTO zak_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hano omukaangati wuyo yiigwiiri gayo, akiitiimaata, kwo okubha yaari muniibhi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hano Yeesu yamuruuzi yiitiimaatiri ego, akabhuga, “Erabha kukongʼu kumuniibhi kusikira mubhutemi bhwa Taatabhugya! ");
INSERT INTO zak_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ni kunyoohu kwe engamia okuhita mukibhaanga kyo orugera, kukira omuniibhi kusikira mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abhaatu hano bhakiigwa gayo, bhakabhuga, “Bhoono, eraabhe niigo gari, weewi wuno akunagya kutuuribhwa?” ");
INSERT INTO zak_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yeesu akabhabhuurira, “Kubhaatu gatakuturikana, nawe ku Taatabhugya garaturikana.” ");
INSERT INTO zak_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Niho, Petero akamubhuurira Yeesu, “Rora etwe, tumariri kutiga bhyoosi, tukakutuniirira!” ");
INSERT INTO zak_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yeesu akabhuga, “Ndabhabhuurira obhuheene, omuutu wuno atigiri enyuumba, hamwe omukari waaye, hamwe abhamura bhaabhu, hamwe abhiibhuri bhaaye, hamwe abhaana bhaaye, kwiiguru yo obhutemi bhwa Taatabhugya, ");
INSERT INTO zak_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","eheene arasuungʼaana maaru bhukongʼu kukira bhino akatiga, araabhe akyaari mukyaaro hano. Ne eriibhaga rino rikuuza, arasuungʼaana obhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yeesu akakumania abhaanabheega bhaaye ikumi na bhabhiri kibhezo, akabhabhuurira, “Murore, bhoono tureerekera Yerusaremu, na eyo gano goosi abharooti bhaakaamiri iguru ye enye Omwaana wo Omuutu, garakuunaana. ");
INSERT INTO zak_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ndagazibhwa kubhaatu bhano bhatari Abhayahudi, bhano bharanizibhura no okunituka, bharanitweera amate. ");
INSERT INTO zak_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kweeki, bharanitema emijariti no okuniita, nawe orusiku rwa katatu, ndaryooka.” ");
INSERT INTO zak_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nawe amangʼana gano Yeesu yabhabhuuriiri abhaanabheega bhaaye, bhataamenyiri kwo okubha gaari gabhisirwe kweebho, neebho bhataamenyiri yaari arakeereneryaki. ");
INSERT INTO zak_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yeesu yaari ariisukira omugye gwa Yeriko, na orubhaara rwe enzira, yaari ariho omuhoku owumwe, ewe ahaabha yiikeeri arasabhasabha. ");
INSERT INTO zak_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Hano akiigwa abhaatu bhaaru bharahita hayo, akabhuurya, “Niki kiriiyo?” ");
INSERT INTO zak_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhakamubhuurira, “Yeesu wa Nazareeti arahita.” ");
INSERT INTO zak_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Rugeendo rumwe, akatiirya eriiraka, arabhuga, “Ee Yeesu, Omwaana wo omutemi Daudi, ondorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abhaatu bhano bhamukaangatiri Yeesu bhaari bharamurekya kubha akire. Nawe ewe, akoongera akatiirya eriiraka akamubhirikira, “Omwaana wo omutemi Daudi, ondorere ebhigoongi!” ");
INSERT INTO zak_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hano Yeesu akiigwa eriiraka ryo omuhoku wuyo, akiimeerera, akaswaagya bhamureete kweenye. Hano omuhoku akiisuka, Yeesu akamubhuurya, ");
INSERT INTO zak_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Oreenda nikukorereki?” Akabhuga, “Ee Omukuru, ndeenda okurora!” ");
INSERT INTO zak_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yeesu akamubhuurira, “Orore! Obhwiikirirya bhwaazo bhukuhonirye.” ");
INSERT INTO zak_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Rugeendo rumwe, akarora, akamutuniirira Yeesu, eno aramukumya Taatabhugya. Na abhaatu bhoosi, hano bhaakoriri gayo, bhakataanga okumukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yeesu akasikira mumugye gwa Yeriko, akabha arahita gatigati yo omugye. ");
INSERT INTO zak_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mumugye guyo, yaari arimu omuniibhi wumwe, eriina ryaaye Zakayo, ewe yaari omukuru wa abhatobhya bhe eriigooti. ");
INSERT INTO zak_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yaari areenda kurora Yeesu ni muutu wa tuubhoki, nawe ataanagirye kumurora, kwo okubha esaango ya abhaatu yaari ni kuru, neewe ni muguhi. ");
INSERT INTO zak_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kweego akaryaara bhwaangu, akagya embere we esaango yiyo, akatiira kumuti gwo omuko, okubha anagye kumurora Yeesu akuhita kunzira yiyo. ");
INSERT INTO zak_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Hano Yeesu yahikiri hayo, akiisuunza kumuti iguru, akabhuga, “Zakayo, ituuma bhwaangu! Nireenderwa nibhe omugini mumugye gwaazo reero.” ");
INSERT INTO zak_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rugeendo rumwe Zakayo akiituuma, akamuginihya Yeesu mumugye gwaaye kwo obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Abhaatu bhoosi, hano bhaaruuzi gayo, bhakataanga kwiiririirirya, bharabhuga, “Ndora agiiri kurya no omukori we ebhibhi!” ");
INSERT INTO zak_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nawe, Zakayo akiimeerera, akamubhuurira “Itegeerera, Omukuru Yeesu! Bhoono ego, eriitinika rye ebhigiro bhyaane ndabhaha abhataka. Na eraabhe nimuruusirye omuutu wowoosi, ndamukyoorerya kane.” ");
INSERT INTO zak_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yeesu akabhuga, “Reero yino, obhutuurya bhuhikiiri abhaatu bhe enyuumba yino. Omuutu wuyo woosi, bhoono ni we ekisyooko kya Aburahamu, ");
INSERT INTO zak_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","kwo okubha enye Omwaana wo Omuutu, niiziri kumoohya no okutuurya abhaatu bhano bhabhuriri.” ");
INSERT INTO zak_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hano abhaatu bhaari bhakwiitegeerera amangʼana gayo, Yeesu akeenderera kugaamba ekireengyo kimwe, kwo okubha yaari ariisukira Yerusaremu, na abhaatu bhayo bhakiiseega kubha, obhutemi bhwa Taatabhugya bhuratuuka kwiibhaga riyoriyo. ");
INSERT INTO zak_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kweego, akabhuga, “Yaari ariho omuutu owumwe we ekisyooko kyo obhutemi. Omuutu wuyo, akagya orugeendo kukyaaro kya kure, okubha ahaabhwe obhukaangati bhwo okubha omutemi, kyaamwe akyoore kukaangata ekyaaro kyaaye. ");
INSERT INTO zak_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Hano ya akyaari kugya, akabhabhirikira abhagya bhaaye ikumi gati wa abhaandi, akabhaha eziimiina ikumi, akabhabhuurira, ‘Mukore obhusuruzya bhwe eziimbirya zino tee hano ndaakyoore.’ ");
INSERT INTO zak_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Nawe abhaatu bhe ekyaaro kyaaye bhakamubhiihirirya bhukongʼu. Bhakatuma abhaatu bhamutuniirire no okuhira amangʼana, bharabhuga ‘Tutakumweenda omuutu wuno abhe omutemi weetu!’ ");
INSERT INTO zak_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nawe, akahaabhwa obhukaangati bhwo obhutemi. Hano yakyooriri, omutemi akabhabhirikira abhabhagati bharya akabhahaana eziimbirya, okubha omugya wowoosi amubhuurire omutemi abhweeni bhweeraki. ");
INSERT INTO zak_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Omugya wo obhutaangi akahika, akamubhuurira, ‘Omutemi, kuriingʼaana ne eziimbirya zino waantigiiri, nibhweeni obhweera bhwi ikumi kukiraho.’ ");
INSERT INTO zak_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Omutemi wuyo akamubhuurira, ‘Okoriri kisi. Awe ni mugya muzomu! Kya bhurya waari omuheene kumahokya amasuuhu bhukongʼu, ndakuha obhukuru iguru ye emigye ikumi.’ ");
INSERT INTO zak_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Omugya wa kabhiri woosi akahika, akamubhuurira, ‘Omutemi, kuriingʼaana ne eziimbirya zino waantigiiri, nibhweeni obhweera bhwi isaano kukiraho.’ ");
INSERT INTO zak_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Omutemi akamubhuurira, ‘Woosi, ndakuha obhuturo iguru ye emigye etaano.’ ");
INSERT INTO zak_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Omugya owuundi akahika, akabhuga, ‘Omutemi, eziimbirya zyaazo nzino hano, nikazibhisa kumweenda, zitaaza kubhura. ");
INSERT INTO zak_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nikakora ego kwo okubha ndakwoobhoha, awe ni muutu mukongʼu, oragega gano otaagateeriho, na oragesa gano oteemirye.’ ");
INSERT INTO zak_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Omutemi akamubhuurira, ‘Omugya omubhi! Bhoono ndakutinira ekiina kumangʼana gaazo omweene. Ogaambiri omenyiri kubha enye ni muutu mukongʼu, ndagega garya nitaagateeriho, na ndagesa gano niteemirye? ");
INSERT INTO zak_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Eraabhe niigo, bhoono kwaki otanibhiikiiri eziimbirya zyaane kubhasuruzya, okubha nizigege hamwe no obhweera bhwaku hano nikukyoora owaane?’ ");
INSERT INTO zak_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Rugeendo rumwe, akabhabhuurira abhaatu bhano bhaari bhiimeereeri hayo, ‘Mugege eziimbirya zya wuyo, mumuhe wurya abhweeni obhweera bhwi ikumi.’ ");
INSERT INTO zak_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Bhakamubhuurira, ‘Nawe omutemi, ndora wuno abhweeni obhweera bhwi ikumi!’ ");
INSERT INTO zak_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Akabhuga, ‘Ndabhabhuurira kubha, omuutu wowoosi wuno akukorera emirimo ebhigiro bhino nimuheeri, ndamwoongerya ebhiindi. Nawe, omuutu wowoosi wuno atakukorera bhuzomu ebhigiro bhino nimuheeri, naabhe ebhisuuhu bhino anabhyo ndamuteesya. ");
INSERT INTO zak_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nawe abhabhisa bhaane bhano bhateendiri enye nibhe omutemi waabhu, mubhareete hano, mubhiite embere waane!’ ” ");
INSERT INTO zak_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hano Yeesu yamariri kugaamba gayo, akeenderera no orugeendo rwaaye rwo okugya Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hano yiisukiri mumigye gya Betifage na Betania, mu Kiguru kye Emizeituni. Niho akabharagania bhabhiri gati wa abhaanabheega bhaaye, ");
INSERT INTO zak_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","akabhabhuurira, “Mugeende mumugye guno guri embere weenyu. Hano muraasikire muyo, murabhona etikiri, yino ekyaari kugega muutu, ebhohirwe. Muyisibhure muyireete hano. ");
INSERT INTO zak_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Eraabhe omuutu wowoosi arabhabhuurya, ‘Ndora murayitazura?’ mumubhuurire, ‘Omukuru arayeenda.’ ” ");
INSERT INTO zak_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kimwe, abhaanabheega bhayo bhakagya, bhakabhona bhyoosi kyaabhurya Yeesu yabhabhuuriiri. ");
INSERT INTO zak_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hano bhaari bharatazura etikiri, bheene tikiri bhakabhabhuurya, “Emwe! Kwaki murasibhura etikiri yiyo?” ");
INSERT INTO zak_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhakabhabhuurira, “Omukuru arayeenda.” ");
INSERT INTO zak_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bhakamuhirira Yeesu etikiri yirya, bhakaarya emyeenda gyaabhu iguru yaku, kimwe bhakamutiirya Yeesu iguru waku. ");
INSERT INTO zak_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hano Yeesu yaari aragya, abhaatu bhakaarya emyeenda gyaabhu kunzira kwo okumusuuka. ");
INSERT INTO zak_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na hano yiisukiri ahagiro he ekihiriingito kye Ekiguru kye Emizeituni, esaango yoosi ya abhaanabheega bhaaye bhakataanga kumukumya Taatabhugya kwo obhuzomererwa, iguru ye ebhitiika bhyoosi bhino bharuuzi. Bhakatiirya eriiraka ryaabhu, ");
INSERT INTO zak_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","bhakabha bharabhuga, “Atweerwe ebhite omutemi wuno akuuza kuriina ryo Omukuru! Habhe no omureembe gati wa Taatabhugya na abhaatu bhaaye! Turamukumya Taatabhugya wuno ari mwiisaaro!” ");
INSERT INTO zak_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kusaango yiyo, bhaabharimu Abhafarisayo. Neebho, bhakamubhuurira Yeesu, “Omweegya, obhatumanie abhaanabheega bhaazo bhatagaamba gayo!” ");
INSERT INTO zak_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yeesu akabhuga, “Ndabhabhuurira kubha, eraabhe bhano bharaakire, eheene amagina garatiirya eriiraka!” ");
INSERT INTO zak_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hano Yeesu yiisukiri omugye gwa Yerusaremu no okugurora, akataanga okuguririra. ");
INSERT INTO zak_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Akabhuga, “Niingeendiri reero yino kubha omenye enzira yo okureeta omureembe! Nawe bhoono otakunagya kumenya. ");
INSERT INTO zak_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kuziisiku zino zikuuza, abhabhisa bhaazo bharakwiinarirya enyiki kongʼu yo okukurwaania kurwa eziimbaara zoosi. ");
INSERT INTO zak_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kubhuteero, bharakusikya haasi awe na abhaatu bhaazo bhoosi. Ritariho eriigina rino riraasage iguru ye eriindi, kwo okubha hano Taatabhugya akakureetera obhutuurya, otaabhumenyeekereerye.” ");
INSERT INTO zak_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kyaamwe, Yeesu akasikira mwiigoobhe rye eriiseengerero rya Taatabhugya, akabhabhona abhaatu bhano bhaari bhakugurya ebhigiro, akabhaheebha muyo. ");
INSERT INTO zak_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Akabhabhuurira, “Ekaamirwe mumakaamo ga Taatabhugya, ‘Enyuumba yaane erabha enyuumba ya amasabhi.’ Nawe emwe, muyikoriri kubha eriibhigi rya abhateesya.” ");
INSERT INTO zak_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Eziisiku zyoosi, Yeesu ahaabha areegya abhaatu mwiiseengerero. Abhakuru bha abhaseengeri hamwe na abheegya bhe emigiro na abhakaruka bha Abhayahudi, bhaari bharakomya enzira yo okumwiita. ");
INSERT INTO zak_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nawe bhataabhweeni omweeya kwo okubha abhaatu bhoosi bhaari bhariitegeerera amangʼana gaaye kwo obhwiitegeereri bhwaaru. ");
INSERT INTO zak_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Orusiku rumwe Yeesu ahaabha mwiiseengerero rya Taatabhugya, areegya abhaatu na kubharwaazira Amangʼana Amazomu ga Taatabhugya. Niho abhakuru bha abhaseengeri, abheegya bhe emigiro na abhakaruka bha Abhayahudi bhakamuuzaku, ");
INSERT INTO zak_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bhakamubhuurya, “Garya okoriri, oragakora kwo obhuturoki? Ni weewi akuheeri obhuturo bhuyo?” ");
INSERT INTO zak_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yeesu akabhakyoora, “Na neenye ndabhabhuurya eriingʼana rimwe. Mumbuurire, ");
INSERT INTO zak_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","obhuturo bhwa Yohana bhwo okubatiiza abhaatu bhukarwa ku Taatabhugya wuno ari mwiisaaro kasi kubhaatu?” ");
INSERT INTO zak_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Hayo, bhaari bhariibhuurya abheene bharabhuga, “Turaabhuge, bhukarwa mwiisaaro, aratubhuurya, ‘Ambe! Ndora mutaamwiikiriirye?’ ");
INSERT INTO zak_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na turaamukyoore kubha obhuturo bhwaaye bhurwiiri kubhaatu, ambe abhaatu bhoosi bharatutema amagina, kwo okubha bhariikirirya kubha Yohana yaari omurooti.” ");
INSERT INTO zak_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kweego, bhakamubhuurira, “Tutamenyiri obhuturo bhwaaye bhukarweera hayi.” ");
INSERT INTO zak_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yeesu akabhabhuurira, “Na neenye nitakubhabhuurira ni kwo obhuturoki ndakora gano.” ");
INSERT INTO zak_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Niho, Yeesu akabhabhuurira abhaatu ekireengyo kino. Akabhuga, “Yaari ariho omuutu wumwe, akeemya emizabibu mumuguundu gwaaye, akabhasagarya abharimi bhaguriibhe. Ewe, akagya orugeendo, akamara eyo eziisiku nzaru. ");
INSERT INTO zak_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eriibhaga ryo okugesa eziizabibu hano ryahikiri, akamutuma owumwe wa abhagya kubharimi bhaaye bharya, okubha bhamuhe esoondo yaaye ye eziizabibu okurwa mumuguundu gwaaye. Nawe, hano omugya yahikiri, abharimi bhayo bhakamutema, bhakamuheebha mabhoko bhusa. ");
INSERT INTO zak_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Mweene muguundu, akamutuma omugya owuundi. Nawe woosi bhakamutema no okumukorera obhubhi bhukongʼu, kyaamwe bhakamuheebha mabhoko bhusa. ");
INSERT INTO zak_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akamutuma omugya wa katatu. Wuyo woosi bhakamunyahaara, bhakamuheebha. ");
INSERT INTO zak_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mubhuteero, mweene muguundu akabhuga, ‘Bhoono, nikorebhwi? Orugeendo runo, ndamutuma omwaana waane omuseegwa! Hamwe bharamusuuka ewe.’ ");
INSERT INTO zak_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nawe, hano abharimi bhaamuruuzi, bhakagaambana, ‘Wuno niwe omugabhi we ebhigiro bhya wiise. Tumwiite, engabho yaaye ebhe eyeetu.’ ");
INSERT INTO zak_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kimwe, bhakamuruusya mumuguundu, bhakamwiita.” Niho Yeesu akabhabhuurya, “Bhoono, mweene muguundu wuyo arabhakorabhwi abharimi bhayo? ");
INSERT INTO zak_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Araaze no okubhiita, no omuguundu guyo, arabhasagarya abhaandi!” Hano abhaatu bhakiigwa amangʼana gayo, bhakabhuga, “Gayo gatatuuka kweeki!” ");
INSERT INTO zak_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yeesu akabhamogorera, akabhabhuurya, “Bhoono mbe! Amakaamo gano gano obhugazuroki? ‘Eriigina rino abhoomboki bhaaryaangiri, niryo ribheeri eriigina eriikuru ryo obhurusa.’ ");
INSERT INTO zak_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ambe, omuutu wowoosi wuno akubha agweereeri eriigina riyo, arabhunika. Kweeki, omuutu wuno eriigina riyo riraamugweere, riramubhoondora bhukongʼu.” ");
INSERT INTO zak_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abheegya bhe emigiro bhayo na abhakuru bha abhaseengeri, bhakamenya kubha ekireengyo kino ni kwiiguru waabhu. Kweego bhakeenda kumumamira hayohayo, nawe bhakoobhoha esaango ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kweego abhakuru bha Abhayahudi, bhaari bharamwiisuunza Yeesu bhukongʼu, bhakatuma abhazuzuumi. Abhazuzuumi bhayo, bhakiikora kubha ni bhaatu bhe eheene. Nawe, bhaari ne ekeembo yo okumutega Yeesu kumangʼana gaaye, bhamugwaate no okumuhira kumwaanaangwa we Ekirooma, okubha azoongeerwe. ");
INSERT INTO zak_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kweego, abhazuzuumi bhakamubhuurya, “Ee Omweegya, tumenyiri kubha engʼana yino okugaamba no okweegya ni nzomu. Awe otakwaahura naabhe obhukuru bhwo omuutu, nawe oreegya enzira ya Taatabhugya kwo obhuheene. ");
INSERT INTO zak_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Awee! Emigiro gya Musa giriikirirya, tumurihe Kaisari eriigooti, kasi tutamuriha?” ");
INSERT INTO zak_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Rugeendo rumwe Yeesu akamenya omukoonyo gwaabhu, akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Munierekye orubhirya rwe edinaari. Epicha yino ne eriina rino, ni bhya weewi?” Bhakamubhuurira, “Ni bhya Kaisari.” ");
INSERT INTO zak_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yeesu akabhabhuurira, “Ambe, bhya Kaisari, muhaane Kaisari. Na bhya Taatabhugya, muhaane Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eriikyooro riyo rya Yeesu, rikabharuguurya bhukongʼu, bhakakira. Bhakatamwa okumutega kumangʼana gano akabhuga embere ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kweego Abhasadukayo abhaandi bhakaaza ku Yeesu. Abhasadukayo bhaheegya kubha, abhaku bhatakuryooka kweeki. Bhakamubhuurya Yeesu, ");
INSERT INTO zak_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Omweegya, Musa akatukaamira kubha, ‘Eraabhe omuutu akuuri na atigiri omukaaye akyaari kwiibhura, wamwaabhu amugabhe omutuumba wuyo, okubha amwiibhurire wamwaabhu omwaana.’ ");
INSERT INTO zak_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tubhuge, bhaari bhariho abhahiiri muhuungati. Wo okutaanga akakweera omukari, akakwa akyaari kutiga omwaana. ");
INSERT INTO zak_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Omusuuhu waaye wuyo wa kabhiri, akamugabha omutuumba wuyo, woosi akakwa. ");
INSERT INTO zak_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ekabha egoego ku wa katatu, woosi akamukweera, akakwa. Ekabha egoego kubhoosi muhuungati, bhakakweera omukari wuyowuyo, bhakakwa bhataatigiri mwaana. ");
INSERT INTO zak_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mubhuteero, omutuumba wuyo woosi akakwa. ");
INSERT INTO zak_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ambe otubhuurire, eraabhe obhuryoori bhurabhaho, omutuumba wuyo arabha omukari wawi? Bhoosi muhuungati bharya bhakamukweera no okumugabha.” ");
INSERT INTO zak_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yeesu akabhabhuurira, “Abhaatu bhe eriibhaga rino bhano bhakukweera no okukweerwa. ");
INSERT INTO zak_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nawe, bhano Taatabhugya abharuuzi bhareenderwa okuryoorwa mubhaku no okwiikara kukyaaro ekihya, bhayo bhatakukweera naabhe kukweerwa kweeki. ");
INSERT INTO zak_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na bhatakukwa kweeki, kwo okubha bharabha kya bhamaraika. Bharabha abhaana bha Taatabhugya, kwo okubha bhararyoorwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Naabhe Musa akazweenia abhaatu kubha abhaku bhararyoorwa. Mumakaamo gano akakaama iguru ye ekisaka kirya kino kyaari kwaaka omuriro, akabhuga Omukuru niwe ‘Taatabhugya wa Aburahamu, Isaaka na Yaakobo.’ ");
INSERT INTO zak_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kweego, yiingabha abhatatu bhayo bhaari bhakuuri eziisiku nzaru, Taatabhugya akabhuga bhayo ni bhahoru kweewe! Kweego, abhaatu abhaku na abhahoru, bhoosi ni bhahoru mumeeso gaaye.” ");
INSERT INTO zak_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Niho, abheegya bhe emigiro abhaandi bhakabhuga, “Omweegya, ogaambiri bhuzomu!” ");
INSERT INTO zak_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Okutaanga eriibhaga riyo, bhaari bharoobhoha kumubhuurya Yeesu amabhuuryo agaandi. ");
INSERT INTO zak_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nawe, Yeesu akabhabhuurya abheegya bhayo, “Kwaki abhaatu bharabhuga kubha, Masiya ni mwaana wo omutemi Daudi? ");
INSERT INTO zak_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daudi omweene, mukitabhu kya Zaburi, akabhuga, ‘Omukuru, Taatabhugya akamubhuurira Omukuru waane, “Wiikare orubhaara rwaane rwo obhuryo, ");
INSERT INTO zak_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tee hano nikutuura abhabhisa bhaazo iyaasi wa amaguru gaazo.” ’ ");
INSERT INTO zak_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Eraabhe Daudi aramubhirikira Masiya, ‘Omukuru,’ bhoono erabhabhwi Masiya abhe kweeki omwaana waaye?” ");
INSERT INTO zak_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hano abhaatu bhe esaango bhaari bharamwiitegeerera, Yeesu akabhabhuurira abhaanabheega bhaaye, ");
INSERT INTO zak_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mwiiriihe na abheegya bhe emigiro gya Musa. Bhano bhakuseega kugeenda kunzira bhiibhohiri emyeenda gyaabhu emitaambi, no okukeeribhwa kwo obhusuuku mumiteera. Kweeki, muziinyuumba zye eziisaango, bharaseega kwiikara kubhituumbi bhye embere. Ne eraabhe bhabharaarikiri muziinyaangi, bharaseega kwiikara hano abhagini bho obhusuuku bhakwiikara. ");
INSERT INTO zak_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bharabhateesya abhatuumba eziinyuumba zyaabhu. Na bhariiyeerekya kubhaatu kwo okusabha amasabhi mataambi bhukongʼu embere wa abhaatu. Murusiku rwo okutina ekiina, abhaatu bhayo bharabhona obhutemwa bhukuru okurwa ku Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Eriibhaga rino Yeesu yaari mwiiseengerero, akabharora abhaniibhi bharatuura ebhimweeso bhyaabhu muhuunguro ye ekimweeso. ");
INSERT INTO zak_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Akamurora kweeki omutuumba owumwe omutaka arateemu amazeenzere abhiri ego. ");
INSERT INTO zak_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Niho Yeesu akabhuga, “Ndabhabhuurira ge eheene kubha, omutuumba omutaka wuyo, atuuriri eziimbirya nzaru muhuunguro kukira bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bhoosi bhano bhatuuriri ebhimweeso bhisuuhu ego kubhyaaru bhye ebhigiro bhyaabhu. Nawe omutuumba wuno ni mutaka bhukongʼu, neewe atuuriri bhyoosi bhino yaari kwiisigira mubhwiikari bhwaaye.” ");
INSERT INTO zak_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abhaanabheega abhaandi, bhaari bharakeerenerya eriiseengerero, kyeego ekangʼatibhwa kwa amagina amazomu, hamwe ne ebhigiro bhyo obhuguri bhino abhaatu bhaamuruusiirye Taatabhugya. Nawe Yeesu akabhuga, ");
INSERT INTO zak_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gayo goosi gano mukugarora, ziraaza eziisiku zino ritariho eriigina rino riraatame iguru we eriindi, goosi garagwiisibhwa!” ");
INSERT INTO zak_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abhaanabheega bhayo bhakamubhuurya, “Omweegya, amangʼana gayo ni ryoori garaatuuke? Ne ekyeerekenioki kireerekye kubha, gayo gari haguhi kutuukira?” ");
INSERT INTO zak_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Akabhabhuurira, “Mwiiriihe, omuutu wowoosi ataaza kubhangʼeena! Abhaatu bhaaru bharaaza bhakuhokeerya eriina ryaane, bharabhuga, ‘Enye neenye Masiya.’ Kweeki bharabhuga, ‘Eriibhaga ryo obhuteero, rihikiri!’ Abhaatu bhayo, bharangʼeena abhaatu bhaaru. ");
INSERT INTO zak_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na hano mukwiigwa amangʼana ge eriihi, ne ebhitiika bhya abhabhisa, mutoobhoha. Gareenderwa gayo goosi, gatuuke hiinga, nawe obhuteero bhwa goosi, bhukyaari.” ");
INSERT INTO zak_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yeesu akagaamba, “Ekyaaro kimwe kirarwaana ne ekiindi, no obhutemi obhumwe bhurarwaana no obhutemi obhuundi. ");
INSERT INTO zak_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Harabhaho ebhirigito ebhikuru bhye esi, na ahagiro ahaandi harabha ne enzara ehaari, na amarweeri amabhi bhukongʼu. Na kiraaza ekyeerekenio ekikuru kurwa mwiisaaro, na abhaatu bhararora ebhisigo bhyo okubhobhohya bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nawe, hano gayo goosi gakyaari kutuuka, abhaatu bharabhagwaata emwe no okubhahira muziinyuumba zye eziisaango, no okubhabhoha munyuumba ya abhabhohwa, bharabhanyaakya. Na murahirwa embere ya abhatemi na abhaanaangwa, kwo okubha emwe ni abhaanabheega bhaane. ");
INSERT INTO zak_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Niigo ego muraabhone omweeya gwo okunigaambira. ");
INSERT INTO zak_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Kweego, mwaamure muziikoro zyeenyu, okubha mutige okunyaaka murakyoorabhwi hano ekiina kyeenyu kikubha kikyaari okugaambwa. ");
INSERT INTO zak_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Enye omweene, ndabhaha amangʼeeni na amangʼana gano muraagaambe, tee abhabhisa bheenyu bhatakunagya kwaanga naabhe okubhahakania. ");
INSERT INTO zak_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Eriibhaga riyo ryo okuruusibhwa kwa abhakaangati, murariibhwa omukoonyo na abhiibhuri bheenyu, abhahiiri bheenyu, abhaatu bho orugaanda rweenyu, na abhasaani bheenyu. Bharakora abhaandi bheenyu bhariitwa. ");
INSERT INTO zak_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Abhaatu bhoosi bharabhabhiihirirya kwe ekigirye kyo okubha emwe ni bhaanabheega bhaane. ");
INSERT INTO zak_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nawe, rutakubhura naabhe oruzweeri orumwe kumitwe gyeenyu! ");
INSERT INTO zak_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","No omuutu wowoosi wuno araagumire tee obhuteero niwe araatuuribhwe. ");
INSERT INTO zak_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Hano muraarore kubha omugye gwa Yerusaremu gwiinaarirwe na abhasirikare bhe eriihi, niho muraamenye kubha eriibhaga ryo obhusarya rihikiri. ");
INSERT INTO zak_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eriibhaga riyo, bhano bhakwiikara mukyaaro kya Yudea, bhangʼosere mubhiguru, na bhano bhakubha mumugye gwa Yerusaremu, bharwemu bhwaangu, na bhano bhakubha mumiguundu, bhatakyoora mumugye muyo. ");
INSERT INTO zak_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bhararyaara, kwo okubha eziisiku ziyo ni siku zye enyaako, okubha amangʼana goosi gano gakaamirwe gakuunaane ");
INSERT INTO zak_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Turabharorera ebhigoongi, abhakari bhano bharitohiri na bhano bhakukookya muziisiku ziyo! Erabha bhubhi, kwo okubha, mukyaaro muyo, harabha ne enyaako ehaari bhukongʼu, kweeki obhutemwa okurwa ku Taatabhugya bhuraaza kubhaatu. ");
INSERT INTO zak_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abhaatu abhaandi, bhariitwa kwa nyaambato, na abhaandi, bharagwaatwa no okubha abhabhohwa no okuhirwa mubhyaaro ebhiindi bhyoosi. No omugye gwa Yerusaremu ogweene, guratazwa na abhaatu bhe ebhyaaro ebhiindi bhano bhatari Abhayahudi, tee eziisiku zyaabhu zisire. ");
INSERT INTO zak_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Erabha ekyeerekenio kuryoobha, omweeri ne eziinzota. Na mukyaaro hano, eziinyaanza zirabha na amabhooka maaru, ziraruma, na kuteemo yiyo, abhaatu bhe ebhyaaro bharabha ne ehaha ne enyaako. ");
INSERT INTO zak_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Gayo goosi, hano gakuuza kukyaaro, abhaatu bharoobhoha bhukongʼu. Bharakwa eziikoro kwo okukaangwa, bharaganya okubhonwa na amangʼana amabhi mukyaaro, kwo okubha Taatabhugya arabhisiingisya ebhigiro bhyoosi bhya mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Niho, abhaatu bhoosi bharaandore Omwaana wo Omuutu, nikuuza mumasaaro kwo obhuturo bhwaaru no obhuguungo. ");
INSERT INTO zak_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gayo goosi, hano garaataange okukorwa, mwiimeerere tiri, kwo okubha eriibhaga ryo okutuuribhwa kweenyu, riri haguhi!” ");
INSERT INTO zak_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kweeki, Yeesu akabhabhuurira abhaanabheega bhaaye ekireengyo, arabhuga, “Mwiiseege omuti gwo omutiini, ne emiti egiindi gyoosi. ");
INSERT INTO zak_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hano muraarore gitaangiri okusibhuka amatu, hayohayo muramenya kubha eriibhaga rya amaahu riisukiri. ");
INSERT INTO zak_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","“Egoego na neemwe, hano muraarore gayo gataangiri kukorwa, niho muraamenye kubha obhutemi bhwa Taatabhugya bhwiisukiri. ");
INSERT INTO zak_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ndabhabhuurira obhuheene, orwiibhuro runo rutakuhita, tee gano goosi garaamarwe kukorwa. ");
INSERT INTO zak_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Eriisaaro ne ekyaaro bhirahweerera, nawe amangʼana gaane gatakuhweerera na rumwe! ");
INSERT INTO zak_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mwiiriihe, mutaaza kuhizwa na amangʼana amabhi ne ebhigiro bhye ekyaaro, no obhunywi, ne ehaha yo obhwiikari. Eraabhe mutiiriihiri, orusiku rwo obhuteero rurabha kituukiro no okubhakaanga. ");
INSERT INTO zak_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Orusiku ruyo, rurabha kituukiro mukyaaro kyoosi. ");
INSERT INTO zak_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kweego, mubhe meeso eriibhaga ryoosi! Mugeenderere kumusabha Taatabhugya, okubha mutuuribhwe mugoosi gano garaatuuke, no okwiimeerera embere ya Omwaana wo Omuutu.” ");
INSERT INTO zak_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kuziisiku ziyo, mumwiisi Yeesu ahaabha areegya abhaatu mwiigoobhe rye eriiseengerero, nawe obhutiku ahaabha aragya mukiguru kino kikubhirikirwa Ekiguru kye Emizeituni. ");
INSERT INTO zak_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eziisiku zyoosi, abhaatu bhoosi bhahaabhuuka etabhoori zuri, no okwiikumanirya mwiiseengerero bhamwiitegeerere. ");
INSERT INTO zak_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yaari yiisukiri, Enyaangi ye Emikaate Gino Gitana Ekibhwiisya, yino ekabhirikirwa Enyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Abhakuru bha abhaseengeri, hamwe na abheegya bhe emigiro gya Musa, bhaari bharamoohya enzira yo okumwiita Yeesu, nawe bhaari bharoobhoha abhaatu. ");
INSERT INTO zak_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Niho, Seetaani akamusikira Yuuda, wuno ahaabhirikirwa Isikariyoti, owumwe wa abhaanabheega bha Yeesu ikumi na bhabhiri. ");
INSERT INTO zak_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kyaamwe, Yuuda akagya kubhakuru bha abhaseengeri na kubhakuru bha abhariibhi bhe eriiseengerero, bhakakeerenia nabho kyeego araamuruusye Yeesu kweebho. ");
INSERT INTO zak_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kumangʼana gayo bhakazomererwa bhukongʼu, bhakiikirirya kumuha eziimbirya. ");
INSERT INTO zak_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuuda akiikirirya, akataanga kumoohya omweeya gwo okumurya omukoonyo Yeesu, kwiibhaga rino abhaatu bhaaru bhatari bhariho. ");
INSERT INTO zak_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Orusiku rwe Enyaangi ye Emikaate Gino Gitana Ekibhwiisya rukahika, eheenderwa engʼoondu ye Enyaangi yo Okuhiita egwaagwe. ");
INSERT INTO zak_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Niho, Yeesu akabhatuma Petero na Yohana, akabhabhuurira, “Mugye mutubhanurire ebhyaakurya bhye Enyaangi yo Okuhiita tuuze turye hamwe.” ");
INSERT INTO zak_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhakamubhuurya, “Oreenda tubhibhanurire hayi?” ");
INSERT INTO zak_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akabhakyoora, “Mugeende mumugye. Muraasikane no omusubhe wumwe wuno agegiri eseengo ya amaanzi, mumutuniirire eno akugya. ");
INSERT INTO zak_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Munyuumba yino araasikire, mugye mumubhuurire mweene nyuumba, ‘Omweegya arasabha otweerekye hano araariire ebhyaakurya bhye Enyaangi yo Okuhiita hamwe na abhaanabheega bhaaye.’ ");
INSERT INTO zak_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Niho mweene nyuumba araabheerekye ekyuumba ekikuru mukinazo, kimariri kubhanurwa. Mutubhanurire muyo, turiire ebhyaakurya bhye Enyaangi yo Okuhiita.” ");
INSERT INTO zak_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Abhaanabheega bhabhiri bhayo, hano bhakiigwa gayo, bhakarwa hayo, bhakagya. Bhakabhona goosi kyeego Yeesu yabhabhuuriiri, bhakabhanura ebhyaakurya bhye Enyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hano eriibhaga ryo okurya ryahikiri, Yeesu akiikara kubhyaakurya hamwe na abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Akabhabhuurira, “Bhoono niigoombiri bhukongʼu okurya ebhyaakurya bhye Enyaangi yo Okuhiita hamwe neemwe nikyaari kunyaakibhwa. ");
INSERT INTO zak_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ndabhabhuurira kubha, nitakurya kweeki ebhyaakurya bhino, tee obhugazuro bhwe Enyaangi yo Okuhiita bhurakuunaanibhwe, no okweerekenia mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kyaamwe Yeesu akagega ekikoombe kya amaanzi go omuzabibu, akabhuga, “Ozomirye, Taatabhugya.” Niho akabhaha abhaanabheega bhaaye, arabhuga, “Mugege ekikoombe kino, munywe. ");
INSERT INTO zak_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ndabhabhuurira kubha nitakunywa kweeki amaanzi go omuzabibu, tee obhutemi bhwa Taatabhugya bhuuze.” ");
INSERT INTO zak_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yeesu akagega omukaate, akabhuga, “Ozomirye, Taatabhugya.” Akagubhega, akabhaha abhaanabheega bhaaye, arabhabhuurira, “Murye, guno nigwo omubhiri gwaane, na guraruusibhwa kwiiguru yeenyu. Mubhe murakora ego, kwo okunihiita enye.” ");
INSERT INTO zak_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na hano bhaamariri kurya ebhyaakurya bhye engoroobha, Yeesu akagega amaanzi go omuzabibu gayo, akabhuga, “Amaanzi go omuzabibu gano gariimeererera eriiragano eriihya rino Taatabhugya akukora, kuhitira amanyiinga gaane. ");
INSERT INTO zak_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nawe murore! Owumwe weenyu aranirya omukoonyo, na wuno akunirya omukoonyo tunawe mwiigari hano. ");
INSERT INTO zak_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Enye Omwaana wo Omuutu, ndagya kwiitwa, kyeego Taatabhugya ahaabha yeendiri. Nawe, araaza kurora omuutu wuno araanirye omukoonyo enye Omwaana wo Omuutu.” ");
INSERT INTO zak_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Niho, abhaanabheega bha Yeesu bhakataanga kwiibhuurya, “Ni weewi gati weetu araakore gayo?” ");
INSERT INTO zak_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Niho kweeki, eriiyoge rikarweera gati wa abhaanabheega bha Yeesu, kubha ni weewi gati yaabhu araabhe omukuru kukira abhaandi. ");
INSERT INTO zak_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yeesu akabhabhuurira, “Abhatemi bha abhaatu bhano bhatari Abhayahudi, bharabhaaha kwa amanaga, no okwiikumya kubha ni bhahaani. ");
INSERT INTO zak_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Nawe etakubha ego kweemwe, wuno akubha omukuru gati weenyu, abhe kyo omusuuhu. Na wuno akubha omukaangati, abhe kyo omubhagati wa abhaandi. ");
INSERT INTO zak_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kweego! Ni weewi omukuru wo okubhakira? Ni wurya akwiikara kubhyaakurya, kasi ni wuno akuhokya ebhyaakurya? Atari wurya akwiikara kubhyaakurya? Kweego, enye neenye niri gati yeenyu kyo omuhokya. ");
INSERT INTO zak_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Neemwe abheene ego, mukiikara no okusaaga neenye, hano niari munyaako. ");
INSERT INTO zak_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kweego, ndabhatuurira obhunagya bhwo obhutemi, kyaabhurya Taata waane yantuuriri enye. ");
INSERT INTO zak_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ndabhaha obhuturo bhuyo kwo okwiikara hamwe na neenye mubhe murarya no okunywa hamwe mubhutemi bhwaane. Muriikara kubhituumbi bhyo obhutemi ikumi na bhibhiri eno murabhaaha ebhisyooko ikumi na bhibhiri bhya Iziraeri.” ");
INSERT INTO zak_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yeesu akabhuga, “Simooni, Simooni! Rora, Seetaani arabhasakya emwe kyo omuseesi wo okuseesa engano. ");
INSERT INTO zak_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nawe, nikusabhiiri ku Taatabhugya, obhwiikirirya bhwaazo bhutasuuha. Naawe hano oraakyoore, osakirye abharikyaazo.” ");
INSERT INTO zak_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simooni akamukyoora, “Ee Omukuru, enye nibheeri wo okugya kubhohwa hamwe naawe mukibhoho, naabhe kwiitwa, enye noosi ndiitwa!” ");
INSERT INTO zak_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yeesu akamukyoora, “Ee Petero, ndakubhuurira kubha reero ekorokoome ekyaari kugaamba, orabha omariri kunianga katatu koosi kwo okwiikora otanimenyiri.” ");
INSERT INTO zak_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kyaamwe, Yeesu akabhuurya abhaanabheega bhaaye, “Hano niabhatumiri mutaari ne ekiguzi kye eziimbirya, mutaari ne esakwa, mutaari ne ebhikweera, mukasuuhirwa na kigiro?” Bhakamukyoora, “Zeyi.” ");
INSERT INTO zak_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yeesu akabhabhuurira, “Kweema bhoono, eraabhe omuutu ane ekiguzi kye eziimbirya na ane esakwa, agege. Na wuno atana nyaambato, agurye ekabhuuti yaaye, agure nyaambato yimwe. ");
INSERT INTO zak_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mukore ego, kwo okubha amangʼana gano gakaamirwe na abharooti iguru waane, gari haguhi kubha no obhuteero bhwaaye. Kweego ekaamirwe, ‘Akabharwa hamwe na abhatemya bhe ebhibhi.’ Ndabhabhuurira kubha, ereenderwa gayo gakorwe kweenye.” ");
INSERT INTO zak_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nabho bhakamubhuurira, “Ee Omukuru, rora! Hano ziriho eziinyaambato ibhiri.” Neewe akabhuga, “Gano giisiri.” ");
INSERT INTO zak_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Niho Yeesu akarwa hayo, akagya kukiguru kino kyaari kubhirikirwa Ekiguru kye Emizeituni, kyeego yaari teemo yaaye na abhaanabheega bhaaye nabho bhakabha bharamutuniirira. ");
INSERT INTO zak_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na hano yahikiri kukiguru kiyo, akabhabhuurira, “Musabhe Taatabhugya okubha mutaaza kusakibhwa.” ");
INSERT INTO zak_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Niho, akiibheza akiisuka embere hasuuhu, obhweema bhwo okutaasa eriigina, akatema haasi ebhiru, akasabha, ");
INSERT INTO zak_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ee Taata, eraabhe ni bhuseegi bhwaazo, ndakusabha onduusiryeho eziinyaako zino. Nawe etabha kyeego enye nikweenda, nawe kyeego awe okweenda.”  ");
INSERT INTO zak_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Niho, maraika kurwa mwiisaaro akamuhwaarukira Yeesu, akamuha amanaga. ");
INSERT INTO zak_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yeesu akabha no obhururu bhuhaari bhukongʼu, bhukamukora yoongere kusabha. Ekigeri kyaaye kyatuubheeni na amanyiinga, kikabha kiratonya haasi toi, toi. ");
INSERT INTO zak_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na hano yamariri kusabha, akiimeerera, akabhakyoorera abhaanabheega bhaaye, akabhabhona bhahiindiiri kwo okubha bhaari bharosiri kwe ebhigoongi. ");
INSERT INTO zak_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Akabhabhuurya, “Kwaki muhiindiiri? Mubhuuke! Musabhe Taatabhugya, okubha mutaaza kusakibhwa.” ");
INSERT INTO zak_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hano Yeesu yaari akyagaamba gayo, akiizirwa na abhaatu bhaaru. Abhaatu bhayo, bhakakaangatibhwa na Yuuda, owumwe wa abhaanabheega bhaaye ikumi na bhabhiri. Niho, Yuuda akamwiisukira Yeesu, amukeerye kwo okumuhuumbata. ");
INSERT INTO zak_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yeesu akamubhuurya, “Yuuda, heene oranikeerya kwo okunihuumbata kyo omusaani, eno oranikorera omukoonyo kwo okuniruusya enye Omwaana wo Omuutu?” ");
INSERT INTO zak_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hano abhaanabheega bha Yeesu bhayo bhaaruuzi kyeego eraabhe, bhakamubhuurya, “Ee Omukuru! Tubhangʼerengʼere kwa nyaambato?” ");
INSERT INTO zak_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Niho, owumwe wa abhaanabheega akamutema no okumutina okutwi kwo obhuryo omugya wo omuseengeri omukuru. ");
INSERT INTO zak_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yeesu akabhuga, “Mutige! Giisiri.” Akagwaata okutwi kwo omugya wuyo, akamuhorya. ");
INSERT INTO zak_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yeesu akabhabhuurya abhakuru bha abhaseengeri, abhakuru bha abhariibhi bha mwiiseengerero, hamwe na abhakaruka bha Abhayahudi bhano bhakaaza kumugwaata, “Mbe, mwiiziri ne eziinyaambato ne eziinduguzo okunigwaata kyo omuteesya? ");
INSERT INTO zak_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eziisiku zyoosi niari hamwe neemwe, ndeegya mwiiseengerero rya Taatabhugya, na mutaangwaatiri. Nawe bhoono, eriibhaga rino ni ryeenyu na ryo obhukaangati bhwa Seetaani.” ");
INSERT INTO zak_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Abhaatu bhayo bhakamugwaata Yeesu, bhakamuhira tee munyuumba yo omuseengeri omukuru. Petero akabha aramutuniirira kwa kure. ");
INSERT INTO zak_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hano bhaahikiri gatigati yo omugye, omuriro gukahuutwa, bhakiikara. Na Petero woosi akaaza kwiikara gati yaabhu. ");
INSERT INTO zak_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","No obhweero bhwo omuriro guyo bhukamumurika, no omuhokya wumwe omuukya, akamurora kwo okumumogorera akabhuga, “Omuutu wuno, ahaabha hamwe neewe.” ");
INSERT INTO zak_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nawe Petero akaanga, akabhuga, “Omukari wuno! Nitamumenyiri.” ");
INSERT INTO zak_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kwiibhaga isuuhu ego, omuutu owuundi akamurora Petero akamubhuurira, “Awe ni wumwe waabhu.” Kyaamwe Petero akamukyoora, “Awe mura! Ntari enye.” ");
INSERT INTO zak_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Niho eriibhaga irebhe rikahita, omuutu owuundi akamukumiirirya, “Kwe eheene, omuutu wuno ahaabha hamwe nawe, ewe woosi ni Mugariraaya!” ");
INSERT INTO zak_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kyaamwe Petero akabhuga, “Mura, nitagamenyiri gayo okugaamba!” Hano yaari akyagaamba gayo, niho ekorokoome ekagaamba. ");
INSERT INTO zak_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hayo hayo Omukuru Yeesu akamwiikibhukira, akamutaangaarira Petero. Petero akagahiita amangʼana garya Yeesu yaari amubhuuriiri, “Reero, ekorokoome ekyaari kugaamba, orabha omariri kunianga katatu koosi.” ");
INSERT INTO zak_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kyaamwe akahuruka igutu, akabha ararira kwo obhururu bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kyaamwe abhasubhe bharya bhaari bharamugwaata Yeesu, bhakabha bharamuzibhura, no okumutema bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhakamukuundikirya mumeeso, bharamubhuurya, “Ruusya obhurooti! Ni weewi wuno akutemiri?” ");
INSERT INTO zak_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bhakageenderera kumuruusirya amangʼana maaru ga amatuki. ");
INSERT INTO zak_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hano kwakiiri, abhakaruka bha Abhayahudi, abhakuru bha abhaseengeri na abheegya bhe emigiro bhakakora ekiina. Yeesu akareetwa embere yaabhu, bhakamubhuurya, ");
INSERT INTO zak_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Eraabhe awe naawe Masiya, otubhuurire.” Yeesu akabhakyoora, “Naangabhabhuurira, mutakwiikirirya. ");
INSERT INTO zak_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Naangabhabhuurya eriibhuuryo, mutakunikyoora. ");
INSERT INTO zak_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kweemera bhoono, muraandora enye Omwaana wo Omuutu, ndabha niikeeri orubhaara rwo obhuryo rwa Taatabhugya wa amanaga.” ");
INSERT INTO zak_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bhoosi bhakamubhuurya Yeesu, “Heene awe ni Mwaana wa Taatabhugya?” Yeesu akabhakyoora, “Ndora abheene mugaambiri kubha enye niwe.” ");
INSERT INTO zak_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Niho abhakuru bhayo bhakabhuga, “Bhoono tutakweenda obhumenyeekererya obhuundi, kwo okubha etwe twoosi twiigwiiri engʼana yino!” ");
INSERT INTO zak_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kyaamwe, abhakuru bhoosi bha Abhayahudi bhakiimeerera, bhakamuhira Yeesu ku Pirato. ");
INSERT INTO zak_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhakataanga okumuzoongera kwo obhuhaari, bhakabhuga, “Omuutu wuno, tumubhweeni arabhatubhuuzikania abhaatu bhe ekyaaro kyeetu kwo okubha, arabharekya abhaatu kubha bhatariha eriigooti kweeki ku Kaisari. Na arabhuga kubha ewe niwe Masiya, omutemi.” ");
INSERT INTO zak_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Niho, Pirato akamubhuurya Yeesu, “Awe naawe omutemi wa Abhayahudi?” Yeesu akamukyoora, “Naawe ogaambiri.” ");
INSERT INTO zak_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Niho kweeki, Pirato akabhabhuurira abhakuru bha abhaseengeri bhayo, hamwe ne eriihizo rya abhaatu, “Omuutu wuno, niruuzi atana isarya riyo ryoosi rirya.” ");
INSERT INTO zak_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Abhaatu bhayo, bhakagaamba kwo okukumiirirya, “Ndora arasiigirirya abhaatu bha mukyaaro kyoosi kya Yudea. Akataanga okweegya eyo Gariraaya, na akanyaragania tee hano.” ");
INSERT INTO zak_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hano Pirato akiigwa gayo, akabhuurya, “Omuutu wuno ni Mugariraaya?” ");
INSERT INTO zak_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na hano yamenyiri kubha ewe ni Mugariraaya wa mubhukaangati bhwa Herode, akamutuma kweewe, kwo okubha eziisiku ziyo, Herode ahaabha Yerusaremu hayo. ");
INSERT INTO zak_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Niigo Herode akarora Yeesu, akazomererwa bhukongʼu, kwo okubha aheenda amurore kuziisiku nzaru. Omweene yaari yiigwiiri amangʼana gaaye, akeenda kurora Yeesu akukora ekitiika. ");
INSERT INTO zak_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herode akamubhuurya Yeesu kwa amabhuuryo maaru, nawe Yeesu ataamukyooriri ngʼana. ");
INSERT INTO zak_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abhakuru bha abhaseengeri na abheegya bhe emigiro, bhakahita embere bhakataanga kuzoongera Yeesu kwo obhuhaari. ");
INSERT INTO zak_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herode na abhasirikare bhaaye bhakataanga kumuzibhura, bhakamuseka, bhakamwiibhohya emyeenda emizomu. Kyaamwe bhakamukyoorya ku Pirato. ");
INSERT INTO zak_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na kweema orusiku ruyo, Herode na Pirato bhakiigwaana bhakabha abhasaani, yiingabha ekare hayo bhaari ni bhabhisa. ");
INSERT INTO zak_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kyaamwe, Pirato akabhakumania abhakuru bha abhaseengeri, abhakaangati bha Abhayahudi, hamwe na abhaatu bha mumugye. ");
INSERT INTO zak_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Akabhabhuurira, “Mundeeteeri omuutu wuno murabhuga arasiigirirya abhaatu. Mumenye kubha nimariri kumubhuurya embere weenyu. Na kwa amasemo geenyu goosi, ritariho isarya riyo ryoosi rino niruuzi kweewe. ");
INSERT INTO zak_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nawe Herode woosi, ataaruuzi kino asarirye, nikyo amukyoorirye kweetwe. Mumenyeekereerye kisi kubha, omuutu wuno ataakoriri ngʼana yino eraagirye yiitwe! ");
INSERT INTO zak_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kweego ndabhabhuurira abhasirikare bhamuteme eziityaanya, kumara nimuhaatire.”  ");
INSERT INTO zak_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pirato wuyo, eriibhaga rye Enyaangi yo Okuhiita, yaari ereenderwa abhiigurire omubhohwa wumwe kurwa mukibhoho. ");
INSERT INTO zak_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Abhaatu bhayo bhoosi bhakakora ekituri hamwe bharabhuga, “Oturuusiryeho omuutu wuyo, otwiigurire Baraaba!” ");
INSERT INTO zak_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraaba wuyo, ahaabha abhohirwe mukibhoho, kwo okukora obhwaangi bhuno bhwatuukiri mumugye no obhwiiti. ");
INSERT INTO zak_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pirato akagaambana na abhaatu bhayo rwa kabhiri kweeki, kwo okubha akeenda amuhaatire Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kyaamwe, ebho bhakeenderera kukora ekituri, “Mumubhaambe, mumubhaambe kumusaraba!” ");
INSERT INTO zak_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kweeki akagaambana nabho rwa katatu, “Akoriri isaryaki rino rigirirye abhaambwe kumusaraba? Ndora etariho engʼana yino niruuzi kweewe yino eraagirye yiitwe! Kweego ndabhabhuurira bhamuteme eziityaanya, kumara nimuhaatire.” ");
INSERT INTO zak_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kyaamwe, abhaatu bhayo bhakoongera kutema ekituri bhukongʼu kubha Yeesu yiitwe kumusaraba, ne eriiraka ryaabhu rikakiraho. ");
INSERT INTO zak_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Niho Pirato akiikirirya, abhaatu bhayo bhakore kyeego bhaari bhasabhiri. ");
INSERT INTO zak_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Akabhiigurira omusarya wurya, wuno ahaabha abhohirwe kwo okukora obhuhakani no obhwiiti, akaragania bhamugege Yeesu bhamukorere kyeego bhakweenda. ");
INSERT INTO zak_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hano abhasirikare bhaari bhakumuhira Yeesu kumwiita, bhakasikana no omuutu wumwe, eriina ryaaye Simooni wa mumugye gwa Kirene. Simooni wuyo, yaari arareka mumuguundu. Niho bhakamugwaata kwa nguru, bhakamuseserya omusaraba. Akabha aramurwa Yeesu kwiinyuma. ");
INSERT INTO zak_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Abhaatu bhaaru bhahaamutuniirira Yeesu, gati yaabhu abhakari bhaari bharamuririra kwe ebhigoongi. ");
INSERT INTO zak_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yeesu akabhiikibhukira, akabhabhuurira, “Emwe abhakari bha Yerusaremu, mutaandirira enye! Nawe mwiiririre abheene na abhaana bheenyu. ");
INSERT INTO zak_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mumenye kubha, eziisiku zino zikuuza, abhaatu bharabhuga, hakiriku abhakari abhaguumba na bhano bhatakookirye! ");
INSERT INTO zak_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kyaamwe, bharabhuurira ebhiguru, ‘Mutugweere,’ bharabhuurira ehiguru, ‘Mutukuundikirye.’ ");
INSERT INTO zak_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eraabhe gayo garaakorwe kumuti omubhisi, erabhabhwi kumuti omwoomu?” ");
INSERT INTO zak_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Abhasirikare bhakabhahira Yeesu na abhaatu bhe ebhibhi bhabhiri, keembo bhagye kwiitwa hamwe. ");
INSERT INTO zak_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bhakahika ahagiro hano haabhirikiirwe Ekihaanga kyo Omutwe, niho bhakabhabhaamba Yeesu na abhaatu bhe ebhibhi bhabhiri bhayo kumisaraba, owumwe orubhaara rwaaye rwo obhuryo, no owuundi orubhaara rwo obhumosi. ");
INSERT INTO zak_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yeesu akabhuga, “Ee Taata, obhaabhire, kwo okubha gano bhakukora bhatagamenyiri.” Abhasirikare bhayo bhakatwaana eziingibho zyaaye, na bhakazitemera obhwiitoori. ");
INSERT INTO zak_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Abhaatu bhakiimeerera hayo bhakiisuunza, na abhakaangati bha Abhayahudi, bhakataanga okumuseka Yeesu, bhakabhuga, “Ndora ahaabhatuurya abhaandi, bhoono araabhe niwe Masiya wuno yasorirwe na Taatabhugya, yiituurye omweene.” ");
INSERT INTO zak_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abhasirikare nabho bhakamuzibhura, bhakamwiisukira, okubha bhamuhe amaanzi amaruru go omuzabibu gari musuka. ");
INSERT INTO zak_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bhakamubhuurira, “Eraabhe heene naawe omutemi wa Abhayahudi, wiituurye omweene.” ");
INSERT INTO zak_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na iguru yaaye amakaamo gakatuurwa kurubaawa, gakaamirwe, “Wuno ni Mutemi wa Abhayahudi.” ");
INSERT INTO zak_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kubhakori bhe ebhibhi bhabhiri bhayo, owumwe akamutuka Yeesu arabhuga, “Awe naawe Masiya? Bhoono ituurya omweene, otutuurye na neetwe.” ");
INSERT INTO zak_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kyaamwe, omusarya omurikyaaye akamurekya, akabhuga, “Awe otakumwoobhoha Taatabhugya yiingabha hasuuhu? Ekiina kino tutiniirwe, nikyo woosi araatinirwe. ");
INSERT INTO zak_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Etwe tutiniirwe kwo obhuheene bhwe ebhisigo bhyeetu, nawe wuno atana isarya rino akoriri.” ");
INSERT INTO zak_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kyaamwe, akabhuga, “Ee Yeesu! Onihiite na neenye hano oraasikire mubhutemi bhwaazo.” ");
INSERT INTO zak_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yeesu akamukyoora, “Ndakubhuurira obhuheene, reero yino turabha hamwe mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Eriibhaga ryaari rya kasaasabha mumwiisi, ekiirima kikasikira mukyaaro kyoosi tee eriibhaga rya keenda, ");
INSERT INTO zak_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kwo okubha eryoobha rikarima. No omweenda guno gwaari gusuungirwe mu Hahoreeru he eriiseengerero, gukaraanduka mbaara ibhiri. ");
INSERT INTO zak_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yeesu akarira kwiiraka ikuru, “Ee Taata, ndatuura ekoro yaane mumabhoko gaazo.” ");
INSERT INTO zak_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na hano yamariri kugaamba gayo akatina ekoro. Omukuru wa abhasirikare hano yaruuzi gayo, akamukumya Taatabhugya arabhuga, “Nimenyiri omuutu wuno yaari omuheene.” ");
INSERT INTO zak_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Abhaatu bhoosi bhano bhaari bhiikumanirye hayo kurora ekisigo kiyo, hano bhaaruuzi gayo bhakakyoora mumigye gyaabhu, bhariitematema mubhikubha bhyaabhu kwe ebhigoongi. ");
INSERT INTO zak_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na abhaandi bhano bhaamumenyiri Yeesu, bhakiikara kure no okwiisuunza gano gaari kukorwa. Gati waabhu, abhakari bhaari bharimu bhano bhakumutuniirira kurwa Gariraaya. ");
INSERT INTO zak_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Hahaabha no omuutu wumwe, eriina ryaaye Yusufu, wa mumugye gwa Arimataya wa mukyaaro kya Yudea. Yusufu wuyo, ahaabha wumwe gati wa abhakuru bha Abhayahudi, nawe atiikirirenie na abharikyaaye kwe ekiina kyo okumwiita Yeesu. Ewe yaari omuutu omuzomu no omuheene, na ahaabha araganya obhutemi bhwa Taatabhugya bhuuze. ");
INSERT INTO zak_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Niho Yusufu wuyo, akagya ku Pirato akamusabha ekituundu kya Yeesu. ");
INSERT INTO zak_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na hano Pirato akiikirirya, Yusufu akagya akiikya ekituundu okurwa kumusaraba, akakiriizirira mumweenda gwo obhuguri bhukuru. Kyaamwe akakihiindirya mumbiihira yino yabhaazirwe kwiitare, na mumbiihira muyo, ataariho omuutu owuundi wuno yabhiikirwemu. ");
INSERT INTO zak_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Orusiku ruyo, rukabha orusiku rwo okubhanura no orusiku rwo okumuunya, na runo rwaari haguhi kuhika. ");
INSERT INTO zak_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abhakari bhano bhaageendiri hamwe na Yeesu kurwa Gariraaya bhakaaza na Yusufu. Bhakamutuniirira bhakarora mumbiihira muyo, na kyeego ekituundu kya Yeesu kihiindirwemu. ");
INSERT INTO zak_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kyaamwe, bhakakyoora yiika, bhakabhanura amaguta no omuruumbaaso, bhaaze nabhyo kuhaka kukituundu kya Yeesu. Kyaamwe orusiku rwo okumuunya, kyeego emigiro gyaari kweenda. ");
INSERT INTO zak_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Etabhoori zuri orusiku rwo okutaanga rwo obhutuuro, abhakari bhayo bhakagya mumbiihira na amaguta go omuruumbaaso gano bhaari bhagabhanwiiri. ");
INSERT INTO zak_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hano bhaahikiri, bhakabhona eriigina eriikuru rino ryaari riribhiri mumbiihira, rihuungwiirwe embarika. ");
INSERT INTO zak_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Niho bhakasikira muusi, kyaamwe bhakabhona ekituundu kyo Omukuru Yeesu kitarimu. ");
INSERT INTO zak_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hano bhaari bhakyaruguura iguru ye engʼana yiyo, kituukiro embarika waabhu, bhakiimeerera abhaatu bhabhiri, bhiibhohiri emyeenda gyo okumesyamesya. ");
INSERT INTO zak_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hano bharuuzi gayo, abhakari bhayo bhakagwaatwa no obhwoobha bhwaaru, niho bhakiihiinya tee haasi. Kyaamwe, abhaatu bhayo bhakabhabhuurira, “Ndora muramoohya omuhoru mubhaku? ");
INSERT INTO zak_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Atari hano, aryookiri! Emwe mutakuhiita amangʼana garya yabhabhuuriiri, hano yaari akyaari Gariraaya? ");
INSERT INTO zak_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Akabhuga, ‘Enye Omwaana wo Omuutu, nireenderwa nituurwe mumabhoko ga bhe ebhibhi, na bharaniitira kumusaraba, no orusiku rwa katatu ndaryooka.’ ” ");
INSERT INTO zak_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Neebho bhakahiita amangʼana gayo ga Yeesu, ");
INSERT INTO zak_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","bhakarwa mumbiihira bhakagya kukeerenia na abheega bha Yeesu ikumi na wumwe, hamwe na abhaatu abhaandi bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Abhakari bhayo ni Mariamu wa mumugye gwa Magidara, Yoana, na Mariamu nina waabhu Yaakobo, hamwe na abhakari abhaandi bhano bhaari hamwe nabho. ");
INSERT INTO zak_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hano bhaagaambiri goosi gayo kubheega, bhakagarora kubha ni ga kizabhuri, bhataagiikiriirye. ");
INSERT INTO zak_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nawe, Petero akiimeerera, akaryaara bhwaangu kugya mubhubhi. Akiihiinya, akasoomya mumbiihira, akayirora engibho ndabhu yino bhaamubhiikiirimu Yeesu, giri hayo egyeene ego. Akarwa hayo, eno ariibhuurya omweene kino kituukiri. ");
INSERT INTO zak_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Orusiku ruyoruyo, abhabhiri bha abheega bha Yeesu bhaari murugeendo rwo okugya mumugye gwa Emau. Omugye guyo, gwaari obhweema bhwa amataambuka ebhikwe ikumi na kimwe (11,000) okurwa Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na abhabhiri bhayo, bhaari bhariibhisirya iguru ya amangʼana goosi gano gaakorirwe. ");
INSERT INTO zak_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hano bhakwiibhuurya no okukeerenia, Yeesu woosi akaaza, akageenda hamwe nabho. ");
INSERT INTO zak_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nawe bhaari bhakuundikiriibhwe ameeso gaabhu, bhatamenyiri kubha niwe. ");
INSERT INTO zak_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Akabhabhuurya, “Murakeereneryaki eno murageenda?” Bhakiimeerera, eno bhariingiri eziikomo zyaabhu. ");
INSERT INTO zak_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Owumwe waabhu, eriina ryaaye niwe Kiriopa, akamukyoora, “Mubhagini bhoosi bha Yerusaremu, naawe omweene ego omugini, wuno oteenda wiigwa goosi gano gakorirwe eziisiku zino!” ");
INSERT INTO zak_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yeesu akabhuurya, “Ni mangʼanaki gayo?” Bhakamukyoora, “Amangʼana ga Yeesu wa Nazareeti. Niwe yaari omurooti wo obhunagya bhwo okukora no okugaamba embere wa Taatabhugya na abhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kyaamwe, abhakuru bha abhaseengeri na abhakaangati bheetu, bhakamutinira ekiina kubha yiitwe, niho bhakamwiita kumusaraba. ");
INSERT INTO zak_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na ewe niwe tumwiisigiiri kubha, aratutuurya etwe Abhiiziraeri. Okutuuma gayo goosi, reero ni rusiku rwa katatu kweema gaatuukiri. ");
INSERT INTO zak_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Hamwe na gayo, gati wa abhakari bhano bhaari bhe eweetu, bhakatutakya. Reero etabhoori zuri bhakagya kumbiihira, ");
INSERT INTO zak_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bhakabhona omubhiri gutari muusi muyo, bhiiziri kutubhuurira kubha bhatuukiirwe na bhamaraika bhano bhabhabhuuriiri kubha Yeesu ni muhoru. ");
INSERT INTO zak_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na abhaandi bhano bhaari hamwe na neetwe, bhakagya mubhubhi bhakabhona niigo ego kyeego abhakari bharya bhaagaambiri, nawe Yeesu bhataamuruuzi.” ");
INSERT INTO zak_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yeesu akabhabhuurira, “Emwe bhageege bhano, kwaki mutakunagya kwiikirirya, kwaki ni bhakongʼu ego kwiikirirya gano gaagaambirwe na abharooti? ");
INSERT INTO zak_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ndora Masiya akeenderwa kuhitira enyaako yoosi yiyo, Taatabhugya aramukora aguungibhwe?” ");
INSERT INTO zak_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Niho, akabhagarurira amangʼana goosi gano gakaamirwe iguru waaye, kweemera ebhitabhu bhya Musa, tee ebhitabhu bhyoosi bhya abharooti. ");
INSERT INTO zak_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na hano bhaari bhariisuka mumugye muyo, Yeesu akiikora kubha akyaageenderera no orugeendo. ");
INSERT INTO zak_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Niho bhakamwiisasaama bhukongʼu, “Wiikare hamwe neetwe hano! Ndora ritubhiiri ne ekiirima kiiziri.” Niho, Yeesu akasikira yiika kwiikara nabho. ");
INSERT INTO zak_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na hano bhakiikara kubhyaakurya, Yeesu akagega omukaate, akagusabhira, akagubhega, akabhaha. ");
INSERT INTO zak_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hayohayo, bhakarimurwa ameeso gaabhu, bhakamumenyeekererya kubha ni Yeesu. Kyaamwe akabhabhuraku. ");
INSERT INTO zak_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhakiibhuurira, “Hano twaari munzira, akatukeerenerya gano gaari mu Makaamo Amahoreeru, tutasaambarukiri bhukongʼu muziikoro zeetu?” ");
INSERT INTO zak_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bhakabhuuka kwiibhaga riyoriyo, bhakakyoora Yerusaremu. Eyo bhakabhabhona abheega bha Yeesu ikumi na wumwe bhiikumeenie hamwe na abhaandi. ");
INSERT INTO zak_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Abheega bhakabhabhuurira, “Ni heene, Omukuru Yeesu aryookiri, amuhwaarukiiri Simooni.” ");
INSERT INTO zak_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Niho bhakazweenia abharikyaabhu gano gabhatuukiiri munzira, bhakabhabhuurira kyeego bhaamumenyiri Yeesu hano yabhegiri omukaate. ");
INSERT INTO zak_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hano abhaanabheega bha Yeesu bhayo bhaari bhakwiibhisirya iguru ya gayo, hasuuhwiigo Yeesu omweene akiimeerera gati waabhu. Akabhabhuurira, “Omureembe gubhe neemwe.” ");
INSERT INTO zak_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhakiitakya, bhakoobhoha bhukongʼu, kwo okubha bhakiiseega kubha bharuuzi omusaambwa. ");
INSERT INTO zak_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kyaamwe, Yeesu akabhabhuurira, “Ndora muhoobhiri bhukongʼu, na kwaki mwiitiimaatiri muziikoro zyeenyu? ");
INSERT INTO zak_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Muniisuunze amabhoko gaane na amaguru gaane, niho mumenye kubha neenye. Mungwaateku, mwiirorere abheene! Omusaambwa gutana minoku na gutana maguha, nawe, kyaabhurya mukuundora enye ninabhyo bhiyo.” ");
INSERT INTO zak_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kyaamwe, akabheerekya amabhoko gaaye na amaguru gaaye. ");
INSERT INTO zak_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Abheega bhaaye, bhakazomererwa bhukongʼu eno bharuguuriri, nawe bhatiikiriirye gayo ni go obhuheene. Niho, Yeesu akabhabhuurya, “Mune ebhyaakurya bhyobhyoosi hano?” ");
INSERT INTO zak_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhakamuha ekitinika kye eswe ekaru, ");
INSERT INTO zak_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akakigega, akakirya embere waabhu. ");
INSERT INTO zak_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kyaamwe akabhabhuurira, “Gano nigo garya niabhabhuuriiri eriibhaga niari hamwe na neemwe, kubha garaakorwe gano goosi gakaamirwe iguru waane mumigiro gya Musa, na mubhitabhu bhya abharooti, na mukitabhu kya Zaburi.” ");
INSERT INTO zak_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Hayo, Yeesu akabhasakirya no okubhagarurira kumenya Amakaamo Amahoreeru. ");
INSERT INTO zak_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Akabhabhuurira, “Ekaamirwe kubha Masiya aranyaakibhwa no orusiku rwa katatu araryooka kurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na abhaatu bha mubhyaaro bhyoosi, kweemera hano Yerusaremu, bhareegibhwa kuriina ryaaye kubha bhate ebhibhi bhyaabhu, niho bharaabhirwe. ");
INSERT INTO zak_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Emwe neemwe abhamenyeekererya bha amangʼana gayo gaatuukiri. ");
INSERT INTO zak_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Murore! Ndabhareetera emwe Ekoro Muhoreeru kyeego Taata yabharageenie, kubha mwiikare mumugye guno tee Ekoro Muhoreeru yiize abhiizurirye obhunagya kurwa mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kyaamwe, Yeesu akabhakaangata abhaanabheega bhaaye, haguhi no omugye gwa Betania. Hano bhaahikiri hayo, akagorora amabhoko gaaye iguru kwo okubhatweera ebhite. ");
INSERT INTO zak_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Na hano yaari arabhatweera ebhite, niho ewe akabhatiga kwo okugegwa kugya mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hayo bhakamuseengera, kyaamwe bhakakyoora Yerusaremu, eno bhazomereerwe bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Neebho bhakiikara mwiiseengerero, bhakabha bharamukumya Taatabhugya.");
INSERT INTO zak_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kubhweemero hayo, Engʼana yaari ariho. Engʼana wuyo yaari hamwe na Taatabhugya, kweeki niwe Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kubhweemero, Engʼana yaari hamwe na Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ebhigiro bhyoosi bhyaateemirwe kwo okuhitira Engʼana wuyo. Kitariho naabhe ekigiro kimwe kino kyabhuumbirwe atariho. ");
INSERT INTO zak_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Engʼana wuyo yaari esimuka yo obhuhoru bhwoosi, no obhuhoru bhuyo nibhwo bhwaari bhukureeta obhweero kubhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Obhweero bhuyo bhuhaabhaanza mukiirima, naawe ekiirima kitaanagirye kubhuhiza tee reero. ");
INSERT INTO zak_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Akaaza omuutu wumwe wuno yatumirwe na Taatabhugya. Omuutu wuyo yaari arabhirikirwa Yohana. ");
INSERT INTO zak_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohana akaaza okumenyeekererya obhweero bhuyo, okubha abhaatu bhoosi bhabhone okwiikirirya kwo okuhitira obhumenyeekererya bhwaaye. ");
INSERT INTO zak_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana omweene ataari obhweero bhuyo, nawe akaaza okubhumenyeekererya. ");
INSERT INTO zak_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Obhweero bhwe eheene bhuyo, bhuno bhukubhaanzira omuutu wuyo woosi, bhwaari bhuraaza mukyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Engʼana niwe yaari mukyaaro muno, kweeki Taatabhugya yateemiri ekyaaro okuhitira kweewe. Nawe, abhaatu bha mukyaaro bhataamumenyeekereerye. ");
INSERT INTO zak_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akaaza mukyaaro kyaaye, nawe abhaatu bhaaye bhataamusuungʼaaniri. ");
INSERT INTO zak_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nawe abhaatu bhoosi bhano bhakamusuungʼaana no okumwiikirirya, bhayo akabhaha obhuturikano bhwo kubha abhaana bha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bhayo nibho abhaana bha Taatabhugya bhatari bhiibhwiirwe kya abhaandi, kasi kwo obhuseegi bhwo omubhiri, kasi kwo obhwiigoombi bhwo omuutu, nawe Taatabhugya omweene akabhakora kubha abhaana bhaaye. ");
INSERT INTO zak_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ambe, Engʼana wuyo akabha omuutu, akiikara gati weetu. Na neetwe tukarora obhuguungo bhwaaye, obhuguungo bhwo Omwaana omweene wa Taata Taatabhugya. Yaari no orubhaango rwaaye no obhuheene bhwoosi. ");
INSERT INTO zak_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana akamumenyeekererya, akatiirya eriiraka ikuru akubhuga, “Wuno niwe wuno niari nikubhabhuurira, ‘Araaza omuutu wumwe inyuma waane, omukuru kukira enye, kwo okubha yaari ariho nikyaari kwiibhurwa.’ ” ");
INSERT INTO zak_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kutuukana no obhukuunaanio bhwaaye, Taatabhugya atuheeri twoosi orubhaango rwaaye, na arageenderera okutuha orubhaango kukiraho. ");
INSERT INTO zak_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Okweema ekare Taatabhugya akaruusya emigiro gyaaye kwo okuhitira Musa, na bhoono aruusirye orubhaango rwaaye no obhuheene bhwaaye kwo okuhitira Yeesu Krisito. ");
INSERT INTO zak_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Atariho omuutu wowoosi wuno yaanguhiri okumurora Taatabhugya. Nawe Omwaana omweene, ewe niwe Taatabhugya, kweeki ari hamwe na Taata Taatabhugya, ewe niwe amukuundukwiiri Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Orusiku rumwe, abhakaangati bha Abhayahudi bhakatuma abhaseengeri na Abharaawi okurwa Yerusaremu, bhagye ku Yohana, bhamubhuurye, “Awe naawe weewi?” Akabhamenyeekererya, ");
INSERT INTO zak_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","no okubhakyoora okutama kubhisa obhuheene, “Enye nitari Masiya.” ");
INSERT INTO zak_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhakamubhuurya kweeki, “Bhoono, awe naawe weewi? Mbe, awe naawe omurooti Eriya?” Yohana akabhakyoora, “Zeyi, enye nitari Eriya.” Ebho bhakamubhuurya kweeki, “Mbe, awe niwe omurooti wuno tukumuganya okurwa ku Taatabhugya?” Yohana akabhakyoora, “Zeyi, nitari enye.” ");
INSERT INTO zak_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bhakamubhuurya kweeki, “Ambe, awe naawe weewi? Otubhuurire okubha tugye tubhabhuurire bhano bhatutumiri. Awe orabhugabhwi iguru waazo omweene?” ");
INSERT INTO zak_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana akabhakyoora kuriingʼaana na amangʼana gano omurooti Isaya akabhuga, “Enye ni wurya ‘omuutu wuno akubhirikira kwe eriiraka ikuru okurwa mwiitirigo: Mumukorere Omukuru eziinzira zino araahite!’ ” ");
INSERT INTO zak_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Abhaatu bhano bhaatumirwe, bhaari bharwiiri ku Bhafarisayo. ");
INSERT INTO zak_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bhayo bhakamubhuurya, “Eraabhe awe otari Masiya, naabhe omurooti Eriya, naabhe omurooti wuno tukumuganya okurwa ku Taatabhugya, ni kwaki orabatiiza abhaatu?” ");
INSERT INTO zak_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana akabhakyoora, “Enye ndabatiiza abhaatu kwa amaanzi, nawe gati weenyu ariho omuutu wuno emwe mutamenyiri. ");
INSERT INTO zak_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wuyo niwe akuuza inyuma waane. Enye nitakungʼarira kubha omuhokya waaye naabhe okutazura eziikobha zye ebhikweera bhyaaye.” ");
INSERT INTO zak_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amangʼana goosi gayo, gakakorwa mumugye gwa Betania, orubhaara rwa ruguru rwe Ekitaaro kya Yorodaani, hano Yohana yaakubatiiza abhaatu. ");
INSERT INTO zak_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tabhoori yaho, Yohana akamurora Yeesu araaza kweewe. Akabhabhuurira abhaatu bhano bhaari bhariho hayo, “Rora, wuyo niwe Engʼoondu ya Taatabhugya. Wuno akuruusya ebhibhi bhya abhaatu bhoosi bhe ekyaaro kino! ");
INSERT INTO zak_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wuno niwe wuno niari nikubhabhuurira, ‘Araaza omuutu wumwe inyuma waane, ewe ni mukuru kukira enye, kwo okubha yaari ariho nikyaari kwiibhurwa.’ ");
INSERT INTO zak_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naabhe enye nitaamumenyeekereerye kubha ni weewi, nawe niiziri okubatiiza abhaatu kwa amaanzi, okubha akuundukurwe kubhaatu bha Iziraeri.” ");
INSERT INTO zak_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Niho Yohana akamenyeekererya gano yaruuzi, akabhuga, “Nikamurora Ekoro Muhoreeru ariika okurwa mwiisaaro kye ekiguuti no okwiituura iguru waaye. ");
INSERT INTO zak_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Naabhe enye omweene nitaamumenyeekereerye kubha ni weewi, nawe Taatabhugya wuno akaanituma okubatiiza kwa amaanzi yaari anibhuuriiri, ‘Omuutu wuno oraamurore Ekoro Muhoreeru ariika no okwiikara iguru waaye, wuyo niwe araabatiize abhaatu kwe Ekoro Muhoreeru.’ ” ");
INSERT INTO zak_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Niho Yohana akabhuga, “Enye nduuzi gayo goosi, na ndabhamenyeekererya bhoono kubha, wuyo niwe Omwaana wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tabhoori yaho, Yohana yaari yiimeereeri hayo kweeki, hamwe na abhabhiri bha abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Niho akamurora Yeesu arageenda haguhi nabho. Akabhabhuurira abhaanabheega bhaaye, “Rora, wuyo niwe Engʼoondu ya Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hano abhaanabheega bhabhiri bhayo bhiigwiiri amangʼana gayo, bhakamutuniirira Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu akiikibhuka, akarora abhaanabheega bhayo bharamutuniirira. Akabhabhuurya, “Mbe, mureendaki?” Ebho bhakamukyoora, “Ee Raabi, oriikara hayi?” Obhugazuro bhwe engʼana Raabi ni Mweegya. ");
INSERT INTO zak_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yeesu akabhuga, “Muuze muraharora.” Niho bhakamutuniirira, bhakagya hano yaari akwiikara. Hano bhaahikiri hayo, yaari eriibhaga ri ikumi engoroobha, bhakasaaga neewe kwo orusiku ruyo. ");
INSERT INTO zak_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Owumwe gati wa abhaanabheega bhabhiri bhano bhakiigwa amangʼana ga Yohana no okumutuniirira Yeesu, yaari arabhirikirwa Andurea, wamwaabhu Simooni Petero. ");
INSERT INTO zak_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Rugeendo rumwe akagya okumumoohya Simooni, wamwaabhu. Hano yamubhweeni, akamubhuurira, “Tumuruuzi Masiya!” Masiya, obhugazuro bhwaku ni Krisito, omuhakwa wa amaguta. ");
INSERT INTO zak_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Niho Andurea akamuhira Simooni ku Yeesu. Yeesu akamumogorera Simooni, akamubhuurira, “Awe ni Simooni, omwaana wa Yohana. Nawe okweemera bhoono, eriina ryaazo rirabha ni Kefa.” Eriina riyo ku Kiyunaani ni Petero, obhugazuro bhwaku ni itare. ");
INSERT INTO zak_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tabhoori yaho, Yeesu akaamura kugya mukyaaro kya Gariraaya. Niho akamubhona Firipo, akamubhuurira, “Nawuuze, onituniirire.” ");
INSERT INTO zak_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Firipo yaari muutu wo okurwa mumugye gwa Betisaida, hano Andurea na Petero nabho bhaari bhakurweera. ");
INSERT INTO zak_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ambe, Firipo akamubhona Natanieri, akamubhuurira, “Tumuruuzi omuutu wuno Musa yakaamiri amangʼana gaaye mukitabhu kye emigiro, kweeki na abharooti nabho bhaakaamiri amangʼana gyaaye. Eriina ryaaye ni Yeesu, omwaana wa Yusufu, okurwa Nazareeti.” ");
INSERT INTO zak_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nawe Natanieri akamubhuurya Firipo, “Mbe, ekigiro kyokyoosi ekizomu kiranagya okurwa mumugye omusuuhu gwa Nazareeti?” Firipo akamukyoora, “Nawuuze, orore.” ");
INSERT INTO zak_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hano Yeesu yamuruuzi Natanieri araaza kweewe, akabhuga, “Rora, omuutu wuyo ni Mwiiziraeri we eheene, atana bhungʼeenererya bhwobhwoosi muusi waaye.” ");
INSERT INTO zak_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanieri akamubhuurya Yeesu, “Okoriribhwi onimenyiri?” Yeesu akamukyoora, “Naabhe hano Firipo yaari akyaari kukubhirikira, enye nikakurora wiikeeri iyaasi wo omutiini.” ");
INSERT INTO zak_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanieri akamukyoora, “Omweegya, awe ni Mwaana wa Taatabhugya! Awe ni Mutemi wa Iziraeri!” ");
INSERT INTO zak_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yeesu akamubhuurya, “Mbe, oriikirirya kwo okubha nikubhuuriiri nikuruuzi hano waari wiikeeri iyaasi wo omutiini? Orarora amangʼana agaandi amakuru kukira gano!” ");
INSERT INTO zak_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Niho akamubhuurira, “Ndabhabhuurira obhuheene, murarora mwiisaaro hiigukiri, na murarora bhamaraika bha Taatabhugya bharatiira no okwiika kweenye, Omwaana wo Omuutu.” ");
INSERT INTO zak_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ambe, orusiku rwa katatu, ekakorwa enyaangi yo obhweenga mumugye gwa Kana, mukyaaro kya Gariraaya. Mubhweenga bhuyo, nina waabhu Yeesu neewe yaariho. ");
INSERT INTO zak_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yeesu na abhaanabheega bhaaye nabho bhaari bharaarikirwe mubhweenga bhuyo. ");
INSERT INTO zak_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hano amaanzi go omuzabibu gaari gahwiiri, nina waabhu Yeesu akamubhuurira Yeesu, “Abhagini bhatana amaanzi go omuzabibu gogoosi.” ");
INSERT INTO zak_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yeesu akabhuga, “Maayi, kwaki oraambuurira ego? Eriibhaga ryo okukora emirimo gyaane rikyaari kuhika.” ");
INSERT INTO zak_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Niho nina waabhu akabhabhuurira abhahokya bha hayo, “Ryoryoosi rino araabhabhuurire, mukore.” ");
INSERT INTO zak_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ambe, zyaari zireho eziinyuungu isaasabha zya amaanzi zino zyakorirwe na amagina. Abhayahudi bhaari bharatuura amaanzi muyo go okukorera eziinyaangi zyaabhu zyo okwiiyeerya. Eseengo yaari eriizura amadebe ataano kasi asaasabha. ");
INSERT INTO zak_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Niho Yeesu akabhabhuurira abhahokya, “Mwiizurye amaanzi muziinyuungu ziyo.” Nabho bhakiizurya amaanzi eziinyuungu ziyo tee iguru. ");
INSERT INTO zak_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kyaamwe, Yeesu akabhabhuurira, “Bhoono, mutahe amaanzi gayo hasuuhu, mumuhe omukuru we enyaangi.” Nabho bhakakora ego. ");
INSERT INTO zak_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hano omukuru we enyaangi yasamiri amaanzi gayo, akabhona gaari gikyooriri kubha amaanzi go omuzabibu. Ewe ataamenyiri hano amaanzi go omuzabibu gayo garweereeri, nawe abhahokya bhano bhaatahiri amaanzi muziinyuungu bhakamenya. Niho akamubhirikira omukweeri. ");
INSERT INTO zak_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Hano yahikiri, omukuru we enyaangi akamubhuurira, “Abhakori bhe enyaangi bhahaataanga okubhaha abhagini amaanzi go omuzabibu amazomu hiinga. Kyaamwe, eriibhaga rino abhagini bhakwiiguta, niho bhahaaza na amaanzi go omuzabibu gano gatari mazomu. Nawe awe oreetiri amaanzi go omuzabibu amazomu mubhuteero!” ");
INSERT INTO zak_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yeesu akakora ekitiika kino mumugye gwa Kana mukyaaro kya Gariraaya. Ekitiika kiyo kyaari kyo okutaanga okweerekya obhukuru bhwaaye, na abhaanabheega bhaaye bhakamwiikirirya. ");
INSERT INTO zak_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hano enyaangi yo obhweenga yahwiiri, Yeesu akahiriingita kugya mumugye gwa Kaperinaumu hamwe na nina waabhu, bhawamwaabhu na abhaanabheega bhaaye. Bhakiikara eyo siku suuhu. ");
INSERT INTO zak_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hano Enyaangi yo Okuhiita ya Abhayahudi yaari yiisukiri, Yeesu akatiira kugya Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ambe, hano yahikiri, akasikira mwiigoobhe rye eriiseengerero rya Taatabhugya, akabhona abhaatu bharagurya muyo, eziingʼoombe, eziingʼoondu ne ebhiguuti, na abhaandi bhaari bhiikeeri kuzimeeza zyaabhu bharakirania eziimbirya. ");
INSERT INTO zak_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Hano Yeesu yaruuzi gayo, akoogosa omujariti gwo orusiri, akaheebha bhoosi bhano bhaari bhakugurya mwiigoobhe rye eriiseengerero, hamwe ne eziingʼoondu ne eziingʼoombe. Kweeki, akazigwiisya eziimeeza zya bhano bhakukirania eziimbirya, no okunyaragania eziimbirya zyaabhu. ");
INSERT INTO zak_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Niho akabhabhuurira bhano bhaari bhakugurya ebhiguuti, “Muruusye ebhiguuti bhino hano! Mutakora nyuumba ya Taata waane kubha omuteera!” ");
INSERT INTO zak_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Hano abhaanabheega bhaaye bhiigwiiri gayo, bhakahiita amangʼana gano gakaamirwe mu Makaamo Amahoreeru, “Obhuseegi bhwaane kunyuumba yaazo bhusikiiri muusi waane na oraanimare.” ");
INSERT INTO zak_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hano abhakaangati bha Abhayahudi bhaaruuzi gano Yeesu akoriri, bhakamubhuurya, “Orakora ekyeerekenioki okumenyeekererya kubha ono obhuturo bhwo okukora amangʼana gayo?” ");
INSERT INTO zak_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yeesu akabhakyoora, “Murigwiisye eriiseengerero rino, na neenye ndaryoomboka kwa siku isatu.” ");
INSERT INTO zak_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Niho bhakabhuga, “Eriiseengerero rino rikoombokwa kwe emyaaka miroongo ene ni isaasabha (46)! Igabhwi awe oranagya okwoomboka kwa siku isatu?” ");
INSERT INTO zak_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nawe Yeesu yaari atakukeerenerya iguru we eriiseengerero eryeene, nawe yaari arakeerenerya iguru yo omubhiri gwaaye. ");
INSERT INTO zak_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hano Yeesu yaryookiri okurwa mubhaku, abhaanabheega bhaaye bhakahiita amangʼana gano yabhugiri. Niho bhakiikirirya Amakaamo Amahoreeru na amangʼana gano Yeesu yabhugiri. ");
INSERT INTO zak_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hano Yeesu yaari Yerusaremu mu Nyaangi yo Okuhiita, abhaatu bhaaru bhakataanga okumwiikirirya, kwe ekigirirye bhakarora ekyeerekenio kino yakoriri. ");
INSERT INTO zak_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nawe Yeesu ataabhiisigiri, kwe ekigirirye akabhamenya eziikoro zyaabhu bhoosi. ");
INSERT INTO zak_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ataamweendiri omuutu wuyo woosi okumubhuurira gano abhaatu bhakwiiseega, kwe ekigirirye akamenya goosi gano gari muziikoro zya abhaatu. ");
INSERT INTO zak_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yaari ariho omukaangati wumwe wa Abhayahudi we esaango ya Abhafarisayo, eriina ryaaye Nikodemo. ");
INSERT INTO zak_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Orusiku rumwe obhutiku, Nikodemo akagya ku Yeesu, akamubhuurira, “Omweegya, tumenyiri kubha awe ni mweegya wuno otumirwe na Taatabhugya, kwo okubha atariho omuutu wuno akunagya kukora ebhitiika bhino awe okukora, eraabhe Taatabhugya atari hamwe neewe.” ");
INSERT INTO zak_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu akabhuga, “Ndakubhuurira obhuheene, omuutu atakunagya kusikira mubhutemi bhwa Taatabhugya eraabhe akyaari kwiibhurwa rwa kabhiri.” ");
INSERT INTO zak_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo akamubhuurya Yeesu, “Omuutu aranagyabhwi okwiibhurwa rwa kabhiri akubha mukaruka? Eheene, aranagya kukyoora muunda ya nina waabhu okubha yiibhurwe kweeki?” ");
INSERT INTO zak_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yeesu akamukyoora, “Ndakubhuurira obhuheene, atariho omuutu wuno akunagya kusikira mubhutemi bhwa Taatabhugya eraabhe akyaari kwiibhurwa kwa amaanzi na kwe Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Omuutu ahiibhurwa okurwa kubhiibhuri bhaaye, nawe omuutu ahiibhurwa bhuhya kwe Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Otaruguura kwo okubha nikubhuuriiri, ‘Mureenderwa mwiibhurwe rwa kabhiri.’ ");
INSERT INTO zak_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ekoro Muhoreeru atuubheeni no obhukama bhuno bhukuhuumbuuta okweerekera hano bhukweenda. Oranagya okwiigwa obhuhuumbuuti bhwago, nawe otamenyiri hano bhukurweera na hano bhukugya. Niigo eri kwo omuutu wowoosi wuno yiibhwiirwe ne Ekoro Muhoreeru.” ");
INSERT INTO zak_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo akamubhuurya Yeesu, “Omuutu aranagyabhwi okwiibhurwa ne Ekoro Muhoreeru?” ");
INSERT INTO zak_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu akamukyoora, “Awe ni mweegya wuno okusuukwa bhukongʼu mukyaaro kya Iziraeri, no otamenyiri amangʼana gayo? ");
INSERT INTO zak_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ndakubhuurira obhuheene, etwe turabhuga gano tumenyiri, na turamenyeekererya gano turuuzi. Nawe emwe mutakwiikirirya obhumenyeekererya bhweetu. ");
INSERT INTO zak_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nibhabhuuriiri amangʼana gano gakukorwa mukyaaro hano, nawe emwe mutakwiikirirya. Bhoono muranagyabhwi kuniikirirya eraabhe ndabhabhuurira amangʼana ga amangʼana gano gakukorwa mwiisaaro? ");
INSERT INTO zak_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Atariho omuutu wowoosi wuno yagiiri mwiisaaro. Nawe enye Omwaana wo Omuutu, neenye nikaaza okurwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Hano Abhiiziraeri bhaari mukibhara, Musa akakora omusaambwa gwo okubhaazwa gwe enzoka ye eshaba no okuyitiirya kuriiti okubha bhahore. Egoego na neenye Omwaana wo Omuutu nireenderwa okutiiribhwa, ");
INSERT INTO zak_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","okubha omuutu wowoosi wuno akuniikirirya abhe no obhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Taatabhugya yaseegiri bhukongʼu abhaatu bhoosi bha mukyaaro muno. Nikyo ekigirirye akamuragania omwaana waaye omweene ego yiize mukyaaro muno, okubha omuutu wowoosi araamwiikirirye atabhura, nawe abhe no obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Taatabhugya ataamutumiri Omwaana waaye mukyaaro muno, okubha atinire ekiina abhaatu, nawe abhatuurye kuhitira kweewe. ");
INSERT INTO zak_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Taatabhugya atakutinira ekiina omuutu wuno amwiikiriirye Omwaana waaye. Nawe omuutu wuno atakumwiikirirya, amariri okutinirwa ekiina kwo okubha ataamwiikiriirye Omwaana wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Obhutini bhwe ekiina nibhwo bhuno, Omwaana wa Taatabhugya areetiri obhweero mukyaaro muno, nawe abhaatu bhaseegiri ekiirima kukira obhweero, kwo okubha amahokya gaabhu ni mabhiihu. ");
INSERT INTO zak_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abhaatu bhoosi bhano bhakutemya mabhiihu, ebho bharabhiihirirwa obhweero bhuyo. Bhatakweenda okuuza mubhweero, okubha amahokya gaabhu mabhiihu gataaza gamenyekane. ");
INSERT INTO zak_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nawe abhaatu bhoosi bhano bhakukora amahokya ge eheene, ebho bharamoohya kubha mubhweero bhuyo, okubha emenyekane Taatabhugya niwe akubhaha obhunagya bhwo okugahokya. ");
INSERT INTO zak_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ambe, okuhita gayo, Yeesu na abhaanabheega bhaaye bhakarwa mumugye gwa Yerusaremu na bhakagya mukyaaro kya Yudea. Akiikara eyo kwiibhaga irebhe, akabha arabatiiza abhaatu. ");
INSERT INTO zak_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana neewe yaari arabatiiza abhaatu Ainoni eyo, haguhi ne ekyaaro kya Saremu, kwo okubha gaari gariyo eyo amaanzi maaru. Na abhaatu bhaari bharagya eyo ku Yohana okubha abhabatiize. ");
INSERT INTO zak_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kwe eriibhaga riyo, Yohana yaari akyaari kugwaatwa no okutuurwa munyuumba ya abhabhohwa. ");
INSERT INTO zak_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Orusiku rumwe, abhaanabheega bha Yohana bhakataanga okuhakana no Omuyahudi wumwe iguru ye enyaangi yo okwiiyeerya. ");
INSERT INTO zak_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Niho bhakagya ku Yohana, bhakamubhuurira, “Omweegya, orahiita omuutu wuno yaari naawe kumwaambuko gwe Ekitaaro kya Yorodaani, no okagaamba amangʼana gaaye? Bhoono ewe woosi arabatiiza, na abhaatu bhoosi bharagya kweewe!” ");
INSERT INTO zak_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana akabhuga, “Omuutu atakunagya kubhona kigiro kyokyoosi, eraabhe Taatabhugya akyaari kumuha. ");
INSERT INTO zak_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Emwe ni bhamenyeekererya bhaane kubha nikabhuga, ‘Enye nitari Masiya, nawe Taatabhugya akaanituma okubha nimukaangatire Masiya.’ ");
INSERT INTO zak_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mumweenga, omweenga ni wo omukweeri. Nawe enye ni kyo omusaani wo omukweeri, niimeereeri embarika waaye ndazomererwa okwiigwa eriiraka ryaaye. Eheene ni mirimo gino giinzomeeri bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ereenderwa Yeesu abhe omukuru bhukongʼu, nawe enye nibhe omusuuhu.” ");
INSERT INTO zak_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wuno arwiiri mwiisaaro, ni mukuru kukira bhoosi. Wowoosi wuno akurweera mukyaaro, aragaamba amangʼana ga mukyaaro muno. Nawe wuno arwiiri mwiisaaro, ni mukuru kukira abhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ewe aramenyeekererya gano akarora no okwiigwa, nawe abhaatu bhatakwiikirirya amangʼana gaaye. ");
INSERT INTO zak_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Omuutu wowoosi wuno akwiikirirya amangʼana gaaye, areerekya kubha Taatabhugya ni we eheene, ");
INSERT INTO zak_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","kwo okubha Taatabhugya akamutuma Yeesu okubha agaambe amangʼana gaaye. Taatabhugya amuheeri Ekoro Muhoreeru kutama kubha ne ekireengo. ");
INSERT INTO zak_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taata Taatabhugya amuseegiri Omwaana waaye, kweeki amuheeri obhuturo iguru ye ebhigiro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Omuutu wowoosi wuno akumwiikirirya Omwaana wa Taatabhugya, wuyo ano obhuhoru bhwa kirakeego. Nawe omuutu wowoosi wuno akumwaanga, wuyo atana obhuhoru bhwa kirakeego, kwo okubha obhururu bhwa Taatabhugya bhuri iguru waaye. ");
INSERT INTO zak_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ambe, Yeesu akiigwa kubha, Abhafarisayo bhaabhuuriirwe arabatiiza no okubhona abhaanabheega bhaaru kukira Yohana. ");
INSERT INTO zak_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nawe, obhuheene ni kubha, Yeesu omweene ataabatiiziri, nawe abhaanabheega bhaaye nibho bhaari bharabatiiza. ");
INSERT INTO zak_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kweego Yeesu akatanura mukyaaro kya Yudea hamwe na abhaanabheega bhaaye, akakyoora mukyaaro kya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hano bhaari bhakugya Gariraaya, bhakeenderwa kuhitira mukyaaro kya Samaria. ");
INSERT INTO zak_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ambe, bhakahika mumugye gumwe gwa Samaria guno gukubhirikirwa Sikaari. Omugye guyo, gwaari haguhi no omuguundu guno Yaakobo akamuha engabho omwaana waaye Yusufu. ");
INSERT INTO zak_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hayo niho Yaakobo yaari atukiri ekitaaro, kino kikabhirikirwa ekitaaro kya Yaakobo. Yeesu, kwo okubha yaari arosiri no orugeendo, akiikara embarika we ekitaaro okubha amuunye. Yaari eriibhaga rya kasaasabha mumwiisi. ");
INSERT INTO zak_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Kyaamwe, omukari wumwe Omusamaria akaaza okutaha amaanzi mukitaaro hayo. Yeesu akamubhuurira, “Maayi, niha amaanzi ninywe.” ");
INSERT INTO zak_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Eriibhaga riyo, abhaanabheega bhaaye bhaari bhagiiri mumugye okugura ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ambe, omukari wuyo akabhuga, “Awe ni Muyahudi, na neenye ni Musamaria. Erabhabhwi onsabhe nikuhe amaanzi?” Akabhuga ego, kwo okubha Abhayahudi bhatakwiisaanginia na Abhasamaria. ");
INSERT INTO zak_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yeesu akamukyoora, “Eraabhe wuungamenyiri kino Taatabhugya akweenda kukuha, na kubha ni weewi wuno akukusabha amaanzi, wuungansabhiri enye, neenye niinganagirye okukuha amaanzi go obhuhoru.” ");
INSERT INTO zak_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Omukari wuyo akamubhuurira Yeesu, “Omukuru, awe otana naabhe ekigiro kyo okutahira amaanzi, kweeki ekitaaro kino ni kitaambi. Bhoono orabhona hayi amaanzi gayo go obhuhoru? ");
INSERT INTO zak_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Zaazi weetu Yaakobo omweene akatuha ekitaaro kino, neewe yaari aranywa amaanzi gaamu hamwe na abhaana bhaaye ne emitugo gyaaye. Bhoono mbe, oriirora kubha awe ni mukuru kumukira ewe?” ");
INSERT INTO zak_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Niho Yeesu akamukyoora, “Omuutu wowoosi wuno akunywa amaanzi ge ekitaaro kino, ariigwa enyoota kweeki. ");
INSERT INTO zak_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nawe omuutu wuno akunywa amaanzi gano enye ndaamuhe, atakwiigwa enyoota kweeki, naabhe kirakeego. Amaanzi gano ndaamuhe, garabha kye emisabhuko gya amaanzi muusi waaye, nago garabha garasabhuka obhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Niho omukari wuyo akamubhuurira Yeesu, “Omukuru, niha amaanzi gayo, okubha nitiigwa enyoota kweeki, na nitaaza okutaha amaanzi kweeki mukitaaro kino.” ");
INSERT INTO zak_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yeesu akabhuga, “Noogye omubhirikire omusubhe waazo, wuuze nawe hano.” ");
INSERT INTO zak_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Akabhuga, “Enye ntana musubhe.” Yeesu akamubhuurira, “Ogaambiri kisi kubha otana musubhe, ");
INSERT INTO zak_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","kwo okubha omariri kukweerwa kataano, no omusubhe wuno okwiikara nawe bhoono, atari musubhe waazo. Ogaambiri heene.” ");
INSERT INTO zak_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Omukari wuyo akamukyoora, “Omukuru, ndarora kubha awe ni murooti. ");
INSERT INTO zak_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bhazaazi bheetu bhaari bharamuseengera Taatabhugya mu Kiguru kya Gerizimu kino, nawe emwe Abhayahudi muragaamba kubha, tureenderwa tugye tumuseengere Taatabhugya Yerusaremu.” ");
INSERT INTO zak_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu akamubhuurira, “Maayi, oniikirirye, eriibhaga riraaza rino mutakuuza kumuseengera Taata Taatabhugya mukiguru kino kasi Yerusaremu erya. ");
INSERT INTO zak_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Emwe Abhasamaria muramuseengera Taatabhugya wuno mutamenyiri. Nawe etwe Abhayahudi turamuseengera Taatabhugya wuno tumumenyiri, kwo okubha Taatabhugya aratuurya abhaatu kwo okuhitira Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Eriibhaga riraaza, kweeki rimariri kuhika, hano abhaatu bhano bhakumuseengera Taata Taatabhugya kwo obhuheene, bharamuseengera kwe Ekoro Muhoreeru kyeego ari muheene. Taata Taatabhugya arakomya abhaatu bhano bhakumuseengera kwe enzira yiyo. ");
INSERT INTO zak_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Taatabhugya ni Koro. Abhaatu bhano bhakumuseengera, bhareenderwa bhabhe bharamuseengera kwe Ekoro Muhoreeru kyeego ari muheene.” ");
INSERT INTO zak_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Omukari wuyo akamubhuurira Yeesu, “Nimenyiri kubha Masiya araaza, wuno akubhirikirwa Krisito. Kweeki nimenyiri, eriibhaga hano araaze, aratubhuurira amangʼana goosi.” ");
INSERT INTO zak_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Niho Yeesu akamubhuurira, “Enye wuno nikugaamba naawe, niwe Masiya.” ");
INSERT INTO zak_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ambe, eriibhaga riyo, abhaanabheega bhaaye bhakakyoora. Bhakaruguura bhukongʼu kubha Yeesu yaari arakeerenia no omukari. Nawe atariho naabhe wumwe wuno akamubhuurya Yeesu, “Oreendaki kweewe?” kasi, “Kwaki orakeerenia neewe?” ");
INSERT INTO zak_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ambe, omukari wuyo akatiga eseengo yaaye ya amaanzi hayo, akagya mumugye. Hano yahikiri, akabhabhuurira abhaatu, ");
INSERT INTO zak_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Muuze tugye, mumurore omuutu wuno anibhuuriiri amangʼana goosi gano niahiitiri kukora! Mbe, eraturikana kubha wuyo niwe Masiya?” ");
INSERT INTO zak_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hano abhaatu bhiigwiiri gayo, bhakahuruka mumugye muyo, bhakagya ku Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hano abhaatu bhayo bhaari bhakyaari kuhika ku Yeesu, abhaanabheega bhaaye bhakamusabha, “Omweegya, orye ebhyaakurya.” ");
INSERT INTO zak_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nawe akabhabhuurira, “Enye nine ebhyaakurya ebhiindi bhino emwe mutabhimenyiri.” ");
INSERT INTO zak_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Niho abhaanabheega bhaaye bhakataanga okwiibhuurya, “Mbe, eheene eraturikana omuutu amureeteeri ebhyaakurya?” ");
INSERT INTO zak_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yeesu akabhabhuurira, “Ebhyaakurya bhyaane ni kukora obhuseegi bhwa Taatabhugya, wuno yaanitumeenie, no okukuunaania emirimo gyaaye. ");
INSERT INTO zak_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Emwe munariri okugaamba, ‘Gisaagiri emyeeri ene ego kuhikira amagesa.’ Nawe enye ndabhabhuurira, murore emiguundu kyeego giri, amagesa gamariri kukongʼa, gareenderwa gageswe. ");
INSERT INTO zak_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Omugesi ataangiri kubhona amariho gaaye, na amagesa gano bhakugesa ni bhaatu bhano bhakureetwa kubhuhoru bhwa kirakeego. Kweego, omweemya no omugesi, bhoosi bharazomererwa hamwe. ");
INSERT INTO zak_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kiriho ekireengyo kyo obhuheene kino kikubhuga, ‘Omuutu wumwe areemya, no owuundi aragesa.’ ");
INSERT INTO zak_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Enye nikabhatuma mugese gano mutaaganyaakiiriri. Abhaatu abhaandi bhakakora emirimo gyoosi emikongʼu, na neemwe murabhona obhweera bhwe emirimo gyaabhu.” ");
INSERT INTO zak_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ambe, Abhasamaria bhaaru bha mumugye guyo, bhakamwiikirirya Yeesu, kwo okubha bhiigwiiri obhugaambi bhwo omukari wuyo, “Omuutu wuyo anibhuuriiri amangʼana goosi gano niahiitiri kukora.” ");
INSERT INTO zak_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hano Abhasamaria bhaahikiri ku Yeesu, bhakamwiisasaama yiikare hamwe nabho. Niho akiikara mumugye guyo siku ibhiri. ");
INSERT INTO zak_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Abhaatu bhaaru bhukongʼu bhakamwiikirirya Yeesu kwe ekigirirye kya gano yaari akugaamba. ");
INSERT INTO zak_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhakamubhuurira omukari wuyo, “Turamwiikirirya omuutu wuno, etari kwe ekigiriye kya gano otubhuuriiri awe, nawe kwe ekigirirye twiigwiiri etwe abheene gano akubhuga. Bhoono tumenyiri kwo obhuheene kubha, omuutu wuno niwe Omutuurya we ekyaaro.” ");
INSERT INTO zak_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hano eziisiku ibhiri zyahitiri, Yeesu akarwa eyo, akageenderera kugya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yeesu yaari abhugiri, “Omurooti atakusuukwa muroobho yaaye.” ");
INSERT INTO zak_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hano yahikiri Gariraaya eyo, abhaatu bhakamuginihya, kwo okubha abheene bhaari bhariyo Yerusaremu mu Nyaangi yo Okuhiita na bhaari bharuuzi goosi gano yaari akoriri. ");
INSERT INTO zak_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yeesu akagya kweeki mumugye gwa Kana ya Gariraaya, hano yaari akyoosirye amaanzi kubha amaanzi go omuzabibu. Ambe, yaariho omutaake wumwe we ekitemi okurwa mumugye gwa Kaperinaumu. Omutaake wuyo, yaari no omumura waaye murweeri. ");
INSERT INTO zak_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Omutaake wuyo yaari yiigwiiri kubha Yeesu yakyooriri Gariraaya okureka Yudea. Kweego, akagya ku Yeesu no okumwiisasaama kubha ahiriingite Kaperinaumu, ahorye omumura waaye, kwo okubha yaari murweeri atamiiriirwe. ");
INSERT INTO zak_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yeesu akabhuga, “Emwe, muritama kurora ebhyeerekenio ne ebhiruguuro, mutakwiikirirya.” ");
INSERT INTO zak_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Omutaake wuyo akabhuga, “Omukuru, ndakusabha, tugye kumumura waane, akyaari kukwa.” ");
INSERT INTO zak_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nawe Yeesu akabhuga, “Noogye, omumura waazo ahoriri.” Omutaake wuyo, akiikirirya amangʼana gano Yeesu yamubhuuriiri, akatanura kugya owaaye. ");
INSERT INTO zak_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tabhoori yaho, hano yaari munzira, akasikana na abhagya bhaaye, bhaari bhagiiri kumusuungʼaana, nabho bhakamubhuurira, “Omumura waazo ni muhoru.” ");
INSERT INTO zak_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Niho akabhabhuurya eriibhaga rino akataanga kuhora. Bhakamukyoora, “Ehooma ekamutiga kweemera izo, eriibhaga rya muhuungati mumwiisi.” ");
INSERT INTO zak_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ambe, wiise wo omwaana wuyo akamenya kubha, mura waaye ahoriri kweemera eriibhaga riryarirya Yeesu yagaambiri, “Omumura waazo ahoriri.” Hayo omutaake wuyo hamwe na abhaatu bhoosi bha munyuumba yaaye, bhakamwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kino kyaari ekyeerekenio kya kabhiri kino Yeesu yakoriri hano yaari akurwa Yudea, kugya mukyaaro kya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ambe, okuhita gayo, Yeesu akagya Yerusaremu kuginiha enyaangi endebhe ya Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusaremu muyo, kyaari kireho ekisyooko ekikuru kino kikubhirikirwa Ekisyooko kye Engʼoondu. Haguhi ne ekisyooko kiyo, ryaari ririho eriisima rino eriina ryaaye mukigaambo kye Ekieburania ni Betizata. Eriisima riyo rikiinogoorwa na amabhuru ataano gano gaari ne eziitimu. ");
INSERT INTO zak_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mumabhuru gayo, bhaari bharahiindira abhaatu bhaaru: abhahoku, amagata na bhano bhakuuri ebhiimo. Bhaari bharaganya amaanzi gahoribhwe, ");
INSERT INTO zak_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kwe ekigirirye maraika wa Taatabhugya yaari araaza kubhusa amaanzi mukisima kiyo. Omuutu wuno yaari wo okutaanga kusikira mumaanzi, yaari arahora obhurweeri bhuno yaari nabhwe. ");
INSERT INTO zak_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gati waabhu, yaari arimu omusubhe wumwe wuno yaari murweeri kwe eriibhaga rye emyaaka miroongo etatu ne enaane (38). ");
INSERT INTO zak_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Niho Yeesu akamurora ahiindiiri hayo, akamenya kubha, omuutu wuyo yaarwaariri ibhaga itaambi. Akamubhuurya, “Mbe, oreenda kuhora?” ");
INSERT INTO zak_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Omurweeri wuyo akamukyoora Yeesu, “Omukuru, eriibhaga rino amaanzi gakuhoribhwa, ntana omuutu wo okunisakirya nisikire mukisima. Hano nikweenda kusikira mumaanzi, omuutu owuundi aranikaangatira kusikira muyo.” ");
INSERT INTO zak_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Niho Yeesu akamubhuurira, “Imeerera, gega ekiigi kyaazo, no ogeende.” ");
INSERT INTO zak_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hayohayo, omuutu wuyo akahora, akagega ekiigi kyaaye, akataanga kugeenda! Yeesu akamuhorya omuutu wuyo orusiku rwo okumuunya. ");
INSERT INTO zak_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kweego, abhakaangati bha Abhayahudi bhakamubhuurira omuutu wuyo wuno akahoribhwa, “Reero ni rusiku rwo okumuunya. Emigiro gyeetu gyo orusiku rwo okumuunya gitakwiikirirya okugega ekiigi kyaazo.” ");
INSERT INTO zak_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nawe akabhuga, “Omuutu wuno anihorirye, niwe anibhuuriiri, ‘Gega ekiigi kyaazo, ogeende.’ ” ");
INSERT INTO zak_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Abhakaangati bhayo bhakamubhuurya, “Ni weewi wuno akubhuuriiri kukora ego?” ");
INSERT INTO zak_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nawe ataamumenyiri wuno amuhonirye, kwe ekigirirye Yeesu ataarorekeeni kweeki musaango ekuru ya abhaatu bhano bhaariho. ");
INSERT INTO zak_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ambe, okuhita gayo, Yeesu akamubhona omuutu wuyo mwiiseengerero, akamubhuurira, “Itegeerera, bhoono ohoriri. Otabha orakora ebhibhi kweeki, otaaza kunyaaka kukira bhurya waari kunyaaka kubhutaangiro.” ");
INSERT INTO zak_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Rugeendo rumwe, omuutu wuyo akagya kubhakaangati bha Abhayahudi, akabhabhuurira kubha ni Yeesu wuno akamuhorya. ");
INSERT INTO zak_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Niho abhakaangati bha Abhayahudi bhakataanga kumunyaakya Yeesu, kwe ekigirirye yaari arahorya abhaatu orusiku rwo okumuunya. ");
INSERT INTO zak_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nawe Yeesu akabhabhuurira, “Taata arakora emirimo eziisiku zyoosi, na neenye ndakora egoego.” ");
INSERT INTO zak_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ambe, iguru wa amangʼana gayo, abhakaangati bha Abhayahudi bhakataanga kukomya enzira yo okumwiita Yeesu. Bhaari bhareenda kukora ego, kwo okubha Yeesu yaari arasarya emigiro gyo orusiku rwo okumuunya nawe ekibhi bhukongʼu ni kwo okubha yaari arabhuga, Taatabhugya ni Wiise. Kwo okugaamba ego, yaari ariikora ni kya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yeesu akabhabhuurira abhakaangati bhayo, “Ndabhabhuurira obhuheene, Omwaana wa Taatabhugya atakunagya kukora ryoryoosi ewe omweene, nawe arakora gano akurora Wiise waabhu akukora ego. Goosi gano Wiise waabhu akukora, nigo gano Omwaana akukora. ");
INSERT INTO zak_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Taata aramuseega Omwaana, na aramweerekya emirimo gyoosi gino akukora. Kweeki, aramweerekya kyeego araakore amangʼana amakuru kukira gano yaari amariri kugakora, na neemwe muraaruguure bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kyeego Taata akuryoora abhaku no okubhaha obhuhoru bhwa kirakeego, ego niigo Omwaana neewe akubhaha obhuhoru abhaatu bhano akweenda okubhaha. ");
INSERT INTO zak_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Taata atakutinira ekiina omuutu wowoosi, nawe amuheeri Omwaana waaye obhuturo bhwoosi bhwo okutinira ekiina abhaatu, ");
INSERT INTO zak_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","okubha kwe enzira yiyo bhoosi bhamusuuke Omwaana kyeego bhakumusuuka Wiise. Omuutu wowoosi wuno atakumusuuka Omwaana, wuyo atakumusuuka Wiise waabhu wuno yamutumiri. ");
INSERT INTO zak_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ndabhabhuurira obhuheene, omuutu wowoosi wuno akwiigwa amangʼana gaane no okumwiikirirya Taatabhugya wuno anitumeenie, wuyo ano obhuhoru bhwa kirakeego. Omuutu wuyo atakutinirwa ekiina, nawe amariri okwaambuka okurwa muruku no okusikira mubhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ndabhabhuurira obhuheene, eriibhaga riraaza, kweeki eriibhaga riyo rimariri kuhika, abhaku bhariigwa eriiraka ryo Omwaana wa Taatabhugya. Niho abhaatu bhano bhakubha bharamwiitegeerera, bhararyoorwa bharabha no obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kyeego Taata ano obhunagya bhwo okumuha omuutu obhuhoru bhwa kirakeego, egoego amuheeri Omwaana waaye obhunagya bhwo okubhaha abhaatu obhuhoru bhuyo bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kweeki, amuheeri Omwaana waaye obhuturo bhwo okutinira ekiina abhaatu, kwe ekigirirye ewe niwe Omwaana wo Omuutu. ");
INSERT INTO zak_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mutaruguura amangʼana gayo! Riraaza eriibhaga rino abhaku bhoosi bhariigwa eriiraka ryo Omwaana wo Omuutu, ");
INSERT INTO zak_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","neebho bhararyooka no okurwa muziimbiihira zyaabhu. Abhaatu bhano bhaari bharakora amazomu, bhararyoorwa, no okuhaanwa obhuhoru bhwa kirakeego, nawe bhano bhaari bhakukora amabhiihu, bhararyoorwa no okutinirwa ekiina. ");
INSERT INTO zak_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Enye nitakunagya kukora ryoryoosi omweene. Ndatinira ekiina abhaatu kyeego Taata waane akunibhuurira. Obhutini bhwe ekiina bhwaane ni bhwe eheene, kwo okubha nitakukora kyeego enye omweene nikweenda, nawe ndakora kyeego Taata akweenda, wuno yaanitumeenie. ");
INSERT INTO zak_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Eraabhe niingiimenyeekereerye enye omweene obhumenyeekererya bhwaane, bhutari bhwe eheene. ");
INSERT INTO zak_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nawe ariho owuundi wuno akunimenyeekererya amangʼana gaane kweemwe, wuno niwe Taata. Na neenye nimenyiri kubha, obhumenyeekererya bhwaaye ni bhwe eheene. ");
INSERT INTO zak_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Emwe mukatuma abhabhagati ku Yohana Omubatiizi, neewe akabhagaambira obhuheene iguru waane. ");
INSERT INTO zak_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Enye nitakwiisigira obhugaambi bhwa abhaatu, nawe ndabhabhuurira goosi gayo, okubha mubhone kutuuribhwa. ");
INSERT INTO zak_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“Yohana Omubatiizi yaari kyeego etara yino ekwaaka no okumirika mukiirima, na neemwe mukazomererwa obhweero bhuyo kwiibhaga iguhi. ");
INSERT INTO zak_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nawe enye nino obhumenyeekererya obhukuru kukira bhwa Yohana, nigyo emirimo gino Taata waane yaniheeri kukuunaania. Emirimo gyaane gireerekya kubha, Taata waane niwe yantumeenie. ");
INSERT INTO zak_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Neewe Taata waane wuno yantumeenie, omweene animenyeekereerye kweemwe. Emwe mukyaari kwiigwa eriiraka ryaaye, naabhe okurora ewe kyeego ari. ");
INSERT INTO zak_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Amangʼana gaaye, gatakwiikara muusi weenyu, kwe ekigirirye mutakumwiikirirya wurya wuno Taatabhugya yamtumeenie kweemwe. ");
INSERT INTO zak_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Murakora omukya kwiisuunza Amakaamo Amahoreeru, kwo okubha muriiseega muranagya okubhona muyo obhuhoru bhwa kirakeego. Amakaamo gayogayo nigo gakunimenyeekererya enye! ");
INSERT INTO zak_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nawe muraanga okuuza kweenye, okubha mubhone obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Enye nitakukomya omukumo okurwa kubhaatu. ");
INSERT INTO zak_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nawe nimenyiri kyeego emwe muri, kubha mutana obhuseegi bhwa Taatabhugya muziikoro zeenyu. ");
INSERT INTO zak_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Enye niiziri kwo obhuturo bhwa Taata waane, nawe muraanga kunisuungʼaana. Nawe omuutu owuundi hano akuuza kwo obhuturo bhwaaye omweene, ewe muramusuungʼaana. ");
INSERT INTO zak_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Emwe museegiri okukumibhwa na abharikyeenyu, nawe mutakukomya omukumo guno gukurwa ku Taatabhugya omweene. Bhoono, muranagya igabhwi kuniikirirya enye? ");
INSERT INTO zak_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mutiiseega kubha, enye ndabhahaya ku Taata. Wuno araabhahaye ni Musa, kwe ekigirirye wuyo niwe mukumwiisigira. ");
INSERT INTO zak_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Eraabhe eheene muungikiriirye amangʼana ga Musa, ambe enye woosi muunganiikiriirye, kwe ekigirirye Musa akakaama amangʼana gaane. ");
INSERT INTO zak_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nawe eraabhe mutakwiikirirya amakaamo ga Musa, ambe muranagya igabhwi okwiikirirya amangʼana gaane?” ");
INSERT INTO zak_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ambe, okuhita gayo, Yeesu akaambuka Enyaanza ya Gariraaya, yino eriina eriindi ni Nyaanza ya Tiberia. ");
INSERT INTO zak_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Esaango ekuru ya abhaatu bhaari bharamutuniirira Yeesu, kwo okubha bhaari bharuuzi ebhitiika bhino yakoriri kubharweeri. ");
INSERT INTO zak_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Niho Yeesu akatiira mukiguru ekirebhe hamwe na abhaanabheega bhaaye, akiikara eyo hamwe nabho. ");
INSERT INTO zak_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Eriibhaga riyo, Enyaangi yo Okuhiita ya Abhayahudi, yaari haguhi. ");
INSERT INTO zak_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hano Yeesu yataasiri ameeso, akarora esaango ekuru ya abhaatu, bhano bhaari bhakuuza kweewe. Niho akamubhuurya Firipo, “Mbe, nihe turaagure ebhyaakurya bhyo okuriisya abhaatu bhoosi bhano?” ");
INSERT INTO zak_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yeesu akamenya kino araakore, nawe akamubhuurira Firipo kwo okumusakya. ");
INSERT INTO zak_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Firipo akamukyoora, “Naabhe tuungaguriri ebhyaakurya bhye eziidinaari amagana abhiri (200), okubha abhaatu bhoosi bhabhone bhisuuhu, nazyo zitakubhiisa.” ");
INSERT INTO zak_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Niho Andurea, wuno yaari omwaanamweega owuundi wa Yeesu, wamwaabhu Simooni Petero, akamubhuurira Yeesu, ");
INSERT INTO zak_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ari hano omumura wumwe wuno ane emikaate etaano gye eshayiri ne eziiswe ibhiri. Nawe, ebhyaakurya bhino bhirakorabhwi bhiise esaango yoosi yino?” ");
INSERT INTO zak_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ambe, Yeesu akaswaagya abhaanabheega bhaaye, “Mubhabhuurire abhaatu bhiikare haasi.” Ahagiro hayo, haari no obhunyaaki bhwaaru. Niho abhaatu bhoosi, bhakiikara haasi. Abhasubhe abheene ego bhano bhakiikara okurya bhaari ni kye ebhikwe bhitaano (5,000). ");
INSERT INTO zak_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kyaamwe, Yeesu akagega emikaate giyo, akamubhuurira Taatabhugya, “Ozomirye,” akatwaanira abhaatu bhoosi bhano bhaari bhiikeeri hayo. Akakora egoego ne eziiswe nazyo, akabhatwaanira. Abhaatu bhoosi bhakarya kyeego bhaari kweenda. ");
INSERT INTO zak_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hano bhiigutiri bhoosi, Yeesu akabhabhuurira abhaanabheega bhaaye, “Mukumanie ebhyaakurya bhyoosi bhino bhisaagiri, okubha bhitaaza kusarika.” ");
INSERT INTO zak_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ambe, bhakakumania amasaagyo ge emikaate etaano gye eshayiri gano gakyaari kuriibhwa, bhakiizurya ebhikapu ikumi na bhibhiri. ");
INSERT INTO zak_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hano abhaatu bhayo bharuuzi ekyeerekenio kino Yeesu yakoriri, bhakabhuga, “Eheene omuutu wuno niwe omurooti wa Taatabhugya wuno tukwiisigira kubha araaza mukyaaro kino.” ");
INSERT INTO zak_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kyaamwe, Yeesu akamenyeekererya kubha, abhaatu bhayo bhakeenda kumugwaata kwa amanaga, okubha bhamukore omutemi waabhu. Nawe Yeesu akatanura hayo, akagya kweeki mukiguru omweene ego. ");
INSERT INTO zak_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hano yahikiri engoroobha, abhaanabheega bha Yeesu bhakahiriingita kugya ku Nyaanza ya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kwiibhaga riyo, haari kiirima, nawe Yeesu yaari akyaari kubhahikira. Bhakatiira mubhwaato, no okutaanga okwaambuka enyaanza kugya mumugye gwa Kaperinaumu. ");
INSERT INTO zak_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ambe, obhukama bhuhaari bhwaari bhurahuumbuuta ne enyaanza ekabhiiha. ");
INSERT INTO zak_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hano abhaanabheega bha Yeesu bhaahikiri obhutaambi bhwa amataambuka ebhikwe bhitaano (5,000) kasi bhisaasabha (6,000) ego, bhakamurora Yeesu arageenda iguru wa amaanzi no okubhwiisukira obhwaato bhwaabhu. Bhakoobhoha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nawe, Yeesu akabhabhuurira, “Mutoobhoha! Neenye!” ");
INSERT INTO zak_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ambe, ebho bhakeenda atiire mubhwaato. Hayohayo, obhwaato bhukahika kumwaambuko hano bhaari bhakugya. ");
INSERT INTO zak_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tabhoori yaho, esaango ya abhaatu bhano bhakasaaga kumwaambuko oguundi gwe enyaanza, bhakahiita izo yaho hano bhaaruuzi obhwaato bhumwe ego. Kweego bhakamenyeekererya kubha abhaanabheega bha Yeesu bhaari bhatanwiiri abheene, bhataagiiri na Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kyaamwe, abhaatu abhaandi bhakaaza na amaato okurwa mumugye gwa Tiberia, bhakahika hano Omukuru Yeesu yaari amubhuuriiri Taatabhugya, “Ozomirye,” hano esaango ya abhaatu bhaari bhaaririiri emikaate. ");
INSERT INTO zak_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hano esaango ya abhaatu bhayo bhaaruuzi kubha Yeesu atari hayo, na abhaanabheega bhaaye nabho bhataari bhariho, bhakasikira mumaato gayo, bhakagya Kaperinaumu kumumoohya Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hano abhaatu bhayo bhaahikiri kumwaambuko gwe enyaanza, bhakamubhona Yeesu, bhakamubhuurya, “Omweegya, okahika eno ryoori?” ");
INSERT INTO zak_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yeesu akabhakyoora, “Ndabhabhuurira obhuheene, murakomya kwo okubha nikabhaha emikaate, mukarya no okwiiguta, etari kwe ekigirirye mukamenya ebhitiika bhino nikakora. ");
INSERT INTO zak_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mutakora emirimo kwiiguru yo okubhona ebhyaakurya bhino bhikusarika, nawe mubhe murakora emirimo kwiiguru yo okubhona ebhyaakurya bhino bhitakusarika, bhino bhikubhaha obhuhoru bhwa kirakeego. Enye Omwaana wo Omuutu, ndabhaha ebhyaakurya bhiyo, kwo okubha Taata Taatabhugya aniheeri obhuturo bhwo okukora ego.” ");
INSERT INTO zak_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Niho, ebho bhakamubhuurya, “Mbe, tukoreki, okubha tubhone kukora amangʼana gano Taatabhugya akweenda?” ");
INSERT INTO zak_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu akabhakyoora, “Engʼana yino Taatabhugya akweenda mukore, ni kuniikirirya enye wuno yaanitumiri.” ");
INSERT INTO zak_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Hayo bhakamubhuurya, “Orakora ekyeerekenio kiihe, okubha tukirore no okukwiikirirya? Orakora kigiro kiihe? ");
INSERT INTO zak_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bhazaazi bheetu, hano bhaari mukibhara, bhakarya ebhyaakurya bhino bhikubhirikirwa mana. Ekaamirwe mu Makaamo Amahoreeru, ‘Akabhaha ebhyaakurya bhyo okurwa mwiisaaro okubha bharye.’ ” ");
INSERT INTO zak_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ambe, Yeesu akabhabhuurira, “Ndabhabhuurira obhuheene, etari Musa wuno yabhaheeri bhazaazi bheenyu ebhyaakurya bhiyo okurwa mwiisaaro, nawe ni Taata waane. Ewe niwe akubhaha emwe ebhyaakurya bhye eheene okurwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ebhyaakurya bhya Taatabhugya ni bhino bhikwiituuma okurwa mwiisaaro, no okubhaha abhaatu bhoosi bhe ekyaaro obhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Niho bhakamubhuurira, “Omukuru, otuhe ebhyaakurya bhiyo eziisiku zyoosi.” ");
INSERT INTO zak_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yeesu akabhakyoora, “Enye neenye ebhyaakurya bhino bhikubhaha abhaatu obhuhoru bhuyo. Omuutu wowoosi wuno akuuza kweenye no okuniikirirya, atakwiigwa enzara naabhe enyoota kweeki. ");
INSERT INTO zak_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Kyeego bhurya niabhabhuuriiri, munduuzi, nawe mutakuniikirirya. ");
INSERT INTO zak_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abhaatu bhoosi bhano Taata akuuniha, bharaaza kweenye no okuniikirirya. Enye nitakwaanga naabhe wumwe wuno akuuza kweenye, ");
INSERT INTO zak_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","kwo okubha enye nitiiziri okurwa mwiisaaro okubha nibhe ndakora bhurya nikweenda enye, nawe nibhe ndakora kyeego Taata wuno yaanitumiri akweenda. ");
INSERT INTO zak_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Taata waane wuno yaanitumiri areenda nitabhurya naabhe omuutu wumwe mubhano yaniheeri, nawe nibharyoore murusiku rwo obhuteero. ");
INSERT INTO zak_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kino Taata akweenda ni kubha, abhaatu bhoosi bhano bhiikiriirye kubha, enye ni Mwaana waaye no okuniikirirya, bhabhe no obhuhoru bhwa kirakeego. Enye ndabharyoora murusiku rwo obhuteero.” ");
INSERT INTO zak_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ambe, Abhayahudi bha hayo, bhakataanga okuririirira kwe ekigirirye Yeesu akiigaamba, “Enye neenye ebhyaakurya bhino bhiituumiibhwe okurwa mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakiibhuurya, “Mbe, omuutu wuno atari Yeesu, omwaana wa Yusufu, kweeki abhiibhuri bhaaye tubhamenyiri? Bhoono, igabhwi aranagya okugaamba yiituumiri okurwa mwiisaaro?” ");
INSERT INTO zak_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yeesu akabhakyoora, “Mutige okwiiririirira abheene kwa abheene. ");
INSERT INTO zak_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Atariho omuutu wuno akunagya kuuza kweenye, eraabhe akyaari kukaangatibhwa na Taata waane wuno yaanitumiri. Na neenye ndaaza okumuryoora murusiku rwo obhuteero. ");
INSERT INTO zak_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ekaamirwe mu Makaamo Amahoreeru ga abharooti kubha, ‘Abhaatu bhoosi bhareegibhwa na Taatabhugya.’ Ambe, omuutu wowoosi wuno akwiitegeerera no okweega okurwa ku Taata, araaza kweenye. ");
INSERT INTO zak_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Atariho omuutu wuno amuruuzi Taata Taatabhugya, nawe enye omweene nimuruuzi, kwe ekigirirye niarwiiri kweewe. ");
INSERT INTO zak_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ndabhabhuurira obhuheene, omuutu wowoosi wuno akuniikirirya, wuyo ano obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Enye neenye ebhyaakurya bhino bhikubhaha abhaatu obhuhoru bhuyo. ");
INSERT INTO zak_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yiingabha bhazaazi bheenyu bhakarya mana mukibhara, nawe bhakakwa. ");
INSERT INTO zak_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nawe hano bhireho ebhyaakurya bhino bhiituumiibhwe okurwa mwiisaaro. Kyeego omuutu akurya ebhyaakurya bhiyo, atakukwa na rumwe. ");
INSERT INTO zak_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Enye neenye ebhyaakurya bhino bhiituumiibhwe okurwa mwiisaaro, bhino kikubhaha abhaatu obhuhoru bhwa kirakeego. Omuutu wowoosi wuno akurya ebhyaakurya bhiyo, arabha no obhuhoru bhwa kirakeego. Ebhyaakurya bhiyo ni mubhiri gwaane guno ndaaruusye kwiiguru wa abhaatu bhoosi bhe ekyaaro kino, okubha bhabhe no obhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ambe, Abhayahudi bhayo bhakataanga kuhakana bhukongʼu, bhariibhuurya, “Omuutu wuno, igabhwi aranagya kutuhaana omubhiri gwaaye, okubha tugurye?” ");
INSERT INTO zak_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kweego, Yeesu akabhabhuurira, “Ndabhabhuurira obhuheene, eraabhe mutakurya omubhiri gwaane, no okunywa amanyiinga gaane enye Omwaana wo Omuutu, mutakubha no obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Omuutu wowoosi wuno akurya omubhiri gwaane no okunywa amanyiinga gaane, wuyo ano obhuhoru bhwa kirakeego, na neenye ndamuryoora murusiku rwo obhuteero. ");
INSERT INTO zak_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwo obhugazuro bhuyo, omubhiri gwaane nigwe ebhyaakurya bhye eheene, na amanyiinga gaane nigo ekinyweebhwa kye eheene. ");
INSERT INTO zak_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Omuutu wowoosi wuno akurya omubhiri gwaane no okunywa amanyiinga gaane, wuyo ariikara muusi waane, na neenye ndiikara muusi waaye. ");
INSERT INTO zak_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kyeego bhurya Taata waane wuno yantumiri niwe obhweemero bhwo obhuhoru, ego niigo neenye nkubhona obhuhoru bhwaane okurwa kweewe. Egoego, omuutu wowoosi wuno akunirya, arabhona obhuhoru okurwa kweenye. ");
INSERT INTO zak_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ambe, bhiyo nibhyo ebhyaakurya bhino bhiikiituuma okurwa mwiisaaro. Ebhyaakurya bhiyo bhitatuubheeni ne ebhyaakurya bhino bhazaazi bheenyu bhakarya. Ebho bhakakwa. Nawe omuutu wowoosi wuno akurya ebhyaakurya bhino, arabha no obhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yeesu akabhuga amangʼana gayo, eriibhaga rino yaari akweegya munyuumba ye esaango ya Kaperinaumu eyo. ");
INSERT INTO zak_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Hano abhaanabheega bhaaye bhiigwiiri amangʼana gayo, abhaandi bhaabhu bhakabhuga, “Ameegyo gano ni makongʼu bhukongʼu! Weewi akunagya okugiikirirya?” ");
INSERT INTO zak_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yeesu akamenyeekererya, abhaanabheega bhaaye bharaririirira amangʼana gano yaari abhugiri, kweego akabhabhuurya, “Mbe, engʼana yino ebhanyaakirye? ");
INSERT INTO zak_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bhoono, erabhabhwi eraabhe muranirora enye Omwaana wo Omuutu, nikutiira kugya mwiisaaro hano niari ndiho kubhutaangiro? ");
INSERT INTO zak_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ekoro wa Taatabhugya niwe wuno akubhaha abhaatu obhuhoru. Omuutu atakunagya kukora kyokyoosi kwa amanaga gaaye omweene ego. Amangʼana gano nibhabhuuriiri ni ge Ekoro wa Taatabhugya, na garareeta obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nawe bhariho abhaandi gati weenyu bhano bhatakuniikirirya.” Yeesu akabhuga ego, kwo okubha akamenya okurwa obhweemero, ni bhaweewi bhatakumwiikiriirya, na ni weewi wuno akumurya omukoonyo. ");
INSERT INTO zak_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ambe, akageenderera kubhabhuurira, “Kiyo nikyo ekigirirye nibhabhuuriiri, atariho omuutu wuno akunagya okuuza kweenye, eraabhe akyaari kukaangatibhwa na Taata waane.” ");
INSERT INTO zak_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kweemera eriibhaga rino bhiigwiiri amangʼana gayo, bhaaru gati wa abhaanabheega bhaaye, bhakamutiga, bhataageendiri neewe kweeki. ");
INSERT INTO zak_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Niho Yeesu akabhuurya abhaanabheega bhaaye ikumi na bhabhiri, “Mbe, na neemwe mureenda okunitiga?” ");
INSERT INTO zak_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simooni Petero akamukyoora, “Omukuru, tugye kuweewi? Awe omweene ona amangʼana gano gakutuha obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Etwe turakwiikirirya na tumenyiri kubha, awe naawe Muhoreeru wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Niho Yeesu akabhabhuurira, “Nisoriri emwe ikumi na bhabhiri kubha abhaanabheega bhaane, nawe owumwe gati weenyu ni wa Seetaani.” ");
INSERT INTO zak_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hayo Yeesu yaari aramukeerenerya Yuuda, omwaana wa Simooni Isikariyoti. Yuuda wuyo niwe yamuriiri omukoonyo Yeesu, yiingabha yaari owumwe gati wa abhaanabheega bhaaye ikumi na bhabhiri. ");
INSERT INTO zak_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ambe, okuhita gayo, Yeesu akataanga okwiiruguura mukyaaro kya Gariraaya. Ateendiri kwiiruguura mukyaaro kya Yudea, kwo okubha abhakaangati bha Abhayahudi bhaari bhareenda kumwiita. ");
INSERT INTO zak_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Eriibhaga riyo, Enyaangi ye Ebhihuuna ya Abhayahudi yaari yiisukiri. ");
INSERT INTO zak_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Niho bhawamwaabhu Yeesu bhakamubhuurira, “Otasaaga hano, ogye Yudea, okubha abhaanabheega bhaazo bharore ebhitiika bhino okukora. ");
INSERT INTO zak_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Eraabhe omuutu areenda amenyekane kubhaatu, atakukora emirimo gyaaye kwa mbiso. Ambe, kwo okubha oranagya kukora amangʼana gayo, noogye wiiyeerekye kubhaatu bhoosi, okubha bhakumenye.” ");
INSERT INTO zak_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bhawamwaabhu bhakagaamba ego, kwo okubha naabhe ebho abheene bhataamwiikiriirye kubha Yeesu ni Masiya. ");
INSERT INTO zak_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Niho Yeesu akabhabhuurira, “Eriibhaga ryaane, rikyaari kuhika, nawe emwe muranagya kugya eriibhaga ryoryoosi. ");
INSERT INTO zak_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abhaatu bhe ekyaaro kino, bhatana ekigirirye kyo okubhiihirirwa emwe. Nawe bharanibhiihirirya enye, kwe ekigirirye ndabhabhuurira, amahokya gaabhu ni mabhi. ");
INSERT INTO zak_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Emwe abheene, mugye Yerusaremu kuginiha enyaangi. Enye nitakugya, kwe ekigirirye eriibhaga ryaane rikyaari kuhika.” ");
INSERT INTO zak_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hano Yeesu yamariri okugaamba amangʼana gayo, akasaaga Gariraaya. ");
INSERT INTO zak_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nawe hano abhahiiri bhaaye bhaari bhagiiri Yerusaremu kuginiha enyaangi yiyo, Yeesu neewe akagya eyo, nawe kwa mbiso, atiiyeerekirye kubhweero. ");
INSERT INTO zak_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ambe, eriibhaga riyo, abhakaangati bha Abhayahudi bhakataanga kumukomya Yeesu munyaangi yiyo. Bhaari bharabhuurya abhaatu, “Ari hayi omuutu wurya?” ");
INSERT INTO zak_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Abhaatu bhaaru bhaari bharahakana iguru wa Yeesu, abhaandi bhakagaamba, “Ni muutu muzomu,” nawe abhaandi bhaari bharabhuga, “Zeyi, arakaangirirya abhaatu.” ");
INSERT INTO zak_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nawe ataari ariho omuutu wuno yaari akumugaamba Yeesu kubhweero, kwo okubha bhaari bharoobhoha abhakaangati bhayo. ");
INSERT INTO zak_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hano eziisiku zye enyaangi zyahikiri gatigati, Yeesu akagya, akasikira mwiiseengerero, akataanga okweegya abhaatu. ");
INSERT INTO zak_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Niho Abhayahudi bhakaruguura kwa ameegyo gaaye, bhakabhuga, “Mbe, igabhwi omuutu wuno aranagya okumenya goosi gano, neewe akyaari kweegibhwa bhukongʼu?” ");
INSERT INTO zak_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ambe, Yeesu akabhabhuurira, “Ameegyo gano nikweegya, gatari gaane, nawe garwiiri kuwuno yaanitumiri. ");
INSERT INTO zak_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Omuutu wowoosi wuno akweenda kukora bhino Taatabhugya akweenda, wuyo aramenya eraabhe, ameegyo gaane garwiiri ku Taatabhugya, kasi enye ndiigaambira omweene ego. ");
INSERT INTO zak_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Omuutu wowoosi wuno akugaamba kwo obhuturo bhwaaye omweene, wuyo ariikomeerya obhuguungo ewe omweene. Nawe wuno akukomya obhuguungo kuwuno akamutuma, wuyo aragaamba obhuheene, atakugaamba orurimi. ");
INSERT INTO zak_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mumenyiri kubha, Musa akabhaha emigiro gya Taatabhugya. Nawe atariho omuutu gati weenyu wuno akugwaata emigiro giyo. Kwaki mureenda kuniita?” ");
INSERT INTO zak_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Abhaatu bhayo bhakamukyoora, “One eriisaambwa eriibhi awe! Ni weewi wuno akweenda kukwiita?” ");
INSERT INTO zak_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yeesu akabhakyoora, “Nikakora ekitiika kimwe hano murusiku rwo okumuunya, na neemwe bhoosi mukaruguura. ");
INSERT INTO zak_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Rora, Musa akabharagania okusaara abhaana bheenyu abhasubhe. Etari kubha enyaangi yiyo ekarwa ku Musa omweene, nawe ekarweera kubhazaazi bheenyu bho okutaanga. Bhoono naabhe emwe murakora emirimo murusiku rwo okumuunya, kwe ekigirye murasaara abhaana bheenyu abhasubhe naabhe murusiku ruyo. ");
INSERT INTO zak_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ambe naabhe murusiku rwo okumuunya murasaara abhaana, okubha omugiro gwa Musa gutaaza gukasarika. Ndora murantiindira hano nikumuhorya omuutu murusiku rwo okumuunya? ");
INSERT INTO zak_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mutatinira ekiina omuutu kutuukana na amangʼana gano gakurorekana igutu, nawe omutinire ekiina omuutu kwe eheene.” ");
INSERT INTO zak_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ambe, abhaatu abhaandi bha Yerusaremu hayo, bhakabha bhariibhuurya, “Mbe, omuutu wuno atari wuno abhakaangati bheetu bhakweenda kumwiita? ");
INSERT INTO zak_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Rora, bhoono aragaamba kubhweero, nawe ebho bhatakumubhuurira kyokyoosi! Mbe, eraturikana kubha, abhakaangati bheetu neebho bhoosi bhamenyiiri kubha, wuyo niwe Masiya? ");
INSERT INTO zak_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nawe omuutu wuno, tumenyiri hano arwiiri. Hano Masiya omweene akuuza, atariho omuutu wuno akumenya hano arwiiri.” ");
INSERT INTO zak_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hano Yeesu yaari akweegya mwiiseengerero, akatiirya eriiraka akubhuga, “Eheene munimenyiri, na mumenyiri hano nikurwa. Enye nitiiziri kwo obhuturo bhwaane, nawe nikatumwa na Taatabhugya we eheene. Emwe mutamumenyiri. ");
INSERT INTO zak_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Enye nimumenyiri, kwe ekigirirye nirwiiri kweewe, na niwe akaanituma.” ");
INSERT INTO zak_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Niho abhaatu bhakeenda okumugwaata, nawe ataari ariho omuutu wuno akamugwaata, kwe ekigirirye eriibhaga ryaaye ryaari rikyaari kuhika. ");
INSERT INTO zak_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nawe gati wa abhaatu, bhaari bhariho bhaaru bhano bhakamwiikirirya Yeesu. Abhaatu bhayo bhakabhuga, “Hano Masiya araaze, eheene atakuuza kukora ebhitiika bhyaaru kukira bhino omuutu wuno akoriri.” ");
INSERT INTO zak_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ambe, Abhafarisayo bhakiigwa kyeego esaango ya abhaatu bhakumoonyerera ego iguru wa Yeesu. Kweego, Abhafarisayo bhayo, hamwe na abhakuru bha abhaseengeri, bhakaragania abhasirikare okubha bhamugwaate Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Niho Yeesu akabhabhuurira abhaatu bhayo, “Ndabha na neemwe kwe eriibhaga iguhi ego. Okumara ndakyoora kuwuno yaanitumiri. ");
INSERT INTO zak_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Muraankomya, nawe mutakuumbona. Kweeki, hano nkugya enye, emwe mutakunagya kuuza.” ");
INSERT INTO zak_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Niho Abhayahudi bhakakeerenia, “Mbe, omuutu wuno aragya hayi hano etwe tutakunagya okumubhona? Mbe, areenda kugya ku Bhayahudi bhano bhanyarageeni mubhyaaro ebhiindi, no okweegya abhaatu bhano bhatari Abhayahudi? ");
INSERT INTO zak_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mbe, obhugazuro bhwaku niki hano akubhuga, ‘Muraankomya, nawe mutakuumbona. Kweeki, hano nkugya enye, emwe mutakunagya kuuza’?” ");
INSERT INTO zak_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Orusiku rwo okumariirya Enyaangi ye Ebhihuuna, rwaari orusiku orukuru. Ambe, Yeesu akiimeerera mwiiseengerero, akabhuga kwe eriiraka ikuru, “Omuutu akwiigwa enyoota, yiize kweenye, anywe! ");
INSERT INTO zak_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Amakaamo Amahoreeru garabhuga, omuutu wowoosi wuno akuniikirirya enye, ‘Emisabhuko gya amaanzi go obhuhoru giragera okurwa muusi waaye.’ ” ");
INSERT INTO zak_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yeesu yaari arakeerenerya Ekoro Muhoreeru, wuno abhaatu bhoosi bhano bhakumwiikirirya Yeesu bharamusuungʼaana. Eriibhaga riyo, Taatabhugya yaari akyaari kutuma Ekoro waaye kweebho, kwe ekigirirye yaari akyaari kweerekya kubhweero obhuguungo bhwa Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ambe abhaatu abhaandi musaango yiyo bhakiigwa amangʼana gayo, bhakabhuga, “Eheene, omuutu wuno niwe omurooti wurya wuno tukumuganya okurwa ku Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abhaatu abhaandi bhakabhuga, “Omuutu wuno niwe Masiya.” Nawe abhaandi bhakabhuga, “Zeyi, Masiya atakunagya okurwa mukyaaro kya Gariraaya. ");
INSERT INTO zak_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mbe, Amakaamo Amahoreeru gatakugaamba, Masiya ararweera murwiibhuro rwo omutemi Daudi? Kweeki kubha, ariibhurwa mu Beterehemu, mumugye guno Daudi akiibhurwa?” ");
INSERT INTO zak_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kweego abhaatu bhakatwaanikana kwe ekigirirye kya Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Abhaandi bhakeenda okumugwaata, nawe ataari ariho omuutu wuno yasakirye kumugwaata, kwe ekigirirye eriibhaga ryaaye ryaari rikyaari kuhika. ");
INSERT INTO zak_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ambe, abhasirikare bhayo bhakakyoora kubhakuru bha abhaseengeri na Abhafarisayo. Abhakaangati bhayo bhakabhabhuurya, “Kwaki mutaamugwaatiri Yeesu no okumureeta hano?” ");
INSERT INTO zak_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abhasirikare bhayo bhakakyoora, “Tukyaari kwiigwa omuutu owuundi wuno akunagya kugaamba kyeego ewe arabhuga.” ");
INSERT INTO zak_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kyaamwe Abhafarisayo bhakabhabhuurya, “Mbe, naabhe emwe mumariri kukaangiribhwa neewe? ");
INSERT INTO zak_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bhoono ariho omukaangati wowoosi wurya kasi Omufarisayo naabhe wumwe wuno akumwiikirirya? ");
INSERT INTO zak_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nawe abhaatu bhano bhakumwiikirirya, ni saango ya abhaatu bhano bhatamenyiri emigiro gya Musa. Bhiihiimirwe na Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Niho Nikodemo, owumwe wa abhakaangati bha Abhafarisayo wuno yaari amariri kugya ku Yeesu orusiku rumwe obhutiku, akabhuurya abharikyaaye, ");
INSERT INTO zak_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mbe, emigiro gyeetu giriikirirya okumutinira ekiina omuutu eno tukyaari kumwiitegeerera no okumenya gano akoriri?” ");
INSERT INTO zak_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ebho bhakamukyoora Nikodemo, “Mbe, woosi orwiiri Gariraaya? Noogye wiisuunze bhuzomu Amakaamo Amahoreeru, no oramenya kubha, atariho omurooti wuno akurweera Gariraaya!” ");
INSERT INTO zak_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Niho bhayo bhoosi bhakatanura eyo, bhakakyoora yiika. Yeesu neewe akatanura mwiiseengerero, akagya mu Kiguru kye Emizeituni. ");
INSERT INTO zak_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hano bhwakiiri, Yeesu akagya kweeki akasikira mwiiseengerero. Abhaatu bhoosi bhakaaza kweewe, neewe akiikara, akataanga kubheegya. ");
INSERT INTO zak_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kyaamwe, abheegya bhe emigiro gya Musa na Abhafarisayo, bhakamuhirira omukari wumwe wuno yaagwaatirwe ekiroogi, bhakamutuura gatigati we esaango ya abhaatu. ");
INSERT INTO zak_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Bhakamubhuurira Yeesu, “Omweegya, omukari wuno, agwaatirwe ekiroogi. ");
INSERT INTO zak_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Bhoono, kutuukana ne emigiro gya Musa, omukari wuno areenderwa yiitwe kwo okumutema amagina. Ambe, awe orabhugabhwi?” ");
INSERT INTO zak_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ebho bhakamubhuurya ego kwo okumusakya Yeesu, okubha bhabhone ekigirirye kyo okumuzoongera. Nawe Yeesu akiihiinya, akataanga kukaama haasi mumarobha kwe ekyaara kyaaye. ");
INSERT INTO zak_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hano bhaageendereeri okumubhuurya, Yeesu akiimeerera, akabhakyoora, “Eraabhe ariho owumwe gati weenyu wuno akyaari kukora ebhibhi naabhe rugeendo rumwe, wuyo abhe wo okutaanga okumutema eriigina omukari wuno.” ");
INSERT INTO zak_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ambe, Yeesu akiihiinya kweeki haasi, akageenderera kukaama mumarobha. ");
INSERT INTO zak_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hano bhiigwiiri gayo, gakabharumirira mumitima gyaabhu. Bhakataanga kutanura wumwe wumwe, okweemera abhakaruka tee abhamura. Mubhuteero, Yeesu akasaaga omweene ego no omukari wuyo, wuno yaari yiimeereeri embere waaye. ");
INSERT INTO zak_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Niho Yeesu akiimeerera, akamubhuurya, “Maayi, bhari hayi bhano bhakukuzoongera? Mbe, atariho wowoosi wuno asaagiri okubha akutinire ekiina?” ");
INSERT INTO zak_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akamukyoora, “Omukuru, atariho naabhe wumwe.” Ambe, Yeesu akamubhuurira, “Naabhe enye nitakukutinira ekiina. Noogye, nawe kweemera reero, otakora ebhibhi kweeki.” ");
INSERT INTO zak_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ambe, Yeesu akageenderera kugaamba ne esaango, akabhuga, “Enye neenye obhweero bhwe ekyaaro. Omuutu wowoosi wuno akunituniirira enye, atakugeenda mukiirima na rumwe, nawe arabha no obhweero bhuno bhukumukaangata mubhuhoru bhwa kirakeego.” ");
INSERT INTO zak_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abhafarisayo bhakamubhuurira Yeesu, “Awe oriigaambira omweene. Obhumenyeekererya bhwaazo bhutari bhwe eheene!” ");
INSERT INTO zak_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yeesu akabhakyoora, “Yiingabha ndiimenyeekererya omweene, obhumenyeekererya bhwaane ni bhwe eheene. Enye nimenyiri hano nikurwa, kweeki nimenyiri hano nikugya. Nawe emwe mutamenyiri hano nikurwa na hano nikugya. ");
INSERT INTO zak_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Emwe muranitinira ekiina kuriingʼaana na amiiseego ga abhaatu, nawe enye nitakumutinira ekiina omuutu wowoosi. ");
INSERT INTO zak_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nawe, eraabhe enye ndatinira ekiina omuutu, ndamutinira ekiina kwe eheene, kwo okubha enye nitari omweene ego, nawe niri hamwe na Taata wuno yantumiri. ");
INSERT INTO zak_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mumigiro gyeenyu ekaamirwe kubha, obhumenyeekererya bhwa abhaatu bhabhiri bhuriisigirwa kubha bhwe eheene. ");
INSERT INTO zak_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ambe, enye ndiigaambira omweene, na Taata wuno akaanituma neewe aranimenyeekererya.” ");
INSERT INTO zak_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Niho Abhafarisayo bhakamubhuurya Yeesu, “Wuuso weenyu ari hayi?” Yeesu akabhakyoora, “Emwe mutanimenyiri enye, naabhe Taata waane mutamumenyiri. Eraabhe muunganimenyiri enye, ambe muungamumenyiri na Taata woosi.” ");
INSERT INTO zak_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yeesu akabhuga gayo goosi, eriibhaga rino yaari areegya mwiiseengerero, ahagiro hano bhaari bhakutuura eziihuunguro zye ekimweeso. Nawe ataari ariho omuutu wuno akamugwaata, kwe ekigirirye eriibhaga ryaaye ryaari rikyaari kuhika. ");
INSERT INTO zak_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ambe, Yeesu akabhabhuurira Abhafarisayo bhayo kweeki, “Enye ndagya, na neemwe muraankomya, nawe murakwa kwiiguru we ebhibhi bhyeenyu. Hano nkugya enye, emwe mutakunagya kuuza.” ");
INSERT INTO zak_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Niho abhakaangati bha Abhayahudi bhakataanga okwiibhuurya, “Kwaki arabhuga, tutakunagya okumutuniirira hano akugya? Mbe, aragya okwiiyiita?” ");
INSERT INTO zak_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yeesu akageenderera kubhabhuurira, “Emwe murweereeri haasi hano, nawe enye nirweereeri iguru mwiisaaro. Emwe ni bhe ekyaaro kino, nawe enye nitari we ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nikyo ekigirirye nikabhabhuurira, murakwa kwiiguru we ebhibhi bhyeenyu. Ambe, eraabhe mutakwiikirirya kubha ‘Enye Neenye,’ murakwa kwiiguru we ebhibhi bhyeenyu.” ");
INSERT INTO zak_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Neebho bhakamubhuurya, “Otubhuurire, awe ni weewi?” Yeesu akabhakyoora, “Nibhabhuuriiri okurwa obhweemero kubha enye ni weewi! ");
INSERT INTO zak_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nina amangʼana maaru gano nikunagya kugaamba iguru weenyu no okubhatinira ekiina. Nawe nitakukora ego, enye ndabhabhuurira abhaatu bhe ekyaaro kino amangʼana gano niigwiiri okurwa kweewe, kwo okubha wuno yantumiri ni we eheene.” ");
INSERT INTO zak_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hano bhiigwiiri gayo, bhataamenyiri kubha yaari aragaamba nabho iguru wa Wiise waabhu wa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ambe, Yeesu akabhabhuurira, “Hano muraamutiirye Omwaana wo Omuutu okubha mumwiite, hayo niho muraamenye kubha enye niwe ewe. Kweeki muramenya kubha goosi gano nikukora, nitakukora kwo obhuturo bhwaane, nawe ndagagaamba kyeego Taata waane akaaniegya. ");
INSERT INTO zak_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wuno yantumiri ari hamwe na neenye. Akyaari kunitiga omweene ego, kwe ekigirirye eriibhaga ryoosi ndakora gano gakumuzomera.” ");
INSERT INTO zak_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hano Yeesu yabhugiri amangʼana gayo, abhaatu bhaaru bhakamwiikirirya. ");
INSERT INTO zak_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ambe, Yeesu akabhabhuurira Abhayahudi bhano bhakamwiikirirya, “Eraabhe murageenderera kugwaata ameegyo gaane, hayo niho mubheeri abhaanabheega bhaane bhe eheene. ");
INSERT INTO zak_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kweeki muramenya obhuheene, no obhuheene bhuyo bhurabhatuura mubhwiiragaanzi.” ");
INSERT INTO zak_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ebho bhakamubhuurya, “Etwe ni bhiibhurwa bha Aburahamu. Tukyaari kukorwa abhagya bho omuutu wuyo woosi. Kwaki orabhuga kubha etwe turabha abhiiragaanzi?” ");
INSERT INTO zak_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yeesu akabhakyoora, “Ndabhabhuurira obhuheene, omuutu wowoosi wuno akugeenderera okukora ebhibhi, wuyo ni mugya we ebhibhi. ");
INSERT INTO zak_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Omugya atakwiikara munyuumba yo omukuru waaye eziisiku zyoosi, nawe omwaana niwe akusaaga munyuumba eziisiku zyoosi. ");
INSERT INTO zak_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kweego, eraabhe enye Omwaana wa Taatabhugya nibhiiguriiri okurwa mubhibhi bhyeenyu, mutakubha abhagya kweeki, nawe murabha abhiiragaanzi eheene. ");
INSERT INTO zak_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nimenyiri kubha, emwe ni bho orwiibhuro rwa Aburahamu. Nawe mureenda kuniita, kwe ekigirirye muraanga okwiikirirya gano nikubheegya. ");
INSERT INTO zak_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Enye ndabhabhuurira gano niruuzi ku Taata waane, nawe emwe murakora gano wuuso weenyu abheegirye.” ");
INSERT INTO zak_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ebho bhakamukyoora, “Aburahamu niwe taata weetu!” Yeesu akabhabhuurira, “Eraabhe heene ni bhiibhurwa bha Aburahamu, muungakoriri gano Aburahamu yaari akukora. ");
INSERT INTO zak_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nawe bhoono murakomya enzira yo okuniita, yiingabha nibhabhuuriiri obhuheene bhuno niigwiiri okurwa ku Taatabhugya. Aburahamu ataakoriri ego kyeego mukweenda kukora bhoono. ");
INSERT INTO zak_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amahokya gano emwe mukukora, gararwa ku wuuso weenyu owuundi.” Niho bhakamukyoora, “Etwe tutari bhigwi ibhaanza. Taatabhugya omweene ego niwe Taata weetu!” ");
INSERT INTO zak_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yeesu akabhakyoora, “Eraabhe Taatabhugya yiingabheeri Wuuso weenyu, muunganiseegiri, kwe ekigirirye nirwiiri ku Taatabhugya, na bhoono niri hano. Enye nitiiziri kwo obhuturo bhwaane, nawe ni Taatabhugya niwe akaanituma. ");
INSERT INTO zak_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kwaki mutamenyiri gano nikugaamba? Ni kwe ekigirirye mutakweenda okwiitegeerera ameegyo gaane. ");
INSERT INTO zak_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Emwe ni bha Seetaani, wuyo niwe wuuso weenyu! Kweego mureenda kukora gano wuuso weenyu akwiigoomba. Seetaani ni mwiiti kweema obhweemero. Atakuseega bhukongʼu obhuheene, kwo okubha obhuheene bhutarimu mukoro yaaye. Seetaani aragaamba orurimi, niyo eteemwa yaaye, kwe ekigirirye omweene ni mubheehi, kweeki niwe taata wo orurimi rwoosi. ");
INSERT INTO zak_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nawe kwo okubha enye ndabhabhuurira obhuheene, mutakuniikirirya. ");
INSERT INTO zak_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni weewi gati weenyu wuno akunagya okumenyeekererya kubha enye nitemirye ebhibhi? Eraabhe ndabhabhuurira obhuheene, kwaki mutakuniikirirya? ");
INSERT INTO zak_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Omuutu wowoosi wuno ni wa Taatabhugya, wuyo ahiigwa amangʼana gaaye. Emwe mutakwiigwa gano Taatabhugya akubhuga, kwe ekigirirye emwe mutari bhaatu bhaaye.” ");
INSERT INTO zak_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Abhayahudi bhakamubhuurya Yeesu, “Mbe, tutakugaamba obhuheene turibhuga, awe ni Musamaria, kweeki one eriisaambwa eriibhi?” ");
INSERT INTO zak_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yeesu akabhakyoora, “Enye nitana eriisaambwa. Enye ndamusuuka Taata waane, nawe emwe mutakunisuuka. ");
INSERT INTO zak_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Enye nitakwiikomeerya omukumo, nawe ariho owuundi wuno akweenda okunikumya, kweeki niwe akubha omutini we ekiina we eheene. ");
INSERT INTO zak_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ndabhabhuurira obhuheene, omuutu wowoosi wuno akugwaata ameegyo gaane, atakukwa na rumwe.” ");
INSERT INTO zak_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ambe, Abhayahudi bhayo bhakamubhuurira Yeesu, “Bhoono tumenyiri kubha, awe one eriisaambwa eriibhi! Aburahamu akakwa, na abharooti nabho bhakakwa. Nawe awe orabhuga, ‘Omuutu wowoosi wuno akugwaata ameegyo gaane, atakukwa na rumwe.’ ");
INSERT INTO zak_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mbe, oriikora kubha mukuru kukira zaazi weetu Aburahamu? Ewe akakwa, na abharooti nabho bhakakwa. Mbe, awe oriikora kubha ni weewi?” ");
INSERT INTO zak_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yeesu akabhakyoora, “Eraabhe ndiikumya omweene, okwiikumya kwaane kutana obhugazuro bhwobhwoosi. Nawe Taata waane, wuno emwe mukugaamba kubha ni Taatabhugya weenyu, niwe akunikumya. ");
INSERT INTO zak_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Emwe mutamumenyiri Taatabhugya, nawe enye nimumenyiri. Eraabhe niingagaambiri kubha nitamumenyiri Taatabhugya, ambe niingabheeri mubheehi kye emwe. Nawe enye nimumenyiri Taatabhugya, kweeki ndagwaata gano akubhuga. ");
INSERT INTO zak_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Zaazi weenyu Aburahamu, akazomererwa bhukongʼu okurora eziisiku zyaane. Hano yaziruuzi, akazomererwa bhukongʼu.” ");
INSERT INTO zak_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ambe, Abhayahudi bhakamubhuurira Yeesu, “Awe okyaari kuhikya emyaaka miroongo etaano (50). Okamurorabhwi Aburahamu?” ");
INSERT INTO zak_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu akabhakyoora, “Ndabhabhuurira obhuheene, hano Aburahamu yaari akyaari kwiibhurwa, enye ndiho.” ");
INSERT INTO zak_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hano Abhayahudi bhiigwiiri gayo, bhakatoora amagina okubha bhamuteme nago no okumwiita. Nawe Yeesu akiibhisa, akatanura mwiiseengerero. ");
INSERT INTO zak_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Orusiku rumwe, hano Yeesu yaari akugeenda kunzira, akamurora omuutu wumwe wuno akiibhurwa muhoku. ");
INSERT INTO zak_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abhaanabheega bhaaye bhakamubhuurya, “Omweegya, omuutu wuno akiibhurwa muhoku kwe ekigirirye kye ebhibhi bhya weewi? Yaari kwe ekigirirye kye ebhibhi bhyo omuutu wuno omweene, kasi kya abhiibhuri bhaaye?” ");
INSERT INTO zak_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeesu akabhakyoora, “Wuno atari muhoku kwe ekigirirye kye ebhibhi bhyaaye, kasi ebhibhi bhya abhiibhuri bhaaye. Nawe akiibhurwa muhoku, okubha emirimo gya Taatabhugya girorekane kubhaatu mubhwiikari bhwaaye. ");
INSERT INTO zak_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tureenderwa kukora emirimo gya Taatabhugya wuno yaanitumiri, eriibhaga rikyaari mumwiisi. Obhutiku bhuraaza, hano tutakunagya kukora emirimo giyo. ");
INSERT INTO zak_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eriibhaga rino nikyaari niriho mukyaaro kino, enye ni bhweero kubhaatu bhoosi.” ");
INSERT INTO zak_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hano Yeesu yamariri okugaamba amangʼana gayo, akatwa amate mubhutoto, akakonya obhutoto na amate, akahaka amatoto mumeeso go omuhoku wuyo. ");
INSERT INTO zak_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kyaamwe akamubhuurira omuhoku wuyo, “Noogye wiisaabhe obhusyo mukisima kya Siroamu.” Siroamu, obhugazuro bhwaku ni wuno atumirwe. Niho omuhoku wuyo akagya, akiisaabha obhusyo, akagya mumugye gwaaye ararora. ");
INSERT INTO zak_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ambe, abhanyaroobho bhaaye na abhaandi bhano bhaari bhanariri kumurora arasabhasabha, bhakiibhuurya, “Mbe, omuutu wuno atari wurya yaari akwiikara no okusabhasabha?” ");
INSERT INTO zak_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abhaandi bhakabhuga, “Niwe.” Abhaandi bhakabhuga, “Atari ewe, nawe atuubheeni neewe bhukongʼu.” Nawe ewe omweene akabhabhuurira, “Ni heene, ni neenye.” ");
INSERT INTO zak_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Niho bhakamubhuurya, “Eraabhe naawe, igabhwi ameeso gaazo gabhweeni okurora?” ");
INSERT INTO zak_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Akabhakyoora, “Omuutu owumwe wuno akubhirikirwa Yeesu, akatwa amate mubhutoto, akakonya obhutoto, akahaka obhutoto mumeeso gaane. Kyaamwe akaanibhuurira, ‘Noogye wiisaabhe obhusyo mukisima kya Siroamu.’ Ambe nikagya, nikiisaabha, nikarora.” ");
INSERT INTO zak_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ebho bhakamubhuurya, “Mbe, omuutu wuyo ari hayi?” Neewe akabhakyoora, “Enye nitamenyiri.” ");
INSERT INTO zak_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ambe, bhakamuhira wuno yaari omuhoku ku Bhafarisayo. ");
INSERT INTO zak_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Orusiku runo Yeesu yakonyiri obhutoto na amate, no okuhorya omuhoku wuyo, rwaari orusiku rwo okumuunya. ");
INSERT INTO zak_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ambe, Abhafarisayo nabho bhakamubhuurya omuutu wuyo kyeego yahoriri. Akabhakyoora, “Akaanihaka obhutoto mumeeso, nikiisaabha, na bhoono ndarora.” ");
INSERT INTO zak_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Niho Abhafarisayo abhaandi bhakabhuga, “Omuutu wuno akoriri ego ataarwiiri ku Taatabhugya, kwo okubha arasarya emigiro gyo orusiku rwo okumuunya.” Nawe abhaandi bhakabhuga, “Mbe, omuutu we ebhibhi aranagyabhwi kukora ebhitiika ebhikuru bhiyo?” Kweego, bhakahabhana abheene kwa abheene. ");
INSERT INTO zak_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Niho, Abhafarisayo bhakamubhuurya kweeki, “Omuutu wuno akuhorirye ameeso gaazo, orabhugabhwi iguru waaye?” Neewe akabhakyoora, “Enye ndarora omuutu wuyo ni murooti wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nawe abhakaangati bhayo bha Abhayahudi bhatiikiriirye, omuutu wuno ararora bhoono, yaari yiibhwiirwe muhoku. Kweego, bhakabhirikira abhiibhuri bhaaye. ");
INSERT INTO zak_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bhakabhabhuurya, “Mbe, omuutu wuno ni mwaana weenyu? Ni heene akiibhurwa muhoku? Eraabhe niigo, aranagyabhwi kurora bhoono?” ");
INSERT INTO zak_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Niho abhiibhuri bhaaye bhakabhakyoora, “Etwe tumenyiri kubha wuno ni mwaana weetu, tukamwiibhura muhoku. ");
INSERT INTO zak_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nawe tutamenyiri kyeego ahoriri, kweeki tutamumenyiri omuutu wuno amuhorirye ameeso gaaye. Mumubhuurye omweene, kwo okubha ni muutu mugima, aranagya okugaamba omweene.” ");
INSERT INTO zak_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abhiibhuri bhaaye bhakagaamba ego, kwe ekigirirye bhaari bharoobhoha abhakaangati bha Abhayahudi. Abhakaangati bhayo bhaari bhiikirireenie kubha, omuutu wowoosi wuno akwiikirirya Yeesu niwe Masiya, araheebhwa okurwa muziinyuumba zye eziisaango zyaabhu. ");
INSERT INTO zak_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nikyo kikagirya abhiibhuri bhayo bhaabhugiri, “Mumubhuurye omweene, kwo okubha ni muutu mugima.” ");
INSERT INTO zak_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ambe, abhakaangati bha Abhayahudi bhakamubhirikira kweeki omuutu wuno yaari muhoku, bhakamubhuurira, “Wiirahire ku Taatabhugya kubha, oragaamba obhuheene. Etwe tumenyiri omuutu wuno yakuhorirye, ni mutemya we ebhibhi.” ");
INSERT INTO zak_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Neewe akabhakyoora, “Enye nitamenyiri eraabhe omuutu wuyo ni mutemya we ebhibhi, nawe kino nimenyiri ni kigiro kimwe ego. Niari muhoku, nawe bhoono ndarora.” ");
INSERT INTO zak_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kyaamwe bhakamubhuurya, “Mbe, omuutu wuyo akakukoreraki? Akahoryabhwi ameeso gaazo?” ");
INSERT INTO zak_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Neewe akabhakyoora, “Nimariri kubhabhuurira amangʼana gayo, nawe mutaaniitegeereeri. Kwaki mureenda nibhabhuurire kweeki? Mbe, na neemwe mureenda kubha abhaanabheega bhaaye?” ");
INSERT INTO zak_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ambe, ebho bhakamutuka, “Awe naawe omwaanamweega waaye! Nawe etwe ni bhaanabheega bha Musa. ");
INSERT INTO zak_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tumenyiri kubha Taatabhugya akagaamba na Musa, nawe omuutu wuyo tutamenyiri hano arwiiri.” ");
INSERT INTO zak_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Neewe akabhakyoora, “Enye ndaruguura bhukongʼu! Mutamenyiri hano arwiiri, nawe wuyo niwe anihorirye ameeso! ");
INSERT INTO zak_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumenyiri, Taatabhugya atakwiigwa amasabhi ga abhatemya bhe ebhibhi, nawe ariigwa omuutu wowoosi wuno akumwiigwa no okukora gano Taatabhugya akweenda. ");
INSERT INTO zak_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kweema ekare, tukyaari kwiigwa naabhe rugeendo rumwe kubha, omuutu ahorirye omuutu wuno akiibhurwa muhoku. ");
INSERT INTO zak_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Eraabhe omuutu wuyo ataarweereeri ku Taatabhugya, atiinganagirye kukora gayo.” ");
INSERT INTO zak_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ebho bhakamukyoora, “Awe okiibhurwa no okukiinibhwa kyo omutemya we ebhibhi. Bhoono awe ono obhuturoki bhwo okutweegya etwe?” Ambe, bhakamuhurukya igutu. ");
INSERT INTO zak_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Hano Yeesu yiigwiiri kubha bhamuheebhiri omuutu wuyo, akagya kumumoohya. Hano akamubhona, akamubhuurya, “Mbe, oramwiikirirya Omwaana wo Omuutu?” ");
INSERT INTO zak_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Omuutu wuyo akamukyoora, “Omukuru, onibhuurire Omwaana wo Omuutu ni weewi, okubha nibhe ndamwiikirirya.” ");
INSERT INTO zak_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu akamubhuurira, “Awe omariri okumurora, kweeki niwe wuno akukeerenia na naawe.” ");
INSERT INTO zak_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Omuutu wuyo akabhuga, “Ndakwiikirirya, Omukuru.” Niho akamuseengera. ");
INSERT INTO zak_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ambe, Yeesu akabhuga, “Enye nikaaza mukyaaro hano okutinira ekiina, okubha abhahoku bharore, na bhano bhakurora, bhabhe abhahoku.” ");
INSERT INTO zak_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Niho, Abhafarisayo abhaandi bhano bhaari hayo, hano bhakiigwa amangʼana gayo, bhakamubhuurya, “Mbe, orabhuga kubha naabhe etwe turi bhahoku?” ");
INSERT INTO zak_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu akabhakyoora, “Muungabheeri bhahoku, mutiingabheeri abhatemya bhe ebhibhi. Nawe kwo okubha murabhuga kubha murarora bhuzomu, kweego murasaaga ne ebhibhi bhyeenyu.” ");
INSERT INTO zak_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yeesu akageenderera okugaamba, “Ndabhabhuurira obhuheene, omuutu wuyo woosi wuno atakusikira kuhitira mukisyooko kye eriibhaanza rye eziingʼoondu, nawe arasikirira ahaandi, wuyo ni mwiibhi no omuteesya. ");
INSERT INTO zak_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nawe wuno akusikira kuhitira mukisyooko kye eriibhaanza, wuyo ni muriisya we eziingʼoondu. ");
INSERT INTO zak_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Omuriibhi we eriibhaanza ahaasyookora ekisyooko, ne eziingʼoondu zihiigwa eriiraka ryo omuriisya. Omuriisya ahaayibhirikira engʼoondu yimwe yimwe eriina ryaaye no okuzikaangata kugya igutu. ");
INSERT INTO zak_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hano akumara okuruusya eziingʼoondu zyaaye igutu, ahaakaangata embere, nazyo zihaamutuniirira, kwe ekigirirye zimenyiri eriiraka ryaaye. ");
INSERT INTO zak_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Eziingʼoondu zitakunagya okumutuniirira omugini, nawe zihaamungʼosa, kwo okubha zitamenyiri eriiraka ryaaye.” ");
INSERT INTO zak_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yeesu akabhabhuurira Abhafarisayo ekireengyo kino, nawe ebho bhataamenyiri gano yaari akubhabhuurira. ");
INSERT INTO zak_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ambe, Yeesu akabhabhuurira kweeki, “Ndabhabhuurira obhuheene, enye neenye ekisyooko kino eziingʼoondu zikuhita okusikirira mwiibhaanza. ");
INSERT INTO zak_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhoosi bhano bhaanikaangatiiri kubha abhariisya bhe eziingʼoondu, bhaari abhiibhi kweeki abhateesya, nawe eziingʼoondu zitaabhiitegeereeri. ");
INSERT INTO zak_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Enye neenye ekisyooko kiyo. Wowoosi wuno akusikira mwiibhaanza kuhitira kweenye aratuuribhwa, kweeki arabha mwiiragaanzi kusikira no okurekamu, no okugya mukiriisyo ekizomu. ");
INSERT INTO zak_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Omwiibhi araaza mwiibhaanza okubha yiibhe eziingʼoondu, okuziita no okusarya. Nawe enye niiziri okubha mubhe no obhuhoru, kweeki mubhe no obhuhoru bhuyo kwo obhwaaru. ");
INSERT INTO zak_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Enye neenye omuriisya omuzomu. Omuriisya omuzomu araruusya obhuhoru bhwaaye kwiiguru ye eziingʼoondu zyaaye. ");
INSERT INTO zak_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Omuhokya wuno atari muriisya we eziingʼoondu ne eziingʼoondu zitari zyaaye, eraabhe aruuzi esuuzi eraaza, arangʼosa no okutiga eziingʼoondu ezyeene ego. Kweego, esuuzi erarwaania eziingʼoondu no okuzinyaragania. ");
INSERT INTO zak_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Omuhokya arangʼosa, kwo okubha atakumura eziingʼoondu ziyo. ");
INSERT INTO zak_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Enye neenye omuriisya omuzomu. Nimenyiri bhuzomu eziingʼoondu zyaane, nazyo zinimenyiri, ");
INSERT INTO zak_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","kyeego Taata akunimenya enye, na neenye ndamumenya Taata. Enye ndabhuruusya obhuhoru bhwaane kwiiguru we eziingʼoondu zyaane. ");
INSERT INTO zak_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Enye nine eziingʼoondu eziindi zino zitari zya mwiibhaanza rino, zyoosi ndeenderwa nizireete. Eziingʼoondu ziyo zyoosi, zihiigwa eriiraka ryaane. Kweego, zirabha ihizo rimwe, kurabha no omuriisya wumwe. ");
INSERT INTO zak_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taata anseegiri, kwo okubha ndaruusya obhuhoru bhwaane, okubha nibhugege kweeki. ");
INSERT INTO zak_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Atariho omuutu wuno akunagya okuniteesya obhuhoru bhwaane. Neenye omweene nikuruusya obhuhoru bhwaane. Nino obhuturo bhwo okuruusya obhuhoru bhwaane, kweeki nino obhuturo bhwo okugega obhuhoru kweeki. Ego niigo Taata omweene yaaniswaagirye nikore.” ");
INSERT INTO zak_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hano bhiigwiiri amangʼana gayo, Abhayahudi bhakahabhana abheene kwa abheene. ");
INSERT INTO zak_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abhaaru gati waabhu bhakabhuga, “Wuno ane eriisaambwa eriibhi! Kweeki ni muyaanga! Kwaki muramwiitegeerera?” ");
INSERT INTO zak_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nawe abhaandi bhakabhuga, “Amangʼana gayo gatakurwa kumuutu wuno atiirirwe eriisaambwa eriibhi. Mbe, eriisaambwa eriibhi riranagya okumukora omuhoku arore?” ");
INSERT INTO zak_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ambe, Yerusaremu eyo, ryaari rihikiri eriibhaga rye enyaangi ya Abhayahudi yo obhuhiiti bhwo okweerya eriiseengerero rya Taatabhugya. Eriibhaga riyo, ryaari rye embeho. ");
INSERT INTO zak_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeesu yaari arageenda mwiiseengerero, ahagiro hano hakubhirikirwa Eriibhaanza rya Soromooni. ");
INSERT INTO zak_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Abhakaangati bha Abhayahudi bhakamwiiruguura, bhakamubhuurya, “Bhoono, oratunyaakya muziikoro zyeetu tee ryoori? Eraabhe awe naawe Masiya, otubhuurire mwaasi.” ");
INSERT INTO zak_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nawe Yeesu akabhakyoora, “Enye nimariri kubhabhuurira ego, nawe emwe mutakuniikirirya. Ebhitiika bhino nikukora kwo obhuturo bhwa Taata, nibhyo bhikunimenyeekererya kubha enye ni weewi. ");
INSERT INTO zak_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nawe muraanga kuniikirirya, kwe ekigirirye emwe mutari eziingʼoondu zyaane. ");
INSERT INTO zak_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Eziingʼoondu zyaane zihiigwa eriiraka ryaane. Enye nizimenyiri, zyoosi ziranituniirira. ");
INSERT INTO zak_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Enye ndaziha obhuhoru bhwa kirakeego, na zitakusika na rumwe. Na atariho omuutu wuno akunagya okuzisaakura okurwa mumabhoko gaane. ");
INSERT INTO zak_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taata waane aniheeri eziingʼoondu ziyo, na niwe omukuru kukira bhoosi. Kweeki atariho omuutu wuno akunagya okuzisaakura mumabhoko gaaye. ");
INSERT INTO zak_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Enye na Taata ni bhamwe.” ");
INSERT INTO zak_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hayo niho abhakaangati bha Abhayahudi bhakatoora amagina kweeki, okubha bhamuteme nago no okumwiita. ");
INSERT INTO zak_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nawe Yeesu akabhabhuurira, “Nibheerekirye emirimo myaaru mizomu gino niakoriri kwa amanaga ga Taata. Ni ngʼanaki yino ekubhakora emwe mweende okuuntema na amagina?” ");
INSERT INTO zak_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Abhakaangati bha Abhayahudi bhakamukyoora, “Tutakweenda kukutema na amagina kwe ekigirirye kyo okukora amangʼana amazomu, nawe kwe ekigirirye oramutuka Taatabhugya. Oriigaamba kubha awe ni Taatabhugya, eriibhaga awe ni muutu kya abhaandi!” ");
INSERT INTO zak_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yeesu akabhabhuurya, “Mbe, ekyaari kukaamwa mu Makaamo geenyu ge emigiro kubha Taatabhugya akabhuga, ‘Emwe ni misaambwa’? ");
INSERT INTO zak_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Etwe tumenyiri Amakaamo Amahoreeru gatakutubhuuzikana. Kyeego ekaamirwe kubha, Taatabhugya yabhabhirikiiri abhaatu emisaambwa bhano bhasuungʼaaniri amangʼana gaaye, ");
INSERT INTO zak_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ambe kwaki murabhuga kubha enye ndamutuka Taatabhugya hano nikwiibhirikira, ‘Enye ni Mwaana wa Taatabhugya’? Enye niinye wuno Taata yanierirye no okunitumania mukyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eraabhe nitakukora emirimo gya Taata, ambe mutige kuniikirirya. ");
INSERT INTO zak_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nawe eraabhe ndakora emirimo gya Taata, eraabhe mutakuniikirirya enye, ambe mwiikiriirye emirimo giyo. Niho muraamenye, Taata ari muusi waane, na neenye niri muusi wa Taata.” ");
INSERT INTO zak_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hano Abhayahudi bhiigwiiri amangʼana gayo, bhakeenda okumugwaata kweeki, nawe Yeesu akamyooka mumabhoko gaabhu. ");
INSERT INTO zak_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ambe, Yeesu akagya kweeki kumwaambuko gwe Ekitaaro kya Yorodaani, akahika hano Yohana yaari akubatiiza abhaatu hayo kubhutaangiro. Akiikara eyo siku suuhu. ");
INSERT INTO zak_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Abhaatu bhaaru bhakamuuzaku, bhakabhuga, “Yohana ataakoriri ekyeerekenio naabhe rumwe, nawe amangʼana goosi gano yaari akubhuga iguru wa Yeesu, gaari ge eheene.” ");
INSERT INTO zak_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Abhaatu bhaaru bhano bhaari bhariho hayo, bhakamwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yaariho omuutu wumwe eriina ryaaye Razaro, yaari murweeri. Yaari ariikara mukyaaro kya Betania hamwe na abhasubhaati bhaaye, Mariamu na Marita. ");
INSERT INTO zak_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariamu wuyo, yaari musubhaati wo omurweeri Razaro, niwe yamuhakiri Omukuru Yeesu amaguta go omuruumbaaso, no okumutarikya amaguru ne eziinzweeri zyaaye. ");
INSERT INTO zak_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ambe, Mariamu na Marita bhakaragania amangʼana ku Yeesu, “Omukuru, omusaani waazo Razaro ni murweeri.” ");
INSERT INTO zak_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hano Yeesu yiigwiiri amangʼana gayo, akabhuga, “Obhurweeri bhuyo bhutari bhwo okumwiita, nawe ni bhwo okweerekya obhuguungo bhwa Taatabhugya. Arwaariri okubha obhuguungo bhwo Omwaana wa Taatabhugya, bhurorekane.” ");
INSERT INTO zak_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yeesu akabhaseega bhukongʼu Marita, Mariamu na Razaro. ");
INSERT INTO zak_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nawe hano Yeesu yiigwiiri kubha Razaro ni murweeri, akageenderera kwiikara ahagiro hayo siku ibhiri. ");
INSERT INTO zak_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hano eziisiku ibhiri ziyo zyahitiri, Yeesu akabhabhuurira abhaanabheega bhaaye, “Tukyoore Yudea.” ");
INSERT INTO zak_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abhaanabheega bhaaye bhakamukyoora, “Omweegya, ni ibhaga iguhiigo abhakaangati bha Abhayahudi bhakeenda kukutema na amagina okubha bhakwiite. Ambe kwaki oreenda kugya eyo kweeki?” ");
INSERT INTO zak_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yeesu akabhakyoora, “Mbe, omwiisi gutana eziisa ikumi ni ibhiri? Eraabhe omuutu arageenda mumwiisi, atakunagya okwiitema okuguru kwaaye, kwe ekigirirye arabhurora obhweero bhwe ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nawe wuno akugeenda obhutiku, ariitema kwe ekigirirye obhweero bhwo okumusakirya bhutariho.” ");
INSERT INTO zak_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hano Yeesu yabhugiri gayo, akageenderera kubhabhuurira abhaanabheega bhaaye, “Omusaani weetu Razaro ahiindiiri eziitiro, nawe ndagya kumubhuukya.” ");
INSERT INTO zak_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ambe, abhaanabheega bhaaye bhakamukyoora, “Ee Omukuru, eraabhe ahiindiiri, arahora.” ");
INSERT INTO zak_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yeesu yaari aragaamba, Razaro akuuri, nawe abhaanabheega bhaaye bhakiiseega abhugiri ahiindiiri eziitiro. ");
INSERT INTO zak_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ambe, Yeesu akabhabhuurira mwaasi, “Razaro akuuri. ");
INSERT INTO zak_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nawe, enye ndazomererwa kubha nitaari ndiho eriibhaga rino Razaro akukwa, okubha emwe muniikirirye. Ambe, tugeende kweewe.” ");
INSERT INTO zak_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ambe, omwaanamweega wumwe eriina ryaaye Tomaso wuno bhakamubhirikira Mbasa, akabhabhuurira abhaanabheega abharikyaaye, “Na neetwe tugye, okubha tukwe hamwe neewe.” ");
INSERT INTO zak_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ambe, hano Yeesu yahikiri mukyaaro kya Yudea mumugye gwa Betania, akabhona Razaro yaari amariri siku inye mumbiihira. ");
INSERT INTO zak_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Omugye gwa Betania gwaari kya amataambuka ebhikwe bhitatu (3,000) ego okurwa Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abhayahudi bhaaru bhakaaza Betania kubhagosorerya Marita na Mariamu, kwe ekigirirye kyo oruku rwa Razaro mura waabhu. ");
INSERT INTO zak_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ambe, hano Marita yiigwiiri kubha Yeesu yaari araaza, akagya kumusuungʼaana, nawe Mariamu akasaaga munyuumba. ");
INSERT INTO zak_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marita akamubhuurira Yeesu, “Ee Omukuru, eraabhe wuungabheeriho hano, mura weetu atiingakuuri. ");
INSERT INTO zak_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nawe naabhe bhoono nimenyiri kubha kyokyoosi kino oraamusabhe Taatabhugya, arakuhaana.” ");
INSERT INTO zak_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ambe, Yeesu akamukyoora, “Mura weenyu araryooka.” ");
INSERT INTO zak_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marita akabhuga, “Nimenyiri kubha Taatabhugya hano akubharyoora abhaatu bhoosi murusiku rwo obhuteero, neewe araryooka no okubha muhoru kweeki.” ");
INSERT INTO zak_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yeesu akamukyoora, “Enye neenye obhuryoori no obhuhoru. Omuutu wowoosi wuno akuniikirirya enye, yiingabha arakwa, arabha muhoru. ");
INSERT INTO zak_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na wowoosi wuno ari muhoru no okuniikirirya enye, atakukwa na rumwe. Mbe, oriikirirya gayo?” ");
INSERT INTO zak_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marita akamukyoora, “Ni heene Omukuru, ndiikirirya kubha awe ni Masiya, Omwaana wa Taatabhugya, wuno okuuza mukyaaro.” ");
INSERT INTO zak_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hano Marita yamariri kubhuga gayo, akagya kumubhirikira Mariamu omusubhaati waaye, akamubhuurira kibhezo, “Omweegya ari hano, arakubhirikira.” ");
INSERT INTO zak_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hano Mariamu yiigwiiri gayo, akabhuuka bhwaangu, akagya ku Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yeesu yaari akyaari kusikira mumugye guyo, yaari hano Marita yagiiri kumusuungʼaana. ");
INSERT INTO zak_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Abhayahudi bhano bhaari bhakumugosorerya Mariamu, bhakamurora arabhuuka bhwaangu okugya igutu. Nabho bhakamutuniirira, kwo okubha bhakiiseega kubha Mariamu aragya kumbiihira okubha aririre eyo. ");
INSERT INTO zak_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Hano Mariamu yahikiri ku Yeesu, akamurora, akahigama embere waaye, kyaamwe akamubhuurira, “Ee Omukuru, eraabhe wuungabheeriho hano, mura weetu atiingakuuri.” ");
INSERT INTO zak_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Hano Yeesu yamuruuzi Mariamu ararira na abhaatu bhano bhiiziri nabho bhararira, akabha no obhururu, akahoobha bhukongʼu mukoro yaaye. ");
INSERT INTO zak_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ambe, akabhabhuurya, “Mumubhiikiri hayi?” Bhakamukyoora, “Ee Omukuru, tugye tukweerekye.” ");
INSERT INTO zak_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yeesu akarira. ");
INSERT INTO zak_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ambe, abhaatu bhano bhakaaza kuruku bhakabhuga, “Rora kyeego yaari amuseegiri Razaro!” ");
INSERT INTO zak_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nawe abhamwe bhaabhu bhakabhuga, “Omuutu wuno niwe wuno yamuhorirye omuhoku, ambe kwaki ataakoriri ryoryoosi ku Razaro okubha atakwa?” ");
INSERT INTO zak_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hano Yeesu yaari akyaari ane ebhigoongi bhukongʼu mukoro yaaye, akahika kumbiihira. Embiihira yiyo yaari ye eriibhigi rino bhayiribhiri ne eriigina ikuru mukiseku. ");
INSERT INTO zak_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yeesu akabhabhuurira abhaatu bhano bhaari harya, “Muriruusyeho eriigina riyo kumbiihira.” Ambe, Marita, musubhaati waaye Razaro, akamubhuurira, “Ee Omukuru, bhoono ataangiri kuhuza, kwo okubha zihitiri siku inye ari mumbiihira.” ");
INSERT INTO zak_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ambe, Yeesu akamubhuurira, “Mbe, nitaakubhuuriiri kubha, eraabhe oriikirirya, orabhurora obhuguungo bhwa Taatabhugya?” ");
INSERT INTO zak_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ambe, bhakariruusyaho eriigina rirya. Yeesu akarora mwiisaaro, akasabha ku Taatabhugya akabhuga, “Ee Taata, ndabhuga ozomirye kwo okubha wiigwiiri amasabhi gaane. ");
INSERT INTO zak_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nimenyiri kubha oraniigwa eriibhaga ryoosi, nawe ndagaamba gano kwe ekigirirye kye esaango ya abhaatu bhano, okubha bhiikirirye kubha naawe wuno ontumeenie.” ");
INSERT INTO zak_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hano Yeesu yamariri kubhuga gayo, akatiirya eriiraka akabhuga, “Razaro, nawuuze igutu eno!” ");
INSERT INTO zak_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ambe, akahuruka igutu wurya yaari akuuri. Amaguru na amabhoko gaaye gariiziriirwe emyeenda gyo okubhiikira abhaku, no obhusyo bhwaaye bhwaari bhubhohirwe ekitaambaara. Ambe, Yeesu akabhabhuurira abhaatu bharya, “Mumutazure emyeenda giyo, mumutige agye.” ");
INSERT INTO zak_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ambe, Abhayahudi bhaaru bhano bhiiziri ku Mariamu, hano bhaaruuzi gano Yeesu yakoriri, bhakamwiikirirya. ");
INSERT INTO zak_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nawe abhamwe bhaabhu bhakagya ku Bhafarisayo no okubhabhuurira gano Yeesu yakoriri. ");
INSERT INTO zak_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ambe, abhakuru bha abhaseengeri na Abhafarisayo bhakabhirikira ekiina ekikuru kya Abhayahudi, bhakiibhuurya, “Tukoreki? Kwe ekigirirye omuutu wuno arakora ebhyeerekenio ne ebhitiika bhyaaru. ");
INSERT INTO zak_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Turaamutige ageenderere okukora ego, abhaatu bhoosi bharamwiikirirya. Abharooma bharaaza no okusarya ekyaaro kyeetu ne eriiseengerero ryeetu.” ");
INSERT INTO zak_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ambe, owumwe wa abhakuru bharya eriina ryaaye ni Kayafa, wuno yaari omuseengeri omukuru wo omwaaka guyo, akabhabhuurira, “Emwe mutamenyiri kyokyoosi! ");
INSERT INTO zak_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mbe, mutamenyiri kubha, ni hakiriku omuutu wumwe akwe kwiiguru wa abhaatu bhoosi, kukira ekyaaro kyoosi kisikibhwe?” ");
INSERT INTO zak_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafa ataagaambiri gayo kwo amiiseego gaaye omweene. Nawe kwo okubha yaari omuseengeri omukuru omwaaka guyo, yaari araroota kubha Yeesu arakwa kwiiguru wa Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kweeki Yeesu atakukwa kwiiguru waabhu abheene, nawe ni kwiiguru yo okubhakumania abhaana bha Taatabhugya bhano bhanyarageeni, bhabhe hamwe. ");
INSERT INTO zak_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Okurwa rusiku ruyo, abhakaangati bha Abhayahudi bhakataanga kukomya enzira yo okumwiita Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kwe ekigirirye kiyo, Yeesu akatiga kugeenda mwaasi Yudea. Nawe akatanura no okugya haguhi ne eriitirigo, mumugye guno gukubhirikirwa Ifurahimu, akiikara eyo hamwe na abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Enyaangi yo Okuhiita ya Abhayahudi yaari haguhi. Ambe, abhaatu bhaaru bhakatanura okurwa mumigye gyaabhu kugya Yerusaremu, okubha bhiiyeerye kwiiguru ye enyaangi. ");
INSERT INTO zak_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ambe, bhakageenderera okumumoohya Yeesu, bhakiibhuurya bhakubha bhiikumaniirye hamwe mwiiseengerero, bhakabhuga, “Emwe murarorabhwi? Mbe, omuutu wuyo araaza munyaangi heene?” ");
INSERT INTO zak_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Abhakuru bha abhaseengeri na Abhafarisayo bhaari bhaswaagirye kubha, omuutu wowoosi wuno amenyiri hano Yeesu ari, aruusye amangʼana okubha bhamugwaate. ");
INSERT INTO zak_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Hano zyasaagiri siku isaasabha kuhika Enyaangi yo Okuhiita, Yeesu akahika kweeki Betania, mumugye guno yamuryooriri Razaro okurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ambe, abhaatu bha ahagiro hayo bhakamuginihya. Marita akamuhokeerya Yeesu ebhyaakurya, na Razaro yaari owumwe wa bhano bhakarya hamwe na Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kyaamwe, Mariamu akagega amaguta go omuruumbaaso gano gano obhuguri bhukuru bhukongʼu, akamuhaka Yeesu kumaguru, akamutarikya ne eziinzweeri zyaaye. Enyuumba yoosi ekiizura obhuraangaasiro bhuzomu bhwa amaguta go omuruumbaaso. ");
INSERT INTO zak_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nawe owumwe wa abhaanabheega bhaaye eriina ryaaye Yuuda Isikariyoti, wuno niwe araamurye omukoonyo Yeesu, akabhuga, ");
INSERT INTO zak_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kwaki amaguta gayo gataaguriibhwe eziidinaari magana atatu (300) no okuhaabhwa abhataka?” ");
INSERT INTO zak_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuuda ataagaambiri ego kwe ekigirirye kyo okubharorera ebhigoongi abhataka, nawe kwe ekigirirye yaari mwiibhi. Ewe niwe yaari akubhiika esakwa ye eziimbirya. Yaari ariibha eziimbirya zino zikatuurwa musakwa yiyo. ");
INSERT INTO zak_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ambe, Yeesu akamukyoora Yuuda, “Mutamunyaakya omukari wuno, mumutige, abhiikiri amaguta gayo kwiiguru yo orusiku runo bharaambiike. ");
INSERT INTO zak_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abhataka bhari hamwe neemwe eziisiku zyoosi, nawe enye nitakubha hamwe neemwe eziisiku zyoosi.” ");
INSERT INTO zak_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ambe, Abhayahudi bhaaru bhakiigwa kubha Yeesu yaari ahagiro hayo, bhakagya kumurora etari ewe omweene, nawe kweeki kumurora Razaro, wuno Yeesu akamuryoora okurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ambe, abhakuru bha abhaseengeri bhakataanga kukomya enzira yo okumwiita Razaro woosi, ");
INSERT INTO zak_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwo okubha Abhayahudi bhaaru bhakabhatiga abhakaangati bhaabhu, bhakamwiikirirya Yeesu, kutuukana na amangʼana go okuryooka kwa Razaro. ");
INSERT INTO zak_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tabhoori yaho, esaango ekuru ya abhaatu bhano bhakaaza kuginiha Enyaangi yo Okuhiita, bhakiigwa kubha Yeesu ari munzira araaza Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ambe, bhakagega amatu ge emiteende, bhakagya kumusuungʼaana Yeesu. Bhakatiirya eriiraka bhakubhuga, “Taatabhugya akumibhwe! Atweerwe ebhite wuno akuuza kuriina ryo Omukuru! Aguungibhwe omutemi wa Abhiiziraeri.” ");
INSERT INTO zak_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ambe, Yeesu akabhona etikiri, akatiira, akiikara kyeego ekaamirwe mu Makaamo Amahoreeru, ");
INSERT INTO zak_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Emwe abhaatu bha Sayuni, mutoobhoha! Rora, omutemi weenyu araaza, atiiriri etikiri!” ");
INSERT INTO zak_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Eriibhaga riyo, abhaanabheega bha Yeesu bhataamenyiri engʼana yino ni ngʼanaki. Nawe hano Yeesu yaryookiri, bhakahiita kubha gayo gakaamirwe na niigo bhamukoreeri. ");
INSERT INTO zak_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Abhaatu bhano bhaari na Yeesu hano yamubhirikiiri Razaro okurwa mumbiihira no okumuryoora okurwa mubhaku, bhakageenderera kunyaragania amangʼana gayo. ");
INSERT INTO zak_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ambe, abhaatu bhaaru bhaari bhiigwiiri amangʼana ge ekitiika kino Yeesu yakoriri, nikyo ekigirye bhakagya kumusuungʼaana. ");
INSERT INTO zak_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nawe Abhafarisayo bhakiibhuurya, “Murarora? Tutakunagya kukora kyokyoosi! Rora, abhaatu bhoosi bharamutuniirira ewe.” ");
INSERT INTO zak_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Haari na abhaatu bhano bhatari Abhayahudi gati wa abhaatu bhano bhakagya Yerusaremu kumuseengera Taatabhugya mu Nyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ambe, abhaatu bhayo bhakagya ku Firipo wuno yarwiiri Betisaida mukyaaro kya Gariraaya, bhakamusabha, “Omukuru, turasabha turorane na Yeesu.” ");
INSERT INTO zak_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Firipo akagya kumubhuurira Andurea amangʼana gayo, kyaamwe bhoosi bhabhiri bhakagya ku Yeesu kumubhuurira. ");
INSERT INTO zak_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yeesu akabhabhuurira, “Eriibhaga rihikiri rya Taatabhugya okweerekya obhuguungo bhwe eheene bhwo Omwaana wo Omuutu. ");
INSERT INTO zak_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ndabhabhuurira obhuheene, eraabhe embibho ye engano ekyaari kukuundikirwa mumarobha no okukwa, etakutura kumera. Nawe eraabhe erakwa, eramera no okwiibhura emisumo myaaru. ");
INSERT INTO zak_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Omuutu wowoosi wuno akuseega obhwiikari bhwaaye omweene, arabhubhurya, nawe omuutu wowoosi wuno akubhiihirirwa obhwiikari bhwaaye mukyaaro kino, wuyo arabhuriibha obhuhoru bhwaaye, okubha bhubhe bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Omuutu wowoosi wuno akunihokeerya enye, ereenderwa anituniirire. Kweeki hohoosi hano nikubha, hayo niho omuhokya waane araabheho. Taata aramusuuka omuutu wowoosi wuno akunihokeerya enye. ");
INSERT INTO zak_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Bhoono nitaangiri kuhoobha bhukongʼu mukoro yaane. Mbe, nigaambeki? Nibhuge, ‘Ee Taata, ndakusabha onituurye mwiibhaga rino rye enyaako?’ Zeyi, nitakunagya kusabha ego, kwo okubha niiziri mukyaaro kino okubha nibhone enyaako yiyo. ");
INSERT INTO zak_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ee Taata Taatabhugya, okuundukure obhuguungo bhwe eriina ryaazo.” Niho, eriiraka rikagaamba okurwa mwiisaaro, “Nibhukuundukwiiri, kweeki ndageenderera okubhukuundukura.” ");
INSERT INTO zak_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Esaango ya abhaatu bhano bhaari harya, hano bhakiigwa eriiraka okurwa mwiisaaro, abhaandi bhakabhuga kubha, orukubha rubharukiri, na abhaandi bhakabhuga kubha, maraika yaari akeereenie neewe. ");
INSERT INTO zak_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nawe, Yeesu akabhabhuurira abhaatu bharya, “Eriiraka rino mwaari mukwiigwa ritaari kwiiguru waane, nawe ryaari kwiiguru weenyu. ");
INSERT INTO zak_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bhoono, rihikiri eriibhaga rya Taatabhugya okutinira ekiina ekyaaro kino. Na rihikiri eriibhaga ryo okumuheebha Seetaani omukaangati we ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hano enye ndaanuungwe iguru kumusaraba, ndabharuta bhoosi okubha bhiize kweenye.” ");
INSERT INTO zak_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yeesu akabhuga ego, okweerekya kyeego araakwe. ");
INSERT INTO zak_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ambe, esaango ya abhaatu bhakamukyoora Yeesu, “Tusomiri mu Makaamo Amahoreeru kubha, Masiya arabha muhoru kirakeego. Ambe, kwaki orabhuga kubha, Omwaana wo Omuutu areenderwa kunuungwa iguru? Mbe, Omwaana wo Omuutu ni weewi?” ");
INSERT INTO zak_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yeesu akabhabhuurira, “Obhweero bhurabha hamwe na neemwe kwe eriibhaga iguhi ego. Mugeenderere kugeenda mubhweero bhuno eriibhaga bhuriho, okubha ekiirima kitaaza okubhahiza, kwo okubha omuutu wuno akugeenda mukiirima atahamenyiri hano akugya. ");
INSERT INTO zak_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mutuure obhwiikirirya bhweenyu kubhweero bhuyo eriibhaga rino obhweero bhukyaari bhuriho, okubha mubhe abhaana bho obhweero.” Hano Yeesu yamariri kugaamba gayo, akatiga esaango yirya, akagya okwiibhisa. ");
INSERT INTO zak_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yiingabha Yeesu akakora ebhitiika bhyaaru embere waabhu, nawe abhaatu bhaaru bhataamwiikiriirye. ");
INSERT INTO zak_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Gaari ego okubha gakuunaane amangʼana gano omurooti Isaya yabhugiri, “Omukuru, ni weewi wuno yiikiriirye amangʼana geetu? Kweeki, Omukuru amukuundukuriirye weewi amanaga gaaye?” ");
INSERT INTO zak_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kweego bhataanagirye kwiikirirya, kwe ekigirirye Taatabhugya akagaamba kweeki kuhitira ku Isaya, ");
INSERT INTO zak_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nihukwiirye ameeso gaabhu, no okukora eziikoro zyaabhu zibhe kongʼu, bhatarora kwa ameeso, bhatamenyeekererya kwe eziikoro zyaabhu, bhataaza bhakaaniikyoorera, na neenye nibhatuurye.” ");
INSERT INTO zak_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya akagaamba gayo kwo okubha akarora obhuguungo bhwa Yeesu no okugaamba amangʼana gaaye. ");
INSERT INTO zak_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Naabhe ego, abhakaangati bhaaru bha Abhayahudi bhakamwiikirirya Yeesu, nawe bhataagaambiri kubhweero bhamwiikiriirye, kwe ekigirirye bhaari bharoobhoha okuheebhwa na Abhafarisayo munyuumba ye esaango. ");
INSERT INTO zak_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Abhakaangati bhayo, bhakaseega bhukongʼu okukumibhwa na abhaatu, kukira okukumibhwa na Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ambe, Yeesu akagaamba kwiiraka ikuru, “Omuutu wuno akuniikirirya enye, atakuniikirirya enye omweene ego, nawe aramwiikirirya na wuno antumiri. ");
INSERT INTO zak_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hano anduuzi enye, amuruuzi na wuno antumiri. ");
INSERT INTO zak_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Enye niiziri mukyaaro kino kyo obhweero, okubha abhaatu bhano bhakuniikirirya bhatige kubha mukiirima. ");
INSERT INTO zak_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Omuutu wowoosi wuno akwiitegeerera amangʼana gaane, nawe atakugagwaata, enye nitakumutinira ekiina, kwe ekigirirye nitiiziri mukyaaro kino kubhatinira ekiina abhaatu, nawe nikaaza kubhatuurya. ");
INSERT INTO zak_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Naabhe ego, omuutu wowoosi wuno akunianga enye hamwe na amangʼana gaane, araaza okutinirwa ekiina. Amangʼana gano nigaambiri nigo gano gakuuza okumutinira ekiina kurusiku rwo obhuteero. ");
INSERT INTO zak_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nitagaambiri amangʼana gayo kwo obhuturo bhwaane omweene, nawe Taata wuno antumiri, niwe wuno aniswaagirye go okugaamba, na kyeego ndaagaambe. ");
INSERT INTO zak_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kweeki, nimenyiri kubha obhuswaagyo bhwaaye bhurabhaha abhaatu obhuhoru bhwa kirakeego. Niho, enye nikugaamba omweene ego gano Taata aniswaagirye okugaamba.” ");
INSERT INTO zak_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ambe, hano Enyaangi yo Okuhiita yaari ekyaari kuhika, Yeesu akamenya kubha eriibhaga ryaaye rihikiri ryo kutanura mukyaaro kino kugya ku Wiise waabhu. Yeesu yaari abhaseegiri abhaatu bhaaye bhano bhari mukyaaro, kweeki akabhaseega tee obhuteero. ");
INSERT INTO zak_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yeesu na abhaanabheega bhaaye bhakiikara kurya ebhyaakurya bhye engoroobha. Eriibhaga riyo, Seetaani yaari amariri kumukorokoomba Yuuda, omwaana wa Simooni Isikariyoti, okubha amurye omukoonyo Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yeesu akamenya kubha, Wiise amuheeri obhuturo bhwo okubhikaangata ebhigiro bhyoosi. Kweeki akamenya arwiiri ku Taatabhugya, na arakyoora ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ambe, Yeesu akatiga kurya, akiimeerera, akaruusya omweenda gwaaye gwi igutu, akagega ekitaambaara akakibhoha mukiribhizi. ");
INSERT INTO zak_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Akiituruurira amaanzi mukarayi. Ambe, akataanga kubhoogya abhaanabheega bhaaye amaguru no okubhatarikya ne ekitaambaara kino yiibhohiri. ");
INSERT INTO zak_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Hano Yeesu yamuhikiiri Simooni Petero, Petero akamubhuurya, “Ee Omukuru, oreenda okuniogya amaguru gaane?” ");
INSERT INTO zak_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yeesu akamukyoora, “Awe otamenyiri bhoono gano nikukora, nawe oragamenyeekererya ibhaga riindi.” ");
INSERT INTO zak_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petero akamubhuurira, “Otakunagya na rumwe okuniisaabhya amaguru gaane!” Yeesu akamukyoora, “Eraabhe nitakukwiisaabhya awe, otakunagya kubha hamwe na neenye.” ");
INSERT INTO zak_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simooni Petero akamubhuurira, “Ee Omukuru, eraabhe niigo, otakuniisaabhya amaguru ageene, nawe na amabhoko gaane hamwe no omutwe gwaane.” ");
INSERT INTO zak_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yeesu akamubhuurira, “Omuutu wuno amariri kwiisaabha, atakweenderwa kwiisaabha kweeki, nawe okwiisaabha amaguru ageene. Wuyo yeeriri kimwe. Na neemwe mweeriri, nawe mutari mwoosi.” ");
INSERT INTO zak_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yeesu yaari amumenyiri wuno araamurye omukoonyo, nikyo ekigirirye yagaambiri, “Mutari mwoosi kubha mweeriri.” ");
INSERT INTO zak_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Hano Yeesu yamariri kubhiisaabhya abhaanabheega bhaaye amaguru, akiibhoha omweenda gwaaye, akiikara kweeki hano bhaari bhakurya ebhyaakurya, akabhabhuurya, “Mbe, mumenyiri gano nibhakoreeri emwe? ");
INSERT INTO zak_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Emwe muraambirikira enye, ‘Omweegya,’ kweeki muraambirikira, ‘Omukuru.’ Muragaamba obhuheene, kwe ekigirirye enye niigo niri. ");
INSERT INTO zak_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Enye, wuno ni Mweegya no Omukuru weenyu, nisaabhirye amaguru geenyu. Egoego na neemwe, mureenderwa mwiisaabhanie amaguru. ");
INSERT INTO zak_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nibheerekirye ekireengyo okubha na neemwe mubhe murakorerana kyeego enye nibhakoreeri emwe. ");
INSERT INTO zak_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ndabhabhuurira obhuheene, omugya atari mukuru kukira omukuru waaye, kweeki wuno akutumwa atari omukuru kukira wuno akumutuma. ");
INSERT INTO zak_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Eraabhe murigamenya gayo, ambe hakiriku kubhano mukugakora. ");
INSERT INTO zak_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nitakugaamba gano kwiiguru emwe bhoosi. Nibhamenyiri abhaatu bhano nibhasoriri kubha abhaanabheega bhaane. Nawe nigaambiri gano okubha gakuunaane gano gakaamirwe mu Makaamo Amahoreeru, ‘Omusaani waane wuno yaari akurya ebhyaakurya hamwe na neenye, yiibharaangwiiri kubha omubhisa waane.’ ");
INSERT INTO zak_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndabhabhuurira gano goosi gakyaari kutuuka, okubha hano garaatuuke, mwiikirirye kubha enye ndiho. ");
INSERT INTO zak_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ndabhabhuurira obhuheene, omuutu wowoosi wuno akumusuungʼaana wuno nimutumiri, ansuungʼaaniri na neenye. Egoego, wuno akunisuungʼaana enye, aramusuungʼaana Taata wuno anirageenie.” ");
INSERT INTO zak_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Hano Yeesu yamariri kugaamba gayo, akahoobha mukoro yaaye, akagaamba mwaasi, “Ndabhabhuurira obhuheene, owumwe weenyu aranirya omukoonyo.” ");
INSERT INTO zak_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ambe, abhaanabheega bhaaye bhakataanga okwiiroreerera, kwe ekigirirye bhataamenyiri aramugaamba weewi. ");
INSERT INTO zak_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yaari ariho omwaanamweega owumwe, wuno Yeesu yaari amuseegiri bhukongʼu. Ewe yaari yiikeeri haguhi na Yeesu eriibhaga ryo okurya. ");
INSERT INTO zak_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ambe, Simooni Petero akamusimya omwaanamweega wuyo, akamubhuurira, “Mubhuurye Yeesu aramugaamba weewi gati weetu.” ");
INSERT INTO zak_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ambe, omwaanamweega wurya akiiyegeka ku Yeesu, akamubhuurya, “Ee Omukuru, ni weewi?” ");
INSERT INTO zak_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yeesu akamukyoora, “Niwe wuno ndaamukorerye no okumuha ekitinika kyo omukaate.” Ambe, akagega kitinika kyo omukaate akakorya, akamuha Yuuda, omwaana wa Simooni Isikariyoti. ");
INSERT INTO zak_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kituukiro ego hano yamariri okusuungʼaana kitinika kirya kyo omukaate, Seetaani akamusikirira Yuuda. Ambe, Yeesu akamubhuurira, “Gano okweenda kukora, gakore bhwaangu!” ");
INSERT INTO zak_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nawe ataari ariho naabhe wumwe gati wa bhano bhaari kurya wuno akamenyeekererya kwaki Yeesu yaari abhugiri ego. ");
INSERT INTO zak_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Abhaandi bhakiiseega Yeesu abhugiri ego, kwo okubha Yuuda niwe yaari omutiimbiriri we esakwa ye eziimbirya. Bhakiiseega kubha Yeesu amubhuuriiri agure bhino bhikweenderwa munyaangi, kasi abhahe abhataka eziimbirya suuhu. ");
INSERT INTO zak_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ambe, hano Yuuda yasuungʼaaniri ekitinika kyo omukaate, akarwa igutu bhwaangu. Ne eriibhaga riyo, bhwaari bhutiku. ");
INSERT INTO zak_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ambe, hano Yuuda yahurukiri igutu, Yeesu akabhabhuurira abhaanabheega bhaaye, “Bhoono obhuguungo bhwaane, enye Omwaana wo Omuutu, bhwiisukiri kurorekana mwaasi. Kweeki bhurarorekana mwaasi obhuguungo bhwa Taatabhugya kuhitira kweenye. ");
INSERT INTO zak_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kyeego bhukurorekana obhuguungo bhwaaye kuhitira kumahokya gaane, ambe neewe Taatabhugya arabheerekya abhaatu obhuguungo bhwaane enye Omwaana wo Omuutu, kweeki arakora bhwaangu. ");
INSERT INTO zak_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Emwe abhaana bhaane, nikyaari ne eriibhaga iguhi kubha neemwe. Murankomya, nawe kyeego niari nibhuuriiri abhakaangati bha Abhayahudi, egoego ndabhabhuurira na neemwe bhoono, hano nkugya enye, emwe mutakunagya kuuza. ");
INSERT INTO zak_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nawe bhoono, ndabhaha obhuswaagyo obhuhya, ndabharagania kubha: Mwiiseege. Kyeego enye nibhaseegiri emwe, egoego na neemwe mwiiseege. ");
INSERT INTO zak_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Eraabhe muraseegana, ambe, abhaatu bhoosi bharamenya kubha emwe ni bhaanabheega bhaane.” ");
INSERT INTO zak_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ambe, Simooni Petero akamubhuurya Yeesu, “Ee Omukuru, oragya hayi?” Yeesu akamukyoora, “Ndagya hano awe otakunagya okunituniirira bhoono, nawe oranituniirira ibhaga riindi.” ");
INSERT INTO zak_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petero akamubhuurya, “Ee Omukuru, kwe ekigirirye kiihe nitakunagya kukutuniirira bhoono? Enye ndakwa kwiiguru waazo!” ");
INSERT INTO zak_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yeesu akamukyoora, “Mbe, eheene oriikirirya okukwa iguru waane? Ndakubhuurira obhuheene, hano ekorokoome erabha ekyaari kugaamba, orabha omariri kunianga katatu koosi.” ");
INSERT INTO zak_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yeesu akageenderera okubheegya abhaanabheega bhaaye, arabhuga, “Mutahoobha muziikoro zyeenyu, mumwiikirirye Taatabhugya, kweeki muniikirirye na neenye. ");
INSERT INTO zak_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Munyuumba ya Taata omweeya ni mwaaru gwo okwiisa. Eraabhe itiingabheeri ego, niingabhabhuuriiri, kwo okubha ndagya kubhabhanurira ahagiro. ");
INSERT INTO zak_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Hano ndaagye no okubhabhanurira ahagiro, ndaaza kweeki kubhagega okubha ahagiro hano nikubha, na neemwe mubheho hamwe neenye. ");
INSERT INTO zak_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Emwe muyimenyiri enzira yo okuhika hano nkugya.” ");
INSERT INTO zak_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Niho, Tomaso akamubhuurya Yeesu, “Ee Omukuru, etwe tutamenyiri hano okugya. Mbe, turanagyabhwi okuyimenyeekererya enzira?” ");
INSERT INTO zak_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yeesu akamukyoora, “Enye neenye enzira, obhuheene no obhuhoru. Atariho omuutu wowoosi wuno akunagya okuuza ku Taata eraabhe akyaari kuhitira kweenye. ");
INSERT INTO zak_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eraabhe muunganimenyiri enye, ambe muungamumenyiri na Taata. Kweemera bhoono, mumumenyiri, kweeki mumuruuzi.” ");
INSERT INTO zak_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Firipo akamubhuurira, “Ee Omukuru, turakusabha otweerekye Taata, na riyo ririisa.” ");
INSERT INTO zak_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu akamukyoora, “Firipo, nibheeri hamwe na neemwe ibhaga itaambi, okyaari kunimenyeekererya enye? Omuutu wowoosi wuno anduuzi enye, amuruuzi Taata. Ambe kwaki murambuurya, ‘Tweerekye Taata?’ ");
INSERT INTO zak_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mbe, otakwiikirirya kubha enye niri muusi wa Taata, na Taata ari muusi waane? Amangʼana gano nikubhabhuurira gatakurwa mumiiseego gaane, nawe Taata, wuno ari muusi waane, arakora emirimo gyaaye. ");
INSERT INTO zak_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mwiikirirye gano nikugaamba kubha niri muusi wa Taata, na neewe ari muusi waane. Nawe eraabhe emwe mutakwiikirirya gano nikugaamba, ambe mwiikirirye kwe ekigirirye kye emirimo gino nikukora. ");
INSERT INTO zak_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ndabhabhuurira obhuheene, omuutu wowoosi wuno akuniikirirya, arakora emirimo giryagirya gino enye nikugikora. Kweeki arakora emirimo kukira gino nikukora, kwe ekigirirye ndagya ku Taata. ");
INSERT INTO zak_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eraabhe murasabha ekigiro kyokyoosi kuriina ryaane, enye ndakora kyeego mukusabha. Kweego, obhuguungo bhwa Taata bhurarorekana kuhitira kweenye, Omwaana waaye. ");
INSERT INTO zak_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kweeki muraanisabhe ekigiro kyokyoosi kuriina ryaane, ndakora kyeego mukusabha. ");
INSERT INTO zak_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Eraabhe muunseegiri, murakora emirimo gyoosi gino nibhaswaagirye. ");
INSERT INTO zak_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ambe, na neenye ndamusabha Taata okubha abhahe Omusakirya owuundi, okubha abhe hamwe neemwe eziisiku zyoosi. ");
INSERT INTO zak_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ekoro wuyo arabhakuundukurira abhaatu obhuheene. Abhaatu bhano bhakumwaanga Taatabhugya bhatakunagya kumusuungʼaana Ekoro wuyo, kwe ekigirirye bhatakumurora, kweeki bhatamumenyiri. Nawe emwe mumumenyiri Ekoro wuyo, kwo okubha ariikara hamwe neemwe, kweeki araaza kubha muusi weenyu. ");
INSERT INTO zak_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nitakubhatiga abheene kya abhamweemwe, nawe ndaaza kweeki kweemwe. ");
INSERT INTO zak_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nikyaari hasuuhu nitakurorekana kweeki mukyaaro kino. Nawe emwe muraandora, kwo okubha enye ni muhoru, na neemwe murabha bhahoru. ");
INSERT INTO zak_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Murusiku rurya, muramenya kubha enye niri muusi wa Taata, na neemwe muri muusi waane, na neenye niri muusi weenyu. ");
INSERT INTO zak_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Omuutu wowoosi wuno akugamenya no okukora gano nikuswaagya, wuyo niwe anseegiri. No omuutu wuno anseegiri, Taata amuseegiri. Na neenye ndamuseega no okwiiyeerekya kweewe.” ");
INSERT INTO zak_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ambe, omwaanamweega wumwe eriina ryaaye Yuuda, atari Yuuda Isikariyoti, akamubhuurya Yeesu, “Ee Omukuru, eraturikanabhwi okwiiyeerekya kweetwe, nawe otakwiiyeerekya kubhaatu abhaandi bhoosi?” ");
INSERT INTO zak_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yeesu akamukyoora, “Omuutu wowoosi wuno anseegiri, aragwaata ameegyo gaane. Egoego Taata aramuseega, kweeki enye na Taata turaaza kweewe no okwiikara hamwe neewe. ");
INSERT INTO zak_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nawe omuutu wowoosi wuno ataaniseegiri, ewe atakugwaata ameegyo gaane. Kweeki, gano nikubharagania gatari gaane, nawe gararwa ku Taata wuno antumeenie kweemwe. ");
INSERT INTO zak_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nibhabhuuriiri goosi gayo hano nikyaari ndiikara hamwe neemwe. ");
INSERT INTO zak_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nawe Omusakirya wuyo, niwe Ekoro Muhoreeru, wuno Taata araamutume kweemwe kuriina ryaane. Arabheegya no okubhahiitya goosi gano niari nibhabhuuriiri. ");
INSERT INTO zak_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Hano nikubhuuka, ndabhatigira omureembe, omureembe gwaane ndabhaha. Omureembe guyo gutari kyeego guno gukurwa kubhaatu bha mukyaaro. Mutahoobha muziikoro zeenyu, kweeki mutoobhoha kyokyoosi. ");
INSERT INTO zak_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Mwiigwiiri gano niabhabhuuriiri, ‘Ndagya, nawe ndaaza kweeki kweemwe.’ Eraabhe heene muunseegiri, muungabheeri murazomererwa okwiigwa kubha ndagya ku Taata, kwo okubha Taata ni mukuru kunikira enye. ");
INSERT INTO zak_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na bhoono nibhabhuuriiri amangʼana gayo gakyaari kurorekana, okubha eriibhaga garaatuuke muniikirirye. ");
INSERT INTO zak_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Nitakugaamba neemwe kwiibhaga itaambi, kwo okubha Seetaani omukaangati we ekyaaro kino araaza. Nawe atana obhunagya iguru waane. ");
INSERT INTO zak_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gano nikukora nigo gano Taata yaniswaagirye kukora, okubha abhaatu bhoosi bhamenye kubha nimuseegiri. “Bhoono, mwiimeerere tutanure hano.” ");
INSERT INTO zak_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yeesu akageenderera okubheegya, “Enye ni muzabibu gwe eheene, na Taata waane ni murimi. ");
INSERT INTO zak_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Eriisagya ryoryoosi muusi waane rino ritakwiibhura emisumo, Taata ahaariruusyaho. Nawe eriisagya rino rikwiibhura emisumo, Taata ahaarihagura okubha riibhure bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Emwe mumariri kuhagurirwa kubha mweeriri, kwo okubha mwiikiriirye ameegyo gaane. ");
INSERT INTO zak_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mwiikare muusi waane, neenye ndiikara muusi weenyu. Kyeego eriisagya ritakunagya okwiibhura emisumo eryeene ego kutama okwiigwaatirirya kumuzabibu, egoego mutakunagya kukora obhuseegi bhwa Taatabhugya kutama kwiikara muusi waane. ");
INSERT INTO zak_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Enye ni muzabibu, neemwe ni masagya. Omuutu wuno akwiikara muusi waane, na neenye ndiikare muusi waaye, wuyo arabha ariibhura emisumo myaaru, kwe ekigirirye kutama enye mutakunagya kukora ryoryoosi. ");
INSERT INTO zak_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Omuutu wowoosi wuno atakwiikara muusi waane atuubheeni na masagya gano garekeerwe no okwooma. Ambe, abhaatu bhararitoora no okurirekera mumuriro, riraruungura. ");
INSERT INTO zak_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Eraabhe muriikara muusi waane na amangʼana gaane gariikara muusi weenyu, ambe musabhe Taata kyokyoosi kino mukweenda, neewe arabhaha. ");
INSERT INTO zak_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Eraabhe muriibhura emisumo myaaru no okubha abhaanabheega bhaane bhe eheene, murabha mureerekya mwaasi obhuguungo bhwa Taata. ");
INSERT INTO zak_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kyeego Taata anseegiri enye, niigo neenye nikubhaseega emwe. Ambe mwiikare mubhuseegi bhwaane. ");
INSERT INTO zak_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Eraabhe murigwaata gano nikubhaswaagya, ambe muriikara mubhuseegi bhwaane, kyeego enye nigwaatiri gano Taata yaaniswaagirye no okwiikara mubhuseegi bhwaaye. ");
INSERT INTO zak_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nibhabhuuriiri gano okubha mubhone obhuzomererwa bhwe eheene kyeego bhuno ninabhwe enye, no obhuzomererwa bhweenyu bhukuunaane. ");
INSERT INTO zak_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Gano nikubhaswaagya nigo gano: Mwiiseege kyeego enye nibhaseegiri emwe. ");
INSERT INTO zak_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Atariho omuutu wuno ano obhuseegi bhukuru kukira wuno akuruusya obhuhoru bhwaaye kwiiguru ya abhasaani bhaaye. ");
INSERT INTO zak_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eraabhe murakora gano nibhaswaagirye, emwe ni bhasaani bhaane. ");
INSERT INTO zak_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kweemera bhoono, nitakubha ndabhabhirikira kweeki abhagya bhaane, kwe ekigirirye omugya atamenyiri kino omukuru waaye akukora. Nawe emwe nibhakuundukuriiri goosi gano niigwiiri okurwa ku Taata, ambe kweego ndabhabhirikira abhasaani bhaane. ");
INSERT INTO zak_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Emwe mutaanisoriri enye, nawe enye nikabhasora emwe. Nikabhatuma okubha mwiibhure emisumo gino gitakuhwa na rumwe. Murikora ego, goosi gano mukusabha kuriina ryaane, neewe Taata arabhaha. ");
INSERT INTO zak_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ambe, ndabhaswaagya emwe kubha mwiiseege.” ");
INSERT INTO zak_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yeesu akageenderera okubheegya, “Eraabhe abhaatu bhe ekyaaro kino bharabhabhiihirirya emwe, mubhe murahiita kubha bhakakaangata okunibhiihirirya enye. ");
INSERT INTO zak_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eraabhe muungabheeri bhaatu bhe ekyaaro kino, bhayo bhiingabheeri bharabhaseega kyeego bhakubhaseega abhaatu bhe ekyaaro kino. Nawe emwe mutari bhe ekyaaro kino, kwo okubha nibhasoriri okurwa mukyaaro kino, nikyo ekigirirye abhaatu bhe ekyaaro kino bhakubhabhiihirirya. ");
INSERT INTO zak_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muteebha gano niabhabhuuriiri, ‘Omugya atari mukuru kukira omukuru waaye.’ Ambe, eraabhe bhakaaninyaakya enye, bharabhanyaakya na neemwe. Nawe eraabhe bhakagwaata ameegyo gaane, bharagwaata na geenyu. ");
INSERT INTO zak_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nawe bharabhakorera goosi gayo kwo okubha muranituniirira enye, kweeki kwe ekigirirye bhatamumenyiri wuno anitumiri. ");
INSERT INTO zak_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Eraabhe nitiingiziri kweebho no okugaamba nabho, ambe bhiingabheeri bhatana ebhibhi. Nawe bhoono, bhatakunagya kwiisasaama kubha bhatana ebhibhi. ");
INSERT INTO zak_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Omuutu wowoosi wuno akunibhiihirirya enye, aramubhiihirirya na Taata. ");
INSERT INTO zak_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nikoriri ebhitiika bhikuru bhino bhikyaari okukorwa no owuundi. Eraabhe bhatiingabhiruuzi, bhaari bharabha bhatana ebhibhi. Nawe bhoono, bharuuzi goosi gano niakoriri, naabhe ego bhakyaari bhanibhiihiriirye na bhamubhiihiriirye Taata. ");
INSERT INTO zak_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gano gatuukiri okubha amangʼana garorekane gano gakaamirwe mu Makaamo Amahoreeru kubha, ‘Bhakamubhiihirirya bhusa.’ ");
INSERT INTO zak_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ndamutumania kweemwe Omusakirya, neewe ni Koro Muhoreeru, niwe akubhakuundukurira abhaatu bhoosi obhuheene. Ararweera ku Taata, na hano akuhika kweemwe, arabhamenyeekererya obhuheene bhwaane. ");
INSERT INTO zak_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kweeki neemwe mwoosi muramenyeekererya amangʼana gaane, kwo okubha mwaari hamwe na neenye okurwa obhweemero. ");
INSERT INTO zak_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nibhabhuuriiri goosi gano okubha mutatiga kuniikirirya. ");
INSERT INTO zak_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nawe abhaatu bharabha bharabhaahura emwe muziinyuumba zye eziisaango zyaabhu. Riraaza eriibhaga rino eraabhe omuutu arabhiita, ariiseega kubha arakora emirimo gya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bharabhakorera ego, kwe ekigirirye bhatamumenyiri Taata, kweeki bhataanimenyiri enye. ");
INSERT INTO zak_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nawe nibhabhuuriiri gayo, okubha eriibhaga ryaabhu ryo okukora gayo hano riraahike, muhiite kubha nibhabhuuriiri. “Nitaabhabhuuriiri gayo goosi kubhutaangiro, kwe ekigirirye niari hamwe neemwe. ");
INSERT INTO zak_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ambe, bhoono ndagya kuwuno yantumiri. Nawe atariho wowoosi gati weenyu wuno akuumbuurya, ‘Mbe, oragya hayi?’ ");
INSERT INTO zak_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mune ebhigoongi bhukongʼu muziikoro zeenyu kwo okubha ndabhabhuurira kubha ndagya ku Taata. ");
INSERT INTO zak_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Ndabhabhuurira obhuheene, ereenderwa enye nigeende, kwo okubha yiingabheeri nitakugya ku Taata, Omusakirya ataari kuuza kweemwe. Nawe eraabhe ndagya, ndamutuma yiize kweemwe. ");
INSERT INTO zak_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hano araaze, arabha arabheerekya abhaatu bhoosi ebho ni bhatemya bhe ebhibhi, na neenye ni we eheene, kweeki Taatabhugya araaza okubhatinira ekiina. ");
INSERT INTO zak_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Arabha arabheerekya ebho ni bhatemya bhe ebhibhi, kwo okubha bhatakuniikirirya enye. ");
INSERT INTO zak_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Areerekya kyeego enye ni we eheene, kwo okubha ndagya ku Taata na mutakuundora kweeki. ");
INSERT INTO zak_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Arabha arabheerekya mwaasi kubha Taatabhugya arabhatinira ekiina, kwe ekigirirye amutiniiri ekiina Seetaani omukaangati we ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nikyaari ninago amangʼana maaru go okubhabhuurira, nawe eriibhaga rino mutakunagya kugamenya. ");
INSERT INTO zak_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ekoro wuyo Omuhoreeru, wuno ahaakuundukura obhuheene, hano akuuza kweemwe, arabhakaangata kumenya obhuheene. Atakugaamba kwo obhuturo bhwaaye omweene, nawe aragaamba gano yiigwiiri no okubhabhuurira gano garaarorekane. ");
INSERT INTO zak_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ekoro wuyo arabhakuundukurira abhaatu obhuguungo bhwaane, kwo okubha arabhabhuurira amangʼana goosi gano obhona akugagega kureka kweenye. ");
INSERT INTO zak_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ebhigiro bhyoosi bhino Taata anabhyo ni bhyaane. Nikyo ekigirirye kino nigaambiri kubha, Ekoro wuyo arabhabhuurira goosi gano akugega kweenye. ");
INSERT INTO zak_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Rikyaari ibhaga isuuhu neemwe mutakunirora, nawe okumara ibhaga isuuhu kweeki muraandora.” ");
INSERT INTO zak_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ambe, abhaanabheega bhaaye abhaandi bhakiibhuurya, “Mbe, obhugazuro bhwa gano niki, ‘Rikyaari ibhaga isuuhu neemwe mutakuundora, nawe okumara ibhaga isuuhu kweeki muraandora,’ na ‘Kwo okubha ndagya ku Taata’?” ");
INSERT INTO zak_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ambe, bhakageenderera okwiibhuurya, “Obhugazuro bhwaku niki, ‘Eriibhaga isuuhu?’ Etwe tutakumenya gano akubhuga.” ");
INSERT INTO zak_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yeesu akamenyeekererya kubha bhakeenda okumubhuurya gano akubhuga, okumara akabhabhuurya, “Mbe, muriibhuurya gano nibhugiri, ‘Rikyaari ibhaga isuuhu neemwe mutakunirora, nawe okumara ibhaga isuuhu kweeki muraandora’? ");
INSERT INTO zak_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ndabhabhuurira obhuheene, emwe murarira no okubha ne ebhigoongi, nawe abhaatu bhe ekyaaro kino bharazomererwa. Murabha ne ebhigoongi, nawe ebhigoongi bhyeenyu bhiriikyoora kubha obhuzomererwa. ");
INSERT INTO zak_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kyeego omukari akugya okwiituurania omwaana, arabha ne ebhigoongi kwo okubha eriibhaga rye enyaako yaaye rihikiri. Nawe hano akumara kwiituurania, atakuhiita kweeki enyaako yiyo yo obhusuungu, kwe ekigirirye kyo obhuzomererwa bhwo okwiibhurwa omwaana mukyaaro. ");
INSERT INTO zak_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kweego ego na neemwe mwoosi mune ebhigoongi kwiibhaga rino. Nawe ndaaza kweeki kweemwe, ambe murabha no obhuzomererwa muziikoro zyeenyu. Atariho wuno akuruusyaho obhuzomererwa bhuyo muziikoro zyeenyu. ");
INSERT INTO zak_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kweeki eriibhaga riyo hano riraahike, mutakumbuurya ngʼana yoyoosi. “Ndabhabhuurira obhuheene, goosi gano muraasabhe kuriina ryaane, Taata arabhaha. ");
INSERT INTO zak_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tee bhoono, mukyaari kusabha kyokyoosi ku Taatabhugya kuriina ryaane. Musabhe neewe arabhaha, okubha obhuzomererwa bhweenyu bhukuunaane. ");
INSERT INTO zak_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ndabhabhuurira goosi gayo kwe enzira ye ebhireengyo. Eriibhaga riraaza rino nitakugaamba neemwe kwe enzira ye ebhireengyo, nawe ndabhabhuurira mwaasi iguru wa Taata. ");
INSERT INTO zak_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mwiibhaga riyo, kuriina ryaane muramusabha Taatabhugya. Nitakugaamba kubha enye ndabhasabhira ku Taata. ");
INSERT INTO zak_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Taata omweene abhaseegiri emwe, kwo okubha muunseegiri enye, kweeki mwiikiriirye kubha nikarwa ku Taata. ");
INSERT INTO zak_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nikaaza mukyaaro kino okurwa ku Taata, nawe bhoono ndarwa mukyaaro hano, ndakyoora ku Taata.” ");
INSERT INTO zak_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ambe abhaanabheega bhaaye bhakamubhuurira, “Bhoono otaangiri okugaamba na neetwe okutama ebhireengyo! ");
INSERT INTO zak_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bhoono tumenyiri kubha omenyiri goosi, naabhe akyaari muutu kukubhuurya kyokyoosi. Gayo nigo gatukoriri okwiikirirya kubha okarwa ku Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yeesu akabhabhuurya, “Mbe, mutaangiri okwiikirirya bhoono? ");
INSERT INTO zak_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Eriibhaga riisukiri, kweeki riri haguhi bhukongʼu, hano bhoosi muraanyaragane. Bhoosi muragya oweenyu, no okunitiga omweene ego. Nawe nitakubha omweene ego, kwo okubha Taata ari hamwe neenye. ");
INSERT INTO zak_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ndabhabhuurira gano goosi okubha mubhe no omureembe muziikoro zyeenyu, kwo okubha muri muusi waane. Mukyaaro hano murabhona eziinyaako nzaru, nawe muteme ekubhi kwo okubha enye nikihiziri ekyaaro.” ");
INSERT INTO zak_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Hano Yeesu yamariri okugaamba goosi gayo, akarora mwiisaaro, akasabha, “Ee Taata, eriibhaga rihikiri. Obheerekye abhaatu obhuguungo bhwo Omwaana waazo, okubha na neewe abheerekye obhuguungo bhwaazo kyeego bhuri. ");
INSERT INTO zak_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kyeego wamuheeri obhuturo bhwo okubhakaangata abhaatu bhoosi, okubha bhano wamuheeri abhahe obhuhoru bhwa kirakeego. ");
INSERT INTO zak_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Obhuhoru bhwa kirakeego nibhwe bhuno, abhaatu bhakumenye awe, Taatabhugya we eheene omweene ego, kweeki bhaanimenye enye Yeesu Krisito, wuno wantumiri kweebho. ");
INSERT INTO zak_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Enye nierekirye obhuguungo bhwaazo kubhaatu bhoosi hano mukyaaro, kwe enzira yo okukuunaania emirimo gino waniheeri kugikora. ");
INSERT INTO zak_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ee Taata, ndasabha weerekye obhuguungo bhwaane, obhuguungo bhuno niari nabhwo eriibhaga turi hamwe, eriibhaga okyaari kuteema ekyaaro. ");
INSERT INTO zak_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ee Taata, nierekirye kyeego awe ori kubhaatu bhano waniheeri mukyaaro hano. Ebho bhaari abhaazo, awe okaaniha enye. Kweeki bhagwaatiri ameegyo gaazo. ");
INSERT INTO zak_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bhoono bhamenyiri kubha ebhigiro bhyoosi bhino okaaniha, bhirwiiri kwaawe, ");
INSERT INTO zak_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kwo okubha nibhabhuuriiri goosi gano okaambuurira, neebho bhasuungʼaaniri. Bhamenyiri obhuheene kubha nirwiiri owaazo, kweeki bhiikiriirye kubha naawe okaantuma. ");
INSERT INTO zak_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ndabhasabhira bhayo, nitakusabhira abhaatu bha mukyaaro, nawe ndabhasabhira bhano waniheeri, kwo okubha bhayo ni bhaazo. ");
INSERT INTO zak_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Abhaatu bhaane bhoosi ni bhaazo, kweeki abhaatu bhaazo bhoosi ni bhaane. Kwe enzira yaabhu, obhuguungo bhwaane bhukuundukwiirwe. ");
INSERT INTO zak_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Bhoono ndarwa mukyaaro hano, na ndaaza owaazo. Nawe ebho bharageenderera kubha mukyaaro hano. Ee Taata Omuhoreeru, ndakusabha obhariibhe kwo obhuturo bhwe eriina ryaazo rino oniheeri, okubha bhabhe bhamwe kyeego enye na naawe turi bhamwe. ");
INSERT INTO zak_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hano niari hamwe neebho nikabhariibha kwo obhuturo bhwe eriina ryaazo bhuno waniheeri. Niabhariibhiri bhuzomu okubha nitamubhurya naabhe owumwe gati waabhu, okutiga wuno akweenderwa okusikibhwa, okubha gakorwe gano gakaamirwe mu Makaamo Amahoreeru. ");
INSERT INTO zak_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ee Taata, bhoono ndaaza owaazo. Enye ndabhabhuurira abhaanabheega bhaane goosi gayo, hano nikyaari mukyaaro kino, okubha bhabhe no obhuzomererwa bhwaane kwo obhukuunaanio muziikoro zyaabhu. ");
INSERT INTO zak_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nibhabhuuriiri amangʼana gaazo. Nawe abhaatu bhe ekyaaro kino bharabhabhiihirira, kwo okubha ebho bhatari bhe ekyaaro kino, kyeego enye nitari we ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Enye ntakusabha kubha obharuusye mukyaaro kino, nawe obhariibhe iguru wa Seetaani, omubhi wurya. ");
INSERT INTO zak_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ebho bhatari bhe ekyaaro kino kyeego enye nitari we ekyaaro kino. ");
INSERT INTO zak_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ee Taata, ndakusabha obheerye kwo obhuheene bhwaazo, kwo okubha engʼana yaazo niyo obhuheene. ");
INSERT INTO zak_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kyeego okaantuma enye mukyaaro, niigo ego na neenye nibhatumiri ebho mukyaaro. ");
INSERT INTO zak_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwiiguru waabhu, ndiiyeerya omweene, okubha neebho obheerye mubhuheene. ");
INSERT INTO zak_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ntakubhasabhira abheene ego, nawe ndabhasabhira bhoosi bhano bhakuuza kuniikirirya kwe ekigirirye kya gano abhaanabheega bhaane bhakweegya. ");
INSERT INTO zak_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ndasabha kubha bhayo bhabhe bhamwe. Ee Taata, ndasabha bhabhe muusi weetu, kyeego awe ori muusi waane, neenye niri muusi waazo. Ndasabha bhabhe bhamwe, okubha abhaatu bhe ekyaaro bhiikirirye kubha naawe okaantuma. ");
INSERT INTO zak_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Obhuguungo bhuno waniheeri enye, nibhaheeri abhaanabheega bhaane, okubha bhabhe bhamwe, kyeego enye na naawe turi bhamwe. ");
INSERT INTO zak_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Enye niri muusi waabhu, na naawe ori muusi waane. Ndasabha bhabhe bhamwe, okubha kwe enzira yiyo abhaatu bhoosi bhe ekyaaro bhamenye kubha ni naawe wuno okaantuma, kweeki bhamenye kubha obhaseegiri kyeego onseegiri enye. ");
INSERT INTO zak_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ee Taata, ndiigoomba bhano oniheeri bhabhe hamwe neenye hano nikubha. Ebho bhabhurore obhuguungo bhwaane bhuno waniheeri, kwo okubha okaanseega okyaari kuteema ekyaaro. ");
INSERT INTO zak_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ee Taata we eheene, abhaatu bhe ekyaaro kino bhatakumenyiri. Nawe enye nikumenyiri, kweeki abhaanabheega bhaane bhamenyiri kubha okaantuma. ");
INSERT INTO zak_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Enye nibheegirye kyeego awe ori, kweeki ndageenderera kukora ego, okubha woosi obhaseege kyeego onseegiri enye, nibhe muusi waabhu.” ");
INSERT INTO zak_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hano Yeesu yamariri kusabha, akatanura na abhaanabheega bhaaye, akagya kumwaambuko gwa Kidirooni, guno gwaari mumuguundu gwe emizeituni. Bhakasikira muyo. ");
INSERT INTO zak_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ambe, Yuuda wuno yaari akugya okumurya omukoonyo Yeesu, akagumenya omuguundu guyo, kwo okubha Yeesu yaari anariri kugya murya mwiibhaga ryaaru hamwe na abhaanabheega bhaaye. ");
INSERT INTO zak_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kweego, Yuuda akakaangata esaango ya abhasirikare, hamwe na abhabhagati okurwa kubhakuru bha abhaseengeri na Abhafarisayo. Bhakagya mumuguundu gurya, bhagwaatiriri eziitara, ebhimuri ne ebhigwaato. ");
INSERT INTO zak_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yeesu akamenya goosi gano garaamubhone, kweego akiiyeerekya, akabhabhuurya, “Mbe, muramukomya weewi?” ");
INSERT INTO zak_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ebho bhakamukyoora, “Turamukomya Yeesu Omunazareeti.” Yeesu akabhakyoora, “Niinye,” Yuuda wuno akamurya omukoonyo Yeesu yaari yiimeereeri hamwe nabho. ");
INSERT INTO zak_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ambe, hano Yeesu yabhabhuuriiri, “Niinye,” abhasirikare bharya bhakakyoora inyuma no okugwa haasi. ");
INSERT INTO zak_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeesu akabhabhuurya kweeki, “Mbe, muramukomya weewi?” Ebho bhakamukyoora, “Turamukomya Yeesu Omunazareeti.” ");
INSERT INTO zak_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yeesu akabhabhuurira, “Nibhabhuuriiri neenye. Eraabhe muranikomya enye, ambe mubhatige abhaandi bhano bhageende.” ");
INSERT INTO zak_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yeesu akabhuga ego okubha gakuunaane gano yagaambiri, “Niari ndabhariibha bhuzomu, okubha nitamubhurya naabhe owumwe mubhano waniheeri.” ");
INSERT INTO zak_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simooni Petero akasohora nyaambato, akamutema no okumutina okutwi kwo obhuryo omugya wo omuseengeri omukuru. Omugya wuyo eriina ryaaye ryaari ni Mariko. ");
INSERT INTO zak_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nawe Yeesu akamubhuurira Petero, “Petero, kyoorya nyaambato mukyoobho kyaaye. Mbe, otamenyiri kubha ndeenderwa kunyaakibhwa kyeego Taata yeendiri?” ");
INSERT INTO zak_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ambe, omukuru wa abhasirikare, hamwe ne esaango yaaye, na abhabhagati bha abhakaangati bha Abhayahudi, bhakamugwaata Yeesu, bhakamubhoha. ");
INSERT INTO zak_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bhakamuhira hiinga ku Anasi, isibhyaara wa Kayafa. Na Kayafa yaari omuseengeri omukuru kwiibhaga riyo. ");
INSERT INTO zak_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Muziisiku zi inyuma, Kayafa niwe wuno akabhatoongera abhakaangati bha Abhayahudi kubha, ni hakiriku omuutu wumwe akwe kwiiguru wa abhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simooni Petero no omwaanamweega owuundi bhaari bharamutuniirira Yeesu kwiinyuma. Omwaanamweega wurya, omuseengeri omukuru yaari amumenyiri, niwe akasikira na Yeesu murukuungu rwe enyuumba yo omuseengeri omukuru. ");
INSERT INTO zak_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nawe Petero akiimeerera igutu we ekiseku. Niho omwaanamweega owuundi wurya wuno omuseengeri omukuru yaari amumenyiri, akagya igutu. Akagaamba no omuukya wumwe wuno yaari akuriibha mukiseku, akamwiikirirya Petero kusikira murukuungu. ");
INSERT INTO zak_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ambe, omuukya omuriibhi wurya, akamubhuurya Petero, “Mbe, naawe woosi otari owumwe wa abhaanabheega bho omuutu wuyo?” Petero akamukyoora, “Zeyi, nitari enye.” ");
INSERT INTO zak_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kwo okubha haari ne embeho, abhagya na abhabhagati bhaari bhiimeereeri bharoota omuriro gwa amakara guno bhaguhuutiri. Petero woosi yaari yiimeereeri hamwe nabho, aroota omuriro. ");
INSERT INTO zak_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ambe omuseengeri omukuru wurya, eriina ryaaye Anasi, akamubhuurya Yeesu amangʼana iguru wa abhaanabheega bhaaye na ameegyo gaaye. ");
INSERT INTO zak_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yeesu akamukyoora, “Eriibhaga ryoosi niari ndagaamba kubhaatu bhoosi mwaasi. Eziisiku zyoosi niari ndeegya abhaatu muziinyuumba zye esaango na mwiigoobhe rye eriiseengerero muno Abhayahudi bhaaru bhakwiikumania hamwe. Niteegirye ameegyo gaane kwa mbiso. ");
INSERT INTO zak_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ambe kwaki murambuurya enye? Ambe kwaki otakubhabhuurya abhaatu bhano bhaari bhakuniitegeerera hano niari kweegya? Ebho bhagamenyiri gano niari nikugaamba no okweegya.” ");
INSERT INTO zak_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hano Yeesu yabhugiri gayo, omusirikare wumwe wuno yaari yiimeereeri haguhi neewe akamutema oruhi, akamubhuurya, “Mbe, oramukyoora ego omuseengeri omukuru?” ");
INSERT INTO zak_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yeesu akamukyoora, “Eraabhe nigaambiri bhubhi, ogaambe obhubhi bhwaane. Nawe eraabhe nigaambiri obhuheene, ambe kwaki orantema?” ");
INSERT INTO zak_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ambe, eriibhaga Yeesu yaari akyaari abhohirwe, Anasi akaswaagya kubha bhamuhire kumuseengeri omukuru, Kayafa. ");
INSERT INTO zak_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ambe, hano Simooni Petero yaari akyaari aroota omuriro, abhaatu abharebhe bhakamubhuurya, “Angu, naawe woosi otari owumwe wa abhaanabheega bhaaye?” Petero akaanga, akabhuga, “Zeyi, ntari enye.” ");
INSERT INTO zak_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nawe owumwe wa abhagya bho omuseengeri omukuru wuno yaari omuhiiri wo omuutu wurya wuno Petero yamutiniri okutwi, akamubhuurya, “Mbe, enye nitakuruuzi eriibhaga waari hamwe na Yeesu mumuguundu?” ");
INSERT INTO zak_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petero akaanga kweeki, “Nitari enye.” Hayohayo, ekorokoome ekagaamba. ");
INSERT INTO zak_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ambe, hano kwakiiri, abhakaangati bha Abhayahudi bhakamugega Yeesu kurwa wa Kayafa tee kumwaanaangwa wa Abharooma. Nawe ebho bhataasikiiri munyuumba yaaye okubha bhatabha makire na bhataanagirye kurya ebhyaakurya bhye Enyaangi yo Okuhiita. ");
INSERT INTO zak_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ambe omwaanaangwa wa Abharooma, eriina ryaaye Pirato, akagya igutu no okugya hano bhaari bhariho, akabhabhuurya, “Mbe, omuutu wuno akoriri ebhibhiki bhino mukumusema?” ");
INSERT INTO zak_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ebho bhakamukyoora, “Eraabhe omuutu wuno atiingabheeri ne ebhibhi, tutiinganagirye okuuza neewe kwaawe.” ");
INSERT INTO zak_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pirato akabhabhuurira, “Ambe emwe mumugege, mumutinire ekiina kuriingʼaana ne emigiro gyeenyu.” Nawe abhakaangati bha Abhayahudi bhakamukyoora, “Tutana obhuturo bhwo okumutinira ekiina omuutu wowoosi kubha akwe.” ");
INSERT INTO zak_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gayo gakakoreka ego, okubha amangʼana gano Yeesu yagaambiri gakuunaane okweerekya kyaabhurya araakwe. ");
INSERT INTO zak_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ambe, Pirato akasikira kweeki munyuumba, akaswaagya kubha bhamureete Yeesu kweewe, akamubhuurya, “Awe naawe omutemi wa Abhayahudi?” ");
INSERT INTO zak_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nawe Yeesu akamukyoora, “Mbe, gano okuumbuurya gararwa mumiiseego gaazo kasi abhaatu abhaandi bhakubhuuriiri amangʼana iguru waane?” ");
INSERT INTO zak_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pirato akamukyoora, “Mbe, enye ni Muyahudi? Niigo, abhaatu bhe ekigaambo kyaazo hamwe na abhakuru bha abhaseengeri nibho bhano bhakureetiri kweenye okubha nikutinire ekiina. Mbe, okoriri isaryaki?” ");
INSERT INTO zak_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yeesu akamukyoora, “Obhutemi bhwaane bhutari bhwe ekyaaro kino. Eraabhe bhuungabheeri bhwe ekyaaro kino, ambe abhaanabheega bhaane bhaanganirwaaniiri okubha nitagwaatwa na Abhayahudi. Nawe obhutemi bhwaane bhutari bhwa hano.” ");
INSERT INTO zak_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ambe, Pirato akamubhuurya, “Mbe, ambe ni heene kubha awe ni mutemi?” Yeesu akamukyoora, “Ni awe ogaambiri kubha enye ni mutemi. Enye nikiibhurwa mukyaaro kino, kweeki nikaaza mukyaaro okubha nimenyeekererye abhaatu obhuheene. Omuutu wowoosi wuno akubhutuniirira obhuheene, aragiigwa amangʼana gaane.” ");
INSERT INTO zak_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pirato akamubhuurya, “Obhuheene niki?” Hano Pirato yagaambiri gayo, akahuruka igutu kweeki, akabhabhuurira abhakaangati bha Abhayahudi, “Enye nitakurora ekiina kya amasemo kumuutu wuno. ");
INSERT INTO zak_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nawe mune eziinyaangi zyo okunisabha okubhiigurira omubhohwa wumwe eriibhaga rye Enyaangi yo Okuhiita. Mbe, mureenda nibhiigurire omutemi wa Abhayahudi?” ");
INSERT INTO zak_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nawe abhaatu bhoosi bhakakora ekituri bhakubhuga, “Zeyi! Otatwiigurira omuutu wuyo, nawe otwiigurire Baraaba.” Baraaba yaari abhohirwe munyuumba ya abhabhohwa kwe ekigirirye kyo okuhakania eserikaare ya Abharooma. ");
INSERT INTO zak_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ambe, Pirato akaragania abhasirikare bhaaye kubha bhamugege Yeesu, bhamuteme emijariti. ");
INSERT INTO zak_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abhasirikare bhakoogosa orusuurya rwa amahwa, bhakamwiibhohya kumutwe. Bhakamwiibhohya omweenda gwe eraangi ye ezambaraau. ");
INSERT INTO zak_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhakabha bharamugyaku, bharamukeerya bharabhuga, “Kasiinga rugabho, ee omutemi wa Abhayahudi!” Eno bhakumutema eziihi. ");
INSERT INTO zak_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pirato akahuruka igutu kweeki, akabhabhuurira abhakaangati bha Abhayahudi bharya, “Mwiitegeerere, ndamureeta igutu kweemwe omuutu wuno, okubha mumenye kubha nitakurora ekiina kya amasemo kyokyoosi kweewe.” ");
INSERT INTO zak_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ambe, niho Yeesu akahuruka igutu eno yiibhohiri orusaangarya rwa amahwa no omweenda gwe ezambaraau. Ambe, Pirato akagaamba mwaasi, “Rora, omuutu omweene ni wuyo.” ");
INSERT INTO zak_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hano abhakuru bha abhaseengeri na abhasirikare bhe eriiseengerero bhaamuruuzi Yeesu, bhakakora ekituri bhakubhuga, “Mumubhaambe kumusaraba, mumubhaambe kumusaraba!” Ambe, Pirato akabhabhuurira, “Mumugege emwe abheene mugye mumubhaambe kumusaraba, kwo okubha enye nikyaari kubhona isarya ryoryoosi kweewe.” ");
INSERT INTO zak_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Abhakaangati bha Abhayahudi bhakamukyoora, “Etwe tunagyo emigiro. Kuriingʼaana ne emigiro giyo, areenderwa okwiitwa, kwe ekigirirye ariigaamba kubha ni Mwaana wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hano Pirato yiigwiiri amangʼana gayo, akoobhoha kukiraho bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ambe, akasikira kweeki munyuumba, akamubhuurya Yeesu, “Awe orwiiri hayi?” Nawe Yeesu ataamukyooriri ryoryoosi. ");
INSERT INTO zak_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ambe, Pirato akamubhuurira, “Kwaki otakunikyoora? Mbe, otamenyiri kubha nino obhunagya bhwo okukutazura, kweeki bhwo okukutemerera kumusaraba?” ");
INSERT INTO zak_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yeesu akamukyoora Pirato, “Otiingabheeri no obhunagya bhwobhwoosi iguru waane eraabhe otiingaheerwe na Taatabhugya. Kweego omuutu wuno anituuriri mumabhoko gaazo ane ebhibhi bhikuru bhukongʼu kukira ebhibhi bhyaazo.” ");
INSERT INTO zak_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ambe, hano Pirato yiigwiiri gayo, akasakya kukomya enzira yo okumutazura Yeesu, nawe Abhakaangati bha Abhayahudi bhakakora ekituri kweeki bhakubhuga, “Eraabhe oraamutazure omuutu wuyo, ambe awe otari omusaani wa Kaisari. Omuutu wowoosi wuno akwiikora kubha mutemi, aramuhakania Kaisari.” ");
INSERT INTO zak_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hano Pirato yiigwiiri amangʼana gayo, akamureeta Yeesu igutu, ewe akagya kwiikara kukituumbi kyo okutinira ekiina, ahagiro hano bhakabhirikira Orukuungu rwa Amagina. Kukigaambo kye Ekieburania bharabhuga Gabata. ");
INSERT INTO zak_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yaari ehikiri eriibhaga rya kasaasabha murusiku rwo okwiibhanura kwiiguru ye Enyaangi yo Okuhiita. Pirato akabhabhuurira Abhayahudi, “Rora, omutemi weenyu nguno!” ");
INSERT INTO zak_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ebho bhakakora ekituri bhakabhuga, “Mumwiite, mumwiite! Mumubhaambe kumusaraba!” Pirato akabhabhuurya, “Mbe, mureenda nimubhaambe kumusaraba omutemi weenyu?” Abhakuru bha abhaseengeri bhakamukyoora, “Etwe tutana omutemi owuundi nawe Kaisari!” ");
INSERT INTO zak_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ambe mubhuteero Pirato akaswaagya agegwe, atemererwe kumusaraba. Ambe, abhasirikare bhakamugega Yeesu no okugya neewe. ");
INSERT INTO zak_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Akagega omusaraba gwaaye, akatanura mumugye, akagya hagiro hano haabhirikiirwe Gorigota mukigaambo kye Ekieburania, obhugazuro bhwaku Ekihaanga kyo Omutwe. ");
INSERT INTO zak_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hano bhaahikiri harya, bhakamutemerera Yeesu kumusaraba. Hagiro haryaharya bhaari bhariho abhaatu abhaandi bhabhiri bhano bhakabhatemerera kumisaraba hamwe neewe, owumwe orubhaara rwo obhuryo no owuundi orubhaara rwo obhumosi. ");
INSERT INTO zak_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pirato akaswaagya kubha, gakaamwe amangʼana no okutuurwa kumusaraba gwa Yeesu, garabhuga, “Yeesu wa Nazareeti, Omutemi wa Abhayahudi.” ");
INSERT INTO zak_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Amakaamo gayo gakaamirwe mukigaambo kye Ekieburania, Ekirooma ne Ekiyunaani. Abhayahudi bhaaru bhaari bharasoma amakaamo gayo, kwe ekigirirye ahagiro hano bhaamutemereeri Yeesu kumusaraba haari haguhi na Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ambe, abhakuru bha abhaseengeri bhakamubhuurira Pirato, “Otakaama, ‘Omutemi wa Abhayahudi,’ nawe kaama, ‘Omuutu wuno akabhuga kubha ewe ni omutemi wa Abhayahudi.’ ” ");
INSERT INTO zak_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pirato akabhakyoora, “Zeyi, gano nikaamiri gasaage egoego kyeego nikaamiri.” ");
INSERT INTO zak_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hano abhasirikare bhamutemereeri Yeesu kumusaraba, bhakagega emyeenda gyaaye, bhakatwaania magazo ane. Abhasirikare bhayo kwo owumwe, akagega eriigazo ryaaye. Kweeki, bhakagega eriigooti ryaaye. Eriigooti ryaari ryoogosirwe, bhakahokeerya ekitinika kimwe kyo omweenda, gutaari na mutumo naabhe gumwe. ");
INSERT INTO zak_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ambe, bhakiibhuurira, “Tutaraandura omweenda guno, nawe tuteme obhwiitoori, turore, gurabha gwa weewi.” Gayo gakakorwa ego, okubha gakuunaane gano gakaamirwe mu Amakaamo Amahoreeru kubha, “Bhakatwaana emyeenda gyaane, no okutema obhwiitoori iguru yo omweenda gwaane.” Nigo gano bhaakoriri abhasirikare. ");
INSERT INTO zak_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ambe, bhaari bhariho abhakari abhaandi bhane bhano bhaari bhiimeereeri haguhi no omusaraba gwa Yeesu. Gati wa abhakari bhayo yaariho nina waabhu Yeesu, nina waabhu omusuuhu wa Yeesu, Mariamu omukari wa Kireopa, na Mariamu wa mumugye gwa Magidara. ");
INSERT INTO zak_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Hano Yeesu yamuruuzi nina waabhu no omwaanamweega wuno akamuseega bhukongʼu yiimeereeri haguhi na nina waabhu, akabhuga, “Ee maayi, wuyo niwe omwaana waazo.” ");
INSERT INTO zak_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kweeki akamubhuurira omwaanamweega wurya, “Awe wuyo niwe nina weenyu.” Ambe, okurwa eriibhaga riryarirya omwaanamweega wuyo, akamugega nina waabhu Yeesu, akagya kwiikara neewe mumugye gwaaye. ");
INSERT INTO zak_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ambe, Yeesu akamenyeekererya kubha yaari amariri kugikora emirimo gyoosi. Ambe, akabhuga, “Ndiigwa enyoota.” Gayo, gakatuuka okubha gakuunaane kyeego gakaamirwe mu Amakaamo Amahoreeru. ");
INSERT INTO zak_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ahagiro harya haari ne ekigiro kikiizura amaanzi amaruru go omuzabibu gari musuka. Ambe, bhakagega epaamba, bhakatobhya mumaanzi amaruru go omuzabibu gayo, bhakagazya kumaara, bhakamutuurira Yeesu kumunwa. ");
INSERT INTO zak_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yeesu hano yasamiri amaanzi amaruru go omuzabibu gayo, akabhuga, “Emirimo gyaane gihwiiri!” Akiinamya omutwe, akatina ekoro. ");
INSERT INTO zak_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Orusiku ruyo, rukabha orusiku rwo okubhanura no orusiku rwo okumuunya runo rwaari rukuru kukira rwo obhutuuro ku Nyaangi yo Okuhiita. Nikyo abhakaangati bha Abhayahudi bhateendiri ebhituundu bhisaage iguru yo omusaraba kurusiku rwo okumuunya. Ambe bhakagya ku Pirato, bhakamusabha kubha abhasirikare bhagye bhabhabhune amaguru abhaatu bhano bhakatemererwa, no okuruusyaho ebhituundu bhyaabhu kumisaraba. ");
INSERT INTO zak_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ambe, abhasirikare bhakagya, bhakamubhuna amaguru omuutu wo okutaanga na wa kabhiri bhano bhaari bhabhatemereeri hamwe na Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nawe hano bhakagya ku Yeesu, bhakabhona akuuri, kweego bhataamubhuniri amaguru. ");
INSERT INTO zak_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nawe owumwe wa abhasirikare akamusoma Yeesu ne eriitimu murubharu. Amanyiinga na amaanzi gakarwa. ");
INSERT INTO zak_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Amangʼana gayo gakaamirwe no omuutu wuno yaari akurora gano gakukoreka. Gano akumenyeekererya ni ge eheene, woosi amenyiri kubha gano akubhuga ni ge eheene, okubha na neemwe mwiikirirye. ");
INSERT INTO zak_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gayo gakakoreka okubha gakuunaane gano gakaamirwe mu Makaamo Amahoreeru, “Ritariho eriiguha ryaaye rino riraabhunike.” ");
INSERT INTO zak_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kweeki Amakaamo Amahoreeru garabhuga, “Bharaaza kumurora wuno bhaamusomiri.” ");
INSERT INTO zak_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ambe, okuhita gayo, akaaza omuutu owumwe eriina ryaaye Yusufu, wuno akarwa mumugye gwa Arimataya. Omuutu wuyo yaari omwaanamweega wa Yeesu, nawe kwa mbiso, kwo okubha yaari aroobhoha abhakaangati bha Abhayahudi. Ambe, omuutu wurya akagya ku Pirato, akamusabha kubha agege ekituundu kya Yeesu, akibhiike. Pirato akamwiikirirya. Kyaamwe, Yusufu akagya, akaruusyaho ekituundu kya Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Niho, Nikodemo wuno yaari agiiri ku Yeesu obhutiku, akaaza na amaguta go omuruumbaaso gano gasaangiibhwe na manemane, gaari eziikiro emiroongo etatu (30). ");
INSERT INTO zak_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ambe, abhabhiri bhayo bhakagega ekituundu kya Yeesu, bhakakiriizirira mumweenda gwo obhuguri bhukuru, bhakakihaka amaguta go omuruumbaaso kuriingʼaana ne enyaangi ya Abhayahudi yo okubhiika abhaatu. ");
INSERT INTO zak_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ahagiro hano bhakamutemerera Yeesu gwaari gureho omuguundu. Mumuguundu muyo, yaari erimu embiihira ehya yino bhakyaari kumubhiika omuutu wowoosi. ");
INSERT INTO zak_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Orusiku ruyo, Abhayahudi bhahiibhanura kurusiku rwo okumuunya. Kwe ekigirirye kiyo, bhakamubhiika Yeesu mumbiihira yirya kwo okubha yaari haguhi. ");
INSERT INTO zak_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Orusiku rwo okutaanga rwo obhutuuro, etabhoori zuri, Mariamu wa mumugye gwa Magidara akagya kumbiihira ya Yeesu. Akabhona eriigina rihuungwiirwe okurwa mukiseku kye embiihira. ");
INSERT INTO zak_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ambe, akaryaara harya, akagya ku Simooni Petero na kumwaanamweega wuno Yeesu yaamuseegiri. Akabhabhuurira, “Abhaatu bhakiruusiryeho ekituundu kyo Omukuru weetu mumbiihira, kweeki tutamenyiri hano bhakituuriri!” ");
INSERT INTO zak_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Petero no omwaanamweega owuundi wurya bhakatanura, bhakeerekera kumbiihira. ");
INSERT INTO zak_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhoosi bhabhiri bhaari bhararyaara, nawe omwaanamweega wurya owuundi akaryaara kumuhita Petero no okukaangata kuhika kumbiihira. ");
INSERT INTO zak_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akiihiinya, akasoomya mumbiihira, akayirora engibho ndabhu yino bhaamubhiikiirimu Yeesu, nawe ataasikiiri muusi. ");
INSERT INTO zak_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ambe, Simooni Petero akamutuna, akahika harya, akasikira mumbiihira no okuyibhona engibho ndabhu yino bhaamubhiikirimu Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kweeki akakibhona ne ekitaambaara kino bhaamubhoheeri Yeesu kumutwe. Ekitaambaara kiyo kitaari hamwe ne engibho eyiindi, nawe kikakunywa no okutuurwa embarika. ");
INSERT INTO zak_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ambe, omwaanamweega owuundi wurya, wuno akakaangata kuhika harya, neewe akasikira mumbiihira. Akarora no okwiikirirya. ");
INSERT INTO zak_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bhaari bhakyaari okumenya Amakaamo Amahoreeru gano garabhuga kubha, Yeesu ereenderwa aryooke okurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ambe, abhaanabheega bharya bhakagya owaabhu. ");
INSERT INTO zak_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Nawe Mariamu wa mumugye gwa Magidara akasaaga no okwiimeerera igutu mumbiihira, yaari ararira. Hano yaari ararira, akiihiinya no okusoomya mumbiihira, ");
INSERT INTO zak_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","akabharora bhamaraika bhabhiri bhano bhiibhohiri emyeenda emirabhu. Bhakiikara hano bhaari bhahiindiirye ekituundu kya Yeesu. Maraika wumwe akiikara orubhaara rwa kumutwe, owuundi akiikara orubhaara rwa mumaguru. ");
INSERT INTO zak_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bhamaraika bharya bhakamubhuurya, “Ee maayi, kwaki orarira?” Neewe akabhakyoora, “Abhaatu bhakiruusiryeho ekituundu kyo Omukuru waane, kweeki nitamenyiri hano bhakituuriri!” ");
INSERT INTO zak_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hano Mariamu yabhugiri amangʼana gayo, akiikibhuka, akamurora Yeesu yiimeereeri haryaharya, nawe Mariamu ataamumenyiri. ");
INSERT INTO zak_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yeesu akamubhuurya, “Ee maayi, kwaki orarira? Mbe, oramukomya weewi?” Mariamu yiiseegiri kubha omuutu wurya yaari omuhokya wo omuguundu, kweego akamukyoora, “Ee taata, eraabhe naawe oruusiryeho ekituundu kyaaye, mbuurira hano okituuriri, neenye ndagya kukigega.” ");
INSERT INTO zak_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yeesu akamubhirikira eriina ryaaye, “Mariamu!” Ambe Mariamu akiikibhuka, akamurora Yeesu, akabhuga mukigaambo kye Ekieburania, “Raboni!” Obhugazuro bhwaku ni Omweegya. ");
INSERT INTO zak_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yeesu akamubhuurira, “Otaanigwaata, kwo okubha nkyaari kugya mwiisaaro ku Taata. Ambe, noogye obhabhuurire abhahiiri bhaane, kubha ndagya mwiisaaro ku Taata, neewe ni Wuuso weenyu, ku Taatabhugya waane, neewe ni Taatabhugya weenyu.” ");
INSERT INTO zak_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ambe Mariamu wa mumugye gwa Magidara akagya kubhaanabheega bha Yeesu, akabhabhuurira amangʼana gayo, “Enye nimuruuzi Omukuru!” Kyaamwe, akabhakeerenerya goosi gano Yeesu amuswaagirye. ");
INSERT INTO zak_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hano yahikiri engoroobha orusiku rurya rwo okutaanga rwo obhutuuro, abhaanabheega bha Yeesu bhakiikumania munyuumba yimwe no okwiigara ebhiseku, kwo okubha bhaari bharoobhoha abhakaangati bha Abhayahudi. Kituukiro Yeesu akahwaaruka no okwiimeerera gati waabhu, akabhabhuurira, “Omureembe gubhe neemwe.” ");
INSERT INTO zak_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kyaamwe, akabheerekya amabhoko gaaye no orubharu rwaaye. Hano abhaanabheega bhamuruuzi Omukuru, bhakazomererwa bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeesu akabhabhuurira kweeki, “Omureembe gubhe neemwe. Kyeego Taata akaantuma enye, egoego na neenye ndabhatumania emwe.” ");
INSERT INTO zak_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Okumara, akabhahuutira omwiika, akabhabhuurira, “Musuungʼaane Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Eraabhe murabhaabhira abhaatu ebhibhi bhyaabhu, Taatabhugya neewe arabhaabhira ebhibhi bhyaabhu. Eraabhe mutakubhaabhira, Taatabhugya woosi atakubhaabhira.” ");
INSERT INTO zak_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Omwaanamweega wumwe mubhaanabheega bha Yeesu, eriina ryaaye Tomaso, wuno bhaamubhirikiiri Mbasa, ataari hamwe na abhaanabheega abhaandi hano Yeesu yabhahwaarukiiri. ");
INSERT INTO zak_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ambe, abhaanabheega abhaandi bharya bhakamubhuurira, “Etwe tumuruuzi Omukuru!” Nawe ewe akabhakyoora, “Enye nitakunagya okwiikirirya gayo eraabhe nikyaari kurora hiinga eziikoru zye emisumaari mumabhoko gaaye no okutuura ekyaara kyaane muziikoru ziyo, no okutuura okubhoko kwaane murubharu rwaaye.” ");
INSERT INTO zak_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hano eziisiku inyaanye zyahitiri, abhaanabheega bha Yeesu bhakiikumania hamwe kweeki munyuumba. Orusiku ruyo, Tomaso neewe yaari hamwe nabho. Ebhiseku bhyaari bhiigeeri, nawe, Yeesu akarorekana mwaasi, akiimeerera gatigati waabhu, akabhakeerya, “Omureembe gubhe neemwe.” ");
INSERT INTO zak_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ambe, Yeesu akamubhuurira Tomaso, “Ee Tomaso, nawuuze onikunieku ne ekyaara ekyaazo hano, ogarore amabhoko gaane. Kweeki, onigwaateku no okubhoko kwaazo murubharu rwaane. Otabha no obhwiitiimaati, nawe wiikirirye.” ");
INSERT INTO zak_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaso akamukyoora, “Omukuru waane na Taatabhugya waane!” ");
INSERT INTO zak_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yeesu akamukyoora, “Wiikiriirye kwo okubha onduuzi. Bhatweereerwe ebhite bhano bhaniikiriirye yiingabha bhakyaari kuundora.” ");
INSERT INTO zak_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yeesu akakora ebhyeerekenio ebhiindi bhyaaru bhino abhaanabheega bhaaye bhakabhirora, na bhino bhitaakaamirwe mukitabhu kino. ");
INSERT INTO zak_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nawe ebhyeerekenio bhino bhiri mukitabhu kino bhikaamirwe okubha emwe mwiikirirye Yeesu niwe Masiya, Omwaana wa Taatabhugya, no okubha kwo okumwiikirirya, mubhone obhuhoru bhwa kirakeego kuriina ryaaye. ");
INSERT INTO zak_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ambe, okuhita gayo, Yeesu akabhahwaarukira kweeki abhaanabheega bhaaye embarika we Enyaanza ya Tiberia. Ego niigo akiiyeerekya. ");
INSERT INTO zak_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Bhaari bhariho Simooni Petero, Tomaso wuno eriina eriindi ni Mbasa, Natanieri wuno yarwiiri Kana ya Gariraaya, abhaana bhabhiri bha Zebedaayo na abhaanabheega abhaandi bhabhiri. ");
INSERT INTO zak_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simooni Petero akabhabhuurira abharikyaaye, “Ndagya munyaanza okutega eziiswe.” Ebho bhakamukyoora, “Na neetwe turagya hamwe na naawe.” Ambe bhakagya, bhakatiira mubhwaato, bhakatega obhutiku bhwoosi, nawe bhataagwaatirye eziiswe zyozyoosi. ");
INSERT INTO zak_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Etabhoori zuri, Yeesu akiimeerera embarika we enyaanza, nawe abhaanabheega bhaaye bhataamenyiri kubha ni Yeesu. ");
INSERT INTO zak_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ambe, Yeesu akabhabhirikira, “Emwe abhasaani bhaane, mbe, mukyaari kubhona eziiswe zyozyoosi?” Ebho bhakamukyoora, “Zeyi.” ");
INSERT INTO zak_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yeesu akabhabhuurira, “Mutaase orweero orubhaara rwo obhuryo rwo obhwaato, muragwaata eziiswe.” Ambe, bhakarekera orweero munyaanza, nawe bhakatamwa okururuta kwe ekigirirye bhakagwaatya eziiswe nzaru bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Omwaanamweega wuno Yeesu yaamuseegiri bhukongʼu, akamubhuurira Petero, “Ni Mukuru!” Hano Simooni Petero yiigwiiri kubha ni Mukuru, akiibhoha emyeenda gyaaye gino yaruusirye hano yataangiri okutega, akiirekera munyaanza. ");
INSERT INTO zak_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abhaanabheega abhaandi bhakagya kurungʼoongo rwe enyaanza no obhwaato, kwo okubha bhataari kure, nawe bhaari mataambuka igana rimwe (100) ego. Bhakaruruta orweero runo rwiizwiiri eziiswe. ");
INSERT INTO zak_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hano bhaahikiri embarika we enyaanza, bhakabha no omukaate no omuriro gwa amakara guno eziiswe zikukarwaku. ");
INSERT INTO zak_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yeesu akabhabhuurira abhaanabheega bhaaye, “Muuze, mureete hano eziiswe ezimwe zino mutegiri.” ");
INSERT INTO zak_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ambe, Simooni Petero akatiira mubhwaato, akabhuruta embarika orweero rurya runo rwiizwiiri eziiswe. Murweero rurya zyaari zirimu eziiswe eziikuru igana rimwe miroongo etaano ni isatu (153). Yiingabha eziiswe zyaari nzaru bhukongʼu, nawe orweero rutaaraandukiri. ");
INSERT INTO zak_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yeesu akabhabhuurira abhaanabheega bhaaye, “Muuze murye ebhyaakurya.” Ataari ariho omwaanamweega wuno akasakya okumubhuurya, “Awe naawe weewi?” kwo okubha bhakamenya kubha ni Mukuru. ");
INSERT INTO zak_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ambe Yeesu akaaza, akagega omukaate, akabhaha abhaanabheega bhaaye. Kweeki, akagega eziiswe nazyo, akakora egoego. ");
INSERT INTO zak_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ruyo rwaari rugeendo rwa katatu Yeesu okubhahwaarukira abhaanabheega bhaaye, okweema hano Taatabhugya yaari amuryooriri okurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hano bhaamariri kurya, Yeesu akamubhuurya Simooni Petero, “Simooni, omwaana wa Yohana, eheene, onseegiri enye bhukongʼu kubhakira abharikyaazo bhano kyeego bhanseegiri?” Petero akamukyoora, “Hee, Omukuru, omenyiri kubha nikuseegiri.” Yeesu akamubhuurira, “Riisya eziingʼoondu zyaane.” ");
INSERT INTO zak_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeesu akamubhuurya Petero rwa kabhiri, “Simooni, omwaana wa Yohana, eheene, onseegiri?” Petero akamukyoora, “Hee, Omukuru, omenyiri kubha ndakuseega.” Yeesu akamubhuurira, “Riibha eziingʼoondu zyaane.” ");
INSERT INTO zak_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akamubhuurya rugeendo rwa katatu, “Simooni, omwaana wa Yohana, eheene, onseegiri?” Ambe, Petero akabha ne ebhigoongi kwe ekigirirye akamubhuurya rugeendo rwa katatu, “Eheene, onseegiri?” Akamukyoora, “Ee Omukuru, omenyiri goosi. Omenyiri kubha nikuseegiri.” Yeesu akamubhuurira akabhuga, “Riisya eziingʼoondu zyaane. ");
INSERT INTO zak_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ndakubhuurira obhuheene, hano waari mumura, okanara okwiibhoha eziingibho zyaazo omweene, no okugya hano okweenda. Nawe hano okukuunguha, oragororokya amabhoko gaazo no omuutu owuundi arakwiibhohya eziingibho zyaazo no okukuhira hano otakweenda kugya.” ");
INSERT INTO zak_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yeesu akabhuga ego okweerekya kyeego Petero araakwe, okubha abhaatu bhamuguungye Taatabhugya. Ambe, Yeesu akamubhuurira Petero, “Ontuniirire.” ");
INSERT INTO zak_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ambe, Petero akiikibhuka, akamurora omwaanamweega wuno Yeesu yaamuseegiri bhukongʼu, yaari arabhatuniirira. Omwaanamweega wuyo, niwe akiiyegeka haguhi na Yeesu hano bhahaarya ebhyaakurya, no okumubhuurya, “Ee Omukuru, ni weewi arakurye omukoonyo?” ");
INSERT INTO zak_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ambe, hano Petero yamuruuzi omwaanamweega wurya, akamubhuurya Yeesu, “Ee Omukuru, mbe, erabhabhwi kumwaanamweega wuyo?” ");
INSERT INTO zak_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yeesu akamukyoora, “Eraabhe ndeenda abhe muhoru tee hano ndaakyoore, kwaki gayo garakunyaakya? Awe onituniirire.” ");
INSERT INTO zak_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kwe ekigirirye kiyo, abharikyaaye bhaaru bhakiiseega kubha omwaanamweega wuyo atakukwa na rumwe. Nawe Yeesu ataamubhuuriiri omwaanamweega wuyo atakukwa na rumwe, nawe akabhuga, “Eraabhe ndeenda abhe muhoru tee hano ndaakyoore, kwaki gayo garakunyaakya?” ");
INSERT INTO zak_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Omwaanamweega wuyo niwe wuno yamenyeekereerye gano no okugakaama. Etwe tumenyiri kubha gano akubhuga ni ge eheene. ");
INSERT INTO zak_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gariho amangʼana agaandi maaru gano Yeesu yagakoriri. Eraabhe goosi gayo gaangakaamirwe, ndiiseega ekyaaro kyoosi kitiingisiri okutuura ebhitabhu bhino bhyaangakaamirwe.");
INSERT INTO zak_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Omuguungibhwa Teofiro, mukitabhu kyaane kyo okutaanga, nikakukaamira iguru wa amangʼana goosi gano Yeesu yataangiri kukora no okweegya, okurwa obhweemero bhwe emirimo gyaaye, ");
INSERT INTO zak_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tee orusiku runo yagegirwe kugya mwiisaaro. Hano yaari akyaari kugegwa, akabhaha abheega bhaaye amaragiriro kwe enzira ye Ekoro Muhoreeru, akabhaha abheegya bhaaye amaragiriro, bhano yabhasoriri iguru we emirimo gino bharaagikore. ");
INSERT INTO zak_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kwe eziisiku miroongo ene (40) okurwa hano Yeesu yakuuri no okuryooka, yaari arabhahwaarukira abheega bhaaye. Akabheerekya heene ari muhoru kwe ebhyeerekenio bhyaaru, na yaari arabheegya amangʼana go obhutemi bhwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Orusiku rumwe, hano Yeesu yaari na abheega bhaaye, akabhaswaagya, “Mutarwa Yerusaremu, nawe muganye okusuungʼaana Ekoro Muhoreeru, wuno Taata yabharagiri kuhitira amangʼana gaane. ");
INSERT INTO zak_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana Omubatiizi, akabatiiza abhaatu mumaanzi, nawe eriibhaga rya siku suuhu, murabha murabatiizwa kwe Ekoro Muhoreeru.” ");
INSERT INTO zak_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ambe, abheega hano bhaari bhiikumeenie hamwe na Yeesu, bhakamubhuurya, “Omukuru, eriibhaga rino niryo oraabhakyoorerye Abhiiziraeri obhutemi bhwaabhu?” ");
INSERT INTO zak_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yeesu akabhakyoora, “Mutakweenderwa kumenya eziisiku ne eriibhaga rino riri mubhuturo bhwa Taatabhugya, kwo okubha ni Taata omweene kubhuturo bhwaaye amenyiri garatuuka ryoori. ");
INSERT INTO zak_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nawe murasuungʼaana amanaga hano Ekoro Muhoreeru araabhiikire. Emwe murabha abhamenyeekererya bhaane Yerusaremu, na ahagiro hoosi ha Yudea na Samaria, na tee obhuteero bhwe ekyaaro kyoosi.” ");
INSERT INTO zak_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hano Yeesu yamariri kubhabhuurira abheega bhaaye gayo, eriibhaga bhaari bhakyataangarireeni, rugeendo rumwe Yeesu akagegwa kugya mwiisaaro. Eriisaaro rikamukuundikirya, bhataamuruuzi kweeki. ");
INSERT INTO zak_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hano bhaari bhakyataangariiri mwiisaaro, kituukiro, abhasubhe bhabhiri bhano bhaari bhiibhohiri emyeenda emirabhu pee, bhakiimeerera haguhi nabho. ");
INSERT INTO zak_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Abhasubhe bhabhiri bhayo bhakabhuga, “Emwe abhaatu bha Gariraaya, ndora mwiimeereeri eno murarora mwiisaaro? Yeesu wuno agegirwe kweemwe kugya mwiisaaro, arakyoora kweeki, kyeegoego mumuruuzi aragya mwiisaaro.” ");
INSERT INTO zak_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kyaamwe, abheega bhakakyoora Yerusaremu kurweera mukiguru kino kikubhirikirwa Ekiguru kye Emizeituni, kino kyaari obhweema bhwa amataambuka kikwe kimwe ego (1,000). ");
INSERT INTO zak_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hano bhaahikiri Yerusaremu, bhakatiira mukyuumba kye ekinazo muno bhaari kwiikara. Abheega bhayo bhaari Petero, Yohana, Yaakobo, Andurea, Firipo, Tomaso, Baritoromaayo, Mataayo, Yaakobo omwaana wa Arifayo, Simooni Omuzeroote, na Yuuda omwaana wa Yaakobo. ");
INSERT INTO zak_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bhano bhoosi bhaari bhiikumaniirye muyo bharamusabha Taatabhugya kwe ekoro yimwe, hamwe na Mariamu nina waabhu Yeesu, abhakari abhaandi, na bhawamwaabhu Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kuziisiku ziyo, abhiikirirya bha Yeesu bhaari bhiikumaniirye, obhwaaru bhwa abhaatu bhayo bhwaari igana rimwe na miroongo ebhiri ego (120). Niho Petero akiimeerera gatigati waabhu akabhuga, ");
INSERT INTO zak_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Abhahiiri bhaane, ekeenderwa Amakaamo Amahoreeru gakorwe, kyeego Ekoro Muhoreeru akaroota kuhitira kumutemi Daudi kwiiguru wa Yuuda, wuno yakaangatiri abhaatu bhano bhaamugwaatiri Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuuda yaari omweega omurikyeetu, tukakora nawe emirimo hamwe.” ");
INSERT INTO zak_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hano Yuuda yabhweeni eziimbirya kwo okukora amangʼana amabhiihu, akagura omuguundu. Mumuguundu muyo muyo, akagwa haasi, enda yaaye ekabhaaruka na amara gaaye gakiitika igutu. ");
INSERT INTO zak_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Amangʼana gayo, gakamenywa na abhaatu bhoosi bha Yerusaremu, kweego bhakahabhirikira ahagiro hayo Akeridama mukigaambo kyaabhu, obhugazuro bhwaku omuguundu gwa amanyiinga. ");
INSERT INTO zak_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ambe, Petero akageenderera okugaamba, “Gakaamirwe mukitabhu kya Zaburi, ‘Ahagiro haaye habhe ne ekiibhuuro, na atabhaho omuutu wuno ariikaremu.’ Na kweeki gakaamirwe, ‘Omuutu owuundi ahaabhwe emirimo gyaaye gyo okukaangata.’ ");
INSERT INTO zak_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kweego, ereenderwa tusore omuutu owuundi wuno twaari kugeendenia nawe, eriibhaga ryoosi rino Omukuru Yeesu yaari hamwe neetwe, ");
INSERT INTO zak_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kweemera hano Yeesu yaabatiizirwe na Yohana, tee okugegwa kugya mwiisaaro. Omuutu wuyo, arabha arasakirania hamwe na neetwe okuraarika obhuryoori bhwa Yeesu.” ");
INSERT INTO zak_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kweego, bhakagaamba amariina ga abhaatu bhabhiri. Owumwe yaari Yusufu wuno akubhirikirwa Barisaaba, ne eriina ryaaye eriindi Yusito. Na wa kabhiri, akabhirikirwa Matiya. ");
INSERT INTO zak_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Niho bhakamusabha Taatabhugya, bhakabhuga, “Omukuru, naawe omenyiri eziikoro zya abhaatu bhoosi. Kweego, otweerekye ni weewi wuno osoriri gati wa abhabhiri bhano, ");
INSERT INTO zak_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","okubha agege omweeya gwe emirimo gyo obhweega bhuno Yuuda yatigiri, hano yakuuri no okugya hano haamungʼariiri.” ");
INSERT INTO zak_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kyaamwe bhakataanga kwiitoora obhwiitoori bhukamugweera Matiya, kweego akoongeribhwa kubharya abheega abhaandi ikumi na wumwe. ");
INSERT INTO zak_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Hano orusiku rwe enyaangi ya Pentekositi rwahikiri, abhiikirirya bha Yeesu bhoosi bhaari bhiikumaniirye ahagiro hamwe. ");
INSERT INTO zak_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Rugeendo rumwe, kukahwaaruka eriiraka kyo obhukama obhuhaari bhwo okurweera mwiisaaro, eriiraka riyo rikiizurya enyuumba yoosi muno bhaari bhiikumaniirye. ");
INSERT INTO zak_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Niho bhakarora ebhigiro kyo orurare rwo omuriro, bhikatwaanikana, bhikiituuma iguru wa bhoosi. ");
INSERT INTO zak_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Abhaatu bhoosi bhano bhaari kurusiku ruyo, bhakiizuribhwa Ekoro Muhoreeru, bhakataanga kugaamba kubhigaambo ebhiindi, kyeego Ekoro Muhoreeru akabhakaangata okugaamba. ");
INSERT INTO zak_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ambe, Yerusaremu bhaari bhariho Abhayahudi bhano bhaamwiikiriirye Taatabhugya, na bhaari bharweereeri kubhyaaro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hano bhakiigwa eriiraka riyo, esaango ekuru ya abhaatu bhakasikana. Bhoosi bhakaruguura, kwo okubha bhakiigwa ebhigaambo bhyaabhu bhya simuka kyeego bhikugaambwa. ");
INSERT INTO zak_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Hano bhaari bhakuruguura no okugaandaara, bhakiibhuurya, “Awe bhoosi bhano tukubhiigwa bharagaamba ego, bhatari Abhagariraaya? ");
INSERT INTO zak_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Erabhabhwi etwe twoosi okubhiigwa bharagaamba ebhigaambo bhyeetu bhya simuka? ");
INSERT INTO zak_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Na gati weetu, bharimu abhaatu okurwa ebhyaaro bhya Abhapariti, Abhamedi na Abheeramu. Na abhaandi bhararwa ebhyaaro bhya Mesopotamia, Yudea, Kapadokia, Poonto na Asia, ");
INSERT INTO zak_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Furigia, Pamufiria na Misiri. Na abhaandi bhakarwa mbaara zye ekyaaro kya Ribia kino kiri haguhi no omugye gwa Kirene, na abhaandi bheetu ni bhagini okurwa mumugye gwa Rooma. Gati waabhu ni Bhayahudi bha simuka na Abhayahudi bhano bhaarwiiri ebhyaaro ebhiindi, bhano bhiikiriirye enyaangi ye Ekiyahudi. ");
INSERT INTO zak_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na bhariho abhaaru ni Bhakirete na abhaandi ni Bhaaraabu. Etwe twoosi turabhiigwa bharagaamba ebhigaambo bhyeetu iguru wa amahokya amakuru ga Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Abhaatu bhoosi bhakaruguura no okutitiikana eno bhariibhuurya, “Niki obhugazuro bhwa amangʼana gano?” ");
INSERT INTO zak_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nawe abhaandi bhakabhaseka, bhakabhuga, “Awe bhano bhagwaatirwe na amaanzi go omuzabibu!” ");
INSERT INTO zak_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Niho Petero akiimeerera hamwe na abheega ikumi na wumwe bharya. Akataanga okubhabhuurira abhaatu bhayo kwiiraka ikuru, “Emwe Abhayahudi abharikyaane, na neemwe abhiikari abhaandi bha Yerusaremu, mumenye eriingʼana rino, no okwiitegeerera amangʼana gaane. ");
INSERT INTO zak_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abhaatu bhano bhatagwaatirwe kyeego mukwiiseega, mutakurora ekyaari etabhoori, eriibhaga rya katatu! ");
INSERT INTO zak_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nawe engʼana yino ni yirya yagaambirwe no omurooti Yoeri, ");
INSERT INTO zak_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Taatabhugya arabhuga, muziisiku zyo obhuteero, ndabhiikirya Ekoro Muhoreeru iguru wa abhaatu bhoosi. Abhaana bheenyu bhe ekisubhe na bhe ekikari bhararuusya obhurooti, na abhamura bheenyu bhararora obhurori, na abhakaruka bheenyu bhararoota ebhirooto. ");
INSERT INTO zak_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kuziisiku ziyo ndabhiikirya Ekoro Muhoreeru waane naabhe iguru wa abhagya bhaane, abhasubhe na abhakari, neebho bhararuusya obhurooti. ");
INSERT INTO zak_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ndakora ebhiruguuro iguru kwiisaaro, ne ekyeerekenio mukyaaro hano. Na abhaatu bhararora ebhyeerekenio bhya amanyiinga no omuriro, ne eryooki ryo omwooki. ");
INSERT INTO zak_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Eryoobha ririikyoora kubha ekiirima, no omweeri gurakaangaara kya amanyiinga, gayo garakorwa hano rukubha rukyaari kuuza orusiku orukuru rwo obhuguungo bhwo Omukuru. ");
INSERT INTO zak_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nawe omuutu wuyo woosi wuno akusabha kwo okwiisiga eriina ryo Omukuru, aratuuribhwa.’ ” ");
INSERT INTO zak_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petero akageenderera kugaamba, “Emwe abhaatu bha Iziraeri, mwiitegeerere amangʼana gano. Taatabhugya omweene yabheerekirye kubha arakora emirimo kuhitira ku Yeesu wa Nazareeti, yakoriri ego kwe enzira ye ebhitiika, ebhiruguuro ne ebhyeerekenio bhino akukora gati weenyu, kyeego emwe abheene mumenyiri. ");
INSERT INTO zak_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yeesu wuno yatuurirwe mumabhoko geenyu, kyeego Taatabhugya yeendiri okurwa obhutaangi, na neemwe mukamwiitira kumusaraba, kwe enzira ya abhaatu abhabhi. ");
INSERT INTO zak_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nawe Taatabhugya akamuryoora kurwa mubhaku, akamuruusya mubhururu bhwo oruku, kwo okubha etaangaturikeeni agwaatwe no oruku! ");
INSERT INTO zak_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Naabhe omutemi Daudi akagaamba iguru wa Yeesu, ‘Nikamurora Omukuru embere waane eriibhaga ryoosi. Na nitakusiingisibhwa kweeki, kwo okubha ari kukubhoko kwaane kwo obhuryo. ");
INSERT INTO zak_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kweego, ekoro yaane ekazomererwa, kweeki orurimi rwaane rurariryaata. No omubhiri gwaane, gurabha no obhwiisige, ");
INSERT INTO zak_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwo okubha awe otakunitiga nyaari. No otakwiikirirya omubhiri gwo Omuhoreeru waazo gubhore. ");
INSERT INTO zak_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Awe onierekirye eziinzira zo obhuhoru, Oniizuriirye obhuzomererwa bhwaaru, kwo okubha orabha hamwe na neenye.’ ” ");
INSERT INTO zak_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Petero akageenderera okugaamba, “Abhahiiri bhaane, ndeenderwa nibhabhuurire kwe eheene kubha zaazi weetu Daudi akakwa. Neewe akabhiikwa ne embiihira yaaye eriho hano tee reero. ");
INSERT INTO zak_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nawe, kwo okubha Daudi yaari omurooti, akamenya kubha Taatabhugya akamuragania kwo okumwiirahiirira kubha, yaramutuura omuutu wumwe we ehamati yaaye kubha omukaangati wo obhutemi bhwaaye. ");
INSERT INTO zak_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi akabha ararora amangʼana gano garaatuuke embere, akagaamba iguru wo okuryooka kwa Masiya weetu, kubha ataatigirwe nyaari no omubhiri gwaaye gutaabhoriri. ");
INSERT INTO zak_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Taatabhugya akamuryoora Yeesu kurwa mubhaku, na neetwe twoosi ni bhamenyeekererya bhe engʼana yiyo. ");
INSERT INTO zak_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Taatabhugya akamugororokya no okumutiirya obhukuru, bhoono yiikeeri orubhaara rwaaye rwo obhuryo. Kyaamwe Taata akamuha Yeesu Ekoro Muhoreeru kyeego akamuragania, Yeesu woosi akatwiikirya Ekoro Muhoreeru, kyeego mukurora no okwiigwa. ");
INSERT INTO zak_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daudi omweene ataatiiriri okusikira mwiisaaro, nawe akabhuga, ‘Omukuru, Taatabhugya akamubhuurira Omukuru waane, “Wiikare orubhaara rwaane rwo obhuryo, ");
INSERT INTO zak_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tee hano nikutuura abhabhisa bhaazo iyaasi wa amaguru gaazo.” ’” ");
INSERT INTO zak_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Petero akamaririirya okugaamba, “Abhiiziraeri bhoosi mureenderwa mumenye kwe eheene kubha, Yeesu wuno mukiita, niwe wuyowuyo Taatabhugya akamukora kubha Omukuru na Masiya!” ");
INSERT INTO zak_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hano abhaatu bhiigwiiri amangʼana gayo, gakabhanyahaara bhukongʼu muziikoro zyaabhu. Kyaamwe, bhakamubhuurya Petero na abheega abharikyaaye, “Abhahiiri bheetu, bhoono tukorebhwi?” ");
INSERT INTO zak_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petero akabhakyoora, “Mwoosi mute ebhibhi bhyeenyu, na mubatiizwe kuriina rya Yeesu Krisito, okubha mwaabhirwe ebhibhi bhyeenyu na murasuungʼaana Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Obhurage bhuno ni iguru weenyu na abhaana bheenyu, na kubhaatu bhoosi bhano bhari mubhyaaro ebhiindi. Omukuru, Taatabhugya weetu, araabhabhirikire abhaatu bhoosi bhabhe bhaaye.” ");
INSERT INTO zak_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero akageenderera okubhariiha abhaatu bhayo kwa amangʼana agaandi maaru no okubhakumiirirya, akabhuga, “Mwiituurye no okurwa murwiibhuro orubhi runo!” ");
INSERT INTO zak_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abhaatu bho okuhika ebhikwe bhitatu (3,000) bhakiikirirya ameegyo gano Petero yaari kweegya kurusiku ruyo, bhakabatiizwa, bhakagwaatana na abhaanabheega abhaandi bha Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Neebho abhiikirirya bhaari bhariiruusya okweega ameegyo ga abheega bha Yeesu, na bhakagwaatana hamwe no okurya mwiigari ryo Omukuru eriihoreeru no okumusabha Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abheega bhano bhaari bharakora ebhyeerekenio ne ebhiruguuro bhyaaru, bhikakora bhoosi bhakagwaatwa ne ehaho ya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na abhiikirirya bhoosi bhaari no obhumwe, na ebhigiro bhyaabhu bhyoosi bhyaari kyo obhumwe bhwaabhu. ");
INSERT INTO zak_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Hano bhahaagurya ebhigiro bhyaabhu, bhahaatwaana abhaatu bhoosi kyeego bhaari bhakweenda. ");
INSERT INTO zak_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kuziisiku zoosi, bhahaasikanira mwiiseengerero rya Taatabhugya. Bhahaabhega omukaate enyuumba kwe enyuumba, na bhahaasaanga okurya ebhyaakurya kwo obhuzomererwa na kwe ekoro yimwe. ");
INSERT INTO zak_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bhahaamukumya Taatabhugya no okubhazomera abhaatu bhoosi. Ne eziisiku zyoosi Omukuru Yeesu akageenderera okutuurya abhaandi, na abhiikirirya bhakaaruha. ");
INSERT INTO zak_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Orusiku rumwe Petero na Yohana bhakagya okuseengera mwiiseengerero, eriibhaga rya keenda mumwiisi. Eriibhaga riyo niryo ryaari ryo okumuseengera Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Haguhi ne ekiseku kimwe kye eriiseengerero kino kyaari kubhirikirwa Ekiseku Ekizomu, hahaabha no omuutu wumwe wuno yaari eriigata okurwa okwiibhurwa kwaaye. Eziisiku zyoosi, eriigata ahaagegwa na abhaatu no okutuurwa haguhi ne Ekiseku Ekizomu, abhone okusabha eziimbirya kubhaatu bhano bhaari kuhita no okusikira mwiiseengerero rya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hano eriigata wuyo yabharuuzi Petero na Yohana bhiisukiri haguhi bhakweenda kusikira mwiiseengerero, akabhasabha bhamuhe eziimbirya. ");
INSERT INTO zak_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Niho Petero na Yohana bhakamutaangaarira, kyaamwe Petero akamubhuurira, “Oturoreerere etwe!” ");
INSERT INTO zak_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kweego omuutu wurya akabharoreerera, eno ariisiga kubha bhaari ne ekigiro kyo okumuha. ");
INSERT INTO zak_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nawe Petero akamubhuurira, “Nitana mbirya ziyo zoosi, naabhe ezahaabu, nawe kino ninakyo, nikyo ndaakuhe. Ndakubhuurira kuriina rya Yeesu Krisito wa Nazareeti, imeerera ogye!” ");
INSERT INTO zak_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kyaamwe Petero akamugwaata omuutu wuyo okubhoko kwo obhuryo, akamwiimeererya. Hayohayo ebhitugweetugwe bhyaaye bhikabha na amanaga. ");
INSERT INTO zak_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Akabhururuka, akiimeerera bhwaangu, akataanga okugeenda omweene. Akasikira mwiiseengerero, hamwe na Petero na Yohana, eno arabhururuka no okumukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Abhaatu bhoosi bhano bhaari hayo, bhakamurora arageenda no okumukumya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Na bhakamumenya kubha, niwe wuryawurya wuno yaari kwiikara habhoori mu Kiseku Ekizomu kirya kye eriiseengerero, eno arasabhasabha. Bhoosi bhakiitakya no okuruguura bhukongʼu okurora engʼana yino emutuukiiri. ");
INSERT INTO zak_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Abhaatu bhoosi bhakyaruguura omuutu wuyo ahoriibhwe, eno arabhaangiraku Petero na Yohana. Abhaatu bhakataanga kuryaarira kweebho, ahagiro harya hakubhirikirwa Eriibhaanza rya Soromooni. ");
INSERT INTO zak_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hano Petero yaari amariri kubharora abhaatu bhiikumeenie hayo, akabhona omweeya gwo okubhabhuurira, “Emwe abhaatu bha Iziraeri, kwaki gayo garabharuguurya? Ndora muratumogorera ameeso? Kyamuna mukubhuga, ni kwo obhunagya hamwe kwo obhuhoreeru bhweetu tugirirye omuutu wuno ahoriibhwe na ageende? ");
INSERT INTO zak_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Taatabhugya wa bhazaazi bheetu, Aburahamu, Isaaka na Yaakobo, amuguungirye omuhokya waaye Yeesu, niwe omuhorya wa wuyo. Na Yeesu wuyo niwe wuno emwe mwamuruusirye atinirwe ekiina kyo oruku! Yiingabha Pirato aheenda abhiigurire Yeesu, mukaanga atahaatirwa. ");
INSERT INTO zak_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Emwe mukamwaanga omuheene no omuhoreeru na mukamusabha Pirato kubha, omwiiti ahaatirwe kumweeya gwaaye. ");
INSERT INTO zak_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kweego mukamwiita Yeesu, wuno akuha abhaatu obhuhoru! Nawe Taatabhugya akamuryoora kurwa mubhaku, neetwe ni bhamenyeekererya bho okuryooka kwaaye. ");
INSERT INTO zak_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kwo okwiikirirya eriina rya Yeesu, omuutu wuyo mukumurora no okumumenya kisi, aheerwe amanaga. Ewe ahoriibhwe kwe enzira yo obhwiikirirya bhwe eriina riyo. ");
INSERT INTO zak_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Bhoono abhahiiri bheetu, nimenyiri mwamukoreeri Yeesu gayo goosi, kwo obhutamenya bhweenyu, niigo abhakaangati bheenyu bhoosi bhaakoriri. ");
INSERT INTO zak_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nawe, amangʼana gano Taatabhugya yagaambiri okurwa ekare, kuminwa gya abharooti bhaaye bhoosi kubha, Masiya waaye araaza kunyaakibhwa, na niigo yabheeri. ");
INSERT INTO zak_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kweego, mute ebhibhi bhyeenyu, na mumwiikyooserye Taatabhugya, okubha ewe abhaabhire ebhibhi bhyeenyu, na ziraaza eziisiku zo okuzomeribhwa kwo okubhaho kwaaye Omukuru, Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Araaza kukora ego okubha anagye kumutuma Yeesu. Ewe niwe Masiya, wuno yatuurirweho kwiiguru weenyu kweema ekare. ");
INSERT INTO zak_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ewe akeenderwa asaage mwiisaaro, tee hano Taatabhugya araakore bhuhya ebhigiro bhyoosi mukyaaro, kyeego akabhuga kurwa ekare kwe enzira ya abharooti bhaaye abhahoreeru. ");
INSERT INTO zak_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Musa akabhuga, ‘Omukuru, Taatabhugya weenyu, arabhasorera omurooti kya neenye, kurwa gati wa abhahiiri bheenyu. Mumwiitegeerere kisi amangʼana goosi gano araabhabhuurire. ");
INSERT INTO zak_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","No omuutu wuyo woosi wuno atakumwiikirirya omurooti wuyo, araahurwa no okutuurwa kure na abhaatu bha Taatabhugya.’ ");
INSERT INTO zak_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na abharooti bhoosi, kweemera Samweeri na abhaandi bhano bhaamurumiriku, bhakaroota amangʼana ge eziisiku zino. ");
INSERT INTO zak_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Emwe ni bhaana bha abharooti, na abhaana bhe eriiragano rino Taatabhugya yakoriri na bhazaazi bheenyu. Taatabhugya akamuragania Aburahamu, ‘Kwe enzira yo omuutu wo orwiibhuro rwaazo, abhaatu bhe ebhyaaro bhyoosi bharatweerwa ebhite.’ ");
INSERT INTO zak_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Hano Taatabhugya yamariri kumuryoora omuhokya waaye Yeesu, akataanga kumutuma kweemwe, okubha abhatweere ebhite, kwo okubhakyoora abhaatu bhoosi kutiga eziinzira zyaabhu eziimbiihu.” ");
INSERT INTO zak_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Hano Petero na Yohana bhaari bhakyarwaazira abhaatu bharya, abhaseengeri, abhariibhi bhe eriiseengerero na Abhasadukayo bhakabhahikaku. ");
INSERT INTO zak_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Abhakuru bhayo bhaari bhatiindiri bhukongʼu, kwo okubha Petero na Yohana bhaari bhareegya abhaatu kubha, Yeesu akaryooka, no okuryooka kwa Yeesu kureerekya kubha abhaku bhararyooka. ");
INSERT INTO zak_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kweego, bhakabhagwaata Petero na Yohana no okubhatuura mukibhoho, tee etabhoori yaho, kwo okubha yaari engoroobha. ");
INSERT INTO zak_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nawe, abhaatu bhaaru bhano bhakiigwa ameegyo ga Petero na Yohana, bhakagiikirirya, no obhwaaru bhwa abhasubhe bhwaari bhuriisukira kya abhasubhe bhikwe bhitaano (5,000). ");
INSERT INTO zak_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Etabhoori yaho, abhaseengeri, abhakaruka na abheegya bhe emigiro bhakiikumanirya Yerusaremu hayo. ");
INSERT INTO zak_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Musaango yiyo, yaarimu omuseengeri omukuru Anasi, hamwe na Kayafa, Yohana, Arekizanda na abhahiiri abhaandi bho omuseengeri omukuru. ");
INSERT INTO zak_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bhakaragania Petero na Yohana bhareetwe mukiina. Bhakabhiimeererya gatigati waabhu, bhakataanga kubhabhuurya, “Emwe mukoriri engʼana yino kwa amanagaki na kwe eriina rya weewi?” ");
INSERT INTO zak_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Hayo Petero yaari yiizwiiri Ekoro Muhoreeru, akabhabhuurira, “Emwe, abhakaangati bha abhaatu bha Iziraeri na abhakaruka, ");
INSERT INTO zak_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","reero muratubhuurya amabhuuryo iguru ya kyeego tukamusakirya eriigata wuno, na muratubhuurya kyeego yahoriibhwe. ");
INSERT INTO zak_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ambe bhoono, emenywe kweemwe mwoosi na abhaatu bha Iziraeri kubha, omuutu wuno yiimeereeri embere weenyu reero ni muhoru kwe eriina rya Yeesu Krisito wa Nazareeti. Niwe mukamwiitira kumusaraba, nawe Taatabhugya akamuryoora okurwa mubhaku. ");
INSERT INTO zak_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ewe niwe wuno Amakaamo Amahoreeru gakubhuga, ‘Yeesu niwe eriigina rino emwe abhoomboki mwaaryaangiri, niryo ribheeri eriigina eriikuru ryo obhurusa.’ ");
INSERT INTO zak_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Obhutuurya bhutakubhoneka kumuutu owuundi wuyo woosi, kwo okubha ritariho eriina eriindi ryoryoosi mukyaaro rino turaanagye kutuuribhwa kweeryo!” ");
INSERT INTO zak_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hano abhakaangati bhayo bhaaruuzi Petero na Yohana bhaagaambiri kwo obhukaari, no okumenyeekererya kubha abhaatu bhayo bhataasomiri, niho bhakaruguura bhukongʼu. Bhakamenyeekererya kubha bhaari hamwe na Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nawe kwo okubha bhaari bharamurora omuutu wuno yaari ahoriibhwe yiimeereeri hamwe nabho, bhataari ne engʼana yo okugaamba. ");
INSERT INTO zak_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kweego, bhakabhaswaagya Petero na Yohana bhahuruke habhoori we ekiina kirya, neebho bhakasaaga bhariitoongera abheene. ");
INSERT INTO zak_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bhakiibhuurya, “Tubhakorebhwi abhaatu bhano? Abhiikari bhoosi bha hano Yerusaremu bhamenyiri kubha bhakoriri ekyeerekenio ekikuru kino, na tutakunagya kwaanga. ");
INSERT INTO zak_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nawe, kwo okuribhira engʼana yiyo etige kunyaragana mubhaatu, tureenderwa tubharekye bhatagaambana no omuutu wowoosi kuriina rya Yeesu.” ");
INSERT INTO zak_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kyaamwe abhakuru bhayo bhakabhabhirikira kweeki Petero na Yohana munyuumba. Bhakabharekya bhatakeerenia, naabhe okweegya iguru ye eriina rya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nawe Petero na Yohana bhakabhakyoora kwo okubhabhuurira, “Muhitye emwe abheene, eraabhe ni kisi kubhiigwa emwe, kukira okumwiigwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nawe etwe tutakutura kutiga kugaamba iguru wa amangʼana gano twaagaruuzi no okwiigwa!” ");
INSERT INTO zak_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ambe, abhakuru bhayo bhe ekiina, bhakabharekya kwo obhuhaari bhukongʼu, okumara bhakabhahaatira. Bhataanagirye kubhatema naabhe kubhanyaakya, kwo okubha abhaatu bhoosi bhaari bharamukumya Taatabhugya kwiiguru ye ekisigo kiyo. ");
INSERT INTO zak_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Omuutu wuno ahoriibhwe yaari ne emyaaka gino gikutuuma miroongo ene (40). ");
INSERT INTO zak_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Hano Petero na Yohana bhaahaatiirwe, bhakakyoora kubharikyaabhu. Na bhakabhabhuurira kyeego bhaabhuuriirwe na abhakuru bha abhaseengeri na abhakaruka bha Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Neebho hano bhakiigwa amangʼana gayo, bhakatiirya eriiraka bhakamusabha Taatabhugya kwa hamwe bhakubhuga, “Omukuru, Taatabhugya, Omuteemi we ekyaaro, eriisaaro, enyaanza ne ebhigiro bhyoosi bhyamu. ");
INSERT INTO zak_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Naawe wagaambiri kwe enzira ye Ekoro Muhoreeru, kuhitira omunwa gwa Daudi zaazi weetu, omuhokya waazo, ‘Ndora abhaatu bhe ebhyaaro bharatiinda, na abhaatu bhariiseega okukora amangʼana gano gatana bhweera? ");
INSERT INTO zak_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abhatemi bhe ekyaaro na abhakaangati bhiikumeenie hamwe, okubha bhamwaange Omukuru, Taatabhugya na Masiya waaye.’ ");
INSERT INTO zak_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ni heene, kwo okubha Herode Antipasi na Pontio Pirato kwa hamwe na abhaatu bhe ebhyaaro ebhiindi na Abhiiziraeri, bhakiikumanirya hamwe mumugye guno okubha bhamwaange Yeesu, omuhokya omuhoreeru waazo omusorwa. ");
INSERT INTO zak_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kweego, ebho bhakakora gano kwo obhuturo bhwaazo na amiiseego gaazo gakeendwa gakorwe kurwa mubhutaangiro. ");
INSERT INTO zak_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na bhoono, ee Omukuru, Taatabhugya, oruuzi ebhikaango bhyaabhu bhiyo, otusakirye no okutuha obhunagya, etwe abhagya bhaazo, kuraarika engʼana yaazo kwo obhukaari bhukuru. ");
INSERT INTO zak_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ogororokye okubhoko kwaazo, okubha ohorye abhaatu. Okore ekyeerekenio ne ekiruguuro kwe eriina rya Yeesu, omuhokya waazo omuhoreeru!” ");
INSERT INTO zak_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hano bhaamariri okumusabha Taatabhugya, ahagiro harya bhaari bhiikumaniirye, hakarigita. Neebho bhoosi bhakiizuribhwa ne Ekoro Muhoreeru, bhakataanga okurwaazira abhaatu engʼana ya Taatabhugya kwo obhukaari. ");
INSERT INTO zak_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abhiikirirya bhoosi bhaari no omutima gumwe no obhwiiseegi bhumwe. Ataari ariho omuutu naabhe wumwe wuno yaari kubhara ebhigiro bhyaaye kubha ni bhyaaye omweene ego, nawe ebhigiro bhyoosi bhyaari bhyo obhusaange. ");
INSERT INTO zak_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abheega bha Yeesu bhakageenderera kugaambira abhaatu kwa amanaga maaru, amangʼana go okuryooka kwo Omukuru Yeesu. Na Taatabhugya akabhatweera ebhite bhoosi. ");
INSERT INTO zak_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na ataari ariho omuutu owumwe gati waabhu wuno yasuuhiirwe ne ekigiro. Bhataasuuhiirwe, kwo okubha bhano bhaari ne emiguundu ne eziinyuumba, bhakabhigurya ne eziimbirya zino bhaabhweeni ");
INSERT INTO zak_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bhakazihaana abheega. Nabho bhakazitwaania eziimbirya ziyo kubhaatu bhano bhataari nazyo kyeego bhaari bhakweenda. ");
INSERT INTO zak_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yaari ariho Omuraawi wumwe omwiibhurwa wa Kipuro eriina ryaaye ni Yusufu, nawe abheega bha Yeesu bhakamuha eriina Barinaaba, obhugazuro bhwaku ni wo okugosorerania. ");
INSERT INTO zak_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barinaaba akagurya omuguundu gwaaye, eziimbirya zino akabhona, akazihaana abheega bhayo. ");
INSERT INTO zak_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kwaari no omuutu owumwe, eriina ryaaye Anania na mukaaye yaari arabhirikirwa Safira. Neebho bhakagurya omuguundu gwaabhu. ");
INSERT INTO zak_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Anania akabhisa eziimbirya eziindi kurwa kuzino bhaabhweeni. Na mukaaye woosi, yaari yiikirireenie neewe. Niho Anania akagega eziimbirya zino zasaagiri, akagya akabhaha abheega bha Yeesu eno arabhuga nizo ziyo zoosi. ");
INSERT INTO zak_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petero akamubhuurya, “Awe Anania! Ndora Seetaani akukoriri ongʼeenererye ekoro yaazo, no okumubheehera Ekoro Muhoreeru, kwo okubhisa eziimbirya eziindi zino wabhweeni kwo okugurya omuguundu gwaazo? ");
INSERT INTO zak_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Hano waari okyaari kugurya omuguundu guyo, gwaari ogwaazo? Na hano omariri kugurya gutaari mubhunagya bhwaazo? Kwaki wiiseegiri kwo okukora obhubhi bhuyo mukoro yaazo? Awe otaabheheeri omuutu nawe obheheeri Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hano Anania yiigwiiri amangʼana ga Petero gayo, akagwa haasi akakwa. Na bhoosi bhano bhakiigwa amangʼana gayo, bhakahaha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Abhamura bhakaaza, bhakakuundikirya omubhiri gwaaye kwo omweenda, bhakamuhurukya habhoori, bhakamuhira ahagiro ho okubhiikira, bhakamubhiika. ");
INSERT INTO zak_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hano zyahitiri eziisa isatu, omukari wa Anania woosi akasikira munyuumba, ekabha ewe yaari akyaari kumenya gano gaatuukiri muyo. ");
INSERT INTO zak_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petero akamubhuurya woosi, “Ombuurire, eziimbirya zino nizo mukagurya emenyo yeenyu?” Akamukyoora, “Hee! Tukagurya kwo obhuguri bhuyobhuyo!” ");
INSERT INTO zak_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Niho Petero akamubhuurira, “Ndora awe no omusubhe waazo mukoriri omukoonyo kwo okusakya Ekoro Muhoreeru wo Omukuru, Taatabhugya? Rora! Abhamura bhano bhaagiiri kubhiika omusubhe waazo, bhakyooriri na bhari mukiseku hayo, bharaaza okukugega no okukuhira habhoori!” ");
INSERT INTO zak_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Rugeendo rumwe, Safira woosi akagwa mumaguru ga Petero, akakwa hayohayo. Niho abhamura bharya bhakasikiramu, bhakabhona Safira woosi akuuri. Bhakahira ekituundu kyaaye habhoori, bhakakibhiika haguhi no omusubhe waaye. ");
INSERT INTO zak_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gayo gakagirya abhaatu bhoosi bhe ekanisa, hamwe na abhaandi bhoosi bhano bhakiigwa amangʼana gayo, bhakahaha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abheega bha Yeesu bhayo bhaari bharakora ebhyeerekenio ne ebhiruguuro bhyaaru gati wa abhaatu. Na abhiikirirya bha Yeesu bhoosi bhahiikumania hamwe mwiiseengerero, ahagiro he Eriibhaanza rya Soromooni. ");
INSERT INTO zak_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Abhaatu bhano bhataamwiikiriirye Yeesu, bhaari bharabhakumya bhukongʼu abhiikirirya bhayo, nawe naabhe owumwe waabhu, ataasakirye okwiisaanginia hamwe nabho. ");
INSERT INTO zak_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nawe abhaatu bhaaru abhasubhe na abhakari bhakamwiikirirya Omukuru, kweego bhakaaruha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kwo okuriingʼaana ne ebhiruguuro bhiyo abheega bhaakoreerwe, abhaatu bhakabha bharareeta abharweeri no okubhahiindirya habhoori, kubhuriri na kubhiigi, okubha hano Petero akuhita, ekiiriiri kyaaye kibhahikeku abhaandi, bhahore. ");
INSERT INTO zak_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eziisaango zya abhaatu zaari zirasaanga kurwa mumigye gye embarika wa Yerusaremu, bhakabhareeta abharweeri bhaabhu na bhano bhanyahaarikiri kwa amasaambwa amabhi, bhoosi bhakahoribhwa. ");
INSERT INTO zak_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Okumara omuseengeri omukuru na abharikyaaye bhoosi, bhano bhaari eriihizo rya Abhasadukayo, bhakabhakorera omugono mwaaru abheega bha Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kweego, bhakabhagwaata abheega bhayo, bhakabhabhoha munyuumba ekuru ya abhabhohwa. ");
INSERT INTO zak_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nawe hano obhutiku bhwiiriri, maraika wumwe wo Omukuru akiigura ekiseku kye enyuumba ya abhabhohwa yiyo, akabhahurukya habhoori. Kimwe akabhabhuurira, ");
INSERT INTO zak_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mugeende mwiimeerere mwiiseengerero, mubhuurire abhaatu amangʼana goosi iguru yo obhuhoru obhuhya bhwa kirakeego!” ");
INSERT INTO zak_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hano abheega bhayo bhakiigwa, bhakagya mwiiseengerero etabhoori zuri, bhakataanga okweegya abhaatu. Niho omuseengeri omukuru akaaza hamwe na abharikyaaye, bhakabhasikania abhakuru bhoosi bha Abhayahudi hamwe na abhakaruka abhakuru bhe ekiina ekikuru kya Abhiiziraeri. Okumara bhakabhatuma abhariibhi bhe enyuumba ya abhabhohwa, bhabhareete abheega bhayo. ");
INSERT INTO zak_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nawe hano abhariibhi bhe eriiseengerero bhaasikiiri munyuumba ya abhabhohwa, bhataabhweenimu abheega bhayo. Kweego bhakakyoora no okubhuurira abhakuru bhayo, ");
INSERT INTO zak_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Hano twaahikiri tukabhona enyuumba ya abhabhohwa yiyo ebhiseku bhiigeeri, na abhariibhi bhiimeereeri habhoori we ebhiseku bharariibha. Nawe hano twiigwiiri ebhiseku bhiyo, tutabhweenimu omuutu wowoosi!” ");
INSERT INTO zak_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ambe, omukuru wa abhariibhi bhe eriiseengerero na abhakuru bha abhaseengeri bhakiigwa gayo, bhakatitiikana bhukongʼu, bhakiibhuurya, “Awe, amangʼana gano nibhwi gabheeri?” ");
INSERT INTO zak_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Niho omuutu wumwe akaaza, akabhabhuurira, “Murore! Abhaatu bharya bhano mwabhabhweeni, bhoono ego bhari mwiiseengerero, bhareegya abhaatu.” ");
INSERT INTO zak_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Niho omukuru wa abhariibhi bhe eriiseengerero, hamwe na abhasirikare bhaaye, bhakagya kubheega bhayo, bhakabhareeta. Nawe bhataabhagwaatiri kwa nguru, kwo okubha bhakoobhoha okutemwa amagina na abhaatu. ");
INSERT INTO zak_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Niho bhakabhareeta embere no okubhiimeererya mukiina. Omuseengeri omukuru akabhabhuurya, ");
INSERT INTO zak_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tutaabharekirye kwa amanaga kubha, muteegya kwe eriina ryo omuutu wuyo? Bhoono emwe murore, munyarageenie Yerusaremu yoosi ameegyo geenyu, eno mureenda kutuririirira kwo okutugegya omurigo gwo oruku rwaaye rubhe iguru weetu.” ");
INSERT INTO zak_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero na abheega abharikyaaye bhakamukyoora, “Ereenderwa tumwiigwe Taatabhugya, kukira abhaatu. ");
INSERT INTO zak_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Emwe mukamwiita kwo okumuturuungaazya kumusaraba, nawe Taatabhugya wa zaazi weetu akamuryoora Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kyaamwe, Taatabhugya akamuguungya Yeesu no okumutuura orubhaara rwaaye rwo obhuryo, abhe Omukaangati no Omutuurya wa abhaatu. Taatabhugya akakora ego, okubha abhasakirye Abhiiziraeri bhate ebhibhi bhyaabhu no okwaabhirwa. ");
INSERT INTO zak_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na neetwe ni bhamenyeekererya bha gayo goosi ne Ekoro Muhoreeru, wuno Taatabhugya abhaheeri abhaatu bhano bhakumwiigwa.” ");
INSERT INTO zak_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Hano abhakuru bhe ekiina kya abhakaruka bhiigwiiri gayo, bhakatiinda bhukongʼu, bhakeenda kubhiita abheega bhayo. ");
INSERT INTO zak_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nawe mukiina muyo haari no Omufarisayo wumwe, wuno yaari kubhirikirwa Gamarieri. Ewe Gamarieri yaari omweegya we emigiro, na abhaatu bhoosi bhahaamwiigwa. Akiimeerera, akaswaagya kubha, abheega bhahurukibhwe habhoori kwiibhaga iguhi. ");
INSERT INTO zak_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Niho akabhabhuurira abhakuru bhe ekiina, “Emwe abhaatu bha Iziraeri, mwiiseege kisi mukyaari kukora engʼana yino mukweenda kukora kubhaatu bhano! ");
INSERT INTO zak_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Eziisiku suuhu zino zyaahitiri, akatuukira omuutu wumwe, eriina ryaaye Teuda. Teuda wuyo yaari ariizuuma kubha ni muutu mukuru, na akabhona abhaatu magana ane (400) bhakagwaatana neewe. Nawe kubhuteero akiitwa, na abhaatu bhaaye bhoosi bhano bhakumutuniirira bhakanyaragana no okubhura. ");
INSERT INTO zak_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hano wuyo yahitiri, eriibhaga ryo okubhara abhaatu, akatuukira omuutu owuundi wuno yaari akubhirikirwa Yuuda Omugariraaya. Ewe woosi akabhona abhaatu bho okumutuniirira, neewe woosi akiitwa, na bhoosi bhano bhaari bhamwiikiriirye, bhakanyaragana. ");
INSERT INTO zak_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Kweego, iguru ye engʼana yino, ndabhatoongera kubha, mutigane na abhaatu bhano. Mubhatige bhageende zyaabhu, kwo okubha, eraabhe amangʼana gano garweereeri kumuutu gatakuuza kubha. ");
INSERT INTO zak_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nawe eraabhe gayo ni mirimo gino gitaangirwe na Taatabhugya, mutakunagya kubharekya. Ambe mungʼeenihe bhwaheene mutaaza kurorekana kubha, murahakana na Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Abhakuru bhe ekiina bhakiikirirya obhutoongeri bhwa Gamarieri. Bhakabhabhirikira abheega bhayo bhakabhatema eziihiimbo, bhakabharekya bhateegya kweeki kwe eriina rya Yeesu. Okumara bhakabhatiga bhagye. ");
INSERT INTO zak_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ambe, abheega bhayo bhakahuruka kurwa mukiina, eno bhazomereerwe bhukongʼu, kwo okubha Taatabhugya akabhaha obhusuuku kwo okunyaakibhwa kuriina rya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Eziisiku zyoosi bhaheegya mwiiseengerero na muziinyuumba zya abhaatu, bhataatigiri kuraarika Amangʼana Amazomu kubha, Yeesu niwe Masiya. ");
INSERT INTO zak_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kuziisiku ziyo, abhaanabheega bha Yeesu bhakabha bharaaruha. Gati waabhu, bhaabharimu Abhayahudi bhano bhahaakeerenia ekigaambo kye Ekiyunaani, na Abhayahudi abharikyaabhu bhano bhahaakeerenia ekigaambo kye Ekiaramu. Bharya bhahaakeerenia Ekiyunaani bhakaririirira kubha, abhatuumba bhaabhu bhareebhwa eriibhaga rye esoondo ye ebhyaakurya bhye eziisiku zyoosi. ");
INSERT INTO zak_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kweego, abheega ikumi na bhabhiri bharya bhakasaanga na abhaanabheega bhoosi no okubhabhuurira, “Etari kisi, etwe tutige okweegya engʼana ya Taatabhugya, kwiiguru yo okusoondera abhaatu ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kweego abhahiiri bheetu, musore abhasubhe muhuungati gati weenyu bhano bhiizuriibhwe ne Ekoro Muhoreeru na amangʼeeni, okubha tubhatuure kumirimo gino. ");
INSERT INTO zak_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Neetwe turiiruusya kwo okumusabha Taatabhugya no okweegya abhaatu engʼana yaaye.” ");
INSERT INTO zak_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Gano bhaagaambiri, gakabhazomera abhaatu bhoosi. Neebho bhakasora Sitefano, omuutu wuno yiizwiiri Ekoro Muhoreeru na mweene obhwiikirirya bhukuru, na bhakabhasora Firipo, Porokoro, Nikanori, Timoni, Parimena na Nikorao wa Antiokia, wuno yarwiiri mukyaaro ekiindi akiikirirya enyaangi ye Ekiyahudi. ");
INSERT INTO zak_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Niho okumara bhakabhareeta abhaatu bhayo embere wa abheega. Abheega bhakabhatuurira amabhoko iguru waabhu no okubhasabhira. ");
INSERT INTO zak_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eriingʼana rya Taatabhugya rikageenderera kunyaragana kubhaatu. No obhwaaru bhwa abhaanabheega bhukabha bhuraaruha Yerusaremu, naabhe abhaseengeri bhaaru bhakamwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sitefano wuyo, eno yiizwiiri orubhaango runo yaheerwe na Taatabhugya, yaari no obhunagya bhwaaru, neewe ahaakora ebhyeerekenio ne ebhiruguuro gatigati wa abhaatu. ");
INSERT INTO zak_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nawe Abhayahudi abharebhe bhaari bharasakya kuhakana na Sitefano. Abhaatu bhayo bhaari bha munyuumba ye esaango yino yeekubhirikirwa Enyuumba ye Esaango ya Abhaatu Bhano Bhano Obhwiiragaanzi, nabho bhakarweera Kirene, Arekizandiria, Kirikia na Asia. ");
INSERT INTO zak_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nawe bhataanagirye kumuhiza, kwe ekigirirye kya amangʼeeni na akagaamba kwo okukaangatwa ne Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Niho bhakagaambana na abhaatu abhaandi kwo okubhaha ehoongo, okubha bhagaambe orurimi kubha bhamwiigwiiri Sitefano aragaamba amabhi go okumutuka Musa na Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwo okugaamba ego, bhakabhasiigirirya abhaatu, abhakaruka bha Abhayahudi na abheegya bhe emigiro. Neebho bhakamugwaata Sitefano no okumuhira mukiina kya abhakuru bha Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Okumara bhaareetiri abhamenyeekererya bho orurimi bhano bhaagaambiri orurimi bhakubhuga, “Omuutu wuno atakurosa no okutiga kugaamba amangʼana amabhi go okutuka eriiseengerero eriihoreeru rino, na iguru ye emigiro gya Musa! ");
INSERT INTO zak_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tumwiigwiiri arabhuga Yeesu Omunazareeti arahasarya ahagiro he eriiseengerero rya Taatabhugya, na arakyoosya eziinyaangi zoosi zino twabhweeni kurwa ku Musa.” ");
INSERT INTO zak_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Abhaatu bhoosi bhano bhaari bhiikeeri mukiina kiyo bhakamumogorera Sitefano, bhakarora obhusyo bhwaaye bhuramesya kyo obhusyo bhwa maraika. ");
INSERT INTO zak_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kyaamwe omuseengeri omukuru akamubhuurya Sitefano, “Gano goosi bhaagaambiri, ni ge eheene?” ");
INSERT INTO zak_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitefano akamukyoora, “Abhahiiri bhaane na bhataata, muniitegeerere! Taatabhugya wo obhuguungo akamutuukira zaazi weetu Aburahamu mukyaaro kya Mesopotamia, hano yaari akyaari kusaamira mumugye gwa Haraani. ");
INSERT INTO zak_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Taatabhugya akamubhuurira, ‘Orwe mukyaaro kyaazo kino na abhahiiri bhaazo, ogye mukyaaro kino niraakweerekye.’ ");
INSERT INTO zak_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Niho Aburahamu akasaama mukyaaro kyaaye kya Abhakaridayo, akagya kwiikara mumugye gwa Haraani. Eriibhaga ryo oruku rwa wiise waabhu, Taatabhugya akamusaamya, akamureeta mukyaaro kino mukwiikara tee bhoono. ");
INSERT INTO zak_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Taatabhugya ataamuheeri Aburahamu engabho yoyoosi mukyaaro kino, ataamuheeri naabhe ahagiro ho okutaza itazo rimwe. Nawe Taatabhugya akamuragania kubha, ewe no orwiibhuro rwaaye runo rukuuza bharagabha ekyaaro, yiingabha Aburahamu ataari na mwaana. ");
INSERT INTO zak_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Taatabhugya akamubhuurira Aburahamu, ‘Abhaatu bho orwiibhuro rwaazo bharabha abhagini mukyaaro kya abhaatu abhaandi, abhaatu bhe ekyaaro kiyo bharabhakora abhagya bhaabhu no okukorerwa kibhi kumyaaka magana ane (400).’ ");
INSERT INTO zak_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Taatabhugya akabhuga, ‘Nawe enye ndabhatema abhaatu bhe ekyaaro kiyo, bhano bharaabhakorye emirimo kya abhagya, okumara ndabharuusya abhiibhurwa bhaazo mukyaaro kiyo okubha bhaaze kuniseengera hano.’ ");
INSERT INTO zak_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Niho Taatabhugya akakora eriiragano rye esaaro na Aburahamu, okubha abhaana bhe ekisubhe bhoosi bhasaarwe. Kweego Aburahamu akamwiibhura Isaaka, akamusaara orusiku rwa kanaane kweema yiibhurwe. Niho okumara Isaaka woosi hano yamwiibhwiiri Yaakobo akamusaara, na Yaakobo woosi hano yiibhwiiri abhamura ikumi na bhabhiri, akabhasaara. Bhayo nibho bhazaazi bheetu. ");
INSERT INTO zak_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ambe, bhazaazi bheetu bhayo bhakamurorera omugono Yusufu, bhakamugurya abhe omugya mukyaaro kya Misiri. Nawe Taatabhugya yaari hamwe neewe, ");
INSERT INTO zak_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","akamutuurya munyaako yaaye yoosi. Taatabhugya akamuha amangʼeeni no orubhaango embere wa Farao, omutemi wa Misiri. Kweego omutemi wuyo akamuseega, akamutuura abhe omukaangati we ekyaaro no omwiimeerereri omukuru we enyuumba yaaye yo obhutemi. ");
INSERT INTO zak_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Niho ekatuuka enzara haari bhukongʼu mukyaaro kyoosi kya Misiri na Kanaani, ne enzara yiyo ekagirya enyaako nzaru, na bhazaazi bheetu bhataabhweeni ebhyaakurya. ");
INSERT INTO zak_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Hano Yaakobo yiigwiiri kubha engano eratuuka mukyaaro kya Misiri, akabhatuma abhaana bhaaye. Na runo nirwo rwaari orugeendo rwaabhu rwo obhweemero okugya eyo. ");
INSERT INTO zak_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Murugeendo rwaabhu rwa kabhiri, Yusufu akiimenyeekererya kubhahiiri bhaaye bhayo, na bhakamenyekana ku Farao. ");
INSERT INTO zak_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kyaamwe, Yusufu akatuma amangʼana kugya kumubhirikira wiise waabhu Yaakobo, hamwe na abhahiiri bhaaye bhoosi bhagye Misiri. Neebho bhoosi bhaari miroongo muhuungati na bhataano (75). ");
INSERT INTO zak_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kweego, Yaakobo akahiriingita kugya Misiri, eyo niyo ewe na bhazaazi bheetu bhaakweereeri. ");
INSERT INTO zak_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nawe emibhiri gyaabhu gikareetwa owaabhu mumugye gwa Shekemu, gikabhiikwa mumbiihira ya mwiibhigi yino Aburahamu yaguriri kwe eziimbirya ndebhe okurwa kubhaana bha Hamoori. ");
INSERT INTO zak_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Hano eriibhaga rikiisuka rya Taatabhugya akore kyeego yamuragiri Aburahamu, abhaatu bheetu bhakaaruha bhukongʼu Misiri eyo. ");
INSERT INTO zak_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mubhuteero, omutemi owuundi wuno ataamenyiri kiyo kyoosi iguru wa Yusufu, akataanga obhukaangati Misiri. ");
INSERT INTO zak_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Omutemi wuyo, akabhakorera eniku no okubhanyaakya bhazaazi bheetu, akabha arabhaswaagya bharekere abhaana bhaabhu abharere habhoori bhakwe. ");
INSERT INTO zak_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Eriibhaga riyo, niryo Musa yiibhwiirwe, yaari omwaana muzomu bhukongʼu. Yarerirwe na abhiibhuri bhaaye munyuumba yaabhu kwa myeeri etatu. ");
INSERT INTO zak_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Hano abhiibhuri bhaatamiibhwe kumubhisa, bhakamuhira igutu haguhi ne ekitaaro, niho omuukya wa Farao akamugega, akamurera kyo omwaana waaye omwiibhurwa. ");
INSERT INTO zak_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa akeegibhwa amangʼeeni goosi ga Abhamisiri, akabha omukaari kwo obhugaambi na amahokya. ");
INSERT INTO zak_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Hano Musa yahikirye emyaaka miroongo ene (40), akabha ne enaamba yo okugya kurorana na abhahiiri bhaaye bha Iziraeri. ");
INSERT INTO zak_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Akarora Omwiiziraeri wumwe aranyaakibhwa bhukongʼu no Omumisiri. Niho akagya bhwaangu kumutuurya omuhiiri waaye no okumurihira endihi, akamwiita Omumisiri wuyo. ");
INSERT INTO zak_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa yaari ariiseega kubha abhahiiri bhaaye bhaangamenyiri kubha Taatabhugya arabhatuurya kurwa mubhugya, kwo okuhitira kweewe, nawe bhataamenyiri ego. ");
INSERT INTO zak_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tabhoori yaho, akasikana na Abhiiziraeri bhabhiri bhararwaana. Akasakya kubhiigwaania akabhuga, ‘Bhamure, emwe ndora ni bhahiiri! Kwaki muriinyahaara?’ ");
INSERT INTO zak_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Nawe wuyo yaari kumunyaakya omurikyaaye akamuhuna Musa embarika, akamubhuurya, ‘Ni weewi wuno yakutuuriri obhe omukaangati weetu no omutaania weetu? ");
INSERT INTO zak_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bhoono, oreenda kuniita kyeego izo okiita Omumisiri wurya?’ ");
INSERT INTO zak_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Hano Musa yiigwiiri amangʼana gayo, akangʼosa, akagya mukyaaro kya Midiani, akiikara eyo kyo omugini. Hano yaari eyo, akiibhura abhaana bhabhiri. ");
INSERT INTO zak_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Hano Musa ahiikara Midiani, gyaari gihitiri emyaaka miroongo ene (40), niho akahwaarukirwa na maraika, hayo yaari mukibhara haguhi ne Ekiguru kya Sinai. Maraika wuyo yaari mukisaka kino kyaari kwaaka omuriro. ");
INSERT INTO zak_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa hano yaruuzi ekisaka kiyo akaruguura bhukongʼu. Akakiisukira kukiisuunza kisi, akiigwa eriiraka ryo Omukuru, riramubhuurira, ");
INSERT INTO zak_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Enye ni Taatabhugya wa bhazaazi bhaazo, Aburahamu, Isaaka na Yaakobo!’ Hano Musa yiigwiiri gayo, akataanga kurigita kwe ehaha, akoobhoha kurora ekisaka kiyo. ");
INSERT INTO zak_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Niho Omukuru akamubhuurira, ‘Ruusya ebhikweera bhyaazo, kwo okubha hayo wiimeereeri ni hagiro ahahoreeru. ");
INSERT INTO zak_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Eheene enye niruuzi enyaako ya abhaatu bhaane bhano bhari Misiri, niigwiiri ekiriro kyaabhu, na neenye niikiri nibhatuurye. Ambe, bhoono ndakutuma ogye Misiri.’ ");
INSERT INTO zak_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Musa wuyo, niwe wurya abhaatu bhakamwaanga, bhakabhuga, ‘Ni weewi wuno yakutuuriri obhe omukaangati weetu no omutaania weetu?’ Niwe wuno Taatabhugya yamutumiri abhe omukaangati waabhu no omutuurya waabhu, kwe enzira ya maraika wuno yamuhwaarukiiri mukisaka kiyo! ");
INSERT INTO zak_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa niwe, akabhakaangata okubharuusya mukyaaro kya Misiri, kwo okukora ebhiruguuro ne ebhyeerekenio bhyaaru, na mu Nyaanza ya Shamu, na mukibhara kwiibhaga rye emyaaka miroongo ene (40). ");
INSERT INTO zak_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa wuyo niwe akabhabhuurira Abhiiziraeri kubha, ‘Taatabhugya arabhasorera omurooti kya neenye, kurwa gati wa abhahiiri bheenyu, mumwiitegeerere ewe.’ ");
INSERT INTO zak_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Niwe wuno yaari hamwe ne esaango ya Abhiiziraeri mukibhara. Na niwe akakeerenia na maraika mu Kiguru kya Sinai, akasuungʼaana amangʼana go obhuhoru, okubha atuhe etwe. ");
INSERT INTO zak_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Bhazaazi bheetu, bhakaanga okumwiigwa Musa, bhakamutuura embarika, bhakabha ne enaamba muziikoro zyaabhu kukyoora Misiri. ");
INSERT INTO zak_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bhakamubhuurira Haruuni, ‘Otukorere emisaambwa gyo okubhaazwa, gino giraatukaangate munzira, kwo okubha Musa wuno yatukaangatiri kurwa Misiri, tutamenyiri amangʼana gano gaamubhweeni!’ ");
INSERT INTO zak_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kuziisiku ziyo bhakakora omusaambwa gwo okubhaazwa guno gutuubheeni ne ekimoori kye engʼoombe. Bhakaguruusirya ekimweeso no okuzomererwa kwe ekigiro kino bhaakikoriri kwa amabhoko gaabhu abheene! ");
INSERT INTO zak_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ambe, Taatabhugya akiikyoora, akabhatiga bhaseengere eryoobha, omweeri ne eziinzota, niigo ekaamirwe mukitabhu kya abharooti, ‘Emwe abhaatu bha Iziraeri, hano mwaari mukibhara, muhaanigwaagira emitugo na muhaaniruusirya ekimweeso kwiibhaga rye emyaaka miroongo ene (40)? ");
INSERT INTO zak_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Muhaageenda eno mugegiri eriibhuru ryo omusaambwa gweenyu Moreki, eno mune enzota yo omusaambwa gweenyu Refani, ne emisaambwa gyo okubhaazwa gino mukiikorera abheene no okugiseengera. Kweego, ndabhahira kure bhukongʼu kuhitiira omugye gwa Babeeri.’ ” ");
INSERT INTO zak_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sitefano akageenderera kugaamba, “Mukibhara eyo, bhazaazi bheetu bhayo, bhahaabha bharagya ne eriibhuru ryo okumuseengera Taatabhugya. Taatabhugya yaari amubhuuriiri Musa akore kyeego yaari amweerekirye. ");
INSERT INTO zak_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Okumara, bhazaazi bheetu bhano bhaakaangatiibhwe na Yoshua, bhakarisuungʼaana eriibhuru. Nabho bhakarireeta mukyaaro kino, hano bhaaruusirye mubhyaaro bhino Taatabhugya yakaangatiri kubhaheebha embere waabhu. Rikasaaga mukyaaro kyaabhu kiyo, tee kuziisiku zyo omutemi Daudi. ");
INSERT INTO zak_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi akazomererwa na Taatabhugya, woosi akamusabha amwoombokere Taatabhugya wa Yaakobo eriiseengerero. ");
INSERT INTO zak_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nawe omwoomboki we enyuumba yiyo yaari omutemi Soromooni. ");
INSERT INTO zak_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Naabhe ego, Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi, na ewe atakwiikara muziinyuumba zino zyoombokirwe na amabhoko ga abhaatu. Ni kyeego omurooti yabhugiri, ");
INSERT INTO zak_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Omukuru arabhuga, Eriisaaro nikyo ekituumbi kyaane kyo obhutemi, ne ekyaaro ni hagiro haane ho okutuura amaguru gaane. Bhoono, muraniombokera enyuumba ya tuubhoki? Ahagiro haane ho okumuunya harabha hayi? ");
INSERT INTO zak_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bhino bhyoosi, tiinye omweene nikabhiteema kwa amabhoko gaane?’ ” ");
INSERT INTO zak_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sitefano akageenderera kugaamba, “Emwe ni bhazabhuri abhakuru! Eziikoro na amatwi geenyu ni kya garya ga abhapagaani. Eziisiku zoosi muramuhakania Ekoro Muhoreeru, kyeego bhazaazi bheenyu bhoosi bhaari kumuhakania! ");
INSERT INTO zak_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bhoono, ariho omurooti naabhe owumwe wuno bhataamunyaakirye? Bhakabhiita naabhe abharooti bhe ekare bhano bhaari bhararwaazira okuuza Mweene Heene wa Taatabhugya! Na wuyo niwe wuno emwe mukamwaanga no okumwiita! ");
INSERT INTO zak_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Emwe mumariri kusuungʼaana emigiro gya Taatabhugya kwe enzira ya bhamaraika bhaaye, nawe mutaagigwaatiri.” ");
INSERT INTO zak_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Hano abhakuru bha Abhayahudi bhayo bhiigwiiri amangʼana ga Sitefano, bhakatiinda bhukongʼu, bhakasaanania ameeno gaabhu kwo obhururu. ");
INSERT INTO zak_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nawe Sitefano akabha yiizwiiri Ekoro Muhoreeru, akarora iguru kwiisaaro, akarora obhuguungo bhwa Taatabhugya na Yeesu yiimeereeri orubhaara rwo obhuryo rwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Niho akabhuga, “Murore! Ndarora eriisaaro riigwiirwe, no Omwaana wo Omuutu yiimeereeri orubhaara rwo obhuryo rwa Taatabhugya!” ");
INSERT INTO zak_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Niho abhakuru bha Abhayahudi bhayo bhakaribha amatwi gaabhu kwa amabhoko gaabhu, bhakakora ekituri. Bhakamuryaarira Sitefano, bhakamugwaata kwa hamwe. ");
INSERT INTO zak_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bhakamuhurukya igutu wo omugye, bhakataanga kumutema kwa amagina. Hano bhaari bhakyamutema amagina, abhamenyeekererya bhayo bhakaruusya emyeenda gyaabhu, bhakagitiga haguhi no omumura wumwe, wuno yakubhirikirwa Sauri. ");
INSERT INTO zak_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bhakabha bharageenderera kumutema Sitefano na amagina, eno arasabha arabhuga, “Omukuru Yeesu, osuungʼaane ekoro yaane!” ");
INSERT INTO zak_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kyaamwe akahigama, akarira kwe eriiraka ikuru, “Omukuru, otabhanyaakya kwe ebhibhi bhyaabhu bhino!” Hano yaagaambiri gayo, akakwa. Sauri woosi akarora bhwaheene kukino kyagirirye Sitefano akiitwa. ");
INSERT INTO zak_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Abhaatu bhe ekanisa ya mumugye gwa Yerusaremu, bhakataanga kunyaakibhwa bhukongʼu. Orusiku runo Sitefano yiitirwe, abhiikirirya bhoosi okuruusyamu abheega bhakangʼosa, bhakanyaragana mubhyaaro bhyoosi bhya Yudea na Samaria. ");
INSERT INTO zak_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Hayo niho abhaatu bhakumwiikirirya Taatabhugya, bhakamubhiika Sitefano no okumwaaramira kwo okumuririra bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sauri woosi akataanga okusarya abhaatu bhe ekanisa, akabha arasikira enyuumba kwe enyuumba, na arabhahurukya igutu abhiikirirya, abhasubhe na abhakari, no okubhatuura munyuumba ya abhabhohwa. ");
INSERT INTO zak_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nawe abhaanabheega bhakanyaaragana, bhakabha bhararaarikira abhaatu Amangʼana Amazomu iguru wa Yeesu ahagiro hoosi hano bhaagiiri. ");
INSERT INTO zak_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Firipo akagya mumugye gumwe gwa Samaria, akataanga okubharwaazira abhaatu bhe eyo amangʼana ga Masiya. ");
INSERT INTO zak_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Abhaatu bhaaru hano bhaamwiitegeereeri Firipo no okurora ebhyeerekenio bhino yaari kubhikora, bhakiitegeerera kwa kaniire kugano yaari aragaamba. ");
INSERT INTO zak_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Akabha araheebha amasaambwa amabhi kurwa mubhaatu bhaaru, gakabharwamu eno garatema ekituri. Akabha arahorya amagata maaru na abharema. ");
INSERT INTO zak_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Abhaatu bha mumugye guyo bhakazomererwa bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mumugye guyo, haari no omuutu wumwe omurogi, eriina ryaaye Simooni. Kwiibhaga itaambi, Simooni ahaaroga no okubharuguurya abhaatu bha Samaria, ariikumya kubha ewe ni muutu mukuru. ");
INSERT INTO zak_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Abhaatu bhoosi, abhasuuhu kwa abhakuru, bhaari bharamwiitegeerera kwa kaniire, bharabhuga, “Omuutu wuno ano obhunagya bhwa Taatabhugya, bhuno bhukubhirikirwa Obhunagya Obhukuru!” ");
INSERT INTO zak_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Abhaatu bhakabha bharamwiitegeerera, kwo okubha akabharuguurya kwiibhaga itaambi kwo obhurogi bhwaaye. ");
INSERT INTO zak_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nawe hano bhaamwiigwiiri Firipo kyeego yaakubharwaazira Amangʼana Amazomu iguru yo obhutemi bhwa Taatabhugya ni iguru we eriina rya Yeesu Krisito, abhasubhe na abhakari bhakiikirirya, bhakabatiizwa. ");
INSERT INTO zak_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simooni woosi akiikirirya Yeesu, akabatiizwa, akabha aramutuniirira Firipo ahagiro hoosi. Hano yaruuzi ebhitiika ne ebhyeerekenio ebhikuru bhino Firipo yaari arabhikora, akaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Abheega bhano bhaari Yerusaremu, hano bhakiigwa kubha abhaatu bha Samaria bhiikirirye engʼana ya Taatabhugya, bhakabhatumira Petero na Yohana bhagye eyo. ");
INSERT INTO zak_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na hano bhaahikiri Samaria, bhakasabhira abhaatu okubha bhabhone no okusuungʼaana Ekoro Muhoreeru, ");
INSERT INTO zak_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kwo okubha ataariho naabhe owumwe gati waabhu wuno Ekoro yaari amwiikiiri. Ebho bhaari bhabatiizirwe kuriina ryo Omukuru Yeesu eryeene. ");
INSERT INTO zak_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Niho, Petero na Yohana bhakatuura amabhoko gaabhu kubhiikirirya bhayo, bhakasuungʼaana Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simooni, hano yaruuzi kubha abhaatu bhasuungʼaaniri Ekoro Muhoreeru kwo okutuurirwa amabhoko ga abheega, akabhaha Petero na Yohana eziimbirya, akabhuga, ");
INSERT INTO zak_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Muunihe na neenye obhunagya bhuno, okubha abhaatu bhoosi bhano ndaabhatuurire amabhoko gaane, bhasuungʼaane Ekoro Muhoreeru.” ");
INSERT INTO zak_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petero akamukyoora, “Eziimbirya zyaazo zisike hamwe na naawe, kwo okubha oriiseega obhuturo bhwa Taatabhugya bhurabhoneka kwe eziimbirya! ");
INSERT INTO zak_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Awe, otana soondo ahagiro hayo hoosi mumirimo gya Taatabhugya gino, kwo okubha ekoro yaazo etari nzomu mumeeso gaaye. ");
INSERT INTO zak_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ambe, wiikyoore otige kimwe obhubhi bhwaazo bhuno, no omusabhe Omukuru, hamwe ariikirirye akwaabhire amiiseego amabhi ga mukoro yaazo. ");
INSERT INTO zak_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Niruuzi wiizwiiri omugono bhukongʼu, kyo obhururu bhwe endurwe na ni mubhohwa we ebhibhi bhyaazo.” ");
INSERT INTO zak_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Niho, Simooni akamubhuurira, “Munisabhire ku Mukuru, okubha ritaambona naabhe ingʼana rimwe kugayo gano mugaambiri!” ");
INSERT INTO zak_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hano Petero na Yohana bhaamariri kuruusya amangʼana gaabhu no okuraarika Amangʼana iguru wo Omukuru, bhakakyoora Yerusaremu. Hano bhaari kukyoora, bhakaraarika Amangʼana Amazomu kwo okuhitira mumigye myaaru gya Abhasamaria. ");
INSERT INTO zak_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Orusiku rumwe, maraika wo Omukuru akamubhuurira Firipo, “Bhuuka, ogye orubhaara rwa maamu, enzira yino ekuhita mukibhara okurwa Yerusaremu okweerekera Gaza.” ");
INSERT INTO zak_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kyaamwe Firipo akataanga orugeendo rwaaye rwo okugya. Hano yaari munzira, akasikana no omukuru wa Ethiopia, wuno yaari omuzigaru no omukaangati we eziimbirya zoosi zya Kandake, marikia wa Kushi, wuno yaari akwiimeererera eziihata zyaaye zyoosi. Woosi yaari agiiri Yerusaremu kumuseengera Taatabhugya, ");
INSERT INTO zak_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ne eriibhaga riyo yaari arakyoora yiika, akubha yiikeeri mumootoka yaaye yo okurutwa ne efaraasi, arasoma ekitabhu kyo omurooti Isaya. ");
INSERT INTO zak_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ekoro Muhoreeru akamubhuurira Firipo, “Noogye oyiisukiirire emootoka yiyo, ogeende nayo.” ");
INSERT INTO zak_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Niho Firipo akaryaarira haguhi kumootoka yirya, akiigwa omuutu wuyo arasoma ekitabhu kyo omurooti Isaya. Hayo Firipo akamubhuurya, “Gano okusoma oragamenya?” ");
INSERT INTO zak_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Neewe akamukyoora, “Ndanagyabhwi okumenya, eraabhe atariho omuutu wo okunigarurira?” Okumara omukuru wuyo, akamuginihya Firipo atiire mumootoka yaaye bhiikare hamwe. ");
INSERT INTO zak_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Omukuru wa Ethiopia wuyo akabha arasoma Amakaamo gano, “Akakaangatibhwa kye engʼoondu yino ekugya kugwaagwa. Akakira kye engʼoondu ekukira hano ekubha embere wo omuutu wuno akuyitina amabhuri, ewe ataaruusirye eriiraka riyo ryoosi. ");
INSERT INTO zak_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bhakamusuukya kwo okumutinira ekiina kutama eheene. Atariho omuutu wuno akutura kugaambira orwiibhuro rwaaye, kwo okubha akiitwa mukyaaro hano.” ");
INSERT INTO zak_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Omuzigaru wurya akamubhuurya Firipo, “Ndasabha ombuurire, omurooti wuno aragaamba iguru waaye omweene kasi aragaamba iguru wo omuutu owuundi?” ");
INSERT INTO zak_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kyaamwe Firipo akataanga na amangʼana gayo, akamurwaazira Amangʼana Amazomu iguru wa Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hano bhaari munzira murugeendo ruyo, bhakahika ahagiro hano haari na amaanzi. Omuzigaru omukuru wuyo akamubhuurira Firipo, “Rora, hano hana amaanzi! Ni kigiroki kino kiraanirekye nitabatiizwa?”  ");
INSERT INTO zak_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Firipo akamubhuurira, “Eraabhe oraamwiikirirye Yeesu Krisito kwe ekoro yaazo yoosi, oranagya kubatiizwa.” Akamubhuurira, “Ndiikirirya kubha Yeesu Krisito ni Mwaana wa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Neewe akaswaagya emootoka yiimeereribhwe. Kyaamwe bhoosi bhabhiri bhakiituuma mumootoka, bhakasikira mumaanzi, Firipo akamubatiiza. ");
INSERT INTO zak_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hano bhaarwiiri mumaanzi, Ekoro yo Omukuru ekamusaakura Firipo, no omuzigaru omukuru wuyo ataamuruuzi kweeki, nawe akagya zyaaye arazomererwa. ");
INSERT INTO zak_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Firipo akatuukira ari mumugye gwa Azota. Akataanga orugeendo rwo okugya mumugye gwa Kaisaria, akahita mumigye ararwaazira abhaatu Amangʼana Amazomu ga Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Eriibhaga riyoriyo, Sauri yaari akyaageenderera kukaanga kwo okwiita abhaanabheega bho Omukuru Yeesu. Orusiku rumwe akagya kumuseengeri omukuru, ");
INSERT INTO zak_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","akamusabha amuhe eziinyaarubha zyo okumumenyeekererya, agye naryo muziinyuumba zye eziisaango zyo omugye gwa Damesiko. Akakora ego, okubha araabhone abhaanabheega bhe enzira ya Yeesu, bharaabhe abhasubhe naabhe abhakari, anagye kubhabhoha no okubhareeta Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hano yaari akyaari murugeendo rwaaye ruyo rwo okugya Damesiko, kituukiro ego obhweero bhuhaari kurwa mwiisaaro bhukamubharira mbaara zyoosi. ");
INSERT INTO zak_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Akagwa haasi muu. Niho akiigwa eriiraka riramubhuurira, “Sauri, Sauri! Kwaki oraninyaakya?” ");
INSERT INTO zak_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauri akabhuurya, “Ee Omukuru, awe ni weewi?” Akamukyoora, “Enye neenye Yeesu, wuno okumunyaakya. ");
INSERT INTO zak_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bhoono imeerera, ogye osikire mumugye guyo, no orabhuurirwa rino rikweenderwa kukorwa.” ");
INSERT INTO zak_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abhaatu bhano bhaari murugeendo hamwe na Sauri, bhakabha bhiimeereeri kiri bhatana rya kugaamba, kwo okubha bhakiigwa eriiraka ryo omuutu nawe bhataari kurora wuno yaari kugaamba. ");
INSERT INTO zak_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauri akabhuuka kurwa haasi harya, na hano yasakirye kuramukya ameeso gaaye, ataanagirye kurora ekigiro kiyo kyoosi. Ambe abharikyaaye bhayo bhakamugwaata okubhoko no okumukaangata tee Damesiko. ");
INSERT INTO zak_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Akiikara muyo eno ataakurora kwa siku isatu. Eriibhaga riyo ryoosi ataariri naabhe kunywa kigiro kyokyoosi. ");
INSERT INTO zak_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damesiko eyo, haari no omwaanamweega wumwe, eriina ryaaye Anania. Omukuru akamubhirikira Anania mubhurori, “Anania!” Woosi akiitabha, “Enye niri hano, Omukuru.” ");
INSERT INTO zak_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Neewe Omukuru akamubhuurira, “Bhuuka ogye munyuumba ya Yuuda, eri kunzira yino ekubhirikirwa Obhweema. Obhuurye muyo omuutu wuno arwiiri mumugye gwa Tariso, eriina ryaaye Sauri. Eriibhaga rino arasabha, ");
INSERT INTO zak_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","neewe aruuzi obhurori, na mubhurori bhuyo, akamurora omuutu wuno akubhirikirwa Anania arasikira munyuumba yino arimu, aramutuurira amabhoko iguru wa ameeso gaaye, okubha anagye okurora kweeki.” ");
INSERT INTO zak_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nawe Anania akakyoora, “Omukuru, niigwiiri kurwa kubhaatu bhaaru kubha, Sauri wuyo yaari arabhakorera abhahoreeru bhaazo amabhi hano yaari Yerusaremu! ");
INSERT INTO zak_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Neewe yiiziri Damesiko hano, ano obhunagya kurwa kubhakuru bha abhaseengeri kubha, abhagwaate bhoosi bhano bhakukuseengera kwe eriina ryaazo.” ");
INSERT INTO zak_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nawe Omukuru akamubhuurira Anania, “Noogye. Omuutu wuyo, nimusoriri abhe omuhokya waane, okubha ariraarike eriina ryaane kubhaatu bhano bhatari Abhayahudi, kubhatemi bhaabhu, naabhe ku Bhiiziraeri abheene. ");
INSERT INTO zak_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Enye ndamweerekya kyeego akweenderwa anyaake bhukongʼu kwiiguru we eriina ryaane.” ");
INSERT INTO zak_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kyaamwe Anania akagya, akasikira munyuumba yiyo. Akatuura amabhoko gaaye iguru ku Sauri, akamubhuurira, “Omuhiiri waane Sauri, Omukuru Yeesu wuno yakuhwaarukiiri kunzira, hano waari kuuza eno, anitumiri kwaawe, okubha orore kweeki, na wiizuriibhwe Ekoro Muhoreeru.” ");
INSERT INTO zak_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kituukiro ego, ebhigiro kya amaguunzu bhikagwa kurwa mumeeso ga Sauri, akanagya kurora kweeki, akiimeerera, akabatiizwa. ");
INSERT INTO zak_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Okumara akarya ebhyaakurya, akabhona amanaga kweeki. Kuziisiku eziindebhe akiikara eyo, ari hamwe na abhaanabheega bha Yeesu bhano bhaari mumugye gwa Damesiko. ");
INSERT INTO zak_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kyaamwe akataanga okugya munyuumba ye esaango ya Abhayahudi, akabha arabharwaazira amangʼana ga Yeesu, kubha ewe niwe Omwaana wa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abhaatu bhoosi bhano bhaamwiigwiiri Sauri, bhakaruguura bhukongʼu, bhakabha bhariibhuurya, “Omuutu wuno, atari wurya yaari kunyaakya abhaatu bha Yeesu bha Yerusaremu eyo? Na ewe ataari yiiziri agwaate abhaatu abhabhohe na abhahire kubhakuru bha abhaseengeri?” ");
INSERT INTO zak_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nawe Sauri akoongera okubhona amanaga, no okubharuguurya kwo okubhamenyeekererya Abhayahudi bha Damesiko kubha Yeesu niwe Masiya. Yaareegya kyeego Amakaamo Amahoreeru gakugaamba, bhakatamwa kumuhakania. ");
INSERT INTO zak_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Hano eziisiku nzaru zyahitiri, Abhayahudi bhakakora omukoonyo gwo okumwiita Sauri. ");
INSERT INTO zak_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nawe Sauri akazweeniibhwa iguru yo omukoonyo gwaabhu guyo. Bhakamwiiratira mubhiseku bhyo omugye obhutiku no omwiisi, okubha bhanagye kumwiita. ");
INSERT INTO zak_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na hano obhutiku bhwaahikiri, abhaanabheega bhaaye bhakamugega, bhakamutuura mugusehi ogukuru guno gwaari gubhohirwe eziisiri, bhakaguhitya mwiibhaanga eriikuru rino ryaari kunyiki yo omugye, bhakiituumya haasi. ");
INSERT INTO zak_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ambe, Sauri akagya Yerusaremu. Hano yahikiri eyo, akasakya kugwaatana na abhaanabheega, nawe bhaari bharamwoobhoha, bhatiikiriirye kubha ewe woosi abheeri omwaanamweega. ");
INSERT INTO zak_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nawe Barinaaba akamuhira Sauri kubheega. Akabhabhuurira kyeego Sauri akamurora Omukuru Yeesu munzira, hano yaaragya Damesiko na kyeego Omukuru akakeerenia neewe. Woosi akabhabhuurira kyeego Sauri akarwaaza kwo obhukaari, iguru wa Yeesu kubhaatu bhe eyo Damesiko. ");
INSERT INTO zak_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kweego Sauri akiikara na abheega, na akabha areegya abhaatu iguru yo Omukuru Yeesu kwo obhukaari mumugye gwa Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ewe yaari arakeerenia no okuhakana na Abhayahudi bhano bhakugaamba ekigaambo kye Ekiyunaani, nawe ebho bhahaasakya okumwiita. ");
INSERT INTO zak_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Hano abhiikirirya abhaandi bhaabhweeni amangʼana gayo, bhakamuheregesya tee mumugye gwa Kaisaria, no okumutuma kubha agye Tariso. ");
INSERT INTO zak_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Eziisiku ziyo, abhaatu bhe ekanisa bhaari no omureembe mbaara zyoosi zya Yudea, Gariraaya na Samaria. Abhaatu bhayo bhakaaruha kwo okwoongera ekireengo kyaabhu. Bhakageenderera kukongʼera bhakabha bharamusuuka no okumwiigwa Omukuru Yeesu, no okugosororibhwa ne Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Hano Petero yaari kugya orugeendo rwa ahagiro hoosi, akahika Ruuda okutaarira abhahoreeru bhano bhaari kwiikara mumugye guyo. ");
INSERT INTO zak_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mumugye hayo, akasikana no omuutu wumwe, eriina ryaaye ni Ainea, wuno ahaabha aremeeri no okuhiindira kubhuriri bhwaaye kwe emyaaka enaane. ");
INSERT INTO zak_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petero akamubhuurira, “Ainea, Yeesu Krisito arakuhorya, bhuuka, waarye obhuriri bhwaazo.” Hayohayo Ainea akabhuuka! ");
INSERT INTO zak_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Abhaatu bhoosi bha Ruuda na Sharooni bhakamurora Ainea, bhakiikyoora no okumwiikirirya Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Mumugye gwa Yafa kwaari no omukari wumwe, omwaanamweega wo Omukuru Yeesu, eriina ryaaye Tabita, na mukigaambo kye Ekiyunaani ni Dorikasi, no obhugazuro bhwaku ni mbarahe. Dorikasi yaari ne eteemwa nzomu, na yaari arasakirya abhataka. ");
INSERT INTO zak_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eziisiku ziyo Dorikasi akarwaara tee akakwa. Hano abhaatu bhaamariri okwiisaabhya omubhiri gwaaye, bhakaguhiindirya mukyuumba kya mukinazo. ");
INSERT INTO zak_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na kwo okubha omugye gwa Ruuda gwaari haguhi na Yafa, hano abhaanabheega bhiigwiiri kubha Petero yaari Ruuda, bhakatuma abhaatu bhabhiri kugya kumwiisasaama Petero kwo okumubhuurira, “Nawuuze bhwaangu oweetu, otakeezera!” ");
INSERT INTO zak_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kyaamwe Petero akabhuuka, akagya nabho. Hano bhaahikiri Yafa, bhakamuhira mukyuumba kya mukinazo kirya. Abhatuumba bhaaru bhaari bhamwiinogooriri, bhararira no okumweerekya eziingibho ne emyeenda egiindi gino Dorikasi ahaatuma hano yaari akyaari muhoru. ");
INSERT INTO zak_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petero akabhahurukya bhoosi habhoori we ekyuumba, akahigama, akasabha Taatabhugya. Okumara akiikibhukira ekituundu kirya, akabhuga, “Tabita, imeerera!” Niho akaramukya ameeso gaaye, akamurora Petero, akiikara. ");
INSERT INTO zak_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petero akamugwaata okubhoko, akamusakirya okwiimeerera. Akabhabhirikira abhatuumba hamwe na abhahoreeru abhaandi, akabhagwaatya Dorikasi muhoru. ");
INSERT INTO zak_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Amangʼana gayo gakanyaragana bhukongʼu mumugye guyo gwoosi gwa Yafa, na abhaatu bhaaru bhakamwiikirirya Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petero akiikara Yafa kwa siku nzaru, akiikara munyuumba ya Simooni omusasaabhi wa amasaakwa. ");
INSERT INTO zak_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mumugye gwa Kaisaria yaariho omukuru wa abhasirikare, eriina ryaaye ni Korinerio. Ewe akiimeererera abhasirikare igana (100), okurwa mwiihizo ikuru rya abhasirikare rino rikubhirikirwa Abhiitaria. ");
INSERT INTO zak_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Omukuru wuyo yaari muutu muzomu, na yaari aramwiigwa Taatabhugya hamwe na abhaatu bhoosi bho omugye gwaaye. Na yaari aramusabha Taatabhugya kwiibhaga ryoosi. Hamwe na gayo, yaari arasakirya bhukongʼu abhataka bhe Ekiyahudi. ");
INSERT INTO zak_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Orusiku rumwe kye eriibhaga rya keenda mumwiisi, Korinerio akarora obhurori. Mubhurori bhuyo, akamurora maraika wa Taatabhugya aramuhwaarukira no okumubhirikira, “Korinerio!” ");
INSERT INTO zak_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korinerio akamutaangaarira maraika wuyo kwo obhwoobha, akamubhuurya, “Omukuru, niki kibheeri?” Maraika wuyo akamubhuurira, “Taatabhugya yiigwiiri okusabha kwaazo ne ekimweeso kyaazo, aruuzi kyeego waari kusakirya abhataka. Gayo goosi aragahiita mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kweego bhoono, otume abhaatu bhagye mumugye gwa Yafa, bhamureete Simooni, eriina ryaaye eriindi arabhirikirwa Petero. ");
INSERT INTO zak_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ariikara na Simooni omusasaabhi wa amasaakwa, enyuumba yaaye eri embarika we enyaanza.” ");
INSERT INTO zak_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Hano maraika yaamariri kumubhuurira Korinerio gayo, akagya no orugeendo. Niho Korinerio akabhabhirikira abhabhiri gati wa abhahokya bhaaye, no omusirikare wumwe wo okurwa kubharya bhaari kumukorera emirimo, ewe yaaramwiigwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na hano Korinerio yaabhabhuuriiri goosi gano gaatuukiri, akabhatuma bhagye Yafa. ");
INSERT INTO zak_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Etabhoori yaho, hano abhaatu bhatatu bhayo bhaari bhiisukiiri omugye gwa Yafa, Petero woosi akatiira kukisara kye enyuumba okumusabha Taatabhugya, eriibhaga rya kasaasabha mumwiisi. ");
INSERT INTO zak_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Akiigwa enzara, akabha ne enaamba yo okurya. Hano bhaari bhakumuhokeerya ebhyaakurya, ewe akarora obhurori. ");
INSERT INTO zak_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kwo obhurori bhuyo, akarora eriisaaro ririigurwa, ne ekigiro kyo omweenda omukuru guno gugwaatiriirwe mbaara zyaaye inye, guriituumibhwa mukyaaro. ");
INSERT INTO zak_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mumweenda guyo haari ne ebhityeenyi bhya maanga goosi. Ebhityeenyi bhya amaguru ane, ebhityeenyi bhino bhikugeendera eziinda ne ebhinyonyi bhino bhikubhururuka. ");
INSERT INTO zak_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kyaamwe Petero akiigwa eriiraka riramubhuurira, “Petero, bhuuka, ogwaage, orye!” ");
INSERT INTO zak_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petero akamukyoora, “Zeyi, Omukuru! Nikyaari kurya bhyaakurya bhyobhyoosi ebhibhi, bhino bhigaambirwe ne emigiro gyeetu gye Ekiyahudi kubha ni makire!” ");
INSERT INTO zak_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Eriiraka riyo rikamubhuurira kweeki rikubhuga, “Otabhibhirikira ebhigiro bhino Taatabhugya abhyeeriirye kubha ni makire.” ");
INSERT INTO zak_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Engʼana yino yakyooreerwe katatu koosi, kyaamwe omweenda gurya gukakyooribhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Hano Petero yaari aratitiikana iguru yo obhugazuro bhwo obhurori bhuyo, abhaatu bhatatu bhano bhaatumirwe na Korinerio bhakahika, bhakiimeerera habhoori we ekiseku kye enyuumba ya Simooni. ");
INSERT INTO zak_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhakabhuga hanoo no okubhuurya, “Hano, ariho omugini wuno akubhirikirwa Simooni, eriina eriindi arabhirikirwa Petero?” ");
INSERT INTO zak_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na hano Petero yaari ariiseega iguru yo obhurori bhuyo, Ekoro Muhoreeru akamubhuurira, “Itegeerera! Hano bhariho abhaatu bhatatu bharakumoohya. ");
INSERT INTO zak_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wiituume iyaasi, ogye hamwe nabho, otabha no obhwiitiimaati, kwo okubha enye omweene neenye nibhatumiri owaazo.” ");
INSERT INTO zak_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petero akiituuma kugya kubhaatu bharya, akabhuga, “Enye niwe wuno mukumoohya. Ni kwaki mwiiziri?” ");
INSERT INTO zak_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bhakamukyoora, “Tutumirwe no omukuru wa abhasirikare, eriina ryaaye ni Korinerio. Ewe araguungibhwa na Abhayahudi bhoosi, kyeego yaakumwiigwa Taatabhugya, na ni muutu muzomu. Bhoono yeerekiibhwe na maraika wa Taatabhugya kubha, akuginihye yiika waaye, okubha yiitegeerere amangʼana gano oraamubhuurire.” ");
INSERT INTO zak_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kyaamwe, Petero akabhaginihya munyuumba, akabhaha ahagiro ho okuhiindira obhutiku bhuyo. Etabhoori yaho, Petero na abhatatu bharya bhakataanga orugeendo na abhiikirirya abhaandi bho okurwa Yafa bhakahirana. ");
INSERT INTO zak_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","No orusiku runo rwarumusiiri hayo, bhakahika mumugye gwa Kaisaria. Hano bhaahikiri, bhakabhona Korinerio arabhaganya, hamwe na abhahiiri na abhasaani bhano yaari araarikiri. ");
INSERT INTO zak_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Hano Petero yaakusikira wa Korinerio, Korinerio akamusuungʼaana, akahigama haasi bhubhuumari embere waaye no okwiihiinya haasi kwo obhwiitegeereri. ");
INSERT INTO zak_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nawe Petero akamwiimeererya, akamubhuurira, “Imeerera! Enye woosi ni muutu kya awe!” ");
INSERT INTO zak_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petero hano yaakugaamba na Korinerio, bhakabha bharasikira munyuumba, bhakabhona abhaatu bhaaru bhiikumaniiryemu. ");
INSERT INTO zak_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petero akabhabhuurira, “Emwe mumenyiri kisi kubha, etwe Abhayahudi tutakweenderwa ne emigiro gyeetu kubha obhumwe na abhaatu bhano bhatari Abhayahudi, naabhe kutaarirana nabho. Nawe Taatabhugya anirekirye kubha nitabhirikira muutu wuyo woosi makire, naabhe nitabhuga atakweenderwa. ");
INSERT INTO zak_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kiyo nikyo ekigirirye kyo okuuza hano mumbirikiiri, na nikaaza nitana haha. Bhoono, mumbuurire, kwaki mumbirikiiri?” ");
INSERT INTO zak_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korinerio akamubhuurira, “Siku isatu zino zihitiri eriibhaga kya rino rya keenda mumwiisi, niari ndasabha Taatabhugya munyuumba yaane. Kituukiro nikarora omuutu yiimeereeri embere waane, yiibhohiri emyeenda gino gibhaanziri. ");
INSERT INTO zak_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Akaanibhuurira, ‘Korinerio, Taatabhugya yiigwiiri okusabha kwaazo ne ekimweeso kyaazo na arahiita kyeego waari okusakirya abhataka. ");
INSERT INTO zak_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kweego, otume abhaatu bhagye mumugye gwa Yafa, bhamureete Simooni, eriina ryaaye eriindi arabhirikirwa Petero. Ewe ariikara mumugye gwa Simooni omusasaabhi wa amasaakwa. Enyuumba yaaye eri embarika we enyaanza.’ ");
INSERT INTO zak_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nikatuma abhaatu owaazo rugeendo rumwe, na naawe okoriri kisi kuuza. Bhoono twoosi turi embere wa Taatabhugya, okubha twiitegeerere amangʼana goosi gano Omukuru akuswaagirye kutubhuurira.” ");
INSERT INTO zak_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Niho Petero akabhabhuurira abhaatu bhayo, “Bhoono niho nimenyiri kubha ni heene, Taatabhugya atana obhwaahuri mubhaatu! ");
INSERT INTO zak_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nawe arabhiikirirya abhaatu bhe ebhigaambo bhyoosi bhano bhakumwiigwa, no okukora kisi embere waaye. ");
INSERT INTO zak_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Emwe mumenyiri amangʼana gano Taatabhugya abhaheeri Abhiiziraeri, akurwaaza Amangʼana Amazomu kubha, bhanagye kubhona omureembe na Taatabhugya kwe enzira ya Yeesu Krisito. Yeesu wuyo ni Mukuru wa abhaatu bhoosi. ");
INSERT INTO zak_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mumenyiri amangʼana gano gaatuukiri mukyaaro kyoosi kya Yudea, okweemera Gariraaya hano Yohana yaari amariri okurwaazira abhaatu kubha bhabatiizwe. ");
INSERT INTO zak_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Na kweeki mumenyiri kyeego Taatabhugya yamusoriri Yeesu wa Nazareeti, kwo okumuha Ekoro Muhoreeru no obhunagya. Yeesu akagya eyo ne eyo, arakora amazomu no okuhorya bhoosi bhano bhaari kunyaakibhwa na Seetaani, kwo okubha Taatabhugya yaari hamwe neewe. ");
INSERT INTO zak_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Etwe niitwe abhamenyeekererya bha amangʼana goosi gano Yeesu yakoriri mukyaaro kya Abhayahudi, na mumugye gwa Yerusaremu. Okumara bhakamwiita kwo okumusuruungaazya kumusaraba, ");
INSERT INTO zak_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","nawe orusiku rwa katatu, Taatabhugya akamuryoora, akamweerekya kubhaatu. ");
INSERT INTO zak_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ataarorekeeni kubhaatu bhoosi, nawe kubharya bhano Taatabhugya yaari abhasoriri kubha abhamenyeekererya bho okumurora. Abhamenyeekererya bhayo, ne etwe. Hano yamariri kuryooka, tukamurora, tukarya no okunywa hamwe nawe. ");
INSERT INTO zak_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Akatuswaagya turwaazire abhaatu Amangʼana Amazomu no okuraarika kubha, ewe niwe akatuurwa na Taatabhugya, abhatinire ebhiina abhahoru na abhaku. ");
INSERT INTO zak_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abharooti bhoosi bhakagaamba iguru waaye kubha, omuutu wowoosi wuno araamwiikirirye araabhirwa ebhibhi bhyaaye kwe enzira ye eriina ryaaye.” ");
INSERT INTO zak_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Hano Petero yaari akyagaamba gayo, Ekoro Muhoreeru akabhiikira bhoosi bhano bhaari bharamwiitegeerera. ");
INSERT INTO zak_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abhayahudi abhiikirirya bhano bhaari bhiiziri hamwe na Petero, bhakaruguura bhukongʼu kurora kubha Taatabhugya akabhiituruurira abhaatu bhano bhatari Abhayahudi Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bhakamenyeekererya kwo okubha bhakiigwa abhaatu bhayo bharagaamba kwe ebhigaambo ebhiindi kumukumya Taatabhugya. Okumara Petero akabhuga, ");
INSERT INTO zak_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Abhaatu bhano bhabhweeni Ekoro Muhoreeru kyeego etwe. Ni weewi wuno akutura kubharibhira abhaatu bhano bhatabatiizwa kwa amaanzi?” ");
INSERT INTO zak_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Niho Petero akaswaagya kubha Korinerio na abharikyaaye bhabatiizwe kwe eriina rya Yeesu Krisito, na akiikara nabho kwa siku suuhu. ");
INSERT INTO zak_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abheega bha Yeesu na abhiikirirya bha Yudea, bhakiigwa kubha, abhaatu bhano bhatari Abhayahudi bhiikiriirye engʼana ya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kweego, hano Petero yakyooriri Yerusaremu, Abhayahudi bhano bhaari bhamwiikiriirye Yeesu, bhakataanga kumwiiyogya, ");
INSERT INTO zak_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","bharabhuurya, “Ni kwaki okasikira mumigye gya abhaatu bhano bhatari Abhayahudi no okurya hamwe nabho?” ");
INSERT INTO zak_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Niho Petero akataanga kubharagirirya kwo okubhamenyeekererya kyeego goosi gaatuukiri, akabhuga, ");
INSERT INTO zak_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Orusiku rumwe, niari mumugye gwa Yafa ndamusabha Taatabhugya, nikarora obhurori. Na mubhurori bhuyo nikarora ekigiro kyo omweenda omukuru guno gugwaatiriirwe mbaara inye. Omweenda guyo gwaari guriituumibhwa kurwa mwiisaaro, gukiitumira orubhaara rwaane. ");
INSERT INTO zak_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nikiisuunza bhwaheene, nikarora ebhityeenyi bhya maanga goosi. Ebhityeenyi bhya amaguru ane, ebhityeenyi bhya mwiitirigo, ebhityeenyi bhino bhikugeendera eziinda ne ebhinyonyi bhino bhikubhururuka. ");
INSERT INTO zak_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Niho nikiigwa eriiraka riranibhuurira, ‘Petero, bhuuka, ogwaage orye!’ ");
INSERT INTO zak_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Nikakyoora, ‘Zeyi, Omukuru! Nikyaari kurya bhyaakurya bhyobhyoosi ebhibhi, bhino bhigaambirwe ne emigiro gyeetu gye Ekiyahudi kubha ni makire!’ ");
INSERT INTO zak_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Kweeki nikiigwa eriiraka rugeendo rwa kabhiri kurwa mwiisaaro rirabhuga, ‘Otabhibhirikira ebhigiro bhino Taatabhugya abhyeeriirye kubha ni makire.’ ");
INSERT INTO zak_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Engʼana yiyo ekatuuka katatu koosi, kyaamwe ebhityeenyi bhiyo bhyoosi bhikakyooribhwa mwiisaaro. ");
INSERT INTO zak_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Eriibhaga riyoriyo, abhaatu bhatatu bhano bhaatumirwe kurwa ku Kaisaria bhakahika embere we enyuumba yino niari kwiikara. ");
INSERT INTO zak_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ekoro Muhoreeru akaanibhuurira nigye hamwe nabho, nitiitiimaata kwo okubha bhayo bhatari Abhayahudi. Kweego nikagya hamwe na abharikyeetu bhasaasabha, tee tukasikira munyuumba ya Korinerio. ");
INSERT INTO zak_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Niho akatubhuurira kyeego maraika akiimeerera yiika waaye, akamubhuurira, ‘Otume abhaatu bhagye mumugye gwa Yafa, bhamureete Simooni, eriina ryaaye eriindi arabhirikirwa Petero. ");
INSERT INTO zak_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wuyo niwe araakubhuurire amangʼana, na kwo okugagwaata gayo, mutuuribhwe awe na abhaatu bhoosi munyuumba yaazo.’ ");
INSERT INTO zak_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Hano nataangiri kugaamba, Ekoro Muhoreeru akabhiikira, kyeego yatuhwaarukiiri kubhweemero. ");
INSERT INTO zak_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Hayo niho nahiitiri amangʼana garya Omukuru Yeesu yatubhuuriiri, ‘Yohana akabatiiza abhaatu kwa amaanzi, nawe emwe murabatiizwa kwe Ekoro Muhoreeru.’ ");
INSERT INTO zak_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Eraabhe Taatabhugya akabhaha abhaatu bhano Ekoro Muhoreeru, kyeego yatuheeri etwe hano twaamwiikiriirye Omukuru Yeesu Krisito, bhoono, enye ni weewi, naabhe nisakye kumwaanga Taatabhugya?” ");
INSERT INTO zak_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hano Abhayahudi bhiigwiiri gayo, bhataari na ryo okuhakanira. Bhakamukumya Taatabhugya bhakabhuga, “Heene, Taatabhugya abhaheeri abhaatu bhano bhatari Abhayahudi omweeya gwo okuta ebhibhi bhyaabhu, okubha bhabhone obhuhoru bhwa kirakeego!” ");
INSERT INTO zak_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ambe, kuriingʼaana no okunyaakibhwa kuno kwatuukiiri no okwiitwa kwa Sitefano, abhiikirirya bhakanyaragana no okungʼosera mukyaaro kya Foinike, mukigiinga kya Kipuro na mumugye gwa Antiokia. Bhakarwaaza engʼana ya Taatabhugya, nawe ku Bhayahudi abheene. ");
INSERT INTO zak_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nawe gati waabhu bhaari bharimu abhaatu bha Kipuro na Kirene, bhano bhaagiiri mumugye gwa Antiokia, no okugaambana na abhaatu bhano bhatari Abhayahudi, no okubharwaazira Amangʼana iguru yo Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Omukuru akabhakaangata kwo obhunagya bhwaaye, akagirya abhaatu bhaaru bhakamwiikirirya no okumwiikyoorera Omukuru. ");
INSERT INTO zak_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Abhaatu bhe ekanisa ya Yerusaremu, hano bhakiigwa amangʼana gayo, bhakamutuma Barinaaba agye Antiokia. ");
INSERT INTO zak_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Hano yahikiri eyo, akarora kyeego Taatabhugya abhaheeri abhaatu bhayo orubhaango rwaaye. Akazomererwa bhukongʼu, akabha arabhakumiirirya kubha bhabhe abhaheene ku Mukuru Yeesu, bhageenderere na amiiseego amagumiru muziikoro zyaabhu. ");
INSERT INTO zak_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barinaaba yaari muutu muzomu, na yiizwiiri Ekoro Muhoreeru no obhwiikirirya bhukuru. Ne ekireengo kya abhaatu bho Omukuru Yeesu bhakaaruha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Okumara Barinaaba akagya mumugye gwa Tariso kumumoohya Sauri. ");
INSERT INTO zak_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hano yamubhweeni, akamureeta Antiokia. Na kubhubhiri bhwaabhu bhakiikara na abhaatu bhe ekanisa yirya omwaaka mugima, bhareegya abhaatu bhaaru bhukongʼu iguru wa Yeesu. Antiokia hayo nimwe abhaanabheega bha Yeesu bhakataanga kubhirikirwa Abhakrisito. ");
INSERT INTO zak_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Muziisiku ziyo, abharooti bhakaaza Antiokia okurwa Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Owumwe waabhu, wuno yaari kubhirikirwa Agabo, akiimeerera musaango, akaruusya obhurooti kwe enzira ye Ekoro Muhoreeru kubha, enzara haari eraaza kukyaaro kyoosi. Na heene enzara ekatuuka mubhukaangati bhwa Kiraudio. ");
INSERT INTO zak_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kuriingʼaana no obhurooti bhuyo, abhaanabheega bhoosi bha Antiokia, bhakeenda kubha, kuriingʼaana no obhunagya bhwaabhu, bharuusye obhusakirya kwiiguru wa Abhakrisito abharikyaabhu bhano bhaari kwiikara Yudea. ");
INSERT INTO zak_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bhakakora ego, bhakahaana Barinaaba na Sauri eziisaambo ziyo, okubha bhazihire kubhakaruka bhe ekanisa ya Yudea. ");
INSERT INTO zak_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Muziisiku ziyo, omutemi Herode Agiripa akataanga kunyaakya abhiikirirya abhaandi. ");
INSERT INTO zak_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Akaswaagya Yaakobo omuhiiri waaye Yohana, yiitwe kwa nyaambato. ");
INSERT INTO zak_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hano yaruuzi kubha engʼana yiyo ebhazomeeri Abhayahudi, akaswaagya na Petero agwaatwe. Gano gaatuukiri eriibhaga rye Enyaangi ye Emikaate Gino Gitana Ekibhwiisya. ");
INSERT INTO zak_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hano bhaamariri kumugwaata Petero, Herode akaswaagya abhoherwe munyuumba ya abhabhohwa. Akamugwaatya kumahizo ane ga abhasirikare bhane bhane, okubha bhamuriibhe kisi. Akeenda okutina ekiina embere wa abhaatu hano enyaangi ekuhwa. ");
INSERT INTO zak_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ambe, Petero yaari abhohirwe munyuumba ya abhabhohwa, nawe abhaatu bhe ekanisa bhakakora omukya kumusabhira ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Obhutiku bhwo orusiku runo Herode yaari yeendiri okumutinira ekiina, Petero yaari ahiindiiri munyuumba ya abhabhohwa. Yaari gatigati wa abhasirikare bhabhiri, eno abhohirwe ne eminyororo ebhiri. Abhasirikare abhaandi bhaari bharariibha habhoori we ekiseku kye enyuumba ya abhabhohwa. ");
INSERT INTO zak_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kituukiro ego, maraika wo Omukuru akiimeerera ahagiro hano Petero yaari, obhweero bhukabhaanza mukyuumba kiyo. Maraika akamutema Petero murubharu no okumubhuukya, akamubhuurira, “Bhuuka bhwaangu!” Kyaamwe eminyororo gino bhaamubhoheeri Petero kumabhoko gikagwa haasi! ");
INSERT INTO zak_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Okumara maraika akamubhuurira, “Wiibhohe emyeenda gyaazo ne ebhikweera bhyaazo.” Petero hano yamariri kukora ego, maraika akamubhuurira, “Ibhoha ekabhuuti yaazo, onituniirire!” ");
INSERT INTO zak_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petero akamutuniirira maraika wurya igutu we enyuumba ya abhabhohwa, bhakeerekera habhoori we enyuumba yiyo. Nawe Petero ataamenyiri kubha amahokya gayo goosi ga maraika gaari ge eheene, yaari ariiseega kubha ararora obhurori. ");
INSERT INTO zak_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Petero na maraika wuyo bhakahita kubhariibhi bho obhweemero, na bha kabhiri, bhakahika kukiseku kye ekyooma kyo okusikirira mumugye. Ekiseku kiyo kikiiguka ekyeene, bhakahuruka kurwa mukibhoho. Bhakahita enzira yimwe, kyaamwe maraika wuyo akamutiga Petero. ");
INSERT INTO zak_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Niho Petero akamenyeekererya gano gaamutuukiiri gaari ge eheene, akabhuga, “Bhoono nimenyiri kwe eheene kubha, Omukuru anitumiiri maraika waaye okubha anituurye okurwa mumabhoko ga Herode, no okurwa mubhubhi bhwoosi bhuno Abhayahudi bhakeenda kunikorera.” ");
INSERT INTO zak_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hano Petero yamenyiri gayo ego, akagya kimwekimwe wa Mariamu, nina waabhu Yohana, eriina ryaaye eriindi ni Mariko. Munyuumba yiyo, abhiikirirya bhaaru bhaari bhiikumeenie, bharamusabhira Petero ku Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Hano Petero yahikiri mukiseku kurubhago rwe enyuumba, akabhuga hanoo, omuukya wumwe omuhokya, eriina yaaye Rooda, akaaza okwiitegeerera kubha ni weewi. ");
INSERT INTO zak_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Hano yamenyeekereerye eriiraka rya Petero, akazomerwa bhukongʼu, akeebha okumwiigurira, akaryaara kusikira munyuumba, akabhabhuurira bhoosi, “Petero yiimeereeri mukiseku!” ");
INSERT INTO zak_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Neebho bhakamubhuurira, “Oyaangahiri!” Nawe omuukya wuyo akakumiirirya kubha eriiraka rino yiigwiiri ni rya Petero, niho ebho bhakabhuga, “Wuyo ni maraika waaye.” ");
INSERT INTO zak_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eriibhaga riyo ryoosi Petero ewe akabha arageenderera okubhuga hanoo. Hano bhiigwiiri ekiseku no okumurora, bhakaruguura bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petero akabheerekeererya kwo okubhoko bhakire, akabhabhuurira kyeego Omukuru akamuruusya munyuumba ya abhabhohwa. Niho akabhabhuurira, “Amangʼana gayo, mumubhuurire Yaakobo na abhahiiri bheetu abhaandi.” Kyaamwe Petero akahuruka hayo, akagya ahagiro ahaandi. ");
INSERT INTO zak_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Hano kwakiiri, abhasirikare bharya bhe enyuumba ya abhabhohwa bhakabha ne ehaha bhukongʼu iguru ya gano gaamutuukiiri Petero. ");
INSERT INTO zak_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herode akaswaagya abhasirikare bhaaye bhamukomye Petero, nawe ataarorekeeni. Kweego akabhabhuurya abhasirikare bhano bhaari bhakumuriibha Petero, hano bhaatamirwe okumukyoora, akaswaagya bhiitwe. Okumara Herode akarwa Yudea, akagya mumugye gwa Kaisaria, akiikara eyo siku suuhu. ");
INSERT INTO zak_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Omutemi Herode yaari abhatiindiiri bhukongʼu abhaatu bhe emigye gya Tiro na Sidooni. Kweego abhaatu bhe emigye ebhiri giyo, bhakiikiriryana kwa hamwe, bhakeenda kusikana nawe. Bhakasabha bhiikiriranie kwo omureembe, kwiiguru ye ebhyaaro bhyaabhu, kwo okwiisigira ebhyaakurya kurwa mukyaaro kyaaye. Abhaatu bhayo bhakabha bhiikiriryeenie na Burasito embere wa Herode. Burasito wuyo, niwe yaari omuutu wa haguhi na Herode, neewe yaari omwiimeerereri wa amangʼana gaaye. ");
INSERT INTO zak_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Orusiku runo omutemi Herode akarusora, akiibhoha emyeenda gyaaye gye ekitemi, akiikara kukituumbi kyaaye kyo obhutemi, akakeerenerya abhaatu. ");
INSERT INTO zak_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Abhaatu bhano bhaari bhiikumaniirye harya, bhakakora ekituri bharabhuga, “Rino ritari eriiraka ryo omuutu! Ni riiraka rye eriisaambwa!” ");
INSERT INTO zak_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hayohayo maraika wo Omukuru akamutema Herode haasi kwo okubha ataamuguungirye Taatabhugya. Kweego akariibhwa na amakoorimo muunda tee akakwa. ");
INSERT INTO zak_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nawe engʼana ya Taatabhugya ekageenderera kunyaragana mubhaatu, na abhiikirirya bhakaaruha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Hano Barinaaba na Sauri bhaamariri emirimo gyaabhu gyo okusakirya abhiikirirya bha mumugye gwa Yerusaremu, bhakamugega Yohana wuno akubhirikirwa Mariko, bhakakyoora nawe Antiokia. ");
INSERT INTO zak_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mumugye gwa Antiokia haari ne ekanisa yino yaari na abharooti na abheegya. Gati waabhu bhaari bharimu Barinaaba, Simioni wuno yakubhirikirwa Nigeri, obhugazuro bhwaku omuutu omumwaamu, Rukio okurwa Kirene, Manaeni wuno yaari akiiniiri hamwe no omutemi Herode Antipasi no owuundi yaari Sauri. ");
INSERT INTO zak_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hano bhaari bhakumusabha Omukuru no okwiisiitya ebhyaakurya, Ekoro Muhoreeru akabhabhuurira, “Munisorere Barinaaba na Sauri kumirimo gino nibhabhirikiriiri.” ");
INSERT INTO zak_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hano bhaamariri okumuseengera Taatabhugya no okwiisiitya ebhyaakurya, bhakabhatuurira Barinaaba na Sauri amabhoko iguru waabhu no okubhasabhira, bhakabhatiga bhagye. ");
INSERT INTO zak_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kweego Barinaaba na Sauri bhakatumwa ne Ekoro Muhoreeru. Bhakagya bhakiikira mumugye gwa Serukia, kurwa hayo bhakatiira emeeri, bhakagya mukigiinga kya Kipuro. ");
INSERT INTO zak_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na hano bhaahikiri mukigiinga kiyo, mumugye gwa Sarami, bhakataanga kurwaazira abhaatu engʼana ya Taatabhugya muziinyuumba zye eziisaango zya Abhayahudi. Neebho bhaari na Yohana, ne eriina eriindi arabhirikirwa Mariko, yaari omusakirya waabhu. ");
INSERT INTO zak_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Hano bhaahitiiri gatigati we ekigiinga kiyo kya Kipuro, bhakahika tee mumugye gwa Pafo. Mumugye hayo niho bhakasikana no Omuyahudi wumwe omurogi, omurooti wo orurimi, eriina ryaaye Bari-Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Omuutu wuno yaari hamwe no omwaanaangwa Serigio Pauro, omuutu wa amangʼeeni. Ewe omwaanaangwa wuyo akabhabhirikira Barinaaba na Sauri bhiize kweewe, kwo okubha akeenda yiigwe engʼana ya Taatabhugya kurweera kweebho. ");
INSERT INTO zak_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nawe Bari-Yeesu omurogi, eriina ryaaye rye Ekiyunaani ni Erima, yaari na amangʼana go okuhakania Barinaaba na Sauri, eno arasakya kumurekya omwaanaangwa wa mukigiinga wuyo atamwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Niho, Sauri eriina ryaaye eriindi arabhirikirwa Pauro, eno yiizwiiri Ekoro Muhoreeru, akamumogorera Erima, ");
INSERT INTO zak_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","akamubhuurira, “Awe omwaana wa Seetaani! Awe ni mubhisa wa goosi gano amazomu embere wa Taatabhugya! Wiizwiiri obhungʼeenererya, orabha orakaangirirya abhaandi! Otaageenderere okukyoora amangʼana ge eheene go Omukuru kubha orurimi? ");
INSERT INTO zak_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bhoono, itegeerera! Omukuru arakugororokerya okubhoko kwaaye akuteme, orabha omuhoku, otakurora kyokyoosi kwiibhaga.” Kyaamwe Erima, ekitu kikamwiizura mumeeso, akabha mukiirima atakurora. Akataanga kwiinogooranogoora kumoohya omuutu wuno araamugwaate okubhoko okubha amukaangate. ");
INSERT INTO zak_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Eriibhaga riyo omwaanaangwa wa mukigiinga wuyo akarora ekika kiyo, akamwiikirirya Omukuru. Kweeki, yaari araruguura bhukongʼu iguru wa ameegyo go Omukuru gano yiigwiiri. ");
INSERT INTO zak_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pauro na abharikyaaye bhakarwa Pafo. Bhakagya orugeendo mumeeri, bhakahikira omugye gwa Perige mukyaaro kya Pamufiria. Yohana akabhatiga hayo, akakyoora Yerusaremu. ");
INSERT INTO zak_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nawe Pauro na Barinaaba bhakabhuukira Perige, bhakageenderera no orugeendo, bhakahika mumugye gwa Antiokia mukyaaro kya Pisidia. Orusiku rwo okumuunya, bhakasikira munyuumba ye esaango, bhakiikara. ");
INSERT INTO zak_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Hano abhakuru bhe enyuumba ye esaango yiyo bhaamariri okusoma amangʼana agaandi okurwa mumigiro gya Musa na mubhitabhu bhya abharooti, bhakatuma omuutu ku Pauro na Barinaaba, akabhabhuurira, “Abhahiiri bheetu, eraabhe mune engʼana yo okubhatoongera ekoro abhaatu bhano, mugaambe.” ");
INSERT INTO zak_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Niho Pauro akiimeerera, akabheerekeererya kwo okubhoko kubha bhamwiitegeerere, akabhuga, “Emwe abhaatu bha Iziraeri, na neemwe abhaatu bhe ebhyaaro ebhiindi bhano mukumwiigwa Taatabhugya, muniitegeerere! ");
INSERT INTO zak_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Taatabhugya wa abhaatu bheetu bha Iziraeri niwe akasora bhazaazi bheetu. Kwiibhaga rino bhaari kwiikara kya abhagini mukyaaro kya Misiri, akabhakora kubha ekyaaro ekikuru bhukongʼu. Taatabhugya akabharuusya eyo kwo obhunagya bhwaaye obhukuru. ");
INSERT INTO zak_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Akabhiikongʼeererya kwe emyaaka miroongo ene (40) kukibhara. ");
INSERT INTO zak_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kyaamwe, akasikya ebhigaambo muhuungati mukyaaro kya Kanaani, akabhaha bhazaazi bheetu Abhiiziraeri ekyaaro kiyo kubha engabho yaabhu. ");
INSERT INTO zak_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gayo goosi gakakorwa kumyaaka magana ane na miroongo etaano (450) ego. “Okumara, Taatabhugya akabhaha bhazaazi bheetu abhataania kubhakaangata, tee hano omurooti Samweeri yabhakaangatiri. ");
INSERT INTO zak_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Niho bhakamusabha kubha, bhahaabhwe omutemi, na Taatabhugya akabhaha Sauri, omwaana wa Kishi, okurwa mukisyooko kya Benjamini, woosi akabha omutemi kwe emyaaka miroongo ene (40). ");
INSERT INTO zak_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Hano Taatabhugya yamariri okumuruusyaho Sauri, akamutuura Daudi kubha omutemi waabhu. Taatabhugya akabhuga iguru wa Daudi, ‘Nimuruuzi Daudi omwaana wa Yeese, omuutu wuyo akaanizomera, kweeki niwe araakore obhuseegi bhwaane bhwoosi.’ ");
INSERT INTO zak_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Okurwa muhamati ya Daudi nimwe Taatabhugya abhareteeri Abhiiziraeri Omutuurya Yeesu, kyeego yaari abharageenie. ");
INSERT INTO zak_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hano Yeesu yaari akyaari kutaanga emirimo gyaaye, Yohana yaari arabharwaazira Abhiiziraeri bhoosi kubha bhate ebhibhi bhyaabhu na bhabatiizwe. ");
INSERT INTO zak_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Hano Yohana yaari haguhi kumara emirimo gyaaye, akabhuga, ‘Muriisiga enye ni weewi? Enye nitari wurya Krisito wuno mukumuganyirira! Mwiitegeerere! Wuno araaze inyuma waane, enye nitakweenderwa naabhe kutazura eziikobha zye ebhikweera bhyaaye!’ ");
INSERT INTO zak_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abhahiiri bhaane, emwe abhaatu bhe ehamati ya Aburahamu na neemwe abhaatu bhano bhatari Abhayahudi bhano mukumwiigwa Taatabhugya, amangʼana go obhutuurya gareetirwe okurwa ku Taatabhugya! ");
INSERT INTO zak_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Abhaatu bha Yerusaremu na abhakaangati bhaabhu bhataamumenyeekereerye kubha Yeesu niwe wurya abharooti bhaamugaambiiri iguru waaye. Nawe bhakamutinira ekiina kyo okwiitwa, na kwo okukora ego bhakamara amangʼana go obhurooti gano gakusomwa eziisiku zyoosi zyo okumuunya. ");
INSERT INTO zak_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yiingabha bhataabheeri na amasemo gogoosi go obhuheene gano gakweerekya kubha Yeesu areenderwa yiitwe, bhakamusabha Pirato aswaagye Yeesu yiitwe. ");
INSERT INTO zak_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Hano bhaamariri goosi gano gakaamirwe iguru wa Yeesu, bhakamwiikya okurwa kumusaraba, bhakamubhiika mumbiihira. ");
INSERT INTO zak_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nawe Taatabhugya akamuryoora okurwa mubhaku! ");
INSERT INTO zak_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kwa siku nzaru, Yeesu akabha arabhahwaarukira abhaatu bhano bhaari bhakumutuniirira hano bhaari bhakurwa Gariraaya, kugya Yerusaremu. Bhoono nibho abhamenyeekererya kubhaatu bha Iziraeri. ");
INSERT INTO zak_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Na neetwe turabharwaazira Amangʼana Amazomu, gano Taatabhugya yarageenie bhazaazi bheetu, ");
INSERT INTO zak_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","agamariri kweetwe, etwe abhaana bhaabhu, kwo okumuryoora Yeesu kurwa mubhaku. Kyeego yaari ekaamirwe mu Zaburi ya kabhiri, ‘Awe ni Mwaana waane, reero niho nibharaarikiiri kubha awe ni mwaana waane.’ ");
INSERT INTO zak_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Taatabhugya akamuryoora Yeesu okurwa mubhaku, okubha atakyoora mubhusarya, akagaamba amangʼana gano, ‘Ndakuha awe orubhaango rwe eheene runo niamurageenie Daudi.’ ");
INSERT INTO zak_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kweeki, engʼana yiyo ekaamirwe ahagiro ahaandi, ‘No otakwiikirirya omubhiri gwo Omuhoreeru waazo gubhore.’ ");
INSERT INTO zak_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Hano Daudi yamariri kukora gano Taatabhugya yaari amweendeeri kwo orwiibhuro rwaaye, akakwa, akabhiikwa haguhi na bhazaazi bhaaye, omubhiri gwaaye gukabhora. ");
INSERT INTO zak_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nawe wurya Taatabhugya akamuryoora kurwa mubhaku, ewe ataabhoriri. ");
INSERT INTO zak_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Bhoono abhahiiri bhaane, ndeenda mumenye kubha, kwo okuhitira ku Yeesu wuyo okwaabhirwa ebhibhi bhyeenyu kuraarikirwe kweemwe. ");
INSERT INTO zak_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kwo okuhitira kweewe, abhaatu bhoosi bhano bhakumwiikirirya, bharabharirwa kubha bhe eheene embere wa Taatabhugya, engʼana yino etakuturikana kweemwe kwo okutuniirira emigiro gya Musa. ");
INSERT INTO zak_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kweego mwiiriihe kisi okubha mutaaza mukabhonwa na amangʼana gano gaagaambwa na abharooti, ");
INSERT INTO zak_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mwiitegeerere, emwe abhazeeri bha amangʼana! Muruguure, kweeki musike, kwo okubha ndakora kwiibhaga ryeenyu rino, ekigiro kino mutakuuza kukiikirirya yiingabha omuutu araaze abhabhuurire!’” ");
INSERT INTO zak_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Hano Pauro na Barinaaba bhaari bharahuruka munyuumba ye esaango, abhaatu bhakabhiisasaama bhakyoore kurusiku rwo okumuunya runo rukuuza, okubha bhagaambe iguru wa amangʼana gayo kweeki. ");
INSERT INTO zak_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Hano bhaari bharanyaragana munyuumba ye esaango kugya yiika, Abhayahudi bhaaru, hamwe na abhaatu bhe ebhyaaro ebhiindi bhano bhiikiriirye enyaangi ye Ekiyahudi, bhakabhatuniirira Pauro na Barinaaba. Abheega bhayo bhakabha bharakeerenia nabho amakeerenio amazomu go okutoongera ekoro kwo okugeendererya murubhaango rwa Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Nyamuunga abhaatu bhoosi bho omugye guyo bhakaaza kurusiku rwo okumuunya okwiitegeerera Amangʼana iguru wo Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nawe hano abhakaangati bha Abhayahudi bhaaruuzi kubha abhaatu bhaaru bhukongʼu bhiikumeenie kubhiitegeerera abheega bhayo, bhakabha no omugono bhukongʼu. Niho bhakabha bharahakana na Pauro no okumutuka. ");
INSERT INTO zak_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Naabhe, Pauro na Barinaaba bhakakeerenia kwo obhukaari bhakabhuga, “Ekeenderwa tutaange kugaambana na neemwe Abhayahudi engʼana ya Taatabhugya. Nawe kwo okubha mugaangiri, muriitinira ekiina abheene kubha mutaari kweenderwa okubhona obhuhoru bhwa kirakeego, kweego turagya kurwaazira abhaatu bhano bhatari Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwo okubha Omukuru, Taatabhugya atuswaagirye kubha, ‘Nikutuuriri obhe no obhweero kubhaatu bhano bhatari Abhayahudi, okubha abhaatu bhoosi bharanagya kutuuribhwa tee kubhuteero bhwe ekyaaro.’” ");
INSERT INTO zak_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hano abhaatu bhano bhatari Abhayahudi bhiigwiiri amangʼana gayo, bhakazomererwa, bhakabha bharakumya Amangʼana iguru wo Omukuru Yeesu. Neebho bhoosi bhano bhaari bheendirwe kubha no obhuhoru bhwa kirakeego bhakamwiikirirya Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Amangʼana iguru wo Omukuru Yeesu gakanyaragana mukyaaro kiyo kyoosi. ");
INSERT INTO zak_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nawe Abhayahudi bhakasiigirirya abhakari bha amangʼeeni bhano bhakumwiikirirya Taatabhugya, na abhakaangati bho omugye guyo. Nabho bharasiigirirya abhaatu abhaandi kubhanyaakya Pauro na Barinaaba, no okubhaheebha okurwa mumigye gyaabhu. ");
INSERT INTO zak_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kweego Pauro na Barinaaba bhakakungʼuuta oruteeri kumaguru gaabhu okweerekya ekyeerekenio kubha bhate ebhibhi bhyaabhu. Niho bhakabhuuka bhakagya mumugye gwa Ikonio. ");
INSERT INTO zak_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na abhaanabheega bha Yeesu bha Antiokia bhakazomererwa bhukongʼu, bhakabha bhiizuriibhwe Ekoro Muhoreeru. ");
INSERT INTO zak_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hano Pauro na Barinaaba bhaari Ikonio, bhakasikira munyuumba ye esaango ya Abhayahudi, kyeego yaari enyaangi yaabhu. Bhakeegya abhaatu iguru wa Yeesu kwo obhukaari, ekagirya Abhayahudi bhaaru hamwe na abhaatu bhaaru bhano bhatari Abhayahudi bhakamwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nawe Abhayahudi abhaandi bhakaanga kumwiikirirya Yeesu, bhakataanga kubhasiigirirya abhaatu bhano bhatari Abhayahudi, okubha bhabhatiindire abhiikirirya bhayo. ");
INSERT INTO zak_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pauro na Barinaaba bhakageenderera kwiikara Ikonio hayo kwa siku nzaru, bharakeerenerya abhaatu kwo obhukaari iguru yo orubhaango rwo Omukuru Yeesu. Neewe Yeesu akabhamenyeekererya kwo okubheerekya ebhiruguuro ne ebhyeerekenio kwa amabhoko gaabhu. ");
INSERT INTO zak_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nawe abhaatu bho omugye gurya bhakatwaanikana magara abhiri. Abhaandi bhakiikirirya no okugwaatana na Abhayahudi, na abhaandi bhakagwaatana na abheega. ");
INSERT INTO zak_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kubhuteero, Abhayahudi na abhaatu bhano bhatari Abhayahudi bhakagwaatana na abhakaangati bhaabhu, bhakakora omukoonyo gwo okubhakorera amabhi no okubhatema Pauro na Barinaaba kwa amagina. ");
INSERT INTO zak_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nawe abheega hano bhaangʼuriri amangʼana gayo, bhakaryaarira mukyaaro kya Rikaonia, kumigye gya Risitura na Deribe ne emigye egiindi gye embarika hayo. ");
INSERT INTO zak_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Hano bhaari eyo, bhakabha bharabharwaazira abhaatu Amangʼana Amazomu iguru wo Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mumugye gwa Risitura, yaari ariho omuutu wumwe eriigata kweema okwiibhurwa kwaaye, ataari aranagya kugeenda. ");
INSERT INTO zak_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Omuutu wuyo yaari aramwiitegeerera Pauro hano yaari kugaamba. Pauro akamumogorera, akamurora kubha yaari no obhwiikirirya bhwo okuhoribhwa. ");
INSERT INTO zak_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kweego Pauro akamugaambira kwiiraka ikuru, “Bhuuka! Wiimeerere kisi kwa amaguru gaazo.” Kyaamwe omuutu wuyo akiimeerera bhwaangu, akataanga okugeenda omweene! ");
INSERT INTO zak_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Hano esaango ya abhaatu bhaakoriri kyeego Pauro akamuhorya omuutu wuyo, bhakataanga kugaamba kwiiraka ikuru rye Ekirikaonia, bharabhuga, “Emisaambwa gitwiikiiri kutuubho ya abhaatu!” ");
INSERT INTO zak_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bhakamuhaana Barinaaba eriina rye eriisaambwa eriikuru Zeu. Na Pauro, bhakamuhaana eriina rye eriisaambwa ryaabhu eriindi Herime, kwo okubha Pauro niwe yaari kugaamba bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ne eriiseengerero rya Zeu ryaari igutu wo omugye guyo. Niho omuseengeri wa Zeu akareeta egeeni, no orusuurya rwe ebhibharyo tee mukiseku. Ewe hamwe na abhaatu bhayo bhakeenda kubharuusirya ekimweeso Pauro na Barinaaba. ");
INSERT INTO zak_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nawe, Barinaaba na Pauro hano bhakiigwa amangʼana gayo, bhakaraandura emyeenda gyaabhu kwo obhururu, bhakaryaara, bhakasikira musaango yiyo, bhakabhabhuurira kwe eriiraka ikuru, ");
INSERT INTO zak_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Emwe abhaatu bhano! Ndora murakora amangʼana gano? Neetwe ni bhaatu kye emwe! Turi hano okubharwaazira Amangʼana Amazomu kubha, mutige kwiisasaama emisaambwa giyo gitana bhweera, mutaange mumwiikyoorere Taatabhugya wuno ari muhoru! Ewe niwe akateema ekyaaro, eriisaaro, enyaanza ne ebhigiro bhyoosi bhyamu. ");
INSERT INTO zak_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Eziisiku zino zyahitiri, Taatabhugya akabhatiga abhaatu bhano bhatari Abhayahudi bhiikare no okukora kyeego bhakweenda. ");
INSERT INTO zak_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Naabhe ego Taatabhugya ataatigiri okwiiyeerekya kweemwe no okukora amazomu kwo okubhatweekera embura okurwa mwiisaaro okubha mubhone amagesa no okwiiguta ebhyaakurya ne eziikoro zyeenyu okuzomererwa.” ");
INSERT INTO zak_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yiingabha Pauro na Barinaaba bhakagaamba amangʼana gayo, kwaari kukongʼu kweebho kubharekya abhaatu bhe esaango yiyo bhatabharuusirya ekimweeso. ");
INSERT INTO zak_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nawe bhakaaza Abhayahudi abhaandi okurwa Antiokia ya Pisidia na Ikonio, bhakabhakaangirirya abhaatu bha musaango yirya bhabhe hamwe nabho. Niho bhoosi bhakataanga kumutema Pauro kwa amagina tee hano bhiiseegiri kubha akuuri, bhakamukurura tee habhoori wo omugye. ");
INSERT INTO zak_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nawe hano abhaanabheega bhiikumeenie no okumwiinogoora, akabhuuka, akakyoora mumugye. Na tabhoori yaho, akarwa hayo, bhakagya hamwe na Barinaaba mumugye gwa Deribe. ");
INSERT INTO zak_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pauro na Barinaaba, hano bhaari Deribe, bhaari bharabharwaazira abhaatu Amangʼana Amazomu ga Yeesu, no okubhakora bhabhe abhaanabheega. Okumara bhakakyoora okugya okuhitira Risitura, Ikonio na Antiokia ya Pisidia. ");
INSERT INTO zak_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kwa ahagiro hoosi, bharakongʼeererya abhaanabheega, na bhaari bharabhakumiirirya kubha, bhageenderere kwiikirirya amangʼana goosi go obhwiikirirya bhwaabhu. Na bhaari bharabhabhuurira, “Etwe twoosi tureenderwa tuhitire munyaako nzaru, okubha tusikire mubhutemi bhwa Taatabhugya.” ");
INSERT INTO zak_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pauro na Barinaaba bhaari bharabhasorera abhakaruka kurwa mumakanisa goosi. Kwo okusabha no okwiisiitya ebhyaakurya, bhakabhatuura mumabhoko go Omukuru Yeesu, wuno bhakamwiikirirya. ");
INSERT INTO zak_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Okumara Pauro na Barinaaba bhakahitira ekyaaro kiyo kya Pisidia, bhakasikira mukyaaro kya Pamufiria, ");
INSERT INTO zak_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","na bhakahika omugye gwa Perige. Bhakarwaaza eyo Amangʼana gayo ga Taatabhugya, kyaamwe bhakiitumira mumugye gwa Ataria. ");
INSERT INTO zak_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Okurwa hayo bhakagya orugeendo kwe emeeri, bhakakyoora mumugye gwa Antiokia ya Siria. Hayo niho abhiikirirya bhe ekanisa bhaari bhabhatuuriri kwo orubhaango rwa Taatabhugya kwiiguru ye emirimo gino bhaari bhagimariri. ");
INSERT INTO zak_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hano bhaahikiri kweeki Antiokia, bhakabhakumania abhaatu bhe ekanisa. Na bhakabhabhuurira goosi gano Taatabhugya yakoriri okuhitira kweebho, na kyeego akabhiigurira abhaatu bhano bhatari Abhayahudi ekiseku kyo okumwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhakiikara kwiibhaga itaambi hayo Antiokia hamwe na abhaanabheega bhayo. ");
INSERT INTO zak_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Abhaatu abharebhe bhakiikira Yudea, okugya mumugye gwa Antiokia ya Siria. Neebho bhakataanga okweegya abhiikirirya bharabhuga, “Eraabhe mutakusaarwa kuriingʼaana ne enyaangi yino Musa yatutigiiri, mutakunagya kutuuribhwa.” ");
INSERT INTO zak_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Engʼana yiyo ekakora Pauro na Barinaaba bhahakane na abhaatu bhayo, no okugaambana nabho kwo obhuhaari bhukongʼu. Mubhuteero Pauro na Barinaaba na abhaatu gati waabhu, bhakasorwa bhatiire okugya Yerusaremu okubha bhakeerenerye eriingʼana riyo kubhakaruka na abheega. ");
INSERT INTO zak_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Abhaatu bhe ekanisa bhakabharaga, niho bhakahita ebhyaaro bhya Foinike na Samaria, bhakabhuurira abhaatu bhe eyo iguru ya kyeego abhaatu bhano bhatari Abhayahudi bhamwiikiriirye Yeesu. Amangʼana gayo gakabhazomera bhukongʼu abhiikirirya bhoosi. ");
INSERT INTO zak_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hano Pauro na abharikyaaye bhaahikiri Yerusaremu, bhakaginihwa kisi na abheega bha Yeesu, abhakaruka bhe ekanisa hamwe na abhaatu abhaandi bhe ekanisa. Bhakataanga kubhabhuurira garya goosi gano Taatabhugya yakoriri kwo okuhitira kweebho. ");
INSERT INTO zak_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nawe abhiikirirya abharebhe bhe enyaangi ya Abhafarisayo bhakiimeerera, bhakabhuga, “Abhaatu bhano bhatari Abhayahudi bhareenderwa bhasaarwe, bhabhuurirwe kubha bhiigwe emigiro gyoosi gya Musa.” ");
INSERT INTO zak_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Abheega bha Yeesu na abhakaruka bhayo bhakakora ekiina kubha, bhiisuunze kisi engʼana yiyo. ");
INSERT INTO zak_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hano bhaari kukeerenia kwiibhaga itaambi no okuhakana nabho, Petero akiimeerera, akabhabhuurira, “Emwe abhahiiri bheetu, mumenyiri kubha kurwa ekare hayo Taatabhugya akaanisora gati weenyu, okubha abhaatu bhano bhatari Abhayahudi bhabhone kuzweenibhwa Amangʼana Amazomu kwo okuhitira kweenye, tee bhamwiikiriirye. ");
INSERT INTO zak_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Taatabhugya ewe amenyiri goosi gano gari muziikoro zya abhaatu, akamenyeekererya kubha abhiikiriirye kwo okubhaha Ekoro Muhoreeru, kyeego yatuheeri etwe. ");
INSERT INTO zak_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kweego bhutariho obhwaahuri bhuno Taatabhugya yakoriri gati weetu na bharya, niho akeerya eziikoro zyaabhu kwe enzira yo okumwiikirirya Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ambe bhoono, kwaki muramusakya Taatabhugya kwo okubhagegya abhaanabheega emirigo gino gikututama etwe ebheene, naabhe na bhazaazi bheetu gikabhatama? ");
INSERT INTO zak_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nawe etwe turiikirirya kubha turatuuribhwa kwo orubhaango rwo Omukuru weetu Yeesu Krisito, ni kyeego ebho bhoosi bhakutuuribhwa.” ");
INSERT INTO zak_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ambe, esaango yoosi ya abhaatu ekabha kiri, bharabhiitegeerera Barinaaba na Pauro bharabhabhuurira, kyeego Taatabhugya okuhitira kweebho akakora ebhyeerekenio ne ebhiruguuro bhyoosi bhino yeerekirye gati wa abhaatu bhano bhatari Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hano bhaamariri kukeerenia, Yaakobo woosi akabhuga, “Emwe abhahiiri bhaane, muniitegeerere! ");
INSERT INTO zak_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simooni atubhuuriiri kyeego Taatabhugya yaabhasakiirye okusora abhaatu bhano bhatari Abhayahudi, bhabhe abhaatu bhaaye. ");
INSERT INTO zak_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Eriingʼana riyo riratuuka kumangʼana ga abharooti kyeego gakaamirwe mu Makaamo Amahoreeru, ");
INSERT INTO zak_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Amangʼana gayo hano garaahwe, ndakyoora, nioomboke bhuhya enyuumba ya Daudi yino yagwiiri. Ndoomboka enyuumba yiyo, yino yaari ituturi, ndiimeererya bhuhya, ");
INSERT INTO zak_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","okubha abhaatu bhano bhatari Abhayahudi bhaanikomye, bhoosi bhano nibhabhirikiiri bhabhe abhaatu abhaane. ");
INSERT INTO zak_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Omukuru, Taatabhugya akabhazweenia amangʼana gayo kweema ekare.’” ");
INSERT INTO zak_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yaakobo akageenderera kubhuga, “Amiiseego gaane ni kubha, tutabhanyaakya abhaatu bhano bhatari Abhayahudi, bhano bhakumwiikyoorera Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nawe, tureenderwa tubhakaamire eziinyaarubha zyo okubhabhuurira, bhatarya ebhyaakurya bhino bhikuruusibhwa kumisaambwa gyo okubhaazwa, bhatabha bharakora obhuseebheeti, bhatabha bhararya enyama yino egubhirwe, na bhatabha bhararya amanyiinga. ");
INSERT INTO zak_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tukabhabhuurira gayo kwo okubha kweema ekare, emigiro gya Musa gyaari gireegibhwa emigye gyoosi, no okusomwa muziinyuumba zye eziisaango zya Abhayahudi muziisiku zyoosi zyo okumuunya.” ");
INSERT INTO zak_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Abheega na abhakaruka, hamwe na abhiikirirya bhoosi bha Yerusaremu, bhakiikirirania bhasore abhaatu abharebhe bhano bharaagye hamwe na Pauro na Barinaaba mumugye gwa Antiokia ya Siria. Kweego, gati waabhu bhakasora abhakaangati bhabhiri, Yuuda wuno akubhirikirwa Barisaaba, hamwe na Siira. Ebho bhakatumwa no okuhaabhwa enyaarubha yino ekubhuga, ");
INSERT INTO zak_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","“Etwe abheega na abhakaruka bhe ekanisa, etwe abhiikirirya abharikyeenyu, turabhakeerya emwe bhano mutari Abhayahudi muri mumugye gwa Antiokia, mubhyaaro bhya Siria na Kirikia. Mwaareeri! ");
INSERT INTO zak_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Twiigwiiri kubha abharikyeetu bhakaaza, nawe bhataari na rugusa rweetu, bhabhanyaakirye mumiiseego geenyu kwo okubhabhuurira amangʼana go okubhatubhuuzikania. ");
INSERT INTO zak_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kweego, tukiikirirania kubha tusore abhaatu no okubhatuma kweemwe, bhiize hamwe na abhaseegwa bheetu Barinaaba na Pauro. ");
INSERT INTO zak_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Na abhabhiri bhayo, bhakaruusya obhwiikari bhwaabhu munyaako, kwiiguru yo okumuhokeerya Omukuru weetu Yeesu Krisito. ");
INSERT INTO zak_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Kweego, bhano tubhatumiri kweemwe ni Yuuda na Siira, ebho nibho bharabhagaraanzurira amangʼana gano tubhakaamiiri. ");
INSERT INTO zak_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ambe, Ekoro Muhoreeru na neetwe turuuzi kisi kubha tutabhagegya emirigo egiindi emirito, kukira amangʼana amakuru gano. ");
INSERT INTO zak_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Mutarya ebhyaakurya bhino bhikuruusibhwa kumisaambwa gyo okubhaazwa, na mutabha murarya amanyiinga, naabhe enyama yino bhagubhiri, na mutige kukora obhuseebheeti. Hano mukubha mutigiri gayo, niho mukubha mukoriri kisi. Mubhe no omureembe.” ");
INSERT INTO zak_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Okumara, bhakaraga, bhakiituuma kugya mumugye gwa Antiokia. Bhakakumania abhiikirirya bhoosi, bhakabhaha enyaarubha yiyo. ");
INSERT INTO zak_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Abhiikirirya bhayo hano bhaasomiri enyaarubha yiyo, bhakazomererwa bhukongʼu, kumangʼana go obhutoongeri gayo. ");
INSERT INTO zak_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuuda na Siira ebho bhaari abharooti, kweego bhakabhabhuurira abhiikirirya abharikyaabhu amangʼana go obhutoongeri no okubhaha amanaga. ");
INSERT INTO zak_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Hano bhaamariri kwiikara Antiokia kwiibhaga, abhiikirirya bhe eyo bhakeenderwa bhakyoore Yerusaremu kwo omureembe, kubhano bhaari bhabhatumiri.  ");
INSERT INTO zak_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nawe Siira ewe akarora kubha ni kisi atame eyo. ");
INSERT INTO zak_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nawe Pauro na Barinaaba bhakasaaga Antiokia, hamwe na abhaatu abhaandi bhe eyo, bhakabha bhararwaazira abhaatu Amangʼana iguru wo Omukuru Yeesu. ");
INSERT INTO zak_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Hano eziisiku suuhu zyahitiri, Pauro akamubhuurira Barinaaba, “Tukyoore mumigye girya gino tukeegya Amangʼana iguru wo Omukuru Yeesu, tubhataarire abhiikirirya abharikyeetu turore kyeego amageendereryo gaabhu gari.” ");
INSERT INTO zak_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barinaaba akeenda bhamugege Yohana wuno akubhirikirwa Mariko, bhagye nawe. ");
INSERT INTO zak_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nawe Pauro ataaseegiri kumugega Yohana Mariko, kwo okubha akabha abhatigiri hano bhaari Pamufiria, ateendiri kweenderera kukora nabho emirimo hamwe. ");
INSERT INTO zak_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ambe, gayo gakagirya bhaange kwiigwaana, kweego bhakatwaanikana. Barinaaba akamugega Yohana Mariko bhakagya hamwe mumeeri tee bhakahika mukigiinga kya Kipuro. ");
INSERT INTO zak_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pauro ewe akamugega Siira. Niho abhiikirirya abharikyaabhu bhakabhasabhira no okubhatuura mumabhoko go Omukuru, kyaamwe bhakatanura. ");
INSERT INTO zak_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bhakahita mubhyaaro bhya Siria na Kirikia, bhakabha bharabhoongerya amanaga abhaatu bha amakanisa. ");
INSERT INTO zak_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauro akagya mumugye gwa Deribe na Risitura. Na Risitura eyo yaari ariyo omwaanamweega wumwe wa Yeesu, eriina ryaaye ni Timoteo. Nina waabhu yaari Muyahudi wuno amwiikiriirye Yeesu, nawe wiise waabhu yaari Omuyunaani. ");
INSERT INTO zak_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoteo yaari no obhukumya obhukuru gati wa abhiikirirya abharikyaaye bha Risitura na Ikonio. ");
INSERT INTO zak_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauro akeenda bhagye orugeendo ruyo hamwe na Timoteo, niho akaamura Timoteo asaarwe, kwo okubha Abhayahudi bhe eyo bhaari bhamenyiri kubha wiise waabhu yaari Omuyunaani. ");
INSERT INTO zak_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ambe, Pauro na abharikyaaye hano bhaari kuhita mumigye giyo, bhakabha bharabhaha abhiikirirya ameegyo gano gateerwe na abheega bha Yeesu na abhakaruka bhe ekanisa ya Yerusaremu, okubha bhabhe bhariigwa ameegyo gayo. ");
INSERT INTO zak_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kweego, abhaatu bha amakanisa ge eyo bhakageenderera kukongʼa kwo obhwiikirirya, no obhwaaru bhwa abhiikirirya bhwaari bhuroongerwaho eziisiku zyoosi. ");
INSERT INTO zak_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pauro na abharikyaaye bhayo, bhakahita mukyaaro kya Furigia na Garatia, kwo okubha bhaari bharekiibhwe ne Ekoro Muhoreeru kubha, bhateegya engʼana ya Taatabhugya mumugye gwa Asia. ");
INSERT INTO zak_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hano bhaahikiri kumiimbi ye ekyaaro kya Misia, bhakasakya okusikira mukyaaro kya Bitinia, nawe Ekoro wa Yeesu etaabhiikiriirye. ");
INSERT INTO zak_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kweego, bhakahita mukyaaro kiyo kya Misia, bhakahiriingita mumugye gwa Turoa. ");
INSERT INTO zak_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Obhutiku bhuyo Pauro akarora obhurori. Mubhurori bhuyo akarora omuutu wumwe wa Makedonia yiimeereeri aramwiisasaama arabhuga, “Yaambuka enyaanza wuuze otusakirye Makedonia eno.” ");
INSERT INTO zak_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Rugeendo rumwe Pauro hano yamariri kurora obhurori bhuyo, tukabhanura okugya Makedonia, kwo okubha turuuzi Taatabhugya atubhirikiiri tugye turwaaze Amangʼana Amazomu kubhaatu bhe eyo. ");
INSERT INTO zak_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kweego tukahuruka hayo Turoa ne emeeri, tukagya kimwekimwe tee mukigiinga kya Samotirake. Hano kwakiiri, tukahika mumugye gwa Neapori. ");
INSERT INTO zak_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Okurwa hayo, tukagya tee mumugye gwa Firipi, nigwo omugye omukuru mukyaaro kya Makedonia, na nigwo omugye gwa Abharooma. Tukiikara mumugye gurya eziisiku suuhu. ");
INSERT INTO zak_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Orusiku rwo okumuunya tukagya habhoori wo omugye guyo, haguhi ne ekitaaro, kwo okwiisiga kubha niho tuungabhweeni abhaatu bharamusabha Taatabhugya. Tukiikara, tukakeerenia na abhakari bhano bhaari bhiikumaniirye harya. ");
INSERT INTO zak_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gati ya abhakari bhayo yaarimu omukari wumwe eriina ryaaye niwe Ridia. Ridia wuyo, yaari omusuruzya we emyeenda emizomu gye ezambaraau, omwiikari wa mumugye gwa Tiatira, na yaari aramwiigwa Taatabhugya. Hano Pauro yaabhazweenirye Amangʼana Amazomu, Omukuru akiigura ekoro ya Ridia tee akiikirirya Amangʼana Amazomu. ");
INSERT INTO zak_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Niho akabatiizwa hamwe na abhaatu bhe enyuumba yaaye, akatwiisasaama akabhuga, “Eraabhe heene muniruuzi enye ndamwiikirirya Omukuru, musikire owaane mwiikare.” Akatukumiirirya bhukongʼu tugye owaaye. ");
INSERT INTO zak_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Orusiku rumwe, hano twaari tukugya ahagiro ho okumuseengera Taatabhugya, tukasikana no omuukya wumwe omuhokya. Omuukya wuyo yaari ne eriisaambwa eriibhi ryo okurora obhurori bhuno bhukuuza. Kwe enzira yiyo, abhaniibhi bhaaye bhaari bharabhona eziimbirya nzaru. ");
INSERT INTO zak_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Omuukya wuyo, akabha aratutuniirira etwe na Pauro, aratema ekituri arabhuga, “Abhaatu bhano ni bhagya bha Taatabhugya Wuno Ari Iguru we Ebhigiro Bhyoosi na bhararwaazira enzira yo okutuuribhwa!” ");
INSERT INTO zak_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Akabha aragaamba amangʼana gayo kwo okukwiinuuryamu kwe eziisiku nzaru. Ekagirya Pauro akatiinda bhukongʼu. Akiikyoora inyuma no okuribhuurira eriisaambwa eriibhi rino riri muusi wo omuukya wuyo, “Ndakubhuurira kwe eriina rya Yeesu Krisito, orwe kumuukya wuno!” Kyaamwe eriisaambwa riyo rikarwa hayohayo kurwa kumuukya wuyo. ");
INSERT INTO zak_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Hano abhaniibhi bho omuukya wuyo bhaaruuzi kubha etariho enzira eyiindi yino bharaabhe bharabhona eziimbirya, bhakabhatuumira Pauro na Siira, bhakabharuta tee mumuteera embere ya abhakaangati bho omugye. ");
INSERT INTO zak_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hano bhaabhahikirye kubhakaangati bha Abharooma, bhakabhuga, “Abhaatu bhano ni Bhayahudi, neebho bhagirirye omugye gweetu gubhe no orwaambi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eno bhareegya enyaangi yo owaabhu yino tutakweenderwa okuyiikirirya, kwo okubha ni mugiro etwe Abharooma okuyikora.” ");
INSERT INTO zak_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kyaamwe, abhaatu bhano bhaari bhiikumeenie hayo bhakagya no obhururu bhakabharwaania Pauro na Siira. Na abhakaangati bharya bhakabharuusya emyeenda gyaabhu kwa nguru, bhakabhuga bhatemwe eziihiimbo bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hano bhaamariri kubhatema, bhakabhatuura munyuumba ya abhabhohwa. Abhakaangati bhayo bhakamukumiirirya omuriibhi we enyuumba ya abhabhohwa kubha abhariibhe kisi. ");
INSERT INTO zak_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Omukuru wa abhabhohwa, hano yabhweeni obhuswaagibhwa, akabhasikirya mukyuumba kya muusi gatigati, akabhasibhika eminyororo kumaguru gaabhu kwiitimu. ");
INSERT INTO zak_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Hano obhutiku bhwaahikiri gati, Pauro na Siira bhaari bharamusabha no okumweembera Taatabhugya ameembo go okumukumya. Abhabhohwa abharikyaabhu bhaari bharabhiitegeerera. ");
INSERT INTO zak_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kituukiro ekirigito ekikuru bhukongʼu kikahita mukyaaro, kikarigitya obhurusa bhwe enyuumba ya abhabhohwa yiyo, tee ebhiseku bhyoosi bhikiiguka ebhyeene, ne eminyororo gyoosi gino bhaabhoheerwe abhabhohwa bhayo, gikatazuka. ");
INSERT INTO zak_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Omuriibhi we enyuumba ya abhabhohwa akabhuuka, akarora ebhiseku bhiigukiri na hari mwaasi, akasohora nyaambato yaaye akeenda okwiiyiita, kwo okubha yaari ariiseega abhabhohwa bhayo bhoosi bhatorokiri. ");
INSERT INTO zak_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nawe Pauro akatema ekituri akamubhuurira, “Otiiyiita! Abhabhohwa bhoosi turi muno!” ");
INSERT INTO zak_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Hayo omuriibhi wuyo akatumania eziitara zireetwe. Hano eziitara zareetirwe, akasikira munyuumba yiyo, akiirekera embere wa Pauro na Siira eno ararigita. ");
INSERT INTO zak_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Okumara akabhahurukya habhoori no okubhabhuurya, “Bhamure abhakuru bhaane, ndeenderwa nikorebhwi nibhone obhutuurya?” ");
INSERT INTO zak_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bhakamukyoora, “Omwiikirirye Omukuru Yeesu, awe na abhaatu bhano bhari munyuumba yaazo, niho muraatuuribhwe.” ");
INSERT INTO zak_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Okumara Pauro na Siira bhakamweegya Amangʼana iguru wo Omukuru, ewe hamwe na abhaatu bhoosi bhano bhaari munyuumba yaaye. ");
INSERT INTO zak_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Obhutiku bhuryabhurya, omuriibhi wuyo akabhoogya Pauro na Siira ebhigaati bhyaabhu, niho akabatiizwa hamwe na abhaatu bhaaye bhoosi. ");
INSERT INTO zak_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Okumara akabhahira Pauro na Siira owaaye, akabhaginihya ebhyaakurya. Akazomererwa bhukongʼu hamwe na abhaatu bhaaye bhoosi, kwo okubha bhaari bhamwiikiriirye Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Hano kwakiiri, abhakaangati bhayo bhakatuma abhakuru bha abhasirikare kumuriibhi wuyo we enyuumba ya abhabhohwa, okubha bhamubhuurire, “Mubhatazure abhaatu bhayo.” ");
INSERT INTO zak_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Omuriibhi wuyo hano yaari abhuuriirwe gayo, akamubhuurira Pauro, “Abhakaangati bhatumeenie amangʼana kubha nibhiigurire, murwe igutu, mugye kwo omureembe.” ");
INSERT INTO zak_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nawe Pauro akabhabhuurira abhasirikare bhayo, akabhuga, “Ndora bhakatutema bhukongʼu embere wa abhaatu naabhe bhataatuzoongeeri no okutubhuurya, neebho bhakaturekera munyuumba ya abhabhohwa, yiingabha etwe ni Bharooma. Neebho bhoono bhareenda kuturuusya muno kwa bhwiibhisi? Etakuturikana! Ebho bhaaze abheene bhaturuusye mukibhoho muno.” ");
INSERT INTO zak_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abhasirikare bhayo bhakakyoora no okubhabhuurira abhakaangati gayo goosi. Abhakaangati bhayo, hano bhakiigwa kubha Pauro na Siira ni Bharooma, bhakahaha bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bhakaaza mukibhoho kubhiisasaama, bhakabharuusya munyuumba yiyo ya abhabhohwa, bhakabhasabha kubha bharwe mumugye gwaabhu. ");
INSERT INTO zak_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Hano Pauro na Siira bhaahurukiri munyuumba ya abhabhohwa, bhakagya ku Ridia. Bhakasikana na abhiikirirya abharikyaabhu, bhakatoongera no okubhaha amanaga, niho bhakagya. ");
INSERT INTO zak_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pauro na Siira bhakahita mumigye gya Amufipori na Aporonia, tee bhakahika mumugye gwa Tesaronike. Tesaronike hayo, haari ne enyuumba ye esaango ya Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kyeego yaari enyaangi yaaye, Pauro akasikira munyuumba ye esaango. Kwo obhutuuro bhutatu bhwe eziisiku zyo okumuunya, akabha arabhabhuurira abhaatu amangʼana gano gari mu Makaamo Amahoreeru. ");
INSERT INTO zak_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Yaari aragakuundukura kubhweero no okubheerekya kubha, Masiya akeenderwa anyaakibhwe no okwiitwa, no okumara aryooke kurwa mubhaku. Pauro akabhabhuurira, “Masiya wuno nikubhabhuurira amangʼana gaaye niwe Yeesu.” ");
INSERT INTO zak_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Abhayahudi abhaandi bhakiikirirya amangʼana gano Pauro yaari aragaamba, hamwe na abhaatu bhano bhatari Abhayahudi bhano bhaamwiigwiiri Taatabhugya, na abhakari bhaaru bha amangʼeeni. Bhayo bhoosi bhakagwaatana na Pauro na Siira. ");
INSERT INTO zak_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nawe Abhayahudi abhaandi bhakagwaatwa no omugono. Kweego bhakagya kumuteera, bhakakumania abhaatu bhe eteemo embiihu. Abhaatu bhayo, bhakataanga kukora orwaambi rwaaru mumugye gwoosi. Bhakagya munyuumba ya Yasoni kubhakomya Pauro na Siira, okubha bhabhareete kusaango ya abhaatu bhayo. ");
INSERT INTO zak_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Hano bhaabhabhuriri, bhakamugega Yasoni omweene hamwe na abhiikirirya abharebhe. Bhakabhakurura tee embere ya abhakuru bho omugye, bharagaamba kwiiraka ikuru, “Abhaatu bhano nibho bhakukora orwaambi rwaaru mubhyaaro ebhiindi bhyoosi, na bhoono bhahikiri eno hoosi. ");
INSERT INTO zak_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Na Yasoni niwe akabhaginihya munyuumba yaaye. Na bhoosi bharazeera emigiro gino gituurirwe na Kaisari, na bhariiguungya kubha, bhano omutemi waabhu owuundi, eriina ryaaye ni Yeesu.” ");
INSERT INTO zak_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hano abhakuru na abhaatu abhaandi bho omugye guyo bhiigwiiri amangʼana gayo, bhakoongera okukora orwaambi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Hano abhakuru bhe ekyaaro bhaariiri enzagu ya Yasoni na abharikyaaye, kyaamwe bhakabhatiga bhagye zyaabhu. ");
INSERT INTO zak_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Hano bhwaabheeri obhutiku, abhiikirirya bhakabhaheregesya Pauro na Siira bhakagya mumugye gwa Beroya. Hano bhaahikiri Beroya, bhakasikira munyuumba ye esaango ya Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abhayahudi bhano bha Beroya bhaari abhaatu bhe eteemo nzomu kukira Tesaronike. Kweego bhakamwiitegeerera kisi Pauro hano yaakubharwaazira engʼana ya Taatabhugya, bhakiigoomba okuyiitegeerera. Bhakabha bhariisuunza mu Makaamo Amahoreeru eziisiku zyoosi, okubha bhamenyeekererye eraabhe amangʼana gayo gaari garagaambwa na Pauro na Siira ni maheene na niigo gari. ");
INSERT INTO zak_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Abhayahudi bhaaru gati waabhu bhakamwiikirirya Yeesu, hamwe na Abhayunaani, abhasubhe na abhakari bhano bhaari bhakusuukwa. ");
INSERT INTO zak_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Abhayahudi bhayo bha Tesaronike, hano bhaamenyiri kubha Pauro areegya engʼana ya Taatabhugya eyo Beroya, bhakagyayo. Bhakasiigirirya esaango ya abhaatu bhano bhaari hayo, tee bhakabha no orwaambi rwaaru. ");
INSERT INTO zak_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Abhiikirirya bharya bhakamuheregesya Pauro, bhakamuhira tee kurungʼoongo rwe enyaanza. Nawe Siira na Timoteo ebho bhakasaaga Beroya hayo. ");
INSERT INTO zak_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Na bhano bhaamuheregesirye Pauro bhakamuhikya tee mumugye gwa Atene. Hano bhaari bharakyoora, akabharagirirya kubha bhabhabhuurire Siira na Timoteo bhamutuniirire bhwaangu. ");
INSERT INTO zak_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Hano Pauro yaari akubhaganya Siira na Timoteo mumugye gwa Atene hayo, akabha aranyahaarwa bhukongʼu kwo okurora omugye guyo gwoosi gwiizwiiri emisaambwa gyo okubhaazwa. ");
INSERT INTO zak_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kweego, akabha aragya munyuumba ye esaango kubhuurania na Abhayahudi na bhano bhatari Abhayahudi bhano bhakumwiigwa Taatabhugya. Kweeki yaari areegya abhaatu kumuteera, na bhano yaari akusikana nabho. ");
INSERT INTO zak_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ambe, Pauro akabha arasikana na abhasomi abharebhe bhe esaango ya Abheepikurio na Abhasitoiko, kyaamwe bhakataanga kuhakana neewe. Abhaandi bhakabhuga, “Omubharuki wuno, areenda kugaambaki?” Abhaandi bharabhuga, “Erarorekana kubha, ararwaaza iguru we emisaambwa gye ekigini.” Bhakabhuga ego, kwo okubha akarwaaza iguru wa Yeesu no okuryooka kwa abhaku. ");
INSERT INTO zak_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bhakamugwaata Pauro, bhakamuhira embere we ekiina ekikuru kino kikubhirikirwa Areopago. Abhakuru bhe ekiina kiyo bhakamubhuurya, “Oratura kutubhuurira obhugazuro bhwa ameegyo amahya gayo okubhabhuurira abhaatu? ");
INSERT INTO zak_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Awe oratureetera amangʼana amahya, kweego tureenda tumenye obhugazuro bhwago.” ");
INSERT INTO zak_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Gano goosi ni kwo okubha abhiibhurwa bha Atene na abhagini abhaandi bhano bhaari kwiikara muyo, kwiibhaga riyo ryoosi bhataakoriri ngʼana yoyoosi okuruusyaku okwiitegeerera no okukeerenerya amangʼana amahya. ");
INSERT INTO zak_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Okumara Pauro akiimeerera embere we esaango ya Areopago, akabhuga, “Emwe abhiikari bha Atene! Niruuzi kubha emwe ni bhaatu bhano museegiri amangʼana ge enyaangi bhukongʼu. ");
INSERT INTO zak_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Hano niari ndahita mumugye gweenyu, nikarora ebhigiro bhyeenyu bhyo okuseengera. Nikarora ahagiro ho okuruusirya ekimweeso hano hakaamirwe amangʼana gano, Ku Taatabhugya wuno atamenyekeeni. Ambe, Taatabhugya wuno mukuseengera eno mutamumenyiri, niwe nikubharwaazira reero. ");
INSERT INTO zak_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Taatabhugya wuyo ni Muteemi we ekyaaro ne ebhigiro bhyoosi bhino bhirimu, kwo okubha ewe atakwiikara muziinyuumba zino zoombokirwe na abhaatu. ");
INSERT INTO zak_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ewe atakweenda kukorerwa ekigiro kyokyoosi na abhaatu, kwo okubha ewe niwe akubhaha bhoosi obhuhoru no omwiika ne ebhigiro bhyoosi. ");
INSERT INTO zak_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","No okurweera kumuutu wumwe, niho yaruusirye abhaatu bhe ebhigaambo bhyoosi, na bhiikare mukyaaro kyoosi. Akabhatuurira ne eriibhaga ryo okwiikara kweemera ekare, akabhatinira eziimiimbi zya ahagiro hano bhakweenderwa bhiikare. ");
INSERT INTO zak_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Taatabhugya akakora ego, okubha abhaatu bhamukomye, naabhe kwo okubhabhaata bhamurore. Nawe, Taatabhugya atari kure neetwe twoosi. ");
INSERT INTO zak_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kwo obhunagya bhwaaye tureho, turakora na turageenderera. Ni kya abhakaami bha ameembo geenyu bhakabhuga, ‘Etwe ni bhaana bhaaye.’ ");
INSERT INTO zak_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ambe, kwo okubha etwe ni bhaana bha Taatabhugya, tutiiseega kubha atuubheeni ne emisaambwa gino gikorirwe kwe ezahaabu, eziimbirya, naabhe emisaambwa gino gibhaazirwe kumagina. Gayo goosi garakorwa kwo obhutuguukurya na amangʼeeni ga abhaatu. ");
INSERT INTO zak_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ekare hayo, hano abhaatu bhaari bharakora gayo kwo obhugeege, Taatabhugya yaari ariikora kubha atakugarora. Nawe bhoono, arabhabhuurira abhaatu bhoosi bha ahagiro hoosi kubha bhate ebhibhi, ");
INSERT INTO zak_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","kwo okubha amariri kutuura orusiku runo araabhatinire ekiina abhaatu bhoosi kwe eheene, kwe enzira yo omuutu wumwe akamutaaho kumirimo giyo. Ewe atweerekirye obhuheene bhwa amangʼana gayo kwo okumuryoorya omuutu wuyo kurwa mubhaku.” ");
INSERT INTO zak_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hano abhakuru bhayo bhiigwiiri kubha Pauro aragaamba iguru wo okuryooka kwa abhaku, abhamwe bhaabhu bhakamuzeera, nawe abhaandi bhakabhuga, “Tureenda okukwiitegeerera orusiku oruundi kweeki iguru wa amangʼana gayo.” ");
INSERT INTO zak_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kweego, Pauro akahuruka mukiina kya abhakuru kiyo. ");
INSERT INTO zak_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nawe abhaatu abhaandi bhakiikirirya, bhakagwaatana na Pauro. Gati waabhu bhaari Dionisio, owumwe we ekiina kya Abhaareopago no omukari wumwe eriina yaaye ni Damaari, hamwe na abhaatu abhaandi. ");
INSERT INTO zak_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hano amangʼana gayo gahwiiri, Pauro akatanura kurwa Atene hayo, akagya mumugye gwa Koriinto. ");
INSERT INTO zak_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Akasikana no Omuyahudi wumwe, eriina ryaaye ni Akiira, omwiibhurwa wa Poonto. Akiira hamwe no omukari waaye Prisika, bhaari bhararwa mumugye gwa Rooma mukyaaro kya Itaria. Bhakarwa eyo kwo okubha Kaisari Kiraudio yaari aswaagirye kubha Abhayahudi bhoosi bharwe mumugye muyo. Kweego Pauro akagya kukeerya Akiira no omukari waaye. ");
INSERT INTO zak_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Na kwo okubha Pauro ewe yaari arakora emirimo gyo okutuma amatuundubhaari kye ebho, akiikara owaabhu bhakabha bharakora emirimo giyo kwa hamwe. ");
INSERT INTO zak_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Eziisiku zyoosi zyo okumuunya, Pauro yaari arasikira munyuumba ye esaango ya Abhayahudi, akabha arabharwaazira Amangʼana Amazomu ga Yeesu. Yaari arasakya kukorokoomba Abhayahudi na abhaatu bhano bhatari Abhayahudi. ");
INSERT INTO zak_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Hano Siira na Timoteo bhaahikiri hayo okurwa Makedonia, Pauro akaruusya eriibhaga ryaaye ryoosi areegya engʼana ya Taatabhugya ku Abhayahudi kwo okubhakumiirirya kubha, Yeesu niwe Masiya. ");
INSERT INTO zak_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nawe Abhayahudi bhayo bhakataanga kumuhakania no okumutuka. Amangʼana gayo gakagirya akabhakungʼuutira oruteeri runo rwaari rugiiri kumyeenda gyaaye, na akabhabhuurira, “Amanyiinga geenyu gabhe iguru weenyu abheene! Enye, nitana engʼana yino nimusariirye. Kweema bhoono, nirabha niragya mubhaatu bhano bhatari Abhayahudi.” ");
INSERT INTO zak_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kyaamwe Pauro akahuruka kurwa munyuumba ye esaango, akasikira munyuumba yino yaari embarika waaye. Enyuumba yiyo yaari ya Tito Yusito, omuutu wuno yaari akumuseengera Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Omukaangati we enyuumba ye esaango yiyo, eriina ryaaye Kirisipo, woosi akamwiikirirya Omukuru Yeesu, hamwe na abhaatu bhoosi munyuumba yaaye. Abhakoriinto abhaandi bhaaru bhano bhakiigwa amangʼana ga Pauro, nabho bhakiikirirya, bhakabatiizwa. ");
INSERT INTO zak_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Orusiku rumwe obhutiku, Omukuru akamubhuurira Pauro mubhurori, “Otoobhoha, ogeenderere ego kurwaaza, otakira. ");
INSERT INTO zak_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Enye niri hamwe na naawe, na atariho omuutu wuyo woosi wuno araakunyahaare no okukora kibhi, kwo okubha abhaatu bhaaru bha mumugye muno bharaaza kuniikyoorera.” ");
INSERT INTO zak_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pauro akiikara Koriinto hayo, kwa mwaaka gumwe ne emyeeri esaasabha, areegya abhaatu engʼana ya Taatabhugya. ");
INSERT INTO zak_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Hano Gario yaari omwaanaangwa we ekyaaro kya Akaaya, Abhayahudi bhoosi kwa hamwe bhakamutuumira Pauro. Bhakamureeta embere we ekituumbi kyo okutinira ekiina, ");
INSERT INTO zak_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","no okumuzoongera kwo okubhuga, “Omuutu wuno arabhuurira abhaatu bhabhe bharamuseengera Taatabhugya kwe enzira eyiindi yino etakweenderwa ne emigiro gyeetu.” ");
INSERT INTO zak_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Hano Pauro yeendiri kugaamba iguru waaye, Gario akabhabhuurira Abhayahudi bhayo, “Emwe Abhayahudi, yiingabheeri mumuzoongeeri omuutu wuno iguru yo okusarya emigiro gye Ekirooma, niho ningabhiitegeereeri. ");
INSERT INTO zak_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nawe kwo okurora haka ezyeene iguru wa amangʼana, amariina ne emigiro gyeenyu, mugamare emwe abheene. Enye nitakweenda kubha omutaania wa amangʼana gano.” ");
INSERT INTO zak_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Niho Gario akaswaagya kubha bhaheebhwe okurwa mwiibaraza. ");
INSERT INTO zak_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Neebho bhoosi bhakamugwaata Sositenesi wuno yaari omukaangati we enyuumba ye esaango, bhakamutemera haryaharya mwiibaraza. Nawe Gario ataagiiri nago mitwe naabhe hasuuhu. ");
INSERT INTO zak_vpl VALUES ("AC18_18","074_18_18","